/** @file
 * VirtualBox API class wrapper code for IPCIDeviceAttachment.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PCIDEVICEATTACHMENT

#include "PCIDeviceAttachmentWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PCIDeviceAttachmentWrap)

//
// IPCIDeviceAttachment properties
//

STDMETHODIMP PCIDeviceAttachmentWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "PCIDeviceAttachment::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "PCIDeviceAttachment::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP PCIDeviceAttachmentWrap::COMGETTER(IsPhysicalDevice)(BOOL *aIsPhysicalDevice)
{
    LogRelFlow(("{%p} %s: enter aIsPhysicalDevice=%p\n", this, "PCIDeviceAttachment::getIsPhysicalDevice", aIsPhysicalDevice));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIsPhysicalDevice);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_ISPHYSICALDEVICE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIsPhysicalDevice(aIsPhysicalDevice);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_ISPHYSICALDEVICE_RETURN(this, hrc, 0 /*normal*/,*aIsPhysicalDevice != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_ISPHYSICALDEVICE_RETURN(this, hrc, 1 /*hrc exception*/,*aIsPhysicalDevice != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_ISPHYSICALDEVICE_RETURN(this, hrc, 9 /*unhandled exception*/,*aIsPhysicalDevice != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIsPhysicalDevice=%RTbool hrc=%Rhrc\n", this, "PCIDeviceAttachment::getIsPhysicalDevice", *aIsPhysicalDevice, hrc));
    return hrc;
}

STDMETHODIMP PCIDeviceAttachmentWrap::COMGETTER(HostAddress)(LONG *aHostAddress)
{
    LogRelFlow(("{%p} %s: enter aHostAddress=%p\n", this, "PCIDeviceAttachment::getHostAddress", aHostAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHostAddress);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_HOSTADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getHostAddress(aHostAddress);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_HOSTADDRESS_RETURN(this, hrc, 0 /*normal*/,*aHostAddress);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_HOSTADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,*aHostAddress);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_HOSTADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,*aHostAddress);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aHostAddress=%RI32 hrc=%Rhrc\n", this, "PCIDeviceAttachment::getHostAddress", *aHostAddress, hrc));
    return hrc;
}

STDMETHODIMP PCIDeviceAttachmentWrap::COMGETTER(GuestAddress)(LONG *aGuestAddress)
{
    LogRelFlow(("{%p} %s: enter aGuestAddress=%p\n", this, "PCIDeviceAttachment::getGuestAddress", aGuestAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aGuestAddress);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_GUESTADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getGuestAddress(aGuestAddress);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_GUESTADDRESS_RETURN(this, hrc, 0 /*normal*/,*aGuestAddress);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_GUESTADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,*aGuestAddress);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PCIDEVICEATTACHMENT_GET_GUESTADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,*aGuestAddress);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aGuestAddress=%RI32 hrc=%Rhrc\n", this, "PCIDeviceAttachment::getGuestAddress", *aGuestAddress, hrc));
    return hrc;
}


//
// IPCIDeviceAttachment methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PCIDeviceAttachmentWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PCIDeviceAttachmentWrap, IPCIDeviceAttachment)
#endif // VBOX_WITH_XPCOM
