/** @file
 * VirtualBox API class wrapper code for IGuestFile.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTFILE

#include "GuestFileWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestFileWrap)

//
// IFile properties
//

STDMETHODIMP GuestFileWrap::COMGETTER(EventSource)(IEventSource **aEventSource)
{
    LogRelFlow(("{%p} %s: enter aEventSource=%p\n", this, "GuestFile::getEventSource", aEventSource));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEventSource);
        ComTypeOutConverter<IEventSource> TmpEventSource(aEventSource);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_EVENTSOURCE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEventSource(TmpEventSource.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_EVENTSOURCE_RETURN(this, hrc, 0 /*normal*/,(void *)TmpEventSource.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_EVENTSOURCE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_EVENTSOURCE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEventSource=%p hrc=%Rhrc\n", this, "GuestFile::getEventSource", *aEventSource, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(Id)(ULONG *aId)
{
    LogRelFlow(("{%p} %s: enter aId=%p\n", this, "GuestFile::getId", aId));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aId);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getId(aId);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ID_RETURN(this, hrc, 0 /*normal*/,*aId);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ID_RETURN(this, hrc, 1 /*hrc exception*/,*aId);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ID_RETURN(this, hrc, 9 /*unhandled exception*/,*aId);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aId=%RU32 hrc=%Rhrc\n", this, "GuestFile::getId", *aId, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InitialSize)(LONG64 *aInitialSize)
{
    LogRelFlow(("{%p} %s: enter aInitialSize=%p\n", this, "GuestFile::getInitialSize", aInitialSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aInitialSize);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_INITIALSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getInitialSize(aInitialSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_INITIALSIZE_RETURN(this, hrc, 0 /*normal*/,*aInitialSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_INITIALSIZE_RETURN(this, hrc, 1 /*hrc exception*/,*aInitialSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_INITIALSIZE_RETURN(this, hrc, 9 /*unhandled exception*/,*aInitialSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aInitialSize=%RI64 hrc=%Rhrc\n", this, "GuestFile::getInitialSize", *aInitialSize, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(Offset)(LONG64 *aOffset)
{
    LogRelFlow(("{%p} %s: enter aOffset=%p\n", this, "GuestFile::getOffset", aOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOffset);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OFFSET_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOffset(aOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OFFSET_RETURN(this, hrc, 0 /*normal*/,*aOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OFFSET_RETURN(this, hrc, 1 /*hrc exception*/,*aOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OFFSET_RETURN(this, hrc, 9 /*unhandled exception*/,*aOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOffset=%RI64 hrc=%Rhrc\n", this, "GuestFile::getOffset", *aOffset, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(Status)(FileStatus_T *aStatus)
{
    LogRelFlow(("{%p} %s: enter aStatus=%p\n", this, "GuestFile::getStatus", aStatus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStatus);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_STATUS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStatus(aStatus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_STATUS_RETURN(this, hrc, 0 /*normal*/,*aStatus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_STATUS_RETURN(this, hrc, 1 /*hrc exception*/,*aStatus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_STATUS_RETURN(this, hrc, 9 /*unhandled exception*/,*aStatus);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aStatus=%RU32 hrc=%Rhrc\n", this, "GuestFile::getStatus", *aStatus, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(Filename)(BSTR *aFilename)
{
    LogRelFlow(("{%p} %s: enter aFilename=%p\n", this, "GuestFile::getFilename", aFilename));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFilename);
        BSTROutConverter TmpFilename(aFilename);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_FILENAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFilename(TmpFilename.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_FILENAME_RETURN(this, hrc, 0 /*normal*/,TmpFilename.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_FILENAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_FILENAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFilename=%ls hrc=%Rhrc\n", this, "GuestFile::getFilename", *aFilename, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(CreationMode)(ULONG *aCreationMode)
{
    LogRelFlow(("{%p} %s: enter aCreationMode=%p\n", this, "GuestFile::getCreationMode", aCreationMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCreationMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_CREATIONMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCreationMode(aCreationMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_CREATIONMODE_RETURN(this, hrc, 0 /*normal*/,*aCreationMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_CREATIONMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aCreationMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_CREATIONMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aCreationMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCreationMode=%RU32 hrc=%Rhrc\n", this, "GuestFile::getCreationMode", *aCreationMode, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(OpenAction)(FileOpenAction_T *aOpenAction)
{
    LogRelFlow(("{%p} %s: enter aOpenAction=%p\n", this, "GuestFile::getOpenAction", aOpenAction));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aOpenAction);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OPENACTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getOpenAction(aOpenAction);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OPENACTION_RETURN(this, hrc, 0 /*normal*/,*aOpenAction);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OPENACTION_RETURN(this, hrc, 1 /*hrc exception*/,*aOpenAction);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_OPENACTION_RETURN(this, hrc, 9 /*unhandled exception*/,*aOpenAction);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aOpenAction=%RU32 hrc=%Rhrc\n", this, "GuestFile::getOpenAction", *aOpenAction, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(AccessMode)(FileAccessMode_T *aAccessMode)
{
    LogRelFlow(("{%p} %s: enter aAccessMode=%p\n", this, "GuestFile::getAccessMode", aAccessMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aAccessMode);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ACCESSMODE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getAccessMode(aAccessMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ACCESSMODE_RETURN(this, hrc, 0 /*normal*/,*aAccessMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ACCESSMODE_RETURN(this, hrc, 1 /*hrc exception*/,*aAccessMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_GET_ACCESSMODE_RETURN(this, hrc, 9 /*unhandled exception*/,*aAccessMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aAccessMode=%RU32 hrc=%Rhrc\n", this, "GuestFile::getAccessMode", *aAccessMode, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute1IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute2IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute3IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute4IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute5IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute6IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute7IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::COMGETTER(InternalAndReservedAttribute8IFile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IGuestFile properties
//

STDMETHODIMP GuestFileWrap::COMGETTER(MidlDoesNotLikeEmptyInterfaces)(BOOL *aMidlDoesNotLikeEmptyInterfaces)
{
#if 0 /* This is a dummy attribute */
    LogRelFlow(("{%p} %s: enter aMidlDoesNotLikeEmptyInterfaces=%p\n", this, "GuestFile::getMidlDoesNotLikeEmptyInterfaces", aMidlDoesNotLikeEmptyInterfaces));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMidlDoesNotLikeEmptyInterfaces);
        
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMidlDoesNotLikeEmptyInterfaces(aMidlDoesNotLikeEmptyInterfaces);
        }
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
    }

    LogRelFlow(("{%p} %s: leave *aMidlDoesNotLikeEmptyInterfaces=%RTbool hrc=%Rhrc\n", this, "GuestFile::getMidlDoesNotLikeEmptyInterfaces", *aMidlDoesNotLikeEmptyInterfaces, hrc));
    return hrc;
#else  /* dummy attribute */
    NOREF(aMidlDoesNotLikeEmptyInterfaces);
    return E_FAIL;
#endif /* dummy attribute */
}


//
// IFile methods
//

STDMETHODIMP GuestFileWrap::Close()
{
    LogRelFlow(("{%p} %s: enter\n", this, "GuestFile::close"));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {



#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_CLOSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = close();
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_CLOSE_RETURN(this, hrc, 0 /*normal*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_CLOSE_RETURN(this, hrc, 1 /*hrc exception*/);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_CLOSE_RETURN(this, hrc, 9 /*unhandled exception*/);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestFile::close", hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::QueryInfo(IFsObjInfo **aObjInfo)
{
    LogRelFlow(("{%p} %s: enter aObjInfo=%p\n", this, "GuestFile::queryInfo", aObjInfo));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aObjInfo);


        ComTypeOutConverter<IFsObjInfo> TmpObjInfo(aObjInfo);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYINFO_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryInfo(TmpObjInfo.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYINFO_RETURN(this, hrc, 0 /*normal*/, (void *)TmpObjInfo.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYINFO_RETURN(this, hrc, 1 /*hrc exception*/, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYINFO_RETURN(this, hrc, 9 /*unhandled exception*/, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aObjInfo=%p hrc=%Rhrc\n", this, "GuestFile::queryInfo", *aObjInfo, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::QuerySize(LONG64 *aSize)
{
    LogRelFlow(("{%p} %s: enter aSize=%p\n", this, "GuestFile::querySize", aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSize);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYSIZE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = querySize(aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYSIZE_RETURN(this, hrc, 0 /*normal*/, *aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYSIZE_RETURN(this, hrc, 1 /*hrc exception*/, *aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_QUERYSIZE_RETURN(this, hrc, 9 /*unhandled exception*/, *aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSize=%RI64 hrc=%Rhrc\n", this, "GuestFile::querySize", *aSize, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::Read(ULONG aToRead,
                                 ULONG aTimeoutMS,
                                 ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aToRead=%RU32 aTimeoutMS=%RU32 aData=%p\n", this, "GuestFile::read", aToRead, aTimeoutMS, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READ_ENTER(this, aToRead, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = read(aToRead,
                       aTimeoutMS,
                       TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READ_RETURN(this, hrc, 0 /*normal*/, aToRead, aTimeoutMS, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READ_RETURN(this, hrc, 1 /*hrc exception*/, aToRead, aTimeoutMS, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READ_RETURN(this, hrc, 9 /*unhandled exception*/, aToRead, aTimeoutMS, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "GuestFile::read", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::ReadAt(LONG64 aOffset,
                                   ULONG aToRead,
                                   ULONG aTimeoutMS,
                                   ComSafeArrayOut(BYTE, aData))
{
    LogRelFlow(("{%p} %s: enter aOffset=%RI64 aToRead=%RU32 aTimeoutMS=%RU32 aData=%p\n", this, "GuestFile::readAt", aOffset, aToRead, aTimeoutMS, aData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aData);


        
        
        
        ArrayOutConverter<BYTE> TmpData(ComSafeArrayOutArg(aData));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READAT_ENTER(this, aOffset, aToRead, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = readAt(aOffset,
                         aToRead,
                         aTimeoutMS,
                         TmpData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READAT_RETURN(this, hrc, 0 /*normal*/, aOffset, aToRead, aTimeoutMS, (uint32_t)TmpData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READAT_RETURN(this, hrc, 1 /*hrc exception*/, aOffset, aToRead, aTimeoutMS, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_READAT_RETURN(this, hrc, 9 /*unhandled exception*/, aOffset, aToRead, aTimeoutMS, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aData=%zu hrc=%Rhrc\n", this, "GuestFile::readAt", ComSafeArraySize(*aData), hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::Seek(LONG64 aOffset,
                                 FileSeekOrigin_T aWhence,
                                 LONG64 *aNewOffset)
{
    LogRelFlow(("{%p} %s: enter aOffset=%RI64 aWhence=%RU32 aNewOffset=%p\n", this, "GuestFile::seek", aOffset, aWhence, aNewOffset));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aNewOffset);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SEEK_ENTER(this, aOffset, aWhence);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = seek(aOffset,
                       aWhence,
                       aNewOffset);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SEEK_RETURN(this, hrc, 0 /*normal*/, aOffset, aWhence, *aNewOffset);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SEEK_RETURN(this, hrc, 1 /*hrc exception*/, aOffset, aWhence, *aNewOffset);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SEEK_RETURN(this, hrc, 9 /*unhandled exception*/, aOffset, aWhence, *aNewOffset);
#endif
    }

    LogRelFlow(("{%p} %s: leave aNewOffset=%RI64 hrc=%Rhrc\n", this, "GuestFile::seek", *aNewOffset, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::SetACL(IN_BSTR aAcl,
                                   ULONG aMode)
{
    LogRelFlow(("{%p} %s: enter aAcl=%ls aMode=%RU32\n", this, "GuestFile::setACL", aAcl, aMode));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        BSTRInConverter TmpAcl(aAcl);
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETACL_ENTER(this, TmpAcl.str().c_str(), aMode);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setACL(TmpAcl.str(),
                         aMode);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETACL_RETURN(this, hrc, 0 /*normal*/, TmpAcl.str().c_str(), aMode);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETACL_RETURN(this, hrc, 1 /*hrc exception*/, 0, aMode);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETACL_RETURN(this, hrc, 9 /*unhandled exception*/, 0, aMode);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestFile::setACL", hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::SetSize(LONG64 aSize)
{
    LogRelFlow(("{%p} %s: enter aSize=%RI64\n", this, "GuestFile::setSize", aSize));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETSIZE_ENTER(this, aSize);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setSize(aSize);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETSIZE_RETURN(this, hrc, 0 /*normal*/, aSize);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETSIZE_RETURN(this, hrc, 1 /*hrc exception*/, aSize);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_SETSIZE_RETURN(this, hrc, 9 /*unhandled exception*/, aSize);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestFile::setSize", hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::Write(ComSafeArrayIn(BYTE, aData),
                                  ULONG aTimeoutMS,
                                  ULONG *aWritten)
{
    LogRelFlow(("{%p} %s: enter aData=%zu aTimeoutMS=%RU32 aWritten=%p\n", this, "GuestFile::write", aData, aTimeoutMS, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITE_ENTER(this, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = write(TmpData.array(),
                        aTimeoutMS,
                        aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITE_RETURN(this, hrc, 0 /*normal*/, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, aTimeoutMS, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, aTimeoutMS, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "GuestFile::write", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::WriteAt(LONG64 aOffset,
                                    ComSafeArrayIn(BYTE, aData),
                                    ULONG aTimeoutMS,
                                    ULONG *aWritten)
{
    LogRelFlow(("{%p} %s: enter aOffset=%RI64 aData=%zu aTimeoutMS=%RU32 aWritten=%p\n", this, "GuestFile::writeAt", aOffset, aData, aTimeoutMS, aWritten));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWritten);


        
        ArrayInConverter<BYTE> TmpData(ComSafeArrayInArg(aData));
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITEAT_ENTER(this, aOffset, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = writeAt(aOffset,
                          TmpData.array(),
                          aTimeoutMS,
                          aWritten);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITEAT_RETURN(this, hrc, 0 /*normal*/, aOffset, (uint32_t)TmpData.array().size(), NULL /*for now*/, aTimeoutMS, *aWritten);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITEAT_RETURN(this, hrc, 1 /*hrc exception*/, aOffset, 0, 0, aTimeoutMS, *aWritten);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTFILE_WRITEAT_RETURN(this, hrc, 9 /*unhandled exception*/, aOffset, 0, 0, aTimeoutMS, *aWritten);
#endif
    }

    LogRelFlow(("{%p} %s: leave aWritten=%RU32 hrc=%Rhrc\n", this, "GuestFile::writeAt", *aWritten, hrc));
    return hrc;
}

STDMETHODIMP GuestFileWrap::InternalAndReservedMethod1IFile()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::InternalAndReservedMethod2IFile()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::InternalAndReservedMethod3IFile()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestFileWrap::InternalAndReservedMethod4IFile()
{
    return E_NOTIMPL;
}

//
// IGuestFile methods
//

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestFileWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(GuestFileWrap, IGuestFile, IFile)
#endif // VBOX_WITH_XPCOM
