/** @file
 * VirtualBox API class wrapper code for IGuestDebugControl.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_GUESTDEBUGCONTROL

#include "GuestDebugControlWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(GuestDebugControlWrap)

//
// IGuestDebugControl properties
//

STDMETHODIMP GuestDebugControlWrap::COMGETTER(DebugProvider)(GuestDebugProvider_T *aDebugProvider)
{
    LogRelFlow(("{%p} %s: enter aDebugProvider=%p\n", this, "GuestDebugControl::getDebugProvider", aDebugProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDebugProvider);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPROVIDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDebugProvider(aDebugProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPROVIDER_RETURN(this, hrc, 0 /*normal*/,*aDebugProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,*aDebugProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,*aDebugProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDebugProvider=%RU32 hrc=%Rhrc\n", this, "GuestDebugControl::getDebugProvider", *aDebugProvider, hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMSETTER(DebugProvider)(GuestDebugProvider_T aDebugProvider)
{
    LogRelFlow(("{%p} %s: enter aDebugProvider=%RU32\n", this, "GuestDebugControl::setDebugProvider", aDebugProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPROVIDER_ENTER(this, aDebugProvider);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDebugProvider(aDebugProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPROVIDER_RETURN(this, hrc, 0 /*normal*/,aDebugProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,aDebugProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,aDebugProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDebugControl::setDebugProvider", hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMGETTER(DebugIoProvider)(GuestDebugIoProvider_T *aDebugIoProvider)
{
    LogRelFlow(("{%p} %s: enter aDebugIoProvider=%p\n", this, "GuestDebugControl::getDebugIoProvider", aDebugIoProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDebugIoProvider);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGIOPROVIDER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDebugIoProvider(aDebugIoProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGIOPROVIDER_RETURN(this, hrc, 0 /*normal*/,*aDebugIoProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGIOPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,*aDebugIoProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGIOPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,*aDebugIoProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDebugIoProvider=%RU32 hrc=%Rhrc\n", this, "GuestDebugControl::getDebugIoProvider", *aDebugIoProvider, hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMSETTER(DebugIoProvider)(GuestDebugIoProvider_T aDebugIoProvider)
{
    LogRelFlow(("{%p} %s: enter aDebugIoProvider=%RU32\n", this, "GuestDebugControl::setDebugIoProvider", aDebugIoProvider));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGIOPROVIDER_ENTER(this, aDebugIoProvider);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDebugIoProvider(aDebugIoProvider);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGIOPROVIDER_RETURN(this, hrc, 0 /*normal*/,aDebugIoProvider);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGIOPROVIDER_RETURN(this, hrc, 1 /*hrc exception*/,aDebugIoProvider);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGIOPROVIDER_RETURN(this, hrc, 9 /*unhandled exception*/,aDebugIoProvider);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDebugControl::setDebugIoProvider", hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMGETTER(DebugAddress)(BSTR *aDebugAddress)
{
    LogRelFlow(("{%p} %s: enter aDebugAddress=%p\n", this, "GuestDebugControl::getDebugAddress", aDebugAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDebugAddress);
        BSTROutConverter TmpDebugAddress(aDebugAddress);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGADDRESS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDebugAddress(TmpDebugAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpDebugAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDebugAddress=%ls hrc=%Rhrc\n", this, "GuestDebugControl::getDebugAddress", *aDebugAddress, hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMSETTER(DebugAddress)(IN_BSTR aDebugAddress)
{
    LogRelFlow(("{%p} %s: enter aDebugAddress=%ls\n", this, "GuestDebugControl::setDebugAddress", aDebugAddress));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        BSTRInConverter TmpDebugAddress(aDebugAddress);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGADDRESS_ENTER(this, TmpDebugAddress.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDebugAddress(TmpDebugAddress.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGADDRESS_RETURN(this, hrc, 0 /*normal*/,TmpDebugAddress.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGADDRESS_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGADDRESS_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDebugControl::setDebugAddress", hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMGETTER(DebugPort)(ULONG *aDebugPort)
{
    LogRelFlow(("{%p} %s: enter aDebugPort=%p\n", this, "GuestDebugControl::getDebugPort", aDebugPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDebugPort);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPORT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDebugPort(aDebugPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPORT_RETURN(this, hrc, 0 /*normal*/,*aDebugPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPORT_RETURN(this, hrc, 1 /*hrc exception*/,*aDebugPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_GET_DEBUGPORT_RETURN(this, hrc, 9 /*unhandled exception*/,*aDebugPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDebugPort=%RU32 hrc=%Rhrc\n", this, "GuestDebugControl::getDebugPort", *aDebugPort, hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMSETTER(DebugPort)(ULONG aDebugPort)
{
    LogRelFlow(("{%p} %s: enter aDebugPort=%RU32\n", this, "GuestDebugControl::setDebugPort", aDebugPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPORT_ENTER(this, aDebugPort);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setDebugPort(aDebugPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPORT_RETURN(this, hrc, 0 /*normal*/,aDebugPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPORT_RETURN(this, hrc, 1 /*hrc exception*/,aDebugPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_GUESTDEBUGCONTROL_SET_DEBUGPORT_RETURN(this, hrc, 9 /*unhandled exception*/,aDebugPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "GuestDebugControl::setDebugPort", hrc));
    return hrc;
}

STDMETHODIMP GuestDebugControlWrap::COMGETTER(InternalAndReservedAttribute1IGuestDebugControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP GuestDebugControlWrap::COMGETTER(InternalAndReservedAttribute2IGuestDebugControl)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IGuestDebugControl methods
//

STDMETHODIMP GuestDebugControlWrap::InternalAndReservedMethod1IGuestDebugControl()
{
    return E_NOTIMPL;
}

STDMETHODIMP GuestDebugControlWrap::InternalAndReservedMethod2IGuestDebugControl()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(GuestDebugControlWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(GuestDebugControlWrap, IGuestDebugControl)
#endif // VBOX_WITH_XPCOM
