/** @file
 * VirtualBox API class wrapper code for IExtPack.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_EXTPACK

#include "ExtPackWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(ExtPackWrap)

//
// IExtPackBase properties
//

STDMETHODIMP ExtPackWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "ExtPack::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "ExtPack::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(Description)(BSTR *aDescription)
{
    LogRelFlow(("{%p} %s: enter aDescription=%p\n", this, "ExtPack::getDescription", aDescription));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDescription);
        BSTROutConverter TmpDescription(aDescription);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_DESCRIPTION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDescription(TmpDescription.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_DESCRIPTION_RETURN(this, hrc, 0 /*normal*/,TmpDescription.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_DESCRIPTION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_DESCRIPTION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aDescription=%ls hrc=%Rhrc\n", this, "ExtPack::getDescription", *aDescription, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(Version)(BSTR *aVersion)
{
    LogRelFlow(("{%p} %s: enter aVersion=%p\n", this, "ExtPack::getVersion", aVersion));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersion);
        BSTROutConverter TmpVersion(aVersion);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VERSION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersion(TmpVersion.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VERSION_RETURN(this, hrc, 0 /*normal*/,TmpVersion.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VERSION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VERSION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersion=%ls hrc=%Rhrc\n", this, "ExtPack::getVersion", *aVersion, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(Revision)(ULONG *aRevision)
{
    LogRelFlow(("{%p} %s: enter aRevision=%p\n", this, "ExtPack::getRevision", aRevision));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRevision);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_REVISION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRevision(aRevision);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_REVISION_RETURN(this, hrc, 0 /*normal*/,*aRevision);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_REVISION_RETURN(this, hrc, 1 /*hrc exception*/,*aRevision);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_REVISION_RETURN(this, hrc, 9 /*unhandled exception*/,*aRevision);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRevision=%RU32 hrc=%Rhrc\n", this, "ExtPack::getRevision", *aRevision, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(Edition)(BSTR *aEdition)
{
    LogRelFlow(("{%p} %s: enter aEdition=%p\n", this, "ExtPack::getEdition", aEdition));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aEdition);
        BSTROutConverter TmpEdition(aEdition);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_EDITION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getEdition(TmpEdition.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_EDITION_RETURN(this, hrc, 0 /*normal*/,TmpEdition.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_EDITION_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_EDITION_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aEdition=%ls hrc=%Rhrc\n", this, "ExtPack::getEdition", *aEdition, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(VRDEModule)(BSTR *aVRDEModule)
{
    LogRelFlow(("{%p} %s: enter aVRDEModule=%p\n", this, "ExtPack::getVRDEModule", aVRDEModule));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVRDEModule);
        BSTROutConverter TmpVRDEModule(aVRDEModule);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VRDEMODULE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVRDEModule(TmpVRDEModule.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VRDEMODULE_RETURN(this, hrc, 0 /*normal*/,TmpVRDEModule.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VRDEMODULE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_VRDEMODULE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVRDEModule=%ls hrc=%Rhrc\n", this, "ExtPack::getVRDEModule", *aVRDEModule, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(CryptoModule)(BSTR *aCryptoModule)
{
    LogRelFlow(("{%p} %s: enter aCryptoModule=%p\n", this, "ExtPack::getCryptoModule", aCryptoModule));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCryptoModule);
        BSTROutConverter TmpCryptoModule(aCryptoModule);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_CRYPTOMODULE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCryptoModule(TmpCryptoModule.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_CRYPTOMODULE_RETURN(this, hrc, 0 /*normal*/,TmpCryptoModule.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_CRYPTOMODULE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_CRYPTOMODULE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCryptoModule=%ls hrc=%Rhrc\n", this, "ExtPack::getCryptoModule", *aCryptoModule, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(PlugIns)(ComSafeArrayOut(IExtPackPlugIn *, aPlugIns))
{
    LogRelFlow(("{%p} %s: enter aPlugIns=%p\n", this, "ExtPack::getPlugIns", aPlugIns));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPlugIns);
        ArrayComTypeOutConverter<IExtPackPlugIn> TmpPlugIns(ComSafeArrayOutArg(aPlugIns));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_PLUGINS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPlugIns(TmpPlugIns.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_PLUGINS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpPlugIns.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_PLUGINS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_PLUGINS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPlugIns=%zu hrc=%Rhrc\n", this, "ExtPack::getPlugIns", ComSafeArraySize(*aPlugIns), hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(Usable)(BOOL *aUsable)
{
    LogRelFlow(("{%p} %s: enter aUsable=%p\n", this, "ExtPack::getUsable", aUsable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aUsable);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_USABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getUsable(aUsable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_USABLE_RETURN(this, hrc, 0 /*normal*/,*aUsable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_USABLE_RETURN(this, hrc, 1 /*hrc exception*/,*aUsable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_USABLE_RETURN(this, hrc, 9 /*unhandled exception*/,*aUsable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aUsable=%RTbool hrc=%Rhrc\n", this, "ExtPack::getUsable", *aUsable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(WhyUnusable)(BSTR *aWhyUnusable)
{
    LogRelFlow(("{%p} %s: enter aWhyUnusable=%p\n", this, "ExtPack::getWhyUnusable", aWhyUnusable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aWhyUnusable);
        BSTROutConverter TmpWhyUnusable(aWhyUnusable);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_WHYUNUSABLE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getWhyUnusable(TmpWhyUnusable.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_WHYUNUSABLE_RETURN(this, hrc, 0 /*normal*/,TmpWhyUnusable.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_WHYUNUSABLE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_WHYUNUSABLE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aWhyUnusable=%ls hrc=%Rhrc\n", this, "ExtPack::getWhyUnusable", *aWhyUnusable, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(ShowLicense)(BOOL *aShowLicense)
{
    LogRelFlow(("{%p} %s: enter aShowLicense=%p\n", this, "ExtPack::getShowLicense", aShowLicense));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aShowLicense);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_SHOWLICENSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getShowLicense(aShowLicense);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_SHOWLICENSE_RETURN(this, hrc, 0 /*normal*/,*aShowLicense != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_SHOWLICENSE_RETURN(this, hrc, 1 /*hrc exception*/,*aShowLicense != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_SHOWLICENSE_RETURN(this, hrc, 9 /*unhandled exception*/,*aShowLicense != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aShowLicense=%RTbool hrc=%Rhrc\n", this, "ExtPack::getShowLicense", *aShowLicense, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(License)(BSTR *aLicense)
{
    LogRelFlow(("{%p} %s: enter aLicense=%p\n", this, "ExtPack::getLicense", aLicense));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLicense);
        BSTROutConverter TmpLicense(aLicense);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_LICENSE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getLicense(TmpLicense.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_LICENSE_RETURN(this, hrc, 0 /*normal*/,TmpLicense.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_LICENSE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_GET_LICENSE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aLicense=%ls hrc=%Rhrc\n", this, "ExtPack::getLicense", *aLicense, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute1IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute2IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute3IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute4IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute5IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute6IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute7IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::COMGETTER(InternalAndReservedAttribute8IExtPackBase)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

//
// IExtPack properties
//


//
// IExtPackBase methods
//

STDMETHODIMP ExtPackWrap::QueryLicense(IN_BSTR aPreferredLocale,
                                       IN_BSTR aPreferredLanguage,
                                       IN_BSTR aFormat,
                                       BSTR *aLicenseText)
{
    LogRelFlow(("{%p} %s: enter aPreferredLocale=%ls aPreferredLanguage=%ls aFormat=%ls aLicenseText=%p\n", this, "ExtPack::queryLicense", aPreferredLocale, aPreferredLanguage, aFormat, aLicenseText));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aLicenseText);


        BSTRInConverter TmpPreferredLocale(aPreferredLocale);
        BSTRInConverter TmpPreferredLanguage(aPreferredLanguage);
        BSTRInConverter TmpFormat(aFormat);
        BSTROutConverter TmpLicenseText(aLicenseText);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYLICENSE_ENTER(this, TmpPreferredLocale.str().c_str(), TmpPreferredLanguage.str().c_str(), TmpFormat.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryLicense(TmpPreferredLocale.str(),
                               TmpPreferredLanguage.str(),
                               TmpFormat.str(),
                               TmpLicenseText.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYLICENSE_RETURN(this, hrc, 0 /*normal*/, TmpPreferredLocale.str().c_str(), TmpPreferredLanguage.str().c_str(), TmpFormat.str().c_str(), TmpLicenseText.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYLICENSE_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYLICENSE_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aLicenseText=%ls hrc=%Rhrc\n", this, "ExtPack::queryLicense", *aLicenseText, hrc));
    return hrc;
}

STDMETHODIMP ExtPackWrap::InternalAndReservedMethod1IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::InternalAndReservedMethod2IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::InternalAndReservedMethod3IExtPackBase()
{
    return E_NOTIMPL;
}

STDMETHODIMP ExtPackWrap::InternalAndReservedMethod4IExtPackBase()
{
    return E_NOTIMPL;
}

//
// IExtPack methods
//

STDMETHODIMP ExtPackWrap::QueryObject(IN_BSTR aObjUuid,
                                      IUnknown **aReturnInterface)
{
    LogRelFlow(("{%p} %s: enter aObjUuid=%ls aReturnInterface=%p\n", this, "ExtPack::queryObject", aObjUuid, aReturnInterface));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aReturnInterface);


        BSTRInConverter TmpObjUuid(aObjUuid);
        ComTypeOutConverter<IUnknown> TmpReturnInterface(aReturnInterface);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYOBJECT_ENTER(this, TmpObjUuid.str().c_str());
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryObject(TmpObjUuid.str(),
                              TmpReturnInterface.ptr());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYOBJECT_RETURN(this, hrc, 0 /*normal*/, TmpObjUuid.str().c_str(), (void *)TmpReturnInterface.ptr());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYOBJECT_RETURN(this, hrc, 1 /*hrc exception*/, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_EXTPACK_QUERYOBJECT_RETURN(this, hrc, 9 /*unhandled exception*/, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aReturnInterface=%p hrc=%Rhrc\n", this, "ExtPack::queryObject", *aReturnInterface, hrc));
    return hrc;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(ExtPackWrap)
NS_IMPL_THREADSAFE_ISUPPORTS2_CI(ExtPackWrap, IExtPack, IExtPackBase)
#endif // VBOX_WITH_XPCOM
