/** @file
 * VirtualBox API class wrapper code for ICertificate.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_CERTIFICATE

#include "CertificateWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CertificateWrap)

//
// ICertificate properties
//

STDMETHODIMP CertificateWrap::COMGETTER(VersionNumber)(CertificateVersion_T *aVersionNumber)
{
    LogRelFlow(("{%p} %s: enter aVersionNumber=%p\n", this, "Certificate::getVersionNumber", aVersionNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aVersionNumber);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VERSIONNUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getVersionNumber(aVersionNumber);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VERSIONNUMBER_RETURN(this, hrc, 0 /*normal*/,*aVersionNumber);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VERSIONNUMBER_RETURN(this, hrc, 1 /*hrc exception*/,*aVersionNumber);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VERSIONNUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,*aVersionNumber);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aVersionNumber=%RU32 hrc=%Rhrc\n", this, "Certificate::getVersionNumber", *aVersionNumber, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SerialNumber)(BSTR *aSerialNumber)
{
    LogRelFlow(("{%p} %s: enter aSerialNumber=%p\n", this, "Certificate::getSerialNumber", aSerialNumber));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSerialNumber);
        BSTROutConverter TmpSerialNumber(aSerialNumber);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SERIALNUMBER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSerialNumber(TmpSerialNumber.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SERIALNUMBER_RETURN(this, hrc, 0 /*normal*/,TmpSerialNumber.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SERIALNUMBER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SERIALNUMBER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSerialNumber=%ls hrc=%Rhrc\n", this, "Certificate::getSerialNumber", *aSerialNumber, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SignatureAlgorithmOID)(BSTR *aSignatureAlgorithmOID)
{
    LogRelFlow(("{%p} %s: enter aSignatureAlgorithmOID=%p\n", this, "Certificate::getSignatureAlgorithmOID", aSignatureAlgorithmOID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSignatureAlgorithmOID);
        BSTROutConverter TmpSignatureAlgorithmOID(aSignatureAlgorithmOID);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMOID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSignatureAlgorithmOID(TmpSignatureAlgorithmOID.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMOID_RETURN(this, hrc, 0 /*normal*/,TmpSignatureAlgorithmOID.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMOID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMOID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSignatureAlgorithmOID=%ls hrc=%Rhrc\n", this, "Certificate::getSignatureAlgorithmOID", *aSignatureAlgorithmOID, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SignatureAlgorithmName)(BSTR *aSignatureAlgorithmName)
{
    LogRelFlow(("{%p} %s: enter aSignatureAlgorithmName=%p\n", this, "Certificate::getSignatureAlgorithmName", aSignatureAlgorithmName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSignatureAlgorithmName);
        BSTROutConverter TmpSignatureAlgorithmName(aSignatureAlgorithmName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSignatureAlgorithmName(TmpSignatureAlgorithmName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMNAME_RETURN(this, hrc, 0 /*normal*/,TmpSignatureAlgorithmName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SIGNATUREALGORITHMNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSignatureAlgorithmName=%ls hrc=%Rhrc\n", this, "Certificate::getSignatureAlgorithmName", *aSignatureAlgorithmName, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(IssuerName)(ComSafeArrayOut(BSTR, aIssuerName))
{
    LogRelFlow(("{%p} %s: enter aIssuerName=%p\n", this, "Certificate::getIssuerName", aIssuerName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIssuerName);
        ArrayBSTROutConverter TmpIssuerName(ComSafeArrayOutArg(aIssuerName));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIssuerName(TmpIssuerName.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERNAME_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpIssuerName.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERNAME_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIssuerName=%zu hrc=%Rhrc\n", this, "Certificate::getIssuerName", ComSafeArraySize(*aIssuerName), hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SubjectName)(ComSafeArrayOut(BSTR, aSubjectName))
{
    LogRelFlow(("{%p} %s: enter aSubjectName=%p\n", this, "Certificate::getSubjectName", aSubjectName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSubjectName);
        ArrayBSTROutConverter TmpSubjectName(ComSafeArrayOutArg(aSubjectName));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSubjectName(TmpSubjectName.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTNAME_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSubjectName.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTNAME_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSubjectName=%zu hrc=%Rhrc\n", this, "Certificate::getSubjectName", ComSafeArraySize(*aSubjectName), hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(FriendlyName)(BSTR *aFriendlyName)
{
    LogRelFlow(("{%p} %s: enter aFriendlyName=%p\n", this, "Certificate::getFriendlyName", aFriendlyName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFriendlyName);
        BSTROutConverter TmpFriendlyName(aFriendlyName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_FRIENDLYNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFriendlyName(TmpFriendlyName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_FRIENDLYNAME_RETURN(this, hrc, 0 /*normal*/,TmpFriendlyName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_FRIENDLYNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_FRIENDLYNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFriendlyName=%ls hrc=%Rhrc\n", this, "Certificate::getFriendlyName", *aFriendlyName, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(ValidityPeriodNotBefore)(BSTR *aValidityPeriodNotBefore)
{
    LogRelFlow(("{%p} %s: enter aValidityPeriodNotBefore=%p\n", this, "Certificate::getValidityPeriodNotBefore", aValidityPeriodNotBefore));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValidityPeriodNotBefore);
        BSTROutConverter TmpValidityPeriodNotBefore(aValidityPeriodNotBefore);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTBEFORE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValidityPeriodNotBefore(TmpValidityPeriodNotBefore.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTBEFORE_RETURN(this, hrc, 0 /*normal*/,TmpValidityPeriodNotBefore.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTBEFORE_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTBEFORE_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValidityPeriodNotBefore=%ls hrc=%Rhrc\n", this, "Certificate::getValidityPeriodNotBefore", *aValidityPeriodNotBefore, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(ValidityPeriodNotAfter)(BSTR *aValidityPeriodNotAfter)
{
    LogRelFlow(("{%p} %s: enter aValidityPeriodNotAfter=%p\n", this, "Certificate::getValidityPeriodNotAfter", aValidityPeriodNotAfter));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aValidityPeriodNotAfter);
        BSTROutConverter TmpValidityPeriodNotAfter(aValidityPeriodNotAfter);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTAFTER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getValidityPeriodNotAfter(TmpValidityPeriodNotAfter.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTAFTER_RETURN(this, hrc, 0 /*normal*/,TmpValidityPeriodNotAfter.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTAFTER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_VALIDITYPERIODNOTAFTER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aValidityPeriodNotAfter=%ls hrc=%Rhrc\n", this, "Certificate::getValidityPeriodNotAfter", *aValidityPeriodNotAfter, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(PublicKeyAlgorithmOID)(BSTR *aPublicKeyAlgorithmOID)
{
    LogRelFlow(("{%p} %s: enter aPublicKeyAlgorithmOID=%p\n", this, "Certificate::getPublicKeyAlgorithmOID", aPublicKeyAlgorithmOID));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPublicKeyAlgorithmOID);
        BSTROutConverter TmpPublicKeyAlgorithmOID(aPublicKeyAlgorithmOID);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHMOID_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPublicKeyAlgorithmOID(TmpPublicKeyAlgorithmOID.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHMOID_RETURN(this, hrc, 0 /*normal*/,TmpPublicKeyAlgorithmOID.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHMOID_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHMOID_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPublicKeyAlgorithmOID=%ls hrc=%Rhrc\n", this, "Certificate::getPublicKeyAlgorithmOID", *aPublicKeyAlgorithmOID, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(PublicKeyAlgorithm)(BSTR *aPublicKeyAlgorithm)
{
    LogRelFlow(("{%p} %s: enter aPublicKeyAlgorithm=%p\n", this, "Certificate::getPublicKeyAlgorithm", aPublicKeyAlgorithm));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aPublicKeyAlgorithm);
        BSTROutConverter TmpPublicKeyAlgorithm(aPublicKeyAlgorithm);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHM_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getPublicKeyAlgorithm(TmpPublicKeyAlgorithm.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHM_RETURN(this, hrc, 0 /*normal*/,TmpPublicKeyAlgorithm.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHM_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_PUBLICKEYALGORITHM_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aPublicKeyAlgorithm=%ls hrc=%Rhrc\n", this, "Certificate::getPublicKeyAlgorithm", *aPublicKeyAlgorithm, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SubjectPublicKey)(ComSafeArrayOut(BYTE, aSubjectPublicKey))
{
    LogRelFlow(("{%p} %s: enter aSubjectPublicKey=%p\n", this, "Certificate::getSubjectPublicKey", aSubjectPublicKey));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSubjectPublicKey);
        ArrayOutConverter<BYTE> TmpSubjectPublicKey(ComSafeArrayOutArg(aSubjectPublicKey));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTPUBLICKEY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSubjectPublicKey(TmpSubjectPublicKey.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTPUBLICKEY_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSubjectPublicKey.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTPUBLICKEY_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTPUBLICKEY_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSubjectPublicKey=%zu hrc=%Rhrc\n", this, "Certificate::getSubjectPublicKey", ComSafeArraySize(*aSubjectPublicKey), hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(IssuerUniqueIdentifier)(BSTR *aIssuerUniqueIdentifier)
{
    LogRelFlow(("{%p} %s: enter aIssuerUniqueIdentifier=%p\n", this, "Certificate::getIssuerUniqueIdentifier", aIssuerUniqueIdentifier));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aIssuerUniqueIdentifier);
        BSTROutConverter TmpIssuerUniqueIdentifier(aIssuerUniqueIdentifier);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERUNIQUEIDENTIFIER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getIssuerUniqueIdentifier(TmpIssuerUniqueIdentifier.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERUNIQUEIDENTIFIER_RETURN(this, hrc, 0 /*normal*/,TmpIssuerUniqueIdentifier.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERUNIQUEIDENTIFIER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_ISSUERUNIQUEIDENTIFIER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aIssuerUniqueIdentifier=%ls hrc=%Rhrc\n", this, "Certificate::getIssuerUniqueIdentifier", *aIssuerUniqueIdentifier, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SubjectUniqueIdentifier)(BSTR *aSubjectUniqueIdentifier)
{
    LogRelFlow(("{%p} %s: enter aSubjectUniqueIdentifier=%p\n", this, "Certificate::getSubjectUniqueIdentifier", aSubjectUniqueIdentifier));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSubjectUniqueIdentifier);
        BSTROutConverter TmpSubjectUniqueIdentifier(aSubjectUniqueIdentifier);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTUNIQUEIDENTIFIER_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSubjectUniqueIdentifier(TmpSubjectUniqueIdentifier.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTUNIQUEIDENTIFIER_RETURN(this, hrc, 0 /*normal*/,TmpSubjectUniqueIdentifier.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTUNIQUEIDENTIFIER_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SUBJECTUNIQUEIDENTIFIER_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSubjectUniqueIdentifier=%ls hrc=%Rhrc\n", this, "Certificate::getSubjectUniqueIdentifier", *aSubjectUniqueIdentifier, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(CertificateAuthority)(BOOL *aCertificateAuthority)
{
    LogRelFlow(("{%p} %s: enter aCertificateAuthority=%p\n", this, "Certificate::getCertificateAuthority", aCertificateAuthority));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aCertificateAuthority);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_CERTIFICATEAUTHORITY_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getCertificateAuthority(aCertificateAuthority);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_CERTIFICATEAUTHORITY_RETURN(this, hrc, 0 /*normal*/,*aCertificateAuthority != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_CERTIFICATEAUTHORITY_RETURN(this, hrc, 1 /*hrc exception*/,*aCertificateAuthority != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_CERTIFICATEAUTHORITY_RETURN(this, hrc, 9 /*unhandled exception*/,*aCertificateAuthority != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aCertificateAuthority=%RTbool hrc=%Rhrc\n", this, "Certificate::getCertificateAuthority", *aCertificateAuthority, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(KeyUsage)(ULONG *aKeyUsage)
{
    LogRelFlow(("{%p} %s: enter aKeyUsage=%p\n", this, "Certificate::getKeyUsage", aKeyUsage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aKeyUsage);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_KEYUSAGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getKeyUsage(aKeyUsage);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_KEYUSAGE_RETURN(this, hrc, 0 /*normal*/,*aKeyUsage);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_KEYUSAGE_RETURN(this, hrc, 1 /*hrc exception*/,*aKeyUsage);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_KEYUSAGE_RETURN(this, hrc, 9 /*unhandled exception*/,*aKeyUsage);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aKeyUsage=%RU32 hrc=%Rhrc\n", this, "Certificate::getKeyUsage", *aKeyUsage, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(ExtendedKeyUsage)(ComSafeArrayOut(BSTR, aExtendedKeyUsage))
{
    LogRelFlow(("{%p} %s: enter aExtendedKeyUsage=%p\n", this, "Certificate::getExtendedKeyUsage", aExtendedKeyUsage));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExtendedKeyUsage);
        ArrayBSTROutConverter TmpExtendedKeyUsage(ComSafeArrayOutArg(aExtendedKeyUsage));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXTENDEDKEYUSAGE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExtendedKeyUsage(TmpExtendedKeyUsage.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXTENDEDKEYUSAGE_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpExtendedKeyUsage.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXTENDEDKEYUSAGE_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXTENDEDKEYUSAGE_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExtendedKeyUsage=%zu hrc=%Rhrc\n", this, "Certificate::getExtendedKeyUsage", ComSafeArraySize(*aExtendedKeyUsage), hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(RawCertData)(ComSafeArrayOut(BYTE, aRawCertData))
{
    LogRelFlow(("{%p} %s: enter aRawCertData=%p\n", this, "Certificate::getRawCertData", aRawCertData));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRawCertData);
        ArrayOutConverter<BYTE> TmpRawCertData(ComSafeArrayOutArg(aRawCertData));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_RAWCERTDATA_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRawCertData(TmpRawCertData.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_RAWCERTDATA_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpRawCertData.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_RAWCERTDATA_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_RAWCERTDATA_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRawCertData=%zu hrc=%Rhrc\n", this, "Certificate::getRawCertData", ComSafeArraySize(*aRawCertData), hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(SelfSigned)(BOOL *aSelfSigned)
{
    LogRelFlow(("{%p} %s: enter aSelfSigned=%p\n", this, "Certificate::getSelfSigned", aSelfSigned));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSelfSigned);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SELFSIGNED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSelfSigned(aSelfSigned);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SELFSIGNED_RETURN(this, hrc, 0 /*normal*/,*aSelfSigned != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SELFSIGNED_RETURN(this, hrc, 1 /*hrc exception*/,*aSelfSigned != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_SELFSIGNED_RETURN(this, hrc, 9 /*unhandled exception*/,*aSelfSigned != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSelfSigned=%RTbool hrc=%Rhrc\n", this, "Certificate::getSelfSigned", *aSelfSigned, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(Trusted)(BOOL *aTrusted)
{
    LogRelFlow(("{%p} %s: enter aTrusted=%p\n", this, "Certificate::getTrusted", aTrusted));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aTrusted);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_TRUSTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getTrusted(aTrusted);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_TRUSTED_RETURN(this, hrc, 0 /*normal*/,*aTrusted != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_TRUSTED_RETURN(this, hrc, 1 /*hrc exception*/,*aTrusted != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_TRUSTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aTrusted != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aTrusted=%RTbool hrc=%Rhrc\n", this, "Certificate::getTrusted", *aTrusted, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(Expired)(BOOL *aExpired)
{
    LogRelFlow(("{%p} %s: enter aExpired=%p\n", this, "Certificate::getExpired", aExpired));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExpired);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXPIRED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExpired(aExpired);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXPIRED_RETURN(this, hrc, 0 /*normal*/,*aExpired != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXPIRED_RETURN(this, hrc, 1 /*hrc exception*/,*aExpired != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_GET_EXPIRED_RETURN(this, hrc, 9 /*unhandled exception*/,*aExpired != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExpired=%RTbool hrc=%Rhrc\n", this, "Certificate::getExpired", *aExpired, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute1ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute2ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute3ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute4ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute5ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute6ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute7ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute8ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute9ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute10ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute11ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::COMGETTER(InternalAndReservedAttribute12ICertificate)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICertificate methods
//

STDMETHODIMP CertificateWrap::IsCurrentlyExpired(BOOL *aResult)
{
    LogRelFlow(("{%p} %s: enter aResult=%p\n", this, "Certificate::isCurrentlyExpired", aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_ISCURRENTLYEXPIRED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = isCurrentlyExpired(aResult);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_ISCURRENTLYEXPIRED_RETURN(this, hrc, 0 /*normal*/, *aResult != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_ISCURRENTLYEXPIRED_RETURN(this, hrc, 1 /*hrc exception*/, *aResult != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_ISCURRENTLYEXPIRED_RETURN(this, hrc, 9 /*unhandled exception*/, *aResult != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%RTbool hrc=%Rhrc\n", this, "Certificate::isCurrentlyExpired", *aResult, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::QueryInfo(LONG aWhat,
                                        BSTR *aResult)
{
    LogRelFlow(("{%p} %s: enter aWhat=%RI32 aResult=%p\n", this, "Certificate::queryInfo", aWhat, aResult));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aResult);


        
        BSTROutConverter TmpResult(aResult);

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_QUERYINFO_ENTER(this, aWhat);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = queryInfo(aWhat,
                            TmpResult.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_QUERYINFO_RETURN(this, hrc, 0 /*normal*/, aWhat, TmpResult.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_QUERYINFO_RETURN(this, hrc, 1 /*hrc exception*/, aWhat, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CERTIFICATE_QUERYINFO_RETURN(this, hrc, 9 /*unhandled exception*/, aWhat, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aResult=%ls hrc=%Rhrc\n", this, "Certificate::queryInfo", *aResult, hrc));
    return hrc;
}

STDMETHODIMP CertificateWrap::InternalAndReservedMethod1ICertificate()
{
    return E_NOTIMPL;
}

STDMETHODIMP CertificateWrap::InternalAndReservedMethod2ICertificate()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CertificateWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CertificateWrap, ICertificate)
#endif // VBOX_WITH_XPCOM
