/** @file
 * VirtualBox API class wrapper code for ICPUProfile.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2025 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_CPUPROFILE

#include "CPUProfileWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(CPUProfileWrap)

//
// ICPUProfile properties
//

STDMETHODIMP CPUProfileWrap::COMGETTER(Name)(BSTR *aName)
{
    LogRelFlow(("{%p} %s: enter aName=%p\n", this, "CPUProfile::getName", aName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aName);
        BSTROutConverter TmpName(aName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_NAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getName(TmpName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_NAME_RETURN(this, hrc, 0 /*normal*/,TmpName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_NAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_NAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aName=%ls hrc=%Rhrc\n", this, "CPUProfile::getName", *aName, hrc));
    return hrc;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(FullName)(BSTR *aFullName)
{
    LogRelFlow(("{%p} %s: enter aFullName=%p\n", this, "CPUProfile::getFullName", aFullName));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aFullName);
        BSTROutConverter TmpFullName(aFullName);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_FULLNAME_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getFullName(TmpFullName.str());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_FULLNAME_RETURN(this, hrc, 0 /*normal*/,TmpFullName.str().c_str());
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_FULLNAME_RETURN(this, hrc, 1 /*hrc exception*/,0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_FULLNAME_RETURN(this, hrc, 9 /*unhandled exception*/,0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aFullName=%ls hrc=%Rhrc\n", this, "CPUProfile::getFullName", *aFullName, hrc));
    return hrc;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(Architecture)(CPUArchitecture_T *aArchitecture)
{
    LogRelFlow(("{%p} %s: enter aArchitecture=%p\n", this, "CPUProfile::getArchitecture", aArchitecture));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aArchitecture);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_ARCHITECTURE_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getArchitecture(aArchitecture);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_ARCHITECTURE_RETURN(this, hrc, 0 /*normal*/,*aArchitecture);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_ARCHITECTURE_RETURN(this, hrc, 1 /*hrc exception*/,*aArchitecture);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_CPUPROFILE_GET_ARCHITECTURE_RETURN(this, hrc, 9 /*unhandled exception*/,*aArchitecture);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aArchitecture=%RU32 hrc=%Rhrc\n", this, "CPUProfile::getArchitecture", *aArchitecture, hrc));
    return hrc;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute1ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute2ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute3ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute4ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute5ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute6ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute7ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::COMGETTER(InternalAndReservedAttribute8ICPUProfile)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// ICPUProfile methods
//

STDMETHODIMP CPUProfileWrap::InternalAndReservedMethod1ICPUProfile()
{
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::InternalAndReservedMethod2ICPUProfile()
{
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::InternalAndReservedMethod3ICPUProfile()
{
    return E_NOTIMPL;
}

STDMETHODIMP CPUProfileWrap::InternalAndReservedMethod4ICPUProfile()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(CPUProfileWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(CPUProfileWrap, ICPUProfile)
#endif // VBOX_WITH_XPCOM
