
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack(1)
#endif
typedef struct RTMSGENTRYINT
{
    uint64_t offDefine   : 17; /* max 0x1bc71 */
    uint64_t cchDefine   :  6; /* max 0x28 */
    uint64_t offMsgShort : 17; /* max 0x1bc77 */
    uint64_t cchMsgShort :  8; /* max 0x8e */
    int64_t  iCode       : 16;
} RTMSGENTRYINT;
typedef RTMSGENTRYINT *PCRTMSGENTRYINT;
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack()
#endif

static const RTMSGENTRYINT g_aStatusMsgs[ /*2461*/ ] =
{
    { 0x015273,  18, 0x002806,  60,   -27018 }, /* VERR_FDT_AT_ROOT_LEVEL */
    { 0x00e44c,  27, 0x0097cf,  36,   -27017 }, /* VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED */
    { 0x00fa77,  25, 0x004dc1,  49,   -27016 }, /* VERR_FDT_DTB_PROP_SIZE_MALFORMED */
    { 0x00d027,  29, 0x005a99,  46,   -27015 }, /* VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE */
    { 0x009817,  36, 0x008e25,  37,   -27014 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END */
    { 0x007aaa,  40, 0x0050d1,  48,   -27013 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING */
    { 0x009397,  36, 0x0075b9,  41,   -27012 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED */
    { 0x007bc2,  40, 0x00af9b,  32,   -27011 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID */
    { 0x009547,  36, 0x009d97,  35,   -27010 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID */
    { 0x00a2d2,  34, 0x007089,  42,   -27009 }, /* VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED */
    { 0x009d0b,  35, 0x000a6b,  84,   -27008 }, /* VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING */
    { 0x008b3b,  38, 0x007089,  42,   -27007 }, /* VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID */
    { 0x008cd8,  37, 0x00760b,  41,   -27006 }, /* VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID */
    { 0x008bf9,  38, 0x0057dc,  47,   -27005 }, /* VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID */
    { 0x011ad4,  22, 0x0034fd,  56,   -27004 }, /* VERR_FDT_DTB_HDR_SIZE_INVALID */
    { 0x00a04d,  34, 0x007257,  42,   -27003 }, /* VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID */
    { 0x0167d8,  17, 0x00c93d,  30,   -27002 }, /* VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED */
    { 0x00ed35,  26, 0x00d36f,  28,   -27001 }, /* VERR_FDT_DTB_HDR_MAGIC_INVALID */
    { 0x01590d,  18, 0x00cee8,  29,   -27000 }, /* VERR_FDT_DTB_MALFORMED */
    { 0x0146fe,  19, 0x01754f,  16,   -26820 }, /* VERR_HARDAVL_UNBALANCED */
    { 0x0172d0,  16, 0x0197a9,  13,   -26819 }, /* VERR_HARDAVL_BAD_HEIGHT */
    { 0x013534,  21, 0x00dbbf,  28,   -26818 }, /* VERR_HARDAVL_LOOKUP_TOO_DEEP */
    { 0x00ed01,  26, 0x003a2d,  54,   -26817 }, /* VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES */
    { 0x01369f,  20, 0x00cfb3,  29,   -26816 }, /* VERR_HARDAVL_UNEXPECTED_NULL_RIGHT */
    { 0x014a68,  19, 0x00d7eb,  28,   -26815 }, /* VERR_HARDAVL_UNEXPECTED_NULL_LEFT */
    { 0x014129,  20, 0x016343,  17,   -26814 }, /* VERR_HARDAVL_BAD_NEW_HEIGHT */
    { 0x01211a,  22, 0x0143e1,  19,   -26813 }, /* VERR_HARDAVL_BAD_RIGHT_HEIGHT */
    { 0x012fcb,  21, 0x0154c4,  18,   -26812 }, /* VERR_HARDAVL_BAD_LEFT_HEIGHT */
    { 0x00edb7,  26, 0x009a95,  35,   -26811 }, /* VERR_HARDAVL_INSERT_INVALID_KEY_RANGE */
    { 0x0114d3,  23, 0x00b47b,  32,   -26810 }, /* VERR_HARDAVL_STACK_OVERFLOW */
    { 0x012ff5,  21, 0x00dc67,  28,   -26804 }, /* VERR_HARDAVL_NODE_IS_FREE */
    { 0x00e8ba,  27, 0x008f72,  37,   -26803 }, /* VERR_HARDAVL_MISALIGNED_POINTER */
    { 0x00c3d9,  30, 0x00777c,  41,   -26802 }, /* VERR_HARDAVL_POINTER_OUT_OF_BOUNDS */
    { 0x00dc13,  28, 0x010765,  24,   -26801 }, /* VERR_HARDAVL_INDEX_OUT_OF_BOUNDS */
    { 0x00cfed,  29, 0x003f6b,  53,   -26602 }, /* VERR_TRACELOG_READER_ITERATOR_END */
    { 0x00ad1b,  32, 0x018103,  15,   -26601 }, /* VERR_TRACELOG_READER_LOG_UNSUPPORTED */
    { 0x00c325,  30, 0x012264,  22,   -26600 }, /* VERR_TRACELOG_READER_MALFORMED_LOG */
    { 0x01006c,  25, 0x0112f0,  23,   -26406 }, /* VERR_FTP_CLIENT_LIMIT_REACHED */
    { 0x0187cc,  14, 0x01af0e,   9,   -26405 }, /* VERR_FTP_CLIENT_NOT_FOUND */
    { 0x00d957,  28, 0x00addb,  32,   -26404 }, /* VERR_FTP_DATA_CONN_LIMIT_REACHED */
    { 0x01672e,  17, 0x01548e,  18,   -26403 }, /* VERR_FTP_DATA_CONN_NOT_FOUND */
    { 0x0130b2,  21, 0x01548e,  18,   -26402 }, /* VERR_FTP_DATA_CONN_INIT_FAILED */
    { 0x01a5d0,  11, 0x013e5a,  20,   -26401 }, /* VERR_FTP_INIT_FAILED */
    { 0x013bee,  20, 0x0152f1,  18,   -26400 }, /* VERR_FTP_STATUS_SERVER_ERROR */
    { 0x0193da,  13, 0x0048b0,  50,   -26203 }, /* VERR_IOQUEUE_BUSY */
    { 0x018ab2,  14, 0x0016ce,  68,   -26202 }, /* VERR_IOQUEUE_EMPTY */
    { 0x018fa3,  13, 0x00620a,  45,   -26201 }, /* VERR_IOQUEUE_FULL */
    { 0x00e29c,  27, 0x008597,  38,   -26200 }, /* VERR_IOQUEUE_HANDLE_NOT_REGISTERED */
    { 0x00bcee,  31, 0x00e7ac,  27,   -26000 }, /* VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED */
    { 0x011712,  23, 0x006bbd,  43,   -25811 }, /* VERR_CR_CIPHER_OSSL_SET_TAG_FAILED */
    { 0x011785,  23, 0x006a90,  43,   -25810 }, /* VERR_CR_CIPHER_OSSL_GET_TAG_FAILED */
    { 0x01418d,  20, 0x01986d,  12,   -25809 }, /* VERR_CR_CIPHER_INVALID_TAG_LENGTH */
    { 0x008aa3,  38, 0x00c8e3,  30,   -25808 }, /* VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH */
    { 0x013b76,  20, 0x019aad,  12,   -25807 }, /* VERR_CR_CIPHER_INVALID_KEY_LENGTH */
    { 0x00cbf6,  29, 0x015ceb,  18,   -25806 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED */
    { 0x00c523,  30, 0x0148c6,  19,   -25805 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED */
    { 0x00d5f3,  28, 0x016596,  17,   -25804 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED */
    { 0x00d2df,  29, 0x0151ad,  18,   -25803 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED */
    { 0x00c8c5,  30, 0x014453,  19,   -25802 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED */
    { 0x00d893,  28, 0x0169b4,  17,   -25801 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED */
    { 0x01a6cd,  11, 0x01b2a9,   8,   -25800 }, /* VERR_CR_CIPHER_NOT_SUPPORTED */
    { 0x01aba4,  10, 0x01badf,   5,   -25799 }, /* VERR_REST_INTERNAL_ERROR_9 */
    { 0x01abcc,  10, 0x01ba7b,   5,   -25798 }, /* VERR_REST_INTERNAL_ERROR_8 */
    { 0x01abfe,  10, 0x01ba21,   5,   -25797 }, /* VERR_REST_INTERNAL_ERROR_7 */
    { 0x01a730,  10, 0x01bb11,   5,   -25796 }, /* VERR_REST_INTERNAL_ERROR_6 */
    { 0x01a73a,  10, 0x01bac6,   5,   -25795 }, /* VERR_REST_INTERNAL_ERROR_5 */
    { 0x01a744,  10, 0x01ba30,   5,   -25794 }, /* VERR_REST_INTERNAL_ERROR_4 */
    { 0x01ab86,  10, 0x01bb61,   5,   -25793 }, /* VERR_REST_INTERNAL_ERROR_3 */
    { 0x01a74e,  10, 0x01bae9,   5,   -25792 }, /* VERR_REST_INTERNAL_ERROR_2 */
    { 0x01a758,  10, 0x01ba94,   5,   -25791 }, /* VERR_REST_INTERNAL_ERROR_1 */
    { 0x0093df,  36, 0x00d67f,  28,   -25713 }, /* VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET */
    { 0x009937,  35, 0x00a796,  33,   -25712 }, /* VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET */
    { 0x00fce8,  25, 0x014583,  19,   -25711 }, /* VERR_REST_PATH_PARAMETER_NOT_SET */
    { 0x00f555,  26, 0x0168a4,  17,   -25710 }, /* VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL */
    { 0x00e18e,  27, 0x015032,  19,   -25709 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DATE */
    { 0x010b9d,  24, 0x018040,  15,   -25708 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_STRING */
    { 0x00d336,  29, 0x012d2b,  21,   -25707 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE */
    { 0x00c901,  30, 0x0122e8,  22,   -25706 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER */
    { 0x00e4d3,  27, 0x0144d8,  19,   -25705 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_BOOL */
    { 0x00e374,  27, 0x017b72,  15,   -25704 }, /* VERR_REST_UNABLE_TO_DECODE_DATE */
    { 0x00a338,  34, 0x005cc1,  46,   -25703 }, /* VERR_REST_RESPONSE_REPEAT_HEADER_FIELD */
    { 0x00aaef,  33, 0x0063c3,  44,   -25702 }, /* VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR */
    { 0x0126b0,  22, 0x00e941,  27,   -25701 }, /* VERR_REST_RESPONSE_INVALID_UTF8_ENCODING */
    { 0x00eabb,  27, 0x006de9,  42,   -25700 }, /* VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED */
    { 0x012c44,  21, 0x004585,  51,   -25501 }, /* VERR_SERIALPORT_INVALID_BAUDRATE */
    { 0x00ed9d,  26, 0x005bad,  46,   -25500 }, /* VERR_SERIALPORT_BREAK_DETECTED */
    { 0x01bb75,   4, 0x01b5c3,   6,   -25395 }, /* VERR_ISOFS_IPE_5 */
    { 0x01bb95,   4, 0x01b4bb,   6,   -25394 }, /* VERR_ISOFS_IPE_4 */
    { 0x01bb99,   4, 0x01b38b,   6,   -25393 }, /* VERR_ISOFS_IPE_3 */
    { 0x01bba5,   4, 0x01b26b,   6,   -25392 }, /* VERR_ISOFS_IPE_2 */
    { 0x01bbe9,   4, 0x01b153,   6,   -25391 }, /* VERR_ISOFS_IPE_1 */
    { 0x015565,  18, 0x013034,  21,   -25390 }, /* VERR_ISOFS_UDF_NOT_IMPLEMENTED */
    { 0x01bb34,   5, 0x019324,  13,   -25345 }, /* VERR_ISOFS_UNKNOWN_FILE_TYPE */
    { 0x01ab40,  10, 0x019855,  12,   -25344 }, /* VERR_ISOFS_WRONG_FILE_TYPE */
    { 0x01b489,   8, 0x007701,  41,   -25343 }, /* VERR_ISOFS_BAD_EXTAD */
    { 0x01a3d6,  11, 0x0153a4,  18,   -25342 }, /* VERR_ISO_FS_UNKNOWN_AD_TYPE */
    { 0x01b0bd,   9, 0x01ae1b,   9,   -25341 }, /* VERR_ISOFS_BAD_FILE_ENTRY */
    { 0x01b9ce,   6, 0x01a52b,  11,   -25340 }, /* VERR_ISOFS_UNSUPPORTED_ICB */
    { 0x0154e8,  18, 0x008c44,  37,   -25339 }, /* VERR_ISOFS_ICB_ENTRY_TOO_SMALL */
    { 0x01350a,  21, 0x0116e4,  23,   -25338 }, /* VERR_ISOFS_TOO_DEEP_ICB_RECURSION */
    { 0x013856,  20, 0x0083ec,  39,   -25337 }, /* VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS */
    { 0x01305e,  21, 0x0132fe,  21,   -25336 }, /* VERR_ISOFS_NO_DIRECT_ICB_ENTRIES */
    { 0x01a0dd,  12, 0x0185d4,  14,   -25335 }, /* VERR_ISOFS_ICB_TOO_SMALL */
    { 0x01a924,  10, 0x019e25,  12,   -25334 }, /* VERR_ISOFS_ICB_TOO_BIG */
    { 0x015f47,  17, 0x00b4db,  32,   -25333 }, /* VERR_ISOFS_FSD_NEXT_EXTENT */
    { 0x014737,  19, 0x006f39,  42,   -25332 }, /* VERR_ISOFS_FSD_ZERO_ROOT_DIR */
    { 0x017afa,  15, 0x0165eb,  17,   -25331 }, /* VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET */
    { 0x0155f5,  18, 0x00cbbc,  29,   -25330 }, /* VERR_ISOFS_INVALID_PARTITION_INDEX */
    { 0x0139aa,  20, 0x004978,  50,   -25329 }, /* VERR_ISOFS_BAD_LVD_DESC_CHAR_SET */
    { 0x00ff0e,  25, 0x00e64d,  27,   -25327 }, /* VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION */
    { 0x0171d0,  16, 0x00aebb,  32,   -25326 }, /* VERR_ISOFS_BAD_LVD_DOMAIN_ID */
    { 0x0159e5,  18, 0x00abd6,  33,   -25325 }, /* VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE */
    { 0x01b481,   8, 0x004a40,  50,   -25324 }, /* VERR_ISOFS_MPM_NOT_SUPPORTED */
    { 0x01b441,   8, 0x004c66,  50,   -25323 }, /* VERR_ISOFS_SPM_NOT_SUPPORTED */
    { 0x01b319,   8, 0x0050a0,  49,   -25322 }, /* VERR_ISOFS_VPM_NOT_SUPPORTED */
    { 0x016e70,  16, 0x004a72,  50,   -25321 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID */
    { 0x0148a0,  19, 0x0132d4,  21,   -25320 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE */
    { 0x00e590,  27, 0x0069b9,  43,   -25319 }, /* VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE */
    { 0x018d44,  14, 0x00705f,  42,   -25318 }, /* VERR_ISOFS_PARTITION_NOT_FOUND */
    { 0x00f4ed,  26, 0x005430,  47,   -25317 }, /* VERR_ISOFS_MALFORMED_PART_MAP_TABLE */
    { 0x0197c3,  13, 0x006fb7,  42,   -25316 }, /* VERR_ISOFS_TOO_MANY_PART_MAPS */
    { 0x017c26,  15, 0x002ca8,  59,   -25315 }, /* VERR_ISOFS_MULTIPLE_LVDS */
    { 0x017a28,  15, 0x002a95,  59,   -25314 }, /* VERR_ISOFS_MULTIPLE_PVDS */
    { 0x01bb39,   5, 0x01095d,  24,   -25313 }, /* VERR_ISOFS_NO_PD */
    { 0x01b9aa,   6, 0x011757,  23,   -25312 }, /* VERR_ISOFS_NO_LVD */
    { 0x01b914,   6, 0x011a65,  23,   -25311 }, /* VERR_ISOFS_NO_PVD */
    { 0x012912,  21, 0x00ab52,  33,   -25310 }, /* VERR_ISOFS_TOO_BIT_PARTMAP_IN_LVD */
    { 0x01b778,   7, 0x00e107,  27,   -25309 }, /* VERR_ISOFS_TOO_MANY_PDS */
    { 0x01b369,   8, 0x00f3b5,  26,   -25308 }, /* VERR_ISOFS_TOO_MANY_LVDS */
    { 0x01b321,   8, 0x00f215,  26,   -25307 }, /* VERR_ISOFS_TOO_MANY_PVDS */
    { 0x01a35d,  11, 0x009277,  36,   -25306 }, /* VERR_ISOFS_UNEXPECTED_VDS_DESC */
    { 0x00b05b,  32, 0x00eed5,  26,   -25305 }, /* VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC */
    { 0x019dc5,  12, 0x010cec,  24,   -25304 }, /* VERR_ISOFS_DESC_CRC_MISMATCH */
    { 0x0189ee,  14, 0x00b23b,  32,   -25303 }, /* VERR_ISOFS_TAG_SECTOR_MISMATCH */
    { 0x017c17,  15, 0x0182d4,  15,   -25302 }, /* VERR_ISOFS_BAD_TAG_CHECKSUM */
    { 0x01b4f9,   8, 0x018b4c,  14,   -25301 }, /* VERR_ISOFS_UNSUPPORTED_TAG_VERSION */
    { 0x015e53,  18, 0x00f2ff,  26,   -25300 }, /* VERR_ISOFS_TAG_IS_ALL_ZEROS */
    { 0x00a206,  34, 0x000b64,  80,   -25157 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS */
    { 0x007e42,  40, 0x000969,  88,   -25156 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE */
    { 0x009adb,  35, 0x000860,  89,   -25155 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR */
    { 0x00912e,  37, 0x002188,  63,   -25154 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS */
    { 0x00f6da,  25, 0x000ca4,  78,   -25153 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID */
    { 0x00b835,  31, 0x005eb3,  45,   -25152 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND */
    { 0x00e617,  27, 0x00168a,  68,   -25151 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG */
    { 0x00f2cb,  26, 0x0066db,  44,   -25150 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE */
    { 0x008e4a,  37, 0x0025e6,  61,   -25149 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS */
    { 0x009f18,  35, 0x00749a,  41,   -25148 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD */
    { 0x00bf98,  31, 0x00801d,  39,   -25147 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG */
    { 0x00d973,  28, 0x007f5a,  39,   -25146 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS */
    { 0x00f789,  25, 0x008350,  39,   -25145 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE */
    { 0x011d10,  22, 0x009bd0,  35,   -25144 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID */
    { 0x00acdb,  32, 0x004486,  51,   -25143 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM */
    { 0x00da8b,  28, 0x005bdb,  46,   -25142 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS */
    { 0x00aa6b,  33, 0x004750,  51,   -25141 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID */
    { 0x00ec99,  26, 0x008d91,  37,   -25140 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS */
    { 0x00c1db,  30, 0x002c32,  59,   -25133 }, /* VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT */
    { 0x00ed83,  26, 0x001a7f,  66,   -25132 }, /* VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT */
    { 0x00bd6a,  31, 0x0018aa,  68,   -25131 }, /* VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC */
    { 0x010bcd,  24, 0x0044b9,  51,   -25130 }, /* VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS */
    { 0x00e3e0,  20, 0x01b2f9,   8,   -25129 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME */
    { 0x00e3e0,  27, 0x01b2f9,   8,   -25128 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH */
    { 0x0156cd,  18, 0x00d743,  28,   -25127 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH */
    { 0x00bb99,  31, 0x00c4e7,  30,   -25126 }, /* VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS */
    { 0x010b6d,  24, 0x005b51,  46,   -25125 }, /* VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO */
    { 0x0156cd,  11, 0x01591f,  18,   -25124 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC */
    { 0x01694e,  17, 0x012d55,  21,   -25123 }, /* VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE */
    { 0x00e8d5,  27, 0x00c2e9,  30,   -25122 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT */
    { 0x00db4f,  28, 0x00be81,  31,   -25121 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG */
    { 0x011432,  23, 0x00ab31,  33,   -25120 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH */
    { 0x00b55b,  32, 0x00a316,  34,   -25119 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS */
    { 0x013477,  21, 0x0062e7,  44,   -25118 }, /* VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO */
    { 0x01250e,  22, 0x00b57b,  32,   -25117 }, /* VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR */
    { 0x011432,  16, 0x01148e,  23,   -25116 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC */
    { 0x015e9a,  18, 0x0023f9,  62,   -25115 }, /* VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH */
    { 0x015162,  19, 0x001f8e,  64,   -25114 }, /* VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH */
    { 0x0153ec,  18, 0x00f3cf,  26,   -25113 }, /* VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO */
    { 0x00c3f7,  30, 0x01272f,  21,   -25112 }, /* VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET */
    { 0x0111c5,  23, 0x0064f7,  44,   -25111 }, /* VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB */
    { 0x019136,  13, 0x00968b,  36,   -25110 }, /* VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC */
    { 0x012990,  21, 0x00741f,  41,   -25109 }, /* VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER */
    { 0x0139e6,  20, 0x00c415,  30,   -25108 }, /* VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC */
    { 0x00d91f,  28, 0x009d2e,  35,   -25107 }, /* VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER */
    { 0x00bdc7,  31, 0x004552,  51,   -25106 }, /* VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY */
    { 0x00d85b,  28, 0x008c69,  37,   -25105 }, /* VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS */
    { 0x00e38f,  27, 0x007fa8,  39,   -25104 }, /* VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS */
    { 0x00d149,  29, 0x008b61,  38,   -25103 }, /* VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS */
    { 0x01779e,  16, 0x014524,  19,   -25102 }, /* VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR */
    { 0x018dfa,  14, 0x00bfd6,  31,   -25101 }, /* VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS */
    { 0x01a9f6,  10, 0x009667,  36,   -25100 }, /* VERR_ISOMK_IMPORT_UNKNOWN_FORMAT */
    { 0x016aa1,  16, 0x00ca7d,  29,   -25029 }, /* VERR_ISOMK_RR_SPILL_FILE_FULL */
    { 0x019018,  13, 0x00a59c,  34,   -25028 }, /* VERR_ISOMK_IPE_FINALIZE_1 */
    { 0x017ed8,  15, 0x00e90b,  27,   -25027 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_3 */
    { 0x017eab,  15, 0x00e3fb,  27,   -25026 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_2 */
    { 0x017ec9,  15, 0x00df21,  27,   -25025 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_1 */
    { 0x013892,  20, 0x008302,  39,   -25024 }, /* VERR_ISOMK_IPE_PRODUCE_TRANS_TBL */
    { 0x01746f,  16, 0x00b37b,  32,   -25023 }, /* VERR_ISOMK_IPE_BOOT_CAT_FILE */
    { 0x01a4b2,  11, 0x011dd6,  22,   -25022 }, /* VERR_ISOMK_IPE_BUFFER_SIZE */
    { 0x01938c,  13, 0x00a942,  33,   -25021 }, /* VERR_ISOMK_IPE_DESC_COUNT */
    { 0x019553,  13, 0x00bc72,  31,   -25020 }, /* VERR_ISOMK_IPE_ROOT_SLASH */
    { 0x015297,  18, 0x00ebae,  27,   -25019 }, /* VERR_ISOMK_IPE_EMPTY_COMPONENT */
    { 0x0194f8,  13, 0x01309d,  21,   -25018 }, /* VERR_ISOMK_IPE_EMPTY_PATH */
    { 0x018970,  14, 0x00bac0,  31,   -25017 }, /* VERR_ISOMK_IPE_NAMESPACE_6 */
    { 0x018a0a,  14, 0x00bafe,  31,   -25016 }, /* VERR_ISOMK_IPE_NAMESPACE_5 */
    { 0x01897e,  14, 0x00b873,  31,   -25015 }, /* VERR_ISOMK_IPE_NAMESPACE_4 */
    { 0x01898c,  14, 0x00bebf,  31,   -25014 }, /* VERR_ISOMK_IPE_NAMESPACE_3 */
    { 0x01899a,  14, 0x00bc53,  31,   -25013 }, /* VERR_ISOMK_IPE_NAMESPACE_2 */
    { 0x0189fc,  14, 0x00bbf6,  31,   -25012 }, /* VERR_ISOMK_IPE_NAMESPACE_1 */
    { 0x01b4f1,   8, 0x00b09b,  32,   -25011 }, /* VERR_ISOMK_IPE_TABLE */
    { 0x01a79e,  10, 0x009fe7,  34,   -25010 }, /* VERR_ISOMK_IPE_RR_READ */
    { 0x015cb5,  18, 0x009f81,  34,   -25009 }, /* VERR_ISOMK_RR_NO_SPACE_FOR_CE */
    { 0x00efa5,  26, 0x0035a5,  56,   -25008 }, /* VERR_ISOMK_SYMLINK_SUPPORT_DISABLED */
    { 0x010cbd,  24, 0x0029a9,  59,   -25007 }, /* VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x012c6e,  21, 0x001dce,  64,   -25006 }, /* VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3 */
    { 0x0108b5,  24, 0x010b25,  24,   -25005 }, /* VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY */
    { 0x01333d,  21, 0x00a89d,  33,   -25004 }, /* VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE */
    { 0x011e86,  22, 0x01110d,  23,   -25003 }, /* VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY */
    { 0x009fa3,  34, 0x01b024,   9,   -25002 }, /* VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER */
    { 0x010053,  25, 0x00fa45,  25,   -25001 }, /* VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY */
    { 0x00de97,  28, 0x00d487,  28,   -25000 }, /* VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY */
    { 0x019f8d,  12, 0x005c65,  46,   -24804 }, /* VERR_VFS_UNSUPPORTED_CREATE_TYPE */
    { 0x01ab9a,  10, 0x017140,  16,   -24803 }, /* VERR_VFS_UNSUPPORTED_FORMAT */
    { 0x017f9b,  15, 0x00cb2b,  29,   -24802 }, /* VERR_VFS_BOGUS_OFFSET */
    { 0x017866,  15, 0x00cca4,  29,   -24801 }, /* VERR_VFS_BOGUS_FORMAT */
    { 0x01a8de,  10, 0x01753f,  16,   -24800 }, /* VERR_VFS_UNKNOWN_FORMAT */
    { 0x016de0,  16, 0x01a2ad,  11,   -24707 }, /* VERR_JSON_INVALID_CODEPOINT */
    { 0x00c217,  30, 0x00b5db,  32,   -24706 }, /* VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE */
    { 0x011b58,  22, 0x00c7f3,  30,   -24705 }, /* VERR_JSON_MISSING_SURROGATE_PAIR */
    { 0x00d583,  28, 0x010b0d,  24,   -24704 }, /* VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE */
    { 0x01853a,  14, 0x013145,  21,   -24703 }, /* VERR_JSON_IS_EMPTY */
    { 0x017e51,  15, 0x00f4b9,  26,   -24702 }, /* VERR_JSON_MALFORMED */
    { 0x015e41,  18, 0x01180f,  23,   -24701 }, /* VERR_JSON_ITERATOR_END */
    { 0x018a42,  14, 0x007e1a,  40,   -24700 }, /* VERR_JSON_VALUE_INVALID_TYPE */
    { 0x01908d,  13, 0x00e308,  27,   -24610 }, /* VERR_URI_NOT_FILE_SCHEME */
    { 0x00cb9f,  29, 0x0028ba,  60,   -24609 }, /* VERR_URI_MISSING_UTF8_CONTINUATION_BYTE */
    { 0x0097ab,  36, 0x002ef2,  58,   -24608 }, /* VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE */
    { 0x00ddef,  28, 0x005221,  48,   -24607 }, /* VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE */
    { 0x00c4ab,  30, 0x006075,  45,   -24606 }, /* VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8 */
    { 0x016222,  17, 0x0041ae,  52,   -24605 }, /* VERR_URI_ESCAPED_ZERO */
    { 0x017150,  16, 0x01609b,  17,   -24604 }, /* VERR_URI_INVALID_ESCAPE_SEQ */
    { 0x016a5e,  17, 0x01968b,  13,   -24603 }, /* VERR_URI_INVALID_PORT_NUMBER */
    { 0x019d95,  12, 0x01b529,   8,   -24602 }, /* VERR_URI_INVALID_SCHEME */
    { 0x01a4bd,  11, 0x00eb42,  27,   -24601 }, /* VERR_URI_TOO_SHORT */
    { 0x01ac1c,  10, 0x019b55,  12,   -24600 }, /* VERR_URI_EMPTY */
    { 0x011e02,  22, 0x00bc34,  31,   -24403 }, /* VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS */
    { 0x00b6fb,  32, 0x005281,  48,   -24402 }, /* VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED */
    { 0x01300a,  21, 0x01814e,  15,   -24400 }, /* VERR_PATH_MATCH_UNKNOWN_VARIABLE */
    { 0x011f8e,  22, 0x008785,  38,   -24399 }, /* VERR_CR_MALFORMED_PEM_HEADER */
    { 0x01ac26,  10, 0x00554a,  47,   -24398 }, /* VERR_CR_RANDOM_FAILED */
    { 0x017020,  16, 0x00554a,  47,   -24397 }, /* VERR_CR_RANDOM_SETUP_FAILED */
    { 0x00c84d,  30, 0x00cf22,  29,   -24396 }, /* VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED */
    { 0x017040,  16, 0x00ca9a,  29,   -24395 }, /* VERR_CR_OPENSSL_VERSION_TOO_OLD */
    { 0x01ba80,   5, 0x00946f,  36,   -24205 }, /* VERR_CR_DIGEST_NOT_SUPPORTED */
    { 0x011729,  23, 0x00dd47,  28,   -24204 }, /* VERR_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x0187f6,  14, 0x0147a9,  19,   -24203 }, /* VERR_CR_DIGEST_COMPROMISED */
    { 0x0195a1,  13, 0x015acf,  18,   -24202 }, /* VERR_CR_DIGEST_DEPRECATED */
    { 0x014770,  19, 0x00e0d1,  27,   -24201 }, /* VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR */
    { 0x018211,  15, 0x00b6bb,  32,   -24200 }, /* VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR */
    { 0x00f9af,  25, 0x005401,  47,   -24002 }, /* VERR_BIGNUM_NEGATIVE_EXPONENT */
    { 0x014395,  19, 0x0121b4,  22,   -24001 }, /* VERR_BIGNUM_DIV_BY_ZERO */
    { 0x01141b,  23, 0x002149,  63,   -24000 }, /* VERR_BIGNUM_SENSITIVE_INPUT */
    { 0x017e60,  15, 0x01b8a2,   6,   -23900 }, /* VERR_CR_RSA_GENERIC_ERROR */
    { 0x014a2f,  19, 0x00a48c,  34,   -23819 }, /* VERR_CR_KEY_ALGO_PARAMS_MISMATCH */
    { 0x00fb8a,  25, 0x008ddb,  37,   -23818 }, /* VERR_CR_KEY_ALGO_PARAMS_UNKNOWN */
    { 0x014679,  19, 0x007686,  41,   -23817 }, /* VERR_CR_KEY_ALGO_PARAMS_MISSING */
    { 0x00d3a7,  28, 0x00f34d,  26,   -23816 }, /* VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED */
    { 0x01832e,  15, 0x014dac,  19,   -23815 }, /* VERR_CR_KEY_GEN_FAILED_RSA */
    { 0x015955,  18, 0x00364d,  56,   -23813 }, /* VERR_CR_KEY_DECRYPTION_FAILED */
    { 0x00f725,  25, 0x013c3e,  20,   -23812 }, /* VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR */
    { 0x0171a0,  16, 0x0094db,  36,   -23811 }, /* VERR_CR_KEY_PASSWORD_ENCODING */
    { 0x00fb71,  25, 0x003e97,  53,   -23810 }, /* VERR_CR_KEY_MALFORMED_CIPHER_IV */
    { 0x011c8c,  22, 0x00417a,  52,   -23809 }, /* VERR_CR_KEY_TOO_SHORT_CIPHER_IV */
    { 0x012783,  21, 0x007afa,  40,   -23808 }, /* VERR_CR_KEY_MISSING_CIPHER_PARAMS */
    { 0x01382e,  20, 0x004bd0,  50,   -23807 }, /* VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS */
    { 0x018eed,  13, 0x01183d,  23,   -23806 }, /* VERR_CR_KEY_UNSUPPORTED_CIPHER */
    { 0x0147cf,  19, 0x015b71,  18,   -23805 }, /* VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED */
    { 0x013c8e,  20, 0x007916,  41,   -23804 }, /* VERR_CR_KEY_DEK_INFO_TOO_LONG */
    { 0x01823e,  15, 0x001345,  71,   -23803 }, /* VERR_CR_KEY_NO_DEK_INFO */
    { 0x0178cf,  15, 0x008eb9,  37,   -23802 }, /* VERR_CR_KEY_ENCRYPTED */
    { 0x01780c,  15, 0x0199b1,  12,   -23801 }, /* VERR_CR_KEY_FORMAT_NOT_SUPPORTED */
    { 0x01b3e1,   8, 0x00e122,  27,   -23800 }, /* VERR_CR_KEY_UNKNOWN_TYPE */
    { 0x016101,  17, 0x01b141,   8,   -23700 }, /* VERR_CR_STORE_GENERIC_ERROR */
    { 0x00dba3,  28, 0x00a921,  33,   -23527 }, /* VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED */
    { 0x01053e,  24, 0x015859,  18,   -23526 }, /* VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY */
    { 0x00f806,  25, 0x014b00,  19,   -23525 }, /* VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY */
    { 0x011e2e,  22, 0x016bb1,  16,   -23524 }, /* VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY */
    { 0x0113a8,  23, 0x016200,  17,   -23523 }, /* VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY */
    { 0x00bb1d,  29, 0x008c8e,  37,   -23522 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE */
    { 0x00bb1d,  31, 0x006e91,  42,   -23521 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE */
    { 0x0108fd,  24, 0x00d417,  28,   -23520 }, /* VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED */
    { 0x00c64f,  30, 0x00628f,  44,   -23519 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR */
    { 0x00cd8c,  29, 0x00c3bb,  30,   -23518 }, /* VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED */
    { 0x010aad,  24, 0x0101e3,  25,   -23517 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR */
    { 0x00daa7,  28, 0x00cd52,  29,   -23516 }, /* VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED */
    { 0x00f46b,  26, 0x012a4d,  21,   -23515 }, /* VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED */
    { 0x00c8a7,  30, 0x009643,  36,   -23514 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED */
    { 0x00a514,  34, 0x008973,  38,   -23513 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP */
    { 0x00a514,  30, 0x00c1bd,  30,   -23512 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN */
    { 0x00fc6b,  25, 0x014219,  20,   -23511 }, /* VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN */
    { 0x00c071,  31, 0x007849,  41,   -23510 }, /* VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL */
    { 0x015df9,  18, 0x006683,  44,   -23509 }, /* VERR_CR_PKIX_SIGNATURE_MISMATCH */
    { 0x0104f6,  24, 0x015d7b,  18,   -23508 }, /* VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH */
    { 0x00fba3,  25, 0x012b33,  21,   -23507 }, /* VERR_CR_PKIX_SIGNATURE_NEGATIVE */
    { 0x01137a,  23, 0x008999,  38,   -23506 }, /* VERR_CR_PKIX_SIGNATURE_GE_KEY */
    { 0x012448,  22, 0x009dba,  35,   -23505 }, /* VERR_CR_PKIX_SIGNATURE_TOO_LONG */
    { 0x00fa90,  25, 0x00551b,  47,   -23504 }, /* VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY */
    { 0x01addc,   9, 0x01bc77,   2,   -23503 }, /* VERR_CR_PKIX_INTERNAL_ERROR */
    { 0x01a776,  10, 0x019c51,  12,   -23502 }, /* VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE */
    { 0x00a17f,  34, 0x0039c1,  54,   -23501 }, /* VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS */
    { 0x016cc0,  16, 0x01acda,  10,   -23500 }, /* VERR_CR_PKIX_GENERIC_ERROR */
    { 0x011fba,  22, 0x009bad,  35,   -23416 }, /* VERR_CR_SPC_PEIMAGE_NO_CONTENT */
    { 0x00db6b,  28, 0x014075,  20,   -23415 }, /* VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED */
    { 0x010e84,  24, 0x015188,  19,   -23414 }, /* VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE */
    { 0x00b17b,  32, 0x00ef8b,  26,   -23413 }, /* VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS */
    { 0x01506b,  19, 0x010292,  25,   -23412 }, /* VERR_CR_SPC_MONIKER_BAD_DATA */
    { 0x012eba,  21, 0x010a65,  24,   -23411 }, /* VERR_CR_SPC_BAD_MONIKER_CHOICE */
    { 0x0150ca,  19, 0x014a7b,  19,   -23410 }, /* VERR_CR_SPC_UNKNOWN_MONIKER_UUID */
    { 0x0144eb,  19, 0x010166,  25,   -23409 }, /* VERR_CR_SPC_BAD_MONIKER_UUID */
    { 0x00ea85,  27, 0x012dd3,  21,   -23408 }, /* VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT */
    { 0x00d6d3,  28, 0x00c6a9,  30,   -23407 }, /* VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA */
    { 0x015058,  19, 0x009075,  37,   -23406 }, /* VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH */
    { 0x019f69,  12, 0x017b90,  15,   -23405 }, /* VERR_CR_SPC_UNKNOWN_DIGEST_ALGO */
    { 0x00bd0d,  31, 0x002206,  63,   -23404 }, /* VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS */
    { 0x00d1f7,  29, 0x005dff,  45,   -23403 }, /* VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH */
    { 0x010e6c,  24, 0x001b03,  66,   -23402 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO */
    { 0x00bff5,  31, 0x004a0e,  50,   -23401 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS */
    { 0x017cda,  15, 0x01b986,   6,   -23400 }, /* VERR_CR_SPC_GENERIC_ERROR */
    { 0x00e9fe,  27, 0x01a0d1,  12,   -23310 }, /* VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED */
    { 0x014ea3,  19, 0x00341b,  57,   -23309 }, /* VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB */
    { 0x013e6e,  20, 0x0034c5,  56,   -23308 }, /* VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH */
    { 0x013663,  20, 0x00179a,  68,   -23307 }, /* VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB */
    { 0x013e32,  20, 0x0032fe,  57,   -23306 }, /* VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB */
    { 0x012f0e,  21, 0x0032c5,  57,   -23305 }, /* VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH */
    { 0x013438,  21, 0x0017de,  68,   -23304 }, /* VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB */
    { 0x018a96,  14, 0x00b11b,  32,   -23303 }, /* VERR_CR_PKCS7_KEY_USAGE_MISMATCH */
    { 0x01224e,  22, 0x01a6e3,  11,   -23302 }, /* VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND */
    { 0x0172c0,  16, 0x0081a3,  39,   -23301 }, /* VERR_CR_PKCS7_NO_SIGNER_INFOS */
    { 0x01992d,  12, 0x01acda,  10,   -23300 }, /* VERR_CR_PKCS7_GENERIC_ERROR */
    { 0x00f7ed,  25, 0x00b423,  24,   -23109 }, /* VERR_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x00a404,  34, 0x01b211,   8,   -23108 }, /* VERR_X509_CERTIFICATE_VERIFICATION_FAILURE */
    { 0x01068d,  24, 0x0119f2,  23,   -23107 }, /* VERR_X509_PRINT_EXTENSION_TO_BIO */
    { 0x00cc87,  29, 0x00de43,  28,   -23106 }, /* VERR_X509_GETTING_DATA_FROM_EXTENSION */
    { 0x00c9cf,  29, 0x0088db,  38,   -23105 }, /* VERR_X509_GETTING_EXTENSION_FROM_CERT */
    { 0x0126f0,  21, 0x010247,  25,   -23104 }, /* VERR_X509_NO_BASIC_CONSTARAINTS */
    { 0x00ee05,  26, 0x01a0d1,  12,   -23103 }, /* VERR_X509_RSA_VERIFICATION_FUILURE */
    { 0x00ca26,  29, 0x00aaad,  33,   -23102 }, /* VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY */
    { 0x00ebc9,  26, 0x00688c,  43,   -23101 }, /* VERR_X509_EXTRACT_PUBKEY_FROM_CERT */
    { 0x011363,  23, 0x00a963,  33,   -23100 }, /* VERR_X509_READING_CERT_FROM_BIO */
    { 0x019623,  13, 0x01563d,  18,   -23090 }, /* VERR_CR_X509_OSSL_D2I_FAILED */
    { 0x01738f,  16, 0x01011b,  25,   -23037 }, /* VERR_CR_X509_CPB_BAD_CERT_CTX */
    { 0x00b49b,  32, 0x0035dd,  56,   -23036 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX */
    { 0x00b71b,  32, 0x00348d,  56,   -23035 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN */
    { 0x0099e6,  35, 0x003b3b,  54,   -23034 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE */
    { 0x0127c2,  21, 0x01165a,  23,   -23033 }, /* VERR_CR_X509_CPV_NOT_VALID_AT_TIME */
    { 0x0179dd,  15, 0x003841,  55,   -23032 }, /* VERR_CR_X509_CPV_ISSUER_MISMATCH */
    { 0x00f673,  26, 0x004fab,  49,   -23031 }, /* VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED */
    { 0x0124b6,  22, 0x00919d,  37,   -23030 }, /* VERR_CR_X509_CPV_NAME_NOT_PERMITTED */
    { 0x01131e,  23, 0x008f4d,  37,   -23029 }, /* VERR_CR_X509_CPV_NO_PERMITTED_NAMES */
    { 0x011daa,  22, 0x0084d6,  39,   -23028 }, /* VERR_CR_X509_CPV_INVALID_POLICY_MAPPING */
    { 0x0179bf,  15, 0x009787,  36,   -23027 }, /* VERR_CR_X509_CPV_NOT_V3_CERT */
    { 0x0179b0,  15, 0x005898,  47,   -23026 }, /* VERR_CR_X509_CPV_NOT_CA_CERT */
    { 0x011a7c,  22, 0x004b9e,  50,   -23025 }, /* VERR_CR_X509_CPV_MAX_PATH_LENGTH */
    { 0x011d3c,  22, 0x004b08,  50,   -23024 }, /* VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN */
    { 0x00f22f,  26, 0x010645,  24,   -23023 }, /* VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION */
    { 0x01431d,  20, 0x015ebe,  18,   -23022 }, /* VERR_CR_X509_CPV_NO_VALID_POLICY */
    { 0x01276e,  21, 0x014b72,  19,   -23021 }, /* VERR_CR_X509_CPV_NO_TRUSTED_PATHS */
    { 0x011615,  23, 0x005af5,  46,   -23020 }, /* VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY */
    { 0x00c145,  30, 0x0133e4,  21,   -23019 }, /* VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION */
    { 0x0146eb,  19, 0x00b4bb,  32,   -23018 }, /* VERR_CR_X509_VALIDITY_SWAPPED */
    { 0x013199,  21, 0x010e3c,  24,   -23017 }, /* VERR_CR_X509_NAME_EMPTY_SUB_SET */
    { 0x016123,  17, 0x014fd3,  19,   -23016 }, /* VERR_CR_X509_NAME_EMPTY_SET */
    { 0x01a8f2,  10, 0x017fe6,  15,   -23015 }, /* VERR_CR_X509_NAME_NOT_STRING */
    { 0x01813f,  15, 0x01abb8,  10,   -23014 }, /* VERR_CR_X509_NAME_EMPTY_STRING */
    { 0x018d1a,  14, 0x01a10b,  11,   -23013 }, /* VERR_CR_X509_INVALID_NAME_STRING_TAG */
    { 0x01368b,  20, 0x0148ff,  19,   -23012 }, /* VERR_CR_X509_PUBLIC_KEY_TOO_SMALL */
    { 0x0190f5,  13, 0x01bc50,   3,   -23011 }, /* VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION */
    { 0x008a57,  38, 0x00d2fc,  29,   -23010 }, /* VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS */
    { 0x00d8e7,  28, 0x0080b9,  39,   -23009 }, /* VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2 */
    { 0x011bb0,  22, 0x00b0bb,  32,   -23008 }, /* VERR_CR_X509_TBSCERT_EXTS_REQ_V3 */
    { 0x011180,  23, 0x001645,  69,   -23007 }, /* VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH */
    { 0x01475d,  19, 0x0132aa,  21,   -23006 }, /* VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH */
    { 0x015bef,  18, 0x01bc41,   3,   -23005 }, /* VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO */
    { 0x0175df,  16, 0x013e1e,  20,   -23004 }, /* VERR_CR_X509_NO_TRUST_ANCHOR */
    { 0x01a011,  12, 0x01469f,  19,   -23003 }, /* VERR_CR_X509_NOT_VERIFIED */
    { 0x017aa0,  15, 0x01ba16,   6,   -23002 }, /* VERR_CR_X509_CERTPATHS_INTERNAL_ERROR */
    { 0x01ba1c,   5, 0x01ba16,   6,   -23001 }, /* VERR_CR_X509_INTERNAL_ERROR */
    { 0x019b0d,  12, 0x01bc4a,   3,   -23000 }, /* VERR_CR_X509_GENERIC_ERROR */
    { 0x00cf05,  29, 0x00d12c,  29,   -22992 }, /* VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS */
    { 0x015c01,  18, 0x00c0eb,  30,   -22991 }, /* VERR_LDRLX_NRICHAIN_NOT_SUPPORTED */
    { 0x016211,  17, 0x01695f,  17,   -22990 }, /* VERR_LDRLX_BAD_FORWARDER */
    { 0x018e4e,  14, 0x01b371,   8,   -22989 }, /* VERR_LDRLX_BAD_SONAME */
    { 0x01858e,  14, 0x01b3a1,   8,   -22988 }, /* VERR_LDRLX_NO_SONAME */
    { 0x018cfe,  14, 0x01945c,  13,   -22987 }, /* VERR_LDRLX_BAD_BUNDLE */
    { 0x0160ce,  17, 0x00eb93,  27,   -22986 }, /* VERR_LDRLX_BAD_ITERDATA2 */
    { 0x0160ce,  16, 0x010198,  25,   -22985 }, /* VERR_LDRLX_BAD_ITERDATA */
    { 0x01a0b9,  12, 0x00fac2,  25,   -22984 }, /* VERR_LDRLX_BAD_PAGE_MAP */
    { 0x01387e,  20, 0x014f3b,  19,   -22983 }, /* VERR_LDRLX_BAD_OBJECT_TABLE */
    { 0x012f38,  21, 0x00902b,  37,   -22982 }, /* VERR_LDRLX_BAD_FIXUP_SECTION */
    { 0x012146,  22, 0x00b29b,  32,   -22981 }, /* VERR_LDRLX_BAD_LOADER_SECTION */
    { 0x018c72,  14, 0x0161cd,  17,   -22980 }, /* VERR_LDRLX_BAD_HEADER */
    { 0x012f77,  21, 0x016145,  17,   -22979 }, /* VERR_LDR_ADDRESS_OVERFLOW */
    { 0x01a4de,  11, 0x018ec6,  13,   -22978 }, /* VERR_LDR_BAD_FIXUP */
    { 0x016ac1,  16, 0x01b7e8,   7,   -22977 }, /* VERR_LDR_NO_IMAGE_UUID */
    { 0x00e24b,  27, 0x011899,  23,   -22976 }, /* VERR_LDR_DUPLICATE_SEGMENT_NAME */
    { 0x01a373,  11, 0x00dbf7,  28,   -22975 }, /* VERR_LDRMACHO_BAD_SYMTAB_SIZE */
    { 0x01b8c6,   6, 0x00e2ed,  27,   -22974 }, /* VERR_LDRMACHO_TODO */
    { 0x014c69,  19, 0x007e6a,  40,   -22973 }, /* VERR_LDRMACHO_NON_CONT_SEG_BITS */
    { 0x00dfde,  27, 0x007b72,  40,   -22972 }, /* VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS */
    { 0x01a866,  10, 0x01a0a1,  12,   -22971 }, /* VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE */
    { 0x01b048,   9, 0x017bcc,  15,   -22970 }, /* VERR_LDRMACHO_BAD_SYMBOL */
    { 0x01876a,  14, 0x016d40,  16,   -22969 }, /* VERR_LDRMACHO_BAD_OBJECT_FILE */
    { 0x01afb9,   9, 0x005fee,  45,   -22968 }, /* VERR_LDRMACHO_BIT_MIX */
    { 0x017240,  16, 0x005983,  47,   -22967 }, /* VERR_LDRMACHO_BAD_SECTION_ORDER */
    { 0x01a97e,  10, 0x00d75f,  28,   -22966 }, /* VERR_LDRMACHO_UNKNOWN_SECTION */
    { 0x018004,  15, 0x010341,  25,   -22965 }, /* VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION */
    { 0x017c62,  15, 0x00f757,  25,   -22964 }, /* VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION */
    { 0x01a9e2,  10, 0x01035a,  25,   -22963 }, /* VERR_LDRMACHO_UNSUPPORTED_SECTION */
    { 0x017240,  10, 0x01aeea,   9,   -22962 }, /* VERR_LDRMACHO_BAD_SECTION */
    { 0x0179ce,  15, 0x0094ff,  36,   -22961 }, /* VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND */
    { 0x017956,  15, 0x011266,  23,   -22960 }, /* VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND */
    { 0x017929,  15, 0x016464,  17,   -22959 }, /* VERR_LDRMACHO_BAD_LOAD_COMMAND */
    { 0x01a8a2,  10, 0x00471d,  51,   -22958 }, /* VERR_LDRMACHO_UNSUPPORTED_MACHINE */
    { 0x01bb3e,   5, 0x01a92e,  10,   -22957 }, /* VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE */
    { 0x01af8c,   9, 0x006ebb,  42,   -22956 }, /* VERR_LDRMACHO_BAD_HEADER */
    { 0x016398,  17, 0x009006,  37,   -22955 }, /* VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED */
    { 0x015c37,  18, 0x009cc5,  35,   -22954 }, /* VERR_LDR_FORWARDERS_NOT_SUPPORTED */
    { 0x0131ed,  21, 0x009c5c,  35,   -22953 }, /* VERR_LDR_FORWARDER_CHAIN_TOO_LONG */
    { 0x018121,  15, 0x00ee6d,  26,   -22952 }, /* VERR_LDR_BAD_FORWARDER */
    { 0x0179a1,  15, 0x012222,  22,   -22951 }, /* VERR_LDR_NOT_FORWARDER */
    { 0x0131ed,  14, 0x007cda,  40,   -22950 }, /* VERR_LDR_FORWARDER */
    { 0x018db4,  14, 0x00a7d8,  33,   -22930 }, /* VERR_LDRVI_BAD_CERT_FORMAT */
    { 0x0183ce,  14, 0x013806,  20,   -22929 }, /* VERR_LDRVI_IMAGE_HASH_MISMATCH */
    { 0x01ada6,   9, 0x0145f5,  19,   -22928 }, /* VERR_LDRVI_PAGE_HASH_MISMATCH */
    { 0x00a06f,  34, 0x0042e6,  52,   -22927 }, /* VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA */
    { 0x00db87,  28, 0x009d74,  35,   -22926 }, /* VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED */
    { 0x0161bc,  17, 0x006263,  44,   -22925 }, /* VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG */
    { 0x011e18,  22, 0x00ffbd,  25,   -22924 }, /* VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW */
    { 0x00920b,  36, 0x001150,  72,   -22923 }, /* VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID */
    { 0x01b539,   8, 0x019b49,  12,   -22922 }, /* VERR_LDRVI_PARSE_BER_ERROR */
    { 0x01b9c8,   6, 0x00d9ab,  28,   -22921 }, /* VERR_LDRVI_PARSE_IPE */
    { 0x01b6d0,   7, 0x0122bc,  22,   -22919 }, /* VERR_LDRVI_UNSUPPORTED_ARCH */
    { 0x010021,  25, 0x007ad2,  40,   -22918 }, /* VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH */
    { 0x00ffd6,  25, 0x006c69,  43,   -22917 }, /* VERR_LDRVI_SECTION_RAW_DATA_VALUES */
    { 0x016db0,  16, 0x0171b0,  16,   -22916 }, /* VERR_LDRVI_INVALID_SECTION_COUNT */
    { 0x0197dd,  12, 0x016f30,  16,   -22915 }, /* VERR_LDRVI_BAD_MZ_OFFSET */
    { 0x016c70,  16, 0x00c5b9,  30,   -22914 }, /* VERR_LDRVI_BAD_CERT_MULTIPLE */
    { 0x0196e6,  13, 0x016f30,  16,   -22913 }, /* VERR_LDRVI_BAD_CERT_HDR_TYPE */
    { 0x0135d7,  20, 0x016f30,  16,   -22912 }, /* VERR_LDRVI_BAD_CERT_HDR_REVISION */
    { 0x015dd5,  18, 0x016f30,  16,   -22911 }, /* VERR_LDRVI_BAD_CERT_HDR_LENGTH */
    { 0x013130,  21, 0x00fde2,  25,   -22910 }, /* VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY */
    { 0x019f45,  12, 0x00985f,  36,   -22909 }, /* VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT */
    { 0x01ac3a,  10, 0x00b7f7,  31,   -22908 }, /* VERR_LDRVI_NO_MEMORY_SHDRS */
    { 0x018d0c,  14, 0x004aa4,  50,   -22907 }, /* VERR_LDRVI_NO_MEMORY_SIGNATURE */
    { 0x01b9d4,   6, 0x00d62b,  28,   -22906 }, /* VERR_LDRVI_NO_MEMORY_STATE */
    { 0x01a5f1,  11, 0x00c7d5,  30,   -22905 }, /* VERR_LDRVI_FILE_LENGTH_ERROR */
    { 0x019143,  13, 0x00e215,  27,   -22904 }, /* VERR_LDRVI_READ_ERROR_HASH */
    { 0x0154fa,  18, 0x0061b0,  45,   -22903 }, /* VERR_LDRVI_READ_ERROR_SIGNATURE */
    { 0x0185c6,  14, 0x00f1ad,  26,   -22902 }, /* VERR_LDRVI_READ_ERROR_SHDRS */
    { 0x019801,  12, 0x00f297,  26,   -22901 }, /* VERR_LDRVI_READ_ERROR_HDR */
    { 0x01b036,   9, 0x00b21b,  32,   -22900 }, /* VERR_LDRVI_NOT_SIGNED */
    { 0x01b91a,   6, 0x01bbfd,   4,   -22899 }, /* VERR_ASN1_INTERNAL_ERROR_5 */
    { 0x01b920,   6, 0x01bbfd,   4,   -22898 }, /* VERR_ASN1_INTERNAL_ERROR_4 */
    { 0x01b926,   6, 0x01bbfd,   4,   -22897 }, /* VERR_ASN1_INTERNAL_ERROR_3 */
    { 0x01b93e,   6, 0x01bbfd,   4,   -22896 }, /* VERR_ASN1_INTERNAL_ERROR_2 */
    { 0x01b944,   6, 0x01bbfd,   4,   -22895 }, /* VERR_ASN1_INTERNAL_ERROR_1 */
    { 0x019ca5,  12, 0x01bc6d,   2,   -22857 }, /* VERR_ASN1_INVALID_INTEGER_ENCODING */
    { 0x01aee1,   9, 0x016750,  17,   -22856 }, /* VERR_ASN1_UNEXPECTED_OBJ_ID */
    { 0x016d50,  16, 0x01bc75,   2,   -22855 }, /* VERR_ASN1_TOO_DEEPLY_NESTED */
    { 0x01824d,  15, 0x015c6d,  18,   -22854 }, /* VERR_ASN1_INVALID_DATA_POINTER */
    { 0x013aea,  20, 0x019d71,  12,   -22853 }, /* VERR_ASN1_EXPECTED_PRIMITIVE */
    { 0x01b7da,   7, 0x0065d2,   1,   -22852 }, /* VERR_ASN1_TOO_LONG */
    { 0x018a18,  14, 0x01bc73,   2,   -22851 }, /* VERR_ASN1_DUMMY_OBJECT */
    { 0x018aea,  14, 0x0065d2,   1,   -22850 }, /* VERR_ASN1_DYNTYPE_BAD_TAG */
    { 0x01462e,  19, 0x01790b,  15,   -22849 }, /* VERR_ASN1_DYNTYPE_TAG_NOT_IMPL */
    { 0x018882,  14, 0x01bc6d,   2,   -22848 }, /* VERR_ASN1_INVALID_BITSTRING_ENCODING */
    { 0x01b117,   9, 0x01bc6d,   2,   -22847 }, /* VERR_ASN1_INVALID_NULL_ENCODING */
    { 0x019a65,  12, 0x01bc6d,   2,   -22846 }, /* VERR_ASN1_INVALID_BOOLEAN_ENCODING */
    { 0x012dbe,  21, 0x01bc6d,   2,   -22845 }, /* VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING */
    { 0x0193cd,  13, 0x01bc6d,   2,   -22844 }, /* VERR_ASN1_INVALID_UTC_TIME_ENCODING */
    { 0x015abd,  18, 0x016c10,  16,   -22843 }, /* VERR_ASN1_TIME_NORMALIZE_MISMATCH */
    { 0x015aab,  18, 0x01970d,  13,   -22842 }, /* VERR_ASN1_TIME_NORMALIZE_ERROR */
    { 0x010f41,  23, 0x01bc6b,   2,   -22841 }, /* VERR_ASN1_TIME_BAD_NORMALIZE_INPUT */
    { 0x00fd1a,  25, 0x0065d2,   1,   -22840 }, /* VERR_ASN1_BITSTRING_OUT_OF_BOUNDS */
    { 0x00fbee,  25, 0x01bc73,   2,   -22839 }, /* VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH */
    { 0x018c3a,  14, 0x01bc73,   2,   -22838 }, /* VERR_ASN1_CURSOR_TAG_MISMATCH */
    { 0x00c46f,  30, 0x006dbf,  42,   -22837 }, /* VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING */
    { 0x00f0f7,  26, 0x018cc6,  14,   -22836 }, /* VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT */
    { 0x0143bb,  19, 0x019d89,  12,   -22835 }, /* VERR_ASN1_CURSOR_NO_MORE_DATA */
    { 0x015d8d,  16, 0x0065d2,   1,   -22834 }, /* VERR_ASN1_CURSOR_BAD_LENGTH */
    { 0x00e53f,  27, 0x008fbc,  37,   -22833 }, /* VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH */
    { 0x00a448,  34, 0x008218,  39,   -22832 }, /* VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH */
    { 0x015d8d,  18, 0x01bc6b,   2,   -22831 }, /* VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING */
    { 0x015fe0,  17, 0x01b9da,   6,   -22830 }, /* VERR_ASN1_CURSOR_LONG_TAG */
    { 0x016b21,  16, 0x0065a7,  44,   -22829 }, /* VERR_ASN1_CURSOR_NOT_AT_END */
    { 0x01acbc,  10, 0x0065d2,   1,   -22828 }, /* VERR_ASN1_NOT_PRESENT */
    { 0x0124e2,  22, 0x0065d2,   1,   -22827 }, /* VERR_ASN1_NO_CHECK_SANITY_METHOD */
    { 0x01b0e1,   9, 0x0065d2,   1,   -22826 }, /* VERR_ASN1_NO_VTABLE */
    { 0x0158d7,  18, 0x017f05,  15,   -22825 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET */
    { 0x015943,  18, 0x00a7b7,  33,   -22824 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ */
    { 0x015285,  18, 0x00a712,  33,   -22823 }, /* VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ */
    { 0x019819,  12, 0x011c60,  22,   -22820 }, /* VERR_ASN1_TIME_TAG_MISMATCH */
    { 0x01af20,   9, 0x0158fb,  18,   -22819 }, /* VERR_ASN1_STRING_TAG_MISMATCH */
    { 0x012d01,  21, 0x00eb0c,  27,   -22818 }, /* VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL */
    { 0x016354,  17, 0x017c9e,  15,   -22817 }, /* VERR_ASN1_OBJID_INVALID_DOTTED_STRING */
    { 0x0140d9,  20, 0x00e977,  27,   -22816 }, /* VERR_ASN1_OBJID_TOO_LONG_STRING_FORM */
    { 0x014011,  20, 0x014796,  19,   -22815 }, /* VERR_ASN1_OBJID_TOO_MANY_COMPONENTS */
    { 0x011d68,  22, 0x016f40,  16,   -22814 }, /* VERR_ASN1_OBJID_COMPONENT_TOO_BIG */
    { 0x01a8fc,  10, 0x01bc6d,   2,   -22813 }, /* VERR_ASN1_INVALID_OBJID_ENCODING */
    { 0x01ad3e,  10, 0x01bc6d,   2,   -22812 }, /* VERR_ASN1_INVALID_BMP_STRING_ENCODING */
    { 0x01734f,  16, 0x01bc6d,   2,   -22811 }, /* VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING */
    { 0x018a26,  14, 0x01bc6d,   2,   -22810 }, /* VERR_ASN1_INVALID_GENERAL_STRING_ENCODING */
    { 0x018dde,  14, 0x01bc6d,   2,   -22809 }, /* VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING */
    { 0x0188e4,  14, 0x01bc6d,   2,   -22808 }, /* VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING */
    { 0x01ad2a,  10, 0x01bc6d,   2,   -22807 }, /* VERR_ASN1_INVALID_IA5_STRING_ENCODING */
    { 0x017e15,  15, 0x01bc6d,   2,   -22806 }, /* VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING */
    { 0x01a992,  10, 0x01bc6d,   2,   -22805 }, /* VERR_ASN1_INVALID_T61_STRING_ENCODING */
    { 0x0175af,  16, 0x01bc6d,   2,   -22804 }, /* VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING */
    { 0x018548,  14, 0x01bc6d,   2,   -22803 }, /* VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING */
    { 0x01a607,  11, 0x01bc6d,   2,   -22802 }, /* VERR_ASN1_INVALID_UTF8_STRING_ENCODING */
    { 0x01575d,  18, 0x01bc3e,   3,   -22801 }, /* VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED */
    { 0x01bc5f,   3, 0x011923,  23,   -22800 }, /* VERR_ASN1_ERROR */
    { 0x0099c3,  35, 0x00287e,  60,   -22739 }, /* VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH */
    { 0x00fec3,  25, 0x003d57,  54,   -22738 }, /* VERR_XAR_UNUSED_ARCHIVED_DATA */
    { 0x014115,  20, 0x006313,  44,   -22737 }, /* VERR_XAR_ARCHIVED_HASH_MISMATCH */
    { 0x0103a5,  25, 0x00d166,  29,   -22736 }, /* VERR_XAR_EXTRACTED_SIZE_EXCEEDED */
    { 0x012f8c,  21, 0x005d4b,  45,   -22735 }, /* VERR_XAR_EXTRACTED_HASH_MISMATCH */
    { 0x01a229,  11, 0x0175cf,  16,   -22734 }, /* VERR_XAR_INVALID_FILE_NAME */
    { 0x0198fd,  12, 0x014cb5,  19,   -22733 }, /* VERR_XAR_BAD_FILE_INODE */
    { 0x016c60,  16, 0x014255,  20,   -22732 }, /* VERR_XAR_BAD_FILE_DEVICE_NO */
    { 0x01ac12,  10, 0x012c83,  21,   -22731 }, /* VERR_XAR_BAD_FILE_GID */
    { 0x01acc6,  10, 0x01373f,  20,   -22730 }, /* VERR_XAR_BAD_FILE_UID */
    { 0x01a1bb,  11, 0x0167c7,  17,   -22729 }, /* VERR_XAR_BAD_FILE_MODE */
    { 0x01772e,  16, 0x01301f,  21,   -22728 }, /* VERR_XAR_BAD_FILE_TIMESTAMP */
    { 0x01b82e,   7, 0x00b92d,  31,   -22727 }, /* VERR_XAR_NO_ENCODING */
    { 0x01b399,   8, 0x01b2c9,   8,   -22726 }, /* VERR_XAR_UNKNOWN_FILE_TYPE */
    { 0x014d99,  19, 0x01386a,  20,   -22725 }, /* VERR_XAR_MISSING_DATA_ELEMENT */
    { 0x018dec,  14, 0x015553,  18,   -22724 }, /* VERR_XAR_BAD_FILE_ELEMENT */
    { 0x013dba,  20, 0x00fadb,  25,   -22723 }, /* VERR_XAR_BAD_LENGTH_ELEMENT */
    { 0x012e90,  21, 0x00ac7b,  32,   -22722 }, /* VERR_XAR_MISSING_LENGTH_ELEMENT */
    { 0x01808b,  15, 0x010f86,  23,   -22721 }, /* VERR_XAR_BAD_SIZE_ELEMENT */
    { 0x016c90,  16, 0x00c1f9,  30,   -22720 }, /* VERR_XAR_MISSING_SIZE_ELEMENT */
    { 0x0138a6,  20, 0x00fa5e,  25,   -22719 }, /* VERR_XAR_BAD_OFFSET_ELEMENT */
    { 0x01348c,  21, 0x00b4fb,  32,   -22718 }, /* VERR_XAR_MISSING_OFFSET_ELEMENT */
    { 0x00d044,  29, 0x0012b7,  71,   -22717 }, /* VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER */
    { 0x019220,  13, 0x011e44,  22,   -22716 }, /* VERR_XAR_BAD_DIGEST_LENGTH */
    { 0x013b8a,  20, 0x006e67,  42,   -22715 }, /* VERR_XAR_HASH_FUNCTION_MISMATCH */
    { 0x01269a,  22, 0x00be24,  31,   -22714 }, /* VERR_XAR_BAD_CHECKSUM_ELEMENT */
    { 0x01a116,  11, 0x016f60,  16,   -22713 }, /* VERR_XAR_TOC_DIGEST_MISMATCH */
    { 0x00ce00,  29, 0x0025a9,  61,   -22712 }, /* VERR_XML_TOC_ELEMENT_HAS_SIBLINGS */
    { 0x015703,  18, 0x0086ed,  38,   -22711 }, /* VERR_XML_TOC_ELEMENT_MISSING */
    { 0x01817b,  15, 0x00c2ad,  30,   -22710 }, /* VERR_XAR_TOC_XML_PARSE_ERROR */
    { 0x017875,  15, 0x012658,  22,   -22709 }, /* VERR_XAR_TOC_UTF8_ENCODING */
    { 0x01619a,  17, 0x007590,  41,   -22708 }, /* VERR_XAR_TOC_STRLEN_MISMATCH */
    { 0x014479,  19, 0x003253,  57,   -22707 }, /* VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH */
    { 0x010c75,  24, 0x0129f9,  21,   -22706 }, /* VERR_XAR_TOC_TOO_BIG_COMPRESSED */
    { 0x010c75,  13, 0x0174cf,  16,   -22705 }, /* VERR_XAR_TOC_TOO_BIG */
    { 0x017dd9,  15, 0x0072ab,  42,   -22704 }, /* VERR_XAR_TOC_TOO_SMALL */
    { 0x014c0a,  19, 0x0153c8,  18,   -22703 }, /* VERR_XAR_UNSUPPORTED_HASH_FUNCTION */
    { 0x01b83c,   7, 0x01b090,   9,   -22702 }, /* VERR_XAR_UNSUPPORTED_VERSION */
    { 0x01a3e1,  11, 0x01b6bb,   7,   -22701 }, /* VERR_XAR_BAD_HDR_SIZE */
    { 0x016a91,  16, 0x018fd7,  13,   -22700 }, /* VERR_XAR_WRONG_MAGIC */
    { 0x0149d0,  19, 0x008b87,  38,   -22600 }, /* VERR_FILESYSTEM_CORRUPT */
    { 0x011027,  23, 0x01474a,  19,   -22503 }, /* VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY */
    { 0x017992,  15, 0x01abc2,  10,   -22502 }, /* VERR_SYS_SHUTDOWN_FAILED */
    { 0x012dfd,  21, 0x0087f7,  38,   -22500 }, /* VERR_SYS_CANNOT_POWER_OFF */
    { 0x00f485,  26, 0x003136,  57,   -22430 }, /* VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION */
    { 0x0182b6,  15, 0x017f50,  15,   -22429 }, /* VERR_INSTALLATION_FAILED */
    { 0x018b76,  14, 0x0168c6,  17,   -22428 }, /* VERR_REBOOT_NEEDED */
    { 0x017938,  15, 0x00f0a9,  26,   -22427 }, /* VERR_FLOAT_OVERFLOW */
    { 0x016cb0,  16, 0x00e3c5,  27,   -22426 }, /* VERR_FLOAT_UNDERFLOW */
    { 0x011cce,  22, 0x00296e,  59,   -22425 }, /* VERR_PROC_NO_ARG_TRANSLATION */
    { 0x011b2c,  22, 0x0128a9,  21,   -22424 }, /* VERR_THREAD_IS_TERMINATING */
    { 0x01979c,  13, 0x00fe91,  25,   -22423 }, /* VERR_TOO_MANY_REFERENCES */
    { 0x01b559,   8, 0x019247,  13,   -22422 }, /* VERR_EMPTY_STRING */
    { 0x0185b8,  14, 0x006f63,  42,   -22421 }, /* VERR_NO_STRING_TERMINATOR */
    { 0x0139fa,  20, 0x008c1f,  37,   -22420 }, /* VERR_INCOMPATIBLE_CONFIG */
    { 0x010825,  24, 0x00f145,  26,   -22419 }, /* VERR_PROC_ELEVATION_REQUIRED */
    { 0x019ecd,  12, 0x01a059,  12,   -22418 }, /* VERR_INVALID_SESSION_ID */
    { 0x01a3f7,  11, 0x01a213,  11,   -22417 }, /* VERR_INVALID_CLIENT_ID */
    { 0x015ca3,  18, 0x012cd7,  21,   -22416 }, /* VERR_WRONG_PARAMETER_TYPE */
    { 0x011b84,  22, 0x0125a8,  22,   -22415 }, /* VERR_WRONG_PARAMETER_COUNT */
    { 0x01ad66,  10, 0x016e10,  16,   -22414 }, /* VERR_MP_TOO_MANY_CPUS */
    { 0x014bbe,  19, 0x000e72,  75,   -22413 }, /* VERR_PROC_IQ_PRIV_NOT_HELD */
    { 0x013aae,  20, 0x000c04,  80,   -22412 }, /* VERR_PROC_APT_PRIV_NOT_HELD */
    { 0x0135c3,  20, 0x0003ea, 104,   -22411 }, /* VERR_PROC_TCB_PRIV_NOT_HELD */
    { 0x01758f,  16, 0x0030c2,  58,   -22410 }, /* VERR_PRIVILEGE_NOT_HELD */
    { 0x01b3b1,   8, 0x01a1fd,  11,   -22409 }, /* VERR_WRONG_TYPE */
    { 0x01bc71,   2, 0x01ae51,   9,   -22408 }, /* VERR_MISMATCH */
    { 0x01735f,  16, 0x014d86,  19,   -22407 }, /* VERR_ALLOCATION_TOO_BIG */
    { 0x00b7d8,  31, 0x005dd2,  45,   -22406 }, /* VERR_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x015175,  19, 0x008a31,  38,   -22405 }, /* VERR_ACCOUNT_RESTRICTED */
    { 0x01807c,  15, 0x009b21,  35,   -22404 }, /* VERR_PROC_DETACH_NOT_SUPPORTED */
    { 0x01a47b,  11, 0x0073cd,  41,   -22403 }, /* VERR_NOT_AVAILABLE */
    { 0x0191c5,  13, 0x018ffe,  13,   -22402 }, /* VERR_UNEVEN_INPUT */
    { 0x016563,  17, 0x016255,  17,   -22401 }, /* VERR_BUFFER_UNDERFLOW */
    { 0x01a28c,  11, 0x006ae6,  43,   -22400 }, /* VERR_UNEXPECTED_EXCEPTION */
    { 0x01b219,   8, 0x015fcf,  17,   -22360 }, /* VERR_CR_PKCS7_NOT_DATA */
    { 0x00ff72,  25, 0x0079ba,  40,   -22359 }, /* VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH */
    { 0x011826,  23, 0x008107,  39,   -22358 }, /* VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED */
    { 0x00ae7b,  32, 0x005f0d,  45,   -22357 }, /* VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO */
    { 0x016c20,  16, 0x00ce57,  29,   -22356 }, /* VERR_CR_PKCS7_SIGNER_INFO_VERSION */
    { 0x00df06,  27, 0x005341,  48,   -22355 }, /* VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO */
    { 0x0160f0,  17, 0x00caf1,  29,   -22354 }, /* VERR_CR_PKCS7_EXPECTED_NO_CRLS */
    { 0x0176af,  16, 0x007471,  41,   -22353 }, /* VERR_CR_PKCS7_NO_CERTIFICATES */
    { 0x018c02,  14, 0x010a4d,  24,   -22352 }, /* VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM */
    { 0x0123c4,  22, 0x0080e0,  39,   -22351 }, /* VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS */
    { 0x01773e,  16, 0x01022e,  25,   -22350 }, /* VERR_CR_PKCS7_SIGNED_DATA_VERSION */
    { 0x01a78a,  10, 0x009e69,  35,   -22320 }, /* VERR_CR_PKCS7_DIGEST_CALC_ERROR */
    { 0x0199bd,  12, 0x011169,  23,   -22319 }, /* VERR_CR_PKCS7_DIGEST_CREATE_ERROR */
    { 0x016e40,  16, 0x006cbf,  43,   -22318 }, /* VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS */
    { 0x017fc8,  15, 0x0077f7,  41,   -22317 }, /* VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS */
    { 0x017a19,  15, 0x01041e,  24,   -22316 }, /* VERR_CR_PKCS7_NOT_SIGNED_DATA */
    { 0x01481b,  19, 0x00269d,  61,   -22315 }, /* VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST */
    { 0x017220,  16, 0x005da5,  45,   -22314 }, /* VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL */
    { 0x017270,  16, 0x0152a9,  18,   -22313 }, /* VERR_CR_PKCS7_OSSL_VERIFY_FAILED */
    { 0x019700,  13, 0x014854,  19,   -22312 }, /* VERR_CR_PKCS7_OSSL_D2I_FAILED */
    { 0x01baee,   5, 0x01a7d0,  10,   -22311 }, /* VERR_CR_PKCS7_INTERNAL_ERROR */
    { 0x017d07,  15, 0x00d1da,  29,   -22300 }, /* VERR_LOG_REVISION_MISMATCH */
    { 0x01748f,  16, 0x00be43,  31,   -22201 }, /* VERR_DVM_MAP_NO_VOLUME */
    { 0x018388,  14, 0x00b07b,  32,   -22200 }, /* VERR_DVM_MAP_EMPTY */
    { 0x012ea5,  21, 0x00328c,  57,   -22158 }, /* VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT */
    { 0x018e6a,  14, 0x00fc9d,  25,   -22157 }, /* VERR_VFS_CHAIN_NOT_PATH_ONLY */
    { 0x016684,  17, 0x0019fa,  67,   -22156 }, /* VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY */
    { 0x018eb9,  13, 0x000bb4,  80,   -22155 }, /* VERR_VFS_CHAIN_PATH_ONLY */
    { 0x015b4d,  18, 0x00233f,  62,   -22154 }, /* VERR_VFS_CHAIN_WRITE_ONLY_IOS */
    { 0x01650e,  17, 0x001198,  72,   -22153 }, /* VERR_VFS_CHAIN_READ_ONLY_IOS */
    { 0x0102f6,  25, 0x0018ee,  67,   -22152 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS */
    { 0x015458,  18, 0x00654f,  44,   -22151 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_VFS */
    { 0x01a142,  11, 0x0097f3,  36,   -22150 }, /* VERR_VFS_CHAIN_TAKES_VFS */
    { 0x0195d5,  13, 0x006d15,  43,   -22149 }, /* VERR_VFS_CHAIN_TAKES_FSS */
    { 0x0102f6,  13, 0x00d0d5,  29,   -22148 }, /* VERR_VFS_CHAIN_TAKES_DIR */
    { 0x016134,  17, 0x007352,  41,   -22147 }, /* VERR_VFS_CHAIN_TAKES_FILE_OR_IOS */
    { 0x018468,  14, 0x011501,  23,   -22146 }, /* VERR_VFS_CHAIN_TAKES_FILE */
    { 0x016981,  17, 0x00304e,  58,   -22145 }, /* VERR_VFS_CHAIN_ONLY_DIR_OR_VFS */
    { 0x011477,  23, 0x00304e,  58,   -22144 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR */
    { 0x01a906,  10, 0x007a32,  40,   -22143 }, /* VERR_VFS_CHAIN_ONLY_VFS */
    { 0x0198d9,  12, 0x0055d7,  47,   -22142 }, /* VERR_VFS_CHAIN_ONLY_FSS */
    { 0x016981,  12, 0x00a8df,  33,   -22141 }, /* VERR_VFS_CHAIN_ONLY_DIR */
    { 0x01989d,  12, 0x006cea,  43,   -22140 }, /* VERR_VFS_CHAIN_ONLY_IOS */
    { 0x011477,  16, 0x0061dd,  45,   -22139 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS */
    { 0x01949d,  13, 0x011a92,  22,   -22138 }, /* VERR_VFS_CHAIN_INVALID_ARGUMENT */
    { 0x01933e,  13, 0x010675,  24,   -22137 }, /* VERR_VFS_CHAIN_EMPTY_ARG */
    { 0x01a88e,  10, 0x0152bb,  18,   -22136 }, /* VERR_VFS_CHAIN_TOO_MANY_ARGS */
    { 0x019177,  13, 0x0152bb,  18,   -22135 }, /* VERR_VFS_CHAIN_TOO_FEW_ARGS */
    { 0x013d7e,  20, 0x0152bb,  18,   -22134 }, /* VERR_VFS_CHAIN_AT_MOST_SIX_ARGS */
    { 0x012fe0,  21, 0x014cee,  19,   -22133 }, /* VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS */
    { 0x01a005,  12, 0x01120a,  23,   -22132 }, /* VERR_VFS_CHAIN_SIX_ARGS */
    { 0x012b87,  21, 0x014e57,  19,   -22131 }, /* VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS */
    { 0x011b6e,  22, 0x013fe9,  20,   -22130 }, /* VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS */
    { 0x018eac,  13, 0x01044e,  24,   -22129 }, /* VERR_VFS_CHAIN_FIVE_ARGS */
    { 0x012e3c,  21, 0x014596,  19,   -22128 }, /* VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS */
    { 0x012172,  22, 0x013bda,  20,   -22127 }, /* VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS */
    { 0x019358,  13, 0x010436,  24,   -22126 }, /* VERR_VFS_CHAIN_FOUR_ARGS */
    { 0x011ffc,  22, 0x0136b3,  20,   -22125 }, /* VERR_VFS_CHAIN_AT_MOST_THREE_ARGS */
    { 0x011055,  23, 0x012c1a,  21,   -22124 }, /* VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS */
    { 0x018c1e,  14, 0x0100e9,  25,   -22123 }, /* VERR_VFS_CHAIN_THREE_ARGS */
    { 0x0139be,  20, 0x015339,  18,   -22122 }, /* VERR_VFS_CHAIN_AT_MOST_TWO_ARGS */
    { 0x012c2f,  21, 0x014de5,  19,   -22121 }, /* VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS */
    { 0x019c45,  12, 0x0113bf,  23,   -22120 }, /* VERR_VFS_CHAIN_TWO_ARGS */
    { 0x013afe,  20, 0x00deeb,  27,   -22119 }, /* VERR_VFS_CHAIN_AT_LEAST_ONE_ARG */
    { 0x014bd1,  19, 0x00eeef,  26,   -22118 }, /* VERR_VFS_CHAIN_AT_MOST_ONE_ARG */
    { 0x01a6c2,  11, 0x00b90e,  31,   -22117 }, /* VERR_VFS_CHAIN_ONE_ARG */
    { 0x01b0ea,   9, 0x018b5a,  14,   -22116 }, /* VERR_VFS_CHAIN_NO_ARGS */
    { 0x018fe4,  13, 0x00ba44,  31,   -22115 }, /* VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH */
    { 0x017857,  15, 0x01804f,  15,   -22114 }, /* VERR_VFS_CHAIN_PROVIDER_NOT_FOUND */
    { 0x01b827,   7, 0x01b571,   8,   -22113 }, /* VERR_VFS_CHAIN_IPE */
    { 0x01ab0e,  10, 0x01af29,   9,   -22112 }, /* VERR_VFS_CHAIN_CAST_FAILED */
    { 0x00e080,  27, 0x00e02f,  27,   -22111 }, /* VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT */
    { 0x00fc20,  25, 0x0071d9,  42,   -22110 }, /* VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT */
    { 0x011abe,  22, 0x00b9e7,  31,   -22109 }, /* VERR_VFS_CHAIN_TRAILING_SEPARATOR */
    { 0x012759,  21, 0x00c541,  30,   -22108 }, /* VERR_VFS_CHAIN_LEADING_SEPARATOR */
    { 0x011dec,  22, 0x013fd5,  20,   -22107 }, /* VERR_VFS_CHAIN_EXPECTED_SEPARATOR */
    { 0x00f68d,  26, 0x0160ac,  17,   -22106 }, /* VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME */
    { 0x00c163,  30, 0x01322c,  21,   -22105 }, /* VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES */
    { 0x00ce91,  29, 0x013c2a,  20,   -22104 }, /* VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES */
    { 0x01b9a4,   6, 0x01974e,  13,   -22103 }, /* VERR_VFS_CHAIN_UNKNOWN_TYPE */
    { 0x0142f5,  20, 0x01a7bc,  10,   -22102 }, /* VERR_VFS_CHAIN_EXPECTED_ELEMENT */
    { 0x01933e,   9, 0x00f7bb,  25,   -22101 }, /* VERR_VFS_CHAIN_EMPTY */
    { 0x01a71a,  11, 0x007bea,  40,   -22100 }, /* VERR_VFS_CHAIN_NO_PREFIX */
    { 0x0198f1,  12, 0x009ab8,  35,   -22005 }, /* VERR_ZIP_BAD_HEADER */
    { 0x019b91,  12, 0x00a754,  33,   -22004 }, /* VERR_ZIP_UNSUPPORTED_METHOD */
    { 0x01b6f3,   7, 0x00a4d0,  34,   -22003 }, /* VERR_ZIP_UNSUPPORTED_VERSION */
    { 0x01b70f,   7, 0x0068b7,  43,   -22002 }, /* VERR_ZIP_NO_MEMORY */
    { 0x018dc2,  14, 0x01047e,  24,   -22001 }, /* VERR_ZIP_CORRUPTED */
    { 0x01b998,   6, 0x01b9e0,   6,   -22000 }, /* VERR_ZIP_ERROR */
    { 0x019476,  13, 0x005e86,  45,    -7602 }, /* VERR_GCM_NOT_HANDLED */
    { 0x016387,  17, 0x009c39,  35,    -7400 }, /* VERR_PLATFORM_ARCH_NOT_SUPPORTED */
    { 0x01ba3f,   5, 0x01b5e9,   8,    -7399 }, /* VERR_IOMMU_IPE_9 */
    { 0x01ba44,   5, 0x01b169,   8,    -7398 }, /* VERR_IOMMU_IPE_8 */
    { 0x01ba49,   5, 0x01b409,   8,    -7397 }, /* VERR_IOMMU_IPE_7 */
    { 0x01ba4e,   5, 0x01b209,   8,    -7396 }, /* VERR_IOMMU_IPE_6 */
    { 0x01ba53,   5, 0x01b5c1,   8,    -7395 }, /* VERR_IOMMU_IPE_5 */
    { 0x01ba58,   5, 0x01b4b9,   8,    -7394 }, /* VERR_IOMMU_IPE_4 */
    { 0x01ba5d,   5, 0x01b389,   8,    -7393 }, /* VERR_IOMMU_IPE_3 */
    { 0x01ba62,   5, 0x01b269,   8,    -7392 }, /* VERR_IOMMU_IPE_2 */
    { 0x01baa8,   5, 0x01b151,   8,    -7391 }, /* VERR_IOMMU_IPE_1 */
    { 0x01baad,   5, 0x01b339,   8,    -7390 }, /* VERR_IOMMU_IPE_0 */
    { 0x01482e,  19, 0x000f07,  74,    -7310 }, /* VERR_IOMMU_CANNOT_CALL_SELF */
    { 0x01a2fa,  11, 0x01904c,  13,    -7309 }, /* VERR_IOMMU_NOT_PRESENT */
    { 0x01a2ef,  11, 0x00fcb6,  25,    -7308 }, /* VERR_IOMMU_CMD_HW_ERROR */
    { 0x018a88,  14, 0x006e3d,  42,    -7307 }, /* VERR_IOMMU_CMD_INVALID_FORMAT */
    { 0x01adb8,   9, 0x01a802,  10,    -7306 }, /* VERR_IOMMU_CMD_NOT_SUPPORTED */
    { 0x013ed2,  20, 0x001866,  68,    -7305 }, /* VERR_IOMMU_INTR_REMAP_DENIED */
    { 0x017c08,  15, 0x011335,  23,    -7304 }, /* VERR_IOMMU_INTR_REMAP_FAILED */
    { 0x0132e9,  21, 0x010615,  24,    -7303 }, /* VERR_IOMMU_ADDR_ACCESS_DENIED */
    { 0x0133bb,  21, 0x013049,  21,    -7302 }, /* VERR_IOMMU_ADDR_TRANSLATION_FAILED */
    { 0x0185e2,  14, 0x00fe14,  25,    -7301 }, /* VERR_IOMMU_DTE_BAD_OFFSET */
    { 0x019372,  13, 0x01086d,  24,    -7300 }, /* VERR_IOMMU_DTE_READ_FAILED */
    { 0x011083,  23, 0x008413,  39,    -7206 }, /* VERR_PDM_CRITSECTRW_MISALIGNED */
    { 0x016fa0,  16, 0x00bbb8,  31,    -7205 }, /* VERR_PDM_CRITSECTRW_IPE */
    { 0x01014d,  25, 0x001c49,  65,    -7204 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS */
    { 0x0120d8,  22, 0x00680b,  43,    -7203 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS */
    { 0x012104,  22, 0x006473,  44,    -7202 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_READERS */
    { 0x0157b7,  18, 0x008f03,  37,    -7201 }, /* VERR_PDM_CRITSECT_ABORT_FAILED */
    { 0x0193f4,  13, 0x00bd2c,  31,    -7153 }, /* VERR_SHCLPB_NO_DATA */
    { 0x017a64,  15, 0x00f8e7,  25,    -7152 }, /* VERR_SHCLPB_EVENT_FAILED */
    { 0x017d61,  15, 0x014f4e,  19,    -7151 }, /* VERR_SHCLPB_GUEST_ERROR */
    { 0x01203e,  22, 0x00bcb0,  31,    -7150 }, /* VERR_SHCLPB_TRANSFER_ID_NOT_FOUND */
    { 0x00f5a3,  26, 0x002dcf,  59,    -7106 }, /* VERR_SHCLPB_MAX_EVENTS_REACHED */
    { 0x014bf7,  19, 0x00d9ff,  28,    -7105 }, /* VERR_SHCLPB_EVENT_ID_NOT_FOUND */
    { 0x00ee1f,  26, 0x006963,  43,    -7104 }, /* VERR_SHCLPB_OBJ_HANDLE_INVALID */
    { 0x00ea19,  27, 0x007b4a,  40,    -7103 }, /* VERR_SHCLPB_LIST_HANDLE_INVALID */
    { 0x00f94b,  25, 0x006c94,  43,    -7102 }, /* VERR_SHCLPB_MAX_LISTS_REACHED */
    { 0x00e524,  27, 0x005e2c,  45,    -7101 }, /* VERR_SHCLPB_MAX_OBJECTS_REACHED */
    { 0x00ce1d,  29, 0x00481a,  50,    -7100 }, /* VERR_SHCLPB_MAX_TRANSFERS_REACHED */
    { 0x0105b5,  24, 0x007d52,  40,    -7000 }, /* VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT */
    { 0x018b92,  14, 0x01a326,  11,    -6908 }, /* VERR_RECORDING_ENCODING_FAILED */
    { 0x013bb2,  20, 0x006237,  44,    -6907 }, /* VERR_RECORDING_THROTTLED */
    { 0x0106bd,  24, 0x00b19b,  32,    -6906 }, /* VERR_RECORDING_LIMIT_REACHED */
    { 0x012b5d,  21, 0x00633f,  44,    -6905 }, /* VERR_RECORDING_RESTRICTED */
    { 0x013cde,  20, 0x00eccd,  26,    -6904 }, /* VERR_RECORDING_FORMAT_NOT_SUPPORTED */
    { 0x01501f,  19, 0x01af5f,   9,    -6903 }, /* VERR_RECORDING_CODEC_NOT_SUPPORTED */
    { 0x011a37,  23, 0x01245e,  22,    -6902 }, /* VERR_RECORDING_CODEC_INIT_FAILED */
    { 0x016794,  17, 0x00f39b,  26,    -6901 }, /* VERR_RECORDING_INIT_FAILED */
    { 0x014c43,  19, 0x01af4d,   9,    -6900 }, /* VERR_RECORDING_CODEC_NOT_FOUND */
    { 0x01ba67,   5, 0x01b2f1,   8,    -6899 }, /* VERR_NEM_IPE_9 */
    { 0x01ba6c,   5, 0x01b549,   8,    -6898 }, /* VERR_NEM_IPE_8 */
    { 0x01ba71,   5, 0x01b231,   8,    -6897 }, /* VERR_NEM_IPE_7 */
    { 0x01ba76,   5, 0x01b341,   8,    -6896 }, /* VERR_NEM_IPE_6 */
    { 0x01ba85,   5, 0x01b5f1,   8,    -6895 }, /* VERR_NEM_IPE_5 */
    { 0x01ba8a,   5, 0x01b161,   8,    -6894 }, /* VERR_NEM_IPE_4 */
    { 0x01ba8f,   5, 0x01b421,   8,    -6893 }, /* VERR_NEM_IPE_3 */
    { 0x01ba99,   5, 0x01b201,   8,    -6892 }, /* VERR_NEM_IPE_2 */
    { 0x01ba9e,   5, 0x01b5b9,   8,    -6891 }, /* VERR_NEM_IPE_1 */
    { 0x01baa3,   5, 0x01b4c1,   8,    -6890 }, /* VERR_NEM_IPE_0 */
    { 0x019cf9,  12, 0x007d7a,  40,    -6817 }, /* VERR_NEM_MISSING_FEATURE */
    { 0x011294,  23, 0x0107f5,  24,    -6816 }, /* VERR_NEM_QUERY_DIRTY_BITMAP_FAILED */
    { 0x0166ea,  17, 0x00a1e4,  34,    -6815 }, /* VERR_NEM_MISSING_KERNEL_API_5 */
    { 0x01683e,  17, 0x00a2b0,  34,    -6814 }, /* VERR_NEM_MISSING_KERNEL_API_4 */
    { 0x016761,  17, 0x00a3e2,  34,    -6813 }, /* VERR_NEM_MISSING_KERNEL_API_3 */
    { 0x01671d,  17, 0x00a624,  34,    -6812 }, /* VERR_NEM_MISSING_KERNEL_API_2 */
    { 0x01ab2c,  10, 0x019ced,  12,    -6811 }, /* VERR_NEM_SET_TSC */
    { 0x01a071,  12, 0x007753,  41,    -6810 }, /* VERR_NEM_FLUSH_TLB */
    { 0x0157c9,  18, 0x015d9f,  18,    -6809 }, /* VERR_NEM_SET_REGISTERS_FAILED */
    { 0x0157ff,  18, 0x015979,  18,    -6808 }, /* VERR_NEM_GET_REGISTERS_FAILED */
    { 0x016b61,  16, 0x00e70a,  27,    -6807 }, /* VERR_NEM_UNMAP_PAGES_FAILED */
    { 0x018e40,  14, 0x0100d0,  25,    -6806 }, /* VERR_NEM_MAP_PAGES_FAILED */
    { 0x019331,  13, 0x00b94c,  31,    -6805 }, /* VERR_NEM_VM_CREATE_FAILED */
    { 0x01940e,  13, 0x00b98a,  31,    -6804 }, /* VERR_NEM_RING3_ONLY */
    { 0x01670c,  17, 0x00a091,  34,    -6803 }, /* VERR_NEM_MISSING_KERNEL_API_1 */
    { 0x01b0f3,   9, 0x01b581,   8,    -6802 }, /* VERR_NEM_INIT_FAILED */
    { 0x019741,  13, 0x01882e,  14,    -6801 }, /* VERR_NEM_NOT_AVAILABLE */
    { 0x01a2d9,  11, 0x019999,  12,    -6800 }, /* VERR_NEM_NOT_ENABLED */
    { 0x013e46,  20, 0x00dd9b,  28,    -6702 }, /* VERR_APIC_INTR_DISCARDED */
    { 0x010406,  24, 0x00bc91,  31,    -6701 }, /* VERR_APIC_INTR_MASKED_BY_TPR */
    { 0x014d01,  19, 0x014938,  19,    -6700 }, /* VERR_APIC_INTR_NOT_PENDING */
    { 0x00c86b,  30, 0x004c02,  50,    -6608 }, /* VERR_AUDIO_STREAM_INIT_IN_PROGRESS */
    { 0x013c02,  20, 0x013295,  21,    -6607 }, /* VERR_AUDIO_ENUMERATION_FAILED */
    { 0x00df3c,  27, 0x01158b,  23,    -6606 }, /* VERR_AUDIO_STREAM_COULD_NOT_CREATE */
    { 0x014269,  20, 0x015541,  18,    -6605 }, /* VERR_AUDIO_STREAM_NOT_READY */
    { 0x00d061,  29, 0x00a13b,  34,    -6604 }, /* VERR_AUDIO_STREAM_PENDING_DISABLE */
    { 0x00e4ee,  27, 0x013073,  21,    -6603 }, /* VERR_AUDIO_NO_FREE_OUTPUT_STREAMS */
    { 0x00f027,  26, 0x0142cd,  20,    -6602 }, /* VERR_AUDIO_NO_FREE_INPUT_STREAMS */
    { 0x01059d,  24, 0x009e00,  35,    -6601 }, /* VERR_AUDIO_BACKEND_NOT_ATTACHED */
    { 0x012adf,  21, 0x009ce8,  35,    -6600 }, /* VERR_AUDIO_BACKEND_INIT_FAILED */
    { 0x019d65,  12, 0x011ec8,  22,    -6500 }, /* VERR_DND_GUEST_ERROR */
    { 0x00d8af,  28, 0x00398b,  54,    -6401 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_IPE */
    { 0x00c37f,  30, 0x0059e1,  46,    -6400 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR */
    { 0x012840,  21, 0x003765,  55,    -6318 }, /* VERR_GIM_INVALID_HYPERCALL_INSTR */
    { 0x011ef4,  22, 0x00ca60,  29,    -6315 }, /* VERR_GIM_NO_DEBUG_CONNECTION */
    { 0x01747f,  16, 0x0141dd,  20,    -6314 }, /* VERR_GIM_HYPERCALL_FAILED */
    { 0x01062d,  24, 0x0053a1,  48,    -6313 }, /* VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED */
    { 0x01162c,  23, 0x0054ec,  47,    -6312 }, /* VERR_GIM_HYPERCALL_MEMORY_READ_FAILED */
    { 0x00ddb7,  28, 0x002fda,  58,    -6311 }, /* VERR_GIM_HYPERCALL_ACCESS_DENIED */
    { 0x011124,  23, 0x006f8d,  42,    -6310 }, /* VERR_GIM_DEVICE_NOT_REGISTERED */
    { 0x010e9c,  24, 0x00e13d,  27,    -6309 }, /* VERR_GIM_HYPERCALLS_NOT_ENABLED */
    { 0x00ec4b,  26, 0x00adfb,  32,    -6308 }, /* VERR_GIM_HYPERCALLS_NOT_AVAILABLE */
    { 0x0174bf,  16, 0x018cb8,  14,    -6307 }, /* VERR_GIM_OPERATION_FAILED */
    { 0x018cd4,  14, 0x016d90,  16,    -6306 }, /* VERR_GIM_INVALID_PROVIDER */
    { 0x01513c,  19, 0x00932b,  36,    -6305 }, /* VERR_GIM_PVTSC_NOT_ENABLED */
    { 0x01286a,  21, 0x0076af,  41,    -6304 }, /* VERR_GIM_PVTSC_NOT_AVAILABLE */
    { 0x01b6d7,   7, 0x01aa28,  10,    -6303 }, /* VERR_GIM_IPE_3 */
    { 0x01b708,   7, 0x01a7b2,  10,    -6302 }, /* VERR_GIM_IPE_2 */
    { 0x01b732,   7, 0x01a820,  10,    -6301 }, /* VERR_GIM_IPE_1 */
    { 0x019505,  13, 0x009f3b,  35,    -6300 }, /* VERR_GIM_NOT_ENABLED */
    { 0x00fa13,  25, 0x008901,  38,    -6225 }, /* VERR_GSTCTL_PROCESS_EXIT_CODE */
    { 0x00d214,  29, 0x00662b,  44,    -6224 }, /* VERR_GSTCTL_MAX_CID_COUNT_REACHED */
    { 0x00b7b9,  31, 0x0068e2,  43,    -6223 }, /* VERR_GSTCTL_MAX_CID_OBJECTS_REACHED */
    { 0x00ae1b,  32, 0x006707,  44,    -6222 }, /* VERR_GSTCTL_MAX_CID_SESSIONS_REACHED */
    { 0x011a4e,  23, 0x0115e7,  23,    -6221 }, /* VERR_GSTCTL_PROCESS_WRONG_STATE */
    { 0x017839,  15, 0x011ec8,  22,    -6200 }, /* VERR_GSTCTL_GUEST_ERROR */
    { 0x0163ba,  17, 0x0051f1,  48,    -6001 }, /* VERR_EXTPACK_VBOX_VERSION_MISMATCH */
    { 0x0104de,  24, 0x01aed8,   9,    -6000 }, /* VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL */
    { 0x019e6d,  12, 0x01065d,  24,    -5699 }, /* VERR_SUP_DRIVERLESS */
    { 0x0089e5,  38, 0x00063d,  95,    -5679 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT */
    { 0x010ff9,  23, 0x00a37c,  34,    -5678 }, /* VERR_SUP_VP_SET_HANDLE_NOINHERIT */
    { 0x01608a,  17, 0x013f35,  20,    -5677 }, /* VERR_SUP_VP_QUERY_HANDLE_TYPE */
    { 0x0133a6,  21, 0x0143f4,  19,    -5676 }, /* VERR_SUP_VP_UNDESIRABLE_MODULE */
    { 0x01050e,  24, 0x003dc3,  53,    -5675 }, /* VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED */
    { 0x01a9c4,  10, 0x017050,  16,    -5674 }, /* VERR_SUP_VP_FILE_MODE_ERROR */
    { 0x012080,  22, 0x00019d, 125,    -5673 }, /* VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED */
    { 0x0131d8,  21, 0x001460,  70,    -5672 }, /* VERR_SUP_VP_STUB_THREAD_OPEN_ERROR */
    { 0x0162ee,  17, 0x000fe5,  73,    -5671 }, /* VERR_SUP_VP_STUB_THREAD_NOT_FOUND */
    { 0x01860c,  14, 0x00204d,  63,    -5670 }, /* VERR_SUP_VP_STUB_OPEN_ERROR */
    { 0x01a910,  10, 0x001a3d,  66,    -5669 }, /* VERR_SUP_VP_STUB_NOT_FOUND */
    { 0x0196cc,  13, 0x014f28,  19,    -5668 }, /* VERR_SUP_VP_IMAGE_TOO_BIG */
    { 0x00c703,  30, 0x006c3e,  43,    -5667 }, /* VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER */
    { 0x01826b,  15, 0x008db6,  37,    -5666 }, /* VERR_SUP_VP_UNKOWN_MEM_TYPE */
    { 0x0121f6,  22, 0x00037d, 109,    -5665 }, /* VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED */
    { 0x014e6a,  19, 0x000806,  90,    -5664 }, /* VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED */
    { 0x014ec9,  19, 0x0117b3,  23,    -5663 }, /* VERR_SUP_VP_KERNEL32_ALREADY_MAPPED */
    { 0x0192af,  13, 0x0011e0,  72,    -5662 }, /* VERR_SUP_VP_SYSFER_DLL */
    { 0x00cd35,  29, 0x0094b7,  36,    -5661 }, /* VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED */
    { 0x01391e,  20, 0x017cad,  15,    -5660 }, /* VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT */
    { 0x00bb3c,  31, 0x0037d3,  55,    -5659 }, /* VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE */
    { 0x015b3b,  18, 0x00fef5,  25,    -5658 }, /* VERR_SUP_VP_NOT_BUILD_CERT_IPE */
    { 0x00ed69,  26, 0x004946,  50,    -5657 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT */
    { 0x011197,  23, 0x001270,  71,    -5656 }, /* VERR_SUP_VP_WINTRUST_CAT_FAILURE */
    { 0x00e791,  27, 0x010ee4,  24,    -5655 }, /* VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR */
    { 0x00e992,  27, 0x00f60b,  26,    -5654 }, /* VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR */
    { 0x00f659,  26, 0x003df8,  53,    -5653 }, /* VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH */
    { 0x010c8d,  24, 0x002c6d,  59,    -5652 }, /* VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH */
    { 0x015a3f,  18, 0x00817c,  39,    -5651 }, /* VERR_SUP_VP_EXE_MISSING_NX_COMPAT */
    { 0x012b1e,  21, 0x0087d1,  38,    -5650 }, /* VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE */
    { 0x016ce0,  16, 0x000f9b,  74,    -5649 }, /* VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY */
    { 0x016431,  17, 0x00a9e7,  33,    -5648 }, /* VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS */
    { 0x016486,  17, 0x006ee5,  42,    -5647 }, /* VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE */
    { 0x01957a,  13, 0x014cc8,  19,    -5646 }, /* VERR_SUP_VP_TOO_MANY_SECTIONS */
    { 0x0189c4,  14, 0x00f996,  25,    -5645 }, /* VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS */
    { 0x015530,  18, 0x015315,  18,    -5644 }, /* VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS */
    { 0x0171f0,  16, 0x00e0ec,  27,    -5643 }, /* VERR_SUP_VP_TOO_MANY_DLLS_LOADED */
    { 0x017230,  16, 0x00cbd9,  29,    -5642 }, /* VERR_SUP_VP_TOO_LARGE_REGION */
    { 0x014be4,  19, 0x00c181,  30,    -5641 }, /* VERR_SUP_VP_TOO_HIGH_REGION_RVA */
    { 0x0177be,  16, 0x00e6ef,  27,    -5640 }, /* VERR_SUP_VP_THREAD_NOT_ALONE */
    { 0x016fe0,  16, 0x00a733,  33,    -5639 }, /* VERR_SUP_VP_SYSTEM32_PATH */
    { 0x011996,  23, 0x00b69b,  32,    -5638 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR */
    { 0x013e96,  20, 0x00bd89,  31,    -5637 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR */
    { 0x01692c,  17, 0x00affb,  32,    -5636 }, /* VERR_SUP_VP_NT_QI_THREAD_ERROR */
    { 0x012fa1,  21, 0x014f02,  19,    -5635 }, /* VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR */
    { 0x00f08f,  26, 0x006129,  45,    -5634 }, /* VERR_SUP_VP_NT_MAPPING_NAME_CHANGED */
    { 0x013cca,  20, 0x0036f5,  56,    -5633 }, /* VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE */
    { 0x0149bd,  19, 0x004452,  52,    -5632 }, /* VERR_SUP_VP_NON_SYSTEM32_DLL */
    { 0x016a4d,  17, 0x01ab7c,  10,    -5631 }, /* VERR_SUP_VP_NO_NTDLL_MAPPING */
    { 0x01b69f,   7, 0x00715b,  42,    -5630 }, /* VERR_SUP_VP_NO_MEMORY_STATE */
    { 0x01b69f,   5, 0x011f4c,  22,    -5629 }, /* VERR_SUP_VP_NO_MEMORY */
    { 0x013c7a,  20, 0x0198c1,  12,    -5628 }, /* VERR_SUP_VP_NO_KERNEL32_MAPPING */
    { 0x011d94,  22, 0x00b816,  31,    -5627 }, /* VERR_SUP_VP_NO_IMAGE_MAPPING_NAME */
    { 0x01559b,  18, 0x0046b7,  51,    -5626 }, /* VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING */
    { 0x01a56d,  11, 0x0092e3,  36,    -5625 }, /* VERR_SUP_VP_MEMORY_READ_ERROR */
    { 0x0116b6,  23, 0x00008e, 138,    -5624 }, /* VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR */
    { 0x01454a,  19, 0x012ef9,  21,    -5623 }, /* VERR_SUP_VP_IMAGE_HDR_READ_ERROR */
    { 0x0175ff,  16, 0x015607,  18,    -5622 }, /* VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR */
    { 0x016585,  17, 0x012e27,  21,    -5621 }, /* VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR */
    { 0x00c451,  30, 0x002301,  62,    -5620 }, /* VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING */
    { 0x01a121,  11, 0x007329,  41,    -5619 }, /* VERR_SUP_VP_FOUND_EXEC_MEMORY */
    { 0x012af4,  21, 0x007fcf,  39,    -5618 }, /* VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH */
    { 0x011ca2,  22, 0x00fe46,  25,    -5617 }, /* VERR_SUP_VP_EMPTY_REGION_TOO_LARGE */
    { 0x0105cd,  24, 0x00bf3b,  31,    -5616 }, /* VERR_SUP_VP_DUPLICATE_DLL_MAPPING */
    { 0x01a3b5,  11, 0x01326b,  21,    -5615 }, /* VERR_SUP_VP_DEBUGGED */
    { 0x016b81,  16, 0x0158b3,  18,    -5614 }, /* VERR_SUP_VP_BAD_SIZE_OF_HEADERS */
    { 0x012894,  21, 0x01564f,  18,    -5613 }, /* VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE */
    { 0x017947,  15, 0x012aa1,  21,    -5612 }, /* VERR_SUP_VP_BAD_SECTION_RVA */
    { 0x018d36,  14, 0x018013,  15,    -5611 }, /* VERR_SUP_VP_BAD_SECTION_FILE_SIZE */
    { 0x00e1a9,  27, 0x00fd7e,  25,    -5610 }, /* VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE */
    { 0x015045,  19, 0x0136ef,  20,    -5609 }, /* VERR_SUP_VP_BAD_OPTIONAL_HEADER */
    { 0x0190c1,  13, 0x00dd63,  28,    -5608 }, /* VERR_SUP_VP_BAD_MZ_OFFSET */
    { 0x01a4a7,  11, 0x01a99c,  10,    -5607 }, /* VERR_SUP_VP_BAD_IMAGE_SIZE */
    { 0x01455d,  19, 0x017bbd,  15,    -5606 }, /* VERR_SUP_VP_BAD_IMAGE_SIGNATURE */
    { 0x018572,  14, 0x015835,  18,    -5605 }, /* VERR_SUP_VP_BAD_IMAGE_BASE */
    { 0x013f71,  20, 0x00fe2d,  25,    -5604 }, /* VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE */
    { 0x010e24,  24, 0x007567,  41,    -5603 }, /* VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED */
    { 0x015d57,  18, 0x009c16,  35,    -5602 }, /* VERR_SUP_VP_SECTION_NOT_MAPPED */
    { 0x0115a2,  23, 0x004ee7,  49,    -5601 }, /* VERR_SUP_VP_SECTION_PROTECTION_MISMATCH */
    { 0x01a884,  10, 0x012a8c,  21,    -5600 }, /* VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH */
    { 0x016970,  17, 0x01a9b0,  10,    -5499 }, /* VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS */
    { 0x0186c2,  14, 0x01b6a6,   7,    -5498 }, /* VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS */
    { 0x0140b1,  20, 0x00b27b,  32,    -5497 }, /* VERR_DBGC_PARSE_ARGUMENT_OVERFLOW */
    { 0x012fb6,  21, 0x0126db,  21,    -5496 }, /* VERR_DBGC_PARSE_EXPECTED_BINARY_OP */
    { 0x016310,  17, 0x007203,  42,    -5494 }, /* VERR_DBGC_PARSE_NO_RANGE_ALLOWED */
    { 0x0150f0,  19, 0x012642,  22,    -5493 }, /* VERR_DBGC_PARSE_UNBALANCED_QUOTE */
    { 0x010260,  25, 0x00e1c4,  27,    -5492 }, /* VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS */
    { 0x01690a,  17, 0x00678a,  43,    -5491 }, /* VERR_DBGC_PARSE_EMPTY_ARGUMENT */
    { 0x019f51,  12, 0x013a9a,  20,    -5490 }, /* VERR_DBGC_PARSE_UNEXPECTED_OPERATOR */
    { 0x01aac8,  10, 0x0184e6,  14,    -5489 }, /* VERR_DBGC_PARSE_INVALID_NUMBER */
    { 0x0186a6,  14, 0x012801,  21,    -5488 }, /* VERR_DBGC_PARSE_NUMBER_TOO_BIG */
    { 0x01975b,  13, 0x0173ff,  16,    -5487 }, /* VERR_DBGC_PARSE_INVALID_OPERATION */
    { 0x018d60,  14, 0x017c8f,  15,    -5486 }, /* VERR_DBGC_PARSE_FUNCTION_NOT_FOUND */
    { 0x018b3e,  14, 0x00d353,  28,    -5485 }, /* VERR_DBGC_PARSE_NOT_A_FUNCTION */
    { 0x01a63e,  11, 0x0106ed,  24,    -5484 }, /* VERR_DBGC_PARSE_NO_SCRATCH */
    { 0x01bb25,   5, 0x00cf79,  29,    -5483 }, /* VERR_DBGC_PARSE_NO_MEMORY */
    { 0x015619,  18, 0x00d46b,  28,    -5482 }, /* VERR_DBGC_PARSE_INCORRECT_ARG_TYPE */
    { 0x018e32,  14, 0x00961f,  36,    -5481 }, /* VERR_DBGC_PARSE_VARIABLE_NOT_FOUND */
    { 0x017c53,  15, 0x014440,  19,    -5480 }, /* VERR_DBGC_PARSE_CONVERSION_FAILED */
    { 0x017b27,  15, 0x003acf,  54,    -5479 }, /* VERR_DBGC_PARSE_NOT_IMPLEMENTED */
    { 0x0199ed,  12, 0x005101,  48,    -5478 }, /* VERR_DBGC_PARSE_BAD_RESULT_TYPE */
    { 0x014e44,  19, 0x0043ea,  52,    -5477 }, /* VERR_DBGC_PARSE_WRITEONLY_SYMBOL */
    { 0x0121e0,  22, 0x0151bf,  18,    -5476 }, /* VERR_DBGC_PARSE_INVALD_COMMAND_NAME */
    { 0x019059,  13, 0x018b06,  14,    -5475 }, /* VERR_DBGC_PARSE_COMMAND_NOT_FOUND */
    { 0x01b8a8,   6, 0x0163cb,  17,    -5474 }, /* VERR_DBGC_PARSE_BUG */
    { 0x01bb1b,   5, 0x0156df,  18,    -5408 }, /* VERR_DBGC_IPE */
    { 0x01a260,  11, 0x00edd1,  26,    -5407 }, /* VERR_DBGC_COMMAND_FAILED */
    { 0x01a465,  11, 0x01a848,  10,    -5405 }, /* VERR_DBGC_BP_EXISTS */
    { 0x01b67c,   7, 0x0199d5,  12,    -5404 }, /* VERR_DBGC_BP_NOT_FOUND */
    { 0x01262c,  22, 0x008377,  39,    -5403 }, /* VERR_DBGC_COMMANDS_NOT_REGISTERED */
    { 0x01b89c,   6, 0x00ece7,  26,    -5400 }, /* VERR_DBGC_QUIT */
    { 0x01bc2d,   4, 0x0196d9,  13,    -5399 }, /* VERR_IEM_IPE_9 */
    { 0x01bc31,   4, 0x01978f,  13,    -5398 }, /* VERR_IEM_IPE_8 */
    { 0x01bbf9,   4, 0x01963d,  13,    -5397 }, /* VERR_IEM_IPE_7 */
    { 0x01bc01,   4, 0x018f96,  13,    -5396 }, /* VERR_IEM_IPE_6 */
    { 0x01bc19,   4, 0x019261,  13,    -5395 }, /* VERR_IEM_IPE_5 */
    { 0x01bc1d,   4, 0x019594,  13,    -5394 }, /* VERR_IEM_IPE_4 */
    { 0x01bc21,   4, 0x019365,  13,    -5393 }, /* VERR_IEM_IPE_3 */
    { 0x01bc25,   4, 0x0192e3,  13,    -5392 }, /* VERR_IEM_IPE_2 */
    { 0x01bbf5,   4, 0x019630,  13,    -5391 }, /* VERR_IEM_IPE_1 */
    { 0x012d7f,  21, 0x004e23,  49,    -5390 }, /* VERR_IEM_ASPECT_NOT_IMPLEMENTED */
    { 0x012b9c,  21, 0x00d2c2,  29,    -5389 }, /* VERR_IEM_RESTART_INSTRUCTION */
    { 0x013717,  20, 0x018580,  14,    -5384 }, /* VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER */
    { 0x00c631,  30, 0x010915,  24,    -5383 }, /* VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE */
    { 0x01586b,  18, 0x012c05,  21,    -5382 }, /* VERR_IEM_EMIT_BAD_SEG_REG_NO */
    { 0x0193b3,  13, 0x00ef57,  26,    -5381 }, /* VERR_IEM_EMIT_BAD_MEM_SIZE */
    { 0x00edeb,  26, 0x013a4a,  20,    -5380 }, /* VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1 */
    { 0x01ae6c,   9, 0x00dcbb,  28,    -5377 }, /* VERR_IEM_VAR_IPE_13 */
    { 0x01ae75,   9, 0x00d4db,  28,    -5376 }, /* VERR_IEM_VAR_IPE_12 */
    { 0x01ae7e,   9, 0x00deb3,  28,    -5375 }, /* VERR_IEM_VAR_IPE_11 */
    { 0x01ae90,   9, 0x00de0b,  28,    -5374 }, /* VERR_IEM_VAR_IPE_10 */
    { 0x01b439,   8, 0x00e84e,  27,    -5373 }, /* VERR_IEM_VAR_IPE_9 */
    { 0x01b349,   8, 0x00eaa0,  27,    -5372 }, /* VERR_IEM_VAR_IPE_8 */
    { 0x01b359,   8, 0x00e09b,  27,    -5371 }, /* VERR_IEM_VAR_IPE_7 */
    { 0x01b3b9,   8, 0x00e359,  27,    -5370 }, /* VERR_IEM_VAR_IPE_6 */
    { 0x01b3c1,   8, 0x00e575,  27,    -5369 }, /* VERR_IEM_VAR_IPE_5 */
    { 0x01b3e9,   8, 0x00ea6a,  27,    -5368 }, /* VERR_IEM_VAR_IPE_4 */
    { 0x01b3f1,   8, 0x00e1df,  27,    -5367 }, /* VERR_IEM_VAR_IPE_3 */
    { 0x01b431,   8, 0x00e75b,  27,    -5366 }, /* VERR_IEM_VAR_IPE_2 */
    { 0x01ae6c,   8, 0x00e49d,  27,    -5365 }, /* VERR_IEM_VAR_IPE_1 */
    { 0x015b5f,  18, 0x0108cd,  24,    -5364 }, /* VERR_IEM_VAR_NOT_INITIALIZED */
    { 0x01a255,  11, 0x015f14,  17,    -5363 }, /* VERR_IEM_VAR_UNEXPECTED_KIND */
    { 0x0107ad,  24, 0x015392,  18,    -5362 }, /* VERR_IEM_VAR_OUT_OF_STACK_SLOTS */
    { 0x01759f,  16, 0x0096af,  36,    -5361 }, /* VERR_IEM_VAR_DUP_ARG_NO */
    { 0x0182e3,  15, 0x01760f,  16,    -5360 }, /* VERR_IEM_VAR_EXHAUSTED */
    { 0x01b099,   9, 0x00e230,  27,    -5355 }, /* VERR_IEM_REG_IPE_13 */
    { 0x01b0b4,   9, 0x00e6d4,  27,    -5354 }, /* VERR_IEM_REG_IPE_12 */
    { 0x01b0a2,   9, 0x00ead6,  27,    -5353 }, /* VERR_IEM_REG_IPE_11 */
    { 0x01b0ab,   9, 0x00e55a,  27,    -5352 }, /* VERR_IEM_REG_IPE_10 */
    { 0x01b259,   8, 0x00f075,  26,    -5351 }, /* VERR_IEM_REG_IPE_9 */
    { 0x01b261,   8, 0x00f53b,  26,    -5350 }, /* VERR_IEM_REG_IPE_8 */
    { 0x01b2a1,   8, 0x00f319,  26,    -5349 }, /* VERR_IEM_REG_IPE_7 */
    { 0x01b2b1,   8, 0x00ecb3,  26,    -5348 }, /* VERR_IEM_REG_IPE_6 */
    { 0x01b2e1,   8, 0x00eff3,  26,    -5347 }, /* VERR_IEM_REG_IPE_5 */
    { 0x01b2c1,   8, 0x00ef23,  26,    -5346 }, /* VERR_IEM_REG_IPE_4 */
    { 0x01b2d1,   8, 0x00f41d,  26,    -5345 }, /* VERR_IEM_REG_IPE_3 */
    { 0x01b2d9,   8, 0x00ec7f,  26,    -5344 }, /* VERR_IEM_REG_IPE_2 */
    { 0x01b099,   8, 0x00f0c3,  26,    -5343 }, /* VERR_IEM_REG_IPE_1 */
    { 0x0101fc,  25, 0x00d0f2,  29,    -5341 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR */
    { 0x00fc84,  25, 0x00d7cf,  28,    -5340 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP */
    { 0x01aa32,  10, 0x0192fd,  13,    -5339 }, /* VERR_IEM_LABEL_IPE_6 */
    { 0x01aa3c,  10, 0x018f7c,  13,    -5338 }, /* VERR_IEM_LABEL_IPE_5 */
    { 0x01aa46,  10, 0x01919e,  13,    -5337 }, /* VERR_IEM_LABEL_IPE_4 */
    { 0x01aa50,  10, 0x0193e7,  13,    -5336 }, /* VERR_IEM_LABEL_IPE_3 */
    { 0x01aa5a,  10, 0x019775,  13,    -5335 }, /* VERR_IEM_LABEL_IPE_2 */
    { 0x01aa8c,  10, 0x018ff1,  13,    -5334 }, /* VERR_IEM_LABEL_IPE_1 */
    { 0x017130,  16, 0x017fb9,  15,    -5333 }, /* VERR_IEM_LABEL_OUT_OF_MEMORY */
    { 0x019539,  13, 0x019698,  13,    -5332 }, /* VERR_IEM_LABEL_TOO_MANY */
    { 0x014165,  20, 0x00b35b,  32,    -5331 }, /* VERR_IEM_INSTR_BUF_OUT_OF_MEMORY */
    { 0x0157ed,  18, 0x0106d5,  24,    -5330 }, /* VERR_IEM_INSTR_BUF_TOO_LARGE */
    { 0x00ba63,  31, 0x007a5a,  40,    -5329 }, /* VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL */
    { 0x016c80,  16, 0x01825c,  15,    -5328 }, /* VERR_IEM_FIXUP_OUT_OF_MEMORY */
    { 0x01916a,  13, 0x019671,  13,    -5327 }, /* VERR_IEM_FIXUP_TOO_MANY */
    { 0x01aa96,  10, 0x019295,  13,    -5326 }, /* VERR_IEM_FIXUP_IPE_1 */
    { 0x019ef1,  12, 0x015577,  18,    -5325 }, /* VERR_IEM_DBGINFO_IPE_2 */
    { 0x019efd,  12, 0x01562b,  18,    -5324 }, /* VERR_IEM_DBGINFO_IPE_1 */
    { 0x01546a,  18, 0x00c433,  30,    -5323 }, /* VERR_IEM_DBGINFO_OUT_OF_MEMORY */
    { 0x00cf96,  29, 0x00700b,  42,    -5322 }, /* VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED */
    { 0x013462,  21, 0x00b2fb,  32,    -5321 }, /* VERR_IEM_COND_TOO_DEEPLY_NESTED */
    { 0x019981,  12, 0x00bea0,  31,    -5320 }, /* VERR_IEM_TB_ALLOC_FAILED */
    { 0x017a46,  15, 0x00be05,  31,    -5304 }, /* VERR_IEM_INVALID_INSTR_LENGTH */
    { 0x01a87a,  10, 0x006d40,  43,    -5303 }, /* VERR_IEM_INVALID_EFF_SEG */
    { 0x0182a7,  15, 0x0098ef,  36,    -5302 }, /* VERR_IEM_INVALID_ADDRESS_MODE */
    { 0x019b6d,  12, 0x0091e7,  36,    -5301 }, /* VERR_IEM_INVALID_OPERAND_SIZE */
    { 0x014381,  20, 0x0101ca,  25,    -5300 }, /* VERR_IEM_INSTR_NOT_IMPLEMENTED */
    { 0x00dc9f,  28, 0x00434e,  52,    -5205 }, /* VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED */
    { 0x01b5f9,   8, 0x0184bc,  14,    -5204 }, /* VERR_GVMM_IPE_2 */
    { 0x01b601,   8, 0x0187da,  14,    -5203 }, /* VERR_GVMM_IPE_1 */
    { 0x0163dc,  17, 0x00b3bb,  32,    -5202 }, /* VERR_GVMM_BROKEN_IPRT */
    { 0x013c52,  20, 0x0058f6,  47,    -5201 }, /* VERR_GVMM_HOST_CPU_RANGE */
    { 0x01891c,  14, 0x00eb5d,  27,    -5200 }, /* VERR_GVMM_INSTANCE */
    { 0x00bfb7,  31, 0x011c76,  22,    -5102 }, /* VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING */
    { 0x014331,  20, 0x014eef,  19,    -5101 }, /* VERR_PCI_PASSTHROUGH_NO_HM */
    { 0x00c271,  30, 0x0164b9,  17,    -5100 }, /* VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC */
    { 0x014101,  20, 0x00b96b,  31,    -5003 }, /* VERR_FAM_CONNECTION_LOST */
    { 0x010705,  24, 0x00b5bb,  32,    -5002 }, /* VERR_FAM_MONITOR_DIRECTORY_FAILED */
    { 0x01835b,  15, 0x00ad9b,  32,    -5001 }, /* VERR_FAM_MONITOR_FILE_FAILED */
    { 0x01a16e,  11, 0x010885,  24,    -5000 }, /* VERR_FAM_OPEN_FAILED */
    { 0x017dca,  15, 0x016046,  17,    -4904 }, /* VERR_VSCSI_LUN_BUSY */
    { 0x013a5e,  20, 0x00fd97,  25,    -4903 }, /* VERR_VSCSI_LUN_NOT_ATTACHED */
    { 0x01536e,  18, 0x0178de,  15,    -4902 }, /* VERR_VSCSI_LUN_INVALID */
    { 0x00d09b,  29, 0x008a7d,  38,    -4901 }, /* VERR_VSCSI_LUN_ATTACHED_TO_DEVICE */
    { 0x017a55,  15, 0x01b519,   8,    -4900 }, /* VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED */
    { 0x007f81,  39, 0x003bdd,  54,    -4700 }, /* VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST */
    { 0x018c2c,  14, 0x004c98,  50,    -4698 }, /* VERR_COM_OBJECT_NOT_FOUND */
    { 0x01ae87,   9, 0x00929b,  36,    -4697 }, /* VERR_COM_INVALID_VM_STATE */
    { 0x01b4a1,   8, 0x0081f1,  39,    -4696 }, /* VERR_COM_VM_ERROR */
    { 0x01b804,   7, 0x008bd3,  38,    -4695 }, /* VERR_COM_FILE_ERROR */
    { 0x01a675,  11, 0x01b9f2,   6,    -4694 }, /* VERR_COM_IPRT_ERROR */
    { 0x01b77f,   7, 0x00f1fb,  26,    -4693 }, /* VERR_COM_PDM_ERROR */
    { 0x01843e,  14, 0x012cc2,  21,    -4692 }, /* VERR_COM_INVALID_OBJECT_STATE */
    { 0x01a541,  11, 0x00b77b,  31,    -4691 }, /* VERR_COM_HOST_ERROR */
    { 0x01b6e5,   7, 0x018484,  14,    -4690 }, /* VERR_COM_NOT_SUPPORTED */
    { 0x01a8b6,  10, 0x01b938,   6,    -4689 }, /* VERR_COM_XML_ERROR */
    { 0x018112,  15, 0x00dc83,  28,    -4688 }, /* VERR_COM_INVALID_SESSION_STATE */
    { 0x015261,  18, 0x00ceae,  29,    -4687 }, /* VERR_COM_OBJECT_IN_USE */
    { 0x013946,  20, 0x0009c1,  85,    -4686 }, /* VERR_COM_DONT_CALL_AGAIN */
    { 0x018130,  15, 0x0187be,  14,    -4600 }, /* VERR_COM_UNEXPECTED */
    { 0x017bae,  15, 0x00be62,  31,    -4304 }, /* VERR_WEB_UNSUPPORTED_INTERFACE */
    { 0x017f5f,  15, 0x010102,  25,    -4303 }, /* VERR_WEB_INVALID_OBJECT_ID */
    { 0x01755f,  16, 0x00ac9b,  32,    -4302 }, /* VERR_WEB_INVALID_SESSION_ID */
    { 0x00c2cb,  30, 0x00de5f,  28,    -4301 }, /* VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE */
    { 0x014a42,  19, 0x00675f,  43,    -4300 }, /* VERR_WEB_NOT_AUTHENTICATED */
    { 0x01741f,  16, 0x01afb0,   9,    -4206 }, /* VERR_DIS_TOO_LONG_INSTR */
    { 0x017d52,  15, 0x016068,  17,    -4204 }, /* VERR_DIS_INVALID_PARAMETER */
    { 0x01a49c,  11, 0x01b131,   8,    -4203 }, /* VERR_DIS_INVALID_MODRM */
    { 0x014ff9,  19, 0x01791a,  15,    -4202 }, /* VERR_DIS_NO_READ_CALLBACK */
    { 0x016b41,  16, 0x00d7b3,  28,    -4201 }, /* VERR_DIS_GEN_FAILURE */
    { 0x019b01,  12, 0x01757f,  16,    -4200 }, /* VERR_DIS_INVALID_OPCODE */
    { 0x017a73,  15, 0x019512,  13,    -4116 }, /* VERR_HM_INVALID_HM64ON32OP */
    { 0x01b8d2,   6, 0x019f15,  12,    -4115 }, /* VERR_HM_IPE_5 */
    { 0x01b8d8,   6, 0x01a035,  12,    -4114 }, /* VERR_HM_IPE_4 */
    { 0x01b8de,   6, 0x019c39,  12,    -4113 }, /* VERR_HM_IPE_3 */
    { 0x012382,  22, 0x0102dd,  25,    -4112 }, /* VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO */
    { 0x014f15,  19, 0x016057,  17,    -4111 }, /* VERR_HM_UNKNOWN_IO_INSTRUCTION */
    { 0x015739,  18, 0x00f81f,  25,    -4110 }, /* VERR_HM_WRONG_SWITCHER */
    { 0x01b8f0,   6, 0x019bfd,  12,    -4109 }, /* VERR_HM_IPE_2 */
    { 0x01b8f6,   6, 0x01a029,  12,    -4108 }, /* VERR_HM_IPE_1 */
    { 0x0195bb,  13, 0x00b2db,  32,    -4107 }, /* VERR_HM_WRONG_CPU */
    { 0x012616,  22, 0x00af5b,  32,    -4106 }, /* VERR_HM_NO_32_TO_64_SWITCHER */
    { 0x018ba0,  14, 0x00dd7f,  28,    -4105 }, /* VERR_HM_UNEXPECTED_LD_ST_MSR */
    { 0x016f90,  16, 0x01845a,  14,    -4104 }, /* VERR_HM_ALREADY_ENABLED_IPE */
    { 0x019d4d,  12, 0x010d34,  24,    -4103 }, /* VERR_HM_CONFIG_MISMATCH */
    { 0x014bab,  19, 0x00a646,  34,    -4100 }, /* VERR_HM_SUSPEND_PENDING */
    { 0x0137b6,  20, 0x00b1db,  32,    -4073 }, /* VERR_SVM_VMRUN_PRECOND_3 */
    { 0x0137f2,  20, 0x00b33b,  32,    -4072 }, /* VERR_SVM_VMRUN_PRECOND_2 */
    { 0x0137ca,  20, 0x00b15b,  32,    -4071 }, /* VERR_SVM_VMRUN_PRECOND_1 */
    { 0x0137de,  20, 0x00af1b,  32,    -4070 }, /* VERR_SVM_VMRUN_PRECOND_0 */
    { 0x0194eb,  13, 0x0065ff,  44,    -4066 }, /* VERR_SVM_VMEXIT_FAILED */
    { 0x01b667,   7, 0x019f75,  12,    -4065 }, /* VERR_SVM_IPE_5 */
    { 0x01b66e,   7, 0x019e79,  12,    -4064 }, /* VERR_SVM_IPE_4 */
    { 0x01b675,   7, 0x019c81,  12,    -4063 }, /* VERR_SVM_IPE_3 */
    { 0x01b771,   7, 0x019a59,  12,    -4062 }, /* VERR_SVM_IPE_2 */
    { 0x01b786,   7, 0x01a041,  12,    -4061 }, /* VERR_SVM_IPE_1 */
    { 0x01a7e4,  10, 0x010a1d,  24,    -4060 }, /* VERR_SVM_UNKNOWN_EXIT */
    { 0x0191f9,  13, 0x00a5be,  34,    -4059 }, /* VERR_SVM_INVALID_GUEST_STATE */
    { 0x01944f,  13, 0x0176bf,  16,    -4058 }, /* VERR_SVM_UNEXPECTED_PATCH_TYPE */
    { 0x01782a,  15, 0x013d56,  20,    -4057 }, /* VERR_SVM_UNEXPECTED_XCPT_EXIT */
    { 0x01aaaa,  10, 0x01a8ac,  10,    -4056 }, /* VERR_SVM_UNEXPECTED_EXIT */
    { 0x01a583,  11, 0x01b835,   7,    -4055 }, /* VERR_SVM_INVALID_PVMCB */
    { 0x01a633,  11, 0x00e9e3,  27,    -4054 }, /* VERR_SVM_IN_USE */
    { 0x01900b,  13, 0x00806b,  39,    -4053 }, /* VERR_SVM_DISABLED */
    { 0x01af05,   9, 0x00bf79,  31,    -4052 }, /* VERR_SVM_NO_SVM */
    { 0x013241,  21, 0x00d93b,  28,    -4051 }, /* VERR_SVM_ILLEGAL_EFER_MSR */
    { 0x011b9a,  22, 0x013677,  20,    -4050 }, /* VERR_SVM_UNABLE_TO_START_VM */
    { 0x0147bc,  19, 0x00a009,  34,    -4042 }, /* VERR_VMX_STARTVM_PRECOND_3 */
    { 0x014a09,  19, 0x00a57a,  34,    -4041 }, /* VERR_VMX_STARTVM_PRECOND_2 */
    { 0x0149e3,  19, 0x00a0d5,  34,    -4040 }, /* VERR_VMX_STARTVM_PRECOND_1 */
    { 0x0149f6,  19, 0x009fc5,  34,    -4039 }, /* VERR_VMX_STARTVM_PRECOND_0 */
    { 0x016ba1,  16, 0x00f367,  26,    -4038 }, /* VERR_VMX_INVALID_VMCS_LAUNCH_STATE */
    { 0x01ad5c,  10, 0x016f00,  16,    -4034 }, /* VERR_VMX_VMEXIT_FAILED */
    { 0x01a402,  11, 0x019fd5,  12,    -4033 }, /* VERR_VMX_VMENTRY_FAILED */
    { 0x0144c5,  19, 0x002b46,  59,    -4032 }, /* VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED */
    { 0x0178c0,  15, 0x00356d,  56,    -4031 }, /* VERR_VMX_MSR_VMX_ENABLE_FAILED */
    { 0x00f521,  26, 0x00c75d,  30,    -4030 }, /* VERR_VMX_VMCS_FIELD_CACHE_INVALID */
    { 0x017e06,  15, 0x00c343,  30,    -4029 }, /* VERR_VMX_MSR_VMX_DISABLED */
    { 0x014e31,  19, 0x003685,  56,    -4028 }, /* VERR_VMX_MSR_ALL_VMX_DISABLED */
    { 0x01bbb1,   4, 0x019c75,  12,    -4027 }, /* VERR_VMX_IPE_5 */
    { 0x01bbb5,   4, 0x01a0c5,  12,    -4026 }, /* VERR_VMX_IPE_4 */
    { 0x01bbc1,   4, 0x0198b5,  12,    -4025 }, /* VERR_VMX_IPE_3 */
    { 0x01bbc5,   4, 0x019db9,  12,    -4024 }, /* VERR_VMX_IPE_2 */
    { 0x01bbd9,   4, 0x019add,  12,    -4023 }, /* VERR_VMX_IPE_1 */
    { 0x011d26,  22, 0x007d2a,  40,    -4022 }, /* VERR_VMX_INVALID_VMCS_PTR_TO_START_VM */
    { 0x01a347,  11, 0x005c09,  46,    -4021 }, /* VERR_VMX_VMPTRLD_FAILED */
    { 0x013256,  21, 0x01599d,  18,    -4019 }, /* VERR_VMX_UNDEFINED_EXIT_CODE */
    { 0x016cd0,  16, 0x003e62,  53,    -4018 }, /* VERR_VMX_NOT_IN_VMX_ROOT_MODE */
    { 0x011b00,  22, 0x01077d,  24,    -4017 }, /* VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE */
    { 0x019d05,  12, 0x019129,  13,    -4016 }, /* VERR_VMX_UNEXPECTED_EXCEPTION */
    { 0x01b740,   7, 0x01b419,   8,    -4015 }, /* VERR_VMX_UNEXPECTED_EXIT */
    { 0x01ab36,  10, 0x011c4a,  22,    -4014 }, /* VERR_VMX_INVALID_GUEST_STATE */
    { 0x0180e5,  15, 0x00c9ec,  29,    -4013 }, /* VERR_VMX_MSR_LOCKING_FAILED */
    { 0x011e9c,  22, 0x005ee0,  45,    -4012 }, /* VERR_VMX_X86_CR4_VMXE_CLEARED */
    { 0x017ce9,  15, 0x0021c7,  63,    -4011 }, /* VERR_VMX_IN_VMX_ROOT_MODE */
    { 0x01b86c,   6, 0x00839e,  39,    -4009 }, /* VERR_VMX_NO_VMX */
    { 0x01af32,   9, 0x00ef71,  26,    -4006 }, /* VERR_VMX_INVALID_HOST_STATE */
    { 0x01487a,  19, 0x013677,  20,    -4005 }, /* VERR_VMX_UNABLE_TO_START_VM */
    { 0x019e85,  12, 0x017d25,  15,    -4004 }, /* VERR_VMX_INVALID_VMXON_PTR */
    { 0x01a8ca,  10, 0x0014a6,  70,    -4003 }, /* VERR_VMX_RESERVED */
    { 0x0014de,  13, 0x008a0b,  38,    -4002 }, /* VERR_VMX_INVALID_VMCS_FIELD */
    { 0x0014d1,  11, 0x018aa4,  14,    -4001 }, /* VERR_VMX_INVALID_VMCS_PTR */
    { 0x01b07e,   9, 0x007d02,  40,    -4000 }, /* VERR_VMX_VMXON_FAILED */
    { 0x018da6,  14, 0x004e54,  49,    -3907 }, /* VERR_GVM_MISMATCH_SVN_REV */
    { 0x01468c,  19, 0x0082b4,  39,    -3906 }, /* VERR_GVM_MISMATCH_VM_STRUCT_VER */
    { 0x018d7c,  14, 0x005869,  47,    -3905 }, /* VERR_GVM_MISMATCH_VMCPU_SIZE */
    { 0x01ab54,  10, 0x006abb,  43,    -3904 }, /* VERR_GVM_MISMATCH_VM_SIZE */
    { 0x01ab04,  10, 0x00f00d,  26,    -3900 }, /* VERR_GVM_TOO_MANY_VMS */
    { 0x00d2a5,  29, 0x003c49,  54,    -3831 }, /* VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE */
    { 0x0131ae,  21, 0x00a6f0,  34,    -3830 }, /* VERR_GMM_BAD_SHARED_MODULE_SIZE */
    { 0x012f4d,  21, 0x015cd9,  18,    -3829 }, /* VERR_GMM_SHARED_MODULE_NOT_FOUND */
    { 0x00b0db,  32, 0x001822,  68,    -3828 }, /* VERR_GMM_SHARED_MODULE_ADDRESS_CLASH */
    { 0x012705,  21, 0x012566,  22,    -3826 }, /* VERR_GMM_TOO_MANY_GLOBAL_MODULES */
    { 0x0141c9,  20, 0x012566,  22,    -3825 }, /* VERR_GMM_TOO_MANY_PER_VM_MODULES */
    { 0x018708,  14, 0x00efd9,  26,    -3824 }, /* VERR_GMM_TOO_MANY_REGIONS */
    { 0x014fc0,  19, 0x010975,  24,    -3823 }, /* VERR_GMM_MODULE_VERSION_TOO_LONG */
    { 0x012188,  22, 0x00eaf1,  27,    -3822 }, /* VERR_GMM_MODULE_NAME_TOO_LONG */
    { 0x0126c6,  21, 0x008ede,  37,    -3821 }, /* VERR_GMM_ACTUAL_PAGES_IPE */
    { 0x01364f,  20, 0x016dd0,  16,    -3820 }, /* VERR_GMM_ALLOC_PAGES_IPE */
    { 0x01889e,  14, 0x01179c,  23,    -3819 }, /* VERR_GMM_MTX_FLAGS */
    { 0x019483,  13, 0x011968,  23,    -3818 }, /* VERR_GMM_INSTANCE */
    { 0x0161ab,  17, 0x0110f6,  23,    -3817 }, /* VERR_GMM_CHUNK_INSERT */
    { 0x01926e,  13, 0x013f49,  20,    -3816 }, /* VERR_GMM_IS_NOT_SANE */
    { 0x00e0b6,  27, 0x0004b9,  98,    -3815 }, /* VERR_GMM_MEMORY_RESERVATION_DECLINED */
    { 0x012a0e,  21, 0x0089bf,  38,    -3814 }, /* VERR_GMM_TOO_MANY_CHUNK_MAPPINGS */
    { 0x0153fe,  18, 0x003b05,  54,    -3813 }, /* VERR_GMM_CHUNK_NOT_MAPPED */
    { 0x015422,  18, 0x00ba82,  31,    -3812 }, /* VERR_GMM_CHUNK_ALREADY_MAPPED */
    { 0x019191,  13, 0x01a536,  11,    -3811 }, /* VERR_GMM_CHUNK_NOT_FOUND */
    { 0x019a95,  12, 0x00793f,  41,    -3810 }, /* VERR_GMM_NOT_PAGE_OWNER */
    { 0x01a44f,  11, 0x0154a0,  18,    -3809 }, /* VERR_GMM_PAGE_ALREADY_FREE */
    { 0x01952c,  13, 0x00dadf,  28,    -3808 }, /* VERR_GMM_PAGE_NOT_SHARED */
    { 0x018bca,  14, 0x00d26b,  29,    -3807 }, /* VERR_GMM_PAGE_NOT_PRIVATE */
    { 0x01b4a9,   8, 0x012356,  22,    -3806 }, /* VERR_GMM_PAGE_NOT_FOUND */
    { 0x00cb0e,  29, 0x008739,  38,    -3805 }, /* VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH */
    { 0x00f589,  26, 0x0043b6,  52,    -3804 }, /* VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH */
    { 0x010556,  24, 0x010fcb,  23,    -3803 }, /* VERR_GMM_HIT_VM_ACCOUNT_LIMIT */
    { 0x013313,  21, 0x00cf5c,  29,    -3802 }, /* VERR_GMM_HIT_GLOBAL_LIMIT */
    { 0x01923a,  13, 0x007cb2,  40,    -3801 }, /* VERR_GMM_OUT_OF_MEMORY */
    { 0x0183ea,  14, 0x0067e0,  43,    -3778 }, /* VERR_SUPLIB_UNEXPECTED_INSTRUCTION */
    { 0x0185f0,  14, 0x0049dc,  50,    -3777 }, /* VERR_SUPLIB_TEXT_NOT_SEALED */
    { 0x015f69,  17, 0x010a7d,  24,    -3776 }, /* VERR_SUPLIB_TEXT_NOT_WRITEABLE */
    { 0x010ddc,  24, 0x00d54b,  28,    -3775 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5 */
    { 0x010d4c,  24, 0x00dcf3,  28,    -3774 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4 */
    { 0x010dc4,  24, 0x00d83f,  28,    -3773 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3 */
    { 0x010dac,  24, 0x00d5d7,  28,    -3772 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2 */
    { 0x010d64,  24, 0x00d9c7,  28,    -3771 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1 */
    { 0x010d7c,  24, 0x00d3df,  28,    -3770 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0 */
    { 0x01a557,  11, 0x007c8a,  40,    -3769 }, /* VERR_SUPLIB_INVALID_INTERNAL_APP_DIR */
    { 0x016497,  17, 0x00583a,  47,    -3768 }, /* VERR_SUPLIB_INVALID_ARGV0_INTERNAL */
    { 0x01743f,  16, 0x012c59,  21,    -3767 }, /* VERR_SUPLIB_WORLD_WRITABLE */
    { 0x013549,  21, 0x005d1d,  46,    -3766 }, /* VERR_SUPLIB_WRITE_NON_SYS_GROUP */
    { 0x018f55,  13, 0x0180f4,  15,    -3765 }, /* VERR_SUPLIB_OWNER_NOT_ROOT */
    { 0x018652,  14, 0x00c66d,  30,    -3764 }, /* VERR_SUPLIB_NOT_SAME_OBJECT */
    { 0x01aebd,   9, 0x01903f,  13,    -3763 }, /* VERR_SUPLIB_IS_FILE */
    { 0x0189a8,  14, 0x018e9f,  13,    -3762 }, /* VERR_SUPLIB_IS_DIRECTORY */
    { 0x019f2d,  12, 0x00a1c2,  34,    -3761 }, /* VERR_SUPLIB_NOT_DIR_NOT_FILE */
    { 0x00fc07,  25, 0x00c799,  30,    -3760 }, /* VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED */
    { 0x01aea2,   9, 0x01009e,  25,    -3759 }, /* VERR_SUPLIB_FSTAT_FAILED */
    { 0x01b309,   8, 0x0144b2,  19,    -3758 }, /* VERR_SUPLIB_STAT_FAILED */
    { 0x0191ab,  13, 0x008571,  38,    -3757 }, /* VERR_SUPLIB_STAT_ENUM_FAILED */
    { 0x019cc9,  12, 0x01851e,  14,    -3756 }, /* VERR_SUPLIB_DIR_ENUM_FAILED */
    { 0x0185fe,  14, 0x018f2e,  13,    -3755 }, /* VERR_SUPLIB_PATH_IS_ROOT */
    { 0x01494b,  19, 0x015bcb,  18,    -3754 }, /* VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS */
    { 0x018f62,  13, 0x019ad1,  12,    -3753 }, /* VERR_SUPLIB_PATH_TOO_SHORT */
    { 0x01a0ad,  12, 0x01a4d3,  11,    -3752 }, /* VERR_SUPLIB_PATH_TOO_LONG */
    { 0x0194de,  13, 0x019fed,  12,    -3751 }, /* VERR_SUPLIB_PATH_NOT_CLEAN */
    { 0x017250,  16, 0x0182c5,  15,    -3750 }, /* VERR_SUPLIB_PATH_NOT_ABSOLUTE */
    { 0x0123da,  22, 0x006d6b,  42,    -3749 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2 */
    { 0x012406,  22, 0x0070dd,  42,    -3748 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1 */
    { 0x00d4bf,  28, 0x004684,  51,    -3747 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY */
    { 0x019eb5,  12, 0x00dfc3,  27,    -3745 }, /* VERR_SUPDRV_TSC_READ_FAILED */
    { 0x010bb5,  24, 0x00e467,  27,    -3744 }, /* VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED */
    { 0x00ff59,  25, 0x0086a1,  38,    -3743 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x015e0b,  18, 0x00a28e,  34,    -3742 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE */
    { 0x01ac8a,  10, 0x0040a9,  53,    -3741 }, /* VERR_SUPDRV_CSRSS_NOT_FOUND */
    { 0x010c15,  24, 0x009178,  37,    -3740 }, /* VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR */
    { 0x015e0b,  16, 0x00ccc1,  29,    -3739 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR */
    { 0x01103e,  23, 0x00051b,  97,    -3738 }, /* VERR_SUPDRV_HARDENING_EVIL_HANDLE */
    { 0x00d807,  28, 0x0060cf,  45,    -3737 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD */
    { 0x0100b7,  25, 0x0076d8,  41,    -3736 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG */
    { 0x0121ca,  22, 0x002fa0,  58,    -3735 }, /* VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES */
    { 0x011518,  23, 0x0030fc,  58,    -3734 }, /* VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT */
    { 0x017f6e,  15, 0x00c5f5,  30,    -3733 }, /* VERR_SUPDRV_TRACER_TOO_LARGE */
    { 0x013627,  20, 0x005693,  47,    -3732 }, /* VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS */
    { 0x014c1d,  19, 0x016f20,  16,    -3731 }, /* VERR_SUPDRV_TRACER_BAD_ARG_FLAGS */
    { 0x00fc39,  25, 0x008e6f,  37,    -3730 }, /* VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF */
    { 0x012ecf,  21, 0x006a3a,  43,    -3729 }, /* VERR_SUPDRV_TRACER_SESSION_BUSY */
    { 0x0155d1,  18, 0x014808,  19,    -3728 }, /* VERR_SUPDRV_TRACER_UNLOADING */
    { 0x0169f8,  17, 0x010373,  25,    -3727 }, /* VERR_SUPDRV_TRACER_NOT_PRESENT */
    { 0x01762f,  16, 0x015d33,  18,    -3726 }, /* VERR_SUPDRV_TRACER_NOT_OPENED */
    { 0x01764f,  16, 0x00ac18,  33,    -3725 }, /* VERR_SUPDRV_TRACER_ALREADY_OPENED */
    { 0x013f5d,  20, 0x009e23,  35,    -3724 }, /* VERR_SUPDRV_TRACER_NOT_REGISTERED */
    { 0x01378e,  20, 0x0112c2,  23,    -3723 }, /* VERR_SUPDRV_TRACER_ALREADY_REGISTERED */
    { 0x00df57,  27, 0x00a228,  34,    -3722 }, /* VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION */
    { 0x016189,  17, 0x00b2bb,  32,    -3721 }, /* VERR_SUPDRV_VTG_ALREADY_REGISTERED */
    { 0x0176ef,  16, 0x00e33e,  27,    -3720 }, /* VERR_SUPDRV_VTG_BAD_PROBE_LOC */
    { 0x013ad6,  20, 0x010e0c,  24,    -3719 }, /* VERR_SUPDRV_VTG_BAD_PROBE_ENABLED */
    { 0x018732,  14, 0x00c59b,  30,    -3718 }, /* VERR_SUPDRV_VTG_BAD_ARGLIST */
    { 0x013ad6,  12, 0x011cfa,  22,    -3717 }, /* VERR_SUPDRV_VTG_BAD_PROBE */
    { 0x017f8c,  15, 0x00fedc,  25,    -3716 }, /* VERR_SUPDRV_VTG_BAD_PROVIDER */
    { 0x01a305,  11, 0x01730f,  16,    -3715 }, /* VERR_SUPDRV_VTG_BAD_ATTR */
    { 0x019782,  13, 0x019f21,  12,    -3714 }, /* VERR_SUPDRV_VTG_STRING_TOO_LONG */
    { 0x01b5e1,   8, 0x019d59,  12,    -3713 }, /* VERR_SUPDRV_VTG_BAD_STRING */
    { 0x016f50,  16, 0x018a5e,  14,    -3712 }, /* VERR_SUPDRV_VTG_STRTAB_OFF */
    { 0x013587,  20, 0x0099a0,  35,    -3711 }, /* VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE */
    { 0x0174ef,  16, 0x0180c7,  15,    -3710 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH */
    { 0x018199,  15, 0x01875c,  14,    -3709 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW */
    { 0x018ce2,  14, 0x018220,  15,    -3708 }, /* VERR_SUPDRV_VTG_BAD_HDR_PTR */
    { 0x018c8e,  14, 0x018220,  15,    -3707 }, /* VERR_SUPDRV_VTG_BAD_HDR_OFF */
    { 0x017e42,  15, 0x019428,  13,    -3706 }, /* VERR_SUPDRV_VTG_BAD_HDR_MISC */
    { 0x01a852,  10, 0x01765f,  16,    -3705 }, /* VERR_SUPDRV_VTG_BITS */
    { 0x01a1c6,  11, 0x019d35,  12,    -3704 }, /* VERR_SUPDRV_VTG_MAGIC */
    { 0x012e51,  21, 0x0148b3,  19,    -3703 }, /* VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX */
    { 0x019a41,  12, 0x014e90,  19,    -3702 }, /* VERR_SUPDRV_SERVICE_NOT_FOUND */
    { 0x0188c8,  14, 0x00854b,  38,    -3701 }, /* VERR_SUPDRV_INTERFACE_NOT_SUPPORTED */
    { 0x018b14,  14, 0x012684,  22,    -3700 }, /* VERR_SUPDRV_COMPONENT_NOT_FOUND */
    { 0x00dac3,  28, 0x00f89c,  25,    -3611 }, /* VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND */
    { 0x00ce3a,  29, 0x00b3fb,  32,    -3610 }, /* VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED */
    { 0x00c57d,  30, 0x00828d,  39,    -3609 }, /* VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND */
    { 0x011010,  23, 0x0066af,  44,    -3608 }, /* VERR_INTNET_FLT_VNIC_OPEN_FAILED */
    { 0x0110df,  23, 0x004ad6,  50,    -3607 }, /* VERR_INTNET_FLT_VNIC_INIT_FAILED */
    { 0x00e4b8,  27, 0x005925,  47,    -3606 }, /* VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND */
    { 0x00fb0d,  25, 0x005a3d,  46,    -3605 }, /* VERR_INTNET_FLT_VNIC_CREATE_FAILED */
    { 0x00ec65,  26, 0x001531,  69,    -3604 }, /* VERR_INTNET_INCOMPATIBLE_FLAGS */
    { 0x00f5f1,  26, 0x004c34,  50,    -3603 }, /* VERR_INTNET_INCOMPATIBLE_TRUNK */
    { 0x016e20,  16, 0x004f18,  49,    -3602 }, /* VERR_INTNET_FLT_IF_FAILED */
    { 0x014b39,  19, 0x0042b2,  52,    -3601 }, /* VERR_INTNET_FLT_IF_BUSY */
    { 0x015f25,  17, 0x00aa8c,  33,    -3600 }, /* VERR_INTNET_FLT_IF_NOT_FOUND */
    { 0x0162cc,  17, 0x00bf5a,  31,    -3504 }, /* VERR_VGA_GL_SYMBOL_NOT_FOUND */
    { 0x013613,  20, 0x00881d,  38,    -3503 }, /* VERR_VGA_GL_LOAD_FAILURE */
    { 0x00d823,  28, 0x005f94,  45,    -3502 }, /* VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE */
    { 0x0166fb,  17, 0x00c6c7,  30,    -3500 }, /* VERR_VGA_INVALID_CUSTOM_MODE */
    { 0x00e7e2,  27, 0x00b01b,  32,    -3408 }, /* VERR_VUSB_USB_DEVICE_PERMISSION */
    { 0x00f70c,  25, 0x007ff6,  39,    -3407 }, /* VERR_VUSB_DEVICE_IS_SUSPENDED */
    { 0x00f86a,  25, 0x0077a5,  41,    -3406 }, /* VERR_VUSB_DEVICE_IS_RESETTING */
    { 0x01241c,  22, 0x00b01b,  32,    -3405 }, /* VERR_VUSB_USBFS_PERMISSION */
    { 0x013b26,  20, 0x00b73b,  32,    -3404 }, /* VERR_VUSB_DEVICE_NAME_NOT_FOUND */
    { 0x013d92,  20, 0x009eaf,  35,    -3403 }, /* VERR_VUSB_FAILED_TO_QUEUE_URB */
    { 0x019b79,  12, 0x014f87,  19,    -3402 }, /* VERR_VUSB_NO_URB_MEMORY */
    { 0x011ce4,  22, 0x007f0a,  40,    -3401 }, /* VERR_VUSB_DEVICE_NOT_ATTACHED */
    { 0x019bf1,  12, 0x00f8b5,  25,    -3400 }, /* VERR_VUSB_NO_PORTS */
    { 0x01930a,  13, 0x014511,  19,    -3302 }, /* VERR_VBGL_IOCTL_FAILED */
    { 0x01a310,  11, 0x00867b,  38,    -3301 }, /* VERR_VBGL_INVALID_ADDR */
    { 0x015d69,  18, 0x01266e,  22,    -3300 }, /* VERR_VBGL_NOT_INITIALIZED */
    { 0x01a4e9,  11, 0x0158e9,  18,    -3290 }, /* VERR_VD_SHRINK_NOT_SUPPORTED */
    { 0x015091,  19, 0x00c91f,  30,    -3289 }, /* VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG */
    { 0x011aea,  22, 0x00875f,  38,    -3288 }, /* VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL */
    { 0x014570,  19, 0x00bbd7,  31,    -3287 }, /* VERR_VD_RAW_SIZE_MODULO_2048 */
    { 0x0159c1,  18, 0x00c6e5,  30,    -3286 }, /* VERR_VD_RAW_SIZE_MODULO_512 */
    { 0x014f9a,  19, 0x006b67,  43,    -3285 }, /* VERR_VD_DMG_NOT_FOUND_INSIDE_XAR */
    { 0x01a089,  12, 0x01193a,  23,    -3284 }, /* VERR_VD_DMG_XML_PARSE_ERROR */
    { 0x0150b7,  19, 0x004fdc,  49,    -3282 }, /* VERR_VD_READ_OUT_OF_RANGE */
    { 0x00f6f3,  25, 0x005f67,  45,    -3281 }, /* VERR_VD_IMAGE_REPAIR_IMPOSSIBLE */
    { 0x0166b7,  17, 0x017884,  15,    -3280 }, /* VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED */
    { 0x0167b6,  17, 0x00a119,  34,    -3279 }, /* VERR_VD_IMAGE_CORRUPTED */
    { 0x019be5,  12, 0x00a426,  34,    -3278 }, /* VERR_VD_DISCARD_NOT_SUPPORTED */
    { 0x0109ed,  24, 0x007e92,  40,    -3277 }, /* VERR_VD_DISCARD_ALIGNMENT_NOT_MET */
    { 0x014b4c,  19, 0x00f179,  26,    -3276 }, /* VERR_VD_CACHE_NOT_UP_TO_DATE */
    { 0x01aa78,  10, 0x00b53b,  32,    -3275 }, /* VERR_VD_CACHE_NOT_FOUND */
    { 0x017d34,  15, 0x00ad7b,  32,    -3274 }, /* VERR_VD_CACHE_ALREADY_EXISTS */
    { 0x019945,  12, 0x001931,  67,    -3273 }, /* VERR_VD_IOCTX_HALT */
    { 0x015c25,  18, 0x00427e,  52,    -3272 }, /* VERR_VD_NOT_ENOUGH_METADATA */
    { 0x01b351,   8, 0x0193c0,  13,    -3271 }, /* VERR_VD_RAW_INVALID_TYPE */
    { 0x0195ef,  13, 0x017b63,  15,    -3270 }, /* VERR_VD_RAW_INVALID_HEADER */
    { 0x0190a7,  13, 0x017f41,  15,    -3267 }, /* VERR_VD_DMG_INVALID_HEADER */
    { 0x0146b2,  19, 0x00f8ce,  25,    -3265 }, /* VERR_VD_PARALLELS_INVALID_HEADER */
    { 0x0190ce,  13, 0x017ee7,  15,    -3260 }, /* VERR_VD_VHD_INVALID_HEADER */
    { 0x0105e5,  24, 0x009d51,  35,    -3253 }, /* VERR_VD_ISCSI_SECRET_ENCRYPTED */
    { 0x01a960,  10, 0x0111ae,  23,    -3252 }, /* VERR_VD_ISCSI_INVALID_TYPE */
    { 0x01a942,  10, 0x005fc1,  45,    -3251 }, /* VERR_VD_ISCSI_INVALID_STATE */
    { 0x017c80,  15, 0x015697,  18,    -3250 }, /* VERR_VD_ISCSI_INVALID_HEADER */
    { 0x0194aa,  13, 0x011f20,  22,    -3245 }, /* VERR_VD_VMDK_INVALID_WRITE */
    { 0x018be6,  14, 0x009b67,  35,    -3244 }, /* VERR_VD_VMDK_INVALID_FORMAT */
    { 0x01b10e,   9, 0x00657b,  44,    -3243 }, /* VERR_VD_VMDK_INVALID_STATE */
    { 0x01805e,  15, 0x01106c,  23,    -3242 }, /* VERR_VD_VMDK_VALUE_NOT_FOUND */
    { 0x01b120,   9, 0x00f263,  26,    -3241 }, /* VERR_VD_VMDK_UNSUPPORTED_VERSION */
    { 0x018c64,  14, 0x016da0,  16,    -3240 }, /* VERR_VD_VMDK_INVALID_HEADER */
    { 0x014dbf,  19, 0x01737f,  16,    -3233 }, /* VERR_VD_VDI_COMMENT_TOO_LONG */
    { 0x01b1c9,   8, 0x010008,  25,    -3232 }, /* VERR_VD_VDI_UNSUPPORTED_VERSION */
    { 0x016e90,  16, 0x00e95c,  27,    -3231 }, /* VERR_VD_VDI_INVALID_SIGNATURE */
    { 0x0197b6,  13, 0x0178a2,  15,    -3230 }, /* VERR_VD_VDI_INVALID_HEADER */
    { 0x019025,  13, 0x0143a8,  19,    -3220 }, /* VERR_VD_GEN_INVALID_HEADER */
    { 0x013efa,  20, 0x00649f,  44,    -3215 }, /* VERR_VD_PASSWORD_INCORRECT */
    { 0x01b7e1,   7, 0x00bccf,  31,    -3214 }, /* VERR_VD_DEK_MISSING */
    { 0x019951,  12, 0x0146d8,  19,    -3213 }, /* VERR_VD_UNKNOWN_INTERFACE */
    { 0x018fca,  13, 0x010945,  24,    -3212 }, /* VERR_VD_UNKNOWN_CFG_VALUES */
    { 0x01bb79,   4, 0x00c090,  31,    -3211 }, /* VERR_VD_INVALID_SIZE */
    { 0x01232a,  22, 0x00b31b,  32,    -3210 }, /* VERR_VD_ASYNC_IO_IN_PROGRESS */
    { 0x01b129,   8, 0x002a5a,  59,    -3208 }, /* VERR_VD_UUID_MISMATCH */
    { 0x019b85,  12, 0x0130dc,  21,    -3207 }, /* VERR_VD_BLOCK_FREE */
    { 0x017abe,  15, 0x0129a5,  21,    -3206 }, /* VERR_VD_GEOMETRY_NOT_SET */
    { 0x0165a7,  17, 0x0160bd,  17,    -3205 }, /* VERR_VD_IMAGE_READ_ONLY */
    { 0x01a7c6,  10, 0x013c66,  20,    -3204 }, /* VERR_VD_IMAGE_NOT_FOUND */
    { 0x01aef3,   9, 0x01344d,  21,    -3203 }, /* VERR_VD_NOT_OPENED */
    { 0x01a938,  10, 0x015f7a,  17,    -3202 }, /* VERR_VD_VALUE_NOT_FOUND */
    { 0x01bb91,   4, 0x0044ec,  51,    -3201 }, /* VERR_VD_INVALID_STATE */
    { 0x01bb81,   4, 0x01b68a,   7,    -3200 }, /* VERR_VD_INVALID_TYPE */
    { 0x0183b2,  14, 0x005cef,  46,    -3105 }, /* VERR_HOSTIF_TERM_FAILED */
    { 0x010a05,  24, 0x000911,  88,    -3104 }, /* VERR_HOSTIF_FD_AND_INIT_TERM */
    { 0x0170f0,  16, 0x003a99,  54,    -3103 }, /* VERR_HOSTIF_BLOCKING */
    { 0x01910f,  13, 0x00461e,  51,    -3102 }, /* VERR_HOSTIF_IOCTL */
    { 0x010134,  25, 0x007c62,  40,    -3101 }, /* VERR_HOSTIF_DEVICE_NAME_TOO_LONG */
    { 0x018556,  14, 0x007968,  41,    -3100 }, /* VERR_HOSTIF_INIT_FAILED */
    { 0x017010,  16, 0x0095fb,  36,    -3002 }, /* VERR_NAT_REDIR_SETUP */
    { 0x014641,  19, 0x0070b3,  42,    -3001 }, /* VERR_NAT_REDIR_GUEST_IP */
    { 0x013f99,  20, 0x009ca2,  35,    -2909 }, /* VERR_HGCM_TOO_MANY_CLIENT_CALLS */
    { 0x017faa,  15, 0x0110b1,  23,    -2908 }, /* VERR_HGCM_TOO_MANY_CLIENTS */
    { 0x013ffd,  20, 0x00eebb,  26,    -2907 }, /* VERR_HGCM_SERVICE_EXISTS */
    { 0x0173ef,  16, 0x01771e,  16,    -2905 }, /* VERR_HGCM_INVALID_CLIENT_ID */
    { 0x018476,  14, 0x00e89f,  27,    -2904 }, /* VERR_HGCM_INTERNAL */
    { 0x015ba7,  18, 0x00f883,  25,    -2902 }, /* VERR_HGCM_INVALID_CMD_ADDRESS */
    { 0x016af1,  16, 0x00ec17,  26,    -2900 }, /* VERR_HGCM_SERVICE_NOT_FOUND */
    { 0x0152df,  18, 0x015a63,  18,    -2899 }, /* VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE */
    { 0x014089,  20, 0x019e19,  12,    -2897 }, /* VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND */
    { 0x00f05b,  26, 0x013703,  20,    -2896 }, /* VERR_PDM_MEDIAEX_IOREQID_CONFLICT */
    { 0x010855,  24, 0x00a4ae,  34,    -2895 }, /* VERR_PDM_MEDIAEX_IOBUF_UNDERRUN */
    { 0x010ecc,  24, 0x00aa4a,  33,    -2894 }, /* VERR_PDM_MEDIAEX_IOBUF_OVERFLOW */
    { 0x010add,  24, 0x01750f,  16,    -2893 }, /* VERR_PDM_MEDIAEX_IOREQ_CANCELED */
    { 0x01b381,   8, 0x002b0b,  59,    -2892 }, /* VERR_PDM_HM_IPE */
    { 0x016288,  17, 0x001ccb,  65,    -2891 }, /* VERR_PDM_NOT_PCI_BUS_MASTER */
    { 0x00a83b,  33, 0x00316f,  57,    -2890 }, /* VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER */
    { 0x00a6ce,  34, 0x00b8b1,  31,    -2889 }, /* VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION */
    { 0x01b391,   8, 0x01922d,  13,    -2888 }, /* VERR_PDM_DEV_IPE_1 */
    { 0x019734,  13, 0x014a1c,  19,    -2887 }, /* VERR_PDM_BAD_PCI_CONFIG */
    { 0x00d0b8,  29, 0x005371,  48,    -2886 }, /* VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE */
    { 0x01a18f,  11, 0x013a22,  20,    -2885 }, /* VERR_PDM_THREAD_IPE_2 */
    { 0x01a6b7,  11, 0x0142b9,  20,    -2884 }, /* VERR_PDM_THREAD_IPE_1 */
    { 0x016d70,  16, 0x008266,  39,    -2883 }, /* VERR_PDM_THREAD_INVALID_CALLER */
    { 0x0194c4,  13, 0x00d3c3,  28,    -2882 }, /* VERR_PDM_CRITSECT_NOT_FOUND */
    { 0x0183f8,  14, 0x016be0,  16,    -2881 }, /* VERR_PDM_CRITSECT_IPE */
    { 0x012592,  22, 0x002e0a,  58,    -2880 }, /* VERR_PDM_HPET_LEGACY_NOTIFY_MISSING */
    { 0x0115b9,  23, 0x00b51b,  32,    -2879 }, /* VERR_PDM_DEV_HEAP_R3_TO_GCPHYS */
    { 0x019af5,  12, 0x01934b,  13,    -2878 }, /* VERR_PDM_DRIVER_VERSION_MISMATCH */
    { 0x0198a9,  12, 0x016a2b,  17,    -2877 }, /* VERR_PDM_USBDEV_VERSION_MISMATCH */
    { 0x01a07d,  12, 0x018f07,  13,    -2876 }, /* VERR_PDM_DEVICE_VERSION_MISMATCH */
    { 0x018b30,  14, 0x0135af,  20,    -2875 }, /* VERR_PDM_DRVHLPR3_VERSION_MISMATCH */
    { 0x01a04d,  12, 0x01206a,  22,    -2874 }, /* VERR_PDM_DRVINS_VERSION_MISMATCH */
    { 0x018946,  14, 0x010ca5,  24,    -2873 }, /* VERR_PDM_USBHLPR3_VERSION_MISMATCH */
    { 0x019c15,  12, 0x00f507,  26,    -2872 }, /* VERR_PDM_USBINS_VERSION_MISMATCH */
    { 0x019ab9,  12, 0x013a0e,  20,    -2871 }, /* VERR_PDM_DEVHLP_VERSION_MISMATCH */
    { 0x0199e1,  12, 0x011e5a,  22,    -2870 }, /* VERR_PDM_DEVINS_VERSION_MISMATCH */
    { 0x010d04,  24, 0x00c9b2,  29,    -2869 }, /* VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES */
    { 0x013e82,  20, 0x00feaa,  25,    -2868 }, /* VERR_PDM_TOO_MANY_DRIVER_INSTANCES */
    { 0x013c16,  20, 0x00fccf,  25,    -2867 }, /* VERR_PDM_TOO_MANY_DEVICE_INSTANCES */
    { 0x013de2,  20, 0x002ad0,  59,    -2866 }, /* VERR_PDM_DRIVER_INVALID_PROPERTIES */
    { 0x00cda9,  29, 0x009afe,  35,    -2865 }, /* VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED */
    { 0x00cab7,  29, 0x009bf3,  35,    -2864 }, /* VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED */
    { 0x013202,  21, 0x008461,  39,    -2863 }, /* VERR_PDM_ASYNC_TEMPLATE_BUSY */
    { 0x01a612,  11, 0x00b1fb,  32,    -2862 }, /* VERR_PDM_NO_USBPROXY */
    { 0x0198e5,  12, 0x005c93,  46,    -2861 }, /* VERR_PDM_NO_USB_PORTS */
    { 0x01a704,  11, 0x007a82,  40,    -2860 }, /* VERR_PDM_NO_USB_HUBS */
    { 0x016d20,  16, 0x012096,  22,    -2859 }, /* VERR_PDM_USB_HUB_EXISTS */
    { 0x016b71,  16, 0x0155e3,  18,    -2858 }, /* VERR_PDM_USB_NAME_CLASH */
    { 0x014841,  19, 0x00d8cb,  28,    -2857 }, /* VERR_PDM_INVALID_USB_REGISTRATION */
    { 0x01a12c,  11, 0x004783,  51,    -2856 }, /* VERR_PDM_UNKNOWN_USBREG_VERSION */
    { 0x01b241,   8, 0x010d94,  24,    -2855 }, /* VERR_PDM_HIF_INVALID_VERSION */
    { 0x0149aa,  19, 0x0115fe,  23,    -2854 }, /* VERR_PDM_DRIVER_NO_RT_ATTACH */
    { 0x0150a4,  19, 0x0118c7,  23,    -2853 }, /* VERR_PDM_DEVICE_NO_RT_ATTACH */
    { 0x019b61,  12, 0x0112ab,  23,    -2852 }, /* VERR_PDM_HIF_OPEN_FAILED */
    { 0x011574,  23, 0x00506f,  49,    -2851 }, /* VERR_PDM_HIF_SHARING_VIOLATION */
    { 0x0177ee,  15, 0x0015bb,  69,    -2850 }, /* VERR_PDM_NO_RTC_INSTANCE */
    { 0x016b91,  16, 0x001ece,  64,    -2849 }, /* VERR_PDM_NO_DMAC_INSTANCE */
    { 0x0174af,  16, 0x001c8a,  65,    -2848 }, /* VERR_PDM_NO_APIC_INSTANCE */
    { 0x018022,  15, 0x00208c,  63,    -2847 }, /* VERR_PDM_NO_PIC_INSTANCE */
    { 0x00f900,  25, 0x00484c,  50,    -2846 }, /* VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01b5b1,   8, 0x016ef0,  16,    -2845 }, /* VERR_PDM_LUN_NOT_FOUND */
    { 0x013932,  20, 0x013573,  20,    -2844 }, /* VERR_PDM_DRIVER_INSTANCE_NOT_FOUND */
    { 0x01074d,  24, 0x008d47,  37,    -2843 }, /* VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND */
    { 0x010c45,  24, 0x00a0b3,  34,    -2842 }, /* VERR_PDM_DEVICE_INSTANCE_NO_IBASE */
    { 0x0138e2,  20, 0x0183dc,  14,    -2841 }, /* VERR_PDM_DEVICE_INSTANCE_NOT_FOUND */
    { 0x01a234,  11, 0x01ab72,  10,    -2840 }, /* VERR_PDM_DEVICE_NOT_FOUND */
    { 0x014f61,  19, 0x01522b,  18,    -2839 }, /* VERR_PDM_DEVICE_NAME_CLASH */
    { 0x014997,  19, 0x0084fd,  39,    -2838 }, /* VERR_PDM_INVALID_DEVICE_HOST_BITS */
    { 0x01396e,  20, 0x018298,  15,    -2837 }, /* VERR_PDM_INVALID_DEVICE_GUEST_BITS */
    { 0x0124f8,  22, 0x00d8cb,  28,    -2836 }, /* VERR_PDM_INVALID_DEVICE_REGISTRATION */
    { 0x01a2ce,  11, 0x0056f1,  47,    -2835 }, /* VERR_PDM_UNKNOWN_DEVREG_VERSION */
    { 0x019546,  13, 0x0036bd,  56,    -2834 }, /* VERR_PDM_NOT_PCI_DEVICE */
    { 0x01acd0,  10, 0x00d288,  29,    -2833 }, /* VERR_PDM_NO_PCI_BUS */
    { 0x010085,  25, 0x0045eb,  51,    -2832 }, /* VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE */
    { 0x014ac7,  19, 0x018298,  15,    -2831 }, /* VERR_PDM_INVALID_DRIVER_HOST_BITS */
    { 0x011e70,  22, 0x00dd0f,  28,    -2830 }, /* VERR_PDM_INVALID_DRIVER_REGISTRATION */
    { 0x01a1b0,  11, 0x00574f,  47,    -2829 }, /* VERR_PDM_UNKNOWN_DRVREG_VERSION */
    { 0x015116,  19, 0x0155e3,  18,    -2828 }, /* VERR_PDM_DRIVER_NAME_CLASH */
    { 0x01442d,  19, 0x012e7b,  21,    -2827 }, /* VERR_PDM_MODULE_NAME_TOO_LONG */
    { 0x0125d4,  22, 0x00372d,  56,    -2826 }, /* VERR_PDM_NO_REGISTRATION_EXPORT */
    { 0x014783,  19, 0x007991,  41,    -2825 }, /* VERR_PDM_MODULE_NAME_CLASH */
    { 0x01a725,  11, 0x012f62,  21,    -2823 }, /* VERR_PDM_DRIVER_NOT_FOUND */
    { 0x014c30,  19, 0x003cb5,  54,    -2822 }, /* VERR_PDM_CFG_MISSING_DRIVER_NAME */
    { 0x00f900,  18, 0x00030f, 110,    -2821 }, /* VERR_PDM_NO_DRIVER_ATTACHED */
    { 0x015446,  18, 0x004cca,  50,    -2820 }, /* VERR_PDM_DRIVER_ALREADY_ATTACHED */
    { 0x01ad34,  10, 0x0167e9,  17,    -2819 }, /* VERR_PDM_UNSUPPORTED_BLOCK_TYPE */
    { 0x0137a2,  20, 0x001e0e,  64,    -2818 }, /* VERR_PDM_BLOCK_UNKNOWN_TRANSLATION */
    { 0x01ac4e,  10, 0x003370,  57,    -2817 }, /* VERR_PDM_BLOCK_UNKNOWN_TYPE */
    { 0x01aadc,  10, 0x006a65,  43,    -2816 }, /* VERR_PDM_BLOCK_NO_TYPE */
    { 0x01844c,  14, 0x00decf,  28,    -2815 }, /* VERR_PDM_MEDIA_LOCKED */
    { 0x0180a9,  15, 0x00eea1,  26,    -2814 }, /* VERR_PDM_MEDIA_MOUNTED */
    { 0x01749f,  16, 0x006397,  44,    -2813 }, /* VERR_PDM_MEDIA_NOT_MOUNTED */
    { 0x015a1b,  18, 0x003e2d,  53,    -2812 }, /* VERR_PDM_TRANSLATION_NOT_SET */
    { 0x01809a,  15, 0x004cfc,  50,    -2811 }, /* VERR_PDM_GEOMETRY_NOT_SET */
    { 0x015380,  18, 0x016178,  17,    -2810 }, /* VERR_PDM_NO_ATTACHED_DRIVER */
    { 0x017180,  16, 0x008609,  38,    -2809 }, /* VERR_PDM_DEVINS_NO_ATTACH */
    { 0x0170c0,  16, 0x005a6b,  46,    -2808 }, /* VERR_PDM_DRVINS_NO_ATTACH */
    { 0x018a50,  14, 0x008aef,  38,    -2807 }, /* VERR_PDM_NO_QUEUE_ITEMS */
    { 0x017b18,  15, 0x0067b5,  43,    -2806 }, /* VERR_PDM_TOO_PCI_MANY_DEVICES */
    { 0x013eaa,  20, 0x00d60f,  28,    -2805 }, /* VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES */
    { 0x014c56,  13, 0x003c13,  54,    -2804 }, /* VERR_PDM_MISSING_INTERFACE */
    { 0x014c56,  19, 0x001f4e,  64,    -2803 }, /* VERR_PDM_MISSING_INTERFACE_BELOW */
    { 0x01507e,  19, 0x0027ca,  60,    -2802 }, /* VERR_PDM_MISSING_INTERFACE_ABOVE */
    { 0x014309,  20, 0x00de7b,  28,    -2801 }, /* VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES */
    { 0x01a3cb,  11, 0x00cde3,  29,    -2800 }, /* VERR_PDM_NO_SUCH_LUN */
    { 0x0116fb,  23, 0x0065d3,  44,    -2721 }, /* VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET */
    { 0x0161de,  17, 0x012da9,  21,    -2720 }, /* VERR_VMM_CANNOT_BLOCK */
    { 0x00bb5b,  31, 0x001e8e,  64,    -2719 }, /* VERR_VMM_CONTEXT_HOOK_STILL_ENABLED */
    { 0x01395a,  20, 0x00fd33,  25,    -2718 }, /* VERR_VMM_WRONG_NEM_VMCPU_STATE */
    { 0x0124a0,  22, 0x00138c,  71,    -2717 }, /* VERR_VMM_SMAP_BUT_AC_CLEAR */
    { 0x01287f,  21, 0x00f1c7,  26,    -2716 }, /* VERR_VMM_WRONG_HM_VMCPU_STATE */
    { 0x015811,  18, 0x00ca09,  29,    -2715 }, /* VERR_VMM_SWITCHER_STUB */
    { 0x017100,  16, 0x015410,  18,    -2713 }, /* VERR_VMM_SWITCHER_IPE_1 */
    { 0x017acd,  15, 0x01781b,  15,    -2709 }, /* VERR_VMM_LONG_JMP_ERROR */
    { 0x01a1f2,  11, 0x01b84a,   7,    -2705 }, /* VERR_VMM_RC_VERSION_MISMATCH */
    { 0x01a418,  11, 0x01b79b,   7,    -2704 }, /* VERR_VMM_R0_VERSION_MISMATCH */
    { 0x010735,  24, 0x00da6f,  28,    -2703 }, /* VERR_VMM_RING3_CALL_DISABLED */
    { 0x016c50,  16, 0x008fe1,  37,    -2702 }, /* VERR_VMM_HYPER_CR3_MISMATCH */
    { 0x014025,  20, 0x00909a,  37,    -2701 }, /* VERR_VMM_RING0_ASSERTION */
    { 0x012d40,  21, 0x0156bb,  18,    -2663 }, /* VERR_IOM_MMIO_REGION_NOT_MAPPED */
    { 0x0133d0,  21, 0x015a99,  18,    -2662 }, /* VERR_IOM_MMIO_REGION_ALREADY_MAPPED */
    { 0x01884a,  14, 0x01a9ba,  10,    -2661 }, /* VERR_IOM_INVALID_MMIO_HANDLE */
    { 0x011dc0,  22, 0x012927,  21,    -2660 }, /* VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS */
    { 0x0136db,  20, 0x0123f0,  22,    -2653 }, /* VERR_IOM_IOPORTS_NOT_MAPPED */
    { 0x013da6,  20, 0x011d7e,  22,    -2652 }, /* VERR_IOM_IOPORTS_ALREADY_MAPPED */
    { 0x014df8,  19, 0x01660d,  17,    -2651 }, /* VERR_IOM_INVALID_IOPORT_HANDLE */
    { 0x00e632,  27, 0x00da53,  28,    -2650 }, /* VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS */
    { 0x015c91,  18, 0x00c55f,  30,    -2638 }, /* VERR_IOM_FF_STATUS_IPE */
    { 0x01a3c0,  11, 0x002d94,  59,    -2637 }, /* VERR_IOM_HM_IPE */
    { 0x01b05a,   9, 0x01a649,  11,    -2636 }, /* VERR_IOM_MMIO_IPE_3 */
    { 0x01ad94,   9, 0x01a486,  11,    -2635 }, /* VERR_IOM_MMIO_IPE_2 */
    { 0x01adc1,   9, 0x01a2c3,  11,    -2634 }, /* VERR_IOM_MMIO_IPE_1 */
    { 0x0184ae,  14, 0x0157a5,  18,    -2633 }, /* VERR_IOM_IOPORT_IPE_3 */
    { 0x0184ca,  14, 0x015207,  18,    -2632 }, /* VERR_IOM_IOPORT_IPE_2 */
    { 0x0184d8,  14, 0x015967,  18,    -2631 }, /* VERR_IOM_IOPORT_IPE_1 */
    { 0x014c8f,  19, 0x005d78,  45,    -2630 }, /* VERR_IOM_IOPORT_UNKNOWN_OPCODE */
    { 0x015685,  18, 0x00102e,  73,    -2614 }, /* VERR_IOM_IOPORT_UNUSED */
    { 0x0111dc,  23, 0x0052e1,  48,    -2613 }, /* VERR_IOM_MMIO_HANDLER_DISASM_ERROR */
    { 0x01003a,  25, 0x009427,  36,    -2612 }, /* VERR_IOM_MMIO_HANDLER_BOGUS_CALL */
    { 0x018bbc,  14, 0x00958f,  36,    -2611 }, /* VERR_IOM_INVALID_IOPORT_SIZE */
    { 0x0117ca,  23, 0x00da37,  28,    -2610 }, /* VERR_IOM_INCOMPLETE_MMIO_RANGE */
    { 0x0181b7,  15, 0x011eb2,  22,    -2609 }, /* VERR_IOM_MMIO_RANGE_NOT_FOUND */
    { 0x0134e0,  21, 0x008bad,  38,    -2608 }, /* VERR_IOM_MMIO_RANGE_CONFLICT */
    { 0x014b26,  19, 0x00812e,  39,    -2607 }, /* VERR_IOM_NOT_MMIO_RANGE_OWNER */
    { 0x016df0,  16, 0x003ba7,  54,    -2606 }, /* VERR_IOM_NO_R3_MMIO_RANGE */
    { 0x0195c8,  13, 0x014dd2,  19,    -2605 }, /* VERR_IOM_INVALID_MMIO_RANGE */
    { 0x010a35,  24, 0x005c37,  46,    -2604 }, /* VERR_IOM_NOT_IOPORT_RANGE_OWNER */
    { 0x014291,  20, 0x002660,  61,    -2603 }, /* VERR_IOM_IOPORT_RANGE_NOT_FOUND */
    { 0x00ef09,  26, 0x0060a2,  45,    -2602 }, /* VERR_IOM_IOPORT_RANGE_CONFLICT */
    { 0x01271a,  21, 0x00252f,  61,    -2601 }, /* VERR_IOM_NO_R3_IOPORT_RANGE */
    { 0x015715,  18, 0x00f5bd,  26,    -2600 }, /* VERR_IOM_INVALID_IOPORT_RANGE */
    { 0x019849,  12, 0x00278e,  60,    -2509 }, /* VERR_SELM_HM_IPE */
    { 0x017d8e,  15, 0x003c7f,  54,    -2508 }, /* VERR_SELM_GDT_TOO_FULL */
    { 0x016cf0,  16, 0x005b7f,  46,    -2507 }, /* VERR_SELM_GDT_READ_ERROR */
    { 0x011546,  23, 0x00d663,  28,    -2506 }, /* VERR_SELM_LDT_OUT_OF_BOUNDS */
    { 0x01acb2,  10, 0x017c71,  15,    -2505 }, /* VERR_SELM_INVALID_LDT */
    { 0x01ac94,  10, 0x014912,  19,    -2504 }, /* VERR_SELM_NO_TSS */
    { 0x012550,  22, 0x006938,  43,    -2502 }, /* VERR_SELM_SHADOW_TSS_WRITE */
    { 0x0124cc,  22, 0x00690d,  43,    -2501 }, /* VERR_SELM_SHADOW_LDT_WRITE */
    { 0x012130,  22, 0x0069e4,  43,    -2500 }, /* VERR_SELM_SHADOW_GDT_WRITE */
    { 0x0198cd,  12, 0x0028f6,  60,    -2409 }, /* VERR_TRPM_HM_IPE */
    { 0x01b1d1,   8, 0x019da1,  12,    -2408 }, /* VERR_TRPM_IPE_3 */
    { 0x01b1d9,   8, 0x019ea9,  12,    -2407 }, /* VERR_TRPM_IPE_2 */
    { 0x01b1f9,   8, 0x019885,  12,    -2406 }, /* VERR_TRPM_IPE_1 */
    { 0x016a6f,  17, 0x01651f,  17,    -2405 }, /* VERR_TRPM_BAD_TRAP_IN_OP */
    { 0x01a2b8,  11, 0x013cf2,  20,    -2404 }, /* VERR_TRPM_PANIC */
    { 0x01763f,  16, 0x00c7b7,  30,    -2403 }, /* VERR_TRPM_DONT_PANIC */
    { 0x01219e,  22, 0x006c13,  43,    -2402 }, /* VERR_TRPM_SHADOW_IDT_WRITE */
    { 0x016035,  17, 0x019cbd,  12,    -2401 }, /* VERR_TRPM_ACTIVE_TRAP */
    { 0x015c49,  18, 0x018e85,  13,    -2400 }, /* VERR_TRPM_NO_ACTIVE_TRAP */
    { 0x01b884,   6, 0x01aecf,   9,    -2299 }, /* VERR_TM_IPE_9 */
    { 0x01b950,   6, 0x01b063,   9,    -2298 }, /* VERR_TM_IPE_8 */
    { 0x01b88a,   6, 0x01ae2d,   9,    -2297 }, /* VERR_TM_IPE_7 */
    { 0x01b890,   6, 0x01b01b,   9,    -2296 }, /* VERR_TM_IPE_6 */
    { 0x01b902,   6, 0x01aec6,   9,    -2295 }, /* VERR_TM_IPE_5 */
    { 0x01b94a,   6, 0x01aeb4,   9,    -2294 }, /* VERR_TM_IPE_4 */
    { 0x01b95c,   6, 0x01ade5,   9,    -2293 }, /* VERR_TM_IPE_3 */
    { 0x01b962,   6, 0x01aff7,   9,    -2292 }, /* VERR_TM_IPE_2 */
    { 0x01b968,   6, 0x01af56,   9,    -2291 }, /* VERR_TM_IPE_1 */
    { 0x00e5fc,  27, 0x009763,  36,    -2214 }, /* VERR_TM_TIMER_QUEUE_CANNOT_GROW */
    { 0x017290,  16, 0x01436d,  20,    -2213 }, /* VERR_TM_INVALID_TIMER_QUEUE */
    { 0x019c69,  12, 0x010eb4,  24,    -2212 }, /* VERR_TM_TOO_MANY_TIMERS */
    { 0x0114bc,  23, 0x014537,  19,    -2211 }, /* VERR_TM_VIRTUAL_TICKING_IPE */
    { 0x017e24,  15, 0x00d3fb,  28,    -2210 }, /* VERR_TM_TSC_ALREADY_PAUSED */
    { 0x01742f,  16, 0x00c5d7,  30,    -2209 }, /* VERR_TM_TSC_ALREADY_TICKING */
    { 0x01381a,  20, 0x00c28f,  30,    -2208 }, /* VERR_TM_TIMER_UNSTABLE_STATE */
    { 0x01756f,  16, 0x0041e2,  52,    -2207 }, /* VERR_TM_TIMER_BAD_CLOCK */
    { 0x00d38b,  28, 0x00d183,  29,    -2206 }, /* VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG */
    { 0x01ad9d,   9, 0x0145cf,  19,    -2205 }, /* VERR_TM_GIP_VERSION */
    { 0x016ae1,  16, 0x0172df,  16,    -2204 }, /* VERR_TM_GIP_REQUIRED */
    { 0x0188ba,  14, 0x002842,  60,    -2203 }, /* VERR_TM_UNSTABLE_STATE */
    { 0x01b872,   6, 0x00ff40,  25,    -2202 }, /* VERR_TM_UNKNOWN_STATE */
    { 0x01b8b4,   6, 0x010496,  24,    -2201 }, /* VERR_TM_INVALID_STATE */
    { 0x01a9ec,  10, 0x00f381,  26,    -2200 }, /* VERR_TM_LOAD_STATE */
    { 0x01b2b9,   8, 0x019bd9,  12,    -2165 }, /* VERR_CFGM_IPE_1 */
    { 0x01550c,  18, 0x006e13,  42,    -2164 }, /* VERR_CFGM_CONFIG_UNKNOWN_NODE */
    { 0x015103,  19, 0x00b0fb,  32,    -2163 }, /* VERR_CFGM_CONFIG_UNKNOWN_VALUE */
    { 0x016299,  17, 0x003b71,  54,    -2162 }, /* VERR_CFGM_LEAF_EXISTS */
    { 0x016321,  17, 0x0039f7,  54,    -2161 }, /* VERR_CFGM_NODE_EXISTS */
    { 0x016f10,  16, 0x007df2,  40,    -2160 }, /* VERR_CFGM_INVALID_NODE_PATH */
    { 0x01834c,  15, 0x008655,  38,    -2110 }, /* VERR_CFGM_NOT_PASSWORD */
    { 0x014d3a,  19, 0x00ec31,  26,    -2109 }, /* VERR_CFGM_NOT_ENOUGH_SPACE */
    { 0x019c09,  12, 0x01551e,  18,    -2108 }, /* VERR_CFGM_NOT_BYTES */
    { 0x01b2e9,   8, 0x0082db,  39,    -2107 }, /* VERR_CFGM_NOT_STRING */
    { 0x018406,  14, 0x019727,  13,    -2106 }, /* VERR_CFGM_NOT_INTEGER */
    { 0x01a37e,  11, 0x0169a3,  17,    -2105 }, /* VERR_CFGM_NO_NODE */
    { 0x01964a,  13, 0x01169f,  23,    -2104 }, /* VERR_CFGM_NO_PARENT */
    { 0x018698,  14, 0x01b509,   8,    -2103 }, /* VERR_CFGM_VALUE_NOT_FOUND */
    { 0x016893,  17, 0x011f0a,  22,    -2102 }, /* VERR_CFGM_INVALID_CHILD_PATH */
    { 0x0183a4,  14, 0x018bf4,  14,    -2101 }, /* VERR_CFGM_CHILD_NOT_FOUND */
    { 0x0151e3,  18, 0x00a2f4,  34,    -2100 }, /* VERR_CFGM_INTEGER_TOO_BIG */
    { 0x014984,  19, 0x015e2f,  18,    -2007 }, /* VERR_VRDP_ACCESS_DENIED */
    { 0x01b561,   8, 0x01441a,  19,    -2006 }, /* VERR_VRDP_NO_MEMORY */
    { 0x01a1dc,  11, 0x00a558,  34,    -2005 }, /* VERR_VRDP_INVALID_MODE */
    { 0x01109a,  23, 0x003014,  58,    -2004 }, /* VERR_VRDP_INSUFFICIENT_DATA */
    { 0x01b289,   8, 0x011740,  23,    -2003 }, /* VERR_VRDP_NOT_SUPPORTED */
    { 0x0172a0,  16, 0x0104ae,  24,    -2002 }, /* VERR_VRDP_PROTOCOL_ERROR */
    { 0x013280,  21, 0x00ab10,  33,    -2001 }, /* VERR_VRDP_SEC_ENGINE_FAIL */
    { 0x0145a9,  19, 0x013b9e,  20,    -2000 }, /* VERR_VRDP_ISO_UNSUPPORTED */
    { 0x016453,  17, 0x00d1a0,  29,    -1919 }, /* VERR_VM_REQUEST_KILLED */
    { 0x017e9c,  15, 0x01751f,  16,    -1918 }, /* VERR_VM_FATAL_WAIT_ERROR */
    { 0x0133f9,  21, 0x006fe1,  42,    -1917 }, /* VERR_VM_REQUEST_TOO_MANY_ARGS_IPE */
    { 0x018b68,  14, 0x0153da,  18,    -1916 }, /* VERR_VM_UNEXPECTED_UNSTABLE_STATE */
    { 0x01b80b,   7, 0x012855,  21,    -1915 }, /* VERR_VM_UNEXPECTED_VM_STATE */
    { 0x016bc1,  16, 0x005b23,  46,    -1914 }, /* VERR_VM_THREAD_IS_EMT */
    { 0x015d45,  18, 0x00ab94,  33,    -1913 }, /* VERR_VM_SAVE_STATE_NOT_ALLOWED */
    { 0x019073,  13, 0x00cc4d,  29,    -1912 }, /* VERR_VM_DRIVER_VERSION_MISMATCH */
    { 0x016c40,  16, 0x00fa2c,  25,    -1911 }, /* VERR_VM_DRIVER_OPEN_ERROR */
    { 0x01766f,  16, 0x010215,  25,    -1910 }, /* VERR_VM_DRIVER_LOAD_ERROR */
    { 0x0129e4,  21, 0x0172ef,  16,    -1909 }, /* VERR_VM_DRIVER_NOT_ACCESSIBLE */
    { 0x013d2e,  20, 0x017e6f,  15,    -1908 }, /* VERR_VM_DRIVER_NOT_INSTALLED */
    { 0x01b6c9,   7, 0x01a988,  10,    -1907 }, /* VERR_VM_INVALID_VM_STATE */
    { 0x018d28,  14, 0x00487e,  50,    -1906 }, /* VERR_VM_THREAD_NOT_EMT */
    { 0x01186b,  23, 0x00a15d,  34,    -1905 }, /* VERR_VM_REQUEST_STATUS_FREED */
    { 0x00bb7a,  31, 0x002932,  60,    -1904 }, /* VERR_VM_REQUEST_STATUS_STILL_PENDING */
    { 0x014666,  19, 0x01a4f4,  11,    -1903 }, /* VERR_VM_REQUEST_INVALID_PACKAGE */
    { 0x019c5d,  12, 0x01ad02,  10,    -1902 }, /* VERR_VM_REQUEST_STATE */
    { 0x0191ec,  13, 0x01b03f,   9,    -1901 }, /* VERR_VM_REQUEST_INVALID_TYPE */
    { 0x01927b,  13, 0x00e869,  27,    -1900 }, /* VERR_VM_ATRESET_NOT_FOUND */
    { 0x00f838,  25, 0x0164ca,  17,    -1880 }, /* VERR_SSM_ENUM_VALUE_OUT_OF_RANGE */
    { 0x00b25b,  32, 0x000d8d,  77,    -1879 }, /* VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION */
    { 0x01bb85,   4, 0x0199a5,  12,    -1878 }, /* VERR_SSM_IPE_3 */
    { 0x01bb89,   4, 0x019f39,  12,    -1877 }, /* VERR_SSM_IPE_2 */
    { 0x01bb8d,   4, 0x01a0e9,  12,    -1876 }, /* VERR_SSM_IPE_1 */
    { 0x01b451,   8, 0x00c978,  29,    -1875 }, /* VERR_SSM_BAD_REC_TYPE */
    { 0x01ad52,  10, 0x00580b,  47,    -1874 }, /* VERR_SSM_MEM_TOO_BIG */
    { 0x01761f,  16, 0x006b11,  43,    -1873 }, /* VERR_SSM_SKIP_BACKWARDS */
    { 0x01b6ec,   7, 0x006657,  44,    -1872 }, /* VERR_SSM_UNEXPECTED_PASS */
    { 0x01abae,  10, 0x01ae24,   9,    -1871 }, /* VERR_SSM_STREAM_ERROR */
    { 0x01866e,  14, 0x010526,  24,    -1870 }, /* VERR_SSM_FIELD_INVALID_VALUE */
    { 0x015a75,  18, 0x011152,  23,    -1869 }, /* VERR_SSM_FIELD_INVALID_PADDING_SIZE */
    { 0x016574,  17, 0x00753e,  41,    -1868 }, /* VERR_SSM_FIELD_INVALID_CALLBACK */
    { 0x013b12,  20, 0x0072d5,  42,    -1867 }, /* VERR_SSM_FIELD_NOT_CONSECUTIVE */
    { 0x012a23,  21, 0x00dd2b,  28,    -1866 }, /* VERR_SSM_FIELD_OUT_OF_BOUNDS */
    { 0x01a85c,  10, 0x0091c2,  37,    -1865 }, /* VERR_SSM_FIELD_INVALID_SIZE */
    { 0x0177fd,  15, 0x003ceb,  54,    -1864 }, /* VERR_SSM_FIELD_COMPLEX */
    { 0x018422,  14, 0x002e7e,  58,    -1863 }, /* VERR_SSM_LIVE_FATAL_ERROR */
    { 0x0122fe,  22, 0x002b81,  59,    -1862 }, /* VERR_SSM_LIVE_GURU_MEDITATION */
    { 0x015e65,  18, 0x009ddd,  35,    -1861 }, /* VERR_SSM_LIVE_POWERED_OFF */
    { 0x019909,  12, 0x017df7,  15,    -1860 }, /* VERR_SSM_ALREADY_CANCELLED */
    { 0x0136c7,  20, 0x01080d,  24,    -1859 }, /* VERR_SSM_NO_PENDING_OPERATION */
    { 0x01a276,  11, 0x01967e,  13,    -1858 }, /* VERR_SSM_CANCELLED */
    { 0x0145bc,  19, 0x002ce3,  59,    -1857 }, /* VERR_SSM_LOW_ON_DISK_SPACE */
    { 0x019184,  13, 0x002623,  61,    -1856 }, /* VERR_SSM_STATE_GREW_TOO_BIG */
    { 0x01aae6,  10, 0x002d59,  59,    -1855 }, /* VERR_SSM_TOO_MANY_PASSES */
    { 0x013e0a,  20, 0x016ee0,  16,    -1853 }, /* VERR_SSM_VOTE_FOR_GIVING_UP */
    { 0x0170e0,  16, 0x002437,  62,    -1850 }, /* VERR_SSM_GCPTR_OVERFLOW */
    { 0x0167a5,  17, 0x00210a,  63,    -1849 }, /* VERR_SSM_GCPHYS_OVERFLOW */
    { 0x01b6ad,   7, 0x00a0f7,  34,    -1848 }, /* VERR_SSM_UNEXPECTED_DATA */
    { 0x0160df,  17, 0x01315a,  21,    -1847 }, /* VERR_SSM_STRUCTURE_MAGIC */
    { 0x014608,  19, 0x002245,  63,    -1846 }, /* VERR_SSM_IDE_ASYNC_TIMEOUT */
    { 0x015eac,  18, 0x008488,  39,    -1845 }, /* VERR_SSM_VIRTUAL_CLOCK_HZ */
    { 0x01831f,  15, 0x00636b,  44,    -1844 }, /* VERR_SSM_LOAD_CONFIG_MISMATCH */
    { 0x019dd1,  12, 0x00601b,  45,    -1843 }, /* VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH */
    { 0x0185aa,  14, 0x0019b7,  67,    -1842 }, /* VERR_SSM_LOAD_CPUID_MISMATCH */
    { 0x00f249,  26, 0x00ee53,  26,    -1841 }, /* VERR_SSM_DATA_UNIT_FORMAT_CHANGED */
    { 0x01890e,  14, 0x017f32,  15,    -1840 }, /* VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION */
    { 0x017210,  16, 0x00d797,  28,    -1833 }, /* VERR_SSM_LOADED_TOO_LITTLE */
    { 0x01bc15,   4, 0x00d797,  28,    -1832 }, /* VERR_SSM_INVALID_STATE */
    { 0x018e24,  14, 0x00256c,  61,    -1831 }, /* VERR_SSM_LOADED_TOO_MUCH */
    { 0x019ddd,  12, 0x003878,  55,    -1830 }, /* VERR_SSM_NO_LOAD_EXEC */
    { 0x019435,  13, 0x0122d2,  22,    -1827 }, /* VERR_SSM_INTEGRITY_DIR_MAGIC */
    { 0x019435,   7, 0x0130f1,  21,    -1826 }, /* VERR_SSM_INTEGRITY_DIR */
    { 0x0169c5,  17, 0x0102c4,  25,    -1825 }, /* VERR_SSM_INTEGRITY_DECOMPRESSION */
    { 0x0177ae,  16, 0x00ae5b,  32,    -1824 }, /* VERR_SSM_INTEGRITY_REC_TERM_CRC */
    { 0x0177ae,  12, 0x00c889,  30,    -1823 }, /* VERR_SSM_INTEGRITY_REC_TERM */
    { 0x01a158,  11, 0x014eb6,  19,    -1822 }, /* VERR_SSM_INTEGRITY_REC_HDR */
    { 0x01ad20,  10, 0x015c13,  18,    -1821 }, /* VERR_SSM_INTEGRITY_FOOTER */
    { 0x01abd6,  10, 0x00db17,  28,    -1820 }, /* VERR_SSM_INTEGRITY_VBOX_VERSION */
    { 0x01a19a,  11, 0x00a39e,  34,    -1819 }, /* VERR_SSM_INTEGRITY_UNIT_NOT_FOUND */
    { 0x018e16,  14, 0x00d70b,  28,    -1818 }, /* VERR_SSM_INTEGRITY_UNIT_MAGIC */
    { 0x018e16,   8, 0x01684f,  17,    -1817 }, /* VERR_SSM_INTEGRITY_UNIT */
    { 0x01a94c,  10, 0x014b98,  19,    -1816 }, /* VERR_SSM_INTEGRITY_HEADER */
    { 0x018a7a,  14, 0x00ad5b,  32,    -1815 }, /* VERR_SMM_INTEGRITY_MACHINE */
    { 0x01b794,   7, 0x00f63f,  26,    -1814 }, /* VERR_SSM_INTEGRITY_CRC */
    { 0x01bb5c,   5, 0x00772a,  41,    -1813 }, /* VERR_SSM_INTEGRITY_SIZE */
    { 0x01bb52,   5, 0x018efa,  13,    -1812 }, /* VERR_SSM_INTEGRITY_VERSION */
    { 0x01ad8b,   9, 0x00d5bb,  28,    -1811 }, /* VERR_SSM_INTEGRITY_MAGIC */
    { 0x0169c5,   3, 0x00e725,  27,    -1810 }, /* VERR_SSM_INTEGRITY */
    { 0x019288,  13, 0x00cf3f,  29,    -1802 }, /* VERR_SSM_UNIT_NOT_OWNER */
    { 0x01af68,   9, 0x017060,  16,    -1801 }, /* VERR_SSM_UNIT_NOT_FOUND */
    { 0x01915d,  13, 0x01827a,  15,    -1800 }, /* VERR_SSM_UNIT_EXISTS */
    { 0x014aa1,  19, 0x01a794,  10,    -1771 }, /* VERR_CPUM_UNSUPPORTED_ID_REG_VALUE */
    { 0x015dc3,  18, 0x01680b,  17,    -1770 }, /* VERR_CPUM_UNSUPPORTED_ID_REGISTER */
    { 0x010bfd,  24, 0x004382,  52,    -1768 }, /* VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO */
    { 0x013b3a,  20, 0x001c08,  65,    -1767 }, /* VERR_CPUM_INVALID_HWVIRT_CONFIG */
    { 0x01a33c,  11, 0x0117e1,  23,    -1765 }, /* VERR_CPUM_INVALID_XCR0 */
    { 0x016e30,  16, 0x011a20,  23,    -1764 }, /* VERR_CPUM_INVALID_XSAVE_HDR */
    { 0x012054,  22, 0x009109,  37,    -1763 }, /* VERR_CPUM_INVALID_XSAVE_COMP_MASK */
    { 0x00a02b,  34, 0x0014ec,  69,    -1762 }, /* VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK */
    { 0x014c7c,  19, 0x01b0d8,   9,    -1761 }, /* VERR_CPUM_INVALID_CONFIG_VALUE */
    { 0x017c44,  15, 0x015a87,  18,    -1760 }, /* VERR_TOO_MANY_CPUID_LEAVES */
    { 0x00f73e,  25, 0x00e884,  27,    -1757 }, /* VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET */
    { 0x017848,  15, 0x00c95b,  29,    -1756 }, /* VERR_CPUM_DB_CPU_NOT_FOUND */
    { 0x01b281,   8, 0x01a628,  11,    -1755 }, /* VERR_CPUM_IPE_2 */
    { 0x01b291,   8, 0x01a352,  11,    -1754 }, /* VERR_CPUM_IPE_1 */
    { 0x01113b,  23, 0x008cfd,  37,    -1753 }, /* VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES */
    { 0x011cb8,  22, 0x000f51,  74,    -1752 }, /* VERR_CPUM_HIDDEN_CS_LOAD_ERROR */
    { 0x00faf4,  25, 0x00b75b,  32,    -1751 }, /* VERR_CPUM_INCOMPATIBLE_CONFIG */
    { 0x01776e,  16, 0x00862f,  38,    -1750 }, /* VERR_CPUM_RAISE_GP_0 */
    { 0x0181d5,  15, 0x006b3c,  43,    -1702 }, /* VERR_MM_BAD_TRAP_TYPE_IPE */
    { 0x019fe1,  12, 0x010be5,  24,    -1701 }, /* VERR_MM_HYPER_NO_MEMORY */
    { 0x016fb0,  16, 0x001f0e,  64,    -1700 }, /* VERR_MM_RAM_CONFLICT */
    { 0x0184f4,  14, 0x016bd0,  16,    -1692 }, /* VERR_PGM_TOO_MANY_ROM_RANGES */
    { 0x012bc6,  21, 0x0095b3,  36,    -1691 }, /* VERR_PGM_PHYS_RAM_LOOKUP_IPE */
    { 0x018786,  14, 0x016ea0,  16,    -1690 }, /* VERR_PGM_TOO_MANY_RAM_RANGES */
    { 0x017974,  15, 0x005664,  47,    -1689 }, /* VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE */
    { 0x017983,  15, 0x003a63,  54,    -1688 }, /* VERR_PGM_PAE_PDPE_RSVD */
    { 0x018a6c,  14, 0x012cec,  21,    -1687 }, /* VERR_PGM_SHW_NONE_IPE */
    { 0x01ac08,  10, 0x01b149,   8,    -1686 }, /* VERR_PGM_MODE_IPE */
    { 0x0180b8,  15, 0x0040de,  52,    -1685 }, /* VERR_PGM_PHYS_MMIO_EX_IPE */
    { 0x0129ba,  21, 0x003f36,  53,    -1684 }, /* VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE */
    { 0x0176cf,  16, 0x015673,  18,    -1683 }, /* VERR_PGM_TOO_MANY_MMIO2_RANGES */
    { 0x010c2d,  24, 0x0090bf,  37,    -1682 }, /* VERR_PGM_PCI_PASSTHRU_MISCONFIG */
    { 0x01588f,  18, 0x009153,  37,    -1681 }, /* VERR_PGM_PHYS_NULL_PAGE_PARAM */
    { 0x018301,  15, 0x01155d,  23,    -1680 }, /* VERR_PGM_PHYS_PAGE_GET_IPE */
    { 0x011404,  23, 0x01030f,  25,    -1679 }, /* VERR_PGM_WRITE_MONITOR_ENGAGED */
    { 0x01aad2,  10, 0x019ee5,  12,    -1678 }, /* VERR_PGM_POOL_IPE */
    { 0x0104c6,  24, 0x00789b,  41,    -1677 }, /* VERR_PGM_POOL_MAXED_OUT_ALREADY */
    { 0x019442,  13, 0x011fa4,  22,    -1676 }, /* VERR_PGM_MAPPING_IPE */
    { 0x01892a,  14, 0x00c68b,  30,    -1675 }, /* VERR_PGM_POOL_TOO_MANY_LOOPS */
    { 0x0186de,  14, 0x00c721,  30,    -1674 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_4 */
    { 0x0187a2,  14, 0x00c39d,  30,    -1673 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_3 */
    { 0x01883c,  14, 0x00c82f,  30,    -1672 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_2 */
    { 0x0187e8,  14, 0x00c253,  30,    -1671 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_1 */
    { 0x015847,  18, 0x00e173,  27,    -1670 }, /* VERR_PGM_PHYS_HANDLER_IPE */
    { 0x019ff9,  12, 0x00a602,  34,    -1669 }, /* VERR_PGM_INVALID_PDPE_ADDR */
    { 0x01a680,  11, 0x00997d,  35,    -1668 }, /* VERR_PGM_INVALID_CR3_ADDR */
    { 0x017dbb,  15, 0x00237d,  62,    -1667 }, /* VERR_PGM_NOT_USED_IN_MODE */
    { 0x018f3b,  13, 0x012bdb,  21,    -1666 }, /* VERR_PGM_POOL_GET_PAGE_FAILED */
    { 0x018396,  14, 0x01937f,  13,    -1665 }, /* VERR_PGM_PML4_MAPPING */
    { 0x019d7d,  12, 0x00f3e9,  26,    -1664 }, /* VERR_PGM_HANDY_PAGE_IPE */
    { 0x019ed9,  12, 0x010af5,  24,    -1663 }, /* VERR_PGM_DYNMAP_IPE */
    { 0x019317,  13, 0x017bf9,  15,    -1662 }, /* VERR_PGM_SAVED_REC_TYPE */
    { 0x015f9c,  17, 0x00a26c,  34,    -1661 }, /* VERR_PGM_SAVED_ROM_PAGE_PROT */
    { 0x017f23,  15, 0x00922f,  36,    -1660 }, /* VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND */
    { 0x01413d,  20, 0x0077ce,  41,    -1659 }, /* VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND */
    { 0x0162dd,  17, 0x008927,  38,    -1658 }, /* VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND */
    { 0x012340,  22, 0x006861,  43,    -1657 }, /* VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND */
    { 0x01ba3a,   5, 0x00cb48,  29,    -1656 }, /* VERR_PGM_UNEXPECTED_PAGE_STATE */
    { 0x01acee,  10, 0x00d07e,  29,    -1655 }, /* VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE */
    { 0x01a39f,  11, 0x018d8a,  14,    -1654 }, /* VERR_PGM_INVALID_SAVED_PAGE_STATE */
    { 0x018502,  14, 0x00cc6a,  29,    -1653 }, /* VERR_PGM_MAPPINGS_SMP */
    { 0x014466,  19, 0x00d513,  28,    -1652 }, /* VERR_PGM_MAPPINGS_DISABLED */
    { 0x014ca2,  19, 0x00451f,  51,    -1651 }, /* VERR_PGM_MAP_MMIO2_ALIAS_MMIO */
    { 0x01a01d,  12, 0x0103d6,  24,    -1647 }, /* VERR_PGM_HANDLER_IPE_1 */
    { 0x016541,  17, 0x009e46,  35,    -1646 }, /* VERR_PGM_PHYS_PAGE_BALLOONED */
    { 0x01816c,  15, 0x00e431,  27,    -1645 }, /* VERR_PGM_INVALID_LARGE_PAGE_RANGE */
    { 0x0155ad,  18, 0x00a5e0,  34,    -1643 }, /* VERR_PGM_HANDLER_ALREADY_ALIASED */
    { 0x0191df,  13, 0x017f7d,  15,    -1642 }, /* VERR_PGM_PHYS_NOT_MMIO2 */
    { 0x01adf7,   9, 0x01a179,  11,    -1641 }, /* VERR_PGM_PHYS_NOT_MMIO */
    { 0x01a61d,  11, 0x019490,  13,    -1640 }, /* VERR_PGM_PHYS_NOT_ROM */
    { 0x01a14d,  11, 0x00ea34,  27,    -1639 }, /* VERR_PGM_PHYS_NOT_RAM */
    { 0x012e12,  21, 0x002f2c,  58,    -1638 }, /* VERR_PGM_PHYS_WR_HIT_HANDLER */
    { 0x01a21e,  11, 0x00df72,  27,    -1637 }, /* VERR_PGM_PHYS_INVALID_PAGE_ID */
    { 0x015219,  18, 0x0106a5,  24,    -1636 }, /* VERR_PGM_NO_CR3_SHADOW_ROOT */
    { 0x012028,  22, 0x0088b5,  38,    -1635 }, /* VERR_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x013b62,  20, 0x00973f,  36,    -1634 }, /* VERR_PGM_PHYS_TLB_CATCH_ALL */
    { 0x013184,  21, 0x005f3a,  45,    -1633 }, /* VERR_PGM_PHYS_TLB_UNASSIGNED */
    { 0x016013,  17, 0x009403,  36,    -1632 }, /* VERR_PGM_DYNMAP_EXPAND_ERROR */
    { 0x0173af,  16, 0x0073a4,  41,    -1631 }, /* VERR_PGM_DYNMAP_SETUP_ERROR */
    { 0x016002,  17, 0x005a0f,  46,    -1630 }, /* VERR_PGM_DYNMAP_FULL_SET */
    { 0x01aa6e,  10, 0x00995a,  35,    -1629 }, /* VERR_PGM_DYNMAP_FAILED */
    { 0x01355e,  21, 0x009493,  36,    -1628 }, /* VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE */
    { 0x00c48d,  30, 0x001b86,  65,    -1627 }, /* VERR_PGM_INTERMEDIATE_PAGING_CONFLICT */
    { 0x00b9c8,  31, 0x000d40,  77,    -1626 }, /* VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY */
    { 0x01282b,  21, 0x00f2e5,  26,    -1619 }, /* VERR_PGM_NO_HYPERVISOR_ADDRESS */
    { 0x016c30,  16, 0x004b6c,  50,    -1618 }, /* VERR_PGM_PHYS_PAGE_RESERVED */
    { 0x01449f,  19, 0x009373,  36,    -1617 }, /* VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE */
    { 0x012744,  21, 0x007da2,  40,    -1612 }, /* VERR_PGM_MAPPINGS_FIX_TOO_SMALL */
    { 0x01197f,  23, 0x006447,  44,    -1611 }, /* VERR_PGM_MAPPINGS_FIX_REJECTED */
    { 0x011391,  23, 0x006523,  44,    -1610 }, /* VERR_PGM_MAPPINGS_FIX_CONFLICT */
    { 0x01774e,  16, 0x002752,  60,    -1609 }, /* VERR_PGM_MAPPINGS_FIXED */
    { 0x018628,  14, 0x001f0e,  64,    -1608 }, /* VERR_PGM_RAM_CONFLICT */
    { 0x019891,  12, 0x00d903,  28,    -1607 }, /* VERR_PGM_HANDLER_NOT_FOUND */
    { 0x014061,  20, 0x0145e2,  19,    -1606 }, /* VERR_PGM_INVALID_GC_PHYSICAL_RANGE */
    { 0x005f4f,  22, 0x013217,  21,    -1605 }, /* VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS */
    { 0x0195e2,  13, 0x01afdd,   9,    -1604 }, /* VERR_PGM_INVALID_PAGE_DIRECTORY */
    { 0x00e281,  27, 0x002284,  63,    -1603 }, /* VERR_PGM_HANDLER_PHYSICAL_CONFLICT */
    { 0x00ebe3,  26, 0x0024f1,  62,    -1602 }, /* VERR_PGM_HANDLER_VIRTUAL_CONFLICT */
    { 0x00d00a,  29, 0x00424a,  52,    -1601 }, /* VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE */
    { 0x015b29,  18, 0x002d1e,  59,    -1600 }, /* VERR_PGM_MAPPING_CONFLICT */
    { 0x019fbd,  12, 0x007820,  41,    -1504 }, /* VERR_CSAM_HM_IPE */
    { 0x00fbd5,  25, 0x018ace,  14,    -1432 }, /* VERR_PATM_IPE_TRAP_IN_PATCH_CODE */
    { 0x019b25,  12, 0x0047b6,  50,    -1431 }, /* VERR_PATM_HM_IPE */
    { 0x018812,  14, 0x01736f,  16,    -1428 }, /* VERR_PATM_ALREADY_PATCHED */
    { 0x016079,  17, 0x00badf,  31,    -1426 }, /* VERR_PATM_UNSAFE_CODE */
    { 0x016e80,  16, 0x013996,  20,    -1425 }, /* VERR_PATCH_NO_CONFLICT */
    { 0x017d43,  15, 0x0171e0,  16,    -1406 }, /* VERR_PATCH_ALREADY_ENABLED */
    { 0x016ec0,  16, 0x015fbe,  17,    -1405 }, /* VERR_PATCH_ALREADY_DISABLED */
    { 0x017aaf,  15, 0x0178ed,  15,    -1403 }, /* VERR_PATCH_DISABLED */
    { 0x01af71,   9, 0x018f21,  13,    -1402 }, /* VERR_PATCH_NOT_FOUND */
    { 0x0168b5,  17, 0x0013d3,  71,    -1401 }, /* VERR_PATCHING_REFUSED */
    { 0x019f5d,  12, 0x01967e,  13,    -1241 }, /* VERR_DBGF_CANCELLED */
    { 0x00a87c,  33, 0x0095d7,  36,    -1240 }, /* VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS */
    { 0x00fc52,  25, 0x00b63b,  32,    -1238 }, /* VERR_DBGF_BP_OWNER_NO_MORE_HANDLES */
    { 0x016552,  17, 0x007eba,  40,    -1237 }, /* VERR_DBGF_BP_L2_LOOKUP_FAILED */
    { 0x016156,  17, 0x007a0a,  40,    -1236 }, /* VERR_DBGF_BP_L1_LOOKUP_FAILED */
    { 0x01b179,   8, 0x013d6a,  20,    -1235 }, /* VERR_DBGF_BP_IPE_9 */
    { 0x01b181,   8, 0x013bc6,  20,    -1234 }, /* VERR_DBGF_BP_IPE_8 */
    { 0x01b189,   8, 0x01427d,  20,    -1233 }, /* VERR_DBGF_BP_IPE_7 */
    { 0x01b191,   8, 0x0138ba,  20,    -1232 }, /* VERR_DBGF_BP_IPE_6 */
    { 0x01b199,   8, 0x013d06,  20,    -1231 }, /* VERR_DBGF_BP_IPE_5 */
    { 0x01b1a1,   8, 0x013f85,  20,    -1230 }, /* VERR_DBGF_BP_IPE_4 */
    { 0x01b1c1,   8, 0x0135ff,  20,    -1229 }, /* VERR_DBGF_BP_IPE_3 */
    { 0x01b469,   8, 0x013a86,  20,    -1228 }, /* VERR_DBGF_BP_IPE_2 */
    { 0x01b461,   8, 0x014205,  20,    -1227 }, /* VERR_DBGF_BP_IPE_1 */
    { 0x00db33,  28, 0x0045b8,  51,    -1226 }, /* VERR_DBGF_BP_INT3_ADD_TRIES_REACHED */
    { 0x019560,  13, 0x0049aa,  50,    -1225 }, /* VERR_DBGF_OWNER_BUSY */
    { 0x01bb48,   5, 0x017200,  16,    -1223 }, /* VERR_DBGF_IPE_1 */
    { 0x01a40d,  11, 0x007b9a,  40,    -1222 }, /* VWRN_DBGF_ALREADY_RUNNING */
    { 0x019c21,  12, 0x00fd01,  25,    -1221 }, /* VERR_DBGF_TRACER_IPE_1 */
    { 0x0175ef,  16, 0x004f49,  49,    -1220 }, /* VERR_DBGF_NO_TRACE_BUFFER */
    { 0x01a5ba,  11, 0x0165b8,  17,    -1219 }, /* VERR_DBGF_STACK_IPE_2 */
    { 0x01a5a4,  11, 0x01673f,  17,    -1218 }, /* VERR_DBGF_STACK_IPE_1 */
    { 0x016dc0,  16, 0x00e6b9,  27,    -1217 }, /* VERR_DBGF_HYPER_DB_XCPT */
    { 0x01adee,   9, 0x0199c9,  12,    -1216 }, /* VERR_DBGF_REG_IPE_2 */
    { 0x01ae00,   9, 0x019df5,  12,    -1215 }, /* VERR_DBGF_REG_IPE_1 */
    { 0x012cad,  21, 0x00fdb0,  25,    -1214 }, /* VERR_DBGF_READ_ONLY_REGISTER */
    { 0x01b379,   8, 0x0163a9,  17,    -1213 }, /* VERR_DBGF_UNSUPPORTED_CAST */
    { 0x018c48,  14, 0x01b8fc,   6,    -1210 }, /* VERR_DBGF_REGISTER_NOT_FOUND */
    { 0x018866,  14, 0x0178fc,  15,    -1209 }, /* VERR_DBGF_OS_NOT_DETCTED */
    { 0x01afc2,   9, 0x01aa82,  10,    -1208 }, /* VERR_DBGF_MEM_NOT_FOUND */
    { 0x01b569,   8, 0x00c811,  30,    -1204 }, /* VERR_DBGF_BP_NOT_FOUND */
    { 0x016871,  17, 0x010466,  24,    -1203 }, /* VERR_DBGF_NO_MORE_BP_SLOTS */
    { 0x019fb1,  12, 0x003615,  56,    -1201 }, /* VERR_DBGF_ALREADY_ATTACHED */
    { 0x019a35,  12, 0x001fce,  64,    -1200 }, /* VERR_DBGF_NOT_ATTACHED */
    { 0x015de7,  18, 0x00acfb,  32,    -1158 }, /* VERR_EM_GUEST_CPU_HANG */
    { 0x01340e,  21, 0x004914,  50,    -1156 }, /* VERR_EM_CANNOT_EXEC_GUEST */
    { 0x0127d7,  21, 0x00d44f,  28,    -1154 }, /* VERR_EM_UNEXPECTED_MAPPING_CONFLICT */
    { 0x01b992,   6, 0x003fa0,  53,    -1149 }, /* VERR_EM_INTERNAL_ERROR */
    { 0x0179fb,  15, 0x008713,  38,    -1148 }, /* VERR_EM_INTERPRETER */
    { 0x0125be,  22, 0x007ee2,  40,    -1133 }, /* VERR_EM_RAW_PATCH_CONFLICT */
    { 0x01b99e,   6, 0x00d59f,  28,    -1114 }, /* VERR_EM_NO_MEMORY */
    { 0x0128be,  21, 0x0057ad,  47,    -1028 }, /* VERR_DRIVER_REBOOT_NEEDED */
    { 0x012951,  21, 0x01377a,  20,    -1027 }, /* VERR_RESERVED_PAGE_TABLE_BITS */
    { 0x01b74e,   7, 0x00dfa8,  27,    -1026 }, /* VERR_NOT_SUP_BY_NEM */
    { 0x01a491,  11, 0x018c56,  14,    -1025 }, /* VERR_VM_RESTORED */
    { 0x011c34,  22, 0x0052b1,  48,    -1024 }, /* VERR_INCONSISTENT_VM_HANDLE */
    { 0x019cd5,  12, 0x00a24a,  34,    -1023 }, /* VERR_RAW_MODE_NOT_SUPPORTED */
    { 0x01a6ac,  11, 0x01a423,  11,    -1022 }, /* VERR_INVALID_CPU_INDEX */
    { 0x018e08,  14, 0x00b61b,  32,    -1021 }, /* VERR_NOT_SUP_IN_RAW_MODE */
    { 0x0163fe,  17, 0x00d4a3,  28,    -1020 }, /* VERR_SERVICE_DISABLED */
    { 0x01b75c,   7, 0x01a5e6,  11,    -1019 }, /* VERR_TOO_MANY_CPUS */
    { 0x01b429,   8, 0x01775e,  16,    -1018 }, /* VERR_INVALID_CPU_ID */
    { 0x018492,  14, 0x01a9a6,  10,    -1017 }, /* VERR_INVALID_VMCPU_HANDLE */
    { 0x01ac9e,  10, 0x01a9a6,  10,    -1016 }, /* VERR_INVALID_VM_HANDLE */
    { 0x0189e0,  14, 0x017a37,  15,    -1015 }, /* VERR_RAW_MODE_INVALID_SMP */
    { 0x0107c5,  24, 0x0113ed,  23,    -1014 }, /* VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT */
    { 0x01351f,  21, 0x017cbc,  15,    -1013 }, /* VERR_PAGE_MAP_LEVEL4_NOT_PRESENT */
    { 0x01bb66,   5, 0x015cfd,  18,    -1012 }, /* VERR_INVALID_RPL */
    { 0x01abea,  10, 0x01a956,  10,    -1011 }, /* VERR_INVALID_SELECTOR */
    { 0x0113d6,  23, 0x01316f,  21,    -1010 }, /* VERR_OUT_OF_SELECTOR_BOUNDS */
    { 0x017b45,  15, 0x018af8,  14,    -1009 }, /* VERR_NOT_DATA_SELECTOR */
    { 0x017ef6,  15, 0x0153b6,  18,    -1008 }, /* VERR_NOT_CODE_SELECTOR */
    { 0x0159af,  18, 0x015e88,  18,    -1007 }, /* VERR_SELECTOR_NOT_PRESENT */
    { 0x01a389,  11, 0x010f9d,  23,    -1006 }, /* VERR_CFG_NO_VALUE */
    { 0x019d1d,  12, 0x009050,  37,    -1005 }, /* VERR_CFG_INVALID_FORMAT */
    { 0x01aaa0,  10, 0x01868a,  14,    -1004 }, /* VERR_PAGE_NOT_PRESENT */
    { 0x01a9ce,  10, 0x01abe0,  10,    -1003 }, /* VERR_UNSUPPORTED_CPU_MODE */
    { 0x01a9ce,   5, 0x01bad5,   5,    -1002 }, /* VERR_UNSUPPORTED_CPU */
    { 0x01a3ec,  11, 0x000cf2,  78,    -1001 }, /* VERR_DONT_PANIC */
    { 0x01bb2a,   5, 0x0141a1,  20,    -1000 }, /* VERR_NO_VM_MEMORY */
    { 0x0117f8,  23, 0x00431a,  52,     -965 }, /* VERR_PKZIP_ZIP64EX_IN_ZIP32 */
    { 0x018414,  14, 0x016ad1,  16,     -964 }, /* VERR_PKZIP_UNKNOWN_TYPE_FLAG */
    { 0x015793,  18, 0x01488d,  19,     -963 }, /* VERR_PKZIP_BAD_CDF_HEADER */
    { 0x016376,  17, 0x0175bf,  16,     -962 }, /* VERR_PKZIP_BAD_LF_HEADER */
    { 0x0169e7,  17, 0x013367,  21,     -961 }, /* VERR_PKZIP_NAME_TOO_LONG */
    { 0x019ba9,  12, 0x01176e,  23,     -960 }, /* VERR_PKZIP_NO_EOCB */
    { 0x016651,  17, 0x0170b0,  16,     -953 }, /* VERR_POLL_SET_IS_FULL */
    { 0x015bb9,  18, 0x01017f,  25,     -952 }, /* VERR_POLL_HANDLE_ID_NOT_FOUND */
    { 0x011bdc,  22, 0x00aefb,  32,     -951 }, /* VERR_POLL_HANDLE_ID_EXISTS */
    { 0x0120c2,  22, 0x01514f,  19,     -950 }, /* VERR_POLL_HANDLE_NOT_POLLABLE */
    { 0x017d70,  15, 0x00e683,  27,     -947 }, /* VERR_TAR_NAME_TOO_LONG */
    { 0x00e482,  27, 0x0085bd,  38,     -946 }, /* VERR_TAR_MALFORMED_GNU_LONGXXXX */
    { 0x015823,  18, 0x0085bd,  38,     -945 }, /* VERR_TAR_BAD_CHKSUM_FIELD */
    { 0x01833d,  15, 0x00af7b,  32,     -944 }, /* VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE */
    { 0x014d27,  19, 0x00934f,  36,     -943 }, /* VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE */
    { 0x01a520,  11, 0x003ecc,  53,     -942 }, /* VERR_TAR_UNSUPPORTED_PAX_TYPE */
    { 0x00d877,  28, 0x00b43b,  32,     -941 }, /* VERR_TAR_NON_DIR_ENDS_WITH_SLASH */
    { 0x017aeb,  15, 0x0194b7,  13,     -940 }, /* VERR_TAR_EMPTY_NAME */
    { 0x017a82,  15, 0x00ba06,  31,     -939 }, /* VERR_TAR_NOT_USTAR_V00 */
    { 0x0176ff,  16, 0x016783,  17,     -938 }, /* VERR_TAR_ZERO_HEADER */
    { 0x019e0d,  12, 0x016ad1,  16,     -937 }, /* VERR_TAR_UNKNOWN_TYPE_FLAG */
    { 0x019c99,  12, 0x00722d,  42,     -936 }, /* VERR_TAR_SIZE_NOT_ZERO */
    { 0x016f80,  16, 0x00a4f2,  34,     -935 }, /* VERR_TAR_MODE_WITH_TYPE */
    { 0x0174ff,  16, 0x00f932,  25,     -934 }, /* VERR_TAR_BAD_MODE_FIELD */
    { 0x0134f5,  21, 0x002475,  62,     -933 }, /* VERR_TAR_DEV_VALUE_TOO_LARGE */
    { 0x012b48,  21, 0x0022c3,  62,     -932 }, /* VERR_TAR_NUM_VALUE_TOO_LARGE */
    { 0x017030,  16, 0x000abf,  83,     -931 }, /* VERR_TAR_BASE_256_NOT_SUPPORTED */
    { 0x013ca2,  20, 0x0064cb,  44,     -930 }, /* VERR_TAR_BAD_NUM_FIELD_TERM */
    { 0x013ca2,  15, 0x00f9e1,  25,     -929 }, /* VERR_TAR_BAD_NUM_FIELD */
    { 0x0147e2,  19, 0x001d8e,  64,     -928 }, /* VERR_TAR_EOS_MORE_INPUT */
    { 0x01aefc,   9, 0x00fe78,  25,     -927 }, /* VERR_TAR_UNEXPECTED_EOS */
    { 0x016ed0,  16, 0x010795,  24,     -926 }, /* VERR_TAR_END_OF_FILE */
    { 0x019032,  13, 0x00afdb,  32,     -925 }, /* VERR_TAR_CHKSUM_MISMATCH */
    { 0x014fe6,  19, 0x011f78,  22,     -906 }, /* VERR_MANIFEST_ATTR_TYPE_NOT_FOUND */
    { 0x015931,  18, 0x011221,  23,     -905 }, /* VERR_MANIFEST_ATTR_TYPE_MISMATCH */
    { 0x015f8b,  17, 0x008ac9,  38,     -904 }, /* VERR_MANIFEST_ATTR_NOT_FOUND */
    { 0x019a29,  12, 0x00abf7,  33,     -903 }, /* VERR_MANIFEST_FILE_MISMATCH */
    { 0x019d11,  12, 0x00c361,  30,     -902 }, /* VERR_MANIFEST_DIGEST_MISMATCH */
    { 0x010f13,  23, 0x0053d1,  48,     -901 }, /* VERR_MANIFEST_WRONG_FILE_FORMAT */
    { 0x0193a6,  13, 0x00d4f7,  28,     -900 }, /* VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE */
    { 0x0199f9,  12, 0x01b64b,   7,     -899 }, /* VERR_HTTP_CURL_ERROR */
    { 0x01b401,   8, 0x012432,  22,     -898 }, /* VERR_HTTP_NOT_SUPPORTED */
    { 0x010f58,  23, 0x010ac5,  24,     -897 }, /* VERR_HTTP_CURL_PROXY_CONFIG */
    { 0x0190e8,  13, 0x00af3b,  32,     -896 }, /* VERR_HTTP_HOST_NOT_FOUND */
    { 0x01861a,  14, 0x00fb26,  25,     -895 }, /* VERR_HTTP_PROXY_NOT_FOUND */
    { 0x01769f,  16, 0x013d1a,  20,     -894 }, /* VERR_HTTP_REDIRECTED */
    { 0x01911c,  13, 0x009a72,  35,     -893 }, /* VERR_HTTP_ABORTED */
    { 0x00b03b,  32, 0x0073f6,  41,     -892 }, /* VERR_HTTP_CACERT_CANNOT_AUTHENTICATE */
    { 0x00ffef,  25, 0x00b59b,  32,     -891 }, /* VERR_HTTP_CACERT_WRONG_FORMAT */
    { 0x014e0b,  19, 0x016ca0,  16,     -890 }, /* VERR_HTTP_SSL_CONNECT_ERROR */
    { 0x012ee4,  21, 0x00a8be,  33,     -889 }, /* VERR_HTTP_COULDNT_CONNECT */
    { 0x018778,  14, 0x007185,  42,     -888 }, /* VERR_HTTP_BAD_REQUEST */
    { 0x015129,  19, 0x010e54,  24,     -887 }, /* VERR_HTTP_ACCESS_DENIED */
    { 0x01b3f9,   8, 0x006048,  45,     -886 }, /* VERR_HTTP_NOT_FOUND */
    { 0x019ec1,  12, 0x013352,  21,     -885 }, /* VERR_HTTP_INIT_FAILED */
    { 0x013328,  21, 0x01500c,  19,     -884 }, /* VERR_HTTP_STATUS_SERVER_ERROR */
    { 0x019a05,  12, 0x013ebe,  20,     -879 }, /* VERR_S3_CANCELED */
    { 0x015ff1,  17, 0x00ed4f,  26,     -878 }, /* VERR_S3_BUCKET_NOT_EMPTY */
    { 0x015d0f,  18, 0x017cf8,  15,     -877 }, /* VERR_S3_BUCKET_ALREADY_EXISTS */
    { 0x01b9c2,   6, 0x01363b,  20,     -876 }, /* VERR_S3_NOT_FOUND */
    { 0x0164db,  17, 0x018289,  15,     -875 }, /* VERR_S3_ACCESS_DENIED */
    { 0x01778e,  16, 0x0105fd,  24,     -855 }, /* VERR_MEM_CACHE_MAX_SIZE */
    { 0x0197f5,  12, 0x01257c,  22,     -851 }, /* VERR_CACHE_EMPTY */
    { 0x01a45a,  11, 0x012a77,  21,     -850 }, /* VERR_CACHE_FULL */
    { 0x01818a,  15, 0x006a0f,  43,     -829 }, /* VERR_GETOPT_INDEX_MISSING */
    { 0x0103ee,  24, 0x00441e,  52,     -827 }, /* VERR_GETOPT_INVALID_ARGUMENT_FORMAT */
    { 0x00e776,  27, 0x006183,  45,     -826 }, /* VERR_GETOPT_REQUIRED_ARGUMENT_MISSING */
    { 0x017dac,  15, 0x006d95,  42,     -825 }, /* VERR_GETOPT_UNKNOWN_OPTION */
    { 0x01b63d,   7, 0x01a31b,  11,     -803 }, /* VERR_CPU_IPE_1 */
    { 0x015fad,  17, 0x0071af,  42,     -802 }, /* VERR_NOT_ALL_CPUS_SHOWED */
    { 0x01b6fa,   7, 0x01add3,   9,     -801 }, /* VERR_CPU_NOT_FOUND */
    { 0x019e3d,  12, 0x017b54,  15,     -800 }, /* VERR_CPU_OFFLINE */
    { 0x0186ec,  14, 0x005251,  48,     -753 }, /* VERR_ENV_VAR_UNSET */
    { 0x018cf0,  14, 0x00e5ab,  27,     -752 }, /* VERR_ENV_INVALID_VAR_NAME */
    { 0x01a654,  11, 0x00f193,  26,     -750 }, /* VERR_ENV_VAR_NOT_FOUND */
    { 0x010cd5,  24, 0x00a15d,  34,     -704 }, /* VERR_RT_REQUEST_STATUS_FREED */
    { 0x00b45b,  32, 0x002932,  60,     -703 }, /* VERR_RT_REQUEST_STATUS_STILL_PENDING */
    { 0x014345,  20, 0x01a095,  12,     -702 }, /* VERR_RT_REQUEST_INVALID_PACKAGE */
    { 0x01951f,  13, 0x01a24a,  11,     -701 }, /* VERR_RT_REQUEST_STATE */
    { 0x01852c,  14, 0x01ace4,  10,     -700 }, /* VERR_RT_REQUEST_INVALID_TYPE */
    { 0x00f2b1,  26, 0x00d1bd,  29,     -696 }, /* VERR_DBG_MALFORMED_UNWIND_INFO */
    { 0x014711,  19, 0x00adbb,  32,     -695 }, /* VERR_DBG_UNWIND_INFO_NOT_FOUND */
    { 0x01640f,  17, 0x0123ae,  22,     -694 }, /* VERR_DBG_NO_UNWIND_INFO */
    { 0x01b843,   7, 0x0087ab,  38,     -693 }, /* VERR_CV_IPE */
    { 0x01b521,   8, 0x005ac7,  46,     -692 }, /* VERR_CV_TODO */
    { 0x01a184,  11, 0x0098cb,  36,     -691 }, /* VERR_CV_BAD_FORMAT */
    { 0x019a89,  12, 0x00f6a7,  26,     -689 }, /* VERR_DBG_MOD_IPE */
    { 0x01b652,   7, 0x004d5f,  49,     -688 }, /* VERR_DBG_FILE_MISMATCH */
    { 0x01ad82,   9, 0x00c73f,  30,     -687 }, /* VERR_DBG_TODO */
    { 0x014151,  20, 0x00ba25,  31,     -686 }, /* VERR_DBG_DEFERRED_LOAD_FAILED */
    { 0x014ada,  19, 0x011fe6,  22,     -685 }, /* VERR_DBG_CFG_NOT_UINT_PROP */
    { 0x018202,  15, 0x00fb3f,  25,     -684 }, /* VERR_DBG_CFG_INVALID_VALUE */
    { 0x01aa14,  10, 0x019861,  12,     -683 }, /* VERR_DWARF_IPE */
    { 0x011ede,  22, 0x00e9c8,  27,     -682 }, /* VERR_DWARF_STACK_UNDERFLOW */
    { 0x0128d3,  21, 0x00ebfd,  26,     -681 }, /* VERR_DWARF_STACK_OVERFLOW */
    { 0x0151d1,  18, 0x0168f9,  17,     -680 }, /* VERR_DWARF_UNKNOWN_LOC_OPCODE */
    { 0x01a5fc,  11, 0x019ce1,  12,     -679 }, /* VERR_DWARF_TODO */
    { 0x019fa5,  12, 0x00d727,  28,     -678 }, /* VERR_DWARF_UNEXPECTED_FORM */
    { 0x019ac5,  12, 0x00f851,  25,     -677 }, /* VERR_DWARF_UNKNOWN_FORM */
    { 0x01752f,  16, 0x0103be,  24,     -676 }, /* VERR_DWARF_ABBREV_NOT_FOUND */
    { 0x018564,  14, 0x00fb58,  25,     -675 }, /* VERR_DWARF_BAD_ABBREV */
    { 0x019831,  12, 0x019939,  12,     -674 }, /* VERR_DWARF_BAD_INFO */
    { 0x01a66a,  11, 0x016e60,  16,     -673 }, /* VERR_DWARF_BAD_POS */
    { 0x01af7a,   9, 0x0188f2,  14,     -672 }, /* VERR_DWARF_BAD_STRING */
    { 0x01a68b,  11, 0x00d10f,  29,     -671 }, /* VERR_DWARF_BAD_LNE */
    { 0x014edc,  19, 0x009a4f,  35,     -670 }, /* VERR_DWARF_LEB_OVERFLOW */
    { 0x01a2e4,  11, 0x016695,  17,     -669 }, /* VERR_DWARF_UNEXPECTED_END */
    { 0x00f15f,  26, 0x014039,  20,     -668 }, /* VERR_DWARF_BAD_LINE_NUMBER_HEADER */
    { 0x00f1e1,  26, 0x00577e,  47,     -667 }, /* VERR_DBG_NO_MATCHING_INTERPRETER */
    { 0x013fc1,  20, 0x00b1bb,  32,     -666 }, /* VERR_DBG_NOT_LINUX_KALLSYMS */
    { 0x016640,  17, 0x01083d,  24,     -665 }, /* VERR_DBG_NOT_NM_MAP_FILE */
    { 0x01681c,  17, 0x00cd18,  29,     -664 }, /* VERR_DBG_ADDRESS_WRAP */
    { 0x00c505,  30, 0x009a09,  35,     -663 }, /* VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE */
    { 0x0118b0,  23, 0x00dbdb,  28,     -662 }, /* VERR_DBG_FILE_NAME_OUT_OF_RANGE */
    { 0x00ccde,  29, 0x00a6ac,  34,     -661 }, /* VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE */
    { 0x019921,  12, 0x0072ff,  42,     -660 }, /* VERR_DBG_LINE_NOT_FOUND */
    { 0x00e69e,  27, 0x004f7a,  49,     -659 }, /* VERR_DBG_SEGMENT_INDEX_CONFLICT */
    { 0x012d6a,  21, 0x00ae9b,  32,     -658 }, /* VERR_DBG_DUPLICATE_SYMBOL */
    { 0x01297b,  21, 0x00765d,  41,     -657 }, /* VERR_DBG_ADDRESS_CONFLICT */
    { 0x013ee6,  20, 0x00e5c6,  27,     -656 }, /* VERR_DBG_SPECIAL_SEGMENT */
    { 0x01b051,   9, 0x00e5c6,  27,     -655 }, /* VERR_DBG_INVALID_RVA */
    { 0x013ac2,  20, 0x017280,  16,     -654 }, /* VERR_DBG_INVALID_SEGMENT_OFFSET */
    { 0x01448c,  19, 0x0179ec,  15,     -653 }, /* VERR_DBG_INVALID_SEGMENT_INDEX */
    { 0x0192f0,  13, 0x00a35a,  34,     -652 }, /* VERR_DBG_INVALID_ADDRESS */
    { 0x019664,  13, 0x00befd,  31,     -651 }, /* VERR_DBG_NO_SYMBOLS */
    { 0x0159d3,  18, 0x00c109,  30,     -650 }, /* VERR_DBG_NO_LINE_NUMBERS */
    { 0x016f70,  16, 0x010a95,  24,     -649 }, /* VERR_LDR_INVALID_SEG_OFFSET */
    { 0x01b009,   9, 0x00e5c6,  27,     -648 }, /* VERR_LDR_INVALID_RVA */
    { 0x0154b2,  18, 0x018962,  14,     -647 }, /* VERR_LDR_INVALID_LINK_ADDRESS */
    { 0x00f12b,  26, 0x00d567,  28,     -641 }, /* VERR_LDRELF_UNTERMINATED_STRING_TAB */
    { 0x00ee39,  26, 0x007281,  42,     -640 }, /* VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS */
    { 0x00f5d7,  26, 0x00e818,  27,     -639 }, /* VERR_LDRELF_INVALID_RELOCATION_OFFSET */
    { 0x00e7c7,  27, 0x00d98f,  28,     -638 }, /* VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET */
    { 0x013106,  21, 0x00ed1b,  26,     -637 }, /* VERR_LDRELF_INVALID_SYMBOL_INDEX */
    { 0x012f23,  21, 0x009913,  36,     -636 }, /* VERR_LDRELF_RELOCATION_NOT_SUPPORTED */
    { 0x010df4,  24, 0x0081ca,  39,     -635 }, /* VERR_LDRELF_MULTIPLE_SYMTABS */
    { 0x01b075,   9, 0x01ae63,   9,     -634 }, /* VERR_LDRELF_VERSION */
    { 0x017965,  15, 0x004d2e,  49,     -633 }, /* VERR_LDRELF_MACHINE */
    { 0x019ae9,  12, 0x000ebd,  74,     -632 }, /* VERR_LDRELF_EXEC */
    { 0x01a331,  11, 0x0012fe,  71,     -631 }, /* VERR_LDRELF_DYN */
    { 0x015b95,  18, 0x00a9a5,  33,     -630 }, /* VERR_LDRELF_ODD_ENDIAN */
    { 0x0127ec,  21, 0x007c3a,  40,     -628 }, /* VERR_LDRPE_GUARD_CF_STUFF */
    { 0x010c5d,  24, 0x0023bb,  62,     -627 }, /* VERR_LDRPE_LOCK_PREFIX_TABLE */
    { 0x013753,  20, 0x00500d,  49,     -626 }, /* VERR_LDRPE_LOAD_CONFIG_SIZE */
    { 0x0128e8,  21, 0x0101b1,  25,     -625 }, /* VERR_LDRPE_COM_DESCRIPTOR */
    { 0x01ab90,  10, 0x015ae1,  18,     -624 }, /* VERR_LDRPE_TLS */
    { 0x016b31,  16, 0x005e59,  45,     -623 }, /* VERR_LDRPE_GLOBALPTR */
    { 0x011238,  23, 0x009e8c,  35,     -622 }, /* VERR_LDRPE_CERT_UNSUPPORTED */
    { 0x012b72,  21, 0x00c19f,  30,     -621 }, /* VERR_LDRPE_CERT_MALFORMED */
    { 0x014ab4,  19, 0x002eb8,  58,     -620 }, /* VERR_LDRPE_DELAY_IMPORT */
    { 0x01822f,  15, 0x018adc,  14,     -619 }, /* VERR_LDR_IMAGE_HASH */
    { 0x01409d,  20, 0x01aa64,  10,     -618 }, /* VERR_LDR_GENERAL_FAILURE */
    { 0x011951,  23, 0x008b15,  38,     -617 }, /* VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND */
    { 0x018f89,  13, 0x0090e4,  37,     -616 }, /* VERR_LDR_MISMATCH_NATIVE */
    { 0x01a5c5,  11, 0x00f7d4,  25,     -615 }, /* VERR_LDR_ARCH_MISMATCH */
    { 0x016024,  17, 0x00a3c0,  34,     -614 }, /* VERR_IMAGE_BASE_TOO_HIGH */
    { 0x01a515,  11, 0x01b3c9,   8,     -612 }, /* VERR_IMAGE_TOO_BIG */
    { 0x015303,  18, 0x00400a,  53,     -611 }, /* VERR_SYMBOL_VALUE_TOO_BIG */
    { 0x01a96a,  10, 0x01afa7,   9,     -610 }, /* VERR_MODULE_NOT_FOUND */
    { 0x01ab68,  10, 0x01574b,  18,     -609 }, /* VERR_SYMBOL_NOT_FOUND */
    { 0x019a71,  12, 0x019e91,  12,     -608 }, /* VERR_BAD_EXE_FORMAT */
    { 0x01998d,  12, 0x0127ad,  21,     -607 }, /* VERR_AOUT_EXE_NOT_SUPPORTED */
    { 0x01ac62,  10, 0x0058c7,  47,     -606 }, /* VERR_MZ_EXE_NOT_SUPPORTED */
    { 0x01ad0c,  10, 0x005720,  47,     -605 }, /* VERR_NE_EXE_NOT_SUPPORTED */
    { 0x01ab4a,  10, 0x005954,  47,     -604 }, /* VERR_LE_EXE_NOT_SUPPORTED */
    { 0x01aaf0,  10, 0x0055a8,  47,     -603 }, /* VERR_LX_EXE_NOT_SUPPORTED */
    { 0x01a91a,  10, 0x00545f,  47,     -602 }, /* VERR_PE_EXE_NOT_SUPPORTED */
    { 0x01a439,  11, 0x005161,  48,     -601 }, /* VERR_ELF_EXE_NOT_SUPPORTED */
    { 0x0182f2,  15, 0x0120ee,  22,     -600 }, /* VERR_INVALID_EXE_SIGNATURE */
    { 0x0165fc,  17, 0x00e833,  27,     -566 }, /* VERR_L4_DS_MANAGER_NOT_FOUND */
    { 0x00fdc9,  25, 0x00d231,  29,     -563 }, /* VERR_IPC_SEND_SEND_PF_TIMEOUT */
    { 0x00da1b,  28, 0x00afbb,  32,     -562 }, /* VERR_IPC_RECEIVE_SEND_PF_TIMEOUT */
    { 0x017893,  15, 0x00c033,  31,     -561 }, /* VERR_IPC_SEND_MAP_FAILED */
    { 0x015727,  18, 0x00a536,  34,     -560 }, /* VERR_IPC_RECEIVE_MAP_FAILED */
    { 0x0169d6,  17, 0x0196f3,  13,     -559 }, /* VERR_IPC_SEND_ABORTED */
    { 0x014241,  20, 0x01770e,  16,     -558 }, /* VERR_IPC_RECEIVE_ABORTED */
    { 0x014925,  19, 0x017adc,  15,     -557 }, /* VERR_IPC_SEND_CANCELLED */
    { 0x01236c,  22, 0x0159f7,  18,     -556 }, /* VERR_IPC_RECEIVE_CANCELLED */
    { 0x016420,  17, 0x0196a5,  13,     -555 }, /* VERR_IPC_SEND_TIMEOUT */
    { 0x01390a,  20, 0x0174df,  16,     -554 }, /* VERR_IPC_RECEIVE_TIMEOUT */
    { 0x017a91,  15, 0x012816,  21,     -553 }, /* VERR_IPC_PROCESS_NOT_FOUND */
    { 0x01732f,  16, 0x01a470,  11,     -552 }, /* VERR_RESOURCE_IN_USE */
    { 0x00da1b,   4, 0x01bb02,   5,     -551 }, /* VERR_IPC */
    { 0x0187b0,  14, 0x0114ea,  23,     -550 }, /* VERR_L4_INVALID_DS_OFFSET */
    { 0x012a38,  21, 0x010f2a,  23,     -522 }, /* VERR_UDP_SERVER_DESTROYED */
    { 0x013cb6,  20, 0x004df2,  49,     -521 }, /* VERR_UDP_SERVER_SHUTDOWN */
    { 0x016c00,  16, 0x016a3c,  17,     -520 }, /* VERR_UDP_SERVER_STOP */
    { 0x0128fd,  21, 0x0119c4,  23,     -502 }, /* VERR_TCP_SERVER_DESTROYED */
    { 0x013b4e,  20, 0x004eb6,  49,     -501 }, /* VERR_TCP_SERVER_SHUTDOWN */
    { 0x016b11,  16, 0x0166a6,  17,     -500 }, /* VERR_TCP_SERVER_STOP */
    { 0x015f58,  17, 0x00ccfb,  29,     -469 }, /* VERR_NET_NOT_UNSUPPORTED */
    { 0x01a50a,  11, 0x018794,  14,     -468 }, /* VERR_NET_INIT_FAILED */
    { 0x00f97d,  25, 0x00944b,  36,     -467 }, /* VERR_NET_INCOMPLETE_TX_PACKET */
    { 0x01806d,  15, 0x01ac6c,  10,     -466 }, /* VERR_NET_PROTOCOL_ERROR */
    { 0x01311b,  21, 0x0197d0,  13,     -465 }, /* VERR_NET_HOST_UNREACHABLE */
    { 0x018b84,  14, 0x01a6f9,  11,     -464 }, /* VERR_NET_HOST_DOWN */
    { 0x010f6f,  23, 0x0148ec,  19,     -461 }, /* VERR_NET_CONNECTION_REFUSED */
    { 0x00faa9,  25, 0x00c4c9,  30,     -460 }, /* VERR_NET_CONNECTION_TIMED_OUT */
    { 0x016a80,  17, 0x00c4c9,  30,     -459 }, /* VERR_NET_TOO_MANY_REFERENCES */
    { 0x019206,  13, 0x00aace,  33,     -458 }, /* VERR_NET_SHUTDOWN */
    { 0x017d9d,  15, 0x0148d9,  19,     -457 }, /* VERR_NET_NOT_CONNECTED */
    { 0x01836a,  15, 0x0146c5,  19,     -456 }, /* VERR_NET_ALREADY_CONNECTED */
    { 0x015a09,  18, 0x010d1c,  24,     -455 }, /* VERR_NET_NO_BUFFER_SPACE */
    { 0x00ca43,  29, 0x0119ad,  23,     -454 }, /* VERR_NET_CONNECTION_RESET_BY_PEER */
    { 0x0118de,  23, 0x00ac5a,  33,     -453 }, /* VERR_NET_CONNECTION_ABORTED */
    { 0x00ca43,  21, 0x0092bf,  36,     -452 }, /* VERR_NET_CONNECTION_RESET */
    { 0x016d60,  16, 0x013423,  21,     -451 }, /* VERR_NET_UNREACHABLE */
    { 0x01aeab,   9, 0x018430,  14,     -450 }, /* VERR_NET_DOWN */
    { 0x010fb4,  23, 0x012600,  22,     -449 }, /* VERR_NET_ADDRESS_NOT_AVAILABLE */
    { 0x01495e,  19, 0x018716,  14,     -448 }, /* VERR_NET_ADDRESS_IN_USE */
    { 0x012474,  22, 0x006b92,  43,     -447 }, /* VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED */
    { 0x0110c8,  23, 0x01587d,  18,     -446 }, /* VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED */
    { 0x01682d,  17, 0x019f99,  12,     -445 }, /* VERR_NET_OPERATION_NOT_SUPPORTED */
    { 0x0170d0,  16, 0x01abf4,  10,     -444 }, /* VERR_NET_SOCKET_TYPE_NOT_SUPPORTED */
    { 0x016ff0,  16, 0x01a70f,  11,     -443 }, /* VERR_NET_PROTOCOL_NOT_SUPPORTED */
    { 0x010b55,  24, 0x01359b,  20,     -442 }, /* VERR_NET_PROTOCOL_NOT_AVAILABLE */
    { 0x017eba,  15, 0x01092d,  24,     -441 }, /* VERR_NET_PROTOCOL_TYPE */
    { 0x01a80c,  10, 0x018954,  14,     -440 }, /* VERR_NET_MSG_SIZE */
    { 0x00f4d3,  26, 0x00cd6f,  29,     -439 }, /* VERR_NET_DEST_ADDRESS_REQUIRED */
    { 0x019f09,  12, 0x008044,  39,     -438 }, /* VERR_NET_NOT_SOCKET */
    { 0x016112,  17, 0x012a62,  21,     -437 }, /* VERR_NET_ALREADY_IN_PROGRESS */
    { 0x01777e,  16, 0x0142a5,  20,     -436 }, /* VERR_NET_IN_PROGRESS */
    { 0x015ed0,  17, 0x00f0dd,  26,     -406 }, /* VERR_NET_NOT_UNIQUE_NAME */
    { 0x019102,  13, 0x011854,  23,     -405 }, /* VERR_NET_NO_NETWORK */
    { 0x019975,  12, 0x00f333,  26,     -404 }, /* VERR_NET_PRINT_ERROR */
    { 0x019a4d,  12, 0x01a137,  11,     -403 }, /* VERR_NET_PATH_NOT_FOUND */
    { 0x019e61,  12, 0x016ab1,  16,     -402 }, /* VERR_NET_HOST_NOT_FOUND */
    { 0x01293c,  21, 0x00aedb,  32,     -401 }, /* VERR_NET_OUT_OF_RESOURCES */
    { 0x01af95,   9, 0x00c77b,  30,     -400 }, /* VERR_NET_IO_ERROR */
    { 0x01a8d4,  10, 0x008329,  39,     -377 }, /* VERR_SEM_LV_INTERNAL_ERROR */
    { 0x0156a9,  18, 0x009253,  36,     -376 }, /* VERR_SEM_LV_NOT_SIGNALLER */
    { 0x0111f3,  23, 0x009a2c,  35,     -375 }, /* VERR_SEM_LV_ILLEGAL_UPGRADE */
    { 0x018900,  14, 0x008869,  38,     -374 }, /* VERR_SEM_LV_NOT_OWNER */
    { 0x00f919,  25, 0x0063ef,  44,     -373 }, /* VERR_SEM_LV_EXISTING_DEADLOCK */
    { 0x016fd0,  16, 0x00956b,  36,     -372 }, /* VERR_SEM_LV_DEADLOCK */
    { 0x015c7f,  18, 0x0096f7,  36,     -371 }, /* VERR_SEM_LV_INVALID_PARAMETER */
    { 0x0189b6,  14, 0x005311,  48,     -370 }, /* VERR_SEM_LV_NESTED */
    { 0x00e9ad,  27, 0x00cdc6,  29,     -369 }, /* VERR_SEM_LV_WRONG_RELEASE_ORDER */
    { 0x0150dd,  19, 0x00cb65,  29,     -368 }, /* VERR_SEM_LV_WRONG_ORDER */
    { 0x0192bc,  13, 0x008524,  39,     -367 }, /* VERR_SEM_BAD_CONTEXT */
    { 0x0173bf,  16, 0x009ed2,  35,     -366 }, /* VERR_SEM_OUT_OF_TURN */
    { 0x01ae99,   9, 0x01535c,  18,     -365 }, /* VERR_DEADLOCK */
    { 0x01a4ff,  11, 0x0024b3,  62,     -364 }, /* VERR_SEM_NESTED */
    { 0x018858,  14, 0x00a1a0,  34,     -363 }, /* VERR_SEM_DESTROYED */
    { 0x01b6de,   7, 0x00ea4f,  27,     -362 }, /* VERR_SEM_NOT_FOUND */
    { 0x017bdb,  15, 0x006836,  43,     -361 }, /* VERR_SEM_OWNER_DIED */
    { 0x01ae36,   9, 0x016365,  17,     -360 }, /* VERR_SEM_BUSY */
    { 0x01b691,   7, 0x00f041,  26,     -359 }, /* VERR_ALREADY_RESET */
    { 0x01b479,   8, 0x00e416,  27,     -358 }, /* VERR_ALREADY_POSTED */
    { 0x01b239,   8, 0x006be8,  43,     -357 }, /* VERR_TOO_MANY_POSTS */
    { 0x01b411,   8, 0x00d6b7,  28,     -356 }, /* VERR_TOO_MANY_OPENS */
    { 0x01b819,   7, 0x0085e3,  38,     -355 }, /* VERR_NOT_OWNER */
    { 0x018379,  15, 0x0112d9,  23,     -354 }, /* VERR_TOO_MANY_SEM_REQUESTS */
    { 0x01a5af,  11, 0x00f111,  26,     -353 }, /* VERR_SEM_IS_SET */
    { 0x017170,  16, 0x006733,  44,     -352 }, /* VERR_EXCL_SEM_ALREADY_OWNED */
    { 0x018ed3,  13, 0x017160,  16,     -351 }, /* VERR_TOO_MANY_SEMAPHORES */
    { 0x01b9b6,   6, 0x00b6db,  32,     -350 }, /* VERR_SEM_ERROR */
    { 0x019f81,  12, 0x008d6c,  37,     -308 }, /* VERR_PIPE_NOT_WRITE */
    { 0x01a0f5,  11, 0x008e94,  37,     -307 }, /* VERR_PIPE_NOT_READ */
    { 0x01ac30,  10, 0x01248a,  22,     -306 }, /* VERR_MORE_DATA */
    { 0x0173df,  16, 0x016673,  17,     -305 }, /* VERR_PIPE_NOT_CONNECTED */
    { 0x01b98c,   6, 0x01b4c9,   8,     -304 }, /* VERR_NO_DATA */
    { 0x01ad48,  10, 0x01a54c,  11,     -303 }, /* VERR_PIPE_BUSY */
    { 0x01b974,   6, 0x01b908,   6,     -302 }, /* VERR_BAD_PIPE */
    { 0x019bb5,  12, 0x019c2d,  12,     -301 }, /* VERR_BROKEN_PIPE */
    { 0x01a816,  10, 0x00bf1c,  31,     -300 }, /* VERR_PIPE_IO_ERROR */
    { 0x017d7f,  15, 0x00d433,  28,     -257 }, /* VERR_IO_GEN_FAILURE */
    { 0x019254,  13, 0x012de8,  21,     -256 }, /* VERR_IO_SECTOR_NOT_FOUND */
    { 0x01a6a1,  11, 0x0139d2,  20,     -255 }, /* VERR_IO_BAD_LENGTH */
    { 0x01b739,   7, 0x016a09,  17,     -254 }, /* VERR_IO_CRC */
    { 0x019d41,  12, 0x012aca,  21,     -253 }, /* VERR_IO_BAD_COMMAND */
    { 0x01a898,  10, 0x012012,  22,     -252 }, /* VERR_IO_NOT_READY */
    { 0x01ad70,   9, 0x0154d6,  18,     -251 }, /* VERR_IO_BAD_UNIT */
    { 0x01adaf,   9, 0x00e266,  27,     -250 }, /* VERR_DEV_IO_ERROR */
    { 0x0115d0,  23, 0x0051c1,  48,     -234 }, /* VERR_IPE_NOT_REACHED_DEFAULT_CASE */
    { 0x01253a,  22, 0x01098d,  24,     -233 }, /* VERR_IPE_UNINITIALIZED_STATUS */
    { 0x01a444,  11, 0x01a1d1,  11,     -232 }, /* VERR_IPE_UNEXPECTED_ERROR_STATUS */
    { 0x018dd0,  14, 0x01a1d1,  11,     -231 }, /* VERR_IPE_UNEXPECTED_INFO_STATUS */
    { 0x01afd4,   9, 0x01a1d1,  11,     -230 }, /* VERR_IPE_UNEXPECTED_STATUS */
    { 0x01bb16,   5, 0x01bb57,   5,     -229 }, /* VERR_INTERNAL_ERROR_5 */
    { 0x01bb20,   5, 0x01bb57,   5,     -228 }, /* VERR_INTERNAL_ERROR_4 */
    { 0x01ba26,   5, 0x01bb57,   5,     -227 }, /* VERR_INTERNAL_ERROR_3 */
    { 0x01ba35,   5, 0x01bb57,   5,     -226 }, /* VERR_INTERNAL_ERROR_2 */
    { 0x01ba26,   3, 0x00cc30,  29,     -225 }, /* VERR_INTERNAL_ERROR */
    { 0x012bb1,  21, 0x00bc15,  31,     -202 }, /* VERR_NO_MORE_SEARCH_HANDLES */
    { 0x019915,  12, 0x019469,  13,     -201 }, /* VERR_NO_MORE_FILES */
    { 0x01b087,   9, 0x00cad4,  29,     -200 }, /* VERR_SEARCH_ERROR */
    { 0x017ccb,  15, 0x018644,  14,     -165 }, /* VERR_DRIVE_IS_EMPTY */
    { 0x016772,  17, 0x011bc6,  22,     -164 }, /* VERR_IS_A_CHAR_DEVICE */
    { 0x015327,  18, 0x01598b,  18,     -163 }, /* VERR_IS_A_BLOCK_DEVICE */
    { 0x01995d,  12, 0x019bcd,  12,     -162 }, /* VERR_IS_A_SOCKET */
    { 0x01ac76,  10, 0x01a9d8,  10,     -161 }, /* VERR_IS_A_FIFO */
    { 0x0195fc,  13, 0x014b85,  19,     -160 }, /* VERR_IS_A_SYMLINK */
    { 0x0168d7,  17, 0x011882,  23,     -159 }, /* VERR_SYMLINK_NOT_ALLOWED */
    { 0x0109a5,  24, 0x007c12,  40,     -158 }, /* VERR_NS_SYMLINK_CHANGE_OWNER */
    { 0x014179,  20, 0x0054bd,  47,     -157 }, /* VERR_NS_SYMLINK_SET_TIME */
    { 0x01a578,  11, 0x0135eb,  20,     -156 }, /* VERR_TOO_MANY_SYMLINKS */
    { 0x0192d6,  13, 0x00d6ef,  28,     -155 }, /* VERR_DISK_INVALID_FORMAT */
    { 0x018f6f,  13, 0x018740,  14,     -154 }, /* VERR_DRIVE_LOCKED */
    { 0x019879,  12, 0x018a34,  14,     -153 }, /* VERR_DISK_CHANGE */
    { 0x01a762,  10, 0x01a297,  11,     -152 }, /* VERR_DISK_FULL */
    { 0x01b7be,   7, 0x018caa,  14,     -151 }, /* VERR_INVALID_DRIVE */
    { 0x01a780,  10, 0x00b8d0,  31,     -150 }, /* VERR_DISK_IO_ERROR */
    { 0x018c9c,  14, 0x007448,  41,     -147 }, /* VERR_STALE_FILE_HANDLE */
    { 0x00f6c1,  25, 0x001b45,  65,     -146 }, /* VERR_FILE_AIO_INSUFFICIENT_EVENTS */
    { 0x016475,  17, 0x016a1a,  17,     -145 }, /* VERR_PATH_ZERO_LENGTH */
    { 0x015d21,  18, 0x0060fc,  45,     -144 }, /* VERR_PATH_IS_NOT_RELATIVE */
    { 0x016233,  17, 0x00c127,  30,     -143 }, /* VERR_PATH_IS_RELATIVE */
    { 0x00e323,  27, 0x00ab73,  33,     -142 }, /* VERR_PATH_DOES_NOT_START_WITH_ROOT */
    { 0x01a83e,  10, 0x015c5b,  18,     -141 }, /* VERR_UNEXPECTED_FS_OBJ_TYPE */
    { 0x01aa00,  10, 0x00b13b,  32,     -140 }, /* VERR_IS_A_FILE */
    { 0x01b541,   8, 0x00b3db,  32,     -139 }, /* VERR_NOT_A_FILE */
    { 0x0189d2,  14, 0x0119db,  23,     -138 }, /* VERR_RESOURCE_BUSY */
    { 0x00cc13,  29, 0x003337,  57,     -137 }, /* VERR_FILE_AIO_INSUFFICIENT_RESSOURCES */
    { 0x017fd7,  15, 0x00888f,  38,     -136 }, /* VERR_FILE_AIO_NOT_PREPARED */
    { 0x01745f,  16, 0x0074ec,  41,     -135 }, /* VERR_FILE_AIO_NOT_SUBMITTED */
    { 0x01874e,  14, 0x019aa1,  12,     -134 }, /* VERR_FILE_AIO_CANCELED */
    { 0x014359,  20, 0x001d4d,  65,     -133 }, /* VERR_FILE_AIO_LIMIT_EXCEEDED */
    { 0x01ac80,  10, 0x001974,  67,     -132 }, /* VERR_FILE_AIO_BUSY */
    { 0x017e7e,  15, 0x00a46a,  34,     -131 }, /* VERR_FILE_AIO_COMPLETED */
    { 0x01693d,  17, 0x001712,  68,     -130 }, /* VERR_FILE_AIO_IN_PROGRESS */
    { 0x01867c,  14, 0x007107,  42,     -129 }, /* VERR_FILE_AIO_NO_REQUEST */
    { 0x01ba0a,   6, 0x004074,  53,     -128 }, /* VERR_FILE_TOO_BIG */
    { 0x018310,  15, 0x00acbb,  32,     -127 }, /* VERR_IS_A_DIRECTORY */
    { 0x018f48,  13, 0x00ad3b,  32,     -126 }, /* VERR_NOT_A_DIRECTORY */
    { 0x01a208,  11, 0x013088,  21,     -125 }, /* VERR_DIR_NOT_EMPTY */
    { 0x01a3aa,  11, 0x00ee87,  26,     -124 }, /* VERR_FILE_LOCK_LOST */
    { 0x01ae5a,   9, 0x00b8ef,  31,     -123 }, /* VERR_FILE_NOT_LOCKED */
    { 0x01523d,  18, 0x01220c,  22,     -122 }, /* VERR_MEDIA_NOT_RECOGNIZED */
    { 0x017f14,  15, 0x012238,  22,     -121 }, /* VERR_MEDIA_NOT_PRESENT */
    { 0x0180d6,  15, 0x00d77b,  28,     -120 }, /* VERR_FILENAME_TOO_LONG */
    { 0x019080,  13, 0x00f437,  26,     -119 }, /* VERR_NOT_SAME_DEVICE */
    { 0x011c1e,  22, 0x010328,  25,     -118 }, /* VERR_CANT_DELETE_DIRECTORY */
    { 0x01983d,  12, 0x011fd0,  22,     -117 }, /* VERR_CANT_CREATE */
    { 0x0172b0,  16, 0x003f01,  53,     -116 }, /* VERR_FILE_LOCK_VIOLATION */
    { 0x01b1e9,   8, 0x01071d,  24,     -115 }, /* VERR_FILE_LOCK_FAILED */
    { 0x015bdd,  18, 0x004e85,  49,     -114 }, /* VERR_SHARING_VIOLATION */
    { 0x018d98,  14, 0x01815d,  15,     -113 }, /* VERR_WRITE_PROTECT */
    { 0x01b5a9,   8, 0x01b012,   9,     -112 }, /* VERR_WRITE_ERROR */
    { 0x01b62f,   7, 0x01b4e9,   8,     -111 }, /* VERR_READ_ERROR */
    { 0x01bbcd,   4, 0x0140ed,  20,     -110 }, /* VERR_EOF */
    { 0x017e8d,  15, 0x01127d,  23,     -109 }, /* VERR_SEEK_ON_DEVICE */
    { 0x018d6e,  14, 0x015a51,  18,     -108 }, /* VERR_NEGATIVE_SEEK */
    { 0x017e8d,   5, 0x01b932,   6,     -107 }, /* VERR_SEEK */
    { 0x019401,  13, 0x0177de,  16,     -106 }, /* VERR_TOO_MANY_OPEN_FILES */
    { 0x01b299,   8, 0x01372b,  20,     -105 }, /* VERR_ALREADY_EXISTS */
    { 0x01b9b0,   6, 0x00dafb,  28,     -104 }, /* VERR_INVALID_NAME */
    { 0x01b3d9,   8, 0x01b851,   7,     -103 }, /* VERR_PATH_NOT_FOUND */
    { 0x01bb9d,   4, 0x01b820,   7,     -102 }, /* VERR_FILE_NOT_FOUND */
    { 0x01b72b,   7, 0x015661,  18,     -101 }, /* VERR_OPEN_FAILED */
    { 0x01b878,   6, 0x00e926,  27,     -100 }, /* VERR_FILE_IO_ERROR */
    { 0x01bc6f,   2, 0x0147f5,  19,      -99 }, /* VERR_MISSING */
    { 0x01acf8,  10, 0x0141f1,  20,      -98 }, /* VERR_DUPLICATE */
    { 0x01a368,  11, 0x0188d6,  14,      -97 }, /* VERR_UNSUPPORTED_ALIGNMENT */
    { 0x01b499,   8, 0x0048e2,  50,      -96 }, /* VERR_NO_EXEC_MEMORY */
    { 0x01b301,   8, 0x019b3d,  12,      -95 }, /* VERR_NO_CHANGE */
    { 0x015434,  18, 0x009883,  36,      -93 }, /* VERR_CALLER_NO_REFERENCE */
    { 0x015a2d,  18, 0x00b9a9,  31,      -92 }, /* VERR_CONCURRENT_ACCESS */
    { 0x01b271,   8, 0x001756,  68,      -91 }, /* VERR_IGNORED */
    { 0x018c80,  14, 0x0164fd,  17,      -90 }, /* VERR_NOT_POWER_OF_TWO */
    { 0x011a09,  23, 0x010fe2,  23,      -89 }, /* VERR_AUTHENTICATION_FAILURE */
    { 0x017110,  16, 0x008155,  39,      -88 }, /* VERR_CALLBACK_RETURN */
    { 0x01aafa,  10, 0x0162aa,  17,      -87 }, /* VERR_INVALID_BASE64_ENCODING */
    { 0x016860,  17, 0x00ff27,  25,      -86 }, /* VERR_DANGLING_OBJECTS */
    { 0x0166c8,  17, 0x014a55,  19,      -85 }, /* VERR_OBJECT_DESTROYED */
    { 0x0138ce,  20, 0x01337c,  21,      -84 }, /* VERR_PAGE_COUNT_OUT_OF_RANGE */
    { 0x01afcb,   9, 0x019969,  12,      -83 }, /* VERR_END_OF_STRING */
    { 0x016277,  17, 0x0130c7,  21,      -82 }, /* VERR_PREEMPT_DISABLED */
    { 0x0186fa,  14, 0x0079e2,  40,      -81 }, /* VERR_NO_MORE_HANDLES */
    { 0x015f03,  17, 0x016167,  17,      -80 }, /* VERR_OUT_OF_RESOURCES */
    { 0x01bc62,   3, 0x01bbad,   4,      -79 }, /* VERR_INVALID_STATE */
    { 0x01bc38,   3, 0x01af9e,   9,      -78 }, /* VERR_NOT_FOUND */
    { 0x016d30,  16, 0x017090,  16,      -77 }, /* VERR_TRAILING_SPACES */
    { 0x017ff5,  15, 0x013f0d,  20,      -76 }, /* VERR_TRAILING_CHARS */
    { 0x01b92c,   6, 0x01731f,  16,      -75 }, /* VERR_MAP_FAILED */
    { 0x019768,  13, 0x009ef5,  35,      -74 }, /* VERR_ADDRESS_TOO_BIG */
    { 0x01b331,   8, 0x0026da,  60,      -73 }, /* VERR_NO_PHYS_MEMORY */
    { 0x01b6c2,   7, 0x00380a,  55,      -72 }, /* VERR_NO_LOW_MEMORY */
    { 0x018874,  14, 0x01152f,  23,      -71 }, /* VERR_MEMOBJ_INIT_FAILED */
    { 0x01a82a,  10, 0x003954,  55,      -70 }, /* VERR_CANCELLED */
    { 0x01768f,  16, 0x0084af,  39,      -69 }, /* VERR_TIMER_SUSPENDED */
    { 0x019609,  13, 0x0093bb,  36,      -68 }, /* VERR_TIMER_ACTIVE */
    { 0x01b7a9,   7, 0x00a81a,  33,      -67 }, /* VERR_MEMORY_BUSY */
    { 0x018820,  14, 0x0033a9,  57,      -66 }, /* VERR_NO_CODE_POINT_MEMORY */
    { 0x01b000,   9, 0x0020cb,  63,      -65 }, /* VERR_NO_UTF16_MEMORY */
    { 0x01b76a,   7, 0x0059b2,  47,      -64 }, /* VERR_NO_STR_MEMORY */
    { 0x0131c3,  21, 0x005579,  47,      -63 }, /* VERR_CANT_RECODE_AS_UTF16 */
    { 0x01af17,   9, 0x00698e,  43,      -62 }, /* VERR_INVALID_UTF16_ENCODING */
    { 0x01b171,   8, 0x0078c4,  41,      -61 }, /* VERR_INVALID_UTF8_ENCODING */
    { 0x012c98,  21, 0x00379c,  55,      -60 }, /* VERR_CODE_POINT_SURROGATE */
    { 0x00dcd7,  28, 0x001077,  73,      -59 }, /* VERR_CODE_POINT_ENDIAN_INDICATOR */
    { 0x0190b4,  13, 0x0062bb,  44,      -58 }, /* VERR_NO_TRANSLATION */
    { 0x015589,  18, 0x008f97,  37,      -57 }, /* VERR_NEGATIVE_UNSIGNED */
    { 0x01b5a1,   8, 0x005606,  47,      -56 }, /* VERR_NO_DIGITS */
    { 0x019dad,  12, 0x007515,  41,      -55 }, /* VERR_NUMBER_TOO_BIG */
    { 0x0196b2,  13, 0x015ee1,  17,      -54 }, /* VERR_OUT_OF_RANGE */
    { 0x01bc56,   3, 0x01b4d1,   8,      -53 }, /* VERR_PARSE_ERROR */
    { 0x01a7a8,  10, 0x01b551,   8,      -52 }, /* VERR_TRY_AGAIN */
    { 0x017000,  16, 0x00a775,  33,      -51 }, /* VERR_PROCESS_RUNNING */
    { 0x01a562,  11, 0x01b9f8,   6,      -50 }, /* VERR_PROCESS_NOT_FOUND */
    { 0x0194d1,  13, 0x00e014,  27,      -49 }, /* VERR_INVALID_UUID_FORMAT */
    { 0x01ab22,  10, 0x01a974,  10,      -48 }, /* VERR_STATE_CHANGED */
    { 0x017b81,  15, 0x00b854,  31,      -47 }, /* VERR_SIGNAL_INVALID */
    { 0x017b36,  15, 0x0144fe,  19,      -46 }, /* VERR_SIGNAL_PENDING */
    { 0x017d16,  15, 0x00cb82,  29,      -45 }, /* VERR_SIGNAL_REFUSED */
    { 0x015b83,  18, 0x018510,  14,      -44 }, /* VERR_MAX_PROCS_REACHED */
    { 0x0157db,  18, 0x012966,  21,      -43 }, /* VERR_MAX_THRDS_REACHED */
    { 0x01a26b,  11, 0x014867,  19,      -42 }, /* VERR_TOO_MUCH_DATA */
    { 0x016b01,  16, 0x00e1fa,  27,      -41 }, /* VERR_BUFFER_OVERFLOW */
    { 0x01b459,   8, 0x01b579,   8,      -40 }, /* VERR_TIMEOUT */
    { 0x019e55,  12, 0x0168e8,  17,      -39 }, /* VERR_INTERRUPTED */
    { 0x0188ac,  14, 0x018804,  14,      -38 }, /* VERR_ACCESS_DENIED */
    { 0x01bc3b,   3, 0x01bafd,   5,      -37 }, /* VERR_NOT_SUPPORTED */
    { 0x01a7ee,  10, 0x01aa0a,  10,      -36 }, /* VERR_INVALID_FUNCTION */
    { 0x01956d,  13, 0x0096d3,  36,      -35 }, /* VERR_UNRESOLVED_ERROR */
    { 0x016266,  17, 0x0163ed,  17,      -34 }, /* VERR_ADDRESS_CONFLICT */
    { 0x01a6d8,  11, 0x01547c,  18,      -33 }, /* VERR_TIMER_BUSY */
    { 0x01afef,   9, 0x01ad79,   9,      -32 }, /* VERR_INVALID_CONTEXT */
    { 0x016b51,  16, 0x014653,  19,      -31 }, /* VERR_PAGE_TABLE_NOT_PRESENT */
    { 0x016530,  17, 0x0138f6,  20,      -30 }, /* VERR_THREAD_NOT_WAITABLE */
    { 0x0181f3,  15, 0x017a0a,  15,      -29 }, /* VERR_THREAD_IS_DEAD */
    { 0x018fb0,  13, 0x01404d,  20,      -28 }, /* VERR_ALREADY_INITIALIZED */
    { 0x01bbb9,   4, 0x00df8d,  27,      -27 }, /* VERR_NO_PAGE_MEMORY */
    { 0x01b361,   8, 0x008d22,  37,      -26 }, /* VERR_NO_CONT_MEMORY */
    { 0x0151f5,  18, 0x001bc7,  65,      -24 }, /* VERR_FAILED_TO_SET_SELF_TLS */
    { 0x018bae,  14, 0x0010c0,  72,      -23 }, /* VERR_NO_TLS_FOR_SELF */
    { 0x0197e9,  12, 0x012b09,  21,      -22 }, /* VERR_WRONG_ORDER */
    { 0x01b755,   7, 0x01227a,  22,      -21 }, /* VERR_INVALID_FMODE */
    { 0x01b7c5,   7, 0x00d9e3,  28,      -20 }, /* VERR_NO_TMP_MEMORY */
    { 0x01b105,   9, 0x00c613,  30,      -19 }, /* VERR_NOT_SYMLINK */
    { 0x01b7b7,   7, 0x01ac44,  10,      -18 }, /* VERR_NOT_EQUAL */
    { 0x01b7ef,   7, 0x018938,  14,      -13 }, /* VERR_INVALID_FLAGS */
    { 0x0191b8,  13, 0x00ff8b,  25,      -12 }, /* VERR_NOT_IMPLEMENTED */
    { 0x01bbed,   4, 0x016244,  17,      -11 }, /* VERR_VERSION_MISMATCH */
    { 0x0158a1,  18, 0x01576f,  18,      -10 }, /* VERR_PERMISSION_DENIED */
    { 0x01b591,   8, 0x018031,  15,       -9 }, /* VERR_ALREADY_LOADED */
    { 0x01bc65,   3, 0x01441a,  19,       -8 }, /* VERR_NO_MEMORY */
    { 0x01b8ba,   6, 0x018e78,  13,       -7 }, /* VERR_IDT_FAILED */
    { 0x01af83,   9, 0x01a8c0,  10,       -6 }, /* VERR_INVALID_POINTER */
    { 0x01b660,   7, 0x0122a6,  22,       -5 }, /* VERR_LOCK_FAILED */
    { 0x01b311,   8, 0x01b329,   8,       -4 }, /* VERR_INVALID_HANDLE */
    { 0x01b7d3,   7, 0x0178b1,  15,       -3 }, /* VERR_INVALID_MAGIC */
    { 0x01a2a2,  11, 0x01a58e,  11,       -2 }, /* VERR_INVALID_PARAMETER */
    { 0x017260,  16, 0x00983b,  36,       -1 }, /* VERR_GENERAL_FAILURE */
    { 0x01b589,   8, 0x01b1e1,   8,        0 }, /* VINF_SUCCESS */
    { 0x01a42e,  11, 0x01a58e,  11,        2 }, /* VWRN_INVALID_PARAMETER */
    { 0x01b7f6,   7, 0x0178b1,  15,        3 }, /* VWRN_INVALID_MAGIC */
    { 0x01b229,   8, 0x01b329,   8,        4 }, /* VWRN_INVALID_HANDLE */
    { 0x015cc7,  18, 0x01576f,  18,       10 }, /* VINF_PERMISSION_DENIED */
    { 0x0190db,  13, 0x00ff8b,  25,       12 }, /* VINF_NOT_IMPLEMENTED */
    { 0x019066,  13, 0x01404d,  20,       28 }, /* VINF_ALREADY_INITIALIZED */
    { 0x01bc53,   3, 0x01bafd,   5,       37 }, /* VINF_NOT_SUPPORTED */
    { 0x019c8d,  12, 0x0168e8,  17,       39 }, /* VINF_INTERRUPTED */
    { 0x01b5d9,   8, 0x01b579,   8,       40 }, /* VINF_TIMEOUT */
    { 0x016d10,  16, 0x00e1fa,  27,       41 }, /* VINF_BUFFER_OVERFLOW */
    { 0x01aab4,  10, 0x014d60,  19,       48 }, /* VWRN_STATE_CHANGED */
    { 0x01ad16,  10, 0x01b551,   8,       52 }, /* VINF_TRY_AGAIN */
    { 0x019825,  12, 0x007515,  41,       55 }, /* VWRN_NUMBER_TOO_BIG */
    { 0x01b139,   8, 0x005606,  47,       56 }, /* VWRN_NO_DIGITS */
    { 0x01534b,  18, 0x008f97,  37,       57 }, /* VWRN_NEGATIVE_UNSIGNED */
    { 0x01971a,  13, 0x0062bb,  44,       58 }, /* VWRN_NO_TRANSLATION */
    { 0x0181c6,  15, 0x013f0d,  20,       76 }, /* VWRN_TRAILING_CHARS */
    { 0x0177ce,  16, 0x017090,  16,       77 }, /* VWRN_TRAILING_SPACES */
    { 0x01bc44,   3, 0x016eb0,  16,       78 }, /* VWRN_NOT_FOUND */
    { 0x01bc68,   3, 0x01a163,  11,       79 }, /* VWRN_INVALID_STATE */
    { 0x0161ef,  17, 0x010585,  24,       80 }, /* VWRN_OUT_OF_RESOURCES */
    { 0x01b0cf,   9, 0x019969,  12,       83 }, /* VINF_END_OF_STRING */
    { 0x0162bb,  17, 0x00e5e1,  27,       85 }, /* VINF_OBJECT_DESTROYED */
    { 0x01662f,  17, 0x00ff27,  25,       86 }, /* VWRN_DANGLING_OBJECTS */
    { 0x01767f,  16, 0x008155,  39,       88 }, /* VINF_CALLBACK_RETURN */
    { 0x01b449,   8, 0x016e50,  16,       95 }, /* VINF_NO_CHANGE */
    { 0x01a394,  11, 0x001576,  69,       97 }, /* VINF_UNSUPPORTED_ALIGNMENT */
    { 0x01b279,   8, 0x01372b,  20,      105 }, /* VWRN_ALREADY_EXISTS */
    { 0x01bc05,   4, 0x0140ed,  20,      110 }, /* VINF_EOF */
    { 0x018ee0,  13, 0x006156,  45,      203 }, /* VWRN_NO_DIRENT_INFO */
    { 0x01b599,   8, 0x00e416,  27,      358 }, /* VINF_ALREADY_POSTED */
    { 0x01a1e7,  11, 0x004b3a,  50,      364 }, /* VINF_SEM_NESTED */
    { 0x01941b,  13, 0x0047e8,  50,      367 }, /* VINF_SEM_BAD_CONTEXT */
    { 0x0173cf,  16, 0x015ef2,  17,      500 }, /* VINF_TCP_SERVER_STOP */
    { 0x014d4d,  19, 0x00894d,  38,      503 }, /* VINF_TCP_SERVER_NO_CLIENT */
    { 0x01733f,  16, 0x015ef2,  17,      520 }, /* VINF_UDP_SERVER_STOP */
    { 0x014b5f,  19, 0x0086c7,  38,      523 }, /* VINF_UDP_SERVER_NO_CLIENT */
    { 0x013982,  20, 0x00641b,  44,      564 }, /* VINF_IPC_RECEIVE_MSG_CUT */
    { 0x0167fa,  17, 0x00737b,  41,      565 }, /* VINF_IPC_SEND_MSG_CUT */
    { 0x014fad,  19, 0x0083c5,  39,      690 }, /* VINF_DBG_ADJUSTED_SYM_SIZE */
    { 0x01a696,  11, 0x00f193,  26,      750 }, /* VINF_ENV_VAR_NOT_FOUND */
    { 0x011f36,  22, 0x0005dd,  96,      751 }, /* VWRN_ENV_NOT_FULLY_TRANSLATED */
    { 0x0183c0,  14, 0x008e00,  37,      753 }, /* VINF_ENV_VAR_UNSET */
    { 0x017e33,  15, 0x012398,  22,      828 }, /* VINF_GETOPT_NOT_OPTION */
    { 0x019150,  13, 0x018bd8,  14,      948 }, /* VINF_TAR_DIR_PATH */
    { 0x01bab2,   5, 0x01bad5,   5,     1002 }, /* VWRN_UNSUPPORTED_CPU */
    { 0x012798,  21, 0x0057ad,  47,     1028 }, /* VINF_DRIVER_REBOOT_NEEDED */
    { 0x01909a,  13, 0x003454,  57,     1100 }, /* VINF_EM_TERMINATE */
    { 0x012ab6,  21, 0x00f964,  25,     1101 }, /* VINF_EM_DBG_HYPER_STEPPED */
    { 0x0109bd,  24, 0x00021a, 124,     1102 }, /* VINF_EM_DBG_HYPER_BREAKPOINT */
    { 0x01134c,  23, 00000000, 142,     1103 }, /* VINF_EM_DBG_HYPER_ASSERTION */
    { 0x019213,  13, 0x009523,  36,     1104 }, /* VINF_EM_DBG_EVENT */
    { 0x01a065,  12, 0x000c54,  80,     1105 }, /* VINF_EM_DBG_STOP */
    { 0x017b9f,  15, 0x001228,  72,     1106 }, /* VINF_EM_DBG_STEPPED */
    { 0x015af3,  18, 0x0007ac,  90,     1107 }, /* VINF_EM_DBG_BREAKPOINT */
    { 0x017b9f,  12, 0x00548e,  47,     1108 }, /* VINF_EM_DBG_STEP */
    { 0x01b78d,   7, 0x000a16,  85,     1109 }, /* VINF_EM_OFF */
    { 0x01a6ee,  11, 0x000e26,  76,     1110 }, /* VINF_EM_SUSPEND */
    { 0x01b0c6,   9, 0x001e4e,  64,     1111 }, /* VINF_EM_RESET */
    { 0x01b491,   8, 0x000452, 103,     1112 }, /* VINF_EM_HALT */
    { 0x00f451,  10, 0x002e44,  58,     1113 }, /* VINF_EM_RESUME */
    { 0x01b866,   6, 0x000752,  90,     1114 }, /* VINF_EM_NO_MEMORY */
    { 0x015b17,  18, 0x0038af,  55,     1115 }, /* VINF_EM_RESCHEDULE_REM */
    { 0x00f56f,  26, 0x0031e1,  57,     1116 }, /* VINF_EM_RESCHEDULE_EXEC_ENGINE */
    { 0x00f56f,  14, 0x007634,  41,     1118 }, /* VINF_EM_RESCHEDULE */
    { 0x019587,  13, 0x00d319,  29,     1120 }, /* VINF_EM_WAIT_SIPI */
    { 0x0155bf,  18, 0x0078ed,  41,     1121 }, /* VINF_EM_RAW_GUEST_TRAP */
    { 0x00f7a2,  17, 0x00823f,  39,     1122 }, /* VINF_EM_RAW_INTERRUPT */
    { 0x0116cd,  23, 0x002f66,  58,     1123 }, /* VINF_EM_RAW_INTERRUPT_HYPER */
    { 0x0114a5,  19, 0x00b67b,  32,     1124 }, /* VINF_EM_RAW_RING_SWITCH */
    { 0x0114a5,  23, 0x0033e2,  57,     1125 }, /* VINF_EM_RAW_RING_SWITCH_INT */
    { 0x00dc4b,  28, 0x0075e2,  41,     1126 }, /* VINF_EM_RAW_EXCEPTION_PRIVILEGED */
    { 0x00b79a,  21, 0x00e509,  27,     1127 }, /* VINF_EM_RAW_EMULATE_INSTR */
    { 0x00c014,  31, 0x00e740,  27,     1128 }, /* VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT */
    { 0x00bde6,  31, 0x00e158,  27,     1129 }, /* VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT */
    { 0x00b79a,  31, 0x00eb78,  27,     1130 }, /* VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT */
    { 0x00baa1,  31, 0x00b65b,  32,     1131 }, /* VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT */
    { 0x018fbd,  13, 0x01124f,  23,     1135 }, /* VINF_EM_RAW_TO_R3 */
    { 0x0134b6,  21, 0x012e66,  21,     1136 }, /* VINF_EM_RAW_TIMER_PENDING */
    { 0x00f7a2,  25, 0x00a900,  33,     1137 }, /* VINF_EM_RAW_INTERRUPT_PENDING */
    { 0x0125ea,  22, 0x00fd4c,  25,     1138 }, /* VINF_EM_RAW_STALE_SELECTOR */
    { 0x0164ec,  17, 0x009307,  36,     1139 }, /* VINF_EM_RAW_IRET_TRAP */
    { 0x014e1e,  19, 0x015781,  18,     1150 }, /* VINF_EM_PENDING_REQUEST */
    { 0x0109d5,  24, 0x00ce74,  29,     1151 }, /* VINF_EM_RAW_EMULATE_DBG_STEP */
    { 0x012290,  22, 0x00cfd0,  29,     1152 }, /* VINF_EM_HM_PATCH_TPR_INSTR */
    { 0x016e00,  16, 0x00ae3b,  32,     1155 }, /* VINF_EM_TRIPLE_FAULT */
    { 0x01038c,  25, 0x00e668,  27,     1157 }, /* VINF_EM_RAW_INJECT_TRPM_EVENT */
    { 0x00f625,  26, 0x008f28,  37,     1159 }, /* VINF_EM_PENDING_R3_IOPORT_READ */
    { 0x00e2b7,  27, 0x008843,  38,     1160 }, /* VINF_EM_PENDING_R3_IOPORT_WRITE */
    { 0x00f451,  26, 0x002716,  60,     1161 }, /* VINF_EM_RESUME_R3_HISTORY_EXEC */
    { 0x011c08,  22, 0x00abb5,  33,     1162 }, /* VINF_EM_EMULATE_SPLIT_LOCK */
    { 0x01ab18,  10, 0x00c052,  31,     1202 }, /* VWRN_DBGF_ALREADY_HALTED */
    { 0x018c10,  14, 0x00ac39,  33,     1205 }, /* VINF_DBGF_BP_ALREADY_ENABLED */
    { 0x0181a8,  15, 0x009b8a,  35,     1206 }, /* VINF_DBGF_BP_ALREADY_DISABLED */
    { 0x019b19,  12, 0x01a848,  10,     1207 }, /* VINF_DBGF_BP_ALREADY_EXIST */
    { 0x0186b4,  14, 0x0178fc,  15,     1209 }, /* VINF_DBGF_OS_NOT_DETCTED */
    { 0x013391,  21, 0x015db1,  18,     1211 }, /* VINF_DBGF_TRUNCATED_REGISTER */
    { 0x0102ab,  25, 0x0120ac,  22,     1212 }, /* VINF_DBGF_ZERO_EXTENDED_REGISTER */
    { 0x01aca8,  10, 0x0006f7,  91,     1224 }, /* VINF_DBGF_BP_HALT */
    { 0x013767,  20, 0x005131,  48,     1239 }, /* VINF_DBGF_R3_BP_OWNER_DEFER */
    { 0x015e77,  18, 0x0056c2,  47,     1400 }, /* VWRN_CONTINUE_ANALYSIS */
    { 0x0184a0,  14, 0x018636,  14,     1404 }, /* VWRN_PATCH_ENABLED */
    { 0x018724,  14, 0x017bea,  15,     1407 }, /* VWRN_PATCH_REMOVED */
    { 0x014d14,  19, 0x00a9c6,  33,     1408 }, /* VINF_PATM_PATCH_TRAP_GP */
    { 0x014407,  19, 0x00aa08,  33,     1409 }, /* VINF_PATM_PATCH_TRAP_PF */
    { 0x0172ff,  16, 0x00a68a,  34,     1410 }, /* VINF_PATM_PATCH_INT3 */
    { 0x011aa8,  22, 0x00a984,  33,     1411 }, /* VINF_PATM_CHECK_PATCH_PAGE */
    { 0x0108e5,  24, 0x007b22,  40,     1412 }, /* VINF_PATM_DUPLICATE_FUNCTION */
    { 0x013a36,  20, 0x00f49f,  26,     1413 }, /* VINF_PATCH_EMULATE_INSTR */
    { 0x011d52,  22, 0x00c307,  30,     1414 }, /* VINF_PATM_HC_MMIO_PATCH_WRITE */
    { 0x0132bf,  21, 0x00cecb,  29,     1415 }, /* VINF_PATM_HC_MMIO_PATCH_READ */
    { 0x00d69b,  28, 0x008092,  39,     1416 }, /* VINF_PATM_PENDING_IRQ_AFTER_IRET */
    { 0x015f36,  17, 0x01056d,  24,     1427 }, /* VWRN_PATCH_END_BRANCH */
    { 0x016d00,  16, 0x013a72,  20,     1429 }, /* VINF_PATM_SPINLOCK_FAILED */
    { 0x017c35,  15, 0x0098a7,  36,     1430 }, /* VINF_PATCH_CONTINUE */
    { 0x014971,  19, 0x018e5c,  14,     1500 }, /* VWRN_CSAM_TRAP_NOT_HANDLED */
    { 0x00f9c8,  25, 0x01744f,  16,     1501 }, /* VWRN_CSAM_INSTRUCTION_PATCHED */
    { 0x01b02d,   9, 0x018b22,  14,     1502 }, /* VWRN_CSAM_PAGE_NOT_FOUND */
    { 0x013842,  20, 0x007872,  41,     1503 }, /* VINF_CSAM_PENDING_ACTION */
    { 0x01aabe,  10, 0x00f27d,  26,     1613 }, /* VINF_PGM_SYNC_CR3 */
    { 0x0134a1,  21, 0x00a7f9,  33,     1614 }, /* VINF_PGM_NO_DIRTY_BIT_TRACKING */
    { 0x010279,  25, 0x00503e,  49,     1615 }, /* VINF_PGM_HANDLED_DIRTY_BIT_FAULT */
    { 0x0141b5,  20, 0x00bede,  31,     1616 }, /* VINF_PGM_HANDLER_DO_DEFAULT */
    { 0x018e92,  13, 0x00ef3d,  26,     1622 }, /* VINF_PGM_CACHED_PAGE */
    { 0x017120,  16, 0x000118, 133,     1623 }, /* VINF_PGM_GCPHYS_ALIASED */
    { 0x011449,  23, 0x011671,  23,     1625 }, /* VINF_PGM_SYNCPAGE_MODIFIED_PDE */
    { 0x011b42,  22, 0x0088b5,  38,     1635 }, /* VINF_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x015e1d,  18, 0x00ddd3,  28,     1643 }, /* VINF_PGM_HANDLER_ALREADY_ALIASED */
    { 0x013d42,  20, 0x007f32,  40,     1644 }, /* VINF_PGM_POOL_FLUSH_PENDING */
    { 0x0162ff,  17, 0x00b39b,  32,     1758 }, /* VINF_CPUM_R3_MSR_READ */
    { 0x0152cd,  18, 0x00a85b,  33,     1759 }, /* VINF_CPUM_R3_MSR_WRITE */
    { 0x01190c,  23, 0x005635,  47,     1766 }, /* VINF_CPUM_HOST_CR0_MODIFIED */
    { 0x012d94,  21, 0x009b44,  35,     1769 }, /* VINF_CPUM_MATCHED_BY_NAME */
    { 0x0118f5,  23, 0x014724,  19,     1851 }, /* VINF_SSM_VOTE_FOR_ANOTHER_PASS */
    { 0x00e8f0,  27, 0x0046ea,  51,     1852 }, /* VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN */
    { 0x016882,  17, 0x009c7f,  35,     1854 }, /* VINF_SSM_DONT_CALL_AGAIN */
    { 0x0176df,  16, 0x0029e4,  59,     1864 }, /* VINF_SSM_LIVE_SUSPENDED */
    { 0x019b31,  12, 0x00eb27,  27,     2008 }, /* VWRN_VRDP_PDU_NOT_SUPPORTED */
    { 0x0165c9,  17, 0x005191,  48,     2009 }, /* VINF_VRDP_PROCESS_PDU */
    { 0x00fd65,  25, 0x00b5fb,  32,     2010 }, /* VINF_VRDP_OPERATION_COMPLETED */
    { 0x01422d,  20, 0x00a668,  34,     2011 }, /* VINF_VRDP_THREAD_STARTED */
    { 0x01215c,  22, 0x003d21,  54,     2012 }, /* VINF_VRDP_RESIZE_REQUESTED */
    { 0x014cdb,  19, 0x00d24e,  29,     2013 }, /* VINF_VRDP_OUTPUT_ENABLE */
    { 0x018d52,  14, 0x00971b,  36,     2503 }, /* VINF_SELM_SYNC_GDT */
    { 0x017080,  16, 0x00f770,  25,     2615 }, /* VINF_IOM_MMIO_UNUSED_00 */
    { 0x016d80,  16, 0x00f9fa,  25,     2616 }, /* VINF_IOM_MMIO_UNUSED_FF */
    { 0x014f74,  19, 0x012bf0,  21,     2620 }, /* VINF_IOM_R3_IOPORT_READ */
    { 0x0140c5,  20, 0x011b16,  22,     2621 }, /* VINF_IOM_R3_IOPORT_WRITE */
    { 0x00e2d2,  27, 0x00c0af,  30,     2622 }, /* VINF_IOM_R3_IOPORT_COMMIT_WRITE */
    { 0x013fad,  14, 0x0186d0,  14,     2623 }, /* VINF_IOM_R3_MMIO_READ */
    { 0x017de8,  15, 0x017b09,  15,     2624 }, /* VINF_IOM_R3_MMIO_WRITE */
    { 0x013fad,  20, 0x013dce,  20,     2625 }, /* VINF_IOM_R3_MMIO_READ_WRITE */
    { 0x011f62,  22, 0x010efc,  23,     2626 }, /* VINF_IOM_R3_MMIO_COMMIT_WRITE */
    { 0x017070,  16, 0x00c0cd,  30,     2712 }, /* VINF_VMM_CALL_TRACER */
    { 0x01740f,  16, 0x0134cb,  21,     2714 }, /* VINF_VMM_UNKNOWN_RING3_CALL */
    { 0x01b0fc,   9, 0x0107dd,  24,     2824 }, /* VINF_PDM_ALREADY_LOADED */
    { 0x00fdfb,  25, 0x00484c,  50,     2846 }, /* VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x00e065,  27, 0x01661e,  17,     2898 }, /* VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS */
    { 0x0129cf,  21, 0x009f5e,  35,     2901 }, /* VINF_HGCM_CLIENT_REJECTED */
    { 0x014a8e,  19, 0x006f0f,  42,     2903 }, /* VINF_HGCM_ASYNC_EXECUTE */
    { 0x019e01,  12, 0x013f21,  20,     2906 }, /* VINF_HGCM_SAVE_STATE */
    { 0x0143ce,  19, 0x00e04a,  27,     3209 }, /* VINF_VD_ASYNC_IO_FINISHED */
    { 0x015b05,  18, 0x003535,  56,     3283 }, /* VINF_VD_NEW_ZEROED_BLOCK */
    { 0x011688,  23, 0x00c995,  29,     3501 }, /* VINF_VGA_RESIZE_IN_PROGRESS */
    { 0x00fbbc,  25, 0x00141a,  70,     3746 }, /* VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x00c235,  30, 0x00d647,  28,     3827 }, /* VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED */
    { 0x019616,  13, 0x00b892,  31,     3901 }, /* VINF_GVM_NOT_BLOCKED */
    { 0x0171c0,  16, 0x007035,  42,     3902 }, /* VINF_GVM_NOT_BUSY_IN_GC */
    { 0x019a1d,  12, 0x004112,  52,     3903 }, /* VINF_GVM_YIELDED */
    { 0x01b471,   8, 0x00dc2f,  28,     4033 }, /* VINF_VMX_VMEXIT */
    { 0x014d73,  19, 0x002a1f,  59,     4035 }, /* VINF_VMX_INTERCEPT_NOT_ACTIVE */
    { 0x014aed,  19, 0x000b12,  82,     4036 }, /* VINF_VMX_MODIFIES_BEHAVIOR */
    { 0x01461b,  19, 0x0031a8,  57,     4037 }, /* VINF_VMX_VMLAUNCH_VMRESUME */
    { 0x01a100,  11, 0x00aa29,  33,     4067 }, /* VINF_SVM_VMEXIT */
    { 0x01aa1e,  10, 0x001ac1,  66,     4068 }, /* VINF_SVM_VMRUN */
    { 0x011bf2,  22, 0x002bf7,  59,     4069 }, /* VINF_SVM_INTERCEPT_NOT_ACTIVE */
    { 0x0170a0,  16, 0x004d90,  49,     4117 }, /* VINF_HM_DOUBLE_FAULT */
    { 0x016bf0,  16, 0x00843a,  39,     4118 }, /* VINF_HM_PENDING_XCPT */
    { 0x012d16,  21, 0x0158c5,  18,     4400 }, /* VINF_PARAV_SWITCH_TO_HOST */
    { 0x016662,  17, 0x00403f,  53,     4500 }, /* VINF_VHWA_CMD_PENDING */
    { 0x016442,  17, 0x002bbc,  59,     4800 }, /* VINF_AIO_TASK_PENDING */
    { 0x016332,  17, 0x00057c,  97,     5150 }, /* VINF_PCI_MAPPING_DONE */
    { 0x01859c,  14, 0x001108,  72,     5305 }, /* VINF_IEM_SELECTOR_NOT_OK */
    { 0x0156f1,  18, 0x004146,  52,     5306 }, /* VINF_IEM_YIELD_PENDING_FF */
    { 0x0166d9,  14, 0x003d8d,  54,     5310 }, /* VINF_IEM_REEXEC_BREAK */
    { 0x0166d9,  17, 0x003fd5,  53,     5311 }, /* VINF_IEM_REEXEC_BREAK_FF */
    { 0x00efbf,  26, 0x000dda,  76,     5312 }, /* VINF_IEM_REEXEC_FINISH_WITH_FLAGS */
    { 0x0195ae,  13, 0x007131,  42,     5313 }, /* VINF_IEM_REEXEC_JUMP */
    { 0x01519b,  18, 0x008cb3,  37,     5319 }, /* VINF_IEM_RECOMPILE_END_TB */
    { 0x0192a2,  13, 0x012524,  22,     5401 }, /* VWRN_DBGC_CMD_PENDING */
    { 0x018f14,  13, 0x011460,  23,     5402 }, /* VWRN_DBGC_ALREADY_REGISTERED */
    { 0x0192c9,  13, 0x018660,  14,     5406 }, /* VINF_DBGC_BP_NO_COMMAND */
    { 0x019cb1,  12, 0x01065d,  24,     5699 }, /* VINF_SUP_DRIVERLESS */
    { 0x00dff9,  27, 0x007dca,  40,     6220 }, /* VWRN_GSTCTL_OBJECTSTATE_CHANGED */
    { 0x0165da,  17, 0x0074c3,  41,     6316 }, /* VINF_GIM_R3_HYPERCALL */
    { 0x00ffa4,  25, 0x0038e6,  55,     6317 }, /* VINF_GIM_HYPERCALL_CONTINUING */
    { 0x00f403,  26, 0x011307,  23,     6605 }, /* VINF_AUDIO_MORE_DATA_AVAILABLE */
    { 0x00bda8,  31, 0x000296, 121,     6609 }, /* VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED */
    { 0x019d29,  12, 0x00de27,  28,     6810 }, /* VINF_NEM_FLUSH_TLB */
    { 0x01089d,  24, 0x00b19b,  32,     6906 }, /* VINF_RECORDING_LIMIT_REACHED */
    { 0x013df6,  20, 0x006237,  44,     6907 }, /* VINF_RECORDING_THROTTLED */
    { 0x0142e1,  20, 0x0164a8,  17,     6908 }, /* VWRN_RECORDING_ENCODING_SKIPPED */
    { 0x017190,  16, 0x001600,  69,     7200 }, /* VINF_PDM_PCI_DO_DEFAULT */
    { 0x00d52f,  28, 0x00321a,  57,     7311 }, /* VINF_IOMMU_ADDR_TRANSLATION_DISABLED */
    { 0x010b3d,  12, 0x00200e,  63,     7600 }, /* VINF_GCM_HANDLED */
    { 0x010b3d,  24, 0x00391d,  55,     7601 }, /* VINF_GCM_HANDLED_ADVANCE_RIP */
    { 0x0191d2,  13, 0x004651,  51,    22301 }, /* VINF_LOG_DISABLED */
    { 0x019bc1,  12, 0x016992,  17,    22302 }, /* VINF_LOG_NO_LOGGER */
    { 0x01691b,  17, 0x016255,  17,    22401 }, /* VINF_BUFFER_UNDERFLOW */
    { 0x014e7d,  19, 0x008a31,  38,    22405 }, /* VINF_ACCOUNT_RESTRICTED */
    { 0x00bd4b,  31, 0x005dd2,  45,    22406 }, /* VWRN_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x01b1b9,   8, 0x01a1fd,  11,    22409 }, /* VWRN_WRONG_TYPE */
    { 0x012314,  22, 0x0008b9,  88,    22424 }, /* VINF_THREAD_IS_TERMINATING */
    { 0x016fc0,  16, 0x00e3c5,  27,    22426 }, /* VWRN_FLOAT_UNDERFLOW */
    { 0x0181e4,  15, 0x00f0a9,  26,    22427 }, /* VWRN_FLOAT_OVERFLOW */
    { 0x018ac0,  14, 0x0168c6,  17,    22428 }, /* VINF_REBOOT_NEEDED */
    { 0x01524f,  18, 0x001d0c,  65,    22501 }, /* VINF_SYS_MAY_POWER_OFF */
    { 0x01a23f,  11, 0x00e3aa,  27,    22821 }, /* VINF_ASN1_MORE_DATA */
    { 0x01a7f8,  10, 0x00069c,  91,    22822 }, /* VINF_ASN1_NOT_ENCODED */
    { 0x01ae3f,   9, 0x003088,  58,    22900 }, /* VINF_LDRVI_NOT_SIGNED */
    { 0x00fe5f,  25, 0x00b41b,  32,    23109 }, /* VINF_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x014b13,  19, 0x01739f,  16,    23814 }, /* VINF_CR_KEY_WAS_DECRYPTED */
    { 0x019657,  13, 0x015acf,  18,    24202 }, /* VINF_CR_DIGEST_DEPRECATED */
    { 0x018890,  14, 0x0147a9,  19,    24203 }, /* VINF_CR_DIGEST_COMPROMISED */
    { 0x011643,  23, 0x00dd47,  28,    24204 }, /* VINF_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x010b85,  24, 0x004216,  52,    25007 }, /* VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x00e7fd,  27, 0x017b72,  15,    25704 }, /* VWRN_REST_UNABLE_TO_DECODE_DATE */
};

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStatusMsgStrTab[] =
{
/* 0x00000 = "Hit a possible assertion in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','p','o','s','s','i','b','l','e',' ','a','s','s','e','r','t','i','o','n',' ','\x0f','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','t','h','i','s',' ','\x0a','\x02','d','e','b','u','g','g','e','r',',',' ','\x99','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x0008e = "Process Verification Failure: Image mapping is bogus as the first region has different AllocationBase and BaseAddress values, indicating that a section was unmapped or otherwise tampered with." */
    '\x1e','\x0d','\x12','I','m','a','g','e',' ','m','a','p','p','i','n','g',' ','\x0b','b','o','g','u','s',' ','a','s',' ','\x02','f','i','r','s','t',' ','r','e','g','i','o','n',' ','\x7b','d','i','f','f','e','r','e','n','t',' ','A','l','l','o','c','a','t','i','o','n','B','a','s','e',' ','\x99','B','a','s','e','A','d','d','r','e','s','s',' ','v','a','l','u','e','s',',',' ','i','n','d','i','c','a','t','i','n','g',' ','\xac','a',' ','\xda','\x11','u','n','m','a','p','p','e','d',' ','\xa9','o','t','h','e','r','w','i','s','e',' ','t','a','m','p','e','r','e','d',' ','w','i','t','h','.',
/* 0x00118 = "Returned by handler registration, modification and deregistration when the shadow PTs could be updated because the guest page aliased or/and mapped by multiple PTs." */
    'R','e','t','u','r','n','e','d',' ','\xdf','h','a','n','d','l','e','r',' ','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x99','d','e','r','e','g','i','s','t','r','a','t','i','o','n',' ','w','h','e','n',' ','\x02','s','h','a','d','o','w',' ','P','T','s',' ','c','o','u','l','d',' ','\xa8','u','p','d','a','t','e','d',' ','\x40','\x02','\xbb','\xcb','a','l','i','a','s','e','d',' ','o','r','/','a','n','d',' ','m','a','p','p','e','d',' ','\xdf','m','u','l','t','i','p','l','e',' ','P','T','s','.',
/* 0x0019d = "Process Purification Failure: NtAllocateVirtualMemory failed to get us suitable replacement memory for a chunk of executable memory that shouldn\'t be present in our process." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','A','l','l','o','c','a','t','e','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x98','\x0a','g','e','t',' ','u','s',' ','s','u','i','t','a','b','l','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','\x85','\x10','a',' ','c','h','u','n','k',' ','\x15','e','x','e','c','u','t','a','b','l','e',' ','\x85','\xac','s','h','o','u','l','d','n','\'','t',' ','\xa8','p','r','e','s','e','n','t',' ','\x0f','o','u','r',' ','p','r','o','c','e','s','s','.',
/* 0x0021a = "Hit a breakpoint in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','\xbf','\x0f','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','t','h','i','s',' ','\x0a','\x02','d','e','b','u','g','g','e','r',',',' ','\x99','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x00296 = "Special PDMIHOSTAUDIO::pfnStreamCreate return value for triggering calling of PDMIHOSTAUDIO::pfnStreamInitAsync on a worker thread." */
    'S','p','e','c','i','a','l',' ','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','C','r','e','a','t','e',' ','r','e','t','u','r','n',' ','\xfa','\x10','t','r','i','g','g','e','r','i','n','g',' ','c','a','l','l','i','n','g',' ','\x15','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','I','n','i','t','A','s','y','n','c',' ','o','n',' ','a',' ','w','o','r','k','e','r',' ','t','h','r','e','a','d','.',
/* 0x0030f = "An attempt on detaching a driver without anyone actually being attached, or performing any other operation on an attached driver." */
    'A','n',' ','a','t','t','e','m','p','t',' ','o','n',' ','d','e','t','a','c','h','i','n','g',' ','a',' ','\xc5','w','i','t','h','o','u','t',' ','a','n','y','o','n','e',' ','a','c','t','u','a','l','l','y',' ','b','e','i','n','g',' ','a','t','t','a','c','h','e','d',',',' ','\xa9','p','e','r','f','o','r','m','i','n','g',' ','a','n','y',' ','o','t','h','e','r',' ','\x96','o','n',' ','\x87','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x0037d = "Process Purification Failure: Both NtUnmapViewOfSetion and NtProtectVirtualMemory failed to get rid of or passify an non-image executable mapping." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','B','o','t','h',' ','N','t','U','n','m','a','p','V','i','e','w','O','f','S','e','t','i','o','n',' ','\x99','N','t','P','r','o','t','e','c','t','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x98','\x0a','g','e','t',' ','r','i','d',' ','\x15','\xa9','p','a','s','s','i','f','y',' ','\x87','n','o','n','-','\x25','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','i','n','g','.',
/* 0x003ea = "Process does not have the trusted code base (TCB) privilege needed for user authentication or/and process creation as a given user." */
    '\x1e','\xb2','\x08','h','a','v','e',' ','\x02','t','r','u','s','t','e','d',' ','c','o','d','e',' ','b','a','s','e',' ','(','T','C','B',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','u','s','e','r',' ','a','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','o','r','/','a','n','d',' ','\x92','c','r','e','a','t','i','o','n',' ','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00452 = "Indicating that the VM has executed a halt instruction and that the emulation thread should wait for an interrupt before resuming execution." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','\x7b','e','x','e','c','u','t','e','d',' ','a',' ','h','a','l','t',' ','\xd9','\x99','\xac','\x02','e','m','u','l','a','t','i','o','n',' ','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','w','a','i','t',' ','\x10','\x87','i','n','t','e','r','r','u','p','t',' ','b','e','f','o','r','e',' ','r','e','s','u','m','i','n','g',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x004b9 = "The reservation or reservation update was declined - too many VMs, too little memory, and/or too low GMM configuration." */
    '\x03','r','e','s','e','r','v','a','t','i','o','n',' ','\xa9','r','e','s','e','r','v','a','t','i','o','n',' ','u','p','d','a','t','e',' ','\x11','d','e','c','l','i','n','e','d',' ','-',' ','\xa0','\xb4','V','M','s',',',' ','\xa0','l','i','t','t','l','e',' ','m','e','m','o','r','y',',',' ','a','n','d','/','o','r',' ','\xa0','l','o','w',' ','G','M','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0051b = "The VM process was denied access to vboxdrv because someone have managed to open the process or its main thread with too broad access rights." */
    '\x03','\xcc',' ','\x92','\x11','d','e','n','i','e','d',' ','a','c','c','e','s','s',' ','\x0a','v','b','o','x','d','r','v',' ','\x40','s','o','m','e','o','n','e',' ','h','a','v','e',' ','m','a','n','a','g','e','d',' ','\x0a','o','p','e','n',' ','\x02','\x92','\xa9','i','t','s',' ','m','a','i','n',' ','t','h','r','e','a','d',' ','\x80','\xa0','b','r','o','a','d',' ','a','c','c','e','s','s',' ','r','i','g','h','t','s','.',
/* 0x0057c = "Special return code from a PCI I/O region mapping handler that tells the BUS that it has done the mapping already." */
    'S','p','e','c','i','a','l',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','f','r','o','m',' ','a',' ','P','C','I',' ','I','/','O',' ','r','e','g','i','o','n',' ','m','a','p','p','i','n','g',' ','h','a','n','d','l','e','r',' ','\xac','t','e','l','l','s',' ','\x02','B','U','S',' ','\xac','i','t',' ','\x7b','d','o','n','e',' ','\x02','m','a','p','p','i','n','g',' ','a','l','r','e','a','d','y','.',
/* 0x005dd = "Unable to translate all the variables in the default environment due to codeset issues (LANG / LC_ALL / LC_CTYPE)." */
    '\xde','\x0a','t','r','a','n','s','l','a','t','e',' ','a','l','l',' ','\x02','v','a','r','i','a','b','l','e','s',' ','\x0f','\x02','d','e','f','a','u','l','t',' ','e','n','v','i','r','o','n','m','e','n','t',' ','d','u','e',' ','\x0a','c','o','d','e','s','e','t',' ','i','s','s','u','e','s',' ','(','L','A','N','G',' ','/',' ','L','C','_','A','L','L',' ','/',' ','L','C','_','C','T','Y','P','E',')','.',
/* 0x0063d = "The image is required to be signed with the same certificate as the rest of VirtualBox or one of the special trusted (Oracle) certificates." */
    '\x03','\x25','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','\xa8','s','i','g','n','e','d',' ','\x80','\x02','s','a','m','e',' ','\x9e','a','s',' ','\x02','r','e','s','t',' ','\x15','V','i','r','t','u','a','l','B','o','x',' ','\xa9','o','n','e',' ','\x15','\x02','s','p','e','c','i','a','l',' ','t','r','u','s','t','e','d',' ','(','O','r','a','c','l','e',')',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0069c = "RTAsnEncodeWriteHeader return code indicating that nothing was written and the content should be skipped as well." */
    'R','T','A','s','n','E','n','c','o','d','e','W','r','i','t','e','H','e','a','d','e','r',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','i','n','d','i','c','a','t','i','n','g',' ','\xac','n','o','t','h','i','n','g',' ','\x11','w','r','i','t','t','e','n',' ','\x99','\x02','\xed','s','h','o','u','l','d',' ','\xa8','s','k','i','p','p','e','d',' ','a','s',' ','w','e','l','l','.',
/* 0x006f7 = "Returned by a breakpoint callback when guest execution should be suspended and the VM should be dropped into the debugger." */
    'R','e','t','u','r','n','e','d',' ','\xdf','a',' ','\xbf','c','a','l','l','b','a','c','k',' ','w','h','e','n',' ','\xbb','e','x','e','c','u','t','i','o','n',' ','s','h','o','u','l','d',' ','\xa8','s','u','s','p','e','n','d','e','d',' ','\x99','\x02','\xcc',' ','s','h','o','u','l','d',' ','\xa8','d','r','o','p','p','e','d',' ','i','n','t','o',' ','\x02','d','e','b','u','g','g','e','r','.',
/* 0x00752 = "Indicating that we\'ve got an out-of-memory condition and that we need to take the appropriate actions to deal with this." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','w','e','\'','v','e',' ','g','o','t',' ','\x87','o','u','t','-','o','f','-','\x85','c','o','n','d','i','t','i','o','n',' ','\x99','\xac','w','e',' ','n','e','e','d',' ','\x0a','t','a','k','e',' ','\x02','a','p','p','r','o','p','r','i','a','t','e',' ','a','c','t','i','o','n','s',' ','\x0a','d','e','a','l',' ','\x80','t','h','i','s','.',
/* 0x007ac = "Indicating that a breakpoint was hit and that EM should notify the debugger and in the event there is no debugger fail fatally." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','a',' ','\xbf','\x11','h','i','t',' ','\x99','\xac','E','M',' ','s','h','o','u','l','d',' ','n','o','t','i','f','y',' ','\x02','d','e','b','u','g','g','e','r',' ','\x99','\x0f','\x02','e','v','e','n','t',' ','t','h','e','r','e',' ','\x0b','n','o',' ','d','e','b','u','g','g','e','r',' ','f','a','i','l',' ','f','a','t','a','l','l','y','.',
/* 0x00806 = "Process Purification Failure: NtFreeVirtualMemory failed on a chunk of executable memory which shouldn\'t be present in the process." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','F','r','e','e','V','i','r','t','u','a','l','M','e','m','o','r','y',' ','\x98','o','n',' ','a',' ','c','h','u','n','k',' ','\x15','e','x','e','c','u','t','a','b','l','e',' ','\x85','\xeb','s','h','o','u','l','d','n','\'','t',' ','\xa8','p','r','e','s','e','n','t',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x00860 = "A boot catalog extension entry in the import ISO indicates more entries when we reached the end of the boot catalog sector." */
    'A',' ','b','o','o','t',' ','\xe5','e','x','t','e','n','s','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','i','n','d','i','c','a','t','e','s',' ','m','o','r','e',' ','e','n','t','r','i','e','s',' ','w','h','e','n',' ','w','e',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','b','o','o','t',' ','\xe5','s','e','c','t','o','r','.',
/* 0x008b9 = "Returned by RTThreadQueryTerminationStatus to indicate that the thread is (or should be) terminating." */
    'R','e','t','u','r','n','e','d',' ','\xdf','R','T','T','h','r','e','a','d','Q','u','e','r','y','T','e','r','m','i','n','a','t','i','o','n','S','t','a','t','u','s',' ','\x0a','i','n','d','i','c','a','t','e',' ','\xac','\x02','t','h','r','e','a','d',' ','\x0b','(','o','r',' ','s','h','o','u','l','d',' ','b','e',')',' ','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x00911 = "If a Host Interface Networking filehandle was specified it\'s not allowed to have any init or term programs." */
    'I','f',' ','a',' ','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','f','i','l','e','h','a','n','d','l','e',' ','\x11','\x18','i','t','\'','s',' ','\x08','a','l','l','o','w','e','d',' ','\x0a','h','a','v','e',' ','a','n','y',' ','i','n','i','t',' ','\xa9','t','e','r','m',' ','p','r','o','g','r','a','m','s','.',
/* 0x00969 = "A boot catalog entry in the import ISO sets the continuation flag when using NONE as the selection criteria type." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','w','h','e','n',' ','u','s','i','n','g',' ','N','O','N','E',' ','a','s',' ','\x02','s','e','l','e','c','t','i','o','n',' ','c','r','i','t','e','r','i','a',' ','t','y','p','e','.',
/* 0x009c1 = "Returned by callback methods which does not need to be called again because the client does not actually make use of them." */
    'R','e','t','u','r','n','e','d',' ','\xdf','c','a','l','l','b','a','c','k',' ','m','e','t','h','o','d','s',' ','\xeb','\xb2','\x08','n','e','e','d',' ','\x0a','\xa8','c','a','l','l','e','d',' ','a','g','a','i','n',' ','\x40','\x02','c','l','i','e','n','t',' ','\xb2','\x08','a','c','t','u','a','l','l','y',' ','m','a','k','e',' ','u','s','e',' ','\x15','t','h','e','m','.',
/* 0x00a16 = "Indicating that the VM is being turned off and that the EM should exit to the VM awaiting the destruction request." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','\x0b','b','e','i','n','g',' ','t','u','r','n','e','d',' ','o','f','f',' ','\x99','\xac','\x02','E','M',' ','s','h','o','u','l','d',' ','e','x','i','t',' ','\x0a','\x02','\xcc',' ','a','w','a','i','t','i','n','g',' ','\x02','d','e','s','t','r','u','c','t','i','o','n',' ','r','e','q','u','e','s','t','.',
/* 0x00a6b = "The DTB being parsed has no terminating memory reservation block entry before the start of the structs block." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','n','o',' ','t','e','r','m','i','n','a','t','i','n','g',' ','\x85','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','\xc8','b','e','f','o','r','e',' ','\x02','s','t','a','r','t',' ','\x15','\x02','s','t','r','u','c','t','s',' ','b','l','o','c','k','.',
/* 0x00abf = "A number tar header field was encoded using base-256 which this tar implementation currently does not support." */
    'A',' ','\xf9','t','a','r',' ','\xb3','f','i','e','l','d',' ','\x11','e','n','c','o','d','e','d',' ','u','s','i','n','g',' ','b','a','s','e','-','2','5','6',' ','\xeb','t','h','i','s',' ','t','a','r',' ','i','m','p','l','e','m','e','n','t','a','t','i','o','n',' ','c','u','r','r','e','n','t','l','y',' ','\xb2','\x08','s','u','p','p','o','r','t','.',
/* 0x00b12 = "The behavior of the instruction/operation is modified/needs modification in VMX non-root mode." */
    '\x03','b','e','h','a','v','i','o','r',' ','\x15','\x02','i','n','s','t','r','u','c','t','i','o','n','/','o','p','e','r','a','t','i','o','n',' ','\x0b','m','o','d','i','f','i','e','d','/','n','e','e','d','s',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x0f','V','M','X',' ','n','o','n','-','r','o','o','t',' ','m','o','d','e','.',
/* 0x00b64 = "A boot catalog entry in the import ISO sets the continuation flag when we reached the ned of the boot catalog secotr." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','w','h','e','n',' ','w','e',' ','r','e','a','c','h','e','d',' ','\x02','n','e','d',' ','\x15','\x02','b','o','o','t',' ','\xe5','s','e','c','o','t','r','.',
/* 0x00bb4 = "VFS chain only has a single element and it is just a path, need to be treated as a normal file system request." */
    '\x8d',' ','\x9f','o','n','l','y',' ','\x7b','a',' ','s','i','n','g','l','e',' ','\x5c','\x99','i','t',' ','\x0b','j','u','s','t',' ','a',' ','p','a','t','h',',',' ','n','e','e','d',' ','\x0a','\xa8','t','r','e','a','t','e','d',' ','a','s',' ','a',' ','n','o','r','m','a','l',' ','\x1f','s','y','s','t','e','m',' ','r','e','q','u','e','s','t','.',
/* 0x00c04 = "Process does not have the assign primary token (APT) privilege needed for creating process as a given user." */
    '\x1e','\xb2','\x08','h','a','v','e',' ','\x02','a','s','s','i','g','n',' ','p','r','i','m','a','r','y',' ','t','o','k','e','n',' ','(','A','P','T',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','c','r','e','a','t','i','n','g',' ','\x92','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00c54 = "Indicating that the VM should be suspended for debugging because the developer wants to inspect the VM state." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','s','h','o','u','l','d',' ','\xa8','s','u','s','p','e','n','d','e','d',' ','\x10','d','e','b','u','g','g','i','n','g',' ','\x40','\x02','d','e','v','e','l','o','p','e','r',' ','w','a','n','t','s',' ','\x0a','i','n','s','p','e','c','t',' ','\x02','\xcc',' ','s','t','a','t','e','.',
/* 0x00ca4 = "A boot catalog extension entry in the import ISO was either flagged incorrectly in the previous entry or has an invalid header ID." */
    'A',' ','b','o','o','t',' ','\xe5','e','x','t','e','n','s','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x11','e','i','t','h','e','r',' ','f','l','a','g','g','e','d',' ','i','n','c','o','r','r','e','c','t','l','y',' ','\x0f','\x02','p','r','e','v','i','o','u','s',' ','\xc8','\xa9','\x7b','\x87','\x8f','\xb3','I','D','.',
/* 0x00cf2 = "RC is toasted and the VMM should be terminated at once, but no need to panic about it :-)." */
    'R','C',' ','\x0b','t','o','a','s','t','e','d',' ','\x99','\x02','V','M','M',' ','s','h','o','u','l','d',' ','\xa8','t','e','r','m','i','n','a','t','e','d',' ','a','t',' ','o','n','c','e',',',' ','b','u','t',' ','n','o',' ','n','e','e','d',' ','\x0a','p','a','n','i','c',' ','a','b','o','u','t',' ','i','t',' ',':','-',')','.',
/* 0x00d40 = "Physical range crosses dynamic ram chunk boundary; translation to HC ptr not safe." */
    'P','h','y','s','i','c','a','l',' ','r','a','n','g','e',' ','c','r','o','s','s','e','s',' ','d','y','n','a','m','i','c',' ','r','a','m',' ','c','h','u','n','k',' ','b','o','u','n','d','a','r','y',';',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x0a','H','C',' ','p','t','r',' ','\x08','s','a','f','e','.',
/* 0x00d8d = "A field contained an transformation that should only be used when loading old states." */
    'A',' ','f','i','e','l','d',' ','c','o','n','t','a','i','n','e','d',' ','\x87','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','\xac','s','h','o','u','l','d',' ','o','n','l','y',' ','\xa8','u','s','e','d',' ','w','h','e','n',' ','l','o','a','d','i','n','g',' ','o','l','d',' ','s','t','a','t','e','s','.',
/* 0x00dda = "Recompiled execution: Debug related (hidden) EFLAGS are set and needs handling." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','D','e','b','u','g',' ','r','e','l','a','t','e','d',' ','(','h','i','d','d','e','n',')',' ','E','F','L','A','G','S',' ','a','r','e',' ','s','e','t',' ','\x99','n','e','e','d','s',' ','h','a','n','d','l','i','n','g','.',
/* 0x00e26 = "Indicating that the VM has been suspended and that the thread should wait for request telling it what to do next." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','\x7b','\xca','s','u','s','p','e','n','d','e','d',' ','\x99','\xac','\x02','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','w','a','i','t',' ','\x10','\xaa','t','e','l','l','i','n','g',' ','i','t',' ','w','h','a','t',' ','\x0a','d','o',' ','n','e','x','t','.',
/* 0x00e72 = "Process does not have the increase quota (IQ) privilege needed for creating a process as a given user." */
    '\x1e','\xb2','\x08','h','a','v','e',' ','\x02','i','n','c','r','e','a','s','e',' ','q','u','o','t','a',' ','(','I','Q',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x10','c','r','e','a','t','i','n','g',' ','a',' ','\x92','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',
/* 0x00ebd = "The ELF image is \'executable\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x25','\x0b','\'','e','x','e','c','u','t','a','b','l','e','\'',',',' ','\x02','E','L','F',' ','\xd8','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x00f07 = "IOMMU instance cannot call itself (for remapping interrupts or translating addresses)." */
    '\xfc',' ','i','n','s','t','a','n','c','e',' ','\xe0','c','a','l','l',' ','i','t','s','e','l','f',' ','(','f','o','r',' ','r','e','m','a','p','p','i','n','g',' ','i','n','t','e','r','r','u','p','t','s',' ','\xa9','t','r','a','n','s','l','a','t','i','n','g',' ','a','d','d','r','e','s','s','e','s',')','.',
/* 0x00f51 = "CPUMR3DisasmInstrCPU unexpectedly failed to determine the hidden parts of the CS register." */
    'C','P','U','M','R','3','D','i','s','a','s','m','I','n','s','t','r','C','P','U',' ','u','n','e','x','p','e','c','t','e','d','l','y',' ','\x98','\x0a','d','e','t','e','r','m','i','n','e',' ','\x02','h','i','d','d','e','n',' ','p','a','r','t','s',' ','\x15','\x02','C','S',' ','r','e','g','i','s','t','e','r','.',
/* 0x00f9b = "Process Verification Failure: Expected the process and exe to have forced integrity checking enabled (verifying signatures)." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x99','e','x','e',' ','\x0a','h','a','v','e',' ','f','o','r','c','e','d',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','i','n','g',' ','e','n','a','b','l','e','d',' ','(','v','e','r','i','f','y','i','n','g',' ','s','i','g','n','a','t','u','r','e','s',')','.',
/* 0x00fe5 = "Stub process thread not found during revalidation upon vboxdrv opening by the VM process." */
    'S','t','u','b',' ','\x92','t','h','r','e','a','d',' ','\x08','f','o','u','n','d',' ','d','u','r','i','n','g',' ','r','e','v','a','l','i','d','a','t','i','o','n',' ','u','p','o','n',' ','v','b','o','x','d','r','v',' ','o','p','e','n','i','n','g',' ','\xdf','\x02','\xcc',' ','p','r','o','c','e','s','s','.',
/* 0x0102e = "The port being read was not present(/unused) and IOM shall return ~0 according to size." */
    '\x03','p','o','r','t',' ','b','e','i','n','g',' ','r','e','a','d',' ','\x11','\x08','p','r','e','s','e','n','t','(','/','u','n','u','s','e','d',')',' ','\x99','I','O','M',' ','s','h','a','l','l',' ','r','e','t','u','r','n',' ','~','0',' ','a','c','c','o','r','d','i','n','g',' ','\x0a','s','i','z','e','.',
/* 0x01077 = "Encountered unicode code point which is reserved for use as endian indicator (0xffff or 0xfffe)." */
    '\xa5','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xeb','\x0b','r','e','s','e','r','v','e','d',' ','\x10','u','s','e',' ','a','s',' ','e','n','d','i','a','n',' ','i','n','d','i','c','a','t','o','r',' ','(','0','x','f','f','f','f',' ','\xa9','0','x','f','f','f','e',')','.',
/* 0x010c0 = "There is no TLS (thread local storage) available for storing the current thread." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','a','v','a','i','l','a','b','l','e',' ','\x10','s','t','o','r','i','n','g',' ','\x02','c','u','r','r','e','n','t',' ','t','h','r','e','a','d','.',
/* 0x01108 = "Internal status code for indicating that a selector isn\'t valid (LAR, LSL, VERR, VERW)." */
    '\x07','s','t','a','t','u','s',' ','c','o','d','e',' ','\x10','i','n','d','i','c','a','t','i','n','g',' ','\xac','a',' ','s','e','l','e','c','t','o','r',' ','i','s','n','\'','t',' ','v','a','l','i','d',' ','(','L','A','R',',',' ','L','S','L',',',' ','V','E','R','R',',',' ','V','E','R','W',')','.',
/* 0x01150 = "Expected the signed data content to be the object ID of SpcIndirectDataContent, found something else instead." */
    '\xb8','\x02','s','i','g','n','e','d',' ','\x9c','\xed','\x0a','\xa8','\x02','\xa7','I','D',' ','\x15','S','p','c','I','n','d','i','r','e','c','t','D','a','t','a','C','o','n','t','e','n','t',',',' ','f','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','e','l','s','e',' ','i','n','s','t','e','a','d','.',
/* 0x01198 = "VFS chain element only provides a read-only I/O stream, while the chain requires write access." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','o','n','l','y',' ','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x9f','r','e','q','u','i','r','e','s',' ','w','r','i','t','e',' ','a','c','c','e','s','s','.',
/* 0x011e0 = "Process Verification Failure: Symantec Endpoint Protection must be disabled for the VirtualBox VM processes." */
    '\x1e','\x0d','\x12','S','y','m','a','n','t','e','c',' ','E','n','d','p','o','i','n','t',' ','P','r','o','t','e','c','t','i','o','n',' ','m','u','s','t',' ','\xa8','d','i','s','a','b','l','e','d',' ','\x10','\x02','V','i','r','t','u','a','l','B','o','x',' ','\xcc',' ','p','r','o','c','e','s','s','e','s','.',
/* 0x01228 = "Indicating success single stepping and that EM should report that event to the debugger." */
    'I','n','d','i','c','a','t','i','n','g',' ','s','u','c','c','e','s','s',' ','s','i','n','g','l','e',' ','s','t','e','p','p','i','n','g',' ','\x99','\xac','E','M',' ','s','h','o','u','l','d',' ','r','e','p','o','r','t',' ','\xac','e','v','e','n','t',' ','\x0a','\x02','d','e','b','u','g','g','e','r','.',
/* 0x01270 = "WinVerifyTrust failed with an unexpected status code when using the catalog-file approach." */
    'W','i','n','V','e','r','i','f','y','T','r','u','s','t',' ','\x98','\x80','\x87','u','n','e','x','p','e','c','t','e','d',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','w','h','e','n',' ','u','s','i','n','g',' ','\x02','c','a','t','a','l','o','g','-','\x1f','a','p','p','r','o','a','c','h','.',
/* 0x012b7 = "The order of elements in the XAR file does not lend it self to expansion from via an I/O stream." */
    '\x03','o','r','d','e','r',' ','\x15','e','l','e','m','e','n','t','s',' ','\x0f','\x02','X','A','R',' ','\x1f','\xb2','\x08','l','e','n','d',' ','i','t',' ','s','e','l','f',' ','\x0a','e','x','p','a','n','s','i','o','n',' ','f','r','o','m',' ','v','i','a',' ','\x87','I','/','O',' ','s','t','r','e','a','m','.',
/* 0x012fe = "The ELF image is \'dynamic\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x25','\x0b','\'','d','y','n','a','m','i','c','\'',',',' ','\x02','E','L','F',' ','\xd8','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x01345 = "The key was marked as encrypted by no DEK-Info field with the encryption algortihms was found." */
    '\x03','k','e','y',' ','\x11','m','a','r','k','e','d',' ','a','s',' ','e','n','c','r','y','p','t','e','d',' ','\xdf','n','o',' ','D','E','K','-','I','n','f','o',' ','f','i','e','l','d',' ','\x80','\x02','e','n','c','r','y','p','t','i','o','n',' ','a','l','g','o','r','t','i','h','m','s',' ','\x11','\x88',
/* 0x0138c = "SMAP enabled, but the AC flag was found to be clear - check the kernel log for details." */
    'S','M','A','P',' ','e','n','a','b','l','e','d',',',' ','b','u','t',' ','\x02','A','C',' ','f','l','a','g',' ','\x11','f','o','u','n','d',' ','\x0a','\xa8','c','l','e','a','r',' ','-',' ','c','h','e','c','k',' ','\x02','k','e','r','n','e','l',' ','l','o','g',' ','\x10','d','e','t','a','i','l','s','.',
/* 0x013d3 = "Patch installation refused (patch too complex or unsupported instructions )." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','a','t','i','o','n',' ','r','e','f','u','s','e','d',' ','(','p','a','t','c','h',' ','\xa0','c','o','m','p','l','e','x',' ','\xa9','u','n','s','u','p','p','o','r','t','e','d',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ',')','.',
/* 0x0141a = "Failed to measure the TSC delta between two CPUs, continue without any TSC-delta." */
    '\x8b','\x0a','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s',',',' ','c','o','n','t','i','n','u','e',' ','w','i','t','h','o','u','t',' ','a','n','y',' ','T','S','C','-','d','e','l','t','a','.',
/* 0x01460 = "Error opening the stub process thread for revalidation when vboxdrv is opened by the VM process." */
    '\xc0','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x92','t','h','r','e','a','d',' ','\x10','r','e','v','a','l','i','d','a','t','i','o','n',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xdf','\x02','\xcc',' ','p','r','o','c','e','s','s','.',
/* 0x014a6 = "Reserved for future status code that we wish to OR with VERR_VMX_INVALID_VMCS_PTR and VERR_VMX_INVALID_VMCS_FIELD." */
    'R','e','s','e','r','v','e','d',' ','\x10','f','u','t','u','r','e',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\xac','w','e',' ','w','i','s','h',' ','\x0a','O','R',' ','\x80','\x01','\xe1','\x05','V','M','C','S','_','P','T','R',' ','\x99','\x01','\xe1','\x05','V','M','C','S','_','F','I','E','L','D','.',
/* 0x014ec = "The loaded XSAVE component mask is not compatible with the host CPU or/and VM config." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x0b','\x08','c','o','m','p','a','t','i','b','l','e',' ','\x80','\x02','h','o','s','t',' ','C','P','U',' ','o','r','/','a','n','d',' ','\xcc',' ','c','o','n','f','i','g','.',
/* 0x01531 = "The network already exists with a different security profile (restricted / public)." */
    '\x03','n','e','t','w','o','r','k',' ','\x7f','e','x','i','s','t','s',' ','\x80','a',' ','d','i','f','f','e','r','e','n','t',' ','s','e','c','u','r','i','t','y',' ','p','r','o','f','i','l','e',' ','(','r','e','s','t','r','i','c','t','e','d',' ','/',' ','p','u','b','l','i','c',')','.',
/* 0x01576 = "The alignment is not really supported, however we got lucky with this allocation." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x0b','\x08','r','e','a','l','l','y',' ','s','u','p','p','o','r','t','e','d',',',' ','h','o','w','e','v','e','r',' ','w','e',' ','g','o','t',' ','l','u','c','k','y',' ','\x80','t','h','i','s',' ','a','l','l','o','c','a','t','i','o','n','.',
/* 0x015bb = "No RTC device instance is registered with the current VM and thus the RTC or CMOS operation cannot be performed." */
    '\xe6','R','T','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcc',' ','\x99','t','h','u','s',' ','\x02','R','T','C',' ','\xa9','C','M','O','S',' ','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d','.',
/* 0x01600 = "Returned by PCI config space callbacks to indicate taking default action." */
    'R','e','t','u','r','n','e','d',' ','\xdf','P','C','I',' ','c','o','n','f','i','g',' ','s','p','a','c','e',' ','c','a','l','l','b','a','c','k','s',' ','\x0a','i','n','d','i','c','a','t','e',' ','t','a','k','i','n','g',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x01645 = "The signature algorithm in the to-be-signed certificate part does not match the one associated with the signature." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\xd3','\x0f','\x02','t','o','-','b','e','-','s','i','g','n','e','d',' ','\x9e','p','a','r','t',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0168a = "The boot catalog in the import ISO is larger than a sector or it is missing the final section header entry." */
    '\x03','b','o','o','t',' ','\xe5','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x0b','l','a','r','g','e','r',' ','t','h','a','n',' ','a',' ','s','e','c','t','o','r',' ','\xa9','i','t',' ','\x0b','m','i','s','s','i','n','g',' ','\x02','f','i','n','a','l',' ','\xda','\xb3','e','n','t','r','y','.',
/* 0x016ce = "The I/O queue doesn't contain any prepared requests to commit or wait for completion." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\xc7','c','o','n','t','a','i','n',' ','a','n','y',' ','p','r','e','p','a','r','e','d',' ','r','e','q','u','e','s','t','s',' ','\x0a','c','o','m','m','i','t',' ','\xa9','w','a','i','t',' ','\x10','c','o','m','p','l','e','t','i','o','n','.',
/* 0x01712 = "The request could not be canceled or prepared for another transfer because it is still in progress." */
    '\x03','\xaa','c','o','u','l','d',' ','\x08','\xa8','c','a','n','c','e','l','e','d',' ','\xa9','p','r','e','p','a','r','e','d',' ','\x10','a','n','o','t','h','e','r',' ','t','r','a','n','s','f','e','r',' ','\x40','i','t',' ','\x0b','s','t','i','l','l',' ','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x01756 = "Status code, typically given as a parameter, that isn\'t supposed to be used." */
    'S','t','a','t','u','s',' ','c','o','d','e',',',' ','t','y','p','i','c','a','l','l','y',' ','g','i','v','e','n',' ','a','s',' ','a',' ','p','a','r','a','m','e','t','e','r',',',' ','\xac','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x0a','\xa8','u','s','e','d','.',
/* 0x0179a = "Signed data verification failed because of missing (or duplicate) authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd6','a','t','t','r','i','b','u','t','e','.',
/* 0x017de = "Signed data verification failed because of missing (or duplicate) authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf1','a','t','t','r','i','b','u','t','e','.',
/* 0x01822 = "The shared module clashed address wise with a previously registered module." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','a','d','d','r','e','s','s',' ','w','i','s','e',' ','\x80','a',' ','p','r','e','v','i','o','u','s','l','y',' ','r','e','g','i','s','t','e','r','e','d',' ','m','o','d','u','l','e','.',
/* 0x01866 = "Remapping denied for the interrupt (might have caused a PCI target abort)." */
    'R','e','m','a','p','p','i','n','g',' ','d','e','n','i','e','d',' ','\x10','\x02','i','n','t','e','r','r','u','p','t',' ','(','m','i','g','h','t',' ','h','a','v','e',' ','c','a','u','s','e','d',' ','a',' ','P','C','I',' ','t','a','r','g','e','t',' ','a','b','o','r','t',')','.',
/* 0x018aa = "Import ISO contains a multi-extent directory record that differs significantly from first record." */
    '\xc3','\xc1',' ','\x8a','a',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x26','r','e','c','o','r','d',' ','\xac','d','i','f','f','e','r','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','f','r','o','m',' ','f','i','r','s','t',' ','r','e','c','o','r','d','.',
/* 0x018ee = "VFS chain element takes a directory (dir), file system stream (fss), or file system (vfs) object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x26','(','d','i','r',')',',',' ','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',',',' ','\xa9','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x01931 = "Halt the current I/O context until further notification from the backend." */
    'H','a','l','t',' ','\x02','c','u','r','r','e','n','t',' ','I','/','O',' ','c','o','n','t','e','x','t',' ','u','n','t','i','l',' ','f','u','r','t','h','e','r',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','f','r','o','m',' ','\x02','b','a','c','k','e','n','d','.',
/* 0x01974 = "The I/O context couldn\'t be destroyed because there are still pending requests." */
    '\x03','I','/','O',' ','c','o','n','t','e','x','t',' ','c','o','u','l','d','n','\'','t',' ','\xa8','d','e','s','t','r','o','y','e','d',' ','\x40','t','h','e','r','e',' ','a','r','e',' ','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','r','e','q','u','e','s','t','s','.',
/* 0x019b7 = "The CPUID instruction returns different information when loading than when saved." */
    '\x03','C','P','U','I','D',' ','\xd9','r','e','t','u','r','n','s',' ','d','i','f','f','e','r','e','n','t',' ','i','n','f','o','r','m','a','t','i','o','n',' ','w','h','e','n',' ','l','o','a','d','i','n','g',' ','t','h','a','n',' ','w','h','e','n',' ','s','a','v','e','d','.',
/* 0x019fa = "VFS chain element preceding the final path needs to be a directory, file system or file system stream." */
    '\x8d',' ','\x9f','\x5c','p','r','e','c','e','d','i','n','g',' ','\x02','f','i','n','a','l',' ','\xd0','n','e','e','d','s',' ','\x0a','\xa8','a',' ','d','i','r','e','c','t','o','r','y',',',' ','\x1f','s','y','s','t','e','m',' ','\xa9','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m','.',
/* 0x01a3d = "Stub process not found so it cannot be revalidated when vboxdrv is opened by the VM process." */
    'S','t','u','b',' ','\x92','\x08','f','o','u','n','d',' ','s','o',' ','i','t',' ','\xe0','\xa8','r','e','v','a','l','i','d','a','t','e','d',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xdf','\x02','\xcc',' ','p','r','o','c','e','s','s','.',
/* 0x01a7f = "Import ISO contains a non-final multi-extent directory record with a size that isn\'t block aligned." */
    '\xc3','\xc1',' ','\x8a','a',' ','n','o','n','-','f','i','n','a','l',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x26','r','e','c','o','r','d',' ','\x80','a',' ','s','i','z','e',' ','\xac','i','s','n','\'','t',' ','b','l','o','c','k',' ','a','l','i','g','n','e','d','.',
/* 0x01ac1 = "VMRUN emulation succeeded, ready to immediately enter the nested-guest." */
    'V','M','R','U','N',' ','e','m','u','l','a','t','i','o','n',' ','s','u','c','c','e','e','d','e','d',',',' ','r','e','a','d','y',' ','\x0a','i','m','m','e','d','i','a','t','e','l','y',' ','e','n','t','e','r',' ','\x02','n','e','s','t','e','d','-','g','u','e','s','t','.',
/* 0x01b03 = "There shall be exactly one digest algorithm to go with the single SingerInfo entry required by SPC." */
    'T','h','e','r','e',' ','s','h','a','l','l',' ','\xa8','e','x','a','c','t','l','y',' ','o','n','e',' ','\xd6','\xd3','\x0a','g','o',' ','\x80','\x02','s','i','n','g','l','e',' ','S','i','n','g','e','r','I','n','f','o',' ','\xc8','r','e','q','u','i','r','e','d',' ','\xdf','S','P','C','.',
/* 0x01b45 = "There are not enough events available on the host to create the I/O context." */
    'T','h','e','r','e',' ','a','r','e',' ','\x08','e','n','o','u','g','h',' ','e','v','e','n','t','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','\x02','h','o','s','t',' ','\x0a','c','r','e','a','t','e',' ','\x02','I','/','O',' ','c','o','n','t','e','x','t','.',
/* 0x01b86 = "Conflict between the core memory and the intermediate paging context, try again." */
    'C','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','c','o','r','e',' ','\x85','\x99','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',',',' ','t','r','y',' ','a','g','a','i','n','.',
/* 0x01bc7 = "Failed to set the TLS (thread local storage) entry which points to our thread structure." */
    '\x8b','\x0a','s','e','t',' ','\x02','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','\xc8','\xeb','p','o','i','n','t','s',' ','\x0a','o','u','r',' ','t','h','r','e','a','d',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x01c08 = "Invalid/unsupported nested hardware virtualization configuration." */
    'I','n','v','a','l','i','d','/','u','n','s','u','p','p','o','r','t','e','d',' ','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x01c49 = "Too many write or write/read recursions on read/write critical section." */
    'T','o','o',' ','\xb4','w','r','i','t','e',' ','\xa9','w','r','i','t','e','/','r','e','a','d',' ','r','e','c','u','r','s','i','o','n','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x01c8a = "No APIC device instance is registered with the current VM and thus the APIC operation cannot be performed." */
    '\xe6','A','P','I','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcc',' ','\x99','t','h','u','s',' ','\x02','A','P','I','C',' ','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d','.',
/* 0x01ccb = "The PCI device isn\'t configured as a busmaster, physical memory access rejected." */
    '\x03','P','C','I',' ','\xa3','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','a','s',' ','a',' ','b','u','s','m','a','s','t','e','r',',',' ','p','h','y','s','i','c','a','l',' ','\x85','a','c','c','e','s','s',' ','r','e','j','e','c','t','e','d','.',
/* 0x01d0c = "The halt action was requested, but the OS may actually power off the machine." */
    '\x03','h','a','l','t',' ','a','c','t','i','o','n',' ','\x11','r','e','q','u','e','s','t','e','d',',',' ','b','u','t',' ','\x02','O','S',' ','m','a','y',' ','a','c','t','u','a','l','l','y',' ','p','o','w','e','r',' ','o','f','f',' ','\x02','m','a','c','h','i','n','e','.',
/* 0x01d4d = "The requests couldn\'t be submitted because that would exceed the capacity of the context." */
    '\x03','r','e','q','u','e','s','t','s',' ','c','o','u','l','d','n','\'','t',' ','\xa8','s','u','b','m','i','t','t','e','d',' ','\x40','\xac','w','o','u','l','d',' ','e','x','c','e','e','d',' ','\x02','c','a','p','a','c','i','t','y',' ','\x15','\x02','c','o','n','t','e','x','t','.',
/* 0x01d8e = "The tar termination records was encountered without reaching the end of the input stream." */
    '\x03','t','a','r',' ','t','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d','s',' ','\x11','\xae','w','i','t','h','o','u','t',' ','r','e','a','c','h','i','n','g',' ','\x02','e','n','d',' ','\x15','\x02','i','n','p','u','t',' ','s','t','r','e','a','m','.',
/* 0x01dce = "The file is too big for the current ISO level (4GB+ sized files requires ISO level 3)." */
    '\x03','\x1f','\x0b','\xa0','b','i','g',' ','\x10','\x02','c','u','r','r','e','n','t',' ','\xc1',' ','l','e','v','e','l',' ','(','4','G','B','+',' ','s','i','z','e','d',' ','f','i','l','e','s',' ','r','e','q','u','i','r','e','s',' ','\xc1',' ','l','e','v','e','l',' ','3',')','.',
/* 0x01e0e = "The \'Translation\' attribute in the DrvBlock configuration had an unknown value." */
    '\x03','\'','T','r','a','n','s','l','a','t','i','o','n','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','h','a','d',' ','\x87','u','n','k','n','o','w','n',' ','\xf3',
/* 0x01e4e = "Indicating that the VM has been reset and that scheduling goes back to startup defaults." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','\x7b','\xca','r','e','s','e','t',' ','\x99','\xac','s','c','h','e','d','u','l','i','n','g',' ','g','o','e','s',' ','b','a','c','k',' ','\x0a','s','t','a','r','t','u','p',' ','d','e','f','a','u','l','t','s','.',
/* 0x01e8e = "Got back from vmmR0CallRing3SetJmp with the context hook still enabled." */
    'G','o','t',' ','b','a','c','k',' ','f','r','o','m',' ','v','m','m','R','0','C','a','l','l','R','i','n','g','3','S','e','t','J','m','p',' ','\x80','\x02','c','o','n','t','e','x','t',' ','h','o','o','k',' ','s','t','i','l','l',' ','e','n','a','b','l','e','d','.',
/* 0x01ece = "No DMAC device instance is registered with the current VM and thus the DMA operation cannot be performed." */
    '\xe6','D','M','A','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcc',' ','\x99','t','h','u','s',' ','\x02','D','M','A',' ','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d','.',
/* 0x01f0e = "Attempt to register a RAM range of which parts are already covered by existing RAM ranges." */
    'A','t','t','e','m','p','t',' ','\x0a','\xe9','a',' ','R','A','M',' ','r','a','n','g','e',' ','\x15','\xeb','p','a','r','t','s',' ','a','r','e',' ','\x7f','c','o','v','e','r','e','d',' ','\xdf','e','x','i','s','t','i','n','g',' ','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x01f4e = "The below driver doesn't export a interface required by the drive having attached it." */
    '\x03','b','e','l','o','w',' ','\xc5','\xc7','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xdf','\x02','d','r','i','v','e',' ','h','a','v','i','n','g',' ','a','t','t','a','c','h','e','d',' ','i','t','.',
/* 0x01f8e = "Import ISO has different volume space sizes of primary and supplementary volume descriptors." */
    '\xc3','\xc1',' ','\x7b','d','i','f','f','e','r','e','n','t',' ','\xd1','s','p','a','c','e',' ','s','i','z','e','s',' ','\x15','p','r','i','m','a','r','y',' ','\x99','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x01fce = "The function called requires the caller to be attached as a debugger to the VM." */
    '\x03','f','u','n','c','t','i','o','n',' ','c','a','l','l','e','d',' ','r','e','q','u','i','r','e','s',' ','\x02','c','a','l','l','e','r',' ','\x0a','\xa8','a','t','t','a','c','h','e','d',' ','a','s',' ','a',' ','d','e','b','u','g','g','e','r',' ','\x0a','\x02','V','M','.',
/* 0x0200e = "The intercepted situation was completely handled, continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','s','i','t','u','a','t','i','o','n',' ','\x11','c','o','m','p','l','e','t','e','l','y',' ','h','a','n','d','l','e','d',',',' ','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x0204d = "Error opening the stub process for revalidation when vboxdrv is opened by the VM process." */
    '\xc0','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x92','\x10','r','e','v','a','l','i','d','a','t','i','o','n',' ','w','h','e','n',' ','v','b','o','x','d','r','v',' ','\x0b','o','p','e','n','e','d',' ','\xdf','\x02','\xcc',' ','p','r','o','c','e','s','s','.',
/* 0x0208c = "No PIC device instance is registered with the current VM and thus the PIC operation cannot be performed." */
    '\xe6','P','I','C',' ','\xa3','i','n','s','t','a','n','c','e',' ','\x0b','r','e','g','i','s','t','e','r','e','d',' ','\x80','\x02','c','u','r','r','e','n','t',' ','\xcc',' ','\x99','t','h','u','s',' ','\x02','P','I','C',' ','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d','.',
/* 0x020cb = "Got an out of memory condition trying to allocate a UTF-16 (/UCS-2) string." */
    'G','o','t',' ','\x87','o','u','t',' ','\x15','\x85','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','U','T','F','-','1','6',' ','(','/','U','C','S','-','2',')',' ','s','t','r','i','n','g','.',
/* 0x0210a = "Trying to read a 64-bit guest physical address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x0a','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xbb','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x02149 = "Sensitive input requires the result(s) to be initialized as sensitive." */
    'S','e','n','s','i','t','i','v','e',' ','i','n','p','u','t',' ','r','e','q','u','i','r','e','s',' ','\x02','r','e','s','u','l','t','(','s',')',' ','\x0a','\xa8','i','n','i','t','i','a','l','i','z','e','d',' ','a','s',' ','s','e','n','s','i','t','i','v','e','.',
/* 0x02188 = "A boot catalog extension entry in the import ISO uses undefined flags which will be lost." */
    'A',' ','b','o','o','t',' ','\xe5','e','x','t','e','n','s','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','u','s','e','s',' ','u','n','d','e','f','i','n','e','d',' ','f','l','a','g','s',' ','\xeb','w','i','l','l',' ','\xa8','l','o','s','t','.',
/* 0x021c7 = "CPU was incorrectly left in VMX root mode; incompatible with VirtualBox." */
    'C','P','U',' ','\x11','i','n','c','o','r','r','e','c','t','l','y',' ','l','e','f','t',' ','\x0f','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','\x80','V','i','r','t','u','a','l','B','o','x','.',
/* 0x02206 = "The digest algorithm in the indirect data was not found in the list of digest algorithms in the signed data structure." */
    '\x03','\xd6','\xd3','\x0f','\x02','i','n','d','i','r','e','c','t',' ','\x9c','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','l','i','s','t',' ','\x15','\xd6','a','l','g','o','r','i','t','h','m','s',' ','\x0f','\x02','s','i','g','n','e','d',' ','\x9c','s','t','r','u','c','t','u','r','e','.',
/* 0x02245 = "A timeout occurred while waiting for async IDE operations to finish." */
    'A',' ','t','i','m','e','o','u','t',' ','o','c','c','u','r','r','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g',' ','\x10','a','s','y','n','c',' ','I','D','E',' ','o','p','e','r','a','t','i','o','n','s',' ','\x0a','f','i','n','i','s','h','.',
/* 0x02284 = "Attempt to register an access handler for a physical range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x0a','\xe9','\x87','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','a',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e',' ','\x15','\xeb','a',' ','p','a','r','t',' ','\x11','\x7f','h','a','n','d','l','e','d','.',
/* 0x022c3 = "A number tar header field yielded a value too large for the internal variable of the tar interpreter." */
    'A',' ','\xf9','t','a','r',' ','\xb3','f','i','e','l','d',' ','y','i','e','l','d','e','d',' ','a',' ','\xfa','\xa0','l','a','r','g','e',' ','\x10','\x02','\x17','v','a','r','i','a','b','l','e',' ','\x15','\x02','t','a','r',' ','i','n','t','e','r','p','r','e','t','e','r','.',
/* 0x02301 = "Process Verification Failure: There is more than one known executable mapped into the process." */
    '\x1e','\x0d','\x12','T','h','e','r','e',' ','\x0b','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','k','n','o','w','n',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0233f = "VFS chain element only provides a read-only I/O stream, while the chain read access." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','o','n','l','y',' ','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x9f','r','e','a','d',' ','a','c','c','e','s','s','.',
/* 0x0237d = "A PGM function was called in a mode where it isn\'t supposed to be used." */
    'A',' ','P','G','M',' ','f','u','n','c','t','i','o','n',' ','\x11','c','a','l','l','e','d',' ','\x0f','a',' ','m','o','d','e',' ','w','h','e','r','e',' ','i','t',' ','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x0a','\xa8','u','s','e','d','.',
/* 0x023bb = "The PE loader encountered a lock prefix table, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xd8','\xae','a',' ','l','o','c','k',' ','p','r','e','f','i','x',' ','t','a','b','l','e',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xeb','h','a','s','n','\'','t',' ','\xca','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x023f9 = "Import ISO has different volume set sizes of primary and supplementary volume descriptors." */
    '\xc3','\xc1',' ','\x7b','d','i','f','f','e','r','e','n','t',' ','\xd1','s','e','t',' ','s','i','z','e','s',' ','\x15','p','r','i','m','a','r','y',' ','\x99','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x02437 = "Trying to read a 64-bit guest virtual address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x0a','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xbb','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x02475 = "The combined minor and major device number type is too small to hold the value stored in the tar header." */
    '\x03','c','o','m','b','i','n','e','d',' ','m','i','n','o','r',' ','\x99','m','a','j','o','r',' ','\xa3','\xf9','\xf1','\x0b','\xa0','s','m','a','l','l',' ','\x0a','h','o','l','d',' ','\x02','\xfa','s','t','o','r','e','d',' ','\x0f','\x02','t','a','r',' ','h','e','a','d','e','r','.',
/* 0x024b3 = "Nested ownership requests are not permitted for this semaphore type." */
    'N','e','s','t','e','d',' ','o','w','n','e','r','s','h','i','p',' ','r','e','q','u','e','s','t','s',' ','a','r','e',' ','\x08','p','e','r','m','i','t','t','e','d',' ','\x10','t','h','i','s',' ','s','e','m','a','p','h','o','r','e',' ','t','y','p','e','.',
/* 0x024f1 = "Attempt to register an access handler for a virtual range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x0a','\xe9','\x87','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','a',' ','v','i','r','t','u','a','l',' ','r','a','n','g','e',' ','\x15','\xeb','a',' ','p','a','r','t',' ','\x11','\x7f','h','a','n','d','l','e','d','.',
/* 0x0252f = "The specified R0 or RC I/O port range didn\'t have a corresponding R3 range." */
    '\x03','\x18','R','0',' ','\xa9','R','C',' ','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','d','i','d','n','\'','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',
/* 0x0256c = "A restore routine attempted to load more data then the unit contained." */
    'A',' ','r','e','s','t','o','r','e',' ','r','o','u','t','i','n','e',' ','a','t','t','e','m','p','t','e','d',' ','\x0a','l','o','a','d',' ','m','o','r','e',' ','\x9c','t','h','e','n',' ','\x02','u','n','i','t',' ','c','o','n','t','a','i','n','e','d','.',
/* 0x025a9 = "The table of content XML element (toc) has siblings, we expected it to be an only child or the root element (xar)." */
    '\x03','\xb1','\x15','\xed','X','M','L',' ','\x5c','(','t','o','c',')',' ','\x7b','s','i','b','l','i','n','g','s',',',' ','w','e',' ','\xc9','i','t',' ','\x0a','\xa8','\x87','o','n','l','y',' ','c','h','i','l','d',' ','\xa9','\x02','r','o','o','t',' ','\x5c','(','x','a','r',')','.',
/* 0x025e6 = "A boot catalog entry in the import ISO points to a block after the end of the image input file." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','p','o','i','n','t','s',' ','\x0a','a',' ','b','l','o','c','k',' ','a','f','t','e','r',' ','\x02','e','n','d',' ','\x15','\x02','\x25','i','n','p','u','t',' ','f','i','l','e','.',
/* 0x02623 = "Giving up a live snapshot/teleportation attempt because the state grew to big." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x40','\x02','\xcd','g','r','e','w',' ','\x0a','b','i','g','.',
/* 0x02660 = "The I/O port range specified for removal wasn\'t found or it wasn\'t contiguous." */
    '\x03','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','w','a','s','n','\'','t',' ','f','o','u','n','d',' ','\xa9','i','t',' ','w','a','s','n','\'','t',' ','c','o','n','t','i','g','u','o','u','s','.',
/* 0x0269d = "The digest algorithm of a signer info entry was not found in the list of digest algorithms in the signed data." */
    '\x03','\xd6','\xd3','\x15','a',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','\xc8','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','l','i','s','t',' ','\x15','\xd6','a','l','g','o','r','i','t','h','m','s',' ','\x0f','\x02','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x026da = "Out of memory condition when allocating physical memory (without mapping)." */
    'O','u','t',' ','\x15','\x85','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','p','h','y','s','i','c','a','l',' ','\x85','(','w','i','t','h','o','u','t',' ','m','a','p','p','i','n','g',')','.',
/* 0x02716 = "Trick for resuming EMHistoryExec after a VMCPU_FF_IOM is handled." */
    'T','r','i','c','k',' ','\x10','r','e','s','u','m','i','n','g',' ','E','M','H','i','s','t','o','r','y','E','x','e','c',' ','a','f','t','e','r',' ','a',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0b','h','a','n','d','l','e','d','.',
/* 0x02752 = "Failed to add new mappings because the current mappings are fixed in guest os memory." */
    '\x8b','\x0a','a','d','d',' ','n','e','w',' ','m','a','p','p','i','n','g','s',' ','\x40','\x02','c','u','r','r','e','n','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','f','i','x','e','d',' ','\x0f','\xbb','o','s',' ','m','e','m','o','r','y','.',
/* 0x0278e = "Got into a part of SELM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','S','E','L','M',' ','\xac','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x027ca = "The above driver doesn't export a interface required by a driver being attached to it." */
    '\x03','a','b','o','v','e',' ','\xc5','\xc7','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xdf','a',' ','\xc5','b','e','i','n','g',' ','a','t','t','a','c','h','e','d',' ','\x0a','i','t','.',
/* 0x02806 = "Can\'t finalize the node as the FDT cursor is at the root level already." */
    'C','a','n','\'','t',' ','f','i','n','a','l','i','z','e',' ','\x02','n','o','d','e',' ','a','s',' ','\x02','F','D','T',' ','c','u','r','s','o','r',' ','\x0b','a','t',' ','\x02','r','o','o','t',' ','l','e','v','e','l',' ','a','l','r','e','a','d','y','.',
/* 0x02842 = "The timer was stuck in an unstable state until we grew impatient and returned." */
    '\x03','t','i','m','e','r',' ','\x11','s','t','u','c','k',' ','\x0f','\x87','u','n','s','t','a','b','l','e',' ','\xcd','u','n','t','i','l',' ','w','e',' ','g','r','e','w',' ','i','m','p','a','t','i','e','n','t',' ','\x99','r','e','t','u','r','n','e','d','.',
/* 0x0287e = "Expected the archived and extracted XAR data sizes to be the same for uncompressed data." */
    '\xb8','\x02','a','r','c','h','i','v','e','d',' ','\x99','e','x','t','r','a','c','t','e','d',' ','X','A','R',' ','\x9c','s','i','z','e','s',' ','\x0a','\xa8','\x02','s','a','m','e',' ','\x10','u','n','c','o','m','p','r','e','s','s','e','d',' ','d','a','t','a','.',
/* 0x028ba = "Missing UTF-8 continutation in escaped URI character sequence." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','\x0f','e','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x028f6 = "Got into a part of TRPM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','T','R','P','M',' ','\xac','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02932 = "The status field has not been updated yet as the request is still pending completion." */
    '\x03','s','t','a','t','u','s',' ','f','i','e','l','d',' ','\x7b','\x08','\xca','u','p','d','a','t','e','d',' ','y','e','t',' ','a','s',' ','\x02','\xaa','\x0b','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','c','o','m','p','l','e','t','i','o','n','.',
/* 0x0296e = "Unable to translate one or more of the arguments to the codeset the child process is expected to use." */
    '\xde','\x0a','t','r','a','n','s','l','a','t','e',' ','o','n','e',' ','\xa9','m','o','r','e',' ','\x15','\x02','a','r','g','u','m','e','n','t','s',' ','\x0a','\x02','c','o','d','e','s','e','t',' ','\x02','c','h','i','l','d',' ','\x92','\x0b','\xc9','\x0a','u','s','e','.',
/* 0x029a9 = "Cannot add symbolic link to namespace which isn\'t configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x0a','n','a','m','e','s','p','a','c','e',' ','\xeb','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','\x0a','\xce','i','t','.',
/* 0x029e4 = "The VM was suspended before or while saving, don\'t resume execution." */
    '\x03','\xcc',' ','\x11','s','u','s','p','e','n','d','e','d',' ','b','e','f','o','r','e',' ','\xa9','w','h','i','l','e',' ','s','a','v','i','n','g',',',' ','d','o','n','\'','t',' ','r','e','s','u','m','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x02a1f = "The requested nested-guest VMX intercept is not active or not in nested-guest execution mode." */
    '\x03','\xdd','n','e','s','t','e','d','-','\xbb','V','M','X',' ','i','n','t','e','r','c','e','p','t',' ','\x0b','\x08','a','c','t','i','v','e',' ','\xa9','\x08','\x0f','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x02a5a = "Differencing and parent images can\'t be used together due to UUID." */
    'D','i','f','f','e','r','e','n','c','i','n','g',' ','\x99','p','a','r','e','n','t',' ','i','m','a','g','e','s',' ','c','a','n','\'','t',' ','\xa8','u','s','e','d',' ','t','o','g','e','t','h','e','r',' ','d','u','e',' ','\x0a','U','U','I','D','.',
/* 0x02a95 = "Multiple primary volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','p','r','i','m','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','o','n','e','.',
/* 0x02ad0 = "The driver properties were invalid, and as a consequence construction failed." */
    '\x03','\xc5','p','r','o','p','e','r','t','i','e','s',' ','w','e','r','e',' ','i','n','v','a','l','i','d',',',' ','\x99','a','s',' ','a',' ','c','o','n','s','e','q','u','e','n','c','e',' ','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x7d',
/* 0x02b0b = "Got into a part of PDM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','P','D','M',' ','\xac','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02b46 = "Failed to enable VMXON-in-SMX bit while enabling VT-x through the MSR." */
    '\x8b','\x0a','e','n','a','b','l','e',' ','V','M','X','O','N','-','i','n','-','S','M','X',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x02b81 = "The live snapshot/teleportation operation was aborted because of a guru meditation." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x96','\x11','a','b','o','r','t','e','d',' ','\x40','\x15','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x02bbc = "Async I/O task is pending, a completion handler will be called." */
    'A','s','y','n','c',' ','I','/','O',' ','t','a','s','k',' ','\x0b','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\xa8','c','a','l','l','e','d','.',
/* 0x02bf7 = "The requested nested-guest SVM intercept is not active or not in nested-guest execution mode." */
    '\x03','\xdd','n','e','s','t','e','d','-','\xbb','S','V','M',' ','i','n','t','e','r','c','e','p','t',' ','\x0b','\x08','a','c','t','i','v','e',' ','\xa9','\x08','\x0f','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x02c32 = "Import ISO contains a non-contigiuous multi-extent data, this is currently not supported." */
    '\xc3','\xc1',' ','\x8a','a',' ','n','o','n','-','c','o','n','t','i','g','i','u','o','u','s',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','d','a','t','a',',',' ','t','h','i','s',' ','\x0b','c','u','r','r','e','n','t','l','y',' ','\x08','\xa4',
/* 0x02c6d = "Process Verification Failure: The DllCharacteristics of the process does not match the value in the optional header in the exe file." */
    '\x1e','\x0d','\x12','\x03','D','l','l','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x15','\x02','\x92','\xb2','\x08','m','a','t','c','h',' ','\x02','\xfa','\x0f','\x02','o','p','t','i','o','n','a','l',' ','\xb3','\x0f','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x02ca8 = "Multiple logical volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','o','n','l','y',' ','d','e','a','l',' ','\x80','o','n','e','.',
/* 0x02ce3 = "Giving up a live snapshot attempt because we\'re low on disk space." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t',' ','a','t','t','e','m','p','t',' ','\x40','w','e','\'','r','e',' ','l','o','w',' ','o','n',' ','d','i','s','k',' ','s','p','a','c','e','.',
/* 0x02d1e = "Attempt to create a GC mapping which conflicts with an existing mapping." */
    'A','t','t','e','m','p','t',' ','\x0a','c','r','e','a','t','e',' ','a',' ','G','C',' ','m','a','p','p','i','n','g',' ','\xeb','c','o','n','f','l','i','c','t','s',' ','\x80','\x87','e','x','i','s','t','i','n','g',' ','m','a','p','p','i','n','g','.',
/* 0x02d59 = "Giving up a live snapshot/teleportation attempt because of too many passes." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x40','\x15','\xa0','\xb4','p','a','s','s','e','s','.',
/* 0x02d94 = "Got into a part of IOM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x15','I','O','M',' ','\xac','\x0b','\x08','u','s','e','d',' ','w','h','e','n',' ','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x02dcf = "Maximum number of Shared Clipboard events for an event source has been reached." */
    'M','a','x','i','m','u','m',' ','\xf9','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t','s',' ','\x10','\x87','e','v','e','n','t',' ','s','o','u','r','c','e',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x02e0a = "A legacy device isn\'t implementing the HPET notification interface." */
    'A',' ','l','e','g','a','c','y',' ','\xa3','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','i','n','g',' ','\x02','H','P','E','T',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x02e44 = "Indicating that the VM has been resumed and that the thread should start executing." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','\x7b','\xca','r','e','s','u','m','e','d',' ','\x99','\xac','\x02','t','h','r','e','a','d',' ','s','h','o','u','l','d',' ','s','t','a','r','t',' ','e','x','e','c','u','t','i','n','g','.',
/* 0x02e7e = "The live snapshot/teleportation operation was aborted because of a fatal runtime error." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x96','\x11','a','b','o','r','t','e','d',' ','\x40','\x15','a',' ','f','a','t','a','l',' ','r','u','n','t','i','m','e',' ','\x84',
/* 0x02eb8 = "The PE loader encountered delayed imports, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xd8','\xae','d','e','l','a','y','e','d',' ','i','m','p','o','r','t','s',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xeb','h','a','s','n','\'','t',' ','\xca','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x02ef2 = "Escaped URI character sequence with invalid UTF-8 continutation byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e',' ','\x80','\x8f','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','b','y','t','e','.',
/* 0x02f2c = "PGMPhysWrite/Read hit a handler in Ring-0 or raw-mode context." */
    'P','G','M','P','h','y','s','W','r','i','t','e','/','R','e','a','d',' ','h','i','t',' ','a',' ','h','a','n','d','l','e','r',' ','\x0f','R','i','n','g','-','0',' ','\xa9','r','a','w','-','m','o','d','e',' ','c','o','n','t','e','x','t','.',
/* 0x02f66 = "Reason for leaving RC: Interrupted by external interrupt while in hypervisor code." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xdf','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t',' ','w','h','i','l','e',' ','\x0f','h','y','p','e','r','v','i','s','o','r',' ','\x83',
/* 0x02fa0 = "The user mode tracepoint provider has too many probe locations and probes." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x7b','\xa0','\xb4','p','r','o','b','e',' ','l','o','c','a','t','i','o','n','s',' ','\x99','p','r','o','b','e','s','.',
/* 0x02fda = "Hypercall cannot be enabled/performed due to access/permissions/CPL." */
    'H','y','p','e','r','c','a','l','l',' ','\xe0','\xa8','e','n','a','b','l','e','d','/','p','e','r','f','o','r','m','e','d',' ','d','u','e',' ','\x0a','a','c','c','e','s','s','/','p','e','r','m','i','s','s','i','o','n','s','/','C','P','L','.',
/* 0x03014 = "VRDP protocol violation, client sends less data than expected." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n',',',' ','c','l','i','e','n','t',' ','s','e','n','d','s',' ','l','e','s','s',' ','\x9c','t','h','a','n',' ','e','x','p','e','c','t','e','d','.',
/* 0x0304e = "VFS chain element only provides file, I/O stream (ios), or directory (dir) objects." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','f','i','l','e',',',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',',',' ','\xa9','\x26','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x03088 = "Image Verification Warning: No Authenticode Signature, but on whitelist." */
    'I','m','a','g','e',' ','\x0d','W','a','r','n','i','n','g',':',' ','\xe6','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e',',',' ','b','u','t',' ','o','n',' ','w','h','i','t','e','l','i','s','t','.',
/* 0x030c2 = "This indicates that the process does not have sufficient privileges to perform the operation." */
    'T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','\xac','\x02','\x92','\xb2','\x08','h','a','v','e',' ','s','u','f','f','i','c','i','e','n','t',' ','p','r','i','v','i','l','e','g','e','s',' ','\x0a','p','e','r','f','o','r','m',' ','\x02','\xe8',
/* 0x030fc = "The probe location array isn\'t adjacent to the probe enable array." */
    '\x03','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','a','r','r','a','y',' ','i','s','n','\'','t',' ','a','d','j','a','c','e','n','t',' ','\x0a','\x02','p','r','o','b','e',' ','e','n','a','b','l','e',' ','a','r','r','a','y','.',
/* 0x03136 = "Windows system integrity policy violation (device guard)." */
    'W','i','n','d','o','w','s',' ','s','y','s','t','e','m',' ','i','n','t','e','g','r','i','t','y',' ','p','o','l','i','c','y',' ','v','i','o','l','a','t','i','o','n',' ','(','d','e','v','i','c','e',' ','g','u','a','r','d',')','.',
/* 0x0316f = "The driver is already removed, not more transformations possible (at present)." */
    '\x03','\xc5','\x0b','\x7f','r','e','m','o','v','e','d',',',' ','\x08','m','o','r','e',' ','t','r','a','n','s','f','o','r','m','a','t','i','o','n','s',' ','p','o','s','s','i','b','l','e',' ','(','a','t',' ','p','r','e','s','e','n','t',')','.',
/* 0x031a8 = "VMLAUNCH/VMRESUME succeeded, can enter nested-guest execution." */
    'V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E',' ','s','u','c','c','e','e','d','e','d',',',' ','c','a','n',' ','e','n','t','e','r',' ','n','e','s','t','e','d','-','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x031e1 = "Indicating that we should reschedule to the main execution engine." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','w','e',' ','s','h','o','u','l','d',' ','r','e','s','c','h','e','d','u','l','e',' ','\x0a','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e','.',
/* 0x0321a = "Address translation disabled (but permission bits apply)." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','u','t',' ','p','e','r','m','i','s','s','i','o','n',' ','b','i','t','s',' ','a','p','p','l','y',')','.',
/* 0x03253 = "The uncompressed table of content size in the header didn\'t match what ZLib returned." */
    '\x03','u','n','c','o','m','p','r','e','s','s','e','d',' ','\xb1','\x15','\xed','s','i','z','e',' ','\x0f','\x02','\xb3','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','w','h','a','t',' ','Z','L','i','b',' ','r','e','t','u','r','n','e','d','.',
/* 0x0328c = "The path only element at the end of the VFS chain is too short to make out the parent directory." */
    '\x03','\xd0','o','n','l','y',' ','\x5c','a','t',' ','\x02','e','n','d',' ','\x15','\x02','\x8d',' ','\x9f','\x0b','\xa0','s','h','o','r','t',' ','\x0a','m','a','k','e',' ','o','u','t',' ','\x02','p','a','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x032c5 = "Signed data verification failed because of the authenticated content-type attribute did not match." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','\x15','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf1','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x032fe = "Signed data verification failed because of a malformed authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','\x15','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xf1','a','t','t','r','i','b','u','t','e','.',
/* 0x03337 = "Not all requests could be submitted due to resource shortage." */
    'N','o','t',' ','a','l','l',' ','r','e','q','u','e','s','t','s',' ','c','o','u','l','d',' ','\xa8','s','u','b','m','i','t','t','e','d',' ','d','u','e',' ','\x0a','r','e','s','o','u','r','c','e',' ','s','h','o','r','t','a','g','e','.',
/* 0x03370 = "The \'Type\' attribute in the DrvBlock configuration had an unknown value." */
    '\x03','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','h','a','d',' ','\x87','u','n','k','n','o','w','n',' ','\xf3',
/* 0x033a9 = "Get an out of memory condition trying to allocate a code point array." */
    'G','e','t',' ','\x87','o','u','t',' ','\x15','\x85','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','c','o','d','e',' ','p','o','i','n','t',' ','a','r','r','a','y','.',
/* 0x033e2 = "Reason for leaving RC: A Ring switch was attempted using software interrupt." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x11','a','t','t','e','m','p','t','e','d',' ','u','s','i','n','g',' ','s','o','f','t','w','a','r','e',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x0341b = "Signed data verification failed because of a malformed authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','\x15','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd6','a','t','t','r','i','b','u','t','e','.',
/* 0x03454 = "Indicating that the VM is being terminated and that the execution shall stop." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','\x02','\xcc',' ','\x0b','b','e','i','n','g',' ','t','e','r','m','i','n','a','t','e','d',' ','\x99','\xac','\x02','e','x','e','c','u','t','i','o','n',' ','s','h','a','l','l',' ','s','t','o','p','.',
/* 0x0348d = "Certificate path validator: Unexpected minimum value found in general subtree object (name constraints)." */
    '\xba','\xd0','\xfd','\x94','m','i','n','i','m','u','m',' ','\xfa','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa7','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x034c5 = "Signed data verification failed because the authenticated message-digest attribute did not match." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xd6','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x034fd = "The DTB being parsed has an invalid size set in the header compared to the actual size." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','\x87','\x8f','s','i','z','e',' ','s','e','t',' ','\x0f','\x02','\xb3','c','o','m','p','a','r','e','d',' ','\x0a','\x02','a','c','t','u','a','l',' ','s','i','z','e','.',
/* 0x03535 = "Block read was marked as free in the image and returned as a zero block." */
    'B','l','o','c','k',' ','r','e','a','d',' ','\x11','m','a','r','k','e','d',' ','a','s',' ','f','r','e','e',' ','\x0f','\x02','\x25','\x99','r','e','t','u','r','n','e','d',' ','a','s',' ','a',' ','z','e','r','o',' ','b','l','o','c','k','.',
/* 0x0356d = "Failed to set VMXON enable bit while enabling VT-x through the MSR." */
    '\x8b','\x0a','s','e','t',' ','V','M','X','O','N',' ','e','n','a','b','l','e',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x035a5 = "Cannot add symbolic link because no namespace is configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x40','n','o',' ','n','a','m','e','s','p','a','c','e',' ','\x0b','c','o','n','f','i','g','u','r','e','d',' ','\x0a','\xce','i','t','.',
/* 0x035dd = "Certificate path validator: Unexpected maximum value found in general subtree object (name constraints)." */
    '\xba','\xd0','\xfd','\x94','m','a','x','i','m','u','m',' ','\xfa','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa7','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x03615 = "Someone (including the caller) was already attached as debugger to the VM." */
    'S','o','m','e','o','n','e',' ','(','i','n','c','l','u','d','i','n','g',' ','\x02','c','a','l','l','e','r',')',' ','\x11','\x7f','a','t','t','a','c','h','e','d',' ','a','s',' ','d','e','b','u','g','g','e','r',' ','\x0a','\x02','V','M','.',
/* 0x0364d = "Key decryption failed, perhaps due to an incorrect password." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','f','a','i','l','e','d',',',' ','p','e','r','h','a','p','s',' ','d','u','e',' ','\x0a','\x87','i','n','c','o','r','r','e','c','t',' ','p','a','s','s','w','o','r','d','.',
/* 0x03685 = "VT-x features for all modes (SMX and non-SMX) disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','\x10','a','l','l',' ','m','o','d','e','s',' ','(','S','M','X',' ','\x99','n','o','n','-','S','M','X',')',' ','d','i','s','a','b','l','e','d',' ','\xdf','\x02','B','I','O','S','.',
/* 0x036bd = "The device is not a registered PCI device and thus cannot perform any PCI operations." */
    '\x03','\xa3','\x0b','\x08','a',' ','r','e','g','i','s','t','e','r','e','d',' ','P','C','I',' ','\xa3','\x99','t','h','u','s',' ','\xe0','p','e','r','f','o','r','m',' ','a','n','y',' ','P','C','I',' ','o','p','e','r','a','t','i','o','n','s','.',
/* 0x036f5 = "Process Verification Failure: An unknown and unwanted DLL was found loaded into the process." */
    '\x1e','\x0d','\x12','A','n',' ','u','n','k','n','o','w','n',' ','\x99','u','n','w','a','n','t','e','d',' ','D','L','L',' ','\x11','f','o','u','n','d',' ','l','o','a','d','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0372d = "Couldn\'t find any export for registration of drivers/devices." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','e','x','p','o','r','t',' ','\x10','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x15','d','r','i','v','e','r','s','/','d','e','v','i','c','e','s','.',
/* 0x03765 = "Instruction that triggers the hypercall is invalid/unrecognized." */
    'I','n','s','t','r','u','c','t','i','o','n',' ','\xac','t','r','i','g','g','e','r','s',' ','\x02','h','y','p','e','r','c','a','l','l',' ','\x0b','i','n','v','a','l','i','d','/','u','n','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0379c = "Encountered unicode code point in the surrogate range (0xd800 to 0xdfff)." */
    '\xa5','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\x0f','\x02','s','u','r','r','o','g','a','t','e',' ','r','a','n','g','e',' ','(','0','x','d','8','0','0',' ','\x0a','0','x','d','f','f','f',')','.',
/* 0x037d3 = "The image requires to be signed using the kernel-code signing process." */
    '\x03','\x25','r','e','q','u','i','r','e','s',' ','\x0a','\xa8','s','i','g','n','e','d',' ','u','s','i','n','g',' ','\x02','k','e','r','n','e','l','-','c','o','d','e',' ','s','i','g','n','i','n','g',' ','p','r','o','c','e','s','s','.',
/* 0x0380a = "Out of memory condition when allocating memory with low physical backing." */
    'O','u','t',' ','\x15','\x85','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','\x85','\x80','l','o','w',' ','p','h','y','s','i','c','a','l',' ','b','a','c','k','i','n','g','.',
/* 0x03841 = "Certificate path validator: Intermediate certificate subject does not match child issuer property." */
    '\xba','\xd0','\xfd','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x9e','s','u','b','j','e','c','t',' ','\xb2','\x08','m','a','t','c','h',' ','c','h','i','l','d',' ','i','s','s','u','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x03878 = "A data unit in the saved state file was defined but didn\'t any routine for processing it." */
    'A',' ','\x9c','u','n','i','t',' ','\x0f','\x02','s','a','v','e','d',' ','\xcd','\x1f','\x11','d','e','f','i','n','e','d',' ','b','u','t',' ','d','i','d','n','\'','t',' ','a','n','y',' ','r','o','u','t','i','n','e',' ','\x10','\x04','i','t','.',
/* 0x038af = "Indicating that we should reschedule to recompiled execution." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','w','e',' ','s','h','o','u','l','d',' ','r','e','s','c','h','e','d','u','l','e',' ','\x0a','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x038e6 = "Continuing hypercall at the same RIP, continue guest execution." */
    'C','o','n','t','i','n','u','i','n','g',' ','h','y','p','e','r','c','a','l','l',' ','a','t',' ','\x02','s','a','m','e',' ','R','I','P',',',' ','c','o','n','t','i','n','u','e',' ','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x0391d = "The intercepted instruction handled, advance RIP and continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\xd9','h','a','n','d','l','e','d',',',' ','a','d','v','a','n','c','e',' ','R','I','P',' ','\x99','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03954 = "The operation was cancelled by the user (copy) or another thread (local ipc)." */
    '\x03','\x96','\x11','c','a','n','c','e','l','l','e','d',' ','\xdf','\x02','u','s','e','r',' ','(','c','o','p','y',')',' ','\xa9','a','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','(','l','o','c','a','l',' ','i','p','c',')','.',
/* 0x0398b = "The configuration constructor in main failed due to an internal consistency error." */
    '\x03','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','c','o','n','s','t','r','u','c','t','o','r',' ','\x0f','m','a','i','n',' ','\x98','d','u','e',' ','\x0a','\x87','\x17','c','o','n','s','i','s','t','e','n','c','y',' ','\x84',
/* 0x039c1 = "Parameters was presented to a signature schema that does not take any." */
    'P','a','r','a','m','e','t','e','r','s',' ','\x11','p','r','e','s','e','n','t','e','d',' ','\x0a','a',' ','s','i','g','n','a','t','u','r','e',' ','s','c','h','e','m','a',' ','\xac','\xb2','\x08','t','a','k','e',' ','a','n','y','.',
/* 0x039f7 = "A new node couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','n','o','d','e',' ','c','o','u','l','d','n','\'','t',' ','\xa8','i','n','s','e','r','t','e','d',' ','\x40','o','n','e',' ','\x80','\x02','s','a','m','e',' ','n','a','m','e',' ','e','x','i','s','t','s','.',
/* 0x03a2d = "Tree traversal encountered more nodes than available in the allocator." */
    'T','r','e','e',' ','t','r','a','v','e','r','s','a','l',' ','\xae','m','o','r','e',' ','n','o','d','e','s',' ','t','h','a','n',' ','a','v','a','i','l','a','b','l','e',' ','\x0f','\x02','a','l','l','o','c','a','t','o','r','.',
/* 0x03a63 = "One or more PAE PDPEs are invalid due to reserved bits being set." */
    'O','n','e',' ','\xa9','m','o','r','e',' ','P','A','E',' ','P','D','P','E','s',' ','a','r','e',' ','\x8f','d','u','e',' ','\x0a','r','e','s','e','r','v','e','d',' ','b','i','t','s',' ','b','e','i','n','g',' ','s','e','t','.',
/* 0x03a99 = "Failed to make the Host Interface Networking handle non-blocking." */
    '\x8b','\x0a','m','a','k','e',' ','\x02','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','h','a','n','d','l','e',' ','n','o','n','-','b','l','o','c','k','i','n','g','.',
/* 0x03acf = "Syntax error - you hit a debugger feature which isn\'t implemented yet." */
    '\xf7','\x09','-',' ','y','o','u',' ','h','i','t',' ','a',' ','d','e','b','u','g','g','e','r',' ','f','e','a','t','u','r','e',' ','\xeb','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x03b05 = "The chunk to be unmapped isn\'t actually mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x0a','\xa8','u','n','m','a','p','p','e','d',' ','i','s','n','\'','t',' ','a','c','t','u','a','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x03b3b = "Certificate path validator: Unexpected choice found in general subtree object (name constraints)." */
    '\xba','\xd0','\xfd','\x94','c','h','o','i','c','e',' ','f','o','u','n','d',' ','\x0f','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\xa7','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x03b71 = "A new leaf couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','l','e','a','f',' ','c','o','u','l','d','n','\'','t',' ','\xa8','i','n','s','e','r','t','e','d',' ','\x40','o','n','e',' ','\x80','\x02','s','a','m','e',' ','n','a','m','e',' ','e','x','i','s','t','s','.',
/* 0x03ba7 = "The specified R0 or RC MMIO range didn\'t have a corresponding R3 range." */
    '\x03','\x18','R','0',' ','\xa9','R','C',' ','\xd2',' ','r','a','n','g','e',' ','d','i','d','n','\'','t',' ','h','a','v','e',' ','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',
/* 0x03bdd = "CPU hotplug events from VMMDev are not monitored by the guest." */
    'C','P','U',' ','h','o','t','p','l','u','g',' ','e','v','e','n','t','s',' ','f','r','o','m',' ','V','M','M','D','e','v',' ','a','r','e',' ','\x08','m','o','n','i','t','o','r','e','d',' ','\xdf','\x02','g','u','e','s','t','.',
/* 0x03c13 = "A device didn\'t find a required interface with an attached driver." */
    'A',' ','\xa3','d','i','d','n','\'','t',' ','f','i','n','d',' ','a',' ','r','e','q','u','i','r','e','d',' ','i','n','t','e','r','f','a','c','e',' ','\x80','\x87','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x03c49 = "The size of the one or more regions in the shared module was out of range." */
    '\x03','s','i','z','e',' ','\x15','\x02','o','n','e',' ','\xa9','m','o','r','e',' ','r','e','g','i','o','n','s',' ','\x0f','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x03c7f = "The guest GDT so full that we cannot find free space for our own selectors." */
    '\x03','\xbb','G','D','T',' ','s','o',' ','f','u','l','l',' ','\xac','w','e',' ','\xe0','f','i','n','d',' ','f','r','e','e',' ','s','p','a','c','e',' ','\x10','o','u','r',' ','o','w','n',' ','s','e','l','e','c','t','o','r','s','.',
/* 0x03cb5 = "The attached driver configuration is missing the \'Driver\' attribute." */
    '\x03','a','t','t','a','c','h','e','d',' ','\xc5','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x0b','m','i','s','s','i','n','g',' ','\x02','\'','D','r','i','v','e','r','\'',' ','a','t','t','r','i','b','u','t','e','.',
/* 0x03ceb = "Complex SSM field fed to SSMR3PutStruct or SSMR3GetStruct." */
    'C','o','m','p','l','e','x',' ','S','S','M',' ','f','i','e','l','d',' ','f','e','d',' ','\x0a','S','S','M','R','3','P','u','t','S','t','r','u','c','t',' ','\xa9','S','S','M','R','3','G','e','t','S','t','r','u','c','t','.',
/* 0x03d21 = "Framebuffer is resized, terminate send bitmap procedure." */
    'F','r','a','m','e','b','u','f','f','e','r',' ','\x0b','r','e','s','i','z','e','d',',',' ','t','e','r','m','i','n','a','t','e',' ','s','e','n','d',' ','b','i','t','m','a','p',' ','p','r','o','c','e','d','u','r','e','.',
/* 0x03d57 = "The decompressor completed without using all the input data." */
    '\x03','d','e','c','o','m','p','r','e','s','s','o','r',' ','c','o','m','p','l','e','t','e','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','a','l','l',' ','\x02','i','n','p','u','t',' ','d','a','t','a','.',
/* 0x03d8d = "Recompiled execution: Break out of current TB execution." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k',' ','o','u','t',' ','\x15','c','u','r','r','e','n','t',' ','T','B',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x03dc3 = "Error creating an event semaphore for used with asynchronous reads." */
    '\xc0','c','r','e','a','t','i','n','g',' ','\x87','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x10','u','s','e','d',' ','\x80','a','s','y','n','c','h','r','o','n','o','u','s',' ','r','e','a','d','s','.',
/* 0x03df8 = "Process Verification Failure: The ImageCharacteristics of the process does not match the value in the file header in the exe file." */
    '\x1e','\x0d','\x12','\x03','I','m','a','g','e','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x15','\x02','\x92','\xb2','\x08','m','a','t','c','h',' ','\x02','\xfa','\x0f','\x02','\x1f','\xb3','\x0f','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x03e2d = "The media translation hasn\'t been set yet, so it cannot be obtained." */
    '\x03','m','e','d','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','h','a','s','n','\'','t',' ','\xca','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xe0','\xa8','o','b','t','a','i','n','e','d','.',
/* 0x03e62 = "CPU is not in VMX root mode; unexpected when leaving VMX root mode." */
    'C','P','U',' ','\x0b','\x08','\x0f','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','u','n','e','x','p','e','c','t','e','d',' ','w','h','e','n',' ','\x81','V','M','X',' ','r','o','o','t',' ','m','o','d','e','.',
/* 0x03e97 = "Malformed initialization vector for encrypted key ciper." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x03ecc = "Encountered an unsupported portable archive exchange (pax) header." */
    '\xa5','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','p','o','r','t','a','b','l','e',' ','a','r','c','h','i','v','e',' ','e','x','c','h','a','n','g','e',' ','(','p','a','x',')',' ','h','e','a','d','e','r','.',
/* 0x03f01 = "File access error, another process has locked a portion of the file." */
    'F','i','l','e',' ','a','c','c','e','s','s',' ','e','r','r','o','r',',',' ','a','n','o','t','h','e','r',' ','\x92','\x7b','l','o','c','k','e','d',' ','a',' ','p','o','r','t','i','o','n',' ','\x15','\x02','f','i','l','e','.',
/* 0x03f36 = "Internal processing error in the PGM physical page mapping code dealing with MMIO2 pages." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','\xcb','m','a','p','p','i','n','g',' ','c','o','d','e',' ','d','e','a','l','i','n','g',' ','\x80','M','M','I','O','2',' ','p','a','g','e','s','.',
/* 0x03f6b = "The trace log reader iterator reached the end of the event list." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','r','e','a','d','e','r',' ','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','e','v','e','n','t',' ','l','i','s','t','.',
/* 0x03fa0 = "Internal EM error caused by an unknown warning or informational status code." */
    '\x07','E','M',' ','\x09','c','a','u','s','e','d',' ','\xdf','\x87','u','n','k','n','o','w','n',' ','w','a','r','n','i','n','g',' ','\xa9','i','n','f','o','r','m','a','t','i','o','n','a','l',' ','s','t','a','t','u','s',' ','\x83',
/* 0x03fd5 = "Recompiled execution: Breaking out because of FFs or/and IRQs." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k','i','n','g',' ','o','u','t',' ','\x40','\x15','F','F','s',' ','o','r','/','a','n','d',' ','I','R','Q','s','.',
/* 0x0400a = "The loader resolved an external symbol to an address to big for the image format." */
    '\x03','\xd8','r','e','s','o','l','v','e','d',' ','\x87','e','x','t','e','r','n','a','l',' ','s','y','m','b','o','l',' ','\x0a','\x87','a','d','d','r','e','s','s',' ','\x0a','b','i','g',' ','\x10','\x02','\x25','f','o','r','m','a','t','.',
/* 0x0403f = "command processing is pending, a completion handler will be called." */
    'c','o','m','m','a','n','d',' ','\x04','\x0b','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\xa8','c','a','l','l','e','d','.',
/* 0x04074 = "Tried to grow a file beyond the limit imposed by the process or the filesystem." */
    'T','r','i','e','d',' ','\x0a','g','r','o','w',' ','a',' ','\x1f','b','e','y','o','n','d',' ','\x02','l','i','m','i','t',' ','i','m','p','o','s','e','d',' ','\xdf','\x02','\x92','\xa9','\x02','f','i','l','e','s','y','s','t','e','m','.',
/* 0x040a9 = "The CSRSS instance associated with the client process could not be located." */
    '\x03','C','S','R','S','S',' ','i','n','s','t','a','n','c','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','\x02','c','l','i','e','n','t',' ','\x92','c','o','u','l','d',' ','\x08','\xa8','l','o','c','a','t','e','d','.',
/* 0x040de = "Internal processing error in the PGM physcal page handling code related to MMIO/MMIO2." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','c','a','l',' ','\xcb','h','a','n','d','l','i','n','g',' ','c','o','d','e',' ','r','e','l','a','t','e','d',' ','\x0a','M','M','I','O','/','M','M','I','O','2','.',
/* 0x04112 = "RTThreadYield was called during a GVMMR0SchedPoll call." */
    'R','T','T','h','r','e','a','d','Y','i','e','l','d',' ','\x11','c','a','l','l','e','d',' ','d','u','r','i','n','g',' ','a',' ','G','V','M','M','R','0','S','c','h','e','d','P','o','l','l',' ','c','a','l','l','.',
/* 0x04146 = "Returns by rep-prefixed string instruction if they yield because of pending FFs." */
    'R','e','t','u','r','n','s',' ','\xdf','r','e','p','-','p','r','e','f','i','x','e','d',' ','\xf0','\xd9','i','f',' ','t','h','e','y',' ','y','i','e','l','d',' ','\x40','\x15','p','e','n','d','i','n','g',' ','F','F','s','.',
/* 0x0417a = "To short initialization vector for encrypted key ciper." */
    'T','o',' ','s','h','o','r','t',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x041ae = "Escape URI char decodes as zero (the C string terminator)." */
    'E','s','c','a','p','e',' ','U','R','I',' ','c','h','a','r',' ','d','e','c','o','d','e','s',' ','a','s',' ','z','e','r','o',' ','(','t','h','e',' ','C',' ','\xf0','t','e','r','m','i','n','a','t','o','r',')','.',
/* 0x041e2 = "The timer has a bad clock enum value, probably corruption." */
    '\x03','t','i','m','e','r',' ','\x7b','a',' ','b','a','d',' ','c','l','o','c','k',' ','e','n','u','m',' ','v','a','l','u','e',',',' ','p','r','o','b','a','b','l','y',' ','c','o','r','r','u','p','t','i','o','n','.',
/* 0x04216 = "Cannot add symbolic link to one of the selected namespaces." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x0a','o','n','e',' ','\x15','\x02','s','e','l','e','c','t','e','d',' ','n','a','m','e','s','p','a','c','e','s','.',
/* 0x0424a = "The physical handler range has no corresponding RAM range." */
    '\x03','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','r','a','n','g','e',' ','\x7b','n','o',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','A','M',' ','r','a','n','g','e','.',
/* 0x0427e = "The backend needs more metadata before it can continue." */
    '\x03','b','a','c','k','e','n','d',' ','n','e','e','d','s',' ','m','o','r','e',' ','m','e','t','a','d','a','t','a',' ','b','e','f','o','r','e',' ','i','t',' ','c','a','n',' ','c','o','n','t','i','n','u','e','.',
/* 0x042b2 = "The networking interface to filter was busy (used by someone)." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x0a','f','i','l','t','e','r',' ','\x11','b','u','s','y',' ','(','u','s','e','d',' ','\xdf','s','o','m','e','o','n','e',')','.',
/* 0x042e6 = "The page hash table hashes data outside the defined and implicit sections." */
    '\x03','\xcb','h','a','s','h',' ','\xb1','h','a','s','h','e','s',' ','\x9c','o','u','t','s','i','d','e',' ','\x02','d','e','f','i','n','e','d',' ','\x99','i','m','p','l','i','c','i','t',' ','s','e','c','t','i','o','n','s','.',
/* 0x0431a = "Found a ZIP64 Extra Information Field in a ZIP32 file." */
    'F','o','u','n','d',' ','a',' ','Z','I','P','6','4',' ','E','x','t','r','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','F','i','e','l','d',' ','\x0f','a',' ','Z','I','P','3','2',' ','f','i','l','e','.',
/* 0x0434e = "Cannot destroy VM because not all other EMTs have deregistered." */
    'C','a','n','n','o','t',' ','d','e','s','t','r','o','y',' ','\xcc',' ','\x40','\x08','a','l','l',' ','o','t','h','e','r',' ','E','M','T','s',' ','h','a','v','e',' ','d','e','r','e','g','i','s','t','e','r','e','d','.',
/* 0x04382 = "Invalid nested hardware virtualization feature combination." */
    '\x0c','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x043b6 = "Attempt to free more memory than what was previously allocated." */
    'A','t','t','e','m','p','t',' ','\x0a','f','r','e','e',' ','m','o','r','e',' ','\x85','t','h','a','n',' ','w','h','a','t',' ','\x11','p','r','e','v','i','o','u','s','l','y',' ','a','l','l','o','c','a','t','e','d','.',
/* 0x043ea = "Syntax error - Cannot read symbol value, it is a set-only symbol." */
    '\xf7','\x09','-',' ','C','a','n','n','o','t',' ','r','e','a','d',' ','s','y','m','b','o','l',' ','v','a','l','u','e',',',' ','i','t',' ','\x0b','a',' ','s','e','t','-','o','n','l','y',' ','s','y','m','b','o','l','.',
/* 0x0441e = "RTGetOpt: Command line option has argument with bad format." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x7b','a','r','g','u','m','e','n','t',' ','\x80','b','a','d',' ','f','o','r','m','a','t','.',
/* 0x04452 = "Process Verification Failure: A DLL residing outside System32 was found in the process." */
    '\x1e','\x0d','\x12','A',' ','D','L','L',' ','r','e','s','i','d','i','n','g',' ','o','u','t','s','i','d','e',' ','S','y','s','t','e','m','3','2',' ','\x11','f','o','u','n','d',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x04486 = "The boot catalog validation entry in the import ISO has an incorrect checksum." */
    '\x03','b','o','o','t',' ','\xe5','v','a','l','i','d','a','t','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','\x87','i','n','c','o','r','r','e','c','t',' ','c','h','e','c','k','s','u','m','.',
/* 0x044b9 = "Import ISO contains a directory with a more than one extent, that\'s currently not supported." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x26','\x80','a',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','e','x','t','e','n','t',',',' ','t','h','a','t','\'','s',' ','c','u','r','r','e','n','t','l','y',' ','\x08','\xa4',
/* 0x044ec = "Operation can\'t be done in current HDD container state." */
    'O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa8','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','H','D','D',' ','c','o','n','t','a','i','n','e','r',' ','s','t','a','t','e','.',
/* 0x0451f = "pgmPhysPageMapCommon encountered PGMPAGETYPE_MMIO2_ALIAS_MMIO." */
    'p','g','m','P','h','y','s','P','a','g','e','M','a','p','C','o','m','m','o','n',' ','\xae','P','G','M','P','A','G','E','T','Y','P','E','_','M','M','I','O','2','_','A','L','I','A','S','_','M','M','I','O','.',
/* 0x04552 = "Import ISO starts with supplementary volume descriptor before any primary ones." */
    '\xc3','\xc1',' ','s','t','a','r','t','s',' ','\x80','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd1','\xee','b','e','f','o','r','e',' ','a','n','y',' ','p','r','i','m','a','r','y',' ','o','n','e','s','.',
/* 0x04585 = "The chosen baudrate is invalid or not supported by the given serial port." */
    '\x03','c','h','o','s','e','n',' ','b','a','u','d','r','a','t','e',' ','\x0b','\x8f','\xa9','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','\x02','g','i','v','e','n',' ','s','e','r','i','a','l',' ','p','o','r','t','.',
/* 0x045b8 = "Number of tries to add an int3 breakpoint table to the lookup tables reached." */
    'N','u','m','b','e','r',' ','\x15','t','r','i','e','s',' ','\x0a','a','d','d',' ','\x87','i','n','t','3',' ','\xbf','\xb1','\x0a','\x02','l','o','o','k','u','p',' ','t','a','b','l','e','s',' ','r','e','a','c','h','e','d','.',
/* 0x045eb = "Not possible to detach a driver because the above driver/device doesn't support it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','d','e','t','a','c','h',' ','a',' ','\xc5','\x40','\x02','a','b','o','v','e',' ','d','r','i','v','e','r','/','d','e','v','i','c','e',' ','\xc7','\xce','i','t','.',
/* 0x0461e = "The Host Interface Networking name config IOCTL call failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','n','a','m','e',' ','c','o','n','f','i','g',' ','I','O','C','T','L',' ','c','a','l','l',' ','\x7d',
/* 0x04651 = "Logging is disabled or logger instance could not be created." */
    'L','o','g','g','i','n','g',' ','\x0b','d','i','s','a','b','l','e','d',' ','\xa9','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x08','\xa8','c','r','e','a','t','e','d','.',
/* 0x04684 = "A TSC-delta measurement request is currently being serviced." */
    'A',' ','T','S','C','-','d','e','l','t','a',' ','m','e','a','s','u','r','e','m','e','n','t',' ','\xaa','\x0b','c','u','r','r','e','n','t','l','y',' ','b','e','i','n','g',' ','s','e','r','v','i','c','e','d','.',
/* 0x046b7 = "Process Verification Failure: Found no executable mapped into the process address space." */
    '\x1e','\x0d','\x12','F','o','u','n','d',' ','n','o',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','\x92','a','d','d','r','e','s','s',' ','s','p','a','c','e','.',
/* 0x046ea = "Vote for done tell SSM not to call again until the final pass." */
    'V','o','t','e',' ','\x10','d','o','n','e',' ','t','e','l','l',' ','S','S','M',' ','\x08','\x0a','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x0471d = "The machine (cputype / cpusubtype combination) isn\'t supported." */
    '\x03','m','a','c','h','i','n','e',' ','(','c','p','u','t','y','p','e',' ','/',' ','c','p','u','s','u','b','t','y','p','e',' ','c','o','m','b','i','n','a','t','i','o','n',')',' ','i','s','n','\'','t',' ','\xa4',
/* 0x04750 = "The boot catalog block in the import ISO has an incorrect validation header ID." */
    '\x03','b','o','o','t',' ','\xe5','b','l','o','c','k',' ','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','\x87','i','n','c','o','r','r','e','c','t',' ','v','a','l','i','d','a','t','i','o','n',' ','\xb3','I','D','.',
/* 0x04783 = "The version of the USB device registration structure is unknown to this VBox version." */
    '\x03','\xcf','\x15','\x02','U','S','B',' ','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xea','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x047b6 = "The patch manager is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','p','a','t','c','h',' ','m','a','n','a','g','e','r',' ','\x0b','\x08','u','s','e','d',' ','\x40','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x99','V','T','-','x','/','A','M','D','-','V','.',
/* 0x047e8 = "Don\'t spin for the semaphore, but it is safe to try grab it." */
    'D','o','n','\'','t',' ','s','p','i','n',' ','\x10','\x02','s','e','m','a','p','h','o','r','e',',',' ','b','u','t',' ','i','t',' ','\x0b','s','a','f','e',' ','\x0a','t','r','y',' ','g','r','a','b',' ','i','t','.',
/* 0x0481a = "Maximum of concurrent clipboard transfers has been reached." */
    'M','a','x','i','m','u','m',' ','\x15','c','o','n','c','u','r','r','e','n','t',' ','c','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r','s',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x0484c = "The Logical Unit was found, but it had no driver attached to it." */
    '\x03','L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x11','f','o','u','n','d',',',' ','b','u','t',' ','i','t',' ','h','a','d',' ','n','o',' ','\xc5','a','t','t','a','c','h','e','d',' ','\x0a','i','t','.',
/* 0x0487e = "A VM api requiring EMT was called from another thread." */
    'A',' ','\xcc',' ','a','p','i',' ','r','e','q','u','i','r','i','n','g',' ','E','M','T',' ','\x11','c','a','l','l','e','d',' ','f','r','o','m',' ','a','n','o','t','h','e','r',' ','t','h','r','e','a','d','.',
/* 0x048b0 = "The I/O queue has requests pending which need complete first." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x7b','r','e','q','u','e','s','t','s',' ','p','e','n','d','i','n','g',' ','\xeb','n','e','e','d',' ','c','o','m','p','l','e','t','e',' ','f','i','r','s','t','.',
/* 0x048e2 = "Out of memory condition when allocating executable memory." */
    'O','u','t',' ','\x15','\x85','c','o','n','d','i','t','i','o','n',' ','w','h','e','n',' ','a','l','l','o','c','a','t','i','n','g',' ','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x04914 = "The specified execution engine cannot execute guest code in the current state." */
    '\x03','\x18','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xe0','e','x','e','c','u','t','e',' ','\xbb','c','o','d','e',' ','\x0f','\x02','c','u','r','r','e','n','t',' ','s','t','a','t','e','.',
/* 0x04946 = "The image is required to be signed with the same certificate as the rest of VirtualBox." */
    '\x03','\x25','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','\xa8','s','i','g','n','e','d',' ','\x80','\x02','s','a','m','e',' ','\x9e','a','s',' ','\x02','r','e','s','t',' ','\x15','V','i','r','t','u','a','l','B','o','x','.',
/* 0x04978 = "Non-standard descriptor character set in the logical volume descriptor." */
    'N','o','n','-','s','t','a','n','d','a','r','d',' ','\xee','c','h','a','r','a','c','t','e','r',' ','s','e','t',' ','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x049aa = "The breakpoint owner handle is still used by one or more breakpoints." */
    '\x03','\xbf','o','w','n','e','r',' ','h','a','n','d','l','e',' ','\x0b','s','t','i','l','l',' ','u','s','e','d',' ','\xdf','o','n','e',' ','\xa9','m','o','r','e',' ','b','r','e','a','k','p','o','i','n','t','s','.',
/* 0x049dc = "Unable to seal text memory again to protect against write access (hardening)." */
    '\xde','\x0a','s','e','a','l',' ','t','e','x','t',' ','\x85','a','g','a','i','n',' ','\x0a','p','r','o','t','e','c','t',' ','a','g','a','i','n','s','t',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\xad',
/* 0x04a0e = "SPC requires there to be exactly one SignerInfo entry." */
    'S','P','C',' ','r','e','q','u','i','r','e','s',' ','t','h','e','r','e',' ','\x0a','\xa8','e','x','a','c','t','l','y',' ','o','n','e',' ','S','i','g','n','e','r','I','n','f','o',' ','e','n','t','r','y','.',
/* 0x04a40 = "Support for metadata partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','m','e','t','a','d','a','t','a',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x08','y','e','t',' ','\xca','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04a72 = "Unkonwn paritition ID found in the partition map table." */
    'U','n','k','o','n','w','n',' ','p','a','r','i','t','i','t','i','o','n',' ','I','D',' ','f','o','u','n','d',' ','\x0f','\x02','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','t','a','b','l','e','.',
/* 0x04aa4 = "Image Verification Failure: Error allocating memory for authenticode signature data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\x85','\x10','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x04ad6 = "Failed to initialize a virtual network interface instance." */
    '\x8b','\x0a','i','n','i','t','i','a','l','i','z','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x04b08 = "Certificate path validator: Intermediate certificate is missing the KeyCertSign usage flag." */
    '\xba','\xd0','\xfd','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x9e','\x0b','m','i','s','s','i','n','g',' ','\x02','K','e','y','C','e','r','t','S','i','g','n',' ','u','s','a','g','e',' ','f','l','a','g','.',
/* 0x04b3a = "The release call only release a semaphore nesting, i." */
    '\x03','r','e','l','e','a','s','e',' ','c','a','l','l',' ','o','n','l','y',' ','r','e','l','e','a','s','e',' ','a',' ','s','e','m','a','p','h','o','r','e',' ','n','e','s','t','i','n','g',',',' ','i','.',
/* 0x04b6c = "The physical guest page is a reserved/MMIO page and does not have any HC address." */
    '\x03','p','h','y','s','i','c','a','l',' ','\xbb','\xcb','\x0b','a',' ','r','e','s','e','r','v','e','d','/','\xd2',' ','\xcb','\x99','\xb2','\x08','h','a','v','e',' ','a','n','y',' ','H','C',' ','a','d','d','r','e','s','s','.',
/* 0x04b9e = "Certificate path validator: Hit the max certificate path length before reaching trust anchor." */
    '\xba','\xd0','\xfd','H','i','t',' ','\x02','m','a','x',' ','\x9e','\xd0','l','e','n','g','t','h',' ','b','e','f','o','r','e',' ','r','e','a','c','h','i','n','g',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x04bd0 = "Found unexpected cipher parameters for encrypted key." */
    'F','o','u','n','d',' ','u','n','e','x','p','e','c','t','e','d',' ','c','i','p','h','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x04c02 = "Asynchronous stream initialization still on-going." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','s','t','r','e','a','m',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','i','l','l',' ','o','n','-','g','o','i','n','g','.',
/* 0x04c34 = "The network already exists with a different trunk configuration." */
    '\x03','n','e','t','w','o','r','k',' ','\x7f','e','x','i','s','t','s',' ','\x80','a',' ','d','i','f','f','e','r','e','n','t',' ','t','r','u','n','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x04c66 = "Support for sparable partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','s','p','a','r','a','b','l','e',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x08','y','e','t',' ','\xca','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x04c98 = "Object corresponding to the supplied arguments does not exist." */
    'O','b','j','e','c','t',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','\x0a','\x02','s','u','p','p','l','i','e','d',' ','a','r','g','u','m','e','n','t','s',' ','\xb2','\x08','e','x','i','s','t','.',
/* 0x04cca = "A attach or prepare mount call failed because the driver already had a driver attached." */
    'A',' ','a','t','t','a','c','h',' ','\xa9','p','r','e','p','a','r','e',' ','m','o','u','n','t',' ','c','a','l','l',' ','\x98','\x40','\x02','\xc5','\x7f','h','a','d',' ','a',' ','\xc5','a','t','t','a','c','h','e','d','.',
/* 0x04cfc = "The media geometry hasn\'t been set yet, so it cannot be obtained." */
    '\x03','m','e','d','i','a',' ','g','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xca','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xe0','\xa8','o','b','t','a','i','n','e','d','.',
/* 0x04d2e = "The ELF image was created for an unsupported target machine type." */
    '\x03','E','L','F',' ','\x25','\x11','c','r','e','a','t','e','d',' ','\x10','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','t','y','p','e','.',
/* 0x04d5f = "Found file, but it didn\'t match the search criteria." */
    'F','o','u','n','d',' ','f','i','l','e',',',' ','b','u','t',' ','i','t',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','s','e','a','r','c','h',' ','c','r','i','t','e','r','i','a','.',
/* 0x04d90 = "Resume guest execution after injecting a double-fault." */
    'R','e','s','u','m','e',' ','\xbb','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','i','n','j','e','c','t','i','n','g',' ','a',' ','d','o','u','b','l','e','-','f','a','u','l','t','.',
/* 0x04dc1 = "The DTB property payload size does not match the expectations." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','s','i','z','e',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x04df2 = "The UDP server was shut down using RTUdpServerShutdown." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x11','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','U','d','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x04e23 = "This particular aspect of the instruction is not yet implemented by IEM." */
    'T','h','i','s',' ','p','a','r','t','i','c','u','l','a','r',' ','a','s','p','e','c','t',' ','\x15','\x02','\xd9','\x0b','\x08','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xdf','I','E','M','.',
/* 0x04e54 = "Mismatching SVN revision number between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','S','V','N',' ','r','e','v','i','s','i','o','n',' ','\xf9','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x99','V','B','o','x','V','M','M','.',
/* 0x04e85 = "Sharing violation, file is being used by another process." */
    'S','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',',',' ','\x1f','\x0b','b','e','i','n','g',' ','u','s','e','d',' ','\xdf','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x04eb6 = "The TCP server was shut down using RTTcpServerShutdown." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x11','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','T','c','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x04ee7 = "Process Verification Failure: The memory protection of a image file section does not match what the section header prescribes." */
    '\x1e','\x0d','\x12','\x03','\x85','p','r','o','t','e','c','t','i','o','n',' ','\x15','a',' ','\x25','\x1f','\xda','\xb2','\x08','m','a','t','c','h',' ','w','h','a','t',' ','\x02','\xda','\xb3','p','r','e','s','c','r','i','b','e','s','.',
/* 0x04f18 = "Failed to create or connect to a networking interface filter." */
    '\x8b','\x0a','c','r','e','a','t','e',' ','\xa9','c','o','n','n','e','c','t',' ','\x0a','a',' ','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','f','i','l','t','e','r','.',
/* 0x04f49 = "No trace buffer available, please change the VM config." */
    '\xe6','t','r','a','c','e',' ','b','u','f','f','e','r',' ','a','v','a','i','l','a','b','l','e',',',' ','p','l','e','a','s','e',' ','c','h','a','n','g','e',' ','\x02','\xcc',' ','c','o','n','f','i','g','.',
/* 0x04f7a = "The segment index specified when adding a new segment is already in use." */
    '\x03','s','e','g','m','e','n','t',' ','i','n','d','e','x',' ','\x18','w','h','e','n',' ','a','d','d','i','n','g',' ','a',' ','n','e','w',' ','s','e','g','m','e','n','t',' ','\x0b','\x7f','\x0f','u','s','e','.',
/* 0x04fab = "Certificate path validator: Name constraints does not permits the alternative certificate name." */
    '\xba','\xd0','\xfd','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\xb2','\x08','p','e','r','m','i','t','s',' ','\x02','a','l','t','e','r','n','a','t','i','v','e',' ','\x9e','n','a','m','e','.',
/* 0x04fdc = "Reading from the image was not possible because the offset is out of the image range." */
    'R','e','a','d','i','n','g',' ','f','r','o','m',' ','\x02','\x25','\x11','\x08','p','o','s','s','i','b','l','e',' ','\x40','\x02','o','f','f','s','e','t',' ','\x0b','o','u','t',' ','\x15','\x02','\x25','r','a','n','g','e','.',
/* 0x0500d = "The PE loader encountered an unknown load config directory/header size." */
    '\x03','P','E',' ','\xd8','\xae','\x87','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','n','f','i','g',' ','d','i','r','e','c','t','o','r','y','/','h','e','a','d','e','r',' ','s','i','z','e','.',
/* 0x0503e = "Page fault caused by dirty bit tracking; corrected." */
    'P','a','g','e',' ','f','a','u','l','t',' ','c','a','u','s','e','d',' ','\xdf','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g',';',' ','c','o','r','r','e','c','t','e','d','.',
/* 0x0506f = "Unable to open the host interface due to a sharing violation ." */
    '\xde','\x0a','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','d','u','e',' ','\x0a','a',' ','s','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',' ','.',
/* 0x050a0 = "Support for virtual partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','v','i','r','t','u','a','l',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x08','y','e','t',' ','\xca','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x050d1 = "The DTB structs block contains a malformed padding at the end." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','a',' ','m','a','l','f','o','r','m','e','d',' ','p','a','d','d','i','n','g',' ','a','t',' ','\x02','e','n','d','.',
/* 0x05101 = "Syntax error - Couldn\'t satisfy a request for a specific result type." */
    '\xf7','\x09','-',' ','C','o','u','l','d','n','\'','t',' ','s','a','t','i','s','f','y',' ','a',' ','\xaa','\x10','a',' ','s','p','e','c','i','f','i','c',' ','r','e','s','u','l','t',' ','t','y','p','e','.',
/* 0x05131 = "Reason for leaving RZ: Defer the owner callback invocation to Ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','D','e','f','e','r',' ','\x02','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','i','n','v','o','c','a','t','i','o','n',' ','\x0a','R','i','n','g','-','3','.',
/* 0x05161 = "The iprt loader recognized a ELF image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','a',' ','E','L','F',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05191 = "VRDP script allowed the packet to be processed further." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','a','l','l','o','w','e','d',' ','\x02','p','a','c','k','e','t',' ','\x0a','\xa8','p','r','o','c','e','s','s','e','d',' ','f','u','r','t','h','e','r','.',
/* 0x051c1 = "Internal error: Supposedly unreachable default case in a switch." */
    '\x07','\xd7','S','u','p','p','o','s','e','d','l','y',' ','u','n','r','e','a','c','h','a','b','l','e',' ','d','e','f','a','u','l','t',' ','c','a','s','e',' ','\x0f','a',' ','s','w','i','t','c','h','.',
/* 0x051f1 = "The VirtualBox version is not supported by one of the extension packs." */
    '\x03','V','i','r','t','u','a','l','B','o','x',' ','\xcf','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','o','n','e',' ','\x15','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',
/* 0x05221 = "Escaped URI character is not a valid UTF-8 lead byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','\x0b','\x08','a',' ','v','a','l','i','d',' ','U','T','F','-','8',' ','l','e','a','d',' ','b','y','t','e','.',
/* 0x05251 = "The environment variable has been recorded as being unset." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x7b','\xca','r','e','c','o','r','d','e','d',' ','a','s',' ','b','e','i','n','g',' ','u','n','s','e','t','.',
/* 0x05281 = "Hit unimplemented glob pattern matching feature." */
    'H','i','t',' ','u','n','i','m','p','l','e','m','e','n','t','e','d',' ','g','l','o','b',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','e','a','t','u','r','e','.',
/* 0x052b1 = "Essential fields in the shared VM structure doesn't match the global one." */
    'E','s','s','e','n','t','i','a','l',' ','f','i','e','l','d','s',' ','\x0f','\x02','s','h','a','r','e','d',' ','\xcc',' ','\xea','\xc7','m','a','t','c','h',' ','\x02','g','l','o','b','a','l',' ','o','n','e','.',
/* 0x052e1 = "The MMIO handler experienced a problem with the disassembler." */
    '\x03','\xd2',' ','h','a','n','d','l','e','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','a',' ','p','r','o','b','l','e','m',' ','\x80','\x02','d','i','s','a','s','s','e','m','b','l','e','r','.',
/* 0x05311 = "Attempt to recursively enter a non-recursive lock." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','c','u','r','s','i','v','e','l','y',' ','e','n','t','e','r',' ','a',' ','n','o','n','-','r','e','c','u','r','s','i','v','e',' ','l','o','c','k','.',
/* 0x05341 = "Expected PKCS #7 object to contain exactly on signer info entry." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa7','\x0a','c','o','n','t','a','i','n',' ','e','x','a','c','t','l','y',' ','o','n',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','e','n','t','r','y','.',
/* 0x05371 = "Only one PCI function is supported per PDM device." */
    'O','n','l','y',' ','o','n','e',' ','P','C','I',' ','f','u','n','c','t','i','o','n',' ','\x0b','s','u','p','p','o','r','t','e','d',' ','p','e','r',' ','P','D','M',' ','d','e','v','i','c','e','.',
/* 0x053a1 = "Failed to write to a memory region while performing a hypercall." */
    '\x8b','\x0a','w','r','i','t','e',' ','\x0a','a',' ','\x85','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x053d1 = "An entry in the manifest file couldn\'t be interpreted correctly." */
    'A','n',' ','\xc8','\x0f','\x02','m','a','n','i','f','e','s','t',' ','\x1f','c','o','u','l','d','n','\'','t',' ','\xa8','i','n','t','e','r','p','r','e','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x05401 = "Negative exponent makes no sense to integer math." */
    'N','e','g','a','t','i','v','e',' ','e','x','p','o','n','e','n','t',' ','m','a','k','e','s',' ','n','o',' ','s','e','n','s','e',' ','\x0a','i','n','t','e','g','e','r',' ','m','a','t','h','.',
/* 0x05430 = "Malformed partition map table in the logical volume descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb1','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0545f = "The iprt loader recognized a PE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','a',' ','P','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0548e = "Indicating that EM should single step an instruction." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','E','M',' ','s','h','o','u','l','d',' ','s','i','n','g','l','e',' ','s','t','e','p',' ','\x87','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x054bd = "The OS does not support setting the time stamps on a symbolic link." */
    '\x03','O','S',' ','\xb2','\x08','\xce','s','e','t','t','i','n','g',' ','\x02','t','i','m','e',' ','s','t','a','m','p','s',' ','o','n',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x054ec = "Failed to read to a memory region while performing a hypercall." */
    '\x8b','\x0a','r','e','a','d',' ','\x0a','a',' ','\x85','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x0551b = "The hash is too long for the key used when signing/verifying." */
    '\x03','h','a','s','h',' ','\x0b','\xa0','l','o','n','g',' ','\x10','\x02','k','e','y',' ','u','s','e','d',' ','w','h','e','n',' ','s','i','g','n','i','n','g','/','v','e','r','i','f','y','i','n','g','.',
/* 0x0554a = "Failed getting cryptographically strong random bytes." */
    '\x8b','g','e','t','t','i','n','g',' ','c','r','y','p','t','o','g','r','a','p','h','i','c','a','l','l','y',' ','s','t','r','o','n','g',' ','r','a','n','d','o','m',' ','b','y','t','e','s','.',
/* 0x05579 = "Encountered a unicode code point which cannot be represented as UTF-16." */
    '\xa5','a',' ','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xeb','\xe0','\xa8','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','U','T','F','-','1','6','.',
/* 0x055a8 = "The iprt loader recognized a LX image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','X',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x055d7 = "VFS chain element only provides file system stream (fss) objects." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x05606 = "The number being converted (string) contained no digits." */
    '\x03','\xf9','b','e','i','n','g',' ','c','o','n','v','e','r','t','e','d',' ','(','s','t','r','i','n','g',')',' ','c','o','n','t','a','i','n','e','d',' ','n','o',' ','d','i','g','i','t','s','.',
/* 0x05635 = "Indicates that we modified the host CR0 (FPU related)." */
    'I','n','d','i','c','a','t','e','s',' ','\xac','w','e',' ','m','o','d','i','f','i','e','d',' ','\x02','h','o','s','t',' ','C','R','0',' ','(','F','P','U',' ','r','e','l','a','t','e','d',')','.',
/* 0x05664 = "Attemted illegal operation in simplified memory management mode." */
    'A','t','t','e','m','t','e','d',' ','i','l','l','e','g','a','l',' ','\x96','\x0f','s','i','m','p','l','i','f','i','e','d',' ','\x85','m','a','n','a','g','e','m','e','n','t',' ','m','o','d','e','.',
/* 0x05693 = "The session has reached the max number of (user mode) providers." */
    '\x03','s','e','s','s','i','o','n',' ','\x7b','r','e','a','c','h','e','d',' ','\x02','m','a','x',' ','\xf9','\x15','(','u','s','e','r',' ','m','o','d','e',')',' ','p','r','o','v','i','d','e','r','s','.',
/* 0x056c2 = "Non fatal Patch Manager analysis phase warning." */
    'N','o','n',' ','f','a','t','a','l',' ','P','a','t','c','h',' ','M','a','n','a','g','e','r',' ','a','n','a','l','y','s','i','s',' ','p','h','a','s','e',' ','w','a','r','n','i','n','g','.',
/* 0x056f1 = "The version of the device registration structure is unknown to this VBox version." */
    '\x03','\xcf','\x15','\x02','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xea','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x05720 = "The iprt loader recognized a NE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','a',' ','N','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0574f = "The version of the driver registration structure is unknown to this VBox version." */
    '\x03','\xcf','\x15','\x02','\xc5','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xea','\x0b','u','n','k','n','o','w','n',' ','\x0a','t','h','i','s',' ','V','B','o','x',' ','v','e','r','s','i','o','n','.',
/* 0x0577e = "No debug module interpreter matching the debug info." */
    '\xe6','d','e','b','u','g',' ','m','o','d','u','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','m','a','t','c','h','i','n','g',' ','\x02','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x057ad = "A reboot is needed for completing driver (un)installation." */
    'A',' ','r','e','b','o','o','t',' ','\x0b','n','e','e','d','e','d',' ','\x10','c','o','m','p','l','e','t','i','n','g',' ','\xc5','(','u','n',')','i','n','s','t','a','l','l','a','t','i','o','n','.',
/* 0x057dc = "The DTB being parsed has an invalid memory reservation block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','\x87','\x8f','\x85','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0580b = "Someone is trying to write a memory block which is too big to encode." */
    'S','o','m','e','o','n','e',' ','\x0b','t','r','y','i','n','g',' ','\x0a','w','r','i','t','e',' ','a',' ','\x85','b','l','o','c','k',' ','\xeb','\x0b','\xa0','b','i','g',' ','\x0a','e','n','c','o','d','e','.',
/* 0x0583a = "The argv[0] of an internal application does not match the executable image path (hardening)." */
    '\x03','a','r','g','v','[','0',']',' ','\x15','\x87','\x17','a','p','p','l','i','c','a','t','i','o','n',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','e','x','e','c','u','t','a','b','l','e',' ','\x25','\xd0','\xad',
/* 0x05869 = "Mismatching VMCPU structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','V','M','C','P','U',' ','\xea','s','i','z','e',' ','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x99','V','B','o','x','V','M','M','.',
/* 0x05898 = "Certificate path validator: Intermediate certificate is not marked as a certificate authority (CA)." */
    '\xba','\xd0','\xfd','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x9e','\x0b','\x08','m','a','r','k','e','d',' ','a','s',' ','a',' ','\x9e','a','u','t','h','o','r','i','t','y',' ','(','C','A',')','.',
/* 0x058c7 = "The iprt loader recognized a MZ image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','a',' ','M','Z',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x058f6 = "GVMM does not support the range of CPUs present/possible on the host." */
    'G','V','M','M',' ','\xb2','\x08','\xce','\x02','r','a','n','g','e',' ','\x15','C','P','U','s',' ','p','r','e','s','e','n','t','/','p','o','s','s','i','b','l','e',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x05925 = "Failed to retrieve a virtual network interface link ID." */
    '\x8b','\x0a','r','e','t','r','i','e','v','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','l','i','n','k',' ','I','D','.',
/* 0x05954 = "The iprt loader recognized a LE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xc7','\xce','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x05983 = "The sections aren\'t ordered by segment as expected by the loader." */
    '\x03','s','e','c','t','i','o','n','s',' ','a','r','e','n','\'','t',' ','o','r','d','e','r','e','d',' ','\xdf','s','e','g','m','e','n','t',' ','a','s',' ','\xc9','\xdf','\x02','l','o','a','d','e','r','.',
/* 0x059b2 = "Got an out of memory condition trying to allocate a string." */
    'G','o','t',' ','\x87','o','u','t',' ','\x15','\x85','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x0a','a','l','l','o','c','a','t','e',' ','a',' ','s','t','r','i','n','g','.',
/* 0x059e1 = "The configuration constructor in main failed due to a COM error." */
    '\x03','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','c','o','n','s','t','r','u','c','t','o','r',' ','\x0f','m','a','i','n',' ','\x98','d','u','e',' ','\x0a','a',' ','C','O','M',' ','\x84',
/* 0x05a0f = "The auto usage cache for the dynamic mapping set is full." */
    '\x03','a','u','t','o',' ','u','s','a','g','e',' ','c','a','c','h','e',' ','\x10','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','s','e','t',' ','\x0b','f','u','l','l','.',
/* 0x05a3d = "Failed to create a virtual network interface instance." */
    '\x8b','\x0a','c','r','e','a','t','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x05a6b = "Not possible to attach further drivers to the driver." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','a','t','t','a','c','h',' ','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','\x0a','\x02','d','r','i','v','e','r','.',
/* 0x05a99 = "The DTB property name offset points past the string block." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','n','a','m','e',' ','o','f','f','s','e','t',' ','p','o','i','n','t','s',' ','p','a','s','t',' ','\x02','\xf0','b','l','o','c','k','.',
/* 0x05ac7 = "Unfinished CodeView debug information feature." */
    'U','n','f','i','n','i','s','h','e','d',' ','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','e','a','t','u','r','e','.',
/* 0x05af5 = "Missing relative distinguished name map entry." */
    'M','i','s','s','i','n','g',' ','r','e','l','a','t','i','v','e',' ','d','i','s','t','i','n','g','u','i','s','h','e','d',' ','n','a','m','e',' ','m','a','p',' ','e','n','t','r','y','.',
/* 0x05b23 = "An EMT called an API which cannot be called on such a thread." */
    'A','n',' ','E','M','T',' ','c','a','l','l','e','d',' ','\x87','A','P','I',' ','\xeb','\xe0','\xa8','c','a','l','l','e','d',' ','o','n',' ','s','u','c','h',' ','a',' ','t','h','r','e','a','d','.',
/* 0x05b51 = "Import ISO contains a directory record with a mismatching volume sequence number." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x26','r','e','c','o','r','d',' ','\x80','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xd1','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x05b7f = "Unknown error while reading the guest GDT during shadow table updating." */
    '\xf8','\x09','w','h','i','l','e',' ','r','e','a','d','i','n','g',' ','\x02','\xbb','G','D','T',' ','d','u','r','i','n','g',' ','s','h','a','d','o','w',' ','\xb1','u','p','d','a','t','i','n','g','.',
/* 0x05bad = "A break was detected until all requested data could be received." */
    'A',' ','b','r','e','a','k',' ','\x11','d','e','t','e','c','t','e','d',' ','u','n','t','i','l',' ','a','l','l',' ','\xdd','\x9c','c','o','u','l','d',' ','\xa8','r','e','c','e','i','v','e','d','.',
/* 0x05bdb = "The boot catalog validation entry in the import ISO has incorrect keys." */
    '\x03','b','o','o','t',' ','\xe5','v','a','l','i','d','a','t','i','o','n',' ','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','i','n','c','o','r','r','e','c','t',' ','k','e','y','s','.',
/* 0x05c09 = "VMPTRLD failed; possibly because of invalid VMCS launch-state." */
    'V','M','P','T','R','L','D',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x40','\x15','\x8f','V','M','C','S',' ','l','a','u','n','c','h','-','s','t','a','t','e','.',
/* 0x05c37 = "The specified I/O port range was owned by some other device(s)." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x11','o','w','n','e','d',' ','\xdf','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',
/* 0x05c65 = "Unsupported create type in an RTVfsObjOpen or RTVfsDirOpenObj call." */
    '\x97','c','r','e','a','t','e',' ','\xf1','\x0f','\x87','R','T','V','f','s','O','b','j','O','p','e','n',' ','\xa9','R','T','V','f','s','D','i','r','O','p','e','n','O','b','j',' ','c','a','l','l','.',
/* 0x05c93 = "Couldn\'t find any free USB ports to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','f','r','e','e',' ','U','S','B',' ','p','o','r','t','s',' ','\x0a','a','t','t','a','c','h',' ','\x02','\xa3','t','o','.',
/* 0x05cc1 = "Server response contains unexpected repetitive header field." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x8a','u','n','e','x','p','e','c','t','e','d',' ','r','e','p','e','t','i','t','i','v','e',' ','\xb3','f','i','e','l','d','.',
/* 0x05cef = "The Host Interface Networking terminate program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','t','e','r','m','i','n','a','t','e',' ','p','r','o','g','r','a','m',' ','\x7d',
/* 0x05d1d = "The group is a non-system group and it has write access (hardening)." */
    '\x03','g','r','o','u','p',' ','\x0b','a',' ','n','o','n','-','s','y','s','t','e','m',' ','g','r','o','u','p',' ','\x99','i','t',' ','\x7b','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\xad',
/* 0x05d4b = "The message digest of the extracted data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xd6','\x15','\x02','e','x','t','r','a','c','t','e','d',' ','\x9c','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x05d78 = "IOMGCIOPortHandler was given an unexpected opcode." */
    'I','O','M','G','C','I','O','P','o','r','t','H','a','n','d','l','e','r',' ','\x11','g','i','v','e','n',' ','\x87','u','n','e','x','p','e','c','t','e','d',' ','o','p','c','o','d','e','.',
/* 0x05da5 = "Digest algorithm parameters are not supported by the PKCS #7 code." */
    'D','i','g','e','s','t',' ','\xd3','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','\x02','P','K','C','S',' ','#','7',' ','\x83',
/* 0x05dd2 = "Not able satisfy all the requirements of the request." */
    'N','o','t',' ','a','b','l','e',' ','s','a','t','i','s','f','y',' ','a','l','l',' ','\x02','r','e','q','u','i','r','e','m','e','n','t','s',' ','\x15','\x02','r','e','q','u','e','s','t','.',
/* 0x05dff = "The digest algorithm in the SignerInfo does not match the one in the indirect data." */
    '\x03','\xd6','\xd3','\x0f','\x02','S','i','g','n','e','r','I','n','f','o',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','i','n','d','i','r','e','c','t',' ','d','a','t','a','.',
/* 0x05e2c = "Maximum number of Shared Clipboard objects has been reached." */
    'M','a','x','i','m','u','m',' ','\xf9','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x05e59 = "The PE loader doesn't know how to deal with the global pointer data directory entry yet." */
    '\x03','P','E',' ','\xd8','\xc7','k','n','o','w',' ','h','o','w',' ','\x0a','d','e','a','l',' ','\x80','\x02','g','l','o','b','a','l',' ','p','o','i','n','t','e','r',' ','\x9c','\x26','\xc8','y','e','t','.',
/* 0x05e86 = "The intercepted operation was not handled, take default action." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\x96','\x11','\x08','h','a','n','d','l','e','d',',',' ','t','a','k','e',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x05eb3 = "The default boot catalog entry in the import ISO an invalid boot indicator value." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x87','\x8f','b','o','o','t',' ','i','n','d','i','c','a','t','o','r',' ','\xf3',
/* 0x05ee0 = "Somebody cleared X86_CR4_VMXE in the CR4 register." */
    'S','o','m','e','b','o','d','y',' ','c','l','e','a','r','e','d',' ','X','8','6','_','C','R','4','_','V','M','X','E',' ','\x0f','\x02','C','R','4',' ','r','e','g','i','s','t','e','r','.',
/* 0x05f0d = "PKCS #7 singer info contains no issuer serial number." */
    'P','K','C','S',' ','#','7',' ','s','i','n','g','e','r',' ','i','n','f','o',' ','\x8a','n','o',' ','i','s','s','u','e','r',' ','s','e','r','i','a','l',' ','n','u','m','b','e','r','.',
/* 0x05f3a = "The page is unassigned (akin to VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS)." */
    '\x03','\xcb','\x0b','u','n','a','s','s','i','g','n','e','d',' ','(','a','k','i','n',' ','\x0a','\x01','\x8c','\x05','G','C','_','P','H','Y','S','I','C','A','L','_','A','D','D','R','E','S','S',')','.',
/* 0x05f67 = "Repairing the image is not possible because the corruption is to severe." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x25','\x0b','\x08','p','o','s','s','i','b','l','e',' ','\x40','\x02','c','o','r','r','u','p','t','i','o','n',' ','\x0b','\x0a','s','e','v','e','r','e','.',
/* 0x05f94 = "Unexpected PCI region change during VGA saved state loading." */
    '\x94','P','C','I',' ','r','e','g','i','o','n',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','V','G','A',' ','s','a','v','e','d',' ','\xcd','l','o','a','d','i','n','g','.',
/* 0x05fc1 = "iSCSI: Operation can\'t be done in current image state." */
    'i','S','C','S','I',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa8','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','\x25','s','t','a','t','e','.',
/* 0x05fee = "The image is 32-bit and contains 64-bit load commands or vise versa." */
    '\x03','\x25','\x0b','3','2','-','b','i','t',' ','\x99','\x8a','6','4','-','b','i','t',' ','l','o','a','d',' ','c','o','m','m','a','n','d','s',' ','\xa9','v','i','s','e',' ','v','e','r','s','a','.',
/* 0x0601b = "The RAM size differs between the saved state and the VM config." */
    '\x03','R','A','M',' ','s','i','z','e',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','\x02','s','a','v','e','d',' ','\xcd','\x99','\x02','\xcc',' ','c','o','n','f','i','g','.',
/* 0x06048 = "The server has not found anything matching the URI given." */
    '\x03','s','e','r','v','e','r',' ','\x7b','\x08','f','o','u','n','d',' ','a','n','y','t','h','i','n','g',' ','m','a','t','c','h','i','n','g',' ','\x02','U','R','I',' ','g','i','v','e','n','.',
/* 0x06075 = "Escaped URI characters does not decode to valid UTF-8." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r','s',' ','\xb2','\x08','d','e','c','o','d','e',' ','\x0a','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x060a2 = "The specified I/O port range intruded on an existing range." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','i','n','t','r','u','d','e','d',' ','o','n',' ','\x87','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',
/* 0x060cf = "The user mode tracepoint provider string table offset is bad." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xf0','\xb1','o','f','f','s','e','t',' ','\x0b','b','a','d','.',
/* 0x060fc = "A path is not relative (start with root), expected an relative path." */
    'A',' ','\xd0','\x0b','\x08','r','e','l','a','t','i','v','e',' ','(','s','t','a','r','t',' ','\x80','r','o','o','t',')',',',' ','\xc9','\x87','r','e','l','a','t','i','v','e',' ','p','a','t','h','.',
/* 0x06129 = "Process Verification Failure: The name of an image file changes between mapping regions." */
    '\x1e','\x0d','\x12','\x03','n','a','m','e',' ','\x15','\x87','\x25','\x1f','c','h','a','n','g','e','s',' ','b','e','t','w','e','e','n',' ','m','a','p','p','i','n','g',' ','r','e','g','i','o','n','s','.',
/* 0x06156 = "RTDirReadEx() failed to retrieve the extra data which was requested." */
    'R','T','D','i','r','R','e','a','d','E','x','(',')',' ','\x98','\x0a','r','e','t','r','i','e','v','e',' ','\x02','e','x','t','r','a',' ','\x9c','\xeb','\x11','r','e','q','u','e','s','t','e','d','.',
/* 0x06183 = "RTGetOpt: Command line option needs argument." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','a','r','g','u','m','e','n','t','.',
/* 0x061b0 = "Image Verification Failure: Error reading authenticode signature data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x061dd = "VFS chain element only provides file and I/O stream (ios) objects." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x1f','\x99','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0620a = "The I/O queue is full and can\'t accept more requests." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x0b','f','u','l','l',' ','\x99','c','a','n','\'','t',' ','a','c','c','e','p','t',' ','m','o','r','e',' ','r','e','q','u','e','s','t','s','.',
/* 0x06237 = "Recording has been throttled due to current settings." */
    'R','e','c','o','r','d','i','n','g',' ','\x7b','\xca','t','h','r','o','t','t','l','e','d',' ','d','u','e',' ','\x0a','c','u','r','r','e','n','t',' ','s','e','t','t','i','n','g','s','.',
/* 0x06263 = "Page hash table is too long (covers signature data, i." */
    'P','a','g','e',' ','h','a','s','h',' ','\xb1','\x0b','\xa0','l','o','n','g',' ','(','c','o','v','e','r','s',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a',',',' ','i','.',
/* 0x0628f = "The EVP_PKEY_CTX_set_rsa_padding API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','C','T','X','_','s','e','t','_','r','s','a','_','p','a','d','d','i','n','g',' ','A','P','I',' ','\x0f','O','p','e','n','S','S','L',' ','\x7d',
/* 0x062bb = "Error while characters translation (unicode and so)." */
    '\xc0','w','h','i','l','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','(','u','n','i','c','o','d','e',' ','\x99','s','o',')','.',
/* 0x062e7 = "Import ISO contains a root directory with a mismatching volume sequence number." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x26','\x80','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xd1','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x06313 = "The message digest of the archived data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xd6','\x15','\x02','a','r','c','h','i','v','e','d',' ','\x9c','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0633f = "Recording is not possible due to a set restriction." */
    'R','e','c','o','r','d','i','n','g',' ','\x0b','\x08','p','o','s','s','i','b','l','e',' ','d','u','e',' ','\x0a','a',' ','s','e','t',' ','r','e','s','t','r','i','c','t','i','o','n','.',
/* 0x0636b = "The state doesn't match the VM configuration in one or another way." */
    '\x03','\xcd','\xc7','m','a','t','c','h',' ','\x02','\xcc',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x0f','o','n','e',' ','\xa9','a','n','o','t','h','e','r',' ','w','a','y','.',
/* 0x06397 = "The media is not mounted, operation requires a mounted media." */
    '\x03','m','e','d','i','a',' ','\x0b','\x08','m','o','u','n','t','e','d',',',' ','\x96','r','e','q','u','i','r','e','s',' ','a',' ','m','o','u','n','t','e','d',' ','m','e','d','i','a','.',
/* 0x063c3 = "Server response contains embedded zero character(s)." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x8a','e','m','b','e','d','d','e','d',' ','z','e','r','o',' ','c','h','a','r','a','c','t','e','r','(','s',')','.',
/* 0x063ef = "The lock validator detected an existing deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','\x87','e','x','i','s','t','i','n','g',' ','d','e','a','d','l','o','c','k','.',
/* 0x0641b = "(One) receive buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','r','e','c','e','i','v','e',' ','b','u','f','f','e','r',' ','\x11','\xa0','s','m','a','l','l',',',' ','\xa9','\xa0','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x06447 = "Failed to fix mappings because a mapping rejected the address." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x40','a',' ','m','a','p','p','i','n','g',' ','r','e','j','e','c','t','e','d',' ','\x02','a','d','d','r','e','s','s','.',
/* 0x06473 = "Too many readers on read/write critical section." */
    'T','o','o',' ','\xb4','r','e','a','d','e','r','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0649f = "The provided password to decrypt the DEK was incorrect." */
    '\x03','p','r','o','v','i','d','e','d',' ','p','a','s','s','w','o','r','d',' ','\x0a','d','e','c','r','y','p','t',' ','\x02','D','E','K',' ','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x064cb = "A numeric tar header field was not terminated correctly." */
    'A',' ','n','u','m','e','r','i','c',' ','t','a','r',' ','\xb3','f','i','e','l','d',' ','\x11','\x08','t','e','r','m','i','n','a','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x064f7 = "Import ISO uses a logical block size other than 2KB." */
    '\xc3','\xc1',' ','u','s','e','s',' ','a',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e',' ','o','t','h','e','r',' ','t','h','a','n',' ','2','K','B','.',
/* 0x06523 = "Failed to fix mappings because of a conflict with the intermediate code." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x40','\x15','a',' ','c','o','n','f','l','i','c','t',' ','\x80','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','\x83',
/* 0x0654f = "VFS chain element takes a directory (dir) or file system (vfs) object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x26','(','d','i','r',')',' ','\xa9','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x0657b = "VMDK: Operation can\'t be done in current image state." */
    'V','M','D','K',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\xa8','d','o','n','e',' ','\x0f','c','u','r','r','e','n','t',' ','\x25','s','t','a','t','e','.',
/* 0x065a7 = "There are unconsumed bytes after decoding an ASN." */
    'T','h','e','r','e',' ','a','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','b','y','t','e','s',' ','a','f','t','e','r',' ','d','e','c','o','d','i','n','g',' ','\x87','\xf4',
/* 0x065d3 = "The ring-0 function is not supported for this VM target." */
    '\x03','r','i','n','g','-','0',' ','f','u','n','c','t','i','o','n',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\x10','t','h','i','s',' ','\xcc',' ','t','a','r','g','e','t','.',
/* 0x065ff = "The nested-guest #VMEXIT processing failed, initiate shutdown." */
    '\x03','n','e','s','t','e','d','-','\xbb','#','V','M','E','X','I','T',' ','\x04','f','a','i','l','e','d',',',' ','i','n','i','t','i','a','t','e',' ','s','h','u','t','d','o','w','n','.',
/* 0x0662b = "Maximum (context ID object) count has been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',' ','o','b','j','e','c','t',')',' ','c','o','u','n','t',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x06657 = "SSM did a callback for a pass we didn\'t expect." */
    'S','S','M',' ','d','i','d',' ','a',' ','c','a','l','l','b','a','c','k',' ','\x10','a',' ','p','a','s','s',' ','w','e',' ','d','i','d','n','\'','t',' ','e','x','p','e','c','t','.',
/* 0x06683 = "PKIX signature no does not match up to the current data." */
    'P','K','I','X',' ','s','i','g','n','a','t','u','r','e',' ','n','o',' ','\xb2','\x08','m','a','t','c','h',' ','u','p',' ','\x0a','\x02','c','u','r','r','e','n','t',' ','d','a','t','a','.',
/* 0x066af = "Failed to open a virtual network interface instance." */
    '\x8b','\x0a','o','p','e','n',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x066db = "A boot catalog entry in the import ISO has an image with an indeterminate size." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','\x87','\x25','\x80','\x87','i','n','d','e','t','e','r','m','i','n','a','t','e',' ','s','i','z','e','.',
/* 0x06707 = "Maximum (context ID) sessions have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','s','e','s','s','i','o','n','s',' ','h','a','v','e',' ','\xca','r','e','a','c','h','e','d','.',
/* 0x06733 = "Exclusive semaphore is owned by another process." */
    'E','x','c','l','u','s','i','v','e',' ','s','e','m','a','p','h','o','r','e',' ','\x0b','o','w','n','e','d',' ','\xdf','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0675f = "Authentication failed (ISessionManager::logon())." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\x98','(','I','S','e','s','s','i','o','n','M','a','n','a','g','e','r',':',':','l','o','g','o','n','(',')',')','.',
/* 0x0678a = "Syntax error - an argument or subargument contains nothing useful." */
    '\xf7','\x09','-',' ','\x87','a','r','g','u','m','e','n','t',' ','\xa9','s','u','b','a','r','g','u','m','e','n','t',' ','\x8a','n','o','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x067b5 = "The PCI bus assigned to a device didn\'t have room for it." */
    '\x03','P','C','I',' ','b','u','s',' ','a','s','s','i','g','n','e','d',' ','\x0a','a',' ','\xa3','d','i','d','n','\'','t',' ','h','a','v','e',' ','r','o','o','m',' ','\x10','i','t','.',
/* 0x067e0 = "Unexpected instruction encountered for which there is no patch strategy implemented (hardening)." */
    '\x94','\xd9','\xae','\x10','\xeb','t','h','e','r','e',' ','\x0b','n','o',' ','p','a','t','c','h',' ','s','t','r','a','t','e','g','y',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xad',
/* 0x0680b = "Too many writes on read/write critical section." */
    'T','o','o',' ','\xb4','w','r','i','t','e','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x06836 = "The previous ownership of this semaphore has ended." */
    '\x03','p','r','e','v','i','o','u','s',' ','o','w','n','e','r','s','h','i','p',' ','\x15','t','h','i','s',' ','s','e','m','a','p','h','o','r','e',' ','\x7b','e','n','d','e','d','.',
/* 0x06861 = "Couldn\'t find MMIO2 range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','r','a','n','g','e',' ','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0688c = "Error extracting a public key from the certificate." */
    '\xc0','e','x','t','r','a','c','t','i','n','g',' ','a',' ','p','u','b','l','i','c',' ','k','e','y',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x068b7 = "Ran out of memory while compressing or uncompressing." */
    'R','a','n',' ','o','u','t',' ','\x15','\x85','w','h','i','l','e',' ','c','o','m','p','r','e','s','s','i','n','g',' ','\xa9','u','n','c','o','m','p','r','e','s','s','i','n','g','.',
/* 0x068e2 = "Maximum (context ID) objects have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','o','b','j','e','c','t','s',' ','h','a','v','e',' ','\xca','r','e','a','c','h','e','d','.',
/* 0x0690d = "Reason for leaving RC: Guest tried to write to our LDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','L','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06938 = "Reason for leaving RC: Guest tried to write to our TSS - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','T','S','S',' ','-',' ','f','a','t','a','l','.',
/* 0x06963 = "A Shared Clipboard objects handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','h','a','n','d','l','e',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x0698e = "A string claiming to be in UTF-16 is incorrectly encoded." */
    'A',' ','\xf0','c','l','a','i','m','i','n','g',' ','\x0a','\xa8','\x0f','U','T','F','-','1','6',' ','\x0b','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x069b9 = "Partition mapping table is shorted than described." */
    'P','a','r','t','i','t','i','o','n',' ','m','a','p','p','i','n','g',' ','\xb1','\x0b','s','h','o','r','t','e','d',' ','t','h','a','n',' ','d','e','s','c','r','i','b','e','d','.',
/* 0x069e4 = "Reason for leaving RC: Guest tried to write to our GDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','G','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06a0f = "RTGetOpt: Command line option needs an index." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','\x87','i','n','d','e','x','.',
/* 0x06a3a = "Another thread in the session is talking to the tracer." */
    'A','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','\x0f','\x02','s','e','s','s','i','o','n',' ','\x0b','t','a','l','k','i','n','g',' ','\x0a','\x02','t','r','a','c','e','r','.',
/* 0x06a65 = "No \'Type\' attribute in the DrvBlock configuration." */
    '\xe6','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0f','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x06a90 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_GET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','G','E','T','_','T','A','G',' ','\x7d',
/* 0x06abb = "Mismatching VM structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xcc',' ','\xea','s','i','z','e',' ','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x99','V','B','o','x','V','M','M','.',
/* 0x06ae6 = "An unexpected (/unknown) exception was caught." */
    'A','n',' ','u','n','e','x','p','e','c','t','e','d',' ','(','/','u','n','k','n','o','w','n',')',' ','e','x','c','e','p','t','i','o','n',' ','\x11','c','a','u','g','h','t','.',
/* 0x06b11 = "Someone is trying to skip backwards in the stream..." */
    'S','o','m','e','o','n','e',' ','\x0b','t','r','y','i','n','g',' ','\x0a','s','k','i','p',' ','b','a','c','k','w','a','r','d','s',' ','\x0f','\x02','s','t','r','e','a','m','.','.','.',
/* 0x06b3c = "A bad trap type ended up in mmGCRamTrap0eHandler." */
    'A',' ','b','a','d',' ','t','r','a','p',' ','\xf1','e','n','d','e','d',' ','u','p',' ','\x0f','m','m','G','C','R','a','m','T','r','a','p','0','e','H','a','n','d','l','e','r','.',
/* 0x06b67 = "Unable to locate a usable DMG file within the XAR archive." */
    '\xde','\x0a','l','o','c','a','t','e',' ','a',' ','u','s','a','b','l','e',' ','D','M','G',' ','\x1f','w','i','t','h','i','n',' ','\x02','X','A','R',' ','a','r','c','h','i','v','e','.',
/* 0x06b92 = "Address family not supported by protocol family." */
    'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','.',
/* 0x06bbd = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_SET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','S','E','T','_','T','A','G',' ','\x7d',
/* 0x06be8 = "The maximum posts for the event semaphore has been reached." */
    '\x03','m','a','x','i','m','u','m',' ','p','o','s','t','s',' ','\x10','\x02','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x06c13 = "Reason for leaving RC: Guest tried to write to our IDT - fatal." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','w','r','i','t','e',' ','\x0a','o','u','r',' ','I','D','T',' ','-',' ','f','a','t','a','l','.',
/* 0x06c3e = "The image file is not owned by TrustedInstaller is it should be." */
    '\x03','\x25','\x1f','\x0b','\x08','o','w','n','e','d',' ','\xdf','T','r','u','s','t','e','d','I','n','s','t','a','l','l','e','r',' ','\x0b','i','t',' ','s','h','o','u','l','d',' ','b','e','.',
/* 0x06c69 = "Image Verification Failure: Raw data offsets and sizes are out of range." */
    'I','m','a','g','e',' ','\x0d','\x12','R','a','w',' ','\x9c','o','f','f','s','e','t','s',' ','\x99','s','i','z','e','s',' ','a','r','e',' ','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x06c94 = "Maximum number of Shared Clipboard lists has been reached." */
    'M','a','x','i','m','u','m',' ','\xf9','\x15','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t','s',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x06cbf = "Too many digest algorithms used by PKCS #7 signed data." */
    'T','o','o',' ','\xb4','\xd6','a','l','g','o','r','i','t','h','m','s',' ','u','s','e','d',' ','\xdf','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x06cea = "VFS chain element only provides I/O stream (ios) objects." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x06d15 = "VFS chain element takes a file system stream (fss) object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x1f','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x06d40 = "Invalid effective segment register number passed to an IEM function." */
    '\x0c','e','f','f','e','c','t','i','v','e',' ','s','e','g','m','e','n','t',' ','\xe9','\xf9','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x06d6b = "The process trying to open VBoxDrv is not a budding VM process (2)." */
    '\x03','\x92','t','r','y','i','n','g',' ','\x0a','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x0b','\x08','a',' ','b','u','d','d','i','n','g',' ','\xcc',' ','\x92','(','2',')','.',
/* 0x06d95 = "RTGetOpt: Command line option not recognized." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x08','r','e','c','o','g','n','i','z','e','d','.',
/* 0x06dbf = "Constructed string is not according to the encoding rules." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xf0','\x0b','\x08','a','c','c','o','r','d','i','n','g',' ','\x0a','\x02','e','n','c','o','d','i','n','g',' ','r','u','l','e','s','.',
/* 0x06de9 = "Do not know how to handle the content type in the server response." */
    'D','o',' ','\x08','k','n','o','w',' ','h','o','w',' ','\x0a','h','a','n','d','l','e',' ','\x02','\xed','\xf1','\x0f','\x02','s','e','r','v','e','r',' ','r','e','s','p','o','n','s','e','.',
/* 0x06e13 = "An unknown config node (key) was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','n','o','d','e',' ','(','k','e','y',')',' ','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x06e3d = "Command format (or reserved bits) invalid." */
    'C','o','m','m','a','n','d',' ','f','o','r','m','a','t',' ','(','o','r',' ','r','e','s','e','r','v','e','d',' ','b','i','t','s',')',' ','i','n','v','a','l','i','d','.',
/* 0x06e67 = "The hash function in the header doesn't match the one in the table of content." */
    '\x03','h','a','s','h',' ','f','u','n','c','t','i','o','n',' ','\x0f','\x02','\xb3','\xc7','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x06e91 = "OpenSSL and IPRT disagree on the signature size." */
    'O','p','e','n','S','S','L',' ','\x99','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e',' ','s','i','z','e','.',
/* 0x06ebb = "The Mach-O header is bad or contains new and unsupported features." */
    '\x03','M','a','c','h','-','O',' ','\xb3','\x0b','b','a','d',' ','\xa9','\x8a','n','e','w',' ','\x99','u','n','s','u','p','p','o','r','t','e','d',' ','f','e','a','t','u','r','e','s','.',
/* 0x06ee5 = "Process Verification Failure: An image is targeting an unexpected machine/CPU." */
    '\x1e','\x0d','\x12','A','n',' ','\x25','\x0b','t','a','r','g','e','t','i','n','g',' ','\x87','u','n','e','x','p','e','c','t','e','d',' ','m','a','c','h','i','n','e','/','C','P','U','.',
/* 0x06f0f = "Service will execute the command in background." */
    'S','e','r','v','i','c','e',' ','w','i','l','l',' ','e','x','e','c','u','t','e',' ','\x02','c','o','m','m','a','n','d',' ','\x0f','b','a','c','k','g','r','o','u','n','d','.',
/* 0x06f39 = "File set descriptor has an zero length or invalid root dir extent." */
    'F','i','l','e',' ','s','e','t',' ','\xee','\x7b','\x87','z','e','r','o',' ','l','e','n','g','t','h',' ','\xa9','\x8f','r','o','o','t',' ','d','i','r',' ','e','x','t','e','n','t','.',
/* 0x06f63 = "String is not terminated within the buffer bounds." */
    'S','t','r','i','n','g',' ','\x0b','\x08','t','e','r','m','i','n','a','t','e','d',' ','w','i','t','h','i','n',' ','\x02','b','u','f','f','e','r',' ','b','o','u','n','d','s','.',
/* 0x06f8d = "The GIM device is not registered with GIM when it ought to be." */
    '\x03','G','I','M',' ','\xa3','\x0b','\x08','r','e','g','i','s','t','e','r','e','d',' ','\x80','G','I','M',' ','w','h','e','n',' ','i','t',' ','o','u','g','h','t',' ','\x0a','b','e','.',
/* 0x06fb7 = "Too many partition maps in the logical volume descriptor." */
    'T','o','o',' ','\xb4','p','a','r','t','i','t','i','o','n',' ','m','a','p','s',' ','\x0f','\x02','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x06fe1 = "Too many arguments passed to a VM request / request corruption." */
    'T','o','o',' ','\xb4','a','r','g','u','m','e','n','t','s',' ','p','a','s','s','e','d',' ','\x0a','a',' ','\xcc',' ','\xaa','/',' ','\xaa','c','o','r','r','u','p','t','i','o','n','.',
/* 0x0700b = "Recompiler: Failed to reconcile the register/variable state on endif." */
    '\x13','\x8b','\x0a','r','e','c','o','n','c','i','l','e',' ','\x02','r','e','g','i','s','t','e','r','/','v','a','r','i','a','b','l','e',' ','\xcd','o','n',' ','e','n','d','i','f','.',
/* 0x07035 = "The EMT was not busy running guest code at the time of the call." */
    '\x03','E','M','T',' ','\x11','\x08','b','u','s','y',' ','r','u','n','n','i','n','g',' ','\xbb','c','o','d','e',' ','a','t',' ','\x02','t','i','m','e',' ','\x15','\x02','c','a','l','l','.',
/* 0x0705f = "Unable to find partition descriptor for a partition map table entry." */
    '\xde','\x0a','f','i','n','d',' ','p','a','r','t','i','t','i','o','n',' ','\xee','\x10','a',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb1','e','n','t','r','y','.',
/* 0x07089 = "The DTB being parsed has an invalid strings block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','\x87','\x8f','s','t','r','i','n','g','s',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x070b3 = "Failed to convert the specified Guest IP to a binary IP address." */
    '\x8b','\x0a','c','o','n','v','e','r','t',' ','\x02','\x18','G','u','e','s','t',' ','I','P',' ','\x0a','a',' ','b','i','n','a','r','y',' ','I','P',' ','a','d','d','r','e','s','s','.',
/* 0x070dd = "The process trying to open VBoxDrv is not a budding VM process (1)." */
    '\x03','\x92','t','r','y','i','n','g',' ','\x0a','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x0b','\x08','a',' ','b','u','d','d','i','n','g',' ','\xcc',' ','\x92','(','1',')','.',
/* 0x07107 = "No pending request the aio context has to wait for completion." */
    '\xe6','p','e','n','d','i','n','g',' ','\xaa','\x02','a','i','o',' ','c','o','n','t','e','x','t',' ','\x7b','\x0a','w','a','i','t',' ','\x10','c','o','m','p','l','e','t','i','o','n','.',
/* 0x07131 = "Recompiled execution: Jump back in the same TB." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','J','u','m','p',' ','b','a','c','k',' ','\x0f','\x02','s','a','m','e',' ','T','B','.',
/* 0x0715b = "Process Verification Failure: Error allocating state memory or querying the system32 path." */
    '\x1e','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\xcd','\x85','\xa9','q','u','e','r','y','i','n','g',' ','\x02','s','y','s','t','e','m','3','2',' ','p','a','t','h','.',
/* 0x07185 = "The server did not understand the request due to bad syntax." */
    '\x03','s','e','r','v','e','r',' ','d','i','d',' ','\x08','u','n','d','e','r','s','t','a','n','d',' ','\x02','\xaa','d','u','e',' ','\x0a','b','a','d',' ','s','y','n','t','a','x','.',
/* 0x071af = "Not all of the requested CPUs showed up in the PFNRTMPWORKER." */
    'N','o','t',' ','a','l','l',' ','\x15','\x02','\xdd','C','P','U','s',' ','s','h','o','w','e','d',' ','u','p',' ','\x0f','\x02','P','F','N','R','T','M','P','W','O','R','K','E','R','.',
/* 0x071d9 = "The provider is only allowed as the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\x0b','o','n','l','y',' ','a','l','l','o','w','e','d',' ','a','s',' ','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x07203 = "Syntax error - the argument does not allow a range to be specified." */
    '\xf7','\x09','-',' ','\x02','a','r','g','u','m','e','n','t',' ','\xb2','\x08','a','l','l','o','w',' ','a',' ','r','a','n','g','e',' ','\x0a','\xa8','s','p','e','c','i','f','i','e','d','.',
/* 0x0722d = "The size field should be zero for links and symlinks." */
    '\x03','s','i','z','e',' ','f','i','e','l','d',' ','s','h','o','u','l','d',' ','\xa8','z','e','r','o',' ','\x10','l','i','n','k','s',' ','\x99','s','y','m','l','i','n','k','s','.',
/* 0x07257 = "The DTB being parsed has an invalid last compatible version set." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','\x87','\x8f','l','a','s','t',' ','c','o','m','p','a','t','i','b','l','e',' ','\xcf','s','e','t','.',
/* 0x07281 = "The ELF loader didn\'t find the symbol/string table for the image." */
    '\x03','E','L','F',' ','\xd8','d','i','d','n','\'','t',' ','f','i','n','d',' ','\x02','s','y','m','b','o','l','/','s','t','r','i','n','g',' ','\xb1','\x10','\x02','i','m','a','g','e','.',
/* 0x072ab = "The table of content (TOC) is too small and therefore can\'t be valid." */
    '\x03','\xb1','\x15','\xed','(','T','O','C',')',' ','\x0b','\xa0','s','m','a','l','l',' ','\x99','t','h','e','r','e','f','o','r','e',' ','c','a','n','\'','t',' ','\xa8','v','a','l','i','d','.',
/* 0x072d5 = "The field does not follow immediately the previous one." */
    '\x03','f','i','e','l','d',' ','\xb2','\x08','f','o','l','l','o','w',' ','i','m','m','e','d','i','a','t','e','l','y',' ','\x02','p','r','e','v','i','o','u','s',' ','o','n','e','.',
/* 0x072ff = "No line number was found for the specified address/ordinal/whatever." */
    '\xe6','l','i','n','e',' ','\xf9','\x11','f','o','u','n','d',' ','\x10','\x02','\x18','a','d','d','r','e','s','s','/','o','r','d','i','n','a','l','/','w','h','a','t','e','v','e','r','.',
/* 0x07329 = "Process Verification Failure: Found executable memory allocated in the process." */
    '\x1e','\x0d','\x12','F','o','u','n','d',' ','e','x','e','c','u','t','a','b','l','e',' ','\x85','a','l','l','o','c','a','t','e','d',' ','\x0f','\x02','p','r','o','c','e','s','s','.',
/* 0x07352 = "VFS chain element takes a file or I/O stream (ios) object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x1f','\xa9','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x0737b = "(One) send buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','s','e','n','d',' ','b','u','f','f','e','r',' ','\x11','\xa0','s','m','a','l','l',',',' ','\xa9','\xa0','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x073a4 = "The initialization of the dynamic mapping cache failed." */
    '\x03','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x15','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x7d',
/* 0x073cd = "Something is not available or not working properly." */
    'S','o','m','e','t','h','i','n','g',' ','\x0b','\x08','a','v','a','i','l','a','b','l','e',' ','\xa9','\x08','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y','.',
/* 0x073f6 = "Certificate cannot be authenticated with the given CA certificates." */
    '\xba','\xe0','\xa8','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','\x80','\x02','g','i','v','e','n',' ','C','A',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0741f = "Import ISO contains an unsupported supplementary volume descriptor version." */
    '\xc3','\xc1',' ','\x8a','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd1','\xee','v','e','r','s','i','o','n','.',
/* 0x07448 = "The native file handle got stale while it was open." */
    '\x03','n','a','t','i','v','e',' ','\x1f','h','a','n','d','l','e',' ','g','o','t',' ','s','t','a','l','e',' ','w','h','i','l','e',' ','i','t',' ','\x11','o','p','e','n','.',
/* 0x07471 = "Expected PKCS #7 object to ship at least one certificate." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa7','\x0a','s','h','i','p',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0749a = "A boot catalog entry in the import ISO is using the unused field." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x0b','u','s','i','n','g',' ','\x02','u','n','u','s','e','d',' ','f','i','e','l','d','.',
/* 0x074c3 = "Return to ring-3 to perform the hypercall there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','p','e','r','f','o','r','m',' ','\x02','h','y','p','e','r','c','a','l','l',' ','t','h','e','r','e','.',
/* 0x074ec = "The request wasn\'t submitted so it can\'t be canceled." */
    '\x03','\xaa','w','a','s','n','\'','t',' ','s','u','b','m','i','t','t','e','d',' ','s','o',' ','i','t',' ','c','a','n','\'','t',' ','\xa8','c','a','n','c','e','l','e','d','.',
/* 0x07515 = "A numeric conversion encountered a value which was too big for the target." */
    'A',' ','n','u','m','e','r','i','c',' ','c','o','n','v','e','r','s','i','o','n',' ','\xae','a',' ','\xfa','\xeb','\x11','\xa0','b','i','g',' ','\x10','\x02','t','a','r','g','e','t','.',
/* 0x0753e = "The field contains an invalid callback or transformation index." */
    '\x03','f','i','e','l','d',' ','\x8a','\x87','\x8f','c','a','l','l','b','a','c','k',' ','\xa9','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','i','n','d','e','x','.',
/* 0x07567 = "Process Verification Failure: One of the section in the image file is not fully mapped into memory." */
    '\x1e','\x0d','\x12','O','n','e',' ','\x15','\x02','\xda','\x0f','\x02','\x25','\x1f','\x0b','\x08','f','u','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x07590 = "The table of content string length didn\'t match the size specified in the header." */
    '\x03','\xb1','\x15','\xed','\xf0','l','e','n','g','t','h',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','s','i','z','e',' ','\x18','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x075b9 = "The DTB structs block contains an unterminated string." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','\x87','u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x075e2 = "Reason for leaving RC: A privileged instruction was attempted executed." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','p','r','i','v','i','l','e','g','e','d',' ','\xd9','\x11','a','t','t','e','m','p','t','e','d',' ','e','x','e','c','u','t','e','d','.',
/* 0x0760b = "The DTB being parsed has an invalid struct block offset." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','\x87','\x8f','s','t','r','u','c','t',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x07634 = "Indicating that a rescheduling now is required." */
    'I','n','d','i','c','a','t','i','n','g',' ','\xac','a',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','n','o','w',' ','\x0b','r','e','q','u','i','r','e','d','.',
/* 0x0765d = "Address conflict within a module/segment." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t',' ','w','i','t','h','i','n',' ','a',' ','m','o','d','u','l','e','/','s','e','g','m','e','n','t','.',
/* 0x07686 = "Key algorithm parameters are required but missing." */
    'K','e','y',' ','\xd3','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','m','i','s','s','i','n','g','.',
/* 0x076af = "The GIM provider does not support any paravirtualized TSC." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\xb2','\x08','\xce','a','n','y',' ','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x076d8 = "The user mode tracepoint provider string table is too large." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xf0','\xb1','\x0b','\xa0','l','a','r','g','e','.',
/* 0x07701 = "Malformed extended allocation descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','e','x','t','e','n','d','e','d',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0772a = "The saved state file size didn\'t match the one in the header." */
    '\x03','s','a','v','e','d',' ','\xcd','\x1f','s','i','z','e',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x07753 = "Get register caller must flush the TLB (not an error)." */
    'G','e','t',' ','\xe9','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B',' ','(','n','o','t',' ','\x87','e','r','r','o','r',')','.',
/* 0x0777c = "Node pointer is not within the memory allocated for nodes." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x0b','\x08','w','i','t','h','i','n',' ','\x02','\x85','a','l','l','o','c','a','t','e','d',' ','\x10','n','o','d','e','s','.',
/* 0x077a5 = "The requested operation cannot be performed because the device is currently being reset." */
    '\x03','\xdd','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d',' ','\x40','\x02','\xa3','\x0b','c','u','r','r','e','n','t','l','y',' ','b','e','i','n','g',' ','r','e','s','e','t','.',
/* 0x077ce = "Couldn\'t find ROM range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','r','a','n','g','e',' ','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x077f7 = "No digest algorithms listed in PKCS #7 signed data." */
    '\xe6','\xd6','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d',' ','\x0f','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x07820 = "The CSAM is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','C','S','A','M',' ','\x0b','\x08','u','s','e','d',' ','\x40','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x99','V','T','-','x','/','A','M','D','-','V','.',
/* 0x07849 = "PKIX cipher algorithm parameters are not implemented." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd3','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07872 = "Reason for leaving RC: CSAM wants perform a task in ring-3." */
    '\x93','\x10','\x81','R','C',':',' ','C','S','A','M',' ','w','a','n','t','s',' ','p','e','r','f','o','r','m',' ','a',' ','t','a','s','k',' ','\x0f','r','i','n','g','-','3','.',
/* 0x0789b = "An attempt was made to grow an already maxed out page pool." */
    'A','n',' ','a','t','t','e','m','p','t',' ','\x11','m','a','d','e',' ','\x0a','g','r','o','w',' ','\x87','\x7f','m','a','x','e','d',' ','o','u','t',' ','\xcb','p','o','o','l','.',
/* 0x078c4 = "A string claiming to be UTF-8 is incorrectly encoded." */
    'A',' ','\xf0','c','l','a','i','m','i','n','g',' ','\x0a','\xa8','U','T','F','-','8',' ','\x0b','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x078ed = "Reason for leaving RC: Guest trap which couldn\'t be handled in RC." */
    '\x93','\x10','\x81','R','C',':',' ','G','u','e','s','t',' ','t','r','a','p',' ','\xeb','c','o','u','l','d','n','\'','t',' ','\xa8','h','a','n','d','l','e','d',' ','\x0f','R','C','.',
/* 0x07916 = "The algorithms part of the DEK-Info field is too long." */
    '\x03','a','l','g','o','r','i','t','h','m','s',' ','p','a','r','t',' ','\x15','\x02','D','E','K','-','I','n','f','o',' ','f','i','e','l','d',' ','\x0b','\xa0','l','o','n','g','.',
/* 0x0793f = "The page to be updated or freed was noted owned by the caller." */
    '\x03','\xcb','\x0a','\xa8','u','p','d','a','t','e','d',' ','\xa9','f','r','e','e','d',' ','\x11','n','o','t','e','d',' ','o','w','n','e','d',' ','\xdf','\x02','c','a','l','l','e','r','.',
/* 0x07968 = "The Host Interface Networking init program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','i','n','i','t',' ','p','r','o','g','r','a','m',' ','\x7d',
/* 0x07991 = "The name of the module clashed with an existing module." */
    '\x03','n','a','m','e',' ','\x15','\x02','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','\x80','\x87','e','x','i','s','t','i','n','g',' ','m','o','d','u','l','e','.',
/* 0x079ba = "The encrypted digest algorithm does not match the one in the certificate." */
    '\x03','e','n','c','r','y','p','t','e','d',' ','\xd6','\xd3','\xb2','\x08','m','a','t','c','h',' ','\x02','o','n','e',' ','\x0f','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x079e2 = "No more handles available, too many open handles." */
    '\xe6','m','o','r','e',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e',',',' ','\xa0','\xb4','o','p','e','n',' ','h','a','n','d','l','e','s','.',
/* 0x07a0a = "Level 2 lookup failed because the L1 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x98','\x40','\x02','L','1',' ','l','o','o','k','u','p',' ','\xb1','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x07a32 = "VFS chain element only provides file system (vfs) objects." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x07a5a = "Recompiler: Wrong jump instruction targeting label at end of TB." */
    '\x13','W','r','o','n','g',' ','j','u','m','p',' ','\xd9','t','a','r','g','e','t','i','n','g',' ','l','a','b','e','l',' ','a','t',' ','e','n','d',' ','\x15','T','B','.',
/* 0x07a82 = "Couldn\'t find any USB hubs to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','U','S','B',' ','h','u','b','s',' ','\x0a','a','t','t','a','c','h',' ','\x02','\xa3','t','o','.',
/* 0x07aaa = "VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','M','A','L','F','O','R','M','E','D','_','P','A','D','D','I','N','G',
/* 0x07ad2 = "Optional header magic and target machine does not match." */
    'O','p','t','i','o','n','a','l',' ','\xb3','m','a','g','i','c',' ','\x99','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','\xb2','\x08','m','a','t','c','h','.',
/* 0x07afa = "Missing ciper parameters for encrypted key." */
    'M','i','s','s','i','n','g',' ','c','i','p','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x10','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x07b22 = "Reason for leaving RC: duplicate instruction called at current eip." */
    '\x93','\x10','\x81','R','C',':',' ','d','u','p','l','i','c','a','t','e',' ','\xd9','c','a','l','l','e','d',' ','a','t',' ','c','u','r','r','e','n','t',' ','e','i','p','.',
/* 0x07b4a = "A Shared Clipboard list handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t',' ','h','a','n','d','l','e',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x07b72 = "Both debug and non-debug sections in segment." */
    'B','o','t','h',' ','d','e','b','u','g',' ','\x99','n','o','n','-','d','e','b','u','g',' ','s','e','c','t','i','o','n','s',' ','\x0f','s','e','g','m','e','n','t','.',
/* 0x07b9a = "Tried to resume a VM or CPU that is already fully running." */
    'T','r','i','e','d',' ','\x0a','r','e','s','u','m','e',' ','a',' ','\xcc',' ','\xa9','C','P','U',' ','\xac','\x0b','\x7f','f','u','l','l','y',' ','r','u','n','n','i','n','g','.',
/* 0x07bc2 = "VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','N','O','D','E','_','N','A','M','E','_','I','N','V','A','L','I','D',
/* 0x07bea = "The VFS chain specification does not have a valid prefix." */
    '\x03','\x8d',' ','\x9f','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\xb2','\x08','h','a','v','e',' ','a',' ','v','a','l','i','d',' ','p','r','e','f','i','x','.',
/* 0x07c12 = "The OS does not support changing the owner of a symbolic link." */
    '\x03','O','S',' ','\xb2','\x08','\xce','c','h','a','n','g','i','n','g',' ','\x02','o','w','n','e','r',' ','\x15','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x07c3a = "The PE loader encountered some Guard CF stuff in the load config." */
    '\x03','P','E',' ','\xd8','\xae','s','o','m','e',' ','G','u','a','r','d',' ','C','F',' ','s','t','u','f','f',' ','\x0f','\x02','l','o','a','d',' ','c','o','n','f','i','g','.',
/* 0x07c62 = "The Host Interface Networking device name is too long." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\xa3','n','a','m','e',' ','\x0b','\xa0','l','o','n','g','.',
/* 0x07c8a = "The internal application does not reside in the correct place (hardening)." */
    '\x03','\x17','a','p','p','l','i','c','a','t','i','o','n',' ','\xb2','\x08','r','e','s','i','d','e',' ','\x0f','\x02','c','o','r','r','e','c','t',' ','p','l','a','c','e',' ','\xad',
/* 0x07cb2 = "Unable to allocate more pages from the host system." */
    '\xde','\x0a','a','l','l','o','c','a','t','e',' ','m','o','r','e',' ','p','a','g','e','s',' ','f','r','o','m',' ','\x02','h','o','s','t',' ','s','y','s','t','e','m','.',
/* 0x07cda = "Cannot resolve symbol because it\'s a forwarder." */
    'C','a','n','n','o','t',' ','r','e','s','o','l','v','e',' ','s','y','m','b','o','l',' ','\x40','i','t','\'','s',' ','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x07d02 = "VMXON failed; possibly because it was already run before." */
    'V','M','X','O','N',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x40','i','t',' ','\x11','\x7f','r','u','n',' ','b','e','f','o','r','e','.',
/* 0x07d2a = "Invalid VMCS pointer passed to VMLAUNCH/VMRESUME." */
    '\x0c','V','M','C','S',' ','p','o','i','n','t','e','r',' ','p','a','s','s','e','d',' ','\x0a','V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E','.',
/* 0x07d52 = "Raw-mode is unavailable courtesy of Hyper-V." */
    'R','a','w','-','m','o','d','e',' ','\x0b','u','n','a','v','a','i','l','a','b','l','e',' ','c','o','u','r','t','e','s','y',' ','\x15','H','y','p','e','r','-','V','.',
/* 0x07d7a = "NEM is missing a require feature in the host API." */
    '\xec',' ','\x0b','m','i','s','s','i','n','g',' ','a',' ','r','e','q','u','i','r','e',' ','f','e','a','t','u','r','e',' ','\x0f','\x02','h','o','s','t',' ','A','P','I','.',
/* 0x07da2 = "Failed to fix mappings because the proposed memory area was to small." */
    '\x8b','\x0a','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x40','\x02','p','r','o','p','o','s','e','d',' ','\x85','a','r','e','a',' ','\x11','\x0a','s','m','a','l','l','.',
/* 0x07dca = "A guest control object has changed its overall status." */
    'A',' ','\xbb','c','o','n','t','r','o','l',' ','\xa7','\x7b','c','h','a','n','g','e','d',' ','i','t','s',' ','o','v','e','r','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x07df2 = "The path of a new node contained slashes or was empty." */
    '\x03','\xd0','\x15','a',' ','n','e','w',' ','n','o','d','e',' ','c','o','n','t','a','i','n','e','d',' ','s','l','a','s','h','e','s',' ','\xa9','\x11','e','m','p','t','y','.',
/* 0x07e1a = "The called method does not work with the value type of the given JSON value." */
    '\x03','c','a','l','l','e','d',' ','m','e','t','h','o','d',' ','\xb2','\x08','w','o','r','k',' ','\x80','\x02','\xfa','\xf1','\x15','\x02','g','i','v','e','n',' ','J','S','O','N',' ','\xf3',
/* 0x07e42 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','W','I','T','H','_','N','O','N','E',
/* 0x07e6a = "The segment bits are non-contiguous in the file." */
    '\x03','s','e','g','m','e','n','t',' ','b','i','t','s',' ','a','r','e',' ','n','o','n','-','c','o','n','t','i','g','u','o','u','s',' ','\x0f','\x02','f','i','l','e','.',
/* 0x07e92 = "The given range does not meet the required alignment." */
    '\x03','g','i','v','e','n',' ','r','a','n','g','e',' ','\xb2','\x08','m','e','e','t',' ','\x02','r','e','q','u','i','r','e','d',' ','a','l','i','g','n','m','e','n','t','.',
/* 0x07eba = "Level 2 lookup failed because the L2 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x98','\x40','\x02','L','2',' ','l','o','o','k','u','p',' ','\xb1','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x07ee2 = "Reason for leaving RC: jump inside generated patch jump." */
    '\x93','\x10','\x81','R','C',':',' ','j','u','m','p',' ','i','n','s','i','d','e',' ','g','e','n','e','r','a','t','e','d',' ','p','a','t','c','h',' ','j','u','m','p','.',
/* 0x07f0a = "The requested operation cannot be performed on a detached USB device." */
    '\x03','\xdd','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d',' ','o','n',' ','a',' ','d','e','t','a','c','h','e','d',' ','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x07f32 = "PGM pool flush pending - return to ring 3." */
    'P','G','M',' ','p','o','o','l',' ','f','l','u','s','h',' ','p','e','n','d','i','n','g',' ','-',' ','r','e','t','u','r','n',' ','\x0a','r','i','n','g',' ','3','.',
/* 0x07f5a = "The default boot catalog entry in the import ISO has invalid flags set." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','\x8f','f','l','a','g','s',' ','s','e','t','.',
/* 0x07f81 = "VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST" */
    '\x01','V','M','M','D','E','V','_','C','P','U','_','H','O','T','P','L','U','G','_','\x06','M','O','N','I','T','O','R','E','D','_','B','Y','_','G','U','E','S','T',
/* 0x07fa8 = "Import ISO contains more than one el torito descriptor." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','e','l',' ','t','o','r','i','t','o',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x07fcf = "Process Verification Failure: Executable file name and process image name does not match up." */
    '\x1e','\x0d','\x12','E','x','e','c','u','t','a','b','l','e',' ','\x1f','n','a','m','e',' ','\x99','\x92','\x25','n','a','m','e',' ','\xb2','\x08','m','a','t','c','h',' ','u','p','.',
/* 0x07ff6 = "The requested operation cannot be performed because the device is currently suspended." */
    '\x03','\xdd','\x96','\xe0','\xa8','p','e','r','f','o','r','m','e','d',' ','\x40','\x02','\xa3','\x0b','c','u','r','r','e','n','t','l','y',' ','s','u','s','p','e','n','d','e','d','.',
/* 0x0801d = "A boot catalog entry in the import ISO has reserved flag set." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','r','e','s','e','r','v','e','d',' ','f','l','a','g',' ','s','e','t','.',
/* 0x08044 = "Attempted socket operation with a non-socket handle." */
    'A','t','t','e','m','p','t','e','d',' ','s','o','c','k','e','t',' ','\x96','\x80','a',' ','n','o','n','-','s','o','c','k','e','t',' ','h','a','n','d','l','e','.',
/* 0x0806b = "AMD-V CPU extension disabled (by BIOS)." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','y',' ','B','I','O','S',')','.',
/* 0x08092 = "Reason for leaving RC: pending irq after iret that sets IF." */
    '\x93','\x10','\x81','R','C',':',' ','p','e','n','d','i','n','g',' ','i','r','q',' ','a','f','t','e','r',' ','i','r','e','t',' ','\xac','s','e','t','s',' ','I','F','.',
/* 0x080b9 = "Unique issuer and subject IDs require version certificate 2." */
    'U','n','i','q','u','e',' ','i','s','s','u','e','r',' ','\x99','s','u','b','j','e','c','t',' ','I','D','s',' ','r','e','q','u','i','r','e',' ','\xcf','\x9e','2','.',
/* 0x080e0 = "PKCS #7 signed data has no digest algorithms listed." */
    'P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x9c','\x7b','n','o',' ','\xd6','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d','.',
/* 0x08107 = "Expected PKCS #7 object to ship the signer certificate(s)." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa7','\x0a','s','h','i','p',' ','\x02','s','i','g','n','e','r',' ','c','e','r','t','i','f','i','c','a','t','e','(','s',')','.',
/* 0x0812e = "The specified MMIO range was owned by some other device(s)." */
    '\x03','\x18','\xd2',' ','r','a','n','g','e',' ','\x11','o','w','n','e','d',' ','\xdf','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',
/* 0x08155 = "Return instigated by a callback or similar." */
    'R','e','t','u','r','n',' ','i','n','s','t','i','g','a','t','e','d',' ','\xdf','a',' ','c','a','l','l','b','a','c','k',' ','\xa9','s','i','m','i','l','a','r','.',
/* 0x0817c = "Process Verification Failure: Expected the process and exe to advertise NX compatibility." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x99','e','x','e',' ','\x0a','a','d','v','e','r','t','i','s','e',' ','N','X',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','.',
/* 0x081a3 = "Signed data verification failed because there are zero signer infos." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','\x40','t','h','e','r','e',' ','a','r','e',' ','z','e','r','o',' ','s','i','g','n','e','r',' ','i','n','f','o','s','.',
/* 0x081ca = "The ELF loader cannot handle multiple SYMTAB sections." */
    '\x03','E','L','F',' ','\xd8','\xe0','h','a','n','d','l','e',' ','m','u','l','t','i','p','l','e',' ','S','Y','M','T','A','B',' ','s','e','c','t','i','o','n','s','.',
/* 0x081f1 = "Virtual machine error occurred attempting the operation." */
    'V','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\x09','o','c','c','u','r','r','e','d',' ','a','t','t','e','m','p','t','i','n','g',' ','\x02','\xe8',
/* 0x08218 = "Indefinite length form is against the rules." */
    'I','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','f','o','r','m',' ','\x0b','a','g','a','i','n','s','t',' ','\x02','r','u','l','e','s','.',
/* 0x0823f = "Reason for leaving RC: Interrupted by external interrupt." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xdf','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x08266 = "A PDMThread API was called by the wrong thread." */
    'A',' ','P','D','M','T','h','r','e','a','d',' ','A','P','I',' ','\x11','c','a','l','l','e','d',' ','\xdf','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x0828d = "Failed to retrieve underlying (lower mac) link." */
    '\x8b','\x0a','r','e','t','r','i','e','v','e',' ','u','n','d','e','r','l','y','i','n','g',' ','(','l','o','w','e','r',' ','m','a','c',')',' ','l','i','n','k','.',
/* 0x082b4 = "Mismatching VM structure version between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xcc',' ','\xea','\xcf','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x99','V','B','o','x','V','M','M','.',
/* 0x082db = "The value is not a zero terminated character string." */
    '\x03','\xfa','\x0b','\x08','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','.',
/* 0x08302 = "Internal ISO maker error: Inconsistency produing trans." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','I','n','c','o','n','s','i','s','t','e','n','c','y',' ','p','r','o','d','u','i','n','g',' ','t','r','a','n','s','.',
/* 0x08329 = "Internal error in the lock validator or related components." */
    '\x07','\x09','\x0f','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','\xa9','r','e','l','a','t','e','d',' ','c','o','m','p','o','n','e','n','t','s','.',
/* 0x08350 = "A boot catalog entry in the import ISO has an invalid boot media type." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','\x87','\x8f','b','o','o','t',' ','m','e','d','i','a',' ','t','y','p','e','.',
/* 0x08377 = "The command cannot be deregistered because has not been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\xe0','\xa8','d','e','r','e','g','i','s','t','e','r','e','d',' ','\x40','\x7b','\x08','\xca','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0839e = "VMX CPU extension not available in hardware." */
    'V','M','X',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x08','a','v','a','i','l','a','b','l','e',' ','\x0f','h','a','r','d','w','a','r','e','.',
/* 0x083c5 = "The symbol size was adjusted while adding it." */
    '\x03','s','y','m','b','o','l',' ','s','i','z','e',' ','\x11','a','d','j','u','s','t','e','d',' ','w','h','i','l','e',' ','a','d','d','i','n','g',' ','i','t','.',
/* 0x083ec = "Too many ICB indirections, possibly a loop." */
    'T','o','o',' ','\xb4','I','C','B',' ','i','n','d','i','r','e','c','t','i','o','n','s',',',' ','p','o','s','s','i','b','l','y',' ','a',' ','l','o','o','p','.',
/* 0x08413 = "Misaligned read/write critical section." */
    'M','i','s','a','l','i','g','n','e','d',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0843a = "Pending exception; continue guest execution." */
    'P','e','n','d','i','n','g',' ','e','x','c','e','p','t','i','o','n',';',' ','c','o','n','t','i','n','u','e',' ','\xbb','e','x','e','c','u','t','i','o','n','.',
/* 0x08461 = "The async completion template is still used." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','e','m','p','l','a','t','e',' ','\x0b','s','t','i','l','l',' ','u','s','e','d','.',
/* 0x08488 = "The virtual clock frequency differs too much." */
    '\x03','v','i','r','t','u','a','l',' ','c','l','o','c','k',' ','f','r','e','q','u','e','n','c','y',' ','d','i','f','f','e','r','s',' ','\xa0','m','u','c','h','.',
/* 0x084af = "The timer can\'t be stopped because it\'s already suspended." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\xa8','s','t','o','p','p','e','d',' ','\x40','i','t','\'','s',' ','\x7f','s','u','s','p','e','n','d','e','d','.',
/* 0x084d6 = "Certificate path validator: Invalid policy mapping (to/from anyPolicy)." */
    '\xba','\xd0','\xfd','\x0c','p','o','l','i','c','y',' ','m','a','p','p','i','n','g',' ','(','t','o','/','f','r','o','m',' ','a','n','y','P','o','l','i','c','y',')','.',
/* 0x084fd = "The guest bit mask didn\'t match the guest being loaded." */
    '\x03','\xbb','b','i','t',' ','m','a','s','k',' ','d','i','d','n','\'','t',' ','m','a','t','c','h',' ','\x02','\xbb','b','e','i','n','g',' ','l','o','a','d','e','d','.',
/* 0x08524 = "Tried to take a semaphore in a bad context." */
    'T','r','i','e','d',' ','\x0a','t','a','k','e',' ','a',' ','s','e','m','a','p','h','o','r','e',' ','\x0f','a',' ','b','a','d',' ','c','o','n','t','e','x','t','.',
/* 0x0854b = "The component factories do not support the requested interface." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','i','e','s',' ','d','o',' ','\x08','\xce','\x02','\xdd','i','n','t','e','r','f','a','c','e','.',
/* 0x08571 = "Failed to stat a file/dir during enumeration (hardening)." */
    '\x8b','\x0a','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','d','u','r','i','n','g',' ','e','n','u','m','e','r','a','t','i','o','n',' ','\xad',
/* 0x08597 = "The handle was not registered for use with the I/O queue." */
    '\x03','h','a','n','d','l','e',' ','\x11','\x08','r','e','g','i','s','t','e','r','e','d',' ','\x10','u','s','e',' ','\x80','\x02','I','/','O',' ','q','u','e','u','e','.',
/* 0x085bd = "Malformed checksum field in the tar header." */
    'M','a','l','f','o','r','m','e','d',' ','c','h','e','c','k','s','u','m',' ','f','i','e','l','d',' ','\x0f','\x02','t','a','r',' ','h','e','a','d','e','r','.',
/* 0x085e3 = "Attempt to release mutex not owned by caller." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','l','e','a','s','e',' ','m','u','t','e','x',' ','\x08','o','w','n','e','d',' ','\xdf','c','a','l','l','e','r','.',
/* 0x08609 = "Not possible to attach drivers to the device." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x0a','a','t','t','a','c','h',' ','d','r','i','v','e','r','s',' ','\x0a','\x02','d','e','v','i','c','e','.',
/* 0x0862f = "The caller shall raise an #GP(0) exception." */
    '\x03','c','a','l','l','e','r',' ','s','h','a','l','l',' ','r','a','i','s','e',' ','\x87','#','G','P','(','0',')',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x08655 = "The value is not a zero terminated password string." */
    '\x03','\xfa','\x0b','\x08','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','p','a','s','s','w','o','r','d',' ','s','t','r','i','n','g','.',
/* 0x0867b = "Virtual address was not allocated by the library." */
    'V','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','\x11','\x08','a','l','l','o','c','a','t','e','d',' ','\xdf','\x02','l','i','b','r','a','r','y','.',
/* 0x086a1 = "Failed to measure the TSC delta between two CPUs." */
    '\x8b','\x0a','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s','.',
/* 0x086c7 = "The UDP server has no client associated with it." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x7b','n','o',' ','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','i','t','.',
/* 0x086ed = "The table of content XML document does not have a toc element." */
    '\x03','\xb1','\x15','\xed','X','M','L',' ','d','o','c','u','m','e','n','t',' ','\xb2','\x08','h','a','v','e',' ','a',' ','t','o','c',' ','e','l','e','m','e','n','t','.',
/* 0x08713 = "The interpreter was unable to deal with the instruction at hand." */
    '\x03','i','n','t','e','r','p','r','e','t','e','r',' ','\x11','u','n','a','b','l','e',' ','\x0a','d','e','a','l',' ','\x80','\x02','\xd9','a','t',' ','h','a','n','d','.',
/* 0x08739 = "Attempted to report too many pages as deflated." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','r','e','p','o','r','t',' ','\xa0','\xb4','p','a','g','e','s',' ','a','s',' ','d','e','f','l','a','t','e','d','.',
/* 0x0875f = "The size of the raw optical image is too small (<= 32K)." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','o','p','t','i','c','a','l',' ','\x25','\x0b','\xa0','s','m','a','l','l',' ','(','<','=',' ','3','2','K',')','.',
/* 0x08785 = "Malformed or failed to parse PEM formatted data." */
    'M','a','l','f','o','r','m','e','d',' ','\xa9','\x98','\x0a','p','a','r','s','e',' ','P','E','M',' ','f','o','r','m','a','t','t','e','d',' ','d','a','t','a','.',
/* 0x087ab = "Internal processing error the CodeView debug information reader." */
    '\x07','\x04','\x09','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','r','e','a','d','e','r','.',
/* 0x087d1 = "Process Verification Failure: Expected the process and exe to have dynamic base enabled." */
    '\x1e','\x0d','\x12','\xb8','\x02','\x92','\x99','e','x','e',' ','\x0a','h','a','v','e',' ','d','y','n','a','m','i','c',' ','b','a','s','e',' ','e','n','a','b','l','e','d','.',
/* 0x087f7 = "Power off is not supported by the hardware or the OS." */
    'P','o','w','e','r',' ','o','f','f',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','\x02','h','a','r','d','w','a','r','e',' ','\xa9','\x02','O','S','.',
/* 0x0881d = "Unabled to locate or load the OpenGL library." */
    'U','n','a','b','l','e','d',' ','\x0a','l','o','c','a','t','e',' ','\xa9','l','o','a','d',' ','\x02','O','p','e','n','G','L',' ','l','i','b','r','a','r','y','.',
/* 0x08843 = "Reason for leaving RZ: Pending ring-3 OUT instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','O','U','T',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x08869 = "Not the lock owner according our records." */
    'N','o','t',' ','\x02','l','o','c','k',' ','o','w','n','e','r',' ','a','c','c','o','r','d','i','n','g',' ','o','u','r',' ','r','e','c','o','r','d','s','.',
/* 0x0888f = "A request was not prepared and thus could not be submitted." */
    'A',' ','\xaa','\x11','\x08','p','r','e','p','a','r','e','d',' ','\x99','t','h','u','s',' ','c','o','u','l','d',' ','\x08','\xa8','s','u','b','m','i','t','t','e','d','.',
/* 0x088b5 = "Catch write access and route it thru PGM." */
    'C','a','t','c','h',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x99','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x088db = "Error getting extensions from the certificate." */
    '\xc0','g','e','t','t','i','n','g',' ','e','x','t','e','n','s','i','o','n','s',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x08901 = "Started guest process terminated with an exit code <> 0." */
    'S','t','a','r','t','e','d',' ','\xbb','\x92','t','e','r','m','i','n','a','t','e','d',' ','\x80','\x87','e','x','i','t',' ','c','o','d','e',' ','<','>',' ','0','.',
/* 0x08927 = "Couldn\'t find MMIO2 page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xcb','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0894d = "The TCP server has no client associated with it." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x7b','n','o',' ','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','i','t','.',
/* 0x08973 = "PKIX cipher algorithm is not known to OpenSSL EVP API." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd3','\x0b','\x08','k','n','o','w','n',' ','\x0a','O','p','e','n','S','S','L',' ','E','V','P',' ','A','P','I','.',
/* 0x08999 = "The signature is greater than or equal to the key." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','g','r','e','a','t','e','r',' ','t','h','a','n',' ','\xa9','e','q','u','a','l',' ','\x0a','\x02','k','e','y','.',
/* 0x089bf = "The chunk has been mapped too many times already (impossible)." */
    '\x03','c','h','u','n','k',' ','\x7b','\xca','m','a','p','p','e','d',' ','\xa0','\xb4','t','i','m','e','s',' ','\x7f','(','i','m','p','o','s','s','i','b','l','e',')','.',
/* 0x089e5 = "VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT" */
    '\x01','\x95','\xbd','\x06','S','I','G','N','E','D','_','W','I','T','H','_','S','P','E','C','I','A','L','L','Y','_','T','R','U','S','T','E','D','_','C','E','R','T',
/* 0x08a0b = "Invalid VMCS index or write to read-only element." */
    '\x0c','V','M','C','S',' ','i','n','d','e','x',' ','\xa9','w','r','i','t','e',' ','\x0a','r','e','a','d','-','o','n','l','y',' ','e','l','e','m','e','n','t','.',
/* 0x08a31 = "An account is restricted in a certain way." */
    'A','n',' ','a','c','c','o','u','n','t',' ','\x0b','r','e','s','t','r','i','c','t','e','d',' ','\x0f','a',' ','c','e','r','t','a','i','n',' ','w','a','y','.',
/* 0x08a57 = "VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS" */
    '\x01','\x22','\xb7','T','B','S','C','E','R','T','_','S','E','R','I','A','L','_','N','U','M','B','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x08a7d = "LUN is already/still attached to a device." */
    'L','U','N',' ','\x0b','a','l','r','e','a','d','y','/','s','t','i','l','l',' ','a','t','t','a','c','h','e','d',' ','\x0a','a',' ','d','e','v','i','c','e','.',
/* 0x08aa3 = "VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH" */
    '\x01','\x22','C','I','P','H','E','R','_','\x05','I','N','I','T','I','A','L','I','Z','A','T','I','O','N','_','V','E','C','T','O','R','_','L','E','N','G','T','H',
/* 0x08ac9 = "The specified attribute (name) was not found in the manifest." */
    '\x03','\x18','a','t','t','r','i','b','u','t','e',' ','(','n','a','m','e',')',' ','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','m','a','n','i','f','e','s','t','.',
/* 0x08aef = "A queue is out of free items, the queueing operation failed." */
    'A',' ','q','u','e','u','e',' ','\x0b','o','u','t',' ','\x15','f','r','e','e',' ','i','t','e','m','s',',',' ','\x02','q','u','e','u','e','i','n','g',' ','\x96','\x7d',
/* 0x08b15 = "Failed to resolve an imported (external) symbol." */
    '\x8b','\x0a','r','e','s','o','l','v','e',' ','\x87','i','m','p','o','r','t','e','d',' ','(','e','x','t','e','r','n','a','l',')',' ','s','y','m','b','o','l','.',
/* 0x08b3b = "VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08b61 = "Import ISO contains more than one primary volume descriptor." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','p','r','i','m','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x08b87 = "Filesystem can\'t be opened because it is corrupt." */
    'F','i','l','e','s','y','s','t','e','m',' ','c','a','n','\'','t',' ','\xa8','o','p','e','n','e','d',' ','\x40','i','t',' ','\x0b','c','o','r','r','u','p','t','.',
/* 0x08bad = "The specified MMIO range intruded on an existing range." */
    '\x03','\x18','\xd2',' ','r','a','n','g','e',' ','i','n','t','r','u','d','e','d',' ','o','n',' ','\x87','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',
/* 0x08bd3 = "File not accessible or erroneous file contents." */
    'F','i','l','e',' ','\x08','a','c','c','e','s','s','i','b','l','e',' ','\xa9','e','r','r','o','n','e','o','u','s',' ','\x1f','c','o','n','t','e','n','t','s','.',
/* 0x08bf9 = "VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08c1f = "Incompatible configuration requested." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','r','e','q','u','e','s','t','e','d','.',
/* 0x08c44 = "ICB is too small to contain anything useful." */
    'I','C','B',' ','\x0b','\xa0','s','m','a','l','l',' ','\x0a','c','o','n','t','a','i','n',' ','a','n','y','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x08c69 = "Import ISO contains more than one joliet volume descriptor." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','j','o','l','i','e','t',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x08c8e = "OpenSSL and IPRT disagree on the signature." */
    'O','p','e','n','S','S','L',' ','\x99','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x08cb3 = "Recompilation: End translation block." */
    'R','e','c','o','m','p','i','l','a','t','i','o','n',':',' ','E','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k','.',
/* 0x08cd8 = "VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','U','C','T','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x08cfd = "Couldn\'t find the end of CPUID sub-leaves." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','e','n','d',' ','\x15','C','P','U','I','D',' ','s','u','b','-','l','e','a','v','e','s','.',
/* 0x08d22 = "Not able to allocate contiguous memory." */
    'N','o','t',' ','a','b','l','e',' ','\x0a','a','l','l','o','c','a','t','e',' ','c','o','n','t','i','g','u','o','u','s',' ','m','e','m','o','r','y','.',
/* 0x08d47 = "The device instance have no such logical unit." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','h','a','v','e',' ','n','o',' ','s','u','c','h',' ','l','o','g','i','c','a','l',' ','u','n','i','t','.',
/* 0x08d6c = "Expected write pipe, got a read pipe instead." */
    '\xb8','w','r','i','t','e',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','r','e','a','d',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x08d91 = "The boot catalog block in the import ISO is out of bounds." */
    '\x03','b','o','o','t',' ','\xe5','b','l','o','c','k',' ','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x08db6 = "Process Purification Failure: Unknown memory type of executable memory." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','\xf8','\x85','\xf1','\x15','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x08ddb = "Key algorithm parameters are not known/supported." */
    'K','e','y',' ','\xd3','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x08','k','n','o','w','n','/','s','u','p','p','o','r','t','e','d','.',
/* 0x08e00 = "The environment variable is an unset record." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x0b','\x87','u','n','s','e','t',' ','r','e','c','o','r','d','.',
/* 0x08e25 = "The DTB structs block ended prematurely." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','e','n','d','e','d',' ','p','r','e','m','a','t','u','r','e','l','y','.',
/* 0x08e4a = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','I','M','A','G','E','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x08e6f = "The tracer cannot open it self in the same session." */
    '\x03','t','r','a','c','e','r',' ','\xe0','o','p','e','n',' ','i','t',' ','s','e','l','f',' ','\x0f','\x02','s','a','m','e',' ','s','e','s','s','i','o','n','.',
/* 0x08e94 = "Expected read pipe, got a write pipe instead." */
    '\xb8','r','e','a','d',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','w','r','i','t','e',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x08eb9 = "Key encrypted but no password was given." */
    'K','e','y',' ','e','n','c','r','y','p','t','e','d',' ','b','u','t',' ','n','o',' ','p','a','s','s','w','o','r','d',' ','\x11','g','i','v','e','n','.',
/* 0x08ede = "Invalid page count given to GMMR3FreePagesPerform." */
    '\x0c','\xcb','c','o','u','n','t',' ','g','i','v','e','n',' ','\x0a','G','M','M','R','3','F','r','e','e','P','a','g','e','s','P','e','r','f','o','r','m','.',
/* 0x08f03 = "Failed to abort entering a critical section in ring-0." */
    '\x8b','\x0a','a','b','o','r','t',' ','e','n','t','e','r','i','n','g',' ','a',' ','c','r','i','t','i','c','a','l',' ','\xda','\x0f','r','i','n','g','-','0','.',
/* 0x08f28 = "Reason for leaving RZ: Pending ring-3 IN instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','I','N',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x08f4d = "Certificate path validator: Name constraints permits no names." */
    '\xba','\xd0','\xfd','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','p','e','r','m','i','t','s',' ','n','o',' ','n','a','m','e','s','.',
/* 0x08f72 = "Node pointer does not point to the start of a node." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\xb2','\x08','p','o','i','n','t',' ','\x0a','\x02','s','t','a','r','t',' ','\x15','a',' ','n','o','d','e','.',
/* 0x08f97 = "Encountered a \'-\' during conversion to an unsigned value." */
    '\xa5','a',' ','\'','-','\'',' ','d','u','r','i','n','g',' ','c','o','n','v','e','r','s','i','o','n',' ','\x0a','\x87','u','n','s','i','g','n','e','d',' ','\xf3',
/* 0x08fbc = "Malformed indefinite length encoding." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x08fe1 = "The hyper CR3 differs between PGM and CPUM." */
    '\x03','h','y','p','e','r',' ','C','R','3',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','P','G','M',' ','\x99','C','P','U','M','.',
/* 0x09006 = "Only native endian Mach-O files are supported." */
    'O','n','l','y',' ','n','a','t','i','v','e',' ','e','n','d','i','a','n',' ','M','a','c','h','-','O',' ','f','i','l','e','s',' ','a','r','e',' ','\xa4',
/* 0x0902b = "validation of the fixup section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','f','i','x','u','p',' ','\xda','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x7d',
/* 0x09050 = "Invalid/Corrupted configuration file." */
    'I','n','v','a','l','i','d','/','C','o','r','r','u','p','t','e','d',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','f','i','l','e','.',
/* 0x09075 = "The indirect data digest size does not match the digest algorithm." */
    '\x03','i','n','d','i','r','e','c','t',' ','\x9c','\xd6','s','i','z','e',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','\xd6','a','l','g','o','r','i','t','h','m','.',
/* 0x0909a = "Reason for leaving R0: Hit a ring-0 assertion on EMT." */
    '\x93','\x10','\x81','R','0',':',' ','H','i','t',' ','a',' ','r','i','n','g','-','0',' ','a','s','s','e','r','t','i','o','n',' ','o','n',' ','E','M','T','.',
/* 0x090bf = "PCI passthru is not supported by this build." */
    'P','C','I',' ','p','a','s','s','t','h','r','u',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','t','h','i','s',' ','b','u','i','l','d','.',
/* 0x090e4 = "Mismatch between IPRT and native loader." */
    'M','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','I','P','R','T',' ','\x99','n','a','t','i','v','e',' ','l','o','a','d','e','r','.',
/* 0x09109 = "The loaded XSAVE component mask is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x0b','\x08','v','a','l','i','d','.',
/* 0x0912e = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','U','N','D','E','F','I','N','E','D','_','F','L','A','G','S',
/* 0x09153 = "We were given a NULL pPage parameter." */
    'W','e',' ','w','e','r','e',' ','g','i','v','e','n',' ','a',' ','N','U','L','L',' ','p','P','a','g','e',' ','p','a','r','a','m','e','t','e','r','.',
/* 0x09178 = "Error enumerating all processes in the session." */
    '\xc0','e','n','u','m','e','r','a','t','i','n','g',' ','a','l','l',' ','p','r','o','c','e','s','s','e','s',' ','\x0f','\x02','s','e','s','s','i','o','n','.',
/* 0x0919d = "Certificate path validator: Name constraints does not permits the certificate name." */
    '\xba','\xd0','\xfd','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\xb2','\x08','p','e','r','m','i','t','s',' ','\x02','\x9e','n','a','m','e','.',
/* 0x091c2 = "Invalid size of a SSM field with the specified transformation." */
    '\x0c','s','i','z','e',' ','\x15','a',' ','S','S','M',' ','f','i','e','l','d',' ','\x80','\x02','\x18','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x091e7 = "Invalid operand size passed to an IEM function." */
    '\x0c','o','p','e','r','a','n','d',' ','s','i','z','e',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0920b = "VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID" */
    '\x01','\xf2','E','X','P','E','C','T','E','D','_','I','N','D','I','R','E','C','T','_','D','A','T','A','_','C','O','N','T','E','N','T','_','O','I','D',
/* 0x0922f = "Couldn\'t find ROM page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xcb','f','r','o','m',' ','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x09253 = "The thread is not a valid signaller of the event." */
    '\x03','t','h','r','e','a','d',' ','\x0b','\x08','a',' ','v','a','l','i','d',' ','s','i','g','n','a','l','l','e','r',' ','\x15','\x02','e','v','e','n','t','.',
/* 0x09277 = "Unexpected/unknown/bad descriptor in volume descriptor sequence." */
    'U','n','e','x','p','e','c','t','e','d','/','u','n','k','n','o','w','n','/','b','a','d',' ','\xee','\x0f','\xd1','\xee','s','e','q','u','e','n','c','e','.',
/* 0x0929b = "Current virtual machine state prevents the operation." */
    'C','u','r','r','e','n','t',' ','v','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\xcd','p','r','e','v','e','n','t','s',' ','\x02','\xe8',
/* 0x092bf = "Network dropped connection on reset." */
    'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','.',
/* 0x092e3 = "Process Verification Failure: Error reading process memory for comparing with disk data." */
    '\x1e','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x92','\x85','\x10','c','o','m','p','a','r','i','n','g',' ','\x80','d','i','s','k',' ','d','a','t','a','.',
/* 0x09307 = "Reason for leaving RC: The IRET resuming guest code trapped." */
    '\x93','\x10','\x81','R','C',':',' ','\x03','I','R','E','T',' ','r','e','s','u','m','i','n','g',' ','\xbb','c','o','d','e',' ','t','r','a','p','p','e','d','.',
/* 0x0932b = "The guest has not setup use of the paravirtualized TSC." */
    '\x03','\xbb','\x7b','\x08','s','e','t','u','p',' ','u','s','e',' ','\x15','\x02','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0934f = "Encountered an unsupported Solaris Tar extension." */
    '\xa5','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','S','o','l','a','r','i','s',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x09373 = "The paging mode of the host is not supported yet." */
    '\x03','p','a','g','i','n','g',' ','m','o','d','e',' ','\x15','\x02','h','o','s','t',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','y','e','t','.',
/* 0x09397 = "VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','\xd4','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x093bb = "The timer can\'t be started because it\'s already active." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\xa8','s','t','a','r','t','e','d',' ','\x40','i','t','\'','s',' ','\x7f','a','c','t','i','v','e','.',
/* 0x093df = "VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','H','E','A','D','E','R','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x09403 = "The expanding of the dynamic mapping cache failed." */
    '\x03','e','x','p','a','n','d','i','n','g',' ','\x15','\x02','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x7d',
/* 0x09427 = "The MMIO handler was called for a bogus address!" */
    '\x03','\xd2',' ','h','a','n','d','l','e','r',' ','\x11','c','a','l','l','e','d',' ','\x10','a',' ','b','o','g','u','s',' ','a','d','d','r','e','s','s','!',
/* 0x0944b = "Incomplete packet was submitted by guest." */
    'I','n','c','o','m','p','l','e','t','e',' ','p','a','c','k','e','t',' ','\x11','s','u','b','m','i','t','t','e','d',' ','\xdf','g','u','e','s','t','.',
/* 0x0946f = "Specified digest not supported in this context." */
    'S','p','e','c','i','f','i','e','d',' ','\xd6','\x08','s','u','p','p','o','r','t','e','d',' ','\x0f','t','h','i','s',' ','c','o','n','t','e','x','t','.',
/* 0x09493 = "The shadow paging mode is not supported yet." */
    '\x03','s','h','a','d','o','w',' ','p','a','g','i','n','g',' ','m','o','d','e',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','y','e','t','.',
/* 0x094b7 = "The image is required to force integrity checks." */
    '\x03','\x25','\x0b','r','e','q','u','i','r','e','d',' ','\x0a','f','o','r','c','e',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','s','.',
/* 0x094db = "Error encoding the password for key decryption." */
    '\xc0','e','n','c','o','d','i','n','g',' ','\x02','p','a','s','s','w','o','r','d',' ','\x10','k','e','y',' ','d','e','c','r','y','p','t','i','o','n','.',
/* 0x094ff = "Encountered a load command that\'s not implemented." */
    '\xa5','a',' ','l','o','a','d',' ','c','o','m','m','a','n','d',' ','t','h','a','t','\'','s',' ','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x09523 = "Generic debug event, suspend the VM for debugging." */
    '\xa6','d','e','b','u','g',' ','e','v','e','n','t',',',' ','s','u','s','p','e','n','d',' ','\x02','\xcc',' ','\x10','d','e','b','u','g','g','i','n','g','.',
/* 0x09547 = "VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','T','O','K','E','N','_','I','N','V','A','L','I','D',
/* 0x0956b = "The lock validator detected a deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','a',' ','d','e','a','d','l','o','c','k','.',
/* 0x0958f = "An invalid I/O port size was specified for a read or write operation." */
    'A','n',' ','\x8f','I','/','O',' ','p','o','r','t',' ','s','i','z','e',' ','\x11','\x18','\x10','a',' ','r','e','a','d',' ','\xa9','w','r','i','t','e',' ','\xe8',
/* 0x095b3 = "Internal processing error in the PGM physical RAM range lookup code." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','R','A','M',' ','r','a','n','g','e',' ','l','o','o','k','u','p',' ','\x83',
/* 0x095d7 = "The breakpoint owner callback returned an invalid status code." */
    '\x03','\xbf','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','r','e','t','u','r','n','e','d',' ','\x87','\x8f','s','t','a','t','u','s',' ','\x83',
/* 0x095fb = "Failed while setting up a redirector rule." */
    '\x8b','w','h','i','l','e',' ','s','e','t','t','i','n','g',' ','u','p',' ','a',' ','r','e','d','i','r','e','c','t','o','r',' ','r','u','l','e','.',
/* 0x0961f = "Syntax error - an undefined variable was referenced." */
    '\xf7','\x09','-',' ','\x87','u','n','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e',' ','\x11','r','e','f','e','r','e','n','c','e','d','.',
/* 0x09643 = "OpenSSL failed to init PKIX cipher algorithm context." */
    'O','p','e','n','S','S','L',' ','\x98','\x0a','i','n','i','t',' ','P','K','I','X',' ','c','i','p','h','e','r',' ','\xd3','c','o','n','t','e','x','t','.',
/* 0x09667 = "Requested to import an unknown ISO format." */
    'R','e','q','u','e','s','t','e','d',' ','\x0a','i','m','p','o','r','t',' ','\x87','u','n','k','n','o','w','n',' ','\xc1',' ','f','o','r','m','a','t','.',
/* 0x0968b = "Import ISO contains a bad supplementary volume descriptor." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x096af = "Recompiler: Duplicate argument variable number." */
    '\x13','D','u','p','l','i','c','a','t','e',' ','a','r','g','u','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','u','m','b','e','r','.',
/* 0x096d3 = "Unresolved (unknown) host platform error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','\x84',
/* 0x096f7 = "Invalid parameters passed to the lock validator." */
    '\x0c','p','a','r','a','m','e','t','e','r','s',' ','p','a','s','s','e','d',' ','\x0a','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r','.',
/* 0x0971b = "Reason for leaving RC: Sync the GDT table to solve a conflict." */
    '\x93','\x10','\x81','R','C',':',' ','S','y','n','c',' ','\x02','G','D','T',' ','\xb1','\x0a','s','o','l','v','e',' ','a',' ','c','o','n','f','l','i','c','t','.',
/* 0x0973f = "Catch any access and route it thru PGM." */
    'C','a','t','c','h',' ','a','n','y',' ','a','c','c','e','s','s',' ','\x99','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x09763 = "The timer queue is not longer allowed to grow." */
    '\x03','t','i','m','e','r',' ','q','u','e','u','e',' ','\x0b','\x08','l','o','n','g','e','r',' ','a','l','l','o','w','e','d',' ','\x0a','g','r','o','w','.',
/* 0x09787 = "Certificate path validator: Intermediate certificate is not a version 3 certificate." */
    '\xba','\xd0','\xfd','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x9e','\x0b','\x08','a',' ','\xcf','3',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x097ab = "VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','D','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x097cf = "The DTB property payload string is not terminated." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xf0','\x0b','\x08','t','e','r','m','i','n','a','t','e','d','.',
/* 0x097f3 = "VFS chain element takes a file system (vfs) object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x1f','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x09817 = "VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','P','R','E','M','A','T','U','R','E','_','E','N','D',
/* 0x0983b = "General failure - DON\'T USE THIS!!!." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','-',' ','D','O','N','\'','T',' ','U','S','E',' ','T','H','I','S','!','!','!','.',
/* 0x0985f = "Image Verification Failure: Authenticode parsing output." */
    'I','m','a','g','e',' ','\x0d','\x12','A','u','t','h','e','n','t','i','c','o','d','e',' ','p','a','r','s','i','n','g',' ','o','u','t','p','u','t','.',
/* 0x09883 = "The caller does not have a reference to the object." */
    '\x03','c','a','l','l','e','r',' ','\xb2','\x08','h','a','v','e',' ','a',' ','r','e','f','e','r','e','n','c','e',' ','\x0a','\x02','o','b','j','e','c','t','.',
/* 0x098a7 = "Continue execution after patch trap." */
    'C','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','p','a','t','c','h',' ','t','r','a','p','.',
/* 0x098cb = "Unable to parse the CodeView debug information." */
    '\xde','\x0a','p','a','r','s','e',' ','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x098ef = "Invalid address mode passed to an IEM function." */
    '\x0c','a','d','d','r','e','s','s',' ','m','o','d','e',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x09913 = "The ELF loader encountered a relocation type which is not implemented." */
    '\x03','E','L','F',' ','\xd8','\xae','a',' ','r','e','l','o','c','a','t','i','o','n',' ','\xf1','\xeb','\x0b','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x09937 = "VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','Q','U','E','R','Y','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x0995a = "The dynamic mapping cache for physical memory failed." */
    '\x03','d','y','n','a','m','i','c',' ','m','a','p','p','i','n','g',' ','c','a','c','h','e',' ','\x10','p','h','y','s','i','c','a','l',' ','\x85','\x7d',
/* 0x0997d = "The CR3 address specified memory we don\'t know about." */
    '\x03','C','R','3',' ','a','d','d','r','e','s','s',' ','\x18','\x85','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x099a0 = "Bad VTG header - size value is not a multiple of the structure size." */
    '\x9d','V','T','G',' ','\xb3','-',' ','s','i','z','e',' ','\xfa','\x0b','\x08','a',' ','m','u','l','t','i','p','l','e',' ','\x15','\x02','\xea','s','i','z','e','.',
/* 0x099c3 = "VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','A','N','D','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','S','_','\x19',
/* 0x099e6 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE" */
    '\x01','\x22','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','C','H','O','I','C','E',
/* 0x09a09 = "The length of the segment name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','s','e','g','m','e','n','t',' ','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x09a2c = "An illegal lock upgrade was attempted." */
    'A','n',' ','i','l','l','e','g','a','l',' ','l','o','c','k',' ','u','p','g','r','a','d','e',' ','\x11','a','t','t','e','m','p','t','e','d','.',
/* 0x09a4f = "DWARF LEB value overflows the decoder type." */
    'D','W','A','R','F',' ','L','E','B',' ','\xfa','o','v','e','r','f','l','o','w','s',' ','\x02','d','e','c','o','d','e','r',' ','t','y','p','e','.',
/* 0x09a72 = "The current HTTP request was forcefully aborted." */
    '\x03','c','u','r','r','e','n','t',' ','H','T','T','P',' ','\xaa','\x11','f','o','r','c','e','f','u','l','l','y',' ','a','b','o','r','t','e','d','.',
/* 0x09a95 = "Attempted to insert mode with invalid key range." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','i','n','s','e','r','t',' ','m','o','d','e',' ','\x80','\x8f','k','e','y',' ','r','a','n','g','e','.',
/* 0x09ab8 = "The compressed data started with a bad header." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9c','s','t','a','r','t','e','d',' ','\x80','a',' ','b','a','d',' ','h','e','a','d','e','r','.',
/* 0x09adb = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','E','N','D','_','O','F','_','S','E','C','T','O','R',
/* 0x09afe = "The async completion task is not suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x0b','\x08','s','u','s','p','e','n','d','e','d','.',
/* 0x09b21 = "The RTPROC_FLAGS_DETACHED flag isn\'t supported." */
    '\x03','R','T','P','R','O','C','_','F','L','A','G','S','_','D','E','T','A','C','H','E','D',' ','f','l','a','g',' ','i','s','n','\'','t',' ','\xa4',
/* 0x09b44 = "CPU microarch lookup matched by name." */
    'C','P','U',' ','m','i','c','r','o','a','r','c','h',' ','l','o','o','k','u','p',' ','m','a','t','c','h','e','d',' ','\xdf','n','a','m','e','.',
/* 0x09b67 = "VMDK: Format is invalid/inconsistent." */
    'V','M','D','K',':',' ','F','o','r','m','a','t',' ','\x0b','i','n','v','a','l','i','d','/','i','n','c','o','n','s','i','s','t','e','n','t','.',
/* 0x09b8a = "Attempted to disabled a breakpoint which was already disabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','d','i','s','a','b','l','e','d',' ','a',' ','\xbf','\xeb','\x11','\x7f','d','i','s','a','b','l','e','d','.',
/* 0x09bad = "PE image data without any valid content was not expected." */
    'P','E',' ','\x25','\x9c','w','i','t','h','o','u','t',' ','a','n','y',' ','v','a','l','i','d',' ','\xed','\x11','\x08','e','x','p','e','c','t','e','d','.',
/* 0x09bd0 = "A boot catalog entry in the import ISO has an unknown type." */
    'A',' ','b','o','o','t',' ','\xe5','\xc8','\x0f','\x02','i','m','p','o','r','t',' ','\xc1',' ','\x7b','\x87','u','n','k','n','o','w','n',' ','t','y','p','e','.',
/* 0x09bf3 = "The async completion task is already suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x0b','\x7f','s','u','s','p','e','n','d','e','d','.',
/* 0x09c16 = "Process Verification Failure: One of the section in the image file is not mapped into memory." */
    '\x1e','\x0d','\x12','O','n','e',' ','\x15','\x02','\xda','\x0f','\x02','\x25','\x1f','\x0b','\x08','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x09c39 = "The selected platform architecture is not supported." */
    '\x03','s','e','l','e','c','t','e','d',' ','p','l','a','t','f','o','r','m',' ','a','r','c','h','i','t','e','c','t','u','r','e',' ','\x0b','\x08','\xa4',
/* 0x09c5c = "Too long forwarder chain or there is a loop." */
    'T','o','o',' ','l','o','n','g',' ','f','o','r','w','a','r','d','e','r',' ','\x9f','\xa9','t','h','e','r','e',' ','\x0b','a',' ','l','o','o','p','.',
/* 0x09c7f = "Don\'t call again until the final pass." */
    'D','o','n','\'','t',' ','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x09ca2 = "Too many calls to the service from a client." */
    'T','o','o',' ','\xb4','c','a','l','l','s',' ','\x0a','\x02','s','e','r','v','i','c','e',' ','f','r','o','m',' ','a',' ','c','l','i','e','n','t','.',
/* 0x09cc5 = "Support for forwarders has not been implemented." */
    'S','u','p','p','o','r','t',' ','\x10','f','o','r','w','a','r','d','e','r','s',' ','\x7b','\x08','\xca','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x09ce8 = "Host backend couldn\'t be initialized." */
    'H','o','s','t',' ','b','a','c','k','e','n','d',' ','c','o','u','l','d','n','\'','t',' ','\xa8','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x09d0b = "VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING" */
    '\x01','F','D','T','_','D','T','B','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','T','E','R','M','I','N','A','T','O','R','_','\xc4',
/* 0x09d2e = "Import ISO contains an unsupported primary volume descriptor version." */
    '\xc3','\xc1',' ','\x8a','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','p','r','i','m','a','r','y',' ','\xd1','\xee','v','e','r','s','i','o','n','.',
/* 0x09d51 = "iSCSI: Initiator secret not decrypted." */
    'i','S','C','S','I',':',' ','I','n','i','t','i','a','t','o','r',' ','s','e','c','r','e','t',' ','\x08','d','e','c','r','y','p','t','e','d','.',
/* 0x09d74 = "The page hash table is not strictly ordered by offset." */
    '\x03','\xcb','h','a','s','h',' ','\xb1','\x0b','\x08','s','t','r','i','c','t','l','y',' ','o','r','d','e','r','e','d',' ','\xdf','o','f','f','s','e','t','.',
/* 0x09d97 = "The DTB structs block starts with an invalid token." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','s','t','a','r','t','s',' ','\x80','\x87','\x8f','t','o','k','e','n','.',
/* 0x09dba = "The signature is too long for the scratch buffer." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','\xa0','l','o','n','g',' ','\x10','\x02','s','c','r','a','t','c','h',' ','b','u','f','f','e','r','.',
/* 0x09ddd = "The machine was powered off while saving." */
    '\x03','m','a','c','h','i','n','e',' ','\x11','p','o','w','e','r','e','d',' ','o','f','f',' ','w','h','i','l','e',' ','s','a','v','i','n','g','.',
/* 0x09e00 = "No host backend attached / available." */
    '\xe6','h','o','s','t',' ','b','a','c','k','e','n','d',' ','a','t','t','a','c','h','e','d',' ','/',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x09e23 = "The session has no tracer associated with it." */
    '\x03','s','e','s','s','i','o','n',' ','\x7b','n','o',' ','t','r','a','c','e','r',' ','a','s','s','o','c','i','a','t','e','d',' ','\x80','i','t','.',
/* 0x09e46 = "Don\'t mess around with ballooned pages." */
    'D','o','n','\'','t',' ','m','e','s','s',' ','a','r','o','u','n','d',' ','\x80','b','a','l','l','o','o','n','e','d',' ','p','a','g','e','s','.',
/* 0x09e69 = "Error while calculating a digest for a PKCS #7 verification operation." */
    '\xc0','w','h','i','l','e',' ','c','a','l','c','u','l','a','t','i','n','g',' ','a',' ','\xd6','\x10','a',' ','P','K','C','S',' ','#','7',' ','\xf6','\xe8',
/* 0x09e8c = "The PE loader encountered a certificate with an unsupported type or structure revision." */
    '\x03','P','E',' ','\xd8','\xae','a',' ','\x9e','\x80','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','\xf1','\xa9','\xea','r','e','v','i','s','i','o','n','.',
/* 0x09eaf = "General failure during URB queuing." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','U','R','B',' ','q','u','e','u','i','n','g','.',
/* 0x09ed2 = "Ping-Pong listen or speak out of turn error." */
    'P','i','n','g','-','P','o','n','g',' ','l','i','s','t','e','n',' ','\xa9','s','p','e','a','k',' ','o','u','t',' ','\x15','t','u','r','n',' ','\x84',
/* 0x09ef5 = "The address (virtual or physical) is too big." */
    '\x03','a','d','d','r','e','s','s',' ','(','v','i','r','t','u','a','l',' ','\xa9','p','h','y','s','i','c','a','l',')',' ','\x0b','\xa0','b','i','g','.',
/* 0x09f18 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','U','S','E','S','_','U','N','U','S','E','D','_','F','I','E','L','D',
/* 0x09f3b = "No GIM provider is configured for this VM." */
    '\xe6','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x0b','c','o','n','f','i','g','u','r','e','d',' ','\x10','t','h','i','s',' ','V','M','.',
/* 0x09f5e = "Service rejected client connection." */
    'S','e','r','v','i','c','e',' ','r','e','j','e','c','t','e','d',' ','c','l','i','e','n','t',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x09f81 = "No space for rock ridge \'CE\' entry in directory record." */
    '\xe6','s','p','a','c','e',' ','\x10','r','o','c','k',' ','r','i','d','g','e',' ','\'','C','E','\'',' ','\xc8','\x0f','\x26','r','e','c','o','r','d','.',
/* 0x09fa3 = "VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER" */
    '\x01','\x24','B','O','O','T','_','C','A','T','_','E','X','P','E','C','T','E','D','_','S','E','C','T','I','O','N','_','H','E','A','D','E','R',
/* 0x09fc5 = "Precodition no 0 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','0',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7d',
/* 0x09fe7 = "Internal ISO maker error: Rock ridge read problem." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','R','o','c','k',' ','r','i','d','g','e',' ','r','e','a','d',' ','p','r','o','b','l','e','m','.',
/* 0x0a009 = "Precodition no 3 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','3',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7d',
/* 0x0a02b = "VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x0a04d = "VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','L','A','S','T','_','C','O','M','P','A','T','_','\xbc','_','I','N','V','A','L','I','D',
/* 0x0a06f = "VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA" */
    '\x01','\xdb','H','A','S','H','_','T','A','B','_','H','A','S','H','E','S','_','N','O','N','_','S','E','C','T','I','O','N','_','D','A','T','A',
/* 0x0a091 = "NEM init failed because of missing kernel API (#1)." */
    '\xec',' ','i','n','i','t',' ','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','1',')','.',
/* 0x0a0b3 = "The device instance have no base interface." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','h','a','v','e',' ','n','o',' ','b','a','s','e',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x0a0d5 = "Precodition no 1 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','1',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7d',
/* 0x0a0f7 = "The data in the saved state doesn't conform to expectations." */
    '\x03','\x9c','\x0f','\x02','s','a','v','e','d',' ','\xcd','\xc7','c','o','n','f','o','r','m',' ','\x0a','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0a119 = "The image is the correct format but is corrupted." */
    '\x03','\x25','\x0b','\x02','c','o','r','r','e','c','t',' ','f','o','r','m','a','t',' ','b','u','t',' ','\x0b','c','o','r','r','u','p','t','e','d','.',
/* 0x0a13b = "Pending stream disable operation in progress." */
    'P','e','n','d','i','n','g',' ','s','t','r','e','a','m',' ','d','i','s','a','b','l','e',' ','\x96','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x0a15d = "The request has been freed, don\'t read the status now." */
    '\x03','\xaa','\x7b','\xca','f','r','e','e','d',',',' ','d','o','n','\'','t',' ','r','e','a','d',' ','\x02','s','t','a','t','u','s',' ','n','o','w','.',
/* 0x0a17f = "VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS" */
    '\x01','\x22','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','T','A','K','E','S','_','\x60','P','A','R','A','M','E','T','E','R','S',
/* 0X0a1a1 = "Semaphore destroyed while waiting." */
    'e','m','a','p','h','o','r','e',' ','d','e','s','t','r','o','y','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g','.',
/* 0x0a1c2 = "Found something which isn\'t a file nor a directory (hardening)." */
    'F','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','\xeb','i','s','n','\'','t',' ','a',' ','\x1f','n','o','r',' ','a',' ','\x26','\xad',
/* 0x0a1e4 = "NEM init failed because of missing kernel API (#5)." */
    '\xec',' ','i','n','i','t',' ','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','5',')','.',
/* 0x0a206 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','E','O','S',
/* 0x0a228 = "A driver may only register one VTG object per session." */
    'A',' ','\xc5','m','a','y',' ','o','n','l','y',' ','\xe9','o','n','e',' ','V','T','G',' ','\xa7','p','e','r',' ','s','e','s','s','i','o','n','.',
/* 0x0a24a = "This VirtualBox build does not support raw-mode." */
    'T','h','i','s',' ','V','i','r','t','u','a','l','B','o','x',' ','b','u','i','l','d',' ','\xb2','\x08','\xce','r','a','w','-','m','o','d','e','.',
/* 0x0a26c = "ROM page mismatch between saved state and the VM." */
    'R','O','M',' ','\xcb','m','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','s','a','v','e','d',' ','\xcd','\x99','\x02','V','M','.',
/* 0x0a28e = "Type error opening the ApiPort LPC object." */
    'T','y','p','e',' ','\x09','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0a2b0 = "NEM init failed because of missing kernel API (#4)." */
    '\xec',' ','i','n','i','t',' ','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','4',')','.',
/* 0x0a2d2 = "VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x0a2f4 = "The integer value was too big for the requested representation." */
    '\x03','i','n','t','e','g','e','r',' ','\xfa','\x11','\xa0','b','i','g',' ','\x10','\x02','\xdd','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0a316 = "Import ISO contains a root directory with an out of bounds data extent." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x26','\x80','\x87','o','u','t',' ','\x15','b','o','u','n','d','s',' ','\x9c','e','x','t','e','n','t','.',
/* 0x0a338 = "VERR_REST_RESPONSE_REPEAT_HEADER_FIELD" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','R','E','P','E','A','T','_','H','E','A','D','E','R','_','F','I','E','L','D',
/* 0x0a35a = "The specified segment:offset address was invalid." */
    '\x03','\x18','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0a37c = "NtSetInformationObject/NoInherit failed." */
    'N','t','S','e','t','I','n','f','o','r','m','a','t','i','o','n','O','b','j','e','c','t','/','N','o','I','n','h','e','r','i','t',' ','\x7d',
/* 0x0a39e = "The file contained a data unit which no-one wants." */
    '\x03','\x1f','c','o','n','t','a','i','n','e','d',' ','a',' ','\x9c','u','n','i','t',' ','\xeb','n','o','-','o','n','e',' ','w','a','n','t','s','.',
/* 0x0a3c0 = "The image base address is to high for this image type." */
    '\x03','\x25','b','a','s','e',' ','a','d','d','r','e','s','s',' ','\x0b','\x0a','h','i','g','h',' ','\x10','t','h','i','s',' ','\x25','t','y','p','e','.',
/* 0x0a3e2 = "NEM init failed because of missing kernel API (#3)." */
    '\xec',' ','i','n','i','t',' ','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','3',')','.',
/* 0x0a404 = "VERR_X509_CERTIFICATE_VERIFICATION_FAILURE" */
    '\x01','\xb7','C','E','R','T','I','F','I','C','A','T','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x0a426 = "The discard operation is not supported for this image." */
    '\x03','d','i','s','c','a','r','d',' ','\x96','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\x10','t','h','i','s',' ','i','m','a','g','e','.',
/* 0x0a448 = "VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH" */
    '\x01','\xa1','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0a46a = "The request could not be canceled because it already completed." */
    '\x03','\xaa','c','o','u','l','d',' ','\x08','\xa8','c','a','n','c','e','l','e','d',' ','\x40','i','t',' ','\x7f','c','o','m','p','l','e','t','e','d','.',
/* 0x0a48c = "Algorithm parameters does not match the key." */
    'A','l','g','o','r','i','t','h','m',' ','p','a','r','a','m','e','t','e','r','s',' ','\xb2','\x08','m','a','t','c','h',' ','\x02','k','e','y','.',
/* 0x0a4ae = "There is not enough data to satisfy the request." */
    'T','h','e','r','e',' ','\x0b','\x08','e','n','o','u','g','h',' ','\x9c','\x0a','s','a','t','i','s','f','y',' ','\x02','r','e','q','u','e','s','t','.',
/* 0x0a4d0 = "The compression format version is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','f','o','r','m','a','t',' ','\xcf','\x0b','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0a4f2 = "The mode field should not include the type." */
    '\x03','m','o','d','e',' ','f','i','e','l','d',' ','s','h','o','u','l','d',' ','\x08','i','n','c','l','u','d','e',' ','\x02','t','y','p','e','.',
/* 0x0a514 = "VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','G','O','_','\x06','K','N','O','W','N','_','E','V','P',
/* 0x0a536 = "Couldn\'t map pages during receive." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','r','e','c','e','i','v','e','.',
/* 0x0a558 = "Internal error, VRDP packet is in wrong operation mode." */
    '\x07','e','r','r','o','r',',',' ','V','R','D','P',' ','p','a','c','k','e','t',' ','\x0b','\x0f','w','r','o','n','g',' ','\x96','m','o','d','e','.',
/* 0x0a57a = "Precodition no 2 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','2',' ','\x0f','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x7d',
/* 0x0a59c = "Internal ISO maker error: Finalization problem #1." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','F','i','n','a','l','i','z','a','t','i','o','n',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0a5be = "Unable to start VM execution due to an invalid guest state." */
    '\xde','\x0a','s','t','a','r','t',' ','\xcc',' ','e','x','e','c','u','t','i','o','n',' ','d','u','e',' ','\x0a','\x87','\x8f','\xbb','s','t','a','t','e','.',
/* 0x0a5e0 = "Already aliased to a different page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x0a','a',' ','d','i','f','f','e','r','e','n','t',' ','p','a','g','e','.',
/* 0x0a602 = "One or the PDPEs specified memory we don\'t know about." */
    'O','n','e',' ','\xa9','\x02','P','D','P','E','s',' ','\x18','\x85','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0a624 = "NEM init failed because of missing kernel API (#2)." */
    '\xec',' ','i','n','i','t',' ','\x98','\x40','\x15','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','2',')','.',
/* 0x0a646 = "Host is about to go into suspend mode." */
    'H','o','s','t',' ','\x0b','a','b','o','u','t',' ','\x0a','g','o',' ','i','n','t','o',' ','s','u','s','p','e','n','d',' ','m','o','d','e','.',
/* 0x0a668 = "VRDP thread has started OK and will run." */
    'V','R','D','P',' ','t','h','r','e','a','d',' ','\x7b','s','t','a','r','t','e','d',' ','O','K',' ','\x99','w','i','l','l',' ','r','u','n','.',
/* 0x0a68a = "Reason for leaving RC: int3 with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','i','n','t','3',' ','\x80','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x83',
/* 0x0a6ac = "The length of the symbol name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','s','y','m','b','o','l',' ','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0a6ce = "VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION" */
    '\x01','\x5e','M','I','S','C','O','N','F','I','G','U','R','E','D','_','D','R','V','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0a6f0 = "The size of the shared module was out of range." */
    '\x03','s','i','z','e',' ','\x15','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0a712 = "Unknown escape sequence encountered in TeletexString." */
    '\xf8','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\xae','\x0f','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0a733 = "Process Verification Failure: Error determining the full path of System32." */
    '\x1e','\x0d','\x12','\xc0','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','f','u','l','l',' ','\xd0','\x15','S','y','s','t','e','m','3','2','.',
/* 0x0a754 = "The compression method is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','m','e','t','h','o','d',' ','\x0b','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0a775 = "The process specified to a non-block wait had not exited." */
    '\x03','\x92','\x18','\x0a','a',' ','n','o','n','-','b','l','o','c','k',' ','w','a','i','t',' ','h','a','d',' ','\x08','e','x','i','t','e','d','.',
/* 0x0a796 = "A required query parameter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','q','u','e','r','y',' ','p','a','r','a','m','e','t','e','r',' ','\x11','\x08','s','e','t','.',
/* 0x0a7b7 = "Unsupported escape sequence encountered in TeletexString." */
    '\x97','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\xae','\x0f','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0a7d8 = "Malformed code signing structure." */
    'M','a','l','f','o','r','m','e','d',' ','c','o','d','e',' ','s','i','g','n','i','n','g',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0a7f9 = "Page not marked for dirty bit tracking." */
    'P','a','g','e',' ','\x08','m','a','r','k','e','d',' ','\x10','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g','.',
/* 0x0a81a = "Can\'t free the memory because it\'s used in mapping." */
    'C','a','n','\'','t',' ','f','r','e','e',' ','\x02','\x85','\x40','i','t','\'','s',' ','u','s','e','d',' ','\x0f','m','a','p','p','i','n','g','.',
/* 0x0a83b = "VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER" */
    '\x01','\x5e','C','A','N','N','O','T','_','T','R','A','N','S','F','O','R','M','_','R','E','M','O','V','E','D','_','D','R','I','V','E','R',
/* 0X0a85c = "Return to ring-3 to write the MSR there." */
    'e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','w','r','i','t','e',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0a87c = "VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS" */
    '\x01','\xb9','_','B','P','_','O','W','N','E','R','_','C','A','L','L','B','A','C','K','_','W','R','O','N','G','_','S','T','A','T','U','S',
/* 0x0a89d = "Entry in a boot catalog section is another section." */
    'E','n','t','r','y',' ','\x0f','a',' ','b','o','o','t',' ','\xe5','\xda','\x0b','a','n','o','t','h','e','r',' ','s','e','c','t','i','o','n','.',
/* 0x0a8be = "Couldn\'t connect to the server (proxy?" */
    'C','o','u','l','d','n','\'','t',' ','c','o','n','n','e','c','t',' ','\x0a','\x02','s','e','r','v','e','r',' ','(','p','r','o','x','y','?',
/* 0x0a8df = "VFS chain element only provides directory (dir) objects." */
    '\x8d',' ','\x9f','\x5c','o','n','l','y',' ','p','r','o','v','i','d','e','s',' ','\x26','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x0a900 = "Reason for leaving RC: Interrupt pending (guest)." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','t','e','r','r','u','p','t',' ','p','e','n','d','i','n','g',' ','(','g','u','e','s','t',')','.',
/* 0x0a921 = "OpenSSL failed to decode the key parameters." */
    'O','p','e','n','S','S','L',' ','\x98','\x0a','d','e','c','o','d','e',' ','\x02','k','e','y',' ','p','a','r','a','m','e','t','e','r','s','.',
/* 0x0a942 = "Internal ISO maker error: Descriptor miscounting." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','D','e','s','c','r','i','p','t','o','r',' ','m','i','s','c','o','u','n','t','i','n','g','.',
/* 0x0a963 = "Error reading a certificate in PEM format from BIO." */
    '\xc0','r','e','a','d','i','n','g',' ','a',' ','\x9e','\x0f','P','E','M',' ','f','o','r','m','a','t',' ','f','r','o','m',' ','B','I','O','.',
/* 0x0a984 = "Reason for leaving RC: #PF for monitored patch page." */
    '\x93','\x10','\x81','R','C',':',' ','#','P','F',' ','\x10','m','o','n','i','t','o','r','e','d',' ','p','a','t','c','h',' ','p','a','g','e','.',
/* 0x0a9a5 = "The ELF loader doesn't handle foreign endianness." */
    '\x03','E','L','F',' ','\xd8','\xc7','h','a','n','d','l','e',' ','f','o','r','e','i','g','n',' ','e','n','d','i','a','n','n','e','s','s','.',
/* 0x0a9c6 = "Reason for leaving RC: #GP with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','#','G','P',' ','\x80','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x83',
/* 0x0a9e7 = "Process Verification Failure: Unexpected section protection flag combination." */
    '\x1e','\x0d','\x12','\x94','\xda','p','r','o','t','e','c','t','i','o','n',' ','f','l','a','g',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0aa08 = "Reason for leaving RC: #PF with EIP pointing to patch code." */
    '\x93','\x10','\x81','R','C',':',' ','#','P','F',' ','\x80','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x0a','p','a','t','c','h',' ','\x83',
/* 0x0aa29 = "An operation caused a nested-guest SVM #VMEXIT." */
    'A','n',' ','\x96','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xbb','S','V','M',' ','#','V','M','E','X','I','T','.',
/* 0x0aa4a = "There is not enough room to store the data." */
    'T','h','e','r','e',' ','\x0b','\x08','e','n','o','u','g','h',' ','r','o','o','m',' ','\x0a','s','t','o','r','e',' ','\x02','d','a','t','a','.',
/* 0x0aa6b = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','H','E','A','D','E','R','_','I','D',
/* 0x0aa8c = "The networking interface to filter was not found." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x0a','f','i','l','t','e','r',' ','\x11','\x08','\x88',
/* 0x0aaad = "Error extracting RSA from the public key." */
    '\xc0','e','x','t','r','a','c','t','i','n','g',' ','R','S','A',' ','f','r','o','m',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0aace = "Can\'t send after socket shutdown." */
    'C','a','n','\'','t',' ','s','e','n','d',' ','a','f','t','e','r',' ','s','o','c','k','e','t',' ','s','h','u','t','d','o','w','n','.',
/* 0x0aaef = "VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','E','M','B','E','D','D','E','D','_','Z','E','R','O','_','C','H','A','R',
/* 0x0ab10 = "Security (en/decryption) engine error." */
    'S','e','c','u','r','i','t','y',' ','(','e','n','/','d','e','c','r','y','p','t','i','o','n',')',' ','e','n','g','i','n','e',' ','\x84',
/* 0x0ab31 = "Import ISO contains a root directory with a bad record length." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x26','\x80','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0ab52 = "The logical volume descriptor has a too big partition map." */
    '\x03','l','o','g','i','c','a','l',' ','\xd1','\xee','\x7b','a',' ','\xa0','b','i','g',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p','.',
/* 0x0ab73 = "A path does not start with a root specification." */
    'A',' ','\xd0','\xb2','\x08','s','t','a','r','t',' ','\x80','a',' ','r','o','o','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',
/* 0x0ab94 = "Saving the VM state is temporarily not allowed." */
    'S','a','v','i','n','g',' ','\x02','\xcc',' ','\xcd','\x0b','t','e','m','p','o','r','a','r','i','l','y',' ','\x08','a','l','l','o','w','e','d','.',
/* 0x0abb5 = "Emulate split-lock access on SMP." */
    'E','m','u','l','a','t','e',' ','s','p','l','i','t','-','l','o','c','k',' ','a','c','c','e','s','s',' ','o','n',' ','S','M','P','.',
/* 0x0abd6 = "Invalid or unsupported logical block size." */
    '\x0c','\xa9','u','n','s','u','p','p','o','r','t','e','d',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e','.',
/* 0x0abf7 = "The file list doesn't match to the content of the manifest file." */
    '\x03','\x1f','l','i','s','t',' ','\xc7','m','a','t','c','h',' ','\x0a','\x02','\xed','\x15','\x02','m','a','n','i','f','e','s','t',' ','f','i','l','e','.',
/* 0x0ac18 = "The tracer has already been opened in this sesssion." */
    '\x03','t','r','a','c','e','r',' ','\x7b','\x7f','\xca','o','p','e','n','e','d',' ','\x0f','t','h','i','s',' ','s','e','s','s','s','i','o','n','.',
/* 0x0ac39 = "Attempted to enabled a breakpoint which was already enabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','e','n','a','b','l','e','d',' ','a',' ','\xbf','\xeb','\x11','\x7f','e','n','a','b','l','e','d','.',
/* 0x0ac5a = "Software caused connection abort." */
    'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','.',
/* 0x0ac7b = "Missing length element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','l','e','n','g','t','h',' ','\x5c','\x0f','\xb1','\x15','\xed','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0ac9b = "Invalid session ID in managed object reference." */
    '\x0c','s','e','s','s','i','o','n',' ','I','D',' ','\x0f','m','a','n','a','g','e','d',' ','\xa7','r','e','f','e','r','e','n','c','e','.',
/* 0x0acbb = "A non-directory operation was attempted on a directory object." */
    'A',' ','n','o','n','-','\x26','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x26','o','b','j','e','c','t','.',
/* 0x0acdb = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','C','H','E','C','K','S','U','M',
/* 0x0acfb = "Guest tried to trigger a CPU hang." */
    'G','u','e','s','t',' ','t','r','i','e','d',' ','\x0a','t','r','i','g','g','e','r',' ','a',' ','C','P','U',' ','h','a','n','g','.',
/* 0x0ad1b = "VERR_TRACELOG_READER_LOG_UNSUPPORTED" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','L','O','G','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x0ad3b = "A directory operation was attempted on a non-directory object." */
    'A',' ','\x26','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x26','o','b','j','e','c','t','.',
/* 0x0ad5b = "The machine uuid field wasn\'t null." */
    '\x03','m','a','c','h','i','n','e',' ','u','u','i','d',' ','f','i','e','l','d',' ','w','a','s','n','\'','t',' ','n','u','l','l','.',
/* 0x0ad7b = "The disk has a cache attached already." */
    '\x03','d','i','s','k',' ','\x7b','a',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x0ad9b = "FAM failed to add a file to the list to be monitored." */
    'F','A','M',' ','\x98','\x0a','a','d','d',' ','a',' ','\x1f','\x0a','\x02','l','i','s','t',' ','\x0a','\xa8','m','o','n','i','t','o','r','e','d','.',
/* 0x0adbb = "No unwind information for the specified location." */
    '\xe6','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x10','\x02','\x18','l','o','c','a','t','i','o','n','.',
/* 0x0addb = "Data connection limit has been reached." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','l','i','m','i','t',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x0adfb = "The GIM provider does not support any hypercalls." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\xb2','\x08','\xce','a','n','y',' ','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0ae1b = "VERR_GSTCTL_MAX_CID_SESSIONS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','S','E','S','S','I','O','N','S','_','R','E','A','C','H','E','D',
/* 0x0ae3b = "Reason for leaving RC: A triple-fault condition." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','t','r','i','p','l','e','-','f','a','u','l','t',' ','c','o','n','d','i','t','i','o','n','.',
/* 0x0ae5b = "Termination record CRC mismatch." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x0ae7b = "VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO" */
    '\x01','\x22','\xe3','S','I','G','N','E','R','_','I','N','F','O','_','\x60','I','S','S','U','E','R','_','S','E','R','I','A','L','_','N','O',
/* 0x0ae9b = "Duplicate symbol within the module." */
    'D','u','p','l','i','c','a','t','e',' ','s','y','m','b','o','l',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',
/* 0x0aebb = "Unsupported domain ID in logical volume descriptor." */
    '\x97','d','o','m','a','i','n',' ','I','D',' ','\x0f','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0aedb = "The network is busy or is out of resources." */
    '\x03','n','e','t','w','o','r','k',' ','\x0b','b','u','s','y',' ','\xa9','\x0b','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s','.',
/* 0x0aefb = "The handle ID is already present in the poll set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x0b','\x7f','p','r','e','s','e','n','t',' ','\x0f','\x02','p','o','l','l',' ','s','e','t','.',
/* 0x0af1b = "Precodition no 0 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','0',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7d',
/* 0x0af3b = "The remote host couldn\'t be resolved." */
    '\x03','r','e','m','o','t','e',' ','h','o','s','t',' ','c','o','u','l','d','n','\'','t',' ','\xa8','r','e','s','o','l','v','e','d','.',
/* 0x0af5b = "No 32-bit to 64-bit switcher in place." */
    '\xe6','3','2','-','b','i','t',' ','\x0a','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r',' ','\x0f','p','l','a','c','e','.',
/* 0x0af7b = "Encountered an unsupported GNU Tar extension." */
    '\xa5','\x87','u','n','s','u','p','p','o','r','t','e','d',' ','G','N','U',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0af9b = "The DTB structs block contains an invalid node name." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x8a','\x87','\x8f','n','o','d','e',' ','n','a','m','e','.',
/* 0x0afbb = "Send pagefault timeout in receive." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0f','r','e','c','e','i','v','e','.',
/* 0x0afdb = "The checksum of a tar header record doesn't match." */
    '\x03','c','h','e','c','k','s','u','m',' ','\x15','a',' ','t','a','r',' ','\xb3','r','e','c','o','r','d',' ','\xc7','m','a','t','c','h','.',
/* 0x0affb = "Process Verification Failure: Error querying thread information." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','t','h','r','e','a','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0b01b = "Not permitted to open the USB device." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x0a','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x0b03b = "VERR_HTTP_CACERT_CANNOT_AUTHENTICATE" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','C','A','N','N','O','T','_','A','U','T','H','E','N','T','I','C','A','T','E',
/* 0x0b05b = "VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC" */
    '\x01','\xa2','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A','_','F','O','R','_','D','E','S','C','_','C','R','C',
/* 0x0b07b = "The volume map doesn't contain any valid volume." */
    '\x03','\xd1','m','a','p',' ','\xc7','c','o','n','t','a','i','n',' ','a','n','y',' ','v','a','l','i','d',' ','v','o','l','u','m','e','.',
/* 0x0b09b = "Internal ISO maker error: Buggy namespace table." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','B','u','g','g','y',' ','n','a','m','e','s','p','a','c','e',' ','t','a','b','l','e','.',
/* 0x0b0bb = "Certificate extensions requires certificate version 3 or later." */
    '\xba','e','x','t','e','n','s','i','o','n','s',' ','r','e','q','u','i','r','e','s',' ','\x9e','\xcf','3',' ','\xa9','l','a','t','e','r','.',
/* 0x0b0db = "VERR_GMM_SHARED_MODULE_ADDRESS_CLASH" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','A','D','D','R','E','S','S','_','C','L','A','S','H',
/* 0x0b0fb = "An unknown config value was encountered." */
    'A','n',' ','u','n','k','n','o','w','n',' ','c','o','n','f','i','g',' ','\xfa','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0b11b = "Signed data verification failed due to key usage issues." */
    'S','i','g','n','e','d',' ','\x9c','\xf6','\x98','d','u','e',' ','\x0a','k','e','y',' ','u','s','a','g','e',' ','i','s','s','u','e','s','.',
/* 0x0b13b = "A non-file operation was attempted on a file object." */
    'A',' ','n','o','n','-','\x1f','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x1f','o','b','j','e','c','t','.',
/* 0x0b15b = "Precodition no 1 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','1',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7d',
/* 0x0b17b = "VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS" */
    '\x01','\x22','S','P','C','_','P','E','I','M','A','G','E','_','M','U','L','T','I','P','L','E','_','H','A','S','H','_','T','A','B','S',
/* 0x0b19b = "Recording limit (time, size, ..." */
    'R','e','c','o','r','d','i','n','g',' ','l','i','m','i','t',' ','(','t','i','m','e',',',' ','s','i','z','e',',',' ','.','.','.',
/* 0x0b1bb = "The file is not a valid /proc/kallsyms file." */
    '\x03','\x1f','\x0b','\x08','a',' ','v','a','l','i','d',' ','/','p','r','o','c','/','k','a','l','l','s','y','m','s',' ','f','i','l','e','.',
/* 0x0b1db = "Precodition no 3 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','3',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7d',
/* 0x0b1fb = "Couldn\'t find the USB Proxy device." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','U','S','B',' ','P','r','o','x','y',' ','d','e','v','i','c','e','.',
/* 0x0b21b = "Image Verification Failure: No Authenticode Signature." */
    'I','m','a','g','e',' ','\x0d','\x12','\xe6','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e','.',
/* 0x0b23b = "Descriptor tag sector number mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','s','e','c','t','o','r',' ','\xf9','m','i','s','m','a','t','c','h','.',
/* 0x0b25b = "VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION" */
    '\x01','\xb0','F','I','E','L','D','_','L','O','A','D','_','O','N','L','Y','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0b27b = "Syntax error - too many arguments for static storage." */
    '\xf7','\x09','-',' ','\xa0','\xb4','a','r','g','u','m','e','n','t','s',' ','\x10','s','t','a','t','i','c',' ','s','t','o','r','a','g','e','.',
/* 0x0b29b = "validation of the loader section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','\xd8','\xda','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x7d',
/* 0x0b2bb = "The VTG object for the session or image has already been registered." */
    '\x03','V','T','G',' ','\xa7','\x10','\x02','s','e','s','s','i','o','n',' ','\xa9','\x25','\x7b','\x7f','\xca','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0b2db = "HMR0Leave was called on the wrong CPU." */
    'H','M','R','0','L','e','a','v','e',' ','\x11','c','a','l','l','e','d',' ','o','n',' ','\x02','w','r','o','n','g',' ','C','P','U','.',
/* 0x0b2fb = "Recompiler: Too deeply nested conditionals." */
    '\x13','T','o','o',' ','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','c','o','n','d','i','t','i','o','n','a','l','s','.',
/* 0x0b31b = "Asynchronous I/O is not finished yet." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x0b','\x08','f','i','n','i','s','h','e','d',' ','y','e','t','.',
/* 0x0b33b = "Precodition no 2 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','n','o',' ','2',' ','\x0f','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x7d',
/* 0x0b35b = "Recompiler: Out of memory for the instruction buffer (regular heap)." */
    '\x13','O','u','t',' ','\x15','\x85','\x10','\x02','\xd9','b','u','f','f','e','r',' ','(','r','e','g','u','l','a','r',' ','h','e','a','p',')','.',
/* 0x0b37b = "Internal ISO maker error: Boot catalog file handle problem." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','B','o','o','t',' ','\xe5','\x1f','h','a','n','d','l','e',' ','p','r','o','b','l','e','m','.',
/* 0x0b39b = "Return to ring-3 to read the MSR there." */
    'R','e','t','u','r','n',' ','\x0a','r','i','n','g','-','3',' ','\x0a','r','e','a','d',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0b3bb = "GVMM ran into some broken IPRT code." */
    'G','V','M','M',' ','r','a','n',' ','i','n','t','o',' ','s','o','m','e',' ','b','r','o','k','e','n',' ','I','P','R','T',' ','\x83',
/* 0x0b3db = "A file operation was attempted on a non-file object." */
    'A',' ','\x1f','\x96','\x11','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x1f','o','b','j','e','c','t','.',
/* 0x0b3fb = "Failed to open underlying link instance." */
    '\x8b','\x0a','o','p','e','n',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','i','n','s','t','a','n','c','e','.',
/* 0x0b41b = "Warning X509 certificate isn\'t self signed." */
    'W','a','r','n','i','n','g',' ','X','5','0','9',' ','\x9e','i','s','n','\'','t',' ','s','e','l','f',' ','s','i','g','n','e','d','.',
/* 0x0b43b = "A non-directory entry has a name ending with a slash." */
    'A',' ','n','o','n','-','\x26','\xc8','\x7b','a',' ','n','a','m','e',' ','e','n','d','i','n','g',' ','\x80','a',' ','s','l','a','s','h','.',
/* 0x0b45b = "VERR_RT_REQUEST_STATUS_STILL_PENDING" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0b47b = "Stack overflow during AVL tree operation." */
    'S','t','a','c','k',' ','o','v','e','r','f','l','o','w',' ','d','u','r','i','n','g',' ','A','V','L',' ','t','r','e','e',' ','\xe8',
/* 0x0b49b = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX" */
    '\x01','\x22','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','A','X',
/* 0x0b4bb = "The NotBefore and NotAfter values of an X." */
    '\x03','N','o','t','B','e','f','o','r','e',' ','\x99','N','o','t','A','f','t','e','r',' ','v','a','l','u','e','s',' ','\x15','\x87','X','.',
/* 0x0b4db = "File set descriptor has a next extent member." */
    'F','i','l','e',' ','s','e','t',' ','\xee','\x7b','a',' ','n','e','x','t',' ','e','x','t','e','n','t',' ','m','e','m','b','e','r','.',
/* 0x0b4fb = "Missing offset element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','o','f','f','s','e','t',' ','\x5c','\x0f','\xb1','\x15','\xed','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0b51b = "PDMVMMDevHeapR3ToGCPhys failure." */
    'P','D','M','V','M','M','D','e','v','H','e','a','p','R','3','T','o','G','C','P','h','y','s',' ','f','a','i','l','u','r','e','.',
/* 0x0b53b = "There is no cache attached to the disk." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','\x0a','\x02','d','i','s','k','.',
/* 0x0b55b = "VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\x24','\x89','R','O','O','T','_','D','I','R','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0b57b = "Import ISO contains a zero sized root directory." */
    '\xc3','\xc1',' ','\x8a','a',' ','z','e','r','o',' ','s','i','z','e','d',' ','r','o','o','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0b59b = "CAcert is missing or has the wrong format." */
    'C','A','c','e','r','t',' ','\x0b','m','i','s','s','i','n','g',' ','\xa9','\x7b','\x02','w','r','o','n','g',' ','f','o','r','m','a','t','.',
/* 0x0b5bb = "FAM failed to add a directory to the list to be monitored." */
    'F','A','M',' ','\x98','\x0a','a','d','d',' ','a',' ','\x26','\x0a','\x02','l','i','s','t',' ','\x0a','\xa8','m','o','n','i','t','o','r','e','d','.',
/* 0x0b5db = "Bad UTF-16 surrogate pair sequence." */
    '\x9d','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0b5fb = "VRDP script has completed its task." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','\x7b','c','o','m','p','l','e','t','e','d',' ','i','t','s',' ','t','a','s','k','.',
/* 0x0b61b = "The requested feature is not supported in raw-mode." */
    '\x03','\xdd','f','e','a','t','u','r','e',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\x0f','r','a','w','-','m','o','d','e','.',
/* 0x0b63b = "The DBGF has no more free breakpoint owner handles." */
    '\x03','\xb9',' ','\x7b','n','o',' ','m','o','r','e',' ','f','r','e','e',' ','\xbf','o','w','n','e','r',' ','h','a','n','d','l','e','s','.',
/* 0x0b65b = "Reason for leaving RC: Partly handled GDT write." */
    '\x93','\x10','\x81','R','C',':',' ','P','a','r','t','l','y',' ','h','a','n','d','l','e','d',' ','G','D','T',' ','w','r','i','t','e','.',
/* 0x0b67b = "Reason for leaving RC: A Ring switch was attempted." */
    '\x93','\x10','\x81','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x11','a','t','t','e','m','p','t','e','d','.',
/* 0x0b69b = "Process Verification Failure: Error query virtual memory mapping name." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x85','m','a','p','p','i','n','g',' ','n','a','m','e','.',
/* 0x0b6bb = "OpenSSL failed to initialize the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x98','\x0a','i','n','i','t','i','a','l','i','z','e',' ','\x02','\xd6','\xd3','c','o','n','t','e','x','t','.',
/* 0x0b6db = "Unresolved (unknown) semaphore error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','m','a','p','h','o','r','e',' ','\x84',
/* 0x0b6fb = "VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','F','E','A','T','U','R','E','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x0b71b = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN" */
    '\x01','\x22','\xb7','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','I','N',
/* 0x0b73b = "Device creation failed because the USB device name was not found." */
    'D','e','v','i','c','e',' ','c','r','e','a','t','i','o','n',' ','\x98','\x40','\x02','U','S','B',' ','\xa3','n','a','m','e',' ','\x11','\x08','\x88',
/* 0x0b75b = "Incompatible CPUM configuration." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','C','P','U','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0b77b = "Host operating system related error." */
    'H','o','s','t',' ','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m',' ','r','e','l','a','t','e','d',' ','\x84',
/* 0x0b79a = "VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','I','D','T','_','F','A','U','L','T',
/* 0x0b7b9 = "VERR_GSTCTL_MAX_CID_OBJECTS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0b7d8 = "VERR_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\x01','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0b7f7 = "Image Verification Failure: Error allocating memory for section headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\x85','\x10','\xda','h','e','a','d','e','r','s','.',
/* 0x0b816 = "Process Verification Failure: An image mapping failed to report a name." */
    '\x1e','\x0d','\x12','A','n',' ','\x25','m','a','p','p','i','n','g',' ','\x98','\x0a','r','e','p','o','r','t',' ','a',' ','n','a','m','e','.',
/* 0x0b835 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x05','B','O','O','T','_','I','N','D',
/* 0x0b854 = "The signal being posted is not correct." */
    '\x03','s','i','g','n','a','l',' ','b','e','i','n','g',' ','p','o','s','t','e','d',' ','\x0b','\x08','c','o','r','r','e','c','t','.',
/* 0x0b873 = "Internal ISO maker error: Namespace problem #4." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','4','.',
/* 0x0b892 = "The EMT was not blocked at the time of the call." */
    '\x03','E','M','T',' ','\x11','\x08','b','l','o','c','k','e','d',' ','a','t',' ','\x02','t','i','m','e',' ','\x15','\x02','c','a','l','l','.',
/* 0x0b8b1 = "Misconfigured driver chain transformation." */
    'M','i','s','c','o','n','f','i','g','u','r','e','d',' ','\xc5','\x9f','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0b8d0 = "Unresolved (unknown) disk i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','d','i','s','k',' ','i','/','o',' ','\x84',
/* 0x0b8ef = "Can\'t unlock - region was not locked." */
    'C','a','n','\'','t',' ','u','n','l','o','c','k',' ','-',' ','r','e','g','i','o','n',' ','\x11','\x08','l','o','c','k','e','d','.',
/* 0x0b90e = "VFS chain element takes exactly one argument." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0b92d = "Missing encoding element for XAR data stream." */
    'M','i','s','s','i','n','g',' ','e','n','c','o','d','i','n','g',' ','\x5c','\x10','X','A','R',' ','\x9c','s','t','r','e','a','m','.',
/* 0x0b94c = "NEM failed to create a native VM instance." */
    '\xec',' ','\x98','\x0a','c','r','e','a','t','e',' ','a',' ','n','a','t','i','v','e',' ','\xcc',' ','i','n','s','t','a','n','c','e','.',
/* 0x0b96b = "The connection to the FAM daemon was lost." */
    '\x03','c','o','n','n','e','c','t','i','o','n',' ','\x0a','\x02','F','A','M',' ','d','a','e','m','o','n',' ','\x11','l','o','s','t','.',
/* 0x0b98a = "NEM can only operate from ring-3." */
    '\xec',' ','c','a','n',' ','o','n','l','y',' ','o','p','e','r','a','t','e',' ','f','r','o','m',' ','r','i','n','g','-','3','.',
/* 0x0b9a9 = "Concurrent access to the object is not allowed." */
    'C','o','n','c','u','r','r','e','n','t',' ','a','c','c','e','s','s',' ','\x0a','\x02','\xa7','\x0b','\x08','a','l','l','o','w','e','d','.',
/* 0x0b9c8 = "VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY" */
    '\x01','\x8c','G','C','P','H','Y','S','_','R','A','N','G','E','_','C','R','O','S','S','E','S','_','B','O','U','N','D','A','R','Y',
/* 0x0b9e7 = "Trailing element separator not permitted." */
    'T','r','a','i','l','i','n','g',' ','\x5c','s','e','p','a','r','a','t','o','r',' ','\x08','p','e','r','m','i','t','t','e','d','.',
/* 0x0ba06 = "Not a uniform standard tape v0." */
    'N','o','t',' ','a',' ','u','n','i','f','o','r','m',' ','s','t','a','n','d','a','r','d',' ','t','a','p','e',' ','v','0','.',
/* 0x0ba25 = "Deferred loading of information failed." */
    'D','e','f','e','r','r','e','d',' ','l','o','a','d','i','n','g',' ','\x15','i','n','f','o','r','m','a','t','i','o','n',' ','\x7d',
/* 0x0ba44 = "VFS chain does not terminate with the desired object type." */
    '\x8d',' ','\x9f','\xb2','\x08','t','e','r','m','i','n','a','t','e',' ','\x80','\x02','d','e','s','i','r','e','d',' ','\xa7','t','y','p','e','.',
/* 0x0ba63 = "VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL" */
    '\x01','\x9b','F','I','X','U','P','_','S','H','O','R','T','_','J','M','P','_','T','O','_','T','A','I','L','_','L','A','B','E','L',
/* 0x0ba82 = "The chunk has already been mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x7b','\x7f','\xca','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0baa1 = "VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','G','D','T','_','F','A','U','L','T',
/* 0x0bac0 = "Internal ISO maker error: Namespace problem #6." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','6','.',
/* 0x0badf = "Detected unsafe code for patching." */
    'D','e','t','e','c','t','e','d',' ','u','n','s','a','f','e',' ','c','o','d','e',' ','\x10','p','a','t','c','h','i','n','g','.',
/* 0x0bafe = "Internal ISO maker error: Namespace problem #5." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','5','.',
/* 0x0bb1d = "VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','V','S','_','I','P','R','T','_','S','I','G','N','A','T','U','R','E','_','\xfe',
/* 0x0bb3c = "VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE" */
    '\x01','\x95','\xbd','\x06','V','A','L','I','D','_','K','E','R','N','E','L','_','C','O','D','E','_','S','I','G','N','A','T','U','R','E',
/* 0x0bb5b = "VERR_VMM_CONTEXT_HOOK_STILL_ENABLED" */
    '\x01','V','M','M','_','C','O','N','T','E','X','T','_','H','O','O','K','_','S','T','I','L','L','_','E','N','A','B','L','E','D',
/* 0x0bb7a = "VERR_VM_REQUEST_STATUS_STILL_PENDING" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0bb99 = "VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\x24','\x89','D','I','R','_','R','E','C','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0bbb8 = "Internal error in read-write critical section." */
    '\x07','\x09','\x0f','r','e','a','d','-','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0bbd7 = "The size of the raw image is not dividable by 2048." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','\x25','\x0b','\x08','d','i','v','i','d','a','b','l','e',' ','\xdf','2','0','4','8','.',
/* 0x0bbf6 = "Internal ISO maker error: Namespace problem #1." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0bc15 = "No more search handles available." */
    '\xe6','m','o','r','e',' ','s','e','a','r','c','h',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x0bc34 = "Unknown character class in glob pattern." */
    '\xf8','c','h','a','r','a','c','t','e','r',' ','c','l','a','s','s',' ','\x0f','g','l','o','b',' ','p','a','t','t','e','r','n','.',
/* 0x0bc53 = "Internal ISO maker error: Namespace problem #2." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','2','.',
/* 0x0bc72 = "Internal ISO maker error: Expected path to start with root slash." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','\xb8','\xd0','\x0a','s','t','a','r','t',' ','\x80','r','o','o','t',' ','s','l','a','s','h','.',
/* 0x0bc91 = "Pending interrupt is masked by TPR." */
    'P','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t',' ','\x0b','m','a','s','k','e','d',' ','\xdf','T','P','R','.',
/* 0x0bcb0 = "Shared Clipboard transfer ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r',' ','I','D',' ','\x08','\x88',
/* 0x0bccf = "The DEK for disk encryption is missing." */
    '\x03','D','E','K',' ','\x10','d','i','s','k',' ','e','n','c','r','y','p','t','i','o','n',' ','\x0b','m','i','s','s','i','n','g','.',
/* 0x0bcee = "VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED" */
    '\x01','S','H','M','E','M','_','M','A','X','I','M','U','M','_','M','A','P','P','I','N','G','S','_','R','E','A','C','H','E','D',
/* 0x0bd0d = "VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS" */
    '\x01','\x22','S','P','C','_','I','N','D','_','D','A','T','A','_','\xbe','A','L','G','O','_','\x06','I','N','_','\xbe','A','L','G','O','S',
/* 0x0bd2c = "No clipboard data available for requested format." */
    '\xe6','c','l','i','p','b','o','a','r','d',' ','\x9c','a','v','a','i','l','a','b','l','e',' ','\x10','\xdd','f','o','r','m','a','t','.',
/* 0x0bd4b = "VWRN_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\xe4','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0bd6a = "VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC" */
    '\x01','\x24','\x89','M','I','S','M','A','T','C','H','I','N','G','_','M','U','L','T','I','_','E','X','T','E','N','T','_','R','E','C',
/* 0x0bd89 = "Process Verification Failure: Error query virtual memory information." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x85','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0bda8 = "VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED" */
    '\x0e','A','U','D','I','O','_','S','T','R','E','A','M','_','A','S','Y','N','C','_','I','N','I','T','_','N','E','E','D','E','D',
/* 0x0bdc7 = "VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY" */
    '\x01','\x24','\x89','S','U','P','P','L','E','M','E','N','T','A','R','Y','_','B','E','F','O','R','E','_','P','R','I','M','A','R','Y',
/* 0x0bde6 = "VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','L','D','T','_','F','A','U','L','T',
/* 0x0be05 = "Invalid instruction length passed to an IEM function." */
    '\x0c','\xd9','l','e','n','g','t','h',' ','p','a','s','s','e','d',' ','\x0a','\x87','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0be24 = "Bad or missing XAR checksum element." */
    '\x9d','\xa9','m','i','s','s','i','n','g',' ','X','A','R',' ','c','h','e','c','k','s','u','m',' ','e','l','e','m','e','n','t','.',
/* 0x0be43 = "There is no volume behind the current one." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','\xd1','b','e','h','i','n','d',' ','\x02','c','u','r','r','e','n','t',' ','o','n','e','.',
/* 0x0be62 = "Unsupported interface for managed object reference." */
    '\x97','i','n','t','e','r','f','a','c','e',' ','\x10','m','a','n','a','g','e','d',' ','\xa7','r','e','f','e','r','e','n','c','e','.',
/* 0x0be81 = "Import ISO contains a root directory without the directory flag set." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x26','w','i','t','h','o','u','t',' ','\x02','\x26','f','l','a','g',' ','s','e','t','.',
/* 0x0bea0 = "Recompiler: Translation block allocation failed." */
    '\x13','T','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k',' ','a','l','l','o','c','a','t','i','o','n',' ','\x7d',
/* 0x0bebf = "Internal ISO maker error: Namespace problem #3." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','3','.',
/* 0x0bede = "Go ahead with the default Read/Write operation." */
    'G','o',' ','a','h','e','a','d',' ','\x80','\x02','d','e','f','a','u','l','t',' ','R','e','a','d','/','W','r','i','t','e',' ','\xe8',
/* 0x0befd = "The module contains no symbol information." */
    '\x03','m','o','d','u','l','e',' ','\x8a','n','o',' ','s','y','m','b','o','l',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0bf1c = "Unresolved (unknown) pipe i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','p','i','p','e',' ','i','/','o',' ','\x84',
/* 0x0bf3b = "Process Verification Failure: A DLL was found more than once." */
    '\x1e','\x0d','\x12','A',' ','D','L','L',' ','\x11','f','o','u','n','d',' ','m','o','r','e',' ','t','h','a','n',' ','o','n','c','e','.',
/* 0x0bf5a = "Unabled to locate an OpenGL symbol." */
    'U','n','a','b','l','e','d',' ','\x0a','l','o','c','a','t','e',' ','\x87','O','p','e','n','G','L',' ','s','y','m','b','o','l','.',
/* 0x0bf79 = "AMD-V CPU extension not available." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x08','a','v','a','i','l','a','b','l','e','.',
/* 0x0bf98 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','R','E','S','E','R','V','E','D','_','F','L','A','G',
/* 0x0bfb7 = "VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','N','E','S','T','E','D','_','P','A','G','I','N','G',
/* 0x0bfd6 = "Too many volume descriptors in the import ISO." */
    'T','o','o',' ','\xb4','\xd1','d','e','s','c','r','i','p','t','o','r','s',' ','\x0f','\x02','i','m','p','o','r','t',' ','I','S','O','.',
/* 0x0bff5 = "VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS" */
    '\x01','\x22','S','P','C','_','\x06','E','X','A','C','T','L','Y','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x0c014 = "VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','T','S','S','_','F','A','U','L','T',
/* 0x0c033 = "Couldn\'t map pages during send." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','s','e','n','d','.',
/* 0x0c052 = "Tried to halt a VM or CPU that was already halted." */
    'T','r','i','e','d',' ','\x0a','h','a','l','t',' ','a',' ','\xcc',' ','\xa9','C','P','U',' ','\xac','\x11','\x7f','h','a','l','t','e','d','.',
/* 0x0c071 = "VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL" */
    '\x01','\x22','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','P','A','R','A','M','S','_','\x06','I','M','P','L',
/* 0x0c090 = "The image is too small or too large for this format." */
    '\x03','\x25','\x0b','\xa0','s','m','a','l','l',' ','\xa9','\xa0','l','a','r','g','e',' ','\x10','t','h','i','s',' ','f','o','r','m','a','t','.',
/* 0x0c0af = "Reason for leaving RZ: Pending I/O port write." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x0c0cd = "Reason for leaving RC: Caller the tracer in ring-0." */
    '\x93','\x10','\x81','R','C',':',' ','C','a','l','l','e','r',' ','\x02','t','r','a','c','e','r',' ','\x0f','r','i','n','g','-','0','.',
/* 0x0c0eb = "internal fixup chain isn\'t implemented yet." */
    '\x17','f','i','x','u','p',' ','\x9f','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0c109 = "The module contains no line number information." */
    '\x03','m','o','d','u','l','e',' ','\x8a','n','o',' ','l','i','n','e',' ','\xf9','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0c127 = "A path is relative, expected an absolute path." */
    'A',' ','\xd0','\x0b','r','e','l','a','t','i','v','e',',',' ','\xc9','\x87','a','b','s','o','l','u','t','e',' ','p','a','t','h','.',
/* 0x0c145 = "VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION" */
    '\x01','\x22','\xb7','T','B','S','C','E','R','T','_','D','U','P','L','I','C','A','T','E','_','E','X','T','E','N','S','I','O','N',
/* 0x0c163 = "VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','R','I','G','H','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0c181 = "Process Verification Failure: The image mapping is too large (>= 2GB)." */
    '\x1e','\x0d','\x12','\x03','\x25','m','a','p','p','i','n','g',' ','\x0b','\xa0','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0c19f = "The PE loader encountered a malformed certificate." */
    '\x03','P','E',' ','\xd8','\xae','a',' ','m','a','l','f','o','r','m','e','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c1bd = "PKIX cipher algorithm is not known to OpenSSL." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xd3','\x0b','\x08','k','n','o','w','n',' ','\x0a','O','p','e','n','S','S','L','.',
/* 0x0c1db = "VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT" */
    '\x01','\x24','\x89','N','O','N','_','C','O','N','T','I','G','U','O','U','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0c1f9 = "Missing size element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','s','i','z','e',' ','\x5c','\x0f','\xb1','\x15','\xed','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0c217 = "VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE" */
    '\x01','J','S','O','N','_','\x1d','S','U','R','R','O','G','A','T','E','_','P','A','I','R','_','S','E','Q','U','E','N','C','E',
/* 0x0c235 = "VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED" */
    '\x0e','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x9a','R','E','G','I','S','T','E','R','E','D',
/* 0x0c253 = "Internal processing error #1 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcb','m','a','p','p','i','n','g',' ','\x83',
/* 0x0c271 = "VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','R','A','M','_','P','R','E','A','L','L','O','C',
/* 0x0c28f = "The timer failed to reach a stable state." */
    '\x03','t','i','m','e','r',' ','\x98','\x0a','r','e','a','c','h',' ','a',' ','s','t','a','b','l','e',' ','s','t','a','t','e','.',
/* 0x0c2ad = "XML error while parsing the table of content." */
    'X','M','L',' ','\x09','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x0c2cb = "VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE" */
    '\x01','W','E','B','_','\x05','M','A','N','A','G','E','D','_','O','B','J','E','C','T','_','R','E','F','E','R','E','N','C','E',
/* 0x0c2e9 = "Import ISO contains a root directory with multiple extents." */
    '\xc3','\xc1',' ','\x8a','a',' ','r','o','o','t',' ','\x26','\x80','m','u','l','t','i','p','l','e',' ','e','x','t','e','n','t','s','.',
/* 0x0c307 = "Reason for leaving RC: attempt to patch MMIO write." */
    '\x93','\x10','\x81','R','C',':',' ','a','t','t','e','m','p','t',' ','\x0a','p','a','t','c','h',' ','\xd2',' ','w','r','i','t','e','.',
/* 0x0c325 = "VERR_TRACELOG_READER_MALFORMED_LOG" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','M','A','L','F','O','R','M','E','D','_','L','O','G',
/* 0x0c343 = "VT-x features disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','d','i','s','a','b','l','e','d',' ','\xdf','\x02','B','I','O','S','.',
/* 0x0c361 = "A digest doesn't match the corresponding file." */
    'A',' ','\xd6','\xc7','m','a','t','c','h',' ','\x02','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e','.',
/* 0x0c37f = "VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','C','O','M','_','\x1a',
/* 0x0c39d = "Internal processing error #3 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcb','m','a','p','p','i','n','g',' ','\x83',
/* 0x0c3bb = "OpenSSL failed to decode the private key." */
    'O','p','e','n','S','S','L',' ','\x98','\x0a','d','e','c','o','d','e',' ','\x02','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x0c3d9 = "VERR_HARDAVL_POINTER_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','P','O','I','N','T','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0c3f7 = "VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET" */
    '\x01','\x24','\x89','M','O','R','E','_','T','H','A','N','_','O','N','E','_','V','O','L','U','M','E','_','I','N','_','S','E','T',
/* 0x0c415 = "Import ISO contains a bad primary volume descriptor." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','p','r','i','m','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c433 = "Recompiler: Failed to allocate more memory for debug info." */
    '\x13','\x8b','\x0a','a','l','l','o','c','a','t','e',' ','m','o','r','e',' ','\x85','\x10','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x0c451 = "VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING" */
    '\x01','\x95','\xbd','\x2a','_','M','O','R','E','_','T','H','A','N','_','O','N','E','_','E','X','E','_','M','A','P','P','I','N','G',
/* 0x0c46f = "VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING" */
    '\x01','\xa1','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','C','O','N','S','T','R','U','C','T','E','D','_','\xd4',
/* 0x0c48d = "VERR_PGM_INTERMEDIATE_PAGING_CONFLICT" */
    '\x01','\x8c','I','N','T','E','R','M','E','D','I','A','T','E','_','P','A','G','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x0c4ab = "VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','C','H','A','R','S','_','\x06','V','A','L','I','D','_','U','T','F','8',
/* 0x0c4c9 = "Too many references: can\'t splice." */
    'T','o','o',' ','\xb4','r','e','f','e','r','e','n','c','e','s',':',' ','c','a','n','\'','t',' ','s','p','l','i','c','e','.',
/* 0x0c4e7 = "Import ISO contains a directory with an extent that is out of bounds." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x26','\x80','\x87','e','x','t','e','n','t',' ','\xac','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0c505 = "VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0c523 = "VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x16',
/* 0x0c541 = "Leading element separator not permitted." */
    'L','e','a','d','i','n','g',' ','\x5c','s','e','p','a','r','a','t','o','r',' ','\x08','p','e','r','m','i','t','t','e','d','.',
/* 0x0c55f = "Internal processing error while merging status codes." */
    '\x07','\x04','\x09','w','h','i','l','e',' ','m','e','r','g','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x0c57d = "VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','N','F','O','_','\x06','\x2a',
/* 0x0c59b = "Bad VTG argument list descriptor." */
    '\x9d','V','T','G',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c5b9 = "Image Verification Failure: More than one certificate table entry." */
    'I','m','a','g','e',' ','\x0d','\x12','M','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','\x9e','\xb1','e','n','t','r','y','.',
/* 0x0c5d7 = "Attempt to resume a running TSC." */
    'A','t','t','e','m','p','t',' ','\x0a','r','e','s','u','m','e',' ','a',' ','r','u','n','n','i','n','g',' ','T','S','C','.',
/* 0x0c5f5 = "The tracepoint provider object is too large." */
    '\x03','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xa7','\x0b','\xa0','l','a','r','g','e','.',
/* 0x0c613 = "The specified path does not point at a symbolic link." */
    '\x03','\x18','\xd0','\xb2','\x08','p','o','i','n','t',' ','a','t',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0c631 = "VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE" */
    '\x01','\x9b','E','M','I','T','_','F','I','X','E','D','_','J','U','M','P','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0c64f = "VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','R','S','A','_','P','A','D','_','\x1a',
/* 0x0c66d = "The path is not the same object as the native handle (hardening)." */
    '\x03','\xd0','\x0b','\x08','\x02','s','a','m','e',' ','\xa7','a','s',' ','\x02','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\xad',
/* 0x0c68b = "Too many loops looking for a page to reuse." */
    'T','o','o',' ','\xb4','l','o','o','p','s',' ','l','o','o','k','i','n','g',' ','\x10','a',' ','\xcb','\x0a','r','e','u','s','e','.',
/* 0x0c6a9 = "Expected PE image data inside indirect data object." */
    '\xb8','P','E',' ','\x25','\x9c','i','n','s','i','d','e',' ','i','n','d','i','r','e','c','t',' ','\x9c','o','b','j','e','c','t','.',
/* 0x0c6c7 = "One of the custom modes was incorrect." */
    'O','n','e',' ','\x15','\x02','c','u','s','t','o','m',' ','m','o','d','e','s',' ','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0c6e5 = "The size of the raw image is not dividable by 512." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','\x25','\x0b','\x08','d','i','v','i','d','a','b','l','e',' ','\xdf','5','1','2','.',
/* 0x0c703 = "VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER" */
    '\x01','\x95','\xbd','\x06','O','W','N','E','D','_','B','Y','_','T','R','U','S','T','E','D','_','I','N','S','T','A','L','L','E','R',
/* 0x0c721 = "Internal processing error #4 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcb','m','a','p','p','i','n','g',' ','\x83',
/* 0x0c73f = "Unfinished debug info reader code." */
    'U','n','f','i','n','i','s','h','e','d',' ','d','e','b','u','g',' ','i','n','f','o',' ','r','e','a','d','e','r',' ','\x83',
/* 0x0c75d = "VT-x VMCS field cache invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','f','i','e','l','d',' ','c','a','c','h','e',' ','i','n','v','a','l','i','d','.',
/* 0x0c77b = "Unresolved (unknown) network error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','n','e','t','w','o','r','k',' ','\x84',
/* 0x0c799 = "Found an illegal symbolic link (hardening)." */
    'F','o','u','n','d',' ','\x87','i','l','l','e','g','a','l',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\xad',
/* 0x0c7b7 = "Reason for leaving RC: Fatal trap in hypervisor." */
    '\x93','\x10','\x81','R','C',':',' ','F','a','t','a','l',' ','t','r','a','p',' ','\x0f','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0c7d5 = "Image Verification Failure: Error determining the file length." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','\x1f','l','e','n','g','t','h','.',
/* 0x0c7f3 = "Missing UTF-16 surrogate pair." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r','.',
/* 0x0c811 = "The DBGF couldn\'t find the specified breakpoint." */
    '\x03','\xb9',' ','c','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','\x18','b','r','e','a','k','p','o','i','n','t','.',
/* 0x0c82f = "Internal processing error #2 in the PGM physial page mapping code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xcb','m','a','p','p','i','n','g',' ','\x83',
/* 0x0c84d = "VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED" */
    '\x01','\x22','P','A','S','S','W','O','R','D','_','2','_','K','E','Y','_','D','E','R','I','V','I','A','T','I','O','N','_','\x16',
/* 0x0c86b = "VERR_AUDIO_STREAM_INIT_IN_PROGRESS" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','I','N','I','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0c889 = "Termination record integrity error." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x0c8a7 = "VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','O','G','_','I','N','I','T','_','\x16',
/* 0x0c8c5 = "VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x16',
/* 0x0c8e3 = "Invalid initialization vector length." */
    '\x0c','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','l','e','n','g','t','h','.',
/* 0x0c901 = "VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','I','N','T','E','G','E','R',
/* 0x0c91f = "The size of the raw floppy image is too big (>2." */
    '\x03','s','i','z','e',' ','\x15','\x02','r','a','w',' ','f','l','o','p','p','y',' ','\x25','\x0b','\xa0','b','i','g',' ','(','>','2','.',
/* 0x0c93d = "The DTB being parsed has a version set which is not supported." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','a',' ','\xcf','s','e','t',' ','\xeb','\x0b','\x08','\xa4',
/* 0x0c95b = "The specified CPU cannot be found in the CPU database." */
    '\x03','\x18','C','P','U',' ','\xe0','\xa8','f','o','u','n','d',' ','\x0f','\x02','C','P','U',' ','d','a','t','a','b','a','s','e','.',
/* 0x0c978 = "Encountered an bad (/unknown) record type." */
    '\xa5','\x87','b','a','d',' ','(','/','u','n','k','n','o','w','n',')',' ','r','e','c','o','r','d',' ','t','y','p','e','.',
/* 0x0c995 = "The display connector is resizing." */
    '\x03','d','i','s','p','l','a','y',' ','c','o','n','n','e','c','t','o','r',' ','\x0b','r','e','s','i','z','i','n','g','.',
/* 0x0c9b2 = "Too many instances of a usb device." */
    'T','o','o',' ','\xb4','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','u','s','b',' ','d','e','v','i','c','e','.',
/* 0x0c9cf = "VERR_X509_GETTING_EXTENSION_FROM_CERT" */
    '\x01','\xb7','G','E','T','T','I','N','G','_','E','X','T','E','N','S','I','O','N','_','F','R','O','M','_','C','E','R','T',
/* 0x0c9ec = "Failed to enable and lock VT-x features." */
    '\x8b','\x0a','e','n','a','b','l','e',' ','\x99','l','o','c','k',' ','V','T','-','x',' ','f','e','a','t','u','r','e','s','.',
/* 0x0ca09 = "Attempted to use stub switcher." */
    'A','t','t','e','m','p','t','e','d',' ','\x0a','u','s','e',' ','s','t','u','b',' ','s','w','i','t','c','h','e','r','.',
/* 0x0ca26 = "VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY" */
    '\x01','\xb7','E','X','T','R','A','C','T','_','R','S','A','_','F','R','O','M','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x0ca43 = "VERR_NET_CONNECTION_RESET_BY_PEER" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','S','E','T','_','B','Y','_','P','E','E','R',
/* 0x0ca60 = "No debug connection configured." */
    '\xe6','d','e','b','u','g',' ','c','o','n','n','e','c','t','i','o','n',' ','c','o','n','f','i','g','u','r','e','d','.',
/* 0x0ca7d = "The spill file grew larger than 4GB." */
    '\x03','s','p','i','l','l',' ','\x1f','g','r','e','w',' ','l','a','r','g','e','r',' ','t','h','a','n',' ','4','G','B','.',
/* 0x0ca9a = "The OpenSSL version is too old for the attempted operation." */
    '\x03','O','p','e','n','S','S','L',' ','\xcf','\x0b','\xa0','o','l','d',' ','\x10','\x02','a','t','t','e','m','p','t','e','d',' ','\xe8',
/* 0x0cab7 = "VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED" */
    '\x01','\x5e','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x9a','S','U','S','P','E','N','D','E','D',
/* 0x0cad4 = "Unresolved (unknown) search error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','a','r','c','h',' ','\x84',
/* 0x0caf1 = "Expected PKCS #7 object to not contain any CRLs." */
    '\xb8','P','K','C','S',' ','#','7',' ','\xa7','\x0a','\x08','c','o','n','t','a','i','n',' ','a','n','y',' ','C','R','L','s','.',
/* 0x0cb0e = "VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','D','E','F','L','A','T','E','_','\x1c','M','U','C','H',
/* 0x0cb2b = "Found bogus offset in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','o','f','f','s','e','t',' ','\x0f','\x02','\x1f','s','y','s','t','e','m','.',
/* 0x0cb48 = "Encountered an unexpected page state in the saved state." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xcb','\xcd','\x0f','\x02','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0cb65 = "Wrong locking order detected." */
    'W','r','o','n','g',' ','l','o','c','k','i','n','g',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0cb82 = "The recipient process has refused the signal." */
    '\x03','r','e','c','i','p','i','e','n','t',' ','\x92','\x7b','r','e','f','u','s','e','d',' ','\x02','s','i','g','n','a','l','.',
/* 0x0cb9f = "VERR_URI_MISSING_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\xc4','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0cbbc = "Invalid partition index in a location." */
    '\x0c','p','a','r','t','i','t','i','o','n',' ','i','n','d','e','x',' ','\x0f','a',' ','l','o','c','a','t','i','o','n','.',
/* 0x0cbd9 = "Process Verification Failure: The memory region is too large (>= 2GB)." */
    '\x1e','\x0d','\x12','\x03','\x85','r','e','g','i','o','n',' ','\x0b','\xa0','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0cbf6 = "VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','F','I','N','A','L','_','\x16',
/* 0x0cc13 = "VERR_FILE_AIO_INSUFFICIENT_RESSOURCES" */
    '\x01','\xab','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','R','E','S','S','O','U','R','C','E','S',
/* 0x0cc30 = "Internal error - this should never happen." */
    '\x07','\x09','-',' ','t','h','i','s',' ','s','h','o','u','l','d',' ','n','e','v','e','r',' ','h','a','p','p','e','n','.',
/* 0x0cc4d = "The installed support driver doesn't match the version of the user." */
    '\x03','i','n','s','t','a','l','l','e','d',' ','\xce','\xc5','\xc7','m','a','t','c','h',' ','\x02','\xcf','\x15','\x02','u','s','e','r','.',
/* 0x0cc6a = "No guest mappings when SMP is enabled." */
    '\xe6','\xbb','m','a','p','p','i','n','g','s',' ','w','h','e','n',' ','S','M','P',' ','\x0b','e','n','a','b','l','e','d','.',
/* 0x0cc87 = "VERR_X509_GETTING_DATA_FROM_EXTENSION" */
    '\x01','\xb7','G','E','T','T','I','N','G','_','D','A','T','A','_','F','R','O','M','_','E','X','T','E','N','S','I','O','N',
/* 0x0cca4 = "Found bogus values in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','v','a','l','u','e','s',' ','\x0f','\x02','\x1f','s','y','s','t','e','m','.',
/* 0x0ccc1 = "Error opening the ApiPort LPC object." */
    '\xc0','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0ccde = "VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0ccfb = "Trying to use too new winsock API." */
    'T','r','y','i','n','g',' ','\x0a','u','s','e',' ','\xa0','n','e','w',' ','w','i','n','s','o','c','k',' ','A','P','I','.',
/* 0x0cd18 = "The specified address range wraps around." */
    '\x03','\x18','a','d','d','r','e','s','s',' ','r','a','n','g','e',' ','w','r','a','p','s',' ','a','r','o','u','n','d','.',
/* 0x0cd35 = "VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED" */
    '\x01','\x95','\xbd','S','I','G','N','A','T','U','R','E','_','C','H','E','C','K','S','_','\x06','E','N','F','O','R','C','E','D',
/* 0x0cd52 = "OpenSSL failed to decode the public key." */
    'O','p','e','n','S','S','L',' ','\x98','\x0a','d','e','c','o','d','e',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0cd6f = "Destination address required." */
    'D','e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','.',
/* 0x0cd8c = "VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','R','I','V','A','T','E','_','K','E','Y','_','\x16',
/* 0x0cda9 = "VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED" */
    '\x01','\x5e','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x06','S','U','S','P','E','N','D','E','D',
/* 0x0cdc6 = "Wrong release order detected." */
    'W','r','o','n','g',' ','r','e','l','e','a','s','e',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x0cde3 = "An invalid LUN specification was given." */
    'A','n',' ','\x8f','L','U','N',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x11','g','i','v','e','n','.',
/* 0x0ce00 = "VERR_XML_TOC_ELEMENT_HAS_SIBLINGS" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','H','A','S','_','S','I','B','L','I','N','G','S',
/* 0x0ce1d = "VERR_SHCLPB_MAX_TRANSFERS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','T','R','A','N','S','F','E','R','S','_','R','E','A','C','H','E','D',
/* 0x0ce3a = "VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','O','P','E','N','_','\x16',
/* 0x0ce57 = "Unsupported PKCS #7 signer info version." */
    '\x97','P','K','C','S',' ','#','7',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','v','e','r','s','i','o','n','.',
/* 0x0ce74 = "Start instruction stepping (debug only)." */
    'S','t','a','r','t',' ','\xd9','s','t','e','p','p','i','n','g',' ','(','d','e','b','u','g',' ','o','n','l','y',')','.',
/* 0x0ce91 = "VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','L','E','F','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0ceae = "Object being in use prohibits operation." */
    'O','b','j','e','c','t',' ','b','e','i','n','g',' ','\x0f','u','s','e',' ','p','r','o','h','i','b','i','t','s',' ','\xe8',
/* 0x0cecb = "Reason for leaving RC: attempt to patch MMIO read." */
    '\x93','\x10','\x81','R','C',':',' ','a','t','t','e','m','p','t',' ','\x0a','p','a','t','c','h',' ','\xd2',' ','r','e','a','d','.',
/* 0x0cee8 = "The DTB being parsed is malformed." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x0cf05 = "VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS" */
    '\x01','L','D','R','L','X','_','\x89','O','R','D','I','N','A','L','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0cf22 = "Failed to derivate key from password." */
    '\x8b','\x0a','d','e','r','i','v','a','t','e',' ','k','e','y',' ','f','r','o','m',' ','p','a','s','s','w','o','r','d','.',
/* 0x0cf3f = "The specified data unit wasn\'t owned by caller." */
    '\x03','\x18','\x9c','u','n','i','t',' ','w','a','s','n','\'','t',' ','o','w','n','e','d',' ','\xdf','c','a','l','l','e','r','.',
/* 0x0cf5c = "Hit the global allocation limit." */
    'H','i','t',' ','\x02','g','l','o','b','a','l',' ','a','l','l','o','c','a','t','i','o','n',' ','l','i','m','i','t','.',
/* 0x0cf79 = "Syntax error - out of regular heap memory." */
    '\xf7','\x09','-',' ','o','u','t',' ','\x15','r','e','g','u','l','a','r',' ','h','e','a','p',' ','m','e','m','o','r','y','.',
/* 0x0cf96 = "VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED" */
    '\x01','\x9b','C','O','N','D','_','E','N','D','I','F','_','R','E','C','O','N','C','I','L','I','A','T','I','O','N','_','\x16',
/* 0x0cfb3 = "Unexpected NULL pointer to right subtree." */
    '\x94','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x0a','r','i','g','h','t',' ','s','u','b','t','r','e','e','.',
/* 0x0cfd0 = "Patch TPR access instruction." */
    'P','a','t','c','h',' ','T','P','R',' ','a','c','c','e','s','s',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0cfed = "VERR_TRACELOG_READER_ITERATOR_END" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x0d00a = "VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','\x60','R','A','M','_','R','A','N','G','E',
/* 0x0d027 = "VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','N','A','M','E','_','O','F','F','_','\x1c','L','A','R','G','E',
/* 0x0d044 = "VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER" */
    '\x01','X','A','R','_','\x06','S','T','R','E','A','M','B','L','E','_','E','L','E','M','E','N','T','_','O','R','D','E','R',
/* 0x0d061 = "VERR_AUDIO_STREAM_PENDING_DISABLE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','P','E','N','D','I','N','G','_','D','I','S','A','B','L','E',
/* 0x0d07e = "Encountered an unexpected page type in the saved state." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xcb','\xf1','\x0f','\x02','s','a','v','e','d',' ','s','t','a','t','e','.',
/* 0x0d09b = "VERR_VSCSI_LUN_ATTACHED_TO_DEVICE" */
    '\x01','V','S','C','S','I','_','L','U','N','_','A','T','T','A','C','H','E','D','_','T','O','_','D','E','V','I','C','E',
/* 0x0d0b8 = "VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE" */
    '\x01','\x5e','O','N','E','_','P','C','I','_','F','U','N','C','T','I','O','N','_','P','E','R','_','D','E','V','I','C','E',
/* 0x0d0d5 = "VFS chain element takes a directory (dir) object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x26','(','d','i','r',')',' ','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x0d0f2 = "Recompiler: No host register available for variables." */
    '\x13','\xe6','h','o','s','t',' ','\xe9','a','v','a','i','l','a','b','l','e',' ','\x10','v','a','r','i','a','b','l','e','s','.',
/* 0x0d10f = "Bad DWARF extended line number opcode." */
    '\x9d','D','W','A','R','F',' ','e','x','t','e','n','d','e','d',' ','l','i','n','e',' ','\xf9','o','p','c','o','d','e','.',
/* 0x0d12c = "Import module ordinal is out of bounds." */
    '\xc3','m','o','d','u','l','e',' ','o','r','d','i','n','a','l',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d149 = "VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS" */
    '\x01','\x24','\x89','M','U','L','T','I','P','L','E','_','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x0d166 = "The extracted data has exceeded the expected size." */
    '\x03','e','x','t','r','a','c','t','e','d',' ','\x9c','\x7b','e','x','c','e','e','d','e','d',' ','\x02','\xc9','s','i','z','e','.',
/* 0x0d183 = "The GIP update interval is too large." */
    '\x03','G','I','P',' ','u','p','d','a','t','e',' ','i','n','t','e','r','v','a','l',' ','\x0b','\xa0','l','a','r','g','e','.',
/* 0x0d1a0 = "The VM request was killed at VM termination." */
    '\x03','\xcc',' ','\xaa','\x11','k','i','l','l','e','d',' ','a','t',' ','\xcc',' ','t','e','r','m','i','n','a','t','i','o','n','.',
/* 0x0d1bd = "Malformed unwind information." */
    'M','a','l','f','o','r','m','e','d',' ','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0d1da = "The internal logger revision did not match." */
    '\x03','\x17','l','o','g','g','e','r',' ','r','e','v','i','s','i','o','n',' ','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x0d1f7 = "VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH" */
    '\x01','\x22','S','P','C','_','S','I','G','N','E','D','_','I','N','D','_','D','A','T','A','_','\xbe','A','L','G','O','_','\x19',
/* 0x0d214 = "VERR_GSTCTL_MAX_CID_COUNT_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','C','O','U','N','T','_','R','E','A','C','H','E','D',
/* 0x0d231 = "Send pagefault timeout in send." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0f','s','e','n','d','.',
/* 0x0d24e = "Output can be enabled for the client." */
    'O','u','t','p','u','t',' ','c','a','n',' ','\xa8','e','n','a','b','l','e','d',' ','\x10','\x02','c','l','i','e','n','t','.',
/* 0x0d26b = "The specified shared page was not actually private." */
    '\x03','\x18','s','h','a','r','e','d',' ','\xcb','\x11','\x08','a','c','t','u','a','l','l','y',' ','p','r','i','v','a','t','e','.',
/* 0x0d288 = "No PCI Bus is available to register the device with." */
    '\xe6','P','C','I',' ','B','u','s',' ','\x0b','a','v','a','i','l','a','b','l','e',' ','\x0a','\xe9','\x02','\xa3','w','i','t','h','.',
/* 0x0d2a5 = "VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x1d','R','E','G','I','O','N','S','_','\xfe',
/* 0x0d2c2 = "Restart the current instruction." */
    'R','e','s','t','a','r','t',' ','\x02','c','u','r','r','e','n','t',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0d2df = "VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','F','I','N','A','L','_','\x16',
/* 0x0d2fc = "Certificate serial number length is out of bounds." */
    '\xba','s','e','r','i','a','l',' ','\xf9','l','e','n','g','t','h',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d319 = "Go back into wait for SIPI mode." */
    'G','o',' ','b','a','c','k',' ','i','n','t','o',' ','w','a','i','t',' ','\x10','S','I','P','I',' ','m','o','d','e','.',
/* 0x0d336 = "VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','D','O','U','B','L','E',
/* 0x0d353 = "Syntax error - the specified function is not a function." */
    '\xf7','\x09','-',' ','\x02','\x18','f','u','n','c','t','i','o','n',' ','\x0b','\x08','a',' ','f','u','n','c','t','i','o','n','.',
/* 0x0d36f = "The DTB being parsed has an invalid header magic." */
    '\x03','D','T','B',' ','b','e','i','n','g',' ','p','a','r','s','e','d',' ','\x7b','\x87','\x8f','\xb3','m','a','g','i','c','.',
/* 0x0d38b = "VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG" */
    '\x01','T','M','_','G','I','P','_','U','P','D','A','T','E','_','I','N','T','E','R','V','A','L','_','\x1c','B','I','G',
/* 0x0d3a7 = "VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED" */
    '\x01','\x22','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','E','X','P','E','C','T','E','D',
/* 0x0d3c3 = "The critical section being deleted was not found." */
    '\x03','c','r','i','t','i','c','a','l',' ','\xda','b','e','i','n','g',' ','d','e','l','e','t','e','d',' ','\x11','\x08','\x88',
/* 0x0d3df = "Unable to establish trusted of VM process (0)." */
    '\xde','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcc',' ','\x92','(','0',')','.',
/* 0x0d3fb = "Attempt to pause a paused TSC." */
    'A','t','t','e','m','p','t',' ','\x0a','p','a','u','s','e',' ','a',' ','p','a','u','s','e','d',' ','T','S','C','.',
/* 0x0d417 = "Final OpenSSL PKIX signing failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','s','i','g','n','i','n','g',' ','\x7d',
/* 0x0d433 = "Device i/o: General failure." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e','.',
/* 0x0d44f = "Unexpected guest mapping conflict detected." */
    '\x94','\xbb','m','a','p','p','i','n','g',' ','c','o','n','f','l','i','c','t',' ','d','e','t','e','c','t','e','d','.',
/* 0x0d46b = "Syntax error - incorrect argument type." */
    '\xf7','\x09','-',' ','i','n','c','o','r','r','e','c','t',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','.',
/* 0x0d487 = "No validation entry in the boot catalog." */
    '\xe6','v','a','l','i','d','a','t','i','o','n',' ','\xc8','\x0f','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x0d4a3 = "The service was disabled on the host." */
    '\x03','s','e','r','v','i','c','e',' ','\x11','d','i','s','a','b','l','e','d',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x0d4bf = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY" */
    '\x01','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','B','U','S','Y',
/* 0x0d4db = "Recompiler: Variable management internal processing error #12." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','1','2','.',
/* 0x0d4f7 = "A digest type used in the manifest file isn\'t supported." */
    'A',' ','\xd6','\xf1','u','s','e','d',' ','\x0f','\x02','m','a','n','i','f','e','s','t',' ','\x1f','i','s','n','\'','t',' ','\xa4',
/* 0x0d513 = "Guest mappings are disabled." */
    'G','u','e','s','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','d','i','s','a','b','l','e','d','.',
/* 0x0d52f = "VINF_IOMMU_ADDR_TRANSLATION_DISABLED" */
    '\x0e','\xfc','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','D','I','S','A','B','L','E','D',
/* 0x0d54b = "Unable to establish trusted of VM process (5)." */
    '\xde','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcc',' ','\x92','(','5',')','.',
/* 0x0d567 = "The ELF loader encountered an unterminated string table." */
    '\x03','E','L','F',' ','\xd8','\xae','\x87','u','n','t','e','r','m','i','n','a','t','e','d',' ','\xf0','t','a','b','l','e','.',
/* 0x0d583 = "VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE" */
    '\x01','J','S','O','N','_','\x05','U','T','F','1','6','_','E','S','C','A','P','E','_','S','E','Q','U','E','N','C','E',
/* 0x0d59f = "The fatal variant of VINF_EM_NO_MEMORY." */
    '\x03','f','a','t','a','l',' ','v','a','r','i','a','n','t',' ','\x15','\x0e','E','M','_','\x60','M','E','M','O','R','Y','.',
/* 0x0d5bb = "The saved state file magic was not recognized." */
    '\x03','s','a','v','e','d',' ','\xcd','\x1f','m','a','g','i','c',' ','\x11','\x08','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0d5d7 = "Unable to establish trusted of VM process (2)." */
    '\xde','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcc',' ','\x92','(','2',')','.',
/* 0x0d5f3 = "VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x16',
/* 0x0d60f = "A driver encountered an unknown configuration value." */
    'A',' ','\xc5','\xae','\x87','u','n','k','n','o','w','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf3',
/* 0x0d62b = "Image Verification Failure: Error allocating memory for state data." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','\x85','\x10','\xcd','d','a','t','a','.',
/* 0x0d647 = "The shared module is already registered." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x0b','\x7f','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0d663 = "The guest LDT selector is out of bounds." */
    '\x03','\xbb','L','D','T',' ','s','e','l','e','c','t','o','r',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x0d67f = "A required header parmaeter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','\xb3','p','a','r','m','a','e','t','e','r',' ','\x11','\x08','s','e','t','.',
/* 0x0d69b = "VINF_PATM_PENDING_IRQ_AFTER_IRET" */
    '\x0e','P','A','T','M','_','P','E','N','D','I','N','G','_','I','R','Q','_','A','F','T','E','R','_','I','R','E','T',
/* 0x0d6b7 = "The semaphore has been opened too many times." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x7b','\xca','o','p','e','n','e','d',' ','\xa0','\xb4','t','i','m','e','s','.',
/* 0x0d6d3 = "VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA" */
    '\x01','\x22','S','P','C','_','E','X','P','E','C','T','E','D','_','P','E','_','I','M','A','G','E','_','D','A','T','A',
/* 0x0d6ef = "The specified disk or diskette cannot be accessed." */
    '\x03','\x18','d','i','s','k',' ','\xa9','d','i','s','k','e','t','t','e',' ','\xe0','\xa8','a','c','c','e','s','s','e','d','.',
/* 0x0d70b = "Invalid unit magic (internal data tag)." */
    '\x0c','u','n','i','t',' ','m','a','g','i','c',' ','(','i','n','t','e','r','n','a','l',' ','\x9c','t','a','g',')','.',
/* 0x0d727 = "Encountered an unexpected attribute form." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x0d743 = "Import ISO contains a directory with a bad record length." */
    '\xc3','\xc1',' ','\x8a','a',' ','\x26','\x80','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0d75f = "Encountered a section type that\'s not known to the loader." */
    '\xa5','a',' ','\xda','\xf1','t','h','a','t','\'','s',' ','\x08','k','n','o','w','n',' ','\x0a','\x02','l','o','a','d','e','r','.',
/* 0x0d77b = "The filename or extension is too long." */
    '\x03','f','i','l','e','n','a','m','e',' ','\xa9','e','x','t','e','n','s','i','o','n',' ','\x0b','\xa0','l','o','n','g','.',
/* 0x0d797 = "Not in the correct state for the attempted operation." */
    'N','o','t',' ','\x0f','\x02','c','o','r','r','e','c','t',' ','\xcd','\x10','\x02','a','t','t','e','m','p','t','e','d',' ','\xe8',
/* 0x0d7b3 = "Generic failure during disassembly." */
    '\xa6','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','d','i','s','a','s','s','e','m','b','l','y','.',
/* 0x0d7cf = "Recompiler: No temporary host register available." */
    '\x13','\xe6','t','e','m','p','o','r','a','r','y',' ','h','o','s','t',' ','\xe9','a','v','a','i','l','a','b','l','e','.',
/* 0x0d7eb = "Unexpected NULL pointer to left subtree." */
    '\x94','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x0a','l','e','f','t',' ','s','u','b','t','r','e','e','.',
/* 0x0d807 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','O','F','F','_','B','A','D',
/* 0x0d823 = "VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE" */
    '\x01','V','G','A','_','\x86','P','C','I','_','R','E','G','I','O','N','_','L','O','A','D','_','C','H','A','N','G','E',
/* 0x0d83f = "Unable to establish trusted of VM process (3)." */
    '\xde','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcc',' ','\x92','(','3',')','.',
/* 0x0d85b = "VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS" */
    '\x01','\x24','\x89','M','U','L','T','I','P','L','E','_','J','O','L','I','E','T','_','V','O','L','_','D','E','S','C','S',
/* 0x0d877 = "VERR_TAR_NON_DIR_ENDS_WITH_SLASH" */
    '\x01','T','A','R','_','N','O','N','_','D','I','R','_','E','N','D','S','_','W','I','T','H','_','S','L','A','S','H',
/* 0x0d893 = "VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','I','N','I','T','_','\x16',
/* 0x0d8af = "VERR_MAIN_CONFIG_CONSTRUCTOR_IPE" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','I','P','E',
/* 0x0d8cb = "Invalid entry in the device registration structure." */
    '\x0c','\xc8','\x0f','\x02','\xa3','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d8e7 = "VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2" */
    '\x01','\x22','\xb7','T','B','S','C','E','R','T','_','U','N','I','Q','U','E','_','I','D','S','_','R','E','Q','_','V','2',
/* 0x0d903 = "Specified access handler was not found." */
    'S','p','e','c','i','f','i','e','d',' ','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x11','\x08','\x88',
/* 0x0d91f = "VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\x89','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x0d93b = "AMD-V bit not set in K6_EFER MSR." */
    'A','M','D','-','V',' ','b','i','t',' ','\x08','s','e','t',' ','\x0f','K','6','_','E','F','E','R',' ','M','S','R','.',
/* 0x0d957 = "VERR_FTP_DATA_CONN_LIMIT_REACHED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x0d973 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x05','F','L','A','G','S',
/* 0x0d98f = "The ELF loader encountered an invalid symbol name offset." */
    '\x03','E','L','F',' ','\xd8','\xae','\x87','\x8f','s','y','m','b','o','l',' ','n','a','m','e',' ','o','f','f','s','e','t','.',
/* 0x0d9ab = "Image Verification Failure: Internal error in signature parser." */
    'I','m','a','g','e',' ','\x0d','\x12','\x07','\x09','\x0f','s','i','g','n','a','t','u','r','e',' ','p','a','r','s','e','r','.',
/* 0x0d9c7 = "Unable to establish trusted of VM process (1)." */
    '\xde','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcc',' ','\x92','(','1',')','.',
/* 0x0d9e3 = "Failed to allocate temporary memory." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','t','e','m','p','o','r','a','r','y',' ','m','e','m','o','r','y','.',
/* 0x0d9ff = "Shared Clipboard event ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','I','D',' ','\x08','\x88',
/* 0x0da1b = "VERR_IPC_RECEIVE_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x0da37 = "The MMIO range specified for removal was invalid." */
    '\x03','\xd2',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0da53 = "Too many I/O port registrations." */
    'T','o','o',' ','\xb4','I','/','O',' ','p','o','r','t',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x0da6f = "Reason for leaving RZ: Illegal call to ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','I','l','l','e','g','a','l',' ','c','a','l','l',' ','\x0a','r','i','n','g','-','3','.',
/* 0x0da8b = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\x1d','V','A','L','I','D','A','T','I','O','N','_','K','E','Y','S',
/* 0x0daa7 = "VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','U','B','L','I','C','_','K','E','Y','_','\x16',
/* 0x0dac3 = "VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','D','_','\x06','\x2a',
/* 0x0dadf = "The specified shared page was not actually shared." */
    '\x03','\x18','s','h','a','r','e','d',' ','\xcb','\x11','\x08','a','c','t','u','a','l','l','y',' ','s','h','a','r','e','d','.',
/* 0x0dafb = "Invalid (malformed) file/path name." */
    '\x0c','(','m','a','l','f','o','r','m','e','d',')',' ','f','i','l','e','/','p','a','t','h',' ','n','a','m','e','.',
/* 0x0db17 = "Incorrect version numbers in the header." */
    'I','n','c','o','r','r','e','c','t',' ','\xcf','n','u','m','b','e','r','s',' ','\x0f','\x02','h','e','a','d','e','r','.',
/* 0x0db33 = "VERR_DBGF_BP_INT3_ADD_TRIES_REACHED" */
    '\x01','\xb9','_','B','P','_','I','N','T','3','_','A','D','D','_','T','R','I','E','S','_','R','E','A','C','H','E','D',
/* 0x0db4f = "VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG" */
    '\x01','\x24','\x89','R','O','O','T','_','D','I','R','_','W','I','T','H','O','U','T','_','D','I','R','_','F','L','A','G',
/* 0x0db6b = "VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED" */
    '\x01','\x22','S','P','C','_','P','E','I','M','A','G','E','_','U','R','L','_','U','N','E','X','P','E','C','T','E','D',
/* 0x0db87 = "VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED" */
    '\x01','\xf2','\xdb','H','A','S','H','_','T','A','B','_','\x06','S','T','R','I','C','T','L','Y','_','S','O','R','T','E','D',
/* 0x0dba3 = "VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','D','2','I','_','K','E','Y','_','P','A','R','A','M','S','_','\x16',
/* 0x0dbbf = "Too deep walk during lookup." */
    'T','o','o',' ','d','e','e','p',' ','w','a','l','k',' ','d','u','r','i','n','g',' ','l','o','o','k','u','p','.',
/* 0x0dbdb = "The length of the file name is out of range." */
    '\x03','l','e','n','g','t','h',' ','\x15','\x02','\x1f','n','a','m','e',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x0dbf7 = "Bad symbol table size in Mach-O image." */
    '\x9d','s','y','m','b','o','l',' ','\xb1','s','i','z','e',' ','\x0f','M','a','c','h','-','O',' ','i','m','a','g','e','.',
/* 0x0dc13 = "VERR_HARDAVL_INDEX_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','I','N','D','E','X','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0dc2f = "An operation caused a nested-guest VM-exit." */
    'A','n',' ','\x96','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xbb','\xcc','-','e','x','i','t','.',
/* 0x0dc4b = "VINF_EM_RAW_EXCEPTION_PRIVILEGED" */
    '\x0e','E','M','_','R','A','W','_','E','X','C','E','P','T','I','O','N','_','P','R','I','V','I','L','E','G','E','D',
/* 0x0dc67 = "Bogus reference to freed node." */
    'B','o','g','u','s',' ','r','e','f','e','r','e','n','c','e',' ','\x0a','f','r','e','e','d',' ','n','o','d','e','.',
/* 0x0dc83 = "Current session state prohibits operation." */
    'C','u','r','r','e','n','t',' ','s','e','s','s','i','o','n',' ','\xcd','p','r','o','h','i','b','i','t','s',' ','\xe8',
/* 0x0dc9f = "VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED" */
    '\x01','G','V','M','M','_','\x06','A','L','L','_','E','M','T','S','_','D','E','R','E','G','I','S','T','E','R','E','D',
/* 0x0dcbb = "Recompiler: Variable management internal processing error #13." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','1','3','.',
/* 0x0dcd7 = "VERR_CODE_POINT_ENDIAN_INDICATOR" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','E','N','D','I','A','N','_','I','N','D','I','C','A','T','O','R',
/* 0x0dcf3 = "Unable to establish trusted of VM process (4)." */
    '\xde','\x0a','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x15','\xcc',' ','\x92','(','4',')','.',
/* 0x0dd0f = "Invalid entry in the driver registration structure." */
    '\x0c','\xc8','\x0f','\x02','\xc5','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0dd2b = "The specified field is outside the structure." */
    '\x03','\x18','f','i','e','l','d',' ','\x0b','o','u','t','s','i','d','e',' ','\x02','s','t','r','u','c','t','u','r','e','.',
/* 0x0dd47 = "Severely compromised digest." */
    'S','e','v','e','r','e','l','y',' ','c','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x0dd63 = "Process Verification Failure: Bad new-header offset in the MZ header." */
    '\x1e','\x0d','\x12','\x9d','n','e','w','-','\xb3','o','f','f','s','e','t',' ','\x0f','\x02','M','Z',' ','h','e','a','d','e','r','.',
/* 0x0dd7f = "Unexpected MSR in the auto-load/store area." */
    '\x94','M','S','R',' ','\x0f','\x02','a','u','t','o','-','l','o','a','d','/','s','t','o','r','e',' ','a','r','e','a','.',
/* 0x0dd9b = "APIC did not accept the interrupt." */
    'A','P','I','C',' ','d','i','d',' ','\x08','a','c','c','e','p','t',' ','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x0ddb7 = "VERR_GIM_HYPERCALL_ACCESS_DENIED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x0ddd3 = "Already aliased to the same page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x0a','\x02','s','a','m','e',' ','p','a','g','e','.',
/* 0x0ddef = "VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','D','_','U','T','F','8','_','L','E','A','D','_','B','Y','T','E',
/* 0x0de0b = "Recompiler: Variable management internal processing error #10." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','1','0','.',
/* 0x0de27 = "Get register caller must flush the TLB." */
    'G','e','t',' ','\xe9','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B','.',
/* 0x0de43 = "Error getting a data from the extension." */
    '\xc0','g','e','t','t','i','n','g',' ','a',' ','\x9c','f','r','o','m',' ','\x02','e','x','t','e','n','s','i','o','n','.',
/* 0x0de5f = "Invalid format of managed object reference." */
    '\x0c','f','o','r','m','a','t',' ','\x15','m','a','n','a','g','e','d',' ','\xa7','r','e','f','e','r','e','n','c','e','.',
/* 0x0de7b = "A device encountered an unknown configuration value." */
    'A',' ','\xa3','\xae','\x87','u','n','k','n','o','w','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xf3',
/* 0x0de97 = "VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY" */
    '\x01','\x24','B','O','O','T','_','C','A','T','_','\x60','V','A','L','I','D','A','T','I','O','N','_','E','N','T','R','Y',
/* 0x0deb3 = "Recompiler: Variable management internal processing error #11." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','1','1','.',
/* 0x0decf = "The media is locked and cannot be unmounted." */
    '\x03','m','e','d','i','a',' ','\x0b','l','o','c','k','e','d',' ','\x99','\xe0','\xa8','u','n','m','o','u','n','t','e','d','.',
/* 0x0deeb = "VFS chain element expected at least one argument." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0df06 = "VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO" */
    '\x01','\x22','\xe3','E','X','P','E','C','T','E','D','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O',
/* 0x0df21 = "Internal ISO maker error: Read file data probem #1." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','R','e','a','d',' ','\x1f','\x9c','p','r','o','b','e','m',' ','#','1','.',
/* 0x0df3c = "VERR_AUDIO_STREAM_COULD_NOT_CREATE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','C','O','U','L','D','_','\x06','C','R','E','A','T','E',
/* 0x0df57 = "VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION" */
    '\x01','\x90','V','T','G','_','O','N','L','Y','_','O','N','C','E','_','P','E','R','_','S','E','S','S','I','O','N',
/* 0x0df72 = "Trying to free a page with an invalid Page ID." */
    'T','r','y','i','n','g',' ','\x0a','f','r','e','e',' ','a',' ','\xcb','\x80','\x87','\x8f','P','a','g','e',' ','I','D','.',
/* 0x0df8d = "No memory available for page table or page directory." */
    '\xe6','\x85','a','v','a','i','l','a','b','l','e',' ','\x10','\xcb','\xb1','\xa9','\xcb','d','i','r','e','c','t','o','r','y','.',
/* 0x0dfa8 = "The requested feature is not supported by NEM." */
    '\x03','\xdd','f','e','a','t','u','r','e',' ','\x0b','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','N','E','M','.',
/* 0x0dfc3 = "Failed to get the delta-adjusted TSC value." */
    '\x8b','\x0a','g','e','t',' ','\x02','d','e','l','t','a','-','a','d','j','u','s','t','e','d',' ','T','S','C',' ','\xf3',
/* 0x0dfde = "VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS" */
    '\x01','\xe7','M','I','X','E','D','_','D','E','B','U','G','_','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x0dff9 = "VWRN_GSTCTL_OBJECTSTATE_CHANGED" */
    '\xe4','G','S','T','C','T','L','_','O','B','J','E','C','T','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x0e014 = "Error while parsing UUID string." */
    '\xc0','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','U','U','I','D',' ','s','t','r','i','n','g','.',
/* 0x0e02f = "The provider cannot be the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\xe0','\xa8','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x0e04a = "Asynchronous I/O request finished." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\xaa','f','i','n','i','s','h','e','d','.',
/* 0x0e065 = "VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS" */
    '\x0e','\x5e','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0e080 = "VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT" */
    '\x01','\x8d','_','\x8e','C','A','N','N','O','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x0e09b = "Recompiler: Variable management internal processing error #7." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','7','.',
/* 0x0e0b6 = "VERR_GMM_MEMORY_RESERVATION_DECLINED" */
    '\x01','G','M','M','_','\xb6','_','R','E','S','E','R','V','A','T','I','O','N','_','D','E','C','L','I','N','E','D',
/* 0x0e0d1 = "OpenSSL failed to clone the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x98','\x0a','c','l','o','n','e',' ','\x02','\xd6','\xd3','c','o','n','t','e','x','t','.',
/* 0x0e0ec = "Process Verification Failure: There are too many DLLs loaded." */
    '\x1e','\x0d','\x12','T','h','e','r','e',' ','a','r','e',' ','\xa0','\xb4','D','L','L','s',' ','l','o','a','d','e','d','.',
/* 0x0e107 = "Too many partition descriptors." */
    'T','o','o',' ','\xb4','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0e122 = "Could not recognize the key type." */
    'C','o','u','l','d',' ','\x08','r','e','c','o','g','n','i','z','e',' ','\x02','k','e','y',' ','t','y','p','e','.',
/* 0x0e13d = "The guest has not setup use of the hypercalls." */
    '\x03','\xbb','\x7b','\x08','s','e','t','u','p',' ','u','s','e',' ','\x15','\x02','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0e158 = "Reason for leaving RC: Unhandled LDT write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','L','D','T',' ','w','r','i','t','e','.',
/* 0x0e173 = "Internal processing error in the PGM physical handler code." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\x83',
/* 0x0e18e = "VERR_REST_WRONG_JSON_TYPE_FOR_DATE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','D','A','T','E',
/* 0x0e1a9 = "VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x0e1c4 = "Syntax error - unbalanced parenthesis." */
    '\xf7','\x09','-',' ','u','n','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s','.',
/* 0x0e1df = "Recompiler: Variable management internal processing error #3." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','3','.',
/* 0x0e1fa = "Buffer too small to save result." */
    'B','u','f','f','e','r',' ','\xa0','s','m','a','l','l',' ','\x0a','s','a','v','e',' ','r','e','s','u','l','t','.',
/* 0x0e215 = "Image Verification Failure: Error reading file for hashing." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x1f','\x10','h','a','s','h','i','n','g','.',
/* 0x0e230 = "Recompiler: Register allocator internal processing error #13." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','1','3','.',
/* 0x0e24b = "VERR_LDR_DUPLICATE_SEGMENT_NAME" */
    '\x01','L','D','R','_','D','U','P','L','I','C','A','T','E','_','S','E','G','M','E','N','T','_','N','A','M','E',
/* 0x0e266 = "Unresolved (unknown) device i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\xa3','i','/','o',' ','\x84',
/* 0x0e281 = "VERR_PGM_HANDLER_PHYSICAL_CONFLICT" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','C','O','N','F','L','I','C','T',
/* 0x0e29c = "VERR_IOQUEUE_HANDLE_NOT_REGISTERED" */
    '\x01','I','O','Q','U','E','U','E','_','H','A','N','D','L','E','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x0e2b7 = "VINF_EM_PENDING_R3_IOPORT_WRITE" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x0e2d2 = "VINF_IOM_R3_IOPORT_COMMIT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x0e2ed = "Hit a todo in the mach-o loader." */
    'H','i','t',' ','a',' ','t','o','d','o',' ','\x0f','\x02','m','a','c','h','-','o',' ','l','o','a','d','e','r','.',
/* 0x0e308 = "Expected URI using the \'file:\' scheme." */
    '\xb8','U','R','I',' ','u','s','i','n','g',' ','\x02','\'','f','i','l','e',':','\'',' ','s','c','h','e','m','e','.',
/* 0x0e323 = "VERR_PATH_DOES_NOT_START_WITH_ROOT" */
    '\x01','P','A','T','H','_','D','O','E','S','_','\x06','S','T','A','R','T','_','W','I','T','H','_','R','O','O','T',
/* 0x0e33e = "Bad VTG probe location record." */
    '\x9d','V','T','G',' ','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','r','e','c','o','r','d','.',
/* 0x0e359 = "Recompiler: Variable management internal processing error #6." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','6','.',
/* 0x0e374 = "VERR_REST_UNABLE_TO_DECODE_DATE" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e38f = "VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS" */
    '\x01','\x24','\x89','M','U','L','T','I','P','L','E','_','E','L','_','T','O','R','I','T','O','_','D','E','S','C','S',
/* 0x0e3aa = "More unconsumed data available." */
    'M','o','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','\x9c','a','v','a','i','l','a','b','l','e','.',
/* 0x0e3c5 = "Floating pointer underflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x0e3e0 = "VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH" */
    '\x01','\x24','\x89','D','O','T','_','D','I','R','_','R','E','C','_','\x1d','N','A','M','E','_','L','E','N','G','T','H',
/* 0x0e3fb = "Internal ISO maker error: Read file data probem #2." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','R','e','a','d',' ','\x1f','\x9c','p','r','o','b','e','m',' ','#','2','.',
/* 0x0e416 = "The event semaphore has already been posted." */
    '\x03','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x7b','\x7f','\xca','p','o','s','t','e','d','.',
/* 0x0e431 = "Unable to use the range for a large page." */
    '\xde','\x0a','u','s','e',' ','\x02','r','a','n','g','e',' ','\x10','a',' ','l','a','r','g','e',' ','p','a','g','e','.',
/* 0x0e44c = "VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','\xd4','_','\x06','T','E','R','M','I','N','A','T','E','D',
/* 0x0e467 = "Failed to calculate the TSC frequency." */
    '\x8b','\x0a','c','a','l','c','u','l','a','t','e',' ','\x02','T','S','C',' ','f','r','e','q','u','e','n','c','y','.',
/* 0x0e482 = "VERR_TAR_MALFORMED_GNU_LONGXXXX" */
    '\x01','T','A','R','_','M','A','L','F','O','R','M','E','D','_','G','N','U','_','L','O','N','G','X','X','X','X',
/* 0x0e49d = "Recompiler: Variable management internal processing error #1." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','1','.',
/* 0x0e4b8 = "VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','L','I','N','K','_','I','D','_','\x06','\x2a',
/* 0x0e4d3 = "VERR_REST_WRONG_JSON_TYPE_FOR_BOOL" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','B','O','O','L',
/* 0x0e4ee = "VERR_AUDIO_NO_FREE_OUTPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\x60','F','R','E','E','_','O','U','T','P','U','T','_','S','T','R','E','A','M','S',
/* 0x0e509 = "Reason for leaving RZ: Emulate instruction." */
    '\x93','\x10','\x81','R','Z',':',' ','E','m','u','l','a','t','e',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0e524 = "VERR_SHCLPB_MAX_OBJECTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0e53f = "VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH" */
    '\x01','\xa1','C','U','R','S','O','R','_','\x1d','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0e55a = "Recompiler: Register allocator internal processing error #10." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','1','0','.',
/* 0x0e575 = "Recompiler: Variable management internal processing error #5." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','5','.',
/* 0x0e590 = "VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE" */
    '\x01','\xa2','I','N','C','O','M','P','L','E','T','E','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x0e5ab = "Invalid environment variable name." */
    '\x0c','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','a','m','e','.',
/* 0x0e5c6 = "Invalid image relative virtual address." */
    '\x0c','\x25','r','e','l','a','t','i','v','e',' ','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x0e5e1 = "Generic object was destroyed by the call status." */
    '\xa6','\xa7','\x11','d','e','s','t','r','o','y','e','d',' ','\xdf','\x02','c','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x0e5fc = "VERR_TM_TIMER_QUEUE_CANNOT_GROW" */
    '\x01','T','M','_','T','I','M','E','R','_','Q','U','E','U','E','_','C','A','N','N','O','T','_','G','R','O','W',
/* 0x0e617 = "VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\xc4','_','F','I','N','A','L','_','O','R','_','\x1c','B','I','G',
/* 0x0e632 = "VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS" */
    '\x01','I','O','M','_','\x1c','\xaf','I','O','P','O','R','T','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x0e64d = "Malformed or invalid file set descriptor location." */
    'M','a','l','f','o','r','m','e','d',' ','\xa9','\x8f','\x1f','s','e','t',' ','\xee','l','o','c','a','t','i','o','n','.',
/* 0x0e668 = "Reason for leaving RC: Inject a TRPM event." */
    '\x93','\x10','\x81','R','C',':',' ','I','n','j','e','c','t',' ','a',' ','T','R','P','M',' ','e','v','e','n','t','.',
/* 0x0e683 = "Too long name or link string." */
    'T','o','o',' ','l','o','n','g',' ','n','a','m','e',' ','\xa9','l','i','n','k',' ','s','t','r','i','n','g','.',
/* 0x0e69e = "VERR_DBG_SEGMENT_INDEX_CONFLICT" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','I','N','D','E','X','_','C','O','N','F','L','I','C','T',
/* 0x0e6b9 = "Unhandled #DB in hypervisor code." */
    'U','n','h','a','n','d','l','e','d',' ','#','D','B',' ','\x0f','h','y','p','e','r','v','i','s','o','r',' ','\x83',
/* 0x0e6d4 = "Recompiler: Register allocator internal processing error #12." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','1','2','.',
/* 0x0e6ef = "Process Verification Failure: The process has more than one thread." */
    '\x1e','\x0d','\x12','\x03','\x92','\x7b','m','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','t','h','r','e','a','d','.',
/* 0x0e70a = "NEM failed to unmap page(s) into the VM." */
    '\xec',' ','\x98','\x0a','u','n','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x0e725 = "General saved state file integrity error." */
    'G','e','n','e','r','a','l',' ','s','a','v','e','d',' ','\xcd','\x1f','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x0e740 = "Reason for leaving RC: Unhandled TSS write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','T','S','S',' ','w','r','i','t','e','.',
/* 0x0e75b = "Recompiler: Variable management internal processing error #2." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','2','.',
/* 0x0e776 = "VERR_GETOPT_REQUIRED_ARGUMENT_MISSING" */
    '\x01','G','E','T','O','P','T','_','R','E','Q','U','I','R','E','D','_','A','R','G','U','M','E','N','T','_','\xc4',
/* 0x0e791 = "VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','D','B','G','_','P','O','R','T','_','\x1a',
/* 0x0e7ac = "Maximum number of mappings reached." */
    'M','a','x','i','m','u','m',' ','\xf9','\x15','m','a','p','p','i','n','g','s',' ','r','e','a','c','h','e','d','.',
/* 0x0e7c7 = "VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x05','S','Y','M','B','O','L','_','N','A','M','E','_','O','F','F','S','E','T',
/* 0x0e7e2 = "VERR_VUSB_USB_DEVICE_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','_','D','E','V','I','C','E','_','P','E','R','M','I','S','S','I','O','N',
/* 0x0e7fd = "VWRN_REST_UNABLE_TO_DECODE_DATE" */
    '\xe4','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0e818 = "The ELF loader encountered an invalid relocation offset." */
    '\x03','E','L','F',' ','\xd8','\xae','\x87','\x8f','r','e','l','o','c','a','t','i','o','n',' ','o','f','f','s','e','t','.',
/* 0x0e833 = "Dataspace manager server not found." */
    'D','a','t','a','s','p','a','c','e',' ','m','a','n','a','g','e','r',' ','s','e','r','v','e','r',' ','\x08','\x88',
/* 0x0e84e = "Recompiler: Variable management internal processing error #9." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','9','.',
/* 0x0e869 = "The specified at reset handler wasn\'t found." */
    '\x03','\x18','a','t',' ','r','e','s','e','t',' ','h','a','n','d','l','e','r',' ','w','a','s','n','\'','t',' ','\x88',
/* 0x0e884 = "Invalid CPUMCPU offset in MSR range." */
    '\x0c','C','P','U','M','C','P','U',' ','o','f','f','s','e','t',' ','\x0f','M','S','R',' ','r','a','n','g','e','.',
/* 0x0e89f = "HGCM could not perform requested operation because of an internal error." */
    'H','G','C','M',' ','c','o','u','l','d',' ','\x08','p','e','r','f','o','r','m',' ','\xdd','\x96','\x40','\x15','\x87','\x17','\x84',
/* 0x0e8ba = "VERR_HARDAVL_MISALIGNED_POINTER" */
    '\x01','H','A','R','D','A','V','L','_','M','I','S','A','L','I','G','N','E','D','_','P','O','I','N','T','E','R',
/* 0x0e8d5 = "VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT" */
    '\x01','\x24','\x89','R','O','O','T','_','D','I','R','_','I','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0e8f0 = "VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN" */
    '\x0e','\xb0','V','O','T','E','_','D','O','N','E','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x0e90b = "Internal ISO maker error: Read file data probem #3." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','R','e','a','d',' ','\x1f','\x9c','p','r','o','b','e','m',' ','#','3','.',
/* 0x0e926 = "Unresolved (unknown) file i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x1f','i','/','o',' ','\x84',
/* 0x0e941 = "Invalid UTF-8 encoding in the response." */
    '\x0c','U','T','F','-','8',' ','e','n','c','o','d','i','n','g',' ','\x0f','\x02','r','e','s','p','o','n','s','e','.',
/* 0x0e95c = "VDI: Invalid image file header: invalid signature." */
    'V','D','I',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r',':',' ','\x8f','s','i','g','n','a','t','u','r','e','.',
/* 0x0e977 = "The dotted-string representation of an ASN." */
    '\x03','d','o','t','t','e','d','-','\xf0','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','\x15','\x87','\xf4',
/* 0x0e992 = "VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','I','M','G','_','I','N','F','O','_','\x1a',
/* 0x0e9ad = "VERR_SEM_LV_WRONG_RELEASE_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','R','E','L','E','A','S','E','_','O','R','D','E','R',
/* 0x0e9c8 = "Expression stack underflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x0e9e3 = "AMD-V CPU extension in-use." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','i','n','-','u','s','e','.',
/* 0x0e9fe = "VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED" */
    '\x01','\x22','\xe3','S','I','G','N','A','T','U','R','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','\x16',
/* 0x0ea19 = "VERR_SHCLPB_LIST_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','L','I','S','T','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x0ea34 = "Trying to free a page that isn\'t RAM." */
    'T','r','y','i','n','g',' ','\x0a','f','r','e','e',' ','a',' ','\xcb','\xac','i','s','n','\'','t',' ','R','A','M','.',
/* 0x0ea4f = "Failed to open semaphore by name - not found." */
    '\x8b','\x0a','o','p','e','n',' ','s','e','m','a','p','h','o','r','e',' ','\xdf','n','a','m','e',' ','-',' ','\x08','\x88',
/* 0x0ea6a = "Recompiler: Variable management internal processing error #4." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','4','.',
/* 0x0ea85 = "VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT" */
    '\x01','\x22','S','P','C','_','P','E','I','M','A','G','E','_','D','A','T','A','_','\x06','P','R','E','S','E','N','T',
/* 0x0eaa0 = "Recompiler: Variable management internal processing error #8." */
    '\x13','V','a','r','i','a','b','l','e',' ','m','a','n','a','g','e','m','e','n','t',' ','\x17','\x04','\x09','#','8','.',
/* 0x0eabb = "VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','C','O','N','T','E','N','T','_','\xb5','_','\x06','\x82',
/* 0x0ead6 = "Recompiler: Register allocator internal processing error #11." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','1','1','.',
/* 0x0eaf1 = "The shared module name is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','n','a','m','e',' ','\x0b','\xa0','l','o','n','g','.',
/* 0x0eb0c = "Constructed string type not implemented." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xf0','\xf1','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0eb27 = "VRPD receives a packet that is not supported." */
    'V','R','P','D',' ','r','e','c','e','i','v','e','s',' ','a',' ','p','a','c','k','e','t',' ','\xac','\x0b','\x08','\xa4',
/* 0x0eb42 = "The URI is too short to be a valid URI." */
    '\x03','U','R','I',' ','\x0b','\xa0','s','h','o','r','t',' ','\x0a','\xa8','a',' ','v','a','l','i','d',' ','U','R','I','.',
/* 0x0eb5d = "Internal error obtaining the GVMM instance." */
    '\x07','\x09','o','b','t','a','i','n','i','n','g',' ','\x02','G','V','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x0eb78 = "Reason for leaving RC: Unhandled IDT write." */
    '\x93','\x10','\x81','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','I','D','T',' ','w','r','i','t','e','.',
/* 0x0eb93 = "Bad iterdata2 (EXEPACK2) data." */
    '\x9d','i','t','e','r','d','a','t','a','2',' ','(','E','X','E','P','A','C','K','2',')',' ','d','a','t','a','.',
/* 0x0ebae = "Internal ISO maker error: Unexpected empty component." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','\x94','e','m','p','t','y',' ','c','o','m','p','o','n','e','n','t','.',
/* 0x0ebc9 = "VERR_X509_EXTRACT_PUBKEY_FROM_CERT" */
    '\x01','\xb7','E','X','T','R','A','C','T','_','P','U','B','K','E','Y','_','F','R','O','M','_','C','E','R','T',
/* 0x0ebe3 = "VERR_PGM_HANDLER_VIRTUAL_CONFLICT" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','V','I','R','T','U','A','L','_','C','O','N','F','L','I','C','T',
/* 0x0ebfd = "Expression stack overflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','o','v','e','r','f','l','o','w','.',
/* 0x0ec17 = "Requested service does not exist." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\xb2','\x08','e','x','i','s','t','.',
/* 0x0ec31 = "The specified string / bytes buffer was to small." */
    '\x03','\x18','\xf0','/',' ','b','y','t','e','s',' ','b','u','f','f','e','r',' ','\x11','\x0a','s','m','a','l','l','.',
/* 0x0ec4b = "VERR_GIM_HYPERCALLS_NOT_AVAILABLE" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x0ec65 = "VERR_INTNET_INCOMPATIBLE_FLAGS" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','F','L','A','G','S',
/* 0x0ec7f = "Recompiler: Register allocator internal processing error #2." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','2','.',
/* 0x0ec99 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\x1d','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0ecb3 = "Recompiler: Register allocator internal processing error #6." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','6','.',
/* 0x0eccd = "Format not supported by the codec." */
    'F','o','r','m','a','t',' ','\x08','s','u','p','p','o','r','t','e','d',' ','\xdf','\x02','c','o','d','e','c','.',
/* 0x0ece7 = "Status that causes DBGC to quit." */
    'S','t','a','t','u','s',' ','\xac','c','a','u','s','e','s',' ','D','B','G','C',' ','\x0a','q','u','i','t','.',
/* 0x0ed01 = "VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES" */
    '\x01','H','A','R','D','A','V','L','_','T','R','A','V','E','R','S','E','D','_','\x1c','\xaf','N','O','D','E','S',
/* 0x0ed1b = "The ELF loader encountered a bad symbol index." */
    '\x03','E','L','F',' ','\xd8','\xae','a',' ','b','a','d',' ','s','y','m','b','o','l',' ','i','n','d','e','x','.',
/* 0x0ed35 = "VERR_FDT_DTB_HDR_MAGIC_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','A','G','I','C','_','I','N','V','A','L','I','D',
/* 0x0ed4f = "Can\'t delete bucket with keys." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','b','u','c','k','e','t',' ','\x80','k','e','y','s','.',
/* 0x0ed69 = "VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT" */
    '\x01','\x95','\xbd','\x06','S','I','G','N','E','D','_','W','I','T','H','_','B','U','I','L','D','_','C','E','R','T',
/* 0x0ed83 = "VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT" */
    '\x01','\x24','\x89','M','I','S','A','L','I','G','N','E','D','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0ed9d = "VERR_SERIALPORT_BREAK_DETECTED" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','B','R','E','A','K','_','D','E','T','E','C','T','E','D',
/* 0x0edb7 = "VERR_HARDAVL_INSERT_INVALID_KEY_RANGE" */
    '\x01','H','A','R','D','A','V','L','_','I','N','S','E','R','T','_','\x05','K','E','Y','_','R','A','N','G','E',
/* 0x0edd1 = "Generic debugger command failure." */
    '\xa6','d','e','b','u','g','g','e','r',' ','c','o','m','m','a','n','d',' ','f','a','i','l','u','r','e','.',
/* 0x0edeb = "VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1" */
    '\x01','\x9b','E','M','I','T','_','C','A','S','E','_','\x06','I','M','P','L','E','M','E','N','T','E','D','_','1',
/* 0x0ee05 = "VERR_X509_RSA_VERIFICATION_FUILURE" */
    '\x01','\xb7','R','S','A','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','U','I','L','U','R','E',
/* 0x0ee1f = "VERR_SHCLPB_OBJ_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','O','B','J','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x0ee39 = "VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS" */
    '\x01','L','D','R','E','L','F','_','\x60','S','Y','M','B','O','L','_','O','R','_','\x60','\xd4','_','T','A','B','S',
/* 0x0ee53 = "The format of a data unit has changed." */
    '\x03','f','o','r','m','a','t',' ','\x15','a',' ','\x9c','u','n','i','t',' ','\x7b','c','h','a','n','g','e','d','.',
/* 0x0ee6d = "Malformed forwarder entry." */
    'M','a','l','f','o','r','m','e','d',' ','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x0ee87 = "Unrecoverable error: lock was lost." */
    'U','n','r','e','c','o','v','e','r','a','b','l','e',' ','\xd7','l','o','c','k',' ','\x11','l','o','s','t','.',
/* 0x0eea1 = "Mount failed because a media was already mounted." */
    'M','o','u','n','t',' ','\x98','\x40','a',' ','m','e','d','i','a',' ','\x11','\x7f','m','o','u','n','t','e','d','.',
/* 0x0eebb = "Requested service already exists." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x7f','e','x','i','s','t','s','.',
/* 0x0eed5 = "Insufficient data to check descriptor CRC." */
    'I','n','s','u','f','f','i','c','i','e','n','t',' ','\x9c','\x0a','c','h','e','c','k',' ','\xee','C','R','C','.',
/* 0x0eeef = "VFS chain element expected at most one argument." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','m','o','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0ef09 = "VERR_IOM_IOPORT_RANGE_CONFLICT" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x0ef23 = "Recompiler: Register allocator internal processing error #4." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','4','.',
/* 0x0ef3d = "The returned shadow page is cached." */
    '\x03','r','e','t','u','r','n','e','d',' ','s','h','a','d','o','w',' ','\xcb','\x0b','c','a','c','h','e','d','.',
/* 0x0ef57 = "Recompiler: Totally unexpected memory size." */
    '\x13','T','o','t','a','l','l','y',' ','u','n','e','x','p','e','c','t','e','d',' ','\x85','s','i','z','e','.',
/* 0x0ef71 = "Unable to switch due to invalid host state." */
    '\xde','\x0a','s','w','i','t','c','h',' ','d','u','e',' ','\x0a','\x8f','h','o','s','t',' ','s','t','a','t','e','.',
/* 0x0ef8b = "Multiple PE image page hash tables." */
    'M','u','l','t','i','p','l','e',' ','P','E',' ','\x25','\xcb','h','a','s','h',' ','t','a','b','l','e','s','.',
/* 0x0efa5 = "VERR_ISOMK_SYMLINK_SUPPORT_DISABLED" */
    '\x01','\x24','S','Y','M','L','I','N','K','_','S','U','P','P','O','R','T','_','D','I','S','A','B','L','E','D',
/* 0x0efbf = "VINF_IEM_REEXEC_FINISH_WITH_FLAGS" */
    '\x0e','\x9b','R','E','E','X','E','C','_','F','I','N','I','S','H','_','W','I','T','H','_','F','L','A','G','S',
/* 0x0efd9 = "The shared module has too many regions." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x7b','\xa0','\xb4','r','e','g','i','o','n','s','.',
/* 0x0eff3 = "Recompiler: Register allocator internal processing error #5." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','5','.',
/* 0x0f00d = "The GVM is out of VM handle space." */
    '\x03','G','V','M',' ','\x0b','o','u','t',' ','\x15','\xcc',' ','h','a','n','d','l','e',' ','s','p','a','c','e','.',
/* 0x0f027 = "VERR_AUDIO_NO_FREE_INPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\x60','F','R','E','E','_','I','N','P','U','T','_','S','T','R','E','A','M','S',
/* 0x0f041 = "The event semaphore has already been reset." */
    '\x03','e','v','e','n','t',' ','s','e','m','a','p','h','o','r','e',' ','\x7b','\x7f','\xca','r','e','s','e','t','.',
/* 0x0f05b = "VERR_PDM_MEDIAEX_IOREQID_CONFLICT" */
    '\x01','\x5e','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','C','O','N','F','L','I','C','T',
/* 0x0f075 = "Recompiler: Register allocator internal processing error #9." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','9','.',
/* 0x0f08f = "VERR_SUP_VP_NT_MAPPING_NAME_CHANGED" */
    '\x01','\x95','\xbd','N','T','_','M','A','P','P','I','N','G','_','N','A','M','E','_','C','H','A','N','G','E','D',
/* 0x0f0a9 = "Floating pointer overflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','o','v','e','r','f','l','o','w','.',
/* 0x0f0c3 = "Recompiler: Register allocator internal processing error #1." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','1','.',
/* 0x0f0dd = "Name is not unique on the network." */
    'N','a','m','e',' ','\x0b','\x08','u','n','i','q','u','e',' ','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x0f0f7 = "VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT" */
    '\x01','\xa1','C','U','R','S','O','R','_','\x1c','L','I','T','T','L','E','_','D','A','T','A','_','L','E','F','T',
/* 0x0f111 = "The semaphore is set and cannot be closed." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x0b','s','e','t',' ','\x99','\xe0','\xa8','c','l','o','s','e','d','.',
/* 0x0f12b = "VERR_LDRELF_UNTERMINATED_STRING_TAB" */
    '\x01','L','D','R','E','L','F','_','U','N','T','E','R','M','I','N','A','T','E','D','_','\xd4','_','T','A','B',
/* 0x0f145 = "Requires process elevation (UAC)." */
    'R','e','q','u','i','r','e','s',' ','\x92','e','l','e','v','a','t','i','o','n',' ','(','U','A','C',')','.',
/* 0x0f15f = "VERR_DWARF_BAD_LINE_NUMBER_HEADER" */
    '\x01','D','W','A','R','F','_','\x1d','L','I','N','E','_','N','U','M','B','E','R','_','H','E','A','D','E','R',
/* 0x0f179 = "The cache is not up to date with the image." */
    '\x03','c','a','c','h','e',' ','\x0b','\x08','u','p',' ','\x0a','d','a','t','e',' ','\x80','\x02','i','m','a','g','e','.',
/* 0x0f193 = "The specified environment variable was not found." */
    '\x03','\x18','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x11','\x08','\x88',
/* 0x0f1ad = "Image Verification Failure: Error reading section headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\xda','h','e','a','d','e','r','s','.',
/* 0x0f1c7 = "HM returned in the wrong state." */
    'H','M',' ','r','e','t','u','r','n','e','d',' ','\x0f','\x02','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x0f1e1 = "VERR_DBG_NO_MATCHING_INTERPRETER" */
    '\x01','D','B','G','_','\x60','M','A','T','C','H','I','N','G','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x0f1fb = "Pluggable Device Manager error." */
    'P','l','u','g','g','a','b','l','e',' ','D','e','v','i','c','e',' ','M','a','n','a','g','e','r',' ','\x84',
/* 0x0f215 = "Too many primary volume descriptors." */
    'T','o','o',' ','\xb4','p','r','i','m','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0f22f = "VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION" */
    '\x01','\x22','\xb7','C','P','V','_','\x91','C','R','I','T','I','C','A','L','_','E','X','T','E','N','S','I','O','N',
/* 0x0f249 = "VERR_SSM_DATA_UNIT_FORMAT_CHANGED" */
    '\x01','\xb0','D','A','T','A','_','U','N','I','T','_','F','O','R','M','A','T','_','C','H','A','N','G','E','D',
/* 0x0f263 = "VMDK: Invalid image file header: invalid version." */
    'V','M','D','K',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r',':',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x0f27d = "Reason for leaving RZ: The urge to syncing CR3." */
    '\x93','\x10','\x81','R','Z',':',' ','\x03','u','r','g','e',' ','\x0a','s','y','n','c','i','n','g',' ','C','R','3','.',
/* 0x0f297 = "Image Verification Failure: Error reading image headers." */
    'I','m','a','g','e',' ','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x25','h','e','a','d','e','r','s','.',
/* 0x0f2b1 = "VERR_DBG_MALFORMED_UNWIND_INFO" */
    '\x01','D','B','G','_','M','A','L','F','O','R','M','E','D','_','U','N','W','I','N','D','_','I','N','F','O',
/* 0x0f2cb = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','\x91','I','M','A','G','E','_','\xfe',
/* 0x0f2e5 = "No page directory available for the hypervisor." */
    '\xe6','\xcb','\x26','a','v','a','i','l','a','b','l','e',' ','\x10','\x02','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0f2ff = "Descriptor tag is all zeros." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','\x0b','a','l','l',' ','z','e','r','o','s','.',
/* 0x0f319 = "Recompiler: Register allocator internal processing error #7." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','7','.',
/* 0x0f333 = "General network printing error." */
    'G','e','n','e','r','a','l',' ','n','e','t','w','o','r','k',' ','p','r','i','n','t','i','n','g',' ','\x84',
/* 0x0f34d = "Key algorithm parameters not expected." */
    'K','e','y',' ','\xd3','p','a','r','a','m','e','t','e','r','s',' ','\x08','e','x','p','e','c','t','e','d','.',
/* 0x0f367 = "VT-x VMCS launch state invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','l','a','u','n','c','h',' ','\xcd','i','n','v','a','l','i','d','.',
/* 0x0f381 = "The loaded timer state was incorrect." */
    '\x03','l','o','a','d','e','d',' ','t','i','m','e','r',' ','\xcd','\x11','i','n','c','o','r','r','e','c','t','.',
/* 0x0f39b = "Recording initialization failed." */
    'R','e','c','o','r','d','i','n','g',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7d',
/* 0x0f3b5 = "Too many logical volume descriptors." */
    'T','o','o',' ','\xb4','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x0f3cf = "Import ISO uses invalid volume sequence number." */
    '\xc3','\xc1',' ','u','s','e','s',' ','\x8f','\xd1','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x0f3e9 = "Internal processing error in the PGM handy page allocator." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','h','a','n','d','y',' ','\xcb','a','l','l','o','c','a','t','o','r','.',
/* 0x0f403 = "VINF_AUDIO_MORE_DATA_AVAILABLE" */
    '\x0e','A','U','D','I','O','_','M','O','R','E','_','D','A','T','A','_','A','V','A','I','L','A','B','L','E',
/* 0x0f41d = "Recompiler: Register allocator internal processing error #3." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','3','.',
/* 0x0f437 = "Can\'t move file to another disk." */
    'C','a','n','\'','t',' ','m','o','v','e',' ','\x1f','\x0a','a','n','o','t','h','e','r',' ','d','i','s','k','.',
/* 0x0f451 = "VINF_EM_RESUME_R3_HISTORY_EXEC" */
    '\x0e','E','M','_','R','E','S','U','M','E','_','R','3','_','H','I','S','T','O','R','Y','_','E','X','E','C',
/* 0x0f46b = "VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','V','E','R','I','F','Y','_','F','I','N','A','L','_','\x16',
/* 0x0f485 = "VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION" */
    '\x01','S','Y','S','T','E','M','_','\xf5','_','P','O','L','I','C','Y','_','V','I','O','L','A','T','I','O','N',
/* 0x0f49f = "Execute one instruction with the recompiler." */
    'E','x','e','c','u','t','e',' ','o','n','e',' ','\xd9','\x80','\x02','r','e','c','o','m','p','i','l','e','r','.',
/* 0x0f4b9 = "The JSON document is malformed." */
    '\x03','J','S','O','N',' ','d','o','c','u','m','e','n','t',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x0f4d3 = "VERR_NET_DEST_ADDRESS_REQUIRED" */
    '\x01','N','E','T','_','D','E','S','T','_','A','D','D','R','E','S','S','_','R','E','Q','U','I','R','E','D',
/* 0x0f4ed = "VERR_ISOFS_MALFORMED_PART_MAP_TABLE" */
    '\x01','\xa2','M','A','L','F','O','R','M','E','D','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x0f507 = "The USB device instance structure version has changed." */
    '\x03','U','S','B',' ','\xa3','i','n','s','t','a','n','c','e',' ','\xea','\xcf','\x7b','c','h','a','n','g','e','d','.',
/* 0x0f521 = "VERR_VMX_VMCS_FIELD_CACHE_INVALID" */
    '\x01','\xe1','V','M','C','S','_','F','I','E','L','D','_','C','A','C','H','E','_','I','N','V','A','L','I','D',
/* 0x0f53b = "Recompiler: Register allocator internal processing error #8." */
    '\x13','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x17','\x04','\x09','#','8','.',
/* 0x0f555 = "VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','\xe2','\xd4','_','A','S','_','B','O','O','L',
/* 0x0f56f = "VINF_EM_RESCHEDULE_EXEC_ENGINE" */
    '\x0e','E','M','_','R','E','S','C','H','E','D','U','L','E','_','E','X','E','C','_','E','N','G','I','N','E',
/* 0x0f589 = "VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','F','R','E','E','_','\x1c','M','U','C','H',
/* 0x0f5a3 = "VERR_SHCLPB_MAX_EVENTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','E','V','E','N','T','S','_','R','E','A','C','H','E','D',
/* 0x0f5bd = "The specified I/O port range was invalid." */
    '\x03','\x18','I','/','O',' ','p','o','r','t',' ','r','a','n','g','e',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x0f5d7 = "VERR_LDRELF_INVALID_RELOCATION_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x05','R','E','L','O','C','A','T','I','O','N','_','O','F','F','S','E','T',
/* 0x0f5f1 = "VERR_INTNET_INCOMPATIBLE_TRUNK" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','T','R','U','N','K',
/* 0x0f60b = "Process Verification Failure: Error querying image information." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','\x25','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0f625 = "VINF_EM_PENDING_R3_IOPORT_READ" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x0f63f = "The CRC of the saved state file did not match." */
    '\x03','C','R','C',' ','\x15','\x02','s','a','v','e','d',' ','\xcd','\x1f','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x0f659 = "VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x19',
/* 0x0f673 = "VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED" */
    '\x01','\x22','\xb7','C','P','V','_','A','L','T','_','N','A','M','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x0f68d = "VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','P','R','O','V','I','D','E','R','_','N','A','M','E',
/* 0x0f6a7 = "Internal processing error in the debug module reader code." */
    '\x07','\x04','\x09','\x0f','\x02','d','e','b','u','g',' ','m','o','d','u','l','e',' ','r','e','a','d','e','r',' ','\x83',
/* 0x0f6c1 = "VERR_FILE_AIO_INSUFFICIENT_EVENTS" */
    '\x01','\xab','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','E','V','E','N','T','S',
/* 0x0f6da = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','\x05','I','D',
/* 0x0f6f3 = "VERR_VD_IMAGE_REPAIR_IMPOSSIBLE" */
    '\x01','\xff','I','M','A','G','E','_','R','E','P','A','I','R','_','I','M','P','O','S','S','I','B','L','E',
/* 0x0f70c = "VERR_VUSB_DEVICE_IS_SUSPENDED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','S','U','S','P','E','N','D','E','D',
/* 0x0f725 = "VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR" */
    '\x01','\x22','K','E','Y','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x1a',
/* 0x0f73e = "VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET" */
    '\x01','C','P','U','M','_','M','S','R','_','\x1d','C','P','U','M','C','P','U','_','O','F','F','S','E','T',
/* 0x0f757 = "Encountered a init function section." */
    '\xa5','a',' ','i','n','i','t',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x0f770 = "Unused MMIO register read, fill with 00." */
    'U','n','u','s','e','d',' ','\xd2',' ','\xe9','r','e','a','d',',',' ','f','i','l','l',' ','\x80','0','0','.',
/* 0x0f789 = "VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\x05','B','O','O','T','_','M','E','D','I','A','_','\xb5',
/* 0x0f7a2 = "VINF_EM_RAW_INTERRUPT_PENDING" */
    '\x0e','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','P','E','N','D','I','N','G',
/* 0x0f7bb = "The VFS chain specification is empty." */
    '\x03','\x8d',' ','\x9f','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x0b','e','m','p','t','y','.',
/* 0x0f7d4 = "Mismatching architecture." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x0f7ed = "VERR_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x01','\xb7','\x06','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0f806 = "VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY" */
    '\x01','\x22','P','K','I','X','_','\x06','E','C','D','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x0f81f = "Wrong 32/64-bit switcher." */
    'W','r','o','n','g',' ','3','2','/','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r','.',
/* 0x0f838 = "VERR_SSM_ENUM_VALUE_OUT_OF_RANGE" */
    '\x01','\xb0','E','N','U','M','_','V','A','L','U','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f851 = "Encountered an unknown attribute form." */
    '\xa5','\x87','u','n','k','n','o','w','n',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x0f86a = "VERR_VUSB_DEVICE_IS_RESETTING" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','R','E','S','E','T','T','I','N','G',
/* 0x0f883 = "Command address is invalid." */
    'C','o','m','m','a','n','d',' ','a','d','d','r','e','s','s',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x0f89c = "Failed to get underlying link ID." */
    '\x8b','\x0a','g','e','t',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','I','D','.',
/* 0x0f8b5 = "No available ports on the hub." */
    '\xe6','a','v','a','i','l','a','b','l','e',' ','p','o','r','t','s',' ','o','n',' ','\x02','h','u','b','.',
/* 0x0f8ce = "Parallels HDD: Invalid image file header." */
    'P','a','r','a','l','l','e','l','s',' ','H','D','D',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x0f8e7 = "Shared Clipboard event failed error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','\x98','\x84',
/* 0x0f900 = "VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x01','\x5e','\x60','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x0f919 = "VERR_SEM_LV_EXISTING_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','E','X','I','S','T','I','N','G','_','D','E','A','D','L','O','C','K',
/* 0x0f932 = "The mode field in a tar header is bad." */
    '\x03','m','o','d','e',' ','f','i','e','l','d',' ','\x0f','a',' ','t','a','r',' ','\xb3','\x0b','b','a','d','.',
/* 0x0f94b = "VERR_SHCLPB_MAX_LISTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','L','I','S','T','S','_','R','E','A','C','H','E','D',
/* 0x0f964 = "Hypervisor code was stepped." */
    'H','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',' ','\x11','s','t','e','p','p','e','d','.',
/* 0x0f97d = "VERR_NET_INCOMPLETE_TX_PACKET" */
    '\x01','N','E','T','_','I','N','C','O','M','P','L','E','T','E','_','T','X','_','P','A','C','K','E','T',
/* 0x0f996 = "Process Verification Failure: The process has too many virtual memory regions." */
    '\x1e','\x0d','\x12','\x03','\x92','\x7b','\xa0','\xb4','v','i','r','t','u','a','l',' ','\x85','r','e','g','i','o','n','s','.',
/* 0x0f9af = "VERR_BIGNUM_NEGATIVE_EXPONENT" */
    '\x01','B','I','G','N','U','M','_','N','E','G','A','T','I','V','E','_','E','X','P','O','N','E','N','T',
/* 0x0f9c8 = "VWRN_CSAM_INSTRUCTION_PATCHED" */
    '\xe4','C','S','A','M','_','I','N','S','T','R','U','C','T','I','O','N','_','P','A','T','C','H','E','D',
/* 0x0f9e1 = "A number tar header field was malformed." */
    'A',' ','\xf9','t','a','r',' ','\xb3','f','i','e','l','d',' ','\x11','m','a','l','f','o','r','m','e','d','.',
/* 0x0f9fa = "Unused MMIO register read, fill with FF." */
    'U','n','u','s','e','d',' ','\xd2',' ','\xe9','r','e','a','d',',',' ','f','i','l','l',' ','\x80','F','F','.',
/* 0x0fa13 = "VERR_GSTCTL_PROCESS_EXIT_CODE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','E','X','I','T','_','C','O','D','E',
/* 0x0fa2c = "Was not able to open the support driver." */
    'W','a','s',' ','\x08','a','b','l','e',' ','\x0a','o','p','e','n',' ','\x02','\xce','d','r','i','v','e','r','.',
/* 0x0fa45 = "No default entry in the boot catalog." */
    '\xe6','d','e','f','a','u','l','t',' ','\xc8','\x0f','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x0fa5e = "Bad offset element in table of content sub-element." */
    '\x9d','o','f','f','s','e','t',' ','\x5c','\x0f','\xb1','\x15','\xed','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0fa77 = "VERR_FDT_DTB_PROP_SIZE_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','\xfe','_','M','A','L','F','O','R','M','E','D',
/* 0x0fa90 = "VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY" */
    '\x01','\x22','P','K','I','X','_','H','A','S','H','_','\x1c','L','O','N','G','_','F','O','R','_','K','E','Y',
/* 0x0faa9 = "VERR_NET_CONNECTION_TIMED_OUT" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','T','I','M','E','D','_','O','U','T',
/* 0x0fac2 = "A bad page map entry was encountered." */
    'A',' ','b','a','d',' ','\xcb','m','a','p',' ','\xc8','\x11','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0fadb = "Bad length element in table of content sub-element." */
    '\x9d','l','e','n','g','t','h',' ','\x5c','\x0f','\xb1','\x15','\xed','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0faf4 = "VERR_CPUM_INCOMPATIBLE_CONFIG" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x0fb0d = "VERR_INTNET_FLT_VNIC_CREATE_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','C','R','E','A','T','E','_','\x16',
/* 0x0fb26 = "Proxy couldn\'t be resolved." */
    'P','r','o','x','y',' ','c','o','u','l','d','n','\'','t',' ','\xa8','r','e','s','o','l','v','e','d','.',
/* 0x0fb3f = "Invalid configuration property value." */
    '\x0c','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','p','e','r','t','y',' ','\xf3',
/* 0x0fb58 = "Bad DWARF abbreviation data." */
    '\x9d','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','d','a','t','a','.',
/* 0x0fb71 = "VERR_CR_KEY_MALFORMED_CIPHER_IV" */
    '\x01','\x22','K','E','Y','_','M','A','L','F','O','R','M','E','D','_','C','I','P','H','E','R','_','I','V',
/* 0x0fb8a = "VERR_CR_KEY_ALGO_PARAMS_UNKNOWN" */
    '\x01','\x22','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','K','N','O','W','N',
/* 0x0fba3 = "VERR_CR_PKIX_SIGNATURE_NEGATIVE" */
    '\x01','\x22','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','N','E','G','A','T','I','V','E',
/* 0x0fbbc = "VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\xe4','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x16',
/* 0x0fbd5 = "VERR_PATM_IPE_TRAP_IN_PATCH_CODE" */
    '\x01','P','A','T','M','_','\x14','T','R','A','P','_','I','N','_','P','A','T','C','H','_','C','O','D','E',
/* 0x0fbee = "VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH" */
    '\x01','\xa1','C','U','R','S','O','R','_','T','A','G','_','F','L','A','G','_','C','L','A','S','S','_','\x19',
/* 0x0fc07 = "VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED" */
    '\x01','\xd5','S','Y','M','L','I','N','K','S','_','A','R','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x0fc20 = "VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT" */
    '\x01','\x8d','_','\x8e','M','U','S','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x0fc39 = "VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF" */
    '\x01','\x90','T','R','A','C','E','R','_','C','A','N','N','O','T','_','O','P','E','N','_','S','E','L','F',
/* 0x0fc52 = "VERR_DBGF_BP_OWNER_NO_MORE_HANDLES" */
    '\x01','\xb9','_','B','P','_','O','W','N','E','R','_','\x60','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x0fc6b = "VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN" */
    '\x01','\x22','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','\x06','K','N','O','W','N',
/* 0x0fc84 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP" */
    '\x01','\x9b','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\x60','F','R','E','E','_','T','M','P',
/* 0x0fc9d = "VFS chain doesn't end with a path only element." */
    '\x8d',' ','\x9f','\xc7','e','n','d',' ','\x80','a',' ','\xd0','o','n','l','y',' ','e','l','e','m','e','n','t','.',
/* 0x0fcb6 = "Command hardware failure." */
    'C','o','m','m','a','n','d',' ','h','a','r','d','w','a','r','e',' ','f','a','i','l','u','r','e','.',
/* 0x0fccf = "Too many instances of a device." */
    'T','o','o',' ','\xb4','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','d','e','v','i','c','e','.',
/* 0x0fce8 = "VERR_REST_PATH_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','P','A','T','H','_','P','A','R','A','M','E','T','E','R','_','\x06','S','E','T',
/* 0x0fd01 = "Internal processing error #1 in the DBGF event tracing code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','e','v','e','n','t',' ','t','r','a','c','i','n','g',' ','\x83',
/* 0x0fd1a = "VERR_ASN1_BITSTRING_OUT_OF_BOUNDS" */
    '\x01','\xa1','B','I','T','S','T','R','I','N','G','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0fd33 = "NEM returned in the wrong state." */
    '\xec',' ','r','e','t','u','r','n','e','d',' ','\x0f','\x02','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x0fd4c = "Reason for leaving RC: Encountered a stale selector." */
    '\x93','\x10','\x81','R','C',':',' ','\xa5','a',' ','s','t','a','l','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x0fd65 = "VINF_VRDP_OPERATION_COMPLETED" */
    '\x0e','V','R','D','P','_','O','P','E','R','A','T','I','O','N','_','C','O','M','P','L','E','T','E','D',
/* 0x0fd7e = "Process Verification Failure: Bad section alignment value in image header." */
    '\x1e','\x0d','\x12','\x9d','\xda','a','l','i','g','n','m','e','n','t',' ','\xfa','\x0f','\x25','h','e','a','d','e','r','.',
/* 0x0fd97 = "The LUN is not attached to the device." */
    '\x03','L','U','N',' ','\x0b','\x08','a','t','t','a','c','h','e','d',' ','\x0a','\x02','d','e','v','i','c','e','.',
/* 0x0fdb0 = "The register is read-only and cannot be modified." */
    '\x03','\xe9','\x0b','r','e','a','d','-','o','n','l','y',' ','\x99','\xe0','\xa8','m','o','d','i','f','i','e','d','.',
/* 0x0fdc9 = "VERR_IPC_SEND_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x0fde2 = "Image Verification Failure: Invalid security directory entry." */
    'I','m','a','g','e',' ','\x0d','\x12','\x0c','s','e','c','u','r','i','t','y',' ','\x26','e','n','t','r','y','.',
/* 0x0fdfb = "VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x0e','\x5e','\x60','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x0fe14 = "Failed to read the device table entry due to an invalid offset." */
    '\x8b','\x0a','r','e','a','d',' ','\x02','\xa3','\xb1','\xc8','d','u','e',' ','\x0a','\x87','\x8f','o','f','f','s','e','t','.',
/* 0x0fe2d = "Process Verification Failure: Bad file alignment value in image header." */
    '\x1e','\x0d','\x12','\x9d','\x1f','a','l','i','g','n','m','e','n','t',' ','\xfa','\x0f','\x25','h','e','a','d','e','r','.',
/* 0x0fe46 = "Process Verification Failure: Image section region is too large." */
    '\x1e','\x0d','\x12','I','m','a','g','e',' ','\xda','r','e','g','i','o','n',' ','\x0b','\xa0','l','a','r','g','e','.',
/* 0x0fe5f = "VINF_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x0e','\xb7','\x06','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0fe78 = "The tar file ended unexpectedly." */
    '\x03','t','a','r',' ','\x1f','e','n','d','e','d',' ','u','n','e','x','p','e','c','t','e','d','l','y','.',
/* 0x0fe91 = "Too many references to an object." */
    'T','o','o',' ','\xb4','r','e','f','e','r','e','n','c','e','s',' ','\x0a','\x87','o','b','j','e','c','t','.',
/* 0x0feaa = "Too many instances of a driver." */
    'T','o','o',' ','\xb4','i','n','s','t','a','n','c','e','s',' ','\x15','a',' ','d','r','i','v','e','r','.',
/* 0x0fec3 = "VERR_XAR_UNUSED_ARCHIVED_DATA" */
    '\x01','X','A','R','_','U','N','U','S','E','D','_','A','R','C','H','I','V','E','D','_','D','A','T','A',
/* 0x0fedc = "Bad VTG provider descriptor." */
    '\x9d','V','T','G',' ','p','r','o','v','i','d','e','r',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0fef5 = "Internal processing error: Not build certificate." */
    '\x07','\x04','\xd7','N','o','t',' ','b','u','i','l','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0ff0e = "VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION" */
    '\x01','\xa2','\x1d','L','V','D','_','\xab','S','E','T','_','D','E','S','C','_','L','O','C','A','T','I','O','N',
/* 0x0ff27 = "Generic dangling objects status." */
    '\xa6','d','a','n','g','l','i','n','g',' ','o','b','j','e','c','t','s',' ','s','t','a','t','u','s','.',
/* 0x0ff40 = "The timer was in a unknown state." */
    '\x03','t','i','m','e','r',' ','\x11','\x0f','a',' ','u','n','k','n','o','w','n',' ','s','t','a','t','e','.',
/* 0x0ff59 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\x01','\x90','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x16',
/* 0x0ff72 = "VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH" */
    '\x01','\x22','\xe3','S','I','G','N','E','R','_','I','N','F','O','_','\xbe','E','N','C','R','Y','P','T','_','\x19',
/* 0x0ff8b = "The request function is not implemented." */
    '\x03','\xaa','f','u','n','c','t','i','o','n',' ','\x0b','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0ffa4 = "VINF_GIM_HYPERCALL_CONTINUING" */
    '\x0e','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','C','O','N','T','I','N','U','I','N','G',
/* 0x0ffbd = "Page hash table size overflow." */
    'P','a','g','e',' ','h','a','s','h',' ','\xb1','s','i','z','e',' ','o','v','e','r','f','l','o','w','.',
/* 0x0ffd6 = "VERR_LDRVI_SECTION_RAW_DATA_VALUES" */
    '\x01','\xf2','S','E','C','T','I','O','N','_','R','A','W','_','D','A','T','A','_','V','A','L','U','E','S',
/* 0x0ffef = "VERR_HTTP_CACERT_WRONG_FORMAT" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','W','R','O','N','G','_','F','O','R','M','A','T',
/* 0x10008 = "VDI: Invalid image file header: invalid version." */
    'V','D','I',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r',':',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x10021 = "VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH" */
    '\x01','\xf2','M','A','C','H','I','N','E','_','O','P','T','_','H','D','R','_','M','A','G','I','C','_','\x19',
/* 0x1003a = "VERR_IOM_MMIO_HANDLER_BOGUS_CALL" */
    '\x01','I','O','M','_','\xd2','_','H','A','N','D','L','E','R','_','B','O','G','U','S','_','C','A','L','L',
/* 0x10053 = "VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY" */
    '\x01','\x24','B','O','O','T','_','C','A','T','_','\x60','D','E','F','A','U','L','T','_','E','N','T','R','Y',
/* 0x1006c = "VERR_FTP_CLIENT_LIMIT_REACHED" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10085 = "VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE" */
    '\x01','\x5e','D','R','I','V','E','R','_','D','E','T','A','C','H','_','\x06','P','O','S','S','I','B','L','E',
/* 0x1009e = "Failed to fstat a native handle (hardening)." */
    '\x8b','\x0a','f','s','t','a','t',' ','a',' ','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\xad',
/* 0x100b7 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','\x1c','B','I','G',
/* 0x100d0 = "NEM failed to map page(s) into the VM." */
    '\xec',' ','\x98','\x0a','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x100e9 = "VFS chain element takes exactly three arguments." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','h','r','e','e',' ','\xdc',
/* 0x10102 = "Invalid object ID in managed object reference." */
    '\x0c','\xa7','I','D',' ','\x0f','m','a','n','a','g','e','d',' ','\xa7','r','e','f','e','r','e','n','c','e','.',
/* 0x1011b = "Certificate path builder: Encountered bad certificate context." */
    '\xba','\xd0','b','u','i','l','d','e','r',':',' ','\xa5','b','a','d',' ','\x9e','c','o','n','t','e','x','t','.',
/* 0x10134 = "VERR_HOSTIF_DEVICE_NAME_TOO_LONG" */
    '\x01','H','O','S','T','I','F','_','D','E','V','I','C','E','_','N','A','M','E','_','\x1c','L','O','N','G',
/* 0x1014d = "VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','R','W','_','\x1c','\xaf','R','E','C','U','R','S','I','O','N','S',
/* 0x10166 = "Bad SPC object moniker UUID field." */
    '\x9d','S','P','C',' ','\xa7','m','o','n','i','k','e','r',' ','U','U','I','D',' ','f','i','e','l','d','.',
/* 0x1017f = "The handle ID was not found in the set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x11','\x08','f','o','u','n','d',' ','\x0f','\x02','s','e','t','.',
/* 0x10198 = "Bad iterdata (EXEPACK) data." */
    '\x9d','i','t','e','r','d','a','t','a',' ','(','E','X','E','P','A','C','K',')',' ','d','a','t','a','.',
/* 0x101b1 = "The PE loader doesn't grok the COM descriptor data directory entry." */
    '\x03','P','E',' ','\xd8','\xc7','g','r','o','k',' ','\x02','C','O','M',' ','\xee','\x9c','\x26','e','n','t','r','y','.',
/* 0x101ca = "The instruction is not yet implemented by IEM." */
    '\x03','\xd9','\x0b','\x08','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xdf','I','E','M','.',
/* 0x101e3 = "The EVP_PKEY_type API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','\xf1','A','P','I',' ','\x0f','O','p','e','n','S','S','L',' ','\x7d',
/* 0x101fc = "VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR" */
    '\x01','\x9b','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\x60','F','R','E','E','_','V','A','R',
/* 0x10215 = "Was not able to load the support driver." */
    'W','a','s',' ','\x08','a','b','l','e',' ','\x0a','l','o','a','d',' ','\x02','\xce','d','r','i','v','e','r','.',
/* 0x1022e = "Unsupported PKCS #7 signed data version." */
    '\x97','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x9c','v','e','r','s','i','o','n','.',
/* 0x10247 = "Basic constraints were not found." */
    'B','a','s','i','c',' ','c','o','n','s','t','r','a','i','n','t','s',' ','w','e','r','e',' ','\x08','\x88',
/* 0x10260 = "VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS" */
    '\x01','\xfb','\xe2','U','N','B','A','L','A','N','C','E','D','_','P','A','R','E','N','T','H','E','S','I','S',
/* 0x10279 = "VINF_PGM_HANDLED_DIRTY_BIT_FAULT" */
    '\x0e','\x8c','H','A','N','D','L','E','D','_','D','I','R','T','Y','_','B','I','T','_','F','A','U','L','T',
/* 0x10292 = "Internal SPC error: Bad object moniker data pointer." */
    '\x07','S','P','C',' ','\xd7','\x9d','\xa7','m','o','n','i','k','e','r',' ','\x9c','p','o','i','n','t','e','r','.',
/* 0x102ab = "VINF_DBGF_ZERO_EXTENDED_REGISTER" */
    '\x0e','\xb9','_','Z','E','R','O','_','E','X','T','E','N','D','E','D','_','R','E','G','I','S','T','E','R',
/* 0x102c4 = "Decompression integrity error." */
    'D','e','c','o','m','p','r','e','s','s','i','o','n',' ','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x102dd = "Unsupported CPU feature combination." */
    '\x97','C','P','U',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x102f6 = "VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','D','I','R','_','O','R','_','F','S','S','_','O','R','_','\x8d',
/* 0x1030f = "The write monitor is already engaged." */
    '\x03','w','r','i','t','e',' ','m','o','n','i','t','o','r',' ','\x0b','\x7f','e','n','g','a','g','e','d','.',
/* 0x10328 = "Directory can\'t be deleted." */
    'D','i','r','e','c','t','o','r','y',' ','c','a','n','\'','t',' ','\xa8','d','e','l','e','t','e','d','.',
/* 0x10341 = "Encountered a term function section." */
    '\xa5','a',' ','t','e','r','m',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x1035a = "Encountered a section type that\'s not implemented." */
    '\xa5','a',' ','\xda','\xf1','t','h','a','t','\'','s',' ','\x08','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x10373 = "There is no tracer present." */
    'T','h','e','r','e',' ','\x0b','n','o',' ','t','r','a','c','e','r',' ','p','r','e','s','e','n','t','.',
/* 0x1038c = "VINF_EM_RAW_INJECT_TRPM_EVENT" */
    '\x0e','E','M','_','R','A','W','_','I','N','J','E','C','T','_','T','R','P','M','_','E','V','E','N','T',
/* 0x103a5 = "VERR_XAR_EXTRACTED_SIZE_EXCEEDED" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','\xfe','_','E','X','C','E','E','D','E','D',
/* 0x103be = "A DWARF abbreviation was not found." */
    'A',' ','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','\x11','\x08','\x88',
/* 0x103d6 = "Internal processing error #1 in page access handler code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\xcb','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x83',
/* 0x103ee = "VERR_GETOPT_INVALID_ARGUMENT_FORMAT" */
    '\x01','G','E','T','O','P','T','_','\x05','A','R','G','U','M','E','N','T','_','F','O','R','M','A','T',
/* 0x10406 = "VERR_APIC_INTR_MASKED_BY_TPR" */
    '\x01','A','P','I','C','_','I','N','T','R','_','M','A','S','K','E','D','_','B','Y','_','T','P','R',
/* 0x1041e = "The PKCS #7 content is not signed data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xed','\x0b','\x08','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x10436 = "VFS chain element takes exactly four arguments." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','o','u','r',' ','\xdc',
/* 0x1044e = "VFS chain element takes exactly five arguments." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','i','v','e',' ','\xdc',
/* 0x10466 = "The DBGF has no more free breakpoint slots." */
    '\x03','\xb9',' ','\x7b','n','o',' ','m','o','r','e',' ','f','r','e','e',' ','\xbf','s','l','o','t','s','.',
/* 0x1047e = "The compressed data was corrupted." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9c','\x11','c','o','r','r','u','p','t','e','d','.',
/* 0x10496 = "The timer was not in the correct state for the request operation." */
    '\x03','t','i','m','e','r',' ','\x11','\x08','\x0f','\x02','c','o','r','r','e','c','t',' ','\xcd','\x10','\x02','\xaa','\xe8',
/* 0x104ae = "VRDP protocol violation." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n','.',
/* 0x104c6 = "VERR_PGM_POOL_MAXED_OUT_ALREADY" */
    '\x01','\x8c','P','O','O','L','_','M','A','X','E','D','_','O','U','T','_','A','L','R','E','A','D','Y',
/* 0x104de = "VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL" */
    '\x01','E','X','T','P','A','C','K','_','\x1b','H','O','S','T','_','U','N','I','N','S','T','A','L','L',
/* 0x104f6 = "VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH" */
    '\x01','\x22','P','K','I','X','_','\x05','S','I','G','N','A','T','U','R','E','_','L','E','N','G','T','H',
/* 0x1050e = "VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED" */
    '\x01','\x95','\xbd','C','R','E','A','T','E','_','R','E','A','D','_','E','V','T','_','S','E','M','_','\x16',
/* 0x10526 = "The field contains a value that is out of range." */
    '\x03','f','i','e','l','d',' ','\x8a','a',' ','\xfa','\xac','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x1053e = "VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY" */
    '\x01','\x22','P','K','I','X','_','\x06','E','C','D','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x10556 = "VERR_GMM_HIT_VM_ACCOUNT_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','\xcc','_','A','C','C','O','U','N','T','_','L','I','M','I','T',
/* 0X1056e = "Terminate search branch." */
    'e','r','m','i','n','a','t','e',' ','s','e','a','r','c','h',' ','b','r','a','n','c','h','.',
/* 0x10585 = "Generic out of resources warning." */
    '\xa6','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s',' ','w','a','r','n','i','n','g','.',
/* 0x1059d = "VERR_AUDIO_BACKEND_NOT_ATTACHED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','\x06','A','T','T','A','C','H','E','D',
/* 0x105b5 = "VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT" */
    '\x01','\x90','\x60','R','A','W','_','M','O','D','E','_','H','Y','P','E','R','_','V','_','R','O','O','T',
/* 0x105cd = "VERR_SUP_VP_DUPLICATE_DLL_MAPPING" */
    '\x01','\x95','\xbd','D','U','P','L','I','C','A','T','E','_','D','L','L','_','M','A','P','P','I','N','G',
/* 0x105e5 = "VERR_VD_ISCSI_SECRET_ENCRYPTED" */
    '\x01','\xff','I','S','C','S','I','_','S','E','C','R','E','T','_','E','N','C','R','Y','P','T','E','D',
/* 0x105fd = "Reached the max cache size." */
    'R','e','a','c','h','e','d',' ','\x02','m','a','x',' ','c','a','c','h','e',' ','s','i','z','e','.',
/* 0x10615 = "Access denied for the address." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x10','\x02','a','d','d','r','e','s','s','.',
/* 0x1062d = "VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\xb6','_','W','R','I','T','E','_','\x16',
/* 0x10645 = "Certificate path validator: Unknown critical certificate extension." */
    '\xba','\xd0','\xfd','\xf8','c','r','i','t','i','c','a','l',' ','\x9e','e','x','t','e','n','s','i','o','n','.',
/* 0x1065d = "We are in driverless mode." */
    'W','e',' ','a','r','e',' ','\x0f','d','r','i','v','e','r','l','e','s','s',' ','m','o','d','e','.',
/* 0x10675 = "VFS chain element expected non-empty argument." */
    '\x8d',' ','\x9f','\x5c','\xc9','n','o','n','-','e','m','p','t','y',' ','a','r','g','u','m','e','n','t','.',
/* 0x1068d = "VERR_X509_PRINT_EXTENSION_TO_BIO" */
    '\x01','\xb7','P','R','I','N','T','_','E','X','T','E','N','S','I','O','N','_','T','O','_','B','I','O',
/* 0x106a5 = "No CR3 root shadow page table." */
    '\xe6','C','R','3',' ','r','o','o','t',' ','s','h','a','d','o','w',' ','\xcb','t','a','b','l','e','.',
/* 0x106bd = "VERR_RECORDING_LIMIT_REACHED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x106d5 = "Recompiler: Hit instruction buffer size limit." */
    '\x13','H','i','t',' ','\xd9','b','u','f','f','e','r',' ','s','i','z','e',' ','l','i','m','i','t','.',
/* 0x106ed = "Syntax error - out of scratch memory." */
    '\xf7','\x09','-',' ','o','u','t',' ','\x15','s','c','r','a','t','c','h',' ','m','e','m','o','r','y','.',
/* 0x10705 = "VERR_FAM_MONITOR_DIRECTORY_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','D','I','R','E','C','T','O','R','Y','_','\x16',
/* 0x1071d = "Unable to lock a region of a file." */
    '\xde','\x0a','l','o','c','k',' ','a',' ','r','e','g','i','o','n',' ','\x15','a',' ','f','i','l','e','.',
/* 0x10735 = "VERR_VMM_RING3_CALL_DISABLED" */
    '\x01','V','M','M','_','R','I','N','G','3','_','C','A','L','L','_','D','I','S','A','B','L','E','D',
/* 0x1074d = "VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND" */
    '\x01','\x5e','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','L','U','N','_','\x06','\x2a',
/* 0x10765 = "Node index is out of bounds." */
    'N','o','d','e',' ','i','n','d','e','x',' ','\x0b','o','u','t',' ','\x15','b','o','u','n','d','s','.',
/* 0x1077d = "Unexpected interruption exit type." */
    '\x94','i','n','t','e','r','r','u','p','t','i','o','n',' ','e','x','i','t',' ','t','y','p','e','.',
/* 0x10795 = "The tar end of file record was read." */
    '\x03','t','a','r',' ','e','n','d',' ','\x15','\x1f','r','e','c','o','r','d',' ','\x11','r','e','a','d','.',
/* 0x107ad = "VERR_IEM_VAR_OUT_OF_STACK_SLOTS" */
    '\x01','\x9b','V','A','R','_','O','U','T','_','O','F','_','S','T','A','C','K','_','S','L','O','T','S',
/* 0x107c5 = "VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT" */
    '\x01','\xdb','D','I','R','E','C','T','O','R','Y','_','P','T','R','_','\x06','P','R','E','S','E','N','T',
/* 0x107dd = "The Ring-3 module was already loaded." */
    '\x03','R','i','n','g','-','3',' ','m','o','d','u','l','e',' ','\x11','\x7f','l','o','a','d','e','d','.',
/* 0x107f5 = "NEM failed to query dirty page bitmap." */
    '\xec',' ','\x98','\x0a','q','u','e','r','y',' ','d','i','r','t','y',' ','\xcb','b','i','t','m','a','p','.',
/* 0x1080d = "Nothing that can be cancelled." */
    'N','o','t','h','i','n','g',' ','\xac','c','a','n',' ','\xa8','c','a','n','c','e','l','l','e','d','.',
/* 0x10825 = "VERR_PROC_ELEVATION_REQUIRED" */
    '\x01','P','R','O','C','_','E','L','E','V','A','T','I','O','N','_','R','E','Q','U','I','R','E','D',
/* 0x1083d = "The file is not a valid NM map file." */
    '\x03','\x1f','\x0b','\x08','a',' ','v','a','l','i','d',' ','N','M',' ','m','a','p',' ','f','i','l','e','.',
/* 0x10855 = "VERR_PDM_MEDIAEX_IOBUF_UNDERRUN" */
    '\x01','\x5e','M','E','D','I','A','E','X','_','I','O','B','U','F','_','U','N','D','E','R','R','U','N',
/* 0x1086d = "Failed to read the device table entry from guest memory." */
    '\x8b','\x0a','r','e','a','d',' ','\x02','\xa3','\xb1','\xc8','f','r','o','m',' ','\xbb','m','e','m','o','r','y','.',
/* 0x10885 = "FAM failed to open a connection." */
    'F','A','M',' ','\x98','\x0a','o','p','e','n',' ','a',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x1089d = "VINF_RECORDING_LIMIT_REACHED" */
    '\x0e','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x108b5 = "VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY" */
    '\x01','\x24','B','O','O','T','_','C','A','T','_','E','R','R','A','T','I','C','_','E','N','T','R','Y',
/* 0x108cd = "Recompiler: Uninitialized variable." */
    '\x13','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','v','a','r','i','a','b','l','e','.',
/* 0x108e5 = "VINF_PATM_DUPLICATE_FUNCTION" */
    '\x0e','P','A','T','M','_','D','U','P','L','I','C','A','T','E','_','F','U','N','C','T','I','O','N',
/* 0x108fd = "VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','S','I','G','N','_','F','I','N','A','L','_','\x16',
/* 0x10915 = "Recompiler: Fixed jump is out of range." */
    '\x13','F','i','x','e','d',' ','j','u','m','p',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x1092d = "Protocol wrong type for socket." */
    'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','\xf1','\x10','s','o','c','k','e','t','.',
/* 0x10945 = "Configuration value is unknown." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xfa','\x0b','u','n','k','n','o','w','n','.',
/* 0x1095d = "No partition descriptors found." */
    '\xe6','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x88',
/* 0x10975 = "The shared module version string is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xcf','\xf0','\x0b','\xa0','l','o','n','g','.',
/* 0x1098d = "Internal error: Uninitialized status code." */
    '\x07','\xd7','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','s','t','a','t','u','s',' ','\x83',
/* 0x109a5 = "VERR_NS_SYMLINK_CHANGE_OWNER" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','C','H','A','N','G','E','_','O','W','N','E','R',
/* 0x109bd = "VINF_EM_DBG_HYPER_BREAKPOINT" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','B','R','E','A','K','P','O','I','N','T',
/* 0x109d5 = "VINF_EM_RAW_EMULATE_DBG_STEP" */
    '\x0e','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','D','B','G','_','S','T','E','P',
/* 0x109ed = "VERR_VD_DISCARD_ALIGNMENT_NOT_MET" */
    '\x01','\xff','D','I','S','C','A','R','D','_','A','L','I','G','N','M','E','N','T','_','\x06','M','E','T',
/* 0x10a05 = "VERR_HOSTIF_FD_AND_INIT_TERM" */
    '\x01','H','O','S','T','I','F','_','F','D','_','A','N','D','_','I','N','I','T','_','T','E','R','M',
/* 0x10a1d = "Unknown or unrecognized SVM exit." */
    '\xf8','\xa9','u','n','r','e','c','o','g','n','i','z','e','d',' ','S','V','M',' ','e','x','i','t','.',
/* 0x10a35 = "VERR_IOM_NOT_IOPORT_RANGE_OWNER" */
    '\x01','I','O','M','_','\x06','I','O','P','O','R','T','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x10a4d = "Unknown digest algorithm used by PKCS #7 object." */
    '\xf8','\xd6','\xd3','u','s','e','d',' ','\xdf','P','K','C','S',' ','#','7',' ','o','b','j','e','c','t','.',
/* 0x10a65 = "Internal SPC error: Bad object moniker choice value." */
    '\x07','S','P','C',' ','\xd7','\x9d','\xa7','m','o','n','i','k','e','r',' ','c','h','o','i','c','e',' ','\xf3',
/* 0x10a7d = "Unable to make text memory writeable (hardening)." */
    '\xde','\x0a','m','a','k','e',' ','t','e','x','t',' ','\x85','w','r','i','t','e','a','b','l','e',' ','\xad',
/* 0x10a95 = "Invalid segment:offset address." */
    '\x0c','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s','.',
/* 0x10aad = "VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR" */
    '\x01','\x22','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','\xb5','_','\x1a',
/* 0x10ac5 = "Unexpected cURL error configure the proxy." */
    '\x94','c','U','R','L',' ','\x09','c','o','n','f','i','g','u','r','e',' ','\x02','p','r','o','x','y','.',
/* 0x10add = "VERR_PDM_MEDIAEX_IOREQ_CANCELED" */
    '\x01','\x5e','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','C','A','N','C','E','L','E','D',
/* 0x10af5 = "Internal processing error in the PGM dynmap (r0/rc)." */
    '\x07','\x04','\x09','\x0f','\x02','P','G','M',' ','d','y','n','m','a','p',' ','(','r','0','/','r','c',')','.',
/* 0x10b0d = "Invalid UTF-16 escape sequence." */
    '\x0c','U','T','F','-','1','6',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x10b25 = "Unsectioned boot catalog entry." */
    'U','n','s','e','c','t','i','o','n','e','d',' ','b','o','o','t',' ','\xe5','e','n','t','r','y','.',
/* 0x10b3d = "VINF_GCM_HANDLED_ADVANCE_RIP" */
    '\x0e','G','C','M','_','H','A','N','D','L','E','D','_','A','D','V','A','N','C','E','_','R','I','P',
/* 0x10b55 = "VERR_NET_PROTOCOL_NOT_AVAILABLE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x10b6d = "VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO" */
    '\x01','\x24','\x89','D','I','R','_','R','E','C','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x10b85 = "VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x0e','\x24','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x10b9d = "VERR_REST_WRONG_JSON_TYPE_FOR_STRING" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','\xb5','_','F','O','R','_','\xd4',
/* 0x10bb5 = "VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED" */
    '\x01','\x90','T','S','C','_','F','R','E','Q','_','M','E','A','S','U','R','E','M','E','N','T','_','\x16',
/* 0x10bcd = "VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS" */
    '\x01','\x24','\x89','D','I','R','_','W','I','T','H','_','M','O','R','E','_','E','X','T','E','N','T','S',
/* 0x10be5 = "Hypervisor memory allocation failed." */
    'H','y','p','e','r','v','i','s','o','r',' ','\x85','a','l','l','o','c','a','t','i','o','n',' ','\x7d',
/* 0x10bfd = "VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO" */
    '\x01','C','P','U','M','_','\x05','H','W','V','I','R','T','_','F','E','A','T','_','C','O','M','B','O',
/* 0x10c15 = "VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR" */
    '\x01','\x90','S','E','S','S','I','O','N','_','P','R','O','C','E','S','S','_','E','N','U','M','_','\x1a',
/* 0x10c2d = "VERR_PGM_PCI_PASSTHRU_MISCONFIG" */
    '\x01','\x8c','P','C','I','_','P','A','S','S','T','H','R','U','_','M','I','S','C','O','N','F','I','G',
/* 0x10c45 = "VERR_PDM_DEVICE_INSTANCE_NO_IBASE" */
    '\x01','\x5e','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x60','I','B','A','S','E',
/* 0x10c5d = "VERR_LDRPE_LOCK_PREFIX_TABLE" */
    '\x01','L','D','R','P','E','_','L','O','C','K','_','P','R','E','F','I','X','_','T','A','B','L','E',
/* 0x10c75 = "VERR_XAR_TOC_TOO_BIG_COMPRESSED" */
    '\x01','X','A','R','_','T','O','C','_','\x1c','B','I','G','_','C','O','M','P','R','E','S','S','E','D',
/* 0x10c8d = "VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH" */
    '\x01','\x95','\xbd','D','L','L','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x19',
/* 0x10ca5 = "The USB device helper structure version has changed." */
    '\x03','U','S','B',' ','\xa3','h','e','l','p','e','r',' ','\xea','\xcf','\x7b','c','h','a','n','g','e','d','.',
/* 0x10cbd = "VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x01','\x24','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x10cd5 = "VERR_RT_REQUEST_STATUS_FREED" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0X10ced = "Descriptor CRC mismatch." */
    'e','s','c','r','i','p','t','o','r',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x10d04 = "VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES" */
    '\x01','\x5e','\x1c','\xaf','U','S','B','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x10d1c = "No buffer space available." */
    '\xe6','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x10d34 = "Conflicting CFGM values." */
    'C','o','n','f','l','i','c','t','i','n','g',' ','C','F','G','M',' ','v','a','l','u','e','s','.',
/* 0x10d4c = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4" */
    '\x01','\xd5','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','4',
/* 0x10d64 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1" */
    '\x01','\xd5','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','1',
/* 0x10d7c = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0" */
    '\x01','\xd5','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','0',
/* 0x10d94 = "Invalid host interface version." */
    '\x0c','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','v','e','r','s','i','o','n','.',
/* 0x10dac = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2" */
    '\x01','\xd5','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','2',
/* 0x10dc4 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3" */
    '\x01','\xd5','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','3',
/* 0x10ddc = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5" */
    '\x01','\xd5','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','5',
/* 0x10df4 = "VERR_LDRELF_MULTIPLE_SYMTABS" */
    '\x01','L','D','R','E','L','F','_','M','U','L','T','I','P','L','E','_','S','Y','M','T','A','B','S',
/* 0x10e0c = "Bad VTG probe enabled data." */
    '\x9d','V','T','G',' ','p','r','o','b','e',' ','e','n','a','b','l','e','d',' ','d','a','t','a','.',
/* 0x10e24 = "VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','\x06','F','U','L','L','Y','_','M','A','P','P','E','D',
/* 0x10e3c = "Empty sub-string set inside X." */
    'E','m','p','t','y',' ','s','u','b','-','\xf0','s','e','t',' ','i','n','s','i','d','e',' ','X','.',
/* 0x10e54 = "The request is for something forbidden." */
    '\x03','\xaa','\x0b','\x10','s','o','m','e','t','h','i','n','g',' ','f','o','r','b','i','d','d','e','n','.',
/* 0x10e6c = "VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO" */
    '\x01','\x22','S','P','C','_','\x06','E','X','A','C','T','L','Y','_','O','N','E','_','\xbe','A','L','G','O',
/* 0x10e84 = "VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE" */
    '\x01','\x22','S','P','C','_','P','E','I','M','A','G','E','_','\x91','A','T','T','R','I','B','U','T','E',
/* 0x10e9c = "VERR_GIM_HYPERCALLS_NOT_ENABLED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x06','E','N','A','B','L','E','D',
/* 0x10eb4 = "Max timer limit reached." */
    'M','a','x',' ','t','i','m','e','r',' ','l','i','m','i','t',' ','r','e','a','c','h','e','d','.',
/* 0x10ecc = "VERR_PDM_MEDIAEX_IOBUF_OVERFLOW" */
    '\x01','\x5e','M','E','D','I','A','E','X','_','I','O','B','U','F','_','O','V','E','R','F','L','O','W',
/* 0x10ee4 = "Process Verification Failure: Error querying debug port." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','d','e','b','u','g',' ','p','o','r','t','.',
/* 0x10efc = "Reason for leaving RZ: Pending MMIO write." */
    '\x93','\x10','\x81','R','Z',':',' ','P','e','n','d','i','n','g',' ','\xd2',' ','w','r','i','t','e','.',
/* 0x10f13 = "VERR_MANIFEST_WRONG_FILE_FORMAT" */
    '\x01','M','A','N','I','F','E','S','T','_','W','R','O','N','G','_','\xab','F','O','R','M','A','T',
/* 0x10f2a = "The UDP server was destroyed." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x11','d','e','s','t','r','o','y','e','d','.',
/* 0x10f41 = "VERR_ASN1_TIME_BAD_NORMALIZE_INPUT" */
    '\x01','\xa1','T','I','M','E','_','\x1d','N','O','R','M','A','L','I','Z','E','_','I','N','P','U','T',
/* 0x10f58 = "VERR_HTTP_CURL_PROXY_CONFIG" */
    '\x01','H','T','T','P','_','C','U','R','L','_','P','R','O','X','Y','_','C','O','N','F','I','G',
/* 0x10f6f = "VERR_NET_CONNECTION_REFUSED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','F','U','S','E','D',
/* 0x10f86 = "Bad size element in table of content sub-element." */
    '\x9d','s','i','z','e',' ','\x5c','\x0f','\xb1','\x15','\xed','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x10f9d = "No configuration value exists." */
    '\xe6','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xfa','e','x','i','s','t','s','.',
/* 0x10fb4 = "VERR_NET_ADDRESS_NOT_AVAILABLE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x10fcb = "Hit the a VM account limit." */
    'H','i','t',' ','\x02','a',' ','\xcc',' ','a','c','c','o','u','n','t',' ','l','i','m','i','t','.',
/* 0x10fe2 = "Authentication failure." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','f','a','i','l','u','r','e','.',
/* 0x10ff9 = "VERR_SUP_VP_SET_HANDLE_NOINHERIT" */
    '\x01','\x95','\xbd','S','E','T','_','H','A','N','D','L','E','_','N','O','I','N','H','E','R','I','T',
/* 0x11010 = "VERR_INTNET_FLT_VNIC_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','O','P','E','N','_','\x16',
/* 0x11027 = "VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY" */
    '\x01','S','Y','S','_','\x1b','F','I','R','M','W','A','R','E','_','P','R','O','P','E','R','T','Y',
/* 0x1103e = "VERR_SUPDRV_HARDENING_EVIL_HANDLE" */
    '\x01','\x90','H','A','R','D','E','N','I','N','G','_','E','V','I','L','_','H','A','N','D','L','E',
/* 0x11055 = "VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x1106c = "VMDK: Image property not found." */
    'V','M','D','K',':',' ','I','m','a','g','e',' ','p','r','o','p','e','r','t','y',' ','\x08','\x88',
/* 0x11083 = "VERR_PDM_CRITSECTRW_MISALIGNED" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','R','W','_','M','I','S','A','L','I','G','N','E','D',
/* 0x1109a = "VERR_VRDP_INSUFFICIENT_DATA" */
    '\x01','V','R','D','P','_','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A',
/* 0x110b1 = "Too many clients for the service." */
    'T','o','o',' ','\xb4','c','l','i','e','n','t','s',' ','\x10','\x02','s','e','r','v','i','c','e','.',
/* 0x110c8 = "VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','F','A','M','I','L','Y','_','\x06','\x82',
/* 0x110df = "VERR_INTNET_FLT_VNIC_INIT_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','I','N','I','T','_','\x16',
/* 0x110f6 = "Inserting a new chunk failed." */
    'I','n','s','e','r','t','i','n','g',' ','a',' ','n','e','w',' ','c','h','u','n','k',' ','\x7d',
/* 0x1110d = "Entry in a boot catalog section is empty." */
    'E','n','t','r','y',' ','\x0f','a',' ','b','o','o','t',' ','\xe5','\xda','\x0b','e','m','p','t','y','.',
/* 0x11124 = "VERR_GIM_DEVICE_NOT_REGISTERED" */
    '\x01','G','I','M','_','D','E','V','I','C','E','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x1113b = "VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES" */
    '\x01','C','P','U','M','_','\x1c','\xaf','C','P','U','I','D','_','S','U','B','L','E','A','V','E','S',
/* 0x11152 = "The field contains an invalid padding size." */
    '\x03','f','i','e','l','d',' ','\x8a','\x87','\x8f','p','a','d','d','i','n','g',' ','s','i','z','e','.',
/* 0x11169 = "Error creating digest algorithm calculator." */
    '\xc0','c','r','e','a','t','i','n','g',' ','\xd6','\xd3','c','a','l','c','u','l','a','t','o','r','.',
/* 0x11180 = "VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH" */
    '\x01','\x22','\xb7','C','E','R','T','_','T','B','S','_','S','I','G','N','_','A','L','G','O','_','\x19',
/* 0x11197 = "VERR_SUP_VP_WINTRUST_CAT_FAILURE" */
    '\x01','\x95','\xbd','W','I','N','T','R','U','S','T','_','C','A','T','_','F','A','I','L','U','R','E',
/* 0x111ae = "iSCSI: Invalid device type (not a disk)." */
    'i','S','C','S','I',':',' ','\x0c','\xa3','\xf1','(','n','o','t',' ','a',' ','d','i','s','k',')','.',
/* 0x111c5 = "VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB" */
    '\x01','\x24','\x89','L','O','G','I','C','A','L','_','B','L','O','C','K','_','\xfe','_','\x06','2','K','B',
/* 0x111dc = "VERR_IOM_MMIO_HANDLER_DISASM_ERROR" */
    '\x01','I','O','M','_','\xd2','_','H','A','N','D','L','E','R','_','D','I','S','A','S','M','_','\x1a',
/* 0x111f3 = "VERR_SEM_LV_ILLEGAL_UPGRADE" */
    '\x01','S','E','M','_','L','V','_','I','L','L','E','G','A','L','_','U','P','G','R','A','D','E',
/* 0x1120a = "VFS chain element takes exactly six arguments." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','s','i','x',' ','\xdc',
/* 0x11221 = "The attribute type did not match." */
    '\x03','a','t','t','r','i','b','u','t','e',' ','\xf1','d','i','d',' ','\x08','m','a','t','c','h','.',
/* 0x11238 = "VERR_LDRPE_CERT_UNSUPPORTED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x1124f = "Reason for leaving RZ: Ring-3 operation pending." */
    '\x93','\x10','\x81','R','Z',':',' ','R','i','n','g','-','3',' ','\x96','p','e','n','d','i','n','g','.',
/* 0x11266 = "Encountered an unknown load command." */
    '\xa5','\x87','u','n','k','n','o','w','n',' ','l','o','a','d',' ','c','o','m','m','a','n','d','.',
/* 0x1127d = "Trying to seek on device." */
    'T','r','y','i','n','g',' ','\x0a','s','e','e','k',' ','o','n',' ','d','e','v','i','c','e','.',
/* 0x11294 = "VERR_NEM_QUERY_DIRTY_BITMAP_FAILED" */
    '\x01','\xec','_','Q','U','E','R','Y','_','D','I','R','T','Y','_','B','I','T','M','A','P','_','\x16',
/* 0x112ab = "Unable to open the host interface." */
    '\xde','\x0a','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x112c2 = "A tracer has already been registered." */
    'A',' ','t','r','a','c','e','r',' ','\x7b','\x7f','\xca','r','e','g','i','s','t','e','r','e','d','.',
/* 0x112d9 = "The semaphore cannot be set again." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\xe0','\xa8','s','e','t',' ','a','g','a','i','n','.',
/* 0x112f0 = "Client limit has been reached." */
    'C','l','i','e','n','t',' ','l','i','m','i','t',' ','\x7b','\xca','r','e','a','c','h','e','d','.',
/* 0x11307 = "There is more data available." */
    'T','h','e','r','e',' ','\x0b','m','o','r','e',' ','\x9c','a','v','a','i','l','a','b','l','e','.',
/* 0x1131e = "VERR_CR_X509_CPV_NO_PERMITTED_NAMES" */
    '\x01','\x22','\xb7','C','P','V','_','\x60','P','E','R','M','I','T','T','E','D','_','N','A','M','E','S',
/* 0x11335 = "Remapping failed for the interrupt." */
    'R','e','m','a','p','p','i','n','g',' ','\x98','\x10','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x1134c = "VINF_EM_DBG_HYPER_ASSERTION" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','A','S','S','E','R','T','I','O','N',
/* 0x11363 = "VERR_X509_READING_CERT_FROM_BIO" */
    '\x01','\xb7','R','E','A','D','I','N','G','_','C','E','R','T','_','F','R','O','M','_','B','I','O',
/* 0x1137a = "VERR_CR_PKIX_SIGNATURE_GE_KEY" */
    '\x01','\x22','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','G','E','_','K','E','Y',
/* 0x11391 = "VERR_PGM_MAPPINGS_FIX_CONFLICT" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','C','O','N','F','L','I','C','T',
/* 0x113a8 = "VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY" */
    '\x01','\x22','P','K','I','X','_','\x06','R','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x113bf = "VFS chain element takes exactly two arguments." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','w','o',' ','\xdc',
/* 0x113d6 = "VERR_OUT_OF_SELECTOR_BOUNDS" */
    '\x01','O','U','T','_','O','F','_','S','E','L','E','C','T','O','R','_','B','O','U','N','D','S',
/* 0x113ed = "Page directory pointer not present." */
    'P','a','g','e',' ','\x26','p','o','i','n','t','e','r',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x11404 = "VERR_PGM_WRITE_MONITOR_ENGAGED" */
    '\x01','\x8c','W','R','I','T','E','_','M','O','N','I','T','O','R','_','E','N','G','A','G','E','D',
/* 0x1141b = "VERR_BIGNUM_SENSITIVE_INPUT" */
    '\x01','B','I','G','N','U','M','_','S','E','N','S','I','T','I','V','E','_','I','N','P','U','T',
/* 0x11432 = "VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH" */
    '\x01','\x24','\x89','\x1d','R','O','O','T','_','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x11449 = "VINF_PGM_SYNCPAGE_MODIFIED_PDE" */
    '\x0e','\x8c','S','Y','N','C','P','A','G','E','_','M','O','D','I','F','I','E','D','_','P','D','E',
/* 0x11460 = "The command has already been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\x7b','\x7f','\xca','r','e','g','i','s','t','e','r','e','d','.',
/* 0x11477 = "VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','\xab','O','R','_','I','O','S','_','O','R','_','D','I','R',
/* 0x1148e = "Import ISO contains a bad root directory record." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','r','o','o','t',' ','\x26','r','e','c','o','r','d','.',
/* 0x114a5 = "VINF_EM_RAW_RING_SWITCH_INT" */
    '\x0e','E','M','_','R','A','W','_','R','I','N','G','_','S','W','I','T','C','H','_','I','N','T',
/* 0x114bc = "VERR_TM_VIRTUAL_TICKING_IPE" */
    '\x01','T','M','_','V','I','R','T','U','A','L','_','T','I','C','K','I','N','G','_','I','P','E',
/* 0x114d3 = "VERR_HARDAVL_STACK_OVERFLOW" */
    '\x01','H','A','R','D','A','V','L','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x114ea = "Invalid offset in an L4 dataspace." */
    '\x0c','o','f','f','s','e','t',' ','\x0f','\x87','L','4',' ','d','a','t','a','s','p','a','c','e','.',
/* 0x11501 = "VFS chain element takes a file object as input." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','a',' ','\x1f','\xa7','a','s',' ','i','n','p','u','t','.',
/* 0x11518 = "VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','\x06','A','D','J','A','C','E','N','T',
/* 0x1152f = "Failed to initialize a memory object." */
    '\x8b','\x0a','i','n','i','t','i','a','l','i','z','e',' ','a',' ','\x85','o','b','j','e','c','t','.',
/* 0x11546 = "VERR_SELM_LDT_OUT_OF_BOUNDS" */
    '\x01','S','E','L','M','_','L','D','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x1155d = "Failed to get a guest page which is expected to be present." */
    '\x8b','\x0a','g','e','t',' ','a',' ','\xbb','\xcb','\xeb','\x0b','\xc9','\x0a','\xa8','p','r','e','s','e','n','t','.',
/* 0x11574 = "VERR_PDM_HIF_SHARING_VIOLATION" */
    '\x01','\x5e','H','I','F','_','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1158b = "Stream could not be created." */
    'S','t','r','e','a','m',' ','c','o','u','l','d',' ','\x08','\xa8','c','r','e','a','t','e','d','.',
/* 0x115a2 = "VERR_SUP_VP_SECTION_PROTECTION_MISMATCH" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','P','R','O','T','E','C','T','I','O','N','_','\x19',
/* 0x115b9 = "VERR_PDM_DEV_HEAP_R3_TO_GCPHYS" */
    '\x01','\x5e','D','E','V','_','H','E','A','P','_','R','3','_','T','O','_','G','C','P','H','Y','S',
/* 0x115d0 = "VERR_IPE_NOT_REACHED_DEFAULT_CASE" */
    '\x01','\x14','\x06','R','E','A','C','H','E','D','_','D','E','F','A','U','L','T','_','C','A','S','E',
/* 0x115e7 = "Guest process is in a wrong state." */
    'G','u','e','s','t',' ','\x92','\x0b','\x0f','a',' ','w','r','o','n','g',' ','s','t','a','t','e','.',
/* 0x115fe = "The driver doesn't support runtime driver attaching." */
    '\x03','\xc5','\xc7','\xce','r','u','n','t','i','m','e',' ','\xc5','a','t','t','a','c','h','i','n','g','.',
/* 0x11615 = "VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY" */
    '\x01','\x22','\xb7','N','A','M','E','_','\xc4','_','R','D','N','_','M','A','P','_','E','N','T','R','Y',
/* 0x1162c = "VERR_GIM_HYPERCALL_MEMORY_READ_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\xb6','_','R','E','A','D','_','\x16',
/* 0x11643 = "VINF_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x0e','\x22','\xbe','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x1165a = "Certificate path validator: The certificate is not valid at the specified time." */
    '\xba','\xd0','\xfd','\x03','\x9e','\x0b','\x08','v','a','l','i','d',' ','a','t',' ','\x02','\x18','t','i','m','e','.',
/* 0x11671 = "SyncPage modified the PDE." */
    'S','y','n','c','P','a','g','e',' ','m','o','d','i','f','i','e','d',' ','\x02','P','D','E','.',
/* 0x11688 = "VINF_VGA_RESIZE_IN_PROGRESS" */
    '\x0e','V','G','A','_','R','E','S','I','Z','E','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1169f = "No parent node specified." */
    '\xe6','p','a','r','e','n','t',' ','n','o','d','e',' ','s','p','e','c','i','f','i','e','d','.',
/* 0x116b6 = "VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','M','A','P','P','I','N','G','_','B','A','S','E','_','\x1a',
/* 0x116cd = "VINF_EM_RAW_INTERRUPT_HYPER" */
    '\x0e','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','H','Y','P','E','R',
/* 0x116e4 = "Too deep ICB recursion." */
    'T','o','o',' ','d','e','e','p',' ','I','C','B',' ','r','e','c','u','r','s','i','o','n','.',
/* 0x116fb = "VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET" */
    '\x01','V','M','M','_','F','N','_','\x06','\x82','_','F','O','R','_','V','M','T','A','R','G','E','T',
/* 0x11712 = "VERR_CR_CIPHER_OSSL_SET_TAG_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','S','E','T','_','T','A','G','_','\x16',
/* 0x11729 = "VERR_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x01','\x22','\xbe','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x11740 = "Unsupported VRDP protocol feature." */
    '\x97','V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x11757 = "No logical volume descriptors found." */
    '\xe6','l','o','g','i','c','a','l',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s',' ','\x88',
/* 0x1176e = "No end of central directory record found." */
    '\xe6','e','n','d',' ','\x15','c','e','n','t','r','a','l',' ','\x26','r','e','c','o','r','d',' ','\x88',
/* 0x11785 = "VERR_CR_CIPHER_OSSL_GET_TAG_FAILED" */
    '\x01','\x22','C','I','P','H','E','R','_','O','S','S','L','_','G','E','T','_','T','A','G','_','\x16',
/* 0x1179c = "Bad mutex semaphore flags." */
    '\x9d','m','u','t','e','x',' ','s','e','m','a','p','h','o','r','e',' ','f','l','a','g','s','.',
/* 0x117b3 = "Process Purification Failure: KERNE32." */
    '\x1e','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','K','E','R','N','E','3','2','.',
/* 0x117ca = "VERR_IOM_INCOMPLETE_MMIO_RANGE" */
    '\x01','I','O','M','_','I','N','C','O','M','P','L','E','T','E','_','\xd2','_','R','A','N','G','E',
/* 0x117e1 = "The loaded XCR0 register value is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','C','R','0',' ','\xe9','\xfa','\x0b','\x08','v','a','l','i','d','.',
/* 0x117f8 = "VERR_PKZIP_ZIP64EX_IN_ZIP32" */
    '\x01','P','K','Z','I','P','_','Z','I','P','6','4','E','X','_','I','N','_','Z','I','P','3','2',
/* 0x1180f = "The iterator reached the end." */
    '\x03','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d','.',
/* 0x11826 = "VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED" */
    '\x01','\x22','\xe3','S','I','G','N','E','R','_','C','E','R','T','_','\x06','S','H','I','P','P','E','D',
/* 0x1183d = "Unsupported key encryption cipher." */
    '\x97','k','e','y',' ','e','n','c','r','y','p','t','i','o','n',' ','c','i','p','h','e','r','.',
/* 0x11854 = "The machine is not on the network." */
    '\x03','m','a','c','h','i','n','e',' ','\x0b','\x08','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x1186b = "VERR_VM_REQUEST_STATUS_FREED" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x11882 = "Symbolic link not allowed." */
    'S','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','a','l','l','o','w','e','d','.',
/* 0x11899 = "Duplicate segment name." */
    'D','u','p','l','i','c','a','t','e',' ','s','e','g','m','e','n','t',' ','n','a','m','e','.',
/* 0x118b0 = "VERR_DBG_FILE_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','\xab','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x118c7 = "The device doesn't support runtime driver attaching." */
    '\x03','\xa3','\xc7','\xce','r','u','n','t','i','m','e',' ','\xc5','a','t','t','a','c','h','i','n','g','.',
/* 0x118de = "VERR_NET_CONNECTION_ABORTED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','A','B','O','R','T','E','D',
/* 0x118f5 = "VINF_SSM_VOTE_FOR_ANOTHER_PASS" */
    '\x0e','\xb0','V','O','T','E','_','F','O','R','_','A','N','O','T','H','E','R','_','P','A','S','S',
/* 0x1190c = "VINF_CPUM_HOST_CR0_MODIFIED" */
    '\x0e','C','P','U','M','_','H','O','S','T','_','C','R','0','_','M','O','D','I','F','I','E','D',
/* 0x11923 = "Temporary place holder." */
    'T','e','m','p','o','r','a','r','y',' ','p','l','a','c','e',' ','h','o','l','d','e','r','.',
/* 0x1193a = "Unable to parse the XML in DMG file." */
    '\xde','\x0a','p','a','r','s','e',' ','\x02','X','M','L',' ','\x0f','D','M','G',' ','f','i','l','e','.',
/* 0x11951 = "VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND" */
    '\x01','L','D','R','_','I','M','P','O','R','T','E','D','_','S','Y','M','B','O','L','_','\x06','\x2a',
/* 0x11968 = "Failed to obtain the GMM instance." */
    '\x8b','\x0a','o','b','t','a','i','n',' ','\x02','G','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x1197f = "VERR_PGM_MAPPINGS_FIX_REJECTED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','R','E','J','E','C','T','E','D',
/* 0x11996 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','\xb6','_','N','M','_','\x1a',
/* 0x119ad = "Connection reset by peer." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','\xdf','p','e','e','r','.',
/* 0x119c4 = "The TCP server was destroyed." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x11','d','e','s','t','r','o','y','e','d','.',
/* 0x119db = "Device or resource is busy." */
    'D','e','v','i','c','e',' ','\xa9','r','e','s','o','u','r','c','e',' ','\x0b','b','u','s','y','.',
/* 0x119f2 = "Error formatting an extension." */
    '\xc0','f','o','r','m','a','t','t','i','n','g',' ','\x87','e','x','t','e','n','s','i','o','n','.',
/* 0x11a09 = "VERR_AUTHENTICATION_FAILURE" */
    '\x01','A','U','T','H','E','N','T','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x11a20 = "The loaded XSAVE header is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','\xb3','\x0b','\x08','v','a','l','i','d','.',
/* 0x11a37 = "VERR_RECORDING_CODEC_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','I','N','I','T','_','\x16',
/* 0x11a4e = "VERR_GSTCTL_PROCESS_WRONG_STATE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','W','R','O','N','G','_','\xef',
/* 0x11a65 = "No primary volume descriptors found." */
    '\xe6','p','r','i','m','a','r','y',' ','\xd1','d','e','s','c','r','i','p','t','o','r','s',' ','\x88',
/* 0x11a7c = "VERR_CR_X509_CPV_MAX_PATH_LENGTH" */
    '\x01','\x22','\xb7','C','P','V','_','M','A','X','_','P','A','T','H','_','L','E','N','G','T','H',
/* 0x11a92 = "Invalid argument to VFS chain element." */
    '\x0c','a','r','g','u','m','e','n','t',' ','\x0a','\x8d',' ','\x9f','e','l','e','m','e','n','t','.',
/* 0x11aa8 = "VINF_PATM_CHECK_PATCH_PAGE" */
    '\x0e','P','A','T','M','_','C','H','E','C','K','_','P','A','T','C','H','_','P','A','G','E',
/* 0x11abe = "VERR_VFS_CHAIN_TRAILING_SEPARATOR" */
    '\x01','\x8d','_','\x8e','T','R','A','I','L','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x11ad4 = "VERR_FDT_DTB_HDR_SIZE_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','\xfe','_','I','N','V','A','L','I','D',
/* 0x11aea = "VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL" */
    '\x01','\xff','R','A','W','_','\xfe','_','O','P','T','I','C','A','L','_','\x1c','S','M','A','L','L',
/* 0x11b00 = "VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE" */
    '\x01','\xe1','\x86','I','N','T','E','R','R','U','P','T','I','O','N','_','E','X','I','T','_','\xb5',
/* 0x11b16 = "Reason for leaving RZ: I/O port write." */
    '\x93','\x10','\x81','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x11b2c = "VERR_THREAD_IS_TERMINATING" */
    '\x01','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x11b42 = "VINF_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x0e','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x11b58 = "VERR_JSON_MISSING_SURROGATE_PAIR" */
    '\x01','J','S','O','N','_','\xc4','_','S','U','R','R','O','G','A','T','E','_','P','A','I','R',
/* 0x11b6e = "VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x11b84 = "VERR_WRONG_PARAMETER_COUNT" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','C','O','U','N','T',
/* 0x11b9a = "VERR_SVM_UNABLE_TO_START_VM" */
    '\x01','S','V','M','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xcc',
/* 0x11bb0 = "VERR_CR_X509_TBSCERT_EXTS_REQ_V3" */
    '\x01','\x22','\xb7','T','B','S','C','E','R','T','_','E','X','T','S','_','R','E','Q','_','V','3',
/* 0x11bc6 = "Is a character device." */
    'I','s',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','d','e','v','i','c','e','.',
/* 0x11bdc = "VERR_POLL_HANDLE_ID_EXISTS" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','E','X','I','S','T','S',
/* 0x11bf2 = "VINF_SVM_INTERCEPT_NOT_ACTIVE" */
    '\x0e','S','V','M','_','I','N','T','E','R','C','E','P','T','_','\x06','A','C','T','I','V','E',
/* 0x11c08 = "VINF_EM_EMULATE_SPLIT_LOCK" */
    '\x0e','E','M','_','E','M','U','L','A','T','E','_','S','P','L','I','T','_','L','O','C','K',
/* 0x11c1e = "VERR_CANT_DELETE_DIRECTORY" */
    '\x01','C','A','N','T','_','D','E','L','E','T','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x11c34 = "VERR_INCONSISTENT_VM_HANDLE" */
    '\x01','I','N','C','O','N','S','I','S','T','E','N','T','_','\xcc','_','H','A','N','D','L','E',
/* 0x11c4a = "Unable to switch due to invalid guest state." */
    '\xde','\x0a','s','w','i','t','c','h',' ','d','u','e',' ','\x0a','\x8f','\xbb','s','t','a','t','e','.',
/* 0x11c60 = "Expected a different time tag." */
    '\xb8','a',' ','d','i','f','f','e','r','e','n','t',' ','t','i','m','e',' ','t','a','g','.',
/* 0x11c76 = "Nested paging not active." */
    'N','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x08','a','c','t','i','v','e','.',
/* 0x11c8c = "VERR_CR_KEY_TOO_SHORT_CIPHER_IV" */
    '\x01','\x22','K','E','Y','_','\x1c','S','H','O','R','T','_','C','I','P','H','E','R','_','I','V',
/* 0x11ca2 = "VERR_SUP_VP_EMPTY_REGION_TOO_LARGE" */
    '\x01','\x95','\xbd','E','M','P','T','Y','_','R','E','G','I','O','N','_','\x1c','L','A','R','G','E',
/* 0x11cb8 = "VERR_CPUM_HIDDEN_CS_LOAD_ERROR" */
    '\x01','C','P','U','M','_','H','I','D','D','E','N','_','C','S','_','L','O','A','D','_','\x1a',
/* 0x11cce = "VERR_PROC_NO_ARG_TRANSLATION" */
    '\x01','P','R','O','C','_','\x60','A','R','G','_','T','R','A','N','S','L','A','T','I','O','N',
/* 0x11ce4 = "VERR_VUSB_DEVICE_NOT_ATTACHED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','\x06','A','T','T','A','C','H','E','D',
/* 0x11cfa = "Bad VTG probe descriptor." */
    '\x9d','V','T','G',' ','p','r','o','b','e',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x11d10 = "VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID" */
    '\x01','\x24','\x89','B','O','O','T','_','C','A','T','_','\x91','H','E','A','D','E','R','_','I','D',
/* 0x11d26 = "VERR_VMX_INVALID_VMCS_PTR_TO_START_VM" */
    '\x01','\xe1','\x05','V','M','C','S','_','P','T','R','_','T','O','_','S','T','A','R','T','_','\xcc',
/* 0x11d3c = "VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN" */
    '\x01','\x22','\xb7','C','P','V','_','\xc4','_','K','E','Y','_','C','E','R','T','_','S','I','G','N',
/* 0x11d52 = "VINF_PATM_HC_MMIO_PATCH_WRITE" */
    '\x0e','P','A','T','M','_','H','C','_','\xd2','_','P','A','T','C','H','_','W','R','I','T','E',
/* 0x11d68 = "VERR_ASN1_OBJID_COMPONENT_TOO_BIG" */
    '\x01','\xa1','O','B','J','I','D','_','C','O','M','P','O','N','E','N','T','_','\x1c','B','I','G',
/* 0x11d7e = "I/O ports are already mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x7f','m','a','p','p','e','d','.',
/* 0x11d94 = "VERR_SUP_VP_NO_IMAGE_MAPPING_NAME" */
    '\x01','\x95','\xbd','\x60','I','M','A','G','E','_','M','A','P','P','I','N','G','_','N','A','M','E',
/* 0x11daa = "VERR_CR_X509_CPV_INVALID_POLICY_MAPPING" */
    '\x01','\x22','\xb7','C','P','V','_','\x05','P','O','L','I','C','Y','_','M','A','P','P','I','N','G',
/* 0x11dc0 = "VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS" */
    '\x01','I','O','M','_','\x1c','\xaf','\xd2','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x11dd6 = "Internal ISO maker error: Buffer size." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','B','u','f','f','e','r',' ','s','i','z','e','.',
/* 0x11dec = "VERR_VFS_CHAIN_EXPECTED_SEPARATOR" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','S','E','P','A','R','A','T','O','R',
/* 0x11e02 = "VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS" */
    '\x01','P','A','T','H','_','G','L','O','B','_','\x91','C','H','A','R','_','C','L','A','S','S',
/* 0x11e18 = "VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW" */
    '\x01','\xf2','\xdb','H','A','S','H','_','T','A','B','_','\xfe','_','O','V','E','R','F','L','O','W',
/* 0x11e2e = "VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY" */
    '\x01','\x22','P','K','I','X','_','\x06','R','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x11e44 = "Bad digest length encountered in the table of content." */
    '\x9d','\xd6','l','e','n','g','t','h',' ','\xae','\x0f','\x02','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x11e5a = "The device instance structure version has changed." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','\xea','\xcf','\x7b','c','h','a','n','g','e','d','.',
/* 0x11e70 = "VERR_PDM_INVALID_DRIVER_REGISTRATION" */
    '\x01','\x5e','\x05','D','R','I','V','E','R','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x11e86 = "VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY" */
    '\x01','\x24','B','O','O','T','_','C','A','T','_','E','M','P','T','Y','_','E','N','T','R','Y',
/* 0x11e9c = "VERR_VMX_X86_CR4_VMXE_CLEARED" */
    '\x01','\xe1','X','8','6','_','C','R','4','_','V','M','X','E','_','C','L','E','A','R','E','D',
/* 0x11eb2 = "The MMIO range specified for removal was not found." */
    '\x03','\xd2',' ','r','a','n','g','e',' ','\x18','\x10','r','e','m','o','v','a','l',' ','\x11','\x08','\x88',
/* 0x11ec8 = "Guest side reported an error." */
    'G','u','e','s','t',' ','s','i','d','e',' ','r','e','p','o','r','t','e','d',' ','\x87','\x84',
/* 0x11ede = "VERR_DWARF_STACK_UNDERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','U','N','D','E','R','F','L','O','W',
/* 0x11ef4 = "VERR_GIM_NO_DEBUG_CONNECTION" */
    '\x01','G','I','M','_','\x60','D','E','B','U','G','_','C','O','N','N','E','C','T','I','O','N',
/* 0x11f0a = "Path to child node was invalid (i." */
    'P','a','t','h',' ','\x0a','c','h','i','l','d',' ','n','o','d','e',' ','\x11','\x8f','(','i','.',
/* 0x11f20 = "VMDK: Invalid write position." */
    'V','M','D','K',':',' ','\x0c','w','r','i','t','e',' ','p','o','s','i','t','i','o','n','.',
/* 0x11f36 = "VWRN_ENV_NOT_FULLY_TRANSLATED" */
    '\xe4','E','N','V','_','\x06','F','U','L','L','Y','_','T','R','A','N','S','L','A','T','E','D',
/* 0x11f4c = "Process Verification Failure: Error allocating memory." */
    '\x1e','\x0d','\x12','\xc0','a','l','l','o','c','a','t','i','n','g',' ','m','e','m','o','r','y','.',
/* 0x11f62 = "VINF_IOM_R3_MMIO_COMMIT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd2','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x11f78 = "No attribute of the specified types was found." */
    '\xe6','a','t','t','r','i','b','u','t','e',' ','\x15','\x02','\x18','t','y','p','e','s',' ','\x11','\x88',
/* 0x11f8e = "VERR_CR_MALFORMED_PEM_HEADER" */
    '\x01','\x22','M','A','L','F','O','R','M','E','D','_','P','E','M','_','H','E','A','D','E','R',
/* 0x11fa4 = "Internal processing error related to guest mappings." */
    '\x07','\x04','\x09','r','e','l','a','t','e','d',' ','\x0a','\xbb','m','a','p','p','i','n','g','s','.',
/* 0x11fba = "VERR_CR_SPC_PEIMAGE_NO_CONTENT" */
    '\x01','\x22','S','P','C','_','P','E','I','M','A','G','E','_','\x60','C','O','N','T','E','N','T',
/* 0x11fd0 = "File or directory can\'t be created." */
    'F','i','l','e',' ','\xa9','\x26','c','a','n','\'','t',' ','\xa8','c','r','e','a','t','e','d','.',
/* 0x11fe6 = "Not an integer property." */
    'N','o','t',' ','\x87','i','n','t','e','g','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x11ffc = "VERR_VFS_CHAIN_AT_MOST_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x12012 = "Device i/o: Not ready." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','N','o','t',' ','r','e','a','d','y','.',
/* 0x12028 = "VERR_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x1203e = "VERR_SHCLPB_TRANSFER_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','T','R','A','N','S','F','E','R','_','I','D','_','\x06','\x2a',
/* 0x12054 = "VERR_CPUM_INVALID_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','\x05','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x1206a = "The driver instance structure version has changed." */
    '\x03','\xc5','i','n','s','t','a','n','c','e',' ','\xea','\xcf','\x7b','c','h','a','n','g','e','d','.',
/* 0x12080 = "VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\x95','\xbd','R','E','P','L','A','C','E','_','V','I','R','T','U','A','L','_','\xb6','_','\x16',
/* 0x12096 = "The USB hub is already registered." */
    '\x03','U','S','B',' ','h','u','b',' ','\x0b','\x7f','r','e','g','i','s','t','e','r','e','d','.',
/* 0x120ac = "The value was zero extended to fit." */
    '\x03','\xfa','\x11','z','e','r','o',' ','e','x','t','e','n','d','e','d',' ','\x0a','f','i','t','.',
/* 0x120c2 = "VERR_POLL_HANDLE_NOT_POLLABLE" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','\x06','P','O','L','L','A','B','L','E',
/* 0x120d8 = "VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','R','W','_','\x1c','\xaf','W','R','I','T','E','R','S',
/* 0x120ee = "Invalid executable signature." */
    '\x0c','e','x','e','c','u','t','a','b','l','e',' ','s','i','g','n','a','t','u','r','e','.',
/* 0x12104 = "VERR_PDM_CRITSECTRW_TOO_MANY_READERS" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','R','W','_','\x1c','\xaf','R','E','A','D','E','R','S',
/* 0x1211a = "VERR_HARDAVL_BAD_RIGHT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','R','I','G','H','T','_','H','E','I','G','H','T',
/* 0x12130 = "VERR_SELM_SHADOW_GDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','G','D','T','_','W','R','I','T','E',
/* 0x12146 = "VERR_LDRLX_BAD_LOADER_SECTION" */
    '\x01','L','D','R','L','X','_','\x1d','L','O','A','D','E','R','_','S','E','C','T','I','O','N',
/* 0x1215c = "VINF_VRDP_RESIZE_REQUESTED" */
    '\x0e','V','R','D','P','_','R','E','S','I','Z','E','_','R','E','Q','U','E','S','T','E','D',
/* 0x12172 = "VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x12188 = "VERR_GMM_MODULE_NAME_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','N','A','M','E','_','\x1c','L','O','N','G',
/* 0x1219e = "VERR_TRPM_SHADOW_IDT_WRITE" */
    '\x01','T','R','P','M','_','S','H','A','D','O','W','_','I','D','T','_','W','R','I','T','E',
/* 0x121b4 = "Attempt to divide by zero." */
    'A','t','t','e','m','p','t',' ','\x0a','d','i','v','i','d','e',' ','\xdf','z','e','r','o','.',
/* 0x121ca = "VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES" */
    '\x01','\x90','T','R','A','C','E','R','_','U','M','O','D','_','\x1c','\xaf','P','R','O','B','E','S',
/* 0x121e0 = "VERR_DBGC_PARSE_INVALD_COMMAND_NAME" */
    '\x01','\xfb','\xe2','I','N','V','A','L','D','_','C','O','M','M','A','N','D','_','N','A','M','E',
/* 0x121f6 = "VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED" */
    '\x01','\x95','\xbd','U','N','M','A','P','_','A','N','D','_','P','R','O','T','E','C','T','_','\x16',
/* 0x1220c = "The type of media was not recognized." */
    '\x03','\xf1','\x15','m','e','d','i','a',' ','\x11','\x08','r','e','c','o','g','n','i','z','e','d','.',
/* 0x12222 = "The symbol is not a forwarder." */
    '\x03','s','y','m','b','o','l',' ','\x0b','\x08','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x12238 = "Media not present in drive." */
    'M','e','d','i','a',' ','\x08','p','r','e','s','e','n','t',' ','\x0f','d','r','i','v','e','.',
/* 0x1224e = "VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND" */
    '\x01','\x22','\xe3','S','I','G','N','E','D','_','D','A','T','A','_','C','E','R','T','_','\x06','\x2a',
/* 0x12264 = "The trace log is malformed." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\x0b','m','a','l','f','o','r','m','e','d','.',
/* 0x1227a = "Invalid file mode mask (RTFMODE)." */
    '\x0c','\x1f','m','o','d','e',' ','m','a','s','k',' ','(','R','T','F','M','O','D','E',')','.',
/* 0x12290 = "VINF_EM_HM_PATCH_TPR_INSTR" */
    '\x0e','E','M','_','H','M','_','P','A','T','C','H','_','T','P','R','_','I','N','S','T','R',
/* 0x122a6 = "Failed to lock the address range." */
    '\x8b','\x0a','l','o','c','k',' ','\x02','a','d','d','r','e','s','s',' ','r','a','n','g','e','.',
/* 0x122bc = "Unsupported image target architecture." */
    '\x97','\x25','t','a','r','g','e','t',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x122d2 = "The saved state directory magic is wrong." */
    '\x03','s','a','v','e','d',' ','\xcd','\x26','m','a','g','i','c',' ','\x0b','w','r','o','n','g','.',
/* 0x122e8 = "Wrong JSON type for integer value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf1','\x10','i','n','t','e','g','e','r',' ','\xf3',
/* 0x122fe = "VERR_SSM_LIVE_GURU_MEDITATION" */
    '\x01','\xb0','L','I','V','E','_','G','U','R','U','_','M','E','D','I','T','A','T','I','O','N',
/* 0x12314 = "VINF_THREAD_IS_TERMINATING" */
    '\x0e','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x1232a = "VERR_VD_ASYNC_IO_IN_PROGRESS" */
    '\x01','\xff','A','S','Y','N','C','_','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x12340 = "VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','M','M','I','O','2','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x12356 = "The page to be freed or updated was not found." */
    '\x03','\xcb','\x0a','\xa8','f','r','e','e','d',' ','\xa9','u','p','d','a','t','e','d',' ','\x11','\x08','\x88',
/* 0x1236c = "VERR_IPC_RECEIVE_CANCELLED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','C','A','N','C','E','L','L','E','D',
/* 0x12382 = "VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO" */
    '\x01','H','M','_','\x1b','C','P','U','_','F','E','A','T','U','R','E','_','C','O','M','B','O',
/* 0x12398 = "RTGetOpt: Not an option." */
    'R','T','G','e','t','O','p','t',':',' ','N','o','t',' ','\x87','o','p','t','i','o','n','.',
/* 0x123ae = "No unwind information was found." */
    '\xe6','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x11','\x88',
/* 0x123c4 = "VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS" */
    '\x01','\x22','\xe3','S','I','G','N','E','D','_','D','A','T','A','_','\x60','\xbe','A','L','G','O','S',
/* 0x123da = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2" */
    '\x01','\x90','\x06','B','U','D','D','I','N','G','_','\xcc','_','P','R','O','C','E','S','S','_','2',
/* 0x123f0 = "I/O ports are not mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x08','m','a','p','p','e','d','.',
/* 0x12406 = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1" */
    '\x01','\x90','\x06','B','U','D','D','I','N','G','_','\xcc','_','P','R','O','C','E','S','S','_','1',
/* 0x1241c = "VERR_VUSB_USBFS_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','F','S','_','P','E','R','M','I','S','S','I','O','N',
/* 0x12432 = "The server does not support the requested function." */
    '\x03','s','e','r','v','e','r',' ','\xb2','\x08','\xce','\x02','\xdd','f','u','n','c','t','i','o','n','.',
/* 0x12448 = "VERR_CR_PKIX_SIGNATURE_TOO_LONG" */
    '\x01','\x22','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x1c','L','O','N','G',
/* 0x1245e = "Codec initialization failed." */
    'C','o','d','e','c',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7d',
/* 0x12474 = "VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','F','A','M','I','L','Y','_','\x06','\x82',
/* 0x1248a = "More data available in pipe." */
    'M','o','r','e',' ','\x9c','a','v','a','i','l','a','b','l','e',' ','\x0f','p','i','p','e','.',
/* 0x124a0 = "VERR_VMM_SMAP_BUT_AC_CLEAR" */
    '\x01','V','M','M','_','S','M','A','P','_','B','U','T','_','A','C','_','C','L','E','A','R',
/* 0x124b6 = "VERR_CR_X509_CPV_NAME_NOT_PERMITTED" */
    '\x01','\x22','\xb7','C','P','V','_','N','A','M','E','_','\x06','P','E','R','M','I','T','T','E','D',
/* 0x124cc = "VERR_SELM_SHADOW_LDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','L','D','T','_','W','R','I','T','E',
/* 0x124e2 = "VERR_ASN1_NO_CHECK_SANITY_METHOD" */
    '\x01','\xa1','\x60','C','H','E','C','K','_','S','A','N','I','T','Y','_','M','E','T','H','O','D',
/* 0x124f8 = "VERR_PDM_INVALID_DEVICE_REGISTRATION" */
    '\x01','\x5e','\x05','D','E','V','I','C','E','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x1250e = "VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR" */
    '\x01','\x24','\x89','Z','E','R','O','_','S','I','Z','E','D','_','R','O','O','T','_','D','I','R',
/* 0x12524 = "Async command pending." */
    'A','s','y','n','c',' ','c','o','m','m','a','n','d',' ','p','e','n','d','i','n','g','.',
/* 0x1253a = "VERR_IPE_UNINITIALIZED_STATUS" */
    '\x01','\x14','U','N','I','N','I','T','I','A','L','I','Z','E','D','_','S','T','A','T','U','S',
/* 0x12550 = "VERR_SELM_SHADOW_TSS_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','T','S','S','_','W','R','I','T','E',
/* 0x12566 = "The guest has reported too many modules." */
    '\x03','\xbb','\x7b','r','e','p','o','r','t','e','d',' ','\xa0','\xb4','m','o','d','u','l','e','s','.',
/* 0x1257c = "RTCache: cache is empty." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x0b','e','m','p','t','y','.',
/* 0x12592 = "VERR_PDM_HPET_LEGACY_NOTIFY_MISSING" */
    '\x01','\x5e','H','P','E','T','_','L','E','G','A','C','Y','_','N','O','T','I','F','Y','_','\xc4',
/* 0x125a8 = "Wrong parameter count." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','c','o','u','n','t','.',
/* 0x125be = "VERR_EM_RAW_PATCH_CONFLICT" */
    '\x01','E','M','_','R','A','W','_','P','A','T','C','H','_','C','O','N','F','L','I','C','T',
/* 0x125d4 = "VERR_PDM_NO_REGISTRATION_EXPORT" */
    '\x01','\x5e','\x60','R','E','G','I','S','T','R','A','T','I','O','N','_','E','X','P','O','R','T',
/* 0x125ea = "VINF_EM_RAW_STALE_SELECTOR" */
    '\x0e','E','M','_','R','A','W','_','S','T','A','L','E','_','S','E','L','E','C','T','O','R',
/* 0x12600 = "Can\'t assign requested address." */
    'C','a','n','\'','t',' ','a','s','s','i','g','n',' ','\xdd','a','d','d','r','e','s','s','.',
/* 0x12616 = "VERR_HM_NO_32_TO_64_SWITCHER" */
    '\x01','H','M','_','\x60','3','2','_','T','O','_','6','4','_','S','W','I','T','C','H','E','R',
/* 0x1262c = "VERR_DBGC_COMMANDS_NOT_REGISTERED" */
    '\x01','\xfb','C','O','M','M','A','N','D','S','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x12642 = "Syntax error - unbalanced quotes." */
    '\xf7','\x09','-',' ','u','n','b','a','l','a','n','c','e','d',' ','q','u','o','t','e','s','.',
/* 0x12658 = "The table of content isn\'t valid UTF-8." */
    '\x03','\xb1','\x15','\xed','i','s','n','\'','t',' ','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x1266e = "Library was not initialized." */
    'L','i','b','r','a','r','y',' ','\x11','\x08','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x12684 = "The component factory was not found." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','y',' ','\x11','\x08','\x88',
/* 0x1269a = "VERR_XAR_BAD_CHECKSUM_ELEMENT" */
    '\x01','X','A','R','_','\x1d','C','H','E','C','K','S','U','M','_','E','L','E','M','E','N','T',
/* 0x126b0 = "VERR_REST_RESPONSE_INVALID_UTF8_ENCODING" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','\x05','U','T','F','8','_','\xc6',
/* 0x126c6 = "VERR_GMM_ACTUAL_PAGES_IPE" */
    '\x01','G','M','M','_','A','C','T','U','A','L','_','P','A','G','E','S','_','I','P','E',
/* 0x126db = "Syntax error - expected binary operator." */
    '\xf7','\x09','-',' ','\xc9','b','i','n','a','r','y',' ','o','p','e','r','a','t','o','r','.',
/* 0x126f0 = "VERR_X509_NO_BASIC_CONSTARAINTS" */
    '\x01','\xb7','\x60','B','A','S','I','C','_','C','O','N','S','T','A','R','A','I','N','T','S',
/* 0x12705 = "VERR_GMM_TOO_MANY_GLOBAL_MODULES" */
    '\x01','G','M','M','_','\x1c','\xaf','G','L','O','B','A','L','_','M','O','D','U','L','E','S',
/* 0x1271a = "VERR_IOM_NO_R3_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x60','R','3','_','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x1272f = "Import ISO contains more than volume." */
    '\xc3','\xc1',' ','\x8a','m','o','r','e',' ','t','h','a','n',' ','v','o','l','u','m','e','.',
/* 0x12744 = "VERR_PGM_MAPPINGS_FIX_TOO_SMALL" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','_','\x1c','S','M','A','L','L',
/* 0x12759 = "VERR_VFS_CHAIN_LEADING_SEPARATOR" */
    '\x01','\x8d','_','\x8e','L','E','A','D','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x1276e = "VERR_CR_X509_CPV_NO_TRUSTED_PATHS" */
    '\x01','\x22','\xb7','C','P','V','_','\x60','T','R','U','S','T','E','D','_','P','A','T','H','S',
/* 0x12783 = "VERR_CR_KEY_MISSING_CIPHER_PARAMS" */
    '\x01','\x22','K','E','Y','_','\xc4','_','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x12798 = "VINF_DRIVER_REBOOT_NEEDED" */
    '\x0e','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x127ad = "The iprt loader recognized an a." */
    '\x03','i','p','r','t',' ','\xd8','r','e','c','o','g','n','i','z','e','d',' ','\x87','a','.',
/* 0x127c2 = "VERR_CR_X509_CPV_NOT_VALID_AT_TIME" */
    '\x01','\x22','\xb7','C','P','V','_','\x06','V','A','L','I','D','_','A','T','_','T','I','M','E',
/* 0x127d7 = "VERR_EM_UNEXPECTED_MAPPING_CONFLICT" */
    '\x01','E','M','_','\x86','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x127ec = "VERR_LDRPE_GUARD_CF_STUFF" */
    '\x01','L','D','R','P','E','_','G','U','A','R','D','_','C','F','_','S','T','U','F','F',
/* 0x12801 = "Syntax error - numeric overflow." */
    '\xf7','\x09','-',' ','n','u','m','e','r','i','c',' ','o','v','e','r','f','l','o','w','.',
/* 0x12816 = "Source/destination not found." */
    'S','o','u','r','c','e','/','d','e','s','t','i','n','a','t','i','o','n',' ','\x08','\x88',
/* 0x1282b = "VERR_PGM_NO_HYPERVISOR_ADDRESS" */
    '\x01','\x8c','\x60','H','Y','P','E','R','V','I','S','O','R','_','A','D','D','R','E','S','S',
/* 0x12840 = "VERR_GIM_INVALID_HYPERCALL_INSTR" */
    '\x01','G','I','M','_','\x05','H','Y','P','E','R','C','A','L','L','_','I','N','S','T','R',
/* 0x12855 = "Encountered an unexpected VM state." */
    '\xa5','\x87','u','n','e','x','p','e','c','t','e','d',' ','\xcc',' ','s','t','a','t','e','.',
/* 0x1286a = "VERR_GIM_PVTSC_NOT_AVAILABLE" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1287f = "VERR_VMM_WRONG_HM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','H','M','_','V','M','C','P','U','_','\xef',
/* 0x12894 = "VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','V','I','R','T','U','A','L','_','\xfe',
/* 0x128a9 = "The thread is terminating." */
    '\x03','t','h','r','e','a','d',' ','\x0b','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x128be = "VERR_DRIVER_REBOOT_NEEDED" */
    '\x01','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x128d3 = "VERR_DWARF_STACK_OVERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x128e8 = "VERR_LDRPE_COM_DESCRIPTOR" */
    '\x01','L','D','R','P','E','_','C','O','M','_','D','E','S','C','R','I','P','T','O','R',
/* 0x128fd = "VERR_TCP_SERVER_DESTROYED" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x12912 = "VERR_ISOFS_TOO_BIT_PARTMAP_IN_LVD" */
    '\x01','\xa2','\x1c','B','I','T','_','P','A','R','T','M','A','P','_','I','N','_','L','V','D',
/* 0x12927 = "Too many MMIO registrations." */
    'T','o','o',' ','\xb4','\xd2',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x1293c = "VERR_NET_OUT_OF_RESOURCES" */
    '\x01','N','E','T','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x12951 = "VERR_RESERVED_PAGE_TABLE_BITS" */
    '\x01','R','E','S','E','R','V','E','D','_','\xdb','T','A','B','L','E','_','B','I','T','S',
/* 0x12966 = "Max threads number reached." */
    'M','a','x',' ','t','h','r','e','a','d','s',' ','\xf9','r','e','a','c','h','e','d','.',
/* 0x1297b = "VERR_DBG_ADDRESS_CONFLICT" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x12990 = "VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\x89','\x95','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x129a5 = "Geometry hasn\'t been set." */
    'G','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xca','s','e','t','.',
/* 0x129ba = "VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','M','A','P','_','M','M','I','O','2','_','I','P','E',
/* 0x129cf = "VINF_HGCM_CLIENT_REJECTED" */
    '\x0e','H','G','C','M','_','C','L','I','E','N','T','_','R','E','J','E','C','T','E','D',
/* 0x129e4 = "VERR_VM_DRIVER_NOT_ACCESSIBLE" */
    '\x01','\xcc','_','D','R','I','V','E','R','_','\x06','A','C','C','E','S','S','I','B','L','E',
/* 0x129f9 = "The compressed table of content is too big." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\xb1','\x15','\xed','\x0b','\xa0','b','i','g','.',
/* 0x12a0e = "VERR_GMM_TOO_MANY_CHUNK_MAPPINGS" */
    '\x01','G','M','M','_','\x1c','\xaf','C','H','U','N','K','_','M','A','P','P','I','N','G','S',
/* 0x12a23 = "VERR_SSM_FIELD_OUT_OF_BOUNDS" */
    '\x01','\xb0','F','I','E','L','D','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x12a38 = "VERR_UDP_SERVER_DESTROYED" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x12a4d = "Final OpenSSL PKIX verification failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','\xf6','\x7d',
/* 0x12a62 = "Operation already in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x7f','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x12a77 = "RTCache: cache is full." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x0b','f','u','l','l','.',
/* 0x12a8c = "Process Verification Failure: The memory content does not match the image file." */
    '\x1e','\x0d','\x12','\x03','\x85','\xed','\xb2','\x08','m','a','t','c','h',' ','\x02','\x25','f','i','l','e','.',
/* 0x12aa1 = "Process Verification Failure: Bad virtual section address." */
    '\x1e','\x0d','\x12','\x9d','v','i','r','t','u','a','l',' ','\xda','a','d','d','r','e','s','s','.',
/* 0x12ab6 = "VINF_EM_DBG_HYPER_STEPPED" */
    '\x0e','E','M','_','D','B','G','_','H','Y','P','E','R','_','S','T','E','P','P','E','D',
/* 0X12acb = "Device i/o: Bad command." */
    'e','v','i','c','e',' ','i','/','o',':',' ','\x9d','c','o','m','m','a','n','d','.',
/* 0x12adf = "VERR_AUDIO_BACKEND_INIT_FAILED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','I','N','I','T','_','\x16',
/* 0x12af4 = "VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH" */
    '\x01','\x95','\xbd','E','X','E','_','V','S','_','P','R','O','C','_','N','A','M','E','_','\x19',
/* 0x12b09 = "Incorrect call order." */
    'I','n','c','o','r','r','e','c','t',' ','c','a','l','l',' ','o','r','d','e','r','.',
/* 0x12b1e = "VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE" */
    '\x01','\x95','\xbd','E','X','E','_','\xc4','_','D','Y','N','A','M','I','C','_','B','A','S','E',
/* 0x12b33 = "The signature is negative." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x0b','n','e','g','a','t','i','v','e','.',
/* 0x12b48 = "VERR_TAR_NUM_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','N','U','M','_','V','A','L','U','E','_','\x1c','L','A','R','G','E',
/* 0x12b5d = "VERR_RECORDING_RESTRICTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','R','E','S','T','R','I','C','T','E','D',
/* 0x12b72 = "VERR_LDRPE_CERT_MALFORMED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','M','A','L','F','O','R','M','E','D',
/* 0x12b87 = "VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x12b9c = "VERR_IEM_RESTART_INSTRUCTION" */
    '\x01','\x9b','R','E','S','T','A','R','T','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x12bb1 = "VERR_NO_MORE_SEARCH_HANDLES" */
    '\x01','\x60','M','O','R','E','_','S','E','A','R','C','H','_','H','A','N','D','L','E','S',
/* 0x12bc6 = "VERR_PGM_PHYS_RAM_LOOKUP_IPE" */
    '\x01','\x8c','P','H','Y','S','_','R','A','M','_','L','O','O','K','U','P','_','I','P','E',
/* 0x12bdb = "Failed to obtain a pool page." */
    '\x8b','\x0a','o','b','t','a','i','n',' ','a',' ','p','o','o','l',' ','p','a','g','e','.',
/* 0x12bf0 = "Reason for leaving RZ: I/O port read." */
    '\x93','\x10','\x81','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','r','e','a','d','.',
/* 0x12c05 = "Recompiler: Bad segment register number for memory access." */
    '\x13','\x9d','s','e','g','m','e','n','t',' ','\xe9','\xf9','\x10','\x85','a','c','c','e','s','s','.',
/* 0x12c1a = "VFS chain element expected at least three arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','t','h','r','e','e',' ','\xdc',
/* 0x12c2f = "VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','T','W','O','_','A','R','G','S',
/* 0x12c44 = "VERR_SERIALPORT_INVALID_BAUDRATE" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','\x05','B','A','U','D','R','A','T','E',
/* 0x12c59 = "The file or directory is world writable (hardening)." */
    '\x03','\x1f','\xa9','\x26','\x0b','w','o','r','l','d',' ','w','r','i','t','a','b','l','e',' ','\xad',
/* 0x12c6e = "VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3" */
    '\x01','\x24','\xab','\x1c','B','I','G','_','R','E','Q','_','\xc1','_','L','E','V','E','L','_','3',
/* 0x12c83 = "Bad file group id for XAR file." */
    '\x9d','\x1f','g','r','o','u','p',' ','i','d',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x12c98 = "VERR_CODE_POINT_SURROGATE" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','S','U','R','R','O','G','A','T','E',
/* 0x12cad = "VERR_DBGF_READ_ONLY_REGISTER" */
    '\x01','\xb9','_','R','E','A','D','_','O','N','L','Y','_','R','E','G','I','S','T','E','R',
/* 0x12cc2 = "Current object state prohibits operation." */
    'C','u','r','r','e','n','t',' ','\xa7','\xcd','p','r','o','h','i','b','i','t','s',' ','\xe8',
/* 0x12cd7 = "Wrong parameter type." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','t','y','p','e','.',
/* 0x12cec = "Shadow mode \'none\' internal error." */
    'S','h','a','d','o','w',' ','m','o','d','e',' ','\'','n','o','n','e','\'',' ','\x17','\x84',
/* 0x12d01 = "VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL" */
    '\x01','\xa1','C','O','N','S','T','R','U','C','T','E','D','_','\xd4','_','\x06','I','M','P','L',
/* 0x12d16 = "VINF_PARAV_SWITCH_TO_HOST" */
    '\x0e','P','A','R','A','V','_','S','W','I','T','C','H','_','T','O','_','H','O','S','T',
/* 0x12d2b = "Wrong JSON type for double value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf1','\x10','d','o','u','b','l','e',' ','\xf3',
/* 0x12d40 = "VERR_IOM_MMIO_REGION_NOT_MAPPED" */
    '\x01','I','O','M','_','\xd2','_','R','E','G','I','O','N','_','\x06','M','A','P','P','E','D',
/* 0x12d55 = "Import ISO contains a too deep directory subtree." */
    '\xc3','\xc1',' ','\x8a','a',' ','\xa0','d','e','e','p',' ','\x26','s','u','b','t','r','e','e','.',
/* 0x12d6a = "VERR_DBG_DUPLICATE_SYMBOL" */
    '\x01','D','B','G','_','D','U','P','L','I','C','A','T','E','_','S','Y','M','B','O','L',
/* 0x12d7f = "VERR_IEM_ASPECT_NOT_IMPLEMENTED" */
    '\x01','\x9b','A','S','P','E','C','T','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x12d94 = "VINF_CPUM_MATCHED_BY_NAME" */
    '\x0e','C','P','U','M','_','M','A','T','C','H','E','D','_','B','Y','_','N','A','M','E',
/* 0x12da9 = "Cannot block in ring-0." */
    'C','a','n','n','o','t',' ','b','l','o','c','k',' ','\x0f','r','i','n','g','-','0','.',
/* 0x12dbe = "VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING" */
    '\x01','\xa1','\x05','G','E','N','E','R','A','L','I','Z','E','D','_','T','I','M','E','_','\xc6',
/* 0x12dd3 = "Internal SPC error: The PE image data is missing." */
    '\x07','S','P','C',' ','\xd7','\x03','P','E',' ','\x25','\x9c','\x0b','m','i','s','s','i','n','g','.',
/* 0x12de8 = "Device i/o: Sector not found." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','S','e','c','t','o','r',' ','\x08','\x88',
/* 0x12dfd = "VERR_SYS_CANNOT_POWER_OFF" */
    '\x01','S','Y','S','_','C','A','N','N','O','T','_','P','O','W','E','R','_','O','F','F',
/* 0x12e12 = "VERR_PGM_PHYS_WR_HIT_HANDLER" */
    '\x01','\x8c','P','H','Y','S','_','W','R','_','H','I','T','_','H','A','N','D','L','E','R',
/* 0x12e27 = "Process Verification Failure: Error closing image file handle." */
    '\x1e','\x0d','\x12','\xc0','c','l','o','s','i','n','g',' ','\x25','\x1f','h','a','n','d','l','e','.',
/* 0x12e3c = "VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x12e51 = "VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX" */
    '\x01','\x90','K','E','R','N','E','L','_','\x1c','O','L','D','_','F','O','R','_','V','T','X',
/* 0x12e66 = "Reason for leaving RZ: Timer pending." */
    '\x93','\x10','\x81','R','Z',':',' ','T','i','m','e','r',' ','p','e','n','d','i','n','g','.',
/* 0x12e7b = "A module name is too long." */
    'A',' ','m','o','d','u','l','e',' ','n','a','m','e',' ','\x0b','\xa0','l','o','n','g','.',
/* 0x12e90 = "VERR_XAR_MISSING_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x12ea5 = "VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT" */
    '\x01','\x8d','_','\x8e','\x1c','S','H','O','R','T','_','F','O','R','_','P','A','R','E','N','T',
/* 0x12eba = "VERR_CR_SPC_BAD_MONIKER_CHOICE" */
    '\x01','\x22','S','P','C','_','\x1d','M','O','N','I','K','E','R','_','C','H','O','I','C','E',
/* 0x12ecf = "VERR_SUPDRV_TRACER_SESSION_BUSY" */
    '\x01','\x90','T','R','A','C','E','R','_','S','E','S','S','I','O','N','_','B','U','S','Y',
/* 0x12ee4 = "VERR_HTTP_COULDNT_CONNECT" */
    '\x01','H','T','T','P','_','C','O','U','L','D','N','T','_','C','O','N','N','E','C','T',
/* 0x12ef9 = "Process Verification Failure: Error reading image file header." */
    '\x1e','\x0d','\x12','\xc0','r','e','a','d','i','n','g',' ','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x12f0e = "VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH" */
    '\x01','\x22','\xe3','C','O','N','T','E','N','T','_','\xb5','_','A','T','T','R','I','B','_','\x19',
/* 0x12f23 = "VERR_LDRELF_RELOCATION_NOT_SUPPORTED" */
    '\x01','L','D','R','E','L','F','_','R','E','L','O','C','A','T','I','O','N','_','\x06','\x82',
/* 0x12f38 = "VERR_LDRLX_BAD_FIXUP_SECTION" */
    '\x01','L','D','R','L','X','_','\x1d','F','I','X','U','P','_','S','E','C','T','I','O','N',
/* 0x12f4d = "VERR_GMM_SHARED_MODULE_NOT_FOUND" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x06','\x2a',
/* 0x12f62 = "The configured driver wasn\'t found." */
    '\x03','c','o','n','f','i','g','u','r','e','d',' ','\xc5','w','a','s','n','\'','t',' ','\x88',
/* 0x12f77 = "VERR_LDR_ADDRESS_OVERFLOW" */
    '\x01','L','D','R','_','A','D','D','R','E','S','S','_','O','V','E','R','F','L','O','W',
/* 0x12f8c = "VERR_XAR_EXTRACTED_HASH_MISMATCH" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','H','A','S','H','_','\x19',
/* 0x12fa1 = "VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','N','M','_','\x1a',
/* 0x12fb6 = "VERR_DBGC_PARSE_EXPECTED_BINARY_OP" */
    '\x01','\xfb','\xe2','E','X','P','E','C','T','E','D','_','B','I','N','A','R','Y','_','O','P',
/* 0x12fcb = "VERR_HARDAVL_BAD_LEFT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','L','E','F','T','_','H','E','I','G','H','T',
/* 0x12fe0 = "VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','S','I','X','_','A','R','G','S',
/* 0x12ff5 = "VERR_HARDAVL_NODE_IS_FREE" */
    '\x01','H','A','R','D','A','V','L','_','N','O','D','E','_','I','S','_','F','R','E','E',
/* 0x1300a = "VERR_PATH_MATCH_UNKNOWN_VARIABLE" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','\x91','V','A','R','I','A','B','L','E',
/* 0x1301f = "Bad timestamp for XAR file." */
    '\x9d','t','i','m','e','s','t','a','m','p',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x13034 = "Not implemented for UDF." */
    'N','o','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x10','U','D','F','.',
/* 0x13049 = "Address translation failed." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x7d',
/* 0x1305e = "VERR_ISOFS_NO_DIRECT_ICB_ENTRIES" */
    '\x01','\xa2','\x60','D','I','R','E','C','T','_','I','C','B','_','E','N','T','R','I','E','S',
/* 0x13073 = "No free output streams." */
    '\xe6','f','r','e','e',' ','o','u','t','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x13088 = "Can\'t delete directory with files." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','\x26','\x80','f','i','l','e','s','.',
/* 0x1309d = "Internal ISO maker error: Empty path." */
    '\x07','\xc1',' ','m','a','k','e','r',' ','\xd7','E','m','p','t','y',' ','p','a','t','h','.',
/* 0x130b2 = "VERR_FTP_DATA_CONN_INIT_FAILED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','I','N','I','T','_','\x16',
/* 0x130c7 = "Preemption is disabled." */
    'P','r','e','e','m','p','t','i','o','n',' ','\x0b','d','i','s','a','b','l','e','d','.',
/* 0x130dc = "No data for this block in image." */
    '\xe6','\x9c','\x10','t','h','i','s',' ','b','l','o','c','k',' ','\x0f','i','m','a','g','e','.',
/* 0x130f1 = "Saved state directory wintertides error." */
    'S','a','v','e','d',' ','\xcd','\x26','w','i','n','t','e','r','t','i','d','e','s',' ','\x84',
/* 0x13106 = "VERR_LDRELF_INVALID_SYMBOL_INDEX" */
    '\x01','L','D','R','E','L','F','_','\x05','S','Y','M','B','O','L','_','I','N','D','E','X',
/* 0x1311b = "VERR_NET_HOST_UNREACHABLE" */
    '\x01','N','E','T','_','H','O','S','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x13130 = "VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY" */
    '\x01','\xf2','\x05','S','E','C','U','R','I','T','Y','_','D','I','R','_','E','N','T','R','Y',
/* 0x13145 = "Object or array is empty." */
    'O','b','j','e','c','t',' ','\xa9','a','r','r','a','y',' ','\x0b','e','m','p','t','y','.',
/* 0x1315a = "One of the structure magics was wrong." */
    'O','n','e',' ','\x15','\x02','\xea','m','a','g','i','c','s',' ','\x11','w','r','o','n','g','.',
/* 0x1316f = "Out of selector bounds." */
    'O','u','t',' ','\x15','s','e','l','e','c','t','o','r',' ','b','o','u','n','d','s','.',
/* 0x13184 = "VERR_PGM_PHYS_TLB_UNASSIGNED" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','U','N','A','S','S','I','G','N','E','D',
/* 0x13199 = "VERR_CR_X509_NAME_EMPTY_SUB_SET" */
    '\x01','\x22','\xb7','N','A','M','E','_','E','M','P','T','Y','_','S','U','B','_','S','E','T',
/* 0x131ae = "VERR_GMM_BAD_SHARED_MODULE_SIZE" */
    '\x01','G','M','M','_','\x1d','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xfe',
/* 0x131c3 = "VERR_CANT_RECODE_AS_UTF16" */
    '\x01','C','A','N','T','_','R','E','C','O','D','E','_','A','S','_','U','T','F','1','6',
/* 0x131d8 = "VERR_SUP_VP_STUB_THREAD_OPEN_ERROR" */
    '\x01','\x95','\xbd','S','T','U','B','_','T','H','R','E','A','D','_','O','P','E','N','_','\x1a',
/* 0x131ed = "VERR_LDR_FORWARDER_CHAIN_TOO_LONG" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','_','\x8e','\x1c','L','O','N','G',
/* 0x13202 = "VERR_PDM_ASYNC_TEMPLATE_BUSY" */
    '\x01','\x5e','A','S','Y','N','C','_','T','E','M','P','L','A','T','E','_','B','U','S','Y',
/* 0x13217 = "Invalid GC physical address." */
    '\x0c','G','C',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x1322c = "Expected a right parentheses." */
    '\xb8','a',' ','r','i','g','h','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x13241 = "VERR_SVM_ILLEGAL_EFER_MSR" */
    '\x01','S','V','M','_','I','L','L','E','G','A','L','_','E','F','E','R','_','M','S','R',
/* 0x13256 = "VERR_VMX_UNDEFINED_EXIT_CODE" */
    '\x01','\xe1','U','N','D','E','F','I','N','E','D','_','E','X','I','T','_','C','O','D','E',
/* 0x1326b = "Process Verification Failure: The process is being debugged." */
    '\x1e','\x0d','\x12','\x03','\x92','\x0b','b','e','i','n','g',' ','d','e','b','u','g','g','e','d','.',
/* 0x13280 = "VERR_VRDP_SEC_ENGINE_FAIL" */
    '\x01','V','R','D','P','_','S','E','C','_','E','N','G','I','N','E','_','F','A','I','L',
/* 0x13295 = "Generic audio device enumeration error." */
    '\xa6','a','u','d','i','o',' ','\xa3','e','n','u','m','e','r','a','t','i','o','n',' ','\x84',
/* 0x132aa = "Certificate signature algorithm mismatch." */
    '\xba','s','i','g','n','a','t','u','r','e',' ','\xd3','m','i','s','m','a','t','c','h','.',
/* 0x132bf = "VINF_PATM_HC_MMIO_PATCH_READ" */
    '\x0e','P','A','T','M','_','H','C','_','\xd2','_','P','A','T','C','H','_','R','E','A','D',
/* 0x132d4 = "Unknown partition map entry type." */
    '\xf8','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xc8','t','y','p','e','.',
/* 0x132e9 = "VERR_IOMMU_ADDR_ACCESS_DENIED" */
    '\x01','\xfc','_','A','D','D','R','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x132fe = "No direct ICB entries found." */
    '\xe6','d','i','r','e','c','t',' ','I','C','B',' ','e','n','t','r','i','e','s',' ','\x88',
/* 0x13313 = "VERR_GMM_HIT_GLOBAL_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','G','L','O','B','A','L','_','L','I','M','I','T',
/* 0x13328 = "VERR_HTTP_STATUS_SERVER_ERROR" */
    '\x01','H','T','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x1a',
/* 0x1333d = "VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE" */
    '\x01','\x24','B','O','O','T','_','C','A','T','_','\x05','S','E','C','T','I','O','N','_','\xfe',
/* 0x13352 = "HTTP initialization failed." */
    'H','T','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7d',
/* 0x13367 = "Too long name string." */
    'T','o','o',' ','l','o','n','g',' ','n','a','m','e',' ','s','t','r','i','n','g','.',
/* 0x1337c = "A page count is out of range." */
    'A',' ','\xcb','c','o','u','n','t',' ','\x0b','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x13391 = "VINF_DBGF_TRUNCATED_REGISTER" */
    '\x0e','\xb9','_','T','R','U','N','C','A','T','E','D','_','R','E','G','I','S','T','E','R',
/* 0x133a6 = "VERR_SUP_VP_UNDESIRABLE_MODULE" */
    '\x01','\x95','\xbd','U','N','D','E','S','I','R','A','B','L','E','_','M','O','D','U','L','E',
/* 0x133bb = "VERR_IOMMU_ADDR_TRANSLATION_FAILED" */
    '\x01','\xfc','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','\x16',
/* 0x133d0 = "VERR_IOM_MMIO_REGION_ALREADY_MAPPED" */
    '\x01','I','O','M','_','\xd2','_','R','E','G','I','O','N','_','\x9a','M','A','P','P','E','D',
/* 0X133e5 = "Duplicate certificate extension." */
    'u','p','l','i','c','a','t','e',' ','\x9e','e','x','t','e','n','s','i','o','n','.',
/* 0x133f9 = "VERR_VM_REQUEST_TOO_MANY_ARGS_IPE" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','\x1c','\xaf','A','R','G','S','_','I','P','E',
/* 0x1340e = "VERR_EM_CANNOT_EXEC_GUEST" */
    '\x01','E','M','_','C','A','N','N','O','T','_','E','X','E','C','_','G','U','E','S','T',
/* 0x13423 = "Network is unreachable." */
    'N','e','t','w','o','r','k',' ','\x0b','u','n','r','e','a','c','h','a','b','l','e','.',
/* 0x13438 = "VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB" */
    '\x01','\x22','\xe3','\xc4','_','C','O','N','T','E','N','T','_','\xb5','_','A','T','T','R','I','B',
/* 0x1344d = "Virtual HDD is not opened." */
    'V','i','r','t','u','a','l',' ','H','D','D',' ','\x0b','\x08','o','p','e','n','e','d','.',
/* 0x13462 = "VERR_IEM_COND_TOO_DEEPLY_NESTED" */
    '\x01','\x9b','C','O','N','D','_','\x1c','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x13477 = "VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO" */
    '\x01','\x24','\x89','R','O','O','T','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x1348c = "VERR_XAR_MISSING_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x134a1 = "VINF_PGM_NO_DIRTY_BIT_TRACKING" */
    '\x0e','\x8c','\x60','D','I','R','T','Y','_','B','I','T','_','T','R','A','C','K','I','N','G',
/* 0x134b6 = "VINF_EM_RAW_TIMER_PENDING" */
    '\x0e','E','M','_','R','A','W','_','T','I','M','E','R','_','P','E','N','D','I','N','G',
/* 0x134cb = "Reason for leaving RZ: Unknown call to ring-3." */
    '\x93','\x10','\x81','R','Z',':',' ','\xf8','c','a','l','l',' ','\x0a','r','i','n','g','-','3','.',
/* 0x134e0 = "VERR_IOM_MMIO_RANGE_CONFLICT" */
    '\x01','I','O','M','_','\xd2','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x134f5 = "VERR_TAR_DEV_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','D','E','V','_','V','A','L','U','E','_','\x1c','L','A','R','G','E',
/* 0x1350a = "VERR_ISOFS_TOO_DEEP_ICB_RECURSION" */
    '\x01','\xa2','\x1c','D','E','E','P','_','I','C','B','_','R','E','C','U','R','S','I','O','N',
/* 0x1351f = "VERR_PAGE_MAP_LEVEL4_NOT_PRESENT" */
    '\x01','\xdb','M','A','P','_','L','E','V','E','L','4','_','\x06','P','R','E','S','E','N','T',
/* 0x13534 = "VERR_HARDAVL_LOOKUP_TOO_DEEP" */
    '\x01','H','A','R','D','A','V','L','_','L','O','O','K','U','P','_','\x1c','D','E','E','P',
/* 0x13549 = "VERR_SUPLIB_WRITE_NON_SYS_GROUP" */
    '\x01','\xd5','W','R','I','T','E','_','N','O','N','_','S','Y','S','_','G','R','O','U','P',
/* 0x1355e = "VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE" */
    '\x01','\x8c','\x1b','S','H','A','D','O','W','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x13573 = "The driver instance could not be found." */
    '\x03','\xc5','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x08','\xa8','\x88',
/* 0x13587 = "VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x06','M','U','L','T','I','P','L','E',
/* 0x1359b = "Protocol not available." */
    'P','r','o','t','o','c','o','l',' ','\x08','a','v','a','i','l','a','b','l','e','.',
/* 0x135af = "The driver helper structure version has changed." */
    '\x03','\xc5','h','e','l','p','e','r',' ','\xea','\xcf','\x7b','c','h','a','n','g','e','d','.',
/* 0x135c3 = "VERR_PROC_TCB_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','T','C','B','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x135d7 = "VERR_LDRVI_BAD_CERT_HDR_REVISION" */
    '\x01','\xf2','\x1d','C','E','R','T','_','H','D','R','_','R','E','V','I','S','I','O','N',
/* 0x135eb = "Too many symbolic links." */
    'T','o','o',' ','\xb4','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','.',
/* 0x135ff = "Internal processing error #3 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x13613 = "VERR_VGA_GL_LOAD_FAILURE" */
    '\x01','V','G','A','_','G','L','_','L','O','A','D','_','F','A','I','L','U','R','E',
/* 0x13627 = "VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1c','\xaf','P','R','O','V','I','D','E','R','S',
/* 0x1363b = "The bucket/key wasn\'t found." */
    '\x03','b','u','c','k','e','t','/','k','e','y',' ','w','a','s','n','\'','t',' ','\x88',
/* 0x1364f = "VERR_GMM_ALLOC_PAGES_IPE" */
    '\x01','G','M','M','_','A','L','L','O','C','_','P','A','G','E','S','_','I','P','E',
/* 0x13663 = "VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\x22','\xe3','\xc4','_','M','E','S','S','A','G','E','_','\xbe','A','T','T','R','I','B',
/* 0x13677 = "Unable to start VM execution." */
    '\xde','\x0a','s','t','a','r','t',' ','\xcc',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x1368b = "VERR_CR_X509_PUBLIC_KEY_TOO_SMALL" */
    '\x01','\x22','\xb7','P','U','B','L','I','C','_','K','E','Y','_','\x1c','S','M','A','L','L',
/* 0x1369f = "VERR_HARDAVL_UNEXPECTED_NULL_RIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x86','N','U','L','L','_','R','I','G','H','T',
/* 0x136b3 = "VFS chain element expected at most three arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','m','o','s','t',' ','t','h','r','e','e',' ','\xdc',
/* 0x136c7 = "VERR_SSM_NO_PENDING_OPERATION" */
    '\x01','\xb0','\x60','P','E','N','D','I','N','G','_','O','P','E','R','A','T','I','O','N',
/* 0x136db = "VERR_IOM_IOPORTS_NOT_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x06','M','A','P','P','E','D',
/* 0x136ef = "Process Verification Failure: Bad optional header field." */
    '\x1e','\x0d','\x12','\x9d','o','p','t','i','o','n','a','l',' ','\xb3','f','i','e','l','d','.',
/* 0x13703 = "The I/O request ID is already existing." */
    '\x03','I','/','O',' ','\xaa','I','D',' ','\x0b','\x7f','e','x','i','s','t','i','n','g','.',
/* 0x13717 = "VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER" */
    '\x01','\x9b','E','M','I','T','_','\x86','V','A','R','_','R','E','G','I','S','T','E','R',
/* 0x1372b = "The object in question already exists." */
    '\x03','\xa7','\x0f','q','u','e','s','t','i','o','n',' ','\x7f','e','x','i','s','t','s','.',
/* 0x1373f = "Bad file user id for XAR file." */
    '\x9d','\x1f','u','s','e','r',' ','i','d',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x13753 = "VERR_LDRPE_LOAD_CONFIG_SIZE" */
    '\x01','L','D','R','P','E','_','L','O','A','D','_','C','O','N','F','I','G','_','\xfe',
/* 0x13767 = "VINF_DBGF_R3_BP_OWNER_DEFER" */
    '\x0e','\xb9','_','R','3','_','B','P','_','O','W','N','E','R','_','D','E','F','E','R',
/* 0X1377b = "Reserved page table bits set." */
    'e','s','e','r','v','e','d',' ','\xcb','\xb1','b','i','t','s',' ','s','e','t','.',
/* 0x1378e = "VERR_SUPDRV_TRACER_ALREADY_REGISTERED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x9a','R','E','G','I','S','T','E','R','E','D',
/* 0x137a2 = "VERR_PDM_BLOCK_UNKNOWN_TRANSLATION" */
    '\x01','\x5e','B','L','O','C','K','_','\x91','T','R','A','N','S','L','A','T','I','O','N',
/* 0x137b6 = "VERR_SVM_VMRUN_PRECOND_3" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','3',
/* 0x137ca = "VERR_SVM_VMRUN_PRECOND_1" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','1',
/* 0x137de = "VERR_SVM_VMRUN_PRECOND_0" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','0',
/* 0x137f2 = "VERR_SVM_VMRUN_PRECOND_2" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','2',
/* 0x13806 = "Image hash mismatch." */
    'I','m','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x1381a = "VERR_TM_TIMER_UNSTABLE_STATE" */
    '\x01','T','M','_','T','I','M','E','R','_','U','N','S','T','A','B','L','E','_','\xef',
/* 0x1382e = "VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS" */
    '\x01','\x22','K','E','Y','_','\x86','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x13842 = "VINF_CSAM_PENDING_ACTION" */
    '\x0e','C','S','A','M','_','P','E','N','D','I','N','G','_','A','C','T','I','O','N',
/* 0x13856 = "VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS" */
    '\x01','\xa2','\x1c','\xaf','I','C','B','_','I','N','D','I','R','E','C','T','I','O','N','S',
/* 0x1386a = "Missing data element for XAR file." */
    'M','i','s','s','i','n','g',' ','\x9c','\x5c','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x1387e = "VERR_LDRLX_BAD_OBJECT_TABLE" */
    '\x01','L','D','R','L','X','_','\x1d','O','B','J','E','C','T','_','T','A','B','L','E',
/* 0x13892 = "VERR_ISOMK_IPE_PRODUCE_TRANS_TBL" */
    '\x01','\x24','\x14','P','R','O','D','U','C','E','_','T','R','A','N','S','_','T','B','L',
/* 0x138a6 = "VERR_XAR_BAD_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\x1d','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x138ba = "Internal processing error #6 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','6',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x138ce = "VERR_PAGE_COUNT_OUT_OF_RANGE" */
    '\x01','\xdb','C','O','U','N','T','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x138e2 = "VERR_PDM_DEVICE_INSTANCE_NOT_FOUND" */
    '\x01','\x5e','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x06','\x2a',
/* 0x138f6 = "The specified thread is not waitable." */
    '\x03','\x18','t','h','r','e','a','d',' ','\x0b','\x08','w','a','i','t','a','b','l','e','.',
/* 0x1390a = "VERR_IPC_RECEIVE_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','T','I','M','E','O','U','T',
/* 0x1391e = "VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT" */
    '\x01','\x95','\xbd','\x86','V','A','L','I','D','_','P','A','T','H','_','C','O','U','N','T',
/* 0x13932 = "VERR_PDM_DRIVER_INSTANCE_NOT_FOUND" */
    '\x01','\x5e','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','_','\x06','\x2a',
/* 0x13946 = "VERR_COM_DONT_CALL_AGAIN" */
    '\x01','C','O','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x1395a = "VERR_VMM_WRONG_NEM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','\xec','_','V','M','C','P','U','_','\xef',
/* 0x1396e = "VERR_PDM_INVALID_DEVICE_GUEST_BITS" */
    '\x01','\x5e','\x05','D','E','V','I','C','E','_','G','U','E','S','T','_','B','I','T','S',
/* 0x13982 = "VINF_IPC_RECEIVE_MSG_CUT" */
    '\x0e','I','P','C','_','R','E','C','E','I','V','E','_','M','S','G','_','C','U','T',
/* 0x13996 = "No conflicts to resolve." */
    '\xe6','c','o','n','f','l','i','c','t','s',' ','\x0a','r','e','s','o','l','v','e','.',
/* 0x139aa = "VERR_ISOFS_BAD_LVD_DESC_CHAR_SET" */
    '\x01','\xa2','\x1d','L','V','D','_','D','E','S','C','_','C','H','A','R','_','S','E','T',
/* 0x139be = "VERR_VFS_CHAIN_AT_MOST_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','T','W','O','_','A','R','G','S',
/* 0x139d2 = "Device i/o: Bad length." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9d','l','e','n','g','t','h','.',
/* 0x139e6 = "VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC" */
    '\x01','\x24','\x89','\x1d','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C',
/* 0x139fa = "VERR_INCOMPATIBLE_CONFIG" */
    '\x01','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x13a0e = "The device helper structure version has changed." */
    '\x03','\xa3','h','e','l','p','e','r',' ','\xea','\xcf','\x7b','c','h','a','n','g','e','d','.',
/* 0x13a22 = "Internal processing error #2 in the PDM Thread code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x83',
/* 0x13a36 = "VINF_PATCH_EMULATE_INSTR" */
    '\x0e','P','A','T','C','H','_','E','M','U','L','A','T','E','_','I','N','S','T','R',
/* 0x13a4a = "Recompiler: Unimplemented case." */
    '\x13','U','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','a','s','e','.',
/* 0x13a5e = "VERR_VSCSI_LUN_NOT_ATTACHED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\x06','A','T','T','A','C','H','E','D',
/* 0x13a72 = "Spinlock detection failed." */
    'S','p','i','n','l','o','c','k',' ','d','e','t','e','c','t','i','o','n',' ','\x7d',
/* 0x13a86 = "Internal processing error #2 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x13a9a = "Syntax error - invalid operator usage." */
    '\xf7','\x09','-',' ','\x8f','o','p','e','r','a','t','o','r',' ','u','s','a','g','e','.',
/* 0x13aae = "VERR_PROC_APT_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','A','P','T','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x13ac2 = "VERR_DBG_INVALID_SEGMENT_OFFSET" */
    '\x01','D','B','G','_','\x05','S','E','G','M','E','N','T','_','O','F','F','S','E','T',
/* 0x13ad6 = "VERR_SUPDRV_VTG_BAD_PROBE_ENABLED" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','B','E','_','E','N','A','B','L','E','D',
/* 0x13aea = "VERR_ASN1_EXPECTED_PRIMITIVE" */
    '\x01','\xa1','E','X','P','E','C','T','E','D','_','P','R','I','M','I','T','I','V','E',
/* 0x13afe = "VERR_VFS_CHAIN_AT_LEAST_ONE_ARG" */
    '\x01','\x8d','_','\x8e','A','T','_','L','E','A','S','T','_','O','N','E','_','A','R','G',
/* 0x13b12 = "VERR_SSM_FIELD_NOT_CONSECUTIVE" */
    '\x01','\xb0','F','I','E','L','D','_','\x06','C','O','N','S','E','C','U','T','I','V','E',
/* 0x13b26 = "VERR_VUSB_DEVICE_NAME_NOT_FOUND" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','N','A','M','E','_','\x06','\x2a',
/* 0x13b3a = "VERR_CPUM_INVALID_HWVIRT_CONFIG" */
    '\x01','C','P','U','M','_','\x05','H','W','V','I','R','T','_','C','O','N','F','I','G',
/* 0x13b4e = "VERR_TCP_SERVER_SHUTDOWN" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x13b62 = "VERR_PGM_PHYS_TLB_CATCH_ALL" */
    '\x01','\x8c','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','A','L','L',
/* 0x13b76 = "VERR_CR_CIPHER_INVALID_KEY_LENGTH" */
    '\x01','\x22','C','I','P','H','E','R','_','\x05','K','E','Y','_','L','E','N','G','T','H',
/* 0x13b8a = "VERR_XAR_HASH_FUNCTION_MISMATCH" */
    '\x01','X','A','R','_','H','A','S','H','_','F','U','N','C','T','I','O','N','_','\x19',
/* 0x13b9e = "Unsupported ISO protocol feature." */
    '\x97','\xc1',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x13bb2 = "VERR_RECORDING_THROTTLED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x13bc6 = "Internal processing error #8 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','8',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x13bda = "VFS chain element expected at least four arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','f','o','u','r',' ','\xdc',
/* 0x13bee = "VERR_FTP_STATUS_SERVER_ERROR" */
    '\x01','F','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x1a',
/* 0x13c02 = "VERR_AUDIO_ENUMERATION_FAILED" */
    '\x01','A','U','D','I','O','_','E','N','U','M','E','R','A','T','I','O','N','_','\x16',
/* 0x13c16 = "VERR_PDM_TOO_MANY_DEVICE_INSTANCES" */
    '\x01','\x5e','\x1c','\xaf','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x13c2a = "Expected a left parentheses." */
    '\xb8','a',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x13c3e = "EVP_DecryptInit_ex failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t','_','e','x',' ','\x7d',
/* 0x13c52 = "VERR_GVMM_HOST_CPU_RANGE" */
    '\x01','G','V','M','M','_','H','O','S','T','_','C','P','U','_','R','A','N','G','E',
/* 0x13c66 = "Requested image is not opened." */
    'R','e','q','u','e','s','t','e','d',' ','\x25','\x0b','\x08','o','p','e','n','e','d','.',
/* 0x13c7a = "VERR_SUP_VP_NO_KERNEL32_MAPPING" */
    '\x01','\x95','\xbd','\x60','K','E','R','N','E','L','3','2','_','M','A','P','P','I','N','G',
/* 0x13c8e = "VERR_CR_KEY_DEK_INFO_TOO_LONG" */
    '\x01','\x22','K','E','Y','_','D','E','K','_','I','N','F','O','_','\x1c','L','O','N','G',
/* 0x13ca2 = "VERR_TAR_BAD_NUM_FIELD_TERM" */
    '\x01','T','A','R','_','\x1d','N','U','M','_','F','I','E','L','D','_','T','E','R','M',
/* 0x13cb6 = "VERR_UDP_SERVER_SHUTDOWN" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x13cca = "VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE" */
    '\x01','\x95','\xbd','\x06','K','N','O','W','N','_','D','L','L','_','O','R','_','E','X','E',
/* 0x13cde = "VERR_RECORDING_FORMAT_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','F','O','R','M','A','T','_','\x06','\x82',
/* 0x13cf2 = "Reason for leaving RC: Double Fault." */
    '\x93','\x10','\x81','R','C',':',' ','D','o','u','b','l','e',' ','F','a','u','l','t','.',
/* 0x13d06 = "Internal processing error #5 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','5',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x13d1a = "Request was redirected." */
    'R','e','q','u','e','s','t',' ','\x11','r','e','d','i','r','e','c','t','e','d','.',
/* 0x13d2e = "VERR_VM_DRIVER_NOT_INSTALLED" */
    '\x01','\xcc','_','D','R','I','V','E','R','_','\x06','I','N','S','T','A','L','L','E','D',
/* 0x13d42 = "VINF_PGM_POOL_FLUSH_PENDING" */
    '\x0e','\x8c','P','O','O','L','_','F','L','U','S','H','_','P','E','N','D','I','N','G',
/* 0x13d56 = "Unexpected SVM exception exit." */
    '\x94','S','V','M',' ','e','x','c','e','p','t','i','o','n',' ','e','x','i','t','.',
/* 0x13d6a = "Internal processing error #9 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','9',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x13d7e = "VERR_VFS_CHAIN_AT_MOST_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','S','I','X','_','A','R','G','S',
/* 0x13d92 = "VERR_VUSB_FAILED_TO_QUEUE_URB" */
    '\x01','V','U','S','B','_','\x16','_','T','O','_','Q','U','E','U','E','_','U','R','B',
/* 0x13da6 = "VERR_IOM_IOPORTS_ALREADY_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x9a','M','A','P','P','E','D',
/* 0x13dba = "VERR_XAR_BAD_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\x1d','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x13dce = "Reason for leaving RZ: MMIO read/write." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd2',' ','r','e','a','d','/','w','r','i','t','e','.',
/* 0x13de2 = "VERR_PDM_DRIVER_INVALID_PROPERTIES" */
    '\x01','\x5e','D','R','I','V','E','R','_','\x05','P','R','O','P','E','R','T','I','E','S',
/* 0x13df6 = "VINF_RECORDING_THROTTLED" */
    '\x0e','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x13e0a = "VERR_SSM_VOTE_FOR_GIVING_UP" */
    '\x01','\xb0','V','O','T','E','_','F','O','R','_','G','I','V','I','N','G','_','U','P',
/* 0x13e1e = "The certificate path has no trust anchor." */
    '\x03','\x9e','\xd0','\x7b','n','o',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x13e32 = "VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB" */
    '\x01','\x22','\xe3','\x1d','C','O','N','T','E','N','T','_','\xb5','_','A','T','T','R','I','B',
/* 0x13e46 = "VERR_APIC_INTR_DISCARDED" */
    '\x01','A','P','I','C','_','I','N','T','R','_','D','I','S','C','A','R','D','E','D',
/* 0x13e5a = "FTP initialization failed." */
    'F','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x7d',
/* 0x13e6e = "VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH" */
    '\x01','\x22','\xe3','M','E','S','S','A','G','E','_','\xbe','A','T','T','R','I','B','_','\x19',
/* 0x13e82 = "VERR_PDM_TOO_MANY_DRIVER_INSTANCES" */
    '\x01','\x5e','\x1c','\xaf','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','S',
/* 0x13e96 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','\xb6','_','\x1a',
/* 0x13eaa = "VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\x5e','D','R','V','I','N','S','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x13ebe = "The current operation was canceled." */
    '\x03','c','u','r','r','e','n','t',' ','\x96','\x11','c','a','n','c','e','l','e','d','.',
/* 0x13ed2 = "VERR_IOMMU_INTR_REMAP_DENIED" */
    '\x01','\xfc','_','I','N','T','R','_','R','E','M','A','P','_','D','E','N','I','E','D',
/* 0x13ee6 = "VERR_DBG_SPECIAL_SEGMENT" */
    '\x01','D','B','G','_','S','P','E','C','I','A','L','_','S','E','G','M','E','N','T',
/* 0x13efa = "VERR_VD_PASSWORD_INCORRECT" */
    '\x01','\xff','P','A','S','S','W','O','R','D','_','I','N','C','O','R','R','E','C','T',
/* 0X13f0e = "Trailing characters." */
    'r','a','i','l','i','n','g',' ','c','h','a','r','a','c','t','e','r','s','.',
/* 0x13f21 = "The HGCM is saving state." */
    '\x03','H','G','C','M',' ','\x0b','s','a','v','i','n','g',' ','s','t','a','t','e','.',
/* 0x13f35 = "NtQueryObject/Type failed." */
    'N','t','Q','u','e','r','y','O','b','j','e','c','t','/','T','y','p','e',' ','\x7d',
/* 0x13f49 = "A GMM sanity check failed." */
    'A',' ','G','M','M',' ','s','a','n','i','t','y',' ','c','h','e','c','k',' ','\x7d',
/* 0x13f5d = "VERR_SUPDRV_TRACER_NOT_REGISTERED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','R','E','G','I','S','T','E','R','E','D',
/* 0x13f71 = "VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE" */
    '\x01','\x95','\xbd','\x1d','\xab','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x13f85 = "Internal processing error #4 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x13f99 = "VERR_HGCM_TOO_MANY_CLIENT_CALLS" */
    '\x01','H','G','C','M','_','\x1c','\xaf','C','L','I','E','N','T','_','C','A','L','L','S',
/* 0x13fad = "VINF_IOM_R3_MMIO_READ_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd2','_','R','E','A','D','_','W','R','I','T','E',
/* 0x13fc1 = "VERR_DBG_NOT_LINUX_KALLSYMS" */
    '\x01','D','B','G','_','\x06','L','I','N','U','X','_','K','A','L','L','S','Y','M','S',
/* 0x13fd5 = "Expected an element separator (| or :)." */
    '\xb8','\x87','\x5c','s','e','p','a','r','a','t','o','r',' ','(','|',' ','\xa9',':',')','.',
/* 0x13fe9 = "VFS chain element expected at least five arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','f','i','v','e',' ','\xdc',
/* 0x13ffd = "VERR_HGCM_SERVICE_EXISTS" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','E','X','I','S','T','S',
/* 0x14011 = "VERR_ASN1_OBJID_TOO_MANY_COMPONENTS" */
    '\x01','\xa1','O','B','J','I','D','_','\x1c','\xaf','C','O','M','P','O','N','E','N','T','S',
/* 0x14025 = "VERR_VMM_RING0_ASSERTION" */
    '\x01','V','M','M','_','R','I','N','G','0','_','A','S','S','E','R','T','I','O','N',
/* 0x14039 = "Bad DWARF line number header." */
    '\x9d','D','W','A','R','F',' ','l','i','n','e',' ','\xf9','h','e','a','d','e','r','.',
/* 0x1404d = "Already initialized." */
    'A','l','r','e','a','d','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x14061 = "VERR_PGM_INVALID_GC_PHYSICAL_RANGE" */
    '\x01','\x8c','\x05','G','C','_','P','H','Y','S','I','C','A','L','_','R','A','N','G','E',
/* 0x14075 = "URL not expected in SPC PE image data." */
    'U','R','L',' ','\x08','\xc9','\x0f','S','P','C',' ','P','E',' ','\x25','d','a','t','a','.',
/* 0x14089 = "VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND" */
    '\x01','\x5e','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','\x06','\x2a',
/* 0x1409d = "VERR_LDR_GENERAL_FAILURE" */
    '\x01','L','D','R','_','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x140b1 = "VERR_DBGC_PARSE_ARGUMENT_OVERFLOW" */
    '\x01','\xfb','\xe2','A','R','G','U','M','E','N','T','_','O','V','E','R','F','L','O','W',
/* 0x140c5 = "VINF_IOM_R3_IOPORT_WRITE" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x140d9 = "VERR_ASN1_OBJID_TOO_LONG_STRING_FORM" */
    '\x01','\xa1','O','B','J','I','D','_','\x1c','L','O','N','G','_','\xd4','_','F','O','R','M',
/* 0x140ed = "Reached the end of the file." */
    'R','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x15','\x02','f','i','l','e','.',
/* 0x14101 = "VERR_FAM_CONNECTION_LOST" */
    '\x01','F','A','M','_','C','O','N','N','E','C','T','I','O','N','_','L','O','S','T',
/* 0x14115 = "VERR_XAR_ARCHIVED_HASH_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','H','A','S','H','_','\x19',
/* 0x14129 = "VERR_HARDAVL_BAD_NEW_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','N','E','W','_','H','E','I','G','H','T',
/* 0x1413d = "VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x14151 = "VERR_DBG_DEFERRED_LOAD_FAILED" */
    '\x01','D','B','G','_','D','E','F','E','R','R','E','D','_','L','O','A','D','_','\x16',
/* 0x14165 = "VERR_IEM_INSTR_BUF_OUT_OF_MEMORY" */
    '\x01','\x9b','I','N','S','T','R','_','B','U','F','_','O','U','T','_','O','F','_','\xb6',
/* 0x14179 = "VERR_NS_SYMLINK_SET_TIME" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','S','E','T','_','T','I','M','E',
/* 0x1418d = "VERR_CR_CIPHER_INVALID_TAG_LENGTH" */
    '\x01','\x22','C','I','P','H','E','R','_','\x05','T','A','G','_','L','E','N','G','T','H',
/* 0x141a1 = "Failed to allocate VM memory." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','\xcc',' ','m','e','m','o','r','y','.',
/* 0x141b5 = "VINF_PGM_HANDLER_DO_DEFAULT" */
    '\x0e','\x8c','H','A','N','D','L','E','R','_','D','O','_','D','E','F','A','U','L','T',
/* 0x141c9 = "VERR_GMM_TOO_MANY_PER_VM_MODULES" */
    '\x01','G','M','M','_','\x1c','\xaf','P','E','R','_','\xcc','_','M','O','D','U','L','E','S',
/* 0x141dd = "Generic hypercall operation failure." */
    '\xa6','h','y','p','e','r','c','a','l','l',' ','\x96','f','a','i','l','u','r','e','.',
/* 0x141f1 = "Duplicate something." */
    'D','u','p','l','i','c','a','t','e',' ','s','o','m','e','t','h','i','n','g','.',
/* 0x14205 = "Internal processing error #1 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x14219 = "Cipher algorithm is not known to us." */
    'C','i','p','h','e','r',' ','\xd3','\x0b','\x08','k','n','o','w','n',' ','\x0a','u','s','.',
/* 0x1422d = "VINF_VRDP_THREAD_STARTED" */
    '\x0e','V','R','D','P','_','T','H','R','E','A','D','_','S','T','A','R','T','E','D',
/* 0x14241 = "VERR_IPC_RECEIVE_ABORTED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','A','B','O','R','T','E','D',
/* 0x14255 = "Bad file inode device number for XAR file." */
    '\x9d','\x1f','i','n','o','d','e',' ','\xa3','\xf9','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14269 = "VERR_AUDIO_STREAM_NOT_READY" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','\x06','R','E','A','D','Y',
/* 0x1427d = "Internal processing error #7 in the DBGF breakpoint manager code." */
    '\x07','\x04','\x09','#','7',' ','\x0f','\x02','\xb9',' ','\xbf','m','a','n','a','g','e','r',' ','\x83',
/* 0x14291 = "VERR_IOM_IOPORT_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x142a5 = "Operation in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x142b9 = "Internal processing error #1 in the PDM Thread code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x83',
/* 0x142cd = "No free input streams." */
    '\xe6','f','r','e','e',' ','i','n','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x142e1 = "VWRN_RECORDING_ENCODING_SKIPPED" */
    '\xe4','R','E','C','O','R','D','I','N','G','_','\xc6','_','S','K','I','P','P','E','D',
/* 0x142f5 = "VERR_VFS_CHAIN_EXPECTED_ELEMENT" */
    '\x01','\x8d','_','\x8e','E','X','P','E','C','T','E','D','_','E','L','E','M','E','N','T',
/* 0x14309 = "VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\x5e','D','E','V','I','N','S','_','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x1431d = "VERR_CR_X509_CPV_NO_VALID_POLICY" */
    '\x01','\x22','\xb7','C','P','V','_','\x60','V','A','L','I','D','_','P','O','L','I','C','Y',
/* 0x14331 = "VERR_PCI_PASSTHROUGH_NO_HM" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\x60','H','M',
/* 0x14345 = "VERR_RT_REQUEST_INVALID_PACKAGE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x05','P','A','C','K','A','G','E',
/* 0x14359 = "VERR_FILE_AIO_LIMIT_EXCEEDED" */
    '\x01','\xab','A','I','O','_','L','I','M','I','T','_','E','X','C','E','E','D','E','D',
/* 0x1436d = "Invalid timer queue number." */
    '\x0c','t','i','m','e','r',' ','q','u','e','u','e',' ','n','u','m','b','e','r','.',
/* 0x14381 = "VERR_IEM_INSTR_NOT_IMPLEMENTED" */
    '\x01','\x9b','I','N','S','T','R','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x14395 = "VERR_BIGNUM_DIV_BY_ZERO" */
    '\x01','B','I','G','N','U','M','_','D','I','V','_','B','Y','_','Z','E','R','O',
/* 0x143a8 = "Generic: Invalid image file header." */
    'G','e','n','e','r','i','c',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x143bb = "VERR_ASN1_CURSOR_NO_MORE_DATA" */
    '\x01','\xa1','C','U','R','S','O','R','_','\x60','M','O','R','E','_','D','A','T','A',
/* 0x143ce = "VINF_VD_ASYNC_IO_FINISHED" */
    '\x0e','\xff','A','S','Y','N','C','_','I','O','_','F','I','N','I','S','H','E','D',
/* 0x143e1 = "Bad left right height." */
    '\x9d','l','e','f','t',' ','r','i','g','h','t',' ','h','e','i','g','h','t','.',
/* 0x143f4 = "Undesirable module." */
    'U','n','d','e','s','i','r','a','b','l','e',' ','m','o','d','u','l','e','.',
/* 0x14407 = "VINF_PATM_PATCH_TRAP_PF" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','P','F',
/* 0x1441a = "Memory allocation failed." */
    'M','e','m','o','r','y',' ','a','l','l','o','c','a','t','i','o','n',' ','\x7d',
/* 0x1442d = "VERR_PDM_MODULE_NAME_TOO_LONG" */
    '\x01','\x5e','M','O','D','U','L','E','_','N','A','M','E','_','\x1c','L','O','N','G',
/* 0x14440 = "Syntax error - a type conversion failed." */
    '\xf7','\x09','-',' ','a',' ','\xf1','c','o','n','v','e','r','s','i','o','n',' ','\x7d',
/* 0x14453 = "EVP_EncryptUpdate failed." */
    'E','V','P','_','E','n','c','r','y','p','t','U','p','d','a','t','e',' ','\x7d',
/* 0x14466 = "VERR_PGM_MAPPINGS_DISABLED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','D','I','S','A','B','L','E','D',
/* 0x14479 = "VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','U','N','C','O','M','P','_','\xfe','_','\x19',
/* 0x1448c = "VERR_DBG_INVALID_SEGMENT_INDEX" */
    '\x01','D','B','G','_','\x05','S','E','G','M','E','N','T','_','I','N','D','E','X',
/* 0x1449f = "VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE" */
    '\x01','\x8c','\x1b','H','O','S','T','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x144b2 = "Failed to stat a file/dir (hardening)." */
    '\x8b','\x0a','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','\xad',
/* 0x144c5 = "VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED" */
    '\x01','\xe1','M','S','R','_','S','M','X','_','\xe1','E','N','A','B','L','E','_','\x16',
/* 0x144d8 = "Wrong JSON type for bool value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf1','\x10','b','o','o','l',' ','\xf3',
/* 0x144eb = "VERR_CR_SPC_BAD_MONIKER_UUID" */
    '\x01','\x22','S','P','C','_','\x1d','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x144fe = "A signal is already pending." */
    'A',' ','s','i','g','n','a','l',' ','\x0b','\x7f','p','e','n','d','i','n','g','.',
/* 0x14511 = "IOCtl to VBoxGuest driver failed." */
    'I','O','C','t','l',' ','\x0a','V','B','o','x','G','u','e','s','t',' ','\xc5','\x7d',
/* 0x14524 = "Import ISO contains a bad volume descriptor header." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','\xd1','\xee','h','e','a','d','e','r','.',
/* 0x14537 = "Invalid value for cVirtualTicking." */
    '\x0c','\xfa','\x10','c','V','i','r','t','u','a','l','T','i','c','k','i','n','g','.',
/* 0x1454a = "VERR_SUP_VP_IMAGE_HDR_READ_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','H','D','R','_','R','E','A','D','_','\x1a',
/* 0x1455d = "VERR_SUP_VP_BAD_IMAGE_SIGNATURE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','S','I','G','N','A','T','U','R','E',
/* 0x14570 = "VERR_VD_RAW_SIZE_MODULO_2048" */
    '\x01','\xff','R','A','W','_','\xfe','_','M','O','D','U','L','O','_','2','0','4','8',
/* 0x14583 = "A path parameter was not set." */
    'A',' ','\xd0','p','a','r','a','m','e','t','e','r',' ','\x11','\x08','s','e','t','.',
/* 0x14596 = "VFS chain element expected at most four arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','m','o','s','t',' ','f','o','u','r',' ','\xdc',
/* 0x145a9 = "VERR_VRDP_ISO_UNSUPPORTED" */
    '\x01','V','R','D','P','_','\xc1','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x145bc = "VERR_SSM_LOW_ON_DISK_SPACE" */
    '\x01','\xb0','L','O','W','_','O','N','_','D','I','S','K','_','S','P','A','C','E',
/* 0x145cf = "TM does not support the GIP version." */
    'T','M',' ','\xb2','\x08','\xce','\x02','G','I','P',' ','v','e','r','s','i','o','n','.',
/* 0x145e2 = "Invalid GC physical range." */
    '\x0c','G','C',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e','.',
/* 0x145f5 = "Page hash mismatch." */
    'P','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x14608 = "VERR_SSM_IDE_ASYNC_TIMEOUT" */
    '\x01','\xb0','I','D','E','_','A','S','Y','N','C','_','T','I','M','E','O','U','T',
/* 0x1461b = "VINF_VMX_VMLAUNCH_VMRESUME" */
    '\x0e','\xe1','V','M','L','A','U','N','C','H','_','V','M','R','E','S','U','M','E',
/* 0x1462e = "VERR_ASN1_DYNTYPE_TAG_NOT_IMPL" */
    '\x01','\xa1','D','Y','N','T','Y','P','E','_','T','A','G','_','\x06','I','M','P','L',
/* 0x14641 = "VERR_NAT_REDIR_GUEST_IP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','G','U','E','S','T','_','I','P',
/* 0X14654 = "Pagetable not present." */
    'a','g','e','t','a','b','l','e',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x14666 = "VERR_VM_REQUEST_INVALID_PACKAGE" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','\x05','P','A','C','K','A','G','E',
/* 0x14679 = "VERR_CR_KEY_ALGO_PARAMS_MISSING" */
    '\x01','\x22','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\xc4',
/* 0x1468c = "VERR_GVM_MISMATCH_VM_STRUCT_VER" */
    '\x01','G','V','M','_','\x19','_','\xcc','_','S','T','R','U','C','T','_','V','E','R',
/* 0x1469f = "Path not verified yet." */
    'P','a','t','h',' ','\x08','v','e','r','i','f','i','e','d',' ','y','e','t','.',
/* 0x146b2 = "VERR_VD_PARALLELS_INVALID_HEADER" */
    '\x01','\xff','P','A','R','A','L','L','E','L','S','_','\x05','H','E','A','D','E','R',
/* 0x146c5 = "Socket is already connected." */
    'S','o','c','k','e','t',' ','\x0b','\x7f','c','o','n','n','e','c','t','e','d','.',
/* 0x146d8 = "Interface is unknown." */
    'I','n','t','e','r','f','a','c','e',' ','\x0b','u','n','k','n','o','w','n','.',
/* 0x146eb = "VERR_CR_X509_VALIDITY_SWAPPED" */
    '\x01','\x22','\xb7','V','A','L','I','D','I','T','Y','_','S','W','A','P','P','E','D',
/* 0x146fe = "VERR_HARDAVL_UNBALANCED" */
    '\x01','H','A','R','D','A','V','L','_','U','N','B','A','L','A','N','C','E','D',
/* 0x14711 = "VERR_DBG_UNWIND_INFO_NOT_FOUND" */
    '\x01','D','B','G','_','U','N','W','I','N','D','_','I','N','F','O','_','\x06','\x2a',
/* 0x14724 = "Vote for another pass." */
    'V','o','t','e',' ','\x10','a','n','o','t','h','e','r',' ','p','a','s','s','.',
/* 0x14737 = "VERR_ISOFS_FSD_ZERO_ROOT_DIR" */
    '\x01','\xa2','F','S','D','_','Z','E','R','O','_','R','O','O','T','_','D','I','R',
/* 0x1474a = "Unsupported firmware property." */
    '\x97','f','i','r','m','w','a','r','e',' ','p','r','o','p','e','r','t','y','.',
/* 0x1475d = "VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH" */
    '\x01','\x22','\xb7','C','E','R','T','_','S','I','G','N','_','A','L','G','O','_','\x19',
/* 0x14770 = "VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR" */
    '\x01','\x22','\xbe','O','S','S','L','_','\xbe','C','T','X','_','C','O','P','Y','_','\x1a',
/* 0x14783 = "VERR_PDM_MODULE_NAME_CLASH" */
    '\x01','\x5e','M','O','D','U','L','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x14796 = "Too many components in an ASN." */
    'T','o','o',' ','\xb4','c','o','m','p','o','n','e','n','t','s',' ','\x0f','\x87','\xf4',
/* 0x147a9 = "Compromised digest." */
    'C','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x147bc = "VERR_VMX_STARTVM_PRECOND_3" */
    '\x01','\xe1','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','3',
/* 0x147cf = "VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED" */
    '\x01','\x22','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x06','\x82',
/* 0x147e2 = "VERR_TAR_EOS_MORE_INPUT" */
    '\x01','T','A','R','_','E','O','S','_','M','O','R','E','_','I','N','P','U','T',
/* 0x147f5 = "Something is missing." */
    'S','o','m','e','t','h','i','n','g',' ','\x0b','m','i','s','s','i','n','g','.',
/* 0x14808 = "The tracer is unloading." */
    '\x03','t','r','a','c','e','r',' ','\x0b','u','n','l','o','a','d','i','n','g','.',
/* 0x1481b = "VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST" */
    '\x01','\x22','\xe3','\xbe','A','L','G','O','_','\x06','\x2a','_','I','N','_','L','I','S','T',
/* 0x1482e = "VERR_IOMMU_CANNOT_CALL_SELF" */
    '\x01','\xfc','_','C','A','N','N','O','T','_','C','A','L','L','_','S','E','L','F',
/* 0x14841 = "VERR_PDM_INVALID_USB_REGISTRATION" */
    '\x01','\x5e','\x05','U','S','B','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x14854 = "OpenSSL d2i_PKCS7 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','P','K','C','S','7',' ','\x7d',
/* 0x14867 = "Data size overflow." */
    'D','a','t','a',' ','s','i','z','e',' ','o','v','e','r','f','l','o','w','.',
/* 0x1487a = "VERR_VMX_UNABLE_TO_START_VM" */
    '\x01','\xe1','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xcc',
/* 0x1488d = "Central directory file header corrupt." */
    'C','e','n','t','r','a','l',' ','\x26','\x1f','\xb3','c','o','r','r','u','p','t','.',
/* 0x148a0 = "VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE" */
    '\x01','\xa2','\x91','P','A','R','T','_','M','A','P','_','E','N','T','R','Y','_','\xb5',
/* 0x148b3 = "The host kernel is too old." */
    '\x03','h','o','s','t',' ','k','e','r','n','e','l',' ','\x0b','\xa0','o','l','d','.',
/* 0x148c6 = "EVP_DecryptUpdate failed." */
    'E','V','P','_','D','e','c','r','y','p','t','U','p','d','a','t','e',' ','\x7d',
/* 0x148d9 = "Socket is not connected." */
    'S','o','c','k','e','t',' ','\x0b','\x08','c','o','n','n','e','c','t','e','d','.',
/* 0x148ec = "Connection refused." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','.',
/* 0x148ff = "Public key is too small." */
    'P','u','b','l','i','c',' ','k','e','y',' ','\x0b','\xa0','s','m','a','l','l','.',
/* 0x14912 = "No valid TSS present." */
    '\xe6','v','a','l','i','d',' ','T','S','S',' ','p','r','e','s','e','n','t','.',
/* 0x14925 = "VERR_IPC_SEND_CANCELLED" */
    '\x01','I','P','C','_','S','E','N','D','_','C','A','N','C','E','L','L','E','D',
/* 0x14938 = "No pending interrupt." */
    '\xe6','p','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x1494b = "VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS" */
    '\x01','\xd5','P','A','T','H','_','\x1c','\xaf','C','O','M','P','O','N','E','N','T','S',
/* 0x1495e = "VERR_NET_ADDRESS_IN_USE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','I','N','_','U','S','E',
/* 0x14971 = "VWRN_CSAM_TRAP_NOT_HANDLED" */
    '\xe4','C','S','A','M','_','T','R','A','P','_','\x06','H','A','N','D','L','E','D',
/* 0x14984 = "VERR_VRDP_ACCESS_DENIED" */
    '\x01','V','R','D','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x14997 = "VERR_PDM_INVALID_DEVICE_HOST_BITS" */
    '\x01','\x5e','\x05','D','E','V','I','C','E','_','H','O','S','T','_','B','I','T','S',
/* 0x149aa = "VERR_PDM_DRIVER_NO_RT_ATTACH" */
    '\x01','\x5e','D','R','I','V','E','R','_','\x60','R','T','_','A','T','T','A','C','H',
/* 0x149bd = "VERR_SUP_VP_NON_SYSTEM32_DLL" */
    '\x01','\x95','\xbd','N','O','N','_','S','Y','S','T','E','M','3','2','_','D','L','L',
/* 0x149d0 = "VERR_FILESYSTEM_CORRUPT" */
    '\x01','F','I','L','E','S','Y','S','T','E','M','_','C','O','R','R','U','P','T',
/* 0x149e3 = "VERR_VMX_STARTVM_PRECOND_1" */
    '\x01','\xe1','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','1',
/* 0x149f6 = "VERR_VMX_STARTVM_PRECOND_0" */
    '\x01','\xe1','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','0',
/* 0x14a09 = "VERR_VMX_STARTVM_PRECOND_2" */
    '\x01','\xe1','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','2',
/* 0x14a1c = "Bad PCI configuration." */
    '\x9d','P','C','I',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x14a2f = "VERR_CR_KEY_ALGO_PARAMS_MISMATCH" */
    '\x01','\x22','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\x19',
/* 0x14a42 = "VERR_WEB_NOT_AUTHENTICATED" */
    '\x01','W','E','B','_','\x06','A','U','T','H','E','N','T','I','C','A','T','E','D',
/* 0x14a55 = "Generic object destroyed status." */
    '\xa6','\xa7','d','e','s','t','r','o','y','e','d',' ','s','t','a','t','u','s','.',
/* 0x14a68 = "VERR_HARDAVL_UNEXPECTED_NULL_LEFT" */
    '\x01','H','A','R','D','A','V','L','_','\x86','N','U','L','L','_','L','E','F','T',
/* 0x14a7b = "Unknown SPC object moniker UUID." */
    '\xf8','S','P','C',' ','\xa7','m','o','n','i','k','e','r',' ','U','U','I','D','.',
/* 0x14a8e = "VINF_HGCM_ASYNC_EXECUTE" */
    '\x0e','H','G','C','M','_','A','S','Y','N','C','_','E','X','E','C','U','T','E',
/* 0x14aa1 = "VERR_CPUM_UNSUPPORTED_ID_REG_VALUE" */
    '\x01','C','P','U','M','_','\x1b','I','D','_','R','E','G','_','V','A','L','U','E',
/* 0x14ab4 = "VERR_LDRPE_DELAY_IMPORT" */
    '\x01','L','D','R','P','E','_','D','E','L','A','Y','_','I','M','P','O','R','T',
/* 0x14ac7 = "VERR_PDM_INVALID_DRIVER_HOST_BITS" */
    '\x01','\x5e','\x05','D','R','I','V','E','R','_','H','O','S','T','_','B','I','T','S',
/* 0x14ada = "VERR_DBG_CFG_NOT_UINT_PROP" */
    '\x01','D','B','G','_','C','F','G','_','\x06','U','I','N','T','_','P','R','O','P',
/* 0x14aed = "VINF_VMX_MODIFIES_BEHAVIOR" */
    '\x0e','\xe1','M','O','D','I','F','I','E','S','_','B','E','H','A','V','I','O','R',
/* 0x14b00 = "Expected ECDSA private key." */
    '\xb8','E','C','D','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x14b13 = "VINF_CR_KEY_WAS_DECRYPTED" */
    '\x0e','\x22','K','E','Y','_','W','A','S','_','D','E','C','R','Y','P','T','E','D',
/* 0x14b26 = "VERR_IOM_NOT_MMIO_RANGE_OWNER" */
    '\x01','I','O','M','_','\x06','\xd2','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x14b39 = "VERR_INTNET_FLT_IF_BUSY" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','B','U','S','Y',
/* 0x14b4c = "VERR_VD_CACHE_NOT_UP_TO_DATE" */
    '\x01','\xff','C','A','C','H','E','_','\x06','U','P','_','T','O','_','D','A','T','E',
/* 0x14b5f = "VINF_UDP_SERVER_NO_CLIENT" */
    '\x0e','U','D','P','_','S','E','R','V','E','R','_','\x60','C','L','I','E','N','T',
/* 0x14b72 = "Certificate path validator: No trusted certificate paths." */
    '\xba','\xd0','\xfd','\xe6','t','r','u','s','t','e','d',' ','\x9e','p','a','t','h','s','.',
/* 0x14b85 = "Is a symbolic link." */
    'I','s',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x14b98 = "Saved state header integrity error." */
    'S','a','v','e','d',' ','\xcd','\xb3','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x14bab = "VERR_HM_SUSPEND_PENDING" */
    '\x01','H','M','_','S','U','S','P','E','N','D','_','P','E','N','D','I','N','G',
/* 0x14bbe = "VERR_PROC_IQ_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','I','Q','_','P','R','I','V','_','\x06','H','E','L','D',
/* 0x14bd1 = "VERR_VFS_CHAIN_AT_MOST_ONE_ARG" */
    '\x01','\x8d','_','\x8e','A','T','_','M','O','S','T','_','O','N','E','_','A','R','G',
/* 0x14be4 = "VERR_SUP_VP_TOO_HIGH_REGION_RVA" */
    '\x01','\x95','\xbd','\x1c','H','I','G','H','_','R','E','G','I','O','N','_','R','V','A',
/* 0x14bf7 = "VERR_SHCLPB_EVENT_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','I','D','_','\x06','\x2a',
/* 0x14c0a = "VERR_XAR_UNSUPPORTED_HASH_FUNCTION" */
    '\x01','X','A','R','_','\x1b','H','A','S','H','_','F','U','N','C','T','I','O','N',
/* 0x14c1d = "VERR_SUPDRV_TRACER_BAD_ARG_FLAGS" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1d','A','R','G','_','F','L','A','G','S',
/* 0x14c30 = "VERR_PDM_CFG_MISSING_DRIVER_NAME" */
    '\x01','\x5e','C','F','G','_','\xc4','_','D','R','I','V','E','R','_','N','A','M','E',
/* 0x14c43 = "VERR_RECORDING_CODEC_NOT_FOUND" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x06','\x2a',
/* 0x14c56 = "VERR_PDM_MISSING_INTERFACE_BELOW" */
    '\x01','\x5e','\xc4','_','I','N','T','E','R','F','A','C','E','_','B','E','L','O','W',
/* 0x14c69 = "VERR_LDRMACHO_NON_CONT_SEG_BITS" */
    '\x01','\xe7','N','O','N','_','C','O','N','T','_','S','E','G','_','B','I','T','S',
/* 0x14c7c = "VERR_CPUM_INVALID_CONFIG_VALUE" */
    '\x01','C','P','U','M','_','\x05','C','O','N','F','I','G','_','V','A','L','U','E',
/* 0x14c8f = "VERR_IOM_IOPORT_UNKNOWN_OPCODE" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x91','O','P','C','O','D','E',
/* 0x14ca2 = "VERR_PGM_MAP_MMIO2_ALIAS_MMIO" */
    '\x01','\x8c','M','A','P','_','M','M','I','O','2','_','A','L','I','A','S','_','\xd2',
/* 0x14cb5 = "Bad file inode number for XAR file." */
    '\x9d','\x1f','i','n','o','d','e',' ','\xf9','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x14cc8 = "Process Verification Failure: An image has too many sections." */
    '\x1e','\x0d','\x12','A','n',' ','\x25','\x7b','\xa0','\xb4','s','e','c','t','i','o','n','s','.',
/* 0x14cdb = "VINF_VRDP_OUTPUT_ENABLE" */
    '\x0e','V','R','D','P','_','O','U','T','P','U','T','_','E','N','A','B','L','E',
/* 0x14cee = "VFS chain element expected at least six arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','s','i','x',' ','\xdc',
/* 0x14d01 = "VERR_APIC_INTR_NOT_PENDING" */
    '\x01','A','P','I','C','_','I','N','T','R','_','\x06','P','E','N','D','I','N','G',
/* 0x14d14 = "VINF_PATM_PATCH_TRAP_GP" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','G','P',
/* 0x14d27 = "VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE" */
    '\x01','T','A','R','_','\x1b','S','O','L','A','R','I','S','_','H','D','R','_','\xb5',
/* 0x14d3a = "VERR_CFGM_NOT_ENOUGH_SPACE" */
    '\x01','C','F','G','M','_','\x06','E','N','O','U','G','H','_','S','P','A','C','E',
/* 0x14d4d = "VINF_TCP_SERVER_NO_CLIENT" */
    '\x0e','T','C','P','_','S','E','R','V','E','R','_','\x60','C','L','I','E','N','T',
/* 0x14d60 = "Warning, the state changed." */
    'W','a','r','n','i','n','g',',',' ','\x02','\xcd','c','h','a','n','g','e','d','.',
/* 0x14d73 = "VINF_VMX_INTERCEPT_NOT_ACTIVE" */
    '\x0e','\xe1','I','N','T','E','R','C','E','P','T','_','\x06','A','C','T','I','V','E',
/* 0x14d86 = "The requested allocation is too big." */
    '\x03','\xdd','a','l','l','o','c','a','t','i','o','n',' ','\x0b','\xa0','b','i','g','.',
/* 0x14d99 = "VERR_XAR_MISSING_DATA_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','D','A','T','A','_','E','L','E','M','E','N','T',
/* 0x14dac = "Failed to generate RSA key." */
    '\x8b','\x0a','g','e','n','e','r','a','t','e',' ','R','S','A',' ','k','e','y','.',
/* 0x14dbf = "VERR_VD_VDI_COMMENT_TOO_LONG" */
    '\x01','\xff','V','D','I','_','C','O','M','M','E','N','T','_','\x1c','L','O','N','G',
/* 0x14dd2 = "The specified MMIO range was invalid." */
    '\x03','\x18','\xd2',' ','r','a','n','g','e',' ','\x11','i','n','v','a','l','i','d','.',
/* 0x14de5 = "VFS chain element expected at least two arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','l','e','a','s','t',' ','t','w','o',' ','\xdc',
/* 0x14df8 = "VERR_IOM_INVALID_IOPORT_HANDLE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','H','A','N','D','L','E',
/* 0x14e0b = "VERR_HTTP_SSL_CONNECT_ERROR" */
    '\x01','H','T','T','P','_','S','S','L','_','C','O','N','N','E','C','T','_','\x1a',
/* 0x14e1e = "VINF_EM_PENDING_REQUEST" */
    '\x0e','E','M','_','P','E','N','D','I','N','G','_','R','E','Q','U','E','S','T',
/* 0x14e31 = "VERR_VMX_MSR_ALL_VMX_DISABLED" */
    '\x01','\xe1','M','S','R','_','A','L','L','_','\xe1','D','I','S','A','B','L','E','D',
/* 0x14e44 = "VERR_DBGC_PARSE_WRITEONLY_SYMBOL" */
    '\x01','\xfb','\xe2','W','R','I','T','E','O','N','L','Y','_','S','Y','M','B','O','L',
/* 0x14e57 = "VFS chain element expected at most five arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','m','o','s','t',' ','f','i','v','e',' ','\xdc',
/* 0x14e6a = "VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\x95','\xbd','F','R','E','E','_','V','I','R','T','U','A','L','_','\xb6','_','\x16',
/* 0x14e7d = "VINF_ACCOUNT_RESTRICTED" */
    '\x0e','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x14e90 = "The service module was not found." */
    '\x03','s','e','r','v','i','c','e',' ','m','o','d','u','l','e',' ','\x11','\x08','\x88',
/* 0x14ea3 = "VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\x22','\xe3','\x1d','M','E','S','S','A','G','E','_','\xbe','A','T','T','R','I','B',
/* 0x14eb6 = "Record header integrity error." */
    'R','e','c','o','r','d',' ','\xb3','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x14ec9 = "VERR_SUP_VP_KERNEL32_ALREADY_MAPPED" */
    '\x01','\x95','\xbd','K','E','R','N','E','L','3','2','_','\x9a','M','A','P','P','E','D',
/* 0x14edc = "VERR_DWARF_LEB_OVERFLOW" */
    '\x01','D','W','A','R','F','_','L','E','B','_','O','V','E','R','F','L','O','W',
/* 0x14eef = "VT-x/AMD-V not active." */
    'V','T','-','x','/','A','M','D','-','V',' ','\x08','a','c','t','i','v','e','.',
/* 0x14f02 = "Process Verification Failure: Error querying process name." */
    '\x1e','\x0d','\x12','\xc0','q','u','e','r','y','i','n','g',' ','\x92','n','a','m','e','.',
/* 0x14f15 = "VERR_HM_UNKNOWN_IO_INSTRUCTION" */
    '\x01','H','M','_','\x91','I','O','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x14f28 = "The image is outside the expected range." */
    '\x03','\x25','\x0b','o','u','t','s','i','d','e',' ','\x02','\xc9','r','a','n','g','e','.',
/* 0x14f3b = "validation of the LX object table failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','\x02','L','X',' ','\xa7','\xb1','\x7d',
/* 0x14f4e = "Shared Clipboard guest error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','\xbb','\x84',
/* 0x14f61 = "VERR_PDM_DEVICE_NAME_CLASH" */
    '\x01','\x5e','D','E','V','I','C','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x14f74 = "VINF_IOM_R3_IOPORT_READ" */
    '\x0e','I','O','M','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x14f87 = "Failed to allocate memory for a URB." */
    '\x8b','\x0a','a','l','l','o','c','a','t','e',' ','\x85','\x10','a',' ','U','R','B','.',
/* 0x14f9a = "VERR_VD_DMG_NOT_FOUND_INSIDE_XAR" */
    '\x01','\xff','D','M','G','_','\x06','\x2a','_','I','N','S','I','D','E','_','X','A','R',
/* 0x14fad = "VINF_DBG_ADJUSTED_SYM_SIZE" */
    '\x0e','D','B','G','_','A','D','J','U','S','T','E','D','_','S','Y','M','_','\xfe',
/* 0x14fc0 = "VERR_GMM_MODULE_VERSION_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','\xbc','_','\x1c','L','O','N','G',
/* 0x14fd3 = "Empty set inside X." */
    'E','m','p','t','y',' ','s','e','t',' ','i','n','s','i','d','e',' ','X','.',
/* 0x14fe6 = "VERR_MANIFEST_ATTR_TYPE_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\xb5','_','\x06','\x2a',
/* 0x14ff9 = "VERR_DIS_NO_READ_CALLBACK" */
    '\x01','D','I','S','_','\x60','R','E','A','D','_','C','A','L','L','B','A','C','K',
/* 0x1500c = "HTTP Internal Server Error." */
    'H','T','T','P',' ','\x07','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x1501f = "VERR_RECORDING_CODEC_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x06','\x82',
/* 0x15032 = "Wrong JSON type for date value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf1','\x10','d','a','t','e',' ','\xf3',
/* 0x15045 = "VERR_SUP_VP_BAD_OPTIONAL_HEADER" */
    '\x01','\x95','\xbd','\x1d','O','P','T','I','O','N','A','L','_','H','E','A','D','E','R',
/* 0x15058 = "VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH" */
    '\x01','\x22','S','P','C','_','I','N','D','_','D','A','T','A','_','\xbe','\xfe','_','\x19',
/* 0x1506b = "VERR_CR_SPC_MONIKER_BAD_DATA" */
    '\x01','\x22','S','P','C','_','M','O','N','I','K','E','R','_','\x1d','D','A','T','A',
/* 0x1507e = "VERR_PDM_MISSING_INTERFACE_ABOVE" */
    '\x01','\x5e','\xc4','_','I','N','T','E','R','F','A','C','E','_','A','B','O','V','E',
/* 0x15091 = "VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG" */
    '\x01','\xff','R','A','W','_','\xfe','_','F','L','O','P','P','Y','_','\x1c','B','I','G',
/* 0x150a4 = "VERR_PDM_DEVICE_NO_RT_ATTACH" */
    '\x01','\x5e','D','E','V','I','C','E','_','\x60','R','T','_','A','T','T','A','C','H',
/* 0x150b7 = "VERR_VD_READ_OUT_OF_RANGE" */
    '\x01','\xff','R','E','A','D','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x150ca = "VERR_CR_SPC_UNKNOWN_MONIKER_UUID" */
    '\x01','\x22','S','P','C','_','\x91','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x150dd = "VERR_SEM_LV_WRONG_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','O','R','D','E','R',
/* 0x150f0 = "VERR_DBGC_PARSE_UNBALANCED_QUOTE" */
    '\x01','\xfb','\xe2','U','N','B','A','L','A','N','C','E','D','_','Q','U','O','T','E',
/* 0x15103 = "VERR_CFGM_CONFIG_UNKNOWN_VALUE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\x91','V','A','L','U','E',
/* 0x15116 = "VERR_PDM_DRIVER_NAME_CLASH" */
    '\x01','\x5e','D','R','I','V','E','R','_','N','A','M','E','_','C','L','A','S','H',
/* 0x15129 = "VERR_HTTP_ACCESS_DENIED" */
    '\x01','H','T','T','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x1513c = "VERR_GIM_PVTSC_NOT_ENABLED" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x06','E','N','A','B','L','E','D',
/* 0x1514f = "The handle is not pollable." */
    '\x03','h','a','n','d','l','e',' ','\x0b','\x08','p','o','l','l','a','b','l','e','.',
/* 0x15162 = "VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH" */
    '\x01','\x24','\x89','V','O','L','U','M','E','_','S','P','A','C','E','_','\xfe','_','\x19',
/* 0x15175 = "VERR_ACCOUNT_RESTRICTED" */
    '\x01','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x15188 = "Unknown SPC PE image attribute." */
    '\xf8','S','P','C',' ','P','E',' ','\x25','a','t','t','r','i','b','u','t','e','.',
/* 0x1519b = "VINF_IEM_RECOMPILE_END_TB" */
    '\x0e','\x9b','R','E','C','O','M','P','I','L','E','_','E','N','D','_','T','B',
/* 0x151ad = "EVP_EncryptFinal failed." */
    'E','V','P','_','E','n','c','r','y','p','t','F','i','n','a','l',' ','\x7d',
/* 0x151bf = "Syntax error - Invalid command name." */
    '\xf7','\x09','-',' ','\x0c','c','o','m','m','a','n','d',' ','n','a','m','e','.',
/* 0x151d1 = "VERR_DWARF_UNKNOWN_LOC_OPCODE" */
    '\x01','D','W','A','R','F','_','\x91','L','O','C','_','O','P','C','O','D','E',
/* 0x151e3 = "VERR_CFGM_INTEGER_TOO_BIG" */
    '\x01','C','F','G','M','_','I','N','T','E','G','E','R','_','\x1c','B','I','G',
/* 0x151f5 = "VERR_FAILED_TO_SET_SELF_TLS" */
    '\x01','\x16','_','T','O','_','S','E','T','_','S','E','L','F','_','T','L','S',
/* 0x15207 = "Internal processing error #2 in the I/O port code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x83',
/* 0x15219 = "VERR_PGM_NO_CR3_SHADOW_ROOT" */
    '\x01','\x8c','\x60','C','R','3','_','S','H','A','D','O','W','_','R','O','O','T',
/* 0x1522b = "Device name clash." */
    'D','e','v','i','c','e',' ','n','a','m','e',' ','c','l','a','s','h','.',
/* 0x1523d = "VERR_MEDIA_NOT_RECOGNIZED" */
    '\x01','M','E','D','I','A','_','\x06','R','E','C','O','G','N','I','Z','E','D',
/* 0x1524f = "VINF_SYS_MAY_POWER_OFF" */
    '\x0e','S','Y','S','_','M','A','Y','_','P','O','W','E','R','_','O','F','F',
/* 0x15261 = "VERR_COM_OBJECT_IN_USE" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','I','N','_','U','S','E',
/* 0x15273 = "VERR_FDT_AT_ROOT_LEVEL" */
    '\x01','F','D','T','_','A','T','_','R','O','O','T','_','L','E','V','E','L',
/* 0x15285 = "VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ" */
    '\x01','\xa1','T','E','L','E','T','E','X','_','\x91','E','S','C','_','S','E','Q',
/* 0x15297 = "VERR_ISOMK_IPE_EMPTY_COMPONENT" */
    '\x01','\x24','\x14','E','M','P','T','Y','_','C','O','M','P','O','N','E','N','T',
/* 0x152a9 = "OpenSSL PKCS #7 verification failed." */
    'O','p','e','n','S','S','L',' ','P','K','C','S',' ','#','7',' ','\xf6','\x7d',
/* 0x152bb = "VFS chain element expected at most six arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','m','o','s','t',' ','s','i','x',' ','\xdc',
/* 0x152cd = "VINF_CPUM_R3_MSR_WRITE" */
    '\x0e','C','P','U','M','_','R','3','_','M','S','R','_','W','R','I','T','E',
/* 0x152df = "VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE" */
    '\x01','\x5e','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','\x05','\xef',
/* 0x152f1 = "FTP Internal Server Error." */
    'F','T','P',' ','\x07','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x15303 = "VERR_SYMBOL_VALUE_TOO_BIG" */
    '\x01','S','Y','M','B','O','L','_','V','A','L','U','E','_','\x1c','B','I','G',
/* 0x15315 = "Process Verification Failure: An image has too many regions." */
    '\x1e','\x0d','\x12','A','n',' ','\x25','\x7b','\xa0','\xb4','r','e','g','i','o','n','s','.',
/* 0x15327 = "VERR_IS_A_BLOCK_DEVICE" */
    '\x01','I','S','_','A','_','B','L','O','C','K','_','D','E','V','I','C','E',
/* 0x15339 = "VFS chain element expected at most two arguments." */
    '\x8d',' ','\x9f','\x5c','\xc9','a','t',' ','m','o','s','t',' ','t','w','o',' ','\xdc',
/* 0x1534b = "VWRN_NEGATIVE_UNSIGNED" */
    '\xe4','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0X1535d = "Deadlock detected." */
    'e','a','d','l','o','c','k',' ','d','e','t','e','c','t','e','d','.',
/* 0x1536e = "VERR_VSCSI_LUN_INVALID" */
    '\x01','V','S','C','S','I','_','L','U','N','_','I','N','V','A','L','I','D',
/* 0x15380 = "VERR_PDM_NO_ATTACHED_DRIVER" */
    '\x01','\x5e','\x60','A','T','T','A','C','H','E','D','_','D','R','I','V','E','R',
/* 0x15392 = "Recompiler: Out of stack slots." */
    '\x13','O','u','t',' ','\x15','s','t','a','c','k',' ','s','l','o','t','s','.',
/* 0x153a4 = "Unknown allocation descriptor type." */
    '\xf8','a','l','l','o','c','a','t','i','o','n',' ','\xee','t','y','p','e','.',
/* 0x153b6 = "Not code selector." */
    'N','o','t',' ','c','o','d','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x153c8 = "Unsupported hashing function." */
    '\x97','h','a','s','h','i','n','g',' ','f','u','n','c','t','i','o','n','.',
/* 0x153da = "Unexpected unstable VM state." */
    '\x94','u','n','s','t','a','b','l','e',' ','\xcc',' ','s','t','a','t','e','.',
/* 0x153ec = "VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO" */
    '\x01','\x24','\x89','\x05','V','O','L','U','M','N','E','_','S','E','Q','_','N','O',
/* 0x153fe = "VERR_GMM_CHUNK_NOT_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x06','M','A','P','P','E','D',
/* 0x15410 = "Internal processing error #1 in the switcher code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','s','w','i','t','c','h','e','r',' ','\x83',
/* 0x15422 = "VERR_GMM_CHUNK_ALREADY_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x9a','M','A','P','P','E','D',
/* 0x15434 = "VERR_CALLER_NO_REFERENCE" */
    '\x01','C','A','L','L','E','R','_','\x60','R','E','F','E','R','E','N','C','E',
/* 0x15446 = "VERR_PDM_DRIVER_ALREADY_ATTACHED" */
    '\x01','\x5e','D','R','I','V','E','R','_','\x9a','A','T','T','A','C','H','E','D',
/* 0x15458 = "VERR_VFS_CHAIN_TAKES_DIR_OR_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','D','I','R','_','O','R','_','\x8d',
/* 0x1546a = "VERR_IEM_DBGINFO_OUT_OF_MEMORY" */
    '\x01','\x9b','D','B','G','I','N','F','O','_','O','U','T','_','O','F','_','\xb6',
/* 0x1547c = "The per process timer is busy." */
    '\x03','p','e','r',' ','\x92','t','i','m','e','r',' ','\x0b','b','u','s','y','.',
/* 0x1548e = "Data connection not found." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','\x08','\x88',
/* 0x154a0 = "The page to be freed was already freed." */
    '\x03','\xcb','\x0a','\xa8','f','r','e','e','d',' ','\x11','\x7f','f','r','e','e','d','.',
/* 0x154b2 = "VERR_LDR_INVALID_LINK_ADDRESS" */
    '\x01','L','D','R','_','\x05','L','I','N','K','_','A','D','D','R','E','S','S',
/* 0x154c4 = "Bad left tree height." */
    '\x9d','l','e','f','t',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x154d6 = "Device i/o: Bad unit." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x9d','u','n','i','t','.',
/* 0x154e8 = "VERR_ISOFS_ICB_ENTRY_TOO_SMALL" */
    '\x01','\xa2','I','C','B','_','E','N','T','R','Y','_','\x1c','S','M','A','L','L',
/* 0x154fa = "VERR_LDRVI_READ_ERROR_SIGNATURE" */
    '\x01','\xf2','R','E','A','D','_','\x1a','_','S','I','G','N','A','T','U','R','E',
/* 0x1550c = "VERR_CFGM_CONFIG_UNKNOWN_NODE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\x91','N','O','D','E',
/* 0x1551e = "The value is not a byte string." */
    '\x03','\xfa','\x0b','\x08','a',' ','b','y','t','e',' ','s','t','r','i','n','g','.',
/* 0x15530 = "VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS" */
    '\x01','\x95','\xbd','\x1c','\xaf','I','M','A','G','E','_','R','E','G','I','O','N','S',
/* 0X15542 = "Stream is not ready for requested operation." */
    't','r','e','a','m',' ','\x0b','\x08','r','e','a','d','y',' ','\x10','\xdd','\xe8',
/* 0x15553 = "Bad file element in XAR table of content." */
    '\x9d','\x1f','\x5c','\x0f','X','A','R',' ','\xb1','\x15','c','o','n','t','e','n','t','.',
/* 0x15565 = "VERR_ISOFS_UDF_NOT_IMPLEMENTED" */
    '\x01','\xa2','U','D','F','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x15577 = "Recompiler: Debug info internal processing error #2." */
    '\x13','D','e','b','u','g',' ','i','n','f','o',' ','\x17','\x04','\x09','#','2','.',
/* 0x15589 = "VERR_NEGATIVE_UNSIGNED" */
    '\x01','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x1559b = "VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING" */
    '\x01','\x95','\xbd','\x60','\x2a','_','\x60','E','X','E','_','M','A','P','P','I','N','G',
/* 0x155ad = "VERR_PGM_HANDLER_ALREADY_ALIASED" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x9a','A','L','I','A','S','E','D',
/* 0x155bf = "VINF_EM_RAW_GUEST_TRAP" */
    '\x0e','E','M','_','R','A','W','_','G','U','E','S','T','_','T','R','A','P',
/* 0x155d1 = "VERR_SUPDRV_TRACER_UNLOADING" */
    '\x01','\x90','T','R','A','C','E','R','_','U','N','L','O','A','D','I','N','G',
/* 0x155e3 = "Driver name clash." */
    'D','r','i','v','e','r',' ','n','a','m','e',' ','c','l','a','s','h','.',
/* 0x155f5 = "VERR_ISOFS_INVALID_PARTITION_INDEX" */
    '\x01','\xa2','\x05','P','A','R','T','I','T','I','O','N','_','I','N','D','E','X',
/* 0x15607 = "Process Verification Failure: Error opening image file." */
    '\x1e','\x0d','\x12','\xc0','o','p','e','n','i','n','g',' ','\x25','f','i','l','e','.',
/* 0x15619 = "VERR_DBGC_PARSE_INCORRECT_ARG_TYPE" */
    '\x01','\xfb','\xe2','I','N','C','O','R','R','E','C','T','_','A','R','G','_','\xb5',
/* 0x1562b = "Recompiler: Debug info internal processing error #1." */
    '\x13','D','e','b','u','g',' ','i','n','f','o',' ','\x17','\x04','\x09','#','1','.',
/* 0x1563d = "OpenSSL d2i_X509 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','X','5','0','9',' ','\x7d',
/* 0x1564f = "Process Verification Failure: Bad virtual section size." */
    '\x1e','\x0d','\x12','\x9d','v','i','r','t','u','a','l',' ','\xda','s','i','z','e','.',
/* 0x15661 = "File/Device open failed." */
    'F','i','l','e','/','D','e','v','i','c','e',' ','o','p','e','n',' ','\x7d',
/* 0x15673 = "Too many MMIO2 ranges." */
    'T','o','o',' ','\xb4','M','M','I','O','2',' ','r','a','n','g','e','s','.',
/* 0x15685 = "VERR_IOM_IOPORT_UNUSED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','U','N','U','S','E','D',
/* 0x15697 = "iSCSI: Invalid header, i." */
    'i','S','C','S','I',':',' ','\x0c','h','e','a','d','e','r',',',' ','i','.',
/* 0x156a9 = "VERR_SEM_LV_NOT_SIGNALLER" */
    '\x01','S','E','M','_','L','V','_','\x06','S','I','G','N','A','L','L','E','R',
/* 0x156bb = "MMIO region is not mapped." */
    '\xd2',' ','r','e','g','i','o','n',' ','\x0b','\x08','m','a','p','p','e','d','.',
/* 0x156cd = "VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH" */
    '\x01','\x24','\x89','\x1d','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x156df = "Logic bug in the DBGC code." */
    'L','o','g','i','c',' ','b','u','g',' ','\x0f','\x02','D','B','G','C',' ','\x83',
/* 0x156f1 = "VINF_IEM_YIELD_PENDING_FF" */
    '\x0e','\x9b','Y','I','E','L','D','_','P','E','N','D','I','N','G','_','F','F',
/* 0x15703 = "VERR_XML_TOC_ELEMENT_MISSING" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','\xc4',
/* 0x15715 = "VERR_IOM_INVALID_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x15727 = "VERR_IPC_RECEIVE_MAP_FAILED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','M','A','P','_','\x16',
/* 0x15739 = "VERR_HM_WRONG_SWITCHER" */
    '\x01','H','M','_','W','R','O','N','G','_','S','W','I','T','C','H','E','R',
/* 0x1574b = "Symbol (export) not found." */
    'S','y','m','b','o','l',' ','(','e','x','p','o','r','t',')',' ','\x08','\x88',
/* 0x1575d = "VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED" */
    '\x01','\xa1','\xd4','_','\xb5','_','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1576f = "Permission denied." */
    'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','.',
/* 0x15781 = "Pending VM request packet." */
    'P','e','n','d','i','n','g',' ','\xcc',' ','\xaa','p','a','c','k','e','t','.',
/* 0x15793 = "VERR_PKZIP_BAD_CDF_HEADER" */
    '\x01','P','K','Z','I','P','_','\x1d','C','D','F','_','H','E','A','D','E','R',
/* 0x157a5 = "Internal processing error #3 in the I/O port code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x83',
/* 0x157b7 = "VERR_PDM_CRITSECT_ABORT_FAILED" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','_','A','B','O','R','T','_','\x16',
/* 0x157c9 = "VERR_NEM_SET_REGISTERS_FAILED" */
    '\x01','\xec','_','S','E','T','_','R','E','G','I','S','T','E','R','S','_','\x16',
/* 0x157db = "VERR_MAX_THRDS_REACHED" */
    '\x01','M','A','X','_','T','H','R','D','S','_','R','E','A','C','H','E','D',
/* 0x157ed = "VERR_IEM_INSTR_BUF_TOO_LARGE" */
    '\x01','\x9b','I','N','S','T','R','_','B','U','F','_','\x1c','L','A','R','G','E',
/* 0x157ff = "VERR_NEM_GET_REGISTERS_FAILED" */
    '\x01','\xec','_','G','E','T','_','R','E','G','I','S','T','E','R','S','_','\x16',
/* 0x15811 = "VERR_VMM_SWITCHER_STUB" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','S','T','U','B',
/* 0x15823 = "VERR_TAR_BAD_CHKSUM_FIELD" */
    '\x01','T','A','R','_','\x1d','C','H','K','S','U','M','_','F','I','E','L','D',
/* 0x15835 = "Process Verification Failure: Bad image base in header." */
    '\x1e','\x0d','\x12','\x9d','\x25','b','a','s','e',' ','\x0f','h','e','a','d','e','r','.',
/* 0x15847 = "VERR_PGM_PHYS_HANDLER_IPE" */
    '\x01','\x8c','P','H','Y','S','_','H','A','N','D','L','E','R','_','I','P','E',
/* 0x15859 = "Expected ECDSA public key." */
    '\xb8','E','C','D','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1586b = "VERR_IEM_EMIT_BAD_SEG_REG_NO" */
    '\x01','\x9b','E','M','I','T','_','\x1d','S','E','G','_','R','E','G','_','N','O',
/* 0x1587d = "Protocol family not supported." */
    'P','r','o','t','o','c','o','l',' ','f','a','m','i','l','y',' ','\x08','\xa4',
/* 0x1588f = "VERR_PGM_PHYS_NULL_PAGE_PARAM" */
    '\x01','\x8c','P','H','Y','S','_','N','U','L','L','_','\xdb','P','A','R','A','M',
/* 0x158a1 = "VERR_PERMISSION_DENIED" */
    '\x01','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x158b3 = "Process Verification Failure: Bad size of image header." */
    '\x1e','\x0d','\x12','\x9d','s','i','z','e',' ','\x15','\x25','h','e','a','d','e','r','.',
/* 0x158c5 = "Switch back to host." */
    'S','w','i','t','c','h',' ','b','a','c','k',' ','\x0a','h','o','s','t','.',
/* 0x158d7 = "VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET" */
    '\x01','\xa1','T','E','L','E','T','E','X','_','\x1b','C','H','A','R','S','E','T',
/* 0x158e9 = "Reducing the size is not supported." */
    'R','e','d','u','c','i','n','g',' ','\x02','s','i','z','e',' ','\x0b','\x08','\xa4',
/* 0x158fb = "Expected a different string tag." */
    '\xb8','a',' ','d','i','f','f','e','r','e','n','t',' ','\xf0','t','a','g','.',
/* 0x1590d = "VERR_FDT_DTB_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','M','A','L','F','O','R','M','E','D',
/* 0x1591f = "Import ISO contains a bad directory record." */
    '\xc3','\xc1',' ','\x8a','a',' ','b','a','d',' ','\x26','r','e','c','o','r','d','.',
/* 0x15931 = "VERR_MANIFEST_ATTR_TYPE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\xb5','_','\x19',
/* 0x15943 = "VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ" */
    '\x01','\xa1','T','E','L','E','T','E','X','_','\x1b','E','S','C','_','S','E','Q',
/* 0x15955 = "VERR_CR_KEY_DECRYPTION_FAILED" */
    '\x01','\x22','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x16',
/* 0x15967 = "Internal processing error #1 in the I/O port code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','I','/','O',' ','p','o','r','t',' ','\x83',
/* 0x15979 = "NEM failed to get registers." */
    '\xec',' ','\x98','\x0a','g','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x1598b = "Is a block device." */
    'I','s',' ','a',' ','b','l','o','c','k',' ','d','e','v','i','c','e','.',
/* 0x1599d = "Undefined VM exit code." */
    'U','n','d','e','f','i','n','e','d',' ','\xcc',' ','e','x','i','t',' ','\x83',
/* 0x159af = "VERR_SELECTOR_NOT_PRESENT" */
    '\x01','S','E','L','E','C','T','O','R','_','\x06','P','R','E','S','E','N','T',
/* 0x159c1 = "VERR_VD_RAW_SIZE_MODULO_512" */
    '\x01','\xff','R','A','W','_','\xfe','_','M','O','D','U','L','O','_','5','1','2',
/* 0x159d3 = "VERR_DBG_NO_LINE_NUMBERS" */
    '\x01','D','B','G','_','\x60','L','I','N','E','_','N','U','M','B','E','R','S',
/* 0x159e5 = "VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE" */
    '\x01','\xa2','\x1b','L','O','G','I','C','A','L','_','B','L','O','C','K','_','\xfe',
/* 0x159f7 = "Receive cancelled." */
    'R','e','c','e','i','v','e',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x15a09 = "VERR_NET_NO_BUFFER_SPACE" */
    '\x01','N','E','T','_','\x60','B','U','F','F','E','R','_','S','P','A','C','E',
/* 0x15a1b = "VERR_PDM_TRANSLATION_NOT_SET" */
    '\x01','\x5e','T','R','A','N','S','L','A','T','I','O','N','_','\x06','S','E','T',
/* 0x15a2d = "VERR_CONCURRENT_ACCESS" */
    '\x01','C','O','N','C','U','R','R','E','N','T','_','A','C','C','E','S','S',
/* 0x15a3f = "VERR_SUP_VP_EXE_MISSING_NX_COMPAT" */
    '\x01','\x95','\xbd','E','X','E','_','\xc4','_','N','X','_','C','O','M','P','A','T',
/* 0x15a51 = "Seek below file start." */
    'S','e','e','k',' ','b','e','l','o','w',' ','\x1f','s','t','a','r','t','.',
/* 0x15a63 = "The I/O request is in an invalid state for this operation." */
    '\x03','I','/','O',' ','\xaa','\x0b','\x0f','\x87','\x8f','\xcd','\x10','t','h','i','s',' ','\xe8',
/* 0x15a75 = "VERR_SSM_FIELD_INVALID_PADDING_SIZE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','P','A','D','D','I','N','G','_','\xfe',
/* 0x15a87 = "Too many CPUID leaves." */
    'T','o','o',' ','\xb4','C','P','U','I','D',' ','l','e','a','v','e','s','.',
/* 0x15a99 = "MMIO region is already mapped." */
    '\xd2',' ','r','e','g','i','o','n',' ','\x0b','\x7f','m','a','p','p','e','d','.',
/* 0x15aab = "VERR_ASN1_TIME_NORMALIZE_ERROR" */
    '\x01','\xa1','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x1a',
/* 0x15abd = "VERR_ASN1_TIME_NORMALIZE_MISMATCH" */
    '\x01','\xa1','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x19',
/* 0x15acf = "Deprecated digest." */
    'D','e','p','r','e','c','a','t','e','d',' ','d','i','g','e','s','t','.',
/* 0x15ae1 = "The PE loader doesn't support the TLS data directory yet." */
    '\x03','P','E',' ','\xd8','\xc7','\xce','\x02','T','L','S',' ','\x9c','\x26','y','e','t','.',
/* 0x15af3 = "VINF_EM_DBG_BREAKPOINT" */
    '\x0e','E','M','_','D','B','G','_','B','R','E','A','K','P','O','I','N','T',
/* 0x15b05 = "VINF_VD_NEW_ZEROED_BLOCK" */
    '\x0e','\xff','N','E','W','_','Z','E','R','O','E','D','_','B','L','O','C','K',
/* 0x15b17 = "VINF_EM_RESCHEDULE_REM" */
    '\x0e','E','M','_','R','E','S','C','H','E','D','U','L','E','_','R','E','M',
/* 0x15b29 = "VERR_PGM_MAPPING_CONFLICT" */
    '\x01','\x8c','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x15b3b = "VERR_SUP_VP_NOT_BUILD_CERT_IPE" */
    '\x01','\x95','\xbd','\x06','B','U','I','L','D','_','C','E','R','T','_','I','P','E',
/* 0x15b4d = "VERR_VFS_CHAIN_WRITE_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','W','R','I','T','E','_','O','N','L','Y','_','I','O','S',
/* 0x15b5f = "VERR_IEM_VAR_NOT_INITIALIZED" */
    '\x01','\x9b','V','A','R','_','\x06','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x15b71 = "Key decryption is not supported." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','\x0b','\x08','\xa4',
/* 0x15b83 = "VERR_MAX_PROCS_REACHED" */
    '\x01','M','A','X','_','P','R','O','C','S','_','R','E','A','C','H','E','D',
/* 0x15b95 = "VERR_LDRELF_ODD_ENDIAN" */
    '\x01','L','D','R','E','L','F','_','O','D','D','_','E','N','D','I','A','N',
/* 0x15ba7 = "VERR_HGCM_INVALID_CMD_ADDRESS" */
    '\x01','H','G','C','M','_','\x05','C','M','D','_','A','D','D','R','E','S','S',
/* 0x15bb9 = "VERR_POLL_HANDLE_ID_NOT_FOUND" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','\x06','\x2a',
/* 0x15bcb = "The specified path has too many components (hardening)." */
    '\x03','\x18','\xd0','\x7b','\xa0','\xb4','c','o','m','p','o','n','e','n','t','s',' ','\xad',
/* 0x15bdd = "VERR_SHARING_VIOLATION" */
    '\x01','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x15bef = "VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO" */
    '\x01','\x22','\xb7','\x91','C','E','R','T','_','S','I','G','N','_','A','L','G','O',
/* 0x15c01 = "VERR_LDRLX_NRICHAIN_NOT_SUPPORTED" */
    '\x01','L','D','R','L','X','_','N','R','I','C','H','A','I','N','_','\x06','\x82',
/* 0x15c13 = "Footer integrity error." */
    'F','o','o','t','e','r',' ','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x15c25 = "VERR_VD_NOT_ENOUGH_METADATA" */
    '\x01','\xff','\x06','E','N','O','U','G','H','_','M','E','T','A','D','A','T','A',
/* 0x15c37 = "VERR_LDR_FORWARDERS_NOT_SUPPORTED" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','S','_','\x06','\x82',
/* 0x15c49 = "VERR_TRPM_NO_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','\x60','A','C','T','I','V','E','_','T','R','A','P',
/* 0x15c5b = "Unexpected filesystem object type." */
    '\x94','f','i','l','e','s','y','s','t','e','m',' ','\xa7','t','y','p','e','.',
/* 0x15c6d = "Expected valid data pointer for ASN." */
    '\xb8','v','a','l','i','d',' ','\x9c','p','o','i','n','t','e','r',' ','\x10','\xf4',
/* 0x15c7f = "VERR_SEM_LV_INVALID_PARAMETER" */
    '\x01','S','E','M','_','L','V','_','\x05','P','A','R','A','M','E','T','E','R',
/* 0x15c91 = "VERR_IOM_FF_STATUS_IPE" */
    '\x01','I','O','M','_','F','F','_','S','T','A','T','U','S','_','I','P','E',
/* 0x15ca3 = "VERR_WRONG_PARAMETER_TYPE" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','\xb5',
/* 0x15cb5 = "VERR_ISOMK_RR_NO_SPACE_FOR_CE" */
    '\x01','\x24','R','R','_','\x60','S','P','A','C','E','_','F','O','R','_','C','E',
/* 0x15cc7 = "VINF_PERMISSION_DENIED" */
    '\x0e','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x15cd9 = "The shared module was not found." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x11','\x08','\x88',
/* 0x15ceb = "EVP_DecryptFinal failed." */
    'E','V','P','_','D','e','c','r','y','p','t','F','i','n','a','l',' ','\x7d',
/* 0x15cfd = "Invalid requested privilege level." */
    '\x0c','\xdd','p','r','i','v','i','l','e','g','e',' ','l','e','v','e','l','.',
/* 0x15d0f = "VERR_S3_BUCKET_ALREADY_EXISTS" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x9a','E','X','I','S','T','S',
/* 0x15d21 = "VERR_PATH_IS_NOT_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','\x06','R','E','L','A','T','I','V','E',
/* 0x15d33 = "The tracer has not been opened." */
    '\x03','t','r','a','c','e','r',' ','\x7b','\x08','\xca','o','p','e','n','e','d','.',
/* 0x15d45 = "VERR_VM_SAVE_STATE_NOT_ALLOWED" */
    '\x01','\xcc','_','S','A','V','E','_','\xef','_','\x06','A','L','L','O','W','E','D',
/* 0x15d57 = "VERR_SUP_VP_SECTION_NOT_MAPPED" */
    '\x01','\x95','\xbd','S','E','C','T','I','O','N','_','\x06','M','A','P','P','E','D',
/* 0x15d69 = "VERR_VBGL_NOT_INITIALIZED" */
    '\x01','V','B','G','L','_','\x06','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x15d7b = "Invalid signature length." */
    '\x0c','s','i','g','n','a','t','u','r','e',' ','l','e','n','g','t','h','.',
/* 0x15d8d = "VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING" */
    '\x01','\xa1','C','U','R','S','O','R','_','\x1d','L','E','N','G','T','H','_','\xc6',
/* 0x15d9f = "NEM failed to set registers." */
    '\xec',' ','\x98','\x0a','s','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x15db1 = "The value was truncated to fit." */
    '\x03','\xfa','\x11','t','r','u','n','c','a','t','e','d',' ','\x0a','f','i','t','.',
/* 0x15dc3 = "VERR_CPUM_UNSUPPORTED_ID_REGISTER" */
    '\x01','C','P','U','M','_','\x1b','I','D','_','R','E','G','I','S','T','E','R',
/* 0x15dd5 = "VERR_LDRVI_BAD_CERT_HDR_LENGTH" */
    '\x01','\xf2','\x1d','C','E','R','T','_','H','D','R','_','L','E','N','G','T','H',
/* 0x15de7 = "VERR_EM_GUEST_CPU_HANG" */
    '\x01','E','M','_','G','U','E','S','T','_','C','P','U','_','H','A','N','G',
/* 0x15df9 = "VERR_CR_PKIX_SIGNATURE_MISMATCH" */
    '\x01','\x22','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x19',
/* 0x15e0b = "VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE" */
    '\x01','\x90','A','P','I','P','O','R','T','_','O','P','E','N','_','\x1a','_','\xb5',
/* 0x15e1d = "VINF_PGM_HANDLER_ALREADY_ALIASED" */
    '\x0e','\x8c','H','A','N','D','L','E','R','_','\x9a','A','L','I','A','S','E','D',
/* 0x15e2f = "Client has been rejected." */
    'C','l','i','e','n','t',' ','\x7b','\xca','r','e','j','e','c','t','e','d','.',
/* 0x15e41 = "VERR_JSON_ITERATOR_END" */
    '\x01','J','S','O','N','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x15e53 = "VERR_ISOFS_TAG_IS_ALL_ZEROS" */
    '\x01','\xa2','T','A','G','_','I','S','_','A','L','L','_','Z','E','R','O','S',
/* 0x15e65 = "VERR_SSM_LIVE_POWERED_OFF" */
    '\x01','\xb0','L','I','V','E','_','P','O','W','E','R','E','D','_','O','F','F',
/* 0x15e77 = "VWRN_CONTINUE_ANALYSIS" */
    '\xe4','C','O','N','T','I','N','U','E','_','A','N','A','L','Y','S','I','S',
/* 0X15e89 = "Selector not present." */
    'e','l','e','c','t','o','r',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x15e9a = "VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH" */
    '\x01','\x24','\x89','V','O','L','U','M','E','_','I','N','_','S','E','T','_','\x19',
/* 0x15eac = "VERR_SSM_VIRTUAL_CLOCK_HZ" */
    '\x01','\xb0','V','I','R','T','U','A','L','_','C','L','O','C','K','_','H','Z',
/* 0x15ebe = "Certificate path validator: No valid certificate policy." */
    '\xba','\xd0','\xfd','\xe6','v','a','l','i','d',' ','\x9e','p','o','l','i','c','y','.',
/* 0x15ed0 = "VERR_NET_NOT_UNIQUE_NAME" */
    '\x01','N','E','T','_','\x06','U','N','I','Q','U','E','_','N','A','M','E',
/* 0x15ee1 = "Value out of range." */
    'V','a','l','u','e',' ','o','u','t',' ','\x15','r','a','n','g','e','.',
/* 0x15ef2 = "The server was stopped." */
    '\x03','s','e','r','v','e','r',' ','\x11','s','t','o','p','p','e','d','.',
/* 0x15f03 = "VERR_OUT_OF_RESOURCES" */
    '\x01','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x15f14 = "Recompiler: Unexpected kind of variable." */
    '\x13','\x94','k','i','n','d',' ','\x15','v','a','r','i','a','b','l','e','.',
/* 0x15f25 = "VERR_INTNET_FLT_IF_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x06','\x2a',
/* 0x15f36 = "VWRN_PATCH_END_BRANCH" */
    '\xe4','P','A','T','C','H','_','E','N','D','_','B','R','A','N','C','H',
/* 0x15f47 = "VERR_ISOFS_FSD_NEXT_EXTENT" */
    '\x01','\xa2','F','S','D','_','N','E','X','T','_','E','X','T','E','N','T',
/* 0x15f58 = "VERR_NET_NOT_UNSUPPORTED" */
    '\x01','N','E','T','_','\x06','U','N','S','U','P','P','O','R','T','E','D',
/* 0x15f69 = "VERR_SUPLIB_TEXT_NOT_WRITEABLE" */
    '\x01','\xd5','T','E','X','T','_','\x06','W','R','I','T','E','A','B','L','E',
/* 0x15f7a = "Configuration value not found." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xfa','\x08','\x88',
/* 0x15f8b = "VERR_MANIFEST_ATTR_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\x06','\x2a',
/* 0x15f9c = "VERR_PGM_SAVED_ROM_PAGE_PROT" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','\xdb','P','R','O','T',
/* 0x15fad = "VERR_NOT_ALL_CPUS_SHOWED" */
    '\x01','\x06','A','L','L','_','C','P','U','S','_','S','H','O','W','E','D',
/* 0x15fbe = "Patch was already disabled." */
    'P','a','t','c','h',' ','\x11','\x7f','d','i','s','a','b','l','e','d','.',
/* 0x15fcf = "The PKCS #7 content is not data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xed','\x0b','\x08','d','a','t','a','.',
/* 0x15fe0 = "VERR_ASN1_CURSOR_LONG_TAG" */
    '\x01','\xa1','C','U','R','S','O','R','_','L','O','N','G','_','T','A','G',
/* 0x15ff1 = "VERR_S3_BUCKET_NOT_EMPTY" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x06','E','M','P','T','Y',
/* 0x16002 = "VERR_PGM_DYNMAP_FULL_SET" */
    '\x01','\x8c','D','Y','N','M','A','P','_','F','U','L','L','_','S','E','T',
/* 0x16013 = "VERR_PGM_DYNMAP_EXPAND_ERROR" */
    '\x01','\x8c','D','Y','N','M','A','P','_','E','X','P','A','N','D','_','\x1a',
/* 0x16024 = "VERR_IMAGE_BASE_TOO_HIGH" */
    '\x01','I','M','A','G','E','_','B','A','S','E','_','\x1c','H','I','G','H',
/* 0x16035 = "VERR_TRPM_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','A','C','T','I','V','E','_','T','R','A','P',
/* 0x16046 = "The LUN is still busy." */
    '\x03','L','U','N',' ','\x0b','s','t','i','l','l',' ','b','u','s','y','.',
/* 0x16057 = "Unknown I/O instruction." */
    '\xf8','I','/','O',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x16068 = "Invalid parameter index." */
    '\x0c','p','a','r','a','m','e','t','e','r',' ','i','n','d','e','x','.',
/* 0x16079 = "VERR_PATM_UNSAFE_CODE" */
    '\x01','P','A','T','M','_','U','N','S','A','F','E','_','C','O','D','E',
/* 0x1608a = "VERR_SUP_VP_QUERY_HANDLE_TYPE" */
    '\x01','\x95','\xbd','Q','U','E','R','Y','_','H','A','N','D','L','E','_','\xb5',
/* 0x1609b = "Invalid escape sequence." */
    '\x0c','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x160ac = "Expected a provider name." */
    '\xb8','a',' ','p','r','o','v','i','d','e','r',' ','n','a','m','e','.',
/* 0x160bd = "Image is read-only." */
    'I','m','a','g','e',' ','\x0b','r','e','a','d','-','o','n','l','y','.',
/* 0x160ce = "VERR_LDRLX_BAD_ITERDATA2" */
    '\x01','L','D','R','L','X','_','\x1d','I','T','E','R','D','A','T','A','2',
/* 0x160df = "VERR_SSM_STRUCTURE_MAGIC" */
    '\x01','\xb0','S','T','R','U','C','T','U','R','E','_','M','A','G','I','C',
/* 0x160f0 = "VERR_CR_PKCS7_EXPECTED_NO_CRLS" */
    '\x01','\x22','\xe3','E','X','P','E','C','T','E','D','_','\x60','C','R','L','S',
/* 0x16101 = "VERR_CR_STORE_GENERIC_ERROR" */
    '\x01','\x22','S','T','O','R','E','_','G','E','N','E','R','I','C','_','\x1a',
/* 0x16112 = "VERR_NET_ALREADY_IN_PROGRESS" */
    '\x01','N','E','T','_','\x9a','I','N','_','P','R','O','G','R','E','S','S',
/* 0x16123 = "VERR_CR_X509_NAME_EMPTY_SET" */
    '\x01','\x22','\xb7','N','A','M','E','_','E','M','P','T','Y','_','S','E','T',
/* 0x16134 = "VERR_VFS_CHAIN_TAKES_FILE_OR_IOS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','\xab','O','R','_','I','O','S',
/* 0x16145 = "Address overflow." */
    'A','d','d','r','e','s','s',' ','o','v','e','r','f','l','o','w','.',
/* 0x16156 = "VERR_DBGF_BP_L1_LOOKUP_FAILED" */
    '\x01','\xb9','_','B','P','_','L','1','_','L','O','O','K','U','P','_','\x16',
/* 0x16167 = "Generic out of resources error." */
    '\xa6','o','u','t',' ','\x15','r','e','s','o','u','r','c','e','s',' ','\x84',
/* 0x16178 = "No attached driver." */
    '\xe6','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x16189 = "VERR_SUPDRV_VTG_ALREADY_REGISTERED" */
    '\x01','\x90','V','T','G','_','\x9a','R','E','G','I','S','T','E','R','E','D',
/* 0x1619a = "VERR_XAR_TOC_STRLEN_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','S','T','R','L','E','N','_','\x19',
/* 0x161ab = "VERR_GMM_CHUNK_INSERT" */
    '\x01','G','M','M','_','C','H','U','N','K','_','I','N','S','E','R','T',
/* 0x161bc = "VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG" */
    '\x01','\xf2','\xdb','H','A','S','H','_','T','A','B','_','\x1c','L','O','N','G',
/* 0x161cd = "validation of LX header failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x15','L','X',' ','\xb3','\x7d',
/* 0x161de = "VERR_VMM_CANNOT_BLOCK" */
    '\x01','V','M','M','_','C','A','N','N','O','T','_','B','L','O','C','K',
/* 0x161ef = "VWRN_OUT_OF_RESOURCES" */
    '\xe4','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x16200 = "Expected RSA private key." */
    '\xb8','R','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x16211 = "VERR_LDRLX_BAD_FORWARDER" */
    '\x01','L','D','R','L','X','_','\x1d','F','O','R','W','A','R','D','E','R',
/* 0x16222 = "VERR_URI_ESCAPED_ZERO" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','Z','E','R','O',
/* 0x16233 = "VERR_PATH_IS_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','R','E','L','A','T','I','V','E',
/* 0x16244 = "Version mismatch." */
    'V','e','r','s','i','o','n',' ','m','i','s','m','a','t','c','h','.',
/* 0x16255 = "Buffer underflow." */
    'B','u','f','f','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x16266 = "VERR_ADDRESS_CONFLICT" */
    '\x01','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x16277 = "VERR_PREEMPT_DISABLED" */
    '\x01','P','R','E','E','M','P','T','_','D','I','S','A','B','L','E','D',
/* 0x16288 = "VERR_PDM_NOT_PCI_BUS_MASTER" */
    '\x01','\x5e','\x06','P','C','I','_','B','U','S','_','M','A','S','T','E','R',
/* 0x16299 = "VERR_CFGM_LEAF_EXISTS" */
    '\x01','C','F','G','M','_','L','E','A','F','_','E','X','I','S','T','S',
/* 0x162aa = "Invalid Base64 encoding." */
    '\x0c','B','a','s','e','6','4',' ','e','n','c','o','d','i','n','g','.',
/* 0x162bb = "VINF_OBJECT_DESTROYED" */
    '\x0e','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x162cc = "VERR_VGA_GL_SYMBOL_NOT_FOUND" */
    '\x01','V','G','A','_','G','L','_','S','Y','M','B','O','L','_','\x06','\x2a',
/* 0x162dd = "VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','M','M','I','O','2','_','\xdb','\x06','\x2a',
/* 0x162ee = "VERR_SUP_VP_STUB_THREAD_NOT_FOUND" */
    '\x01','\x95','\xbd','S','T','U','B','_','T','H','R','E','A','D','_','\x06','\x2a',
/* 0x162ff = "VINF_CPUM_R3_MSR_READ" */
    '\x0e','C','P','U','M','_','R','3','_','M','S','R','_','R','E','A','D',
/* 0x16310 = "VERR_DBGC_PARSE_NO_RANGE_ALLOWED" */
    '\x01','\xfb','\xe2','\x60','R','A','N','G','E','_','A','L','L','O','W','E','D',
/* 0x16321 = "VERR_CFGM_NODE_EXISTS" */
    '\x01','C','F','G','M','_','N','O','D','E','_','E','X','I','S','T','S',
/* 0x16332 = "VINF_PCI_MAPPING_DONE" */
    '\x0e','P','C','I','_','M','A','P','P','I','N','G','_','D','O','N','E',
/* 0x16343 = "Bad new tree height." */
    '\x9d','n','e','w',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x16354 = "VERR_ASN1_OBJID_INVALID_DOTTED_STRING" */
    '\x01','\xa1','O','B','J','I','D','_','\x05','D','O','T','T','E','D','_','\xd4',
/* 0x16365 = "The semaphore is in use." */
    '\x03','s','e','m','a','p','h','o','r','e',' ','\x0b','\x0f','u','s','e','.',
/* 0x16376 = "VERR_PKZIP_BAD_LF_HEADER" */
    '\x01','P','K','Z','I','P','_','\x1d','L','F','_','H','E','A','D','E','R',
/* 0x16387 = "VERR_PLATFORM_ARCH_NOT_SUPPORTED" */
    '\x01','P','L','A','T','F','O','R','M','_','A','R','C','H','_','\x06','\x82',
/* 0x16398 = "VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED" */
    '\x01','\xe7','O','T','H','E','R','_','E','N','D','I','A','N','_','\x06','\x82',
/* 0x163a9 = "The requested type conversion was not supported." */
    '\x03','\xdd','\xf1','c','o','n','v','e','r','s','i','o','n',' ','\x11','\x08','\xa4',
/* 0x163ba = "VERR_EXTPACK_VBOX_VERSION_MISMATCH" */
    '\x01','E','X','T','P','A','C','K','_','V','B','O','X','_','\xbc','_','\x19',
/* 0x163cb = "Syntax error - buggy parser." */
    '\xf7','\x09','-',' ','b','u','g','g','y',' ','p','a','r','s','e','r','.',
/* 0x163dc = "VERR_GVMM_BROKEN_IPRT" */
    '\x01','G','V','M','M','_','B','R','O','K','E','N','_','I','P','R','T',
/* 0x163ed = "Address conflict." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t','.',
/* 0x163fe = "VERR_SERVICE_DISABLED" */
    '\x01','S','E','R','V','I','C','E','_','D','I','S','A','B','L','E','D',
/* 0x1640f = "VERR_DBG_NO_UNWIND_INFO" */
    '\x01','D','B','G','_','\x60','U','N','W','I','N','D','_','I','N','F','O',
/* 0x16420 = "VERR_IPC_SEND_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','T','I','M','E','O','U','T',
/* 0x16431 = "VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS" */
    '\x01','\x95','\xbd','\x86','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x16442 = "VINF_AIO_TASK_PENDING" */
    '\x0e','A','I','O','_','T','A','S','K','_','P','E','N','D','I','N','G',
/* 0x16453 = "VERR_VM_REQUEST_KILLED" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','K','I','L','L','E','D',
/* 0x16464 = "Bad load command(s)." */
    '\x9d','l','o','a','d',' ','c','o','m','m','a','n','d','(','s',')','.',
/* 0x16475 = "VERR_PATH_ZERO_LENGTH" */
    '\x01','P','A','T','H','_','Z','E','R','O','_','L','E','N','G','T','H',
/* 0x16486 = "VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE" */
    '\x01','\x95','\xbd','\x86','I','M','A','G','E','_','M','A','C','H','I','N','E',
/* 0x16497 = "VERR_SUPLIB_INVALID_ARGV0_INTERNAL" */
    '\x01','\xd5','\x05','A','R','G','V','0','_','I','N','T','E','R','N','A','L',
/* 0x164a8 = "Encoding skipped." */
    'E','n','c','o','d','i','n','g',' ','s','k','i','p','p','e','d','.',
/* 0x164b9 = "RamPreAlloc not set." */
    'R','a','m','P','r','e','A','l','l','o','c',' ','\x08','s','e','t','.',
/* 0x164ca = "Out of range enum value." */
    'O','u','t',' ','\x15','r','a','n','g','e',' ','e','n','u','m',' ','\xf3',
/* 0x164db = "VERR_S3_ACCESS_DENIED" */
    '\x01','S','3','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x164ec = "VINF_EM_RAW_IRET_TRAP" */
    '\x0e','E','M','_','R','A','W','_','I','R','E','T','_','T','R','A','P',
/* 0x164fd = "Not a power of two." */
    'N','o','t',' ','a',' ','p','o','w','e','r',' ','\x15','t','w','o','.',
/* 0x1650e = "VERR_VFS_CHAIN_READ_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','R','E','A','D','_','O','N','L','Y','_','I','O','S',
/* 0x1651f = "Bad TRPM_TRAP_IN_OP." */
    '\x9d','T','R','P','M','_','T','R','A','P','_','I','N','_','O','P','.',
/* 0x16530 = "VERR_THREAD_NOT_WAITABLE" */
    '\x01','T','H','R','E','A','D','_','\x06','W','A','I','T','A','B','L','E',
/* 0x16541 = "VERR_PGM_PHYS_PAGE_BALLOONED" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','B','A','L','L','O','O','N','E','D',
/* 0x16552 = "VERR_DBGF_BP_L2_LOOKUP_FAILED" */
    '\x01','\xb9','_','B','P','_','L','2','_','L','O','O','K','U','P','_','\x16',
/* 0x16563 = "VERR_BUFFER_UNDERFLOW" */
    '\x01','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x16574 = "VERR_SSM_FIELD_INVALID_CALLBACK" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','C','A','L','L','B','A','C','K',
/* 0x16585 = "VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\xab','C','L','O','S','E','_','\x1a',
/* 0x16596 = "EVP_DecryptInit failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t',' ','\x7d',
/* 0x165a7 = "VERR_VD_IMAGE_READ_ONLY" */
    '\x01','\xff','I','M','A','G','E','_','R','E','A','D','_','O','N','L','Y',
/* 0x165b8 = "Internal processing error #2 in the DBGF stack code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','s','t','a','c','k',' ','\x83',
/* 0x165c9 = "VINF_VRDP_PROCESS_PDU" */
    '\x0e','V','R','D','P','_','P','R','O','C','E','S','S','_','P','D','U',
/* 0x165da = "VINF_GIM_R3_HYPERCALL" */
    '\x0e','G','I','M','_','R','3','_','H','Y','P','E','R','C','A','L','L',
/* 0x165eb = "Unsupported file system charset." */
    '\x97','\x1f','s','y','s','t','e','m',' ','c','h','a','r','s','e','t','.',
/* 0x165fc = "VERR_L4_DS_MANAGER_NOT_FOUND" */
    '\x01','L','4','_','D','S','_','M','A','N','A','G','E','R','_','\x06','\x2a',
/* 0x1660d = "Invalid I/O port handle." */
    '\x0c','I','/','O',' ','p','o','r','t',' ','h','a','n','d','l','e','.',
/* 0x1661e = "The I/O request is in progress." */
    '\x03','I','/','O',' ','\xaa','\x0b','\x0f','p','r','o','g','r','e','s','s','.',
/* 0x1662f = "VWRN_DANGLING_OBJECTS" */
    '\xe4','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x16640 = "VERR_DBG_NOT_NM_MAP_FILE" */
    '\x01','D','B','G','_','\x06','N','M','_','M','A','P','_','F','I','L','E',
/* 0x16651 = "VERR_POLL_SET_IS_FULL" */
    '\x01','P','O','L','L','_','S','E','T','_','I','S','_','F','U','L','L',
/* 0x16662 = "VINF_VHWA_CMD_PENDING" */
    '\x0e','V','H','W','A','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x16673 = "Pipe is not connected." */
    'P','i','p','e',' ','\x0b','\x08','c','o','n','n','e','c','t','e','d','.',
/* 0x16684 = "VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','\xb5','_','\x19','_','P','A','T','H','_','O','N','L','Y',
/* 0x16695 = "Unexpected end of DWARF unit." */
    '\x94','e','n','d',' ','\x15','D','W','A','R','F',' ','u','n','i','t','.',
/* 0x166a6 = "Stop the TCP server." */
    'S','t','o','p',' ','\x02','T','C','P',' ','s','e','r','v','e','r','.',
/* 0x166b7 = "VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED" */
    '\x01','\xff','I','M','A','G','E','_','R','E','P','A','I','R','_','\x06','\x82',
/* 0x166c8 = "VERR_OBJECT_DESTROYED" */
    '\x01','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x166d9 = "VINF_IEM_REEXEC_BREAK_FF" */
    '\x0e','\x9b','R','E','E','X','E','C','_','B','R','E','A','K','_','F','F',
/* 0x166ea = "VERR_NEM_MISSING_KERNEL_API_5" */
    '\x01','\xec','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','5',
/* 0x166fb = "VERR_VGA_INVALID_CUSTOM_MODE" */
    '\x01','V','G','A','_','\x05','C','U','S','T','O','M','_','M','O','D','E',
/* 0x1670c = "VERR_NEM_MISSING_KERNEL_API_1" */
    '\x01','\xec','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','1',
/* 0x1671d = "VERR_NEM_MISSING_KERNEL_API_2" */
    '\x01','\xec','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','2',
/* 0x1672e = "VERR_FTP_DATA_CONN_NOT_FOUND" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','\x06','\x2a',
/* 0x1673f = "Internal processing error #1 in the DBGF stack code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','s','t','a','c','k',' ','\x83',
/* 0x16750 = "Generic unexpected object ID error." */
    '\xa6','u','n','e','x','p','e','c','t','e','d',' ','\xa7','I','D',' ','\x84',
/* 0x16761 = "VERR_NEM_MISSING_KERNEL_API_3" */
    '\x01','\xec','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','3',
/* 0x16772 = "VERR_IS_A_CHAR_DEVICE" */
    '\x01','I','S','_','A','_','C','H','A','R','_','D','E','V','I','C','E',
/* 0x16783 = "The tar header is all zeros." */
    '\x03','t','a','r',' ','\xb3','\x0b','a','l','l',' ','z','e','r','o','s','.',
/* 0x16794 = "VERR_RECORDING_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','I','N','I','T','_','\x16',
/* 0x167a5 = "VERR_SSM_GCPHYS_OVERFLOW" */
    '\x01','\xb0','G','C','P','H','Y','S','_','O','V','E','R','F','L','O','W',
/* 0x167b6 = "VERR_VD_IMAGE_CORRUPTED" */
    '\x01','\xff','I','M','A','G','E','_','C','O','R','R','U','P','T','E','D',
/* 0x167c7 = "Bad file mode for XAR file." */
    '\x9d','\x1f','m','o','d','e',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x167d8 = "VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','\xbc','_','\x06','\x82',
/* 0x167e9 = "The block driver type wasn\'t supported." */
    '\x03','b','l','o','c','k',' ','\xc5','\xf1','w','a','s','n','\'','t',' ','\xa4',
/* 0x167fa = "VINF_IPC_SEND_MSG_CUT" */
    '\x0e','I','P','C','_','S','E','N','D','_','M','S','G','_','C','U','T',
/* 0x1680b = "Unsupported CPU ID register." */
    '\x97','C','P','U',' ','I','D',' ','r','e','g','i','s','t','e','r','.',
/* 0x1681c = "VERR_DBG_ADDRESS_WRAP" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','W','R','A','P',
/* 0x1682d = "VERR_NET_OPERATION_NOT_SUPPORTED" */
    '\x01','N','E','T','_','O','P','E','R','A','T','I','O','N','_','\x06','\x82',
/* 0x1683e = "VERR_NEM_MISSING_KERNEL_API_4" */
    '\x01','\xec','_','\xc4','_','K','E','R','N','E','L','_','A','P','I','_','4',
/* 0x1684f = "Unit header integrity error." */
    'U','n','i','t',' ','\xb3','i','n','t','e','g','r','i','t','y',' ','\x84',
/* 0x16860 = "VERR_DANGLING_OBJECTS" */
    '\x01','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x16871 = "VERR_DBGF_NO_MORE_BP_SLOTS" */
    '\x01','\xb9','_','\x60','M','O','R','E','_','B','P','_','S','L','O','T','S',
/* 0x16882 = "VINF_SSM_DONT_CALL_AGAIN" */
    '\x0e','\xb0','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x16893 = "VERR_CFGM_INVALID_CHILD_PATH" */
    '\x01','C','F','G','M','_','\x05','C','H','I','L','D','_','P','A','T','H',
/* 0x168a4 = "Unable to parse string as bool." */
    '\xde','\x0a','p','a','r','s','e',' ','\xf0','a','s',' ','b','o','o','l','.',
/* 0x168b5 = "VERR_PATCHING_REFUSED" */
    '\x01','P','A','T','C','H','I','N','G','_','R','E','F','U','S','E','D',
/* 0x168c6 = "A reboot is needed." */
    'A',' ','r','e','b','o','o','t',' ','\x0b','n','e','e','d','e','d','.',
/* 0x168d7 = "VERR_SYMLINK_NOT_ALLOWED" */
    '\x01','S','Y','M','L','I','N','K','_','\x06','A','L','L','O','W','E','D',
/* 0x168e8 = "Call interrupted." */
    'C','a','l','l',' ','i','n','t','e','r','r','u','p','t','e','d','.',
/* 0x168f9 = "Unknown location opcode." */
    '\xf8','l','o','c','a','t','i','o','n',' ','o','p','c','o','d','e','.',
/* 0x1690a = "VERR_DBGC_PARSE_EMPTY_ARGUMENT" */
    '\x01','\xfb','\xe2','E','M','P','T','Y','_','A','R','G','U','M','E','N','T',
/* 0x1691b = "VINF_BUFFER_UNDERFLOW" */
    '\x0e','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1692c = "VERR_SUP_VP_NT_QI_THREAD_ERROR" */
    '\x01','\x95','\xbd','N','T','_','Q','I','_','T','H','R','E','A','D','_','\x1a',
/* 0x1693d = "VERR_FILE_AIO_IN_PROGRESS" */
    '\x01','\xab','A','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1694e = "VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE" */
    '\x01','\x24','\x89','\x1c','D','E','E','P','_','D','I','R','_','T','R','E','E',
/* 0x1695f = "Bad forwarder entry." */
    '\x9d','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x16970 = "VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS" */
    '\x01','\xfb','\xe2','\x1c','F','E','W','_','A','R','G','U','M','E','N','T','S',
/* 0x16981 = "VERR_VFS_CHAIN_ONLY_DIR_OR_VFS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','D','I','R','_','O','R','_','\x8d',
/* 0x16992 = "No logger instance." */
    '\xe6','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e','.',
/* 0x169a3 = "No node was specified." */
    '\xe6','n','o','d','e',' ','\x11','s','p','e','c','i','f','i','e','d','.',
/* 0x169b4 = "EVP_EncryptInit failed." */
    'E','V','P','_','E','n','c','r','y','p','t','I','n','i','t',' ','\x7d',
/* 0x169c5 = "VERR_SSM_INTEGRITY_DECOMPRESSION" */
    '\x01','\xb0','\xf5','_','D','E','C','O','M','P','R','E','S','S','I','O','N',
/* 0x169d6 = "VERR_IPC_SEND_ABORTED" */
    '\x01','I','P','C','_','S','E','N','D','_','A','B','O','R','T','E','D',
/* 0x169e7 = "VERR_PKZIP_NAME_TOO_LONG" */
    '\x01','P','K','Z','I','P','_','N','A','M','E','_','\x1c','L','O','N','G',
/* 0x169f8 = "VERR_SUPDRV_TRACER_NOT_PRESENT" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','P','R','E','S','E','N','T',
/* 0x16a09 = "Device i/o: CRC error." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','C','R','C',' ','\x84',
/* 0x16a1a = "Zero length path." */
    'Z','e','r','o',' ','l','e','n','g','t','h',' ','p','a','t','h','.',
/* 0x16a2b = "Generic USB device structure version mismatch." */
    '\xa6','U','S','B',' ','\xa3','\xea','\xcf','m','i','s','m','a','t','c','h','.',
/* 0x16a3c = "Stop the UDP server." */
    'S','t','o','p',' ','\x02','U','D','P',' ','s','e','r','v','e','r','.',
/* 0x16a4d = "VERR_SUP_VP_NO_NTDLL_MAPPING" */
    '\x01','\x95','\xbd','\x60','N','T','D','L','L','_','M','A','P','P','I','N','G',
/* 0x16a5e = "VERR_URI_INVALID_PORT_NUMBER" */
    '\x01','U','R','I','_','\x05','P','O','R','T','_','N','U','M','B','E','R',
/* 0x16a6f = "VERR_TRPM_BAD_TRAP_IN_OP" */
    '\x01','T','R','P','M','_','\x1d','T','R','A','P','_','I','N','_','O','P',
/* 0x16a80 = "VERR_NET_TOO_MANY_REFERENCES" */
    '\x01','N','E','T','_','\x1c','\xaf','R','E','F','E','R','E','N','C','E','S',
/* 0x16a91 = "VERR_XAR_WRONG_MAGIC" */
    '\x01','X','A','R','_','W','R','O','N','G','_','M','A','G','I','C',
/* 0x16aa1 = "VERR_ISOMK_RR_SPILL_FILE_FULL" */
    '\x01','\x24','R','R','_','S','P','I','L','L','_','\xab','F','U','L','L',
/* 0x16ab1 = "Net host name not found." */
    'N','e','t',' ','h','o','s','t',' ','n','a','m','e',' ','\x08','\x88',
/* 0x16ac1 = "VERR_LDR_NO_IMAGE_UUID" */
    '\x01','L','D','R','_','\x60','I','M','A','G','E','_','U','U','I','D',
/* 0x16ad1 = "Encountered an unknown type flag." */
    '\xa5','\x87','u','n','k','n','o','w','n',' ','\xf1','f','l','a','g','.',
/* 0x16ae1 = "VERR_TM_GIP_REQUIRED" */
    '\x01','T','M','_','G','I','P','_','R','E','Q','U','I','R','E','D',
/* 0x16af1 = "VERR_HGCM_SERVICE_NOT_FOUND" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','\x06','\x2a',
/* 0x16b01 = "VERR_BUFFER_OVERFLOW" */
    '\x01','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x16b11 = "VERR_TCP_SERVER_STOP" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x16b21 = "VERR_ASN1_CURSOR_NOT_AT_END" */
    '\x01','\xa1','C','U','R','S','O','R','_','\x06','A','T','_','E','N','D',
/* 0x16b31 = "VERR_LDRPE_GLOBALPTR" */
    '\x01','L','D','R','P','E','_','G','L','O','B','A','L','P','T','R',
/* 0x16b41 = "VERR_DIS_GEN_FAILURE" */
    '\x01','D','I','S','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x16b51 = "VERR_PAGE_TABLE_NOT_PRESENT" */
    '\x01','\xdb','T','A','B','L','E','_','\x06','P','R','E','S','E','N','T',
/* 0x16b61 = "VERR_NEM_UNMAP_PAGES_FAILED" */
    '\x01','\xec','_','U','N','M','A','P','_','P','A','G','E','S','_','\x16',
/* 0x16b71 = "VERR_PDM_USB_NAME_CLASH" */
    '\x01','\x5e','U','S','B','_','N','A','M','E','_','C','L','A','S','H',
/* 0x16b81 = "VERR_SUP_VP_BAD_SIZE_OF_HEADERS" */
    '\x01','\x95','\xbd','\x1d','\xfe','_','O','F','_','H','E','A','D','E','R','S',
/* 0x16b91 = "VERR_PDM_NO_DMAC_INSTANCE" */
    '\x01','\x5e','\x60','D','M','A','C','_','I','N','S','T','A','N','C','E',
/* 0x16ba1 = "VERR_VMX_INVALID_VMCS_LAUNCH_STATE" */
    '\x01','\xe1','\x05','V','M','C','S','_','L','A','U','N','C','H','_','\xef',
/* 0x16bb1 = "Expected RSA public key." */
    '\xb8','R','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x16bc1 = "VERR_VM_THREAD_IS_EMT" */
    '\x01','\xcc','_','T','H','R','E','A','D','_','I','S','_','E','M','T',
/* 0X16bd1 = "Too many ROM ranges." */
    'o','o',' ','\xb4','R','O','M',' ','r','a','n','g','e','s','.',
/* 0x16be0 = "Internal processing error in the critical section code." */
    '\x07','\x04','\x09','\x0f','\x02','c','r','i','t','i','c','a','l',' ','\xda','\x83',
/* 0x16bf0 = "VINF_HM_PENDING_XCPT" */
    '\x0e','H','M','_','P','E','N','D','I','N','G','_','X','C','P','T',
/* 0x16c00 = "VERR_UDP_SERVER_STOP" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x16c10 = "Normalization of ASN." */
    'N','o','r','m','a','l','i','z','a','t','i','o','n',' ','\x15','\xf4',
/* 0x16c20 = "VERR_CR_PKCS7_SIGNER_INFO_VERSION" */
    '\x01','\x22','\xe3','S','I','G','N','E','R','_','I','N','F','O','_','\xbc',
/* 0x16c30 = "VERR_PGM_PHYS_PAGE_RESERVED" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','R','E','S','E','R','V','E','D',
/* 0x16c40 = "VERR_VM_DRIVER_OPEN_ERROR" */
    '\x01','\xcc','_','D','R','I','V','E','R','_','O','P','E','N','_','\x1a',
/* 0x16c50 = "VERR_VMM_HYPER_CR3_MISMATCH" */
    '\x01','V','M','M','_','H','Y','P','E','R','_','C','R','3','_','\x19',
/* 0x16c60 = "VERR_XAR_BAD_FILE_DEVICE_NO" */
    '\x01','X','A','R','_','\x1d','\xab','D','E','V','I','C','E','_','N','O',
/* 0x16c70 = "VERR_LDRVI_BAD_CERT_MULTIPLE" */
    '\x01','\xf2','\x1d','C','E','R','T','_','M','U','L','T','I','P','L','E',
/* 0x16c80 = "VERR_IEM_FIXUP_OUT_OF_MEMORY" */
    '\x01','\x9b','F','I','X','U','P','_','O','U','T','_','O','F','_','\xb6',
/* 0x16c90 = "VERR_XAR_MISSING_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\xc4','_','\xfe','_','E','L','E','M','E','N','T',
/* 0x16ca0 = "SSL connection error." */
    'S','S','L',' ','c','o','n','n','e','c','t','i','o','n',' ','\x84',
/* 0x16cb0 = "VERR_FLOAT_UNDERFLOW" */
    '\x01','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x16cc0 = "VERR_CR_PKIX_GENERIC_ERROR" */
    '\x01','\x22','P','K','I','X','_','G','E','N','E','R','I','C','_','\x1a',
/* 0x16cd0 = "VERR_VMX_NOT_IN_VMX_ROOT_MODE" */
    '\x01','\xe1','\x06','I','N','_','\xe1','R','O','O','T','_','M','O','D','E',
/* 0x16ce0 = "VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY" */
    '\x01','\x95','\xbd','E','X','E','_','\xc4','_','F','O','R','C','E','_','\xf5',
/* 0x16cf0 = "VERR_SELM_GDT_READ_ERROR" */
    '\x01','S','E','L','M','_','G','D','T','_','R','E','A','D','_','\x1a',
/* 0x16d00 = "VINF_PATM_SPINLOCK_FAILED" */
    '\x0e','P','A','T','M','_','S','P','I','N','L','O','C','K','_','\x16',
/* 0x16d10 = "VINF_BUFFER_OVERFLOW" */
    '\x0e','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x16d20 = "VERR_PDM_USB_HUB_EXISTS" */
    '\x01','\x5e','U','S','B','_','H','U','B','_','E','X','I','S','T','S',
/* 0x16d30 = "VERR_TRAILING_SPACES" */
    '\x01','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x16d40 = "Bad MH_OBJECT file." */
    '\x9d','M','H','_','O','B','J','E','C','T',' ','f','i','l','e','.',
/* 0x16d50 = "VERR_ASN1_TOO_DEEPLY_NESTED" */
    '\x01','\xa1','\x1c','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x16d60 = "VERR_NET_UNREACHABLE" */
    '\x01','N','E','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x16d70 = "VERR_PDM_THREAD_INVALID_CALLER" */
    '\x01','\x5e','T','H','R','E','A','D','_','\x05','C','A','L','L','E','R',
/* 0x16d80 = "VINF_IOM_MMIO_UNUSED_FF" */
    '\x0e','I','O','M','_','\xd2','_','U','N','U','S','E','D','_','F','F',
/* 0x16d90 = "Unknown or invalid GIM provider." */
    '\xf8','\xa9','\x8f','G','I','M',' ','p','r','o','v','i','d','e','r','.',
/* 0x16da0 = "VMDK: Invalid image file header." */
    'V','M','D','K',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x16db0 = "VERR_LDRVI_INVALID_SECTION_COUNT" */
    '\x01','\xf2','\x05','S','E','C','T','I','O','N','_','C','O','U','N','T',
/* 0x16dc0 = "VERR_DBGF_HYPER_DB_XCPT" */
    '\x01','\xb9','_','H','Y','P','E','R','_','D','B','_','X','C','P','T',
/* 0x16dd0 = "Internal processing error in the page allocator." */
    '\x07','\x04','\x09','\x0f','\x02','\xcb','a','l','l','o','c','a','t','o','r','.',
/* 0x16de0 = "VERR_JSON_INVALID_CODEPOINT" */
    '\x01','J','S','O','N','_','\x05','C','O','D','E','P','O','I','N','T',
/* 0x16df0 = "VERR_IOM_NO_R3_MMIO_RANGE" */
    '\x01','I','O','M','_','\x60','R','3','_','\xd2','_','R','A','N','G','E',
/* 0x16e00 = "VINF_EM_TRIPLE_FAULT" */
    '\x0e','E','M','_','T','R','I','P','L','E','_','F','A','U','L','T',
/* 0x16e10 = "The system has too many CPUs." */
    '\x03','s','y','s','t','e','m',' ','\x7b','\xa0','\xb4','C','P','U','s','.',
/* 0x16e20 = "VERR_INTNET_FLT_IF_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x16',
/* 0x16e30 = "VERR_CPUM_INVALID_XSAVE_HDR" */
    '\x01','C','P','U','M','_','\x05','X','S','A','V','E','_','H','D','R',
/* 0x16e40 = "VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS" */
    '\x01','\x22','\xe3','\x1c','\xaf','\xbe','A','L','G','O','R','I','T','H','M','S',
/* 0x16e50 = "Generic no change info." */
    '\xa6','n','o',' ','c','h','a','n','g','e',' ','i','n','f','o','.',
/* 0x16e60 = "Bad DWARF position." */
    '\x9d','D','W','A','R','F',' ','p','o','s','i','t','i','o','n','.',
/* 0x16e70 = "VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID" */
    '\x01','\xa2','\x91','P','A','R','T','_','M','A','P','_','\xb5','_','I','D',
/* 0x16e80 = "VERR_PATCH_NO_CONFLICT" */
    '\x01','P','A','T','C','H','_','\x60','C','O','N','F','L','I','C','T',
/* 0x16e90 = "VERR_VD_VDI_INVALID_SIGNATURE" */
    '\x01','\xff','V','D','I','_','\x05','S','I','G','N','A','T','U','R','E',
/* 0x16ea0 = "Too many RAM ranges." */
    'T','o','o',' ','\xb4','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x16eb0 = "Generic not found warning." */
    '\xa6','\x08','f','o','u','n','d',' ','w','a','r','n','i','n','g','.',
/* 0x16ec0 = "VERR_PATCH_ALREADY_DISABLED" */
    '\x01','P','A','T','C','H','_','\x9a','D','I','S','A','B','L','E','D',
/* 0x16ed0 = "VERR_TAR_END_OF_FILE" */
    '\x01','T','A','R','_','E','N','D','_','O','F','_','F','I','L','E',
/* 0x16ee0 = "Vote for giving up." */
    'V','o','t','e',' ','\x10','g','i','v','i','n','g',' ','u','p','.',
/* 0x16ef0 = "Logical Unit was not found." */
    'L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x11','\x08','\x88',
/* 0x16f00 = "Generic VM-exit failure." */
    '\xa6','\xcc','-','e','x','i','t',' ','f','a','i','l','u','r','e','.',
/* 0x16f10 = "VERR_CFGM_INVALID_NODE_PATH" */
    '\x01','C','F','G','M','_','\x05','N','O','D','E','_','P','A','T','H',
/* 0x16f20 = "Bad argument flags." */
    '\x9d','a','r','g','u','m','e','n','t',' ','f','l','a','g','s','.',
/* 0x16f30 = "Image Verification Failure:." */
    'I','m','a','g','e',' ','\x0d','F','a','i','l','u','r','e',':','.',
/* 0x16f40 = "A component value of an ASN." */
    'A',' ','c','o','m','p','o','n','e','n','t',' ','\xfa','\x15','\x87','\xf4',
/* 0x16f50 = "VERR_SUPDRV_VTG_STRTAB_OFF" */
    '\x01','\x90','V','T','G','_','S','T','R','T','A','B','_','O','F','F',
/* 0x16f60 = "The XAR table of content digest doesn't match." */
    '\x03','X','A','R',' ','\xb1','\x15','\xed','\xd6','\xc7','m','a','t','c','h','.',
/* 0x16f70 = "VERR_LDR_INVALID_SEG_OFFSET" */
    '\x01','L','D','R','_','\x05','S','E','G','_','O','F','F','S','E','T',
/* 0x16f80 = "VERR_TAR_MODE_WITH_TYPE" */
    '\x01','T','A','R','_','M','O','D','E','_','W','I','T','H','_','\xb5',
/* 0x16f90 = "VERR_HM_ALREADY_ENABLED_IPE" */
    '\x01','H','M','_','\x9a','E','N','A','B','L','E','D','_','I','P','E',
/* 0x16fa0 = "VERR_PDM_CRITSECTRW_IPE" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','R','W','_','I','P','E',
/* 0x16fb0 = "VERR_MM_RAM_CONFLICT" */
    '\x01','M','M','_','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x16fc0 = "VWRN_FLOAT_UNDERFLOW" */
    '\xe4','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x16fd0 = "VERR_SEM_LV_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','D','E','A','D','L','O','C','K',
/* 0x16fe0 = "VERR_SUP_VP_SYSTEM32_PATH" */
    '\x01','\x95','\xbd','S','Y','S','T','E','M','3','2','_','P','A','T','H',
/* 0x16ff0 = "VERR_NET_PROTOCOL_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x06','\x82',
/* 0x17000 = "VERR_PROCESS_RUNNING" */
    '\x01','P','R','O','C','E','S','S','_','R','U','N','N','I','N','G',
/* 0x17010 = "VERR_NAT_REDIR_SETUP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','S','E','T','U','P',
/* 0x17020 = "VERR_CR_RANDOM_SETUP_FAILED" */
    '\x01','\x22','R','A','N','D','O','M','_','S','E','T','U','P','_','\x16',
/* 0x17030 = "VERR_TAR_BASE_256_NOT_SUPPORTED" */
    '\x01','T','A','R','_','B','A','S','E','_','2','5','6','_','\x06','\x82',
/* 0x17040 = "VERR_CR_OPENSSL_VERSION_TOO_OLD" */
    '\x01','\x22','O','P','E','N','S','S','L','_','\xbc','_','\x1c','O','L','D',
/* 0x17050 = "Error getting the file mode." */
    '\xc0','g','e','t','t','i','n','g',' ','\x02','\x1f','m','o','d','e','.',
/* 0x17060 = "The specified data unit wasn\'t found." */
    '\x03','\x18','\x9c','u','n','i','t',' ','w','a','s','n','\'','t',' ','\x88',
/* 0x17070 = "VINF_VMM_CALL_TRACER" */
    '\x0e','V','M','M','_','C','A','L','L','_','T','R','A','C','E','R',
/* 0x17080 = "VINF_IOM_MMIO_UNUSED_00" */
    '\x0e','I','O','M','_','\xd2','_','U','N','U','S','E','D','_','0','0',
/* 0x17090 = "Trailing spaces." */
    'T','r','a','i','l','i','n','g',' ','s','p','a','c','e','s','.',
/* 0x170a0 = "VINF_HM_DOUBLE_FAULT" */
    '\x0e','H','M','_','D','O','U','B','L','E','_','F','A','U','L','T',
/* 0x170b0 = "The poll set is full." */
    '\x03','p','o','l','l',' ','s','e','t',' ','\x0b','f','u','l','l','.',
/* 0x170c0 = "VERR_PDM_DRVINS_NO_ATTACH" */
    '\x01','\x5e','D','R','V','I','N','S','_','\x60','A','T','T','A','C','H',
/* 0x170d0 = "VERR_NET_SOCKET_TYPE_NOT_SUPPORTED" */
    '\x01','N','E','T','_','S','O','C','K','E','T','_','\xb5','_','\x06','\x82',
/* 0x170e0 = "VERR_SSM_GCPTR_OVERFLOW" */
    '\x01','\xb0','G','C','P','T','R','_','O','V','E','R','F','L','O','W',
/* 0x170f0 = "VERR_HOSTIF_BLOCKING" */
    '\x01','H','O','S','T','I','F','_','B','L','O','C','K','I','N','G',
/* 0x17100 = "VERR_VMM_SWITCHER_IPE_1" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','\x14','1',
/* 0x17110 = "VERR_CALLBACK_RETURN" */
    '\x01','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x17120 = "VINF_PGM_GCPHYS_ALIASED" */
    '\x0e','\x8c','G','C','P','H','Y','S','_','A','L','I','A','S','E','D',
/* 0x17130 = "VERR_IEM_LABEL_OUT_OF_MEMORY" */
    '\x01','\x9b','L','A','B','E','L','_','O','U','T','_','O','F','_','\xb6',
/* 0x17140 = "Unsupported file system format." */
    '\x97','\x1f','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x17150 = "VERR_URI_INVALID_ESCAPE_SEQ" */
    '\x01','U','R','I','_','\x05','E','S','C','A','P','E','_','S','E','Q',
/* 0x17160 = "Too many semaphores." */
    'T','o','o',' ','\xb4','s','e','m','a','p','h','o','r','e','s','.',
/* 0x17170 = "VERR_EXCL_SEM_ALREADY_OWNED" */
    '\x01','E','X','C','L','_','S','E','M','_','\x9a','O','W','N','E','D',
/* 0x17180 = "VERR_PDM_DEVINS_NO_ATTACH" */
    '\x01','\x5e','D','E','V','I','N','S','_','\x60','A','T','T','A','C','H',
/* 0x17190 = "VINF_PDM_PCI_DO_DEFAULT" */
    '\x0e','\x5e','P','C','I','_','D','O','_','D','E','F','A','U','L','T',
/* 0x171a0 = "VERR_CR_KEY_PASSWORD_ENCODING" */
    '\x01','\x22','K','E','Y','_','P','A','S','S','W','O','R','D','_','\xc6',
/* 0x171b0 = "Image Verification Failure: Invalid section count." */
    'I','m','a','g','e',' ','\x0d','\x12','\x0c','\xda','c','o','u','n','t','.',
/* 0x171c0 = "VINF_GVM_NOT_BUSY_IN_GC" */
    '\x0e','G','V','M','_','\x06','B','U','S','Y','_','I','N','_','G','C',
/* 0x171d0 = "VERR_ISOFS_BAD_LVD_DOMAIN_ID" */
    '\x01','\xa2','\x1d','L','V','D','_','D','O','M','A','I','N','_','I','D',
/* 0x171e0 = "Patch was already enabled." */
    'P','a','t','c','h',' ','\x11','\x7f','e','n','a','b','l','e','d','.',
/* 0x171f0 = "VERR_SUP_VP_TOO_MANY_DLLS_LOADED" */
    '\x01','\x95','\xbd','\x1c','\xaf','D','L','L','S','_','L','O','A','D','E','D',
/* 0x17200 = "Internal processing error #1 in the DBGF core code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','c','o','r','e',' ','\x83',
/* 0x17210 = "VERR_SSM_LOADED_TOO_LITTLE" */
    '\x01','\xb0','L','O','A','D','E','D','_','\x1c','L','I','T','T','L','E',
/* 0x17220 = "VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL" */
    '\x01','\x22','\xe3','\xbe','P','A','R','A','M','S','_','\x06','I','M','P','L',
/* 0x17230 = "VERR_SUP_VP_TOO_LARGE_REGION" */
    '\x01','\x95','\xbd','\x1c','L','A','R','G','E','_','R','E','G','I','O','N',
/* 0x17240 = "VERR_LDRMACHO_BAD_SECTION_ORDER" */
    '\x01','\xe7','\x1d','S','E','C','T','I','O','N','_','O','R','D','E','R',
/* 0x17250 = "VERR_SUPLIB_PATH_NOT_ABSOLUTE" */
    '\x01','\xd5','P','A','T','H','_','\x06','A','B','S','O','L','U','T','E',
/* 0x17260 = "VERR_GENERAL_FAILURE" */
    '\x01','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x17270 = "VERR_CR_PKCS7_OSSL_VERIFY_FAILED" */
    '\x01','\x22','\xe3','O','S','S','L','_','V','E','R','I','F','Y','_','\x16',
/* 0x17280 = "Invalid segment offset." */
    '\x0c','s','e','g','m','e','n','t',' ','o','f','f','s','e','t','.',
/* 0x17290 = "VERR_TM_INVALID_TIMER_QUEUE" */
    '\x01','T','M','_','\x05','T','I','M','E','R','_','Q','U','E','U','E',
/* 0x172a0 = "VERR_VRDP_PROTOCOL_ERROR" */
    '\x01','V','R','D','P','_','P','R','O','T','O','C','O','L','_','\x1a',
/* 0x172b0 = "VERR_FILE_LOCK_VIOLATION" */
    '\x01','\xab','L','O','C','K','_','V','I','O','L','A','T','I','O','N',
/* 0x172c0 = "VERR_CR_PKCS7_NO_SIGNER_INFOS" */
    '\x01','\x22','\xe3','\x60','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x172d0 = "VERR_HARDAVL_BAD_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\x1d','H','E','I','G','H','T',
/* 0X172e0 = "TM requires GIP." */
    'M',' ','r','e','q','u','i','r','e','s',' ','G','I','P','.',
/* 0x172ef = "The support driver is not accessible." */
    '\x03','\xce','\xc5','\x0b','\x08','a','c','c','e','s','s','i','b','l','e','.',
/* 0x172ff = "VINF_PATM_PATCH_INT3" */
    '\x0e','P','A','T','M','_','P','A','T','C','H','_','I','N','T','3',
/* 0x1730f = "Bad VTG attribute value." */
    '\x9d','V','T','G',' ','a','t','t','r','i','b','u','t','e',' ','\xf3',
/* 0x1731f = "Failed to map a memory object." */
    '\x8b','\x0a','m','a','p',' ','a',' ','\x85','o','b','j','e','c','t','.',
/* 0x1732f = "VERR_RESOURCE_IN_USE" */
    '\x01','R','E','S','O','U','R','C','E','_','I','N','_','U','S','E',
/* 0x1733f = "VINF_UDP_SERVER_STOP" */
    '\x0e','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1734f = "VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING" */
    '\x01','\xa1','\x05','U','N','I','V','E','R','S','A','L','_','\xd4','_','\xc6',
/* 0x1735f = "VERR_ALLOCATION_TOO_BIG" */
    '\x01','A','L','L','O','C','A','T','I','O','N','_','\x1c','B','I','G',
/* 0x1736f = "Already patched." */
    'A','l','r','e','a','d','y',' ','p','a','t','c','h','e','d','.',
/* 0x1737f = "Comment string is too long." */
    'C','o','m','m','e','n','t',' ','\xf0','\x0b','\xa0','l','o','n','g','.',
/* 0x1738f = "VERR_CR_X509_CPB_BAD_CERT_CTX" */
    '\x01','\x22','\xb7','C','P','B','_','\x1d','C','E','R','T','_','C','T','X',
/* 0x1739f = "The key was decrypted." */
    '\x03','k','e','y',' ','\x11','d','e','c','r','y','p','t','e','d','.',
/* 0x173af = "VERR_PGM_DYNMAP_SETUP_ERROR" */
    '\x01','\x8c','D','Y','N','M','A','P','_','S','E','T','U','P','_','\x1a',
/* 0x173bf = "VERR_SEM_OUT_OF_TURN" */
    '\x01','S','E','M','_','O','U','T','_','O','F','_','T','U','R','N',
/* 0x173cf = "VINF_TCP_SERVER_STOP" */
    '\x0e','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x173df = "VERR_PIPE_NOT_CONNECTED" */
    '\x01','P','I','P','E','_','\x06','C','O','N','N','E','C','T','E','D',
/* 0x173ef = "VERR_HGCM_INVALID_CLIENT_ID" */
    '\x01','H','G','C','M','_','\x05','C','L','I','E','N','T','_','I','D',
/* 0x173ff = "Syntax error - invalid operation attempted." */
    '\xf7','\x09','-',' ','\x8f','\x96','a','t','t','e','m','p','t','e','d','.',
/* 0x1740f = "VINF_VMM_UNKNOWN_RING3_CALL" */
    '\x0e','V','M','M','_','\x91','R','I','N','G','3','_','C','A','L','L',
/* 0x1741f = "VERR_DIS_TOO_LONG_INSTR" */
    '\x01','D','I','S','_','\x1c','L','O','N','G','_','I','N','S','T','R',
/* 0x1742f = "VERR_TM_TSC_ALREADY_TICKING" */
    '\x01','T','M','_','T','S','C','_','\x9a','T','I','C','K','I','N','G',
/* 0x1743f = "VERR_SUPLIB_WORLD_WRITABLE" */
    '\x01','\xd5','W','O','R','L','D','_','W','R','I','T','A','B','L','E',
/* 0x1744f = "Patch installed." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','e','d','.',
/* 0x1745f = "VERR_FILE_AIO_NOT_SUBMITTED" */
    '\x01','\xab','A','I','O','_','\x06','S','U','B','M','I','T','T','E','D',
/* 0x1746f = "VERR_ISOMK_IPE_BOOT_CAT_FILE" */
    '\x01','\x24','\x14','B','O','O','T','_','C','A','T','_','F','I','L','E',
/* 0x1747f = "VERR_GIM_HYPERCALL_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\x16',
/* 0x1748f = "VERR_DVM_MAP_NO_VOLUME" */
    '\x01','D','V','M','_','M','A','P','_','\x60','V','O','L','U','M','E',
/* 0x1749f = "VERR_PDM_MEDIA_NOT_MOUNTED" */
    '\x01','\x5e','M','E','D','I','A','_','\x06','M','O','U','N','T','E','D',
/* 0x174af = "VERR_PDM_NO_APIC_INSTANCE" */
    '\x01','\x5e','\x60','A','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x174bf = "VERR_GIM_OPERATION_FAILED" */
    '\x01','G','I','M','_','O','P','E','R','A','T','I','O','N','_','\x16',
/* 0x174cf = "The table of content (TOC) is too big." */
    '\x03','\xb1','\x15','\xed','(','T','O','C',')',' ','\x0b','\xa0','b','i','g','.',
/* 0x174df = "Receive timeout." */
    'R','e','c','e','i','v','e',' ','t','i','m','e','o','u','t','.',
/* 0x174ef = "VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x1c','M','U','C','H',
/* 0x174ff = "VERR_TAR_BAD_MODE_FIELD" */
    '\x01','T','A','R','_','\x1d','M','O','D','E','_','F','I','E','L','D',
/* 0x1750f = "The I/O request was canceled." */
    '\x03','I','/','O',' ','\xaa','\x11','c','a','n','c','e','l','e','d','.',
/* 0x1751f = "Fatal EMT wait error." */
    'F','a','t','a','l',' ','E','M','T',' ','w','a','i','t',' ','\x84',
/* 0x1752f = "VERR_DWARF_ABBREV_NOT_FOUND" */
    '\x01','D','W','A','R','F','_','A','B','B','R','E','V','_','\x06','\x2a',
/* 0x1753f = "Unknown file system format." */
    '\xf8','\x1f','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1754f = "Unbalanced tree." */
    'U','n','b','a','l','a','n','c','e','d',' ','t','r','e','e','.',
/* 0x1755f = "VERR_WEB_INVALID_SESSION_ID" */
    '\x01','W','E','B','_','\x05','S','E','S','S','I','O','N','_','I','D',
/* 0x1756f = "VERR_TM_TIMER_BAD_CLOCK" */
    '\x01','T','M','_','T','I','M','E','R','_','\x1d','C','L','O','C','K',
/* 0x1757f = "Invalid opcode byte(s)." */
    '\x0c','o','p','c','o','d','e',' ','b','y','t','e','(','s',')','.',
/* 0x1758f = "VERR_PRIVILEGE_NOT_HELD" */
    '\x01','P','R','I','V','I','L','E','G','E','_','\x06','H','E','L','D',
/* 0x1759f = "VERR_IEM_VAR_DUP_ARG_NO" */
    '\x01','\x9b','V','A','R','_','D','U','P','_','A','R','G','_','N','O',
/* 0x175af = "VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING" */
    '\x01','\xa1','\x05','P','R','I','N','T','A','B','L','E','_','\xd4','_','\xc6',
/* 0x175bf = "Local file header corrupt." */
    'L','o','c','a','l',' ','\x1f','\xb3','c','o','r','r','u','p','t','.',
/* 0x175cf = "Invalid name for XAR file." */
    '\x0c','n','a','m','e',' ','\x10','X','A','R',' ','f','i','l','e','.',
/* 0x175df = "VERR_CR_X509_NO_TRUST_ANCHOR" */
    '\x01','\x22','\xb7','\x60','T','R','U','S','T','_','A','N','C','H','O','R',
/* 0x175ef = "VERR_DBGF_NO_TRACE_BUFFER" */
    '\x01','\xb9','_','\x60','T','R','A','C','E','_','B','U','F','F','E','R',
/* 0x175ff = "VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\xab','O','P','E','N','_','\x1a',
/* 0x1760f = "Recompiler: Out of variables." */
    '\x13','O','u','t',' ','\x15','v','a','r','i','a','b','l','e','s','.',
/* 0x1761f = "VERR_SSM_SKIP_BACKWARDS" */
    '\x01','\xb0','S','K','I','P','_','B','A','C','K','W','A','R','D','S',
/* 0x1762f = "VERR_SUPDRV_TRACER_NOT_OPENED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x06','O','P','E','N','E','D',
/* 0x1763f = "VERR_TRPM_DONT_PANIC" */
    '\x01','T','R','P','M','_','D','O','N','T','_','P','A','N','I','C',
/* 0x1764f = "VERR_SUPDRV_TRACER_ALREADY_OPENED" */
    '\x01','\x90','T','R','A','C','E','R','_','\x9a','O','P','E','N','E','D',
/* 0x1765f = "Bad VTG bit count value." */
    '\x9d','V','T','G',' ','b','i','t',' ','c','o','u','n','t',' ','\xf3',
/* 0x1766f = "VERR_VM_DRIVER_LOAD_ERROR" */
    '\x01','\xcc','_','D','R','I','V','E','R','_','L','O','A','D','_','\x1a',
/* 0x1767f = "VINF_CALLBACK_RETURN" */
    '\x0e','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1768f = "VERR_TIMER_SUSPENDED" */
    '\x01','T','I','M','E','R','_','S','U','S','P','E','N','D','E','D',
/* 0x1769f = "VERR_HTTP_REDIRECTED" */
    '\x01','H','T','T','P','_','R','E','D','I','R','E','C','T','E','D',
/* 0x176af = "VERR_CR_PKCS7_NO_CERTIFICATES" */
    '\x01','\x22','\xe3','\x60','C','E','R','T','I','F','I','C','A','T','E','S',
/* 0x176bf = "Unexpected SVM patch type." */
    '\x94','S','V','M',' ','p','a','t','c','h',' ','t','y','p','e','.',
/* 0x176cf = "VERR_PGM_TOO_MANY_MMIO2_RANGES" */
    '\x01','\x8c','\x1c','\xaf','M','M','I','O','2','_','R','A','N','G','E','S',
/* 0x176df = "VINF_SSM_LIVE_SUSPENDED" */
    '\x0e','\xb0','L','I','V','E','_','S','U','S','P','E','N','D','E','D',
/* 0x176ef = "VERR_SUPDRV_VTG_BAD_PROBE_LOC" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','B','E','_','L','O','C',
/* 0x176ff = "VERR_TAR_ZERO_HEADER" */
    '\x01','T','A','R','_','Z','E','R','O','_','H','E','A','D','E','R',
/* 0X1770f = "Receive aborted." */
    'e','c','e','i','v','e',' ','a','b','o','r','t','e','d','.',
/* 0x1771e = "Invalid HGCM client id." */
    '\x0c','H','G','C','M',' ','c','l','i','e','n','t',' ','i','d','.',
/* 0x1772e = "VERR_XAR_BAD_FILE_TIMESTAMP" */
    '\x01','X','A','R','_','\x1d','\xab','T','I','M','E','S','T','A','M','P',
/* 0x1773e = "VERR_CR_PKCS7_SIGNED_DATA_VERSION" */
    '\x01','\x22','\xe3','S','I','G','N','E','D','_','D','A','T','A','_','\xbc',
/* 0x1774e = "VERR_PGM_MAPPINGS_FIXED" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','F','I','X','E','D',
/* 0x1775e = "Invalid Virtual CPU ID." */
    '\x0c','V','i','r','t','u','a','l',' ','C','P','U',' ','I','D','.',
/* 0x1776e = "VERR_CPUM_RAISE_GP_0" */
    '\x01','C','P','U','M','_','R','A','I','S','E','_','G','P','_','0',
/* 0x1777e = "VERR_NET_IN_PROGRESS" */
    '\x01','N','E','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1778e = "VERR_MEM_CACHE_MAX_SIZE" */
    '\x01','M','E','M','_','C','A','C','H','E','_','M','A','X','_','\xfe',
/* 0x1779e = "VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR" */
    '\x01','\x24','\x89','\x05','V','O','L','_','D','E','S','C','_','H','D','R',
/* 0x177ae = "VERR_SSM_INTEGRITY_REC_TERM_CRC" */
    '\x01','\xb0','\xf5','_','R','E','C','_','T','E','R','M','_','C','R','C',
/* 0x177be = "VERR_SUP_VP_THREAD_NOT_ALONE" */
    '\x01','\x95','\xbd','T','H','R','E','A','D','_','\x06','A','L','O','N','E',
/* 0x177ce = "VWRN_TRAILING_SPACES" */
    '\xe4','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x177de = "Too many open files." */
    'T','o','o',' ','\xb4','o','p','e','n',' ','f','i','l','e','s','.',
/* 0x177ee = "VERR_PDM_NO_RTC_INSTANCE" */
    '\x01','\x5e','\x60','R','T','C','_','I','N','S','T','A','N','C','E',
/* 0x177fd = "VERR_SSM_FIELD_COMPLEX" */
    '\x01','\xb0','F','I','E','L','D','_','C','O','M','P','L','E','X',
/* 0x1780c = "VERR_CR_KEY_FORMAT_NOT_SUPPORTED" */
    '\x01','\x22','K','E','Y','_','F','O','R','M','A','T','_','\x06','\x82',
/* 0x1781b = "VMM long jump error." */
    'V','M','M',' ','l','o','n','g',' ','j','u','m','p',' ','\x84',
/* 0x1782a = "VERR_SVM_UNEXPECTED_XCPT_EXIT" */
    '\x01','S','V','M','_','\x86','X','C','P','T','_','E','X','I','T',
/* 0x17839 = "VERR_GSTCTL_GUEST_ERROR" */
    '\x01','G','S','T','C','T','L','_','G','U','E','S','T','_','\x1a',
/* 0x17848 = "VERR_CPUM_DB_CPU_NOT_FOUND" */
    '\x01','C','P','U','M','_','D','B','_','C','P','U','_','\x06','\x2a',
/* 0x17857 = "VERR_VFS_CHAIN_PROVIDER_NOT_FOUND" */
    '\x01','\x8d','_','\x8e','P','R','O','V','I','D','E','R','_','\x06','\x2a',
/* 0x17866 = "VERR_VFS_BOGUS_FORMAT" */
    '\x01','\x8d','_','B','O','G','U','S','_','F','O','R','M','A','T',
/* 0x17875 = "VERR_XAR_TOC_UTF8_ENCODING" */
    '\x01','X','A','R','_','T','O','C','_','U','T','F','8','_','\xc6',
/* 0x17884 = "Repairing the image is not supported." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x25','\x0b','\x08','\xa4',
/* 0x17893 = "VERR_IPC_SEND_MAP_FAILED" */
    '\x01','I','P','C','_','S','E','N','D','_','M','A','P','_','\x16',
/* 0x178a2 = "VDI: Invalid image file header." */
    'V','D','I',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x178b1 = "Invalid magic or cookie." */
    '\x0c','m','a','g','i','c',' ','\xa9','c','o','o','k','i','e','.',
/* 0x178c0 = "VERR_VMX_MSR_VMX_ENABLE_FAILED" */
    '\x01','\xe1','M','S','R','_','\xe1','E','N','A','B','L','E','_','\x16',
/* 0x178cf = "VERR_CR_KEY_ENCRYPTED" */
    '\x01','\x22','K','E','Y','_','E','N','C','R','Y','P','T','E','D',
/* 0x178de = "The specified LUN is invalid." */
    '\x03','\x18','L','U','N',' ','\x0b','i','n','v','a','l','i','d','.',
/* 0x178ed = "Patch disabled." */
    'P','a','t','c','h',' ','d','i','s','a','b','l','e','d','.',
/* 0x178fc = "The OS was not detected." */
    '\x03','O','S',' ','\x11','\x08','d','e','t','e','c','t','e','d','.',
/* 0x1790b = "Unimplemented ASN." */
    'U','n','i','m','p','l','e','m','e','n','t','e','d',' ','\xf4',
/* 0x1791a = "No read callback." */
    '\xe6','r','e','a','d',' ','c','a','l','l','b','a','c','k','.',
/* 0x17929 = "VERR_LDRMACHO_BAD_LOAD_COMMAND" */
    '\x01','\xe7','\x1d','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x17938 = "VERR_FLOAT_OVERFLOW" */
    '\x01','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x17947 = "VERR_SUP_VP_BAD_SECTION_RVA" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','R','V','A',
/* 0x17956 = "VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND" */
    '\x01','\xe7','\x91','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x17965 = "VERR_LDRELF_MACHINE" */
    '\x01','L','D','R','E','L','F','_','M','A','C','H','I','N','E',
/* 0x17974 = "VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE" */
    '\x01','\x8c','\x06','\x82','_','F','O','R','_','\xec','_','M','O','D','E',
/* 0x17983 = "VERR_PGM_PAE_PDPE_RSVD" */
    '\x01','\x8c','P','A','E','_','P','D','P','E','_','R','S','V','D',
/* 0x17992 = "VERR_SYS_SHUTDOWN_FAILED" */
    '\x01','S','Y','S','_','S','H','U','T','D','O','W','N','_','\x16',
/* 0x179a1 = "VERR_LDR_NOT_FORWARDER" */
    '\x01','L','D','R','_','\x06','F','O','R','W','A','R','D','E','R',
/* 0x179b0 = "VERR_CR_X509_CPV_NOT_CA_CERT" */
    '\x01','\x22','\xb7','C','P','V','_','\x06','C','A','_','C','E','R','T',
/* 0x179bf = "VERR_CR_X509_CPV_NOT_V3_CERT" */
    '\x01','\x22','\xb7','C','P','V','_','\x06','V','3','_','C','E','R','T',
/* 0x179ce = "VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND" */
    '\x01','\xe7','\x1b','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x179dd = "VERR_CR_X509_CPV_ISSUER_MISMATCH" */
    '\x01','\x22','\xb7','C','P','V','_','I','S','S','U','E','R','_','\x19',
/* 0x179ec = "Invalid segment index." */
    '\x0c','s','e','g','m','e','n','t',' ','i','n','d','e','x','.',
/* 0x179fb = "VERR_EM_INTERPRETER" */
    '\x01','E','M','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x17a0a = "The specified thread is dead." */
    '\x03','\x18','t','h','r','e','a','d',' ','\x0b','d','e','a','d','.',
/* 0x17a19 = "VERR_CR_PKCS7_NOT_SIGNED_DATA" */
    '\x01','\x22','\xe3','\x06','S','I','G','N','E','D','_','D','A','T','A',
/* 0x17a28 = "VERR_ISOFS_MULTIPLE_PVDS" */
    '\x01','\xa2','M','U','L','T','I','P','L','E','_','P','V','D','S',
/* 0x17a37 = "Raw mode doesn't support SMP." */
    'R','a','w',' ','m','o','d','e',' ','\xc7','\xce','S','M','P','.',
/* 0x17a46 = "VERR_IEM_INVALID_INSTR_LENGTH" */
    '\x01','\x9b','\x05','I','N','S','T','R','_','L','E','N','G','T','H',
/* 0x17a55 = "VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\xb5','_','\x06','\x82',
/* 0x17a64 = "VERR_SHCLPB_EVENT_FAILED" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','\x16',
/* 0x17a73 = "VERR_HM_INVALID_HM64ON32OP" */
    '\x01','H','M','_','\x05','H','M','6','4','O','N','3','2','O','P',
/* 0x17a82 = "VERR_TAR_NOT_USTAR_V00" */
    '\x01','T','A','R','_','\x06','U','S','T','A','R','_','V','0','0',
/* 0x17a91 = "VERR_IPC_PROCESS_NOT_FOUND" */
    '\x01','I','P','C','_','P','R','O','C','E','S','S','_','\x06','\x2a',
/* 0x17aa0 = "VERR_CR_X509_CERTPATHS_INTERNAL_ERROR" */
    '\x01','\x22','\xb7','C','E','R','T','P','A','T','H','S','_','\xc2','\x1a',
/* 0x17aaf = "VERR_PATCH_DISABLED" */
    '\x01','P','A','T','C','H','_','D','I','S','A','B','L','E','D',
/* 0x17abe = "VERR_VD_GEOMETRY_NOT_SET" */
    '\x01','\xff','G','E','O','M','E','T','R','Y','_','\x06','S','E','T',
/* 0x17acd = "VERR_VMM_LONG_JMP_ERROR" */
    '\x01','V','M','M','_','L','O','N','G','_','J','M','P','_','\x1a',
/* 0x17adc = "Send cancelled." */
    'S','e','n','d',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x17aeb = "VERR_TAR_EMPTY_NAME" */
    '\x01','T','A','R','_','E','M','P','T','Y','_','N','A','M','E',
/* 0x17afa = "VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET" */
    '\x01','\xa2','F','S','D','_','\x1b','C','H','A','R','_','S','E','T',
/* 0x17b09 = "Reason for leaving RZ: MMIO write." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd2',' ','w','r','i','t','e','.',
/* 0x17b18 = "VERR_PDM_TOO_PCI_MANY_DEVICES" */
    '\x01','\x5e','\x1c','P','C','I','_','\xaf','D','E','V','I','C','E','S',
/* 0x17b27 = "VERR_DBGC_PARSE_NOT_IMPLEMENTED" */
    '\x01','\xfb','\xe2','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x17b36 = "VERR_SIGNAL_PENDING" */
    '\x01','S','I','G','N','A','L','_','P','E','N','D','I','N','G',
/* 0x17b45 = "VERR_NOT_DATA_SELECTOR" */
    '\x01','\x06','D','A','T','A','_','S','E','L','E','C','T','O','R',
/* 0x17b54 = "The specified cpu is offline." */
    '\x03','\x18','c','p','u',' ','\x0b','o','f','f','l','i','n','e','.',
/* 0x17b63 = "Raw: Invalid image file header." */
    'R','a','w',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x17b72 = "Unable to decode date value." */
    '\xde','\x0a','d','e','c','o','d','e',' ','d','a','t','e',' ','\xf3',
/* 0x17b81 = "VERR_SIGNAL_INVALID" */
    '\x01','S','I','G','N','A','L','_','I','N','V','A','L','I','D',
/* 0x17b90 = "The digest algorithm is not known to us." */
    '\x03','\xd6','\xd3','\x0b','\x08','k','n','o','w','n',' ','\x0a','u','s','.',
/* 0x17b9f = "VINF_EM_DBG_STEPPED" */
    '\x0e','E','M','_','D','B','G','_','S','T','E','P','P','E','D',
/* 0x17bae = "VERR_WEB_UNSUPPORTED_INTERFACE" */
    '\x01','W','E','B','_','\x1b','I','N','T','E','R','F','A','C','E',
/* 0x17bbd = "Process Verification Failure: Bad image signature." */
    '\x1e','\x0d','\x12','\x9d','\x25','s','i','g','n','a','t','u','r','e','.',
/* 0x17bcc = "Bad symbol table entry." */
    '\x9d','s','y','m','b','o','l',' ','\xb1','e','n','t','r','y','.',
/* 0x17bdb = "VERR_SEM_OWNER_DIED" */
    '\x01','S','E','M','_','O','W','N','E','R','_','D','I','E','D',
/* 0x17bea = "Patch was removed." */
    'P','a','t','c','h',' ','\x11','r','e','m','o','v','e','d','.',
/* 0x17bf9 = "Unknown saved state record." */
    '\xf8','s','a','v','e','d',' ','\xcd','r','e','c','o','r','d','.',
/* 0x17c08 = "VERR_IOMMU_INTR_REMAP_FAILED" */
    '\x01','\xfc','_','I','N','T','R','_','R','E','M','A','P','_','\x16',
/* 0x17c17 = "VERR_ISOFS_BAD_TAG_CHECKSUM" */
    '\x01','\xa2','\x1d','T','A','G','_','C','H','E','C','K','S','U','M',
/* 0x17c26 = "VERR_ISOFS_MULTIPLE_LVDS" */
    '\x01','\xa2','M','U','L','T','I','P','L','E','_','L','V','D','S',
/* 0x17c35 = "VINF_PATCH_CONTINUE" */
    '\x0e','P','A','T','C','H','_','C','O','N','T','I','N','U','E',
/* 0x17c44 = "VERR_TOO_MANY_CPUID_LEAVES" */
    '\x01','\x1c','\xaf','C','P','U','I','D','_','L','E','A','V','E','S',
/* 0x17c53 = "VERR_DBGC_PARSE_CONVERSION_FAILED" */
    '\x01','\xfb','\xe2','C','O','N','V','E','R','S','I','O','N','_','\x16',
/* 0x17c62 = "VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION" */
    '\x01','\xe7','\x1b','I','N','I','T','_','S','E','C','T','I','O','N',
/* 0x17c71 = "Invalid guest LDT selector." */
    '\x0c','\xbb','L','D','T',' ','s','e','l','e','c','t','o','r','.',
/* 0x17c80 = "VERR_VD_ISCSI_INVALID_HEADER" */
    '\x01','\xff','I','S','C','S','I','_','\x05','H','E','A','D','E','R',
/* 0x17c8f = "Syntax error - function not found." */
    '\xf7','\x09','-',' ','f','u','n','c','t','i','o','n',' ','\x08','\x88',
/* 0x17c9e = "Invalid dotted string." */
    '\x0c','d','o','t','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x17cad = "Unexpected number of valid paths." */
    '\x94','\xf9','\x15','v','a','l','i','d',' ','p','a','t','h','s','.',
/* 0x17cbc = "PML4 entry not present." */
    'P','M','L','4',' ','\xc8','\x08','p','r','e','s','e','n','t','.',
/* 0x17ccb = "VERR_DRIVE_IS_EMPTY" */
    '\x01','D','R','I','V','E','_','I','S','_','E','M','P','T','Y',
/* 0x17cda = "VERR_CR_SPC_GENERIC_ERROR" */
    '\x01','\x22','S','P','C','_','G','E','N','E','R','I','C','_','\x1a',
/* 0x17ce9 = "VERR_VMX_IN_VMX_ROOT_MODE" */
    '\x01','\xe1','I','N','_','\xe1','R','O','O','T','_','M','O','D','E',
/* 0x17cf8 = "Bucket already exists." */
    'B','u','c','k','e','t',' ','\x7f','e','x','i','s','t','s','.',
/* 0x17d07 = "VERR_LOG_REVISION_MISMATCH" */
    '\x01','L','O','G','_','R','E','V','I','S','I','O','N','_','\x19',
/* 0x17d16 = "VERR_SIGNAL_REFUSED" */
    '\x01','S','I','G','N','A','L','_','R','E','F','U','S','E','D',
/* 0x17d25 = "Invalid VMXON pointer." */
    '\x0c','V','M','X','O','N',' ','p','o','i','n','t','e','r','.',
/* 0x17d34 = "VERR_VD_CACHE_ALREADY_EXISTS" */
    '\x01','\xff','C','A','C','H','E','_','\x9a','E','X','I','S','T','S',
/* 0x17d43 = "VERR_PATCH_ALREADY_ENABLED" */
    '\x01','P','A','T','C','H','_','\x9a','E','N','A','B','L','E','D',
/* 0x17d52 = "VERR_DIS_INVALID_PARAMETER" */
    '\x01','D','I','S','_','\x05','P','A','R','A','M','E','T','E','R',
/* 0x17d61 = "VERR_SHCLPB_GUEST_ERROR" */
    '\x01','S','H','C','L','P','B','_','G','U','E','S','T','_','\x1a',
/* 0x17d70 = "VERR_TAR_NAME_TOO_LONG" */
    '\x01','T','A','R','_','N','A','M','E','_','\x1c','L','O','N','G',
/* 0x17d7f = "VERR_IO_GEN_FAILURE" */
    '\x01','I','O','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x17d8e = "VERR_SELM_GDT_TOO_FULL" */
    '\x01','S','E','L','M','_','G','D','T','_','\x1c','F','U','L','L',
/* 0x17d9d = "VERR_NET_NOT_CONNECTED" */
    '\x01','N','E','T','_','\x06','C','O','N','N','E','C','T','E','D',
/* 0x17dac = "VERR_GETOPT_UNKNOWN_OPTION" */
    '\x01','G','E','T','O','P','T','_','\x91','O','P','T','I','O','N',
/* 0x17dbb = "VERR_PGM_NOT_USED_IN_MODE" */
    '\x01','\x8c','\x06','U','S','E','D','_','I','N','_','M','O','D','E',
/* 0x17dca = "VERR_VSCSI_LUN_BUSY" */
    '\x01','V','S','C','S','I','_','L','U','N','_','B','U','S','Y',
/* 0x17dd9 = "VERR_XAR_TOC_TOO_SMALL" */
    '\x01','X','A','R','_','T','O','C','_','\x1c','S','M','A','L','L',
/* 0x17de8 = "VINF_IOM_R3_MMIO_WRITE" */
    '\x0e','I','O','M','_','R','3','_','\xd2','_','W','R','I','T','E',
/* 0x17df7 = "The operation has already been cancelled." */
    '\x03','\x96','\x7b','\x7f','\xca','c','a','n','c','e','l','l','e','d','.',
/* 0x17e06 = "VERR_VMX_MSR_VMX_DISABLED" */
    '\x01','\xe1','M','S','R','_','\xe1','D','I','S','A','B','L','E','D',
/* 0x17e15 = "VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING" */
    '\x01','\xa1','\x05','V','I','D','E','O','T','E','X','_','\xd4','_','\xc6',
/* 0x17e24 = "VERR_TM_TSC_ALREADY_PAUSED" */
    '\x01','T','M','_','T','S','C','_','\x9a','P','A','U','S','E','D',
/* 0x17e33 = "VINF_GETOPT_NOT_OPTION" */
    '\x0e','G','E','T','O','P','T','_','\x06','O','P','T','I','O','N',
/* 0x17e42 = "VERR_SUPDRV_VTG_BAD_HDR_MISC" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','M','I','S','C',
/* 0x17e51 = "VERR_JSON_MALFORMED" */
    '\x01','J','S','O','N','_','M','A','L','F','O','R','M','E','D',
/* 0x17e60 = "VERR_CR_RSA_GENERIC_ERROR" */
    '\x01','\x22','R','S','A','_','G','E','N','E','R','I','C','_','\x1a',
/* 0x17e6f = "The support driver is not installed." */
    '\x03','\xce','\xc5','\x0b','\x08','i','n','s','t','a','l','l','e','d','.',
/* 0x17e7e = "VERR_FILE_AIO_COMPLETED" */
    '\x01','\xab','A','I','O','_','C','O','M','P','L','E','T','E','D',
/* 0x17e8d = "VERR_SEEK_ON_DEVICE" */
    '\x01','S','E','E','K','_','O','N','_','D','E','V','I','C','E',
/* 0x17e9c = "VERR_VM_FATAL_WAIT_ERROR" */
    '\x01','\xcc','_','F','A','T','A','L','_','W','A','I','T','_','\x1a',
/* 0x17eab = "VERR_ISOMK_IPE_READ_FILE_DATA_2" */
    '\x01','\x24','\x14','R','E','A','D','_','\xab','D','A','T','A','_','2',
/* 0x17eba = "VERR_NET_PROTOCOL_TYPE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\xb5',
/* 0x17ec9 = "VERR_ISOMK_IPE_READ_FILE_DATA_1" */
    '\x01','\x24','\x14','R','E','A','D','_','\xab','D','A','T','A','_','1',
/* 0x17ed8 = "VERR_ISOMK_IPE_READ_FILE_DATA_3" */
    '\x01','\x24','\x14','R','E','A','D','_','\xab','D','A','T','A','_','3',
/* 0x17ee7 = "VHD: Invalid image file header." */
    'V','H','D',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x17ef6 = "VERR_NOT_CODE_SELECTOR" */
    '\x01','\x06','C','O','D','E','_','S','E','L','E','C','T','O','R',
/* 0x17f05 = "Unsupported character set." */
    '\x97','c','h','a','r','a','c','t','e','r',' ','s','e','t','.',
/* 0x17f14 = "VERR_MEDIA_NOT_PRESENT" */
    '\x01','M','E','D','I','A','_','\x06','P','R','E','S','E','N','T',
/* 0x17f23 = "VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND" */
    '\x01','\x8c','S','A','V','E','D','_','R','O','M','_','\xdb','\x06','\x2a',
/* 0x17f32 = "Unsupported data unit version." */
    '\x97','\x9c','u','n','i','t',' ','v','e','r','s','i','o','n','.',
/* 0x17f41 = "DMG: Invalid image file header." */
    'D','M','G',':',' ','\x0c','\x25','\x1f','h','e','a','d','e','r','.',
/* 0x17f50 = "Installation has failed." */
    'I','n','s','t','a','l','l','a','t','i','o','n',' ','\x7b','\x7d',
/* 0x17f5f = "VERR_WEB_INVALID_OBJECT_ID" */
    '\x01','W','E','B','_','\x05','O','B','J','E','C','T','_','I','D',
/* 0x17f6e = "VERR_SUPDRV_TRACER_TOO_LARGE" */
    '\x01','\x90','T','R','A','C','E','R','_','\x1c','L','A','R','G','E',
/* 0x17f7d = "Not MMIO2 page." */
    'N','o','t',' ','M','M','I','O','2',' ','p','a','g','e','.',
/* 0x17f8c = "VERR_SUPDRV_VTG_BAD_PROVIDER" */
    '\x01','\x90','V','T','G','_','\x1d','P','R','O','V','I','D','E','R',
/* 0x17f9b = "VERR_VFS_BOGUS_OFFSET" */
    '\x01','\x8d','_','B','O','G','U','S','_','O','F','F','S','E','T',
/* 0x17faa = "VERR_HGCM_TOO_MANY_CLIENTS" */
    '\x01','H','G','C','M','_','\x1c','\xaf','C','L','I','E','N','T','S',
/* 0x17fb9 = "Recompiler: Out of memory for labels." */
    '\x13','O','u','t',' ','\x15','\x85','\x10','l','a','b','e','l','s','.',
/* 0x17fc8 = "VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS" */
    '\x01','\x22','\xe3','\x60','\xbe','A','L','G','O','R','I','T','H','M','S',
/* 0x17fd7 = "VERR_FILE_AIO_NOT_PREPARED" */
    '\x01','\xab','A','I','O','_','\x06','P','R','E','P','A','R','E','D',
/* 0x17fe6 = "Non-string object inside X." */
    'N','o','n','-','\xf0','\xa7','i','n','s','i','d','e',' ','X','.',
/* 0x17ff5 = "VERR_TRAILING_CHARS" */
    '\x01','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x18004 = "VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION" */
    '\x01','\xe7','\x1b','T','E','R','M','_','S','E','C','T','I','O','N',
/* 0x18013 = "Process Verification Failure: Bad section raw data size." */
    '\x1e','\x0d','\x12','\x9d','\xda','r','a','w',' ','\x9c','s','i','z','e','.',
/* 0x18022 = "VERR_PDM_NO_PIC_INSTANCE" */
    '\x01','\x5e','\x60','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x18031 = "Already loaded." */
    'A','l','r','e','a','d','y',' ','l','o','a','d','e','d','.',
/* 0x18040 = "Wrong JSON type for string value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xf1','\x10','\xf0','\xf3',
/* 0x1804f = "VFS chain element provider not found." */
    '\x8d',' ','\x9f','\x5c','p','r','o','v','i','d','e','r',' ','\x08','\x88',
/* 0x1805e = "VERR_VD_VMDK_VALUE_NOT_FOUND" */
    '\x01','\xff','V','M','D','K','_','V','A','L','U','E','_','\x06','\x2a',
/* 0x1806d = "VERR_NET_PROTOCOL_ERROR" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x1a',
/* 0x1807c = "VERR_PROC_DETACH_NOT_SUPPORTED" */
    '\x01','P','R','O','C','_','D','E','T','A','C','H','_','\x06','\x82',
/* 0x1808b = "VERR_XAR_BAD_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\x1d','\xfe','_','E','L','E','M','E','N','T',
/* 0x1809a = "VERR_PDM_GEOMETRY_NOT_SET" */
    '\x01','\x5e','G','E','O','M','E','T','R','Y','_','\x06','S','E','T',
/* 0x180a9 = "VERR_PDM_MEDIA_MOUNTED" */
    '\x01','\x5e','M','E','D','I','A','_','M','O','U','N','T','E','D',
/* 0x180b8 = "VERR_PGM_PHYS_MMIO_EX_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xd2','_','E','X','_','I','P','E',
/* 0x180c7 = "Bad VTG header - to high value." */
    '\x9d','V','T','G',' ','\xb3','-',' ','\x0a','h','i','g','h',' ','\xf3',
/* 0x180d6 = "VERR_FILENAME_TOO_LONG" */
    '\x01','F','I','L','E','N','A','M','E','_','\x1c','L','O','N','G',
/* 0x180e5 = "VERR_VMX_MSR_LOCKING_FAILED" */
    '\x01','\xe1','M','S','R','_','L','O','C','K','I','N','G','_','\x16',
/* 0x180f4 = "The owner is not root (hardening)." */
    '\x03','o','w','n','e','r',' ','\x0b','\x08','r','o','o','t',' ','\xad',
/* 0x18103 = "The trace log version is not supported." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\xcf','\x0b','\x08','\xa4',
/* 0x18112 = "VERR_COM_INVALID_SESSION_STATE" */
    '\x01','C','O','M','_','\x05','S','E','S','S','I','O','N','_','\xef',
/* 0x18121 = "VERR_LDR_BAD_FORWARDER" */
    '\x01','L','D','R','_','\x1d','F','O','R','W','A','R','D','E','R',
/* 0x18130 = "VERR_COM_UNEXPECTED" */
    '\x01','C','O','M','_','U','N','E','X','P','E','C','T','E','D',
/* 0x1813f = "VERR_CR_X509_NAME_EMPTY_STRING" */
    '\x01','\x22','\xb7','N','A','M','E','_','E','M','P','T','Y','_','\xd4',
/* 0x1814e = "Unknown glob variable." */
    '\xf8','g','l','o','b',' ','v','a','r','i','a','b','l','e','.',
/* 0x1815d = "Write protect error." */
    'W','r','i','t','e',' ','p','r','o','t','e','c','t',' ','\x84',
/* 0x1816c = "VERR_PGM_INVALID_LARGE_PAGE_RANGE" */
    '\x01','\x8c','\x05','L','A','R','G','E','_','\xdb','R','A','N','G','E',
/* 0x1817b = "VERR_XAR_TOC_XML_PARSE_ERROR" */
    '\x01','X','A','R','_','T','O','C','_','X','M','L','_','\xe2','\x1a',
/* 0x1818a = "VERR_GETOPT_INDEX_MISSING" */
    '\x01','G','E','T','O','P','T','_','I','N','D','E','X','_','\xc4',
/* 0x18199 = "VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','\x1c','F','E','W',
/* 0x181a8 = "VINF_DBGF_BP_ALREADY_DISABLED" */
    '\x0e','\xb9','_','B','P','_','\x9a','D','I','S','A','B','L','E','D',
/* 0x181b7 = "VERR_IOM_MMIO_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','\xd2','_','R','A','N','G','E','_','\x06','\x2a',
/* 0x181c6 = "VWRN_TRAILING_CHARS" */
    '\xe4','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x181d5 = "VERR_MM_BAD_TRAP_TYPE_IPE" */
    '\x01','M','M','_','\x1d','T','R','A','P','_','\xb5','_','I','P','E',
/* 0x181e4 = "VWRN_FLOAT_OVERFLOW" */
    '\xe4','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x181f3 = "VERR_THREAD_IS_DEAD" */
    '\x01','T','H','R','E','A','D','_','I','S','_','D','E','A','D',
/* 0x18202 = "VERR_DBG_CFG_INVALID_VALUE" */
    '\x01','D','B','G','_','C','F','G','_','\x05','V','A','L','U','E',
/* 0x18211 = "VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR" */
    '\x01','\x22','\xbe','O','S','S','L','_','\xbe','I','N','I','T','_','\x1a',
/* 0x18220 = "Bad VTG header - offset." */
    '\x9d','V','T','G',' ','\xb3','-',' ','o','f','f','s','e','t','.',
/* 0x1822f = "VERR_LDR_IMAGE_HASH" */
    '\x01','L','D','R','_','I','M','A','G','E','_','H','A','S','H',
/* 0x1823e = "VERR_CR_KEY_NO_DEK_INFO" */
    '\x01','\x22','K','E','Y','_','\x60','D','E','K','_','I','N','F','O',
/* 0x1824d = "VERR_ASN1_INVALID_DATA_POINTER" */
    '\x01','\xa1','\x05','D','A','T','A','_','P','O','I','N','T','E','R',
/* 0x1825c = "Recompiler: Out of memory for fixups." */
    '\x13','O','u','t',' ','\x15','\x85','\x10','f','i','x','u','p','s','.',
/* 0x1826b = "VERR_SUP_VP_UNKOWN_MEM_TYPE" */
    '\x01','\x95','\xbd','U','N','K','O','W','N','_','M','E','M','_','\xb5',
/* 0x1827a = "The specified data unit already exist." */
    '\x03','\x18','\x9c','u','n','i','t',' ','\x7f','e','x','i','s','t','.',
/* 0x18289 = "Access denied error." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x84',
/* 0x18298 = "Invalid host bit mask." */
    '\x0c','h','o','s','t',' ','b','i','t',' ','m','a','s','k','.',
/* 0x182a7 = "VERR_IEM_INVALID_ADDRESS_MODE" */
    '\x01','\x9b','\x05','A','D','D','R','E','S','S','_','M','O','D','E',
/* 0x182b6 = "VERR_INSTALLATION_FAILED" */
    '\x01','I','N','S','T','A','L','L','A','T','I','O','N','_','\x16',
/* 0x182c5 = "The specified path was not absolute (hardening)." */
    '\x03','\x18','\xd0','\x11','\x08','a','b','s','o','l','u','t','e',' ','\xad',
/* 0x182d4 = "Bad descriptor tag checksum." */
    '\x9d','\xee','t','a','g',' ','c','h','e','c','k','s','u','m','.',
/* 0x182e3 = "VERR_IEM_VAR_EXHAUSTED" */
    '\x01','\x9b','V','A','R','_','E','X','H','A','U','S','T','E','D',
/* 0x182f2 = "VERR_INVALID_EXE_SIGNATURE" */
    '\x01','\x05','E','X','E','_','S','I','G','N','A','T','U','R','E',
/* 0x18301 = "VERR_PGM_PHYS_PAGE_GET_IPE" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','G','E','T','_','I','P','E',
/* 0x18310 = "VERR_IS_A_DIRECTORY" */
    '\x01','I','S','_','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x1831f = "VERR_SSM_LOAD_CONFIG_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','C','O','N','F','I','G','_','\x19',
/* 0x1832e = "VERR_CR_KEY_GEN_FAILED_RSA" */
    '\x01','\x22','K','E','Y','_','G','E','N','_','\x16','_','R','S','A',
/* 0x1833d = "VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE" */
    '\x01','T','A','R','_','\x1b','G','N','U','_','H','D','R','_','\xb5',
/* 0x1834c = "VERR_CFGM_NOT_PASSWORD" */
    '\x01','C','F','G','M','_','\x06','P','A','S','S','W','O','R','D',
/* 0x1835b = "VERR_FAM_MONITOR_FILE_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','\xab','\x16',
/* 0x1836a = "VERR_NET_ALREADY_CONNECTED" */
    '\x01','N','E','T','_','\x9a','C','O','N','N','E','C','T','E','D',
/* 0x18379 = "VERR_TOO_MANY_SEM_REQUESTS" */
    '\x01','\x1c','\xaf','S','E','M','_','R','E','Q','U','E','S','T','S',
/* 0x18388 = "VERR_DVM_MAP_EMPTY" */
    '\x01','D','V','M','_','M','A','P','_','E','M','P','T','Y',
/* 0x18396 = "VERR_PGM_PML4_MAPPING" */
    '\x01','\x8c','P','M','L','4','_','M','A','P','P','I','N','G',
/* 0x183a4 = "VERR_CFGM_CHILD_NOT_FOUND" */
    '\x01','C','F','G','M','_','C','H','I','L','D','_','\x06','\x2a',
/* 0x183b2 = "VERR_HOSTIF_TERM_FAILED" */
    '\x01','H','O','S','T','I','F','_','T','E','R','M','_','\x16',
/* 0x183c0 = "VINF_ENV_VAR_UNSET" */
    '\x0e','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x183ce = "VERR_LDRVI_IMAGE_HASH_MISMATCH" */
    '\x01','\xf2','I','M','A','G','E','_','H','A','S','H','_','\x19',
/* 0x183dc = "The device instance was not found." */
    '\x03','\xa3','i','n','s','t','a','n','c','e',' ','\x11','\x08','\x88',
/* 0x183ea = "VERR_SUPLIB_UNEXPECTED_INSTRUCTION" */
    '\x01','\xd5','\x86','I','N','S','T','R','U','C','T','I','O','N',
/* 0x183f8 = "VERR_PDM_CRITSECT_IPE" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','_','I','P','E',
/* 0x18406 = "VERR_CFGM_NOT_INTEGER" */
    '\x01','C','F','G','M','_','\x06','I','N','T','E','G','E','R',
/* 0x18414 = "VERR_PKZIP_UNKNOWN_TYPE_FLAG" */
    '\x01','P','K','Z','I','P','_','\x91','\xb5','_','F','L','A','G',
/* 0x18422 = "VERR_SSM_LIVE_FATAL_ERROR" */
    '\x01','\xb0','L','I','V','E','_','F','A','T','A','L','_','\x1a',
/* 0x18430 = "Network is down." */
    'N','e','t','w','o','r','k',' ','\x0b','d','o','w','n','.',
/* 0x1843e = "VERR_COM_INVALID_OBJECT_STATE" */
    '\x01','C','O','M','_','\x05','O','B','J','E','C','T','_','\xef',
/* 0x1844c = "VERR_PDM_MEDIA_LOCKED" */
    '\x01','\x5e','M','E','D','I','A','_','L','O','C','K','E','D',
/* 0x1845a = "Internal processing error in the HM init code." */
    '\x07','\x04','\x09','\x0f','\x02','H','M',' ','i','n','i','t',' ','\x83',
/* 0x18468 = "VERR_VFS_CHAIN_TAKES_FILE" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','F','I','L','E',
/* 0x18476 = "VERR_HGCM_INTERNAL" */
    '\x01','H','G','C','M','_','I','N','T','E','R','N','A','L',
/* 0x18484 = "Requested operation is not supported." */
    'R','e','q','u','e','s','t','e','d',' ','\x96','\x0b','\x08','\xa4',
/* 0x18492 = "VERR_INVALID_VMCPU_HANDLE" */
    '\x01','\x05','V','M','C','P','U','_','H','A','N','D','L','E',
/* 0x184a0 = "VWRN_PATCH_ENABLED" */
    '\xe4','P','A','T','C','H','_','E','N','A','B','L','E','D',
/* 0x184ae = "VERR_IOM_IOPORT_IPE_3" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','3',
/* 0x184bc = "Internal processing error #2 in the GVMM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','G','V','M','M',' ','\x83',
/* 0x184ca = "VERR_IOM_IOPORT_IPE_2" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','2',
/* 0x184d8 = "VERR_IOM_IOPORT_IPE_1" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x14','1',
/* 0x184e6 = "Syntax error - invalid numeric value." */
    '\xf7','\x09','-',' ','\x8f','n','u','m','e','r','i','c',' ','\xf3',
/* 0x184f4 = "VERR_PGM_TOO_MANY_ROM_RANGES" */
    '\x01','\x8c','\x1c','\xaf','R','O','M','_','R','A','N','G','E','S',
/* 0x18502 = "VERR_PGM_MAPPINGS_SMP" */
    '\x01','\x8c','M','A','P','P','I','N','G','S','_','S','M','P',
/* 0x18510 = "Max process number reached." */
    'M','a','x',' ','\x92','\xf9','r','e','a','c','h','e','d','.',
/* 0x1851e = "Failed to enumerate directory (hardening)." */
    '\x8b','\x0a','e','n','u','m','e','r','a','t','e',' ','\x26','\xad',
/* 0x1852c = "VERR_RT_REQUEST_INVALID_TYPE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x05','\xb5',
/* 0x1853a = "VERR_JSON_IS_EMPTY" */
    '\x01','J','S','O','N','_','I','S','_','E','M','P','T','Y',
/* 0x18548 = "VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING" */
    '\x01','\xa1','\x05','N','U','M','E','R','I','C','_','\xd4','_','\xc6',
/* 0x18556 = "VERR_HOSTIF_INIT_FAILED" */
    '\x01','H','O','S','T','I','F','_','I','N','I','T','_','\x16',
/* 0x18564 = "VERR_DWARF_BAD_ABBREV" */
    '\x01','D','W','A','R','F','_','\x1d','A','B','B','R','E','V',
/* 0x18572 = "VERR_SUP_VP_BAD_IMAGE_BASE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','B','A','S','E',
/* 0x18580 = "Recompiler: Unexpected register assignment." */
    '\x13','\x94','\xe9','a','s','s','i','g','n','m','e','n','t','.',
/* 0x1858e = "VERR_LDRLX_NO_SONAME" */
    '\x01','L','D','R','L','X','_','\x60','S','O','N','A','M','E',
/* 0x1859c = "VINF_IEM_SELECTOR_NOT_OK" */
    '\x0e','\x9b','S','E','L','E','C','T','O','R','_','\x06','O','K',
/* 0x185aa = "VERR_SSM_LOAD_CPUID_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','C','P','U','I','D','_','\x19',
/* 0x185b8 = "VERR_NO_STRING_TERMINATOR" */
    '\x01','\x60','\xd4','_','T','E','R','M','I','N','A','T','O','R',
/* 0x185c6 = "VERR_LDRVI_READ_ERROR_SHDRS" */
    '\x01','\xf2','R','E','A','D','_','\x1a','_','S','H','D','R','S',
/* 0x185d4 = "The ICB for is too small." */
    '\x03','I','C','B',' ','\x10','\x0b','\xa0','s','m','a','l','l','.',
/* 0x185e2 = "VERR_IOMMU_DTE_BAD_OFFSET" */
    '\x01','\xfc','_','D','T','E','_','\x1d','O','F','F','S','E','T',
/* 0x185f0 = "VERR_SUPLIB_TEXT_NOT_SEALED" */
    '\x01','\xd5','T','E','X','T','_','\x06','S','E','A','L','E','D',
/* 0x185fe = "VERR_SUPLIB_PATH_IS_ROOT" */
    '\x01','\xd5','P','A','T','H','_','I','S','_','R','O','O','T',
/* 0x1860c = "VERR_SUP_VP_STUB_OPEN_ERROR" */
    '\x01','\x95','\xbd','S','T','U','B','_','O','P','E','N','_','\x1a',
/* 0x1861a = "VERR_HTTP_PROXY_NOT_FOUND" */
    '\x01','H','T','T','P','_','P','R','O','X','Y','_','\x06','\x2a',
/* 0x18628 = "VERR_PGM_RAM_CONFLICT" */
    '\x01','\x8c','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x18636 = "Patch enabled." */
    'P','a','t','c','h',' ','e','n','a','b','l','e','d','.',
/* 0x18644 = "No media in drive." */
    '\xe6','m','e','d','i','a',' ','\x0f','d','r','i','v','e','.',
/* 0x18652 = "VERR_SUPLIB_NOT_SAME_OBJECT" */
    '\x01','\xd5','\x06','S','A','M','E','_','O','B','J','E','C','T',
/* 0x18660 = "The breakpoint has no command." */
    '\x03','\xbf','\x7b','n','o',' ','c','o','m','m','a','n','d','.',
/* 0x1866e = "VERR_SSM_FIELD_INVALID_VALUE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','V','A','L','U','E',
/* 0x1867c = "VERR_FILE_AIO_NO_REQUEST" */
    '\x01','\xab','A','I','O','_','\x60','R','E','Q','U','E','S','T',
/* 0x1868a = "Page not present." */
    'P','a','g','e',' ','\x08','p','r','e','s','e','n','t','.',
/* 0x18698 = "VERR_CFGM_VALUE_NOT_FOUND" */
    '\x01','C','F','G','M','_','V','A','L','U','E','_','\x06','\x2a',
/* 0x186a6 = "VERR_DBGC_PARSE_NUMBER_TOO_BIG" */
    '\x01','\xfb','\xe2','N','U','M','B','E','R','_','\x1c','B','I','G',
/* 0x186b4 = "VINF_DBGF_OS_NOT_DETCTED" */
    '\x0e','\xb9','_','O','S','_','\x06','D','E','T','C','T','E','D',
/* 0x186c2 = "VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS" */
    '\x01','\xfb','\xe2','\x1c','\xaf','A','R','G','U','M','E','N','T','S',
/* 0x186d0 = "Reason for leaving RZ: MMIO read." */
    '\x93','\x10','\x81','R','Z',':',' ','\xd2',' ','r','e','a','d','.',
/* 0x186de = "VERR_PGM_PHYS_PAGE_MAP_IPE_4" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','M','A','P','_','\x14','4',
/* 0x186ec = "VERR_ENV_VAR_UNSET" */
    '\x01','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x186fa = "VERR_NO_MORE_HANDLES" */
    '\x01','\x60','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x18708 = "VERR_GMM_TOO_MANY_REGIONS" */
    '\x01','G','M','M','_','\x1c','\xaf','R','E','G','I','O','N','S',
/* 0x18716 = "Address already in use." */
    'A','d','d','r','e','s','s',' ','\x7f','\x0f','u','s','e','.',
/* 0x18724 = "VWRN_PATCH_REMOVED" */
    '\xe4','P','A','T','C','H','_','R','E','M','O','V','E','D',
/* 0x18732 = "VERR_SUPDRV_VTG_BAD_ARGLIST" */
    '\x01','\x90','V','T','G','_','\x1d','A','R','G','L','I','S','T',
/* 0x18740 = "Drive is locked." */
    'D','r','i','v','e',' ','\x0b','l','o','c','k','e','d','.',
/* 0x1874e = "VERR_FILE_AIO_CANCELED" */
    '\x01','\xab','A','I','O','_','C','A','N','C','E','L','E','D',
/* 0x1875c = "Bad VTG header - to low value." */
    '\x9d','V','T','G',' ','\xb3','-',' ','\x0a','l','o','w',' ','\xf3',
/* 0x1876a = "VERR_LDRMACHO_BAD_OBJECT_FILE" */
    '\x01','\xe7','\x1d','O','B','J','E','C','T','_','F','I','L','E',
/* 0x18778 = "VERR_HTTP_BAD_REQUEST" */
    '\x01','H','T','T','P','_','\x1d','R','E','Q','U','E','S','T',
/* 0x18786 = "VERR_PGM_TOO_MANY_RAM_RANGES" */
    '\x01','\x8c','\x1c','\xaf','R','A','M','_','R','A','N','G','E','S',
/* 0x18794 = "Winsock init error." */
    'W','i','n','s','o','c','k',' ','i','n','i','t',' ','\x84',
/* 0x187a2 = "VERR_PGM_PHYS_PAGE_MAP_IPE_3" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','M','A','P','_','\x14','3',
/* 0x187b0 = "VERR_L4_INVALID_DS_OFFSET" */
    '\x01','L','4','_','\x05','D','S','_','O','F','F','S','E','T',
/* 0x187be = "Unexpected turn of events." */
    '\x94','t','u','r','n',' ','\x15','e','v','e','n','t','s','.',
/* 0x187cc = "VERR_FTP_CLIENT_NOT_FOUND" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','\x06','\x2a',
/* 0x187da = "Internal processing error #1 in the GVMM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','G','V','M','M',' ','\x83',
/* 0x187e8 = "VERR_PGM_PHYS_PAGE_MAP_IPE_1" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','M','A','P','_','\x14','1',
/* 0x187f6 = "VERR_CR_DIGEST_COMPROMISED" */
    '\x01','\x22','\xbe','C','O','M','P','R','O','M','I','S','E','D',
/* 0x18804 = "Access denied." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d','.',
/* 0x18812 = "VERR_PATM_ALREADY_PATCHED" */
    '\x01','P','A','T','M','_','\x9a','P','A','T','C','H','E','D',
/* 0x18820 = "VERR_NO_CODE_POINT_MEMORY" */
    '\x01','\x60','C','O','D','E','_','P','O','I','N','T','_','\xb6',
/* 0x1882e = "NEM is not available." */
    '\xec',' ','\x0b','\x08','a','v','a','i','l','a','b','l','e','.',
/* 0x1883c = "VERR_PGM_PHYS_PAGE_MAP_IPE_2" */
    '\x01','\x8c','P','H','Y','S','_','\xdb','M','A','P','_','\x14','2',
/* 0x1884a = "VERR_IOM_INVALID_MMIO_HANDLE" */
    '\x01','I','O','M','_','\x05','\xd2','_','H','A','N','D','L','E',
/* 0x18858 = "VERR_SEM_DESTROYED" */
    '\x01','S','E','M','_','D','E','S','T','R','O','Y','E','D',
/* 0x18866 = "VERR_DBGF_OS_NOT_DETCTED" */
    '\x01','\xb9','_','O','S','_','\x06','D','E','T','C','T','E','D',
/* 0x18874 = "VERR_MEMOBJ_INIT_FAILED" */
    '\x01','M','E','M','O','B','J','_','I','N','I','T','_','\x16',
/* 0x18882 = "VERR_ASN1_INVALID_BITSTRING_ENCODING" */
    '\x01','\xa1','\x05','B','I','T','S','T','R','I','N','G','_','\xc6',
/* 0x18890 = "VINF_CR_DIGEST_COMPROMISED" */
    '\x0e','\x22','\xbe','C','O','M','P','R','O','M','I','S','E','D',
/* 0x1889e = "VERR_GMM_MTX_FLAGS" */
    '\x01','G','M','M','_','M','T','X','_','F','L','A','G','S',
/* 0x188ac = "VERR_ACCESS_DENIED" */
    '\x01','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x188ba = "VERR_TM_UNSTABLE_STATE" */
    '\x01','T','M','_','U','N','S','T','A','B','L','E','_','\xef',
/* 0x188c8 = "VERR_SUPDRV_INTERFACE_NOT_SUPPORTED" */
    '\x01','\x90','I','N','T','E','R','F','A','C','E','_','\x06','\x82',
/* 0x188d6 = "The alignment is not supported." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x0b','\x08','\xa4',
/* 0x188e4 = "VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING" */
    '\x01','\xa1','\x05','G','R','A','P','H','I','C','_','\xd4','_','\xc6',
/* 0x188f2 = "Bad DWARF string." */
    '\x9d','D','W','A','R','F',' ','s','t','r','i','n','g','.',
/* 0x18900 = "VERR_SEM_LV_NOT_OWNER" */
    '\x01','S','E','M','_','L','V','_','\x06','O','W','N','E','R',
/* 0x1890e = "VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION" */
    '\x01','\xb0','\x1b','D','A','T','A','_','U','N','I','T','_','\xbc',
/* 0x1891c = "VERR_GVMM_INSTANCE" */
    '\x01','G','V','M','M','_','I','N','S','T','A','N','C','E',
/* 0x1892a = "VERR_PGM_POOL_TOO_MANY_LOOPS" */
    '\x01','\x8c','P','O','O','L','_','\x1c','\xaf','L','O','O','P','S',
/* 0x18938 = "Invalid flags was given." */
    '\x0c','f','l','a','g','s',' ','\x11','g','i','v','e','n','.',
/* 0x18946 = "VERR_PDM_USBHLPR3_VERSION_MISMATCH" */
    '\x01','\x5e','U','S','B','H','L','P','R','3','_','\xbc','_','\x19',
/* 0x18954 = "Message too long." */
    'M','e','s','s','a','g','e',' ','\xa0','l','o','n','g','.',
/* 0x18962 = "Invalid link address." */
    '\x0c','l','i','n','k',' ','a','d','d','r','e','s','s','.',
/* 0x18970 = "VERR_ISOMK_IPE_NAMESPACE_6" */
    '\x01','\x24','\x14','N','A','M','E','S','P','A','C','E','_','6',
/* 0x1897e = "VERR_ISOMK_IPE_NAMESPACE_4" */
    '\x01','\x24','\x14','N','A','M','E','S','P','A','C','E','_','4',
/* 0x1898c = "VERR_ISOMK_IPE_NAMESPACE_3" */
    '\x01','\x24','\x14','N','A','M','E','S','P','A','C','E','_','3',
/* 0x1899a = "VERR_ISOMK_IPE_NAMESPACE_2" */
    '\x01','\x24','\x14','N','A','M','E','S','P','A','C','E','_','2',
/* 0x189a8 = "VERR_SUPLIB_IS_DIRECTORY" */
    '\x01','\xd5','I','S','_','D','I','R','E','C','T','O','R','Y',
/* 0x189b6 = "VERR_SEM_LV_NESTED" */
    '\x01','S','E','M','_','L','V','_','N','E','S','T','E','D',
/* 0x189c4 = "VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS" */
    '\x01','\x95','\xbd','\x1c','\xaf','\xb6','_','R','E','G','I','O','N','S',
/* 0x189d2 = "VERR_RESOURCE_BUSY" */
    '\x01','R','E','S','O','U','R','C','E','_','B','U','S','Y',
/* 0x189e0 = "VERR_RAW_MODE_INVALID_SMP" */
    '\x01','R','A','W','_','M','O','D','E','_','\x05','S','M','P',
/* 0x189ee = "VERR_ISOFS_TAG_SECTOR_MISMATCH" */
    '\x01','\xa2','T','A','G','_','S','E','C','T','O','R','_','\x19',
/* 0x189fc = "VERR_ISOMK_IPE_NAMESPACE_1" */
    '\x01','\x24','\x14','N','A','M','E','S','P','A','C','E','_','1',
/* 0x18a0a = "VERR_ISOMK_IPE_NAMESPACE_5" */
    '\x01','\x24','\x14','N','A','M','E','S','P','A','C','E','_','5',
/* 0x18a18 = "VERR_ASN1_DUMMY_OBJECT" */
    '\x01','\xa1','D','U','M','M','Y','_','O','B','J','E','C','T',
/* 0x18a26 = "VERR_ASN1_INVALID_GENERAL_STRING_ENCODING" */
    '\x01','\xa1','\x05','G','E','N','E','R','A','L','_','\xd4','_','\xc6',
/* 0x18a34 = "Disk was changed." */
    'D','i','s','k',' ','\x11','c','h','a','n','g','e','d','.',
/* 0x18a42 = "VERR_JSON_VALUE_INVALID_TYPE" */
    '\x01','J','S','O','N','_','V','A','L','U','E','_','\x05','\xb5',
/* 0x18a50 = "VERR_PDM_NO_QUEUE_ITEMS" */
    '\x01','\x5e','\x60','Q','U','E','U','E','_','I','T','E','M','S',
/* 0x18a5e = "Bad VTG string table offset." */
    '\x9d','V','T','G',' ','\xf0','\xb1','o','f','f','s','e','t','.',
/* 0x18a6c = "VERR_PGM_SHW_NONE_IPE" */
    '\x01','\x8c','S','H','W','_','N','O','N','E','_','I','P','E',
/* 0x18a7a = "VERR_SMM_INTEGRITY_MACHINE" */
    '\x01','S','M','M','_','\xf5','_','M','A','C','H','I','N','E',
/* 0x18a88 = "VERR_IOMMU_CMD_INVALID_FORMAT" */
    '\x01','\xfc','_','C','M','D','_','\x05','F','O','R','M','A','T',
/* 0x18a96 = "VERR_CR_PKCS7_KEY_USAGE_MISMATCH" */
    '\x01','\x22','\xe3','K','E','Y','_','U','S','A','G','E','_','\x19',
/* 0x18aa4 = "Invalid VMCS pointer." */
    '\x0c','V','M','C','S',' ','p','o','i','n','t','e','r','.',
/* 0x18ab2 = "VERR_IOQUEUE_EMPTY" */
    '\x01','I','O','Q','U','E','U','E','_','E','M','P','T','Y',
/* 0x18ac0 = "VINF_REBOOT_NEEDED" */
    '\x0e','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x18ace = "Unexpected trap in patch code." */
    '\x94','t','r','a','p',' ','\x0f','p','a','t','c','h',' ','\x83',
/* 0x18adc = "Code signing error." */
    'C','o','d','e',' ','s','i','g','n','i','n','g',' ','\x84',
/* 0x18aea = "VERR_ASN1_DYNTYPE_BAD_TAG" */
    '\x01','\xa1','D','Y','N','T','Y','P','E','_','\x1d','T','A','G',
/* 0x18af8 = "Not data selector." */
    'N','o','t',' ','\x9c','s','e','l','e','c','t','o','r','.',
/* 0x18b06 = "Syntax error - Command not found." */
    '\xf7','\x09','-',' ','C','o','m','m','a','n','d',' ','\x08','\x88',
/* 0x18b14 = "VERR_SUPDRV_COMPONENT_NOT_FOUND" */
    '\x01','\x90','C','O','M','P','O','N','E','N','T','_','\x06','\x2a',
/* 0x18b22 = "Page record not found." */
    'P','a','g','e',' ','r','e','c','o','r','d',' ','\x08','\x88',
/* 0x18b30 = "VERR_PDM_DRVHLPR3_VERSION_MISMATCH" */
    '\x01','\x5e','D','R','V','H','L','P','R','3','_','\xbc','_','\x19',
/* 0x18b3e = "VERR_DBGC_PARSE_NOT_A_FUNCTION" */
    '\x01','\xfb','\xe2','\x06','A','_','F','U','N','C','T','I','O','N',
/* 0x18b4c = "Unsupported descriptor tag version." */
    '\x97','\xee','t','a','g',' ','v','e','r','s','i','o','n','.',
/* 0x18b5a = "VFS chain element takes no arguments." */
    '\x8d',' ','\x9f','\x5c','t','a','k','e','s',' ','n','o',' ','\xdc',
/* 0x18b68 = "VERR_VM_UNEXPECTED_UNSTABLE_STATE" */
    '\x01','\xcc','_','\x86','U','N','S','T','A','B','L','E','_','\xef',
/* 0x18b76 = "VERR_REBOOT_NEEDED" */
    '\x01','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x18b84 = "VERR_NET_HOST_DOWN" */
    '\x01','N','E','T','_','H','O','S','T','_','D','O','W','N',
/* 0x18b92 = "VERR_RECORDING_ENCODING_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','\xc6','_','\x16',
/* 0x18ba0 = "VERR_HM_UNEXPECTED_LD_ST_MSR" */
    '\x01','H','M','_','\x86','L','D','_','S','T','_','M','S','R',
/* 0x18bae = "VERR_NO_TLS_FOR_SELF" */
    '\x01','\x60','T','L','S','_','F','O','R','_','S','E','L','F',
/* 0x18bbc = "VERR_IOM_INVALID_IOPORT_SIZE" */
    '\x01','I','O','M','_','\x05','I','O','P','O','R','T','_','\xfe',
/* 0x18bca = "VERR_GMM_PAGE_NOT_PRIVATE" */
    '\x01','G','M','M','_','\xdb','\x06','P','R','I','V','A','T','E',
/* 0x18bd8 = "A directory entry in the archive." */
    'A',' ','\x26','\xc8','\x0f','\x02','a','r','c','h','i','v','e','.',
/* 0x18be6 = "VERR_VD_VMDK_INVALID_FORMAT" */
    '\x01','\xff','V','M','D','K','_','\x05','F','O','R','M','A','T',
/* 0x18bf4 = "Child node was not found." */
    'C','h','i','l','d',' ','n','o','d','e',' ','\x11','\x08','\x88',
/* 0x18c02 = "VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM" */
    '\x01','\x22','\xe3','\x91','\xbe','A','L','G','O','R','I','T','H','M',
/* 0x18c10 = "VINF_DBGF_BP_ALREADY_ENABLED" */
    '\x0e','\xb9','_','B','P','_','\x9a','E','N','A','B','L','E','D',
/* 0x18c1e = "VERR_VFS_CHAIN_THREE_ARGS" */
    '\x01','\x8d','_','\x8e','T','H','R','E','E','_','A','R','G','S',
/* 0x18c2c = "VERR_COM_OBJECT_NOT_FOUND" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','\x06','\x2a',
/* 0x18c3a = "VERR_ASN1_CURSOR_TAG_MISMATCH" */
    '\x01','\xa1','C','U','R','S','O','R','_','T','A','G','_','\x19',
/* 0x18c48 = "VERR_DBGF_REGISTER_NOT_FOUND" */
    '\x01','\xb9','_','R','E','G','I','S','T','E','R','_','\x06','\x2a',
/* 0x18c56 = "The VM has been restored." */
    '\x03','\xcc',' ','\x7b','\xca','r','e','s','t','o','r','e','d','.',
/* 0x18c64 = "VERR_VD_VMDK_INVALID_HEADER" */
    '\x01','\xff','V','M','D','K','_','\x05','H','E','A','D','E','R',
/* 0x18c72 = "VERR_LDRLX_BAD_HEADER" */
    '\x01','L','D','R','L','X','_','\x1d','H','E','A','D','E','R',
/* 0x18c80 = "VERR_NOT_POWER_OF_TWO" */
    '\x01','\x06','P','O','W','E','R','_','O','F','_','T','W','O',
/* 0x18c8e = "VERR_SUPDRV_VTG_BAD_HDR_OFF" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','O','F','F',
/* 0x18c9c = "VERR_STALE_FILE_HANDLE" */
    '\x01','S','T','A','L','E','_','\xab','H','A','N','D','L','E',
/* 0x18caa = "Invalid drive number." */
    '\x0c','d','r','i','v','e',' ','n','u','m','b','e','r','.',
/* 0x18cb8 = "GIM generic operation failed." */
    'G','I','M',' ','g','e','n','e','r','i','c',' ','\x96','\x7d',
/* 0x18cc6 = "Too little data in ASN." */
    'T','o','o',' ','l','i','t','t','l','e',' ','\x9c','\x0f','\xf4',
/* 0x18cd4 = "VERR_GIM_INVALID_PROVIDER" */
    '\x01','G','I','M','_','\x05','P','R','O','V','I','D','E','R',
/* 0x18ce2 = "VERR_SUPDRV_VTG_BAD_HDR_PTR" */
    '\x01','\x90','V','T','G','_','\x1d','H','D','R','_','P','T','R',
/* 0x18cf0 = "VERR_ENV_INVALID_VAR_NAME" */
    '\x01','E','N','V','_','\x05','V','A','R','_','N','A','M','E',
/* 0x18cfe = "VERR_LDRLX_BAD_BUNDLE" */
    '\x01','L','D','R','L','X','_','\x1d','B','U','N','D','L','E',
/* 0x18d0c = "VERR_LDRVI_NO_MEMORY_SIGNATURE" */
    '\x01','\xf2','\x60','\xb6','_','S','I','G','N','A','T','U','R','E',
/* 0x18d1a = "VERR_CR_X509_INVALID_NAME_STRING_TAG" */
    '\x01','\x22','\xb7','\x05','N','A','M','E','_','\xd4','_','T','A','G',
/* 0x18d28 = "VERR_VM_THREAD_NOT_EMT" */
    '\x01','\xcc','_','T','H','R','E','A','D','_','\x06','E','M','T',
/* 0x18d36 = "VERR_SUP_VP_BAD_SECTION_FILE_SIZE" */
    '\x01','\x95','\xbd','\x1d','S','E','C','T','I','O','N','_','\xab','\xfe',
/* 0x18d44 = "VERR_ISOFS_PARTITION_NOT_FOUND" */
    '\x01','\xa2','P','A','R','T','I','T','I','O','N','_','\x06','\x2a',
/* 0x18d52 = "VINF_SELM_SYNC_GDT" */
    '\x0e','S','E','L','M','_','S','Y','N','C','_','G','D','T',
/* 0x18d60 = "VERR_DBGC_PARSE_FUNCTION_NOT_FOUND" */
    '\x01','\xfb','\xe2','F','U','N','C','T','I','O','N','_','\x06','\x2a',
/* 0x18d6e = "VERR_NEGATIVE_SEEK" */
    '\x01','N','E','G','A','T','I','V','E','_','S','E','E','K',
/* 0x18d7c = "VERR_GVM_MISMATCH_VMCPU_SIZE" */
    '\x01','G','V','M','_','\x19','_','V','M','C','P','U','_','\xfe',
/* 0x18d8a = "Invalid saved page state." */
    '\x0c','s','a','v','e','d',' ','\xcb','s','t','a','t','e','.',
/* 0x18d98 = "VERR_WRITE_PROTECT" */
    '\x01','W','R','I','T','E','_','P','R','O','T','E','C','T',
/* 0x18da6 = "VERR_GVM_MISMATCH_SVN_REV" */
    '\x01','G','V','M','_','\x19','_','S','V','N','_','R','E','V',
/* 0x18db4 = "VERR_LDRVI_BAD_CERT_FORMAT" */
    '\x01','\xf2','\x1d','C','E','R','T','_','F','O','R','M','A','T',
/* 0x18dc2 = "VERR_ZIP_CORRUPTED" */
    '\x01','Z','I','P','_','C','O','R','R','U','P','T','E','D',
/* 0x18dd0 = "VERR_IPE_UNEXPECTED_INFO_STATUS" */
    '\x01','\x14','\x86','I','N','F','O','_','S','T','A','T','U','S',
/* 0x18dde = "VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING" */
    '\x01','\xa1','\x05','V','I','S','I','B','L','E','_','\xd4','_','\xc6',
/* 0x18dec = "VERR_XAR_BAD_FILE_ELEMENT" */
    '\x01','X','A','R','_','\x1d','\xab','E','L','E','M','E','N','T',
/* 0x18dfa = "VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS" */
    '\x01','\x24','\x89','\x1c','\xaf','V','O','L','_','D','E','S','C','S',
/* 0x18e08 = "VERR_NOT_SUP_IN_RAW_MODE" */
    '\x01','\x06','\x95','I','N','_','R','A','W','_','M','O','D','E',
/* 0x18e16 = "VERR_SSM_INTEGRITY_UNIT_MAGIC" */
    '\x01','\xb0','\xf5','_','U','N','I','T','_','M','A','G','I','C',
/* 0x18e24 = "VERR_SSM_LOADED_TOO_MUCH" */
    '\x01','\xb0','L','O','A','D','E','D','_','\x1c','M','U','C','H',
/* 0x18e32 = "VERR_DBGC_PARSE_VARIABLE_NOT_FOUND" */
    '\x01','\xfb','\xe2','V','A','R','I','A','B','L','E','_','\x06','\x2a',
/* 0x18e40 = "VERR_NEM_MAP_PAGES_FAILED" */
    '\x01','\xec','_','M','A','P','_','P','A','G','E','S','_','\x16',
/* 0x18e4e = "VERR_LDRLX_BAD_SONAME" */
    '\x01','L','D','R','L','X','_','\x1d','S','O','N','A','M','E',
/* 0x18e5c = "Trap not handled." */
    'T','r','a','p',' ','\x08','h','a','n','d','l','e','d','.',
/* 0x18e6a = "VERR_VFS_CHAIN_NOT_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','\x06','P','A','T','H','_','O','N','L','Y',
/* 0x18e78 = "Failed to patch the IDT." */
    '\x8b','\x0a','p','a','t','c','h',' ','\x02','I','D','T','.',
/* 0x18e85 = "No active trap." */
    '\xe6','a','c','t','i','v','e',' ','t','r','a','p','.',
/* 0x18e92 = "VINF_PGM_CACHED_PAGE" */
    '\x0e','\x8c','C','A','C','H','E','D','_','P','A','G','E',
/* 0x18e9f = "The specified path is a directory and not a file (hardening)." */
    '\x03','\x18','\xd0','\x0b','a',' ','\x26','\x99','\x08','a',' ','\x1f','\xad',
/* 0x18eac = "VERR_VFS_CHAIN_FIVE_ARGS" */
    '\x01','\x8d','_','\x8e','F','I','V','E','_','A','R','G','S',
/* 0x18eb9 = "VERR_VFS_CHAIN_PATH_ONLY" */
    '\x01','\x8d','_','\x8e','P','A','T','H','_','O','N','L','Y',
/* 0x18ec6 = "Bad image relocation." */
    '\x9d','\x25','r','e','l','o','c','a','t','i','o','n','.',
/* 0x18ed3 = "VERR_TOO_MANY_SEMAPHORES" */
    '\x01','\x1c','\xaf','S','E','M','A','P','H','O','R','E','S',
/* 0x18ee0 = "VWRN_NO_DIRENT_INFO" */
    '\xe4','\x60','D','I','R','E','N','T','_','I','N','F','O',
/* 0x18eed = "VERR_CR_KEY_UNSUPPORTED_CIPHER" */
    '\x01','\x22','K','E','Y','_','\x1b','C','I','P','H','E','R',
/* 0x18efa = "The saved state file version is not supported." */
    '\x03','s','a','v','e','d',' ','\xcd','\x1f','\xcf','\x0b','\x08','\xa4',
/* 0x18f07 = "Generic device structure version mismatch." */
    '\xa6','\xa3','\xea','\xcf','m','i','s','m','a','t','c','h','.',
/* 0x18f14 = "VWRN_DBGC_ALREADY_REGISTERED" */
    '\xe4','\xfb','\x9a','R','E','G','I','S','T','E','R','E','D',
/* 0x18f21 = "Unable to find patch." */
    '\xde','\x0a','f','i','n','d',' ','p','a','t','c','h','.',
/* 0x18f2e = "The specified path is a root path (hardening)." */
    '\x03','\x18','\xd0','\x0b','a',' ','r','o','o','t',' ','\xd0','\xad',
/* 0x18f3b = "VERR_PGM_POOL_GET_PAGE_FAILED" */
    '\x01','\x8c','P','O','O','L','_','G','E','T','_','\xdb','\x16',
/* 0x18f48 = "VERR_NOT_A_DIRECTORY" */
    '\x01','\x06','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x18f55 = "VERR_SUPLIB_OWNER_NOT_ROOT" */
    '\x01','\xd5','O','W','N','E','R','_','\x06','R','O','O','T',
/* 0x18f62 = "VERR_SUPLIB_PATH_TOO_SHORT" */
    '\x01','\xd5','P','A','T','H','_','\x1c','S','H','O','R','T',
/* 0x18f6f = "VERR_DRIVE_LOCKED" */
    '\x01','D','R','I','V','E','_','L','O','C','K','E','D',
/* 0x18f7c = "Recompiler: Label internal processing error #5." */
    '\x13','L','a','b','e','l',' ','\x17','\x04','\x09','#','5','.',
/* 0x18f89 = "VERR_LDR_MISMATCH_NATIVE" */
    '\x01','L','D','R','_','\x19','_','N','A','T','I','V','E',
/* 0x18f96 = "Internal processing error #6 in the IEM code." */
    '\x07','\x04','\x09','#','6',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x18fa3 = "VERR_IOQUEUE_FULL" */
    '\x01','I','O','Q','U','E','U','E','_','F','U','L','L',
/* 0x18fb0 = "VERR_ALREADY_INITIALIZED" */
    '\x01','\x9a','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x18fbd = "VINF_EM_RAW_TO_R3" */
    '\x0e','E','M','_','R','A','W','_','T','O','_','R','3',
/* 0x18fca = "VERR_VD_UNKNOWN_CFG_VALUES" */
    '\x01','\xff','\x91','C','F','G','_','V','A','L','U','E','S',
/* 0x18fd7 = "Wrong magic value." */
    'W','r','o','n','g',' ','m','a','g','i','c',' ','\xf3',
/* 0x18fe4 = "VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH" */
    '\x01','\x8d','_','\x8e','F','I','N','A','L','_','\xb5','_','\x19',
/* 0x18ff1 = "Recompiler: Label internal processing error #1." */
    '\x13','L','a','b','e','l',' ','\x17','\x04','\x09','#','1','.',
/* 0x18ffe = "Uneven input." */
    'U','n','e','v','e','n',' ','i','n','p','u','t','.',
/* 0x1900b = "VERR_SVM_DISABLED" */
    '\x01','S','V','M','_','D','I','S','A','B','L','E','D',
/* 0x19018 = "VERR_ISOMK_IPE_FINALIZE_1" */
    '\x01','\x24','\x14','F','I','N','A','L','I','Z','E','_','1',
/* 0x19025 = "VERR_VD_GEN_INVALID_HEADER" */
    '\x01','\xff','G','E','N','_','\x05','H','E','A','D','E','R',
/* 0x19032 = "VERR_TAR_CHKSUM_MISMATCH" */
    '\x01','T','A','R','_','C','H','K','S','U','M','_','\x19',
/* 0x1903f = "The specified path is a file and not a directory (hardening)." */
    '\x03','\x18','\xd0','\x0b','a',' ','\x1f','\x99','\x08','a',' ','\x26','\xad',
/* 0x1904c = "IOMMU device is not present." */
    '\xfc',' ','\xa3','\x0b','\x08','p','r','e','s','e','n','t','.',
/* 0x19059 = "VERR_DBGC_PARSE_COMMAND_NOT_FOUND" */
    '\x01','\xfb','\xe2','C','O','M','M','A','N','D','_','\x06','\x2a',
/* 0x19066 = "VINF_ALREADY_INITIALIZED" */
    '\x0e','\x9a','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19073 = "VERR_VM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xcc','_','D','R','I','V','E','R','_','\xbc','_','\x19',
/* 0x19080 = "VERR_NOT_SAME_DEVICE" */
    '\x01','\x06','S','A','M','E','_','D','E','V','I','C','E',
/* 0x1908d = "VERR_URI_NOT_FILE_SCHEME" */
    '\x01','U','R','I','_','\x06','\xab','S','C','H','E','M','E',
/* 0x1909a = "VINF_EM_TERMINATE" */
    '\x0e','E','M','_','T','E','R','M','I','N','A','T','E',
/* 0x190a7 = "VERR_VD_DMG_INVALID_HEADER" */
    '\x01','\xff','D','M','G','_','\x05','H','E','A','D','E','R',
/* 0x190b4 = "VERR_NO_TRANSLATION" */
    '\x01','\x60','T','R','A','N','S','L','A','T','I','O','N',
/* 0x190c1 = "VERR_SUP_VP_BAD_MZ_OFFSET" */
    '\x01','\x95','\xbd','\x1d','M','Z','_','O','F','F','S','E','T',
/* 0x190ce = "VERR_VD_VHD_INVALID_HEADER" */
    '\x01','\xff','V','H','D','_','\x05','H','E','A','D','E','R',
/* 0x190db = "VINF_NOT_IMPLEMENTED" */
    '\x0e','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x190e8 = "VERR_HTTP_HOST_NOT_FOUND" */
    '\x01','H','T','T','P','_','H','O','S','T','_','\x06','\x2a',
/* 0x190f5 = "VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION" */
    '\x01','\x22','\xb7','T','B','S','C','E','R','T','_','\x1b','\xbc',
/* 0x19102 = "VERR_NET_NO_NETWORK" */
    '\x01','N','E','T','_','\x60','N','E','T','W','O','R','K',
/* 0x1910f = "VERR_HOSTIF_IOCTL" */
    '\x01','H','O','S','T','I','F','_','I','O','C','T','L',
/* 0x1911c = "VERR_HTTP_ABORTED" */
    '\x01','H','T','T','P','_','A','B','O','R','T','E','D',
/* 0x19129 = "Unexpected VM exception." */
    '\x94','\xcc',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x19136 = "VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC" */
    '\x01','\x24','\x89','\x1d','\x95','V','O','L','_','D','E','S','C',
/* 0x19143 = "VERR_LDRVI_READ_ERROR_HASH" */
    '\x01','\xf2','R','E','A','D','_','\x1a','_','H','A','S','H',
/* 0x19150 = "VINF_TAR_DIR_PATH" */
    '\x0e','T','A','R','_','D','I','R','_','P','A','T','H',
/* 0x1915d = "VERR_SSM_UNIT_EXISTS" */
    '\x01','\xb0','U','N','I','T','_','E','X','I','S','T','S',
/* 0x1916a = "VERR_IEM_FIXUP_TOO_MANY" */
    '\x01','\x9b','F','I','X','U','P','_','\x1c','M','A','N','Y',
/* 0x19177 = "VERR_VFS_CHAIN_TOO_FEW_ARGS" */
    '\x01','\x8d','_','\x8e','\x1c','F','E','W','_','A','R','G','S',
/* 0x19184 = "VERR_SSM_STATE_GREW_TOO_BIG" */
    '\x01','\xb0','\xef','_','G','R','E','W','_','\x1c','B','I','G',
/* 0x19191 = "VERR_GMM_CHUNK_NOT_FOUND" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x06','\x2a',
/* 0x1919e = "Recompiler: Label internal processing error #4." */
    '\x13','L','a','b','e','l',' ','\x17','\x04','\x09','#','4','.',
/* 0x191ab = "VERR_SUPLIB_STAT_ENUM_FAILED" */
    '\x01','\xd5','S','T','A','T','_','E','N','U','M','_','\x16',
/* 0x191b8 = "VERR_NOT_IMPLEMENTED" */
    '\x01','\x06','I','M','P','L','E','M','E','N','T','E','D',
/* 0x191c5 = "VERR_UNEVEN_INPUT" */
    '\x01','U','N','E','V','E','N','_','I','N','P','U','T',
/* 0x191d2 = "VINF_LOG_DISABLED" */
    '\x0e','L','O','G','_','D','I','S','A','B','L','E','D',
/* 0x191df = "VERR_PGM_PHYS_NOT_MMIO2" */
    '\x01','\x8c','P','H','Y','S','_','\x06','M','M','I','O','2',
/* 0x191ec = "VERR_VM_REQUEST_INVALID_TYPE" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','\x05','\xb5',
/* 0x191f9 = "VERR_SVM_INVALID_GUEST_STATE" */
    '\x01','S','V','M','_','\x05','G','U','E','S','T','_','\xef',
/* 0x19206 = "VERR_NET_SHUTDOWN" */
    '\x01','N','E','T','_','S','H','U','T','D','O','W','N',
/* 0x19213 = "VINF_EM_DBG_EVENT" */
    '\x0e','E','M','_','D','B','G','_','E','V','E','N','T',
/* 0x19220 = "VERR_XAR_BAD_DIGEST_LENGTH" */
    '\x01','X','A','R','_','\x1d','\xbe','L','E','N','G','T','H',
/* 0x1922d = "Internal processing error # in the PDM device code." */
    '\x07','\x04','\x09','#',' ','\x0f','\x02','P','D','M',' ','\xa3','\x83',
/* 0x1923a = "VERR_GMM_OUT_OF_MEMORY" */
    '\x01','G','M','M','_','O','U','T','_','O','F','_','\xb6',
/* 0x19247 = "Empty string." */
    'E','m','p','t','y',' ','s','t','r','i','n','g','.',
/* 0x19254 = "VERR_IO_SECTOR_NOT_FOUND" */
    '\x01','I','O','_','S','E','C','T','O','R','_','\x06','\x2a',
/* 0x19261 = "Internal processing error #5 in the IEM code." */
    '\x07','\x04','\x09','#','5',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x1926e = "VERR_GMM_IS_NOT_SANE" */
    '\x01','G','M','M','_','I','S','_','\x06','S','A','N','E',
/* 0x1927b = "VERR_VM_ATRESET_NOT_FOUND" */
    '\x01','\xcc','_','A','T','R','E','S','E','T','_','\x06','\x2a',
/* 0x19288 = "VERR_SSM_UNIT_NOT_OWNER" */
    '\x01','\xb0','U','N','I','T','_','\x06','O','W','N','E','R',
/* 0x19295 = "Recompiler: Fixup internal processing error #1." */
    '\x13','F','i','x','u','p',' ','\x17','\x04','\x09','#','1','.',
/* 0x192a2 = "VWRN_DBGC_CMD_PENDING" */
    '\xe4','\xfb','C','M','D','_','P','E','N','D','I','N','G',
/* 0x192af = "VERR_SUP_VP_SYSFER_DLL" */
    '\x01','\x95','\xbd','S','Y','S','F','E','R','_','D','L','L',
/* 0x192bc = "VERR_SEM_BAD_CONTEXT" */
    '\x01','S','E','M','_','\x1d','C','O','N','T','E','X','T',
/* 0x192c9 = "VINF_DBGC_BP_NO_COMMAND" */
    '\x0e','\xfb','B','P','_','\x60','C','O','M','M','A','N','D',
/* 0x192d6 = "VERR_DISK_INVALID_FORMAT" */
    '\x01','D','I','S','K','_','\x05','F','O','R','M','A','T',
/* 0x192e3 = "Internal processing error #2 in the IEM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x192f0 = "VERR_DBG_INVALID_ADDRESS" */
    '\x01','D','B','G','_','\x05','A','D','D','R','E','S','S',
/* 0x192fd = "Recompiler: Label internal processing error #6." */
    '\x13','L','a','b','e','l',' ','\x17','\x04','\x09','#','6','.',
/* 0x1930a = "VERR_VBGL_IOCTL_FAILED" */
    '\x01','V','B','G','L','_','I','O','C','T','L','_','\x16',
/* 0x19317 = "VERR_PGM_SAVED_REC_TYPE" */
    '\x01','\x8c','S','A','V','E','D','_','R','E','C','_','\xb5',
/* 0x19324 = "Unknow file type." */
    'U','n','k','n','o','w',' ','\x1f','t','y','p','e','.',
/* 0x19331 = "VERR_NEM_VM_CREATE_FAILED" */
    '\x01','\xec','_','\xcc','_','C','R','E','A','T','E','_','\x16',
/* 0x1933e = "VERR_VFS_CHAIN_EMPTY_ARG" */
    '\x01','\x8d','_','\x8e','E','M','P','T','Y','_','A','R','G',
/* 0x1934b = "Generic driver structure version mismatch." */
    '\xa6','\xc5','\xea','\xcf','m','i','s','m','a','t','c','h','.',
/* 0x19358 = "VERR_VFS_CHAIN_FOUR_ARGS" */
    '\x01','\x8d','_','\x8e','F','O','U','R','_','A','R','G','S',
/* 0x19365 = "Internal processing error #3 in the IEM code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x19372 = "VERR_IOMMU_DTE_READ_FAILED" */
    '\x01','\xfc','_','D','T','E','_','R','E','A','D','_','\x16',
/* 0x1937f = "Failed to map the guest PML4." */
    '\x8b','\x0a','m','a','p',' ','\x02','\xbb','P','M','L','4','.',
/* 0x1938c = "VERR_ISOMK_IPE_DESC_COUNT" */
    '\x01','\x24','\x14','D','E','S','C','_','C','O','U','N','T',
/* 0x19399 = "verification " */
    'v','e','r','i','f','i','c','a','t','i','o','n',' ',
/* 0x193a6 = "VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE" */
    '\x01','M','A','N','I','F','E','S','T','_','\x1b','\xbe','\xb5',
/* 0x193b3 = "VERR_IEM_EMIT_BAD_MEM_SIZE" */
    '\x01','\x9b','E','M','I','T','_','\x1d','M','E','M','_','\xfe',
/* 0x193c0 = "Raw: Invalid image file type." */
    'R','a','w',':',' ','\x0c','\x25','\x1f','t','y','p','e','.',
/* 0x193cd = "VERR_ASN1_INVALID_UTC_TIME_ENCODING" */
    '\x01','\xa1','\x05','U','T','C','_','T','I','M','E','_','\xc6',
/* 0x193da = "VERR_IOQUEUE_BUSY" */
    '\x01','I','O','Q','U','E','U','E','_','B','U','S','Y',
/* 0x193e7 = "Recompiler: Label internal processing error #3." */
    '\x13','L','a','b','e','l',' ','\x17','\x04','\x09','#','3','.',
/* 0x193f4 = "VERR_SHCLPB_NO_DATA" */
    '\x01','S','H','C','L','P','B','_','\x60','D','A','T','A',
/* 0x19401 = "VERR_TOO_MANY_OPEN_FILES" */
    '\x01','\x1c','\xaf','O','P','E','N','_','F','I','L','E','S',
/* 0x1940e = "VERR_NEM_RING3_ONLY" */
    '\x01','\xec','_','R','I','N','G','3','_','O','N','L','Y',
/* 0x1941b = "VINF_SEM_BAD_CONTEXT" */
    '\x0e','S','E','M','_','\x1d','C','O','N','T','E','X','T',
/* 0x19428 = "Bad VTG header - misc." */
    '\x9d','V','T','G',' ','\xb3','-',' ','m','i','s','c','.',
/* 0x19435 = "VERR_SSM_INTEGRITY_DIR_MAGIC" */
    '\x01','\xb0','\xf5','_','D','I','R','_','M','A','G','I','C',
/* 0x19442 = "VERR_PGM_MAPPING_IPE" */
    '\x01','\x8c','M','A','P','P','I','N','G','_','I','P','E',
/* 0x1944f = "VERR_SVM_UNEXPECTED_PATCH_TYPE" */
    '\x01','S','V','M','_','\x86','P','A','T','C','H','_','\xb5',
/* 0x1945c = "Bad bundle data." */
    '\x9d','b','u','n','d','l','e',' ','d','a','t','a','.',
/* 0x19469 = "No more files found." */
    '\xe6','m','o','r','e',' ','f','i','l','e','s',' ','\x88',
/* 0x19476 = "VERR_GCM_NOT_HANDLED" */
    '\x01','G','C','M','_','\x06','H','A','N','D','L','E','D',
/* 0x19483 = "VERR_GMM_INSTANCE" */
    '\x01','G','M','M','_','I','N','S','T','A','N','C','E',
/* 0x19490 = "Not ROM page." */
    'N','o','t',' ','R','O','M',' ','p','a','g','e','.',
/* 0x1949d = "VERR_VFS_CHAIN_INVALID_ARGUMENT" */
    '\x01','\x8d','_','\x8e','\x05','A','R','G','U','M','E','N','T',
/* 0x194aa = "VERR_VD_VMDK_INVALID_WRITE" */
    '\x01','\xff','V','M','D','K','_','\x05','W','R','I','T','E',
/* 0x194b7 = "The name is empty." */
    '\x03','n','a','m','e',' ','\x0b','e','m','p','t','y','.',
/* 0x194c4 = "VERR_PDM_CRITSECT_NOT_FOUND" */
    '\x01','\x5e','C','R','I','T','S','E','C','T','_','\x06','\x2a',
/* 0x194d1 = "VERR_INVALID_UUID_FORMAT" */
    '\x01','\x05','U','U','I','D','_','F','O','R','M','A','T',
/* 0x194de = "VERR_SUPLIB_PATH_NOT_CLEAN" */
    '\x01','\xd5','P','A','T','H','_','\x06','C','L','E','A','N',
/* 0x194eb = "VERR_SVM_VMEXIT_FAILED" */
    '\x01','S','V','M','_','V','M','E','X','I','T','_','\x16',
/* 0x194f8 = "VERR_ISOMK_IPE_EMPTY_PATH" */
    '\x01','\x24','\x14','E','M','P','T','Y','_','P','A','T','H',
/* 0x19505 = "VERR_GIM_NOT_ENABLED" */
    '\x01','G','I','M','_','\x06','E','N','A','B','L','E','D',
/* 0x19512 = "Invalid HM64ON32OP value." */
    '\x0c','H','M','6','4','O','N','3','2','O','P',' ','\xf3',
/* 0x1951f = "VERR_RT_REQUEST_STATE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\xef',
/* 0x1952c = "VERR_GMM_PAGE_NOT_SHARED" */
    '\x01','G','M','M','_','\xdb','\x06','S','H','A','R','E','D',
/* 0x19539 = "VERR_IEM_LABEL_TOO_MANY" */
    '\x01','\x9b','L','A','B','E','L','_','\x1c','M','A','N','Y',
/* 0x19546 = "VERR_PDM_NOT_PCI_DEVICE" */
    '\x01','\x5e','\x06','P','C','I','_','D','E','V','I','C','E',
/* 0x19553 = "VERR_ISOMK_IPE_ROOT_SLASH" */
    '\x01','\x24','\x14','R','O','O','T','_','S','L','A','S','H',
/* 0x19560 = "VERR_DBGF_OWNER_BUSY" */
    '\x01','\xb9','_','O','W','N','E','R','_','B','U','S','Y',
/* 0x1956d = "VERR_UNRESOLVED_ERROR" */
    '\x01','U','N','R','E','S','O','L','V','E','D','_','\x1a',
/* 0x1957a = "VERR_SUP_VP_TOO_MANY_SECTIONS" */
    '\x01','\x95','\xbd','\x1c','\xaf','S','E','C','T','I','O','N','S',
/* 0x19587 = "VINF_EM_WAIT_SIPI" */
    '\x0e','E','M','_','W','A','I','T','_','S','I','P','I',
/* 0x19594 = "Internal processing error #4 in the IEM code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x195a1 = "VERR_CR_DIGEST_DEPRECATED" */
    '\x01','\x22','\xbe','D','E','P','R','E','C','A','T','E','D',
/* 0x195ae = "VINF_IEM_REEXEC_JUMP" */
    '\x0e','\x9b','R','E','E','X','E','C','_','J','U','M','P',
/* 0x195bb = "VERR_HM_WRONG_CPU" */
    '\x01','H','M','_','W','R','O','N','G','_','C','P','U',
/* 0x195c8 = "VERR_IOM_INVALID_MMIO_RANGE" */
    '\x01','I','O','M','_','\x05','\xd2','_','R','A','N','G','E',
/* 0x195d5 = "VERR_VFS_CHAIN_TAKES_FSS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','F','S','S',
/* 0x195e2 = "VERR_PGM_INVALID_PAGE_DIRECTORY" */
    '\x01','\x8c','\x05','\xdb','D','I','R','E','C','T','O','R','Y',
/* 0x195ef = "VERR_VD_RAW_INVALID_HEADER" */
    '\x01','\xff','R','A','W','_','\x05','H','E','A','D','E','R',
/* 0x195fc = "VERR_IS_A_SYMLINK" */
    '\x01','I','S','_','A','_','S','Y','M','L','I','N','K',
/* 0x19609 = "VERR_TIMER_ACTIVE" */
    '\x01','T','I','M','E','R','_','A','C','T','I','V','E',
/* 0x19616 = "VINF_GVM_NOT_BLOCKED" */
    '\x0e','G','V','M','_','\x06','B','L','O','C','K','E','D',
/* 0x19623 = "VERR_CR_X509_OSSL_D2I_FAILED" */
    '\x01','\x22','\xb7','O','S','S','L','_','D','2','I','_','\x16',
/* 0x19630 = "Internal processing error #1 in the IEM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x1963d = "Internal processing error #7 in the IEM code." */
    '\x07','\x04','\x09','#','7',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x1964a = "VERR_CFGM_NO_PARENT" */
    '\x01','C','F','G','M','_','\x60','P','A','R','E','N','T',
/* 0x19657 = "VINF_CR_DIGEST_DEPRECATED" */
    '\x0e','\x22','\xbe','D','E','P','R','E','C','A','T','E','D',
/* 0x19664 = "VERR_DBG_NO_SYMBOLS" */
    '\x01','D','B','G','_','\x60','S','Y','M','B','O','L','S',
/* 0x19671 = "Recompiler: Too many fixups." */
    '\x13','T','o','o',' ','\xb4','f','i','x','u','p','s','.',
/* 0x1967e = "The operation was cancelled." */
    '\x03','\x96','\x11','c','a','n','c','e','l','l','e','d','.',
/* 0x1968b = "Invalid port number." */
    '\x0c','p','o','r','t',' ','n','u','m','b','e','r','.',
/* 0x19698 = "Recompiler: Too many labels." */
    '\x13','T','o','o',' ','\xb4','l','a','b','e','l','s','.',
/* 0x196a5 = "Send timeout." */
    'S','e','n','d',' ','t','i','m','e','o','u','t','.',
/* 0x196b2 = "VERR_OUT_OF_RANGE" */
    '\x01','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x196bf = "Verification " */
    'V','e','r','i','f','i','c','a','t','i','o','n',' ',
/* 0x196cc = "VERR_SUP_VP_IMAGE_TOO_BIG" */
    '\x01','\x95','\xbd','I','M','A','G','E','_','\x1c','B','I','G',
/* 0x196d9 = "Internal processing error #9 in the IEM code." */
    '\x07','\x04','\x09','#','9',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x196e6 = "VERR_LDRVI_BAD_CERT_HDR_TYPE" */
    '\x01','\xf2','\x1d','C','E','R','T','_','H','D','R','_','\xb5',
/* 0x196f3 = "Send aborted." */
    'S','e','n','d',' ','a','b','o','r','t','e','d','.',
/* 0x19700 = "VERR_CR_PKCS7_OSSL_D2I_FAILED" */
    '\x01','\x22','\xe3','O','S','S','L','_','D','2','I','_','\x16',
/* 0x1970d = "Failed to normalize ASN." */
    '\x8b','\x0a','n','o','r','m','a','l','i','z','e',' ','\xf4',
/* 0x1971a = "VWRN_NO_TRANSLATION" */
    '\xe4','\x60','T','R','A','N','S','L','A','T','I','O','N',
/* 0x19727 = "The value is not an integer." */
    '\x03','\xfa','\x0b','\x08','\x87','i','n','t','e','g','e','r','.',
/* 0x19734 = "VERR_PDM_BAD_PCI_CONFIG" */
    '\x01','\x5e','\x1d','P','C','I','_','C','O','N','F','I','G',
/* 0x19741 = "VERR_NEM_NOT_AVAILABLE" */
    '\x01','\xec','_','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1974e = "The VFS object type is not known." */
    '\x03','\x8d',' ','\xa7','\xf1','\x0b','\x08','k','n','o','w','n','.',
/* 0x1975b = "VERR_DBGC_PARSE_INVALID_OPERATION" */
    '\x01','\xfb','\xe2','\x05','O','P','E','R','A','T','I','O','N',
/* 0x19768 = "VERR_ADDRESS_TOO_BIG" */
    '\x01','A','D','D','R','E','S','S','_','\x1c','B','I','G',
/* 0x19775 = "Recompiler: Label internal processing error #2." */
    '\x13','L','a','b','e','l',' ','\x17','\x04','\x09','#','2','.',
/* 0x19782 = "VERR_SUPDRV_VTG_STRING_TOO_LONG" */
    '\x01','\x90','V','T','G','_','\xd4','_','\x1c','L','O','N','G',
/* 0x1978f = "Internal processing error #8 in the IEM code." */
    '\x07','\x04','\x09','#','8',' ','\x0f','\x02','I','E','M',' ','\x83',
/* 0x1979c = "VERR_TOO_MANY_REFERENCES" */
    '\x01','\x1c','\xaf','R','E','F','E','R','E','N','C','E','S',
/* 0x197a9 = "Bad tree height." */
    '\x9d','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x197b6 = "VERR_VD_VDI_INVALID_HEADER" */
    '\x01','\xff','V','D','I','_','\x05','H','E','A','D','E','R',
/* 0x197c3 = "VERR_ISOFS_TOO_MANY_PART_MAPS" */
    '\x01','\xa2','\x1c','\xaf','P','A','R','T','_','M','A','P','S',
/* 0x197d0 = "No route to host." */
    '\xe6','r','o','u','t','e',' ','\x0a','h','o','s','t','.',
/* 0x197dd = "VERR_LDRVI_BAD_MZ_OFFSET" */
    '\x01','\xf2','\x1d','M','Z','_','O','F','F','S','E','T',
/* 0x197e9 = "VERR_WRONG_ORDER" */
    '\x01','W','R','O','N','G','_','O','R','D','E','R',
/* 0x197f5 = "VERR_CACHE_EMPTY" */
    '\x01','C','A','C','H','E','_','E','M','P','T','Y',
/* 0x19801 = "VERR_LDRVI_READ_ERROR_HDR" */
    '\x01','\xf2','R','E','A','D','_','\x1a','_','H','D','R',
/* 0x1980d = "UNSUPPORTED_" */
    'U','N','S','U','P','P','O','R','T','E','D','_',
/* 0x19819 = "VERR_ASN1_TIME_TAG_MISMATCH" */
    '\x01','\xa1','T','I','M','E','_','T','A','G','_','\x19',
/* 0x19825 = "VWRN_NUMBER_TOO_BIG" */
    '\xe4','N','U','M','B','E','R','_','\x1c','B','I','G',
/* 0x19831 = "VERR_DWARF_BAD_INFO" */
    '\x01','D','W','A','R','F','_','\x1d','I','N','F','O',
/* 0x1983d = "VERR_CANT_CREATE" */
    '\x01','C','A','N','T','_','C','R','E','A','T','E',
/* 0x19849 = "VERR_SELM_HM_IPE" */
    '\x01','S','E','L','M','_','H','M','_','I','P','E',
/* 0x19855 = "Wrong file type." */
    'W','r','o','n','g',' ','\x1f','t','y','p','e','.',
/* 0x19861 = "Internal processing error in the DWARF code." */
    '\x07','\x04','\x09','\x0f','\x02','D','W','A','R','F',' ','\x83',
/* 0x1986d = "Invalid tag length." */
    '\x0c','t','a','g',' ','l','e','n','g','t','h','.',
/* 0x19879 = "VERR_DISK_CHANGE" */
    '\x01','D','I','S','K','_','C','H','A','N','G','E',
/* 0x19885 = "Internal processing error #1 in TRPM." */
    '\x07','\x04','\x09','#','1',' ','\x0f','T','R','P','M','.',
/* 0x19891 = "VERR_PGM_HANDLER_NOT_FOUND" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x06','\x2a',
/* 0x1989d = "VERR_VFS_CHAIN_ONLY_IOS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','I','O','S',
/* 0x198a9 = "VERR_PDM_USBDEV_VERSION_MISMATCH" */
    '\x01','\x5e','U','S','B','D','E','V','_','\xbc','_','\x19',
/* 0x198b5 = "Internal VMX processing error no 3." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','3','.',
/* 0x198c1 = "Process Verification Failure: No KERNE32." */
    '\x1e','\x0d','\x12','\xe6','K','E','R','N','E','3','2','.',
/* 0x198cd = "VERR_TRPM_HM_IPE" */
    '\x01','T','R','P','M','_','H','M','_','I','P','E',
/* 0x198d9 = "VERR_VFS_CHAIN_ONLY_FSS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','F','S','S',
/* 0x198e5 = "VERR_PDM_NO_USB_PORTS" */
    '\x01','\x5e','\x60','U','S','B','_','P','O','R','T','S',
/* 0x198f1 = "VERR_ZIP_BAD_HEADER" */
    '\x01','Z','I','P','_','\x1d','H','E','A','D','E','R',
/* 0x198fd = "VERR_XAR_BAD_FILE_INODE" */
    '\x01','X','A','R','_','\x1d','\xab','I','N','O','D','E',
/* 0x19909 = "VERR_SSM_ALREADY_CANCELLED" */
    '\x01','\xb0','\x9a','C','A','N','C','E','L','L','E','D',
/* 0x19915 = "VERR_NO_MORE_FILES" */
    '\x01','\x60','M','O','R','E','_','F','I','L','E','S',
/* 0x19921 = "VERR_DBG_LINE_NOT_FOUND" */
    '\x01','D','B','G','_','L','I','N','E','_','\x06','\x2a',
/* 0x1992d = "VERR_CR_PKCS7_GENERIC_ERROR" */
    '\x01','\x22','\xe3','G','E','N','E','R','I','C','_','\x1a',
/* 0x19939 = "Bad DWARF info." */
    '\x9d','D','W','A','R','F',' ','i','n','f','o','.',
/* 0x19945 = "VERR_VD_IOCTX_HALT" */
    '\x01','\xff','I','O','C','T','X','_','H','A','L','T',
/* 0x19951 = "VERR_VD_UNKNOWN_INTERFACE" */
    '\x01','\xff','\x91','I','N','T','E','R','F','A','C','E',
/* 0x1995d = "VERR_IS_A_SOCKET" */
    '\x01','I','S','_','A','_','S','O','C','K','E','T',
/* 0x19969 = "End of string." */
    'E','n','d',' ','\x15','s','t','r','i','n','g','.',
/* 0x19975 = "VERR_NET_PRINT_ERROR" */
    '\x01','N','E','T','_','P','R','I','N','T','_','\x1a',
/* 0x19981 = "VERR_IEM_TB_ALLOC_FAILED" */
    '\x01','\x9b','T','B','_','A','L','L','O','C','_','\x16',
/* 0x1998d = "VERR_AOUT_EXE_NOT_SUPPORTED" */
    '\x01','A','O','U','T','_','E','X','E','_','\x06','\x82',
/* 0x19999 = "NEM is not enabled." */
    '\xec',' ','\x0b','\x08','e','n','a','b','l','e','d','.',
/* 0x199a5 = "Internal processing error #3 in SSM code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','S','S','M',' ','\x83',
/* 0x199b1 = "Unsupported key format." */
    '\x97','k','e','y',' ','f','o','r','m','a','t','.',
/* 0x199bd = "VERR_CR_PKCS7_DIGEST_CREATE_ERROR" */
    '\x01','\x22','\xe3','\xbe','C','R','E','A','T','E','_','\x1a',
/* 0x199c9 = "Internal processing error #2 in the DBGF register code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xb9',' ','\xe9','\x83',
/* 0x199d5 = "Unknown breakpoint." */
    '\xf8','b','r','e','a','k','p','o','i','n','t','.',
/* 0x199e1 = "VERR_PDM_DEVINS_VERSION_MISMATCH" */
    '\x01','\x5e','D','E','V','I','N','S','_','\xbc','_','\x19',
/* 0x199ed = "VERR_DBGC_PARSE_BAD_RESULT_TYPE" */
    '\x01','\xfb','\xe2','\x1d','R','E','S','U','L','T','_','\xb5',
/* 0x199f9 = "VERR_HTTP_CURL_ERROR" */
    '\x01','H','T','T','P','_','C','U','R','L','_','\x1a',
/* 0x19a05 = "VERR_S3_CANCELED" */
    '\x01','S','3','_','C','A','N','C','E','L','E','D',
/* 0x19a11 = "instruction " */
    'i','n','s','t','r','u','c','t','i','o','n',' ',
/* 0x19a1d = "VINF_GVM_YIELDED" */
    '\x0e','G','V','M','_','Y','I','E','L','D','E','D',
/* 0x19a29 = "VERR_MANIFEST_FILE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','\xab','\x19',
/* 0x19a35 = "VERR_DBGF_NOT_ATTACHED" */
    '\x01','\xb9','_','\x06','A','T','T','A','C','H','E','D',
/* 0x19a41 = "VERR_SUPDRV_SERVICE_NOT_FOUND" */
    '\x01','\x90','S','E','R','V','I','C','E','_','\x06','\x2a',
/* 0x19a4d = "VERR_NET_PATH_NOT_FOUND" */
    '\x01','N','E','T','_','P','A','T','H','_','\x06','\x2a',
/* 0x19a59 = "Internal SVM processing error no 2." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','2','.',
/* 0x19a65 = "VERR_ASN1_INVALID_BOOLEAN_ENCODING" */
    '\x01','\xa1','\x05','B','O','O','L','E','A','N','_','\xc6',
/* 0x19a71 = "VERR_BAD_EXE_FORMAT" */
    '\x01','\x1d','E','X','E','_','F','O','R','M','A','T',
/* 0x19a7d = "Encountered " */
    'E','n','c','o','u','n','t','e','r','e','d',' ',
/* 0x19a89 = "VERR_DBG_MOD_IPE" */
    '\x01','D','B','G','_','M','O','D','_','I','P','E',
/* 0x19a95 = "VERR_GMM_NOT_PAGE_OWNER" */
    '\x01','G','M','M','_','\x06','\xdb','O','W','N','E','R',
/* 0x19aa1 = "The request was canceled." */
    '\x03','\xaa','\x11','c','a','n','c','e','l','e','d','.',
/* 0x19aad = "Invalid key length." */
    '\x0c','k','e','y',' ','l','e','n','g','t','h','.',
/* 0x19ab9 = "VERR_PDM_DEVHLP_VERSION_MISMATCH" */
    '\x01','\x5e','D','E','V','H','L','P','_','\xbc','_','\x19',
/* 0x19ac5 = "VERR_DWARF_UNKNOWN_FORM" */
    '\x01','D','W','A','R','F','_','\x91','F','O','R','M',
/* 0x19ad1 = "The specified path is too short (hardening)." */
    '\x03','\x18','\xd0','\x0b','\xa0','s','h','o','r','t',' ','\xad',
/* 0x19add = "Internal VMX processing error no 1." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','1','.',
/* 0x19ae9 = "VERR_LDRELF_EXEC" */
    '\x01','L','D','R','E','L','F','_','E','X','E','C',
/* 0x19af5 = "VERR_PDM_DRIVER_VERSION_MISMATCH" */
    '\x01','\x5e','D','R','I','V','E','R','_','\xbc','_','\x19',
/* 0x19b01 = "VERR_DIS_INVALID_OPCODE" */
    '\x01','D','I','S','_','\x05','O','P','C','O','D','E',
/* 0x19b0d = "VERR_CR_X509_GENERIC_ERROR" */
    '\x01','\x22','\xb7','G','E','N','E','R','I','C','_','\x1a',
/* 0x19b19 = "VINF_DBGF_BP_ALREADY_EXIST" */
    '\x0e','\xb9','_','B','P','_','\x9a','E','X','I','S','T',
/* 0x19b25 = "VERR_PATM_HM_IPE" */
    '\x01','P','A','T','M','_','H','M','_','I','P','E',
/* 0x19b31 = "VWRN_VRDP_PDU_NOT_SUPPORTED" */
    '\xe4','V','R','D','P','_','P','D','U','_','\x06','\x82',
/* 0x19b3d = "Generic no change error." */
    '\xa6','n','o',' ','c','h','a','n','g','e',' ','\x84',
/* 0x19b49 = "Generic BER parse error." */
    '\xa6','B','E','R',' ','p','a','r','s','e',' ','\x84',
/* 0x19b55 = "The URI is empty." */
    '\x03','U','R','I',' ','\x0b','e','m','p','t','y','.',
/* 0x19b61 = "VERR_PDM_HIF_OPEN_FAILED" */
    '\x01','\x5e','H','I','F','_','O','P','E','N','_','\x16',
/* 0x19b6d = "VERR_IEM_INVALID_OPERAND_SIZE" */
    '\x01','\x9b','\x05','O','P','E','R','A','N','D','_','\xfe',
/* 0x19b79 = "VERR_VUSB_NO_URB_MEMORY" */
    '\x01','V','U','S','B','_','\x60','U','R','B','_','\xb6',
/* 0x19b85 = "VERR_VD_BLOCK_FREE" */
    '\x01','\xff','B','L','O','C','K','_','F','R','E','E',
/* 0x19b91 = "VERR_ZIP_UNSUPPORTED_METHOD" */
    '\x01','Z','I','P','_','\x1b','M','E','T','H','O','D',
/* 0x19b9d = "certificate " */
    'c','e','r','t','i','f','i','c','a','t','e',' ',
/* 0x19ba9 = "VERR_PKZIP_NO_EOCB" */
    '\x01','P','K','Z','I','P','_','\x60','E','O','C','B',
/* 0x19bb5 = "VERR_BROKEN_PIPE" */
    '\x01','B','R','O','K','E','N','_','P','I','P','E',
/* 0x19bc1 = "VINF_LOG_NO_LOGGER" */
    '\x0e','L','O','G','_','\x60','L','O','G','G','E','R',
/* 0x19bcd = "Is a socket." */
    'I','s',' ','a',' ','s','o','c','k','e','t','.',
/* 0x19bd9 = "Internal processing error #1 in CFGM." */
    '\x07','\x04','\x09','#','1',' ','\x0f','C','F','G','M','.',
/* 0x19be5 = "VERR_VD_DISCARD_NOT_SUPPORTED" */
    '\x01','\xff','D','I','S','C','A','R','D','_','\x06','\x82',
/* 0x19bf1 = "VERR_VUSB_NO_PORTS" */
    '\x01','V','U','S','B','_','\x60','P','O','R','T','S',
/* 0x19bfd = "Internal processing error #2 in the HM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','H','M',' ','\x83',
/* 0x19c09 = "VERR_CFGM_NOT_BYTES" */
    '\x01','C','F','G','M','_','\x06','B','Y','T','E','S',
/* 0x19c15 = "VERR_PDM_USBINS_VERSION_MISMATCH" */
    '\x01','\x5e','U','S','B','I','N','S','_','\xbc','_','\x19',
/* 0x19c21 = "VERR_DBGF_TRACER_IPE_1" */
    '\x01','\xb9','_','T','R','A','C','E','R','_','\x14','1',
/* 0x19c2d = "Broken pipe." */
    'B','r','o','k','e','n',' ','p','i','p','e','.',
/* 0x19c39 = "Internal processing error #3 in the HM code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','H','M',' ','\x83',
/* 0x19c45 = "VERR_VFS_CHAIN_TWO_ARGS" */
    '\x01','\x8d','_','\x8e','T','W','O','_','A','R','G','S',
/* 0x19c51 = "Unknown hash digest type." */
    '\xf8','h','a','s','h',' ','\xd6','t','y','p','e','.',
/* 0x19c5d = "VERR_VM_REQUEST_STATE" */
    '\x01','\xcc','_','R','E','Q','U','E','S','T','_','\xef',
/* 0x19c69 = "VERR_TM_TOO_MANY_TIMERS" */
    '\x01','T','M','_','\x1c','\xaf','T','I','M','E','R','S',
/* 0x19c75 = "Internal VMX processing error no 5." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','5','.',
/* 0x19c81 = "Internal SVM processing error no 3." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','3','.',
/* 0x19c8d = "VINF_INTERRUPTED" */
    '\x0e','I','N','T','E','R','R','U','P','T','E','D',
/* 0x19c99 = "VERR_TAR_SIZE_NOT_ZERO" */
    '\x01','T','A','R','_','\xfe','_','\x06','Z','E','R','O',
/* 0x19ca5 = "VERR_ASN1_INVALID_INTEGER_ENCODING" */
    '\x01','\xa1','\x05','I','N','T','E','G','E','R','_','\xc6',
/* 0x19cb1 = "VINF_SUP_DRIVERLESS" */
    '\x0e','\x95','D','R','I','V','E','R','L','E','S','S',
/* 0x19cbd = "Active trap." */
    'A','c','t','i','v','e',' ','t','r','a','p','.',
/* 0x19cc9 = "VERR_SUPLIB_DIR_ENUM_FAILED" */
    '\x01','\xd5','D','I','R','_','E','N','U','M','_','\x16',
/* 0x19cd5 = "VERR_RAW_MODE_NOT_SUPPORTED" */
    '\x01','R','A','W','_','M','O','D','E','_','\x06','\x82',
/* 0x19ce1 = "Unfinished code." */
    'U','n','f','i','n','i','s','h','e','d',' ','\x83',
/* 0x19ced = "NEM failed to set TSC." */
    '\xec',' ','\x98','\x0a','s','e','t',' ','T','S','C','.',
/* 0x19cf9 = "VERR_NEM_MISSING_FEATURE" */
    '\x01','\xec','_','\xc4','_','F','E','A','T','U','R','E',
/* 0x19d05 = "VERR_VMX_UNEXPECTED_EXCEPTION" */
    '\x01','\xe1','\x86','E','X','C','E','P','T','I','O','N',
/* 0x19d11 = "VERR_MANIFEST_DIGEST_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','\xbe','\x19',
/* 0x19d1d = "VERR_CFG_INVALID_FORMAT" */
    '\x01','C','F','G','_','\x05','F','O','R','M','A','T',
/* 0x19d29 = "VINF_NEM_FLUSH_TLB" */
    '\x0e','\xec','_','F','L','U','S','H','_','T','L','B',
/* 0x19d35 = "Bad VTG magic value." */
    '\x9d','V','T','G',' ','m','a','g','i','c',' ','\xf3',
/* 0x19d41 = "VERR_IO_BAD_COMMAND" */
    '\x01','I','O','_','\x1d','C','O','M','M','A','N','D',
/* 0x19d4d = "VERR_HM_CONFIG_MISMATCH" */
    '\x01','H','M','_','C','O','N','F','I','G','_','\x19',
/* 0x19d59 = "Bad VTG string." */
    '\x9d','V','T','G',' ','s','t','r','i','n','g','.',
/* 0x19d65 = "VERR_DND_GUEST_ERROR" */
    '\x01','D','N','D','_','G','U','E','S','T','_','\x1a',
/* 0x19d71 = "Expected primitive ASN." */
    '\xb8','p','r','i','m','i','t','i','v','e',' ','\xf4',
/* 0x19d7d = "VERR_PGM_HANDY_PAGE_IPE" */
    '\x01','\x8c','H','A','N','D','Y','_','\xdb','I','P','E',
/* 0x19d89 = "Not more data in ASN." */
    'N','o','t',' ','m','o','r','e',' ','\x9c','\x0f','\xf4',
/* 0x19d95 = "VERR_URI_INVALID_SCHEME" */
    '\x01','U','R','I','_','\x05','S','C','H','E','M','E',
/* 0x19da1 = "Internal processing error #3 in TRPM." */
    '\x07','\x04','\x09','#','3',' ','\x0f','T','R','P','M','.',
/* 0x19dad = "VERR_NUMBER_TOO_BIG" */
    '\x01','N','U','M','B','E','R','_','\x1c','B','I','G',
/* 0x19db9 = "Internal VMX processing error no 2." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','2','.',
/* 0x19dc5 = "VERR_ISOFS_DESC_CRC_MISMATCH" */
    '\x01','\xa2','D','E','S','C','_','C','R','C','_','\x19',
/* 0x19dd1 = "VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH" */
    '\x01','\xb0','L','O','A','D','_','\xb6','_','\xfe','_','\x19',
/* 0x19ddd = "VERR_SSM_NO_LOAD_EXEC" */
    '\x01','\xb0','\x60','L','O','A','D','_','E','X','E','C',
/* 0x19de9 = "encountered " */
    'e','n','c','o','u','n','t','e','r','e','d',' ',
/* 0x19df5 = "Internal processing error #1 in the DBGF register code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xb9',' ','\xe9','\x83',
/* 0x19e01 = "VINF_HGCM_SAVE_STATE" */
    '\x0e','H','G','C','M','_','S','A','V','E','_','\xef',
/* 0x19e0d = "VERR_TAR_UNKNOWN_TYPE_FLAG" */
    '\x01','T','A','R','_','\x91','\xb5','_','F','L','A','G',
/* 0x19e19 = "The I/O request ID was not found." */
    '\x03','I','/','O',' ','\xaa','I','D',' ','\x11','\x08','\x88',
/* 0x19e25 = "The ICB for is too big." */
    '\x03','I','C','B',' ','\x10','\x0b','\xa0','b','i','g','.',
/* 0x19e31 = "Unsupported " */
    'U','n','s','u','p','p','o','r','t','e','d',' ',
/* 0x19e3d = "VERR_CPU_OFFLINE" */
    '\x01','C','P','U','_','O','F','F','L','I','N','E',
/* 0x19e49 = "Certificate " */
    'C','e','r','t','i','f','i','c','a','t','e',' ',
/* 0x19e55 = "VERR_INTERRUPTED" */
    '\x01','I','N','T','E','R','R','U','P','T','E','D',
/* 0x19e61 = "VERR_NET_HOST_NOT_FOUND" */
    '\x01','N','E','T','_','H','O','S','T','_','\x06','\x2a',
/* 0x19e6d = "VERR_SUP_DRIVERLESS" */
    '\x01','\x95','D','R','I','V','E','R','L','E','S','S',
/* 0x19e79 = "Internal SVM processing error no 4." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','4','.',
/* 0x19e85 = "VERR_VMX_INVALID_VMXON_PTR" */
    '\x01','\xe1','\x05','V','M','X','O','N','_','P','T','R',
/* 0x19e91 = "Bad executable." */
    '\x9d','e','x','e','c','u','t','a','b','l','e','.',
/* 0x19e9d = "(hardening)." */
    '(','h','a','r','d','e','n','i','n','g',')','.',
/* 0x19ea9 = "Internal processing error #2 in TRPM." */
    '\x07','\x04','\x09','#','2',' ','\x0f','T','R','P','M','.',
/* 0x19eb5 = "VERR_SUPDRV_TSC_READ_FAILED" */
    '\x01','\x90','T','S','C','_','R','E','A','D','_','\x16',
/* 0x19ec1 = "VERR_HTTP_INIT_FAILED" */
    '\x01','H','T','T','P','_','I','N','I','T','_','\x16',
/* 0x19ecd = "VERR_INVALID_SESSION_ID" */
    '\x01','\x05','S','E','S','S','I','O','N','_','I','D',
/* 0x19ed9 = "VERR_PGM_DYNMAP_IPE" */
    '\x01','\x8c','D','Y','N','M','A','P','_','I','P','E',
/* 0x19ee5 = "Internal processing error in the page pool code." */
    '\x07','\x04','\x09','\x0f','\x02','\xcb','p','o','o','l',' ','\x83',
/* 0x19ef1 = "VERR_IEM_DBGINFO_IPE_2" */
    '\x01','\x9b','D','B','G','I','N','F','O','_','\x14','2',
/* 0x19efd = "VERR_IEM_DBGINFO_IPE_1" */
    '\x01','\x9b','D','B','G','I','N','F','O','_','\x14','1',
/* 0x19f09 = "VERR_NET_NOT_SOCKET" */
    '\x01','N','E','T','_','\x06','S','O','C','K','E','T',
/* 0x19f15 = "Internal processing error #5 in the HM code." */
    '\x07','\x04','\x09','#','5',' ','\x0f','\x02','H','M',' ','\x83',
/* 0x19f21 = "VTG string is too long." */
    'V','T','G',' ','\xf0','\x0b','\xa0','l','o','n','g','.',
/* 0x19f2d = "VERR_SUPLIB_NOT_DIR_NOT_FILE" */
    '\x01','\xd5','\x06','D','I','R','_','\x06','F','I','L','E',
/* 0x19f39 = "Internal processing error #2 in SSM code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','S','S','M',' ','\x83',
/* 0x19f45 = "VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT" */
    '\x01','\xf2','\x60','\xb6','_','\xe2','O','U','T','P','U','T',
/* 0x19f51 = "VERR_DBGC_PARSE_UNEXPECTED_OPERATOR" */
    '\x01','\xfb','\xe2','\x86','O','P','E','R','A','T','O','R',
/* 0x19f5d = "VERR_DBGF_CANCELLED" */
    '\x01','\xb9','_','C','A','N','C','E','L','L','E','D',
/* 0x19f69 = "VERR_CR_SPC_UNKNOWN_DIGEST_ALGO" */
    '\x01','\x22','S','P','C','_','\x91','\xbe','A','L','G','O',
/* 0x19f75 = "Internal SVM processing error no 5." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','5','.',
/* 0x19f81 = "VERR_PIPE_NOT_WRITE" */
    '\x01','P','I','P','E','_','\x06','W','R','I','T','E',
/* 0x19f8d = "VERR_VFS_UNSUPPORTED_CREATE_TYPE" */
    '\x01','\x8d','_','\x1b','C','R','E','A','T','E','_','\xb5',
/* 0x19f99 = "Operation not supported." */
    'O','p','e','r','a','t','i','o','n',' ','\x08','\xa4',
/* 0x19fa5 = "VERR_DWARF_UNEXPECTED_FORM" */
    '\x01','D','W','A','R','F','_','\x86','F','O','R','M',
/* 0x19fb1 = "VERR_DBGF_ALREADY_ATTACHED" */
    '\x01','\xb9','_','\x9a','A','T','T','A','C','H','E','D',
/* 0x19fbd = "VERR_CSAM_HM_IPE" */
    '\x01','C','S','A','M','_','H','M','_','I','P','E',
/* 0x19fc9 = "Recompiler: " */
    'R','e','c','o','m','p','i','l','e','r',':',' ',
/* 0x19fd5 = "Generic VM-entry failure." */
    '\xa6','\xcc','-','\xc8','f','a','i','l','u','r','e','.',
/* 0x19fe1 = "VERR_MM_HYPER_NO_MEMORY" */
    '\x01','M','M','_','H','Y','P','E','R','_','\x60','\xb6',
/* 0x19fed = "The specified path was not clean (hardening)." */
    '\x03','\x18','\xd0','\x11','\x08','c','l','e','a','n',' ','\xad',
/* 0x19ff9 = "VERR_PGM_INVALID_PDPE_ADDR" */
    '\x01','\x8c','\x05','P','D','P','E','_','A','D','D','R',
/* 0x1a005 = "VERR_VFS_CHAIN_SIX_ARGS" */
    '\x01','\x8d','_','\x8e','S','I','X','_','A','R','G','S',
/* 0x1a011 = "VERR_CR_X509_NOT_VERIFIED" */
    '\x01','\x22','\xb7','\x06','V','E','R','I','F','I','E','D',
/* 0x1a01d = "VERR_PGM_HANDLER_IPE_1" */
    '\x01','\x8c','H','A','N','D','L','E','R','_','\x14','1',
/* 0x1a029 = "Internal processing error #1 in the HM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','H','M',' ','\x83',
/* 0x1a035 = "Internal processing error #4 in the HM code." */
    '\x07','\x04','\x09','#','4',' ','\x0f','\x02','H','M',' ','\x83',
/* 0x1a041 = "Internal SVM processing error no 1." */
    '\x07','S','V','M',' ','\x04','\x09','n','o',' ','1','.',
/* 0x1a04d = "VERR_PDM_DRVINS_VERSION_MISMATCH" */
    '\x01','\x5e','D','R','V','I','N','S','_','\xbc','_','\x19',
/* 0x1a059 = "Invalid session ID." */
    '\x0c','s','e','s','s','i','o','n',' ','I','D','.',
/* 0x1a065 = "VINF_EM_DBG_STOP" */
    '\x0e','E','M','_','D','B','G','_','S','T','O','P',
/* 0x1a071 = "VERR_NEM_FLUSH_TLB" */
    '\x01','\xec','_','F','L','U','S','H','_','T','L','B',
/* 0x1a07d = "VERR_PDM_DEVICE_VERSION_MISMATCH" */
    '\x01','\x5e','D','E','V','I','C','E','_','\xbc','_','\x19',
/* 0x1a089 = "VERR_VD_DMG_XML_PARSE_ERROR" */
    '\x01','\xff','D','M','G','_','X','M','L','_','\xe2','\x1a',
/* 0x1a095 = "Invalid RT request packet." */
    '\x0c','R','T',' ','\xaa','p','a','c','k','e','t','.',
/* 0x1a0a1 = "Unsupported fixup type." */
    '\x97','f','i','x','u','p',' ','t','y','p','e','.',
/* 0x1a0ad = "VERR_SUPLIB_PATH_TOO_LONG" */
    '\x01','\xd5','P','A','T','H','_','\x1c','L','O','N','G',
/* 0x1a0b9 = "VERR_LDRLX_BAD_PAGE_MAP" */
    '\x01','L','D','R','L','X','_','\x1d','\xdb','M','A','P',
/* 0x1a0c5 = "Internal VMX processing error no 4." */
    '\x07','V','M','X',' ','\x04','\x09','n','o',' ','4','.',
/* 0x1a0d1 = "Signature verification failed." */
    'S','i','g','n','a','t','u','r','e',' ','\xf6','\x7d',
/* 0x1a0dd = "VERR_ISOFS_ICB_TOO_SMALL" */
    '\x01','\xa2','I','C','B','_','\x1c','S','M','A','L','L',
/* 0x1a0e9 = "Internal processing error #1 in SSM code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','S','S','M',' ','\x83',
/* 0x1a0f5 = "VERR_PIPE_NOT_READ" */
    '\x01','P','I','P','E','_','\x06','R','E','A','D',
/* 0x1a100 = "VINF_SVM_VMEXIT" */
    '\x0e','S','V','M','_','V','M','E','X','I','T',
/* 0x1a10b = "Invalid string tag for a X." */
    '\x0c','\xf0','t','a','g',' ','\x10','a',' ','X','.',
/* 0x1a116 = "VERR_XAR_TOC_DIGEST_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','\xbe','\x19',
/* 0x1a121 = "VERR_SUP_VP_FOUND_EXEC_MEMORY" */
    '\x01','\x95','\xbd','\x2a','_','E','X','E','C','_','\xb6',
/* 0x1a12c = "VERR_PDM_UNKNOWN_USBREG_VERSION" */
    '\x01','\x5e','\x91','U','S','B','R','E','G','_','\xbc',
/* 0x1a137 = "Network path not found." */
    'N','e','t','w','o','r','k',' ','\xd0','\x08','\x88',
/* 0x1a142 = "VERR_VFS_CHAIN_TAKES_VFS" */
    '\x01','\x8d','_','\x8e','T','A','K','E','S','_','\x8d',
/* 0x1a14d = "VERR_PGM_PHYS_NOT_RAM" */
    '\x01','\x8c','P','H','Y','S','_','\x06','R','A','M',
/* 0x1a158 = "VERR_SSM_INTEGRITY_REC_HDR" */
    '\x01','\xb0','\xf5','_','R','E','C','_','H','D','R',
/* 0x1a163 = "Generic invalid state warning." */
    '\xa6','\x8f','\xcd','w','a','r','n','i','n','g','.',
/* 0x1a16e = "VERR_FAM_OPEN_FAILED" */
    '\x01','F','A','M','_','O','P','E','N','_','\x16',
/* 0x1a179 = "Not MMIO page." */
    'N','o','t',' ','\xd2',' ','p','a','g','e','.',
/* 0x1a184 = "VERR_CV_BAD_FORMAT" */
    '\x01','C','V','_','\x1d','F','O','R','M','A','T',
/* 0x1a18f = "VERR_PDM_THREAD_IPE_2" */
    '\x01','\x5e','T','H','R','E','A','D','_','\x14','2',
/* 0x1a19a = "VERR_SSM_INTEGRITY_UNIT_NOT_FOUND" */
    '\x01','\xb0','\xf5','_','U','N','I','T','_','\x06','\x2a',
/* 0x1a1a5 = "Unexpected " */
    'U','n','e','x','p','e','c','t','e','d',' ',
/* 0x1a1b0 = "VERR_PDM_UNKNOWN_DRVREG_VERSION" */
    '\x01','\x5e','\x91','D','R','V','R','E','G','_','\xbc',
/* 0x1a1bb = "VERR_XAR_BAD_FILE_MODE" */
    '\x01','X','A','R','_','\x1d','\xab','M','O','D','E',
/* 0x1a1c6 = "VERR_SUPDRV_VTG_MAGIC" */
    '\x01','\x90','V','T','G','_','M','A','G','I','C',
/* 0x1a1d1 = "Internal error: Unexpected status code." */
    '\x07','\xd7','\x94','s','t','a','t','u','s',' ','\x83',
/* 0x1a1dc = "VERR_VRDP_INVALID_MODE" */
    '\x01','V','R','D','P','_','\x05','M','O','D','E',
/* 0x1a1e7 = "VINF_SEM_NESTED" */
    '\x0e','S','E','M','_','N','E','S','T','E','D',
/* 0x1a1f2 = "VERR_VMM_RC_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','C','_','\xbc','_','\x19',
/* 0x1a1fd = "Wrong type." */
    'W','r','o','n','g',' ','t','y','p','e','.',
/* 0x1a208 = "VERR_DIR_NOT_EMPTY" */
    '\x01','D','I','R','_','\x06','E','M','P','T','Y',
/* 0x1a213 = "Invalid client ID." */
    '\x0c','c','l','i','e','n','t',' ','I','D','.',
/* 0x1a21e = "VERR_PGM_PHYS_INVALID_PAGE_ID" */
    '\x01','\x8c','P','H','Y','S','_','\x05','\xdb','I','D',
/* 0x1a229 = "VERR_XAR_INVALID_FILE_NAME" */
    '\x01','X','A','R','_','\x05','\xab','N','A','M','E',
/* 0x1a234 = "VERR_PDM_DEVICE_NOT_FOUND" */
    '\x01','\x5e','D','E','V','I','C','E','_','\x06','\x2a',
/* 0x1a23f = "VINF_ASN1_MORE_DATA" */
    '\x0e','\xa1','M','O','R','E','_','D','A','T','A',
/* 0x1a24a = "Invalid RT request state." */
    '\x0c','R','T',' ','\xaa','s','t','a','t','e','.',
/* 0x1a255 = "VERR_IEM_VAR_UNEXPECTED_KIND" */
    '\x01','\x9b','V','A','R','_','\x86','K','I','N','D',
/* 0x1a260 = "VERR_DBGC_COMMAND_FAILED" */
    '\x01','\xfb','C','O','M','M','A','N','D','_','\x16',
/* 0x1a26b = "VERR_TOO_MUCH_DATA" */
    '\x01','\x1c','M','U','C','H','_','D','A','T','A',
/* 0x1a276 = "VERR_SSM_CANCELLED" */
    '\x01','\xb0','C','A','N','C','E','L','L','E','D',
/* 0x1a281 = "processing " */
    'p','r','o','c','e','s','s','i','n','g',' ',
/* 0x1a28c = "VERR_UNEXPECTED_EXCEPTION" */
    '\x01','\x86','E','X','C','E','P','T','I','O','N',
/* 0x1a297 = "Disk is full." */
    'D','i','s','k',' ','\x0b','f','u','l','l','.',
/* 0x1a2a2 = "VERR_INVALID_PARAMETER" */
    '\x01','\x05','P','A','R','A','M','E','T','E','R',
/* 0x1a2ad = "Invalid codepoint." */
    '\x0c','c','o','d','e','p','o','i','n','t','.',
/* 0x1a2b8 = "VERR_TRPM_PANIC" */
    '\x01','T','R','P','M','_','P','A','N','I','C',
/* 0x1a2c3 = "Internal processing error #1 in the MMIO code." */
    '\x07','\x04','\x09','#','1',' ','\x0f','\x02','\xd2',' ','\x83',
/* 0x1a2ce = "VERR_PDM_UNKNOWN_DEVREG_VERSION" */
    '\x01','\x5e','\x91','D','E','V','R','E','G','_','\xbc',
/* 0x1a2d9 = "VERR_NEM_NOT_ENABLED" */
    '\x01','\xec','_','\x06','E','N','A','B','L','E','D',
/* 0x1a2e4 = "VERR_DWARF_UNEXPECTED_END" */
    '\x01','D','W','A','R','F','_','\x86','E','N','D',
/* 0x1a2ef = "VERR_IOMMU_CMD_HW_ERROR" */
    '\x01','\xfc','_','C','M','D','_','H','W','_','\x1a',
/* 0x1a2fa = "VERR_IOMMU_NOT_PRESENT" */
    '\x01','\xfc','_','\x06','P','R','E','S','E','N','T',
/* 0x1a305 = "VERR_SUPDRV_VTG_BAD_ATTR" */
    '\x01','\x90','V','T','G','_','\x1d','A','T','T','R',
/* 0x1a310 = "VERR_VBGL_INVALID_ADDR" */
    '\x01','V','B','G','L','_','\x05','A','D','D','R',
/* 0x1a31b = "Internal processing error in the RTMp code." */
    '\x07','\x04','\x09','\x0f','\x02','R','T','M','p',' ','\x83',
/* 0x1a326 = "Encoding data failed." */
    'E','n','c','o','d','i','n','g',' ','\x9c','\x7d',
/* 0x1a331 = "VERR_LDRELF_DYN" */
    '\x01','L','D','R','E','L','F','_','D','Y','N',
/* 0x1a33c = "VERR_CPUM_INVALID_XCR0" */
    '\x01','C','P','U','M','_','\x05','X','C','R','0',
/* 0x1a347 = "VERR_VMX_VMPTRLD_FAILED" */
    '\x01','\xe1','V','M','P','T','R','L','D','_','\x16',
/* 0x1a352 = "CPUM internal processing error #1." */
    'C','P','U','M',' ','\x17','\x04','\x09','#','1','.',
/* 0x1a35d = "VERR_ISOFS_UNEXPECTED_VDS_DESC" */
    '\x01','\xa2','\x86','V','D','S','_','D','E','S','C',
/* 0x1a368 = "VERR_UNSUPPORTED_ALIGNMENT" */
    '\x01','\x1b','A','L','I','G','N','M','E','N','T',
/* 0x1a373 = "VERR_LDRMACHO_BAD_SYMTAB_SIZE" */
    '\x01','\xe7','\x1d','S','Y','M','T','A','B','_','\xfe',
/* 0x1a37e = "VERR_CFGM_NO_NODE" */
    '\x01','C','F','G','M','_','\x60','N','O','D','E',
/* 0x1a389 = "VERR_CFG_NO_VALUE" */
    '\x01','C','F','G','_','\x60','V','A','L','U','E',
/* 0x1a394 = "VINF_UNSUPPORTED_ALIGNMENT" */
    '\x0e','\x1b','A','L','I','G','N','M','E','N','T',
/* 0x1a39f = "VERR_PGM_INVALID_SAVED_PAGE_STATE" */
    '\x01','\x8c','\x05','S','A','V','E','D','_','\xdb','\xef',
/* 0x1a3aa = "VERR_FILE_LOCK_LOST" */
    '\x01','\xab','L','O','C','K','_','L','O','S','T',
/* 0x1a3b5 = "VERR_SUP_VP_DEBUGGED" */
    '\x01','\x95','\xbd','D','E','B','U','G','G','E','D',
/* 0x1a3c0 = "VERR_IOM_HM_IPE" */
    '\x01','I','O','M','_','H','M','_','I','P','E',
/* 0x1a3cb = "VERR_PDM_NO_SUCH_LUN" */
    '\x01','\x5e','\x60','S','U','C','H','_','L','U','N',
/* 0x1a3d6 = "VERR_ISO_FS_UNKNOWN_AD_TYPE" */
    '\x01','\xc1','_','F','S','_','\x91','A','D','_','\xb5',
/* 0x1a3e1 = "VERR_XAR_BAD_HDR_SIZE" */
    '\x01','X','A','R','_','\x1d','H','D','R','_','\xfe',
/* 0x1a3ec = "VERR_DONT_PANIC" */
    '\x01','D','O','N','T','_','P','A','N','I','C',
/* 0x1a3f7 = "VERR_INVALID_CLIENT_ID" */
    '\x01','\x05','C','L','I','E','N','T','_','I','D',
/* 0x1a402 = "VERR_VMX_VMENTRY_FAILED" */
    '\x01','\xe1','V','M','E','N','T','R','Y','_','\x16',
/* 0x1a40d = "VWRN_DBGF_ALREADY_RUNNING" */
    '\xe4','\xb9','_','\x9a','R','U','N','N','I','N','G',
/* 0x1a418 = "VERR_VMM_R0_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','0','_','\xbc','_','\x19',
/* 0x1a423 = "Invalid CPU index." */
    '\x0c','C','P','U',' ','i','n','d','e','x','.',
/* 0x1a42e = "VWRN_INVALID_PARAMETER" */
    '\xe4','\x05','P','A','R','A','M','E','T','E','R',
/* 0x1a439 = "VERR_ELF_EXE_NOT_SUPPORTED" */
    '\x01','E','L','F','_','E','X','E','_','\x06','\x82',
/* 0x1a444 = "VERR_IPE_UNEXPECTED_ERROR_STATUS" */
    '\x01','\x14','\x86','\x1a','_','S','T','A','T','U','S',
/* 0x1a44f = "VERR_GMM_PAGE_ALREADY_FREE" */
    '\x01','G','M','M','_','\xdb','\x9a','F','R','E','E',
/* 0x1a45a = "VERR_CACHE_FULL" */
    '\x01','C','A','C','H','E','_','F','U','L','L',
/* 0x1a465 = "VERR_DBGC_BP_EXISTS" */
    '\x01','\xfb','B','P','_','E','X','I','S','T','S',
/* 0x1a470 = "Item already used." */
    'I','t','e','m',' ','\x7f','u','s','e','d','.',
/* 0x1a47b = "VERR_NOT_AVAILABLE" */
    '\x01','\x06','A','V','A','I','L','A','B','L','E',
/* 0x1a486 = "Internal processing error #2 in the MMIO code." */
    '\x07','\x04','\x09','#','2',' ','\x0f','\x02','\xd2',' ','\x83',
/* 0x1a491 = "VERR_VM_RESTORED" */
    '\x01','\xcc','_','R','E','S','T','O','R','E','D',
/* 0x1a49c = "VERR_DIS_INVALID_MODRM" */
    '\x01','D','I','S','_','\x05','M','O','D','R','M',
/* 0x1a4a7 = "VERR_SUP_VP_BAD_IMAGE_SIZE" */
    '\x01','\x95','\xbd','\x1d','I','M','A','G','E','_','\xfe',
/* 0x1a4b2 = "VERR_ISOMK_IPE_BUFFER_SIZE" */
    '\x01','\x24','\x14','B','U','F','F','E','R','_','\xfe',
/* 0x1a4bd = "VERR_URI_TOO_SHORT" */
    '\x01','U','R','I','_','\x1c','S','H','O','R','T',
/* 0x1a4c8 = "validator: " */
    'v','a','l','i','d','a','t','o','r',':',' ',
/* 0x1a4d3 = "The specified path is too long (hardening)." */
    '\x03','\x18','\xd0','\x0b','\xa0','l','o','n','g',' ','\xad',
/* 0x1a4de = "VERR_LDR_BAD_FIXUP" */
    '\x01','L','D','R','_','\x1d','F','I','X','U','P',
/* 0x1a4e9 = "VERR_VD_SHRINK_NOT_SUPPORTED" */
    '\x01','\xff','S','H','R','I','N','K','_','\x06','\x82',
/* 0x1a4f4 = "Invalid VM request packet." */
    '\x0c','\xcc',' ','\xaa','p','a','c','k','e','t','.',
/* 0x1a4ff = "VERR_SEM_NESTED" */
    '\x01','S','E','M','_','N','E','S','T','E','D',
/* 0x1a50a = "VERR_NET_INIT_FAILED" */
    '\x01','N','E','T','_','I','N','I','T','_','\x16',
/* 0x1a515 = "VERR_IMAGE_TOO_BIG" */
    '\x01','I','M','A','G','E','_','\x1c','B','I','G',
/* 0x1a520 = "VERR_TAR_UNSUPPORTED_PAX_TYPE" */
    '\x01','T','A','R','_','\x1b','P','A','X','_','\xb5',
/* 0x1a52b = "Unsupported tag encountered in ICB." */
    '\x97','t','a','g',' ','\xae','\x0f','I','C','B','.',
/* 0x1a536 = "The specified chunk was not found." */
    '\x03','\x18','c','h','u','n','k',' ','\x11','\x08','\x88',
/* 0x1a541 = "VERR_COM_HOST_ERROR" */
    '\x01','C','O','M','_','H','O','S','T','_','\x1a',
/* 0x1a54c = "Pipe is busy." */
    'P','i','p','e',' ','\x0b','b','u','s','y','.',
/* 0x1a557 = "VERR_SUPLIB_INVALID_INTERNAL_APP_DIR" */
    '\x01','\xd5','\x05','\xc2','A','P','P','_','D','I','R',
/* 0x1a562 = "VERR_PROCESS_NOT_FOUND" */
    '\x01','P','R','O','C','E','S','S','_','\x06','\x2a',
/* 0x1a56d = "VERR_SUP_VP_MEMORY_READ_ERROR" */
    '\x01','\x95','\xbd','\xb6','_','R','E','A','D','_','\x1a',
/* 0x1a578 = "VERR_TOO_MANY_SYMLINKS" */
    '\x01','\x1c','\xaf','S','Y','M','L','I','N','K','S',
/* 0x1a583 = "VERR_SVM_INVALID_PVMCB" */
    '\x01','S','V','M','_','\x05','P','V','M','C','B',
/* 0x1a58e = "Invalid parameter." */
    '\x0c','p','a','r','a','m','e','t','e','r','.',
/* 0x1a599 = "UNEXPECTED_" */
    'U','N','E','X','P','E','C','T','E','D','_',
/* 0x1a5a4 = "VERR_DBGF_STACK_IPE_1" */
    '\x01','\xb9','_','S','T','A','C','K','_','\x14','1',
/* 0x1a5af = "VERR_SEM_IS_SET" */
    '\x01','S','E','M','_','I','S','_','S','E','T',
/* 0x1a5ba = "VERR_DBGF_STACK_IPE_2" */
    '\x01','\xb9','_','S','T','A','C','K','_','\x14','2',
/* 0x1a5c5 = "VERR_LDR_ARCH_MISMATCH" */
    '\x01','L','D','R','_','A','R','C','H','_','\x19',
/* 0x1a5d0 = "VERR_FTP_INIT_FAILED" */
    '\x01','F','T','P','_','I','N','I','T','_','\x16',
/* 0x1a5db = "descriptor " */
    'd','e','s','c','r','i','p','t','o','r',' ',
/* 0x1a5e6 = "Too many VCPUs." */
    'T','o','o',' ','\xb4','V','C','P','U','s','.',
/* 0x1a5f1 = "VERR_LDRVI_FILE_LENGTH_ERROR" */
    '\x01','\xf2','\xab','L','E','N','G','T','H','_','\x1a',
/* 0x1a5fc = "VERR_DWARF_TODO" */
    '\x01','D','W','A','R','F','_','T','O','D','O',
/* 0x1a607 = "VERR_ASN1_INVALID_UTF8_STRING_ENCODING" */
    '\x01','\xa1','\x05','U','T','F','8','_','\xd4','_','\xc6',
/* 0x1a612 = "VERR_PDM_NO_USBPROXY" */
    '\x01','\x5e','\x60','U','S','B','P','R','O','X','Y',
/* 0x1a61d = "VERR_PGM_PHYS_NOT_ROM" */
    '\x01','\x8c','P','H','Y','S','_','\x06','R','O','M',
/* 0x1a628 = "CPUM internal processing error #2." */
    'C','P','U','M',' ','\x17','\x04','\x09','#','2','.',
/* 0x1a633 = "VERR_SVM_IN_USE" */
    '\x01','S','V','M','_','I','N','_','U','S','E',
/* 0x1a63e = "VERR_DBGC_PARSE_NO_SCRATCH" */
    '\x01','\xfb','\xe2','\x60','S','C','R','A','T','C','H',
/* 0x1a649 = "Internal processing error #3 in the MMIO code." */
    '\x07','\x04','\x09','#','3',' ','\x0f','\x02','\xd2',' ','\x83',
/* 0x1a654 = "VERR_ENV_VAR_NOT_FOUND" */
    '\x01','E','N','V','_','V','A','R','_','\x06','\x2a',
/* 0x1a65f = "breakpoint " */
    'b','r','e','a','k','p','o','i','n','t',' ',
/* 0x1a66a = "VERR_DWARF_BAD_POS" */
    '\x01','D','W','A','R','F','_','\x1d','P','O','S',
/* 0x1a675 = "VERR_COM_IPRT_ERROR" */
    '\x01','C','O','M','_','I','P','R','T','_','\x1a',
/* 0x1a680 = "VERR_PGM_INVALID_CR3_ADDR" */
    '\x01','\x8c','\x05','C','R','3','_','A','D','D','R',
/* 0x1a68b = "VERR_DWARF_BAD_LNE" */
    '\x01','D','W','A','R','F','_','\x1d','L','N','E',
/* 0x1a696 = "VINF_ENV_VAR_NOT_FOUND" */
    '\x0e','E','N','V','_','V','A','R','_','\x06','\x2a',
/* 0x1a6a1 = "VERR_IO_BAD_LENGTH" */
    '\x01','I','O','_','\x1d','L','E','N','G','T','H',
/* 0x1a6ac = "VERR_INVALID_CPU_INDEX" */
    '\x01','\x05','C','P','U','_','I','N','D','E','X',
/* 0x1a6b7 = "VERR_PDM_THREAD_IPE_1" */
    '\x01','\x5e','T','H','R','E','A','D','_','\x14','1',
/* 0x1a6c2 = "VERR_VFS_CHAIN_ONE_ARG" */
    '\x01','\x8d','_','\x8e','O','N','E','_','A','R','G',
/* 0x1a6cd = "VERR_CR_CIPHER_NOT_SUPPORTED" */
    '\x01','\x22','C','I','P','H','E','R','_','\x06','\x82',
/* 0x1a6d8 = "VERR_TIMER_BUSY" */
    '\x01','T','I','M','E','R','_','B','U','S','Y',
/* 0x1a6e3 = "Signed data certificate not found." */
    'S','i','g','n','e','d',' ','\x9c','\x9e','\x08','\x88',
/* 0x1a6ee = "VINF_EM_SUSPEND" */
    '\x0e','E','M','_','S','U','S','P','E','N','D',
/* 0x1a6f9 = "Host is down." */
    'H','o','s','t',' ','\x0b','d','o','w','n','.',
/* 0x1a704 = "VERR_PDM_NO_USB_HUBS" */
    '\x01','\x5e','\x60','U','S','B','_','H','U','B','S',
/* 0x1a70f = "Protocol not supported." */
    'P','r','o','t','o','c','o','l',' ','\x08','\xa4',
/* 0x1a71a = "VERR_VFS_CHAIN_NO_PREFIX" */
    '\x01','\x8d','_','\x8e','\x60','P','R','E','F','I','X',
/* 0x1a725 = "VERR_PDM_DRIVER_NOT_FOUND" */
    '\x01','\x5e','D','R','I','V','E','R','_','\x06','\x2a',
/* 0x1a730 = "VERR_REST_INTERNAL_ERROR_6" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','6',
/* 0x1a73a = "VERR_REST_INTERNAL_ERROR_5" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','5',
/* 0x1a744 = "VERR_REST_INTERNAL_ERROR_4" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','4',
/* 0x1a74e = "VERR_REST_INTERNAL_ERROR_2" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','2',
/* 0x1a758 = "VERR_REST_INTERNAL_ERROR_1" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','1',
/* 0x1a762 = "VERR_DISK_FULL" */
    '\x01','D','I','S','K','_','F','U','L','L',
/* 0x1a76c = "operation." */
    'o','p','e','r','a','t','i','o','n','.',
/* 0x1a776 = "VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE" */
    '\x01','\x22','P','K','I','X','_','\x91','\xbe','\xb5',
/* 0x1a780 = "VERR_DISK_IO_ERROR" */
    '\x01','D','I','S','K','_','I','O','_','\x1a',
/* 0x1a78a = "VERR_CR_PKCS7_DIGEST_CALC_ERROR" */
    '\x01','\x22','\xe3','\xbe','C','A','L','C','_','\x1a',
/* 0x1a794 = "Unsupported CPU ID register value." */
    '\x97','C','P','U',' ','I','D',' ','\xe9','\xf3',
/* 0x1a79e = "VERR_ISOMK_IPE_RR_READ" */
    '\x01','\x24','\x14','R','R','_','R','E','A','D',
/* 0x1a7a8 = "VERR_TRY_AGAIN" */
    '\x01','T','R','Y','_','A','G','A','I','N',
/* 0x1a7b2 = "GIM internal processing error #2." */
    'G','I','M',' ','\x17','\x04','\x09','#','2','.',
/* 0x1a7bc = "Expected an element." */
    '\xb8','\x87','e','l','e','m','e','n','t','.',
/* 0x1a7c6 = "VERR_VD_IMAGE_NOT_FOUND" */
    '\x01','\xff','I','M','A','G','E','_','\x06','\x2a',
/* 0x1a7d0 = "Internal PKCS #7 error." */
    '\x07','P','K','C','S',' ','#','7',' ','\x84',
/* 0x1a7da = "requested " */
    'r','e','q','u','e','s','t','e','d',' ',
/* 0x1a7e4 = "VERR_SVM_UNKNOWN_EXIT" */
    '\x01','S','V','M','_','\x91','E','X','I','T',
/* 0x1a7ee = "VERR_INVALID_FUNCTION" */
    '\x01','\x05','F','U','N','C','T','I','O','N',
/* 0x1a7f8 = "VINF_ASN1_NOT_ENCODED" */
    '\x0e','\xa1','\x06','E','N','C','O','D','E','D',
/* 0x1a802 = "Command not supported." */
    'C','o','m','m','a','n','d',' ','\x08','\xa4',
/* 0x1a80c = "VERR_NET_MSG_SIZE" */
    '\x01','N','E','T','_','M','S','G','_','\xfe',
/* 0x1a816 = "VERR_PIPE_IO_ERROR" */
    '\x01','P','I','P','E','_','I','O','_','\x1a',
/* 0x1a820 = "GIM internal processing error #1." */
    'G','I','M',' ','\x17','\x04','\x09','#','1','.',
/* 0x1a82a = "VERR_CANCELLED" */
    '\x01','C','A','N','C','E','L','L','E','D',
/* 0x1a834 = "arguments." */
    'a','r','g','u','m','e','n','t','s','.',
/* 0x1a83e = "VERR_UNEXPECTED_FS_OBJ_TYPE" */
    '\x01','\x86','F','S','_','O','B','J','_','\xb5',
/* 0x1a848 = "The breakpoint already exists." */
    '\x03','\xbf','\x7f','e','x','i','s','t','s','.',
/* 0x1a852 = "VERR_SUPDRV_VTG_BITS" */
    '\x01','\x90','V','T','G','_','B','I','T','S',
/* 0x1a85c = "VERR_SSM_FIELD_INVALID_SIZE" */
    '\x01','\xb0','F','I','E','L','D','_','\x05','\xfe',
/* 0x1a866 = "VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE" */
    '\x01','\xe7','\x1b','F','I','X','U','P','_','\xb5',
/* 0x1a870 = "algorithm " */
    'a','l','g','o','r','i','t','h','m',' ',
/* 0x1a87a = "VERR_IEM_INVALID_EFF_SEG" */
    '\x01','\x9b','\x05','E','F','F','_','S','E','G',
/* 0x1a884 = "VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH" */
    '\x01','\x95','\xbd','\xb6','_','V','S','_','\xab','\x19',
/* 0x1a88e = "VERR_VFS_CHAIN_TOO_MANY_ARGS" */
    '\x01','\x8d','_','\x8e','\x1c','\xaf','A','R','G','S',
/* 0x1a898 = "VERR_IO_NOT_READY" */
    '\x01','I','O','_','\x06','R','E','A','D','Y',
/* 0x1a8a2 = "VERR_LDRMACHO_UNSUPPORTED_MACHINE" */
    '\x01','\xe7','\x1b','M','A','C','H','I','N','E',
/* 0x1a8ac = "Unexpected SVM exit." */
    '\x94','S','V','M',' ','e','x','i','t','.',
/* 0x1a8b6 = "VERR_COM_XML_ERROR" */
    '\x01','C','O','M','_','X','M','L','_','\x1a',
/* 0x1a8c0 = "Invalid memory pointer." */
    '\x0c','\x85','p','o','i','n','t','e','r','.',
/* 0x1a8ca = "VERR_VMX_RESERVED" */
    '\x01','\xe1','R','E','S','E','R','V','E','D',
/* 0x1a8d4 = "VERR_SEM_LV_INTERNAL_ERROR" */
    '\x01','S','E','M','_','L','V','_','\xc2','\x1a',
/* 0x1a8de = "VERR_VFS_UNKNOWN_FORMAT" */
    '\x01','\x8d','_','\x91','F','O','R','M','A','T',
/* 0x1a8e8 = "structure " */
    's','t','r','u','c','t','u','r','e',' ',
/* 0x1a8f2 = "VERR_CR_X509_NAME_NOT_STRING" */
    '\x01','\x22','\xb7','N','A','M','E','_','\x06','\xd4',
/* 0x1a8fc = "VERR_ASN1_INVALID_OBJID_ENCODING" */
    '\x01','\xa1','\x05','O','B','J','I','D','_','\xc6',
/* 0x1a906 = "VERR_VFS_CHAIN_ONLY_VFS" */
    '\x01','\x8d','_','\x8e','O','N','L','Y','_','\x8d',
/* 0x1a910 = "VERR_SUP_VP_STUB_NOT_FOUND" */
    '\x01','\x95','\xbd','S','T','U','B','_','\x06','\x2a',
/* 0x1a91a = "VERR_PE_EXE_NOT_SUPPORTED" */
    '\x01','P','E','_','E','X','E','_','\x06','\x82',
/* 0x1a924 = "VERR_ISOFS_ICB_TOO_BIG" */
    '\x01','\xa2','I','C','B','_','\x1c','B','I','G',
/* 0x1a92e = "The file type isn\'t supported." */
    '\x03','\x1f','\xf1','i','s','n','\'','t',' ','\xa4',
/* 0x1a938 = "VERR_VD_VALUE_NOT_FOUND" */
    '\x01','\xff','V','A','L','U','E','_','\x06','\x2a',
/* 0x1a942 = "VERR_VD_ISCSI_INVALID_STATE" */
    '\x01','\xff','I','S','C','S','I','_','\x05','\xef',
/* 0x1a94c = "VERR_SSM_INTEGRITY_HEADER" */
    '\x01','\xb0','\xf5','_','H','E','A','D','E','R',
/* 0x1a956 = "Invalid selector." */
    '\x0c','s','e','l','e','c','t','o','r','.',
/* 0x1a960 = "VERR_VD_ISCSI_INVALID_TYPE" */
    '\x01','\xff','I','S','C','S','I','_','\x05','\xb5',
/* 0x1a96a = "VERR_MODULE_NOT_FOUND" */
    '\x01','M','O','D','U','L','E','_','\x06','\x2a',
/* 0x1a974 = "The state changed." */
    '\x03','\xcd','c','h','a','n','g','e','d','.',
/* 0x1a97e = "VERR_LDRMACHO_UNKNOWN_SECTION" */
    '\x01','\xe7','\x91','S','E','C','T','I','O','N',
/* 0x1a988 = "The VM state was invalid for the requested operation." */
    '\x03','\xcc',' ','\xcd','\x11','\x8f','\x10','\x02','\xdd','\xe8',
/* 0x1a992 = "VERR_ASN1_INVALID_T61_STRING_ENCODING" */
    '\x01','\xa1','\x05','T','6','1','_','\xd4','_','\xc6',
/* 0x1a99c = "Process Verification Failure: Bad image size." */
    '\x1e','\x0d','\x12','\x9d','\x25','s','i','z','e','.',
/* 0x1a9a6 = "Invalid VM handle." */
    '\x0c','\xcc',' ','h','a','n','d','l','e','.',
/* 0x1a9b0 = "Syntax error - too few arguments." */
    '\xf7','\x09','-',' ','\xa0','f','e','w',' ','\xdc',
/* 0x1a9ba = "Invalid MMIO handle." */
    '\x0c','\xd2',' ','h','a','n','d','l','e','.',
/* 0x1a9c4 = "VERR_SUP_VP_FILE_MODE_ERROR" */
    '\x01','\x95','\xbd','\xab','M','O','D','E','_','\x1a',
/* 0x1a9ce = "VERR_UNSUPPORTED_CPU_MODE" */
    '\x01','\x1b','C','P','U','_','M','O','D','E',
/* 0x1a9d8 = "Is a FIFO." */
    'I','s',' ','a',' ','F','I','F','O','.',
/* 0x1a9e2 = "VERR_LDRMACHO_UNSUPPORTED_SECTION" */
    '\x01','\xe7','\x1b','S','E','C','T','I','O','N',
/* 0x1a9ec = "VERR_TM_LOAD_STATE" */
    '\x01','T','M','_','L','O','A','D','_','\xef',
/* 0x1a9f6 = "VERR_ISOMK_IMPORT_UNKNOWN_FORMAT" */
    '\x01','\x24','\x89','\x91','F','O','R','M','A','T',
/* 0x1aa00 = "VERR_IS_A_FILE" */
    '\x01','I','S','_','A','_','F','I','L','E',
/* 0x1aa0a = "Invalid function." */
    '\x0c','f','u','n','c','t','i','o','n','.',
/* 0x1aa14 = "VERR_DWARF_IPE" */
    '\x01','D','W','A','R','F','_','I','P','E',
/* 0x1aa1e = "VINF_SVM_VMRUN" */
    '\x0e','S','V','M','_','V','M','R','U','N',
/* 0x1aa28 = "GIM internal processing error #3." */
    'G','I','M',' ','\x17','\x04','\x09','#','3','.',
/* 0x1aa32 = "VERR_IEM_LABEL_IPE_6" */
    '\x01','\x9b','L','A','B','E','L','_','\x14','6',
/* 0x1aa3c = "VERR_IEM_LABEL_IPE_5" */
    '\x01','\x9b','L','A','B','E','L','_','\x14','5',
/* 0x1aa46 = "VERR_IEM_LABEL_IPE_4" */
    '\x01','\x9b','L','A','B','E','L','_','\x14','4',
/* 0x1aa50 = "VERR_IEM_LABEL_IPE_3" */
    '\x01','\x9b','L','A','B','E','L','_','\x14','3',
/* 0x1aa5a = "VERR_IEM_LABEL_IPE_2" */
    '\x01','\x9b','L','A','B','E','L','_','\x14','2',
/* 0x1aa64 = "Generic loader failure." */
    '\xa6','\xd8','f','a','i','l','u','r','e','.',
/* 0x1aa6e = "VERR_PGM_DYNMAP_FAILED" */
    '\x01','\x8c','D','Y','N','M','A','P','_','\x16',
/* 0x1aa78 = "VERR_VD_CACHE_NOT_FOUND" */
    '\x01','\xff','C','A','C','H','E','_','\x06','\x2a',
/* 0x1aa82 = "The byte string was not found." */
    '\x03','b','y','t','e',' ','\xf0','\x11','\x08','\x88',
/* 0x1aa8c = "VERR_IEM_LABEL_IPE_1" */
    '\x01','\x9b','L','A','B','E','L','_','\x14','1',
/* 0x1aa96 = "VERR_IEM_FIXUP_IPE_1" */
    '\x01','\x9b','F','I','X','U','P','_','\x14','1',
/* 0x1aaa0 = "VERR_PAGE_NOT_PRESENT" */
    '\x01','\xdb','\x06','P','R','E','S','E','N','T',
/* 0x1aaaa = "VERR_SVM_UNEXPECTED_EXIT" */
    '\x01','S','V','M','_','\x86','E','X','I','T',
/* 0x1aab4 = "VWRN_STATE_CHANGED" */
    '\xe4','\xef','_','C','H','A','N','G','E','D',
/* 0x1aabe = "VINF_PGM_SYNC_CR3" */
    '\x0e','\x8c','S','Y','N','C','_','C','R','3',
/* 0x1aac8 = "VERR_DBGC_PARSE_INVALID_NUMBER" */
    '\x01','\xfb','\xe2','\x05','N','U','M','B','E','R',
/* 0x1aad2 = "VERR_PGM_POOL_IPE" */
    '\x01','\x8c','P','O','O','L','_','I','P','E',
/* 0x1aadc = "VERR_PDM_BLOCK_NO_TYPE" */
    '\x01','\x5e','B','L','O','C','K','_','\x60','\xb5',
/* 0x1aae6 = "VERR_SSM_TOO_MANY_PASSES" */
    '\x01','\xb0','\x1c','\xaf','P','A','S','S','E','S',
/* 0x1aaf0 = "VERR_LX_EXE_NOT_SUPPORTED" */
    '\x01','L','X','_','E','X','E','_','\x06','\x82',
/* 0x1aafa = "VERR_INVALID_BASE64_ENCODING" */
    '\x01','\x05','B','A','S','E','6','4','_','\xc6',
/* 0x1ab04 = "VERR_GVM_TOO_MANY_VMS" */
    '\x01','G','V','M','_','\x1c','\xaf','V','M','S',
/* 0x1ab0e = "VERR_VFS_CHAIN_CAST_FAILED" */
    '\x01','\x8d','_','\x8e','C','A','S','T','_','\x16',
/* 0x1ab18 = "VWRN_DBGF_ALREADY_HALTED" */
    '\xe4','\xb9','_','\x9a','H','A','L','T','E','D',
/* 0x1ab22 = "VERR_STATE_CHANGED" */
    '\x01','\xef','_','C','H','A','N','G','E','D',
/* 0x1ab2c = "VERR_NEM_SET_TSC" */
    '\x01','\xec','_','S','E','T','_','T','S','C',
/* 0x1ab36 = "VERR_VMX_INVALID_GUEST_STATE" */
    '\x01','\xe1','\x05','G','U','E','S','T','_','\xef',
/* 0x1ab40 = "VERR_ISOFS_WRONG_FILE_TYPE" */
    '\x01','\xa2','W','R','O','N','G','_','\xab','\xb5',
/* 0x1ab4a = "VERR_LE_EXE_NOT_SUPPORTED" */
    '\x01','L','E','_','E','X','E','_','\x06','\x82',
/* 0x1ab54 = "VERR_GVM_MISMATCH_VM_SIZE" */
    '\x01','G','V','M','_','\x19','_','\xcc','_','\xfe',
/* 0x1ab5e = "directory " */
    'd','i','r','e','c','t','o','r','y',' ',
/* 0x1ab68 = "VERR_SYMBOL_NOT_FOUND" */
    '\x01','S','Y','M','B','O','L','_','\x06','\x2a',
/* 0x1ab72 = "The device wasn\'t found." */
    '\x03','\xa3','w','a','s','n','\'','t',' ','\x88',
/* 0x1ab7c = "Process Verification Failure: No NTDLL." */
    '\x1e','\x0d','\x12','\xe6','N','T','D','L','L','.',
/* 0x1ab86 = "VERR_REST_INTERNAL_ERROR_3" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','3',
/* 0x1ab90 = "VERR_LDRPE_TLS" */
    '\x01','L','D','R','P','E','_','T','L','S',
/* 0x1ab9a = "VERR_VFS_UNSUPPORTED_FORMAT" */
    '\x01','\x8d','_','\x1b','F','O','R','M','A','T',
/* 0x1aba4 = "VERR_REST_INTERNAL_ERROR_9" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','9',
/* 0x1abae = "VERR_SSM_STREAM_ERROR" */
    '\x01','\xb0','S','T','R','E','A','M','_','\x1a',
/* 0x1abb8 = "Empty string in X." */
    'E','m','p','t','y',' ','\xf0','\x0f','X','.',
/* 0x1abc2 = "Shutdown failed." */
    'S','h','u','t','d','o','w','n',' ','\x7d',
/* 0x1abcc = "VERR_REST_INTERNAL_ERROR_8" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','8',
/* 0x1abd6 = "VERR_SSM_INTEGRITY_VBOX_VERSION" */
    '\x01','\xb0','\xf5','_','V','B','O','X','_','\xbc',
/* 0x1abe0 = "Unsupported CPU mode." */
    '\x97','C','P','U',' ','m','o','d','e','.',
/* 0x1abea = "VERR_INVALID_SELECTOR" */
    '\x01','\x05','S','E','L','E','C','T','O','R',
/* 0x1abf4 = "Socket type not supported." */
    'S','o','c','k','e','t',' ','\xf1','\x08','\xa4',
/* 0x1abfe = "VERR_REST_INTERNAL_ERROR_7" */
    '\x01','R','E','S','T','_','\xc2','\x1a','_','7',
/* 0x1ac08 = "VERR_PGM_MODE_IPE" */
    '\x01','\x8c','M','O','D','E','_','I','P','E',
/* 0x1ac12 = "VERR_XAR_BAD_FILE_GID" */
    '\x01','X','A','R','_','\x1d','\xab','G','I','D',
/* 0x1ac1c = "VERR_URI_EMPTY" */
    '\x01','U','R','I','_','E','M','P','T','Y',
/* 0x1ac26 = "VERR_CR_RANDOM_FAILED" */
    '\x01','\x22','R','A','N','D','O','M','_','\x16',
/* 0x1ac30 = "VERR_MORE_DATA" */
    '\x01','M','O','R','E','_','D','A','T','A',
/* 0x1ac3a = "VERR_LDRVI_NO_MEMORY_SHDRS" */
    '\x01','\xf2','\x60','\xb6','_','S','H','D','R','S',
/* 0x1ac44 = "Not equal." */
    'N','o','t',' ','e','q','u','a','l','.',
/* 0x1ac4e = "VERR_PDM_BLOCK_UNKNOWN_TYPE" */
    '\x01','\x5e','B','L','O','C','K','_','\x91','\xb5',
/* 0x1ac58 = "specified " */
    's','p','e','c','i','f','i','e','d',' ',
/* 0x1ac62 = "VERR_MZ_EXE_NOT_SUPPORTED" */
    '\x01','M','Z','_','E','X','E','_','\x06','\x82',
/* 0x1ac6c = "Protocol error." */
    'P','r','o','t','o','c','o','l',' ','\x84',
/* 0x1ac76 = "VERR_IS_A_FIFO" */
    '\x01','I','S','_','A','_','F','I','F','O',
/* 0x1ac80 = "VERR_FILE_AIO_BUSY" */
    '\x01','\xab','A','I','O','_','B','U','S','Y',
/* 0x1ac8a = "VERR_SUPDRV_CSRSS_NOT_FOUND" */
    '\x01','\x90','C','S','R','S','S','_','\x06','\x2a',
/* 0x1ac94 = "VERR_SELM_NO_TSS" */
    '\x01','S','E','L','M','_','\x60','T','S','S',
/* 0x1ac9e = "VERR_INVALID_VM_HANDLE" */
    '\x01','\x05','\xcc','_','H','A','N','D','L','E',
/* 0x1aca8 = "VINF_DBGF_BP_HALT" */
    '\x0e','\xb9','_','B','P','_','H','A','L','T',
/* 0x1acb2 = "VERR_SELM_INVALID_LDT" */
    '\x01','S','E','L','M','_','\x05','L','D','T',
/* 0x1acbc = "VERR_ASN1_NOT_PRESENT" */
    '\x01','\xa1','\x06','P','R','E','S','E','N','T',
/* 0x1acc6 = "VERR_XAR_BAD_FILE_UID" */
    '\x01','X','A','R','_','\x1d','\xab','U','I','D',
/* 0x1acd0 = "VERR_PDM_NO_PCI_BUS" */
    '\x01','\x5e','\x60','P','C','I','_','B','U','S',
/* 0x1acda = "Generic PKCS #7 error." */
    '\xa6','P','K','C','S',' ','#','7',' ','\x84',
/* 0x1ace4 = "Invalid RT request type." */
    '\x0c','R','T',' ','\xaa','t','y','p','e','.',
/* 0x1acee = "VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE" */
    '\x01','\x8c','L','O','A','D','_','\x86','\xdb','\xb5',
/* 0x1acf8 = "VERR_DUPLICATE" */
    '\x01','D','U','P','L','I','C','A','T','E',
/* 0x1ad02 = "Invalid VM request state." */
    '\x0c','\xcc',' ','\xaa','s','t','a','t','e','.',
/* 0x1ad0c = "VERR_NE_EXE_NOT_SUPPORTED" */
    '\x01','N','E','_','E','X','E','_','\x06','\x82',
/* 0x1ad16 = "VINF_TRY_AGAIN" */
    '\x0e','T','R','Y','_','A','G','A','I','N',
/* 0x1ad20 = "VERR_SSM_INTEGRITY_FOOTER" */
    '\x01','\xb0','\xf5','_','F','O','O','T','E','R',
/* 0x1ad2a = "VERR_ASN1_INVALID_IA5_STRING_ENCODING" */
    '\x01','\xa1','\x05','I','A','5','_','\xd4','_','\xc6',
/* 0x1ad34 = "VERR_PDM_UNSUPPORTED_BLOCK_TYPE" */
    '\x01','\x5e','\x1b','B','L','O','C','K','_','\xb5',
/* 0x1ad3e = "VERR_ASN1_INVALID_BMP_STRING_ENCODING" */
    '\x01','\xa1','\x05','B','M','P','_','\xd4','_','\xc6',
/* 0x1ad48 = "VERR_PIPE_BUSY" */
    '\x01','P','I','P','E','_','B','U','S','Y',
/* 0x1ad52 = "VERR_SSM_MEM_TOO_BIG" */
    '\x01','\xb0','M','E','M','_','\x1c','B','I','G',
/* 0x1ad5c = "VERR_VMX_VMEXIT_FAILED" */
    '\x01','\xe1','V','M','E','X','I','T','_','\x16',
/* 0x1ad66 = "VERR_MP_TOO_MANY_CPUS" */
    '\x01','M','P','_','\x1c','\xaf','C','P','U','S',
/* 0x1ad70 = "VERR_IO_BAD_UNIT" */
    '\x01','I','O','_','\x1d','U','N','I','T',
/* 0x1ad79 = "Invalid context." */
    '\x0c','c','o','n','t','e','x','t','.',
/* 0x1ad82 = "VERR_DBG_TODO" */
    '\x01','D','B','G','_','T','O','D','O',
/* 0x1ad8b = "VERR_SSM_INTEGRITY_MAGIC" */
    '\x01','\xb0','\xf5','_','M','A','G','I','C',
/* 0x1ad94 = "VERR_IOM_MMIO_IPE_2" */
    '\x01','I','O','M','_','\xd2','_','\x14','2',
/* 0x1ad9d = "VERR_TM_GIP_VERSION" */
    '\x01','T','M','_','G','I','P','_','\xbc',
/* 0x1ada6 = "VERR_LDRVI_PAGE_HASH_MISMATCH" */
    '\x01','\xf2','\xdb','H','A','S','H','_','\x19',
/* 0x1adaf = "VERR_DEV_IO_ERROR" */
    '\x01','D','E','V','_','I','O','_','\x1a',
/* 0x1adb8 = "VERR_IOMMU_CMD_NOT_SUPPORTED" */
    '\x01','\xfc','_','C','M','D','_','\x06','\x82',
/* 0x1adc1 = "VERR_IOM_MMIO_IPE_1" */
    '\x01','I','O','M','_','\xd2','_','\x14','1',
/* 0x1adca = "INTEGRITY" */
    'I','N','T','E','G','R','I','T','Y',
/* 0x1add3 = "The specified cpu was not found." */
    '\x03','\x18','c','p','u',' ','\x11','\x08','\x88',
/* 0x1addc = "VERR_CR_PKIX_INTERNAL_ERROR" */
    '\x01','\x22','P','K','I','X','_','\xc2','\x1a',
/* 0x1ade5 = "TM internal processing error #3." */
    'T','M',' ','\x17','\x04','\x09','#','3','.',
/* 0x1adee = "VERR_DBGF_REG_IPE_2" */
    '\x01','\xb9','_','R','E','G','_','\x14','2',
/* 0x1adf7 = "VERR_PGM_PHYS_NOT_MMIO" */
    '\x01','\x8c','P','H','Y','S','_','\x06','\xd2',
/* 0x1ae00 = "VERR_DBGF_REG_IPE_1" */
    '\x01','\xb9','_','R','E','G','_','\x14','1',
/* 0x1ae09 = "INTERNAL_" */
    'I','N','T','E','R','N','A','L','_',
/* 0x1ae12 = "Expected " */
    'E','x','p','e','c','t','e','d',' ',
/* 0x1ae1b = "Bad file entry (ICB)." */
    '\x9d','\x1f','\xc8','(','I','C','B',')','.',
/* 0x1ae24 = "Generic stream error." */
    '\xa6','s','t','r','e','a','m',' ','\x84',
/* 0x1ae2d = "TM internal processing error #7." */
    'T','M',' ','\x17','\x04','\x09','#','7','.',
/* 0x1ae36 = "VERR_SEM_BUSY" */
    '\x01','S','E','M','_','B','U','S','Y',
/* 0x1ae3f = "VINF_LDRVI_NOT_SIGNED" */
    '\x0e','\xf2','\x06','S','I','G','N','E','D',
/* 0x1ae48 = "contains " */
    'c','o','n','t','a','i','n','s',' ',
/* 0x1ae51 = "Mismatch." */
    'M','i','s','m','a','t','c','h','.',
/* 0x1ae5a = "VERR_FILE_NOT_LOCKED" */
    '\x01','\xab','\x06','L','O','C','K','E','D',
/* 0x1ae63 = "The ELF version is not supported." */
    '\x03','E','L','F',' ','\xcf','\x0b','\x08','\xa4',
/* 0x1ae6c = "VERR_IEM_VAR_IPE_13" */
    '\x01','\x9b','V','A','R','_','\x14','1','3',
/* 0x1ae75 = "VERR_IEM_VAR_IPE_12" */
    '\x01','\x9b','V','A','R','_','\x14','1','2',
/* 0x1ae7e = "VERR_IEM_VAR_IPE_11" */
    '\x01','\x9b','V','A','R','_','\x14','1','1',
/* 0x1ae87 = "VERR_COM_INVALID_VM_STATE" */
    '\x01','C','O','M','_','\x05','\xcc','_','\xef',
/* 0x1ae90 = "VERR_IEM_VAR_IPE_10" */
    '\x01','\x9b','V','A','R','_','\x14','1','0',
/* 0x1ae99 = "VERR_DEADLOCK" */
    '\x01','D','E','A','D','L','O','C','K',
/* 0x1aea2 = "VERR_SUPLIB_FSTAT_FAILED" */
    '\x01','\xd5','F','S','T','A','T','_','\x16',
/* 0x1aeab = "VERR_NET_DOWN" */
    '\x01','N','E','T','_','D','O','W','N',
/* 0x1aeb4 = "TM internal processing error #4." */
    'T','M',' ','\x17','\x04','\x09','#','4','.',
/* 0x1aebd = "VERR_SUPLIB_IS_FILE" */
    '\x01','\xd5','I','S','_','F','I','L','E',
/* 0x1aec6 = "TM internal processing error #5." */
    'T','M',' ','\x17','\x04','\x09','#','5','.',
/* 0x1aecf = "TM internal processing error #9." */
    'T','M',' ','\x17','\x04','\x09','#','9','.',
/* 0x1aed8 = "The host is not supported." */
    '\x03','h','o','s','t',' ','\x0b','\x08','\xa4',
/* 0x1aee1 = "VERR_ASN1_UNEXPECTED_OBJ_ID" */
    '\x01','\xa1','\x86','O','B','J','_','I','D',
/* 0x1aeea = "Bad section." */
    '\x9d','s','e','c','t','i','o','n','.',
/* 0x1aef3 = "VERR_VD_NOT_OPENED" */
    '\x01','\xff','\x06','O','P','E','N','E','D',
/* 0x1aefc = "VERR_TAR_UNEXPECTED_EOS" */
    '\x01','T','A','R','_','\x86','E','O','S',
/* 0x1af05 = "VERR_SVM_NO_SVM" */
    '\x01','S','V','M','_','\x60','S','V','M',
/* 0x1af0e = "Client not found." */
    'C','l','i','e','n','t',' ','\x08','\x88',
/* 0x1af17 = "VERR_INVALID_UTF16_ENCODING" */
    '\x01','\x05','U','T','F','1','6','_','\xc6',
/* 0x1af20 = "VERR_ASN1_STRING_TAG_MISMATCH" */
    '\x01','\xa1','\xd4','_','T','A','G','_','\x19',
/* 0x1af29 = "VFS object cast failed." */
    '\x8d',' ','\xa7','c','a','s','t',' ','\x7d',
/* 0x1af32 = "VERR_VMX_INVALID_HOST_STATE" */
    '\x01','\xe1','\x05','H','O','S','T','_','\xef',
/* 0x1af3b = "Internal " */
    'I','n','t','e','r','n','a','l',' ',
/* 0x1af44 = "LDRMACHO_" */
    'L','D','R','M','A','C','H','O','_',
/* 0x1af4d = "Codec was not found." */
    'C','o','d','e','c',' ','\x11','\x08','\x88',
/* 0x1af56 = "TM internal processing error #1." */
    'T','M',' ','\x17','\x04','\x09','#','1','.',
/* 0x1af5f = "Codec is not supported." */
    'C','o','d','e','c',' ','\x0b','\x08','\xa4',
/* 0x1af68 = "VERR_SSM_UNIT_NOT_FOUND" */
    '\x01','\xb0','U','N','I','T','_','\x06','\x2a',
/* 0x1af71 = "VERR_PATCH_NOT_FOUND" */
    '\x01','P','A','T','C','H','_','\x06','\x2a',
/* 0x1af7a = "VERR_DWARF_BAD_STRING" */
    '\x01','D','W','A','R','F','_','\x1d','\xd4',
/* 0x1af83 = "VERR_INVALID_POINTER" */
    '\x01','\x05','P','O','I','N','T','E','R',
/* 0x1af8c = "VERR_LDRMACHO_BAD_HEADER" */
    '\x01','\xe7','\x1d','H','E','A','D','E','R',
/* 0x1af95 = "VERR_NET_IO_ERROR" */
    '\x01','N','E','T','_','I','O','_','\x1a',
/* 0x1af9e = "Generic not found error." */
    '\xa6','\x08','f','o','u','n','d',' ','\x84',
/* 0x1afa7 = "Module not found." */
    'M','o','d','u','l','e',' ','\x08','\x88',
/* 0x1afb0 = "The instruction is too long." */
    '\x03','\xd9','\x0b','\xa0','l','o','n','g','.',
/* 0x1afb9 = "VERR_LDRMACHO_BIT_MIX" */
    '\x01','\xe7','B','I','T','_','M','I','X',
/* 0x1afc2 = "VERR_DBGF_MEM_NOT_FOUND" */
    '\x01','\xb9','_','M','E','M','_','\x06','\x2a',
/* 0x1afcb = "VERR_END_OF_STRING" */
    '\x01','E','N','D','_','O','F','_','\xd4',
/* 0x1afd4 = "VERR_IPE_UNEXPECTED_STATUS" */
    '\x01','\x14','\x86','S','T','A','T','U','S',
/* 0x1afdd = "Invalid page directory specified to PGM." */
    '\x0c','\xcb','\x26','\x18','\x0a','P','G','M','.',
/* 0x1afe6 = "register " */
    'r','e','g','i','s','t','e','r',' ',
/* 0x1afef = "VERR_INVALID_CONTEXT" */
    '\x01','\x05','C','O','N','T','E','X','T',
/* 0X1aff8 = "TM internal processing error #2." */
    'M',' ','\x17','\x04','\x09','#','2','.',
/* 0x1b000 = "VERR_NO_UTF16_MEMORY" */
    '\x01','\x60','U','T','F','1','6','_','\xb6',
/* 0x1b009 = "VERR_LDR_INVALID_RVA" */
    '\x01','L','D','R','_','\x05','R','V','A',
/* 0x1b012 = "Generic file write error." */
    '\xa6','\x1f','w','r','i','t','e',' ','\x84',
/* 0x1b01b = "TM internal processing error #6." */
    'T','M',' ','\x17','\x04','\x09','#','6','.',
/* 0x1b024 = "Expected section header." */
    '\xb8','\xda','h','e','a','d','e','r','.',
/* 0x1b02d = "VWRN_CSAM_PAGE_NOT_FOUND" */
    '\xe4','C','S','A','M','_','\xdb','\x06','\x2a',
/* 0x1b036 = "VERR_LDRVI_NOT_SIGNED" */
    '\x01','\xf2','\x06','S','I','G','N','E','D',
/* 0x1b03f = "Invalid VM request type." */
    '\x0c','\xcc',' ','\xaa','t','y','p','e','.',
/* 0x1b048 = "VERR_LDRMACHO_BAD_SYMBOL" */
    '\x01','\xe7','\x1d','S','Y','M','B','O','L',
/* 0x1b051 = "VERR_DBG_INVALID_RVA" */
    '\x01','D','B','G','_','\x05','R','V','A',
/* 0x1b05a = "VERR_IOM_MMIO_IPE_3" */
    '\x01','I','O','M','_','\xd2','_','\x14','3',
/* 0x1b063 = "TM internal processing error #8." */
    'T','M',' ','\x17','\x04','\x09','#','8','.',
/* 0x1b06c = "Failure: " */
    'F','a','i','l','u','r','e',':',' ',
/* 0x1b075 = "VERR_LDRELF_VERSION" */
    '\x01','L','D','R','E','L','F','_','\xbc',
/* 0x1b07e = "VERR_VMX_VMXON_FAILED" */
    '\x01','\xe1','V','M','X','O','N','_','\x16',
/* 0x1b087 = "VERR_SEARCH_ERROR" */
    '\x01','S','E','A','R','C','H','_','\x1a',
/* 0x1b090 = "Unsupported version." */
    '\x97','v','e','r','s','i','o','n','.',
/* 0x1b099 = "VERR_IEM_REG_IPE_13" */
    '\x01','\x9b','R','E','G','_','\x14','1','3',
/* 0x1b0a2 = "VERR_IEM_REG_IPE_11" */
    '\x01','\x9b','R','E','G','_','\x14','1','1',
/* 0x1b0ab = "VERR_IEM_REG_IPE_10" */
    '\x01','\x9b','R','E','G','_','\x14','1','0',
/* 0x1b0b4 = "VERR_IEM_REG_IPE_12" */
    '\x01','\x9b','R','E','G','_','\x14','1','2',
/* 0x1b0bd = "VERR_ISOFS_BAD_FILE_ENTRY" */
    '\x01','\xa2','\x1d','\xab','E','N','T','R','Y',
/* 0x1b0c6 = "VINF_EM_RESET" */
    '\x0e','E','M','_','R','E','S','E','T',
/* 0x1b0cf = "VINF_END_OF_STRING" */
    '\x0e','E','N','D','_','O','F','_','\xd4',
/* 0x1b0d8 = "Invalid config value." */
    '\x0c','c','o','n','f','i','g',' ','\xf3',
/* 0x1b0e1 = "VERR_ASN1_NO_VTABLE" */
    '\x01','\xa1','\x60','V','T','A','B','L','E',
/* 0x1b0ea = "VERR_VFS_CHAIN_NO_ARGS" */
    '\x01','\x8d','_','\x8e','\x60','A','R','G','S',
/* 0x1b0f3 = "VERR_NEM_INIT_FAILED" */
    '\x01','\xec','_','I','N','I','T','_','\x16',
/* 0x1b0fc = "VINF_PDM_ALREADY_LOADED" */
    '\x0e','\x5e','\x9a','L','O','A','D','E','D',
/* 0x1b105 = "VERR_NOT_SYMLINK" */
    '\x01','\x06','S','Y','M','L','I','N','K',
/* 0x1b10e = "VERR_VD_VMDK_INVALID_STATE" */
    '\x01','\xff','V','M','D','K','_','\x05','\xef',
/* 0x1b117 = "VERR_ASN1_INVALID_NULL_ENCODING" */
    '\x01','\xa1','\x05','N','U','L','L','_','\xc6',
/* 0x1b120 = "VERR_VD_VMDK_UNSUPPORTED_VERSION" */
    '\x01','\xff','V','M','D','K','_','\x1b','\xbc',
/* 0x1b129 = "VERR_VD_UUID_MISMATCH" */
    '\x01','\xff','U','U','I','D','_','\x19',
/* 0x1b131 = "Invalid Mod/RM." */
    '\x0c','M','o','d','/','R','M','.',
/* 0x1b139 = "VWRN_NO_DIGITS" */
    '\xe4','\x60','D','I','G','I','T','S',
/* 0x1b141 = "Generic store error." */
    '\xa6','s','t','o','r','e',' ','\x84',
/* 0x1b149 = "Mode table internal error." */
    'M','o','d','e',' ','\xb1','\x17','\x84',
/* 0x1b151 = "IOMMU Internal processing error #1." */
    '\xfc',' ','\x07','\x04','\x09','#','1','.',
/* 0x1b159 = "UNKNOWN_" */
    'U','N','K','N','O','W','N','_',
/* 0x1b161 = "NEM internal processing error #4." */
    '\xec',' ','\x17','\x04','\x09','#','4','.',
/* 0x1b169 = "IOMMU Internal processing error #8." */
    '\xfc',' ','\x07','\x04','\x09','#','8','.',
/* 0x1b171 = "VERR_INVALID_UTF8_ENCODING" */
    '\x01','\x05','U','T','F','8','_','\xc6',
/* 0x1b179 = "VERR_DBGF_BP_IPE_9" */
    '\x01','\xb9','_','B','P','_','\x14','9',
/* 0x1b181 = "VERR_DBGF_BP_IPE_8" */
    '\x01','\xb9','_','B','P','_','\x14','8',
/* 0x1b189 = "VERR_DBGF_BP_IPE_7" */
    '\x01','\xb9','_','B','P','_','\x14','7',
/* 0x1b191 = "VERR_DBGF_BP_IPE_6" */
    '\x01','\xb9','_','B','P','_','\x14','6',
/* 0x1b199 = "VERR_DBGF_BP_IPE_5" */
    '\x01','\xb9','_','B','P','_','\x14','5',
/* 0x1b1a1 = "VERR_DBGF_BP_IPE_4" */
    '\x01','\xb9','_','B','P','_','\x14','4',
/* 0x1b1a9 = "Unknown " */
    'U','n','k','n','o','w','n',' ',
/* 0x1b1b1 = "Generic " */
    'G','e','n','e','r','i','c',' ',
/* 0x1b1b9 = "VWRN_WRONG_TYPE" */
    '\xe4','W','R','O','N','G','_','\xb5',
/* 0x1b1c1 = "VERR_DBGF_BP_IPE_3" */
    '\x01','\xb9','_','B','P','_','\x14','3',
/* 0x1b1c9 = "VERR_VD_VDI_UNSUPPORTED_VERSION" */
    '\x01','\xff','V','D','I','_','\x1b','\xbc',
/* 0x1b1d1 = "VERR_TRPM_IPE_3" */
    '\x01','T','R','P','M','_','\x14','3',
/* 0x1b1d9 = "VERR_TRPM_IPE_2" */
    '\x01','T','R','P','M','_','\x14','2',
/* 0x1b1e1 = "Success." */
    'S','u','c','c','e','s','s','.',
/* 0x1b1e9 = "VERR_FILE_LOCK_FAILED" */
    '\x01','\xab','L','O','C','K','_','\x16',
/* 0x1b1f1 = "INVALID_" */
    'I','N','V','A','L','I','D','_',
/* 0x1b1f9 = "VERR_TRPM_IPE_1" */
    '\x01','T','R','P','M','_','\x14','1',
/* 0x1b201 = "NEM internal processing error #2." */
    '\xec',' ','\x17','\x04','\x09','#','2','.',
/* 0x1b209 = "IOMMU Internal processing error #6." */
    '\xfc',' ','\x07','\x04','\x09','#','6','.',
/* 0x1b211 = "X509 certificate verification error." */
    'X','5','0','9',' ','\x9e','\xf6','\x84',
/* 0x1b219 = "VERR_CR_PKCS7_NOT_DATA" */
    '\x01','\x22','\xe3','\x06','D','A','T','A',
/* 0x1b221 = "request " */
    'r','e','q','u','e','s','t',' ',
/* 0x1b229 = "VWRN_INVALID_HANDLE" */
    '\xe4','\x05','H','A','N','D','L','E',
/* 0x1b231 = "NEM internal processing error #7." */
    '\xec',' ','\x17','\x04','\x09','#','7','.',
/* 0x1b239 = "VERR_TOO_MANY_POSTS" */
    '\x01','\x1c','\xaf','P','O','S','T','S',
/* 0x1b241 = "VERR_PDM_HIF_INVALID_VERSION" */
    '\x01','\x5e','H','I','F','_','\x05','\xbc',
/* 0x1b249 = "process " */
    'p','r','o','c','e','s','s',' ',
/* 0x1b251 = "doesn\'t " */
    'd','o','e','s','n','\'','t',' ',
/* 0x1b259 = "VERR_IEM_REG_IPE_9" */
    '\x01','\x9b','R','E','G','_','\x14','9',
/* 0x1b261 = "VERR_IEM_REG_IPE_8" */
    '\x01','\x9b','R','E','G','_','\x14','8',
/* 0x1b269 = "IOMMU Internal processing error #2." */
    '\xfc',' ','\x07','\x04','\x09','#','2','.',
/* 0x1b271 = "VERR_IGNORED" */
    '\x01','I','G','N','O','R','E','D',
/* 0x1b279 = "VWRN_ALREADY_EXISTS" */
    '\xe4','\x9a','E','X','I','S','T','S',
/* 0x1b281 = "VERR_CPUM_IPE_2" */
    '\x01','C','P','U','M','_','\x14','2',
/* 0x1b289 = "VERR_VRDP_NOT_SUPPORTED" */
    '\x01','V','R','D','P','_','\x06','\x82',
/* 0x1b291 = "VERR_CPUM_IPE_1" */
    '\x01','C','P','U','M','_','\x14','1',
/* 0x1b299 = "VERR_ALREADY_EXISTS" */
    '\x01','\x9a','E','X','I','S','T','S',
/* 0x1b2a1 = "VERR_IEM_REG_IPE_7" */
    '\x01','\x9b','R','E','G','_','\x14','7',
/* 0x1b2a9 = "Unsupported cipher." */
    '\x97','c','i','p','h','e','r','.',
/* 0x1b2b1 = "VERR_IEM_REG_IPE_6" */
    '\x01','\x9b','R','E','G','_','\x14','6',
/* 0x1b2b9 = "VERR_CFGM_IPE_1" */
    '\x01','C','F','G','M','_','\x14','1',
/* 0x1b2c1 = "VERR_IEM_REG_IPE_4" */
    '\x01','\x9b','R','E','G','_','\x14','4',
/* 0x1b2c9 = "Unknown XAR file type value." */
    '\xf8','X','A','R',' ','\x1f','\xf1','\xf3',
/* 0x1b2d1 = "VERR_IEM_REG_IPE_3" */
    '\x01','\x9b','R','E','G','_','\x14','3',
/* 0x1b2d9 = "VERR_IEM_REG_IPE_2" */
    '\x01','\x9b','R','E','G','_','\x14','2',
/* 0x1b2e1 = "VERR_IEM_REG_IPE_5" */
    '\x01','\x9b','R','E','G','_','\x14','5',
/* 0x1b2e9 = "VERR_CFGM_NOT_STRING" */
    '\x01','C','F','G','M','_','\x06','\xd4',
/* 0x1b2f1 = "NEM internal processing error #9." */
    '\xec',' ','\x17','\x04','\x09','#','9','.',
/* 0x1b2f9 = "Import ISO contains a \'." */
    '\xc3','\xc1',' ','\x8a','a',' ','\'','.',
/* 0x1b301 = "VERR_NO_CHANGE" */
    '\x01','\x60','C','H','A','N','G','E',
/* 0x1b309 = "VERR_SUPLIB_STAT_FAILED" */
    '\x01','\xd5','S','T','A','T','_','\x16',
/* 0x1b311 = "VERR_INVALID_HANDLE" */
    '\x01','\x05','H','A','N','D','L','E',
/* 0x1b319 = "VERR_ISOFS_VPM_NOT_SUPPORTED" */
    '\x01','\xa2','V','P','M','_','\x06','\x82',
/* 0x1b321 = "VERR_ISOFS_TOO_MANY_PVDS" */
    '\x01','\xa2','\x1c','\xaf','P','V','D','S',
/* 0x1b329 = "Invalid handle." */
    '\x0c','h','a','n','d','l','e','.',
/* 0x1b331 = "VERR_NO_PHYS_MEMORY" */
    '\x01','\x60','P','H','Y','S','_','\xb6',
/* 0x1b339 = "IOMMU Internal processing error #0." */
    '\xfc',' ','\x07','\x04','\x09','#','0','.',
/* 0x1b341 = "NEM internal processing error #6." */
    '\xec',' ','\x17','\x04','\x09','#','6','.',
/* 0x1b349 = "VERR_IEM_VAR_IPE_8" */
    '\x01','\x9b','V','A','R','_','\x14','8',
/* 0x1b351 = "VERR_VD_RAW_INVALID_TYPE" */
    '\x01','\xff','R','A','W','_','\x05','\xb5',
/* 0x1b359 = "VERR_IEM_VAR_IPE_7" */
    '\x01','\x9b','V','A','R','_','\x14','7',
/* 0x1b361 = "VERR_NO_CONT_MEMORY" */
    '\x01','\x60','C','O','N','T','_','\xb6',
/* 0x1b369 = "VERR_ISOFS_TOO_MANY_LVDS" */
    '\x01','\xa2','\x1c','\xaf','L','V','D','S',
/* 0x1b371 = "Bad soname." */
    '\x9d','s','o','n','a','m','e','.',
/* 0x1b379 = "VERR_DBGF_UNSUPPORTED_CAST" */
    '\x01','\xb9','_','\x1b','C','A','S','T',
/* 0x1b381 = "VERR_PDM_HM_IPE" */
    '\x01','\x5e','H','M','_','I','P','E',
/* 0x1b389 = "IOMMU Internal processing error #3." */
    '\xfc',' ','\x07','\x04','\x09','#','3','.',
/* 0x1b391 = "VERR_PDM_DEV_IPE_1" */
    '\x01','\x5e','D','E','V','_','\x14','1',
/* 0x1b399 = "VERR_XAR_UNKNOWN_FILE_TYPE" */
    '\x01','X','A','R','_','\x91','\xab','\xb5',
/* 0x1b3a1 = "No soname." */
    '\xe6','s','o','n','a','m','e','.',
/* 0x1b3a9 = "invalid " */
    'i','n','v','a','l','i','d',' ',
/* 0x1b3b1 = "VERR_WRONG_TYPE" */
    '\x01','W','R','O','N','G','_','\xb5',
/* 0x1b3b9 = "VERR_IEM_VAR_IPE_6" */
    '\x01','\x9b','V','A','R','_','\x14','6',
/* 0x1b3c1 = "VERR_IEM_VAR_IPE_5" */
    '\x01','\x9b','V','A','R','_','\x14','5',
/* 0x1b3c9 = "The image is too big." */
    '\x03','\x25','\x0b','\xa0','b','i','g','.',
/* 0x1b3d1 = "ENCODING" */
    'E','N','C','O','D','I','N','G',
/* 0x1b3d9 = "VERR_PATH_NOT_FOUND" */
    '\x01','P','A','T','H','_','\x06','\x2a',
/* 0x1b3e1 = "VERR_CR_KEY_UNKNOWN_TYPE" */
    '\x01','\x22','K','E','Y','_','\x91','\xb5',
/* 0x1b3e9 = "VERR_IEM_VAR_IPE_4" */
    '\x01','\x9b','V','A','R','_','\x14','4',
/* 0x1b3f1 = "VERR_IEM_VAR_IPE_3" */
    '\x01','\x9b','V','A','R','_','\x14','3',
/* 0x1b3f9 = "VERR_HTTP_NOT_FOUND" */
    '\x01','H','T','T','P','_','\x06','\x2a',
/* 0x1b401 = "VERR_HTTP_NOT_SUPPORTED" */
    '\x01','H','T','T','P','_','\x06','\x82',
/* 0x1b409 = "IOMMU Internal processing error #7." */
    '\xfc',' ','\x07','\x04','\x09','#','7','.',
/* 0x1b411 = "VERR_TOO_MANY_OPENS" */
    '\x01','\x1c','\xaf','O','P','E','N','S',
/* 0x1b419 = "Unexpected VM exit." */
    '\x94','\xcc',' ','e','x','i','t','.',
/* 0x1b421 = "NEM internal processing error #3." */
    '\xec',' ','\x17','\x04','\x09','#','3','.',
/* 0x1b429 = "VERR_INVALID_CPU_ID" */
    '\x01','\x05','C','P','U','_','I','D',
/* 0x1b431 = "VERR_IEM_VAR_IPE_2" */
    '\x01','\x9b','V','A','R','_','\x14','2',
/* 0x1b439 = "VERR_IEM_VAR_IPE_9" */
    '\x01','\x9b','V','A','R','_','\x14','9',
/* 0x1b441 = "VERR_ISOFS_SPM_NOT_SUPPORTED" */
    '\x01','\xa2','S','P','M','_','\x06','\x82',
/* 0x1b449 = "VINF_NO_CHANGE" */
    '\x0e','\x60','C','H','A','N','G','E',
/* 0x1b451 = "VERR_SSM_BAD_REC_TYPE" */
    '\x01','\xb0','\x1d','R','E','C','_','\xb5',
/* 0x1b459 = "VERR_TIMEOUT" */
    '\x01','T','I','M','E','O','U','T',
/* 0x1b461 = "VERR_DBGF_BP_IPE_1" */
    '\x01','\xb9','_','B','P','_','\x14','1',
/* 0x1b469 = "VERR_DBGF_BP_IPE_2" */
    '\x01','\xb9','_','B','P','_','\x14','2',
/* 0x1b471 = "VINF_VMX_VMEXIT" */
    '\x0e','\xe1','V','M','E','X','I','T',
/* 0x1b479 = "VERR_ALREADY_POSTED" */
    '\x01','\x9a','P','O','S','T','E','D',
/* 0x1b481 = "VERR_ISOFS_MPM_NOT_SUPPORTED" */
    '\x01','\xa2','M','P','M','_','\x06','\x82',
/* 0x1b489 = "VERR_ISOFS_BAD_EXTAD" */
    '\x01','\xa2','\x1d','E','X','T','A','D',
/* 0x1b491 = "VINF_EM_HALT" */
    '\x0e','E','M','_','H','A','L','T',
/* 0x1b499 = "VERR_NO_EXEC_MEMORY" */
    '\x01','\x60','E','X','E','C','_','\xb6',
/* 0x1b4a1 = "VERR_COM_VM_ERROR" */
    '\x01','C','O','M','_','\xcc','_','\x1a',
/* 0x1b4a9 = "VERR_GMM_PAGE_NOT_FOUND" */
    '\x01','G','M','M','_','\xdb','\x06','\x2a',
/* 0x1b4b1 = "ALREADY_" */
    'A','L','R','E','A','D','Y','_',
/* 0x1b4b9 = "IOMMU Internal processing error #4." */
    '\xfc',' ','\x07','\x04','\x09','#','4','.',
/* 0x1b4c1 = "NEM internal processing error #0." */
    '\xec',' ','\x17','\x04','\x09','#','0','.',
/* 0x1b4c9 = "No data in pipe." */
    '\xe6','\x9c','\x0f','p','i','p','e','.',
/* 0x1b4d1 = "Generic parse error." */
    '\xa6','p','a','r','s','e',' ','\x84',
/* 0x1b4d9 = "element " */
    'e','l','e','m','e','n','t',' ',
/* 0x1b4e1 = "Process " */
    'P','r','o','c','e','s','s',' ',
/* 0x1b4e9 = "Generic file read error." */
    '\xa6','\x1f','r','e','a','d',' ','\x84',
/* 0x1b4f1 = "VERR_ISOMK_IPE_TABLE" */
    '\x01','\x24','\x14','T','A','B','L','E',
/* 0x1b4f9 = "VERR_ISOFS_UNSUPPORTED_TAG_VERSION" */
    '\x01','\xa2','\x1b','T','A','G','_','\xbc',
/* 0x1b501 = "because " */
    'b','e','c','a','u','s','e',' ',
/* 0x1b509 = "Value not found." */
    'V','a','l','u','e',' ','\x08','\x88',
/* 0x1b511 = "leaving " */
    'l','e','a','v','i','n','g',' ',
/* 0x1b519 = "LUN type is not supported." */
    'L','U','N',' ','\xf1','\x0b','\x08','\xa4',
/* 0x1b521 = "VERR_CV_TODO" */
    '\x01','C','V','_','T','O','D','O',
/* 0x1b529 = "Invalid scheme." */
    '\x0c','s','c','h','e','m','e','.',
/* 0x1b531 = "already " */
    'a','l','r','e','a','d','y',' ',
/* 0x1b539 = "VERR_LDRVI_PARSE_BER_ERROR" */
    '\x01','\xf2','\xe2','B','E','R','_','\x1a',
/* 0x1b541 = "VERR_NOT_A_FILE" */
    '\x01','\x06','A','_','F','I','L','E',
/* 0x1b549 = "NEM internal processing error #8." */
    '\xec',' ','\x17','\x04','\x09','#','8','.',
/* 0x1b551 = "Retry the operation." */
    'R','e','t','r','y',' ','\x02','\xe8',
/* 0x1b559 = "VERR_EMPTY_STRING" */
    '\x01','E','M','P','T','Y','_','\xd4',
/* 0x1b561 = "VERR_VRDP_NO_MEMORY" */
    '\x01','V','R','D','P','_','\x60','\xb6',
/* 0x1b569 = "VERR_DBGF_BP_NOT_FOUND" */
    '\x01','\xb9','_','B','P','_','\x06','\x2a',
/* 0x1b571 = "Internal error in the VFS chain code." */
    '\x07','\x09','\x0f','\x02','\x8d',' ','\x9f','\x83',
/* 0x1b579 = "Timeout." */
    'T','i','m','e','o','u','t','.',
/* 0x1b581 = "NEM init failed." */
    '\xec',' ','i','n','i','t',' ','\x7d',
/* 0x1b589 = "VINF_SUCCESS" */
    '\x0e','S','U','C','C','E','S','S',
/* 0x1b591 = "VERR_ALREADY_LOADED" */
    '\x01','\x9a','L','O','A','D','E','D',
/* 0x1b599 = "VINF_ALREADY_POSTED" */
    '\x0e','\x9a','P','O','S','T','E','D',
/* 0x1b5a1 = "VERR_NO_DIGITS" */
    '\x01','\x60','D','I','G','I','T','S',
/* 0x1b5a9 = "VERR_WRITE_ERROR" */
    '\x01','W','R','I','T','E','_','\x1a',
/* 0x1b5b1 = "VERR_PDM_LUN_NOT_FOUND" */
    '\x01','\x5e','L','U','N','_','\x06','\x2a',
/* 0x1b5b9 = "NEM internal processing error #1." */
    '\xec',' ','\x17','\x04','\x09','#','1','.',
/* 0x1b5c1 = "IOMMU Internal processing error #5." */
    '\xfc',' ','\x07','\x04','\x09','#','5','.',
/* 0x1b5c9 = "support " */
    's','u','p','p','o','r','t',' ',
/* 0x1b5d1 = "content " */
    'c','o','n','t','e','n','t',' ',
/* 0x1b5d9 = "VINF_TIMEOUT" */
    '\x0e','T','I','M','E','O','U','T',
/* 0x1b5e1 = "VERR_SUPDRV_VTG_BAD_STRING" */
    '\x01','\x90','V','T','G','_','\x1d','\xd4',
/* 0x1b5e9 = "IOMMU Internal processing error #9." */
    '\xfc',' ','\x07','\x04','\x09','#','9','.',
/* 0x1b5f1 = "NEM internal processing error #5." */
    '\xec',' ','\x17','\x04','\x09','#','5','.',
/* 0x1b5f9 = "VERR_GVMM_IPE_2" */
    '\x01','G','V','M','M','_','\x14','2',
/* 0x1b601 = "VERR_GVMM_IPE_1" */
    '\x01','G','V','M','M','_','\x14','1',
/* 0x1b609 = "catalog " */
    'c','a','t','a','l','o','g',' ',
/* 0x1b611 = "Invalid " */
    'I','n','v','a','l','i','d',' ',
/* 0x1b619 = "section " */
    's','e','c','t','i','o','n',' ',
/* 0x1b621 = "failed " */
    'f','a','i','l','e','d',' ',
/* 0x1b628 = "MISSING" */
    'M','I','S','S','I','N','G',
/* 0x1b62f = "VERR_READ_ERROR" */
    '\x01','R','E','A','D','_','\x1a',
/* 0x1b636 = "memory " */
    'm','e','m','o','r','y',' ',
/* 0x1b63d = "VERR_CPU_IPE_1" */
    '\x01','C','P','U','_','\x14','1',
/* 0x1b644 = "SUPDRV_" */
    'S','U','P','D','R','V','_',
/* 0x1b64b = "Generic CURL error." */
    '\xa6','C','U','R','L',' ','\x84',
/* 0x1b652 = "VERR_DBG_FILE_MISMATCH" */
    '\x01','D','B','G','_','\xab','\x19',
/* 0x1b659 = "IMPORT_" */
    'I','M','P','O','R','T','_',
/* 0x1b660 = "VERR_LOCK_FAILED" */
    '\x01','L','O','C','K','_','\x16',
/* 0x1b667 = "VERR_SVM_IPE_5" */
    '\x01','S','V','M','_','\x14','5',
/* 0x1b66e = "VERR_SVM_IPE_4" */
    '\x01','S','V','M','_','\x14','4',
/* 0x1b675 = "VERR_SVM_IPE_3" */
    '\x01','S','V','M','_','\x14','3',
/* 0x1b67c = "VERR_DBGC_BP_NOT_FOUND" */
    '\x01','\xfb','B','P','_','\x06','\x2a',
/* 0x1b683 = "digest " */
    'd','i','g','e','s','t',' ',
/* 0x1b68a = "Invalid image type." */
    '\x0c','\x25','t','y','p','e','.',
/* 0x1b691 = "VERR_ALREADY_RESET" */
    '\x01','\x9a','R','E','S','E','T',
/* 0x1b698 = "SUPLIB_" */
    'S','U','P','L','I','B','_',
/* 0x1b69f = "VERR_SUP_VP_NO_MEMORY_STATE" */
    '\x01','\x95','\xbd','\x60','\xb6','_','\xef',
/* 0x1b6a6 = "Syntax error - too many arguments." */
    '\xf7','\x09','-',' ','\xa0','\xb4','\xdc',
/* 0x1b6ad = "VERR_SSM_UNEXPECTED_DATA" */
    '\x01','\xb0','\x86','D','A','T','A',
/* 0x1b6b4 = "volume " */
    'v','o','l','u','m','e',' ',
/* 0x1b6bb = "Bad header size." */
    '\x9d','\xb3','s','i','z','e','.',
/* 0x1b6c2 = "VERR_NO_LOW_MEMORY" */
    '\x01','\x60','L','O','W','_','\xb6',
/* 0x1b6c9 = "VERR_VM_INVALID_VM_STATE" */
    '\x01','\xcc','_','\x05','\xcc','_','\xef',
/* 0x1b6d0 = "VERR_LDRVI_UNSUPPORTED_ARCH" */
    '\x01','\xf2','\x1b','A','R','C','H',
/* 0x1b6d7 = "VERR_GIM_IPE_3" */
    '\x01','G','I','M','_','\x14','3',
/* 0x1b6de = "VERR_SEM_NOT_FOUND" */
    '\x01','S','E','M','_','\x06','\x2a',
/* 0x1b6e5 = "VERR_COM_NOT_SUPPORTED" */
    '\x01','C','O','M','_','\x06','\x82',
/* 0x1b6ec = "VERR_SSM_UNEXPECTED_PASS" */
    '\x01','\xb0','\x86','P','A','S','S',
/* 0x1b6f3 = "VERR_ZIP_UNSUPPORTED_VERSION" */
    '\x01','Z','I','P','_','\x1b','\xbc',
/* 0x1b6fa = "VERR_CPU_NOT_FOUND" */
    '\x01','C','P','U','_','\x06','\x2a',
/* 0x1b701 = "Reason " */
    'R','e','a','s','o','n',' ',
/* 0x1b708 = "VERR_GIM_IPE_2" */
    '\x01','G','I','M','_','\x14','2',
/* 0x1b70f = "VERR_ZIP_NO_MEMORY" */
    '\x01','Z','I','P','_','\x60','\xb6',
/* 0x1b716 = "loader " */
    'l','o','a','d','e','r',' ',
/* 0x1b71d = "Failed " */
    'F','a','i','l','e','d',' ',
/* 0x1b724 = "number " */
    'n','u','m','b','e','r',' ',
/* 0x1b72b = "VERR_OPEN_FAILED" */
    '\x01','O','P','E','N','_','\x16',
/* 0x1b732 = "VERR_GIM_IPE_1" */
    '\x01','G','I','M','_','\x14','1',
/* 0x1b739 = "VERR_IO_CRC" */
    '\x01','I','O','_','C','R','C',
/* 0x1b740 = "VERR_VMX_UNEXPECTED_EXIT" */
    '\x01','\xe1','\x86','E','X','I','T',
/* 0x1b747 = "Unable " */
    'U','n','a','b','l','e',' ',
/* 0x1b74e = "VERR_NOT_SUP_BY_NEM" */
    '\x01','\x06','\x95','B','Y','_','\xec',
/* 0x1b755 = "VERR_INVALID_FMODE" */
    '\x01','\x05','F','M','O','D','E',
/* 0x1b75c = "VERR_TOO_MANY_CPUS" */
    '\x01','\x1c','\xaf','C','P','U','S',
/* 0x1b763 = "object " */
    'o','b','j','e','c','t',' ',
/* 0x1b76a = "VERR_NO_STR_MEMORY" */
    '\x01','\x60','S','T','R','_','\xb6',
/* 0x1b771 = "VERR_SVM_IPE_2" */
    '\x01','S','V','M','_','\x14','2',
/* 0x1b778 = "VERR_ISOFS_TOO_MANY_PDS" */
    '\x01','\xa2','\x1c','\xaf','P','D','S',
/* 0x1b77f = "VERR_COM_PDM_ERROR" */
    '\x01','C','O','M','_','\x5e','\x1a',
/* 0x1b786 = "VERR_SVM_IPE_1" */
    '\x01','S','V','M','_','\x14','1',
/* 0x1b78d = "VINF_EM_OFF" */
    '\x0e','E','M','_','O','F','F',
/* 0x1b794 = "VERR_SSM_INTEGRITY_CRC" */
    '\x01','\xb0','\xf5','_','C','R','C',
/* 0x1b79b = "The VMMR0." */
    '\x03','V','M','M','R','0','.',
/* 0x1b7a2 = "error: " */
    'e','r','r','o','r',':',' ',
/* 0x1b7a9 = "VERR_MEMORY_BUSY" */
    '\x01','\xb6','_','B','U','S','Y',
/* 0x1b7b0 = "Syntax " */
    'S','y','n','t','a','x',' ',
/* 0x1b7b7 = "VERR_NOT_EQUAL" */
    '\x01','\x06','E','Q','U','A','L',
/* 0x1b7be = "VERR_INVALID_DRIVE" */
    '\x01','\x05','D','R','I','V','E',
/* 0x1b7c5 = "VERR_NO_TMP_MEMORY" */
    '\x01','\x60','T','M','P','_','\xb6',
/* 0x1b7cc = "cannot " */
    'c','a','n','n','o','t',' ',
/* 0x1b7d3 = "VERR_INVALID_MAGIC" */
    '\x01','\x05','M','A','G','I','C',
/* 0x1b7da = "VERR_ASN1_TOO_LONG" */
    '\x01','\xa1','\x1c','L','O','N','G',
/* 0x1b7e1 = "VERR_VD_DEK_MISSING" */
    '\x01','\xff','D','E','K','_','\xc4',
/* 0x1b7e8 = "No image UUID." */
    '\xe6','\x25','U','U','I','D','.',
/* 0x1b7ef = "VERR_INVALID_FLAGS" */
    '\x01','\x05','F','L','A','G','S',
/* 0x1b7f6 = "VWRN_INVALID_MAGIC" */
    '\xe4','\x05','M','A','G','I','C',
/* 0x1b7fd = "driver " */
    'd','r','i','v','e','r',' ',
/* 0x1b804 = "VERR_COM_FILE_ERROR" */
    '\x01','C','O','M','_','\xab','\x1a',
/* 0x1b80b = "VERR_VM_UNEXPECTED_VM_STATE" */
    '\x01','\xcc','_','\x86','\xcc','_','\xef',
/* 0x1b812 = "DIGEST_" */
    'D','I','G','E','S','T','_',
/* 0x1b819 = "VERR_NOT_OWNER" */
    '\x01','\x06','O','W','N','E','R',
/* 0x1b820 = "File not found." */
    'F','i','l','e',' ','\x08','\x88',
/* 0x1b827 = "VERR_VFS_CHAIN_IPE" */
    '\x01','\x8d','_','\x8e','I','P','E',
/* 0x1b82e = "VERR_XAR_NO_ENCODING" */
    '\x01','X','A','R','_','\x60','\xc6',
/* 0x1b835 = "Invalid pVMCB." */
    '\x0c','p','V','M','C','B','.',
/* 0x1b83c = "VERR_XAR_UNSUPPORTED_VERSION" */
    '\x01','X','A','R','_','\x1b','\xbc',
/* 0x1b843 = "VERR_CV_IPE" */
    '\x01','C','V','_','I','P','E',
/* 0x1b84a = "The VMMRC." */
    '\x03','V','M','M','R','C','.',
/* 0x1b851 = "Path not found." */
    'P','a','t','h',' ','\x08','\x88',
/* 0x1b858 = "Import " */
    'I','m','p','o','r','t',' ',
/* 0x1b85f = "failed." */
    'f','a','i','l','e','d','.',
/* 0x1b866 = "VINF_EM_NO_MEMORY" */
    '\x0e','E','M','_','\x60','\xb6',
/* 0x1b86c = "VERR_VMX_NO_VMX" */
    '\x01','\xe1','\x60','V','M','X',
/* 0x1b872 = "VERR_TM_UNKNOWN_STATE" */
    '\x01','T','M','_','\x91','\xef',
/* 0x1b878 = "VERR_FILE_IO_ERROR" */
    '\x01','\xab','I','O','_','\x1a',
/* 0x1b87e = "LDRVI_" */
    'L','D','R','V','I','_',
/* 0x1b884 = "VERR_TM_IPE_9" */
    '\x01','T','M','_','\x14','9',
/* 0x1b88a = "VERR_TM_IPE_7" */
    '\x01','T','M','_','\x14','7',
/* 0x1b890 = "VERR_TM_IPE_6" */
    '\x01','T','M','_','\x14','6',
/* 0x1b896 = "found." */
    'f','o','u','n','d','.',
/* 0x1b89c = "VERR_DBGC_QUIT" */
    '\x01','\xfb','Q','U','I','T',
/* 0x1b8a2 = "Generic RSA error." */
    '\xa6','R','S','A',' ','\x84',
/* 0x1b8a8 = "VERR_DBGC_PARSE_BUG" */
    '\x01','\xfb','\xe2','B','U','G',
/* 0x1b8ae = "entry " */
    'e','n','t','r','y',' ',
/* 0x1b8b4 = "VERR_TM_INVALID_STATE" */
    '\x01','T','M','_','\x05','\xef',
/* 0x1b8ba = "VERR_IDT_FAILED" */
    '\x01','I','D','T','_','\x16',
/* 0x1b8c0 = "guest " */
    'g','u','e','s','t',' ',
/* 0x1b8c6 = "VERR_LDRMACHO_TODO" */
    '\x01','\xe7','T','O','D','O',
/* 0x1b8cc = "chain " */
    'c','h','a','i','n',' ',
/* 0x1b8d2 = "VERR_HM_IPE_5" */
    '\x01','H','M','_','\x14','5',
/* 0x1b8d8 = "VERR_HM_IPE_4" */
    '\x01','H','M','_','\x14','4',
/* 0x1b8de = "VERR_HM_IPE_3" */
    '\x01','H','M','_','\x14','3',
/* 0x1b8e4 = "error." */
    'e','r','r','o','r','.',
/* 0x1b8ea = "error " */
    'e','r','r','o','r',' ',
/* 0x1b8f0 = "VERR_HM_IPE_2" */
    '\x01','H','M','_','\x14','2',
/* 0x1b8f6 = "VERR_HM_IPE_1" */
    '\x01','H','M','_','\x14','1',
/* 0x1b8fc = "The specified register was not found." */
    '\x03','\x18','\xe9','\x11','\x08','\x88',
/* 0x1b902 = "VERR_TM_IPE_5" */
    '\x01','T','M','_','\x14','5',
/* 0x1b908 = "Bad pipe." */
    '\x9d','p','i','p','e','.',
/* 0x1b90e = "PARSE_" */
    'P','A','R','S','E','_',
/* 0x1b914 = "VERR_ISOFS_NO_PVD" */
    '\x01','\xa2','\x60','P','V','D',
/* 0x1b91a = "VERR_ASN1_INTERNAL_ERROR_5" */
    '\x01','\xa1','\xc2','\x1a','_','5',
/* 0x1b920 = "VERR_ASN1_INTERNAL_ERROR_4" */
    '\x01','\xa1','\xc2','\x1a','_','4',
/* 0x1b926 = "VERR_ASN1_INTERNAL_ERROR_3" */
    '\x01','\xa1','\xc2','\x1a','_','3',
/* 0x1b92c = "VERR_MAP_FAILED" */
    '\x01','M','A','P','_','\x16',
/* 0x1b932 = "Seek error." */
    'S','e','e','k',' ','\x84',
/* 0x1b938 = "Invalid XML found." */
    '\x0c','X','M','L',' ','\x88',
/* 0x1b93e = "VERR_ASN1_INTERNAL_ERROR_2" */
    '\x01','\xa1','\xc2','\x1a','_','2',
/* 0x1b944 = "VERR_ASN1_INTERNAL_ERROR_1" */
    '\x01','\xa1','\xc2','\x1a','_','1',
/* 0x1b94a = "VERR_TM_IPE_4" */
    '\x01','T','M','_','\x14','4',
/* 0x1b950 = "VERR_TM_IPE_8" */
    '\x01','T','M','_','\x14','8',
/* 0x1b956 = "ISOMK_" */
    'I','S','O','M','K','_',
/* 0x1b95c = "VERR_TM_IPE_3" */
    '\x01','T','M','_','\x14','3',
/* 0x1b962 = "VERR_TM_IPE_2" */
    '\x01','T','M','_','\x14','2',
/* 0x1b968 = "VERR_TM_IPE_1" */
    '\x01','T','M','_','\x14','1',
/* 0x1b96e = "Error " */
    'E','r','r','o','r',' ',
/* 0x1b974 = "VERR_BAD_PIPE" */
    '\x01','\x1d','P','I','P','E',
/* 0x1b97a = "value." */
    'v','a','l','u','e','.',
/* 0x1b980 = "state " */
    's','t','a','t','e',' ',
/* 0x1b986 = "Generic SPC error." */
    '\xa6','S','P','C',' ','\x84',
/* 0x1b98c = "VERR_NO_DATA" */
    '\x01','\x60','D','A','T','A',
/* 0x1b992 = "VERR_EM_INTERNAL_ERROR" */
    '\x01','E','M','_','\xc2','\x1a',
/* 0x1b998 = "VERR_ZIP_ERROR" */
    '\x01','Z','I','P','_','\x1a',
/* 0x1b99e = "VERR_EM_NO_MEMORY" */
    '\x01','E','M','_','\x60','\xb6',
/* 0x1b9a4 = "VERR_VFS_CHAIN_UNKNOWN_TYPE" */
    '\x01','\x8d','_','\x8e','\x91','\xb5',
/* 0x1b9aa = "VERR_ISOFS_NO_LVD" */
    '\x01','\xa2','\x60','L','V','D',
/* 0x1b9b0 = "VERR_INVALID_NAME" */
    '\x01','\x05','N','A','M','E',
/* 0x1b9b6 = "VERR_SEM_ERROR" */
    '\x01','S','E','M','_','\x1a',
/* 0x1b9bc = "ISOFS_" */
    'I','S','O','F','S','_',
/* 0x1b9c2 = "VERR_S3_NOT_FOUND" */
    '\x01','S','3','_','\x06','\x2a',
/* 0x1b9c8 = "VERR_LDRVI_PARSE_IPE" */
    '\x01','\xf2','\xe2','I','P','E',
/* 0x1b9ce = "VERR_ISOFS_UNSUPPORTED_ICB" */
    '\x01','\xa2','\x1b','I','C','B',
/* 0x1b9d4 = "VERR_LDRVI_NO_MEMORY_STATE" */
    '\x01','\xf2','\x60','\xb6','_','\xef',
/* 0x1b9da = "Long ASN." */
    'L','o','n','g',' ','\xf4',
/* 0x1b9e0 = "Generic zip error." */
    '\xa6','z','i','p',' ','\x84',
/* 0x1b9e6 = "image " */
    'i','m','a','g','e',' ',
/* 0x1b9ec = "PKCS7_" */
    'P','K','C','S','7','_',
/* 0x1b9f2 = "IPRT error." */
    'I','P','R','T',' ','\x84',
/* 0x1b9f8 = "The specified process was not found." */
    '\x03','\x18','\x92','\x11','\x08','\x88',
/* 0x1b9fe = "FAILED" */
    'F','A','I','L','E','D',
/* 0x1ba04 = "which " */
    'w','h','i','c','h',' ',
/* 0x1ba0a = "VERR_FILE_TOO_BIG" */
    '\x01','\xab','\x1c','B','I','G',
/* 0x1ba10 = "value " */
    'v','a','l','u','e',' ',
/* 0x1ba16 = "Internal error in the X." */
    '\x07','\x09','\x0f','\x02','X','.',
/* 0x1ba1c = "VERR_CR_X509_INTERNAL_ERROR" */
    '\x01','\x22','\xb7','\xc2','\x1a',
/* 0x1ba21 = "Internal error #7." */
    '\x07','\x09','#','7','.',
/* 0x1ba26 = "VERR_INTERNAL_ERROR_3" */
    '\x01','\xc2','\x1a','_','3',
/* 0x1ba2b = "FOUND" */
    'F','O','U','N','D',
/* 0x1ba30 = "Internal error #4." */
    '\x07','\x09','#','4','.',
/* 0x1ba35 = "VERR_INTERNAL_ERROR_2" */
    '\x01','\xc2','\x1a','_','2',
/* 0x1ba3a = "VERR_PGM_UNEXPECTED_PAGE_STATE" */
    '\x01','\x8c','\x86','\xdb','\xef',
/* 0x1ba3f = "VERR_IOMMU_IPE_9" */
    '\x01','\xfc','_','\x14','9',
/* 0x1ba44 = "VERR_IOMMU_IPE_8" */
    '\x01','\xfc','_','\x14','8',
/* 0x1ba49 = "VERR_IOMMU_IPE_7" */
    '\x01','\xfc','_','\x14','7',
/* 0x1ba4e = "VERR_IOMMU_IPE_6" */
    '\x01','\xfc','_','\x14','6',
/* 0x1ba53 = "VERR_IOMMU_IPE_5" */
    '\x01','\xfc','_','\x14','5',
/* 0x1ba58 = "VERR_IOMMU_IPE_4" */
    '\x01','\xfc','_','\x14','4',
/* 0x1ba5d = "VERR_IOMMU_IPE_3" */
    '\x01','\xfc','_','\x14','3',
/* 0x1ba62 = "VERR_IOMMU_IPE_2" */
    '\x01','\xfc','_','\x14','2',
/* 0x1ba67 = "VERR_NEM_IPE_9" */
    '\x01','\xec','_','\x14','9',
/* 0x1ba6c = "VERR_NEM_IPE_8" */
    '\x01','\xec','_','\x14','8',
/* 0x1ba71 = "VERR_NEM_IPE_7" */
    '\x01','\xec','_','\x14','7',
/* 0x1ba76 = "VERR_NEM_IPE_6" */
    '\x01','\xec','_','\x14','6',
/* 0x1ba7b = "Internal error #8." */
    '\x07','\x09','#','8','.',
/* 0x1ba80 = "VERR_CR_DIGEST_NOT_SUPPORTED" */
    '\x01','\x22','\xbe','\x06','\x82',
/* 0x1ba85 = "VERR_NEM_IPE_5" */
    '\x01','\xec','_','\x14','5',
/* 0x1ba8a = "VERR_NEM_IPE_4" */
    '\x01','\xec','_','\x14','4',
/* 0x1ba8f = "VERR_NEM_IPE_3" */
    '\x01','\xec','_','\x14','3',
/* 0x1ba94 = "Internal error #1." */
    '\x07','\x09','#','1','.',
/* 0x1ba99 = "VERR_NEM_IPE_2" */
    '\x01','\xec','_','\x14','2',
/* 0x1ba9e = "VERR_NEM_IPE_1" */
    '\x01','\xec','_','\x14','1',
/* 0x1baa3 = "VERR_NEM_IPE_0" */
    '\x01','\xec','_','\x14','0',
/* 0x1baa8 = "VERR_IOMMU_IPE_1" */
    '\x01','\xfc','_','\x14','1',
/* 0x1baad = "VERR_IOMMU_IPE_0" */
    '\x01','\xfc','_','\x14','0',
/* 0x1bab2 = "VWRN_UNSUPPORTED_CPU" */
    '\xe4','\x1b','C','P','U',
/* 0x1bab7 = "VERR_" */
    'V','E','R','R','_',
/* 0x1babc = "does " */
    'd','o','e','s',' ',
/* 0x1bac1 = "MANY_" */
    'M','A','N','Y','_',
/* 0x1bac6 = "Internal error #5." */
    '\x07','\x09','#','5','.',
/* 0x1bacb = "VINF_" */
    'V','I','N','F','_',
/* 0x1bad0 = "IOMMU" */
    'I','O','M','M','U',
/* 0x1bad5 = "Unsupported CPU." */
    '\x97','C','P','U','.',
/* 0x1bada = "FILE_" */
    'F','I','L','E','_',
/* 0x1badf = "Internal error #9." */
    '\x07','\x09','#','9','.',
/* 0x1bae4 = "been " */
    'b','e','e','n',' ',
/* 0x1bae9 = "Internal error #2." */
    '\x07','\x09','#','2','.',
/* 0x1baee = "VERR_CR_PKCS7_INTERNAL_ERROR" */
    '\x01','\x22','\xe3','\xc2','\x1a',
/* 0x1baf3 = "with " */
    'w','i','t','h',' ',
/* 0x1baf8 = "DBGC_" */
    'D','B','G','C','_',
/* 0x1bafd = "Not supported." */
    'N','o','t',' ','\xa4',
/* 0x1bb02 = "IPC error." */
    'I','P','C',' ','\x84',
/* 0x1bb07 = "that " */
    't','h','a','t',' ',
/* 0x1bb0c = "ERROR" */
    'E','R','R','O','R',
/* 0x1bb11 = "Internal error #6." */
    '\x07','\x09','#','6','.',
/* 0x1bb16 = "VERR_INTERNAL_ERROR_5" */
    '\x01','\xc2','\x1a','_','5',
/* 0x1bb1b = "VERR_DBGC_IPE" */
    '\x01','\xfb','I','P','E',
/* 0x1bb20 = "VERR_INTERNAL_ERROR_4" */
    '\x01','\xc2','\x1a','_','4',
/* 0x1bb25 = "VERR_DBGC_PARSE_NO_MEMORY" */
    '\x01','\xfb','\xe2','\x60','\xb6',
/* 0x1bb2a = "VERR_NO_VM_MEMORY" */
    '\x01','\x60','\xcc','_','\xb6',
/* 0x1bb2f = "ASN1_" */
    'A','S','N','1','_',
/* 0x1bb34 = "VERR_ISOFS_UNKNOWN_FILE_TYPE" */
    '\x01','\xa2','\x91','\xab','\xb5',
/* 0x1bb39 = "VERR_ISOFS_NO_PD" */
    '\x01','\xa2','\x60','P','D',
/* 0x1bb3e = "VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE" */
    '\x01','\xe7','\x1b','\xab','\xb5',
/* 0x1bb43 = "page " */
    'p','a','g','e',' ',
/* 0x1bb48 = "VERR_DBGF_IPE_1" */
    '\x01','\xb9','_','\x14','1',
/* 0x1bb4d = "X509_" */
    'X','5','0','9','_',
/* 0x1bb52 = "VERR_SSM_INTEGRITY_VERSION" */
    '\x01','\xb0','\xf5','_','\xbc',
/* 0x1bb57 = "Internal error no." */
    '\x07','\x09','n','o','.',
/* 0x1bb5c = "VERR_SSM_INTEGRITY_SIZE" */
    '\x01','\xb0','\xf5','_','\xfe',
/* 0x1bb61 = "Internal error #3." */
    '\x07','\x09','#','3','.',
/* 0x1bb66 = "VERR_INVALID_RPL" */
    '\x01','\x05','R','P','L',
/* 0x1bb6b = "many " */
    'm','a','n','y',' ',
/* 0x1bb70 = "VWRN_" */
    'V','W','R','N','_',
/* 0x1bb75 = "VERR_ISOFS_IPE_5" */
    '\x01','\xa2','\x14','5',
/* 0x1bb79 = "VERR_VD_INVALID_SIZE" */
    '\x01','\xff','\x05','\xfe',
/* 0x1bb7d = "was " */
    'w','a','s',' ',
/* 0x1bb81 = "VERR_VD_INVALID_TYPE" */
    '\x01','\xff','\x05','\xb5',
/* 0x1bb85 = "VERR_SSM_IPE_3" */
    '\x01','\xb0','\x14','3',
/* 0x1bb89 = "VERR_SSM_IPE_2" */
    '\x01','\xb0','\x14','2',
/* 0x1bb8d = "VERR_SSM_IPE_1" */
    '\x01','\xb0','\x14','1',
/* 0x1bb91 = "VERR_VD_INVALID_STATE" */
    '\x01','\xff','\x05','\xef',
/* 0x1bb95 = "VERR_ISOFS_IPE_4" */
    '\x01','\xa2','\x14','4',
/* 0x1bb99 = "VERR_ISOFS_IPE_3" */
    '\x01','\xa2','\x14','3',
/* 0x1bb9d = "VERR_FILE_NOT_FOUND" */
    '\x01','\xab','\x06','\x2a',
/* 0x1bba1 = "TOO_" */
    'T','O','O','_',
/* 0x1bba5 = "VERR_ISOFS_IPE_2" */
    '\x01','\xa2','\x14','2',
/* 0x1bba9 = "PGM_" */
    'P','G','M','_',
/* 0x1bbad = "Generic invalid state error." */
    '\xa6','\x8f','\xcd','\x84',
/* 0x1bbb1 = "VERR_VMX_IPE_5" */
    '\x01','\xe1','\x14','5',
/* 0x1bbb5 = "VERR_VMX_IPE_4" */
    '\x01','\xe1','\x14','4',
/* 0x1bbb9 = "VERR_NO_PAGE_MEMORY" */
    '\x01','\x60','\xdb','\xb6',
/* 0x1bbbd = "too " */
    't','o','o',' ',
/* 0x1bbc1 = "VERR_VMX_IPE_3" */
    '\x01','\xe1','\x14','3',
/* 0x1bbc5 = "VERR_VMX_IPE_2" */
    '\x01','\xe1','\x14','2',
/* 0x1bbc9 = "SUP_" */
    'S','U','P','_',
/* 0x1bbcd = "VERR_EOF" */
    '\x01','E','O','F',
/* 0x1bbd1 = "DBGF" */
    'D','B','G','F',
/* 0x1bbd5 = "Bad " */
    'B','a','d',' ',
/* 0x1bbd9 = "VERR_VMX_IPE_1" */
    '\x01','\xe1','\x14','1',
/* 0x1bbdd = "has " */
    'h','a','s',' ',
/* 0x1bbe1 = "The " */
    'T','h','e',' ',
/* 0x1bbe5 = "VMX_" */
    'V','M','X','_',
/* 0x1bbe9 = "VERR_ISOFS_IPE_1" */
    '\x01','\xa2','\x14','1',
/* 0x1bbed = "VERR_VERSION_MISMATCH" */
    '\x01','\xbc','_','\x19',
/* 0x1bbf1 = "SSM_" */
    'S','S','M','_',
/* 0x1bbf5 = "VERR_IEM_IPE_1" */
    '\x01','\x9b','\x14','1',
/* 0x1bbf9 = "VERR_IEM_IPE_7" */
    '\x01','\x9b','\x14','7',
/* 0x1bbfd = "ANS." */
    'A','N','S','.',
/* 0x1bc01 = "VERR_IEM_IPE_6" */
    '\x01','\x9b','\x14','6',
/* 0x1bc05 = "VINF_EOF" */
    '\x0e','E','O','F',
/* 0x1bc09 = "IEM_" */
    'I','E','M','_',
/* 0x1bc0d = "PDM_" */
    'P','D','M','_',
/* 0x1bc11 = "ASN." */
    'A','S','N','.',
/* 0x1bc15 = "VERR_SSM_INVALID_STATE" */
    '\x01','\xb0','\x05','\xef',
/* 0x1bc19 = "VERR_IEM_IPE_5" */
    '\x01','\x9b','\x14','5',
/* 0x1bc1d = "VERR_IEM_IPE_4" */
    '\x01','\x9b','\x14','4',
/* 0x1bc21 = "VERR_IEM_IPE_3" */
    '\x01','\x9b','\x14','3',
/* 0x1bc25 = "VERR_IEM_IPE_2" */
    '\x01','\x9b','\x14','2',
/* 0x1bc29 = "BAD_" */
    'B','A','D','_',
/* 0x1bc2d = "VERR_IEM_IPE_9" */
    '\x01','\x9b','\x14','9',
/* 0x1bc31 = "VERR_IEM_IPE_8" */
    '\x01','\x9b','\x14','8',
/* 0x1bc35 = "VFS" */
    'V','F','S',
/* 0x1bc38 = "VERR_NOT_FOUND" */
    '\x01','\x06','\x2a',
/* 0x1bc3b = "VERR_NOT_SUPPORTED" */
    '\x01','\x06','\x82',
/* 0x1bc3e = "Encountered an ASN." */
    '\xa5','\x87','\xf4',
/* 0x1bc41 = "Unknown X." */
    '\xf8','X','.',
/* 0x1bc44 = "VWRN_NOT_FOUND" */
    '\xe4','\x06','\x2a',
/* 0x1bc47 = "No " */
    'N','o',' ',
/* 0x1bc4a = "Generic X." */
    '\xa6','X','.',
/* 0x1bc4d = "NO_" */
    'N','O','_',
/* 0x1bc50 = "Unsupported X." */
    '\x97','X','.',
/* 0x1bc53 = "VINF_NOT_SUPPORTED" */
    '\x0e','\x06','\x82',
/* 0x1bc56 = "VERR_PARSE_ERROR" */
    '\x01','\xe2','\x1a',
/* 0x1bc59 = "of " */
    'o','f',' ',
/* 0x1bc5c = "CR_" */
    'C','R','_',
/* 0x1bc5f = "VERR_ASN1_ERROR" */
    '\x01','\xa1','\x1a',
/* 0x1bc62 = "VERR_INVALID_STATE" */
    '\x01','\x05','\xef',
/* 0x1bc65 = "VERR_NO_MEMORY" */
    '\x01','\x60','\xb6',
/* 0x1bc68 = "VWRN_INVALID_STATE" */
    '\xe4','\x05','\xef',
/* 0x1bc6b = "Bad ASN." */
    '\x9d','\xf4',
/* 0x1bc6d = "Invalid ASN." */
    '\x0c','\xf4',
/* 0x1bc6f = "VERR_MISSING" */
    '\x01','\xc4',
/* 0x1bc71 = "VERR_MISMATCH" */
    '\x01','\x19',
/* 0x1bc73 = "Unexpected ASN." */
    '\x94','\xf4',
/* 0x1bc75 = "The ASN." */
    '\x03','\xf4',
/* 0x1bc77 = "Internal error." */
    '\x07','\x84',
};
AssertCompile(sizeof(g_achStrTabStatusMsgStrTab) == 0x1bc79);

static const RTBLDPROGSTRREF g_aCompDictStatusMsgStrTab[256] = 
{
    /*[  0]=*/ { 0x000000, 0x00 }, // unused, because zero terminator
    /*[  1]=*/ { 0x01bab7, 0x05 }, //  11170 - VERR_
    /*[  2]=*/ { 0x0041cf, 0x04 }, //   2604 - the 
    /*[  3]=*/ { 0x01bbe1, 0x04 }, //   2112 - The 
    /*[  4]=*/ { 0x01a281, 0x0b }, //   1716 - processing 
    /*[  5]=*/ { 0x01b1f1, 0x08 }, //   1560 - INVALID_
    /*[  6]=*/ { 0x00a840, 0x04 }, //   1344 - NOT_
    /*[  7]=*/ { 0x01af3b, 0x09 }, //   1341 - Internal 
    /*[  8]=*/ { 0x0029ac, 0x04 }, //   1320 - not 
    /*[  9]=*/ { 0x01b8ea, 0x06 }, //   1224 - error 
    /*[ 10]=*/ { 0x000745, 0x03 }, //   1128 - to 
    /*[ 11]=*/ { 0x000041, 0x03 }, //   1050 - is 
    /*[ 12]=*/ { 0x01b611, 0x08 }, //   1048 - Invalid 
    /*[ 13]=*/ { 0x0196bf, 0x0d }, //    988 - Verification 
    /*[ 14]=*/ { 0x01bacb, 0x05 }, //    955 - VINF_
    /*[ 15]=*/ { 0x00055c, 0x03 }, //    879 - in 
    /*[ 16]=*/ { 0x000f20, 0x04 }, //    764 - for 
    /*[ 17]=*/ { 0x01bb7d, 0x04 }, //    720 - was 
    /*[ 18]=*/ { 0x01b06c, 0x09 }, //    684 - Failure: 
    /*[ 19]=*/ { 0x019fc9, 0x0c }, //    684 - Recompiler: 
    /*[ 20]=*/ { 0x0173e1, 0x04 }, //    648 - IPE_
    /*[ 21]=*/ { 0x01bc59, 0x03 }, //    639 - of 
    /*[ 22]=*/ { 0x01b9fe, 0x06 }, //    612 - FAILED
    /*[ 23]=*/ { 0x00d718, 0x09 }, //    603 - internal 
    /*[ 24]=*/ { 0x01ac58, 0x0a }, //    590 - specified 
    /*[ 25]=*/ { 0x00bd6d, 0x08 }, //    552 - MISMATCH
    /*[ 26]=*/ { 0x01bb0c, 0x05 }, //    530 - ERROR
    /*[ 27]=*/ { 0x01980d, 0x0c }, //    528 - UNSUPPORTED_
    /*[ 28]=*/ { 0x01bba1, 0x04 }, //    524 - TOO_
    /*[ 29]=*/ { 0x01bc29, 0x04 }, //    520 - BAD_
    /*[ 30]=*/ { 0x01b4e1, 0x08 }, //    512 - Process 
    /*[ 31]=*/ { 0x00155b, 0x05 }, //    490 - file 
    /*[ 32]=*/ { 0x000000, 0x00 }, // ' '
    /*[ 33]=*/ { 0x000000, 0x00 }, // '!'
    /*[ 34]=*/ { 0x01bc5c, 0x03 }, //    489 - CR_
    /*[ 35]=*/ { 0x000000, 0x00 }, // '#'
    /*[ 36]=*/ { 0x01b956, 0x06 }, //    480 - ISOMK_
    /*[ 37]=*/ { 0x01b9e6, 0x06 }, //    468 - image 
    /*[ 38]=*/ { 0x01ab5e, 0x0a }, //    460 - directory 
    /*[ 39]=*/ { 0x000000, 0x00 }, // '''
    /*[ 40]=*/ { 0x000000, 0x00 }, // '('
    /*[ 41]=*/ { 0x000000, 0x00 }, // ')'
    /*[ 42]=*/ { 0x01ba2b, 0x05 }, //    445 - FOUND
    /*[ 43]=*/ { 0x000000, 0x00 }, // '+'
    /*[ 44]=*/ { 0x000000, 0x00 }, // ','
    /*[ 45]=*/ { 0x000000, 0x00 }, // '-'
    /*[ 46]=*/ { 0x000000, 0x00 }, // '.'
    /*[ 47]=*/ { 0x000000, 0x00 }, // '/'
    /*[ 48]=*/ { 0x000000, 0x00 }, // '0'
    /*[ 49]=*/ { 0x000000, 0x00 }, // '1'
    /*[ 50]=*/ { 0x000000, 0x00 }, // '2'
    /*[ 51]=*/ { 0x000000, 0x00 }, // '3'
    /*[ 52]=*/ { 0x000000, 0x00 }, // '4'
    /*[ 53]=*/ { 0x000000, 0x00 }, // '5'
    /*[ 54]=*/ { 0x000000, 0x00 }, // '6'
    /*[ 55]=*/ { 0x000000, 0x00 }, // '7'
    /*[ 56]=*/ { 0x000000, 0x00 }, // '8'
    /*[ 57]=*/ { 0x000000, 0x00 }, // '9'
    /*[ 58]=*/ { 0x000000, 0x00 }, // ':'
    /*[ 59]=*/ { 0x000000, 0x00 }, // ';'
    /*[ 60]=*/ { 0x000000, 0x00 }, // '<'
    /*[ 61]=*/ { 0x000000, 0x00 }, // '='
    /*[ 62]=*/ { 0x000000, 0x00 }, // '>'
    /*[ 63]=*/ { 0x000000, 0x00 }, // '?'
    /*[ 64]=*/ { 0x01b501, 0x08 }, //    440 - because 
    /*[ 65]=*/ { 0x000000, 0x00 }, // 'A'
    /*[ 66]=*/ { 0x000000, 0x00 }, // 'B'
    /*[ 67]=*/ { 0x000000, 0x00 }, // 'C'
    /*[ 68]=*/ { 0x000000, 0x00 }, // 'D'
    /*[ 69]=*/ { 0x000000, 0x00 }, // 'E'
    /*[ 70]=*/ { 0x000000, 0x00 }, // 'F'
    /*[ 71]=*/ { 0x000000, 0x00 }, // 'G'
    /*[ 72]=*/ { 0x000000, 0x00 }, // 'H'
    /*[ 73]=*/ { 0x000000, 0x00 }, // 'I'
    /*[ 74]=*/ { 0x000000, 0x00 }, // 'J'
    /*[ 75]=*/ { 0x000000, 0x00 }, // 'K'
    /*[ 76]=*/ { 0x000000, 0x00 }, // 'L'
    /*[ 77]=*/ { 0x000000, 0x00 }, // 'M'
    /*[ 78]=*/ { 0x000000, 0x00 }, // 'N'
    /*[ 79]=*/ { 0x000000, 0x00 }, // 'O'
    /*[ 80]=*/ { 0x000000, 0x00 }, // 'P'
    /*[ 81]=*/ { 0x000000, 0x00 }, // 'Q'
    /*[ 82]=*/ { 0x000000, 0x00 }, // 'R'
    /*[ 83]=*/ { 0x000000, 0x00 }, // 'S'
    /*[ 84]=*/ { 0x000000, 0x00 }, // 'T'
    /*[ 85]=*/ { 0x000000, 0x00 }, // 'U'
    /*[ 86]=*/ { 0x000000, 0x00 }, // 'V'
    /*[ 87]=*/ { 0x000000, 0x00 }, // 'W'
    /*[ 88]=*/ { 0x000000, 0x00 }, // 'X'
    /*[ 89]=*/ { 0x000000, 0x00 }, // 'Y'
    /*[ 90]=*/ { 0x000000, 0x00 }, // 'Z'
    /*[ 91]=*/ { 0x000000, 0x00 }, // '['
    /*[ 92]=*/ { 0x01b4d9, 0x08 }, //    440 - element 
    /*[ 93]=*/ { 0x000000, 0x00 }, // ']'
    /*[ 94]=*/ { 0x01bc0d, 0x04 }, //    432 - PDM_
    /*[ 95]=*/ { 0x000000, 0x00 }, // '_'
    /*[ 96]=*/ { 0x01bc4d, 0x03 }, //    429 - NO_
    /*[ 97]=*/ { 0x000000, 0x00 }, // 'a'
    /*[ 98]=*/ { 0x000000, 0x00 }, // 'b'
    /*[ 99]=*/ { 0x000000, 0x00 }, // 'c'
    /*[100]=*/ { 0x000000, 0x00 }, // 'd'
    /*[101]=*/ { 0x000000, 0x00 }, // 'e'
    /*[102]=*/ { 0x000000, 0x00 }, // 'f'
    /*[103]=*/ { 0x000000, 0x00 }, // 'g'
    /*[104]=*/ { 0x000000, 0x00 }, // 'h'
    /*[105]=*/ { 0x000000, 0x00 }, // 'i'
    /*[106]=*/ { 0x000000, 0x00 }, // 'j'
    /*[107]=*/ { 0x000000, 0x00 }, // 'k'
    /*[108]=*/ { 0x000000, 0x00 }, // 'l'
    /*[109]=*/ { 0x000000, 0x00 }, // 'm'
    /*[110]=*/ { 0x000000, 0x00 }, // 'n'
    /*[111]=*/ { 0x000000, 0x00 }, // 'o'
    /*[112]=*/ { 0x000000, 0x00 }, // 'p'
    /*[113]=*/ { 0x000000, 0x00 }, // 'q'
    /*[114]=*/ { 0x000000, 0x00 }, // 'r'
    /*[115]=*/ { 0x000000, 0x00 }, // 's'
    /*[116]=*/ { 0x000000, 0x00 }, // 't'
    /*[117]=*/ { 0x000000, 0x00 }, // 'u'
    /*[118]=*/ { 0x000000, 0x00 }, // 'v'
    /*[119]=*/ { 0x000000, 0x00 }, // 'w'
    /*[120]=*/ { 0x000000, 0x00 }, // 'x'
    /*[121]=*/ { 0x000000, 0x00 }, // 'y'
    /*[122]=*/ { 0x000000, 0x00 }, // 'z'
    /*[123]=*/ { 0x01bbdd, 0x04 }, //    428 - has 
    /*[124]=*/ { 0x000000, 0x00 }, // '|'
    /*[125]=*/ { 0x01b85f, 0x07 }, //    427 - failed.
    /*[126]=*/ { 0x000000, 0x00 }, // '~'
    /*[127]=*/ { 0x01b531, 0x08 }, //    424 - already 
    /*[128]=*/ { 0x01baf3, 0x05 }, //    410 - with 
    /*[129]=*/ { 0x01b511, 0x08 }, //    400 - leaving 
    /*[130]=*/ { 0x00ad32, 0x09 }, //    396 - SUPPORTED
    /*[131]