
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack(1)
#endif
typedef struct RTMSGENTRYINT
{
    uint64_t offDefine   : 17; /* max 0x1f5e4 */
    uint64_t offMsgShort : 17; /* max 0x1f5e2 */
    uint64_t offMsgFull  : 17; /* max 0x1f5e2 */
    uint64_t cchMsgFull  :  9; /* max 0x170 */
    int32_t  iCode       : 16;
    uint32_t cchDefine   :  6; /* max 0x2b */
    uint32_t cchMsgShort :  8; /* max 0x8a */
} RTMSGENTRYINT;
typedef RTMSGENTRYINT *PCRTMSGENTRYINT;
#if defined(RT_ARCH_AMD64) || defined(RT_ARCH_X86)
# pragma pack()
#endif

static const RTMSGENTRYINT g_aStatusMsgs[ /*2461*/ ] =
{
    { 0x01a06e, 0x0057b8, 0x0057b8,  60, -27018,  18,  60 }, /* VERR_FDT_AT_ROOT_LEVEL */
    { 0x00e1d4, 0x00bfef, 0x00bfef,  36, -27017,  32,  36 }, /* VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED */
    { 0x010ba8, 0x00aaff, 0x00aaff,  40, -27016,  28,  40 }, /* VERR_FDT_DTB_PROP_SIZE_MALFORMED */
    { 0x0102eb, 0x009c52, 0x009c52,  42, -27015,  29,  42 }, /* VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE */
    { 0x00c427, 0x00b8eb, 0x00b8eb,  37, -27014,  36,  37 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END */
    { 0x00a96f, 0x008348, 0x008348,  48, -27013,  40,  48 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING */
    { 0x009fec, 0x00a15d, 0x00a15d,  41, -27012,  41,  41 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED */
    { 0x00a8cf, 0x00e2b4, 0x00e2b4,  32, -27011,  40,  32 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID */
    { 0x00c58f, 0x00c8b9, 0x00c8b9,  35, -27010,  36,  35 }, /* VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID */
    { 0x00d201, 0x00bd41, 0x00bd41,  37, -27009,  34,  37 }, /* VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED */
    { 0x00a39b, 0x003cc8, 0x003cc8,  77, -27008,  41,  77 }, /* VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING */
    { 0x00b568, 0x00bd41, 0x00bd41,  37, -27007,  38,  37 }, /* VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID */
    { 0x00b935, 0x00bf3b, 0x00bf3b,  36, -27006,  37,  36 }, /* VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID */
    { 0x00b6e4, 0x009988, 0x009988,  42, -27005,  38,  42 }, /* VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID */
    { 0x01323a, 0x008555, 0x008555,  47, -27004,  25,  47 }, /* VERR_FDT_DTB_HDR_SIZE_INVALID */
    { 0x00a5ff, 0x00bcf7, 0x00bcf7,  37, -27003,  40,  37 }, /* VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID */
    { 0x014a8f, 0x012ffb, 0x012ffb,  25, -27002,  23,  25 }, /* VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED */
    { 0x0120f9, 0x014ec8, 0x014ec8,  23, -27001,  26,  23 }, /* VERR_FDT_DTB_HDR_MAGIC_INVALID */
    { 0x019e88, 0x014365, 0x014365,  24, -27000,  18,  24 }, /* VERR_FDT_DTB_MALFORMED */
    { 0x01858a, 0x01b78d, 0x01b78d,  16, -26820,  19,  16 }, /* VERR_HARDAVL_UNBALANCED */
    { 0x01bb2d, 0x01d367, 0x01d367,  13, -26819,  16,  13 }, /* VERR_HARDAVL_BAD_HEIGHT */
    { 0x016c51, 0x0134f6, 0x0134f6,  25, -26818,  21,  25 }, /* VERR_HARDAVL_LOOKUP_TOO_DEEP */
    { 0x00f476, 0x00788e, 0x00788e,  50, -26817,  30,  50 }, /* VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES */
    { 0x01835d, 0x0101ad, 0x0101ad,  29, -26816,  20,  29 }, /* VERR_HARDAVL_UNEXPECTED_NULL_RIGHT */
    { 0x018505, 0x010c50, 0x010c50,  28, -26815,  19,  28 }, /* VERR_HARDAVL_UNEXPECTED_NULL_LEFT */
    { 0x018209, 0x01a41f, 0x01a41f,  17, -26814,  20,  17 }, /* VERR_HARDAVL_BAD_NEW_HEIGHT */
    { 0x015ace, 0x01918f, 0x01918f,  19, -26813,  22,  19 }, /* VERR_HARDAVL_BAD_RIGHT_HEIGHT */
    { 0x0164b0, 0x019931, 0x019931,  18, -26812,  21,  18 }, /* VERR_HARDAVL_BAD_LEFT_HEIGHT */
    { 0x012919, 0x00c715, 0x00c715,  35, -26811,  26,  35 }, /* VERR_HARDAVL_INSERT_INVALID_KEY_RANGE */
    { 0x0151a8, 0x00ddd4, 0x00ddd4,  32, -26810,  23,  32 }, /* VERR_HARDAVL_STACK_OVERFLOW */
    { 0x016a1a, 0x010e7f, 0x010e7f,  28, -26804,  21,  28 }, /* VERR_HARDAVL_NODE_IS_FREE */
    { 0x011a40, 0x00baa7, 0x00baa7,  37, -26803,  27,  37 }, /* VERR_HARDAVL_MISALIGNED_POINTER */
    { 0x00f41c, 0x00a43f, 0x00a43f,  41, -26802,  30,  41 }, /* VERR_HARDAVL_POINTER_OUT_OF_BOUNDS */
    { 0x0106f4, 0x01428d, 0x01428d,  24, -26801,  28,  24 }, /* VERR_HARDAVL_INDEX_OUT_OF_BOUNDS */
    { 0x00ff69, 0x007044, 0x007044,  53, -26602,  29,  53 }, /* VERR_TRACELOG_READER_ITERATOR_END */
    { 0x00e034, 0x01bc7a, 0x01bc7a,  15, -26601,  32,  15 }, /* VERR_TRACELOG_READER_LOG_UNSUPPORTED */
    { 0x00f1e2, 0x016114, 0x016114,  22, -26600,  30,  22 }, /* VERR_TRACELOG_READER_MALFORMED_LOG */
    { 0x013b9a, 0x014be8, 0x014be8,  23, -26406,  25,  23 }, /* VERR_FTP_CLIENT_LIMIT_REACHED */
    { 0x01c82e, 0x01eae4, 0x01eae4,   9, -26405,  14,   9 }, /* VERR_FTP_CLIENT_NOT_FOUND */
    { 0x010a90, 0x00e0b4, 0x00e0b4,  32, -26404,  28,  32 }, /* VERR_FTP_DATA_CONN_LIMIT_REACHED */
    { 0x01aa7f, 0x019445, 0x019445,  18, -26403,  17,  18 }, /* VERR_FTP_DATA_CONN_NOT_FOUND */
    { 0x016b94, 0x019445, 0x019445,  18, -26402,  21,  18 }, /* VERR_FTP_DATA_CONN_INIT_FAILED */
    { 0x01e095, 0x0180b5, 0x0180b5,  20, -26401,  11,  20 }, /* VERR_FTP_INIT_FAILED */
    { 0x0176c9, 0x019bcb, 0x019bcb,  18, -26400,  20,  18 }, /* VERR_FTP_STATUS_SERVER_ERROR */
    { 0x01d75d, 0x007988, 0x007988,  50, -26203,  13,  50 }, /* VERR_IOQUEUE_BUSY */
    { 0x01cbd8, 0x0049b9, 0x0049b9,  68, -26202,  14,  68 }, /* VERR_IOQUEUE_EMPTY */
    { 0x01d193, 0x00a1d8, 0x00a1d8,  41, -26201,  13,  41 }, /* VERR_IOQUEUE_FULL */
    { 0x011c77, 0x00b3ec, 0x00b3ec,  38, -26200,  27,  38 }, /* VERR_IOQUEUE_HANDLE_NOT_REGISTERED */
    { 0x00ed77, 0x01179d, 0x01179d,  27, -26000,  31,  27 }, /* VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED */
    { 0x014a05, 0x009657, 0x009657,  43, -25811,  23,  43 }, /* VERR_CR_CIPHER_OSSL_SET_TAG_FAILED */
    { 0x014d41, 0x009682, 0x009682,  43, -25810,  23,  43 }, /* VERR_CR_CIPHER_OSSL_GET_TAG_FAILED */
    { 0x017c41, 0x01d9ac, 0x01d9ac,  12, -25809,  20,  12 }, /* VERR_CR_CIPHER_INVALID_TAG_LENGTH */
    { 0x00b58e, 0x00f1a6, 0x00f1a6,  30, -25808,  38,  30 }, /* VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH */
    { 0x0176f1, 0x01dd2f, 0x01dd2f,  12, -25807,  20,  12 }, /* VERR_CR_CIPHER_INVALID_KEY_LENGTH */
    { 0x0101ca, 0x019823, 0x019823,  18, -25806,  29,  18 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED */
    { 0x00f9da, 0x018480, 0x018480,  19, -25805,  30,  19 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED */
    { 0x011173, 0x01a94d, 0x01a94d,  17, -25804,  28,  17 }, /* VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED */
    { 0x00fd25, 0x01924d, 0x01924d,  18, -25803,  29,  18 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED */
    { 0x00f836, 0x0186cd, 0x0186cd,  19, -25802,  30,  19 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED */
    { 0x010bc4, 0x01a30f, 0x01a30f,  17, -25801,  28,  17 }, /* VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED */
    { 0x01e3d9, 0x01efba, 0x01efba,   8, -25800,  11,   8 }, /* VERR_CR_CIPHER_NOT_SUPPORTED */
    { 0x01962b, 0x01f4cc, 0x01f4cc,   5, -25799,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_9 */
    { 0x01959b, 0x01f508, 0x01f508,   5, -25798,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_8 */
    { 0x01951d, 0x01f4a9, 0x01f4a9,   5, -25797,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_7 */
    { 0x01952f, 0x01f4d1, 0x01f4d1,   5, -25796,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_6 */
    { 0x019541, 0x01f4d6, 0x01f4d6,   5, -25795,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_5 */
    { 0x019553, 0x01f51c, 0x01f51c,   5, -25794,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_4 */
    { 0x019589, 0x01f53a, 0x01f53a,   5, -25793,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_3 */
    { 0x019565, 0x01f4ef, 0x01f4ef,   5, -25792,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_2 */
    { 0x019577, 0x01f526, 0x01f526,   5, -25791,  18,   5 }, /* VERR_REST_INTERNAL_ERROR_1 */
    { 0x00c397, 0x01103f, 0x01103f,  28, -25713,  36,  28 }, /* VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET */
    { 0x00ca80, 0x00d3fc, 0x00d3fc,  33, -25712,  35,  33 }, /* VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET */
    { 0x0133b1, 0x018c37, 0x018c37,  19, -25711,  25,  19 }, /* VERR_REST_PATH_PARAMETER_NOT_SET */
    { 0x00bd8b, 0x01a3db, 0x01a3db,  17, -25710,  36,  17 }, /* VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL */
    { 0x00f098, 0x0188bb, 0x0188bb,  19, -25709,  30,  19 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DATE */
    { 0x00e414, 0x01bbe4, 0x01bbe4,  15, -25708,  32,  15 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_STRING */
    { 0x00dfb4, 0x0166a8, 0x0166a8,  21, -25707,  32,  21 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE */
    { 0x00d60c, 0x01571d, 0x01571d,  22, -25706,  33,  22 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER */
    { 0x00f674, 0x018a95, 0x018a95,  19, -25705,  30,  19 }, /* VERR_REST_WRONG_JSON_TYPE_FOR_BOOL */
    { 0x011407, 0x01bd88, 0x01bd88,  15, -25704,  27,  15 }, /* VERR_REST_UNABLE_TO_DECODE_DATE */
    { 0x00d025, 0x008d56, 0x008d56,  46, -25703,  34,  46 }, /* VERR_REST_RESPONSE_REPEAT_HEADER_FIELD */
    { 0x00d6d2, 0x0093f6, 0x0093f6,  44, -25702,  33,  44 }, /* VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR */
    { 0x01040d, 0x011515, 0x011515,  27, -25701,  29,  27 }, /* VERR_REST_RESPONSE_INVALID_UTF8_ENCODING */
    { 0x00f8ae, 0x009bfe, 0x009bfe,  42, -25700,  30,  42 }, /* VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED */
    { 0x0172e1, 0x009bd4, 0x009bd4,  42, -25501,  21,  42 }, /* VERR_SERIALPORT_INVALID_BAUDRATE */
    { 0x012161, 0x008be6, 0x008be6,  46, -25500,  26,  46 }, /* VERR_SERIALPORT_BREAK_DETECTED */
    { 0x01f55d, 0x01da66, 0x01da66,   6, -25395,   4,   6 }, /* VERR_ISOFS_IPE_5 */
    { 0x01f561, 0x01dbaa, 0x01dbaa,   6, -25394,   4,   6 }, /* VERR_ISOFS_IPE_4 */
    { 0x01f5b1, 0x01dd7d, 0x01dd7d,   6, -25393,   4,   6 }, /* VERR_ISOFS_IPE_3 */
    { 0x01f5b5, 0x01d96a, 0x01d96a,   6, -25392,   4,   6 }, /* VERR_ISOFS_IPE_2 */
    { 0x01f5bd, 0x01de31, 0x01de31,   6, -25391,   4,   6 }, /* VERR_ISOFS_IPE_1 */
    { 0x019979, 0x016558, 0x016558,  21, -25390,  18,  21 }, /* VERR_ISOFS_UDF_NOT_IMPLEMENTED */
    { 0x01da48, 0x01d7ec, 0x01d7ec,  13, -25345,  12,  13 }, /* VERR_ISOFS_UNKNOWN_FILE_TYPE */
    { 0x01a430, 0x01de5b, 0x01de5b,  12, -25344,  17,  12 }, /* VERR_ISOFS_WRONG_FILE_TYPE */
    { 0x01ef7a, 0x00a015, 0x00a015,  41, -25343,   8,  41 }, /* VERR_ISOFS_BAD_EXTAD */
    { 0x01c98c, 0x019db0, 0x019db0,  18, -25342,  14,  18 }, /* VERR_ISO_FS_UNKNOWN_AD_TYPE */
    { 0x01d11e, 0x01eb47, 0x01eb47,   9, -25341,  13,   9 }, /* VERR_ISOFS_BAD_FILE_ENTRY */
    { 0x01f3dd, 0x01e20b, 0x01e20b,  11, -25340,   6,  11 }, /* VERR_ISOFS_UNSUPPORTED_ICB */
    { 0x0198d7, 0x00bb16, 0x00bb16,  37, -25339,  18,  37 }, /* VERR_ISOFS_ICB_ENTRY_TOO_SMALL */
    { 0x016822, 0x017e5d, 0x017e5d,  20, -25338,  21,  20 }, /* VERR_ISOFS_TOO_DEEP_ICB_RECURSION */
    { 0x013f5d, 0x00bef3, 0x00bef3,  36, -25337,  24,  36 }, /* VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS */
    { 0x0172f6, 0x016fae, 0x016fae,  21, -25336,  21,  21 }, /* VERR_ISOFS_NO_DIRECT_ICB_ENTRIES */
    { 0x01d82c, 0x01ca88, 0x01ca88,  14, -25335,  12,  14 }, /* VERR_ISOFS_ICB_TOO_SMALL */
    { 0x01e5e0, 0x01dc64, 0x01dc64,  12, -25334,  10,  12 }, /* VERR_ISOFS_ICB_TOO_BIG */
    { 0x01a60c, 0x00e154, 0x00e154,  32, -25333,  17,  32 }, /* VERR_ISOFS_FSD_NEXT_EXTENT */
    { 0x018882, 0x009da2, 0x009da2,  42, -25332,  19,  42 }, /* VERR_ISOFS_FSD_ZERO_ROOT_DIR */
    { 0x01be00, 0x01a73e, 0x01a73e,  17, -25331,  15,  17 }, /* VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET */
    { 0x019313, 0x00ffdd, 0x00ffdd,  29, -25330,  18,  29 }, /* VERR_ISOFS_INVALID_PARTITION_INDEX */
    { 0x017485, 0x0078c0, 0x0078c0,  50, -25329,  20,  50 }, /* VERR_ISOFS_BAD_LVD_DESC_CHAR_SET */
    { 0x010139, 0x011ec9, 0x011ec9,  27, -25327,  29,  27 }, /* VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION */
    { 0x01b62d, 0x00df94, 0x00df94,  32, -25326,  16,  32 }, /* VERR_ISOFS_BAD_LVD_DOMAIN_ID */
    { 0x016b6a, 0x00d4e3, 0x00d4e3,  33, -25325,  21,  33 }, /* VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE */
    { 0x01ef3a, 0x00785c, 0x00785c,  50, -25324,   8,  50 }, /* VERR_ISOFS_MPM_NOT_SUPPORTED */
    { 0x01edd2, 0x007956, 0x007956,  50, -25323,   8,  50 }, /* VERR_ISOFS_SPM_NOT_SUPPORTED */
    { 0x01f04a, 0x007e60, 0x007e60,  49, -25322,   8,  49 }, /* VERR_ISOFS_VPM_NOT_SUPPORTED */
    { 0x0189d8, 0x0078f2, 0x0078f2,  50, -25321,  19,  50 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID */
    { 0x0160e8, 0x016693, 0x016693,  21, -25320,  22,  21 }, /* VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE */
    { 0x0116e0, 0x00c29b, 0x00c29b,  36, -25319,  27,  36 }, /* VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE */
    { 0x01c8ba, 0x009f46, 0x009f46,  42, -25318,  14,  42 }, /* VERR_ISOFS_PARTITION_NOT_FOUND */
    { 0x012217, 0x00866f, 0x00866f,  47, -25317,  26,  47 }, /* VERR_ISOFS_MALFORMED_PART_MAP_TABLE */
    { 0x01a7f9, 0x00ac3a, 0x00ac3a,  39, -25316,  17,  39 }, /* VERR_ISOFS_TOO_MANY_PART_MAPS */
    { 0x01c355, 0x006ba0, 0x006ba0,  55, -25315,  15,  55 }, /* VERR_ISOFS_MULTIPLE_LVDS */
    { 0x01c1c0, 0x006a56, 0x006a56,  55, -25314,  15,  55 }, /* VERR_ISOFS_MULTIPLE_PVDS */
    { 0x01f517, 0x0143f5, 0x0143f5,  24, -25313,   5,  24 }, /* VERR_ISOFS_NO_PD */
    { 0x01f49d, 0x014a1c, 0x014a1c,  23, -25312,   6,  23 }, /* VERR_ISOFS_NO_LVD */
    { 0x01f3fb, 0x0153d0, 0x0153d0,  23, -25311,   6,  23 }, /* VERR_ISOFS_NO_PVD */
    { 0x016c66, 0x00d8e2, 0x00d8e2,  33, -25310,  21,  33 }, /* VERR_ISOFS_TOO_BIT_PARTMAP_IN_LVD */
    { 0x01e50d, 0x0145d5, 0x0145d5,  24, -25309,  11,  24 }, /* VERR_ISOFS_TOO_MANY_PDS */
    { 0x01df3f, 0x01532f, 0x01532f,  23, -25308,  12,  23 }, /* VERR_ISOFS_TOO_MANY_LVDS */
    { 0x01da6c, 0x014d2a, 0x014d2a,  23, -25307,  12,  23 }, /* VERR_ISOFS_TOO_MANY_PVDS */
    { 0x01e150, 0x00c32b, 0x00c32b,  36, -25306,  11,  36 }, /* VERR_ISOFS_UNEXPECTED_VDS_DESC */
    { 0x00dc54, 0x0124d5, 0x0124d5,  26, -25305,  32,  26 }, /* VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC */
    { 0x01de43, 0x014815, 0x014815,  24, -25304,  12,  24 }, /* VERR_ISOFS_DESC_CRC_MISMATCH */
    { 0x01cd0c, 0x00e4b4, 0x00e4b4,  32, -25303,  14,  32 }, /* VERR_ISOFS_TAG_SECTOR_MISMATCH */
    { 0x01bfa4, 0x01c409, 0x01c409,  15, -25302,  15,  15 }, /* VERR_ISOFS_BAD_TAG_CHECKSUM */
    { 0x01ca6c, 0x01cd36, 0x01cd36,  14, -25301,  14,  14 }, /* VERR_ISOFS_UNSUPPORTED_TAG_VERSION */
    { 0x01a1e8, 0x012301, 0x012301,  26, -25300,  18,  26 }, /* VERR_ISOFS_TAG_IS_ALL_ZEROS */
    { 0x00ce27, 0x003e92, 0x003e92,  76, -25157,  34,  76 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS */
    { 0x00aaaf, 0x0036c4, 0x0036c4,  84, -25156,  40,  84 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE */
    { 0x00c873, 0x0039ad, 0x0039ad,  81, -25155,  35,  81 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR */
    { 0x00bc88, 0x0052e7, 0x0052e7,  63, -25154,  37,  63 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS */
    { 0x0136d1, 0x003bde, 0x003bde,  78, -25153,  25,  78 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID */
    { 0x00e804, 0x008d84, 0x008d84,  45, -25152,  31,  45 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND */
    { 0x00db13, 0x004b0d, 0x004b0d,  68, -25151,  33,  68 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG */
    { 0x00fd08, 0x00923e, 0x00923e,  44, -25150,  29,  44 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE */
    { 0x00b80d, 0x00564c, 0x00564c,  61, -25149,  37,  61 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS */
    { 0x00c738, 0x00a3c4, 0x00a3c4,  41, -25148,  35,  41 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD */
    { 0x00e861, 0x00abc5, 0x00abc5,  39, -25147,  31,  39 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG */
    { 0x011253, 0x00acfd, 0x00acfd,  39, -25146,  28,  39 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS */
    { 0x010860, 0x00ae83, 0x00ae83,  39, -25145,  28,  39 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE */
    { 0x01621c, 0x010a74, 0x010a74,  28, -25144,  22,  28 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID */
    { 0x00de14, 0x0076c8, 0x0076c8,  51, -25143,  32,  51 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM */
    { 0x0109e8, 0x008b8a, 0x008b8a,  46, -25142,  28,  46 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS */
    { 0x00d41d, 0x0076fb, 0x0076fb,  51, -25141,  33,  51 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID */
    { 0x01224b, 0x00bb60, 0x00bb60,  37, -25140,  26,  37 }, /* VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS */
    { 0x00f944, 0x006c0e, 0x006c0e,  55, -25133,  30,  55 }, /* VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT */
    { 0x012a03, 0x0053a3, 0x0053a3,  62, -25132,  26,  62 }, /* VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT */
    { 0x00e671, 0x0048a9, 0x0048a9,  68, -25131,  31,  68 }, /* VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC */
    { 0x0146dd, 0x008930, 0x008930,  47, -25130,  24,  47 }, /* VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS */
    { 0x0118ab, 0x00ac88, 0x00be63,  36, -25129,  20,   8 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME */
    { 0x0118ab, 0x00ac88, 0x00ac88,  39, -25128,  27,   8 }, /* VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH */
    { 0x01a04a, 0x01111f, 0x01111f,  28, -25127,  18,  28 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH */
    { 0x00eb49, 0x00f458, 0x00f458,  30, -25126,  31,  30 }, /* VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS */
    { 0x014785, 0x008a76, 0x008a76,  46, -25125,  24,  46 }, /* VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO */
    { 0x01a04a, 0x0198a1, 0x0198a1,  18, -25124,  11,  18 }, /* VERR_ISOMK_IMPORT_BAD_DIR_REC */
    { 0x01a7d7, 0x01667e, 0x01667e,  21, -25123,  17,  21 }, /* VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE */
    { 0x0113ec, 0x00f926, 0x00f926,  30, -25122,  27,  30 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT */
    { 0x0108d0, 0x00eb2a, 0x00eb2a,  31, -25121,  28,  31 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG */
    { 0x01566b, 0x00d399, 0x00d399,  33, -25120,  23,  33 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH */
    { 0x00e334, 0x00d311, 0x00d311,  34, -25119,  32,  34 }, /* VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS */
    { 0x017389, 0x009372, 0x009372,  44, -25118,  21,  44 }, /* VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO */
    { 0x015c5a, 0x00dd94, 0x00dd94,  32, -25117,  22,  32 }, /* VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR */
    { 0x01566b, 0x015038, 0x015038,  23, -25116,  16,  23 }, /* VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC */
    { 0x019fde, 0x005365, 0x005365,  62, -25115,  18,  62 }, /* VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH */
    { 0x015fe0, 0x004f2d, 0x004f2d,  64, -25114,  22,  64 }, /* VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH */
    { 0x019f84, 0x012113, 0x012113,  26, -25113,  18,  26 }, /* VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO */
    { 0x00f6ce, 0x01aebf, 0x01aebf,  17, -25112,  30,  17 }, /* VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET */
    { 0x012a85, 0x00a9bf, 0x00a9bf,  40, -25111,  26,  40 }, /* VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB */
    { 0x01d3c2, 0x00becf, 0x00becf,  36, -25110,  13,  36 }, /* VERR_ISOMK_IMPORT_BAD_SUP_VOL_DESC */
    { 0x01684c, 0x00a320, 0x00a320,  41, -25109,  21,  41 }, /* VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER */
    { 0x018349, 0x00f908, 0x00f908,  30, -25108,  20,  30 }, /* VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC */
    { 0x010e63, 0x00c8ff, 0x00c8ff,  35, -25107,  28,  35 }, /* VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER */
    { 0x00e8dd, 0x007761, 0x007761,  51, -25106,  31,  51 }, /* VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY */
    { 0x0110e7, 0x00d64e, 0x00d64e,  33, -25105,  28,  33 }, /* VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS */
    { 0x011a76, 0x00c6cf, 0x00c6cf,  35, -25104,  27,  35 }, /* VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS */
    { 0x01023e, 0x00cdc1, 0x00cdc1,  34, -25103,  29,  34 }, /* VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS */
    { 0x01b95d, 0x01d0ea, 0x01d0ea,  13, -25102,  16,  13 }, /* VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR */
    { 0x0194d5, 0x010e47, 0x010e47,  28, -25101,  18,  28 }, /* VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS */
    { 0x01e54a, 0x010156, 0x010156,  29, -25100,  10,  29 }, /* VERR_ISOMK_IMPORT_UNKNOWN_FORMAT */
    { 0x017d95, 0x00fe2a, 0x00fe2a,  29, -25029,  20,  29 }, /* VERR_ISOMK_RR_SPILL_FILE_FULL */
    { 0x01d12b, 0x00ceaf, 0x00ceaf,  34, -25028,  13,  34 }, /* VERR_ISOMK_IPE_FINALIZE_1 */
    { 0x0185e9, 0x0114a9, 0x0114a9,  27, -25027,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_3 */
    { 0x018752, 0x0116fb, 0x0116fb,  27, -25026,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_2 */
    { 0x01860f, 0x011e78, 0x011e78,  27, -25025,  19,  27 }, /* VERR_ISOMK_IPE_READ_FILE_DATA_1 */
    { 0x01768d, 0x008288, 0x008288,  48, -25024,  20,  39 }, /* VERR_ISOMK_IPE_PRODUCE_TRANS_TBL */
    { 0x01b20d, 0x00e4d4, 0x00e4d4,  32, -25023,  16,  32 }, /* VERR_ISOMK_IPE_BOOT_CAT_FILE */
    { 0x01cb30, 0x015733, 0x015733,  22, -25022,  14,  22 }, /* VERR_ISOMK_IPE_BUFFER_SIZE */
    { 0x01d04e, 0x00d987, 0x00d987,  33, -25021,  13,  33 }, /* VERR_ISOMK_IPE_DESC_COUNT */
    { 0x01d3dc, 0x00ef67, 0x00ef67,  31, -25020,  13,  31 }, /* VERR_ISOMK_IPE_ROOT_SLASH */
    { 0x019e52, 0x011ac7, 0x011ac7,  27, -25019,  18,  27 }, /* VERR_ISOMK_IPE_EMPTY_COMPONENT */
    { 0x01d736, 0x017374, 0x017374,  21, -25018,  13,  21 }, /* VERR_ISOMK_IPE_EMPTY_PATH */
    { 0x01ccb8, 0x00e880, 0x00e880,  31, -25017,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_6 */
    { 0x01cc64, 0x00e91b, 0x00e91b,  31, -25016,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_5 */
    { 0x01cc72, 0x00ed1a, 0x00ed1a,  31, -25015,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_4 */
    { 0x01cc8e, 0x00ee8e, 0x00ee8e,  31, -25014,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_3 */
    { 0x01cc80, 0x00ee50, 0x00ee50,  31, -25013,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_2 */
    { 0x01ccaa, 0x00eb0b, 0x00eb0b,  31, -25012,  14,  31 }, /* VERR_ISOMK_IPE_NAMESPACE_1 */
    { 0x01ef0a, 0x00e454, 0x00e454,  32, -25011,   8,  32 }, /* VERR_ISOMK_IPE_TABLE */
    { 0x01e9b4, 0x00d179, 0x00d179,  34, -25010,  10,  34 }, /* VERR_ISOMK_IPE_RR_READ */
    { 0x0197ed, 0x00d223, 0x00d223,  34, -25009,  18,  34 }, /* VERR_ISOMK_RR_NO_SPACE_FOR_CE */
    { 0x012b6f, 0x006dbf, 0x006dbf,  54, -25008,  26,  54 }, /* VERR_ISOMK_SYMLINK_SUPPORT_DISABLED */
    { 0x013ced, 0x005d0c, 0x005d0c,  59, -25007,  24,  59 }, /* VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x01398d, 0x006273, 0x006273,  57, -25006,  25,  57 }, /* VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3 */
    { 0x013d05, 0x013ddd, 0x013ddd,  24, -25005,  24,  24 }, /* VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY */
    { 0x014395, 0x00d756, 0x00d756,  33, -25004,  24,  33 }, /* VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE */
    { 0x016038, 0x014bff, 0x014bff,  23, -25003,  22,  23 }, /* VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY */
    { 0x00ce49, 0x01f5c7, 0x01f5c7,   3, -25002,  34,   3 }, /* VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER */
    { 0x013046, 0x01329e, 0x01329e,  25, -25001,  25,  25 }, /* VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY */
    { 0x01087c, 0x01128b, 0x01128b,  28, -25000,  28,  28 }, /* VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY */
    { 0x01c5cb, 0x008c9e, 0x008c9e,  46, -24804,  15,  46 }, /* VERR_VFS_UNSUPPORTED_CREATE_TYPE */
    { 0x01e86a, 0x01b39d, 0x01b39d,  16, -24803,  10,  16 }, /* VERR_VFS_UNSUPPORTED_FORMAT */
    { 0x01c0fd, 0x00fac4, 0x00fac4,  29, -24802,  15,  29 }, /* VERR_VFS_BOGUS_OFFSET */
    { 0x01c184, 0x00fe9e, 0x00fe9e,  29, -24801,  15,  29 }, /* VERR_VFS_BOGUS_FORMAT */
    { 0x01e90a, 0x01b52d, 0x01b52d,  16, -24800,  10,  16 }, /* VERR_VFS_UNKNOWN_FORMAT */
    { 0x01b94d, 0x01e468, 0x01e468,  11, -24707,  16,  11 }, /* VERR_JSON_INVALID_CODEPOINT */
    { 0x00f7a0, 0x00e3f4, 0x00e3f4,  32, -24706,  30,  32 }, /* VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE */
    { 0x01064c, 0x00f6b0, 0x00f6b0,  30, -24705,  28,  30 }, /* VERR_JSON_MISSING_SURROGATE_PAIR */
    { 0x010898, 0x013e0d, 0x013e0d,  24, -24704,  28,  24 }, /* VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE */
    { 0x01cb84, 0x01741c, 0x01741c,  21, -24703,  14,  21 }, /* VERR_JSON_IS_EMPTY */
    { 0x01bf1d, 0x01294d, 0x01294d,  26, -24702,  15,  26 }, /* VERR_JSON_MALFORMED */
    { 0x0193b5, 0x014a33, 0x014a33,  23, -24701,  18,  23 }, /* VERR_JSON_ITERATOR_END */
    { 0x01a70b, 0x00a82f, 0x00a82f,  40, -24700,  17,  40 }, /* VERR_JSON_VALUE_INVALID_TYPE */
    { 0x01a7b5, 0x011716, 0x011716,  27, -24610,  17,  27 }, /* VERR_URI_NOT_FILE_SCHEME */
    { 0x00cbde, 0x0057f4, 0x0057f4,  60, -24609,  35,  60 }, /* VERR_URI_MISSING_UTF8_CONTINUATION_BYTE */
    { 0x00bfcb, 0x005e69, 0x005e69,  58, -24608,  36,  58 }, /* VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE */
    { 0x0105c0, 0x008498, 0x008498,  48, -24607,  28,  48 }, /* VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE */
    { 0x00f566, 0x008dde, 0x008dde,  45, -24606,  30,  45 }, /* VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8 */
    { 0x01a4c9, 0x0074f9, 0x0074f9,  52, -24605,  17,  52 }, /* VERR_URI_ESCAPED_ZERO */
    { 0x01baed, 0x01ac4a, 0x01ac4a,  17, -24604,  16,  17 }, /* VERR_URI_INVALID_ESCAPE_SEQ */
    { 0x01aaf6, 0x01d444, 0x01d444,  13, -24603,  17,  13 }, /* VERR_URI_INVALID_PORT_NUMBER */
    { 0x01dc10, 0x01f12a, 0x01f12a,   8, -24602,  12,   8 }, /* VERR_URI_INVALID_SCHEME */
    { 0x01e4ec, 0x011afd, 0x011afd,  27, -24601,  11,  27 }, /* VERR_URI_TOO_SHORT */
    { 0x01e89c, 0x01def7, 0x01def7,  12, -24600,  10,  12 }, /* VERR_URI_EMPTY */
    { 0x01616c, 0x00e769, 0x00e769,  31, -24403,  22,  31 }, /* VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS */
    { 0x00e174, 0x0082b8, 0x0082b8,  48, -24402,  32,  48 }, /* VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED */
    { 0x0170e9, 0x01c5e9, 0x01c5e9,  15, -24400,  21,  15 }, /* VERR_PATH_MATCH_UNKNOWN_VARIABLE */
    { 0x015a4b, 0x00b224, 0x00b224,  38, -24399,  22,  38 }, /* VERR_CR_MALFORMED_PEM_HEADER */
    { 0x01e8ce, 0x00875a, 0x00875a,  47, -24398,  10,  47 }, /* VERR_CR_RANDOM_FAILED */
    { 0x01b59d, 0x00875a, 0x00875a,  47, -24397,  16,  47 }, /* VERR_CR_RANDOM_SETUP_FAILED */
    { 0x00f782, 0x01037c, 0x01037c,  29, -24396,  30,  29 }, /* VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED */
    { 0x01596f, 0x0103f0, 0x0103f0,  29, -24395,  22,  29 }, /* VERR_CR_OPENSSL_VERSION_TOO_OLD */
    { 0x01e334, 0x0155b3, 0x0155b3,  23, -24205,  11,  23 }, /* VERR_CR_DIGEST_NOT_SUPPORTED */
    { 0x00fe81, 0x010b00, 0x010b00,  28, -24204,  29,  28 }, /* VERR_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x017e71, 0x01852b, 0x01852b,  19, -24203,  20,  19 }, /* VERR_CR_DIGEST_COMPROMISED */
    { 0x018940, 0x019c25, 0x019c25,  18, -24202,  19,  18 }, /* VERR_CR_DIGEST_DEPRECATED */
    { 0x00eacd, 0x0117d3, 0x0117d3,  27, -24201,  31,  27 }, /* VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR */
    { 0x011b69, 0x00dd54, 0x00dd54,  32, -24200,  27,  32 }, /* VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR */
    { 0x012f97, 0x008fa0, 0x008fa0,  45, -24002,  25,  45 }, /* VERR_BIGNUM_NEGATIVE_EXPONENT */
    { 0x01879e, 0x015eee, 0x015eee,  22, -24001,  19,  22 }, /* VERR_BIGNUM_DIV_BY_ZERO */
    { 0x0151ed, 0x005326, 0x005326,  63, -24000,  23,  63 }, /* VERR_BIGNUM_SENSITIVE_INPUT */
    { 0x01c364, 0x01f36b, 0x01f36b,   6, -23900,  15,   6 }, /* VERR_CR_RSA_GENERIC_ERROR */
    { 0x01866e, 0x00fb38, 0x00fb38,  29, -23819,  19,  29 }, /* VERR_CR_KEY_ALGO_PARAMS_MISMATCH */
    { 0x013398, 0x00b910, 0x00b910,  37, -23818,  25,  37 }, /* VERR_CR_KEY_ALGO_PARAMS_UNKNOWN */
    { 0x013942, 0x00a1af, 0x00a1af,  41, -23817,  25,  41 }, /* VERR_CR_KEY_ALGO_PARAMS_MISSING */
    { 0x010cf8, 0x0122e7, 0x0122e7,  26, -23816,  28,  26 }, /* VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED */
    { 0x01bf0e, 0x018cbc, 0x018cbc,  19, -23815,  15,  19 }, /* VERR_CR_KEY_GEN_FAILED_RSA */
    { 0x019bb9, 0x0066a5, 0x0066a5,  56, -23813,  18,  56 }, /* VERR_CR_KEY_DECRYPTION_FAILED */
    { 0x013a87, 0x01772d, 0x01772d,  20, -23812,  25,  20 }, /* VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR */
    { 0x015107, 0x00c403, 0x00c403,  36, -23811,  23,  36 }, /* VERR_CR_KEY_PASSWORD_ENCODING */
    { 0x013492, 0x006fda, 0x006fda,  53, -23810,  25,  53 }, /* VERR_CR_KEY_MALFORMED_CIPHER_IV */
    { 0x015f30, 0x007289, 0x007289,  52, -23809,  22,  52 }, /* VERR_CR_KEY_TOO_SHORT_CIPHER_IV */
    { 0x01159c, 0x00aa0f, 0x00aa0f,  40, -23808,  27,  40 }, /* VERR_CR_KEY_MISSING_CIPHER_PARAMS */
    { 0x018335, 0x007ab4, 0x007ab4,  50, -23807,  20,  50 }, /* VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS */
    { 0x01d68d, 0x015094, 0x015094,  23, -23806,  13,  23 }, /* VERR_CR_KEY_UNSUPPORTED_CIPHER */
    { 0x0191b5, 0x019f2a, 0x019f2a,  18, -23805,  19,  18 }, /* VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED */
    { 0x0181f5, 0x00c0a3, 0x00c0a3,  36, -23804,  20,  36 }, /* VERR_CR_KEY_DEK_INFO_TOO_LONG */
    { 0x01bdf1, 0x00512d, 0x00512d,  64, -23803,  15,  64 }, /* VERR_CR_KEY_NO_DEK_INFO */
    { 0x01bfd1, 0x00cc24, 0x00cc24,  35, -23802,  15,  35 }, /* VERR_CR_KEY_ENCRYPTED */
    { 0x01c319, 0x01d9b8, 0x01d9b8,  12, -23801,  15,  12 }, /* VERR_CR_KEY_FORMAT_NOT_SUPPORTED */
    { 0x01dffb, 0x011473, 0x011473,  27, -23800,  11,  27 }, /* VERR_CR_KEY_UNKNOWN_TYPE */
    { 0x01aee1, 0x01ee6a, 0x01ee6a,   8, -23700,  17,   8 }, /* VERR_CR_STORE_GENERIC_ERROR */
    { 0x010ed3, 0x00d7da, 0x00d7da,  33, -23527,  28,  33 }, /* VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED */
    { 0x013ee5, 0x019f3c, 0x019f3c,  18, -23526,  24,  18 }, /* VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY */
    { 0x012eb6, 0x0186a7, 0x0186a7,  19, -23525,  25,  19 }, /* VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY */
    { 0x015e3e, 0x01b18d, 0x01b18d,  16, -23524,  22,  16 }, /* VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY */
    { 0x014f69, 0x01a6b6, 0x01a6b6,  17, -23523,  23,  17 }, /* VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY */
    { 0x00d135, 0x00b7c3, 0x00b7c3,  37, -23522,  29,  37 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE */
    { 0x00d135, 0x009b02, 0x009b02,  42, -23521,  34,  42 }, /* VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE */
    { 0x014485, 0x01079c, 0x01079c,  28, -23520,  24,  28 }, /* VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED */
    { 0x00f2b4, 0x009162, 0x009162,  44, -23519,  30,  44 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR */
    { 0x0104d8, 0x00f3fe, 0x00f3fe,  30, -23518,  29,  30 }, /* VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED */
    { 0x011674, 0x013aeb, 0x013aeb,  25, -23517,  27,  25 }, /* VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR */
    { 0x0110cb, 0x010051, 0x010051,  29, -23516,  28,  29 }, /* VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED */
    { 0x01253d, 0x016a05, 0x016a05,  21, -23515,  26,  21 }, /* VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED */
    { 0x00f0f2, 0x00c44b, 0x00c44b,  36, -23514,  30,  36 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED */
    { 0x00ccd3, 0x00b484, 0x00b484,  38, -23513,  34,  38 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP */
    { 0x00ccd3, 0x00f7fa, 0x00f7fa,  30, -23512,  30,  30 }, /* VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN */
    { 0x013415, 0x017921, 0x017921,  20, -23511,  25,  20 }, /* VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN */
    { 0x00e7a7, 0x00a4ba, 0x00a4ba,  41, -23510,  31,  41 }, /* VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL */
    { 0x019d20, 0x00f548, 0x00f548,  30, -23509,  18,  30 }, /* VERR_CR_PKIX_SIGNATURE_MISMATCH */
    { 0x01470d, 0x01964f, 0x01964f,  18, -23508,  24,  18 }, /* VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH */
    { 0x013285, 0x016b55, 0x016b55,  21, -23507,  25,  21 }, /* VERR_CR_PKIX_SIGNATURE_NEGATIVE */
    { 0x014e83, 0x00b270, 0x00b270,  38, -23506,  23,  38 }, /* VERR_CR_PKIX_SIGNATURE_GE_KEY */
    { 0x015afa, 0x00c9d1, 0x00c9d1,  35, -23505,  22,  35 }, /* VERR_CR_PKIX_SIGNATURE_TOO_LONG */
    { 0x0138ac, 0x0095ab, 0x0095ab,  43, -23504,  25,  43 }, /* VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY */
    { 0x01ad27, 0x01f5e2, 0x01f5e2,   2, -23503,  17,   2 }, /* VERR_CR_PKIX_INTERNAL_ERROR */
    { 0x018b1a, 0x01dbc8, 0x01dbc8,  12, -23502,  19,  12 }, /* VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE */
    { 0x00cf15, 0x006c45, 0x006c45,  54, -23501,  34,  54 }, /* VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS */
    { 0x01b36d, 0x01e5a4, 0x01e5a4,  10, -23500,  16,  10 }, /* VERR_CR_PKIX_GENERIC_ERROR */
    { 0x0161f0, 0x00cc01, 0x00cc01,  35, -23416,  22,  35 }, /* VERR_CR_SPC_PEIMAGE_NO_CONTENT */
    { 0x01126f, 0x017a39, 0x017a39,  20, -23415,  28,  20 }, /* VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED */
    { 0x01431d, 0x018ae1, 0x018ae1,  19, -23414,  24,  19 }, /* VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE */
    { 0x00e5d4, 0x01246d, 0x01246d,  26, -23413,  32,  26 }, /* VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS */
    { 0x018e97, 0x013816, 0x013816,  25, -23412,  19,  25 }, /* VERR_CR_SPC_MONIKER_BAD_DATA */
    { 0x01652e, 0x0147e5, 0x0147e5,  24, -23411,  21,  24 }, /* VERR_CR_SPC_BAD_MONIKER_CHOICE */
    { 0x01859d, 0x018f42, 0x018f42,  19, -23410,  19,  19 }, /* VERR_CR_SPC_UNKNOWN_MONIKER_UUID */
    { 0x01886f, 0x013799, 0x013799,  25, -23409,  19,  25 }, /* VERR_CR_SPC_BAD_MONIKER_UUID */
    { 0x011b9f, 0x017080, 0x017080,  21, -23408,  27,  21 }, /* VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT */
    { 0x010da0, 0x00f764, 0x00f764,  30, -23407,  28,  30 }, /* VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA */
    { 0x0105f8, 0x010b70, 0x010b70,  28, -23406,  28,  28 }, /* VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH */
    { 0x0193eb, 0x01bf77, 0x01bf77,  15, -23405,  18,  15 }, /* VERR_CR_SPC_UNKNOWN_DIGEST_ALGO */
    { 0x009601, 0x00516d, 0x00516d,  63, -23404,  43,  63 }, /* VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS */
    { 0x00cb98, 0x00a78f, 0x00a78f,  40, -23403,  35,  40 }, /* VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH */
    { 0x00f200, 0x004ce2, 0x004ce2,  66, -23402,  30,  66 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO */
    { 0x00eeeb, 0x0079ba, 0x0079ba,  50, -23401,  31,  50 }, /* VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS */
    { 0x01c10c, 0x01f449, 0x01f449,   6, -23400,  15,   6 }, /* VERR_CR_SPC_GENERIC_ERROR */
    { 0x00dbd4, 0x01df63, 0x01df63,  12, -23310,  32,  12 }, /* VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED */
    { 0x00f3e0, 0x0060ab, 0x0060ab,  57, -23309,  30,  57 }, /* VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB */
    { 0x00eead, 0x00682d, 0x00682d,  56, -23308,  31,  56 }, /* VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH */
    { 0x00bd66, 0x004a41, 0x004a41,  68, -23307,  37,  68 }, /* VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB */
    { 0x010b1c, 0x0060e4, 0x0060e4,  57, -23306,  28,  57 }, /* VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB */
    { 0x010221, 0x006357, 0x006357,  57, -23305,  29,  57 }, /* VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH */
    { 0x00c9ae, 0x004865, 0x004865,  68, -23304,  35,  68 }, /* VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB */
    { 0x01878b, 0x00de34, 0x00de34,  32, -23303,  19,  32 }, /* VERR_CR_PKCS7_KEY_USAGE_MISMATCH */
    { 0x0115d2, 0x01e263, 0x01e263,  11, -23302,  27,  11 }, /* VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND */
    { 0x0171a6, 0x00af1f, 0x00af1f,  39, -23301,  21,  39 }, /* VERR_CR_PKCS7_NO_SIGNER_INFOS */
    { 0x01a463, 0x01e5a4, 0x01e5a4,  10, -23300,  17,  10 }, /* VERR_CR_PKCS7_GENERIC_ERROR */
    { 0x00fc94, 0x00defc, 0x00defc,  24, -23109,  29,  24 }, /* VERR_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x00b1b2, 0x01ee0a, 0x01ee0a,   8, -23108,  38,   8 }, /* VERR_X509_CERTIFICATE_VERIFICATION_FAILURE */
    { 0x011007, 0x014ba3, 0x014ba3,  23, -23107,  28,  23 }, /* VERR_X509_PRINT_EXTENSION_TO_BIO */
    { 0x00d83d, 0x010908, 0x010908,  28, -23106,  33,  28 }, /* VERR_X509_GETTING_DATA_FROM_EXTENSION */
    { 0x00d62d, 0x00b5da, 0x00b5da,  38, -23105,  33,  38 }, /* VERR_X509_GETTING_EXTENSION_FROM_CERT */
    { 0x012fe2, 0x012fc9, 0x012fc9,  25, -23104,  25,  25 }, /* VERR_X509_NO_BASIC_CONSTARAINTS */
    { 0x00f9bc, 0x01df63, 0x01df63,  12, -23103,  30,  12 }, /* VERR_X509_RSA_VERIFICATION_FUILURE */
    { 0x00d8a0, 0x00d85e, 0x00d85e,  33, -23102,  33,  33 }, /* VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY */
    { 0x00f872, 0x009580, 0x009580,  43, -23101,  30,  43 }, /* VERR_X509_EXTRACT_PUBKEY_FROM_CERT */
    { 0x011968, 0x00d45f, 0x00d45f,  33, -23100,  27,  33 }, /* VERR_X509_READING_CERT_FROM_BIO */
    { 0x01a91a, 0x01a110, 0x01a110,  18, -23090,  17,  18 }, /* VERR_CR_X509_OSSL_D2I_FAILED */
    { 0x017c69, 0x013b04, 0x013b04,  25, -23037,  20,  25 }, /* VERR_CR_X509_CPB_BAD_CERT_CTX */
    { 0x00beab, 0x0065fd, 0x0065fd,  56, -23036,  36,  56 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX */
    { 0x00c4ff, 0x0065c5, 0x0065c5,  56, -23035,  36,  56 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN */
    { 0x00b0f3, 0x006d53, 0x006d53,  54, -23034,  39,  54 }, /* VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE */
    { 0x01371c, 0x015585, 0x015585,  23, -23033,  25,  23 }, /* VERR_CR_X509_CPV_NOT_VALID_AT_TIME */
    { 0x01923a, 0x007b18, 0x007b18,  50, -23032,  19,  50 }, /* VERR_CR_X509_CPV_ISSUER_MISMATCH */
    { 0x00f0b6, 0x007ec2, 0x007ec2,  49, -23031,  30,  49 }, /* VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED */
    { 0x012a37, 0x00bbf4, 0x00bbf4,  37, -23030,  26,  37 }, /* VERR_CR_X509_CPV_NAME_NOT_PERMITTED */
    { 0x011365, 0x00cb75, 0x00cb75,  35, -23029,  27,  35 }, /* VERR_CR_X509_CPV_NO_PERMITTED_NAMES */
    { 0x012369, 0x00dc14, 0x00dc14,  32, -23028,  26,  32 }, /* VERR_CR_X509_CPV_INVALID_POLICY_MAPPING */
    { 0x0186f3, 0x00c373, 0x00c373,  36, -23027,  19,  36 }, /* VERR_CR_X509_CPV_NOT_V3_CERT */
    { 0x018907, 0x0088d2, 0x0088d2,  47, -23026,  19,  47 }, /* VERR_CR_X509_CPV_NOT_CA_CERT */
    { 0x012bf1, 0x007bae, 0x007bae,  50, -23025,  26,  50 }, /* VERR_CR_X509_CPV_MAX_PATH_LENGTH */
    { 0x00e314, 0x00782a, 0x00782a,  50, -23024,  32,  50 }, /* VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN */
    { 0x00f5a2, 0x014845, 0x014845,  24, -23023,  30,  24 }, /* VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION */
    { 0x013fd5, 0x019dc2, 0x019dc2,  18, -23022,  24,  18 }, /* VERR_CR_X509_CPV_NO_VALID_POLICY */
    { 0x013703, 0x0187c4, 0x0187c4,  19, -23021,  25,  19 }, /* VERR_CR_X509_CPV_NO_TRUSTED_PATHS */
    { 0x00da8f, 0x009e4a, 0x009e4a,  42, -23020,  33,  42 }, /* VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY */
    { 0x00ced1, 0x016ad7, 0x016ad7,  21, -23019,  34,  21 }, /* VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION */
    { 0x014b30, 0x0044dd, 0x0044dd,  70, -23018,  23,  32 }, /* VERR_CR_X509_VALIDITY_SWAPPED */
    { 0x013b4f, 0x00d3ba, 0x00d3ba,  33, -23017,  25,  24 }, /* VERR_CR_X509_NAME_EMPTY_SUB_SET */
    { 0x016ac2, 0x0110af, 0x0110af,  28, -23016,  21,  19 }, /* VERR_CR_X509_NAME_EMPTY_SET */
    { 0x018f68, 0x011b4e, 0x011b4e,  27, -23015,  19,  15 }, /* VERR_CR_X509_NAME_NOT_STRING */
    { 0x013c75, 0x0162b6, 0x0162b6,  22, -23014,  24,  10 }, /* VERR_CR_X509_NAME_EMPTY_STRING */
    { 0x015529, 0x0154b6, 0x0154b6,  23, -23013,  23,  11 }, /* VERR_CR_X509_INVALID_NAME_STRING_TAG */
    { 0x013d4d, 0x0190e4, 0x0190e4,  19, -23012,  24,  19 }, /* VERR_CR_X509_PUBLIC_KEY_TOO_SMALL */
    { 0x014edf, 0x01b7ed, 0x01b7ed,  16, -23011,  23,   3 }, /* VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION */
    { 0x009b2c, 0x010512, 0x010512,  29, -23010,  42,  29 }, /* VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS */
    { 0x00e394, 0x00ad99, 0x00ad99,  39, -23009,  32,  39 }, /* VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2 */
    { 0x012077, 0x00dcf4, 0x00dcf4,  32, -23008,  26,  32 }, /* VERR_CR_X509_TBSCERT_EXTS_REQ_V3 */
    { 0x011c0b, 0x004fad, 0x004fad,  64, -23007,  27,  64 }, /* VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH */
    { 0x014c44, 0x017470, 0x017470,  21, -23006,  23,  21 }, /* VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH */
    { 0x0156f1, 0x010684, 0x010684,  28, -23005,  22,   3 }, /* VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO */
    { 0x0175c5, 0x01991f, 0x01991f,  18, -23004,  20,  18 }, /* VERR_CR_X509_NO_TRUST_ANCHOR */
    { 0x01b0ad, 0x01898c, 0x01898c,  19, -23003,  16,  19 }, /* VERR_CR_X509_NOT_VERIFIED */
    { 0x01200d, 0x014515, 0x014515,  24, -23002,  27,   6 }, /* VERR_CR_X509_CERTPATHS_INTERNAL_ERROR */
    { 0x01af8b, 0x014515, 0x01e2fd,  11, -23001,  17,   6 }, /* VERR_CR_X509_INTERNAL_ERROR */
    { 0x01b45d, 0x01ef6a, 0x01ef6a,   8, -23000,  16,   3 }, /* VERR_CR_X509_GENERIC_ERROR */
    { 0x00fc20, 0x010204, 0x010204,  29, -22992,  29,  29 }, /* VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS */
    { 0x019e0a, 0x00f8cc, 0x00f8cc,  30, -22991,  18,  30 }, /* VERR_LDRLX_NRICHAIN_NOT_SUPPORTED */
    { 0x01a6a5, 0x01a7a4, 0x01a7a4,  17, -22990,  17,  17 }, /* VERR_LDRLX_BAD_FORWARDER */
    { 0x01c652, 0x01f072, 0x01f072,   8, -22989,  14,   8 }, /* VERR_LDRLX_BAD_SONAME */
    { 0x01c84a, 0x01f0c2, 0x01f0c2,   8, -22988,  14,   8 }, /* VERR_LDRLX_NO_SONAME */
    { 0x01cc2c, 0x01d263, 0x01d263,  13, -22987,  14,  13 }, /* VERR_LDRLX_BAD_BUNDLE */
    { 0x01a683, 0x0112f9, 0x0112f9,  27, -22986,  17,  27 }, /* VERR_LDRLX_BAD_ITERDATA2 */
    { 0x01a683, 0x0138f7, 0x0138f7,  25, -22985,  16,  25 }, /* VERR_LDRLX_BAD_ITERDATA */
    { 0x01ba6d, 0x0134c4, 0x0134c4,  25, -22984,  16,  25 }, /* VERR_LDRLX_BAD_PAGE_MAP */
    { 0x017949, 0x018d7a, 0x018d7a,  19, -22983,  20,  19 }, /* VERR_LDRLX_BAD_OBJECT_TABLE */
    { 0x016aec, 0x00b8a1, 0x00b8a1,  37, -22982,  21,  37 }, /* VERR_LDRLX_BAD_FIXUP_SECTION */
    { 0x015893, 0x00e3d4, 0x00e3d4,  32, -22981,  22,  32 }, /* VERR_LDRLX_BAD_LOADER_SECTION */
    { 0x01cd1a, 0x01a2dc, 0x01a2dc,  17, -22980,  14,  17 }, /* VERR_LDRLX_BAD_HEADER */
    { 0x016a98, 0x01abb1, 0x01abb1,  17, -22979,  21,  17 }, /* VERR_LDR_ADDRESS_OVERFLOW */
    { 0x01e1b3, 0x01d22f, 0x01d22f,  13, -22978,  11,  13 }, /* VERR_LDR_BAD_FIXUP */
    { 0x01b66d, 0x01f25b, 0x01f25b,   7, -22977,  16,   7 }, /* VERR_LDR_NO_IMAGE_UUID */
    { 0x011bf0, 0x014c16, 0x014c16,  23, -22976,  27,  23 }, /* VERR_LDR_DUPLICATE_SEGMENT_NAME */
    { 0x0160a6, 0x01461d, 0x01461d,  24, -22975,  22,  24 }, /* VERR_LDRMACHO_BAD_SYMTAB_SIZE */
    { 0x01cdb4, 0x0112de, 0x0112de,  27, -22974,  14,  27 }, /* VERR_LDRMACHO_TODO */
    { 0x011ff2, 0x00a587, 0x00a587,  40, -22973,  27,  40 }, /* VERR_LDRMACHO_NON_CONT_SEG_BITS */
    { 0x00cbbb, 0x00a87f, 0x00a87f,  40, -22972,  35,  40 }, /* VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS */
    { 0x016711, 0x01dc34, 0x01dc34,  12, -22971,  21,  12 }, /* VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE */
    { 0x01a96f, 0x01c01c, 0x01c01c,  15, -22970,  17,  15 }, /* VERR_LDRMACHO_BAD_SYMBOL */
    { 0x016392, 0x01ba0d, 0x01ba0d,  16, -22969,  22,  16 }, /* VERR_LDRMACHO_BAD_OBJECT_FILE */
    { 0x01ac9f, 0x008db1, 0x008db1,  45, -22968,  17,  45 }, /* VERR_LDRMACHO_BIT_MIX */
    { 0x013c5d, 0x00895f, 0x00895f,  47, -22967,  24,  47 }, /* VERR_LDRMACHO_BAD_SECTION_ORDER */
    { 0x0199d3, 0x0083a8, 0x0083a8,  48, -22966,  18,  28 }, /* VERR_LDRMACHO_UNKNOWN_SECTION */
    { 0x014fdc, 0x0132b7, 0x0132b7,  25, -22965,  23,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION */
    { 0x014b47, 0x01382f, 0x01382f,  25, -22964,  23,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION */
    { 0x0192cb, 0x012f7e, 0x012f7e,  25, -22963,  18,  25 }, /* VERR_LDRMACHO_UNSUPPORTED_SECTION */
    { 0x013c5d, 0x01ebbc, 0x01ebbc,   9, -22962,  18,   9 }, /* VERR_LDRMACHO_BAD_SECTION */
    { 0x014ef6, 0x00c307, 0x00c307,  36, -22961,  23,  36 }, /* VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND */
    { 0x014d13, 0x01bb3d, 0x01bb3d,  16, -22960,  23,  16 }, /* VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND */
    { 0x0150c2, 0x01a72d, 0x01a72d,  17, -22959,  23,  17 }, /* VERR_LDRMACHO_BAD_LOAD_COMMAND */
    { 0x01a0fe, 0x007695, 0x007695,  51, -22958,  18,  51 }, /* VERR_LDRMACHO_UNSUPPORTED_MACHINE */
    { 0x017511, 0x01e8c4, 0x01e8c4,  10, -22957,  20,  10 }, /* VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE */
    { 0x01a980, 0x009d24, 0x009d24,  42, -22956,  17,  42 }, /* VERR_LDRMACHO_BAD_HEADER */
    { 0x012e39, 0x00b70a, 0x00b70a,  37, -22955,  25,  37 }, /* VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED */
    { 0x019a51, 0x00cb52, 0x00cb52,  35, -22954,  18,  35 }, /* VERR_LDR_FORWARDERS_NOT_SUPPORTED */
    { 0x016543, 0x00e534, 0x00e534,  32, -22953,  21,  32 }, /* VERR_LDR_FORWARDER_CHAIN_TOO_LONG */
    { 0x01c625, 0x012487, 0x012487,  26, -22952,  15,  26 }, /* VERR_LDR_BAD_FORWARDER */
    { 0x01bb7b, 0x015b7e, 0x015b7e,  22, -22951,  15,  22 }, /* VERR_LDR_NOT_FORWARDER */
    { 0x016543, 0x00a8a7, 0x00a8a7,  40, -22950,  14,  40 }, /* VERR_LDR_FORWARDER */
    { 0x0190ab, 0x00d588, 0x00d588,  33, -22930,  19,  33 }, /* VERR_LDRVI_BAD_CERT_FORMAT */
    { 0x019039, 0x01c0ee, 0x01c0ee,  15, -22929,  19,  15 }, /* VERR_LDRVI_IMAGE_HASH_MISMATCH */
    { 0x019337, 0x018fa1, 0x018fa1,  19, -22928,  18,  19 }, /* VERR_LDRVI_PAGE_HASH_MISMATCH */
    { 0x00b438, 0x0072bd, 0x0072bd,  52, -22927,  38,  52 }, /* VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA */
    { 0x00b857, 0x00c6ac, 0x00c6ac,  35, -22926,  37,  35 }, /* VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED */
    { 0x012b89, 0x0069e8, 0x0069e8,  55, -22925,  26,  44 }, /* VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG */
    { 0x00d355, 0x016ef1, 0x016ef1,  21, -22924,  34,  21 }, /* VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW */
    { 0x00a090, 0x004331, 0x004331,  72, -22923,  41,  72 }, /* VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID */
    { 0x0195e3, 0x00d480, 0x00d480,  33, -22922,  18,  12 }, /* VERR_LDRVI_PARSE_BER_ERROR */
    { 0x01afed, 0x0150f0, 0x0150f0,  23, -22921,  16,  23 }, /* VERR_LDRVI_PARSE_IPE */
    { 0x01d820, 0x01580f, 0x01580f,  22, -22919,  12,  22 }, /* VERR_LDRVI_UNSUPPORTED_ARCH */
    { 0x00f25a, 0x00aa37, 0x00aa37,  40, -22918,  30,  40 }, /* VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH */
    { 0x00f2d2, 0x00b542, 0x00b542,  38, -22917,  30,  38 }, /* VERR_LDRVI_SECTION_RAW_DATA_VALUES */
    { 0x01699c, 0x01e376, 0x01e376,  11, -22916,  21,  11 }, /* VERR_LDRVI_INVALID_SECTION_COUNT */
    { 0x01a595, 0x01e1df, 0x01e1df,  11, -22915,  17,  11 }, /* VERR_LDRVI_BAD_MZ_OFFSET */
    { 0x0165eb, 0x0138de, 0x0138de,  25, -22914,  21,  25 }, /* VERR_LDRVI_BAD_CERT_MULTIPLE */
    { 0x016765, 0x01e1df, 0x01e1df,  11, -22913,  21,  11 }, /* VERR_LDRVI_BAD_CERT_HDR_TYPE */
    { 0x012e07, 0x01e1df, 0x01e1df,  11, -22912,  25,  11 }, /* VERR_LDRVI_BAD_CERT_HDR_REVISION */
    { 0x01560f, 0x01e1df, 0x01e1df,  11, -22911,  23,  11 }, /* VERR_LDRVI_BAD_CERT_HDR_LENGTH */
    { 0x0125f3, 0x018079, 0x018079,  20, -22910,  26,  20 }, /* VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY */
    { 0x011a25, 0x00efc4, 0x00efc4,  31, -22909,  27,  31 }, /* VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT */
    { 0x017881, 0x012815, 0x012815,  26, -22908,  20,  26 }, /* VERR_LDRVI_NO_MEMORY_SHDRS */
    { 0x0148ed, 0x008e92, 0x008e92,  45, -22907,  24,  45 }, /* VERR_LDRVI_NO_MEMORY_SIGNATURE */
    { 0x017ce1, 0x0154fb, 0x0154fb,  23, -22906,  20,  23 }, /* VERR_LDRVI_NO_MEMORY_STATE */
    { 0x017bdd, 0x0133fc, 0x0133fc,  25, -22905,  20,  25 }, /* VERR_LDRVI_FILE_LENGTH_ERROR */
    { 0x019b71, 0x01637c, 0x01637c,  22, -22904,  18,  22 }, /* VERR_LDRVI_READ_ERROR_HASH */
    { 0x014f0d, 0x00a717, 0x00a717,  40, -22903,  23,  40 }, /* VERR_LDRVI_READ_ERROR_SIGNATURE */
    { 0x018ca9, 0x0165ac, 0x0165ac,  21, -22902,  19,  21 }, /* VERR_LDRVI_READ_ERROR_SHDRS */
    { 0x01a6e9, 0x016eb2, 0x016eb2,  21, -22901,  17,  21 }, /* VERR_LDRVI_READ_ERROR_HDR */
    { 0x01cdec, 0x011983, 0x011983,  27, -22900,  14,  27 }, /* VERR_LDRVI_NOT_SIGNED */
    { 0x01c794, 0x01e586, 0x01ea04,  10, -22899,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_5 */
    { 0x01c75c, 0x01e586, 0x01e586,  10, -22898,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_4 */
    { 0x01c76a, 0x01e586, 0x01e798,  10, -22897,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_3 */
    { 0x01c786, 0x01e586, 0x01e8a6,  10, -22896,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_2 */
    { 0x01c778, 0x01e586, 0x01e6a8,  10, -22895,  14,   4 }, /* VERR_ASN1_INTERNAL_ERROR_1 */
    { 0x018c83, 0x00b779, 0x0141e5,  24, -22857,  19,   5 }, /* VERR_ASN1_INVALID_INTEGER_ENCODING */
    { 0x01eac9, 0x01a485, 0x01a485,  17, -22856,   9,  17 }, /* VERR_ASN1_UNEXPECTED_OBJ_ID */
    { 0x01b55d, 0x009a06, 0x009a06,  42, -22855,  16,   5 }, /* VERR_ASN1_TOO_DEEPLY_NESTED */
    { 0x01c03a, 0x00f368, 0x00f368,  30, -22854,  15,  21 }, /* VERR_ASN1_INVALID_DATA_POINTER */
    { 0x018259, 0x01452d, 0x01452d,  24, -22853,  20,  15 }, /* VERR_ASN1_EXPECTED_PRIMITIVE */
    { 0x01f27e, 0x003732, 0x01c6d0,  14, -22852,   7,   4 }, /* VERR_ASN1_TOO_LONG */
    { 0x01c8c8, 0x00b600, 0x013a55,  25, -22851,  14,   5 }, /* VERR_ASN1_DUMMY_OBJECT */
    { 0x01ca18, 0x003732, 0x0082e8,  48, -22850,  14,   4 }, /* VERR_ASN1_DYNTYPE_BAD_TAG */
    { 0x018e25, 0x008108, 0x008108,  48, -22849,  19,  18 }, /* VERR_ASN1_DYNTYPE_TAG_NOT_IMPL */
    { 0x01739e, 0x00b779, 0x011623,  27, -22848,  21,   5 }, /* VERR_ASN1_INVALID_BITSTRING_ENCODING */
    { 0x01b96d, 0x00b779, 0x016c90,  21, -22847,  16,   5 }, /* VERR_ASN1_INVALID_NULL_ENCODING */
    { 0x018beb, 0x00b779, 0x01491d,  24, -22846,  19,   5 }, /* VERR_ASN1_INVALID_BOOLEAN_ENCODING */
    { 0x010f7b, 0x00b779, 0x00da0b,  33, -22845,  28,   5 }, /* VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING */
    { 0x017539, 0x00b779, 0x013140,  25, -22844,  20,   5 }, /* VERR_ASN1_INVALID_UTC_TIME_ENCODING */
    { 0x019d32, 0x0097af, 0x0097af,  43, -22843,  18,  19 }, /* VERR_ASN1_TIME_NORMALIZE_MISMATCH */
    { 0x019cc7, 0x00f3a4, 0x00f3a4,  30, -22842,  18,  16 }, /* VERR_ASN1_TIME_NORMALIZE_ERROR */
    { 0x015654, 0x0146f5, 0x0188ce,  19, -22841,  23,   5 }, /* VERR_ASN1_TIME_BAD_NORMALIZE_INPUT */
    { 0x012e20, 0x003732, 0x013091,  25, -22840,  25,   4 }, /* VERR_ASN1_BITSTRING_OUT_OF_BOUNDS */
    { 0x013159, 0x00b600, 0x00b600,  38, -22839,  25,   5 }, /* VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH */
    { 0x01ccf0, 0x00b600, 0x011314,  27, -22838,  14,   5 }, /* VERR_ASN1_CURSOR_TAG_MISMATCH */
    { 0x00cae9, 0x009df6, 0x009df6,  42, -22837,  35,  42 }, /* VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING */
    { 0x012779, 0x0107f0, 0x0107f0,  28, -22836,  26,  14 }, /* VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT */
    { 0x01872c, 0x012d3f, 0x012d3f,  25, -22835,  19,  11 }, /* VERR_ASN1_CURSOR_NO_MORE_DATA */
    { 0x013302, 0x003732, 0x006e61,  54, -22834,  16,   4 }, /* VERR_ASN1_CURSOR_BAD_LENGTH */
    { 0x011fbc, 0x00b9c9, 0x00b9c9,  37, -22833,  27,  37 }, /* VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH */
    { 0x00d19b, 0x00af94, 0x00af94,  39, -22832,  34,  39 }, /* VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH */
    { 0x013302, 0x0146f5, 0x0146f5,  24, -22831,  25,   5 }, /* VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING */
    { 0x01a474, 0x00d2ab, 0x00d2ab,  34, -22830,  17,   9 }, /* VERR_ASN1_CURSOR_LONG_TAG */
    { 0x01b80d, 0x00666d, 0x00666d,  56, -22829,  16,  47 }, /* VERR_ASN1_CURSOR_NOT_AT_END */
    { 0x01e824, 0x003732, 0x01ac39,  17, -22828,  10,   4 }, /* VERR_ASN1_NOT_PRESENT */
    { 0x015c86, 0x003732, 0x00ea51,  31, -22827,  22,   4 }, /* VERR_ASN1_NO_CHECK_SANITY_METHOD */
    { 0x01ec67, 0x003732, 0x00f5c0,  30, -22826,   9,   4 }, /* VERR_ASN1_NO_VTABLE */
    { 0x0199c1, 0x01c1ed, 0x01c1ed,  15, -22825,  18,  15 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET */
    { 0x019835, 0x00d7b9, 0x00d7b9,  33, -22824,  18,  33 }, /* VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ */
    { 0x01936d, 0x00d5ca, 0x00d5ca,  33, -22823,  18,  33 }, /* VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ */
    { 0x01dd23, 0x015b52, 0x015b52,  22, -22820,  12,  22 }, /* VERR_ASN1_TIME_TAG_MISMATCH */
    { 0x01cce2, 0x019abd, 0x019abd,  18, -22819,  14,  18 }, /* VERR_ASN1_STRING_TAG_MISMATCH */
    { 0x012147, 0x01199e, 0x01199e,  27, -22818,  26,  27 }, /* VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL */
    { 0x0158d5, 0x01bfb3, 0x01bfb3,  15, -22817,  22,  15 }, /* VERR_ASN1_OBJID_INVALID_DOTTED_STRING */
    { 0x0135f0, 0x003718, 0x003718,  84, -22816,  25,  30 }, /* VERR_ASN1_OBJID_TOO_LONG_STRING_FORM */
    { 0x01434d, 0x0058a8, 0x0058a8,  60, -22815,  24,  19 }, /* VERR_ASN1_OBJID_TOO_MANY_COMPONENTS */
    { 0x0163be, 0x003dfa, 0x003dfa,  76, -22814,  22,  19 }, /* VERR_ASN1_OBJID_COMPONENT_TOO_BIG */
    { 0x01adaf, 0x00b779, 0x00cd9f,  34, -22813,  17,   5 }, /* VERR_ASN1_INVALID_OBJID_ENCODING */
    { 0x01592d, 0x00b779, 0x011f50,  27, -22812,  22,   5 }, /* VERR_ASN1_INVALID_BMP_STRING_ENCODING */
    { 0x0109b0, 0x00b779, 0x00d924,  33, -22811,  28,   5 }, /* VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING */
    { 0x0121fd, 0x00b779, 0x00e614,  31, -22810,  26,   5 }, /* VERR_ASN1_INVALID_GENERAL_STRING_ENCODING */
    { 0x012981, 0x00b779, 0x00b779,  37, -22809,  26,   5 }, /* VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING */
    { 0x01227f, 0x00b779, 0x00e959,  31, -22808,  26,   5 }, /* VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING */
    { 0x015985, 0x00b779, 0x011fd7,  27, -22807,  22,   5 }, /* VERR_ASN1_INVALID_IA5_STRING_ENCODING */
    { 0x011809, 0x00b779, 0x00e054,  32, -22806,  27,   5 }, /* VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING */
    { 0x015f88, 0x00b779, 0x00c98b,  35, -22805,  22,   5 }, /* VERR_ASN1_INVALID_T61_STRING_ENCODING */
    { 0x010994, 0x00b779, 0x00d4a1,  33, -22804,  28,   5 }, /* VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING */
    { 0x012ab9, 0x00b779, 0x00ea13,  31, -22803,  26,   5 }, /* VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING */
    { 0x01556e, 0x00b779, 0x00fc3d,  29, -22802,  23,   5 }, /* VERR_ASN1_INVALID_UTF8_STRING_ENCODING */
    { 0x012b21, 0x01ce86, 0x01ce86,  14, -22801,  26,   6 }, /* VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED */
    { 0x01f5c4, 0x0149c0, 0x0149c0,  23, -22800,   3,  23 }, /* VERR_ASN1_ERROR */
    { 0x00c850, 0x005830, 0x005830,  60, -22739,  35,  60 }, /* VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH */
    { 0x013479, 0x006ce7, 0x006ce7,  54, -22738,  25,  54 }, /* VERR_XAR_UNUSED_ARCHIVED_DATA */
    { 0x017d59, 0x00acd6, 0x00acd6,  39, -22737,  20,  39 }, /* VERR_XAR_ARCHIVED_HASH_MISMATCH */
    { 0x010bfc, 0x00ff12, 0x00ff12,  29, -22736,  28,  29 }, /* VERR_XAR_EXTRACTED_SIZE_EXCEEDED */
    { 0x0169b1, 0x00a767, 0x00a767,  40, -22735,  21,  40 }, /* VERR_XAR_EXTRACTED_HASH_MISMATCH */
    { 0x01c0df, 0x01dc70, 0x01dc70,  12, -22734,  15,  12 }, /* VERR_XAR_INVALID_FILE_NAME */
    { 0x01b97d, 0x018895, 0x018895,  19, -22733,  16,  19 }, /* VERR_XAR_BAD_FILE_INODE */
    { 0x017665, 0x017f25, 0x017f25,  20, -22732,  20,  20 }, /* VERR_XAR_BAD_FILE_DEVICE_NO */
    { 0x01c91c, 0x017320, 0x017320,  21, -22731,  14,  21 }, /* VERR_XAR_BAD_FILE_GID */
    { 0x01cf20, 0x0180f1, 0x0180f1,  20, -22730,  14,  20 }, /* VERR_XAR_BAD_FILE_UID */
    { 0x01c058, 0x01ae48, 0x01ae48,  17, -22729,  15,  17 }, /* VERR_XAR_BAD_FILE_MODE */
    { 0x0174fd, 0x0172b7, 0x0172b7,  21, -22728,  20,  21 }, /* VERR_XAR_BAD_FILE_TIMESTAMP */
    { 0x01c66e, 0x00e6ce, 0x00e6ce,  31, -22727,  14,  31 }, /* VERR_XAR_NO_ENCODING */
    { 0x01c30a, 0x01ee8a, 0x01ee8a,   8, -22726,  15,   8 }, /* VERR_XAR_UNKNOWN_FILE_TYPE */
    { 0x0130c3, 0x017ead, 0x017ead,  20, -22725,  25,  20 }, /* VERR_XAR_MISSING_DATA_ELEMENT */
    { 0x019ba7, 0x01a038, 0x01a038,  18, -22724,  18,  18 }, /* VERR_XAR_BAD_FILE_ELEMENT */
    { 0x018245, 0x01318b, 0x01318b,  25, -22723,  20,  25 }, /* VERR_XAR_BAD_LENGTH_ELEMENT */
    { 0x0119d4, 0x00dc74, 0x00dc74,  32, -22722,  27,  32 }, /* VERR_XAR_MISSING_LENGTH_ELEMENT */
    { 0x01990d, 0x018fb4, 0x018fb4,  19, -22721,  18,  19 }, /* VERR_XAR_BAD_SIZE_ELEMENT */
    { 0x01334d, 0x012967, 0x012967,  26, -22720,  25,  26 }, /* VERR_XAR_MISSING_SIZE_ELEMENT */
    { 0x017859, 0x013974, 0x013974,  25, -22719,  20,  25 }, /* VERR_XAR_BAD_OFFSET_ELEMENT */
    { 0x011e27, 0x00dd14, 0x00dd14,  32, -22718,  27,  32 }, /* VERR_XAR_MISSING_OFFSET_ELEMENT */
    { 0x0101e7, 0x00444f, 0x00444f,  71, -22717,  29,  71 }, /* VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER */
    { 0x018ebd, 0x015867, 0x015867,  22, -22716,  19,  22 }, /* VERR_XAR_BAD_DIGEST_LENGTH */
    { 0x017845, 0x00b9ee, 0x00b9ee,  37, -22715,  20,  37 }, /* VERR_XAR_HASH_FUNCTION_MISMATCH */
    { 0x015d62, 0x00e93a, 0x00e93a,  31, -22714,  22,  31 }, /* VERR_XAR_BAD_CHECKSUM_ELEMENT */
    { 0x01aef2, 0x01b6cd, 0x01b6cd,  16, -22713,  17,  16 }, /* VERR_XAR_TOC_DIGEST_MISMATCH */
    { 0x01054c, 0x006201, 0x006201,  57, -22712,  29,  57 }, /* VERR_XML_TOC_ELEMENT_HAS_SIBLINGS */
    { 0x013bfd, 0x00cde3, 0x00cde3,  34, -22711,  24,  34 }, /* VERR_XML_TOC_ELEMENT_MISSING */
    { 0x01826d, 0x00f2f0, 0x00f2f0,  30, -22710,  20,  30 }, /* VERR_XAR_TOC_XML_PARSE_ERROR */
    { 0x015851, 0x01587d, 0x01587d,  22, -22709,  22,  22 }, /* VERR_XAR_TOC_UTF8_ENCODING */
    { 0x01ac28, 0x01212d, 0x01212d,  26, -22708,  17,  26 }, /* VERR_XAR_TOC_STRLEN_MISMATCH */
    { 0x016400, 0x008378, 0x008378,  48, -22707,  22,  48 }, /* VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH */
    { 0x01464d, 0x016e9d, 0x016e9d,  21, -22706,  24,  21 }, /* VERR_XAR_TOC_TOO_BIG_COMPRESSED */
    { 0x01464d, 0x01b5ad, 0x01b5ad,  16, -22705,  13,  16 }, /* VERR_XAR_TOC_TOO_BIG */
    { 0x01c3af, 0x009e9e, 0x009e9e,  42, -22704,  15,  42 }, /* VERR_XAR_TOC_TOO_SMALL */
    { 0x0190be, 0x019f4e, 0x019f4e,  18, -22703,  19,  18 }, /* VERR_XAR_UNSUPPORTED_HASH_FUNCTION */
    { 0x01d186, 0x01ed5a, 0x01ed5a,   9, -22702,  13,   9 }, /* VERR_XAR_UNSUPPORTED_VERSION */
    { 0x01c99a, 0x01f24d, 0x01f24d,   7, -22701,  14,   7 }, /* VERR_XAR_BAD_HDR_SIZE */
    { 0x01ba9d, 0x01d1a0, 0x01d1a0,  13, -22700,  16,  13 }, /* VERR_XAR_WRONG_MAGIC */
    { 0x018fed, 0x00b672, 0x00b672,  38, -22600,  19,  38 }, /* VERR_FILESYSTEM_CORRUPT */
    { 0x014f80, 0x018dff, 0x018dff,  19, -22503,  23,  19 }, /* VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY */
    { 0x01c2b0, 0x01e8f6, 0x01e8f6,  10, -22502,  15,  10 }, /* VERR_SYS_SHUTDOWN_FAILED */
    { 0x016b2b, 0x010308, 0x010308,  29, -22500,  21,  29 }, /* VERR_SYS_CANNOT_POWER_OFF */
    { 0x00ccf5, 0x006072, 0x006072,  57, -22430,  34,  57 }, /* VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION */
    { 0x01bf2c, 0x01be4b, 0x01be4b,  15, -22429,  15,  15 }, /* VERR_INSTALLATION_FAILED */
    { 0x01cbbc, 0x01a85f, 0x01a85f,  17, -22428,  14,  17 }, /* VERR_REBOOT_NEEDED */
    { 0x01bd10, 0x012335, 0x012335,  26, -22427,  15,  26 }, /* VERR_FLOAT_OVERFLOW */
    { 0x01b76d, 0x011659, 0x011659,  27, -22426,  16,  27 }, /* VERR_FLOAT_UNDERFLOW */
    { 0x015e12, 0x006a1f, 0x006a1f,  55, -22425,  22,  55 }, /* VERR_PROC_NO_ARG_TRANSLATION */
    { 0x015959, 0x016de0, 0x016de0,  21, -22424,  22,  21 }, /* VERR_THREAD_IS_TERMINATING */
    { 0x01a320, 0x01649a, 0x01649a,  22, -22423,  17,  22 }, /* VERR_TOO_MANY_REFERENCES */
    { 0x01d041, 0x01d625, 0x01d625,  13, -22422,  13,  13 }, /* VERR_EMPTY_STRING */
    { 0x018493, 0x009a5a, 0x009a5a,  42, -22421,  19,  42 }, /* VERR_NO_STRING_TERMINATOR */
    { 0x017c2d, 0x01485d, 0x01485d,  24, -22420,  20,  24 }, /* VERR_INCOMPATIBLE_CONFIG */
    { 0x0145a5, 0x0122b3, 0x0122b3,  26, -22419,  24,  26 }, /* VERR_PROC_ELEVATION_REQUIRED */
    { 0x01deaf, 0x01dd9b, 0x01dd9b,  12, -22418,  12,  12 }, /* VERR_INVALID_SESSION_ID */
    { 0x01e329, 0x01e41b, 0x01e41b,  11, -22417,  11,  11 }, /* VERR_INVALID_CLIENT_ID */
    { 0x0171d0, 0x016d77, 0x016d77,  21, -22416,  21,  21 }, /* VERR_WRONG_PARAMETER_TYPE */
    { 0x015e96, 0x0163d4, 0x0163d4,  22, -22415,  22,  22 }, /* VERR_WRONG_PARAMETER_COUNT */
    { 0x01c9fc, 0x01b28d, 0x01b28d,  16, -22414,  14,  16 }, /* VERR_MP_TOO_MANY_CPUS */
    { 0x0191ee, 0x002477, 0x002477, 106, -22413,  19,  71 }, /* VERR_PROC_IQ_PRIV_NOT_HELD */
    { 0x0177e1, 0x001b5c, 0x001b5c, 119, -22412,  20,  76 }, /* VERR_PROC_APT_PRIV_NOT_HELD */
    { 0x017a9d, 0x000ff0, 0x000ff0, 151, -22411,  20, 100 }, /* VERR_PROC_TCB_PRIV_NOT_HELD */
    { 0x01b92d, 0x006f03, 0x006f03,  54, -22410,  16,  54 }, /* VERR_PRIVILEGE_NOT_HELD */
    { 0x01e360, 0x01e355, 0x01e355,  11, -22409,  11,  11 }, /* VERR_WRONG_TYPE */
    { 0x01f5e4, 0x01ec79, 0x01ec79,   9, -22408,   2,   9 }, /* VERR_MISMATCH */
    { 0x01b98d, 0x018a70, 0x018a70,  19, -22407,  16,  19 }, /* VERR_ALLOCATION_TOO_BIG */
    { 0x00efe3, 0x008e65, 0x008e65,  45, -22406,  31,  45 }, /* VERR_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x018e71, 0x00b24a, 0x00b24a,  38, -22405,  19,  38 }, /* VERR_ACCOUNT_RESTRICTED */
    { 0x01c5ad, 0x00cb2f, 0x00cb2f,  35, -22404,  15,  35 }, /* VERR_PROC_DETACH_NOT_SUPPORTED */
    { 0x01e2b0, 0x00a491, 0x00a491,  41, -22403,  11,  41 }, /* VERR_NOT_AVAILABLE */
    { 0x01d5a3, 0x01d2b1, 0x01d2b1,  13, -22402,  13,  13 }, /* VERR_UNEVEN_INPUT */
    { 0x01a81b, 0x01acf4, 0x01acf4,  17, -22401,  17,  17 }, /* VERR_BUFFER_UNDERFLOW */
    { 0x01e13a, 0x009805, 0x009805,  43, -22400,  11,  43 }, /* VERR_UNEXPECTED_EXCEPTION */
    { 0x01d4e0, 0x01a287, 0x01a287,  17, -22360,  13,  17 }, /* VERR_CR_PKCS7_NOT_DATA */
    { 0x00c3df, 0x00c945, 0x00c945,  35, -22359,  36,  35 }, /* VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH */
    { 0x0106d8, 0x00ad24, 0x00ad24,  39, -22358,  28,  39 }, /* VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED */
    { 0x00b8c6, 0x0098b1, 0x0098b1,  43, -22357,  37,  43 }, /* VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO */
    { 0x011875, 0x00fa50, 0x00fa50,  29, -22356,  27,  29 }, /* VERR_CR_PKCS7_SIGNER_INFO_VERSION */
    { 0x00db54, 0x008078, 0x008078,  48, -22355,  32,  48 }, /* VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO */
    { 0x015f04, 0x0104bb, 0x0104bb,  29, -22354,  22,  29 }, /* VERR_CR_PKCS7_EXPECTED_NO_CRLS */
    { 0x0169db, 0x00a535, 0x00a535,  41, -22353,  21,  41 }, /* VERR_CR_PKCS7_NO_CERTIFICATES */
    { 0x013014, 0x0148bd, 0x0148bd,  24, -22352,  25,  24 }, /* VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM */
    { 0x00d81c, 0x00baf1, 0x00baf1,  37, -22351,  33,  37 }, /* VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS */
    { 0x011d4f, 0x01374e, 0x01374e,  25, -22350,  27,  25 }, /* VERR_CR_PKCS7_SIGNED_DATA_VERSION */
    { 0x016582, 0x00ca17, 0x00ca17,  35, -22320,  21,  35 }, /* VERR_CR_PKCS7_DIGEST_CALC_ERROR */
    { 0x014ad4, 0x014d58, 0x014d58,  23, -22319,  23,  23 }, /* VERR_CR_PKCS7_DIGEST_CREATE_ERROR */
    { 0x00ef48, 0x002952, 0x002952, 102, -22318,  31,  40 }, /* VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS */
    { 0x0127e1, 0x009f9a, 0x009f9a,  41, -22317,  26,  41 }, /* VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS */
    { 0x017791, 0x0143dd, 0x0143dd,  24, -22316,  20,  24 }, /* VERR_CR_PKCS7_NOT_SIGNED_DATA */
    { 0x00f43a, 0x005689, 0x005689,  61, -22315,  30,  61 }, /* VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST */
    { 0x011917, 0x00c2e3, 0x00c2e3,  36, -22314,  27,  36 }, /* VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL */
    { 0x017113, 0x019ff0, 0x019ff0,  18, -22313,  21,  18 }, /* VERR_CR_PKCS7_OSSL_VERIFY_FAILED */
    { 0x01935b, 0x0183fb, 0x0183fb,  19, -22312,  18,  19 }, /* VERR_CR_PKCS7_OSSL_D2I_FAILED */
    { 0x01a1a0, 0x01e96e, 0x01e96e,  10, -22311,  18,  10 }, /* VERR_CR_PKCS7_INTERNAL_ERROR */
    { 0x01bce3, 0x00fbac, 0x00fbac,  29, -22300,  15,  29 }, /* VERR_LOG_REVISION_MISMATCH */
    { 0x01badd, 0x015d36, 0x015d36,  22, -22201,  16,  22 }, /* VERR_DVM_MAP_NO_VOLUME */
    { 0x01c962, 0x00e354, 0x00e354,  32, -22200,  14,  32 }, /* VERR_DVM_MAP_EMPTY */
    { 0x017278, 0x006fa5, 0x006fa5,  53, -22158,  21,  53 }, /* VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT */
    { 0x01c8d6, 0x016fc3, 0x016fc3,  21, -22157,  14,  21 }, /* VERR_VFS_CHAIN_NOT_PATH_ONLY */
    { 0x0174ad, 0x004c1a, 0x004c1a,  67, -22156,  20,  67 }, /* VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY */
    { 0x01d680, 0x003dae, 0x003dae,  76, -22155,  13,  76 }, /* VERR_VFS_CHAIN_PATH_ONLY */
    { 0x019d44, 0x006e2b, 0x006e2b,  54, -22154,  18,  54 }, /* VERR_VFS_CHAIN_WRITE_ONLY_IOS */
    { 0x01ab5c, 0x00502d, 0x00502d,  64, -22153,  17,  64 }, /* VERR_VFS_CHAIN_READ_ONLY_IOS */
    { 0x012cf4, 0x004c5d, 0x004c5d,  67, -22152,  25,  67 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS */
    { 0x019a09, 0x0091ba, 0x0091ba,  44, -22151,  18,  44 }, /* VERR_VFS_CHAIN_TAKES_DIR_OR_VFS */
    { 0x01e426, 0x00bf5f, 0x00bf5f,  36, -22150,  11,  36 }, /* VERR_VFS_CHAIN_TAKES_VFS */
    { 0x01d0f7, 0x0097da, 0x0097da,  43, -22149,  13,  43 }, /* VERR_VFS_CHAIN_TAKES_FSS */
    { 0x012cf4, 0x00fb1b, 0x00fb1b,  29, -22148,  13,  29 }, /* VERR_VFS_CHAIN_TAKES_DIR */
    { 0x01695d, 0x00a134, 0x00a134,  41, -22147,  21,  41 }, /* VERR_VFS_CHAIN_TAKES_FILE_OR_IOS */
    { 0x01695d, 0x015066, 0x015066,  23, -22146,  14,  23 }, /* VERR_VFS_CHAIN_TAKES_FILE */
    { 0x01aa90, 0x006f39, 0x006f39,  54, -22145,  17,  54 }, /* VERR_VFS_CHAIN_ONLY_DIR_OR_VFS */
    { 0x01183f, 0x006f39, 0x006f39,  54, -22144,  27,  54 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR */
    { 0x01e554, 0x00c20b, 0x00c20b,  36, -22143,  10,  36 }, /* VERR_VFS_CHAIN_ONLY_VFS */
    { 0x01dcac, 0x009932, 0x009932,  43, -22142,  12,  43 }, /* VERR_VFS_CHAIN_ONLY_FSS */
    { 0x01aa90, 0x01049e, 0x01049e,  29, -22141,  12,  29 }, /* VERR_VFS_CHAIN_ONLY_DIR */
    { 0x01db80, 0x00ab77, 0x00ab77,  39, -22140,  12,  39 }, /* VERR_VFS_CHAIN_ONLY_IOS */
    { 0x01183f, 0x00a416, 0x00a416,  41, -22139,  20,  41 }, /* VERR_VFS_CHAIN_ONLY_FILE_OR_IOS */
    { 0x01d2ff, 0x015901, 0x015901,  22, -22138,  13,  22 }, /* VERR_VFS_CHAIN_INVALID_ARGUMENT */
    { 0x01d76a, 0x014455, 0x014455,  24, -22137,  13,  24 }, /* VERR_VFS_CHAIN_EMPTY_ARG */
    { 0x01c858, 0x0193fd, 0x0193fd,  18, -22136,  14,  18 }, /* VERR_VFS_CHAIN_TOO_MANY_ARGS */
    { 0x01d111, 0x0193fd, 0x0193fd,  18, -22135,  13,  18 }, /* VERR_VFS_CHAIN_TOO_FEW_ARGS */
    { 0x01790d, 0x0193fd, 0x0193fd,  18, -22134,  20,  18 }, /* VERR_VFS_CHAIN_AT_MOST_SIX_ARGS */
    { 0x016be8, 0x01910a, 0x01910a,  19, -22133,  21,  19 }, /* VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS */
    { 0x01dc4c, 0x014e6c, 0x014e6c,  23, -22132,  12,  23 }, /* VERR_VFS_CHAIN_SIX_ARGS */
    { 0x016c7b, 0x018a11, 0x018a11,  19, -22131,  21,  19 }, /* VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS */
    { 0x0161c4, 0x017705, 0x017705,  20, -22130,  22,  20 }, /* VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS */
    { 0x01d52e, 0x014155, 0x014155,  24, -22129,  13,  24 }, /* VERR_VFS_CHAIN_FIVE_ARGS */
    { 0x016d23, 0x0185fc, 0x0185fc,  19, -22128,  21,  19 }, /* VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS */
    { 0x0158bf, 0x01817d, 0x01817d,  20, -22127,  22,  20 }, /* VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS */
    { 0x01d618, 0x0144cd, 0x0144cd,  24, -22126,  13,  24 }, /* VERR_VFS_CHAIN_FOUR_ARGS */
    { 0x015ab8, 0x017d1d, 0x017d1d,  20, -22125,  22,  20 }, /* VERR_VFS_CHAIN_AT_MOST_THREE_ARGS */
    { 0x0153a2, 0x0170d4, 0x0170d4,  21, -22124,  23,  21 }, /* VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS */
    { 0x01c7e8, 0x013447, 0x013447,  25, -22123,  14,  25 }, /* VERR_VFS_CHAIN_THREE_ARGS */
    { 0x0174e9, 0x019de6, 0x019de6,  18, -22122,  20,  18 }, /* VERR_VFS_CHAIN_AT_MOST_TWO_ARGS */
    { 0x01730b, 0x0189c5, 0x0189c5,  19, -22121,  21,  19 }, /* VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS */
    { 0x01d898, 0x014d9d, 0x014d9d,  23, -22120,  12,  23 }, /* VERR_VFS_CHAIN_TWO_ARGS */
    { 0x0179e9, 0x01174c, 0x01174c,  27, -22119,  20,  27 }, /* VERR_VFS_CHAIN_AT_LEAST_ONE_ARG */
    { 0x018b2d, 0x012557, 0x012557,  26, -22118,  19,  26 }, /* VERR_VFS_CHAIN_AT_MOST_ONE_ARG */
    { 0x01e3ef, 0x00ea70, 0x00ea70,  31, -22117,  11,  31 }, /* VERR_VFS_CHAIN_ONE_ARG */
    { 0x01ed75, 0x01d940, 0x01d940,  12, -22116,   9,  12 }, /* VERR_VFS_CHAIN_NO_ARGS */
    { 0x01b07d, 0x00e842, 0x00e842,  31, -22115,  16,  31 }, /* VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH */
    { 0x01c4db, 0x01be2d, 0x01be2d,  15, -22114,  15,  15 }, /* VERR_VFS_CHAIN_PROVIDER_NOT_FOUND */
    { 0x01f14a, 0x01ef5a, 0x01ef5a,   8, -22113,   7,   8 }, /* VERR_VFS_CHAIN_IPE */
    { 0x01e928, 0x01ec04, 0x01ec04,   9, -22112,  10,   9 }, /* VERR_VFS_CHAIN_CAST_FAILED */
    { 0x01134a, 0x011d6a, 0x011d6a,  27, -22111,  27,  27 }, /* VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT */
    { 0x013bb3, 0x00b64c, 0x00b64c,  38, -22110,  25,  38 }, /* VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT */
    { 0x0162e2, 0x00ef29, 0x00ef29,  31, -22109,  22,  31 }, /* VERR_VFS_CHAIN_TRAILING_SEPARATOR */
    { 0x01680d, 0x00f30e, 0x00f30e,  30, -22108,  21,  30 }, /* VERR_VFS_CHAIN_LEADING_SEPARATOR */
    { 0x01575f, 0x017fb1, 0x017fb1,  20, -22107,  22,  20 }, /* VERR_VFS_CHAIN_EXPECTED_SEPARATOR */
    { 0x012b3b, 0x01aa4c, 0x01aa4c,  17, -22106,  26,  17 }, /* VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME */
    { 0x00f12e, 0x0170fe, 0x0170fe,  21, -22105,  30,  21 }, /* VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES */
    { 0x0102b1, 0x018119, 0x018119,  20, -22104,  29,  20 }, /* VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES */
    { 0x01ec16, 0x01d249, 0x01d249,  13, -22103,   9,  13 }, /* VERR_VFS_CHAIN_UNKNOWN_TYPE */
    { 0x0178e5, 0x01e5fe, 0x01e5fe,  10, -22102,  20,  10 }, /* VERR_VFS_CHAIN_EXPECTED_ELEMENT */
    { 0x01d76a, 0x0130aa, 0x0130aa,  25, -22101,   9,  25 }, /* VERR_VFS_CHAIN_EMPTY */
    { 0x01e473, 0x00c4db, 0x00c4db,  36, -22100,  11,  36 }, /* VERR_VFS_CHAIN_NO_PREFIX */
    { 0x01dec7, 0x010173, 0x010173,  29, -22005,  12,  29 }, /* VERR_ZIP_BAD_HEADER */
    { 0x01d988, 0x00daf2, 0x00daf2,  33, -22004,  12,  33 }, /* VERR_ZIP_UNSUPPORTED_METHOD */
    { 0x01d7df, 0x00cd39, 0x00cd39,  34, -22003,  13,  34 }, /* VERR_ZIP_UNSUPPORTED_VERSION */
    { 0x01dcb8, 0x009830, 0x009830,  43, -22002,  12,  43 }, /* VERR_ZIP_NO_MEMORY */
    { 0x01c9a8, 0x01488d, 0x01488d,  24, -22001,  14,  24 }, /* VERR_ZIP_CORRUPTED */
    { 0x01f431, 0x01f47f, 0x01f47f,   6, -22000,   6,   6 }, /* VERR_ZIP_ERROR */
    { 0x01d2d8, 0x009135, 0x009135,  45,  -7602,  13,  45 }, /* VERR_GCM_NOT_HANDLED */
    { 0x01a8d6, 0x004ac9, 0x004ac9,  68,  -7400,  17,  35 }, /* VERR_PLATFORM_ARCH_NOT_SUPPORTED */
    { 0x01eb7d, 0x01d868, 0x01d868,  12,  -7399,   9,  12 }, /* VERR_IOMMU_IPE_9 */
    { 0x01eb86, 0x01de8b, 0x01de8b,  12,  -7398,   9,  12 }, /* VERR_IOMMU_IPE_8 */
    { 0x01eb8f, 0x01ddb3, 0x01ddb3,  12,  -7397,   9,  12 }, /* VERR_IOMMU_IPE_7 */
    { 0x01eb98, 0x01da18, 0x01da18,  12,  -7396,   9,  12 }, /* VERR_IOMMU_IPE_6 */
    { 0x01eba1, 0x01da60, 0x01da60,  12,  -7395,   9,  12 }, /* VERR_IOMMU_IPE_5 */
    { 0x01ebaa, 0x01dba4, 0x01dba4,  12,  -7394,   9,  12 }, /* VERR_IOMMU_IPE_4 */
    { 0x01ebb3, 0x01dd77, 0x01dd77,  12,  -7393,   9,  12 }, /* VERR_IOMMU_IPE_3 */
    { 0x01ebc5, 0x01d964, 0x01d964,  12,  -7392,   9,  12 }, /* VERR_IOMMU_IPE_2 */
    { 0x01ebe9, 0x01de2b, 0x01de2b,  12,  -7391,   9,  12 }, /* VERR_IOMMU_IPE_1 */
    { 0x01ebe0, 0x01db50, 0x01db50,  12,  -7390,   9,  12 }, /* VERR_IOMMU_IPE_0 */
    { 0x014f24, 0x003c2c, 0x003c2c,  78,  -7310,  23,  78 }, /* VERR_IOMMU_CANNOT_CALL_SELF */
    { 0x01c247, 0x01a84e, 0x01a84e,  17,  -7309,  15,  17 }, /* VERR_IOMMU_NOT_PRESENT */
    { 0x01c274, 0x0136ea, 0x0136ea,  25,  -7308,  15,  25 }, /* VERR_IOMMU_CMD_HW_ERROR */
    { 0x019ca3, 0x009a30, 0x009a30,  42,  -7307,  18,  42 }, /* VERR_IOMMU_CMD_INVALID_FORMAT */
    { 0x01d145, 0x01e7ac, 0x01e7ac,  10,  -7306,  13,  10 }, /* VERR_IOMMU_CMD_NOT_SUPPORTED */
    { 0x013c45, 0x00506d, 0x00506d,  64,  -7305,  24,  64 }, /* VERR_IOMMU_INTR_REMAP_DENIED */
    { 0x018966, 0x014fc5, 0x014fc5,  23,  -7304,  19,  23 }, /* VERR_IOMMU_INTR_REMAP_FAILED */
    { 0x012d58, 0x014185, 0x014185,  24,  -7303,  25,  24 }, /* VERR_IOMMU_ADDR_ACCESS_DENIED */
    { 0x01387a, 0x016972, 0x016972,  21,  -7302,  25,  21 }, /* VERR_IOMMU_ADDR_TRANSLATION_FAILED */
    { 0x01a21e, 0x01331b, 0x01331b,  25,  -7301,  18,  25 }, /* VERR_IOMMU_DTE_BAD_OFFSET */
    { 0x01af36, 0x0143c5, 0x0143c5,  24,  -7300,  17,  24 }, /* VERR_IOMMU_DTE_READ_FAILED */
    { 0x0152a5, 0x00afbb, 0x00afbb,  39,  -7206,  23,  39 }, /* VERR_PDM_CRITSECTRW_MISALIGNED */
    { 0x01b91d, 0x00e7e5, 0x00e7e5,  31,  -7205,  16,  31 }, /* VERR_PDM_CRITSECTRW_IPE */
    { 0x00fa6d, 0x00549b, 0x00549b,  62,  -7204,  29,  62 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS */
    { 0x01258b, 0x00a5d7, 0x00a5d7,  40,  -7203,  26,  40 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS */
    { 0x012675, 0x00a55e, 0x00a55e,  41,  -7202,  26,  41 }, /* VERR_PDM_CRITSECTRW_TOO_MANY_READERS */
    { 0x019c37, 0x00bc19, 0x00bc19,  37,  -7201,  18,  37 }, /* VERR_PDM_CRITSECT_ABORT_FAILED */
    { 0x01d60b, 0x00ec60, 0x00ec60,  31,  -7153,  13,  31 }, /* VERR_SHCLPB_NO_DATA */
    { 0x01c076, 0x013573, 0x013573,  25,  -7152,  15,  25 }, /* VERR_SHCLPB_EVENT_FAILED */
    { 0x01bba8, 0x01892d, 0x01892d,  19,  -7151,  15,  19 }, /* VERR_SHCLPB_GUEST_ERROR */
    { 0x015e80, 0x00e978, 0x00e978,  31,  -7150,  22,  31 }, /* VERR_SHCLPB_TRANSFER_ID_NOT_FOUND */
    { 0x0123d1, 0x005c96, 0x005c96,  59,  -7106,  26,  59 }, /* VERR_SHCLPB_MAX_EVENTS_REACHED */
    { 0x01911d, 0x010e2b, 0x010e2b,  28,  -7105,  19,  28 }, /* VERR_SHCLPB_EVENT_ID_NOT_FOUND */
    { 0x0124a1, 0x00952a, 0x00952a,  43,  -7104,  26,  43 }, /* VERR_SHCLPB_OBJ_HANDLE_INVALID */
    { 0x011f6b, 0x00a6ef, 0x00a6ef,  40,  -7103,  27,  40 }, /* VERR_SHCLPB_LIST_HANDLE_INVALID */
    { 0x0131a4, 0x009907, 0x009907,  43,  -7102,  25,  43 }, /* VERR_SHCLPB_MAX_LISTS_REACHED */
    { 0x0113d1, 0x009027, 0x009027,  45,  -7101,  27,  45 }, /* VERR_SHCLPB_MAX_OBJECTS_REACHED */
    { 0x010481, 0x007a50, 0x007a50,  50,  -7100,  29,  50 }, /* VERR_SHCLPB_MAX_TRANSFERS_REACHED */
    { 0x01437d, 0x00a5af, 0x00a5af,  40,  -7000,  24,  40 }, /* VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT */
    { 0x016a83, 0x01dff0, 0x01dff0,  11,  -6908,  21,  11 }, /* VERR_RECORDING_ENCODING_FAILED */
    { 0x017ac5, 0x001e0d, 0x001e0d, 111,  -6907,  20,  37 }, /* VERR_RECORDING_THROTTLED */
    { 0x01407d, 0x0094d2, 0x0094d2,  44,  -6906,  24,  32 }, /* VERR_RECORDING_LIMIT_REACHED */
    { 0x016e1f, 0x009212, 0x009212,  44,  -6905,  21,  44 }, /* VERR_RECORDING_RESTRICTED */
    { 0x017a4d, 0x01a5d9, 0x01a5d9,  17,  -6904,  20,  17 }, /* VERR_RECORDING_FORMAT_NOT_SUPPORTED */
    { 0x018f1c, 0x01ed7e, 0x01ed7e,   9,  -6903,  19,   9 }, /* VERR_RECORDING_CODEC_NOT_SUPPORTED */
    { 0x015318, 0x015917, 0x015917,  22,  -6902,  23,  22 }, /* VERR_RECORDING_CODEC_INIT_FAILED */
    { 0x01a573, 0x0125bf, 0x0125bf,  26,  -6901,  17,  26 }, /* VERR_RECORDING_INIT_FAILED */
    { 0x0190f7, 0x01ed3f, 0x01ed3f,   9,  -6900,  19,   9 }, /* VERR_RECORDING_CODEC_NOT_FOUND */
    { 0x01f28c, 0x01ea35, 0x01ea35,  10,  -6899,   7,  10 }, /* VERR_NEM_IPE_9 */
    { 0x01f293, 0x01e57c, 0x01e57c,  10,  -6898,   7,  10 }, /* VERR_NEM_IPE_8 */
    { 0x01f29a, 0x01e8ba, 0x01e8ba,  10,  -6897,   7,  10 }, /* VERR_NEM_IPE_7 */
    { 0x01f2a1, 0x01e892, 0x01e892,  10,  -6896,   7,  10 }, /* VERR_NEM_IPE_6 */
    { 0x01f2a8, 0x01e68a, 0x01e68a,  10,  -6895,   7,  10 }, /* VERR_NEM_IPE_5 */
    { 0x01f1b3, 0x01e702, 0x01e702,  10,  -6894,   7,  10 }, /* VERR_NEM_IPE_4 */
    { 0x01f1ba, 0x01e8b0, 0x01e8b0,  10,  -6893,   7,  10 }, /* VERR_NEM_IPE_3 */
    { 0x01f1cf, 0x01e95a, 0x01e95a,  10,  -6892,   7,  10 }, /* VERR_NEM_IPE_2 */
    { 0x01f1dd, 0x01e69e, 0x01e69e,  10,  -6891,   7,  10 }, /* VERR_NEM_IPE_1 */
    { 0x01f1e4, 0x01e75c, 0x01e75c,  10,  -6890,   7,  10 }, /* VERR_NEM_IPE_0 */
    { 0x017b01, 0x009e20, 0x009e20,  42,  -6817,  20,  42 }, /* VERR_NEM_MISSING_FEATURE */
    { 0x0137b2, 0x012a9f, 0x012a9f,  26,  -6816,  25,  26 }, /* VERR_NEM_QUERY_DIRTY_BITMAP_FAILED */
    { 0x012f65, 0x00c4b7, 0x00c4b7,  36,  -6815,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_5 */
    { 0x012ee8, 0x00be1b, 0x00be1b,  36,  -6814,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_4 */
    { 0x012f4c, 0x00c157, 0x00c157,  36,  -6813,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_3 */
    { 0x012f01, 0x00bdaf, 0x00bdaf,  36,  -6812,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_2 */
    { 0x01db98, 0x01c804, 0x01c804,  14,  -6811,  12,  14 }, /* VERR_NEM_SET_TSC */
    { 0x01cc1e, 0x00a372, 0x00a372,  41,  -6810,  14,  41 }, /* VERR_NEM_FLUSH_TLB */
    { 0x017d6d, 0x01786d, 0x01786d,  20,  -6809,  20,  20 }, /* VERR_NEM_SET_REGISTERS_FAILED */
    { 0x018399, 0x01812d, 0x01812d,  20,  -6808,  20,  20 }, /* VERR_NEM_GET_REGISTERS_FAILED */
    { 0x019b83, 0x0100a8, 0x0100a8,  29,  -6807,  18,  29 }, /* VERR_NEM_UNMAP_PAGES_FAILED */
    { 0x01b74d, 0x011cc8, 0x011cc8,  27,  -6806,  16,  27 }, /* VERR_NEM_MAP_PAGES_FAILED */
    { 0x01be96, 0x00d66f, 0x00d66f,  33,  -6805,  15,  33 }, /* VERR_NEM_VM_CREATE_FAILED */
    { 0x01c0c1, 0x00fd42, 0x00fd42,  29,  -6804,  15,  29 }, /* VERR_NEM_RING3_ONLY */
    { 0x012f33, 0x00c5d7, 0x00c5d7,  36,  -6803,  25,  36 }, /* VERR_NEM_MISSING_KERNEL_API_1 */
    { 0x01e397, 0x01e694, 0x01e694,  10,  -6802,  11,  10 }, /* VERR_NEM_INIT_FAILED */
    { 0x01bea5, 0x01ba5d, 0x01ba5d,  16,  -6801,  15,  16 }, /* VERR_NEM_NOT_AVAILABLE */
    { 0x01d381, 0x01c8f2, 0x01c8f2,  14,  -6800,  13,  14 }, /* VERR_NEM_NOT_ENABLED */
    { 0x018051, 0x010f0b, 0x010f0b,  28,  -6702,  20,  28 }, /* VERR_APIC_INTR_DISCARDED */
    { 0x014725, 0x00ed96, 0x00ed96,  31,  -6701,  24,  31 }, /* VERR_APIC_INTR_MASKED_BY_TPR */
    { 0x018da0, 0x019130, 0x019130,  19,  -6700,  19,  19 }, /* VERR_APIC_INTR_NOT_PENDING */
    { 0x00f728, 0x0077f8, 0x0077f8,  50,  -6608,  30,  50 }, /* VERR_AUDIO_STREAM_INIT_IN_PROGRESS */
    { 0x0182bd, 0x017002, 0x017002,  21,  -6607,  20,  21 }, /* VERR_AUDIO_ENUMERATION_FAILED */
    { 0x011f35, 0x00146c, 0x00146c, 137,  -6606,  27,  23 }, /* VERR_AUDIO_STREAM_COULD_NOT_CREATE */
    { 0x017cb9, 0x019283, 0x019283,  18,  -6605,  20,  18 }, /* VERR_AUDIO_STREAM_NOT_READY */
    { 0x010190, 0x00d377, 0x00d377,  34,  -6604,  29,  34 }, /* VERR_AUDIO_STREAM_PENDING_DISABLE */
    { 0x01139b, 0x0173c8, 0x0173c8,  21,  -6603,  27,  21 }, /* VERR_AUDIO_NO_FREE_OUTPUT_STREAMS */
    { 0x0127ad, 0x0174d5, 0x0174d5,  20,  -6602,  26,  20 }, /* VERR_AUDIO_NO_FREE_INPUT_STREAMS */
    { 0x013df5, 0x00c7e7, 0x00c7e7,  35,  -6601,  24,  35 }, /* VERR_AUDIO_BACKEND_NOT_ATTACHED */
    { 0x016876, 0x0014f5, 0x0014f5, 137,  -6600,  21,  35 }, /* VERR_AUDIO_BACKEND_INIT_FAILED */
    { 0x01db2c, 0x015aa2, 0x015aa2,  22,  -6500,  12,  22 }, /* VERR_DND_GUEST_ERROR */
    { 0x01113b, 0x00376c, 0x00376c,  84,  -6401,  28,  41 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_IPE */
    { 0x00f692, 0x00417c, 0x00417c,  74,  -6400,  30,  33 }, /* VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR */
    { 0x01688b, 0x006943, 0x006943,  55,  -6318,  21,  55 }, /* VERR_GIM_INVALID_HYPERCALL_INSTR */
    { 0x015cde, 0x00ff4c, 0x00ff4c,  29,  -6315,  22,  29 }, /* VERR_GIM_NO_DEBUG_CONNECTION */
    { 0x01b03d, 0x017f11, 0x017f11,  20,  -6314,  16,  20 }, /* VERR_GIM_HYPERCALL_FAILED */
    { 0x00fe0d, 0x008168, 0x008168,  48,  -6313,  29,  48 }, /* VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED */
    { 0x010e9b, 0x008901, 0x008901,  47,  -6312,  28,  47 }, /* VERR_GIM_HYPERCALL_MEMORY_READ_FAILED */
    { 0x0111e3, 0x005f8b, 0x005f8b,  58,  -6311,  28,  58 }, /* VERR_GIM_HYPERCALL_ACCESS_DENIED */
    { 0x015135, 0x00b2e2, 0x00b2e2,  38,  -6310,  23,  38 }, /* VERR_GIM_DEVICE_NOT_REGISTERED */
    { 0x013fa5, 0x011bd5, 0x011bd5,  27,  -6309,  24,  27 }, /* VERR_GIM_HYPERCALLS_NOT_ENABLED */
    { 0x012453, 0x00dd74, 0x00dd74,  32,  -6308,  26,  32 }, /* VERR_GIM_HYPERCALLS_NOT_AVAILABLE */
    { 0x01b50d, 0x01cb3e, 0x01cb3e,  14,  -6307,  16,  14 }, /* VERR_GIM_OPERATION_FAILED */
    { 0x01ceb0, 0x01b67d, 0x01b67d,  16,  -6306,  14,  16 }, /* VERR_GIM_INVALID_PROVIDER */
    { 0x0187d7, 0x00bdf7, 0x00bdf7,  36,  -6305,  19,  36 }, /* VERR_GIM_PVTSC_NOT_ENABLED */
    { 0x016db6, 0x009fc3, 0x009fc3,  41,  -6304,  21,  41 }, /* VERR_GIM_PVTSC_NOT_AVAILABLE */
    { 0x01f200, 0x01e6bc, 0x01e6bc,  10,  -6303,   7,  10 }, /* VERR_GIM_IPE_3 */
    { 0x01f2f5, 0x01e630, 0x01e630,  10,  -6302,   7,  10 }, /* VERR_GIM_IPE_2 */
    { 0x01f262, 0x01e84c, 0x01e84c,  10,  -6301,   7,  10 }, /* VERR_GIM_IPE_1 */
    { 0x01d514, 0x00e7c6, 0x00e7c6,  31,  -6300,  13,  31 }, /* VERR_GIM_NOT_ENABLED */
    { 0x012dbc, 0x00b296, 0x00b296,  38,  -6225,  25,  38 }, /* VERR_GSTCTL_PROCESS_EXIT_CODE */
    { 0x00fc77, 0x0091e6, 0x0091e6,  44,  -6224,  29,  44 }, /* VERR_GSTCTL_MAX_CID_COUNT_REACHED */
    { 0x00eb68, 0x00abec, 0x00abec,  39,  -6223,  31,  39 }, /* VERR_GSTCTL_MAX_CID_OBJECTS_REACHED */
    { 0x00e554, 0x00a627, 0x00a627,  40,  -6222,  32,  40 }, /* VERR_GSTCTL_MAX_CID_SESSIONS_REACHED */
    { 0x011aac, 0x019703, 0x019703,  18,  -6221,  27,  18 }, /* VERR_GSTCTL_PROCESS_WRONG_STATE */
    { 0x01bcf2, 0x015aa2, 0x015aa2,  22,  -6200,  15,  22 }, /* VERR_GSTCTL_GUEST_ERROR */
    { 0x0149a9, 0x001242, 0x001242, 140,  -6001,  23,  33 }, /* VERR_EXTPACK_VBOX_VERSION_MISMATCH */
    { 0x01473d, 0x003d15, 0x003d15,  77,  -6000,  24,   9 }, /* VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL */
    { 0x01d9c4, 0x013e55, 0x013e55,  24,  -5699,  12,  24 }, /* VERR_SUP_DRIVERLESS */
    { 0x00a997, 0x003260, 0x003260,  89,  -5679,  40,  89 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT */
    { 0x012dee, 0x00cf9d, 0x00cf9d,  34,  -5678,  25,  34 }, /* VERR_SUP_VP_SET_HANDLE_NOINHERIT */
    { 0x0156af, 0x0182e5, 0x0182e5,  20,  -5677,  22,  20 }, /* VERR_SUP_VP_QUERY_HANDLE_TYPE */
    { 0x01521b, 0x018622, 0x018622,  19,  -5676,  23,  19 }, /* VERR_SUP_VP_UNDESIRABLE_MODULE */
    { 0x0126a9, 0x0094fe, 0x0094fe,  44,  -5675,  26,  44 }, /* VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED */
    { 0x01b2bd, 0x01b12d, 0x01b12d,  16,  -5674,  16,  16 }, /* VERR_SUP_VP_FILE_MODE_ERROR */
    { 0x00ffa3, 0x0004b3, 0x0004b3, 213,  -5673,  29, 119 }, /* VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED */
    { 0x014abd, 0x004ca0, 0x004ca0,  66,  -5672,  23,  66 }, /* VERR_SUP_VP_STUB_THREAD_OPEN_ERROR */
    { 0x0183d5, 0x004258, 0x004258,  73,  -5671,  19,  73 }, /* VERR_SUP_VP_STUB_THREAD_NOT_FOUND */
    { 0x01afad, 0x0059d2, 0x0059d2,  59,  -5670,  16,  59 }, /* VERR_SUP_VP_STUB_OPEN_ERROR */
    { 0x01dac0, 0x005555, 0x005555,  62,  -5669,  12,  62 }, /* VERR_SUP_VP_STUB_NOT_FOUND */
    { 0x01c085, 0x018f09, 0x018f09,  19,  -5668,  15,  19 }, /* VERR_SUP_VP_IMAGE_TOO_BIG */
    { 0x00db34, 0x00bacc, 0x00bacc,  37,  -5667,  32,  37 }, /* VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER */
    { 0x017f9d, 0x00bc3e, 0x00bc3e,  37,  -5666,  20,  37 }, /* VERR_SUP_VP_UNKOWN_MEM_TYPE */
    { 0x014545, 0x002684, 0x002684, 103,  -5665,  24, 103 }, /* VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED */
    { 0x012ba3, 0x003670, 0x003670,  84,  -5664,  26,  84 }, /* VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED */
    { 0x01706b, 0x005593, 0x005593,  62,  -5663,  21,  23 }, /* VERR_SUP_VP_KERNEL32_ALREADY_MAPPED */
    { 0x01c0b2, 0x000656, 0x000656, 181,  -5662,  15,  66 }, /* VERR_SUP_VP_SYSFER_DLL */
    { 0x00ecdc, 0x00c493, 0x00c493,  36,  -5661,  31,  36 }, /* VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED */
    { 0x015d0a, 0x01c3eb, 0x01c3eb,  15,  -5660,  22,  15 }, /* VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT */
    { 0x00d777, 0x00690c, 0x00690c,  55,  -5659,  33,  55 }, /* VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE */
    { 0x017999, 0x01355a, 0x01355a,  25,  -5658,  20,  25 }, /* VERR_SUP_VP_NOT_BUILD_CERT_IPE */
    { 0x010a04, 0x009296, 0x009296,  44,  -5657,  28,  44 }, /* VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT */
    { 0x013208, 0x004b94, 0x004b94,  67,  -5656,  25,  67 }, /* VERR_SUP_VP_WINTRUST_CAT_FAILURE */
    { 0x01052f, 0x014215, 0x014215,  24,  -5655,  29,  24 }, /* VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR */
    { 0x01035f, 0x012745, 0x012745,  26,  -5654,  29,  26 }, /* VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR */
    { 0x010d4c, 0x0081c8, 0x0081c8,  48,  -5653,  28,  48 }, /* VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH */
    { 0x01287d, 0x006ecd, 0x006ecd,  54,  -5652,  26,  54 }, /* VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH */
    { 0x012b07, 0x00ad72, 0x00ad72,  39,  -5651,  26,  39 }, /* VERR_SUP_VP_EXE_MISSING_NX_COMPAT */
    { 0x00fd5f, 0x00d157, 0x00d157,  34,  -5650,  29,  34 }, /* VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE */
    { 0x00e474, 0x0045af, 0x0045af,  70,  -5649,  32,  70 }, /* VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY */
    { 0x018ace, 0x00d546, 0x00d546,  33,  -5648,  19,  33 }, /* VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS */
    { 0x018b9f, 0x0099dc, 0x0099dc,  42,  -5647,  19,  42 }, /* VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE */
    { 0x018c11, 0x018849, 0x018849,  19,  -5646,  19,  19 }, /* VERR_SUP_VP_TOO_MANY_SECTIONS */
    { 0x0133ca, 0x0139bf, 0x0139bf,  25,  -5645,  25,  25 }, /* VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS */
    { 0x014245, 0x019b95, 0x019b95,  18,  -5644,  24,  18 }, /* VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS */
    { 0x0161ae, 0x011eff, 0x011eff,  27,  -5643,  22,  27 }, /* VERR_SUP_VP_TOO_MANY_DLLS_LOADED */
    { 0x019301, 0x00fa16, 0x00fa16,  29,  -5642,  18,  29 }, /* VERR_SUP_VP_TOO_LARGE_REGION */
    { 0x016948, 0x0152d3, 0x0152d3,  23,  -5641,  21,  23 }, /* VERR_SUP_VP_TOO_HIGH_REGION_RVA */
    { 0x019ebe, 0x015301, 0x015301,  23,  -5640,  18,  23 }, /* VERR_SUP_VP_THREAD_NOT_ALONE */
    { 0x01986b, 0x00d567, 0x00d567,  33,  -5639,  18,  33 }, /* VERR_SUP_VP_SYSTEM32_PATH */
    { 0x00f21e, 0x013541, 0x013541,  25,  -5638,  30,  25 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR */
    { 0x011608, 0x00edb5, 0x00edb5,  31,  -5637,  27,  31 }, /* VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR */
    { 0x018bc5, 0x00e294, 0x00e294,  32,  -5636,  19,  32 }, /* VERR_SUP_VP_NT_QI_THREAD_ERROR */
    { 0x014e55, 0x018fc7, 0x018fc7,  19,  -5635,  23,  19 }, /* VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR */
    { 0x010764, 0x00d069, 0x00d069,  34,  -5634,  28,  34 }, /* VERR_SUP_VP_NT_MAPPING_NAME_CHANGED */
    { 0x015c02, 0x007cd8, 0x007cd8,  49,  -5633,  22,  49 }, /* VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE */
    { 0x01673b, 0x00752d, 0x00752d,  52,  -5632,  21,  52 }, /* VERR_SUP_VP_NON_SYSTEM32_DLL */
    { 0x018bd8, 0x00d047, 0x00d047,  34,  -5631,  19,  10 }, /* VERR_SUP_VP_NO_NTDLL_MAPPING */
    { 0x01988f, 0x009ca6, 0x009ca6,  42,  -5630,  18,  42 }, /* VERR_SUP_VP_NO_MEMORY_STATE */
    { 0x01988f, 0x016248, 0x016248,  22,  -5629,  12,  22 }, /* VERR_SUP_VP_NO_MEMORY */
    { 0x015a8d, 0x00c523, 0x00c523,  36,  -5628,  22,  12 }, /* VERR_SUP_VP_NO_KERNEL32_MAPPING */
    { 0x0148a5, 0x014635, 0x014635,  24,  -5627,  24,  24 }, /* VERR_SUP_VP_NO_IMAGE_MAPPING_NAME */
    { 0x0181e1, 0x007e2f, 0x007e2f,  49,  -5626,  20,  49 }, /* VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING */
    { 0x0194c3, 0x00c013, 0x00c013,  36,  -5625,  18,  36 }, /* VERR_SUP_VP_MEMORY_READ_ERROR */
    { 0x013b1d, 0x001706, 0x001706, 126,  -5624,  25, 126 }, /* VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR */
    { 0x016e73, 0x01c1fc, 0x01c1fc,  15,  -5623,  21,  15 }, /* VERR_SUP_VP_IMAGE_HDR_READ_ERROR */
    { 0x015e28, 0x019ed0, 0x019ed0,  18,  -5622,  22,  18 }, /* VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR */
    { 0x01517a, 0x016a44, 0x016a44,  21,  -5621,  23,  21 }, /* VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR */
    { 0x00e1f4, 0x005d81, 0x005d81,  58,  -5620,  32,  58 }, /* VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING */
    { 0x019661, 0x00239f, 0x00239f, 108,  -5619,  18,  41 }, /* VERR_SUP_VP_FOUND_EXEC_MEMORY */
    { 0x015204, 0x012849, 0x012849,  26,  -5618,  23,  26 }, /* VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH */
    { 0x0140dd, 0x017935, 0x017935,  20,  -5617,  24,  20 }, /* VERR_SUP_VP_EMPTY_REGION_TOO_LARGE */
    { 0x012265, 0x011b18, 0x011b18,  27,  -5616,  26,  27 }, /* VERR_SUP_VP_DUPLICATE_DLL_MAPPING */
    { 0x01d5b0, 0x01afcd, 0x01afcd,  16,  -5615,  13,  16 }, /* VERR_SUP_VP_DEBUGGED */
    { 0x0171fa, 0x01f0ba, 0x01f0ba,   8,  -5614,  21,   8 }, /* VERR_SUP_VP_BAD_SIZE_OF_HEADERS */
    { 0x01241f, 0x0195ad, 0x0195ad,  18,  -5613,  26,  18 }, /* VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE */
    { 0x01ab6d, 0x0164c5, 0x0164c5,  21,  -5612,  17,  21 }, /* VERR_SUP_VP_BAD_SECTION_RVA */
    { 0x014d86, 0x01bc98, 0x01bc98,  15,  -5611,  23,  15 }, /* VERR_SUP_VP_BAD_SECTION_FILE_SIZE */
    { 0x00fdd3, 0x018b40, 0x018b40,  19,  -5610,  29,  19 }, /* VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE */
    { 0x0168ca, 0x018155, 0x018155,  20,  -5609,  21,  20 }, /* VERR_SUP_VP_BAD_OPTIONAL_HEADER */
    { 0x01c328, 0x0159b1, 0x0159b1,  22,  -5608,  15,  22 }, /* VERR_SUP_VP_BAD_MZ_OFFSET */
    { 0x01b53d, 0x01e6d0, 0x01e6d0,  10,  -5607,  16,  10 }, /* VERR_SUP_VP_BAD_IMAGE_SIZE */
    { 0x017167, 0x01c283, 0x01c283,  15,  -5606,  21,  15 }, /* VERR_SUP_VP_BAD_IMAGE_SIGNATURE */
    { 0x01babd, 0x01dafc, 0x01dafc,  12,  -5605,  16,  12 }, /* VERR_SUP_VP_BAD_IMAGE_BASE */
    { 0x01239d, 0x018778, 0x018778,  19,  -5604,  26,  19 }, /* VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE */
    { 0x012439, 0x00a186, 0x00a186,  41,  -5603,  26,  41 }, /* VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED */
    { 0x017a25, 0x00cb0c, 0x00cb0c,  35,  -5602,  20,  35 }, /* VERR_SUP_VP_SECTION_NOT_MAPPED */
    { 0x01342e, 0x0092c2, 0x0092c2,  44,  -5601,  25,  44 }, /* VERR_SUP_VP_SECTION_PROTECTION_MISMATCH */
    { 0x016f1b, 0x01bb4d, 0x01bb4d,  16,  -5600,  21,  16 }, /* VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH */
    { 0x012405, 0x01e87e, 0x01e87e,  10,  -5499,  26,  10 }, /* VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS */
    { 0x011824, 0x01f350, 0x01f350,   7,  -5498,  27,   7 }, /* VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS */
    { 0x00fef5, 0x00e434, 0x00e434,  32,  -5497,  29,  32 }, /* VERR_DBGC_PARSE_ARGUMENT_OVERFLOW */
    { 0x00f494, 0x016e34, 0x016e34,  21,  -5496,  30,  21 }, /* VERR_DBGC_PARSE_EXPECTED_BINARY_OP */
    { 0x012509, 0x00b7e8, 0x00b7e8,  37,  -5494,  26,  37 }, /* VERR_DBGC_PARSE_NO_RANGE_ALLOWED */
    { 0x010ac8, 0x01625e, 0x01625e,  22,  -5493,  28,  22 }, /* VERR_DBGC_PARSE_UNBALANCED_QUOTE */
    { 0x00d1bd, 0x012028, 0x012028,  27,  -5492,  34,  27 }, /* VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS */
    { 0x0126dd, 0x00995d, 0x00995d,  43,  -5491,  26,  43 }, /* VERR_DBGC_PARSE_EMPTY_ARGUMENT */
    { 0x0167a4, 0x017dbd, 0x017dbd,  20,  -5490,  21,  20 }, /* VERR_DBGC_PARSE_UNEXPECTED_OPERATOR */
    { 0x018681, 0x01ce94, 0x01ce94,  14,  -5489,  19,  14 }, /* VERR_DBGC_PARSE_INVALID_NUMBER */
    { 0x0153b9, 0x016504, 0x016504,  21,  -5488,  23,  21 }, /* VERR_DBGC_PARSE_NUMBER_TOO_BIG */
    { 0x016182, 0x01b4bd, 0x01b4bd,  16,  -5487,  22,  16 }, /* VERR_DBGC_PARSE_INVALID_OPERATION */
    { 0x015488, 0x01c256, 0x01c256,  15,  -5486,  23,  15 }, /* VERR_DBGC_PARSE_FUNCTION_NOT_FOUND */
    { 0x0155f8, 0x010780, 0x010780,  28,  -5485,  23,  28 }, /* VERR_DBGC_PARSE_NOT_A_FUNCTION */
    { 0x0175b1, 0x01443d, 0x01443d,  24,  -5484,  20,  24 }, /* VERR_DBGC_PARSE_NO_SCRATCH */
    { 0x018765, 0x0102ce, 0x0102ce,  29,  -5483,  19,  29 }, /* VERR_DBGC_PARSE_NO_MEMORY */
    { 0x00f656, 0x010b38, 0x010b38,  28,  -5482,  30,  28 }, /* VERR_DBGC_PARSE_INCORRECT_ARG_TYPE */
    { 0x014ca0, 0x00c10f, 0x00c10f,  36,  -5481,  23,  36 }, /* VERR_DBGC_PARSE_VARIABLE_NOT_FOUND */
    { 0x013c15, 0x0189eb, 0x0189eb,  19,  -5480,  24,  19 }, /* VERR_DBGC_PARSE_CONVERSION_FAILED */
    { 0x013d7d, 0x00336a, 0x00336a,  87,  -5479,  24,  54 }, /* VERR_DBGC_PARSE_NOT_IMPLEMENTED */
    { 0x014755, 0x0080a8, 0x0080a8,  48,  -5478,  24,  48 }, /* VERR_DBGC_PARSE_BAD_RESULT_TYPE */
    { 0x010844, 0x0081f8, 0x0081f8,  48,  -5477,  28,  48 }, /* VERR_DBGC_PARSE_WRITEONLY_SYMBOL */
    { 0x00eaec, 0x019c7f, 0x019c7f,  18,  -5476,  31,  18 }, /* VERR_DBGC_PARSE_INVALD_COMMAND_NAME */
    { 0x015ec2, 0x01cef6, 0x01cef6,  14,  -5475,  22,  14 }, /* VERR_DBGC_PARSE_COMMAND_NOT_FOUND */
    { 0x01c472, 0x01aa3b, 0x01aa3b,  17,  -5474,  15,  17 }, /* VERR_DBGC_PARSE_BUG */
    { 0x01ec28, 0x019e2e, 0x019e2e,  18,  -5408,   9,  18 }, /* VERR_DBGC_IPE */
    { 0x01c238, 0x012a6b, 0x012a6b,  26,  -5407,  15,  26 }, /* VERR_DBGC_COMMAND_FAILED */
    { 0x01c553, 0x01e93c, 0x01e93c,  10,  -5405,  15,  10 }, /* VERR_DBGC_BP_EXISTS */
    { 0x01e1d4, 0x01d934, 0x01d934,  12,  -5404,  11,  12 }, /* VERR_DBGC_BP_NOT_FOUND */
    { 0x0128e5, 0x00b07e, 0x00b07e,  39,  -5403,  26,  39 }, /* VERR_DBGC_COMMANDS_NOT_REGISTERED */
    { 0x01e61c, 0x012195, 0x012195,  26,  -5400,  10,  26 }, /* VERR_DBGC_QUIT */
    { 0x01f569, 0x01d27d, 0x01d27d,  13,  -5399,   4,  13 }, /* VERR_IEM_IPE_9 */
    { 0x01f56d, 0x01d138, 0x01d138,  13,  -5398,   4,  13 }, /* VERR_IEM_IPE_8 */
    { 0x01f571, 0x01d437, 0x01d437,  13,  -5397,   4,  13 }, /* VERR_IEM_IPE_7 */
    { 0x01f575, 0x01d0d0, 0x01d0d0,  13,  -5396,   4,  13 }, /* VERR_IEM_IPE_6 */
    { 0x01f579, 0x01d5e4, 0x01d5e4,  13,  -5395,   4,  13 }, /* VERR_IEM_IPE_5 */
    { 0x01f57d, 0x01d49f, 0x01d49f,  13,  -5394,   4,  13 }, /* VERR_IEM_IPE_4 */
    { 0x01f581, 0x01d1d4, 0x01d1d4,  13,  -5393,   4,  13 }, /* VERR_IEM_IPE_3 */
    { 0x01f585, 0x01d15f, 0x01d15f,  13,  -5392,   4,  13 }, /* VERR_IEM_IPE_2 */
    { 0x01f589, 0x01d3b5, 0x01d3b5,  13,  -5391,   4,  13 }, /* VERR_IEM_IPE_1 */
    { 0x017407, 0x007f86, 0x007f86,  49,  -5390,  21,  49 }, /* VERR_IEM_ASPECT_NOT_IMPLEMENTED */
    { 0x0170bf, 0x00a857, 0x00a857,  40,  -5389,  21,  22 }, /* VERR_IEM_RESTART_INSTRUCTION */
    { 0x017c55, 0x01ca50, 0x01ca50,  14,  -5384,  20,  14 }, /* VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER */
    { 0x00f4ee, 0x0141b5, 0x0141b5,  24,  -5383,  30,  24 }, /* VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE */
    { 0x019943, 0x0168df, 0x0168df,  21,  -5382,  18,  21 }, /* VERR_IEM_EMIT_BAD_SEG_REG_NO */
    { 0x01b08d, 0x012863, 0x012863,  26,  -5381,  16,  26 }, /* VERR_IEM_EMIT_BAD_MEM_SIZE */
    { 0x012c0b, 0x0178a9, 0x0178a9,  20,  -5380,  26,  20 }, /* VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1 */
    { 0x01ed48, 0x019df8, 0x019df8,  18,  -5377,   9,  18 }, /* VERR_IEM_VAR_IPE_13 */
    { 0x01ed51, 0x01a134, 0x01a134,  18,  -5376,   9,  18 }, /* VERR_IEM_VAR_IPE_12 */
    { 0x01ea66, 0x019fa8, 0x019fa8,  18,  -5375,   9,  18 }, /* VERR_IEM_VAR_IPE_11 */
    { 0x01ea5d, 0x019a1b, 0x019a1b,  18,  -5374,   9,  18 }, /* VERR_IEM_VAR_IPE_10 */
    { 0x01ee92, 0x01a8a3, 0x01a8a3,  17,  -5373,   8,  17 }, /* VERR_IEM_VAR_IPE_9 */
    { 0x01ee9a, 0x01ae26, 0x01ae26,  17,  -5372,   8,  17 }, /* VERR_IEM_VAR_IPE_8 */
    { 0x01eea2, 0x01ab8f, 0x01ab8f,  17,  -5371,   8,  17 }, /* VERR_IEM_VAR_IPE_7 */
    { 0x01ef62, 0x01a6c7, 0x01a6c7,  17,  -5370,   8,  17 }, /* VERR_IEM_VAR_IPE_6 */
    { 0x01eeaa, 0x01af47, 0x01af47,  17,  -5369,   8,  17 }, /* VERR_IEM_VAR_IPE_5 */
    { 0x01eeb2, 0x01ad16, 0x01ad16,  17,  -5368,   8,  17 }, /* VERR_IEM_VAR_IPE_4 */
    { 0x01eeba, 0x01a51e, 0x01a51e,  17,  -5367,   8,  17 }, /* VERR_IEM_VAR_IPE_3 */
    { 0x01eec2, 0x01a9e6, 0x01a9e6,  17,  -5366,   8,  17 }, /* VERR_IEM_VAR_IPE_2 */
    { 0x01ea5d, 0x01a254, 0x01a254,  17,  -5365,   8,  17 }, /* VERR_IEM_VAR_IPE_1 */
    { 0x01940f, 0x014605, 0x014605,  24,  -5364,  18,  24 }, /* VERR_IEM_VAR_NOT_INITIALIZED */
    { 0x01e26e, 0x01aba0, 0x01aba0,  17,  -5363,  11,  17 }, /* VERR_IEM_VAR_UNEXPECTED_KIND */
    { 0x013be5, 0x019673, 0x019673,  18,  -5362,  24,  18 }, /* VERR_IEM_VAR_OUT_OF_STACK_SLOTS */
    { 0x01b48d, 0x00c19f, 0x00c19f,  36,  -5361,  16,  36 }, /* VERR_IEM_VAR_DUP_ARG_NO */
    { 0x01c427, 0x01b00d, 0x01b00d,  16,  -5360,  15,  16 }, /* VERR_IEM_VAR_EXHAUSTED */
    { 0x01ed63, 0x01143d, 0x01143d,  27,  -5355,   9,  27 }, /* VERR_IEM_REG_IPE_13 */
    { 0x01ed6c, 0x0117b8, 0x0117b8,  27,  -5354,   9,  27 }, /* VERR_IEM_REG_IPE_12 */
    { 0x01ea8a, 0x011f1a, 0x011f1a,  27,  -5353,   9,  27 }, /* VERR_IEM_REG_IPE_11 */
    { 0x01ea81, 0x011c26, 0x011c26,  27,  -5352,   9,  27 }, /* VERR_IEM_REG_IPE_10 */
    { 0x01ede2, 0x0129e9, 0x0129e9,  26,  -5351,   8,  26 }, /* VERR_IEM_REG_IPE_9 */
    { 0x01edf2, 0x012793, 0x012793,  26,  -5350,   8,  26 }, /* VERR_IEM_REG_IPE_8 */
    { 0x01f122, 0x012c8d, 0x012c8d,  26,  -5349,   8,  26 }, /* VERR_IEM_REG_IPE_7 */
    { 0x01eda2, 0x0124bb, 0x0124bb,  26,  -5348,   8,  26 }, /* VERR_IEM_REG_IPE_6 */
    { 0x01edaa, 0x0128ff, 0x0128ff,  26,  -5347,   8,  26 }, /* VERR_IEM_REG_IPE_5 */
    { 0x01edb2, 0x012897, 0x012897,  26,  -5346,   8,  26 }, /* VERR_IEM_REG_IPE_4 */
    { 0x01edc2, 0x0120c5, 0x0120c5,  26,  -5345,   8,  26 }, /* VERR_IEM_REG_IPE_3 */
    { 0x01edba, 0x012ad3, 0x012ad3,  26,  -5344,   8,  26 }, /* VERR_IEM_REG_IPE_2 */
    { 0x01ea81, 0x01268f, 0x01268f,  26,  -5343,   8,  26 }, /* VERR_IEM_REG_IPE_1 */
    { 0x013b81, 0x010447, 0x010447,  29,  -5341,  25,  29 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR */
    { 0x013861, 0x010cc0, 0x010cc0,  28,  -5340,  25,  28 }, /* VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP */
    { 0x01e70c, 0x01d222, 0x01d222,  13,  -5339,  10,  13 }, /* VERR_IEM_LABEL_IPE_6 */
    { 0x01e716, 0x01d4b9, 0x01d4b9,  13,  -5338,  10,  13 }, /* VERR_IEM_LABEL_IPE_5 */
    { 0x01e720, 0x01d589, 0x01d589,  13,  -5337,  10,  13 }, /* VERR_IEM_LABEL_IPE_4 */
    { 0x01e72a, 0x01d027, 0x01d027,  13,  -5336,  10,  13 }, /* VERR_IEM_LABEL_IPE_3 */
    { 0x01e766, 0x01d777, 0x01d777,  13,  -5335,  10,  13 }, /* VERR_IEM_LABEL_IPE_2 */
    { 0x01e752, 0x01d403, 0x01d403,  13,  -5334,  10,  13 }, /* VERR_IEM_LABEL_IPE_1 */
    { 0x016ec7, 0x01be5a, 0x01be5a,  15,  -5333,  21,  15 }, /* VERR_IEM_LABEL_OUT_OF_MEMORY */
    { 0x01d2cb, 0x01e612, 0x01e612,  10,  -5332,  13,  10 }, /* VERR_IEM_LABEL_TOO_MANY */
    { 0x013ab9, 0x00e214, 0x00e214,  32,  -5331,  25,  32 }, /* VERR_IEM_INSTR_BUF_OUT_OF_MEMORY */
    { 0x0196df, 0x0177a5, 0x0177a5,  20,  -5330,  18,  20 }, /* VERR_IEM_INSTR_BUF_TOO_LARGE */
    { 0x00e6af, 0x00a8f7, 0x00a8f7,  40,  -5329,  31,  40 }, /* VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL */
    { 0x016cba, 0x01bd3d, 0x01bd3d,  15,  -5328,  21,  15 }, /* VERR_IEM_FIXUP_OUT_OF_MEMORY */
    { 0x01d729, 0x01e946, 0x01e946,  10,  -5327,  13,  10 }, /* VERR_IEM_FIXUP_TOO_MANY */
    { 0x01e5b8, 0x01d2a4, 0x01d2a4,  13,  -5326,  10,  13 }, /* VERR_IEM_FIXUP_IPE_1 */
    { 0x01d9d0, 0x019d7a, 0x019d7a,  18,  -5325,  12,  18 }, /* VERR_IEM_DBGINFO_IPE_2 */
    { 0x01d9dc, 0x01a122, 0x01a122,  18,  -5324,  12,  18 }, /* VERR_IEM_DBGINFO_IPE_1 */
    { 0x0151bf, 0x01217b, 0x01217b,  26,  -5323,  23,  26 }, /* VERR_IEM_DBGINFO_OUT_OF_MEMORY */
    { 0x00fbe6, 0x009d4e, 0x009d4e,  42,  -5322,  29,  42 }, /* VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED */
    { 0x016bfd, 0x01008b, 0x01008b,  29,  -5321,  21,  29 }, /* VERR_IEM_COND_TOO_DEEPLY_NESTED */
    { 0x01df57, 0x00ea32, 0x00ea32,  31,  -5320,  12,  31 }, /* VERR_IEM_TB_ALLOC_FAILED */
    { 0x01be78, 0x00e633, 0x00e633,  31,  -5304,  15,  31 }, /* VERR_IEM_INVALID_INSTR_LENGTH */
    { 0x01e608, 0x009555, 0x009555,  43,  -5303,  10,  43 }, /* VERR_IEM_INVALID_EFF_SEG */
    { 0x01be69, 0x00c547, 0x00c547,  36,  -5302,  15,  36 }, /* VERR_IEM_INVALID_ADDRESS_MODE */
    { 0x01c175, 0x00e194, 0x00e194,  32,  -5301,  15,  32 }, /* VERR_IEM_INVALID_OPERAND_SIZE */
    { 0x017efd, 0x0131d6, 0x0131d6,  25,  -5300,  20,  25 }, /* VERR_IEM_INSTR_NOT_IMPLEMENTED */
    { 0x011103, 0x008138, 0x008138,  48,  -5205,  28,  48 }, /* VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED */
    { 0x01effa, 0x01cdfa, 0x01cdfa,  14,  -5204,   8,  14 }, /* VERR_GVMM_IPE_2 */
    { 0x01f002, 0x01cf4a, 0x01cf4a,  14,  -5203,   8,  14 }, /* VERR_GVMM_IPE_1 */
    { 0x01a9b3, 0x00dfd4, 0x00dfd4,  32,  -5202,  17,  32 }, /* VERR_GVMM_BROKEN_IPRT */
    { 0x0177cd, 0x009c28, 0x009c28,  42,  -5201,  20,  42 }, /* VERR_GVMM_HOST_CPU_RANGE */
    { 0x01ce78, 0x011458, 0x011458,  27,  -5200,  14,  27 }, /* VERR_GVMM_INSTANCE */
    { 0x00eaae, 0x003aa0, 0x003aa0,  81,  -5102,  31,  22 }, /* VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING */
    { 0x017b29, 0x003f75, 0x003f75,  75,  -5101,  20,  19 }, /* VERR_PCI_PASSTHROUGH_NO_HM */
    { 0x00f0d4, 0x003af1, 0x003af1,  79,  -5100,  30,  17 }, /* VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC */
    { 0x01759d, 0x00eecc, 0x00eecc,  31,  -5003,  20,  31 }, /* VERR_FAM_CONNECTION_LOST */
    { 0x014275, 0x00dff4, 0x00dff4,  32,  -5002,  24,  32 }, /* VERR_FAM_MONITOR_DIRECTORY_FAILED */
    { 0x018a37, 0x00e074, 0x00e074,  32,  -5001,  19,  32 }, /* VERR_FAM_MONITOR_FILE_FAILED */
    { 0x01e166, 0x01401d, 0x01401d,  24,  -5000,  11,  24 }, /* VERR_FAM_OPEN_FAILED */
    { 0x01bd6a, 0x01a672, 0x01a672,  17,  -4904,  15,  17 }, /* VERR_VSCSI_LUN_BUSY */
    { 0x018029, 0x012dd5, 0x012dd5,  25,  -4903,  20,  25 }, /* VERR_VSCSI_LUN_NOT_ATTACHED */
    { 0x019697, 0x01c418, 0x01c418,  15,  -4902,  18,  15 }, /* VERR_VSCSI_LUN_INVALID */
    { 0x0100ff, 0x00b5b4, 0x00b5b4,  38,  -4901,  29,  38 }, /* VERR_VSCSI_LUN_ATTACHED_TO_DEVICE */
    { 0x019cb5, 0x01ef1a, 0x01ef1a,   8,  -4900,  18,   8 }, /* VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED */
    { 0x00ac61, 0x006c7b, 0x006c7b,  54,  -4700,  39,  54 }, /* VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST */
    { 0x01ce6a, 0x007794, 0x007794,  50,  -4698,  14,  50 }, /* VERR_COM_OBJECT_NOT_FOUND */
    { 0x01d6f5, 0x00bf83, 0x00bf83,  36,  -4697,  13,  36 }, /* VERR_COM_INVALID_VM_STATE */
    { 0x01f0b2, 0x00d87f, 0x00d87f,  33,  -4696,   8,  33 }, /* VERR_COM_VM_ERROR */
    { 0x01e31e, 0x00b412, 0x00b412,  38,  -4695,  11,  38 }, /* VERR_COM_FILE_ERROR */
    { 0x01e0ab, 0x01f485, 0x01f485,   6,  -4694,  11,   6 }, /* VERR_COM_IPRT_ERROR */
    { 0x01f1c1, 0x01205d, 0x01205d,  26,  -4693,   7,  26 }, /* VERR_COM_PDM_ERROR */
    { 0x019d9e, 0x017128, 0x017128,  21,  -4692,  18,  21 }, /* VERR_COM_INVALID_OBJECT_STATE */
    { 0x01dfe5, 0x00ee6f, 0x00ee6f,  31,  -4691,  11,  31 }, /* VERR_COM_HOST_ERROR */
    { 0x01f17b, 0x01cb14, 0x01cb14,  14,  -4690,   7,  14 }, /* VERR_COM_NOT_SUPPORTED */
    { 0x01e860, 0x01f467, 0x01f467,   6,  -4689,  10,   6 }, /* VERR_COM_XML_ERROR */
    { 0x018d41, 0x010f97, 0x010f97,  28,  -4688,  19,  28 }, /* VERR_COM_INVALID_SESSION_STATE */
    { 0x01a1b2, 0x013f45, 0x013f45,  24,  -4687,  18,  24 }, /* VERR_COM_OBJECT_IN_USE */
    { 0x017ba1, 0x00351d, 0x00351d,  85,  -4686,  20,  85 }, /* VERR_COM_DONT_CALL_AGAIN */
    { 0x01c535, 0x01cc56, 0x01cc56,  14,  -4600,  15,  14 }, /* VERR_COM_UNEXPECTED */
    { 0x01c562, 0x00e6ed, 0x00e6ed,  31,  -4304,  15,  31 }, /* VERR_WEB_UNSUPPORTED_INTERFACE */
    { 0x01c445, 0x013929, 0x013929,  25,  -4303,  15,  25 }, /* VERR_WEB_INVALID_OBJECT_ID */
    { 0x01b58d, 0x00db74, 0x00db74,  32,  -4302,  16,  32 }, /* VERR_WEB_INVALID_SESSION_ID */
    { 0x00f296, 0x010ca4, 0x010ca4,  28,  -4301,  30,  28 }, /* VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE */
    { 0x018e4b, 0x00972e, 0x00972e,  43,  -4300,  19,  43 }, /* VERR_WEB_NOT_AUTHENTICATED */
    { 0x01b05d, 0x01ead2, 0x01ead2,   9,  -4206,  16,   9 }, /* VERR_DIS_TOO_LONG_INSTR */
    { 0x01bfe0, 0x01ab7e, 0x01ab7e,  17,  -4204,  15,  17 }, /* VERR_DIS_INVALID_PARAMETER */
    { 0x01e49f, 0x01ef8a, 0x01ef8a,   8,  -4203,  11,   8 }, /* VERR_DIS_INVALID_MODRM */
    { 0x018421, 0x01c229, 0x01c229,  15,  -4202,  19,  15 }, /* VERR_DIS_NO_READ_CALLBACK */
    { 0x01b6fd, 0x010b8c, 0x010b8c,  28,  -4201,  16,  28 }, /* VERR_DIS_GEN_FAILURE */
    { 0x01dc1c, 0x01b3bd, 0x01b3bd,  16,  -4200,  12,  16 }, /* VERR_DIS_INVALID_OPCODE */
    { 0x01c4f9, 0x01d507, 0x01d507,  13,  -4116,  15,  13 }, /* VERR_HM_INVALID_HM64ON32OP */
    { 0x01f437, 0x01dfc3, 0x01dfc3,  12,  -4115,   6,  12 }, /* VERR_HM_IPE_5 */
    { 0x01f43d, 0x01dcdc, 0x01dcdc,  12,  -4114,   6,  12 }, /* VERR_HM_IPE_4 */
    { 0x01f455, 0x01db74, 0x01db74,  12,  -4113,   6,  12 }, /* VERR_HM_IPE_3 */
    { 0x0162a0, 0x013a0a, 0x013a0a,  25,  -4112,  22,  25 }, /* VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO */
    { 0x0187ea, 0x01ae7b, 0x01ae7b,  17,  -4111,  19,  17 }, /* VERR_HM_UNKNOWN_IO_INSTRUCTION */
    { 0x019781, 0x012cdb, 0x012cdb,  25,  -4110,  18,  25 }, /* VERR_HM_WRONG_SWITCHER */
    { 0x01f443, 0x01daa8, 0x01daa8,  12,  -4109,   6,  12 }, /* VERR_HM_IPE_2 */
    { 0x01f44f, 0x01d874, 0x01d874,  12,  -4108,   6,  12 }, /* VERR_HM_IPE_1 */
    { 0x01d30c, 0x00e014, 0x00e014,  32,  -4107,  13,  32 }, /* VERR_HM_WRONG_CPU */
    { 0x0161da, 0x00e0d4, 0x00e0d4,  32,  -4106,  22,  32 }, /* VERR_HM_NO_32_TO_64_SWITCHER */
    { 0x01c92a, 0x011157, 0x011157,  28,  -4105,  14,  28 }, /* VERR_HM_UNEXPECTED_LD_ST_MSR */
    { 0x01b0ed, 0x01cf74, 0x01cf74,  14,  -4104,  16,  14 }, /* VERR_HM_ALREADY_ENABLED_IPE */
    { 0x01db38, 0x013ca5, 0x013ca5,  24,  -4103,  12,  24 }, /* VERR_HM_CONFIG_MISMATCH */
    { 0x0191a2, 0x00d0f1, 0x00d0f1,  34,  -4100,  19,  34 }, /* VERR_HM_SUSPEND_PENDING */
    { 0x017b79, 0x00f1c4, 0x00f1c4,  30,  -4073,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_3 */
    { 0x017bf1, 0x00f5fc, 0x00f5fc,  30,  -4072,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_2 */
    { 0x017bb5, 0x00f7be, 0x00f7be,  30,  -4071,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_1 */
    { 0x017b8d, 0x00f890, 0x00f890,  30,  -4070,  20,  30 }, /* VERR_SVM_VMRUN_PRECOND_0 */
    { 0x01d791, 0x00939e, 0x00939e,  44,  -4066,  13,  44 }, /* VERR_SVM_VMEXIT_FAILED */
    { 0x01f15f, 0x01e7f2, 0x01e7f2,  10,  -4065,   7,  10 }, /* VERR_SVM_IPE_5 */
    { 0x01f166, 0x01ea0e, 0x01ea0e,  10,  -4064,   7,  10 }, /* VERR_SVM_IPE_4 */
    { 0x01f182, 0x01e540, 0x01e540,  10,  -4063,   7,  10 }, /* VERR_SVM_IPE_3 */
    { 0x01f189, 0x01e64e, 0x01e64e,  10,  -4062,   7,  10 }, /* VERR_SVM_IPE_2 */
    { 0x01f197, 0x01e914, 0x01e914,  10,  -4061,   7,  10 }, /* VERR_SVM_IPE_1 */
    { 0x01e950, 0x01467d, 0x01467d,  24,  -4060,  10,  24 }, /* VERR_SVM_UNKNOWN_EXIT */
    { 0x01a92b, 0x00fdb6, 0x00fdb6,  29,  -4059,  17,  29 }, /* VERR_SVM_INVALID_GUEST_STATE */
    { 0x01b9ad, 0x01b46d, 0x01b46d,  16,  -4058,  16,  16 }, /* VERR_SVM_UNEXPECTED_PATCH_TYPE */
    { 0x01c1b1, 0x017769, 0x017769,  20,  -4057,  15,  20 }, /* VERR_SVM_UNEXPECTED_XCPT_EXIT */
    { 0x01e8d8, 0x01e5c2, 0x01e5c2,  10,  -4056,  10,  10 }, /* VERR_SVM_UNEXPECTED_EXIT */
    { 0x01e032, 0x01f20e, 0x01f20e,   7,  -4055,  11,   7 }, /* VERR_SVM_INVALID_PVMCB */
    { 0x01e069, 0x011d19, 0x011d19,  27,  -4054,  11,  27 }, /* VERR_SVM_IN_USE */
    { 0x01d28a, 0x00ade7, 0x00ade7,  39,  -4053,  13,  39 }, /* VERR_SVM_DISABLED */
    { 0x01eaed, 0x00ef0a, 0x00ef0a,  31,  -4052,   9,  31 }, /* VERR_SVM_NO_SVM */
    { 0x017224, 0x010a58, 0x010a58,  28,  -4051,  21,  28 }, /* VERR_SVM_ILLEGAL_EFER_MSR */
    { 0x01612a, 0x0179c1, 0x0179c1,  20,  -4050,  22,  20 }, /* VERR_SVM_UNABLE_TO_START_VM */
    { 0x016090, 0x00e3b4, 0x00e3b4,  32,  -4042,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_3 */
    { 0x01607a, 0x00dc94, 0x00dc94,  32,  -4041,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_2 */
    { 0x015baa, 0x00e274, 0x00e274,  32,  -4040,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_1 */
    { 0x015c2e, 0x00df74, 0x00df74,  32,  -4039,  22,  32 }, /* VERR_VMX_STARTVM_PRECOND_0 */
    { 0x015277, 0x012231, 0x012231,  26,  -4038,  23,  26 }, /* VERR_VMX_INVALID_VMCS_LAUNCH_STATE */
    { 0x01d5fe, 0x01b2dd, 0x01b2dd,  16,  -4034,  13,  16 }, /* VERR_VMX_VMEXIT_FAILED */
    { 0x01cd8a, 0x01df33, 0x01df33,  12,  -4033,  14,  12 }, /* VERR_VMX_VMENTRY_FAILED */
    { 0x01326c, 0x00595c, 0x00595c,  59,  -4032,  25,  59 }, /* VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED */
    { 0x0166e7, 0x0067f5, 0x0067f5,  56,  -4031,  21,  56 }, /* VERR_VMX_MSR_VMX_ENABLE_FAILED */
    { 0x01006e, 0x01395b, 0x01395b,  25,  -4030,  29,  25 }, /* VERR_VMX_VMCS_FIELD_CACHE_INVALID */
    { 0x016f06, 0x00f110, 0x00f110,  30,  -4029,  21,  30 }, /* VERR_VMX_MSR_VMX_DISABLED */
    { 0x01363b, 0x0064e5, 0x0064e5,  56,  -4028,  25,  56 }, /* VERR_VMX_MSR_ALL_VMX_DISABLED */
    { 0x01f2d2, 0x01e810, 0x01e810,  10,  -4027,   7,  10 }, /* VERR_VMX_IPE_5 */
    { 0x01f2d9, 0x01e888, 0x01e888,  10,  -4026,   7,  10 }, /* VERR_VMX_IPE_4 */
    { 0x01f2e0, 0x01e6da, 0x01e6da,  10,  -4025,   7,  10 }, /* VERR_VMX_IPE_3 */
    { 0x01f2e7, 0x01e6f8, 0x01e6f8,  10,  -4024,   7,  10 }, /* VERR_VMX_IPE_2 */
    { 0x01f2ee, 0x01e856, 0x01e856,  10,  -4023,   7,  10 }, /* VERR_VMX_IPE_1 */
    { 0x0137e4, 0x00a6c7, 0x00a6c7,  40,  -4022,  25,  40 }, /* VERR_VMX_INVALID_VMCS_PTR_TO_START_VM */
    { 0x01ce4e, 0x00a2a5, 0x00a2a5,  41,  -4021,  14,  41 }, /* VERR_VMX_VMPTRLD_FAILED */
    { 0x013e9d, 0x019f96, 0x019f96,  18,  -4019,  24,  18 }, /* VERR_VMX_UNDEFINED_EXIT_CODE */
    { 0x0160bc, 0x007c76, 0x007c76,  49,  -4018,  22,  49 }, /* VERR_VMX_NOT_IN_VMX_ROOT_MODE */
    { 0x01095c, 0x0142a5, 0x0142a5,  24,  -4017,  28,  24 }, /* VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE */
    { 0x01c12a, 0x01d000, 0x01d000,  13,  -4016,  15,  13 }, /* VERR_VMX_UNEXPECTED_EXCEPTION */
    { 0x01e6ee, 0x01f00a, 0x01f00a,   8,  -4015,  10,   8 }, /* VERR_VMX_UNEXPECTED_EXIT */
    { 0x01adc0, 0x01a9f7, 0x01a9f7,  17,  -4014,  17,  17 }, /* VERR_VMX_INVALID_GUEST_STATE */
    { 0x019e9a, 0x010017, 0x010017,  29,  -4013,  18,  29 }, /* VERR_VMX_MSR_LOCKING_FAILED */
    { 0x013622, 0x009108, 0x009108,  45,  -4012,  25,  45 }, /* VERR_VMX_X86_CR4_VMXE_CLEARED */
    { 0x01677a, 0x00611d, 0x00611d,  57,  -4011,  21,  57 }, /* VERR_VMX_IN_VMX_ROOT_MODE */
    { 0x01eadb, 0x00aef8, 0x00aef8,  39,  -4009,   9,  39 }, /* VERR_VMX_NO_VMX */
    { 0x01b22d, 0x017263, 0x017263,  21,  -4006,  16,  21 }, /* VERR_VMX_INVALID_HOST_STATE */
    { 0x015dba, 0x0179c1, 0x0179c1,  20,  -4005,  22,  20 }, /* VERR_VMX_UNABLE_TO_START_VM */
    { 0x01bc20, 0x01bffe, 0x01bffe,  15,  -4004,  15,  15 }, /* VERR_VMX_INVALID_VMXON_PTR */
    { 0x01d492, 0x003e46, 0x003e46,  76,  -4003,  13,  76 }, /* VERR_VMX_RESERVED */
    { 0x003e81, 0x00d333, 0x00d333,  34,  -4002,  16,  34 }, /* VERR_VMX_INVALID_VMCS_FIELD */
    { 0x003e71, 0x008845, 0x008845,  47,  -4001,  14,  14 }, /* VERR_VMX_INVALID_VMCS_PTR */
    { 0x01da24, 0x00a9e7, 0x00a9e7,  40,  -4000,  12,  40 }, /* VERR_VMX_VMXON_FAILED */
    { 0x01c7be, 0x007d3a, 0x007d3a,  49,  -3907,  14,  49 }, /* VERR_GVM_MISMATCH_SVN_REV */
    { 0x018abb, 0x00adc0, 0x00adc0,  39,  -3906,  19,  39 }, /* VERR_GVM_MISMATCH_VM_STRUCT_VER */
    { 0x01ac8e, 0x00962c, 0x00962c,  43,  -3905,  17,  43 }, /* VERR_GVM_MISMATCH_VMCPU_SIZE */
    { 0x01d3f6, 0x00ad4b, 0x00ad4b,  39,  -3904,  13,  39 }, /* VERR_GVM_MISMATCH_VM_SIZE */
    { 0x01c724, 0x012299, 0x012299,  26,  -3900,  14,  26 }, /* VERR_GVM_TOO_MANY_VMS */
    { 0x00e594, 0x008b00, 0x008b00,  46,  -3831,  32,  46 }, /* VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE */
    { 0x013f75, 0x00f3c2, 0x00f3c2,  30,  -3830,  24,  30 }, /* VERR_GMM_BAD_SHARED_MODULE_SIZE */
    { 0x016d0e, 0x019e40, 0x019e40,  18,  -3829,  21,  18 }, /* VERR_GMM_SHARED_MODULE_NOT_FOUND */
    { 0x00e374, 0x0048ed, 0x0048ed,  68,  -3828,  32,  68 }, /* VERR_GMM_SHARED_MODULE_ADDRESS_CLASH */
    { 0x01369f, 0x015d4c, 0x015d4c,  22,  -3826,  25,  22 }, /* VERR_GMM_TOO_MANY_GLOBAL_MODULES */
    { 0x013c2d, 0x015d4c, 0x015d4c,  22,  -3825,  24,  22 }, /* VERR_GMM_TOO_MANY_PER_VM_MODULES */
    { 0x0196f1, 0x012ca7, 0x012ca7,  26,  -3824,  18,  26 }, /* VERR_GMM_TOO_MANY_REGIONS */
    { 0x01337f, 0x01404d, 0x01404d,  24,  -3823,  25,  24 }, /* VERR_GMM_MODULE_VERSION_TOO_LONG */
    { 0x01578b, 0x0150ab, 0x0150ab,  23,  -3822,  22,  23 }, /* VERR_GMM_MODULE_NAME_TOO_LONG */
    { 0x0171e5, 0x00bbaa, 0x00bbaa,  37,  -3821,  21,  37 }, /* VERR_GMM_ACTUAL_PAGES_IPE */
    { 0x018169, 0x01b5dd, 0x01b5dd,  16,  -3820,  20,  16 }, /* VERR_GMM_ALLOC_PAGES_IPE */
    { 0x01c716, 0x01cf04, 0x01cf04,  14,  -3819,  14,  14 }, /* VERR_GMM_MTX_FLAGS */
    { 0x01d23c, 0x014dcb, 0x014dcb,  23,  -3818,  13,  23 }, /* VERR_GMM_INSTANCE */
    { 0x01acd2, 0x0153e7, 0x0153e7,  23,  -3817,  17,  23 }, /* VERR_GMM_CHUNK_INSERT */
    { 0x01d57c, 0x017f75, 0x017f75,  20,  -3816,  13,  20 }, /* VERR_GMM_IS_NOT_SANE */
    { 0x00e254, 0x002c12, 0x002c12,  98,  -3815,  32,  98 }, /* VERR_GMM_MEMORY_RESERVATION_DECLINED */
    { 0x013a6e, 0x00b626, 0x00b626,  38,  -3814,  25,  38 }, /* VERR_GMM_TOO_MANY_CHUNK_MAPPINGS */
    { 0x0192b9, 0x006d89, 0x006d89,  54,  -3813,  18,  54 }, /* VERR_GMM_CHUNK_NOT_MAPPED */
    { 0x01950b, 0x00ee31, 0x00ee31,  31,  -3812,  18,  31 }, /* VERR_GMM_CHUNK_ALREADY_MAPPED */
    { 0x01d6db, 0x01e4aa, 0x01e4aa,  11,  -3811,  13,  11 }, /* VERR_GMM_CHUNK_NOT_FOUND */
    { 0x01b38d, 0x00a2ce, 0x00a2ce,  41,  -3810,  16,  41 }, /* VERR_GMM_NOT_PAGE_OWNER */
    { 0x01c3be, 0x01a1c4, 0x01a1c4,  18,  -3809,  15,  18 }, /* VERR_GMM_PAGE_ALREADY_FREE */
    { 0x01a63f, 0x010c88, 0x010c88,  28,  -3808,  17,  28 }, /* VERR_GMM_PAGE_NOT_SHARED */
    { 0x01a242, 0x00fc5a, 0x00fc5a,  29,  -3807,  18,  29 }, /* VERR_GMM_PAGE_NOT_PRIVATE */
    { 0x01dc04, 0x016022, 0x016022,  22,  -3806,  12,  22 }, /* VERR_GMM_PAGE_NOT_FOUND */
    { 0x010342, 0x00b4f6, 0x00b4f6,  38,  -3805,  29,  38 }, /* VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH */
    { 0x012383, 0x0083d8, 0x0083d8,  48,  -3804,  26,  48 }, /* VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH */
    { 0x01425d, 0x0155ca, 0x0155ca,  23,  -3803,  24,  23 }, /* VERR_GMM_HIT_VM_ACCOUNT_LIMIT */
    { 0x017239, 0x002dfb, 0x002dfb,  97,  -3802,  21,  29 }, /* VERR_GMM_HIT_GLOBAL_LIMIT */
    { 0x019f60, 0x00c07f, 0x00c07f,  36,  -3801,  18,  36 }, /* VERR_GMM_OUT_OF_MEMORY */
    { 0x01763d, 0x00a2f7, 0x00a2f7,  41,  -3778,  20,  41 }, /* VERR_SUPLIB_UNEXPECTED_INSTRUCTION */
    { 0x0174c1, 0x007a1e, 0x007a1e,  50,  -3777,  20,  50 }, /* VERR_SUPLIB_TEXT_NOT_SEALED */
    { 0x01511e, 0x013e6d, 0x013e6d,  24,  -3776,  23,  24 }, /* VERR_SUPLIB_TEXT_NOT_WRITEABLE */
    { 0x00f9f8, 0x010978, 0x010978,  28,  -3775,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5 */
    { 0x00f99e, 0x0111c7, 0x0111c7,  28,  -3774,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4 */
    { 0x00f980, 0x010ae4, 0x010ae4,  28,  -3773,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3 */
    { 0x00f818, 0x010748, 0x010748,  28,  -3772,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2 */
    { 0x00f03e, 0x010eef, 0x010eef,  28,  -3771,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1 */
    { 0x00f002, 0x0108b4, 0x0108b4,  28,  -3770,  30,  28 }, /* VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0 */
    { 0x013735, 0x00a69f, 0x00a69f,  40,  -3769,  25,  40 }, /* VERR_SUPLIB_INVALID_INTERNAL_APP_DIR */
    { 0x01528e, 0x009baa, 0x009baa,  42,  -3768,  23,  42 }, /* VERR_SUPLIB_INVALID_ARGV0_INTERNAL */
    { 0x0157e3, 0x017191, 0x017191,  21,  -3767,  22,  21 }, /* VERR_SUPLIB_WORLD_WRITABLE */
    { 0x011cfe, 0x008a48, 0x008a48,  46,  -3766,  27,  46 }, /* VERR_SUPLIB_WRITE_NON_SYS_GROUP */
    { 0x019026, 0x01c2dd, 0x01c2dd,  15,  -3765,  19,  15 }, /* VERR_SUPLIB_OWNER_NOT_ROOT */
    { 0x0177f5, 0x00f32c, 0x00f32c,  30,  -3764,  20,  30 }, /* VERR_SUPLIB_NOT_SAME_OBJECT */
    { 0x01c517, 0x01d42a, 0x01d42a,  13,  -3763,  15,  13 }, /* VERR_SUPLIB_IS_FILE */
    { 0x0178d1, 0x01d6c1, 0x01d6c1,  13,  -3762,  20,  13 }, /* VERR_SUPLIB_IS_DIRECTORY */
    { 0x01a18e, 0x00d003, 0x00d003,  34,  -3761,  18,  34 }, /* VERR_SUPLIB_NOT_DIR_NOT_FILE */
    { 0x00ea8f, 0x00f14c, 0x00f14c,  30,  -3760,  31,  30 }, /* VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED */
    { 0x01bca7, 0x013172, 0x013172,  25,  -3759,  15,  25 }, /* VERR_SUPLIB_FSTAT_FAILED */
    { 0x01c820, 0x0185d6, 0x0185d6,  19,  -3758,  14,  19 }, /* VERR_SUPLIB_STAT_FAILED */
    { 0x018b53, 0x00b2bc, 0x00b2bc,  38,  -3757,  19,  38 }, /* VERR_SUPLIB_STAT_ENUM_FAILED */
    { 0x01949f, 0x01caea, 0x01caea,  14,  -3756,  18,  14 }, /* VERR_SUPLIB_DIR_ENUM_FAILED */
    { 0x01830d, 0x01d4c6, 0x01d4c6,  13,  -3755,  20,  13 }, /* VERR_SUPLIB_PATH_IS_ROOT */
    { 0x00fed8, 0x01948d, 0x01948d,  18,  -3754,  29,  18 }, /* VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS */
    { 0x0184b9, 0x01dd8f, 0x01dd8f,  12,  -3753,  19,  12 }, /* VERR_SUPLIB_PATH_TOO_SHORT */
    { 0x0194e7, 0x01e187, 0x01e187,  11,  -3752,  18,  11 }, /* VERR_SUPLIB_PATH_TOO_LONG */
    { 0x018d67, 0x01d844, 0x01d844,  12,  -3751,  19,  12 }, /* VERR_SUPLIB_PATH_NOT_CLEAN */
    { 0x015ff6, 0x01bbc6, 0x01bbc6,  15,  -3750,  22,  15 }, /* VERR_SUPLIB_PATH_NOT_ABSOLUTE */
    { 0x0163ea, 0x009ec8, 0x009ec8,  42,  -3749,  22,  42 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2 */
    { 0x015825, 0x009aae, 0x009aae,  42,  -3748,  22,  42 }, /* VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1 */
    { 0x0111ab, 0x008c42, 0x008c42,  46,  -3747,  28,  46 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY */
    { 0x01da78, 0x01168f, 0x01168f,  27,  -3745,  12,  27 }, /* VERR_SUPDRV_TSC_READ_FAILED */
    { 0x013d35, 0x011e42, 0x011e42,  27,  -3744,  24,  27 }, /* VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED */
    { 0x013aa0, 0x00b11a, 0x00b11a,  38,  -3743,  25,  38 }, /* VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x016f5a, 0x00d2ef, 0x00d2ef,  34,  -3742,  21,  34 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE */
    { 0x01e676, 0x0070e3, 0x0070e3,  53,  -3741,  10,  53 }, /* VERR_SUPDRV_CSRSS_NOT_FOUND */
    { 0x013d65, 0x00b832, 0x00b832,  37,  -3740,  24,  37 }, /* VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR */
    { 0x016f5a, 0x00fa33, 0x00fa33,  29,  -3739,  16,  29 }, /* VERR_SUPDRV_APIPORT_OPEN_ERROR */
    { 0x015471, 0x003096, 0x003096,  93,  -3738,  23,  93 }, /* VERR_SUPDRV_HARDENING_EVIL_HANDLE */
    { 0x011093, 0x009081, 0x009081,  45,  -3737,  28,  45 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD */
    { 0x0132d0, 0x00a253, 0x00a253,  41,  -3736,  25,  41 }, /* VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG */
    { 0x012523, 0x005d47, 0x005d47,  58,  -3735,  26,  58 }, /* VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES */
    { 0x01500a, 0x005fc5, 0x005fc5,  58,  -3734,  23,  58 }, /* VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT */
    { 0x01beff, 0x00f52a, 0x00f52a,  30,  -3733,  15,  30 }, /* VERR_SUPDRV_TRACER_TOO_LARGE */
    { 0x014695, 0x00869e, 0x00869e,  47,  -3732,  24,  47 }, /* VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS */
    { 0x018b07, 0x01b64d, 0x01b64d,  16,  -3731,  19,  16 }, /* VERR_SUPDRV_TRACER_BAD_ARG_FLAGS */
    { 0x0134dd, 0x00ba5d, 0x00ba5d,  37,  -3730,  25,  37 }, /* VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF */
    { 0x016ce4, 0x0096d8, 0x0096d8,  43,  -3729,  21,  43 }, /* VERR_SUPDRV_TRACER_SESSION_BUSY */
    { 0x0198c5, 0x01885c, 0x01885c,  19,  -3728,  18,  19 }, /* VERR_SUPDRV_TRACER_UNLOADING */
    { 0x01a50d, 0x015191, 0x015191,  23,  -3727,  17,  23 }, /* VERR_SUPDRV_TRACER_NOT_PRESENT */
    { 0x01b43d, 0x019433, 0x019433,  18,  -3726,  16,  18 }, /* VERR_SUPDRV_TRACER_NOT_OPENED */
    { 0x01b24d, 0x00fe64, 0x00fe64,  29,  -3725,  16,  29 }, /* VERR_SUPDRV_TRACER_ALREADY_OPENED */
    { 0x017bc9, 0x00d9a8, 0x00d9a8,  33,  -3724,  20,  33 }, /* VERR_SUPDRV_TRACER_NOT_REGISTERED */
    { 0x017e35, 0x014db4, 0x014db4,  23,  -3723,  20,  23 }, /* VERR_SUPDRV_TRACER_ALREADY_REGISTERED */
    { 0x0118fc, 0x00f278, 0x00f278,  30,  -3722,  27,  30 }, /* VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION */
    { 0x01aa6e, 0x00e2f4, 0x00e2f4,  32,  -3721,  17,  32 }, /* VERR_SUPDRV_VTG_ALREADY_REGISTERED */
    { 0x01b73d, 0x011581, 0x011581,  27,  -3720,  16,  27 }, /* VERR_SUPDRV_VTG_BAD_PROBE_LOC */
    { 0x017651, 0x0144b5, 0x0144b5,  24,  -3719,  20,  24 }, /* VERR_SUPDRV_VTG_BAD_PROBE_ENABLED */
    { 0x01ca26, 0x00f962, 0x00f962,  30,  -3718,  14,  30 }, /* VERR_SUPDRV_VTG_BAD_ARGLIST */
    { 0x017651, 0x015dfc, 0x015dfc,  22,  -3717,  12,  22 }, /* VERR_SUPDRV_VTG_BAD_PROBE */
    { 0x01bb5d, 0x012ecf, 0x012ecf,  25,  -3716,  15,  25 }, /* VERR_SUPDRV_VTG_BAD_PROVIDER */
    { 0x01e0c1, 0x01ba8d, 0x01ba8d,  16,  -3715,  11,  16 }, /* VERR_SUPDRV_VTG_BAD_ATTR */
    { 0x0199e5, 0x01dd47, 0x01dd47,  12,  -3714,  18,  12 }, /* VERR_SUPDRV_VTG_STRING_TOO_LONG */
    { 0x01d0c3, 0x01d8e0, 0x01d8e0,  12,  -3713,  13,  12 }, /* VERR_SUPDRV_VTG_BAD_STRING */
    { 0x01b2cd, 0x01cd7c, 0x01cd7c,  14,  -3712,  16,  14 }, /* VERR_SUPDRV_VTG_STRTAB_OFF */
    { 0x018231, 0x00e652, 0x00e652,  31,  -3711,  20,  31 }, /* VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE */
    { 0x01b72d, 0x01bd1f, 0x01bd1f,  15,  -3710,  16,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH */
    { 0x01bc2f, 0x01c6de, 0x01c6de,  14,  -3709,  15,  14 }, /* VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW */
    { 0x01ccc6, 0x01be87, 0x01be87,  15,  -3708,  14,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_PTR */
    { 0x01c6ec, 0x01be87, 0x01be87,  15,  -3707,  14,  15 }, /* VERR_SUPDRV_VTG_BAD_HDR_OFF */
    { 0x01bd01, 0x01d39b, 0x01d39b,  13,  -3706,  15,  13 }, /* VERR_SUPDRV_VTG_BAD_HDR_MISC */
    { 0x01e9be, 0x01b5cd, 0x01b5cd,  16,  -3705,  10,  16 }, /* VERR_SUPDRV_VTG_BITS */
    { 0x01e502, 0x01d970, 0x01d970,  12,  -3704,  11,  12 }, /* VERR_SUPDRV_VTG_MAGIC */
    { 0x0167b9, 0x018b79, 0x018b79,  19,  -3703,  21,  19 }, /* VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX */
    { 0x01da30, 0x019000, 0x019000,  19,  -3702,  12,  19 }, /* VERR_SUPDRV_SERVICE_NOT_FOUND */
    { 0x01c97e, 0x00b18c, 0x00b18c,  38,  -3701,  14,  38 }, /* VERR_SUPDRV_INTERFACE_NOT_SUPPORTED */
    { 0x01c882, 0x015bec, 0x015bec,  22,  -3700,  14,  22 }, /* VERR_SUPDRV_COMPONENT_NOT_FOUND */
    { 0x010dd7, 0x013bcc, 0x013bcc,  25,  -3611,  28,  25 }, /* VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND */
    { 0x00fa8a, 0x00ddf4, 0x00ddf4,  32,  -3610,  29,  32 }, /* VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED */
    { 0x00f61a, 0x00aed1, 0x00aed1,  39,  -3609,  30,  39 }, /* VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND */
    { 0x014a4a, 0x00918e, 0x00918e,  44,  -3608,  23,  44 }, /* VERR_INTNET_FLT_VNIC_OPEN_FAILED */
    { 0x014fae, 0x007c12, 0x007c12,  50,  -3607,  23,  50 }, /* VERR_INTNET_FLT_VNIC_INIT_FAILED */
    { 0x011fa1, 0x0084c8, 0x0084c8,  47,  -3606,  27,  47 }, /* VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND */
    { 0x0139a6, 0x008c70, 0x008c70,  46,  -3605,  25,  46 }, /* VERR_INTNET_FLT_VNIC_CREATE_FAILED */
    { 0x012c3f, 0x004797, 0x004797,  69,  -3604,  26,  69 }, /* VERR_INTNET_INCOMPATIBLE_FLAGS */
    { 0x012627, 0x007924, 0x007924,  50,  -3603,  26,  50 }, /* VERR_INTNET_INCOMPATIBLE_TRUNK */
    { 0x01b3ed, 0x007d09, 0x007d09,  49,  -3602,  16,  49 }, /* VERR_INTNET_FLT_IF_FAILED */
    { 0x01905f, 0x007561, 0x007561,  52,  -3601,  19,  52 }, /* VERR_INTNET_FLT_IF_BUSY */
    { 0x01ab3a, 0x00d9c9, 0x00d9c9,  33,  -3600,  17,  33 }, /* VERR_INTNET_FLT_IF_NOT_FOUND */
    { 0x01a551, 0x00edd4, 0x00edd4,  31,  -3504,  17,  31 }, /* VERR_VGA_GL_SYMBOL_NOT_FOUND */
    { 0x0181a5, 0x00b4aa, 0x00b4aa,  38,  -3503,  20,  38 }, /* VERR_VGA_GL_LOAD_FAILURE */
    { 0x010cdc, 0x008ffa, 0x008ffa,  45,  -3502,  28,  45 }, /* VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE */
    { 0x01adf3, 0x00400a, 0x00400a,  74,  -3500,  17,  30 }, /* VERR_VGA_INVALID_CUSTOM_MODE */
    { 0x0115b7, 0x00395c, 0x00395c,  81,  -3408,  27,  32 }, /* VERR_VUSB_USB_DEVICE_PERMISSION */
    { 0x0136b8, 0x00ae0e, 0x00ae0e,  39,  -3407,  25,  39 }, /* VERR_VUSB_DEVICE_IS_SUSPENDED */
    { 0x012d26, 0x00c0c7, 0x00c0c7,  36,  -3406,  25,  36 }, /* VERR_VUSB_DEVICE_IS_RESETTING */
    { 0x015749, 0x00395c, 0x003a4f,  81,  -3405,  22,  32 }, /* VERR_VUSB_USBFS_PERMISSION */
    { 0x0178bd, 0x010f27, 0x010f27,  28,  -3404,  20,  28 }, /* VERR_VUSB_DEVICE_NAME_NOT_FOUND */
    { 0x01808d, 0x002cd6, 0x002cd6,  98,  -3403,  20,  35 }, /* VERR_VUSB_FAILED_TO_QUEUE_URB */
    { 0x01a793, 0x0190d1, 0x0190d1,  19,  -3402,  17,  19 }, /* VERR_VUSB_NO_URB_MEMORY */
    { 0x0162f8, 0x00ab27, 0x00ab27,  40,  -3401,  22,  40 }, /* VERR_VUSB_DEVICE_NOT_ATTACHED */
    { 0x01d904, 0x002a1e, 0x002a1e, 101,  -3400,  12,  25 }, /* VERR_VUSB_NO_PORTS */
    { 0x01d5f1, 0x018979, 0x018979,  19,  -3302,  13,  19 }, /* VERR_VBGL_IOCTL_FAILED */
    { 0x01e284, 0x00dc34, 0x00dc34,  32,  -3301,  11,  32 }, /* VERR_VBGL_INVALID_ADDR */
    { 0x019f06, 0x015fca, 0x015fca,  22,  -3300,  18,  22 }, /* VERR_VBGL_NOT_INITIALIZED */
    { 0x01d673, 0x01cf9e, 0x01cf9e,  14,  -3290,  13,  14 }, /* VERR_VD_SHRINK_NOT_SUPPORTED */
    { 0x014005, 0x00e2d4, 0x00e2d4,  32,  -3289,  24,  26 }, /* VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG */
    { 0x011e5d, 0x00cd7d, 0x00cd7d,  34,  -3288,  27,  34 }, /* VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL */
    { 0x01419d, 0x011566, 0x011566,  27,  -3287,  24,  27 }, /* VERR_VD_RAW_SIZE_MODULO_2048 */
    { 0x01559c, 0x012c59, 0x012c59,  26,  -3286,  23,  26 }, /* VERR_VD_RAW_SIZE_MODULO_512 */
    { 0x01724e, 0x009886, 0x009886,  43,  -3285,  21,  43 }, /* VERR_VD_DMG_NOT_FOUND_INSIDE_XAR */
    { 0x018d2e, 0x014cb7, 0x014cb7,  23,  -3284,  19,  23 }, /* VERR_VD_DMG_XML_PARSE_ERROR */
    { 0x016d8c, 0x001d2c, 0x001d2c, 113,  -3282,  21,  49 }, /* VERR_VD_READ_OUT_OF_RANGE */
    { 0x011e0c, 0x008f19, 0x008f19,  45,  -3281,  27,  45 }, /* VERR_VD_IMAGE_REPAIR_IMPOSSIBLE */
    { 0x018e5e, 0x01c00d, 0x01c00d,  15,  -3280,  19,  15 }, /* VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED */
    { 0x018823, 0x00cf7b, 0x00cf7b,  34,  -3279,  19,  34 }, /* VERR_VD_IMAGE_CORRUPTED */
    { 0x01cd44, 0x01663f, 0x01663f,  21,  -3278,  14,  21 }, /* VERR_VD_DISCARD_NOT_SUPPORTED */
    { 0x012641, 0x00c9f4, 0x00c9f4,  35,  -3277,  26,  35 }, /* VERR_VD_DISCARD_ALIGNMENT_NOT_MET */
    { 0x01702c, 0x0123b7, 0x0123b7,  26,  -3276,  21,  26 }, /* VERR_VD_CACHE_NOT_UP_TO_DATE */
    { 0x01dae4, 0x00f5de, 0x00f5de,  30,  -3275,  12,  30 }, /* VERR_VD_CACHE_NOT_FOUND */
    { 0x01a298, 0x00e234, 0x00e234,  32,  -3274,  17,  32 }, /* VERR_VD_CACHE_ALREADY_EXISTS */
    { 0x01cc02, 0x0058e4, 0x0058e4,  60,  -3273,  14,  60 }, /* VERR_VD_IOCTX_HALT */
    { 0x0179fd, 0x008228, 0x008228,  48,  -3272,  20,  48 }, /* VERR_VD_NOT_ENOUGH_METADATA */
    { 0x01d08f, 0x01d16c, 0x01d16c,  13,  -3271,  13,  13 }, /* VERR_VD_RAW_INVALID_TYPE */
    { 0x01bfef, 0x01ebd7, 0x01ebd7,   9,  -3270,  15,   9 }, /* VERR_VD_RAW_INVALID_HEADER */
    { 0x01c1a2, 0x01ea9c, 0x01ea9c,   9,  -3267,  15,   9 }, /* VERR_VD_DMG_INVALID_HEADER */
    { 0x016a2f, 0x019169, 0x019169,  19,  -3265,  21,  19 }, /* VERR_VD_PARALLELS_INVALID_HEADER */
    { 0x01c20b, 0x01ec5e, 0x01ec5e,   9,  -3260,  15,   9 }, /* VERR_VD_VHD_INVALID_HEADER */
    { 0x012a51, 0x00c77e, 0x00c77e,  35,  -3253,  26,  35 }, /* VERR_VD_ISCSI_SECRET_ENCRYPTED */
    { 0x01bc11, 0x014b75, 0x014b75,  23,  -3252,  15,  23 }, /* VERR_VD_ISCSI_INVALID_TYPE */
    { 0x01b26d, 0x00d3db, 0x00d3db,  33,  -3251,  16,  33 }, /* VERR_VD_ISCSI_INVALID_STATE */
    { 0x01ace3, 0x009759, 0x009759,  43,  -3250,  17,  18 }, /* VERR_VD_ISCSI_INVALID_HEADER */
    { 0x01c4ae, 0x0157b7, 0x0157b7,  22,  -3245,  15,  22 }, /* VERR_VD_VMDK_INVALID_WRITE */
    { 0x01b16d, 0x00cac6, 0x00cac6,  35,  -3244,  16,  35 }, /* VERR_VD_VMDK_INVALID_FORMAT */
    { 0x01bf59, 0x00e4f4, 0x00e4f4,  32,  -3243,  15,  32 }, /* VERR_VD_VMDK_INVALID_STATE */
    { 0x01af58, 0x0193a3, 0x0193a3,  18,  -3242,  17,  18 }, /* VERR_VD_VMDK_VALUE_NOT_FOUND */
    { 0x01a3a8, 0x0121e3, 0x0121e3,  26,  -3241,  17,  26 }, /* VERR_VD_VMDK_UNSUPPORTED_VERSION */
    { 0x01b40d, 0x01e842, 0x01e842,  10,  -3240,  16,  10 }, /* VERR_VD_VMDK_INVALID_HEADER */
    { 0x01745b, 0x01b60d, 0x01b60d,  16,  -3233,  21,  16 }, /* VERR_VD_VDI_COMMENT_TOO_LONG */
    { 0x01b65d, 0x012e9d, 0x012e9d,  25,  -3232,  16,  25 }, /* VERR_VD_VDI_UNSUPPORTED_VERSION */
    { 0x01a0da, 0x0117ee, 0x0117ee,  27,  -3231,  18,  27 }, /* VERR_VD_VDI_INVALID_SIGNATURE */
    { 0x01bc4d, 0x01eb50, 0x01eb50,   9,  -3230,  15,   9 }, /* VERR_VD_VDI_INVALID_HEADER */
    { 0x01bfc2, 0x01118f, 0x01118f,  28,  -3220,  15,  13 }, /* VERR_VD_GEN_INVALID_HEADER */
    { 0x015eac, 0x00926a, 0x00926a,  44,  -3215,  22,  44 }, /* VERR_VD_PASSWORD_INCORRECT */
    { 0x01c2ec, 0x00ed58, 0x00ed58,  31,  -3214,  15,  31 }, /* VERR_VD_DEK_MISSING */
    { 0x01c74e, 0x007491, 0x007491,  52,  -3213,  14,  19 }, /* VERR_VD_UNKNOWN_INTERFACE */
    { 0x01c139, 0x006390, 0x006390,  57,  -3212,  15,  24 }, /* VERR_VD_UNKNOWN_CFG_VALUES */
    { 0x01ea93, 0x0114c4, 0x0114c4,  27,  -3211,   9,  27 }, /* VERR_VD_INVALID_SIZE */
    { 0x0144fd, 0x00dcb4, 0x00dcb4,  32,  -3210,  24,  32 }, /* VERR_VD_ASYNC_IO_IN_PROGRESS */
    { 0x01e900, 0x005abe, 0x005abe,  59,  -3208,  10,  59 }, /* VERR_VD_UUID_MISMATCH */
    { 0x01cb92, 0x01ae04, 0x01ae04,  17,  -3207,  14,  17 }, /* VERR_VD_BLOCK_FREE */
    { 0x01aa2a, 0x01720f, 0x01720f,  21,  -3206,  17,  21 }, /* VERR_VD_GEOMETRY_NOT_SET */
    { 0x018ccf, 0x01da3c, 0x01da3c,  12,  -3205,  19,  12 }, /* VERR_VD_IMAGE_READ_ONLY */
    { 0x01db5c, 0x017ca5, 0x017ca5,  20,  -3204,  12,  20 }, /* VERR_VD_IMAGE_NOT_FOUND */
    { 0x01e2c6, 0x01bb6c, 0x01bb6c,  15,  -3203,  11,  15 }, /* VERR_VD_NOT_OPENED */
    { 0x01dbd4, 0x01af7a, 0x01af7a,  17,  -3202,  12,  17 }, /* VERR_VD_VALUE_NOT_FOUND */
    { 0x01e5d6, 0x00af6d, 0x00af6d,  39,  -3201,  10,  39 }, /* VERR_VD_INVALID_STATE */
    { 0x01ec55, 0x01f254, 0x01f254,   7,  -3200,   9,   7 }, /* VERR_VD_INVALID_TYPE */
    { 0x01cac0, 0x008c14, 0x008c14,  46,  -3105,  14,  46 }, /* VERR_HOSTIF_TERM_FAILED */
    { 0x013cd5, 0x00361c, 0x00361c,  84,  -3104,  24,  84 }, /* VERR_HOSTIF_FD_AND_INIT_TERM */
    { 0x01b1cd, 0x006e97, 0x006e97,  54,  -3103,  16,  54 }, /* VERR_HOSTIF_BLOCKING */
    { 0x01d555, 0x008584, 0x008584,  47,  -3102,  13,  47 }, /* VERR_HOSTIF_IOCTL */
    { 0x012da3, 0x00c253, 0x00c253,  36,  -3101,  25,  36 }, /* VERR_HOSTIF_DEVICE_NAME_TOO_LONG */
    { 0x01cee8, 0x00a468, 0x00a468,  41,  -3100,  14,  41 }, /* VERR_HOSTIF_INIT_FAILED */
    { 0x01b32d, 0x001c49, 0x001c49, 114,  -3002,  16,  36 }, /* VERR_NAT_REDIR_SETUP */
    { 0x0188e1, 0x005cd1, 0x005cd1,  59,  -3001,  19,  42 }, /* VERR_NAT_REDIR_GUEST_IP */
    { 0x013cbd, 0x00df14, 0x00df14,  32,  -2909,  24,  32 }, /* VERR_HGCM_TOO_MANY_CLIENT_CALLS */
    { 0x018a4a, 0x017d81, 0x017d81,  20,  -2908,  19,  20 }, /* VERR_HGCM_TOO_MANY_CLIENTS */
    { 0x0175d9, 0x012bd7, 0x012bd7,  26,  -2907,  20,  26 }, /* VERR_HGCM_SERVICE_EXISTS */
    { 0x01b01d, 0x01b06d, 0x01b06d,  16,  -2905,  16,  16 }, /* VERR_HGCM_INVALID_CLIENT_ID */
    { 0x01cbe6, 0x011380, 0x011380,  27,  -2904,  14,  27 }, /* VERR_HGCM_INTERNAL */
    { 0x0195d1, 0x0139f1, 0x0139f1,  25,  -2902,  18,  25 }, /* VERR_HGCM_INVALID_CMD_ADDRESS */
    { 0x01b77d, 0x01231b, 0x01231b,  26,  -2900,  16,  26 }, /* VERR_HGCM_SERVICE_NOT_FOUND */
    { 0x015bd6, 0x01ca42, 0x01ca42,  14,  -2899,  22,  14 }, /* VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE */
    { 0x017a89, 0x01d8bc, 0x01d8bc,  12,  -2897,  20,  12 }, /* VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND */
    { 0x01282f, 0x017c7d, 0x017c7d,  20,  -2896,  26,  20 }, /* VERR_PDM_MEDIAEX_IOREQID_CONFLICT */
    { 0x013f8d, 0x00ce8d, 0x00ce8d,  34,  -2895,  24,  34 }, /* VERR_PDM_MEDIAEX_IOBUF_UNDERRUN */
    { 0x0147cd, 0x00d9ea, 0x00d9ea,  33,  -2894,  24,  33 }, /* VERR_PDM_MEDIAEX_IOBUF_OVERFLOW */
    { 0x0144e5, 0x01b2fd, 0x01b2fd,  16,  -2893,  24,  16 }, /* VERR_PDM_MEDIAEX_IOREQ_CANCELED */
    { 0x01efda, 0x006b32, 0x006b32,  55,  -2892,   8,  55 }, /* VERR_PDM_HM_IPE */
    { 0x01a95e, 0x004eec, 0x004eec,  65,  -2891,  17,  65 }, /* VERR_PDM_NOT_PCI_BUS_MASTER */
    { 0x00d525, 0x007118, 0x007118,  53,  -2890,  33,  53 }, /* VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER */
    { 0x00d0cf, 0x00e8be, 0x00e8be,  31,  -2889,  34,  31 }, /* VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION */
    { 0x01ef32, 0x01d326, 0x01d326,  13,  -2888,   8,  13 }, /* VERR_PDM_DEV_IPE_1 */
    { 0x01d7c5, 0x01865b, 0x01865b,  19,  -2887,  13,  19 }, /* VERR_PDM_BAD_PCI_CONFIG */
    { 0x00fb55, 0x00acaf, 0x00acaf,  39,  -2886,  29,  39 }, /* VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE */
    { 0x01e36b, 0x017ccd, 0x017ccd,  20,  -2885,  11,  20 }, /* VERR_PDM_THREAD_IPE_2 */
    { 0x01e3b8, 0x017615, 0x017615,  20,  -2884,  11,  20 }, /* VERR_PDM_THREAD_IPE_1 */
    { 0x01b17d, 0x00ae35, 0x00ae35,  39,  -2883,  16,  39 }, /* VERR_PDM_THREAD_INVALID_CALLER */
    { 0x01d082, 0x014f3b, 0x014f3b,  23,  -2882,  13,  23 }, /* VERR_PDM_CRITSECT_NOT_FOUND */
    { 0x01caf8, 0x01afdd, 0x01afdd,  16,  -2881,  14,  16 }, /* VERR_PDM_CRITSECT_IPE */
    { 0x010a20, 0x005f17, 0x005f17,  58,  -2880,  28,  58 }, /* VERR_PDM_HPET_LEGACY_NOTIFY_MISSING */
    { 0x01549f, 0x00db94, 0x00db94,  32,  -2879,  23,  32 }, /* VERR_PDM_DEV_HEAP_R3_TO_GCPHYS */
    { 0x019d8c, 0x000eb8, 0x000eb8, 156,  -2878,  18,  13 }, /* VERR_PDM_DRIVER_VERSION_MISMATCH */
    { 0x01a146, 0x000d7a, 0x000d7a, 160,  -2877,  18,  17 }, /* VERR_PDM_USBDEV_VERSION_MISMATCH */
    { 0x019b3b, 0x000f54, 0x000f54, 156,  -2876,  18,  13 }, /* VERR_PDM_DEVICE_VERSION_MISMATCH */
    { 0x018141, 0x000c35, 0x000c35, 163,  -2875,  20,  20 }, /* VERR_PDM_DRVHLPR3_VERSION_MISMATCH */
    { 0x019af3, 0x000901, 0x000901, 165,  -2874,  18,  22 }, /* VERR_PDM_DRVINS_VERSION_MISMATCH */
    { 0x0180c9, 0x0007b4, 0x0007b4, 167,  -2873,  20,  24 }, /* VERR_PDM_USBHLPR3_VERSION_MISMATCH */
    { 0x019c6d, 0x00070b, 0x00070b, 169,  -2872,  18,  26 }, /* VERR_PDM_USBINS_VERSION_MISMATCH */
    { 0x019ee2, 0x000aef, 0x000aef, 163,  -2871,  18,  20 }, /* VERR_PDM_DEVHLP_VERSION_MISMATCH */
    { 0x019d0e, 0x0009a6, 0x0009a6, 165,  -2870,  18,  22 }, /* VERR_PDM_DEVINS_VERSION_MISMATCH */
    { 0x010940, 0x0120ab, 0x0120ab,  26,  -2869,  28,  26 }, /* VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES */
    { 0x01449d, 0x015e6a, 0x015e6a,  22,  -2868,  24,  22 }, /* VERR_PDM_TOO_MANY_DRIVER_INSTANCES */
    { 0x014875, 0x015f5c, 0x015f5c,  22,  -2867,  24,  22 }, /* VERR_PDM_TOO_MANY_DEVICE_INSTANCES */
    { 0x017c05, 0x0027b9, 0x0027b9, 103,  -2866,  20,  59 }, /* VERR_PDM_DRIVER_INVALID_PROPERTIES */
    { 0x00fb72, 0x00c643, 0x00c643,  35,  -2865,  29,  35 }, /* VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED */
    { 0x00fcb1, 0x00caa3, 0x00caa3,  35,  -2864,  29,  35 }, /* VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED */
    { 0x017041, 0x00aeaa, 0x00aeaa,  39,  -2863,  21,  39 }, /* VERR_PDM_ASYNC_TEMPLATE_BUSY */
    { 0x01e4b5, 0x0094a6, 0x0094a6,  44,  -2862,  11,  32 }, /* VERR_PDM_NO_USBPROXY */
    { 0x01d8ec, 0x008a1a, 0x008a1a,  46,  -2861,  12,  46 }, /* VERR_PDM_NO_USB_PORTS */
    { 0x01e08a, 0x00aa87, 0x00aa87,  40,  -2860,  11,  40 }, /* VERR_PDM_NO_USB_HUBS */
    { 0x01b41d, 0x015f9e, 0x015f9e,  22,  -2859,  16,  22 }, /* VERR_PDM_USB_HUB_EXISTS */
    { 0x01b1fd, 0x005baa, 0x005baa,  59,  -2858,  16,  14 }, /* VERR_PDM_USB_NAME_CLASH */
    { 0x0189fe, 0x010f5f, 0x010f5f,  28,  -2857,  19,  28 }, /* VERR_PDM_INVALID_USB_REGISTRATION */
    { 0x01ad6b, 0x002333, 0x002333, 108,  -2856,  17,  40 }, /* VERR_PDM_UNKNOWN_USBREG_VERSION */
    { 0x01cd28, 0x0140c5, 0x0140c5,  24,  -2855,  14,  24 }, /* VERR_PDM_HIF_INVALID_VERSION */
    { 0x0184cc, 0x004523, 0x004523,  70,  -2854,  19,  23 }, /* VERR_PDM_DRIVER_NO_RT_ATTACH */
    { 0x018d8d, 0x0046c7, 0x0046c7,  70,  -2853,  19,  23 }, /* VERR_PDM_DEVICE_NO_RT_ATTACH */
    { 0x01dc88, 0x014b19, 0x014b19,  23,  -2852,  12,  23 }, /* VERR_PDM_HIF_OPEN_FAILED */
    { 0x014992, 0x007dcd, 0x007dcd,  49,  -2851,  23,  49 }, /* VERR_PDM_HIF_SHARING_VIOLATION */
    { 0x01c2a1, 0x0054d9, 0x0054d9,  62,  -2850,  15,  62 }, /* VERR_PDM_NO_RTC_INSTANCE */
    { 0x01b90d, 0x0062e5, 0x0062e5,  57,  -2849,  16,  57 }, /* VERR_PDM_NO_DMAC_INSTANCE */
    { 0x01b9ed, 0x005e2f, 0x005e2f,  58,  -2848,  16,  58 }, /* VERR_PDM_NO_APIC_INSTANCE */
    { 0x01bec3, 0x00658d, 0x00658d,  56,  -2847,  15,  56 }, /* VERR_PDM_NO_PIC_INSTANCE */
    { 0x013b68, 0x008258, 0x008258,  48,  -2846,  25,  48 }, /* VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01eeca, 0x01b9cd, 0x01b9cd,  16,  -2845,   8,  16 }, /* VERR_PDM_LUN_NOT_FOUND */
    { 0x017dd1, 0x018191, 0x018191,  20,  -2844,  20,  20 }, /* VERR_PDM_DRIVER_INSTANCE_NOT_FOUND */
    { 0x01458d, 0x00e9f4, 0x00e9f4,  31,  -2843,  24,  31 }, /* VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND */
    { 0x013dad, 0x0108ec, 0x0108ec,  28,  -2842,  24,  28 }, /* VERR_PDM_DEVICE_INSTANCE_NO_IBASE */
    { 0x017f61, 0x01ca5e, 0x01ca5e,  14,  -2841,  20,  14 }, /* VERR_PDM_DEVICE_INSTANCE_NOT_FOUND */
    { 0x01e0a0, 0x00b166, 0x00b166,  38,  -2840,  11,  10 }, /* VERR_PDM_DEVICE_NOT_FOUND */
    { 0x019214, 0x005af9, 0x005af9,  59,  -2839,  19,  14 }, /* VERR_PDM_DEVICE_NAME_CLASH */
    { 0x018bb2, 0x00fd99, 0x00fd99,  29,  -2838,  19,  29 }, /* VERR_PDM_INVALID_DEVICE_HOST_BITS */
    { 0x017fed, 0x01bb99, 0x01bb99,  15,  -2837,  20,  15 }, /* VERR_PDM_INVALID_DEVICE_GUEST_BITS */
    { 0x0159f3, 0x010f5f, 0x010f5f,  28,  -2836,  22,  28 }, /* VERR_PDM_INVALID_DEVICE_REGISTRATION */
    { 0x01a782, 0x0025b4, 0x0025b4, 104,  -2835,  17,  36 }, /* VERR_PDM_UNKNOWN_DEVREG_VERSION */
    { 0x01d152, 0x003d62, 0x003d62,  76,  -2834,  13,  56 }, /* VERR_PDM_NOT_PCI_DEVICE */
    { 0x01e7ca, 0x002f1c, 0x002f1c,  95,  -2833,  10,  29 }, /* VERR_PDM_NO_PCI_BUS */
    { 0x013460, 0x0030f3, 0x0030f3,  93,  -2832,  25,  51 }, /* VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE */
    { 0x018648, 0x01bb99, 0x01bb99,  15,  -2831,  19,  15 }, /* VERR_PDM_INVALID_DRIVER_HOST_BITS */
    { 0x01628a, 0x010eb7, 0x010eb7,  28,  -2830,  22,  28 }, /* VERR_PDM_INVALID_DRIVER_REGISTRATION */
    { 0x01a5a6, 0x00261c, 0x00261c, 104,  -2829,  17,  36 }, /* VERR_PDM_UNKNOWN_DRVREG_VERSION */
    { 0x018af4, 0x005baa, 0x005baa,  59,  -2828,  19,  14 }, /* VERR_PDM_DRIVER_NAME_CLASH */
    { 0x01899f, 0x01a3fd, 0x01a3fd,  17,  -2827,  19,  17 }, /* VERR_PDM_MODULE_NAME_TOO_LONG */
    { 0x016416, 0x006865, 0x006865,  56,  -2826,  22,  56 }, /* VERR_PDM_NO_REGISTRATION_EXPORT */
    { 0x01917c, 0x00b87c, 0x00b87c,  37,  -2825,  19,  37 }, /* VERR_PDM_MODULE_NAME_CLASH */
    { 0x01e1c9, 0x0026eb, 0x0026eb, 103,  -2823,  11,  21 }, /* VERR_PDM_DRIVER_NOT_FOUND */
    { 0x012d8a, 0x00a10b, 0x00a10b,  41,  -2822,  25,  41 }, /* VERR_PDM_CFG_MISSING_DRIVER_NAME */
    { 0x013b68, 0x00254b, 0x00254b, 105,  -2821,  18, 105 }, /* VERR_PDM_NO_DRIVER_ATTACHED */
    { 0x019739, 0x007b4a, 0x007b4a,  50,  -2820,  18,  50 }, /* VERR_PDM_DRIVER_ALREADY_ATTACHED */
    { 0x01d79e, 0x003418, 0x003418,  87,  -2819,  13,  17 }, /* VERR_PDM_UNSUPPORTED_BLOCK_TYPE */
    { 0x018371, 0x0053e1, 0x0053e1,  62,  -2818,  20,  44 }, /* VERR_PDM_BLOCK_UNKNOWN_TRANSLATION */
    { 0x01d01a, 0x006a8d, 0x006a8d,  55,  -2817,  13,  37 }, /* VERR_PDM_BLOCK_UNKNOWN_TYPE */
    { 0x01d521, 0x0056c6, 0x0056c6,  61,  -2816,  13,  43 }, /* VERR_PDM_BLOCK_NO_TYPE */
    { 0x01ce40, 0x010d68, 0x010d68,  28,  -2815,  14,  28 }, /* VERR_PDM_MEDIA_LOCKED */
    { 0x01bf95, 0x0066dd, 0x0066dd,  56,  -2814,  15,  26 }, /* VERR_PDM_MEDIA_MOUNTED */
    { 0x01b0bd, 0x00931a, 0x00931a,  44,  -2813,  16,  44 }, /* VERR_PDM_MEDIA_NOT_MOUNTED */
    { 0x01a20c, 0x0033c1, 0x0033c1,  87,  -2812,  18,  53 }, /* VERR_PDM_TRANSLATION_NOT_SET */
    { 0x01c436, 0x002820, 0x002820, 102,  -2811,  15,  50 }, /* VERR_PDM_GEOMETRY_NOT_SET */
    { 0x019e76, 0x00240b, 0x00240b, 108,  -2810,  18,  17 }, /* VERR_PDM_NO_ATTACHED_DRIVER */
    { 0x01b09d, 0x001087, 0x001087, 150,  -2809,  16,  38 }, /* VERR_PDM_DEVINS_NO_ATTACH */
    { 0x01b14d, 0x00085b, 0x00085b, 166,  -2808,  16,  46 }, /* VERR_PDM_DRVINS_NO_ATTACH */
    { 0x01ce5c, 0x00b6be, 0x00b6be,  38,  -2807,  14,  38 }, /* VERR_PDM_NO_QUEUE_ITEMS */
    { 0x018577, 0x000a4b, 0x000a4b, 164,  -2806,  19,  39 }, /* VERR_PDM_TOO_PCI_MANY_DEVICES */
    { 0x0179d5, 0x004054, 0x004054,  74,  -2805,  20,   8 }, /* VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES */
    { 0x0137cb, 0x003312, 0x003312,  88,  -2804,  19,  54 }, /* VERR_PDM_MISSING_INTERFACE */
    { 0x0137cb, 0x002d38, 0x002d38,  98,  -2803,  25,  64 }, /* VERR_PDM_MISSING_INTERFACE_BELOW */
    { 0x0137fd, 0x0032b9, 0x0032b9,  89,  -2802,  25,  55 }, /* VERR_PDM_MISSING_INTERFACE_ABOVE */
    { 0x017971, 0x0031ab, 0x0031ab,  91,  -2801,  20,   8 }, /* VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES */
    { 0x01e2d1, 0x00fae1, 0x00fae1,  29,  -2800,  11,  29 }, /* VERR_PDM_NO_SUCH_LUN */
    { 0x0154e4, 0x00e74a, 0x00e74a,  31,  -2721,  23,  31 }, /* VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET */
    { 0x01a62e, 0x016615, 0x016615,  21,  -2720,  17,  21 }, /* VERR_VMM_CANNOT_BLOCK */
    { 0x00ec9e, 0x0050ed, 0x0050ed,  64,  -2719,  31,  64 }, /* VERR_VMM_CONTEXT_HOOK_STILL_ENABLED */
    { 0x0127c7, 0x015da4, 0x015da4,  22,  -2718,  26,  22 }, /* VERR_VMM_WRONG_NEM_VMCPU_STATE */
    { 0x016366, 0x004408, 0x004408,  71,  -2717,  22,  71 }, /* VERR_VMM_SMAP_BUT_AC_CLEAR */
    { 0x012d71, 0x017335, 0x017335,  21,  -2716,  25,  21 }, /* VERR_VMM_WRONG_HM_VMCPU_STATE */
    { 0x019acf, 0x00fb8f, 0x00fb8f,  29,  -2715,  18,  29 }, /* VERR_VMM_SWITCHER_STUB */
    { 0x01b9fd, 0x01a0b6, 0x01a0b6,  18,  -2713,  16,  18 }, /* VERR_VMM_SWITCHER_IPE_1 */
    { 0x01c21a, 0x01c607, 0x01c607,  15,  -2709,  15,  15 }, /* VERR_VMM_LONG_JMP_ERROR */
    { 0x01ac6c, 0x00157e, 0x00157e, 132,  -2705,  17,   7 }, /* VERR_VMM_RC_VERSION_MISMATCH */
    { 0x01a71c, 0x000588, 0x000588, 206,  -2704,  17,   7 }, /* VERR_VMM_R0_VERSION_MISMATCH */
    { 0x0141fd, 0x01072c, 0x01072c,  28,  -2703,  24,  28 }, /* VERR_VMM_RING3_CALL_DISABLED */
    { 0x01b63d, 0x00b754, 0x00b754,  37,  -2702,  16,  37 }, /* VERR_VMM_HYPER_CR3_MISMATCH */
    { 0x0181b9, 0x00bd1c, 0x00bd1c,  37,  -2701,  20,  37 }, /* VERR_VMM_RING0_ASSERTION */
    { 0x016a6e, 0x019325, 0x019325,  18,  -2663,  21,  18 }, /* VERR_IOM_MMIO_REGION_NOT_MAPPED */
    { 0x016bd3, 0x01a1d6, 0x01a1d6,  18,  -2662,  21,  18 }, /* VERR_IOM_MMIO_REGION_ALREADY_MAPPED */
    { 0x01ceda, 0x01e658, 0x01e658,  10,  -2661,  14,  10 }, /* VERR_IOM_INVALID_MMIO_HANDLE */
    { 0x0129cf, 0x019271, 0x019271,  18,  -2660,  26,  18 }, /* VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS */
    { 0x017f4d, 0x015f72, 0x015f72,  22,  -2653,  20,  22 }, /* VERR_IOM_IOPORTS_NOT_MAPPED */
    { 0x017de5, 0x01600c, 0x01600c,  22,  -2652,  20,  22 }, /* VERR_IOM_IOPORTS_ALREADY_MAPPED */
    { 0x018a5d, 0x01aeae, 0x01aeae,  17,  -2651,  19,  17 }, /* VERR_IOM_INVALID_IOPORT_HANDLE */
    { 0x00e8fc, 0x012f1a, 0x012f1a,  25,  -2650,  31,  25 }, /* VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS */
    { 0x0198b3, 0x00f386, 0x00f386,  30,  -2638,  18,  30 }, /* VERR_IOM_FF_STATUS_IPE */
    { 0x01e1ea, 0x00697a, 0x00697a,  55,  -2637,  11,  55 }, /* VERR_IOM_HM_IPE */
    { 0x01eb35, 0x01e3a2, 0x01e3a2,  11,  -2636,   9,  11 }, /* VERR_IOM_MMIO_IPE_3 */
    { 0x01eb1a, 0x01e0d7, 0x01e0d7,  11,  -2635,   9,  11 }, /* VERR_IOM_MMIO_IPE_2 */
    { 0x01eb23, 0x01e4e1, 0x01e4e1,  11,  -2634,   9,  11 }, /* VERR_IOM_MMIO_IPE_1 */
    { 0x01c6a6, 0x0194f9, 0x0194f9,  18,  -2633,  14,  18 }, /* VERR_IOM_IOPORT_IPE_3 */
    { 0x01c6b4, 0x019391, 0x019391,  18,  -2632,  14,  18 }, /* VERR_IOM_IOPORT_IPE_2 */
    { 0x01c6c2, 0x01976f, 0x01976f,  18,  -2631,  14,  18 }, /* VERR_IOM_IOPORT_IPE_1 */
    { 0x0187b1, 0x009054, 0x009054,  45,  -2630,  19,  45 }, /* VERR_IOM_IOPORT_UNKNOWN_OPCODE */
    { 0x01a1fa, 0x004975, 0x004975,  68,  -2614,  18,  68 }, /* VERR_IOM_IOPORT_UNUSED */
    { 0x014964, 0x008438, 0x008438,  48,  -2613,  23,  48 }, /* VERR_IOM_MMIO_HANDLER_DISASM_ERROR */
    { 0x01366d, 0x008eec, 0x008eec,  45,  -2612,  25,  36 }, /* VERR_IOM_MMIO_HANDLER_BOGUS_CALL */
    { 0x01ab18, 0x00deb4, 0x00deb4,  32,  -2611,  17,  32 }, /* VERR_IOM_INVALID_IOPORT_SIZE */
    { 0x014cce, 0x00187e, 0x00187e, 125,  -2610,  23,  23 }, /* VERR_IOM_INCOMPLETE_MMIO_RANGE */
    { 0x01bf4a, 0x01ad5a, 0x01ad5a,  17,  -2609,  15,  17 }, /* VERR_IOM_MMIO_RANGE_NOT_FOUND */
    { 0x0164da, 0x002baf, 0x002baf,  99,  -2608,  21,  33 }, /* VERR_IOM_MMIO_RANGE_CONFLICT */
    { 0x018ef6, 0x002886, 0x002886, 102,  -2607,  19,  34 }, /* VERR_IOM_NOT_MMIO_RANGE_OWNER */
    { 0x01b23d, 0x0034c6, 0x0034c6,  87,  -2606,  16,  45 }, /* VERR_IOM_NO_R3_MMIO_RANGE */
    { 0x01d297, 0x007f24, 0x007f24,  49,  -2605,  13,  14 }, /* VERR_IOM_INVALID_MMIO_RANGE */
    { 0x0142d5, 0x0021ed, 0x0021ed, 109,  -2604,  24,  41 }, /* VERR_IOM_NOT_IOPORT_RANGE_OWNER */
    { 0x017ec1, 0x006715, 0x006715,  56,  -2603,  20,  56 }, /* VERR_IOM_IOPORT_RANGE_NOT_FOUND */
    { 0x0124ef, 0x001cbb, 0x001cbb, 113,  -2602,  26,  40 }, /* VERR_IOM_IOPORT_RANGE_CONFLICT */
    { 0x0169f0, 0x002ebc, 0x002ebc,  96,  -2601,  21,  52 }, /* VERR_IOM_NO_R3_IOPORT_RANGE */
    { 0x019e1c, 0x00651d, 0x00651d,  56,  -2600,  18,  21 }, /* VERR_IOM_INVALID_IOPORT_RANGE */
    { 0x01d8d4, 0x006785, 0x006785,  56,  -2509,  12,  56 }, /* VERR_SELM_HM_IPE */
    { 0x01c508, 0x006cb1, 0x006cb1,  54,  -2508,  15,  54 }, /* VERR_SELM_GDT_TOO_FULL */
    { 0x01b57d, 0x008b5c, 0x008b5c,  46,  -2507,  16,  46 }, /* VERR_SELM_GDT_READ_ERROR */
    { 0x014ce5, 0x010d14, 0x010d14,  28,  -2506,  23,  28 }, /* VERR_SELM_LDT_OUT_OF_BOUNDS */
    { 0x01e982, 0x01bc5c, 0x01bc5c,  15,  -2505,  10,  15 }, /* VERR_SELM_INVALID_LDT */
    { 0x01e77a, 0x018ed0, 0x018ed0,  19,  -2504,  10,  19 }, /* VERR_SELM_NO_TSS */
    { 0x01633a, 0x00225a, 0x00225a, 109,  -2502,  22,  43 }, /* VERR_SELM_SHADOW_TSS_WRITE */
    { 0x015ae4, 0x0020a4, 0x0020a4, 110,  -2501,  22,  43 }, /* VERR_SELM_SHADOW_LDT_WRITE */
    { 0x015b68, 0x001f5a, 0x001f5a, 110,  -2500,  22,  43 }, /* VERR_SELM_SHADOW_GDT_WRITE */
    { 0x01da84, 0x0064ad, 0x0064ad,  56,  -2409,  12,  56 }, /* VERR_TRPM_HM_IPE */
    { 0x01f0f2, 0x01daf0, 0x01daf0,  12,  -2408,   8,  12 }, /* VERR_TRPM_IPE_3 */
    { 0x01f0fa, 0x01d838, 0x01d838,  12,  -2407,   8,  12 }, /* VERR_TRPM_IPE_2 */
    { 0x01f102, 0x01dd3b, 0x01dd3b,  12,  -2406,   8,  12 }, /* VERR_TRPM_IPE_1 */
    { 0x01ae8c, 0x01a61d, 0x01a61d,  17,  -2405,  17,  17 }, /* VERR_TRPM_BAD_TRAP_IN_OP */
    { 0x01e221, 0x017f89, 0x017f89,  20,  -2404,  11,  20 }, /* VERR_TRPM_PANIC */
    { 0x01b99d, 0x00f4b2, 0x00f4b2,  30,  -2403,  16,  30 }, /* VERR_TRPM_DONT_PANIC */
    { 0x015d78, 0x002036, 0x002036, 110,  -2402,  22,  43 }, /* VERR_TRPM_SHADOW_IDT_WRITE */
    { 0x01ac7d, 0x007359, 0x007359,  52,  -2401,  17,  12 }, /* VERR_TRPM_ACTIVE_TRAP */
    { 0x01a230, 0x006d1d, 0x006d1d,  54,  -2400,  18,  13 }, /* VERR_TRPM_NO_ACTIVE_TRAP */
    { 0x01f371, 0x01ec9d, 0x01ec9d,   9,  -2299,   6,   9 }, /* VERR_TM_IPE_9 */
    { 0x01f377, 0x01eb2c, 0x01eb2c,   9,  -2298,   6,   9 }, /* VERR_TM_IPE_8 */
    { 0x01f37d, 0x01ed36, 0x01ed36,   9,  -2297,   6,   9 }, /* VERR_TM_IPE_7 */
    { 0x01f383, 0x01ec4c, 0x01ec4c,   9,  -2296,   6,   9 }, /* VERR_TM_IPE_6 */
    { 0x01f389, 0x01eaf6, 0x01eaf6,   9,  -2295,   6,   9 }, /* VERR_TM_IPE_5 */
    { 0x01f38f, 0x01ec0d, 0x01ec0d,   9,  -2294,   6,   9 }, /* VERR_TM_IPE_4 */
    { 0x01f395, 0x01ebfb, 0x01ebfb,   9,  -2293,   6,   9 }, /* VERR_TM_IPE_3 */
    { 0x01f39b, 0x01ed00, 0x01ed00,   9,  -2292,   6,   9 }, /* VERR_TM_IPE_2 */
    { 0x01f3a1, 0x01ed2d, 0x01ed2d,   9,  -2291,   6,   9 }, /* VERR_TM_IPE_1 */
    { 0x0116c5, 0x00bfa7, 0x00bfa7,  36,  -2214,  27,  36 }, /* VERR_TM_TIMER_QUEUE_CANNOT_GROW */
    { 0x01b9bd, 0x017fd9, 0x017fd9,  20,  -2213,  16,  20 }, /* VERR_TM_INVALID_TIMER_QUEUE */
    { 0x01b81d, 0x013efd, 0x013efd,  24,  -2212,  16,  24 }, /* VERR_TM_TOO_MANY_TIMERS */
    { 0x01563d, 0x01d6e8, 0x01d6e8,  13,  -2211,  23,  13 }, /* VERR_TM_VIRTUAL_TICKING_IPE */
    { 0x01c59e, 0x010c6c, 0x010c6c,  28,  -2210,  15,  28 }, /* VERR_TM_TSC_ALREADY_PAUSED */
    { 0x01b29d, 0x00f638, 0x00f638,  30,  -2209,  16,  30 }, /* VERR_TM_TSC_ALREADY_TICKING */
    { 0x014305, 0x0133e3, 0x0133e3,  25,  -2208,  24,  25 }, /* VERR_TM_TIMER_UNSTABLE_STATE */
    { 0x01b86d, 0x0073c1, 0x0073c1,  52,  -2207,  16,  52 }, /* VERR_TM_TIMER_BAD_CLOCK */
    { 0x010d30, 0x00fd7c, 0x00fd7c,  29,  -2206,  28,  29 }, /* VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG */
    { 0x01bd5b, 0x018e12, 0x018e12,  19,  -2205,  15,  19 }, /* VERR_TM_GIP_VERSION */
    { 0x01b4ad, 0x01b15d, 0x01b15d,  16,  -2204,  16,  16 }, /* VERR_TM_GIP_REQUIRED */
    { 0x019727, 0x005740, 0x005740,  60,  -2203,  18,  60 }, /* VERR_TM_UNSTABLE_STATE */
    { 0x01e644, 0x00a0b9, 0x00a0b9,  41,  -2202,  10,  13 }, /* VERR_TM_UNKNOWN_STATE */
    { 0x01ea3f, 0x013c8d, 0x013c8d,  24,  -2201,  10,  24 }, /* VERR_TM_INVALID_STATE */
    { 0x01cab2, 0x0122cd, 0x0122cd,  26,  -2200,  14,  26 }, /* VERR_TM_LOAD_STATE */
    { 0x01efc2, 0x01d91c, 0x01d91c,  12,  -2165,   8,  12 }, /* VERR_CFGM_IPE_1 */
    { 0x019967, 0x00c6f2, 0x00c6f2,  35,  -2164,  18,  35 }, /* VERR_CFGM_CONFIG_UNKNOWN_NODE */
    { 0x019072, 0x0135a5, 0x0135a5,  25,  -2163,  19,  25 }, /* VERR_CFGM_CONFIG_UNKNOWN_VALUE */
    { 0x01ad8d, 0x007c44, 0x007c44,  50,  -2162,  17,  50 }, /* VERR_CFGM_LEAF_EXISTS */
    { 0x01a397, 0x007b7c, 0x007b7c,  50,  -2161,  17,  50 }, /* VERR_CFGM_NODE_EXISTS */
    { 0x01b7ad, 0x00a947, 0x00a947,  40,  -2160,  16,  40 }, /* VERR_CFGM_INVALID_NODE_PATH */
    { 0x01c643, 0x00b1d8, 0x00b1d8,  38,  -2110,  15,  38 }, /* VERR_CFGM_NOT_PASSWORD */
    { 0x018cf5, 0x006bd7, 0x006bd7,  55,  -2109,  19,  26 }, /* VERR_CFGM_NOT_ENOUGH_SPACE */
    { 0x01db44, 0x019c91, 0x019c91,  18,  -2108,  12,  18 }, /* VERR_CFGM_NOT_BYTES */
    { 0x01d374, 0x00ae5c, 0x00ae5c,  39,  -2107,  13,  39 }, /* VERR_CFGM_NOT_STRING */
    { 0x01c9b6, 0x01d4d3, 0x01d4d3,  13,  -2106,  14,  13 }, /* VERR_CFGM_NOT_INTEGER */
    { 0x01e10e, 0x01a7c6, 0x01a7c6,  17,  -2105,  11,  17 }, /* VERR_CFGM_NO_NODE */
    { 0x01d208, 0x014bba, 0x014bba,  23,  -2104,  13,  23 }, /* VERR_CFGM_NO_PARENT */
    { 0x01c68a, 0x01f11a, 0x01f11a,   8,  -2103,  14,   8 }, /* VERR_CFGM_VALUE_NOT_FOUND */
    { 0x01ac17, 0x00de94, 0x00de94,  32,  -2102,  17,  22 }, /* VERR_CFGM_INVALID_CHILD_PATH */
    { 0x01c740, 0x01ce24, 0x01ce24,  14,  -2101,  14,  14 }, /* VERR_CFGM_CHILD_NOT_FOUND */
    { 0x0196cd, 0x00d0ad, 0x00d0ad,  34,  -2100,  18,  34 }, /* VERR_CFGM_INTEGER_TOO_BIG */
    { 0x0185c3, 0x01987d, 0x01987d,  18,  -2007,  19,  18 }, /* VERR_VRDP_ACCESS_DENIED */
    { 0x01d743, 0x0186e0, 0x0186e0,  19,  -2006,  13,  19 }, /* VERR_VRDP_NO_MEMORY */
    { 0x01e34a, 0x00cf37, 0x00cf37,  34,  -2005,  11,  34 }, /* VERR_VRDP_INVALID_MODE */
    { 0x014bd1, 0x005fff, 0x005fff,  58,  -2004,  23,  58 }, /* VERR_VRDP_INSUFFICIENT_DATA */
    { 0x01edea, 0x01494d, 0x01494d,  23,  -2003,   8,  23 }, /* VERR_VRDP_NOT_SUPPORTED */
    { 0x01b1bd, 0x013ecd, 0x013ecd,  24,  -2002,  16,  24 }, /* VERR_VRDP_PROTOCOL_ERROR */
    { 0x0172a2, 0x00da4d, 0x00da4d,  33,  -2001,  21,  33 }, /* VERR_VRDP_SEC_ENGINE_FAIL */
    { 0x019143, 0x017985, 0x017985,  20,  -2000,  19,  20 }, /* VERR_VRDP_ISO_UNSUPPORTED */
    { 0x01a80a, 0x010034, 0x010034,  29,  -1919,  17,  29 }, /* VERR_VM_REQUEST_KILLED */
    { 0x01be3c, 0x01b7fd, 0x01b7fd,  16,  -1918,  15,  16 }, /* VERR_VM_FATAL_WAIT_ERROR */
    { 0x013b36, 0x00b009, 0x00b009,  39,  -1917,  25,  39 }, /* VERR_VM_REQUEST_TOO_MANY_ARGS_IPE */
    { 0x019715, 0x01d53b, 0x01d53b,  13,  -1916,  18,  13 }, /* VERR_VM_UNEXPECTED_UNSTABLE_STATE */
    { 0x01e027, 0x01b75d, 0x01b75d,  16,  -1915,  11,  16 }, /* VERR_VM_UNEXPECTED_VM_STATE */
    { 0x01b21d, 0x008ad2, 0x008ad2,  46,  -1914,  16,  46 }, /* VERR_VM_THREAD_IS_EMT */
    { 0x0156c5, 0x0079ec, 0x0079ec,  50,  -1913,  22,  33 }, /* VERR_VM_SAVE_STATE_NOT_ALLOWED */
    { 0x01846d, 0x01422d, 0x01422d,  24,  -1912,  19,  24 }, /* VERR_VM_DRIVER_VERSION_MISMATCH */
    { 0x01b6ad, 0x005703, 0x005703,  61,  -1911,  16,  25 }, /* VERR_VM_DRIVER_OPEN_ERROR */
    { 0x01b27d, 0x006156, 0x006156,  57,  -1910,  16,  25 }, /* VERR_VM_DRIVER_LOAD_ERROR */
    { 0x016600, 0x008816, 0x008816,  47,  -1909,  21,  16 }, /* VERR_VM_DRIVER_NOT_ACCESSIBLE */
    { 0x017fc5, 0x0084f7, 0x0084f7,  47,  -1908,  20,  15 }, /* VERR_VM_DRIVER_NOT_INSTALLED */
    { 0x01e33f, 0x008048, 0x008048,  48,  -1907,  11,  10 }, /* VERR_VM_INVALID_VM_STATE */
    { 0x01cb22, 0x003572, 0x003572,  85,  -1906,  14,  50 }, /* VERR_VM_THREAD_NOT_EMT */
    { 0x014a78, 0x003b8f, 0x003b8f,  79,  -1905,  23,  34 }, /* VERR_VM_REQUEST_STATUS_FREED */
    { 0x00ee12, 0x002180, 0x002180, 109,  -1904,  31,  55 }, /* VERR_VM_REQUEST_STATUS_STILL_PENDING */
    { 0x018694, 0x002b4b, 0x002b4b, 100,  -1903,  19,  11 }, /* VERR_VM_REQUEST_INVALID_PACKAGE */
    { 0x01b85d, 0x002112, 0x002112, 110,  -1902,  16,   5 }, /* VERR_VM_REQUEST_STATE */
    { 0x01b1ed, 0x000b92, 0x000b92, 163,  -1901,  16,   9 }, /* VERR_VM_REQUEST_INVALID_TYPE */
    { 0x01d5bd, 0x0118c6, 0x0118c6,  27,  -1900,  13,  27 }, /* VERR_VM_ATRESET_NOT_FOUND */
    { 0x010fb3, 0x01dca0, 0x01dca0,  12,  -1880,  28,  12 }, /* VERR_SSM_ENUM_VALUE_OUT_OF_RANGE */
    { 0x00c7c4, 0x005f51, 0x005f51,  58,  -1879,  35,  58 }, /* VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION */
    { 0x01f334, 0x01da00, 0x01da00,  12,  -1878,   7,  12 }, /* VERR_SSM_IPE_3 */
    { 0x01f33b, 0x01d97c, 0x01d97c,  12,  -1877,   7,  12 }, /* VERR_SSM_IPE_2 */
    { 0x01f342, 0x01dfb7, 0x01dfb7,  12,  -1876,   7,  12 }, /* VERR_SSM_IPE_1 */
    { 0x01c9e0, 0x0103d3, 0x0103d3,  29,  -1875,  14,  29 }, /* VERR_SSM_BAD_REC_TYPE */
    { 0x01d333, 0x0086cd, 0x0086cd,  47,  -1874,  13,  47 }, /* VERR_SSM_MEM_TOO_BIG */
    { 0x0185b0, 0x009784, 0x009784,  43,  -1873,  19,  43 }, /* VERR_SSM_SKIP_BACKWARDS */
    { 0x01e5ae, 0x0092ee, 0x0092ee,  44,  -1872,  10,  44 }, /* VERR_SSM_UNEXPECTED_PASS */
    { 0x01d6ce, 0x01eaff, 0x01eaff,   9,  -1871,  13,   9 }, /* VERR_SSM_STREAM_ERROR */
    { 0x01a694, 0x018f2f, 0x018f2f,  19,  -1870,  17,  19 }, /* VERR_SSM_FIELD_INVALID_VALUE */
    { 0x0142ed, 0x019bdd, 0x019bdd,  18,  -1869,  24,  18 }, /* VERR_SSM_FIELD_INVALID_PADDING_SIZE */
    { 0x017f39, 0x00c133, 0x00c133,  36,  -1868,  20,  36 }, /* VERR_SSM_FIELD_INVALID_CALLBACK */
    { 0x015540, 0x00b72f, 0x00b72f,  37,  -1867,  23,  37 }, /* VERR_SSM_FIELD_NOT_CONSECUTIVE */
    { 0x013e85, 0x0155e1, 0x0155e1,  23,  -1866,  24,  23 }, /* VERR_SSM_FIELD_OUT_OF_BOUNDS */
    { 0x01b4dd, 0x0112a7, 0x0112a7,  28,  -1865,  16,  28 }, /* VERR_SSM_FIELD_INVALID_SIZE */
    { 0x019457, 0x004a85, 0x004a85,  68,  -1864,  18,  49 }, /* VERR_SSM_FIELD_COMPLEX */
    { 0x01a584, 0x005ea3, 0x005ea3,  58,  -1863,  17,  58 }, /* VERR_SSM_LIVE_FATAL_ERROR */
    { 0x01305f, 0x005be5, 0x005be5,  59,  -1862,  25,  59 }, /* VERR_SSM_LIVE_GURU_MEDITATION */
    { 0x016e49, 0x00ca3a, 0x00ca3a,  35,  -1861,  21,  35 }, /* VERR_SSM_LIVE_POWERED_OFF */
    { 0x01c337, 0x01c616, 0x01c616,  15,  -1860,  15,  15 }, /* VERR_SSM_ALREADY_CANCELLED */
    { 0x0149ee, 0x013dc5, 0x013dc5,  24,  -1859,  23,  24 }, /* VERR_SSM_NO_PENDING_OPERATION */
    { 0x01c954, 0x01d270, 0x01d270,  13,  -1858,  14,  13 }, /* VERR_SSM_CANCELLED */
    { 0x01599b, 0x005b6f, 0x005b6f,  59,  -1857,  22,  59 }, /* VERR_SSM_LOW_ON_DISK_SPACE */
    { 0x0181cd, 0x00560f, 0x00560f,  61,  -1856,  20,  61 }, /* VERR_SSM_STATE_GREW_TOO_BIG */
    { 0x01a364, 0x005a83, 0x005a83,  59,  -1855,  17,  59 }, /* VERR_SSM_TOO_MANY_PASSES */
    { 0x015249, 0x01ba4d, 0x01ba4d,  16,  -1853,  23,  16 }, /* VERR_SSM_VOTE_FOR_GIVING_UP */
    { 0x018518, 0x0055d1, 0x0055d1,  62,  -1850,  19,  62 }, /* VERR_SSM_GCPTR_OVERFLOW */
    { 0x018321, 0x005269, 0x005269,  63,  -1849,  20,  63 }, /* VERR_SSM_GCPHYS_OVERFLOW */
    { 0x01ea18, 0x00ce6b, 0x00ce6b,  34,  -1848,  10,  34 }, /* VERR_SSM_UNEXPECTED_DATA */
    { 0x017ed5, 0x016b7f, 0x016b7f,  21,  -1847,  20,  21 }, /* VERR_SSM_STRUCTURE_MAGIC */
    { 0x015bc0, 0x00522a, 0x00522a,  63,  -1846,  22,  63 }, /* VERR_SSM_IDE_ASYNC_TIMEOUT */
    { 0x016ca5, 0x002ae7, 0x002ae7, 100,  -1845,  21,  39 }, /* VERR_SSM_VIRTUAL_CLOCK_HZ */
    { 0x019fba, 0x0013e2, 0x0013e2, 138,  -1844,  18,  26 }, /* VERR_SSM_LOAD_CONFIG_MISMATCH */
    { 0x015163, 0x00a349, 0x00a349,  41,  -1843,  23,  41 }, /* VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH */
    { 0x01a9c4, 0x00111d, 0x00111d, 149,  -1842,  17,  59 }, /* VERR_SSM_LOAD_CPUID_MISMATCH */
    { 0x00fdf0, 0x0024e1, 0x0024e1, 106,  -1841,  29,  26 }, /* VERR_SSM_DATA_UNIT_FORMAT_CHANGED */
    { 0x014aeb, 0x00577c, 0x00577c,  60,  -1840,  23,  15 }, /* VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION */
    { 0x018d54, 0x0107d4, 0x0107d4,  28,  -1833,  19,  28 }, /* VERR_SSM_LOADED_TOO_LITTLE */
    { 0x01e05e, 0x0107d4, 0x0107d4,  28,  -1832,  11,  28 }, /* VERR_SSM_INVALID_STATE */
    { 0x01a265, 0x0062ac, 0x0062ac,  57,  -1831,  17,  57 }, /* VERR_SSM_LOADED_TOO_MUCH */
    { 0x01bc02, 0x0069b1, 0x0069b1,  55,  -1830,  15,  55 }, /* VERR_SSM_NO_LOAD_EXEC */
    { 0x014335, 0x015b3c, 0x015b3c,  22,  -1827,  24,  22 }, /* VERR_SSM_INTEGRITY_DIR_MAGIC */
    { 0x014335, 0x016f6f, 0x016f6f,  21,  -1826,  18,  21 }, /* VERR_SSM_INTEGRITY_DIR */
    { 0x010924, 0x0135d7, 0x0135d7,  25,  -1825,  28,  25 }, /* VERR_SSM_INTEGRITY_DECOMPRESSION */
    { 0x011a91, 0x00df34, 0x00df34,  32,  -1824,  27,  32 }, /* VERR_SSM_INTEGRITY_REC_TERM_CRC */
    { 0x011a91, 0x00f05c, 0x00f05c,  30,  -1823,  23,  30 }, /* VERR_SSM_INTEGRITY_REC_TERM */
    { 0x016484, 0x018ee3, 0x018ee3,  19,  -1822,  22,  19 }, /* VERR_SSM_INTEGRITY_REC_HDR */
    { 0x016933, 0x0199af, 0x0199af,  18,  -1821,  21,  18 }, /* VERR_SSM_INTEGRITY_FOOTER */
    { 0x011ae2, 0x015b10, 0x015b10,  22,  -1820,  27,  22 }, /* VERR_SSM_INTEGRITY_VBOX_VERSION */
    { 0x01646e, 0x00cf59, 0x00cf59,  34,  -1819,  22,  34 }, /* VERR_SSM_INTEGRITY_UNIT_NOT_FOUND */
    { 0x012fb0, 0x010668, 0x010668,  28,  -1818,  25,  28 }, /* VERR_SSM_INTEGRITY_UNIT_MAGIC */
    { 0x012fb0, 0x01abf5, 0x01abf5,  17,  -1817,  19,  17 }, /* VERR_SSM_INTEGRITY_UNIT */
    { 0x01735f, 0x01891a, 0x01891a,  19,  -1816,  21,  19 }, /* VERR_SSM_INTEGRITY_HEADER */
    { 0x0159c7, 0x0116aa, 0x0116aa,  27,  -1815,  22,  27 }, /* VERR_SMM_INTEGRITY_MACHINE */
    { 0x0198e9, 0x012c73, 0x012c73,  26,  -1814,  18,  26 }, /* VERR_SSM_INTEGRITY_CRC */
    { 0x0184df, 0x0123eb, 0x0123eb,  26,  -1813,  19,  26 }, /* VERR_SSM_INTEGRITY_SIZE */
    { 0x015c9c, 0x01d64c, 0x01d64c,  13,  -1812,  22,  13 }, /* VERR_SSM_INTEGRITY_VERSION */
    { 0x0176b5, 0x0105dc, 0x0105dc,  28,  -1811,  20,  28 }, /* VERR_SSM_INTEGRITY_MAGIC */
    { 0x010924, 0x011c5c, 0x011c5c,  27,  -1810,  14,  27 }, /* VERR_SSM_INTEGRITY */
    { 0x01b4cd, 0x00faa7, 0x00faa7,  29,  -1802,  16,  29 }, /* VERR_SSM_UNIT_NOT_OWNER */
    { 0x01db8c, 0x01b8dd, 0x01b8dd,  16,  -1801,  12,  16 }, /* VERR_SSM_UNIT_NOT_FOUND */
    { 0x01bb1d, 0x01bef0, 0x01bef0,  15,  -1800,  16,  15 }, /* VERR_SSM_UNIT_EXISTS */
    { 0x018706, 0x01e522, 0x01e522,  10,  -1771,  19,  10 }, /* VERR_CPUM_UNSUPPORTED_ID_REG_VALUE */
    { 0x0193d9, 0x01a7e8, 0x01a7e8,  17,  -1770,  18,  17 }, /* VERR_CPUM_UNSUPPORTED_ID_REGISTER */
    { 0x013d95, 0x0073f5, 0x0073f5,  52,  -1768,  24,  52 }, /* VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO */
    { 0x0176a1, 0x004eab, 0x004eab,  65,  -1767,  20,  65 }, /* VERR_CPUM_INVALID_HWVIRT_CONFIG */
    { 0x01e43c, 0x014c2d, 0x014c2d,  23,  -1765,  11,  23 }, /* VERR_CPUM_INVALID_XCR0 */
    { 0x01b8fd, 0x01545a, 0x01545a,  23,  -1764,  16,  23 }, /* VERR_CPUM_INVALID_XSAVE_HDR */
    { 0x01583b, 0x00ba38, 0x00ba38,  37,  -1763,  22,  37 }, /* VERR_CPUM_INVALID_XSAVE_COMP_MASK */
    { 0x00d113, 0x0047dc, 0x0047dc,  69,  -1762,  34,  69 }, /* VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK */
    { 0x018810, 0x01ece5, 0x01ece5,   9,  -1761,  19,   9 }, /* VERR_CPUM_INVALID_CONFIG_VALUE */
    { 0x019098, 0x01bde2, 0x01bde2,  15,  -1760,  19,  15 }, /* VERR_TOO_MANY_CPUID_LEAVES */
    { 0x013334, 0x0119ef, 0x0119ef,  27,  -1757,  25,  27 }, /* VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET */
    { 0x01c5da, 0x0103b6, 0x0103b6,  29,  -1756,  15,  29 }, /* VERR_CPUM_DB_CPU_NOT_FOUND */
    { 0x01f042, 0x01e171, 0x01e171,  11,  -1755,   8,  11 }, /* VERR_CPUM_IPE_2 */
    { 0x01f07a, 0x01e192, 0x01e192,  11,  -1754,   8,  11 }, /* VERR_CPUM_IPE_1 */
    { 0x011890, 0x00bb3b, 0x00bb3b,  37,  -1753,  27,  37 }, /* VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES */
    { 0x015de6, 0x0040e8, 0x0040e8,  74,  -1752,  22,  74 }, /* VERR_CPUM_HIDDEN_CS_LOAD_ERROR */
    { 0x013654, 0x00e5f4, 0x00e5f4,  32,  -1751,  25,  32 }, /* VERR_CPUM_INCOMPATIBLE_CONFIG */
    { 0x01b79d, 0x00b45e, 0x00b45e,  38,  -1750,  16,  38 }, /* VERR_CPUM_RAISE_GP_0 */
    { 0x019d56, 0x00985b, 0x00985b,  43,  -1702,  18,  43 }, /* VERR_MM_BAD_TRAP_TYPE_IPE */
    { 0x01ad49, 0x014425, 0x014425,  24,  -1701,  17,  24 }, /* VERR_MM_HYPER_NO_MEMORY */
    { 0x01b35d, 0x005997, 0x005997,  59,  -1700,  16,  59 }, /* VERR_MM_RAM_CONFLICT */
    { 0x019685, 0x01d3e9, 0x01d3e9,  13,  -1692,  18,  13 }, /* VERR_PGM_TOO_MANY_ROM_RANGES */
    { 0x0172cc, 0x00e690, 0x00e690,  31,  -1691,  21,  31 }, /* VERR_PGM_PHYS_RAM_LOOKUP_IPE */
    { 0x019b17, 0x01d0b6, 0x01d0b6,  13,  -1690,  18,  13 }, /* VERR_PGM_TOO_MANY_RAM_RANGES */
    { 0x01a562, 0x00bbcf, 0x00bbcf,  37,  -1689,  17,  37 }, /* VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE */
    { 0x01be1e, 0x008fcd, 0x008fcd,  45,  -1688,  15,  45 }, /* VERR_PGM_PAE_PDPE_RSVD */
    { 0x01ce16, 0x01691e, 0x01691e,  21,  -1687,  14,  21 }, /* VERR_PGM_SHW_NONE_IPE */
    { 0x01e8ec, 0x01ee5a, 0x01ee5a,   8,  -1686,  10,   8 }, /* VERR_PGM_MODE_IPE */
    { 0x01c157, 0x007325, 0x007325,  52,  -1685,  15,  52 }, /* VERR_PGM_PHYS_MMIO_EX_IPE */
    { 0x01350f, 0x008bb8, 0x008bb8,  46,  -1684,  25,  46 }, /* VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE */
    { 0x0182f9, 0x01c0a3, 0x01c0a3,  15,  -1683,  20,  15 }, /* VERR_PGM_TOO_MANY_MMIO2_RANGES */
    { 0x01446d, 0x01455d, 0x01455d,  24,  -1682,  24,  24 }, /* VERR_PGM_PCI_PASSTHRU_MISCONFIG */
    { 0x0162cc, 0x00b95a, 0x00b95a,  37,  -1681,  22,  37 }, /* VERR_PGM_PHYS_NULL_PAGE_PARAM */
    { 0x018b66, 0x01504f, 0x01504f,  23,  -1680,  19,  23 }, /* VERR_PGM_PHYS_PAGE_GET_IPE */
    { 0x014b8c, 0x013366, 0x013366,  25,  -1679,  23,  25 }, /* VERR_PGM_WRITE_MONITOR_ENGAGED */
    { 0x01e66c, 0x01ddcb, 0x01ddcb,  12,  -1678,  10,  12 }, /* VERR_PGM_POOL_IPE */
    { 0x014665, 0x00a27c, 0x00a27c,  41,  -1677,  24,  41 }, /* VERR_PGM_POOL_MAXED_OUT_ALREADY */
    { 0x01d813, 0x015a61, 0x015a61,  22,  -1676,  13,  22 }, /* VERR_PGM_MAPPING_IPE */
    { 0x0197ff, 0x0114fa, 0x0114fa,  27,  -1675,  18,  27 }, /* VERR_PGM_POOL_TOO_MANY_LOOPS */
    { 0x0195bf, 0x014eb1, 0x014eb1,  23,  -1674,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_4 */
    { 0x0195f5, 0x0152bc, 0x0152bc,  23,  -1673,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_3 */
    { 0x019619, 0x014ff3, 0x014ff3,  23,  -1672,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_2 */
    { 0x019607, 0x015232, 0x015232,  23,  -1671,  18,  23 }, /* VERR_PGM_PHYS_PAGE_MAP_IPE_1 */
    { 0x01a16a, 0x011731, 0x011731,  27,  -1670,  18,  27 }, /* VERR_PGM_PHYS_HANDLER_IPE */
    { 0x01ddd7, 0x00cfbf, 0x00cfbf,  34,  -1669,  12,  34 }, /* VERR_PGM_INVALID_PDPE_ADDR */
    { 0x01e381, 0x00c7a1, 0x00c7a1,  35,  -1668,  11,  35 }, /* VERR_PGM_INVALID_CR3_ADDR */
    { 0x01c067, 0x00541f, 0x00541f,  62,  -1667,  15,  62 }, /* VERR_PGM_NOT_USED_IN_MODE */
    { 0x01a909, 0x016cf9, 0x016cf9,  21,  -1666,  17,  21 }, /* VERR_PGM_POOL_GET_PAGE_FAILED */
    { 0x01c938, 0x01d3a8, 0x01d3a8,  13,  -1665,  14,  13 }, /* VERR_PGM_PML4_MAPPING */
    { 0x01b3fd, 0x0121af, 0x0121af,  26,  -1664,  16,  26 }, /* VERR_PGM_HANDY_PAGE_IPE */
    { 0x01de4f, 0x013d1d, 0x013d1d,  24,  -1663,  12,  24 }, /* VERR_PGM_DYNMAP_IPE */
    { 0x01b44d, 0x01c3a0, 0x01c3a0,  15,  -1662,  16,  15 }, /* VERR_PGM_SAVED_REC_TYPE */
    { 0x01717c, 0x00d245, 0x00d245,  34,  -1661,  21,  34 }, /* VERR_PGM_SAVED_ROM_PAGE_PROT */
    { 0x018c96, 0x00ed39, 0x00ed39,  31,  -1660,  19,  31 }, /* VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND */
    { 0x017a61, 0x00e788, 0x00e788,  31,  -1659,  20,  31 }, /* VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND */
    { 0x016d4d, 0x00d4c2, 0x00d4c2,  33,  -1658,  21,  33 }, /* VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND */
    { 0x016064, 0x00d6b1, 0x00d6b1,  33,  -1657,  22,  33 }, /* VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND */
    { 0x01d38e, 0x01413d, 0x01413d,  24,  -1656,  13,  24 }, /* VERR_PGM_UNEXPECTED_PAGE_STATE */
    { 0x01a540, 0x01476d, 0x01476d,  24,  -1655,  17,  24 }, /* VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE */
    { 0x018ce2, 0x01ed09, 0x01ed09,   9,  -1654,  19,   9 }, /* VERR_PGM_INVALID_SAVED_PAGE_STATE */
    { 0x01cfac, 0x013910, 0x013910,  25,  -1653,  14,  25 }, /* VERR_PGM_MAPPINGS_SMP */
    { 0x018dd9, 0x0107b8, 0x0107b8,  28,  -1652,  19,  28 }, /* VERR_PGM_MAPPINGS_DISABLED */
    { 0x019085, 0x00762f, 0x00762f,  51,  -1651,  19,  51 }, /* VERR_PGM_MAP_MMIO2_ALIAS_MMIO */
    { 0x01dd17, 0x01479d, 0x01479d,  24,  -1647,  12,  24 }, /* VERR_PGM_HANDLER_IPE_1 */
    { 0x0167ce, 0x00cc6a, 0x00cc6a,  35,  -1646,  21,  35 }, /* VERR_PGM_PHYS_PAGE_BALLOONED */
    { 0x018c24, 0x015ed8, 0x015ed8,  22,  -1645,  19,  22 }, /* VERR_PGM_INVALID_LARGE_PAGE_RANGE */
    { 0x019811, 0x00d2cd, 0x00d2cd,  34,  -1643,  18,  34 }, /* VERR_PGM_HANDLER_ALREADY_ALIASED */
    { 0x01d71c, 0x01c2ce, 0x01c2ce,  15,  -1642,  13,  15 }, /* VERR_PGM_PHYS_NOT_MMIO2 */
    { 0x01ed12, 0x01e447, 0x01e447,  11,  -1641,   9,  11 }, /* VERR_PGM_PHYS_NOT_MMIO */
    { 0x01e4c0, 0x01d451, 0x01d451,  13,  -1640,  11,  13 }, /* VERR_PGM_PHYS_NOT_ROM */
    { 0x01e4f7, 0x0113b6, 0x0113b6,  27,  -1639,  11,  27 }, /* VERR_PGM_PHYS_NOT_RAM */
    { 0x016519, 0x005dbb, 0x005dbb,  58,  -1638,  21,  58 }, /* VERR_PGM_PHYS_WR_HIT_HANDLER */
    { 0x01c544, 0x011d34, 0x011d34,  27,  -1637,  15,  27 }, /* VERR_PGM_PHYS_INVALID_PAGE_ID */
    { 0x019859, 0x013eb5, 0x013eb5,  24,  -1636,  18,  24 }, /* VERR_PGM_NO_CR3_SHADOW_ROOT */
    { 0x015a1f, 0x00b51c, 0x00b51c,  38,  -1635,  22,  38 }, /* VERR_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x01754d, 0x00c05b, 0x00c05b,  36,  -1634,  20,  36 }, /* VERR_PGM_PHYS_TLB_CATCH_ALL */
    { 0x016861, 0x008e38, 0x008e38,  45,  -1633,  21,  45 }, /* VERR_PGM_PHYS_TLB_UNASSIGNED */
    { 0x01a82c, 0x010569, 0x010569,  29,  -1632,  17,  29 }, /* VERR_PGM_DYNMAP_EXPAND_ERROR */
    { 0x01b3cd, 0x00cef3, 0x00cef3,  34,  -1631,  16,  34 }, /* VERR_PGM_DYNMAP_SETUP_ERROR */
    { 0x01a4da, 0x00b0cc, 0x00b0cc,  39,  -1630,  17,  39 }, /* VERR_PGM_DYNMAP_FULL_SET */
    { 0x01e5f4, 0x01121b, 0x01121b,  28,  -1629,  10,  28 }, /* VERR_PGM_DYNMAP_FAILED */
    { 0x0166d2, 0x011cad, 0x011cad,  27,  -1628,  21,  27 }, /* VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE */
    { 0x00f23c, 0x000170, 0x000170, 334,  -1627,  30,  65 }, /* VERR_PGM_INTERMEDIATE_PAGING_CONFLICT */
    { 0x00ebc5, 0x004379, 0x004379,  72,  -1626,  31,  72 }, /* VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY */
    { 0x0173f2, 0x0128b1, 0x0128b1,  26,  -1619,  21,  26 }, /* VERR_PGM_NO_HYPERVISOR_ADDRESS */
    { 0x017b3d, 0x008aa4, 0x008aa4,  46,  -1618,  20,  46 }, /* VERR_PGM_PHYS_PAGE_RESERVED */
    { 0x019013, 0x011767, 0x011767,  27,  -1617,  19,  27 }, /* VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE */
    { 0x016ba9, 0x00a7b7, 0x00a7b7,  40,  -1612,  21,  40 }, /* VERR_PGM_MAPPINGS_FIX_TOO_SMALL */
    { 0x014de2, 0x00bcad, 0x00bcad,  37,  -1611,  23,  37 }, /* VERR_PGM_MAPPINGS_FIX_REJECTED */
    { 0x014df9, 0x009346, 0x009346,  44,  -1610,  23,  44 }, /* VERR_PGM_MAPPINGS_FIX_CONFLICT */
    { 0x01b70d, 0x0070ae, 0x0070ae,  53,  -1609,  16,  53 }, /* VERR_PGM_MAPPINGS_FIXED */
    { 0x01c90e, 0x005997, 0x005997,  59,  -1608,  14,  59 }, /* VERR_PGM_RAM_CONFLICT */
    { 0x01debb, 0x010aac, 0x010aac,  28,  -1607,  12,  28 }, /* VERR_PGM_HANDLER_NOT_FOUND */
    { 0x0183ad, 0x004821, 0x004821,  68,  -1606,  20,  19 }, /* VERR_PGM_INVALID_GC_PHYSICAL_RANGE */
    { 0x008e4d, 0x0164ef, 0x0164ef,  21,  -1605,  22,  21 }, /* VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS */
    { 0x01ae59, 0x01eaa5, 0x01eaa5,   9,  -1604,  17,   9 }, /* VERR_PGM_INVALID_PAGE_DIRECTORY */
    { 0x01163e, 0x005edd, 0x005edd,  58,  -1603,  27,  58 }, /* VERR_PGM_HANDLER_PHYSICAL_CONFLICT */
    { 0x0121c9, 0x006039, 0x006039,  57,  -1602,  26,  57 }, /* VERR_PGM_HANDLER_VIRTUAL_CONFLICT */
    { 0x00fc03, 0x001977, 0x001977, 124,  -1601,  29,  45 }, /* VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE */
    { 0x01a05c, 0x007429, 0x007429,  52,  -1600,  18,  52 }, /* VERR_PGM_MAPPING_CONFLICT */
    { 0x01d928, 0x00a3ed, 0x00a3ed,  41,  -1504,  12,  41 }, /* VERR_CSAM_HM_IPE */
    { 0x012e84, 0x01c9d2, 0x01c9d2,  14,  -1432,  25,  14 }, /* VERR_PATM_IPE_TRAP_IN_PATCH_CODE */
    { 0x01dc58, 0x007be0, 0x007be0,  50,  -1431,  12,  50 }, /* VERR_PATM_HM_IPE */
    { 0x01c8ac, 0x01b04d, 0x01b04d,  16,  -1428,  14,  16 }, /* VERR_PATM_ALREADY_PATCHED */
    { 0x01abd3, 0x00edf3, 0x00edf3,  31,  -1426,  17,  31 }, /* VERR_PATM_UNSAFE_CODE */
    { 0x01b37d, 0x017d09, 0x017d09,  20,  -1425,  16,  20 }, /* VERR_PATCH_NO_CONFLICT */
    { 0x01bdd3, 0x01b4fd, 0x01b4fd,  16,  -1406,  15,  16 }, /* VERR_PATCH_ALREADY_ENABLED */
    { 0x01b19d, 0x01ac06, 0x01ac06,  17,  -1405,  16,  17 }, /* VERR_PATCH_ALREADY_DISABLED */
    { 0x01c166, 0x01bd4c, 0x01bd4c,  15,  -1403,  15,  15 }, /* VERR_PATCH_DISABLED */
    { 0x01eca6, 0x01d56f, 0x01d56f,  13,  -1402,   9,  13 }, /* VERR_PATCH_NOT_FOUND */
    { 0x01ade2, 0x004496, 0x004496,  71,  -1401,  17,  71 }, /* VERR_PATCHING_REFUSED */
    { 0x01dbbc, 0x01d270, 0x01d270,  13,  -1241,  12,  13 }, /* VERR_DBGF_CANCELLED */
    { 0x00d966, 0x00c0eb, 0x00c0eb,  36,  -1240,  33,  36 }, /* VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS */
    { 0x013893, 0x0125d9, 0x0125d9,  26,  -1238,  25,  26 }, /* VERR_DBGF_BP_OWNER_NO_MORE_HANDLES */
    { 0x01a331, 0x00a73f, 0x00a73f,  40,  -1237,  17,  40 }, /* VERR_DBGF_BP_L2_LOOKUP_FAILED */
    { 0x01a5fb, 0x00aad7, 0x00aad7,  40,  -1236,  17,  40 }, /* VERR_DBGF_BP_L1_LOOKUP_FAILED */
    { 0x01ee82, 0x017df9, 0x017df9,  20,  -1235,   8,  20 }, /* VERR_DBGF_BP_IPE_9 */
    { 0x01ee12, 0x017a75, 0x017a75,  20,  -1234,   8,  20 }, /* VERR_DBGF_BP_IPE_8 */
    { 0x01ee1a, 0x017831, 0x017831,  20,  -1233,   8,  20 }, /* VERR_DBGF_BP_IPE_7 */
    { 0x01ee22, 0x01821d, 0x01821d,  20,  -1232,   8,  20 }, /* VERR_DBGF_BP_IPE_6 */
    { 0x01ee2a, 0x017525, 0x017525,  20,  -1231,   8,  20 }, /* VERR_DBGF_BP_IPE_5 */
    { 0x01ee32, 0x017895, 0x017895,  20,  -1230,   8,  20 }, /* VERR_DBGF_BP_IPE_4 */
    { 0x01ee3a, 0x017e21, 0x017e21,  20,  -1229,   8,  20 }, /* VERR_DBGF_BP_IPE_3 */
    { 0x01ee42, 0x01803d, 0x01803d,  20,  -1228,   8,  20 }, /* VERR_DBGF_BP_IPE_2 */
    { 0x01ee4a, 0x017809, 0x017809,  20,  -1227,   8,  20 }, /* VERR_DBGF_BP_IPE_1 */
    { 0x010e0f, 0x0075fc, 0x0075fc,  51,  -1226,  28,  51 }, /* VERR_DBGF_BP_INT3_ADD_TRIES_REACHED */
    { 0x01d478, 0x008d28, 0x008d28,  46,  -1225,  13,  46 }, /* VERR_DBGF_OWNER_BUSY */
    { 0x01f4fe, 0x01b84d, 0x01b84d,  16,  -1223,   5,  16 }, /* VERR_DBGF_IPE_1 */
    { 0x01bcc5, 0x00a91f, 0x00a91f,  40,  -1222,  15,  40 }, /* VWRN_DBGF_ALREADY_RUNNING */
    { 0x01dc7c, 0x013127, 0x013127,  25,  -1221,  12,  25 }, /* VERR_DBGF_TRACER_IPE_1 */
    { 0x01b0fd, 0x007e91, 0x007e91,  49,  -1220,  16,  49 }, /* VERR_DBGF_NO_TRACE_BUFFER */
    { 0x01e1f5, 0x01af14, 0x01af14,  17,  -1219,  11,  17 }, /* VERR_DBGF_STACK_IPE_2 */
    { 0x01e200, 0x01a3ca, 0x01a3ca,  17,  -1218,  11,  17 }, /* VERR_DBGF_STACK_IPE_1 */
    { 0x01b82d, 0x0112c3, 0x0112c3,  27,  -1217,  16,  27 }, /* VERR_DBGF_HYPER_DB_XCPT */
    { 0x01ea6f, 0x01dd6b, 0x01dd6b,  12,  -1216,   9,  12 }, /* VERR_DBGF_REG_IPE_2 */
    { 0x01ea78, 0x01db68, 0x01db68,  12,  -1215,   9,  12 }, /* VERR_DBGF_REG_IPE_1 */
    { 0x016837, 0x017152, 0x017152,  21,  -1214,  21,  21 }, /* VERR_DBGF_READ_ONLY_REGISTER */
    { 0x01efaa, 0x01ad05, 0x01ad05,  17,  -1213,   8,  17 }, /* VERR_DBGF_UNSUPPORTED_CAST */
    { 0x01cb68, 0x01f497, 0x01f497,   6,  -1210,  14,   6 }, /* VERR_DBGF_REGISTER_NOT_FOUND */
    { 0x01c6fa, 0x01c265, 0x01c265,  15,  -1209,  14,  15 }, /* VERR_DBGF_OS_NOT_DETCTED */
    { 0x01ec82, 0x01e9c8, 0x01e9c8,  10,  -1208,   9,  10 }, /* VERR_DBGF_MEM_NOT_FOUND */
    { 0x01ee02, 0x00f34a, 0x00f34a,  30,  -1204,   8,  30 }, /* VERR_DBGF_BP_NOT_FOUND */
    { 0x01ad9e, 0x01a0a4, 0x01a0a4,  18,  -1203,  17,  18 }, /* VERR_DBGF_NO_MORE_BP_SLOTS */
    { 0x01db08, 0x00689d, 0x00689d,  56,  -1201,  12,  56 }, /* VERR_DBGF_ALREADY_ATTACHED */
    { 0x01d9f4, 0x0050ad, 0x0050ad,  64,  -1200,  12,  64 }, /* VERR_DBGF_NOT_ATTACHED */
    { 0x019295, 0x006afb, 0x006afb,  55,  -1158,  18,  32 }, /* VERR_EM_GUEST_CPU_HANG */
    { 0x01734a, 0x00b698, 0x00b698,  38,  -1156,  21,  38 }, /* VERR_EM_CANNOT_EXEC_GUEST */
    { 0x01656d, 0x01678f, 0x01678f,  21,  -1154,  21,  21 }, /* VERR_EM_UNEXPECTED_MAPPING_CONFLICT */
    { 0x01cd98, 0x008b2e, 0x008b2e,  46,  -1149,  14,  46 }, /* VERR_EM_INTERNAL_ERROR */
    { 0x01c193, 0x00b4d0, 0x00b4d0,  38,  -1148,  15,  38 }, /* VERR_EM_INTERPRETER */
    { 0x015775, 0x008408, 0x008408,  48,  -1133,  22,  40 }, /* VERR_EM_RAW_PATCH_CONFLICT */
    { 0x01e47e, 0x0106a0, 0x0106a0,  28,  -1114,  11,  28 }, /* VERR_EM_NO_MEMORY */
    { 0x016ccf, 0x0085b3, 0x0085b3,  47,  -1028,  21,  47 }, /* VERR_DRIVER_REBOOT_NEEDED */
    { 0x0135be, 0x018065, 0x018065,  20,  -1027,  25,  20 }, /* VERR_RESERVED_PAGE_TABLE_BITS */
    { 0x01ed87, 0x0194b1, 0x0194b1,  18,  -1026,   9,  18 }, /* VERR_NOT_SUP_BY_NEM */
    { 0x01e011, 0x01cebe, 0x01cebe,  14,  -1025,  11,  14 }, /* VERR_VM_RESTORED */
    { 0x0158eb, 0x0098dc, 0x0098dc,  43,  -1024,  22,  43 }, /* VERR_INCONSISTENT_VM_HANDLE */
    { 0x01dc28, 0x010feb, 0x010feb,  28,  -1023,  12,  28 }, /* VERR_RAW_MODE_NOT_SUPPORTED */
    { 0x01e452, 0x01e124, 0x01e124,  11,  -1022,  11,  11 }, /* VERR_INVALID_CPU_INDEX */
    { 0x01cc48, 0x014e27, 0x014e27,  23,  -1021,  14,  23 }, /* VERR_NOT_SUP_IN_RAW_MODE */
    { 0x01aab2, 0x001801, 0x001801, 125,  -1020,  17,  28 }, /* VERR_SERVICE_DISABLED */
    { 0x01e431, 0x01eefa, 0x01eefa,   8,  -1019,  11,   8 }, /* VERR_TOO_MANY_CPUS */
    { 0x01efe2, 0x01e590, 0x01e590,  10,  -1018,   8,  10 }, /* VERR_INVALID_CPU_ID */
    { 0x01c8e4, 0x01e932, 0x01e932,  10,  -1017,  14,  10 }, /* VERR_INVALID_VMCPU_HANDLE */
    { 0x01e7e8, 0x01e932, 0x01e932,  10,  -1016,  10,  10 }, /* VERR_INVALID_VM_HANDLE */
    { 0x01cd52, 0x01bdb5, 0x01bdb5,  15,  -1015,  14,  15 }, /* VERR_RAW_MODE_INVALID_SMP */
    { 0x010d84, 0x015626, 0x015626,  23,  -1014,  28,  23 }, /* VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT */
    { 0x0131ef, 0x01bf68, 0x01bf68,  15,  -1013,  25,  15 }, /* VERR_PAGE_MAP_LEVEL4_NOT_PRESENT */
    { 0x01f4bd, 0x01a080, 0x01a080,  18,  -1012,   5,  18 }, /* VERR_INVALID_RPL */
    { 0x01e978, 0x00d289, 0x00d289,  34,  -1011,  10,  10 }, /* VERR_INVALID_SELECTOR */
    { 0x0152ea, 0x016726, 0x016726,  21,  -1010,  23,  21 }, /* VERR_OUT_OF_SELECTOR_BOUNDS */
    { 0x01bc3e, 0x01ce08, 0x01ce08,  14,  -1009,  15,  14 }, /* VERR_NOT_DATA_SELECTOR */
    { 0x01c580, 0x01a014, 0x01a014,  18,  -1008,  15,  18 }, /* VERR_NOT_CODE_SELECTOR */
    { 0x0197db, 0x019cfc, 0x019cfc,  18,  -1007,  18,  18 }, /* VERR_SELECTOR_NOT_PRESENT */
    { 0x01e074, 0x01e9aa, 0x01e9aa,  10,  -1006,  11,  10 }, /* VERR_CFG_NO_VALUE */
    { 0x01dedf, 0x01482d, 0x01482d,  24,  -1005,  12,  24 }, /* VERR_CFG_INVALID_FORMAT */
    { 0x01cf3c, 0x01cfc8, 0x01cfc8,  14,  -1004,  14,  14 }, /* VERR_PAGE_NOT_PRESENT */
    { 0x01e806, 0x01e9a0, 0x01e9a0,  10,  -1003,  10,  10 }, /* VERR_UNSUPPORTED_CPU_MODE */
    { 0x01e806, 0x01f535, 0x01f535,   5,  -1002,   5,   5 }, /* VERR_UNSUPPORTED_CPU */
    { 0x01e313, 0x004681, 0x004681,  70,  -1001,  11,  70 }, /* VERR_DONT_PANIC */
    { 0x01e536, 0x018281, 0x018281,  20,  -1000,  10,  20 }, /* VERR_NO_VM_MEMORY */
    { 0x014a61, 0x00738d, 0x00738d,  52,   -965,  23,  52 }, /* VERR_PKZIP_ZIP64EX_IN_ZIP32 */
    { 0x01a5c8, 0x01ed90, 0x01ed90,   9,   -964,  17,   9 }, /* VERR_PKZIP_UNKNOWN_TYPE_FLAG */
    { 0x019b05, 0x018db3, 0x018db3,  19,   -963,  18,  19 }, /* VERR_PKZIP_BAD_CDF_HEADER */
    { 0x01aa08, 0x01b42d, 0x01b42d,  16,   -962,  17,  16 }, /* VERR_PKZIP_BAD_LF_HEADER */
    { 0x01a892, 0x01c7cc, 0x01c7cc,  14,   -961,  17,  14 }, /* VERR_PKZIP_NAME_TOO_LONG */
    { 0x01d880, 0x0153fe, 0x0153fe,  23,   -960,  12,  23 }, /* VERR_PKZIP_NO_EOCB */
    { 0x01a6d8, 0x01b31d, 0x01b31d,  16,   -953,  17,  16 }, /* VERR_POLL_SET_IS_FULL */
    { 0x019e64, 0x013a3c, 0x013a3c,  25,   -952,  18,  25 }, /* VERR_POLL_HANDLE_ID_NOT_FOUND */
    { 0x015c44, 0x00ded4, 0x00ded4,  32,   -951,  22,  32 }, /* VERR_POLL_HANDLE_ID_EXISTS */
    { 0x015d20, 0x018a24, 0x018a24,  19,   -950,  22,  19 }, /* VERR_POLL_HANDLE_NOT_POLLABLE */
    { 0x01c526, 0x017c91, 0x017c91,  20,   -947,  15,  20 }, /* VERR_TAR_NAME_TOO_LONG */
    { 0x011932, 0x0118e1, 0x0118e1,  27,   -946,  27,  27 }, /* VERR_TAR_MALFORMED_GNU_LONGXXXX */
    { 0x019f18, 0x0118e1, 0x0118e1,  27,   -945,  18,  27 }, /* VERR_TAR_BAD_CHKSUM_FIELD */
    { 0x01975d, 0x00e5b4, 0x00e5b4,  32,   -944,  18,  32 }, /* VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE */
    { 0x0156db, 0x00c46f, 0x00c46f,  36,   -943,  22,  36 }, /* VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE */
    { 0x01cf66, 0x0087e7, 0x0087e7,  47,   -942,  14,  47 }, /* VERR_TAR_UNSUPPORTED_PAX_TYPE */
    { 0x010f43, 0x010dbb, 0x010dbb,  28,   -941,  28,  28 }, /* VERR_TAR_NON_DIR_ENDS_WITH_SLASH */
    { 0x01c148, 0x01eaae, 0x01eaae,   9,   -940,  15,   9 }, /* VERR_TAR_EMPTY_NAME */
    { 0x01bda6, 0x009c7c, 0x009c7c,  42,   -939,  15,  31 }, /* VERR_TAR_NOT_USTAR_V00 */
    { 0x01b89d, 0x01a4fc, 0x01a4fc,  17,   -938,  16,  17 }, /* VERR_TAR_ZERO_HEADER */
    { 0x01c11b, 0x01ed90, 0x01ed90,   9,   -937,  15,   9 }, /* VERR_TAR_UNKNOWN_TYPE_FLAG */
    { 0x01c02b, 0x0114df, 0x0114df,  27,   -936,  15,  27 }, /* VERR_TAR_SIZE_NOT_ZERO */
    { 0x018eaa, 0x014f52, 0x014f52,  23,   -935,  19,  23 }, /* VERR_TAR_MODE_WITH_TYPE */
    { 0x01b49d, 0x0180a1, 0x0180a1,  20,   -934,  16,  20 }, /* VERR_TAR_BAD_MODE_FIELD */
    { 0x017017, 0x006555, 0x006555,  56,   -933,  21,  56 }, /* VERR_TAR_DEV_VALUE_TOO_LARGE */
    { 0x016987, 0x0063c9, 0x0063c9,  57,   -932,  21,  57 }, /* VERR_TAR_NUM_VALUE_TOO_LARGE */
    { 0x01bb0d, 0x004132, 0x004132,  74,   -931,  16,  74 }, /* VERR_TAR_BASE_256_NOT_SUPPORTED */
    { 0x017d31, 0x00b030, 0x00b030,  39,   -930,  20,  39 }, /* VERR_TAR_BAD_NUM_FIELD_TERM */
    { 0x017d31, 0x0180dd, 0x0180dd,  20,   -929,  15,  20 }, /* VERR_TAR_BAD_NUM_FIELD */
    { 0x018953, 0x004f6d, 0x004f6d,  64,   -928,  19,  64 }, /* VERR_TAR_EOS_MORE_INPUT */
    { 0x01ed1b, 0x01358c, 0x01358c,  25,   -927,   9,  25 }, /* VERR_TAR_UNEXPECTED_EOS */
    { 0x01b2ed, 0x0145bd, 0x0145bd,  24,   -926,  16,  24 }, /* VERR_TAR_END_OF_FILE */
    { 0x01d1ba, 0x00e1b4, 0x00e1b4,  32,   -925,  13,  32 }, /* VERR_TAR_CHKSUM_MISMATCH */
    { 0x016442, 0x015cf4, 0x015cf4,  22,   -906,  22,  22 }, /* VERR_MANIFEST_ATTR_TYPE_NOT_FOUND */
    { 0x016f84, 0x01542c, 0x01542c,  23,   -905,  21,  23 }, /* VERR_MANIFEST_ATTR_TYPE_MISMATCH */
    { 0x01a771, 0x00b37a, 0x00b37a,  38,   -904,  17,  38 }, /* VERR_MANIFEST_ATTR_NOT_FOUND */
    { 0x01ba3d, 0x0109cc, 0x0109cc,  28,   -903,  16,  28 }, /* VERR_MANIFEST_FILE_MISMATCH */
    { 0x019d68, 0x0134ab, 0x0134ab,  25,   -902,  18,  25 }, /* VERR_MANIFEST_DIGEST_MISMATCH */
    { 0x011dd6, 0x008018, 0x008018,  48,   -901,  27,  48 }, /* VERR_MANIFEST_WRONG_FILE_FORMAT */
    { 0x0159dd, 0x011237, 0x011237,  28,   -900,  22,  28 }, /* VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE */
    { 0x01de7f, 0x01f21c, 0x01f21c,   7,   -899,  12,   7 }, /* VERR_HTTP_CURL_ERROR */
    { 0x01ee52, 0x015b94, 0x015b94,  22,   -898,   8,  22 }, /* VERR_HTTP_NOT_SUPPORTED */
    { 0x014d6f, 0x0147fd, 0x0147fd,  24,   -897,  23,  24 }, /* VERR_HTTP_CURL_PROXY_CONFIG */
    { 0x01d5ca, 0x00e094, 0x00e094,  32,   -896,  13,  32 }, /* VERR_HTTP_HOST_NOT_FOUND */
    { 0x01cb06, 0x013221, 0x013221,  25,   -895,  14,  25 }, /* VERR_HTTP_PROXY_NOT_FOUND */
    { 0x01afbd, 0x017741, 0x017741,  20,   -894,  16,  20 }, /* VERR_HTTP_REDIRECTED */
    { 0x01d562, 0x011077, 0x011077,  28,   -893,  13,  28 }, /* VERR_HTTP_ABORTED */
    { 0x00dd34, 0x00a50c, 0x00a50c,  41,   -892,  32,  41 }, /* VERR_HTTP_CACERT_CANNOT_AUTHENTICATE */
    { 0x013a23, 0x00dbf4, 0x00dbf4,  32,   -891,  25,  32 }, /* VERR_HTTP_CACERT_WRONG_FORMAT */
    { 0x018c4a, 0x01b5ed, 0x01b5ed,  16,   -890,  19,  16 }, /* VERR_HTTP_SSL_CONNECT_ERROR */
    { 0x016b01, 0x00c80a, 0x00c80a,  35,   -889,  21,  33 }, /* VERR_HTTP_COULDNT_CONNECT */
    { 0x01c660, 0x009f70, 0x009f70,  42,   -888,  14,  42 }, /* VERR_HTTP_BAD_REQUEST */
    { 0x018e38, 0x007ae6, 0x007ae6,  50,   -887,  19,  24 }, /* VERR_HTTP_ACCESS_DENIED */
    { 0x01ee62, 0x0090ae, 0x0090ae,  45,   -886,   8,  45 }, /* VERR_HTTP_NOT_FOUND */
    { 0x01d85c, 0x016597, 0x016597,  21,   -885,  12,  21 }, /* VERR_HTTP_INIT_FAILED */
    { 0x016654, 0x01873f, 0x01873f,  19,   -884,  21,  19 }, /* VERR_HTTP_STATUS_SERVER_ERROR */
    { 0x01ded3, 0x01d1fb, 0x01d1fb,  13,   -879,  12,  13 }, /* VERR_S3_CANCELED */
    { 0x01a52f, 0x0127fb, 0x0127fb,  26,   -878,  17,  26 }, /* VERR_S3_BUCKET_NOT_EMPTY */
    { 0x01a002, 0x01c391, 0x01c391,  15,   -877,  18,  15 }, /* VERR_S3_BUCKET_ALREADY_EXISTS */
    { 0x01f425, 0x017499, 0x017499,  20,   -876,   6,  20 }, /* VERR_S3_NOT_FOUND */
    { 0x01a8b4, 0x01c2fb, 0x01c2fb,  15,   -875,  17,  15 }, /* VERR_S3_ACCESS_DENIED */
    { 0x0189b2, 0x0140ad, 0x0140ad,  24,   -855,  19,  24 }, /* VERR_MEM_CACHE_MAX_SIZE */
    { 0x01dfab, 0x015fb4, 0x015fb4,  22,   -851,  12,  22 }, /* VERR_CACHE_EMPTY */
    { 0x01e494, 0x016b40, 0x016b40,  21,   -850,  11,  21 }, /* VERR_CACHE_FULL */
    { 0x016f45, 0x009703, 0x009703,  43,   -829,  21,  43 }, /* VERR_GETOPT_INDEX_MISSING */
    { 0x014035, 0x0074c5, 0x0074c5,  52,   -827,  24,  52 }, /* VERR_GETOPT_INVALID_ARGUMENT_FORMAT */
    { 0x00dad1, 0x0090db, 0x0090db,  45,   -826,  33,  45 }, /* VERR_GETOPT_REQUIRED_ARGUMENT_MISSING */
    { 0x01c4bd, 0x0099b2, 0x0099b2,  42,   -825,  15,  42 }, /* VERR_GETOPT_UNKNOWN_OPTION */
    { 0x01f2bd, 0x01e2bb, 0x01e2bb,  11,   -803,   7,  11 }, /* VERR_CPU_IPE_1 */
    { 0x01ad7c, 0x009b56, 0x009b56,  42,   -802,  17,  42 }, /* VERR_NOT_ALL_CPUS_SHOWED */
    { 0x01f2fc, 0x01ec43, 0x01ec43,   9,   -801,   7,   9 }, /* VERR_CPU_NOT_FOUND */
    { 0x01df27, 0x01c49f, 0x01c49f,  15,   -800,  12,  15 }, /* VERR_CPU_OFFLINE */
    { 0x01c708, 0x0095d6, 0x0095d6,  43,   -753,  14,  43 }, /* VERR_ENV_VAR_UNSET */
    { 0x01cea2, 0x01132f, 0x01132f,  27,   -752,  14,  27 }, /* VERR_ENV_INVALID_VAR_NAME */
    { 0x01e15b, 0x009f1c, 0x00a64f,  40,   -750,  11,  26 }, /* VERR_ENV_VAR_NOT_FOUND */
    { 0x01410d, 0x003b8f, 0x003b8f,  79,   -704,  24,  34 }, /* VERR_RT_REQUEST_STATUS_FREED */
    { 0x00ddb4, 0x002180, 0x002180, 109,   -703,  32,  55 }, /* VERR_RT_REQUEST_STATUS_STILL_PENDING */
    { 0x017629, 0x0028ec, 0x0028ec, 102,   -702,  20,  12 }, /* VERR_RT_REQUEST_INVALID_PACKAGE */
    { 0x01af9c, 0x001eeb, 0x001eeb, 111,   -701,  17,   6 }, /* VERR_RT_REQUEST_STATE */
    { 0x01a496, 0x000cd8, 0x000cd8, 162,   -700,  17,  10 }, /* VERR_RT_REQUEST_INVALID_TYPE */
    { 0x012a1d, 0x00fceb, 0x00fceb,  29,   -696,  26,  29 }, /* VERR_DBG_MALFORMED_UNWIND_INFO */
    { 0x018dec, 0x00e574, 0x00e574,  32,   -695,  19,  32 }, /* VERR_DBG_UNWIND_INFO_NOT_FOUND */
    { 0x01a452, 0x015e54, 0x015e54,  22,   -694,  17,  22 }, /* VERR_DBG_NO_UNWIND_INFO */
    { 0x01f246, 0x00b32e, 0x00b32e,  38,   -693,   7,  38 }, /* VERR_CV_IPE */
    { 0x01f0ea, 0x008ccc, 0x008ccc,  46,   -692,   8,  46 }, /* VERR_CV_TODO */
    { 0x01e405, 0x00c5b3, 0x00c5b3,  36,   -691,  11,  36 }, /* VERR_CV_BAD_FORMAT */
    { 0x01dce8, 0x01265b, 0x01265b,  26,   -689,  12,  26 }, /* VERR_DBG_MOD_IPE */
    { 0x01e3e4, 0x0093ca, 0x0093ca,  44,   -688,  11,  44 }, /* VERR_DBG_FILE_MISMATCH */
    { 0x01ec94, 0x00f188, 0x00f188,  30,   -687,   9,  30 }, /* VERR_DBG_TODO */
    { 0x017e49, 0x00e9b6, 0x00e9b6,  31,   -686,  20,  31 }, /* VERR_DBG_DEFERRED_LOAD_FAILED */
    { 0x018447, 0x016324, 0x016324,  22,   -685,  19,  22 }, /* VERR_DBG_CFG_NOT_UINT_PROP */
    { 0x01c58f, 0x01d958, 0x01d958,  12,   -684,  15,  12 }, /* VERR_DBG_CFG_INVALID_VALUE */
    { 0x01e63a, 0x01df4b, 0x01df4b,  12,   -683,  10,  12 }, /* VERR_DWARF_IPE */
    { 0x0160fe, 0x011e93, 0x011e93,  27,   -682,  22,  27 }, /* VERR_DWARF_STACK_UNDERFLOW */
    { 0x016fd8, 0x012043, 0x012043,  26,   -681,  21,  26 }, /* VERR_DWARF_STACK_OVERFLOW */
    { 0x01a0ec, 0x01a2a9, 0x01a2a9,  17,   -680,  18,  17 }, /* VERR_DWARF_UNKNOWN_LOC_OPCODE */
    { 0x01e07f, 0x01db14, 0x01db14,  12,   -679,  11,  12 }, /* VERR_DWARF_TODO */
    { 0x01de97, 0x010a3c, 0x010a3c,  28,   -678,  12,  28 }, /* VERR_DWARF_UNEXPECTED_FORM */
    { 0x01dda7, 0x019a87, 0x019a87,  18,   -677,  12,  18 }, /* VERR_DWARF_UNKNOWN_FORM */
    { 0x01b68d, 0x014095, 0x014095,  24,   -676,  16,  24 }, /* VERR_DWARF_ABBREV_NOT_FOUND */
    { 0x01cace, 0x0139d8, 0x0139d8,  25,   -675,  14,  25 }, /* VERR_DWARF_BAD_ABBREV */
    { 0x01dcd0, 0x01dd0b, 0x01dd0b,  12,   -674,  12,  12 }, /* VERR_DWARF_BAD_INFO */
    { 0x01e237, 0x01b69d, 0x01b69d,  16,   -673,  11,  16 }, /* VERR_DWARF_BAD_POS */
    { 0x01c7a2, 0x01cf2e, 0x01cf2e,  14,   -672,  14,  14 }, /* VERR_DWARF_BAD_STRING */
    { 0x01e279, 0x010464, 0x010464,  29,   -671,  11,  29 }, /* VERR_DWARF_BAD_LNE */
    { 0x018a83, 0x00cc47, 0x00cc47,  35,   -670,  19,  35 }, /* VERR_DWARF_LEB_OVERFLOW */
    { 0x01e2f2, 0x01af69, 0x01af69,  17,   -669,  11,  17 }, /* VERR_DWARF_UNEXPECTED_END */
    { 0x012933, 0x01c874, 0x01c874,  14,   -668,  26,  14 }, /* VERR_DWARF_BAD_LINE_NUMBER_HEADER */
    { 0x01299b, 0x008611, 0x008611,  47,   -667,  26,  47 }, /* VERR_DBG_NO_MATCHING_INTERPRETER */
    { 0x018385, 0x00df54, 0x00df54,  32,   -666,  20,  32 }, /* VERR_DBG_NOT_LINUX_KALLSYMS */
    { 0x01add1, 0x0146ad, 0x0146ad,  24,   -665,  17,  24 }, /* VERR_DBG_NOT_NM_MAP_FILE */
    { 0x01a661, 0x014575, 0x014575,  24,   -664,  17,  24 }, /* VERR_DBG_ADDRESS_WRAP */
    { 0x00f6ec, 0x002752, 0x002752, 103,   -663,  30,  31 }, /* VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE */
    { 0x011ce3, 0x002fda, 0x002fda,  94,   -662,  27,  24 }, /* VERR_DBG_FILE_NAME_OUT_OF_RANGE */
    { 0x00ff86, 0x0029b8, 0x0029b8, 102,   -661,  29,  30 }, /* VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE */
    { 0x01de1f, 0x009d78, 0x009d78,  42,   -660,  12,  42 }, /* VERR_DBG_LINE_NOT_FOUND */
    { 0x011a0a, 0x008f46, 0x008f46,  45,   -659,  27,  45 }, /* VERR_DBG_SEGMENT_INDEX_CONFLICT */
    { 0x016d62, 0x0038b8, 0x0038b8,  82,   -658,  21,  32 }, /* VERR_DBG_DUPLICATE_SYMBOL */
    { 0x01713d, 0x0018fb, 0x0018fb, 124,   -657,  21,  41 }, /* VERR_DBG_ADDRESS_CONFLICT */
    { 0x017561, 0x01154b, 0x01154b,  27,   -656,  20,  27 }, /* VERR_DBG_SPECIAL_SEGMENT */
    { 0x01eb74, 0x01154b, 0x01154b,  27,   -655,   9,  27 }, /* VERR_DBG_INVALID_RVA */
    { 0x018001, 0x01b51d, 0x01b51d,  16,   -654,  20,  16 }, /* VERR_DBG_INVALID_SEGMENT_OFFSET */
    { 0x0186ba, 0x01c571, 0x01c571,  15,   -653,  19,  15 }, /* VERR_DBG_INVALID_SEGMENT_INDEX */
    { 0x01d596, 0x003038, 0x003038,  94,   -652,  13,  34 }, /* VERR_DBG_INVALID_ADDRESS */
    { 0x01d2e5, 0x00ff2f, 0x00ff2f,  29,   -651,  13,  29 }, /* VERR_DBG_NO_SYMBOLS */
    { 0x01998b, 0x010710, 0x010710,  28,   -650,  18,  28 }, /* VERR_DBG_NO_LINE_NUMBERS */
    { 0x01b8ad, 0x0147b5, 0x0147b5,  24,   -649,  16,  24 }, /* VERR_LDR_INVALID_SEG_OFFSET */
    { 0x01ecd3, 0x01154b, 0x01154b,  27,   -648,   9,  27 }, /* VERR_LDR_INVALID_RVA */
    { 0x0193c7, 0x01cf58, 0x01cf58,  14,   -647,  18,  14 }, /* VERR_LDR_INVALID_LINK_ADDRESS */
    { 0x00e997, 0x010fcf, 0x010fcf,  28,   -641,  31,  28 }, /* VERR_LDRELF_UNTERMINATED_STRING_TAB */
    { 0x00ec7f, 0x009cfa, 0x009cfa,  42,   -640,  31,  42 }, /* VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS */
    { 0x0125a5, 0x0119b9, 0x0119b9,  27,   -639,  26,  27 }, /* VERR_LDRELF_INVALID_RELOCATION_OFFSET */
    { 0x011f86, 0x01416d, 0x01416d,  24,   -638,  27,  24 }, /* VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET */
    { 0x01728d, 0x0126f7, 0x0126f7,  26,   -637,  21,  26 }, /* VERR_LDRELF_INVALID_SYMBOL_INDEX */
    { 0x016bbe, 0x00be3f, 0x00be3f,  36,   -636,  21,  36 }, /* VERR_LDRELF_RELOCATION_NOT_SUPPORTED */
    { 0x013e25, 0x00b0a5, 0x00b0a5,  39,   -635,  24,  39 }, /* VERR_LDRELF_MULTIPLE_SYMTABS */
    { 0x01c5f8, 0x01ec3a, 0x01ec3a,   9,   -634,  15,   9 }, /* VERR_LDRELF_VERSION */
    { 0x01c3dc, 0x007d6b, 0x007d6b,  49,   -633,  15,  49 }, /* VERR_LDRELF_MACHINE */
    { 0x01ddef, 0x0045f5, 0x0045f5,  70,   -632,  12,  70 }, /* VERR_LDRELF_EXEC */
    { 0x01e29a, 0x004bd7, 0x004bd7,  67,   -631,  11,  67 }, /* VERR_LDRELF_DYN */
    { 0x019a2d, 0x00d714, 0x00d714,  33,   -630,  18,  33 }, /* VERR_LDRELF_ODD_ENDIAN */
    { 0x016dcb, 0x00a7df, 0x00a7df,  40,   -628,  21,  40 }, /* VERR_LDRPE_GUARD_CF_STUFF */
    { 0x013f15, 0x005517, 0x005517,  62,   -627,  24,  62 }, /* VERR_LDRPE_LOCK_PREFIX_TABLE */
    { 0x015512, 0x009ef2, 0x009ef2,  42,   -626,  23,  42 }, /* VERR_LDRPE_LOAD_CONFIG_SIZE */
    { 0x016f99, 0x013528, 0x013528,  25,   -625,  21,  25 }, /* VERR_LDRPE_COM_DESCRIPTOR */
    { 0x01e680, 0x0196bb, 0x0196bb,  18,   -624,  10,  18 }, /* VERR_LDRPE_TLS */
    { 0x01b9dd, 0x008ebf, 0x008ebf,  45,   -623,  16,  45 }, /* VERR_LDRPE_GLOBALPTR */
    { 0x0154cd, 0x00c666, 0x00c666,  35,   -622,  23,  35 }, /* VERR_LDRPE_CERT_UNSUPPORTED */
    { 0x016e0a, 0x00f4d0, 0x00f4d0,  30,   -621,  21,  30 }, /* VERR_LDRPE_CERT_MALFORMED */
    { 0x019201, 0x005df5, 0x005df5,  58,   -620,  19,  58 }, /* VERR_LDRPE_DELAY_IMPORT */
    { 0x01c382, 0x01cecc, 0x01cecc,  14,   -619,  15,  14 }, /* VERR_LDR_IMAGE_HASH */
    { 0x0175ed, 0x01e6c6, 0x01e6c6,  10,   -618,  20,  10 }, /* VERR_LDR_GENERAL_FAILURE */
    { 0x014c72, 0x00b308, 0x00b308,  38,   -617,  23,  38 }, /* VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND */
    { 0x01d485, 0x00b9a4, 0x00b9a4,  37,   -616,  13,  37 }, /* VERR_LDR_MISMATCH_NATIVE */
    { 0x01e17c, 0x012d0d, 0x012d0d,  25,   -615,  11,  25 }, /* VERR_LDR_ARCH_MISMATCH */
    { 0x01a5ea, 0x00f020, 0x00f020,  30,   -614,  17,  30 }, /* VERR_IMAGE_BASE_TOO_HIGH */
    { 0x01e3ad, 0x01ee7a, 0x01ee7a,   8,   -612,  11,   8 }, /* VERR_IMAGE_TOO_BIG */
    { 0x019aab, 0x007079, 0x007079,  53,   -611,  18,  53 }, /* VERR_SYMBOL_VALUE_TOO_BIG */
    { 0x01e7c0, 0x01ebf2, 0x01ebf2,   9,   -610,  10,   9 }, /* VERR_MODULE_NOT_FOUND */
    { 0x01e784, 0x019f72, 0x019f72,  18,   -609,  10,  18 }, /* VERR_SYMBOL_NOT_FOUND */
    { 0x01dcff, 0x01dde3, 0x01dde3,  12,   -608,  12,  12 }, /* VERR_BAD_EXE_FORMAT */
    { 0x01ddfb, 0x007f55, 0x007f55,  49,   -607,  12,  21 }, /* VERR_AOUT_EXE_NOT_SUPPORTED */
    { 0x01ea53, 0x0089bd, 0x0089bd,  47,   -606,  10,  47 }, /* VERR_MZ_EXE_NOT_SUPPORTED */
    { 0x01e59a, 0x0086fc, 0x0086fc,  47,   -605,  10,  47 }, /* VERR_NE_EXE_NOT_SUPPORTED */
    { 0x01e78e, 0x00898e, 0x00898e,  47,   -604,  10,  47 }, /* VERR_LE_EXE_NOT_SUPPORTED */
    { 0x01e748, 0x00872b, 0x00872b,  47,   -603,  10,  47 }, /* VERR_LX_EXE_NOT_SUPPORTED */
    { 0x01e7de, 0x0087b8, 0x0087b8,  47,   -602,  10,  47 }, /* VERR_PE_EXE_NOT_SUPPORTED */
    { 0x01e0ed, 0x008468, 0x008468,  48,   -601,  11,  48 }, /* VERR_ELF_EXE_NOT_SUPPORTED */
    { 0x01c346, 0x015f1a, 0x015f1a,  22,   -600,  15,  22 }, /* VERR_INVALID_EXE_SIGNATURE */
    { 0x01a881, 0x0115ed, 0x0115ed,  27,   -566,  17,  27 }, /* VERR_L4_DS_MANAGER_NOT_FOUND */
    { 0x013253, 0x010399, 0x010399,  29,   -563,  25,  29 }, /* VERR_IPC_SEND_SEND_PF_TIMEOUT */
    { 0x010b54, 0x00e0f4, 0x00e0f4,  32,   -562,  28,  32 }, /* VERR_IPC_RECEIVE_SEND_PF_TIMEOUT */
    { 0x01beb4, 0x00ec41, 0x00ec41,  31,   -561,  15,  31 }, /* VERR_IPC_SEND_MAP_FAILED */
    { 0x019421, 0x00d267, 0x00d267,  34,   -560,  18,  34 }, /* VERR_IPC_RECEIVE_MAP_FAILED */
    { 0x01a353, 0x01d7f9, 0x01d7f9,  13,   -559,  17,  13 }, /* VERR_IPC_SEND_ABORTED */
    { 0x017e85, 0x01b88d, 0x01b88d,  16,   -558,  20,  16 }, /* VERR_IPC_RECEIVE_ABORTED */
    { 0x0184a6, 0x01c1de, 0x01c1de,  15,   -557,  19,  15 }, /* VERR_IPC_SEND_CANCELLED */
    { 0x0157cd, 0x019dd4, 0x019dd4,  18,   -556,  22,  18 }, /* VERR_IPC_RECEIVE_CANCELLED */
    { 0x01a650, 0x01d70f, 0x01d70f,  13,   -555,  17,  13 }, /* VERR_IPC_SEND_TIMEOUT */
    { 0x017b51, 0x01affd, 0x01affd,  16,   -554,  20,  16 }, /* VERR_IPC_RECEIVE_TIMEOUT */
    { 0x01c373, 0x016750, 0x016750,  21,   -553,  15,  21 }, /* VERR_IPC_PROCESS_NOT_FOUND */
    { 0x01b10d, 0x01e006, 0x01e006,  11,   -552,  16,  11 }, /* VERR_RESOURCE_IN_USE */
    { 0x010b54, 0x01f4e5, 0x01f4e5,   5,   -551,   4,   5 }, /* VERR_IPC */
    { 0x01cfba, 0x015415, 0x015415,  23,   -550,  14,  23 }, /* VERR_L4_INVALID_DS_OFFSET */
    { 0x0168a0, 0x015443, 0x015443,  23,   -522,  21,  23 }, /* VERR_UDP_SERVER_DESTROYED */
    { 0x017719, 0x007ef3, 0x007ef3,  49,   -521,  20,  49 }, /* VERR_UDP_SERVER_SHUTDOWN */
    { 0x01b5fd, 0x01a386, 0x01a386,  17,   -520,  16,  17 }, /* VERR_UDP_SERVER_STOP */
    { 0x017056, 0x014e10, 0x014e10,  23,   -502,  21,  23 }, /* VERR_TCP_SERVER_DESTROYED */
    { 0x01777d, 0x007ca7, 0x007ca7,  49,   -501,  20,  49 }, /* VERR_TCP_SERVER_SHUTDOWN */
    { 0x01b6ed, 0x01a74f, 0x01a74f,  17,   -500,  16,  17 }, /* VERR_TCP_SERVER_STOP */
    { 0x01aaa1, 0x01011c, 0x01011c,  29,   -469,  17,  29 }, /* VERR_NET_NOT_UNSUPPORTED */
    { 0x01e4d6, 0x01c67c, 0x01c67c,  14,   -468,  11,  14 }, /* VERR_NET_INIT_FAILED */
    { 0x01302d, 0x00c61f, 0x00c61f,  36,   -467,  25,  36 }, /* VERR_NET_INCOMPLETE_TX_PACKET */
    { 0x01bf86, 0x01e996, 0x01e996,  10,   -466,  15,  10 }, /* VERR_NET_PROTOCOL_ERROR */
    { 0x0167e3, 0x01d068, 0x01d068,  13,   -465,  21,  13 }, /* VERR_NET_HOST_UNREACHABLE */
    { 0x01cba0, 0x01e3fa, 0x01e3fa,  11,   -464,  14,  11 }, /* VERR_NET_HOST_DOWN */
    { 0x015021, 0x0184f2, 0x0184f2,  19,   -461,  23,  19 }, /* VERR_NET_CONNECTION_REFUSED */
    { 0x013ad2, 0x011b33, 0x011b33,  27,   -460,  25,  27 }, /* VERR_NET_CONNECTION_TIMED_OUT */
    { 0x017446, 0x011b33, 0x011b33,  27,   -459,  21,  27 }, /* VERR_NET_TOO_MANY_REFERENCES */
    { 0x01d6a7, 0x00d735, 0x00d735,  33,   -458,  13,  33 }, /* VERR_NET_SHUTDOWN */
    { 0x01c3cd, 0x018719, 0x018719,  19,   -457,  15,  19 }, /* VERR_NET_NOT_CONNECTED */
    { 0x01c634, 0x0183e8, 0x0183e8,  19,   -456,  15,  19 }, /* VERR_NET_ALREADY_CONNECTED */
    { 0x019cd9, 0x0141cd, 0x0141cd,  24,   -455,  18,  24 }, /* VERR_NET_NO_BUFFER_SPACE */
    { 0x0100c5, 0x015346, 0x015346,  23,   -454,  29,  23 }, /* VERR_NET_CONNECTION_RESET_BY_PEER */
    { 0x014b02, 0x00d5eb, 0x00d5eb,  33,   -453,  23,  33 }, /* VERR_NET_CONNECTION_ABORTED */
    { 0x0100c5, 0x00c5fb, 0x00c5fb,  36,   -452,  21,  36 }, /* VERR_NET_CONNECTION_RESET */
    { 0x01b4ed, 0x017095, 0x017095,  21,   -451,  16,  21 }, /* VERR_NET_UNREACHABLE */
    { 0x01ed24, 0x01cdc2, 0x01cdc2,  14,   -450,   9,  14 }, /* VERR_NET_DOWN */
    { 0x01535d, 0x0157a1, 0x0157a1,  22,   -449,  23,  22 }, /* VERR_NET_ADDRESS_NOT_AVAILABLE */
    { 0x018564, 0x01c900, 0x01c900,  14,   -448,  19,  14 }, /* VERR_NET_ADDRESS_IN_USE */
    { 0x015a35, 0x00cd5b, 0x00cd5b,  34,   -447,  22,  34 }, /* VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED */
    { 0x0151d6, 0x019ae1, 0x019ae1,  18,   -446,  23,  18 }, /* VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED */
    { 0x01a760, 0x01df87, 0x01df87,  12,   -445,  17,  12 }, /* VERR_NET_OPERATION_NOT_SUPPORTED */
    { 0x018551, 0x01e73e, 0x01e73e,  10,   -444,  19,  10 }, /* VERR_NET_SOCKET_TYPE_NOT_SUPPORTED */
    { 0x01ba1d, 0x01e28f, 0x01e28f,  11,   -443,  16,  11 }, /* VERR_NET_PROTOCOL_NOT_SUPPORTED */
    { 0x0145ed, 0x017e99, 0x017e99,  20,   -442,  24,  20 }, /* VERR_NET_PROTOCOL_NOT_AVAILABLE */
    { 0x0197c9, 0x0143ad, 0x0143ad,  24,   -441,  18,  24 }, /* VERR_NET_PROTOCOL_TYPE */
    { 0x01d4ac, 0x01cbf4, 0x01cbf4,  14,   -440,  13,  14 }, /* VERR_NET_MSG_SIZE */
    { 0x0120df, 0x010325, 0x010325,  29,   -439,  26,  29 }, /* VERR_NET_DEST_ADDRESS_REQUIRED */
    { 0x01dc94, 0x0042a1, 0x0042a1,  72,   -438,  12,  39 }, /* VERR_NET_NOT_SOCKET */
    { 0x01a3ec, 0x016e88, 0x016e88,  21,   -437,  17,  21 }, /* VERR_NET_ALREADY_IN_PROGRESS */
    { 0x01bacd, 0x017575, 0x017575,  20,   -436,  16,  20 }, /* VERR_NET_IN_PROGRESS */
    { 0x01ab4b, 0x01272b, 0x01272b,  26,   -406,  17,  26 }, /* VERR_NET_NOT_UNIQUE_NAME */
    { 0x01d319, 0x015682, 0x015682,  23,   -405,  13,  23 }, /* VERR_NET_NO_NETWORK */
    { 0x01de37, 0x012cc1, 0x012cc1,  26,   -404,  12,  26 }, /* VERR_NET_PRINT_ERROR */
    { 0x01df6f, 0x01e119, 0x01e119,  11,   -403,  12,  11 }, /* VERR_NET_PATH_NOT_FOUND */
    { 0x01dea3, 0x01d88c, 0x01d88c,  12,   -402,  12,  12 }, /* VERR_NET_HOST_NOT_FOUND */
    { 0x0166fc, 0x00de54, 0x00de54,  32,   -401,  21,  32 }, /* VERR_NET_OUT_OF_RESOURCES */
    { 0x01ec1f, 0x00f7dc, 0x00f7dc,  30,   -400,   9,  30 }, /* VERR_NET_IO_ERROR */
    { 0x019b29, 0x00ab9e, 0x00ab9e,  39,   -377,  18,  39 }, /* VERR_SEM_LV_INTERNAL_ERROR */
    { 0x019c49, 0x00c3bb, 0x00c3bb,  36,   -376,  18,  36 }, /* VERR_SEM_LV_NOT_SIGNALLER */
    { 0x014e9a, 0x00c968, 0x00c968,  35,   -375,  23,  35 }, /* VERR_SEM_LV_ILLEGAL_UPGRADE */
    { 0x01c812, 0x00b3c6, 0x00b3c6,  38,   -374,  14,  38 }, /* VERR_SEM_LV_NOT_OWNER */
    { 0x0131bd, 0x002c74, 0x002c74,  98,   -373,  25,  44 }, /* VERR_SEM_LV_EXISTING_DEADLOCK */
    { 0x01b3ad, 0x00be87, 0x00be87,  36,   -372,  16,  36 }, /* VERR_SEM_LV_DEADLOCK */
    { 0x01a158, 0x00bdd3, 0x00bdd3,  36,   -371,  18,  36 }, /* VERR_SEM_LV_INVALID_PARAMETER */
    { 0x01ce32, 0x008318, 0x008318,  48,   -370,  14,  48 }, /* VERR_SEM_LV_NESTED */
    { 0x011dbb, 0x0104f5, 0x0104f5,  29,   -369,  27,  29 }, /* VERR_SEM_LV_WRONG_RELEASE_ORDER */
    { 0x018e84, 0x010294, 0x010294,  29,   -368,  19,  29 }, /* VERR_SEM_LV_WRONG_ORDER */
    { 0x01d69a, 0x00f8ea, 0x00f8ea,  30,   -367,  13,  30 }, /* VERR_SEM_BAD_CONTEXT */
    { 0x01b13d, 0x00cc8d, 0x00cc8d,  35,   -366,  16,  35 }, /* VERR_SEM_OUT_OF_TURN */
    { 0x01ec8b, 0x01a026, 0x01a026,  18,   -365,   9,  18 }, /* VERR_DEADLOCK */
    { 0x01e4cb, 0x007fb7, 0x007fb7,  49,   -364,  11,  49 }, /* VERR_SEM_NESTED */
    { 0x01c866, 0x00cd17, 0x00cd17,  34,   -363,  14,  34 }, /* VERR_SEM_DESTROYED */
    { 0x01f174, 0x01c698, 0x01c698,  14,   -362,   7,  14 }, /* VERR_SEM_NOT_FOUND */
    { 0x01c049, 0x00f584, 0x00f584,  30,   -361,  15,  30 }, /* VERR_SEM_OWNER_DIED */
    { 0x01ec31, 0x01f062, 0x01f062,   8,   -360,   9,   8 }, /* VERR_SEM_BUSY */
    { 0x01f151, 0x01a4b8, 0x01a4b8,  17,   -359,   7,  17 }, /* VERR_ALREADY_RESET */
    { 0x01f10a, 0x019847, 0x019847,  18,   -358,   8,  18 }, /* VERR_ALREADY_POSTED */
    { 0x01d9a0, 0x00d1df, 0x00d1df,  34,   -357,  12,  34 }, /* VERR_TOO_MANY_POSTS */
    { 0x01dd83, 0x0187fd, 0x0187fd,  19,   -356,  12,  19 }, /* VERR_TOO_MANY_OPENS */
    { 0x01f270, 0x00b1fe, 0x00b1fe,  38,   -355,   7,  38 }, /* VERR_NOT_OWNER */
    { 0x018f7b, 0x01c946, 0x01c946,  14,   -354,  19,  14 }, /* VERR_TOO_MANY_SEM_REQUESTS */
    { 0x01e0cc, 0x01a8e7, 0x01a8e7,  17,   -353,  11,  17 }, /* VERR_SEM_IS_SET */
    { 0x01b93d, 0x00ccb0, 0x00ccb0,  35,   -352,  16,  35 }, /* VERR_EXCL_SEM_ALREADY_OWNED */
    { 0x01ae37, 0x01d806, 0x01d806,  13,   -351,  17,  13 }, /* VERR_TOO_MANY_SEMAPHORES */
    { 0x01f479, 0x0150d9, 0x0150d9,  23,   -350,   6,  23 }, /* VERR_SEM_ERROR */
    { 0x01d8f8, 0x00b79e, 0x00b79e,  37,   -308,  12,  37 }, /* VERR_PIPE_NOT_WRITE */
    { 0x01e2dc, 0x00bc63, 0x00bc63,  37,   -307,  11,  37 }, /* VERR_PIPE_NOT_READ */
    { 0x01e91e, 0x015707, 0x015707,  22,   -306,  10,  22 }, /* VERR_MORE_DATA */
    { 0x01baad, 0x01ae6a, 0x01ae6a,  17,   -305,  16,  17 }, /* VERR_PIPE_NOT_CONNECTED */
    { 0x01f3ad, 0x01ee72, 0x01ee72,   8,   -304,   6,   8 }, /* VERR_NO_DATA */
    { 0x01e9fa, 0x01e03d, 0x01e03d,  11,   -303,  10,  11 }, /* VERR_PIPE_BUSY */
    { 0x01f3d7, 0x01f46d, 0x01f46d,   6,   -302,   6,   6 }, /* VERR_BAD_PIPE */
    { 0x01da9c, 0x01dbf8, 0x01dbf8,  12,   -301,  12,  12 }, /* VERR_BROKEN_PIPE */
    { 0x01e81a, 0x00ef86, 0x00ef86,  31,   -300,  10,  31 }, /* VERR_PIPE_IO_ERROR */
    { 0x01bbb7, 0x01105b, 0x01105b,  28,   -257,  15,  28 }, /* VERR_IO_GEN_FAILURE */
    { 0x01d0a9, 0x0168f4, 0x0168f4,  21,   -256,  13,  21 }, /* VERR_IO_SECTOR_NOT_FOUND */
    { 0x01e0b6, 0x018295, 0x018295,  20,   -255,  11,  20 }, /* VERR_IO_BAD_LENGTH */
    { 0x01f357, 0x01af03, 0x01af03,  17,   -254,   7,  17 }, /* VERR_IO_CRC */
    { 0x01de07, 0x0173b3, 0x0173b3,  21,   -253,  12,  21 }, /* VERR_IO_BAD_COMMAND */
    { 0x01e874, 0x015c18, 0x015c18,  22,   -252,  10,  22 }, /* VERR_IO_NOT_READY */
    { 0x01ebce, 0x019c5b, 0x019c5b,  18,   -251,   9,  18 }, /* VERR_IO_BAD_UNIT */
    { 0x01ecdc, 0x011da0, 0x011da0,  27,   -250,   9,  27 }, /* VERR_DEV_IO_ERROR */
    { 0x014b5e, 0x008198, 0x008198,  48,   -234,  23,  48 }, /* VERR_IPE_NOT_REACHED_DEFAULT_CASE */
    { 0x016206, 0x0061c8, 0x0061c8,  57,   -233,  22,  24 }, /* VERR_IPE_UNINITIALIZED_STATUS */
    { 0x01e103, 0x01e242, 0x01e242,  11,   -232,  11,  11 }, /* VERR_IPE_UNEXPECTED_ERROR_STATUS */
    { 0x01ca96, 0x01e242, 0x01e242,  11,   -231,  14,  11 }, /* VERR_IPE_UNEXPECTED_INFO_STATUS */
    { 0x01eb08, 0x01e242, 0x01e242,  11,   -230,   9,  11 }, /* VERR_IPE_UNEXPECTED_STATUS */
    { 0x01d1ad, 0x01ef52, 0x01ef52,   8,   -229,  13,   5 }, /* VERR_INTERNAL_ERROR_5 */
    { 0x01d1ee, 0x01ef52, 0x01f112,   8,   -228,  13,   5 }, /* VERR_INTERNAL_ERROR_4 */
    { 0x01d1c7, 0x01ef52, 0x01f05a,   8,   -227,  13,   5 }, /* VERR_INTERNAL_ERROR_3 */
    { 0x01d1e1, 0x01ef52, 0x01ef92,   8,   -226,  13,   5 }, /* VERR_INTERNAL_ERROR_2 */
    { 0x01d1ad, 0x018aa8, 0x018aa8,  19,   -225,  11,  19 }, /* VERR_INTERNAL_ERROR */
    { 0x01662a, 0x011530, 0x011530,  27,   -202,  21,  27 }, /* VERR_NO_MORE_SEARCH_HANDLES */
    { 0x01dbb0, 0x01eac0, 0x01eac0,   9,   -201,  12,   9 }, /* VERR_NO_MORE_FILES */
    { 0x01eb6b, 0x0100e2, 0x0100e2,  29,   -200,   9,  29 }, /* VERR_SEARCH_ERROR */
    { 0x01bd2e, 0x01cc3a, 0x01cc3a,  14,   -165,  15,  14 }, /* VERR_DRIVE_IS_EMPTY */
    { 0x01a5b7, 0x015cc8, 0x015cc8,  22,   -164,  17,  22 }, /* VERR_IS_A_CHAR_DEVICE */
    { 0x019469, 0x019a63, 0x019a63,  18,   -163,  18,  18 }, /* VERR_IS_A_BLOCK_DEVICE */
    { 0x01deeb, 0x01dbe0, 0x01dbe0,  12,   -162,  12,  12 }, /* VERR_IS_A_SOCKET */
    { 0x01e8e2, 0x01e734, 0x01e734,  10,   -161,  10,  10 }, /* VERR_IS_A_FIFO */
    { 0x01d340, 0x019227, 0x019227,  19,   -160,  13,  19 }, /* VERR_IS_A_SYMLINK */
    { 0x01a2ba, 0x01497b, 0x01497b,  23,   -159,  17,  23 }, /* VERR_SYMLINK_NOT_ALLOWED */
    { 0x013f2d, 0x00a807, 0x00a807,  40,   -158,  24,  40 }, /* VERR_NS_SYMLINK_CHANGE_OWNER */
    { 0x017e0d, 0x008640, 0x008640,  47,   -157,  20,  47 }, /* VERR_NS_SYMLINK_SET_TIME */
    { 0x01c4ea, 0x01a342, 0x01a342,  17,   -156,  15,  17 }, /* VERR_TOO_MANY_SYMLINKS */
    { 0x01d4fa, 0x01080c, 0x01080c,  28,   -155,  13,  28 }, /* VERR_DISK_INVALID_FORMAT */
    { 0x01d034, 0x01cb5a, 0x01cb5a,  14,   -154,  13,  14 }, /* VERR_DRIVE_LOCKED */
    { 0x01d994, 0x01cadc, 0x01cadc,  14,   -153,  12,  14 }, /* VERR_DISK_CHANGE */
    { 0x01e55e, 0x01e22c, 0x01e22c,  11,   -152,  10,  11 }, /* VERR_DISK_FULL */
    { 0x01f1eb, 0x01cdde, 0x01cdde,  14,   -151,   7,  14 }, /* VERR_INVALID_DRIVE */
    { 0x01e9d2, 0x00ecbd, 0x00ecbd,  31,   -150,  10,  31 }, /* VERR_DISK_IO_ERROR */
    { 0x019c13, 0x002a83, 0x002a83, 100,   -147,  18,  41 }, /* VERR_STALE_FILE_HANDLE */
    { 0x01025b, 0x001fc8, 0x001fc8, 110,   -146,  29,  65 }, /* VERR_FILE_AIO_INSUFFICIENT_EVENTS */
    { 0x01a870, 0x01a276, 0x01a276,  17,   -145,  17,  17 }, /* VERR_PATH_ZERO_LENGTH */
    { 0x019b5f, 0x008e0b, 0x008e0b,  45,   -144,  18,  45 }, /* VERR_PATH_IS_NOT_RELATIVE */
    { 0x01a40e, 0x00f16a, 0x00f16a,  30,   -143,  17,  30 }, /* VERR_PATH_IS_RELATIVE */
    { 0x011782, 0x00dab0, 0x00dab0,  33,   -142,  27,  33 }, /* VERR_PATH_DOES_NOT_START_WITH_ROOT */
    { 0x01d7ab, 0x019ef4, 0x019ef4,  18,   -141,  13,  18 }, /* VERR_UNEXPECTED_FS_OBJ_TYPE */
    { 0x01e662, 0x00dcd4, 0x00dcd4,  32,   -140,  10,  32 }, /* VERR_IS_A_FILE */
    { 0x01ef02, 0x00dbb4, 0x00dbb4,  32,   -139,   8,  32 }, /* VERR_NOT_A_FILE */
    { 0x01cd6e, 0x014f97, 0x014f97,  23,   -138,  14,  23 }, /* VERR_RESOURCE_BUSY */
    { 0x00d5a9, 0x00643b, 0x00643b,  57,   -137,  33,  57 }, /* VERR_FILE_AIO_INSUFFICIENT_RESSOURCES */
    { 0x018c70, 0x00b354, 0x00b354,  38,   -136,  19,  38 }, /* VERR_FILE_AIO_NOT_PREPARED */
    { 0x017589, 0x00a067, 0x00a067,  41,   -135,  20,  41 }, /* VERR_FILE_AIO_NOT_SUBMITTED */
    { 0x019793, 0x01dd53, 0x01dd53,  12,   -134,  18,  12 }, /* VERR_FILE_AIO_CANCELED */
    { 0x014125, 0x004de8, 0x004de8,  65,   -133,  24,  65 }, /* VERR_FILE_AIO_LIMIT_EXCEEDED */
    { 0x01ccd4, 0x004b51, 0x004b51,  67,   -132,  14,  67 }, /* VERR_FILE_AIO_BUSY */
    { 0x0191c8, 0x00ce05, 0x00ce05,  34,   -131,  19,  34 }, /* VERR_FILE_AIO_COMPLETED */
    { 0x016e5e, 0x0049fd, 0x0049fd,  68,   -130,  21,  68 }, /* VERR_FILE_AIO_IN_PROGRESS */
    { 0x019eac, 0x009ad8, 0x009ad8,  42,   -129,  18,  42 }, /* VERR_FILE_AIO_NO_REQUEST */
    { 0x01e5cc, 0x00714d, 0x00714d,  53,   -128,  10,  53 }, /* VERR_FILE_TOO_BIG */
    { 0x01bee1, 0x00e134, 0x00e134,  32,   -127,  15,  32 }, /* VERR_IS_A_DIRECTORY */
    { 0x01d7b8, 0x00e494, 0x00e494,  32,   -126,  13,  32 }, /* VERR_NOT_A_DIRECTORY */
    { 0x01e2e7, 0x0165d6, 0x0165d6,  21,   -125,  11,  21 }, /* VERR_DIR_NOT_EMPTY */
    { 0x01bd97, 0x012091, 0x012091,  26,   -124,  15,  26 }, /* VERR_FILE_LOCK_LOST */
    { 0x01d6b4, 0x00e9d5, 0x00e9d5,  31,   -123,  13,  31 }, /* VERR_FILE_NOT_LOCKED */
    { 0x0192dd, 0x00b140, 0x00b140,  38,   -122,  18,  22 }, /* VERR_MEDIA_NOT_RECOGNIZED */
    { 0x01be0f, 0x01630e, 0x01630e,  22,   -121,  15,  22 }, /* VERR_MEDIA_NOT_PRESENT */
    { 0x01c1cf, 0x010df3, 0x010df3,  28,   -120,  15,  28 }, /* VERR_FILENAME_TOO_LONG */
    { 0x01d410, 0x012aed, 0x012aed,  26,   -119,  13,  26 }, /* VERR_NOT_SAME_DEVICE */
    { 0x01604e, 0x0132e9, 0x0132e9,  25,   -118,  22,  25 }, /* VERR_CANT_DELETE_DIRECTORY */
    { 0x01df9f, 0x0160d2, 0x0160d2,  22,   -117,  12,  22 }, /* VERR_CANT_CREATE */
    { 0x01795d, 0x0071ec, 0x0071ec,  53,   -116,  20,  53 }, /* VERR_FILE_LOCK_VIOLATION */
    { 0x01d9e8, 0x0142bd, 0x0142bd,  24,   -115,  12,  24 }, /* VERR_FILE_LOCK_FAILED */
    { 0x0198fb, 0x00947a, 0x00947a,  44,   -114,  18,  44 }, /* VERR_SHARING_VIOLATION */
    { 0x01cfd6, 0x01c4cc, 0x01c4cc,  15,   -113,  14,  15 }, /* VERR_WRITE_PROTECT */
    { 0x01f08a, 0x01eb11, 0x01eb11,   9,   -112,   8,   9 }, /* VERR_WRITE_ERROR */
    { 0x01f311, 0x01f092, 0x01f092,   8,   -111,   7,   8 }, /* VERR_READ_ERROR */
    { 0x01f591, 0x017c19, 0x017c19,  20,   -110,   4,  20 }, /* VERR_EOF */
    { 0x01c481, 0x014aa6, 0x014aa6,  23,   -109,  15,  23 }, /* VERR_SEEK_ON_DEVICE */
    { 0x01cf90, 0x019349, 0x019349,  18,   -108,  14,  18 }, /* VERR_NEGATIVE_SEEK */
    { 0x01c481, 0x01f401, 0x01f401,   6,   -107,   5,   6 }, /* VERR_SEEK */
    { 0x01a991, 0x01d179, 0x01d179,  13,   -106,  17,  13 }, /* VERR_TOO_MANY_OPEN_FILES */
    { 0x01eeea, 0x0178f9, 0x0178f9,  20,   -105,   8,  20 }, /* VERR_ALREADY_EXISTS */
    { 0x01f473, 0x0106bc, 0x0106bc,  28,   -104,   6,  28 }, /* VERR_INVALID_NAME */
    { 0x01ef82, 0x01f318, 0x01f318,   7,   -103,   8,   7 }, /* VERR_PATH_NOT_FOUND */
    { 0x01efd2, 0x01f303, 0x01f303,   7,   -102,   8,   7 }, /* VERR_FILE_NOT_FOUND */
    { 0x01f2af, 0x01a17c, 0x01a17c,  18,   -101,   7,  18 }, /* VERR_OPEN_FAILED */
    { 0x01ea49, 0x011bba, 0x011bba,  27,   -100,  10,  27 }, /* VERR_FILE_IO_ERROR */
    { 0x01f0d2, 0x019156, 0x019156,  19,    -99,   8,  19 }, /* VERR_MISSING */
    { 0x01ea22, 0x017da9, 0x017da9,  20,    -98,  10,  20 }, /* VERR_DUPLICATE */
    { 0x01e19d, 0x01cd60, 0x01cd60,  14,    -97,  11,  14 }, /* VERR_UNSUPPORTED_ALIGNMENT */
    { 0x01d702, 0x0089ec, 0x0089ec,  46,    -96,  13,  46 }, /* VERR_NO_EXEC_MEMORY */
    { 0x01efea, 0x01e5ea, 0x01e5ea,  10,    -95,   8,  10 }, /* VERR_NO_CHANGE */
    { 0x0192ef, 0x002d9a, 0x002d9a,  97,    -93,  18,  32 }, /* VERR_CALLER_NO_REFERENCE */
    { 0x019ceb, 0x00e72b, 0x00e72b,  31,    -92,  18,  31 }, /* VERR_CONCURRENT_ACCESS */
    { 0x01eef2, 0x004931, 0x004931,  68,    -91,   8,  68 }, /* VERR_IGNORED */
    { 0x01cf82, 0x01ab29, 0x01ab29,  17,    -90,  14,  17 }, /* VERR_NOT_POWER_OF_TWO */
    { 0x0149d7, 0x014e3e, 0x014e3e,  23,    -89,  23,  23 }, /* VERR_AUTHENTICATION_FAILURE */
    { 0x01b34d, 0x00af46, 0x00af46,  39,    -88,  16,  39 }, /* VERR_CALLBACK_RETURN */
    { 0x01ae9d, 0x01a4eb, 0x01a4eb,  17,    -87,  17,  17 }, /* VERR_INVALID_BASE64_ENCODING */
    { 0x01a4a7, 0x013078, 0x013078,  25,    -86,  17,  25 }, /* VERR_DANGLING_OBJECTS */
    { 0x01a441, 0x0188a8, 0x0188a8,  19,    -85,  17,  19 }, /* VERR_OBJECT_DESTROYED */
    { 0x0148d5, 0x016a59, 0x016a59,  21,    -84,  24,  21 }, /* VERR_PAGE_COUNT_OUT_OF_RANGE */
    { 0x01cf12, 0x01df7b, 0x01df7b,  12,    -83,  14,  12 }, /* VERR_END_OF_STRING */
    { 0x01acb0, 0x00545d, 0x00545d,  62,    -82,  17,  21 }, /* VERR_PREEMPT_DISABLED */
    { 0x01cfe4, 0x00c2bf, 0x00c2bf,  36,    -81,  14,  36 }, /* VERR_NO_MORE_HANDLES */
    { 0x01a3b9, 0x01a83d, 0x01a83d,  17,    -80,  17,  17 }, /* VERR_OUT_OF_RESOURCES */
    { 0x01f1f9, 0x01f5ad, 0x01f5ad,   4,    -79,   7,   4 }, /* VERR_INVALID_STATE */
    { 0x01f5dc, 0x01ec70, 0x01ec70,   9,    -78,   3,   9 }, /* VERR_NOT_FOUND */
    { 0x01b56d, 0x01b30d, 0x01b30d,  16,    -77,  16,  16 }, /* VERR_TRAILING_SPACES */
    { 0x01c454, 0x017ee9, 0x017ee9,  20,    -76,  15,  20 }, /* VERR_TRAILING_CHARS */
    { 0x01f3ef, 0x01b6dd, 0x01b6dd,  16,    -75,   6,  16 }, /* VERR_MAP_FAILED */
    { 0x01d45e, 0x00c922, 0x00c922,  35,    -74,  13,  35 }, /* VERR_ADDRESS_TOO_BIG */
    { 0x01d075, 0x006635, 0x006635,  56,    -73,  13,  56 }, /* VERR_NO_PHYS_MEMORY */
    { 0x01dacc, 0x00772e, 0x00772e,  51,    -72,  12,  51 }, /* VERR_NO_LOW_MEMORY */
    { 0x01c970, 0x00618f, 0x00618f,  57,    -71,  14,  23 }, /* VERR_MEMOBJ_INIT_FAILED */
    { 0x01e7fc, 0x006ac4, 0x006ac4,  55,    -70,  10,  55 }, /* VERR_CANCELLED */
    { 0x01bafd, 0x00ac13, 0x00ac13,  39,    -69,  16,  39 }, /* VERR_TIMER_SUSPENDED */
    { 0x01d34d, 0x00c17b, 0x00c17b,  36,    -68,  13,  36 }, /* VERR_TIMER_ACTIVE */
    { 0x01da90, 0x00d504, 0x00d504,  33,    -67,  12,  33 }, /* VERR_MEMORY_BUSY */
    { 0x018f8e, 0x006402, 0x006402,  57,    -66,  19,  57 }, /* VERR_NO_CODE_POINT_MEMORY */
    { 0x01c9ee, 0x0051eb, 0x0051eb,  63,    -65,  14,  63 }, /* VERR_NO_UTF16_MEMORY */
    { 0x01db20, 0x008789, 0x008789,  47,    -64,  12,  47 }, /* VERR_NO_STR_MEMORY */
    { 0x016669, 0x0085e2, 0x0085e2,  47,    -63,  21,  47 }, /* VERR_CANT_RECODE_AS_UTF16 */
    { 0x01b1dd, 0x0096ad, 0x0096ad,  43,    -62,  16,  43 }, /* VERR_INVALID_UTF16_ENCODING */
    { 0x01c3fa, 0x00a03e, 0x00a03e,  41,    -61,  15,  41 }, /* VERR_INVALID_UTF8_ENCODING */
    { 0x016f30, 0x007a82, 0x007a82,  50,    -60,  21,  50 }, /* VERR_CODE_POINT_SURROGATE */
    { 0x010c34, 0x00420f, 0x00420f,  73,    -59,  28,  73 }, /* VERR_CODE_POINT_ENDIAN_INDICATOR */
    { 0x01d0dd, 0x009422, 0x009422,  44,    -58,  13,  44 }, /* VERR_NO_TRANSLATION */
    { 0x01a092, 0x00bcd2, 0x00bcd2,  37,    -57,  18,  37 }, /* VERR_NEGATIVE_UNSIGNED */
    { 0x01efb2, 0x00aa5f, 0x00aa5f,  40,    -56,   8,  40 }, /* VERR_NO_DIGITS */
    { 0x01ddbf, 0x00a0e2, 0x00a0e2,  41,    -55,  12,  41 }, /* VERR_NUMBER_TOO_BIG */
    { 0x01d2be, 0x01aac3, 0x01aac3,  17,    -54,  13,  17 }, /* VERR_OUT_OF_RANGE */
    { 0x01ef12, 0x01f0e2, 0x01f0e2,   8,    -53,   8,   8 }, /* VERR_PARSE_ERROR */
    { 0x01e9e6, 0x01f0aa, 0x01f0aa,   8,    -52,  10,   8 }, /* VERR_TRY_AGAIN */
    { 0x01b5bd, 0x00d43e, 0x00d43e,  33,    -51,  16,  33 }, /* VERR_PROCESS_RUNNING */
    { 0x01e048, 0x01f413, 0x01f413,   6,    -50,  11,   6 }, /* VERR_PROCESS_NOT_FOUND */
    { 0x01d05b, 0x01185a, 0x01185a,  27,    -49,  13,  27 }, /* VERR_INVALID_UUID_FORMAT */
    { 0x01c890, 0x004e6a, 0x004e6a,  65,    -48,  14,  10 }, /* VERR_STATE_CHANGED */
    { 0x01c094, 0x012571, 0x012571,  26,    -47,  15,  26 }, /* VERR_SIGNAL_INVALID */
    { 0x01c0d0, 0x018836, 0x018836,  19,    -46,  15,  19 }, /* VERR_SIGNAL_PENDING */
    { 0x01bb8a, 0x00fbc9, 0x00fbc9,  29,    -45,  15,  29 }, /* VERR_SIGNAL_REFUSED */
    { 0x019a75, 0x01caa4, 0x01caa4,  14,    -44,  18,  14 }, /* VERR_MAX_PROCS_REACHED */
    { 0x0199f7, 0x016d38, 0x016d38,  21,    -43,  18,  21 }, /* VERR_MAX_THRDS_REACHED */
    { 0x01e2a5, 0x01bdc4, 0x01bdc4,  15,    -42,  11,  15 }, /* VERR_TOO_MUCH_DATA */
    { 0x01b7dd, 0x011d85, 0x011d85,  27,    -41,  16,  27 }, /* VERR_BUFFER_OVERFLOW */
    { 0x01f09a, 0x01f0ca, 0x01f0ca,   8,    -40,   8,   8 }, /* VERR_TIMEOUT */
    { 0x01dad8, 0x01ae15, 0x01ae15,  17,    -39,  12,  17 }, /* VERR_INTERRUPTED */
    { 0x01cc9c, 0x01c7da, 0x01c7da,  14,    -38,  14,  14 }, /* VERR_ACCESS_DENIED */
    { 0x01f5c1, 0x01f4db, 0x01f4db,   5,    -37,   3,   5 }, /* VERR_NOT_SUPPORTED */
    { 0x01e770, 0x01e82e, 0x01e82e,  10,    -36,  10,  10 }, /* VERR_INVALID_FUNCTION */
    { 0x01d46b, 0x00c1c3, 0x00c1c3,  36,    -35,  13,  36 }, /* VERR_UNRESOLVED_ERROR */
    { 0x01aae5, 0x01a9a2, 0x01a9a2,  17,    -34,  17,  17 }, /* VERR_ADDRESS_CONFLICT */
    { 0x01e38c, 0x01937f, 0x01937f,  18,    -33,  11,  18 }, /* VERR_TIMER_BUSY */
    { 0x01ecca, 0x008cfa, 0x008cfa,  46,    -32,   9,   9 }, /* VERR_INVALID_CONTEXT */
    { 0x0176dd, 0x018434, 0x018434,  19,    -31,  20,  19 }, /* VERR_PAGE_TABLE_NOT_PRESENT */
    { 0x01abe4, 0x01781d, 0x01781d,  20,    -30,  17,  20 }, /* VERR_THREAD_NOT_WAITABLE */
    { 0x01c5bc, 0x01c2bf, 0x01c2bf,  15,    -29,  15,  15 }, /* VERR_THREAD_IS_DEAD */
    { 0x01d5d7, 0x0182d1, 0x0182d1,  20,    -28,  13,  20 }, /* VERR_ALREADY_INITIALIZED */
    { 0x01d256, 0x011c92, 0x011c92,  27,    -27,  13,  27 }, /* VERR_NO_PAGE_MEMORY */
    { 0x01d09c, 0x00ba82, 0x00ba82,  37,    -26,  13,  37 }, /* VERR_NO_CONT_MEMORY */
    { 0x019b4d, 0x004d66, 0x004d66,  65,    -24,  18,  65 }, /* VERR_FAILED_TO_SET_SELF_TLS */
    { 0x01cbae, 0x0052a8, 0x0052a8,  63,    -23,  14,  63 }, /* VERR_NO_TLS_FOR_SELF */
    { 0x01d8c8, 0x0168b5, 0x0168b5,  21,    -22,  12,  21 }, /* VERR_WRONG_ORDER */
    { 0x01f19e, 0x016274, 0x016274,  22,    -21,   7,  22 }, /* VERR_INVALID_FMODE */
    { 0x01da0c, 0x011023, 0x011023,  28,    -20,  12,  28 }, /* VERR_NO_TMP_MEMORY */
    { 0x01ecf7, 0x00f746, 0x00f746,  30,    -19,   9,  30 }, /* VERR_NOT_SYMLINK */
    { 0x01f2b6, 0x01e98c, 0x01e98c,  10,    -18,   7,  10 }, /* VERR_NOT_EQUAL */
    { 0x01f207, 0x01cb4c, 0x01cb4c,  14,    -13,   7,  14 }, /* VERR_INVALID_FLAGS */
    { 0x01d666, 0x0130dc, 0x0130dc,  25,    -12,  13,  25 }, /* VERR_NOT_IMPLEMENTED */
    { 0x01e568, 0x01ab07, 0x01ab07,  17,    -11,  10,  17 }, /* VERR_VERSION_MISMATCH */
    { 0x019bef, 0x0196a9, 0x0196a9,  18,    -10,  18,  18 }, /* VERR_PERMISSION_DENIED */
    { 0x01ef4a, 0x01c463, 0x01c463,  15,     -9,   8,  15 }, /* VERR_ALREADY_LOADED */
    { 0x01eff2, 0x0186e0, 0x0186e0,  19,     -8,   8,  19 }, /* VERR_NO_MEMORY */
    { 0x01f3e9, 0x01d4ed, 0x01d4ed,  13,     -7,   6,  13 }, /* VERR_IDT_FAILED */
    { 0x01ecc1, 0x01e6e4, 0x01e6e4,  10,     -6,   9,  10 }, /* VERR_INVALID_POINTER */
    { 0x01f31f, 0x016198, 0x016198,  22,     -5,   7,  22 }, /* VERR_LOCK_FAILED */
    { 0x01ef22, 0x01ef9a, 0x01ef9a,   8,     -4,   8,   8 }, /* VERR_INVALID_HANDLE */
    { 0x01f238, 0x01c292, 0x01c292,  15,     -3,   7,  15 }, /* VERR_INVALID_MAGIC */
    { 0x01e145, 0x01e0f8, 0x01e0f8,  11,     -2,  11,  11 }, /* VERR_INVALID_PARAMETER */
    { 0x01b0cd, 0x00c22f, 0x00c22f,  36,     -1,  16,  36 }, /* VERR_GENERAL_FAILURE */
    { 0x01f052, 0x01eed2, 0x01eed2,   8,      0,   8,   8 }, /* VINF_SUCCESS */
    { 0x01bbd5, 0x01e0f8, 0x01e0f8,  11,      2,  15,  11 }, /* VWRN_INVALID_PARAMETER */
    { 0x01e489, 0x01c292, 0x01c292,  15,      3,  11,  15 }, /* VWRN_INVALID_MAGIC */
    { 0x01da54, 0x01ef9a, 0x01ef9a,   8,      4,  12,   8 }, /* VWRN_INVALID_HANDLE */
    { 0x01947b, 0x0196a9, 0x0196a9,  18,     10,  18,  18 }, /* VINF_PERMISSION_DENIED */
    { 0x01d00d, 0x0130dc, 0x0130dc,  25,     12,  13,  25 }, /* VINF_NOT_IMPLEMENTED */
    { 0x01d784, 0x0182d1, 0x0182d1,  20,     28,  13,  20 }, /* VINF_ALREADY_INITIALIZED */
    { 0x01f5df, 0x01f4db, 0x01f4db,   5,     37,   3,   5 }, /* VINF_NOT_SUPPORTED */
    { 0x01d8b0, 0x01ae15, 0x01ae15,  17,     39,  12,  17 }, /* VINF_INTERRUPTED */
    { 0x01f03a, 0x01f0ca, 0x01f0ca,   8,     40,   8,   8 }, /* VINF_TIMEOUT */
    { 0x01ba7d, 0x011d85, 0x011d85,  27,     41,  16,  27 }, /* VINF_BUFFER_OVERFLOW */
    { 0x01999d, 0x003fc0, 0x003fc0,  74,     48,  18,  19 }, /* VWRN_STATE_CHANGED */
    { 0x01ea2c, 0x01f0aa, 0x01f0aa,   8,     52,  10,   8 }, /* VINF_TRY_AGAIN */
    { 0x01b2ad, 0x00a0e2, 0x00a0e2,  41,     55,  16,  41 }, /* VWRN_NUMBER_TOO_BIG */
    { 0x01d910, 0x00aa5f, 0x00aa5f,  40,     56,  12,  40 }, /* VWRN_NO_DIGITS */
    { 0x0158a9, 0x00bcd2, 0x00bcd2,  37,     57,  22,  37 }, /* VWRN_NEGATIVE_UNSIGNED */
    { 0x01a2cb, 0x009422, 0x009422,  44,     58,  17,  44 }, /* VWRN_NO_TRANSLATION */
    { 0x01840e, 0x017ee9, 0x017ee9,  20,     76,  19,  20 }, /* VWRN_TRAILING_CHARS */
    { 0x0183c1, 0x01b30d, 0x01b30d,  16,     77,  20,  16 }, /* VWRN_TRAILING_SPACES */
    { 0x01f223, 0x01b25d, 0x01b25d,  16,     78,   7,  16 }, /* VWRN_NOT_FOUND */
    { 0x01e258, 0x01e1a8, 0x01e1a8,  11,     79,  11,  11 }, /* VWRN_INVALID_STATE */
    { 0x0169c6, 0x013e3d, 0x013e3d,  24,     80,  21,  24 }, /* VWRN_OUT_OF_RESOURCES */
    { 0x01cff2, 0x01df7b, 0x01df7b,  12,     83,  14,  12 }, /* VINF_END_OF_STRING */
    { 0x01aa5d, 0x011b84, 0x011b84,  27,     85,  17,  27 }, /* VINF_OBJECT_DESTROYED */
    { 0x017431, 0x013078, 0x013078,  25,     86,  21,  25 }, /* VWRN_DANGLING_OBJECTS */
    { 0x01b02d, 0x00af46, 0x00af46,  39,     88,  16,  39 }, /* VINF_CALLBACK_RETURN */
    { 0x01f022, 0x01cbca, 0x01cbca,  14,     95,   8,  14 }, /* VINF_NO_CHANGE */
    { 0x01e308, 0x004e29, 0x004e29,  65,     97,  11,  65 }, /* VINF_UNSUPPORTED_ALIGNMENT */
    { 0x01dab4, 0x0178f9, 0x0178f9,  20,    105,  12,  20 }, /* VWRN_ALREADY_EXISTS */
    { 0x01f599, 0x017c19, 0x017c19,  20,    110,   4,  20 }, /* VINF_EOF */
    { 0x01a2fe, 0x008f73, 0x008f73,  45,    203,  17,  45 }, /* VWRN_NO_DIRENT_INFO */
    { 0x01f0a2, 0x019847, 0x019847,  18,    358,   8,  18 }, /* VINF_ALREADY_POSTED */
    { 0x01e410, 0x00409e, 0x00409e,  74,    364,  11,  37 }, /* VINF_SEM_NESTED */
    { 0x01d7d2, 0x0077c6, 0x0077c6,  50,    367,  13,  50 }, /* VINF_SEM_BAD_CONTEXT */
    { 0x01b8ed, 0x01a8f8, 0x01a8f8,  17,    500,  16,  17 }, /* VINF_TCP_SERVER_STOP */
    { 0x01845a, 0x00c1e7, 0x00c1e7,  36,    503,  19,  36 }, /* VINF_TCP_SERVER_NO_CLIENT */
    { 0x01b83d, 0x01a8f8, 0x01a8f8,  17,    520,  16,  17 }, /* VINF_UDP_SERVER_STOP */
    { 0x018bfe, 0x00c34f, 0x00c34f,  36,    523,  19,  36 }, /* VINF_UDP_SERVER_NO_CLIENT */
    { 0x017b15, 0x00944e, 0x00944e,  44,    564,  20,  44 }, /* VINF_IPC_RECEIVE_MSG_CUT */
    { 0x01a93c, 0x00a22a, 0x00a22a,  41,    565,  17,  41 }, /* VINF_IPC_SEND_MSG_CUT */
    { 0x015f46, 0x00c689, 0x00c689,  35,    690,  22,  35 }, /* VINF_DBG_ADJUSTED_SYM_SIZE */
    { 0x01e3c3, 0x009f1c, 0x009f1c,  42,    750,  11,  26 }, /* VINF_ENV_VAR_NOT_FOUND */
    { 0x012c25, 0x002e5c, 0x002e5c,  96,    751,  26,  96 }, /* VWRN_ENV_NOT_FULLY_TRANSLATED */
    { 0x01c9c4, 0x00ba13, 0x00ba13,  37,    753,  14,  37 }, /* VINF_ENV_VAR_UNSET */
    { 0x01bd79, 0x016140, 0x016140,  22,    828,  15,  22 }, /* VINF_GETOPT_NOT_OPTION */
    { 0x01d750, 0x01c7f6, 0x01c7f6,  14,    948,  13,  14 }, /* VINF_TAR_DIR_PATH */
    { 0x01eb3e, 0x01f535, 0x01f535,   5,   1002,   9,   5 }, /* VWRN_UNSUPPORTED_CPU */
    { 0x016909, 0x0085b3, 0x0085b3,  47,   1028,  21,  47 }, /* VINF_DRIVER_REBOOT_NEEDED */
    { 0x01d548, 0x009cd0, 0x009cd0,  42,   1100,  13,  42 }, /* VINF_EM_TERMINATE */
    { 0x0165c1, 0x001ae4, 0x001ae4, 120,   1101,  21,  25 }, /* VINF_EM_DBG_HYPER_STEPPED */
    { 0x0140f5, 0x001a6c, 0x001a6c, 120,   1102,  24, 120 }, /* VINF_EM_DBG_HYPER_BREAKPOINT */
    { 0x015260, 0x0012ce, 0x0012ce, 138,   1103,  23, 138 }, /* VINF_EM_DBG_HYPER_ASSERTION */
    { 0x01d35a, 0x00c277, 0x00c277,  36,   1104,  13,  36 }, /* VINF_EM_DBG_EVENT */
    { 0x01de13, 0x005c20, 0x005c20,  59,   1105,  12,  59 }, /* VINF_EM_DBG_STOP */
    { 0x01bcd4, 0x0067bd, 0x0067bd,  56,   1106,  15,  56 }, /* VINF_EM_DBG_STEPPED */
    { 0x019c01, 0x0042e9, 0x0042e9,  72,   1107,  18,  72 }, /* VINF_EM_DBG_BREAKPOINT */
    { 0x01bcd4, 0x0043c1, 0x0043c1,  71,   1108,  12,  31 }, /* VINF_EM_DBG_STEP */
    { 0x01f2cb, 0x004fed, 0x004fed,  64,   1109,   7,  64 }, /* VINF_EM_OFF */
    { 0x000096, 0x00586c, 0x00586c,  60,   1110,  11,  60 }, /* VINF_EM_SUSPEND */
    { 0x01ecb8, 0x006f6f, 0x006f6f,  54,   1111,   9,  54 }, /* VINF_EM_RESET */
    { 0x00008c, 0x00346f, 0x00346f,  87,   1112,   8,  87 }, /* VINF_EM_HALT */
    { 0x0000a4, 0x009e74, 0x009e74,  42,   1113,  10,  42 }, /* VINF_EM_RESUME */
    { 0x0106b0, 00000000, 00000000, 368,   1114,  11,  80 }, /* VINF_EM_NO_MEMORY */
    { 0x0197a5, 0x0002be, 0x0002be, 281,   1115,  18,  39 }, /* VINF_EM_RESCHEDULE_REM */
    { 0x01275f, 0x0003d7, 0x0003d7, 220,   1116,  26,  41 }, /* VINF_EM_RESCHEDULE_EXEC_ENGINE */
    { 0x01275f, 0x0039fe, 0x0039fe,  81,   1118,  14,  31 }, /* VINF_EM_RESCHEDULE */
    { 0x01d104, 0x00fffa, 0x00fffa,  29,   1120,  13,  29 }, /* VINF_EM_WAIT_SIPI */
    { 0x019955, 0x003150, 0x003150,  91,   1121,  18,  41 }, /* VINF_EM_RAW_GUEST_TRAP */
    { 0x0138c5, 0x003c7a, 0x003c7a,  78,   1122,  17,  39 }, /* VINF_EM_RAW_INTERRUPT */
    { 0x014c89, 0x000e1a, 0x000e1a, 158,   1123,  23,  58 }, /* VINF_EM_RAW_INTERRUPT_HYPER */
    { 0x015557, 0x00463b, 0x00463b,  70,   1124,  19,  32 }, /* VINF_EM_RAW_RING_SWITCH */
    { 0x015557, 0x002f7b, 0x002f7b,  95,   1125,  23,  57 }, /* VINF_EM_RAW_RING_SWITCH_INT */
    { 0x010828, 0x003b40, 0x003b40,  79,   1126,  28,  41 }, /* VINF_EM_RAW_EXCEPTION_PRIVILEGED */
    { 0x00e89f, 0x011c41, 0x011c41,  27,   1127,  21,  27 }, /* VINF_EM_RAW_EMULATE_INSTR */
    { 0x00ebe4, 0x00745d, 0x00745d,  52,   1128,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT */
    { 0x00ec22, 0x007221, 0x007221,  52,   1129,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT */
    { 0x00ec03, 0x007595, 0x007595,  52,   1130,  31,  27 }, /* VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT */
    { 0x00e89f, 0x006474, 0x006474,  57,   1131,  31,  32 }, /* VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT */
    { 0x01d3cf, 0x014cfc, 0x014cfc,  23,   1135,  13,  23 }, /* VINF_EM_RAW_TO_R3 */
    { 0x0170aa, 0x016c12, 0x016c12,  21,   1136,  21,  21 }, /* VINF_EM_RAW_TIMER_PENDING */
    { 0x0138c5, 0x00d945, 0x00d945,  33,   1137,  25,  33 }, /* VINF_EM_RAW_INTERRUPT_PENDING */
    { 0x016156, 0x013767, 0x013767,  25,   1138,  22,  25 }, /* VINF_EM_RAW_STALE_SELECTOR */
    { 0x01af25, 0x00c037, 0x00c037,  36,   1139,  17,  36 }, /* VINF_EM_RAW_IRET_TRAP */
    { 0x018d1b, 0x0197b7, 0x0197b7,  18,   1150,  19,  18 }, /* VINF_EM_PENDING_REQUEST */
    { 0x013fed, 0x010277, 0x010277,  29,   1151,  24,  29 }, /* VINF_EM_RAW_EMULATE_DBG_STEP */
    { 0x015cb2, 0x00ffc0, 0x00ffc0,  29,   1152,  22,  29 }, /* VINF_EM_HM_PATCH_TPR_INSTR */
    { 0x01b6bd, 0x004752, 0x004752,  69,   1155,  16,  32 }, /* VINF_EM_TRIPLE_FAULT */
    { 0x012e6b, 0x011eae, 0x011eae,  27,   1157,  25,  27 }, /* VINF_EM_RAW_INJECT_TRPM_EVENT */
    { 0x0128cb, 0x00bb85, 0x00bb85,  37,   1159,  26,  37 }, /* VINF_EM_PENDING_R3_IOPORT_READ */
    { 0x011ee4, 0x00b3a0, 0x00b3a0,  38,   1160,  27,  38 }, /* VINF_EM_PENDING_R3_IOPORT_WRITE */
    { 0x01260d, 0x005920, 0x005920,  60,   1161,  26,  60 }, /* VINF_EM_RESUME_R3_HISTORY_EXEC */
    { 0x015dd0, 0x001d9d, 0x001d9d, 112,   1162,  22,  33 }, /* VINF_EM_EMULATE_SPLIT_LOCK */
    { 0x01c83c, 0x00eba6, 0x00eba6,  31,   1202,  14,  31 }, /* VWRN_DBGF_ALREADY_HALTED */
    { 0x01cdd0, 0x00d6f3, 0x00d6f3,  33,   1205,  14,  33 }, /* VINF_DBGF_BP_ALREADY_ENABLED */
    { 0x01bbf3, 0x00c896, 0x00c896,  35,   1206,  15,  35 }, /* VINF_DBGF_BP_ALREADY_DISABLED */
    { 0x01de67, 0x01e93c, 0x01e93c,  10,   1207,  12,  10 }, /* VINF_DBGF_BP_ALREADY_EXIST */
    { 0x01ca0a, 0x01c265, 0x01c265,  15,   1209,  14,  15 }, /* VINF_DBGF_OS_NOT_DETCTED */
    { 0x0166bd, 0x0022c7, 0x0022c7, 108,   1211,  21,  18 }, /* VINF_DBGF_TRUNCATED_REGISTER */
    { 0x012e52, 0x001bd3, 0x001bd3, 118,   1212,  25,  22 }, /* VINF_DBGF_ZERO_EXTENDED_REGISTER */
    { 0x01e572, 0x003f2a, 0x003f2a,  75,   1224,  10,  75 }, /* VINF_DBGF_BP_HALT */
    { 0x017b65, 0x0080d8, 0x0080d8,  48,   1239,  20,  48 }, /* VINF_DBGF_R3_BP_OWNER_DEFER */
    { 0x016232, 0x008874, 0x008874,  47,   1400,  22,  47 }, /* VWRN_CONTINUE_ANALYSIS */
    { 0x01925f, 0x01ca7a, 0x01ca7a,  14,   1404,  18,  14 }, /* VWRN_PATCH_ENABLED */
    { 0x019fcc, 0x01bc6b, 0x01bc6b,  15,   1407,  18,  15 }, /* VWRN_PATCH_REMOVED */
    { 0x0191db, 0x00d798, 0x00d798,  33,   1408,  19,  33 }, /* VINF_PATM_PATCH_TRAP_GP */
    { 0x018f55, 0x00d690, 0x00d690,  33,   1409,  19,  33 }, /* VINF_PATM_PATCH_TRAP_PF */
    { 0x01b7cd, 0x00d08b, 0x00d08b,  34,   1410,  16,  34 }, /* VINF_PATM_PATCH_INT3 */
    { 0x015943, 0x00d903, 0x00d903,  33,   1411,  22,  33 }, /* VINF_PATM_CHECK_PATCH_PAGE */
    { 0x0146c5, 0x00d8c1, 0x00d8c1,  33,   1412,  24,  33 }, /* VINF_PATM_DUPLICATE_FUNCTION */
    { 0x017755, 0x012bbd, 0x012bbd,  26,   1413,  20,  26 }, /* VINF_PATCH_EMULATE_INSTR */
    { 0x015c70, 0x00f854, 0x00f854,  30,   1414,  22,  30 }, /* VINF_PATM_HC_MMIO_PATCH_WRITE */
    { 0x016c3c, 0x00fcce, 0x00fcce,  29,   1415,  21,  29 }, /* VINF_PATM_HC_MMIO_PATCH_READ */
    { 0x010630, 0x00b057, 0x00b057,  39,   1416,  28,  39 }, /* VINF_PATM_PENDING_IRQ_AFTER_IRET */
    { 0x016c27, 0x01440d, 0x01440d,  24,   1427,  21,  24 }, /* VWRN_PATCH_END_BRANCH */
    { 0x01b87d, 0x017679, 0x017679,  20,   1429,  16,  20 }, /* VINF_PATM_SPINLOCK_FAILED */
    { 0x01bed2, 0x00c56b, 0x00c56b,  36,   1430,  15,  36 }, /* VINF_PATCH_CONTINUE */
    { 0x014c5b, 0x01c732, 0x01c732,  14,   1500,  23,  14 }, /* VWRN_CSAM_TRAP_NOT_HANDLED */
    { 0x00fafe, 0x01b0dd, 0x01b0dd,  16,   1501,  29,  16 }, /* VWRN_CSAM_INSTRUCTION_PATCHED */
    { 0x01acc1, 0x01cb76, 0x01cb76,  14,   1502,  17,  14 }, /* VWRN_CSAM_PAGE_NOT_FOUND */
    { 0x018105, 0x00a201, 0x00a201,  41,   1503,  20,  41 }, /* VINF_CSAM_PENDING_ACTION */
    { 0x01e52c, 0x0129b5, 0x0129b5,  26,   1613,  10,  26 }, /* VINF_PGM_SYNC_CR3 */
    { 0x0173dd, 0x00d7fb, 0x00d7fb,  33,   1614,  21,  33 }, /* VINF_PGM_NO_DIRTY_BIT_TRACKING */
    { 0x013848, 0x007dfe, 0x007dfe,  49,   1615,  25,  49 }, /* VINF_PGM_HANDLED_DIRTY_BIT_FAULT */
    { 0x017aed, 0x001358, 0x001358, 138,   1616,  20,  31 }, /* VINF_PGM_HANDLER_DO_DEFAULT */
    { 0x01d41d, 0x01234f, 0x01234f,  26,   1622,  13,  26 }, /* VINF_PGM_CACHED_PAGE */
    { 0x01b1ad, 0x001685, 0x001685, 129,   1623,  16, 129 }, /* VINF_PGM_GCPHYS_ALIASED */
    { 0x01507d, 0x0011b2, 0x0011b2, 144,   1625,  23,  23 }, /* VINF_PGM_SYNCPAGE_MODIFIED_PDE */
    { 0x01642c, 0x00b51c, 0x00b51c,  38,   1635,  22,  38 }, /* VINF_PGM_PHYS_TLB_CATCH_WRITE */
    { 0x01a0c8, 0x010be0, 0x010be0,  28,   1643,  18,  28 }, /* VINF_PGM_HANDLER_ALREADY_ALIASED */
    { 0x017601, 0x00a677, 0x00a677,  40,   1644,  20,  40 }, /* VINF_PGM_POOL_FLUSH_PENDING */
    { 0x01ac5b, 0x00de74, 0x00de74,  32,   1758,  17,  32 }, /* VINF_CPUM_R3_MSR_READ */
    { 0x019a99, 0x00da2c, 0x00da2c,  33,   1759,  18,  33 }, /* VINF_CPUM_R3_MSR_WRITE */
    { 0x01514c, 0x008526, 0x008526,  47,   1766,  23,  47 }, /* VINF_CPUM_HOST_CR0_MODIFIED */
    { 0x016da1, 0x00c82d, 0x00c82d,  35,   1769,  21,  35 }, /* VINF_CPUM_MATCHED_BY_NAME */
    { 0x012b55, 0x018635, 0x018635,  19,   1851,  26,  19 }, /* VINF_SSM_VOTE_FOR_ANOTHER_PASS */
    { 0x00f70a, 0x0075c9, 0x0075c9,  51,   1852,  30,  51 }, /* VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN */
    { 0x018015, 0x00ca5d, 0x00ca5d,  35,   1854,  20,  35 }, /* VINF_SSM_DONT_CALL_AGAIN */
    { 0x018b8c, 0x005b34, 0x005b34,  59,   1864,  19,  59 }, /* VINF_SSM_LIVE_SUSPENDED */
    { 0x01ba2d, 0x011422, 0x011422,  27,   2008,  16,  27 }, /* VWRN_VRDP_PDU_NOT_SUPPORTED */
    { 0x01a375, 0x007fe8, 0x007fe8,  48,   2009,  17,  48 }, /* VINF_VRDP_PROCESS_PDU */
    { 0x01310e, 0x00e114, 0x00e114,  32,   2010,  25,  32 }, /* VINF_VRDP_OPERATION_COMPLETED */
    { 0x0182a9, 0x00cfe1, 0x00cfe1,  34,   2011,  20,  34 }, /* VINF_VRDP_THREAD_STARTED */
    { 0x015d8e, 0x006df5, 0x006df5,  54,   2012,  22,  54 }, /* VINF_VRDP_RESIZE_REQUESTED */
    { 0x018dc6, 0x00fe47, 0x00fe47,  29,   2013,  19,  29 }, /* VINF_VRDP_OUTPUT_ENABLE */
    { 0x01cc10, 0x00bf17, 0x00bf17,  36,   2503,  14,  36 }, /* VINF_SELM_SYNC_GDT */
    { 0x01b33d, 0x0130f5, 0x0130f5,  25,   2615,  16,  25 }, /* VINF_IOM_MMIO_UNUSED_00 */
    { 0x01b47d, 0x013609, 0x013609,  25,   2616,  16,  25 }, /* VINF_IOM_MMIO_UNUSED_FF */
    { 0x018c5d, 0x016aad, 0x016aad,  21,   2620,  19,  21 }, /* VINF_IOM_R3_IOPORT_READ */
    { 0x017d45, 0x015a09, 0x015a09,  22,   2621,  20,  22 }, /* VINF_IOM_R3_IOPORT_WRITE */
    { 0x011df1, 0x001602, 0x001602, 131,   2622,  27,  30 }, /* VINF_IOM_R3_IOPORT_COMMIT_WRITE */
    { 0x0179ad, 0x01c7b0, 0x01c7b0,  14,   2623,  14,  14 }, /* VINF_IOM_R3_MMIO_READ */
    { 0x01bf3b, 0x01bcb6, 0x01bcb6,  15,   2624,  15,  15 }, /* VINF_IOM_R3_MMIO_WRITE */
    { 0x0179ad, 0x017ab1, 0x017ab1,  20,   2625,  20,  20 }, /* VINF_IOM_R3_MMIO_READ_WRITE */
    { 0x015b26, 0x001784, 0x001784, 125,   2626,  22,  23 }, /* VINF_IOM_R3_MMIO_COMMIT_WRITE */
    { 0x01b54d, 0x00f07a, 0x00f07a,  30,   2712,  16,  30 }, /* VINF_VMM_CALL_TRACER */
    { 0x01b71d, 0x016b16, 0x016b16,  21,   2714,  16,  21 }, /* VINF_VMM_UNKNOWN_RING3_CALL */
    { 0x01ed99, 0x014065, 0x014065,  24,   2824,   9,  24 }, /* VINF_PDM_ALREADY_LOADED */
    { 0x013780, 0x008258, 0x008258,  48,   2846,  25,  48 }, /* VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN */
    { 0x01148e, 0x01abc2, 0x01abc2,  17,   2898,  27,  17 }, /* VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS */
    { 0x016edc, 0x00c8dc, 0x00c8dc,  35,   2901,  21,  35 }, /* VINF_HGCM_CLIENT_REJECTED */
    { 0x01904c, 0x009b80, 0x009b80,  42,   2903,  19,  42 }, /* VINF_HGCM_ASYNC_EXECUTE */
    { 0x01b11d, 0x01bc89, 0x01bc89,  15,   2906,  16,  15 }, /* VINF_HGCM_SAVE_STATE */
    { 0x016fed, 0x011a5b, 0x011a5b,  27,   3209,  21,  27 }, /* VINF_VD_ASYNC_IO_FINISHED */
    { 0x017ad9, 0x00674d, 0x00674d,  56,   3283,  20,  56 }, /* VINF_VD_NEW_ZEROED_BLOCK */
    { 0x015374, 0x0105a3, 0x0105a3,  29,   3501,  23,  29 }, /* VINF_VGA_RESIZE_IN_PROGRESS */
    { 0x01042a, 0x004569, 0x004569,  70,   3746,  29,  70 }, /* VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED */
    { 0x00f50c, 0x010614, 0x010614,  28,   3827,  30,  28 }, /* VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED */
    { 0x01d63f, 0x00e823, 0x00e823,  31,   3901,  13,  31 }, /* VINF_GVM_NOT_BLOCKED */
    { 0x01b8cd, 0x009a84, 0x009a84,  42,   3902,  16,  42 }, /* VINF_GVM_NOT_BUSY_IN_GC */
    { 0x01d850, 0x0072f1, 0x0072f1,  52,   3903,  12,  52 }, /* VINF_GVM_YIELDED */
    { 0x01e01c, 0x010c18, 0x010c18,  28,   4033,  11,  28 }, /* VINF_VMX_VMEXIT */
    { 0x0163a8, 0x005a0d, 0x005a0d,  59,   4035,  22,  59 }, /* VINF_VMX_INTERCEPT_NOT_ACTIVE */
    { 0x016458, 0x00390a, 0x00390a,  82,   4036,  22,  82 }, /* VINF_VMX_MODIFIES_BEHAVIOR */
    { 0x015699, 0x00631e, 0x00631e,  57,   4037,  22,  57 }, /* VINF_VMX_VMLAUNCH_VMRESUME */
    { 0x01dfda, 0x00da6e, 0x00da6e,  33,   4067,  11,  33 }, /* VINF_SVM_VMEXIT */
    { 0x01e9f0, 0x004d24, 0x004d24,  66,   4068,  10,  66 }, /* VINF_SVM_VMRUN */
    { 0x015a77, 0x005a48, 0x005a48,  59,   4069,  22,  59 }, /* VINF_SVM_INTERCEPT_NOT_ACTIVE */
    { 0x01b8bd, 0x007d9c, 0x007d9c,  49,   4117,  16,  49 }, /* VINF_HM_DOUBLE_FAULT */
    { 0x01b7bd, 0x00afe2, 0x00afe2,  39,   4118,  16,  39 }, /* VINF_HM_PENDING_XCPT */
    { 0x0171bb, 0x019a3f, 0x019a3f,  18,   4400,  21,  18 }, /* VINF_PARAV_SWITCH_TO_HOST */
    { 0x01aed0, 0x0071b7, 0x0071b7,  53,   4500,  17,  53 }, /* VINF_VHWA_CMD_PENDING */
    { 0x01a8c5, 0x005c5b, 0x005c5b,  59,   4800,  17,  59 }, /* VINF_AIO_TASK_PENDING */
    { 0x01a2ed, 0x003813, 0x003813,  83,   5150,  17,  83 }, /* VINF_PCI_MAPPING_DONE */
    { 0x01ccfe, 0x001e7c, 0x001e7c, 111,   5305,  14,  72 }, /* VINF_IEM_SELECTOR_NOT_OK */
    { 0x0192a7, 0x0041c6, 0x0041c6,  73,   5306,  18,  52 }, /* VINF_IEM_YIELD_PENDING_FF */
    { 0x01aa19, 0x0088a3, 0x0088a3,  47,   5310,  14,  47 }, /* VINF_IEM_REEXEC_BREAK */
    { 0x01aa19, 0x00700f, 0x00700f,  53,   5311,  17,  53 }, /* VINF_IEM_REEXEC_BREAK_FF */
    { 0x0126c3, 0x003ede, 0x003ede,  76,   5312,  26,  76 }, /* VINF_IEM_REEXEC_FINISH_WITH_FLAGS */
    { 0x01d632, 0x009dcc, 0x009dcc,  42,   5313,  13,  42 }, /* VINF_IEM_REEXEC_JUMP */
    { 0x01963d, 0x00b97f, 0x00b97f,  37,   5319,  18,  37 }, /* VINF_IEM_RECOMPILE_END_TB */
    { 0x0167f8, 0x016350, 0x016350,  22,   5401,  21,  22 }, /* VWRN_DBGC_CMD_PENDING */
    { 0x016df5, 0x01538b, 0x01538b,  23,   5402,  21,  23 }, /* VWRN_DBGC_ALREADY_REGISTERED */
    { 0x01a9d5, 0x01dc40, 0x01dc40,  12,   5406,  17,  12 }, /* VINF_DBGC_BP_NO_COMMAND */
    { 0x01dd5f, 0x013e55, 0x013e55,  24,   5699,  12,  24 }, /* VINF_SUP_DRIVERLESS */
    { 0x00eb87, 0x00ab4f, 0x00ab4f,  40,   6220,  31,  40 }, /* VWRN_GSTCTL_OBJECTSTATE_CHANGED */
    { 0x01aad4, 0x00a4e3, 0x00a4e3,  41,   6316,  17,  41 }, /* VINF_GIM_R3_HYPERCALL */
    { 0x013686, 0x006b69, 0x006b69,  55,   6317,  25,  55 }, /* VINF_GIM_HYPERCALL_CONTINUING */
    { 0x012711, 0x0037c0, 0x0037c0,  83,   6605,  26,  19 }, /* VINF_AUDIO_MORE_DATA_AVAILABLE */
    { 0x00ecfb, 0x0019f3, 0x0019f3, 121,   6609,  31, 121 }, /* VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED */
    { 0x01cda6, 0x0111ff, 0x0111ff,  28,   6810,  14,  28 }, /* VINF_NEM_FLUSH_TLB */
    { 0x013fbd, 0x0094d2, 0x0094d2,  44,   6906,  24,  32 }, /* VINF_RECORDING_LIMIT_REACHED */
    { 0x0177b9, 0x001e0d, 0x001e0d, 111,   6907,  20,  37 }, /* VINF_RECORDING_THROTTLED */
    { 0x00e70c, 0x003206, 0x003206,  90,   6908,  31,  17 }, /* VWRN_RECORDING_ENCODING_SKIPPED */
    { 0x01b61d, 0x00470d, 0x00470d,  69,   7200,  16,  69 }, /* VINF_PDM_PCI_DO_DEFAULT */
    { 0x00e514, 0x00623a, 0x00623a,  57,   7311,  32,  57 }, /* VINF_IOMMU_ADDR_TRANSLATION_DISABLED */
    { 0x014905, 0x0051ac, 0x0051ac,  63,   7600,  12,  63 }, /* VINF_GCM_HANDLED */
    { 0x014905, 0x0068d5, 0x0068d5,  55,   7601,  24,  55 }, /* VINF_GCM_HANDLED_ADVANCE_RIP */
    { 0x01d2f2, 0x007662, 0x007662,  51,  22301,  13,  51 }, /* VINF_LOG_DISABLED */
    { 0x01de73, 0x01a6fa, 0x01a6fa,  17,  22302,  12,  17 }, /* VINF_LOG_NO_LOGGER */
    { 0x01ad38, 0x01acf4, 0x01acf4,  17,  22401,  17,  17 }, /* VINF_BUFFER_UNDERFLOW */
    { 0x018d08, 0x00b24a, 0x00b24a,  38,  22405,  19,  38 }, /* VINF_ACCOUNT_RESTRICTED */
    { 0x00c75b, 0x008e65, 0x008e65,  45,  22406,  35,  45 }, /* VWRN_UNABLE_TO_SATISFY_REQUIREMENTS */
    { 0x01c490, 0x01e355, 0x01e355,  11,  22409,  15,  11 }, /* VWRN_WRONG_TYPE */
    { 0x0157f9, 0x003866, 0x003866,  82,  22424,  22,  82 }, /* VINF_THREAD_IS_TERMINATING */
    { 0x017a11, 0x011659, 0x011659,  27,  22426,  20,  27 }, /* VWRN_FLOAT_UNDERFLOW */
    { 0x0188f4, 0x012335, 0x012335,  26,  22427,  19,  26 }, /* VWRN_FLOAT_OVERFLOW */
    { 0x01c89e, 0x01a85f, 0x01a85f,  17,  22428,  14,  17 }, /* VINF_REBOOT_NEEDED */
    { 0x01974b, 0x004da7, 0x004da7,  65,  22501,  18,  65 }, /* VINF_SYS_MAY_POWER_OFF */
    { 0x01dfcf, 0x01194d, 0x01194d,  27,  22821,  11,  27 }, /* VINF_ASN1_MORE_DATA */
    { 0x01e626, 0x0035c7, 0x0035c7,  85,  22822,  10,  85 }, /* VINF_ASN1_NOT_ENCODED */
    { 0x01ca34, 0x007182, 0x007182,  53,  22900,  14,  53 }, /* VINF_LDRVI_NOT_SIGNED */
    { 0x010586, 0x00def4, 0x00def4,  32,  23109,  29,  32 }, /* VINF_X509_NOT_SELFSIGNED_CERTIFICATE */
    { 0x018fda, 0x01b3dd, 0x01b3dd,  16,  23814,  19,  16 }, /* VINF_CR_KEY_WAS_DECRYPTED */
    { 0x01853e, 0x019c25, 0x019c25,  18,  24202,  19,  18 }, /* VINF_CR_DIGEST_DEPRECATED */
    { 0x017cf5, 0x01852b, 0x01852b,  19,  24203,  20,  19 }, /* VINF_CR_DIGEST_COMPROMISED */
    { 0x00febb, 0x010b00, 0x010b00,  28,  24204,  29,  28 }, /* VINF_CR_DIGEST_SEVERELY_COMPROMISED */
    { 0x014935, 0x007255, 0x007255,  52,  25007,  24,  52 }, /* VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE */
    { 0x00efa5, 0x01bd88, 0x01bd88,  15,  25704,  31,  15 }, /* VWRN_REST_UNABLE_TO_DECODE_DATE */
};

#include <iprt/bldprog-strtab.h>

static const char g_achStrTabStatusMsgStrTab[] =
{
/* 0x00000 = "Indicating that we\'ve got an out-of-memory condition and that we need to take the appropriate actions to deal with this. @remarks It might seem odd at first that this has lower priority than VINF_EM_HALT, VINF_EM_SUSPEND, and VINF_EM_RESUME. The reason is that these events are vital to correctly operating the VM. Also, they can\'t normally occur together with an out-of-memory condition, and even if that should happen the condition will be rediscovered before executing any more code." */
    '\xfa','\x89','w','e','\'','v','e',' ','g','o','t',' ','\x60','o','u','t','-','o','f','-','\x5c','c','o','n','d','i','t','i','o','n',' ','\x2a','\x89','w','e',' ','n','e','e','d',' ','\x08','t','a','k','e',' ','\x02','a','p','p','r','o','p','r','i','a','t','e',' ','a','c','t','i','o','n','s',' ','\x08','d','e','a','l',' ','\x1e','t','h','i','s','.',' ','@','r','e','m','a','r','k','s',' ','I','t',' ','m','i','g','h','t',' ','s','e','e','m',' ','o','d','d',' ','a','t',' ','f','i','r','s','t',' ','\x89','\xc9','\x1d','l','o','w','e','r',' ','p','r','i','o','r','i','t','y',' ','t','h','a','n',' ','\x19','E','M','_','H','A','L','T',',',' ','\x19','E','M','_','S','U','S','P','E','N','D',',',' ','\x2a','\x19','E','M','_','R','E','S','U','M','E','.',' ','\x03','r','e','a','s','o','n',' ','\x09','\x89','t','h','e','s','e',' ','e','v','e','n','t','s',' ','a','r','e',' ','v','i','t','a','l',' ','\x08','c','o','r','r','e','c','t','l','y',' ','o','p','e','r','a','t','i','n','g',' ','\x02','V','M','.',' ','A','l','s','o',',',' ','t','h','e','y',' ','c','a','n','\'','t',' ','n','o','r','m','a','l','l','y',' ','o','c','c','u','r',' ','t','o','g','e','t','h','e','r',' ','\x1e','\x60','o','u','t','-','o','f','-','\x5c','c','o','n','d','i','t','i','o','n',',',' ','\x2a','e','v','e','n',' ','i','f',' ','\x89','\xec','h','a','p','p','e','n',' ','\x02','c','o','n','d','i','t','i','o','n',' ','w','i','l','l',' ','\x90','r','e','d','i','s','c','o','v','e','r','e','d',' ','b','e','f','o','r','e',' ','e','x','e','c','u','t','i','n','g',' ','a','n','y',' ','\xf6','\x5e',
/* 0x00170 = "Conflict between the core memory and the intermediate paging context, try again. There are some very special conditions applying to the intermediate paging context (used during the world switches), and some times we continuously run into these when asking the host kernel for memory during VM init. Let us know if you run into this and we\'ll adjust the code so it tries harder to avoid it." */
    'C','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','c','o','r','e',' ','\x5c','\x2a','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',',',' ','t','r','y',' ','a','g','a','i','n','.',' ','T','h','e','r','e',' ','a','r','e',' ','s','o','m','e',' ','v','e','r','y',' ','s','p','e','c','i','a','l',' ','c','o','n','d','i','t','i','o','n','s',' ','a','p','p','l','y','i','n','g',' ','\x08','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','p','a','g','i','n','g',' ','c','o','n','t','e','x','t',' ','(','u','s','e','d',' ','d','u','r','i','n','g',' ','\x02','w','o','r','l','d',' ','s','w','i','t','c','h','e','s',')',',',' ','\x2a','s','o','m','e',' ','t','i','m','e','s',' ','w','e',' ','c','o','n','t','i','n','u','o','u','s','l','y',' ','r','u','n',' ','i','n','t','o',' ','t','h','e','s','e',' ','\xef','a','s','k','i','n','g',' ','\x02','h','o','s','t',' ','k','e','r','n','e','l',' ','\x0e','\x5c','d','u','r','i','n','g',' ','\xcf',' ','i','n','i','t','.',' ','L','e','t',' ','u','s',' ','k','n','o','w',' ','i','f',' ','y','o','u',' ','r','u','n',' ','i','n','t','o',' ','\xc9','\x2a','w','e','\'','l','l',' ','a','d','j','u','s','t',' ','\x02','c','o','d','e',' ','s','o',' ','i','t',' ','t','r','i','e','s',' ','h','a','r','d','e','r',' ','\x08','a','v','o','i','d',' ','i','t','.',
/* 0x002be = "Indicating that we should reschedule to recompiled execution. Typically caused by the main execution engine not being capable of executing code in the current CPU state, or would be doing it too slowly, and we must fall back to recompiled execution. @remarks Important to have a higher priority (lower number) than the other rescheduling status codes." */
    '\xfa','\x89','w','e',' ','\xec','r','e','s','c','h','e','d','u','l','e',' ','\x08','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',' ','T','y','p','i','c','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\x05','\xdb','c','a','p','a','b','l','e',' ','\x13','e','x','e','c','u','t','i','n','g',' ','c','o','d','e',' ','\x0d','\x02','\xd1','C','P','U',' ','s','t','a','t','e',',',' ','\x86','w','o','u','l','d',' ','\x90','d','o','i','n','g',' ','i','t',' ','\x8c','s','l','o','w','l','y',',',' ','\x2a','w','e',' ','m','u','s','t',' ','f','a','l','l',' ','b','a','c','k',' ','\x08','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n','.',' ','@','r','e','m','a','r','k','s',' ','I','m','p','o','r','t','a','n','t',' ','\x08','\xeb','a',' ','h','i','g','h','e','r',' ','p','r','i','o','r','i','t','y',' ','(','l','o','w','e','r',' ','n','u','m','b','e','r',')',' ','t','h','a','n',' ','\x02','o','t','h','e','r',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x003d7 = "Indicating that we should reschedule to the main execution engine. Mainly triggered in recompiled execution mode to switch back to the main execution engine when the CPU state is compatible with it again (or we\'re past the expensive portion of code that is deemed faster to recompile)." */
    '\xfa','\x89','w','e',' ','\xec','r','e','s','c','h','e','d','u','l','e',' ','\x08','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e','.',' ','M','a','i','n','l','y',' ','t','r','i','g','g','e','r','e','d',' ','\x0d','r','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',' ','m','o','d','e',' ','\x08','s','w','i','t','c','h',' ','b','a','c','k',' ','\x08','\x02','m','a','i','n',' ','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xef','\x02','C','P','U',' ','\xb0','\x09','c','o','m','p','a','t','i','b','l','e',' ','\x1e','i','t',' ','a','g','a','i','n',' ','(','o','r',' ','w','e','\'','r','e',' ','p','a','s','t',' ','\x02','e','x','p','e','n','s','i','v','e',' ','p','o','r','t','i','o','n',' ','\x13','c','o','d','e',' ','\x89','\x09','d','e','e','m','e','d',' ','f','a','s','t','e','r',' ','\x08','r','e','c','o','m','p','i','l','e',')','.',
/* 0x004b3 = "Process Purification Failure: NtAllocateVirtualMemory failed to get us suitable replacement memory for a chunk of executable memory that shouldn\'t be present in our process. (You will only see this message if you got potentially fatally buggy anti-virus software installed.)." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','A','l','l','o','c','a','t','e','\xe2','M','e','m','o','r','y',' ','\x88','\x08','g','e','t',' ','u','s',' ','s','u','i','t','a','b','l','e',' ','r','e','p','l','a','c','e','m','e','n','t',' ','\x5c','\x0e','a',' ','c','h','u','n','k',' ','\x13','e','x','e','c','u','t','a','b','l','e',' ','\x5c','\x89','s','h','o','u','l','d','n','\'','t',' ','\x90','p','r','e','s','e','n','t',' ','\x0d','o','u','r',' ','p','r','o','c','e','s','s','.',' ','(','Y','o','u',' ','w','i','l','l',' ','\xf7','s','e','e',' ','\xc9','m','e','s','s','a','g','e',' ','i','f',' ','y','o','u',' ','g','o','t',' ','p','o','t','e','n','t','i','a','l','l','y',' ','f','a','t','a','l','l','y',' ','b','u','g','g','y',' ','a','n','t','i','-','v','i','r','u','s',' ','s','o','f','t','w','a','r','e',' ','i','n','s','t','a','l','l','e','d','.',')','.',
/* 0x00588 = "The VMMR0.r0 module version does not match VBoxVMM.dll/so/dylib. If you just upgraded VirtualBox, please terminate all VMs and make sure that neither VBoxNetDHCP nor VBoxNetNAT is running. Then try again. If this error persists, try re-installing VirtualBox." */
    '\x03','V','M','M','R','0','.','r','0',' ','m','o','d','u','l','e',' ','\xb4','\x9c','\x05','\xe3','V','B','o','x','V','M','M','.','d','l','l','/','s','o','/','d','y','l','i','b','.',' ','I','f',' ','y','o','u',' ','j','u','s','t',' ','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',',',' ','p','l','e','a','s','e',' ','t','e','r','m','i','n','a','t','e',' ','a','l','l',' ','V','M','s',' ','\x2a','m','a','k','e',' ','s','u','r','e',' ','\x89','n','e','i','t','h','e','r',' ','V','B','o','x','N','e','t','D','H','C','P',' ','n','o','r',' ','V','B','o','x','N','e','t','N','A','T',' ','\x09','r','u','n','n','i','n','g','.',' ','T','h','e','n',' ','t','r','y',' ','a','g','a','i','n','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00656 = "Process Verification Failure: Symantec Endpoint Protection must be disabled for the VirtualBox VM processes. http://www.symantec.com/connect/articles/creating-application-control-exclusions-symantec-endpoint-protection-121." */
    '\x17','\x0c','\x12','S','y','m','a','n','t','e','c',' ','E','n','d','p','o','i','n','t',' ','P','r','o','t','e','c','t','i','o','n',' ','m','u','s','t',' ','\x90','d','i','s','a','b','l','e','d',' ','\x0e','\x02','\xe2','B','o','x',' ','\xcf',' ','p','r','o','c','e','s','s','e','s','.',' ','h','t','t','p',':','/','/','w','w','w','.','s','y','m','a','n','t','e','c','.','c','o','m','/','c','o','n','n','e','c','t','/','a','r','t','i','c','l','e','s','/','c','r','e','a','t','i','n','g','-','a','p','p','l','i','c','a','t','i','o','n','-','c','o','n','t','r','o','l','-','e','x','c','l','u','s','i','o','n','s','-','s','y','m','a','n','t','e','c','-','e','n','d','p','o','i','n','t','-','p','r','o','t','e','c','t','i','o','n','-','1','2','1','.',
/* 0x0070b = "The USB device instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','U','S','B',' ','\x8b','i','n','s','t','a','n','c','e',' ','\xc1','\xb4','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x007b4 = "The USB device helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','U','S','B',' ','\x8b','h','e','l','p','e','r',' ','\xc1','\xb4','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x0085b = "Not possible to attach further drivers to the driver. A driver which doesn't support attachments (below of course) will return this status code if it found that further drivers were configured to be attached to it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','a','t','t','a','c','h',' ','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','\x08','\x02','d','r','i','v','e','r','.',' ','A',' ','\xa8','\xc0','\xa5','\xb1','a','t','t','a','c','h','m','e','n','t','s',' ','(','b','e','l','o','w',' ','\x13','c','o','u','r','s','e',')',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xc9','s','t','a','t','u','s',' ','c','o','d','e',' ','i','f',' ','i','t',' ','f','o','u','n','d',' ','\x89','f','u','r','t','h','e','r',' ','d','r','i','v','e','r','s',' ','w','e','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x90','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x00901 = "The driver instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\xa8','i','n','s','t','a','n','c','e',' ','\xc1','\xb4','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x009a6 = "The device instance structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xc1','\xb4','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00a4b = "The PCI bus assigned to a device didn\'t have room for it. Either too many devices are configured on the same PCI bus, or there are some internal problem where PDM/PCI doesn't free up slots when unplugging devices." */
    '\x03','P','C','I',' ','b','u','s',' ','a','s','s','i','g','n','e','d',' ','\x08','a',' ','\x8b','d','i','d','n','\'','t',' ','\xeb','r','o','o','m',' ','\x0e','i','t','.',' ','E','i','t','h','e','r',' ','\x8c','\xa3','d','e','v','i','c','e','s',' ','a','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','o','n',' ','\x02','s','a','m','e',' ','P','C','I',' ','b','u','s',',',' ','\x86','t','h','e','r','e',' ','a','r','e',' ','s','o','m','e',' ','\x15','p','r','o','b','l','e','m',' ','w','h','e','r','e',' ','P','D','M','/','P','C','I',' ','\xa5','f','r','e','e',' ','u','p',' ','s','l','o','t','s',' ','\xef','u','n','p','l','u','g','g','i','n','g',' ','d','e','v','i','c','e','s','.',
/* 0x00aef = "The device helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\x8b','h','e','l','p','e','r',' ','\xc1','\xb4','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00b92 = "Invalid VM request type. For the VMR3ReqAlloc() case, the caller just specified an illegal enmType. For all the other occurrences it means indicates corruption, broken logic, or stupid interface user." */
    '\x0b','\xcf',' ','\x94','t','y','p','e','.',' ','F','o','r',' ','\x02','V','M','R','3','R','e','q','A','l','l','o','c','(',')',' ','c','a','s','e',',',' ','\x02','c','a','l','l','e','r',' ','j','u','s','t',' ','\x16','\x60','i','l','l','e','g','a','l',' ','e','n','m','T','y','p','e','.',' ','F','o','r',' ','a','l','l',' ','\x02','o','t','h','e','r',' ','o','c','c','u','r','r','e','n','c','e','s',' ','i','t',' ','m','e','a','n','s',' ','i','n','d','i','c','a','t','e','s',' ','c','o','r','r','u','p','t','i','o','n',',',' ','b','r','o','k','e','n',' ','l','o','g','i','c',',',' ','\x86','s','t','u','p','i','d',' ','i','n','t','e','r','f','a','c','e',' ','u','s','e','r','.',
/* 0x00c35 = "The driver helper structure version has changed.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x03','\xa8','h','e','l','p','e','r',' ','\xc1','\xb4','\x1d','c','h','a','n','g','e','d','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00cd8 = "Invalid RT request type. For the RTReqAlloc() case, the caller just specified an illegal enmType. For all the other occurrences it means indicates corruption, broken logic, or stupid interface user." */
    '\x0b','R','T',' ','\x94','t','y','p','e','.',' ','F','o','r',' ','\x02','R','T','R','e','q','A','l','l','o','c','(',')',' ','c','a','s','e',',',' ','\x02','c','a','l','l','e','r',' ','j','u','s','t',' ','\x16','\x60','i','l','l','e','g','a','l',' ','e','n','m','T','y','p','e','.',' ','F','o','r',' ','a','l','l',' ','\x02','o','t','h','e','r',' ','o','c','c','u','r','r','e','n','c','e','s',' ','i','t',' ','m','e','a','n','s',' ','i','n','d','i','c','a','t','e','s',' ','c','o','r','r','u','p','t','i','o','n',',',' ','b','r','o','k','e','n',' ','l','o','g','i','c',',',' ','\x86','s','t','u','p','i','d',' ','i','n','t','e','r','f','a','c','e',' ','u','s','e','r','.',
/* 0x00d7a = "Generic USB device structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','U','S','B',' ','\x8b','\xc1','\xb4','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00e1a = "Reason for leaving RC: Interrupted by external interrupt while in hypervisor code. The interrupt needed to be handled by the host OS and hypervisor execution must be resumed. VM state is not complete at this point." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xb9','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t',' ','w','h','i','l','e',' ','\x0d','h','y','p','e','r','v','i','s','o','r',' ','\x5e',' ','\x03','i','n','t','e','r','r','u','p','t',' ','n','e','e','d','e','d',' ','\x08','\x90','h','a','n','d','l','e','d',' ','\xb9','\x02','h','o','s','t',' ','O','S',' ','\x2a','h','y','p','e','r','v','i','s','o','r',' ','e','x','e','c','u','t','i','o','n',' ','m','u','s','t',' ','\x90','r','e','s','u','m','e','d','.',' ','\xcf',' ','\xb0','\x09','\x05','c','o','m','p','l','e','t','e',' ','a','t',' ','\xc9','p','o','i','n','t','.',
/* 0x00eb8 = "Generic driver structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','\xa8','\xc1','\xb4','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00f54 = "Generic device structure version mismatch.
If you have upgraded VirtualBox recently, please make sure you have terminated all VMs and upgraded any extension packs. If this error persists, try re-installing VirtualBox." */
    '\x96','\x8b','\xc1','\xb4','m','i','s','m','a','t','c','h','.','\x0a','I','f',' ','y','o','u',' ','\xeb','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y',',',' ','p','l','e','a','s','e',' ','m','a','k','e',' ','s','u','r','e',' ','y','o','u',' ','\xeb','t','e','r','m','i','n','a','t','e','d',' ','a','l','l',' ','V','M','s',' ','\x2a','u','p','g','r','a','d','e','d',' ','a','n','y',' ','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.',' ','I','f',' ','\xc9','\x07','p','e','r','s','i','s','t','s',',',' ','t','r','y',' ','r','e','-','i','n','s','t','a','l','l','i','n','g',' ','\xe2','B','o','x','.',
/* 0x00ff0 = "Process does not have the trusted code base (TCB) privilege needed for user authentication or/and process creation as a given user. TCB is also called \'Act as part of the operating system\'." */
    '\x17','\x9c','\x05','\xeb','\x02','t','r','u','s','t','e','d',' ','c','o','d','e',' ','b','a','s','e',' ','(','T','C','B',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','u','s','e','r',' ','a','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','o','r','/','a','n','d',' ','\x82','c','r','e','a','t','i','o','n',' ','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','T','C','B',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','A','c','t',' ','a','s',' ','p','a','r','t',' ','\x13','\x02','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m','\'','.',
/* 0x01087 = "Not possible to attach drivers to the device. A device which doesn't support attachments (below of course) will return this status code if it found that drivers were configured to be attached to it." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','a','t','t','a','c','h',' ','d','r','i','v','e','r','s',' ','\x08','\x02','d','e','v','i','c','e','.',' ','A',' ','\x8b','\xc0','\xa5','\xb1','a','t','t','a','c','h','m','e','n','t','s',' ','(','b','e','l','o','w',' ','\x13','c','o','u','r','s','e',')',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xc9','s','t','a','t','u','s',' ','c','o','d','e',' ','i','f',' ','i','t',' ','f','o','u','n','d',' ','\x89','d','r','i','v','e','r','s',' ','w','e','r','e',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x90','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x0111d = "The CPUID instruction returns different information when loading than when saved. Normally caused by hardware changes on the host, but could also be caused by changes in the BIOS setup." */
    '\x03','C','P','U','I','D',' ','\xba','r','e','t','u','r','n','s',' ','d','i','f','f','e','r','e','n','t',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\xef','l','o','a','d','i','n','g',' ','t','h','a','n',' ','\xef','s','a','v','e','d','.',' ','N','o','r','m','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','h','a','r','d','w','a','r','e',' ','c','h','a','n','g','e','s',' ','o','n',' ','\x02','h','o','s','t',',',' ','b','u','t',' ','c','o','u','l','d',' ','a','l','s','o',' ','\x90','c','a','u','s','e','d',' ','\xb9','c','h','a','n','g','e','s',' ','\x0d','\x02','B','I','O','S',' ','s','e','t','u','p','.',
/* 0x011b2 = "SyncPage modified the PDE. This is an internal status code used to communicate back to the #PF handler that the PDE was (probably) marked not-present and it should restart the instruction." */
    'S','y','n','c','P','a','g','e',' ','m','o','d','i','f','i','e','d',' ','\x02','P','D','E','.',' ','T','h','i','s',' ','\x09','\x60','\x15','s','t','a','t','u','s',' ','c','o','d','e',' ','u','s','e','d',' ','\x08','c','o','m','m','u','n','i','c','a','t','e',' ','b','a','c','k',' ','\x08','\x02','#','P','F',' ','h','a','n','d','l','e','r',' ','\x89','\x02','P','D','E',' ','\x10','(','p','r','o','b','a','b','l','y',')',' ','m','a','r','k','e','d',' ','n','o','t','-','p','r','e','s','e','n','t',' ','\x2a','i','t',' ','\xec','r','e','s','t','a','r','t',' ','\x02','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x01242 = "The VirtualBox version is not supported by one of the extension packs.
You have probably upgraded VirtualBox recently. Please upgrade the extension packs to versions compatible with this VirtualBox release." */
    '\x03','\xe2','B','o','x',' ','\xb4','\x09','\x05','\xf9','\xb9','o','n','e',' ','\x13','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s','.','\x0a','Y','o','u',' ','\xeb','p','r','o','b','a','b','l','y',' ','u','p','g','r','a','d','e','d',' ','\xe2','B','o','x',' ','r','e','c','e','n','t','l','y','.',' ','P','l','e','a','s','e',' ','u','p','g','r','a','d','e',' ','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','s',' ','\x08','v','e','r','s','i','o','n','s',' ','c','o','m','p','a','t','i','b','l','e',' ','\x1e','\xc9','\xe2','B','o','x',' ','r','e','l','e','a','s','e','.',
/* 0x012ce = "Hit a possible assertion in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','p','o','s','s','i','b','l','e',' ','a','s','s','e','r','t','i','o','n',' ','\x0d','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xc9','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01358 = "Go ahead with the default Read/Write operation. This is returned by a R3 physical or virtual handler when it wants the PGMPhys[Read|Write] routine do the reading/writing." */
    'G','o',' ','a','h','e','a','d',' ','\x1e','\x02','d','e','f','a','u','l','t',' ','R','e','a','d','/','W','r','i','t','e',' ','\xcc',' ','T','h','i','s',' ','\x09','r','e','t','u','r','n','e','d',' ','\xb9','a',' ','R','3',' ','p','h','y','s','i','c','a','l',' ','\x86','v','i','r','t','u','a','l',' ','h','a','n','d','l','e','r',' ','\xef','i','t',' ','w','a','n','t','s',' ','\x02','P','G','M','P','h','y','s','[','R','e','a','d','|','W','r','i','t','e',']',' ','r','o','u','t','i','n','e',' ','d','o',' ','\x02','r','e','a','d','i','n','g','/','w','r','i','t','i','n','g','.',
/* 0x013e2 = "The state doesn't match the VM configuration in one or another way. (There are certain PCI reconfiguration which the OS could potentially do which can cause this problem. Check this out when it happens.)." */
    '\x03','\xb0','\xa5','\xe3','\x02','\xcf',' ','\xe8','\x0d','o','n','e',' ','\x86','a','n','o','t','h','e','r',' ','w','a','y','.',' ','(','T','h','e','r','e',' ','a','r','e',' ','c','e','r','t','a','i','n',' ','P','C','I',' ','r','e','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xc0','\x02','O','S',' ','c','o','u','l','d',' ','p','o','t','e','n','t','i','a','l','l','y',' ','d','o',' ','\xc0','c','a','n',' ','c','a','u','s','e',' ','\xc9','p','r','o','b','l','e','m','.',' ','C','h','e','c','k',' ','\xc9','o','u','t',' ','\xef','i','t',' ','h','a','p','p','e','n','s','.',')','.',
/* 0x0146c = "Stream could not be created. This might due to missing host (backend) drivers or a host not having the required hardware, or that the requested stream configuration is not supported by the host backend." */
    'S','t','r','e','a','m',' ','c','o','u','l','d',' ','\x05','\x90','c','r','e','a','t','e','d','.',' ','T','h','i','s',' ','m','i','g','h','t',' ','d','u','e',' ','\x08','m','i','s','s','i','n','g',' ','h','o','s','t',' ','(','b','a','c','k','e','n','d',')',' ','d','r','i','v','e','r','s',' ','\x86','a',' ','h','o','s','t',' ','\x05','h','a','v','i','n','g',' ','\x02','r','e','q','u','i','r','e','d',' ','h','a','r','d','w','a','r','e',',',' ','\x86','\x89','\x02','\xbf','s','t','r','e','a','m',' ','\xe8','\x09','\x05','\xf9','\xb9','\x02','h','o','s','t',' ','b','a','c','k','e','n','d','.',
/* 0x014f5 = "Host backend couldn\'t be initialized. Happen if the audio server is not reachable, audio hardware is not available or similar. We should use the NULL audio driver." */
    'H','o','s','t',' ','b','a','c','k','e','n','d',' ','c','o','u','l','d','n','\'','t',' ','\x90','i','n','i','t','i','a','l','i','z','e','d','.',' ','H','a','p','p','e','n',' ','i','f',' ','\x02','a','u','d','i','o',' ','s','e','r','v','e','r',' ','\x09','\x05','r','e','a','c','h','a','b','l','e',',',' ','a','u','d','i','o',' ','h','a','r','d','w','a','r','e',' ','\x09','\x05','a','v','a','i','l','a','b','l','e',' ','\x86','s','i','m','i','l','a','r','.',' ','W','e',' ','\xec','u','s','e',' ','\x02','N','U','L','L',' ','a','u','d','i','o',' ','d','r','i','v','e','r','.',
/* 0x0157e = "The VMMRC.rc module version does not match VBoxVMM.dll/so/dylib. Re-install if you are a user. Developers should make sure the build is complete or try with a clean build." */
    '\x03','V','M','M','R','C','.','r','c',' ','m','o','d','u','l','e',' ','\xb4','\x9c','\x05','\xe3','V','B','o','x','V','M','M','.','d','l','l','/','s','o','/','d','y','l','i','b','.',' ','R','e','-','i','n','s','t','a','l','l',' ','i','f',' ','y','o','u',' ','a','r','e',' ','a',' ','u','s','e','r','.',' ','D','e','v','e','l','o','p','e','r','s',' ','\xec','m','a','k','e',' ','s','u','r','e',' ','\x02','b','u','i','l','d',' ','\x09','c','o','m','p','l','e','t','e',' ','\x86','t','r','y',' ','\x1e','a',' ','c','l','e','a','n',' ','b','u','i','l','d','.',
/* 0x01602 = "Reason for leaving RZ: Pending I/O port write. Since there is also VMCPU_FF_IOM for this condition, it\'s ok to drop this status code for some other VINF_EM_XXX statuses." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',' ','S','i','n','c','e',' ','t','h','e','r','e',' ','\x09','a','l','s','o',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0e','\xc9','c','o','n','d','i','t','i','o','n',',',' ','i','t','\'','s',' ','o','k',' ','\x08','d','r','o','p',' ','\xc9','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','s','o','m','e',' ','o','t','h','e','r',' ','\x19','E','M','_','X','X','X',' ','s','t','a','t','u','s','e','s','.',
/* 0x01685 = "Returned by handler registration, modification and deregistration when the shadow PTs could be updated because the guest page aliased or/and mapped by multiple PTs." */
    'R','e','t','u','r','n','e','d',' ','\xb9','h','a','n','d','l','e','r',' ','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xef','\x02','s','h','a','d','o','w',' ','P','T','s',' ','c','o','u','l','d',' ','\x90','u','p','d','a','t','e','d',' ','\x1c','\x02','\xa1','\xb6','a','l','i','a','s','e','d',' ','o','r','/','a','n','d',' ','m','a','p','p','e','d',' ','\xb9','m','u','l','t','i','p','l','e',' ','P','T','s','.',
/* 0x01706 = "Process Verification Failure: Image mapping is bogus as the first region has different AllocationBase and BaseAddress values, indicating that a section was unmapped or otherwise tampered with." */
    '\x17','\x0c','\x12','\xfe','\xe0','\x09','b','o','g','u','s',' ','a','s',' ','\x02','f','i','r','s','t',' ','r','e','g','i','o','n',' ','\x1d','d','i','f','f','e','r','e','n','t',' ','A','l','l','o','c','a','t','i','o','n','B','a','s','e',' ','\x2a','B','a','s','e','A','d','d','r','e','s','s',' ','v','a','l','u','e','s',',',' ','i','n','d','i','c','a','t','i','n','g',' ','\x89','a',' ','\xc6','\x10','u','n','m','a','p','p','e','d',' ','\x86','o','t','h','e','r','w','i','s','e',' ','t','a','m','p','e','r','e','d',' ','w','i','t','h','.',
/* 0x01784 = "Reason for leaving RZ: Pending MMIO write.  Since there is also VMCPU_FF_IOM for this condition, it\'s ok to drop this status code for some other VINF_EM_XXX statuses." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','\xf4',' ','w','r','i','t','e','.',' ',' ','S','i','n','c','e',' ','t','h','e','r','e',' ','\x09','a','l','s','o',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x0e','\xc9','c','o','n','d','i','t','i','o','n',',',' ','i','t','\'','s',' ','o','k',' ','\x08','d','r','o','p',' ','\xc9','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','s','o','m','e',' ','o','t','h','e','r',' ','\x19','E','M','_','X','X','X',' ','s','t','a','t','u','s','e','s','.',
/* 0x01801 = "The service was disabled on the host. Returned by pfnInit in VBoxService to indicated a non-fatal error that should results in the particular service being disabled." */
    '\x03','s','e','r','v','i','c','e',' ','\x10','d','i','s','a','b','l','e','d',' ','o','n',' ','\x02','h','o','s','t','.',' ','R','e','t','u','r','n','e','d',' ','\xb9','p','f','n','I','n','i','t',' ','\x0d','V','B','o','x','S','e','r','v','i','c','e',' ','\x08','i','n','d','i','c','a','t','e','d',' ','a',' ','n','o','n','-','f','a','t','a','l',' ','\x07','\x89','\xec','r','e','s','u','l','t','s',' ','\x0d','\x02','p','a','r','t','i','c','u','l','a','r',' ','s','e','r','v','i','c','e',' ','\xdb','d','i','s','a','b','l','e','d','.',
/* 0x0187e = "The MMIO range specified for removal was invalid. The range didn\'t match quite match a set of existing ranges. It\'s not possible to remove parts of a MMIO range, only one or more full ranges." */
    '\x03','\xf4',' ','\xe4','\x16','\x0e','r','e','m','o','v','a','l',' ','\x10','i','n','v','a','l','i','d','.',' ','\x03','\xe4','d','i','d','n','\'','t',' ','\xe3','q','u','i','t','e',' ','\xe3','a',' ','s','e','t',' ','\x13','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','s','.',' ','I','t','\'','s',' ','\x05','p','o','s','s','i','b','l','e',' ','\x08','r','e','m','o','v','e',' ','p','a','r','t','s',' ','\x13','a',' ','\xf4',' ','r','a','n','g','e',',',' ','\xf7','o','n','e',' ','\x86','\xf6','f','u','l','l',' ','r','a','n','g','e','s','.',
/* 0x018fb = "Address conflict within a module/segment. Attempted to add a segment, symbol or line number that fully or partially overlaps with an existing one." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t',' ','w','i','t','h','i','n',' ','a',' ','m','o','d','u','l','e','/','s','e','g','m','e','n','t','.',' ','A','t','t','e','m','p','t','e','d',' ','\x08','a','d','d',' ','a',' ','s','e','g','m','e','n','t',',',' ','s','y','m','b','o','l',' ','\x86','l','i','n','e',' ','\xdd','\x89','f','u','l','l','y',' ','\x86','p','a','r','t','i','a','l','l','y',' ','o','v','e','r','l','a','p','s',' ','\x1e','\x60','e','x','i','s','t','i','n','g',' ','o','n','e','.',
/* 0x01977 = "The physical handler range has no corresponding RAM range. If this is MMIO, see todo above the return. If not MMIO, then it\'s someone else\'s fault..." */
    '\x03','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\xe4','\x1d','\xe9','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','A','M',' ','r','a','n','g','e','.',' ','I','f',' ','\xc9','\x09','M','M','I','O',',',' ','s','e','e',' ','t','o','d','o',' ','a','b','o','v','e',' ','\x02','r','e','t','u','r','n','.',' ','I','f',' ','\x05','M','M','I','O',',',' ','t','h','e','n',' ','i','t','\'','s',' ','s','o','m','e','o','n','e',' ','e','l','s','e','\'','s',' ','f','a','u','l','t','.','.','.',
/* 0x019f3 = "Special PDMIHOSTAUDIO::pfnStreamCreate return value for triggering calling of PDMIHOSTAUDIO::pfnStreamInitAsync on a worker thread." */
    'S','p','e','c','i','a','l',' ','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','C','r','e','a','t','e',' ','r','e','t','u','r','n',' ','\xd2','\x0e','t','r','i','g','g','e','r','i','n','g',' ','c','a','l','l','i','n','g',' ','\x13','P','D','M','I','H','O','S','T','A','U','D','I','O',':',':','p','f','n','S','t','r','e','a','m','I','n','i','t','A','s','y','n','c',' ','o','n',' ','a',' ','w','o','r','k','e','r',' ','t','h','r','e','a','d','.',
/* 0x01a6c = "Hit a breakpoint in the hypervisor code, EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','i','t',' ','a',' ','\xab','\x0d','\x02','h','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',',',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xc9','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01ae4 = "Hypervisor code was stepped. EM will first send this to the debugger, and if the issue isn\'t resolved there it will enter guru meditation." */
    'H','y','p','e','r','v','i','s','o','r',' ','c','o','d','e',' ','\x10','s','t','e','p','p','e','d','.',' ','E','M',' ','w','i','l','l',' ','f','i','r','s','t',' ','s','e','n','d',' ','\xc9','\x08','\x02','d','e','b','u','g','g','e','r',',',' ','\x2a','i','f',' ','\x02','i','s','s','u','e',' ','i','s','n','\'','t',' ','r','e','s','o','l','v','e','d',' ','t','h','e','r','e',' ','i','t',' ','w','i','l','l',' ','e','n','t','e','r',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x01b5c = "Process does not have the assign primary token (APT) privilege needed for creating process as a given user. APT is also called \'Replace a process level token\'." */
    '\x17','\x9c','\x05','\xeb','\x02','a','s','s','i','g','n',' ','p','r','i','m','a','r','y',' ','t','o','k','e','n',' ','(','A','P','T',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','c','r','e','a','t','i','n','g',' ','\x82','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','A','P','T',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','R','e','p','l','a','c','e',' ','a',' ','\x82','l','e','v','e','l',' ','t','o','k','e','n','\'','.',
/* 0x01bd3 = "The value was zero extended to fit. For queries this means that the register is narrower than the queried value. For setters this means that the value is narrower than the register." */
    '\x03','\xd2','\x10','z','e','r','o',' ','e','x','t','e','n','d','e','d',' ','\x08','f','i','t','.',' ','F','o','r',' ','q','u','e','r','i','e','s',' ','\xc9','m','e','a','n','s',' ','\x89','\x02','\xbc','\x09','n','a','r','r','o','w','e','r',' ','t','h','a','n',' ','\x02','q','u','e','r','i','e','d',' ','\xd3',' ','F','o','r',' ','s','e','t','t','e','r','s',' ','\xc9','m','e','a','n','s',' ','\x89','\x02','\xd2','\x09','n','a','r','r','o','w','e','r',' ','t','h','a','n',' ','\x02','r','e','g','i','s','t','e','r','.',
/* 0x01c49 = "Failed while setting up a redirector rule. There probably is a conflict between the rule and some existing service on the computer." */
    '\x80','w','h','i','l','e',' ','s','e','t','t','i','n','g',' ','u','p',' ','a',' ','r','e','d','i','r','e','c','t','o','r',' ','r','u','l','e','.',' ','T','h','e','r','e',' ','p','r','o','b','a','b','l','y',' ','\x09','a',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','\x02','r','u','l','e',' ','\x2a','s','o','m','e',' ','e','x','i','s','t','i','n','g',' ','s','e','r','v','i','c','e',' ','o','n',' ','\x02','c','o','m','p','u','t','e','r','.',
/* 0x01cbb = "The specified I/O port range intruded on an existing range. There is a I/O port conflict between two device, or a device tried to register the same range twice." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe4','i','n','t','r','u','d','e','d',' ','o','n',' ','\x60','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',' ','T','h','e','r','e',' ','\x09','a',' ','I','/','O',' ','p','o','r','t',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','d','e','v','i','c','e',',',' ','\x86','a',' ','\x8b','t','r','i','e','d',' ','\x08','\xbc','\x02','s','a','m','e',' ','\xe4','t','w','i','c','e','.',
/* 0x01d2c = "Reading from the image was not possible because the offset is out of the image range. This usually indicates that there is a minor corruption in the image meta data." */
    'R','e','a','d','i','n','g',' ','f','r','o','m',' ','\x02','\x1a','\x10','\x05','p','o','s','s','i','b','l','e',' ','\x1c','\x02','o','f','f','s','e','t',' ','\x09','o','u','t',' ','\x13','\x02','\x1a','r','a','n','g','e','.',' ','T','h','i','s',' ','u','s','u','a','l','l','y',' ','i','n','d','i','c','a','t','e','s',' ','\x89','t','h','e','r','e',' ','\x09','a',' ','m','i','n','o','r',' ','c','o','r','r','u','p','t','i','o','n',' ','\x0d','\x02','\x1a','m','e','t','a',' ','d','a','t','a','.',
/* 0x01d9d = "Emulate split-lock access on SMP. This is also used for dealing with locked alignment conflicts with the host in general from IEM." */
    'E','m','u','l','a','t','e',' ','s','p','l','i','t','-','l','o','c','k',' ','a','c','c','e','s','s',' ','o','n',' ','S','M','P','.',' ','T','h','i','s',' ','\x09','a','l','s','o',' ','u','s','e','d',' ','\x0e','d','e','a','l','i','n','g',' ','\x1e','l','o','c','k','e','d',' ','a','l','i','g','n','m','e','n','t',' ','c','o','n','f','l','i','c','t','s',' ','\x1e','\x02','h','o','s','t',' ','\x0d','g','e','n','e','r','a','l',' ','f','r','o','m',' ','I','E','M','.',
/* 0x01e0d = "Recording has been throttled due to current settings. This e.g. can happen when submitting more video frames than the current FPS setting allows." */
    'R','e','c','o','r','d','i','n','g',' ','\x1d','\xad','t','h','r','o','t','t','l','e','d',' ','d','u','e',' ','\x08','\xd1','s','e','t','t','i','n','g','s','.',' ','T','h','i','s',' ','e','.','g','.',' ','c','a','n',' ','h','a','p','p','e','n',' ','\xef','s','u','b','m','i','t','t','i','n','g',' ','\xf6','v','i','d','e','o',' ','f','r','a','m','e','s',' ','t','h','a','n',' ','\x02','\xd1','F','P','S',' ','s','e','t','t','i','n','g',' ','a','l','l','o','w','s','.',
/* 0x01e7c = "Internal status code for indicating that a selector isn\'t valid (LAR, LSL, VERR, VERW). This is not used outside the instruction implementations." */
    '\x06','s','t','a','t','u','s',' ','c','o','d','e',' ','\x0e','i','n','d','i','c','a','t','i','n','g',' ','\x89','a',' ','s','e','l','e','c','t','o','r',' ','i','s','n','\'','t',' ','v','a','l','i','d',' ','(','L','A','R',',',' ','L','S','L',',',' ','V','E','R','R',',',' ','V','E','R','W',')','.',' ','T','h','i','s',' ','\x09','\x05','u','s','e','d',' ','o','u','t','s','i','d','e',' ','\x02','\xba','i','m','p','l','e','m','e','n','t','a','t','i','o','n','s','.',
/* 0x01eeb = "Invalid RT request state. The state of the request packet was not the expected and accepted one(s). Either the interface user screwed up, or we\'ve got corruption/broken logic." */
    '\x0b','R','T',' ','\x94','\xf5',' ','\x03','\xb0','\x13','\x02','\x94','p','a','c','k','e','t',' ','\x10','\x05','\x02','\xae','\x2a','a','c','c','e','p','t','e','d',' ','o','n','e','(','s',')','.',' ','E','i','t','h','e','r',' ','\x02','i','n','t','e','r','f','a','c','e',' ','u','s','e','r',' ','s','c','r','e','w','e','d',' ','u','p',',',' ','\x86','w','e','\'','v','e',' ','g','o','t',' ','c','o','r','r','u','p','t','i','o','n','/','b','r','o','k','e','n',' ','l','o','g','i','c','.',
/* 0x01f5a = "Reason for leaving RC: Guest tried to write to our GDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the gdtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','G','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xcf',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','g','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x01fc8 = "There are not enough events available on the host to create the I/O context. This exact meaning is host platform dependent." */
    'T','h','e','r','e',' ','a','r','e',' ','\x05','e','n','o','u','g','h',' ','e','v','e','n','t','s',' ','a','v','a','i','l','a','b','l','e',' ','o','n',' ','\x02','h','o','s','t',' ','\x08','c','r','e','a','t','e',' ','\x02','I','/','O',' ','c','o','n','t','e','x','t','.',' ','T','h','i','s',' ','e','x','a','c','t',' ','m','e','a','n','i','n','g',' ','\x09','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','d','e','p','e','n','d','e','n','t','.',
/* 0x02036 = "Reason for leaving RC: Guest tried to write to our IDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the idtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','I','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xcf',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','i','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x020a4 = "Reason for leaving RC: Guest tried to write to our LDT - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the ldtr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','L','D','T',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xcf',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','l','d','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x02112 = "Invalid VM request state. The state of the request packet was not the expected and accepted one(s). Either the interface user screwed up, or we\'ve got corruption/broken logic." */
    '\x0b','\xcf',' ','\x94','\xf5',' ','\x03','\xb0','\x13','\x02','\x94','p','a','c','k','e','t',' ','\x10','\x05','\x02','\xae','\x2a','a','c','c','e','p','t','e','d',' ','o','n','e','(','s',')','.',' ','E','i','t','h','e','r',' ','\x02','i','n','t','e','r','f','a','c','e',' ','u','s','e','r',' ','s','c','r','e','w','e','d',' ','u','p',',',' ','\x86','w','e','\'','v','e',' ','g','o','t',' ','c','o','r','r','u','p','t','i','o','n','/','b','r','o','k','e','n',' ','l','o','g','i','c','.',
/* 0x02180 = "The status field has not been updated yet as the request is still pending completion. Someone queried the iStatus field before the request has been fully processed." */
    '\x03','s','t','a','t','u','s',' ','\xff','\x1d','\x05','\xad','u','p','d','a','t','e','d',' ','y','e','t',' ','a','s',' ','\x02','\x94','\x09','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','c','o','m','p','l','e','t','i','o','n','.',' ','S','o','m','e','o','n','e',' ','q','u','e','r','i','e','d',' ','\x02','i','S','t','a','t','u','s',' ','\xff','b','e','f','o','r','e',' ','\x02','\x94','\x1d','\xad','f','u','l','l','y',' ','p','r','o','c','e','s','s','e','d','.',
/* 0x021ed = "The specified I/O port range was owned by some other device(s). Both registration and deregistration, but in the first case only RC and R0 ranges." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe4','\x10','o','w','n','e','d',' ','\xb9','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',' ','B','o','t','h',' ','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','b','u','t',' ','\x0d','\x02','f','i','r','s','t',' ','c','a','s','e',' ','\xf7','R','C',' ','\x2a','R','0',' ','r','a','n','g','e','s','.',
/* 0x0225a = "Reason for leaving RC: Guest tried to write to our TSS - fatal. The VM will be terminated assuming the worst, i.e. that the guest has read the ltr register." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','w','r','i','t','e',' ','\x08','o','u','r',' ','T','S','S',' ','-',' ','f','a','t','a','l','.',' ','\x03','\xcf',' ','w','i','l','l',' ','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','s','s','u','m','i','n','g',' ','\x02','w','o','r','s','t',',',' ','i','.','e','.',' ','\x89','\x02','\xa1','\x1d','r','e','a','d',' ','\x02','l','t','r',' ','r','e','g','i','s','t','e','r','.',
/* 0x022c7 = "The value was truncated to fit. For queries this means that the register is wider than the queried value. For setters this means that the value is wider than the register." */
    '\x03','\xd2','\x10','t','r','u','n','c','a','t','e','d',' ','\x08','f','i','t','.',' ','F','o','r',' ','q','u','e','r','i','e','s',' ','\xc9','m','e','a','n','s',' ','\x89','\x02','\xbc','\x09','w','i','d','e','r',' ','t','h','a','n',' ','\x02','q','u','e','r','i','e','d',' ','\xd3',' ','F','o','r',' ','s','e','t','t','e','r','s',' ','\xc9','m','e','a','n','s',' ','\x89','\x02','\xd2','\x09','w','i','d','e','r',' ','t','h','a','n',' ','\x02','r','e','g','i','s','t','e','r','.',
/* 0x02333 = "The version of the USB device registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb4','\x13','\x02','U','S','B',' ','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc1','\x09','\xfc','\x08','\xc9','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc1','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x0239f = "Process Verification Failure: Found executable memory allocated in the process. There is only supposed be executable memory associated with image file mappings (DLLs & EXE)." */
    '\x17','\x0c','\x12','F','o','u','n','d',' ','e','x','e','c','u','t','a','b','l','e',' ','\x5c','a','l','l','o','c','a','t','e','d',' ','\x0d','\x02','p','r','o','c','e','s','s','.',' ','T','h','e','r','e',' ','\x09','\xf7','s','u','p','p','o','s','e','d',' ','\x90','e','x','e','c','u','t','a','b','l','e',' ','\x5c','a','s','s','o','c','i','a','t','e','d',' ','\x1e','\x1a','\x18','m','a','p','p','i','n','g','s',' ','(','D','L','L','s',' ','&',' ','E','X','E',')','.',
/* 0x0240b = "No attached driver. The PDMDRVHLP::pfnAttach and PDMDEVHLP::pfnDriverAttach will return this error when no driver was configured to be attached." */
    '\xd0','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',' ','\x03','P','D','M','D','R','V','H','L','P',':',':','p','f','n','A','t','t','a','c','h',' ','\x2a','P','D','M','D','E','V','H','L','P',':',':','p','f','n','D','r','i','v','e','r','A','t','t','a','c','h',' ','w','i','l','l',' ','r','e','t','u','r','n',' ','\xc9','\x07','\xef','\xe9','\xa8','\x10','c','o','n','f','i','g','u','r','e','d',' ','\x08','\x90','a','t','t','a','c','h','e','d','.',
/* 0x02477 = "Process does not have the increase quota (IQ) privilege needed for creating a process as a given user. IQ is also called \'Increase quotas\'." */
    '\x17','\x9c','\x05','\xeb','\x02','i','n','c','r','e','a','s','e',' ','q','u','o','t','a',' ','(','I','Q',')',' ','p','r','i','v','i','l','e','g','e',' ','n','e','e','d','e','d',' ','\x0e','c','r','e','a','t','i','n','g',' ','a',' ','\x82','a','s',' ','a',' ','g','i','v','e','n',' ','u','s','e','r','.',' ','I','Q',' ','\x09','a','l','s','o',' ','c','a','l','l','e','d',' ','\'','I','n','c','r','e','a','s','e',' ','q','u','o','t','a','s','\'','.',
/* 0x024e1 = "The format of a data unit has changed. A SSM user returns this if it\'s not able to read the format for other reasons than u32Version." */
    '\x03','f','o','r','m','a','t',' ','\x13','a',' ','\x8f','u','n','i','t',' ','\x1d','c','h','a','n','g','e','d','.',' ','A',' ','S','S','M',' ','u','s','e','r',' ','r','e','t','u','r','n','s',' ','\xc9','i','f',' ','i','t','\'','s',' ','\x05','a','b','l','e',' ','\x08','r','e','a','d',' ','\x02','f','o','r','m','a','t',' ','\x0e','o','t','h','e','r',' ','r','e','a','s','o','n','s',' ','t','h','a','n',' ','u','3','2','V','e','r','s','i','o','n','.',
/* 0x0254b = "An attempt on detaching a driver without anyone actually being attached, or performing any other operation on an attached driver." */
    'A','n',' ','a','t','t','e','m','p','t',' ','o','n',' ','d','e','t','a','c','h','i','n','g',' ','a',' ','\xa8','w','i','t','h','o','u','t',' ','a','n','y','o','n','e',' ','a','c','t','u','a','l','l','y',' ','\xdb','a','t','t','a','c','h','e','d',',',' ','\x86','p','e','r','f','o','r','m','i','n','g',' ','a','n','y',' ','o','t','h','e','r',' ','\x83','o','n',' ','\x60','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',
/* 0x025b4 = "The version of the device registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb4','\x13','\x02','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc1','\x09','\xfc','\x08','\xc9','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc1','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x0261c = "The version of the driver registration structure is unknown to this VBox version. Either mixing incompatible versions or the structure isn\'t correctly initialized." */
    '\x03','\xb4','\x13','\x02','\xa8','r','e','g','i','s','t','r','a','t','i','o','n',' ','\xc1','\x09','\xfc','\x08','\xc9','V','B','o','x',' ','v','e','r','s','i','o','n','.',' ','E','i','t','h','e','r',' ','m','i','x','i','n','g',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','v','e','r','s','i','o','n','s',' ','\x86','\x02','\xc1','i','s','n','\'','t',' ','c','o','r','r','e','c','t','l','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x02684 = "Process Purification Failure: Both NtUnmapViewOfSetion and NtProtectVirtualMemory failed to get rid of or passify an non-image executable mapping." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','B','o','t','h',' ','N','t','U','n','m','a','p','V','i','e','w','O','f','S','e','t','i','o','n',' ','\x2a','N','t','P','r','o','t','e','c','t','\xe2','M','e','m','o','r','y',' ','\x88','\x08','g','e','t',' ','r','i','d',' ','\x13','\x86','p','a','s','s','i','f','y',' ','\x60','n','o','n','-','\x1a','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','i','n','g','.',
/* 0x026eb = "The configured driver wasn\'t found. Either the necessary driver modules wasn\'t loaded, the name was misspelled, or it was a misconfiguration." */
    '\x03','c','o','n','f','i','g','u','r','e','d',' ','\xa8','w','a','s','n','\'','t',' ','\x7d',' ','E','i','t','h','e','r',' ','\x02','n','e','c','e','s','s','a','r','y',' ','\xa8','m','o','d','u','l','e','s',' ','w','a','s','n','\'','t',' ','l','o','a','d','e','d',',',' ','\x02','\xf3','\x10','m','i','s','s','p','e','l','l','e','d',',',' ','\x86','i','t',' ','\x10','a',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x02752 = "The length of the segment name is out of range. This means it is an empty string or that it is greater or equal to RTDBG_SEGMENT_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x13','\x02','s','e','g','m','e','n','t',' ','\xf3','\x09','o','u','t',' ','\x13','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc7','\x86','\x89','i','t',' ','\x09','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x027b9 = "The driver properties were invalid, and as a consequence construction failed. Caused my unusable media or similar problems." */
    '\x03','\xa8','p','r','o','p','e','r','t','i','e','s',' ','w','e','r','e',' ','i','n','v','a','l','i','d',',',' ','\x2a','a','s',' ','a',' ','c','o','n','s','e','q','u','e','n','c','e',' ','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x24',' ','C','a','u','s','e','d',' ','m','y',' ','u','n','u','s','a','b','l','e',' ','m','e','d','i','a',' ','\x86','s','i','m','i','l','a','r',' ','p','r','o','b','l','e','m','s','.',
/* 0x02820 = "The media geometry hasn\'t been set yet, so it cannot be obtained. The caller should then calculate the geometry from the media size." */
    '\x03','m','e','d','i','a',' ','g','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xad','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xcb','\x90','o','b','t','a','i','n','e','d','.',' ','\x03','c','a','l','l','e','r',' ','\xec','t','h','e','n',' ','c','a','l','c','u','l','a','t','e',' ','\x02','g','e','o','m','e','t','r','y',' ','f','r','o','m',' ','\x02','m','e','d','i','a',' ','s','i','z','e','.',
/* 0x02886 = "The specified MMIO range was owned by some other device(s). Both registration and deregistration, but in the first case only RC and R0 ranges." */
    '\x03','\x16','\xf4',' ','\xe4','\x10','o','w','n','e','d',' ','\xb9','s','o','m','e',' ','o','t','h','e','r',' ','d','e','v','i','c','e','(','s',')','.',' ','B','o','t','h',' ','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x2a','d','e','r','e','g','i','s','t','r','a','t','i','o','n',',',' ','b','u','t',' ','\x0d','\x02','f','i','r','s','t',' ','c','a','s','e',' ','\xf7','R','C',' ','\x2a','R','0',' ','r','a','n','g','e','s','.',
/* 0x028ec = "Invalid RT request packet. One or more of the RT controlled packet members didn\'t contain the correct values. Some thing\'s broken." */
    '\x0b','R','T',' ','\x94','p','a','c','k','e','t','.',' ','O','n','e',' ','\x86','\xf6','\x13','\x02','R','T',' ','c','o','n','t','r','o','l','l','e','d',' ','p','a','c','k','e','t',' ','m','e','m','b','e','r','s',' ','d','i','d','n','\'','t',' ','c','o','n','t','a','i','n',' ','\x02','c','o','r','r','e','c','t',' ','v','a','l','u','e','s','.',' ','S','o','m','e',' ','t','h','i','n','g','\'','s',' ','b','r','o','k','e','n','.',
/* 0x02952 = "Too many digest algorithms used by PKCS #7 signed data. This is an internal limitation of the code that aims at saving kernel stack space." */
    '\xf0','\xa3','\xc2','a','l','g','o','r','i','t','h','m','s',' ','u','s','e','d',' ','\xb9','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',' ','T','h','i','s',' ','\x09','\x60','\x15','l','i','m','i','t','a','t','i','o','n',' ','\x13','\x02','c','o','d','e',' ','\x89','a','i','m','s',' ','a','t',' ','s','a','v','i','n','g',' ','k','e','r','n','e','l',' ','s','t','a','c','k',' ','s','p','a','c','e','.',
/* 0x029b8 = "The length of the symbol name is out of range. This means it is an empty string or that it\'s greater or equal to RTDBG_SYMBOL_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x13','\x02','s','y','m','b','o','l',' ','\xf3','\x09','o','u','t',' ','\x13','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc7','\x86','\x89','i','t','\'','s',' ','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x02a1e = "No available ports on the hub. This error is returned when a device is attempted created and/or attached to a hub which is out of ports." */
    '\xd0','a','v','a','i','l','a','b','l','e',' ','p','o','r','t','s',' ','o','n',' ','\x02','h','u','b','.',' ','T','h','i','s',' ','\x07','\x09','r','e','t','u','r','n','e','d',' ','\xef','a',' ','\x8b','\x09','a','t','t','e','m','p','t','e','d',' ','c','r','e','a','t','e','d',' ','a','n','d','/','o','r',' ','a','t','t','a','c','h','e','d',' ','\x08','a',' ','h','u','b',' ','\xc0','\x09','o','u','t',' ','\x13','p','o','r','t','s','.',
/* 0x02a83 = "The native file handle got stale while it was open. Can occur with files on network shares when the server is unresponsive." */
    '\x03','n','a','t','i','v','e',' ','\x18','h','a','n','d','l','e',' ','g','o','t',' ','s','t','a','l','e',' ','w','h','i','l','e',' ','i','t',' ','\x10','o','p','e','n','.',' ','C','a','n',' ','o','c','c','u','r',' ','\x1e','f','i','l','e','s',' ','o','n',' ','n','e','t','w','o','r','k',' ','s','h','a','r','e','s',' ','\xef','\x02','s','e','r','v','e','r',' ','\x09','u','n','r','e','s','p','o','n','s','i','v','e','.',
/* 0x02ae7 = "The virtual clock frequency differs too much. The clock source for the virtual time isn\'t reliable or the code have changed." */
    '\x03','v','i','r','t','u','a','l',' ','c','l','o','c','k',' ','f','r','e','q','u','e','n','c','y',' ','d','i','f','f','e','r','s',' ','\x8c','m','u','c','h','.',' ','\x03','c','l','o','c','k',' ','s','o','u','r','c','e',' ','\x0e','\x02','v','i','r','t','u','a','l',' ','t','i','m','e',' ','i','s','n','\'','t',' ','r','e','l','i','a','b','l','e',' ','\x86','\x02','c','o','d','e',' ','\xeb','c','h','a','n','g','e','d','.',
/* 0x02b4b = "Invalid VM request packet. One or more of the VM controlled packet members didn\'t contain the correct values. Some thing\'s broken." */
    '\x0b','\xcf',' ','\x94','p','a','c','k','e','t','.',' ','O','n','e',' ','\x86','\xf6','\x13','\x02','\xcf',' ','c','o','n','t','r','o','l','l','e','d',' ','p','a','c','k','e','t',' ','m','e','m','b','e','r','s',' ','d','i','d','n','\'','t',' ','c','o','n','t','a','i','n',' ','\x02','c','o','r','r','e','c','t',' ','v','a','l','u','e','s','.',' ','S','o','m','e',' ','t','h','i','n','g','\'','s',' ','b','r','o','k','e','n','.',
/* 0x02baf = "The specified MMIO range intruded on an existing range. There is a MMIO conflict between two device, or a device tried to register the same range twice." */
    '\x03','\x16','\xf4',' ','\xe4','i','n','t','r','u','d','e','d',' ','o','n',' ','\x60','e','x','i','s','t','i','n','g',' ','r','a','n','g','e','.',' ','T','h','e','r','e',' ','\x09','a',' ','\xf4',' ','c','o','n','f','l','i','c','t',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','d','e','v','i','c','e',',',' ','\x86','a',' ','\x8b','t','r','i','e','d',' ','\x08','\xbc','\x02','s','a','m','e',' ','\xe4','t','w','i','c','e','.',
/* 0x02c12 = "The reservation or reservation update was declined - too many VMs, too little memory, and/or too low GMM configuration." */
    '\x03','r','e','s','e','r','v','a','t','i','o','n',' ','\x86','r','e','s','e','r','v','a','t','i','o','n',' ','u','p','d','a','t','e',' ','\x10','d','e','c','l','i','n','e','d',' ','-',' ','\x8c','\xa3','V','M','s',',',' ','\x8c','l','i','t','t','l','e',' ','m','e','m','o','r','y',',',' ','a','n','d','/','o','r',' ','\x8c','l','o','w',' ','G','M','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x02c74 = "The lock validator detected an existing deadlock. The deadlock was not caused by the current operation, but existed already." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','\x60','e','x','i','s','t','i','n','g',' ','d','e','a','d','l','o','c','k','.',' ','\x03','d','e','a','d','l','o','c','k',' ','\x10','\x05','c','a','u','s','e','d',' ','\xb9','\x02','\xd1','o','p','e','r','a','t','i','o','n',',',' ','b','u','t',' ','e','x','i','s','t','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x02cd6 = "General failure during URB queuing. This will go away when the queueing gets proper status code handling." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','U','R','B',' ','q','u','e','u','i','n','g','.',' ','T','h','i','s',' ','w','i','l','l',' ','g','o',' ','a','w','a','y',' ','\xef','\x02','q','u','e','u','e','i','n','g',' ','g','e','t','s',' ','p','r','o','p','e','r',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','h','a','n','d','l','i','n','g','.',
/* 0x02d38 = "The below driver doesn't export a interface required by the drive having attached it. Typical misconfiguration problem." */
    '\x03','b','e','l','o','w',' ','\xa8','\xa5','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xb9','\x02','d','r','i','v','e',' ','h','a','v','i','n','g',' ','a','t','t','a','c','h','e','d',' ','i','t','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x02d9a = "The caller does not have a reference to the object. This status is used when two threads is caught sharing the same object reference." */
    '\x03','c','a','l','l','e','r',' ','\x9c','\x05','\xeb','a',' ','r','e','f','e','r','e','n','c','e',' ','\x08','\x02','o','b','j','e','c','t','.',' ','T','h','i','s',' ','s','t','a','t','u','s',' ','\x09','u','s','e','d',' ','\xef','t','w','o',' ','t','h','r','e','a','d','s',' ','\x09','c','a','u','g','h','t',' ','s','h','a','r','i','n','g',' ','\x02','s','a','m','e',' ','\x8d','r','e','f','e','r','e','n','c','e','.',
/* 0x02dfb = "Hit the global allocation limit. If you know there is still sufficient memory available, try raising the limit." */
    'H','i','t',' ','\x02','g','l','o','b','a','l',' ','a','l','l','o','c','a','t','i','o','n',' ','l','i','m','i','t','.',' ','I','f',' ','y','o','u',' ','k','n','o','w',' ','t','h','e','r','e',' ','\x09','s','t','i','l','l',' ','s','u','f','f','i','c','i','e','n','t',' ','\x5c','a','v','a','i','l','a','b','l','e',',',' ','t','r','y',' ','r','a','i','s','i','n','g',' ','\x02','l','i','m','i','t','.',
/* 0x02e5c = "Unable to translate all the variables in the default environment due to codeset issues (LANG / LC_ALL / LC_CTYPE)." */
    '\xca','\x08','t','r','a','n','s','l','a','t','e',' ','a','l','l',' ','\x02','v','a','r','i','a','b','l','e','s',' ','\x0d','\x02','d','e','f','a','u','l','t',' ','e','n','v','i','r','o','n','m','e','n','t',' ','d','u','e',' ','\x08','c','o','d','e','s','e','t',' ','i','s','s','u','e','s',' ','(','L','A','N','G',' ','/',' ','L','C','_','A','L','L',' ','/',' ','L','C','_','C','T','Y','P','E',')','.',
/* 0x02ebc = "The specified R0 or RC I/O port range didn\'t have a corresponding R3 range. IOMR3IOPortRegisterR3() must be called first." */
    '\x03','\x16','R','0',' ','\x86','R','C',' ','I','/','O',' ','p','o','r','t',' ','\xe4','d','i','d','n','\'','t',' ','\xeb','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',' ','I','O','M','R','3','I','O','P','o','r','t','R','e','g','i','s','t','e','r','R','3','(',')',' ','m','u','s','t',' ','\x90','c','a','l','l','e','d',' ','f','i','r','s','t','.',
/* 0x02f1c = "No PCI Bus is available to register the device with. This is usually a misconfiguration or in rare cases a buggy pci device." */
    '\xd0','P','C','I',' ','B','u','s',' ','\x09','a','v','a','i','l','a','b','l','e',' ','\x08','\xbc','\x02','\x8b','w','i','t','h','.',' ','T','h','i','s',' ','\x09','u','s','u','a','l','l','y',' ','a',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x86','\x0d','r','a','r','e',' ','c','a','s','e','s',' ','a',' ','b','u','g','g','y',' ','p','c','i',' ','d','e','v','i','c','e','.',
/* 0x02f7b = "Reason for leaving RC: A Ring switch was attempted using software interrupt. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x10','a','t','t','e','m','p','t','e','d',' ','u','s','i','n','g',' ','s','o','f','t','w','a','r','e',' ','i','n','t','e','r','r','u','p','t','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x13','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xc9','\x0d','R','E','M','.',
/* 0x02fda = "The length of the file name is out of range. This means it is an empty string or that it\'s greater or equal to RTDBG_FILE_NAME_LENGTH." */
    '\x03','l','e','n','g','t','h',' ','\x13','\x02','\x18','\xf3','\x09','o','u','t',' ','\x13','r','a','n','g','e','.',' ','T','h','i','s',' ','m','e','a','n','s',' ','i','t',' ','\x09','\x60','e','m','p','t','y',' ','\xc7','\x86','\x89','i','t','\'','s',' ','g','r','e','a','t','e','r',' ','\x86','e','q','u','a','l',' ','\x08','R','T','D','B','G','_','F','I','L','E','_','N','A','M','E','_','L','E','N','G','T','H','.',
/* 0x03038 = "The specified segment:offset address was invalid. Typically an attempt at addressing outside the segment boundary." */
    '\x03','\x16','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s',' ','\x10','i','n','v','a','l','i','d','.',' ','T','y','p','i','c','a','l','l','y',' ','\x60','a','t','t','e','m','p','t',' ','a','t',' ','a','d','d','r','e','s','s','i','n','g',' ','o','u','t','s','i','d','e',' ','\x02','s','e','g','m','e','n','t',' ','b','o','u','n','d','a','r','y','.',
/* 0x03096 = "The VM process was denied access to vboxdrv because someone have managed to open the process or its main thread with too broad access rights." */
    '\x03','\xcf',' ','\x82','\x10','d','e','n','i','e','d',' ','a','c','c','e','s','s',' ','\x08','v','b','o','x','d','r','v',' ','\x1c','s','o','m','e','o','n','e',' ','\xeb','m','a','n','a','g','e','d',' ','\x08','o','p','e','n',' ','\x02','\x82','\x86','i','t','s',' ','m','a','i','n',' ','t','h','r','e','a','d',' ','\x1e','\x8c','b','r','o','a','d',' ','a','c','c','e','s','s',' ','r','i','g','h','t','s','.',
/* 0x030f3 = "Not possible to detach a driver because the above driver/device doesn't support it. The above entity doesn't implement the pfnDetach call." */
    'N','o','t',' ','p','o','s','s','i','b','l','e',' ','\x08','d','e','t','a','c','h',' ','a',' ','\xa8','\x1c','\x02','a','b','o','v','e',' ','d','r','i','v','e','r','/','d','e','v','i','c','e',' ','\xa5','\xb1','i','t','.',' ','\x03','a','b','o','v','e',' ','e','n','t','i','t','y',' ','\xa5','i','m','p','l','e','m','e','n','t',' ','\x02','p','f','n','D','e','t','a','c','h',' ','c','a','l','l','.',
/* 0x03150 = "Reason for leaving RC: Guest trap which couldn\'t be handled in RC. The trap is generally forwarded to the REM and executed there." */
    '\x84','\x0e','\x25','R','C',':',' ','G','u','e','s','t',' ','t','r','a','p',' ','\xc0','c','o','u','l','d','n','\'','t',' ','\x90','h','a','n','d','l','e','d',' ','\x0d','R','C','.',' ','\x03','t','r','a','p',' ','\x09','g','e','n','e','r','a','l','l','y',' ','f','o','r','w','a','r','d','e','d',' ','\x08','\x02','R','E','M',' ','\x2a','e','x','e','c','u','t','e','d',' ','t','h','e','r','e','.',
/* 0x031ab = "A device encountered an unknown configuration value. This means that the device is potentially misconfigured and the device construction or unit attachment failed because of this." */
    'A',' ','\x8b','\x98','\x60','\xfc','\xe8','\xd3',' ','T','h','i','s',' ','m','e','a','n','s',' ','\x89','\x02','\x8b','\x09','p','o','t','e','n','t','i','a','l','l','y',' ','m','i','s','c','o','n','f','i','g','u','r','e','d',' ','\x2a','\x02','\x8b','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x86','u','n','i','t',' ','a','t','t','a','c','h','m','e','n','t',' ','\x88','\x1c','\x13','t','h','i','s','.',
/* 0x03206 = "Encoding skipped. Can happen if e.g. a frame is not visible or does not need to be encoded for whatever reason." */
    'E','n','c','o','d','i','n','g',' ','s','k','i','p','p','e','d','.',' ','C','a','n',' ','h','a','p','p','e','n',' ','i','f',' ','e','.','g','.',' ','a',' ','f','r','a','m','e',' ','\x09','\x05','v','i','s','i','b','l','e',' ','\x86','\x9c','\x05','n','e','e','d',' ','\x08','\x90','e','n','c','o','d','e','d',' ','\x0e','w','h','a','t','e','v','e','r',' ','r','e','a','s','o','n','.',
/* 0x03260 = "The image is required to be signed with the same certificate as the rest of VirtualBox or one of the special trusted (Oracle) certificates." */
    '\x03','\x1a','\x09','r','e','q','u','i','r','e','d',' ','\x08','\x90','s','i','g','n','e','d',' ','\x1e','\x02','s','a','m','e',' ','\x8a','a','s',' ','\x02','r','e','s','t',' ','\x13','\xe2','B','o','x',' ','\x86','o','n','e',' ','\x13','\x02','s','p','e','c','i','a','l',' ','t','r','u','s','t','e','d',' ','(','O','r','a','c','l','e',')',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x032b9 = "The above driver doesn't export a interface required by a driver being attached to it. Typical misconfiguration problem." */
    '\x03','a','b','o','v','e',' ','\xa8','\xa5','e','x','p','o','r','t',' ','a',' ','i','n','t','e','r','f','a','c','e',' ','r','e','q','u','i','r','e','d',' ','\xb9','a',' ','\xa8','\xdb','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x03312 = "A device didn\'t find a required interface with an attached driver. Typical misconfiguration problem." */
    'A',' ','\x8b','d','i','d','n','\'','t',' ','f','i','n','d',' ','a',' ','r','e','q','u','i','r','e','d',' ','i','n','t','e','r','f','a','c','e',' ','\x1e','\x60','a','t','t','a','c','h','e','d',' ','d','r','i','v','e','r','.',' ','T','y','p','i','c','a','l',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','p','r','o','b','l','e','m','.',
/* 0x0336a = "Syntax error - you hit a debugger feature which isn\'t implemented yet. (Feel free to help implement it.)." */
    '\xe1','\x07','-',' ','y','o','u',' ','h','i','t',' ','a',' ','d','e','b','u','g','g','e','r',' ','f','e','a','t','u','r','e',' ','\xc0','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',' ','(','F','e','e','l',' ','f','r','e','e',' ','\x08','h','e','l','p',' ','i','m','p','l','e','m','e','n','t',' ','i','t','.',')','.',
/* 0x033c1 = "The media translation hasn\'t been set yet, so it cannot be obtained. The caller should then guess the translation." */
    '\x03','m','e','d','i','a',' ','t','r','a','n','s','l','a','t','i','o','n',' ','h','a','s','n','\'','t',' ','\xad','s','e','t',' ','y','e','t',',',' ','s','o',' ','i','t',' ','\xcb','\x90','o','b','t','a','i','n','e','d','.',' ','\x03','c','a','l','l','e','r',' ','\xec','t','h','e','n',' ','g','u','e','s','s',' ','\x02','t','r','a','n','s','l','a','t','i','o','n','.',
/* 0x03418 = "The block driver type wasn\'t supported. Misconfiguration of the kind you get when attaching a floppy to an IDE controller." */
    '\x03','b','l','o','c','k',' ','\xa8','\xd9','w','a','s','n','\'','t',' ','\x95',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n',' ','\x13','\x02','k','i','n','d',' ','y','o','u',' ','g','e','t',' ','\xef','a','t','t','a','c','h','i','n','g',' ','a',' ','f','l','o','p','p','y',' ','\x08','\x60','I','D','E',' ','c','o','n','t','r','o','l','l','e','r','.',
/* 0x0346f = "Indicating that the VM has executed a halt instruction and that the emulation thread should wait for an interrupt before resuming execution." */
    '\xfa','\x89','\x02','\xcf',' ','\x1d','e','x','e','c','u','t','e','d',' ','a',' ','h','a','l','t',' ','\xba','\x2a','\x89','\x02','e','m','u','l','a','t','i','o','n',' ','t','h','r','e','a','d',' ','\xec','w','a','i','t',' ','\x0e','\x60','i','n','t','e','r','r','u','p','t',' ','b','e','f','o','r','e',' ','r','e','s','u','m','i','n','g',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x034c6 = "The specified R0 or RC MMIO range didn\'t have a corresponding R3 range. IOMR3MMIORegisterR3() must be called first." */
    '\x03','\x16','R','0',' ','\x86','R','C',' ','\xf4',' ','\xe4','d','i','d','n','\'','t',' ','\xeb','a',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','R','3',' ','r','a','n','g','e','.',' ','I','O','M','R','3','M','M','I','O','R','e','g','i','s','t','e','r','R','3','(',')',' ','m','u','s','t',' ','\x90','c','a','l','l','e','d',' ','f','i','r','s','t','.',
/* 0x0351d = "Returned by callback methods which does not need to be called again because the client does not actually make use of them." */
    'R','e','t','u','r','n','e','d',' ','\xb9','c','a','l','l','b','a','c','k',' ','m','e','t','h','o','d','s',' ','\xc0','\x9c','\x05','n','e','e','d',' ','\x08','\x90','c','a','l','l','e','d',' ','a','g','a','i','n',' ','\x1c','\x02','c','l','i','e','n','t',' ','\x9c','\x05','a','c','t','u','a','l','l','y',' ','m','a','k','e',' ','u','s','e',' ','\x13','t','h','e','m','.',
/* 0x03572 = "A VM api requiring EMT was called from another thread. Use the VMR3ReqCall() apis to call it!." */
    'A',' ','\xcf',' ','a','p','i',' ','r','e','q','u','i','r','i','n','g',' ','E','M','T',' ','\x10','c','a','l','l','e','d',' ','f','r','o','m',' ','a','n','o','t','h','e','r',' ','t','h','r','e','a','d','.',' ','U','s','e',' ','\x02','V','M','R','3','R','e','q','C','a','l','l','(',')',' ','a','p','i','s',' ','\x08','c','a','l','l',' ','i','t','!','.',
/* 0x035c7 = "RTAsnEncodeWriteHeader return code indicating that nothing was written and the content should be skipped as well." */
    'R','T','A','s','n','E','n','c','o','d','e','W','r','i','t','e','H','e','a','d','e','r',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','i','n','d','i','c','a','t','i','n','g',' ','\x89','n','o','t','h','i','n','g',' ','\x10','w','r','i','t','t','e','n',' ','\x2a','\x02','\xd8','\xec','\x90','s','k','i','p','p','e','d',' ','a','s',' ','w','e','l','l','.',
/* 0x0361c = "If a Host Interface Networking filehandle was specified it\'s not allowed to have any init or term programs." */
    'I','f',' ','a',' ','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','f','i','l','e','h','a','n','d','l','e',' ','\x10','\x16','i','t','\'','s',' ','\x05','a','l','l','o','w','e','d',' ','\x08','\xeb','a','n','y',' ','i','n','i','t',' ','\x86','t','e','r','m',' ','p','r','o','g','r','a','m','s','.',
/* 0x03670 = "Process Purification Failure: NtFreeVirtualMemory failed on a chunk of executable memory which shouldn\'t be present in the process." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','N','t','F','r','e','e','\xe2','M','e','m','o','r','y',' ','\x88','o','n',' ','a',' ','c','h','u','n','k',' ','\x13','e','x','e','c','u','t','a','b','l','e',' ','\x5c','\xc0','s','h','o','u','l','d','n','\'','t',' ','\x90','p','r','e','s','e','n','t',' ','\x0d','\x02','p','r','o','c','e','s','s','.',
/* 0x036c4 = "A boot catalog entry in the import ISO sets the continuation flag when using NONE as the selection criteria type." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','\xef','u','s','i','n','g',' ','N','O','N','E',' ','a','s',' ','\x02','s','e','l','e','c','t','i','o','n',' ','c','r','i','t','e','r','i','a',' ','t','y','p','e','.',
/* 0x03718 = "The dotted-string representation of an ASN.1 OBJECT IDENTIFIER would be too long for our internal representation." */
    '\x03','d','o','t','t','e','d','-','\xc7','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','\x13','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','w','o','u','l','d',' ','\x90','\x8c','l','o','n','g',' ','\x0e','o','u','r',' ','\x15','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0376c = "The configuration constructor in main failed due to an internal consistency error. Consult the release log of the VM for further details." */
    '\x03','\xe8','c','o','n','s','t','r','u','c','t','o','r',' ','\x0d','m','a','i','n',' ','\x88','d','u','e',' ','\x08','\x60','\x15','c','o','n','s','i','s','t','e','n','c','y',' ','\x7b',' ','C','o','n','s','u','l','t',' ','\x02','r','e','l','e','a','s','e',' ','l','o','g',' ','\x13','\x02','\xcf',' ','\x0e','f','u','r','t','h','e','r',' ','d','e','t','a','i','l','s','.',
/* 0x037c0 = "There is more data available. This can happen due to a buffer wraparound of a buffer read/write operation." */
    'T','h','e','r','e',' ','\x09','\xf6','\x8f','a','v','a','i','l','a','b','l','e','.',' ','T','h','i','s',' ','c','a','n',' ','h','a','p','p','e','n',' ','d','u','e',' ','\x08','a',' ','b','u','f','f','e','r',' ','w','r','a','p','a','r','o','u','n','d',' ','\x13','a',' ','b','u','f','f','e','r',' ','r','e','a','d','/','w','r','i','t','e',' ','\xcc',
/* 0x03813 = "Special return code from a PCI I/O region mapping handler that tells the BUS that it has done the mapping already." */
    'S','p','e','c','i','a','l',' ','r','e','t','u','r','n',' ','c','o','d','e',' ','f','r','o','m',' ','a',' ','P','C','I',' ','I','/','O',' ','r','e','g','i','o','n',' ','\xe0','h','a','n','d','l','e','r',' ','\x89','t','e','l','l','s',' ','\x02','B','U','S',' ','\x89','i','t',' ','\x1d','d','o','n','e',' ','\x02','\xe0','a','l','r','e','a','d','y','.',
/* 0x03866 = "Returned by RTThreadQueryTerminationStatus to indicate that the thread is (or should be) terminating." */
    'R','e','t','u','r','n','e','d',' ','\xb9','R','T','T','h','r','e','a','d','Q','u','e','r','y','T','e','r','m','i','n','a','t','i','o','n','S','t','a','t','u','s',' ','\x08','i','n','d','i','c','a','t','e',' ','\x89','\x02','t','h','r','e','a','d',' ','\x09','(','o','r',' ','\xec','b','e',')',' ','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x038b8 = "Duplicate symbol within the module. Attempted to add a symbol which name already exists within the module." */
    'D','u','p','l','i','c','a','t','e',' ','s','y','m','b','o','l',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',' ','A','t','t','e','m','p','t','e','d',' ','\x08','a','d','d',' ','a',' ','s','y','m','b','o','l',' ','\xc0','\xf3','\x22','e','x','i','s','t','s',' ','w','i','t','h','i','n',' ','\x02','m','o','d','u','l','e','.',
/* 0x0390a = "The behavior of the instruction/operation is modified/needs modification in VMX non-root mode." */
    '\x03','b','e','h','a','v','i','o','r',' ','\x13','\x02','i','n','s','t','r','u','c','t','i','o','n','/','o','p','e','r','a','t','i','o','n',' ','\x09','m','o','d','i','f','i','e','d','/','n','e','e','d','s',' ','m','o','d','i','f','i','c','a','t','i','o','n',' ','\x0d','V','M','X',' ','n','o','n','-','r','o','o','t',' ','m','o','d','e','.',
/* 0x0395c = "Not permitted to open the USB device. The user doesn't have access to the device node, check group memberships." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x08','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',' ','\x03','u','s','e','r',' ','\xa5','\xeb','a','c','c','e','s','s',' ','\x08','\x02','\x8b','n','o','d','e',',',' ','c','h','e','c','k',' ','g','r','o','u','p',' ','m','e','m','b','e','r','s','h','i','p','s','.',
/* 0x039ad = "A boot catalog extension entry in the import ISO indicates more entries when we reached the end of the boot catalog sector." */
    'A',' ','b','o','o','t',' ','\xcd','e','x','t','e','n','s','i','o','n',' ','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','i','n','d','i','c','a','t','e','s',' ','\xf6','e','n','t','r','i','e','s',' ','\xef','w','e',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x13','\x02','b','o','o','t',' ','\xcd','s','e','c','t','o','r','.',
/* 0x039fe = "Indicating that a rescheduling now is required. Typically caused by interrupts having changed the EIP." */
    '\xfa','\x89','a',' ','r','e','s','c','h','e','d','u','l','i','n','g',' ','n','o','w',' ','\x09','r','e','q','u','i','r','e','d','.',' ','T','y','p','i','c','a','l','l','y',' ','c','a','u','s','e','d',' ','\xb9','i','n','t','e','r','r','u','p','t','s',' ','h','a','v','i','n','g',' ','c','h','a','n','g','e','d',' ','\x02','E','I','P','.',
/* 0x03a4f = "Not permitted to open the USB device. The user doesn't have access to the device in the usbfs, check the mount options." */
    'N','o','t',' ','p','e','r','m','i','t','t','e','d',' ','\x08','o','p','e','n',' ','\x02','U','S','B',' ','d','e','v','i','c','e','.',' ','\x03','u','s','e','r',' ','\xa5','\xeb','a','c','c','e','s','s',' ','\x08','\x02','\x8b','\x0d','\x02','u','s','b','f','s',',',' ','c','h','e','c','k',' ','\x02','m','o','u','n','t',' ','o','p','t','i','o','n','s','.',
/* 0x03aa0 = "Nested paging not active. PCI passthrough currently works only if nested paging is active." */
    'N','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x05','a','c','t','i','v','e','.',' ','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h',' ','c','u','r','r','e','n','t','l','y',' ','w','o','r','k','s',' ','\xf7','i','f',' ','n','e','s','t','e','d',' ','p','a','g','i','n','g',' ','\x09','a','c','t','i','v','e','.',
/* 0x03af1 = "RamPreAlloc not set. RAM pre-allocation is currently a requirement for PCI passthrough." */
    'R','a','m','P','r','e','A','l','l','o','c',' ','\x05','s','e','t','.',' ','R','A','M',' ','p','r','e','-','a','l','l','o','c','a','t','i','o','n',' ','\x09','c','u','r','r','e','n','t','l','y',' ','a',' ','r','e','q','u','i','r','e','m','e','n','t',' ','\x0e','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h','.',
/* 0x03b40 = "Reason for leaving RC: A privileged instruction was attempted executed. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','p','r','i','v','i','l','e','g','e','d',' ','\xba','\x10','a','t','t','e','m','p','t','e','d',' ','e','x','e','c','u','t','e','d','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x13','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xc9','\x0d','R','E','M','.',
/* 0x03b8f = "The request has been freed, don\'t read the status now. Someone is reading the iStatus field of a freed request packet." */
    '\x03','\x94','\x1d','\xad','f','r','e','e','d',',',' ','d','o','n','\'','t',' ','r','e','a','d',' ','\x02','s','t','a','t','u','s',' ','n','o','w','.',' ','S','o','m','e','o','n','e',' ','\x09','r','e','a','d','i','n','g',' ','\x02','i','S','t','a','t','u','s',' ','\xff','\x13','a',' ','f','r','e','e','d',' ','\x94','p','a','c','k','e','t','.',
/* 0x03bde = "A boot catalog extension entry in the import ISO was either flagged incorrectly in the previous entry or has an invalid header ID." */
    'A',' ','b','o','o','t',' ','\xcd','e','x','t','e','n','s','i','o','n',' ','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x10','e','i','t','h','e','r',' ','f','l','a','g','g','e','d',' ','i','n','c','o','r','r','e','c','t','l','y',' ','\x0d','\x02','p','r','e','v','i','o','u','s',' ','\xb5','\x86','\x1d','\x60','\x81','\xa2','I','D','.',
/* 0x03c2c = "IOMMU instance cannot call itself (for remapping interrupts or translating addresses)." */
    'I','O','M','M','U',' ','i','n','s','t','a','n','c','e',' ','\xcb','c','a','l','l',' ','i','t','s','e','l','f',' ','(','f','o','r',' ','r','e','m','a','p','p','i','n','g',' ','i','n','t','e','r','r','u','p','t','s',' ','\x86','t','r','a','n','s','l','a','t','i','n','g',' ','a','d','d','r','e','s','s','e','s',')','.',
/* 0x03c7a = "Reason for leaving RC: Interrupted by external interrupt. The interrupt needed to be handled by the host OS." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t','e','d',' ','\xb9','e','x','t','e','r','n','a','l',' ','i','n','t','e','r','r','u','p','t','.',' ','\x03','i','n','t','e','r','r','u','p','t',' ','n','e','e','d','e','d',' ','\x08','\x90','h','a','n','d','l','e','d',' ','\xb9','\x02','h','o','s','t',' ','O','S','.',
/* 0x03cc8 = "The DTB being parsed has no terminating memory reservation block entry before the start of the structs block." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\xe9','t','e','r','m','i','n','a','t','i','n','g',' ','\x5c','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','\xb5','b','e','f','o','r','e',' ','\x02','s','t','a','r','t',' ','\x13','\x02','s','t','r','u','c','t','s',' ','b','l','o','c','k','.',
/* 0x03d15 = "The host is not supported. Uninstall the extension pack. Returned by the VBOXEXTPACKREG::pfnInstalled." */
    '\x03','h','o','s','t',' ','\x09','\x05','\x95',' ','U','n','i','n','s','t','a','l','l',' ','\x02','e','x','t','e','n','s','i','o','n',' ','p','a','c','k','.',' ','R','e','t','u','r','n','e','d',' ','\xb9','\x02','V','B','O','X','E','X','T','P','A','C','K','R','E','G',':',':','p','f','n','I','n','s','t','a','l','l','e','d','.',
/* 0x03d62 = "The device is not a registered PCI device and thus cannot perform any PCI operations. The device forgot to register it self." */
    '\x03','\x8b','\x09','\x05','a',' ','r','e','g','i','s','t','e','r','e','d',' ','P','C','I',' ','\x8b','\x2a','t','h','u','s',' ','\xcb','p','e','r','f','o','r','m',' ','a','n','y',' ','P','C','I',' ','o','p','e','r','a','t','i','o','n','s','.',' ','\x03','\x8b','f','o','r','g','o','t',' ','\x08','\xbc','i','t',' ','s','e','l','f','.',
/* 0x03dae = "VFS chain only has a single element and it is just a path, need to be treated as a normal file system request." */
    '\xa4',' ','\x91','\xf7','\x1d','a',' ','s','i','n','g','l','e',' ','\x1f','\x2a','i','t',' ','\x09','j','u','s','t',' ','a',' ','p','a','t','h',',',' ','n','e','e','d',' ','\x08','\x90','t','r','e','a','t','e','d',' ','a','s',' ','a',' ','n','o','r','m','a','l',' ','\x18','s','y','s','t','e','m',' ','r','e','q','u','e','s','t','.',
/* 0x03dfa = "A component value of an ASN.1 OBJECT IDENTIFIER is too big for our internal representation (32-bits)." */
    'A',' ','c','o','m','p','o','n','e','n','t',' ','\xd2','\x13','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','\x09','\x8c','b','i','g',' ','\x0e','o','u','r',' ','\x15','r','e','p','r','e','s','e','n','t','a','t','i','o','n',' ','(','3','2','-','b','i','t','s',')','.',
/* 0x03e46 = "Reserved for future status code that we wish to OR with VERR_VMX_INVALID_VMCS_PTR and VERR_VMX_INVALID_VMCS_FIELD." */
    'R','e','s','e','r','v','e','d',' ','\x0e','f','u','t','u','r','e',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\x89','w','e',' ','w','i','s','h',' ','\x08','O','R',' ','\x1e','\x01','V','M','X','_','\x0f','V','M','C','S','_','P','T','R',' ','\x2a','\x01','V','M','X','_','\x0f','V','M','C','S','_','F','I','E','L','D','.',
/* 0x03e92 = "A boot catalog entry in the import ISO sets the continuation flag when we reached the ned of the boot catalog secotr." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','s','e','t','s',' ','\x02','c','o','n','t','i','n','u','a','t','i','o','n',' ','f','l','a','g',' ','\xef','w','e',' ','r','e','a','c','h','e','d',' ','\x02','n','e','d',' ','\x13','\x02','b','o','o','t',' ','\xcd','s','e','c','o','t','r','.',
/* 0x03ede = "Recompiled execution: Debug related (hidden) EFLAGS are set and needs handling." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','D','e','b','u','g',' ','r','e','l','a','t','e','d',' ','(','h','i','d','d','e','n',')',' ','E','F','L','A','G','S',' ','a','r','e',' ','s','e','t',' ','\x2a','n','e','e','d','s',' ','h','a','n','d','l','i','n','g','.',
/* 0x03f2a = "Returned by a breakpoint callback when guest execution should be suspended and the VM should be dropped into the debugger." */
    'R','e','t','u','r','n','e','d',' ','\xb9','a',' ','\xab','c','a','l','l','b','a','c','k',' ','\xef','\xa1','e','x','e','c','u','t','i','o','n',' ','\xec','\x90','s','u','s','p','e','n','d','e','d',' ','\x2a','\x02','\xcf',' ','\xec','\x90','d','r','o','p','p','e','d',' ','i','n','t','o',' ','\x02','d','e','b','u','g','g','e','r','.',
/* 0x03f75 = "VT-x/AMD-V not active. PCI passthrough currently works only if VT-x/AMD-V is active." */
    'V','T','-','x','/','A','M','D','-','V',' ','\x05','a','c','t','i','v','e','.',' ','P','C','I',' ','p','a','s','s','t','h','r','o','u','g','h',' ','c','u','r','r','e','n','t','l','y',' ','w','o','r','k','s',' ','\xf7','i','f',' ','V','T','-','x','/','A','M','D','-','V',' ','\x09','a','c','t','i','v','e','.',
/* 0x03fc0 = "Warning, the state changed. This is a generic error message and needs a context to make sense." */
    'W','a','r','n','i','n','g',',',' ','\x02','\xb0','c','h','a','n','g','e','d','.',' ','T','h','i','s',' ','\x09','a',' ','g','e','n','e','r','i','c',' ','\x07','m','e','s','s','a','g','e',' ','\x2a','n','e','e','d','s',' ','a',' ','c','o','n','t','e','x','t',' ','\x08','m','a','k','e',' ','s','e','n','s','e','.',
/* 0x0400a = "One of the custom modes was incorrect. The format or bit count of the custom mode value is invalid." */
    'O','n','e',' ','\x13','\x02','c','u','s','t','o','m',' ','m','o','d','e','s',' ','\x10','i','n','c','o','r','r','e','c','t','.',' ','\x03','f','o','r','m','a','t',' ','\x86','b','i','t',' ','c','o','u','n','t',' ','\x13','\x02','c','u','s','t','o','m',' ','m','o','d','e',' ','\xd2','\x09','i','n','v','a','l','i','d','.',
/* 0x04054 = "A driver encountered an unknown configuration value. This means that the driver is potentially misconfigured and the driver construction failed because of this." */
    'A',' ','\xa8','\x98','\x60','\xfc','\xe8','\xd3',' ','T','h','i','s',' ','m','e','a','n','s',' ','\x89','\x02','\xa8','\x09','p','o','t','e','n','t','i','a','l','l','y',' ','m','i','s','c','o','n','f','i','g','u','r','e','d',' ','\x2a','\x02','\xa8','c','o','n','s','t','r','u','c','t','i','o','n',' ','\x88','\x1c','\x13','t','h','i','s','.',
/* 0x0409e = "The release call only release a semaphore nesting, i.e. the caller is still holding the semaphore." */
    '\x03','r','e','l','e','a','s','e',' ','c','a','l','l',' ','\xf7','r','e','l','e','a','s','e',' ','a',' ','\xea','n','e','s','t','i','n','g',',',' ','i','.','e','.',' ','\x02','c','a','l','l','e','r',' ','\x09','s','t','i','l','l',' ','h','o','l','d','i','n','g',' ','\x02','s','e','m','a','p','h','o','r','e','.',
/* 0x040e8 = "CPUMR3DisasmInstrCPU unexpectedly failed to determine the hidden parts of the CS register." */
    'C','P','U','M','R','3','D','i','s','a','s','m','I','n','s','t','r','C','P','U',' ','u','n','e','x','p','e','c','t','e','d','l','y',' ','\x88','\x08','d','e','t','e','r','m','i','n','e',' ','\x02','h','i','d','d','e','n',' ','p','a','r','t','s',' ','\x13','\x02','C','S',' ','r','e','g','i','s','t','e','r','.',
/* 0x04132 = "A number tar header field was encoded using base-256 which this tar implementation currently does not support." */
    'A',' ','\xdd','t','a','r',' ','\xa2','\xff','\x10','e','n','c','o','d','e','d',' ','u','s','i','n','g',' ','b','a','s','e','-','2','5','6',' ','\xc0','\xc9','t','a','r',' ','i','m','p','l','e','m','e','n','t','a','t','i','o','n',' ','c','u','r','r','e','n','t','l','y',' ','\x9c','\x05','s','u','p','p','o','r','t','.',
/* 0x0417c = "The configuration constructor in main failed due to a COM error. Check the release log of the VM for further details." */
    '\x03','\xe8','c','o','n','s','t','r','u','c','t','o','r',' ','\x0d','m','a','i','n',' ','\x88','d','u','e',' ','\x08','a',' ','C','O','M',' ','\x7b',' ','C','h','e','c','k',' ','\x02','r','e','l','e','a','s','e',' ','l','o','g',' ','\x13','\x02','\xcf',' ','\x0e','f','u','r','t','h','e','r',' ','d','e','t','a','i','l','s','.',
/* 0x041c6 = "Returns by rep-prefixed string instruction if they yield because of pending FFs. The status code is internal to IEM." */
    'R','e','t','u','r','n','s',' ','\xb9','r','e','p','-','p','r','e','f','i','x','e','d',' ','\xc7','\xba','i','f',' ','t','h','e','y',' ','y','i','e','l','d',' ','\x1c','\x13','p','e','n','d','i','n','g',' ','F','F','s','.',' ','\x03','s','t','a','t','u','s',' ','c','o','d','e',' ','\x09','\x15','\x08','I','E','M','.',
/* 0x0420f = "Encountered unicode code point which is reserved for use as endian indicator (0xffff or 0xfffe)." */
    '\x97','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xc0','\x09','r','e','s','e','r','v','e','d',' ','\x0e','u','s','e',' ','a','s',' ','e','n','d','i','a','n',' ','i','n','d','i','c','a','t','o','r',' ','(','0','x','f','f','f','f',' ','\x86','0','x','f','f','f','e',')','.',
/* 0x04258 = "Stub process thread not found during revalidation upon vboxdrv opening by the VM process." */
    'S','t','u','b',' ','\x82','t','h','r','e','a','d',' ','\x05','f','o','u','n','d',' ','d','u','r','i','n','g',' ','r','e','v','a','l','i','d','a','t','i','o','n',' ','u','p','o','n',' ','v','b','o','x','d','r','v',' ','o','p','e','n','i','n','g',' ','\xb9','\x02','\xcf',' ','p','r','o','c','e','s','s','.',
/* 0x042a1 = "Attempted socket operation with a non-socket handle. (This includes closed handles.)." */
    'A','t','t','e','m','p','t','e','d',' ','s','o','c','k','e','t',' ','\x83','\x1e','a',' ','n','o','n','-','s','o','c','k','e','t',' ','h','a','n','d','l','e','.',' ','(','T','h','i','s',' ','i','n','c','l','u','d','e','s',' ','c','l','o','s','e','d',' ','h','a','n','d','l','e','s','.',')','.',
/* 0x042e9 = "Indicating that a breakpoint was hit and that EM should notify the debugger and in the event there is no debugger fail fatally." */
    '\xfa','\x89','a',' ','\xab','\x10','h','i','t',' ','\x2a','\x89','E','M',' ','\xec','n','o','t','i','f','y',' ','\x02','d','e','b','u','g','g','e','r',' ','\x2a','\x0d','\x02','e','v','e','n','t',' ','t','h','e','r','e',' ','\x09','\xe9','d','e','b','u','g','g','e','r',' ','f','a','i','l',' ','f','a','t','a','l','l','y','.',
/* 0x04331 = "Expected the signed data content to be the object ID of SpcIndirectDataContent, found something else instead." */
    '\xa6','\x02','s','i','g','n','e','d',' ','\x8f','\xd8','\x08','\x90','\x02','\x8d','I','D',' ','\x13','S','p','c','I','n','d','i','r','e','c','t','D','a','t','a','C','o','n','t','e','n','t',',',' ','f','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','e','l','s','e',' ','i','n','s','t','e','a','d','.',
/* 0x04379 = "Physical range crosses dynamic ram chunk boundary; translation to HC ptr not safe." */
    'P','h','y','s','i','c','a','l',' ','\xe4','c','r','o','s','s','e','s',' ','d','y','n','a','m','i','c',' ','r','a','m',' ','c','h','u','n','k',' ','b','o','u','n','d','a','r','y',';',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x08','H','C',' ','p','t','r',' ','\x05','s','a','f','e','.',
/* 0x043c1 = "Indicating that EM should single step an instruction. The instruction is stepped in the current execution mode (RAW/REM)." */
    '\xfa','\x89','E','M',' ','\xec','s','i','n','g','l','e',' ','s','t','e','p',' ','\x60','i','n','s','t','r','u','c','t','i','o','n','.',' ','\x03','\xba','\x09','s','t','e','p','p','e','d',' ','\x0d','\x02','\xd1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e',' ','(','R','A','W','/','R','E','M',')','.',
/* 0x04408 = "SMAP enabled, but the AC flag was found to be clear - check the kernel log for details." */
    'S','M','A','P',' ','e','n','a','b','l','e','d',',',' ','b','u','t',' ','\x02','A','C',' ','f','l','a','g',' ','\x10','f','o','u','n','d',' ','\x08','\x90','c','l','e','a','r',' ','-',' ','c','h','e','c','k',' ','\x02','k','e','r','n','e','l',' ','l','o','g',' ','\x0e','d','e','t','a','i','l','s','.',
/* 0x0444f = "The order of elements in the XAR file does not lend it self to expansion from via an I/O stream." */
    '\x03','o','r','d','e','r',' ','\x13','e','l','e','m','e','n','t','s',' ','\x0d','\x02','X','A','R',' ','\x18','\x9c','\x05','l','e','n','d',' ','i','t',' ','s','e','l','f',' ','\x08','e','x','p','a','n','s','i','o','n',' ','f','r','o','m',' ','v','i','a',' ','\x60','I','/','O',' ','s','t','r','e','a','m','.',
/* 0x04496 = "Patch installation refused (patch too complex or unsupported instructions )." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','a','t','i','o','n',' ','r','e','f','u','s','e','d',' ','(','p','a','t','c','h',' ','\x8c','c','o','m','p','l','e','x',' ','\x86','u','n','s','u','p','p','o','r','t','e','d',' ','i','n','s','t','r','u','c','t','i','o','n','s',' ',')','.',
/* 0x044dd = "The NotBefore and NotAfter values of an X.509 Validity object seems to have been swapped around." */
    '\x03','N','o','t','B','e','f','o','r','e',' ','\x2a','N','o','t','A','f','t','e','r',' ','v','a','l','u','e','s',' ','\x13','\x60','X','.','5','0','9',' ','V','a','l','i','d','i','t','y',' ','\x8d','s','e','e','m','s',' ','\x08','\xeb','\xad','s','w','a','p','p','e','d',' ','a','r','o','u','n','d','.',
/* 0x04523 = "The driver doesn't support runtime driver attaching. The PDMDRVREG::pfnAttach callback function is NULL." */
    '\x03','\xa8','\xa5','\xb1','r','u','n','t','i','m','e',' ','\xa8','a','t','t','a','c','h','i','n','g','.',' ','\x03','P','D','M','D','R','V','R','E','G',':',':','p','f','n','A','t','t','a','c','h',' ','c','a','l','l','b','a','c','k',' ','f','u','n','c','t','i','o','n',' ','\x09','N','U','L','L','.',
/* 0x04569 = "Failed to measure the TSC delta between two CPUs, continue without any TSC-delta." */
    '\x80','\x08','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s',',',' ','c','o','n','t','i','n','u','e',' ','w','i','t','h','o','u','t',' ','a','n','y',' ','T','S','C','-','d','e','l','t','a','.',
/* 0x045af = "Process Verification Failure: Expected the process and exe to have forced integrity checking enabled (verifying signatures)." */
    '\x17','\x0c','\x12','\xa6','\x02','\x82','\x2a','e','x','e',' ','\x08','\xeb','f','o','r','c','e','d',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','i','n','g',' ','e','n','a','b','l','e','d',' ','(','v','e','r','i','f','y','i','n','g',' ','s','i','g','n','a','t','u','r','e','s',')','.',
/* 0x045f5 = "The ELF image is \'executable\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x1a','\x09','\'','e','x','e','c','u','t','a','b','l','e','\'',',',' ','\x02','E','L','F',' ','\xc4','c','a','n',' ','\xf7','d','e','a','l',' ','\x1e','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x0463b = "Reason for leaving RC: A Ring switch was attempted. Normal cause of action is to execute this in REM." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','R','i','n','g',' ','s','w','i','t','c','h',' ','\x10','a','t','t','e','m','p','t','e','d','.',' ','N','o','r','m','a','l',' ','c','a','u','s','e',' ','\x13','a','c','t','i','o','n',' ','\x09','\x08','e','x','e','c','u','t','e',' ','\xc9','\x0d','R','E','M','.',
/* 0x04681 = "RC is toasted and the VMM should be terminated at once, but no need to panic about it :-)." */
    'R','C',' ','\x09','t','o','a','s','t','e','d',' ','\x2a','\x02','V','M','M',' ','\xec','\x90','t','e','r','m','i','n','a','t','e','d',' ','a','t',' ','o','n','c','e',',',' ','b','u','t',' ','\xe9','n','e','e','d',' ','\x08','p','a','n','i','c',' ','a','b','o','u','t',' ','i','t',' ',':','-',')','.',
/* 0x046c7 = "The device doesn't support runtime driver attaching. The PDMDEVREG::pfnAttach callback function is NULL." */
    '\x03','\x8b','\xa5','\xb1','r','u','n','t','i','m','e',' ','\xa8','a','t','t','a','c','h','i','n','g','.',' ','\x03','P','D','M','D','E','V','R','E','G',':',':','p','f','n','A','t','t','a','c','h',' ','c','a','l','l','b','a','c','k',' ','f','u','n','c','t','i','o','n',' ','\x09','N','U','L','L','.',
/* 0x0470d = "Returned by PCI config space callbacks to indicate taking default action." */
    'R','e','t','u','r','n','e','d',' ','\xb9','P','C','I',' ','c','o','n','f','i','g',' ','s','p','a','c','e',' ','c','a','l','l','b','a','c','k','s',' ','\x08','i','n','d','i','c','a','t','e',' ','t','a','k','i','n','g',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x04752 = "Reason for leaving RC: A triple-fault condition. Currently, causes a guru meditation." */
    '\x84','\x0e','\x25','R','C',':',' ','A',' ','t','r','i','p','l','e','-','f','a','u','l','t',' ','c','o','n','d','i','t','i','o','n','.',' ','C','u','r','r','e','n','t','l','y',',',' ','c','a','u','s','e','s',' ','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x04797 = "The network already exists with a different security profile (restricted / public)." */
    '\x03','n','e','t','w','o','r','k',' ','\x22','e','x','i','s','t','s',' ','\x1e','a',' ','d','i','f','f','e','r','e','n','t',' ','s','e','c','u','r','i','t','y',' ','p','r','o','f','i','l','e',' ','(','r','e','s','t','r','i','c','t','e','d',' ','/',' ','p','u','b','l','i','c',')','.',
/* 0x047dc = "The loaded XSAVE component mask is not compatible with the host CPU or/and VM config." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x09','\x05','c','o','m','p','a','t','i','b','l','e',' ','\x1e','\x02','h','o','s','t',' ','C','P','U',' ','o','r','/','a','n','d',' ','\xcf',' ','c','o','n','f','i','g','.',
/* 0x04821 = "Invalid GC physical range. Usually used when a specified range crosses a RAM region boundary." */
    '\x0b','G','C',' ','p','h','y','s','i','c','a','l',' ','r','a','n','g','e','.',' ','U','s','u','a','l','l','y',' ','u','s','e','d',' ','\xef','a',' ','\x16','\xe4','c','r','o','s','s','e','s',' ','a',' ','R','A','M',' ','r','e','g','i','o','n',' ','b','o','u','n','d','a','r','y','.',
/* 0x04865 = "Signed data verification failed because of missing (or duplicate) authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xd9','a','t','t','r','i','b','u','t','e','.',
/* 0x048a9 = "Import ISO contains a multi-extent directory record that differs significantly from first record." */
    '\xaf','\xb2',' ','\x7f','a',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x1b','r','e','c','o','r','d',' ','\x89','d','i','f','f','e','r','s',' ','s','i','g','n','i','f','i','c','a','n','t','l','y',' ','f','r','o','m',' ','f','i','r','s','t',' ','r','e','c','o','r','d','.',
/* 0x048ed = "The shared module clashed address wise with a previously registered module." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','a','d','d','r','e','s','s',' ','w','i','s','e',' ','\x1e','a',' ','p','r','e','v','i','o','u','s','l','y',' ','r','e','g','i','s','t','e','r','e','d',' ','m','o','d','u','l','e','.',
/* 0x04931 = "Status code, typically given as a parameter, that isn\'t supposed to be used." */
    'S','t','a','t','u','s',' ','c','o','d','e',',',' ','t','y','p','i','c','a','l','l','y',' ','g','i','v','e','n',' ','a','s',' ','a',' ','p','a','r','a','m','e','t','e','r',',',' ','\x89','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x08','\x90','u','s','e','d','.',
/* 0x04975 = "The port being read was not present(/unused) and IOM shall return ~0 according to size." */
    '\x03','p','o','r','t',' ','\xdb','r','e','a','d',' ','\x10','\x05','p','r','e','s','e','n','t','(','/','u','n','u','s','e','d',')',' ','\x2a','I','O','M',' ','s','h','a','l','l',' ','r','e','t','u','r','n',' ','~','0',' ','a','c','c','o','r','d','i','n','g',' ','\x08','s','i','z','e','.',
/* 0x049b9 = "The I/O queue doesn't contain any prepared requests to commit or wait for completion." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\xa5','c','o','n','t','a','i','n',' ','a','n','y',' ','p','r','e','p','a','r','e','d',' ','r','e','q','u','e','s','t','s',' ','\x08','c','o','m','m','i','t',' ','\x86','w','a','i','t',' ','\x0e','c','o','m','p','l','e','t','i','o','n','.',
/* 0x049fd = "The request could not be canceled or prepared for another transfer because it is still in progress." */
    '\x03','\x94','c','o','u','l','d',' ','\x05','\x90','c','a','n','c','e','l','e','d',' ','\x86','p','r','e','p','a','r','e','d',' ','\x0e','a','n','o','t','h','e','r',' ','t','r','a','n','s','f','e','r',' ','\x1c','i','t',' ','\x09','s','t','i','l','l',' ','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x04a41 = "Signed data verification failed because of missing (or duplicate) authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','(','o','r',' ','d','u','p','l','i','c','a','t','e',')',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc2','a','t','t','r','i','b','u','t','e','.',
/* 0x04a85 = "Complex SSM field fed to SSMR3PutStruct or SSMR3GetStruct. Use the extended API." */
    'C','o','m','p','l','e','x',' ','S','S','M',' ','\xff','f','e','d',' ','\x08','S','S','M','R','3','P','u','t','S','t','r','u','c','t',' ','\x86','S','S','M','R','3','G','e','t','S','t','r','u','c','t','.',' ','U','s','e',' ','\x02','e','x','t','e','n','d','e','d',' ','A','P','I','.',
/* 0x04ac9 = "The selected platform architecture is not supported. Depends on the context (host / VM)." */
    '\x03','s','e','l','e','c','t','e','d',' ','p','l','a','t','f','o','r','m',' ','a','r','c','h','i','t','e','c','t','u','r','e',' ','\x09','\x05','\x95',' ','D','e','p','e','n','d','s',' ','o','n',' ','\x02','c','o','n','t','e','x','t',' ','(','h','o','s','t',' ','/',' ','V','M',')','.',
/* 0x04b0d = "The boot catalog in the import ISO is larger than a sector or it is missing the final section header entry." */
    '\x03','b','o','o','t',' ','\xcd','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x09','l','a','r','g','e','r',' ','t','h','a','n',' ','a',' ','s','e','c','t','o','r',' ','\x86','i','t',' ','\x09','m','i','s','s','i','n','g',' ','\x02','f','i','n','a','l',' ','\xc6','\xa2','e','n','t','r','y','.',
/* 0x04b51 = "The I/O context couldn\'t be destroyed because there are still pending requests." */
    '\x03','I','/','O',' ','c','o','n','t','e','x','t',' ','c','o','u','l','d','n','\'','t',' ','\x90','d','e','s','t','r','o','y','e','d',' ','\x1c','t','h','e','r','e',' ','a','r','e',' ','s','t','i','l','l',' ','p','e','n','d','i','n','g',' ','r','e','q','u','e','s','t','s','.',
/* 0x04b94 = "WinVerifyTrust failed with an unexpected status code when using the catalog-file approach." */
    'W','i','n','V','e','r','i','f','y','T','r','u','s','t',' ','\x88','\x1e','\x60','u','n','e','x','p','e','c','t','e','d',' ','s','t','a','t','u','s',' ','c','o','d','e',' ','\xef','u','s','i','n','g',' ','\x02','c','a','t','a','l','o','g','-','\x18','a','p','p','r','o','a','c','h','.',
/* 0x04bd7 = "The ELF image is \'dynamic\', the ELF loader can only deal with \'relocatable\' images at present." */
    '\x03','E','L','F',' ','\x1a','\x09','\'','d','y','n','a','m','i','c','\'',',',' ','\x02','E','L','F',' ','\xc4','c','a','n',' ','\xf7','d','e','a','l',' ','\x1e','\'','r','e','l','o','c','a','t','a','b','l','e','\'',' ','i','m','a','g','e','s',' ','a','t',' ','p','r','e','s','e','n','t','.',
/* 0x04c1a = "VFS chain element preceding the final path needs to be a directory, file system or file system stream." */
    '\xa4',' ','\x91','\x1f','p','r','e','c','e','d','i','n','g',' ','\x02','f','i','n','a','l',' ','\xbb','n','e','e','d','s',' ','\x08','\x90','a',' ','d','i','r','e','c','t','o','r','y',',',' ','\x18','s','y','s','t','e','m',' ','\x86','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m','.',
/* 0x04c5d = "VFS chain element takes a directory (dir), file system stream (fss), or file system (vfs) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x1b','(','d','i','r',')',',',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',',',' ','\x86','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x04ca0 = "Error opening the stub process thread for revalidation when vboxdrv is opened by the VM process." */
    '\xac','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x82','t','h','r','e','a','d',' ','\x0e','r','e','v','a','l','i','d','a','t','i','o','n',' ','\xef','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xcf',' ','p','r','o','c','e','s','s','.',
/* 0x04ce2 = "There shall be exactly one digest algorithm to go with the single SingerInfo entry required by SPC." */
    'T','h','e','r','e',' ','s','h','a','l','l',' ','\x90','e','x','a','c','t','l','y',' ','o','n','e',' ','\xc2','\xbe','\x08','g','o',' ','\x1e','\x02','s','i','n','g','l','e',' ','S','i','n','g','e','r','I','n','f','o',' ','\xb5','r','e','q','u','i','r','e','d',' ','\xb9','S','P','C','.',
/* 0x04d24 = "VMRUN emulation succeeded, ready to immediately enter the nested-guest." */
    'V','M','R','U','N',' ','e','m','u','l','a','t','i','o','n',' ','s','u','c','c','e','e','d','e','d',',',' ','r','e','a','d','y',' ','\x08','i','m','m','e','d','i','a','t','e','l','y',' ','e','n','t','e','r',' ','\x02','n','e','s','t','e','d','-','g','u','e','s','t','.',
/* 0x04d66 = "Failed to set the TLS (thread local storage) entry which points to our thread structure." */
    '\x80','\x08','s','e','t',' ','\x02','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','\xb5','\xc0','p','o','i','n','t','s',' ','\x08','o','u','r',' ','t','h','r','e','a','d',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x04da7 = "The halt action was requested, but the OS may actually power off the machine." */
    '\x03','h','a','l','t',' ','a','c','t','i','o','n',' ','\x10','r','e','q','u','e','s','t','e','d',',',' ','b','u','t',' ','\x02','O','S',' ','m','a','y',' ','a','c','t','u','a','l','l','y',' ','p','o','w','e','r',' ','o','f','f',' ','\x02','m','a','c','h','i','n','e','.',
/* 0x04de8 = "The requests couldn\'t be submitted because that would exceed the capacity of the context." */
    '\x03','r','e','q','u','e','s','t','s',' ','c','o','u','l','d','n','\'','t',' ','\x90','s','u','b','m','i','t','t','e','d',' ','\x1c','\x89','w','o','u','l','d',' ','e','x','c','e','e','d',' ','\x02','c','a','p','a','c','i','t','y',' ','\x13','\x02','c','o','n','t','e','x','t','.',
/* 0x04e29 = "The alignment is not really supported, however we got lucky with this allocation." */
    '\x03','a','l','i','g','n','m','e','n','t',' ','\x09','\x05','r','e','a','l','l','y',' ','s','u','p','p','o','r','t','e','d',',',' ','h','o','w','e','v','e','r',' ','w','e',' ','g','o','t',' ','l','u','c','k','y',' ','\x1e','\xc9','a','l','l','o','c','a','t','i','o','n','.',
/* 0x04e6a = "The state changed. This is a generic error message and needs a context to make sense." */
    '\x03','\xb0','c','h','a','n','g','e','d','.',' ','T','h','i','s',' ','\x09','a',' ','g','e','n','e','r','i','c',' ','\x07','m','e','s','s','a','g','e',' ','\x2a','n','e','e','d','s',' ','a',' ','c','o','n','t','e','x','t',' ','\x08','m','a','k','e',' ','s','e','n','s','e','.',
/* 0x04eab = "Invalid/unsupported nested hardware virtualization configuration." */
    'I','n','v','a','l','i','d','/','u','n','s','u','p','p','o','r','t','e','d',' ','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x04eec = "The PCI device isn\'t configured as a busmaster, physical memory access rejected." */
    '\x03','P','C','I',' ','\x8b','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','a','s',' ','a',' ','b','u','s','m','a','s','t','e','r',',',' ','p','h','y','s','i','c','a','l',' ','\x5c','a','c','c','e','s','s',' ','r','e','j','e','c','t','e','d','.',
/* 0x04f2d = "Import ISO has different volume space sizes of primary and supplementary volume descriptors." */
    '\xaf','\xb2',' ','\x1d','d','i','f','f','e','r','e','n','t',' ','\xbd','s','p','a','c','e',' ','s','i','z','e','s',' ','\x13','p','r','i','m','a','r','y',' ','\x2a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x04f6d = "The tar termination records was encountered without reaching the end of the input stream." */
    '\x03','t','a','r',' ','t','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d','s',' ','\x10','\x98','w','i','t','h','o','u','t',' ','r','e','a','c','h','i','n','g',' ','\x02','e','n','d',' ','\x13','\x02','i','n','p','u','t',' ','s','t','r','e','a','m','.',
/* 0x04fad = "The signature algorithm in the to-be-signed certificate part does not match the one associated with the signature." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\xbe','\x0d','\x02','t','o','-','b','e','-','s','i','g','n','e','d',' ','\x8a','p','a','r','t',' ','\x9c','\x05','\xe3','\x02','o','n','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x04fed = "Indicating that the VM is being turned off and that the EM should exit to the VM awaiting the destruction request." */
    '\xfa','\x89','\x02','\xcf',' ','\x09','\xdb','t','u','r','n','e','d',' ','o','f','f',' ','\x2a','\x89','\x02','E','M',' ','\xec','e','x','i','t',' ','\x08','\x02','\xcf',' ','a','w','a','i','t','i','n','g',' ','\x02','d','e','s','t','r','u','c','t','i','o','n',' ','r','e','q','u','e','s','t','.',
/* 0x0502d = "VFS chain element only provides a read-only I/O stream, while the chain requires write access." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','\xf7','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x91','r','e','q','u','i','r','e','s',' ','w','r','i','t','e',' ','a','c','c','e','s','s','.',
/* 0x0506d = "Remapping denied for the interrupt (might have caused a PCI target abort)." */
    'R','e','m','a','p','p','i','n','g',' ','d','e','n','i','e','d',' ','\x0e','\x02','i','n','t','e','r','r','u','p','t',' ','(','m','i','g','h','t',' ','\xeb','c','a','u','s','e','d',' ','a',' ','P','C','I',' ','t','a','r','g','e','t',' ','a','b','o','r','t',')','.',
/* 0x050ad = "The function called requires the caller to be attached as a debugger to the VM." */
    '\x03','f','u','n','c','t','i','o','n',' ','c','a','l','l','e','d',' ','r','e','q','u','i','r','e','s',' ','\x02','c','a','l','l','e','r',' ','\x08','\x90','a','t','t','a','c','h','e','d',' ','a','s',' ','a',' ','d','e','b','u','g','g','e','r',' ','\x08','\x02','V','M','.',
/* 0x050ed = "Got back from vmmR0CallRing3SetJmp with the context hook still enabled." */
    'G','o','t',' ','b','a','c','k',' ','f','r','o','m',' ','v','m','m','R','0','C','a','l','l','R','i','n','g','3','S','e','t','J','m','p',' ','\x1e','\x02','c','o','n','t','e','x','t',' ','h','o','o','k',' ','s','t','i','l','l',' ','e','n','a','b','l','e','d','.',
/* 0x0512d = "The key was marked as encrypted by no DEK-Info field with the encryption algortihms was found." */
    '\x03','k','e','y',' ','\x10','m','a','r','k','e','d',' ','a','s',' ','e','n','c','r','y','p','t','e','d',' ','\xb9','\xe9','D','E','K','-','I','n','f','o',' ','\xff','\x1e','\x02','e','n','c','r','y','p','t','i','o','n',' ','a','l','g','o','r','t','i','h','m','s',' ','\x10','\x7d',
/* 0x0516d = "The digest algorithm in the indirect data was not found in the list of digest algorithms in the signed data structure." */
    '\x03','\xc2','\xbe','\x0d','\x02','i','n','d','i','r','e','c','t',' ','\x8f','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','l','i','s','t',' ','\x13','\xc2','a','l','g','o','r','i','t','h','m','s',' ','\x0d','\x02','s','i','g','n','e','d',' ','\x8f','s','t','r','u','c','t','u','r','e','.',
/* 0x051ac = "The intercepted situation was completely handled, continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','s','i','t','u','a','t','i','o','n',' ','\x10','c','o','m','p','l','e','t','e','l','y',' ','h','a','n','d','l','e','d',',',' ','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x051eb = "Got an out of memory condition trying to allocate a UTF-16 (/UCS-2) string." */
    'G','o','t',' ','\x60','o','u','t',' ','\x13','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','U','T','F','-','1','6',' ','(','/','U','C','S','-','2',')',' ','s','t','r','i','n','g','.',
/* 0x0522a = "A timeout occurred while waiting for async IDE operations to finish." */
    'A',' ','t','i','m','e','o','u','t',' ','o','c','c','u','r','r','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g',' ','\x0e','a','s','y','n','c',' ','I','D','E',' ','o','p','e','r','a','t','i','o','n','s',' ','\x08','f','i','n','i','s','h','.',
/* 0x05269 = "Trying to read a 64-bit guest physical address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x08','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xa1','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x052a8 = "There is no TLS (thread local storage) available for storing the current thread." */
    'T','h','e','r','e',' ','\x09','\xe9','T','L','S',' ','(','t','h','r','e','a','d',' ','l','o','c','a','l',' ','s','t','o','r','a','g','e',')',' ','a','v','a','i','l','a','b','l','e',' ','\x0e','s','t','o','r','i','n','g',' ','\x02','\xd1','t','h','r','e','a','d','.',
/* 0x052e7 = "A boot catalog extension entry in the import ISO uses undefined flags which will be lost." */
    'A',' ','b','o','o','t',' ','\xcd','e','x','t','e','n','s','i','o','n',' ','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','u','s','e','s',' ','u','n','d','e','f','i','n','e','d',' ','f','l','a','g','s',' ','\xc0','w','i','l','l',' ','\x90','l','o','s','t','.',
/* 0x05326 = "Sensitive input requires the result(s) to be initialized as sensitive." */
    'S','e','n','s','i','t','i','v','e',' ','i','n','p','u','t',' ','r','e','q','u','i','r','e','s',' ','\x02','r','e','s','u','l','t','(','s',')',' ','\x08','\x90','i','n','i','t','i','a','l','i','z','e','d',' ','a','s',' ','s','e','n','s','i','t','i','v','e','.',
/* 0x05365 = "Import ISO has different volume set sizes of primary and supplementary volume descriptors." */
    '\xaf','\xb2',' ','\x1d','d','i','f','f','e','r','e','n','t',' ','\xbd','s','e','t',' ','s','i','z','e','s',' ','\x13','p','r','i','m','a','r','y',' ','\x2a','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x053a3 = "Import ISO contains a non-final multi-extent directory record with a size that isn\'t block aligned." */
    '\xaf','\xb2',' ','\x7f','a',' ','n','o','n','-','f','i','n','a','l',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','\x1b','r','e','c','o','r','d',' ','\x1e','a',' ','\xf8','\x89','i','s','n','\'','t',' ','b','l','o','c','k',' ','a','l','i','g','n','e','d','.',
/* 0x053e1 = "The \'Translation\' attribute in the DrvBlock configuration had an unknown value. Misconfiguration." */
    '\x03','\'','T','r','a','n','s','l','a','t','i','o','n','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','\xe8','h','a','d',' ','\x60','\xfc','\xd3',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0541f = "A PGM function was called in a mode where it isn\'t supposed to be used." */
    'A',' ','P','G','M',' ','f','u','n','c','t','i','o','n',' ','\x10','c','a','l','l','e','d',' ','\x0d','a',' ','m','o','d','e',' ','w','h','e','r','e',' ','i','t',' ','i','s','n','\'','t',' ','s','u','p','p','o','s','e','d',' ','\x08','\x90','u','s','e','d','.',
/* 0x0545d = "Preemption is disabled. The requested operation can only be performed when preemption is enabled." */
    'P','r','e','e','m','p','t','i','o','n',' ','\x09','d','i','s','a','b','l','e','d','.',' ','\x03','\xbf','\x83','c','a','n',' ','\xf7','\x90','p','e','r','f','o','r','m','e','d',' ','\xef','p','r','e','e','m','p','t','i','o','n',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x0549b = "Too many write or write/read recursions on read/write critical section." */
    '\xf0','\xa3','w','r','i','t','e',' ','\x86','w','r','i','t','e','/','r','e','a','d',' ','r','e','c','u','r','s','i','o','n','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x054d9 = "No RTC device instance is registered with the current VM and thus the RTC or CMOS operation cannot be performed." */
    '\xd0','R','T','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd1','\xcf',' ','\x2a','t','h','u','s',' ','\x02','R','T','C',' ','\x86','C','M','O','S',' ','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x05517 = "The PE loader encountered a lock prefix table, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xc4','\x98','a',' ','l','o','c','k',' ','p','r','e','f','i','x',' ','t','a','b','l','e',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xc0','h','a','s','n','\'','t',' ','\xad','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x05555 = "Stub process not found so it cannot be revalidated when vboxdrv is opened by the VM process." */
    'S','t','u','b',' ','\x82','\x05','f','o','u','n','d',' ','s','o',' ','i','t',' ','\xcb','\x90','r','e','v','a','l','i','d','a','t','e','d',' ','\xef','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xcf',' ','p','r','o','c','e','s','s','.',
/* 0x05593 = "Process Purification Failure: KERNE32.DLL already mapped into the initial process (suspended)." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','K','E','R','N','E','3','2','.','D','L','L',' ','\x22','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','i','n','i','t','i','a','l',' ','\x82','(','s','u','s','p','e','n','d','e','d',')','.',
/* 0x055d1 = "Trying to read a 64-bit guest virtual address into a 32-bit variable." */
    'T','r','y','i','n','g',' ','\x08','r','e','a','d',' ','a',' ','6','4','-','b','i','t',' ','\xa1','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s',' ','i','n','t','o',' ','a',' ','3','2','-','b','i','t',' ','v','a','r','i','a','b','l','e','.',
/* 0x0560f = "Giving up a live snapshot/teleportation attempt because the state grew to big." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x1c','\x02','\xb0','g','r','e','w',' ','\x08','b','i','g','.',
/* 0x0564c = "A boot catalog entry in the import ISO points to a block after the end of the image input file." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','p','o','i','n','t','s',' ','\x08','a',' ','b','l','o','c','k',' ','a','f','t','e','r',' ','\x02','e','n','d',' ','\x13','\x02','\x1a','i','n','p','u','t',' ','f','i','l','e','.',
/* 0x05689 = "The digest algorithm of a signer info entry was not found in the list of digest algorithms in the signed data." */
    '\x03','\xc2','\xbe','\x13','a',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','\xb5','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','l','i','s','t',' ','\x13','\xc2','a','l','g','o','r','i','t','h','m','s',' ','\x0d','\x02','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x056c6 = "No \'Type\' attribute in the DrvBlock configuration. Misconfiguration." */
    '\xd0','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x05703 = "Was not able to open the support driver. Generic open error used when none of the other ones fit." */
    'W','a','s',' ','\x05','a','b','l','e',' ','\x08','o','p','e','n',' ','\x02','\xb1','d','r','i','v','e','r','.',' ','\x96','o','p','e','n',' ','\x07','u','s','e','d',' ','\xef','n','o','n','e',' ','\x13','\x02','o','t','h','e','r',' ','o','n','e','s',' ','f','i','t','.',
/* 0x05740 = "The timer was stuck in an unstable state until we grew impatient and returned." */
    '\x03','t','i','m','e','r',' ','\x10','s','t','u','c','k',' ','\x0d','\x60','u','n','s','t','a','b','l','e',' ','\xb0','u','n','t','i','l',' ','w','e',' ','g','r','e','w',' ','i','m','p','a','t','i','e','n','t',' ','\x2a','r','e','t','u','r','n','e','d','.',
/* 0x0577c = "Unsupported data unit version. A SSM user returns this if it doesn't know the u32Version." */
    '\x87','\x8f','u','n','i','t',' ','v','e','r','s','i','o','n','.',' ','A',' ','S','S','M',' ','u','s','e','r',' ','r','e','t','u','r','n','s',' ','\xc9','i','f',' ','i','t',' ','\xa5','k','n','o','w',' ','\x02','u','3','2','V','e','r','s','i','o','n','.',
/* 0x057b8 = "Can\'t finalize the node as the FDT cursor is at the root level already." */
    'C','a','n','\'','t',' ','f','i','n','a','l','i','z','e',' ','\x02','n','o','d','e',' ','a','s',' ','\x02','F','D','T',' ','c','u','r','s','o','r',' ','\x09','a','t',' ','\x02','r','o','o','t',' ','l','e','v','e','l',' ','a','l','r','e','a','d','y','.',
/* 0x057f4 = "Missing UTF-8 continutation in escaped URI character sequence." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','\x0d','e','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x05830 = "Expected the archived and extracted XAR data sizes to be the same for uncompressed data." */
    '\xa6','\x02','a','r','c','h','i','v','e','d',' ','\x2a','e','x','t','r','a','c','t','e','d',' ','X','A','R',' ','\x8f','s','i','z','e','s',' ','\x08','\x90','\x02','s','a','m','e',' ','\x0e','u','n','c','o','m','p','r','e','s','s','e','d',' ','d','a','t','a','.',
/* 0x0586c = "Indicating that the VM has been suspended and that the thread should wait for request telling it what to do next." */
    '\xfa','\x89','\x02','\xcf',' ','\x1d','\xad','s','u','s','p','e','n','d','e','d',' ','\x2a','\x89','\x02','t','h','r','e','a','d',' ','\xec','w','a','i','t',' ','\x0e','\x94','t','e','l','l','i','n','g',' ','i','t',' ','w','h','a','t',' ','\x08','d','o',' ','n','e','x','t','.',
/* 0x058a8 = "Too many components in an ASN.1 OBJECT IDENTIFIER for our internal representation." */
    '\xf0','\xa3','c','o','m','p','o','n','e','n','t','s',' ','\x0d','\x60','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','\x0e','o','u','r',' ','\x15','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x058e4 = "Halt the current I/O context until further notification from the backend." */
    'H','a','l','t',' ','\x02','\xd1','I','/','O',' ','c','o','n','t','e','x','t',' ','u','n','t','i','l',' ','f','u','r','t','h','e','r',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','f','r','o','m',' ','\x02','b','a','c','k','e','n','d','.',
/* 0x05920 = "Trick for resuming EMHistoryExec after a VMCPU_FF_IOM is handled." */
    'T','r','i','c','k',' ','\x0e','r','e','s','u','m','i','n','g',' ','E','M','H','i','s','t','o','r','y','E','x','e','c',' ','a','f','t','e','r',' ','a',' ','V','M','C','P','U','_','F','F','_','I','O','M',' ','\x09','h','a','n','d','l','e','d','.',
/* 0x0595c = "Failed to enable VMXON-in-SMX bit while enabling VT-x through the MSR." */
    '\x80','\x08','e','n','a','b','l','e',' ','V','M','X','O','N','-','i','n','-','S','M','X',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x05997 = "Attempt to register a RAM range of which parts are already covered by existing RAM ranges." */
    'A','t','t','e','m','p','t',' ','\x08','\xbc','a',' ','R','A','M',' ','\xe4','\x13','\xc0','p','a','r','t','s',' ','a','r','e',' ','\x22','c','o','v','e','r','e','d',' ','\xb9','e','x','i','s','t','i','n','g',' ','R','A','M',' ','r','a','n','g','e','s','.',
/* 0x059d2 = "Error opening the stub process for revalidation when vboxdrv is opened by the VM process." */
    '\xac','o','p','e','n','i','n','g',' ','\x02','s','t','u','b',' ','\x82','\x0e','r','e','v','a','l','i','d','a','t','i','o','n',' ','\xef','v','b','o','x','d','r','v',' ','\x09','o','p','e','n','e','d',' ','\xb9','\x02','\xcf',' ','p','r','o','c','e','s','s','.',
/* 0x05a0d = "The requested nested-guest VMX intercept is not active or not in nested-guest execution mode." */
    '\x03','\xbf','n','e','s','t','e','d','-','\xa1','V','M','X',' ','i','n','t','e','r','c','e','p','t',' ','\x09','\x05','a','c','t','i','v','e',' ','\x86','\x05','\x0d','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x05a48 = "The requested nested-guest SVM intercept is not active or not in nested-guest execution mode." */
    '\x03','\xbf','n','e','s','t','e','d','-','\xa1','S','V','M',' ','i','n','t','e','r','c','e','p','t',' ','\x09','\x05','a','c','t','i','v','e',' ','\x86','\x05','\x0d','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n',' ','m','o','d','e','.',
/* 0x05a83 = "Giving up a live snapshot/teleportation attempt because of too many passes." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','a','t','t','e','m','p','t',' ','\x1c','\x13','\x8c','\xa3','p','a','s','s','e','s','.',
/* 0x05abe = "Differencing and parent images can\'t be used together due to UUID." */
    'D','i','f','f','e','r','e','n','c','i','n','g',' ','\x2a','p','a','r','e','n','t',' ','i','m','a','g','e','s',' ','c','a','n','\'','t',' ','\x90','u','s','e','d',' ','t','o','g','e','t','h','e','r',' ','d','u','e',' ','\x08','U','U','I','D','.',
/* 0x05af9 = "Device name clash. Another device with the same name as the one being registered exists." */
    'D','e','v','i','c','e',' ','\xf3','c','l','a','s','h','.',' ','A','n','o','t','h','e','r',' ','\x8b','\x1e','\x02','s','a','m','e',' ','\xf3','a','s',' ','\x02','o','n','e',' ','\xdb','r','e','g','i','s','t','e','r','e','d',' ','e','x','i','s','t','s','.',
/* 0x05b34 = "The VM was suspended before or while saving, don\'t resume execution." */
    '\x03','\xcf',' ','\x10','s','u','s','p','e','n','d','e','d',' ','b','e','f','o','r','e',' ','\x86','w','h','i','l','e',' ','s','a','v','i','n','g',',',' ','d','o','n','\'','t',' ','r','e','s','u','m','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x05b6f = "Giving up a live snapshot attempt because we\'re low on disk space." */
    'G','i','v','i','n','g',' ','u','p',' ','a',' ','l','i','v','e',' ','s','n','a','p','s','h','o','t',' ','a','t','t','e','m','p','t',' ','\x1c','w','e','\'','r','e',' ','l','o','w',' ','o','n',' ','d','i','s','k',' ','s','p','a','c','e','.',
/* 0x05baa = "Driver name clash. Another driver with the same name as the one being registered exists." */
    'D','r','i','v','e','r',' ','\xf3','c','l','a','s','h','.',' ','A','n','o','t','h','e','r',' ','\xa8','\x1e','\x02','s','a','m','e',' ','\xf3','a','s',' ','\x02','o','n','e',' ','\xdb','r','e','g','i','s','t','e','r','e','d',' ','e','x','i','s','t','s','.',
/* 0x05be5 = "The live snapshot/teleportation operation was aborted because of a guru meditation." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x83','\x10','a','b','o','r','t','e','d',' ','\x1c','\x13','a',' ','g','u','r','u',' ','m','e','d','i','t','a','t','i','o','n','.',
/* 0x05c20 = "Indicating that the VM should be suspended for debugging because the developer wants to inspect the VM state." */
    '\xfa','\x89','\x02','\xcf',' ','\xec','\x90','s','u','s','p','e','n','d','e','d',' ','\x0e','d','e','b','u','g','g','i','n','g',' ','\x1c','\x02','d','e','v','e','l','o','p','e','r',' ','w','a','n','t','s',' ','\x08','i','n','s','p','e','c','t',' ','\x02','\xcf',' ','\xf5',
/* 0x05c5b = "Async I/O task is pending, a completion handler will be called." */
    'A','s','y','n','c',' ','I','/','O',' ','t','a','s','k',' ','\x09','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\x90','c','a','l','l','e','d','.',
/* 0x05c96 = "Maximum number of Shared Clipboard events for an event source has been reached." */
    'M','a','x','i','m','u','m',' ','\xdd','\x13','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t','s',' ','\x0e','\x60','e','v','e','n','t',' ','s','o','u','r','c','e',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x05cd1 = "Failed to convert the specified Guest IP to a binary IP address. Malformed input." */
    '\x80','\x08','c','o','n','v','e','r','t',' ','\x02','\x16','G','u','e','s','t',' ','I','P',' ','\x08','a',' ','b','i','n','a','r','y',' ','I','P',' ','a','d','d','r','e','s','s','.',' ','M','a','l','f','o','r','m','e','d',' ','i','n','p','u','t','.',
/* 0x05d0c = "Cannot add symbolic link to namespace which isn\'t configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','n','a','m','e','s','p','a','c','e',' ','\xc0','i','s','n','\'','t',' ','c','o','n','f','i','g','u','r','e','d',' ','\x08','\xb1','i','t','.',
/* 0x05d47 = "The user mode tracepoint provider has too many probe locations and probes." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x1d','\x8c','\xa3','p','r','o','b','e',' ','l','o','c','a','t','i','o','n','s',' ','\x2a','p','r','o','b','e','s','.',
/* 0x05d81 = "Process Verification Failure: There is more than one known executable mapped into the process." */
    '\x17','\x0c','\x12','T','h','e','r','e',' ','\x09','\xf6','t','h','a','n',' ','o','n','e',' ','k','n','o','w','n',' ','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x05dbb = "PGMPhysWrite/Read hit a handler in Ring-0 or raw-mode context." */
    'P','G','M','P','h','y','s','W','r','i','t','e','/','R','e','a','d',' ','h','i','t',' ','a',' ','h','a','n','d','l','e','r',' ','\x0d','R','i','n','g','-','0',' ','\x86','r','a','w','-','m','o','d','e',' ','c','o','n','t','e','x','t','.',
/* 0x05df5 = "The PE loader encountered delayed imports, a feature which hasn\'t been implemented yet." */
    '\x03','P','E',' ','\xc4','\x98','d','e','l','a','y','e','d',' ','i','m','p','o','r','t','s',',',' ','a',' ','f','e','a','t','u','r','e',' ','\xc0','h','a','s','n','\'','t',' ','\xad','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x05e2f = "No APIC device instance is registered with the current VM and thus the APIC operation cannot be performed." */
    '\xd0','A','P','I','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd1','\xcf',' ','\x2a','t','h','u','s',' ','\x02','A','P','I','C',' ','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x05e69 = "Escaped URI character sequence with invalid UTF-8 continutation byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','s','e','q','u','e','n','c','e',' ','\x1e','\x81','U','T','F','-','8',' ','c','o','n','t','i','n','u','t','a','t','i','o','n',' ','b','y','t','e','.',
/* 0x05ea3 = "The live snapshot/teleportation operation was aborted because of a fatal runtime error." */
    '\x03','l','i','v','e',' ','s','n','a','p','s','h','o','t','/','t','e','l','e','p','o','r','t','a','t','i','o','n',' ','\x83','\x10','a','b','o','r','t','e','d',' ','\x1c','\x13','a',' ','f','a','t','a','l',' ','r','u','n','t','i','m','e',' ','\x7b',
/* 0x05edd = "Attempt to register an access handler for a physical range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x08','\xbc','\x60','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x0e','a',' ','p','h','y','s','i','c','a','l',' ','\xe4','\x13','\xc0','a',' ','p','a','r','t',' ','\x10','\x22','h','a','n','d','l','e','d','.',
/* 0x05f17 = "A legacy device isn\'t implementing the HPET notification interface." */
    'A',' ','l','e','g','a','c','y',' ','\x8b','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','i','n','g',' ','\x02','H','P','E','T',' ','n','o','t','i','f','i','c','a','t','i','o','n',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x05f51 = "A field contained an transformation that should only be used when loading old states." */
    'A',' ','\xff','c','o','n','t','a','i','n','e','d',' ','\x60','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','\x89','\xec','\xf7','\x90','u','s','e','d',' ','\xef','l','o','a','d','i','n','g',' ','o','l','d',' ','s','t','a','t','e','s','.',
/* 0x05f8b = "Hypercall cannot be enabled/performed due to access/permissions/CPL." */
    'H','y','p','e','r','c','a','l','l',' ','\xcb','\x90','e','n','a','b','l','e','d','/','p','e','r','f','o','r','m','e','d',' ','d','u','e',' ','\x08','a','c','c','e','s','s','/','p','e','r','m','i','s','s','i','o','n','s','/','C','P','L','.',
/* 0x05fc5 = "The probe location array isn\'t adjacent to the probe enable array." */
    '\x03','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','a','r','r','a','y',' ','i','s','n','\'','t',' ','a','d','j','a','c','e','n','t',' ','\x08','\x02','p','r','o','b','e',' ','e','n','a','b','l','e',' ','a','r','r','a','y','.',
/* 0x05fff = "VRDP protocol violation, client sends less data than expected." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n',',',' ','c','l','i','e','n','t',' ','s','e','n','d','s',' ','l','e','s','s',' ','\x8f','t','h','a','n',' ','e','x','p','e','c','t','e','d','.',
/* 0x06039 = "Attempt to register an access handler for a virtual range of which a part was already handled." */
    'A','t','t','e','m','p','t',' ','\x08','\xbc','\x60','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x0e','a',' ','v','i','r','t','u','a','l',' ','\xe4','\x13','\xc0','a',' ','p','a','r','t',' ','\x10','\x22','h','a','n','d','l','e','d','.',
/* 0x06072 = "Windows system integrity policy violation (device guard)." */
    'W','i','n','d','o','w','s',' ','s','y','s','t','e','m',' ','i','n','t','e','g','r','i','t','y',' ','p','o','l','i','c','y',' ','v','i','o','l','a','t','i','o','n',' ','(','d','e','v','i','c','e',' ','g','u','a','r','d',')','.',
/* 0x060ab = "Signed data verification failed because of a malformed authenticated message-digest attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','\x13','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc2','a','t','t','r','i','b','u','t','e','.',
/* 0x060e4 = "Signed data verification failed because of a malformed authenticated content-type attribute." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','\x13','a',' ','m','a','l','f','o','r','m','e','d',' ','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xd9','a','t','t','r','i','b','u','t','e','.',
/* 0x0611d = "CPU was incorrectly left in VMX root mode; incompatible with VirtualBox." */
    'C','P','U',' ','\x10','i','n','c','o','r','r','e','c','t','l','y',' ','l','e','f','t',' ','\x0d','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','i','n','c','o','m','p','a','t','i','b','l','e',' ','\x1e','\xe2','B','o','x','.',
/* 0x06156 = "Was not able to load the support driver. On linux, open returned ENODEV." */
    'W','a','s',' ','\x05','a','b','l','e',' ','\x08','l','o','a','d',' ','\x02','\xb1','d','r','i','v','e','r','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','N','O','D','E','V','.',
/* 0x0618f = "Failed to initialize a memory object. Exactly what this means is OS specific." */
    '\x80','\x08','i','n','i','t','i','a','l','i','z','e',' ','a',' ','\x5c','o','b','j','e','c','t','.',' ','E','x','a','c','t','l','y',' ','w','h','a','t',' ','\xc9','m','e','a','n','s',' ','\x09','O','S',' ','s','p','e','c','i','f','i','c','.',
/* 0x061c8 = "Internal error: Uninitialized status code. @remarks This is used by value elsewhere." */
    '\x06','\xc3','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','s','t','a','t','u','s',' ','\x5e',' ','@','r','e','m','a','r','k','s',' ','T','h','i','s',' ','\x09','u','s','e','d',' ','\xb9','\xd2','e','l','s','e','w','h','e','r','e','.',
/* 0x06201 = "The table of content XML element (toc) has siblings, we expected it to be an only child or the root element (xar)." */
    '\x03','\x9e','\x13','\xd8','X','M','L',' ','\x1f','(','t','o','c',')',' ','\x1d','s','i','b','l','i','n','g','s',',',' ','w','e',' ','\xae','i','t',' ','\x08','\x90','\x60','\xf7','c','h','i','l','d',' ','\x86','\x02','r','o','o','t',' ','\x1f','(','x','a','r',')','.',
/* 0x0623a = "Address translation disabled (but permission bits apply)." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','u','t',' ','p','e','r','m','i','s','s','i','o','n',' ','b','i','t','s',' ','a','p','p','l','y',')','.',
/* 0x06273 = "The file is too big for the current ISO level (4GB+ sized files requires ISO level 3)." */
    '\x03','\x18','\x09','\x8c','b','i','g',' ','\x0e','\x02','\xd1','\xb2',' ','l','e','v','e','l',' ','(','4','G','B','+',' ','s','i','z','e','d',' ','f','i','l','e','s',' ','r','e','q','u','i','r','e','s',' ','\xb2',' ','l','e','v','e','l',' ','3',')','.',
/* 0x062ac = "A restore routine attempted to load more data then the unit contained." */
    'A',' ','r','e','s','t','o','r','e',' ','r','o','u','t','i','n','e',' ','a','t','t','e','m','p','t','e','d',' ','\x08','l','o','a','d',' ','\xf6','\x8f','t','h','e','n',' ','\x02','u','n','i','t',' ','c','o','n','t','a','i','n','e','d','.',
/* 0x062e5 = "No DMAC device instance is registered with the current VM and thus the DMA operation cannot be performed." */
    '\xd0','D','M','A','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd1','\xcf',' ','\x2a','t','h','u','s',' ','\x02','D','M','A',' ','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x0631e = "VMLAUNCH/VMRESUME succeeded, can enter nested-guest execution." */
    'V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E',' ','s','u','c','c','e','e','d','e','d',',',' ','c','a','n',' ','e','n','t','e','r',' ','n','e','s','t','e','d','-','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x06357 = "Signed data verification failed because of the authenticated content-type attribute did not match." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','\x13','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','c','o','n','t','e','n','t','-','\xd9','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x06390 = "Configuration value is unknown. This indicates misconfiguration." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xd2','\x09','u','n','k','n','o','w','n','.',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x063c9 = "A number tar header field yielded a value too large for the internal variable of the tar interpreter." */
    'A',' ','\xdd','t','a','r',' ','\xa2','\xff','y','i','e','l','d','e','d',' ','a',' ','\xd2','\x8c','l','a','r','g','e',' ','\x0e','\x02','\x15','v','a','r','i','a','b','l','e',' ','\x13','\x02','t','a','r',' ','i','n','t','e','r','p','r','e','t','e','r','.',
/* 0x06402 = "Get an out of memory condition trying to allocate a code point array." */
    'G','e','t',' ','\x60','o','u','t',' ','\x13','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','c','o','d','e',' ','p','o','i','n','t',' ','a','r','r','a','y','.',
/* 0x0643b = "Not all requests could be submitted due to resource shortage." */
    'N','o','t',' ','a','l','l',' ','r','e','q','u','e','s','t','s',' ','c','o','u','l','d',' ','\x90','s','u','b','m','i','t','t','e','d',' ','d','u','e',' ','\x08','r','e','s','o','u','r','c','e',' ','s','h','o','r','t','a','g','e','.',
/* 0x06474 = "Reason for leaving RC: Partly handled GDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','P','a','r','t','l','y',' ','h','a','n','d','l','e','d',' ','G','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x064ad = "Got into a part of TRPM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x13','T','R','P','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xef','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x064e5 = "VT-x features for all modes (SMX and non-SMX) disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','\x0e','a','l','l',' ','m','o','d','e','s',' ','(','S','M','X',' ','\x2a','n','o','n','-','S','M','X',')',' ','d','i','s','a','b','l','e','d',' ','\xb9','\x02','B','I','O','S','.',
/* 0x0651d = "The specified I/O port range was invalid. It was either empty or it was out of bounds." */
    '\x03','\x16','I','/','O',' ','p','o','r','t',' ','\xe4','\x10','i','n','v','a','l','i','d','.',' ','I','t',' ','\x10','e','i','t','h','e','r',' ','e','m','p','t','y',' ','\x86','i','t',' ','\x10','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x06555 = "The combined minor and major device number type is too small to hold the value stored in the tar header." */
    '\x03','c','o','m','b','i','n','e','d',' ','m','i','n','o','r',' ','\x2a','m','a','j','o','r',' ','\x8b','\xdd','\xd9','\x09','\x8c','s','m','a','l','l',' ','\x08','h','o','l','d',' ','\x02','\xd2','s','t','o','r','e','d',' ','\x0d','\x02','t','a','r',' ','\xe7',
/* 0x0658d = "No PIC device instance is registered with the current VM and thus the PIC operation cannot be performed." */
    '\xd0','P','I','C',' ','\x8b','i','n','s','t','a','n','c','e',' ','\x09','r','e','g','i','s','t','e','r','e','d',' ','\x1e','\x02','\xd1','\xcf',' ','\x2a','t','h','u','s',' ','\x02','P','I','C',' ','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d','.',
/* 0x065c5 = "Certificate path validator: Unexpected minimum value found in general subtree object (name constraints)." */
    '\xa7','\xbb','\xe5','\x85','m','i','n','i','m','u','m',' ','\xd2','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8d','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x065fd = "Certificate path validator: Unexpected maximum value found in general subtree object (name constraints)." */
    '\xa7','\xbb','\xe5','\x85','m','a','x','i','m','u','m',' ','\xd2','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8d','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x06635 = "Out of memory condition when allocating physical memory (without mapping)." */
    'O','u','t',' ','\x13','\x5c','c','o','n','d','i','t','i','o','n',' ','\xef','a','l','l','o','c','a','t','i','n','g',' ','p','h','y','s','i','c','a','l',' ','\x5c','(','w','i','t','h','o','u','t',' ','m','a','p','p','i','n','g',')','.',
/* 0x0666d = "There are unconsumed bytes after decoding an ASN.1 object." */
    'T','h','e','r','e',' ','a','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','b','y','t','e','s',' ','a','f','t','e','r',' ','d','e','c','o','d','i','n','g',' ','\x60','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x066a5 = "Key decryption failed, perhaps due to an incorrect password." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','f','a','i','l','e','d',',',' ','p','e','r','h','a','p','s',' ','d','u','e',' ','\x08','\x60','i','n','c','o','r','r','e','c','t',' ','p','a','s','s','w','o','r','d','.',
/* 0x066dd = "Mount failed because a media was already mounted. Unmount the media and retry the mount." */
    'M','o','u','n','t',' ','\x88','\x1c','a',' ','m','e','d','i','a',' ','\x10','\x22','m','o','u','n','t','e','d','.',' ','U','n','m','o','u','n','t',' ','\x02','m','e','d','i','a',' ','\x2a','r','e','t','r','y',' ','\x02','m','o','u','n','t','.',
/* 0x06715 = "The I/O port range specified for removal wasn\'t found or it wasn\'t contiguous." */
    '\x03','I','/','O',' ','p','o','r','t',' ','\xe4','\x16','\x0e','r','e','m','o','v','a','l',' ','w','a','s','n','\'','t',' ','f','o','u','n','d',' ','\x86','i','t',' ','w','a','s','n','\'','t',' ','c','o','n','t','i','g','u','o','u','s','.',
/* 0x0674d = "Block read was marked as free in the image and returned as a zero block." */
    'B','l','o','c','k',' ','r','e','a','d',' ','\x10','m','a','r','k','e','d',' ','a','s',' ','f','r','e','e',' ','\x0d','\x02','\x1a','\x2a','r','e','t','u','r','n','e','d',' ','a','s',' ','a',' ','z','e','r','o',' ','b','l','o','c','k','.',
/* 0x06785 = "Got into a part of SELM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x13','S','E','L','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xef','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x067bd = "Indicating success single stepping and that EM should report that event to the debugger." */
    '\xfa','s','u','c','c','e','s','s',' ','s','i','n','g','l','e',' ','s','t','e','p','p','i','n','g',' ','\x2a','\x89','E','M',' ','\xec','r','e','p','o','r','t',' ','\x89','e','v','e','n','t',' ','\x08','\x02','d','e','b','u','g','g','e','r','.',
/* 0x067f5 = "Failed to set VMXON enable bit while enabling VT-x through the MSR." */
    '\x80','\x08','s','e','t',' ','V','M','X','O','N',' ','e','n','a','b','l','e',' ','b','i','t',' ','w','h','i','l','e',' ','e','n','a','b','l','i','n','g',' ','V','T','-','x',' ','t','h','r','o','u','g','h',' ','\x02','M','S','R','.',
/* 0x0682d = "Signed data verification failed because the authenticated message-digest attribute did not match." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','\x02','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','m','e','s','s','a','g','e','-','\xc2','a','t','t','r','i','b','u','t','e',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x06865 = "Couldn\'t find any export for registration of drivers/devices." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','e','x','p','o','r','t',' ','\x0e','r','e','g','i','s','t','r','a','t','i','o','n',' ','\x13','d','r','i','v','e','r','s','/','d','e','v','i','c','e','s','.',
/* 0x0689d = "Someone (including the caller) was already attached as debugger to the VM." */
    'S','o','m','e','o','n','e',' ','(','i','n','c','l','u','d','i','n','g',' ','\x02','c','a','l','l','e','r',')',' ','\x10','\x22','a','t','t','a','c','h','e','d',' ','a','s',' ','d','e','b','u','g','g','e','r',' ','\x08','\x02','V','M','.',
/* 0x068d5 = "The intercepted instruction handled, advance RIP and continue execution." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\xba','h','a','n','d','l','e','d',',',' ','a','d','v','a','n','c','e',' ','R','I','P',' ','\x2a','c','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x0690c = "The image requires to be signed using the kernel-code signing process." */
    '\x03','\x1a','r','e','q','u','i','r','e','s',' ','\x08','\x90','s','i','g','n','e','d',' ','u','s','i','n','g',' ','\x02','k','e','r','n','e','l','-','c','o','d','e',' ','s','i','g','n','i','n','g',' ','p','r','o','c','e','s','s','.',
/* 0x06943 = "Instruction that triggers the hypercall is invalid/unrecognized." */
    'I','n','s','t','r','u','c','t','i','o','n',' ','\x89','t','r','i','g','g','e','r','s',' ','\x02','h','y','p','e','r','c','a','l','l',' ','\x09','i','n','v','a','l','i','d','/','u','n','r','e','c','o','g','n','i','z','e','d','.',
/* 0x0697a = "Got into a part of IOM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x13','I','O','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xef','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x069b1 = "A data unit in the saved state file was defined but didn\'t any routine for processing it." */
    'A',' ','\x8f','u','n','i','t',' ','\x0d','\x02','s','a','v','e','d',' ','\xb0','\x18','\x10','d','e','f','i','n','e','d',' ','b','u','t',' ','d','i','d','n','\'','t',' ','a','n','y',' ','r','o','u','t','i','n','e',' ','\x0e','\x04','i','t','.',
/* 0x069e8 = "Page hash table is too long (covers signature data, i.e. itself)." */
    'P','a','g','e',' ','h','a','s','h',' ','\x9e','\x09','\x8c','l','o','n','g',' ','(','c','o','v','e','r','s',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a',',',' ','i','.','e','.',' ','i','t','s','e','l','f',')','.',
/* 0x06a1f = "Unable to translate one or more of the arguments to the codeset the child process is expected to use." */
    '\xca','\x08','t','r','a','n','s','l','a','t','e',' ','o','n','e',' ','\x86','\xf6','\x13','\x02','a','r','g','u','m','e','n','t','s',' ','\x08','\x02','c','o','d','e','s','e','t',' ','\x02','c','h','i','l','d',' ','\x82','\x09','\xae','\x08','u','s','e','.',
/* 0x06a56 = "Multiple primary volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','p','r','i','m','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','\xf7','d','e','a','l',' ','\x1e','o','n','e','.',
/* 0x06a8d = "The \'Type\' attribute in the DrvBlock configuration had an unknown value. Misconfiguration." */
    '\x03','\'','T','y','p','e','\'',' ','a','t','t','r','i','b','u','t','e',' ','\x0d','\x02','D','r','v','B','l','o','c','k',' ','\xe8','h','a','d',' ','\x60','\xfc','\xd3',' ','M','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x06ac4 = "The operation was cancelled by the user (copy) or another thread (local ipc)." */
    '\x03','\x83','\x10','c','a','n','c','e','l','l','e','d',' ','\xb9','\x02','u','s','e','r',' ','(','c','o','p','y',')',' ','\x86','a','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','(','l','o','c','a','l',' ','i','p','c',')','.',
/* 0x06afb = "Guest tried to trigger a CPU hang. The guest is probably up to no good." */
    'G','u','e','s','t',' ','t','r','i','e','d',' ','\x08','t','r','i','g','g','e','r',' ','a',' ','C','P','U',' ','h','a','n','g','.',' ','\x03','\xa1','\x09','p','r','o','b','a','b','l','y',' ','u','p',' ','\x08','\xe9','g','o','o','d','.',
/* 0x06b32 = "Got into a part of PDM that is not used when HM (VT-x/AMD-V) is enabled." */
    'G','o','t',' ','i','n','t','o',' ','a',' ','p','a','r','t',' ','\x13','P','D','M',' ','\x89','\x09','\x05','u','s','e','d',' ','\xef','H','M',' ','(','V','T','-','x','/','A','M','D','-','V',')',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x06b69 = "Continuing hypercall at the same RIP, continue guest execution." */
    'C','o','n','t','i','n','u','i','n','g',' ','h','y','p','e','r','c','a','l','l',' ','a','t',' ','\x02','s','a','m','e',' ','R','I','P',',',' ','c','o','n','t','i','n','u','e',' ','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x06ba0 = "Multiple logical volume descriptors found, we can only deal with one." */
    'M','u','l','t','i','p','l','e',' ','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s',' ','f','o','u','n','d',',',' ','w','e',' ','c','a','n',' ','\xf7','d','e','a','l',' ','\x1e','o','n','e','.',
/* 0x06bd7 = "The specified string / bytes buffer was to small. Specify a larger one and retry." */
    '\x03','\x16','\xc7','/',' ','b','y','t','e','s',' ','b','u','f','f','e','r',' ','\x10','\x08','s','m','a','l','l','.',' ','S','p','e','c','i','f','y',' ','a',' ','l','a','r','g','e','r',' ','o','n','e',' ','\x2a','r','e','t','r','y','.',
/* 0x06c0e = "Import ISO contains a non-contigiuous multi-extent data, this is currently not supported." */
    '\xaf','\xb2',' ','\x7f','a',' ','n','o','n','-','c','o','n','t','i','g','i','u','o','u','s',' ','m','u','l','t','i','-','e','x','t','e','n','t',' ','d','a','t','a',',',' ','\xc9','\x09','c','u','r','r','e','n','t','l','y',' ','\x05','\x95',
/* 0x06c45 = "Parameters was presented to a signature schema that does not take any." */
    'P','a','r','a','m','e','t','e','r','s',' ','\x10','p','r','e','s','e','n','t','e','d',' ','\x08','a',' ','s','i','g','n','a','t','u','r','e',' ','s','c','h','e','m','a',' ','\x89','\x9c','\x05','t','a','k','e',' ','a','n','y','.',
/* 0x06c7b = "CPU hotplug events from VMMDev are not monitored by the guest." */
    'C','P','U',' ','h','o','t','p','l','u','g',' ','e','v','e','n','t','s',' ','f','r','o','m',' ','V','M','M','D','e','v',' ','a','r','e',' ','\x05','m','o','n','i','t','o','r','e','d',' ','\xb9','\x02','g','u','e','s','t','.',
/* 0x06cb1 = "The guest GDT so full that we cannot find free space for our own selectors." */
    '\x03','\xa1','G','D','T',' ','s','o',' ','f','u','l','l',' ','\x89','w','e',' ','\xcb','f','i','n','d',' ','f','r','e','e',' ','s','p','a','c','e',' ','\x0e','o','u','r',' ','o','w','n',' ','s','e','l','e','c','t','o','r','s','.',
/* 0x06ce7 = "The decompressor completed without using all the input data." */
    '\x03','d','e','c','o','m','p','r','e','s','s','o','r',' ','c','o','m','p','l','e','t','e','d',' ','w','i','t','h','o','u','t',' ','u','s','i','n','g',' ','a','l','l',' ','\x02','i','n','p','u','t',' ','d','a','t','a','.',
/* 0x06d1d = "No active trap. Cannot query or reset a non-existing trap." */
    '\xd0','a','c','t','i','v','e',' ','t','r','a','p','.',' ','C','a','n','n','o','t',' ','q','u','e','r','y',' ','\x86','r','e','s','e','t',' ','a',' ','n','o','n','-','e','x','i','s','t','i','n','g',' ','t','r','a','p','.',
/* 0x06d53 = "Certificate path validator: Unexpected choice found in general subtree object (name constraints)." */
    '\xa7','\xbb','\xe5','\x85','c','h','o','i','c','e',' ','f','o','u','n','d',' ','\x0d','g','e','n','e','r','a','l',' ','s','u','b','t','r','e','e',' ','\x8d','(','n','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',')','.',
/* 0x06d89 = "The chunk to be unmapped isn\'t actually mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x08','\x90','u','n','m','a','p','p','e','d',' ','i','s','n','\'','t',' ','a','c','t','u','a','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x06dbf = "Cannot add symbolic link because no namespace is configured to support it." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x1c','\xe9','n','a','m','e','s','p','a','c','e',' ','\x09','c','o','n','f','i','g','u','r','e','d',' ','\x08','\xb1','i','t','.',
/* 0x06df5 = "Framebuffer is resized, terminate send bitmap procedure." */
    'F','r','a','m','e','b','u','f','f','e','r',' ','\x09','r','e','s','i','z','e','d',',',' ','t','e','r','m','i','n','a','t','e',' ','s','e','n','d',' ','b','i','t','m','a','p',' ','p','r','o','c','e','d','u','r','e','.',
/* 0x06e2b = "VFS chain element only provides a read-only I/O stream, while the chain read access." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','a',' ','r','e','a','d','-','\xf7','I','/','O',' ','s','t','r','e','a','m',',',' ','w','h','i','l','e',' ','\x02','\x91','r','e','a','d',' ','a','c','c','e','s','s','.',
/* 0x06e61 = "ASN.1 object length goes beyond the end of the byte stream being decoded." */
    'A','S','N','.','1',' ','\x8d','l','e','n','g','t','h',' ','g','o','e','s',' ','b','e','y','o','n','d',' ','\x02','e','n','d',' ','\x13','\x02','b','y','t','e',' ','s','t','r','e','a','m',' ','\xdb','d','e','c','o','d','e','d','.',
/* 0x06e97 = "Failed to make the Host Interface Networking handle non-blocking." */
    '\x80','\x08','m','a','k','e',' ','\x02','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','h','a','n','d','l','e',' ','n','o','n','-','b','l','o','c','k','i','n','g','.',
/* 0x06ecd = "Process Verification Failure: The DllCharacteristics of the process does not match the value in the optional header in the exe file." */
    '\x17','\x0c','\x12','\x03','D','l','l','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x13','\x02','\x82','\x9c','\x05','\xe3','\x02','\xd2','\x0d','\x02','o','p','t','i','o','n','a','l',' ','\xa2','\x0d','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x06f03 = "This indicates that the process does not have sufficient privileges to perform the operation." */
    'T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','\x89','\x02','\x82','\x9c','\x05','\xeb','s','u','f','f','i','c','i','e','n','t',' ','p','r','i','v','i','l','e','g','e','s',' ','\x08','p','e','r','f','o','r','m',' ','\x02','\xcc',
/* 0x06f39 = "VFS chain element only provides file, I/O stream (ios), or directory (dir) objects." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','f','i','l','e',',',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',',',' ','\x86','\x1b','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x06f6f = "Indicating that the VM has been reset and that scheduling goes back to startup defaults." */
    '\xfa','\x89','\x02','\xcf',' ','\x1d','\xad','r','e','s','e','t',' ','\x2a','\x89','s','c','h','e','d','u','l','i','n','g',' ','g','o','e','s',' ','b','a','c','k',' ','\x08','s','t','a','r','t','u','p',' ','d','e','f','a','u','l','t','s','.',
/* 0x06fa5 = "The path only element at the end of the VFS chain is too short to make out the parent directory." */
    '\x03','\xbb','\xf7','\x1f','a','t',' ','\x02','e','n','d',' ','\x13','\x02','\xa4',' ','\x91','\x09','\x8c','s','h','o','r','t',' ','\x08','m','a','k','e',' ','o','u','t',' ','\x02','p','a','r','e','n','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x06fda = "Malformed initialization vector for encrypted key ciper." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x0700f = "Recompiled execution: Breaking out because of FFs or/and IRQs." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k','i','n','g',' ','o','u','t',' ','\x1c','\x13','F','F','s',' ','o','r','/','a','n','d',' ','I','R','Q','s','.',
/* 0x07044 = "The trace log reader iterator reached the end of the event list." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','r','e','a','d','e','r',' ','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x13','\x02','e','v','e','n','t',' ','l','i','s','t','.',
/* 0x07079 = "The loader resolved an external symbol to an address to big for the image format." */
    '\x03','\xc4','r','e','s','o','l','v','e','d',' ','\x60','e','x','t','e','r','n','a','l',' ','s','y','m','b','o','l',' ','\x08','\x60','a','d','d','r','e','s','s',' ','\x08','b','i','g',' ','\x0e','\x02','\x1a','f','o','r','m','a','t','.',
/* 0x070ae = "Failed to add new mappings because the current mappings are fixed in guest os memory." */
    '\x80','\x08','a','d','d',' ','n','e','w',' ','m','a','p','p','i','n','g','s',' ','\x1c','\x02','\xd1','m','a','p','p','i','n','g','s',' ','a','r','e',' ','f','i','x','e','d',' ','\x0d','\xa1','o','s',' ','m','e','m','o','r','y','.',
/* 0x070e3 = "The CSRSS instance associated with the client process could not be located." */
    '\x03','C','S','R','S','S',' ','i','n','s','t','a','n','c','e',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','\x02','c','l','i','e','n','t',' ','\x82','c','o','u','l','d',' ','\x05','\x90','l','o','c','a','t','e','d','.',
/* 0x07118 = "The driver is already removed, not more transformations possible (at present)." */
    '\x03','\xa8','\x09','\x22','r','e','m','o','v','e','d',',',' ','\x05','\xf6','t','r','a','n','s','f','o','r','m','a','t','i','o','n','s',' ','p','o','s','s','i','b','l','e',' ','(','a','t',' ','p','r','e','s','e','n','t',')','.',
/* 0x0714d = "Tried to grow a file beyond the limit imposed by the process or the filesystem." */
    'T','r','i','e','d',' ','\x08','g','r','o','w',' ','a',' ','\x18','b','e','y','o','n','d',' ','\x02','l','i','m','i','t',' ','i','m','p','o','s','e','d',' ','\xb9','\x02','\x82','\x86','\x02','f','i','l','e','s','y','s','t','e','m','.',
/* 0x07182 = "Image Verification Warning: No Authenticode Signature, but on whitelist." */
    '\xfe','\x0c','W','a','r','n','i','n','g',':',' ','\xd0','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e',',',' ','b','u','t',' ','o','n',' ','w','h','i','t','e','l','i','s','t','.',
/* 0x071b7 = "command processing is pending, a completion handler will be called." */
    'c','o','m','m','a','n','d',' ','\x04','\x09','p','e','n','d','i','n','g',',',' ','a',' ','c','o','m','p','l','e','t','i','o','n',' ','h','a','n','d','l','e','r',' ','w','i','l','l',' ','\x90','c','a','l','l','e','d','.',
/* 0x071ec = "File access error, another process has locked a portion of the file." */
    'F','i','l','e',' ','a','c','c','e','s','s',' ','e','r','r','o','r',',',' ','a','n','o','t','h','e','r',' ','\x82','\x1d','l','o','c','k','e','d',' ','a',' ','p','o','r','t','i','o','n',' ','\x13','\x02','f','i','l','e','.',
/* 0x07221 = "Reason for leaving RC: Unhandled LDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','L','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x07255 = "Cannot add symbolic link to one of the selected namespaces." */
    'C','a','n','n','o','t',' ','a','d','d',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x08','o','n','e',' ','\x13','\x02','s','e','l','e','c','t','e','d',' ','n','a','m','e','s','p','a','c','e','s','.',
/* 0x07289 = "To short initialization vector for encrypted key ciper." */
    'T','o',' ','s','h','o','r','t',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y',' ','c','i','p','e','r','.',
/* 0x072bd = "The page hash table hashes data outside the defined and implicit sections." */
    '\x03','\xb6','h','a','s','h',' ','\x9e','h','a','s','h','e','s',' ','\x8f','o','u','t','s','i','d','e',' ','\x02','d','e','f','i','n','e','d',' ','\x2a','i','m','p','l','i','c','i','t',' ','s','e','c','t','i','o','n','s','.',
/* 0x072f1 = "RTThreadYield was called during a GVMMR0SchedPoll call." */
    'R','T','T','h','r','e','a','d','Y','i','e','l','d',' ','\x10','c','a','l','l','e','d',' ','d','u','r','i','n','g',' ','a',' ','G','V','M','M','R','0','S','c','h','e','d','P','o','l','l',' ','c','a','l','l','.',
/* 0x07325 = "Internal processing error in the PGM physcal page handling code related to MMIO/MMIO2." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','c','a','l',' ','\xb6','h','a','n','d','l','i','n','g',' ','c','o','d','e',' ','r','e','l','a','t','e','d',' ','\x08','M','M','I','O','/','M','M','I','O','2','.',
/* 0x07359 = "Active trap. Cannot assert a new trap when one is already active." */
    'A','c','t','i','v','e',' ','t','r','a','p','.',' ','C','a','n','n','o','t',' ','a','s','s','e','r','t',' ','a',' ','n','e','w',' ','t','r','a','p',' ','\xef','o','n','e',' ','\x09','\x22','a','c','t','i','v','e','.',
/* 0x0738d = "Found a ZIP64 Extra Information Field in a ZIP32 file." */
    'F','o','u','n','d',' ','a',' ','Z','I','P','6','4',' ','E','x','t','r','a',' ','I','n','f','o','r','m','a','t','i','o','n',' ','F','i','e','l','d',' ','\x0d','a',' ','Z','I','P','3','2',' ','f','i','l','e','.',
/* 0x073c1 = "The timer has a bad clock enum value, probably corruption." */
    '\x03','t','i','m','e','r',' ','\x1d','a',' ','b','a','d',' ','c','l','o','c','k',' ','e','n','u','m',' ','v','a','l','u','e',',',' ','p','r','o','b','a','b','l','y',' ','c','o','r','r','u','p','t','i','o','n','.',
/* 0x073f5 = "Invalid nested hardware virtualization feature combination." */
    '\x0b','n','e','s','t','e','d',' ','h','a','r','d','w','a','r','e',' ','v','i','r','t','u','a','l','i','z','a','t','i','o','n',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x07429 = "Attempt to create a GC mapping which conflicts with an existing mapping." */
    'A','t','t','e','m','p','t',' ','\x08','c','r','e','a','t','e',' ','a',' ','G','C',' ','\xe0','\xc0','c','o','n','f','l','i','c','t','s',' ','\x1e','\x60','e','x','i','s','t','i','n','g',' ','m','a','p','p','i','n','g','.',
/* 0x0745d = "Reason for leaving RC: Unhandled TSS write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','T','S','S',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x07491 = "Interface is unknown. This indicates misconfiguration." */
    'I','n','t','e','r','f','a','c','e',' ','\x09','u','n','k','n','o','w','n','.',' ','T','h','i','s',' ','i','n','d','i','c','a','t','e','s',' ','m','i','s','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x074c5 = "RTGetOpt: Command line option has argument with bad format." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x1d','a','r','g','u','m','e','n','t',' ','\x1e','b','a','d',' ','f','o','r','m','a','t','.',
/* 0x074f9 = "Escape URI char decodes as zero (the C string terminator)." */
    'E','s','c','a','p','e',' ','U','R','I',' ','c','h','a','r',' ','d','e','c','o','d','e','s',' ','a','s',' ','z','e','r','o',' ','(','t','h','e',' ','C',' ','\xc7','t','e','r','m','i','n','a','t','o','r',')','.',
/* 0x0752d = "Process Verification Failure: A DLL residing outside System32 was found in the process." */
    '\x17','\x0c','\x12','A',' ','D','L','L',' ','r','e','s','i','d','i','n','g',' ','o','u','t','s','i','d','e',' ','S','y','s','t','e','m','3','2',' ','\x10','f','o','u','n','d',' ','\x0d','\x02','p','r','o','c','e','s','s','.',
/* 0x07561 = "The networking interface to filter was busy (used by someone)." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x08','f','i','l','t','e','r',' ','\x10','b','u','s','y',' ','(','u','s','e','d',' ','\xb9','s','o','m','e','o','n','e',')','.',
/* 0x07595 = "Reason for leaving RC: Unhandled IDT write. Recompiler gets control." */
    '\x84','\x0e','\x25','R','C',':',' ','U','n','h','a','n','d','l','e','d',' ','I','D','T',' ','w','r','i','t','e','.',' ','R','e','c','o','m','p','i','l','e','r',' ','g','e','t','s',' ','c','o','n','t','r','o','l','.',
/* 0x075c9 = "Vote for done tell SSM not to call again until the final pass." */
    'V','o','t','e',' ','\x0e','d','o','n','e',' ','t','e','l','l',' ','S','S','M',' ','\x05','\x08','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x075fc = "Number of tries to add an int3 breakpoint table to the lookup tables reached." */
    'N','u','m','b','e','r',' ','\x13','t','r','i','e','s',' ','\x08','a','d','d',' ','\x60','i','n','t','3',' ','\xab','\x9e','\x08','\x02','l','o','o','k','u','p',' ','t','a','b','l','e','s',' ','r','e','a','c','h','e','d','.',
/* 0x0762f = "pgmPhysPageMapCommon encountered PGMPAGETYPE_MMIO2_ALIAS_MMIO." */
    'p','g','m','P','h','y','s','P','a','g','e','M','a','p','C','o','m','m','o','n',' ','\x98','P','G','M','P','A','G','E','T','Y','P','E','_','M','M','I','O','2','_','A','L','I','A','S','_','M','M','I','O','.',
/* 0x07662 = "Logging is disabled or logger instance could not be created." */
    'L','o','g','g','i','n','g',' ','\x09','d','i','s','a','b','l','e','d',' ','\x86','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x05','\x90','c','r','e','a','t','e','d','.',
/* 0x07695 = "The machine (cputype / cpusubtype combination) isn\'t supported." */
    '\x03','m','a','c','h','i','n','e',' ','(','c','p','u','t','y','p','e',' ','/',' ','c','p','u','s','u','b','t','y','p','e',' ','c','o','m','b','i','n','a','t','i','o','n',')',' ','i','s','n','\'','t',' ','\x95',
/* 0x076c8 = "The boot catalog validation entry in the import ISO has an incorrect checksum." */
    '\x03','b','o','o','t',' ','\xcd','v','a','l','i','d','a','t','i','o','n',' ','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','\x60','i','n','c','o','r','r','e','c','t',' ','c','h','e','c','k','s','u','m','.',
/* 0x076fb = "The boot catalog block in the import ISO has an incorrect validation header ID." */
    '\x03','b','o','o','t',' ','\xcd','b','l','o','c','k',' ','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','\x60','i','n','c','o','r','r','e','c','t',' ','v','a','l','i','d','a','t','i','o','n',' ','\xa2','I','D','.',
/* 0x0772e = "Out of memory condition when allocating memory with low physical backing." */
    'O','u','t',' ','\x13','\x5c','c','o','n','d','i','t','i','o','n',' ','\xef','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x1e','l','o','w',' ','p','h','y','s','i','c','a','l',' ','b','a','c','k','i','n','g','.',
/* 0x07761 = "Import ISO starts with supplementary volume descriptor before any primary ones." */
    '\xaf','\xb2',' ','s','t','a','r','t','s',' ','\x1e','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbd','\xd6','b','e','f','o','r','e',' ','a','n','y',' ','p','r','i','m','a','r','y',' ','o','n','e','s','.',
/* 0x07794 = "Object corresponding to the supplied arguments does not exist." */
    'O','b','j','e','c','t',' ','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','\x08','\x02','s','u','p','p','l','i','e','d',' ','a','r','g','u','m','e','n','t','s',' ','\x9c','\x05','e','x','i','s','t','.',
/* 0x077c6 = "Don\'t spin for the semaphore, but it is safe to try grab it." */
    'D','o','n','\'','t',' ','s','p','i','n',' ','\x0e','\x02','s','e','m','a','p','h','o','r','e',',',' ','b','u','t',' ','i','t',' ','\x09','s','a','f','e',' ','\x08','t','r','y',' ','g','r','a','b',' ','i','t','.',
/* 0x077f8 = "Asynchronous stream initialization still on-going." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','s','t','r','e','a','m',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','s','t','i','l','l',' ','o','n','-','g','o','i','n','g','.',
/* 0x0782a = "Certificate path validator: Intermediate certificate is missing the KeyCertSign usage flag." */
    '\xa7','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','m','i','s','s','i','n','g',' ','\x02','K','e','y','C','e','r','t','S','i','g','n',' ','u','s','a','g','e',' ','f','l','a','g','.',
/* 0x0785c = "Support for metadata partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','m','e','t','a','d','a','t','a',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xad','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0788e = "Tree traversal encountered more nodes than available in the allocator." */
    'T','r','e','e',' ','t','r','a','v','e','r','s','a','l',' ','\x98','\xf6','n','o','d','e','s',' ','t','h','a','n',' ','a','v','a','i','l','a','b','l','e',' ','\x0d','\x02','a','l','l','o','c','a','t','o','r','.',
/* 0x078c0 = "Non-standard descriptor character set in the logical volume descriptor." */
    'N','o','n','-','s','t','a','n','d','a','r','d',' ','\xd6','c','h','a','r','a','c','t','e','r',' ','s','e','t',' ','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x078f2 = "Unkonwn paritition ID found in the partition map table." */
    'U','n','k','o','n','w','n',' ','p','a','r','i','t','i','t','i','o','n',' ','I','D',' ','f','o','u','n','d',' ','\x0d','\x02','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','t','a','b','l','e','.',
/* 0x07924 = "The network already exists with a different trunk configuration." */
    '\x03','n','e','t','w','o','r','k',' ','\x22','e','x','i','s','t','s',' ','\x1e','a',' ','d','i','f','f','e','r','e','n','t',' ','t','r','u','n','k',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x07956 = "Support for sparable partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','s','p','a','r','a','b','l','e',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xad','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07988 = "The I/O queue has requests pending which need complete first." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x1d','r','e','q','u','e','s','t','s',' ','p','e','n','d','i','n','g',' ','\xc0','n','e','e','d',' ','c','o','m','p','l','e','t','e',' ','f','i','r','s','t','.',
/* 0x079ba = "SPC requires there to be exactly one SignerInfo entry." */
    'S','P','C',' ','r','e','q','u','i','r','e','s',' ','t','h','e','r','e',' ','\x08','\x90','e','x','a','c','t','l','y',' ','o','n','e',' ','S','i','g','n','e','r','I','n','f','o',' ','e','n','t','r','y','.',
/* 0x079ec = "Saving the VM state is temporarily not allowed. Try again later." */
    'S','a','v','i','n','g',' ','\x02','\xcf',' ','\xb0','\x09','t','e','m','p','o','r','a','r','i','l','y',' ','\x05','a','l','l','o','w','e','d','.',' ','T','r','y',' ','a','g','a','i','n',' ','l','a','t','e','r','.',
/* 0x07a1e = "Unable to seal text memory again to protect against write access (hardening)." */
    '\xca','\x08','s','e','a','l',' ','t','e','x','t',' ','\x5c','a','g','a','i','n',' ','\x08','p','r','o','t','e','c','t',' ','a','g','a','i','n','s','t',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a',
/* 0x07a50 = "Maximum of concurrent clipboard transfers has been reached." */
    'M','a','x','i','m','u','m',' ','\x13','c','o','n','c','u','r','r','e','n','t',' ','c','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r','s',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x07a82 = "Encountered unicode code point in the surrogate range (0xd800 to 0xdfff)." */
    '\x97','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\x0d','\x02','s','u','r','r','o','g','a','t','e',' ','\xe4','(','0','x','d','8','0','0',' ','\x08','0','x','d','f','f','f',')','.',
/* 0x07ab4 = "Found unexpected cipher parameters for encrypted key." */
    'F','o','u','n','d',' ','u','n','e','x','p','e','c','t','e','d',' ','c','i','p','h','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x07ae6 = "The request is for something forbidden. Authorization will not help." */
    '\x03','\x94','\x09','\x0e','s','o','m','e','t','h','i','n','g',' ','f','o','r','b','i','d','d','e','n','.',' ','A','u','t','h','o','r','i','z','a','t','i','o','n',' ','w','i','l','l',' ','\x05','h','e','l','p','.',
/* 0x07b18 = "Certificate path validator: Intermediate certificate subject does not match child issuer property." */
    '\xa7','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','s','u','b','j','e','c','t',' ','\x9c','\x05','\xe3','c','h','i','l','d',' ','i','s','s','u','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x07b4a = "A attach or prepare mount call failed because the driver already had a driver attached." */
    'A',' ','a','t','t','a','c','h',' ','\x86','p','r','e','p','a','r','e',' ','m','o','u','n','t',' ','c','a','l','l',' ','\x88','\x1c','\x02','\xa8','\x22','h','a','d',' ','a',' ','\xa8','a','t','t','a','c','h','e','d','.',
/* 0x07b7c = "A new node couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','n','o','d','e',' ','c','o','u','l','d','n','\'','t',' ','\x90','i','n','s','e','r','t','e','d',' ','\x1c','o','n','e',' ','\x1e','\x02','s','a','m','e',' ','\xf3','e','x','i','s','t','s','.',
/* 0x07bae = "Certificate path validator: Hit the max certificate path length before reaching trust anchor." */
    '\xa7','\xbb','\xe5','H','i','t',' ','\x02','m','a','x',' ','\x8a','\xbb','l','e','n','g','t','h',' ','b','e','f','o','r','e',' ','r','e','a','c','h','i','n','g',' ','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x07be0 = "The patch manager is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','p','a','t','c','h',' ','m','a','n','a','g','e','r',' ','\x09','\x05','u','s','e','d',' ','\x1c','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x2a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x07c12 = "Failed to initialize a virtual network interface instance." */
    '\x80','\x08','i','n','i','t','i','a','l','i','z','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x07c44 = "A new leaf couldn\'t be inserted because one with the same name exists." */
    'A',' ','n','e','w',' ','l','e','a','f',' ','c','o','u','l','d','n','\'','t',' ','\x90','i','n','s','e','r','t','e','d',' ','\x1c','o','n','e',' ','\x1e','\x02','s','a','m','e',' ','\xf3','e','x','i','s','t','s','.',
/* 0x07c76 = "CPU is not in VMX root mode; unexpected when leaving VMX root mode." */
    'C','P','U',' ','\x09','\x05','\x0d','V','M','X',' ','r','o','o','t',' ','m','o','d','e',';',' ','u','n','e','x','p','e','c','t','e','d',' ','\xef','\x25','V','M','X',' ','r','o','o','t',' ','m','o','d','e','.',
/* 0x07ca7 = "The TCP server was shut down using RTTcpServerShutdown." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x10','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','T','c','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x07cd8 = "Process Verification Failure: An unknown and unwanted DLL was found loaded into the process." */
    '\x17','\x0c','\x12','A','n',' ','\xfc','\x2a','u','n','w','a','n','t','e','d',' ','D','L','L',' ','\x10','f','o','u','n','d',' ','l','o','a','d','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x07d09 = "Failed to create or connect to a networking interface filter." */
    '\x80','\x08','c','r','e','a','t','e',' ','\x86','c','o','n','n','e','c','t',' ','\x08','a',' ','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','f','i','l','t','e','r','.',
/* 0x07d3a = "Mismatching SVN revision number between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','S','V','N',' ','r','e','v','i','s','i','o','n',' ','\xdd','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x07d6b = "The ELF image was created for an unsupported target machine type." */
    '\x03','E','L','F',' ','\x1a','\x10','c','r','e','a','t','e','d',' ','\x0e','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','t','y','p','e','.',
/* 0x07d9c = "Resume guest execution after injecting a double-fault." */
    'R','e','s','u','m','e',' ','\xa1','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','i','n','j','e','c','t','i','n','g',' ','a',' ','d','o','u','b','l','e','-','f','a','u','l','t','.',
/* 0x07dcd = "Unable to open the host interface due to a sharing violation ." */
    '\xca','\x08','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','d','u','e',' ','\x08','a',' ','s','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',' ','.',
/* 0x07dfe = "Page fault caused by dirty bit tracking; corrected." */
    'P','a','g','e',' ','f','a','u','l','t',' ','c','a','u','s','e','d',' ','\xb9','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g',';',' ','c','o','r','r','e','c','t','e','d','.',
/* 0x07e2f = "Process Verification Failure: Found no executable mapped into the process address space." */
    '\x17','\x0c','\x12','F','o','u','n','d',' ','\xe9','e','x','e','c','u','t','a','b','l','e',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','\x82','a','d','d','r','e','s','s',' ','s','p','a','c','e','.',
/* 0x07e60 = "Support for virtual partitions as not yet been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','v','i','r','t','u','a','l',' ','p','a','r','t','i','t','i','o','n','s',' ','a','s',' ','\x05','y','e','t',' ','\xad','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x07e91 = "No trace buffer available, please change the VM config." */
    '\xd0','t','r','a','c','e',' ','b','u','f','f','e','r',' ','a','v','a','i','l','a','b','l','e',',',' ','p','l','e','a','s','e',' ','c','h','a','n','g','e',' ','\x02','\xcf',' ','c','o','n','f','i','g','.',
/* 0x07ec2 = "Certificate path validator: Name constraints does not permits the alternative certificate name." */
    '\xa7','\xbb','\xe5','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\x9c','\x05','p','e','r','m','i','t','s',' ','\x02','a','l','t','e','r','n','a','t','i','v','e',' ','\x8a','n','a','m','e','.',
/* 0x07ef3 = "The UDP server was shut down using RTUdpServerShutdown." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x10','s','h','u','t',' ','d','o','w','n',' ','u','s','i','n','g',' ','R','T','U','d','p','S','e','r','v','e','r','S','h','u','t','d','o','w','n','.',
/* 0x07f24 = "The specified MMIO range was invalid. It was either empty or it was out of bounds." */
    '\x03','\x16','\xf4',' ','\xe4','\x10','i','n','v','a','l','i','d','.',' ','I','t',' ','\x10','e','i','t','h','e','r',' ','e','m','p','t','y',' ','\x86','i','t',' ','\x10','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x07f55 = "The iprt loader recognized an a.out image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','\x60','a','.','o','u','t',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x07f86 = "This particular aspect of the instruction is not yet implemented by IEM." */
    'T','h','i','s',' ','p','a','r','t','i','c','u','l','a','r',' ','a','s','p','e','c','t',' ','\x13','\x02','\xba','\x09','\x05','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xb9','I','E','M','.',
/* 0x07fb7 = "Nested ownership requests are not permitted for this semaphore type." */
    'N','e','s','t','e','d',' ','o','w','n','e','r','s','h','i','p',' ','r','e','q','u','e','s','t','s',' ','a','r','e',' ','\x05','p','e','r','m','i','t','t','e','d',' ','\x0e','\xc9','\xea','t','y','p','e','.',
/* 0x07fe8 = "VRDP script allowed the packet to be processed further." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','a','l','l','o','w','e','d',' ','\x02','p','a','c','k','e','t',' ','\x08','\x90','p','r','o','c','e','s','s','e','d',' ','f','u','r','t','h','e','r','.',
/* 0x08018 = "An entry in the manifest file couldn\'t be interpreted correctly." */
    'A','n',' ','\xb5','\x0d','\x02','m','a','n','i','f','e','s','t',' ','\x18','c','o','u','l','d','n','\'','t',' ','\x90','i','n','t','e','r','p','r','e','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x08048 = "The VM state was invalid for the requested operation. Go check the \'VM Statechart Diagram.gif\'." */
    '\x03','\xcf',' ','\xb0','\x10','\x81','\x0e','\x02','\xbf','\xcc',' ','G','o',' ','c','h','e','c','k',' ','\x02','\'','\xcf',' ','S','t','a','t','e','c','h','a','r','t',' ','D','i','a','g','r','a','m','.','g','i','f','\'','.',
/* 0x08078 = "Expected PKCS #7 object to contain exactly on signer info entry." */
    '\xa6','P','K','C','S',' ','#','7',' ','\x8d','\x08','c','o','n','t','a','i','n',' ','e','x','a','c','t','l','y',' ','o','n',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','e','n','t','r','y','.',
/* 0x080a8 = "Syntax error - Couldn\'t satisfy a request for a specific result type." */
    '\xe1','\x07','-',' ','C','o','u','l','d','n','\'','t',' ','s','a','t','i','s','f','y',' ','a',' ','\x94','\x0e','a',' ','s','p','e','c','i','f','i','c',' ','r','e','s','u','l','t',' ','t','y','p','e','.',
/* 0x080d8 = "Reason for leaving RZ: Defer the owner callback invocation to Ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','D','e','f','e','r',' ','\x02','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','i','n','v','o','c','a','t','i','o','n',' ','\x08','R','i','n','g','-','3','.',
/* 0x08108 = "Unimplemented ASN.1 tag reached the RTAsn1DynType code." */
    'U','n','i','m','p','l','e','m','e','n','t','e','d',' ','A','S','N','.','1',' ','t','a','g',' ','r','e','a','c','h','e','d',' ','\x02','R','T','A','s','n','1','D','y','n','T','y','p','e',' ','\x5e',
/* 0x08138 = "Cannot destroy VM because not all other EMTs have deregistered." */
    'C','a','n','n','o','t',' ','d','e','s','t','r','o','y',' ','\xcf',' ','\x1c','\x05','a','l','l',' ','o','t','h','e','r',' ','E','M','T','s',' ','\xeb','d','e','r','e','g','i','s','t','e','r','e','d','.',
/* 0x08168 = "Failed to write to a memory region while performing a hypercall." */
    '\x80','\x08','w','r','i','t','e',' ','\x08','a',' ','\x5c','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x08198 = "Internal error: Supposedly unreachable default case in a switch." */
    '\x06','\xc3','S','u','p','p','o','s','e','d','l','y',' ','u','n','r','e','a','c','h','a','b','l','e',' ','d','e','f','a','u','l','t',' ','c','a','s','e',' ','\x0d','a',' ','s','w','i','t','c','h','.',
/* 0x081c8 = "Process Verification Failure: The ImageCharacteristics of the process does not match the value in the file header in the exe file." */
    '\x17','\x0c','\x12','\x03','I','m','a','g','e','C','h','a','r','a','c','t','e','r','i','s','t','i','c','s',' ','\x13','\x02','\x82','\x9c','\x05','\xe3','\x02','\xd2','\x0d','\x02','\x18','\xa2','\x0d','\x02','e','x','e',' ','f','i','l','e','.',
/* 0x081f8 = "Syntax error - Cannot read symbol value, it is a set-only symbol." */
    '\xe1','\x07','-',' ','C','a','n','n','o','t',' ','r','e','a','d',' ','s','y','m','b','o','l',' ','v','a','l','u','e',',',' ','i','t',' ','\x09','a',' ','s','e','t','-','\xf7','s','y','m','b','o','l','.',
/* 0x08228 = "The backend needs more metadata before it can continue." */
    '\x03','b','a','c','k','e','n','d',' ','n','e','e','d','s',' ','\xf6','m','e','t','a','d','a','t','a',' ','b','e','f','o','r','e',' ','i','t',' ','c','a','n',' ','c','o','n','t','i','n','u','e','.',
/* 0x08258 = "The Logical Unit was found, but it had no driver attached to it." */
    '\x03','L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x10','f','o','u','n','d',',',' ','b','u','t',' ','i','t',' ','h','a','d',' ','\xe9','\xa8','a','t','t','a','c','h','e','d',' ','\x08','i','t','.',
/* 0x08288 = "Internal ISO maker error: Inconsistency produing trans.tbl file." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','I','n','c','o','n','s','i','s','t','e','n','c','y',' ','p','r','o','d','u','i','n','g',' ','t','r','a','n','s','.','t','b','l',' ','f','i','l','e','.',
/* 0x082b8 = "Hit unimplemented glob pattern matching feature." */
    'H','i','t',' ','u','n','i','m','p','l','e','m','e','n','t','e','d',' ','g','l','o','b',' ','p','a','t','t','e','r','n',' ','m','a','t','c','h','i','n','g',' ','f','e','a','t','u','r','e','.',
/* 0x082e8 = "ASN.1 tag and flags/class mismatch in RTAsn1DynType code." */
    'A','S','N','.','1',' ','t','a','g',' ','\x2a','f','l','a','g','s','/','c','l','a','s','s',' ','m','i','s','m','a','t','c','h',' ','\x0d','R','T','A','s','n','1','D','y','n','T','y','p','e',' ','\x5e',
/* 0x08318 = "Attempt to recursively enter a non-recursive lock." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','c','u','r','s','i','v','e','l','y',' ','e','n','t','e','r',' ','a',' ','n','o','n','-','r','e','c','u','r','s','i','v','e',' ','l','o','c','k','.',
/* 0x08348 = "The DTB structs block contains a malformed padding at the end." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','a',' ','m','a','l','f','o','r','m','e','d',' ','p','a','d','d','i','n','g',' ','a','t',' ','\x02','e','n','d','.',
/* 0x08378 = "The uncompressed table of content size in the header didn\'t match what ZLib returned." */
    '\x03','u','n','c','o','m','p','r','e','s','s','e','d',' ','\x9e','\x13','\xd8','\xf8','\x0d','\x02','\xa2','d','i','d','n','\'','t',' ','\xe3','w','h','a','t',' ','Z','L','i','b',' ','r','e','t','u','r','n','e','d','.',
/* 0x083a8 = "Encountered a section type that\'s not known to the loader. (probably invalid)." */
    '\x97','a',' ','\xc6','\xd9','t','h','a','t','\'','s',' ','\x05','k','n','o','w','n',' ','\x08','\x02','l','o','a','d','e','r','.',' ','(','p','r','o','b','a','b','l','y',' ','i','n','v','a','l','i','d',')','.',
/* 0x083d8 = "Attempt to free more memory than what was previously allocated." */
    'A','t','t','e','m','p','t',' ','\x08','f','r','e','e',' ','\xf6','\x5c','t','h','a','n',' ','w','h','a','t',' ','\x10','p','r','e','v','i','o','u','s','l','y',' ','a','l','l','o','c','a','t','e','d','.',
/* 0x08408 = "Reason for leaving RC: jump inside generated patch jump. Fatal error." */
    '\x84','\x0e','\x25','R','C',':',' ','j','u','m','p',' ','i','n','s','i','d','e',' ','g','e','n','e','r','a','t','e','d',' ','p','a','t','c','h',' ','j','u','m','p','.',' ','F','a','t','a','l',' ','\x7b',
/* 0x08438 = "The MMIO handler experienced a problem with the disassembler." */
    '\x03','\xf4',' ','h','a','n','d','l','e','r',' ','e','x','p','e','r','i','e','n','c','e','d',' ','a',' ','p','r','o','b','l','e','m',' ','\x1e','\x02','d','i','s','a','s','s','e','m','b','l','e','r','.',
/* 0x08468 = "The iprt loader recognized a ELF image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','a',' ','E','L','F',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x08498 = "Escaped URI character is not a valid UTF-8 lead byte." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r',' ','\x09','\x05','a',' ','v','a','l','i','d',' ','U','T','F','-','8',' ','l','e','a','d',' ','b','y','t','e','.',
/* 0x084c8 = "Failed to retrieve a virtual network interface link ID." */
    '\x80','\x08','r','e','t','r','i','e','v','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','l','i','n','k',' ','I','D','.',
/* 0x084f7 = "The support driver is not installed. On linux, open returned ENOENT." */
    '\x03','\xb1','\xa8','\x09','\x05','i','n','s','t','a','l','l','e','d','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','N','O','E','N','T','.',
/* 0x08526 = "Indicates that we modified the host CR0 (FPU related)." */
    'I','n','d','i','c','a','t','e','s',' ','\x89','w','e',' ','m','o','d','i','f','i','e','d',' ','\x02','h','o','s','t',' ','C','R','0',' ','(','F','P','U',' ','r','e','l','a','t','e','d',')','.',
/* 0x08555 = "The DTB being parsed has an invalid size set in the header compared to the actual size." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\x60','\x81','\xf8','s','e','t',' ','\x0d','\x02','\xa2','c','o','m','p','a','r','e','d',' ','\x08','\x02','a','c','t','u','a','l',' ','s','i','z','e','.',
/* 0x08584 = "The Host Interface Networking name config IOCTL call failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\xf3','c','o','n','f','i','g',' ','I','O','C','T','L',' ','c','a','l','l',' ','\x24',
/* 0x085b3 = "A reboot is needed for completing driver (un)installation." */
    'A',' ','r','e','b','o','o','t',' ','\x09','n','e','e','d','e','d',' ','\x0e','c','o','m','p','l','e','t','i','n','g',' ','\xa8','(','u','n',')','i','n','s','t','a','l','l','a','t','i','o','n','.',
/* 0x085e2 = "Encountered a unicode code point which cannot be represented as UTF-16." */
    '\x97','a',' ','u','n','i','c','o','d','e',' ','c','o','d','e',' ','p','o','i','n','t',' ','\xc0','\xcb','\x90','r','e','p','r','e','s','e','n','t','e','d',' ','a','s',' ','U','T','F','-','1','6','.',
/* 0x08611 = "No debug module interpreter matching the debug info." */
    '\xd0','d','e','b','u','g',' ','m','o','d','u','l','e',' ','i','n','t','e','r','p','r','e','t','e','r',' ','m','a','t','c','h','i','n','g',' ','\x02','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x08640 = "The OS does not support setting the time stamps on a symbolic link." */
    '\x03','O','S',' ','\x9c','\x05','\xb1','s','e','t','t','i','n','g',' ','\x02','t','i','m','e',' ','s','t','a','m','p','s',' ','o','n',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0866f = "Malformed partition map table in the logical volume descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\x9e','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0869e = "The session has reached the max number of (user mode) providers." */
    '\x03','s','e','s','s','i','o','n',' ','\x1d','r','e','a','c','h','e','d',' ','\x02','m','a','x',' ','\xdd','\x13','(','u','s','e','r',' ','m','o','d','e',')',' ','p','r','o','v','i','d','e','r','s','.',
/* 0x086cd = "Someone is trying to write a memory block which is too big to encode." */
    'S','o','m','e','o','n','e',' ','\x09','t','r','y','i','n','g',' ','\x08','w','r','i','t','e',' ','a',' ','\x5c','b','l','o','c','k',' ','\xc0','\x09','\x8c','b','i','g',' ','\x08','e','n','c','o','d','e','.',
/* 0x086fc = "The iprt loader recognized a NE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','a',' ','N','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0872b = "The iprt loader recognized a LX image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','X',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x0875a = "Failed getting cryptographically strong random bytes." */
    '\x80','g','e','t','t','i','n','g',' ','c','r','y','p','t','o','g','r','a','p','h','i','c','a','l','l','y',' ','s','t','r','o','n','g',' ','r','a','n','d','o','m',' ','b','y','t','e','s','.',
/* 0x08789 = "Got an out of memory condition trying to allocate a string." */
    'G','o','t',' ','\x60','o','u','t',' ','\x13','\x5c','c','o','n','d','i','t','i','o','n',' ','t','r','y','i','n','g',' ','\x08','a','l','l','o','c','a','t','e',' ','a',' ','s','t','r','i','n','g','.',
/* 0x087b8 = "The iprt loader recognized a PE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','a',' ','P','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x087e7 = "Encountered an unsupported portable archive exchange (pax) header." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','p','o','r','t','a','b','l','e',' ','a','r','c','h','i','v','e',' ','e','x','c','h','a','n','g','e',' ','(','p','a','x',')',' ','\xe7',
/* 0x08816 = "The support driver is not accessible. On linux, open returned EPERM." */
    '\x03','\xb1','\xa8','\x09','\x05','a','c','c','e','s','s','i','b','l','e','.',' ','O','n',' ','l','i','n','u','x',',',' ','o','p','e','n',' ','r','e','t','u','r','n','e','d',' ','E','P','E','R','M','.',
/* 0x08845 = "Invalid VMCS pointer. (Can be OR\'ed with VERR_VMX_INVALID_VMCS_FIELD.)." */
    '\x0b','V','M','C','S',' ','p','o','i','n','t','e','r','.',' ','(','C','a','n',' ','\x90','O','R','\'','e','d',' ','\x1e','\x01','V','M','X','_','\x0f','V','M','C','S','_','F','I','E','L','D','.',')','.',
/* 0x08874 = "Non fatal Patch Manager analysis phase warning." */
    'N','o','n',' ','f','a','t','a','l',' ','P','a','t','c','h',' ','M','a','n','a','g','e','r',' ','a','n','a','l','y','s','i','s',' ','p','h','a','s','e',' ','w','a','r','n','i','n','g','.',
/* 0x088a3 = "Recompiled execution: Break out of current TB execution." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','B','r','e','a','k',' ','o','u','t',' ','\x13','\xd1','T','B',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x088d2 = "Certificate path validator: Intermediate certificate is not marked as a certificate authority (CA)." */
    '\xa7','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','\x05','m','a','r','k','e','d',' ','a','s',' ','a',' ','\x8a','a','u','t','h','o','r','i','t','y',' ','(','C','A',')','.',
/* 0x08901 = "Failed to read to a memory region while performing a hypercall." */
    '\x80','\x08','r','e','a','d',' ','\x08','a',' ','\x5c','r','e','g','i','o','n',' ','w','h','i','l','e',' ','p','e','r','f','o','r','m','i','n','g',' ','a',' ','h','y','p','e','r','c','a','l','l','.',
/* 0x08930 = "Import ISO contains a directory with a more than one extent, that\'s currently not supported." */
    '\xaf','\xb2',' ','\x7f','a',' ','\x1b','\x1e','a',' ','\xf6','t','h','a','n',' ','o','n','e',' ','e','x','t','e','n','t',',',' ','t','h','a','t','\'','s',' ','c','u','r','r','e','n','t','l','y',' ','\x05','\x95',
/* 0x0895f = "The sections aren\'t ordered by segment as expected by the loader." */
    '\x03','s','e','c','t','i','o','n','s',' ','a','r','e','n','\'','t',' ','o','r','d','e','r','e','d',' ','\xb9','s','e','g','m','e','n','t',' ','a','s',' ','\xae','\xb9','\x02','l','o','a','d','e','r','.',
/* 0x0898e = "The iprt loader recognized a LE image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','a',' ','L','E',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x089bd = "The iprt loader recognized a MZ image, but doesn't support loading it." */
    '\x03','i','p','r','t',' ','\xc4','r','e','c','o','g','n','i','z','e','d',' ','a',' ','M','Z',' ','i','m','a','g','e',',',' ','b','u','t',' ','\xa5','\xb1','l','o','a','d','i','n','g',' ','i','t','.',
/* 0x089ec = "Out of memory condition when allocating executable memory." */
    'O','u','t',' ','\x13','\x5c','c','o','n','d','i','t','i','o','n',' ','\xef','a','l','l','o','c','a','t','i','n','g',' ','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x08a1a = "Couldn\'t find any free USB ports to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','f','r','e','e',' ','U','S','B',' ','p','o','r','t','s',' ','\x08','a','t','t','a','c','h',' ','\x02','\x8b','t','o','.',
/* 0x08a48 = "The group is a non-system group and it has write access (hardening)." */
    '\x03','g','r','o','u','p',' ','\x09','a',' ','n','o','n','-','s','y','s','t','e','m',' ','g','r','o','u','p',' ','\x2a','i','t',' ','\x1d','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x9a',
/* 0x08a76 = "Import ISO contains a directory record with a mismatching volume sequence number." */
    '\xaf','\xb2',' ','\x7f','a',' ','\x1b','r','e','c','o','r','d',' ','\x1e','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xbd','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x08aa4 = "The physical guest page is a reserved/MMIO page and does not have any HC address." */
    '\x03','p','h','y','s','i','c','a','l',' ','\xa1','\xb6','\x09','a',' ','r','e','s','e','r','v','e','d','/','\xf4',' ','\xb6','\x2a','\x9c','\x05','\xeb','a','n','y',' ','H','C',' ','a','d','d','r','e','s','s','.',
/* 0x08ad2 = "An EMT called an API which cannot be called on such a thread." */
    'A','n',' ','E','M','T',' ','c','a','l','l','e','d',' ','\x60','A','P','I',' ','\xc0','\xcb','\x90','c','a','l','l','e','d',' ','o','n',' ','s','u','c','h',' ','a',' ','t','h','r','e','a','d','.',
/* 0x08b00 = "The size of the one or more regions in the shared module was out of range." */
    '\x03','\xf8','\x13','\x02','o','n','e',' ','\x86','\xf6','r','e','g','i','o','n','s',' ','\x0d','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x08b2e = "Internal EM error caused by an unknown warning or informational status code." */
    '\x06','E','M',' ','\x07','c','a','u','s','e','d',' ','\xb9','\x60','\xfc','w','a','r','n','i','n','g',' ','\x86','i','n','f','o','r','m','a','t','i','o','n','a','l',' ','s','t','a','t','u','s',' ','\x5e',
/* 0x08b5c = "Unknown error while reading the guest GDT during shadow table updating." */
    '\xdf','\x07','w','h','i','l','e',' ','r','e','a','d','i','n','g',' ','\x02','\xa1','G','D','T',' ','d','u','r','i','n','g',' ','s','h','a','d','o','w',' ','\x9e','u','p','d','a','t','i','n','g','.',
/* 0x08b8a = "The boot catalog validation entry in the import ISO has incorrect keys." */
    '\x03','b','o','o','t',' ','\xcd','v','a','l','i','d','a','t','i','o','n',' ','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','i','n','c','o','r','r','e','c','t',' ','k','e','y','s','.',
/* 0x08bb8 = "Internal processing error in the PGM physical page mapping code dealing with MMIO2 pages." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','\xb6','\xe0','c','o','d','e',' ','d','e','a','l','i','n','g',' ','\x1e','M','M','I','O','2',' ','p','a','g','e','s','.',
/* 0x08be6 = "A break was detected until all requested data could be received." */
    'A',' ','b','r','e','a','k',' ','\x10','d','e','t','e','c','t','e','d',' ','u','n','t','i','l',' ','a','l','l',' ','\xbf','\x8f','c','o','u','l','d',' ','\x90','r','e','c','e','i','v','e','d','.',
/* 0x08c14 = "The Host Interface Networking terminate program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','t','e','r','m','i','n','a','t','e',' ','p','r','o','g','r','a','m',' ','\x24',
/* 0x08c42 = "A TSC-delta measurement request is currently being serviced." */
    'A',' ','T','S','C','-','d','e','l','t','a',' ','m','e','a','s','u','r','e','m','e','n','t',' ','\x94','\x09','c','u','r','r','e','n','t','l','y',' ','\xdb','s','e','r','v','i','c','e','d','.',
/* 0x08c70 = "Failed to create a virtual network interface instance." */
    '\x80','\x08','c','r','e','a','t','e',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x08c9e = "Unsupported create type in an RTVfsObjOpen or RTVfsDirOpenObj call." */
    '\x87','c','r','e','a','t','e',' ','\xd9','\x0d','\x60','R','T','V','f','s','O','b','j','O','p','e','n',' ','\x86','R','T','V','f','s','D','i','r','O','p','e','n','O','b','j',' ','c','a','l','l','.',
/* 0x08ccc = "Unfinished CodeView debug information feature." */
    'U','n','f','i','n','i','s','h','e','d',' ','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','f','e','a','t','u','r','e','.',
/* 0x08cfa = "Invalid context. Typically an API was used by the wrong thread." */
    '\x0b','c','o','n','t','e','x','t','.',' ','T','y','p','i','c','a','l','l','y',' ','\x60','A','P','I',' ','\x10','u','s','e','d',' ','\xb9','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x08d28 = "The breakpoint owner handle is still used by one or more breakpoints." */
    '\x03','\xab','o','w','n','e','r',' ','h','a','n','d','l','e',' ','\x09','s','t','i','l','l',' ','u','s','e','d',' ','\xb9','o','n','e',' ','\x86','\xf6','b','r','e','a','k','p','o','i','n','t','s','.',
/* 0x08d56 = "Server response contains unexpected repetitive header field." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x7f','u','n','e','x','p','e','c','t','e','d',' ','r','e','p','e','t','i','t','i','v','e',' ','\xa2','f','i','e','l','d','.',
/* 0x08d84 = "The default boot catalog entry in the import ISO an invalid boot indicator value." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x60','\x81','b','o','o','t',' ','i','n','d','i','c','a','t','o','r',' ','\xd3',
/* 0x08db1 = "The image is 32-bit and contains 64-bit load commands or vise versa." */
    '\x03','\x1a','\x09','3','2','-','b','i','t',' ','\x2a','\x7f','6','4','-','b','i','t',' ','l','o','a','d',' ','c','o','m','m','a','n','d','s',' ','\x86','v','i','s','e',' ','v','e','r','s','a','.',
/* 0x08dde = "Escaped URI characters does not decode to valid UTF-8." */
    'E','s','c','a','p','e','d',' ','U','R','I',' ','c','h','a','r','a','c','t','e','r','s',' ','\x9c','\x05','d','e','c','o','d','e',' ','\x08','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x08e0b = "A path is not relative (start with root), expected an relative path." */
    'A',' ','\xbb','\x09','\x05','r','e','l','a','t','i','v','e',' ','(','s','t','a','r','t',' ','\x1e','r','o','o','t',')',',',' ','\xae','\x60','r','e','l','a','t','i','v','e',' ','p','a','t','h','.',
/* 0x08e38 = "The page is unassigned (akin to VERR_PGM_INVALID_GC_PHYSICAL_ADDRESS)." */
    '\x03','\xb6','\x09','u','n','a','s','s','i','g','n','e','d',' ','(','a','k','i','n',' ','\x08','\x01','\xd7','\x0f','G','C','_','P','H','Y','S','I','C','A','L','_','A','D','D','R','E','S','S',')','.',
/* 0x08e65 = "Not able satisfy all the requirements of the request." */
    'N','o','t',' ','a','b','l','e',' ','s','a','t','i','s','f','y',' ','a','l','l',' ','\x02','r','e','q','u','i','r','e','m','e','n','t','s',' ','\x13','\x02','r','e','q','u','e','s','t','.',
/* 0x08e92 = "Image Verification Failure: Error allocating memory for authenticode signature data." */
    '\xfe','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x08ebf = "The PE loader doesn't know how to deal with the global pointer data directory entry yet." */
    '\x03','P','E',' ','\xc4','\xa5','k','n','o','w',' ','h','o','w',' ','\x08','d','e','a','l',' ','\x1e','\x02','g','l','o','b','a','l',' ','p','o','i','n','t','e','r',' ','\x8f','\x1b','\xb5','y','e','t','.',
/* 0x08eec = "The MMIO handler was called for a bogus address! Internal error!." */
    '\x03','\xf4',' ','h','a','n','d','l','e','r',' ','\x10','c','a','l','l','e','d',' ','\x0e','a',' ','b','o','g','u','s',' ','a','d','d','r','e','s','s','!',' ','\x06','e','r','r','o','r','!','.',
/* 0x08f19 = "Repairing the image is not possible because the corruption is to severe." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x1a','\x09','\x05','p','o','s','s','i','b','l','e',' ','\x1c','\x02','c','o','r','r','u','p','t','i','o','n',' ','\x09','\x08','s','e','v','e','r','e','.',
/* 0x08f46 = "The segment index specified when adding a new segment is already in use." */
    '\x03','s','e','g','m','e','n','t',' ','i','n','d','e','x',' ','\x16','\xef','a','d','d','i','n','g',' ','a',' ','n','e','w',' ','s','e','g','m','e','n','t',' ','\x09','\x22','\x0d','u','s','e','.',
/* 0x08f73 = "RTDirReadEx() failed to retrieve the extra data which was requested." */
    'R','T','D','i','r','R','e','a','d','E','x','(',')',' ','\x88','\x08','r','e','t','r','i','e','v','e',' ','\x02','e','x','t','r','a',' ','\x8f','\xc0','\x10','r','e','q','u','e','s','t','e','d','.',
/* 0x08fa0 = "Negative exponent makes no sense to integer math." */
    'N','e','g','a','t','i','v','e',' ','e','x','p','o','n','e','n','t',' ','m','a','k','e','s',' ','\xe9','s','e','n','s','e',' ','\x08','i','n','t','e','g','e','r',' ','m','a','t','h','.',
/* 0x08fcd = "One or more PAE PDPEs are invalid due to reserved bits being set." */
    'O','n','e',' ','\x86','\xf6','P','A','E',' ','P','D','P','E','s',' ','a','r','e',' ','\x81','d','u','e',' ','\x08','r','e','s','e','r','v','e','d',' ','b','i','t','s',' ','\xdb','s','e','t','.',
/* 0x08ffa = "Unexpected PCI region change during VGA saved state loading." */
    '\x85','P','C','I',' ','r','e','g','i','o','n',' ','c','h','a','n','g','e',' ','d','u','r','i','n','g',' ','V','G','A',' ','s','a','v','e','d',' ','\xb0','l','o','a','d','i','n','g','.',
/* 0x09027 = "Maximum number of Shared Clipboard objects has been reached." */
    'M','a','x','i','m','u','m',' ','\xdd','\x13','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x09054 = "IOMGCIOPortHandler was given an unexpected opcode." */
    'I','O','M','G','C','I','O','P','o','r','t','H','a','n','d','l','e','r',' ','\x10','g','i','v','e','n',' ','\x60','u','n','e','x','p','e','c','t','e','d',' ','o','p','c','o','d','e','.',
/* 0x09081 = "The user mode tracepoint provider string table offset is bad." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xc7','\x9e','o','f','f','s','e','t',' ','\x09','b','a','d','.',
/* 0x090ae = "The server has not found anything matching the URI given." */
    '\x03','s','e','r','v','e','r',' ','\x1d','\x05','f','o','u','n','d',' ','a','n','y','t','h','i','n','g',' ','m','a','t','c','h','i','n','g',' ','\x02','U','R','I',' ','g','i','v','e','n','.',
/* 0x090db = "RTGetOpt: Command line option needs argument." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','a','r','g','u','m','e','n','t','.',
/* 0x09108 = "Somebody cleared X86_CR4_VMXE in the CR4 register." */
    'S','o','m','e','b','o','d','y',' ','c','l','e','a','r','e','d',' ','X','8','6','_','C','R','4','_','V','M','X','E',' ','\x0d','\x02','C','R','4',' ','r','e','g','i','s','t','e','r','.',
/* 0x09135 = "The intercepted operation was not handled, take default action." */
    '\x03','i','n','t','e','r','c','e','p','t','e','d',' ','\x83','\x10','\x05','h','a','n','d','l','e','d',',',' ','t','a','k','e',' ','d','e','f','a','u','l','t',' ','a','c','t','i','o','n','.',
/* 0x09162 = "The EVP_PKEY_CTX_set_rsa_padding API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','C','T','X','_','s','e','t','_','r','s','a','_','p','a','d','d','i','n','g',' ','A','P','I',' ','\x0d','O','p','e','n','S','S','L',' ','\x24',
/* 0x0918e = "Failed to open a virtual network interface instance." */
    '\x80','\x08','o','p','e','n',' ','a',' ','v','i','r','t','u','a','l',' ','n','e','t','w','o','r','k',' ','i','n','t','e','r','f','a','c','e',' ','i','n','s','t','a','n','c','e','.',
/* 0x091ba = "VFS chain element takes a directory (dir) or file system (vfs) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x1b','(','d','i','r',')',' ','\x86','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x091e6 = "Maximum (context ID object) count has been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',' ','o','b','j','e','c','t',')',' ','c','o','u','n','t',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x09212 = "Recording is not possible due to a set restriction." */
    'R','e','c','o','r','d','i','n','g',' ','\x09','\x05','p','o','s','s','i','b','l','e',' ','d','u','e',' ','\x08','a',' ','s','e','t',' ','r','e','s','t','r','i','c','t','i','o','n','.',
/* 0x0923e = "A boot catalog entry in the import ISO has an image with an indeterminate size." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','\x60','\x1a','\x1e','\x60','i','n','d','e','t','e','r','m','i','n','a','t','e',' ','s','i','z','e','.',
/* 0x0926a = "The provided password to decrypt the DEK was incorrect." */
    '\x03','p','r','o','v','i','d','e','d',' ','p','a','s','s','w','o','r','d',' ','\x08','d','e','c','r','y','p','t',' ','\x02','D','E','K',' ','\x10','i','n','c','o','r','r','e','c','t','.',
/* 0x09296 = "The image is required to be signed with the same certificate as the rest of VirtualBox." */
    '\x03','\x1a','\x09','r','e','q','u','i','r','e','d',' ','\x08','\x90','s','i','g','n','e','d',' ','\x1e','\x02','s','a','m','e',' ','\x8a','a','s',' ','\x02','r','e','s','t',' ','\x13','\xe2','B','o','x','.',
/* 0x092c2 = "Process Verification Failure: The memory protection of a image file section does not match what the section header prescribes." */
    '\x17','\x0c','\x12','\x03','\x5c','p','r','o','t','e','c','t','i','o','n',' ','\x13','a',' ','\x1a','\x18','\xc6','\x9c','\x05','\xe3','w','h','a','t',' ','\x02','\xc6','\xa2','p','r','e','s','c','r','i','b','e','s','.',
/* 0x092ee = "SSM did a callback for a pass we didn\'t expect." */
    'S','S','M',' ','d','i','d',' ','a',' ','c','a','l','l','b','a','c','k',' ','\x0e','a',' ','p','a','s','s',' ','w','e',' ','d','i','d','n','\'','t',' ','e','x','p','e','c','t','.',
/* 0x0931a = "The media is not mounted, operation requires a mounted media." */
    '\x03','m','e','d','i','a',' ','\x09','\x05','m','o','u','n','t','e','d',',',' ','\x83','r','e','q','u','i','r','e','s',' ','a',' ','m','o','u','n','t','e','d',' ','m','e','d','i','a','.',
/* 0x09346 = "Failed to fix mappings because of a conflict with the intermediate code." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1c','\x13','a',' ','c','o','n','f','l','i','c','t',' ','\x1e','\x02','i','n','t','e','r','m','e','d','i','a','t','e',' ','\x5e',
/* 0x09372 = "Import ISO contains a root directory with a mismatching volume sequence number." */
    '\xaf','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x1b','\x1e','a',' ','m','i','s','m','a','t','c','h','i','n','g',' ','\xbd','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x0939e = "The nested-guest #VMEXIT processing failed, initiate shutdown." */
    '\x03','n','e','s','t','e','d','-','\xa1','#','V','M','E','X','I','T',' ','\x04','f','a','i','l','e','d',',',' ','i','n','i','t','i','a','t','e',' ','s','h','u','t','d','o','w','n','.',
/* 0x093ca = "Found file, but it didn\'t match the search criteria." */
    'F','o','u','n','d',' ','f','i','l','e',',',' ','b','u','t',' ','i','t',' ','d','i','d','n','\'','t',' ','\xe3','\x02','s','e','a','r','c','h',' ','c','r','i','t','e','r','i','a','.',
/* 0x093f6 = "Server response contains embedded zero character(s)." */
    'S','e','r','v','e','r',' ','r','e','s','p','o','n','s','e',' ','\x7f','e','m','b','e','d','d','e','d',' ','z','e','r','o',' ','c','h','a','r','a','c','t','e','r','(','s',')','.',
/* 0x09422 = "Error while characters translation (unicode and so)." */
    '\xac','w','h','i','l','e',' ','c','h','a','r','a','c','t','e','r','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','(','u','n','i','c','o','d','e',' ','\x2a','s','o',')','.',
/* 0x0944e = "(One) receive buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','r','e','c','e','i','v','e',' ','b','u','f','f','e','r',' ','\x10','\x8c','s','m','a','l','l',',',' ','\x86','\x8c','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x0947a = "Sharing violation, file is being used by another process." */
    'S','h','a','r','i','n','g',' ','v','i','o','l','a','t','i','o','n',',',' ','\x18','\x09','\xdb','u','s','e','d',' ','\xb9','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x094a6 = "Couldn\'t find the USB Proxy device. Using OSE?." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','U','S','B',' ','P','r','o','x','y',' ','d','e','v','i','c','e','.',' ','U','s','i','n','g',' ','O','S','E','?','.',
/* 0x094d2 = "Recording limit (time, size, ...) has been reached." */
    'R','e','c','o','r','d','i','n','g',' ','l','i','m','i','t',' ','(','t','i','m','e',',',' ','s','i','z','e',',',' ','.','.','.',')',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x094fe = "Error creating an event semaphore for used with asynchronous reads." */
    '\xac','c','r','e','a','t','i','n','g',' ','\x60','e','v','e','n','t',' ','\xea','\x0e','u','s','e','d',' ','\x1e','a','s','y','n','c','h','r','o','n','o','u','s',' ','r','e','a','d','s','.',
/* 0x0952a = "A Shared Clipboard objects handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','o','b','j','e','c','t','s',' ','h','a','n','d','l','e',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x09555 = "Invalid effective segment register number passed to an IEM function." */
    '\x0b','e','f','f','e','c','t','i','v','e',' ','s','e','g','m','e','n','t',' ','\xbc','\xdd','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x09580 = "Error extracting a public key from the certificate." */
    '\xac','e','x','t','r','a','c','t','i','n','g',' ','a',' ','p','u','b','l','i','c',' ','k','e','y',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x095ab = "The hash is too long for the key used when signing/verifying." */
    '\x03','h','a','s','h',' ','\x09','\x8c','l','o','n','g',' ','\x0e','\x02','k','e','y',' ','u','s','e','d',' ','\xef','s','i','g','n','i','n','g','/','v','e','r','i','f','y','i','n','g','.',
/* 0x095d6 = "The environment variable has been recorded as being unset." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x1d','\xad','r','e','c','o','r','d','e','d',' ','a','s',' ','\xdb','u','n','s','e','t','.',
/* 0x09601 = "VERR_CR_SPC_IND_DATA_DIGEST_ALGO_NOT_IN_DIGEST_ALGOS" */
    '\x01','\xa9','S','P','C','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','A','L','G','O','_','\x14','I','N','_','D','I','G','E','S','T','_','A','L','G','O','S',
/* 0x0962c = "Mismatching VMCPU structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','V','M','C','P','U',' ','\xc1','\xf8','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x09657 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_SET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','S','E','T','_','T','A','G',' ','\x24',
/* 0x09682 = "EVP_CIPHER_CTX_ctrl EVP_CTRL_AEAD_GET_TAG failed." */
    'E','V','P','_','C','I','P','H','E','R','_','C','T','X','_','c','t','r','l',' ','E','V','P','_','C','T','R','L','_','A','E','A','D','_','G','E','T','_','T','A','G',' ','\x24',
/* 0x096ad = "A string claiming to be in UTF-16 is incorrectly encoded." */
    'A',' ','\xc7','c','l','a','i','m','i','n','g',' ','\x08','\x90','\x0d','U','T','F','-','1','6',' ','\x09','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x096d8 = "Another thread in the session is talking to the tracer." */
    'A','n','o','t','h','e','r',' ','t','h','r','e','a','d',' ','\x0d','\x02','s','e','s','s','i','o','n',' ','\x09','t','a','l','k','i','n','g',' ','\x08','\x02','t','r','a','c','e','r','.',
/* 0x09703 = "RTGetOpt: Command line option needs an index." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','n','e','e','d','s',' ','\x60','i','n','d','e','x','.',
/* 0x0972e = "Authentication failed (ISessionManager::logon())." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','\x88','(','I','S','e','s','s','i','o','n','M','a','n','a','g','e','r',':',':','l','o','g','o','n','(',')',')','.',
/* 0x09759 = "iSCSI: Invalid header, i.e. dummy for validity check." */
    'i','S','C','S','I',':',' ','\x0b','h','e','a','d','e','r',',',' ','i','.','e','.',' ','d','u','m','m','y',' ','\x0e','v','a','l','i','d','i','t','y',' ','c','h','e','c','k','.',
/* 0x09784 = "Someone is trying to skip backwards in the stream..." */
    'S','o','m','e','o','n','e',' ','\x09','t','r','y','i','n','g',' ','\x08','s','k','i','p',' ','b','a','c','k','w','a','r','d','s',' ','\x0d','\x02','s','t','r','e','a','m','.','.','.',
/* 0x097af = "Normalization of ASN.1 time object didn\'t work out." */
    'N','o','r','m','a','l','i','z','a','t','i','o','n',' ','\x13','A','S','N','.','1',' ','t','i','m','e',' ','\x8d','d','i','d','n','\'','t',' ','w','o','r','k',' ','o','u','t','.',
/* 0x097da = "VFS chain element takes a file system stream (fss) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x09805 = "An unexpected (/unknown) exception was caught." */
    'A','n',' ','u','n','e','x','p','e','c','t','e','d',' ','(','/','u','n','k','n','o','w','n',')',' ','e','x','c','e','p','t','i','o','n',' ','\x10','c','a','u','g','h','t','.',
/* 0x09830 = "Ran out of memory while compressing or uncompressing." */
    'R','a','n',' ','o','u','t',' ','\x13','\x5c','w','h','i','l','e',' ','c','o','m','p','r','e','s','s','i','n','g',' ','\x86','u','n','c','o','m','p','r','e','s','s','i','n','g','.',
/* 0x0985b = "A bad trap type ended up in mmGCRamTrap0eHandler." */
    'A',' ','b','a','d',' ','t','r','a','p',' ','\xd9','e','n','d','e','d',' ','u','p',' ','\x0d','m','m','G','C','R','a','m','T','r','a','p','0','e','H','a','n','d','l','e','r','.',
/* 0x09886 = "Unable to locate a usable DMG file within the XAR archive." */
    '\xca','\x08','l','o','c','a','t','e',' ','a',' ','u','s','a','b','l','e',' ','D','M','G',' ','\x18','w','i','t','h','i','n',' ','\x02','X','A','R',' ','a','r','c','h','i','v','e','.',
/* 0x098b1 = "PKCS #7 singer info contains no issuer serial number." */
    'P','K','C','S',' ','#','7',' ','s','i','n','g','e','r',' ','i','n','f','o',' ','\x7f','\xe9','i','s','s','u','e','r',' ','s','e','r','i','a','l',' ','n','u','m','b','e','r','.',
/* 0x098dc = "Essential fields in the shared VM structure doesn't match the global one." */
    'E','s','s','e','n','t','i','a','l',' ','f','i','e','l','d','s',' ','\x0d','\x02','s','h','a','r','e','d',' ','\xcf',' ','\xc1','\xa5','\xe3','\x02','g','l','o','b','a','l',' ','o','n','e','.',
/* 0x09907 = "Maximum number of Shared Clipboard lists has been reached." */
    'M','a','x','i','m','u','m',' ','\xdd','\x13','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t','s',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x09932 = "VFS chain element only provides file system stream (fss) objects." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','\x18','s','y','s','t','e','m',' ','s','t','r','e','a','m',' ','(','f','s','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0995d = "Syntax error - an argument or subargument contains nothing useful." */
    '\xe1','\x07','-',' ','\x60','a','r','g','u','m','e','n','t',' ','\x86','s','u','b','a','r','g','u','m','e','n','t',' ','\x7f','n','o','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x09988 = "The DTB being parsed has an invalid memory reservation block offset." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\x60','\x81','\x5c','r','e','s','e','r','v','a','t','i','o','n',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x099b2 = "RTGetOpt: Command line option not recognized." */
    'R','T','G','e','t','O','p','t',':',' ','C','o','m','m','a','n','d',' ','l','i','n','e',' ','o','p','t','i','o','n',' ','\x05','r','e','c','o','g','n','i','z','e','d','.',
/* 0x099dc = "Process Verification Failure: An image is targeting an unexpected machine/CPU." */
    '\x17','\x0c','\x12','A','n',' ','\x1a','\x09','t','a','r','g','e','t','i','n','g',' ','\x60','u','n','e','x','p','e','c','t','e','d',' ','m','a','c','h','i','n','e','/','C','P','U','.',
/* 0x09a06 = "The ASN.1 encoding is too deeply nested for the decoder." */
    '\x03','A','S','N','.','1',' ','e','n','c','o','d','i','n','g',' ','\x09','\x8c','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','\x0e','\x02','d','e','c','o','d','e','r','.',
/* 0x09a30 = "Command format (or reserved bits) invalid." */
    'C','o','m','m','a','n','d',' ','f','o','r','m','a','t',' ','(','o','r',' ','r','e','s','e','r','v','e','d',' ','b','i','t','s',')',' ','i','n','v','a','l','i','d','.',
/* 0x09a5a = "String is not terminated within the buffer bounds." */
    'S','t','r','i','n','g',' ','\x09','\x05','t','e','r','m','i','n','a','t','e','d',' ','w','i','t','h','i','n',' ','\x02','b','u','f','f','e','r',' ','b','o','u','n','d','s','.',
/* 0x09a84 = "The EMT was not busy running guest code at the time of the call." */
    '\x03','E','M','T',' ','\x10','\x05','b','u','s','y',' ','r','u','n','n','i','n','g',' ','\xa1','c','o','d','e',' ','a','t',' ','\x02','t','i','m','e',' ','\x13','\x02','c','a','l','l','.',
/* 0x09aae = "The process trying to open VBoxDrv is not a budding VM process (1)." */
    '\x03','\x82','t','r','y','i','n','g',' ','\x08','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x09','\x05','a',' ','b','u','d','d','i','n','g',' ','\xcf',' ','\x82','(','1',')','.',
/* 0x09ad8 = "No pending request the aio context has to wait for completion." */
    '\xd0','p','e','n','d','i','n','g',' ','\x94','\x02','a','i','o',' ','c','o','n','t','e','x','t',' ','\x1d','\x08','w','a','i','t',' ','\x0e','c','o','m','p','l','e','t','i','o','n','.',
/* 0x09b02 = "OpenSSL and IPRT disagree on the signature size." */
    'O','p','e','n','S','S','L',' ','\x2a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e',' ','s','i','z','e','.',
/* 0x09b2c = "VERR_CR_X509_TBSCERT_SERIAL_NUMBER_OUT_OF_BOUNDS" */
    '\x01','\xa9','X','5','0','9','_','T','B','S','C','E','R','T','_','S','E','R','I','A','L','_','N','U','M','B','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x09b56 = "Not all of the requested CPUs showed up in the PFNRTMPWORKER." */
    'N','o','t',' ','a','l','l',' ','\x13','\x02','\xbf','C','P','U','s',' ','s','h','o','w','e','d',' ','u','p',' ','\x0d','\x02','P','F','N','R','T','M','P','W','O','R','K','E','R','.',
/* 0x09b80 = "Service will execute the command in background." */
    'S','e','r','v','i','c','e',' ','w','i','l','l',' ','e','x','e','c','u','t','e',' ','\x02','c','o','m','m','a','n','d',' ','\x0d','b','a','c','k','g','r','o','u','n','d','.',
/* 0x09baa = "The argv[0] of an internal application does not match the executable image path (hardening)." */
    '\x03','a','r','g','v','[','0',']',' ','\x13','\x60','\x15','a','p','p','l','i','c','a','t','i','o','n',' ','\x9c','\x05','\xe3','\x02','e','x','e','c','u','t','a','b','l','e',' ','\x1a','\xbb','\x9a',
/* 0x09bd4 = "The chosen baudrate is invalid or not supported by the given serial port." */
    '\x03','c','h','o','s','e','n',' ','b','a','u','d','r','a','t','e',' ','\x09','\x81','\x86','\x05','\xf9','\xb9','\x02','g','i','v','e','n',' ','s','e','r','i','a','l',' ','p','o','r','t','.',
/* 0x09bfe = "Do not know how to handle the content type in the server response." */
    'D','o',' ','\x05','k','n','o','w',' ','h','o','w',' ','\x08','h','a','n','d','l','e',' ','\x02','\xd8','\xd9','\x0d','\x02','s','e','r','v','e','r',' ','r','e','s','p','o','n','s','e','.',
/* 0x09c28 = "GVMM does not support the range of CPUs present/possible on the host." */
    'G','V','M','M',' ','\x9c','\x05','\xb1','\x02','\xe4','\x13','C','P','U','s',' ','p','r','e','s','e','n','t','/','p','o','s','s','i','b','l','e',' ','o','n',' ','\x02','h','o','s','t','.',
/* 0x09c52 = "The DTB property name offset points past the string block." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','\xf3','o','f','f','s','e','t',' ','p','o','i','n','t','s',' ','p','a','s','t',' ','\x02','\xc7','b','l','o','c','k','.',
/* 0x09c7c = "Not a uniform standard tape v0.0 archive header." */
    'N','o','t',' ','a',' ','u','n','i','f','o','r','m',' ','s','t','a','n','d','a','r','d',' ','t','a','p','e',' ','v','0','.','0',' ','a','r','c','h','i','v','e',' ','\xe7',
/* 0x09ca6 = "Process Verification Failure: Error allocating state memory or querying the system32 path." */
    '\x17','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\xb0','\x5c','\x86','q','u','e','r','y','i','n','g',' ','\x02','s','y','s','t','e','m','3','2',' ','p','a','t','h','.',
/* 0x09cd0 = "Indicating that the VM is being terminated and that the execution shall stop." */
    '\xfa','\x89','\x02','\xcf',' ','\x09','\xdb','t','e','r','m','i','n','a','t','e','d',' ','\x2a','\x89','\x02','e','x','e','c','u','t','i','o','n',' ','s','h','a','l','l',' ','s','t','o','p','.',
/* 0x09cfa = "The ELF loader didn\'t find the symbol/string table for the image." */
    '\x03','E','L','F',' ','\xc4','d','i','d','n','\'','t',' ','f','i','n','d',' ','\x02','s','y','m','b','o','l','/','s','t','r','i','n','g',' ','\x9e','\x0e','\x02','i','m','a','g','e','.',
/* 0x09d24 = "The Mach-O header is bad or contains new and unsupported features." */
    '\x03','M','a','c','h','-','O',' ','\xa2','\x09','b','a','d',' ','\x86','\x7f','n','e','w',' ','\x2a','u','n','s','u','p','p','o','r','t','e','d',' ','f','e','a','t','u','r','e','s','.',
/* 0x09d4e = "Recompiler: Failed to reconcile the register/variable state on endif." */
    '\x11','\x80','\x08','r','e','c','o','n','c','i','l','e',' ','\x02','r','e','g','i','s','t','e','r','/','v','a','r','i','a','b','l','e',' ','\xb0','o','n',' ','e','n','d','i','f','.',
/* 0x09d78 = "No line number was found for the specified address/ordinal/whatever." */
    '\xd0','l','i','n','e',' ','\xdd','\x10','f','o','u','n','d',' ','\x0e','\x02','\x16','a','d','d','r','e','s','s','/','o','r','d','i','n','a','l','/','w','h','a','t','e','v','e','r','.',
/* 0x09da2 = "File set descriptor has an zero length or invalid root dir extent." */
    'F','i','l','e',' ','s','e','t',' ','\xd6','\x1d','\x60','z','e','r','o',' ','l','e','n','g','t','h',' ','\x86','\x81','r','o','o','t',' ','d','i','r',' ','e','x','t','e','n','t','.',
/* 0x09dcc = "Recompiled execution: Jump back in the same TB." */
    'R','e','c','o','m','p','i','l','e','d',' ','e','x','e','c','u','t','i','o','n',':',' ','J','u','m','p',' ','b','a','c','k',' ','\x0d','\x02','s','a','m','e',' ','T','B','.',
/* 0x09df6 = "Constructed string is not according to the encoding rules." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xc7','\x09','\x05','a','c','c','o','r','d','i','n','g',' ','\x08','\x02','e','n','c','o','d','i','n','g',' ','r','u','l','e','s','.',
/* 0x09e20 = "NEM is missing a require feature in the host API." */
    'N','E','M',' ','\x09','m','i','s','s','i','n','g',' ','a',' ','r','e','q','u','i','r','e',' ','f','e','a','t','u','r','e',' ','\x0d','\x02','h','o','s','t',' ','A','P','I','.',
/* 0x09e4a = "Missing relative distinguished name map entry." */
    'M','i','s','s','i','n','g',' ','r','e','l','a','t','i','v','e',' ','d','i','s','t','i','n','g','u','i','s','h','e','d',' ','\xf3','m','a','p',' ','e','n','t','r','y','.',
/* 0x09e74 = "Indicating that the VM has been resumed and that the thread should start executing." */
    '\xfa','\x89','\x02','\xcf',' ','\x1d','\xad','r','e','s','u','m','e','d',' ','\x2a','\x89','\x02','t','h','r','e','a','d',' ','\xec','s','t','a','r','t',' ','e','x','e','c','u','t','i','n','g','.',
/* 0x09e9e = "The table of content (TOC) is too small and therefore can\'t be valid." */
    '\x03','\x9e','\x13','\xd8','(','T','O','C',')',' ','\x09','\x8c','s','m','a','l','l',' ','\x2a','t','h','e','r','e','f','o','r','e',' ','c','a','n','\'','t',' ','\x90','v','a','l','i','d','.',
/* 0x09ec8 = "The process trying to open VBoxDrv is not a budding VM process (2)." */
    '\x03','\x82','t','r','y','i','n','g',' ','\x08','o','p','e','n',' ','V','B','o','x','D','r','v',' ','\x09','\x05','a',' ','b','u','d','d','i','n','g',' ','\xcf',' ','\x82','(','2',')','.',
/* 0x09ef2 = "The PE loader encountered an unknown load config directory/header size." */
    '\x03','P','E',' ','\xc4','\x98','\x60','\xfc','l','o','a','d',' ','c','o','n','f','i','g',' ','d','i','r','e','c','t','o','r','y','/','h','e','a','d','e','r',' ','s','i','z','e','.',
/* 0x09f1c = "The specified environment variable was not found. (RTEnvUnsetEx)." */
    '\x03','\x16','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x10','\x05','\x7d',' ','(','R','T','E','n','v','U','n','s','e','t','E','x',')','.',
/* 0x09f46 = "Unable to find partition descriptor for a partition map table entry." */
    '\xca','\x08','f','i','n','d',' ','p','a','r','t','i','t','i','o','n',' ','\xd6','\x0e','a',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\x9e','e','n','t','r','y','.',
/* 0x09f70 = "The server did not understand the request due to bad syntax." */
    '\x03','s','e','r','v','e','r',' ','d','i','d',' ','\x05','u','n','d','e','r','s','t','a','n','d',' ','\x02','\x94','d','u','e',' ','\x08','b','a','d',' ','s','y','n','t','a','x','.',
/* 0x09f9a = "No digest algorithms listed in PKCS #7 signed data." */
    '\xd0','\xc2','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d',' ','\x0d','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x09fc3 = "The GIM provider does not support any paravirtualized TSC." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x9c','\x05','\xb1','a','n','y',' ','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x09fec = "VERR_FDT_DTB_STRUCTS_BLOCK_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','S','T','R','I','N','G','_','\x14','T','E','R','M','I','N','A','T','E','D',
/* 0x0a015 = "Malformed extended allocation descriptor." */
    'M','a','l','f','o','r','m','e','d',' ','e','x','t','e','n','d','e','d',' ','a','l','l','o','c','a','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0a03e = "A string claiming to be UTF-8 is incorrectly encoded." */
    'A',' ','\xc7','c','l','a','i','m','i','n','g',' ','\x08','\x90','U','T','F','-','8',' ','\x09','i','n','c','o','r','r','e','c','t','l','y',' ','e','n','c','o','d','e','d','.',
/* 0x0a067 = "The request wasn\'t submitted so it can\'t be canceled." */
    '\x03','\x94','w','a','s','n','\'','t',' ','s','u','b','m','i','t','t','e','d',' ','s','o',' ','i','t',' ','c','a','n','\'','t',' ','\x90','c','a','n','c','e','l','e','d','.',
/* 0x0a090 = "VERR_LDRVI_EXPECTED_INDIRECT_DATA_CONTENT_OID" */
    '\x01','L','D','R','V','I','_','E','X','P','E','C','T','E','D','_','I','N','D','I','R','E','C','T','_','D','A','T','A','_','C','O','N','T','E','N','T','_','O','I','D',
/* 0x0a0b9 = "The timer was in a unknown state. Corruption or stupid coding error." */
    '\x03','t','i','m','e','r',' ','\x10','\x0d','a',' ','\xfc','\xf5',' ','C','o','r','r','u','p','t','i','o','n',' ','\x86','s','t','u','p','i','d',' ','c','o','d','i','n','g',' ','\x7b',
/* 0x0a0e2 = "A numeric conversion encountered a value which was too big for the target." */
    'A',' ','n','u','m','e','r','i','c',' ','c','o','n','v','e','r','s','i','o','n',' ','\x98','a',' ','\xd2','\xc0','\x10','\x8c','b','i','g',' ','\x0e','\x02','t','a','r','g','e','t','.',
/* 0x0a10b = "The attached driver configuration is missing the \'Driver\' attribute." */
    '\x03','a','t','t','a','c','h','e','d',' ','\xa8','\xe8','\x09','m','i','s','s','i','n','g',' ','\x02','\'','D','r','i','v','e','r','\'',' ','a','t','t','r','i','b','u','t','e','.',
/* 0x0a134 = "VFS chain element takes a file or I/O stream (ios) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','\x86','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x0a15d = "The DTB structs block contains an unterminated string." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','\x60','u','n','t','e','r','m','i','n','a','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x0a186 = "Process Verification Failure: One of the section in the image file is not fully mapped into memory." */
    '\x17','\x0c','\x12','O','n','e',' ','\x13','\x02','\xc6','\x0d','\x02','\x1a','\x18','\x09','\x05','f','u','l','l','y',' ','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0a1af = "Key algorithm parameters are required but missing." */
    'K','e','y',' ','\xbe','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','r','e','q','u','i','r','e','d',' ','b','u','t',' ','m','i','s','s','i','n','g','.',
/* 0x0a1d8 = "The I/O queue is full and can\'t accept more requests." */
    '\x03','I','/','O',' ','q','u','e','u','e',' ','\x09','f','u','l','l',' ','\x2a','c','a','n','\'','t',' ','a','c','c','e','p','t',' ','\xf6','r','e','q','u','e','s','t','s','.',
/* 0x0a201 = "Reason for leaving RC: CSAM wants perform a task in ring-3." */
    '\x84','\x0e','\x25','R','C',':',' ','C','S','A','M',' ','w','a','n','t','s',' ','p','e','r','f','o','r','m',' ','a',' ','t','a','s','k',' ','\x0d','r','i','n','g','-','3','.',
/* 0x0a22a = "(One) send buffer was too small, or too few buffers." */
    '(','O','n','e',')',' ','s','e','n','d',' ','b','u','f','f','e','r',' ','\x10','\x8c','s','m','a','l','l',',',' ','\x86','\x8c','f','e','w',' ','b','u','f','f','e','r','s','.',
/* 0x0a253 = "The user mode tracepoint provider string table is too large." */
    '\x03','u','s','e','r',' ','m','o','d','e',' ','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\xc7','\x9e','\x09','\x8c','l','a','r','g','e','.',
/* 0x0a27c = "An attempt was made to grow an already maxed out page pool." */
    'A','n',' ','a','t','t','e','m','p','t',' ','\x10','m','a','d','e',' ','\x08','g','r','o','w',' ','\x60','\x22','m','a','x','e','d',' ','o','u','t',' ','\xb6','p','o','o','l','.',
/* 0x0a2a5 = "VMPTRLD failed; possibly because of invalid VMCS launch-state." */
    'V','M','P','T','R','L','D',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x1c','\x13','\x81','V','M','C','S',' ','l','a','u','n','c','h','-','\xf5',
/* 0x0a2ce = "The page to be updated or freed was noted owned by the caller." */
    '\x03','\xb6','\x08','\x90','u','p','d','a','t','e','d',' ','\x86','f','r','e','e','d',' ','\x10','n','o','t','e','d',' ','o','w','n','e','d',' ','\xb9','\x02','c','a','l','l','e','r','.',
/* 0x0a2f7 = "Unexpected instruction encountered for which there is no patch strategy implemented (hardening)." */
    '\x85','\xba','\x98','\x0e','\xc0','t','h','e','r','e',' ','\x09','\xe9','p','a','t','c','h',' ','s','t','r','a','t','e','g','y',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x9a',
/* 0x0a320 = "Import ISO contains an unsupported supplementary volume descriptor version." */
    '\xaf','\xb2',' ','\x7f','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbd','\xd6','v','e','r','s','i','o','n','.',
/* 0x0a349 = "The RAM size differs between the saved state and the VM config." */
    '\x03','R','A','M',' ','\xf8','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','\x02','s','a','v','e','d',' ','\xb0','\x2a','\x02','\xcf',' ','c','o','n','f','i','g','.',
/* 0x0a372 = "Get register caller must flush the TLB (not an error)." */
    'G','e','t',' ','\xbc','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B',' ','(','n','o','t',' ','\x60','e','r','r','o','r',')','.',
/* 0x0a39b = "VERR_FDT_DTB_MEM_RSV_BLOCK_TERMINATOR_MISSING" */
    '\x01','F','D','T','_','D','T','B','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','T','E','R','M','I','N','A','T','O','R','_','M','I','S','S','I','N','G',
/* 0x0a3c4 = "A boot catalog entry in the import ISO is using the unused field." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x09','u','s','i','n','g',' ','\x02','u','n','u','s','e','d',' ','f','i','e','l','d','.',
/* 0x0a3ed = "The CSAM is not used because we\'re using HM and VT-x/AMD-V." */
    '\x03','C','S','A','M',' ','\x09','\x05','u','s','e','d',' ','\x1c','w','e','\'','r','e',' ','u','s','i','n','g',' ','H','M',' ','\x2a','V','T','-','x','/','A','M','D','-','V','.',
/* 0x0a416 = "VFS chain element only provides file and I/O stream (ios) objects." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','\x18','\x2a','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0a43f = "Node pointer is not within the memory allocated for nodes." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x09','\x05','w','i','t','h','i','n',' ','\x02','\x5c','a','l','l','o','c','a','t','e','d',' ','\x0e','n','o','d','e','s','.',
/* 0x0a468 = "The Host Interface Networking init program failed." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','i','n','i','t',' ','p','r','o','g','r','a','m',' ','\x24',
/* 0x0a491 = "Something is not available or not working properly." */
    'S','o','m','e','t','h','i','n','g',' ','\x09','\x05','a','v','a','i','l','a','b','l','e',' ','\x86','\x05','w','o','r','k','i','n','g',' ','p','r','o','p','e','r','l','y','.',
/* 0x0a4ba = "PKIX cipher algorithm parameters are not implemented." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbe','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0a4e3 = "Return to ring-3 to perform the hypercall there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','p','e','r','f','o','r','m',' ','\x02','h','y','p','e','r','c','a','l','l',' ','t','h','e','r','e','.',
/* 0x0a50c = "Certificate cannot be authenticated with the given CA certificates." */
    '\xa7','\xcb','\x90','a','u','t','h','e','n','t','i','c','a','t','e','d',' ','\x1e','\x02','g','i','v','e','n',' ','C','A',' ','c','e','r','t','i','f','i','c','a','t','e','s','.',
/* 0x0a535 = "Expected PKCS #7 object to ship at least one certificate." */
    '\xa6','P','K','C','S',' ','#','7',' ','\x8d','\x08','s','h','i','p',' ','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0a55e = "Too many readers on read/write critical section." */
    '\xf0','\xa3','r','e','a','d','e','r','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0a587 = "The segment bits are non-contiguous in the file." */
    '\x03','s','e','g','m','e','n','t',' ','b','i','t','s',' ','a','r','e',' ','n','o','n','-','c','o','n','t','i','g','u','o','u','s',' ','\x0d','\x02','f','i','l','e','.',
/* 0x0a5af = "Raw-mode is unavailable courtesy of Hyper-V." */
    'R','a','w','-','m','o','d','e',' ','\x09','u','n','a','v','a','i','l','a','b','l','e',' ','c','o','u','r','t','e','s','y',' ','\x13','H','y','p','e','r','-','V','.',
/* 0x0a5d7 = "Too many writes on read/write critical section." */
    '\xf0','\xa3','w','r','i','t','e','s',' ','o','n',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0a5ff = "VERR_FDT_DTB_HDR_LAST_COMPAT_VERSION_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','L','A','S','T','_','C','O','M','P','A','T','_','V','E','R','S','I','O','N','_','I','N','V','A','L','I','D',
/* 0x0a627 = "Maximum (context ID) sessions have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','s','e','s','s','i','o','n','s',' ','\xeb','\xad','r','e','a','c','h','e','d','.',
/* 0x0a64f = "The specified environment variable was not found. (RTEnvGetEx)." */
    '\x03','\x16','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x10','\x05','\x7d',' ','(','R','T','E','n','v','G','e','t','E','x',')','.',
/* 0x0a677 = "PGM pool flush pending - return to ring 3." */
    'P','G','M',' ','p','o','o','l',' ','f','l','u','s','h',' ','p','e','n','d','i','n','g',' ','-',' ','r','e','t','u','r','n',' ','\x08','r','i','n','g',' ','3','.',
/* 0x0a69f = "The internal application does not reside in the correct place (hardening)." */
    '\x03','\x15','a','p','p','l','i','c','a','t','i','o','n',' ','\x9c','\x05','r','e','s','i','d','e',' ','\x0d','\x02','c','o','r','r','e','c','t',' ','p','l','a','c','e',' ','\x9a',
/* 0x0a6c7 = "Invalid VMCS pointer passed to VMLAUNCH/VMRESUME." */
    '\x0b','V','M','C','S',' ','p','o','i','n','t','e','r',' ','p','a','s','s','e','d',' ','\x08','V','M','L','A','U','N','C','H','/','V','M','R','E','S','U','M','E','.',
/* 0x0a6ef = "A Shared Clipboard list handle is invalid." */
    'A',' ','S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','l','i','s','t',' ','h','a','n','d','l','e',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x0a717 = "Image Verification Failure: Error reading authenticode signature data." */
    '\xfe','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','a','u','t','h','e','n','t','i','c','o','d','e',' ','s','i','g','n','a','t','u','r','e',' ','d','a','t','a','.',
/* 0x0a73f = "Level 2 lookup failed because the L2 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x88','\x1c','\x02','L','2',' ','l','o','o','k','u','p',' ','\x9e','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0a767 = "The message digest of the extracted data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xc2','\x13','\x02','e','x','t','r','a','c','t','e','d',' ','\x8f','\x9c','\x05','\xe3','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0a78f = "The digest algorithm in the SignerInfo does not match the one in the indirect data." */
    '\x03','\xc2','\xbe','\x0d','\x02','S','i','g','n','e','r','I','n','f','o',' ','\x9c','\x05','\xe3','\x02','o','n','e',' ','\x0d','\x02','i','n','d','i','r','e','c','t',' ','d','a','t','a','.',
/* 0x0a7b7 = "Failed to fix mappings because the proposed memory area was to small." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1c','\x02','p','r','o','p','o','s','e','d',' ','\x5c','a','r','e','a',' ','\x10','\x08','s','m','a','l','l','.',
/* 0x0a7df = "The PE loader encountered some Guard CF stuff in the load config." */
    '\x03','P','E',' ','\xc4','\x98','s','o','m','e',' ','G','u','a','r','d',' ','C','F',' ','s','t','u','f','f',' ','\x0d','\x02','l','o','a','d',' ','c','o','n','f','i','g','.',
/* 0x0a807 = "The OS does not support changing the owner of a symbolic link." */
    '\x03','O','S',' ','\x9c','\x05','\xb1','c','h','a','n','g','i','n','g',' ','\x02','o','w','n','e','r',' ','\x13','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0a82f = "The called method does not work with the value type of the given JSON value." */
    '\x03','c','a','l','l','e','d',' ','m','e','t','h','o','d',' ','\x9c','\x05','w','o','r','k',' ','\x1e','\x02','\xd2','\xd9','\x13','\x02','g','i','v','e','n',' ','J','S','O','N',' ','\xd3',
/* 0x0a857 = "Restart the current instruction. For testing only." */
    'R','e','s','t','a','r','t',' ','\x02','\xd1','i','n','s','t','r','u','c','t','i','o','n','.',' ','F','o','r',' ','t','e','s','t','i','n','g',' ','o','n','l','y','.',
/* 0x0a87f = "Both debug and non-debug sections in segment." */
    'B','o','t','h',' ','d','e','b','u','g',' ','\x2a','n','o','n','-','d','e','b','u','g',' ','s','e','c','t','i','o','n','s',' ','\x0d','s','e','g','m','e','n','t','.',
/* 0x0a8a7 = "Cannot resolve symbol because it\'s a forwarder." */
    'C','a','n','n','o','t',' ','r','e','s','o','l','v','e',' ','s','y','m','b','o','l',' ','\x1c','i','t','\'','s',' ','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x0a8cf = "VERR_FDT_DTB_STRUCTS_BLOCK_NODE_NAME_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','N','O','D','E','_','N','A','M','E','_','I','N','V','A','L','I','D',
/* 0x0a8f7 = "Recompiler: Wrong jump instruction targeting label at end of TB." */
    '\x11','W','r','o','n','g',' ','j','u','m','p',' ','\xba','t','a','r','g','e','t','i','n','g',' ','l','a','b','e','l',' ','a','t',' ','e','n','d',' ','\x13','T','B','.',
/* 0x0a91f = "Tried to resume a VM or CPU that is already fully running." */
    'T','r','i','e','d',' ','\x08','r','e','s','u','m','e',' ','a',' ','\xcf',' ','\x86','C','P','U',' ','\x89','\x09','\x22','f','u','l','l','y',' ','r','u','n','n','i','n','g','.',
/* 0x0a947 = "The path of a new node contained slashes or was empty." */
    '\x03','\xbb','\x13','a',' ','n','e','w',' ','n','o','d','e',' ','c','o','n','t','a','i','n','e','d',' ','s','l','a','s','h','e','s',' ','\x86','\x10','e','m','p','t','y','.',
/* 0x0a96f = "VERR_FDT_DTB_STRUCTS_BLOCK_MALFORMED_PADDING" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','M','A','L','F','O','R','M','E','D','_','P','A','D','D','I','N','G',
/* 0x0a997 = "VERR_SUP_VP_NOT_SIGNED_WITH_SPECIALLY_TRUSTED_CERT" */
    '\x01','\xe6','V','P','_','\x14','S','I','G','N','E','D','_','W','I','T','H','_','S','P','E','C','I','A','L','L','Y','_','T','R','U','S','T','E','D','_','C','E','R','T',
/* 0x0a9bf = "Import ISO uses a logical block size other than 2KB." */
    '\xaf','\xb2',' ','u','s','e','s',' ','a',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','\xf8','o','t','h','e','r',' ','t','h','a','n',' ','2','K','B','.',
/* 0x0a9e7 = "VMXON failed; possibly because it was already run before." */
    'V','M','X','O','N',' ','f','a','i','l','e','d',';',' ','p','o','s','s','i','b','l','y',' ','\x1c','i','t',' ','\x10','\x22','r','u','n',' ','b','e','f','o','r','e','.',
/* 0x0aa0f = "Missing ciper parameters for encrypted key." */
    'M','i','s','s','i','n','g',' ','c','i','p','e','r',' ','p','a','r','a','m','e','t','e','r','s',' ','\x0e','e','n','c','r','y','p','t','e','d',' ','k','e','y','.',
/* 0x0aa37 = "Optional header magic and target machine does not match." */
    'O','p','t','i','o','n','a','l',' ','\xa2','m','a','g','i','c',' ','\x2a','t','a','r','g','e','t',' ','m','a','c','h','i','n','e',' ','\x9c','\x05','m','a','t','c','h','.',
/* 0x0aa5f = "The number being converted (string) contained no digits." */
    '\x03','\xdd','\xdb','c','o','n','v','e','r','t','e','d',' ','(','s','t','r','i','n','g',')',' ','c','o','n','t','a','i','n','e','d',' ','\xe9','d','i','g','i','t','s','.',
/* 0x0aa87 = "Couldn\'t find any USB hubs to attach the device to." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','a','n','y',' ','U','S','B',' ','h','u','b','s',' ','\x08','a','t','t','a','c','h',' ','\x02','\x8b','t','o','.',
/* 0x0aaaf = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_WITH_NONE" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','W','I','T','H','_','N','O','N','E',
/* 0x0aad7 = "Level 2 lookup failed because the L1 lookup table is corrupted." */
    'L','e','v','e','l',' ','2',' ','l','o','o','k','u','p',' ','\x88','\x1c','\x02','L','1',' ','l','o','o','k','u','p',' ','\x9e','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0aaff = "The DTB property payload size does not match the expectations." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xf8','\x9c','\x05','\xe3','\x02','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0ab27 = "The requested operation cannot be performed on a detached USB device." */
    '\x03','\xbf','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d',' ','o','n',' ','a',' ','d','e','t','a','c','h','e','d',' ','U','S','B',' ','d','e','v','i','c','e','.',
/* 0x0ab4f = "A guest control object has changed its overall status." */
    'A',' ','\xa1','c','o','n','t','r','o','l',' ','\x8d','\x1d','c','h','a','n','g','e','d',' ','i','t','s',' ','o','v','e','r','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x0ab77 = "VFS chain element only provides I/O stream (ios) objects." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','I','/','O',' ','s','t','r','e','a','m',' ','(','i','o','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0ab9e = "Internal error in the lock validator or related components." */
    '\x06','\x07','\x0d','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','\x86','r','e','l','a','t','e','d',' ','c','o','m','p','o','n','e','n','t','s','.',
/* 0x0abc5 = "A boot catalog entry in the import ISO has reserved flag set." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','r','e','s','e','r','v','e','d',' ','f','l','a','g',' ','s','e','t','.',
/* 0x0abec = "Maximum (context ID) objects have been reached." */
    'M','a','x','i','m','u','m',' ','(','c','o','n','t','e','x','t',' ','I','D',')',' ','o','b','j','e','c','t','s',' ','\xeb','\xad','r','e','a','c','h','e','d','.',
/* 0x0ac13 = "The timer can\'t be stopped because it\'s already suspended." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\x90','s','t','o','p','p','e','d',' ','\x1c','i','t','\'','s',' ','\x22','s','u','s','p','e','n','d','e','d','.',
/* 0x0ac3a = "Too many partition maps in the logical volume descriptor." */
    '\xf0','\xa3','p','a','r','t','i','t','i','o','n',' ','m','a','p','s',' ','\x0d','\x02','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0ac61 = "VERR_VMMDEV_CPU_HOTPLUG_NOT_MONITORED_BY_GUEST" */
    '\x01','V','M','M','D','E','V','_','C','P','U','_','H','O','T','P','L','U','G','_','\x14','M','O','N','I','T','O','R','E','D','_','B','Y','_','G','U','E','S','T',
/* 0x0ac88 = "Import ISO contains a \'.\' or \'..\' directory record with a bad name length." */
    '\xaf','\xb2',' ','\x7f','a',' ','\'','.','\'',' ','\x86','\'','.','.','\'',' ','\x1b','r','e','c','o','r','d',' ','\x1e','a',' ','b','a','d',' ','\xf3','l','e','n','g','t','h','.',
/* 0x0acaf = "Only one PCI function is supported per PDM device." */
    'O','n','l','y',' ','o','n','e',' ','P','C','I',' ','f','u','n','c','t','i','o','n',' ','\x09','\xf9','p','e','r',' ','P','D','M',' ','d','e','v','i','c','e','.',
/* 0x0acd6 = "The message digest of the archived data does not match the one supplied." */
    '\x03','m','e','s','s','a','g','e',' ','\xc2','\x13','\x02','a','r','c','h','i','v','e','d',' ','\x8f','\x9c','\x05','\xe3','\x02','o','n','e',' ','s','u','p','p','l','i','e','d','.',
/* 0x0acfd = "The default boot catalog entry in the import ISO has invalid flags set." */
    '\x03','d','e','f','a','u','l','t',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','\x81','f','l','a','g','s',' ','s','e','t','.',
/* 0x0ad24 = "Expected PKCS #7 object to ship the signer certificate(s)." */
    '\xa6','P','K','C','S',' ','#','7',' ','\x8d','\x08','s','h','i','p',' ','\x02','s','i','g','n','e','r',' ','c','e','r','t','i','f','i','c','a','t','e','(','s',')','.',
/* 0x0ad4b = "Mismatching VM structure size between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xcf',' ','\xc1','\xf8','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x0ad72 = "Process Verification Failure: Expected the process and exe to advertise NX compatibility." */
    '\x17','\x0c','\x12','\xa6','\x02','\x82','\x2a','e','x','e',' ','\x08','a','d','v','e','r','t','i','s','e',' ','N','X',' ','c','o','m','p','a','t','i','b','i','l','i','t','y','.',
/* 0x0ad99 = "Unique issuer and subject IDs require version certificate 2." */
    'U','n','i','q','u','e',' ','i','s','s','u','e','r',' ','\x2a','s','u','b','j','e','c','t',' ','I','D','s',' ','r','e','q','u','i','r','e',' ','\xb4','\x8a','2','.',
/* 0x0adc0 = "Mismatching VM structure version between VMMR0 and VBoxVMM." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','\xcf',' ','\xc1','\xb4','b','e','t','w','e','e','n',' ','V','M','M','R','0',' ','\x2a','V','B','o','x','V','M','M','.',
/* 0x0ade7 = "AMD-V CPU extension disabled (by BIOS)." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','d','i','s','a','b','l','e','d',' ','(','b','y',' ','B','I','O','S',')','.',
/* 0x0ae0e = "The requested operation cannot be performed because the device is currently suspended." */
    '\x03','\xbf','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d',' ','\x1c','\x02','\x8b','\x09','c','u','r','r','e','n','t','l','y',' ','s','u','s','p','e','n','d','e','d','.',
/* 0x0ae35 = "A PDMThread API was called by the wrong thread." */
    'A',' ','P','D','M','T','h','r','e','a','d',' ','A','P','I',' ','\x10','c','a','l','l','e','d',' ','\xb9','\x02','w','r','o','n','g',' ','t','h','r','e','a','d','.',
/* 0x0ae5c = "The value is not a zero terminated character string." */
    '\x03','\xd2','\x09','\x05','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','c','h','a','r','a','c','t','e','r',' ','s','t','r','i','n','g','.',
/* 0x0ae83 = "A boot catalog entry in the import ISO has an invalid boot media type." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','\x60','\x81','b','o','o','t',' ','m','e','d','i','a',' ','t','y','p','e','.',
/* 0x0aeaa = "The async completion template is still used." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','e','m','p','l','a','t','e',' ','\x09','s','t','i','l','l',' ','u','s','e','d','.',
/* 0x0aed1 = "Failed to retrieve underlying (lower mac) link." */
    '\x80','\x08','r','e','t','r','i','e','v','e',' ','u','n','d','e','r','l','y','i','n','g',' ','(','l','o','w','e','r',' ','m','a','c',')',' ','l','i','n','k','.',
/* 0x0aef8 = "VMX CPU extension not available in hardware." */
    'V','M','X',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x05','a','v','a','i','l','a','b','l','e',' ','\x0d','h','a','r','d','w','a','r','e','.',
/* 0x0af1f = "Signed data verification failed because there are zero signer infos." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','\x1c','t','h','e','r','e',' ','a','r','e',' ','z','e','r','o',' ','s','i','g','n','e','r',' ','i','n','f','o','s','.',
/* 0x0af46 = "Return instigated by a callback or similar." */
    'R','e','t','u','r','n',' ','i','n','s','t','i','g','a','t','e','d',' ','\xb9','a',' ','c','a','l','l','b','a','c','k',' ','\x86','s','i','m','i','l','a','r','.',
/* 0x0af6d = "Operation can\'t be done in current HDD container state." */
    'O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x90','d','o','n','e',' ','\x0d','\xd1','H','D','D',' ','c','o','n','t','a','i','n','e','r',' ','\xf5',
/* 0x0af94 = "Indefinite length form is against the rules." */
    'I','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','f','o','r','m',' ','\x09','a','g','a','i','n','s','t',' ','\x02','r','u','l','e','s','.',
/* 0x0afbb = "Misaligned read/write critical section." */
    'M','i','s','a','l','i','g','n','e','d',' ','r','e','a','d','/','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0afe2 = "Pending exception; continue guest execution." */
    'P','e','n','d','i','n','g',' ','e','x','c','e','p','t','i','o','n',';',' ','c','o','n','t','i','n','u','e',' ','\xa1','e','x','e','c','u','t','i','o','n','.',
/* 0x0b009 = "Too many arguments passed to a VM request / request corruption." */
    '\xf0','\xa3','a','r','g','u','m','e','n','t','s',' ','p','a','s','s','e','d',' ','\x08','a',' ','\xcf',' ','\x94','/',' ','\x94','c','o','r','r','u','p','t','i','o','n','.',
/* 0x0b030 = "A numeric tar header field was not terminated correctly." */
    'A',' ','n','u','m','e','r','i','c',' ','t','a','r',' ','\xa2','\xff','\x10','\x05','t','e','r','m','i','n','a','t','e','d',' ','c','o','r','r','e','c','t','l','y','.',
/* 0x0b057 = "Reason for leaving RC: pending irq after iret that sets IF." */
    '\x84','\x0e','\x25','R','C',':',' ','p','e','n','d','i','n','g',' ','i','r','q',' ','a','f','t','e','r',' ','i','r','e','t',' ','\x89','s','e','t','s',' ','I','F','.',
/* 0x0b07e = "The command cannot be deregistered because has not been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\xcb','\x90','d','e','r','e','g','i','s','t','e','r','e','d',' ','\x1c','\x1d','\x05','\xad','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0b0a5 = "The ELF loader cannot handle multiple SYMTAB sections." */
    '\x03','E','L','F',' ','\xc4','\xcb','h','a','n','d','l','e',' ','m','u','l','t','i','p','l','e',' ','S','Y','M','T','A','B',' ','s','e','c','t','i','o','n','s','.',
/* 0x0b0cc = "The auto usage cache for the dynamic mapping set is full." */
    '\x03','a','u','t','o',' ','u','s','a','g','e',' ','c','a','c','h','e',' ','\x0e','\x02','d','y','n','a','m','i','c',' ','\xe0','s','e','t',' ','\x09','f','u','l','l','.',
/* 0x0b0f3 = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_CHOICE" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','C','H','O','I','C','E',
/* 0x0b11a = "Failed to measure the TSC delta between two CPUs." */
    '\x80','\x08','m','e','a','s','u','r','e',' ','\x02','T','S','C',' ','d','e','l','t','a',' ','b','e','t','w','e','e','n',' ','t','w','o',' ','C','P','U','s','.',
/* 0x0b140 = "The type of media was not recognized. Not formatted?." */
    '\x03','\xd9','\x13','m','e','d','i','a',' ','\x10','\x05','r','e','c','o','g','n','i','z','e','d','.',' ','N','o','t',' ','f','o','r','m','a','t','t','e','d','?','.',
/* 0x0b166 = "The device wasn\'t found. There was no registered device by that name." */
    '\x03','\x8b','w','a','s','n','\'','t',' ','\x7d',' ','T','h','e','r','e',' ','\x10','\xe9','r','e','g','i','s','t','e','r','e','d',' ','\x8b','\xb9','\x89','n','a','m','e','.',
/* 0x0b18c = "The component factories do not support the requested interface." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','i','e','s',' ','d','o',' ','\x05','\xb1','\x02','\xbf','i','n','t','e','r','f','a','c','e','.',
/* 0x0b1b2 = "VERR_X509_CERTIFICATE_VERIFICATION_FAILURE" */
    '\x01','X','5','0','9','_','C','E','R','T','I','F','I','C','A','T','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x0b1d8 = "The value is not a zero terminated password string." */
    '\x03','\xd2','\x09','\x05','a',' ','z','e','r','o',' ','t','e','r','m','i','n','a','t','e','d',' ','p','a','s','s','w','o','r','d',' ','s','t','r','i','n','g','.',
/* 0x0b1fe = "Attempt to release mutex not owned by caller." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','l','e','a','s','e',' ','m','u','t','e','x',' ','\x05','o','w','n','e','d',' ','\xb9','c','a','l','l','e','r','.',
/* 0x0b224 = "Malformed or failed to parse PEM formatted data." */
    'M','a','l','f','o','r','m','e','d',' ','\x86','\x88','\x08','p','a','r','s','e',' ','P','E','M',' ','f','o','r','m','a','t','t','e','d',' ','d','a','t','a','.',
/* 0x0b24a = "An account is restricted in a certain way." */
    'A','n',' ','a','c','c','o','u','n','t',' ','\x09','r','e','s','t','r','i','c','t','e','d',' ','\x0d','a',' ','c','e','r','t','a','i','n',' ','w','a','y','.',
/* 0x0b270 = "The signature is greater than or equal to the key." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','g','r','e','a','t','e','r',' ','t','h','a','n',' ','\x86','e','q','u','a','l',' ','\x08','\x02','k','e','y','.',
/* 0x0b296 = "Started guest process terminated with an exit code <> 0." */
    'S','t','a','r','t','e','d',' ','\xa1','\x82','t','e','r','m','i','n','a','t','e','d',' ','\x1e','\x60','e','x','i','t',' ','c','o','d','e',' ','<','>',' ','0','.',
/* 0x0b2bc = "Failed to stat a file/dir during enumeration (hardening)." */
    '\x80','\x08','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','d','u','r','i','n','g',' ','e','n','u','m','e','r','a','t','i','o','n',' ','\x9a',
/* 0x0b2e2 = "The GIM device is not registered with GIM when it ought to be." */
    '\x03','G','I','M',' ','\x8b','\x09','\x05','r','e','g','i','s','t','e','r','e','d',' ','\x1e','G','I','M',' ','\xef','i','t',' ','o','u','g','h','t',' ','\x08','b','e','.',
/* 0x0b308 = "Failed to resolve an imported (external) symbol." */
    '\x80','\x08','r','e','s','o','l','v','e',' ','\x60','i','m','p','o','r','t','e','d',' ','(','e','x','t','e','r','n','a','l',')',' ','s','y','m','b','o','l','.',
/* 0x0b32e = "Internal processing error the CodeView debug information reader." */
    '\x06','\x04','\x07','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n',' ','r','e','a','d','e','r','.',
/* 0x0b354 = "A request was not prepared and thus could not be submitted." */
    'A',' ','\x94','\x10','\x05','p','r','e','p','a','r','e','d',' ','\x2a','t','h','u','s',' ','c','o','u','l','d',' ','\x05','\x90','s','u','b','m','i','t','t','e','d','.',
/* 0x0b37a = "The specified attribute (name) was not found in the manifest." */
    '\x03','\x16','a','t','t','r','i','b','u','t','e',' ','(','n','a','m','e',')',' ','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','m','a','n','i','f','e','s','t','.',
/* 0x0b3a0 = "Reason for leaving RZ: Pending ring-3 OUT instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','O','U','T',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0b3c6 = "Not the lock owner according our records." */
    'N','o','t',' ','\x02','l','o','c','k',' ','o','w','n','e','r',' ','a','c','c','o','r','d','i','n','g',' ','o','u','r',' ','r','e','c','o','r','d','s','.',
/* 0x0b3ec = "The handle was not registered for use with the I/O queue." */
    '\x03','h','a','n','d','l','e',' ','\x10','\x05','r','e','g','i','s','t','e','r','e','d',' ','\x0e','u','s','e',' ','\x1e','\x02','I','/','O',' ','q','u','e','u','e','.',
/* 0x0b412 = "File not accessible or erroneous file contents." */
    'F','i','l','e',' ','\x05','a','c','c','e','s','s','i','b','l','e',' ','\x86','e','r','r','o','n','e','o','u','s',' ','\x18','c','o','n','t','e','n','t','s','.',
/* 0x0b438 = "VERR_PAGE_HASH_TAB_HASHES_NON_SECTION_DATA" */
    '\x01','P','A','G','E','_','H','A','S','H','_','T','A','B','_','H','A','S','H','E','S','_','N','O','N','_','S','E','C','T','I','O','N','_','D','A','T','A',
/* 0x0b45e = "The caller shall raise an #GP(0) exception." */
    '\x03','c','a','l','l','e','r',' ','s','h','a','l','l',' ','r','a','i','s','e',' ','\x60','#','G','P','(','0',')',' ','e','x','c','e','p','t','i','o','n','.',
/* 0x0b484 = "PKIX cipher algorithm is not known to OpenSSL EVP API." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbe','\x09','\x05','k','n','o','w','n',' ','\x08','O','p','e','n','S','S','L',' ','E','V','P',' ','A','P','I','.',
/* 0x0b4aa = "Unabled to locate or load the OpenGL library." */
    'U','n','a','b','l','e','d',' ','\x08','l','o','c','a','t','e',' ','\x86','l','o','a','d',' ','\x02','O','p','e','n','G','L',' ','l','i','b','r','a','r','y','.',
/* 0x0b4d0 = "The interpreter was unable to deal with the instruction at hand." */
    '\x03','i','n','t','e','r','p','r','e','t','e','r',' ','\x10','u','n','a','b','l','e',' ','\x08','d','e','a','l',' ','\x1e','\x02','\xba','a','t',' ','h','a','n','d','.',
/* 0x0b4f6 = "Attempted to report too many pages as deflated." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','r','e','p','o','r','t',' ','\x8c','\xa3','p','a','g','e','s',' ','a','s',' ','d','e','f','l','a','t','e','d','.',
/* 0x0b51c = "Catch write access and route it thru PGM." */
    'C','a','t','c','h',' ','w','r','i','t','e',' ','a','c','c','e','s','s',' ','\x2a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0b542 = "Image Verification Failure: Raw data offsets and sizes are out of range." */
    '\xfe','\x0c','\x12','R','a','w',' ','\x8f','o','f','f','s','e','t','s',' ','\x2a','s','i','z','e','s',' ','a','r','e',' ','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x0b568 = "VERR_FDT_DTB_HDR_STRINGS_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b58e = "VERR_CR_CIPHER_INVALID_INITIALIZATION_VECTOR_LENGTH" */
    '\x01','\xa9','C','I','P','H','E','R','_','\x0f','I','N','I','T','I','A','L','I','Z','A','T','I','O','N','_','V','E','C','T','O','R','_','L','E','N','G','T','H',
/* 0x0b5b4 = "LUN is already/still attached to a device." */
    'L','U','N',' ','\x09','a','l','r','e','a','d','y','/','s','t','i','l','l',' ','a','t','t','a','c','h','e','d',' ','\x08','a',' ','d','e','v','i','c','e','.',
/* 0x0b5da = "Error getting extensions from the certificate." */
    '\xac','g','e','t','t','i','n','g',' ','e','x','t','e','n','s','i','o','n','s',' ','f','r','o','m',' ','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0b600 = "Unexpected ASN.1 tag class/flag encountered while decoding." */
    '\x85','A','S','N','.','1',' ','t','a','g',' ','c','l','a','s','s','/','f','l','a','g',' ','\x98','w','h','i','l','e',' ','d','e','c','o','d','i','n','g','.',
/* 0x0b626 = "The chunk has been mapped too many times already (impossible)." */
    '\x03','c','h','u','n','k',' ','\x1d','\xad','m','a','p','p','e','d',' ','\x8c','\xa3','t','i','m','e','s',' ','\x22','(','i','m','p','o','s','s','i','b','l','e',')','.',
/* 0x0b64c = "The provider is only allowed as the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\x09','\xf7','a','l','l','o','w','e','d',' ','a','s',' ','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x0b672 = "Filesystem can\'t be opened because it is corrupt." */
    'F','i','l','e','s','y','s','t','e','m',' ','c','a','n','\'','t',' ','\x90','o','p','e','n','e','d',' ','\x1c','i','t',' ','\x09','c','o','r','r','u','p','t','.',
/* 0x0b698 = "The specified execution engine cannot execute guest code in the current state." */
    '\x03','\x16','e','x','e','c','u','t','i','o','n',' ','e','n','g','i','n','e',' ','\xcb','e','x','e','c','u','t','e',' ','\xa1','c','o','d','e',' ','\x0d','\x02','\xd1','\xf5',
/* 0x0b6be = "A queue is out of free items, the queueing operation failed." */
    'A',' ','q','u','e','u','e',' ','\x09','o','u','t',' ','\x13','f','r','e','e',' ','i','t','e','m','s',',',' ','\x02','q','u','e','u','e','i','n','g',' ','\x83','\x24',
/* 0x0b6e4 = "VERR_FDT_DTB_HDR_MEM_RSV_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','E','M','_','R','S','V','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b70a = "Only native endian Mach-O files are supported." */
    'O','n','l','y',' ','n','a','t','i','v','e',' ','e','n','d','i','a','n',' ','M','a','c','h','-','O',' ','f','i','l','e','s',' ','a','r','e',' ','\x95',
/* 0x0b72f = "The field does not follow immediately the previous one." */
    '\x03','\xff','\x9c','\x05','f','o','l','l','o','w',' ','i','m','m','e','d','i','a','t','e','l','y',' ','\x02','p','r','e','v','i','o','u','s',' ','o','n','e','.',
/* 0x0b754 = "The hyper CR3 differs between PGM and CPUM." */
    '\x03','h','y','p','e','r',' ','C','R','3',' ','d','i','f','f','e','r','s',' ','b','e','t','w','e','e','n',' ','P','G','M',' ','\x2a','C','P','U','M','.',
/* 0x0b779 = "Invalid ASN.1 ISO-646/VISIBLE STRING encoding." */
    '\x0b','A','S','N','.','1',' ','\xb2','-','6','4','6','/','V','I','S','I','B','L','E',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0b79e = "Expected write pipe, got a read pipe instead." */
    '\xa6','w','r','i','t','e',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','r','e','a','d',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x0b7c3 = "OpenSSL and IPRT disagree on the signature." */
    'O','p','e','n','S','S','L',' ','\x2a','I','P','R','T',' ','d','i','s','a','g','r','e','e',' ','o','n',' ','\x02','s','i','g','n','a','t','u','r','e','.',
/* 0x0b7e8 = "Syntax error - the argument does not allow a range to be specified." */
    '\xe1','\x07','-',' ','\x02','a','r','g','u','m','e','n','t',' ','\x9c','\x05','a','l','l','o','w',' ','a',' ','\xe4','\x08','\x90','s','p','e','c','i','f','i','e','d','.',
/* 0x0b80d = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_IMAGE_OUT_OF_BOUNDS" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','I','M','A','G','E','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0b832 = "Error enumerating all processes in the session." */
    '\xac','e','n','u','m','e','r','a','t','i','n','g',' ','a','l','l',' ','p','r','o','c','e','s','s','e','s',' ','\x0d','\x02','s','e','s','s','i','o','n','.',
/* 0x0b857 = "VERR_LDRVI_PAGE_HASH_TAB_NOT_STRICTLY_SORTED" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','\x14','S','T','R','I','C','T','L','Y','_','S','O','R','T','E','D',
/* 0x0b87c = "The name of the module clashed with an existing module." */
    '\x03','\xf3','\x13','\x02','m','o','d','u','l','e',' ','c','l','a','s','h','e','d',' ','\x1e','\x60','e','x','i','s','t','i','n','g',' ','m','o','d','u','l','e','.',
/* 0x0b8a1 = "validation of the fixup section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x13','\x02','f','i','x','u','p',' ','\xc6','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x24',
/* 0x0b8c6 = "VERR_CR_PKCS7_SIGNER_INFO_NO_ISSUER_SERIAL_NO" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','\xb7','I','S','S','U','E','R','_','S','E','R','I','A','L','_','N','O',
/* 0x0b8eb = "The DTB structs block ended prematurely." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','e','n','d','e','d',' ','p','r','e','m','a','t','u','r','e','l','y','.',
/* 0x0b910 = "Key algorithm parameters are not known/supported." */
    'K','e','y',' ','\xbe','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','k','n','o','w','n','/','s','u','p','p','o','r','t','e','d','.',
/* 0x0b935 = "VERR_FDT_DTB_HDR_STRUCT_BLOCK_OFF_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','T','R','U','C','T','_','B','L','O','C','K','_','O','F','F','_','I','N','V','A','L','I','D',
/* 0x0b95a = "We were given a NULL pPage parameter." */
    'W','e',' ','w','e','r','e',' ','g','i','v','e','n',' ','a',' ','N','U','L','L',' ','p','P','a','g','e',' ','p','a','r','a','m','e','t','e','r','.',
/* 0x0b97f = "Recompilation: End translation block." */
    'R','e','c','o','m','p','i','l','a','t','i','o','n',':',' ','E','n','d',' ','t','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k','.',
/* 0x0b9a4 = "Mismatch between IPRT and native loader." */
    'M','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','I','P','R','T',' ','\x2a','n','a','t','i','v','e',' ','l','o','a','d','e','r','.',
/* 0x0b9c9 = "Malformed indefinite length encoding." */
    'M','a','l','f','o','r','m','e','d',' ','i','n','d','e','f','i','n','i','t','e',' ','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x0b9ee = "The hash function in the header doesn't match the one in the table of content." */
    '\x03','h','a','s','h',' ','f','u','n','c','t','i','o','n',' ','\x0d','\x02','\xa2','\xa5','\xe3','\x02','o','n','e',' ','\x0d','\x02','\x9e','\x13','c','o','n','t','e','n','t','.',
/* 0x0ba13 = "The environment variable is an unset record." */
    '\x03','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','\x09','\x60','u','n','s','e','t',' ','r','e','c','o','r','d','.',
/* 0x0ba38 = "The loaded XSAVE component mask is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','c','o','m','p','o','n','e','n','t',' ','m','a','s','k',' ','\x09','\x05','v','a','l','i','d','.',
/* 0x0ba5d = "The tracer cannot open it self in the same session." */
    '\x03','t','r','a','c','e','r',' ','\xcb','o','p','e','n',' ','i','t',' ','s','e','l','f',' ','\x0d','\x02','s','a','m','e',' ','s','e','s','s','i','o','n','.',
/* 0x0ba82 = "Not able to allocate contiguous memory." */
    'N','o','t',' ','a','b','l','e',' ','\x08','a','l','l','o','c','a','t','e',' ','c','o','n','t','i','g','u','o','u','s',' ','m','e','m','o','r','y','.',
/* 0x0baa7 = "Node pointer does not point to the start of a node." */
    'N','o','d','e',' ','p','o','i','n','t','e','r',' ','\x9c','\x05','p','o','i','n','t',' ','\x08','\x02','s','t','a','r','t',' ','\x13','a',' ','n','o','d','e','.',
/* 0x0bacc = "The image file is not owned by TrustedInstaller is it should be." */
    '\x03','\x1a','\x18','\x09','\x05','o','w','n','e','d',' ','\xb9','T','r','u','s','t','e','d','I','n','s','t','a','l','l','e','r',' ','\x09','i','t',' ','\xec','b','e','.',
/* 0x0baf1 = "PKCS #7 signed data has no digest algorithms listed." */
    'P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x8f','\x1d','\xe9','\xc2','a','l','g','o','r','i','t','h','m','s',' ','l','i','s','t','e','d','.',
/* 0x0bb16 = "ICB is too small to contain anything useful." */
    'I','C','B',' ','\x09','\x8c','s','m','a','l','l',' ','\x08','c','o','n','t','a','i','n',' ','a','n','y','t','h','i','n','g',' ','u','s','e','f','u','l','.',
/* 0x0bb3b = "Couldn\'t find the end of CPUID sub-leaves." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','e','n','d',' ','\x13','C','P','U','I','D',' ','s','u','b','-','l','e','a','v','e','s','.',
/* 0x0bb60 = "The boot catalog block in the import ISO is out of bounds." */
    '\x03','b','o','o','t',' ','\xcd','b','l','o','c','k',' ','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x0bb85 = "Reason for leaving RZ: Pending ring-3 IN instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','P','e','n','d','i','n','g',' ','r','i','n','g','-','3',' ','I','N',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0bbaa = "Invalid page count given to GMMR3FreePagesPerform." */
    '\x0b','\xb6','c','o','u','n','t',' ','g','i','v','e','n',' ','\x08','G','M','M','R','3','F','r','e','e','P','a','g','e','s','P','e','r','f','o','r','m','.',
/* 0x0bbcf = "Attemted illegal operation in simplified memory management mode." */
    'A','t','t','e','m','t','e','d',' ','i','l','l','e','g','a','l',' ','\x83','\x0d','s','i','m','p','l','i','f','i','e','d',' ','\x5c','\xfb','m','o','d','e','.',
/* 0x0bbf4 = "Certificate path validator: Name constraints does not permits the certificate name." */
    '\xa7','\xbb','\xe5','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','\x9c','\x05','p','e','r','m','i','t','s',' ','\x02','\x8a','n','a','m','e','.',
/* 0x0bc19 = "Failed to abort entering a critical section in ring-0." */
    '\x80','\x08','a','b','o','r','t',' ','e','n','t','e','r','i','n','g',' ','a',' ','c','r','i','t','i','c','a','l',' ','\xc6','\x0d','r','i','n','g','-','0','.',
/* 0x0bc3e = "Process Purification Failure: Unknown memory type of executable memory." */
    '\x17','P','u','r','i','f','i','c','a','t','i','o','n',' ','\x12','\xdf','\x5c','\xd9','\x13','e','x','e','c','u','t','a','b','l','e',' ','m','e','m','o','r','y','.',
/* 0x0bc63 = "Expected read pipe, got a write pipe instead." */
    '\xa6','r','e','a','d',' ','p','i','p','e',',',' ','g','o','t',' ','a',' ','w','r','i','t','e',' ','p','i','p','e',' ','i','n','s','t','e','a','d','.',
/* 0x0bc88 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_UNDEFINED_FLAGS" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','U','N','D','E','F','I','N','E','D','_','F','L','A','G','S',
/* 0x0bcad = "Failed to fix mappings because a mapping rejected the address." */
    '\x80','\x08','f','i','x',' ','m','a','p','p','i','n','g','s',' ','\x1c','a',' ','\xe0','r','e','j','e','c','t','e','d',' ','\x02','a','d','d','r','e','s','s','.',
/* 0x0bcd2 = "Encountered a \'-\' during conversion to an unsigned value." */
    '\x97','a',' ','\'','-','\'',' ','d','u','r','i','n','g',' ','c','o','n','v','e','r','s','i','o','n',' ','\x08','\x60','u','n','s','i','g','n','e','d',' ','\xd3',
/* 0x0bcf7 = "The DTB being parsed has an invalid last compatible version set." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\x60','\x81','l','a','s','t',' ','c','o','m','p','a','t','i','b','l','e',' ','\xb4','s','e','t','.',
/* 0x0bd1c = "Reason for leaving R0: Hit a ring-0 assertion on EMT." */
    '\x84','\x0e','\x25','R','0',':',' ','H','i','t',' ','a',' ','r','i','n','g','-','0',' ','a','s','s','e','r','t','i','o','n',' ','o','n',' ','E','M','T','.',
/* 0x0bd41 = "The DTB being parsed has an invalid strings block offset." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\x60','\x81','s','t','r','i','n','g','s',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0bd66 = "VERR_CR_PKCS7_MISSING_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\xa9','P','K','C','S','7','_','M','I','S','S','I','N','G','_','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B',
/* 0x0bd8b = "VERR_REST_UNABLE_TO_PARSE_STRING_AS_BOOL" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','P','A','R','S','E','_','S','T','R','I','N','G','_','A','S','_','B','O','O','L',
/* 0x0bdaf = "NEM init failed because of missing kernel API (#2)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','2',')','.',
/* 0x0bdd3 = "Invalid parameters passed to the lock validator." */
    '\x0b','p','a','r','a','m','e','t','e','r','s',' ','p','a','s','s','e','d',' ','\x08','\x02','l','o','c','k',' ','v','a','l','i','d','a','t','o','r','.',
/* 0x0bdf7 = "The guest has not setup use of the paravirtualized TSC." */
    '\x03','\xa1','\x1d','\x05','s','e','t','u','p',' ','u','s','e',' ','\x13','\x02','p','a','r','a','v','i','r','t','u','a','l','i','z','e','d',' ','T','S','C','.',
/* 0x0be1b = "NEM init failed because of missing kernel API (#4)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','4',')','.',
/* 0x0be3f = "The ELF loader encountered a relocation type which is not implemented." */
    '\x03','E','L','F',' ','\xc4','\x98','a',' ','r','e','l','o','c','a','t','i','o','n',' ','\xd9','\xc0','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0be63 = "Import ISO contains a \'.\' or \'..\' directory record with a bad name." */
    '\xaf','\xb2',' ','\x7f','a',' ','\'','.','\'',' ','\x86','\'','.','.','\'',' ','\x1b','r','e','c','o','r','d',' ','\x1e','a',' ','b','a','d',' ','n','a','m','e','.',
/* 0x0be87 = "The lock validator detected a deadlock." */
    '\x03','l','o','c','k',' ','v','a','l','i','d','a','t','o','r',' ','d','e','t','e','c','t','e','d',' ','a',' ','d','e','a','d','l','o','c','k','.',
/* 0x0beab = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MAX" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','A','X',
/* 0x0becf = "Import ISO contains a bad supplementary volume descriptor." */
    '\xaf','\xb2',' ','\x7f','a',' ','b','a','d',' ','s','u','p','p','l','e','m','e','n','t','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0bef3 = "Too many ICB indirections, possibly a loop." */
    '\xf0','\xa3','I','C','B',' ','i','n','d','i','r','e','c','t','i','o','n','s',',',' ','p','o','s','s','i','b','l','y',' ','a',' ','l','o','o','p','.',
/* 0x0bf17 = "Reason for leaving RC: Sync the GDT table to solve a conflict." */
    '\x84','\x0e','\x25','R','C',':',' ','S','y','n','c',' ','\x02','G','D','T',' ','\x9e','\x08','s','o','l','v','e',' ','a',' ','c','o','n','f','l','i','c','t','.',
/* 0x0bf3b = "The DTB being parsed has an invalid struct block offset." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\x60','\x81','s','t','r','u','c','t',' ','b','l','o','c','k',' ','o','f','f','s','e','t','.',
/* 0x0bf5f = "VFS chain element takes a file system (vfs) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x0bf83 = "Current virtual machine state prevents the operation." */
    'C','u','r','r','e','n','t',' ','v','i','r','t','u','a','l',' ','m','a','c','h','i','n','e',' ','\xb0','p','r','e','v','e','n','t','s',' ','\x02','\xcc',
/* 0x0bfa7 = "The timer queue is not longer allowed to grow." */
    '\x03','t','i','m','e','r',' ','q','u','e','u','e',' ','\x09','\x05','l','o','n','g','e','r',' ','a','l','l','o','w','e','d',' ','\x08','g','r','o','w','.',
/* 0x0bfcb = "VERR_URI_INVALID_ESCAPED_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','D','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0bfef = "The DTB property payload string is not terminated." */
    '\x03','D','T','B',' ','p','r','o','p','e','r','t','y',' ','p','a','y','l','o','a','d',' ','\xc7','\x09','\x05','t','e','r','m','i','n','a','t','e','d','.',
/* 0x0c013 = "Process Verification Failure: Error reading process memory for comparing with disk data." */
    '\x17','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x82','\x5c','\x0e','c','o','m','p','a','r','i','n','g',' ','\x1e','d','i','s','k',' ','d','a','t','a','.',
/* 0x0c037 = "Reason for leaving RC: The IRET resuming guest code trapped." */
    '\x84','\x0e','\x25','R','C',':',' ','\x03','I','R','E','T',' ','r','e','s','u','m','i','n','g',' ','\xa1','c','o','d','e',' ','t','r','a','p','p','e','d','.',
/* 0x0c05b = "Catch any access and route it thru PGM." */
    'C','a','t','c','h',' ','a','n','y',' ','a','c','c','e','s','s',' ','\x2a','r','o','u','t','e',' ','i','t',' ','t','h','r','u',' ','P','G','M','.',
/* 0x0c07f = "Unable to allocate more pages from the host system." */
    '\xca','\x08','a','l','l','o','c','a','t','e',' ','\xf6','p','a','g','e','s',' ','f','r','o','m',' ','\x02','h','o','s','t',' ','s','y','s','t','e','m','.',
/* 0x0c0a3 = "The algorithms part of the DEK-Info field is too long." */
    '\x03','a','l','g','o','r','i','t','h','m','s',' ','p','a','r','t',' ','\x13','\x02','D','E','K','-','I','n','f','o',' ','\xff','\x09','\x8c','l','o','n','g','.',
/* 0x0c0c7 = "The requested operation cannot be performed because the device is currently being reset." */
    '\x03','\xbf','\x83','\xcb','\x90','p','e','r','f','o','r','m','e','d',' ','\x1c','\x02','\x8b','\x09','c','u','r','r','e','n','t','l','y',' ','\xdb','r','e','s','e','t','.',
/* 0x0c0eb = "The breakpoint owner callback returned an invalid status code." */
    '\x03','\xab','o','w','n','e','r',' ','c','a','l','l','b','a','c','k',' ','r','e','t','u','r','n','e','d',' ','\x60','\x81','s','t','a','t','u','s',' ','\x5e',
/* 0x0c10f = "Syntax error - an undefined variable was referenced." */
    '\xe1','\x07','-',' ','\x60','u','n','d','e','f','i','n','e','d',' ','v','a','r','i','a','b','l','e',' ','\x10','r','e','f','e','r','e','n','c','e','d','.',
/* 0x0c133 = "The field contains an invalid callback or transformation index." */
    '\x03','\xff','\x7f','\x60','\x81','c','a','l','l','b','a','c','k',' ','\x86','t','r','a','n','s','f','o','r','m','a','t','i','o','n',' ','i','n','d','e','x','.',
/* 0x0c157 = "NEM init failed because of missing kernel API (#3)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','3',')','.',
/* 0x0c17b = "The timer can\'t be started because it\'s already active." */
    '\x03','t','i','m','e','r',' ','c','a','n','\'','t',' ','\x90','s','t','a','r','t','e','d',' ','\x1c','i','t','\'','s',' ','\x22','a','c','t','i','v','e','.',
/* 0x0c19f = "Recompiler: Duplicate argument variable number." */
    '\x11','D','u','p','l','i','c','a','t','e',' ','a','r','g','u','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','u','m','b','e','r','.',
/* 0x0c1c3 = "Unresolved (unknown) host platform error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','h','o','s','t',' ','p','l','a','t','f','o','r','m',' ','\x7b',
/* 0x0c1e7 = "The TCP server has no client associated with it." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x1d','\xe9','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','i','t','.',
/* 0x0c20b = "VFS chain element only provides file system (vfs) objects." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','\x18','s','y','s','t','e','m',' ','(','v','f','s',')',' ','o','b','j','e','c','t','s','.',
/* 0x0c22f = "General failure - DON\'T USE THIS!!!." */
    'G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e',' ','-',' ','D','O','N','\'','T',' ','U','S','E',' ','T','H','I','S','!','!','!','.',
/* 0x0c253 = "The Host Interface Networking device name is too long." */
    '\x03','H','o','s','t',' ','I','n','t','e','r','f','a','c','e',' ','N','e','t','w','o','r','k','i','n','g',' ','\x8b','\xf3','\x09','\x8c','l','o','n','g','.',
/* 0x0c277 = "Generic debug event, suspend the VM for debugging." */
    '\x96','d','e','b','u','g',' ','e','v','e','n','t',',',' ','s','u','s','p','e','n','d',' ','\x02','\xcf',' ','\x0e','d','e','b','u','g','g','i','n','g','.',
/* 0x0c29b = "Partition mapping table is shorted than described." */
    'P','a','r','t','i','t','i','o','n',' ','\xe0','\x9e','\x09','s','h','o','r','t','e','d',' ','t','h','a','n',' ','d','e','s','c','r','i','b','e','d','.',
/* 0x0c2bf = "No more handles available, too many open handles." */
    '\xd0','\xf6','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e',',',' ','\x8c','\xa3','o','p','e','n',' ','h','a','n','d','l','e','s','.',
/* 0x0c2e3 = "Digest algorithm parameters are not supported by the PKCS #7 code." */
    'D','i','g','e','s','t',' ','\xbe','p','a','r','a','m','e','t','e','r','s',' ','a','r','e',' ','\x05','\xf9','\xb9','\x02','P','K','C','S',' ','#','7',' ','\x5e',
/* 0x0c307 = "Encountered a load command that\'s not implemented." */
    '\x97','a',' ','l','o','a','d',' ','c','o','m','m','a','n','d',' ','t','h','a','t','\'','s',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0c32b = "Unexpected/unknown/bad descriptor in volume descriptor sequence." */
    'U','n','e','x','p','e','c','t','e','d','/','u','n','k','n','o','w','n','/','b','a','d',' ','\xd6','\x0d','\xbd','\xd6','s','e','q','u','e','n','c','e','.',
/* 0x0c34f = "The UDP server has no client associated with it." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x1d','\xe9','c','l','i','e','n','t',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','i','t','.',
/* 0x0c373 = "Certificate path validator: Intermediate certificate is not a version 3 certificate." */
    '\xa7','\xbb','\xe5','I','n','t','e','r','m','e','d','i','a','t','e',' ','\x8a','\x09','\x05','a',' ','\xb4','3',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c397 = "VERR_REST_REQUIRED_HEADER_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','H','E','A','D','E','R','_','P','A','R','A','M','E','T','E','R','_','\x14','S','E','T',
/* 0x0c3bb = "The thread is not a valid signaller of the event." */
    '\x03','t','h','r','e','a','d',' ','\x09','\x05','a',' ','v','a','l','i','d',' ','s','i','g','n','a','l','l','e','r',' ','\x13','\x02','e','v','e','n','t','.',
/* 0x0c3df = "VERR_CR_PKCS7_SIGNER_INFO_DIGEST_ENCRYPT_MISMATCH" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','D','I','G','E','S','T','_','E','N','C','R','Y','P','T','_','\x99',
/* 0x0c403 = "Error encoding the password for key decryption." */
    '\xac','e','n','c','o','d','i','n','g',' ','\x02','p','a','s','s','w','o','r','d',' ','\x0e','k','e','y',' ','d','e','c','r','y','p','t','i','o','n','.',
/* 0x0c427 = "VERR_FDT_DTB_STRUCTS_BLOCK_PREMATURE_END" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','P','R','E','M','A','T','U','R','E','_','E','N','D',
/* 0x0c44b = "OpenSSL failed to init PKIX cipher algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','i','n','i','t',' ','P','K','I','X',' ','c','i','p','h','e','r',' ','\xbe','c','o','n','t','e','x','t','.',
/* 0x0c46f = "Encountered an unsupported Solaris Tar extension." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','S','o','l','a','r','i','s',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0c493 = "The image is required to force integrity checks." */
    '\x03','\x1a','\x09','r','e','q','u','i','r','e','d',' ','\x08','f','o','r','c','e',' ','i','n','t','e','g','r','i','t','y',' ','c','h','e','c','k','s','.',
/* 0x0c4b7 = "NEM init failed because of missing kernel API (#5)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','5',')','.',
/* 0x0c4db = "The VFS chain specification does not have a valid prefix." */
    '\x03','\xa4',' ','\x91','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x9c','\x05','\xeb','a',' ','v','a','l','i','d',' ','p','r','e','f','i','x','.',
/* 0x0c4ff = "VERR_CR_X509_CPV_UNEXP_GENERAL_SUBTREE_MIN" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','U','N','E','X','P','_','G','E','N','E','R','A','L','_','S','U','B','T','R','E','E','_','M','I','N',
/* 0x0c523 = "Process Verification Failure: No KERNE32.DLL mapping found. This is impossible." */
    '\x17','\x0c','\x12','\xd0','K','E','R','N','E','3','2','.','D','L','L',' ','\xe0','\x7d',' ','T','h','i','s',' ','\x09','i','m','p','o','s','s','i','b','l','e','.',
/* 0x0c547 = "Invalid address mode passed to an IEM function." */
    '\x0b','a','d','d','r','e','s','s',' ','m','o','d','e',' ','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0c56b = "Continue execution after patch trap." */
    'C','o','n','t','i','n','u','e',' ','e','x','e','c','u','t','i','o','n',' ','a','f','t','e','r',' ','p','a','t','c','h',' ','t','r','a','p','.',
/* 0x0c58f = "VERR_FDT_DTB_STRUCTS_BLOCK_TOKEN_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','U','C','T','S','_','B','L','O','C','K','_','T','O','K','E','N','_','I','N','V','A','L','I','D',
/* 0x0c5b3 = "Unable to parse the CodeView debug information." */
    '\xca','\x08','p','a','r','s','e',' ','\x02','C','o','d','e','V','i','e','w',' ','d','e','b','u','g',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0c5d7 = "NEM init failed because of missing kernel API (#1)." */
    'N','E','M',' ','i','n','i','t',' ','\x88','\x1c','\x13','m','i','s','s','i','n','g',' ','k','e','r','n','e','l',' ','A','P','I',' ','(','#','1',')','.',
/* 0x0c5fb = "Network dropped connection on reset." */
    'N','e','t','w','o','r','k',' ','d','r','o','p','p','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','o','n',' ','r','e','s','e','t','.',
/* 0x0c61f = "Incomplete packet was submitted by guest." */
    'I','n','c','o','m','p','l','e','t','e',' ','p','a','c','k','e','t',' ','\x10','s','u','b','m','i','t','t','e','d',' ','\xb9','g','u','e','s','t','.',
/* 0x0c643 = "The async completion task is not suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x09','\x05','s','u','s','p','e','n','d','e','d','.',
/* 0x0c666 = "The PE loader encountered a certificate with an unsupported type or structure revision." */
    '\x03','P','E',' ','\xc4','\x98','a',' ','\x8a','\x1e','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','\xd9','\x86','\xc1','r','e','v','i','s','i','o','n','.',
/* 0x0c689 = "The symbol size was adjusted while adding it." */
    '\x03','s','y','m','b','o','l',' ','\xf8','\x10','a','d','j','u','s','t','e','d',' ','w','h','i','l','e',' ','a','d','d','i','n','g',' ','i','t','.',
/* 0x0c6ac = "The page hash table is not strictly ordered by offset." */
    '\x03','\xb6','h','a','s','h',' ','\x9e','\x09','\x05','s','t','r','i','c','t','l','y',' ','o','r','d','e','r','e','d',' ','\xb9','o','f','f','s','e','t','.',
/* 0x0c6cf = "Import ISO contains more than one el torito descriptor." */
    '\xaf','\xb2',' ','\x7f','\xf6','t','h','a','n',' ','o','n','e',' ','e','l',' ','t','o','r','i','t','o',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0c6f2 = "An unknown config node (key) was encountered." */
    'A','n',' ','\xfc','c','o','n','f','i','g',' ','n','o','d','e',' ','(','k','e','y',')',' ','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x0c715 = "Attempted to insert mode with invalid key range." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','i','n','s','e','r','t',' ','m','o','d','e',' ','\x1e','\x81','k','e','y',' ','r','a','n','g','e','.',
/* 0x0c738 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_USES_UNUSED_FIELD" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','U','S','E','S','_','U','N','U','S','E','D','_','F','I','E','L','D',
/* 0x0c75b = "VWRN_UNABLE_TO_SATISFY_REQUIREMENTS" */
    'V','W','R','N','_','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0c77e = "iSCSI: Initiator secret not decrypted." */
    'i','S','C','S','I',':',' ','I','n','i','t','i','a','t','o','r',' ','s','e','c','r','e','t',' ','\x05','d','e','c','r','y','p','t','e','d','.',
/* 0x0c7a1 = "The CR3 address specified memory we don\'t know about." */
    '\x03','C','R','3',' ','a','d','d','r','e','s','s',' ','\x16','\x5c','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0c7c4 = "VERR_SSM_FIELD_LOAD_ONLY_TRANSFORMATION" */
    '\x01','S','S','M','_','F','I','E','L','D','_','L','O','A','D','_','O','N','L','Y','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0c7e7 = "No host backend attached / available." */
    '\xd0','h','o','s','t',' ','b','a','c','k','e','n','d',' ','a','t','t','a','c','h','e','d',' ','/',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x0c80a = "Couldn\'t connect to the server (proxy?)." */
    'C','o','u','l','d','n','\'','t',' ','c','o','n','n','e','c','t',' ','\x08','\x02','s','e','r','v','e','r',' ','(','p','r','o','x','y','?',')','.',
/* 0x0c82d = "CPU microarch lookup matched by name." */
    'C','P','U',' ','m','i','c','r','o','a','r','c','h',' ','l','o','o','k','u','p',' ','m','a','t','c','h','e','d',' ','\xb9','n','a','m','e','.',
/* 0x0c850 = "VERR_XAR_ARCHIVED_AND_EXTRACTED_SIZES_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','A','N','D','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','S','_','\x99',
/* 0x0c873 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_END_OF_SECTOR" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','E','N','D','_','O','F','_','S','E','C','T','O','R',
/* 0x0c896 = "Attempted to disabled a breakpoint which was already disabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','d','i','s','a','b','l','e','d',' ','a',' ','\xab','\xc0','\x10','\x22','d','i','s','a','b','l','e','d','.',
/* 0x0c8b9 = "The DTB structs block starts with an invalid token." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','s','t','a','r','t','s',' ','\x1e','\x60','\x81','t','o','k','e','n','.',
/* 0x0c8dc = "Service rejected client connection." */
    'S','e','r','v','i','c','e',' ','r','e','j','e','c','t','e','d',' ','c','l','i','e','n','t',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x0c8ff = "Import ISO contains an unsupported primary volume descriptor version." */
    '\xaf','\xb2',' ','\x7f','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','p','r','i','m','a','r','y',' ','\xbd','\xd6','v','e','r','s','i','o','n','.',
/* 0x0c922 = "The address (virtual or physical) is too big." */
    '\x03','a','d','d','r','e','s','s',' ','(','v','i','r','t','u','a','l',' ','\x86','p','h','y','s','i','c','a','l',')',' ','\x09','\x8c','b','i','g','.',
/* 0x0c945 = "The encrypted digest algorithm does not match the one in the certificate." */
    '\x03','e','n','c','r','y','p','t','e','d',' ','\xc2','\xbe','\x9c','\x05','\xe3','\x02','o','n','e',' ','\x0d','\x02','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0c968 = "An illegal lock upgrade was attempted." */
    'A','n',' ','i','l','l','e','g','a','l',' ','l','o','c','k',' ','u','p','g','r','a','d','e',' ','\x10','a','t','t','e','m','p','t','e','d','.',
/* 0x0c98b = "Invalid ASN.1 T61/TELETEX STRING encoding." */
    '\x0b','A','S','N','.','1',' ','T','6','1','/','T','E','L','E','T','E','X',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0c9ae = "VERR_CR_PKCS7_MISSING_CONTENT_TYPE_ATTRIB" */
    '\x01','\xa9','P','K','C','S','7','_','M','I','S','S','I','N','G','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B',
/* 0x0c9d1 = "The signature is too long for the scratch buffer." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','\x8c','l','o','n','g',' ','\x0e','\x02','s','c','r','a','t','c','h',' ','b','u','f','f','e','r','.',
/* 0x0c9f4 = "The given range does not meet the required alignment." */
    '\x03','g','i','v','e','n',' ','\xe4','\x9c','\x05','m','e','e','t',' ','\x02','r','e','q','u','i','r','e','d',' ','a','l','i','g','n','m','e','n','t','.',
/* 0x0ca17 = "Error while calculating a digest for a PKCS #7 verification operation." */
    '\xac','w','h','i','l','e',' ','c','a','l','c','u','l','a','t','i','n','g',' ','a',' ','\xc2','\x0e','a',' ','P','K','C','S',' ','#','7',' ','\xd5','\xcc',
/* 0x0ca3a = "The machine was powered off while saving." */
    '\x03','m','a','c','h','i','n','e',' ','\x10','p','o','w','e','r','e','d',' ','o','f','f',' ','w','h','i','l','e',' ','s','a','v','i','n','g','.',
/* 0x0ca5d = "Don\'t call again until the final pass." */
    'D','o','n','\'','t',' ','c','a','l','l',' ','a','g','a','i','n',' ','u','n','t','i','l',' ','\x02','f','i','n','a','l',' ','p','a','s','s','.',
/* 0x0ca80 = "VERR_REST_REQUIRED_QUERY_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','R','E','Q','U','I','R','E','D','_','Q','U','E','R','Y','_','P','A','R','A','M','E','T','E','R','_','\x14','S','E','T',
/* 0x0caa3 = "The async completion task is already suspended." */
    '\x03','a','s','y','n','c',' ','c','o','m','p','l','e','t','i','o','n',' ','t','a','s','k',' ','\x09','\x22','s','u','s','p','e','n','d','e','d','.',
/* 0x0cac6 = "VMDK: Format is invalid/inconsistent." */
    'V','M','D','K',':',' ','F','o','r','m','a','t',' ','\x09','i','n','v','a','l','i','d','/','i','n','c','o','n','s','i','s','t','e','n','t','.',
/* 0x0cae9 = "VERR_ASN1_CURSOR_ILLEGAL_CONSTRUCTED_STRING" */
    '\x01','\xf2','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','C','O','N','S','T','R','U','C','T','E','D','_','S','T','R','I','N','G',
/* 0x0cb0c = "Process Verification Failure: One of the section in the image file is not mapped into memory." */
    '\x17','\x0c','\x12','O','n','e',' ','\x13','\x02','\xc6','\x0d','\x02','\x1a','\x18','\x09','\x05','m','a','p','p','e','d',' ','i','n','t','o',' ','m','e','m','o','r','y','.',
/* 0x0cb2f = "The RTPROC_FLAGS_DETACHED flag isn\'t supported." */
    '\x03','R','T','P','R','O','C','_','F','L','A','G','S','_','D','E','T','A','C','H','E','D',' ','f','l','a','g',' ','i','s','n','\'','t',' ','\x95',
/* 0x0cb52 = "Support for forwarders has not been implemented." */
    'S','u','p','p','o','r','t',' ','\x0e','f','o','r','w','a','r','d','e','r','s',' ','\x1d','\x05','\xad','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0cb75 = "Certificate path validator: Name constraints permits no names." */
    '\xa7','\xbb','\xe5','N','a','m','e',' ','c','o','n','s','t','r','a','i','n','t','s',' ','p','e','r','m','i','t','s',' ','\xe9','n','a','m','e','s','.',
/* 0x0cb98 = "VERR_CR_SPC_SIGNED_IND_DATA_DIGEST_ALGO_MISMATCH" */
    '\x01','\xa9','S','P','C','_','S','I','G','N','E','D','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','A','L','G','O','_','\x99',
/* 0x0cbbb = "VERR_LDRMACHO_MIXED_DEBUG_SECTION_FLAGS" */
    '\x01','L','D','R','M','A','C','H','O','_','M','I','X','E','D','_','D','E','B','U','G','_','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x0cbde = "VERR_URI_MISSING_UTF8_CONTINUATION_BYTE" */
    '\x01','U','R','I','_','M','I','S','S','I','N','G','_','U','T','F','8','_','C','O','N','T','I','N','U','A','T','I','O','N','_','B','Y','T','E',
/* 0x0cc01 = "PE image data without any valid content was not expected." */
    'P','E',' ','\x1a','\x8f','w','i','t','h','o','u','t',' ','a','n','y',' ','v','a','l','i','d',' ','\xd8','\x10','\x05','e','x','p','e','c','t','e','d','.',
/* 0x0cc24 = "Key encrypted but no password was given." */
    'K','e','y',' ','e','n','c','r','y','p','t','e','d',' ','b','u','t',' ','\xe9','p','a','s','s','w','o','r','d',' ','\x10','g','i','v','e','n','.',
/* 0x0cc47 = "DWARF LEB value overflows the decoder type." */
    'D','W','A','R','F',' ','L','E','B',' ','\xd2','o','v','e','r','f','l','o','w','s',' ','\x02','d','e','c','o','d','e','r',' ','t','y','p','e','.',
/* 0x0cc6a = "Don\'t mess around with ballooned pages." */
    'D','o','n','\'','t',' ','m','e','s','s',' ','a','r','o','u','n','d',' ','\x1e','b','a','l','l','o','o','n','e','d',' ','p','a','g','e','s','.',
/* 0x0cc8d = "Ping-Pong listen or speak out of turn error." */
    'P','i','n','g','-','P','o','n','g',' ','l','i','s','t','e','n',' ','\x86','s','p','e','a','k',' ','o','u','t',' ','\x13','t','u','r','n',' ','\x7b',
/* 0x0ccb0 = "Exclusive semaphore is owned by another process." */
    'E','x','c','l','u','s','i','v','e',' ','\xea','\x09','o','w','n','e','d',' ','\xb9','a','n','o','t','h','e','r',' ','p','r','o','c','e','s','s','.',
/* 0x0ccd3 = "VERR_CR_PKIX_OSSL_CIPHER_ALGO_NOT_KNOWN_EVP" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','G','O','_','\x14','K','N','O','W','N','_','E','V','P',
/* 0x0ccf5 = "VERR_SYSTEM_INTEGRITY_POLICY_VIOLATION" */
    '\x01','S','Y','S','T','E','M','_','I','N','T','E','G','R','I','T','Y','_','P','O','L','I','C','Y','_','V','I','O','L','A','T','I','O','N',
/* 0x0cd17 = "Semaphore destroyed while waiting." */
    'S','e','m','a','p','h','o','r','e',' ','d','e','s','t','r','o','y','e','d',' ','w','h','i','l','e',' ','w','a','i','t','i','n','g','.',
/* 0x0cd39 = "The compression format version is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','f','o','r','m','a','t',' ','\xb4','\x09','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0cd5b = "Address family not supported by protocol family." */
    'A','d','d','r','e','s','s',' ','f','a','m','i','l','y',' ','\x05','\xf9','\xb9','p','r','o','t','o','c','o','l',' ','f','a','m','i','l','y','.',
/* 0x0cd7d = "The size of the raw optical image is too small (<= 32K)." */
    '\x03','\xf8','\x13','\x02','r','a','w',' ','o','p','t','i','c','a','l',' ','\x1a','\x09','\x8c','s','m','a','l','l',' ','(','<','=',' ','3','2','K',')','.',
/* 0x0cd9f = "Invalid ASN.1 OBJECT IDENTIFIER encoding." */
    '\x0b','A','S','N','.','1',' ','O','B','J','E','C','T',' ','I','D','E','N','T','I','F','I','E','R',' ','e','n','c','o','d','i','n','g','.',
/* 0x0cdc1 = "Import ISO contains more than one primary volume descriptor." */
    '\xaf','\xb2',' ','\x7f','\xf6','t','h','a','n',' ','o','n','e',' ','p','r','i','m','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0cde3 = "The table of content XML document does not have a toc element." */
    '\x03','\x9e','\x13','\xd8','X','M','L',' ','d','o','c','u','m','e','n','t',' ','\x9c','\x05','\xeb','a',' ','t','o','c',' ','e','l','e','m','e','n','t','.',
/* 0x0ce05 = "The request could not be canceled because it already completed." */
    '\x03','\x94','c','o','u','l','d',' ','\x05','\x90','c','a','n','c','e','l','e','d',' ','\x1c','i','t',' ','\x22','c','o','m','p','l','e','t','e','d','.',
/* 0x0ce27 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_CONTINUATION_EOS" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','C','O','N','T','I','N','U','A','T','I','O','N','_','E','O','S',
/* 0x0ce49 = "VERR_ISOMK_BOOT_CAT_EXPECTED_SECTION_HEADER" */
    '\x01','\xaa','B','O','O','T','_','C','A','T','_','E','X','P','E','C','T','E','D','_','S','E','C','T','I','O','N','_','H','E','A','D','E','R',
/* 0x0ce6b = "The data in the saved state doesn't conform to expectations." */
    '\x03','\x8f','\x0d','\x02','s','a','v','e','d',' ','\xb0','\xa5','c','o','n','f','o','r','m',' ','\x08','e','x','p','e','c','t','a','t','i','o','n','s','.',
/* 0x0ce8d = "There is not enough data to satisfy the request." */
    'T','h','e','r','e',' ','\x09','\x05','e','n','o','u','g','h',' ','\x8f','\x08','s','a','t','i','s','f','y',' ','\x02','r','e','q','u','e','s','t','.',
/* 0x0ceaf = "Internal ISO maker error: Finalization problem #1." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','F','i','n','a','l','i','z','a','t','i','o','n',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0ced1 = "VERR_CR_X509_TBSCERT_DUPLICATE_EXTENSION" */
    '\x01','\xa9','X','5','0','9','_','T','B','S','C','E','R','T','_','D','U','P','L','I','C','A','T','E','_','E','X','T','E','N','S','I','O','N',
/* 0x0cef3 = "The initialization of the dynamic mapping cache failed." */
    '\x03','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x13','\x02','d','y','n','a','m','i','c',' ','\xe0','c','a','c','h','e',' ','\x24',
/* 0x0cf15 = "VERR_CR_PKIX_SIGNATURE_TAKES_NO_PARAMETERS" */
    '\x01','\xa9','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','T','A','K','E','S','_','\xb7','P','A','R','A','M','E','T','E','R','S',
/* 0x0cf37 = "Internal error, VRDP packet is in wrong operation mode." */
    '\x06','e','r','r','o','r',',',' ','V','R','D','P',' ','p','a','c','k','e','t',' ','\x09','\x0d','w','r','o','n','g',' ','\x83','m','o','d','e','.',
/* 0x0cf59 = "The file contained a data unit which no-one wants." */
    '\x03','\x18','c','o','n','t','a','i','n','e','d',' ','a',' ','\x8f','u','n','i','t',' ','\xc0','n','o','-','o','n','e',' ','w','a','n','t','s','.',
/* 0x0cf7b = "The image is the correct format but is corrupted." */
    '\x03','\x1a','\x09','\x02','c','o','r','r','e','c','t',' ','f','o','r','m','a','t',' ','b','u','t',' ','\x09','c','o','r','r','u','p','t','e','d','.',
/* 0x0cf9d = "NtSetInformationObject/NoInherit failed." */
    'N','t','S','e','t','I','n','f','o','r','m','a','t','i','o','n','O','b','j','e','c','t','/','N','o','I','n','h','e','r','i','t',' ','\x24',
/* 0x0cfbf = "One or the PDPEs specified memory we don\'t know about." */
    'O','n','e',' ','\x86','\x02','P','D','P','E','s',' ','\x16','\x5c','w','e',' ','d','o','n','\'','t',' ','k','n','o','w',' ','a','b','o','u','t','.',
/* 0x0cfe1 = "VRDP thread has started OK and will run." */
    'V','R','D','P',' ','t','h','r','e','a','d',' ','\x1d','s','t','a','r','t','e','d',' ','O','K',' ','\x2a','w','i','l','l',' ','r','u','n','.',
/* 0x0d003 = "Found something which isn\'t a file nor a directory (hardening)." */
    'F','o','u','n','d',' ','s','o','m','e','t','h','i','n','g',' ','\xc0','i','s','n','\'','t',' ','a',' ','\x18','n','o','r',' ','a',' ','\x1b','\x9a',
/* 0x0d025 = "VERR_REST_RESPONSE_REPEAT_HEADER_FIELD" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','R','E','P','E','A','T','_','H','E','A','D','E','R','_','F','I','E','L','D',
/* 0x0d047 = "Process Verification Failure: No NTDLL.DLL mapping found. This is impossible." */
    '\x17','\x0c','\x12','\xd0','N','T','D','L','L','.','D','L','L',' ','\xe0','\x7d',' ','T','h','i','s',' ','\x09','i','m','p','o','s','s','i','b','l','e','.',
/* 0x0d069 = "Process Verification Failure: The name of an image file changes between mapping regions." */
    '\x17','\x0c','\x12','\x03','\xf3','\x13','\x60','\x1a','\x18','c','h','a','n','g','e','s',' ','b','e','t','w','e','e','n',' ','\xe0','r','e','g','i','o','n','s','.',
/* 0x0d08b = "Reason for leaving RC: int3 with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','i','n','t','3',' ','\x1e','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d0ad = "The integer value was too big for the requested representation." */
    '\x03','i','n','t','e','g','e','r',' ','\xd2','\x10','\x8c','b','i','g',' ','\x0e','\x02','\xbf','r','e','p','r','e','s','e','n','t','a','t','i','o','n','.',
/* 0x0d0cf = "VERR_PDM_MISCONFIGURED_DRV_TRANSFORMATION" */
    '\x01','\xb8','M','I','S','C','O','N','F','I','G','U','R','E','D','_','D','R','V','_','T','R','A','N','S','F','O','R','M','A','T','I','O','N',
/* 0x0d0f1 = "Host is about to go into suspend mode." */
    'H','o','s','t',' ','\x09','a','b','o','u','t',' ','\x08','g','o',' ','i','n','t','o',' ','s','u','s','p','e','n','d',' ','m','o','d','e','.',
/* 0x0d113 = "VERR_CPUM_INCOMPATIBLE_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x0d135 = "VERR_CR_PKIX_OSSL_VS_IPRT_SIGNATURE_SIZE" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','V','S','_','I','P','R','T','_','S','I','G','N','A','T','U','R','E','_','S','I','Z','E',
/* 0x0d157 = "Process Verification Failure: Expected the process and exe to have dynamic base enabled." */
    '\x17','\x0c','\x12','\xa6','\x02','\x82','\x2a','e','x','e',' ','\x08','\xeb','d','y','n','a','m','i','c',' ','b','a','s','e',' ','e','n','a','b','l','e','d','.',
/* 0x0d179 = "Internal ISO maker error: Rock ridge read problem." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','R','o','c','k',' ','r','i','d','g','e',' ','r','e','a','d',' ','p','r','o','b','l','e','m','.',
/* 0x0d19b = "VERR_ASN1_CURSOR_ILLEGAL_INDEFINITE_LENGTH" */
    '\x01','\xf2','C','U','R','S','O','R','_','I','L','L','E','G','A','L','_','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x0d1bd = "VERR_DBGC_PARSE_UNBALANCED_PARENTHESIS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','U','N','B','A','L','A','N','C','E','D','_','P','A','R','E','N','T','H','E','S','I','S',
/* 0x0d1df = "The maximum posts for the event semaphore has been reached." */
    '\x03','m','a','x','i','m','u','m',' ','p','o','s','t','s',' ','\x0e','\x02','e','v','e','n','t',' ','\xea','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x0d201 = "VERR_FDT_DTB_STRINGS_BLOCK_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','S','T','R','I','N','G','S','_','B','L','O','C','K','_','\x14','T','E','R','M','I','N','A','T','E','D',
/* 0x0d223 = "No space for rock ridge \'CE\' entry in directory record." */
    '\xd0','s','p','a','c','e',' ','\x0e','r','o','c','k',' ','r','i','d','g','e',' ','\'','C','E','\'',' ','\xb5','\x0d','\x1b','r','e','c','o','r','d','.',
/* 0x0d245 = "ROM page mismatch between saved state and the VM." */
    'R','O','M',' ','\xb6','m','i','s','m','a','t','c','h',' ','b','e','t','w','e','e','n',' ','s','a','v','e','d',' ','\xb0','\x2a','\x02','V','M','.',
/* 0x0d267 = "Couldn\'t map pages during receive." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','r','e','c','e','i','v','e','.',
/* 0x0d289 = "Invalid selector. Usually beyond table limits." */
    '\x0b','s','e','l','e','c','t','o','r','.',' ','U','s','u','a','l','l','y',' ','b','e','y','o','n','d',' ','\x9e','l','i','m','i','t','s','.',
/* 0x0d2ab = "Long ASN.1 tag form is not implemented." */
    'L','o','n','g',' ','A','S','N','.','1',' ','t','a','g',' ','f','o','r','m',' ','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x0d2cd = "Already aliased to a different page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x08','a',' ','d','i','f','f','e','r','e','n','t',' ','p','a','g','e','.',
/* 0x0d2ef = "Type error opening the ApiPort LPC object." */
    'T','y','p','e',' ','\x07','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0d311 = "Import ISO contains a root directory with an out of bounds data extent." */
    '\xaf','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x1b','\x1e','\x60','o','u','t',' ','\x13','b','o','u','n','d','s',' ','\x8f','e','x','t','e','n','t','.',
/* 0x0d333 = "Invalid VMCS index or write to read-only element." */
    '\x0b','V','M','C','S',' ','i','n','d','e','x',' ','\x86','w','r','i','t','e',' ','\x08','r','e','a','d','-','\xf7','e','l','e','m','e','n','t','.',
/* 0x0d355 = "VERR_LDRVI_PAGE_HASH_TAB_SIZE_OVERFLOW" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','S','I','Z','E','_','O','V','E','R','F','L','O','W',
/* 0x0d377 = "Pending stream disable operation in progress." */
    'P','e','n','d','i','n','g',' ','s','t','r','e','a','m',' ','d','i','s','a','b','l','e',' ','\x83','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x0d399 = "Import ISO contains a root directory with a bad record length." */
    '\xaf','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x1b','\x1e','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x0d3ba = "Empty sub-string set inside X.509 name." */
    'E','m','p','t','y',' ','s','u','b','-','\xc7','s','e','t',' ','i','n','s','i','d','e',' ','X','.','5','0','9',' ','n','a','m','e','.',
/* 0x0d3db = "iSCSI: Operation can\'t be done in current image state." */
    'i','S','C','S','I',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x90','d','o','n','e',' ','\x0d','\xd1','\x1a','\xf5',
/* 0x0d3fc = "A required query parameter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','q','u','e','r','y',' ','p','a','r','a','m','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x0d41d = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_HEADER_ID" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','H','E','A','D','E','R','_','I','D',
/* 0x0d43e = "The process specified to a non-block wait had not exited." */
    '\x03','\x82','\x16','\x08','a',' ','n','o','n','-','b','l','o','c','k',' ','w','a','i','t',' ','h','a','d',' ','\x05','e','x','i','t','e','d','.',
/* 0x0d45f = "Error reading a certificate in PEM format from BIO." */
    '\xac','r','e','a','d','i','n','g',' ','a',' ','\x8a','\x0d','P','E','M',' ','f','o','r','m','a','t',' ','f','r','o','m',' ','B','I','O','.',
/* 0x0d480 = "Generic BER parse error. Will be refined later." */
    '\x96','B','E','R',' ','p','a','r','s','e',' ','\x7b',' ','W','i','l','l',' ','\x90','r','e','f','i','n','e','d',' ','l','a','t','e','r','.',
/* 0x0d4a1 = "Invalid ASN.1 PRINTABLE STRING encoding." */
    '\x0b','A','S','N','.','1',' ','P','R','I','N','T','A','B','L','E',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0d4c2 = "Couldn\'t find MMIO2 page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xb6','f','r','o','m',' ','s','a','v','e','d',' ','\xf5',
/* 0x0d4e3 = "Invalid or unsupported logical block size." */
    '\x0b','\x86','u','n','s','u','p','p','o','r','t','e','d',' ','l','o','g','i','c','a','l',' ','b','l','o','c','k',' ','s','i','z','e','.',
/* 0x0d504 = "Can\'t free the memory because it\'s used in mapping." */
    'C','a','n','\'','t',' ','f','r','e','e',' ','\x02','\x5c','\x1c','i','t','\'','s',' ','u','s','e','d',' ','\x0d','m','a','p','p','i','n','g','.',
/* 0x0d525 = "VERR_PDM_CANNOT_TRANSFORM_REMOVED_DRIVER" */
    '\x01','\xb8','C','A','N','N','O','T','_','T','R','A','N','S','F','O','R','M','_','R','E','M','O','V','E','D','_','D','R','I','V','E','R',
/* 0x0d546 = "Process Verification Failure: Unexpected section protection flag combination." */
    '\x17','\x0c','\x12','\x85','\xc6','p','r','o','t','e','c','t','i','o','n',' ','f','l','a','g',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x0d567 = "Process Verification Failure: Error determining the full path of System32." */
    '\x17','\x0c','\x12','\xac','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','f','u','l','l',' ','\xbb','\x13','S','y','s','t','e','m','3','2','.',
/* 0x0d588 = "Malformed code signing structure." */
    'M','a','l','f','o','r','m','e','d',' ','c','o','d','e',' ','s','i','g','n','i','n','g',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x0d5a9 = "VERR_FILE_AIO_INSUFFICIENT_RESSOURCES" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','R','E','S','S','O','U','R','C','E','S',
/* 0x0d5ca = "Unknown escape sequence encountered in TeletexString." */
    '\xdf','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\x98','\x0d','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0d5eb = "Software caused connection abort." */
    'S','o','f','t','w','a','r','e',' ','c','a','u','s','e','d',' ','c','o','n','n','e','c','t','i','o','n',' ','a','b','o','r','t','.',
/* 0x0d60c = "VERR_REST_WRONG_JSON_TYPE_FOR_INTEGER" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','I','N','T','E','G','E','R',
/* 0x0d62d = "VERR_X509_GETTING_EXTENSION_FROM_CERT" */
    '\x01','X','5','0','9','_','G','E','T','T','I','N','G','_','E','X','T','E','N','S','I','O','N','_','F','R','O','M','_','C','E','R','T',
/* 0x0d64e = "Import ISO contains more than one joliet volume descriptor." */
    '\xaf','\xb2',' ','\x7f','\xf6','t','h','a','n',' ','o','n','e',' ','j','o','l','i','e','t',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0d66f = "NEM failed to create a native VM instance." */
    'N','E','M',' ','\x88','\x08','c','r','e','a','t','e',' ','a',' ','n','a','t','i','v','e',' ','\xcf',' ','i','n','s','t','a','n','c','e','.',
/* 0x0d690 = "Reason for leaving RC: #PF with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','#','P','F',' ','\x1e','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d6b1 = "Couldn\'t find MMIO2 range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','M','M','I','O','2',' ','\xe4','f','r','o','m',' ','s','a','v','e','d',' ','\xf5',
/* 0x0d6d2 = "VERR_REST_RESPONSE_EMBEDDED_ZERO_CHAR" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','E','M','B','E','D','D','E','D','_','Z','E','R','O','_','C','H','A','R',
/* 0x0d6f3 = "Attempted to enabled a breakpoint which was already enabled." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','e','n','a','b','l','e','d',' ','a',' ','\xab','\xc0','\x10','\x22','e','n','a','b','l','e','d','.',
/* 0x0d714 = "The ELF loader doesn't handle foreign endianness." */
    '\x03','E','L','F',' ','\xc4','\xa5','h','a','n','d','l','e',' ','f','o','r','e','i','g','n',' ','e','n','d','i','a','n','n','e','s','s','.',
/* 0x0d735 = "Can\'t send after socket shutdown." */
    'C','a','n','\'','t',' ','s','e','n','d',' ','a','f','t','e','r',' ','s','o','c','k','e','t',' ','s','h','u','t','d','o','w','n','.',
/* 0x0d756 = "Entry in a boot catalog section is another section." */
    'E','n','t','r','y',' ','\x0d','a',' ','b','o','o','t',' ','\xcd','\xc6','\x09','a','n','o','t','h','e','r',' ','s','e','c','t','i','o','n','.',
/* 0x0d777 = "VERR_SUP_VP_NOT_VALID_KERNEL_CODE_SIGNATURE" */
    '\x01','\xe6','V','P','_','\x14','V','A','L','I','D','_','K','E','R','N','E','L','_','C','O','D','E','_','S','I','G','N','A','T','U','R','E',
/* 0x0d798 = "Reason for leaving RC: #GP with EIP pointing to patch code." */
    '\x84','\x0e','\x25','R','C',':',' ','#','G','P',' ','\x1e','E','I','P',' ','p','o','i','n','t','i','n','g',' ','\x08','p','a','t','c','h',' ','\x5e',
/* 0x0d7b9 = "Unsupported escape sequence encountered in TeletexString." */
    '\x87','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e',' ','\x98','\x0d','T','e','l','e','t','e','x','S','t','r','i','n','g','.',
/* 0x0d7da = "OpenSSL failed to decode the key parameters." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','k','e','y',' ','p','a','r','a','m','e','t','e','r','s','.',
/* 0x0d7fb = "Page not marked for dirty bit tracking." */
    'P','a','g','e',' ','\x05','m','a','r','k','e','d',' ','\x0e','d','i','r','t','y',' ','b','i','t',' ','t','r','a','c','k','i','n','g','.',
/* 0x0d81c = "VERR_CR_PKCS7_SIGNED_DATA_NO_DIGEST_ALGOS" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','\xb7','D','I','G','E','S','T','_','A','L','G','O','S',
/* 0x0d83d = "VERR_X509_GETTING_DATA_FROM_EXTENSION" */
    '\x01','X','5','0','9','_','G','E','T','T','I','N','G','_','D','A','T','A','_','F','R','O','M','_','E','X','T','E','N','S','I','O','N',
/* 0x0d85e = "Error extracting RSA from the public key." */
    '\xac','e','x','t','r','a','c','t','i','n','g',' ','R','S','A',' ','f','r','o','m',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x0d87f = "Virtual machine error occurred attempting the operation." */
    '\xe2',' ','m','a','c','h','i','n','e',' ','\x07','o','c','c','u','r','r','e','d',' ','a','t','t','e','m','p','t','i','n','g',' ','\x02','\xcc',
/* 0x0d8a0 = "VERR_X509_EXTRACT_RSA_FROM_PUBLIC_KEY" */
    '\x01','X','5','0','9','_','E','X','T','R','A','C','T','_','R','S','A','_','F','R','O','M','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x0d8c1 = "Reason for leaving RC: duplicate instruction called at current eip." */
    '\x84','\x0e','\x25','R','C',':',' ','d','u','p','l','i','c','a','t','e',' ','\xba','c','a','l','l','e','d',' ','a','t',' ','\xd1','e','i','p','.',
/* 0x0d8e2 = "The logical volume descriptor has a too big partition map." */
    '\x03','l','o','g','i','c','a','l',' ','\xbd','\xd6','\x1d','a',' ','\x8c','b','i','g',' ','p','a','r','t','i','t','i','o','n',' ','m','a','p','.',
/* 0x0d903 = "Reason for leaving RC: #PF for monitored patch page." */
    '\x84','\x0e','\x25','R','C',':',' ','#','P','F',' ','\x0e','m','o','n','i','t','o','r','e','d',' ','p','a','t','c','h',' ','p','a','g','e','.',
/* 0x0d924 = "Invalid ASN.1 UNIVERSAL STRING encoding." */
    '\x0b','A','S','N','.','1',' ','U','N','I','V','E','R','S','A','L',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0d945 = "Reason for leaving RC: Interrupt pending (guest)." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','t','e','r','r','u','p','t',' ','p','e','n','d','i','n','g',' ','(','g','u','e','s','t',')','.',
/* 0x0d966 = "VERR_DBGF_BP_OWNER_CALLBACK_WRONG_STATUS" */
    '\x01','\xf1','_','B','P','_','O','W','N','E','R','_','C','A','L','L','B','A','C','K','_','W','R','O','N','G','_','S','T','A','T','U','S',
/* 0x0d987 = "Internal ISO maker error: Descriptor miscounting." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','D','e','s','c','r','i','p','t','o','r',' ','m','i','s','c','o','u','n','t','i','n','g','.',
/* 0x0d9a8 = "The session has no tracer associated with it." */
    '\x03','s','e','s','s','i','o','n',' ','\x1d','\xe9','t','r','a','c','e','r',' ','a','s','s','o','c','i','a','t','e','d',' ','\x1e','i','t','.',
/* 0x0d9c9 = "The networking interface to filter was not found." */
    '\x03','n','e','t','w','o','r','k','i','n','g',' ','i','n','t','e','r','f','a','c','e',' ','\x08','f','i','l','t','e','r',' ','\x10','\x05','\x7d',
/* 0x0d9ea = "There is not enough room to store the data." */
    'T','h','e','r','e',' ','\x09','\x05','e','n','o','u','g','h',' ','r','o','o','m',' ','\x08','s','t','o','r','e',' ','\x02','d','a','t','a','.',
/* 0x0da0b = "Invalid ASN.1 GENERALIZED TIME encoding." */
    '\x0b','A','S','N','.','1',' ','G','E','N','E','R','A','L','I','Z','E','D',' ','T','I','M','E',' ','e','n','c','o','d','i','n','g','.',
/* 0x0da2c = "Return to ring-3 to write the MSR there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','w','r','i','t','e',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0da4d = "Security (en/decryption) engine error." */
    'S','e','c','u','r','i','t','y',' ','(','e','n','/','d','e','c','r','y','p','t','i','o','n',')',' ','e','n','g','i','n','e',' ','\x7b',
/* 0x0da6e = "An operation caused a nested-guest SVM #VMEXIT." */
    'A','n',' ','\x83','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xa1','S','V','M',' ','#','V','M','E','X','I','T','.',
/* 0x0da8f = "VERR_CR_X509_NAME_MISSING_RDN_MAP_ENTRY" */
    '\x01','\xa9','X','5','0','9','_','N','A','M','E','_','M','I','S','S','I','N','G','_','R','D','N','_','M','A','P','_','E','N','T','R','Y',
/* 0x0dab0 = "A path does not start with a root specification." */
    'A',' ','\xbb','\x9c','\x05','s','t','a','r','t',' ','\x1e','a',' ','r','o','o','t',' ','s','p','e','c','i','f','i','c','a','t','i','o','n','.',
/* 0x0dad1 = "VERR_GETOPT_REQUIRED_ARGUMENT_MISSING" */
    '\x01','G','E','T','O','P','T','_','R','E','Q','U','I','R','E','D','_','A','R','G','U','M','E','N','T','_','M','I','S','S','I','N','G',
/* 0x0daf2 = "The compression method is unsupported." */
    '\x03','c','o','m','p','r','e','s','s','i','o','n',' ','m','e','t','h','o','d',' ','\x09','u','n','s','u','p','p','o','r','t','e','d','.',
/* 0x0db13 = "VERR_ISOMK_IMPORT_BOOT_CAT_MISSING_FINAL_OR_TOO_BIG" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','M','I','S','S','I','N','G','_','F','I','N','A','L','_','O','R','_','\x9f','B','I','G',
/* 0x0db34 = "VERR_SUP_VP_NOT_OWNED_BY_TRUSTED_INSTALLER" */
    '\x01','\xe6','V','P','_','\x14','O','W','N','E','D','_','B','Y','_','T','R','U','S','T','E','D','_','I','N','S','T','A','L','L','E','R',
/* 0x0db54 = "VERR_CR_PKCS7_EXPECTED_ONE_SIGNER_INFO" */
    '\x01','\xa9','P','K','C','S','7','_','E','X','P','E','C','T','E','D','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O',
/* 0x0db74 = "Invalid session ID in managed object reference." */
    '\x0b','s','e','s','s','i','o','n',' ','I','D',' ','\x0d','m','a','n','a','g','e','d',' ','\x8d','r','e','f','e','r','e','n','c','e','.',
/* 0x0db94 = "PDMVMMDevHeapR3ToGCPhys failure." */
    'P','D','M','V','M','M','D','e','v','H','e','a','p','R','3','T','o','G','C','P','h','y','s',' ','f','a','i','l','u','r','e','.',
/* 0x0dbb4 = "A file operation was attempted on a non-file object." */
    'A',' ','\x18','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x18','o','b','j','e','c','t','.',
/* 0x0dbd4 = "VERR_CR_PKCS7_SIGNATURE_VERIFICATION_FAILED" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','A','T','U','R','E','_','V','E','R','I','F','I','C','A','T','I','O','N','_','\x93',
/* 0x0dbf4 = "CAcert is missing or has the wrong format." */
    'C','A','c','e','r','t',' ','\x09','m','i','s','s','i','n','g',' ','\x86','\x1d','\x02','w','r','o','n','g',' ','f','o','r','m','a','t','.',
/* 0x0dc14 = "Certificate path validator: Invalid policy mapping (to/from anyPolicy)." */
    '\xa7','\xbb','\xe5','\x0b','p','o','l','i','c','y',' ','\xe0','(','t','o','/','f','r','o','m',' ','a','n','y','P','o','l','i','c','y',')','.',
/* 0x0dc34 = "Virtual address was not allocated by the library." */
    '\xe2',' ','a','d','d','r','e','s','s',' ','\x10','\x05','a','l','l','o','c','a','t','e','d',' ','\xb9','\x02','l','i','b','r','a','r','y','.',
/* 0x0dc54 = "VERR_ISOFS_INSUFFICIENT_DATA_FOR_DESC_CRC" */
    '\x01','\xfd','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A','_','F','O','R','_','D','E','S','C','_','C','R','C',
/* 0x0dc74 = "Missing length element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','l','e','n','g','t','h',' ','\x1f','\x0d','\x9e','\x13','\xd8','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0dc94 = "Precodition no 2 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','2',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0dcb4 = "Asynchronous I/O is not finished yet." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x09','\x05','f','i','n','i','s','h','e','d',' ','y','e','t','.',
/* 0x0dcd4 = "A non-file operation was attempted on a file object." */
    'A',' ','n','o','n','-','\x18','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x18','o','b','j','e','c','t','.',
/* 0x0dcf4 = "Certificate extensions requires certificate version 3 or later." */
    '\xa7','e','x','t','e','n','s','i','o','n','s',' ','r','e','q','u','i','r','e','s',' ','\x8a','\xb4','3',' ','\x86','l','a','t','e','r','.',
/* 0x0dd14 = "Missing offset element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','o','f','f','s','e','t',' ','\x1f','\x0d','\x9e','\x13','\xd8','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x0dd34 = "VERR_HTTP_CACERT_CANNOT_AUTHENTICATE" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','C','A','N','N','O','T','_','A','U','T','H','E','N','T','I','C','A','T','E',
/* 0x0dd54 = "OpenSSL failed to initialize the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','i','n','i','t','i','a','l','i','z','e',' ','\x02','\xc2','\xbe','c','o','n','t','e','x','t','.',
/* 0x0dd74 = "The GIM provider does not support any hypercalls." */
    '\x03','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x9c','\x05','\xb1','a','n','y',' ','h','y','p','e','r','c','a','l','l','s','.',
/* 0x0dd94 = "Import ISO contains a zero sized root directory." */
    '\xaf','\xb2',' ','\x7f','a',' ','z','e','r','o',' ','s','i','z','e','d',' ','r','o','o','t',' ','d','i','r','e','c','t','o','r','y','.',
/* 0x0ddb4 = "VERR_RT_REQUEST_STATUS_STILL_PENDING" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0ddd4 = "Stack overflow during AVL tree operation." */
    'S','t','a','c','k',' ','o','v','e','r','f','l','o','w',' ','d','u','r','i','n','g',' ','A','V','L',' ','t','r','e','e',' ','\xcc',
/* 0x0ddf4 = "Failed to open underlying link instance." */
    '\x80','\x08','o','p','e','n',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','i','n','s','t','a','n','c','e','.',
/* 0x0de14 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_CHECKSUM" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','C','H','E','C','K','S','U','M',
/* 0x0de34 = "Signed data verification failed due to key usage issues." */
    'S','i','g','n','e','d',' ','\x8f','\xd5','\x88','d','u','e',' ','\x08','k','e','y',' ','u','s','a','g','e',' ','i','s','s','u','e','s','.',
/* 0x0de54 = "The network is busy or is out of resources." */
    '\x03','n','e','t','w','o','r','k',' ','\x09','b','u','s','y',' ','\x86','\x09','o','u','t',' ','\x13','r','e','s','o','u','r','c','e','s','.',
/* 0x0de74 = "Return to ring-3 to read the MSR there." */
    'R','e','t','u','r','n',' ','\x08','r','i','n','g','-','3',' ','\x08','r','e','a','d',' ','\x02','M','S','R',' ','t','h','e','r','e','.',
/* 0x0de94 = "Path to child node was invalid (i.e. empty)." */
    'P','a','t','h',' ','\x08','c','h','i','l','d',' ','n','o','d','e',' ','\x10','\x81','(','i','.','e','.',' ','e','m','p','t','y',')','.',
/* 0x0deb4 = "An invalid I/O port size was specified for a read or write operation." */
    'A','n',' ','\x81','I','/','O',' ','p','o','r','t',' ','\xf8','\x10','\x16','\x0e','a',' ','r','e','a','d',' ','\x86','w','r','i','t','e',' ','\xcc',
/* 0x0ded4 = "The handle ID is already present in the poll set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x09','\x22','p','r','e','s','e','n','t',' ','\x0d','\x02','p','o','l','l',' ','s','e','t','.',
/* 0x0def4 = "Warning X509 certificate isn\'t self signed." */
    'W','a','r','n','i','n','g',' ','X','5','0','9',' ','\x8a','i','s','n','\'','t',' ','s','e','l','f',' ','s','i','g','n','e','d','.',
/* 0x0df14 = "Too many calls to the service from a client." */
    '\xf0','\xa3','c','a','l','l','s',' ','\x08','\x02','s','e','r','v','i','c','e',' ','f','r','o','m',' ','a',' ','c','l','i','e','n','t','.',
/* 0x0df34 = "Termination record CRC mismatch." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x0df54 = "The file is not a valid /proc/kallsyms file." */
    '\x03','\x18','\x09','\x05','a',' ','v','a','l','i','d',' ','/','p','r','o','c','/','k','a','l','l','s','y','m','s',' ','f','i','l','e','.',
/* 0x0df74 = "Precodition no 0 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','0',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0df94 = "Unsupported domain ID in logical volume descriptor." */
    '\x87','d','o','m','a','i','n',' ','I','D',' ','\x0d','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0dfb4 = "VERR_REST_WRONG_JSON_TYPE_FOR_DOUBLE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','D','O','U','B','L','E',
/* 0x0dfd4 = "GVMM ran into some broken IPRT code." */
    'G','V','M','M',' ','r','a','n',' ','i','n','t','o',' ','s','o','m','e',' ','b','r','o','k','e','n',' ','I','P','R','T',' ','\x5e',
/* 0x0dff4 = "FAM failed to add a directory to the list to be monitored." */
    'F','A','M',' ','\x88','\x08','a','d','d',' ','a',' ','\x1b','\x08','\x02','l','i','s','t',' ','\x08','\x90','m','o','n','i','t','o','r','e','d','.',
/* 0x0e014 = "HMR0Leave was called on the wrong CPU." */
    'H','M','R','0','L','e','a','v','e',' ','\x10','c','a','l','l','e','d',' ','o','n',' ','\x02','w','r','o','n','g',' ','C','P','U','.',
/* 0x0e034 = "VERR_TRACELOG_READER_LOG_UNSUPPORTED" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','L','O','G','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x0e054 = "Invalid ASN.1 VIDEOTEX STRING encoding." */
    '\x0b','A','S','N','.','1',' ','V','I','D','E','O','T','E','X',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0e074 = "FAM failed to add a file to the list to be monitored." */
    'F','A','M',' ','\x88','\x08','a','d','d',' ','a',' ','\x18','\x08','\x02','l','i','s','t',' ','\x08','\x90','m','o','n','i','t','o','r','e','d','.',
/* 0x0e094 = "The remote host couldn\'t be resolved." */
    '\x03','r','e','m','o','t','e',' ','h','o','s','t',' ','c','o','u','l','d','n','\'','t',' ','\x90','r','e','s','o','l','v','e','d','.',
/* 0x0e0b4 = "Data connection limit has been reached." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','l','i','m','i','t',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x0e0d4 = "No 32-bit to 64-bit switcher in place." */
    '\xd0','3','2','-','b','i','t',' ','\x08','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r',' ','\x0d','p','l','a','c','e','.',
/* 0x0e0f4 = "Send pagefault timeout in receive." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0d','r','e','c','e','i','v','e','.',
/* 0x0e114 = "VRDP script has completed its task." */
    'V','R','D','P',' ','s','c','r','i','p','t',' ','\x1d','c','o','m','p','l','e','t','e','d',' ','i','t','s',' ','t','a','s','k','.',
/* 0x0e134 = "A non-directory operation was attempted on a directory object." */
    'A',' ','n','o','n','-','\x1b','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','\x1b','o','b','j','e','c','t','.',
/* 0x0e154 = "File set descriptor has a next extent member." */
    'F','i','l','e',' ','s','e','t',' ','\xd6','\x1d','a',' ','n','e','x','t',' ','e','x','t','e','n','t',' ','m','e','m','b','e','r','.',
/* 0x0e174 = "VERR_PATH_MATCH_FEATURE_NOT_IMPLEMENTED" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','F','E','A','T','U','R','E','_','\x14','I','M','P','L','E','M','E','N','T','E','D',
/* 0x0e194 = "Invalid operand size passed to an IEM function." */
    '\x0b','o','p','e','r','a','n','d',' ','\xf8','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0e1b4 = "The checksum of a tar header record doesn't match." */
    '\x03','c','h','e','c','k','s','u','m',' ','\x13','a',' ','t','a','r',' ','\xa2','r','e','c','o','r','d',' ','\xa5','m','a','t','c','h','.',
/* 0x0e1d4 = "VERR_FDT_DTB_PROP_STRING_NOT_TERMINATED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','S','T','R','I','N','G','_','\x14','T','E','R','M','I','N','A','T','E','D',
/* 0x0e1f4 = "VERR_SUP_VP_FOUND_MORE_THAN_ONE_EXE_MAPPING" */
    '\x01','\xe6','V','P','_','\xb3','_','M','O','R','E','_','T','H','A','N','_','O','N','E','_','E','X','E','_','M','A','P','P','I','N','G',
/* 0x0e214 = "Recompiler: Out of memory for the instruction buffer (regular heap)." */
    '\x11','O','u','t',' ','\x13','\x5c','\x0e','\x02','\xba','b','u','f','f','e','r',' ','(','r','e','g','u','l','a','r',' ','h','e','a','p',')','.',
/* 0x0e234 = "The disk has a cache attached already." */
    '\x03','d','i','s','k',' ','\x1d','a',' ','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','a','l','r','e','a','d','y','.',
/* 0x0e254 = "VERR_GMM_MEMORY_RESERVATION_DECLINED" */
    '\x01','G','M','M','_','M','E','M','O','R','Y','_','R','E','S','E','R','V','A','T','I','O','N','_','D','E','C','L','I','N','E','D',
/* 0x0e274 = "Precodition no 1 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','1',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e294 = "Process Verification Failure: Error querying thread information." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','t','h','r','e','a','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0e2b4 = "The DTB structs block contains an invalid node name." */
    '\x03','D','T','B',' ','s','t','r','u','c','t','s',' ','b','l','o','c','k',' ','\x7f','\x60','\x81','n','o','d','e',' ','n','a','m','e','.',
/* 0x0e2d4 = "The size of the raw floppy image is too big (>2.88MB)." */
    '\x03','\xf8','\x13','\x02','r','a','w',' ','f','l','o','p','p','y',' ','\x1a','\x09','\x8c','b','i','g',' ','(','>','2','.','8','8','M','B',')','.',
/* 0x0e2f4 = "The VTG object for the session or image has already been registered." */
    '\x03','V','T','G',' ','\x8d','\x0e','\x02','s','e','s','s','i','o','n',' ','\x86','\x1a','\x1d','\x22','\xad','r','e','g','i','s','t','e','r','e','d','.',
/* 0x0e314 = "VERR_CR_X509_CPV_MISSING_KEY_CERT_SIGN" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','M','I','S','S','I','N','G','_','K','E','Y','_','C','E','R','T','_','S','I','G','N',
/* 0x0e334 = "VERR_ISOMK_IMPORT_ROOT_DIR_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\xaa','\xd4','R','O','O','T','_','D','I','R','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0e354 = "The volume map doesn't contain any valid volume." */
    '\x03','\xbd','m','a','p',' ','\xa5','c','o','n','t','a','i','n',' ','a','n','y',' ','v','a','l','i','d',' ','v','o','l','u','m','e','.',
/* 0x0e374 = "VERR_GMM_SHARED_MODULE_ADDRESS_CLASH" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','A','D','D','R','E','S','S','_','C','L','A','S','H',
/* 0x0e394 = "VERR_CR_X509_TBSCERT_UNIQUE_IDS_REQ_V2" */
    '\x01','\xa9','X','5','0','9','_','T','B','S','C','E','R','T','_','U','N','I','Q','U','E','_','I','D','S','_','R','E','Q','_','V','2',
/* 0x0e3b4 = "Precodition no 3 in hmR0VMXStartVm failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','3',' ','\x0d','h','m','R','0','V','M','X','S','t','a','r','t','V','m',' ','\x24',
/* 0x0e3d4 = "validation of the loader section (in the LX header) failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x13','\x02','\xc4','\xc6','(','i','n',' ','\x02','L','X',' ','h','e','a','d','e','r',')',' ','\x24',
/* 0x0e3f4 = "Bad UTF-16 surrogate pair sequence." */
    '\x92','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r',' ','s','e','q','u','e','n','c','e','.',
/* 0x0e414 = "VERR_REST_WRONG_JSON_TYPE_FOR_STRING" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','S','T','R','I','N','G',
/* 0x0e434 = "Syntax error - too many arguments for static storage." */
    '\xe1','\x07','-',' ','\x8c','\xa3','a','r','g','u','m','e','n','t','s',' ','\x0e','s','t','a','t','i','c',' ','s','t','o','r','a','g','e','.',
/* 0x0e454 = "Internal ISO maker error: Buggy namespace table." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','B','u','g','g','y',' ','n','a','m','e','s','p','a','c','e',' ','t','a','b','l','e','.',
/* 0x0e474 = "VERR_SUP_VP_EXE_MISSING_FORCE_INTEGRITY" */
    '\x01','\xe6','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','F','O','R','C','E','_','I','N','T','E','G','R','I','T','Y',
/* 0x0e494 = "A directory operation was attempted on a non-directory object." */
    'A',' ','\x1b','\x83','\x10','a','t','t','e','m','p','t','e','d',' ','o','n',' ','a',' ','n','o','n','-','\x1b','o','b','j','e','c','t','.',
/* 0x0e4b4 = "Descriptor tag sector number mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','s','e','c','t','o','r',' ','\xdd','m','i','s','m','a','t','c','h','.',
/* 0x0e4d4 = "Internal ISO maker error: Boot catalog file handle problem." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','B','o','o','t',' ','\xcd','\x18','h','a','n','d','l','e',' ','p','r','o','b','l','e','m','.',
/* 0x0e4f4 = "VMDK: Operation can\'t be done in current image state." */
    'V','M','D','K',':',' ','O','p','e','r','a','t','i','o','n',' ','c','a','n','\'','t',' ','\x90','d','o','n','e',' ','\x0d','\xd1','\x1a','\xf5',
/* 0x0e514 = "VINF_IOMMU_ADDR_TRANSLATION_DISABLED" */
    '\x19','I','O','M','M','U','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','D','I','S','A','B','L','E','D',
/* 0x0e534 = "Too long forwarder chain or there is a loop." */
    '\xf0','l','o','n','g',' ','f','o','r','w','a','r','d','e','r',' ','\x91','\x86','t','h','e','r','e',' ','\x09','a',' ','l','o','o','p','.',
/* 0x0e554 = "VERR_GSTCTL_MAX_CID_SESSIONS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','S','E','S','S','I','O','N','S','_','R','E','A','C','H','E','D',
/* 0x0e574 = "No unwind information for the specified location." */
    '\xd0','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x0e','\x02','\x16','l','o','c','a','t','i','o','n','.',
/* 0x0e594 = "VERR_GMM_SHARED_MODULE_BAD_REGIONS_SIZE" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xa0','R','E','G','I','O','N','S','_','S','I','Z','E',
/* 0x0e5b4 = "Encountered an unsupported GNU Tar extension." */
    '\x97','\x60','u','n','s','u','p','p','o','r','t','e','d',' ','G','N','U',' ','T','a','r',' ','e','x','t','e','n','s','i','o','n','.',
/* 0x0e5d4 = "VERR_CR_SPC_PEIMAGE_MULTIPLE_HASH_TABS" */
    '\x01','\xa9','S','P','C','_','P','E','I','M','A','G','E','_','M','U','L','T','I','P','L','E','_','H','A','S','H','_','T','A','B','S',
/* 0x0e5f4 = "Incompatible CPUM configuration." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','C','P','U','M',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x0e614 = "Invalid ASN.1 GENERAL STRING encoding." */
    '\x0b','A','S','N','.','1',' ','G','E','N','E','R','A','L',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0e633 = "Invalid instruction length passed to an IEM function." */
    '\x0b','\xba','l','e','n','g','t','h',' ','p','a','s','s','e','d',' ','\x08','\x60','I','E','M',' ','f','u','n','c','t','i','o','n','.',
/* 0x0e652 = "Bad VTG header - size value is not a multiple of the structure size." */
    '\x92','V','T','G',' ','\xa2','-',' ','\xf8','\xd2','\x09','\x05','a',' ','m','u','l','t','i','p','l','e',' ','\x13','\x02','\xc1','s','i','z','e','.',
/* 0x0e671 = "VERR_ISOMK_IMPORT_MISMATCHING_MULTI_EXTENT_REC" */
    '\x01','\xaa','\xd4','M','I','S','M','A','T','C','H','I','N','G','_','M','U','L','T','I','_','E','X','T','E','N','T','_','R','E','C',
/* 0x0e690 = "Internal processing error in the PGM physical RAM range lookup code." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','R','A','M',' ','\xe4','l','o','o','k','u','p',' ','\x5e',
/* 0x0e6af = "VERR_IEM_FIXUP_SHORT_JMP_TO_TAIL_LABEL" */
    '\x01','\xee','F','I','X','U','P','_','S','H','O','R','T','_','J','M','P','_','T','O','_','T','A','I','L','_','L','A','B','E','L',
/* 0x0e6ce = "Missing encoding element for XAR data stream." */
    'M','i','s','s','i','n','g',' ','e','n','c','o','d','i','n','g',' ','\x1f','\x0e','X','A','R',' ','\x8f','s','t','r','e','a','m','.',
/* 0x0e6ed = "Unsupported interface for managed object reference." */
    '\x87','i','n','t','e','r','f','a','c','e',' ','\x0e','m','a','n','a','g','e','d',' ','\x8d','r','e','f','e','r','e','n','c','e','.',
/* 0x0e70c = "VWRN_RECORDING_ENCODING_SKIPPED" */
    'V','W','R','N','_','R','E','C','O','R','D','I','N','G','_','E','N','C','O','D','I','N','G','_','S','K','I','P','P','E','D',
/* 0x0e72b = "Concurrent access to the object is not allowed." */
    'C','o','n','c','u','r','r','e','n','t',' ','a','c','c','e','s','s',' ','\x08','\x02','\x8d','\x09','\x05','a','l','l','o','w','e','d','.',
/* 0x0e74a = "The ring-0 function is not supported for this VM target." */
    '\x03','r','i','n','g','-','0',' ','f','u','n','c','t','i','o','n',' ','\x09','\x05','\xf9','\x0e','\xc9','\xcf',' ','t','a','r','g','e','t','.',
/* 0x0e769 = "Unknown character class in glob pattern." */
    '\xdf','c','h','a','r','a','c','t','e','r',' ','c','l','a','s','s',' ','\x0d','g','l','o','b',' ','p','a','t','t','e','r','n','.',
/* 0x0e788 = "Couldn\'t find ROM range from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xe4','f','r','o','m',' ','s','a','v','e','d',' ','\xf5',
/* 0x0e7a7 = "VERR_CR_PKIX_CIPHER_ALGO_PARAMS_NOT_IMPL" */
    '\x01','\xa9','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','P','A','R','A','M','S','_','\x14','I','M','P','L',
/* 0x0e7c6 = "No GIM provider is configured for this VM." */
    '\xd0','G','I','M',' ','p','r','o','v','i','d','e','r',' ','\x09','c','o','n','f','i','g','u','r','e','d',' ','\x0e','\xc9','V','M','.',
/* 0x0e7e5 = "Internal error in read-write critical section." */
    '\x06','\x07','\x0d','r','e','a','d','-','w','r','i','t','e',' ','c','r','i','t','i','c','a','l',' ','s','e','c','t','i','o','n','.',
/* 0x0e804 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_BOOT_IND" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x0f','B','O','O','T','_','I','N','D',
/* 0x0e823 = "The EMT was not blocked at the time of the call." */
    '\x03','E','M','T',' ','\x10','\x05','b','l','o','c','k','e','d',' ','a','t',' ','\x02','t','i','m','e',' ','\x13','\x02','c','a','l','l','.',
/* 0x0e842 = "VFS chain does not terminate with the desired object type." */
    '\xa4',' ','\x91','\x9c','\x05','t','e','r','m','i','n','a','t','e',' ','\x1e','\x02','d','e','s','i','r','e','d',' ','\x8d','t','y','p','e','.',
/* 0x0e861 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_RESERVED_FLAG" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','R','E','S','E','R','V','E','D','_','F','L','A','G',
/* 0x0e880 = "Internal ISO maker error: Namespace problem #6." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','6','.',
/* 0x0e89f = "VINF_EM_RAW_EMULATE_INSTR_GDT_FAULT" */
    '\x19','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','G','D','T','_','F','A','U','L','T',
/* 0x0e8be = "Misconfigured driver chain transformation." */
    'M','i','s','c','o','n','f','i','g','u','r','e','d',' ','\xa8','\x91','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x0e8dd = "VERR_ISOMK_IMPORT_SUPPLEMENTARY_BEFORE_PRIMARY" */
    '\x01','\xaa','\xd4','S','U','P','P','L','E','M','E','N','T','A','R','Y','_','B','E','F','O','R','E','_','P','R','I','M','A','R','Y',
/* 0x0e8fc = "VERR_IOM_TOO_MANY_IOPORT_REGISTRATIONS" */
    '\x01','I','O','M','_','\x9f','M','A','N','Y','_','I','O','P','O','R','T','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x0e91b = "Internal ISO maker error: Namespace problem #5." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','5','.',
/* 0x0e93a = "Bad or missing XAR checksum element." */
    '\x92','\x86','m','i','s','s','i','n','g',' ','X','A','R',' ','c','h','e','c','k','s','u','m',' ','e','l','e','m','e','n','t','.',
/* 0x0e959 = "Invalid ASN.1 GRAPHIC STRING encoding." */
    '\x0b','A','S','N','.','1',' ','G','R','A','P','H','I','C',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0e978 = "Shared Clipboard transfer ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','t','r','a','n','s','f','e','r',' ','I','D',' ','\x05','\x7d',
/* 0x0e997 = "VERR_LDRELF_UNTERMINATED_STRING_TAB" */
    '\x01','L','D','R','E','L','F','_','U','N','T','E','R','M','I','N','A','T','E','D','_','S','T','R','I','N','G','_','T','A','B',
/* 0x0e9b6 = "Deferred loading of information failed." */
    'D','e','f','e','r','r','e','d',' ','l','o','a','d','i','n','g',' ','\x13','i','n','f','o','r','m','a','t','i','o','n',' ','\x24',
/* 0x0e9d5 = "Can\'t unlock - region was not locked." */
    'C','a','n','\'','t',' ','u','n','l','o','c','k',' ','-',' ','r','e','g','i','o','n',' ','\x10','\x05','l','o','c','k','e','d','.',
/* 0x0e9f4 = "The device instance have no such logical unit." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xeb','\xe9','s','u','c','h',' ','l','o','g','i','c','a','l',' ','u','n','i','t','.',
/* 0x0ea13 = "Invalid ASN.1 NUMERIC STRING encoding." */
    '\x0b','A','S','N','.','1',' ','N','U','M','E','R','I','C',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0ea32 = "Recompiler: Translation block allocation failed." */
    '\x11','T','r','a','n','s','l','a','t','i','o','n',' ','b','l','o','c','k',' ','a','l','l','o','c','a','t','i','o','n',' ','\x24',
/* 0x0ea51 = "ASN.1 object has no pfnCheckSanity method." */
    'A','S','N','.','1',' ','\x8d','\x1d','\xe9','p','f','n','C','h','e','c','k','S','a','n','i','t','y',' ','m','e','t','h','o','d','.',
/* 0x0ea70 = "VFS chain element takes exactly one argument." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x0ea8f = "VERR_SUPLIB_SYMLINKS_ARE_NOT_PERMITTED" */
    '\x01','S','U','P','L','I','B','_','S','Y','M','L','I','N','K','S','_','A','R','E','_','\x14','P','E','R','M','I','T','T','E','D',
/* 0x0eaae = "VERR_PCI_PASSTHROUGH_NO_NESTED_PAGING" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb7','N','E','S','T','E','D','_','P','A','G','I','N','G',
/* 0x0eacd = "VERR_CR_DIGEST_OSSL_DIGEST_CTX_COPY_ERROR" */
    '\x01','\xa9','D','I','G','E','S','T','_','O','S','S','L','_','D','I','G','E','S','T','_','C','T','X','_','C','O','P','Y','_','\x9b',
/* 0x0eaec = "VERR_DBGC_PARSE_INVALD_COMMAND_NAME" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','I','N','V','A','L','D','_','C','O','M','M','A','N','D','_','N','A','M','E',
/* 0x0eb0b = "Internal ISO maker error: Namespace problem #1." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','1','.',
/* 0x0eb2a = "Import ISO contains a root directory without the directory flag set." */
    '\xaf','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x1b','w','i','t','h','o','u','t',' ','\x02','\x1b','f','l','a','g',' ','s','e','t','.',
/* 0x0eb49 = "VERR_ISOMK_IMPORT_DIR_REC_EXTENT_OUT_OF_BOUNDS" */
    '\x01','\xaa','\xd4','D','I','R','_','R','E','C','_','E','X','T','E','N','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0eb68 = "VERR_GSTCTL_MAX_CID_OBJECTS_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x0eb87 = "VWRN_GSTCTL_OBJECTSTATE_CHANGED" */
    'V','W','R','N','_','G','S','T','C','T','L','_','O','B','J','E','C','T','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x0eba6 = "Tried to halt a VM or CPU that was already halted." */
    'T','r','i','e','d',' ','\x08','h','a','l','t',' ','a',' ','\xcf',' ','\x86','C','P','U',' ','\x89','\x10','\x22','h','a','l','t','e','d','.',
/* 0x0ebc5 = "VERR_PGM_GCPHYS_RANGE_CROSSES_BOUNDARY" */
    '\x01','\xd7','G','C','P','H','Y','S','_','R','A','N','G','E','_','C','R','O','S','S','E','S','_','B','O','U','N','D','A','R','Y',
/* 0x0ebe4 = "VINF_EM_RAW_EMULATE_INSTR_TSS_FAULT" */
    '\x19','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','T','S','S','_','F','A','U','L','T',
/* 0x0ec03 = "VINF_EM_RAW_EMULATE_INSTR_IDT_FAULT" */
    '\x19','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','I','D','T','_','F','A','U','L','T',
/* 0x0ec22 = "VINF_EM_RAW_EMULATE_INSTR_LDT_FAULT" */
    '\x19','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','I','N','S','T','R','_','L','D','T','_','F','A','U','L','T',
/* 0x0ec41 = "Couldn\'t map pages during send." */
    'C','o','u','l','d','n','\'','t',' ','m','a','p',' ','p','a','g','e','s',' ','d','u','r','i','n','g',' ','s','e','n','d','.',
/* 0x0ec60 = "No clipboard data available for requested format." */
    '\xd0','c','l','i','p','b','o','a','r','d',' ','\x8f','a','v','a','i','l','a','b','l','e',' ','\x0e','\xbf','f','o','r','m','a','t','.',
/* 0x0ec7f = "VERR_LDRELF_NO_SYMBOL_OR_NO_STRING_TABS" */
    '\x01','L','D','R','E','L','F','_','\xb7','S','Y','M','B','O','L','_','O','R','_','\xb7','S','T','R','I','N','G','_','T','A','B','S',
/* 0x0ec9e = "VERR_VMM_CONTEXT_HOOK_STILL_ENABLED" */
    '\x01','V','M','M','_','C','O','N','T','E','X','T','_','H','O','O','K','_','S','T','I','L','L','_','E','N','A','B','L','E','D',
/* 0x0ecbd = "Unresolved (unknown) disk i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','d','i','s','k',' ','i','/','o',' ','\x7b',
/* 0x0ecdc = "VERR_SUP_VP_SIGNATURE_CHECKS_NOT_ENFORCED" */
    '\x01','\xe6','V','P','_','S','I','G','N','A','T','U','R','E','_','C','H','E','C','K','S','_','\x14','E','N','F','O','R','C','E','D',
/* 0x0ecfb = "VINF_AUDIO_STREAM_ASYNC_INIT_NEEDED" */
    '\x19','A','U','D','I','O','_','S','T','R','E','A','M','_','A','S','Y','N','C','_','I','N','I','T','_','N','E','E','D','E','D',
/* 0x0ed1a = "Internal ISO maker error: Namespace problem #4." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','4','.',
/* 0x0ed39 = "Couldn\'t find ROM page from saved state." */
    'C','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','R','O','M',' ','\xb6','f','r','o','m',' ','s','a','v','e','d',' ','\xf5',
/* 0x0ed58 = "The DEK for disk encryption is missing." */
    '\x03','D','E','K',' ','\x0e','d','i','s','k',' ','e','n','c','r','y','p','t','i','o','n',' ','\x09','m','i','s','s','i','n','g','.',
/* 0x0ed77 = "VERR_SHMEM_MAXIMUM_MAPPINGS_REACHED" */
    '\x01','S','H','M','E','M','_','M','A','X','I','M','U','M','_','M','A','P','P','I','N','G','S','_','R','E','A','C','H','E','D',
/* 0x0ed96 = "Pending interrupt is masked by TPR." */
    'P','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t',' ','\x09','m','a','s','k','e','d',' ','\xb9','T','P','R','.',
/* 0x0edb5 = "Process Verification Failure: Error query virtual memory information." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x5c','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0edd4 = "Unabled to locate an OpenGL symbol." */
    'U','n','a','b','l','e','d',' ','\x08','l','o','c','a','t','e',' ','\x60','O','p','e','n','G','L',' ','s','y','m','b','o','l','.',
/* 0x0edf3 = "Detected unsafe code for patching." */
    'D','e','t','e','c','t','e','d',' ','u','n','s','a','f','e',' ','c','o','d','e',' ','\x0e','p','a','t','c','h','i','n','g','.',
/* 0x0ee12 = "VERR_VM_REQUEST_STATUS_STILL_PENDING" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','S','T','I','L','L','_','P','E','N','D','I','N','G',
/* 0x0ee31 = "The chunk has already been mapped into the process." */
    '\x03','c','h','u','n','k',' ','\x1d','\x22','\xad','m','a','p','p','e','d',' ','i','n','t','o',' ','\x02','p','r','o','c','e','s','s','.',
/* 0x0ee50 = "Internal ISO maker error: Namespace problem #2." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','2','.',
/* 0x0ee6f = "Host operating system related error." */
    'H','o','s','t',' ','o','p','e','r','a','t','i','n','g',' ','s','y','s','t','e','m',' ','r','e','l','a','t','e','d',' ','\x7b',
/* 0x0ee8e = "Internal ISO maker error: Namespace problem #3." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','N','a','m','e','s','p','a','c','e',' ','p','r','o','b','l','e','m',' ','#','3','.',
/* 0x0eead = "VERR_CR_PKCS7_MESSAGE_DIGEST_ATTRIB_MISMATCH" */
    '\x01','\xa9','P','K','C','S','7','_','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B','_','\x99',
/* 0x0eecc = "The connection to the FAM daemon was lost." */
    '\x03','c','o','n','n','e','c','t','i','o','n',' ','\x08','\x02','F','A','M',' ','d','a','e','m','o','n',' ','\x10','l','o','s','t','.',
/* 0x0eeeb = "VERR_CR_SPC_NOT_EXACTLY_ONE_SIGNER_INFOS" */
    '\x01','\xa9','S','P','C','_','\x14','E','X','A','C','T','L','Y','_','O','N','E','_','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x0ef0a = "AMD-V CPU extension not available." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x0ef29 = "Trailing element separator not permitted." */
    'T','r','a','i','l','i','n','g',' ','\x1f','s','e','p','a','r','a','t','o','r',' ','\x05','p','e','r','m','i','t','t','e','d','.',
/* 0x0ef48 = "VERR_CR_PKCS7_TOO_MANY_DIGEST_ALGORITHMS" */
    '\x01','\xa9','P','K','C','S','7','_','\x9f','M','A','N','Y','_','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M','S',
/* 0x0ef67 = "Internal ISO maker error: Expected path to start with root slash." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','\xa6','\xbb','\x08','s','t','a','r','t',' ','\x1e','r','o','o','t',' ','s','l','a','s','h','.',
/* 0x0ef86 = "Unresolved (unknown) pipe i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','p','i','p','e',' ','i','/','o',' ','\x7b',
/* 0x0efa5 = "VWRN_REST_UNABLE_TO_DECODE_DATE" */
    'V','W','R','N','_','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x0efc4 = "Image Verification Failure: Authenticode parsing output." */
    '\xfe','\x0c','\x12','A','u','t','h','e','n','t','i','c','o','d','e',' ','p','a','r','s','i','n','g',' ','o','u','t','p','u','t','.',
/* 0x0efe3 = "VERR_UNABLE_TO_SATISFY_REQUIREMENTS" */
    '\x01','U','N','A','B','L','E','_','T','O','_','S','A','T','I','S','F','Y','_','R','E','Q','U','I','R','E','M','E','N','T','S',
/* 0x0f002 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_0" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','0',
/* 0x0f020 = "The image base address is to high for this image type." */
    '\x03','\x1a','b','a','s','e',' ','a','d','d','r','e','s','s',' ','\x09','\x08','h','i','g','h',' ','\x0e','\xc9','\x1a','t','y','p','e','.',
/* 0x0f03e = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_1" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','1',
/* 0x0f05c = "Termination record integrity error." */
    'T','e','r','m','i','n','a','t','i','o','n',' ','r','e','c','o','r','d',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x0f07a = "Reason for leaving RC: Caller the tracer in ring-0." */
    '\x84','\x0e','\x25','R','C',':',' ','C','a','l','l','e','r',' ','\x02','t','r','a','c','e','r',' ','\x0d','r','i','n','g','-','0','.',
/* 0x0f098 = "VERR_REST_WRONG_JSON_TYPE_FOR_DATE" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','D','A','T','E',
/* 0x0f0b6 = "VERR_CR_X509_CPV_ALT_NAME_NOT_PERMITTED" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','A','L','T','_','N','A','M','E','_','\x14','P','E','R','M','I','T','T','E','D',
/* 0x0f0d4 = "VERR_PCI_PASSTHROUGH_NO_RAM_PREALLOC" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb7','R','A','M','_','P','R','E','A','L','L','O','C',
/* 0x0f0f2 = "VERR_CR_PKIX_OSSL_CIPHER_ALOG_INIT_FAILED" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','C','I','P','H','E','R','_','A','L','O','G','_','I','N','I','T','_','\x93',
/* 0x0f110 = "VT-x features disabled by the BIOS." */
    'V','T','-','x',' ','f','e','a','t','u','r','e','s',' ','d','i','s','a','b','l','e','d',' ','\xb9','\x02','B','I','O','S','.',
/* 0x0f12e = "VERR_VFS_CHAIN_EXPECTED_RIGHT_PARENTHESES" */
    '\x01','\xa4','_','\xda','E','X','P','E','C','T','E','D','_','R','I','G','H','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x0f14c = "Found an illegal symbolic link (hardening)." */
    'F','o','u','n','d',' ','\x60','i','l','l','e','g','a','l',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x9a',
/* 0x0f16a = "A path is relative, expected an absolute path." */
    'A',' ','\xbb','\x09','r','e','l','a','t','i','v','e',',',' ','\xae','\x60','a','b','s','o','l','u','t','e',' ','p','a','t','h','.',
/* 0x0f188 = "Unfinished debug info reader code." */
    'U','n','f','i','n','i','s','h','e','d',' ','d','e','b','u','g',' ','i','n','f','o',' ','r','e','a','d','e','r',' ','\x5e',
/* 0x0f1a6 = "Invalid initialization vector length." */
    '\x0b','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','v','e','c','t','o','r',' ','l','e','n','g','t','h','.',
/* 0x0f1c4 = "Precodition no 3 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','3',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f1e2 = "VERR_TRACELOG_READER_MALFORMED_LOG" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','M','A','L','F','O','R','M','E','D','_','L','O','G',
/* 0x0f200 = "VERR_CR_SPC_NOT_EXACTLY_ONE_DIGEST_ALGO" */
    '\x01','\xa9','S','P','C','_','\x14','E','X','A','C','T','L','Y','_','O','N','E','_','D','I','G','E','S','T','_','A','L','G','O',
/* 0x0f21e = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_NM_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','N','M','_','\x9b',
/* 0x0f23c = "VERR_PGM_INTERMEDIATE_PAGING_CONFLICT" */
    '\x01','\xd7','I','N','T','E','R','M','E','D','I','A','T','E','_','P','A','G','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x0f25a = "VERR_LDRVI_MACHINE_OPT_HDR_MAGIC_MISMATCH" */
    '\x01','L','D','R','V','I','_','M','A','C','H','I','N','E','_','O','P','T','_','H','D','R','_','M','A','G','I','C','_','\x99',
/* 0x0f278 = "A driver may only register one VTG object per session." */
    'A',' ','\xa8','m','a','y',' ','\xf7','\xbc','o','n','e',' ','V','T','G',' ','\x8d','p','e','r',' ','s','e','s','s','i','o','n','.',
/* 0x0f296 = "VERR_WEB_INVALID_MANAGED_OBJECT_REFERENCE" */
    '\x01','W','E','B','_','\x0f','M','A','N','A','G','E','D','_','O','B','J','E','C','T','_','R','E','F','E','R','E','N','C','E',
/* 0x0f2b4 = "VERR_CR_PKIX_OSSL_EVP_PKEY_RSA_PAD_ERROR" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','R','S','A','_','P','A','D','_','\x9b',
/* 0x0f2d2 = "VERR_LDRVI_SECTION_RAW_DATA_VALUES" */
    '\x01','L','D','R','V','I','_','S','E','C','T','I','O','N','_','R','A','W','_','D','A','T','A','_','V','A','L','U','E','S',
/* 0x0f2f0 = "XML error while parsing the table of content." */
    'X','M','L',' ','\x07','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','\x02','\x9e','\x13','c','o','n','t','e','n','t','.',
/* 0x0f30e = "Leading element separator not permitted." */
    'L','e','a','d','i','n','g',' ','\x1f','s','e','p','a','r','a','t','o','r',' ','\x05','p','e','r','m','i','t','t','e','d','.',
/* 0x0f32c = "The path is not the same object as the native handle (hardening)." */
    '\x03','\xbb','\x09','\x05','\x02','s','a','m','e',' ','\x8d','a','s',' ','\x02','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\x9a',
/* 0x0f34a = "The DBGF couldn\'t find the specified breakpoint." */
    '\x03','\xf1',' ','c','o','u','l','d','n','\'','t',' ','f','i','n','d',' ','\x02','\x16','b','r','e','a','k','p','o','i','n','t','.',
/* 0x0f368 = "Expected valid data pointer for ASN.1 object." */
    '\xa6','v','a','l','i','d',' ','\x8f','p','o','i','n','t','e','r',' ','\x0e','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x0f386 = "Internal processing error while merging status codes." */
    '\x06','\x04','\x07','w','h','i','l','e',' ','m','e','r','g','i','n','g',' ','s','t','a','t','u','s',' ','c','o','d','e','s','.',
/* 0x0f3a4 = "Failed to normalize ASN.1 time object." */
    '\x80','\x08','n','o','r','m','a','l','i','z','e',' ','A','S','N','.','1',' ','t','i','m','e',' ','o','b','j','e','c','t','.',
/* 0x0f3c2 = "The size of the shared module was out of range." */
    '\x03','\xf8','\x13','\x02','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x0f3e0 = "VERR_CR_PKCS7_BAD_MESSAGE_DIGEST_ATTRIB" */
    '\x01','\xa9','P','K','C','S','7','_','\xa0','M','E','S','S','A','G','E','_','D','I','G','E','S','T','_','A','T','T','R','I','B',
/* 0x0f3fe = "OpenSSL failed to decode the private key." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x0f41c = "VERR_HARDAVL_POINTER_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','P','O','I','N','T','E','R','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0f43a = "VERR_CR_PKCS7_DIGEST_ALGO_NOT_FOUND_IN_LIST" */
    '\x01','\xa9','P','K','C','S','7','_','D','I','G','E','S','T','_','A','L','G','O','_','\x14','\xb3','_','I','N','_','L','I','S','T',
/* 0x0f458 = "Import ISO contains a directory with an extent that is out of bounds." */
    '\xaf','\xb2',' ','\x7f','a',' ','\x1b','\x1e','\x60','e','x','t','e','n','t',' ','\x89','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x0f476 = "VERR_HARDAVL_TRAVERSED_TOO_MANY_NODES" */
    '\x01','H','A','R','D','A','V','L','_','T','R','A','V','E','R','S','E','D','_','\x9f','M','A','N','Y','_','N','O','D','E','S',
/* 0x0f494 = "VERR_DBGC_PARSE_EXPECTED_BINARY_OP" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','E','X','P','E','C','T','E','D','_','B','I','N','A','R','Y','_','O','P',
/* 0x0f4b2 = "Reason for leaving RC: Fatal trap in hypervisor." */
    '\x84','\x0e','\x25','R','C',':',' ','F','a','t','a','l',' ','t','r','a','p',' ','\x0d','h','y','p','e','r','v','i','s','o','r','.',
/* 0x0f4d0 = "The PE loader encountered a malformed certificate." */
    '\x03','P','E',' ','\xc4','\x98','a',' ','m','a','l','f','o','r','m','e','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x0f4ee = "VERR_IEM_EMIT_FIXED_JUMP_OUT_OF_RANGE" */
    '\x01','\xee','E','M','I','T','_','F','I','X','E','D','_','J','U','M','P','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f50c = "VINF_GMM_SHARED_MODULE_ALREADY_REGISTERED" */
    '\x19','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\xed','R','E','G','I','S','T','E','R','E','D',
/* 0x0f52a = "The tracepoint provider object is too large." */
    '\x03','t','r','a','c','e','p','o','i','n','t',' ','p','r','o','v','i','d','e','r',' ','\x8d','\x09','\x8c','l','a','r','g','e','.',
/* 0x0f548 = "PKIX signature no does not match up to the current data." */
    'P','K','I','X',' ','s','i','g','n','a','t','u','r','e',' ','\xe9','\x9c','\x05','\xe3','u','p',' ','\x08','\x02','\xd1','d','a','t','a','.',
/* 0x0f566 = "VERR_URI_ESCAPED_CHARS_NOT_VALID_UTF8" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','C','H','A','R','S','_','\x14','V','A','L','I','D','_','U','T','F','8',
/* 0x0f584 = "The previous ownership of this semaphore has ended." */
    '\x03','p','r','e','v','i','o','u','s',' ','o','w','n','e','r','s','h','i','p',' ','\x13','\xc9','\xea','\x1d','e','n','d','e','d','.',
/* 0x0f5a2 = "VERR_CR_X509_CPV_UNKNOWN_CRITICAL_EXTENSION" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\xde','C','R','I','T','I','C','A','L','_','E','X','T','E','N','S','I','O','N',
/* 0x0f5c0 = "ASN.1 object has no virtual method table." */
    'A','S','N','.','1',' ','\x8d','\x1d','\xe9','v','i','r','t','u','a','l',' ','m','e','t','h','o','d',' ','t','a','b','l','e','.',
/* 0x0f5de = "There is no cache attached to the disk." */
    'T','h','e','r','e',' ','\x09','\xe9','c','a','c','h','e',' ','a','t','t','a','c','h','e','d',' ','\x08','\x02','d','i','s','k','.',
/* 0x0f5fc = "Precodition no 2 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','2',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f61a = "VERR_INTNET_FLT_LOWER_LINK_INFO_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','N','F','O','_','\x14','\xb3',
/* 0x0f638 = "Attempt to resume a running TSC." */
    'A','t','t','e','m','p','t',' ','\x08','r','e','s','u','m','e',' ','a',' ','r','u','n','n','i','n','g',' ','T','S','C','.',
/* 0x0f656 = "VERR_DBGC_PARSE_INCORRECT_ARG_TYPE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','I','N','C','O','R','R','E','C','T','_','A','R','G','_','T','Y','P','E',
/* 0x0f674 = "VERR_REST_WRONG_JSON_TYPE_FOR_BOOL" */
    '\x01','R','E','S','T','_','W','R','O','N','G','_','J','S','O','N','_','T','Y','P','E','_','F','O','R','_','B','O','O','L',
/* 0x0f692 = "VERR_MAIN_CONFIG_CONSTRUCTOR_COM_ERROR" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','C','O','M','_','\x9b',
/* 0x0f6b0 = "Missing UTF-16 surrogate pair." */
    'M','i','s','s','i','n','g',' ','U','T','F','-','1','6',' ','s','u','r','r','o','g','a','t','e',' ','p','a','i','r','.',
/* 0x0f6ce = "VERR_ISOMK_IMPORT_MORE_THAN_ONE_VOLUME_IN_SET" */
    '\x01','\xaa','\xd4','M','O','R','E','_','T','H','A','N','_','O','N','E','_','V','O','L','U','M','E','_','I','N','_','S','E','T',
/* 0x0f6ec = "VERR_DBG_SEGMENT_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0f70a = "VINF_SSM_VOTE_DONE_DONT_CALL_AGAIN" */
    '\x19','S','S','M','_','V','O','T','E','_','D','O','N','E','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x0f728 = "VERR_AUDIO_STREAM_INIT_IN_PROGRESS" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','I','N','I','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x0f746 = "The specified path does not point at a symbolic link." */
    '\x03','\x16','\xbb','\x9c','\x05','p','o','i','n','t',' ','a','t',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x0f764 = "Expected PE image data inside indirect data object." */
    '\xa6','P','E',' ','\x1a','\x8f','i','n','s','i','d','e',' ','i','n','d','i','r','e','c','t',' ','\x8f','o','b','j','e','c','t','.',
/* 0x0f782 = "VERR_CR_PASSWORD_2_KEY_DERIVIATION_FAILED" */
    '\x01','\xa9','P','A','S','S','W','O','R','D','_','2','_','K','E','Y','_','D','E','R','I','V','I','A','T','I','O','N','_','\x93',
/* 0x0f7a0 = "VERR_JSON_BAD_SURROGATE_PAIR_SEQUENCE" */
    '\x01','J','S','O','N','_','\xa0','S','U','R','R','O','G','A','T','E','_','P','A','I','R','_','S','E','Q','U','E','N','C','E',
/* 0x0f7be = "Precodition no 1 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','1',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f7dc = "Unresolved (unknown) network error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','n','e','t','w','o','r','k',' ','\x7b',
/* 0x0f7fa = "PKIX cipher algorithm is not known to OpenSSL." */
    'P','K','I','X',' ','c','i','p','h','e','r',' ','\xbe','\x09','\x05','k','n','o','w','n',' ','\x08','O','p','e','n','S','S','L','.',
/* 0x0f818 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_2" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','2',
/* 0x0f836 = "VERR_CR_CIPHER_OSSL_ENCRYPT_UPDATE_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x93',
/* 0x0f854 = "Reason for leaving RC: attempt to patch MMIO write." */
    '\x84','\x0e','\x25','R','C',':',' ','a','t','t','e','m','p','t',' ','\x08','p','a','t','c','h',' ','\xf4',' ','w','r','i','t','e','.',
/* 0x0f872 = "VERR_X509_EXTRACT_PUBKEY_FROM_CERT" */
    '\x01','X','5','0','9','_','E','X','T','R','A','C','T','_','P','U','B','K','E','Y','_','F','R','O','M','_','C','E','R','T',
/* 0x0f890 = "Precodition no 0 in hmR0SvmVmRun failed." */
    'P','r','e','c','o','d','i','t','i','o','n',' ','\xe9','0',' ','\x0d','h','m','R','0','S','v','m','V','m','R','u','n',' ','\x24',
/* 0x0f8ae = "VERR_REST_RESPONSE_CONTENT_TYPE_NOT_SUPPORTED" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','\x14','\xc5',
/* 0x0f8cc = "internal fixup chain isn\'t implemented yet." */
    '\x15','f','i','x','u','p',' ','\x91','i','s','n','\'','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','y','e','t','.',
/* 0x0f8ea = "Tried to take a semaphore in a bad context." */
    'T','r','i','e','d',' ','\x08','t','a','k','e',' ','a',' ','\xea','\x0d','a',' ','b','a','d',' ','c','o','n','t','e','x','t','.',
/* 0x0f908 = "Import ISO contains a bad primary volume descriptor." */
    '\xaf','\xb2',' ','\x7f','a',' ','b','a','d',' ','p','r','i','m','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0f926 = "Import ISO contains a root directory with multiple extents." */
    '\xaf','\xb2',' ','\x7f','a',' ','r','o','o','t',' ','\x1b','\x1e','m','u','l','t','i','p','l','e',' ','e','x','t','e','n','t','s','.',
/* 0x0f944 = "VERR_ISOMK_IMPORT_NON_CONTIGUOUS_MULTI_EXTENT" */
    '\x01','\xaa','\xd4','N','O','N','_','C','O','N','T','I','G','U','O','U','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x0f962 = "Bad VTG argument list descriptor." */
    '\x92','V','T','G',' ','a','r','g','u','m','e','n','t',' ','l','i','s','t',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x0f980 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_3" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','3',
/* 0x0f99e = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_4" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','4',
/* 0x0f9bc = "VERR_X509_RSA_VERIFICATION_FUILURE" */
    '\x01','X','5','0','9','_','R','S','A','_','V','E','R','I','F','I','C','A','T','I','O','N','_','F','U','I','L','U','R','E',
/* 0x0f9da = "VERR_CR_CIPHER_OSSL_DECRYPT_UPDATE_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','U','P','D','A','T','E','_','\x93',
/* 0x0f9f8 = "VERR_SUPLIB_NT_PROCESS_UNTRUSTED_5" */
    '\x01','S','U','P','L','I','B','_','N','T','_','P','R','O','C','E','S','S','_','U','N','T','R','U','S','T','E','D','_','5',
/* 0x0fa16 = "Process Verification Failure: The memory region is too large (>= 2GB)." */
    '\x17','\x0c','\x12','\x03','\x5c','r','e','g','i','o','n',' ','\x09','\x8c','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x0fa33 = "Error opening the ApiPort LPC object." */
    '\xac','o','p','e','n','i','n','g',' ','\x02','A','p','i','P','o','r','t',' ','L','P','C',' ','o','b','j','e','c','t','.',
/* 0x0fa50 = "Unsupported PKCS #7 signer info version." */
    '\x87','P','K','C','S',' ','#','7',' ','s','i','g','n','e','r',' ','i','n','f','o',' ','v','e','r','s','i','o','n','.',
/* 0x0fa6d = "VERR_PDM_CRITSECTRW_TOO_MANY_RECURSIONS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9f','M','A','N','Y','_','R','E','C','U','R','S','I','O','N','S',
/* 0x0fa8a = "VERR_INTNET_FLT_LOWER_LINK_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','O','P','E','N','_','\x93',
/* 0x0faa7 = "The specified data unit wasn\'t owned by caller." */
    '\x03','\x16','\x8f','u','n','i','t',' ','w','a','s','n','\'','t',' ','o','w','n','e','d',' ','\xb9','c','a','l','l','e','r','.',
/* 0x0fac4 = "Found bogus offset in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','o','f','f','s','e','t',' ','\x0d','\x02','\x18','s','y','s','t','e','m','.',
/* 0x0fae1 = "An invalid LUN specification was given." */
    'A','n',' ','\x81','L','U','N',' ','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x10','g','i','v','e','n','.',
/* 0x0fafe = "VWRN_CSAM_INSTRUCTION_PATCHED" */
    'V','W','R','N','_','C','S','A','M','_','I','N','S','T','R','U','C','T','I','O','N','_','P','A','T','C','H','E','D',
/* 0x0fb1b = "VFS chain element takes a directory (dir) object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x1b','(','d','i','r',')',' ','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x0fb38 = "Algorithm parameters does not match the key." */
    'A','l','g','o','r','i','t','h','m',' ','p','a','r','a','m','e','t','e','r','s',' ','\x9c','\x05','\xe3','\x02','k','e','y','.',
/* 0x0fb55 = "VERR_PDM_ONE_PCI_FUNCTION_PER_DEVICE" */
    '\x01','\xb8','O','N','E','_','P','C','I','_','F','U','N','C','T','I','O','N','_','P','E','R','_','D','E','V','I','C','E',
/* 0x0fb72 = "VERR_PDM_ASYNC_COMPLETION_NOT_SUSPENDED" */
    '\x01','\xb8','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\x14','S','U','S','P','E','N','D','E','D',
/* 0x0fb8f = "Attempted to use stub switcher." */
    'A','t','t','e','m','p','t','e','d',' ','\x08','u','s','e',' ','s','t','u','b',' ','s','w','i','t','c','h','e','r','.',
/* 0x0fbac = "The internal logger revision did not match." */
    '\x03','\x15','l','o','g','g','e','r',' ','r','e','v','i','s','i','o','n',' ','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x0fbc9 = "The recipient process has refused the signal." */
    '\x03','r','e','c','i','p','i','e','n','t',' ','\x82','\x1d','r','e','f','u','s','e','d',' ','\x02','s','i','g','n','a','l','.',
/* 0x0fbe6 = "VERR_IEM_COND_ENDIF_RECONCILIATION_FAILED" */
    '\x01','\xee','C','O','N','D','_','E','N','D','I','F','_','R','E','C','O','N','C','I','L','I','A','T','I','O','N','_','\x93',
/* 0x0fc03 = "VERR_PGM_HANDLER_PHYSICAL_NO_RAM_RANGE" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','\xb7','R','A','M','_','R','A','N','G','E',
/* 0x0fc20 = "VERR_LDRLX_IMPORT_ORDINAL_OUT_OF_BOUNDS" */
    '\x01','L','D','R','L','X','_','\xd4','O','R','D','I','N','A','L','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x0fc3d = "Invalid ASN.1 UTF-8 STRING encoding." */
    '\x0b','A','S','N','.','1',' ','U','T','F','-','8',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x0fc5a = "The specified shared page was not actually private." */
    '\x03','\x16','s','h','a','r','e','d',' ','\xb6','\x10','\x05','a','c','t','u','a','l','l','y',' ','p','r','i','v','a','t','e','.',
/* 0x0fc77 = "VERR_GSTCTL_MAX_CID_COUNT_REACHED" */
    '\x01','G','S','T','C','T','L','_','M','A','X','_','C','I','D','_','C','O','U','N','T','_','R','E','A','C','H','E','D',
/* 0x0fc94 = "VERR_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x01','X','5','0','9','_','\x14','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x0fcb1 = "VERR_PDM_ASYNC_COMPLETION_ALREADY_SUSPENDED" */
    '\x01','\xb8','A','S','Y','N','C','_','C','O','M','P','L','E','T','I','O','N','_','\xed','S','U','S','P','E','N','D','E','D',
/* 0x0fcce = "Reason for leaving RC: attempt to patch MMIO read." */
    '\x84','\x0e','\x25','R','C',':',' ','a','t','t','e','m','p','t',' ','\x08','p','a','t','c','h',' ','\xf4',' ','r','e','a','d','.',
/* 0x0fceb = "Malformed unwind information." */
    'M','a','l','f','o','r','m','e','d',' ','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0fd08 = "VERR_ISOMK_IMPORT_BOOT_CAT_ENTRY_UNKNOWN_IMAGE_SIZE" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','N','T','R','Y','_','\xde','I','M','A','G','E','_','S','I','Z','E',
/* 0x0fd25 = "VERR_CR_CIPHER_OSSL_ENCRYPT_FINAL_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','F','I','N','A','L','_','\x93',
/* 0x0fd42 = "NEM can only operate from ring-3." */
    'N','E','M',' ','c','a','n',' ','\xf7','o','p','e','r','a','t','e',' ','f','r','o','m',' ','r','i','n','g','-','3','.',
/* 0x0fd5f = "VERR_SUP_VP_EXE_MISSING_DYNAMIC_BASE" */
    '\x01','\xe6','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','D','Y','N','A','M','I','C','_','B','A','S','E',
/* 0x0fd7c = "The GIP update interval is too large." */
    '\x03','G','I','P',' ','u','p','d','a','t','e',' ','i','n','t','e','r','v','a','l',' ','\x09','\x8c','l','a','r','g','e','.',
/* 0x0fd99 = "The guest bit mask didn\'t match the guest being loaded." */
    '\x03','\xa1','b','i','t',' ','m','a','s','k',' ','d','i','d','n','\'','t',' ','\xe3','\x02','\xa1','\xdb','l','o','a','d','e','d','.',
/* 0x0fdb6 = "Unable to start VM execution due to an invalid guest state." */
    '\xca','\x08','s','t','a','r','t',' ','\xcf',' ','e','x','e','c','u','t','i','o','n',' ','d','u','e',' ','\x08','\x60','\x81','\xa1','\xf5',
/* 0x0fdd3 = "VERR_SUP_VP_BAD_SECTION_ALIGNMENT_VALUE" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x0fdf0 = "VERR_SSM_DATA_UNIT_FORMAT_CHANGED" */
    '\x01','S','S','M','_','D','A','T','A','_','U','N','I','T','_','F','O','R','M','A','T','_','C','H','A','N','G','E','D',
/* 0x0fe0d = "VERR_GIM_HYPERCALL_MEMORY_WRITE_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','M','E','M','O','R','Y','_','W','R','I','T','E','_','\x93',
/* 0x0fe2a = "The spill file grew larger than 4GB." */
    '\x03','s','p','i','l','l',' ','\x18','g','r','e','w',' ','l','a','r','g','e','r',' ','t','h','a','n',' ','4','G','B','.',
/* 0x0fe47 = "Output can be enabled for the client." */
    'O','u','t','p','u','t',' ','c','a','n',' ','\x90','e','n','a','b','l','e','d',' ','\x0e','\x02','c','l','i','e','n','t','.',
/* 0x0fe64 = "The tracer has already been opened in this sesssion." */
    '\x03','t','r','a','c','e','r',' ','\x1d','\x22','\xad','o','p','e','n','e','d',' ','\x0d','\xc9','s','e','s','s','s','i','o','n','.',
/* 0x0fe81 = "VERR_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x01','\xa9','D','I','G','E','S','T','_','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x0fe9e = "Found bogus values in the file system." */
    'F','o','u','n','d',' ','b','o','g','u','s',' ','v','a','l','u','e','s',' ','\x0d','\x02','\x18','s','y','s','t','e','m','.',
/* 0x0febb = "VINF_CR_DIGEST_SEVERELY_COMPROMISED" */
    '\x19','\xa9','D','I','G','E','S','T','_','S','E','V','E','R','E','L','Y','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x0fed8 = "VERR_SUPLIB_PATH_TOO_MANY_COMPONENTS" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9f','M','A','N','Y','_','C','O','M','P','O','N','E','N','T','S',
/* 0x0fef5 = "VERR_DBGC_PARSE_ARGUMENT_OVERFLOW" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','A','R','G','U','M','E','N','T','_','O','V','E','R','F','L','O','W',
/* 0x0ff12 = "The extracted data has exceeded the expected size." */
    '\x03','e','x','t','r','a','c','t','e','d',' ','\x8f','\x1d','e','x','c','e','e','d','e','d',' ','\x02','\xae','s','i','z','e','.',
/* 0x0ff2f = "The module contains no symbol information." */
    '\x03','m','o','d','u','l','e',' ','\x7f','\xe9','s','y','m','b','o','l',' ','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x0ff4c = "No debug connection configured." */
    '\xd0','d','e','b','u','g',' ','c','o','n','n','e','c','t','i','o','n',' ','c','o','n','f','i','g','u','r','e','d','.',
/* 0x0ff69 = "VERR_TRACELOG_READER_ITERATOR_END" */
    '\x01','T','R','A','C','E','L','O','G','_','R','E','A','D','E','R','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x0ff86 = "VERR_DBG_SYMBOL_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','S','Y','M','B','O','L','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x0ffa3 = "VERR_SUP_VP_REPLACE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\xe6','V','P','_','R','E','P','L','A','C','E','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x93',
/* 0x0ffc0 = "Patch TPR access instruction." */
    'P','a','t','c','h',' ','T','P','R',' ','a','c','c','e','s','s',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x0ffdd = "Invalid partition index in a location." */
    '\x0b','p','a','r','t','i','t','i','o','n',' ','i','n','d','e','x',' ','\x0d','a',' ','l','o','c','a','t','i','o','n','.',
/* 0x0fffa = "Go back into wait for SIPI mode." */
    'G','o',' ','b','a','c','k',' ','i','n','t','o',' ','w','a','i','t',' ','\x0e','S','I','P','I',' ','m','o','d','e','.',
/* 0x10017 = "Failed to enable and lock VT-x features." */
    '\x80','\x08','e','n','a','b','l','e',' ','\x2a','l','o','c','k',' ','V','T','-','x',' ','f','e','a','t','u','r','e','s','.',
/* 0x10034 = "The VM request was killed at VM termination." */
    '\x03','\xcf',' ','\x94','\x10','k','i','l','l','e','d',' ','a','t',' ','\xcf',' ','t','e','r','m','i','n','a','t','i','o','n','.',
/* 0x10051 = "OpenSSL failed to decode the public key." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','d','e','c','o','d','e',' ','\x02','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1006e = "VERR_VMX_VMCS_FIELD_CACHE_INVALID" */
    '\x01','V','M','X','_','V','M','C','S','_','F','I','E','L','D','_','C','A','C','H','E','_','I','N','V','A','L','I','D',
/* 0x1008b = "Recompiler: Too deeply nested conditionals." */
    '\x11','\xf0','d','e','e','p','l','y',' ','n','e','s','t','e','d',' ','c','o','n','d','i','t','i','o','n','a','l','s','.',
/* 0x100a8 = "NEM failed to unmap page(s) into the VM." */
    'N','E','M',' ','\x88','\x08','u','n','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x100c5 = "VERR_NET_CONNECTION_RESET_BY_PEER" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','S','E','T','_','B','Y','_','P','E','E','R',
/* 0x100e2 = "Unresolved (unknown) search error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','s','e','a','r','c','h',' ','\x7b',
/* 0x100ff = "VERR_VSCSI_LUN_ATTACHED_TO_DEVICE" */
    '\x01','V','S','C','S','I','_','L','U','N','_','A','T','T','A','C','H','E','D','_','T','O','_','D','E','V','I','C','E',
/* 0x1011c = "Trying to use too new winsock API." */
    'T','r','y','i','n','g',' ','\x08','u','s','e',' ','\x8c','n','e','w',' ','w','i','n','s','o','c','k',' ','A','P','I','.',
/* 0x10139 = "VERR_ISOFS_BAD_LVD_FILE_SET_DESC_LOCATION" */
    '\x01','\xfd','\xa0','L','V','D','_','F','I','L','E','_','S','E','T','_','D','E','S','C','_','L','O','C','A','T','I','O','N',
/* 0x10156 = "Requested to import an unknown ISO format." */
    'R','e','q','u','e','s','t','e','d',' ','\x08','i','m','p','o','r','t',' ','\x60','\xfc','\xb2',' ','f','o','r','m','a','t','.',
/* 0x10173 = "The compressed data started with a bad header." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x8f','s','t','a','r','t','e','d',' ','\x1e','a',' ','b','a','d',' ','\xe7',
/* 0x10190 = "VERR_AUDIO_STREAM_PENDING_DISABLE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','P','E','N','D','I','N','G','_','D','I','S','A','B','L','E',
/* 0x101ad = "Unexpected NULL pointer to right subtree." */
    '\x85','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x08','r','i','g','h','t',' ','s','u','b','t','r','e','e','.',
/* 0x101ca = "VERR_CR_CIPHER_OSSL_DECRYPT_FINAL_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','F','I','N','A','L','_','\x93',
/* 0x101e7 = "VERR_XAR_NOT_STREAMBLE_ELEMENT_ORDER" */
    '\x01','X','A','R','_','\x14','S','T','R','E','A','M','B','L','E','_','E','L','E','M','E','N','T','_','O','R','D','E','R',
/* 0x10204 = "Import module ordinal is out of bounds." */
    '\xaf','m','o','d','u','l','e',' ','o','r','d','i','n','a','l',' ','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x10221 = "VERR_CR_PKCS7_CONTENT_TYPE_ATTRIB_MISMATCH" */
    '\x01','\xa9','P','K','C','S','7','_','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B','_','\x99',
/* 0x1023e = "VERR_ISOMK_IMPORT_MULTIPLE_PRIMARY_VOL_DESCS" */
    '\x01','\xaa','\xd4','M','U','L','T','I','P','L','E','_','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x1025b = "VERR_FILE_AIO_INSUFFICIENT_EVENTS" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','S','U','F','F','I','C','I','E','N','T','_','E','V','E','N','T','S',
/* 0X10278 = "Start instruction stepping (debug only)." */
    't','a','r','t',' ','\xba','s','t','e','p','p','i','n','g',' ','(','d','e','b','u','g',' ','o','n','l','y',')','.',
/* 0x10294 = "Wrong locking order detected." */
    'W','r','o','n','g',' ','l','o','c','k','i','n','g',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x102b1 = "VERR_VFS_CHAIN_EXPECTED_LEFT_PARENTHESES" */
    '\x01','\xa4','_','\xda','E','X','P','E','C','T','E','D','_','L','E','F','T','_','P','A','R','E','N','T','H','E','S','E','S',
/* 0x102ce = "Syntax error - out of regular heap memory." */
    '\xe1','\x07','-',' ','o','u','t',' ','\x13','r','e','g','u','l','a','r',' ','h','e','a','p',' ','m','e','m','o','r','y','.',
/* 0x102eb = "VERR_FDT_DTB_PROP_NAME_OFF_TOO_LARGE" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','N','A','M','E','_','O','F','F','_','\x9f','L','A','R','G','E',
/* 0x10308 = "Power off is not supported by the hardware or the OS." */
    'P','o','w','e','r',' ','o','f','f',' ','\x09','\x05','\xf9','\xb9','\x02','h','a','r','d','w','a','r','e',' ','\x86','\x02','O','S','.',
/* 0x10325 = "Destination address required." */
    'D','e','s','t','i','n','a','t','i','o','n',' ','a','d','d','r','e','s','s',' ','r','e','q','u','i','r','e','d','.',
/* 0x10342 = "VERR_GMM_ATTEMPT_TO_DEFLATE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','D','E','F','L','A','T','E','_','\x9f','M','U','C','H',
/* 0x1035f = "VERR_SUP_VP_NT_QI_PROCESS_IMG_INFO_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','I','M','G','_','I','N','F','O','_','\x9b',
/* 0x1037c = "Failed to derivate key from password." */
    '\x80','\x08','d','e','r','i','v','a','t','e',' ','k','e','y',' ','f','r','o','m',' ','p','a','s','s','w','o','r','d','.',
/* 0x10399 = "Send pagefault timeout in send." */
    'S','e','n','d',' ','p','a','g','e','f','a','u','l','t',' ','t','i','m','e','o','u','t',' ','\x0d','s','e','n','d','.',
/* 0x103b6 = "The specified CPU cannot be found in the CPU database." */
    '\x03','\x16','C','P','U',' ','\xcb','\x90','f','o','u','n','d',' ','\x0d','\x02','C','P','U',' ','d','a','t','a','b','a','s','e','.',
/* 0x103d3 = "Encountered an bad (/unknown) record type." */
    '\x97','\x60','b','a','d',' ','(','/','u','n','k','n','o','w','n',')',' ','r','e','c','o','r','d',' ','t','y','p','e','.',
/* 0x103f0 = "The OpenSSL version is too old for the attempted operation." */
    '\x03','O','p','e','n','S','S','L',' ','\xb4','\x09','\x8c','o','l','d',' ','\x0e','\x02','a','t','t','e','m','p','t','e','d',' ','\xcc',
/* 0x1040d = "VERR_REST_RESPONSE_INVALID_UTF8_ENCODING" */
    '\x01','R','E','S','T','_','R','E','S','P','O','N','S','E','_','\x0f','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x1042a = "VWRN_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    'V','W','R','N','_','\xdc','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x10447 = "Recompiler: No host register available for variables." */
    '\x11','\xd0','h','o','s','t',' ','\xbc','a','v','a','i','l','a','b','l','e',' ','\x0e','v','a','r','i','a','b','l','e','s','.',
/* 0x10464 = "Bad DWARF extended line number opcode." */
    '\x92','D','W','A','R','F',' ','e','x','t','e','n','d','e','d',' ','l','i','n','e',' ','\xdd','o','p','c','o','d','e','.',
/* 0x10481 = "VERR_SHCLPB_MAX_TRANSFERS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','T','R','A','N','S','F','E','R','S','_','R','E','A','C','H','E','D',
/* 0x1049e = "VFS chain element only provides directory (dir) objects." */
    '\xa4',' ','\x91','\x1f','\xf7','p','r','o','v','i','d','e','s',' ','\x1b','(','d','i','r',')',' ','o','b','j','e','c','t','s','.',
/* 0x104bb = "Expected PKCS #7 object to not contain any CRLs." */
    '\xa6','P','K','C','S',' ','#','7',' ','\x8d','\x08','\x05','c','o','n','t','a','i','n',' ','a','n','y',' ','C','R','L','s','.',
/* 0x104d8 = "VERR_CR_PKIX_OSSL_D2I_PRIVATE_KEY_FAILED" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','R','I','V','A','T','E','_','K','E','Y','_','\x93',
/* 0x104f5 = "Wrong release order detected." */
    'W','r','o','n','g',' ','r','e','l','e','a','s','e',' ','o','r','d','e','r',' ','d','e','t','e','c','t','e','d','.',
/* 0x10512 = "Certificate serial number length is out of bounds." */
    '\xa7','s','e','r','i','a','l',' ','\xdd','l','e','n','g','t','h',' ','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x1052f = "VERR_SUP_VP_NT_QI_PROCESS_DBG_PORT_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','D','B','G','_','P','O','R','T','_','\x9b',
/* 0x1054c = "VERR_XML_TOC_ELEMENT_HAS_SIBLINGS" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','H','A','S','_','S','I','B','L','I','N','G','S',
/* 0x10569 = "The expanding of the dynamic mapping cache failed." */
    '\x03','e','x','p','a','n','d','i','n','g',' ','\x13','\x02','d','y','n','a','m','i','c',' ','\xe0','c','a','c','h','e',' ','\x24',
/* 0x10586 = "VINF_X509_NOT_SELFSIGNED_CERTIFICATE" */
    '\x19','X','5','0','9','_','\x14','S','E','L','F','S','I','G','N','E','D','_','C','E','R','T','I','F','I','C','A','T','E',
/* 0x105a3 = "The display connector is resizing." */
    '\x03','d','i','s','p','l','a','y',' ','c','o','n','n','e','c','t','o','r',' ','\x09','r','e','s','i','z','i','n','g','.',
/* 0x105c0 = "VERR_URI_INVALID_ESCAPED_UTF8_LEAD_BYTE" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','D','_','U','T','F','8','_','L','E','A','D','_','B','Y','T','E',
/* 0x105dc = "The saved state file magic was not recognized." */
    '\x03','s','a','v','e','d',' ','\xb0','\x18','m','a','g','i','c',' ','\x10','\x05','r','e','c','o','g','n','i','z','e','d','.',
/* 0x105f8 = "VERR_CR_SPC_IND_DATA_DIGEST_SIZE_MISMATCH" */
    '\x01','\xa9','S','P','C','_','I','N','D','_','D','A','T','A','_','D','I','G','E','S','T','_','S','I','Z','E','_','\x99',
/* 0x10614 = "The shared module is already registered." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x09','\x22','r','e','g','i','s','t','e','r','e','d','.',
/* 0x10630 = "VINF_PATM_PENDING_IRQ_AFTER_IRET" */
    '\x19','P','A','T','M','_','P','E','N','D','I','N','G','_','I','R','Q','_','A','F','T','E','R','_','I','R','E','T',
/* 0x1064c = "VERR_JSON_MISSING_SURROGATE_PAIR" */
    '\x01','J','S','O','N','_','M','I','S','S','I','N','G','_','S','U','R','R','O','G','A','T','E','_','P','A','I','R',
/* 0x10668 = "Invalid unit magic (internal data tag)." */
    '\x0b','u','n','i','t',' ','m','a','g','i','c',' ','(','i','n','t','e','r','n','a','l',' ','\x8f','t','a','g',')','.',
/* 0x10684 = "Unknown X.509 certificate signature algorithm." */
    '\xdf','X','.','5','0','9',' ','\x8a','s','i','g','n','a','t','u','r','e',' ','a','l','g','o','r','i','t','h','m','.',
/* 0x106a0 = "The fatal variant of VINF_EM_NO_MEMORY." */
    '\x03','f','a','t','a','l',' ','v','a','r','i','a','n','t',' ','\x13','\x19','E','M','_','\xb7','M','E','M','O','R','Y','.',
/* 0x106bc = "Invalid (malformed) file/path name." */
    '\x0b','(','m','a','l','f','o','r','m','e','d',')',' ','f','i','l','e','/','p','a','t','h',' ','n','a','m','e','.',
/* 0x106d8 = "VERR_CR_PKCS7_SIGNER_CERT_NOT_SHIPPED" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','R','_','C','E','R','T','_','\x14','S','H','I','P','P','E','D',
/* 0x106f4 = "VERR_HARDAVL_INDEX_OUT_OF_BOUNDS" */
    '\x01','H','A','R','D','A','V','L','_','I','N','D','E','X','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x10710 = "The module contains no line number information." */
    '\x03','m','o','d','u','l','e',' ','\x7f','\xe9','l','i','n','e',' ','\xdd','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x1072c = "Reason for leaving RZ: Illegal call to ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','l','l','e','g','a','l',' ','c','a','l','l',' ','\x08','r','i','n','g','-','3','.',
/* 0x10748 = "Unable to establish trusted of VM process (2)." */
    '\xca','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x13','\xcf',' ','\x82','(','2',')','.',
/* 0x10764 = "VERR_SUP_VP_NT_MAPPING_NAME_CHANGED" */
    '\x01','\xe6','V','P','_','N','T','_','M','A','P','P','I','N','G','_','N','A','M','E','_','C','H','A','N','G','E','D',
/* 0x10780 = "Syntax error - the specified function is not a function." */
    '\xe1','\x07','-',' ','\x02','\x16','f','u','n','c','t','i','o','n',' ','\x09','\x05','a',' ','f','u','n','c','t','i','o','n','.',
/* 0x1079c = "Final OpenSSL PKIX signing failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','s','i','g','n','i','n','g',' ','\x24',
/* 0x107b8 = "Guest mappings are disabled." */
    'G','u','e','s','t',' ','m','a','p','p','i','n','g','s',' ','a','r','e',' ','d','i','s','a','b','l','e','d','.',
/* 0x107d4 = "Not in the correct state for the attempted operation." */
    'N','o','t',' ','\x0d','\x02','c','o','r','r','e','c','t',' ','\xb0','\x0e','\x02','a','t','t','e','m','p','t','e','d',' ','\xcc',
/* 0x107f0 = "Too little data in ASN.1 byte stream." */
    '\xf0','l','i','t','t','l','e',' ','\x8f','\x0d','A','S','N','.','1',' ','b','y','t','e',' ','s','t','r','e','a','m','.',
/* 0x1080c = "The specified disk or diskette cannot be accessed." */
    '\x03','\x16','d','i','s','k',' ','\x86','d','i','s','k','e','t','t','e',' ','\xcb','\x90','a','c','c','e','s','s','e','d','.',
/* 0x10828 = "VINF_EM_RAW_EXCEPTION_PRIVILEGED" */
    '\x19','E','M','_','R','A','W','_','E','X','C','E','P','T','I','O','N','_','P','R','I','V','I','L','E','G','E','D',
/* 0x10844 = "VERR_DBGC_PARSE_WRITEONLY_SYMBOL" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','W','R','I','T','E','O','N','L','Y','_','S','Y','M','B','O','L',
/* 0x10860 = "VERR_ISOMK_IMPORT_BOOT_CAT_INVALID_BOOT_MEDIA_TYPE" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','\x0f','B','O','O','T','_','M','E','D','I','A','_','T','Y','P','E',
/* 0x1087c = "VERR_ISOMK_BOOT_CAT_NO_VALIDATION_ENTRY" */
    '\x01','\xaa','B','O','O','T','_','C','A','T','_','\xb7','V','A','L','I','D','A','T','I','O','N','_','E','N','T','R','Y',
/* 0x10898 = "VERR_JSON_INVALID_UTF16_ESCAPE_SEQUENCE" */
    '\x01','J','S','O','N','_','\x0f','U','T','F','1','6','_','E','S','C','A','P','E','_','S','E','Q','U','E','N','C','E',
/* 0x108b4 = "Unable to establish trusted of VM process (0)." */
    '\xca','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x13','\xcf',' ','\x82','(','0',')','.',
/* 0x108d0 = "VERR_ISOMK_IMPORT_ROOT_DIR_WITHOUT_DIR_FLAG" */
    '\x01','\xaa','\xd4','R','O','O','T','_','D','I','R','_','W','I','T','H','O','U','T','_','D','I','R','_','F','L','A','G',
/* 0x108ec = "The device instance have no base interface." */
    '\x03','\x8b','i','n','s','t','a','n','c','e',' ','\xeb','\xe9','b','a','s','e',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x10908 = "Error getting a data from the extension." */
    '\xac','g','e','t','t','i','n','g',' ','a',' ','\x8f','f','r','o','m',' ','\x02','e','x','t','e','n','s','i','o','n','.',
/* 0x10924 = "VERR_SSM_INTEGRITY_DECOMPRESSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','D','E','C','O','M','P','R','E','S','S','I','O','N',
/* 0x10940 = "VERR_PDM_TOO_MANY_USB_DEVICE_INSTANCES" */
    '\x01','\xb8','\x9f','M','A','N','Y','_','U','S','B','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x1095c = "VERR_VMX_UNEXPECTED_INTERRUPTION_EXIT_TYPE" */
    '\x01','V','M','X','_','\xce','I','N','T','E','R','R','U','P','T','I','O','N','_','E','X','I','T','_','T','Y','P','E',
/* 0x10978 = "Unable to establish trusted of VM process (5)." */
    '\xca','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x13','\xcf',' ','\x82','(','5',')','.',
/* 0x10994 = "VERR_ASN1_INVALID_PRINTABLE_STRING_ENCODING" */
    '\x01','\xf2','\x0f','P','R','I','N','T','A','B','L','E','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x109b0 = "VERR_ASN1_INVALID_UNIVERSAL_STRING_ENCODING" */
    '\x01','\xf2','\x0f','U','N','I','V','E','R','S','A','L','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x109cc = "The file list doesn't match to the content of the manifest file." */
    '\x03','\x18','l','i','s','t',' ','\xa5','\xe3','\x08','\x02','\xd8','\x13','\x02','m','a','n','i','f','e','s','t',' ','f','i','l','e','.',
/* 0x109e8 = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_VALIDATION_KEYS" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','\xa0','V','A','L','I','D','A','T','I','O','N','_','K','E','Y','S',
/* 0x10a04 = "VERR_SUP_VP_NOT_SIGNED_WITH_BUILD_CERT" */
    '\x01','\xe6','V','P','_','\x14','S','I','G','N','E','D','_','W','I','T','H','_','B','U','I','L','D','_','C','E','R','T',
/* 0x10a20 = "VERR_PDM_HPET_LEGACY_NOTIFY_MISSING" */
    '\x01','\xb8','H','P','E','T','_','L','E','G','A','C','Y','_','N','O','T','I','F','Y','_','M','I','S','S','I','N','G',
/* 0x10a3c = "Encountered an unexpected attribute form." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x10a58 = "AMD-V bit not set in K6_EFER MSR." */
    'A','M','D','-','V',' ','b','i','t',' ','\x05','s','e','t',' ','\x0d','K','6','_','E','F','E','R',' ','M','S','R','.',
/* 0x10a74 = "A boot catalog entry in the import ISO has an unknown type." */
    'A',' ','b','o','o','t',' ','\xcd','\xb5','\x0d','\x02','i','m','p','o','r','t',' ','\xb2',' ','\x1d','\x60','\xfc','t','y','p','e','.',
/* 0x10a90 = "VERR_FTP_DATA_CONN_LIMIT_REACHED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x10aac = "Specified access handler was not found." */
    'S','p','e','c','i','f','i','e','d',' ','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x10','\x05','\x7d',
/* 0x10ac8 = "VERR_DBGC_PARSE_UNBALANCED_QUOTE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','U','N','B','A','L','A','N','C','E','D','_','Q','U','O','T','E',
/* 0x10ae4 = "Unable to establish trusted of VM process (3)." */
    '\xca','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x13','\xcf',' ','\x82','(','3',')','.',
/* 0x10b00 = "Severely compromised digest." */
    'S','e','v','e','r','e','l','y',' ','c','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x10b1c = "VERR_CR_PKCS7_BAD_CONTENT_TYPE_ATTRIB" */
    '\x01','\xa9','P','K','C','S','7','_','\xa0','C','O','N','T','E','N','T','_','T','Y','P','E','_','A','T','T','R','I','B',
/* 0x10b38 = "Syntax error - incorrect argument type." */
    '\xe1','\x07','-',' ','i','n','c','o','r','r','e','c','t',' ','a','r','g','u','m','e','n','t',' ','t','y','p','e','.',
/* 0x10b54 = "VERR_IPC_RECEIVE_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x10b70 = "The indirect data digest size does not match the digest algorithm." */
    '\x03','i','n','d','i','r','e','c','t',' ','\x8f','\xc2','\xf8','\x9c','\x05','\xe3','\x02','\xc2','a','l','g','o','r','i','t','h','m','.',
/* 0x10b8c = "Generic failure during disassembly." */
    '\x96','f','a','i','l','u','r','e',' ','d','u','r','i','n','g',' ','d','i','s','a','s','s','e','m','b','l','y','.',
/* 0x10ba8 = "VERR_FDT_DTB_PROP_SIZE_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','P','R','O','P','_','S','I','Z','E','_','M','A','L','F','O','R','M','E','D',
/* 0x10bc4 = "VERR_CR_CIPHER_OSSL_ENCRYPT_INIT_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','E','N','C','R','Y','P','T','_','I','N','I','T','_','\x93',
/* 0x10be0 = "Already aliased to the same page." */
    'A','l','r','e','a','d','y',' ','a','l','i','a','s','e','d',' ','\x08','\x02','s','a','m','e',' ','p','a','g','e','.',
/* 0x10bfc = "VERR_XAR_EXTRACTED_SIZE_EXCEEDED" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','S','I','Z','E','_','E','X','C','E','E','D','E','D',
/* 0x10c18 = "An operation caused a nested-guest VM-exit." */
    'A','n',' ','\x83','c','a','u','s','e','d',' ','a',' ','n','e','s','t','e','d','-','\xa1','\xcf','-','e','x','i','t','.',
/* 0x10c34 = "VERR_CODE_POINT_ENDIAN_INDICATOR" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','E','N','D','I','A','N','_','I','N','D','I','C','A','T','O','R',
/* 0x10c50 = "Unexpected NULL pointer to left subtree." */
    '\x85','N','U','L','L',' ','p','o','i','n','t','e','r',' ','\x08','l','e','f','t',' ','s','u','b','t','r','e','e','.',
/* 0x10c6c = "Attempt to pause a paused TSC." */
    'A','t','t','e','m','p','t',' ','\x08','p','a','u','s','e',' ','a',' ','p','a','u','s','e','d',' ','T','S','C','.',
/* 0x10c88 = "The specified shared page was not actually shared." */
    '\x03','\x16','s','h','a','r','e','d',' ','\xb6','\x10','\x05','a','c','t','u','a','l','l','y',' ','s','h','a','r','e','d','.',
/* 0x10ca4 = "Invalid format of managed object reference." */
    '\x0b','f','o','r','m','a','t',' ','\x13','m','a','n','a','g','e','d',' ','\x8d','r','e','f','e','r','e','n','c','e','.',
/* 0x10cc0 = "Recompiler: No temporary host register available." */
    '\x11','\xd0','t','e','m','p','o','r','a','r','y',' ','h','o','s','t',' ','\xbc','a','v','a','i','l','a','b','l','e','.',
/* 0x10cdc = "VERR_VGA_UNEXPECTED_PCI_REGION_LOAD_CHANGE" */
    '\x01','V','G','A','_','\xce','P','C','I','_','R','E','G','I','O','N','_','L','O','A','D','_','C','H','A','N','G','E',
/* 0x10cf8 = "VERR_CR_KEY_ALGO_PARAMS_UNEXPECTED" */
    '\x01','\xa9','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','E','X','P','E','C','T','E','D',
/* 0x10d14 = "The guest LDT selector is out of bounds." */
    '\x03','\xa1','L','D','T',' ','s','e','l','e','c','t','o','r',' ','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x10d30 = "VERR_TM_GIP_UPDATE_INTERVAL_TOO_BIG" */
    '\x01','T','M','_','G','I','P','_','U','P','D','A','T','E','_','I','N','T','E','R','V','A','L','_','\x9f','B','I','G',
/* 0x10d4c = "VERR_SUP_VP_IMAGE_CHARECTERISTICS_MISMATCH" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x99',
/* 0x10d68 = "The media is locked and cannot be unmounted." */
    '\x03','m','e','d','i','a',' ','\x09','l','o','c','k','e','d',' ','\x2a','\xcb','\x90','u','n','m','o','u','n','t','e','d','.',
/* 0x10d84 = "VERR_PAGE_DIRECTORY_PTR_NOT_PRESENT" */
    '\x01','P','A','G','E','_','D','I','R','E','C','T','O','R','Y','_','P','T','R','_','\x14','P','R','E','S','E','N','T',
/* 0x10da0 = "VERR_CR_SPC_EXPECTED_PE_IMAGE_DATA" */
    '\x01','\xa9','S','P','C','_','E','X','P','E','C','T','E','D','_','P','E','_','I','M','A','G','E','_','D','A','T','A',
/* 0X10dbc = "A non-directory entry has a name ending with a slash." */
    ' ','n','o','n','-','\x1b','\xb5','\x1d','a',' ','\xf3','e','n','d','i','n','g',' ','\x1e','a',' ','s','l','a','s','h','.',
/* 0x10dd7 = "VERR_INTNET_FLT_LOWER_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','L','O','W','E','R','_','L','I','N','K','_','I','D','_','\x14','\xb3',
/* 0x10df3 = "The filename or extension is too long." */
    '\x03','f','i','l','e','n','a','m','e',' ','\x86','e','x','t','e','n','s','i','o','n',' ','\x09','\x8c','l','o','n','g','.',
/* 0x10e0f = "VERR_DBGF_BP_INT3_ADD_TRIES_REACHED" */
    '\x01','\xf1','_','B','P','_','I','N','T','3','_','A','D','D','_','T','R','I','E','S','_','R','E','A','C','H','E','D',
/* 0x10e2b = "Shared Clipboard event ID not found." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','I','D',' ','\x05','\x7d',
/* 0x10e47 = "Too many volume descriptors in the import ISO." */
    '\xf0','\xa3','\xbd','d','e','s','c','r','i','p','t','o','r','s',' ','\x0d','\x02','i','m','p','o','r','t',' ','I','S','O','.',
/* 0x10e63 = "VERR_IOSMK_IMPORT_PRIMARY_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\xd4','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x10e7f = "Bogus reference to freed node." */
    'B','o','g','u','s',' ','r','e','f','e','r','e','n','c','e',' ','\x08','f','r','e','e','d',' ','n','o','d','e','.',
/* 0x10e9b = "VERR_GIM_HYPERCALL_MEMORY_READ_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','M','E','M','O','R','Y','_','R','E','A','D','_','\x93',
/* 0x10eb7 = "Invalid entry in the driver registration structure." */
    '\x0b','\xb5','\x0d','\x02','\xa8','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x10ed3 = "VERR_CR_PKIX_OSSL_D2I_KEY_PARAMS_FAILED" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','D','2','I','_','K','E','Y','_','P','A','R','A','M','S','_','\x93',
/* 0x10eef = "Unable to establish trusted of VM process (1)." */
    '\xca','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x13','\xcf',' ','\x82','(','1',')','.',
/* 0x10f0b = "APIC did not accept the interrupt." */
    'A','P','I','C',' ','d','i','d',' ','\x05','a','c','c','e','p','t',' ','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x10f27 = "Device creation failed because the USB device name was not found." */
    'D','e','v','i','c','e',' ','c','r','e','a','t','i','o','n',' ','\x88','\x1c','\x02','U','S','B',' ','\x8b','\xf3','\x10','\x05','\x7d',
/* 0x10f43 = "VERR_TAR_NON_DIR_ENDS_WITH_SLASH" */
    '\x01','T','A','R','_','N','O','N','_','D','I','R','_','E','N','D','S','_','W','I','T','H','_','S','L','A','S','H',
/* 0x10f5f = "Invalid entry in the device registration structure." */
    '\x0b','\xb5','\x0d','\x02','\x8b','r','e','g','i','s','t','r','a','t','i','o','n',' ','s','t','r','u','c','t','u','r','e','.',
/* 0x10f7b = "VERR_ASN1_INVALID_GENERALIZED_TIME_ENCODING" */
    '\x01','\xf2','\x0f','G','E','N','E','R','A','L','I','Z','E','D','_','T','I','M','E','_','E','N','C','O','D','I','N','G',
/* 0x10f97 = "Current session state prohibits operation." */
    'C','u','r','r','e','n','t',' ','s','e','s','s','i','o','n',' ','\xb0','p','r','o','h','i','b','i','t','s',' ','\xcc',
/* 0x10fb3 = "VERR_SSM_ENUM_VALUE_OUT_OF_RANGE" */
    '\x01','S','S','M','_','E','N','U','M','_','V','A','L','U','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x10fcf = "The ELF loader encountered an unterminated string table." */
    '\x03','E','L','F',' ','\xc4','\x98','\x60','u','n','t','e','r','m','i','n','a','t','e','d',' ','\xc7','t','a','b','l','e','.',
/* 0x10feb = "This VirtualBox build does not support raw-mode." */
    'T','h','i','s',' ','\xe2','B','o','x',' ','b','u','i','l','d',' ','\x9c','\x05','\xb1','r','a','w','-','m','o','d','e','.',
/* 0x11007 = "VERR_X509_PRINT_EXTENSION_TO_BIO" */
    '\x01','X','5','0','9','_','P','R','I','N','T','_','E','X','T','E','N','S','I','O','N','_','T','O','_','B','I','O',
/* 0x11023 = "Failed to allocate temporary memory." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','t','e','m','p','o','r','a','r','y',' ','m','e','m','o','r','y','.',
/* 0x1103f = "A required header parmaeter was not set." */
    'A',' ','r','e','q','u','i','r','e','d',' ','\xa2','p','a','r','m','a','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x1105b = "Device i/o: General failure." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','G','e','n','e','r','a','l',' ','f','a','i','l','u','r','e','.',
/* 0x11077 = "The current HTTP request was forcefully aborted." */
    '\x03','\xd1','H','T','T','P',' ','\x94','\x10','f','o','r','c','e','f','u','l','l','y',' ','a','b','o','r','t','e','d','.',
/* 0x11093 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_OFF_BAD" */
    '\x01','\xdc','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','O','F','F','_','B','A','D',
/* 0x110af = "Empty set inside X.509 name." */
    'E','m','p','t','y',' ','s','e','t',' ','i','n','s','i','d','e',' ','X','.','5','0','9',' ','n','a','m','e','.',
/* 0x110cb = "VERR_CR_PKIX_OSSL_D2I_PUBLIC_KEY_FAILED" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','D','2','I','_','P','U','B','L','I','C','_','K','E','Y','_','\x93',
/* 0x110e7 = "VERR_ISOMK_IMPORT_MULTIPLE_JOLIET_VOL_DESCS" */
    '\x01','\xaa','\xd4','M','U','L','T','I','P','L','E','_','J','O','L','I','E','T','_','V','O','L','_','D','E','S','C','S',
/* 0x11103 = "VERR_GVMM_NOT_ALL_EMTS_DEREGISTERED" */
    '\x01','G','V','M','M','_','\x14','A','L','L','_','E','M','T','S','_','D','E','R','E','G','I','S','T','E','R','E','D',
/* 0x1111f = "Import ISO contains a directory with a bad record length." */
    '\xaf','\xb2',' ','\x7f','a',' ','\x1b','\x1e','a',' ','b','a','d',' ','r','e','c','o','r','d',' ','l','e','n','g','t','h','.',
/* 0x1113b = "VERR_MAIN_CONFIG_CONSTRUCTOR_IPE" */
    '\x01','M','A','I','N','_','C','O','N','F','I','G','_','C','O','N','S','T','R','U','C','T','O','R','_','I','P','E',
/* 0x11157 = "Unexpected MSR in the auto-load/store area." */
    '\x85','M','S','R',' ','\x0d','\x02','a','u','t','o','-','l','o','a','d','/','s','t','o','r','e',' ','a','r','e','a','.',
/* 0x11173 = "VERR_CR_CIPHER_OSSL_DECRYPT_INIT_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x93',
/* 0x1118f = "Generic: Invalid image file header. Use this for plugins." */
    'G','e','n','e','r','i','c',':',' ','\x0b','\x1a','\x18','\xe7',' ','U','s','e',' ','\xc9','\x0e','p','l','u','g','i','n','s','.',
/* 0x111ab = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_BUSY" */
    '\x01','\xdc','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','B','U','S','Y',
/* 0x111c7 = "Unable to establish trusted of VM process (4)." */
    '\xca','\x08','e','s','t','a','b','l','i','s','h',' ','t','r','u','s','t','e','d',' ','\x13','\xcf',' ','\x82','(','4',')','.',
/* 0x111e3 = "VERR_GIM_HYPERCALL_ACCESS_DENIED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x111ff = "Get register caller must flush the TLB." */
    'G','e','t',' ','\xbc','c','a','l','l','e','r',' ','m','u','s','t',' ','f','l','u','s','h',' ','\x02','T','L','B','.',
/* 0x1121b = "The dynamic mapping cache for physical memory failed." */
    '\x03','d','y','n','a','m','i','c',' ','\xe0','c','a','c','h','e',' ','\x0e','p','h','y','s','i','c','a','l',' ','\x5c','\x24',
/* 0x11237 = "A digest type used in the manifest file isn\'t supported." */
    'A',' ','\xc2','\xd9','u','s','e','d',' ','\x0d','\x02','m','a','n','i','f','e','s','t',' ','\x18','i','s','n','\'','t',' ','\x95',
/* 0x11253 = "VERR_ISOMK_IMPORT_BOOT_CAT_DEF_ENTRY_INVALID_FLAGS" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','D','E','F','_','E','N','T','R','Y','_','\x0f','F','L','A','G','S',
/* 0x1126f = "VERR_CR_SPC_PEIMAGE_URL_UNEXPECTED" */
    '\x01','\xa9','S','P','C','_','P','E','I','M','A','G','E','_','U','R','L','_','U','N','E','X','P','E','C','T','E','D',
/* 0x1128b = "No validation entry in the boot catalog." */
    '\xd0','v','a','l','i','d','a','t','i','o','n',' ','\xb5','\x0d','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x112a7 = "Invalid size of a SSM field with the specified transformation." */
    '\x0b','\xf8','\x13','a',' ','S','S','M',' ','\xff','\x1e','\x02','\x16','t','r','a','n','s','f','o','r','m','a','t','i','o','n','.',
/* 0x112c3 = "Unhandled #DB in hypervisor code." */
    'U','n','h','a','n','d','l','e','d',' ','#','D','B',' ','\x0d','h','y','p','e','r','v','i','s','o','r',' ','\x5e',
/* 0x112de = "Hit a todo in the mach-o loader." */
    'H','i','t',' ','a',' ','t','o','d','o',' ','\x0d','\x02','m','a','c','h','-','o',' ','l','o','a','d','e','r','.',
/* 0x112f9 = "Bad iterdata2 (EXEPACK2) data." */
    '\x92','i','t','e','r','d','a','t','a','2',' ','(','E','X','E','P','A','C','K','2',')',' ','d','a','t','a','.',
/* 0x11314 = "Unexpected ASN.1 tag encountered while decoding." */
    '\x85','A','S','N','.','1',' ','t','a','g',' ','\x98','w','h','i','l','e',' ','d','e','c','o','d','i','n','g','.',
/* 0x1132f = "Invalid environment variable name." */
    '\x0b','e','n','v','i','r','o','n','m','e','n','t',' ','v','a','r','i','a','b','l','e',' ','n','a','m','e','.',
/* 0x1134a = "VERR_VFS_CHAIN_CANNOT_BE_FIRST_ELEMENT" */
    '\x01','\xa4','_','\xda','C','A','N','N','O','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x11365 = "VERR_CR_X509_CPV_NO_PERMITTED_NAMES" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\xb7','P','E','R','M','I','T','T','E','D','_','N','A','M','E','S',
/* 0x11380 = "HGCM could not perform requested operation because of an internal error." */
    'H','G','C','M',' ','c','o','u','l','d',' ','\x05','p','e','r','f','o','r','m',' ','\xbf','\x83','\x1c','\x13','\x60','\x15','\x7b',
/* 0x1139b = "VERR_AUDIO_NO_FREE_OUTPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\xb7','F','R','E','E','_','O','U','T','P','U','T','_','S','T','R','E','A','M','S',
/* 0x113b6 = "Trying to free a page that isn\'t RAM." */
    'T','r','y','i','n','g',' ','\x08','f','r','e','e',' ','a',' ','\xb6','\x89','i','s','n','\'','t',' ','R','A','M','.',
/* 0x113d1 = "VERR_SHCLPB_MAX_OBJECTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','O','B','J','E','C','T','S','_','R','E','A','C','H','E','D',
/* 0x113ec = "VERR_ISOMK_IMPORT_ROOT_DIR_IS_MULTI_EXTENT" */
    '\x01','\xaa','\xd4','R','O','O','T','_','D','I','R','_','I','S','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x11407 = "VERR_REST_UNABLE_TO_DECODE_DATE" */
    '\x01','R','E','S','T','_','U','N','A','B','L','E','_','T','O','_','D','E','C','O','D','E','_','D','A','T','E',
/* 0x11422 = "VRPD receives a packet that is not supported." */
    'V','R','P','D',' ','r','e','c','e','i','v','e','s',' ','a',' ','p','a','c','k','e','t',' ','\x89','\x09','\x05','\x95',
/* 0x1143d = "Recompiler: Register allocator internal processing error #13." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','1','3','.',
/* 0x11458 = "Internal error obtaining the GVMM instance." */
    '\x06','\x07','o','b','t','a','i','n','i','n','g',' ','\x02','G','V','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x11473 = "Could not recognize the key type." */
    'C','o','u','l','d',' ','\x05','r','e','c','o','g','n','i','z','e',' ','\x02','k','e','y',' ','t','y','p','e','.',
/* 0x1148e = "VINF_PDM_MEDIAEX_IOREQ_IN_PROGRESS" */
    '\x19','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x114a9 = "Internal ISO maker error: Read file data probem #3." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','R','e','a','d',' ','\x18','\x8f','p','r','o','b','e','m',' ','#','3','.',
/* 0x114c4 = "The image is too small or too large for this format." */
    '\x03','\x1a','\x09','\x8c','s','m','a','l','l',' ','\x86','\x8c','l','a','r','g','e',' ','\x0e','\xc9','f','o','r','m','a','t','.',
/* 0x114df = "The size field should be zero for links and symlinks." */
    '\x03','\xf8','\xff','\xec','\x90','z','e','r','o',' ','\x0e','l','i','n','k','s',' ','\x2a','s','y','m','l','i','n','k','s','.',
/* 0x114fa = "Too many loops looking for a page to reuse." */
    '\xf0','\xa3','l','o','o','p','s',' ','l','o','o','k','i','n','g',' ','\x0e','a',' ','\xb6','\x08','r','e','u','s','e','.',
/* 0x11515 = "Invalid UTF-8 encoding in the response." */
    '\x0b','U','T','F','-','8',' ','e','n','c','o','d','i','n','g',' ','\x0d','\x02','r','e','s','p','o','n','s','e','.',
/* 0x11530 = "No more search handles available." */
    '\xd0','\xf6','s','e','a','r','c','h',' ','h','a','n','d','l','e','s',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x1154b = "Invalid image relative virtual address." */
    '\x0b','\x1a','r','e','l','a','t','i','v','e',' ','v','i','r','t','u','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x11566 = "The size of the raw image is not dividable by 2048." */
    '\x03','\xf8','\x13','\x02','r','a','w',' ','\x1a','\x09','\x05','d','i','v','i','d','a','b','l','e',' ','\xb9','2','0','4','8','.',
/* 0x11581 = "Bad VTG probe location record." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','l','o','c','a','t','i','o','n',' ','r','e','c','o','r','d','.',
/* 0x1159c = "VERR_CR_KEY_MISSING_CIPHER_PARAMS" */
    '\x01','\xa9','K','E','Y','_','M','I','S','S','I','N','G','_','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x115b7 = "VERR_VUSB_USB_DEVICE_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','_','D','E','V','I','C','E','_','P','E','R','M','I','S','S','I','O','N',
/* 0x115d2 = "VERR_CR_PKCS7_SIGNED_DATA_CERT_NOT_FOUND" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','C','E','R','T','_','\x14','\xb3',
/* 0x115ed = "Dataspace manager server not found." */
    'D','a','t','a','s','p','a','c','e',' ','m','a','n','a','g','e','r',' ','s','e','r','v','e','r',' ','\x05','\x7d',
/* 0x11608 = "VERR_SUP_VP_NT_QI_VIRTUAL_MEMORY_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x9b',
/* 0x11623 = "Invalid ASN.1 BIT STRING encoding." */
    '\x0b','A','S','N','.','1',' ','B','I','T',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x1163e = "VERR_PGM_HANDLER_PHYSICAL_CONFLICT" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','P','H','Y','S','I','C','A','L','_','C','O','N','F','L','I','C','T',
/* 0x11659 = "Floating pointer underflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x11674 = "VERR_CR_PKIX_OSSL_EVP_PKEY_TYPE_ERROR" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','E','V','P','_','P','K','E','Y','_','T','Y','P','E','_','\x9b',
/* 0x1168f = "Failed to get the delta-adjusted TSC value." */
    '\x80','\x08','g','e','t',' ','\x02','d','e','l','t','a','-','a','d','j','u','s','t','e','d',' ','T','S','C',' ','\xd3',
/* 0x116aa = "The machine uuid field wasn\'t null." */
    '\x03','m','a','c','h','i','n','e',' ','u','u','i','d',' ','\xff','w','a','s','n','\'','t',' ','n','u','l','l','.',
/* 0x116c5 = "VERR_TM_TIMER_QUEUE_CANNOT_GROW" */
    '\x01','T','M','_','T','I','M','E','R','_','Q','U','E','U','E','_','C','A','N','N','O','T','_','G','R','O','W',
/* 0x116e0 = "VERR_ISOFS_INCOMPLETE_PART_MAP_TABLE" */
    '\x01','\xfd','I','N','C','O','M','P','L','E','T','E','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x116fb = "Internal ISO maker error: Read file data probem #2." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','R','e','a','d',' ','\x18','\x8f','p','r','o','b','e','m',' ','#','2','.',
/* 0x11716 = "Expected URI using the \'file:\' scheme." */
    '\xa6','U','R','I',' ','u','s','i','n','g',' ','\x02','\'','f','i','l','e',':','\'',' ','s','c','h','e','m','e','.',
/* 0x11731 = "Internal processing error in the PGM physical handler code." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','p','h','y','s','i','c','a','l',' ','h','a','n','d','l','e','r',' ','\x5e',
/* 0x1174c = "VFS chain element expected at least one argument." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','l','e','a','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x11767 = "The paging mode of the host is not supported yet." */
    '\x03','p','a','g','i','n','g',' ','m','o','d','e',' ','\x13','\x02','h','o','s','t',' ','\x09','\x05','\xf9','y','e','t','.',
/* 0x11782 = "VERR_PATH_DOES_NOT_START_WITH_ROOT" */
    '\x01','P','A','T','H','_','D','O','E','S','_','\x14','S','T','A','R','T','_','W','I','T','H','_','R','O','O','T',
/* 0x1179d = "Maximum number of mappings reached." */
    'M','a','x','i','m','u','m',' ','\xdd','\x13','m','a','p','p','i','n','g','s',' ','r','e','a','c','h','e','d','.',
/* 0x117b8 = "Recompiler: Register allocator internal processing error #12." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','1','2','.',
/* 0x117d3 = "OpenSSL failed to clone the digest algorithm context." */
    'O','p','e','n','S','S','L',' ','\x88','\x08','c','l','o','n','e',' ','\x02','\xc2','\xbe','c','o','n','t','e','x','t','.',
/* 0x117ee = "VDI: Invalid image file header: invalid signature." */
    'V','D','I',':',' ','\x0b','\x1a','\x18','h','e','a','d','e','r',':',' ','\x81','s','i','g','n','a','t','u','r','e','.',
/* 0x11809 = "VERR_ASN1_INVALID_VIDEOTEX_STRING_ENCODING" */
    '\x01','\xf2','\x0f','V','I','D','E','O','T','E','X','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x11824 = "VERR_DBGC_PARSE_TOO_MANY_ARGUMENTS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x9f','M','A','N','Y','_','A','R','G','U','M','E','N','T','S',
/* 0x1183f = "VERR_VFS_CHAIN_ONLY_FILE_OR_IOS_OR_DIR" */
    '\x01','\xa4','_','\xda','O','N','L','Y','_','F','I','L','E','_','O','R','_','I','O','S','_','O','R','_','D','I','R',
/* 0x1185a = "Error while parsing UUID string." */
    '\xac','w','h','i','l','e',' ','p','a','r','s','i','n','g',' ','U','U','I','D',' ','s','t','r','i','n','g','.',
/* 0x11875 = "VERR_CR_PKCS7_SIGNER_INFO_VERSION" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','R','_','I','N','F','O','_','V','E','R','S','I','O','N',
/* 0x11890 = "VERR_CPUM_TOO_MANY_CPUID_SUBLEAVES" */
    '\x01','C','P','U','M','_','\x9f','M','A','N','Y','_','C','P','U','I','D','_','S','U','B','L','E','A','V','E','S',
/* 0x118ab = "VERR_ISOMK_IMPORT_DOT_DIR_REC_BAD_NAME_LENGTH" */
    '\x01','\xaa','\xd4','D','O','T','_','D','I','R','_','R','E','C','_','\xa0','N','A','M','E','_','L','E','N','G','T','H',
/* 0x118c6 = "The specified at reset handler wasn\'t found." */
    '\x03','\x16','a','t',' ','r','e','s','e','t',' ','h','a','n','d','l','e','r',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x118e1 = "Malformed checksum field in the tar header." */
    'M','a','l','f','o','r','m','e','d',' ','c','h','e','c','k','s','u','m',' ','\xff','\x0d','\x02','t','a','r',' ','\xe7',
/* 0x118fc = "VERR_SUPDRV_VTG_ONLY_ONCE_PER_SESSION" */
    '\x01','\xdc','V','T','G','_','O','N','L','Y','_','O','N','C','E','_','P','E','R','_','S','E','S','S','I','O','N',
/* 0x11917 = "VERR_CR_PKCS7_DIGEST_PARAMS_NOT_IMPL" */
    '\x01','\xa9','P','K','C','S','7','_','D','I','G','E','S','T','_','P','A','R','A','M','S','_','\x14','I','M','P','L',
/* 0x11932 = "VERR_TAR_MALFORMED_GNU_LONGXXXX" */
    '\x01','T','A','R','_','M','A','L','F','O','R','M','E','D','_','G','N','U','_','L','O','N','G','X','X','X','X',
/* 0x1194d = "More unconsumed data available." */
    'M','o','r','e',' ','u','n','c','o','n','s','u','m','e','d',' ','\x8f','a','v','a','i','l','a','b','l','e','.',
/* 0x11968 = "VERR_X509_READING_CERT_FROM_BIO" */
    '\x01','X','5','0','9','_','R','E','A','D','I','N','G','_','C','E','R','T','_','F','R','O','M','_','B','I','O',
/* 0x11983 = "Image Verification Failure: No Authenticode Signature." */
    '\xfe','\x0c','\x12','\xd0','A','u','t','h','e','n','t','i','c','o','d','e',' ','S','i','g','n','a','t','u','r','e','.',
/* 0x1199e = "Constructed string type not implemented." */
    'C','o','n','s','t','r','u','c','t','e','d',' ','\xc7','\xd9','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x119b9 = "The ELF loader encountered an invalid relocation offset." */
    '\x03','E','L','F',' ','\xc4','\x98','\x60','\x81','r','e','l','o','c','a','t','i','o','n',' ','o','f','f','s','e','t','.',
/* 0x119d4 = "VERR_XAR_MISSING_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x119ef = "Invalid CPUMCPU offset in MSR range." */
    '\x0b','C','P','U','M','C','P','U',' ','o','f','f','s','e','t',' ','\x0d','M','S','R',' ','r','a','n','g','e','.',
/* 0x11a0a = "VERR_DBG_SEGMENT_INDEX_CONFLICT" */
    '\x01','D','B','G','_','S','E','G','M','E','N','T','_','I','N','D','E','X','_','C','O','N','F','L','I','C','T',
/* 0x11a25 = "VERR_LDRVI_NO_MEMORY_PARSE_OUTPUT" */
    '\x01','L','D','R','V','I','_','\xb7','M','E','M','O','R','Y','_','P','A','R','S','E','_','O','U','T','P','U','T',
/* 0x11a40 = "VERR_HARDAVL_MISALIGNED_POINTER" */
    '\x01','H','A','R','D','A','V','L','_','M','I','S','A','L','I','G','N','E','D','_','P','O','I','N','T','E','R',
/* 0x11a5b = "Asynchronous I/O request finished." */
    'A','s','y','n','c','h','r','o','n','o','u','s',' ','I','/','O',' ','\x94','f','i','n','i','s','h','e','d','.',
/* 0x11a76 = "VERR_ISOMK_IMPORT_MULTIPLE_EL_TORITO_DESCS" */
    '\x01','\xaa','\xd4','M','U','L','T','I','P','L','E','_','E','L','_','T','O','R','I','T','O','_','D','E','S','C','S',
/* 0x11a91 = "VERR_SSM_INTEGRITY_REC_TERM_CRC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','R','E','C','_','T','E','R','M','_','C','R','C',
/* 0x11aac = "VERR_GSTCTL_PROCESS_WRONG_STATE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','W','R','O','N','G','_','S','T','A','T','E',
/* 0x11ac7 = "Internal ISO maker error: Unexpected empty component." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','\x85','e','m','p','t','y',' ','c','o','m','p','o','n','e','n','t','.',
/* 0x11ae2 = "VERR_SSM_INTEGRITY_VBOX_VERSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','V','B','O','X','_','V','E','R','S','I','O','N',
/* 0x11afd = "The URI is too short to be a valid URI." */
    '\x03','U','R','I',' ','\x09','\x8c','s','h','o','r','t',' ','\x08','\x90','a',' ','v','a','l','i','d',' ','U','R','I','.',
/* 0x11b18 = "Process Verification Failure: A DLL was found more than once." */
    '\x17','\x0c','\x12','A',' ','D','L','L',' ','\x10','f','o','u','n','d',' ','\xf6','t','h','a','n',' ','o','n','c','e','.',
/* 0x11b33 = "Too many references: can\'t splice." */
    '\xf0','\xa3','r','e','f','e','r','e','n','c','e','s',':',' ','c','a','n','\'','t',' ','s','p','l','i','c','e','.',
/* 0x11b4e = "Non-string object inside X.509 name object." */
    'N','o','n','-','\xc7','\x8d','i','n','s','i','d','e',' ','X','.','5','0','9',' ','\xf3','o','b','j','e','c','t','.',
/* 0x11b69 = "VERR_CR_DIGEST_OSSL_DIGEST_INIT_ERROR" */
    '\x01','\xa9','D','I','G','E','S','T','_','O','S','S','L','_','D','I','G','E','S','T','_','I','N','I','T','_','\x9b',
/* 0x11b84 = "Generic object was destroyed by the call status." */
    '\x96','\x8d','\x10','d','e','s','t','r','o','y','e','d',' ','\xb9','\x02','c','a','l','l',' ','s','t','a','t','u','s','.',
/* 0x11b9f = "VERR_CR_SPC_PEIMAGE_DATA_NOT_PRESENT" */
    '\x01','\xa9','S','P','C','_','P','E','I','M','A','G','E','_','D','A','T','A','_','\x14','P','R','E','S','E','N','T',
/* 0x11bba = "Unresolved (unknown) file i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x18','i','/','o',' ','\x7b',
/* 0x11bd5 = "The guest has not setup use of the hypercalls." */
    '\x03','\xa1','\x1d','\x05','s','e','t','u','p',' ','u','s','e',' ','\x13','\x02','h','y','p','e','r','c','a','l','l','s','.',
/* 0x11bf0 = "VERR_LDR_DUPLICATE_SEGMENT_NAME" */
    '\x01','L','D','R','_','D','U','P','L','I','C','A','T','E','_','S','E','G','M','E','N','T','_','N','A','M','E',
/* 0x11c0b = "VERR_CR_X509_CERT_TBS_SIGN_ALGO_MISMATCH" */
    '\x01','\xa9','X','5','0','9','_','C','E','R','T','_','T','B','S','_','S','I','G','N','_','A','L','G','O','_','\x99',
/* 0x11c26 = "Recompiler: Register allocator internal processing error #10." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','1','0','.',
/* 0x11c41 = "Reason for leaving RZ: Emulate instruction." */
    '\x84','\x0e','\x25','R','Z',':',' ','E','m','u','l','a','t','e',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x11c5c = "General saved state file integrity error." */
    'G','e','n','e','r','a','l',' ','s','a','v','e','d',' ','\xb0','\x18','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x11c77 = "VERR_IOQUEUE_HANDLE_NOT_REGISTERED" */
    '\x01','I','O','Q','U','E','U','E','_','H','A','N','D','L','E','_','\x14','R','E','G','I','S','T','E','R','E','D',
/* 0x11c92 = "No memory available for page table or page directory." */
    '\xd0','\x5c','a','v','a','i','l','a','b','l','e',' ','\x0e','\xb6','\x9e','\x86','\xb6','d','i','r','e','c','t','o','r','y','.',
/* 0x11cad = "The shadow paging mode is not supported yet." */
    '\x03','s','h','a','d','o','w',' ','p','a','g','i','n','g',' ','m','o','d','e',' ','\x09','\x05','\xf9','y','e','t','.',
/* 0x11cc8 = "NEM failed to map page(s) into the VM." */
    'N','E','M',' ','\x88','\x08','m','a','p',' ','p','a','g','e','(','s',')',' ','i','n','t','o',' ','\x02','V','M','.',
/* 0x11ce3 = "VERR_DBG_FILE_NAME_OUT_OF_RANGE" */
    '\x01','D','B','G','_','F','I','L','E','_','N','A','M','E','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x11cfe = "VERR_SUPLIB_WRITE_NON_SYS_GROUP" */
    '\x01','S','U','P','L','I','B','_','W','R','I','T','E','_','N','O','N','_','S','Y','S','_','G','R','O','U','P',
/* 0x11d19 = "AMD-V CPU extension in-use." */
    'A','M','D','-','V',' ','C','P','U',' ','e','x','t','e','n','s','i','o','n',' ','i','n','-','u','s','e','.',
/* 0x11d34 = "Trying to free a page with an invalid Page ID." */
    'T','r','y','i','n','g',' ','\x08','f','r','e','e',' ','a',' ','\xb6','\x1e','\x60','\x81','P','a','g','e',' ','I','D','.',
/* 0x11d4f = "VERR_CR_PKCS7_SIGNED_DATA_VERSION" */
    '\x01','\xa9','P','K','C','S','7','_','S','I','G','N','E','D','_','D','A','T','A','_','V','E','R','S','I','O','N',
/* 0x11d6a = "The provider cannot be the first element." */
    '\x03','p','r','o','v','i','d','e','r',' ','\xcb','\x90','\x02','f','i','r','s','t',' ','e','l','e','m','e','n','t','.',
/* 0x11d85 = "Buffer too small to save result." */
    'B','u','f','f','e','r',' ','\x8c','s','m','a','l','l',' ','\x08','s','a','v','e',' ','r','e','s','u','l','t','.',
/* 0x11da0 = "Unresolved (unknown) device i/o error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\x8b','i','/','o',' ','\x7b',
/* 0x11dbb = "VERR_SEM_LV_WRONG_RELEASE_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','R','E','L','E','A','S','E','_','O','R','D','E','R',
/* 0x11dd6 = "VERR_MANIFEST_WRONG_FILE_FORMAT" */
    '\x01','M','A','N','I','F','E','S','T','_','W','R','O','N','G','_','F','I','L','E','_','F','O','R','M','A','T',
/* 0x11df1 = "VINF_IOM_R3_IOPORT_COMMIT_WRITE" */
    '\x19','I','O','M','_','R','3','_','I','O','P','O','R','T','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x11e0c = "VERR_VD_IMAGE_REPAIR_IMPOSSIBLE" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','I','M','P','O','S','S','I','B','L','E',
/* 0x11e27 = "VERR_XAR_MISSING_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x11e42 = "Failed to calculate the TSC frequency." */
    '\x80','\x08','c','a','l','c','u','l','a','t','e',' ','\x02','T','S','C',' ','f','r','e','q','u','e','n','c','y','.',
/* 0x11e5d = "VERR_VD_RAW_SIZE_OPTICAL_TOO_SMALL" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','O','P','T','I','C','A','L','_','\x9f','S','M','A','L','L',
/* 0x11e78 = "Internal ISO maker error: Read file data probem #1." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','R','e','a','d',' ','\x18','\x8f','p','r','o','b','e','m',' ','#','1','.',
/* 0x11e93 = "Expression stack underflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x11eae = "Reason for leaving RC: Inject a TRPM event." */
    '\x84','\x0e','\x25','R','C',':',' ','I','n','j','e','c','t',' ','a',' ','T','R','P','M',' ','e','v','e','n','t','.',
/* 0x11ec9 = "Malformed or invalid file set descriptor location." */
    'M','a','l','f','o','r','m','e','d',' ','\x86','\x81','\x18','s','e','t',' ','\xd6','l','o','c','a','t','i','o','n','.',
/* 0x11ee4 = "VINF_EM_PENDING_R3_IOPORT_WRITE" */
    '\x19','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x11eff = "Process Verification Failure: There are too many DLLs loaded." */
    '\x17','\x0c','\x12','T','h','e','r','e',' ','a','r','e',' ','\x8c','\xa3','D','L','L','s',' ','l','o','a','d','e','d','.',
/* 0x11f1a = "Recompiler: Register allocator internal processing error #11." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','1','1','.',
/* 0x11f35 = "VERR_AUDIO_STREAM_COULD_NOT_CREATE" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','C','O','U','L','D','_','\x14','C','R','E','A','T','E',
/* 0x11f50 = "Invalid ASN.1 BMP STRING encoding." */
    '\x0b','A','S','N','.','1',' ','B','M','P',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x11f6b = "VERR_SHCLPB_LIST_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','L','I','S','T','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x11f86 = "VERR_LDRELF_INVALID_SYMBOL_NAME_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x0f','S','Y','M','B','O','L','_','N','A','M','E','_','O','F','F','S','E','T',
/* 0x11fa1 = "VERR_INTNET_FLT_VNIC_LINK_ID_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','L','I','N','K','_','I','D','_','\x14','\xb3',
/* 0x11fbc = "VERR_ASN1_CURSOR_BAD_INDEFINITE_LENGTH" */
    '\x01','\xf2','C','U','R','S','O','R','_','\xa0','I','N','D','E','F','I','N','I','T','E','_','L','E','N','G','T','H',
/* 0x11fd7 = "Invalid ASN.1 IA5 STRING encoding." */
    '\x0b','A','S','N','.','1',' ','I','A','5',' ','S','T','R','I','N','G',' ','e','n','c','o','d','i','n','g','.',
/* 0x11ff2 = "VERR_LDRMACHO_NON_CONT_SEG_BITS" */
    '\x01','L','D','R','M','A','C','H','O','_','N','O','N','_','C','O','N','T','_','S','E','G','_','B','I','T','S',
/* 0x1200d = "VERR_CR_X509_CERTPATHS_INTERNAL_ERROR" */
    '\x01','\xa9','X','5','0','9','_','C','E','R','T','P','A','T','H','S','_','I','N','T','E','R','N','A','L','_','\x9b',
/* 0x12028 = "Syntax error - unbalanced parenthesis." */
    '\xe1','\x07','-',' ','u','n','b','a','l','a','n','c','e','d',' ','p','a','r','e','n','t','h','e','s','i','s','.',
/* 0x12043 = "Expression stack overflow." */
    'E','x','p','r','e','s','s','i','o','n',' ','s','t','a','c','k',' ','o','v','e','r','f','l','o','w','.',
/* 0x1205d = "Pluggable Device Manager error." */
    'P','l','u','g','g','a','b','l','e',' ','D','e','v','i','c','e',' ','M','a','n','a','g','e','r',' ','\x7b',
/* 0x12077 = "VERR_CR_X509_TBSCERT_EXTS_REQ_V3" */
    '\x01','\xa9','X','5','0','9','_','T','B','S','C','E','R','T','_','E','X','T','S','_','R','E','Q','_','V','3',
/* 0x12091 = "Unrecoverable error: lock was lost." */
    'U','n','r','e','c','o','v','e','r','a','b','l','e',' ','\xc3','l','o','c','k',' ','\x10','l','o','s','t','.',
/* 0x120ab = "Too many instances of a usb device." */
    '\xf0','\xa3','i','n','s','t','a','n','c','e','s',' ','\x13','a',' ','u','s','b',' ','d','e','v','i','c','e','.',
/* 0x120c5 = "Recompiler: Register allocator internal processing error #3." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','3','.',
/* 0x120df = "VERR_NET_DEST_ADDRESS_REQUIRED" */
    '\x01','N','E','T','_','D','E','S','T','_','A','D','D','R','E','S','S','_','R','E','Q','U','I','R','E','D',
/* 0x120f9 = "VERR_FDT_DTB_HDR_MAGIC_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','M','A','G','I','C','_','I','N','V','A','L','I','D',
/* 0x12113 = "Import ISO uses invalid volume sequence number." */
    '\xaf','\xb2',' ','u','s','e','s',' ','\x81','\xbd','s','e','q','u','e','n','c','e',' ','n','u','m','b','e','r','.',
/* 0x1212d = "The table of content string length didn\'t match the size specified in the header." */
    '\x03','\x9e','\x13','\xd8','\xc7','l','e','n','g','t','h',' ','d','i','d','n','\'','t',' ','\xe3','\x02','\xf8','\x16','\x0d','\x02','\xe7',
/* 0x12147 = "VERR_ASN1_CONSTRUCTED_STRING_NOT_IMPL" */
    '\x01','\xf2','C','O','N','S','T','R','U','C','T','E','D','_','S','T','R','I','N','G','_','\x14','I','M','P','L',
/* 0x12161 = "VERR_SERIALPORT_BREAK_DETECTED" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','B','R','E','A','K','_','D','E','T','E','C','T','E','D',
/* 0x1217b = "Recompiler: Failed to allocate more memory for debug info." */
    '\x11','\x80','\x08','a','l','l','o','c','a','t','e',' ','\xf6','\x5c','\x0e','d','e','b','u','g',' ','i','n','f','o','.',
/* 0x12195 = "Status that causes DBGC to quit." */
    'S','t','a','t','u','s',' ','\x89','c','a','u','s','e','s',' ','D','B','G','C',' ','\x08','q','u','i','t','.',
/* 0x121af = "Internal processing error in the PGM handy page allocator." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','h','a','n','d','y',' ','\xb6','a','l','l','o','c','a','t','o','r','.',
/* 0x121c9 = "VERR_PGM_HANDLER_VIRTUAL_CONFLICT" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','V','I','R','T','U','A','L','_','C','O','N','F','L','I','C','T',
/* 0x121e3 = "VMDK: Invalid image file header: invalid version." */
    'V','M','D','K',':',' ','\x0b','\x1a','\x18','h','e','a','d','e','r',':',' ','\x81','v','e','r','s','i','o','n','.',
/* 0x121fd = "VERR_ASN1_INVALID_GENERAL_STRING_ENCODING" */
    '\x01','\xf2','\x0f','G','E','N','E','R','A','L','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12217 = "VERR_ISOFS_MALFORMED_PART_MAP_TABLE" */
    '\x01','\xfd','M','A','L','F','O','R','M','E','D','_','P','A','R','T','_','M','A','P','_','T','A','B','L','E',
/* 0x12231 = "VT-x VMCS launch state invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','l','a','u','n','c','h',' ','\xb0','i','n','v','a','l','i','d','.',
/* 0x1224b = "VERR_ISOMK_IMPORT_BOOT_CAT_BAD_OUT_OF_BOUNDS" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','\xa0','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x12265 = "VERR_SUP_VP_DUPLICATE_DLL_MAPPING" */
    '\x01','\xe6','V','P','_','D','U','P','L','I','C','A','T','E','_','D','L','L','_','M','A','P','P','I','N','G',
/* 0x1227f = "VERR_ASN1_INVALID_GRAPHIC_STRING_ENCODING" */
    '\x01','\xf2','\x0f','G','R','A','P','H','I','C','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12299 = "The GVM is out of VM handle space." */
    '\x03','G','V','M',' ','\x09','o','u','t',' ','\x13','\xcf',' ','h','a','n','d','l','e',' ','s','p','a','c','e','.',
/* 0x122b3 = "Requires process elevation (UAC)." */
    'R','e','q','u','i','r','e','s',' ','\x82','e','l','e','v','a','t','i','o','n',' ','(','U','A','C',')','.',
/* 0x122cd = "The loaded timer state was incorrect." */
    '\x03','l','o','a','d','e','d',' ','t','i','m','e','r',' ','\xb0','\x10','i','n','c','o','r','r','e','c','t','.',
/* 0x122e7 = "Key algorithm parameters not expected." */
    'K','e','y',' ','\xbe','p','a','r','a','m','e','t','e','r','s',' ','\x05','e','x','p','e','c','t','e','d','.',
/* 0x12301 = "Descriptor tag is all zeros." */
    'D','e','s','c','r','i','p','t','o','r',' ','t','a','g',' ','\x09','a','l','l',' ','z','e','r','o','s','.',
/* 0x1231b = "Requested service does not exist." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x9c','\x05','e','x','i','s','t','.',
/* 0x12335 = "Floating pointer overflow." */
    'F','l','o','a','t','i','n','g',' ','p','o','i','n','t','e','r',' ','o','v','e','r','f','l','o','w','.',
/* 0x1234f = "The returned shadow page is cached." */
    '\x03','r','e','t','u','r','n','e','d',' ','s','h','a','d','o','w',' ','\xb6','\x09','c','a','c','h','e','d','.',
/* 0x12369 = "VERR_CR_X509_CPV_INVALID_POLICY_MAPPING" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\x0f','P','O','L','I','C','Y','_','M','A','P','P','I','N','G',
/* 0x12383 = "VERR_GMM_ATTEMPT_TO_FREE_TOO_MUCH" */
    '\x01','G','M','M','_','A','T','T','E','M','P','T','_','T','O','_','F','R','E','E','_','\x9f','M','U','C','H',
/* 0x1239d = "VERR_SUP_VP_BAD_FILE_ALIGNMENT_VALUE" */
    '\x01','\xe6','V','P','_','\xa0','F','I','L','E','_','A','L','I','G','N','M','E','N','T','_','V','A','L','U','E',
/* 0x123b7 = "The cache is not up to date with the image." */
    '\x03','c','a','c','h','e',' ','\x09','\x05','u','p',' ','\x08','d','a','t','e',' ','\x1e','\x02','i','m','a','g','e','.',
/* 0x123d1 = "VERR_SHCLPB_MAX_EVENTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','E','V','E','N','T','S','_','R','E','A','C','H','E','D',
/* 0x123eb = "The saved state file size didn\'t match the one in the header." */
    '\x03','s','a','v','e','d',' ','\xb0','\x18','\xf8','d','i','d','n','\'','t',' ','\xe3','\x02','o','n','e',' ','\x0d','\x02','\xe7',
/* 0x12405 = "VERR_DBGC_PARSE_TOO_FEW_ARGUMENTS" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x9f','F','E','W','_','A','R','G','U','M','E','N','T','S',
/* 0x1241f = "VERR_SUP_VP_BAD_SECTION_VIRTUAL_SIZE" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','V','I','R','T','U','A','L','_','S','I','Z','E',
/* 0x12439 = "VERR_SUP_VP_SECTION_NOT_FULLY_MAPPED" */
    '\x01','\xe6','V','P','_','S','E','C','T','I','O','N','_','\x14','F','U','L','L','Y','_','M','A','P','P','E','D',
/* 0x12453 = "VERR_GIM_HYPERCALLS_NOT_AVAILABLE" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x14','A','V','A','I','L','A','B','L','E',
/* 0x1246d = "Multiple PE image page hash tables." */
    'M','u','l','t','i','p','l','e',' ','P','E',' ','\x1a','\xb6','h','a','s','h',' ','t','a','b','l','e','s','.',
/* 0x12487 = "Malformed forwarder entry." */
    'M','a','l','f','o','r','m','e','d',' ','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x124a1 = "VERR_SHCLPB_OBJ_HANDLE_INVALID" */
    '\x01','S','H','C','L','P','B','_','O','B','J','_','H','A','N','D','L','E','_','I','N','V','A','L','I','D',
/* 0x124bb = "Recompiler: Register allocator internal processing error #6." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','6','.',
/* 0x124d5 = "Insufficient data to check descriptor CRC." */
    'I','n','s','u','f','f','i','c','i','e','n','t',' ','\x8f','\x08','c','h','e','c','k',' ','\xd6','C','R','C','.',
/* 0x124ef = "VERR_IOM_IOPORT_RANGE_CONFLICT" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x12509 = "VERR_DBGC_PARSE_NO_RANGE_ALLOWED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb7','R','A','N','G','E','_','A','L','L','O','W','E','D',
/* 0x12523 = "VERR_SUPDRV_TRACER_UMOD_TOO_MANY_PROBES" */
    '\x01','\xdc','T','R','A','C','E','R','_','U','M','O','D','_','\x9f','M','A','N','Y','_','P','R','O','B','E','S',
/* 0x1253d = "VERR_CR_PKIX_OSSL_VERIFY_FINAL_FAILED" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','V','E','R','I','F','Y','_','F','I','N','A','L','_','\x93',
/* 0x12557 = "VFS chain element expected at most one argument." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','m','o','s','t',' ','o','n','e',' ','a','r','g','u','m','e','n','t','.',
/* 0x12571 = "The signal being posted is not correct." */
    '\x03','s','i','g','n','a','l',' ','\xdb','p','o','s','t','e','d',' ','\x09','\x05','c','o','r','r','e','c','t','.',
/* 0x1258b = "VERR_PDM_CRITSECTRW_TOO_MANY_WRITERS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9f','M','A','N','Y','_','W','R','I','T','E','R','S',
/* 0x125a5 = "VERR_LDRELF_INVALID_RELOCATION_OFFSET" */
    '\x01','L','D','R','E','L','F','_','\x0f','R','E','L','O','C','A','T','I','O','N','_','O','F','F','S','E','T',
/* 0x125bf = "Recording initialization failed." */
    'R','e','c','o','r','d','i','n','g',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x125d9 = "The DBGF has no more free breakpoint owner handles." */
    '\x03','\xf1',' ','\x1d','\xe9','\xf6','f','r','e','e',' ','\xab','o','w','n','e','r',' ','h','a','n','d','l','e','s','.',
/* 0x125f3 = "VERR_LDRVI_INVALID_SECURITY_DIR_ENTRY" */
    '\x01','L','D','R','V','I','_','\x0f','S','E','C','U','R','I','T','Y','_','D','I','R','_','E','N','T','R','Y',
/* 0x1260d = "VINF_EM_RESUME_R3_HISTORY_EXEC" */
    '\x19','E','M','_','R','E','S','U','M','E','_','R','3','_','H','I','S','T','O','R','Y','_','E','X','E','C',
/* 0x12627 = "VERR_INTNET_INCOMPATIBLE_TRUNK" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','T','R','U','N','K',
/* 0x12641 = "VERR_VD_DISCARD_ALIGNMENT_NOT_MET" */
    '\x01','V','D','_','D','I','S','C','A','R','D','_','A','L','I','G','N','M','E','N','T','_','\x14','M','E','T',
/* 0x1265b = "Internal processing error in the debug module reader code." */
    '\x06','\x04','\x07','\x0d','\x02','d','e','b','u','g',' ','m','o','d','u','l','e',' ','r','e','a','d','e','r',' ','\x5e',
/* 0x12675 = "VERR_PDM_CRITSECTRW_TOO_MANY_READERS" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','\x9f','M','A','N','Y','_','R','E','A','D','E','R','S',
/* 0x1268f = "Recompiler: Register allocator internal processing error #1." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','1','.',
/* 0x126a9 = "VERR_SUP_VP_CREATE_READ_EVT_SEM_FAILED" */
    '\x01','\xe6','V','P','_','C','R','E','A','T','E','_','R','E','A','D','_','E','V','T','_','S','E','M','_','\x93',
/* 0x126c3 = "VINF_IEM_REEXEC_FINISH_WITH_FLAGS" */
    '\x19','\xee','R','E','E','X','E','C','_','F','I','N','I','S','H','_','W','I','T','H','_','F','L','A','G','S',
/* 0x126dd = "VERR_DBGC_PARSE_EMPTY_ARGUMENT" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','E','M','P','T','Y','_','A','R','G','U','M','E','N','T',
/* 0x126f7 = "The ELF loader encountered a bad symbol index." */
    '\x03','E','L','F',' ','\xc4','\x98','a',' ','b','a','d',' ','s','y','m','b','o','l',' ','i','n','d','e','x','.',
/* 0x12711 = "VINF_AUDIO_MORE_DATA_AVAILABLE" */
    '\x19','A','U','D','I','O','_','M','O','R','E','_','D','A','T','A','_','A','V','A','I','L','A','B','L','E',
/* 0x1272b = "Name is not unique on the network." */
    'N','a','m','e',' ','\x09','\x05','u','n','i','q','u','e',' ','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x12745 = "Process Verification Failure: Error querying image information." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','\x1a','i','n','f','o','r','m','a','t','i','o','n','.',
/* 0x1275f = "VINF_EM_RESCHEDULE_EXEC_ENGINE" */
    '\x19','E','M','_','R','E','S','C','H','E','D','U','L','E','_','E','X','E','C','_','E','N','G','I','N','E',
/* 0x12779 = "VERR_ASN1_CURSOR_TOO_LITTLE_DATA_LEFT" */
    '\x01','\xf2','C','U','R','S','O','R','_','\x9f','L','I','T','T','L','E','_','D','A','T','A','_','L','E','F','T',
/* 0x12793 = "Recompiler: Register allocator internal processing error #8." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','8','.',
/* 0x127ad = "VERR_AUDIO_NO_FREE_INPUT_STREAMS" */
    '\x01','A','U','D','I','O','_','\xb7','F','R','E','E','_','I','N','P','U','T','_','S','T','R','E','A','M','S',
/* 0x127c7 = "VERR_VMM_WRONG_NEM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','N','E','M','_','V','M','C','P','U','_','S','T','A','T','E',
/* 0x127e1 = "VERR_CR_PKCS7_NO_DIGEST_ALGORITHMS" */
    '\x01','\xa9','P','K','C','S','7','_','\xb7','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M','S',
/* 0x127fb = "Can\'t delete bucket with keys." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','b','u','c','k','e','t',' ','\x1e','k','e','y','s','.',
/* 0x12815 = "Image Verification Failure: Error allocating memory for section headers." */
    '\xfe','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','\xc6','h','e','a','d','e','r','s','.',
/* 0x1282f = "VERR_PDM_MEDIAEX_IOREQID_CONFLICT" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','C','O','N','F','L','I','C','T',
/* 0x12849 = "Process Verification Failure: Executable file name and process image name does not match up." */
    '\x17','\x0c','\x12','E','x','e','c','u','t','a','b','l','e',' ','\x18','\xf3','\x2a','\x82','\x1a','\xf3','\x9c','\x05','\xe3','u','p','.',
/* 0x12863 = "Recompiler: Totally unexpected memory size." */
    '\x11','T','o','t','a','l','l','y',' ','u','n','e','x','p','e','c','t','e','d',' ','\x5c','s','i','z','e','.',
/* 0x1287d = "VERR_SUP_VP_DLL_CHARECTERISTICS_MISMATCH" */
    '\x01','\xe6','V','P','_','D','L','L','_','C','H','A','R','E','C','T','E','R','I','S','T','I','C','S','_','\x99',
/* 0x12897 = "Recompiler: Register allocator internal processing error #4." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','4','.',
/* 0x128b1 = "No page directory available for the hypervisor." */
    '\xd0','\xb6','\x1b','a','v','a','i','l','a','b','l','e',' ','\x0e','\x02','h','y','p','e','r','v','i','s','o','r','.',
/* 0x128cb = "VINF_EM_PENDING_R3_IOPORT_READ" */
    '\x19','E','M','_','P','E','N','D','I','N','G','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x128e5 = "VERR_DBGC_COMMANDS_NOT_REGISTERED" */
    '\x01','D','B','G','C','_','C','O','M','M','A','N','D','S','_','\x14','R','E','G','I','S','T','E','R','E','D',
/* 0x128ff = "Recompiler: Register allocator internal processing error #5." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','5','.',
/* 0x12919 = "VERR_HARDAVL_INSERT_INVALID_KEY_RANGE" */
    '\x01','H','A','R','D','A','V','L','_','I','N','S','E','R','T','_','\x0f','K','E','Y','_','R','A','N','G','E',
/* 0x12933 = "VERR_DWARF_BAD_LINE_NUMBER_HEADER" */
    '\x01','D','W','A','R','F','_','\xa0','L','I','N','E','_','N','U','M','B','E','R','_','H','E','A','D','E','R',
/* 0x1294d = "The JSON document is malformed." */
    '\x03','J','S','O','N',' ','d','o','c','u','m','e','n','t',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x12967 = "Missing size element in table of content sub-element." */
    'M','i','s','s','i','n','g',' ','\xf8','\x1f','\x0d','\x9e','\x13','\xd8','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x12981 = "VERR_ASN1_INVALID_VISIBLE_STRING_ENCODING" */
    '\x01','\xf2','\x0f','V','I','S','I','B','L','E','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1299b = "VERR_DBG_NO_MATCHING_INTERPRETER" */
    '\x01','D','B','G','_','\xb7','M','A','T','C','H','I','N','G','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x129b5 = "Reason for leaving RZ: The urge to syncing CR3." */
    '\x84','\x0e','\x25','R','Z',':',' ','\x03','u','r','g','e',' ','\x08','s','y','n','c','i','n','g',' ','C','R','3','.',
/* 0x129cf = "VERR_IOM_TOO_MANY_MMIO_REGISTRATIONS" */
    '\x01','I','O','M','_','\x9f','M','A','N','Y','_','\xf4','_','R','E','G','I','S','T','R','A','T','I','O','N','S',
/* 0x129e9 = "Recompiler: Register allocator internal processing error #9." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','9','.',
/* 0x12a03 = "VERR_ISOMK_IMPORT_MISALIGNED_MULTI_EXTENT" */
    '\x01','\xaa','\xd4','M','I','S','A','L','I','G','N','E','D','_','M','U','L','T','I','_','E','X','T','E','N','T',
/* 0x12a1d = "VERR_DBG_MALFORMED_UNWIND_INFO" */
    '\x01','D','B','G','_','M','A','L','F','O','R','M','E','D','_','U','N','W','I','N','D','_','I','N','F','O',
/* 0x12a37 = "VERR_CR_X509_CPV_NAME_NOT_PERMITTED" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','N','A','M','E','_','\x14','P','E','R','M','I','T','T','E','D',
/* 0x12a51 = "VERR_VD_ISCSI_SECRET_ENCRYPTED" */
    '\x01','V','D','_','I','S','C','S','I','_','S','E','C','R','E','T','_','E','N','C','R','Y','P','T','E','D',
/* 0x12a6b = "Generic debugger command failure." */
    '\x96','d','e','b','u','g','g','e','r',' ','c','o','m','m','a','n','d',' ','f','a','i','l','u','r','e','.',
/* 0x12a85 = "VERR_ISOMK_IMPORT_LOGICAL_BLOCK_SIZE_NOT_2KB" */
    '\x01','\xaa','\xd4','L','O','G','I','C','A','L','_','B','L','O','C','K','_','S','I','Z','E','_','\x14','2','K','B',
/* 0x12a9f = "NEM failed to query dirty page bitmap." */
    'N','E','M',' ','\x88','\x08','q','u','e','r','y',' ','d','i','r','t','y',' ','\xb6','b','i','t','m','a','p','.',
/* 0x12ab9 = "VERR_ASN1_INVALID_NUMERIC_STRING_ENCODING" */
    '\x01','\xf2','\x0f','N','U','M','E','R','I','C','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x12ad3 = "Recompiler: Register allocator internal processing error #2." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','2','.',
/* 0x12aed = "Can\'t move file to another disk." */
    'C','a','n','\'','t',' ','m','o','v','e',' ','\x18','\x08','a','n','o','t','h','e','r',' ','d','i','s','k','.',
/* 0x12b07 = "VERR_SUP_VP_EXE_MISSING_NX_COMPAT" */
    '\x01','\xe6','V','P','_','E','X','E','_','M','I','S','S','I','N','G','_','N','X','_','C','O','M','P','A','T',
/* 0x12b21 = "VERR_ASN1_STRING_TYPE_NOT_IMPLEMENTED" */
    '\x01','\xf2','S','T','R','I','N','G','_','T','Y','P','E','_','\x14','I','M','P','L','E','M','E','N','T','E','D',
/* 0x12b3b = "VERR_VFS_CHAIN_EXPECTED_PROVIDER_NAME" */
    '\x01','\xa4','_','\xda','E','X','P','E','C','T','E','D','_','P','R','O','V','I','D','E','R','_','N','A','M','E',
/* 0x12b55 = "VINF_SSM_VOTE_FOR_ANOTHER_PASS" */
    '\x19','S','S','M','_','V','O','T','E','_','F','O','R','_','A','N','O','T','H','E','R','_','P','A','S','S',
/* 0x12b6f = "VERR_ISOMK_SYMLINK_SUPPORT_DISABLED" */
    '\x01','\xaa','S','Y','M','L','I','N','K','_','S','U','P','P','O','R','T','_','D','I','S','A','B','L','E','D',
/* 0x12b89 = "VERR_LDRVI_PAGE_HASH_TAB_TOO_LONG" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','T','A','B','_','\x9f','L','O','N','G',
/* 0x12ba3 = "VERR_SUP_VP_FREE_VIRTUAL_MEMORY_FAILED" */
    '\x01','\xe6','V','P','_','F','R','E','E','_','V','I','R','T','U','A','L','_','M','E','M','O','R','Y','_','\x93',
/* 0x12bbd = "Execute one instruction with the recompiler." */
    'E','x','e','c','u','t','e',' ','o','n','e',' ','\xba','\x1e','\x02','r','e','c','o','m','p','i','l','e','r','.',
/* 0x12bd7 = "Requested service already exists." */
    'R','e','q','u','e','s','t','e','d',' ','s','e','r','v','i','c','e',' ','\x22','e','x','i','s','t','s','.',
/* 0x12bf1 = "VERR_CR_X509_CPV_MAX_PATH_LENGTH" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','M','A','X','_','P','A','T','H','_','L','E','N','G','T','H',
/* 0x12c0b = "VERR_IEM_EMIT_CASE_NOT_IMPLEMENTED_1" */
    '\x01','\xee','E','M','I','T','_','C','A','S','E','_','\x14','I','M','P','L','E','M','E','N','T','E','D','_','1',
/* 0x12c25 = "VWRN_ENV_NOT_FULLY_TRANSLATED" */
    'V','W','R','N','_','E','N','V','_','\x14','F','U','L','L','Y','_','T','R','A','N','S','L','A','T','E','D',
/* 0x12c3f = "VERR_INTNET_INCOMPATIBLE_FLAGS" */
    '\x01','I','N','T','N','E','T','_','I','N','C','O','M','P','A','T','I','B','L','E','_','F','L','A','G','S',
/* 0x12c59 = "The size of the raw image is not dividable by 512." */
    '\x03','\xf8','\x13','\x02','r','a','w',' ','\x1a','\x09','\x05','d','i','v','i','d','a','b','l','e',' ','\xb9','5','1','2','.',
/* 0x12c73 = "The CRC of the saved state file did not match." */
    '\x03','C','R','C',' ','\x13','\x02','s','a','v','e','d',' ','\xb0','\x18','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x12c8d = "Recompiler: Register allocator internal processing error #7." */
    '\x11','R','e','g','i','s','t','e','r',' ','a','l','l','o','c','a','t','o','r',' ','\x15','\x04','\x07','#','7','.',
/* 0x12ca7 = "The shared module has too many regions." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x1d','\x8c','\xa3','r','e','g','i','o','n','s','.',
/* 0x12cc1 = "General network printing error." */
    'G','e','n','e','r','a','l',' ','n','e','t','w','o','r','k',' ','p','r','i','n','t','i','n','g',' ','\x7b',
/* 0x12cdb = "Wrong 32/64-bit switcher." */
    'W','r','o','n','g',' ','3','2','/','6','4','-','b','i','t',' ','s','w','i','t','c','h','e','r','.',
/* 0x12cf4 = "VERR_VFS_CHAIN_TAKES_DIR_OR_FSS_OR_VFS" */
    '\x01','\xa4','_','\xda','T','A','K','E','S','_','D','I','R','_','O','R','_','F','S','S','_','O','R','_','\xa4',
/* 0x12d0d = "Mismatching architecture." */
    'M','i','s','m','a','t','c','h','i','n','g',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x12d26 = "VERR_VUSB_DEVICE_IS_RESETTING" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','R','E','S','E','T','T','I','N','G',
/* 0x12d3f = "Not more data in ASN.1 byte stream." */
    'N','o','t',' ','\xf6','\x8f','\x0d','A','S','N','.','1',' ','b','y','t','e',' ','s','t','r','e','a','m','.',
/* 0x12d58 = "VERR_IOMMU_ADDR_ACCESS_DENIED" */
    '\x01','I','O','M','M','U','_','A','D','D','R','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x12d71 = "VERR_VMM_WRONG_HM_VMCPU_STATE" */
    '\x01','V','M','M','_','W','R','O','N','G','_','H','M','_','V','M','C','P','U','_','S','T','A','T','E',
/* 0x12d8a = "VERR_PDM_CFG_MISSING_DRIVER_NAME" */
    '\x01','\xb8','C','F','G','_','M','I','S','S','I','N','G','_','D','R','I','V','E','R','_','N','A','M','E',
/* 0x12da3 = "VERR_HOSTIF_DEVICE_NAME_TOO_LONG" */
    '\x01','H','O','S','T','I','F','_','D','E','V','I','C','E','_','N','A','M','E','_','\x9f','L','O','N','G',
/* 0x12dbc = "VERR_GSTCTL_PROCESS_EXIT_CODE" */
    '\x01','G','S','T','C','T','L','_','P','R','O','C','E','S','S','_','E','X','I','T','_','C','O','D','E',
/* 0x12dd5 = "The LUN is not attached to the device." */
    '\x03','L','U','N',' ','\x09','\x05','a','t','t','a','c','h','e','d',' ','\x08','\x02','d','e','v','i','c','e','.',
/* 0x12dee = "VERR_SUP_VP_SET_HANDLE_NOINHERIT" */
    '\x01','\xe6','V','P','_','S','E','T','_','H','A','N','D','L','E','_','N','O','I','N','H','E','R','I','T',
/* 0x12e07 = "VERR_LDRVI_BAD_CERT_HDR_REVISION" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','R','E','V','I','S','I','O','N',
/* 0x12e20 = "VERR_ASN1_BITSTRING_OUT_OF_BOUNDS" */
    '\x01','\xf2','B','I','T','S','T','R','I','N','G','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x12e39 = "VERR_LDRMACHO_OTHER_ENDIAN_NOT_SUPPORTED" */
    '\x01','L','D','R','M','A','C','H','O','_','O','T','H','E','R','_','E','N','D','I','A','N','_','\x14','\xc5',
/* 0x12e52 = "VINF_DBGF_ZERO_EXTENDED_REGISTER" */
    '\x19','\xf1','_','Z','E','R','O','_','E','X','T','E','N','D','E','D','_','R','E','G','I','S','T','E','R',
/* 0x12e6b = "VINF_EM_RAW_INJECT_TRPM_EVENT" */
    '\x19','E','M','_','R','A','W','_','I','N','J','E','C','T','_','T','R','P','M','_','E','V','E','N','T',
/* 0x12e84 = "VERR_PATM_IPE_TRAP_IN_PATCH_CODE" */
    '\x01','P','A','T','M','_','\x8e','T','R','A','P','_','I','N','_','P','A','T','C','H','_','C','O','D','E',
/* 0x12e9d = "VDI: Invalid image file header: invalid version." */
    'V','D','I',':',' ','\x0b','\x1a','\x18','h','e','a','d','e','r',':',' ','\x81','v','e','r','s','i','o','n','.',
/* 0x12eb6 = "VERR_CR_PKIX_NOT_ECDSA_PRIVATE_KEY" */
    '\x01','\xa9','P','K','I','X','_','\x14','E','C','D','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x12ecf = "Bad VTG provider descriptor." */
    '\x92','V','T','G',' ','p','r','o','v','i','d','e','r',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x12ee8 = "VERR_NEM_MISSING_KERNEL_API_4" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','4',
/* 0x12f01 = "VERR_NEM_MISSING_KERNEL_API_2" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','2',
/* 0x12f1a = "Too many I/O port registrations." */
    '\xf0','\xa3','I','/','O',' ','p','o','r','t',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x12f33 = "VERR_NEM_MISSING_KERNEL_API_1" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','1',
/* 0x12f4c = "VERR_NEM_MISSING_KERNEL_API_3" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','3',
/* 0x12f65 = "VERR_NEM_MISSING_KERNEL_API_5" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','K','E','R','N','E','L','_','A','P','I','_','5',
/* 0x12f7e = "Encountered a section type that\'s not implemented." */
    '\x97','a',' ','\xc6','\xd9','t','h','a','t','\'','s',' ','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x12f97 = "VERR_BIGNUM_NEGATIVE_EXPONENT" */
    '\x01','B','I','G','N','U','M','_','N','E','G','A','T','I','V','E','_','E','X','P','O','N','E','N','T',
/* 0x12fb0 = "VERR_SSM_INTEGRITY_UNIT_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','U','N','I','T','_','M','A','G','I','C',
/* 0x12fc9 = "Basic constraints were not found." */
    'B','a','s','i','c',' ','c','o','n','s','t','r','a','i','n','t','s',' ','w','e','r','e',' ','\x05','\x7d',
/* 0x12fe2 = "VERR_X509_NO_BASIC_CONSTARAINTS" */
    '\x01','X','5','0','9','_','\xb7','B','A','S','I','C','_','C','O','N','S','T','A','R','A','I','N','T','S',
/* 0x12ffb = "The DTB being parsed has a version set which is not supported." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','a',' ','\xb4','s','e','t',' ','\xc0','\x09','\x05','\x95',
/* 0x13014 = "VERR_CR_PKCS7_UNKNOWN_DIGEST_ALGORITHM" */
    '\x01','\xa9','P','K','C','S','7','_','\xde','D','I','G','E','S','T','_','A','L','G','O','R','I','T','H','M',
/* 0x1302d = "VERR_NET_INCOMPLETE_TX_PACKET" */
    '\x01','N','E','T','_','I','N','C','O','M','P','L','E','T','E','_','T','X','_','P','A','C','K','E','T',
/* 0x13046 = "VERR_ISOMK_BOOT_CAT_NO_DEFAULT_ENTRY" */
    '\x01','\xaa','B','O','O','T','_','C','A','T','_','\xb7','D','E','F','A','U','L','T','_','E','N','T','R','Y',
/* 0x1305f = "VERR_SSM_LIVE_GURU_MEDITATION" */
    '\x01','S','S','M','_','L','I','V','E','_','G','U','R','U','_','M','E','D','I','T','A','T','I','O','N',
/* 0x13078 = "Generic dangling objects status." */
    '\x96','d','a','n','g','l','i','n','g',' ','o','b','j','e','c','t','s',' ','s','t','a','t','u','s','.',
/* 0x13091 = "ASN.1 bit string object is out of bounds." */
    'A','S','N','.','1',' ','b','i','t',' ','\xc7','\x8d','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x130aa = "The VFS chain specification is empty." */
    '\x03','\xa4',' ','\x91','s','p','e','c','i','f','i','c','a','t','i','o','n',' ','\x09','e','m','p','t','y','.',
/* 0x130c3 = "VERR_XAR_MISSING_DATA_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','D','A','T','A','_','E','L','E','M','E','N','T',
/* 0x130dc = "The request function is not implemented." */
    '\x03','\x94','f','u','n','c','t','i','o','n',' ','\x09','\x05','i','m','p','l','e','m','e','n','t','e','d','.',
/* 0x130f5 = "Unused MMIO register read, fill with 00." */
    'U','n','u','s','e','d',' ','\xf4',' ','\xbc','r','e','a','d',',',' ','f','i','l','l',' ','\x1e','0','0','.',
/* 0x1310e = "VINF_VRDP_OPERATION_COMPLETED" */
    '\x19','V','R','D','P','_','O','P','E','R','A','T','I','O','N','_','C','O','M','P','L','E','T','E','D',
/* 0x13127 = "Internal processing error #1 in the DBGF event tracing code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf1',' ','e','v','e','n','t',' ','t','r','a','c','i','n','g',' ','\x5e',
/* 0x13140 = "Invalid ASN.1 UTC TIME encoding." */
    '\x0b','A','S','N','.','1',' ','U','T','C',' ','T','I','M','E',' ','e','n','c','o','d','i','n','g','.',
/* 0x13159 = "VERR_ASN1_CURSOR_TAG_FLAG_CLASS_MISMATCH" */
    '\x01','\xf2','C','U','R','S','O','R','_','T','A','G','_','F','L','A','G','_','C','L','A','S','S','_','\x99',
/* 0x13172 = "Failed to fstat a native handle (hardening)." */
    '\x80','\x08','f','s','t','a','t',' ','a',' ','n','a','t','i','v','e',' ','h','a','n','d','l','e',' ','\x9a',
/* 0x1318b = "Bad length element in table of content sub-element." */
    '\x92','l','e','n','g','t','h',' ','\x1f','\x0d','\x9e','\x13','\xd8','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x131a4 = "VERR_SHCLPB_MAX_LISTS_REACHED" */
    '\x01','S','H','C','L','P','B','_','M','A','X','_','L','I','S','T','S','_','R','E','A','C','H','E','D',
/* 0x131bd = "VERR_SEM_LV_EXISTING_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','E','X','I','S','T','I','N','G','_','D','E','A','D','L','O','C','K',
/* 0x131d6 = "The instruction is not yet implemented by IEM." */
    '\x03','\xba','\x09','\x05','y','e','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\xb9','I','E','M','.',
/* 0x131ef = "VERR_PAGE_MAP_LEVEL4_NOT_PRESENT" */
    '\x01','P','A','G','E','_','M','A','P','_','L','E','V','E','L','4','_','\x14','P','R','E','S','E','N','T',
/* 0x13208 = "VERR_SUP_VP_WINTRUST_CAT_FAILURE" */
    '\x01','\xe6','V','P','_','W','I','N','T','R','U','S','T','_','C','A','T','_','F','A','I','L','U','R','E',
/* 0x13221 = "Proxy couldn\'t be resolved." */
    'P','r','o','x','y',' ','c','o','u','l','d','n','\'','t',' ','\x90','r','e','s','o','l','v','e','d','.',
/* 0x1323a = "VERR_FDT_DTB_HDR_SIZE_INVALID" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','S','I','Z','E','_','I','N','V','A','L','I','D',
/* 0x13253 = "VERR_IPC_SEND_SEND_PF_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','S','E','N','D','_','P','F','_','T','I','M','E','O','U','T',
/* 0x1326c = "VERR_VMX_MSR_SMX_VMX_ENABLE_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','S','M','X','_','V','M','X','_','E','N','A','B','L','E','_','\x93',
/* 0x13285 = "VERR_CR_PKIX_SIGNATURE_NEGATIVE" */
    '\x01','\xa9','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','N','E','G','A','T','I','V','E',
/* 0x1329e = "No default entry in the boot catalog." */
    '\xd0','d','e','f','a','u','l','t',' ','\xb5','\x0d','\x02','b','o','o','t',' ','c','a','t','a','l','o','g','.',
/* 0x132b7 = "Encountered a term function section." */
    '\x97','a',' ','t','e','r','m',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x132d0 = "VERR_SUPDRV_TRACER_UMOD_STRTAB_TOO_BIG" */
    '\x01','\xdc','T','R','A','C','E','R','_','U','M','O','D','_','S','T','R','T','A','B','_','\x9f','B','I','G',
/* 0x132e9 = "Directory can\'t be deleted." */
    'D','i','r','e','c','t','o','r','y',' ','c','a','n','\'','t',' ','\x90','d','e','l','e','t','e','d','.',
/* 0x13302 = "VERR_ASN1_CURSOR_BAD_LENGTH_ENCODING" */
    '\x01','\xf2','C','U','R','S','O','R','_','\xa0','L','E','N','G','T','H','_','E','N','C','O','D','I','N','G',
/* 0x1331b = "Failed to read the device table entry due to an invalid offset." */
    '\x80','\x08','r','e','a','d',' ','\x02','\x8b','\x9e','\xb5','d','u','e',' ','\x08','\x60','\x81','o','f','f','s','e','t','.',
/* 0x13334 = "VERR_CPUM_MSR_BAD_CPUMCPU_OFFSET" */
    '\x01','C','P','U','M','_','M','S','R','_','\xa0','C','P','U','M','C','P','U','_','O','F','F','S','E','T',
/* 0x1334d = "VERR_XAR_MISSING_SIZE_ELEMENT" */
    '\x01','X','A','R','_','M','I','S','S','I','N','G','_','S','I','Z','E','_','E','L','E','M','E','N','T',
/* 0x13366 = "The write monitor is already engaged." */
    '\x03','w','r','i','t','e',' ','m','o','n','i','t','o','r',' ','\x09','\x22','e','n','g','a','g','e','d','.',
/* 0x1337f = "VERR_GMM_MODULE_VERSION_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','V','E','R','S','I','O','N','_','\x9f','L','O','N','G',
/* 0x13398 = "VERR_CR_KEY_ALGO_PARAMS_UNKNOWN" */
    '\x01','\xa9','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','U','N','K','N','O','W','N',
/* 0x133b1 = "VERR_REST_PATH_PARAMETER_NOT_SET" */
    '\x01','R','E','S','T','_','P','A','T','H','_','P','A','R','A','M','E','T','E','R','_','\x14','S','E','T',
/* 0x133ca = "VERR_SUP_VP_TOO_MANY_MEMORY_REGIONS" */
    '\x01','\xe6','V','P','_','\x9f','M','A','N','Y','_','M','E','M','O','R','Y','_','R','E','G','I','O','N','S',
/* 0x133e3 = "The timer failed to reach a stable state." */
    '\x03','t','i','m','e','r',' ','\x88','\x08','r','e','a','c','h',' ','a',' ','s','t','a','b','l','e',' ','\xf5',
/* 0x133fc = "Image Verification Failure: Error determining the file length." */
    '\xfe','\x0c','\x12','\xac','d','e','t','e','r','m','i','n','i','n','g',' ','\x02','\x18','l','e','n','g','t','h','.',
/* 0x13415 = "VERR_CR_PKIX_CIPHER_ALGO_NOT_KNOWN" */
    '\x01','\xa9','P','K','I','X','_','C','I','P','H','E','R','_','A','L','G','O','_','\x14','K','N','O','W','N',
/* 0x1342e = "VERR_SUP_VP_SECTION_PROTECTION_MISMATCH" */
    '\x01','\xe6','V','P','_','S','E','C','T','I','O','N','_','P','R','O','T','E','C','T','I','O','N','_','\x99',
/* 0x13447 = "VFS chain element takes exactly three arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','h','r','e','e',' ','\xc8',
/* 0x13460 = "VERR_PDM_DRIVER_DETACH_NOT_POSSIBLE" */
    '\x01','\xb8','D','R','I','V','E','R','_','D','E','T','A','C','H','_','\x14','P','O','S','S','I','B','L','E',
/* 0x13479 = "VERR_XAR_UNUSED_ARCHIVED_DATA" */
    '\x01','X','A','R','_','U','N','U','S','E','D','_','A','R','C','H','I','V','E','D','_','D','A','T','A',
/* 0x13492 = "VERR_CR_KEY_MALFORMED_CIPHER_IV" */
    '\x01','\xa9','K','E','Y','_','M','A','L','F','O','R','M','E','D','_','C','I','P','H','E','R','_','I','V',
/* 0x134ab = "A digest doesn't match the corresponding file." */
    'A',' ','\xc2','\xa5','\xe3','\x02','c','o','r','r','e','s','p','o','n','d','i','n','g',' ','f','i','l','e','.',
/* 0x134c4 = "A bad page map entry was encountered." */
    'A',' ','b','a','d',' ','\xb6','m','a','p',' ','\xb5','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x134dd = "VERR_SUPDRV_TRACER_CANNOT_OPEN_SELF" */
    '\x01','\xdc','T','R','A','C','E','R','_','C','A','N','N','O','T','_','O','P','E','N','_','S','E','L','F',
/* 0x134f6 = "Too deep walk during lookup." */
    '\xf0','d','e','e','p',' ','w','a','l','k',' ','d','u','r','i','n','g',' ','l','o','o','k','u','p','.',
/* 0x1350f = "VERR_PGM_PHYS_PAGE_MAP_MMIO2_IPE" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','M','M','I','O','2','_','I','P','E',
/* 0x13528 = "The PE loader doesn't grok the COM descriptor data directory entry." */
    '\x03','P','E',' ','\xc4','\xa5','g','r','o','k',' ','\x02','C','O','M',' ','\xd6','\x8f','\x1b','e','n','t','r','y','.',
/* 0x13541 = "Process Verification Failure: Error query virtual memory mapping name." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y',' ','v','i','r','t','u','a','l',' ','\x5c','\xe0','n','a','m','e','.',
/* 0x1355a = "Internal processing error: Not build certificate." */
    '\x06','\x04','\xc3','N','o','t',' ','b','u','i','l','d',' ','c','e','r','t','i','f','i','c','a','t','e','.',
/* 0x13573 = "Shared Clipboard event failed error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','e','v','e','n','t',' ','\x88','\x7b',
/* 0x1358c = "The tar file ended unexpectedly." */
    '\x03','t','a','r',' ','\x18','e','n','d','e','d',' ','u','n','e','x','p','e','c','t','e','d','l','y','.',
/* 0x135a5 = "An unknown config value was encountered." */
    'A','n',' ','\xfc','c','o','n','f','i','g',' ','\xd2','\x10','e','n','c','o','u','n','t','e','r','e','d','.',
/* 0x135be = "VERR_RESERVED_PAGE_TABLE_BITS" */
    '\x01','R','E','S','E','R','V','E','D','_','P','A','G','E','_','T','A','B','L','E','_','B','I','T','S',
/* 0x135d7 = "Decompression integrity error." */
    'D','e','c','o','m','p','r','e','s','s','i','o','n',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x135f0 = "VERR_ASN1_OBJID_TOO_LONG_STRING_FORM" */
    '\x01','\xf2','O','B','J','I','D','_','\x9f','L','O','N','G','_','S','T','R','I','N','G','_','F','O','R','M',
/* 0x13609 = "Unused MMIO register read, fill with FF." */
    'U','n','u','s','e','d',' ','\xf4',' ','\xbc','r','e','a','d',',',' ','f','i','l','l',' ','\x1e','F','F','.',
/* 0x13622 = "VERR_VMX_X86_CR4_VMXE_CLEARED" */
    '\x01','V','M','X','_','X','8','6','_','C','R','4','_','V','M','X','E','_','C','L','E','A','R','E','D',
/* 0x1363b = "VERR_VMX_MSR_ALL_VMX_DISABLED" */
    '\x01','V','M','X','_','M','S','R','_','A','L','L','_','V','M','X','_','D','I','S','A','B','L','E','D',
/* 0x13654 = "VERR_CPUM_INCOMPATIBLE_CONFIG" */
    '\x01','C','P','U','M','_','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x1366d = "VERR_IOM_MMIO_HANDLER_BOGUS_CALL" */
    '\x01','I','O','M','_','\xf4','_','H','A','N','D','L','E','R','_','B','O','G','U','S','_','C','A','L','L',
/* 0x13686 = "VINF_GIM_HYPERCALL_CONTINUING" */
    '\x19','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','C','O','N','T','I','N','U','I','N','G',
/* 0x1369f = "VERR_GMM_TOO_MANY_GLOBAL_MODULES" */
    '\x01','G','M','M','_','\x9f','M','A','N','Y','_','G','L','O','B','A','L','_','M','O','D','U','L','E','S',
/* 0x136b8 = "VERR_VUSB_DEVICE_IS_SUSPENDED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','I','S','_','S','U','S','P','E','N','D','E','D',
/* 0x136d1 = "VERR_ISOMK_IMPORT_BOOT_CAT_EXT_ENTRY_INVALID_ID" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','E','X','T','_','E','N','T','R','Y','_','\x0f','I','D',
/* 0x136ea = "Command hardware failure." */
    'C','o','m','m','a','n','d',' ','h','a','r','d','w','a','r','e',' ','f','a','i','l','u','r','e','.',
/* 0x13703 = "VERR_CR_X509_CPV_NO_TRUSTED_PATHS" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\xb7','T','R','U','S','T','E','D','_','P','A','T','H','S',
/* 0x1371c = "VERR_CR_X509_CPV_NOT_VALID_AT_TIME" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\x14','V','A','L','I','D','_','A','T','_','T','I','M','E',
/* 0x13735 = "VERR_SUPLIB_INVALID_INTERNAL_APP_DIR" */
    '\x01','S','U','P','L','I','B','_','\x0f','I','N','T','E','R','N','A','L','_','A','P','P','_','D','I','R',
/* 0x1374e = "Unsupported PKCS #7 signed data version." */
    '\x87','P','K','C','S',' ','#','7',' ','s','i','g','n','e','d',' ','\x8f','v','e','r','s','i','o','n','.',
/* 0x13767 = "Reason for leaving RC: Encountered a stale selector." */
    '\x84','\x0e','\x25','R','C',':',' ','\x97','a',' ','s','t','a','l','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x13780 = "VINF_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x19','\xb8','\xb7','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x13799 = "Bad SPC object moniker UUID field." */
    '\x92','S','P','C',' ','\x8d','m','o','n','i','k','e','r',' ','U','U','I','D',' ','f','i','e','l','d','.',
/* 0x137b2 = "VERR_NEM_QUERY_DIRTY_BITMAP_FAILED" */
    '\x01','N','E','M','_','Q','U','E','R','Y','_','D','I','R','T','Y','_','B','I','T','M','A','P','_','\x93',
/* 0x137cb = "VERR_PDM_MISSING_INTERFACE_BELOW" */
    '\x01','\xb8','M','I','S','S','I','N','G','_','I','N','T','E','R','F','A','C','E','_','B','E','L','O','W',
/* 0x137e4 = "VERR_VMX_INVALID_VMCS_PTR_TO_START_VM" */
    '\x01','V','M','X','_','\x0f','V','M','C','S','_','P','T','R','_','T','O','_','S','T','A','R','T','_','\xcf',
/* 0x137fd = "VERR_PDM_MISSING_INTERFACE_ABOVE" */
    '\x01','\xb8','M','I','S','S','I','N','G','_','I','N','T','E','R','F','A','C','E','_','A','B','O','V','E',
/* 0x13816 = "Internal SPC error: Bad object moniker data pointer." */
    '\x06','S','P','C',' ','\xc3','\x92','\x8d','m','o','n','i','k','e','r',' ','\x8f','p','o','i','n','t','e','r','.',
/* 0x1382f = "Encountered a init function section." */
    '\x97','a',' ','i','n','i','t',' ','f','u','n','c','t','i','o','n',' ','s','e','c','t','i','o','n','.',
/* 0x13848 = "VINF_PGM_HANDLED_DIRTY_BIT_FAULT" */
    '\x19','\xd7','H','A','N','D','L','E','D','_','D','I','R','T','Y','_','B','I','T','_','F','A','U','L','T',
/* 0x13861 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_TMP" */
    '\x01','\xee','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\xb7','F','R','E','E','_','T','M','P',
/* 0x1387a = "VERR_IOMMU_ADDR_TRANSLATION_FAILED" */
    '\x01','I','O','M','M','U','_','A','D','D','R','_','T','R','A','N','S','L','A','T','I','O','N','_','\x93',
/* 0x13893 = "VERR_DBGF_BP_OWNER_NO_MORE_HANDLES" */
    '\x01','\xf1','_','B','P','_','O','W','N','E','R','_','\xb7','M','O','R','E','_','H','A','N','D','L','E','S',
/* 0x138ac = "VERR_CR_PKIX_HASH_TOO_LONG_FOR_KEY" */
    '\x01','\xa9','P','K','I','X','_','H','A','S','H','_','\x9f','L','O','N','G','_','F','O','R','_','K','E','Y',
/* 0x138c5 = "VINF_EM_RAW_INTERRUPT_PENDING" */
    '\x19','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','P','E','N','D','I','N','G',
/* 0x138de = "Image Verification Failure: More than one certificate table entry." */
    '\xfe','\x0c','\x12','M','o','r','e',' ','t','h','a','n',' ','o','n','e',' ','\x8a','\x9e','e','n','t','r','y','.',
/* 0x138f7 = "Bad iterdata (EXEPACK) data." */
    '\x92','i','t','e','r','d','a','t','a',' ','(','E','X','E','P','A','C','K',')',' ','d','a','t','a','.',
/* 0x13910 = "No guest mappings when SMP is enabled." */
    '\xd0','\xa1','m','a','p','p','i','n','g','s',' ','\xef','S','M','P',' ','\x09','e','n','a','b','l','e','d','.',
/* 0x13929 = "Invalid object ID in managed object reference." */
    '\x0b','\x8d','I','D',' ','\x0d','m','a','n','a','g','e','d',' ','\x8d','r','e','f','e','r','e','n','c','e','.',
/* 0x13942 = "VERR_CR_KEY_ALGO_PARAMS_MISSING" */
    '\x01','\xa9','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','M','I','S','S','I','N','G',
/* 0x1395b = "VT-x VMCS field cache invalid." */
    'V','T','-','x',' ','V','M','C','S',' ','\xff','c','a','c','h','e',' ','i','n','v','a','l','i','d','.',
/* 0x13974 = "Bad offset element in table of content sub-element." */
    '\x92','o','f','f','s','e','t',' ','\x1f','\x0d','\x9e','\x13','\xd8','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x1398d = "VERR_ISOMK_FILE_TOO_BIG_REQ_ISO_LEVEL_3" */
    '\x01','\xaa','F','I','L','E','_','\x9f','B','I','G','_','R','E','Q','_','\xb2','_','L','E','V','E','L','_','3',
/* 0x139a6 = "VERR_INTNET_FLT_VNIC_CREATE_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','C','R','E','A','T','E','_','\x93',
/* 0x139bf = "Process Verification Failure: The process has too many virtual memory regions." */
    '\x17','\x0c','\x12','\x03','\x82','\x1d','\x8c','\xa3','v','i','r','t','u','a','l',' ','\x5c','r','e','g','i','o','n','s','.',
/* 0x139d8 = "Bad DWARF abbreviation data." */
    '\x92','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','d','a','t','a','.',
/* 0x139f1 = "Command address is invalid." */
    'C','o','m','m','a','n','d',' ','a','d','d','r','e','s','s',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x13a0a = "Unsupported CPU feature combination." */
    '\x87','C','P','U',' ','f','e','a','t','u','r','e',' ','c','o','m','b','i','n','a','t','i','o','n','.',
/* 0x13a23 = "VERR_HTTP_CACERT_WRONG_FORMAT" */
    '\x01','H','T','T','P','_','C','A','C','E','R','T','_','W','R','O','N','G','_','F','O','R','M','A','T',
/* 0x13a3c = "The handle ID was not found in the set." */
    '\x03','h','a','n','d','l','e',' ','I','D',' ','\x10','\x05','f','o','u','n','d',' ','\x0d','\x02','s','e','t','.',
/* 0x13a55 = "Unexpected ASN.1 fake/dummy object." */
    '\x85','A','S','N','.','1',' ','f','a','k','e','/','d','u','m','m','y',' ','o','b','j','e','c','t','.',
/* 0x13a6e = "VERR_GMM_TOO_MANY_CHUNK_MAPPINGS" */
    '\x01','G','M','M','_','\x9f','M','A','N','Y','_','C','H','U','N','K','_','M','A','P','P','I','N','G','S',
/* 0x13a87 = "VERR_CR_KEY_OSSL_DECRYPT_INIT_ERROR" */
    '\x01','\xa9','K','E','Y','_','O','S','S','L','_','D','E','C','R','Y','P','T','_','I','N','I','T','_','\x9b',
/* 0x13aa0 = "VERR_SUPDRV_TSC_DELTA_MEASUREMENT_FAILED" */
    '\x01','\xdc','T','S','C','_','D','E','L','T','A','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x13ab9 = "VERR_IEM_INSTR_BUF_OUT_OF_MEMORY" */
    '\x01','\xee','I','N','S','T','R','_','B','U','F','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x13ad2 = "VERR_NET_CONNECTION_TIMED_OUT" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','T','I','M','E','D','_','O','U','T',
/* 0x13aeb = "The EVP_PKEY_type API in OpenSSL failed." */
    '\x03','E','V','P','_','P','K','E','Y','_','\xd9','A','P','I',' ','\x0d','O','p','e','n','S','S','L',' ','\x24',
/* 0x13b04 = "Certificate path builder: Encountered bad certificate context." */
    '\xa7','\xbb','b','u','i','l','d','e','r',':',' ','\x97','b','a','d',' ','\x8a','c','o','n','t','e','x','t','.',
/* 0x13b1d = "VERR_SUP_VP_IMAGE_MAPPING_BASE_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','M','A','P','P','I','N','G','_','B','A','S','E','_','\x9b',
/* 0x13b36 = "VERR_VM_REQUEST_TOO_MANY_ARGS_IPE" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','\x9f','M','A','N','Y','_','A','R','G','S','_','I','P','E',
/* 0x13b4f = "VERR_CR_X509_NAME_EMPTY_SUB_SET" */
    '\x01','\xa9','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','U','B','_','S','E','T',
/* 0x13b68 = "VERR_PDM_NO_DRIVER_ATTACHED_TO_LUN" */
    '\x01','\xb8','\xb7','D','R','I','V','E','R','_','A','T','T','A','C','H','E','D','_','T','O','_','L','U','N',
/* 0x13b81 = "VERR_IEM_REG_ALLOCATOR_NO_FREE_VAR" */
    '\x01','\xee','R','E','G','_','A','L','L','O','C','A','T','O','R','_','\xb7','F','R','E','E','_','V','A','R',
/* 0x13b9a = "VERR_FTP_CLIENT_LIMIT_REACHED" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x13bb3 = "VERR_VFS_CHAIN_MUST_BE_FIRST_ELEMENT" */
    '\x01','\xa4','_','\xda','M','U','S','T','_','B','E','_','F','I','R','S','T','_','E','L','E','M','E','N','T',
/* 0x13bcc = "Failed to get underlying link ID." */
    '\x80','\x08','g','e','t',' ','u','n','d','e','r','l','y','i','n','g',' ','l','i','n','k',' ','I','D','.',
/* 0x13be5 = "VERR_IEM_VAR_OUT_OF_STACK_SLOTS" */
    '\x01','\xee','V','A','R','_','O','U','T','_','O','F','_','S','T','A','C','K','_','S','L','O','T','S',
/* 0x13bfd = "VERR_XML_TOC_ELEMENT_MISSING" */
    '\x01','X','M','L','_','T','O','C','_','E','L','E','M','E','N','T','_','M','I','S','S','I','N','G',
/* 0x13c15 = "VERR_DBGC_PARSE_CONVERSION_FAILED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','C','O','N','V','E','R','S','I','O','N','_','\x93',
/* 0x13c2d = "VERR_GMM_TOO_MANY_PER_VM_MODULES" */
    '\x01','G','M','M','_','\x9f','M','A','N','Y','_','P','E','R','_','\xcf','_','M','O','D','U','L','E','S',
/* 0x13c45 = "VERR_IOMMU_INTR_REMAP_DENIED" */
    '\x01','I','O','M','M','U','_','I','N','T','R','_','R','E','M','A','P','_','D','E','N','I','E','D',
/* 0x13c5d = "VERR_LDRMACHO_BAD_SECTION_ORDER" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','E','C','T','I','O','N','_','O','R','D','E','R',
/* 0x13c75 = "VERR_CR_X509_NAME_EMPTY_STRING" */
    '\x01','\xa9','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','T','R','I','N','G',
/* 0x13c8d = "The timer was not in the correct state for the request operation." */
    '\x03','t','i','m','e','r',' ','\x10','\x05','\x0d','\x02','c','o','r','r','e','c','t',' ','\xb0','\x0e','\x02','\x94','\xcc',
/* 0x13ca5 = "Conflicting CFGM values." */
    'C','o','n','f','l','i','c','t','i','n','g',' ','C','F','G','M',' ','v','a','l','u','e','s','.',
/* 0x13cbd = "VERR_HGCM_TOO_MANY_CLIENT_CALLS" */
    '\x01','H','G','C','M','_','\x9f','M','A','N','Y','_','C','L','I','E','N','T','_','C','A','L','L','S',
/* 0x13cd5 = "VERR_HOSTIF_FD_AND_INIT_TERM" */
    '\x01','H','O','S','T','I','F','_','F','D','_','A','N','D','_','I','N','I','T','_','T','E','R','M',
/* 0x13ced = "VERR_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x01','\xaa','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x13d05 = "VERR_ISOMK_BOOT_CAT_ERRATIC_ENTRY" */
    '\x01','\xaa','B','O','O','T','_','C','A','T','_','E','R','R','A','T','I','C','_','E','N','T','R','Y',
/* 0x13d1d = "Internal processing error in the PGM dynmap (r0/rc)." */
    '\x06','\x04','\x07','\x0d','\x02','P','G','M',' ','d','y','n','m','a','p',' ','(','r','0','/','r','c',')','.',
/* 0x13d35 = "VERR_SUPDRV_TSC_FREQ_MEASUREMENT_FAILED" */
    '\x01','\xdc','T','S','C','_','F','R','E','Q','_','M','E','A','S','U','R','E','M','E','N','T','_','\x93',
/* 0x13d4d = "VERR_CR_X509_PUBLIC_KEY_TOO_SMALL" */
    '\x01','\xa9','X','5','0','9','_','P','U','B','L','I','C','_','K','E','Y','_','\x9f','S','M','A','L','L',
/* 0x13d65 = "VERR_SUPDRV_SESSION_PROCESS_ENUM_ERROR" */
    '\x01','\xdc','S','E','S','S','I','O','N','_','P','R','O','C','E','S','S','_','E','N','U','M','_','\x9b',
/* 0x13d7d = "VERR_DBGC_PARSE_NOT_IMPLEMENTED" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x14','I','M','P','L','E','M','E','N','T','E','D',
/* 0x13d95 = "VERR_CPUM_INVALID_HWVIRT_FEAT_COMBO" */
    '\x01','C','P','U','M','_','\x0f','H','W','V','I','R','T','_','F','E','A','T','_','C','O','M','B','O',
/* 0x13dad = "VERR_PDM_DEVICE_INSTANCE_NO_IBASE" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\xb7','I','B','A','S','E',
/* 0x13dc5 = "Nothing that can be cancelled." */
    'N','o','t','h','i','n','g',' ','\x89','c','a','n',' ','\x90','c','a','n','c','e','l','l','e','d','.',
/* 0x13ddd = "Unsectioned boot catalog entry." */
    'U','n','s','e','c','t','i','o','n','e','d',' ','b','o','o','t',' ','\xcd','e','n','t','r','y','.',
/* 0x13df5 = "VERR_AUDIO_BACKEND_NOT_ATTACHED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','\x14','A','T','T','A','C','H','E','D',
/* 0x13e0d = "Invalid UTF-16 escape sequence." */
    '\x0b','U','T','F','-','1','6',' ','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x13e25 = "VERR_LDRELF_MULTIPLE_SYMTABS" */
    '\x01','L','D','R','E','L','F','_','M','U','L','T','I','P','L','E','_','S','Y','M','T','A','B','S',
/* 0x13e3d = "Generic out of resources warning." */
    '\x96','o','u','t',' ','\x13','r','e','s','o','u','r','c','e','s',' ','w','a','r','n','i','n','g','.',
/* 0x13e55 = "We are in driverless mode." */
    'W','e',' ','a','r','e',' ','\x0d','d','r','i','v','e','r','l','e','s','s',' ','m','o','d','e','.',
/* 0x13e6d = "Unable to make text memory writeable (hardening)." */
    '\xca','\x08','m','a','k','e',' ','t','e','x','t',' ','\x5c','w','r','i','t','e','a','b','l','e',' ','\x9a',
/* 0x13e85 = "VERR_SSM_FIELD_OUT_OF_BOUNDS" */
    '\x01','S','S','M','_','F','I','E','L','D','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x13e9d = "VERR_VMX_UNDEFINED_EXIT_CODE" */
    '\x01','V','M','X','_','U','N','D','E','F','I','N','E','D','_','E','X','I','T','_','C','O','D','E',
/* 0x13eb5 = "No CR3 root shadow page table." */
    '\xd0','C','R','3',' ','r','o','o','t',' ','s','h','a','d','o','w',' ','\xb6','t','a','b','l','e','.',
/* 0x13ecd = "VRDP protocol violation." */
    'V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','v','i','o','l','a','t','i','o','n','.',
/* 0x13ee5 = "VERR_CR_PKIX_NOT_ECDSA_PUBLIC_KEY" */
    '\x01','\xa9','P','K','I','X','_','\x14','E','C','D','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x13efd = "Max timer limit reached." */
    'M','a','x',' ','t','i','m','e','r',' ','l','i','m','i','t',' ','r','e','a','c','h','e','d','.',
/* 0x13f15 = "VERR_LDRPE_LOCK_PREFIX_TABLE" */
    '\x01','L','D','R','P','E','_','L','O','C','K','_','P','R','E','F','I','X','_','T','A','B','L','E',
/* 0x13f2d = "VERR_NS_SYMLINK_CHANGE_OWNER" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','C','H','A','N','G','E','_','O','W','N','E','R',
/* 0x13f45 = "Object being in use prohibits operation." */
    'O','b','j','e','c','t',' ','\xdb','\x0d','u','s','e',' ','p','r','o','h','i','b','i','t','s',' ','\xcc',
/* 0x13f5d = "VERR_ISOFS_TOO_MANY_ICB_INDIRECTIONS" */
    '\x01','\xfd','\x9f','M','A','N','Y','_','I','C','B','_','I','N','D','I','R','E','C','T','I','O','N','S',
/* 0x13f75 = "VERR_GMM_BAD_SHARED_MODULE_SIZE" */
    '\x01','G','M','M','_','\xa0','S','H','A','R','E','D','_','M','O','D','U','L','E','_','S','I','Z','E',
/* 0x13f8d = "VERR_PDM_MEDIAEX_IOBUF_UNDERRUN" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','B','U','F','_','U','N','D','E','R','R','U','N',
/* 0x13fa5 = "VERR_GIM_HYPERCALLS_NOT_ENABLED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','S','_','\x14','E','N','A','B','L','E','D',
/* 0x13fbd = "VINF_RECORDING_LIMIT_REACHED" */
    '\x19','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x13fd5 = "VERR_CR_X509_CPV_NO_VALID_POLICY" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\xb7','V','A','L','I','D','_','P','O','L','I','C','Y',
/* 0x13fed = "VINF_EM_RAW_EMULATE_DBG_STEP" */
    '\x19','E','M','_','R','A','W','_','E','M','U','L','A','T','E','_','D','B','G','_','S','T','E','P',
/* 0x14005 = "VERR_VD_RAW_SIZE_FLOPPY_TOO_BIG" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','F','L','O','P','P','Y','_','\x9f','B','I','G',
/* 0x1401d = "FAM failed to open a connection." */
    'F','A','M',' ','\x88','\x08','o','p','e','n',' ','a',' ','c','o','n','n','e','c','t','i','o','n','.',
/* 0x14035 = "VERR_GETOPT_INVALID_ARGUMENT_FORMAT" */
    '\x01','G','E','T','O','P','T','_','\x0f','A','R','G','U','M','E','N','T','_','F','O','R','M','A','T',
/* 0x1404d = "The shared module version string is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xb4','\xc7','\x09','\x8c','l','o','n','g','.',
/* 0x14065 = "The Ring-3 module was already loaded." */
    '\x03','R','i','n','g','-','3',' ','m','o','d','u','l','e',' ','\x10','\x22','l','o','a','d','e','d','.',
/* 0x1407d = "VERR_RECORDING_LIMIT_REACHED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','L','I','M','I','T','_','R','E','A','C','H','E','D',
/* 0x14095 = "A DWARF abbreviation was not found." */
    'A',' ','D','W','A','R','F',' ','a','b','b','r','e','v','i','a','t','i','o','n',' ','\x10','\x05','\x7d',
/* 0x140ad = "Reached the max cache size." */
    'R','e','a','c','h','e','d',' ','\x02','m','a','x',' ','c','a','c','h','e',' ','s','i','z','e','.',
/* 0x140c5 = "Invalid host interface version." */
    '\x0b','h','o','s','t',' ','i','n','t','e','r','f','a','c','e',' ','v','e','r','s','i','o','n','.',
/* 0x140dd = "VERR_SUP_VP_EMPTY_REGION_TOO_LARGE" */
    '\x01','\xe6','V','P','_','E','M','P','T','Y','_','R','E','G','I','O','N','_','\x9f','L','A','R','G','E',
/* 0x140f5 = "VINF_EM_DBG_HYPER_BREAKPOINT" */
    '\x19','E','M','_','D','B','G','_','H','Y','P','E','R','_','B','R','E','A','K','P','O','I','N','T',
/* 0x1410d = "VERR_RT_REQUEST_STATUS_FREED" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x14125 = "VERR_FILE_AIO_LIMIT_EXCEEDED" */
    '\x01','F','I','L','E','_','A','I','O','_','L','I','M','I','T','_','E','X','C','E','E','D','E','D',
/* 0x1413d = "Encountered an unexpected page state in the saved state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xb6','\xb0','\x0d','\x02','s','a','v','e','d',' ','\xf5',
/* 0x14155 = "VFS chain element takes exactly five arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','i','v','e',' ','\xc8',
/* 0x1416d = "The ELF loader encountered an invalid symbol name offset." */
    '\x03','E','L','F',' ','\xc4','\x98','\x60','\x81','s','y','m','b','o','l',' ','\xf3','o','f','f','s','e','t','.',
/* 0x14185 = "Access denied for the address." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x0e','\x02','a','d','d','r','e','s','s','.',
/* 0x1419d = "VERR_VD_RAW_SIZE_MODULO_2048" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','M','O','D','U','L','O','_','2','0','4','8',
/* 0x141b5 = "Recompiler: Fixed jump is out of range." */
    '\x11','F','i','x','e','d',' ','j','u','m','p',' ','\x09','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x141cd = "No buffer space available." */
    '\xd0','b','u','f','f','e','r',' ','s','p','a','c','e',' ','a','v','a','i','l','a','b','l','e','.',
/* 0x141e5 = "Invalid ASN.1 INTEGER encoding." */
    '\x0b','A','S','N','.','1',' ','I','N','T','E','G','E','R',' ','e','n','c','o','d','i','n','g','.',
/* 0x141fd = "VERR_VMM_RING3_CALL_DISABLED" */
    '\x01','V','M','M','_','R','I','N','G','3','_','C','A','L','L','_','D','I','S','A','B','L','E','D',
/* 0x14215 = "Process Verification Failure: Error querying debug port." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','d','e','b','u','g',' ','p','o','r','t','.',
/* 0x1422d = "The installed support driver doesn't match the version of the user." */
    '\x03','i','n','s','t','a','l','l','e','d',' ','\xb1','\xa8','\xa5','\xe3','\x02','\xb4','\x13','\x02','u','s','e','r','.',
/* 0x14245 = "VERR_SUP_VP_TOO_MANY_IMAGE_REGIONS" */
    '\x01','\xe6','V','P','_','\x9f','M','A','N','Y','_','I','M','A','G','E','_','R','E','G','I','O','N','S',
/* 0x1425d = "VERR_GMM_HIT_VM_ACCOUNT_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','\xcf','_','A','C','C','O','U','N','T','_','L','I','M','I','T',
/* 0x14275 = "VERR_FAM_MONITOR_DIRECTORY_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','D','I','R','E','C','T','O','R','Y','_','\x93',
/* 0x1428d = "Node index is out of bounds." */
    'N','o','d','e',' ','i','n','d','e','x',' ','\x09','o','u','t',' ','\x13','b','o','u','n','d','s','.',
/* 0x142a5 = "Unexpected interruption exit type." */
    '\x85','i','n','t','e','r','r','u','p','t','i','o','n',' ','e','x','i','t',' ','t','y','p','e','.',
/* 0x142bd = "Unable to lock a region of a file." */
    '\xca','\x08','l','o','c','k',' ','a',' ','r','e','g','i','o','n',' ','\x13','a',' ','f','i','l','e','.',
/* 0x142d5 = "VERR_IOM_NOT_IOPORT_RANGE_OWNER" */
    '\x01','I','O','M','_','\x14','I','O','P','O','R','T','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x142ed = "VERR_SSM_FIELD_INVALID_PADDING_SIZE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','P','A','D','D','I','N','G','_','S','I','Z','E',
/* 0x14305 = "VERR_TM_TIMER_UNSTABLE_STATE" */
    '\x01','T','M','_','T','I','M','E','R','_','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x1431d = "VERR_CR_SPC_PEIMAGE_UNKNOWN_ATTRIBUTE" */
    '\x01','\xa9','S','P','C','_','P','E','I','M','A','G','E','_','\xde','A','T','T','R','I','B','U','T','E',
/* 0x14335 = "VERR_SSM_INTEGRITY_DIR_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','D','I','R','_','M','A','G','I','C',
/* 0x1434d = "VERR_ASN1_OBJID_TOO_MANY_COMPONENTS" */
    '\x01','\xf2','O','B','J','I','D','_','\x9f','M','A','N','Y','_','C','O','M','P','O','N','E','N','T','S',
/* 0x14365 = "The DTB being parsed is malformed." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x1437d = "VERR_SUPDRV_NO_RAW_MODE_HYPER_V_ROOT" */
    '\x01','\xdc','\xb7','R','A','W','_','M','O','D','E','_','H','Y','P','E','R','_','V','_','R','O','O','T',
/* 0x14395 = "VERR_ISOMK_BOOT_CAT_INVALID_SECTION_SIZE" */
    '\x01','\xaa','B','O','O','T','_','C','A','T','_','\x0f','S','E','C','T','I','O','N','_','S','I','Z','E',
/* 0x143ad = "Protocol wrong type for socket." */
    'P','r','o','t','o','c','o','l',' ','w','r','o','n','g',' ','\xd9','\x0e','s','o','c','k','e','t','.',
/* 0x143c5 = "Failed to read the device table entry from guest memory." */
    '\x80','\x08','r','e','a','d',' ','\x02','\x8b','\x9e','\xb5','f','r','o','m',' ','\xa1','m','e','m','o','r','y','.',
/* 0x143dd = "The PKCS #7 content is not signed data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xd8','\x09','\x05','s','i','g','n','e','d',' ','d','a','t','a','.',
/* 0x143f5 = "No partition descriptors found." */
    '\xd0','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x1440d = "Terminate search branch." */
    'T','e','r','m','i','n','a','t','e',' ','s','e','a','r','c','h',' ','b','r','a','n','c','h','.',
/* 0x14425 = "Hypervisor memory allocation failed." */
    'H','y','p','e','r','v','i','s','o','r',' ','\x5c','a','l','l','o','c','a','t','i','o','n',' ','\x24',
/* 0x1443d = "Syntax error - out of scratch memory." */
    '\xe1','\x07','-',' ','o','u','t',' ','\x13','s','c','r','a','t','c','h',' ','m','e','m','o','r','y','.',
/* 0x14455 = "VFS chain element expected non-empty argument." */
    '\xa4',' ','\x91','\x1f','\xae','n','o','n','-','e','m','p','t','y',' ','a','r','g','u','m','e','n','t','.',
/* 0x1446d = "VERR_PGM_PCI_PASSTHRU_MISCONFIG" */
    '\x01','\xd7','P','C','I','_','P','A','S','S','T','H','R','U','_','M','I','S','C','O','N','F','I','G',
/* 0x14485 = "VERR_CR_PKIX_OSSL_SIGN_FINAL_FAILED" */
    '\x01','\xa9','P','K','I','X','_','O','S','S','L','_','S','I','G','N','_','F','I','N','A','L','_','\x93',
/* 0x1449d = "VERR_PDM_TOO_MANY_DRIVER_INSTANCES" */
    '\x01','\xb8','\x9f','M','A','N','Y','_','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','S',
/* 0x144b5 = "Bad VTG probe enabled data." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','e','n','a','b','l','e','d',' ','d','a','t','a','.',
/* 0x144cd = "VFS chain element takes exactly four arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','f','o','u','r',' ','\xc8',
/* 0x144e5 = "VERR_PDM_MEDIAEX_IOREQ_CANCELED" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','C','A','N','C','E','L','E','D',
/* 0x144fd = "VERR_VD_ASYNC_IO_IN_PROGRESS" */
    '\x01','V','D','_','A','S','Y','N','C','_','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x14515 = "Internal error in the X.509 certificate path building and verification code." */
    '\x06','\x07','\x0d','\x02','X','.','5','0','9',' ','\x8a','\xbb','b','u','i','l','d','i','n','g',' ','\x2a','\xd5','\x5e',
/* 0x1452d = "Expected primitive ASN.1 object." */
    '\xa6','p','r','i','m','i','t','i','v','e',' ','A','S','N','.','1',' ','o','b','j','e','c','t','.',
/* 0x14545 = "VERR_SUP_VP_UNMAP_AND_PROTECT_FAILED" */
    '\x01','\xe6','V','P','_','U','N','M','A','P','_','A','N','D','_','P','R','O','T','E','C','T','_','\x93',
/* 0x1455d = "PCI passthru is not supported by this build." */
    'P','C','I',' ','p','a','s','s','t','h','r','u',' ','\x09','\x05','\xf9','\xb9','\xc9','b','u','i','l','d','.',
/* 0x14575 = "The specified address range wraps around." */
    '\x03','\x16','a','d','d','r','e','s','s',' ','\xe4','w','r','a','p','s',' ','a','r','o','u','n','d','.',
/* 0x1458d = "VERR_PDM_DEVICE_INSTANCE_LUN_NOT_FOUND" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','L','U','N','_','\x14','\xb3',
/* 0x145a5 = "VERR_PROC_ELEVATION_REQUIRED" */
    '\x01','P','R','O','C','_','E','L','E','V','A','T','I','O','N','_','R','E','Q','U','I','R','E','D',
/* 0x145bd = "The tar end of file record was read." */
    '\x03','t','a','r',' ','e','n','d',' ','\x13','\x18','r','e','c','o','r','d',' ','\x10','r','e','a','d','.',
/* 0x145d5 = "Too many partition descriptors." */
    '\xf0','\xa3','p','a','r','t','i','t','i','o','n',' ','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x145ed = "VERR_NET_PROTOCOL_NOT_AVAILABLE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x14','A','V','A','I','L','A','B','L','E',
/* 0x14605 = "Recompiler: Uninitialized variable." */
    '\x11','U','n','i','n','i','t','i','a','l','i','z','e','d',' ','v','a','r','i','a','b','l','e','.',
/* 0x1461d = "Bad symbol table size in Mach-O image." */
    '\x92','s','y','m','b','o','l',' ','\x9e','\xf8','\x0d','M','a','c','h','-','O',' ','i','m','a','g','e','.',
/* 0x14635 = "Process Verification Failure: An image mapping failed to report a name." */
    '\x17','\x0c','\x12','A','n',' ','\x1a','\xe0','\x88','\x08','r','e','p','o','r','t',' ','a',' ','n','a','m','e','.',
/* 0x1464d = "VERR_XAR_TOC_TOO_BIG_COMPRESSED" */
    '\x01','X','A','R','_','T','O','C','_','\x9f','B','I','G','_','C','O','M','P','R','E','S','S','E','D',
/* 0x14665 = "VERR_PGM_POOL_MAXED_OUT_ALREADY" */
    '\x01','\xd7','P','O','O','L','_','M','A','X','E','D','_','O','U','T','_','A','L','R','E','A','D','Y',
/* 0x1467d = "Unknown or unrecognized SVM exit." */
    '\xdf','\x86','u','n','r','e','c','o','g','n','i','z','e','d',' ','S','V','M',' ','e','x','i','t','.',
/* 0x14695 = "VERR_SUPDRV_TRACER_TOO_MANY_PROVIDERS" */
    '\x01','\xdc','T','R','A','C','E','R','_','\x9f','M','A','N','Y','_','P','R','O','V','I','D','E','R','S',
/* 0x146ad = "The file is not a valid NM map file." */
    '\x03','\x18','\x09','\x05','a',' ','v','a','l','i','d',' ','N','M',' ','m','a','p',' ','f','i','l','e','.',
/* 0x146c5 = "VINF_PATM_DUPLICATE_FUNCTION" */
    '\x19','P','A','T','M','_','D','U','P','L','I','C','A','T','E','_','F','U','N','C','T','I','O','N',
/* 0x146dd = "VERR_ISOMK_IMPORT_DIR_WITH_MORE_EXTENTS" */
    '\x01','\xaa','\xd4','D','I','R','_','W','I','T','H','_','M','O','R','E','_','E','X','T','E','N','T','S',
/* 0x146f5 = "Bad ASN.1 object length encoding." */
    '\x92','A','S','N','.','1',' ','\x8d','l','e','n','g','t','h',' ','e','n','c','o','d','i','n','g','.',
/* 0x1470d = "VERR_CR_PKIX_INVALID_SIGNATURE_LENGTH" */
    '\x01','\xa9','P','K','I','X','_','\x0f','S','I','G','N','A','T','U','R','E','_','L','E','N','G','T','H',
/* 0x14725 = "VERR_APIC_INTR_MASKED_BY_TPR" */
    '\x01','A','P','I','C','_','I','N','T','R','_','M','A','S','K','E','D','_','B','Y','_','T','P','R',
/* 0x1473d = "VERR_EXTPACK_UNSUPPORTED_HOST_UNINSTALL" */
    '\x01','E','X','T','P','A','C','K','_','\x9d','H','O','S','T','_','U','N','I','N','S','T','A','L','L',
/* 0x14755 = "VERR_DBGC_PARSE_BAD_RESULT_TYPE" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xa0','R','E','S','U','L','T','_','T','Y','P','E',
/* 0x1476d = "Encountered an unexpected page type in the saved state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xb6','\xd9','\x0d','\x02','s','a','v','e','d',' ','\xf5',
/* 0x14785 = "VERR_ISOMK_IMPORT_DIR_REC_VOLUME_SEQ_NO" */
    '\x01','\xaa','\xd4','D','I','R','_','R','E','C','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x1479d = "Internal processing error #1 in page access handler code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\xb6','a','c','c','e','s','s',' ','h','a','n','d','l','e','r',' ','\x5e',
/* 0x147b5 = "Invalid segment:offset address." */
    '\x0b','s','e','g','m','e','n','t',':','o','f','f','s','e','t',' ','a','d','d','r','e','s','s','.',
/* 0x147cd = "VERR_PDM_MEDIAEX_IOBUF_OVERFLOW" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','B','U','F','_','O','V','E','R','F','L','O','W',
/* 0x147e5 = "Internal SPC error: Bad object moniker choice value." */
    '\x06','S','P','C',' ','\xc3','\x92','\x8d','m','o','n','i','k','e','r',' ','c','h','o','i','c','e',' ','\xd3',
/* 0x147fd = "Unexpected cURL error configure the proxy." */
    '\x85','c','U','R','L',' ','\x07','c','o','n','f','i','g','u','r','e',' ','\x02','p','r','o','x','y','.',
/* 0x14815 = "Descriptor CRC mismatch." */
    'D','e','s','c','r','i','p','t','o','r',' ','C','R','C',' ','m','i','s','m','a','t','c','h','.',
/* 0x1482d = "Invalid/Corrupted configuration file." */
    'I','n','v','a','l','i','d','/','C','o','r','r','u','p','t','e','d',' ','\xe8','f','i','l','e','.',
/* 0x14845 = "Certificate path validator: Unknown critical certificate extension." */
    '\xa7','\xbb','\xe5','\xdf','c','r','i','t','i','c','a','l',' ','\x8a','e','x','t','e','n','s','i','o','n','.',
/* 0x1485d = "Incompatible configuration requested." */
    'I','n','c','o','m','p','a','t','i','b','l','e',' ','\xe8','r','e','q','u','e','s','t','e','d','.',
/* 0x14875 = "VERR_PDM_TOO_MANY_DEVICE_INSTANCES" */
    '\x01','\xb8','\x9f','M','A','N','Y','_','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','S',
/* 0x1488d = "The compressed data was corrupted." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x8f','\x10','c','o','r','r','u','p','t','e','d','.',
/* 0x148a5 = "VERR_SUP_VP_NO_IMAGE_MAPPING_NAME" */
    '\x01','\xe6','V','P','_','\xb7','I','M','A','G','E','_','M','A','P','P','I','N','G','_','N','A','M','E',
/* 0x148bd = "Unknown digest algorithm used by PKCS #7 object." */
    '\xdf','\xc2','\xbe','u','s','e','d',' ','\xb9','P','K','C','S',' ','#','7',' ','o','b','j','e','c','t','.',
/* 0x148d5 = "VERR_PAGE_COUNT_OUT_OF_RANGE" */
    '\x01','P','A','G','E','_','C','O','U','N','T','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x148ed = "VERR_LDRVI_NO_MEMORY_SIGNATURE" */
    '\x01','L','D','R','V','I','_','\xb7','M','E','M','O','R','Y','_','S','I','G','N','A','T','U','R','E',
/* 0x14905 = "VINF_GCM_HANDLED_ADVANCE_RIP" */
    '\x19','G','C','M','_','H','A','N','D','L','E','D','_','A','D','V','A','N','C','E','_','R','I','P',
/* 0x1491d = "Invalid ASN.1 BOOLEAN encoding." */
    '\x0b','A','S','N','.','1',' ','B','O','O','L','E','A','N',' ','e','n','c','o','d','i','n','g','.',
/* 0x14935 = "VINF_ISOMK_SYMLINK_REQ_ROCK_RIDGE" */
    '\x19','\xaa','S','Y','M','L','I','N','K','_','R','E','Q','_','R','O','C','K','_','R','I','D','G','E',
/* 0x1494d = "Unsupported VRDP protocol feature." */
    '\x87','V','R','D','P',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x14964 = "VERR_IOM_MMIO_HANDLER_DISASM_ERROR" */
    '\x01','I','O','M','_','\xf4','_','H','A','N','D','L','E','R','_','D','I','S','A','S','M','_','\x9b',
/* 0x1497b = "Symbolic link not allowed." */
    'S','y','m','b','o','l','i','c',' ','l','i','n','k',' ','\x05','a','l','l','o','w','e','d','.',
/* 0x14992 = "VERR_PDM_HIF_SHARING_VIOLATION" */
    '\x01','\xb8','H','I','F','_','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x149a9 = "VERR_EXTPACK_VBOX_VERSION_MISMATCH" */
    '\x01','E','X','T','P','A','C','K','_','V','B','O','X','_','V','E','R','S','I','O','N','_','\x99',
/* 0x149c0 = "Temporary place holder." */
    'T','e','m','p','o','r','a','r','y',' ','p','l','a','c','e',' ','h','o','l','d','e','r','.',
/* 0x149d7 = "VERR_AUTHENTICATION_FAILURE" */
    '\x01','A','U','T','H','E','N','T','I','C','A','T','I','O','N','_','F','A','I','L','U','R','E',
/* 0x149ee = "VERR_SSM_NO_PENDING_OPERATION" */
    '\x01','S','S','M','_','\xb7','P','E','N','D','I','N','G','_','O','P','E','R','A','T','I','O','N',
/* 0x14a05 = "VERR_CR_CIPHER_OSSL_SET_TAG_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','S','E','T','_','T','A','G','_','\x93',
/* 0x14a1c = "No logical volume descriptors found." */
    '\xd0','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x14a33 = "The iterator reached the end." */
    '\x03','i','t','e','r','a','t','o','r',' ','r','e','a','c','h','e','d',' ','\x02','e','n','d','.',
/* 0x14a4a = "VERR_INTNET_FLT_VNIC_OPEN_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','O','P','E','N','_','\x93',
/* 0x14a61 = "VERR_PKZIP_ZIP64EX_IN_ZIP32" */
    '\x01','P','K','Z','I','P','_','Z','I','P','6','4','E','X','_','I','N','_','Z','I','P','3','2',
/* 0x14a78 = "VERR_VM_REQUEST_STATUS_FREED" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','S','T','A','T','U','S','_','F','R','E','E','D',
/* 0x14a8f = "VERR_FDT_DTB_HDR_VERSION_NOT_SUPPORTED" */
    '\x01','F','D','T','_','D','T','B','_','H','D','R','_','V','E','R','S','I','O','N','_','\x14','\xc5',
/* 0x14aa6 = "Trying to seek on device." */
    'T','r','y','i','n','g',' ','\x08','s','e','e','k',' ','o','n',' ','d','e','v','i','c','e','.',
/* 0x14abd = "VERR_SUP_VP_STUB_THREAD_OPEN_ERROR" */
    '\x01','\xe6','V','P','_','S','T','U','B','_','T','H','R','E','A','D','_','O','P','E','N','_','\x9b',
/* 0x14ad4 = "VERR_CR_PKCS7_DIGEST_CREATE_ERROR" */
    '\x01','\xa9','P','K','C','S','7','_','D','I','G','E','S','T','_','C','R','E','A','T','E','_','\x9b',
/* 0x14aeb = "VERR_SSM_UNSUPPORTED_DATA_UNIT_VERSION" */
    '\x01','S','S','M','_','\x9d','D','A','T','A','_','U','N','I','T','_','V','E','R','S','I','O','N',
/* 0x14b02 = "VERR_NET_CONNECTION_ABORTED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','A','B','O','R','T','E','D',
/* 0x14b19 = "Unable to open the host interface." */
    '\xca','\x08','o','p','e','n',' ','\x02','h','o','s','t',' ','i','n','t','e','r','f','a','c','e','.',
/* 0x14b30 = "VERR_CR_X509_VALIDITY_SWAPPED" */
    '\x01','\xa9','X','5','0','9','_','V','A','L','I','D','I','T','Y','_','S','W','A','P','P','E','D',
/* 0x14b47 = "VERR_LDRMACHO_UNSUPPORTED_INIT_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','I','N','I','T','_','S','E','C','T','I','O','N',
/* 0x14b5e = "VERR_IPE_NOT_REACHED_DEFAULT_CASE" */
    '\x01','\x8e','\x14','R','E','A','C','H','E','D','_','D','E','F','A','U','L','T','_','C','A','S','E',
/* 0x14b75 = "iSCSI: Invalid device type (not a disk)." */
    'i','S','C','S','I',':',' ','\x0b','\x8b','\xd9','(','n','o','t',' ','a',' ','d','i','s','k',')','.',
/* 0x14b8c = "VERR_PGM_WRITE_MONITOR_ENGAGED" */
    '\x01','\xd7','W','R','I','T','E','_','M','O','N','I','T','O','R','_','E','N','G','A','G','E','D',
/* 0x14ba3 = "Error formatting an extension." */
    '\xac','f','o','r','m','a','t','t','i','n','g',' ','\x60','e','x','t','e','n','s','i','o','n','.',
/* 0x14bba = "No parent node specified." */
    '\xd0','p','a','r','e','n','t',' ','n','o','d','e',' ','s','p','e','c','i','f','i','e','d','.',
/* 0x14bd1 = "VERR_VRDP_INSUFFICIENT_DATA" */
    '\x01','V','R','D','P','_','I','N','S','U','F','F','I','C','I','E','N','T','_','D','A','T','A',
/* 0x14be8 = "Client limit has been reached." */
    'C','l','i','e','n','t',' ','l','i','m','i','t',' ','\x1d','\xad','r','e','a','c','h','e','d','.',
/* 0x14bff = "Entry in a boot catalog section is empty." */
    'E','n','t','r','y',' ','\x0d','a',' ','b','o','o','t',' ','\xcd','\xc6','\x09','e','m','p','t','y','.',
/* 0x14c16 = "Duplicate segment name." */
    'D','u','p','l','i','c','a','t','e',' ','s','e','g','m','e','n','t',' ','n','a','m','e','.',
/* 0x14c2d = "The loaded XCR0 register value is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','C','R','0',' ','\xbc','\xd2','\x09','\x05','v','a','l','i','d','.',
/* 0x14c44 = "VERR_CR_X509_CERT_SIGN_ALGO_MISMATCH" */
    '\x01','\xa9','X','5','0','9','_','C','E','R','T','_','S','I','G','N','_','A','L','G','O','_','\x99',
/* 0x14c5b = "VWRN_CSAM_TRAP_NOT_HANDLED" */
    'V','W','R','N','_','C','S','A','M','_','T','R','A','P','_','\x14','H','A','N','D','L','E','D',
/* 0x14c72 = "VERR_LDR_IMPORTED_SYMBOL_NOT_FOUND" */
    '\x01','L','D','R','_','I','M','P','O','R','T','E','D','_','S','Y','M','B','O','L','_','\x14','\xb3',
/* 0x14c89 = "VINF_EM_RAW_INTERRUPT_HYPER" */
    '\x19','E','M','_','R','A','W','_','I','N','T','E','R','R','U','P','T','_','H','Y','P','E','R',
/* 0x14ca0 = "VERR_DBGC_PARSE_VARIABLE_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','V','A','R','I','A','B','L','E','_','\x14','\xb3',
/* 0x14cb7 = "Unable to parse the XML in DMG file." */
    '\xca','\x08','p','a','r','s','e',' ','\x02','X','M','L',' ','\x0d','D','M','G',' ','f','i','l','e','.',
/* 0x14cce = "VERR_IOM_INCOMPLETE_MMIO_RANGE" */
    '\x01','I','O','M','_','I','N','C','O','M','P','L','E','T','E','_','\xf4','_','R','A','N','G','E',
/* 0x14ce5 = "VERR_SELM_LDT_OUT_OF_BOUNDS" */
    '\x01','S','E','L','M','_','L','D','T','_','O','U','T','_','O','F','_','B','O','U','N','D','S',
/* 0x14cfc = "Reason for leaving RZ: Ring-3 operation pending." */
    '\x84','\x0e','\x25','R','Z',':',' ','R','i','n','g','-','3',' ','\x83','p','e','n','d','i','n','g','.',
/* 0x14d13 = "VERR_LDRMACHO_UNKNOWN_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\xde','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x14d2a = "Too many primary volume descriptors." */
    '\xf0','\xa3','p','r','i','m','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x14d41 = "VERR_CR_CIPHER_OSSL_GET_TAG_FAILED" */
    '\x01','\xa9','C','I','P','H','E','R','_','O','S','S','L','_','G','E','T','_','T','A','G','_','\x93',
/* 0x14d58 = "Error creating digest algorithm calculator." */
    '\xac','c','r','e','a','t','i','n','g',' ','\xc2','\xbe','c','a','l','c','u','l','a','t','o','r','.',
/* 0x14d6f = "VERR_HTTP_CURL_PROXY_CONFIG" */
    '\x01','H','T','T','P','_','C','U','R','L','_','P','R','O','X','Y','_','C','O','N','F','I','G',
/* 0x14d86 = "VERR_SUP_VP_BAD_SECTION_FILE_SIZE" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','F','I','L','E','_','S','I','Z','E',
/* 0x14d9d = "VFS chain element takes exactly two arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','t','w','o',' ','\xc8',
/* 0x14db4 = "A tracer has already been registered." */
    'A',' ','t','r','a','c','e','r',' ','\x1d','\x22','\xad','r','e','g','i','s','t','e','r','e','d','.',
/* 0x14dcb = "Failed to obtain the GMM instance." */
    '\x80','\x08','o','b','t','a','i','n',' ','\x02','G','M','M',' ','i','n','s','t','a','n','c','e','.',
/* 0x14de2 = "VERR_PGM_MAPPINGS_FIX_REJECTED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','R','E','J','E','C','T','E','D',
/* 0x14df9 = "VERR_PGM_MAPPINGS_FIX_CONFLICT" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','C','O','N','F','L','I','C','T',
/* 0x14e10 = "The TCP server was destroyed." */
    '\x03','T','C','P',' ','s','e','r','v','e','r',' ','\x10','d','e','s','t','r','o','y','e','d','.',
/* 0x14e27 = "The requested feature is not supported in raw-mode." */
    '\x03','\xbf','f','e','a','t','u','r','e',' ','\x09','\x05','\xf9','\x0d','r','a','w','-','m','o','d','e','.',
/* 0x14e3e = "Authentication failure." */
    'A','u','t','h','e','n','t','i','c','a','t','i','o','n',' ','f','a','i','l','u','r','e','.',
/* 0x14e55 = "VERR_SUP_VP_NT_QI_PROCESS_NM_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','P','R','O','C','E','S','S','_','N','M','_','\x9b',
/* 0x14e6c = "VFS chain element takes exactly six arguments." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','e','x','a','c','t','l','y',' ','s','i','x',' ','\xc8',
/* 0x14e83 = "VERR_CR_PKIX_SIGNATURE_GE_KEY" */
    '\x01','\xa9','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','G','E','_','K','E','Y',
/* 0x14e9a = "VERR_SEM_LV_ILLEGAL_UPGRADE" */
    '\x01','S','E','M','_','L','V','_','I','L','L','E','G','A','L','_','U','P','G','R','A','D','E',
/* 0x14eb1 = "Internal processing error #4 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','4',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb6','\xe0','\x5e',
/* 0x14ec8 = "The DTB being parsed has an invalid header magic." */
    '\x03','D','T','B',' ','\xdb','p','a','r','s','e','d',' ','\x1d','\x60','\x81','\xa2','m','a','g','i','c','.',
/* 0x14edf = "VERR_CR_X509_TBSCERT_UNSUPPORTED_VERSION" */
    '\x01','\xa9','X','5','0','9','_','T','B','S','C','E','R','T','_','\x9d','V','E','R','S','I','O','N',
/* 0x14ef6 = "VERR_LDRMACHO_UNSUPPORTED_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x14f0d = "VERR_LDRVI_READ_ERROR_SIGNATURE" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9b','_','S','I','G','N','A','T','U','R','E',
/* 0x14f24 = "VERR_IOMMU_CANNOT_CALL_SELF" */
    '\x01','I','O','M','M','U','_','C','A','N','N','O','T','_','C','A','L','L','_','S','E','L','F',
/* 0x14f3b = "The critical section being deleted was not found." */
    '\x03','c','r','i','t','i','c','a','l',' ','\xc6','\xdb','d','e','l','e','t','e','d',' ','\x10','\x05','\x7d',
/* 0x14f52 = "The mode field should not include the type." */
    '\x03','m','o','d','e',' ','\xff','\xec','\x05','i','n','c','l','u','d','e',' ','\x02','t','y','p','e','.',
/* 0x14f69 = "VERR_CR_PKIX_NOT_RSA_PRIVATE_KEY" */
    '\x01','\xa9','P','K','I','X','_','\x14','R','S','A','_','P','R','I','V','A','T','E','_','K','E','Y',
/* 0x14f80 = "VERR_SYS_UNSUPPORTED_FIRMWARE_PROPERTY" */
    '\x01','S','Y','S','_','\x9d','F','I','R','M','W','A','R','E','_','P','R','O','P','E','R','T','Y',
/* 0x14f97 = "Device or resource is busy." */
    'D','e','v','i','c','e',' ','\x86','r','e','s','o','u','r','c','e',' ','\x09','b','u','s','y','.',
/* 0x14fae = "VERR_INTNET_FLT_VNIC_INIT_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','V','N','I','C','_','I','N','I','T','_','\x93',
/* 0x14fc5 = "Remapping failed for the interrupt." */
    'R','e','m','a','p','p','i','n','g',' ','\x88','\x0e','\x02','i','n','t','e','r','r','u','p','t','.',
/* 0x14fdc = "VERR_LDRMACHO_UNSUPPORTED_TERM_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','T','E','R','M','_','S','E','C','T','I','O','N',
/* 0x14ff3 = "Internal processing error #2 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb6','\xe0','\x5e',
/* 0x1500a = "VERR_SUPDRV_TRACER_UMOD_NOT_ADJACENT" */
    '\x01','\xdc','T','R','A','C','E','R','_','U','M','O','D','_','\x14','A','D','J','A','C','E','N','T',
/* 0x15021 = "VERR_NET_CONNECTION_REFUSED" */
    '\x01','N','E','T','_','C','O','N','N','E','C','T','I','O','N','_','R','E','F','U','S','E','D',
/* 0x15038 = "Import ISO contains a bad root directory record." */
    '\xaf','\xb2',' ','\x7f','a',' ','b','a','d',' ','r','o','o','t',' ','\x1b','r','e','c','o','r','d','.',
/* 0x1504f = "Failed to get a guest page which is expected to be present." */
    '\x80','\x08','g','e','t',' ','a',' ','\xa1','\xb6','\xc0','\x09','\xae','\x08','\x90','p','r','e','s','e','n','t','.',
/* 0x15066 = "VFS chain element takes a file object as input." */
    '\xa4',' ','\x91','\x1f','t','a','k','e','s',' ','a',' ','\x18','\x8d','a','s',' ','i','n','p','u','t','.',
/* 0x1507d = "VINF_PGM_SYNCPAGE_MODIFIED_PDE" */
    '\x19','\xd7','S','Y','N','C','P','A','G','E','_','M','O','D','I','F','I','E','D','_','P','D','E',
/* 0x15094 = "Unsupported key encryption cipher." */
    '\x87','k','e','y',' ','e','n','c','r','y','p','t','i','o','n',' ','c','i','p','h','e','r','.',
/* 0x150ab = "The shared module name is too long." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\xf3','\x09','\x8c','l','o','n','g','.',
/* 0x150c2 = "VERR_LDRMACHO_BAD_LOAD_COMMAND" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','L','O','A','D','_','C','O','M','M','A','N','D',
/* 0x150d9 = "Unresolved (unknown) semaphore error." */
    'U','n','r','e','s','o','l','v','e','d',' ','(','u','n','k','n','o','w','n',')',' ','\xea','\x7b',
/* 0x150f0 = "Image Verification Failure: Internal error in signature parser." */
    '\xfe','\x0c','\x12','\x06','\x07','\x0d','s','i','g','n','a','t','u','r','e',' ','p','a','r','s','e','r','.',
/* 0x15107 = "VERR_CR_KEY_PASSWORD_ENCODING" */
    '\x01','\xa9','K','E','Y','_','P','A','S','S','W','O','R','D','_','E','N','C','O','D','I','N','G',
/* 0x1511e = "VERR_SUPLIB_TEXT_NOT_WRITEABLE" */
    '\x01','S','U','P','L','I','B','_','T','E','X','T','_','\x14','W','R','I','T','E','A','B','L','E',
/* 0x15135 = "VERR_GIM_DEVICE_NOT_REGISTERED" */
    '\x01','G','I','M','_','D','E','V','I','C','E','_','\x14','R','E','G','I','S','T','E','R','E','D',
/* 0x1514c = "VINF_CPUM_HOST_CR0_MODIFIED" */
    '\x19','C','P','U','M','_','H','O','S','T','_','C','R','0','_','M','O','D','I','F','I','E','D',
/* 0x15163 = "VERR_SSM_LOAD_MEMORY_SIZE_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','M','E','M','O','R','Y','_','S','I','Z','E','_','\x99',
/* 0x1517a = "VERR_SUP_VP_IMAGE_FILE_CLOSE_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','F','I','L','E','_','C','L','O','S','E','_','\x9b',
/* 0x15191 = "There is no tracer present." */
    'T','h','e','r','e',' ','\x09','\xe9','t','r','a','c','e','r',' ','p','r','e','s','e','n','t','.',
/* 0x151a8 = "VERR_HARDAVL_STACK_OVERFLOW" */
    '\x01','H','A','R','D','A','V','L','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x151bf = "VERR_IEM_DBGINFO_OUT_OF_MEMORY" */
    '\x01','\xee','D','B','G','I','N','F','O','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x151d6 = "VERR_NET_PROTOCOL_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','F','A','M','I','L','Y','_','\x14','\xc5',
/* 0x151ed = "VERR_BIGNUM_SENSITIVE_INPUT" */
    '\x01','B','I','G','N','U','M','_','S','E','N','S','I','T','I','V','E','_','I','N','P','U','T',
/* 0x15204 = "VERR_SUP_VP_EXE_VS_PROC_NAME_MISMATCH" */
    '\x01','\xe6','V','P','_','E','X','E','_','V','S','_','P','R','O','C','_','N','A','M','E','_','\x99',
/* 0x1521b = "VERR_SUP_VP_UNDESIRABLE_MODULE" */
    '\x01','\xe6','V','P','_','U','N','D','E','S','I','R','A','B','L','E','_','M','O','D','U','L','E',
/* 0x15232 = "Internal processing error #1 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb6','\xe0','\x5e',
/* 0x15249 = "VERR_SSM_VOTE_FOR_GIVING_UP" */
    '\x01','S','S','M','_','V','O','T','E','_','F','O','R','_','G','I','V','I','N','G','_','U','P',
/* 0x15260 = "VINF_EM_DBG_HYPER_ASSERTION" */
    '\x19','E','M','_','D','B','G','_','H','Y','P','E','R','_','A','S','S','E','R','T','I','O','N',
/* 0x15277 = "VERR_VMX_INVALID_VMCS_LAUNCH_STATE" */
    '\x01','V','M','X','_','\x0f','V','M','C','S','_','L','A','U','N','C','H','_','S','T','A','T','E',
/* 0x1528e = "VERR_SUPLIB_INVALID_ARGV0_INTERNAL" */
    '\x01','S','U','P','L','I','B','_','\x0f','A','R','G','V','0','_','I','N','T','E','R','N','A','L',
/* 0x152a5 = "VERR_PDM_CRITSECTRW_MISALIGNED" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','M','I','S','A','L','I','G','N','E','D',
/* 0x152bc = "Internal processing error #3 in the PGM physial page mapping code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','P','G','M',' ','p','h','y','s','i','a','l',' ','\xb6','\xe0','\x5e',
/* 0x152d3 = "Process Verification Failure: The image mapping is too large (>= 2GB)." */
    '\x17','\x0c','\x12','\x03','\x1a','\xe0','\x09','\x8c','l','a','r','g','e',' ','(','>','=',' ','2','G','B',')','.',
/* 0x152ea = "VERR_OUT_OF_SELECTOR_BOUNDS" */
    '\x01','O','U','T','_','O','F','_','S','E','L','E','C','T','O','R','_','B','O','U','N','D','S',
/* 0x15301 = "Process Verification Failure: The process has more than one thread." */
    '\x17','\x0c','\x12','\x03','\x82','\x1d','\xf6','t','h','a','n',' ','o','n','e',' ','t','h','r','e','a','d','.',
/* 0x15318 = "VERR_RECORDING_CODEC_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','I','N','I','T','_','\x93',
/* 0x1532f = "Too many logical volume descriptors." */
    '\xf0','\xa3','l','o','g','i','c','a','l',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s','.',
/* 0x15346 = "Connection reset by peer." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','s','e','t',' ','\xb9','p','e','e','r','.',
/* 0x1535d = "VERR_NET_ADDRESS_NOT_AVAILABLE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','\x14','A','V','A','I','L','A','B','L','E',
/* 0x15374 = "VINF_VGA_RESIZE_IN_PROGRESS" */
    '\x19','V','G','A','_','R','E','S','I','Z','E','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1538b = "The command has already been registered." */
    '\x03','c','o','m','m','a','n','d',' ','\x1d','\x22','\xad','r','e','g','i','s','t','e','r','e','d','.',
/* 0x153a2 = "VERR_VFS_CHAIN_AT_LEAST_THREE_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','L','E','A','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x153b9 = "VERR_DBGC_PARSE_NUMBER_TOO_BIG" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','N','U','M','B','E','R','_','\x9f','B','I','G',
/* 0x153d0 = "No primary volume descriptors found." */
    '\xd0','p','r','i','m','a','r','y',' ','\xbd','d','e','s','c','r','i','p','t','o','r','s',' ','\x7d',
/* 0x153e7 = "Inserting a new chunk failed." */
    'I','n','s','e','r','t','i','n','g',' ','a',' ','n','e','w',' ','c','h','u','n','k',' ','\x24',
/* 0x153fe = "No end of central directory record found." */
    '\xd0','e','n','d',' ','\x13','c','e','n','t','r','a','l',' ','\x1b','r','e','c','o','r','d',' ','\x7d',
/* 0x15415 = "Invalid offset in an L4 dataspace." */
    '\x0b','o','f','f','s','e','t',' ','\x0d','\x60','L','4',' ','d','a','t','a','s','p','a','c','e','.',
/* 0x1542c = "The attribute type did not match." */
    '\x03','a','t','t','r','i','b','u','t','e',' ','\xd9','d','i','d',' ','\x05','m','a','t','c','h','.',
/* 0x15443 = "The UDP server was destroyed." */
    '\x03','U','D','P',' ','s','e','r','v','e','r',' ','\x10','d','e','s','t','r','o','y','e','d','.',
/* 0x1545a = "The loaded XSAVE header is not valid." */
    '\x03','l','o','a','d','e','d',' ','X','S','A','V','E',' ','\xa2','\x09','\x05','v','a','l','i','d','.',
/* 0x15471 = "VERR_SUPDRV_HARDENING_EVIL_HANDLE" */
    '\x01','\xdc','H','A','R','D','E','N','I','N','G','_','E','V','I','L','_','H','A','N','D','L','E',
/* 0x15488 = "VERR_DBGC_PARSE_FUNCTION_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','F','U','N','C','T','I','O','N','_','\x14','\xb3',
/* 0x1549f = "VERR_PDM_DEV_HEAP_R3_TO_GCPHYS" */
    '\x01','\xb8','D','E','V','_','H','E','A','P','_','R','3','_','T','O','_','G','C','P','H','Y','S',
/* 0x154b6 = "Invalid string tag for a X.509 name object." */
    '\x0b','\xc7','t','a','g',' ','\x0e','a',' ','X','.','5','0','9',' ','\xf3','o','b','j','e','c','t','.',
/* 0x154cd = "VERR_LDRPE_CERT_UNSUPPORTED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x154e4 = "VERR_VMM_FN_NOT_SUPPORTED_FOR_VMTARGET" */
    '\x01','V','M','M','_','F','N','_','\x14','\xc5','_','F','O','R','_','V','M','T','A','R','G','E','T',
/* 0x154fb = "Image Verification Failure: Error allocating memory for state data." */
    '\xfe','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','\x5c','\x0e','\xb0','d','a','t','a','.',
/* 0x15512 = "VERR_LDRPE_LOAD_CONFIG_SIZE" */
    '\x01','L','D','R','P','E','_','L','O','A','D','_','C','O','N','F','I','G','_','S','I','Z','E',
/* 0x15529 = "VERR_CR_X509_INVALID_NAME_STRING_TAG" */
    '\x01','\xa9','X','5','0','9','_','\x0f','N','A','M','E','_','S','T','R','I','N','G','_','T','A','G',
/* 0x15540 = "VERR_SSM_FIELD_NOT_CONSECUTIVE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x14','C','O','N','S','E','C','U','T','I','V','E',
/* 0x15557 = "VINF_EM_RAW_RING_SWITCH_INT" */
    '\x19','E','M','_','R','A','W','_','R','I','N','G','_','S','W','I','T','C','H','_','I','N','T',
/* 0x1556e = "VERR_ASN1_INVALID_UTF8_STRING_ENCODING" */
    '\x01','\xf2','\x0f','U','T','F','8','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x15585 = "Certificate path validator: The certificate is not valid at the specified time." */
    '\xa7','\xbb','\xe5','\x03','\x8a','\x09','\x05','v','a','l','i','d',' ','a','t',' ','\x02','\x16','t','i','m','e','.',
/* 0x1559c = "VERR_VD_RAW_SIZE_MODULO_512" */
    '\x01','V','D','_','R','A','W','_','S','I','Z','E','_','M','O','D','U','L','O','_','5','1','2',
/* 0x155b3 = "Specified digest not supported in this context." */
    'S','p','e','c','i','f','i','e','d',' ','\xc2','\x05','\xf9','\x0d','\xc9','c','o','n','t','e','x','t','.',
/* 0x155ca = "Hit the a VM account limit." */
    'H','i','t',' ','\x02','a',' ','\xcf',' ','a','c','c','o','u','n','t',' ','l','i','m','i','t','.',
/* 0x155e1 = "The specified field is outside the structure." */
    '\x03','\x16','\xff','\x09','o','u','t','s','i','d','e',' ','\x02','s','t','r','u','c','t','u','r','e','.',
/* 0x155f8 = "VERR_DBGC_PARSE_NOT_A_FUNCTION" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x14','A','_','F','U','N','C','T','I','O','N',
/* 0x1560f = "VERR_LDRVI_BAD_CERT_HDR_LENGTH" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','L','E','N','G','T','H',
/* 0x15626 = "Page directory pointer not present." */
    'P','a','g','e',' ','\x1b','p','o','i','n','t','e','r',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x1563d = "VERR_TM_VIRTUAL_TICKING_IPE" */
    '\x01','T','M','_','V','I','R','T','U','A','L','_','T','I','C','K','I','N','G','_','I','P','E',
/* 0x15654 = "VERR_ASN1_TIME_BAD_NORMALIZE_INPUT" */
    '\x01','\xf2','T','I','M','E','_','\xa0','N','O','R','M','A','L','I','Z','E','_','I','N','P','U','T',
/* 0x1566b = "VERR_ISOMK_IMPORT_BAD_ROOT_DIR_REC_LENGTH" */
    '\x01','\xaa','\xd4','\xa0','R','O','O','T','_','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x15682 = "The machine is not on the network." */
    '\x03','m','a','c','h','i','n','e',' ','\x09','\x05','o','n',' ','\x02','n','e','t','w','o','r','k','.',
/* 0x15699 = "VINF_VMX_VMLAUNCH_VMRESUME" */
    '\x19','V','M','X','_','V','M','L','A','U','N','C','H','_','V','M','R','E','S','U','M','E',
/* 0x156af = "VERR_SUP_VP_QUERY_HANDLE_TYPE" */
    '\x01','\xe6','V','P','_','Q','U','E','R','Y','_','H','A','N','D','L','E','_','T','Y','P','E',
/* 0x156c5 = "VERR_VM_SAVE_STATE_NOT_ALLOWED" */
    '\x01','\xcf','_','S','A','V','E','_','S','T','A','T','E','_','\x14','A','L','L','O','W','E','D',
/* 0x156db = "VERR_TAR_UNSUPPORTED_SOLARIS_HDR_TYPE" */
    '\x01','T','A','R','_','\x9d','S','O','L','A','R','I','S','_','H','D','R','_','T','Y','P','E',
/* 0x156f1 = "VERR_CR_X509_UNKNOWN_CERT_SIGN_ALGO" */
    '\x01','\xa9','X','5','0','9','_','\xde','C','E','R','T','_','S','I','G','N','_','A','L','G','O',
/* 0x15707 = "More data available in pipe." */
    'M','o','r','e',' ','\x8f','a','v','a','i','l','a','b','l','e',' ','\x0d','p','i','p','e','.',
/* 0x1571d = "Wrong JSON type for integer value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xd9','\x0e','i','n','t','e','g','e','r',' ','\xd3',
/* 0x15733 = "Internal ISO maker error: Buffer size." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','B','u','f','f','e','r',' ','s','i','z','e','.',
/* 0x15749 = "VERR_VUSB_USBFS_PERMISSION" */
    '\x01','V','U','S','B','_','U','S','B','F','S','_','P','E','R','M','I','S','S','I','O','N',
/* 0x1575f = "VERR_VFS_CHAIN_EXPECTED_SEPARATOR" */
    '\x01','\xa4','_','\xda','E','X','P','E','C','T','E','D','_','S','E','P','A','R','A','T','O','R',
/* 0x15775 = "VERR_EM_RAW_PATCH_CONFLICT" */
    '\x01','E','M','_','R','A','W','_','P','A','T','C','H','_','C','O','N','F','L','I','C','T',
/* 0x1578b = "VERR_GMM_MODULE_NAME_TOO_LONG" */
    '\x01','G','M','M','_','M','O','D','U','L','E','_','N','A','M','E','_','\x9f','L','O','N','G',
/* 0x157a1 = "Can\'t assign requested address." */
    'C','a','n','\'','t',' ','a','s','s','i','g','n',' ','\xbf','a','d','d','r','e','s','s','.',
/* 0x157b7 = "VMDK: Invalid write position." */
    'V','M','D','K',':',' ','\x0b','w','r','i','t','e',' ','p','o','s','i','t','i','o','n','.',
/* 0x157cd = "VERR_IPC_RECEIVE_CANCELLED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','C','A','N','C','E','L','L','E','D',
/* 0x157e3 = "VERR_SUPLIB_WORLD_WRITABLE" */
    '\x01','S','U','P','L','I','B','_','W','O','R','L','D','_','W','R','I','T','A','B','L','E',
/* 0x157f9 = "VINF_THREAD_IS_TERMINATING" */
    '\x19','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x1580f = "Unsupported image target architecture." */
    '\x87','\x1a','t','a','r','g','e','t',' ','a','r','c','h','i','t','e','c','t','u','r','e','.',
/* 0x15825 = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_1" */
    '\x01','\xdc','\x14','B','U','D','D','I','N','G','_','\xcf','_','P','R','O','C','E','S','S','_','1',
/* 0x1583b = "VERR_CPUM_INVALID_XSAVE_COMP_MASK" */
    '\x01','C','P','U','M','_','\x0f','X','S','A','V','E','_','C','O','M','P','_','M','A','S','K',
/* 0x15851 = "VERR_XAR_TOC_UTF8_ENCODING" */
    '\x01','X','A','R','_','T','O','C','_','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x15867 = "Bad digest length encountered in the table of content." */
    '\x92','\xc2','l','e','n','g','t','h',' ','\x98','\x0d','\x02','\x9e','\x13','c','o','n','t','e','n','t','.',
/* 0x1587d = "The table of content isn\'t valid UTF-8." */
    '\x03','\x9e','\x13','\xd8','i','s','n','\'','t',' ','v','a','l','i','d',' ','U','T','F','-','8','.',
/* 0x15893 = "VERR_LDRLX_BAD_LOADER_SECTION" */
    '\x01','L','D','R','L','X','_','\xa0','L','O','A','D','E','R','_','S','E','C','T','I','O','N',
/* 0x158a9 = "VWRN_NEGATIVE_UNSIGNED" */
    'V','W','R','N','_','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x158bf = "VERR_VFS_CHAIN_AT_LEAST_FOUR_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','L','E','A','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x158d5 = "VERR_ASN1_OBJID_INVALID_DOTTED_STRING" */
    '\x01','\xf2','O','B','J','I','D','_','\x0f','D','O','T','T','E','D','_','S','T','R','I','N','G',
/* 0x158eb = "VERR_INCONSISTENT_VM_HANDLE" */
    '\x01','I','N','C','O','N','S','I','S','T','E','N','T','_','\xcf','_','H','A','N','D','L','E',
/* 0x15901 = "Invalid argument to VFS chain element." */
    '\x0b','a','r','g','u','m','e','n','t',' ','\x08','\xa4',' ','\x91','e','l','e','m','e','n','t','.',
/* 0x15917 = "Codec initialization failed." */
    'C','o','d','e','c',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x1592d = "VERR_ASN1_INVALID_BMP_STRING_ENCODING" */
    '\x01','\xf2','\x0f','B','M','P','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x15943 = "VINF_PATM_CHECK_PATCH_PAGE" */
    '\x19','P','A','T','M','_','C','H','E','C','K','_','P','A','T','C','H','_','P','A','G','E',
/* 0x15959 = "VERR_THREAD_IS_TERMINATING" */
    '\x01','T','H','R','E','A','D','_','I','S','_','T','E','R','M','I','N','A','T','I','N','G',
/* 0x1596f = "VERR_CR_OPENSSL_VERSION_TOO_OLD" */
    '\x01','\xa9','O','P','E','N','S','S','L','_','V','E','R','S','I','O','N','_','\x9f','O','L','D',
/* 0x15985 = "VERR_ASN1_INVALID_IA5_STRING_ENCODING" */
    '\x01','\xf2','\x0f','I','A','5','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x1599b = "VERR_SSM_LOW_ON_DISK_SPACE" */
    '\x01','S','S','M','_','L','O','W','_','O','N','_','D','I','S','K','_','S','P','A','C','E',
/* 0x159b1 = "Process Verification Failure: Bad new-header offset in the MZ header." */
    '\x17','\x0c','\x12','\x92','n','e','w','-','\xa2','o','f','f','s','e','t',' ','\x0d','\x02','M','Z',' ','\xe7',
/* 0x159c7 = "VERR_SMM_INTEGRITY_MACHINE" */
    '\x01','S','M','M','_','I','N','T','E','G','R','I','T','Y','_','M','A','C','H','I','N','E',
/* 0x159dd = "VERR_MANIFEST_UNSUPPORTED_DIGEST_TYPE" */
    '\x01','M','A','N','I','F','E','S','T','_','\x9d','D','I','G','E','S','T','_','T','Y','P','E',
/* 0x159f3 = "VERR_PDM_INVALID_DEVICE_REGISTRATION" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x15a09 = "Reason for leaving RZ: I/O port write." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','w','r','i','t','e','.',
/* 0x15a1f = "VERR_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x15a35 = "VERR_NET_ADDRESS_FAMILY_NOT_SUPPORTED" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','F','A','M','I','L','Y','_','\x14','\xc5',
/* 0x15a4b = "VERR_CR_MALFORMED_PEM_HEADER" */
    '\x01','\xa9','M','A','L','F','O','R','M','E','D','_','P','E','M','_','H','E','A','D','E','R',
/* 0x15a61 = "Internal processing error related to guest mappings." */
    '\x06','\x04','\x07','r','e','l','a','t','e','d',' ','\x08','\xa1','m','a','p','p','i','n','g','s','.',
/* 0x15a77 = "VINF_SVM_INTERCEPT_NOT_ACTIVE" */
    '\x19','S','V','M','_','I','N','T','E','R','C','E','P','T','_','\x14','A','C','T','I','V','E',
/* 0x15a8d = "VERR_SUP_VP_NO_KERNEL32_MAPPING" */
    '\x01','\xe6','V','P','_','\xb7','K','E','R','N','E','L','3','2','_','M','A','P','P','I','N','G',
/* 0X15aa3 = "Guest side reported an error." */
    'u','e','s','t',' ','s','i','d','e',' ','r','e','p','o','r','t','e','d',' ','\x60','\x7b',
/* 0x15ab8 = "VERR_VFS_CHAIN_AT_MOST_THREE_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','M','O','S','T','_','T','H','R','E','E','_','A','R','G','S',
/* 0x15ace = "VERR_HARDAVL_BAD_RIGHT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','R','I','G','H','T','_','H','E','I','G','H','T',
/* 0x15ae4 = "VERR_SELM_SHADOW_LDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','L','D','T','_','W','R','I','T','E',
/* 0x15afa = "VERR_CR_PKIX_SIGNATURE_TOO_LONG" */
    '\x01','\xa9','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x9f','L','O','N','G',
/* 0x15b10 = "Incorrect version numbers in the header." */
    'I','n','c','o','r','r','e','c','t',' ','\xb4','n','u','m','b','e','r','s',' ','\x0d','\x02','\xe7',
/* 0x15b26 = "VINF_IOM_R3_MMIO_COMMIT_WRITE" */
    '\x19','I','O','M','_','R','3','_','\xf4','_','C','O','M','M','I','T','_','W','R','I','T','E',
/* 0x15b3c = "The saved state directory magic is wrong." */
    '\x03','s','a','v','e','d',' ','\xb0','\x1b','m','a','g','i','c',' ','\x09','w','r','o','n','g','.',
/* 0x15b52 = "Expected a different time tag." */
    '\xa6','a',' ','d','i','f','f','e','r','e','n','t',' ','t','i','m','e',' ','t','a','g','.',
/* 0x15b68 = "VERR_SELM_SHADOW_GDT_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','G','D','T','_','W','R','I','T','E',
/* 0x15b7e = "The symbol is not a forwarder." */
    '\x03','s','y','m','b','o','l',' ','\x09','\x05','a',' ','f','o','r','w','a','r','d','e','r','.',
/* 0x15b94 = "The server does not support the requested function." */
    '\x03','s','e','r','v','e','r',' ','\x9c','\x05','\xb1','\x02','\xbf','f','u','n','c','t','i','o','n','.',
/* 0x15baa = "VERR_VMX_STARTVM_PRECOND_1" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','1',
/* 0x15bc0 = "VERR_SSM_IDE_ASYNC_TIMEOUT" */
    '\x01','S','S','M','_','I','D','E','_','A','S','Y','N','C','_','T','I','M','E','O','U','T',
/* 0x15bd6 = "VERR_PDM_MEDIAEX_IOREQ_INVALID_STATE" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','_','\x0f','S','T','A','T','E',
/* 0x15bec = "The component factory was not found." */
    '\x03','c','o','m','p','o','n','e','n','t',' ','f','a','c','t','o','r','y',' ','\x10','\x05','\x7d',
/* 0x15c02 = "VERR_SUP_VP_NOT_KNOWN_DLL_OR_EXE" */
    '\x01','\xe6','V','P','_','\x14','K','N','O','W','N','_','D','L','L','_','O','R','_','E','X','E',
/* 0x15c18 = "Device i/o: Not ready." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','N','o','t',' ','r','e','a','d','y','.',
/* 0x15c2e = "VERR_VMX_STARTVM_PRECOND_0" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','0',
/* 0x15c44 = "VERR_POLL_HANDLE_ID_EXISTS" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','E','X','I','S','T','S',
/* 0x15c5a = "VERR_ISOMK_IMPORT_ZERO_SIZED_ROOT_DIR" */
    '\x01','\xaa','\xd4','Z','E','R','O','_','S','I','Z','E','D','_','R','O','O','T','_','D','I','R',
/* 0x15c70 = "VINF_PATM_HC_MMIO_PATCH_WRITE" */
    '\x19','P','A','T','M','_','H','C','_','\xf4','_','P','A','T','C','H','_','W','R','I','T','E',
/* 0x15c86 = "VERR_ASN1_NO_CHECK_SANITY_METHOD" */
    '\x01','\xf2','\xb7','C','H','E','C','K','_','S','A','N','I','T','Y','_','M','E','T','H','O','D',
/* 0x15c9c = "VERR_SSM_INTEGRITY_VERSION" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','V','E','R','S','I','O','N',
/* 0x15cb2 = "VINF_EM_HM_PATCH_TPR_INSTR" */
    '\x19','E','M','_','H','M','_','P','A','T','C','H','_','T','P','R','_','I','N','S','T','R',
/* 0x15cc8 = "Is a character device." */
    'I','s',' ','a',' ','c','h','a','r','a','c','t','e','r',' ','d','e','v','i','c','e','.',
/* 0x15cde = "VERR_GIM_NO_DEBUG_CONNECTION" */
    '\x01','G','I','M','_','\xb7','D','E','B','U','G','_','C','O','N','N','E','C','T','I','O','N',
/* 0x15cf4 = "No attribute of the specified types was found." */
    '\xd0','a','t','t','r','i','b','u','t','e',' ','\x13','\x02','\x16','t','y','p','e','s',' ','\x10','\x7d',
/* 0x15d0a = "VERR_SUP_VP_UNEXPECTED_VALID_PATH_COUNT" */
    '\x01','\xe6','V','P','_','\xce','V','A','L','I','D','_','P','A','T','H','_','C','O','U','N','T',
/* 0x15d20 = "VERR_POLL_HANDLE_NOT_POLLABLE" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','\x14','P','O','L','L','A','B','L','E',
/* 0x15d36 = "There is no volume behind the current one." */
    'T','h','e','r','e',' ','\x09','\xe9','\xbd','b','e','h','i','n','d',' ','\x02','\xd1','o','n','e','.',
/* 0x15d4c = "The guest has reported too many modules." */
    '\x03','\xa1','\x1d','r','e','p','o','r','t','e','d',' ','\x8c','\xa3','m','o','d','u','l','e','s','.',
/* 0x15d62 = "VERR_XAR_BAD_CHECKSUM_ELEMENT" */
    '\x01','X','A','R','_','\xa0','C','H','E','C','K','S','U','M','_','E','L','E','M','E','N','T',
/* 0x15d78 = "VERR_TRPM_SHADOW_IDT_WRITE" */
    '\x01','T','R','P','M','_','S','H','A','D','O','W','_','I','D','T','_','W','R','I','T','E',
/* 0x15d8e = "VINF_VRDP_RESIZE_REQUESTED" */
    '\x19','V','R','D','P','_','R','E','S','I','Z','E','_','R','E','Q','U','E','S','T','E','D',
/* 0x15da4 = "NEM returned in the wrong state." */
    'N','E','M',' ','r','e','t','u','r','n','e','d',' ','\x0d','\x02','w','r','o','n','g',' ','\xf5',
/* 0x15dba = "VERR_VMX_UNABLE_TO_START_VM" */
    '\x01','V','M','X','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xcf',
/* 0x15dd0 = "VINF_EM_EMULATE_SPLIT_LOCK" */
    '\x19','E','M','_','E','M','U','L','A','T','E','_','S','P','L','I','T','_','L','O','C','K',
/* 0x15de6 = "VERR_CPUM_HIDDEN_CS_LOAD_ERROR" */
    '\x01','C','P','U','M','_','H','I','D','D','E','N','_','C','S','_','L','O','A','D','_','\x9b',
/* 0x15dfc = "Bad VTG probe descriptor." */
    '\x92','V','T','G',' ','p','r','o','b','e',' ','d','e','s','c','r','i','p','t','o','r','.',
/* 0x15e12 = "VERR_PROC_NO_ARG_TRANSLATION" */
    '\x01','P','R','O','C','_','\xb7','A','R','G','_','T','R','A','N','S','L','A','T','I','O','N',
/* 0x15e28 = "VERR_SUP_VP_IMAGE_FILE_OPEN_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','F','I','L','E','_','O','P','E','N','_','\x9b',
/* 0x15e3e = "VERR_CR_PKIX_NOT_RSA_PUBLIC_KEY" */
    '\x01','\xa9','P','K','I','X','_','\x14','R','S','A','_','P','U','B','L','I','C','_','K','E','Y',
/* 0x15e54 = "No unwind information was found." */
    '\xd0','u','n','w','i','n','d',' ','i','n','f','o','r','m','a','t','i','o','n',' ','\x10','\x7d',
/* 0x15e6a = "Too many instances of a driver." */
    '\xf0','\xa3','i','n','s','t','a','n','c','e','s',' ','\x13','a',' ','d','r','i','v','e','r','.',
/* 0x15e80 = "VERR_SHCLPB_TRANSFER_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','T','R','A','N','S','F','E','R','_','I','D','_','\x14','\xb3',
/* 0x15e96 = "VERR_WRONG_PARAMETER_COUNT" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','C','O','U','N','T',
/* 0x15eac = "VERR_VD_PASSWORD_INCORRECT" */
    '\x01','V','D','_','P','A','S','S','W','O','R','D','_','I','N','C','O','R','R','E','C','T',
/* 0x15ec2 = "VERR_DBGC_PARSE_COMMAND_NOT_FOUND" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','C','O','M','M','A','N','D','_','\x14','\xb3',
/* 0x15ed8 = "Unable to use the range for a large page." */
    '\xca','\x08','u','s','e',' ','\x02','\xe4','\x0e','a',' ','l','a','r','g','e',' ','p','a','g','e','.',
/* 0x15eee = "Attempt to divide by zero." */
    'A','t','t','e','m','p','t',' ','\x08','d','i','v','i','d','e',' ','\xb9','z','e','r','o','.',
/* 0x15f04 = "VERR_CR_PKCS7_EXPECTED_NO_CRLS" */
    '\x01','\xa9','P','K','C','S','7','_','E','X','P','E','C','T','E','D','_','\xb7','C','R','L','S',
/* 0x15f1a = "Invalid executable signature." */
    '\x0b','e','x','e','c','u','t','a','b','l','e',' ','s','i','g','n','a','t','u','r','e','.',
/* 0x15f30 = "VERR_CR_KEY_TOO_SHORT_CIPHER_IV" */
    '\x01','\xa9','K','E','Y','_','\x9f','S','H','O','R','T','_','C','I','P','H','E','R','_','I','V',
/* 0x15f46 = "VINF_DBG_ADJUSTED_SYM_SIZE" */
    '\x19','D','B','G','_','A','D','J','U','S','T','E','D','_','S','Y','M','_','S','I','Z','E',
/* 0x15f5c = "Too many instances of a device." */
    '\xf0','\xa3','i','n','s','t','a','n','c','e','s',' ','\x13','a',' ','d','e','v','i','c','e','.',
/* 0x15f72 = "I/O ports are not mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x05','m','a','p','p','e','d','.',
/* 0x15f88 = "VERR_ASN1_INVALID_T61_STRING_ENCODING" */
    '\x01','\xf2','\x0f','T','6','1','_','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x15f9e = "The USB hub is already registered." */
    '\x03','U','S','B',' ','h','u','b',' ','\x09','\x22','r','e','g','i','s','t','e','r','e','d','.',
/* 0x15fb4 = "RTCache: cache is empty." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x09','e','m','p','t','y','.',
/* 0x15fca = "Library was not initialized." */
    'L','i','b','r','a','r','y',' ','\x10','\x05','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x15fe0 = "VERR_ISOMK_IMPORT_VOLUME_SPACE_SIZE_MISMATCH" */
    '\x01','\xaa','\xd4','V','O','L','U','M','E','_','S','P','A','C','E','_','S','I','Z','E','_','\x99',
/* 0x15ff6 = "VERR_SUPLIB_PATH_NOT_ABSOLUTE" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x14','A','B','S','O','L','U','T','E',
/* 0x1600c = "I/O ports are already mapped." */
    'I','/','O',' ','p','o','r','t','s',' ','a','r','e',' ','\x22','m','a','p','p','e','d','.',
/* 0x16022 = "The page to be freed or updated was not found." */
    '\x03','\xb6','\x08','\x90','f','r','e','e','d',' ','\x86','u','p','d','a','t','e','d',' ','\x10','\x05','\x7d',
/* 0x16038 = "VERR_ISOMK_BOOT_CAT_EMPTY_ENTRY" */
    '\x01','\xaa','B','O','O','T','_','C','A','T','_','E','M','P','T','Y','_','E','N','T','R','Y',
/* 0x1604e = "VERR_CANT_DELETE_DIRECTORY" */
    '\x01','C','A','N','T','_','D','E','L','E','T','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x16064 = "VERR_PGM_SAVED_MMIO2_RANGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','M','M','I','O','2','_','R','A','N','G','E','_','\x14','\xb3',
/* 0x1607a = "VERR_VMX_STARTVM_PRECOND_2" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','2',
/* 0x16090 = "VERR_VMX_STARTVM_PRECOND_3" */
    '\x01','V','M','X','_','S','T','A','R','T','V','M','_','P','R','E','C','O','N','D','_','3',
/* 0x160a6 = "VERR_LDRMACHO_BAD_SYMTAB_SIZE" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','Y','M','T','A','B','_','S','I','Z','E',
/* 0x160bc = "VERR_VMX_NOT_IN_VMX_ROOT_MODE" */
    '\x01','V','M','X','_','\x14','I','N','_','V','M','X','_','R','O','O','T','_','M','O','D','E',
/* 0x160d2 = "File or directory can\'t be created." */
    'F','i','l','e',' ','\x86','\x1b','c','a','n','\'','t',' ','\x90','c','r','e','a','t','e','d','.',
/* 0x160e8 = "VERR_ISOFS_UNKNOWN_PART_MAP_ENTRY_TYPE" */
    '\x01','\xfd','\xde','P','A','R','T','_','M','A','P','_','E','N','T','R','Y','_','T','Y','P','E',
/* 0x160fe = "VERR_DWARF_STACK_UNDERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','U','N','D','E','R','F','L','O','W',
/* 0x16114 = "The trace log is malformed." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\x09','m','a','l','f','o','r','m','e','d','.',
/* 0x1612a = "VERR_SVM_UNABLE_TO_START_VM" */
    '\x01','S','V','M','_','U','N','A','B','L','E','_','T','O','_','S','T','A','R','T','_','\xcf',
/* 0x16140 = "RTGetOpt: Not an option." */
    'R','T','G','e','t','O','p','t',':',' ','N','o','t',' ','\x60','o','p','t','i','o','n','.',
/* 0x16156 = "VINF_EM_RAW_STALE_SELECTOR" */
    '\x19','E','M','_','R','A','W','_','S','T','A','L','E','_','S','E','L','E','C','T','O','R',
/* 0x1616c = "VERR_PATH_GLOB_UNKNOWN_CHAR_CLASS" */
    '\x01','P','A','T','H','_','G','L','O','B','_','\xde','C','H','A','R','_','C','L','A','S','S',
/* 0x16182 = "VERR_DBGC_PARSE_INVALID_OPERATION" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x0f','O','P','E','R','A','T','I','O','N',
/* 0x16198 = "Failed to lock the address range." */
    '\x80','\x08','l','o','c','k',' ','\x02','a','d','d','r','e','s','s',' ','r','a','n','g','e','.',
/* 0x161ae = "VERR_SUP_VP_TOO_MANY_DLLS_LOADED" */
    '\x01','\xe6','V','P','_','\x9f','M','A','N','Y','_','D','L','L','S','_','L','O','A','D','E','D',
/* 0x161c4 = "VERR_VFS_CHAIN_AT_LEAST_FIVE_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','L','E','A','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x161da = "VERR_HM_NO_32_TO_64_SWITCHER" */
    '\x01','H','M','_','\xb7','3','2','_','T','O','_','6','4','_','S','W','I','T','C','H','E','R',
/* 0x161f0 = "VERR_CR_SPC_PEIMAGE_NO_CONTENT" */
    '\x01','\xa9','S','P','C','_','P','E','I','M','A','G','E','_','\xb7','C','O','N','T','E','N','T',
/* 0x16206 = "VERR_IPE_UNINITIALIZED_STATUS" */
    '\x01','\x8e','U','N','I','N','I','T','I','A','L','I','Z','E','D','_','S','T','A','T','U','S',
/* 0x1621c = "VERR_ISOMK_IMPORT_BOOT_CAT_UNKNOWN_HEADER_ID" */
    '\x01','\xaa','\xd4','B','O','O','T','_','C','A','T','_','\xde','H','E','A','D','E','R','_','I','D',
/* 0x16232 = "VWRN_CONTINUE_ANALYSIS" */
    'V','W','R','N','_','C','O','N','T','I','N','U','E','_','A','N','A','L','Y','S','I','S',
/* 0x16248 = "Process Verification Failure: Error allocating memory." */
    '\x17','\x0c','\x12','\xac','a','l','l','o','c','a','t','i','n','g',' ','m','e','m','o','r','y','.',
/* 0x1625e = "Syntax error - unbalanced quotes." */
    '\xe1','\x07','-',' ','u','n','b','a','l','a','n','c','e','d',' ','q','u','o','t','e','s','.',
/* 0x16274 = "Invalid file mode mask (RTFMODE)." */
    '\x0b','\x18','m','o','d','e',' ','m','a','s','k',' ','(','R','T','F','M','O','D','E',')','.',
/* 0x1628a = "VERR_PDM_INVALID_DRIVER_REGISTRATION" */
    '\x01','\xb8','\x0f','D','R','I','V','E','R','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x162a0 = "VERR_HM_UNSUPPORTED_CPU_FEATURE_COMBO" */
    '\x01','H','M','_','\x9d','C','P','U','_','F','E','A','T','U','R','E','_','C','O','M','B','O',
/* 0x162b6 = "Empty string in X.509 name object." */
    'E','m','p','t','y',' ','\xc7','\x0d','X','.','5','0','9',' ','\xf3','o','b','j','e','c','t','.',
/* 0x162cc = "VERR_PGM_PHYS_NULL_PAGE_PARAM" */
    '\x01','\xd7','P','H','Y','S','_','N','U','L','L','_','P','A','G','E','_','P','A','R','A','M',
/* 0x162e2 = "VERR_VFS_CHAIN_TRAILING_SEPARATOR" */
    '\x01','\xa4','_','\xda','T','R','A','I','L','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x162f8 = "VERR_VUSB_DEVICE_NOT_ATTACHED" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','\x14','A','T','T','A','C','H','E','D',
/* 0x1630e = "Media not present in drive." */
    'M','e','d','i','a',' ','\x05','p','r','e','s','e','n','t',' ','\x0d','d','r','i','v','e','.',
/* 0x16324 = "Not an integer property." */
    'N','o','t',' ','\x60','i','n','t','e','g','e','r',' ','p','r','o','p','e','r','t','y','.',
/* 0x1633a = "VERR_SELM_SHADOW_TSS_WRITE" */
    '\x01','S','E','L','M','_','S','H','A','D','O','W','_','T','S','S','_','W','R','I','T','E',
/* 0x16350 = "Async command pending." */
    'A','s','y','n','c',' ','c','o','m','m','a','n','d',' ','p','e','n','d','i','n','g','.',
/* 0x16366 = "VERR_VMM_SMAP_BUT_AC_CLEAR" */
    '\x01','V','M','M','_','S','M','A','P','_','B','U','T','_','A','C','_','C','L','E','A','R',
/* 0x1637c = "Image Verification Failure: Error reading file for hashing." */
    '\xfe','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x18','\x0e','h','a','s','h','i','n','g','.',
/* 0x16392 = "VERR_LDRMACHO_BAD_OBJECT_FILE" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','O','B','J','E','C','T','_','F','I','L','E',
/* 0x163a8 = "VINF_VMX_INTERCEPT_NOT_ACTIVE" */
    '\x19','V','M','X','_','I','N','T','E','R','C','E','P','T','_','\x14','A','C','T','I','V','E',
/* 0x163be = "VERR_ASN1_OBJID_COMPONENT_TOO_BIG" */
    '\x01','\xf2','O','B','J','I','D','_','C','O','M','P','O','N','E','N','T','_','\x9f','B','I','G',
/* 0x163d4 = "Wrong parameter count." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','c','o','u','n','t','.',
/* 0x163ea = "VERR_SUPDRV_NOT_BUDDING_VM_PROCESS_2" */
    '\x01','\xdc','\x14','B','U','D','D','I','N','G','_','\xcf','_','P','R','O','C','E','S','S','_','2',
/* 0x16400 = "VERR_XAR_TOC_UNCOMP_SIZE_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','U','N','C','O','M','P','_','S','I','Z','E','_','\x99',
/* 0x16416 = "VERR_PDM_NO_REGISTRATION_EXPORT" */
    '\x01','\xb8','\xb7','R','E','G','I','S','T','R','A','T','I','O','N','_','E','X','P','O','R','T',
/* 0x1642c = "VINF_PGM_PHYS_TLB_CATCH_WRITE" */
    '\x19','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','W','R','I','T','E',
/* 0x16442 = "VERR_MANIFEST_ATTR_TYPE_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','T','Y','P','E','_','\x14','\xb3',
/* 0x16458 = "VINF_VMX_MODIFIES_BEHAVIOR" */
    '\x19','V','M','X','_','M','O','D','I','F','I','E','S','_','B','E','H','A','V','I','O','R',
/* 0x1646e = "VERR_SSM_INTEGRITY_UNIT_NOT_FOUND" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','U','N','I','T','_','\x14','\xb3',
/* 0x16484 = "VERR_SSM_INTEGRITY_REC_HDR" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','R','E','C','_','H','D','R',
/* 0x1649a = "Too many references to an object." */
    '\xf0','\xa3','r','e','f','e','r','e','n','c','e','s',' ','\x08','\x60','o','b','j','e','c','t','.',
/* 0x164b0 = "VERR_HARDAVL_BAD_LEFT_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','L','E','F','T','_','H','E','I','G','H','T',
/* 0x164c5 = "Process Verification Failure: Bad virtual section address." */
    '\x17','\x0c','\x12','\x92','v','i','r','t','u','a','l',' ','\xc6','a','d','d','r','e','s','s','.',
/* 0x164da = "VERR_IOM_MMIO_RANGE_CONFLICT" */
    '\x01','I','O','M','_','\xf4','_','R','A','N','G','E','_','C','O','N','F','L','I','C','T',
/* 0x164ef = "Invalid GC physical address." */
    '\x0b','G','C',' ','p','h','y','s','i','c','a','l',' ','a','d','d','r','e','s','s','.',
/* 0x16504 = "Syntax error - numeric overflow." */
    '\xe1','\x07','-',' ','n','u','m','e','r','i','c',' ','o','v','e','r','f','l','o','w','.',
/* 0x16519 = "VERR_PGM_PHYS_WR_HIT_HANDLER" */
    '\x01','\xd7','P','H','Y','S','_','W','R','_','H','I','T','_','H','A','N','D','L','E','R',
/* 0x1652e = "VERR_CR_SPC_BAD_MONIKER_CHOICE" */
    '\x01','\xa9','S','P','C','_','\xa0','M','O','N','I','K','E','R','_','C','H','O','I','C','E',
/* 0x16543 = "VERR_LDR_FORWARDER_CHAIN_TOO_LONG" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','_','\xda','\x9f','L','O','N','G',
/* 0x16558 = "Not implemented for UDF." */
    'N','o','t',' ','i','m','p','l','e','m','e','n','t','e','d',' ','\x0e','U','D','F','.',
/* 0x1656d = "VERR_EM_UNEXPECTED_MAPPING_CONFLICT" */
    '\x01','E','M','_','\xce','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x16582 = "VERR_CR_PKCS7_DIGEST_CALC_ERROR" */
    '\x01','\xa9','P','K','C','S','7','_','D','I','G','E','S','T','_','C','A','L','C','_','\x9b',
/* 0x16597 = "HTTP initialization failed." */
    'H','T','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x165ac = "Image Verification Failure: Error reading section headers." */
    '\xfe','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\xc6','h','e','a','d','e','r','s','.',
/* 0x165c1 = "VINF_EM_DBG_HYPER_STEPPED" */
    '\x19','E','M','_','D','B','G','_','H','Y','P','E','R','_','S','T','E','P','P','E','D',
/* 0x165d6 = "Can\'t delete directory with files." */
    'C','a','n','\'','t',' ','d','e','l','e','t','e',' ','\x1b','\x1e','f','i','l','e','s','.',
/* 0x165eb = "VERR_LDRVI_BAD_CERT_MULTIPLE" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','M','U','L','T','I','P','L','E',
/* 0x16600 = "VERR_VM_DRIVER_NOT_ACCESSIBLE" */
    '\x01','\xcf','_','D','R','I','V','E','R','_','\x14','A','C','C','E','S','S','I','B','L','E',
/* 0x16615 = "Cannot block in ring-0." */
    'C','a','n','n','o','t',' ','b','l','o','c','k',' ','\x0d','r','i','n','g','-','0','.',
/* 0x1662a = "VERR_NO_MORE_SEARCH_HANDLES" */
    '\x01','\xb7','M','O','R','E','_','S','E','A','R','C','H','_','H','A','N','D','L','E','S',
/* 0x1663f = "The discard operation is not supported for this image." */
    '\x03','d','i','s','c','a','r','d',' ','\x83','\x09','\x05','\xf9','\x0e','\xc9','i','m','a','g','e','.',
/* 0x16654 = "VERR_HTTP_STATUS_SERVER_ERROR" */
    '\x01','H','T','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x9b',
/* 0x16669 = "VERR_CANT_RECODE_AS_UTF16" */
    '\x01','C','A','N','T','_','R','E','C','O','D','E','_','A','S','_','U','T','F','1','6',
/* 0x1667e = "Import ISO contains a too deep directory subtree." */
    '\xaf','\xb2',' ','\x7f','a',' ','\x8c','d','e','e','p',' ','\x1b','s','u','b','t','r','e','e','.',
/* 0x16693 = "Unknown partition map entry type." */
    '\xdf','p','a','r','t','i','t','i','o','n',' ','m','a','p',' ','\xb5','t','y','p','e','.',
/* 0x166a8 = "Wrong JSON type for double value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xd9','\x0e','d','o','u','b','l','e',' ','\xd3',
/* 0x166bd = "VINF_DBGF_TRUNCATED_REGISTER" */
    '\x19','\xf1','_','T','R','U','N','C','A','T','E','D','_','R','E','G','I','S','T','E','R',
/* 0x166d2 = "VERR_PGM_UNSUPPORTED_SHADOW_PAGING_MODE" */
    '\x01','\xd7','\x9d','S','H','A','D','O','W','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x166e7 = "VERR_VMX_MSR_VMX_ENABLE_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','V','M','X','_','E','N','A','B','L','E','_','\x93',
/* 0x166fc = "VERR_NET_OUT_OF_RESOURCES" */
    '\x01','N','E','T','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x16711 = "VERR_LDRMACHO_UNSUPPORTED_FIXUP_TYPE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','F','I','X','U','P','_','T','Y','P','E',
/* 0x16726 = "Out of selector bounds." */
    'O','u','t',' ','\x13','s','e','l','e','c','t','o','r',' ','b','o','u','n','d','s','.',
/* 0x1673b = "VERR_SUP_VP_NON_SYSTEM32_DLL" */
    '\x01','\xe6','V','P','_','N','O','N','_','S','Y','S','T','E','M','3','2','_','D','L','L',
/* 0x16750 = "Source/destination not found." */
    'S','o','u','r','c','e','/','d','e','s','t','i','n','a','t','i','o','n',' ','\x05','\x7d',
/* 0x16765 = "VERR_LDRVI_BAD_CERT_HDR_TYPE" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','H','D','R','_','T','Y','P','E',
/* 0x1677a = "VERR_VMX_IN_VMX_ROOT_MODE" */
    '\x01','V','M','X','_','I','N','_','V','M','X','_','R','O','O','T','_','M','O','D','E',
/* 0x1678f = "Unexpected guest mapping conflict detected." */
    '\x85','\xa1','\xe0','c','o','n','f','l','i','c','t',' ','d','e','t','e','c','t','e','d','.',
/* 0x167a4 = "VERR_DBGC_PARSE_UNEXPECTED_OPERATOR" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xce','O','P','E','R','A','T','O','R',
/* 0x167b9 = "VERR_SUPDRV_KERNEL_TOO_OLD_FOR_VTX" */
    '\x01','\xdc','K','E','R','N','E','L','_','\x9f','O','L','D','_','F','O','R','_','V','T','X',
/* 0x167ce = "VERR_PGM_PHYS_PAGE_BALLOONED" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','B','A','L','L','O','O','N','E','D',
/* 0x167e3 = "VERR_NET_HOST_UNREACHABLE" */
    '\x01','N','E','T','_','H','O','S','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x167f8 = "VWRN_DBGC_CMD_PENDING" */
    'V','W','R','N','_','D','B','G','C','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x1680d = "VERR_VFS_CHAIN_LEADING_SEPARATOR" */
    '\x01','\xa4','_','\xda','L','E','A','D','I','N','G','_','S','E','P','A','R','A','T','O','R',
/* 0x16822 = "VERR_ISOFS_TOO_DEEP_ICB_RECURSION" */
    '\x01','\xfd','\x9f','D','E','E','P','_','I','C','B','_','R','E','C','U','R','S','I','O','N',
/* 0x16837 = "VERR_DBGF_READ_ONLY_REGISTER" */
    '\x01','\xf1','_','R','E','A','D','_','O','N','L','Y','_','R','E','G','I','S','T','E','R',
/* 0x1684c = "VERR_IOSMK_IMPORT_SUP_VOL_DESC_VER" */
    '\x01','I','O','S','M','K','_','\xd4','\xe6','V','O','L','_','D','E','S','C','_','V','E','R',
/* 0x16861 = "VERR_PGM_PHYS_TLB_UNASSIGNED" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','U','N','A','S','S','I','G','N','E','D',
/* 0x16876 = "VERR_AUDIO_BACKEND_INIT_FAILED" */
    '\x01','A','U','D','I','O','_','B','A','C','K','E','N','D','_','I','N','I','T','_','\x93',
/* 0x1688b = "VERR_GIM_INVALID_HYPERCALL_INSTR" */
    '\x01','G','I','M','_','\x0f','H','Y','P','E','R','C','A','L','L','_','I','N','S','T','R',
/* 0x168a0 = "VERR_UDP_SERVER_DESTROYED" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x168b5 = "Incorrect call order." */
    'I','n','c','o','r','r','e','c','t',' ','c','a','l','l',' ','o','r','d','e','r','.',
/* 0x168ca = "VERR_SUP_VP_BAD_OPTIONAL_HEADER" */
    '\x01','\xe6','V','P','_','\xa0','O','P','T','I','O','N','A','L','_','H','E','A','D','E','R',
/* 0x168df = "Recompiler: Bad segment register number for memory access." */
    '\x11','\x92','s','e','g','m','e','n','t',' ','\xbc','\xdd','\x0e','\x5c','a','c','c','e','s','s','.',
/* 0x168f4 = "Device i/o: Sector not found." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','S','e','c','t','o','r',' ','\x05','\x7d',
/* 0x16909 = "VINF_DRIVER_REBOOT_NEEDED" */
    '\x19','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x1691e = "Shadow mode \'none\' internal error." */
    'S','h','a','d','o','w',' ','m','o','d','e',' ','\'','n','o','n','e','\'',' ','\x15','\x7b',
/* 0x16933 = "VERR_SSM_INTEGRITY_FOOTER" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','F','O','O','T','E','R',
/* 0x16948 = "VERR_SUP_VP_TOO_HIGH_REGION_RVA" */
    '\x01','\xe6','V','P','_','\x9f','H','I','G','H','_','R','E','G','I','O','N','_','R','V','A',
/* 0x1695d = "VERR_VFS_CHAIN_TAKES_FILE_OR_IOS" */
    '\x01','\xa4','_','\xda','T','A','K','E','S','_','F','I','L','E','_','O','R','_','I','O','S',
/* 0x16972 = "Address translation failed." */
    'A','d','d','r','e','s','s',' ','t','r','a','n','s','l','a','t','i','o','n',' ','\x24',
/* 0x16987 = "VERR_TAR_NUM_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','N','U','M','_','V','A','L','U','E','_','\x9f','L','A','R','G','E',
/* 0x1699c = "VERR_LDRVI_INVALID_SECTION_COUNT" */
    '\x01','L','D','R','V','I','_','\x0f','S','E','C','T','I','O','N','_','C','O','U','N','T',
/* 0x169b1 = "VERR_XAR_EXTRACTED_HASH_MISMATCH" */
    '\x01','X','A','R','_','E','X','T','R','A','C','T','E','D','_','H','A','S','H','_','\x99',
/* 0x169c6 = "VWRN_OUT_OF_RESOURCES" */
    'V','W','R','N','_','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x169db = "VERR_CR_PKCS7_NO_CERTIFICATES" */
    '\x01','\xa9','P','K','C','S','7','_','\xb7','C','E','R','T','I','F','I','C','A','T','E','S',
/* 0x169f0 = "VERR_IOM_NO_R3_IOPORT_RANGE" */
    '\x01','I','O','M','_','\xb7','R','3','_','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x16a05 = "Final OpenSSL PKIX verification failed." */
    'F','i','n','a','l',' ','O','p','e','n','S','S','L',' ','P','K','I','X',' ','\xd5','\x24',
/* 0x16a1a = "VERR_HARDAVL_NODE_IS_FREE" */
    '\x01','H','A','R','D','A','V','L','_','N','O','D','E','_','I','S','_','F','R','E','E',
/* 0x16a2f = "VERR_VD_PARALLELS_INVALID_HEADER" */
    '\x01','V','D','_','P','A','R','A','L','L','E','L','S','_','\x0f','H','E','A','D','E','R',
/* 0x16a44 = "Process Verification Failure: Error closing image file handle." */
    '\x17','\x0c','\x12','\xac','c','l','o','s','i','n','g',' ','\x1a','\x18','h','a','n','d','l','e','.',
/* 0x16a59 = "A page count is out of range." */
    'A',' ','\xb6','c','o','u','n','t',' ','\x09','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x16a6e = "VERR_IOM_MMIO_REGION_NOT_MAPPED" */
    '\x01','I','O','M','_','\xf4','_','R','E','G','I','O','N','_','\x14','M','A','P','P','E','D',
/* 0x16a83 = "VERR_RECORDING_ENCODING_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','E','N','C','O','D','I','N','G','_','\x93',
/* 0x16a98 = "VERR_LDR_ADDRESS_OVERFLOW" */
    '\x01','L','D','R','_','A','D','D','R','E','S','S','_','O','V','E','R','F','L','O','W',
/* 0x16aad = "Reason for leaving RZ: I/O port read." */
    '\x84','\x0e','\x25','R','Z',':',' ','I','/','O',' ','p','o','r','t',' ','r','e','a','d','.',
/* 0x16ac2 = "VERR_CR_X509_NAME_EMPTY_SET" */
    '\x01','\xa9','X','5','0','9','_','N','A','M','E','_','E','M','P','T','Y','_','S','E','T',
/* 0x16ad7 = "Duplicate certificate extension." */
    'D','u','p','l','i','c','a','t','e',' ','\x8a','e','x','t','e','n','s','i','o','n','.',
/* 0x16aec = "VERR_LDRLX_BAD_FIXUP_SECTION" */
    '\x01','L','D','R','L','X','_','\xa0','F','I','X','U','P','_','S','E','C','T','I','O','N',
/* 0x16b01 = "VERR_HTTP_COULDNT_CONNECT" */
    '\x01','H','T','T','P','_','C','O','U','L','D','N','T','_','C','O','N','N','E','C','T',
/* 0x16b16 = "Reason for leaving RZ: Unknown call to ring-3." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xdf','c','a','l','l',' ','\x08','r','i','n','g','-','3','.',
/* 0x16b2b = "VERR_SYS_CANNOT_POWER_OFF" */
    '\x01','S','Y','S','_','C','A','N','N','O','T','_','P','O','W','E','R','_','O','F','F',
/* 0x16b40 = "RTCache: cache is full." */
    'R','T','C','a','c','h','e',':',' ','c','a','c','h','e',' ','\x09','f','u','l','l','.',
/* 0x16b55 = "The signature is negative." */
    '\x03','s','i','g','n','a','t','u','r','e',' ','\x09','n','e','g','a','t','i','v','e','.',
/* 0x16b6a = "VERR_ISOFS_UNSUPPORTED_LOGICAL_BLOCK_SIZE" */
    '\x01','\xfd','\x9d','L','O','G','I','C','A','L','_','B','L','O','C','K','_','S','I','Z','E',
/* 0x16b7f = "One of the structure magics was wrong." */
    'O','n','e',' ','\x13','\x02','\xc1','m','a','g','i','c','s',' ','\x10','w','r','o','n','g','.',
/* 0x16b94 = "VERR_FTP_DATA_CONN_INIT_FAILED" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','I','N','I','T','_','\x93',
/* 0x16ba9 = "VERR_PGM_MAPPINGS_FIX_TOO_SMALL" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','_','\x9f','S','M','A','L','L',
/* 0x16bbe = "VERR_LDRELF_RELOCATION_NOT_SUPPORTED" */
    '\x01','L','D','R','E','L','F','_','R','E','L','O','C','A','T','I','O','N','_','\x14','\xc5',
/* 0x16bd3 = "VERR_IOM_MMIO_REGION_ALREADY_MAPPED" */
    '\x01','I','O','M','_','\xf4','_','R','E','G','I','O','N','_','\xed','M','A','P','P','E','D',
/* 0x16be8 = "VERR_VFS_CHAIN_AT_LEAST_SIX_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','L','E','A','S','T','_','S','I','X','_','A','R','G','S',
/* 0x16bfd = "VERR_IEM_COND_TOO_DEEPLY_NESTED" */
    '\x01','\xee','C','O','N','D','_','\x9f','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x16c12 = "Reason for leaving RZ: Timer pending." */
    '\x84','\x0e','\x25','R','Z',':',' ','T','i','m','e','r',' ','p','e','n','d','i','n','g','.',
/* 0x16c27 = "VWRN_PATCH_END_BRANCH" */
    'V','W','R','N','_','P','A','T','C','H','_','E','N','D','_','B','R','A','N','C','H',
/* 0x16c3c = "VINF_PATM_HC_MMIO_PATCH_READ" */
    '\x19','P','A','T','M','_','H','C','_','\xf4','_','P','A','T','C','H','_','R','E','A','D',
/* 0x16c51 = "VERR_HARDAVL_LOOKUP_TOO_DEEP" */
    '\x01','H','A','R','D','A','V','L','_','L','O','O','K','U','P','_','\x9f','D','E','E','P',
/* 0x16c66 = "VERR_ISOFS_TOO_BIT_PARTMAP_IN_LVD" */
    '\x01','\xfd','\x9f','B','I','T','_','P','A','R','T','M','A','P','_','I','N','_','L','V','D',
/* 0x16c7b = "VERR_VFS_CHAIN_AT_MOST_FIVE_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','M','O','S','T','_','F','I','V','E','_','A','R','G','S',
/* 0x16c90 = "Invalid ASN.1 NULL encoding." */
    '\x0b','A','S','N','.','1',' ','N','U','L','L',' ','e','n','c','o','d','i','n','g','.',
/* 0x16ca5 = "VERR_SSM_VIRTUAL_CLOCK_HZ" */
    '\x01','S','S','M','_','V','I','R','T','U','A','L','_','C','L','O','C','K','_','H','Z',
/* 0x16cba = "VERR_IEM_FIXUP_OUT_OF_MEMORY" */
    '\x01','\xee','F','I','X','U','P','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x16ccf = "VERR_DRIVER_REBOOT_NEEDED" */
    '\x01','D','R','I','V','E','R','_','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x16ce4 = "VERR_SUPDRV_TRACER_SESSION_BUSY" */
    '\x01','\xdc','T','R','A','C','E','R','_','S','E','S','S','I','O','N','_','B','U','S','Y',
/* 0x16cf9 = "Failed to obtain a pool page." */
    '\x80','\x08','o','b','t','a','i','n',' ','a',' ','p','o','o','l',' ','p','a','g','e','.',
/* 0x16d0e = "VERR_GMM_SHARED_MODULE_NOT_FOUND" */
    '\x01','G','M','M','_','S','H','A','R','E','D','_','M','O','D','U','L','E','_','\x14','\xb3',
/* 0x16d23 = "VERR_VFS_CHAIN_AT_MOST_FOUR_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','M','O','S','T','_','F','O','U','R','_','A','R','G','S',
/* 0x16d38 = "Max threads number reached." */
    'M','a','x',' ','t','h','r','e','a','d','s',' ','\xdd','r','e','a','c','h','e','d','.',
/* 0x16d4d = "VERR_PGM_SAVED_MMIO2_PAGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','M','M','I','O','2','_','P','A','G','E','_','\x14','\xb3',
/* 0x16d62 = "VERR_DBG_DUPLICATE_SYMBOL" */
    '\x01','D','B','G','_','D','U','P','L','I','C','A','T','E','_','S','Y','M','B','O','L',
/* 0x16d77 = "Wrong parameter type." */
    'W','r','o','n','g',' ','p','a','r','a','m','e','t','e','r',' ','t','y','p','e','.',
/* 0x16d8c = "VERR_VD_READ_OUT_OF_RANGE" */
    '\x01','V','D','_','R','E','A','D','_','O','U','T','_','O','F','_','R','A','N','G','E',
/* 0x16da1 = "VINF_CPUM_MATCHED_BY_NAME" */
    '\x19','C','P','U','M','_','M','A','T','C','H','E','D','_','B','Y','_','N','A','M','E',
/* 0x16db6 = "VERR_GIM_PVTSC_NOT_AVAILABLE" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x14','A','V','A','I','L','A','B','L','E',
/* 0x16dcb = "VERR_LDRPE_GUARD_CF_STUFF" */
    '\x01','L','D','R','P','E','_','G','U','A','R','D','_','C','F','_','S','T','U','F','F',
/* 0x16de0 = "The thread is terminating." */
    '\x03','t','h','r','e','a','d',' ','\x09','t','e','r','m','i','n','a','t','i','n','g','.',
/* 0x16df5 = "VWRN_DBGC_ALREADY_REGISTERED" */
    'V','W','R','N','_','D','B','G','C','_','\xed','R','E','G','I','S','T','E','R','E','D',
/* 0x16e0a = "VERR_LDRPE_CERT_MALFORMED" */
    '\x01','L','D','R','P','E','_','C','E','R','T','_','M','A','L','F','O','R','M','E','D',
/* 0x16e1f = "VERR_RECORDING_RESTRICTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','R','E','S','T','R','I','C','T','E','D',
/* 0x16e34 = "Syntax error - expected binary operator." */
    '\xe1','\x07','-',' ','\xae','b','i','n','a','r','y',' ','o','p','e','r','a','t','o','r','.',
/* 0x16e49 = "VERR_SSM_LIVE_POWERED_OFF" */
    '\x01','S','S','M','_','L','I','V','E','_','P','O','W','E','R','E','D','_','O','F','F',
/* 0x16e5e = "VERR_FILE_AIO_IN_PROGRESS" */
    '\x01','F','I','L','E','_','A','I','O','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x16e73 = "VERR_SUP_VP_IMAGE_HDR_READ_ERROR" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','H','D','R','_','R','E','A','D','_','\x9b',
/* 0x16e88 = "Operation already in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x22','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x16e9d = "The compressed table of content is too big." */
    '\x03','c','o','m','p','r','e','s','s','e','d',' ','\x9e','\x13','\xd8','\x09','\x8c','b','i','g','.',
/* 0x16eb2 = "Image Verification Failure: Error reading image headers." */
    '\xfe','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x1a','h','e','a','d','e','r','s','.',
/* 0x16ec7 = "VERR_IEM_LABEL_OUT_OF_MEMORY" */
    '\x01','\xee','L','A','B','E','L','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x16edc = "VINF_HGCM_CLIENT_REJECTED" */
    '\x19','H','G','C','M','_','C','L','I','E','N','T','_','R','E','J','E','C','T','E','D',
/* 0x16ef1 = "Page hash table size overflow." */
    'P','a','g','e',' ','h','a','s','h',' ','\x9e','\xf8','o','v','e','r','f','l','o','w','.',
/* 0x16f06 = "VERR_VMX_MSR_VMX_DISABLED" */
    '\x01','V','M','X','_','M','S','R','_','V','M','X','_','D','I','S','A','B','L','E','D',
/* 0x16f1b = "VERR_SUP_VP_MEMORY_VS_FILE_MISMATCH" */
    '\x01','\xe6','V','P','_','M','E','M','O','R','Y','_','V','S','_','F','I','L','E','_','\x99',
/* 0x16f30 = "VERR_CODE_POINT_SURROGATE" */
    '\x01','C','O','D','E','_','P','O','I','N','T','_','S','U','R','R','O','G','A','T','E',
/* 0x16f45 = "VERR_GETOPT_INDEX_MISSING" */
    '\x01','G','E','T','O','P','T','_','I','N','D','E','X','_','M','I','S','S','I','N','G',
/* 0x16f5a = "VERR_SUPDRV_APIPORT_OPEN_ERROR_TYPE" */
    '\x01','\xdc','A','P','I','P','O','R','T','_','O','P','E','N','_','\x9b','_','T','Y','P','E',
/* 0x16f6f = "Saved state directory wintertides error." */
    'S','a','v','e','d',' ','\xb0','\x1b','w','i','n','t','e','r','t','i','d','e','s',' ','\x7b',
/* 0x16f84 = "VERR_MANIFEST_ATTR_TYPE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','T','Y','P','E','_','\x99',
/* 0x16f99 = "VERR_LDRPE_COM_DESCRIPTOR" */
    '\x01','L','D','R','P','E','_','C','O','M','_','D','E','S','C','R','I','P','T','O','R',
/* 0x16fae = "No direct ICB entries found." */
    '\xd0','d','i','r','e','c','t',' ','I','C','B',' ','e','n','t','r','i','e','s',' ','\x7d',
/* 0x16fc3 = "VFS chain doesn't end with a path only element." */
    '\xa4',' ','\x91','\xa5','e','n','d',' ','\x1e','a',' ','\xbb','\xf7','e','l','e','m','e','n','t','.',
/* 0x16fd8 = "VERR_DWARF_STACK_OVERFLOW" */
    '\x01','D','W','A','R','F','_','S','T','A','C','K','_','O','V','E','R','F','L','O','W',
/* 0x16fed = "VINF_VD_ASYNC_IO_FINISHED" */
    '\x19','V','D','_','A','S','Y','N','C','_','I','O','_','F','I','N','I','S','H','E','D',
/* 0x17002 = "Generic audio device enumeration error." */
    '\x96','a','u','d','i','o',' ','\x8b','e','n','u','m','e','r','a','t','i','o','n',' ','\x7b',
/* 0x17017 = "VERR_TAR_DEV_VALUE_TOO_LARGE" */
    '\x01','T','A','R','_','D','E','V','_','V','A','L','U','E','_','\x9f','L','A','R','G','E',
/* 0x1702c = "VERR_VD_CACHE_NOT_UP_TO_DATE" */
    '\x01','V','D','_','C','A','C','H','E','_','\x14','U','P','_','T','O','_','D','A','T','E',
/* 0x17041 = "VERR_PDM_ASYNC_TEMPLATE_BUSY" */
    '\x01','\xb8','A','S','Y','N','C','_','T','E','M','P','L','A','T','E','_','B','U','S','Y',
/* 0x17056 = "VERR_TCP_SERVER_DESTROYED" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','D','E','S','T','R','O','Y','E','D',
/* 0x1706b = "VERR_SUP_VP_KERNEL32_ALREADY_MAPPED" */
    '\x01','\xe6','V','P','_','K','E','R','N','E','L','3','2','_','\xed','M','A','P','P','E','D',
/* 0x17080 = "Internal SPC error: The PE image data is missing." */
    '\x06','S','P','C',' ','\xc3','\x03','P','E',' ','\x1a','\x8f','\x09','m','i','s','s','i','n','g','.',
/* 0x17095 = "Network is unreachable." */
    'N','e','t','w','o','r','k',' ','\x09','u','n','r','e','a','c','h','a','b','l','e','.',
/* 0x170aa = "VINF_EM_RAW_TIMER_PENDING" */
    '\x19','E','M','_','R','A','W','_','T','I','M','E','R','_','P','E','N','D','I','N','G',
/* 0x170bf = "VERR_IEM_RESTART_INSTRUCTION" */
    '\x01','\xee','R','E','S','T','A','R','T','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x170d4 = "VFS chain element expected at least three arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','l','e','a','s','t',' ','t','h','r','e','e',' ','\xc8',
/* 0x170e9 = "VERR_PATH_MATCH_UNKNOWN_VARIABLE" */
    '\x01','P','A','T','H','_','M','A','T','C','H','_','\xde','V','A','R','I','A','B','L','E',
/* 0x170fe = "Expected a right parentheses." */
    '\xa6','a',' ','r','i','g','h','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x17113 = "VERR_CR_PKCS7_OSSL_VERIFY_FAILED" */
    '\x01','\xa9','P','K','C','S','7','_','O','S','S','L','_','V','E','R','I','F','Y','_','\x93',
/* 0x17128 = "Current object state prohibits operation." */
    'C','u','r','r','e','n','t',' ','\x8d','\xb0','p','r','o','h','i','b','i','t','s',' ','\xcc',
/* 0x1713d = "VERR_DBG_ADDRESS_CONFLICT" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x17152 = "The register is read-only and cannot be modified." */
    '\x03','\xbc','\x09','r','e','a','d','-','\xf7','\x2a','\xcb','\x90','m','o','d','i','f','i','e','d','.',
/* 0x17167 = "VERR_SUP_VP_BAD_IMAGE_SIGNATURE" */
    '\x01','\xe6','V','P','_','\xa0','I','M','A','G','E','_','S','I','G','N','A','T','U','R','E',
/* 0x1717c = "VERR_PGM_SAVED_ROM_PAGE_PROT" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','P','A','G','E','_','P','R','O','T',
/* 0x17191 = "The file or directory is world writable (hardening)." */
    '\x03','\x18','\x86','\x1b','\x09','w','o','r','l','d',' ','w','r','i','t','a','b','l','e',' ','\x9a',
/* 0x171a6 = "VERR_CR_PKCS7_NO_SIGNER_INFOS" */
    '\x01','\xa9','P','K','C','S','7','_','\xb7','S','I','G','N','E','R','_','I','N','F','O','S',
/* 0x171bb = "VINF_PARAV_SWITCH_TO_HOST" */
    '\x19','P','A','R','A','V','_','S','W','I','T','C','H','_','T','O','_','H','O','S','T',
/* 0x171d0 = "VERR_WRONG_PARAMETER_TYPE" */
    '\x01','W','R','O','N','G','_','P','A','R','A','M','E','T','E','R','_','T','Y','P','E',
/* 0x171e5 = "VERR_GMM_ACTUAL_PAGES_IPE" */
    '\x01','G','M','M','_','A','C','T','U','A','L','_','P','A','G','E','S','_','I','P','E',
/* 0x171fa = "VERR_SUP_VP_BAD_SIZE_OF_HEADERS" */
    '\x01','\xe6','V','P','_','\xa0','S','I','Z','E','_','O','F','_','H','E','A','D','E','R','S',
/* 0x1720f = "Geometry hasn\'t been set." */
    'G','e','o','m','e','t','r','y',' ','h','a','s','n','\'','t',' ','\xad','s','e','t','.',
/* 0x17224 = "VERR_SVM_ILLEGAL_EFER_MSR" */
    '\x01','S','V','M','_','I','L','L','E','G','A','L','_','E','F','E','R','_','M','S','R',
/* 0x17239 = "VERR_GMM_HIT_GLOBAL_LIMIT" */
    '\x01','G','M','M','_','H','I','T','_','G','L','O','B','A','L','_','L','I','M','I','T',
/* 0x1724e = "VERR_VD_DMG_NOT_FOUND_INSIDE_XAR" */
    '\x01','V','D','_','D','M','G','_','\x14','\xb3','_','I','N','S','I','D','E','_','X','A','R',
/* 0x17263 = "Unable to switch due to invalid host state." */
    '\xca','\x08','s','w','i','t','c','h',' ','d','u','e',' ','\x08','\x81','h','o','s','t',' ','\xf5',
/* 0x17278 = "VERR_VFS_CHAIN_TOO_SHORT_FOR_PARENT" */
    '\x01','\xa4','_','\xda','\x9f','S','H','O','R','T','_','F','O','R','_','P','A','R','E','N','T',
/* 0x1728d = "VERR_LDRELF_INVALID_SYMBOL_INDEX" */
    '\x01','L','D','R','E','L','F','_','\x0f','S','Y','M','B','O','L','_','I','N','D','E','X',
/* 0x172a2 = "VERR_VRDP_SEC_ENGINE_FAIL" */
    '\x01','V','R','D','P','_','S','E','C','_','E','N','G','I','N','E','_','F','A','I','L',
/* 0x172b7 = "Bad timestamp for XAR file." */
    '\x92','t','i','m','e','s','t','a','m','p',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x172cc = "VERR_PGM_PHYS_RAM_LOOKUP_IPE" */
    '\x01','\xd7','P','H','Y','S','_','R','A','M','_','L','O','O','K','U','P','_','I','P','E',
/* 0x172e1 = "VERR_SERIALPORT_INVALID_BAUDRATE" */
    '\x01','S','E','R','I','A','L','P','O','R','T','_','\x0f','B','A','U','D','R','A','T','E',
/* 0x172f6 = "VERR_ISOFS_NO_DIRECT_ICB_ENTRIES" */
    '\x01','\xfd','\xb7','D','I','R','E','C','T','_','I','C','B','_','E','N','T','R','I','E','S',
/* 0x1730b = "VERR_VFS_CHAIN_AT_LEAST_TWO_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','L','E','A','S','T','_','T','W','O','_','A','R','G','S',
/* 0x17320 = "Bad file group id for XAR file." */
    '\x92','\x18','g','r','o','u','p',' ','i','d',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x17335 = "HM returned in the wrong state." */
    'H','M',' ','r','e','t','u','r','n','e','d',' ','\x0d','\x02','w','r','o','n','g',' ','\xf5',
/* 0x1734a = "VERR_EM_CANNOT_EXEC_GUEST" */
    '\x01','E','M','_','C','A','N','N','O','T','_','E','X','E','C','_','G','U','E','S','T',
/* 0x1735f = "VERR_SSM_INTEGRITY_HEADER" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','H','E','A','D','E','R',
/* 0x17374 = "Internal ISO maker error: Empty path." */
    '\x06','\xb2',' ','m','a','k','e','r',' ','\xc3','E','m','p','t','y',' ','p','a','t','h','.',
/* 0x17389 = "VERR_ISOMK_IMPORT_ROOT_VOLUME_SEQ_NO" */
    '\x01','\xaa','\xd4','R','O','O','T','_','V','O','L','U','M','E','_','S','E','Q','_','N','O',
/* 0x1739e = "VERR_ASN1_INVALID_BITSTRING_ENCODING" */
    '\x01','\xf2','\x0f','B','I','T','S','T','R','I','N','G','_','E','N','C','O','D','I','N','G',
/* 0x173b3 = "Device i/o: Bad command." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','c','o','m','m','a','n','d','.',
/* 0x173c8 = "No free output streams." */
    '\xd0','f','r','e','e',' ','o','u','t','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x173dd = "VINF_PGM_NO_DIRTY_BIT_TRACKING" */
    '\x19','\xd7','\xb7','D','I','R','T','Y','_','B','I','T','_','T','R','A','C','K','I','N','G',
/* 0x173f2 = "VERR_PGM_NO_HYPERVISOR_ADDRESS" */
    '\x01','\xd7','\xb7','H','Y','P','E','R','V','I','S','O','R','_','A','D','D','R','E','S','S',
/* 0x17407 = "VERR_IEM_ASPECT_NOT_IMPLEMENTED" */
    '\x01','\xee','A','S','P','E','C','T','_','\x14','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1741c = "Object or array is empty." */
    'O','b','j','e','c','t',' ','\x86','a','r','r','a','y',' ','\x09','e','m','p','t','y','.',
/* 0x17431 = "VWRN_DANGLING_OBJECTS" */
    'V','W','R','N','_','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x17446 = "VERR_NET_TOO_MANY_REFERENCES" */
    '\x01','N','E','T','_','\x9f','M','A','N','Y','_','R','E','F','E','R','E','N','C','E','S',
/* 0x1745b = "VERR_VD_VDI_COMMENT_TOO_LONG" */
    '\x01','V','D','_','V','D','I','_','C','O','M','M','E','N','T','_','\x9f','L','O','N','G',
/* 0x17470 = "Certificate signature algorithm mismatch." */
    '\xa7','s','i','g','n','a','t','u','r','e',' ','\xbe','m','i','s','m','a','t','c','h','.',
/* 0x17485 = "VERR_ISOFS_BAD_LVD_DESC_CHAR_SET" */
    '\x01','\xfd','\xa0','L','V','D','_','D','E','S','C','_','C','H','A','R','_','S','E','T',
/* 0x17499 = "The bucket/key wasn\'t found." */
    '\x03','b','u','c','k','e','t','/','k','e','y',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x174ad = "VERR_VFS_CHAIN_TYPE_MISMATCH_PATH_ONLY" */
    '\x01','\xa4','_','\xda','T','Y','P','E','_','\x99','_','P','A','T','H','_','O','N','L','Y',
/* 0x174c1 = "VERR_SUPLIB_TEXT_NOT_SEALED" */
    '\x01','S','U','P','L','I','B','_','T','E','X','T','_','\x14','S','E','A','L','E','D',
/* 0x174d5 = "No free input streams." */
    '\xd0','f','r','e','e',' ','i','n','p','u','t',' ','s','t','r','e','a','m','s','.',
/* 0x174e9 = "VERR_VFS_CHAIN_AT_MOST_TWO_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','M','O','S','T','_','T','W','O','_','A','R','G','S',
/* 0x174fd = "VERR_XAR_BAD_FILE_TIMESTAMP" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','T','I','M','E','S','T','A','M','P',
/* 0x17511 = "VERR_LDRMACHO_UNSUPPORTED_FILE_TYPE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','F','I','L','E','_','T','Y','P','E',
/* 0x17525 = "Internal processing error #5 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','5',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17539 = "VERR_ASN1_INVALID_UTC_TIME_ENCODING" */
    '\x01','\xf2','\x0f','U','T','C','_','T','I','M','E','_','E','N','C','O','D','I','N','G',
/* 0x1754d = "VERR_PGM_PHYS_TLB_CATCH_ALL" */
    '\x01','\xd7','P','H','Y','S','_','T','L','B','_','C','A','T','C','H','_','A','L','L',
/* 0x17561 = "VERR_DBG_SPECIAL_SEGMENT" */
    '\x01','D','B','G','_','S','P','E','C','I','A','L','_','S','E','G','M','E','N','T',
/* 0x17575 = "Operation in progress." */
    'O','p','e','r','a','t','i','o','n',' ','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x17589 = "VERR_FILE_AIO_NOT_SUBMITTED" */
    '\x01','F','I','L','E','_','A','I','O','_','\x14','S','U','B','M','I','T','T','E','D',
/* 0x1759d = "VERR_FAM_CONNECTION_LOST" */
    '\x01','F','A','M','_','C','O','N','N','E','C','T','I','O','N','_','L','O','S','T',
/* 0x175b1 = "VERR_DBGC_PARSE_NO_SCRATCH" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb7','S','C','R','A','T','C','H',
/* 0x175c5 = "VERR_CR_X509_NO_TRUST_ANCHOR" */
    '\x01','\xa9','X','5','0','9','_','\xb7','T','R','U','S','T','_','A','N','C','H','O','R',
/* 0x175d9 = "VERR_HGCM_SERVICE_EXISTS" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','E','X','I','S','T','S',
/* 0x175ed = "VERR_LDR_GENERAL_FAILURE" */
    '\x01','L','D','R','_','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x17601 = "VINF_PGM_POOL_FLUSH_PENDING" */
    '\x19','\xd7','P','O','O','L','_','F','L','U','S','H','_','P','E','N','D','I','N','G',
/* 0x17615 = "Internal processing error #1 in the PDM Thread code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x5e',
/* 0x17629 = "VERR_RT_REQUEST_INVALID_PACKAGE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x0f','P','A','C','K','A','G','E',
/* 0x1763d = "VERR_SUPLIB_UNEXPECTED_INSTRUCTION" */
    '\x01','S','U','P','L','I','B','_','\xce','I','N','S','T','R','U','C','T','I','O','N',
/* 0x17651 = "VERR_SUPDRV_VTG_BAD_PROBE_ENABLED" */
    '\x01','\xdc','V','T','G','_','\xa0','P','R','O','B','E','_','E','N','A','B','L','E','D',
/* 0x17665 = "VERR_XAR_BAD_FILE_DEVICE_NO" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','D','E','V','I','C','E','_','N','O',
/* 0x17679 = "Spinlock detection failed." */
    'S','p','i','n','l','o','c','k',' ','d','e','t','e','c','t','i','o','n',' ','\x24',
/* 0x1768d = "VERR_ISOMK_IPE_PRODUCE_TRANS_TBL" */
    '\x01','\xaa','\x8e','P','R','O','D','U','C','E','_','T','R','A','N','S','_','T','B','L',
/* 0x176a1 = "VERR_CPUM_INVALID_HWVIRT_CONFIG" */
    '\x01','C','P','U','M','_','\x0f','H','W','V','I','R','T','_','C','O','N','F','I','G',
/* 0x176b5 = "VERR_SSM_INTEGRITY_MAGIC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','M','A','G','I','C',
/* 0x176c9 = "VERR_FTP_STATUS_SERVER_ERROR" */
    '\x01','F','T','P','_','S','T','A','T','U','S','_','S','E','R','V','E','R','_','\x9b',
/* 0x176dd = "VERR_PAGE_TABLE_NOT_PRESENT" */
    '\x01','P','A','G','E','_','T','A','B','L','E','_','\x14','P','R','E','S','E','N','T',
/* 0x176f1 = "VERR_CR_CIPHER_INVALID_KEY_LENGTH" */
    '\x01','\xa9','C','I','P','H','E','R','_','\x0f','K','E','Y','_','L','E','N','G','T','H',
/* 0x17705 = "VFS chain element expected at least five arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','l','e','a','s','t',' ','f','i','v','e',' ','\xc8',
/* 0x17719 = "VERR_UDP_SERVER_SHUTDOWN" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x1772d = "EVP_DecryptInit_ex failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t','_','e','x',' ','\x24',
/* 0x17741 = "Request was redirected." */
    'R','e','q','u','e','s','t',' ','\x10','r','e','d','i','r','e','c','t','e','d','.',
/* 0x17755 = "VINF_PATCH_EMULATE_INSTR" */
    '\x19','P','A','T','C','H','_','E','M','U','L','A','T','E','_','I','N','S','T','R',
/* 0x17769 = "Unexpected SVM exception exit." */
    '\x85','S','V','M',' ','e','x','c','e','p','t','i','o','n',' ','e','x','i','t','.',
/* 0x1777d = "VERR_TCP_SERVER_SHUTDOWN" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','H','U','T','D','O','W','N',
/* 0x17791 = "VERR_CR_PKCS7_NOT_SIGNED_DATA" */
    '\x01','\xa9','P','K','C','S','7','_','\x14','S','I','G','N','E','D','_','D','A','T','A',
/* 0x177a5 = "Recompiler: Hit instruction buffer size limit." */
    '\x11','H','i','t',' ','\xba','b','u','f','f','e','r',' ','\xf8','l','i','m','i','t','.',
/* 0x177b9 = "VINF_RECORDING_THROTTLED" */
    '\x19','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x177cd = "VERR_GVMM_HOST_CPU_RANGE" */
    '\x01','G','V','M','M','_','H','O','S','T','_','C','P','U','_','R','A','N','G','E',
/* 0x177e1 = "VERR_PROC_APT_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','A','P','T','_','P','R','I','V','_','\x14','H','E','L','D',
/* 0x177f5 = "VERR_SUPLIB_NOT_SAME_OBJECT" */
    '\x01','S','U','P','L','I','B','_','\x14','S','A','M','E','_','O','B','J','E','C','T',
/* 0x17809 = "Internal processing error #1 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x1781d = "The specified thread is not waitable." */
    '\x03','\x16','t','h','r','e','a','d',' ','\x09','\x05','w','a','i','t','a','b','l','e','.',
/* 0x17831 = "Internal processing error #7 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','7',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17845 = "VERR_XAR_HASH_FUNCTION_MISMATCH" */
    '\x01','X','A','R','_','H','A','S','H','_','F','U','N','C','T','I','O','N','_','\x99',
/* 0x17859 = "VERR_XAR_BAD_OFFSET_ELEMENT" */
    '\x01','X','A','R','_','\xa0','O','F','F','S','E','T','_','E','L','E','M','E','N','T',
/* 0x1786d = "NEM failed to set registers." */
    'N','E','M',' ','\x88','\x08','s','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x17881 = "VERR_LDRVI_NO_MEMORY_SHDRS" */
    '\x01','L','D','R','V','I','_','\xb7','M','E','M','O','R','Y','_','S','H','D','R','S',
/* 0x17895 = "Internal processing error #4 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','4',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x178a9 = "Recompiler: Unimplemented case." */
    '\x11','U','n','i','m','p','l','e','m','e','n','t','e','d',' ','c','a','s','e','.',
/* 0x178bd = "VERR_VUSB_DEVICE_NAME_NOT_FOUND" */
    '\x01','V','U','S','B','_','D','E','V','I','C','E','_','N','A','M','E','_','\x14','\xb3',
/* 0x178d1 = "VERR_SUPLIB_IS_DIRECTORY" */
    '\x01','S','U','P','L','I','B','_','I','S','_','D','I','R','E','C','T','O','R','Y',
/* 0x178e5 = "VERR_VFS_CHAIN_EXPECTED_ELEMENT" */
    '\x01','\xa4','_','\xda','E','X','P','E','C','T','E','D','_','E','L','E','M','E','N','T',
/* 0x178f9 = "The object in question already exists." */
    '\x03','\x8d','\x0d','q','u','e','s','t','i','o','n',' ','\x22','e','x','i','s','t','s','.',
/* 0x1790d = "VERR_VFS_CHAIN_AT_MOST_SIX_ARGS" */
    '\x01','\xa4','_','\xda','A','T','_','M','O','S','T','_','S','I','X','_','A','R','G','S',
/* 0x17921 = "Cipher algorithm is not known to us." */
    'C','i','p','h','e','r',' ','\xbe','\x09','\x05','k','n','o','w','n',' ','\x08','u','s','.',
/* 0x17935 = "Process Verification Failure: Image section region is too large." */
    '\x17','\x0c','\x12','\xfe','\xc6','r','e','g','i','o','n',' ','\x09','\x8c','l','a','r','g','e','.',
/* 0x17949 = "VERR_LDRLX_BAD_OBJECT_TABLE" */
    '\x01','L','D','R','L','X','_','\xa0','O','B','J','E','C','T','_','T','A','B','L','E',
/* 0x1795d = "VERR_FILE_LOCK_VIOLATION" */
    '\x01','F','I','L','E','_','L','O','C','K','_','V','I','O','L','A','T','I','O','N',
/* 0x17971 = "VERR_PDM_DEVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\xb8','D','E','V','I','N','S','_','\xde','C','F','G','_','V','A','L','U','E','S',
/* 0x17985 = "Unsupported ISO protocol feature." */
    '\x87','\xb2',' ','p','r','o','t','o','c','o','l',' ','f','e','a','t','u','r','e','.',
/* 0x17999 = "VERR_SUP_VP_NOT_BUILD_CERT_IPE" */
    '\x01','\xe6','V','P','_','\x14','B','U','I','L','D','_','C','E','R','T','_','I','P','E',
/* 0x179ad = "VINF_IOM_R3_MMIO_READ_WRITE" */
    '\x19','I','O','M','_','R','3','_','\xf4','_','R','E','A','D','_','W','R','I','T','E',
/* 0x179c1 = "Unable to start VM execution." */
    '\xca','\x08','s','t','a','r','t',' ','\xcf',' ','e','x','e','c','u','t','i','o','n','.',
/* 0x179d5 = "VERR_PDM_DRVINS_UNKNOWN_CFG_VALUES" */
    '\x01','\xb8','D','R','V','I','N','S','_','\xde','C','F','G','_','V','A','L','U','E','S',
/* 0x179e9 = "VERR_VFS_CHAIN_AT_LEAST_ONE_ARG" */
    '\x01','\xa4','_','\xda','A','T','_','L','E','A','S','T','_','O','N','E','_','A','R','G',
/* 0x179fd = "VERR_VD_NOT_ENOUGH_METADATA" */
    '\x01','V','D','_','\x14','E','N','O','U','G','H','_','M','E','T','A','D','A','T','A',
/* 0x17a11 = "VWRN_FLOAT_UNDERFLOW" */
    'V','W','R','N','_','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x17a25 = "VERR_SUP_VP_SECTION_NOT_MAPPED" */
    '\x01','\xe6','V','P','_','S','E','C','T','I','O','N','_','\x14','M','A','P','P','E','D',
/* 0x17a39 = "URL not expected in SPC PE image data." */
    'U','R','L',' ','\x05','\xae','\x0d','S','P','C',' ','P','E',' ','\x1a','d','a','t','a','.',
/* 0x17a4d = "VERR_RECORDING_FORMAT_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','F','O','R','M','A','T','_','\x14','\xc5',
/* 0x17a61 = "VERR_PGM_SAVED_ROM_RANGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','R','A','N','G','E','_','\x14','\xb3',
/* 0x17a75 = "Internal processing error #8 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','8',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17a89 = "VERR_PDM_MEDIAEX_IOREQID_NOT_FOUND" */
    '\x01','\xb8','M','E','D','I','A','E','X','_','I','O','R','E','Q','I','D','_','\x14','\xb3',
/* 0x17a9d = "VERR_PROC_TCB_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','T','C','B','_','P','R','I','V','_','\x14','H','E','L','D',
/* 0x17ab1 = "Reason for leaving RZ: MMIO read/write." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf4',' ','r','e','a','d','/','w','r','i','t','e','.',
/* 0x17ac5 = "VERR_RECORDING_THROTTLED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','T','H','R','O','T','T','L','E','D',
/* 0x17ad9 = "VINF_VD_NEW_ZEROED_BLOCK" */
    '\x19','V','D','_','N','E','W','_','Z','E','R','O','E','D','_','B','L','O','C','K',
/* 0x17aed = "VINF_PGM_HANDLER_DO_DEFAULT" */
    '\x19','\xd7','H','A','N','D','L','E','R','_','D','O','_','D','E','F','A','U','L','T',
/* 0x17b01 = "VERR_NEM_MISSING_FEATURE" */
    '\x01','N','E','M','_','M','I','S','S','I','N','G','_','F','E','A','T','U','R','E',
/* 0x17b15 = "VINF_IPC_RECEIVE_MSG_CUT" */
    '\x19','I','P','C','_','R','E','C','E','I','V','E','_','M','S','G','_','C','U','T',
/* 0x17b29 = "VERR_PCI_PASSTHROUGH_NO_HM" */
    '\x01','P','C','I','_','P','A','S','S','T','H','R','O','U','G','H','_','\xb7','H','M',
/* 0x17b3d = "VERR_PGM_PHYS_PAGE_RESERVED" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','R','E','S','E','R','V','E','D',
/* 0x17b51 = "VERR_IPC_RECEIVE_TIMEOUT" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','T','I','M','E','O','U','T',
/* 0x17b65 = "VINF_DBGF_R3_BP_OWNER_DEFER" */
    '\x19','\xf1','_','R','3','_','B','P','_','O','W','N','E','R','_','D','E','F','E','R',
/* 0x17b79 = "VERR_SVM_VMRUN_PRECOND_3" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','3',
/* 0x17b8d = "VERR_SVM_VMRUN_PRECOND_0" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','0',
/* 0x17ba1 = "VERR_COM_DONT_CALL_AGAIN" */
    '\x01','C','O','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x17bb5 = "VERR_SVM_VMRUN_PRECOND_1" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','1',
/* 0x17bc9 = "VERR_SUPDRV_TRACER_NOT_REGISTERED" */
    '\x01','\xdc','T','R','A','C','E','R','_','\x14','R','E','G','I','S','T','E','R','E','D',
/* 0x17bdd = "VERR_LDRVI_FILE_LENGTH_ERROR" */
    '\x01','L','D','R','V','I','_','F','I','L','E','_','L','E','N','G','T','H','_','\x9b',
/* 0x17bf1 = "VERR_SVM_VMRUN_PRECOND_2" */
    '\x01','S','V','M','_','V','M','R','U','N','_','P','R','E','C','O','N','D','_','2',
/* 0x17c05 = "VERR_PDM_DRIVER_INVALID_PROPERTIES" */
    '\x01','\xb8','D','R','I','V','E','R','_','\x0f','P','R','O','P','E','R','T','I','E','S',
/* 0x17c19 = "Reached the end of the file." */
    'R','e','a','c','h','e','d',' ','\x02','e','n','d',' ','\x13','\x02','f','i','l','e','.',
/* 0x17c2d = "VERR_INCOMPATIBLE_CONFIG" */
    '\x01','I','N','C','O','M','P','A','T','I','B','L','E','_','C','O','N','F','I','G',
/* 0x17c41 = "VERR_CR_CIPHER_INVALID_TAG_LENGTH" */
    '\x01','\xa9','C','I','P','H','E','R','_','\x0f','T','A','G','_','L','E','N','G','T','H',
/* 0x17c55 = "VERR_IEM_EMIT_UNEXPECTED_VAR_REGISTER" */
    '\x01','\xee','E','M','I','T','_','\xce','V','A','R','_','R','E','G','I','S','T','E','R',
/* 0x17c69 = "VERR_CR_X509_CPB_BAD_CERT_CTX" */
    '\x01','\xa9','X','5','0','9','_','C','P','B','_','\xa0','C','E','R','T','_','C','T','X',
/* 0x17c7d = "The I/O request ID is already existing." */
    '\x03','I','/','O',' ','\x94','I','D',' ','\x09','\x22','e','x','i','s','t','i','n','g','.',
/* 0x17c91 = "Too long name or link string." */
    '\xf0','l','o','n','g',' ','\xf3','\x86','l','i','n','k',' ','s','t','r','i','n','g','.',
/* 0x17ca5 = "Requested image is not opened." */
    'R','e','q','u','e','s','t','e','d',' ','\x1a','\x09','\x05','o','p','e','n','e','d','.',
/* 0x17cb9 = "VERR_AUDIO_STREAM_NOT_READY" */
    '\x01','A','U','D','I','O','_','S','T','R','E','A','M','_','\x14','R','E','A','D','Y',
/* 0x17ccd = "Internal processing error #2 in the PDM Thread code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','P','D','M',' ','T','h','r','e','a','d',' ','\x5e',
/* 0x17ce1 = "VERR_LDRVI_NO_MEMORY_STATE" */
    '\x01','L','D','R','V','I','_','\xb7','M','E','M','O','R','Y','_','S','T','A','T','E',
/* 0x17cf5 = "VINF_CR_DIGEST_COMPROMISED" */
    '\x19','\xa9','D','I','G','E','S','T','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x17d09 = "No conflicts to resolve." */
    '\xd0','c','o','n','f','l','i','c','t','s',' ','\x08','r','e','s','o','l','v','e','.',
/* 0x17d1d = "VFS chain element expected at most three arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','m','o','s','t',' ','t','h','r','e','e',' ','\xc8',
/* 0x17d31 = "VERR_TAR_BAD_NUM_FIELD_TERM" */
    '\x01','T','A','R','_','\xa0','N','U','M','_','F','I','E','L','D','_','T','E','R','M',
/* 0x17d45 = "VINF_IOM_R3_IOPORT_WRITE" */
    '\x19','I','O','M','_','R','3','_','I','O','P','O','R','T','_','W','R','I','T','E',
/* 0x17d59 = "VERR_XAR_ARCHIVED_HASH_MISMATCH" */
    '\x01','X','A','R','_','A','R','C','H','I','V','E','D','_','H','A','S','H','_','\x99',
/* 0x17d6d = "VERR_NEM_SET_REGISTERS_FAILED" */
    '\x01','N','E','M','_','S','E','T','_','R','E','G','I','S','T','E','R','S','_','\x93',
/* 0x17d81 = "Too many clients for the service." */
    '\xf0','\xa3','c','l','i','e','n','t','s',' ','\x0e','\x02','s','e','r','v','i','c','e','.',
/* 0x17d95 = "VERR_ISOMK_RR_SPILL_FILE_FULL" */
    '\x01','\xaa','R','R','_','S','P','I','L','L','_','F','I','L','E','_','F','U','L','L',
/* 0x17da9 = "Duplicate something." */
    'D','u','p','l','i','c','a','t','e',' ','s','o','m','e','t','h','i','n','g','.',
/* 0x17dbd = "Syntax error - invalid operator usage." */
    '\xe1','\x07','-',' ','\x81','o','p','e','r','a','t','o','r',' ','u','s','a','g','e','.',
/* 0x17dd1 = "VERR_PDM_DRIVER_INSTANCE_NOT_FOUND" */
    '\x01','\xb8','D','R','I','V','E','R','_','I','N','S','T','A','N','C','E','_','\x14','\xb3',
/* 0x17de5 = "VERR_IOM_IOPORTS_ALREADY_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\xed','M','A','P','P','E','D',
/* 0x17df9 = "Internal processing error #9 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','9',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17e0d = "VERR_NS_SYMLINK_SET_TIME" */
    '\x01','N','S','_','S','Y','M','L','I','N','K','_','S','E','T','_','T','I','M','E',
/* 0x17e21 = "Internal processing error #3 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x17e35 = "VERR_SUPDRV_TRACER_ALREADY_REGISTERED" */
    '\x01','\xdc','T','R','A','C','E','R','_','\xed','R','E','G','I','S','T','E','R','E','D',
/* 0x17e49 = "VERR_DBG_DEFERRED_LOAD_FAILED" */
    '\x01','D','B','G','_','D','E','F','E','R','R','E','D','_','L','O','A','D','_','\x93',
/* 0x17e5d = "Too deep ICB recursion." */
    '\xf0','d','e','e','p',' ','I','C','B',' ','r','e','c','u','r','s','i','o','n','.',
/* 0x17e71 = "VERR_CR_DIGEST_COMPROMISED" */
    '\x01','\xa9','D','I','G','E','S','T','_','C','O','M','P','R','O','M','I','S','E','D',
/* 0x17e85 = "VERR_IPC_RECEIVE_ABORTED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','A','B','O','R','T','E','D',
/* 0x17e99 = "Protocol not available." */
    'P','r','o','t','o','c','o','l',' ','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x17ead = "Missing data element for XAR file." */
    'M','i','s','s','i','n','g',' ','\x8f','\x1f','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x17ec1 = "VERR_IOM_IOPORT_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','R','A','N','G','E','_','\x14','\xb3',
/* 0x17ed5 = "VERR_SSM_STRUCTURE_MAGIC" */
    '\x01','S','S','M','_','S','T','R','U','C','T','U','R','E','_','M','A','G','I','C',
/* 0x17ee9 = "Trailing characters." */
    'T','r','a','i','l','i','n','g',' ','c','h','a','r','a','c','t','e','r','s','.',
/* 0x17efd = "VERR_IEM_INSTR_NOT_IMPLEMENTED" */
    '\x01','\xee','I','N','S','T','R','_','\x14','I','M','P','L','E','M','E','N','T','E','D',
/* 0x17f11 = "Generic hypercall operation failure." */
    '\x96','h','y','p','e','r','c','a','l','l',' ','\x83','f','a','i','l','u','r','e','.',
/* 0x17f25 = "Bad file inode device number for XAR file." */
    '\x92','\x18','i','n','o','d','e',' ','\x8b','\xdd','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x17f39 = "VERR_SSM_FIELD_INVALID_CALLBACK" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','C','A','L','L','B','A','C','K',
/* 0x17f4d = "VERR_IOM_IOPORTS_NOT_MAPPED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','S','_','\x14','M','A','P','P','E','D',
/* 0x17f61 = "VERR_PDM_DEVICE_INSTANCE_NOT_FOUND" */
    '\x01','\xb8','D','E','V','I','C','E','_','I','N','S','T','A','N','C','E','_','\x14','\xb3',
/* 0x17f75 = "A GMM sanity check failed." */
    'A',' ','G','M','M',' ','s','a','n','i','t','y',' ','c','h','e','c','k',' ','\x24',
/* 0x17f89 = "Reason for leaving RC: Double Fault." */
    '\x84','\x0e','\x25','R','C',':',' ','D','o','u','b','l','e',' ','F','a','u','l','t','.',
/* 0x17f9d = "VERR_SUP_VP_UNKOWN_MEM_TYPE" */
    '\x01','\xe6','V','P','_','U','N','K','O','W','N','_','M','E','M','_','T','Y','P','E',
/* 0x17fb1 = "Expected an element separator (| or :)." */
    '\xa6','\x60','\x1f','s','e','p','a','r','a','t','o','r',' ','(','|',' ','\x86',':',')','.',
/* 0x17fc5 = "VERR_VM_DRIVER_NOT_INSTALLED" */
    '\x01','\xcf','_','D','R','I','V','E','R','_','\x14','I','N','S','T','A','L','L','E','D',
/* 0x17fd9 = "Invalid timer queue number." */
    '\x0b','t','i','m','e','r',' ','q','u','e','u','e',' ','n','u','m','b','e','r','.',
/* 0x17fed = "VERR_PDM_INVALID_DEVICE_GUEST_BITS" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','G','U','E','S','T','_','B','I','T','S',
/* 0x18001 = "VERR_DBG_INVALID_SEGMENT_OFFSET" */
    '\x01','D','B','G','_','\x0f','S','E','G','M','E','N','T','_','O','F','F','S','E','T',
/* 0x18015 = "VINF_SSM_DONT_CALL_AGAIN" */
    '\x19','S','S','M','_','D','O','N','T','_','C','A','L','L','_','A','G','A','I','N',
/* 0x18029 = "VERR_VSCSI_LUN_NOT_ATTACHED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','\x14','A','T','T','A','C','H','E','D',
/* 0x1803d = "Internal processing error #2 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x18051 = "VERR_APIC_INTR_DISCARDED" */
    '\x01','A','P','I','C','_','I','N','T','R','_','D','I','S','C','A','R','D','E','D',
/* 0x18065 = "Reserved page table bits set." */
    'R','e','s','e','r','v','e','d',' ','\xb6','\x9e','b','i','t','s',' ','s','e','t','.',
/* 0x18079 = "Image Verification Failure: Invalid security directory entry." */
    '\xfe','\x0c','\x12','\x0b','s','e','c','u','r','i','t','y',' ','\x1b','e','n','t','r','y','.',
/* 0x1808d = "VERR_VUSB_FAILED_TO_QUEUE_URB" */
    '\x01','V','U','S','B','_','\x93','_','T','O','_','Q','U','E','U','E','_','U','R','B',
/* 0x180a1 = "The mode field in a tar header is bad." */
    '\x03','m','o','d','e',' ','\xff','\x0d','a',' ','t','a','r',' ','\xa2','\x09','b','a','d','.',
/* 0x180b5 = "FTP initialization failed." */
    'F','T','P',' ','i','n','i','t','i','a','l','i','z','a','t','i','o','n',' ','\x24',
/* 0x180c9 = "VERR_PDM_USBHLPR3_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','H','L','P','R','3','_','V','E','R','S','I','O','N','_','\x99',
/* 0x180dd = "A number tar header field was malformed." */
    'A',' ','\xdd','t','a','r',' ','\xa2','\xff','\x10','m','a','l','f','o','r','m','e','d','.',
/* 0x180f1 = "Bad file user id for XAR file." */
    '\x92','\x18','u','s','e','r',' ','i','d',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x18105 = "VINF_CSAM_PENDING_ACTION" */
    '\x19','C','S','A','M','_','P','E','N','D','I','N','G','_','A','C','T','I','O','N',
/* 0x18119 = "Expected a left parentheses." */
    '\xa6','a',' ','l','e','f','t',' ','p','a','r','e','n','t','h','e','s','e','s','.',
/* 0x1812d = "NEM failed to get registers." */
    'N','E','M',' ','\x88','\x08','g','e','t',' ','r','e','g','i','s','t','e','r','s','.',
/* 0x18141 = "VERR_PDM_DRVHLPR3_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','V','H','L','P','R','3','_','V','E','R','S','I','O','N','_','\x99',
/* 0x18155 = "Process Verification Failure: Bad optional header field." */
    '\x17','\x0c','\x12','\x92','o','p','t','i','o','n','a','l',' ','\xa2','f','i','e','l','d','.',
/* 0x18169 = "VERR_GMM_ALLOC_PAGES_IPE" */
    '\x01','G','M','M','_','A','L','L','O','C','_','P','A','G','E','S','_','I','P','E',
/* 0x1817d = "VFS chain element expected at least four arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','l','e','a','s','t',' ','f','o','u','r',' ','\xc8',
/* 0x18191 = "The driver instance could not be found." */
    '\x03','\xa8','i','n','s','t','a','n','c','e',' ','c','o','u','l','d',' ','\x05','\x90','\x7d',
/* 0x181a5 = "VERR_VGA_GL_LOAD_FAILURE" */
    '\x01','V','G','A','_','G','L','_','L','O','A','D','_','F','A','I','L','U','R','E',
/* 0x181b9 = "VERR_VMM_RING0_ASSERTION" */
    '\x01','V','M','M','_','R','I','N','G','0','_','A','S','S','E','R','T','I','O','N',
/* 0x181cd = "VERR_SSM_STATE_GREW_TOO_BIG" */
    '\x01','S','S','M','_','S','T','A','T','E','_','G','R','E','W','_','\x9f','B','I','G',
/* 0x181e1 = "VERR_SUP_VP_NO_FOUND_NO_EXE_MAPPING" */
    '\x01','\xe6','V','P','_','\xb7','\xb3','_','\xb7','E','X','E','_','M','A','P','P','I','N','G',
/* 0x181f5 = "VERR_CR_KEY_DEK_INFO_TOO_LONG" */
    '\x01','\xa9','K','E','Y','_','D','E','K','_','I','N','F','O','_','\x9f','L','O','N','G',
/* 0x18209 = "VERR_HARDAVL_BAD_NEW_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','N','E','W','_','H','E','I','G','H','T',
/* 0x1821d = "Internal processing error #6 in the DBGF breakpoint manager code." */
    '\x06','\x04','\x07','#','6',' ','\x0d','\x02','\xf1',' ','\xab','m','a','n','a','g','e','r',' ','\x5e',
/* 0x18231 = "VERR_SUPDRV_VTG_BAD_HDR_NOT_MULTIPLE" */
    '\x01','\xdc','V','T','G','_','\xa0','H','D','R','_','\x14','M','U','L','T','I','P','L','E',
/* 0x18245 = "VERR_XAR_BAD_LENGTH_ELEMENT" */
    '\x01','X','A','R','_','\xa0','L','E','N','G','T','H','_','E','L','E','M','E','N','T',
/* 0x18259 = "VERR_ASN1_EXPECTED_PRIMITIVE" */
    '\x01','\xf2','E','X','P','E','C','T','E','D','_','P','R','I','M','I','T','I','V','E',
/* 0x1826d = "VERR_XAR_TOC_XML_PARSE_ERROR" */
    '\x01','X','A','R','_','T','O','C','_','X','M','L','_','P','A','R','S','E','_','\x9b',
/* 0x18281 = "Failed to allocate VM memory." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','\xcf',' ','m','e','m','o','r','y','.',
/* 0x18295 = "Device i/o: Bad length." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','l','e','n','g','t','h','.',
/* 0x182a9 = "VINF_VRDP_THREAD_STARTED" */
    '\x19','V','R','D','P','_','T','H','R','E','A','D','_','S','T','A','R','T','E','D',
/* 0x182bd = "VERR_AUDIO_ENUMERATION_FAILED" */
    '\x01','A','U','D','I','O','_','E','N','U','M','E','R','A','T','I','O','N','_','\x93',
/* 0x182d1 = "Already initialized." */
    'A','l','r','e','a','d','y',' ','i','n','i','t','i','a','l','i','z','e','d','.',
/* 0x182e5 = "NtQueryObject/Type failed." */
    'N','t','Q','u','e','r','y','O','b','j','e','c','t','/','T','y','p','e',' ','\x24',
/* 0x182f9 = "VERR_PGM_TOO_MANY_MMIO2_RANGES" */
    '\x01','\xd7','\x9f','M','A','N','Y','_','M','M','I','O','2','_','R','A','N','G','E','S',
/* 0x1830d = "VERR_SUPLIB_PATH_IS_ROOT" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','I','S','_','R','O','O','T',
/* 0x18321 = "VERR_SSM_GCPHYS_OVERFLOW" */
    '\x01','S','S','M','_','G','C','P','H','Y','S','_','O','V','E','R','F','L','O','W',
/* 0x18335 = "VERR_CR_KEY_UNEXPECTED_CIPHER_PARAMS" */
    '\x01','\xa9','K','E','Y','_','\xce','C','I','P','H','E','R','_','P','A','R','A','M','S',
/* 0x18349 = "VERR_ISOMK_IMPORT_BAD_PRIMARY_VOL_DESC" */
    '\x01','\xaa','\xd4','\xa0','P','R','I','M','A','R','Y','_','V','O','L','_','D','E','S','C',
/* 0x1835d = "VERR_HARDAVL_UNEXPECTED_NULL_RIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xce','N','U','L','L','_','R','I','G','H','T',
/* 0x18371 = "VERR_PDM_BLOCK_UNKNOWN_TRANSLATION" */
    '\x01','\xb8','B','L','O','C','K','_','\xde','T','R','A','N','S','L','A','T','I','O','N',
/* 0x18385 = "VERR_DBG_NOT_LINUX_KALLSYMS" */
    '\x01','D','B','G','_','\x14','L','I','N','U','X','_','K','A','L','L','S','Y','M','S',
/* 0x18399 = "VERR_NEM_GET_REGISTERS_FAILED" */
    '\x01','N','E','M','_','G','E','T','_','R','E','G','I','S','T','E','R','S','_','\x93',
/* 0x183ad = "VERR_PGM_INVALID_GC_PHYSICAL_RANGE" */
    '\x01','\xd7','\x0f','G','C','_','P','H','Y','S','I','C','A','L','_','R','A','N','G','E',
/* 0x183c1 = "VWRN_TRAILING_SPACES" */
    'V','W','R','N','_','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x183d5 = "VERR_SUP_VP_STUB_THREAD_NOT_FOUND" */
    '\x01','\xe6','V','P','_','S','T','U','B','_','T','H','R','E','A','D','_','\x14','\xb3',
/* 0x183e8 = "Socket is already connected." */
    'S','o','c','k','e','t',' ','\x09','\x22','c','o','n','n','e','c','t','e','d','.',
/* 0x183fb = "OpenSSL d2i_PKCS7 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','P','K','C','S','7',' ','\x24',
/* 0x1840e = "VWRN_TRAILING_CHARS" */
    'V','W','R','N','_','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x18421 = "VERR_DIS_NO_READ_CALLBACK" */
    '\x01','D','I','S','_','\xb7','R','E','A','D','_','C','A','L','L','B','A','C','K',
/* 0x18434 = "Pagetable not present." */
    'P','a','g','e','t','a','b','l','e',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x18447 = "VERR_DBG_CFG_NOT_UINT_PROP" */
    '\x01','D','B','G','_','C','F','G','_','\x14','U','I','N','T','_','P','R','O','P',
/* 0x1845a = "VINF_TCP_SERVER_NO_CLIENT" */
    '\x19','T','C','P','_','S','E','R','V','E','R','_','\xb7','C','L','I','E','N','T',
/* 0x1846d = "VERR_VM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xcf','_','D','R','I','V','E','R','_','V','E','R','S','I','O','N','_','\x99',
/* 0x18480 = "EVP_DecryptUpdate failed." */
    'E','V','P','_','D','e','c','r','y','p','t','U','p','d','a','t','e',' ','\x24',
/* 0x18493 = "VERR_NO_STRING_TERMINATOR" */
    '\x01','\xb7','S','T','R','I','N','G','_','T','E','R','M','I','N','A','T','O','R',
/* 0x184a6 = "VERR_IPC_SEND_CANCELLED" */
    '\x01','I','P','C','_','S','E','N','D','_','C','A','N','C','E','L','L','E','D',
/* 0x184b9 = "VERR_SUPLIB_PATH_TOO_SHORT" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9f','S','H','O','R','T',
/* 0x184cc = "VERR_PDM_DRIVER_NO_RT_ATTACH" */
    '\x01','\xb8','D','R','I','V','E','R','_','\xb7','R','T','_','A','T','T','A','C','H',
/* 0x184df = "VERR_SSM_INTEGRITY_SIZE" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','S','I','Z','E',
/* 0x184f2 = "Connection refused." */
    'C','o','n','n','e','c','t','i','o','n',' ','r','e','f','u','s','e','d','.',
/* 0x18505 = "VERR_HARDAVL_UNEXPECTED_NULL_LEFT" */
    '\x01','H','A','R','D','A','V','L','_','\xce','N','U','L','L','_','L','E','F','T',
/* 0x18518 = "VERR_SSM_GCPTR_OVERFLOW" */
    '\x01','S','S','M','_','G','C','P','T','R','_','O','V','E','R','F','L','O','W',
/* 0x1852b = "Compromised digest." */
    'C','o','m','p','r','o','m','i','s','e','d',' ','d','i','g','e','s','t','.',
/* 0x1853e = "VINF_CR_DIGEST_DEPRECATED" */
    '\x19','\xa9','D','I','G','E','S','T','_','D','E','P','R','E','C','A','T','E','D',
/* 0x18551 = "VERR_NET_SOCKET_TYPE_NOT_SUPPORTED" */
    '\x01','N','E','T','_','S','O','C','K','E','T','_','T','Y','P','E','_','\x14','\xc5',
/* 0x18564 = "VERR_NET_ADDRESS_IN_USE" */
    '\x01','N','E','T','_','A','D','D','R','E','S','S','_','I','N','_','U','S','E',
/* 0x18577 = "VERR_PDM_TOO_PCI_MANY_DEVICES" */
    '\x01','\xb8','\x9f','P','C','I','_','M','A','N','Y','_','D','E','V','I','C','E','S',
/* 0x1858a = "VERR_HARDAVL_UNBALANCED" */
    '\x01','H','A','R','D','A','V','L','_','U','N','B','A','L','A','N','C','E','D',
/* 0x1859d = "VERR_CR_SPC_UNKNOWN_MONIKER_UUID" */
    '\x01','\xa9','S','P','C','_','\xde','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x185b0 = "VERR_SSM_SKIP_BACKWARDS" */
    '\x01','S','S','M','_','S','K','I','P','_','B','A','C','K','W','A','R','D','S',
/* 0x185c3 = "VERR_VRDP_ACCESS_DENIED" */
    '\x01','V','R','D','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x185d6 = "Failed to stat a file/dir (hardening)." */
    '\x80','\x08','s','t','a','t',' ','a',' ','f','i','l','e','/','d','i','r',' ','\x9a',
/* 0x185e9 = "VERR_ISOMK_IPE_READ_FILE_DATA_3" */
    '\x01','\xaa','\x8e','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','3',
/* 0x185fc = "VFS chain element expected at most four arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','m','o','s','t',' ','f','o','u','r',' ','\xc8',
/* 0x1860f = "VERR_ISOMK_IPE_READ_FILE_DATA_1" */
    '\x01','\xaa','\x8e','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','1',
/* 0x18622 = "Undesirable module." */
    'U','n','d','e','s','i','r','a','b','l','e',' ','m','o','d','u','l','e','.',
/* 0x18635 = "Vote for another pass." */
    'V','o','t','e',' ','\x0e','a','n','o','t','h','e','r',' ','p','a','s','s','.',
/* 0x18648 = "VERR_PDM_INVALID_DRIVER_HOST_BITS" */
    '\x01','\xb8','\x0f','D','R','I','V','E','R','_','H','O','S','T','_','B','I','T','S',
/* 0x1865b = "Bad PCI configuration." */
    '\x92','P','C','I',' ','c','o','n','f','i','g','u','r','a','t','i','o','n','.',
/* 0x1866e = "VERR_CR_KEY_ALGO_PARAMS_MISMATCH" */
    '\x01','\xa9','K','E','Y','_','A','L','G','O','_','P','A','R','A','M','S','_','\x99',
/* 0x18681 = "VERR_DBGC_PARSE_INVALID_NUMBER" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\x0f','N','U','M','B','E','R',
/* 0x18694 = "VERR_VM_REQUEST_INVALID_PACKAGE" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','\x0f','P','A','C','K','A','G','E',
/* 0x186a7 = "Expected ECDSA private key." */
    '\xa6','E','C','D','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x186ba = "VERR_DBG_INVALID_SEGMENT_INDEX" */
    '\x01','D','B','G','_','\x0f','S','E','G','M','E','N','T','_','I','N','D','E','X',
/* 0x186cd = "EVP_EncryptUpdate failed." */
    'E','V','P','_','E','n','c','r','y','p','t','U','p','d','a','t','e',' ','\x24',
/* 0x186e0 = "Memory allocation failed." */
    'M','e','m','o','r','y',' ','a','l','l','o','c','a','t','i','o','n',' ','\x24',
/* 0x186f3 = "VERR_CR_X509_CPV_NOT_V3_CERT" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\x14','V','3','_','C','E','R','T',
/* 0x18706 = "VERR_CPUM_UNSUPPORTED_ID_REG_VALUE" */
    '\x01','C','P','U','M','_','\x9d','I','D','_','R','E','G','_','V','A','L','U','E',
/* 0x18719 = "Socket is not connected." */
    'S','o','c','k','e','t',' ','\x09','\x05','c','o','n','n','e','c','t','e','d','.',
/* 0x1872c = "VERR_ASN1_CURSOR_NO_MORE_DATA" */
    '\x01','\xf2','C','U','R','S','O','R','_','\xb7','M','O','R','E','_','D','A','T','A',
/* 0x1873f = "HTTP Internal Server Error." */
    'H','T','T','P',' ','\x06','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x18752 = "VERR_ISOMK_IPE_READ_FILE_DATA_2" */
    '\x01','\xaa','\x8e','R','E','A','D','_','F','I','L','E','_','D','A','T','A','_','2',
/* 0x18765 = "VERR_DBGC_PARSE_NO_MEMORY" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','\xb7','M','E','M','O','R','Y',
/* 0x18778 = "Process Verification Failure: Bad file alignment value in image header." */
    '\x17','\x0c','\x12','\x92','\x18','a','l','i','g','n','m','e','n','t',' ','\xd2','\x0d','\x1a','\xe7',
/* 0x1878b = "VERR_CR_PKCS7_KEY_USAGE_MISMATCH" */
    '\x01','\xa9','P','K','C','S','7','_','K','E','Y','_','U','S','A','G','E','_','\x99',
/* 0x1879e = "VERR_BIGNUM_DIV_BY_ZERO" */
    '\x01','B','I','G','N','U','M','_','D','I','V','_','B','Y','_','Z','E','R','O',
/* 0x187b1 = "VERR_IOM_IOPORT_UNKNOWN_OPCODE" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\xde','O','P','C','O','D','E',
/* 0x187c4 = "Certificate path validator: No trusted certificate paths." */
    '\xa7','\xbb','\xe5','\xd0','t','r','u','s','t','e','d',' ','\x8a','p','a','t','h','s','.',
/* 0x187d7 = "VERR_GIM_PVTSC_NOT_ENABLED" */
    '\x01','G','I','M','_','P','V','T','S','C','_','\x14','E','N','A','B','L','E','D',
/* 0x187ea = "VERR_HM_UNKNOWN_IO_INSTRUCTION" */
    '\x01','H','M','_','\xde','I','O','_','I','N','S','T','R','U','C','T','I','O','N',
/* 0x187fd = "The semaphore has been opened too many times." */
    '\x03','\xea','\x1d','\xad','o','p','e','n','e','d',' ','\x8c','\xa3','t','i','m','e','s','.',
/* 0x18810 = "VERR_CPUM_INVALID_CONFIG_VALUE" */
    '\x01','C','P','U','M','_','\x0f','C','O','N','F','I','G','_','V','A','L','U','E',
/* 0x18823 = "VERR_VD_IMAGE_CORRUPTED" */
    '\x01','V','D','_','I','M','A','G','E','_','C','O','R','R','U','P','T','E','D',
/* 0x18836 = "A signal is already pending." */
    'A',' ','s','i','g','n','a','l',' ','\x09','\x22','p','e','n','d','i','n','g','.',
/* 0x18849 = "Process Verification Failure: An image has too many sections." */
    '\x17','\x0c','\x12','A','n',' ','\x1a','\x1d','\x8c','\xa3','s','e','c','t','i','o','n','s','.',
/* 0x1885c = "The tracer is unloading." */
    '\x03','t','r','a','c','e','r',' ','\x09','u','n','l','o','a','d','i','n','g','.',
/* 0x1886f = "VERR_CR_SPC_BAD_MONIKER_UUID" */
    '\x01','\xa9','S','P','C','_','\xa0','M','O','N','I','K','E','R','_','U','U','I','D',
/* 0x18882 = "VERR_ISOFS_FSD_ZERO_ROOT_DIR" */
    '\x01','\xfd','F','S','D','_','Z','E','R','O','_','R','O','O','T','_','D','I','R',
/* 0x18895 = "Bad file inode number for XAR file." */
    '\x92','\x18','i','n','o','d','e',' ','\xdd','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x188a8 = "Generic object destroyed status." */
    '\x96','\x8d','d','e','s','t','r','o','y','e','d',' ','s','t','a','t','u','s','.',
/* 0x188bb = "Wrong JSON type for date value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xd9','\x0e','d','a','t','e',' ','\xd3',
/* 0x188ce = "Bad ASN.1 time object." */
    '\x92','A','S','N','.','1',' ','t','i','m','e',' ','o','b','j','e','c','t','.',
/* 0x188e1 = "VERR_NAT_REDIR_GUEST_IP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','G','U','E','S','T','_','I','P',
/* 0x188f4 = "VWRN_FLOAT_OVERFLOW" */
    'V','W','R','N','_','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x18907 = "VERR_CR_X509_CPV_NOT_CA_CERT" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','\x14','C','A','_','C','E','R','T',
/* 0x1891a = "Saved state header integrity error." */
    'S','a','v','e','d',' ','\xb0','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x1892d = "Shared Clipboard guest error." */
    'S','h','a','r','e','d',' ','C','l','i','p','b','o','a','r','d',' ','\xa1','\x7b',
/* 0x18940 = "VERR_CR_DIGEST_DEPRECATED" */
    '\x01','\xa9','D','I','G','E','S','T','_','D','E','P','R','E','C','A','T','E','D',
/* 0x18953 = "VERR_TAR_EOS_MORE_INPUT" */
    '\x01','T','A','R','_','E','O','S','_','M','O','R','E','_','I','N','P','U','T',
/* 0x18966 = "VERR_IOMMU_INTR_REMAP_FAILED" */
    '\x01','I','O','M','M','U','_','I','N','T','R','_','R','E','M','A','P','_','\x93',
/* 0x18979 = "IOCtl to VBoxGuest driver failed." */
    'I','O','C','t','l',' ','\x08','V','B','o','x','G','u','e','s','t',' ','\xa8','\x24',
/* 0x1898c = "Path not verified yet." */
    'P','a','t','h',' ','\x05','v','e','r','i','f','i','e','d',' ','y','e','t','.',
/* 0x1899f = "VERR_PDM_MODULE_NAME_TOO_LONG" */
    '\x01','\xb8','M','O','D','U','L','E','_','N','A','M','E','_','\x9f','L','O','N','G',
/* 0x189b2 = "VERR_MEM_CACHE_MAX_SIZE" */
    '\x01','M','E','M','_','C','A','C','H','E','_','M','A','X','_','S','I','Z','E',
/* 0x189c5 = "VFS chain element expected at least two arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','l','e','a','s','t',' ','t','w','o',' ','\xc8',
/* 0x189d8 = "VERR_ISOFS_UNKNOWN_PART_MAP_TYPE_ID" */
    '\x01','\xfd','\xde','P','A','R','T','_','M','A','P','_','T','Y','P','E','_','I','D',
/* 0x189eb = "Syntax error - a type conversion failed." */
    '\xe1','\x07','-',' ','a',' ','\xd9','c','o','n','v','e','r','s','i','o','n',' ','\x24',
/* 0x189fe = "VERR_PDM_INVALID_USB_REGISTRATION" */
    '\x01','\xb8','\x0f','U','S','B','_','R','E','G','I','S','T','R','A','T','I','O','N',
/* 0x18a11 = "VFS chain element expected at most five arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','m','o','s','t',' ','f','i','v','e',' ','\xc8',
/* 0x18a24 = "The handle is not pollable." */
    '\x03','h','a','n','d','l','e',' ','\x09','\x05','p','o','l','l','a','b','l','e','.',
/* 0x18a37 = "VERR_FAM_MONITOR_FILE_FAILED" */
    '\x01','F','A','M','_','M','O','N','I','T','O','R','_','F','I','L','E','_','\x93',
/* 0x18a4a = "VERR_HGCM_TOO_MANY_CLIENTS" */
    '\x01','H','G','C','M','_','\x9f','M','A','N','Y','_','C','L','I','E','N','T','S',
/* 0x18a5d = "VERR_IOM_INVALID_IOPORT_HANDLE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','H','A','N','D','L','E',
/* 0x18a70 = "The requested allocation is too big." */
    '\x03','\xbf','a','l','l','o','c','a','t','i','o','n',' ','\x09','\x8c','b','i','g','.',
/* 0x18a83 = "VERR_DWARF_LEB_OVERFLOW" */
    '\x01','D','W','A','R','F','_','L','E','B','_','O','V','E','R','F','L','O','W',
/* 0X18a96 = "Wrong JSON type for bool value." */
    'r','o','n','g',' ','J','S','O','N',' ','\xd9','\x0e','b','o','o','l',' ','\xd3',
/* 0x18aa8 = "Internal error - this should never happen." */
    '\x06','\x07','-',' ','\xc9','\xec','n','e','v','e','r',' ','h','a','p','p','e','n','.',
/* 0x18abb = "VERR_GVM_MISMATCH_VM_STRUCT_VER" */
    '\x01','G','V','M','_','\x99','_','\xcf','_','S','T','R','U','C','T','_','V','E','R',
/* 0x18ace = "VERR_SUP_VP_UNEXPECTED_SECTION_FLAGS" */
    '\x01','\xe6','V','P','_','\xce','S','E','C','T','I','O','N','_','F','L','A','G','S',
/* 0x18ae1 = "Unknown SPC PE image attribute." */
    '\xdf','S','P','C',' ','P','E',' ','\x1a','a','t','t','r','i','b','u','t','e','.',
/* 0x18af4 = "VERR_PDM_DRIVER_NAME_CLASH" */
    '\x01','\xb8','D','R','I','V','E','R','_','N','A','M','E','_','C','L','A','S','H',
/* 0x18b07 = "VERR_SUPDRV_TRACER_BAD_ARG_FLAGS" */
    '\x01','\xdc','T','R','A','C','E','R','_','\xa0','A','R','G','_','F','L','A','G','S',
/* 0x18b1a = "VERR_CR_PKIX_UNKNOWN_DIGEST_TYPE" */
    '\x01','\xa9','P','K','I','X','_','\xde','D','I','G','E','S','T','_','T','Y','P','E',
/* 0x18b2d = "VERR_VFS_CHAIN_AT_MOST_ONE_ARG" */
    '\x01','\xa4','_','\xda','A','T','_','M','O','S','T','_','O','N','E','_','A','R','G',
/* 0x18b40 = "Process Verification Failure: Bad section alignment value in image header." */
    '\x17','\x0c','\x12','\x92','\xc6','a','l','i','g','n','m','e','n','t',' ','\xd2','\x0d','\x1a','\xe7',
/* 0x18b53 = "VERR_SUPLIB_STAT_ENUM_FAILED" */
    '\x01','S','U','P','L','I','B','_','S','T','A','T','_','E','N','U','M','_','\x93',
/* 0x18b66 = "VERR_PGM_PHYS_PAGE_GET_IPE" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','G','E','T','_','I','P','E',
/* 0x18b79 = "The host kernel is too old." */
    '\x03','h','o','s','t',' ','k','e','r','n','e','l',' ','\x09','\x8c','o','l','d','.',
/* 0x18b8c = "VINF_SSM_LIVE_SUSPENDED" */
    '\x19','S','S','M','_','L','I','V','E','_','S','U','S','P','E','N','D','E','D',
/* 0x18b9f = "VERR_SUP_VP_UNEXPECTED_IMAGE_MACHINE" */
    '\x01','\xe6','V','P','_','\xce','I','M','A','G','E','_','M','A','C','H','I','N','E',
/* 0x18bb2 = "VERR_PDM_INVALID_DEVICE_HOST_BITS" */
    '\x01','\xb8','\x0f','D','E','V','I','C','E','_','H','O','S','T','_','B','I','T','S',
/* 0x18bc5 = "VERR_SUP_VP_NT_QI_THREAD_ERROR" */
    '\x01','\xe6','V','P','_','N','T','_','Q','I','_','T','H','R','E','A','D','_','\x9b',
/* 0x18bd8 = "VERR_SUP_VP_NO_NTDLL_MAPPING" */
    '\x01','\xe6','V','P','_','\xb7','N','T','D','L','L','_','M','A','P','P','I','N','G',
/* 0x18beb = "VERR_ASN1_INVALID_BOOLEAN_ENCODING" */
    '\x01','\xf2','\x0f','B','O','O','L','E','A','N','_','E','N','C','O','D','I','N','G',
/* 0x18bfe = "VINF_UDP_SERVER_NO_CLIENT" */
    '\x19','U','D','P','_','S','E','R','V','E','R','_','\xb7','C','L','I','E','N','T',
/* 0x18c11 = "VERR_SUP_VP_TOO_MANY_SECTIONS" */
    '\x01','\xe6','V','P','_','\x9f','M','A','N','Y','_','S','E','C','T','I','O','N','S',
/* 0x18c24 = "VERR_PGM_INVALID_LARGE_PAGE_RANGE" */
    '\x01','\xd7','\x0f','L','A','R','G','E','_','P','A','G','E','_','R','A','N','G','E',
/* 0x18c37 = "A path parameter was not set." */
    'A',' ','\xbb','p','a','r','a','m','e','t','e','r',' ','\x10','\x05','s','e','t','.',
/* 0x18c4a = "VERR_HTTP_SSL_CONNECT_ERROR" */
    '\x01','H','T','T','P','_','S','S','L','_','C','O','N','N','E','C','T','_','\x9b',
/* 0x18c5d = "VINF_IOM_R3_IOPORT_READ" */
    '\x19','I','O','M','_','R','3','_','I','O','P','O','R','T','_','R','E','A','D',
/* 0x18c70 = "VERR_FILE_AIO_NOT_PREPARED" */
    '\x01','F','I','L','E','_','A','I','O','_','\x14','P','R','E','P','A','R','E','D',
/* 0x18c83 = "VERR_ASN1_INVALID_INTEGER_ENCODING" */
    '\x01','\xf2','\x0f','I','N','T','E','G','E','R','_','E','N','C','O','D','I','N','G',
/* 0x18c96 = "VERR_PGM_SAVED_ROM_PAGE_NOT_FOUND" */
    '\x01','\xd7','S','A','V','E','D','_','R','O','M','_','P','A','G','E','_','\x14','\xb3',
/* 0x18ca9 = "VERR_LDRVI_READ_ERROR_SHDRS" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9b','_','S','H','D','R','S',
/* 0x18cbc = "Failed to generate RSA key." */
    '\x80','\x08','g','e','n','e','r','a','t','e',' ','R','S','A',' ','k','e','y','.',
/* 0x18ccf = "VERR_VD_IMAGE_READ_ONLY" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','A','D','_','O','N','L','Y',
/* 0x18ce2 = "VERR_PGM_INVALID_SAVED_PAGE_STATE" */
    '\x01','\xd7','\x0f','S','A','V','E','D','_','P','A','G','E','_','S','T','A','T','E',
/* 0x18cf5 = "VERR_CFGM_NOT_ENOUGH_SPACE" */
    '\x01','C','F','G','M','_','\x14','E','N','O','U','G','H','_','S','P','A','C','E',
/* 0x18d08 = "VINF_ACCOUNT_RESTRICTED" */
    '\x19','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x18d1b = "VINF_EM_PENDING_REQUEST" */
    '\x19','E','M','_','P','E','N','D','I','N','G','_','R','E','Q','U','E','S','T',
/* 0x18d2e = "VERR_VD_DMG_XML_PARSE_ERROR" */
    '\x01','V','D','_','D','M','G','_','X','M','L','_','P','A','R','S','E','_','\x9b',
/* 0x18d41 = "VERR_COM_INVALID_SESSION_STATE" */
    '\x01','C','O','M','_','\x0f','S','E','S','S','I','O','N','_','S','T','A','T','E',
/* 0x18d54 = "VERR_SSM_LOADED_TOO_LITTLE" */
    '\x01','S','S','M','_','L','O','A','D','E','D','_','\x9f','L','I','T','T','L','E',
/* 0x18d67 = "VERR_SUPLIB_PATH_NOT_CLEAN" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x14','C','L','E','A','N',
/* 0x18d7a = "validation of the LX object table failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x13','\x02','L','X',' ','\x8d','\x9e','\x24',
/* 0x18d8d = "VERR_PDM_DEVICE_NO_RT_ATTACH" */
    '\x01','\xb8','D','E','V','I','C','E','_','\xb7','R','T','_','A','T','T','A','C','H',
/* 0x18da0 = "VERR_APIC_INTR_NOT_PENDING" */
    '\x01','A','P','I','C','_','I','N','T','R','_','\x14','P','E','N','D','I','N','G',
/* 0x18db3 = "Central directory file header corrupt." */
    'C','e','n','t','r','a','l',' ','\x1b','\x18','\xa2','c','o','r','r','u','p','t','.',
/* 0x18dc6 = "VINF_VRDP_OUTPUT_ENABLE" */
    '\x19','V','R','D','P','_','O','U','T','P','U','T','_','E','N','A','B','L','E',
/* 0x18dd9 = "VERR_PGM_MAPPINGS_DISABLED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','D','I','S','A','B','L','E','D',
/* 0x18dec = "VERR_DBG_UNWIND_INFO_NOT_FOUND" */
    '\x01','D','B','G','_','U','N','W','I','N','D','_','I','N','F','O','_','\x14','\xb3',
/* 0x18dff = "Unsupported firmware property." */
    '\x87','f','i','r','m','w','a','r','e',' ','p','r','o','p','e','r','t','y','.',
/* 0x18e12 = "TM does not support the GIP version." */
    'T','M',' ','\x9c','\x05','\xb1','\x02','G','I','P',' ','v','e','r','s','i','o','n','.',
/* 0x18e25 = "VERR_ASN1_DYNTYPE_TAG_NOT_IMPL" */
    '\x01','\xf2','D','Y','N','T','Y','P','E','_','T','A','G','_','\x14','I','M','P','L',
/* 0x18e38 = "VERR_HTTP_ACCESS_DENIED" */
    '\x01','H','T','T','P','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x18e4b = "VERR_WEB_NOT_AUTHENTICATED" */
    '\x01','W','E','B','_','\x14','A','U','T','H','E','N','T','I','C','A','T','E','D',
/* 0x18e5e = "VERR_VD_IMAGE_REPAIR_NOT_SUPPORTED" */
    '\x01','V','D','_','I','M','A','G','E','_','R','E','P','A','I','R','_','\x14','\xc5',
/* 0x18e71 = "VERR_ACCOUNT_RESTRICTED" */
    '\x01','A','C','C','O','U','N','T','_','R','E','S','T','R','I','C','T','E','D',
/* 0x18e84 = "VERR_SEM_LV_WRONG_ORDER" */
    '\x01','S','E','M','_','L','V','_','W','R','O','N','G','_','O','R','D','E','R',
/* 0x18e97 = "VERR_CR_SPC_MONIKER_BAD_DATA" */
    '\x01','\xa9','S','P','C','_','M','O','N','I','K','E','R','_','\xa0','D','A','T','A',
/* 0x18eaa = "VERR_TAR_MODE_WITH_TYPE" */
    '\x01','T','A','R','_','M','O','D','E','_','W','I','T','H','_','T','Y','P','E',
/* 0x18ebd = "VERR_XAR_BAD_DIGEST_LENGTH" */
    '\x01','X','A','R','_','\xa0','D','I','G','E','S','T','_','L','E','N','G','T','H',
/* 0x18ed0 = "No valid TSS present." */
    '\xd0','v','a','l','i','d',' ','T','S','S',' ','p','r','e','s','e','n','t','.',
/* 0x18ee3 = "Record header integrity error." */
    'R','e','c','o','r','d',' ','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x18ef6 = "VERR_IOM_NOT_MMIO_RANGE_OWNER" */
    '\x01','I','O','M','_','\x14','\xf4','_','R','A','N','G','E','_','O','W','N','E','R',
/* 0x18f09 = "The image is outside the expected range." */
    '\x03','\x1a','\x09','o','u','t','s','i','d','e',' ','\x02','\xae','r','a','n','g','e','.',
/* 0x18f1c = "VERR_RECORDING_CODEC_NOT_SUPPORTED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x14','\xc5',
/* 0x18f2f = "The field contains a value that is out of range." */
    '\x03','\xff','\x7f','a',' ','\xd2','\x89','\x09','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x18f42 = "Unknown SPC object moniker UUID." */
    '\xdf','S','P','C',' ','\x8d','m','o','n','i','k','e','r',' ','U','U','I','D','.',
/* 0x18f55 = "VINF_PATM_PATCH_TRAP_PF" */
    '\x19','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','P','F',
/* 0x18f68 = "VERR_CR_X509_NAME_NOT_STRING" */
    '\x01','\xa9','X','5','0','9','_','N','A','M','E','_','\x14','S','T','R','I','N','G',
/* 0x18f7b = "VERR_TOO_MANY_SEM_REQUESTS" */
    '\x01','\x9f','M','A','N','Y','_','S','E','M','_','R','E','Q','U','E','S','T','S',
/* 0x18f8e = "VERR_NO_CODE_POINT_MEMORY" */
    '\x01','\xb7','C','O','D','E','_','P','O','I','N','T','_','M','E','M','O','R','Y',
/* 0x18fa1 = "Page hash mismatch." */
    'P','a','g','e',' ','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x18fb4 = "Bad size element in table of content sub-element." */
    '\x92','\xf8','\x1f','\x0d','\x9e','\x13','\xd8','s','u','b','-','e','l','e','m','e','n','t','.',
/* 0x18fc7 = "Process Verification Failure: Error querying process name." */
    '\x17','\x0c','\x12','\xac','q','u','e','r','y','i','n','g',' ','\x82','n','a','m','e','.',
/* 0x18fda = "VINF_CR_KEY_WAS_DECRYPTED" */
    '\x19','\xa9','K','E','Y','_','W','A','S','_','D','E','C','R','Y','P','T','E','D',
/* 0x18fed = "VERR_FILESYSTEM_CORRUPT" */
    '\x01','F','I','L','E','S','Y','S','T','E','M','_','C','O','R','R','U','P','T',
/* 0x19000 = "The service module was not found." */
    '\x03','s','e','r','v','i','c','e',' ','m','o','d','u','l','e',' ','\x10','\x05','\x7d',
/* 0x19013 = "VERR_PGM_UNSUPPORTED_HOST_PAGING_MODE" */
    '\x01','\xd7','\x9d','H','O','S','T','_','P','A','G','I','N','G','_','M','O','D','E',
/* 0x19026 = "VERR_SUPLIB_OWNER_NOT_ROOT" */
    '\x01','S','U','P','L','I','B','_','O','W','N','E','R','_','\x14','R','O','O','T',
/* 0x19039 = "VERR_LDRVI_IMAGE_HASH_MISMATCH" */
    '\x01','L','D','R','V','I','_','I','M','A','G','E','_','H','A','S','H','_','\x99',
/* 0x1904c = "VINF_HGCM_ASYNC_EXECUTE" */
    '\x19','H','G','C','M','_','A','S','Y','N','C','_','E','X','E','C','U','T','E',
/* 0x1905f = "VERR_INTNET_FLT_IF_BUSY" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','B','U','S','Y',
/* 0x19072 = "VERR_CFGM_CONFIG_UNKNOWN_VALUE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\xde','V','A','L','U','E',
/* 0x19085 = "VERR_PGM_MAP_MMIO2_ALIAS_MMIO" */
    '\x01','\xd7','M','A','P','_','M','M','I','O','2','_','A','L','I','A','S','_','\xf4',
/* 0x19098 = "VERR_TOO_MANY_CPUID_LEAVES" */
    '\x01','\x9f','M','A','N','Y','_','C','P','U','I','D','_','L','E','A','V','E','S',
/* 0x190ab = "VERR_LDRVI_BAD_CERT_FORMAT" */
    '\x01','L','D','R','V','I','_','\xa0','C','E','R','T','_','F','O','R','M','A','T',
/* 0x190be = "VERR_XAR_UNSUPPORTED_HASH_FUNCTION" */
    '\x01','X','A','R','_','\x9d','H','A','S','H','_','F','U','N','C','T','I','O','N',
/* 0x190d1 = "Failed to allocate memory for a URB." */
    '\x80','\x08','a','l','l','o','c','a','t','e',' ','\x5c','\x0e','a',' ','U','R','B','.',
/* 0x190e4 = "Public key is too small." */
    'P','u','b','l','i','c',' ','k','e','y',' ','\x09','\x8c','s','m','a','l','l','.',
/* 0x190f7 = "VERR_RECORDING_CODEC_NOT_FOUND" */
    '\x01','R','E','C','O','R','D','I','N','G','_','C','O','D','E','C','_','\x14','\xb3',
/* 0x1910a = "VFS chain element expected at least six arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','l','e','a','s','t',' ','s','i','x',' ','\xc8',
/* 0x1911d = "VERR_SHCLPB_EVENT_ID_NOT_FOUND" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','I','D','_','\x14','\xb3',
/* 0x19130 = "No pending interrupt." */
    '\xd0','p','e','n','d','i','n','g',' ','i','n','t','e','r','r','u','p','t','.',
/* 0x19143 = "VERR_VRDP_ISO_UNSUPPORTED" */
    '\x01','V','R','D','P','_','\xb2','_','U','N','S','U','P','P','O','R','T','E','D',
/* 0x19156 = "Something is missing." */
    'S','o','m','e','t','h','i','n','g',' ','\x09','m','i','s','s','i','n','g','.',
/* 0x19169 = "Parallels HDD: Invalid image file header." */
    'P','a','r','a','l','l','e','l','s',' ','H','D','D',':',' ','\x0b','\x1a','\x18','\xe7',
/* 0x1917c = "VERR_PDM_MODULE_NAME_CLASH" */
    '\x01','\xb8','M','O','D','U','L','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x1918f = "Bad left right height." */
    '\x92','l','e','f','t',' ','r','i','g','h','t',' ','h','e','i','g','h','t','.',
/* 0x191a2 = "VERR_HM_SUSPEND_PENDING" */
    '\x01','H','M','_','S','U','S','P','E','N','D','_','P','E','N','D','I','N','G',
/* 0x191b5 = "VERR_CR_KEY_DECRYPTION_NOT_SUPPORTED" */
    '\x01','\xa9','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x14','\xc5',
/* 0x191c8 = "VERR_FILE_AIO_COMPLETED" */
    '\x01','F','I','L','E','_','A','I','O','_','C','O','M','P','L','E','T','E','D',
/* 0x191db = "VINF_PATM_PATCH_TRAP_GP" */
    '\x19','P','A','T','M','_','P','A','T','C','H','_','T','R','A','P','_','G','P',
/* 0x191ee = "VERR_PROC_IQ_PRIV_NOT_HELD" */
    '\x01','P','R','O','C','_','I','Q','_','P','R','I','V','_','\x14','H','E','L','D',
/* 0x19201 = "VERR_LDRPE_DELAY_IMPORT" */
    '\x01','L','D','R','P','E','_','D','E','L','A','Y','_','I','M','P','O','R','T',
/* 0x19214 = "VERR_PDM_DEVICE_NAME_CLASH" */
    '\x01','\xb8','D','E','V','I','C','E','_','N','A','M','E','_','C','L','A','S','H',
/* 0x19227 = "Is a symbolic link." */
    'I','s',' ','a',' ','s','y','m','b','o','l','i','c',' ','l','i','n','k','.',
/* 0x1923a = "VERR_CR_X509_CPV_ISSUER_MISMATCH" */
    '\x01','\xa9','X','5','0','9','_','C','P','V','_','I','S','S','U','E','R','_','\x99',
/* 0x1924d = "EVP_EncryptFinal failed." */
    'E','V','P','_','E','n','c','r','y','p','t','F','i','n','a','l',' ','\x24',
/* 0x1925f = "VWRN_PATCH_ENABLED" */
    'V','W','R','N','_','P','A','T','C','H','_','E','N','A','B','L','E','D',
/* 0x19271 = "Too many MMIO registrations." */
    '\xf0','\xa3','\xf4',' ','r','e','g','i','s','t','r','a','t','i','o','n','s','.',
/* 0x19283 = "Stream is not ready for requested operation." */
    'S','t','r','e','a','m',' ','\x09','\x05','r','e','a','d','y',' ','\x0e','\xbf','\xcc',
/* 0x19295 = "VERR_EM_GUEST_CPU_HANG" */
    '\x01','E','M','_','G','U','E','S','T','_','C','P','U','_','H','A','N','G',
/* 0x192a7 = "VINF_IEM_YIELD_PENDING_FF" */
    '\x19','\xee','Y','I','E','L','D','_','P','E','N','D','I','N','G','_','F','F',
/* 0x192b9 = "VERR_GMM_CHUNK_NOT_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\x14','M','A','P','P','E','D',
/* 0x192cb = "VERR_LDRMACHO_UNSUPPORTED_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','S','E','C','T','I','O','N',
/* 0x192dd = "VERR_MEDIA_NOT_RECOGNIZED" */
    '\x01','M','E','D','I','A','_','\x14','R','E','C','O','G','N','I','Z','E','D',
/* 0x192ef = "VERR_CALLER_NO_REFERENCE" */
    '\x01','C','A','L','L','E','R','_','\xb7','R','E','F','E','R','E','N','C','E',
/* 0x19301 = "VERR_SUP_VP_TOO_LARGE_REGION" */
    '\x01','\xe6','V','P','_','\x9f','L','A','R','G','E','_','R','E','G','I','O','N',
/* 0x19313 = "VERR_ISOFS_INVALID_PARTITION_INDEX" */
    '\x01','\xfd','\x0f','P','A','R','T','I','T','I','O','N','_','I','N','D','E','X',
/* 0x19325 = "MMIO region is not mapped." */
    '\xf4',' ','r','e','g','i','o','n',' ','\x09','\x05','m','a','p','p','e','d','.',
/* 0x19337 = "VERR_LDRVI_PAGE_HASH_MISMATCH" */
    '\x01','L','D','R','V','I','_','P','A','G','E','_','H','A','S','H','_','\x99',
/* 0x19349 = "Seek below file start." */
    'S','e','e','k',' ','b','e','l','o','w',' ','\x18','s','t','a','r','t','.',
/* 0x1935b = "VERR_CR_PKCS7_OSSL_D2I_FAILED" */
    '\x01','\xa9','P','K','C','S','7','_','O','S','S','L','_','D','2','I','_','\x93',
/* 0x1936d = "VERR_ASN1_TELETEX_UNKNOWN_ESC_SEQ" */
    '\x01','\xf2','T','E','L','E','T','E','X','_','\xde','E','S','C','_','S','E','Q',
/* 0x1937f = "The per process timer is busy." */
    '\x03','p','e','r',' ','\x82','t','i','m','e','r',' ','\x09','b','u','s','y','.',
/* 0x19391 = "Internal processing error #2 in the I/O port code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x193a3 = "VMDK: Image property not found." */
    'V','M','D','K',':',' ','\xfe','p','r','o','p','e','r','t','y',' ','\x05','\x7d',
/* 0x193b5 = "VERR_JSON_ITERATOR_END" */
    '\x01','J','S','O','N','_','I','T','E','R','A','T','O','R','_','E','N','D',
/* 0x193c7 = "VERR_LDR_INVALID_LINK_ADDRESS" */
    '\x01','L','D','R','_','\x0f','L','I','N','K','_','A','D','D','R','E','S','S',
/* 0x193d9 = "VERR_CPUM_UNSUPPORTED_ID_REGISTER" */
    '\x01','C','P','U','M','_','\x9d','I','D','_','R','E','G','I','S','T','E','R',
/* 0x193eb = "VERR_CR_SPC_UNKNOWN_DIGEST_ALGO" */
    '\x01','\xa9','S','P','C','_','\xde','D','I','G','E','S','T','_','A','L','G','O',
/* 0x193fd = "VFS chain element expected at most six arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','m','o','s','t',' ','s','i','x',' ','\xc8',
/* 0x1940f = "VERR_IEM_VAR_NOT_INITIALIZED" */
    '\x01','\xee','V','A','R','_','\x14','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19421 = "VERR_IPC_RECEIVE_MAP_FAILED" */
    '\x01','I','P','C','_','R','E','C','E','I','V','E','_','M','A','P','_','\x93',
/* 0x19433 = "The tracer has not been opened." */
    '\x03','t','r','a','c','e','r',' ','\x1d','\x05','\xad','o','p','e','n','e','d','.',
/* 0x19445 = "Data connection not found." */
    'D','a','t','a',' ','c','o','n','n','e','c','t','i','o','n',' ','\x05','\x7d',
/* 0x19457 = "VERR_SSM_FIELD_COMPLEX" */
    '\x01','S','S','M','_','F','I','E','L','D','_','C','O','M','P','L','E','X',
/* 0x19469 = "VERR_IS_A_BLOCK_DEVICE" */
    '\x01','I','S','_','A','_','B','L','O','C','K','_','D','E','V','I','C','E',
/* 0x1947b = "VINF_PERMISSION_DENIED" */
    '\x19','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x1948d = "The specified path has too many components (hardening)." */
    '\x03','\x16','\xbb','\x1d','\x8c','\xa3','c','o','m','p','o','n','e','n','t','s',' ','\x9a',
/* 0x1949f = "VERR_SUPLIB_DIR_ENUM_FAILED" */
    '\x01','S','U','P','L','I','B','_','D','I','R','_','E','N','U','M','_','\x93',
/* 0x194b1 = "The requested feature is not supported by NEM." */
    '\x03','\xbf','f','e','a','t','u','r','e',' ','\x09','\x05','\xf9','\xb9','N','E','M','.',
/* 0x194c3 = "VERR_SUP_VP_MEMORY_READ_ERROR" */
    '\x01','\xe6','V','P','_','M','E','M','O','R','Y','_','R','E','A','D','_','\x9b',
/* 0x194d5 = "VERR_ISOMK_IMPORT_TOO_MANY_VOL_DESCS" */
    '\x01','\xaa','\xd4','\x9f','M','A','N','Y','_','V','O','L','_','D','E','S','C','S',
/* 0x194e7 = "VERR_SUPLIB_PATH_TOO_LONG" */
    '\x01','S','U','P','L','I','B','_','P','A','T','H','_','\x9f','L','O','N','G',
/* 0x194f9 = "Internal processing error #3 in the I/O port code." */
    '\x06','\x04','\x07','#','3',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x1950b = "VERR_GMM_CHUNK_ALREADY_MAPPED" */
    '\x01','G','M','M','_','C','H','U','N','K','_','\xed','M','A','P','P','E','D',
/* 0x1951d = "VERR_REST_INTERNAL_ERROR_7" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','7',
/* 0x1952f = "VERR_REST_INTERNAL_ERROR_6" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','6',
/* 0x19541 = "VERR_REST_INTERNAL_ERROR_5" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','5',
/* 0x19553 = "VERR_REST_INTERNAL_ERROR_4" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','4',
/* 0x19565 = "VERR_REST_INTERNAL_ERROR_2" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','2',
/* 0x19577 = "VERR_REST_INTERNAL_ERROR_1" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','1',
/* 0x19589 = "VERR_REST_INTERNAL_ERROR_3" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','3',
/* 0x1959b = "VERR_REST_INTERNAL_ERROR_8" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','8',
/* 0x195ad = "Process Verification Failure: Bad virtual section size." */
    '\x17','\x0c','\x12','\x92','v','i','r','t','u','a','l',' ','\xc6','s','i','z','e','.',
/* 0x195bf = "VERR_PGM_PHYS_PAGE_MAP_IPE_4" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8e','4',
/* 0x195d1 = "VERR_HGCM_INVALID_CMD_ADDRESS" */
    '\x01','H','G','C','M','_','\x0f','C','M','D','_','A','D','D','R','E','S','S',
/* 0x195e3 = "VERR_LDRVI_PARSE_BER_ERROR" */
    '\x01','L','D','R','V','I','_','P','A','R','S','E','_','B','E','R','_','\x9b',
/* 0x195f5 = "VERR_PGM_PHYS_PAGE_MAP_IPE_3" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8e','3',
/* 0x19607 = "VERR_PGM_PHYS_PAGE_MAP_IPE_1" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8e','1',
/* 0x19619 = "VERR_PGM_PHYS_PAGE_MAP_IPE_2" */
    '\x01','\xd7','P','H','Y','S','_','P','A','G','E','_','M','A','P','_','\x8e','2',
/* 0x1962b = "VERR_REST_INTERNAL_ERROR_9" */
    '\x01','R','E','S','T','_','I','N','T','E','R','N','A','L','_','\x9b','_','9',
/* 0x1963d = "VINF_IEM_RECOMPILE_END_TB" */
    '\x19','\xee','R','E','C','O','M','P','I','L','E','_','E','N','D','_','T','B',
/* 0x1964f = "Invalid signature length." */
    '\x0b','s','i','g','n','a','t','u','r','e',' ','l','e','n','g','t','h','.',
/* 0x19661 = "VERR_SUP_VP_FOUND_EXEC_MEMORY" */
    '\x01','\xe6','V','P','_','\xb3','_','E','X','E','C','_','M','E','M','O','R','Y',
/* 0x19673 = "Recompiler: Out of stack slots." */
    '\x11','O','u','t',' ','\x13','s','t','a','c','k',' ','s','l','o','t','s','.',
/* 0x19685 = "VERR_PGM_TOO_MANY_ROM_RANGES" */
    '\x01','\xd7','\x9f','M','A','N','Y','_','R','O','M','_','R','A','N','G','E','S',
/* 0x19697 = "VERR_VSCSI_LUN_INVALID" */
    '\x01','V','S','C','S','I','_','L','U','N','_','I','N','V','A','L','I','D',
/* 0x196a9 = "Permission denied." */
    'P','e','r','m','i','s','s','i','o','n',' ','d','e','n','i','e','d','.',
/* 0x196bb = "The PE loader doesn't support the TLS data directory yet." */
    '\x03','P','E',' ','\xc4','\xa5','\xb1','\x02','T','L','S',' ','\x8f','\x1b','y','e','t','.',
/* 0x196cd = "VERR_CFGM_INTEGER_TOO_BIG" */
    '\x01','C','F','G','M','_','I','N','T','E','G','E','R','_','\x9f','B','I','G',
/* 0x196df = "VERR_IEM_INSTR_BUF_TOO_LARGE" */
    '\x01','\xee','I','N','S','T','R','_','B','U','F','_','\x9f','L','A','R','G','E',
/* 0x196f1 = "VERR_GMM_TOO_MANY_REGIONS" */
    '\x01','G','M','M','_','\x9f','M','A','N','Y','_','R','E','G','I','O','N','S',
/* 0x19703 = "Guest process is in a wrong state." */
    'G','u','e','s','t',' ','\x82','\x09','\x0d','a',' ','w','r','o','n','g',' ','\xf5',
/* 0x19715 = "VERR_VM_UNEXPECTED_UNSTABLE_STATE" */
    '\x01','\xcf','_','\xce','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x19727 = "VERR_TM_UNSTABLE_STATE" */
    '\x01','T','M','_','U','N','S','T','A','B','L','E','_','S','T','A','T','E',
/* 0x19739 = "VERR_PDM_DRIVER_ALREADY_ATTACHED" */
    '\x01','\xb8','D','R','I','V','E','R','_','\xed','A','T','T','A','C','H','E','D',
/* 0x1974b = "VINF_SYS_MAY_POWER_OFF" */
    '\x19','S','Y','S','_','M','A','Y','_','P','O','W','E','R','_','O','F','F',
/* 0x1975d = "VERR_TAR_UNSUPPORTED_GNU_HDR_TYPE" */
    '\x01','T','A','R','_','\x9d','G','N','U','_','H','D','R','_','T','Y','P','E',
/* 0x1976f = "Internal processing error #1 in the I/O port code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','I','/','O',' ','p','o','r','t',' ','\x5e',
/* 0x19781 = "VERR_HM_WRONG_SWITCHER" */
    '\x01','H','M','_','W','R','O','N','G','_','S','W','I','T','C','H','E','R',
/* 0x19793 = "VERR_FILE_AIO_CANCELED" */
    '\x01','F','I','L','E','_','A','I','O','_','C','A','N','C','E','L','E','D',
/* 0x197a5 = "VINF_EM_RESCHEDULE_REM" */
    '\x19','E','M','_','R','E','S','C','H','E','D','U','L','E','_','R','E','M',
/* 0x197b7 = "Pending VM request packet." */
    'P','e','n','d','i','n','g',' ','\xcf',' ','\x94','p','a','c','k','e','t','.',
/* 0x197c9 = "VERR_NET_PROTOCOL_TYPE" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','T','Y','P','E',
/* 0x197db = "VERR_SELECTOR_NOT_PRESENT" */
    '\x01','S','E','L','E','C','T','O','R','_','\x14','P','R','E','S','E','N','T',
/* 0x197ed = "VERR_ISOMK_RR_NO_SPACE_FOR_CE" */
    '\x01','\xaa','R','R','_','\xb7','S','P','A','C','E','_','F','O','R','_','C','E',
/* 0x197ff = "VERR_PGM_POOL_TOO_MANY_LOOPS" */
    '\x01','\xd7','P','O','O','L','_','\x9f','M','A','N','Y','_','L','O','O','P','S',
/* 0x19811 = "VERR_PGM_HANDLER_ALREADY_ALIASED" */
    '\x01','\xd7','H','A','N','D','L','E','R','_','\xed','A','L','I','A','S','E','D',
/* 0x19823 = "EVP_DecryptFinal failed." */
    'E','V','P','_','D','e','c','r','y','p','t','F','i','n','a','l',' ','\x24',
/* 0x19835 = "VERR_ASN1_TELETEX_UNSUPPORTED_ESC_SEQ" */
    '\x01','\xf2','T','E','L','E','T','E','X','_','\x9d','E','S','C','_','S','E','Q',
/* 0x19847 = "The event semaphore has already been posted." */
    '\x03','e','v','e','n','t',' ','\xea','\x1d','\x22','\xad','p','o','s','t','e','d','.',
/* 0x19859 = "VERR_PGM_NO_CR3_SHADOW_ROOT" */
    '\x01','\xd7','\xb7','C','R','3','_','S','H','A','D','O','W','_','R','O','O','T',
/* 0x1986b = "VERR_SUP_VP_SYSTEM32_PATH" */
    '\x01','\xe6','V','P','_','S','Y','S','T','E','M','3','2','_','P','A','T','H',
/* 0x1987d = "Client has been rejected." */
    'C','l','i','e','n','t',' ','\x1d','\xad','r','e','j','e','c','t','e','d','.',
/* 0x1988f = "VERR_SUP_VP_NO_MEMORY_STATE" */
    '\x01','\xe6','V','P','_','\xb7','M','E','M','O','R','Y','_','S','T','A','T','E',
/* 0x198a1 = "Import ISO contains a bad directory record." */
    '\xaf','\xb2',' ','\x7f','a',' ','b','a','d',' ','\x1b','r','e','c','o','r','d','.',
/* 0x198b3 = "VERR_IOM_FF_STATUS_IPE" */
    '\x01','I','O','M','_','F','F','_','S','T','A','T','U','S','_','I','P','E',
/* 0x198c5 = "VERR_SUPDRV_TRACER_UNLOADING" */
    '\x01','\xdc','T','R','A','C','E','R','_','U','N','L','O','A','D','I','N','G',
/* 0x198d7 = "VERR_ISOFS_ICB_ENTRY_TOO_SMALL" */
    '\x01','\xfd','I','C','B','_','E','N','T','R','Y','_','\x9f','S','M','A','L','L',
/* 0x198e9 = "VERR_SSM_INTEGRITY_CRC" */
    '\x01','S','S','M','_','I','N','T','E','G','R','I','T','Y','_','C','R','C',
/* 0x198fb = "VERR_SHARING_VIOLATION" */
    '\x01','S','H','A','R','I','N','G','_','V','I','O','L','A','T','I','O','N',
/* 0x1990d = "VERR_XAR_BAD_SIZE_ELEMENT" */
    '\x01','X','A','R','_','\xa0','S','I','Z','E','_','E','L','E','M','E','N','T',
/* 0x1991f = "The certificate path has no trust anchor." */
    '\x03','\x8a','\xbb','\x1d','\xe9','t','r','u','s','t',' ','a','n','c','h','o','r','.',
/* 0x19931 = "Bad left tree height." */
    '\x92','l','e','f','t',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x19943 = "VERR_IEM_EMIT_BAD_SEG_REG_NO" */
    '\x01','\xee','E','M','I','T','_','\xa0','S','E','G','_','R','E','G','_','N','O',
/* 0x19955 = "VINF_EM_RAW_GUEST_TRAP" */
    '\x19','E','M','_','R','A','W','_','G','U','E','S','T','_','T','R','A','P',
/* 0x19967 = "VERR_CFGM_CONFIG_UNKNOWN_NODE" */
    '\x01','C','F','G','M','_','C','O','N','F','I','G','_','\xde','N','O','D','E',
/* 0x19979 = "VERR_ISOFS_UDF_NOT_IMPLEMENTED" */
    '\x01','\xfd','U','D','F','_','\x14','I','M','P','L','E','M','E','N','T','E','D',
/* 0x1998b = "VERR_DBG_NO_LINE_NUMBERS" */
    '\x01','D','B','G','_','\xb7','L','I','N','E','_','N','U','M','B','E','R','S',
/* 0x1999d = "VWRN_STATE_CHANGED" */
    'V','W','R','N','_','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x199af = "Footer integrity error." */
    'F','o','o','t','e','r',' ','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x199c1 = "VERR_ASN1_TELETEX_UNSUPPORTED_CHARSET" */
    '\x01','\xf2','T','E','L','E','T','E','X','_','\x9d','C','H','A','R','S','E','T',
/* 0x199d3 = "VERR_LDRMACHO_UNKNOWN_SECTION" */
    '\x01','L','D','R','M','A','C','H','O','_','\xde','S','E','C','T','I','O','N',
/* 0x199e5 = "VERR_SUPDRV_VTG_STRING_TOO_LONG" */
    '\x01','\xdc','V','T','G','_','S','T','R','I','N','G','_','\x9f','L','O','N','G',
/* 0x199f7 = "VERR_MAX_THRDS_REACHED" */
    '\x01','M','A','X','_','T','H','R','D','S','_','R','E','A','C','H','E','D',
/* 0x19a09 = "VERR_VFS_CHAIN_TAKES_DIR_OR_VFS" */
    '\x01','\xa4','_','\xda','T','A','K','E','S','_','D','I','R','_','O','R','_','\xa4',
/* 0x19a1b = "Recompiler: Variable management internal processing error #10." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','1','0','.',
/* 0x19a2d = "VERR_LDRELF_ODD_ENDIAN" */
    '\x01','L','D','R','E','L','F','_','O','D','D','_','E','N','D','I','A','N',
/* 0x19a3f = "Switch back to host." */
    'S','w','i','t','c','h',' ','b','a','c','k',' ','\x08','h','o','s','t','.',
/* 0x19a51 = "VERR_LDR_FORWARDERS_NOT_SUPPORTED" */
    '\x01','L','D','R','_','F','O','R','W','A','R','D','E','R','S','_','\x14','\xc5',
/* 0x19a63 = "Is a block device." */
    'I','s',' ','a',' ','b','l','o','c','k',' ','d','e','v','i','c','e','.',
/* 0x19a75 = "VERR_MAX_PROCS_REACHED" */
    '\x01','M','A','X','_','P','R','O','C','S','_','R','E','A','C','H','E','D',
/* 0x19a87 = "Encountered an unknown attribute form." */
    '\x97','\x60','\xfc','a','t','t','r','i','b','u','t','e',' ','f','o','r','m','.',
/* 0x19a99 = "VINF_CPUM_R3_MSR_WRITE" */
    '\x19','C','P','U','M','_','R','3','_','M','S','R','_','W','R','I','T','E',
/* 0x19aab = "VERR_SYMBOL_VALUE_TOO_BIG" */
    '\x01','S','Y','M','B','O','L','_','V','A','L','U','E','_','\x9f','B','I','G',
/* 0x19abd = "Expected a different string tag." */
    '\xa6','a',' ','d','i','f','f','e','r','e','n','t',' ','\xc7','t','a','g','.',
/* 0x19acf = "VERR_VMM_SWITCHER_STUB" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','S','T','U','B',
/* 0x19ae1 = "Protocol family not supported." */
    'P','r','o','t','o','c','o','l',' ','f','a','m','i','l','y',' ','\x05','\x95',
/* 0x19af3 = "VERR_PDM_DRVINS_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','V','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19b05 = "VERR_PKZIP_BAD_CDF_HEADER" */
    '\x01','P','K','Z','I','P','_','\xa0','C','D','F','_','H','E','A','D','E','R',
/* 0x19b17 = "VERR_PGM_TOO_MANY_RAM_RANGES" */
    '\x01','\xd7','\x9f','M','A','N','Y','_','R','A','M','_','R','A','N','G','E','S',
/* 0x19b29 = "VERR_SEM_LV_INTERNAL_ERROR" */
    '\x01','S','E','M','_','L','V','_','I','N','T','E','R','N','A','L','_','\x9b',
/* 0x19b3b = "VERR_PDM_DEVICE_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','I','C','E','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19b4d = "VERR_FAILED_TO_SET_SELF_TLS" */
    '\x01','\x93','_','T','O','_','S','E','T','_','S','E','L','F','_','T','L','S',
/* 0x19b5f = "VERR_PATH_IS_NOT_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','\x14','R','E','L','A','T','I','V','E',
/* 0x19b71 = "VERR_LDRVI_READ_ERROR_HASH" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9b','_','H','A','S','H',
/* 0x19b83 = "VERR_NEM_UNMAP_PAGES_FAILED" */
    '\x01','N','E','M','_','U','N','M','A','P','_','P','A','G','E','S','_','\x93',
/* 0x19b95 = "Process Verification Failure: An image has too many regions." */
    '\x17','\x0c','\x12','A','n',' ','\x1a','\x1d','\x8c','\xa3','r','e','g','i','o','n','s','.',
/* 0x19ba7 = "VERR_XAR_BAD_FILE_ELEMENT" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','E','L','E','M','E','N','T',
/* 0x19bb9 = "VERR_CR_KEY_DECRYPTION_FAILED" */
    '\x01','\xa9','K','E','Y','_','D','E','C','R','Y','P','T','I','O','N','_','\x93',
/* 0x19bcb = "FTP Internal Server Error." */
    'F','T','P',' ','\x06','S','e','r','v','e','r',' ','E','r','r','o','r','.',
/* 0x19bdd = "The field contains an invalid padding size." */
    '\x03','\xff','\x7f','\x60','\x81','p','a','d','d','i','n','g',' ','s','i','z','e','.',
/* 0x19bef = "VERR_PERMISSION_DENIED" */
    '\x01','P','E','R','M','I','S','S','I','O','N','_','D','E','N','I','E','D',
/* 0x19c01 = "VINF_EM_DBG_BREAKPOINT" */
    '\x19','E','M','_','D','B','G','_','B','R','E','A','K','P','O','I','N','T',
/* 0x19c13 = "VERR_STALE_FILE_HANDLE" */
    '\x01','S','T','A','L','E','_','F','I','L','E','_','H','A','N','D','L','E',
/* 0x19c25 = "Deprecated digest." */
    'D','e','p','r','e','c','a','t','e','d',' ','d','i','g','e','s','t','.',
/* 0x19c37 = "VERR_PDM_CRITSECT_ABORT_FAILED" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','_','A','B','O','R','T','_','\x93',
/* 0x19c49 = "VERR_SEM_LV_NOT_SIGNALLER" */
    '\x01','S','E','M','_','L','V','_','\x14','S','I','G','N','A','L','L','E','R',
/* 0x19c5b = "Device i/o: Bad unit." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','\x92','u','n','i','t','.',
/* 0x19c6d = "VERR_PDM_USBINS_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19c7f = "Syntax error - Invalid command name." */
    '\xe1','\x07','-',' ','\x0b','c','o','m','m','a','n','d',' ','n','a','m','e','.',
/* 0x19c91 = "The value is not a byte string." */
    '\x03','\xd2','\x09','\x05','a',' ','b','y','t','e',' ','s','t','r','i','n','g','.',
/* 0x19ca3 = "VERR_IOMMU_CMD_INVALID_FORMAT" */
    '\x01','I','O','M','M','U','_','C','M','D','_','\x0f','F','O','R','M','A','T',
/* 0x19cb5 = "VERR_VSCSI_LUN_TYPE_NOT_SUPPORTED" */
    '\x01','V','S','C','S','I','_','L','U','N','_','T','Y','P','E','_','\x14','\xc5',
/* 0x19cc7 = "VERR_ASN1_TIME_NORMALIZE_ERROR" */
    '\x01','\xf2','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x9b',
/* 0x19cd9 = "VERR_NET_NO_BUFFER_SPACE" */
    '\x01','N','E','T','_','\xb7','B','U','F','F','E','R','_','S','P','A','C','E',
/* 0x19ceb = "VERR_CONCURRENT_ACCESS" */
    '\x01','C','O','N','C','U','R','R','E','N','T','_','A','C','C','E','S','S',
/* 0X19cfd = "Selector not present." */
    'e','l','e','c','t','o','r',' ','\x05','p','r','e','s','e','n','t','.',
/* 0x19d0e = "VERR_PDM_DEVINS_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','I','N','S','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19d20 = "VERR_CR_PKIX_SIGNATURE_MISMATCH" */
    '\x01','\xa9','P','K','I','X','_','S','I','G','N','A','T','U','R','E','_','\x99',
/* 0x19d32 = "VERR_ASN1_TIME_NORMALIZE_MISMATCH" */
    '\x01','\xf2','T','I','M','E','_','N','O','R','M','A','L','I','Z','E','_','\x99',
/* 0x19d44 = "VERR_VFS_CHAIN_WRITE_ONLY_IOS" */
    '\x01','\xa4','_','\xda','W','R','I','T','E','_','O','N','L','Y','_','I','O','S',
/* 0x19d56 = "VERR_MM_BAD_TRAP_TYPE_IPE" */
    '\x01','M','M','_','\xa0','T','R','A','P','_','T','Y','P','E','_','I','P','E',
/* 0x19d68 = "VERR_MANIFEST_DIGEST_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','D','I','G','E','S','T','_','\x99',
/* 0x19d7a = "Recompiler: Debug info internal processing error #2." */
    '\x11','D','e','b','u','g',' ','i','n','f','o',' ','\x15','\x04','\x07','#','2','.',
/* 0x19d8c = "VERR_PDM_DRIVER_VERSION_MISMATCH" */
    '\x01','\xb8','D','R','I','V','E','R','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19d9e = "VERR_COM_INVALID_OBJECT_STATE" */
    '\x01','C','O','M','_','\x0f','O','B','J','E','C','T','_','S','T','A','T','E',
/* 0x19db0 = "Unknown allocation descriptor type." */
    '\xdf','a','l','l','o','c','a','t','i','o','n',' ','\xd6','t','y','p','e','.',
/* 0x19dc2 = "Certificate path validator: No valid certificate policy." */
    '\xa7','\xbb','\xe5','\xd0','v','a','l','i','d',' ','\x8a','p','o','l','i','c','y','.',
/* 0x19dd4 = "Receive cancelled." */
    'R','e','c','e','i','v','e',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x19de6 = "VFS chain element expected at most two arguments." */
    '\xa4',' ','\x91','\x1f','\xae','a','t',' ','m','o','s','t',' ','t','w','o',' ','\xc8',
/* 0x19df8 = "Recompiler: Variable management internal processing error #13." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','1','3','.',
/* 0x19e0a = "VERR_LDRLX_NRICHAIN_NOT_SUPPORTED" */
    '\x01','L','D','R','L','X','_','N','R','I','C','H','A','I','N','_','\x14','\xc5',
/* 0x19e1c = "VERR_IOM_INVALID_IOPORT_RANGE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','R','A','N','G','E',
/* 0x19e2e = "Logic bug in the DBGC code." */
    'L','o','g','i','c',' ','b','u','g',' ','\x0d','\x02','D','B','G','C',' ','\x5e',
/* 0x19e40 = "The shared module was not found." */
    '\x03','s','h','a','r','e','d',' ','m','o','d','u','l','e',' ','\x10','\x05','\x7d',
/* 0x19e52 = "VERR_ISOMK_IPE_EMPTY_COMPONENT" */
    '\x01','\xaa','\x8e','E','M','P','T','Y','_','C','O','M','P','O','N','E','N','T',
/* 0x19e64 = "VERR_POLL_HANDLE_ID_NOT_FOUND" */
    '\x01','P','O','L','L','_','H','A','N','D','L','E','_','I','D','_','\x14','\xb3',
/* 0x19e76 = "VERR_PDM_NO_ATTACHED_DRIVER" */
    '\x01','\xb8','\xb7','A','T','T','A','C','H','E','D','_','D','R','I','V','E','R',
/* 0x19e88 = "VERR_FDT_DTB_MALFORMED" */
    '\x01','F','D','T','_','D','T','B','_','M','A','L','F','O','R','M','E','D',
/* 0x19e9a = "VERR_VMX_MSR_LOCKING_FAILED" */
    '\x01','V','M','X','_','M','S','R','_','L','O','C','K','I','N','G','_','\x93',
/* 0x19eac = "VERR_FILE_AIO_NO_REQUEST" */
    '\x01','F','I','L','E','_','A','I','O','_','\xb7','R','E','Q','U','E','S','T',
/* 0x19ebe = "VERR_SUP_VP_THREAD_NOT_ALONE" */
    '\x01','\xe6','V','P','_','T','H','R','E','A','D','_','\x14','A','L','O','N','E',
/* 0x19ed0 = "Process Verification Failure: Error opening image file." */
    '\x17','\x0c','\x12','\xac','o','p','e','n','i','n','g',' ','\x1a','f','i','l','e','.',
/* 0x19ee2 = "VERR_PDM_DEVHLP_VERSION_MISMATCH" */
    '\x01','\xb8','D','E','V','H','L','P','_','V','E','R','S','I','O','N','_','\x99',
/* 0x19ef4 = "Unexpected filesystem object type." */
    '\x85','f','i','l','e','s','y','s','t','e','m',' ','\x8d','t','y','p','e','.',
/* 0x19f06 = "VERR_VBGL_NOT_INITIALIZED" */
    '\x01','V','B','G','L','_','\x14','I','N','I','T','I','A','L','I','Z','E','D',
/* 0x19f18 = "VERR_TAR_BAD_CHKSUM_FIELD" */
    '\x01','T','A','R','_','\xa0','C','H','K','S','U','M','_','F','I','E','L','D',
/* 0x19f2a = "Key decryption is not supported." */
    'K','e','y',' ','d','e','c','r','y','p','t','i','o','n',' ','\x09','\x05','\x95',
/* 0x19f3c = "Expected ECDSA public key." */
    '\xa6','E','C','D','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x19f4e = "Unsupported hashing function." */
    '\x87','h','a','s','h','i','n','g',' ','f','u','n','c','t','i','o','n','.',
/* 0x19f60 = "VERR_GMM_OUT_OF_MEMORY" */
    '\x01','G','M','M','_','O','U','T','_','O','F','_','M','E','M','O','R','Y',
/* 0x19f72 = "Symbol (export) not found." */
    'S','y','m','b','o','l',' ','(','e','x','p','o','r','t',')',' ','\x05','\x7d',
/* 0x19f84 = "VERR_ISOMK_IMPORT_INVALID_VOLUMNE_SEQ_NO" */
    '\x01','\xaa','\xd4','\x0f','V','O','L','U','M','N','E','_','S','E','Q','_','N','O',
/* 0x19f96 = "Undefined VM exit code." */
    'U','n','d','e','f','i','n','e','d',' ','\xcf',' ','e','x','i','t',' ','\x5e',
/* 0x19fa8 = "Recompiler: Variable management internal processing error #11." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','1','1','.',
/* 0x19fba = "VERR_SSM_LOAD_CONFIG_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','C','O','N','F','I','G','_','\x99',
/* 0x19fcc = "VWRN_PATCH_REMOVED" */
    'V','W','R','N','_','P','A','T','C','H','_','R','E','M','O','V','E','D',
/* 0x19fde = "VERR_ISOMK_IMPORT_VOLUME_IN_SET_MISMATCH" */
    '\x01','\xaa','\xd4','V','O','L','U','M','E','_','I','N','_','S','E','T','_','\x99',
/* 0x19ff0 = "OpenSSL PKCS #7 verification failed." */
    'O','p','e','n','S','S','L',' ','P','K','C','S',' ','#','7',' ','\xd5','\x24',
/* 0x1a002 = "VERR_S3_BUCKET_ALREADY_EXISTS" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\xed','E','X','I','S','T','S',
/* 0x1a014 = "Not code selector." */
    'N','o','t',' ','c','o','d','e',' ','s','e','l','e','c','t','o','r','.',
/* 0x1a026 = "Deadlock detected." */
    'D','e','a','d','l','o','c','k',' ','d','e','t','e','c','t','e','d','.',
/* 0x1a038 = "Bad file element in XAR table of content." */
    '\x92','\x18','\x1f','\x0d','X','A','R',' ','\x9e','\x13','c','o','n','t','e','n','t','.',
/* 0x1a04a = "VERR_ISOMK_IMPORT_BAD_DIR_REC_LENGTH" */
    '\x01','\xaa','\xd4','\xa0','D','I','R','_','R','E','C','_','L','E','N','G','T','H',
/* 0x1a05c = "VERR_PGM_MAPPING_CONFLICT" */
    '\x01','\xd7','M','A','P','P','I','N','G','_','C','O','N','F','L','I','C','T',
/* 0x1a06e = "VERR_FDT_AT_ROOT_LEVEL" */
    '\x01','F','D','T','_','A','T','_','R','O','O','T','_','L','E','V','E','L',
/* 0x1a080 = "Invalid requested privilege level." */
    '\x0b','\xbf','p','r','i','v','i','l','e','g','e',' ','l','e','v','e','l','.',
/* 0x1a092 = "VERR_NEGATIVE_UNSIGNED" */
    '\x01','N','E','G','A','T','I','V','E','_','U','N','S','I','G','N','E','D',
/* 0x1a0a4 = "The DBGF has no more free breakpoint slots." */
    '\x03','\xf1',' ','\x1d','\xe9','\xf6','f','r','e','e',' ','\xab','s','l','o','t','s','.',
/* 0x1a0b6 = "Internal processing error #1 in the switcher code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','s','w','i','t','c','h','e','r',' ','\x5e',
/* 0x1a0c8 = "VINF_PGM_HANDLER_ALREADY_ALIASED" */
    '\x19','\xd7','H','A','N','D','L','E','R','_','\xed','A','L','I','A','S','E','D',
/* 0x1a0da = "VERR_VD_VDI_INVALID_SIGNATURE" */
    '\x01','V','D','_','V','D','I','_','\x0f','S','I','G','N','A','T','U','R','E',
/* 0x1a0ec = "VERR_DWARF_UNKNOWN_LOC_OPCODE" */
    '\x01','D','W','A','R','F','_','\xde','L','O','C','_','O','P','C','O','D','E',
/* 0x1a0fe = "VERR_LDRMACHO_UNSUPPORTED_MACHINE" */
    '\x01','L','D','R','M','A','C','H','O','_','\x9d','M','A','C','H','I','N','E',
/* 0x1a110 = "OpenSSL d2i_X509 failed." */
    'O','p','e','n','S','S','L',' ','d','2','i','_','X','5','0','9',' ','\x24',
/* 0x1a122 = "Recompiler: Debug info internal processing error #1." */
    '\x11','D','e','b','u','g',' ','i','n','f','o',' ','\x15','\x04','\x07','#','1','.',
/* 0x1a134 = "Recompiler: Variable management internal processing error #12." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','1','2','.',
/* 0x1a146 = "VERR_PDM_USBDEV_VERSION_MISMATCH" */
    '\x01','\xb8','U','S','B','D','E','V','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a158 = "VERR_SEM_LV_INVALID_PARAMETER" */
    '\x01','S','E','M','_','L','V','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1a16a = "VERR_PGM_PHYS_HANDLER_IPE" */
    '\x01','\xd7','P','H','Y','S','_','H','A','N','D','L','E','R','_','I','P','E',
/* 0x1a17c = "File/Device open failed." */
    'F','i','l','e','/','D','e','v','i','c','e',' ','o','p','e','n',' ','\x24',
/* 0x1a18e = "VERR_SUPLIB_NOT_DIR_NOT_FILE" */
    '\x01','S','U','P','L','I','B','_','\x14','D','I','R','_','\x14','F','I','L','E',
/* 0x1a1a0 = "VERR_CR_PKCS7_INTERNAL_ERROR" */
    '\x01','\xa9','P','K','C','S','7','_','I','N','T','E','R','N','A','L','_','\x9b',
/* 0x1a1b2 = "VERR_COM_OBJECT_IN_USE" */
    '\x01','C','O','M','_','O','B','J','E','C','T','_','I','N','_','U','S','E',
/* 0x1a1c4 = "The page to be freed was already freed." */
    '\x03','\xb6','\x08','\x90','f','r','e','e','d',' ','\x10','\x22','f','r','e','e','d','.',
/* 0x1a1d6 = "MMIO region is already mapped." */
    '\xf4',' ','r','e','g','i','o','n',' ','\x09','\x22','m','a','p','p','e','d','.',
/* 0x1a1e8 = "VERR_ISOFS_TAG_IS_ALL_ZEROS" */
    '\x01','\xfd','T','A','G','_','I','S','_','A','L','L','_','Z','E','R','O','S',
/* 0x1a1fa = "VERR_IOM_IOPORT_UNUSED" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','U','N','U','S','E','D',
/* 0x1a20c = "VERR_PDM_TRANSLATION_NOT_SET" */
    '\x01','\xb8','T','R','A','N','S','L','A','T','I','O','N','_','\x14','S','E','T',
/* 0x1a21e = "VERR_IOMMU_DTE_BAD_OFFSET" */
    '\x01','I','O','M','M','U','_','D','T','E','_','\xa0','O','F','F','S','E','T',
/* 0x1a230 = "VERR_TRPM_NO_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','\xb7','A','C','T','I','V','E','_','T','R','A','P',
/* 0x1a242 = "VERR_GMM_PAGE_NOT_PRIVATE" */
    '\x01','G','M','M','_','P','A','G','E','_','\x14','P','R','I','V','A','T','E',
/* 0x1a254 = "Recompiler: Variable management internal processing error #1." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','1','.',
/* 0x1a265 = "VERR_SSM_LOADED_TOO_MUCH" */
    '\x01','S','S','M','_','L','O','A','D','E','D','_','\x9f','M','U','C','H',
/* 0x1a276 = "Zero length path." */
    'Z','e','r','o',' ','l','e','n','g','t','h',' ','p','a','t','h','.',
/* 0x1a287 = "The PKCS #7 content is not data." */
    '\x03','P','K','C','S',' ','#','7',' ','\xd8','\x09','\x05','d','a','t','a','.',
/* 0x1a298 = "VERR_VD_CACHE_ALREADY_EXISTS" */
    '\x01','V','D','_','C','A','C','H','E','_','\xed','E','X','I','S','T','S',
/* 0x1a2a9 = "Unknown location opcode." */
    '\xdf','l','o','c','a','t','i','o','n',' ','o','p','c','o','d','e','.',
/* 0x1a2ba = "VERR_SYMLINK_NOT_ALLOWED" */
    '\x01','S','Y','M','L','I','N','K','_','\x14','A','L','L','O','W','E','D',
/* 0x1a2cb = "VWRN_NO_TRANSLATION" */
    'V','W','R','N','_','\xb7','T','R','A','N','S','L','A','T','I','O','N',
/* 0x1a2dc = "validation of LX header failed." */
    'v','a','l','i','d','a','t','i','o','n',' ','\x13','L','X',' ','\xa2','\x24',
/* 0x1a2ed = "VINF_PCI_MAPPING_DONE" */
    '\x19','P','C','I','_','M','A','P','P','I','N','G','_','D','O','N','E',
/* 0x1a2fe = "VWRN_NO_DIRENT_INFO" */
    'V','W','R','N','_','\xb7','D','I','R','E','N','T','_','I','N','F','O',
/* 0x1a30f = "EVP_EncryptInit failed." */
    'E','V','P','_','E','n','c','r','y','p','t','I','n','i','t',' ','\x24',
/* 0x1a320 = "VERR_TOO_MANY_REFERENCES" */
    '\x01','\x9f','M','A','N','Y','_','R','E','F','E','R','E','N','C','E','S',
/* 0x1a331 = "VERR_DBGF_BP_L2_LOOKUP_FAILED" */
    '\x01','\xf1','_','B','P','_','L','2','_','L','O','O','K','U','P','_','\x93',
/* 0x1a342 = "Too many symbolic links." */
    '\xf0','\xa3','s','y','m','b','o','l','i','c',' ','l','i','n','k','s','.',
/* 0x1a353 = "VERR_IPC_SEND_ABORTED" */
    '\x01','I','P','C','_','S','E','N','D','_','A','B','O','R','T','E','D',
/* 0x1a364 = "VERR_SSM_TOO_MANY_PASSES" */
    '\x01','S','S','M','_','\x9f','M','A','N','Y','_','P','A','S','S','E','S',
/* 0x1a375 = "VINF_VRDP_PROCESS_PDU" */
    '\x19','V','R','D','P','_','P','R','O','C','E','S','S','_','P','D','U',
/* 0x1a386 = "Stop the UDP server." */
    'S','t','o','p',' ','\x02','U','D','P',' ','s','e','r','v','e','r','.',
/* 0x1a397 = "VERR_CFGM_NODE_EXISTS" */
    '\x01','C','F','G','M','_','N','O','D','E','_','E','X','I','S','T','S',
/* 0x1a3a8 = "VERR_VD_VMDK_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','M','D','K','_','\x9d','V','E','R','S','I','O','N',
/* 0x1a3b9 = "VERR_OUT_OF_RESOURCES" */
    '\x01','O','U','T','_','O','F','_','R','E','S','O','U','R','C','E','S',
/* 0x1a3ca = "Internal processing error #1 in the DBGF stack code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf1',' ','s','t','a','c','k',' ','\x5e',
/* 0x1a3db = "Unable to parse string as bool." */
    '\xca','\x08','p','a','r','s','e',' ','\xc7','a','s',' ','b','o','o','l','.',
/* 0x1a3ec = "VERR_NET_ALREADY_IN_PROGRESS" */
    '\x01','N','E','T','_','\xed','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1a3fd = "A module name is too long." */
    'A',' ','m','o','d','u','l','e',' ','\xf3','\x09','\x8c','l','o','n','g','.',
/* 0x1a40e = "VERR_PATH_IS_RELATIVE" */
    '\x01','P','A','T','H','_','I','S','_','R','E','L','A','T','I','V','E',
/* 0x1a41f = "Bad new tree height." */
    '\x92','n','e','w',' ','t','r','e','e',' ','h','e','i','g','h','t','.',
/* 0x1a430 = "VERR_ISOFS_WRONG_FILE_TYPE" */
    '\x01','\xfd','W','R','O','N','G','_','F','I','L','E','_','T','Y','P','E',
/* 0x1a441 = "VERR_OBJECT_DESTROYED" */
    '\x01','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1a452 = "VERR_DBG_NO_UNWIND_INFO" */
    '\x01','D','B','G','_','\xb7','U','N','W','I','N','D','_','I','N','F','O',
/* 0x1a463 = "VERR_CR_PKCS7_GENERIC_ERROR" */
    '\x01','\xa9','P','K','C','S','7','_','G','E','N','E','R','I','C','_','\x9b',
/* 0x1a474 = "VERR_ASN1_CURSOR_LONG_TAG" */
    '\x01','\xf2','C','U','R','S','O','R','_','L','O','N','G','_','T','A','G',
/* 0x1a485 = "Generic unexpected object ID error." */
    '\x96','u','n','e','x','p','e','c','t','e','d',' ','\x8d','I','D',' ','\x7b',
/* 0x1a496 = "VERR_RT_REQUEST_INVALID_TYPE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','\x0f','T','Y','P','E',
/* 0x1a4a7 = "VERR_DANGLING_OBJECTS" */
    '\x01','D','A','N','G','L','I','N','G','_','O','B','J','E','C','T','S',
/* 0x1a4b8 = "The event semaphore has already been reset." */
    '\x03','e','v','e','n','t',' ','\xea','\x1d','\x22','\xad','r','e','s','e','t','.',
/* 0x1a4c9 = "VERR_URI_ESCAPED_ZERO" */
    '\x01','U','R','I','_','E','S','C','A','P','E','D','_','Z','E','R','O',
/* 0x1a4da = "VERR_PGM_DYNMAP_FULL_SET" */
    '\x01','\xd7','D','Y','N','M','A','P','_','F','U','L','L','_','S','E','T',
/* 0x1a4eb = "Invalid Base64 encoding." */
    '\x0b','B','a','s','e','6','4',' ','e','n','c','o','d','i','n','g','.',
/* 0x1a4fc = "The tar header is all zeros." */
    '\x03','t','a','r',' ','\xa2','\x09','a','l','l',' ','z','e','r','o','s','.',
/* 0x1a50d = "VERR_SUPDRV_TRACER_NOT_PRESENT" */
    '\x01','\xdc','T','R','A','C','E','R','_','\x14','P','R','E','S','E','N','T',
/* 0x1a51e = "Recompiler: Variable management internal processing error #3." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','3','.',
/* 0x1a52f = "VERR_S3_BUCKET_NOT_EMPTY" */
    '\x01','S','3','_','B','U','C','K','E','T','_','\x14','E','M','P','T','Y',
/* 0x1a540 = "VERR_PGM_LOAD_UNEXPECTED_PAGE_TYPE" */
    '\x01','\xd7','L','O','A','D','_','\xce','P','A','G','E','_','T','Y','P','E',
/* 0x1a551 = "VERR_VGA_GL_SYMBOL_NOT_FOUND" */
    '\x01','V','G','A','_','G','L','_','S','Y','M','B','O','L','_','\x14','\xb3',
/* 0x1a562 = "VERR_PGM_NOT_SUPPORTED_FOR_NEM_MODE" */
    '\x01','\xd7','\x14','\xc5','_','F','O','R','_','N','E','M','_','M','O','D','E',
/* 0x1a573 = "VERR_RECORDING_INIT_FAILED" */
    '\x01','R','E','C','O','R','D','I','N','G','_','I','N','I','T','_','\x93',
/* 0x1a584 = "VERR_SSM_LIVE_FATAL_ERROR" */
    '\x01','S','S','M','_','L','I','V','E','_','F','A','T','A','L','_','\x9b',
/* 0x1a595 = "VERR_LDRVI_BAD_MZ_OFFSET" */
    '\x01','L','D','R','V','I','_','\xa0','M','Z','_','O','F','F','S','E','T',
/* 0x1a5a6 = "VERR_PDM_UNKNOWN_DRVREG_VERSION" */
    '\x01','\xb8','\xde','D','R','V','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1a5b7 = "VERR_IS_A_CHAR_DEVICE" */
    '\x01','I','S','_','A','_','C','H','A','R','_','D','E','V','I','C','E',
/* 0x1a5c8 = "VERR_PKZIP_UNKNOWN_TYPE_FLAG" */
    '\x01','P','K','Z','I','P','_','\xde','T','Y','P','E','_','F','L','A','G',
/* 0x1a5d9 = "Format not supported by the codec." */
    'F','o','r','m','a','t',' ','\x05','\xf9','\xb9','\x02','c','o','d','e','c','.',
/* 0x1a5ea = "VERR_IMAGE_BASE_TOO_HIGH" */
    '\x01','I','M','A','G','E','_','B','A','S','E','_','\x9f','H','I','G','H',
/* 0x1a5fb = "VERR_DBGF_BP_L1_LOOKUP_FAILED" */
    '\x01','\xf1','_','B','P','_','L','1','_','L','O','O','K','U','P','_','\x93',
/* 0x1a60c = "VERR_ISOFS_FSD_NEXT_EXTENT" */
    '\x01','\xfd','F','S','D','_','N','E','X','T','_','E','X','T','E','N','T',
/* 0x1a61d = "Bad TRPM_TRAP_IN_OP." */
    '\x92','T','R','P','M','_','T','R','A','P','_','I','N','_','O','P','.',
/* 0x1a62e = "VERR_VMM_CANNOT_BLOCK" */
    '\x01','V','M','M','_','C','A','N','N','O','T','_','B','L','O','C','K',
/* 0x1a63f = "VERR_GMM_PAGE_NOT_SHARED" */
    '\x01','G','M','M','_','P','A','G','E','_','\x14','S','H','A','R','E','D',
/* 0x1a650 = "VERR_IPC_SEND_TIMEOUT" */
    '\x01','I','P','C','_','S','E','N','D','_','T','I','M','E','O','U','T',
/* 0x1a661 = "VERR_DBG_ADDRESS_WRAP" */
    '\x01','D','B','G','_','A','D','D','R','E','S','S','_','W','R','A','P',
/* 0x1a672 = "The LUN is still busy." */
    '\x03','L','U','N',' ','\x09','s','t','i','l','l',' ','b','u','s','y','.',
/* 0x1a683 = "VERR_LDRLX_BAD_ITERDATA2" */
    '\x01','L','D','R','L','X','_','\xa0','I','T','E','R','D','A','T','A','2',
/* 0x1a694 = "VERR_SSM_FIELD_INVALID_VALUE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','V','A','L','U','E',
/* 0x1a6a5 = "VERR_LDRLX_BAD_FORWARDER" */
    '\x01','L','D','R','L','X','_','\xa0','F','O','R','W','A','R','D','E','R',
/* 0x1a6b6 = "Expected RSA private key." */
    '\xa6','R','S','A',' ','p','r','i','v','a','t','e',' ','k','e','y','.',
/* 0x1a6c7 = "Recompiler: Variable management internal processing error #6." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','6','.',
/* 0x1a6d8 = "VERR_POLL_SET_IS_FULL" */
    '\x01','P','O','L','L','_','S','E','T','_','I','S','_','F','U','L','L',
/* 0x1a6e9 = "VERR_LDRVI_READ_ERROR_HDR" */
    '\x01','L','D','R','V','I','_','R','E','A','D','_','\x9b','_','H','D','R',
/* 0x1a6fa = "No logger instance." */
    '\xd0','l','o','g','g','e','r',' ','i','n','s','t','a','n','c','e','.',
/* 0x1a70b = "VERR_JSON_VALUE_INVALID_TYPE" */
    '\x01','J','S','O','N','_','V','A','L','U','E','_','\x0f','T','Y','P','E',
/* 0x1a71c = "VERR_VMM_R0_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','0','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1a72d = "Bad load command(s)." */
    '\x92','l','o','a','d',' ','c','o','m','m','a','n','d','(','s',')','.',
/* 0x1a73e = "Unsupported file system charset." */
    '\x87','\x18','s','y','s','t','e','m',' ','c','h','a','r','s','e','t','.',
/* 0x1a74f = "Stop the TCP server." */
    'S','t','o','p',' ','\x02','T','C','P',' ','s','e','r','v','e','r','.',
/* 0x1a760 = "VERR_NET_OPERATION_NOT_SUPPORTED" */
    '\x01','N','E','T','_','O','P','E','R','A','T','I','O','N','_','\x14','\xc5',
/* 0x1a771 = "VERR_MANIFEST_ATTR_NOT_FOUND" */
    '\x01','M','A','N','I','F','E','S','T','_','A','T','T','R','_','\x14','\xb3',
/* 0x1a782 = "VERR_PDM_UNKNOWN_DEVREG_VERSION" */
    '\x01','\xb8','\xde','D','E','V','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1a793 = "VERR_VUSB_NO_URB_MEMORY" */
    '\x01','V','U','S','B','_','\xb7','U','R','B','_','M','E','M','O','R','Y',
/* 0x1a7a4 = "Bad forwarder entry." */
    '\x92','f','o','r','w','a','r','d','e','r',' ','e','n','t','r','y','.',
/* 0x1a7b5 = "VERR_URI_NOT_FILE_SCHEME" */
    '\x01','U','R','I','_','\x14','F','I','L','E','_','S','C','H','E','M','E',
/* 0x1a7c6 = "No node was specified." */
    '\xd0','n','o','d','e',' ','\x10','s','p','e','c','i','f','i','e','d','.',
/* 0x1a7d7 = "VERR_ISOMK_IMPORT_TOO_DEEP_DIR_TREE" */
    '\x01','\xaa','\xd4','\x9f','D','E','E','P','_','D','I','R','_','T','R','E','E',
/* 0x1a7e8 = "Unsupported CPU ID register." */
    '\x87','C','P','U',' ','I','D',' ','r','e','g','i','s','t','e','r','.',
/* 0x1a7f9 = "VERR_ISOFS_TOO_MANY_PART_MAPS" */
    '\x01','\xfd','\x9f','M','A','N','Y','_','P','A','R','T','_','M','A','P','S',
/* 0x1a80a = "VERR_VM_REQUEST_KILLED" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','K','I','L','L','E','D',
/* 0x1a81b = "VERR_BUFFER_UNDERFLOW" */
    '\x01','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1a82c = "VERR_PGM_DYNMAP_EXPAND_ERROR" */
    '\x01','\xd7','D','Y','N','M','A','P','_','E','X','P','A','N','D','_','\x9b',
/* 0x1a83d = "Generic out of resources error." */
    '\x96','o','u','t',' ','\x13','r','e','s','o','u','r','c','e','s',' ','\x7b',
/* 0x1a84e = "IOMMU device is not present." */
    'I','O','M','M','U',' ','\x8b','\x09','\x05','p','r','e','s','e','n','t','.',
/* 0x1a85f = "A reboot is needed." */
    'A',' ','r','e','b','o','o','t',' ','\x09','n','e','e','d','e','d','.',
/* 0x1a870 = "VERR_PATH_ZERO_LENGTH" */
    '\x01','P','A','T','H','_','Z','E','R','O','_','L','E','N','G','T','H',
/* 0x1a881 = "VERR_L4_DS_MANAGER_NOT_FOUND" */
    '\x01','L','4','_','D','S','_','M','A','N','A','G','E','R','_','\x14','\xb3',
/* 0x1a892 = "VERR_PKZIP_NAME_TOO_LONG" */
    '\x01','P','K','Z','I','P','_','N','A','M','E','_','\x9f','L','O','N','G',
/* 0x1a8a3 = "Recompiler: Variable management internal processing error #9." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','9','.',
/* 0x1a8b4 = "VERR_S3_ACCESS_DENIED" */
    '\x01','S','3','_','A','C','C','E','S','S','_','D','E','N','I','E','D',
/* 0x1a8c5 = "VINF_AIO_TASK_PENDING" */
    '\x19','A','I','O','_','T','A','S','K','_','P','E','N','D','I','N','G',
/* 0x1a8d6 = "VERR_PLATFORM_ARCH_NOT_SUPPORTED" */
    '\x01','P','L','A','T','F','O','R','M','_','A','R','C','H','_','\x14','\xc5',
/* 0x1a8e7 = "The semaphore is set and cannot be closed." */
    '\x03','\xea','\x09','s','e','t',' ','\x2a','\xcb','\x90','c','l','o','s','e','d','.',
/* 0x1a8f8 = "The server was stopped." */
    '\x03','s','e','r','v','e','r',' ','\x10','s','t','o','p','p','e','d','.',
/* 0x1a909 = "VERR_PGM_POOL_GET_PAGE_FAILED" */
    '\x01','\xd7','P','O','O','L','_','G','E','T','_','P','A','G','E','_','\x93',
/* 0x1a91a = "VERR_CR_X509_OSSL_D2I_FAILED" */
    '\x01','\xa9','X','5','0','9','_','O','S','S','L','_','D','2','I','_','\x93',
/* 0x1a92b = "VERR_SVM_INVALID_GUEST_STATE" */
    '\x01','S','V','M','_','\x0f','G','U','E','S','T','_','S','T','A','T','E',
/* 0x1a93c = "VINF_IPC_SEND_MSG_CUT" */
    '\x19','I','P','C','_','S','E','N','D','_','M','S','G','_','C','U','T',
/* 0x1a94d = "EVP_DecryptInit failed." */
    'E','V','P','_','D','e','c','r','y','p','t','I','n','i','t',' ','\x24',
/* 0x1a95e = "VERR_PDM_NOT_PCI_BUS_MASTER" */
    '\x01','\xb8','\x14','P','C','I','_','B','U','S','_','M','A','S','T','E','R',
/* 0x1a96f = "VERR_LDRMACHO_BAD_SYMBOL" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','S','Y','M','B','O','L',
/* 0x1a980 = "VERR_LDRMACHO_BAD_HEADER" */
    '\x01','L','D','R','M','A','C','H','O','_','\xa0','H','E','A','D','E','R',
/* 0x1a991 = "VERR_TOO_MANY_OPEN_FILES" */
    '\x01','\x9f','M','A','N','Y','_','O','P','E','N','_','F','I','L','E','S',
/* 0x1a9a2 = "Address conflict." */
    'A','d','d','r','e','s','s',' ','c','o','n','f','l','i','c','t','.',
/* 0x1a9b3 = "VERR_GVMM_BROKEN_IPRT" */
    '\x01','G','V','M','M','_','B','R','O','K','E','N','_','I','P','R','T',
/* 0x1a9c4 = "VERR_SSM_LOAD_CPUID_MISMATCH" */
    '\x01','S','S','M','_','L','O','A','D','_','C','P','U','I','D','_','\x99',
/* 0x1a9d5 = "VINF_DBGC_BP_NO_COMMAND" */
    '\x19','D','B','G','C','_','B','P','_','\xb7','C','O','M','M','A','N','D',
/* 0x1a9e6 = "Recompiler: Variable management internal processing error #2." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','2','.',
/* 0x1a9f7 = "Unable to switch due to invalid guest state." */
    '\xca','\x08','s','w','i','t','c','h',' ','d','u','e',' ','\x08','\x81','\xa1','\xf5',
/* 0x1aa08 = "VERR_PKZIP_BAD_LF_HEADER" */
    '\x01','P','K','Z','I','P','_','\xa0','L','F','_','H','E','A','D','E','R',
/* 0x1aa19 = "VINF_IEM_REEXEC_BREAK_FF" */
    '\x19','\xee','R','E','E','X','E','C','_','B','R','E','A','K','_','F','F',
/* 0x1aa2a = "VERR_VD_GEOMETRY_NOT_SET" */
    '\x01','V','D','_','G','E','O','M','E','T','R','Y','_','\x14','S','E','T',
/* 0x1aa3b = "Syntax error - buggy parser." */
    '\xe1','\x07','-',' ','b','u','g','g','y',' ','p','a','r','s','e','r','.',
/* 0x1aa4c = "Expected a provider name." */
    '\xa6','a',' ','p','r','o','v','i','d','e','r',' ','n','a','m','e','.',
/* 0x1aa5d = "VINF_OBJECT_DESTROYED" */
    '\x19','O','B','J','E','C','T','_','D','E','S','T','R','O','Y','E','D',
/* 0x1aa6e = "VERR_SUPDRV_VTG_ALREADY_REGISTERED" */
    '\x01','\xdc','V','T','G','_','\xed','R','E','G','I','S','T','E','R','E','D',
/* 0x1aa7f = "VERR_FTP_DATA_CONN_NOT_FOUND" */
    '\x01','F','T','P','_','D','A','T','A','_','C','O','N','N','_','\x14','\xb3',
/* 0x1aa90 = "VERR_VFS_CHAIN_ONLY_DIR_OR_VFS" */
    '\x01','\xa4','_','\xda','O','N','L','Y','_','D','I','R','_','O','R','_','\xa4',
/* 0x1aaa1 = "VERR_NET_NOT_UNSUPPORTED" */
    '\x01','N','E','T','_','\x14','U','N','S','U','P','P','O','R','T','E','D',
/* 0x1aab2 = "VERR_SERVICE_DISABLED" */
    '\x01','S','E','R','V','I','C','E','_','D','I','S','A','B','L','E','D',
/* 0x1aac3 = "Value out of range." */
    'V','a','l','u','e',' ','o','u','t',' ','\x13','r','a','n','g','e','.',
/* 0x1aad4 = "VINF_GIM_R3_HYPERCALL" */
    '\x19','G','I','M','_','R','3','_','H','Y','P','E','R','C','A','L','L',
/* 0x1aae5 = "VERR_ADDRESS_CONFLICT" */
    '\x01','A','D','D','R','E','S','S','_','C','O','N','F','L','I','C','T',
/* 0x1aaf6 = "VERR_URI_INVALID_PORT_NUMBER" */
    '\x01','U','R','I','_','\x0f','P','O','R','T','_','N','U','M','B','E','R',
/* 0x1ab07 = "Version mismatch." */
    'V','e','r','s','i','o','n',' ','m','i','s','m','a','t','c','h','.',
/* 0x1ab18 = "VERR_IOM_INVALID_IOPORT_SIZE" */
    '\x01','I','O','M','_','\x0f','I','O','P','O','R','T','_','S','I','Z','E',
/* 0x1ab29 = "Not a power of two." */
    'N','o','t',' ','a',' ','p','o','w','e','r',' ','\x13','t','w','o','.',
/* 0x1ab3a = "VERR_INTNET_FLT_IF_NOT_FOUND" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x14','\xb3',
/* 0x1ab4b = "VERR_NET_NOT_UNIQUE_NAME" */
    '\x01','N','E','T','_','\x14','U','N','I','Q','U','E','_','N','A','M','E',
/* 0x1ab5c = "VERR_VFS_CHAIN_READ_ONLY_IOS" */
    '\x01','\xa4','_','\xda','R','E','A','D','_','O','N','L','Y','_','I','O','S',
/* 0x1ab6d = "VERR_SUP_VP_BAD_SECTION_RVA" */
    '\x01','\xe6','V','P','_','\xa0','S','E','C','T','I','O','N','_','R','V','A',
/* 0x1ab7e = "Invalid parameter index." */
    '\x0b','p','a','r','a','m','e','t','e','r',' ','i','n','d','e','x','.',
/* 0x1ab8f = "Recompiler: Variable management internal processing error #7." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','7','.',
/* 0x1aba0 = "Recompiler: Unexpected kind of variable." */
    '\x11','\x85','k','i','n','d',' ','\x13','v','a','r','i','a','b','l','e','.',
/* 0x1abb1 = "Address overflow." */
    'A','d','d','r','e','s','s',' ','o','v','e','r','f','l','o','w','.',
/* 0x1abc2 = "The I/O request is in progress." */
    '\x03','I','/','O',' ','\x94','\x09','\x0d','p','r','o','g','r','e','s','s','.',
/* 0x1abd3 = "VERR_PATM_UNSAFE_CODE" */
    '\x01','P','A','T','M','_','U','N','S','A','F','E','_','C','O','D','E',
/* 0x1abe4 = "VERR_THREAD_NOT_WAITABLE" */
    '\x01','T','H','R','E','A','D','_','\x14','W','A','I','T','A','B','L','E',
/* 0x1abf5 = "Unit header integrity error." */
    'U','n','i','t',' ','\xa2','i','n','t','e','g','r','i','t','y',' ','\x7b',
/* 0x1ac06 = "Patch was already disabled." */
    'P','a','t','c','h',' ','\x10','\x22','d','i','s','a','b','l','e','d','.',
/* 0x1ac17 = "VERR_CFGM_INVALID_CHILD_PATH" */
    '\x01','C','F','G','M','_','\x0f','C','H','I','L','D','_','P','A','T','H',
/* 0x1ac28 = "VERR_XAR_TOC_STRLEN_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','S','T','R','L','E','N','_','\x99',
/* 0x1ac39 = "ASN.1 object is not present." */
    'A','S','N','.','1',' ','\x8d','\x09','\x05','p','r','e','s','e','n','t','.',
/* 0x1ac4a = "Invalid escape sequence." */
    '\x0b','e','s','c','a','p','e',' ','s','e','q','u','e','n','c','e','.',
/* 0x1ac5b = "VINF_CPUM_R3_MSR_READ" */
    '\x19','C','P','U','M','_','R','3','_','M','S','R','_','R','E','A','D',
/* 0x1ac6c = "VERR_VMM_RC_VERSION_MISMATCH" */
    '\x01','V','M','M','_','R','C','_','V','E','R','S','I','O','N','_','\x99',
/* 0x1ac7d = "VERR_TRPM_ACTIVE_TRAP" */
    '\x01','T','R','P','M','_','A','C','T','I','V','E','_','T','R','A','P',
/* 0x1ac8e = "VERR_GVM_MISMATCH_VMCPU_SIZE" */
    '\x01','G','V','M','_','\x99','_','V','M','C','P','U','_','S','I','Z','E',
/* 0x1ac9f = "VERR_LDRMACHO_BIT_MIX" */
    '\x01','L','D','R','M','A','C','H','O','_','B','I','T','_','M','I','X',
/* 0x1acb0 = "VERR_PREEMPT_DISABLED" */
    '\x01','P','R','E','E','M','P','T','_','D','I','S','A','B','L','E','D',
/* 0x1acc1 = "VWRN_CSAM_PAGE_NOT_FOUND" */
    'V','W','R','N','_','C','S','A','M','_','P','A','G','E','_','\x14','\xb3',
/* 0x1acd2 = "VERR_GMM_CHUNK_INSERT" */
    '\x01','G','M','M','_','C','H','U','N','K','_','I','N','S','E','R','T',
/* 0x1ace3 = "VERR_VD_ISCSI_INVALID_HEADER" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','H','E','A','D','E','R',
/* 0x1acf4 = "Buffer underflow." */
    'B','u','f','f','e','r',' ','u','n','d','e','r','f','l','o','w','.',
/* 0x1ad05 = "The requested type conversion was not supported." */
    '\x03','\xbf','\xd9','c','o','n','v','e','r','s','i','o','n',' ','\x10','\x05','\x95',
/* 0x1ad16 = "Recompiler: Variable management internal processing error #4." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','4','.',
/* 0x1ad27 = "VERR_CR_PKIX_INTERNAL_ERROR" */
    '\x01','\xa9','P','K','I','X','_','I','N','T','E','R','N','A','L','_','\x9b',
/* 0x1ad38 = "VINF_BUFFER_UNDERFLOW" */
    '\x19','B','U','F','F','E','R','_','U','N','D','E','R','F','L','O','W',
/* 0x1ad49 = "VERR_MM_HYPER_NO_MEMORY" */
    '\x01','M','M','_','H','Y','P','E','R','_','\xb7','M','E','M','O','R','Y',
/* 0x1ad5a = "The MMIO range specified for removal was not found." */
    '\x03','\xf4',' ','\xe4','\x16','\x0e','r','e','m','o','v','a','l',' ','\x10','\x05','\x7d',
/* 0x1ad6b = "VERR_PDM_UNKNOWN_USBREG_VERSION" */
    '\x01','\xb8','\xde','U','S','B','R','E','G','_','V','E','R','S','I','O','N',
/* 0x1ad7c = "VERR_NOT_ALL_CPUS_SHOWED" */
    '\x01','\x14','A','L','L','_','C','P','U','S','_','S','H','O','W','E','D',
/* 0x1ad8d = "VERR_CFGM_LEAF_EXISTS" */
    '\x01','C','F','G','M','_','L','E','A','F','_','E','X','I','S','T','S',
/* 0x1ad9e = "VERR_DBGF_NO_MORE_BP_SLOTS" */
    '\x01','\xf1','_','\xb7','M','O','R','E','_','B','P','_','S','L','O','T','S',
/* 0x1adaf = "VERR_ASN1_INVALID_OBJID_ENCODING" */
    '\x01','\xf2','\x0f','O','B','J','I','D','_','E','N','C','O','D','I','N','G',
/* 0x1adc0 = "VERR_VMX_INVALID_GUEST_STATE" */
    '\x01','V','M','X','_','\x0f','G','U','E','S','T','_','S','T','A','T','E',
/* 0x1add1 = "VERR_DBG_NOT_NM_MAP_FILE" */
    '\x01','D','B','G','_','\x14','N','M','_','M','A','P','_','F','I','L','E',
/* 0x1ade2 = "VERR_PATCHING_REFUSED" */
    '\x01','P','A','T','C','H','I','N','G','_','R','E','F','U','S','E','D',
/* 0x1adf3 = "VERR_VGA_INVALID_CUSTOM_MODE" */
    '\x01','V','G','A','_','\x0f','C','U','S','T','O','M','_','M','O','D','E',
/* 0x1ae04 = "No data for this block in image." */
    '\xd0','\x8f','\x0e','\xc9','b','l','o','c','k',' ','\x0d','i','m','a','g','e','.',
/* 0x1ae15 = "Call interrupted." */
    'C','a','l','l',' ','i','n','t','e','r','r','u','p','t','e','d','.',
/* 0x1ae26 = "Recompiler: Variable management internal processing error #8." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','8','.',
/* 0x1ae37 = "VERR_TOO_MANY_SEMAPHORES" */
    '\x01','\x9f','M','A','N','Y','_','S','E','M','A','P','H','O','R','E','S',
/* 0x1ae48 = "Bad file mode for XAR file." */
    '\x92','\x18','m','o','d','e',' ','\x0e','X','A','R',' ','f','i','l','e','.',
/* 0x1ae59 = "VERR_PGM_INVALID_PAGE_DIRECTORY" */
    '\x01','\xd7','\x0f','P','A','G','E','_','D','I','R','E','C','T','O','R','Y',
/* 0x1ae6a = "Pipe is not connected." */
    'P','i','p','e',' ','\x09','\x05','c','o','n','n','e','c','t','e','d','.',
/* 0x1ae7b = "Unknown I/O instruction." */
    '\xdf','I','/','O',' ','i','n','s','t','r','u','c','t','i','o','n','.',
/* 0x1ae8c = "VERR_TRPM_BAD_TRAP_IN_OP" */
    '\x01','T','R','P','M','_','\xa0','T','R','A','P','_','I','N','_','O','P',
/* 0x1ae9d = "VERR_INVALID_BASE64_ENCODING" */
    '\x01','\x0f','B','A','S','E','6','4','_','E','N','C','O','D','I','N','G',
/* 0x1aeae = "Invalid I/O port handle." */
    '\x0b','I','/','O',' ','p','o','r','t',' ','h','a','n','d','l','e','.',
/* 0x1aebf = "Import ISO contains more than volume." */
    '\xaf','\xb2',' ','\x7f','\xf6','t','h','a','n',' ','v','o','l','u','m','e','.',
/* 0x1aed0 = "VINF_VHWA_CMD_PENDING" */
    '\x19','V','H','W','A','_','C','M','D','_','P','E','N','D','I','N','G',
/* 0x1aee1 = "VERR_CR_STORE_GENERIC_ERROR" */
    '\x01','\xa9','S','T','O','R','E','_','G','E','N','E','R','I','C','_','\x9b',
/* 0x1aef2 = "VERR_XAR_TOC_DIGEST_MISMATCH" */
    '\x01','X','A','R','_','T','O','C','_','D','I','G','E','S','T','_','\x99',
/* 0x1af03 = "Device i/o: CRC error." */
    'D','e','v','i','c','e',' ','i','/','o',':',' ','C','R','C',' ','\x7b',
/* 0x1af14 = "Internal processing error #2 in the DBGF stack code." */
    '\x06','\x04','\x07','#','2',' ','\x0d','\x02','\xf1',' ','s','t','a','c','k',' ','\x5e',
/* 0x1af25 = "VINF_EM_RAW_IRET_TRAP" */
    '\x19','E','M','_','R','A','W','_','I','R','E','T','_','T','R','A','P',
/* 0x1af36 = "VERR_IOMMU_DTE_READ_FAILED" */
    '\x01','I','O','M','M','U','_','D','T','E','_','R','E','A','D','_','\x93',
/* 0x1af47 = "Recompiler: Variable management internal processing error #5." */
    '\x11','V','a','r','i','a','b','l','e',' ','\xfb','\x15','\x04','\x07','#','5','.',
/* 0x1af58 = "VERR_VD_VMDK_VALUE_NOT_FOUND" */
    '\x01','V','D','_','V','M','D','K','_','V','A','L','U','E','_','\x14','\xb3',
/* 0x1af69 = "Unexpected end of DWARF unit." */
    '\x85','e','n','d',' ','\x13','D','W','A','R','F',' ','u','n','i','t','.',
/* 0x1af7a = "Configuration value not found." */
    'C','o','n','f','i','g','u','r','a','t','i','o','n',' ','\xd2','\x05','\x7d',
/* 0x1af8b = "VERR_CR_X509_INTERNAL_ERROR" */
    '\x01','\xa9','X','5','0','9','_','I','N','T','E','R','N','A','L','_','\x9b',
/* 0x1af9c = "VERR_RT_REQUEST_STATE" */
    '\x01','R','T','_','R','E','Q','U','E','S','T','_','S','T','A','T','E',
/* 0x1afad = "VERR_SUP_VP_STUB_OPEN_ERROR" */
    '\x01','\xe6','V','P','_','S','T','U','B','_','O','P','E','N','_','\x9b',
/* 0x1afbd = "VERR_HTTP_REDIRECTED" */
    '\x01','H','T','T','P','_','R','E','D','I','R','E','C','T','E','D',
/* 0x1afcd = "Process Verification Failure: The process is being debugged." */
    '\x17','\x0c','\x12','\x03','\x82','\x09','\xdb','d','e','b','u','g','g','e','d','.',
/* 0x1afdd = "Internal processing error in the critical section code." */
    '\x06','\x04','\x07','\x0d','\x02','c','r','i','t','i','c','a','l',' ','\xc6','\x5e',
/* 0x1afed = "VERR_LDRVI_PARSE_IPE" */
    '\x01','L','D','R','V','I','_','P','A','R','S','E','_','I','P','E',
/* 0x1affd = "Receive timeout." */
    'R','e','c','e','i','v','e',' ','t','i','m','e','o','u','t','.',
/* 0x1b00d = "Recompiler: Out of variables." */
    '\x11','O','u','t',' ','\x13','v','a','r','i','a','b','l','e','s','.',
/* 0x1b01d = "VERR_HGCM_INVALID_CLIENT_ID" */
    '\x01','H','G','C','M','_','\x0f','C','L','I','E','N','T','_','I','D',
/* 0x1b02d = "VINF_CALLBACK_RETURN" */
    '\x19','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1b03d = "VERR_GIM_HYPERCALL_FAILED" */
    '\x01','G','I','M','_','H','Y','P','E','R','C','A','L','L','_','\x93',
/* 0x1b04d = "Already patched." */
    'A','l','r','e','a','d','y',' ','p','a','t','c','h','e','d','.',
/* 0x1b05d = "VERR_DIS_TOO_LONG_INSTR" */
    '\x01','D','I','S','_','\x9f','L','O','N','G','_','I','N','S','T','R',
/* 0x1b06d = "Invalid HGCM client id." */
    '\x0b','H','G','C','M',' ','c','l','i','e','n','t',' ','i','d','.',
/* 0x1b07d = "VERR_VFS_CHAIN_FINAL_TYPE_MISMATCH" */
    '\x01','\xa4','_','\xda','F','I','N','A','L','_','T','Y','P','E','_','\x99',
/* 0x1b08d = "VERR_IEM_EMIT_BAD_MEM_SIZE" */
    '\x01','\xee','E','M','I','T','_','\xa0','M','E','M','_','S','I','Z','E',
/* 0x1b09d = "VERR_PDM_DEVINS_NO_ATTACH" */
    '\x01','\xb8','D','E','V','I','N','S','_','\xb7','A','T','T','A','C','H',
/* 0x1b0ad = "VERR_CR_X509_NOT_VERIFIED" */
    '\x01','\xa9','X','5','0','9','_','\x14','V','E','R','I','F','I','E','D',
/* 0x1b0bd = "VERR_PDM_MEDIA_NOT_MOUNTED" */
    '\x01','\xb8','M','E','D','I','A','_','\x14','M','O','U','N','T','E','D',
/* 0x1b0cd = "VERR_GENERAL_FAILURE" */
    '\x01','G','E','N','E','R','A','L','_','F','A','I','L','U','R','E',
/* 0x1b0dd = "Patch installed." */
    'P','a','t','c','h',' ','i','n','s','t','a','l','l','e','d','.',
/* 0x1b0ed = "VERR_HM_ALREADY_ENABLED_IPE" */
    '\x01','H','M','_','\xed','E','N','A','B','L','E','D','_','I','P','E',
/* 0x1b0fd = "VERR_DBGF_NO_TRACE_BUFFER" */
    '\x01','\xf1','_','\xb7','T','R','A','C','E','_','B','U','F','F','E','R',
/* 0x1b10d = "VERR_RESOURCE_IN_USE" */
    '\x01','R','E','S','O','U','R','C','E','_','I','N','_','U','S','E',
/* 0x1b11d = "VINF_HGCM_SAVE_STATE" */
    '\x19','H','G','C','M','_','S','A','V','E','_','S','T','A','T','E',
/* 0x1b12d = "Error getting the file mode." */
    '\xac','g','e','t','t','i','n','g',' ','\x02','\x18','m','o','d','e','.',
/* 0x1b13d = "VERR_SEM_OUT_OF_TURN" */
    '\x01','S','E','M','_','O','U','T','_','O','F','_','T','U','R','N',
/* 0x1b14d = "VERR_PDM_DRVINS_NO_ATTACH" */
    '\x01','\xb8','D','R','V','I','N','S','_','\xb7','A','T','T','A','C','H',
/* 0x1b15d = "TM requires GIP." */
    'T','M',' ','r','e','q','u','i','r','e','s',' ','G','I','P','.',
/* 0x1b16d = "VERR_VD_VMDK_INVALID_FORMAT" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','F','O','R','M','A','T',
/* 0x1b17d = "VERR_PDM_THREAD_INVALID_CALLER" */
    '\x01','\xb8','T','H','R','E','A','D','_','\x0f','C','A','L','L','E','R',
/* 0x1b18d = "Expected RSA public key." */
    '\xa6','R','S','A',' ','p','u','b','l','i','c',' ','k','e','y','.',
/* 0x1b19d = "VERR_PATCH_ALREADY_DISABLED" */
    '\x01','P','A','T','C','H','_','\xed','D','I','S','A','B','L','E','D',
/* 0x1b1ad = "VINF_PGM_GCPHYS_ALIASED" */
    '\x19','\xd7','G','C','P','H','Y','S','_','A','L','I','A','S','E','D',
/* 0x1b1bd = "VERR_VRDP_PROTOCOL_ERROR" */
    '\x01','V','R','D','P','_','P','R','O','T','O','C','O','L','_','\x9b',
/* 0x1b1cd = "VERR_HOSTIF_BLOCKING" */
    '\x01','H','O','S','T','I','F','_','B','L','O','C','K','I','N','G',
/* 0x1b1dd = "VERR_INVALID_UTF16_ENCODING" */
    '\x01','\x0f','U','T','F','1','6','_','E','N','C','O','D','I','N','G',
/* 0x1b1ed = "VERR_VM_REQUEST_INVALID_TYPE" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','\x0f','T','Y','P','E',
/* 0x1b1fd = "VERR_PDM_USB_NAME_CLASH" */
    '\x01','\xb8','U','S','B','_','N','A','M','E','_','C','L','A','S','H',
/* 0x1b20d = "VERR_ISOMK_IPE_BOOT_CAT_FILE" */
    '\x01','\xaa','\x8e','B','O','O','T','_','C','A','T','_','F','I','L','E',
/* 0x1b21d = "VERR_VM_THREAD_IS_EMT" */
    '\x01','\xcf','_','T','H','R','E','A','D','_','I','S','_','E','M','T',
/* 0x1b22d = "VERR_VMX_INVALID_HOST_STATE" */
    '\x01','V','M','X','_','\x0f','H','O','S','T','_','S','T','A','T','E',
/* 0x1b23d = "VERR_IOM_NO_R3_MMIO_RANGE" */
    '\x01','I','O','M','_','\xb7','R','3','_','\xf4','_','R','A','N','G','E',
/* 0x1b24d = "VERR_SUPDRV_TRACER_ALREADY_OPENED" */
    '\x01','\xdc','T','R','A','C','E','R','_','\xed','O','P','E','N','E','D',
/* 0x1b25d = "Generic not found warning." */
    '\x96','\x05','f','o','u','n','d',' ','w','a','r','n','i','n','g','.',
/* 0x1b26d = "VERR_VD_ISCSI_INVALID_STATE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','S','T','A','T','E',
/* 0x1b27d = "VERR_VM_DRIVER_LOAD_ERROR" */
    '\x01','\xcf','_','D','R','I','V','E','R','_','L','O','A','D','_','\x9b',
/* 0x1b28d = "The system has too many CPUs." */
    '\x03','s','y','s','t','e','m',' ','\x1d','\x8c','\xa3','C','P','U','s','.',
/* 0x1b29d = "VERR_TM_TSC_ALREADY_TICKING" */
    '\x01','T','M','_','T','S','C','_','\xed','T','I','C','K','I','N','G',
/* 0x1b2ad = "VWRN_NUMBER_TOO_BIG" */
    'V','W','R','N','_','N','U','M','B','E','R','_','\x9f','B','I','G',
/* 0x1b2bd = "VERR_SUP_VP_FILE_MODE_ERROR" */
    '\x01','\xe6','V','P','_','F','I','L','E','_','M','O','D','E','_','\x9b',
/* 0x1b2cd = "VERR_SUPDRV_VTG_STRTAB_OFF" */
    '\x01','\xdc','V','T','G','_','S','T','R','T','A','B','_','O','F','F',
/* 0x1b2dd = "Generic VM-exit failure." */
    '\x96','\xcf','-','e','x','i','t',' ','f','a','i','l','u','r','e','.',
/* 0x1b2ed = "VERR_TAR_END_OF_FILE" */
    '\x01','T','A','R','_','E','N','D','_','O','F','_','F','I','L','E',
/* 0x1b2fd = "The I/O request was canceled." */
    '\x03','I','/','O',' ','\x94','\x10','c','a','n','c','e','l','e','d','.',
/* 0x1b30d = "Trailing spaces." */
    'T','r','a','i','l','i','n','g',' ','s','p','a','c','e','s','.',
/* 0x1b31d = "The poll set is full." */
    '\x03','p','o','l','l',' ','s','e','t',' ','\x09','f','u','l','l','.',
/* 0x1b32d = "VERR_NAT_REDIR_SETUP" */
    '\x01','N','A','T','_','R','E','D','I','R','_','S','E','T','U','P',
/* 0x1b33d = "VINF_IOM_MMIO_UNUSED_00" */
    '\x19','I','O','M','_','\xf4','_','U','N','U','S','E','D','_','0','0',
/* 0x1b34d = "VERR_CALLBACK_RETURN" */
    '\x01','C','A','L','L','B','A','C','K','_','R','E','T','U','R','N',
/* 0x1b35d = "VERR_MM_RAM_CONFLICT" */
    '\x01','M','M','_','R','A','M','_','C','O','N','F','L','I','C','T',
/* 0x1b36d = "VERR_CR_PKIX_GENERIC_ERROR" */
    '\x01','\xa9','P','K','I','X','_','G','E','N','E','R','I','C','_','\x9b',
/* 0x1b37d = "VERR_PATCH_NO_CONFLICT" */
    '\x01','P','A','T','C','H','_','\xb7','C','O','N','F','L','I','C','T',
/* 0x1b38d = "VERR_GMM_NOT_PAGE_OWNER" */
    '\x01','G','M','M','_','\x14','P','A','G','E','_','O','W','N','E','R',
/* 0x1b39d = "Unsupported file system format." */
    '\x87','\x18','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1b3ad = "VERR_SEM_LV_DEADLOCK" */
    '\x01','S','E','M','_','L','V','_','D','E','A','D','L','O','C','K',
/* 0x1b3bd = "Invalid opcode byte(s)." */
    '\x0b','o','p','c','o','d','e',' ','b','y','t','e','(','s',')','.',
/* 0x1b3cd = "VERR_PGM_DYNMAP_SETUP_ERROR" */
    '\x01','\xd7','D','Y','N','M','A','P','_','S','E','T','U','P','_','\x9b',
/* 0x1b3dd = "The key was decrypted." */
    '\x03','k','e','y',' ','\x10','d','e','c','r','y','p','t','e','d','.',
/* 0x1b3ed = "VERR_INTNET_FLT_IF_FAILED" */
    '\x01','I','N','T','N','E','T','_','F','L','T','_','I','F','_','\x93',
/* 0x1b3fd = "VERR_PGM_HANDY_PAGE_IPE" */
    '\x01','\xd7','H','A','N','D','Y','_','P','A','G','E','_','I','P','E',
/* 0x1b40d = "VERR_VD_VMDK_INVALID_HEADER" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','H','E','A','D','E','R',
/* 0x1b41d = "VERR_PDM_USB_HUB_EXISTS" */
    '\x01','\xb8','U','S','B','_','H','U','B','_','E','X','I','S','T','S',
/* 0x1b42d = "Local file header corrupt." */
    'L','o','c','a','l',' ','\x18','\xa2','c','o','r','r','u','p','t','.',
/* 0x1b43d = "VERR_SUPDRV_TRACER_NOT_OPENED" */
    '\x01','\xdc','T','R','A','C','E','R','_','\x14','O','P','E','N','E','D',
/* 0x1b44d = "VERR_PGM_SAVED_REC_TYPE" */
    '\x01','\xd7','S','A','V','E','D','_','R','E','C','_','T','Y','P','E',
/* 0x1b45d = "VERR_CR_X509_GENERIC_ERROR" */
    '\x01','\xa9','X','5','0','9','_','G','E','N','E','R','I','C','_','\x9b',
/* 0x1b46d = "Unexpected SVM patch type." */
    '\x85','S','V','M',' ','p','a','t','c','h',' ','t','y','p','e','.',
/* 0x1b47d = "VINF_IOM_MMIO_UNUSED_FF" */
    '\x19','I','O','M','_','\xf4','_','U','N','U','S','E','D','_','F','F',
/* 0x1b48d = "VERR_IEM_VAR_DUP_ARG_NO" */
    '\x01','\xee','V','A','R','_','D','U','P','_','A','R','G','_','N','O',
/* 0x1b49d = "VERR_TAR_BAD_MODE_FIELD" */
    '\x01','T','A','R','_','\xa0','M','O','D','E','_','F','I','E','L','D',
/* 0x1b4ad = "VERR_TM_GIP_REQUIRED" */
    '\x01','T','M','_','G','I','P','_','R','E','Q','U','I','R','E','D',
/* 0x1b4bd = "Syntax error - invalid operation attempted." */
    '\xe1','\x07','-',' ','\x81','\x83','a','t','t','e','m','p','t','e','d','.',
/* 0x1b4cd = "VERR_SSM_UNIT_NOT_OWNER" */
    '\x01','S','S','M','_','U','N','I','T','_','\x14','O','W','N','E','R',
/* 0x1b4dd = "VERR_SSM_FIELD_INVALID_SIZE" */
    '\x01','S','S','M','_','F','I','E','L','D','_','\x0f','S','I','Z','E',
/* 0x1b4ed = "VERR_NET_UNREACHABLE" */
    '\x01','N','E','T','_','U','N','R','E','A','C','H','A','B','L','E',
/* 0x1b4fd = "Patch was already enabled." */
    'P','a','t','c','h',' ','\x10','\x22','e','n','a','b','l','e','d','.',
/* 0x1b50d = "VERR_GIM_OPERATION_FAILED" */
    '\x01','G','I','M','_','O','P','E','R','A','T','I','O','N','_','\x93',
/* 0x1b51d = "Invalid segment offset." */
    '\x0b','s','e','g','m','e','n','t',' ','o','f','f','s','e','t','.',
/* 0x1b52d = "Unknown file system format." */
    '\xdf','\x18','s','y','s','t','e','m',' ','f','o','r','m','a','t','.',
/* 0x1b53d = "VERR_SUP_VP_BAD_IMAGE_SIZE" */
    '\x01','\xe6','V','P','_','\xa0','I','M','A','G','E','_','S','I','Z','E',
/* 0x1b54d = "VINF_VMM_CALL_TRACER" */
    '\x19','V','M','M','_','C','A','L','L','_','T','R','A','C','E','R',
/* 0x1b55d = "VERR_ASN1_TOO_DEEPLY_NESTED" */
    '\x01','\xf2','\x9f','D','E','E','P','L','Y','_','N','E','S','T','E','D',
/* 0x1b56d = "VERR_TRAILING_SPACES" */
    '\x01','T','R','A','I','L','I','N','G','_','S','P','A','C','E','S',
/* 0x1b57d = "VERR_SELM_GDT_READ_ERROR" */
    '\x01','S','E','L','M','_','G','D','T','_','R','E','A','D','_','\x9b',
/* 0x1b58d = "VERR_WEB_INVALID_SESSION_ID" */
    '\x01','W','E','B','_','\x0f','S','E','S','S','I','O','N','_','I','D',
/* 0x1b59d = "VERR_CR_RANDOM_SETUP_FAILED" */
    '\x01','\xa9','R','A','N','D','O','M','_','S','E','T','U','P','_','\x93',
/* 0x1b5ad = "The table of content (TOC) is too big." */
    '\x03','\x9e','\x13','\xd8','(','T','O','C',')',' ','\x09','\x8c','b','i','g','.',
/* 0x1b5bd = "VERR_PROCESS_RUNNING" */
    '\x01','P','R','O','C','E','S','S','_','R','U','N','N','I','N','G',
/* 0x1b5cd = "Bad VTG bit count value." */
    '\x92','V','T','G',' ','b','i','t',' ','c','o','u','n','t',' ','\xd3',
/* 0x1b5dd = "Internal processing error in the page allocator." */
    '\x06','\x04','\x07','\x0d','\x02','\xb6','a','l','l','o','c','a','t','o','r','.',
/* 0x1b5ed = "SSL connection error." */
    'S','S','L',' ','c','o','n','n','e','c','t','i','o','n',' ','\x7b',
/* 0x1b5fd = "VERR_UDP_SERVER_STOP" */
    '\x01','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b60d = "Comment string is too long." */
    'C','o','m','m','e','n','t',' ','\xc7','\x09','\x8c','l','o','n','g','.',
/* 0x1b61d = "VINF_PDM_PCI_DO_DEFAULT" */
    '\x19','\xb8','P','C','I','_','D','O','_','D','E','F','A','U','L','T',
/* 0x1b62d = "VERR_ISOFS_BAD_LVD_DOMAIN_ID" */
    '\x01','\xfd','\xa0','L','V','D','_','D','O','M','A','I','N','_','I','D',
/* 0x1b63d = "VERR_VMM_HYPER_CR3_MISMATCH" */
    '\x01','V','M','M','_','H','Y','P','E','R','_','C','R','3','_','\x99',
/* 0x1b64d = "Bad argument flags." */
    '\x92','a','r','g','u','m','e','n','t',' ','f','l','a','g','s','.',
/* 0x1b65d = "VERR_VD_VDI_UNSUPPORTED_VERSION" */
    '\x01','V','D','_','V','D','I','_','\x9d','V','E','R','S','I','O','N',
/* 0x1b66d = "VERR_LDR_NO_IMAGE_UUID" */
    '\x01','L','D','R','_','\xb7','I','M','A','G','E','_','U','U','I','D',
/* 0x1b67d = "Unknown or invalid GIM provider." */
    '\xdf','\x86','\x81','G','I','M',' ','p','r','o','v','i','d','e','r','.',
/* 0x1b68d = "VERR_DWARF_ABBREV_NOT_FOUND" */
    '\x01','D','W','A','R','F','_','A','B','B','R','E','V','_','\x14','\xb3',
/* 0x1b69d = "Bad DWARF position." */
    '\x92','D','W','A','R','F',' ','p','o','s','i','t','i','o','n','.',
/* 0x1b6ad = "VERR_VM_DRIVER_OPEN_ERROR" */
    '\x01','\xcf','_','D','R','I','V','E','R','_','O','P','E','N','_','\x9b',
/* 0x1b6bd = "VINF_EM_TRIPLE_FAULT" */
    '\x19','E','M','_','T','R','I','P','L','E','_','F','A','U','L','T',
/* 0x1b6cd = "The XAR table of content digest doesn't match." */
    '\x03','X','A','R',' ','\x9e','\x13','\xd8','\xc2','\xa5','m','a','t','c','h','.',
/* 0x1b6dd = "Failed to map a memory object." */
    '\x80','\x08','m','a','p',' ','a',' ','\x5c','o','b','j','e','c','t','.',
/* 0x1b6ed = "VERR_TCP_SERVER_STOP" */
    '\x01','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b6fd = "VERR_DIS_GEN_FAILURE" */
    '\x01','D','I','S','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x1b70d = "VERR_PGM_MAPPINGS_FIXED" */
    '\x01','\xd7','M','A','P','P','I','N','G','S','_','F','I','X','E','D',
/* 0x1b71d = "VINF_VMM_UNKNOWN_RING3_CALL" */
    '\x19','V','M','M','_','\xde','R','I','N','G','3','_','C','A','L','L',
/* 0x1b72d = "VERR_SUPDRV_VTG_BAD_HDR_TOO_MUCH" */
    '\x01','\xdc','V','T','G','_','\xa0','H','D','R','_','\x9f','M','U','C','H',
/* 0x1b73d = "VERR_SUPDRV_VTG_BAD_PROBE_LOC" */
    '\x01','\xdc','V','T','G','_','\xa0','P','R','O','B','E','_','L','O','C',
/* 0x1b74d = "VERR_NEM_MAP_PAGES_FAILED" */
    '\x01','N','E','M','_','M','A','P','_','P','A','G','E','S','_','\x93',
/* 0x1b75d = "Encountered an unexpected VM state." */
    '\x97','\x60','u','n','e','x','p','e','c','t','e','d',' ','\xcf',' ','\xf5',
/* 0x1b76d = "VERR_FLOAT_UNDERFLOW" */
    '\x01','F','L','O','A','T','_','U','N','D','E','R','F','L','O','W',
/* 0x1b77d = "VERR_HGCM_SERVICE_NOT_FOUND" */
    '\x01','H','G','C','M','_','S','E','R','V','I','C','E','_','\x14','\xb3',
/* 0x1b78d = "Unbalanced tree." */
    'U','n','b','a','l','a','n','c','e','d',' ','t','r','e','e','.',
/* 0x1b79d = "VERR_CPUM_RAISE_GP_0" */
    '\x01','C','P','U','M','_','R','A','I','S','E','_','G','P','_','0',
/* 0x1b7ad = "VERR_CFGM_INVALID_NODE_PATH" */
    '\x01','C','F','G','M','_','\x0f','N','O','D','E','_','P','A','T','H',
/* 0x1b7bd = "VINF_HM_PENDING_XCPT" */
    '\x19','H','M','_','P','E','N','D','I','N','G','_','X','C','P','T',
/* 0x1b7cd = "VINF_PATM_PATCH_INT3" */
    '\x19','P','A','T','M','_','P','A','T','C','H','_','I','N','T','3',
/* 0x1b7dd = "VERR_BUFFER_OVERFLOW" */
    '\x01','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1b7ed = "Unsupported X.509 certificate version." */
    '\x87','X','.','5','0','9',' ','\x8a','v','e','r','s','i','o','n','.',
/* 0x1b7fd = "Fatal EMT wait error." */
    'F','a','t','a','l',' ','E','M','T',' ','w','a','i','t',' ','\x7b',
/* 0x1b80d = "VERR_ASN1_CURSOR_NOT_AT_END" */
    '\x01','\xf2','C','U','R','S','O','R','_','\x14','A','T','_','E','N','D',
/* 0x1b81d = "VERR_TM_TOO_MANY_TIMERS" */
    '\x01','T','M','_','\x9f','M','A','N','Y','_','T','I','M','E','R','S',
/* 0x1b82d = "VERR_DBGF_HYPER_DB_XCPT" */
    '\x01','\xf1','_','H','Y','P','E','R','_','D','B','_','X','C','P','T',
/* 0x1b83d = "VINF_UDP_SERVER_STOP" */
    '\x19','U','D','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b84d = "Internal processing error #1 in the DBGF core code." */
    '\x06','\x04','\x07','#','1',' ','\x0d','\x02','\xf1',' ','c','o','r','e',' ','\x5e',
/* 0x1b85d = "VERR_VM_REQUEST_STATE" */
    '\x01','\xcf','_','R','E','Q','U','E','S','T','_','S','T','A','T','E',
/* 0x1b86d = "VERR_TM_TIMER_BAD_CLOCK" */
    '\x01','T','M','_','T','I','M','E','R','_','\xa0','C','L','O','C','K',
/* 0x1b87d = "VINF_PATM_SPINLOCK_FAILED" */
    '\x19','P','A','T','M','_','S','P','I','N','L','O','C','K','_','\x93',
/* 0x1b88d = "Receive aborted." */
    'R','e','c','e','i','v','e',' ','a','b','o','r','t','e','d','.',
/* 0x1b89d = "VERR_TAR_ZERO_HEADER" */
    '\x01','T','A','R','_','Z','E','R','O','_','H','E','A','D','E','R',
/* 0x1b8ad = "VERR_LDR_INVALID_SEG_OFFSET" */
    '\x01','L','D','R','_','\x0f','S','E','G','_','O','F','F','S','E','T',
/* 0x1b8bd = "VINF_HM_DOUBLE_FAULT" */
    '\x19','H','M','_','D','O','U','B','L','E','_','F','A','U','L','T',
/* 0x1b8cd = "VINF_GVM_NOT_BUSY_IN_GC" */
    '\x19','G','V','M','_','\x14','B','U','S','Y','_','I','N','_','G','C',
/* 0x1b8dd = "The specified data unit wasn\'t found." */
    '\x03','\x16','\x8f','u','n','i','t',' ','w','a','s','n','\'','t',' ','\x7d',
/* 0x1b8ed = "VINF_TCP_SERVER_STOP" */
    '\x19','T','C','P','_','S','E','R','V','E','R','_','S','T','O','P',
/* 0x1b8fd = "VERR_CPUM_INVALID_XSAVE_HDR" */
    '\x01','C','P','U','M','_','\x0f','X','S','A','V','E','_','H','D','R',
/* 0x1b90d = "VERR_PDM_NO_DMAC_INSTANCE" */
    '\x01','\xb8','\xb7','D','M','A','C','_','I','N','S','T','A','N','C','E',
/* 0x1b91d = "VERR_PDM_CRITSECTRW_IPE" */
    '\x01','\xb8','C','R','I','T','S','E','C','T','R','W','_','I','P','E',
/* 0x1b92d = "VERR_PRIVILEGE_NOT_HELD" */
    '\x01','P','R','I','V','I','L','E','G','E','_','\x14','H','E','L','D',
/* 0x1b93d = "VERR_EXCL_SEM_ALREADY_OWNED" */
    '\x01','E','X','C','L','_','S','E','M','_','\xed','O','W','N','E','D',
/* 0x1b94d = "VERR_JSON_INVALID_CODEPOINT" */
    '\x01','J','S','O','N','_','\x0f','C','O','D','E','P','O','I','N','T',
/* 0x1b95d = "VERR_ISOMK_IMPORT_INVALID_VOL_DESC_HDR" */
    '\x01','\xaa','\xd4','\x0f','V','O','L','_','D','E','S','C','_','H','D','R',
/* 0x1b96d = "VERR_ASN1_INVALID_NULL_ENCODING" */
    '\x01','\xf2','\x0f','N','U','L','L','_','E','N','C','O','D','I','N','G',
/* 0x1b97d = "VERR_XAR_BAD_FILE_INODE" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','I','N','O','D','E',
/* 0x1b98d = "VERR_ALLOCATION_TOO_BIG" */
    '\x01','A','L','L','O','C','A','T','I','O','N','_','\x9f','B','I','G',
/* 0x1b99d = "VERR_TRPM_DONT_PANIC" */
    '\x01','T','R','P','M','_','D','O','N','T','_','P','A','N','I','C',
/* 0x1b9ad = "VERR_SVM_UNEXPECTED_PATCH_TYPE" */
    '\x01','S','V','M','_','\xce','P','A','T','C','H','_','T','Y','P','E',
/* 0x1b9bd = "VERR_TM_INVALID_TIMER_QUEUE" */
    '\x01','T','M','_','\x0f','T','I','M','E','R','_','Q','U','E','U','E',
/* 0x1b9cd = "Logical Unit was not found." */
    'L','o','g','i','c','a','l',' ','U','n','i','t',' ','\x10','\x05','\x7d',
/* 0x1b9dd = "VERR_LDRPE_GLOBALPTR" */
    '\x01','L','D','R','P','E','_','G','L','O','B','A','L','P','T','R',
/* 0x1b9ed = "VERR_PDM_NO_APIC_INSTANCE" */
    '\x01','\xb8','\xb7','A','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1b9fd = "VERR_VMM_SWITCHER_IPE_1" */
    '\x01','V','M','M','_','S','W','I','T','C','H','E','R','_','\x8e','1',
/* 0x1ba0d = "Bad MH_OBJECT file." */
    '\x92','M','H','_','O','B','J','E','C','T',' ','f','i','l','e','.',
/* 0x1ba1d = "VERR_NET_PROTOCOL_NOT_SUPPORTED" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x14','\xc5',
/* 0x1ba2d = "VWRN_VRDP_PDU_NOT_SUPPORTED" */
    'V','W','R','N','_','V','R','D','P','_','P','D','U','_','\x14','\xc5',
/* 0x1ba3d = "VERR_MANIFEST_FILE_MISMATCH" */
    '\x01','M','A','N','I','F','E','S','T','_','F','I','L','E','_','\x99',
/* 0x1ba4d = "Vote for giving up." */
    'V','o','t','e',' ','\x0e','g','i','v','i','n','g',' ','u','p','.',
/* 0x1ba5d = "NEM is not available." */
    'N','E','M',' ','\x09','\x05','a','v','a','i','l','a','b','l','e','.',
/* 0x1ba6d = "VERR_LDRLX_BAD_PAGE_MAP" */
    '\x01','L','D','R','L','X','_','\xa0','P','A','G','E','_','M','A','P',
/* 0x1ba7d = "VINF_BUFFER_OVERFLOW" */
    '\x19','B','U','F','F','E','R','_','O','V','E','R','F','L','O','W',
/* 0x1ba8d = "Bad VTG attribute value." */
    '\x92','V','T','G',' ','a','t','t','r','i','b','u','t','e',' ','\xd3',
/* 0x1ba9d = "VERR_XAR_WRONG_MAGIC" */
    '\x01','X','A','R','_','W','R','O','N','G','_','M','A','G','I','C',
/* 0x1baad = "VERR_PIPE_NOT_CONNECTED" */
    '\x01','P','I','P','E','_','\x14','C','O','N','N','E','C','T','E','D',
/* 0x1babd = "VERR_SUP_VP_BAD_IMAGE_BASE" */
    '\x01','\xe6','V','P','_','\xa0','I','M','A','G','E','_','B','A','S','E',
/* 0x1bacd = "VERR_NET_IN_PROGRESS" */
    '\x01','N','E','T','_','I','N','_','P','R','O','G','R','E','S','S',
/* 0x1badd = "VERR_DVM_MAP_NO_VOLUME" */
    '\x01','D','V','M','_','M','A','P','_','\xb7','V','O','L','U','M','E',
/* 0x1baed = "VERR_URI_INVALID_ESCAPE_SEQ" */
    '\x01','U','R','I','_','\x0f','E','S','C','A','P','E','_','S','E','Q',
/* 0x1bafd = "VERR_TIMER_SUSPENDED" */
    '\x01','T','I','M','E','R','_','S','U','S','P','E','N','D','E','D',
/* 0x1bb0d = "VERR_TAR_BASE_256_NOT_SUPPORTED" */
    '\x01','T','A','R','_','B','A','S','E','_','2','5','6','_','\x14','\xc5',
/* 0x1bb1d = "VERR_SSM_UNIT_EXISTS" */
    '\x01','S','S','M','_','U','N','I','T','_','E','X','I','S','T','S',
/* 0x1bb2d = "VERR_HARDAVL_BAD_HEIGHT" */
    '\x01','H','A','R','D','A','V','L','_','\xa0','H','E','I','G','H','T',
/* 0x1bb3d = "Encountered an unknown load command." */
    '\x97','\x60','\xfc','l','o','a','d',' ','c','o','m','m','a','n','d','.',
/* 0x1bb4d = "Process Verification Failure: The memory content does not match the image file." */
    '\x17','\x0c','\x12','\x03','\x5c','\xd8','\x9c','\x05','\xe3','\x02','\x1a','f','i','l','e','.',
/* 0x1bb5d = "VERR_SUPDRV_VTG_BAD_PROVIDER" */
    '\x01','\xdc','V','T','G','_','\xa0','P','R','O','V','I','D','E','R',
/* 0x1bb6c = "Virtual HDD is not opened." */
    '\xe2',' ','H','D','D',' ','\x09','\x05','o','p','e','n','e','d','.',
/* 0x1bb7b = "VERR_LDR_NOT_FORWARDER" */
    '\x01','L','D','R','_','\x14','F','O','R','W','A','R','D','E','R',
/* 0x1bb8a = "VERR_SIGNAL_REFUSED" */
    '\x01','S','I','G','N','A','L','_','R','E','F','U','S','E','D',
/* 0x1bb99 = "Invalid host bit mask." */
    '\x0b','h','o','s','t',' ','b','i','t',' ','m','a','s','k','.',
/* 0x1bba8 = "VERR_SHCLPB_GUEST_ERROR" */
    '\x01','S','H','C','L','P','B','_','G','U','E','S','T','_','\x9b',
/* 0x1bbb7 = "VERR_IO_GEN_FAILURE" */
    '\x01','I','O','_','G','E','N','_','F','A','I','L','U','R','E',
/* 0x1bbc6 = "The specified path was not absolute (hardening)." */
    '\x03','\x16','\xbb','\x10','\x05','a','b','s','o','l','u','t','e',' ','\x9a',
/* 0x1bbd5 = "VWRN_INVALID_PARAMETER" */
    'V','W','R','N','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1bbe4 = "Wrong JSON type for string value." */
    'W','r','o','n','g',' ','J','S','O','N',' ','\xd9','\x0e','\xc7','\xd3',
/* 0x1bbf3 = "VINF_DBGF_BP_ALREADY_DISABLED" */
    '\x19','\xf1','_','B','P','_','\xed','D','I','S','A','B','L','E','D',
/* 0x1bc02 = "VERR_SSM_NO_LOAD_EXEC" */
    '\x01','S','S','M','_','\xb7','L','O','A','D','_','E','X','E','C',
/* 0x1bc11 = "VERR_VD_ISCSI_INVALID_TYPE" */
    '\x01','V','D','_','I','S','C','S','I','_','\x0f','T','Y','P','E',
/* 0x1bc20 = "VERR_VMX_INVALID_VMXON_PTR" */
    '\x01','V','M','X','_','\x0f','V','M','X','O','N','_','P','T','R',
/* 0x1bc2f = "VERR_SUPDRV_VTG_BAD_HDR_TOO_FEW" */
    '\x01','\xdc','V','T','G','_','\xa0','H','D','R','_','\x9f','F','E','W',
/* 0x1bc3e = "VERR_NOT_DATA_SELECTOR" */
    '\x01','\x14','D','A','T','A','_','S','E','L','E','C','T','O','R',
/* 0x1bc4d = "VERR_VD_VDI_INVALID_HEADER" */
    '\x01','V','D','_','V','D','I','_','\x0f','H','E','A','D','E','R',
/* 0x1bc5c = "Invalid guest LDT selector." */
    '\x0b','\xa1','L','D','T',' ','s','e','l','e','c','t','o','r','.',
/* 0x1bc6b = "Patch was removed." */
    'P','a','t','c','h',' ','\x10','r','e','m','o','v','e','d','.',
/* 0x1bc7a = "The trace log version is not supported." */
    '\x03','t','r','a','c','e',' ','l','o','g',' ','\xb4','\x09','\x05','\x95',
/* 0x1bc89 = "The HGCM is saving state." */
    '\x03','H','G','C','M',' ','\x09','s','a','v','i','n','g',' ','\xf5',
/* 0x1bc98 = "Process Verification Failure: Bad section raw data size." */
    '\x17','\x0c','\x12','\x92','\xc6','r','a','w',' ','\x8f','s','i','z','e','.',
/* 0x1bca7 = "VERR_SUPLIB_FSTAT_FAILED" */
    '\x01','S','U','P','L','I','B','_','F','S','T','A','T','_','\x93',
/* 0x1bcb6 = "Reason for leaving RZ: MMIO write." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf4',' ','w','r','i','t','e','.',
/* 0x1bcc5 = "VWRN_DBGF_ALREADY_RUNNING" */
    'V','W','R','N','_','\xf1','_','\xed','R','U','N','N','I','N','G',
/* 0x1bcd4 = "VINF_EM_DBG_STEPPED" */
    '\x19','E','M','_','D','B','G','_','S','T','E','P','P','E','D',
/* 0x1bce3 = "VERR_LOG_REVISION_MISMATCH" */
    '\x01','L','O','G','_','R','E','V','I','S','I','O','N','_','\x99',
/* 0x1bcf2 = "VERR_GSTCTL_GUEST_ERROR" */
    '\x01','G','S','T','C','T','L','_','G','U','E','S','T','_','\x9b',
/* 0x1bd01 = "VERR_SUPDRV_VTG_BAD_HDR_MISC" */
    '\x01','\xdc','V','T','G','_','\xa0','H','D','R','_','M','I','S','C',
/* 0x1bd10 = "VERR_FLOAT_OVERFLOW" */
    '\x01','F','L','O','A','T','_','O','V','E','R','F','L','O','W',
/* 0x1bd1f = "Bad VTG header - to high value." */
    '\x92','V','T','G',' ','\xa2','-',' ','\x08','h','i','g','h',' ','\xd3',
/* 0x1bd2e = "VERR_DRIVE_IS_EMPTY" */
    '\x01','D','R','I','V','E','_','I','S','_','E','M','P','T','Y',
/* 0x1bd3d = "Recompiler: Out of memory for fixups." */
    '\x11','O','u','t',' ','\x13','\x5c','\x0e','f','i','x','u','p','s','.',
/* 0x1bd4c = "Patch disabled." */
    'P','a','t','c','h',' ','d','i','s','a','b','l','e','d','.',
/* 0x1bd5b = "VERR_TM_GIP_VERSION" */
    '\x01','T','M','_','G','I','P','_','V','E','R','S','I','O','N',
/* 0x1bd6a = "VERR_VSCSI_LUN_BUSY" */
    '\x01','V','S','C','S','I','_','L','U','N','_','B','U','S','Y',
/* 0x1bd79 = "VINF_GETOPT_NOT_OPTION" */
    '\x19','G','E','T','O','P','T','_','\x14','O','P','T','I','O','N',
/* 0x1bd88 = "Unable to decode date value." */
    '\xca','\x08','d','e','c','o','d','e',' ','d','a','t','e',' ','\xd3',
/* 0x1bd97 = "VERR_FILE_LOCK_LOST" */
    '\x01','F','I','L','E','_','L','O','C','K','_','L','O','S','T',
/* 0x1bda6 = "VERR_TAR_NOT_USTAR_V00" */
    '\x01','T','A','R','_','\x14','U','S','T','A','R','_','V','0','0',
/* 0x1bdb5 = "Raw mode doesn't support SMP." */
    'R','a','w',' ','m','o','d','e',' ','\xa5','\xb1','S','M','P','.',
/* 0x1bdc4 = "Data size overflow." */
    'D','a','t','a',' ','\xf8','o','v','e','r','f','l','o','w','.',
/* 0x1bdd3 = "VERR_PATCH_ALREADY_ENABLED" */
    '\x01','P','A','T','C','H','_','\xed','E','N','A','B','L','E','D',
/* 0x1bde2 = "Too many CPUID leaves." */
    '\xf0','\xa3','C','P','U','I','D',' ','l','e','a','v','e','s','.',
/* 0x1bdf1 = "VERR_CR_KEY_NO_DEK_INFO" */
    '\x01','\xa9','K','E','Y','_','\xb7','D','E','K','_','I','N','F','O',
/* 0x1be00 = "VERR_ISOFS_FSD_UNSUPPORTED_CHAR_SET" */
    '\x01','\xfd','F','S','D','_','\x9d','C','H','A','R','_','S','E','T',
/* 0x1be0f = "VERR_MEDIA_NOT_PRESENT" */
    '\x01','M','E','D','I','A','_','\x14','P','R','E','S','E','N','T',
/* 0x1be1e = "VERR_PGM_PAE_PDPE_RSVD" */
    '\x01','\xd7','P','A','E','_','P','D','P','E','_','R','S','V','D',
/* 0x1be2d = "VFS chain element provider not found." */
    '\xa4',' ','\x91','\x1f','p','r','o','v','i','d','e','r',' ','\x05','\x7d',
/* 0x1be3c = "VERR_VM_FATAL_WAIT_ERROR" */
    '\x01','\xcf','_','F','A','T','A','L','_','W','A','I','T','_','\x9b',
/* 0x1be4b = "Installation has failed." */
    'I','n','s','t','a','l','l','a','t','i','o','n',' ','\x1d','\x24',
/* 0x1be5a = "Recompiler: Out of memory for labels." */
    '\x11','O','u','t',' ','\x13','\x5c','\x0e','l','a','b','e','l','s','.',
/* 0x1be69 = "VERR_IEM_INVALID_ADDRESS_MODE" */
    '\x01','\xee','\x0f','A','D','D','R','E','S','S','_','M','O','D','E',
/* 0x1be78 = "VERR_IEM_INVALID_INSTR_LENGTH" */
    '\x01','\xee','\x0f','I','N','S','T','R','_','L','E','N','G','T','H',
/* 0x1be87 = "Bad VTG header - offset." */
    '\x92','V','T','G',' ','\xa2','-',' ','o','f','f','s','e','t','.',
/* 0x1be96 = "VERR_NEM_VM_CREATE_FAILED" */
    '\x01','N','E','M','_','\xcf','_','C','R','E','A','T','E','_','\x93',
/* 0x1bea5 = "VERR_NEM_NOT_AVAILABLE" */
    '\x01','N','E','M','_','\x14','A','V','A','I','L','A','B','L','E',
/* 0x1beb4 = "VERR_IPC_SEND_MAP_FAILED" */
    '\x01','I','P','C','_','S','E','N','D','_','M','A','P','_','\x93',
/* 0x1bec3 = "VERR_PDM_NO_PIC_INSTANCE" */
    '\x01','\xb8','\xb7','P','I','C','_','I','N','S','T','A','N','C','E',
/* 0x1bed2 = "VINF_PATCH_CONTINUE" */
    '\x19','P','A','T','C','H','_','C','O','N','T','I','N','U','E',
/* 0x1bee1 = "VERR_IS_A_DIRECTORY" */
    '\x01','I','S','_','A','_','D','I','R','E','C','T','O','R','Y',
/* 0x1bef0 = "The specified data unit already exist." */
    '\x03','\x16','\x8f','u','n','i','t',' ','\x22','e','x','i','s','t','.',
/* 0x1beff = "VERR_SUPDRV_TRACER_TOO_LARGE" */
    '\x01','\xdc','T','R','A','C','E','R','_','\x9f','L','A','R','G','E',
/* 0x1bf0e = "VERR_CR_KEY_GEN_FAILED_RSA" */
    '\x01','\xa9','K','E','Y','_','G','E','N','_','\x93','_','R','S','A',
/* 0x1bf1d = "VERR_JSON_MALFORMED" */
    '\x01','J','S','O','N','_','M','A','L','F','O','R','M','E','D',
/* 0x1bf2c = "VERR_INSTALLATION_FAILED" */
    '\x01','I','N','S','T','A','L','L','A','T','I','O','N','_','\x93',
/* 0x1bf3b = "VINF_IOM_R3_MMIO_WRITE" */
    '\x19','I','O','M','_','R','3','_','\xf4','_','W','R','I','T','E',
/* 0x1bf4a = "VERR_IOM_MMIO_RANGE_NOT_FOUND" */
    '\x01','I','O','M','_','\xf4','_','R','A','N','G','E','_','\x14','\xb3',
/* 0x1bf59 = "VERR_VD_VMDK_INVALID_STATE" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','S','T','A','T','E',
/* 0x1bf68 = "PML4 entry not present." */
    'P','M','L','4',' ','\xb5','\x05','p','r','e','s','e','n','t','.',
/* 0x1bf77 = "The digest algorithm is not known to us." */
    '\x03','\xc2','\xbe','\x09','\x05','k','n','o','w','n',' ','\x08','u','s','.',
/* 0x1bf86 = "VERR_NET_PROTOCOL_ERROR" */
    '\x01','N','E','T','_','P','R','O','T','O','C','O','L','_','\x9b',
/* 0x1bf95 = "VERR_PDM_MEDIA_MOUNTED" */
    '\x01','\xb8','M','E','D','I','A','_','M','O','U','N','T','E','D',
/* 0x1bfa4 = "VERR_ISOFS_BAD_TAG_CHECKSUM" */
    '\x01','\xfd','\xa0','T','A','G','_','C','H','E','C','K','S','U','M',
/* 0x1bfb3 = "Invalid dotted string." */
    '\x0b','d','o','t','t','e','d',' ','s','t','r','i','n','g','.',
/* 0x1bfc2 = "VERR_VD_GEN_INVALID_HEADER" */
    '\x01','V','D','_','G','E','N','_','\x0f','H','E','A','D','E','R',
/* 0x1bfd1 = "VERR_CR_KEY_ENCRYPTED" */
    '\x01','\xa9','K','E','Y','_','E','N','C','R','Y','P','T','E','D',
/* 0x1bfe0 = "VERR_DIS_INVALID_PARAMETER" */
    '\x01','D','I','S','_','\x0f','P','A','R','A','M','E','T','E','R',
/* 0x1bfef = "VERR_VD_RAW_INVALID_HEADER" */
    '\x01','V','D','_','R','A','W','_','\x0f','H','E','A','D','E','R',
/* 0x1bffe = "Invalid VMXON pointer." */
    '\x0b','V','M','X','O','N',' ','p','o','i','n','t','e','r','.',
/* 0x1c00d = "Repairing the image is not supported." */
    'R','e','p','a','i','r','i','n','g',' ','\x02','\x1a','\x09','\x05','\x95',
/* 0x1c01c = "Bad symbol table entry." */
    '\x92','s','y','m','b','o','l',' ','\x9e','e','n','t','r','y','.',
/* 0x1c02b = "VERR_TAR_SIZE_NOT_ZERO" */
    '\x01','T','A','R','_','S','I','Z','E','_','\x14','Z','E','R','O',
/* 0x1c03a = "VERR_ASN1_INVALID_DATA_POINTER" */
    '\x01','\xf2','\x0f','D','A','T','A','_','P','O','I','N','T','E','R',
/* 0x1c049 = "VERR_SEM_OWNER_DIED" */
    '\x01','S','E','M','_','O','W','N','E','R','_','D','I','E','D',
/* 0x1c058 = "VERR_XAR_BAD_FILE_MODE" */
    '\x01','X','A','R','_','\xa0','F','I','L','E','_','M','O','D','E',
/* 0x1c067 = "VERR_PGM_NOT_USED_IN_MODE" */
    '\x01','\xd7','\x14','U','S','E','D','_','I','N','_','M','O','D','E',
/* 0x1c076 = "VERR_SHCLPB_EVENT_FAILED" */
    '\x01','S','H','C','L','P','B','_','E','V','E','N','T','_','\x93',
/* 0x1c085 = "VERR_SUP_VP_IMAGE_TOO_BIG" */
    '\x01','\xe6','V','P','_','I','M','A','G','E','_','\x9f','B','I','G',
/* 0x1c094 = "VERR_SIGNAL_INVALID" */
    '\x01','S','I','G','N','A','L','_','I','N','V','A','L','I','D',
/* 0x1c0a3 = "Too many MMIO2 ranges." */
    '\xf0','\xa3','M','M','I','O','2',' ','r','a','n','g','e','s','.',
/* 0x1c0b2 = "VERR_SUP_VP_SYSFER_DLL" */
    '\x01','\xe6','V','P','_','S','Y','S','F','E','R','_','D','L','L',
/* 0x1c0c1 = "VERR_NEM_RING3_ONLY" */
    '\x01','N','E','M','_','R','I','N','G','3','_','O','N','L','Y',
/* 0x1c0d0 = "VERR_SIGNAL_PENDING" */
    '\x01','S','I','G','N','A','L','_','P','E','N','D','I','N','G',
/* 0x1c0df = "VERR_XAR_INVALID_FILE_NAME" */
    '\x01','X','A','R','_','\x0f','F','I','L','E','_','N','A','M','E',
/* 0x1c0ee = "Image hash mismatch." */
    '\xfe','h','a','s','h',' ','m','i','s','m','a','t','c','h','.',
/* 0x1c0fd = "VERR_VFS_BOGUS_OFFSET" */
    '\x01','\xa4','_','B','O','G','U','S','_','O','F','F','S','E','T',
/* 0x1c10c = "VERR_CR_SPC_GENERIC_ERROR" */
    '\x01','\xa9','S','P','C','_','G','E','N','E','R','I','C','_','\x9b',
/* 0x1c11b = "VERR_TAR_UNKNOWN_TYPE_FLAG" */
    '\x01','T','A','R','_','\xde','T','Y','P','E','_','F','L','A','G',
/* 0x1c12a = "VERR_VMX_UNEXPECTED_EXCEPTION" */
    '\x01','V','M','X','_','\xce','E','X','C','E','P','T','I','O','N',
/* 0x1c139 = "VERR_VD_UNKNOWN_CFG_VALUES" */
    '\x01','V','D','_','\xde','C','F','G','_','V','A','L','U','E','S',
/* 0x1c148 = "VERR_TAR_EMPTY_NAME" */
    '\x01','T','A','R','_','E','M','P','T','Y','_','N','A','M','E',
/* 0x1c157 = "VERR_PGM_PHYS_MMIO_EX_IPE" */
    '\x01','\xd7','P','H','Y','S','_','\xf4','_','E','X','_','I','P','E',
/* 0x1c166 = "VERR_PATCH_DISABLED" */
    '\x01','P','A','T','C','H','_','D','I','S','A','B','L','E','D',
/* 0x1c175 = "VERR_IEM_INVALID_OPERAND_SIZE" */
    '\x01','\xee','\x0f','O','P','E','R','A','N','D','_','S','I','Z','E',
/* 0x1c184 = "VERR_VFS_BOGUS_FORMAT" */
    '\x01','\xa4','_','B','O','G','U','S','_','F','O','R','M','A','T',
/* 0x1c193 = "VERR_EM_INTERPRETER" */
    '\x01','E','M','_','I','N','T','E','R','P','R','E','T','E','R',
/* 0x1c1a2 = "VERR_VD_DMG_INVALID_HEADER" */
    '\x01','V','D','_','D','M','G','_','\x0f','H','E','A','D','E','R',
/* 0x1c1b1 = "VERR_SVM_UNEXPECTED_XCPT_EXIT" */
    '\x01','S','V','M','_','\xce','X','C','P','T','_','E','X','I','T',
/* 0x1c1c0 = "VERR_ISOFS_MULTIPLE_PVDS" */
    '\x01','\xfd','M','U','L','T','I','P','L','E','_','P','V','D','S',
/* 0x1c1cf = "VERR_FILENAME_TOO_LONG" */
    '\x01','F','I','L','E','N','A','M','E','_','\x9f','L','O','N','G',
/* 0x1c1de = "Send cancelled." */
    'S','e','n','d',' ','c','a','n','c','e','l','l','e','d','.',
/* 0x1c1ed = "Unsupported character set." */
    '\x87','c','h','a','r','a','c','t','e','r',' ','s','e','t','.',
/* 0x1c1fc = "Process Verification Failure: Error reading image file header." */
    '\x17','\x0c','\x12','\xac','r','e','a','d','i','n','g',' ','\x1a','\x18','\xe7',
/* 0x1c20b = "VERR_VD_VHD_INVALID_HEADER" */
    '\x01','V','D','_','V','H','D','_','\x0f','H','E','A','D','E','R',
/* 0x1c21a = "VERR_VMM_LONG_JMP_ERROR" */
    '\x01','V','M','M','_','L','O','N','G','_','J','M','P','_','\x9b',
/* 0x1c229 = "No read callback." */
    '\xd0','r','e','a','d',' ','c','a','l','l','b','a','c','k','.',
/* 0x1c238 = "VERR_DBGC_COMMAND_FAILED" */
    '\x01','D','B','G','C','_','C','O','M','M','A','N','D','_','\x93',
/* 0x1c247 = "VERR_IOMMU_NOT_PRESENT" */
    '\x01','I','O','M','M','U','_','\x14','P','R','E','S','E','N','T',
/* 0x1c256 = "Syntax error - function not found." */
    '\xe1','\x07','-',' ','f','u','n','c','t','i','o','n',' ','\x05','\x7d',
/* 0x1c265 = "The OS was not detected." */
    '\x03','O','S',' ','\x10','\x05','d','e','t','e','c','t','e','d','.',
/* 0x1c274 = "VERR_IOMMU_CMD_HW_ERROR" */
    '\x01','I','O','M','M','U','_','C','M','D','_','H','W','_','\x9b',
/* 0x1c283 = "Process Verification Failure: Bad image signature." */
    '\x17','\x0c','\x12','\x92','\x1a','s','i','g','n','a','t','u','r','e','.',
/* 0x1c292 = "Invalid magic or cookie." */
    '\x0b','m','a','g','i','c',' ','\x86','c','o','o','k','i','e','.',
/* 0x1c2a1 = "VERR_PDM_NO_RTC_INSTANCE" */
    '\x01','\xb8','\xb7','R','T','C','_','I','N','S','T','A','N','C','E',
/* 0x1c2b0 = "VERR_SYS_SHUTDOWN_FAILED" */
    '\x01','S','Y','S','_','S','H','U','T','D','O','W','N','_','\x93',
/* 0x1c2bf = "The specified thread is dead." */
    '\x03','\x16','t','h','r','e','a','d',' ','\x09','d','e','a','d','.',
/* 0x1c2ce = "Not MMIO2 page." */
    'N','o','t',' ','M','M','I','O','2',' ','p','a','g','e','.',
/* 0x1c2dd = "The owner is not root (hardening)." */
    '\x03','o','w','n','e','r',' ','\x09','\x05','r','o','o','t',' ','\x9a',
/* 0x1c2ec = "VERR_VD_DEK_MISSING" */
    '\x01','V','D','_','D','E','K','_','M','I','S','S','I','N','G',
/* 0x1c2fb = "Access denied error." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d',' ','\x7b',
/* 0x1c30a = "VERR_XAR_UNKNOWN_FILE_TYPE" */
    '\x01','X','A','R','_','\xde','F','I','L','E','_','T','Y','P','E',
/* 0x1c319 = "VERR_CR_KEY_FORMAT_NOT_SUPPORTED" */
    '\x01','\xa9','K','E','Y','_','F','O','R','M','A','T','_','\x14','\xc5',
/* 0x1c328 = "VERR_SUP_VP_BAD_MZ_OFFSET" */
    '\x01','\xe6','V','P','_','\xa0','M','Z','_','O','F','F','S','E','T',
/* 0x1c337 = "VERR_SSM_ALREADY_CANCELLED" */
    '\x01','S','S','M','_','\xed','C','A','N','C','E','L','L','E','D',
/* 0x1c346 = "VERR_INVALID_EXE_SIGNATURE" */
    '\x01','\x0f','E','X','E','_','S','I','G','N','A','T','U','R','E',
/* 0x1c355 = "VERR_ISOFS_MULTIPLE_LVDS" */
    '\x01','\xfd','M','U','L','T','I','P','L','E','_','L','V','D','S',
/* 0x1c364 = "VERR_CR_RSA_GENERIC_ERROR" */
    '\x01','\xa9','R','S','A','_','G','E','N','E','R','I','C','_','\x9b',
/* 0x1c373 = "VERR_IPC_PROCESS_NOT_FOUND" */
    '\x01','I','P','C','_','P','R','O','C','E','S','S','_','\x14','\xb3',
/* 0x1c382 = "VERR_LDR_IMAGE_HASH" */
    '\x01','L','D','R','_','I','M','A','G','E','_','H','A','S','H',
/* 0x1c391 = "Bucket already exists." */
    'B','u','c','k','e','t',' ','\x22','e','x','i','s','t','s','.',
/* 0x1c3a0 = "Unknown saved state record." */
    '\xdf','s','a','v','e','d',' ','\xb0','r','e','c','o','r','d','.',
/* 0x1c3af = "VERR_XAR_TOC_TOO_SMALL" */
    '\x01','X','A','R','_','T','O','C','_','\x9f','S','M','A','L','L',
/* 0x1c3be = "VERR_GMM_PAGE_ALREADY_FREE" */
    '\x01','G','M','M','_','P','A','G','E','_','\xed','F','R','E','E',
/* 0x1c3cd = "VERR_NET_NOT_CONNECTED" */
    '\x01','N','E','T','_','\x14','C','O','N','N','E','C','T','E','D',
/* 0x1c3dc = "VERR_LDRELF_MACHINE" */
    '\x01','L','D','R','E','L','F','_','M','A','C','H','I','N','E',
/* 0x1c3eb = "Unexpected number of valid paths." */
    '\x85','\xdd','\x13','v','a','l','i','d',' ','p','a','t','h','s','.',
/* 0x1c3fa = "VERR_INVALID_UTF8_ENCODING" */
    '\x01','\x0f','U','T','F','8','_','E','N','C','O','D','I','N','G',
/* 0x1c409 = "Bad descriptor tag checksum." */
    '\x92','\xd6','t','a','g',' ','c','h','e','c','k','s','u','m','.',
/* 0x1c418 = "The specified LUN is invalid." */
    '\x03','\x16','L','U','N',' ','\x09','i','n','v','a','l','i','d','.',
/* 0x1c427 = "VERR_IEM_VAR_EXHAUSTED" */
    '\x01','\xee','V','A','R','_','E','X','H','A','U','S','T','E','D',
/* 0x1c436 = "VERR_PDM_GEOMETRY_NOT_SET" */
    '\x01','\xb8','G','E','O','M','E','T','R','Y','_','\x14','S','E','T',
/* 0x1c445 = "VERR_WEB_INVALID_OBJECT_ID" */
    '\x01','W','E','B','_','\x0f','O','B','J','E','C','T','_','I','D',
/* 0x1c454 = "VERR_TRAILING_CHARS" */
    '\x01','T','R','A','I','L','I','N','G','_','C','H','A','R','S',
/* 0x1c463 = "Already loaded." */
    'A','l','r','e','a','d','y',' ','l','o','a','d','e','d','.',
/* 0x1c472 = "VERR_DBGC_PARSE_BUG" */
    '\x01','D','B','G','C','_','P','A','R','S','E','_','B','U','G',
/* 0x1c481 = "VERR_SEEK_ON_DEVICE" */
    '\x01','S','E','E','K','_','O','N','_','D','E','V','I','C','E',
/* 0x1c490 = "VWRN_WRONG_TYPE" */
    'V','W','R','N','_','W','R','O','N','G','_','T','Y','P','E',
/* 0x1c49f = "The specified cpu is offline." */
    '\x03','\x16','c','p','u',' ','\x09','o','f','f','l','i','n','e','.',
/* 0x1c4ae = "VERR_VD_VMDK_INVALID_WRITE" */
    '\x01','V','D','_','V','M','D','K','_','\x0f','W','R','I','T','E',
/* 0x1c4bd = "VERR_GETOPT_UNKNOWN_OPTION" */
    '\x01','G','E','T','O','P','T','_','\xde','O','P','T','I','O','N',
/* 0x1c4cc = "Write protect error." */
    'W','r','i','t','e',' ','p','r','o','t','e','c','t',' ','\x7b',
/* 0x1c4db = "VERR_VFS_CHAIN_PROVIDER_NOT_FOUND" */
    '\x01','\xa4','_','\xda','P','R','O','V','I','D','E','R','_','\x14','\xb3',
/* 0x1c4ea = "VERR_TOO_MANY_SYMLINKS" */
    '\x01','\x9f','M','A','N','Y','_','S','Y','M','L','I','N','K','S',
/* 0x1c4f9 = "VERR_HM_INVALID_HM64ON32OP" */
    '\x01','H','M','_','\x0f','H','M','6','4','O','N','3','2','O','P',
/* 0x1c508 = "VERR_SELM_GDT_TOO_FULL" */
    '\x01','S','E','L','M','_','G','D','T','_','\x9f','F','U','L','L',
/* 0x1c517 = "VERR_SUPLIB_IS_FILE" */
    '\x01','S','U','P','L','I','B','_','I','S','_','F','I','L','E',
/* 0x1c526 = "VERR_TAR_NAME_TOO_LONG" */
    '\x01','T','A','R','_','N','A','M','E','_','\x9f','L','O','N','G',
/* 0x1c535 = "VERR_COM_UNEXPECTED" */
    '\x01','C','O','M','_','U','N','E','X','P','E','C','T','E','D',
/* 0x1c544 = "VERR_PGM_PHYS_INVALID_PAGE_ID" */
    '\x01','\xd7','P','H','Y','S','_','\x0f','P','A','G','E','_','I','D',
/* 0x1c553 = "VERR_DBGC_BP_EXISTS" */
    '\x01','D','B','G','C','_','B','P','_','E','X','I','S','T','S',
/* 0x1c562 = "VERR_WEB_UNSUPPORTED_INTERFACE" */
    '\x01','W','E','B','_','\x9d','I','N','T','E','R','F','A','C','E',
/* 0x1c571 = "Invalid segment index." */
    '\x0b','s','e','g','m','e','n','t',' ','i','n','d','e','x','.',
/* 0x1c580 = "VERR_NOT_CODE_SELECTOR" */
    '\x01','\x14','C','O','D','E','_','S','E','L','E','C','T','O','R',
/* 0x1c58f = "VERR_DBG_CFG_INVALID_VALUE" */
    '\x01','D','B','G','_','C','F','G','_','\x0f','V','A','L','U','E',
/* 0x1c59e = "VERR_TM_TSC_ALREADY_PAUSED" */
    '\x01','T','M','_','T','S','C','_','\xed','P','A','U','S','E','D',
/* 0x1c5ad = "VERR_PROC_DETACH_NOT_SUPPORTED" */
    '\x01','P','R','O','C','_','D','E','T','A','C','H','_','\x14','\xc5',
/* 0x1c5bc = "VERR_THREAD_IS_DEAD" */
    '\x01','T','H','R','E','A','D','_','I','S','_','D','E','A','D',
/* 0x1c5cb = "VERR_VFS_UNSUPPORTED_CREATE_TYPE" */
    '\x01','\xa4','_','\x9d','C','R','E','A','T','E','_','T','Y','P','E',
/* 0x1c5da = "VERR_CPUM_DB_CPU_NOT_FOUND" */
    '\x01','C','P','U','M','_','D','B','_','C','P','U','_','\x14','\xb3',
/* 0x1c5e9 = "Unknown glob variable." */
    '\xdf','g','l','o','b',' ','v','a','r','i','a','b','l','e','.',
/* 0x1c5f8 = "VERR_LDRELF_VERSION" */
    '\x01','L','D','R','E','L','F','_','V','E','R','S','I','O','N',
/* 0x1c607 = "VMM long jump error." */
    'V','M','M',' ','l','o','n','g',' ','j','u','m','p',' ','\x7b',
/* 0x1c616 = "The operation has already been cancelled." */
    '\x03','\x83','\x1d','\x22','\xad','c','a','n','c','e','l','l','e','d','.',
/* 0x1c625 = "VERR_LDR_BAD_FORWARDER" */
    '\x01','L','D','R','_','\xa0','F','O','R','W','A','R','D','E','R',
/* 0x1c634 = "VERR_NET_ALREADY_CONNECTED" */
    '\x01','N','E','T','_','\xed','C','O','N','N','E','C','T','E','D',
/* 0x1c643 = "VERR_CFGM_NOT_PASSWORD" */
    '\x01','C','F','G','M','_','\x14','P','A','S','S','W','O','R','D',
/* 0x1c652 = "VERR_LDRLX_BAD_SONAME" */
    '\x01','L','D','R','L','X','_','\xa0','S','O','N','A','M','E',
/* 0x1c660 = "VERR_HTTP_BAD_REQUEST" */
    '\x01','H','T','T','P','_','\xa0','R','E','Q','U','E','S','T',
/* 0x1c66e = "VERR_XAR_NO_ENCODING" */
    '\x01','X','A','R','_','\xb7','E','N','C','O','D','I','N','G',
/* 0x1c67c = "Winsock init error." */
    'W','i','n','s','o','c','k',' ','i','n','i','t',' ','\x7b',
/* 0x1c68a = "VERR_CFGM_VALUE_NOT_FOUND" */
    '\x01','C','F','G','M','_','V','A','L','U','E','_','\x14','\xb3',
/* 0x1c698 = "Failed to open semaphore by name - not found." */
    '\x80','\x08','o','p','e','n',' ','\xea','\xb9','\xf3','-',' ','\x05','\x7d',
/* 0x1c6a6 = "VERR_IOM_IOPORT_IPE_3" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x8e','3',
/* 0x1c6b4 = "VERR_IOM_IOPORT_IPE_2" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x8e','2',
/* 0x1c6c2 = "VERR_IOM_IOPORT_IPE_1" */
    '\x01','I','O','M','_','I','O','P','O','R','T','_','\x8e','1',
/* 0x1c6d0 = "ASN.1 object is too long." */
    'A','S','N','.','1',' ','\x8d','\x09','\x8c','l','o','n','g','.',
/* 0x1c6de = "Bad VTG header - to low value." */
    '\x92','V','T','G',' ','\xa2','-',' ','\x08','l','o','w',' ','\xd3',
/* 0x1c6ec = "VERR_SUPDRV_VTG_BAD_HDR_OFF" */
    '\x01','\xdc','V','T','G','_','\xa0','H','D','R','_','O','F','F',
/* 0x1c6fa = "VERR_DBGF_OS_NOT_DETCTED" */
    '\x01','\xf1','_','O','S','_','\x14','D','E','T','C','T','E','D',
/* 0x1c708 = "VERR_ENV_VAR_UNSET" */
    '\x01','E','N','V','_','V','A','R','_','U','N','S','E','T',
/* 0x1c716 = "VERR_GMM_MTX_FLAGS" */
    '\x01','G','M','M','_','M','T','X','_','F','L','A','G','S',
/* 0x1c724 = "VERR_GVM_TOO_MANY_VMS" */
    '\x01','G','V','M','_','\x9f','M','A','N','Y','_','V','M','S',
/* 0x1c732 = "Trap not handled." */
    'T','r','a','p',' ','\x05','h','a','n','d','l','e','d','.',
/* 0x1c740 = "VERR_CFGM_CHILD_NOT_FOUND" */
    '\x01','C','F','G','M','_','C','H','I','L','D','_','\x14','\xb3',
/* 0x1c74e = "VERR_VD_UNKNOWN_INTERFACE" */
    '\x01','V','D','_','\xde','I','N','T','E','R','F','A','C','E',
/* 0x1c75c = "VERR_ASN1_INTERNAL_ERROR_4" */
    '\x01','\xf2','I','N','T','E','R','N','A','L','_','\x9b','_','4',
/* 0x1c76a = "VERR_ASN1_INTERNAL_ERROR_3" */
    '\x01','\xf2','I','N','T','E','R','N','A','L','_','\x9b','_','3',
/* 0x1c778 = "VERR_ASN1_INTERNAL_ERROR_1" */
    '\x01','\xf2','I','N','T','E','R','N','A','L','_','\x9b','_','1',
/* 0x1c786 = "VERR_ASN1_INTERNAL_ERROR_2" */
    '\x01','\xf2','I','N','T','E','R','N','A','L','_','\x9b','_','2',
/* 0x1c794 = "VERR_ASN1_INTERNAL_ERROR_5" */
    '\x01','\xf2','I','N','T','E','R','N','A','L','_','\x9b','_','5',
/* 0x1c7a2 = "VERR_DWARF_BAD_STRING" */
    '\x01','D','W','A','R','F','_','\xa0','S','T','R','I','N','G',
/* 0x1c7b0 = "Reason for leaving RZ: MMIO read." */
    '\x84','\x0e','\x25','R','Z',':',' ','\xf4',' ','r','e','a','d','.',
/* 0x1c7be = "VERR_GVM_MISMATCH_SVN_REV" */
    '\x01','G','V','M','_','\x99','_','S','V','N','_','R','E','V',
/* 0x1c7cc = "Too long name string." */
    '\xf0','l','o','n','g',' ','\xf3','s','t','r','i','n','g','.',
/* 0x1c7da = "Access denied." */
    'A','c','c','e','s','s',' ','d','e','n','i','e','d','.',
/* 0x1c7e8 = "VERR_VFS_CHAIN_THREE_ARGS" */
    '\x01','\xa4','_','\xda','T','H','R','E','E','_','A','R','G','S',
/* 0x1c7f6 = "A directory entry in the archive." */
    'A',' ','\x1b','\xb5','\x0d','\x02','a','r','c','h','i','v','e','.',
/* 0x1c804 = "NEM failed to set TSC." */
    'N','E','M',' ','\x88','\x08','s','e','t',' ','T','S','C','.',
/* 0x1c812 = "VERR_SEM_LV_NOT_OWNER" */
    '\x01','S','E','M','_','L','V','_','\x14','O','W','N','E','R',
/* 0x1c820 = "VERR_SUPLIB_STAT_FAILED" */
    '\x01','S','U','P','L','I','B','_','S','T','A','T','_','\x93',
/* 0x1c82e = "VERR_FTP_CLIENT_NOT_FOUND" */
    '\x01','F','T','P','_','C','L','I','E','N','T','_','\x14','\xb3',
/* 0x1c83c = "VWRN_DBGF_ALREADY_HALTED" */
    'V','W','R','N','_','\xf1','_','\xed','H','A','L','T','E','D',
/* 0x1c84a = "VERR_LDRLX_NO_SONAME" */
    '\x01','L','D','R','L','X','_','\xb7','S','O','N','A','M','E',
/* 0x1c858 = "VERR_VFS_CHAIN_TOO_MANY_ARGS" */
    '\x01','\xa4','_','\xda','\x9f','M','A','N','Y','_','A','R','G','S',
/* 0x1c866 = "VERR_SEM_DESTROYED" */
    '\x01','S','E','M','_','D','E','S','T','R','O','Y','E','D',
/* 0x1c874 = "Bad DWARF line number header." */
    '\x92','D','W','A','R','F',' ','l','i','n','e',' ','\xdd','\xe7',
/* 0x1c882 = "VERR_SUPDRV_COMPONENT_NOT_FOUND" */
    '\x01','\xdc','C','O','M','P','O','N','E','N','T','_','\x14','\xb3',
/* 0x1c890 = "VERR_STATE_CHANGED" */
    '\x01','S','T','A','T','E','_','C','H','A','N','G','E','D',
/* 0x1c89e = "VINF_REBOOT_NEEDED" */
    '\x19','R','E','B','O','O','T','_','N','E','E','D','E','D',
/* 0x1c8ac = "VERR_PATM_ALREADY_PATCHED" */
    '\x01','P','A','T','M','_','\xed','P','A','T','C','H','E','D',
/* 0x1c8ba = "VERR_ISOFS_PARTITION_NOT_FOUND" */
    '\x01','\xfd','P','A','R','T','I','T','I','O','N','_','\x14','\xb3',
/* 0x1c8c8 = "VERR_ASN1_DUMMY_OBJECT" */
    '\x01','\xf2','D','U','M','M','Y','_','O','B','J','E','C','T',
/* 0x1c8d6 = "VERR_VFS_CHAIN_NOT_PATH_ONLY" */
    '\x01','\xa4','_','\xda','\x14','P','A','T','H','_','O','N','L','Y',
/* 0x1c8e4 = "VERR_INVALID_VMCPU_HANDLE" */
    '\x01','\x0f','V','M','C','P','U','_','H','A','N','D','L','E',
/* 0x1c8f2 = "NEM is not enabled." */
    'N','E','M',' ','\x09','\x05','e','n','a','b','l','e','d','.',
/* 0x1c900 = "Address already in use." */
    'A','d','d','r','e','s','s',' ','\x22','\x0d','u','s','e','.',
/* 0x1c90e = "VERR_PGM_RAM_CONFLICT" */
    '\x01','\xd7','R','A','M','_','C','O','N','