// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// DeregisterLinkedClusterReader is a Reader for the DeregisterLinkedCluster structure.
type DeregisterLinkedClusterReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeregisterLinkedClusterReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewDeregisterLinkedClusterOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewDeregisterLinkedClusterDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewDeregisterLinkedClusterOK creates a DeregisterLinkedClusterOK with default headers values
func NewDeregisterLinkedClusterOK() *DeregisterLinkedClusterOK {
	return &DeregisterLinkedClusterOK{}
}

/*
DeregisterLinkedClusterOK describes a response with status code 200, with default header values.

A successful response.
*/
type DeregisterLinkedClusterOK struct {
	Payload *models.HashicorpCloudVault20201125DeregisterLinkedClusterResponse
}

// IsSuccess returns true when this deregister linked cluster o k response has a 2xx status code
func (o *DeregisterLinkedClusterOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this deregister linked cluster o k response has a 3xx status code
func (o *DeregisterLinkedClusterOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this deregister linked cluster o k response has a 4xx status code
func (o *DeregisterLinkedClusterOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this deregister linked cluster o k response has a 5xx status code
func (o *DeregisterLinkedClusterOK) IsServerError() bool {
	return false
}

// IsCode returns true when this deregister linked cluster o k response a status code equal to that given
func (o *DeregisterLinkedClusterOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the deregister linked cluster o k response
func (o *DeregisterLinkedClusterOK) Code() int {
	return 200
}

func (o *DeregisterLinkedClusterOK) Error() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/deregister/{cluster_id}][%d] deregisterLinkedClusterOK  %+v", 200, o.Payload)
}

func (o *DeregisterLinkedClusterOK) String() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/deregister/{cluster_id}][%d] deregisterLinkedClusterOK  %+v", 200, o.Payload)
}

func (o *DeregisterLinkedClusterOK) GetPayload() *models.HashicorpCloudVault20201125DeregisterLinkedClusterResponse {
	return o.Payload
}

func (o *DeregisterLinkedClusterOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudVault20201125DeregisterLinkedClusterResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeregisterLinkedClusterDefault creates a DeregisterLinkedClusterDefault with default headers values
func NewDeregisterLinkedClusterDefault(code int) *DeregisterLinkedClusterDefault {
	return &DeregisterLinkedClusterDefault{
		_statusCode: code,
	}
}

/*
DeregisterLinkedClusterDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type DeregisterLinkedClusterDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this deregister linked cluster default response has a 2xx status code
func (o *DeregisterLinkedClusterDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this deregister linked cluster default response has a 3xx status code
func (o *DeregisterLinkedClusterDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this deregister linked cluster default response has a 4xx status code
func (o *DeregisterLinkedClusterDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this deregister linked cluster default response has a 5xx status code
func (o *DeregisterLinkedClusterDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this deregister linked cluster default response a status code equal to that given
func (o *DeregisterLinkedClusterDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the deregister linked cluster default response
func (o *DeregisterLinkedClusterDefault) Code() int {
	return o._statusCode
}

func (o *DeregisterLinkedClusterDefault) Error() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/deregister/{cluster_id}][%d] DeregisterLinkedCluster default  %+v", o._statusCode, o.Payload)
}

func (o *DeregisterLinkedClusterDefault) String() string {
	return fmt.Sprintf("[DELETE /vault/2020-11-25/organizations/{location.organization_id}/projects/{location.project_id}/link/deregister/{cluster_id}][%d] DeregisterLinkedCluster default  %+v", o._statusCode, o.Payload)
}

func (o *DeregisterLinkedClusterDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *DeregisterLinkedClusterDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
