/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_OUTPUT_MANAGER_V1_SERVER_PROTOCOL_H
#define TREELAND_OUTPUT_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_output_manager_v1 The treeland_output_manager_v1 protocol
 * @section page_ifaces_treeland_output_manager_v1 Interfaces
 * - @subpage page_iface_treeland_output_manager_v1 - expose which is the primary display
 * @section page_copyright_treeland_output_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_output_manager_v1;

#ifndef TREELAND_OUTPUT_MANAGER_V1_INTERFACE
#define TREELAND_OUTPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_output_manager_v1 treeland_output_manager_v1
 * @section page_iface_treeland_output_manager_v1_desc Description
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 * @section page_iface_treeland_output_manager_v1_api API
 * See @ref iface_treeland_output_manager_v1.
 */
/**
 * @defgroup iface_treeland_output_manager_v1 The treeland_output_manager_v1 interface
 *
 * Protocol for telling which is the primary display among the selection of enabled
 * outputs.
 */
extern const struct wl_interface treeland_output_manager_v1_interface;
#endif

/**
 * @ingroup iface_treeland_output_manager_v1
 * @struct treeland_output_manager_v1_interface
 */
struct treeland_output_manager_v1_interface {
	/**
	 * Select which primary output to use
	 *
	 * 
	 */
	void (*set_primary_output)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *output);
	/**
	 * Destroy the primary output notifier.
	 *
	 * 
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT 0

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_SET_PRIMARY_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_output_manager_v1
 */
#define TREELAND_OUTPUT_MANAGER_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_output_manager_v1
 * Sends an primary_output event to the client owning the resource.
 * @param resource_ The client's resource
 * @param output_name the name of the output
 */
static inline void
treeland_output_manager_v1_send_primary_output(struct wl_resource *resource_, const char *output_name)
{
	wl_resource_post_event(resource_, TREELAND_OUTPUT_MANAGER_V1_PRIMARY_OUTPUT, output_name);
}

#ifdef  __cplusplus
}
#endif

#endif
