/*
The MIT License (MIT)

Copyright (c) 2016-2020 Containous SAS; 2020-2026 Traefik Labs

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// ErrorPageApplyConfiguration represents a declarative configuration of the ErrorPage type for use
// with apply.
type ErrorPageApplyConfiguration struct {
	Status         []string                   `json:"status,omitempty"`
	StatusRewrites map[string]int             `json:"statusRewrites,omitempty"`
	Service        *ServiceApplyConfiguration `json:"service,omitempty"`
	Query          *string                    `json:"query,omitempty"`
}

// ErrorPageApplyConfiguration constructs a declarative configuration of the ErrorPage type for use with
// apply.
func ErrorPage() *ErrorPageApplyConfiguration {
	return &ErrorPageApplyConfiguration{}
}

// WithStatus adds the given value to the Status field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Status field.
func (b *ErrorPageApplyConfiguration) WithStatus(values ...string) *ErrorPageApplyConfiguration {
	for i := range values {
		b.Status = append(b.Status, values[i])
	}
	return b
}

// WithStatusRewrites puts the entries into the StatusRewrites field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the StatusRewrites field,
// overwriting an existing map entries in StatusRewrites field with the same key.
func (b *ErrorPageApplyConfiguration) WithStatusRewrites(entries map[string]int) *ErrorPageApplyConfiguration {
	if b.StatusRewrites == nil && len(entries) > 0 {
		b.StatusRewrites = make(map[string]int, len(entries))
	}
	for k, v := range entries {
		b.StatusRewrites[k] = v
	}
	return b
}

// WithService sets the Service field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Service field is set to the value of the last call.
func (b *ErrorPageApplyConfiguration) WithService(value *ServiceApplyConfiguration) *ErrorPageApplyConfiguration {
	b.Service = value
	return b
}

// WithQuery sets the Query field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Query field is set to the value of the last call.
func (b *ErrorPageApplyConfiguration) WithQuery(value string) *ErrorPageApplyConfiguration {
	b.Query = &value
	return b
}
