/* Main.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Main.vala, do not modify */

/*
 * Main.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <unistd.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <stdio.h>
#include <json-glib/json-glib.h>

#define TEE_JEE_FILE_SYSTEM_KB ((gint64) 1000)
#define TEE_JEE_FILE_SYSTEM_MB (1000 * TEE_JEE_FILE_SYSTEM_KB)
#define TEE_JEE_FILE_SYSTEM_GB (1000 * TEE_JEE_FILE_SYSTEM_MB)
#define MAIN_MIN_FREE_SPACE ((guint64) (1 * TEE_JEE_FILE_SYSTEM_GB))
#define MAIN_date_format_default "%Y-%m-%d %H:%M:%S"
#define AppName "Timeshift"
#define CONSTANTS_VERSION "25.12.1"
#define AppVersion CONSTANTS_VERSION
#define CONSTANTS_SYSCONFDIR "/etc"
#define AppShortName "timeshift"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
typedef enum  {
	MAIN_QGROUP_STATUS_UNKNOWN = -1,
	MAIN_QGROUP_STATUS_DISABLED = 0,
	MAIN_QGROUP_STATUS_ENABLED = 1
} MainQGroupStatus;

#define MAIN_TYPE_QGROUP_STATUS (main_qgroup_status_get_type ())
enum  {
	MAIN_0_PROPERTY,
	MAIN_BTRFS_QGROUPS_ENABLED_PROPERTY,
	MAIN_SCHEDULED_PROPERTY,
	MAIN_DST_ROOT_PROPERTY,
	MAIN_DST_BOOT_PROPERTY,
	MAIN_DST_EFI_PROPERTY,
	MAIN_DST_HOME_PROPERTY,
	MAIN_RESTORE_CURRENT_SYSTEM_PROPERTY,
	MAIN_RESTORE_SOURCE_PATH_PROPERTY,
	MAIN_RESTORE_TARGET_PATH_PROPERTY,
	MAIN_RESTORE_LOG_FILE_PROPERTY,
	MAIN_RESTORE_EXCLUDE_FILE_PROPERTY,
	MAIN_NUM_PROPERTIES
};
static GParamSpec* main_properties[MAIN_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _LinuxDistroPrivate LinuxDistroPrivate;
typedef struct _AppLockPrivate AppLockPrivate;
typedef struct _DevicePrivate DevicePrivate;
typedef struct _SystemUserPrivate SystemUserPrivate;

#define TYPE_FS_TAB_ENTRY (fs_tab_entry_get_type ())
#define FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FS_TAB_ENTRY, FsTabEntry))
#define FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FS_TAB_ENTRY, FsTabEntryClass))
#define IS_FS_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FS_TAB_ENTRY))
#define IS_FS_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FS_TAB_ENTRY))
#define FS_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FS_TAB_ENTRY, FsTabEntryClass))

typedef struct _FsTabEntry FsTabEntry;
typedef struct _FsTabEntryClass FsTabEntryClass;
typedef struct _FsTabEntryPrivate FsTabEntryPrivate;
typedef struct _SnapshotPrivate SnapshotPrivate;

#define TYPE_CRYPT_TAB_ENTRY (crypt_tab_entry_get_type ())
#define CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntry))
#define CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))
#define IS_CRYPT_TAB_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CRYPT_TAB_ENTRY))
#define IS_CRYPT_TAB_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CRYPT_TAB_ENTRY))
#define CRYPT_TAB_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CRYPT_TAB_ENTRY, CryptTabEntryClass))

typedef struct _CryptTabEntry CryptTabEntry;
typedef struct _CryptTabEntryClass CryptTabEntryClass;
typedef struct _AppExcludeEntryPrivate AppExcludeEntryPrivate;
typedef struct _SnapshotRepoPrivate SnapshotRepoPrivate;
typedef enum  {
	SNAPSHOT_LOCATION_STATUS_NOT_SELECTED = -2,
	SNAPSHOT_LOCATION_STATUS_NOT_AVAILABLE = -1,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_HAS_SPACE = 0,
	SNAPSHOT_LOCATION_STATUS_HAS_SNAPSHOTS_NO_SPACE = 1,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_NO_SPACE = 2,
	SNAPSHOT_LOCATION_STATUS_NO_SNAPSHOTS_HAS_SPACE = 3,
	SNAPSHOT_LOCATION_STATUS_READ_ONLY_FS = 4,
	SNAPSHOT_LOCATION_STATUS_HARDLINKS_NOT_SUPPORTED = 5,
	SNAPSHOT_LOCATION_STATUS_NO_BTRFS_SYSTEM = 6
} SnapshotLocationStatus;

#define TYPE_SNAPSHOT_LOCATION_STATUS (snapshot_location_status_get_type ())
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _RsyncSpaceCheckTaskPrivate RsyncSpaceCheckTaskPrivate;
typedef void (*MainprogressCallback) (gpointer user_data);
typedef struct _RsyncTaskPrivate RsyncTaskPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _SubvolumePrivate SubvolumePrivate;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef struct _CryptTabEntryPrivate CryptTabEntryPrivate;
typedef struct _MountEntryPrivate MountEntryPrivate;

#define TYPE_TERMINAL_WINDOW (terminal_window_get_type ())
#define TERMINAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TERMINAL_WINDOW, TerminalWindow))
#define TERMINAL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TERMINAL_WINDOW, TerminalWindowClass))
#define IS_TERMINAL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TERMINAL_WINDOW))
#define IS_TERMINAL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TERMINAL_WINDOW))
#define TERMINAL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TERMINAL_WINDOW, TerminalWindowClass))

typedef struct _TerminalWindow TerminalWindow;
typedef struct _TerminalWindowClass TerminalWindowClass;

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _MainPrivate {
	gint _live_system;
	MainQGroupStatus _btrfs_qgroups_enabled_internal;
};

struct _LinuxDistro {
	GObject parent_instance;
	LinuxDistroPrivate * priv;
	gchar* dist_id;
	gchar* description;
	gchar* release;
	gchar* codename;
};

struct _LinuxDistroClass {
	GObjectClass parent_class;
};

struct _AppLock {
	GObject parent_instance;
	AppLockPrivate * priv;
	gchar* lock_file;
	gchar* lock_message;
};

struct _AppLockClass {
	GObjectClass parent_class;
};

struct _Device {
	GObject parent_instance;
	DevicePrivate * priv;
	gchar* device;
	gchar* name;
	gchar* kname;
	gchar* pkname;
	gchar* pkname_toplevel;
	gchar* mapped_name;
	gchar* uuid;
	gchar* label;
	gchar* partuuid;
	gchar* partlabel;
	gint major;
	gint minor;
	gchar* device_mapper;
	gchar* device_by_uuid;
	gchar* device_by_label;
	gchar* device_by_partuuid;
	gchar* device_by_partlabel;
	gchar* type;
	gchar* fstype;
	gint order;
	gchar* vendor;
	gchar* model;
	gchar* serial;
	gchar* revision;
	gboolean removable;
	gboolean read_only;
	guint64 size_bytes;
	guint64 used_bytes;
	guint64 available_bytes;
	gchar* used_percent;
	gchar* dist_info;
	GeeArrayList* mount_points;
	GeeArrayList* symlinks;
	Device* parent;
	GeeArrayList* children;
};

struct _DeviceClass {
	GObjectClass parent_class;
};

struct _SystemUser {
	GObject parent_instance;
	SystemUserPrivate * priv;
	gchar* name;
	gchar* password;
	gint uid;
	gint gid;
	gchar* user_info;
	gchar* home_path;
	gchar* shell_path;
	gchar* full_name;
	gchar* room_num;
	gchar* phone_work;
	gchar* phone_home;
	gchar* other_info;
	gboolean has_encrypted_home;
	gboolean has_encrypted_private_dirs;
	GeeArrayList* encrypted_dirs;
	GeeArrayList* encrypted_private_dirs;
	gboolean is_selected;
};

struct _SystemUserClass {
	GObjectClass parent_class;
};

struct _FsTabEntry {
	GObject parent_instance;
	FsTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* device_string;
	gchar* mount_point;
	gchar* type;
	gchar* options;
	gchar* dump;
	gchar* pass;
	gchar* line;
};

struct _FsTabEntryClass {
	GObjectClass parent_class;
};

struct _Snapshot {
	GObject parent_instance;
	SnapshotPrivate * priv;
	gchar* path;
	gchar* name;
	GDateTime* date;
	gchar* sys_uuid;
	gchar* sys_distro;
	gchar* app_version;
	gchar* description;
	gint64 file_count;
	GeeArrayList* tags;
	GeeArrayList* exclude_list;
	GeeHashMap* subvolumes;
	GeeArrayList* fstab_list;
	GeeArrayList* cryttab_list;
	gboolean valid;
	gboolean live;
	gboolean marked_for_deletion;
	LinuxDistro* distro;
	SnapshotRepo* repo;
	gboolean btrfs_mode;
	GeeHashMap* paths;
	gchar* mount_path_root;
	gchar* mount_path_home;
	DeleteFileTask* delete_file_task;
};

struct _SnapshotClass {
	GObjectClass parent_class;
};

struct _AppExcludeEntry {
	GObject parent_instance;
	AppExcludeEntryPrivate * priv;
	gchar* name;
	gboolean is_include;
	gboolean is_file;
	gboolean enabled;
	GeeArrayList* items;
	GeeArrayList* patterns;
};

struct _AppExcludeEntryClass {
	GObjectClass parent_class;
};

struct _SnapshotRepo {
	GObject parent_instance;
	SnapshotRepoPrivate * priv;
	Device* device;
	Device* device_home;
	gchar* mount_path;
	GeeHashMap* mount_paths;
	gboolean btrfs_mode;
	GeeArrayList* snapshots;
	GeeArrayList* invalid_snapshots;
	gchar* status_message;
	gchar* status_details;
	SnapshotLocationStatus status_code;
	gboolean last_snapshot_failed_space;
};

struct _SnapshotRepoClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*prepare) (AsyncTask* self);
	gchar* (*build_script) (AsyncTask* self);
	gboolean (*begin) (AsyncTask* self);
	void (*execute) (AsyncTask* self);
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _RsyncSpaceCheckTask {
	AsyncTask parent_instance;
	RsyncSpaceCheckTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	gint64 status_line_count;
	gint64 total_size;
};

struct _RsyncSpaceCheckTaskClass {
	AsyncTaskClass parent_class;
};

struct _RsyncTask {
	AsyncTask parent_instance;
	RsyncTaskPrivate * priv;
	gboolean delete_extra;
	gboolean delete_after;
	gboolean delete_excluded;
	gboolean relative;
	gchar* rsync_log_file;
	gchar* exclude_from_file;
	gchar* link_from_path;
	gchar* source_path;
	gchar* dest_path;
	gboolean verbose;
	gboolean io_nice;
	gboolean dry_run;
	GQueue* status_lines;
	gint64 status_line_count;
	gint64 total_size;
	gint64 count_created;
	gint64 count_deleted;
	gint64 count_modified;
	gint64 count_checksum;
	gint64 count_size;
	gint64 count_timestamp;
	gint64 count_permissions;
	gint64 count_owner;
	gint64 count_group;
	gint64 count_unchanged;
	GString* log;
};

struct _RsyncTaskClass {
	AsyncTaskClass parent_class;
};

struct _Subvolume {
	GObject parent_instance;
	SubvolumePrivate * priv;
	gchar* device_uuid;
	gchar* name;
	gchar* path;
	glong id;
	gint64 total_bytes;
	gint64 unshared_bytes;
	gchar* mount_path;
	SnapshotRepo* repo;
};

struct _SubvolumeClass {
	GObjectClass parent_class;
};

struct _CryptTabEntry {
	GObject parent_instance;
	CryptTabEntryPrivate * priv;
	gboolean is_comment;
	gboolean is_empty_line;
	gchar* mapped_name;
	gchar* device_string;
	gchar* keyfile;
	gchar* options;
	gchar* line;
};

struct _CryptTabEntryClass {
	GObjectClass parent_class;
};

struct _MountEntry {
	GObject parent_instance;
	MountEntryPrivate * priv;
	Device* device;
	gchar* mount_point;
	gchar* mount_options;
};

struct _MountEntryClass {
	GObjectClass parent_class;
};

VALA_EXTERN gboolean GTK_INITIALIZED;
gboolean GTK_INITIALIZED = FALSE;
static gint Main_private_offset;
static gpointer main_parent_class = NULL;
VALA_EXTERN gboolean main_btrfs_version__can_recursive_delete;
gboolean main_btrfs_version__can_recursive_delete = FALSE;
VALA_EXTERN guint64 main_first_snapshot_size;
guint64 main_first_snapshot_size = (guint64) 0;
VALA_EXTERN gint64 main_first_snapshot_count;
gint64 main_first_snapshot_count = (gint64) 0;
VALA_EXTERN gboolean tee_jee_logging_LOG_DEBUG;
VALA_EXTERN GDataOutputStream* tee_jee_logging_dos_log;
VALA_EXTERN gboolean tee_jee_logging_LOG_COMMANDS;
VALA_EXTERN Main* App;
VALA_EXTERN gchar* tee_jee_process_helper_TEMP_DIR;

VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GType main_qgroup_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Main* main_new (gchar** args,
                gint args_length1,
                gboolean gui_mode);
VALA_EXTERN Main* main_construct (GType object_type,
                      gchar** args,
                      gint args_length1,
                      gboolean gui_mode);
VALA_EXTERN gboolean tee_jee_file_system_dir_create (const gchar* dir_path,
                                         gboolean show_message);
static void main_parse_some_arguments (Main* self,
                                gchar** args,
                                gint args_length1);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN void main_check_and_remove_timeshift_btrfs (Main* self);
VALA_EXTERN gchar* tee_jee_file_system_path_combine (const gchar* path1,
                                         const gchar* path2);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN LinuxDistro* linux_distro_get_dist_info (const gchar* root_path);
VALA_EXTERN gchar* linux_distro_full_name (LinuxDistro* self);
VALA_EXTERN gboolean main_check_dependencies (Main* self,
                                  gchar** msg);
VALA_EXTERN void tee_jee_gtk_helper_gtk_messagebox (const gchar* title,
                                        const gchar* message,
                                        GtkWindow* parent_win,
                                        gboolean is_error);
VALA_EXTERN void main_exit_app (Main* self,
                    gint exit_code);
VALA_EXTERN void main_check_btrfs_version_capabilities (Main* self);
VALA_EXTERN AppLock* app_lock_new (void);
VALA_EXTERN AppLock* app_lock_construct (GType object_type);
VALA_EXTERN gboolean app_lock_create (AppLock* self,
                          const gchar* app_name,
                          const gchar* message);
void exit (gint exit_code);
VALA_EXTERN SnapshotRepo* snapshot_repo_new (void);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct (GType object_type);
VALA_EXTERN void main_add_default_exclude_entries (Main* self);
VALA_EXTERN RsyncTask* rsync_task_new (void);
VALA_EXTERN RsyncTask* rsync_task_construct (GType object_type);
VALA_EXTERN DeleteFileTask* delete_file_task_new (void);
VALA_EXTERN DeleteFileTask* delete_file_task_construct (GType object_type);
VALA_EXTERN void main_update_partitions (Main* self);
VALA_EXTERN void main_detect_system_devices (Main* self);
static void main_detect_encrypted_dirs (Main* self);
VALA_EXTERN void main_load_app_config (Main* self);
VALA_EXTERN void icon_manager_init (gchar** args,
                        gint args_length1,
                        const gchar* app_name);
VALA_EXTERN void main_initialize (Main* self);
VALA_EXTERN void main_initialize_repo (Main* self);
VALA_EXTERN gboolean tee_jee_process_helper_cmd_exists (const gchar* cmd_tool);
VALA_EXTERN void main_setup_env (void);
VALA_EXTERN GPid tee_jee_process_helper_get_user_process (void);
VALA_EXTERN gchar** tee_jee_process_helper_get_process_env (GPid pid,
                                                gint* result_length1);
VALA_EXTERN gchar* tee_jee_process_helper_get_env (gchar** env,
                                       gint env_length1,
                                       const gchar* name,
                                       const gchar* default_value);
static gint* main_get_btrfs_version_array (Main* self,
                                    gint* result_length1);
VALA_EXTERN gint tee_jee_process_helper_exec_sync (const gchar* cmd,
                                       gchar** std_out,
                                       gchar** std_err);
VALA_EXTERN void tee_jee_logging_log_msg (const gchar* message,
                              gboolean highlight);
VALA_EXTERN gboolean main_check_btrfs_layout_system (Main* self,
                                         GtkWindow* win);
VALA_EXTERN void tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                      GtkWindow* win);
VALA_EXTERN gboolean main_check_btrfs_layout (Main* self,
                                  Device* dev_root,
                                  Device* dev_home,
                                  gboolean unlock);
VALA_EXTERN gboolean main_check_btrfs_volume (Main* self,
                                  Device* dev,
                                  const gchar* subvol_names,
                                  gboolean unlock);
static gboolean* _bool_dup (gboolean* self);
VALA_EXTERN GeeHashMap* system_user_read_users_from_file (const gchar* passwd_file);
VALA_EXTERN gboolean system_user_get_is_system (SystemUser* self);
VALA_EXTERN GType fs_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FsTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* fs_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN void main_add_app_exclude_entries (Main* self);
VALA_EXTERN void app_exclude_entry_clear (void);
static void main_add_app_exclude_entries_for_prefix (Main* self,
                                              const gchar* path_prefix);
VALA_EXTERN GType crypt_tab_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CryptTabEntry, g_object_unref)
VALA_EXTERN GeeArrayList* app_exclude_entry_get_apps_list (GeeArrayList* selected_app_names);
VALA_EXTERN void app_exclude_entry_add_app_exclude_entries_from_path (const gchar* user_home);
VALA_EXTERN void app_exclude_entry_add_app_exclude_entries_from_home (const gchar* home);
VALA_EXTERN GeeArrayList* main_create_exclude_list_for_backup (Main* self);
VALA_EXTERN GeeArrayList* main_create_exclude_list_for_restore (Main* self);
VALA_EXTERN gboolean tee_jee_file_system_file_exists (const gchar* file_path);
VALA_EXTERN gchar* tee_jee_file_system_file_read (const gchar* file_path);
static gchar* main_save_exclude_list_for_backup (Main* self,
                                          const gchar* output_path);
VALA_EXTERN gboolean tee_jee_file_system_file_write (const gchar* file_path,
                                         const gchar* contents);
VALA_EXTERN gboolean main_save_exclude_list_for_restore (Main* self,
                                             const gchar* output_path);
VALA_EXTERN gchar* main_get_restore_exclude_file (Main* self);
VALA_EXTERN void main_save_exclude_list_selections (Main* self);
static gint __lambda17_ (Main* self,
                  const gchar* a,
                  const gchar* b);
static gint ___lambda17__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN gboolean main_live_system (Main* self);
VALA_EXTERN gboolean main_create_snapshot (Main* self,
                               gboolean is_ondemand,
                               GtkWindow* parent_win);
VALA_EXTERN gboolean snapshot_repo_has_space (SnapshotRepo* self,
                                  guint64 needed);
VALA_EXTERN GType snapshot_location_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void snapshot_repo_auto_remove (SnapshotRepo* self);
VALA_EXTERN gchar* snapshot_repo_get_snapshots_path (SnapshotRepo* self);
static gboolean main_create_snapshot_for_tag (Main* self,
                                       const gchar* tag,
                                       GDateTime* dt_created);
VALA_EXTERN gboolean main_get_scheduled (Main* self);
VALA_EXTERN Snapshot* snapshot_repo_get_latest_snapshot (SnapshotRepo* self,
                                             const gchar* tag,
                                             const gchar* sys_uuid);
VALA_EXTERN gdouble tee_jee_system_get_system_uptime_seconds (void);
VALA_EXTERN gboolean snapshot_repo_load_snapshots (SnapshotRepo* self);
VALA_EXTERN void main_cron_job_update (Main* self);
VALA_EXTERN void snapshot_repo_create_symlinks (SnapshotRepo* self);
VALA_EXTERN void snapshot_add_tag (Snapshot* self,
                       const gchar* tag);
VALA_EXTERN gboolean snapshot_repo_available (SnapshotRepo* self);
static Snapshot* main_create_snapshot_with_btrfs (Main* self,
                                           const gchar* tag,
                                           GDateTime* dt_created);
VALA_EXTERN guint64 device_get_free_bytes (Device* self);
static guint64 main_get_space_needed_for_rsync_snapshot (Main* self,
                                                  GDateTime* dt_created);
VALA_EXTERN gchar* tee_jee_file_system_format_file_size (guint64 size,
                                             gboolean binary_units,
                                             const gchar* unit,
                                             gboolean show_units,
                                             gint decimals);
VALA_EXTERN gchar* device_get_free (Device* self);
static Snapshot* main_create_snapshot_with_rsync (Main* self,
                                           const gchar* tag,
                                           GDateTime* dt_created);
VALA_EXTERN gint osd_notify_notify_send (const gchar* title,
                             const gchar* message,
                             gint durationMillis,
                             const gchar* urgency,
                             const gchar* dialog_type);
VALA_EXTERN gchar* tee_jee_file_system_file_basename (const gchar* file_path);
VALA_EXTERN RsyncSpaceCheckTask* rsync_space_check_task_new (void);
VALA_EXTERN RsyncSpaceCheckTask* rsync_space_check_task_construct (GType object_type);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void async_task_execute (AsyncTask* self);
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
VALA_EXTERN guint64 main_estimate_system_size (Main* self,
                                   MainprogressCallback callback,
                                   gpointer callback_target);
VALA_EXTERN gboolean tee_jee_file_system_file_delete (const gchar* file_path);
VALA_EXTERN gchar* async_task_get_stat_time_remaining (AsyncTask* self);
VALA_EXTERN gint64* tee_jee_file_system_file_line_count (const gchar* file_path);
VALA_EXTERN Snapshot* snapshot_write_control_file (const gchar* snapshot_path,
                                       GDateTime* dt_created,
                                       const gchar* root_uuid,
                                       const gchar* distro_full_name,
                                       const gchar* tag,
                                       const gchar* comments,
                                       gint64 item_count,
                                       gboolean is_btrfs,
                                       gboolean is_live,
                                       SnapshotRepo* repo,
                                       gboolean silent);
static void main_set_tags (Main* self,
                    Snapshot* snapshot);
static void main_run_post_backup_hooks (Main* self,
                                 const gchar* snapshot_path);
VALA_EXTERN void snapshot_update_control_file (Snapshot* self);
VALA_EXTERN gint tee_jee_process_helper_exec_script_sync (const gchar* script,
                                              gchar** std_out,
                                              gchar** std_err,
                                              gboolean supress_errors,
                                              gboolean run_as_admin,
                                              gboolean cleanup_tmp,
                                              gboolean print_to_terminal);
VALA_EXTERN void main_validate_cmd_tags (Main* self);
VALA_EXTERN void main_delete_begin (Main* self);
static void ___lambda18_ (Main* self);
VALA_EXTERN void main_delete_thread (Main* self);
static gpointer ____lambda18__gthread_func (gpointer self);
VALA_EXTERN void snapshot_mark_for_deletion (Snapshot* self);
VALA_EXTERN gboolean snapshot_remove (Snapshot* self,
                          gboolean wait);
VALA_EXTERN gchar* async_task_get_stat_time_elapsed (AsyncTask* self);
VALA_EXTERN void main_init_mount_list (Main* self);
VALA_EXTERN GeeArrayList* crypt_tab_entry_read_file (const gchar* file_path);
VALA_EXTERN void main_set_dst_root (Main* self,
                        Device* value);
VALA_EXTERN gboolean fs_tab_entry_is_for_system_directory (FsTabEntry* self);
VALA_EXTERN gchar* fs_tab_entry_get_device_uuid (FsTabEntry* self);
VALA_EXTERN Device* device_get_device_by_uuid (const gchar* uuid);
VALA_EXTERN Device* device_get_device_by_name (const gchar* file_name);
VALA_EXTERN Device* device_luks_unlock (Device* luks_device,
                            const gchar* mapped_name,
                            const gchar* passphrase,
                            GtkWindow* parent_window,
                            gchar** message,
                            gchar** details);
VALA_EXTERN MountEntry* mount_entry_new (Device* device,
                             const gchar* mount_point,
                             const gchar* mount_options);
VALA_EXTERN MountEntry* mount_entry_construct (GType object_type,
                                   Device* device,
                                   const gchar* mount_point,
                                   const gchar* mount_options);
static gint __lambda19_ (Main* self,
                  MountEntry* a,
                  MountEntry* b);
static gint ___lambda19__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
VALA_EXTERN void main_init_boot_options (Main* self);
VALA_EXTERN Device* main_get_dst_root (Main* self);
VALA_EXTERN gboolean device_has_parent (Device* self);
VALA_EXTERN gboolean main_restore_snapshot (Main* self,
                                GtkWindow* parent_win);
VALA_EXTERN gboolean main_get_restore_current_system (Main* self);
static gboolean ____lambda20_ (Main* self);
VALA_EXTERN gboolean main_restore_execute_btrfs (Main* self);
static gpointer _____lambda20__gthread_func (gpointer self);
static gboolean ____lambda21_ (Main* self);
VALA_EXTERN gboolean main_restore_execute_rsync (Main* self);
static gpointer _____lambda21__gthread_func (gpointer self);
VALA_EXTERN void main_get_restore_messages (Main* self,
                                gboolean formatted,
                                gchar** msg_devices,
                                gchar** msg_reboot,
                                gchar** msg_disclaimer);
VALA_EXTERN gchar* mount_entry_subvolume_name (MountEntry* self);
VALA_EXTERN gchar* device_get_full_name_with_parent (Device* self);
VALA_EXTERN gchar* mount_entry_lvm_name (MountEntry* self);
static void main_create_restore_scripts (Main* self,
                                  gchar** sh_sync,
                                  gchar** sh_finish);
VALA_EXTERN gchar* main_get_restore_log_file (Main* self);
VALA_EXTERN gchar* main_get_restore_target_path (Main* self);
VALA_EXTERN gchar* main_get_restore_source_path (Main* self);
VALA_EXTERN gchar* linux_distro_get_dist_type (LinuxDistro* self);
static gboolean main_restore_current_console (Main* self,
                                       const gchar* sh_sync,
                                       const gchar* sh_finish);
VALA_EXTERN void tee_jee_logging_log_to_file (const gchar* message,
                                  gboolean highlight);
static gboolean main_restore_current_gui (Main* self,
                                   const gchar* sh_sync,
                                   const gchar* sh_finish);
VALA_EXTERN gchar* tee_jee_process_helper_save_bash_script_temp (const gchar* commands,
                                                     const gchar* script_path,
                                                     gboolean force_locale,
                                                     gboolean supress_errors);
VALA_EXTERN GType terminal_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TerminalWindow, g_object_unref)
VALA_EXTERN TerminalWindow* terminal_window_new_with_parent (GtkWindow* parent);
VALA_EXTERN TerminalWindow* terminal_window_construct_with_parent (GType object_type,
                                                       GtkWindow* parent);
VALA_EXTERN void terminal_window_execute_script (TerminalWindow* self,
                                     const gchar* script_path,
                                     gboolean wait);
static gboolean main_restore_other_console (Main* self,
                                     const gchar* sh_sync,
                                     const gchar* sh_finish);
static void main_fix_fstab_file (Main* self,
                          const gchar* target_path);
static void main_fix_crypttab_file (Main* self,
                             const gchar* target_path);
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN GeeArrayList* rsync_task_parse_log (RsyncTask* self,
                                    const gchar* log_file_path);
static gboolean main_restore_other_gui (Main* self,
                                 const gchar* sh_sync,
                                 const gchar* sh_finish);
VALA_EXTERN gchar* async_task_get_status_line (AsyncTask* self);
VALA_EXTERN FsTabEntry* fs_tab_entry_find_entry_by_mount_point (GeeArrayList* entries,
                                                    const gchar* mount_path);
VALA_EXTERN FsTabEntry* fs_tab_entry_new (void);
VALA_EXTERN FsTabEntry* fs_tab_entry_construct (GType object_type);
VALA_EXTERN void fs_tab_entry_remove_option (FsTabEntry* self,
                                 const gchar* option);
VALA_EXTERN gchar* fs_tab_entry_subvolume_name (FsTabEntry* self);
VALA_EXTERN MountEntry* mount_entry_find_entry_by_mount_point (GeeArrayList* entries,
                                                   const gchar* mount_path);
VALA_EXTERN gchar* fs_tab_entry_write_file (GeeArrayList* entries,
                                const gchar* file_path,
                                gboolean keep_comments_and_empty_lines);
VALA_EXTERN gboolean tee_jee_file_system_dir_exists (const gchar* dir_path);
VALA_EXTERN void crypt_tab_entry_append_option (CryptTabEntry* self,
                                    const gchar* option);
VALA_EXTERN gboolean device_is_on_encrypted_partition (Device* self);
VALA_EXTERN CryptTabEntry* crypt_tab_entry_find_entry_by_uuid (GeeArrayList* entries,
                                                   const gchar* uuid);
VALA_EXTERN CryptTabEntry* crypt_tab_entry_new (void);
VALA_EXTERN CryptTabEntry* crypt_tab_entry_construct (GType object_type);
VALA_EXTERN void crypt_tab_entry_set_device_uuid (CryptTabEntry* self,
                                      const gchar* value);
VALA_EXTERN gchar* crypt_tab_entry_write_file (GeeArrayList* entries,
                                   const gchar* file_path,
                                   gboolean keep_comments_and_empty_lines);
static void main_check_and_repair_filesystems (Main* self);
VALA_EXTERN void main_unmount_target_device (Main* self,
                                 gboolean exit_on_error);
VALA_EXTERN gboolean main_create_pre_restore_snapshot_btrfs (Main* self);
VALA_EXTERN gboolean subvolume_restore (Subvolume* self);
VALA_EXTERN gboolean subvolume_remove (Subvolume* self);
VALA_EXTERN gchar* snapshot_get_date_formatted (Snapshot* self);
VALA_EXTERN gboolean tee_jee_file_system_dir_delete (const gchar* dir_path,
                                         gboolean show_message);
VALA_EXTERN Subvolume* subvolume_new (const gchar* name,
                          const gchar* path,
                          const gchar* parent_dev_uuid,
                          SnapshotRepo* parent_repo);
VALA_EXTERN Subvolume* subvolume_construct (GType object_type,
                                const gchar* name,
                                const gchar* path,
                                const gchar* parent_dev_uuid,
                                SnapshotRepo* parent_repo);
VALA_EXTERN void main_save_app_config (Main* self);
VALA_EXTERN gboolean snapshot_repo_has_snapshots (SnapshotRepo* self);
static void _vala_JsonNode_free (JsonNode* self);
VALA_EXTERN void tee_jee_file_system_file_move (const gchar* src_file,
                                    const gchar* dest_file);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_file_copy (const gchar* src_file,
                                        const gchar* dest_file);
static JsonNode* _vala_JsonNode_copy (JsonNode* self);
VALA_EXTERN gboolean tee_jee_json_helper_json_get_bool (JsonObject* jobj,
                                            const gchar* member,
                                            gboolean def_value);
VALA_EXTERN void main_set_first_run_flag (Main* self);
VALA_EXTERN gchar* tee_jee_json_helper_json_get_string (JsonObject* jobj,
                                            const gchar* member,
                                            const gchar* def_value);
VALA_EXTERN gint tee_jee_json_helper_json_get_int (JsonObject* jobj,
                                       const gchar* member,
                                       gint def_value);
VALA_EXTERN guint64 tee_jee_json_helper_json_get_uint64 (JsonObject* jobj,
                                             const gchar* member,
                                             guint64 def_value);
static gboolean _bool_equal (const gboolean * s1,
                      const gboolean * s2);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_device (Device* dev,
                                             GtkWindow* parent_win,
                                             gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_device (GType object_type,
                                                   Device* dev,
                                                   GtkWindow* parent_win,
                                                   gboolean btrfs_repo);
VALA_EXTERN void main_try_select_default_device_for_backup (Main* self,
                                                GtkWindow* parent_win);
VALA_EXTERN gboolean device_is_encrypted_partition (Device* self);
VALA_EXTERN gboolean device_has_children (Device* self);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_uuid (const gchar* uuid,
                                           GtkWindow* parent_win,
                                           gboolean btrfs_repo);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_uuid (GType object_type,
                                                 const gchar* uuid,
                                                 GtkWindow* parent_win,
                                                 gboolean btrfs_repo);
VALA_EXTERN GeeArrayList* device_get_filesystems (gboolean get_space,
                                      gboolean get_mounts);
VALA_EXTERN GeeHashMap* subvolume_detect_subvolumes_for_system_by_path (const gchar* system_path,
                                                            SnapshotRepo* repo,
                                                            GtkWindow* parent_window);
VALA_EXTERN gboolean main_mount_target_devices (Main* self,
                                    GtkWindow* parent_win);
VALA_EXTERN Device* main_get_dst_home (Main* self);
VALA_EXTERN gboolean snapshot_has_subvolumes (Snapshot* self);
VALA_EXTERN gboolean device_mount (const gchar* dev_name_or_uuid,
                       const gchar* mount_point,
                       const gchar* mount_options,
                       gboolean silent);
VALA_EXTERN gboolean main_unmount_device (Main* self,
                              const gchar* mount_point,
                              gboolean exit_on_error);
VALA_EXTERN gboolean device_unmount (const gchar* mount_point);
VALA_EXTERN SnapshotLocationStatus main_check_backup_location (Main* self,
                                                   gchar** message,
                                                   gchar** details);
VALA_EXTERN void snapshot_repo_check_status (SnapshotRepo* self);
VALA_EXTERN gboolean device_is_mounted_at_path (Device* self,
                                    const gchar* subvolname,
                                    const gchar* mount_path);
VALA_EXTERN gboolean tee_jee_file_system_dir_is_empty (const gchar* dir_path);
VALA_EXTERN gboolean main_check_device_for_backup (Main* self,
                                       Device* dev,
                                       gboolean unlock);
VALA_EXTERN SnapshotRepo* snapshot_repo_new_from_null (void);
VALA_EXTERN SnapshotRepo* snapshot_repo_construct_from_null (GType object_type);
VALA_EXTERN Device* subvolume_get_device (Subvolume* self);
VALA_EXTERN gboolean device_has_linux_filesystem (Device* self);
VALA_EXTERN void main_query_subvolume_info (Main* self,
                                SnapshotRepo* parent_repo);
static void ___lambda11_ (Main* self);
VALA_EXTERN void main_query_subvolume_info_thread (Main* self);
static gpointer ____lambda11__gthread_func (gpointer self);
VALA_EXTERN gboolean main_query_subvolume_ids (Main* self);
VALA_EXTERN gboolean main_query_subvolume_quotas (Main* self);
VALA_EXTERN gboolean main_query_subvolume_id (Main* self,
                                  const gchar* subvol_name);
VALA_EXTERN gboolean main_query_subvolume_quota (Main* self,
                                     const gchar* subvol_name);
VALA_EXTERN gboolean cron_tab_has_job (const gchar* entry,
                           gboolean partial_match,
                           gboolean use_cached_text);
VALA_EXTERN gboolean cron_tab_remove_job (const gchar* entry,
                              gboolean use_regex,
                              gboolean use_cached_text);
VALA_EXTERN gboolean cron_tab_remove_script_file (const gchar* file_name,
                                      const gchar* cron_dir_type);
VALA_EXTERN gboolean cron_tab_add_script_file (const gchar* file_name,
                                   const gchar* cron_dir_type,
                                   const gchar* text,
                                   gboolean stop_cron_emails);
VALA_EXTERN void main_clean_logs (Main* self);
static gint ___lambda15_ (Main* self,
                   const gchar* a,
                   const gchar* b);
static gint ____lambda15__gcompare_data_func (gconstpointer a,
                                       gconstpointer b,
                                       gpointer self);
VALA_EXTERN void app_lock_remove (AppLock* self);
static void main_cleanup_unmount_devices (Main* self);
VALA_EXTERN GeeArrayList* tee_jee_file_system_dir_list_names (const gchar* path);
VALA_EXTERN gchar* tee_jee_file_system_escape_single_quote (const gchar* file_path);
VALA_EXTERN gboolean tee_jee_file_system_dir_empty_delete (const gchar* path);
VALA_EXTERN gboolean main_get_btrfs_qgroups_enabled (Main* self);
VALA_EXTERN Device* main_get_dst_boot (Main* self);
VALA_EXTERN void main_set_dst_boot (Main* self,
                        Device* value);
VALA_EXTERN Device* main_get_dst_efi (Main* self);
VALA_EXTERN void main_set_dst_efi (Main* self,
                       Device* value);
VALA_EXTERN void main_set_dst_home (Main* self,
                        Device* value);
static void main_finalize (GObject * obj);
static GType main_get_type_once (void);
static void _vala_main_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_main_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
main_get_instance_private (Main* self)
{
	return G_STRUCT_MEMBER_P (self, Main_private_offset);
}

static GType
main_qgroup_status_get_type_once (void)
{
	static const GEnumValue values[] = {{MAIN_QGROUP_STATUS_UNKNOWN, "MAIN_QGROUP_STATUS_UNKNOWN", "unknown"}, {MAIN_QGROUP_STATUS_DISABLED, "MAIN_QGROUP_STATUS_DISABLED", "disabled"}, {MAIN_QGROUP_STATUS_ENABLED, "MAIN_QGROUP_STATUS_ENABLED", "enabled"}, {0, NULL, NULL}};
	GType main_qgroup_status_type_id;
	main_qgroup_status_type_id = g_enum_register_static ("MainQGroupStatus", values);
	return main_qgroup_status_type_id;
}

GType
main_qgroup_status_get_type (void)
{
	static volatile gsize main_qgroup_status_type_id__once = 0;
	if (g_once_init_enter (&main_qgroup_status_type_id__once)) {
		GType main_qgroup_status_type_id;
		main_qgroup_status_type_id = main_qgroup_status_get_type_once ();
		g_once_init_leave (&main_qgroup_status_type_id__once, main_qgroup_status_type_id);
	}
	return main_qgroup_status_type_id__once;
}

Main*
main_construct (GType object_type,
                gchar** args,
                gint args_length1,
                gboolean gui_mode)
{
	Main * self = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp4_ = FALSE;
	LinuxDistro* _tmp42_;
	gboolean _tmp43_ = FALSE;
	gchar* message = NULL;
	gchar* _tmp55_ = NULL;
	gboolean _tmp56_;
	AppLock* _tmp60_;
	AppLock* _tmp61_;
	const gchar* _tmp62_;
	const gchar* _tmp77_;
	GFile* _tmp78_;
	GFile* _tmp79_;
	GFile* _tmp80_;
	GFile* _tmp81_;
	gchar* _tmp82_;
	gchar* _tmp83_;
	gchar* _tmp84_;
	gchar* _tmp85_;
	gchar* _tmp86_;
	gchar* local_exec = NULL;
	const gchar* _tmp87_;
	gchar* _tmp88_;
	gchar* local_conf = NULL;
	const gchar* _tmp89_;
	gchar* _tmp90_;
	gchar* local_share = NULL;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	GFile* f_local_exec = NULL;
	const gchar* _tmp93_;
	GFile* _tmp94_;
	GFile* _tmp95_;
	SnapshotRepo* _tmp107_;
	GeeArrayList* _tmp108_;
	GeeArrayList* _tmp109_;
	GeeHashMap* _tmp110_;
	GeeArrayList* _tmp111_;
	RsyncTask* _tmp112_;
	DeleteFileTask* _tmp113_;
	GError* _inner_error0_ = NULL;
	self = (Main*) g_object_new (object_type, NULL);
	_tmp0_ = g_strdup_printf ("/run/timeshift/%d", (gint) getpid ());
	_g_free0 (self->mount_point_app);
	self->mount_point_app = _tmp0_;
	_tmp1_ = self->mount_point_app;
	tee_jee_file_system_dir_create (_tmp1_, FALSE);
	main_parse_some_arguments (self, args, (gint) args_length1);
	if (gui_mode) {
		gchar* _tmp2_;
		GtkWindow* _tmp3_;
		_tmp2_ = g_strdup ("");
		_g_free0 (self->app_mode);
		self->app_mode = _tmp2_;
		_tmp3_ = (GtkWindow*) gtk_window_new (GTK_WINDOW_TOPLEVEL);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->parent_window);
		self->parent_window = _tmp3_;
	}
	tee_jee_logging_log_debug ("Main()");
	if (tee_jee_logging_LOG_DEBUG) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = gui_mode;
	}
	if (_tmp4_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		tee_jee_logging_log_debug ("");
		_tmp5_ = g_strdup_printf (" %s v%s", AppName, AppVersion);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_ ("Running"), _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_debug (_tmp8_);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		tee_jee_logging_log_debug ("");
	}
	main_check_and_remove_timeshift_btrfs (self);
	{
		const gchar* _tmp9_ = NULL;
		gchar* suffix = NULL;
		gchar* _tmp11_;
		GDateTime* now = NULL;
		GDateTime* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		GDateTime* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		GFile* file = NULL;
		const gchar* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		const gchar* _tmp26_;
		GFile* _tmp27_;
		GFile* _tmp28_;
		GFileOutputStream* _tmp30_ = NULL;
		GFile* _tmp31_;
		GFileOutputStream* _tmp32_;
		GDataOutputStream* _tmp33_;
		gboolean _tmp34_ = FALSE;
		if (gui_mode) {
			_tmp9_ = "gui";
		} else {
			const gchar* _tmp10_;
			_tmp10_ = self->app_mode;
			_tmp9_ = _tmp10_;
		}
		_tmp11_ = g_strdup (_tmp9_);
		suffix = _tmp11_;
		_tmp12_ = g_date_time_new_now_local ();
		now = _tmp12_;
		_tmp13_ = g_strdup ("/var/log/timeshift");
		_g_free0 (self->log_dir);
		self->log_dir = _tmp13_;
		_tmp14_ = self->log_dir;
		_tmp15_ = now;
		_tmp16_ = g_date_time_format (_tmp15_, "%Y-%m-%d_%H-%M-%S");
		_tmp17_ = _tmp16_;
		_tmp18_ = suffix;
		_tmp19_ = g_strdup_printf ("%s_%s.log", _tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = tee_jee_file_system_path_combine (_tmp14_, _tmp20_);
		_g_free0 (self->log_file);
		self->log_file = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp17_);
		_tmp22_ = self->log_dir;
		_tmp23_ = g_file_new_for_path (_tmp22_);
		file = _tmp23_;
		_tmp24_ = file;
		if (!g_file_query_exists (_tmp24_, NULL)) {
			GFile* _tmp25_;
			_tmp25_ = file;
			g_file_make_directory_with_parents (_tmp25_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_date_time_unref0 (now);
				_g_free0 (suffix);
				goto __catch0_g_error;
			}
		}
		_tmp26_ = self->log_file;
		_tmp27_ = g_file_new_for_path (_tmp26_);
		_g_object_unref0 (file);
		file = _tmp27_;
		_tmp28_ = file;
		if (g_file_query_exists (_tmp28_, NULL)) {
			GFile* _tmp29_;
			_tmp29_ = file;
			g_file_delete (_tmp29_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (file);
				_g_date_time_unref0 (now);
				_g_free0 (suffix);
				goto __catch0_g_error;
			}
		}
		_tmp31_ = file;
		_tmp32_ = g_file_create (_tmp31_, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error0_);
		_tmp30_ = _tmp32_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (file);
			_g_date_time_unref0 (now);
			_g_free0 (suffix);
			goto __catch0_g_error;
		}
		_tmp33_ = g_data_output_stream_new ((GOutputStream*) _tmp30_);
		_g_object_unref0 (tee_jee_logging_dos_log);
		tee_jee_logging_dos_log = _tmp33_;
		if (tee_jee_logging_LOG_DEBUG) {
			_tmp34_ = TRUE;
		} else {
			_tmp34_ = gui_mode;
		}
		if (_tmp34_) {
			const gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp35_ = self->log_file;
			_tmp36_ = g_strdup_printf (": %s", _tmp35_);
			_tmp37_ = _tmp36_;
			_tmp38_ = g_strconcat (_ ("Session log file"), _tmp37_, NULL);
			_tmp39_ = _tmp38_;
			tee_jee_logging_log_debug (_tmp39_);
			_g_free0 (_tmp39_);
			_g_free0 (_tmp37_);
		}
		_g_object_unref0 (_tmp30_);
		_g_object_unref0 (file);
		_g_date_time_unref0 (now);
		_g_free0 (suffix);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp40_;
		const gchar* _tmp41_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp40_ = e;
		_tmp41_ = _tmp40_->message;
		tee_jee_logging_log_error (_tmp41_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp42_ = linux_distro_get_dist_info ("/");
	_g_object_unref0 (self->current_distro);
	self->current_distro = _tmp42_;
	if (tee_jee_logging_LOG_DEBUG) {
		_tmp43_ = TRUE;
	} else {
		_tmp43_ = gui_mode;
	}
	if (_tmp43_) {
		gchar* _tmp44_;
		gchar* _tmp45_;
		LinuxDistro* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		LinuxDistro* _tmp51_;
		const gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		_tmp44_ = g_strconcat (_ ("Distribution"), ": ", NULL);
		_tmp45_ = _tmp44_;
		_tmp46_ = self->current_distro;
		_tmp47_ = linux_distro_full_name (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = g_strconcat (_tmp45_, _tmp48_, NULL);
		_tmp50_ = _tmp49_;
		tee_jee_logging_log_debug (_tmp50_);
		_g_free0 (_tmp50_);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp45_);
		_tmp51_ = self->current_distro;
		_tmp52_ = _tmp51_->dist_id;
		_tmp53_ = g_strconcat ("DIST_ID" ": ", _tmp52_, NULL);
		_tmp54_ = _tmp53_;
		tee_jee_logging_log_debug (_tmp54_);
		_g_free0 (_tmp54_);
	}
	_tmp56_ = main_check_dependencies (self, &_tmp55_);
	_g_free0 (message);
	message = _tmp55_;
	if (!_tmp56_) {
		if (gui_mode) {
			gchar* title = NULL;
			gchar* _tmp57_;
			const gchar* _tmp58_;
			const gchar* _tmp59_;
			_tmp57_ = g_strdup (_ ("Missing Dependencies"));
			title = _tmp57_;
			_tmp58_ = title;
			_tmp59_ = message;
			tee_jee_gtk_helper_gtk_messagebox (_tmp58_, _tmp59_, NULL, TRUE);
			_g_free0 (title);
		}
		main_exit_app (self, 1);
	}
	main_check_btrfs_version_capabilities (self);
	_tmp60_ = app_lock_new ();
	_g_object_unref0 (self->app_lock);
	self->app_lock = _tmp60_;
	_tmp61_ = self->app_lock;
	_tmp62_ = self->app_mode;
	if (!app_lock_create (_tmp61_, "timeshift", _tmp62_)) {
		if (gui_mode) {
			gchar* msg = NULL;
			gchar* _tmp63_;
			AppLock* _tmp64_;
			const gchar* _tmp65_;
			gchar* title = NULL;
			gchar* _tmp74_;
			const gchar* _tmp75_;
			const gchar* _tmp76_;
			_tmp63_ = g_strdup ("");
			msg = _tmp63_;
			_tmp64_ = self->app_lock;
			_tmp65_ = _tmp64_->lock_message;
			if (g_strcmp0 (_tmp65_, "backup") == 0) {
				gchar* _tmp66_;
				const gchar* _tmp67_;
				gchar* _tmp68_;
				_tmp66_ = g_strconcat (_ ("Another instance of Timeshift is creating a snapshot."), "\n", NULL);
				_g_free0 (msg);
				msg = _tmp66_;
				_tmp67_ = msg;
				_tmp68_ = g_strconcat (_tmp67_, _ ("Please wait a few minutes and try again."), NULL);
				_g_free0 (msg);
				msg = _tmp68_;
			} else {
				gchar* _tmp69_;
				const gchar* _tmp70_;
				gchar* _tmp71_;
				gchar* _tmp72_;
				gchar* _tmp73_;
				_tmp69_ = g_strconcat (_ ("Another instance of timeshift is currently running!"), "\n", NULL);
				_g_free0 (msg);
				msg = _tmp69_;
				_tmp70_ = msg;
				_tmp71_ = g_strconcat (_ ("Please check if you have multiple windows open."), "\n", NULL);
				_tmp72_ = _tmp71_;
				_tmp73_ = g_strconcat (_tmp70_, _tmp72_, NULL);
				_g_free0 (msg);
				msg = _tmp73_;
				_g_free0 (_tmp72_);
			}
			_tmp74_ = g_strdup (_ ("Scheduled snapshot in progress..."));
			title = _tmp74_;
			_tmp75_ = title;
			_tmp76_ = msg;
			tee_jee_gtk_helper_gtk_messagebox (_tmp75_, _tmp76_, NULL, TRUE);
			_g_free0 (title);
			_g_free0 (msg);
		} else {
		}
		exit (1);
	}
	_tmp77_ = args[0];
	_tmp78_ = g_file_new_for_path (_tmp77_);
	_tmp79_ = _tmp78_;
	_tmp80_ = g_file_get_parent (_tmp79_);
	_tmp81_ = _tmp80_;
	_tmp82_ = g_file_get_path (_tmp81_);
	_g_free0 (self->app_path);
	self->app_path = _tmp82_;
	_g_object_unref0 (_tmp81_);
	_g_object_unref0 (_tmp79_);
	_tmp83_ = g_strdup ("/usr/share");
	_g_free0 (self->share_folder);
	self->share_folder = _tmp83_;
	_tmp84_ = g_strdup ("/etc/timeshift/timeshift.json");
	_g_free0 (self->app_conf_path);
	self->app_conf_path = _tmp84_;
	_tmp85_ = g_strdup ("/etc/timeshift.json");
	_g_free0 (self->app_conf_path_old);
	self->app_conf_path_old = _tmp85_;
	_tmp86_ = g_build_path (G_DIR_SEPARATOR_S, CONSTANTS_SYSCONFDIR, "timeshift", "default.json", NULL);
	_g_free0 (self->app_conf_path_default);
	self->app_conf_path_default = _tmp86_;
	_tmp87_ = args[0];
	_tmp88_ = g_strdup (_tmp87_);
	local_exec = _tmp88_;
	_tmp89_ = self->app_path;
	_tmp90_ = g_strconcat (_tmp89_, "/timeshift.json", NULL);
	local_conf = _tmp90_;
	_tmp91_ = self->app_path;
	_tmp92_ = g_strconcat (_tmp91_, "/share", NULL);
	local_share = _tmp92_;
	_tmp93_ = local_exec;
	_tmp94_ = g_file_new_for_path (_tmp93_);
	f_local_exec = _tmp94_;
	_tmp95_ = f_local_exec;
	if (g_file_query_exists (_tmp95_, NULL)) {
		GFile* f_local_conf = NULL;
		const gchar* _tmp96_;
		GFile* _tmp97_;
		GFile* _tmp98_;
		GFile* f_local_share = NULL;
		const gchar* _tmp101_;
		GFile* _tmp102_;
		GFile* _tmp103_;
		_tmp96_ = local_conf;
		_tmp97_ = g_file_new_for_path (_tmp96_);
		f_local_conf = _tmp97_;
		_tmp98_ = f_local_conf;
		if (g_file_query_exists (_tmp98_, NULL)) {
			const gchar* _tmp99_;
			gchar* _tmp100_;
			_tmp99_ = local_conf;
			_tmp100_ = g_strdup (_tmp99_);
			_g_free0 (self->app_conf_path);
			self->app_conf_path = _tmp100_;
		}
		_tmp101_ = local_share;
		_tmp102_ = g_file_new_for_path (_tmp101_);
		f_local_share = _tmp102_;
		_tmp103_ = f_local_share;
		if (g_file_query_exists (_tmp103_, NULL)) {
			const gchar* _tmp104_;
			gchar* _tmp105_;
			_tmp104_ = local_share;
			_tmp105_ = g_strdup (_tmp104_);
			_g_free0 (self->share_folder);
			self->share_folder = _tmp105_;
		}
		_g_object_unref0 (f_local_share);
		_g_object_unref0 (f_local_conf);
	} else {
		gchar* _tmp106_;
		_tmp106_ = g_find_program_in_path ("timeshift");
		_g_free0 (self->app_path);
		self->app_path = _tmp106_;
	}
	_tmp107_ = snapshot_repo_new ();
	_g_object_unref0 (self->repo);
	self->repo = _tmp107_;
	_tmp108_ = gee_array_list_new (TYPE_MOUNT_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->mount_list);
	self->mount_list = _tmp108_;
	_tmp109_ = gee_array_list_new (TYPE_SNAPSHOT, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->delete_list);
	self->delete_list = _tmp109_;
	_tmp110_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, TYPE_SUBVOLUME, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->sys_subvolumes);
	self->sys_subvolumes = _tmp110_;
	_tmp111_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_app_names);
	self->exclude_app_names = _tmp111_;
	main_add_default_exclude_entries (self);
	_tmp112_ = rsync_task_new ();
	_g_object_unref0 (self->task);
	self->task = _tmp112_;
	_tmp113_ = delete_file_task_new ();
	_g_object_unref0 (self->delete_file_task);
	self->delete_file_task = _tmp113_;
	main_update_partitions (self);
	main_detect_system_devices (self);
	main_detect_encrypted_dirs (self);
	main_load_app_config (self);
	icon_manager_init (args, (gint) args_length1, AppShortName);
	tee_jee_logging_log_debug ("Main(): ok");
	_g_object_unref0 (f_local_exec);
	_g_free0 (local_share);
	_g_free0 (local_conf);
	_g_free0 (local_exec);
	_g_free0 (message);
	return self;
}

Main*
main_new (gchar** args,
          gint args_length1,
          gboolean gui_mode)
{
	return main_construct (TYPE_MAIN, args, args_length1, gui_mode);
}

void
main_initialize (Main* self)
{
	g_return_if_fail (self != NULL);
	main_initialize_repo (self);
}

gboolean
main_check_dependencies (Main* self,
                         gchar** msg)
{
	gchar* _vala_msg = NULL;
	gchar** dependencies = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar** _tmp13_;
	gint dependencies_length1;
	gint _dependencies_size_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gint _tmp15__length1;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: check_dependencies()");
	_tmp0_ = g_strdup ("rsync");
	_tmp1_ = g_strdup ("/sbin/blkid");
	_tmp2_ = g_strdup ("df");
	_tmp3_ = g_strdup ("mount");
	_tmp4_ = g_strdup ("umount");
	_tmp5_ = g_strdup ("fuser");
	_tmp6_ = g_strdup ("crontab");
	_tmp7_ = g_strdup ("cp");
	_tmp8_ = g_strdup ("rm");
	_tmp9_ = g_strdup ("touch");
	_tmp10_ = g_strdup ("ln");
	_tmp11_ = g_strdup ("sync");
	_tmp12_ = g_strdup ("run-parts");
	_tmp13_ = g_new0 (gchar*, 13 + 1);
	_tmp13_[0] = _tmp0_;
	_tmp13_[1] = _tmp1_;
	_tmp13_[2] = _tmp2_;
	_tmp13_[3] = _tmp3_;
	_tmp13_[4] = _tmp4_;
	_tmp13_[5] = _tmp5_;
	_tmp13_[6] = _tmp6_;
	_tmp13_[7] = _tmp7_;
	_tmp13_[8] = _tmp8_;
	_tmp13_[9] = _tmp9_;
	_tmp13_[10] = _tmp10_;
	_tmp13_[11] = _tmp11_;
	_tmp13_[12] = _tmp12_;
	dependencies = _tmp13_;
	dependencies_length1 = 13;
	_dependencies_size_ = dependencies_length1;
	_tmp14_ = g_strdup ("");
	_g_free0 (_vala_msg);
	_vala_msg = _tmp14_;
	_tmp15_ = dependencies;
	_tmp15__length1 = dependencies_length1;
	{
		gchar** cmd_tool_collection = NULL;
		gint cmd_tool_collection_length1 = 0;
		gint _cmd_tool_collection_size_ = 0;
		gint cmd_tool_it = 0;
		cmd_tool_collection = _tmp15_;
		cmd_tool_collection_length1 = _tmp15__length1;
		for (cmd_tool_it = 0; cmd_tool_it < cmd_tool_collection_length1; cmd_tool_it = cmd_tool_it + 1) {
			gchar* _tmp16_;
			gchar* cmd_tool = NULL;
			_tmp16_ = g_strdup (cmd_tool_collection[cmd_tool_it]);
			cmd_tool = _tmp16_;
			{
				const gchar* _tmp17_;
				_tmp17_ = cmd_tool;
				if (!tee_jee_process_helper_cmd_exists (_tmp17_)) {
					const gchar* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp18_ = _vala_msg;
					_tmp19_ = cmd_tool;
					_tmp20_ = g_strconcat (" * ", _tmp19_, NULL);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat (_tmp21_, "\n", NULL);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat (_tmp18_, _tmp23_, NULL);
					_g_free0 (_vala_msg);
					_vala_msg = _tmp24_;
					_g_free0 (_tmp23_);
					_g_free0 (_tmp21_);
				}
				_g_free0 (cmd_tool);
			}
		}
	}
	_tmp25_ = _vala_msg;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ > 0) {
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		const gchar* _tmp34_;
		gchar* _tmp35_;
		const gchar* _tmp36_;
		_tmp28_ = g_strconcat (_ ("Commands listed below are not available on this system"), ":\n\n", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = _vala_msg;
		_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
		_tmp32_ = _tmp31_;
		_tmp33_ = g_strconcat (_tmp32_, "\n", NULL);
		_g_free0 (_vala_msg);
		_vala_msg = _tmp33_;
		_g_free0 (_tmp32_);
		_g_free0 (_tmp29_);
		_tmp34_ = _vala_msg;
		_tmp35_ = g_strconcat (_tmp34_, _ ("Please install required packages and try running TimeShift again"), NULL);
		_g_free0 (_vala_msg);
		_vala_msg = _tmp35_;
		_tmp36_ = _vala_msg;
		tee_jee_logging_log_error (_tmp36_, FALSE, FALSE);
		result = FALSE;
		dependencies = (_vala_array_free (dependencies, dependencies_length1, (GDestroyNotify) g_free), NULL);
		if (msg) {
			*msg = _vala_msg;
		} else {
			_g_free0 (_vala_msg);
		}
		return result;
	} else {
		result = TRUE;
		dependencies = (_vala_array_free (dependencies, dependencies_length1, (GDestroyNotify) g_free), NULL);
		if (msg) {
			*msg = _vala_msg;
		} else {
			_g_free0 (_vala_msg);
		}
		return result;
	}
}

void
main_setup_env (void)
{
	GPid user_pid = 0;
	gchar** user_env = NULL;
	gint _tmp0_ = 0;
	gchar** _tmp1_;
	gint user_env_length1;
	gint _user_env_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** targets = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar** _tmp7_;
	gint targets_length1;
	gint _targets_size_;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar* xdg_runtime_dir = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	gchar* _tmp17_;
	gchar* wayland_display = NULL;
	gchar** _tmp18_;
	gint _tmp18__length1;
	gchar* _tmp19_;
	gboolean _tmp20_ = FALSE;
	const gchar* _tmp21_;
	user_pid = tee_jee_process_helper_get_user_process ();
	_tmp1_ = tee_jee_process_helper_get_process_env (user_pid, &_tmp0_);
	user_env = _tmp1_;
	user_env_length1 = _tmp0_;
	_user_env_size_ = user_env_length1;
	_tmp2_ = user_env;
	_tmp2__length1 = user_env_length1;
	if (_tmp2_ == NULL) {
		user_env = (_vala_array_free (user_env, user_env_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	_tmp3_ = g_strdup ("GTK_THEME");
	_tmp4_ = g_strdup ("DISPLAY");
	_tmp5_ = g_strdup ("XAUTHORITY");
	_tmp6_ = g_strdup ("DBUS_SESSION_BUS_ADDRESS");
	_tmp7_ = g_new0 (gchar*, 4 + 1);
	_tmp7_[0] = _tmp3_;
	_tmp7_[1] = _tmp4_;
	_tmp7_[2] = _tmp5_;
	_tmp7_[3] = _tmp6_;
	targets = _tmp7_;
	targets_length1 = 4;
	_targets_size_ = targets_length1;
	_tmp8_ = targets;
	_tmp8__length1 = targets_length1;
	{
		gchar** target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = _tmp8_;
		target_collection_length1 = _tmp8__length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			gchar* _tmp9_;
			gchar* target = NULL;
			_tmp9_ = g_strdup (target_collection[target_it]);
			target = _tmp9_;
			{
				gchar* user_var = NULL;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp10_ = user_env;
				_tmp10__length1 = user_env_length1;
				_tmp11_ = target;
				_tmp12_ = tee_jee_process_helper_get_env (_tmp10_, (gint) _tmp10__length1, _tmp11_, NULL);
				user_var = _tmp12_;
				_tmp13_ = user_var;
				if (_tmp13_ != NULL) {
					const gchar* _tmp14_;
					const gchar* _tmp15_;
					_tmp14_ = target;
					_tmp15_ = user_var;
					g_setenv (_tmp14_, _tmp15_, TRUE);
				}
				_g_free0 (user_var);
				_g_free0 (target);
			}
		}
	}
	_tmp16_ = user_env;
	_tmp16__length1 = user_env_length1;
	_tmp17_ = tee_jee_process_helper_get_env (_tmp16_, (gint) _tmp16__length1, "XDG_RUNTIME_DIR", NULL);
	xdg_runtime_dir = _tmp17_;
	_tmp18_ = user_env;
	_tmp18__length1 = user_env_length1;
	_tmp19_ = tee_jee_process_helper_get_env (_tmp18_, (gint) _tmp18__length1, "WAYLAND_DISPLAY", NULL);
	wayland_display = _tmp19_;
	_tmp21_ = wayland_display;
	if (_tmp21_ != NULL) {
		const gchar* _tmp22_;
		_tmp22_ = xdg_runtime_dir;
		_tmp20_ = _tmp22_ != NULL;
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		gchar* path = NULL;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar* _tmp25_;
		const gchar* _tmp26_;
		_tmp23_ = xdg_runtime_dir;
		_tmp24_ = wayland_display;
		_tmp25_ = g_strdup_printf ("%s/%s", _tmp23_, _tmp24_);
		path = _tmp25_;
		_tmp26_ = path;
		g_setenv ("WAYLAND_DISPLAY", _tmp26_, TRUE);
		g_setenv ("XDG_RUNTIME_DIR", "/run/user/0", TRUE);
		_g_free0 (path);
	}
	_g_free0 (wayland_display);
	_g_free0 (xdg_runtime_dir);
	targets = (_vala_array_free (targets, targets_length1, (GDestroyNotify) g_free), NULL);
	user_env = (_vala_array_free (user_env, user_env_length1, (GDestroyNotify) g_free), NULL);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	if (_tmp1_ != NULL) {
		gchar* _tmp2_;
		_tmp2_ = _result_;
		result = (gint) (_tmp2_ - ((gchar*) self));
		return result;
	} else {
		result = -1;
		return result;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static gint*
main_get_btrfs_version_array (Main* self,
                              gint* result_length1)
{
	gchar* stdout = NULL;
	gchar* stderr = NULL;
	gint exit_status = 0;
	gchar** lines = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar** _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp14_;
	gint _tmp14__length1;
	gchar* version_line = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp21_;
	gchar* version_prefix = NULL;
	gchar* _tmp23_;
	gint prefix_index = 0;
	const gchar* _tmp24_;
	const gchar* _tmp25_;
	gchar* version_string = NULL;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gint _tmp29_;
	gint _tmp30_;
	gchar* _tmp31_;
	gchar** version_parts = NULL;
	const gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gint version_parts_length1;
	gint _version_parts_size_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gint* version = NULL;
	gint* _tmp40_;
	gint version_length1;
	gint _version_size_;
	gint* _tmp49_;
	gint _tmp49__length1;
	GError* _inner_error0_ = NULL;
	gint* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gint _tmp2_ = 0;
		g_spawn_command_line_sync ("btrfs --version", &_tmp0_, &_tmp1_, &_tmp2_, &_inner_error0_);
		_g_free0 (stdout);
		stdout = _tmp0_;
		_g_free0 (stderr);
		stderr = _tmp1_;
		exit_status = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		gint* _tmp3_;
		gint _tmp3__length1;
		g_clear_error (&_inner_error0_);
		tee_jee_logging_log_debug ("Failed to run btrfs command. Is btrfs-progs installed?");
		_tmp3_ = NULL;
		_tmp3__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp3__length1;
		}
		result = _tmp3_;
		_g_free0 (stderr);
		_g_free0 (stdout);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (stderr);
		_g_free0 (stdout);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	tee_jee_logging_log_debug ("Checking btrfs-progs version and determining capabilities...");
	if (exit_status != 0) {
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gint* _tmp7_;
		gint _tmp7__length1;
		_tmp4_ = stderr;
		_tmp5_ = g_strdup_printf ("btrfs command failed with exit code %d: %s", exit_status, _tmp4_);
		_tmp6_ = _tmp5_;
		tee_jee_logging_log_error (_tmp6_, FALSE, FALSE);
		_g_free0 (_tmp6_);
		_tmp7_ = NULL;
		_tmp7__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp7__length1;
		}
		result = _tmp7_;
		_g_free0 (stderr);
		_g_free0 (stdout);
		return result;
	}
	_tmp8_ = stdout;
	_tmp9_ = string_strip (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, "\n", 0);
	_tmp13_ = _tmp12_;
	_tmp13__length1 = _vala_array_length (_tmp11_);
	_g_free0 (_tmp10_);
	lines = _tmp13_;
	lines_length1 = _tmp13__length1;
	_lines_size_ = lines_length1;
	_tmp14_ = lines;
	_tmp14__length1 = lines_length1;
	if (_tmp14__length1 == 0) {
		gint* _tmp15_;
		gint _tmp15__length1;
		tee_jee_logging_log_error ("No output from btrfs --version", FALSE, FALSE);
		_tmp15_ = NULL;
		_tmp15__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp15__length1;
		}
		result = _tmp15_;
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (stdout);
		return result;
	}
	version_line = NULL;
	_tmp16_ = lines;
	_tmp16__length1 = lines_length1;
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp16_;
		line_collection_length1 = _tmp16__length1;
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp17_;
			gchar* line = NULL;
			_tmp17_ = g_strdup (line_collection[line_it]);
			line = _tmp17_;
			{
				const gchar* _tmp18_;
				_tmp18_ = line;
				if (string_contains (_tmp18_, "btrfs-progs")) {
					const gchar* _tmp19_;
					gchar* _tmp20_;
					_tmp19_ = line;
					_tmp20_ = g_strdup (_tmp19_);
					_g_free0 (version_line);
					version_line = _tmp20_;
					_g_free0 (line);
					break;
				}
				_g_free0 (line);
			}
		}
	}
	_tmp21_ = version_line;
	if (_tmp21_ == NULL) {
		gint* _tmp22_;
		gint _tmp22__length1;
		tee_jee_logging_log_error ("Could not find btrfs-progs version line in output", FALSE, FALSE);
		_tmp22_ = NULL;
		_tmp22__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp22__length1;
		}
		result = _tmp22_;
		_g_free0 (version_line);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (stdout);
		return result;
	}
	_tmp23_ = g_strdup ("btrfs-progs v");
	version_prefix = _tmp23_;
	_tmp24_ = version_line;
	_tmp25_ = version_prefix;
	prefix_index = string_index_of (_tmp24_, _tmp25_, 0);
	if (prefix_index == -1) {
		gint* _tmp26_;
		gint _tmp26__length1;
		tee_jee_logging_log_error ("Could not detect version", FALSE, FALSE);
		_tmp26_ = NULL;
		_tmp26__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp26__length1;
		}
		result = _tmp26_;
		_g_free0 (version_prefix);
		_g_free0 (version_line);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (stdout);
		return result;
	}
	_tmp27_ = version_line;
	_tmp28_ = version_prefix;
	_tmp29_ = strlen (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = string_substring (_tmp27_, (glong) (prefix_index + _tmp30_), (glong) -1);
	version_string = _tmp31_;
	_tmp32_ = version_string;
	_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, ".", 0);
	version_parts = _tmp34_;
	version_parts_length1 = _vala_array_length (_tmp33_);
	_version_parts_size_ = version_parts_length1;
	_tmp35_ = version_parts;
	_tmp35__length1 = version_parts_length1;
	if (_tmp35__length1 < 2) {
		const gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gint* _tmp39_;
		gint _tmp39__length1;
		_tmp36_ = version_string;
		_tmp37_ = g_strdup_printf ("No version components found in: %s", _tmp36_);
		_tmp38_ = _tmp37_;
		tee_jee_logging_log_error (_tmp38_, FALSE, FALSE);
		_g_free0 (_tmp38_);
		_tmp39_ = NULL;
		_tmp39__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp39__length1;
		}
		result = _tmp39_;
		version_parts = (_vala_array_free (version_parts, version_parts_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (version_string);
		_g_free0 (version_prefix);
		_g_free0 (version_line);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (stderr);
		_g_free0 (stdout);
		return result;
	}
	_tmp40_ = g_new0 (gint, 5);
	version = _tmp40_;
	version_length1 = 5;
	_version_size_ = version_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp41_ = FALSE;
			_tmp41_ = TRUE;
			while (TRUE) {
				gchar** _tmp43_;
				gint _tmp43__length1;
				gint* _tmp44_;
				gint _tmp44__length1;
				gchar** _tmp45_;
				gint _tmp45__length1;
				const gchar* _tmp46_;
				gchar* _tmp47_;
				gchar* _tmp48_;
				if (!_tmp41_) {
					gint _tmp42_;
					_tmp42_ = i;
					i = _tmp42_ + 1;
				}
				_tmp41_ = FALSE;
				_tmp43_ = version_parts;
				_tmp43__length1 = version_parts_length1;
				if (!(i < _tmp43__length1)) {
					break;
				}
				_tmp44_ = version;
				_tmp44__length1 = version_length1;
				_tmp45_ = version_parts;
				_tmp45__length1 = version_parts_length1;
				_tmp46_ = _tmp45_[i];
				_tmp47_ = string_strip (_tmp46_);
				_tmp48_ = _tmp47_;
				_tmp44_[i] = atoi (_tmp48_);
				_g_free0 (_tmp48_);
			}
		}
	}
	_tmp49_ = version;
	_tmp49__length1 = version_length1;
	if (result_length1) {
		*result_length1 = _tmp49__length1;
	}
	result = _tmp49_;
	version_parts = (_vala_array_free (version_parts, version_parts_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (version_string);
	_g_free0 (version_prefix);
	_g_free0 (version_line);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (stderr);
	_g_free0 (stdout);
	return result;
}

void
main_check_btrfs_version_capabilities (Main* self)
{
	gint* version = NULL;
	gint _tmp0_ = 0;
	gint* _tmp1_;
	gint version_length1;
	gint _version_size_;
	gint* _tmp2_;
	gint _tmp2__length1;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	gchar* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = main_get_btrfs_version_array (self, &_tmp0_);
	version = _tmp1_;
	version_length1 = _tmp0_;
	_version_size_ = version_length1;
	_tmp2_ = version;
	_tmp2__length1 = version_length1;
	if (_tmp2_ != NULL) {
		gboolean _tmp3_ = FALSE;
		gint* _tmp4_;
		gint _tmp4__length1;
		gint _tmp5_;
		gint* _tmp11_;
		gint _tmp11__length1;
		gint _tmp12_;
		gint* _tmp13_;
		gint _tmp13__length1;
		gint _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp4_ = version;
		_tmp4__length1 = version_length1;
		_tmp5_ = _tmp4_[0];
		if (_tmp5_ > 6) {
			_tmp3_ = TRUE;
		} else {
			gboolean _tmp6_ = FALSE;
			gint* _tmp7_;
			gint _tmp7__length1;
			gint _tmp8_;
			_tmp7_ = version;
			_tmp7__length1 = version_length1;
			_tmp8_ = _tmp7_[0];
			if (_tmp8_ == 6) {
				gint* _tmp9_;
				gint _tmp9__length1;
				gint _tmp10_;
				_tmp9_ = version;
				_tmp9__length1 = version_length1;
				_tmp10_ = _tmp9_[1];
				_tmp6_ = _tmp10_ >= 12;
			} else {
				_tmp6_ = FALSE;
			}
			_tmp3_ = _tmp6_;
		}
		main_btrfs_version__can_recursive_delete = _tmp3_;
		_tmp11_ = version;
		_tmp11__length1 = version_length1;
		_tmp12_ = _tmp11_[0];
		_tmp13_ = version;
		_tmp13__length1 = version_length1;
		_tmp14_ = _tmp13_[1];
		_tmp15_ = g_strdup_printf ("-- btrfs-progs version %d.%d.x", _tmp12_, _tmp14_);
		_tmp16_ = _tmp15_;
		tee_jee_logging_log_debug (_tmp16_);
		_g_free0 (_tmp16_);
	}
	if (main_btrfs_version__can_recursive_delete) {
		_tmp17_ = "supported";
	} else {
		_tmp17_ = "not supported";
	}
	_tmp18_ = g_strdup_printf ("-- btrfs subvolume recursive delete: %s", _tmp17_);
	_tmp19_ = _tmp18_;
	tee_jee_logging_log_debug (_tmp19_);
	_g_free0 (_tmp19_);
	version = (g_free (version), NULL);
}

void
main_check_and_remove_timeshift_btrfs (Main* self)
{
	g_return_if_fail (self != NULL);
	if (tee_jee_process_helper_cmd_exists ("timeshift-btrfs")) {
		gchar* std_out = NULL;
		gchar* std_err = NULL;
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		tee_jee_process_helper_exec_sync ("timeshift-btrfs-uninstall", &_tmp0_, &_tmp1_);
		_g_free0 (std_out);
		std_out = _tmp0_;
		_g_free0 (std_err);
		std_err = _tmp1_;
		tee_jee_logging_log_msg (_ ("** Uninstalled Timeshift BTRFS **"), FALSE);
		_g_free0 (std_err);
		_g_free0 (std_out);
	}
}

gboolean
main_check_btrfs_layout_system (Main* self,
                                GtkWindow* win)
{
	gboolean supported = FALSE;
	GeeHashMap* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("check_btrfs_layout_system()");
	_tmp0_ = self->sys_subvolumes;
	supported = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, "@");
	if (self->include_btrfs_home_for_backup) {
		gboolean _tmp1_ = FALSE;
		if (supported) {
			GeeHashMap* _tmp2_;
			_tmp2_ = self->sys_subvolumes;
			_tmp1_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, "@home");
		} else {
			_tmp1_ = FALSE;
		}
		supported = _tmp1_;
	}
	if (!supported) {
		gchar* msg = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* title = NULL;
		gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp3_ = g_strconcat (_ ("The system partition has an unsupported subvolume layout."), " ", NULL);
		msg = _tmp3_;
		_tmp4_ = msg;
		_tmp5_ = g_strconcat (_ ("Only ubuntu-type layouts with @ and @home subvolumes are currently sup" \
"ported."), "\n\n", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_tmp4_, _tmp6_, NULL);
		_g_free0 (msg);
		msg = _tmp7_;
		_g_free0 (_tmp6_);
		_tmp8_ = msg;
		_tmp9_ = g_strconcat (_ ("Application will exit."), "\n\n", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp8_, _tmp10_, NULL);
		_g_free0 (msg);
		msg = _tmp11_;
		_g_free0 (_tmp10_);
		_tmp12_ = g_strdup (_ ("Not Supported"));
		title = _tmp12_;
		_tmp13_ = self->app_mode;
		if (g_strcmp0 (_tmp13_, "") == 0) {
			const gchar* _tmp14_;
			const gchar* _tmp15_;
			tee_jee_gtk_helper_gtk_set_busy (FALSE, win);
			_tmp14_ = title;
			_tmp15_ = msg;
			tee_jee_gtk_helper_gtk_messagebox (_tmp14_, _tmp15_, win, TRUE);
		} else {
			const gchar* _tmp16_;
			_tmp16_ = msg;
			tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
		}
		_g_free0 (title);
		_g_free0 (msg);
	}
	result = supported;
	return result;
}

gboolean
main_check_btrfs_layout (Main* self,
                         Device* dev_root,
                         Device* dev_home,
                         gboolean unlock)
{
	gboolean supported = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	supported = TRUE;
	if (dev_root != NULL) {
		const gchar* _tmp1_;
		_tmp1_ = dev_root->fstype;
		_tmp0_ = g_strcmp0 (_tmp1_, "btrfs") == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp2_ = FALSE;
		if (dev_home != NULL) {
			const gchar* _tmp3_;
			_tmp3_ = dev_home->fstype;
			_tmp2_ = g_strcmp0 (_tmp3_, "btrfs") == 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			if (dev_home != dev_root) {
				gboolean _tmp4_ = FALSE;
				if (supported) {
					_tmp4_ = main_check_btrfs_volume (self, dev_root, "@", unlock);
				} else {
					_tmp4_ = FALSE;
				}
				supported = _tmp4_;
				if (self->include_btrfs_home_for_backup) {
					gboolean _tmp5_ = FALSE;
					if (supported) {
						_tmp5_ = main_check_btrfs_volume (self, dev_home, "@home", unlock);
					} else {
						_tmp5_ = FALSE;
					}
					supported = _tmp5_;
				}
			} else {
				if (self->include_btrfs_home_for_backup) {
					gboolean _tmp6_ = FALSE;
					if (supported) {
						_tmp6_ = main_check_btrfs_volume (self, dev_root, "@,@home", unlock);
					} else {
						_tmp6_ = FALSE;
					}
					supported = _tmp6_;
				} else {
					gboolean _tmp7_ = FALSE;
					if (supported) {
						_tmp7_ = main_check_btrfs_volume (self, dev_root, "@", unlock);
					} else {
						_tmp7_ = FALSE;
					}
					supported = _tmp7_;
				}
			}
		}
	}
	result = supported;
	return result;
}

static gboolean*
_bool_dup (gboolean* self)
{
	gboolean* dup;
	dup = g_new0 (gboolean, 1);
	memcpy (dup, self, sizeof (gboolean));
	return dup;
}

static gpointer
__bool_dup0 (gpointer self)
{
	return self ? _bool_dup (self) : NULL;
}

static void
main_parse_some_arguments (Main* self,
                           gchar** args,
                           gint args_length1)
{
	g_return_if_fail (self != NULL);
	{
		gint k = 0;
		k = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				const gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				GQuark _tmp6_ = 0U;
				static GQuark _tmp5_label0 = 0;
				static GQuark _tmp5_label1 = 0;
				static GQuark _tmp5_label2 = 0;
				static GQuark _tmp5_label3 = 0;
				static GQuark _tmp5_label4 = 0;
				static GQuark _tmp5_label5 = 0;
				static GQuark _tmp5_label6 = 0;
				static GQuark _tmp5_label7 = 0;
				static GQuark _tmp5_label8 = 0;
				static GQuark _tmp5_label9 = 0;
				static GQuark _tmp5_label10 = 0;
				static GQuark _tmp5_label11 = 0;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = k;
					k = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(k < args_length1)) {
					break;
				}
				_tmp2_ = args[k];
				_tmp3_ = g_utf8_strdown (_tmp2_, (gssize) -1);
				_tmp4_ = _tmp3_;
				_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
				g_free (_tmp4_);
				if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("--debug")))) {
					switch (0) {
						default:
						{
							tee_jee_logging_LOG_COMMANDS = TRUE;
							tee_jee_logging_LOG_DEBUG = TRUE;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("--btrfs")))) {
					switch (0) {
						default:
						{
							gboolean* _tmp7_;
							self->btrfs_mode = TRUE;
							_tmp7_ = __bool_dup0 (&self->btrfs_mode);
							_g_free0 (self->cmd_btrfs_mode);
							self->cmd_btrfs_mode = _tmp7_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("--rsync")))) {
					switch (0) {
						default:
						{
							gboolean* _tmp8_;
							self->btrfs_mode = FALSE;
							_tmp8_ = __bool_dup0 (&self->btrfs_mode);
							_g_free0 (self->cmd_btrfs_mode);
							self->cmd_btrfs_mode = _tmp8_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("--check")))) {
					switch (0) {
						default:
						{
							gchar* _tmp9_;
							_tmp9_ = g_strdup ("backup");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp9_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("--delete")))) {
					switch (0) {
						default:
						{
							gchar* _tmp10_;
							_tmp10_ = g_strdup ("delete");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp10_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label5) ? _tmp5_label5 : (_tmp5_label5 = g_quark_from_static_string ("--delete-all")))) {
					switch (0) {
						default:
						{
							gchar* _tmp11_;
							_tmp11_ = g_strdup ("delete-all");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp11_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label6) ? _tmp5_label6 : (_tmp5_label6 = g_quark_from_static_string ("--restore")))) {
					switch (0) {
						default:
						{
							gchar* _tmp12_;
							_tmp12_ = g_strdup ("restore");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp12_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label7) ? _tmp5_label7 : (_tmp5_label7 = g_quark_from_static_string ("--clone")))) {
					switch (0) {
						default:
						{
							gchar* _tmp13_;
							_tmp13_ = g_strdup ("restore");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp13_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label8) ? _tmp5_label8 : (_tmp5_label8 = g_quark_from_static_string ("--create")))) {
					switch (0) {
						default:
						{
							gchar* _tmp14_;
							_tmp14_ = g_strdup ("ondemand");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp14_;
							break;
						}
					}
				} else if ((_tmp6_ == ((0 != _tmp5_label9) ? _tmp5_label9 : (_tmp5_label9 = g_quark_from_static_string ("--list")))) || (_tmp6_ == ((0 != _tmp5_label10) ? _tmp5_label10 : (_tmp5_label10 = g_quark_from_static_string ("--list-snapshots"))))) {
					switch (0) {
						default:
						{
							gchar* _tmp15_;
							_tmp15_ = g_strdup ("list-snapshots");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp15_;
							break;
						}
					}
				} else if (_tmp6_ == ((0 != _tmp5_label11) ? _tmp5_label11 : (_tmp5_label11 = g_quark_from_static_string ("--list-devices")))) {
					switch (0) {
						default:
						{
							gchar* _tmp16_;
							_tmp16_ = g_strdup ("list-devices");
							_g_free0 (self->app_mode);
							self->app_mode = _tmp16_;
							break;
						}
					}
				}
			}
		}
	}
}

static void
main_detect_encrypted_dirs (Main* self)
{
	GeeHashMap* _tmp0_;
	gchar* txt = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp56_;
	gchar* _tmp57_;
	const gchar* _tmp58_;
	gchar* _tmp59_;
	gchar* _tmp60_;
	const gchar* _tmp61_;
	gchar* _tmp62_;
	gchar* _tmp63_;
	const gchar* _tmp64_;
	gchar* _tmp65_;
	gchar* _tmp66_;
	const gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	g_return_if_fail (self != NULL);
	_tmp0_ = system_user_read_users_from_file ("/etc/passwd");
	_g_object_unref0 (self->current_system_users);
	self->current_system_users = _tmp0_;
	_tmp1_ = g_strdup ("");
	txt = _tmp1_;
	_tmp2_ = g_strdup ("");
	_g_free0 (self->users_with_encrypted_home);
	self->users_with_encrypted_home = _tmp2_;
	_tmp3_ = g_strdup ("");
	_g_free0 (self->encrypted_home_dirs);
	self->encrypted_home_dirs = _tmp3_;
	_tmp4_ = g_strdup ("");
	_g_free0 (self->encrypted_private_dirs);
	self->encrypted_private_dirs = _tmp4_;
	{
		GeeIterator* _user_it = NULL;
		GeeHashMap* _tmp5_;
		GeeCollection* _tmp6_;
		GeeCollection* _tmp7_;
		GeeCollection* _tmp8_;
		GeeIterator* _tmp9_;
		GeeIterator* _tmp10_;
		_tmp5_ = self->current_system_users;
		_tmp6_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		_user_it = _tmp10_;
		while (TRUE) {
			GeeIterator* _tmp11_;
			SystemUser* user = NULL;
			GeeIterator* _tmp12_;
			gpointer _tmp13_;
			SystemUser* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			const gchar* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			const gchar* _tmp22_;
			SystemUser* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			SystemUser* _tmp28_;
			SystemUser* _tmp41_;
			_tmp11_ = _user_it;
			if (!gee_iterator_next (_tmp11_)) {
				break;
			}
			_tmp12_ = _user_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			user = (SystemUser*) _tmp13_;
			_tmp14_ = user;
			_tmp15_ = system_user_get_is_system (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_) {
				_g_object_unref0 (user);
				continue;
			}
			_tmp17_ = txt;
			_tmp18_ = strlen (_tmp17_);
			_tmp19_ = _tmp18_;
			if (_tmp19_ > 0) {
				const gchar* _tmp20_;
				gchar* _tmp21_;
				_tmp20_ = txt;
				_tmp21_ = g_strconcat (_tmp20_, " ", NULL);
				_g_free0 (txt);
				txt = _tmp21_;
			}
			_tmp22_ = txt;
			_tmp23_ = user;
			_tmp24_ = _tmp23_->name;
			_tmp25_ = g_strdup_printf ("%s", _tmp24_);
			_tmp26_ = _tmp25_;
			_tmp27_ = g_strconcat (_tmp22_, _tmp26_, NULL);
			_g_free0 (txt);
			txt = _tmp27_;
			_g_free0 (_tmp26_);
			_tmp28_ = user;
			if (_tmp28_->has_encrypted_home) {
				const gchar* _tmp29_;
				SystemUser* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				SystemUser* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp29_ = self->users_with_encrypted_home;
				_tmp30_ = user;
				_tmp31_ = _tmp30_->name;
				_tmp32_ = g_strdup_printf (" %s", _tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_strconcat (_tmp29_, _tmp33_, NULL);
				_g_free0 (self->users_with_encrypted_home);
				self->users_with_encrypted_home = _tmp34_;
				_g_free0 (_tmp33_);
				_tmp35_ = self->encrypted_home_dirs;
				_tmp36_ = user;
				_tmp37_ = _tmp36_->home_path;
				_tmp38_ = g_strdup_printf ("%s\n", _tmp37_);
				_tmp39_ = _tmp38_;
				_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
				_g_free0 (self->encrypted_home_dirs);
				self->encrypted_home_dirs = _tmp40_;
				_g_free0 (_tmp39_);
			}
			_tmp41_ = user;
			if (_tmp41_->has_encrypted_private_dirs) {
				{
					GeeArrayList* _enc_path_list = NULL;
					SystemUser* _tmp42_;
					GeeArrayList* _tmp43_;
					gint _enc_path_size = 0;
					GeeArrayList* _tmp44_;
					gint _tmp45_;
					gint _tmp46_;
					gint _enc_path_index = 0;
					_tmp42_ = user;
					_tmp43_ = _tmp42_->encrypted_private_dirs;
					_enc_path_list = _tmp43_;
					_tmp44_ = _enc_path_list;
					_tmp45_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp44_);
					_tmp46_ = _tmp45_;
					_enc_path_size = _tmp46_;
					_enc_path_index = -1;
					while (TRUE) {
						gint _tmp47_;
						gint _tmp48_;
						gchar* enc_path = NULL;
						GeeArrayList* _tmp49_;
						gpointer _tmp50_;
						const gchar* _tmp51_;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gchar* _tmp55_;
						_enc_path_index = _enc_path_index + 1;
						_tmp47_ = _enc_path_index;
						_tmp48_ = _enc_path_size;
						if (!(_tmp47_ < _tmp48_)) {
							break;
						}
						_tmp49_ = _enc_path_list;
						_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, _enc_path_index);
						enc_path = (gchar*) _tmp50_;
						_tmp51_ = self->encrypted_private_dirs;
						_tmp52_ = enc_path;
						_tmp53_ = g_strdup_printf ("%s\n", _tmp52_);
						_tmp54_ = _tmp53_;
						_tmp55_ = g_strconcat (_tmp51_, _tmp54_, NULL);
						_g_free0 (self->encrypted_private_dirs);
						self->encrypted_private_dirs = _tmp55_;
						_g_free0 (_tmp54_);
						_g_free0 (enc_path);
					}
				}
			}
			_g_object_unref0 (user);
		}
		_g_object_unref0 (_user_it);
	}
	_tmp56_ = self->users_with_encrypted_home;
	_tmp57_ = string_strip (_tmp56_);
	_g_free0 (self->users_with_encrypted_home);
	self->users_with_encrypted_home = _tmp57_;
	_tmp58_ = txt;
	_tmp59_ = g_strdup_printf ("Users: %s", _tmp58_);
	_tmp60_ = _tmp59_;
	tee_jee_logging_log_debug (_tmp60_);
	_g_free0 (_tmp60_);
	_tmp61_ = self->users_with_encrypted_home;
	_tmp62_ = g_strdup_printf ("Encrypted home users: %s", _tmp61_);
	_tmp63_ = _tmp62_;
	tee_jee_logging_log_debug (_tmp63_);
	_g_free0 (_tmp63_);
	_tmp64_ = self->encrypted_home_dirs;
	_tmp65_ = g_strdup_printf ("Encrypted home dirs:\n%s", _tmp64_);
	_tmp66_ = _tmp65_;
	tee_jee_logging_log_debug (_tmp66_);
	_g_free0 (_tmp66_);
	_tmp67_ = self->encrypted_private_dirs;
	_tmp68_ = g_strdup_printf ("Encrypted private dirs:\n%s", _tmp67_);
	_tmp69_ = _tmp68_;
	tee_jee_logging_log_debug (_tmp69_);
	_g_free0 (_tmp69_);
	_g_free0 (txt);
}

void
main_add_default_exclude_entries (Main* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GeeArrayList* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	GeeArrayList* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	GeeArrayList* _tmp28_;
	GeeArrayList* _tmp29_;
	GeeArrayList* _tmp30_;
	GeeArrayList* _tmp31_;
	GeeArrayList* _tmp93_;
	GeeArrayList* _tmp94_;
	GeeArrayList* _tmp95_;
	GeeArrayList* _tmp96_;
	GeeArrayList* _tmp97_;
	GeeArrayList* _tmp98_;
	GeeArrayList* _tmp99_;
	GeeArrayList* _tmp100_;
	GeeArrayList* _tmp101_;
	GeeArrayList* _tmp102_;
	GeeArrayList* _tmp103_;
	GeeArrayList* _tmp104_;
	GeeArrayList* _tmp105_;
	GeeArrayList* _tmp106_;
	GeeArrayList* _tmp107_;
	GeeArrayList* _tmp108_;
	GeeArrayList* _tmp109_;
	GeeArrayList* _tmp110_;
	GeeArrayList* _tmp111_;
	GeeArrayList* _tmp112_;
	GeeArrayList* _tmp113_;
	GeeArrayList* _tmp114_;
	GeeArrayList* _tmp115_;
	GeeArrayList* _tmp116_;
	GeeArrayList* _tmp117_;
	GeeArrayList* _tmp118_;
	GeeArrayList* _tmp119_;
	GeeArrayList* _tmp120_;
	GeeArrayList* _tmp121_;
	GeeArrayList* _tmp122_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: add_default_exclude_entries()");
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_list_user);
	self->exclude_list_user = _tmp0_;
	_tmp1_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_list_default);
	self->exclude_list_default = _tmp1_;
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_list_default_extra);
	self->exclude_list_default_extra = _tmp2_;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_list_home);
	self->exclude_list_home = _tmp3_;
	_tmp4_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_list_restore);
	self->exclude_list_restore = _tmp4_;
	_tmp5_ = gee_array_list_new (TYPE_APP_EXCLUDE_ENTRY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->exclude_list_apps);
	self->exclude_list_apps = _tmp5_;
	_tmp6_ = gee_array_list_new (TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->partitions);
	self->partitions = _tmp6_;
	_tmp7_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "/dev/*");
	_tmp8_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "/proc/*");
	_tmp9_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "/sys/*");
	_tmp10_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "/media/*");
	_tmp11_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "/mnt/*");
	_tmp12_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "/tmp/*");
	_tmp13_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "/run/*");
	_tmp14_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "/var/run/*");
	_tmp15_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, "/var/lock/*");
	_tmp16_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, "/var/lib/dhcpcd/*");
	_tmp17_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, "/var/lib/docker/*");
	_tmp18_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, "/var/lib/schroot/*");
	_tmp19_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp19_, "/lost+found");
	_tmp20_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, "/timeshift/*");
	_tmp21_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, "/timeshift-btrfs/*");
	_tmp22_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, "/data/*");
	_tmp23_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, "/DATA/*");
	_tmp24_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp24_, "/cdrom/*");
	_tmp25_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, "/sdcard/*");
	_tmp26_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, "/system/*");
	_tmp27_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, "/etc/timeshift.json");
	_tmp28_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, "/var/log/timeshift/*");
	_tmp29_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp29_, "/var/log/timeshift-btrfs/*");
	_tmp30_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, "/swapfile");
	_tmp31_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp31_, "/snap/*");
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp32_;
		gint _entry_size = 0;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _entry_index = 0;
		_tmp32_ = fs_tab_entry_read_file ("/etc/fstab");
		_entry_list = _tmp32_;
		_tmp33_ = _entry_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_entry_size = _tmp35_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			FsTabEntry* entry = NULL;
			GeeArrayList* _tmp38_;
			gpointer _tmp39_;
			FsTabEntry* _tmp40_;
			const gchar* _tmp41_;
			FsTabEntry* _tmp42_;
			const gchar* _tmp43_;
			FsTabEntry* _tmp44_;
			const gchar* _tmp45_;
			FsTabEntry* _tmp46_;
			const gchar* _tmp47_;
			FsTabEntry* _tmp48_;
			const gchar* _tmp49_;
			FsTabEntry* _tmp50_;
			const gchar* _tmp51_;
			FsTabEntry* _tmp52_;
			const gchar* _tmp53_;
			FsTabEntry* _tmp54_;
			const gchar* _tmp55_;
			FsTabEntry* _tmp56_;
			const gchar* _tmp57_;
			FsTabEntry* _tmp58_;
			const gchar* _tmp59_;
			FsTabEntry* _tmp60_;
			const gchar* _tmp61_;
			FsTabEntry* _tmp62_;
			const gchar* _tmp63_;
			FsTabEntry* _tmp64_;
			const gchar* _tmp65_;
			FsTabEntry* _tmp66_;
			const gchar* _tmp67_;
			FsTabEntry* _tmp68_;
			const gchar* _tmp69_;
			FsTabEntry* _tmp70_;
			const gchar* _tmp71_;
			FsTabEntry* _tmp72_;
			const gchar* _tmp73_;
			FsTabEntry* _tmp74_;
			const gchar* _tmp75_;
			FsTabEntry* _tmp76_;
			const gchar* _tmp77_;
			FsTabEntry* _tmp78_;
			const gchar* _tmp79_;
			FsTabEntry* _tmp80_;
			const gchar* _tmp81_;
			FsTabEntry* _tmp82_;
			const gchar* _tmp83_;
			FsTabEntry* _tmp84_;
			const gchar* _tmp85_;
			FsTabEntry* _tmp86_;
			const gchar* _tmp87_;
			GeeArrayList* _tmp88_;
			FsTabEntry* _tmp89_;
			const gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* _tmp92_;
			_entry_index = _entry_index + 1;
			_tmp36_ = _entry_index;
			_tmp37_ = _entry_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _entry_list;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _entry_index);
			entry = (FsTabEntry*) _tmp39_;
			_tmp40_ = entry;
			_tmp41_ = _tmp40_->mount_point;
			if (!g_str_has_prefix (_tmp41_, "/")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp42_ = entry;
			_tmp43_ = _tmp42_->mount_point;
			if (g_strcmp0 (_tmp43_, "/") == 0) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp44_ = entry;
			_tmp45_ = _tmp44_->mount_point;
			if (g_str_has_prefix (_tmp45_, "/bin")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp46_ = entry;
			_tmp47_ = _tmp46_->mount_point;
			if (g_str_has_prefix (_tmp47_, "/boot")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp48_ = entry;
			_tmp49_ = _tmp48_->mount_point;
			if (g_str_has_prefix (_tmp49_, "/cdrom")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp50_ = entry;
			_tmp51_ = _tmp50_->mount_point;
			if (g_str_has_prefix (_tmp51_, "/dev")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp52_ = entry;
			_tmp53_ = _tmp52_->mount_point;
			if (g_str_has_prefix (_tmp53_, "/etc")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp54_ = entry;
			_tmp55_ = _tmp54_->mount_point;
			if (g_str_has_prefix (_tmp55_, "/home")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp56_ = entry;
			_tmp57_ = _tmp56_->mount_point;
			if (g_str_has_prefix (_tmp57_, "/lib")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp58_ = entry;
			_tmp59_ = _tmp58_->mount_point;
			if (g_str_has_prefix (_tmp59_, "/lib64")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp60_ = entry;
			_tmp61_ = _tmp60_->mount_point;
			if (g_str_has_prefix (_tmp61_, "/media")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp62_ = entry;
			_tmp63_ = _tmp62_->mount_point;
			if (g_str_has_prefix (_tmp63_, "/mnt")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp64_ = entry;
			_tmp65_ = _tmp64_->mount_point;
			if (g_str_has_prefix (_tmp65_, "/opt")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp66_ = entry;
			_tmp67_ = _tmp66_->mount_point;
			if (g_str_has_prefix (_tmp67_, "/proc")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp68_ = entry;
			_tmp69_ = _tmp68_->mount_point;
			if (g_str_has_prefix (_tmp69_, "/root")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp70_ = entry;
			_tmp71_ = _tmp70_->mount_point;
			if (g_str_has_prefix (_tmp71_, "/run")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp72_ = entry;
			_tmp73_ = _tmp72_->mount_point;
			if (g_str_has_prefix (_tmp73_, "/sbin")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp74_ = entry;
			_tmp75_ = _tmp74_->mount_point;
			if (g_str_has_prefix (_tmp75_, "/snap")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp76_ = entry;
			_tmp77_ = _tmp76_->mount_point;
			if (g_str_has_prefix (_tmp77_, "/srv")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp78_ = entry;
			_tmp79_ = _tmp78_->mount_point;
			if (g_str_has_prefix (_tmp79_, "/sys")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp80_ = entry;
			_tmp81_ = _tmp80_->mount_point;
			if (g_str_has_prefix (_tmp81_, "/system")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp82_ = entry;
			_tmp83_ = _tmp82_->mount_point;
			if (g_str_has_prefix (_tmp83_, "/tmp")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp84_ = entry;
			_tmp85_ = _tmp84_->mount_point;
			if (g_str_has_prefix (_tmp85_, "/usr")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp86_ = entry;
			_tmp87_ = _tmp86_->mount_point;
			if (g_str_has_prefix (_tmp87_, "/var")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp88_ = self->exclude_list_default_extra;
			_tmp89_ = entry;
			_tmp90_ = _tmp89_->mount_point;
			_tmp91_ = g_strconcat (_tmp90_, "/*", NULL);
			_tmp92_ = _tmp91_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp88_, _tmp92_);
			_g_free0 (_tmp92_);
			_g_object_unref0 (entry);
		}
		_g_object_unref0 (_entry_list);
	}
	_tmp93_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp93_, "/root/.thumbnails");
	_tmp94_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp94_, "/root/.cache");
	_tmp95_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp95_, "/root/.dbus");
	_tmp96_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp96_, "/root/.gvfs");
	_tmp97_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp97_, "/root/.local/share/[Tt]rash");
	_tmp98_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp98_, "/home/*/.thumbnails");
	_tmp99_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp99_, "/home/*/.cache");
	_tmp100_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, "/home/*/.dbus");
	_tmp101_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp101_, "/home/*/.gvfs");
	_tmp102_ = self->exclude_list_default;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp102_, "/home/*/.local/share/[Tt]rash");
	_tmp103_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp103_, "/root/.mozilla/firefox/*.default/Cache");
	_tmp104_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, "/root/.mozilla/firefox/*.default/OfflineCache");
	_tmp105_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, "/root/.opera/cache");
	_tmp106_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp106_, "/root/.kde/share/apps/kio_http/cache");
	_tmp107_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp107_, "/root/.kde/share/cache/http");
	_tmp108_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp108_, "/home/*/.mozilla/firefox/*.default/Cache");
	_tmp109_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, "/home/*/.mozilla/firefox/*.default/OfflineCache");
	_tmp110_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp110_, "/home/*/.opera/cache");
	_tmp111_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp111_, "/home/*/.kde/share/apps/kio_http/cache");
	_tmp112_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp112_, "/home/*/.kde/share/cache/http");
	_tmp113_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp113_, "/var/cache/apt/archives/*");
	_tmp114_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp114_, "/var/cache/pacman/pkg/*");
	_tmp115_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, "/var/cache/yum/*");
	_tmp116_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp116_, "/var/cache/dnf/*");
	_tmp117_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp117_, "/var/cache/eopkg/*");
	_tmp118_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp118_, "/var/cache/xbps/*");
	_tmp119_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp119_, "/var/cache/zypp/*");
	_tmp120_ = self->exclude_list_default_extra;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, "/var/cache/edb/*");
	_tmp121_ = self->exclude_list_home;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp121_, "/root/**");
	_tmp122_ = self->exclude_list_home;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp122_, "/home/*/**");
	tee_jee_logging_log_debug ("Main: add_default_exclude_entries(): exit");
}

void
main_add_app_exclude_entries (Main* self)
{
	Snapshot* _tmp0_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: add_app_exclude_entries()");
	app_exclude_entry_clear ();
	_tmp0_ = self->snapshot_to_restore;
	if (_tmp0_ != NULL) {
		Snapshot* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->snapshot_to_restore;
		_tmp2_ = _tmp1_->path;
		_tmp3_ = tee_jee_file_system_path_combine (_tmp2_, "localhost");
		_tmp4_ = _tmp3_;
		main_add_app_exclude_entries_for_prefix (self, _tmp4_);
		_g_free0 (_tmp4_);
	}
	_tmp5_ = self->exclude_app_names;
	_tmp6_ = app_exclude_entry_get_apps_list (_tmp5_);
	_g_object_unref0 (self->exclude_list_apps);
	self->exclude_list_apps = _tmp6_;
	tee_jee_logging_log_debug ("Main: add_app_exclude_entries(): exit");
}

static void
main_add_app_exclude_entries_for_prefix (Main* self,
                                         const gchar* path_prefix)
{
	gchar* path = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path_prefix != NULL);
	_tmp0_ = g_strdup ("");
	path = _tmp0_;
	_tmp1_ = tee_jee_file_system_path_combine (path_prefix, "root");
	_g_free0 (path);
	path = _tmp1_;
	_tmp2_ = path;
	app_exclude_entry_add_app_exclude_entries_from_path (_tmp2_);
	_tmp3_ = tee_jee_file_system_path_combine (path_prefix, "home");
	_g_free0 (path);
	path = _tmp3_;
	_tmp4_ = path;
	app_exclude_entry_add_app_exclude_entries_from_home (_tmp4_);
	_g_free0 (path);
}

GeeArrayList*
main_create_exclude_list_for_backup (Main* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* timeshift_path = NULL;
	gchar* _tmp126_;
	GeeArrayList* _tmp127_;
	const gchar* _tmp128_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	tee_jee_logging_log_debug ("Main: create_exclude_list_for_backup()");
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp1_;
		gint _path_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _path_index = 0;
		_tmp1_ = self->exclude_list_user;
		_path_list = _tmp1_;
		_tmp2_ = _path_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_path_size = _tmp4_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* path = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			GeeArrayList* _tmp9_;
			const gchar* _tmp10_;
			_path_index = _path_index + 1;
			_tmp5_ = _path_index;
			_tmp6_ = _path_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _path_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _path_index);
			path = (gchar*) _tmp8_;
			_tmp9_ = list;
			_tmp10_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp9_, _tmp10_)) {
				GeeArrayList* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = list;
				_tmp12_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
			}
			_g_free0 (path);
		}
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp13_;
		gint _path_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _path_index = 0;
		_tmp13_ = self->exclude_list_default;
		_path_list = _tmp13_;
		_tmp14_ = _path_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_path_size = _tmp16_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			gchar* path = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			GeeArrayList* _tmp21_;
			const gchar* _tmp22_;
			_path_index = _path_index + 1;
			_tmp17_ = _path_index;
			_tmp18_ = _path_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _path_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _path_index);
			path = (gchar*) _tmp20_;
			_tmp21_ = list;
			_tmp22_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp21_, _tmp22_)) {
				GeeArrayList* _tmp23_;
				const gchar* _tmp24_;
				_tmp23_ = list;
				_tmp24_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp23_, _tmp24_);
			}
			_g_free0 (path);
		}
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp25_;
		gint _path_size = 0;
		GeeArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		gint _path_index = 0;
		_tmp25_ = self->exclude_list_default_extra;
		_path_list = _tmp25_;
		_tmp26_ = _path_list;
		_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
		_tmp28_ = _tmp27_;
		_path_size = _tmp28_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp29_;
			gint _tmp30_;
			gchar* path = NULL;
			GeeArrayList* _tmp31_;
			gpointer _tmp32_;
			GeeArrayList* _tmp33_;
			const gchar* _tmp34_;
			_path_index = _path_index + 1;
			_tmp29_ = _path_index;
			_tmp30_ = _path_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _path_list;
			_tmp32_ = gee_abstract_list_get ((GeeAbstractList*) _tmp31_, _path_index);
			path = (gchar*) _tmp32_;
			_tmp33_ = list;
			_tmp34_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp33_, _tmp34_)) {
				GeeArrayList* _tmp35_;
				const gchar* _tmp36_;
				_tmp35_ = list;
				_tmp36_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp35_, _tmp36_);
			}
			_g_free0 (path);
		}
	}
	{
		GeeIterator* _user_it = NULL;
		GeeHashMap* _tmp37_;
		GeeCollection* _tmp38_;
		GeeCollection* _tmp39_;
		GeeCollection* _tmp40_;
		GeeIterator* _tmp41_;
		GeeIterator* _tmp42_;
		_tmp37_ = self->current_system_users;
		_tmp38_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _tmp39_;
		_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
		_tmp42_ = _tmp41_;
		_g_object_unref0 (_tmp40_);
		_user_it = _tmp42_;
		while (TRUE) {
			GeeIterator* _tmp43_;
			SystemUser* user = NULL;
			GeeIterator* _tmp44_;
			gpointer _tmp45_;
			SystemUser* _tmp46_;
			gboolean _tmp47_;
			gboolean _tmp48_;
			SystemUser* _tmp49_;
			SystemUser* _tmp55_;
			_tmp43_ = _user_it;
			if (!gee_iterator_next (_tmp43_)) {
				break;
			}
			_tmp44_ = _user_it;
			_tmp45_ = gee_iterator_get (_tmp44_);
			user = (SystemUser*) _tmp45_;
			_tmp46_ = user;
			_tmp47_ = system_user_get_is_system (_tmp46_);
			_tmp48_ = _tmp47_;
			if (_tmp48_) {
				_g_object_unref0 (user);
				continue;
			}
			_tmp49_ = user;
			if (_tmp49_->has_encrypted_home) {
				gchar* path = NULL;
				SystemUser* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				GeeArrayList* _tmp53_;
				const gchar* _tmp54_;
				_tmp50_ = user;
				_tmp51_ = _tmp50_->home_path;
				_tmp52_ = g_strdup_printf ("%s/**", _tmp51_);
				path = _tmp52_;
				_tmp53_ = list;
				_tmp54_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp53_, _tmp54_);
				_g_free0 (path);
			}
			_tmp55_ = user;
			if (_tmp55_->has_encrypted_private_dirs) {
				{
					GeeArrayList* _enc_path_list = NULL;
					SystemUser* _tmp56_;
					GeeArrayList* _tmp57_;
					gint _enc_path_size = 0;
					GeeArrayList* _tmp58_;
					gint _tmp59_;
					gint _tmp60_;
					gint _enc_path_index = 0;
					_tmp56_ = user;
					_tmp57_ = _tmp56_->encrypted_private_dirs;
					_enc_path_list = _tmp57_;
					_tmp58_ = _enc_path_list;
					_tmp59_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp58_);
					_tmp60_ = _tmp59_;
					_enc_path_size = _tmp60_;
					_enc_path_index = -1;
					while (TRUE) {
						gint _tmp61_;
						gint _tmp62_;
						gchar* enc_path = NULL;
						GeeArrayList* _tmp63_;
						gpointer _tmp64_;
						gchar* path = NULL;
						const gchar* _tmp65_;
						gchar* _tmp66_;
						GeeArrayList* _tmp67_;
						const gchar* _tmp68_;
						_enc_path_index = _enc_path_index + 1;
						_tmp61_ = _enc_path_index;
						_tmp62_ = _enc_path_size;
						if (!(_tmp61_ < _tmp62_)) {
							break;
						}
						_tmp63_ = _enc_path_list;
						_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, _enc_path_index);
						enc_path = (gchar*) _tmp64_;
						_tmp65_ = enc_path;
						_tmp66_ = g_strdup_printf ("%s/**", _tmp65_);
						path = _tmp66_;
						_tmp67_ = list;
						_tmp68_ = path;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp67_, _tmp68_);
						_g_free0 (path);
						_g_free0 (enc_path);
					}
				}
			}
			_g_object_unref0 (user);
		}
		_g_object_unref0 (_user_it);
	}
	{
		GeeIterator* _user_it = NULL;
		GeeHashMap* _tmp69_;
		GeeCollection* _tmp70_;
		GeeCollection* _tmp71_;
		GeeCollection* _tmp72_;
		GeeIterator* _tmp73_;
		GeeIterator* _tmp74_;
		_tmp69_ = self->current_system_users;
		_tmp70_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp69_);
		_tmp71_ = _tmp70_;
		_tmp72_ = _tmp71_;
		_tmp73_ = gee_iterable_iterator ((GeeIterable*) _tmp72_);
		_tmp74_ = _tmp73_;
		_g_object_unref0 (_tmp72_);
		_user_it = _tmp74_;
		while (TRUE) {
			GeeIterator* _tmp75_;
			SystemUser* user = NULL;
			GeeIterator* _tmp76_;
			gpointer _tmp77_;
			SystemUser* _tmp78_;
			gboolean _tmp79_;
			gboolean _tmp80_;
			gchar* exc_pattern = NULL;
			SystemUser* _tmp81_;
			const gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* inc_pattern = NULL;
			SystemUser* _tmp84_;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			gchar* inc_hidden_pattern = NULL;
			SystemUser* _tmp87_;
			const gchar* _tmp88_;
			gchar* _tmp89_;
			SystemUser* _tmp90_;
			gboolean include_hidden = FALSE;
			GeeArrayList* _tmp97_;
			const gchar* _tmp98_;
			gboolean include_all = FALSE;
			GeeArrayList* _tmp99_;
			const gchar* _tmp100_;
			gboolean _tmp101_ = FALSE;
			gboolean exclude_all = FALSE;
			_tmp75_ = _user_it;
			if (!gee_iterator_next (_tmp75_)) {
				break;
			}
			_tmp76_ = _user_it;
			_tmp77_ = gee_iterator_get (_tmp76_);
			user = (SystemUser*) _tmp77_;
			_tmp78_ = user;
			_tmp79_ = system_user_get_is_system (_tmp78_);
			_tmp80_ = _tmp79_;
			if (_tmp80_) {
				_g_object_unref0 (user);
				continue;
			}
			_tmp81_ = user;
			_tmp82_ = _tmp81_->home_path;
			_tmp83_ = g_strdup_printf ("%s/**", _tmp82_);
			exc_pattern = _tmp83_;
			_tmp84_ = user;
			_tmp85_ = _tmp84_->home_path;
			_tmp86_ = g_strdup_printf ("+ %s/**", _tmp85_);
			inc_pattern = _tmp86_;
			_tmp87_ = user;
			_tmp88_ = _tmp87_->home_path;
			_tmp89_ = g_strdup_printf ("+ %s/.**", _tmp88_);
			inc_hidden_pattern = _tmp89_;
			_tmp90_ = user;
			if (_tmp90_->has_encrypted_home) {
				SystemUser* _tmp91_;
				const gchar* _tmp92_;
				gchar* _tmp93_;
				SystemUser* _tmp94_;
				const gchar* _tmp95_;
				gchar* _tmp96_;
				_tmp91_ = user;
				_tmp92_ = _tmp91_->name;
				_tmp93_ = g_strdup_printf ("+ /home/.ecryptfs/%s/***", _tmp92_);
				_g_free0 (inc_pattern);
				inc_pattern = _tmp93_;
				_tmp94_ = user;
				_tmp95_ = _tmp94_->name;
				_tmp96_ = g_strdup_printf ("/home/.ecryptfs/%s/***", _tmp95_);
				_g_free0 (exc_pattern);
				exc_pattern = _tmp96_;
			}
			_tmp97_ = self->exclude_list_user;
			_tmp98_ = inc_hidden_pattern;
			include_hidden = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp97_, _tmp98_);
			_tmp99_ = self->exclude_list_user;
			_tmp100_ = inc_pattern;
			include_all = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp99_, _tmp100_);
			if (!include_hidden) {
				_tmp101_ = !include_all;
			} else {
				_tmp101_ = FALSE;
			}
			exclude_all = _tmp101_;
			if (exclude_all) {
				GeeArrayList* _tmp102_;
				const gchar* _tmp103_;
				GeeArrayList* _tmp106_;
				const gchar* _tmp107_;
				GeeArrayList* _tmp110_;
				const gchar* _tmp111_;
				_tmp102_ = self->exclude_list_user;
				_tmp103_ = exc_pattern;
				if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp102_, _tmp103_)) {
					GeeArrayList* _tmp104_;
					const gchar* _tmp105_;
					_tmp104_ = self->exclude_list_user;
					_tmp105_ = exc_pattern;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp104_, _tmp105_);
				}
				_tmp106_ = self->exclude_list_user;
				_tmp107_ = inc_pattern;
				if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp106_, _tmp107_)) {
					GeeArrayList* _tmp108_;
					const gchar* _tmp109_;
					_tmp108_ = self->exclude_list_user;
					_tmp109_ = inc_pattern;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp108_, _tmp109_);
				}
				_tmp110_ = self->exclude_list_user;
				_tmp111_ = inc_hidden_pattern;
				if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp110_, _tmp111_)) {
					GeeArrayList* _tmp112_;
					const gchar* _tmp113_;
					_tmp112_ = self->exclude_list_user;
					_tmp113_ = inc_hidden_pattern;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp112_, _tmp113_);
				}
			}
			_g_free0 (inc_hidden_pattern);
			_g_free0 (inc_pattern);
			_g_free0 (exc_pattern);
			_g_object_unref0 (user);
		}
		_g_object_unref0 (_user_it);
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp114_;
		gint _path_size = 0;
		GeeArrayList* _tmp115_;
		gint _tmp116_;
		gint _tmp117_;
		gint _path_index = 0;
		_tmp114_ = self->exclude_list_home;
		_path_list = _tmp114_;
		_tmp115_ = _path_list;
		_tmp116_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp115_);
		_tmp117_ = _tmp116_;
		_path_size = _tmp117_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp118_;
			gint _tmp119_;
			gchar* path = NULL;
			GeeArrayList* _tmp120_;
			gpointer _tmp121_;
			GeeArrayList* _tmp122_;
			const gchar* _tmp123_;
			_path_index = _path_index + 1;
			_tmp118_ = _path_index;
			_tmp119_ = _path_size;
			if (!(_tmp118_ < _tmp119_)) {
				break;
			}
			_tmp120_ = _path_list;
			_tmp121_ = gee_abstract_list_get ((GeeAbstractList*) _tmp120_, _path_index);
			path = (gchar*) _tmp121_;
			_tmp122_ = list;
			_tmp123_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp122_, _tmp123_)) {
				GeeArrayList* _tmp124_;
				const gchar* _tmp125_;
				_tmp124_ = list;
				_tmp125_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp124_, _tmp125_);
			}
			_g_free0 (path);
		}
	}
	_tmp126_ = g_strdup ("/timeshift/*");
	timeshift_path = _tmp126_;
	_tmp127_ = list;
	_tmp128_ = timeshift_path;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp127_, _tmp128_)) {
		GeeArrayList* _tmp129_;
		const gchar* _tmp130_;
		_tmp129_ = list;
		_tmp130_ = timeshift_path;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp129_, _tmp130_);
	}
	tee_jee_logging_log_debug ("Main: create_exclude_list_for_backup(): exit");
	result = list;
	_g_free0 (timeshift_path);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GeeArrayList*
main_create_exclude_list_for_restore (Main* self)
{
	GeeArrayList* _tmp0_;
	Snapshot* _tmp20_;
	gchar* timeshift_path = NULL;
	gchar* _tmp97_;
	GeeArrayList* _tmp98_;
	const gchar* _tmp99_;
	GeeArrayList* _tmp102_;
	GeeArrayList* _tmp103_;
	GeeArrayList* result;
	g_return_val_if_fail (self != NULL, NULL);
	tee_jee_logging_log_debug ("Main: create_exclude_list_for_restore()");
	_tmp0_ = self->exclude_list_restore;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp1_;
		gint _path_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _path_index = 0;
		_tmp1_ = self->exclude_list_user;
		_path_list = _tmp1_;
		_tmp2_ = _path_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_path_size = _tmp4_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* path = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			const gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			gboolean _tmp12_;
			gboolean _tmp13_ = FALSE;
			GeeArrayList* _tmp14_;
			const gchar* _tmp15_;
			_path_index = _path_index + 1;
			_tmp5_ = _path_index;
			_tmp6_ = _path_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _path_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _path_index);
			path = (gchar*) _tmp8_;
			_tmp9_ = path;
			_tmp10_ = string_strip (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_str_has_prefix (_tmp11_, "+");
			_g_free0 (_tmp11_);
			if (_tmp12_) {
				_g_free0 (path);
				continue;
			}
			_tmp14_ = self->exclude_list_restore;
			_tmp15_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp14_, _tmp15_)) {
				GeeArrayList* _tmp16_;
				const gchar* _tmp17_;
				_tmp16_ = self->exclude_list_home;
				_tmp17_ = path;
				_tmp13_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp16_, _tmp17_);
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GeeArrayList* _tmp18_;
				const gchar* _tmp19_;
				_tmp18_ = self->exclude_list_restore;
				_tmp19_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp18_, _tmp19_);
			}
			_g_free0 (path);
		}
	}
	_tmp20_ = self->snapshot_to_restore;
	if (_tmp20_ != NULL) {
		gchar* list_file = NULL;
		Snapshot* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp21_ = self->snapshot_to_restore;
		_tmp22_ = _tmp21_->path;
		_tmp23_ = tee_jee_file_system_path_combine (_tmp22_, "exclude.list");
		list_file = _tmp23_;
		_tmp24_ = list_file;
		if (tee_jee_file_system_file_exists (_tmp24_)) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar** _tmp28_;
			gchar** _tmp29_;
			gchar** _tmp30_;
			gint _tmp30__length1;
			_tmp25_ = list_file;
			_tmp26_ = tee_jee_file_system_file_read (_tmp25_);
			_tmp27_ = _tmp26_;
			_tmp29_ = _tmp28_ = g_strsplit (_tmp27_, "\n", 0);
			_tmp30_ = _tmp29_;
			_tmp30__length1 = _vala_array_length (_tmp28_);
			_g_free0 (_tmp27_);
			{
				gchar** path_collection = NULL;
				gint path_collection_length1 = 0;
				gint _path_collection_size_ = 0;
				gint path_it = 0;
				path_collection = _tmp30_;
				path_collection_length1 = _tmp30__length1;
				for (path_it = 0; path_it < path_collection_length1; path_it = path_it + 1) {
					gchar* _tmp31_;
					gchar* path = NULL;
					_tmp31_ = g_strdup (path_collection[path_it]);
					path = _tmp31_;
					{
						gboolean _tmp32_ = FALSE;
						GeeArrayList* _tmp33_;
						const gchar* _tmp34_;
						_tmp33_ = self->exclude_list_restore;
						_tmp34_ = path;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp33_, _tmp34_)) {
							GeeArrayList* _tmp35_;
							const gchar* _tmp36_;
							_tmp35_ = self->exclude_list_home;
							_tmp36_ = path;
							_tmp32_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp35_, _tmp36_);
						} else {
							_tmp32_ = FALSE;
						}
						if (_tmp32_) {
							GeeArrayList* _tmp37_;
							const gchar* _tmp38_;
							_tmp37_ = self->exclude_list_restore;
							_tmp38_ = path;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp37_, _tmp38_);
						}
						_g_free0 (path);
					}
				}
				path_collection = (_vala_array_free (path_collection, path_collection_length1, (GDestroyNotify) g_free), NULL);
			}
		}
		_g_free0 (list_file);
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp39_;
		gint _path_size = 0;
		GeeArrayList* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
		gint _path_index = 0;
		_tmp39_ = self->exclude_list_default;
		_path_list = _tmp39_;
		_tmp40_ = _path_list;
		_tmp41_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp40_);
		_tmp42_ = _tmp41_;
		_path_size = _tmp42_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp43_;
			gint _tmp44_;
			gchar* path = NULL;
			GeeArrayList* _tmp45_;
			gpointer _tmp46_;
			GeeArrayList* _tmp47_;
			const gchar* _tmp48_;
			_path_index = _path_index + 1;
			_tmp43_ = _path_index;
			_tmp44_ = _path_size;
			if (!(_tmp43_ < _tmp44_)) {
				break;
			}
			_tmp45_ = _path_list;
			_tmp46_ = gee_abstract_list_get ((GeeAbstractList*) _tmp45_, _path_index);
			path = (gchar*) _tmp46_;
			_tmp47_ = self->exclude_list_restore;
			_tmp48_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp47_, _tmp48_)) {
				GeeArrayList* _tmp49_;
				const gchar* _tmp50_;
				_tmp49_ = self->exclude_list_restore;
				_tmp50_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp49_, _tmp50_);
			}
			_g_free0 (path);
		}
	}
	if (!self->mirror_system) {
		{
			GeeArrayList* _path_list = NULL;
			GeeArrayList* _tmp51_;
			gint _path_size = 0;
			GeeArrayList* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			gint _path_index = 0;
			_tmp51_ = self->exclude_list_default_extra;
			_path_list = _tmp51_;
			_tmp52_ = _path_list;
			_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
			_tmp54_ = _tmp53_;
			_path_size = _tmp54_;
			_path_index = -1;
			while (TRUE) {
				gint _tmp55_;
				gint _tmp56_;
				gchar* path = NULL;
				GeeArrayList* _tmp57_;
				gpointer _tmp58_;
				GeeArrayList* _tmp59_;
				const gchar* _tmp60_;
				_path_index = _path_index + 1;
				_tmp55_ = _path_index;
				_tmp56_ = _path_size;
				if (!(_tmp55_ < _tmp56_)) {
					break;
				}
				_tmp57_ = _path_list;
				_tmp58_ = gee_abstract_list_get ((GeeAbstractList*) _tmp57_, _path_index);
				path = (gchar*) _tmp58_;
				_tmp59_ = self->exclude_list_restore;
				_tmp60_ = path;
				if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp59_, _tmp60_)) {
					GeeArrayList* _tmp61_;
					const gchar* _tmp62_;
					_tmp61_ = self->exclude_list_restore;
					_tmp62_ = path;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp61_, _tmp62_);
				}
				_g_free0 (path);
			}
		}
	}
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp63_;
		gint _entry_size = 0;
		GeeArrayList* _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
		gint _entry_index = 0;
		_tmp63_ = self->exclude_list_apps;
		_entry_list = _tmp63_;
		_tmp64_ = _entry_list;
		_tmp65_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp64_);
		_tmp66_ = _tmp65_;
		_entry_size = _tmp66_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp67_;
			gint _tmp68_;
			AppExcludeEntry* entry = NULL;
			GeeArrayList* _tmp69_;
			gpointer _tmp70_;
			AppExcludeEntry* _tmp71_;
			_entry_index = _entry_index + 1;
			_tmp67_ = _entry_index;
			_tmp68_ = _entry_size;
			if (!(_tmp67_ < _tmp68_)) {
				break;
			}
			_tmp69_ = _entry_list;
			_tmp70_ = gee_abstract_list_get ((GeeAbstractList*) _tmp69_, _entry_index);
			entry = (AppExcludeEntry*) _tmp70_;
			_tmp71_ = entry;
			if (_tmp71_->enabled) {
				{
					GeeArrayList* _pattern_list = NULL;
					AppExcludeEntry* _tmp72_;
					GeeArrayList* _tmp73_;
					gint _pattern_size = 0;
					GeeArrayList* _tmp74_;
					gint _tmp75_;
					gint _tmp76_;
					gint _pattern_index = 0;
					_tmp72_ = entry;
					_tmp73_ = _tmp72_->patterns;
					_pattern_list = _tmp73_;
					_tmp74_ = _pattern_list;
					_tmp75_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp74_);
					_tmp76_ = _tmp75_;
					_pattern_size = _tmp76_;
					_pattern_index = -1;
					while (TRUE) {
						gint _tmp77_;
						gint _tmp78_;
						gchar* pattern = NULL;
						GeeArrayList* _tmp79_;
						gpointer _tmp80_;
						GeeArrayList* _tmp81_;
						const gchar* _tmp82_;
						_pattern_index = _pattern_index + 1;
						_tmp77_ = _pattern_index;
						_tmp78_ = _pattern_size;
						if (!(_tmp77_ < _tmp78_)) {
							break;
						}
						_tmp79_ = _pattern_list;
						_tmp80_ = gee_abstract_list_get ((GeeAbstractList*) _tmp79_, _pattern_index);
						pattern = (gchar*) _tmp80_;
						_tmp81_ = self->exclude_list_restore;
						_tmp82_ = pattern;
						if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp81_, _tmp82_)) {
							GeeArrayList* _tmp83_;
							const gchar* _tmp84_;
							_tmp83_ = self->exclude_list_restore;
							_tmp84_ = pattern;
							gee_abstract_collection_add ((GeeAbstractCollection*) _tmp83_, _tmp84_);
						}
						_g_free0 (pattern);
					}
				}
			}
			_g_object_unref0 (entry);
		}
	}
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp85_;
		gint _path_size = 0;
		GeeArrayList* _tmp86_;
		gint _tmp87_;
		gint _tmp88_;
		gint _path_index = 0;
		_tmp85_ = self->exclude_list_home;
		_path_list = _tmp85_;
		_tmp86_ = _path_list;
		_tmp87_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp86_);
		_tmp88_ = _tmp87_;
		_path_size = _tmp88_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp89_;
			gint _tmp90_;
			gchar* path = NULL;
			GeeArrayList* _tmp91_;
			gpointer _tmp92_;
			GeeArrayList* _tmp93_;
			const gchar* _tmp94_;
			_path_index = _path_index + 1;
			_tmp89_ = _path_index;
			_tmp90_ = _path_size;
			if (!(_tmp89_ < _tmp90_)) {
				break;
			}
			_tmp91_ = _path_list;
			_tmp92_ = gee_abstract_list_get ((GeeAbstractList*) _tmp91_, _path_index);
			path = (gchar*) _tmp92_;
			_tmp93_ = self->exclude_list_restore;
			_tmp94_ = path;
			if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp93_, _tmp94_)) {
				GeeArrayList* _tmp95_;
				const gchar* _tmp96_;
				_tmp95_ = self->exclude_list_restore;
				_tmp96_ = path;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp95_, _tmp96_);
			}
			_g_free0 (path);
		}
	}
	_tmp97_ = g_strdup ("/timeshift/*");
	timeshift_path = _tmp97_;
	_tmp98_ = self->exclude_list_restore;
	_tmp99_ = timeshift_path;
	if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp98_, _tmp99_)) {
		GeeArrayList* _tmp100_;
		const gchar* _tmp101_;
		_tmp100_ = self->exclude_list_restore;
		_tmp101_ = timeshift_path;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, _tmp101_);
	}
	tee_jee_logging_log_debug ("Main: create_exclude_list_for_restore(): exit");
	_tmp102_ = self->exclude_list_restore;
	_tmp103_ = _g_object_ref0 (_tmp102_);
	result = _tmp103_;
	_g_free0 (timeshift_path);
	return result;
}

static gchar*
main_save_exclude_list_for_backup (Main* self,
                                   const gchar* output_path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* txt = NULL;
	gchar* _tmp1_;
	gchar* list_file = NULL;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (output_path != NULL, NULL);
	tee_jee_logging_log_debug ("Main: save_exclude_list_for_backup()");
	_tmp0_ = main_create_exclude_list_for_backup (self);
	list = _tmp0_;
	_tmp1_ = g_strdup ("");
	txt = _tmp1_;
	{
		GeeArrayList* _pattern_list = NULL;
		GeeArrayList* _tmp2_;
		gint _pattern_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pattern_index = 0;
		_tmp2_ = list;
		_pattern_list = _tmp2_;
		_tmp3_ = _pattern_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pattern_size = _tmp5_;
		_pattern_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* pattern = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gboolean _tmp15_;
			_pattern_index = _pattern_index + 1;
			_tmp6_ = _pattern_index;
			_tmp7_ = _pattern_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pattern_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _pattern_index);
			pattern = (gchar*) _tmp9_;
			_tmp10_ = pattern;
			_tmp11_ = string_strip (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_ > 0;
			_g_free0 (_tmp12_);
			if (_tmp15_) {
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				_tmp16_ = txt;
				_tmp17_ = pattern;
				_tmp18_ = g_strdup_printf ("%s\n", _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
				_g_free0 (txt);
				txt = _tmp20_;
				_g_free0 (_tmp19_);
			}
			_g_free0 (pattern);
		}
	}
	_tmp21_ = tee_jee_file_system_path_combine (output_path, "exclude.list");
	list_file = _tmp21_;
	_tmp22_ = list_file;
	_tmp23_ = txt;
	if (tee_jee_file_system_file_write (_tmp22_, _tmp23_)) {
		result = list_file;
		_g_free0 (txt);
		_g_object_unref0 (list);
		return result;
	}
	result = NULL;
	_g_free0 (list_file);
	_g_free0 (txt);
	_g_object_unref0 (list);
	return result;
}

gboolean
main_save_exclude_list_for_restore (Main* self,
                                    const gchar* output_path)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	gchar* txt = NULL;
	gchar* _tmp1_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	const gchar* _tmp25_;
	gboolean _tmp26_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (output_path != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: save_exclude_list_for_restore()");
	_tmp0_ = main_create_exclude_list_for_restore (self);
	list = _tmp0_;
	tee_jee_logging_log_debug ("Exclude list -------------");
	_tmp1_ = g_strdup ("");
	txt = _tmp1_;
	{
		GeeArrayList* _pattern_list = NULL;
		GeeArrayList* _tmp2_;
		gint _pattern_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pattern_index = 0;
		_tmp2_ = list;
		_pattern_list = _tmp2_;
		_tmp3_ = _pattern_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pattern_size = _tmp5_;
		_pattern_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* pattern = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			gint _tmp13_;
			gint _tmp14_;
			gboolean _tmp15_;
			_pattern_index = _pattern_index + 1;
			_tmp6_ = _pattern_index;
			_tmp7_ = _pattern_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pattern_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _pattern_index);
			pattern = (gchar*) _tmp9_;
			_tmp10_ = pattern;
			_tmp11_ = string_strip (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = strlen (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _tmp14_ > 0;
			_g_free0 (_tmp12_);
			if (_tmp15_) {
				const gchar* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				gchar* _tmp20_;
				const gchar* _tmp21_;
				_tmp16_ = txt;
				_tmp17_ = pattern;
				_tmp18_ = g_strdup_printf ("%s\n", _tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = g_strconcat (_tmp16_, _tmp19_, NULL);
				_g_free0 (txt);
				txt = _tmp20_;
				_g_free0 (_tmp19_);
				_tmp21_ = pattern;
				tee_jee_logging_log_debug (_tmp21_);
			}
			_g_free0 (pattern);
		}
	}
	_tmp22_ = main_get_restore_exclude_file (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_;
	_tmp25_ = txt;
	_tmp26_ = tee_jee_file_system_file_write (_tmp24_, _tmp25_);
	_g_free0 (_tmp24_);
	result = _tmp26_;
	_g_free0 (txt);
	_g_object_unref0 (list);
	return result;
}

static gint
__lambda17_ (Main* self,
             const gchar* a,
             const gchar* b)
{
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	result = strcmp (a, b);
	return result;
}

static gint
___lambda17__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda17_ ((Main*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

void
main_save_exclude_list_selections (Main* self)
{
	GeeArrayList* _tmp40_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: save_exclude_list_selections()");
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp0_;
		gint _entry_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _entry_index = 0;
		_tmp0_ = self->exclude_list_apps;
		_entry_list = _tmp0_;
		_tmp1_ = _entry_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_entry_size = _tmp3_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			AppExcludeEntry* entry = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			gboolean _tmp8_ = FALSE;
			AppExcludeEntry* _tmp9_;
			_entry_index = _entry_index + 1;
			_tmp4_ = _entry_index;
			_tmp5_ = _entry_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _entry_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _entry_index);
			entry = (AppExcludeEntry*) _tmp7_;
			_tmp9_ = entry;
			if (_tmp9_->enabled) {
				GeeArrayList* _tmp10_;
				AppExcludeEntry* _tmp11_;
				const gchar* _tmp12_;
				_tmp10_ = self->exclude_app_names;
				_tmp11_ = entry;
				_tmp12_ = _tmp11_->name;
				_tmp8_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp10_, _tmp12_);
			} else {
				_tmp8_ = FALSE;
			}
			if (_tmp8_) {
				GeeArrayList* _tmp13_;
				AppExcludeEntry* _tmp14_;
				const gchar* _tmp15_;
				AppExcludeEntry* _tmp16_;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp13_ = self->exclude_app_names;
				_tmp14_ = entry;
				_tmp15_ = _tmp14_->name;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
				_tmp16_ = entry;
				_tmp17_ = _tmp16_->name;
				_tmp18_ = g_strdup_printf ("add app name: %s", _tmp17_);
				_tmp19_ = _tmp18_;
				tee_jee_logging_log_debug (_tmp19_);
				_g_free0 (_tmp19_);
			}
			_g_object_unref0 (entry);
		}
	}
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp20_;
		gint _entry_size = 0;
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gint _entry_index = 0;
		_tmp20_ = self->exclude_list_apps;
		_entry_list = _tmp20_;
		_tmp21_ = _entry_list;
		_tmp22_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp21_);
		_tmp23_ = _tmp22_;
		_entry_size = _tmp23_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp24_;
			gint _tmp25_;
			AppExcludeEntry* entry = NULL;
			GeeArrayList* _tmp26_;
			gpointer _tmp27_;
			gboolean _tmp28_ = FALSE;
			AppExcludeEntry* _tmp29_;
			_entry_index = _entry_index + 1;
			_tmp24_ = _entry_index;
			_tmp25_ = _entry_size;
			if (!(_tmp24_ < _tmp25_)) {
				break;
			}
			_tmp26_ = _entry_list;
			_tmp27_ = gee_abstract_list_get ((GeeAbstractList*) _tmp26_, _entry_index);
			entry = (AppExcludeEntry*) _tmp27_;
			_tmp29_ = entry;
			if (!_tmp29_->enabled) {
				GeeArrayList* _tmp30_;
				AppExcludeEntry* _tmp31_;
				const gchar* _tmp32_;
				_tmp30_ = self->exclude_app_names;
				_tmp31_ = entry;
				_tmp32_ = _tmp31_->name;
				_tmp28_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp30_, _tmp32_);
			} else {
				_tmp28_ = FALSE;
			}
			if (_tmp28_) {
				GeeArrayList* _tmp33_;
				AppExcludeEntry* _tmp34_;
				const gchar* _tmp35_;
				AppExcludeEntry* _tmp36_;
				const gchar* _tmp37_;
				gchar* _tmp38_;
				gchar* _tmp39_;
				_tmp33_ = self->exclude_app_names;
				_tmp34_ = entry;
				_tmp35_ = _tmp34_->name;
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp33_, _tmp35_);
				_tmp36_ = entry;
				_tmp37_ = _tmp36_->name;
				_tmp38_ = g_strdup_printf ("remove app name: %s", _tmp37_);
				_tmp39_ = _tmp38_;
				tee_jee_logging_log_debug (_tmp39_);
				_g_free0 (_tmp39_);
			}
			_g_object_unref0 (entry);
		}
	}
	_tmp40_ = self->exclude_app_names;
	gee_list_sort ((GeeList*) _tmp40_, ___lambda17__gcompare_data_func, g_object_ref (self), g_object_unref);
}

gboolean
main_live_system (Main* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->_live_system == -1) {
		gchar* cmdline = NULL;
		gchar* _tmp0_;
		gboolean _tmp1_ = FALSE;
		const gchar* _tmp2_;
		_tmp0_ = tee_jee_file_system_file_read ("/proc/cmdline");
		cmdline = _tmp0_;
		_tmp2_ = cmdline;
		if (string_contains (_tmp2_, "boot=casper")) {
			_tmp1_ = TRUE;
		} else {
			const gchar* _tmp3_;
			_tmp3_ = cmdline;
			_tmp1_ = string_contains (_tmp3_, "boot=live");
		}
		if (_tmp1_) {
			tee_jee_logging_log_msg ("Live Session detected, backup is disabled.", FALSE);
			self->priv->_live_system = 1;
		} else {
			self->priv->_live_system = 0;
		}
		_g_free0 (cmdline);
	}
	result = self->priv->_live_system == 1;
	return result;
}

gboolean
main_create_snapshot (Main* self,
                      gboolean is_ondemand,
                      GtkWindow* parent_win)
{
	gboolean status = FALSE;
	gboolean update_symlinks = FALSE;
	const gchar* _tmp0_ = NULL;
	Device* _tmp1_;
	gchar* sys_uuid = NULL;
	gchar* _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: create_snapshot()");
	status = TRUE;
	update_symlinks = FALSE;
	_tmp1_ = self->sys_root;
	if (_tmp1_ == NULL) {
		_tmp0_ = "";
	} else {
		Device* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->sys_root;
		_tmp3_ = _tmp2_->uuid;
		_tmp0_ = _tmp3_;
	}
	_tmp4_ = g_strdup (_tmp0_);
	sys_uuid = _tmp4_;
	{
		gboolean _tmp5_ = FALSE;
		GDateTime* now = NULL;
		GDateTime* _tmp6_;
		SnapshotRepo* _tmp7_;
		GFile* f = NULL;
		SnapshotRepo* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		GFile* _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		gchar* _tmp138_;
		gchar* _tmp139_;
		SnapshotRepo* _tmp140_;
		const gchar* _tmp141_;
		gint _tmp142_;
		gint _tmp143_;
		if (self->btrfs_mode) {
			_tmp5_ = main_check_btrfs_layout_system (self, NULL) == FALSE;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = FALSE;
			_g_free0 (sys_uuid);
			return result;
		}
		_tmp6_ = g_date_time_new_now_local ();
		now = _tmp6_;
		_tmp7_ = self->repo;
		if (!snapshot_repo_has_space (_tmp7_, (guint64) 0)) {
			SnapshotRepo* _tmp8_;
			const gchar* _tmp9_;
			SnapshotRepo* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			gchar* _tmp13_;
			const gchar* _tmp14_;
			gint _tmp15_;
			gint _tmp16_;
			SnapshotRepo* _tmp18_;
			_tmp8_ = self->repo;
			_tmp9_ = _tmp8_->status_message;
			tee_jee_logging_log_error (_tmp9_, FALSE, FALSE);
			_tmp10_ = self->repo;
			_tmp11_ = _tmp10_->status_details;
			_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
			_tmp13_ = _tmp12_;
			tee_jee_logging_log_error (_tmp13_, FALSE, FALSE);
			_g_free0 (_tmp13_);
			_tmp14_ = self->app_mode;
			_tmp15_ = strlen (_tmp14_);
			_tmp16_ = _tmp15_;
			if (_tmp16_ != 0) {
				SnapshotRepo* _tmp17_;
				_tmp17_ = self->repo;
				snapshot_repo_auto_remove (_tmp17_);
			}
			_tmp18_ = self->repo;
			if (!snapshot_repo_has_space (_tmp18_, (guint64) 0)) {
				SnapshotRepo* _tmp19_;
				const gchar* _tmp20_;
				SnapshotRepo* _tmp21_;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp19_ = self->repo;
				_tmp20_ = _tmp19_->status_message;
				tee_jee_logging_log_error (_tmp20_, FALSE, FALSE);
				_tmp21_ = self->repo;
				_tmp22_ = _tmp21_->status_details;
				_tmp23_ = g_strconcat (_tmp22_, "\n", NULL);
				_tmp24_ = _tmp23_;
				tee_jee_logging_log_error (_tmp24_, FALSE, FALSE);
				_g_free0 (_tmp24_);
				result = FALSE;
				_g_date_time_unref0 (now);
				_g_free0 (sys_uuid);
				return result;
			}
		}
		_tmp25_ = self->repo;
		_tmp26_ = snapshot_repo_get_snapshots_path (_tmp25_);
		_tmp27_ = _tmp26_;
		_tmp28_ = _tmp27_;
		_tmp29_ = g_file_new_for_path (_tmp28_);
		_tmp30_ = _tmp29_;
		_g_free0 (_tmp28_);
		f = _tmp30_;
		_tmp31_ = f;
		if (!g_file_query_exists (_tmp31_, NULL)) {
			SnapshotRepo* _tmp32_;
			gchar* _tmp33_;
			gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			GFile* _tmp38_;
			_tmp32_ = self->repo;
			_tmp33_ = snapshot_repo_get_snapshots_path (_tmp32_);
			_tmp34_ = _tmp33_;
			_tmp35_ = _tmp34_;
			_tmp36_ = g_strdup_printf ("mkdir: %s", _tmp35_);
			_tmp37_ = _tmp36_;
			tee_jee_logging_log_debug (_tmp37_);
			_g_free0 (_tmp37_);
			_g_free0 (_tmp35_);
			_tmp38_ = f;
			g_file_make_directory_with_parents (_tmp38_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (f);
				_g_date_time_unref0 (now);
				goto __catch0_g_error;
			}
		}
		if (is_ondemand) {
			gboolean ok = FALSE;
			GDateTime* _tmp39_;
			_tmp39_ = now;
			ok = main_create_snapshot_for_tag (self, "ondemand", _tmp39_);
			if (!ok) {
				result = FALSE;
				_g_object_unref0 (f);
				_g_date_time_unref0 (now);
				_g_free0 (sys_uuid);
				return result;
			} else {
				update_symlinks = TRUE;
			}
		} else {
			gboolean _tmp40_;
			gboolean _tmp41_;
			_tmp40_ = main_get_scheduled (self);
			_tmp41_ = _tmp40_;
			if (_tmp41_) {
				Snapshot* last_snapshot_boot = NULL;
				SnapshotRepo* _tmp42_;
				const gchar* _tmp43_;
				Snapshot* _tmp44_;
				Snapshot* last_snapshot_hourly = NULL;
				SnapshotRepo* _tmp45_;
				const gchar* _tmp46_;
				Snapshot* _tmp47_;
				Snapshot* last_snapshot_daily = NULL;
				SnapshotRepo* _tmp48_;
				const gchar* _tmp49_;
				Snapshot* _tmp50_;
				Snapshot* last_snapshot_weekly = NULL;
				SnapshotRepo* _tmp51_;
				const gchar* _tmp52_;
				Snapshot* _tmp53_;
				Snapshot* last_snapshot_monthly = NULL;
				SnapshotRepo* _tmp54_;
				const gchar* _tmp55_;
				Snapshot* _tmp56_;
				GDateTime* dt_sys_boot = NULL;
				GDateTime* _tmp57_;
				GDateTime* _tmp58_;
				gboolean take_new = FALSE;
				_tmp42_ = self->repo;
				_tmp43_ = sys_uuid;
				_tmp44_ = snapshot_repo_get_latest_snapshot (_tmp42_, "boot", _tmp43_);
				last_snapshot_boot = _tmp44_;
				_tmp45_ = self->repo;
				_tmp46_ = sys_uuid;
				_tmp47_ = snapshot_repo_get_latest_snapshot (_tmp45_, "hourly", _tmp46_);
				last_snapshot_hourly = _tmp47_;
				_tmp48_ = self->repo;
				_tmp49_ = sys_uuid;
				_tmp50_ = snapshot_repo_get_latest_snapshot (_tmp48_, "daily", _tmp49_);
				last_snapshot_daily = _tmp50_;
				_tmp51_ = self->repo;
				_tmp52_ = sys_uuid;
				_tmp53_ = snapshot_repo_get_latest_snapshot (_tmp51_, "weekly", _tmp52_);
				last_snapshot_weekly = _tmp53_;
				_tmp54_ = self->repo;
				_tmp55_ = sys_uuid;
				_tmp56_ = snapshot_repo_get_latest_snapshot (_tmp54_, "monthly", _tmp55_);
				last_snapshot_monthly = _tmp56_;
				_tmp57_ = now;
				_tmp58_ = g_date_time_add_seconds (_tmp57_, -1 * tee_jee_system_get_system_uptime_seconds ());
				dt_sys_boot = _tmp58_;
				take_new = FALSE;
				if (self->schedule_boot) {
					Snapshot* _tmp59_;
					tee_jee_logging_log_msg (_ ("Boot snapshots are enabled"), FALSE);
					_tmp59_ = last_snapshot_boot;
					if (_tmp59_ == NULL) {
						tee_jee_logging_log_msg (_ ("Last boot snapshot not found"), FALSE);
						take_new = TRUE;
					} else {
						Snapshot* _tmp60_;
						GDateTime* _tmp61_;
						GDateTime* _tmp62_;
						_tmp60_ = last_snapshot_boot;
						_tmp61_ = _tmp60_->date;
						_tmp62_ = dt_sys_boot;
						if (g_date_time_compare (_tmp61_, _tmp62_) < 0) {
							tee_jee_logging_log_msg (_ ("Last boot snapshot is older than system start time"), FALSE);
							take_new = TRUE;
						} else {
							gint hours = 0;
							GDateTime* _tmp63_;
							Snapshot* _tmp64_;
							GDateTime* _tmp65_;
							gchar* _tmp66_;
							gchar* _tmp67_;
							_tmp63_ = now;
							_tmp64_ = last_snapshot_boot;
							_tmp65_ = _tmp64_->date;
							hours = (gint) (((gfloat) g_date_time_difference (_tmp63_, _tmp65_)) / G_TIME_SPAN_HOUR);
							_tmp66_ = g_strdup_printf (_ ("Last boot snapshot is %d hours old"), hours);
							_tmp67_ = _tmp66_;
							tee_jee_logging_log_msg (_tmp67_, FALSE);
							_g_free0 (_tmp67_);
							take_new = FALSE;
						}
					}
					if (take_new) {
						GDateTime* _tmp68_;
						_tmp68_ = now;
						status = main_create_snapshot_for_tag (self, "boot", _tmp68_);
						if (!status) {
							tee_jee_logging_log_error (_ ("Boot snapshot failed!"), FALSE, FALSE);
							result = FALSE;
							_g_date_time_unref0 (dt_sys_boot);
							_g_object_unref0 (last_snapshot_monthly);
							_g_object_unref0 (last_snapshot_weekly);
							_g_object_unref0 (last_snapshot_daily);
							_g_object_unref0 (last_snapshot_hourly);
							_g_object_unref0 (last_snapshot_boot);
							_g_object_unref0 (f);
							_g_date_time_unref0 (now);
							_g_free0 (sys_uuid);
							return result;
						} else {
							SnapshotRepo* _tmp69_;
							update_symlinks = TRUE;
							_tmp69_ = self->repo;
							snapshot_repo_load_snapshots (_tmp69_);
						}
					}
				}
				if (self->schedule_hourly) {
					Snapshot* _tmp70_;
					tee_jee_logging_log_msg (_ ("Hourly snapshots are enabled"), FALSE);
					_tmp70_ = last_snapshot_hourly;
					if (_tmp70_ == NULL) {
						tee_jee_logging_log_msg (_ ("Last hourly snapshot not found"), FALSE);
						take_new = TRUE;
					} else {
						Snapshot* _tmp71_;
						GDateTime* _tmp72_;
						GDateTime* _tmp73_;
						GDateTime* _tmp74_;
						GDateTime* _tmp75_;
						GDateTime* _tmp76_;
						GDateTime* _tmp77_;
						gboolean _tmp78_;
						_tmp71_ = last_snapshot_hourly;
						_tmp72_ = _tmp71_->date;
						_tmp73_ = now;
						_tmp74_ = g_date_time_add_hours (_tmp73_, -1);
						_tmp75_ = _tmp74_;
						_tmp76_ = g_date_time_add_minutes (_tmp75_, 1);
						_tmp77_ = _tmp76_;
						_tmp78_ = g_date_time_compare (_tmp72_, _tmp77_) < 0;
						_g_date_time_unref0 (_tmp77_);
						_g_date_time_unref0 (_tmp75_);
						if (_tmp78_) {
							tee_jee_logging_log_msg (_ ("Last hourly snapshot is more than 1 hour old"), FALSE);
							take_new = TRUE;
						} else {
							gint mins = 0;
							GDateTime* _tmp79_;
							Snapshot* _tmp80_;
							GDateTime* _tmp81_;
							gchar* _tmp82_;
							gchar* _tmp83_;
							_tmp79_ = now;
							_tmp80_ = last_snapshot_hourly;
							_tmp81_ = _tmp80_->date;
							mins = (gint) (((gfloat) g_date_time_difference (_tmp79_, _tmp81_)) / G_TIME_SPAN_MINUTE);
							_tmp82_ = g_strdup_printf (_ ("Last hourly snapshot is %d minutes old"), mins);
							_tmp83_ = _tmp82_;
							tee_jee_logging_log_msg (_tmp83_, FALSE);
							_g_free0 (_tmp83_);
							take_new = FALSE;
						}
					}
					if (take_new) {
						GDateTime* _tmp84_;
						_tmp84_ = now;
						status = main_create_snapshot_for_tag (self, "hourly", _tmp84_);
						if (!status) {
							tee_jee_logging_log_error (_ ("Hourly snapshot failed!"), FALSE, FALSE);
							result = FALSE;
							_g_date_time_unref0 (dt_sys_boot);
							_g_object_unref0 (last_snapshot_monthly);
							_g_object_unref0 (last_snapshot_weekly);
							_g_object_unref0 (last_snapshot_daily);
							_g_object_unref0 (last_snapshot_hourly);
							_g_object_unref0 (last_snapshot_boot);
							_g_object_unref0 (f);
							_g_date_time_unref0 (now);
							_g_free0 (sys_uuid);
							return result;
						} else {
							SnapshotRepo* _tmp85_;
							update_symlinks = TRUE;
							_tmp85_ = self->repo;
							snapshot_repo_load_snapshots (_tmp85_);
						}
					}
				}
				if (self->schedule_daily) {
					Snapshot* _tmp86_;
					tee_jee_logging_log_msg (_ ("Daily snapshots are enabled"), FALSE);
					_tmp86_ = last_snapshot_daily;
					if (_tmp86_ == NULL) {
						tee_jee_logging_log_msg (_ ("Last daily snapshot not found"), FALSE);
						take_new = TRUE;
					} else {
						Snapshot* _tmp87_;
						GDateTime* _tmp88_;
						GDateTime* _tmp89_;
						GDateTime* _tmp90_;
						GDateTime* _tmp91_;
						GDateTime* _tmp92_;
						GDateTime* _tmp93_;
						gboolean _tmp94_;
						_tmp87_ = last_snapshot_daily;
						_tmp88_ = _tmp87_->date;
						_tmp89_ = now;
						_tmp90_ = g_date_time_add_days (_tmp89_, -1);
						_tmp91_ = _tmp90_;
						_tmp92_ = g_date_time_add_minutes (_tmp91_, 1);
						_tmp93_ = _tmp92_;
						_tmp94_ = g_date_time_compare (_tmp88_, _tmp93_) < 0;
						_g_date_time_unref0 (_tmp93_);
						_g_date_time_unref0 (_tmp91_);
						if (_tmp94_) {
							tee_jee_logging_log_msg (_ ("Last daily snapshot is more than 1 day old"), FALSE);
							take_new = TRUE;
						} else {
							gint hours = 0;
							GDateTime* _tmp95_;
							Snapshot* _tmp96_;
							GDateTime* _tmp97_;
							gchar* _tmp98_;
							gchar* _tmp99_;
							_tmp95_ = now;
							_tmp96_ = last_snapshot_daily;
							_tmp97_ = _tmp96_->date;
							hours = (gint) (((gfloat) g_date_time_difference (_tmp95_, _tmp97_)) / G_TIME_SPAN_HOUR);
							_tmp98_ = g_strdup_printf (_ ("Last daily snapshot is %d hours old"), hours);
							_tmp99_ = _tmp98_;
							tee_jee_logging_log_msg (_tmp99_, FALSE);
							_g_free0 (_tmp99_);
							take_new = FALSE;
						}
					}
					if (take_new) {
						GDateTime* _tmp100_;
						_tmp100_ = now;
						status = main_create_snapshot_for_tag (self, "daily", _tmp100_);
						if (!status) {
							tee_jee_logging_log_error (_ ("Daily snapshot failed!"), FALSE, FALSE);
							result = FALSE;
							_g_date_time_unref0 (dt_sys_boot);
							_g_object_unref0 (last_snapshot_monthly);
							_g_object_unref0 (last_snapshot_weekly);
							_g_object_unref0 (last_snapshot_daily);
							_g_object_unref0 (last_snapshot_hourly);
							_g_object_unref0 (last_snapshot_boot);
							_g_object_unref0 (f);
							_g_date_time_unref0 (now);
							_g_free0 (sys_uuid);
							return result;
						} else {
							SnapshotRepo* _tmp101_;
							update_symlinks = TRUE;
							_tmp101_ = self->repo;
							snapshot_repo_load_snapshots (_tmp101_);
						}
					}
				}
				if (self->schedule_weekly) {
					Snapshot* _tmp102_;
					tee_jee_logging_log_msg (_ ("Weekly snapshots are enabled"), FALSE);
					_tmp102_ = last_snapshot_weekly;
					if (_tmp102_ == NULL) {
						tee_jee_logging_log_msg (_ ("Last weekly snapshot not found"), FALSE);
						take_new = TRUE;
					} else {
						Snapshot* _tmp103_;
						GDateTime* _tmp104_;
						GDateTime* _tmp105_;
						GDateTime* _tmp106_;
						GDateTime* _tmp107_;
						GDateTime* _tmp108_;
						GDateTime* _tmp109_;
						gboolean _tmp110_;
						_tmp103_ = last_snapshot_weekly;
						_tmp104_ = _tmp103_->date;
						_tmp105_ = now;
						_tmp106_ = g_date_time_add_weeks (_tmp105_, -1);
						_tmp107_ = _tmp106_;
						_tmp108_ = g_date_time_add_minutes (_tmp107_, 1);
						_tmp109_ = _tmp108_;
						_tmp110_ = g_date_time_compare (_tmp104_, _tmp109_) < 0;
						_g_date_time_unref0 (_tmp109_);
						_g_date_time_unref0 (_tmp107_);
						if (_tmp110_) {
							tee_jee_logging_log_msg (_ ("Last weekly snapshot is more than 1 week old"), FALSE);
							take_new = TRUE;
						} else {
							gint days = 0;
							GDateTime* _tmp111_;
							Snapshot* _tmp112_;
							GDateTime* _tmp113_;
							gchar* _tmp114_;
							gchar* _tmp115_;
							_tmp111_ = now;
							_tmp112_ = last_snapshot_weekly;
							_tmp113_ = _tmp112_->date;
							days = (gint) (((gfloat) g_date_time_difference (_tmp111_, _tmp113_)) / G_TIME_SPAN_DAY);
							_tmp114_ = g_strdup_printf (_ ("Last weekly snapshot is %d days old"), days);
							_tmp115_ = _tmp114_;
							tee_jee_logging_log_msg (_tmp115_, FALSE);
							_g_free0 (_tmp115_);
							take_new = FALSE;
						}
					}
					if (take_new) {
						GDateTime* _tmp116_;
						_tmp116_ = now;
						status = main_create_snapshot_for_tag (self, "weekly", _tmp116_);
						if (!status) {
							tee_jee_logging_log_error (_ ("Weekly snapshot failed!"), FALSE, FALSE);
							result = FALSE;
							_g_date_time_unref0 (dt_sys_boot);
							_g_object_unref0 (last_snapshot_monthly);
							_g_object_unref0 (last_snapshot_weekly);
							_g_object_unref0 (last_snapshot_daily);
							_g_object_unref0 (last_snapshot_hourly);
							_g_object_unref0 (last_snapshot_boot);
							_g_object_unref0 (f);
							_g_date_time_unref0 (now);
							_g_free0 (sys_uuid);
							return result;
						} else {
							SnapshotRepo* _tmp117_;
							update_symlinks = TRUE;
							_tmp117_ = self->repo;
							snapshot_repo_load_snapshots (_tmp117_);
						}
					}
				}
				if (self->schedule_monthly) {
					Snapshot* _tmp118_;
					tee_jee_logging_log_msg (_ ("Monthly snapshot are enabled"), FALSE);
					_tmp118_ = last_snapshot_monthly;
					if (_tmp118_ == NULL) {
						tee_jee_logging_log_msg (_ ("Last monthly snapshot not found"), FALSE);
						take_new = TRUE;
					} else {
						Snapshot* _tmp119_;
						GDateTime* _tmp120_;
						GDateTime* _tmp121_;
						GDateTime* _tmp122_;
						GDateTime* _tmp123_;
						GDateTime* _tmp124_;
						GDateTime* _tmp125_;
						gboolean _tmp126_;
						_tmp119_ = last_snapshot_monthly;
						_tmp120_ = _tmp119_->date;
						_tmp121_ = now;
						_tmp122_ = g_date_time_add_months (_tmp121_, -1);
						_tmp123_ = _tmp122_;
						_tmp124_ = g_date_time_add_minutes (_tmp123_, 1);
						_tmp125_ = _tmp124_;
						_tmp126_ = g_date_time_compare (_tmp120_, _tmp125_) < 0;
						_g_date_time_unref0 (_tmp125_);
						_g_date_time_unref0 (_tmp123_);
						if (_tmp126_) {
							tee_jee_logging_log_msg (_ ("Last monthly snapshot is more than 1 month old"), FALSE);
							take_new = TRUE;
						} else {
							gint days = 0;
							GDateTime* _tmp127_;
							Snapshot* _tmp128_;
							GDateTime* _tmp129_;
							gchar* _tmp130_;
							gchar* _tmp131_;
							_tmp127_ = now;
							_tmp128_ = last_snapshot_monthly;
							_tmp129_ = _tmp128_->date;
							days = (gint) (((gfloat) g_date_time_difference (_tmp127_, _tmp129_)) / G_TIME_SPAN_DAY);
							_tmp130_ = g_strdup_printf (_ ("Last monthly snapshot is %d days old"), days);
							_tmp131_ = _tmp130_;
							tee_jee_logging_log_msg (_tmp131_, FALSE);
							_g_free0 (_tmp131_);
							take_new = FALSE;
						}
					}
					if (take_new) {
						GDateTime* _tmp132_;
						_tmp132_ = now;
						status = main_create_snapshot_for_tag (self, "monthly", _tmp132_);
						if (!status) {
							tee_jee_logging_log_error (_ ("Monthly snapshot failed!"), FALSE, FALSE);
							result = FALSE;
							_g_date_time_unref0 (dt_sys_boot);
							_g_object_unref0 (last_snapshot_monthly);
							_g_object_unref0 (last_snapshot_weekly);
							_g_object_unref0 (last_snapshot_daily);
							_g_object_unref0 (last_snapshot_hourly);
							_g_object_unref0 (last_snapshot_boot);
							_g_object_unref0 (f);
							_g_date_time_unref0 (now);
							_g_free0 (sys_uuid);
							return result;
						} else {
							SnapshotRepo* _tmp133_;
							update_symlinks = TRUE;
							_tmp133_ = self->repo;
							snapshot_repo_load_snapshots (_tmp133_);
						}
					}
				}
				_g_date_time_unref0 (dt_sys_boot);
				_g_object_unref0 (last_snapshot_monthly);
				_g_object_unref0 (last_snapshot_weekly);
				_g_object_unref0 (last_snapshot_daily);
				_g_object_unref0 (last_snapshot_hourly);
				_g_object_unref0 (last_snapshot_boot);
			} else {
				gchar* _tmp134_;
				gchar* _tmp135_;
				gchar* _tmp136_;
				gchar* _tmp137_;
				_tmp134_ = g_strconcat (_ ("Scheduled snapshots are disabled"), " - ", NULL);
				_tmp135_ = _tmp134_;
				_tmp136_ = g_strconcat (_tmp135_, _ ("Nothing to do!"), NULL);
				_tmp137_ = _tmp136_;
				tee_jee_logging_log_msg (_tmp137_, FALSE);
				_g_free0 (_tmp137_);
				_g_free0 (_tmp135_);
				main_cron_job_update (self);
			}
		}
		_tmp138_ = g_strnfill ((gsize) 78, '-');
		_tmp139_ = _tmp138_;
		tee_jee_logging_log_msg (_tmp139_, FALSE);
		_g_free0 (_tmp139_);
		_tmp140_ = self->repo;
		snapshot_repo_load_snapshots (_tmp140_);
		_tmp141_ = self->app_mode;
		_tmp142_ = strlen (_tmp141_);
		_tmp143_ = _tmp142_;
		if (_tmp143_ != 0) {
			SnapshotRepo* _tmp144_;
			SnapshotRepo* _tmp145_;
			_tmp144_ = self->repo;
			snapshot_repo_auto_remove (_tmp144_);
			_tmp145_ = self->repo;
			snapshot_repo_load_snapshots (_tmp145_);
		}
		if (update_symlinks) {
			SnapshotRepo* _tmp146_;
			_tmp146_ = self->repo;
			snapshot_repo_create_symlinks (_tmp146_);
		}
		_g_object_unref0 (f);
		_g_date_time_unref0 (now);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp147_;
		const gchar* _tmp148_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp147_ = e;
		_tmp148_ = _tmp147_->message;
		tee_jee_logging_log_error (_tmp148_, FALSE, FALSE);
		result = FALSE;
		_g_error_free0 (e);
		_g_free0 (sys_uuid);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp149_ = FALSE;
		_g_free0 (sys_uuid);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp149_;
	}
	result = status;
	_g_free0 (sys_uuid);
	return result;
}

static gpointer
_g_date_time_ref0 (gpointer self)
{
	return self ? g_date_time_ref (self) : NULL;
}

static gboolean
main_create_snapshot_for_tag (Main* self,
                              const gchar* tag,
                              GDateTime* dt_created)
{
	GDateTime* dt_begin = NULL;
	GDateTime* _tmp0_;
	gboolean status = FALSE;
	GDateTime* now = NULL;
	GDateTime* _tmp1_;
	GDateTime* dt_sys_boot = NULL;
	GDateTime* _tmp2_;
	GDateTime* _tmp3_;
	GDateTime* dt_filter = NULL;
	SnapshotRepo* _tmp40_;
	SnapshotRepo* _tmp45_;
	const gchar* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	Snapshot* new_snapshot = NULL;
	GDateTime* dt_end = NULL;
	GDateTime* _tmp84_;
	GTimeSpan elapsed = 0LL;
	GDateTime* _tmp85_;
	GDateTime* _tmp86_;
	glong seconds = 0L;
	gchar* message = NULL;
	gchar* _tmp87_;
	Snapshot* _tmp88_;
	const gchar* _tmp92_;
	const gchar* _tmp93_;
	Snapshot* _tmp94_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (tag != NULL, FALSE);
	g_return_val_if_fail (dt_created != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: backup_and_rotate()");
	_tmp0_ = g_date_time_new_now_local ();
	dt_begin = _tmp0_;
	status = TRUE;
	_tmp1_ = g_date_time_new_now_local ();
	now = _tmp1_;
	_tmp2_ = now;
	_tmp3_ = g_date_time_add_seconds (_tmp2_, -1 * tee_jee_system_get_system_uptime_seconds ());
	dt_sys_boot = _tmp3_;
	dt_filter = NULL;
	if (g_strcmp0 (tag, "ondemand") != 0) {
		const gchar* _tmp4_;
		GQuark _tmp6_ = 0U;
		static GQuark _tmp5_label0 = 0;
		static GQuark _tmp5_label1 = 0;
		static GQuark _tmp5_label2 = 0;
		static GQuark _tmp5_label3 = 0;
		static GQuark _tmp5_label4 = 0;
		Snapshot* backup_to_rotate = NULL;
		Snapshot* _tmp31_;
		_tmp4_ = tag;
		_tmp6_ = (NULL == _tmp4_) ? 0 : g_quark_from_string (_tmp4_);
		if (_tmp6_ == ((0 != _tmp5_label0) ? _tmp5_label0 : (_tmp5_label0 = g_quark_from_static_string ("boot")))) {
			switch (0) {
				default:
				{
					GDateTime* _tmp7_;
					GDateTime* _tmp8_;
					_tmp7_ = dt_sys_boot;
					_tmp8_ = _g_date_time_ref0 (_tmp7_);
					_g_date_time_unref0 (dt_filter);
					dt_filter = _tmp8_;
					break;
				}
			}
		} else if ((((_tmp6_ == ((0 != _tmp5_label1) ? _tmp5_label1 : (_tmp5_label1 = g_quark_from_static_string ("hourly")))) || (_tmp6_ == ((0 != _tmp5_label2) ? _tmp5_label2 : (_tmp5_label2 = g_quark_from_static_string ("daily"))))) || (_tmp6_ == ((0 != _tmp5_label3) ? _tmp5_label3 : (_tmp5_label3 = g_quark_from_static_string ("weekly"))))) || (_tmp6_ == ((0 != _tmp5_label4) ? _tmp5_label4 : (_tmp5_label4 = g_quark_from_static_string ("monthly"))))) {
			switch (0) {
				default:
				{
					GDateTime* _tmp9_;
					GDateTime* _tmp10_;
					GDateTime* _tmp11_;
					GDateTime* _tmp12_;
					_tmp9_ = now;
					_tmp10_ = g_date_time_add_hours (_tmp9_, -1);
					_tmp11_ = _tmp10_;
					_tmp12_ = g_date_time_add_seconds (_tmp11_, (gdouble) 59);
					_g_date_time_unref0 (dt_filter);
					dt_filter = _tmp12_;
					_g_date_time_unref0 (_tmp11_);
					break;
				}
			}
		} else {
			switch (0) {
				default:
				{
					gchar* _tmp13_;
					gchar* _tmp14_;
					gchar* _tmp15_;
					gchar* _tmp16_;
					_tmp13_ = g_strdup_printf (": %s", tag);
					_tmp14_ = _tmp13_;
					_tmp15_ = g_strconcat (_ ("Unknown snapshot type"), _tmp14_, NULL);
					_tmp16_ = _tmp15_;
					tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
					_g_free0 (_tmp16_);
					_g_free0 (_tmp14_);
					result = FALSE;
					_g_date_time_unref0 (dt_filter);
					_g_date_time_unref0 (dt_sys_boot);
					_g_date_time_unref0 (now);
					_g_date_time_unref0 (dt_begin);
					return result;
				}
			}
		}
		backup_to_rotate = NULL;
		{
			GeeArrayList* _bak_list = NULL;
			SnapshotRepo* _tmp17_;
			GeeArrayList* _tmp18_;
			gint _bak_size = 0;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _bak_index = 0;
			_tmp17_ = self->repo;
			_tmp18_ = _tmp17_->snapshots;
			_bak_list = _tmp18_;
			_tmp19_ = _bak_list;
			_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			_bak_size = _tmp21_;
			_bak_index = -1;
			while (TRUE) {
				gint _tmp22_;
				gint _tmp23_;
				Snapshot* bak = NULL;
				GeeArrayList* _tmp24_;
				gpointer _tmp25_;
				Snapshot* _tmp26_;
				GDateTime* _tmp27_;
				GDateTime* _tmp28_;
				_bak_index = _bak_index + 1;
				_tmp22_ = _bak_index;
				_tmp23_ = _bak_size;
				if (!(_tmp22_ < _tmp23_)) {
					break;
				}
				_tmp24_ = _bak_list;
				_tmp25_ = gee_abstract_list_get ((GeeAbstractList*) _tmp24_, _bak_index);
				bak = (Snapshot*) _tmp25_;
				_tmp26_ = bak;
				_tmp27_ = _tmp26_->date;
				_tmp28_ = dt_filter;
				if (g_date_time_compare (_tmp27_, _tmp28_) > 0) {
					Snapshot* _tmp29_;
					Snapshot* _tmp30_;
					_tmp29_ = bak;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					_g_object_unref0 (backup_to_rotate);
					backup_to_rotate = _tmp30_;
					_g_object_unref0 (bak);
					break;
				}
				_g_object_unref0 (bak);
			}
		}
		_tmp31_ = backup_to_rotate;
		if (_tmp31_ != NULL) {
			Snapshot* _tmp32_;
			gchar* message = NULL;
			Snapshot* _tmp33_;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			gchar* _tmp36_;
			gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp32_ = backup_to_rotate;
			snapshot_add_tag (_tmp32_, tag);
			_tmp33_ = backup_to_rotate;
			_tmp34_ = _tmp33_->name;
			_tmp35_ = g_strdup_printf (" '%s': %s", _tmp34_, tag);
			_tmp36_ = _tmp35_;
			_tmp37_ = g_strconcat (_ ("Tagged snapshot"), _tmp36_, NULL);
			_tmp38_ = _tmp37_;
			_g_free0 (_tmp36_);
			message = _tmp38_;
			_tmp39_ = message;
			tee_jee_logging_log_msg (_tmp39_, FALSE);
			result = TRUE;
			_g_free0 (message);
			_g_object_unref0 (backup_to_rotate);
			_g_date_time_unref0 (dt_filter);
			_g_date_time_unref0 (dt_sys_boot);
			_g_date_time_unref0 (now);
			_g_date_time_unref0 (dt_begin);
			return result;
		}
		_g_object_unref0 (backup_to_rotate);
	}
	_tmp40_ = self->repo;
	if (!snapshot_repo_available (_tmp40_)) {
		SnapshotRepo* _tmp41_;
		const gchar* _tmp42_;
		SnapshotRepo* _tmp43_;
		const gchar* _tmp44_;
		_tmp41_ = self->repo;
		_tmp42_ = _tmp41_->status_message;
		tee_jee_logging_log_error (_tmp42_, FALSE, FALSE);
		_tmp43_ = self->repo;
		_tmp44_ = _tmp43_->status_details;
		tee_jee_logging_log_error (_tmp44_, FALSE, FALSE);
		main_exit_app (self, 0);
	}
	_tmp45_ = self->repo;
	_tmp46_ = _tmp45_->mount_path;
	_tmp47_ = strlen (_tmp46_);
	_tmp48_ = _tmp47_;
	if (_tmp48_ == 0) {
		tee_jee_logging_log_error ("Backup location not mounted", FALSE, FALSE);
		main_exit_app (self, 0);
	}
	new_snapshot = NULL;
	if (self->btrfs_mode) {
		Snapshot* _tmp49_;
		_tmp49_ = main_create_snapshot_with_btrfs (self, tag, dt_created);
		_g_object_unref0 (new_snapshot);
		new_snapshot = _tmp49_;
	} else {
		gboolean _tmp50_ = FALSE;
		if (main_first_snapshot_size > ((guint64) 0)) {
			SnapshotRepo* _tmp51_;
			Device* _tmp52_;
			guint64 _tmp53_;
			guint64 _tmp54_;
			_tmp51_ = self->repo;
			_tmp52_ = _tmp51_->device;
			_tmp53_ = device_get_free_bytes (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp50_ = _tmp54_ < main_first_snapshot_size;
		} else {
			_tmp50_ = FALSE;
		}
		if (_tmp50_) {
			guint64 needed = 0ULL;
			gboolean enough = FALSE;
			SnapshotRepo* _tmp55_;
			gchar* message = NULL;
			gchar* _tmp56_;
			gchar* _tmp57_;
			SnapshotRepo* _tmp58_;
			Device* _tmp59_;
			guint64 _tmp60_;
			guint64 _tmp61_;
			SnapshotRepo* _tmp62_;
			Device* _tmp63_;
			gchar* _tmp64_;
			gchar* _tmp65_;
			gchar* _tmp66_;
			gchar* _tmp67_;
			gchar* _tmp68_;
			const gchar* _tmp69_;
			needed = main_get_space_needed_for_rsync_snapshot (self, dt_created);
			_tmp55_ = self->repo;
			enough = snapshot_repo_has_space (_tmp55_, needed);
			_tmp56_ = tee_jee_file_system_format_file_size (needed, FALSE, "", TRUE, 1);
			_tmp57_ = _tmp56_;
			_tmp58_ = self->repo;
			_tmp59_ = _tmp58_->device;
			_tmp60_ = device_get_free_bytes (_tmp59_);
			_tmp61_ = _tmp60_;
			_tmp62_ = self->repo;
			_tmp63_ = _tmp62_->device;
			_tmp64_ = device_get_free (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = _tmp65_;
			_tmp67_ = g_strdup_printf ("Space required for snapshot: %lld (%s). Space available: %lu (%s)", needed, _tmp57_, _tmp61_, _tmp66_);
			_tmp68_ = _tmp67_;
			_g_free0 (_tmp66_);
			_g_free0 (_tmp57_);
			message = _tmp68_;
			_tmp69_ = message;
			tee_jee_logging_log_msg (_tmp69_, FALSE);
			if (!enough) {
				SnapshotRepo* _tmp70_;
				Device* _tmp71_;
				guint64 _tmp72_;
				guint64 _tmp73_;
				SnapshotRepo* _tmp74_;
				Device* _tmp75_;
				guint64 _tmp76_;
				guint64 _tmp77_;
				gchar* _tmp78_;
				gchar* _tmp79_;
				gchar* _tmp80_;
				const gchar* _tmp81_;
				_tmp70_ = self->repo;
				_tmp71_ = _tmp70_->device;
				_tmp72_ = device_get_free_bytes (_tmp71_);
				_tmp73_ = _tmp72_;
				_tmp74_ = self->repo;
				_tmp75_ = _tmp74_->device;
				_tmp76_ = device_get_free_bytes (_tmp75_);
				_tmp77_ = _tmp76_;
				_tmp78_ = tee_jee_file_system_format_file_size (needed - _tmp77_, FALSE, "", TRUE, 1);
				_tmp79_ = _tmp78_;
				_tmp80_ = g_strdup_printf ("Not enough disk space! Additional required: %lld (%s)", needed - _tmp73_, _tmp79_);
				_g_free0 (message);
				message = _tmp80_;
				_g_free0 (_tmp79_);
				_tmp81_ = message;
				tee_jee_logging_log_msg (_tmp81_, FALSE);
			}
			if (enough) {
				Snapshot* _tmp82_;
				_tmp82_ = main_create_snapshot_with_rsync (self, tag, dt_created);
				_g_object_unref0 (new_snapshot);
				new_snapshot = _tmp82_;
			} else {
				result = FALSE;
				_g_free0 (message);
				_g_object_unref0 (new_snapshot);
				_g_date_time_unref0 (dt_filter);
				_g_date_time_unref0 (dt_sys_boot);
				_g_date_time_unref0 (now);
				_g_date_time_unref0 (dt_begin);
				return result;
			}
			_g_free0 (message);
		} else {
			Snapshot* _tmp83_;
			_tmp83_ = main_create_snapshot_with_rsync (self, tag, dt_created);
			_g_object_unref0 (new_snapshot);
			new_snapshot = _tmp83_;
		}
	}
	_tmp84_ = g_date_time_new_now_local ();
	dt_end = _tmp84_;
	_tmp85_ = dt_end;
	_tmp86_ = dt_begin;
	elapsed = g_date_time_difference (_tmp85_, _tmp86_);
	seconds = (glong) ((elapsed * 1.0) / G_TIME_SPAN_SECOND);
	_tmp87_ = g_strdup ("");
	message = _tmp87_;
	_tmp88_ = new_snapshot;
	if (_tmp88_ != NULL) {
		const gchar* _tmp89_ = NULL;
		gchar* _tmp90_;
		if (self->btrfs_mode) {
			_tmp89_ = "BTRFS";
		} else {
			_tmp89_ = "RSYNC";
		}
		_tmp90_ = g_strdup_printf ("%s %s (%lds)", _tmp89_, _ ("Snapshot saved successfully"), seconds);
		_g_free0 (message);
		message = _tmp90_;
	} else {
		gchar* _tmp91_;
		_tmp91_ = g_strdup (_ ("Failed to create snapshot"));
		_g_free0 (message);
		message = _tmp91_;
	}
	_tmp92_ = message;
	tee_jee_logging_log_msg (_tmp92_, FALSE);
	_tmp93_ = message;
	osd_notify_notify_send ("TimeShift", _tmp93_, 10000, "low", "info");
	_tmp94_ = new_snapshot;
	if (_tmp94_ != NULL) {
		Snapshot* _tmp95_;
		const gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		const gchar* _tmp100_;
		_tmp95_ = new_snapshot;
		_tmp96_ = _tmp95_->name;
		_tmp97_ = g_strdup_printf (" '%s': %s", _tmp96_, tag);
		_tmp98_ = _tmp97_;
		_tmp99_ = g_strconcat (_ ("Tagged snapshot"), _tmp98_, NULL);
		_g_free0 (message);
		message = _tmp99_;
		_g_free0 (_tmp98_);
		_tmp100_ = message;
		tee_jee_logging_log_msg (_tmp100_, FALSE);
	}
	result = status;
	_g_free0 (message);
	_g_date_time_unref0 (dt_end);
	_g_object_unref0 (new_snapshot);
	_g_date_time_unref0 (dt_filter);
	_g_date_time_unref0 (dt_sys_boot);
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (dt_begin);
	return result;
}

static guint64
main_get_space_needed_for_rsync_snapshot (Main* self,
                                          GDateTime* dt_created)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SnapshotRepo* _tmp2_;
	Device* _tmp3_;
	const gchar* _tmp4_;
	SnapshotRepo* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* time_stamp = NULL;
	gchar* _tmp9_;
	gchar* snapshot_dir = NULL;
	SnapshotRepo* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* snapshot_name = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* snapshot_path = NULL;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* localhost_path = NULL;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	const gchar* _tmp22_ = NULL;
	Device* _tmp23_;
	gchar* sys_uuid = NULL;
	gchar* _tmp26_;
	Snapshot* snapshot_to_link = NULL;
	Snapshot* _tmp58_;
	gchar* link_from_path = NULL;
	gchar* _tmp62_;
	Snapshot* _tmp63_;
	gchar* exclude_from_file = NULL;
	const gchar* _tmp71_;
	gchar* _tmp72_;
	const gchar* _tmp73_;
	gchar* _tmp74_;
	const gchar* _tmp75_;
	RsyncSpaceCheckTask* _tmp76_;
	RsyncSpaceCheckTask* _tmp77_;
	gchar* _tmp78_;
	RsyncSpaceCheckTask* _tmp79_;
	const gchar* _tmp80_;
	gchar* _tmp81_;
	RsyncSpaceCheckTask* _tmp82_;
	const gchar* _tmp83_;
	gchar* _tmp84_;
	RsyncSpaceCheckTask* _tmp85_;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	RsyncSpaceCheckTask* _tmp88_;
	RsyncSpaceCheckTask* _tmp89_;
	RsyncSpaceCheckTask* _tmp90_;
	RsyncSpaceCheckTask* _tmp91_;
	RsyncSpaceCheckTask* _tmp92_;
	RsyncSpaceCheckTask* _tmp93_;
	RsyncSpaceCheckTask* _tmp94_;
	gint64 total_size = 0LL;
	RsyncSpaceCheckTask* _tmp97_;
	GError* _inner_error0_ = NULL;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	g_return_val_if_fail (dt_created != NULL, 0ULL);
	_tmp0_ = g_strnfill ((gsize) 78, '-');
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_msg (_tmp1_, FALSE);
	_g_free0 (_tmp1_);
	tee_jee_logging_log_msg ("Checking if target drive has enough free space for a snapshot (RSYNC)", FALSE);
	_tmp2_ = self->repo;
	_tmp3_ = _tmp2_->device;
	_tmp4_ = _tmp3_->device;
	_tmp5_ = self->repo;
	_tmp6_ = _tmp5_->mount_path;
	_tmp7_ = g_strdup_printf ("Target device: %s, mount path: %s", _tmp4_, _tmp6_);
	_tmp8_ = _tmp7_;
	tee_jee_logging_log_msg (_tmp8_, FALSE);
	_g_free0 (_tmp8_);
	_tmp9_ = g_date_time_format (dt_created, "%Y-%m-%d_%H-%M-%S");
	time_stamp = _tmp9_;
	_tmp10_ = self->repo;
	_tmp11_ = snapshot_repo_get_snapshots_path (_tmp10_);
	_tmp12_ = _tmp11_;
	snapshot_dir = _tmp12_;
	_tmp13_ = time_stamp;
	_tmp14_ = g_strdup (_tmp13_);
	snapshot_name = _tmp14_;
	_tmp15_ = snapshot_dir;
	_tmp16_ = snapshot_name;
	_tmp17_ = tee_jee_file_system_path_combine (_tmp15_, _tmp16_);
	snapshot_path = _tmp17_;
	_tmp18_ = snapshot_path;
	tee_jee_file_system_dir_create (_tmp18_, FALSE);
	_tmp19_ = snapshot_path;
	_tmp20_ = tee_jee_file_system_path_combine (_tmp19_, "localhost");
	localhost_path = _tmp20_;
	_tmp21_ = localhost_path;
	tee_jee_file_system_dir_create (_tmp21_, FALSE);
	_tmp23_ = self->sys_root;
	if (_tmp23_ == NULL) {
		_tmp22_ = "";
	} else {
		Device* _tmp24_;
		const gchar* _tmp25_;
		_tmp24_ = self->sys_root;
		_tmp25_ = _tmp24_->uuid;
		_tmp22_ = _tmp25_;
	}
	_tmp26_ = g_strdup (_tmp22_);
	sys_uuid = _tmp26_;
	snapshot_to_link = NULL;
	{
		gchar* ctl_path = NULL;
		const gchar* _tmp27_;
		gchar* _tmp28_;
		GFile* f = NULL;
		const gchar* _tmp29_;
		GFile* _tmp30_;
		GFile* _tmp31_;
		_tmp27_ = snapshot_dir;
		_tmp28_ = tee_jee_file_system_path_combine (_tmp27_, ".sync-restore");
		ctl_path = _tmp28_;
		_tmp29_ = ctl_path;
		_tmp30_ = g_file_new_for_path (_tmp29_);
		f = _tmp30_;
		_tmp31_ = f;
		if (g_file_query_exists (_tmp31_, NULL)) {
			gchar* snap_path = NULL;
			const gchar* _tmp32_;
			gchar* _tmp33_;
			gchar* snap_name = NULL;
			const gchar* _tmp34_;
			gchar* _tmp35_;
			_tmp32_ = ctl_path;
			_tmp33_ = tee_jee_file_system_file_read (_tmp32_);
			snap_path = _tmp33_;
			_tmp34_ = snap_path;
			_tmp35_ = tee_jee_file_system_file_basename (_tmp34_);
			snap_name = _tmp35_;
			{
				GeeArrayList* _bak_list = NULL;
				SnapshotRepo* _tmp36_;
				GeeArrayList* _tmp37_;
				gint _bak_size = 0;
				GeeArrayList* _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _bak_index = 0;
				_tmp36_ = self->repo;
				_tmp37_ = _tmp36_->snapshots;
				_bak_list = _tmp37_;
				_tmp38_ = _bak_list;
				_tmp39_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp38_);
				_tmp40_ = _tmp39_;
				_bak_size = _tmp40_;
				_bak_index = -1;
				while (TRUE) {
					gint _tmp41_;
					gint _tmp42_;
					Snapshot* bak = NULL;
					GeeArrayList* _tmp43_;
					gpointer _tmp44_;
					gboolean _tmp45_ = FALSE;
					Snapshot* _tmp46_;
					const gchar* _tmp47_;
					const gchar* _tmp48_;
					_bak_index = _bak_index + 1;
					_tmp41_ = _bak_index;
					_tmp42_ = _bak_size;
					if (!(_tmp41_ < _tmp42_)) {
						break;
					}
					_tmp43_ = _bak_list;
					_tmp44_ = gee_abstract_list_get ((GeeAbstractList*) _tmp43_, _bak_index);
					bak = (Snapshot*) _tmp44_;
					_tmp46_ = bak;
					_tmp47_ = _tmp46_->name;
					_tmp48_ = snap_name;
					if (g_strcmp0 (_tmp47_, _tmp48_) == 0) {
						Snapshot* _tmp49_;
						const gchar* _tmp50_;
						const gchar* _tmp51_;
						_tmp49_ = bak;
						_tmp50_ = _tmp49_->sys_uuid;
						_tmp51_ = sys_uuid;
						_tmp45_ = g_strcmp0 (_tmp50_, _tmp51_) == 0;
					} else {
						_tmp45_ = FALSE;
					}
					if (_tmp45_) {
						Snapshot* _tmp52_;
						Snapshot* _tmp53_;
						GFile* _tmp54_;
						_tmp52_ = bak;
						_tmp53_ = _g_object_ref0 (_tmp52_);
						_g_object_unref0 (snapshot_to_link);
						snapshot_to_link = _tmp53_;
						_tmp54_ = f;
						g_file_delete (_tmp54_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (bak);
							_g_free0 (snap_name);
							_g_free0 (snap_path);
							_g_object_unref0 (f);
							_g_free0 (ctl_path);
							goto __catch0_g_error;
						}
						_g_object_unref0 (bak);
						break;
					}
					_g_object_unref0 (bak);
				}
			}
			_g_free0 (snap_name);
			_g_free0 (snap_path);
		}
		_g_object_unref0 (f);
		_g_free0 (ctl_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp55_;
		const gchar* _tmp56_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp55_ = e;
		_tmp56_ = _tmp55_->message;
		tee_jee_logging_log_error (_tmp56_, FALSE, FALSE);
		result = (guint64) 0;
		_g_error_free0 (e);
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		guint64 _tmp57_ = 0ULL;
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp57_;
	}
	_tmp58_ = snapshot_to_link;
	if (_tmp58_ == NULL) {
		SnapshotRepo* _tmp59_;
		const gchar* _tmp60_;
		Snapshot* _tmp61_;
		_tmp59_ = self->repo;
		_tmp60_ = sys_uuid;
		_tmp61_ = snapshot_repo_get_latest_snapshot (_tmp59_, "", _tmp60_);
		_g_object_unref0 (snapshot_to_link);
		snapshot_to_link = _tmp61_;
	}
	_tmp62_ = g_strdup ("");
	link_from_path = _tmp62_;
	_tmp63_ = snapshot_to_link;
	if (_tmp63_ != NULL) {
		Snapshot* _tmp64_;
		const gchar* _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		Snapshot* _tmp68_;
		const gchar* _tmp69_;
		gchar* _tmp70_;
		_tmp64_ = snapshot_to_link;
		_tmp65_ = _tmp64_->name;
		_tmp66_ = g_strdup_printf ("Linking from snapshot: %s", _tmp65_);
		_tmp67_ = _tmp66_;
		tee_jee_logging_log_msg (_tmp67_, FALSE);
		_g_free0 (_tmp67_);
		_tmp68_ = snapshot_to_link;
		_tmp69_ = _tmp68_->path;
		_tmp70_ = g_strdup_printf ("%s/localhost/", _tmp69_);
		_g_free0 (link_from_path);
		link_from_path = _tmp70_;
	}
	_tmp71_ = snapshot_path;
	_tmp72_ = main_save_exclude_list_for_backup (self, _tmp71_);
	exclude_from_file = _tmp72_;
	_tmp73_ = exclude_from_file;
	if (NULL == _tmp73_) {
		tee_jee_logging_log_error ("Failed to save exclude list", FALSE, FALSE);
		result = (guint64) 0;
		_g_free0 (exclude_from_file);
		_g_free0 (link_from_path);
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		return result;
	}
	_tmp74_ = g_strdup (_ ("Calculating required disk space..."));
	_g_free0 (self->progress_text);
	self->progress_text = _tmp74_;
	_tmp75_ = self->progress_text;
	tee_jee_logging_log_msg (_tmp75_, FALSE);
	_tmp76_ = rsync_space_check_task_new ();
	_g_object_unref0 (self->space_check_task);
	self->space_check_task = _tmp76_;
	_tmp77_ = self->space_check_task;
	_tmp78_ = g_strdup ("");
	_g_free0 (_tmp77_->source_path);
	_tmp77_->source_path = _tmp78_;
	_tmp79_ = self->space_check_task;
	_tmp80_ = snapshot_path;
	_tmp81_ = g_strconcat (_tmp80_, "/localhost/", NULL);
	_g_free0 (_tmp79_->dest_path);
	_tmp79_->dest_path = _tmp81_;
	_tmp82_ = self->space_check_task;
	_tmp83_ = link_from_path;
	_tmp84_ = g_strdup (_tmp83_);
	_g_free0 (_tmp82_->link_from_path);
	_tmp82_->link_from_path = _tmp84_;
	_tmp85_ = self->space_check_task;
	_tmp86_ = exclude_from_file;
	_tmp87_ = g_strdup (_tmp86_);
	_g_free0 (_tmp85_->exclude_from_file);
	_tmp85_->exclude_from_file = _tmp87_;
	_tmp88_ = self->space_check_task;
	((AsyncTask*) _tmp88_)->prg_count_total = main_first_snapshot_count;
	_tmp89_ = self->space_check_task;
	_tmp89_->relative = TRUE;
	_tmp90_ = self->space_check_task;
	_tmp90_->verbose = TRUE;
	_tmp91_ = self->space_check_task;
	_tmp91_->delete_extra = TRUE;
	_tmp92_ = self->space_check_task;
	_tmp92_->delete_excluded = TRUE;
	_tmp93_ = self->space_check_task;
	_tmp93_->delete_after = FALSE;
	_tmp94_ = self->space_check_task;
	async_task_execute ((AsyncTask*) _tmp94_);
	while (TRUE) {
		RsyncSpaceCheckTask* _tmp95_;
		FILE* _tmp96_;
		_tmp95_ = self->space_check_task;
		if (!(((AsyncTask*) _tmp95_)->status == APP_STATUS_RUNNING)) {
			break;
		}
		tee_jee_system_sleep (1000);
		tee_jee_gtk_helper_gtk_do_events ();
		_tmp96_ = stdout;
		fflush (_tmp96_);
	}
	_tmp97_ = self->space_check_task;
	total_size = _tmp97_->total_size;
	_g_object_unref0 (self->space_check_task);
	self->space_check_task = NULL;
	result = (guint64) total_size;
	_g_free0 (exclude_from_file);
	_g_free0 (link_from_path);
	_g_object_unref0 (snapshot_to_link);
	_g_free0 (sys_uuid);
	_g_free0 (localhost_path);
	_g_free0 (snapshot_path);
	_g_free0 (snapshot_name);
	_g_free0 (snapshot_dir);
	_g_free0 (time_stamp);
	return result;
}

static Snapshot*
main_create_snapshot_with_rsync (Main* self,
                                 const gchar* tag,
                                 GDateTime* dt_created)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	SnapshotRepo* _tmp4_;
	Device* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	SnapshotRepo* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	SnapshotRepo* _tmp21_;
	const gchar* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	gchar* time_stamp = NULL;
	gchar* _tmp25_;
	gchar* snapshot_dir = NULL;
	SnapshotRepo* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* snapshot_name = NULL;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* snapshot_path = NULL;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	const gchar* _tmp34_;
	gchar* localhost_path = NULL;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_ = NULL;
	Device* _tmp39_;
	gchar* sys_uuid = NULL;
	gchar* _tmp42_;
	Snapshot* snapshot_to_link = NULL;
	Snapshot* _tmp73_;
	gchar* link_from_path = NULL;
	gchar* _tmp77_;
	Snapshot* _tmp78_;
	gchar* exclude_from_file = NULL;
	const gchar* _tmp86_;
	gchar* _tmp87_;
	const gchar* _tmp88_;
	gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar* log_file = NULL;
	const gchar* _tmp91_;
	gchar* _tmp92_;
	const gchar* _tmp93_;
	RsyncTask* _tmp94_;
	RsyncTask* _tmp95_;
	gchar* _tmp96_;
	RsyncTask* _tmp97_;
	const gchar* _tmp98_;
	gchar* _tmp99_;
	RsyncTask* _tmp100_;
	const gchar* _tmp101_;
	gchar* _tmp102_;
	RsyncTask* _tmp103_;
	const gchar* _tmp104_;
	gchar* _tmp105_;
	RsyncTask* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	RsyncTask* _tmp109_;
	RsyncTask* _tmp110_;
	RsyncTask* _tmp111_;
	RsyncTask* _tmp112_;
	RsyncTask* _tmp113_;
	RsyncTask* _tmp114_;
	const gchar* _tmp115_;
	gint _tmp116_;
	gint _tmp117_;
	RsyncTask* _tmp119_;
	FILE* _tmp132_;
	gchar* _tmp133_;
	gchar* _tmp134_;
	FILE* _tmp135_;
	FILE* _tmp136_;
	FILE* _tmp137_;
	RsyncTask* _tmp138_;
	const gchar* _tmp139_ = NULL;
	gchar* initial_tags = NULL;
	gchar* _tmp140_;
	gint64 fcount = 0LL;
	const gchar* _tmp141_;
	gint64* _tmp142_;
	gint64* _tmp143_;
	gint64 _tmp144_;
	Snapshot* snapshot = NULL;
	const gchar* _tmp145_;
	const gchar* _tmp146_;
	LinuxDistro* _tmp147_;
	gchar* _tmp148_;
	gchar* _tmp149_;
	const gchar* _tmp150_;
	const gchar* _tmp151_;
	SnapshotRepo* _tmp152_;
	Snapshot* _tmp153_;
	Snapshot* _tmp154_;
	Snapshot* _tmp155_;
	const gchar* _tmp156_;
	GError* _inner_error0_ = NULL;
	Snapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (dt_created != NULL, NULL);
	_tmp0_ = g_strnfill ((gsize) 78, '-');
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_msg (_tmp1_, FALSE);
	_g_free0 (_tmp1_);
	if (main_first_snapshot_size == ((guint64) 0)) {
		tee_jee_logging_log_msg (_ ("Estimating system size..."), FALSE);
		main_estimate_system_size (self, NULL, NULL);
	}
	_tmp2_ = g_strconcat (_ ("Creating new snapshot..."), "(RSYNC)", NULL);
	_tmp3_ = _tmp2_;
	tee_jee_logging_log_msg (_tmp3_, FALSE);
	_g_free0 (_tmp3_);
	_tmp4_ = self->repo;
	_tmp5_ = _tmp4_->device;
	_tmp6_ = _tmp5_->device;
	_tmp7_ = g_strdup_printf (": %s", _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_ ("Saving to device"), _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, ", ", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_strconcat (_tmp12_, _ ("mounted at path"), NULL);
	_tmp14_ = _tmp13_;
	_tmp15_ = self->repo;
	_tmp16_ = _tmp15_->mount_path;
	_tmp17_ = g_strdup_printf (": %s", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp14_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	tee_jee_logging_log_msg (_tmp20_, FALSE);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp21_ = self->repo;
	_tmp22_ = _tmp21_->mount_path;
	_tmp23_ = strlen (_tmp22_);
	_tmp24_ = _tmp23_;
	if (_tmp24_ == 0) {
		tee_jee_logging_log_error ("Backup location not mounted", FALSE, FALSE);
		main_exit_app (self, 0);
	}
	_tmp25_ = g_date_time_format (dt_created, "%Y-%m-%d_%H-%M-%S");
	time_stamp = _tmp25_;
	_tmp26_ = self->repo;
	_tmp27_ = snapshot_repo_get_snapshots_path (_tmp26_);
	_tmp28_ = _tmp27_;
	snapshot_dir = _tmp28_;
	_tmp29_ = time_stamp;
	_tmp30_ = g_strdup (_tmp29_);
	snapshot_name = _tmp30_;
	_tmp31_ = snapshot_dir;
	_tmp32_ = snapshot_name;
	_tmp33_ = tee_jee_file_system_path_combine (_tmp31_, _tmp32_);
	snapshot_path = _tmp33_;
	_tmp34_ = snapshot_path;
	tee_jee_file_system_dir_create (_tmp34_, FALSE);
	_tmp35_ = snapshot_path;
	_tmp36_ = tee_jee_file_system_path_combine (_tmp35_, "localhost");
	localhost_path = _tmp36_;
	_tmp37_ = localhost_path;
	tee_jee_file_system_dir_create (_tmp37_, FALSE);
	_tmp39_ = self->sys_root;
	if (_tmp39_ == NULL) {
		_tmp38_ = "";
	} else {
		Device* _tmp40_;
		const gchar* _tmp41_;
		_tmp40_ = self->sys_root;
		_tmp41_ = _tmp40_->uuid;
		_tmp38_ = _tmp41_;
	}
	_tmp42_ = g_strdup (_tmp38_);
	sys_uuid = _tmp42_;
	snapshot_to_link = NULL;
	{
		gchar* ctl_path = NULL;
		const gchar* _tmp43_;
		gchar* _tmp44_;
		GFile* f = NULL;
		const gchar* _tmp45_;
		GFile* _tmp46_;
		GFile* _tmp47_;
		_tmp43_ = snapshot_dir;
		_tmp44_ = tee_jee_file_system_path_combine (_tmp43_, ".sync-restore");
		ctl_path = _tmp44_;
		_tmp45_ = ctl_path;
		_tmp46_ = g_file_new_for_path (_tmp45_);
		f = _tmp46_;
		_tmp47_ = f;
		if (g_file_query_exists (_tmp47_, NULL)) {
			gchar* snap_path = NULL;
			const gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* snap_name = NULL;
			const gchar* _tmp50_;
			gchar* _tmp51_;
			_tmp48_ = ctl_path;
			_tmp49_ = tee_jee_file_system_file_read (_tmp48_);
			snap_path = _tmp49_;
			_tmp50_ = snap_path;
			_tmp51_ = tee_jee_file_system_file_basename (_tmp50_);
			snap_name = _tmp51_;
			{
				GeeArrayList* _bak_list = NULL;
				SnapshotRepo* _tmp52_;
				GeeArrayList* _tmp53_;
				gint _bak_size = 0;
				GeeArrayList* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
				gint _bak_index = 0;
				_tmp52_ = self->repo;
				_tmp53_ = _tmp52_->snapshots;
				_bak_list = _tmp53_;
				_tmp54_ = _bak_list;
				_tmp55_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp54_);
				_tmp56_ = _tmp55_;
				_bak_size = _tmp56_;
				_bak_index = -1;
				while (TRUE) {
					gint _tmp57_;
					gint _tmp58_;
					Snapshot* bak = NULL;
					GeeArrayList* _tmp59_;
					gpointer _tmp60_;
					gboolean _tmp61_ = FALSE;
					Snapshot* _tmp62_;
					const gchar* _tmp63_;
					const gchar* _tmp64_;
					_bak_index = _bak_index + 1;
					_tmp57_ = _bak_index;
					_tmp58_ = _bak_size;
					if (!(_tmp57_ < _tmp58_)) {
						break;
					}
					_tmp59_ = _bak_list;
					_tmp60_ = gee_abstract_list_get ((GeeAbstractList*) _tmp59_, _bak_index);
					bak = (Snapshot*) _tmp60_;
					_tmp62_ = bak;
					_tmp63_ = _tmp62_->name;
					_tmp64_ = snap_name;
					if (g_strcmp0 (_tmp63_, _tmp64_) == 0) {
						Snapshot* _tmp65_;
						const gchar* _tmp66_;
						const gchar* _tmp67_;
						_tmp65_ = bak;
						_tmp66_ = _tmp65_->sys_uuid;
						_tmp67_ = sys_uuid;
						_tmp61_ = g_strcmp0 (_tmp66_, _tmp67_) == 0;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						Snapshot* _tmp68_;
						Snapshot* _tmp69_;
						GFile* _tmp70_;
						_tmp68_ = bak;
						_tmp69_ = _g_object_ref0 (_tmp68_);
						_g_object_unref0 (snapshot_to_link);
						snapshot_to_link = _tmp69_;
						_tmp70_ = f;
						g_file_delete (_tmp70_, NULL, &_inner_error0_);
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (bak);
							_g_free0 (snap_name);
							_g_free0 (snap_path);
							_g_object_unref0 (f);
							_g_free0 (ctl_path);
							goto __catch0_g_error;
						}
						_g_object_unref0 (bak);
						break;
					}
					_g_object_unref0 (bak);
				}
			}
			_g_free0 (snap_name);
			_g_free0 (snap_path);
		}
		_g_object_unref0 (f);
		_g_free0 (ctl_path);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp71_;
		const gchar* _tmp72_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp71_ = e;
		_tmp72_ = _tmp71_->message;
		tee_jee_logging_log_error (_tmp72_, FALSE, FALSE);
		result = NULL;
		_g_error_free0 (e);
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp73_ = snapshot_to_link;
	if (_tmp73_ == NULL) {
		SnapshotRepo* _tmp74_;
		const gchar* _tmp75_;
		Snapshot* _tmp76_;
		_tmp74_ = self->repo;
		_tmp75_ = sys_uuid;
		_tmp76_ = snapshot_repo_get_latest_snapshot (_tmp74_, "", _tmp75_);
		_g_object_unref0 (snapshot_to_link);
		snapshot_to_link = _tmp76_;
	}
	_tmp77_ = g_strdup ("");
	link_from_path = _tmp77_;
	_tmp78_ = snapshot_to_link;
	if (_tmp78_ != NULL) {
		Snapshot* _tmp79_;
		const gchar* _tmp80_;
		gchar* _tmp81_;
		gchar* _tmp82_;
		Snapshot* _tmp83_;
		const gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp79_ = snapshot_to_link;
		_tmp80_ = _tmp79_->name;
		_tmp81_ = g_strdup_printf ("%s: %s", _ ("Linking from snapshot"), _tmp80_);
		_tmp82_ = _tmp81_;
		tee_jee_logging_log_msg (_tmp82_, FALSE);
		_g_free0 (_tmp82_);
		_tmp83_ = snapshot_to_link;
		_tmp84_ = _tmp83_->path;
		_tmp85_ = g_strdup_printf ("%s/localhost/", _tmp84_);
		_g_free0 (link_from_path);
		link_from_path = _tmp85_;
	}
	_tmp86_ = snapshot_path;
	_tmp87_ = main_save_exclude_list_for_backup (self, _tmp86_);
	exclude_from_file = _tmp87_;
	_tmp88_ = exclude_from_file;
	if (NULL == _tmp88_) {
		tee_jee_logging_log_error (_ ("Failed to save exclude list"), FALSE, FALSE);
		result = NULL;
		_g_free0 (exclude_from_file);
		_g_free0 (link_from_path);
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		return result;
	}
	_tmp89_ = g_strdup (_ ("Syncing files with rsync..."));
	_g_free0 (self->progress_text);
	self->progress_text = _tmp89_;
	_tmp90_ = self->progress_text;
	tee_jee_logging_log_msg (_tmp90_, FALSE);
	_tmp91_ = snapshot_path;
	_tmp92_ = g_strconcat (_tmp91_, "/rsync-log", NULL);
	log_file = _tmp92_;
	_tmp93_ = log_file;
	tee_jee_file_system_file_delete (_tmp93_);
	_tmp94_ = rsync_task_new ();
	_g_object_unref0 (self->task);
	self->task = _tmp94_;
	_tmp95_ = self->task;
	_tmp96_ = g_strdup ("");
	_g_free0 (_tmp95_->source_path);
	_tmp95_->source_path = _tmp96_;
	_tmp97_ = self->task;
	_tmp98_ = snapshot_path;
	_tmp99_ = g_strconcat (_tmp98_, "/localhost/", NULL);
	_g_free0 (_tmp97_->dest_path);
	_tmp97_->dest_path = _tmp99_;
	_tmp100_ = self->task;
	_tmp101_ = link_from_path;
	_tmp102_ = g_strdup (_tmp101_);
	_g_free0 (_tmp100_->link_from_path);
	_tmp100_->link_from_path = _tmp102_;
	_tmp103_ = self->task;
	_tmp104_ = exclude_from_file;
	_tmp105_ = g_strdup (_tmp104_);
	_g_free0 (_tmp103_->exclude_from_file);
	_tmp103_->exclude_from_file = _tmp105_;
	_tmp106_ = self->task;
	_tmp107_ = log_file;
	_tmp108_ = g_strdup (_tmp107_);
	_g_free0 (_tmp106_->rsync_log_file);
	_tmp106_->rsync_log_file = _tmp108_;
	_tmp109_ = self->task;
	((AsyncTask*) _tmp109_)->prg_count_total = main_first_snapshot_count;
	_tmp110_ = self->task;
	_tmp110_->relative = TRUE;
	_tmp111_ = self->task;
	_tmp111_->verbose = TRUE;
	_tmp112_ = self->task;
	_tmp112_->delete_extra = TRUE;
	_tmp113_ = self->task;
	_tmp113_->delete_excluded = TRUE;
	_tmp114_ = self->task;
	_tmp114_->delete_after = FALSE;
	_tmp115_ = self->app_mode;
	_tmp116_ = strlen (_tmp115_);
	_tmp117_ = _tmp116_;
	if (_tmp117_ > 0) {
		RsyncTask* _tmp118_;
		_tmp118_ = self->task;
		_tmp118_->io_nice = TRUE;
	}
	_tmp119_ = self->task;
	async_task_execute ((AsyncTask*) _tmp119_);
	while (TRUE) {
		gboolean _tmp120_ = FALSE;
		RsyncTask* _tmp121_;
		FILE* _tmp123_;
		RsyncTask* _tmp124_;
		RsyncTask* _tmp125_;
		gchar* _tmp126_;
		gchar* _tmp127_;
		gchar* _tmp128_;
		gchar* _tmp129_;
		gchar* _tmp130_;
		FILE* _tmp131_;
		_tmp121_ = self->task;
		if (((AsyncTask*) _tmp121_)->status == APP_STATUS_RUNNING) {
			_tmp120_ = TRUE;
		} else {
			RsyncTask* _tmp122_;
			_tmp122_ = self->task;
			_tmp120_ = ((AsyncTask*) _tmp122_)->status == APP_STATUS_PAUSED;
		}
		if (!_tmp120_) {
			break;
		}
		tee_jee_system_sleep (1000);
		tee_jee_gtk_helper_gtk_do_events ();
		_tmp123_ = stdout;
		_tmp124_ = self->task;
		_tmp125_ = self->task;
		_tmp126_ = async_task_get_stat_time_remaining ((AsyncTask*) _tmp125_);
		_tmp127_ = _tmp126_;
		_tmp128_ = _tmp127_;
		_tmp129_ = g_strdup_printf ("%6.2f%% %s (%s %s)\r", ((AsyncTask*) _tmp124_)->progress * 100.0, _ ("complete"), _tmp128_, _ ("remaining"));
		_tmp130_ = _tmp129_;
		fprintf (_tmp123_, "%s", _tmp130_);
		_g_free0 (_tmp130_);
		_g_free0 (_tmp128_);
		_tmp131_ = stdout;
		fflush (_tmp131_);
	}
	_tmp132_ = stdout;
	_tmp133_ = g_strnfill ((gsize) 80, ' ');
	_tmp134_ = _tmp133_;
	fprintf (_tmp132_, "%s", _tmp134_);
	_g_free0 (_tmp134_);
	_tmp135_ = stdout;
	fflush (_tmp135_);
	_tmp136_ = stdout;
	fprintf (_tmp136_, "\r");
	_tmp137_ = stdout;
	fflush (_tmp137_);
	_tmp138_ = self->task;
	if (_tmp138_->total_size == ((gint64) 0)) {
		tee_jee_logging_log_error (_ ("rsync returned an error"), FALSE, FALSE);
		tee_jee_logging_log_error (_ ("Failed to create new snapshot"), FALSE, FALSE);
		result = NULL;
		_g_free0 (log_file);
		_g_free0 (exclude_from_file);
		_g_free0 (link_from_path);
		_g_object_unref0 (snapshot_to_link);
		_g_free0 (sys_uuid);
		_g_free0 (localhost_path);
		_g_free0 (snapshot_path);
		_g_free0 (snapshot_name);
		_g_free0 (snapshot_dir);
		_g_free0 (time_stamp);
		return result;
	}
	if (g_strcmp0 (tag, "ondemand") == 0) {
		_tmp139_ = "";
	} else {
		_tmp139_ = tag;
	}
	_tmp140_ = g_strdup (_tmp139_);
	initial_tags = _tmp140_;
	_tmp141_ = log_file;
	_tmp142_ = tee_jee_file_system_file_line_count (_tmp141_);
	_tmp143_ = _tmp142_;
	_tmp144_ = *_tmp143_;
	_g_free0 (_tmp143_);
	fcount = _tmp144_;
	_tmp145_ = snapshot_path;
	_tmp146_ = sys_uuid;
	_tmp147_ = self->current_distro;
	_tmp148_ = linux_distro_full_name (_tmp147_);
	_tmp149_ = _tmp148_;
	_tmp150_ = initial_tags;
	_tmp151_ = self->cmd_comments;
	_tmp152_ = self->repo;
	_tmp153_ = snapshot_write_control_file (_tmp145_, dt_created, _tmp146_, _tmp149_, _tmp150_, _tmp151_, fcount, FALSE, FALSE, _tmp152_, FALSE);
	_tmp154_ = _tmp153_;
	_g_free0 (_tmp149_);
	snapshot = _tmp154_;
	_tmp155_ = snapshot;
	main_set_tags (self, _tmp155_);
	_tmp156_ = snapshot_path;
	main_run_post_backup_hooks (self, _tmp156_);
	result = snapshot;
	_g_free0 (initial_tags);
	_g_free0 (log_file);
	_g_free0 (exclude_from_file);
	_g_free0 (link_from_path);
	_g_object_unref0 (snapshot_to_link);
	_g_free0 (sys_uuid);
	_g_free0 (localhost_path);
	_g_free0 (snapshot_path);
	_g_free0 (snapshot_name);
	_g_free0 (snapshot_dir);
	_g_free0 (time_stamp);
	return result;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static Snapshot*
main_create_snapshot_with_btrfs (Main* self,
                                 const gchar* tag,
                                 GDateTime* dt_created)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	SnapshotRepo* _tmp2_;
	Device* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	SnapshotRepo* _tmp13_;
	GeeHashMap* _tmp14_;
	gpointer _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gboolean _tmp21_ = FALSE;
	SnapshotRepo* _tmp22_;
	Device* _tmp23_;
	SnapshotRepo* _tmp49_;
	const gchar* _tmp50_;
	gint _tmp51_;
	gint _tmp52_;
	gchar* time_stamp = NULL;
	gchar* _tmp53_;
	gchar* snapshot_name = NULL;
	const gchar* _tmp54_;
	gchar* _tmp55_;
	const gchar* _tmp56_ = NULL;
	Device* _tmp57_;
	gchar* sys_uuid = NULL;
	gchar* _tmp60_;
	gchar* snapshot_path = NULL;
	gchar* _tmp61_;
	gchar** subvol_names = NULL;
	gchar* _tmp62_;
	gchar** _tmp63_;
	gint subvol_names_length1;
	gint _subvol_names_size_;
	gchar** _tmp67_;
	gint _tmp67__length1;
	SnapshotRepo* _tmp119_;
	GeeHashMap* _tmp120_;
	gpointer _tmp121_;
	gchar* _tmp122_;
	const gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	const gchar* _tmp127_ = NULL;
	gchar* initial_tags = NULL;
	gchar* _tmp128_;
	Snapshot* snapshot = NULL;
	const gchar* _tmp129_;
	const gchar* _tmp130_;
	LinuxDistro* _tmp131_;
	gchar* _tmp132_;
	gchar* _tmp133_;
	const gchar* _tmp134_;
	const gchar* _tmp135_;
	SnapshotRepo* _tmp136_;
	Snapshot* _tmp137_;
	Snapshot* _tmp138_;
	Snapshot* _tmp153_;
	Snapshot* _tmp154_;
	const gchar* _tmp155_;
	Snapshot* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (tag != NULL, NULL);
	g_return_val_if_fail (dt_created != NULL, NULL);
	_tmp0_ = g_strconcat (_ ("Creating new backup..."), "(BTRFS)", NULL);
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_msg (_tmp1_, FALSE);
	_g_free0 (_tmp1_);
	_tmp2_ = self->repo;
	_tmp3_ = _tmp2_->device;
	_tmp4_ = _tmp3_->device;
	_tmp5_ = g_strdup_printf (": %s", _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strconcat (_ ("Saving to device"), _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ", ", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp10_, _ ("mounted at path"), NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = self->repo;
	_tmp14_ = _tmp13_->mount_paths;
	_tmp15_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp14_, "@");
	_tmp16_ = (gchar*) _tmp15_;
	_tmp17_ = g_strdup_printf (": %s", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
	_tmp20_ = _tmp19_;
	tee_jee_logging_log_msg (_tmp20_, FALSE);
	_g_free0 (_tmp20_);
	_g_free0 (_tmp18_);
	_g_free0 (_tmp16_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_tmp22_ = self->repo;
	_tmp23_ = _tmp22_->device_home;
	if (_tmp23_ != NULL) {
		SnapshotRepo* _tmp24_;
		Device* _tmp25_;
		const gchar* _tmp26_;
		SnapshotRepo* _tmp27_;
		Device* _tmp28_;
		const gchar* _tmp29_;
		_tmp24_ = self->repo;
		_tmp25_ = _tmp24_->device_home;
		_tmp26_ = _tmp25_->uuid;
		_tmp27_ = self->repo;
		_tmp28_ = _tmp27_->device;
		_tmp29_ = _tmp28_->uuid;
		_tmp21_ = g_strcmp0 (_tmp26_, _tmp29_) != 0;
	} else {
		_tmp21_ = FALSE;
	}
	if (_tmp21_) {
		SnapshotRepo* _tmp30_;
		Device* _tmp31_;
		const gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		SnapshotRepo* _tmp41_;
		GeeHashMap* _tmp42_;
		gpointer _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* _tmp47_;
		gchar* _tmp48_;
		_tmp30_ = self->repo;
		_tmp31_ = _tmp30_->device_home;
		_tmp32_ = _tmp31_->device;
		_tmp33_ = g_strdup_printf (": %s", _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = g_strconcat (_ ("Saving to device"), _tmp34_, NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = g_strconcat (_tmp36_, ", ", NULL);
		_tmp38_ = _tmp37_;
		_tmp39_ = g_strconcat (_tmp38_, _ ("mounted at path"), NULL);
		_tmp40_ = _tmp39_;
		_tmp41_ = self->repo;
		_tmp42_ = _tmp41_->mount_paths;
		_tmp43_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp42_, "@home");
		_tmp44_ = (gchar*) _tmp43_;
		_tmp45_ = g_strdup_printf (": %s", _tmp44_);
		_tmp46_ = _tmp45_;
		_tmp47_ = g_strconcat (_tmp40_, _tmp46_, NULL);
		_tmp48_ = _tmp47_;
		tee_jee_logging_log_msg (_tmp48_, FALSE);
		_g_free0 (_tmp48_);
		_g_free0 (_tmp46_);
		_g_free0 (_tmp44_);
		_g_free0 (_tmp40_);
		_g_free0 (_tmp38_);
		_g_free0 (_tmp36_);
		_g_free0 (_tmp34_);
	}
	_tmp49_ = self->repo;
	_tmp50_ = _tmp49_->mount_path;
	_tmp51_ = strlen (_tmp50_);
	_tmp52_ = _tmp51_;
	if (_tmp52_ == 0) {
		tee_jee_logging_log_error ("Snapshot device not mounted", FALSE, FALSE);
		main_exit_app (self, 0);
	}
	_tmp53_ = g_date_time_format (dt_created, "%Y-%m-%d_%H-%M-%S");
	time_stamp = _tmp53_;
	_tmp54_ = time_stamp;
	_tmp55_ = g_strdup (_tmp54_);
	snapshot_name = _tmp55_;
	_tmp57_ = self->sys_root;
	if (_tmp57_ == NULL) {
		_tmp56_ = "";
	} else {
		Device* _tmp58_;
		const gchar* _tmp59_;
		_tmp58_ = self->sys_root;
		_tmp59_ = _tmp58_->uuid;
		_tmp56_ = _tmp59_;
	}
	_tmp60_ = g_strdup (_tmp56_);
	sys_uuid = _tmp60_;
	_tmp61_ = g_strdup ("");
	snapshot_path = _tmp61_;
	_tmp62_ = g_strdup ("@");
	_tmp63_ = g_new0 (gchar*, 1 + 1);
	_tmp63_[0] = _tmp62_;
	subvol_names = _tmp63_;
	subvol_names_length1 = 1;
	_subvol_names_size_ = subvol_names_length1;
	if (self->include_btrfs_home_for_backup) {
		gchar* _tmp64_;
		gchar* _tmp65_;
		gchar** _tmp66_;
		_tmp64_ = g_strdup ("@");
		_tmp65_ = g_strdup ("@home");
		_tmp66_ = g_new0 (gchar*, 2 + 1);
		_tmp66_[0] = _tmp64_;
		_tmp66_[1] = _tmp65_;
		subvol_names = (_vala_array_free (subvol_names, subvol_names_length1, (GDestroyNotify) g_free), NULL);
		subvol_names = _tmp66_;
		subvol_names_length1 = 2;
		_subvol_names_size_ = subvol_names_length1;
	}
	_tmp67_ = subvol_names;
	_tmp67__length1 = subvol_names_length1;
	{
		gchar** subvol_name_collection = NULL;
		gint subvol_name_collection_length1 = 0;
		gint _subvol_name_collection_size_ = 0;
		gint subvol_name_it = 0;
		subvol_name_collection = _tmp67_;
		subvol_name_collection_length1 = _tmp67__length1;
		for (subvol_name_it = 0; subvol_name_it < subvol_name_collection_length1; subvol_name_it = subvol_name_it + 1) {
			gchar* _tmp68_;
			gchar* subvol_name = NULL;
			_tmp68_ = g_strdup (subvol_name_collection[subvol_name_it]);
			subvol_name = _tmp68_;
			{
				SnapshotRepo* _tmp69_;
				GeeHashMap* _tmp70_;
				const gchar* _tmp71_;
				gpointer _tmp72_;
				gchar* _tmp73_;
				const gchar* _tmp74_;
				gchar* _tmp75_;
				gchar* _tmp76_;
				gchar* _tmp77_;
				const gchar* _tmp78_;
				gchar* src_path = NULL;
				SnapshotRepo* _tmp79_;
				GeeHashMap* _tmp80_;
				const gchar* _tmp81_;
				gpointer _tmp82_;
				gchar* _tmp83_;
				const gchar* _tmp84_;
				gchar* _tmp85_;
				gchar* _tmp86_;
				gchar* dst_path = NULL;
				const gchar* _tmp87_;
				const gchar* _tmp88_;
				gchar* _tmp89_;
				const gchar* _tmp90_;
				gchar* cmd = NULL;
				const gchar* _tmp96_;
				const gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* std_out = NULL;
				gchar* std_err = NULL;
				gint ret_val = 0;
				const gchar* _tmp100_;
				gchar* _tmp101_ = NULL;
				gchar* _tmp102_ = NULL;
				gint _tmp103_;
				_tmp69_ = self->repo;
				_tmp70_ = _tmp69_->mount_paths;
				_tmp71_ = subvol_name;
				_tmp72_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp70_, _tmp71_);
				_tmp73_ = (gchar*) _tmp72_;
				_tmp74_ = snapshot_name;
				_tmp75_ = g_strdup_printf ("timeshift-btrfs/snapshots/%s", _tmp74_);
				_tmp76_ = _tmp75_;
				_tmp77_ = tee_jee_file_system_path_combine (_tmp73_, _tmp76_);
				_g_free0 (snapshot_path);
				snapshot_path = _tmp77_;
				_g_free0 (_tmp76_);
				_g_free0 (_tmp73_);
				_tmp78_ = snapshot_path;
				tee_jee_file_system_dir_create (_tmp78_, TRUE);
				_tmp79_ = self->repo;
				_tmp80_ = _tmp79_->mount_paths;
				_tmp81_ = subvol_name;
				_tmp82_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp80_, _tmp81_);
				_tmp83_ = (gchar*) _tmp82_;
				_tmp84_ = subvol_name;
				_tmp85_ = tee_jee_file_system_path_combine (_tmp83_, _tmp84_);
				_tmp86_ = _tmp85_;
				_g_free0 (_tmp83_);
				src_path = _tmp86_;
				_tmp87_ = snapshot_path;
				_tmp88_ = subvol_name;
				_tmp89_ = tee_jee_file_system_path_combine (_tmp87_, _tmp88_);
				dst_path = _tmp89_;
				_tmp90_ = dst_path;
				if (g_str_has_suffix (_tmp90_, "/@/@")) {
					const gchar* _tmp91_;
					gchar* _tmp92_;
					_tmp91_ = dst_path;
					_tmp92_ = string_replace (_tmp91_, "/@/@", "/@");
					_g_free0 (dst_path);
					dst_path = _tmp92_;
				} else {
					const gchar* _tmp93_;
					_tmp93_ = dst_path;
					if (g_str_has_suffix (_tmp93_, "/@home/@home")) {
						const gchar* _tmp94_;
						gchar* _tmp95_;
						_tmp94_ = dst_path;
						_tmp95_ = string_replace (_tmp94_, "/@home/@home", "/@home");
						_g_free0 (dst_path);
						dst_path = _tmp95_;
					}
				}
				_tmp96_ = src_path;
				_tmp97_ = dst_path;
				_tmp98_ = g_strdup_printf ("btrfs subvolume snapshot '%s' '%s' \n", _tmp96_, _tmp97_);
				cmd = _tmp98_;
				if (tee_jee_logging_LOG_COMMANDS) {
					const gchar* _tmp99_;
					_tmp99_ = cmd;
					tee_jee_logging_log_debug (_tmp99_);
				}
				_tmp100_ = cmd;
				_tmp103_ = tee_jee_process_helper_exec_sync (_tmp100_, &_tmp101_, &_tmp102_);
				_g_free0 (std_out);
				std_out = _tmp101_;
				_g_free0 (std_err);
				std_err = _tmp102_;
				ret_val = _tmp103_;
				if (ret_val != 0) {
					const gchar* _tmp104_;
					gchar* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					gchar* _tmp108_;
					const gchar* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					gchar* _tmp112_;
					gchar* _tmp113_;
					_tmp104_ = std_err;
					tee_jee_logging_log_error (_tmp104_, FALSE, FALSE);
					_tmp105_ = g_strdup_printf (": %d", ret_val);
					_tmp106_ = _tmp105_;
					_tmp107_ = g_strconcat (_ ("btrfs returned an error"), _tmp106_, NULL);
					_tmp108_ = _tmp107_;
					tee_jee_logging_log_error (_tmp108_, FALSE, FALSE);
					_g_free0 (_tmp108_);
					_g_free0 (_tmp106_);
					_tmp109_ = subvol_name;
					_tmp110_ = g_strdup_printf (": %s", _tmp109_);
					_tmp111_ = _tmp110_;
					_tmp112_ = g_strconcat (_ ("Failed to create subvolume snapshot"), _tmp111_, NULL);
					_tmp113_ = _tmp112_;
					tee_jee_logging_log_error (_tmp113_, FALSE, FALSE);
					_g_free0 (_tmp113_);
					_g_free0 (_tmp111_);
					result = NULL;
					_g_free0 (std_err);
					_g_free0 (std_out);
					_g_free0 (cmd);
					_g_free0 (dst_path);
					_g_free0 (src_path);
					_g_free0 (subvol_name);
					subvol_names = (_vala_array_free (subvol_names, subvol_names_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (snapshot_path);
					_g_free0 (sys_uuid);
					_g_free0 (snapshot_name);
					_g_free0 (time_stamp);
					return result;
				} else {
					const gchar* _tmp114_;
					gchar* _tmp115_;
					gchar* _tmp116_;
					gchar* _tmp117_;
					gchar* _tmp118_;
					_tmp114_ = dst_path;
					_tmp115_ = g_strdup_printf (": %s", _tmp114_);
					_tmp116_ = _tmp115_;
					_tmp117_ = g_strconcat (_ ("Created subvolume snapshot"), _tmp116_, NULL);
					_tmp118_ = _tmp117_;
					tee_jee_logging_log_msg (_tmp118_, FALSE);
					_g_free0 (_tmp118_);
					_g_free0 (_tmp116_);
				}
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_free0 (cmd);
				_g_free0 (dst_path);
				_g_free0 (src_path);
				_g_free0 (subvol_name);
			}
		}
	}
	_tmp119_ = self->repo;
	_tmp120_ = _tmp119_->mount_paths;
	_tmp121_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp120_, "@");
	_tmp122_ = (gchar*) _tmp121_;
	_tmp123_ = snapshot_name;
	_tmp124_ = g_strdup_printf ("timeshift-btrfs/snapshots/%s", _tmp123_);
	_tmp125_ = _tmp124_;
	_tmp126_ = tee_jee_file_system_path_combine (_tmp122_, _tmp125_);
	_g_free0 (snapshot_path);
	snapshot_path = _tmp126_;
	_g_free0 (_tmp125_);
	_g_free0 (_tmp122_);
	if (g_strcmp0 (tag, "ondemand") == 0) {
		_tmp127_ = "";
	} else {
		_tmp127_ = tag;
	}
	_tmp128_ = g_strdup (_tmp127_);
	initial_tags = _tmp128_;
	_tmp129_ = snapshot_path;
	_tmp130_ = sys_uuid;
	_tmp131_ = self->current_distro;
	_tmp132_ = linux_distro_full_name (_tmp131_);
	_tmp133_ = _tmp132_;
	_tmp134_ = initial_tags;
	_tmp135_ = self->cmd_comments;
	_tmp136_ = self->repo;
	_tmp137_ = snapshot_write_control_file (_tmp129_, dt_created, _tmp130_, _tmp133_, _tmp134_, _tmp135_, (gint64) 0, TRUE, FALSE, _tmp136_, FALSE);
	_tmp138_ = _tmp137_;
	_g_free0 (_tmp133_);
	snapshot = _tmp138_;
	{
		GeeIterator* _subvol_it = NULL;
		GeeHashMap* _tmp139_;
		GeeCollection* _tmp140_;
		GeeCollection* _tmp141_;
		GeeCollection* _tmp142_;
		GeeIterator* _tmp143_;
		GeeIterator* _tmp144_;
		_tmp139_ = self->sys_subvolumes;
		_tmp140_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp139_);
		_tmp141_ = _tmp140_;
		_tmp142_ = _tmp141_;
		_tmp143_ = gee_iterable_iterator ((GeeIterable*) _tmp142_);
		_tmp144_ = _tmp143_;
		_g_object_unref0 (_tmp142_);
		_subvol_it = _tmp144_;
		while (TRUE) {
			GeeIterator* _tmp145_;
			Subvolume* subvol = NULL;
			GeeIterator* _tmp146_;
			gpointer _tmp147_;
			Snapshot* _tmp148_;
			GeeHashMap* _tmp149_;
			Subvolume* _tmp150_;
			const gchar* _tmp151_;
			Subvolume* _tmp152_;
			_tmp145_ = _subvol_it;
			if (!gee_iterator_next (_tmp145_)) {
				break;
			}
			_tmp146_ = _subvol_it;
			_tmp147_ = gee_iterator_get (_tmp146_);
			subvol = (Subvolume*) _tmp147_;
			_tmp148_ = snapshot;
			_tmp149_ = _tmp148_->subvolumes;
			_tmp150_ = subvol;
			_tmp151_ = _tmp150_->name;
			_tmp152_ = subvol;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp149_, _tmp151_, _tmp152_);
			_g_object_unref0 (subvol);
		}
		_g_object_unref0 (_subvol_it);
	}
	_tmp153_ = snapshot;
	snapshot_update_control_file (_tmp153_);
	_tmp154_ = snapshot;
	main_set_tags (self, _tmp154_);
	_tmp155_ = snapshot_path;
	main_run_post_backup_hooks (self, _tmp155_);
	result = snapshot;
	_g_free0 (initial_tags);
	subvol_names = (_vala_array_free (subvol_names, subvol_names_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (snapshot_path);
	_g_free0 (sys_uuid);
	_g_free0 (snapshot_name);
	_g_free0 (time_stamp);
	return result;
}

static void
main_run_post_backup_hooks (Main* self,
                            const gchar* snapshot_path)
{
	static const char backuphooksdir[] = "/etc/timeshift/backup-hooks.d";
	GFileType fileType = 0;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFileType _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot_path != NULL);
	_tmp0_ = g_file_new_for_path (backuphooksdir);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_query_file_type (_tmp1_, G_FILE_QUERY_INFO_NONE, NULL);
	_g_object_unref0 (_tmp1_);
	fileType = _tmp2_;
	if (fileType == G_FILE_TYPE_DIRECTORY) {
		gchar* sh = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		tee_jee_logging_log_debug ("Running post-backup tasks...");
		_tmp3_ = g_strconcat ("export TS_SNAPSHOT_PATH=\"", snapshot_path, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_strconcat (_tmp4_, "\" &&", NULL);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup_printf (" run-parts --verbose \"%s\"", backuphooksdir);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp6_, _tmp8_, NULL);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		_g_free0 (_tmp4_);
		sh = _tmp10_;
		_tmp11_ = sh;
		tee_jee_process_helper_exec_script_sync (_tmp11_, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
		tee_jee_logging_log_debug ("Finished running post-backup tasks...");
		_g_free0 (sh);
	} else {
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = g_strdup_printf ("Backup hooks skipped, because %s does not exist", backuphooksdir);
		_tmp13_ = _tmp12_;
		tee_jee_logging_log_debug (_tmp13_);
		_g_free0 (_tmp13_);
	}
}

static void
main_set_tags (Main* self,
               Snapshot* snapshot)
{
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	GeeArrayList* _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->cmd_tags;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
		tag_collection = _tmp2_;
		tag_collection_length1 = _vala_array_length (_tmp1_);
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
			gchar* _tmp3_;
			gchar* tag = NULL;
			_tmp3_ = g_strdup (tag_collection[tag_it]);
			tag = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				static GQuark _tmp10_label2 = 0;
				static GQuark _tmp10_label3 = 0;
				static GQuark _tmp10_label4 = 0;
				static GQuark _tmp10_label5 = 0;
				_tmp4_ = tag;
				_tmp5_ = string_strip (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				g_free (_tmp9_);
				if (_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("O")))) {
					switch (0) {
						default:
						{
							snapshot_add_tag (snapshot, "ondemand");
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("B")))) {
					switch (0) {
						default:
						{
							snapshot_add_tag (snapshot, "boot");
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("H")))) {
					switch (0) {
						default:
						{
							snapshot_add_tag (snapshot, "hourly");
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("D")))) {
					switch (0) {
						default:
						{
							snapshot_add_tag (snapshot, "daily");
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("W")))) {
					switch (0) {
						default:
						{
							snapshot_add_tag (snapshot, "weekly");
							break;
						}
					}
				} else if (_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("M")))) {
					switch (0) {
						default:
						{
							snapshot_add_tag (snapshot, "monthly");
							break;
						}
					}
				}
				_g_free0 (tag);
			}
		}
		tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp12_ = snapshot->tags;
	_tmp13_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp12_);
	_tmp14_ = _tmp13_;
	if (_tmp14_ == 0) {
		snapshot_add_tag (snapshot, "ondemand");
	}
}

void
main_validate_cmd_tags (Main* self)
{
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->cmd_tags;
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, ",", 0);
	{
		gchar** tag_collection = NULL;
		gint tag_collection_length1 = 0;
		gint _tag_collection_size_ = 0;
		gint tag_it = 0;
		tag_collection = _tmp2_;
		tag_collection_length1 = _vala_array_length (_tmp1_);
		for (tag_it = 0; tag_it < tag_collection_length1; tag_it = tag_it + 1) {
			gchar* _tmp3_;
			gchar* tag = NULL;
			_tmp3_ = g_strdup (tag_collection[tag_it]);
			tag = _tmp3_;
			{
				const gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				GQuark _tmp11_ = 0U;
				static GQuark _tmp10_label0 = 0;
				static GQuark _tmp10_label1 = 0;
				static GQuark _tmp10_label2 = 0;
				static GQuark _tmp10_label3 = 0;
				static GQuark _tmp10_label4 = 0;
				static GQuark _tmp10_label5 = 0;
				_tmp4_ = tag;
				_tmp5_ = string_strip (_tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_utf8_strup (_tmp6_, (gssize) -1);
				_tmp8_ = _tmp7_;
				_g_free0 (_tmp6_);
				_tmp9_ = _tmp8_;
				_tmp11_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
				g_free (_tmp9_);
				if ((((((_tmp11_ == ((0 != _tmp10_label0) ? _tmp10_label0 : (_tmp10_label0 = g_quark_from_static_string ("O")))) || (_tmp11_ == ((0 != _tmp10_label1) ? _tmp10_label1 : (_tmp10_label1 = g_quark_from_static_string ("B"))))) || (_tmp11_ == ((0 != _tmp10_label2) ? _tmp10_label2 : (_tmp10_label2 = g_quark_from_static_string ("H"))))) || (_tmp11_ == ((0 != _tmp10_label3) ? _tmp10_label3 : (_tmp10_label3 = g_quark_from_static_string ("D"))))) || (_tmp11_ == ((0 != _tmp10_label4) ? _tmp10_label4 : (_tmp10_label4 = g_quark_from_static_string ("W"))))) || (_tmp11_ == ((0 != _tmp10_label5) ? _tmp10_label5 : (_tmp10_label5 = g_quark_from_static_string ("M"))))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							const gchar* _tmp12_;
							gchar* _tmp13_;
							gchar* _tmp14_;
							gchar* _tmp15_;
							gchar* _tmp16_;
							_tmp12_ = tag;
							_tmp13_ = g_strdup_printf (" (%s).", _tmp12_);
							_tmp14_ = _tmp13_;
							_tmp15_ = g_strconcat (_ ("Unknown value specified for option --tags"), _tmp14_, NULL);
							_tmp16_ = _tmp15_;
							tee_jee_logging_log_error (_tmp16_, FALSE, FALSE);
							_g_free0 (_tmp16_);
							_g_free0 (_tmp14_);
							tee_jee_logging_log_error (_ ("Expected values: O, B, H, D, W, M"), FALSE, FALSE);
							main_exit_app (self, 1);
							break;
						}
					}
				}
				_g_free0 (tag);
			}
		}
		tag_collection = (_vala_array_free (tag_collection, tag_collection_length1, (GDestroyNotify) g_free), NULL);
	}
}

static void
___lambda18_ (Main* self)
{
	main_delete_thread (self);
}

static gpointer
____lambda18__gthread_func (gpointer self)
{
	gpointer result;
	___lambda18_ ((Main*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

void
main_delete_begin (Main* self)
{
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: delete_begin()");
	_tmp0_ = g_strdup (_ ("Preparing..."));
	_g_free0 (self->progress_text);
	self->progress_text = _tmp0_;
	{
		GThread* _tmp1_;
		GThread* _tmp2_;
		self->thread_delete_running = TRUE;
		self->thread_delete_success = FALSE;
		_tmp1_ = g_thread_try_new ("delete", ____lambda18__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp2_ = _tmp1_;
		_g_thread_unref0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		tee_jee_logging_log_debug ("delete_begin(): thread created");
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->thread_delete_running = FALSE;
		self->thread_delete_success = FALSE;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		tee_jee_logging_log_error (_tmp4_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	tee_jee_logging_log_debug ("Main: delete_begin(): exit");
}

void
main_delete_thread (Main* self)
{
	gboolean status = FALSE;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("delete_thread()");
	status = TRUE;
	{
		GeeArrayList* _bak_list = NULL;
		GeeArrayList* _tmp0_;
		gint _bak_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _bak_index = 0;
		_tmp0_ = self->delete_list;
		_bak_list = _tmp0_;
		_tmp1_ = _bak_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_bak_size = _tmp3_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			Snapshot* _tmp8_;
			_bak_index = _bak_index + 1;
			_tmp4_ = _bak_index;
			_tmp5_ = _bak_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _bak_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _bak_index);
			bak = (Snapshot*) _tmp7_;
			_tmp8_ = bak;
			snapshot_mark_for_deletion (_tmp8_);
			_g_object_unref0 (bak);
		}
	}
	while (TRUE) {
		GeeArrayList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		Snapshot* bak = NULL;
		GeeArrayList* _tmp12_;
		gpointer _tmp13_;
		Snapshot* _tmp14_;
		GeeArrayList* _tmp35_;
		Snapshot* _tmp36_;
		_tmp9_ = self->delete_list;
		_tmp10_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		if (!(_tmp11_ > 0)) {
			break;
		}
		_tmp12_ = self->delete_list;
		_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, 0);
		bak = (Snapshot*) _tmp13_;
		_tmp14_ = bak;
		snapshot_mark_for_deletion (_tmp14_);
		if (self->btrfs_mode) {
			Snapshot* _tmp15_;
			gchar* message = NULL;
			Snapshot* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp15_ = bak;
			status = snapshot_remove (_tmp15_, TRUE);
			_tmp16_ = bak;
			_tmp17_ = _tmp16_->name;
			_tmp18_ = g_strdup_printf ("%s '%s'", _ ("Removed"), _tmp17_);
			message = _tmp18_;
			_tmp19_ = message;
			osd_notify_notify_send ("TimeShift", _tmp19_, 10000, "low", "info");
			_g_free0 (message);
		} else {
			Snapshot* _tmp20_;
			DeleteFileTask* _tmp21_;
			DeleteFileTask* _tmp22_;
			DeleteFileTask* _tmp23_;
			Snapshot* _tmp24_;
			DeleteFileTask* _tmp25_;
			_tmp20_ = bak;
			_tmp21_ = _tmp20_->delete_file_task;
			_tmp22_ = _g_object_ref0 (_tmp21_);
			_g_object_unref0 (self->delete_file_task);
			self->delete_file_task = _tmp22_;
			_tmp23_ = self->delete_file_task;
			((AsyncTask*) _tmp23_)->prg_count_total = (gint64) main_first_snapshot_count;
			_tmp24_ = bak;
			status = snapshot_remove (_tmp24_, TRUE);
			_tmp25_ = self->delete_file_task;
			if (((AsyncTask*) _tmp25_)->status != APP_STATUS_CANCELLED) {
				gchar* message = NULL;
				Snapshot* _tmp26_;
				const gchar* _tmp27_;
				DeleteFileTask* _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				const gchar* _tmp34_;
				_tmp26_ = bak;
				_tmp27_ = _tmp26_->name;
				_tmp28_ = self->delete_file_task;
				_tmp29_ = async_task_get_stat_time_elapsed ((AsyncTask*) _tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strdup_printf ("%s '%s' (%s)", _ ("Removed"), _tmp27_, _tmp31_);
				_tmp33_ = _tmp32_;
				_g_free0 (_tmp31_);
				message = _tmp33_;
				_tmp34_ = message;
				osd_notify_notify_send ("TimeShift", _tmp34_, 10000, "low", "info");
				_g_free0 (message);
			}
		}
		_tmp35_ = self->delete_list;
		_tmp36_ = bak;
		gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp35_, _tmp36_);
		_g_object_unref0 (bak);
	}
	self->thread_delete_running = FALSE;
	self->thread_delete_success = status;
}

static gint
__lambda19_ (Main* self,
             MountEntry* a,
             MountEntry* b)
{
	GCompareFunc _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	_tmp1_ = a->mount_point;
	_tmp2_ = b->mount_point;
	result = _tmp0_ (_tmp1_, _tmp2_);
	return result;
}

static gint
___lambda19__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda19_ ((Main*) self, (MountEntry*) a, (MountEntry*) b);
	return result;
}

void
main_init_mount_list (Main* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* fstab_list = NULL;
	GeeArrayList* crypttab_list = NULL;
	gboolean root_found = FALSE;
	gboolean boot_found = FALSE;
	gboolean home_found = FALSE;
	GeeArrayList* _tmp186_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: init_mount_list()");
	_tmp0_ = self->mount_list;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	fstab_list = NULL;
	crypttab_list = NULL;
	if (self->mirror_system) {
		gchar* fstab_path = NULL;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		GeeArrayList* _tmp3_;
		gchar* cryttab_path = NULL;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		GeeArrayList* _tmp6_;
		_tmp1_ = g_strdup ("/etc/fstab");
		fstab_path = _tmp1_;
		_tmp2_ = fstab_path;
		_tmp3_ = fs_tab_entry_read_file (_tmp2_);
		_g_object_unref0 (fstab_list);
		fstab_list = _tmp3_;
		_tmp4_ = g_strdup ("/etc/crypttab");
		cryttab_path = _tmp4_;
		_tmp5_ = cryttab_path;
		_tmp6_ = crypt_tab_entry_read_file (_tmp5_);
		_g_object_unref0 (crypttab_list);
		crypttab_list = _tmp6_;
		_g_free0 (cryttab_path);
		_g_free0 (fstab_path);
	} else {
		Snapshot* _tmp7_;
		GeeArrayList* _tmp8_;
		GeeArrayList* _tmp9_;
		Snapshot* _tmp10_;
		GeeArrayList* _tmp11_;
		GeeArrayList* _tmp12_;
		_tmp7_ = self->snapshot_to_restore;
		_tmp8_ = _tmp7_->fstab_list;
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (fstab_list);
		fstab_list = _tmp9_;
		_tmp10_ = self->snapshot_to_restore;
		_tmp11_ = _tmp10_->cryttab_list;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (crypttab_list);
		crypttab_list = _tmp12_;
	}
	root_found = FALSE;
	boot_found = FALSE;
	home_found = FALSE;
	main_set_dst_root (self, NULL);
	{
		GeeArrayList* _fs_entry_list = NULL;
		GeeArrayList* _tmp13_;
		gint _fs_entry_size = 0;
		GeeArrayList* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		gint _fs_entry_index = 0;
		_tmp13_ = fstab_list;
		_fs_entry_list = _tmp13_;
		_tmp14_ = _fs_entry_list;
		_tmp15_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp14_);
		_tmp16_ = _tmp15_;
		_fs_entry_size = _tmp16_;
		_fs_entry_index = -1;
		while (TRUE) {
			gint _tmp17_;
			gint _tmp18_;
			FsTabEntry* fs_entry = NULL;
			GeeArrayList* _tmp19_;
			gpointer _tmp20_;
			FsTabEntry* _tmp21_;
			gchar* p1 = NULL;
			FsTabEntry* _tmp22_;
			const gchar* _tmp23_;
			gchar* _tmp24_;
			gchar* p2 = NULL;
			FsTabEntry* _tmp25_;
			const gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* p3 = NULL;
			FsTabEntry* _tmp28_;
			const gchar* _tmp29_;
			gchar* _tmp30_;
			gboolean _tmp31_ = FALSE;
			GeeArrayList* _tmp32_;
			const gchar* _tmp33_;
			Device* dev_fstab = NULL;
			FsTabEntry* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gint _tmp50_;
			gint _tmp51_;
			gboolean _tmp52_;
			Device* _tmp61_;
			Device* _tmp106_;
			FsTabEntry* _tmp141_;
			const gchar* _tmp142_;
			FsTabEntry* _tmp143_;
			const gchar* _tmp144_;
			FsTabEntry* _tmp145_;
			const gchar* _tmp146_;
			_fs_entry_index = _fs_entry_index + 1;
			_tmp17_ = _fs_entry_index;
			_tmp18_ = _fs_entry_size;
			if (!(_tmp17_ < _tmp18_)) {
				break;
			}
			_tmp19_ = _fs_entry_list;
			_tmp20_ = gee_abstract_list_get ((GeeAbstractList*) _tmp19_, _fs_entry_index);
			fs_entry = (FsTabEntry*) _tmp20_;
			_tmp21_ = fs_entry;
			if (!fs_tab_entry_is_for_system_directory (_tmp21_)) {
				_g_object_unref0 (fs_entry);
				continue;
			}
			_tmp22_ = fs_entry;
			_tmp23_ = _tmp22_->mount_point;
			_tmp24_ = g_strdup_printf ("%s/*", _tmp23_);
			p1 = _tmp24_;
			_tmp25_ = fs_entry;
			_tmp26_ = _tmp25_->mount_point;
			_tmp27_ = g_strdup_printf ("%s/**", _tmp26_);
			p2 = _tmp27_;
			_tmp28_ = fs_entry;
			_tmp29_ = _tmp28_->mount_point;
			_tmp30_ = g_strdup_printf ("%s/***", _tmp29_);
			p3 = _tmp30_;
			_tmp32_ = self->exclude_list_default;
			_tmp33_ = p1;
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp32_, _tmp33_)) {
				_tmp31_ = TRUE;
			} else {
				GeeArrayList* _tmp34_;
				const gchar* _tmp35_;
				_tmp34_ = self->exclude_list_user;
				_tmp35_ = p1;
				_tmp31_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp34_, _tmp35_);
			}
			if (_tmp31_) {
				_g_free0 (p3);
				_g_free0 (p2);
				_g_free0 (p1);
				_g_object_unref0 (fs_entry);
				continue;
			} else {
				gboolean _tmp36_ = FALSE;
				GeeArrayList* _tmp37_;
				const gchar* _tmp38_;
				_tmp37_ = self->exclude_list_default;
				_tmp38_ = p2;
				if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp37_, _tmp38_)) {
					_tmp36_ = TRUE;
				} else {
					GeeArrayList* _tmp39_;
					const gchar* _tmp40_;
					_tmp39_ = self->exclude_list_user;
					_tmp40_ = p2;
					_tmp36_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp39_, _tmp40_);
				}
				if (_tmp36_) {
					_g_free0 (p3);
					_g_free0 (p2);
					_g_free0 (p1);
					_g_object_unref0 (fs_entry);
					continue;
				} else {
					gboolean _tmp41_ = FALSE;
					GeeArrayList* _tmp42_;
					const gchar* _tmp43_;
					_tmp42_ = self->exclude_list_default;
					_tmp43_ = p3;
					if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp42_, _tmp43_)) {
						_tmp41_ = TRUE;
					} else {
						GeeArrayList* _tmp44_;
						const gchar* _tmp45_;
						_tmp44_ = self->exclude_list_user;
						_tmp45_ = p3;
						_tmp41_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp44_, _tmp45_);
					}
					if (_tmp41_) {
						_g_free0 (p3);
						_g_free0 (p2);
						_g_free0 (p1);
						_g_object_unref0 (fs_entry);
						continue;
					}
				}
			}
			dev_fstab = NULL;
			_tmp46_ = fs_entry;
			_tmp47_ = fs_tab_entry_get_device_uuid (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _tmp48_;
			_tmp50_ = strlen (_tmp49_);
			_tmp51_ = _tmp50_;
			_tmp52_ = _tmp51_ > 0;
			_g_free0 (_tmp49_);
			if (_tmp52_) {
				FsTabEntry* _tmp53_;
				gchar* _tmp54_;
				gchar* _tmp55_;
				gchar* _tmp56_;
				Device* _tmp57_;
				_tmp53_ = fs_entry;
				_tmp54_ = fs_tab_entry_get_device_uuid (_tmp53_);
				_tmp55_ = _tmp54_;
				_tmp56_ = _tmp55_;
				_tmp57_ = device_get_device_by_uuid (_tmp56_);
				_g_object_unref0 (dev_fstab);
				dev_fstab = _tmp57_;
				_g_free0 (_tmp56_);
			} else {
				FsTabEntry* _tmp58_;
				const gchar* _tmp59_;
				Device* _tmp60_;
				_tmp58_ = fs_entry;
				_tmp59_ = _tmp58_->device_string;
				_tmp60_ = device_get_device_by_name (_tmp59_);
				_g_object_unref0 (dev_fstab);
				dev_fstab = _tmp60_;
			}
			_tmp61_ = dev_fstab;
			if (_tmp61_ == NULL) {
				FsTabEntry* _tmp62_;
				const gchar* _tmp63_;
				_tmp62_ = fs_entry;
				_tmp63_ = _tmp62_->device_string;
				if (g_str_has_prefix (_tmp63_, "/dev/mapper/")) {
					gchar* mapped_name = NULL;
					FsTabEntry* _tmp64_;
					const gchar* _tmp65_;
					gchar* _tmp66_;
					_tmp64_ = fs_entry;
					_tmp65_ = _tmp64_->device_string;
					_tmp66_ = string_replace (_tmp65_, "/dev/mapper/", "");
					mapped_name = _tmp66_;
					{
						GeeArrayList* _crypt_entry_list = NULL;
						GeeArrayList* _tmp67_;
						gint _crypt_entry_size = 0;
						GeeArrayList* _tmp68_;
						gint _tmp69_;
						gint _tmp70_;
						gint _crypt_entry_index = 0;
						_tmp67_ = crypttab_list;
						_crypt_entry_list = _tmp67_;
						_tmp68_ = _crypt_entry_list;
						_tmp69_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp68_);
						_tmp70_ = _tmp69_;
						_crypt_entry_size = _tmp70_;
						_crypt_entry_index = -1;
						while (TRUE) {
							gint _tmp71_;
							gint _tmp72_;
							CryptTabEntry* crypt_entry = NULL;
							GeeArrayList* _tmp73_;
							gpointer _tmp74_;
							CryptTabEntry* _tmp75_;
							const gchar* _tmp76_;
							const gchar* _tmp77_;
							_crypt_entry_index = _crypt_entry_index + 1;
							_tmp71_ = _crypt_entry_index;
							_tmp72_ = _crypt_entry_size;
							if (!(_tmp71_ < _tmp72_)) {
								break;
							}
							_tmp73_ = _crypt_entry_list;
							_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp73_, _crypt_entry_index);
							crypt_entry = (CryptTabEntry*) _tmp74_;
							_tmp75_ = crypt_entry;
							_tmp76_ = _tmp75_->mapped_name;
							_tmp77_ = mapped_name;
							if (g_strcmp0 (_tmp76_, _tmp77_) == 0) {
								FsTabEntry* _tmp78_;
								CryptTabEntry* _tmp79_;
								const gchar* _tmp80_;
								gchar* _tmp81_;
								FsTabEntry* _tmp82_;
								gchar* _tmp83_;
								gchar* _tmp84_;
								gchar* _tmp85_;
								gint _tmp86_;
								gint _tmp87_;
								gboolean _tmp88_;
								_tmp78_ = fs_entry;
								_tmp79_ = crypt_entry;
								_tmp80_ = _tmp79_->device_string;
								_tmp81_ = g_strdup (_tmp80_);
								_g_free0 (_tmp78_->device_string);
								_tmp78_->device_string = _tmp81_;
								_tmp82_ = fs_entry;
								_tmp83_ = fs_tab_entry_get_device_uuid (_tmp82_);
								_tmp84_ = _tmp83_;
								_tmp85_ = _tmp84_;
								_tmp86_ = strlen (_tmp85_);
								_tmp87_ = _tmp86_;
								_tmp88_ = _tmp87_ > 0;
								_g_free0 (_tmp85_);
								if (_tmp88_) {
									Device* dev_luks = NULL;
									FsTabEntry* _tmp89_;
									gchar* _tmp90_;
									gchar* _tmp91_;
									gchar* _tmp92_;
									Device* _tmp93_;
									Device* _tmp94_;
									Device* _tmp95_;
									_tmp89_ = fs_entry;
									_tmp90_ = fs_tab_entry_get_device_uuid (_tmp89_);
									_tmp91_ = _tmp90_;
									_tmp92_ = _tmp91_;
									_tmp93_ = device_get_device_by_uuid (_tmp92_);
									_tmp94_ = _tmp93_;
									_g_free0 (_tmp92_);
									dev_luks = _tmp94_;
									_tmp95_ = dev_luks;
									if (_tmp95_ != NULL) {
										gchar* msg_out = NULL;
										gchar* msg_err = NULL;
										Device* dev_unlocked = NULL;
										Device* _tmp96_;
										GtkWindow* _tmp97_;
										gchar* _tmp98_ = NULL;
										gchar* _tmp99_ = NULL;
										Device* _tmp100_;
										Device* _tmp101_;
										_tmp96_ = dev_luks;
										_tmp97_ = self->parent_window;
										_tmp100_ = device_luks_unlock (_tmp96_, "", "", _tmp97_, &_tmp98_, &_tmp99_);
										_g_free0 (msg_out);
										msg_out = _tmp98_;
										_g_free0 (msg_err);
										msg_err = _tmp99_;
										dev_unlocked = _tmp100_;
										_tmp101_ = dev_unlocked;
										if (_tmp101_ != NULL) {
											Device* _tmp102_;
											Device* _tmp103_;
											_tmp102_ = dev_unlocked;
											_tmp103_ = _g_object_ref0 (_tmp102_);
											_g_object_unref0 (dev_fstab);
											dev_fstab = _tmp103_;
											main_update_partitions (self);
										} else {
											Device* _tmp104_;
											Device* _tmp105_;
											_tmp104_ = dev_luks;
											_tmp105_ = _g_object_ref0 (_tmp104_);
											_g_object_unref0 (dev_fstab);
											dev_fstab = _tmp105_;
										}
										_g_object_unref0 (dev_unlocked);
										_g_free0 (msg_err);
										_g_free0 (msg_out);
									}
									_g_object_unref0 (dev_luks);
								} else {
								}
								_g_object_unref0 (crypt_entry);
								break;
							}
							_g_object_unref0 (crypt_entry);
						}
					}
					_g_free0 (mapped_name);
				}
			}
			_tmp106_ = dev_fstab;
			if (_tmp106_ != NULL) {
				Device* _tmp107_;
				const gchar* _tmp108_;
				FsTabEntry* _tmp109_;
				const gchar* _tmp110_;
				FsTabEntry* _tmp111_;
				const gchar* _tmp112_;
				gchar* _tmp113_;
				gchar* _tmp114_;
				GeeArrayList* _tmp115_;
				Device* _tmp116_;
				FsTabEntry* _tmp117_;
				const gchar* _tmp118_;
				FsTabEntry* _tmp119_;
				const gchar* _tmp120_;
				MountEntry* _tmp121_;
				MountEntry* _tmp122_;
				FsTabEntry* _tmp123_;
				const gchar* _tmp124_;
				_tmp107_ = dev_fstab;
				_tmp108_ = _tmp107_->device;
				_tmp109_ = fs_entry;
				_tmp110_ = _tmp109_->mount_point;
				_tmp111_ = fs_entry;
				_tmp112_ = _tmp111_->options;
				_tmp113_ = g_strdup_printf ("added: dev: %s, path: %s, options: %s", _tmp108_, _tmp110_, _tmp112_);
				_tmp114_ = _tmp113_;
				tee_jee_logging_log_debug (_tmp114_);
				_g_free0 (_tmp114_);
				_tmp115_ = self->mount_list;
				_tmp116_ = dev_fstab;
				_tmp117_ = fs_entry;
				_tmp118_ = _tmp117_->mount_point;
				_tmp119_ = fs_entry;
				_tmp120_ = _tmp119_->options;
				_tmp121_ = mount_entry_new (_tmp116_, _tmp118_, _tmp120_);
				_tmp122_ = _tmp121_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, _tmp122_);
				_g_object_unref0 (_tmp122_);
				_tmp123_ = fs_entry;
				_tmp124_ = _tmp123_->mount_point;
				if (g_strcmp0 (_tmp124_, "/") == 0) {
					Device* _tmp125_;
					_tmp125_ = dev_fstab;
					main_set_dst_root (self, _tmp125_);
				}
			} else {
				FsTabEntry* _tmp126_;
				const gchar* _tmp127_;
				FsTabEntry* _tmp128_;
				const gchar* _tmp129_;
				FsTabEntry* _tmp130_;
				const gchar* _tmp131_;
				gchar* _tmp132_;
				gchar* _tmp133_;
				GeeArrayList* _tmp134_;
				FsTabEntry* _tmp135_;
				const gchar* _tmp136_;
				FsTabEntry* _tmp137_;
				const gchar* _tmp138_;
				MountEntry* _tmp139_;
				MountEntry* _tmp140_;
				_tmp126_ = fs_entry;
				_tmp127_ = _tmp126_->device_string;
				_tmp128_ = fs_entry;
				_tmp129_ = _tmp128_->mount_point;
				_tmp130_ = fs_entry;
				_tmp131_ = _tmp130_->options;
				_tmp132_ = g_strdup_printf ("missing: dev: %s, path: %s, options: %s", _tmp127_, _tmp129_, _tmp131_);
				_tmp133_ = _tmp132_;
				tee_jee_logging_log_debug (_tmp133_);
				_g_free0 (_tmp133_);
				_tmp134_ = self->mount_list;
				_tmp135_ = fs_entry;
				_tmp136_ = _tmp135_->mount_point;
				_tmp137_ = fs_entry;
				_tmp138_ = _tmp137_->options;
				_tmp139_ = mount_entry_new (NULL, _tmp136_, _tmp138_);
				_tmp140_ = _tmp139_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp134_, _tmp140_);
				_g_object_unref0 (_tmp140_);
			}
			_tmp141_ = fs_entry;
			_tmp142_ = _tmp141_->mount_point;
			if (g_strcmp0 (_tmp142_, "/") == 0) {
				root_found = TRUE;
			}
			_tmp143_ = fs_entry;
			_tmp144_ = _tmp143_->mount_point;
			if (g_strcmp0 (_tmp144_, "/boot") == 0) {
				boot_found = TRUE;
			}
			_tmp145_ = fs_entry;
			_tmp146_ = _tmp145_->mount_point;
			if (g_strcmp0 (_tmp146_, "/home") == 0) {
				home_found = TRUE;
			}
			_g_object_unref0 (dev_fstab);
			_g_free0 (p3);
			_g_free0 (p2);
			_g_free0 (p1);
			_g_object_unref0 (fs_entry);
		}
	}
	if (!root_found) {
		GeeArrayList* _tmp147_;
		MountEntry* _tmp148_;
		MountEntry* _tmp149_;
		tee_jee_logging_log_debug ("added null entry: /");
		_tmp147_ = self->mount_list;
		_tmp148_ = mount_entry_new (NULL, "/", "");
		_tmp149_ = _tmp148_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp147_, _tmp149_);
		_g_object_unref0 (_tmp149_);
	}
	if (!boot_found) {
		GeeArrayList* _tmp150_;
		MountEntry* _tmp151_;
		MountEntry* _tmp152_;
		tee_jee_logging_log_debug ("added null entry: /boot");
		_tmp150_ = self->mount_list;
		_tmp151_ = mount_entry_new (NULL, "/boot", "");
		_tmp152_ = _tmp151_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp150_, _tmp152_);
		_g_object_unref0 (_tmp152_);
	}
	if (!home_found) {
		GeeArrayList* _tmp153_;
		MountEntry* _tmp154_;
		MountEntry* _tmp155_;
		tee_jee_logging_log_debug ("added null entry: /home");
		_tmp153_ = self->mount_list;
		_tmp154_ = mount_entry_new (NULL, "/home", "");
		_tmp155_ = _tmp154_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp153_, _tmp155_);
		_g_object_unref0 (_tmp155_);
	}
	if (self->mirror_system) {
		main_set_dst_root (self, NULL);
		{
			GeeArrayList* _entry_list = NULL;
			GeeArrayList* _tmp156_;
			gint _entry_size = 0;
			GeeArrayList* _tmp157_;
			gint _tmp158_;
			gint _tmp159_;
			gint _entry_index = 0;
			_tmp156_ = self->mount_list;
			_entry_list = _tmp156_;
			_tmp157_ = _entry_list;
			_tmp158_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp157_);
			_tmp159_ = _tmp158_;
			_entry_size = _tmp159_;
			_entry_index = -1;
			while (TRUE) {
				gint _tmp160_;
				gint _tmp161_;
				MountEntry* entry = NULL;
				GeeArrayList* _tmp162_;
				gpointer _tmp163_;
				MountEntry* _tmp164_;
				_entry_index = _entry_index + 1;
				_tmp160_ = _entry_index;
				_tmp161_ = _entry_size;
				if (!(_tmp160_ < _tmp161_)) {
					break;
				}
				_tmp162_ = _entry_list;
				_tmp163_ = gee_abstract_list_get ((GeeAbstractList*) _tmp162_, _entry_index);
				entry = (MountEntry*) _tmp163_;
				_tmp164_ = entry;
				_g_object_unref0 (_tmp164_->device);
				_tmp164_->device = NULL;
				_g_object_unref0 (entry);
			}
		}
	}
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp165_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp166_;
		gint _tmp167_;
		gint _tmp168_;
		gint _mnt_index = 0;
		_tmp165_ = self->mount_list;
		_mnt_list = _tmp165_;
		_tmp166_ = _mnt_list;
		_tmp167_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp166_);
		_tmp168_ = _tmp167_;
		_mnt_size = _tmp168_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp169_;
			gint _tmp170_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp171_;
			gpointer _tmp172_;
			MountEntry* _tmp173_;
			Device* _tmp174_;
			_mnt_index = _mnt_index + 1;
			_tmp169_ = _mnt_index;
			_tmp170_ = _mnt_size;
			if (!(_tmp169_ < _tmp170_)) {
				break;
			}
			_tmp171_ = _mnt_list;
			_tmp172_ = gee_abstract_list_get ((GeeAbstractList*) _tmp171_, _mnt_index);
			mnt = (MountEntry*) _tmp172_;
			_tmp173_ = mnt;
			_tmp174_ = _tmp173_->device;
			if (_tmp174_ != NULL) {
				MountEntry* _tmp175_;
				Device* _tmp176_;
				const gchar* _tmp177_;
				MountEntry* _tmp178_;
				const gchar* _tmp179_;
				gchar* _tmp180_;
				gchar* _tmp181_;
				_tmp175_ = mnt;
				_tmp176_ = _tmp175_->device;
				_tmp177_ = _tmp176_->device;
				_tmp178_ = mnt;
				_tmp179_ = _tmp178_->mount_point;
				_tmp180_ = g_strdup_printf ("Entry: %s -> %s", _tmp177_, _tmp179_);
				_tmp181_ = _tmp180_;
				tee_jee_logging_log_debug (_tmp181_);
				_g_free0 (_tmp181_);
			} else {
				MountEntry* _tmp182_;
				const gchar* _tmp183_;
				gchar* _tmp184_;
				gchar* _tmp185_;
				_tmp182_ = mnt;
				_tmp183_ = _tmp182_->mount_point;
				_tmp184_ = g_strdup_printf ("Entry: null -> %s", _tmp183_);
				_tmp185_ = _tmp184_;
				tee_jee_logging_log_debug (_tmp185_);
				_g_free0 (_tmp185_);
			}
			_g_object_unref0 (mnt);
		}
	}
	_tmp186_ = self->mount_list;
	gee_list_sort ((GeeList*) _tmp186_, ___lambda19__gcompare_data_func, g_object_ref (self), g_object_unref);
	main_init_boot_options (self);
	tee_jee_logging_log_debug ("Main: init_mount_list(): exit");
	_g_object_unref0 (crypttab_list);
	_g_object_unref0 (fstab_list);
}

void
main_init_boot_options (Main* self)
{
	Device* grub_dev = NULL;
	Device* _tmp0_;
	Device* _tmp1_;
	Device* _tmp2_;
	Device* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_get_dst_root (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	grub_dev = _tmp2_;
	_tmp3_ = grub_dev;
	if (_tmp3_ != NULL) {
		Device* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = grub_dev;
		_tmp5_ = _tmp4_->device;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (self->grub_device);
		self->grub_device = _tmp6_;
	}
	while (TRUE) {
		gboolean _tmp7_ = FALSE;
		Device* _tmp8_;
		Device* _tmp10_;
		Device* _tmp11_;
		Device* _tmp12_;
		Device* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp8_ = grub_dev;
		if (_tmp8_ != NULL) {
			Device* _tmp9_;
			_tmp9_ = grub_dev;
			_tmp7_ = device_has_parent (_tmp9_);
		} else {
			_tmp7_ = FALSE;
		}
		if (!_tmp7_) {
			break;
		}
		_tmp10_ = grub_dev;
		_tmp11_ = _tmp10_->parent;
		_tmp12_ = _g_object_ref0 (_tmp11_);
		_g_object_unref0 (grub_dev);
		grub_dev = _tmp12_;
		_tmp13_ = grub_dev;
		_tmp14_ = _tmp13_->device;
		_tmp15_ = g_strdup (_tmp14_);
		_g_free0 (self->grub_device);
		self->grub_device = _tmp15_;
	}
	if (self->mirror_system) {
		self->reinstall_grub2 = TRUE;
		self->update_initramfs = TRUE;
		self->update_grub = TRUE;
	} else {
		Snapshot* _tmp16_;
		LinuxDistro* _tmp17_;
		const gchar* _tmp18_;
		_tmp16_ = self->snapshot_to_restore;
		_tmp17_ = _tmp16_->distro;
		_tmp18_ = _tmp17_->dist_id;
		if (g_strcmp0 (_tmp18_, "fedora") == 0) {
			self->reinstall_grub2 = FALSE;
			self->update_initramfs = FALSE;
			self->update_grub = TRUE;
		} else {
			self->reinstall_grub2 = TRUE;
			self->update_initramfs = FALSE;
			self->update_grub = TRUE;
		}
	}
	_g_object_unref0 (grub_dev);
}

static gboolean
____lambda20_ (Main* self)
{
	gboolean result;
	main_restore_execute_btrfs (self);
	result = TRUE;
	return result;
}

static gpointer
_____lambda20__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda20_ ((Main*) self));
	g_object_unref (self);
	return result;
}

static gboolean
____lambda21_ (Main* self)
{
	gboolean result;
	main_restore_execute_rsync (self);
	result = TRUE;
	return result;
}

static gpointer
_____lambda21__gthread_func (gpointer self)
{
	gpointer result;
	result = (gpointer) ((gintptr) ____lambda21_ ((Main*) self));
	g_object_unref (self);
	return result;
}

gboolean
main_restore_snapshot (Main* self,
                       GtkWindow* parent_win)
{
	GtkWindow* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_snapshot()");
	_tmp0_ = _g_object_ref0 (parent_win);
	_g_object_unref0 (self->parent_window);
	self->parent_window = _tmp0_;
	{
		gint i = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->mount_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		i = _tmp3_ - 1;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				MountEntry* entry = NULL;
				GeeArrayList* _tmp6_;
				gpointer _tmp7_;
				MountEntry* _tmp8_;
				Device* _tmp9_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ - 1;
				}
				_tmp4_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp6_ = self->mount_list;
				_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, i);
				entry = (MountEntry*) _tmp7_;
				_tmp8_ = entry;
				_tmp9_ = _tmp8_->device;
				if (_tmp9_ == NULL) {
					GeeArrayList* _tmp10_;
					MountEntry* _tmp11_;
					_tmp10_ = self->mount_list;
					_tmp11_ = entry;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				}
				_g_object_unref0 (entry);
			}
		}
	}
	if (!self->mirror_system) {
		SnapshotRepo* _tmp12_;
		Device* _tmp13_;
		Snapshot* _tmp25_;
		_tmp12_ = self->repo;
		_tmp13_ = _tmp12_->device;
		if (_tmp13_ == NULL) {
			tee_jee_logging_log_error (_ ("Backup device not specified!"), FALSE, FALSE);
			result = FALSE;
			return result;
		} else {
			gchar* _tmp14_;
			gchar* _tmp15_;
			SnapshotRepo* _tmp16_;
			Device* _tmp17_;
			const gchar* _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
			_tmp14_ = g_strnfill ((gsize) 78, '*');
			_tmp15_ = _tmp14_;
			tee_jee_logging_log_msg (_tmp15_, FALSE);
			_g_free0 (_tmp15_);
			_tmp16_ = self->repo;
			_tmp17_ = _tmp16_->device;
			_tmp18_ = _tmp17_->device;
			_tmp19_ = g_strdup_printf (": %s", _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_strconcat (_ ("Backup Device"), _tmp20_, NULL);
			_tmp22_ = _tmp21_;
			tee_jee_logging_log_msg (_tmp22_, FALSE);
			_g_free0 (_tmp22_);
			_g_free0 (_tmp20_);
			_tmp23_ = g_strnfill ((gsize) 78, '*');
			_tmp24_ = _tmp23_;
			tee_jee_logging_log_msg (_tmp24_, FALSE);
			_g_free0 (_tmp24_);
		}
		_tmp25_ = self->snapshot_to_restore;
		if (_tmp25_ == NULL) {
			tee_jee_logging_log_error (_ ("Snapshot to restore not specified!"), FALSE, FALSE);
			result = FALSE;
			return result;
		} else {
			gboolean _tmp26_ = FALSE;
			Snapshot* _tmp27_;
			_tmp27_ = self->snapshot_to_restore;
			if (_tmp27_ != NULL) {
				Snapshot* _tmp28_;
				_tmp28_ = self->snapshot_to_restore;
				_tmp26_ = _tmp28_->marked_for_deletion;
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				tee_jee_logging_log_error (_ ("Invalid Snapshot"), FALSE, FALSE);
				tee_jee_logging_log_error (_ ("Selected snapshot is marked for deletion"), FALSE, FALSE);
				result = FALSE;
				return result;
			} else {
				gchar* _tmp29_;
				gchar* _tmp30_;
				Snapshot* _tmp31_;
				const gchar* _tmp32_;
				Snapshot* _tmp33_;
				const gchar* _tmp34_;
				gchar* _tmp35_;
				gchar* _tmp36_;
				gchar* _tmp37_;
				gchar* _tmp38_;
				_tmp29_ = g_strnfill ((gsize) 78, '*');
				_tmp30_ = _tmp29_;
				tee_jee_logging_log_msg (_tmp30_, FALSE);
				_g_free0 (_tmp30_);
				_tmp31_ = self->snapshot_to_restore;
				_tmp32_ = _tmp31_->name;
				_tmp33_ = self->snapshot_to_restore;
				_tmp34_ = _tmp33_->description;
				_tmp35_ = g_strdup_printf ("%s: %s ~ %s", _ ("Snapshot"), _tmp32_, _tmp34_);
				_tmp36_ = _tmp35_;
				tee_jee_logging_log_msg (_tmp36_, FALSE);
				_g_free0 (_tmp36_);
				_tmp37_ = g_strnfill ((gsize) 78, '*');
				_tmp38_ = _tmp37_;
				tee_jee_logging_log_msg (_tmp38_, FALSE);
				_g_free0 (_tmp38_);
			}
		}
	}
	if (self->btrfs_mode) {
		SnapshotRepo* _tmp39_;
		GeeHashMap* _tmp40_;
		gpointer _tmp41_;
		gchar* _tmp42_;
		gint _tmp43_;
		gint _tmp44_;
		gboolean _tmp45_;
		gboolean _tmp48_ = FALSE;
		_tmp39_ = self->repo;
		_tmp40_ = _tmp39_->mount_paths;
		_tmp41_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, "@");
		_tmp42_ = (gchar*) _tmp41_;
		_tmp43_ = strlen (_tmp42_);
		_tmp44_ = _tmp43_;
		_tmp45_ = _tmp44_ == 0;
		_g_free0 (_tmp42_);
		if (_tmp45_) {
			gchar* _tmp46_;
			gchar* _tmp47_;
			_tmp46_ = g_strconcat (_ ("BTRFS device is not mounted"), ": @", NULL);
			_tmp47_ = _tmp46_;
			tee_jee_logging_log_error (_tmp47_, FALSE, FALSE);
			_g_free0 (_tmp47_);
			result = FALSE;
			return result;
		}
		if (self->include_btrfs_home_for_restore) {
			SnapshotRepo* _tmp49_;
			GeeHashMap* _tmp50_;
			gpointer _tmp51_;
			gchar* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			_tmp49_ = self->repo;
			_tmp50_ = _tmp49_->mount_paths;
			_tmp51_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp50_, "@home");
			_tmp52_ = (gchar*) _tmp51_;
			_tmp53_ = strlen (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp48_ = _tmp54_ == 0;
			_g_free0 (_tmp52_);
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			gchar* _tmp55_;
			gchar* _tmp56_;
			_tmp55_ = g_strconcat (_ ("BTRFS device is not mounted"), ": @home", NULL);
			_tmp56_ = _tmp55_;
			tee_jee_logging_log_error (_tmp56_, FALSE, FALSE);
			_g_free0 (_tmp56_);
			result = FALSE;
			return result;
		}
	} else {
		Device* _tmp57_;
		Device* _tmp58_;
		gboolean _tmp59_;
		gboolean _tmp60_;
		_tmp57_ = main_get_dst_root (self);
		_tmp58_ = _tmp57_;
		if (_tmp58_ == NULL) {
			tee_jee_logging_log_error (_ ("Target device not specified!"), FALSE, FALSE);
			result = FALSE;
			return result;
		}
		_tmp59_ = main_get_restore_current_system (self);
		_tmp60_ = _tmp59_;
		if (!_tmp60_) {
			const gchar* _tmp61_;
			gchar* _tmp62_;
			gchar* _tmp63_;
			gint _tmp64_;
			gint _tmp65_;
			gboolean _tmp66_;
			_tmp61_ = self->mount_point_restore;
			_tmp62_ = string_strip (_tmp61_);
			_tmp63_ = _tmp62_;
			_tmp64_ = strlen (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = _tmp65_ == 0;
			_g_free0 (_tmp63_);
			if (_tmp66_) {
				tee_jee_logging_log_error (_ ("Target device is not mounted"), FALSE, FALSE);
				result = FALSE;
				return result;
			}
		}
	}
	{
		self->thread_restore_running = TRUE;
		self->thr_success = FALSE;
		if (self->btrfs_mode) {
			GThread* _tmp67_;
			GThread* _tmp68_;
			_tmp67_ = g_thread_try_new ("restore-execute-btrfs", _____lambda20__gthread_func, g_object_ref (self), &_inner_error0_);
			_tmp68_ = _tmp67_;
			_g_thread_unref0 (_tmp68_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			GThread* _tmp69_;
			GThread* _tmp70_;
			_tmp69_ = g_thread_try_new ("restore-execute-rsync", _____lambda21__gthread_func, g_object_ref (self), &_inner_error0_);
			_tmp70_ = _tmp69_;
			_g_thread_unref0 (_tmp70_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp71_;
		const gchar* _tmp72_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->thread_restore_running = FALSE;
		self->thr_success = FALSE;
		_tmp71_ = e;
		_tmp72_ = _tmp71_->message;
		tee_jee_logging_log_error (_tmp72_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp73_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp73_;
	}
	while (TRUE) {
		if (!self->thread_restore_running) {
			break;
		}
		tee_jee_gtk_helper_gtk_do_events ();
		g_usleep (((gulong) G_TIME_SPAN_MILLISECOND) * 100);
	}
	if (!self->dry_run) {
		_g_object_unref0 (self->snapshot_to_restore);
		self->snapshot_to_restore = NULL;
	}
	tee_jee_logging_log_debug ("Main: restore_snapshot(): exit");
	result = self->thr_success;
	return result;
}

void
main_get_restore_messages (Main* self,
                           gboolean formatted,
                           gchar** msg_devices,
                           gchar** msg_reboot,
                           gchar** msg_disclaimer)
{
	gchar* _vala_msg_devices = NULL;
	gchar* _vala_msg_reboot = NULL;
	gchar* _vala_msg_disclaimer = NULL;
	gchar* msg = NULL;
	gchar* _tmp0_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gint max_mount = 0;
	gint _tmp15_;
	gint _tmp16_;
	gint max_dev = 0;
	gint _tmp17_;
	gint _tmp18_;
	gchar* txt = NULL;
	gchar* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	const gchar* _tmp95_;
	gchar* _tmp96_;
	const gchar* _tmp97_;
	gchar* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	gchar* _tmp101_;
	gchar* _tmp102_;
	gchar* _tmp103_;
	gchar* _tmp104_;
	gchar* _tmp105_;
	gchar* _tmp106_;
	const gchar* _tmp107_;
	gchar* _tmp108_;
	const gchar* _tmp188_;
	gchar* _tmp189_;
	gchar* _tmp190_;
	gboolean _tmp191_;
	gboolean _tmp192_;
	const gchar* _tmp199_;
	gchar* _tmp200_;
	gchar* _tmp201_;
	const gchar* _tmp212_;
	gchar* _tmp213_;
	const gchar* _tmp214_;
	gchar* _tmp215_;
	gchar* _tmp216_;
	gchar* _tmp217_;
	const gchar* _tmp220_;
	gchar* _tmp221_;
	const gchar* _tmp222_;
	gint _tmp223_;
	gint _tmp224_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	msg = _tmp0_;
	tee_jee_logging_log_debug ("Main: get_restore_messages()");
	if (!formatted) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp1_ = msg;
		_tmp2_ = g_strnfill ((gsize) 70, '=');
		_tmp3_ = _tmp2_;
		_tmp4_ = g_utf8_strup (_ ("Warning"), (gssize) -1);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strnfill ((gsize) 70, '=');
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("\n%s\n%s\n%s\n", _tmp3_, _tmp5_, _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strconcat (_tmp1_, _tmp9_, NULL);
		_g_free0 (msg);
		msg = _tmp10_;
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp3_);
	}
	_tmp11_ = msg;
	_tmp12_ = g_strconcat (_ ("Data will be modified on following devices:"), "\n\n", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
	_g_free0 (msg);
	msg = _tmp14_;
	_g_free0 (_tmp13_);
	_tmp15_ = strlen (_ ("Mount"));
	_tmp16_ = _tmp15_;
	max_mount = _tmp16_;
	_tmp17_ = strlen (_ ("Device"));
	_tmp18_ = _tmp17_;
	max_dev = _tmp18_;
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp19_;
		gint _entry_size = 0;
		GeeArrayList* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		gint _entry_index = 0;
		_tmp19_ = self->mount_list;
		_entry_list = _tmp19_;
		_tmp20_ = _entry_list;
		_tmp21_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp20_);
		_tmp22_ = _tmp21_;
		_entry_size = _tmp22_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp23_;
			gint _tmp24_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp25_;
			gpointer _tmp26_;
			MountEntry* _tmp27_;
			Device* _tmp28_;
			gchar* dev_name = NULL;
			MountEntry* _tmp47_;
			Device* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			MountEntry* _tmp51_;
			gchar* _tmp52_;
			gchar* _tmp53_;
			gint _tmp54_;
			gint _tmp55_;
			gboolean _tmp56_;
			const gchar* _tmp77_;
			gint _tmp78_;
			gint _tmp79_;
			MountEntry* _tmp83_;
			const gchar* _tmp84_;
			gint _tmp85_;
			gint _tmp86_;
			_entry_index = _entry_index + 1;
			_tmp23_ = _entry_index;
			_tmp24_ = _entry_size;
			if (!(_tmp23_ < _tmp24_)) {
				break;
			}
			_tmp25_ = _entry_list;
			_tmp26_ = gee_abstract_list_get ((GeeAbstractList*) _tmp25_, _entry_index);
			entry = (MountEntry*) _tmp26_;
			_tmp27_ = entry;
			_tmp28_ = _tmp27_->device;
			if (_tmp28_ == NULL) {
				_g_object_unref0 (entry);
				continue;
			}
			if (self->btrfs_mode) {
				MountEntry* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gboolean _tmp34_;
				Main* _tmp35_;
				Snapshot* _tmp36_;
				GeeHashMap* _tmp37_;
				MountEntry* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				gboolean _tmp41_;
				gboolean _tmp42_ = FALSE;
				MountEntry* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				gboolean _tmp46_;
				_tmp29_ = entry;
				_tmp30_ = mount_entry_subvolume_name (_tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = strlen (_tmp31_);
				_tmp33_ = _tmp32_;
				_tmp34_ = _tmp33_ == 0;
				_g_free0 (_tmp31_);
				if (_tmp34_) {
					_g_object_unref0 (entry);
					continue;
				}
				_tmp35_ = App;
				_tmp36_ = _tmp35_->snapshot_to_restore;
				_tmp37_ = _tmp36_->subvolumes;
				_tmp38_ = entry;
				_tmp39_ = mount_entry_subvolume_name (_tmp38_);
				_tmp40_ = _tmp39_;
				_tmp41_ = !gee_abstract_map_has_key ((GeeAbstractMap*) _tmp37_, _tmp40_);
				_g_free0 (_tmp40_);
				if (_tmp41_) {
					_g_object_unref0 (entry);
					continue;
				}
				_tmp43_ = entry;
				_tmp44_ = mount_entry_subvolume_name (_tmp43_);
				_tmp45_ = _tmp44_;
				_tmp46_ = g_strcmp0 (_tmp45_, "@home") == 0;
				_g_free0 (_tmp45_);
				if (_tmp46_) {
					_tmp42_ = !self->include_btrfs_home_for_restore;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					_g_object_unref0 (entry);
					continue;
				}
			}
			_tmp47_ = entry;
			_tmp48_ = _tmp47_->device;
			_tmp49_ = device_get_full_name_with_parent (_tmp48_);
			_tmp50_ = _tmp49_;
			dev_name = _tmp50_;
			_tmp51_ = entry;
			_tmp52_ = mount_entry_subvolume_name (_tmp51_);
			_tmp53_ = _tmp52_;
			_tmp54_ = strlen (_tmp53_);
			_tmp55_ = _tmp54_;
			_tmp56_ = _tmp55_ > 0;
			_g_free0 (_tmp53_);
			if (_tmp56_) {
				const gchar* _tmp57_;
				MountEntry* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				gchar* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp57_ = dev_name;
				_tmp58_ = entry;
				_tmp59_ = mount_entry_subvolume_name (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = g_strdup_printf ("(%s)", _tmp60_);
				_tmp62_ = _tmp61_;
				_tmp63_ = g_strconcat (_tmp57_, _tmp62_, NULL);
				_g_free0 (dev_name);
				dev_name = _tmp63_;
				_g_free0 (_tmp62_);
				_g_free0 (_tmp60_);
			} else {
				MountEntry* _tmp64_;
				gchar* _tmp65_;
				gchar* _tmp66_;
				gint _tmp67_;
				gint _tmp68_;
				gboolean _tmp69_;
				_tmp64_ = entry;
				_tmp65_ = mount_entry_lvm_name (_tmp64_);
				_tmp66_ = _tmp65_;
				_tmp67_ = strlen (_tmp66_);
				_tmp68_ = _tmp67_;
				_tmp69_ = _tmp68_ > 0;
				_g_free0 (_tmp66_);
				if (_tmp69_) {
					const gchar* _tmp70_;
					MountEntry* _tmp71_;
					gchar* _tmp72_;
					gchar* _tmp73_;
					gchar* _tmp74_;
					gchar* _tmp75_;
					gchar* _tmp76_;
					_tmp70_ = dev_name;
					_tmp71_ = entry;
					_tmp72_ = mount_entry_lvm_name (_tmp71_);
					_tmp73_ = _tmp72_;
					_tmp74_ = g_strdup_printf ("(%s)", _tmp73_);
					_tmp75_ = _tmp74_;
					_tmp76_ = g_strconcat (_tmp70_, _tmp75_, NULL);
					_g_free0 (dev_name);
					dev_name = _tmp76_;
					_g_free0 (_tmp75_);
					_g_free0 (_tmp73_);
				}
			}
			_tmp77_ = dev_name;
			_tmp78_ = strlen (_tmp77_);
			_tmp79_ = _tmp78_;
			if (_tmp79_ > max_dev) {
				const gchar* _tmp80_;
				gint _tmp81_;
				gint _tmp82_;
				_tmp80_ = dev_name;
				_tmp81_ = strlen (_tmp80_);
				_tmp82_ = _tmp81_;
				max_dev = _tmp82_;
			}
			_tmp83_ = entry;
			_tmp84_ = _tmp83_->mount_point;
			_tmp85_ = strlen (_tmp84_);
			_tmp86_ = _tmp85_;
			if (_tmp86_ > max_mount) {
				MountEntry* _tmp87_;
				const gchar* _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				_tmp87_ = entry;
				_tmp88_ = _tmp87_->mount_point;
				_tmp89_ = strlen (_tmp88_);
				_tmp90_ = _tmp89_;
				max_mount = _tmp90_;
			}
			_g_free0 (dev_name);
			_g_object_unref0 (entry);
		}
	}
	_tmp91_ = g_strdup_printf ("%%-%ds  %%-%ds", max_dev, max_mount);
	_tmp92_ = _tmp91_;
	_tmp93_ = g_strdup_printf (_tmp92_, _ ("Device"), _ ("Mount"));
	_tmp94_ = _tmp93_;
	_g_free0 (_tmp92_);
	txt = _tmp94_;
	_tmp95_ = txt;
	_tmp96_ = g_strconcat (_tmp95_, "\n", NULL);
	_g_free0 (txt);
	txt = _tmp96_;
	_tmp97_ = txt;
	_tmp98_ = g_strnfill ((gsize) max_dev, '-');
	_tmp99_ = _tmp98_;
	_tmp100_ = g_strconcat (_tmp99_, "  ", NULL);
	_tmp101_ = _tmp100_;
	_tmp102_ = g_strnfill ((gsize) max_mount, '-');
	_tmp103_ = _tmp102_;
	_tmp104_ = g_strconcat (_tmp101_, _tmp103_, NULL);
	_tmp105_ = _tmp104_;
	_tmp106_ = g_strconcat (_tmp97_, _tmp105_, NULL);
	_g_free0 (txt);
	txt = _tmp106_;
	_g_free0 (_tmp105_);
	_g_free0 (_tmp103_);
	_g_free0 (_tmp101_);
	_g_free0 (_tmp99_);
	_tmp107_ = txt;
	_tmp108_ = g_strconcat (_tmp107_, "\n", NULL);
	_g_free0 (txt);
	txt = _tmp108_;
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp109_;
		gint _entry_size = 0;
		GeeArrayList* _tmp110_;
		gint _tmp111_;
		gint _tmp112_;
		gint _entry_index = 0;
		_tmp109_ = self->mount_list;
		_entry_list = _tmp109_;
		_tmp110_ = _entry_list;
		_tmp111_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp110_);
		_tmp112_ = _tmp111_;
		_entry_size = _tmp112_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp113_;
			gint _tmp114_;
			MountEntry* entry = NULL;
			GeeArrayList* _tmp115_;
			gpointer _tmp116_;
			MountEntry* _tmp117_;
			Device* _tmp118_;
			gchar* dev_name = NULL;
			MountEntry* _tmp137_;
			Device* _tmp138_;
			gchar* _tmp139_;
			gchar* _tmp140_;
			MountEntry* _tmp141_;
			gchar* _tmp142_;
			gchar* _tmp143_;
			gint _tmp144_;
			gint _tmp145_;
			gboolean _tmp146_;
			const gchar* _tmp167_;
			gchar* _tmp168_;
			gchar* _tmp169_;
			const gchar* _tmp170_;
			MountEntry* _tmp171_;
			const gchar* _tmp172_;
			gchar* _tmp173_;
			gchar* _tmp174_;
			gchar* _tmp175_;
			const gchar* _tmp176_;
			gchar* _tmp177_;
			_entry_index = _entry_index + 1;
			_tmp113_ = _entry_index;
			_tmp114_ = _entry_size;
			if (!(_tmp113_ < _tmp114_)) {
				break;
			}
			_tmp115_ = _entry_list;
			_tmp116_ = gee_abstract_list_get ((GeeAbstractList*) _tmp115_, _entry_index);
			entry = (MountEntry*) _tmp116_;
			_tmp117_ = entry;
			_tmp118_ = _tmp117_->device;
			if (_tmp118_ == NULL) {
				_g_object_unref0 (entry);
				continue;
			}
			if (self->btrfs_mode) {
				MountEntry* _tmp119_;
				gchar* _tmp120_;
				gchar* _tmp121_;
				gint _tmp122_;
				gint _tmp123_;
				gboolean _tmp124_;
				Main* _tmp125_;
				Snapshot* _tmp126_;
				GeeHashMap* _tmp127_;
				MountEntry* _tmp128_;
				gchar* _tmp129_;
				gchar* _tmp130_;
				gboolean _tmp131_;
				gboolean _tmp132_ = FALSE;
				MountEntry* _tmp133_;
				gchar* _tmp134_;
				gchar* _tmp135_;
				gboolean _tmp136_;
				_tmp119_ = entry;
				_tmp120_ = mount_entry_subvolume_name (_tmp119_);
				_tmp121_ = _tmp120_;
				_tmp122_ = strlen (_tmp121_);
				_tmp123_ = _tmp122_;
				_tmp124_ = _tmp123_ == 0;
				_g_free0 (_tmp121_);
				if (_tmp124_) {
					_g_object_unref0 (entry);
					continue;
				}
				_tmp125_ = App;
				_tmp126_ = _tmp125_->snapshot_to_restore;
				_tmp127_ = _tmp126_->subvolumes;
				_tmp128_ = entry;
				_tmp129_ = mount_entry_subvolume_name (_tmp128_);
				_tmp130_ = _tmp129_;
				_tmp131_ = !gee_abstract_map_has_key ((GeeAbstractMap*) _tmp127_, _tmp130_);
				_g_free0 (_tmp130_);
				if (_tmp131_) {
					_g_object_unref0 (entry);
					continue;
				}
				_tmp133_ = entry;
				_tmp134_ = mount_entry_subvolume_name (_tmp133_);
				_tmp135_ = _tmp134_;
				_tmp136_ = g_strcmp0 (_tmp135_, "@home") == 0;
				_g_free0 (_tmp135_);
				if (_tmp136_) {
					_tmp132_ = !self->include_btrfs_home_for_restore;
				} else {
					_tmp132_ = FALSE;
				}
				if (_tmp132_) {
					_g_object_unref0 (entry);
					continue;
				}
			}
			_tmp137_ = entry;
			_tmp138_ = _tmp137_->device;
			_tmp139_ = device_get_full_name_with_parent (_tmp138_);
			_tmp140_ = _tmp139_;
			dev_name = _tmp140_;
			_tmp141_ = entry;
			_tmp142_ = mount_entry_subvolume_name (_tmp141_);
			_tmp143_ = _tmp142_;
			_tmp144_ = strlen (_tmp143_);
			_tmp145_ = _tmp144_;
			_tmp146_ = _tmp145_ > 0;
			_g_free0 (_tmp143_);
			if (_tmp146_) {
				const gchar* _tmp147_;
				MountEntry* _tmp148_;
				gchar* _tmp149_;
				gchar* _tmp150_;
				gchar* _tmp151_;
				gchar* _tmp152_;
				gchar* _tmp153_;
				_tmp147_ = dev_name;
				_tmp148_ = entry;
				_tmp149_ = mount_entry_subvolume_name (_tmp148_);
				_tmp150_ = _tmp149_;
				_tmp151_ = g_strdup_printf ("(%s)", _tmp150_);
				_tmp152_ = _tmp151_;
				_tmp153_ = g_strconcat (_tmp147_, _tmp152_, NULL);
				_g_free0 (dev_name);
				dev_name = _tmp153_;
				_g_free0 (_tmp152_);
				_g_free0 (_tmp150_);
			} else {
				MountEntry* _tmp154_;
				gchar* _tmp155_;
				gchar* _tmp156_;
				gint _tmp157_;
				gint _tmp158_;
				gboolean _tmp159_;
				_tmp154_ = entry;
				_tmp155_ = mount_entry_lvm_name (_tmp154_);
				_tmp156_ = _tmp155_;
				_tmp157_ = strlen (_tmp156_);
				_tmp158_ = _tmp157_;
				_tmp159_ = _tmp158_ > 0;
				_g_free0 (_tmp156_);
				if (_tmp159_) {
					const gchar* _tmp160_;
					MountEntry* _tmp161_;
					gchar* _tmp162_;
					gchar* _tmp163_;
					gchar* _tmp164_;
					gchar* _tmp165_;
					gchar* _tmp166_;
					_tmp160_ = dev_name;
					_tmp161_ = entry;
					_tmp162_ = mount_entry_lvm_name (_tmp161_);
					_tmp163_ = _tmp162_;
					_tmp164_ = g_strdup_printf ("(%s)", _tmp163_);
					_tmp165_ = _tmp164_;
					_tmp166_ = g_strconcat (_tmp160_, _tmp165_, NULL);
					_g_free0 (dev_name);
					dev_name = _tmp166_;
					_g_free0 (_tmp165_);
					_g_free0 (_tmp163_);
				}
			}
			_tmp167_ = txt;
			_tmp168_ = g_strdup_printf ("%%-%ds  %%-%ds", max_dev, max_mount);
			_tmp169_ = _tmp168_;
			_tmp170_ = dev_name;
			_tmp171_ = entry;
			_tmp172_ = _tmp171_->mount_point;
			_tmp173_ = g_strdup_printf (_tmp169_, _tmp170_, _tmp172_);
			_tmp174_ = _tmp173_;
			_tmp175_ = g_strconcat (_tmp167_, _tmp174_, NULL);
			_g_free0 (txt);
			txt = _tmp175_;
			_g_free0 (_tmp174_);
			_g_free0 (_tmp169_);
			_tmp176_ = txt;
			_tmp177_ = g_strconcat (_tmp176_, "\n", NULL);
			_g_free0 (txt);
			txt = _tmp177_;
			_g_free0 (dev_name);
			_g_object_unref0 (entry);
		}
	}
	if (formatted) {
		const gchar* _tmp178_;
		const gchar* _tmp179_;
		gchar* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		_tmp178_ = msg;
		_tmp179_ = txt;
		_tmp180_ = g_strdup_printf ("<span size=\"medium\"><tt>%s</tt></span>", _tmp179_);
		_tmp181_ = _tmp180_;
		_tmp182_ = g_strconcat (_tmp178_, _tmp181_, NULL);
		_g_free0 (msg);
		msg = _tmp182_;
		_g_free0 (_tmp181_);
	} else {
		const gchar* _tmp183_;
		const gchar* _tmp184_;
		gchar* _tmp185_;
		gchar* _tmp186_;
		gchar* _tmp187_;
		_tmp183_ = msg;
		_tmp184_ = txt;
		_tmp185_ = g_strdup_printf ("%s\n", _tmp184_);
		_tmp186_ = _tmp185_;
		_tmp187_ = g_strconcat (_tmp183_, _tmp186_, NULL);
		_g_free0 (msg);
		msg = _tmp187_;
		_g_free0 (_tmp186_);
	}
	_tmp188_ = msg;
	_tmp189_ = g_strdup (_tmp188_);
	_g_free0 (_vala_msg_devices);
	_vala_msg_devices = _tmp189_;
	_tmp190_ = g_strdup ("");
	_g_free0 (msg);
	msg = _tmp190_;
	_tmp191_ = main_get_restore_current_system (self);
	_tmp192_ = _tmp191_;
	if (_tmp192_) {
		const gchar* _tmp193_;
		gchar* _tmp194_;
		gchar* _tmp195_;
		gchar* _tmp196_;
		const gchar* _tmp197_;
		gchar* _tmp198_;
		_tmp193_ = msg;
		_tmp194_ = g_strconcat (_ ("Please save your work and close all applications."), "\n", NULL);
		_tmp195_ = _tmp194_;
		_tmp196_ = g_strconcat (_tmp193_, _tmp195_, NULL);
		_g_free0 (msg);
		msg = _tmp196_;
		_g_free0 (_tmp195_);
		_tmp197_ = msg;
		_tmp198_ = g_strconcat (_tmp197_, _ ("System will reboot after files are restored."), NULL);
		_g_free0 (msg);
		msg = _tmp198_;
	}
	_tmp199_ = msg;
	_tmp200_ = g_strdup (_tmp199_);
	_g_free0 (_vala_msg_reboot);
	_vala_msg_reboot = _tmp200_;
	_tmp201_ = g_strdup ("");
	_g_free0 (msg);
	msg = _tmp201_;
	if (!formatted) {
		const gchar* _tmp202_;
		gchar* _tmp203_;
		gchar* _tmp204_;
		gchar* _tmp205_;
		gchar* _tmp206_;
		gchar* _tmp207_;
		gchar* _tmp208_;
		gchar* _tmp209_;
		gchar* _tmp210_;
		gchar* _tmp211_;
		_tmp202_ = msg;
		_tmp203_ = g_strnfill ((gsize) 70, '=');
		_tmp204_ = _tmp203_;
		_tmp205_ = g_utf8_strup (_ ("Disclaimer"), (gssize) -1);
		_tmp206_ = _tmp205_;
		_tmp207_ = g_strnfill ((gsize) 70, '=');
		_tmp208_ = _tmp207_;
		_tmp209_ = g_strdup_printf ("\n%s\n%s\n%s\n", _tmp204_, _tmp206_, _tmp208_);
		_tmp210_ = _tmp209_;
		_tmp211_ = g_strconcat (_tmp202_, _tmp210_, NULL);
		_g_free0 (msg);
		msg = _tmp211_;
		_g_free0 (_tmp210_);
		_g_free0 (_tmp208_);
		_g_free0 (_tmp206_);
		_g_free0 (_tmp204_);
	}
	_tmp212_ = msg;
	_tmp213_ = g_strconcat (_tmp212_, _ ("This software comes without absolutely NO warranty and the author take" \
"s no responsibility for any damage arising from the use of this progra" \
"m."), NULL);
	_g_free0 (msg);
	msg = _tmp213_;
	_tmp214_ = msg;
	_tmp215_ = g_strconcat (" ", _ ("If these terms are not acceptable to you, please do not proceed beyond" \
" this point!"), NULL);
	_tmp216_ = _tmp215_;
	_tmp217_ = g_strconcat (_tmp214_, _tmp216_, NULL);
	_g_free0 (msg);
	msg = _tmp217_;
	_g_free0 (_tmp216_);
	if (!formatted) {
		const gchar* _tmp218_;
		gchar* _tmp219_;
		_tmp218_ = msg;
		_tmp219_ = g_strconcat (_tmp218_, "\n", NULL);
		_g_free0 (msg);
		msg = _tmp219_;
	}
	_tmp220_ = msg;
	_tmp221_ = g_strdup (_tmp220_);
	_g_free0 (_vala_msg_disclaimer);
	_vala_msg_disclaimer = _tmp221_;
	_tmp222_ = self->app_mode;
	_tmp223_ = strlen (_tmp222_);
	_tmp224_ = _tmp223_;
	if (_tmp224_ > 0) {
		const gchar* _tmp225_;
		const gchar* _tmp226_;
		const gchar* _tmp227_;
		_tmp225_ = _vala_msg_devices;
		tee_jee_logging_log_msg (_tmp225_, FALSE);
		_tmp226_ = _vala_msg_reboot;
		tee_jee_logging_log_msg (_tmp226_, FALSE);
		_tmp227_ = _vala_msg_disclaimer;
		tee_jee_logging_log_msg (_tmp227_, FALSE);
	}
	tee_jee_logging_log_debug ("Main: get_restore_messages(): exit");
	_g_free0 (txt);
	_g_free0 (msg);
	if (msg_devices) {
		*msg_devices = _vala_msg_devices;
	} else {
		_g_free0 (_vala_msg_devices);
	}
	if (msg_reboot) {
		*msg_reboot = _vala_msg_reboot;
	} else {
		_g_free0 (_vala_msg_reboot);
	}
	if (msg_disclaimer) {
		*msg_disclaimer = _vala_msg_disclaimer;
	} else {
		_g_free0 (_vala_msg_disclaimer);
	}
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
main_create_restore_scripts (Main* self,
                             gchar** sh_sync,
                             gchar** sh_finish)
{
	gchar* _vala_sh_sync = NULL;
	gchar* _vala_sh_finish = NULL;
	gchar* sh = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar* _tmp70_;
	const gchar* _tmp71_ = NULL;
	const gchar* _tmp72_;
	gchar* _tmp74_;
	gchar* _tmp75_;
	LinuxDistro* target_distro = NULL;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	LinuxDistro* _tmp79_;
	LinuxDistro* _tmp80_;
	gchar* _tmp81_;
	gchar* chroot = NULL;
	gchar* _tmp82_;
	gboolean _tmp83_;
	gboolean _tmp84_;
	gboolean _tmp99_ = FALSE;
	gboolean _tmp100_ = FALSE;
	const gchar* _tmp209_;
	gchar* _tmp210_;
	gchar* _tmp211_;
	gchar* _tmp212_;
	gchar* _tmp213_;
	gchar* _tmp214_;
	const gchar* _tmp215_;
	gchar* _tmp216_;
	const gchar* _tmp217_;
	gchar* _tmp218_;
	gboolean _tmp219_;
	gboolean _tmp220_;
	const gchar* _tmp236_;
	const gchar* _tmp237_;
	gchar* _tmp238_;
	const gchar* _tmp239_;
	gchar* _tmp240_;
	const gchar* _tmp241_;
	gchar* _tmp242_;
	gboolean _tmp243_;
	gboolean _tmp244_;
	const gchar* _tmp257_;
	gchar* _tmp258_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: create_restore_scripts()");
	_tmp0_ = g_strdup ("export LC_ALL=C.UTF-8\n");
	sh = _tmp0_;
	_tmp1_ = g_strdup ("");
	_g_free0 (sh);
	sh = _tmp1_;
	_tmp2_ = sh;
	_tmp3_ = g_strconcat (_tmp2_, "echo ''\n", NULL);
	_g_free0 (sh);
	sh = _tmp3_;
	_tmp4_ = main_get_restore_current_system (self);
	_tmp5_ = _tmp4_;
	if (_tmp5_) {
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		tee_jee_logging_log_debug ("restoring current system");
		_tmp6_ = sh;
		_tmp7_ = g_strconcat ("echo '", _ ("Please do not interrupt the restore process!"), NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_strconcat (_tmp8_, "'\n", NULL);
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
		_g_free0 (sh);
		sh = _tmp11_;
		_g_free0 (_tmp10_);
		_g_free0 (_tmp8_);
		_tmp12_ = sh;
		_tmp13_ = g_strconcat ("echo '", _ ("System will reboot after files are restored"), NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "'\n", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
		_g_free0 (sh);
		sh = _tmp17_;
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
	}
	_tmp18_ = sh;
	_tmp19_ = g_strconcat (_tmp18_, "echo ''\n", NULL);
	_g_free0 (sh);
	sh = _tmp19_;
	_tmp20_ = sh;
	_tmp21_ = g_strconcat (_tmp20_, "sleep 3s\n", NULL);
	_g_free0 (sh);
	sh = _tmp21_;
	_tmp22_ = sh;
	_tmp23_ = g_strconcat (_tmp22_, "rsync -avir --force --delete --delete-before", NULL);
	_g_free0 (sh);
	sh = _tmp23_;
	if (self->dry_run) {
		const gchar* _tmp24_;
		gchar* _tmp25_;
		_tmp24_ = sh;
		_tmp25_ = g_strconcat (_tmp24_, " --dry-run", NULL);
		_g_free0 (sh);
		sh = _tmp25_;
	}
	_tmp26_ = sh;
	_tmp27_ = main_get_restore_log_file (self);
	_tmp28_ = _tmp27_;
	_tmp29_ = _tmp28_;
	_tmp30_ = g_strdup_printf (" --log-file=\"%s\"", _tmp29_);
	_tmp31_ = _tmp30_;
	_tmp32_ = g_strconcat (_tmp26_, _tmp31_, NULL);
	_g_free0 (sh);
	sh = _tmp32_;
	_g_free0 (_tmp31_);
	_g_free0 (_tmp29_);
	_tmp33_ = sh;
	_tmp34_ = main_get_restore_exclude_file (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = _tmp35_;
	_tmp37_ = g_strdup_printf (" --exclude-from=\"%s\"", _tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = g_strconcat (_tmp33_, _tmp38_, NULL);
	_g_free0 (sh);
	sh = _tmp39_;
	_g_free0 (_tmp38_);
	_g_free0 (_tmp36_);
	if (self->mirror_system) {
		const gchar* _tmp40_;
		gchar* _tmp41_;
		gchar* _tmp42_;
		gchar* _tmp43_;
		gchar* _tmp44_;
		gchar* _tmp45_;
		gchar* _tmp46_;
		_tmp40_ = sh;
		_tmp41_ = main_get_restore_target_path (self);
		_tmp42_ = _tmp41_;
		_tmp43_ = _tmp42_;
		_tmp44_ = g_strdup_printf (" \"%s\" \"%s\" \n", "/", _tmp43_);
		_tmp45_ = _tmp44_;
		_tmp46_ = g_strconcat (_tmp40_, _tmp45_, NULL);
		_g_free0 (sh);
		sh = _tmp46_;
		_g_free0 (_tmp45_);
		_g_free0 (_tmp43_);
	} else {
		const gchar* _tmp47_;
		gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		gchar* _tmp52_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		gchar* _tmp58_;
		_tmp47_ = sh;
		_tmp48_ = main_get_restore_source_path (self);
		_tmp49_ = _tmp48_;
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strconcat (_tmp50_, "/localhost/", NULL);
		_tmp52_ = _tmp51_;
		_tmp53_ = main_get_restore_target_path (self);
		_tmp54_ = _tmp53_;
		_tmp55_ = _tmp54_;
		_tmp56_ = g_strdup_printf (" \"%s\" \"%s\" \n", _tmp52_, _tmp55_);
		_tmp57_ = _tmp56_;
		_tmp58_ = g_strconcat (_tmp47_, _tmp57_, NULL);
		_g_free0 (sh);
		sh = _tmp58_;
		_g_free0 (_tmp57_);
		_g_free0 (_tmp55_);
		_g_free0 (_tmp52_);
		_g_free0 (_tmp50_);
	}
	if (self->dry_run) {
		const gchar* _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp59_ = sh;
		_tmp60_ = g_strdup (_tmp59_);
		_g_free0 (_vala_sh_sync);
		_vala_sh_sync = _tmp60_;
		_tmp61_ = g_strdup ("");
		_g_free0 (_vala_sh_finish);
		_vala_sh_finish = _tmp61_;
		_g_free0 (sh);
		if (sh_sync) {
			*sh_sync = _vala_sh_sync;
		} else {
			_g_free0 (_vala_sh_sync);
		}
		if (sh_finish) {
			*sh_finish = _vala_sh_finish;
		} else {
			_g_free0 (_vala_sh_finish);
		}
		return;
	}
	_tmp62_ = sh;
	_tmp63_ = g_strconcat (_tmp62_, "sync \n", NULL);
	_g_free0 (sh);
	sh = _tmp63_;
	tee_jee_logging_log_debug ("rsync script:");
	_tmp64_ = sh;
	tee_jee_logging_log_debug (_tmp64_);
	_tmp65_ = sh;
	_tmp66_ = g_strdup (_tmp65_);
	_g_free0 (_vala_sh_sync);
	_vala_sh_sync = _tmp66_;
	_tmp67_ = bool_to_string (self->reinstall_grub2);
	_tmp68_ = _tmp67_;
	_tmp69_ = g_strdup_printf ("reinstall_grub2=%s", _tmp68_);
	_tmp70_ = _tmp69_;
	tee_jee_logging_log_debug (_tmp70_);
	_g_free0 (_tmp70_);
	_g_free0 (_tmp68_);
	_tmp72_ = self->grub_device;
	if (_tmp72_ == NULL) {
		_tmp71_ = "null";
	} else {
		const gchar* _tmp73_;
		_tmp73_ = self->grub_device;
		_tmp71_ = _tmp73_;
	}
	_tmp74_ = g_strdup_printf ("grub_device=%s", _tmp71_);
	_tmp75_ = _tmp74_;
	tee_jee_logging_log_debug (_tmp75_);
	_g_free0 (_tmp75_);
	_tmp76_ = main_get_restore_target_path (self);
	_tmp77_ = _tmp76_;
	_tmp78_ = _tmp77_;
	_tmp79_ = linux_distro_get_dist_info (_tmp78_);
	_tmp80_ = _tmp79_;
	_g_free0 (_tmp78_);
	target_distro = _tmp80_;
	_tmp81_ = g_strdup ("");
	_g_free0 (sh);
	sh = _tmp81_;
	_tmp82_ = g_strdup ("");
	chroot = _tmp82_;
	_tmp83_ = main_get_restore_current_system (self);
	_tmp84_ = _tmp83_;
	if (!_tmp84_) {
		const gchar* _tmp85_;
		gchar* _tmp86_;
		gchar* _tmp87_;
		gchar* _tmp88_;
		gchar* _tmp89_;
		gchar* _tmp90_;
		gchar* _tmp91_;
		const gchar* _tmp92_;
		gchar* _tmp93_;
		gchar* _tmp94_;
		gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		_tmp85_ = chroot;
		_tmp86_ = main_get_restore_target_path (self);
		_tmp87_ = _tmp86_;
		_tmp88_ = _tmp87_;
		_tmp89_ = g_strdup_printf ("chroot \"%s\"", _tmp88_);
		_tmp90_ = _tmp89_;
		_tmp91_ = g_strconcat (_tmp85_, _tmp90_, NULL);
		_g_free0 (chroot);
		chroot = _tmp91_;
		_g_free0 (_tmp90_);
		_g_free0 (_tmp88_);
		_tmp92_ = sh;
		_tmp93_ = main_get_restore_target_path (self);
		_tmp94_ = _tmp93_;
		_tmp95_ = _tmp94_;
		_tmp96_ = g_strdup_printf ("for i in dev dev/pts proc run sys; do mount --bind \"/$i\" \"%s$i\"; d" \
"one \n", _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strconcat (_tmp92_, _tmp97_, NULL);
		_g_free0 (sh);
		sh = _tmp98_;
		_g_free0 (_tmp97_);
		_g_free0 (_tmp95_);
	}
	if (self->reinstall_grub2) {
		const gchar* _tmp101_;
		_tmp101_ = self->grub_device;
		_tmp100_ = _tmp101_ != NULL;
	} else {
		_tmp100_ = FALSE;
	}
	if (_tmp100_) {
		const gchar* _tmp102_;
		gint _tmp103_;
		gint _tmp104_;
		_tmp102_ = self->grub_device;
		_tmp103_ = strlen (_tmp102_);
		_tmp104_ = _tmp103_;
		_tmp99_ = _tmp104_ > 0;
	} else {
		_tmp99_ = FALSE;
	}
	if (_tmp99_) {
		const gchar* _tmp105_;
		gchar* _tmp106_;
		const gchar* _tmp107_;
		gchar* _tmp108_;
		const gchar* _tmp109_;
		gchar* _tmp110_;
		gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
		gchar* _tmp114_;
		LinuxDistro* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		gchar* _tmp118_;
		gboolean _tmp119_;
		_tmp105_ = sh;
		_tmp106_ = g_strconcat (_tmp105_, "sync \n", NULL);
		_g_free0 (sh);
		sh = _tmp106_;
		_tmp107_ = sh;
		_tmp108_ = g_strconcat (_tmp107_, "echo '' \n", NULL);
		_g_free0 (sh);
		sh = _tmp108_;
		_tmp109_ = sh;
		_tmp110_ = g_strconcat ("echo '", _ ("Re-installing GRUB2 bootloader..."), NULL);
		_tmp111_ = _tmp110_;
		_tmp112_ = g_strconcat (_tmp111_, "' \n", NULL);
		_tmp113_ = _tmp112_;
		_tmp114_ = g_strconcat (_tmp109_, _tmp113_, NULL);
		_g_free0 (sh);
		sh = _tmp114_;
		_g_free0 (_tmp113_);
		_g_free0 (_tmp111_);
		_tmp115_ = target_distro;
		_tmp116_ = linux_distro_get_dist_type (_tmp115_);
		_tmp117_ = _tmp116_;
		_tmp118_ = _tmp117_;
		_tmp119_ = g_strcmp0 (_tmp118_, "redhat") == 0;
		_g_free0 (_tmp118_);
		if (_tmp119_) {
			const gchar* _tmp120_;
			const gchar* _tmp121_;
			const gchar* _tmp122_;
			gchar* _tmp123_;
			gchar* _tmp124_;
			gchar* _tmp125_;
			_tmp120_ = sh;
			_tmp121_ = chroot;
			_tmp122_ = self->grub_device;
			_tmp123_ = g_strdup_printf ("%s grub2-install --recheck --force %s \n", _tmp121_, _tmp122_);
			_tmp124_ = _tmp123_;
			_tmp125_ = g_strconcat (_tmp120_, _tmp124_, NULL);
			_g_free0 (sh);
			sh = _tmp125_;
			_g_free0 (_tmp124_);
		} else {
			const gchar* _tmp126_;
			const gchar* _tmp127_;
			const gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			gchar* _tmp131_;
			_tmp126_ = sh;
			_tmp127_ = chroot;
			_tmp128_ = self->grub_device;
			_tmp129_ = g_strdup_printf ("%s grub-install --recheck --force %s \n", _tmp127_, _tmp128_);
			_tmp130_ = _tmp129_;
			_tmp131_ = g_strconcat (_tmp126_, _tmp130_, NULL);
			_g_free0 (sh);
			sh = _tmp131_;
			_g_free0 (_tmp130_);
		}
	} else {
		const gchar* _tmp132_ = NULL;
		const gchar* _tmp133_;
		gchar* _tmp135_;
		gchar* _tmp136_;
		gchar* _tmp137_;
		gchar* _tmp138_;
		_tmp133_ = self->grub_device;
		if (_tmp133_ == NULL) {
			_tmp132_ = "null";
		} else {
			const gchar* _tmp134_;
			_tmp134_ = self->grub_device;
			_tmp132_ = _tmp134_;
		}
		_tmp135_ = bool_to_string (self->reinstall_grub2);
		_tmp136_ = _tmp135_;
		_tmp137_ = g_strdup_printf ("skipping sh_grub: reinstall_grub2=%s, grub_device=%s", _tmp136_, _tmp132_);
		_tmp138_ = _tmp137_;
		tee_jee_logging_log_debug (_tmp138_);
		_g_free0 (_tmp138_);
		_g_free0 (_tmp136_);
	}
	if (self->update_initramfs) {
		const gchar* _tmp139_;
		gchar* _tmp140_;
		const gchar* _tmp141_;
		gchar* _tmp142_;
		gchar* _tmp143_;
		gchar* _tmp144_;
		gchar* _tmp145_;
		gchar* _tmp146_;
		LinuxDistro* _tmp147_;
		gchar* _tmp148_;
		gchar* _tmp149_;
		gchar* _tmp150_;
		gboolean _tmp151_;
		_tmp139_ = sh;
		_tmp140_ = g_strconcat (_tmp139_, "echo '' \n", NULL);
		_g_free0 (sh);
		sh = _tmp140_;
		_tmp141_ = sh;
		_tmp142_ = g_strconcat ("echo '", _ ("Generating initramfs..."), NULL);
		_tmp143_ = _tmp142_;
		_tmp144_ = g_strconcat (_tmp143_, "' \n", NULL);
		_tmp145_ = _tmp144_;
		_tmp146_ = g_strconcat (_tmp141_, _tmp145_, NULL);
		_g_free0 (sh);
		sh = _tmp146_;
		_g_free0 (_tmp145_);
		_g_free0 (_tmp143_);
		_tmp147_ = target_distro;
		_tmp148_ = linux_distro_get_dist_type (_tmp147_);
		_tmp149_ = _tmp148_;
		_tmp150_ = _tmp149_;
		_tmp151_ = g_strcmp0 (_tmp150_, "redhat") == 0;
		_g_free0 (_tmp150_);
		if (_tmp151_) {
			const gchar* _tmp152_;
			const gchar* _tmp153_;
			gchar* _tmp154_;
			gchar* _tmp155_;
			gchar* _tmp156_;
			_tmp152_ = sh;
			_tmp153_ = chroot;
			_tmp154_ = g_strdup_printf ("%s dracut -f -v \n", _tmp153_);
			_tmp155_ = _tmp154_;
			_tmp156_ = g_strconcat (_tmp152_, _tmp155_, NULL);
			_g_free0 (sh);
			sh = _tmp156_;
			_g_free0 (_tmp155_);
		} else {
			LinuxDistro* _tmp157_;
			gchar* _tmp158_;
			gchar* _tmp159_;
			gchar* _tmp160_;
			gboolean _tmp161_;
			_tmp157_ = target_distro;
			_tmp158_ = linux_distro_get_dist_type (_tmp157_);
			_tmp159_ = _tmp158_;
			_tmp160_ = _tmp159_;
			_tmp161_ = g_strcmp0 (_tmp160_, "arch") == 0;
			_g_free0 (_tmp160_);
			if (_tmp161_) {
				const gchar* _tmp162_;
				const gchar* _tmp163_;
				gchar* _tmp164_;
				gchar* _tmp165_;
				gchar* _tmp166_;
				_tmp162_ = sh;
				_tmp163_ = chroot;
				_tmp164_ = g_strdup_printf ("%s mkinitcpio -p /etc/mkinitcpio.d/*.preset\n", _tmp163_);
				_tmp165_ = _tmp164_;
				_tmp166_ = g_strconcat (_tmp162_, _tmp165_, NULL);
				_g_free0 (sh);
				sh = _tmp166_;
				_g_free0 (_tmp165_);
			} else {
				const gchar* _tmp167_;
				const gchar* _tmp168_;
				gchar* _tmp169_;
				gchar* _tmp170_;
				gchar* _tmp171_;
				_tmp167_ = sh;
				_tmp168_ = chroot;
				_tmp169_ = g_strdup_printf ("%s update-initramfs -u -k all \n", _tmp168_);
				_tmp170_ = _tmp169_;
				_tmp171_ = g_strconcat (_tmp167_, _tmp170_, NULL);
				_g_free0 (sh);
				sh = _tmp171_;
				_g_free0 (_tmp170_);
			}
		}
	}
	if (self->update_grub) {
		const gchar* _tmp172_;
		gchar* _tmp173_;
		const gchar* _tmp174_;
		gchar* _tmp175_;
		gchar* _tmp176_;
		gchar* _tmp177_;
		gchar* _tmp178_;
		gchar* _tmp179_;
		LinuxDistro* _tmp180_;
		gchar* _tmp181_;
		gchar* _tmp182_;
		gchar* _tmp183_;
		gboolean _tmp184_;
		LinuxDistro* _tmp190_;
		gchar* _tmp191_;
		gchar* _tmp192_;
		gchar* _tmp193_;
		gboolean _tmp194_;
		const gchar* _tmp205_;
		gchar* _tmp206_;
		const gchar* _tmp207_;
		gchar* _tmp208_;
		_tmp172_ = sh;
		_tmp173_ = g_strconcat (_tmp172_, "echo '' \n", NULL);
		_g_free0 (sh);
		sh = _tmp173_;
		_tmp174_ = sh;
		_tmp175_ = g_strconcat ("echo '", _ ("Updating GRUB menu..."), NULL);
		_tmp176_ = _tmp175_;
		_tmp177_ = g_strconcat (_tmp176_, "' \n", NULL);
		_tmp178_ = _tmp177_;
		_tmp179_ = g_strconcat (_tmp174_, _tmp178_, NULL);
		_g_free0 (sh);
		sh = _tmp179_;
		_g_free0 (_tmp178_);
		_g_free0 (_tmp176_);
		_tmp180_ = target_distro;
		_tmp181_ = linux_distro_get_dist_type (_tmp180_);
		_tmp182_ = _tmp181_;
		_tmp183_ = _tmp182_;
		_tmp184_ = g_strcmp0 (_tmp183_, "redhat") == 0;
		_g_free0 (_tmp183_);
		if (_tmp184_) {
			const gchar* _tmp185_;
			const gchar* _tmp186_;
			gchar* _tmp187_;
			gchar* _tmp188_;
			gchar* _tmp189_;
			_tmp185_ = sh;
			_tmp186_ = chroot;
			_tmp187_ = g_strdup_printf ("%s grub2-mkconfig -o /boot/grub2/grub.cfg \n", _tmp186_);
			_tmp188_ = _tmp187_;
			_tmp189_ = g_strconcat (_tmp185_, _tmp188_, NULL);
			_g_free0 (sh);
			sh = _tmp189_;
			_g_free0 (_tmp188_);
		}
		_tmp190_ = target_distro;
		_tmp191_ = linux_distro_get_dist_type (_tmp190_);
		_tmp192_ = _tmp191_;
		_tmp193_ = _tmp192_;
		_tmp194_ = g_strcmp0 (_tmp193_, "arch") == 0;
		_g_free0 (_tmp193_);
		if (_tmp194_) {
			const gchar* _tmp195_;
			const gchar* _tmp196_;
			gchar* _tmp197_;
			gchar* _tmp198_;
			gchar* _tmp199_;
			_tmp195_ = sh;
			_tmp196_ = chroot;
			_tmp197_ = g_strdup_printf ("%s grub-mkconfig -o /boot/grub/grub.cfg \n", _tmp196_);
			_tmp198_ = _tmp197_;
			_tmp199_ = g_strconcat (_tmp195_, _tmp198_, NULL);
			_g_free0 (sh);
			sh = _tmp199_;
			_g_free0 (_tmp198_);
		} else {
			const gchar* _tmp200_;
			const gchar* _tmp201_;
			gchar* _tmp202_;
			gchar* _tmp203_;
			gchar* _tmp204_;
			_tmp200_ = sh;
			_tmp201_ = chroot;
			_tmp202_ = g_strdup_printf ("%s update-grub \n", _tmp201_);
			_tmp203_ = _tmp202_;
			_tmp204_ = g_strconcat (_tmp200_, _tmp203_, NULL);
			_g_free0 (sh);
			sh = _tmp204_;
			_g_free0 (_tmp203_);
		}
		_tmp205_ = sh;
		_tmp206_ = g_strconcat (_tmp205_, "sync \n", NULL);
		_g_free0 (sh);
		sh = _tmp206_;
		_tmp207_ = sh;
		_tmp208_ = g_strconcat (_tmp207_, "echo '' \n", NULL);
		_g_free0 (sh);
		sh = _tmp208_;
	}
	_tmp209_ = sh;
	_tmp210_ = g_strconcat ("echo '", _ ("Syncing file systems..."), NULL);
	_tmp211_ = _tmp210_;
	_tmp212_ = g_strconcat (_tmp211_, "' \n", NULL);
	_tmp213_ = _tmp212_;
	_tmp214_ = g_strconcat (_tmp209_, _tmp213_, NULL);
	_g_free0 (sh);
	sh = _tmp214_;
	_g_free0 (_tmp213_);
	_g_free0 (_tmp211_);
	_tmp215_ = sh;
	_tmp216_ = g_strconcat (_tmp215_, "sync ; sleep 10s; \n", NULL);
	_g_free0 (sh);
	sh = _tmp216_;
	_tmp217_ = sh;
	_tmp218_ = g_strconcat (_tmp217_, "echo '' \n", NULL);
	_g_free0 (sh);
	sh = _tmp218_;
	_tmp219_ = main_get_restore_current_system (self);
	_tmp220_ = _tmp219_;
	if (!_tmp220_) {
		const gchar* _tmp221_;
		gchar* _tmp222_;
		gchar* _tmp223_;
		gchar* _tmp224_;
		gchar* _tmp225_;
		gchar* _tmp226_;
		const gchar* _tmp227_;
		gchar* _tmp228_;
		gchar* _tmp229_;
		gchar* _tmp230_;
		gchar* _tmp231_;
		gchar* _tmp232_;
		gchar* _tmp233_;
		const gchar* _tmp234_;
		gchar* _tmp235_;
		_tmp221_ = sh;
		_tmp222_ = g_strconcat ("echo '", _ ("Cleaning up..."), NULL);
		_tmp223_ = _tmp222_;
		_tmp224_ = g_strconcat (_tmp223_, "' \n", NULL);
		_tmp225_ = _tmp224_;
		_tmp226_ = g_strconcat (_tmp221_, _tmp225_, NULL);
		_g_free0 (sh);
		sh = _tmp226_;
		_g_free0 (_tmp225_);
		_g_free0 (_tmp223_);
		_tmp227_ = sh;
		_tmp228_ = main_get_restore_target_path (self);
		_tmp229_ = _tmp228_;
		_tmp230_ = _tmp229_;
		_tmp231_ = g_strdup_printf ("for i in dev/pts dev proc run sys; do umount -f \"%s$i\"; done \n", _tmp230_);
		_tmp232_ = _tmp231_;
		_tmp233_ = g_strconcat (_tmp227_, _tmp232_, NULL);
		_g_free0 (sh);
		sh = _tmp233_;
		_g_free0 (_tmp232_);
		_g_free0 (_tmp230_);
		_tmp234_ = sh;
		_tmp235_ = g_strconcat (_tmp234_, "sync \n", NULL);
		_g_free0 (sh);
		sh = _tmp235_;
	}
	tee_jee_logging_log_debug ("GRUB2 install script:");
	_tmp236_ = sh;
	tee_jee_logging_log_debug (_tmp236_);
	tee_jee_logging_log_debug ("Running post-restore tasks...");
	_tmp237_ = sh;
	_tmp238_ = g_strconcat (_tmp237_, "if [ -d \"/etc/timeshift/restore-hooks.d\" ]; then \n", NULL);
	_g_free0 (sh);
	sh = _tmp238_;
	_tmp239_ = sh;
	_tmp240_ = g_strconcat (_tmp239_, "  run-parts --verbose /etc/timeshift/restore-hooks.d \n", NULL);
	_g_free0 (sh);
	sh = _tmp240_;
	_tmp241_ = sh;
	_tmp242_ = g_strconcat (_tmp241_, "fi \n", NULL);
	_g_free0 (sh);
	sh = _tmp242_;
	_tmp243_ = main_get_restore_current_system (self);
	_tmp244_ = _tmp243_;
	if (_tmp244_) {
		const gchar* _tmp245_;
		gchar* _tmp246_;
		const gchar* _tmp247_;
		gchar* _tmp248_;
		gchar* _tmp249_;
		gchar* _tmp250_;
		gchar* _tmp251_;
		gchar* _tmp252_;
		const gchar* _tmp253_;
		gchar* _tmp254_;
		const gchar* _tmp255_;
		gchar* _tmp256_;
		_tmp245_ = sh;
		_tmp246_ = g_strconcat (_tmp245_, "echo '' \n", NULL);
		_g_free0 (sh);
		sh = _tmp246_;
		_tmp247_ = sh;
		_tmp248_ = g_strconcat ("echo '", _ ("Rebooting system..."), NULL);
		_tmp249_ = _tmp248_;
		_tmp250_ = g_strconcat (_tmp249_, "' \n", NULL);
		_tmp251_ = _tmp250_;
		_tmp252_ = g_strconcat (_tmp247_, _tmp251_, NULL);
		_g_free0 (sh);
		sh = _tmp252_;
		_g_free0 (_tmp251_);
		_g_free0 (_tmp249_);
		_tmp253_ = sh;
		_tmp254_ = g_strconcat (_tmp253_, "sleep 5s \n", NULL);
		_g_free0 (sh);
		sh = _tmp254_;
		_tmp255_ = sh;
		_tmp256_ = g_strconcat (_tmp255_, "reboot -f \n", NULL);
		_g_free0 (sh);
		sh = _tmp256_;
	}
	_tmp257_ = sh;
	_tmp258_ = g_strdup (_tmp257_);
	_g_free0 (_vala_sh_finish);
	_vala_sh_finish = _tmp258_;
	_g_free0 (chroot);
	_g_object_unref0 (target_distro);
	_g_free0 (sh);
	if (sh_sync) {
		*sh_sync = _vala_sh_sync;
	} else {
		_g_free0 (_vala_sh_sync);
	}
	if (sh_finish) {
		*sh_finish = _vala_sh_finish;
	} else {
		_g_free0 (_vala_sh_finish);
	}
}

static gboolean
main_restore_current_console (Main* self,
                              const gchar* sh_sync,
                              const gchar* sh_finish)
{
	gchar* script = NULL;
	gchar* _tmp0_;
	gint ret_val = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sh_sync != NULL, FALSE);
	g_return_val_if_fail (sh_finish != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_current_console()");
	_tmp0_ = g_strconcat (sh_sync, sh_finish, NULL);
	script = _tmp0_;
	ret_val = -1;
	if (self->cmd_verbose) {
		const gchar* _tmp1_;
		_tmp1_ = script;
		ret_val = tee_jee_process_helper_exec_script_sync (_tmp1_, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
		tee_jee_logging_log_msg ("", FALSE);
	} else {
		gchar* std_out = NULL;
		gchar* std_err = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = script;
		_tmp5_ = tee_jee_process_helper_exec_script_sync (_tmp2_, &_tmp3_, &_tmp4_, FALSE, FALSE, TRUE, FALSE);
		_g_free0 (std_out);
		std_out = _tmp3_;
		_g_free0 (std_err);
		std_err = _tmp4_;
		ret_val = _tmp5_;
		_tmp6_ = std_out;
		tee_jee_logging_log_to_file (_tmp6_, FALSE);
		_tmp7_ = std_err;
		tee_jee_logging_log_to_file (_tmp7_, FALSE);
		_g_free0 (std_err);
		_g_free0 (std_out);
	}
	result = ret_val == 0;
	_g_free0 (script);
	return result;
}

static gboolean
main_restore_current_gui (Main* self,
                          const gchar* sh_sync,
                          const gchar* sh_finish)
{
	gchar* script = NULL;
	gchar* _tmp0_;
	gchar* temp_script = NULL;
	gchar* _tmp1_;
	TerminalWindow* dlg = NULL;
	GtkWindow* _tmp2_;
	TerminalWindow* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sh_sync != NULL, FALSE);
	g_return_val_if_fail (sh_finish != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_current_gui()");
	_tmp0_ = g_strconcat (sh_sync, sh_finish, NULL);
	script = _tmp0_;
	_tmp1_ = tee_jee_process_helper_save_bash_script_temp (script, NULL, TRUE, FALSE);
	temp_script = _tmp1_;
	_tmp2_ = self->parent_window;
	_tmp3_ = terminal_window_new_with_parent (_tmp2_);
	g_object_ref_sink (_tmp3_);
	dlg = _tmp3_;
	terminal_window_execute_script (dlg, temp_script, TRUE);
	result = TRUE;
	_g_object_unref0 (dlg);
	_g_free0 (temp_script);
	_g_free0 (script);
	return result;
}

static gboolean
main_restore_other_console (Main* self,
                            const gchar* sh_sync,
                            const gchar* sh_finish)
{
	gchar* script = NULL;
	gchar* _tmp0_;
	gint ret_val = 0;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	RsyncTask* task = NULL;
	RsyncTask* _tmp16_;
	RsyncTask* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GeeArrayList* _tmp21_;
	GeeArrayList* _tmp22_;
	gchar* _tmp23_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sh_sync != NULL, FALSE);
	g_return_val_if_fail (sh_finish != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_other_console()");
	_tmp0_ = g_strdup (sh_sync);
	script = _tmp0_;
	ret_val = -1;
	if (self->cmd_verbose) {
		const gchar* _tmp1_;
		_tmp1_ = script;
		ret_val = tee_jee_process_helper_exec_script_sync (_tmp1_, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
		tee_jee_logging_log_msg ("", FALSE);
	} else {
		gchar* std_out = NULL;
		gchar* std_err = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_ = NULL;
		gint _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp2_ = script;
		_tmp5_ = tee_jee_process_helper_exec_script_sync (_tmp2_, &_tmp3_, &_tmp4_, FALSE, FALSE, TRUE, FALSE);
		_g_free0 (std_out);
		std_out = _tmp3_;
		_g_free0 (std_err);
		std_err = _tmp4_;
		ret_val = _tmp5_;
		_tmp6_ = std_out;
		tee_jee_logging_log_to_file (_tmp6_, FALSE);
		_tmp7_ = std_err;
		tee_jee_logging_log_to_file (_tmp7_, FALSE);
		_g_free0 (std_err);
		_g_free0 (std_out);
	}
	_tmp8_ = main_get_restore_target_path (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = _tmp9_;
	main_fix_fstab_file (self, _tmp10_);
	_g_free0 (_tmp10_);
	_tmp11_ = main_get_restore_target_path (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = _tmp12_;
	main_fix_crypttab_file (self, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp14_ = g_strdup (_ ("Parsing log file..."));
	_g_free0 (self->progress_text);
	self->progress_text = _tmp14_;
	_tmp15_ = self->progress_text;
	tee_jee_logging_log_msg (_tmp15_, FALSE);
	_tmp16_ = rsync_task_new ();
	task = _tmp16_;
	_tmp17_ = task;
	_tmp18_ = main_get_restore_log_file (self);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp21_ = rsync_task_parse_log (_tmp17_, _tmp20_);
	_tmp22_ = _tmp21_;
	_g_object_unref0 (_tmp22_);
	_g_free0 (_tmp20_);
	tee_jee_logging_log_debug ("executing sh_finish: ");
	tee_jee_logging_log_debug (sh_finish);
	_tmp23_ = g_strdup (sh_finish);
	_g_free0 (script);
	script = _tmp23_;
	if (self->cmd_verbose) {
		const gchar* _tmp24_;
		_tmp24_ = script;
		ret_val = tee_jee_process_helper_exec_script_sync (_tmp24_, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
		tee_jee_logging_log_msg ("", FALSE);
	} else {
		gchar* std_out = NULL;
		gchar* std_err = NULL;
		const gchar* _tmp25_;
		gchar* _tmp26_ = NULL;
		gchar* _tmp27_ = NULL;
		gint _tmp28_;
		const gchar* _tmp29_;
		const gchar* _tmp30_;
		_tmp25_ = script;
		_tmp28_ = tee_jee_process_helper_exec_script_sync (_tmp25_, &_tmp26_, &_tmp27_, FALSE, FALSE, TRUE, FALSE);
		_g_free0 (std_out);
		std_out = _tmp26_;
		_g_free0 (std_err);
		std_err = _tmp27_;
		ret_val = _tmp28_;
		_tmp29_ = std_out;
		tee_jee_logging_log_to_file (_tmp29_, FALSE);
		_tmp30_ = std_err;
		tee_jee_logging_log_to_file (_tmp30_, FALSE);
		_g_free0 (std_err);
		_g_free0 (std_out);
	}
	result = ret_val == 0;
	_g_object_unref0 (task);
	_g_free0 (script);
	return result;
}

static gboolean
main_restore_other_gui (Main* self,
                        const gchar* sh_sync,
                        const gchar* sh_finish)
{
	gchar* _tmp0_;
	RsyncTask* _tmp1_;
	RsyncTask* _tmp2_;
	RsyncTask* _tmp3_;
	RsyncTask* _tmp4_;
	RsyncTask* _tmp5_;
	RsyncTask* _tmp6_;
	RsyncTask* _tmp7_;
	RsyncTask* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	RsyncTask* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	RsyncTask* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gboolean _tmp23_ = FALSE;
	Snapshot* _tmp24_;
	RsyncTask* _tmp30_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	const gchar* _tmp48_;
	RsyncTask* task = NULL;
	RsyncTask* _tmp49_;
	RsyncTask* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GeeArrayList* _tmp54_;
	GeeArrayList* _tmp55_;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	gint ret_val = 0;
	gchar* _tmp59_;
	gchar* _tmp60_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sh_sync != NULL, FALSE);
	g_return_val_if_fail (sh_finish != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_other_gui()");
	_tmp0_ = g_strdup (_ ("Building file list..."));
	_g_free0 (self->progress_text);
	self->progress_text = _tmp0_;
	_tmp1_ = rsync_task_new ();
	_g_object_unref0 (self->task);
	self->task = _tmp1_;
	_tmp2_ = self->task;
	_tmp2_->relative = FALSE;
	_tmp3_ = self->task;
	_tmp3_->verbose = TRUE;
	_tmp4_ = self->task;
	_tmp4_->delete_extra = TRUE;
	_tmp5_ = self->task;
	_tmp5_->delete_excluded = FALSE;
	_tmp6_ = self->task;
	_tmp6_->delete_after = TRUE;
	_tmp7_ = self->task;
	_tmp7_->dry_run = self->dry_run;
	if (self->mirror_system) {
		RsyncTask* _tmp8_;
		gchar* _tmp9_;
		_tmp8_ = self->task;
		_tmp9_ = g_strdup ("/");
		_g_free0 (_tmp8_->source_path);
		_tmp8_->source_path = _tmp9_;
	} else {
		RsyncTask* _tmp10_;
		Snapshot* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp10_ = self->task;
		_tmp11_ = self->snapshot_to_restore;
		_tmp12_ = _tmp11_->path;
		_tmp13_ = tee_jee_file_system_path_combine (_tmp12_, "localhost");
		_g_free0 (_tmp10_->source_path);
		_tmp10_->source_path = _tmp13_;
	}
	_tmp14_ = self->task;
	_tmp15_ = main_get_restore_target_path (self);
	_tmp16_ = _tmp15_;
	_g_free0 (_tmp14_->dest_path);
	_tmp14_->dest_path = _tmp16_;
	_tmp17_ = self->task;
	_tmp18_ = main_get_restore_exclude_file (self);
	_tmp19_ = _tmp18_;
	_g_free0 (_tmp17_->exclude_from_file);
	_tmp17_->exclude_from_file = _tmp19_;
	_tmp20_ = self->task;
	_tmp21_ = main_get_restore_log_file (self);
	_tmp22_ = _tmp21_;
	_g_free0 (_tmp20_->rsync_log_file);
	_tmp20_->rsync_log_file = _tmp22_;
	_tmp24_ = self->snapshot_to_restore;
	if (_tmp24_ != NULL) {
		Snapshot* _tmp25_;
		_tmp25_ = self->snapshot_to_restore;
		_tmp23_ = _tmp25_->file_count > ((gint64) 0);
	} else {
		_tmp23_ = FALSE;
	}
	if (_tmp23_) {
		RsyncTask* _tmp26_;
		Snapshot* _tmp27_;
		_tmp26_ = self->task;
		_tmp27_ = self->snapshot_to_restore;
		((AsyncTask*) _tmp26_)->prg_count_total = _tmp27_->file_count;
	} else {
		if (main_first_snapshot_count > ((gint64) 0)) {
			RsyncTask* _tmp28_;
			_tmp28_ = self->task;
			((AsyncTask*) _tmp28_)->prg_count_total = main_first_snapshot_count;
		} else {
			RsyncTask* _tmp29_;
			_tmp29_ = self->task;
			((AsyncTask*) _tmp29_)->prg_count_total = (gint64) 500000;
		}
	}
	_tmp30_ = self->task;
	async_task_execute ((AsyncTask*) _tmp30_);
	while (TRUE) {
		RsyncTask* _tmp31_;
		RsyncTask* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gint _tmp36_;
		gint _tmp37_;
		gboolean _tmp38_;
		_tmp31_ = self->task;
		if (!(((AsyncTask*) _tmp31_)->status == APP_STATUS_RUNNING)) {
			break;
		}
		tee_jee_system_sleep (1000);
		_tmp32_ = self->task;
		_tmp33_ = async_task_get_status_line ((AsyncTask*) _tmp32_);
		_tmp34_ = _tmp33_;
		_tmp35_ = _tmp34_;
		_tmp36_ = strlen (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = _tmp37_ > 0;
		_g_free0 (_tmp35_);
		if (_tmp38_) {
			if (self->dry_run) {
				gchar* _tmp39_;
				_tmp39_ = g_strdup (_ ("Comparing files with rsync..."));
				_g_free0 (self->progress_text);
				self->progress_text = _tmp39_;
			} else {
				gchar* _tmp40_;
				_tmp40_ = g_strdup (_ ("Syncing files with rsync..."));
				_g_free0 (self->progress_text);
				self->progress_text = _tmp40_;
			}
		}
		tee_jee_gtk_helper_gtk_do_events ();
	}
	if (self->dry_run) {
		result = TRUE;
		return result;
	}
	_tmp41_ = main_get_restore_target_path (self);
	_tmp42_ = _tmp41_;
	_tmp43_ = _tmp42_;
	main_fix_fstab_file (self, _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = main_get_restore_target_path (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_;
	main_fix_crypttab_file (self, _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = g_strdup (_ ("Parsing log file..."));
	_g_free0 (self->progress_text);
	self->progress_text = _tmp47_;
	_tmp48_ = self->progress_text;
	tee_jee_logging_log_msg (_tmp48_, FALSE);
	_tmp49_ = rsync_task_new ();
	task = _tmp49_;
	_tmp50_ = task;
	_tmp51_ = main_get_restore_log_file (self);
	_tmp52_ = _tmp51_;
	_tmp53_ = _tmp52_;
	_tmp54_ = rsync_task_parse_log (_tmp50_, _tmp53_);
	_tmp55_ = _tmp54_;
	_g_object_unref0 (_tmp55_);
	_g_free0 (_tmp53_);
	if (self->reinstall_grub2) {
		_tmp57_ = TRUE;
	} else {
		_tmp57_ = self->update_initramfs;
	}
	if (_tmp57_) {
		_tmp56_ = TRUE;
	} else {
		_tmp56_ = self->update_grub;
	}
	if (_tmp56_) {
		gchar* _tmp58_;
		_tmp58_ = g_strdup (_ ("Updating bootloader configuration..."));
		_g_free0 (self->progress_text);
		self->progress_text = _tmp58_;
	}
	tee_jee_logging_log_debug ("executing sh_finish: ");
	tee_jee_logging_log_debug (sh_finish);
	ret_val = tee_jee_process_helper_exec_script_sync (sh_finish, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
	_tmp59_ = g_strdup_printf ("script exit code: %d", ret_val);
	_tmp60_ = _tmp59_;
	tee_jee_logging_log_debug (_tmp60_);
	_g_free0 (_tmp60_);
	result = ret_val == 0;
	_g_object_unref0 (task);
	return result;
}

static void
main_fix_fstab_file (Main* self,
                     const gchar* target_path)
{
	gchar* fstab_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeArrayList* fstab_list = NULL;
	const gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp61_;
	const gchar* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_path != NULL);
	tee_jee_logging_log_debug ("Main: fix_fstab_file()");
	_tmp0_ = tee_jee_file_system_path_combine (target_path, "etc/fstab");
	fstab_path = _tmp0_;
	_tmp1_ = fstab_path;
	if (!tee_jee_file_system_file_exists (_tmp1_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = fstab_path;
		_tmp3_ = g_strdup_printf ("File not found: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		tee_jee_logging_log_debug (_tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (fstab_path);
		return;
	}
	_tmp5_ = fstab_path;
	_tmp6_ = fs_tab_entry_read_file (_tmp5_);
	fstab_list = _tmp6_;
	tee_jee_logging_log_debug ("updating entries (1/2)...");
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp7_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _mnt_index = 0;
		_tmp7_ = self->mount_list;
		_mnt_list = _tmp7_;
		_tmp8_ = _mnt_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_mnt_size = _tmp10_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			FsTabEntry* entry = NULL;
			GeeArrayList* _tmp15_;
			MountEntry* _tmp16_;
			const gchar* _tmp17_;
			FsTabEntry* _tmp18_;
			FsTabEntry* _tmp19_;
			FsTabEntry* _tmp27_;
			MountEntry* _tmp28_;
			Device* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			FsTabEntry* _tmp32_;
			MountEntry* _tmp33_;
			Device* _tmp34_;
			const gchar* _tmp35_;
			gchar* _tmp36_;
			MountEntry* _tmp37_;
			Device* _tmp38_;
			const gchar* _tmp39_;
			_mnt_index = _mnt_index + 1;
			_tmp11_ = _mnt_index;
			_tmp12_ = _mnt_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _mnt_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _mnt_index);
			mnt = (MountEntry*) _tmp14_;
			_tmp15_ = fstab_list;
			_tmp16_ = mnt;
			_tmp17_ = _tmp16_->mount_point;
			_tmp18_ = fs_tab_entry_find_entry_by_mount_point (_tmp15_, _tmp17_);
			entry = _tmp18_;
			_tmp19_ = entry;
			if (_tmp19_ == NULL) {
				FsTabEntry* _tmp20_;
				FsTabEntry* _tmp21_;
				MountEntry* _tmp22_;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				GeeArrayList* _tmp25_;
				FsTabEntry* _tmp26_;
				_tmp20_ = fs_tab_entry_new ();
				_g_object_unref0 (entry);
				entry = _tmp20_;
				_tmp21_ = entry;
				_tmp22_ = mnt;
				_tmp23_ = _tmp22_->mount_point;
				_tmp24_ = g_strdup (_tmp23_);
				_g_free0 (_tmp21_->mount_point);
				_tmp21_->mount_point = _tmp24_;
				_tmp25_ = fstab_list;
				_tmp26_ = entry;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, _tmp26_);
			}
			_tmp27_ = entry;
			_tmp28_ = mnt;
			_tmp29_ = _tmp28_->device;
			_tmp30_ = _tmp29_->uuid;
			_tmp31_ = g_strdup_printf ("UUID=%s", _tmp30_);
			_g_free0 (_tmp27_->device_string);
			_tmp27_->device_string = _tmp31_;
			_tmp32_ = entry;
			_tmp33_ = mnt;
			_tmp34_ = _tmp33_->device;
			_tmp35_ = _tmp34_->fstype;
			_tmp36_ = g_strdup (_tmp35_);
			_g_free0 (_tmp32_->type);
			_tmp32_->type = _tmp36_;
			_tmp37_ = mnt;
			_tmp38_ = _tmp37_->device;
			_tmp39_ = _tmp38_->fstype;
			if (g_strcmp0 (_tmp39_, "btrfs") != 0) {
				FsTabEntry* _tmp40_;
				FsTabEntry* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				gchar* _tmp45_;
				_tmp40_ = entry;
				_tmp41_ = entry;
				_tmp42_ = fs_tab_entry_subvolume_name (_tmp41_);
				_tmp43_ = _tmp42_;
				_tmp44_ = g_strdup_printf ("subvol=%s", _tmp43_);
				_tmp45_ = _tmp44_;
				fs_tab_entry_remove_option (_tmp40_, _tmp45_);
				_g_free0 (_tmp45_);
				_g_free0 (_tmp43_);
			}
			_g_object_unref0 (entry);
			_g_object_unref0 (mnt);
		}
	}
	tee_jee_logging_log_debug ("updating entries(2/2)...");
	{
		gint i = 0;
		GeeArrayList* _tmp46_;
		gint _tmp47_;
		gint _tmp48_;
		_tmp46_ = fstab_list;
		_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
		_tmp48_ = _tmp47_;
		i = _tmp48_ - 1;
		{
			gboolean _tmp49_ = FALSE;
			_tmp49_ = TRUE;
			while (TRUE) {
				FsTabEntry* entry = NULL;
				GeeArrayList* _tmp51_;
				gpointer _tmp52_;
				FsTabEntry* _tmp53_;
				MountEntry* mnt = NULL;
				GeeArrayList* _tmp54_;
				FsTabEntry* _tmp55_;
				const gchar* _tmp56_;
				MountEntry* _tmp57_;
				MountEntry* _tmp58_;
				if (!_tmp49_) {
					gint _tmp50_;
					_tmp50_ = i;
					i = _tmp50_ - 1;
				}
				_tmp49_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp51_ = fstab_list;
				_tmp52_ = gee_abstract_list_get ((GeeAbstractList*) _tmp51_, i);
				entry = (FsTabEntry*) _tmp52_;
				_tmp53_ = entry;
				if (!fs_tab_entry_is_for_system_directory (_tmp53_)) {
					_g_object_unref0 (entry);
					continue;
				}
				_tmp54_ = self->mount_list;
				_tmp55_ = entry;
				_tmp56_ = _tmp55_->mount_point;
				_tmp57_ = mount_entry_find_entry_by_mount_point (_tmp54_, _tmp56_);
				mnt = _tmp57_;
				_tmp58_ = mnt;
				if (_tmp58_ == NULL) {
					GeeArrayList* _tmp59_;
					FsTabEntry* _tmp60_;
					_tmp59_ = fstab_list;
					_tmp60_ = entry;
					gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp59_, _tmp60_);
				}
				_g_object_unref0 (mnt);
				_g_object_unref0 (entry);
			}
		}
	}
	tee_jee_logging_log_debug ("writing updated file...");
	_tmp61_ = fstab_list;
	_tmp62_ = fstab_path;
	_tmp63_ = fs_tab_entry_write_file (_tmp61_, _tmp62_, FALSE);
	_tmp64_ = _tmp63_;
	_g_free0 (_tmp64_);
	_tmp65_ = fstab_path;
	_tmp66_ = g_strdup_printf (": %s", _tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = g_strconcat (_ ("Updated /etc/fstab on target device"), _tmp67_, NULL);
	_tmp69_ = _tmp68_;
	tee_jee_logging_log_msg (_tmp69_, FALSE);
	_g_free0 (_tmp69_);
	_g_free0 (_tmp67_);
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp70_;
		gint _entry_size = 0;
		GeeArrayList* _tmp71_;
		gint _tmp72_;
		gint _tmp73_;
		gint _entry_index = 0;
		_tmp70_ = fstab_list;
		_entry_list = _tmp70_;
		_tmp71_ = _entry_list;
		_tmp72_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp71_);
		_tmp73_ = _tmp72_;
		_entry_size = _tmp73_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp74_;
			gint _tmp75_;
			FsTabEntry* entry = NULL;
			GeeArrayList* _tmp76_;
			gpointer _tmp77_;
			FsTabEntry* _tmp78_;
			const gchar* _tmp79_;
			gint _tmp80_;
			gint _tmp81_;
			FsTabEntry* _tmp82_;
			const gchar* _tmp83_;
			gchar* mount_path = NULL;
			FsTabEntry* _tmp84_;
			const gchar* _tmp85_;
			gchar* _tmp86_;
			gboolean _tmp87_ = FALSE;
			gboolean _tmp88_ = FALSE;
			FsTabEntry* _tmp89_;
			const gchar* _tmp94_;
			_entry_index = _entry_index + 1;
			_tmp74_ = _entry_index;
			_tmp75_ = _entry_size;
			if (!(_tmp74_ < _tmp75_)) {
				break;
			}
			_tmp76_ = _entry_list;
			_tmp77_ = gee_abstract_list_get ((GeeAbstractList*) _tmp76_, _entry_index);
			entry = (FsTabEntry*) _tmp77_;
			_tmp78_ = entry;
			_tmp79_ = _tmp78_->mount_point;
			_tmp80_ = strlen (_tmp79_);
			_tmp81_ = _tmp80_;
			if (_tmp81_ == 0) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp82_ = entry;
			_tmp83_ = _tmp82_->mount_point;
			if (!g_str_has_prefix (_tmp83_, "/")) {
				_g_object_unref0 (entry);
				continue;
			}
			_tmp84_ = entry;
			_tmp85_ = _tmp84_->mount_point;
			_tmp86_ = tee_jee_file_system_path_combine (target_path, _tmp85_);
			mount_path = _tmp86_;
			_tmp89_ = entry;
			if (_tmp89_->is_comment) {
				_tmp88_ = TRUE;
			} else {
				FsTabEntry* _tmp90_;
				_tmp90_ = entry;
				_tmp88_ = _tmp90_->is_empty_line;
			}
			if (_tmp88_) {
				_tmp87_ = TRUE;
			} else {
				const gchar* _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
				_tmp91_ = mount_path;
				_tmp92_ = strlen (_tmp91_);
				_tmp93_ = _tmp92_;
				_tmp87_ = _tmp93_ == 0;
			}
			if (_tmp87_) {
				_g_free0 (mount_path);
				_g_object_unref0 (entry);
				continue;
			}
			_tmp94_ = mount_path;
			if (!tee_jee_file_system_dir_exists (_tmp94_)) {
				FsTabEntry* _tmp95_;
				const gchar* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				const gchar* _tmp99_;
				_tmp95_ = entry;
				_tmp96_ = _tmp95_->mount_point;
				_tmp97_ = g_strdup_printf ("Created mount point on target device: %s", _tmp96_);
				_tmp98_ = _tmp97_;
				tee_jee_logging_log_msg (_tmp98_, FALSE);
				_g_free0 (_tmp98_);
				_tmp99_ = mount_path;
				tee_jee_file_system_dir_create (_tmp99_, FALSE);
			}
			_g_free0 (mount_path);
			_g_object_unref0 (entry);
		}
	}
	tee_jee_logging_log_debug ("Main: fix_fstab_file(): exit");
	_g_object_unref0 (fstab_list);
	_g_free0 (fstab_path);
}

static void
main_fix_crypttab_file (Main* self,
                        const gchar* target_path)
{
	gchar* crypttab_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeArrayList* crypttab_list = NULL;
	const gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp71_;
	const gchar* _tmp72_;
	gchar* _tmp73_;
	gchar* _tmp74_;
	const gchar* _tmp75_;
	gchar* _tmp76_;
	gchar* _tmp77_;
	gchar* _tmp78_;
	gchar* _tmp79_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_path != NULL);
	tee_jee_logging_log_debug ("Main: fix_crypttab_file()");
	_tmp0_ = tee_jee_file_system_path_combine (target_path, "etc/crypttab");
	crypttab_path = _tmp0_;
	_tmp1_ = crypttab_path;
	if (!tee_jee_file_system_file_exists (_tmp1_)) {
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = crypttab_path;
		_tmp3_ = g_strdup_printf ("File not found: %s", _tmp2_);
		_tmp4_ = _tmp3_;
		tee_jee_logging_log_debug (_tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (crypttab_path);
		return;
	}
	_tmp5_ = crypttab_path;
	_tmp6_ = crypt_tab_entry_read_file (_tmp5_);
	crypttab_list = _tmp6_;
	tee_jee_logging_log_debug ("checking for 'nofail' option...");
	{
		GeeArrayList* _entry_list = NULL;
		GeeArrayList* _tmp7_;
		gint _entry_size = 0;
		GeeArrayList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		gint _entry_index = 0;
		_tmp7_ = crypttab_list;
		_entry_list = _tmp7_;
		_tmp8_ = _entry_list;
		_tmp9_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		_entry_size = _tmp10_;
		_entry_index = -1;
		while (TRUE) {
			gint _tmp11_;
			gint _tmp12_;
			CryptTabEntry* entry = NULL;
			GeeArrayList* _tmp13_;
			gpointer _tmp14_;
			CryptTabEntry* _tmp15_;
			_entry_index = _entry_index + 1;
			_tmp11_ = _entry_index;
			_tmp12_ = _entry_size;
			if (!(_tmp11_ < _tmp12_)) {
				break;
			}
			_tmp13_ = _entry_list;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp13_, _entry_index);
			entry = (CryptTabEntry*) _tmp14_;
			_tmp15_ = entry;
			crypt_tab_entry_append_option (_tmp15_, "nofail");
			_g_object_unref0 (entry);
		}
	}
	tee_jee_logging_log_debug ("updating entries...");
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp16_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _mnt_index = 0;
		_tmp16_ = self->mount_list;
		_mnt_list = _tmp16_;
		_tmp17_ = _mnt_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_mnt_size = _tmp19_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp22_;
			gpointer _tmp23_;
			gboolean _tmp24_ = FALSE;
			gboolean _tmp25_ = FALSE;
			MountEntry* _tmp26_;
			Device* _tmp27_;
			_mnt_index = _mnt_index + 1;
			_tmp20_ = _mnt_index;
			_tmp21_ = _mnt_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _mnt_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _mnt_index);
			mnt = (MountEntry*) _tmp23_;
			_tmp26_ = mnt;
			_tmp27_ = _tmp26_->device;
			if (_tmp27_ != NULL) {
				MountEntry* _tmp28_;
				Device* _tmp29_;
				Device* _tmp30_;
				_tmp28_ = mnt;
				_tmp29_ = _tmp28_->device;
				_tmp30_ = _tmp29_->parent;
				_tmp25_ = _tmp30_ != NULL;
			} else {
				_tmp25_ = FALSE;
			}
			if (_tmp25_) {
				gboolean _tmp31_ = FALSE;
				MountEntry* _tmp32_;
				Device* _tmp33_;
				_tmp32_ = mnt;
				_tmp33_ = _tmp32_->device;
				if (device_is_on_encrypted_partition (_tmp33_)) {
					_tmp31_ = TRUE;
				} else {
					gboolean _tmp34_ = FALSE;
					MountEntry* _tmp35_;
					Device* _tmp36_;
					Device* _tmp37_;
					Device* _tmp38_;
					_tmp35_ = mnt;
					_tmp36_ = _tmp35_->device;
					_tmp37_ = _tmp36_->parent;
					_tmp38_ = _tmp37_->parent;
					if (_tmp38_ != NULL) {
						MountEntry* _tmp39_;
						Device* _tmp40_;
						Device* _tmp41_;
						_tmp39_ = mnt;
						_tmp40_ = _tmp39_->device;
						_tmp41_ = _tmp40_->parent;
						_tmp34_ = device_is_on_encrypted_partition (_tmp41_);
					} else {
						_tmp34_ = FALSE;
					}
					_tmp31_ = _tmp34_;
				}
				_tmp24_ = _tmp31_;
			} else {
				_tmp24_ = FALSE;
			}
			if (_tmp24_) {
				const gchar* _tmp42_ = NULL;
				MountEntry* _tmp43_;
				Device* _tmp44_;
				gchar* crypt_parent = NULL;
				gchar* _tmp54_;
				CryptTabEntry* entry = NULL;
				GeeArrayList* _tmp55_;
				const gchar* _tmp56_;
				CryptTabEntry* _tmp57_;
				CryptTabEntry* _tmp58_;
				CryptTabEntry* _tmp62_;
				const gchar* _tmp63_;
				CryptTabEntry* _tmp64_;
				const gchar* _tmp65_;
				gchar* _tmp66_;
				CryptTabEntry* _tmp67_;
				gchar* _tmp68_;
				CryptTabEntry* _tmp69_;
				gchar* _tmp70_;
				_tmp43_ = mnt;
				_tmp44_ = _tmp43_->device;
				if (device_is_on_encrypted_partition (_tmp44_)) {
					MountEntry* _tmp45_;
					Device* _tmp46_;
					Device* _tmp47_;
					const gchar* _tmp48_;
					_tmp45_ = mnt;
					_tmp46_ = _tmp45_->device;
					_tmp47_ = _tmp46_->parent;
					_tmp48_ = _tmp47_->uuid;
					_tmp42_ = _tmp48_;
				} else {
					MountEntry* _tmp49_;
					Device* _tmp50_;
					Device* _tmp51_;
					Device* _tmp52_;
					const gchar* _tmp53_;
					_tmp49_ = mnt;
					_tmp50_ = _tmp49_->device;
					_tmp51_ = _tmp50_->parent;
					_tmp52_ = _tmp51_->parent;
					_tmp53_ = _tmp52_->uuid;
					_tmp42_ = _tmp53_;
				}
				_tmp54_ = g_strdup (_tmp42_);
				crypt_parent = _tmp54_;
				_tmp55_ = crypttab_list;
				_tmp56_ = crypt_parent;
				_tmp57_ = crypt_tab_entry_find_entry_by_uuid (_tmp55_, _tmp56_);
				entry = _tmp57_;
				_tmp58_ = entry;
				if (_tmp58_ == NULL) {
					CryptTabEntry* _tmp59_;
					GeeArrayList* _tmp60_;
					CryptTabEntry* _tmp61_;
					_tmp59_ = crypt_tab_entry_new ();
					_g_object_unref0 (entry);
					entry = _tmp59_;
					_tmp60_ = crypttab_list;
					_tmp61_ = entry;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp60_, _tmp61_);
				}
				_tmp62_ = entry;
				_tmp63_ = crypt_parent;
				crypt_tab_entry_set_device_uuid (_tmp62_, _tmp63_);
				_tmp64_ = entry;
				_tmp65_ = crypt_parent;
				_tmp66_ = g_strdup_printf ("luks-%s", _tmp65_);
				_g_free0 (_tmp64_->mapped_name);
				_tmp64_->mapped_name = _tmp66_;
				_tmp67_ = entry;
				_tmp68_ = g_strdup ("none");
				_g_free0 (_tmp67_->keyfile);
				_tmp67_->keyfile = _tmp68_;
				_tmp69_ = entry;
				_tmp70_ = g_strdup ("luks,nofail");
				_g_free0 (_tmp69_->options);
				_tmp69_->options = _tmp70_;
				_g_object_unref0 (entry);
				_g_free0 (crypt_parent);
			}
			_g_object_unref0 (mnt);
		}
	}
	tee_jee_logging_log_debug ("writing updated file...");
	_tmp71_ = crypttab_list;
	_tmp72_ = crypttab_path;
	_tmp73_ = crypt_tab_entry_write_file (_tmp71_, _tmp72_, FALSE);
	_tmp74_ = _tmp73_;
	_g_free0 (_tmp74_);
	_tmp75_ = crypttab_path;
	_tmp76_ = g_strdup_printf (": %s", _tmp75_);
	_tmp77_ = _tmp76_;
	_tmp78_ = g_strconcat (_ ("Updated /etc/crypttab on target device"), _tmp77_, NULL);
	_tmp79_ = _tmp78_;
	tee_jee_logging_log_msg (_tmp79_, FALSE);
	_g_free0 (_tmp79_);
	_g_free0 (_tmp77_);
	tee_jee_logging_log_debug ("Main: fix_crypttab_file(): exit");
	_g_object_unref0 (crypttab_list);
	_g_free0 (crypttab_path);
}

static void
main_check_and_repair_filesystems (Main* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = main_get_restore_current_system (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		gchar* sh_fsck = NULL;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		const gchar* _tmp23_;
		gchar* _tmp24_;
		const gchar* _tmp25_;
		_tmp2_ = g_strconcat ("echo '", _ ("Checking file systems for errors..."), NULL);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strconcat (_tmp3_, "' \n", NULL);
		_tmp5_ = _tmp4_;
		_g_free0 (_tmp3_);
		sh_fsck = _tmp5_;
		{
			GeeArrayList* _mnt_list = NULL;
			GeeArrayList* _tmp6_;
			gint _mnt_size = 0;
			GeeArrayList* _tmp7_;
			gint _tmp8_;
			gint _tmp9_;
			gint _mnt_index = 0;
			_tmp6_ = self->mount_list;
			_mnt_list = _tmp6_;
			_tmp7_ = _mnt_list;
			_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
			_tmp9_ = _tmp8_;
			_mnt_size = _tmp9_;
			_mnt_index = -1;
			while (TRUE) {
				gint _tmp10_;
				gint _tmp11_;
				MountEntry* mnt = NULL;
				GeeArrayList* _tmp12_;
				gpointer _tmp13_;
				MountEntry* _tmp14_;
				Device* _tmp15_;
				_mnt_index = _mnt_index + 1;
				_tmp10_ = _mnt_index;
				_tmp11_ = _mnt_size;
				if (!(_tmp10_ < _tmp11_)) {
					break;
				}
				_tmp12_ = _mnt_list;
				_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _mnt_index);
				mnt = (MountEntry*) _tmp13_;
				_tmp14_ = mnt;
				_tmp15_ = _tmp14_->device;
				if (_tmp15_ != NULL) {
					const gchar* _tmp16_;
					MountEntry* _tmp17_;
					Device* _tmp18_;
					const gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					_tmp16_ = sh_fsck;
					_tmp17_ = mnt;
					_tmp18_ = _tmp17_->device;
					_tmp19_ = _tmp18_->device;
					_tmp20_ = g_strdup_printf ("fsck -y %s \n", _tmp19_);
					_tmp21_ = _tmp20_;
					_tmp22_ = g_strconcat (_tmp16_, _tmp21_, NULL);
					_g_free0 (sh_fsck);
					sh_fsck = _tmp22_;
					_g_free0 (_tmp21_);
				}
				_g_object_unref0 (mnt);
			}
		}
		_tmp23_ = sh_fsck;
		_tmp24_ = g_strconcat (_tmp23_, "echo '' \n", NULL);
		_g_free0 (sh_fsck);
		sh_fsck = _tmp24_;
		_tmp25_ = sh_fsck;
		tee_jee_process_helper_exec_script_sync (_tmp25_, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
		_g_free0 (sh_fsck);
	}
}

gboolean
main_restore_execute_rsync (Main* self)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_execute_rsync()");
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* sh_sync = NULL;
		gchar* sh_finish = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_ = NULL;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gboolean _tmp28_;
		gboolean _tmp29_;
		Snapshot* _tmp40_;
		gchar* _tmp41_;
		const gchar* _tmp42_;
		gboolean ok = FALSE;
		const gchar* _tmp43_;
		_tmp0_ = main_get_restore_source_path (self);
		_tmp1_ = _tmp0_;
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("source_path=%s", _tmp2_);
		_tmp4_ = _tmp3_;
		tee_jee_logging_log_debug (_tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		_tmp5_ = main_get_restore_target_path (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("target_path=%s", _tmp7_);
		_tmp9_ = _tmp8_;
		tee_jee_logging_log_debug (_tmp9_);
		_g_free0 (_tmp9_);
		_g_free0 (_tmp7_);
		main_create_restore_scripts (self, &_tmp10_, &_tmp11_);
		_g_free0 (sh_sync);
		sh_sync = _tmp10_;
		_g_free0 (sh_finish);
		sh_finish = _tmp11_;
		_tmp12_ = main_get_restore_source_path (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = _tmp13_;
		main_save_exclude_list_for_restore (self, _tmp14_);
		_g_free0 (_tmp14_);
		_tmp15_ = main_get_restore_log_file (self);
		_tmp16_ = _tmp15_;
		_tmp17_ = _tmp16_;
		tee_jee_file_system_file_delete (_tmp17_);
		_g_free0 (_tmp17_);
		_tmp18_ = main_get_restore_log_file (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = _tmp19_;
		_tmp21_ = g_strconcat (_tmp20_, "-changes", NULL);
		_tmp22_ = _tmp21_;
		tee_jee_file_system_file_delete (_tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (_tmp20_);
		_tmp23_ = main_get_restore_log_file (self);
		_tmp24_ = _tmp23_;
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, ".gz", NULL);
		_tmp27_ = _tmp26_;
		tee_jee_file_system_file_delete (_tmp27_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_tmp28_ = main_get_restore_current_system (self);
		_tmp29_ = _tmp28_;
		if (_tmp29_) {
			gchar* control_file_path = NULL;
			Snapshot* _tmp30_;
			const gchar* _tmp31_;
			gchar* _tmp32_;
			GFile* f = NULL;
			const gchar* _tmp33_;
			GFile* _tmp34_;
			GFile* _tmp35_;
			const gchar* _tmp37_;
			Snapshot* _tmp38_;
			const gchar* _tmp39_;
			_tmp30_ = self->snapshot_to_restore;
			_tmp31_ = _tmp30_->path;
			_tmp32_ = tee_jee_file_system_path_combine (_tmp31_, ".sync-restore");
			control_file_path = _tmp32_;
			_tmp33_ = control_file_path;
			_tmp34_ = g_file_new_for_path (_tmp33_);
			f = _tmp34_;
			_tmp35_ = f;
			if (g_file_query_exists (_tmp35_, NULL)) {
				GFile* _tmp36_;
				_tmp36_ = f;
				g_file_delete (_tmp36_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (f);
					_g_free0 (control_file_path);
					_g_free0 (sh_finish);
					_g_free0 (sh_sync);
					goto __catch0_g_error;
				}
			}
			_tmp37_ = control_file_path;
			_tmp38_ = self->snapshot_to_restore;
			_tmp39_ = _tmp38_->path;
			tee_jee_file_system_file_write (_tmp37_, _tmp39_);
			_g_object_unref0 (f);
			_g_free0 (control_file_path);
		}
		_tmp40_ = self->snapshot_to_restore;
		if (_tmp40_ != NULL) {
			if (self->dry_run) {
				tee_jee_logging_log_msg (_ ("Comparing Files (Dry Run)..."), FALSE);
			} else {
				tee_jee_logging_log_msg (_ ("Restoring snapshot..."), FALSE);
			}
		} else {
			tee_jee_logging_log_msg (_ ("Cloning system..."), FALSE);
		}
		_tmp41_ = g_strdup (_ ("Syncing files with rsync..."));
		_g_free0 (self->progress_text);
		self->progress_text = _tmp41_;
		_tmp42_ = self->progress_text;
		tee_jee_logging_log_msg (_tmp42_, FALSE);
		ok = TRUE;
		_tmp43_ = self->app_mode;
		if (g_strcmp0 (_tmp43_, "") == 0) {
			gboolean _tmp44_ = FALSE;
			gboolean _tmp45_;
			gboolean _tmp46_;
			_tmp45_ = main_get_restore_current_system (self);
			_tmp46_ = _tmp45_;
			if (!_tmp46_) {
				_tmp44_ = TRUE;
			} else {
				_tmp44_ = self->dry_run;
			}
			if (_tmp44_) {
				const gchar* _tmp47_;
				const gchar* _tmp48_;
				_tmp47_ = sh_sync;
				_tmp48_ = sh_finish;
				ok = main_restore_other_gui (self, _tmp47_, _tmp48_);
			} else {
				const gchar* _tmp49_;
				const gchar* _tmp50_;
				_tmp49_ = sh_sync;
				_tmp50_ = sh_finish;
				ok = main_restore_current_gui (self, _tmp49_, _tmp50_);
			}
		} else {
			gboolean _tmp51_;
			gboolean _tmp52_;
			_tmp51_ = main_get_restore_current_system (self);
			_tmp52_ = _tmp51_;
			if (_tmp52_) {
				const gchar* _tmp53_;
				const gchar* _tmp54_;
				_tmp53_ = sh_sync;
				_tmp54_ = sh_finish;
				ok = main_restore_current_console (self, _tmp53_, _tmp54_);
			} else {
				const gchar* _tmp55_;
				const gchar* _tmp56_;
				_tmp55_ = sh_sync;
				_tmp56_ = sh_finish;
				ok = main_restore_other_console (self, _tmp55_, _tmp56_);
			}
		}
		if (!self->dry_run) {
			gchar* _tmp57_;
			gchar* _tmp58_;
			tee_jee_logging_log_msg (_ ("Restore completed"), FALSE);
			self->thr_success = TRUE;
			_tmp57_ = g_strnfill ((gsize) 78, '-');
			_tmp58_ = _tmp57_;
			tee_jee_logging_log_msg (_tmp58_, FALSE);
			_g_free0 (_tmp58_);
			main_unmount_target_device (self, FALSE);
			main_check_and_repair_filesystems (self);
		}
		_g_free0 (sh_finish);
		_g_free0 (sh_sync);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp59_;
		const gchar* _tmp60_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp59_ = e;
		_tmp60_ = _tmp59_->message;
		tee_jee_logging_log_error (_tmp60_, FALSE, FALSE);
		self->thr_success = FALSE;
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp61_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp61_;
	}
	self->thread_restore_running = FALSE;
	result = self->thr_success;
	return result;
}

gboolean
main_restore_execute_btrfs (Main* self)
{
	gboolean ok = FALSE;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* sh = NULL;
	Snapshot* _tmp16_;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: restore_execute_btrfs()");
	ok = main_create_pre_restore_snapshot_btrfs (self);
	_tmp0_ = g_strnfill ((gsize) 78, '-');
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_msg (_tmp1_, FALSE);
	_g_free0 (_tmp1_);
	if (!ok) {
		self->thread_restore_running = FALSE;
		self->thr_success = FALSE;
		result = self->thr_success;
		return result;
	}
	{
		GeeIterator* _subvol_it = NULL;
		Snapshot* _tmp2_;
		GeeHashMap* _tmp3_;
		GeeCollection* _tmp4_;
		GeeCollection* _tmp5_;
		GeeCollection* _tmp6_;
		GeeIterator* _tmp7_;
		GeeIterator* _tmp8_;
		_tmp2_ = self->snapshot_to_restore;
		_tmp3_ = _tmp2_->subvolumes;
		_tmp4_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = _tmp5_;
		_tmp7_ = gee_iterable_iterator ((GeeIterable*) _tmp6_);
		_tmp8_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
		_subvol_it = _tmp8_;
		while (TRUE) {
			GeeIterator* _tmp9_;
			Subvolume* subvol = NULL;
			GeeIterator* _tmp10_;
			gpointer _tmp11_;
			gboolean _tmp12_ = FALSE;
			Subvolume* _tmp13_;
			const gchar* _tmp14_;
			Subvolume* _tmp15_;
			_tmp9_ = _subvol_it;
			if (!gee_iterator_next (_tmp9_)) {
				break;
			}
			_tmp10_ = _subvol_it;
			_tmp11_ = gee_iterator_get (_tmp10_);
			subvol = (Subvolume*) _tmp11_;
			_tmp13_ = subvol;
			_tmp14_ = _tmp13_->name;
			if (g_strcmp0 (_tmp14_, "@home") == 0) {
				_tmp12_ = !self->include_btrfs_home_for_restore;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				_g_object_unref0 (subvol);
				continue;
			}
			_tmp15_ = subvol;
			subvolume_restore (_tmp15_);
			_g_object_unref0 (subvol);
		}
		_g_object_unref0 (_subvol_it);
	}
	tee_jee_logging_log_msg (_ ("Restore completed"), FALSE);
	self->thr_success = TRUE;
	tee_jee_logging_log_debug ("Running post-restore tasks...");
	_tmp16_ = self->snapshot_to_restore;
	_tmp17_ = _tmp16_->path;
	_tmp18_ = g_strconcat ("test -d \"/etc/timeshift/restore-hooks.d\" &&" " export TS_SNAPSHOT_PATH=\"", _tmp17_, NULL);
	_tmp19_ = _tmp18_;
	_tmp20_ = g_strconcat (_tmp19_, "\" &&", NULL);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_strconcat (_tmp21_, " run-parts --verbose /etc/timeshift/restore-hooks.d", NULL);
	_tmp23_ = _tmp22_;
	_g_free0 (_tmp21_);
	_g_free0 (_tmp19_);
	sh = _tmp23_;
	_tmp24_ = sh;
	tee_jee_process_helper_exec_script_sync (_tmp24_, NULL, NULL, FALSE, FALSE, FALSE, TRUE);
	tee_jee_logging_log_debug ("Finished running post-restore tasks...");
	_tmp25_ = main_get_restore_current_system (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		tee_jee_logging_log_msg (_ ("Snapshot will become active after system is rebooted."), FALSE);
	}
	_tmp27_ = g_strnfill ((gsize) 78, '-');
	_tmp28_ = _tmp27_;
	tee_jee_logging_log_msg (_tmp28_, FALSE);
	_g_free0 (_tmp28_);
	self->thread_restore_running = FALSE;
	result = self->thr_success;
	_g_free0 (sh);
	return result;
}

gboolean
main_create_pre_restore_snapshot_btrfs (Main* self)
{
	gchar* cmd = NULL;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	GDateTime* dt_created = NULL;
	GDateTime* _tmp0_;
	gchar* time_stamp = NULL;
	GDateTime* _tmp1_;
	gchar* _tmp2_;
	gchar* snapshot_name = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* snapshot_path = NULL;
	gchar* _tmp5_;
	gboolean create_pre_restore_backup = FALSE;
	gboolean _tmp6_;
	gboolean _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("Main: create_pre_restore_snapshot_btrfs()");
	_tmp0_ = g_date_time_new_now_local ();
	dt_created = _tmp0_;
	_tmp1_ = dt_created;
	_tmp2_ = g_date_time_format (_tmp1_, "%Y-%m-%d_%H-%M-%S");
	time_stamp = _tmp2_;
	_tmp3_ = time_stamp;
	_tmp4_ = g_strdup (_tmp3_);
	snapshot_name = _tmp4_;
	_tmp5_ = g_strdup ("");
	snapshot_path = _tmp5_;
	create_pre_restore_backup = FALSE;
	_tmp6_ = main_get_restore_current_system (self);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		Snapshot* snap_prev = NULL;
		gboolean found = FALSE;
		snap_prev = NULL;
		found = FALSE;
		{
			GeeArrayList* _bak_list = NULL;
			SnapshotRepo* _tmp8_;
			GeeArrayList* _tmp9_;
			gint _bak_size = 0;
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			gint _bak_index = 0;
			_tmp8_ = self->repo;
			_tmp9_ = _tmp8_->snapshots;
			_bak_list = _tmp9_;
			_tmp10_ = _bak_list;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			_bak_size = _tmp12_;
			_bak_index = -1;
			while (TRUE) {
				gint _tmp13_;
				gint _tmp14_;
				Snapshot* bak = NULL;
				GeeArrayList* _tmp15_;
				gpointer _tmp16_;
				Snapshot* _tmp17_;
				_bak_index = _bak_index + 1;
				_tmp13_ = _bak_index;
				_tmp14_ = _bak_size;
				if (!(_tmp13_ < _tmp14_)) {
					break;
				}
				_tmp15_ = _bak_list;
				_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _bak_index);
				bak = (Snapshot*) _tmp16_;
				_tmp17_ = bak;
				if (_tmp17_->live) {
					Snapshot* _tmp18_;
					Snapshot* _tmp19_;
					Snapshot* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					gchar* _tmp25_;
					found = TRUE;
					_tmp18_ = bak;
					_tmp19_ = _g_object_ref0 (_tmp18_);
					_g_object_unref0 (snap_prev);
					snap_prev = _tmp19_;
					_tmp20_ = bak;
					_tmp21_ = _tmp20_->name;
					_tmp22_ = g_strdup_printf (": %s", _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strconcat (_ ("Found existing pre-restore snapshot"), _tmp23_, NULL);
					_tmp25_ = _tmp24_;
					tee_jee_logging_log_msg (_tmp25_, FALSE);
					_g_free0 (_tmp25_);
					_g_free0 (_tmp23_);
					_g_object_unref0 (bak);
					break;
				}
				_g_object_unref0 (bak);
			}
		}
		if (found) {
			gboolean _tmp26_ = FALSE;
			GeeHashMap* _tmp27_;
			gboolean _tmp35_ = FALSE;
			gboolean _tmp36_ = FALSE;
			Snapshot* _tmp45_;
			Snapshot* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
			gchar* _tmp49_;
			gchar* _tmp50_;
			Snapshot* _tmp51_;
			_tmp27_ = self->sys_subvolumes;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp27_, "@")) {
				Snapshot* _tmp28_;
				GeeHashMap* _tmp29_;
				_tmp28_ = self->snapshot_to_restore;
				_tmp29_ = _tmp28_->subvolumes;
				_tmp26_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp29_, "@");
			} else {
				_tmp26_ = FALSE;
			}
			if (_tmp26_) {
				GeeHashMap* _tmp30_;
				gpointer _tmp31_;
				Subvolume* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				_tmp30_ = self->sys_subvolumes;
				_tmp31_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp30_, "@");
				_tmp32_ = (Subvolume*) _tmp31_;
				subvolume_remove (_tmp32_);
				_g_object_unref0 (_tmp32_);
				_tmp33_ = g_strconcat (_ ("Deleted subvolume"), ": @", NULL);
				_tmp34_ = _tmp33_;
				tee_jee_logging_log_msg (_tmp34_, FALSE);
				_g_free0 (_tmp34_);
			}
			if (self->include_btrfs_home_for_restore) {
				GeeHashMap* _tmp37_;
				_tmp37_ = self->sys_subvolumes;
				_tmp36_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp37_, "@home");
			} else {
				_tmp36_ = FALSE;
			}
			if (_tmp36_) {
				Snapshot* _tmp38_;
				GeeHashMap* _tmp39_;
				_tmp38_ = self->snapshot_to_restore;
				_tmp39_ = _tmp38_->subvolumes;
				_tmp35_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp39_, "@home");
			} else {
				_tmp35_ = FALSE;
			}
			if (_tmp35_) {
				GeeHashMap* _tmp40_;
				gpointer _tmp41_;
				Subvolume* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp40_ = self->sys_subvolumes;
				_tmp41_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, "@home");
				_tmp42_ = (Subvolume*) _tmp41_;
				subvolume_remove (_tmp42_);
				_g_object_unref0 (_tmp42_);
				_tmp43_ = g_strconcat (_ ("Deleted subvolume"), ": @home", NULL);
				_tmp44_ = _tmp43_;
				tee_jee_logging_log_msg (_tmp44_, FALSE);
				_g_free0 (_tmp44_);
			}
			_tmp45_ = snap_prev;
			_tmp46_ = self->snapshot_to_restore;
			_tmp47_ = snapshot_get_date_formatted (_tmp46_);
			_tmp48_ = _tmp47_;
			_tmp49_ = _tmp48_;
			_tmp50_ = g_strdup_printf ("Before restoring '%s'", _tmp49_);
			_g_free0 (_tmp45_->description);
			_tmp45_->description = _tmp50_;
			_g_free0 (_tmp49_);
			_tmp51_ = snap_prev;
			snapshot_update_control_file (_tmp51_);
		} else {
			create_pre_restore_backup = TRUE;
		}
		_g_object_unref0 (snap_prev);
	} else {
		create_pre_restore_backup = TRUE;
	}
	if (create_pre_restore_backup) {
		const gchar* _tmp52_;
		gboolean no_subvolumes_found = FALSE;
		GeeArrayList* subvol_list = NULL;
		GeeArrayList* _tmp53_;
		gchar** subvol_names = NULL;
		gchar* _tmp54_;
		gchar** _tmp55_;
		gint subvol_names_length1;
		gint _subvol_names_size_;
		gchar** _tmp59_;
		gint _tmp59__length1;
		tee_jee_logging_log_msg (_ ("Creating pre-restore snapshot from system subvolumes..."), FALSE);
		_tmp52_ = snapshot_path;
		tee_jee_file_system_dir_create (_tmp52_, FALSE);
		no_subvolumes_found = TRUE;
		_tmp53_ = gee_array_list_new (TYPE_SUBVOLUME, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
		subvol_list = _tmp53_;
		_tmp54_ = g_strdup ("@");
		_tmp55_ = g_new0 (gchar*, 1 + 1);
		_tmp55_[0] = _tmp54_;
		subvol_names = _tmp55_;
		subvol_names_length1 = 1;
		_subvol_names_size_ = subvol_names_length1;
		if (self->include_btrfs_home_for_restore) {
			gchar* _tmp56_;
			gchar* _tmp57_;
			gchar** _tmp58_;
			_tmp56_ = g_strdup ("@");
			_tmp57_ = g_strdup ("@home");
			_tmp58_ = g_new0 (gchar*, 2 + 1);
			_tmp58_[0] = _tmp56_;
			_tmp58_[1] = _tmp57_;
			subvol_names = (_vala_array_free (subvol_names, subvol_names_length1, (GDestroyNotify) g_free), NULL);
			subvol_names = _tmp58_;
			subvol_names_length1 = 2;
			_subvol_names_size_ = subvol_names_length1;
		}
		_tmp59_ = subvol_names;
		_tmp59__length1 = subvol_names_length1;
		{
			gchar** subvol_name_collection = NULL;
			gint subvol_name_collection_length1 = 0;
			gint _subvol_name_collection_size_ = 0;
			gint subvol_name_it = 0;
			subvol_name_collection = _tmp59_;
			subvol_name_collection_length1 = _tmp59__length1;
			for (subvol_name_it = 0; subvol_name_it < subvol_name_collection_length1; subvol_name_it = subvol_name_it + 1) {
				gchar* _tmp60_;
				gchar* subvol_name = NULL;
				_tmp60_ = g_strdup (subvol_name_collection[subvol_name_it]);
				subvol_name = _tmp60_;
				{
					SnapshotRepo* _tmp61_;
					GeeHashMap* _tmp62_;
					const gchar* _tmp63_;
					gpointer _tmp64_;
					gchar* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_;
					gchar* _tmp68_;
					gchar* _tmp69_;
					const gchar* _tmp70_;
					gchar* src_path = NULL;
					SnapshotRepo* _tmp71_;
					GeeHashMap* _tmp72_;
					const gchar* _tmp73_;
					gpointer _tmp74_;
					gchar* _tmp75_;
					const gchar* _tmp76_;
					gchar* _tmp77_;
					gchar* _tmp78_;
					const gchar* _tmp79_;
					gchar* dst_path = NULL;
					const gchar* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
					const gchar* _tmp89_;
					const gchar* _tmp90_;
					gchar* _tmp91_;
					const gchar* _tmp92_;
					gint status = 0;
					const gchar* _tmp93_;
					gchar* _tmp94_ = NULL;
					gchar* _tmp95_ = NULL;
					gint _tmp96_;
					_tmp61_ = self->repo;
					_tmp62_ = _tmp61_->mount_paths;
					_tmp63_ = subvol_name;
					_tmp64_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp62_, _tmp63_);
					_tmp65_ = (gchar*) _tmp64_;
					_tmp66_ = snapshot_name;
					_tmp67_ = g_strdup_printf ("timeshift-btrfs/snapshots/%s", _tmp66_);
					_tmp68_ = _tmp67_;
					_tmp69_ = tee_jee_file_system_path_combine (_tmp65_, _tmp68_);
					_g_free0 (snapshot_path);
					snapshot_path = _tmp69_;
					_g_free0 (_tmp68_);
					_g_free0 (_tmp65_);
					_tmp70_ = snapshot_path;
					tee_jee_file_system_dir_create (_tmp70_, TRUE);
					_tmp71_ = self->repo;
					_tmp72_ = _tmp71_->mount_paths;
					_tmp73_ = subvol_name;
					_tmp74_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp72_, _tmp73_);
					_tmp75_ = (gchar*) _tmp74_;
					_tmp76_ = subvol_name;
					_tmp77_ = tee_jee_file_system_path_combine (_tmp75_, _tmp76_);
					_tmp78_ = _tmp77_;
					_g_free0 (_tmp75_);
					src_path = _tmp78_;
					_tmp79_ = src_path;
					if (!tee_jee_file_system_dir_exists (_tmp79_)) {
						const gchar* _tmp80_;
						gchar* _tmp81_;
						gchar* _tmp82_;
						gchar* _tmp83_;
						gchar* _tmp84_;
						const gchar* _tmp85_;
						_tmp80_ = subvol_name;
						_tmp81_ = g_strdup_printf (": %s", _tmp80_);
						_tmp82_ = _tmp81_;
						_tmp83_ = g_strconcat (_ ("Could not find system subvolume"), _tmp82_, NULL);
						_tmp84_ = _tmp83_;
						tee_jee_logging_log_error (_tmp84_, FALSE, FALSE);
						_g_free0 (_tmp84_);
						_g_free0 (_tmp82_);
						_tmp85_ = snapshot_path;
						tee_jee_file_system_dir_delete (_tmp85_, FALSE);
						_g_free0 (src_path);
						_g_free0 (subvol_name);
						continue;
					}
					no_subvolumes_found = FALSE;
					_tmp86_ = snapshot_path;
					_tmp87_ = subvol_name;
					_tmp88_ = tee_jee_file_system_path_combine (_tmp86_, _tmp87_);
					dst_path = _tmp88_;
					_tmp89_ = src_path;
					_tmp90_ = dst_path;
					_tmp91_ = g_strdup_printf ("mv '%s' '%s'", _tmp89_, _tmp90_);
					_g_free0 (cmd);
					cmd = _tmp91_;
					_tmp92_ = cmd;
					tee_jee_logging_log_debug (_tmp92_);
					_tmp93_ = cmd;
					_tmp96_ = tee_jee_process_helper_exec_sync (_tmp93_, &_tmp94_, &_tmp95_);
					_g_free0 (std_out);
					std_out = _tmp94_;
					_g_free0 (std_err);
					std_err = _tmp95_;
					status = _tmp96_;
					if (status != 0) {
						const gchar* _tmp97_;
						const gchar* _tmp98_;
						gchar* _tmp99_;
						gchar* _tmp100_;
						gchar* _tmp101_;
						gchar* _tmp102_;
						_tmp97_ = std_err;
						tee_jee_logging_log_error (_tmp97_, FALSE, FALSE);
						_tmp98_ = subvol_name;
						_tmp99_ = g_strdup_printf (": %s", _tmp98_);
						_tmp100_ = _tmp99_;
						_tmp101_ = g_strconcat (_ ("Failed to move system subvolume to snapshot directory"), _tmp100_, NULL);
						_tmp102_ = _tmp101_;
						tee_jee_logging_log_error (_tmp102_, FALSE, FALSE);
						_g_free0 (_tmp102_);
						_g_free0 (_tmp100_);
						result = FALSE;
						_g_free0 (dst_path);
						_g_free0 (src_path);
						_g_free0 (subvol_name);
						subvol_names = (_vala_array_free (subvol_names, subvol_names_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (subvol_list);
						_g_free0 (snapshot_path);
						_g_free0 (snapshot_name);
						_g_free0 (time_stamp);
						_g_date_time_unref0 (dt_created);
						_g_free0 (std_err);
						_g_free0 (std_out);
						_g_free0 (cmd);
						return result;
					} else {
						Device* _tmp103_ = NULL;
						const gchar* _tmp104_;
						Device* subvol_dev = NULL;
						Device* _tmp109_;
						GeeArrayList* _tmp110_;
						const gchar* _tmp111_;
						const gchar* _tmp112_;
						Device* _tmp113_;
						const gchar* _tmp114_;
						SnapshotRepo* _tmp115_;
						Subvolume* _tmp116_;
						Subvolume* _tmp117_;
						const gchar* _tmp118_;
						gchar* _tmp119_;
						gchar* _tmp120_;
						gchar* _tmp121_;
						gchar* _tmp122_;
						_tmp104_ = subvol_name;
						if (g_strcmp0 (_tmp104_, "@") == 0) {
							SnapshotRepo* _tmp105_;
							Device* _tmp106_;
							_tmp105_ = self->repo;
							_tmp106_ = _tmp105_->device;
							_tmp103_ = _tmp106_;
						} else {
							SnapshotRepo* _tmp107_;
							Device* _tmp108_;
							_tmp107_ = self->repo;
							_tmp108_ = _tmp107_->device_home;
							_tmp103_ = _tmp108_;
						}
						_tmp109_ = _g_object_ref0 (_tmp103_);
						subvol_dev = _tmp109_;
						_tmp110_ = subvol_list;
						_tmp111_ = subvol_name;
						_tmp112_ = dst_path;
						_tmp113_ = subvol_dev;
						_tmp114_ = _tmp113_->uuid;
						_tmp115_ = self->repo;
						_tmp116_ = subvolume_new (_tmp111_, _tmp112_, _tmp114_, _tmp115_);
						_tmp117_ = _tmp116_;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp110_, _tmp117_);
						_g_object_unref0 (_tmp117_);
						_tmp118_ = subvol_name;
						_tmp119_ = g_strdup_printf (": %s", _tmp118_);
						_tmp120_ = _tmp119_;
						_tmp121_ = g_strconcat (_ ("Moved system subvolume to snapshot directory"), _tmp120_, NULL);
						_tmp122_ = _tmp121_;
						tee_jee_logging_log_msg (_tmp122_, FALSE);
						_g_free0 (_tmp122_);
						_g_free0 (_tmp120_);
						_g_object_unref0 (subvol_dev);
					}
					_g_free0 (dst_path);
					_g_free0 (src_path);
					_g_free0 (subvol_name);
				}
			}
		}
		if (no_subvolumes_found) {
			tee_jee_logging_log_error (_ ("Could not find system subvolumes for creating pre-restore snapshot"), FALSE, FALSE);
		} else {
			SnapshotRepo* _tmp123_;
			GeeHashMap* _tmp124_;
			gpointer _tmp125_;
			gchar* _tmp126_;
			const gchar* _tmp127_;
			gchar* _tmp128_;
			gchar* _tmp129_;
			gchar* _tmp130_;
			Snapshot* snap = NULL;
			const gchar* _tmp131_;
			GDateTime* _tmp132_;
			SnapshotRepo* _tmp133_;
			Device* _tmp134_;
			const gchar* _tmp135_;
			const gchar* _tmp136_;
			gchar* _tmp137_;
			gchar* _tmp138_;
			LinuxDistro* _tmp139_;
			LinuxDistro* _tmp140_;
			gchar* _tmp141_;
			gchar* _tmp142_;
			SnapshotRepo* _tmp143_;
			Snapshot* _tmp144_;
			Snapshot* _tmp145_;
			Snapshot* _tmp146_;
			Snapshot* _tmp147_;
			gchar* _tmp148_;
			gchar* _tmp149_;
			gchar* _tmp150_;
			gchar* _tmp151_;
			Snapshot* _tmp152_;
			Snapshot* _tmp166_;
			Snapshot* _tmp167_;
			const gchar* _tmp168_;
			gchar* _tmp169_;
			gchar* _tmp170_;
			gchar* _tmp171_;
			gchar* _tmp172_;
			SnapshotRepo* _tmp173_;
			_tmp123_ = self->repo;
			_tmp124_ = _tmp123_->mount_paths;
			_tmp125_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp124_, "@");
			_tmp126_ = (gchar*) _tmp125_;
			_tmp127_ = snapshot_name;
			_tmp128_ = g_strdup_printf ("timeshift-btrfs/snapshots/%s", _tmp127_);
			_tmp129_ = _tmp128_;
			_tmp130_ = tee_jee_file_system_path_combine (_tmp126_, _tmp129_);
			_g_free0 (snapshot_path);
			snapshot_path = _tmp130_;
			_g_free0 (_tmp129_);
			_g_free0 (_tmp126_);
			_tmp131_ = snapshot_path;
			_tmp132_ = dt_created;
			_tmp133_ = self->repo;
			_tmp134_ = _tmp133_->device;
			_tmp135_ = _tmp134_->uuid;
			_tmp136_ = snapshot_path;
			_tmp137_ = tee_jee_file_system_path_combine (_tmp136_, "@");
			_tmp138_ = _tmp137_;
			_tmp139_ = linux_distro_get_dist_info (_tmp138_);
			_tmp140_ = _tmp139_;
			_tmp141_ = linux_distro_full_name (_tmp140_);
			_tmp142_ = _tmp141_;
			_tmp143_ = self->repo;
			_tmp144_ = snapshot_write_control_file (_tmp131_, _tmp132_, _tmp135_, _tmp142_, "ondemand", "", (gint64) 0, TRUE, FALSE, _tmp143_, FALSE);
			_tmp145_ = _tmp144_;
			_g_free0 (_tmp142_);
			_g_object_unref0 (_tmp140_);
			_g_free0 (_tmp138_);
			snap = _tmp145_;
			_tmp146_ = snap;
			_tmp147_ = self->snapshot_to_restore;
			_tmp148_ = snapshot_get_date_formatted (_tmp147_);
			_tmp149_ = _tmp148_;
			_tmp150_ = _tmp149_;
			_tmp151_ = g_strdup_printf ("Before restoring '%s'", _tmp150_);
			_g_free0 (_tmp146_->description);
			_tmp146_->description = _tmp151_;
			_g_free0 (_tmp150_);
			_tmp152_ = snap;
			_tmp152_->live = TRUE;
			{
				GeeArrayList* _subvol_list = NULL;
				GeeArrayList* _tmp153_;
				gint _subvol_size = 0;
				GeeArrayList* _tmp154_;
				gint _tmp155_;
				gint _tmp156_;
				gint _subvol_index = 0;
				_tmp153_ = subvol_list;
				_subvol_list = _tmp153_;
				_tmp154_ = _subvol_list;
				_tmp155_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp154_);
				_tmp156_ = _tmp155_;
				_subvol_size = _tmp156_;
				_subvol_index = -1;
				while (TRUE) {
					gint _tmp157_;
					gint _tmp158_;
					Subvolume* subvol = NULL;
					GeeArrayList* _tmp159_;
					gpointer _tmp160_;
					Snapshot* _tmp161_;
					GeeHashMap* _tmp162_;
					Subvolume* _tmp163_;
					const gchar* _tmp164_;
					Subvolume* _tmp165_;
					_subvol_index = _subvol_index + 1;
					_tmp157_ = _subvol_index;
					_tmp158_ = _subvol_size;
					if (!(_tmp157_ < _tmp158_)) {
						break;
					}
					_tmp159_ = _subvol_list;
					_tmp160_ = gee_abstract_list_get ((GeeAbstractList*) _tmp159_, _subvol_index);
					subvol = (Subvolume*) _tmp160_;
					_tmp161_ = snap;
					_tmp162_ = _tmp161_->subvolumes;
					_tmp163_ = subvol;
					_tmp164_ = _tmp163_->name;
					_tmp165_ = subvol;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp162_, _tmp164_, _tmp165_);
					_g_object_unref0 (subvol);
				}
			}
			_tmp166_ = snap;
			snapshot_update_control_file (_tmp166_);
			_tmp167_ = snap;
			_tmp168_ = _tmp167_->name;
			_tmp169_ = g_strdup_printf (": %s", _tmp168_);
			_tmp170_ = _tmp169_;
			_tmp171_ = g_strconcat (_ ("Created pre-restore snapshot"), _tmp170_, NULL);
			_tmp172_ = _tmp171_;
			tee_jee_logging_log_msg (_tmp172_, FALSE);
			_g_free0 (_tmp172_);
			_g_free0 (_tmp170_);
			_tmp173_ = self->repo;
			snapshot_repo_load_snapshots (_tmp173_);
			_g_object_unref0 (snap);
		}
		subvol_names = (_vala_array_free (subvol_names, subvol_names_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (subvol_list);
	}
	result = TRUE;
	_g_free0 (snapshot_path);
	_g_free0 (snapshot_name);
	_g_free0 (time_stamp);
	_g_date_time_unref0 (dt_created);
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	return result;
}

static gpointer
_json_array_ref0 (gpointer self)
{
	return self ? json_array_ref (self) : NULL;
}

static void
_vala_JsonNode_free (JsonNode* self)
{
	g_boxed_free (json_node_get_type (), self);
}

void
main_save_app_config (Main* self)
{
	JsonObject* config = NULL;
	JsonObject* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SnapshotRepo* _tmp2_;
	JsonObject* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	JsonObject* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	JsonObject* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	JsonObject* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	JsonObject* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	JsonObject* _tmp38_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	JsonObject* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	JsonObject* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	JsonObject* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	JsonObject* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	JsonObject* _tmp53_;
	gchar* _tmp54_;
	gchar* _tmp55_;
	JsonObject* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	JsonObject* _tmp59_;
	gchar* _tmp60_;
	gchar* _tmp61_;
	JsonObject* _tmp62_;
	gchar* _tmp63_;
	gchar* _tmp64_;
	JsonObject* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	SnapshotRepo* _tmp68_;
	JsonObject* _tmp75_;
	const gchar* _tmp76_;
	JsonArray* arr = NULL;
	JsonArray* _tmp77_;
	JsonObject* _tmp88_;
	JsonArray* _tmp89_;
	JsonArray* _tmp90_;
	JsonArray* _tmp91_;
	JsonObject* _tmp102_;
	JsonArray* _tmp103_;
	JsonArray* _tmp104_;
	JsonGenerator* json = NULL;
	JsonGenerator* _tmp105_;
	JsonNode* node = NULL;
	JsonNode* _tmp106_;
	JsonObject* _tmp107_;
	gboolean _tmp111_ = FALSE;
	const gchar* _tmp112_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: save_app_config()");
	_tmp0_ = json_object_new ();
	config = _tmp0_;
	_tmp2_ = self->repo;
	if (_tmp2_ != NULL) {
		SnapshotRepo* _tmp3_;
		_tmp3_ = self->repo;
		_tmp1_ = snapshot_repo_available (_tmp3_);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		SnapshotRepo* _tmp5_;
		Device* _tmp6_;
		JsonObject* _tmp10_;
		const gchar* _tmp11_ = NULL;
		SnapshotRepo* _tmp12_;
		Device* _tmp13_;
		JsonObject* _tmp18_;
		_tmp5_ = self->repo;
		_tmp6_ = _tmp5_->device;
		if (_tmp6_ == NULL) {
			_tmp4_ = "";
		} else {
			SnapshotRepo* _tmp7_;
			Device* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = self->repo;
			_tmp8_ = _tmp7_->device;
			_tmp9_ = _tmp8_->uuid;
			_tmp4_ = _tmp9_;
		}
		_tmp10_ = config;
		json_object_set_string_member (_tmp10_, "backup_device_uuid", _tmp4_);
		_tmp12_ = self->repo;
		_tmp13_ = _tmp12_->device;
		if (device_has_parent (_tmp13_)) {
			SnapshotRepo* _tmp14_;
			Device* _tmp15_;
			Device* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = self->repo;
			_tmp15_ = _tmp14_->device;
			_tmp16_ = _tmp15_->parent;
			_tmp17_ = _tmp16_->uuid;
			_tmp11_ = _tmp17_;
		} else {
			_tmp11_ = "";
		}
		_tmp18_ = config;
		json_object_set_string_member (_tmp18_, "parent_device_uuid", _tmp11_);
	} else {
		JsonObject* _tmp19_;
		const gchar* _tmp20_;
		JsonObject* _tmp21_;
		const gchar* _tmp22_;
		_tmp19_ = config;
		_tmp20_ = self->backup_uuid;
		json_object_set_string_member (_tmp19_, "backup_device_uuid", _tmp20_);
		_tmp21_ = config;
		_tmp22_ = self->backup_parent_uuid;
		json_object_set_string_member (_tmp21_, "parent_device_uuid", _tmp22_);
	}
	_tmp23_ = config;
	_tmp24_ = bool_to_string (FALSE);
	_tmp25_ = _tmp24_;
	json_object_set_string_member (_tmp23_, "do_first_run", _tmp25_);
	_g_free0 (_tmp25_);
	_tmp26_ = config;
	_tmp27_ = bool_to_string (self->btrfs_mode);
	_tmp28_ = _tmp27_;
	json_object_set_string_member (_tmp26_, "btrfs_mode", _tmp28_);
	_g_free0 (_tmp28_);
	_tmp29_ = config;
	_tmp30_ = bool_to_string (self->include_btrfs_home_for_backup);
	_tmp31_ = _tmp30_;
	json_object_set_string_member (_tmp29_, "include_btrfs_home_for_backup", _tmp31_);
	_g_free0 (_tmp31_);
	_tmp32_ = config;
	_tmp33_ = bool_to_string (self->include_btrfs_home_for_restore);
	_tmp34_ = _tmp33_;
	json_object_set_string_member (_tmp32_, "include_btrfs_home_for_restore", _tmp34_);
	_g_free0 (_tmp34_);
	_tmp35_ = config;
	_tmp36_ = bool_to_string (self->stop_cron_emails);
	_tmp37_ = _tmp36_;
	json_object_set_string_member (_tmp35_, "stop_cron_emails", _tmp37_);
	_g_free0 (_tmp37_);
	_tmp38_ = config;
	_tmp39_ = bool_to_string (self->schedule_monthly);
	_tmp40_ = _tmp39_;
	json_object_set_string_member (_tmp38_, "schedule_monthly", _tmp40_);
	_g_free0 (_tmp40_);
	_tmp41_ = config;
	_tmp42_ = bool_to_string (self->schedule_weekly);
	_tmp43_ = _tmp42_;
	json_object_set_string_member (_tmp41_, "schedule_weekly", _tmp43_);
	_g_free0 (_tmp43_);
	_tmp44_ = config;
	_tmp45_ = bool_to_string (self->schedule_daily);
	_tmp46_ = _tmp45_;
	json_object_set_string_member (_tmp44_, "schedule_daily", _tmp46_);
	_g_free0 (_tmp46_);
	_tmp47_ = config;
	_tmp48_ = bool_to_string (self->schedule_hourly);
	_tmp49_ = _tmp48_;
	json_object_set_string_member (_tmp47_, "schedule_hourly", _tmp49_);
	_g_free0 (_tmp49_);
	_tmp50_ = config;
	_tmp51_ = bool_to_string (self->schedule_boot);
	_tmp52_ = _tmp51_;
	json_object_set_string_member (_tmp50_, "schedule_boot", _tmp52_);
	_g_free0 (_tmp52_);
	_tmp53_ = config;
	_tmp54_ = g_strdup_printf ("%i", self->count_monthly);
	_tmp55_ = _tmp54_;
	json_object_set_string_member (_tmp53_, "count_monthly", _tmp55_);
	_g_free0 (_tmp55_);
	_tmp56_ = config;
	_tmp57_ = g_strdup_printf ("%i", self->count_weekly);
	_tmp58_ = _tmp57_;
	json_object_set_string_member (_tmp56_, "count_weekly", _tmp58_);
	_g_free0 (_tmp58_);
	_tmp59_ = config;
	_tmp60_ = g_strdup_printf ("%i", self->count_daily);
	_tmp61_ = _tmp60_;
	json_object_set_string_member (_tmp59_, "count_daily", _tmp61_);
	_g_free0 (_tmp61_);
	_tmp62_ = config;
	_tmp63_ = g_strdup_printf ("%i", self->count_hourly);
	_tmp64_ = _tmp63_;
	json_object_set_string_member (_tmp62_, "count_hourly", _tmp64_);
	_g_free0 (_tmp64_);
	_tmp65_ = config;
	_tmp66_ = g_strdup_printf ("%i", self->count_boot);
	_tmp67_ = _tmp66_;
	json_object_set_string_member (_tmp65_, "count_boot", _tmp67_);
	_g_free0 (_tmp67_);
	_tmp68_ = self->repo;
	if (snapshot_repo_has_snapshots (_tmp68_)) {
		JsonObject* _tmp69_;
		gchar* _tmp70_;
		gchar* _tmp71_;
		JsonObject* _tmp72_;
		gchar* _tmp73_;
		gchar* _tmp74_;
		_tmp69_ = config;
		_tmp70_ = g_strdup_printf ("%" G_GUINT64_FORMAT, main_first_snapshot_size);
		_tmp71_ = _tmp70_;
		json_object_set_string_member (_tmp69_, "snapshot_size", _tmp71_);
		_g_free0 (_tmp71_);
		_tmp72_ = config;
		_tmp73_ = g_strdup_printf ("%" G_GINT64_FORMAT, main_first_snapshot_count);
		_tmp74_ = _tmp73_;
		json_object_set_string_member (_tmp72_, "snapshot_count", _tmp74_);
		_g_free0 (_tmp74_);
	} else {
		main_first_snapshot_size = (guint64) 0;
		main_first_snapshot_count = (gint64) 0;
	}
	_tmp75_ = config;
	_tmp76_ = self->date_format;
	json_object_set_string_member (_tmp75_, "date_format", _tmp76_);
	_tmp77_ = json_array_new ();
	arr = _tmp77_;
	{
		GeeArrayList* _path_list = NULL;
		GeeArrayList* _tmp78_;
		gint _path_size = 0;
		GeeArrayList* _tmp79_;
		gint _tmp80_;
		gint _tmp81_;
		gint _path_index = 0;
		_tmp78_ = self->exclude_list_user;
		_path_list = _tmp78_;
		_tmp79_ = _path_list;
		_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
		_tmp81_ = _tmp80_;
		_path_size = _tmp81_;
		_path_index = -1;
		while (TRUE) {
			gint _tmp82_;
			gint _tmp83_;
			gchar* path = NULL;
			GeeArrayList* _tmp84_;
			gpointer _tmp85_;
			JsonArray* _tmp86_;
			const gchar* _tmp87_;
			_path_index = _path_index + 1;
			_tmp82_ = _path_index;
			_tmp83_ = _path_size;
			if (!(_tmp82_ < _tmp83_)) {
				break;
			}
			_tmp84_ = _path_list;
			_tmp85_ = gee_abstract_list_get ((GeeAbstractList*) _tmp84_, _path_index);
			path = (gchar*) _tmp85_;
			_tmp86_ = arr;
			_tmp87_ = path;
			json_array_add_string_element (_tmp86_, _tmp87_);
			_g_free0 (path);
		}
	}
	_tmp88_ = config;
	_tmp89_ = arr;
	_tmp90_ = _json_array_ref0 (_tmp89_);
	json_object_set_array_member (_tmp88_, "exclude", _tmp90_);
	_tmp91_ = json_array_new ();
	_json_array_unref0 (arr);
	arr = _tmp91_;
	{
		GeeArrayList* _name_list = NULL;
		GeeArrayList* _tmp92_;
		gint _name_size = 0;
		GeeArrayList* _tmp93_;
		gint _tmp94_;
		gint _tmp95_;
		gint _name_index = 0;
		_tmp92_ = self->exclude_app_names;
		_name_list = _tmp92_;
		_tmp93_ = _name_list;
		_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
		_tmp95_ = _tmp94_;
		_name_size = _tmp95_;
		_name_index = -1;
		while (TRUE) {
			gint _tmp96_;
			gint _tmp97_;
			gchar* name = NULL;
			GeeArrayList* _tmp98_;
			gpointer _tmp99_;
			JsonArray* _tmp100_;
			const gchar* _tmp101_;
			_name_index = _name_index + 1;
			_tmp96_ = _name_index;
			_tmp97_ = _name_size;
			if (!(_tmp96_ < _tmp97_)) {
				break;
			}
			_tmp98_ = _name_list;
			_tmp99_ = gee_abstract_list_get ((GeeAbstractList*) _tmp98_, _name_index);
			name = (gchar*) _tmp99_;
			_tmp100_ = arr;
			_tmp101_ = name;
			json_array_add_string_element (_tmp100_, _tmp101_);
			_g_free0 (name);
		}
	}
	_tmp102_ = config;
	_tmp103_ = arr;
	_tmp104_ = _json_array_ref0 (_tmp103_);
	json_object_set_array_member (_tmp102_, "exclude-apps", _tmp104_);
	_tmp105_ = json_generator_new ();
	json = _tmp105_;
	json_generator_set_pretty (json, TRUE);
	json_generator_set_indent (json, (guint) 2);
	_tmp106_ = json_node_new (JSON_NODE_OBJECT);
	node = _tmp106_;
	_tmp107_ = config;
	json_node_set_object (node, _tmp107_);
	json_generator_set_root (json, node);
	{
		const gchar* _tmp108_;
		_tmp108_ = self->app_conf_path;
		json_generator_to_file (json, _tmp108_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp109_;
		const gchar* _tmp110_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp109_ = e;
		_tmp110_ = _tmp109_->message;
		tee_jee_logging_log_error (_tmp110_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		__vala_JsonNode_free0 (node);
		_g_object_unref0 (json);
		_json_array_unref0 (arr);
		_json_object_unref0 (config);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp112_ = self->app_mode;
	if (g_strcmp0 (_tmp112_, "") == 0) {
		_tmp111_ = TRUE;
	} else {
		_tmp111_ = tee_jee_logging_LOG_DEBUG;
	}
	if (_tmp111_) {
		const gchar* _tmp113_;
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
		_tmp113_ = self->app_conf_path;
		_tmp114_ = g_strdup_printf (": %s", _tmp113_);
		_tmp115_ = _tmp114_;
		_tmp116_ = g_strconcat (_ ("App config saved"), _tmp115_, NULL);
		_tmp117_ = _tmp116_;
		tee_jee_logging_log_msg (_tmp117_, FALSE);
		_g_free0 (_tmp117_);
		_g_free0 (_tmp115_);
	}
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (json);
	_json_array_unref0 (arr);
	_json_object_unref0 (config);
}

static JsonNode*
_vala_JsonNode_copy (JsonNode* self)
{
	return g_boxed_copy (json_node_get_type (), self);
}

static gpointer
__vala_JsonNode_copy0 (gpointer self)
{
	return self ? _vala_JsonNode_copy (self) : NULL;
}

static gpointer
_json_object_ref0 (gpointer self)
{
	return self ? json_object_ref (self) : NULL;
}

void
main_load_app_config (Main* self)
{
	GFile* f = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	JsonParser* parser = NULL;
	JsonParser* _tmp16_;
	JsonNode* node = NULL;
	JsonNode* _tmp20_;
	JsonNode* _tmp21_;
	JsonNode* _tmp22_ = NULL;
	JsonNode* _tmp23_;
	JsonObject* _tmp24_ = NULL;
	JsonObject* _tmp26_ = NULL;
	JsonObject* _tmp27_;
	JsonObject* config = NULL;
	JsonObject* _tmp29_;
	gboolean do_first_run = FALSE;
	JsonObject* _tmp30_;
	JsonObject* _tmp31_;
	JsonObject* _tmp32_;
	JsonObject* _tmp35_;
	JsonObject* _tmp36_;
	gboolean* _tmp37_;
	JsonObject* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	JsonObject* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	JsonObject* _tmp45_;
	JsonObject* _tmp46_;
	JsonObject* _tmp47_;
	JsonObject* _tmp48_;
	JsonObject* _tmp49_;
	JsonObject* _tmp50_;
	JsonObject* _tmp51_;
	JsonObject* _tmp52_;
	JsonObject* _tmp53_;
	JsonObject* _tmp54_;
	JsonObject* _tmp55_;
	gchar* _tmp56_;
	JsonObject* _tmp57_;
	JsonObject* _tmp58_;
	GeeArrayList* _tmp59_;
	JsonObject* _tmp60_;
	GeeArrayList* _tmp78_;
	JsonObject* _tmp79_;
	gboolean _tmp93_ = FALSE;
	const gchar* _tmp94_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: load_app_config()");
	_tmp0_ = self->app_conf_path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	f = _tmp1_;
	_tmp2_ = f;
	if (!g_file_query_exists (_tmp2_, NULL)) {
		const gchar* _tmp3_;
		_tmp3_ = self->app_conf_path_old;
		if (tee_jee_file_system_file_exists (_tmp3_)) {
			const gchar* _tmp4_;
			const gchar* _tmp5_;
			_tmp4_ = self->app_conf_path_old;
			_tmp5_ = self->app_conf_path;
			tee_jee_file_system_file_move (_tmp4_, _tmp5_);
		} else {
			const gchar* _tmp6_;
			_tmp6_ = self->app_conf_path_default;
			if (tee_jee_file_system_file_exists (_tmp6_)) {
				const gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				gboolean _tmp10_;
				const gchar* _tmp14_;
				const gchar* _tmp15_;
				_tmp7_ = self->app_conf_path;
				_tmp8_ = tee_jee_file_system_file_parent (_tmp7_);
				_tmp9_ = _tmp8_;
				_tmp10_ = !tee_jee_file_system_dir_exists (_tmp9_);
				_g_free0 (_tmp9_);
				if (_tmp10_) {
					const gchar* _tmp11_;
					gchar* _tmp12_;
					gchar* _tmp13_;
					_tmp11_ = self->app_conf_path;
					_tmp12_ = tee_jee_file_system_file_parent (_tmp11_);
					_tmp13_ = _tmp12_;
					tee_jee_file_system_dir_create (_tmp13_, FALSE);
					_g_free0 (_tmp13_);
				}
				_tmp14_ = self->app_conf_path_default;
				_tmp15_ = self->app_conf_path;
				tee_jee_file_system_file_copy (_tmp14_, _tmp15_);
			}
		}
	}
	_tmp16_ = json_parser_new ();
	parser = _tmp16_;
	{
		const gchar* _tmp17_;
		_tmp17_ = self->app_conf_path;
		json_parser_load_from_file (parser, _tmp17_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		tee_jee_logging_log_error (_tmp19_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (parser);
		_g_object_unref0 (f);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp20_ = json_parser_get_root (parser);
	_tmp21_ = __vala_JsonNode_copy0 (_tmp20_);
	node = _tmp21_;
	_tmp23_ = node;
	_tmp22_ = _tmp23_;
	_tmp24_ = NULL;
	if (_tmp22_ != NULL) {
		JsonObject* _tmp25_;
		_tmp25_ = json_node_get_object (_tmp22_);
		_tmp24_ = _tmp25_;
	}
	_tmp27_ = _json_object_ref0 (_tmp24_);
	_tmp26_ = _tmp27_;
	if (_tmp26_ == NULL) {
		JsonObject* _tmp28_;
		_tmp28_ = json_object_new ();
		_json_object_unref0 (_tmp26_);
		_tmp26_ = _tmp28_;
	}
	_tmp29_ = _tmp26_;
	_tmp26_ = NULL;
	config = _tmp29_;
	_tmp30_ = config;
	do_first_run = tee_jee_json_helper_json_get_bool (_tmp30_, "do_first_run", FALSE);
	_tmp31_ = config;
	self->btrfs_mode = tee_jee_json_helper_json_get_bool (_tmp31_, "btrfs_mode", FALSE);
	if (do_first_run) {
		main_set_first_run_flag (self);
	}
	_tmp32_ = config;
	if (json_object_has_member (_tmp32_, "include_btrfs_home")) {
		JsonObject* _tmp33_;
		_tmp33_ = config;
		self->include_btrfs_home_for_backup = tee_jee_json_helper_json_get_bool (_tmp33_, "include_btrfs_home", self->include_btrfs_home_for_backup);
	} else {
		JsonObject* _tmp34_;
		_tmp34_ = config;
		self->include_btrfs_home_for_backup = tee_jee_json_helper_json_get_bool (_tmp34_, "include_btrfs_home_for_backup", self->include_btrfs_home_for_backup);
	}
	_tmp35_ = config;
	self->include_btrfs_home_for_restore = tee_jee_json_helper_json_get_bool (_tmp35_, "include_btrfs_home_for_restore", self->include_btrfs_home_for_restore);
	_tmp36_ = config;
	self->stop_cron_emails = tee_jee_json_helper_json_get_bool (_tmp36_, "stop_cron_emails", self->stop_cron_emails);
	_tmp37_ = self->cmd_btrfs_mode;
	if (_tmp37_ != NULL) {
		gboolean* _tmp38_;
		_tmp38_ = self->cmd_btrfs_mode;
		self->btrfs_mode = *_tmp38_;
	}
	_tmp39_ = config;
	_tmp40_ = self->backup_uuid;
	_tmp41_ = tee_jee_json_helper_json_get_string (_tmp39_, "backup_device_uuid", _tmp40_);
	_g_free0 (self->backup_uuid);
	self->backup_uuid = _tmp41_;
	_tmp42_ = config;
	_tmp43_ = self->backup_parent_uuid;
	_tmp44_ = tee_jee_json_helper_json_get_string (_tmp42_, "parent_device_uuid", _tmp43_);
	_g_free0 (self->backup_parent_uuid);
	self->backup_parent_uuid = _tmp44_;
	_tmp45_ = config;
	self->schedule_monthly = tee_jee_json_helper_json_get_bool (_tmp45_, "schedule_monthly", self->schedule_monthly);
	_tmp46_ = config;
	self->schedule_weekly = tee_jee_json_helper_json_get_bool (_tmp46_, "schedule_weekly", self->schedule_weekly);
	_tmp47_ = config;
	self->schedule_daily = tee_jee_json_helper_json_get_bool (_tmp47_, "schedule_daily", self->schedule_daily);
	_tmp48_ = config;
	self->schedule_hourly = tee_jee_json_helper_json_get_bool (_tmp48_, "schedule_hourly", self->schedule_hourly);
	_tmp49_ = config;
	self->schedule_boot = tee_jee_json_helper_json_get_bool (_tmp49_, "schedule_boot", self->schedule_boot);
	_tmp50_ = config;
	self->count_monthly = tee_jee_json_helper_json_get_int (_tmp50_, "count_monthly", self->count_monthly);
	_tmp51_ = config;
	self->count_weekly = tee_jee_json_helper_json_get_int (_tmp51_, "count_weekly", self->count_weekly);
	_tmp52_ = config;
	self->count_daily = tee_jee_json_helper_json_get_int (_tmp52_, "count_daily", self->count_daily);
	_tmp53_ = config;
	self->count_hourly = tee_jee_json_helper_json_get_int (_tmp53_, "count_hourly", self->count_hourly);
	_tmp54_ = config;
	self->count_boot = tee_jee_json_helper_json_get_int (_tmp54_, "count_boot", self->count_boot);
	_tmp55_ = config;
	_tmp56_ = tee_jee_json_helper_json_get_string (_tmp55_, "date_format", MAIN_date_format_default);
	_g_free0 (self->date_format);
	self->date_format = _tmp56_;
	_tmp57_ = config;
	main_first_snapshot_size = tee_jee_json_helper_json_get_uint64 (_tmp57_, "snapshot_size", main_first_snapshot_size);
	_tmp58_ = config;
	main_first_snapshot_count = (gint64) tee_jee_json_helper_json_get_uint64 (_tmp58_, "snapshot_count", (guint64) main_first_snapshot_count);
	_tmp59_ = self->exclude_list_user;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp59_);
	_tmp60_ = config;
	if (json_object_has_member (_tmp60_, "exclude")) {
		JsonObject* _tmp61_;
		JsonArray* _tmp62_;
		GList* _tmp63_;
		_tmp61_ = config;
		_tmp62_ = json_object_get_array_member (_tmp61_, "exclude");
		_tmp63_ = json_array_get_elements (_tmp62_);
		{
			GList* jnode_collection = NULL;
			GList* jnode_it = NULL;
			jnode_collection = _tmp63_;
			for (jnode_it = jnode_collection; jnode_it != NULL; jnode_it = jnode_it->next) {
				JsonNode* _tmp64_;
				JsonNode* jnode = NULL;
				_tmp64_ = __vala_JsonNode_copy0 ((JsonNode*) jnode_it->data);
				jnode = _tmp64_;
				{
					gchar* path = NULL;
					JsonNode* _tmp65_;
					const gchar* _tmp66_;
					gchar* _tmp67_;
					gboolean _tmp68_ = FALSE;
					gboolean _tmp69_ = FALSE;
					GeeArrayList* _tmp70_;
					const gchar* _tmp71_;
					_tmp65_ = jnode;
					_tmp66_ = json_node_get_string (_tmp65_);
					_tmp67_ = g_strdup (_tmp66_);
					path = _tmp67_;
					_tmp70_ = self->exclude_list_user;
					_tmp71_ = path;
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp70_, _tmp71_)) {
						GeeArrayList* _tmp72_;
						const gchar* _tmp73_;
						_tmp72_ = self->exclude_list_default;
						_tmp73_ = path;
						_tmp69_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp72_, _tmp73_);
					} else {
						_tmp69_ = FALSE;
					}
					if (_tmp69_) {
						GeeArrayList* _tmp74_;
						const gchar* _tmp75_;
						_tmp74_ = self->exclude_list_home;
						_tmp75_ = path;
						_tmp68_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp74_, _tmp75_);
					} else {
						_tmp68_ = FALSE;
					}
					if (_tmp68_) {
						GeeArrayList* _tmp76_;
						const gchar* _tmp77_;
						_tmp76_ = self->exclude_list_user;
						_tmp77_ = path;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp76_, _tmp77_);
					}
					_g_free0 (path);
					__vala_JsonNode_free0 (jnode);
				}
			}
			(jnode_collection == NULL) ? NULL : (jnode_collection = (g_list_free (jnode_collection), NULL));
		}
	}
	_tmp78_ = self->exclude_app_names;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp78_);
	_tmp79_ = config;
	if (json_object_has_member (_tmp79_, "exclude-apps")) {
		JsonArray* apps = NULL;
		JsonObject* _tmp80_;
		JsonArray* _tmp81_;
		JsonArray* _tmp82_;
		JsonArray* _tmp83_;
		GList* _tmp84_;
		_tmp80_ = config;
		_tmp81_ = json_object_get_array_member (_tmp80_, "exclude-apps");
		_tmp82_ = _json_array_ref0 (_tmp81_);
		apps = _tmp82_;
		_tmp83_ = apps;
		_tmp84_ = json_array_get_elements (_tmp83_);
		{
			GList* jnode_collection = NULL;
			GList* jnode_it = NULL;
			jnode_collection = _tmp84_;
			for (jnode_it = jnode_collection; jnode_it != NULL; jnode_it = jnode_it->next) {
				JsonNode* _tmp85_;
				JsonNode* jnode = NULL;
				_tmp85_ = __vala_JsonNode_copy0 ((JsonNode*) jnode_it->data);
				jnode = _tmp85_;
				{
					gchar* name = NULL;
					JsonNode* _tmp86_;
					const gchar* _tmp87_;
					gchar* _tmp88_;
					GeeArrayList* _tmp89_;
					const gchar* _tmp90_;
					_tmp86_ = jnode;
					_tmp87_ = json_node_get_string (_tmp86_);
					_tmp88_ = g_strdup (_tmp87_);
					name = _tmp88_;
					_tmp89_ = self->exclude_app_names;
					_tmp90_ = name;
					if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp89_, _tmp90_)) {
						GeeArrayList* _tmp91_;
						const gchar* _tmp92_;
						_tmp91_ = self->exclude_app_names;
						_tmp92_ = name;
						gee_abstract_collection_add ((GeeAbstractCollection*) _tmp91_, _tmp92_);
					}
					_g_free0 (name);
					__vala_JsonNode_free0 (jnode);
				}
			}
			(jnode_collection == NULL) ? NULL : (jnode_collection = (g_list_free (jnode_collection), NULL));
		}
		_json_array_unref0 (apps);
	}
	_tmp94_ = self->app_mode;
	if (g_strcmp0 (_tmp94_, "") == 0) {
		_tmp93_ = TRUE;
	} else {
		_tmp93_ = tee_jee_logging_LOG_DEBUG;
	}
	if (_tmp93_) {
		const gchar* _tmp95_;
		gchar* _tmp96_;
		gchar* _tmp97_;
		gchar* _tmp98_;
		gchar* _tmp99_;
		_tmp95_ = self->app_conf_path;
		_tmp96_ = g_strdup_printf (": %s", _tmp95_);
		_tmp97_ = _tmp96_;
		_tmp98_ = g_strconcat (_ ("App config loaded"), _tmp97_, NULL);
		_tmp99_ = _tmp98_;
		tee_jee_logging_log_msg (_tmp99_, FALSE);
		_g_free0 (_tmp99_);
		_g_free0 (_tmp97_);
	}
	_json_object_unref0 (config);
	_json_object_unref0 (_tmp26_);
	__vala_JsonNode_free0 (node);
	_g_object_unref0 (parser);
	_g_object_unref0 (f);
}

static gboolean
_bool_equal (const gboolean * s1,
             const gboolean * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

void
main_set_first_run_flag (Main* self)
{
	gboolean _tmp0_ = FALSE;
	GeeHashMap* _tmp1_;
	gboolean supported = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	self->first_run = TRUE;
	tee_jee_logging_log_msg ("First run mode (config file not found)", FALSE);
	_tmp1_ = self->sys_subvolumes;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, "@")) {
		_tmp0_ = tee_jee_process_helper_cmd_exists ("btrfs");
	} else {
		_tmp0_ = FALSE;
	}
	supported = _tmp0_;
	if (supported) {
		_tmp2_ = TRUE;
	} else {
		gboolean* _tmp3_;
		gboolean _tmp4_;
		_tmp3_ = self->cmd_btrfs_mode;
		_tmp4_ = TRUE;
		_tmp2_ = _bool_equal (_tmp3_, &_tmp4_) == TRUE;
	}
	if (_tmp2_) {
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = g_strdup_printf (": %s", "BTRFS");
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strconcat (_ ("Selected default snapshot type"), _tmp6_, NULL);
		_tmp8_ = _tmp7_;
		tee_jee_logging_log_msg (_tmp8_, FALSE);
		_g_free0 (_tmp8_);
		_g_free0 (_tmp6_);
		self->btrfs_mode = TRUE;
	} else {
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp9_ = g_strdup_printf (": %s", "RSYNC");
		_tmp10_ = _tmp9_;
		_tmp11_ = g_strconcat (_ ("Selected default snapshot type"), _tmp10_, NULL);
		_tmp12_ = _tmp11_;
		tee_jee_logging_log_msg (_tmp12_, FALSE);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp10_);
		self->btrfs_mode = FALSE;
	}
}

void
main_initialize_repo (Main* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("Main: initialize_repo()");
	_tmp0_ = self->backup_uuid;
	_tmp1_ = g_strdup_printf ("backup_uuid=%s", _tmp0_);
	_tmp2_ = _tmp1_;
	tee_jee_logging_log_debug (_tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->backup_parent_uuid;
	_tmp4_ = g_strdup_printf ("backup_parent_uuid=%s", _tmp3_);
	_tmp5_ = _tmp4_;
	tee_jee_logging_log_debug (_tmp5_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->app_mode;
	if (g_strcmp0 (_tmp8_, "backup") == 0) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_;
		_tmp9_ = self->app_mode;
		_tmp7_ = g_strcmp0 (_tmp9_, "ondemand") == 0;
	}
	if (_tmp7_) {
		_tmp6_ = self->btrfs_mode;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		Device* _tmp10_;
		_tmp10_ = self->sys_root;
		if (_tmp10_ != NULL) {
			const gchar* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			Device* _tmp14_;
			GtkWindow* _tmp15_;
			SnapshotRepo* _tmp16_;
			tee_jee_logging_log_msg ("Using system disk as snapshot device for creating snapshots in BTRFS m" \
"ode", FALSE);
			_tmp11_ = self->cmd_backup_device;
			_tmp12_ = strlen (_tmp11_);
			_tmp13_ = _tmp12_;
			if (_tmp13_ > 0) {
				tee_jee_logging_log_msg (_ ("Option --snapshot-device should not be specified for creating snapshot" \
"s in BTRFS mode"), FALSE);
			}
			_tmp14_ = self->sys_root;
			_tmp15_ = self->parent_window;
			_tmp16_ = snapshot_repo_new_from_device (_tmp14_, _tmp15_, self->btrfs_mode);
			_g_object_unref0 (self->repo);
			self->repo = _tmp16_;
		} else {
			tee_jee_logging_log_error ("System disk not found!", FALSE, FALSE);
			main_exit_app (self, 1);
		}
	} else {
		const gchar* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		_tmp17_ = self->cmd_backup_device;
		_tmp18_ = strlen (_tmp17_);
		_tmp19_ = _tmp18_;
		if (_tmp19_ > 0) {
			Device* cmd_dev = NULL;
			const gchar* _tmp20_;
			Device* _tmp21_;
			Device* _tmp22_;
			_tmp20_ = self->cmd_backup_device;
			_tmp21_ = device_get_device_by_name (_tmp20_);
			cmd_dev = _tmp21_;
			_tmp22_ = cmd_dev;
			if (_tmp22_ != NULL) {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gchar* _tmp25_;
				Device* _tmp26_;
				GtkWindow* _tmp27_;
				SnapshotRepo* _tmp28_;
				_tmp23_ = self->cmd_backup_device;
				_tmp24_ = g_strdup_printf ("Using snapshot device specified as command argument: %s", _tmp23_);
				_tmp25_ = _tmp24_;
				tee_jee_logging_log_debug (_tmp25_);
				_g_free0 (_tmp25_);
				_tmp26_ = cmd_dev;
				_tmp27_ = self->parent_window;
				_tmp28_ = snapshot_repo_new_from_device (_tmp26_, _tmp27_, self->btrfs_mode);
				_g_object_unref0 (self->repo);
				self->repo = _tmp28_;
			} else {
				const gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				_tmp29_ = self->cmd_backup_device;
				_tmp30_ = g_strdup_printf (": '%s'", _tmp29_);
				_tmp31_ = _tmp30_;
				_tmp32_ = g_strconcat (_ ("Device not found"), _tmp31_, NULL);
				_tmp33_ = _tmp32_;
				tee_jee_logging_log_error (_tmp33_, FALSE, FALSE);
				_g_free0 (_tmp33_);
				_g_free0 (_tmp31_);
				main_exit_app (self, 1);
			}
			_g_object_unref0 (cmd_dev);
		} else {
			gboolean _tmp34_ = FALSE;
			if (self->first_run) {
				const gchar* _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				_tmp35_ = self->backup_uuid;
				_tmp36_ = strlen (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp34_ = _tmp37_ == 0;
			} else {
				_tmp34_ = FALSE;
			}
			if (_tmp34_) {
				GtkWindow* _tmp38_;
				gboolean _tmp39_ = FALSE;
				SnapshotRepo* _tmp40_;
				_tmp38_ = self->parent_window;
				main_try_select_default_device_for_backup (self, _tmp38_);
				_tmp40_ = self->repo;
				if (_tmp40_ != NULL) {
					SnapshotRepo* _tmp41_;
					Device* _tmp42_;
					_tmp41_ = self->repo;
					_tmp42_ = _tmp41_->device;
					_tmp39_ = _tmp42_ != NULL;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					SnapshotRepo* _tmp43_;
					Device* _tmp44_;
					const gchar* _tmp45_;
					gchar* _tmp46_;
					gchar* _tmp47_;
					gchar* _tmp48_;
					gchar* _tmp49_;
					_tmp43_ = self->repo;
					_tmp44_ = _tmp43_->device;
					_tmp45_ = _tmp44_->device;
					_tmp46_ = g_strdup_printf (": %s", _tmp45_);
					_tmp47_ = _tmp46_;
					_tmp48_ = g_strconcat (_ ("Selected default snapshot device"), _tmp47_, NULL);
					_tmp49_ = _tmp48_;
					tee_jee_logging_log_msg (_tmp49_, FALSE);
					_g_free0 (_tmp49_);
					_g_free0 (_tmp47_);
				}
			} else {
				Device* dev = NULL;
				Device* dev_parent = NULL;
				gboolean _tmp50_ = FALSE;
				const gchar* _tmp51_;
				gboolean _tmp57_ = FALSE;
				const gchar* _tmp58_;
				gboolean _tmp64_ = FALSE;
				gboolean _tmp65_ = FALSE;
				Device* _tmp66_;
				tee_jee_logging_log_debug ("Setting snapshot device from config file");
				dev = NULL;
				dev_parent = NULL;
				_tmp51_ = self->backup_uuid;
				if (_tmp51_ != NULL) {
					const gchar* _tmp52_;
					gint _tmp53_;
					gint _tmp54_;
					_tmp52_ = self->backup_uuid;
					_tmp53_ = strlen (_tmp52_);
					_tmp54_ = _tmp53_;
					_tmp50_ = _tmp54_ > 0;
				} else {
					_tmp50_ = FALSE;
				}
				if (_tmp50_) {
					const gchar* _tmp55_;
					Device* _tmp56_;
					_tmp55_ = self->backup_uuid;
					_tmp56_ = device_get_device_by_uuid (_tmp55_);
					_g_object_unref0 (dev);
					dev = _tmp56_;
				}
				_tmp58_ = self->backup_parent_uuid;
				if (_tmp58_ != NULL) {
					const gchar* _tmp59_;
					gint _tmp60_;
					gint _tmp61_;
					_tmp59_ = self->backup_parent_uuid;
					_tmp60_ = strlen (_tmp59_);
					_tmp61_ = _tmp60_;
					_tmp57_ = _tmp61_ > 0;
				} else {
					_tmp57_ = FALSE;
				}
				if (_tmp57_) {
					const gchar* _tmp62_;
					Device* _tmp63_;
					_tmp62_ = self->backup_parent_uuid;
					_tmp63_ = device_get_device_by_uuid (_tmp62_);
					_g_object_unref0 (dev_parent);
					dev_parent = _tmp63_;
				}
				_tmp66_ = dev_parent;
				if (_tmp66_ != NULL) {
					Device* _tmp67_;
					_tmp67_ = dev_parent;
					_tmp65_ = device_is_encrypted_partition (_tmp67_);
				} else {
					_tmp65_ = FALSE;
				}
				if (_tmp65_) {
					Device* _tmp68_;
					_tmp68_ = dev_parent;
					_tmp64_ = !device_has_children (_tmp68_);
				} else {
					_tmp64_ = FALSE;
				}
				if (_tmp64_) {
					const gchar* _tmp69_;
					GtkWindow* _tmp70_;
					SnapshotRepo* _tmp71_;
					tee_jee_logging_log_debug ("Snapshot device is on an encrypted partition");
					_tmp69_ = self->backup_parent_uuid;
					_tmp70_ = self->parent_window;
					_tmp71_ = snapshot_repo_new_from_uuid (_tmp69_, _tmp70_, self->btrfs_mode);
					_g_object_unref0 (self->repo);
					self->repo = _tmp71_;
				} else {
					Device* _tmp72_;
					_tmp72_ = dev;
					if (_tmp72_ != NULL) {
						const gchar* _tmp73_;
						GtkWindow* _tmp74_;
						SnapshotRepo* _tmp75_;
						tee_jee_logging_log_debug ("repo: creating from uuid");
						_tmp73_ = self->backup_uuid;
						_tmp74_ = self->parent_window;
						_tmp75_ = snapshot_repo_new_from_uuid (_tmp73_, _tmp74_, self->btrfs_mode);
						_g_object_unref0 (self->repo);
						self->repo = _tmp75_;
					}
				}
				_g_object_unref0 (dev_parent);
				_g_object_unref0 (dev);
			}
		}
	}
	tee_jee_logging_log_debug ("Main: initialize_repo(): exit");
}

void
main_update_partitions (Main* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp23_;
	gint _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("update_partitions()");
	_tmp0_ = self->partitions;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = device_get_filesystems (TRUE, TRUE);
	_g_object_unref0 (self->partitions);
	self->partitions = _tmp1_;
	{
		GeeArrayList* _pi_list = NULL;
		GeeArrayList* _tmp2_;
		gint _pi_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pi_index = 0;
		_tmp2_ = self->partitions;
		_pi_list = _tmp2_;
		_tmp3_ = _pi_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pi_size = _tmp5_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			Device* pi = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gboolean _tmp10_ = FALSE;
			gboolean _tmp11_ = FALSE;
			SnapshotRepo* _tmp12_;
			_pi_index = _pi_index + 1;
			_tmp6_ = _pi_index;
			_tmp7_ = _pi_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pi_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _pi_index);
			pi = (Device*) _tmp9_;
			_tmp12_ = self->repo;
			if (_tmp12_ != NULL) {
				SnapshotRepo* _tmp13_;
				Device* _tmp14_;
				_tmp13_ = self->repo;
				_tmp14_ = _tmp13_->device;
				_tmp11_ = _tmp14_ != NULL;
			} else {
				_tmp11_ = FALSE;
			}
			if (_tmp11_) {
				Device* _tmp15_;
				const gchar* _tmp16_;
				SnapshotRepo* _tmp17_;
				Device* _tmp18_;
				const gchar* _tmp19_;
				_tmp15_ = pi;
				_tmp16_ = _tmp15_->uuid;
				_tmp17_ = self->repo;
				_tmp18_ = _tmp17_->device;
				_tmp19_ = _tmp18_->uuid;
				_tmp10_ = g_strcmp0 (_tmp16_, _tmp19_) == 0;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				SnapshotRepo* _tmp20_;
				Device* _tmp21_;
				Device* _tmp22_;
				_tmp20_ = self->repo;
				_tmp21_ = pi;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				_g_object_unref0 (_tmp20_->device);
				_tmp20_->device = _tmp22_;
			}
			_g_object_unref0 (pi);
		}
	}
	_tmp23_ = self->partitions;
	_tmp24_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp23_);
	_tmp25_ = _tmp24_;
	if (_tmp25_ == 0) {
		gchar* _tmp26_;
		gchar* _tmp27_;
		_tmp26_ = g_strconcat ("ts: ", _ ("Failed to get partition list."), NULL);
		_tmp27_ = _tmp26_;
		tee_jee_logging_log_error (_tmp27_, FALSE, FALSE);
		_g_free0 (_tmp27_);
	}
	tee_jee_logging_log_debug ("partition list updated");
}

void
main_detect_system_devices (Main* self)
{
	GtkWindow* _tmp137_;
	GeeHashMap* _tmp138_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("detect_system_devices()");
	_g_object_unref0 (self->sys_root);
	self->sys_root = NULL;
	_g_object_unref0 (self->sys_boot);
	self->sys_boot = NULL;
	_g_object_unref0 (self->sys_efi);
	self->sys_efi = NULL;
	_g_object_unref0 (self->sys_home);
	self->sys_home = NULL;
	{
		GeeArrayList* _pi_list = NULL;
		GeeArrayList* _tmp0_;
		gint _pi_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _pi_index = 0;
		_tmp0_ = self->partitions;
		_pi_list = _tmp0_;
		_tmp1_ = _pi_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_pi_size = _tmp3_;
		_pi_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			Device* pi = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			_pi_index = _pi_index + 1;
			_tmp4_ = _pi_index;
			_tmp5_ = _pi_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _pi_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _pi_index);
			pi = (Device*) _tmp7_;
			{
				GeeArrayList* _mp_list = NULL;
				Device* _tmp8_;
				GeeArrayList* _tmp9_;
				gint _mp_size = 0;
				GeeArrayList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				gint _mp_index = 0;
				_tmp8_ = pi;
				_tmp9_ = _tmp8_->mount_points;
				_mp_list = _tmp9_;
				_tmp10_ = _mp_list;
				_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
				_tmp12_ = _tmp11_;
				_mp_size = _tmp12_;
				_mp_index = -1;
				while (TRUE) {
					gint _tmp13_;
					gint _tmp14_;
					MountEntry* mp = NULL;
					GeeArrayList* _tmp15_;
					gpointer _tmp16_;
					gboolean _tmp17_ = FALSE;
					Device* _tmp18_;
					const gchar* _tmp19_;
					MountEntry* _tmp25_;
					const gchar* _tmp26_;
					MountEntry* _tmp53_;
					const gchar* _tmp54_;
					MountEntry* _tmp81_;
					const gchar* _tmp82_;
					MountEntry* _tmp109_;
					const gchar* _tmp110_;
					_mp_index = _mp_index + 1;
					_tmp13_ = _mp_index;
					_tmp14_ = _mp_size;
					if (!(_tmp13_ < _tmp14_)) {
						break;
					}
					_tmp15_ = _mp_list;
					_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _mp_index);
					mp = (MountEntry*) _tmp16_;
					_tmp18_ = pi;
					_tmp19_ = _tmp18_->type;
					if (g_strcmp0 (_tmp19_, "loop") == 0) {
						_tmp17_ = TRUE;
					} else {
						gboolean _tmp20_ = FALSE;
						Device* _tmp21_;
						_tmp21_ = pi;
						if (device_has_parent (_tmp21_)) {
							Device* _tmp22_;
							Device* _tmp23_;
							const gchar* _tmp24_;
							_tmp22_ = pi;
							_tmp23_ = _tmp22_->parent;
							_tmp24_ = _tmp23_->type;
							_tmp20_ = g_strcmp0 (_tmp24_, "loop") == 0;
						} else {
							_tmp20_ = FALSE;
						}
						_tmp17_ = _tmp20_;
					}
					if (_tmp17_) {
						_g_object_unref0 (mp);
						continue;
					}
					_tmp25_ = mp;
					_tmp26_ = _tmp25_->mount_point;
					if (g_strcmp0 (_tmp26_, "/") == 0) {
						Device* _tmp27_;
						Device* _tmp28_;
						gboolean _tmp29_ = FALSE;
						const gchar* _tmp30_;
						_tmp27_ = pi;
						_tmp28_ = _g_object_ref0 (_tmp27_);
						_g_object_unref0 (self->sys_root);
						self->sys_root = _tmp28_;
						_tmp30_ = self->app_mode;
						if (g_strcmp0 (_tmp30_, "") == 0) {
							_tmp29_ = TRUE;
						} else {
							_tmp29_ = tee_jee_logging_LOG_DEBUG;
						}
						if (_tmp29_) {
							gchar* txt = NULL;
							Device* _tmp31_;
							const gchar* _tmp32_;
							Device* _tmp33_;
							const gchar* _tmp34_;
							gchar* _tmp35_;
							gchar* _tmp36_;
							gchar* _tmp37_;
							gchar* _tmp38_;
							MountEntry* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							gint _tmp42_;
							gint _tmp43_;
							gboolean _tmp44_;
							const gchar* _tmp52_;
							_tmp31_ = pi;
							_tmp32_ = _tmp31_->device;
							_tmp33_ = pi;
							_tmp34_ = _tmp33_->uuid;
							_tmp35_ = g_strdup_printf (": %s, UUID=%s", _tmp32_, _tmp34_);
							_tmp36_ = _tmp35_;
							_tmp37_ = g_strconcat (_ ("/ is mapped to device"), _tmp36_, NULL);
							_tmp38_ = _tmp37_;
							_g_free0 (_tmp36_);
							txt = _tmp38_;
							_tmp39_ = mp;
							_tmp40_ = mount_entry_subvolume_name (_tmp39_);
							_tmp41_ = _tmp40_;
							_tmp42_ = strlen (_tmp41_);
							_tmp43_ = _tmp42_;
							_tmp44_ = _tmp43_ > 0;
							_g_free0 (_tmp41_);
							if (_tmp44_) {
								const gchar* _tmp45_;
								MountEntry* _tmp46_;
								gchar* _tmp47_;
								gchar* _tmp48_;
								gchar* _tmp49_;
								gchar* _tmp50_;
								gchar* _tmp51_;
								_tmp45_ = txt;
								_tmp46_ = mp;
								_tmp47_ = mount_entry_subvolume_name (_tmp46_);
								_tmp48_ = _tmp47_;
								_tmp49_ = g_strdup_printf (", subvol=%s", _tmp48_);
								_tmp50_ = _tmp49_;
								_tmp51_ = g_strconcat (_tmp45_, _tmp50_, NULL);
								_g_free0 (txt);
								txt = _tmp51_;
								_g_free0 (_tmp50_);
								_g_free0 (_tmp48_);
							}
							_tmp52_ = txt;
							tee_jee_logging_log_debug (_tmp52_);
							_g_free0 (txt);
						}
					}
					_tmp53_ = mp;
					_tmp54_ = _tmp53_->mount_point;
					if (g_strcmp0 (_tmp54_, "/home") == 0) {
						Device* _tmp55_;
						Device* _tmp56_;
						gboolean _tmp57_ = FALSE;
						const gchar* _tmp58_;
						_tmp55_ = pi;
						_tmp56_ = _g_object_ref0 (_tmp55_);
						_g_object_unref0 (self->sys_home);
						self->sys_home = _tmp56_;
						_tmp58_ = self->app_mode;
						if (g_strcmp0 (_tmp58_, "") == 0) {
							_tmp57_ = TRUE;
						} else {
							_tmp57_ = tee_jee_logging_LOG_DEBUG;
						}
						if (_tmp57_) {
							gchar* txt = NULL;
							Device* _tmp59_;
							const gchar* _tmp60_;
							Device* _tmp61_;
							const gchar* _tmp62_;
							gchar* _tmp63_;
							gchar* _tmp64_;
							gchar* _tmp65_;
							gchar* _tmp66_;
							MountEntry* _tmp67_;
							gchar* _tmp68_;
							gchar* _tmp69_;
							gint _tmp70_;
							gint _tmp71_;
							gboolean _tmp72_;
							const gchar* _tmp80_;
							_tmp59_ = pi;
							_tmp60_ = _tmp59_->device;
							_tmp61_ = pi;
							_tmp62_ = _tmp61_->uuid;
							_tmp63_ = g_strdup_printf (": %s, UUID=%s", _tmp60_, _tmp62_);
							_tmp64_ = _tmp63_;
							_tmp65_ = g_strconcat (_ ("/home is mapped to device"), _tmp64_, NULL);
							_tmp66_ = _tmp65_;
							_g_free0 (_tmp64_);
							txt = _tmp66_;
							_tmp67_ = mp;
							_tmp68_ = mount_entry_subvolume_name (_tmp67_);
							_tmp69_ = _tmp68_;
							_tmp70_ = strlen (_tmp69_);
							_tmp71_ = _tmp70_;
							_tmp72_ = _tmp71_ > 0;
							_g_free0 (_tmp69_);
							if (_tmp72_) {
								const gchar* _tmp73_;
								MountEntry* _tmp74_;
								gchar* _tmp75_;
								gchar* _tmp76_;
								gchar* _tmp77_;
								gchar* _tmp78_;
								gchar* _tmp79_;
								_tmp73_ = txt;
								_tmp74_ = mp;
								_tmp75_ = mount_entry_subvolume_name (_tmp74_);
								_tmp76_ = _tmp75_;
								_tmp77_ = g_strdup_printf (", subvol=%s", _tmp76_);
								_tmp78_ = _tmp77_;
								_tmp79_ = g_strconcat (_tmp73_, _tmp78_, NULL);
								_g_free0 (txt);
								txt = _tmp79_;
								_g_free0 (_tmp78_);
								_g_free0 (_tmp76_);
							}
							_tmp80_ = txt;
							tee_jee_logging_log_debug (_tmp80_);
							_g_free0 (txt);
						}
					}
					_tmp81_ = mp;
					_tmp82_ = _tmp81_->mount_point;
					if (g_strcmp0 (_tmp82_, "/boot") == 0) {
						Device* _tmp83_;
						Device* _tmp84_;
						gboolean _tmp85_ = FALSE;
						const gchar* _tmp86_;
						_tmp83_ = pi;
						_tmp84_ = _g_object_ref0 (_tmp83_);
						_g_object_unref0 (self->sys_boot);
						self->sys_boot = _tmp84_;
						_tmp86_ = self->app_mode;
						if (g_strcmp0 (_tmp86_, "") == 0) {
							_tmp85_ = TRUE;
						} else {
							_tmp85_ = tee_jee_logging_LOG_DEBUG;
						}
						if (_tmp85_) {
							gchar* txt = NULL;
							Device* _tmp87_;
							const gchar* _tmp88_;
							Device* _tmp89_;
							const gchar* _tmp90_;
							gchar* _tmp91_;
							gchar* _tmp92_;
							gchar* _tmp93_;
							gchar* _tmp94_;
							MountEntry* _tmp95_;
							gchar* _tmp96_;
							gchar* _tmp97_;
							gint _tmp98_;
							gint _tmp99_;
							gboolean _tmp100_;
							const gchar* _tmp108_;
							_tmp87_ = pi;
							_tmp88_ = _tmp87_->device;
							_tmp89_ = pi;
							_tmp90_ = _tmp89_->uuid;
							_tmp91_ = g_strdup_printf (": %s, UUID=%s", _tmp88_, _tmp90_);
							_tmp92_ = _tmp91_;
							_tmp93_ = g_strconcat (_ ("/boot is mapped to device"), _tmp92_, NULL);
							_tmp94_ = _tmp93_;
							_g_free0 (_tmp92_);
							txt = _tmp94_;
							_tmp95_ = mp;
							_tmp96_ = mount_entry_subvolume_name (_tmp95_);
							_tmp97_ = _tmp96_;
							_tmp98_ = strlen (_tmp97_);
							_tmp99_ = _tmp98_;
							_tmp100_ = _tmp99_ > 0;
							_g_free0 (_tmp97_);
							if (_tmp100_) {
								const gchar* _tmp101_;
								MountEntry* _tmp102_;
								gchar* _tmp103_;
								gchar* _tmp104_;
								gchar* _tmp105_;
								gchar* _tmp106_;
								gchar* _tmp107_;
								_tmp101_ = txt;
								_tmp102_ = mp;
								_tmp103_ = mount_entry_subvolume_name (_tmp102_);
								_tmp104_ = _tmp103_;
								_tmp105_ = g_strdup_printf (", subvol=%s", _tmp104_);
								_tmp106_ = _tmp105_;
								_tmp107_ = g_strconcat (_tmp101_, _tmp106_, NULL);
								_g_free0 (txt);
								txt = _tmp107_;
								_g_free0 (_tmp106_);
								_g_free0 (_tmp104_);
							}
							_tmp108_ = txt;
							tee_jee_logging_log_debug (_tmp108_);
							_g_free0 (txt);
						}
					}
					_tmp109_ = mp;
					_tmp110_ = _tmp109_->mount_point;
					if (g_strcmp0 (_tmp110_, "/boot/efi") == 0) {
						Device* _tmp111_;
						Device* _tmp112_;
						gboolean _tmp113_ = FALSE;
						const gchar* _tmp114_;
						_tmp111_ = pi;
						_tmp112_ = _g_object_ref0 (_tmp111_);
						_g_object_unref0 (self->sys_efi);
						self->sys_efi = _tmp112_;
						_tmp114_ = self->app_mode;
						if (g_strcmp0 (_tmp114_, "") == 0) {
							_tmp113_ = TRUE;
						} else {
							_tmp113_ = tee_jee_logging_LOG_DEBUG;
						}
						if (_tmp113_) {
							gchar* txt = NULL;
							Device* _tmp115_;
							const gchar* _tmp116_;
							Device* _tmp117_;
							const gchar* _tmp118_;
							gchar* _tmp119_;
							gchar* _tmp120_;
							gchar* _tmp121_;
							gchar* _tmp122_;
							MountEntry* _tmp123_;
							gchar* _tmp124_;
							gchar* _tmp125_;
							gint _tmp126_;
							gint _tmp127_;
							gboolean _tmp128_;
							const gchar* _tmp136_;
							_tmp115_ = pi;
							_tmp116_ = _tmp115_->device;
							_tmp117_ = pi;
							_tmp118_ = _tmp117_->uuid;
							_tmp119_ = g_strdup_printf (": %s, UUID=%s", _tmp116_, _tmp118_);
							_tmp120_ = _tmp119_;
							_tmp121_ = g_strconcat (_ ("/boot/efi is mapped to device"), _tmp120_, NULL);
							_tmp122_ = _tmp121_;
							_g_free0 (_tmp120_);
							txt = _tmp122_;
							_tmp123_ = mp;
							_tmp124_ = mount_entry_subvolume_name (_tmp123_);
							_tmp125_ = _tmp124_;
							_tmp126_ = strlen (_tmp125_);
							_tmp127_ = _tmp126_;
							_tmp128_ = _tmp127_ > 0;
							_g_free0 (_tmp125_);
							if (_tmp128_) {
								const gchar* _tmp129_;
								MountEntry* _tmp130_;
								gchar* _tmp131_;
								gchar* _tmp132_;
								gchar* _tmp133_;
								gchar* _tmp134_;
								gchar* _tmp135_;
								_tmp129_ = txt;
								_tmp130_ = mp;
								_tmp131_ = mount_entry_subvolume_name (_tmp130_);
								_tmp132_ = _tmp131_;
								_tmp133_ = g_strdup_printf (", subvol=%s", _tmp132_);
								_tmp134_ = _tmp133_;
								_tmp135_ = g_strconcat (_tmp129_, _tmp134_, NULL);
								_g_free0 (txt);
								txt = _tmp135_;
								_g_free0 (_tmp134_);
								_g_free0 (_tmp132_);
							}
							_tmp136_ = txt;
							tee_jee_logging_log_debug (_tmp136_);
							_g_free0 (txt);
						}
					}
					_g_object_unref0 (mp);
				}
			}
			_g_object_unref0 (pi);
		}
	}
	_tmp137_ = self->parent_window;
	_tmp138_ = subvolume_detect_subvolumes_for_system_by_path ("/", NULL, _tmp137_);
	_g_object_unref0 (self->sys_subvolumes);
	self->sys_subvolumes = _tmp138_;
}

gboolean
main_mount_target_devices (Main* self,
                           GtkWindow* parent_win)
{
	Device* _tmp0_;
	Device* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	Device* _tmp5_;
	Device* _tmp6_;
	const gchar* _tmp7_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("mount_target_device()");
	_tmp0_ = main_get_dst_root (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->mount_point_app;
	_tmp3_ = g_strconcat (_tmp2_, "/restore", NULL);
	_g_free0 (self->mount_point_restore);
	self->mount_point_restore = _tmp3_;
	_tmp4_ = self->mount_point_restore;
	tee_jee_file_system_dir_create (_tmp4_, FALSE);
	main_unmount_target_device (self, TRUE);
	_tmp5_ = main_get_dst_root (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->fstype;
	if (g_strcmp0 (_tmp7_, "btrfs") == 0) {
		gboolean supported = FALSE;
		Device* _tmp8_;
		Device* _tmp9_;
		Device* _tmp10_;
		Device* _tmp11_;
		gboolean _tmp12_ = FALSE;
		_tmp8_ = main_get_dst_root (self);
		_tmp9_ = _tmp8_;
		_tmp10_ = main_get_dst_home (self);
		_tmp11_ = _tmp10_;
		supported = main_check_btrfs_layout (self, _tmp9_, _tmp11_, FALSE);
		if (!supported) {
			Snapshot* _tmp13_;
			_tmp13_ = self->snapshot_to_restore;
			_tmp12_ = snapshot_has_subvolumes (_tmp13_);
		} else {
			_tmp12_ = FALSE;
		}
		if (_tmp12_) {
			gchar* msg = NULL;
			gchar* _tmp14_;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			const gchar* _tmp17_;
			_tmp14_ = g_strconcat (_ ("The target partition has an unsupported subvolume layout."), "\n", NULL);
			msg = _tmp14_;
			_tmp15_ = msg;
			_tmp16_ = g_strconcat (_tmp15_, _ ("Only ubuntu-type layouts with @ and @home subvolumes are currently sup" \
"ported."), NULL);
			_g_free0 (msg);
			msg = _tmp16_;
			_tmp17_ = self->app_mode;
			if (g_strcmp0 (_tmp17_, "") == 0) {
				gchar* title = NULL;
				gchar* _tmp18_;
				const gchar* _tmp19_;
				const gchar* _tmp20_;
				_tmp18_ = g_strdup (_ ("Unsupported Subvolume Layout"));
				title = _tmp18_;
				_tmp19_ = title;
				_tmp20_ = msg;
				tee_jee_gtk_helper_gtk_messagebox (_tmp19_, _tmp20_, NULL, TRUE);
				_g_free0 (title);
			} else {
				const gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				_tmp21_ = msg;
				_tmp22_ = g_strconcat ("\n", _tmp21_, NULL);
				_tmp23_ = _tmp22_;
				tee_jee_logging_log_error (_tmp23_, FALSE, FALSE);
				_g_free0 (_tmp23_);
			}
			result = FALSE;
			_g_free0 (msg);
			return result;
		}
	}
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp24_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		gint _mnt_index = 0;
		_tmp24_ = self->mount_list;
		_mnt_list = _tmp24_;
		_tmp25_ = _mnt_list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_mnt_size = _tmp27_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp28_;
			gint _tmp29_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp30_;
			gpointer _tmp31_;
			MountEntry* _tmp32_;
			Device* _tmp33_;
			MountEntry* _tmp34_;
			Device* _tmp35_;
			gchar* mount_options = NULL;
			gchar* _tmp52_;
			MountEntry* _tmp53_;
			Device* _tmp54_;
			const gchar* _tmp55_;
			MountEntry* _tmp62_;
			Device* _tmp63_;
			const gchar* _tmp64_;
			const gchar* _tmp65_;
			MountEntry* _tmp66_;
			const gchar* _tmp67_;
			gchar* _tmp68_;
			gchar* _tmp69_;
			const gchar* _tmp70_;
			gboolean _tmp71_;
			_mnt_index = _mnt_index + 1;
			_tmp28_ = _mnt_index;
			_tmp29_ = _mnt_size;
			if (!(_tmp28_ < _tmp29_)) {
				break;
			}
			_tmp30_ = _mnt_list;
			_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, _mnt_index);
			mnt = (MountEntry*) _tmp31_;
			_tmp32_ = mnt;
			_tmp33_ = _tmp32_->device;
			if (_tmp33_ == NULL) {
				_g_object_unref0 (mnt);
				continue;
			}
			_tmp34_ = mnt;
			_tmp35_ = _tmp34_->device;
			if (device_is_encrypted_partition (_tmp35_)) {
				MountEntry* _tmp36_;
				Device* _tmp37_;
				_tmp36_ = mnt;
				_tmp37_ = _tmp36_->device;
				if (device_has_children (_tmp37_)) {
					MountEntry* _tmp38_;
					MountEntry* _tmp39_;
					Device* _tmp40_;
					GeeArrayList* _tmp41_;
					gpointer _tmp42_;
					_tmp38_ = mnt;
					_tmp39_ = mnt;
					_tmp40_ = _tmp39_->device;
					_tmp41_ = _tmp40_->children;
					_tmp42_ = gee_abstract_list_get ((GeeAbstractList*) _tmp41_, 0);
					_g_object_unref0 (_tmp38_->device);
					_tmp38_->device = (Device*) _tmp42_;
				} else {
					gchar* msg_out = NULL;
					gchar* msg_err = NULL;
					Device* dev_unlocked = NULL;
					MountEntry* _tmp43_;
					Device* _tmp44_;
					gchar* _tmp45_ = NULL;
					gchar* _tmp46_ = NULL;
					Device* _tmp47_;
					Device* _tmp48_;
					_tmp43_ = mnt;
					_tmp44_ = _tmp43_->device;
					_tmp47_ = device_luks_unlock (_tmp44_, "", "", parent_win, &_tmp45_, &_tmp46_);
					_g_free0 (msg_out);
					msg_out = _tmp45_;
					_g_free0 (msg_err);
					msg_err = _tmp46_;
					dev_unlocked = _tmp47_;
					_tmp48_ = dev_unlocked;
					if (_tmp48_ == NULL) {
						result = FALSE;
						_g_object_unref0 (dev_unlocked);
						_g_free0 (msg_err);
						_g_free0 (msg_out);
						_g_object_unref0 (mnt);
						return result;
					} else {
						MountEntry* _tmp49_;
						Device* _tmp50_;
						Device* _tmp51_;
						_tmp49_ = mnt;
						_tmp50_ = dev_unlocked;
						_tmp51_ = _g_object_ref0 (_tmp50_);
						_g_object_unref0 (_tmp49_->device);
						_tmp49_->device = _tmp51_;
					}
					_g_object_unref0 (dev_unlocked);
					_g_free0 (msg_err);
					_g_free0 (msg_out);
				}
			}
			_tmp52_ = g_strdup ("");
			mount_options = _tmp52_;
			_tmp53_ = mnt;
			_tmp54_ = _tmp53_->device;
			_tmp55_ = _tmp54_->fstype;
			if (g_strcmp0 (_tmp55_, "btrfs") == 0) {
				MountEntry* _tmp56_;
				const gchar* _tmp57_;
				_tmp56_ = mnt;
				_tmp57_ = _tmp56_->mount_point;
				if (g_strcmp0 (_tmp57_, "/") == 0) {
					gchar* _tmp58_;
					_tmp58_ = g_strdup ("subvol=@");
					_g_free0 (mount_options);
					mount_options = _tmp58_;
				}
				if (self->include_btrfs_home_for_restore) {
					MountEntry* _tmp59_;
					const gchar* _tmp60_;
					_tmp59_ = mnt;
					_tmp60_ = _tmp59_->mount_point;
					if (g_strcmp0 (_tmp60_, "/home") == 0) {
						gchar* _tmp61_;
						_tmp61_ = g_strdup ("subvol=@home");
						_g_free0 (mount_options);
						mount_options = _tmp61_;
					}
				}
			}
			_tmp62_ = mnt;
			_tmp63_ = _tmp62_->device;
			_tmp64_ = _tmp63_->uuid;
			_tmp65_ = self->mount_point_restore;
			_tmp66_ = mnt;
			_tmp67_ = _tmp66_->mount_point;
			_tmp68_ = g_strconcat (_tmp65_, _tmp67_, NULL);
			_tmp69_ = _tmp68_;
			_tmp70_ = mount_options;
			_tmp71_ = !device_mount (_tmp64_, _tmp69_, _tmp70_, FALSE);
			_g_free0 (_tmp69_);
			if (_tmp71_) {
				result = FALSE;
				_g_free0 (mount_options);
				_g_object_unref0 (mnt);
				return result;
			}
			_g_free0 (mount_options);
			_g_object_unref0 (mnt);
		}
	}
	result = TRUE;
	return result;
}

void
main_unmount_target_device (Main* self,
                            gboolean exit_on_error)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->mount_point_restore;
	if (_tmp0_ == NULL) {
		return;
	}
	tee_jee_logging_log_debug ("unmount_target_device()");
	_tmp1_ = self->mount_point_restore;
	_tmp2_ = self->mount_point_app;
	if (g_str_has_prefix (_tmp1_, _tmp2_)) {
		const gchar* _tmp3_;
		_tmp3_ = self->mount_point_restore;
		main_unmount_device (self, _tmp3_, exit_on_error);
	} else {
	}
}

gboolean
main_unmount_device (Main* self,
                     const gchar* mount_point,
                     gboolean exit_on_error)
{
	gboolean is_unmounted = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mount_point != NULL, FALSE);
	is_unmounted = device_unmount (mount_point);
	if (!is_unmounted) {
		if (exit_on_error) {
			const gchar* _tmp0_;
			_tmp0_ = self->app_mode;
			if (g_strcmp0 (_tmp0_, "") == 0) {
				gchar* title = NULL;
				gchar* _tmp1_;
				gchar* msg = NULL;
				gchar* _tmp2_;
				gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				const gchar* _tmp6_;
				const gchar* _tmp7_;
				_tmp1_ = g_strdup (_ ("Critical Error"));
				title = _tmp1_;
				_tmp2_ = g_strconcat (_ ("Failed to unmount device!"), "\n", NULL);
				_tmp3_ = _tmp2_;
				_tmp4_ = g_strconcat (_tmp3_, _ ("Application will exit"), NULL);
				_tmp5_ = _tmp4_;
				_g_free0 (_tmp3_);
				msg = _tmp5_;
				_tmp6_ = title;
				_tmp7_ = msg;
				tee_jee_gtk_helper_gtk_messagebox (_tmp6_, _tmp7_, NULL, TRUE);
				_g_free0 (msg);
				_g_free0 (title);
			}
			main_exit_app (self, 1);
		}
	}
	result = is_unmounted;
	return result;
}

SnapshotLocationStatus
main_check_backup_location (Main* self,
                            gchar** message,
                            gchar** details)
{
	gchar* _vala_message = NULL;
	gchar* _vala_details = NULL;
	SnapshotRepo* _tmp0_;
	SnapshotRepo* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	SnapshotRepo* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	SnapshotRepo* _tmp7_;
	SnapshotLocationStatus result;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->repo;
	snapshot_repo_check_status (_tmp0_);
	_tmp1_ = self->repo;
	_tmp2_ = _tmp1_->status_message;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (_vala_message);
	_vala_message = _tmp3_;
	_tmp4_ = self->repo;
	_tmp5_ = _tmp4_->status_details;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_vala_details);
	_vala_details = _tmp6_;
	_tmp7_ = self->repo;
	result = _tmp7_->status_code;
	if (message) {
		*message = _vala_message;
	} else {
		_g_free0 (_vala_message);
	}
	if (details) {
		*details = _vala_details;
	} else {
		_g_free0 (_vala_details);
	}
	return result;
}

gboolean
main_check_btrfs_volume (Main* self,
                         Device* dev,
                         const gchar* subvol_names,
                         gboolean unlock)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* mnt_btrfs = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gboolean supported = FALSE;
	gchar** _tmp17_;
	gchar** _tmp18_;
	const gchar* _tmp25_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	g_return_val_if_fail (subvol_names != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("check_btrfs_volume():%s", subvol_names);
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->mount_point_app;
	_tmp3_ = g_strconcat (_tmp2_, "/btrfs", NULL);
	mnt_btrfs = _tmp3_;
	_tmp4_ = mnt_btrfs;
	tee_jee_file_system_dir_create (_tmp4_, FALSE);
	_tmp5_ = mnt_btrfs;
	if (!device_is_mounted_at_path (dev, "", _tmp5_)) {
		const gchar* _tmp6_;
		_tmp6_ = mnt_btrfs;
		device_unmount (_tmp6_);
		if (device_is_encrypted_partition (dev)) {
			if (unlock) {
				gchar* msg_out = NULL;
				gchar* msg_err = NULL;
				Device* dev_unlocked = NULL;
				GtkWindow* _tmp7_;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				Device* _tmp10_;
				Device* _tmp11_;
				_tmp7_ = self->parent_window;
				_tmp10_ = device_luks_unlock (dev, "", "", _tmp7_, &_tmp8_, &_tmp9_);
				_g_free0 (msg_out);
				msg_out = _tmp8_;
				_g_free0 (msg_err);
				msg_err = _tmp9_;
				dev_unlocked = _tmp10_;
				_tmp11_ = dev_unlocked;
				if (_tmp11_ == NULL) {
					tee_jee_logging_log_debug ("device is null");
					tee_jee_logging_log_debug ("SnapshotRepo: check_btrfs_volume(): exit");
					result = FALSE;
					_g_object_unref0 (dev_unlocked);
					_g_free0 (msg_err);
					_g_free0 (msg_out);
					_g_free0 (mnt_btrfs);
					return result;
				} else {
					Device* _tmp12_;
					const gchar* _tmp13_;
					const gchar* _tmp14_;
					_tmp12_ = dev_unlocked;
					_tmp13_ = _tmp12_->uuid;
					_tmp14_ = mnt_btrfs;
					device_mount (_tmp13_, _tmp14_, "subvolid=0", TRUE);
				}
				_g_object_unref0 (dev_unlocked);
				_g_free0 (msg_err);
				_g_free0 (msg_out);
			} else {
				result = FALSE;
				_g_free0 (mnt_btrfs);
				return result;
			}
		} else {
			const gchar* _tmp15_;
			const gchar* _tmp16_;
			_tmp15_ = dev->uuid;
			_tmp16_ = mnt_btrfs;
			device_mount (_tmp15_, _tmp16_, "subvolid=0", TRUE);
		}
	}
	supported = TRUE;
	_tmp18_ = _tmp17_ = g_strsplit (subvol_names, ",", 0);
	{
		gchar** subvol_name_collection = NULL;
		gint subvol_name_collection_length1 = 0;
		gint _subvol_name_collection_size_ = 0;
		gint subvol_name_it = 0;
		subvol_name_collection = _tmp18_;
		subvol_name_collection_length1 = _vala_array_length (_tmp17_);
		for (subvol_name_it = 0; subvol_name_it < subvol_name_collection_length1; subvol_name_it = subvol_name_it + 1) {
			gchar* _tmp19_;
			gchar* subvol_name = NULL;
			_tmp19_ = g_strdup (subvol_name_collection[subvol_name_it]);
			subvol_name = _tmp19_;
			{
				gboolean _tmp20_ = FALSE;
				if (supported) {
					const gchar* _tmp21_;
					const gchar* _tmp22_;
					gchar* _tmp23_;
					gchar* _tmp24_;
					_tmp21_ = mnt_btrfs;
					_tmp22_ = subvol_name;
					_tmp23_ = tee_jee_file_system_path_combine (_tmp21_, _tmp22_);
					_tmp24_ = _tmp23_;
					_tmp20_ = tee_jee_file_system_dir_exists (_tmp24_);
					_g_free0 (_tmp24_);
				} else {
					_tmp20_ = FALSE;
				}
				supported = _tmp20_;
				_g_free0 (subvol_name);
			}
		}
		subvol_name_collection = (_vala_array_free (subvol_name_collection, subvol_name_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp25_ = mnt_btrfs;
	if (device_unmount (_tmp25_)) {
		gboolean _tmp26_ = FALSE;
		const gchar* _tmp27_;
		_tmp27_ = mnt_btrfs;
		if (tee_jee_file_system_dir_exists (_tmp27_)) {
			const gchar* _tmp28_;
			_tmp28_ = mnt_btrfs;
			_tmp26_ = tee_jee_file_system_dir_is_empty (_tmp28_);
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			const gchar* _tmp29_;
			const gchar* _tmp30_;
			gchar* _tmp31_;
			gchar* _tmp32_;
			_tmp29_ = mnt_btrfs;
			tee_jee_file_system_dir_delete (_tmp29_, FALSE);
			_tmp30_ = mnt_btrfs;
			_tmp31_ = g_strdup_printf (_ ("Removed mount directory: '%s'"), _tmp30_);
			_tmp32_ = _tmp31_;
			tee_jee_logging_log_debug (_tmp32_);
			_g_free0 (_tmp32_);
		}
	}
	result = supported;
	_g_free0 (mnt_btrfs);
	return result;
}

void
main_try_select_default_device_for_backup (Main* self,
                                           GtkWindow* parent_win)
{
	SnapshotRepo* _tmp0_;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("try_select_default_device_for_backup()");
	_tmp0_ = self->repo;
	if (snapshot_repo_available (_tmp0_)) {
		SnapshotRepo* _tmp1_;
		Device* _tmp2_;
		_tmp1_ = self->repo;
		_tmp2_ = _tmp1_->device;
		if (main_check_device_for_backup (self, _tmp2_, FALSE)) {
			SnapshotRepo* _tmp3_;
			_tmp3_ = self->repo;
			if (_tmp3_->btrfs_mode != self->btrfs_mode) {
				SnapshotRepo* _tmp4_;
				Device* _tmp5_;
				SnapshotRepo* _tmp6_;
				_tmp4_ = self->repo;
				_tmp5_ = _tmp4_->device;
				_tmp6_ = snapshot_repo_new_from_device (_tmp5_, parent_win, self->btrfs_mode);
				_g_object_unref0 (self->repo);
				self->repo = _tmp6_;
			}
			return;
		} else {
			SnapshotRepo* _tmp7_;
			_tmp7_ = snapshot_repo_new_from_null ();
			_g_object_unref0 (self->repo);
			self->repo = _tmp7_;
		}
	}
	main_update_partitions (self);
	if (self->btrfs_mode) {
		GeeHashMap* _tmp9_;
		_tmp9_ = self->sys_subvolumes;
		_tmp8_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp9_, "@");
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		Subvolume* subvol_root = NULL;
		GeeHashMap* _tmp10_;
		gpointer _tmp11_;
		Subvolume* _tmp12_;
		Device* _tmp13_;
		Device* _tmp14_;
		SnapshotRepo* _tmp15_;
		_tmp10_ = self->sys_subvolumes;
		_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, "@");
		subvol_root = (Subvolume*) _tmp11_;
		_tmp12_ = subvol_root;
		_tmp13_ = subvolume_get_device (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = snapshot_repo_new_from_device (_tmp14_, parent_win, self->btrfs_mode);
		_g_object_unref0 (self->repo);
		self->repo = _tmp15_;
		_g_object_unref0 (_tmp14_);
		_g_object_unref0 (subvol_root);
		return;
	}
	{
		GeeArrayList* _dev_list = NULL;
		GeeArrayList* _tmp16_;
		gint _dev_size = 0;
		GeeArrayList* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
		gint _dev_index = 0;
		_tmp16_ = self->partitions;
		_dev_list = _tmp16_;
		_tmp17_ = _dev_list;
		_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
		_tmp19_ = _tmp18_;
		_dev_size = _tmp19_;
		_dev_index = -1;
		while (TRUE) {
			gint _tmp20_;
			gint _tmp21_;
			Device* dev = NULL;
			GeeArrayList* _tmp22_;
			gpointer _tmp23_;
			Device* _tmp24_;
			_dev_index = _dev_index + 1;
			_tmp20_ = _dev_index;
			_tmp21_ = _dev_size;
			if (!(_tmp20_ < _tmp21_)) {
				break;
			}
			_tmp22_ = _dev_list;
			_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _dev_index);
			dev = (Device*) _tmp23_;
			_tmp24_ = dev;
			if (main_check_device_for_backup (self, _tmp24_, FALSE)) {
				Device* _tmp25_;
				SnapshotRepo* _tmp26_;
				_tmp25_ = dev;
				_tmp26_ = snapshot_repo_new_from_device (_tmp25_, parent_win, self->btrfs_mode);
				_g_object_unref0 (self->repo);
				self->repo = _tmp26_;
				_g_object_unref0 (dev);
				break;
			} else {
				_g_object_unref0 (dev);
				continue;
			}
			_g_object_unref0 (dev);
		}
	}
}

gboolean
main_check_device_for_backup (Main* self,
                              Device* dev,
                              gboolean unlock)
{
	gboolean ok = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (dev != NULL, FALSE);
	ok = FALSE;
	_tmp0_ = dev->type;
	if (g_strcmp0 (_tmp0_, "disk") == 0) {
		result = FALSE;
		return result;
	}
	if (device_has_children (dev)) {
		result = FALSE;
		return result;
	}
	if (self->btrfs_mode) {
		gboolean _tmp2_ = FALSE;
		const gchar* _tmp3_;
		_tmp3_ = dev->fstype;
		if (g_strcmp0 (_tmp3_, "btrfs") == 0) {
			_tmp2_ = TRUE;
		} else {
			const gchar* _tmp4_;
			_tmp4_ = dev->fstype;
			_tmp2_ = g_strcmp0 (_tmp4_, "luks") == 0;
		}
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		if (main_check_btrfs_volume (self, dev, "@", unlock)) {
			result = TRUE;
			return result;
		}
	} else {
		gboolean _tmp5_ = FALSE;
		if (!self->btrfs_mode) {
			_tmp5_ = device_has_linux_filesystem (dev);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			result = TRUE;
			return result;
		}
	}
	result = ok;
	return result;
}

guint64
main_estimate_system_size (Main* self,
                           MainprogressCallback callback,
                           gpointer callback_target)
{
	gchar* dir_empty = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	RsyncTask* _tmp3_;
	RsyncTask* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	RsyncTask* _tmp11_;
	gchar* _tmp12_;
	RsyncTask* _tmp13_;
	RsyncTask* _tmp14_;
	RsyncTask* _tmp15_;
	const gchar* _tmp16_;
	gint _tmp17_;
	gint _tmp18_;
	RsyncTask* _tmp20_;
	RsyncTask* _tmp21_;
	RsyncTask* _tmp23_;
	RsyncTask* _tmp24_;
	gboolean _tmp25_ = FALSE;
	RsyncTask* _tmp26_;
	guint64 result;
	g_return_val_if_fail (self != NULL, 0ULL);
	tee_jee_logging_log_debug ("estimate_system_size()");
	if (main_first_snapshot_size > ((guint64) 0)) {
		result = main_first_snapshot_size;
		return result;
	} else {
		if (main_live_system (self)) {
			result = (guint64) 0;
			return result;
		}
	}
	_tmp0_ = tee_jee_process_helper_TEMP_DIR;
	_tmp1_ = tee_jee_file_system_path_combine (_tmp0_, "empty");
	dir_empty = _tmp1_;
	_tmp2_ = dir_empty;
	tee_jee_file_system_dir_create (_tmp2_, FALSE);
	_tmp3_ = rsync_task_new ();
	_g_object_unref0 (self->task);
	self->task = _tmp3_;
	_tmp4_ = self->task;
	_tmp5_ = dir_empty;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_tmp4_->dest_path);
	_tmp4_->dest_path = _tmp6_;
	_tmp8_ = tee_jee_process_helper_TEMP_DIR;
	_tmp9_ = main_save_exclude_list_for_backup (self, _tmp8_);
	_tmp7_ = _tmp9_;
	if (_tmp7_ == NULL) {
		gchar* _tmp10_;
		_tmp10_ = g_strdup ("");
		_g_free0 (_tmp7_);
		_tmp7_ = _tmp10_;
	}
	_tmp11_ = self->task;
	_tmp12_ = _tmp7_;
	_tmp7_ = NULL;
	_g_free0 (_tmp11_->exclude_from_file);
	_tmp11_->exclude_from_file = _tmp12_;
	_tmp13_ = self->task;
	_tmp13_->delete_extra = TRUE;
	_tmp14_ = self->task;
	_tmp14_->delete_excluded = TRUE;
	_tmp15_ = self->task;
	_tmp15_->delete_after = FALSE;
	_tmp16_ = self->app_mode;
	_tmp17_ = strlen (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_ > 0) {
		RsyncTask* _tmp19_;
		_tmp19_ = self->task;
		_tmp19_->io_nice = TRUE;
	}
	_tmp20_ = self->task;
	_tmp20_->dry_run = TRUE;
	_tmp21_ = self->task;
	async_task_execute ((AsyncTask*) _tmp21_);
	while (TRUE) {
		RsyncTask* _tmp22_;
		_tmp22_ = self->task;
		if (!(((AsyncTask*) _tmp22_)->status == APP_STATUS_RUNNING)) {
			break;
		}
		g_usleep (((gulong) G_TIME_SPAN_MILLISECOND) * 16);
		if (callback != NULL) {
			callback (callback_target);
		}
		tee_jee_gtk_helper_gtk_do_events ();
	}
	_tmp23_ = self->task;
	main_first_snapshot_size = (guint64) _tmp23_->total_size;
	_tmp24_ = self->task;
	main_first_snapshot_count = _tmp24_->count_created;
	_tmp26_ = self->task;
	if (_tmp26_->total_size == ((gint64) 0)) {
		Device* _tmp27_;
		_tmp27_ = self->sys_root;
		_tmp25_ = _tmp27_ != NULL;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		Device* _tmp28_;
		_tmp28_ = self->sys_root;
		main_first_snapshot_size = _tmp28_->used_bytes;
	}
	main_save_app_config (self);
	tee_jee_logging_log_debug ("estimate_system_size(): ok");
	result = main_first_snapshot_size;
	_g_free0 (_tmp7_);
	_g_free0 (dir_empty);
	return result;
}

static void
___lambda11_ (Main* self)
{
	main_query_subvolume_info_thread (self);
}

static gpointer
____lambda11__gthread_func (gpointer self)
{
	gpointer result;
	___lambda11_ ((Main*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

void
main_query_subvolume_info (Main* self,
                           SnapshotRepo* parent_repo)
{
	SnapshotRepo* _tmp0_;
	gboolean _tmp1_ = FALSE;
	SnapshotRepo* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parent_repo != NULL);
	_tmp0_ = _g_object_ref0 (parent_repo);
	_g_object_unref0 (self->repo);
	self->repo = _tmp0_;
	_tmp2_ = self->repo;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		SnapshotRepo* _tmp3_;
		_tmp3_ = self->repo;
		_tmp1_ = !_tmp3_->btrfs_mode;
	}
	if (_tmp1_) {
		return;
	}
	tee_jee_logging_log_debug (_ ("Querying subvolume info..."));
	{
		GThread* _tmp4_;
		GThread* _tmp5_;
		self->thread_subvol_info_running = TRUE;
		self->thread_subvol_info_success = FALSE;
		_tmp4_ = g_thread_try_new ("query-subvolume-info", ____lambda11__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp5_ = _tmp4_;
		_g_thread_unref0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		self->thread_subvol_info_running = FALSE;
		self->thread_subvol_info_success = FALSE;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		tee_jee_logging_log_error (_tmp7_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	while (TRUE) {
		if (!self->thread_subvol_info_running) {
			break;
		}
		tee_jee_gtk_helper_gtk_do_events ();
		g_usleep (((gulong) G_TIME_SPAN_MILLISECOND) * 100);
	}
	tee_jee_logging_log_debug (_ ("Query completed"));
}

void
main_query_subvolume_info_thread (Main* self)
{
	gboolean ok = FALSE;
	g_return_if_fail (self != NULL);
	self->thread_subvol_info_running = TRUE;
	ok = main_query_subvolume_ids (self);
	if (!ok) {
		self->thread_subvol_info_success = FALSE;
		self->thread_subvol_info_running = FALSE;
		return;
	}
	if (self->priv->_btrfs_qgroups_enabled_internal != MAIN_QGROUP_STATUS_DISABLED) {
		gboolean success = FALSE;
		success = main_query_subvolume_quotas (self);
		if (self->priv->_btrfs_qgroups_enabled_internal == MAIN_QGROUP_STATUS_UNKNOWN) {
			MainQGroupStatus _tmp0_ = 0;
			if (success) {
				_tmp0_ = MAIN_QGROUP_STATUS_ENABLED;
			} else {
				_tmp0_ = MAIN_QGROUP_STATUS_DISABLED;
			}
			self->priv->_btrfs_qgroups_enabled_internal = _tmp0_;
		}
	}
	self->thread_subvol_info_success = TRUE;
	self->thread_subvol_info_running = FALSE;
	return;
}

gboolean
main_query_subvolume_ids (Main* self)
{
	gboolean ok = FALSE;
	gboolean _tmp0_ = FALSE;
	SnapshotRepo* _tmp1_;
	Device* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ok = main_query_subvolume_id (self, "@");
	_tmp1_ = self->repo;
	_tmp2_ = _tmp1_->device_home;
	if (_tmp2_ != NULL) {
		SnapshotRepo* _tmp3_;
		Device* _tmp4_;
		const gchar* _tmp5_;
		SnapshotRepo* _tmp6_;
		Device* _tmp7_;
		const gchar* _tmp8_;
		_tmp3_ = self->repo;
		_tmp4_ = _tmp3_->device;
		_tmp5_ = _tmp4_->uuid;
		_tmp6_ = self->repo;
		_tmp7_ = _tmp6_->device_home;
		_tmp8_ = _tmp7_->uuid;
		_tmp0_ = g_strcmp0 (_tmp5_, _tmp8_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp9_ = FALSE;
		if (ok) {
			_tmp9_ = main_query_subvolume_id (self, "@home");
		} else {
			_tmp9_ = FALSE;
		}
		ok = _tmp9_;
	}
	result = ok;
	return result;
}

static glong
long_parse (const gchar* str,
            guint _base)
{
	glong result;
	g_return_val_if_fail (str != NULL, 0L);
	result = strtol (str, NULL, (gint) _base);
	return result;
}

gboolean
main_query_subvolume_id (Main* self,
                         const gchar* subvol_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* cmd = NULL;
	gchar* _tmp2_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint ret_val = 0;
	SnapshotRepo* _tmp3_;
	GeeHashMap* _tmp4_;
	gpointer _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	gint _tmp12_;
	const gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subvol_name != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("query_subvolume_id():%s", subvol_name);
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup ("");
	cmd = _tmp2_;
	_tmp3_ = self->repo;
	_tmp4_ = _tmp3_->mount_paths;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, subvol_name);
	_tmp6_ = (gchar*) _tmp5_;
	_tmp7_ = g_strdup_printf ("btrfs subvolume list '%s'", _tmp6_);
	_g_free0 (cmd);
	cmd = _tmp7_;
	_g_free0 (_tmp6_);
	_tmp8_ = cmd;
	tee_jee_logging_log_debug (_tmp8_);
	_tmp9_ = cmd;
	_tmp12_ = tee_jee_process_helper_exec_sync (_tmp9_, &_tmp10_, &_tmp11_);
	_g_free0 (std_out);
	std_out = _tmp10_;
	_g_free0 (std_err);
	std_err = _tmp11_;
	ret_val = _tmp12_;
	if (ret_val != 0) {
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp13_ = std_err;
		tee_jee_logging_log_error (_tmp13_, FALSE, FALSE);
		_tmp14_ = g_strdup_printf (": %d", ret_val);
		_tmp15_ = _tmp14_;
		_tmp16_ = g_strconcat (_ ("btrfs returned an error"), _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		tee_jee_logging_log_error (_tmp17_, FALSE, FALSE);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp15_);
		tee_jee_logging_log_error (_ ("Failed to query subvolume list"), FALSE, FALSE);
		result = FALSE;
		_g_free0 (std_err);
		_g_free0 (std_out);
		_g_free0 (cmd);
		return result;
	}
	_tmp18_ = std_out;
	_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp20_;
		line_collection_length1 = _vala_array_length (_tmp19_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp21_;
			gchar* line = NULL;
			_tmp21_ = g_strdup (line_collection[line_it]);
			line = _tmp21_;
			{
				const gchar* _tmp22_;
				gchar** parts = NULL;
				const gchar* _tmp23_;
				gchar** _tmp24_;
				gchar** _tmp25_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp26_;
				gint _tmp26__length1;
				Subvolume* subvol = NULL;
				gboolean _tmp27_ = FALSE;
				GeeHashMap* _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				Subvolume* _tmp102_;
				_tmp22_ = line;
				if (_tmp22_ == NULL) {
					_g_free0 (line);
					continue;
				}
				_tmp23_ = line;
				_tmp25_ = _tmp24_ = g_strsplit (_tmp23_, " ", 0);
				parts = _tmp25_;
				parts_length1 = _vala_array_length (_tmp24_);
				_parts_size_ = parts_length1;
				_tmp26_ = parts;
				_tmp26__length1 = parts_length1;
				if (_tmp26__length1 < 2) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				subvol = NULL;
				_tmp28_ = self->sys_subvolumes;
				_tmp29_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp28_);
				_tmp30_ = _tmp29_;
				if (_tmp30_ > 0) {
					const gchar* _tmp31_;
					GeeHashMap* _tmp32_;
					gpointer _tmp33_;
					Subvolume* _tmp34_;
					const gchar* _tmp35_;
					SnapshotRepo* _tmp36_;
					GeeHashMap* _tmp37_;
					gpointer _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					gchar* _tmp42_;
					gchar* _tmp43_;
					_tmp31_ = line;
					_tmp32_ = self->sys_subvolumes;
					_tmp33_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, "@");
					_tmp34_ = (Subvolume*) _tmp33_;
					_tmp35_ = _tmp34_->path;
					_tmp36_ = self->repo;
					_tmp37_ = _tmp36_->mount_paths;
					_tmp38_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp37_, "@");
					_tmp39_ = (gchar*) _tmp38_;
					_tmp40_ = g_strconcat (_tmp39_, "/", NULL);
					_tmp41_ = _tmp40_;
					_tmp42_ = string_replace (_tmp35_, _tmp41_, " ");
					_tmp43_ = _tmp42_;
					_tmp27_ = g_str_has_suffix (_tmp31_, _tmp43_);
					_g_free0 (_tmp43_);
					_g_free0 (_tmp41_);
					_g_free0 (_tmp39_);
					_g_object_unref0 (_tmp34_);
				} else {
					_tmp27_ = FALSE;
				}
				if (_tmp27_) {
					GeeHashMap* _tmp44_;
					gpointer _tmp45_;
					_tmp44_ = self->sys_subvolumes;
					_tmp45_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp44_, "@");
					_g_object_unref0 (subvol);
					subvol = (Subvolume*) _tmp45_;
				} else {
					gboolean _tmp46_ = FALSE;
					gboolean _tmp47_ = FALSE;
					GeeHashMap* _tmp48_;
					gint _tmp49_;
					gint _tmp50_;
					_tmp48_ = self->sys_subvolumes;
					_tmp49_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp48_);
					_tmp50_ = _tmp49_;
					if (_tmp50_ > 0) {
						GeeHashMap* _tmp51_;
						_tmp51_ = self->sys_subvolumes;
						_tmp47_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp51_, "@home");
					} else {
						_tmp47_ = FALSE;
					}
					if (_tmp47_) {
						const gchar* _tmp52_;
						GeeHashMap* _tmp53_;
						gpointer _tmp54_;
						Subvolume* _tmp55_;
						const gchar* _tmp56_;
						SnapshotRepo* _tmp57_;
						GeeHashMap* _tmp58_;
						gpointer _tmp59_;
						gchar* _tmp60_;
						gchar* _tmp61_;
						gchar* _tmp62_;
						gchar* _tmp63_;
						gchar* _tmp64_;
						_tmp52_ = line;
						_tmp53_ = self->sys_subvolumes;
						_tmp54_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp53_, "@home");
						_tmp55_ = (Subvolume*) _tmp54_;
						_tmp56_ = _tmp55_->path;
						_tmp57_ = self->repo;
						_tmp58_ = _tmp57_->mount_paths;
						_tmp59_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp58_, "@home");
						_tmp60_ = (gchar*) _tmp59_;
						_tmp61_ = g_strconcat (_tmp60_, "/", NULL);
						_tmp62_ = _tmp61_;
						_tmp63_ = string_replace (_tmp56_, _tmp62_, " ");
						_tmp64_ = _tmp63_;
						_tmp46_ = g_str_has_suffix (_tmp52_, _tmp64_);
						_g_free0 (_tmp64_);
						_g_free0 (_tmp62_);
						_g_free0 (_tmp60_);
						_g_object_unref0 (_tmp55_);
					} else {
						_tmp46_ = FALSE;
					}
					if (_tmp46_) {
						GeeHashMap* _tmp65_;
						gpointer _tmp66_;
						_tmp65_ = self->sys_subvolumes;
						_tmp66_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp65_, "@home");
						_g_object_unref0 (subvol);
						subvol = (Subvolume*) _tmp66_;
					} else {
						{
							GeeArrayList* _bak_list = NULL;
							SnapshotRepo* _tmp67_;
							GeeArrayList* _tmp68_;
							gint _bak_size = 0;
							GeeArrayList* _tmp69_;
							gint _tmp70_;
							gint _tmp71_;
							gint _bak_index = 0;
							_tmp67_ = self->repo;
							_tmp68_ = _tmp67_->snapshots;
							_bak_list = _tmp68_;
							_tmp69_ = _bak_list;
							_tmp70_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp69_);
							_tmp71_ = _tmp70_;
							_bak_size = _tmp71_;
							_bak_index = -1;
							while (TRUE) {
								gint _tmp72_;
								gint _tmp73_;
								Snapshot* bak = NULL;
								GeeArrayList* _tmp74_;
								gpointer _tmp75_;
								_bak_index = _bak_index + 1;
								_tmp72_ = _bak_index;
								_tmp73_ = _bak_size;
								if (!(_tmp72_ < _tmp73_)) {
									break;
								}
								_tmp74_ = _bak_list;
								_tmp75_ = gee_abstract_list_get ((GeeAbstractList*) _tmp74_, _bak_index);
								bak = (Snapshot*) _tmp75_;
								{
									GeeIterator* _sub_it = NULL;
									Snapshot* _tmp76_;
									GeeHashMap* _tmp77_;
									GeeCollection* _tmp78_;
									GeeCollection* _tmp79_;
									GeeCollection* _tmp80_;
									GeeIterator* _tmp81_;
									GeeIterator* _tmp82_;
									_tmp76_ = bak;
									_tmp77_ = _tmp76_->subvolumes;
									_tmp78_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp77_);
									_tmp79_ = _tmp78_;
									_tmp80_ = _tmp79_;
									_tmp81_ = gee_iterable_iterator ((GeeIterable*) _tmp80_);
									_tmp82_ = _tmp81_;
									_g_object_unref0 (_tmp80_);
									_sub_it = _tmp82_;
									while (TRUE) {
										GeeIterator* _tmp83_;
										Subvolume* sub = NULL;
										GeeIterator* _tmp84_;
										gpointer _tmp85_;
										const gchar* _tmp86_;
										Subvolume* _tmp87_;
										const gchar* _tmp88_;
										SnapshotRepo* _tmp89_;
										GeeHashMap* _tmp90_;
										Subvolume* _tmp91_;
										const gchar* _tmp92_;
										gpointer _tmp93_;
										gchar* _tmp94_;
										gchar* _tmp95_;
										gchar* _tmp96_;
										gchar* _tmp97_;
										gchar* _tmp98_;
										gboolean _tmp99_;
										_tmp83_ = _sub_it;
										if (!gee_iterator_next (_tmp83_)) {
											break;
										}
										_tmp84_ = _sub_it;
										_tmp85_ = gee_iterator_get (_tmp84_);
										sub = (Subvolume*) _tmp85_;
										_tmp86_ = line;
										_tmp87_ = sub;
										_tmp88_ = _tmp87_->path;
										_tmp89_ = self->repo;
										_tmp90_ = _tmp89_->mount_paths;
										_tmp91_ = sub;
										_tmp92_ = _tmp91_->name;
										_tmp93_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp90_, _tmp92_);
										_tmp94_ = (gchar*) _tmp93_;
										_tmp95_ = g_strconcat (_tmp94_, "/", NULL);
										_tmp96_ = _tmp95_;
										_tmp97_ = string_replace (_tmp88_, _tmp96_, "");
										_tmp98_ = _tmp97_;
										_tmp99_ = g_str_has_suffix (_tmp86_, _tmp98_);
										_g_free0 (_tmp98_);
										_g_free0 (_tmp96_);
										_g_free0 (_tmp94_);
										if (_tmp99_) {
											Subvolume* _tmp100_;
											Subvolume* _tmp101_;
											_tmp100_ = sub;
											_tmp101_ = _g_object_ref0 (_tmp100_);
											_g_object_unref0 (subvol);
											subvol = _tmp101_;
											_g_object_unref0 (sub);
											break;
										}
										_g_object_unref0 (sub);
									}
									_g_object_unref0 (_sub_it);
								}
								_g_object_unref0 (bak);
							}
						}
					}
				}
				_tmp102_ = subvol;
				if (_tmp102_ != NULL) {
					Subvolume* _tmp103_;
					gchar** _tmp104_;
					gint _tmp104__length1;
					const gchar* _tmp105_;
					_tmp103_ = subvol;
					_tmp104_ = parts;
					_tmp104__length1 = parts_length1;
					_tmp105_ = _tmp104_[1];
					_tmp103_->id = long_parse (_tmp105_, (guint) 0);
				}
				_g_object_unref0 (subvol);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	result = TRUE;
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	return result;
}

gboolean
main_query_subvolume_quotas (Main* self)
{
	gboolean ok = FALSE;
	SnapshotRepo* _tmp0_;
	Device* _tmp1_;
	const gchar* _tmp2_;
	SnapshotRepo* _tmp3_;
	Device* _tmp4_;
	const gchar* _tmp5_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ok = main_query_subvolume_quota (self, "@");
	_tmp0_ = self->repo;
	_tmp1_ = _tmp0_->device;
	_tmp2_ = _tmp1_->uuid;
	_tmp3_ = self->repo;
	_tmp4_ = _tmp3_->device_home;
	_tmp5_ = _tmp4_->uuid;
	if (g_strcmp0 (_tmp2_, _tmp5_) != 0) {
		gboolean _tmp6_ = FALSE;
		if (ok) {
			_tmp6_ = main_query_subvolume_quota (self, "@home");
		} else {
			_tmp6_ = FALSE;
		}
		ok = _tmp6_;
	}
	result = ok;
	return result;
}

static gint64
int64_parse (const gchar* str,
             guint _base)
{
	gint64 result;
	g_return_val_if_fail (str != NULL, 0LL);
	result = g_ascii_strtoll (str, NULL, _base);
	return result;
}

gboolean
main_query_subvolume_quota (Main* self,
                            const gchar* subvol_name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* cmd = NULL;
	gchar* _tmp2_;
	gchar* std_out = NULL;
	gchar* std_err = NULL;
	gint ret_val = 0;
	const gchar* _tmp3_ = NULL;
	gchar* options = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	SnapshotRepo* _tmp6_;
	GeeHashMap* _tmp7_;
	gpointer _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gint _tmp15_;
	const gchar* _tmp32_;
	gchar** _tmp33_;
	gchar** _tmp34_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (subvol_name != NULL, FALSE);
	_tmp0_ = g_strdup_printf ("query_subvolume_quota():%s", subvol_name);
	_tmp1_ = _tmp0_;
	tee_jee_logging_log_debug (_tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_strdup ("");
	cmd = _tmp2_;
	if (self->use_option_raw) {
		_tmp3_ = "--raw";
	} else {
		_tmp3_ = "";
	}
	_tmp4_ = g_strdup (_tmp3_);
	options = _tmp4_;
	_tmp5_ = options;
	_tmp6_ = self->repo;
	_tmp7_ = _tmp6_->mount_paths;
	_tmp8_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp7_, subvol_name);
	_tmp9_ = (gchar*) _tmp8_;
	_tmp10_ = g_strdup_printf ("btrfs qgroup show %s '%s'", _tmp5_, _tmp9_);
	_g_free0 (cmd);
	cmd = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = cmd;
	tee_jee_logging_log_debug (_tmp11_);
	_tmp12_ = cmd;
	_tmp15_ = tee_jee_process_helper_exec_sync (_tmp12_, &_tmp13_, &_tmp14_);
	_g_free0 (std_out);
	std_out = _tmp13_;
	_g_free0 (std_err);
	std_err = _tmp14_;
	ret_val = _tmp15_;
	if (ret_val != 0) {
		if (self->use_option_raw) {
			SnapshotRepo* _tmp16_;
			GeeHashMap* _tmp17_;
			gpointer _tmp18_;
			gchar* _tmp19_;
			gchar* _tmp20_;
			const gchar* _tmp21_;
			const gchar* _tmp22_;
			gchar* _tmp23_ = NULL;
			gchar* _tmp24_ = NULL;
			gint _tmp25_;
			self->use_option_raw = FALSE;
			_tmp16_ = self->repo;
			_tmp17_ = _tmp16_->mount_paths;
			_tmp18_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp17_, subvol_name);
			_tmp19_ = (gchar*) _tmp18_;
			_tmp20_ = g_strdup_printf ("btrfs qgroup show '%s'", _tmp19_);
			_g_free0 (cmd);
			cmd = _tmp20_;
			_g_free0 (_tmp19_);
			_tmp21_ = cmd;
			tee_jee_logging_log_debug (_tmp21_);
			_tmp22_ = cmd;
			_tmp25_ = tee_jee_process_helper_exec_sync (_tmp22_, &_tmp23_, &_tmp24_);
			_g_free0 (std_out);
			std_out = _tmp23_;
			_g_free0 (std_err);
			std_err = _tmp24_;
			ret_val = _tmp25_;
		}
		if (ret_val != 0) {
			const gchar* _tmp26_;
			const gchar* _tmp27_;
			gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp26_ = std_err;
			if (string_contains (_tmp26_, "not enabled")) {
				tee_jee_logging_log_msg ("btrfs: Quotas are not enabled", FALSE);
				result = FALSE;
				_g_free0 (options);
				_g_free0 (std_err);
				_g_free0 (std_out);
				_g_free0 (cmd);
				return result;
			}
			_tmp27_ = std_err;
			tee_jee_logging_log_error (_tmp27_, FALSE, FALSE);
			_tmp28_ = g_strdup_printf (": %d", ret_val);
			_tmp29_ = _tmp28_;
			_tmp30_ = g_strconcat (_ ("btrfs returned an error"), _tmp29_, NULL);
			_tmp31_ = _tmp30_;
			tee_jee_logging_log_error (_tmp31_, FALSE, FALSE);
			_g_free0 (_tmp31_);
			_g_free0 (_tmp29_);
			tee_jee_logging_log_error (_ ("Failed to query subvolume quota"), FALSE, FALSE);
			result = FALSE;
			_g_free0 (options);
			_g_free0 (std_err);
			_g_free0 (std_out);
			_g_free0 (cmd);
			return result;
		}
	}
	_tmp32_ = std_out;
	_tmp34_ = _tmp33_ = g_strsplit (_tmp32_, "\n", 0);
	{
		gchar** line_collection = NULL;
		gint line_collection_length1 = 0;
		gint _line_collection_size_ = 0;
		gint line_it = 0;
		line_collection = _tmp34_;
		line_collection_length1 = _vala_array_length (_tmp33_);
		for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
			gchar* _tmp35_;
			gchar* line = NULL;
			_tmp35_ = g_strdup (line_collection[line_it]);
			line = _tmp35_;
			{
				const gchar* _tmp36_;
				gchar** parts = NULL;
				const gchar* _tmp37_;
				gchar** _tmp38_;
				gchar** _tmp39_;
				gint parts_length1;
				gint _parts_size_;
				gchar** _tmp40_;
				gint _tmp40__length1;
				gchar** _tmp41_;
				gint _tmp41__length1;
				const gchar* _tmp42_;
				gchar** _tmp43_;
				gchar** _tmp44_;
				gchar** _tmp45_;
				gint _tmp45__length1;
				gboolean _tmp46_;
				gint subvol_id = 0;
				gchar** _tmp47_;
				gint _tmp47__length1;
				const gchar* _tmp48_;
				gchar** _tmp49_;
				gchar** _tmp50_;
				gchar** _tmp51_;
				gint _tmp51__length1;
				const gchar* _tmp52_;
				gint _tmp53_;
				Subvolume* subvol = NULL;
				gboolean _tmp54_ = FALSE;
				GeeHashMap* _tmp55_;
				gint _tmp56_;
				gint _tmp57_;
				Subvolume* _tmp96_;
				_tmp36_ = line;
				if (_tmp36_ == NULL) {
					_g_free0 (line);
					continue;
				}
				_tmp37_ = line;
				_tmp39_ = _tmp38_ = g_strsplit (_tmp37_, " ", 0);
				parts = _tmp39_;
				parts_length1 = _vala_array_length (_tmp38_);
				_parts_size_ = parts_length1;
				_tmp40_ = parts;
				_tmp40__length1 = parts_length1;
				if (_tmp40__length1 < 3) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp41_ = parts;
				_tmp41__length1 = parts_length1;
				_tmp42_ = _tmp41_[0];
				_tmp44_ = _tmp43_ = g_strsplit (_tmp42_, "/", 0);
				_tmp45_ = _tmp44_;
				_tmp45__length1 = _vala_array_length (_tmp43_);
				_tmp46_ = _vala_array_length (_tmp43_) < 2;
				_tmp45_ = (_vala_array_free (_tmp45_, _tmp45__length1, (GDestroyNotify) g_free), NULL);
				if (_tmp46_) {
					parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (line);
					continue;
				}
				_tmp47_ = parts;
				_tmp47__length1 = parts_length1;
				_tmp48_ = _tmp47_[0];
				_tmp50_ = _tmp49_ = g_strsplit (_tmp48_, "/", 0);
				_tmp51_ = _tmp50_;
				_tmp51__length1 = _vala_array_length (_tmp49_);
				_tmp52_ = _tmp51_[1];
				_tmp53_ = atoi (_tmp52_);
				_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
				subvol_id = _tmp53_;
				subvol = NULL;
				_tmp55_ = self->sys_subvolumes;
				_tmp56_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp55_);
				_tmp57_ = _tmp56_;
				if (_tmp57_ > 0) {
					GeeHashMap* _tmp58_;
					gpointer _tmp59_;
					Subvolume* _tmp60_;
					_tmp58_ = self->sys_subvolumes;
					_tmp59_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp58_, "@");
					_tmp60_ = (Subvolume*) _tmp59_;
					_tmp54_ = _tmp60_->id == ((glong) subvol_id);
					_g_object_unref0 (_tmp60_);
				} else {
					_tmp54_ = FALSE;
				}
				if (_tmp54_) {
					GeeHashMap* _tmp61_;
					gpointer _tmp62_;
					_tmp61_ = self->sys_subvolumes;
					_tmp62_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp61_, "@");
					_g_object_unref0 (subvol);
					subvol = (Subvolume*) _tmp62_;
				} else {
					gboolean _tmp63_ = FALSE;
					gboolean _tmp64_ = FALSE;
					GeeHashMap* _tmp65_;
					gint _tmp66_;
					gint _tmp67_;
					_tmp65_ = self->sys_subvolumes;
					_tmp66_ = gee_abstract_map_get_size ((GeeAbstractMap*) _tmp65_);
					_tmp67_ = _tmp66_;
					if (_tmp67_ > 0) {
						GeeHashMap* _tmp68_;
						_tmp68_ = self->sys_subvolumes;
						_tmp64_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp68_, "@home");
					} else {
						_tmp64_ = FALSE;
					}
					if (_tmp64_) {
						GeeHashMap* _tmp69_;
						gpointer _tmp70_;
						Subvolume* _tmp71_;
						_tmp69_ = self->sys_subvolumes;
						_tmp70_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp69_, "@home");
						_tmp71_ = (Subvolume*) _tmp70_;
						_tmp63_ = _tmp71_->id == ((glong) subvol_id);
						_g_object_unref0 (_tmp71_);
					} else {
						_tmp63_ = FALSE;
					}
					if (_tmp63_) {
						GeeHashMap* _tmp72_;
						gpointer _tmp73_;
						_tmp72_ = self->sys_subvolumes;
						_tmp73_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp72_, "@home");
						_g_object_unref0 (subvol);
						subvol = (Subvolume*) _tmp73_;
					} else {
						{
							GeeArrayList* _bak_list = NULL;
							SnapshotRepo* _tmp74_;
							GeeArrayList* _tmp75_;
							gint _bak_size = 0;
							GeeArrayList* _tmp76_;
							gint _tmp77_;
							gint _tmp78_;
							gint _bak_index = 0;
							_tmp74_ = self->repo;
							_tmp75_ = _tmp74_->snapshots;
							_bak_list = _tmp75_;
							_tmp76_ = _bak_list;
							_tmp77_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp76_);
							_tmp78_ = _tmp77_;
							_bak_size = _tmp78_;
							_bak_index = -1;
							while (TRUE) {
								gint _tmp79_;
								gint _tmp80_;
								Snapshot* bak = NULL;
								GeeArrayList* _tmp81_;
								gpointer _tmp82_;
								_bak_index = _bak_index + 1;
								_tmp79_ = _bak_index;
								_tmp80_ = _bak_size;
								if (!(_tmp79_ < _tmp80_)) {
									break;
								}
								_tmp81_ = _bak_list;
								_tmp82_ = gee_abstract_list_get ((GeeAbstractList*) _tmp81_, _bak_index);
								bak = (Snapshot*) _tmp82_;
								{
									GeeIterator* _sub_it = NULL;
									Snapshot* _tmp83_;
									GeeHashMap* _tmp84_;
									GeeCollection* _tmp85_;
									GeeCollection* _tmp86_;
									GeeCollection* _tmp87_;
									GeeIterator* _tmp88_;
									GeeIterator* _tmp89_;
									_tmp83_ = bak;
									_tmp84_ = _tmp83_->subvolumes;
									_tmp85_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp84_);
									_tmp86_ = _tmp85_;
									_tmp87_ = _tmp86_;
									_tmp88_ = gee_iterable_iterator ((GeeIterable*) _tmp87_);
									_tmp89_ = _tmp88_;
									_g_object_unref0 (_tmp87_);
									_sub_it = _tmp89_;
									while (TRUE) {
										GeeIterator* _tmp90_;
										Subvolume* sub = NULL;
										GeeIterator* _tmp91_;
										gpointer _tmp92_;
										Subvolume* _tmp93_;
										_tmp90_ = _sub_it;
										if (!gee_iterator_next (_tmp90_)) {
											break;
										}
										_tmp91_ = _sub_it;
										_tmp92_ = gee_iterator_get (_tmp91_);
										sub = (Subvolume*) _tmp92_;
										_tmp93_ = sub;
										if (_tmp93_->id == ((glong) subvol_id)) {
											Subvolume* _tmp94_;
											Subvolume* _tmp95_;
											_tmp94_ = sub;
											_tmp95_ = _g_object_ref0 (_tmp94_);
											_g_object_unref0 (subvol);
											subvol = _tmp95_;
										}
										_g_object_unref0 (sub);
									}
									_g_object_unref0 (_sub_it);
								}
								_g_object_unref0 (bak);
							}
						}
					}
				}
				_tmp96_ = subvol;
				if (_tmp96_ != NULL) {
					gint part_num = 0;
					gchar** _tmp97_;
					gint _tmp97__length1;
					part_num = -1;
					_tmp97_ = parts;
					_tmp97__length1 = parts_length1;
					{
						gchar** part_collection = NULL;
						gint part_collection_length1 = 0;
						gint _part_collection_size_ = 0;
						gint part_it = 0;
						part_collection = _tmp97_;
						part_collection_length1 = _tmp97__length1;
						for (part_it = 0; part_it < part_collection_length1; part_it = part_it + 1) {
							gchar* _tmp98_;
							gchar* part = NULL;
							_tmp98_ = g_strdup (part_collection[part_it]);
							part = _tmp98_;
							{
								const gchar* _tmp99_;
								gchar* _tmp100_;
								gchar* _tmp101_;
								gint _tmp102_;
								gint _tmp103_;
								gboolean _tmp104_;
								_tmp99_ = part;
								_tmp100_ = string_strip (_tmp99_);
								_tmp101_ = _tmp100_;
								_tmp102_ = strlen (_tmp101_);
								_tmp103_ = _tmp102_;
								_tmp104_ = _tmp103_ > 0;
								_g_free0 (_tmp101_);
								if (_tmp104_) {
									gint _tmp105_;
									_tmp105_ = part_num;
									part_num = _tmp105_ + 1;
									switch (part_num) {
										case 1:
										{
											Subvolume* _tmp106_;
											const gchar* _tmp107_;
											_tmp106_ = subvol;
											_tmp107_ = part;
											_tmp106_->total_bytes = int64_parse (_tmp107_, (guint) 0);
											break;
										}
										case 2:
										{
											Subvolume* _tmp108_;
											const gchar* _tmp109_;
											_tmp108_ = subvol;
											_tmp109_ = part;
											_tmp108_->unshared_bytes = int64_parse (_tmp109_, (guint) 0);
											break;
										}
										default:
										{
											break;
										}
									}
								}
								_g_free0 (part);
							}
						}
					}
				}
				_g_object_unref0 (subvol);
				parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
				_g_free0 (line);
			}
		}
		line_collection = (_vala_array_free (line_collection, line_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	{
		GeeArrayList* _bak_list = NULL;
		SnapshotRepo* _tmp110_;
		GeeArrayList* _tmp111_;
		gint _bak_size = 0;
		GeeArrayList* _tmp112_;
		gint _tmp113_;
		gint _tmp114_;
		gint _bak_index = 0;
		_tmp110_ = self->repo;
		_tmp111_ = _tmp110_->snapshots;
		_bak_list = _tmp111_;
		_tmp112_ = _bak_list;
		_tmp113_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp112_);
		_tmp114_ = _tmp113_;
		_bak_size = _tmp114_;
		_bak_index = -1;
		while (TRUE) {
			gint _tmp115_;
			gint _tmp116_;
			Snapshot* bak = NULL;
			GeeArrayList* _tmp117_;
			gpointer _tmp118_;
			Snapshot* _tmp119_;
			_bak_index = _bak_index + 1;
			_tmp115_ = _bak_index;
			_tmp116_ = _bak_size;
			if (!(_tmp115_ < _tmp116_)) {
				break;
			}
			_tmp117_ = _bak_list;
			_tmp118_ = gee_abstract_list_get ((GeeAbstractList*) _tmp117_, _bak_index);
			bak = (Snapshot*) _tmp118_;
			_tmp119_ = bak;
			snapshot_update_control_file (_tmp119_);
			_g_object_unref0 (bak);
		}
	}
	result = TRUE;
	_g_free0 (options);
	_g_free0 (std_err);
	_g_free0 (std_out);
	_g_free0 (cmd);
	return result;
}

void
main_cron_job_update (Main* self)
{
	gchar* entry = NULL;
	gchar* _tmp0_;
	gint count = 0;
	gchar* _tmp4_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	g_return_if_fail (self != NULL);
	if (main_live_system (self)) {
		return;
	}
	_tmp0_ = g_strdup ("timeshift --backup");
	entry = _tmp0_;
	count = 0;
	while (TRUE) {
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		gint _tmp3_;
		_tmp1_ = entry;
		if (!cron_tab_has_job (_tmp1_, TRUE, FALSE)) {
			break;
		}
		_tmp2_ = entry;
		cron_tab_remove_job (_tmp2_, TRUE, TRUE);
		count = count + 1;
		_tmp3_ = count;
		if (_tmp3_ == 100) {
			break;
		}
	}
	_tmp4_ = g_strdup ("timeshift-btrfs --backup");
	_g_free0 (entry);
	entry = _tmp4_;
	count = 0;
	while (TRUE) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gint _tmp7_;
		_tmp5_ = entry;
		if (!cron_tab_has_job (_tmp5_, TRUE, FALSE)) {
			break;
		}
		_tmp6_ = entry;
		cron_tab_remove_job (_tmp6_, TRUE, TRUE);
		count = count + 1;
		_tmp7_ = count;
		if (_tmp7_ == 100) {
			break;
		}
	}
	cron_tab_remove_script_file ("timeshift-hourly", "hourly");
	_tmp8_ = main_get_scheduled (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		cron_tab_add_script_file ("timeshift-hourly", "d", "0 * * * * root timeshift --check --scripted", self->stop_cron_emails);
		if (self->schedule_boot) {
			cron_tab_add_script_file ("timeshift-boot", "d", "@reboot root sleep 10m && timeshift --create --scripted --tags B", self->stop_cron_emails);
		} else {
			cron_tab_remove_script_file ("timeshift-boot", "d");
		}
	} else {
		cron_tab_remove_script_file ("timeshift-hourly", "d");
		cron_tab_remove_script_file ("timeshift-boot", "d");
	}
	_g_free0 (entry);
}

static gint
___lambda15_ (Main* self,
              const gchar* a,
              const gchar* b)
{
	GCompareFunc _tmp0_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = ((GCompareFunc) g_strcmp0);
	result = _tmp0_ (a, b);
	return result;
}

static gint
____lambda15__gcompare_data_func (gconstpointer a,
                                  gconstpointer b,
                                  gpointer self)
{
	gint result;
	result = ___lambda15_ ((Main*) self, (const gchar*) a, (const gchar*) b);
	return result;
}

void
main_clean_logs (Main* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("clean_logs()");
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GFile* dir = NULL;
		const gchar* _tmp1_;
		GFile* _tmp2_;
		GFileEnumerator* enumerator = NULL;
		GFile* _tmp3_;
		GFileEnumerator* _tmp4_;
		GFileInfo* info = NULL;
		GFileEnumerator* _tmp5_;
		GFileInfo* _tmp6_;
		gchar* path = NULL;
		GCompareDataFunc compare_func = NULL;
		gpointer compare_func_target;
		GDestroyNotify compare_func_target_destroy_notify;
		GeeArrayList* _tmp23_;
		GCompareDataFunc _tmp24_;
		gpointer _tmp24__target;
		GDestroyNotify _tmp24__target_destroy_notify;
		GeeArrayList* _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp1_ = self->log_dir;
		_tmp2_ = g_file_new_for_path (_tmp1_);
		dir = _tmp2_;
		_tmp3_ = dir;
		_tmp4_ = g_file_enumerate_children (_tmp3_, "*", 0, NULL, &_inner_error0_);
		enumerator = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		_tmp5_ = enumerator;
		_tmp6_ = g_file_enumerator_next_file (_tmp5_, NULL, &_inner_error0_);
		info = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (enumerator);
			_g_object_unref0 (dir);
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp7_;
			GFileInfo* _tmp8_;
			GFileInfo* _tmp19_ = NULL;
			GFileEnumerator* _tmp20_;
			GFileInfo* _tmp21_;
			GFileInfo* _tmp22_;
			_tmp7_ = info;
			if (!(_tmp7_ != NULL)) {
				break;
			}
			_tmp8_ = info;
			if (g_file_info_get_file_type (_tmp8_) == G_FILE_TYPE_REGULAR) {
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				GFileInfo* _tmp12_;
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				_tmp9_ = self->log_dir;
				_tmp10_ = g_strconcat (_tmp9_, "/", NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = info;
				_tmp13_ = g_file_info_get_name (_tmp12_);
				_tmp14_ = g_strconcat (_tmp11_, _tmp13_, NULL);
				_g_free0 (path);
				path = _tmp14_;
				_g_free0 (_tmp11_);
				_tmp15_ = path;
				_tmp16_ = self->log_file;
				if (g_strcmp0 (_tmp15_, _tmp16_) != 0) {
					GeeArrayList* _tmp17_;
					const gchar* _tmp18_;
					_tmp17_ = list;
					_tmp18_ = path;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp17_, _tmp18_);
				}
			}
			_tmp20_ = enumerator;
			_tmp21_ = g_file_enumerator_next_file (_tmp20_, NULL, &_inner_error0_);
			_tmp19_ = _tmp21_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (path);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				_g_object_unref0 (dir);
				goto __catch0_g_error;
			}
			_tmp22_ = _tmp19_;
			_tmp19_ = NULL;
			_g_object_unref0 (info);
			info = _tmp22_;
			_g_object_unref0 (_tmp19_);
		}
		compare_func = ____lambda15__gcompare_data_func;
		compare_func_target = g_object_ref (self);
		compare_func_target_destroy_notify = g_object_unref;
		_tmp23_ = list;
		_tmp24_ = compare_func;
		_tmp24__target = compare_func_target;
		_tmp24__target_destroy_notify = compare_func_target_destroy_notify;
		compare_func = NULL;
		compare_func_target = NULL;
		compare_func_target_destroy_notify = NULL;
		gee_list_sort ((GeeList*) _tmp23_, _tmp24_, _tmp24__target, _tmp24__target_destroy_notify);
		_tmp25_ = list;
		_tmp26_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		if (_tmp27_ > 500) {
			{
				gint k = 0;
				k = 0;
				{
					gboolean _tmp28_ = FALSE;
					_tmp28_ = TRUE;
					while (TRUE) {
						GFile* file = NULL;
						GeeArrayList* _tmp30_;
						gpointer _tmp31_;
						gchar* _tmp32_;
						GFile* _tmp33_;
						GFile* _tmp34_;
						GFile* _tmp35_;
						if (!_tmp28_) {
							gint _tmp29_;
							_tmp29_ = k;
							k = _tmp29_ + 1;
						}
						_tmp28_ = FALSE;
						if (!(k < 100)) {
							break;
						}
						_tmp30_ = list;
						_tmp31_ = gee_abstract_list_get ((GeeAbstractList*) _tmp30_, k);
						_tmp32_ = (gchar*) _tmp31_;
						_tmp33_ = g_file_new_for_path (_tmp32_);
						_tmp34_ = _tmp33_;
						_g_free0 (_tmp32_);
						file = _tmp34_;
						_tmp35_ = file;
						if (g_file_query_exists (_tmp35_, NULL)) {
							GFile* _tmp36_;
							GeeArrayList* _tmp37_;
							gpointer _tmp38_;
							gchar* _tmp39_;
							gchar* _tmp40_;
							gchar* _tmp41_;
							_tmp36_ = file;
							g_file_delete (_tmp36_, NULL, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_object_unref0 (file);
								(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
								compare_func = NULL;
								compare_func_target = NULL;
								compare_func_target_destroy_notify = NULL;
								_g_free0 (path);
								_g_object_unref0 (info);
								_g_object_unref0 (enumerator);
								_g_object_unref0 (dir);
								goto __catch0_g_error;
							}
							_tmp37_ = list;
							_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, k);
							_tmp39_ = (gchar*) _tmp38_;
							_tmp40_ = g_strdup_printf ("%s: %s", _ ("Removed"), _tmp39_);
							_tmp41_ = _tmp40_;
							tee_jee_logging_log_msg (_tmp41_, FALSE);
							_g_free0 (_tmp41_);
							_g_free0 (_tmp39_);
						}
						_g_object_unref0 (file);
					}
				}
			}
			tee_jee_logging_log_msg (_ ("Older log files removed"), FALSE);
		}
		(compare_func_target_destroy_notify == NULL) ? NULL : (compare_func_target_destroy_notify (compare_func_target), NULL);
		compare_func = NULL;
		compare_func_target = NULL;
		compare_func_target_destroy_notify = NULL;
		_g_free0 (path);
		_g_object_unref0 (info);
		_g_object_unref0 (enumerator);
		_g_object_unref0 (dir);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		tee_jee_logging_log_error (_tmp43_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (list);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (list);
}

void
main_exit_app (Main* self,
               gint exit_code)
{
	const gchar* _tmp0_;
	AppLock* _tmp1_;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("exit_app()");
	_tmp0_ = self->app_mode;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		main_save_app_config (self);
	}
	main_cron_job_update (self);
	main_unmount_target_device (self, FALSE);
	main_clean_logs (self);
	_tmp1_ = self->app_lock;
	app_lock_remove (_tmp1_);
	_tmp2_ = tee_jee_process_helper_TEMP_DIR;
	tee_jee_file_system_dir_delete (_tmp2_, FALSE);
	main_cleanup_unmount_devices (self);
	exit (exit_code);
}

static void
main_cleanup_unmount_devices (Main* self)
{
	GeeArrayList* dirlist = NULL;
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("cleanup_unmount_devices()");
	if (!tee_jee_file_system_dir_exists ("/run/timeshift")) {
		return;
	}
	_tmp0_ = tee_jee_file_system_dir_list_names ("/run/timeshift");
	dirlist = _tmp0_;
	{
		GeeArrayList* _dname_list = NULL;
		GeeArrayList* _tmp1_;
		gint _dname_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _dname_index = 0;
		_tmp1_ = dirlist;
		_dname_list = _tmp1_;
		_tmp2_ = _dname_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_dname_size = _tmp4_;
		_dname_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gchar* dname = NULL;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gint pid = 0;
			const gchar* _tmp9_;
			gchar* mdir = NULL;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			GeeArrayList* dirlist2 = NULL;
			const gchar* _tmp14_;
			GeeArrayList* _tmp15_;
			const gchar* _tmp64_;
			_dname_index = _dname_index + 1;
			_tmp5_ = _dname_index;
			_tmp6_ = _dname_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _dname_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _dname_index);
			dname = (gchar*) _tmp8_;
			_tmp9_ = dname;
			pid = atoi (_tmp9_);
			if (pid != ((gint) getpid ())) {
				gchar* procdir = NULL;
				gchar* _tmp10_;
				const gchar* _tmp11_;
				_tmp10_ = g_strdup_printf ("/proc/%d", pid);
				procdir = _tmp10_;
				_tmp11_ = procdir;
				if (tee_jee_file_system_dir_exists (_tmp11_)) {
					_g_free0 (procdir);
					_g_free0 (dname);
					continue;
				}
				_g_free0 (procdir);
			}
			_tmp12_ = dname;
			_tmp13_ = g_strdup_printf ("/run/timeshift/%s", _tmp12_);
			mdir = _tmp13_;
			_tmp14_ = mdir;
			_tmp15_ = tee_jee_file_system_dir_list_names (_tmp14_);
			dirlist2 = _tmp15_;
			{
				GeeArrayList* _dname2_list = NULL;
				GeeArrayList* _tmp16_;
				gint _dname2_size = 0;
				GeeArrayList* _tmp17_;
				gint _tmp18_;
				gint _tmp19_;
				gint _dname2_index = 0;
				_tmp16_ = dirlist2;
				_dname2_list = _tmp16_;
				_tmp17_ = _dname2_list;
				_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
				_tmp19_ = _tmp18_;
				_dname2_size = _tmp19_;
				_dname2_index = -1;
				while (TRUE) {
					gint _tmp20_;
					gint _tmp21_;
					gchar* dname2 = NULL;
					GeeArrayList* _tmp22_;
					gpointer _tmp23_;
					gchar* mdir2 = NULL;
					const gchar* _tmp24_;
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_dname2_index = _dname2_index + 1;
					_tmp20_ = _dname2_index;
					_tmp21_ = _dname2_size;
					if (!(_tmp20_ < _tmp21_)) {
						break;
					}
					_tmp22_ = _dname2_list;
					_tmp23_ = gee_abstract_list_get ((GeeAbstractList*) _tmp22_, _dname2_index);
					dname2 = (gchar*) _tmp23_;
					_tmp24_ = dname;
					_tmp25_ = dname2;
					_tmp26_ = g_strdup_printf ("/run/timeshift/%s/%s", _tmp24_, _tmp25_);
					mdir2 = _tmp26_;
					{
						GeeArrayList* _dev_list = NULL;
						GeeArrayList* _tmp27_;
						gint _dev_size = 0;
						GeeArrayList* _tmp28_;
						gint _tmp29_;
						gint _tmp30_;
						gint _dev_index = 0;
						_tmp27_ = device_get_filesystems (TRUE, TRUE);
						_dev_list = _tmp27_;
						_tmp28_ = _dev_list;
						_tmp29_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp28_);
						_tmp30_ = _tmp29_;
						_dev_size = _tmp30_;
						_dev_index = -1;
						while (TRUE) {
							gint _tmp31_;
							gint _tmp32_;
							Device* dev = NULL;
							GeeArrayList* _tmp33_;
							gpointer _tmp34_;
							_dev_index = _dev_index + 1;
							_tmp31_ = _dev_index;
							_tmp32_ = _dev_size;
							if (!(_tmp31_ < _tmp32_)) {
								break;
							}
							_tmp33_ = _dev_list;
							_tmp34_ = gee_abstract_list_get ((GeeAbstractList*) _tmp33_, _dev_index);
							dev = (Device*) _tmp34_;
							{
								GeeArrayList* _mnt_list = NULL;
								Device* _tmp35_;
								GeeArrayList* _tmp36_;
								gint _mnt_size = 0;
								GeeArrayList* _tmp37_;
								gint _tmp38_;
								gint _tmp39_;
								gint _mnt_index = 0;
								_tmp35_ = dev;
								_tmp36_ = _tmp35_->mount_points;
								_mnt_list = _tmp36_;
								_tmp37_ = _mnt_list;
								_tmp38_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp37_);
								_tmp39_ = _tmp38_;
								_mnt_size = _tmp39_;
								_mnt_index = -1;
								while (TRUE) {
									gint _tmp40_;
									gint _tmp41_;
									MountEntry* mnt = NULL;
									GeeArrayList* _tmp42_;
									gpointer _tmp43_;
									MountEntry* _tmp44_;
									const gchar* _tmp45_;
									const gchar* _tmp46_;
									_mnt_index = _mnt_index + 1;
									_tmp40_ = _mnt_index;
									_tmp41_ = _mnt_size;
									if (!(_tmp40_ < _tmp41_)) {
										break;
									}
									_tmp42_ = _mnt_list;
									_tmp43_ = gee_abstract_list_get ((GeeAbstractList*) _tmp42_, _mnt_index);
									mnt = (MountEntry*) _tmp43_;
									_tmp44_ = mnt;
									_tmp45_ = _tmp44_->mount_point;
									_tmp46_ = mdir2;
									if (g_strcmp0 (_tmp45_, _tmp46_) == 0) {
										Device* _tmp47_;
										const gchar* _tmp48_;
										const gchar* _tmp49_;
										gchar* _tmp50_;
										gchar* _tmp51_;
										gchar* cmd = NULL;
										const gchar* _tmp52_;
										gchar* _tmp53_;
										gchar* _tmp54_;
										gchar* _tmp55_;
										gchar* _tmp56_;
										gint retval = 0;
										const gchar* _tmp57_;
										const gchar* _tmp60_;
										_tmp47_ = dev;
										_tmp48_ = _tmp47_->device;
										_tmp49_ = mdir2;
										_tmp50_ = g_strdup_printf ("\nFound stale mount for device '%s' at path '%s'", _tmp48_, _tmp49_);
										_tmp51_ = _tmp50_;
										tee_jee_logging_log_debug (_tmp51_);
										_g_free0 (_tmp51_);
										_tmp52_ = mdir2;
										_tmp53_ = tee_jee_file_system_escape_single_quote (_tmp52_);
										_tmp54_ = _tmp53_;
										_tmp55_ = g_strdup_printf ("umount '%s'", _tmp54_);
										_tmp56_ = _tmp55_;
										_g_free0 (_tmp54_);
										cmd = _tmp56_;
										_tmp57_ = cmd;
										retval = tee_jee_process_helper_exec_sync (_tmp57_, NULL, NULL);
										if (retval != 0) {
											gchar* _tmp58_;
											gchar* _tmp59_;
											tee_jee_logging_log_debug ("E: Failed to unmount");
											_tmp58_ = g_strdup_printf ("Ret=%d", retval);
											_tmp59_ = _tmp58_;
											tee_jee_logging_log_debug (_tmp59_);
											_g_free0 (_tmp59_);
										} else {
											tee_jee_logging_log_debug ("Unmounted successfully");
										}
										_tmp60_ = mdir2;
										if (!tee_jee_file_system_dir_empty_delete (_tmp60_)) {
											const gchar* _tmp61_;
											gchar* _tmp62_;
											gchar* _tmp63_;
											_tmp61_ = mdir2;
											_tmp62_ = g_strdup_printf ("E: Failed to delete %s", _tmp61_);
											_tmp63_ = _tmp62_;
											tee_jee_logging_log_debug (_tmp63_);
											_g_free0 (_tmp63_);
										}
										_g_free0 (cmd);
									}
									_g_object_unref0 (mnt);
								}
							}
							_g_object_unref0 (dev);
						}
						_g_object_unref0 (_dev_list);
					}
					_g_free0 (mdir2);
					_g_free0 (dname2);
				}
			}
			_tmp64_ = mdir;
			if (tee_jee_file_system_dir_exists (_tmp64_)) {
				gchar* cmd3 = NULL;
				const gchar* _tmp65_;
				gchar* _tmp66_;
				gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
				gint retval3 = 0;
				const gchar* _tmp70_;
				_tmp65_ = mdir;
				_tmp66_ = tee_jee_file_system_escape_single_quote (_tmp65_);
				_tmp67_ = _tmp66_;
				_tmp68_ = g_strdup_printf ("rmdir '%s'", _tmp67_);
				_tmp69_ = _tmp68_;
				_g_free0 (_tmp67_);
				cmd3 = _tmp69_;
				_tmp70_ = cmd3;
				retval3 = tee_jee_process_helper_exec_sync (_tmp70_, NULL, NULL);
				if (retval3 != 0) {
					gchar* _tmp71_;
					gchar* _tmp72_;
					tee_jee_logging_log_error ("Failed to remove directory", FALSE, FALSE);
					_tmp71_ = g_strdup_printf ("Ret=%d", retval3);
					_tmp72_ = _tmp71_;
					tee_jee_logging_log_msg (_tmp72_, FALSE);
					_g_free0 (_tmp72_);
				}
				_g_free0 (cmd3);
			}
			_g_object_unref0 (dirlist2);
			_g_free0 (mdir);
			_g_free0 (dname);
		}
	}
	_g_object_unref0 (dirlist);
}

gboolean
main_get_btrfs_qgroups_enabled (Main* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_btrfs_qgroups_enabled_internal == MAIN_QGROUP_STATUS_ENABLED;
	return result;
}

gboolean
main_get_scheduled (Main* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (!main_live_system (self)) {
		gboolean _tmp1_ = FALSE;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		if (self->schedule_boot) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = self->schedule_hourly;
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = self->schedule_daily;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = self->schedule_weekly;
		}
		if (_tmp2_) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = self->schedule_monthly;
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Device*
main_get_dst_root (Main* self)
{
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _tmp10_->device;
				result = _tmp11_;
				_g_object_unref0 (mnt);
				return result;
			}
			_g_object_unref0 (mnt);
		}
	}
	result = NULL;
	return result;
}

void
main_set_dst_root (Main* self,
                   Device* value)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _g_object_ref0 (value);
				_g_object_unref0 (_tmp10_->device);
				_tmp10_->device = _tmp11_;
				_g_object_unref0 (mnt);
				break;
			}
			_g_object_unref0 (mnt);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, main_properties[MAIN_DST_ROOT_PROPERTY]);
}

Device*
main_get_dst_boot (Main* self)
{
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/boot") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _tmp10_->device;
				result = _tmp11_;
				_g_object_unref0 (mnt);
				return result;
			}
			_g_object_unref0 (mnt);
		}
	}
	result = NULL;
	return result;
}

void
main_set_dst_boot (Main* self,
                   Device* value)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/boot") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _g_object_ref0 (value);
				_g_object_unref0 (_tmp10_->device);
				_tmp10_->device = _tmp11_;
				_g_object_unref0 (mnt);
				break;
			}
			_g_object_unref0 (mnt);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, main_properties[MAIN_DST_BOOT_PROPERTY]);
}

Device*
main_get_dst_efi (Main* self)
{
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/boot/efi") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _tmp10_->device;
				result = _tmp11_;
				_g_object_unref0 (mnt);
				return result;
			}
			_g_object_unref0 (mnt);
		}
	}
	result = NULL;
	return result;
}

void
main_set_dst_efi (Main* self,
                  Device* value)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/boot/efi") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _g_object_ref0 (value);
				_g_object_unref0 (_tmp10_->device);
				_tmp10_->device = _tmp11_;
				_g_object_unref0 (mnt);
				break;
			}
			_g_object_unref0 (mnt);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, main_properties[MAIN_DST_EFI_PROPERTY]);
}

Device*
main_get_dst_home (Main* self)
{
	Device* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/home") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _tmp10_->device;
				result = _tmp11_;
				_g_object_unref0 (mnt);
				return result;
			}
			_g_object_unref0 (mnt);
		}
	}
	result = NULL;
	return result;
}

void
main_set_dst_home (Main* self,
                   Device* value)
{
	g_return_if_fail (self != NULL);
	{
		GeeArrayList* _mnt_list = NULL;
		GeeArrayList* _tmp0_;
		gint _mnt_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _mnt_index = 0;
		_tmp0_ = self->mount_list;
		_mnt_list = _tmp0_;
		_tmp1_ = _mnt_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_mnt_size = _tmp3_;
		_mnt_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			MountEntry* mnt = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			MountEntry* _tmp8_;
			const gchar* _tmp9_;
			_mnt_index = _mnt_index + 1;
			_tmp4_ = _mnt_index;
			_tmp5_ = _mnt_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _mnt_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _mnt_index);
			mnt = (MountEntry*) _tmp7_;
			_tmp8_ = mnt;
			_tmp9_ = _tmp8_->mount_point;
			if (g_strcmp0 (_tmp9_, "/home") == 0) {
				MountEntry* _tmp10_;
				Device* _tmp11_;
				_tmp10_ = mnt;
				_tmp11_ = _g_object_ref0 (value);
				_g_object_unref0 (_tmp10_->device);
				_tmp10_->device = _tmp11_;
				_g_object_unref0 (mnt);
				break;
			}
			_g_object_unref0 (mnt);
		}
	}
	g_object_notify_by_pspec ((GObject *) self, main_properties[MAIN_DST_HOME_PROPERTY]);
}

gboolean
main_get_restore_current_system (Main* self)
{
	gboolean result;
	gboolean _tmp0_ = FALSE;
	Device* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->sys_root;
	if (_tmp1_ != NULL) {
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		Device* _tmp4_;
		Device* _tmp5_;
		_tmp4_ = main_get_dst_root (self);
		_tmp5_ = _tmp4_;
		if (_tmp5_ != NULL) {
			Device* _tmp6_;
			Device* _tmp7_;
			const gchar* _tmp8_;
			Device* _tmp9_;
			const gchar* _tmp10_;
			_tmp6_ = main_get_dst_root (self);
			_tmp7_ = _tmp6_;
			_tmp8_ = _tmp7_->device;
			_tmp9_ = self->sys_root;
			_tmp10_ = _tmp9_->device;
			_tmp3_ = g_strcmp0 (_tmp8_, _tmp10_) == 0;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			gboolean _tmp11_ = FALSE;
			Device* _tmp12_;
			Device* _tmp13_;
			_tmp12_ = main_get_dst_root (self);
			_tmp13_ = _tmp12_;
			if (_tmp13_ != NULL) {
				Device* _tmp14_;
				Device* _tmp15_;
				const gchar* _tmp16_;
				Device* _tmp17_;
				const gchar* _tmp18_;
				_tmp14_ = main_get_dst_root (self);
				_tmp15_ = _tmp14_;
				_tmp16_ = _tmp15_->uuid;
				_tmp17_ = self->sys_root;
				_tmp18_ = _tmp17_->uuid;
				_tmp11_ = g_strcmp0 (_tmp16_, _tmp18_) == 0;
			} else {
				_tmp11_ = FALSE;
			}
			_tmp2_ = _tmp11_;
		}
		_tmp0_ = _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

gchar*
main_get_restore_source_path (Main* self)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (self->mirror_system) {
		gchar* source_path = NULL;
		gchar* _tmp0_;
		const gchar* _tmp1_;
		_tmp0_ = g_strdup ("/tmp/timeshift");
		source_path = _tmp0_;
		_tmp1_ = source_path;
		tee_jee_file_system_dir_create (_tmp1_, FALSE);
		result = source_path;
		return result;
	} else {
		Snapshot* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = self->snapshot_to_restore;
		_tmp3_ = _tmp2_->path;
		_tmp4_ = g_strdup (_tmp3_);
		result = _tmp4_;
		return result;
	}
}

gchar*
main_get_restore_target_path (Main* self)
{
	gchar* result;
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_get_restore_current_system (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("/");
		result = _tmp2_;
		return result;
	} else {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = self->mount_point_restore;
		_tmp4_ = g_strconcat (_tmp3_, "/", NULL);
		result = _tmp4_;
		return result;
	}
}

gchar*
main_get_restore_log_file (Main* self)
{
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_get_restore_source_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/rsync-log-restore", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

gchar*
main_get_restore_exclude_file (Main* self)
{
	gchar* result;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = main_get_restore_source_path (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strconcat (_tmp2_, "/exclude-restore.list", NULL);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	result = _tmp4_;
	return result;
}

static void
main_class_init (MainClass * klass,
                 gpointer klass_data)
{
	main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Main_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_main_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_main_set_property;
	G_OBJECT_CLASS (klass)->finalize = main_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_BTRFS_QGROUPS_ENABLED_PROPERTY, main_properties[MAIN_BTRFS_QGROUPS_ENABLED_PROPERTY] = g_param_spec_boolean ("btrfs-qgroups-enabled", "btrfs-qgroups-enabled", "btrfs-qgroups-enabled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_SCHEDULED_PROPERTY, main_properties[MAIN_SCHEDULED_PROPERTY] = g_param_spec_boolean ("scheduled", "scheduled", "scheduled", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_DST_ROOT_PROPERTY, main_properties[MAIN_DST_ROOT_PROPERTY] = g_param_spec_object ("dst-root", "dst-root", "dst-root", TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_DST_BOOT_PROPERTY, main_properties[MAIN_DST_BOOT_PROPERTY] = g_param_spec_object ("dst-boot", "dst-boot", "dst-boot", TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_DST_EFI_PROPERTY, main_properties[MAIN_DST_EFI_PROPERTY] = g_param_spec_object ("dst-efi", "dst-efi", "dst-efi", TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_DST_HOME_PROPERTY, main_properties[MAIN_DST_HOME_PROPERTY] = g_param_spec_object ("dst-home", "dst-home", "dst-home", TYPE_DEVICE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_RESTORE_CURRENT_SYSTEM_PROPERTY, main_properties[MAIN_RESTORE_CURRENT_SYSTEM_PROPERTY] = g_param_spec_boolean ("restore-current-system", "restore-current-system", "restore-current-system", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_RESTORE_SOURCE_PATH_PROPERTY, main_properties[MAIN_RESTORE_SOURCE_PATH_PROPERTY] = g_param_spec_string ("restore-source-path", "restore-source-path", "restore-source-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_RESTORE_TARGET_PATH_PROPERTY, main_properties[MAIN_RESTORE_TARGET_PATH_PROPERTY] = g_param_spec_string ("restore-target-path", "restore-target-path", "restore-target-path", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_RESTORE_LOG_FILE_PROPERTY, main_properties[MAIN_RESTORE_LOG_FILE_PROPERTY] = g_param_spec_string ("restore-log-file", "restore-log-file", "restore-log-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), MAIN_RESTORE_EXCLUDE_FILE_PROPERTY, main_properties[MAIN_RESTORE_EXCLUDE_FILE_PROPERTY] = g_param_spec_string ("restore-exclude-file", "restore-exclude-file", "restore-exclude-file", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
main_instance_init (Main * self,
                    gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	self->priv = main_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->app_path = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->share_folder = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->rsnapshot_conf_path = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->app_conf_path = _tmp3_;
	_tmp4_ = g_strdup ("");
	self->app_conf_path_old = _tmp4_;
	_tmp5_ = g_strdup ("");
	self->app_conf_path_default = _tmp5_;
	self->first_run = FALSE;
	_tmp6_ = g_strdup ("");
	self->backup_uuid = _tmp6_;
	_tmp7_ = g_strdup ("");
	self->backup_parent_uuid = _tmp7_;
	self->btrfs_mode = TRUE;
	self->include_btrfs_home_for_backup = FALSE;
	self->include_btrfs_home_for_restore = FALSE;
	self->stop_cron_emails = TRUE;
	_tmp8_ = g_strdup ("");
	self->mount_point_restore = _tmp8_;
	_tmp9_ = g_strdup ("");
	self->mount_point_app = _tmp9_;
	self->mirror_system = FALSE;
	self->schedule_monthly = FALSE;
	self->schedule_weekly = FALSE;
	self->schedule_daily = FALSE;
	self->schedule_hourly = FALSE;
	self->schedule_boot = FALSE;
	self->count_monthly = 2;
	self->count_weekly = 3;
	self->count_daily = 5;
	self->count_hourly = 6;
	self->count_boot = 5;
	_tmp10_ = g_strdup ("");
	self->app_mode = _tmp10_;
	self->dry_run = FALSE;
	self->thr_success = FALSE;
	self->thread_restore_running = FALSE;
	self->thread_restore_success = FALSE;
	self->thread_delete_running = FALSE;
	self->thread_delete_success = FALSE;
	self->thread_subvol_info_running = FALSE;
	self->thread_subvol_info_success = FALSE;
	self->thr_retval = -1;
	_tmp11_ = g_strdup ("");
	self->thr_arg1 = _tmp11_;
	self->thr_timeout_active = FALSE;
	_tmp12_ = g_strdup ("");
	self->thr_timeout_cmd = _tmp12_;
	self->startup_delay_interval_mins = 10;
	self->retain_snapshots_max_days = 200;
	_tmp13_ = g_strdup ("");
	self->log_dir = _tmp13_;
	_tmp14_ = g_strdup ("");
	self->log_file = _tmp14_;
	_tmp15_ = g_strdup ("%Y-%m-%d %H:%M:%S");
	self->date_format = _tmp15_;
	self->reinstall_grub2 = TRUE;
	self->update_initramfs = FALSE;
	self->update_grub = TRUE;
	_tmp16_ = g_strdup ("");
	self->grub_device = _tmp16_;
	self->use_option_raw = TRUE;
	self->cmd_skip_grub = FALSE;
	_tmp17_ = g_strdup ("");
	self->cmd_grub_device = _tmp17_;
	_tmp18_ = g_strdup ("");
	self->cmd_target_device = _tmp18_;
	_tmp19_ = g_strdup ("");
	self->cmd_backup_device = _tmp19_;
	_tmp20_ = g_strdup ("");
	self->cmd_snapshot = _tmp20_;
	self->cmd_confirm = FALSE;
	self->cmd_verbose = TRUE;
	self->cmd_scripted = FALSE;
	_tmp21_ = g_strdup ("");
	self->cmd_comments = _tmp21_;
	_tmp22_ = g_strdup ("");
	self->cmd_tags = _tmp22_;
	self->cmd_btrfs_mode = NULL;
	_tmp23_ = g_strdup ("");
	self->progress_text = _tmp23_;
	self->parent_window = NULL;
	_tmp24_ = g_strdup ("");
	self->users_with_encrypted_home = _tmp24_;
	_tmp25_ = g_strdup ("");
	self->encrypted_home_dirs = _tmp25_;
	self->encrypted_home_warning_shown = FALSE;
	self->priv->_live_system = -1;
	_tmp26_ = g_strdup ("");
	self->encrypted_private_dirs = _tmp26_;
	self->encrypted_private_warning_shown = FALSE;
	self->priv->_btrfs_qgroups_enabled_internal = MAIN_QGROUP_STATUS_UNKNOWN;
}

static void
main_finalize (GObject * obj)
{
	Main * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MAIN, Main);
	_g_free0 (self->app_path);
	_g_free0 (self->share_folder);
	_g_free0 (self->rsnapshot_conf_path);
	_g_free0 (self->app_conf_path);
	_g_free0 (self->app_conf_path_old);
	_g_free0 (self->app_conf_path_default);
	_g_free0 (self->backup_uuid);
	_g_free0 (self->backup_parent_uuid);
	_g_object_unref0 (self->partitions);
	_g_object_unref0 (self->exclude_list_user);
	_g_object_unref0 (self->exclude_list_default);
	_g_object_unref0 (self->exclude_list_default_extra);
	_g_object_unref0 (self->exclude_list_home);
	_g_object_unref0 (self->exclude_list_restore);
	_g_object_unref0 (self->exclude_list_apps);
	_g_object_unref0 (self->mount_list);
	_g_object_unref0 (self->exclude_app_names);
	_g_object_unref0 (self->repo);
	_g_object_unref0 (self->sys_root);
	_g_object_unref0 (self->sys_boot);
	_g_object_unref0 (self->sys_efi);
	_g_object_unref0 (self->sys_home);
	_g_object_unref0 (self->sys_subvolumes);
	_g_free0 (self->mount_point_restore);
	_g_free0 (self->mount_point_app);
	_g_object_unref0 (self->current_distro);
	_g_free0 (self->app_mode);
	_g_free0 (self->thr_arg1);
	_g_free0 (self->thr_timeout_cmd);
	_g_free0 (self->log_dir);
	_g_free0 (self->log_file);
	_g_object_unref0 (self->app_lock);
	_g_free0 (self->date_format);
	_g_object_unref0 (self->delete_list);
	_g_object_unref0 (self->snapshot_to_delete);
	_g_object_unref0 (self->snapshot_to_restore);
	_g_free0 (self->grub_device);
	_g_free0 (self->cmd_grub_device);
	_g_free0 (self->cmd_target_device);
	_g_free0 (self->cmd_backup_device);
	_g_free0 (self->cmd_snapshot);
	_g_free0 (self->cmd_comments);
	_g_free0 (self->cmd_tags);
	_g_free0 (self->cmd_btrfs_mode);
	_g_free0 (self->progress_text);
	_g_object_unref0 (self->parent_window);
	_g_object_unref0 (self->task);
	_g_object_unref0 (self->delete_file_task);
	_g_object_unref0 (self->space_check_task);
	_g_object_unref0 (self->current_system_users);
	_g_free0 (self->users_with_encrypted_home);
	_g_free0 (self->encrypted_home_dirs);
	_g_free0 (self->encrypted_private_dirs);
	G_OBJECT_CLASS (main_parent_class)->finalize (obj);
}

static GType
main_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (MainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Main), 0, (GInstanceInitFunc) main_instance_init, NULL };
	GType main_type_id;
	main_type_id = g_type_register_static (G_TYPE_OBJECT, "Main", &g_define_type_info, 0);
	Main_private_offset = g_type_add_instance_private (main_type_id, sizeof (MainPrivate));
	return main_type_id;
}

GType
main_get_type (void)
{
	static volatile gsize main_type_id__once = 0;
	if (g_once_init_enter (&main_type_id__once)) {
		GType main_type_id;
		main_type_id = main_get_type_once ();
		g_once_init_leave (&main_type_id__once, main_type_id);
	}
	return main_type_id__once;
}

static void
_vala_main_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Main * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN, Main);
	switch (property_id) {
		case MAIN_BTRFS_QGROUPS_ENABLED_PROPERTY:
		g_value_set_boolean (value, main_get_btrfs_qgroups_enabled (self));
		break;
		case MAIN_SCHEDULED_PROPERTY:
		g_value_set_boolean (value, main_get_scheduled (self));
		break;
		case MAIN_DST_ROOT_PROPERTY:
		g_value_set_object (value, main_get_dst_root (self));
		break;
		case MAIN_DST_BOOT_PROPERTY:
		g_value_set_object (value, main_get_dst_boot (self));
		break;
		case MAIN_DST_EFI_PROPERTY:
		g_value_set_object (value, main_get_dst_efi (self));
		break;
		case MAIN_DST_HOME_PROPERTY:
		g_value_set_object (value, main_get_dst_home (self));
		break;
		case MAIN_RESTORE_CURRENT_SYSTEM_PROPERTY:
		g_value_set_boolean (value, main_get_restore_current_system (self));
		break;
		case MAIN_RESTORE_SOURCE_PATH_PROPERTY:
		g_value_take_string (value, main_get_restore_source_path (self));
		break;
		case MAIN_RESTORE_TARGET_PATH_PROPERTY:
		g_value_take_string (value, main_get_restore_target_path (self));
		break;
		case MAIN_RESTORE_LOG_FILE_PROPERTY:
		g_value_take_string (value, main_get_restore_log_file (self));
		break;
		case MAIN_RESTORE_EXCLUDE_FILE_PROPERTY:
		g_value_take_string (value, main_get_restore_exclude_file (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_main_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Main * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MAIN, Main);
	switch (property_id) {
		case MAIN_DST_ROOT_PROPERTY:
		main_set_dst_root (self, g_value_get_object (value));
		break;
		case MAIN_DST_BOOT_PROPERTY:
		main_set_dst_boot (self, g_value_get_object (value));
		break;
		case MAIN_DST_EFI_PROPERTY:
		main_set_dst_efi (self, g_value_get_object (value));
		break;
		case MAIN_DST_HOME_PROPERTY:
		main_set_dst_home (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

