// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/monitoring/v3/notification_service.proto

package monitoringpb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	NotificationChannelService_ListNotificationChannelDescriptors_FullMethodName      = "/google.monitoring.v3.NotificationChannelService/ListNotificationChannelDescriptors"
	NotificationChannelService_GetNotificationChannelDescriptor_FullMethodName        = "/google.monitoring.v3.NotificationChannelService/GetNotificationChannelDescriptor"
	NotificationChannelService_ListNotificationChannels_FullMethodName                = "/google.monitoring.v3.NotificationChannelService/ListNotificationChannels"
	NotificationChannelService_GetNotificationChannel_FullMethodName                  = "/google.monitoring.v3.NotificationChannelService/GetNotificationChannel"
	NotificationChannelService_CreateNotificationChannel_FullMethodName               = "/google.monitoring.v3.NotificationChannelService/CreateNotificationChannel"
	NotificationChannelService_UpdateNotificationChannel_FullMethodName               = "/google.monitoring.v3.NotificationChannelService/UpdateNotificationChannel"
	NotificationChannelService_DeleteNotificationChannel_FullMethodName               = "/google.monitoring.v3.NotificationChannelService/DeleteNotificationChannel"
	NotificationChannelService_SendNotificationChannelVerificationCode_FullMethodName = "/google.monitoring.v3.NotificationChannelService/SendNotificationChannelVerificationCode"
	NotificationChannelService_GetNotificationChannelVerificationCode_FullMethodName  = "/google.monitoring.v3.NotificationChannelService/GetNotificationChannelVerificationCode"
	NotificationChannelService_VerifyNotificationChannel_FullMethodName               = "/google.monitoring.v3.NotificationChannelService/VerifyNotificationChannel"
)

// NotificationChannelServiceClient is the client API for NotificationChannelService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NotificationChannelServiceClient interface {
	// Lists the descriptors for supported channel types. The use of descriptors
	// makes it possible for new channel types to be dynamically added.
	ListNotificationChannelDescriptors(ctx context.Context, in *ListNotificationChannelDescriptorsRequest, opts ...grpc.CallOption) (*ListNotificationChannelDescriptorsResponse, error)
	// Gets a single channel descriptor. The descriptor indicates which fields
	// are expected / permitted for a notification channel of the given type.
	GetNotificationChannelDescriptor(ctx context.Context, in *GetNotificationChannelDescriptorRequest, opts ...grpc.CallOption) (*NotificationChannelDescriptor, error)
	// Lists the notification channels that have been created for the project.
	// To list the types of notification channels that are supported, use
	// the `ListNotificationChannelDescriptors` method.
	ListNotificationChannels(ctx context.Context, in *ListNotificationChannelsRequest, opts ...grpc.CallOption) (*ListNotificationChannelsResponse, error)
	// Gets a single notification channel. The channel includes the relevant
	// configuration details with which the channel was created. However, the
	// response may truncate or omit passwords, API keys, or other private key
	// matter and thus the response may not be 100% identical to the information
	// that was supplied in the call to the create method.
	GetNotificationChannel(ctx context.Context, in *GetNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error)
	// Creates a new notification channel, representing a single notification
	// endpoint such as an email address, SMS number, or PagerDuty service.
	//
	// Design your application to single-thread API calls that modify the state of
	// notification channels in a single project. This includes calls to
	// CreateNotificationChannel, DeleteNotificationChannel and
	// UpdateNotificationChannel.
	CreateNotificationChannel(ctx context.Context, in *CreateNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error)
	// Updates a notification channel. Fields not specified in the field mask
	// remain unchanged.
	//
	// Design your application to single-thread API calls that modify the state of
	// notification channels in a single project. This includes calls to
	// CreateNotificationChannel, DeleteNotificationChannel and
	// UpdateNotificationChannel.
	UpdateNotificationChannel(ctx context.Context, in *UpdateNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error)
	// Deletes a notification channel.
	//
	// Design your application to single-thread API calls that modify the state of
	// notification channels in a single project. This includes calls to
	// CreateNotificationChannel, DeleteNotificationChannel and
	// UpdateNotificationChannel.
	DeleteNotificationChannel(ctx context.Context, in *DeleteNotificationChannelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Causes a verification code to be delivered to the channel. The code
	// can then be supplied in `VerifyNotificationChannel` to verify the channel.
	SendNotificationChannelVerificationCode(ctx context.Context, in *SendNotificationChannelVerificationCodeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Requests a verification code for an already verified channel that can then
	// be used in a call to VerifyNotificationChannel() on a different channel
	// with an equivalent identity in the same or in a different project. This
	// makes it possible to copy a channel between projects without requiring
	// manual reverification of the channel. If the channel is not in the
	// verified state, this method will fail (in other words, this may only be
	// used if the SendNotificationChannelVerificationCode and
	// VerifyNotificationChannel paths have already been used to put the given
	// channel into the verified state).
	//
	// There is no guarantee that the verification codes returned by this method
	// will be of a similar structure or form as the ones that are delivered
	// to the channel via SendNotificationChannelVerificationCode; while
	// VerifyNotificationChannel() will recognize both the codes delivered via
	// SendNotificationChannelVerificationCode() and returned from
	// GetNotificationChannelVerificationCode(), it is typically the case that
	// the verification codes delivered via
	// SendNotificationChannelVerificationCode() will be shorter and also
	// have a shorter expiration (e.g. codes such as "G-123456") whereas
	// GetVerificationCode() will typically return a much longer, websafe base
	// 64 encoded string that has a longer expiration time.
	GetNotificationChannelVerificationCode(ctx context.Context, in *GetNotificationChannelVerificationCodeRequest, opts ...grpc.CallOption) (*GetNotificationChannelVerificationCodeResponse, error)
	// Verifies a `NotificationChannel` by proving receipt of the code
	// delivered to the channel as a result of calling
	// `SendNotificationChannelVerificationCode`.
	VerifyNotificationChannel(ctx context.Context, in *VerifyNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error)
}

type notificationChannelServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewNotificationChannelServiceClient(cc grpc.ClientConnInterface) NotificationChannelServiceClient {
	return &notificationChannelServiceClient{cc}
}

func (c *notificationChannelServiceClient) ListNotificationChannelDescriptors(ctx context.Context, in *ListNotificationChannelDescriptorsRequest, opts ...grpc.CallOption) (*ListNotificationChannelDescriptorsResponse, error) {
	out := new(ListNotificationChannelDescriptorsResponse)
	err := c.cc.Invoke(ctx, NotificationChannelService_ListNotificationChannelDescriptors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) GetNotificationChannelDescriptor(ctx context.Context, in *GetNotificationChannelDescriptorRequest, opts ...grpc.CallOption) (*NotificationChannelDescriptor, error) {
	out := new(NotificationChannelDescriptor)
	err := c.cc.Invoke(ctx, NotificationChannelService_GetNotificationChannelDescriptor_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) ListNotificationChannels(ctx context.Context, in *ListNotificationChannelsRequest, opts ...grpc.CallOption) (*ListNotificationChannelsResponse, error) {
	out := new(ListNotificationChannelsResponse)
	err := c.cc.Invoke(ctx, NotificationChannelService_ListNotificationChannels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) GetNotificationChannel(ctx context.Context, in *GetNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error) {
	out := new(NotificationChannel)
	err := c.cc.Invoke(ctx, NotificationChannelService_GetNotificationChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) CreateNotificationChannel(ctx context.Context, in *CreateNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error) {
	out := new(NotificationChannel)
	err := c.cc.Invoke(ctx, NotificationChannelService_CreateNotificationChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) UpdateNotificationChannel(ctx context.Context, in *UpdateNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error) {
	out := new(NotificationChannel)
	err := c.cc.Invoke(ctx, NotificationChannelService_UpdateNotificationChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) DeleteNotificationChannel(ctx context.Context, in *DeleteNotificationChannelRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, NotificationChannelService_DeleteNotificationChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) SendNotificationChannelVerificationCode(ctx context.Context, in *SendNotificationChannelVerificationCodeRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, NotificationChannelService_SendNotificationChannelVerificationCode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) GetNotificationChannelVerificationCode(ctx context.Context, in *GetNotificationChannelVerificationCodeRequest, opts ...grpc.CallOption) (*GetNotificationChannelVerificationCodeResponse, error) {
	out := new(GetNotificationChannelVerificationCodeResponse)
	err := c.cc.Invoke(ctx, NotificationChannelService_GetNotificationChannelVerificationCode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *notificationChannelServiceClient) VerifyNotificationChannel(ctx context.Context, in *VerifyNotificationChannelRequest, opts ...grpc.CallOption) (*NotificationChannel, error) {
	out := new(NotificationChannel)
	err := c.cc.Invoke(ctx, NotificationChannelService_VerifyNotificationChannel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NotificationChannelServiceServer is the server API for NotificationChannelService service.
// All implementations should embed UnimplementedNotificationChannelServiceServer
// for forward compatibility
type NotificationChannelServiceServer interface {
	// Lists the descriptors for supported channel types. The use of descriptors
	// makes it possible for new channel types to be dynamically added.
	ListNotificationChannelDescriptors(context.Context, *ListNotificationChannelDescriptorsRequest) (*ListNotificationChannelDescriptorsResponse, error)
	// Gets a single channel descriptor. The descriptor indicates which fields
	// are expected / permitted for a notification channel of the given type.
	GetNotificationChannelDescriptor(context.Context, *GetNotificationChannelDescriptorRequest) (*NotificationChannelDescriptor, error)
	// Lists the notification channels that have been created for the project.
	// To list the types of notification channels that are supported, use
	// the `ListNotificationChannelDescriptors` method.
	ListNotificationChannels(context.Context, *ListNotificationChannelsRequest) (*ListNotificationChannelsResponse, error)
	// Gets a single notification channel. The channel includes the relevant
	// configuration details with which the channel was created. However, the
	// response may truncate or omit passwords, API keys, or other private key
	// matter and thus the response may not be 100% identical to the information
	// that was supplied in the call to the create method.
	GetNotificationChannel(context.Context, *GetNotificationChannelRequest) (*NotificationChannel, error)
	// Creates a new notification channel, representing a single notification
	// endpoint such as an email address, SMS number, or PagerDuty service.
	//
	// Design your application to single-thread API calls that modify the state of
	// notification channels in a single project. This includes calls to
	// CreateNotificationChannel, DeleteNotificationChannel and
	// UpdateNotificationChannel.
	CreateNotificationChannel(context.Context, *CreateNotificationChannelRequest) (*NotificationChannel, error)
	// Updates a notification channel. Fields not specified in the field mask
	// remain unchanged.
	//
	// Design your application to single-thread API calls that modify the state of
	// notification channels in a single project. This includes calls to
	// CreateNotificationChannel, DeleteNotificationChannel and
	// UpdateNotificationChannel.
	UpdateNotificationChannel(context.Context, *UpdateNotificationChannelRequest) (*NotificationChannel, error)
	// Deletes a notification channel.
	//
	// Design your application to single-thread API calls that modify the state of
	// notification channels in a single project. This includes calls to
	// CreateNotificationChannel, DeleteNotificationChannel and
	// UpdateNotificationChannel.
	DeleteNotificationChannel(context.Context, *DeleteNotificationChannelRequest) (*emptypb.Empty, error)
	// Causes a verification code to be delivered to the channel. The code
	// can then be supplied in `VerifyNotificationChannel` to verify the channel.
	SendNotificationChannelVerificationCode(context.Context, *SendNotificationChannelVerificationCodeRequest) (*emptypb.Empty, error)
	// Requests a verification code for an already verified channel that can then
	// be used in a call to VerifyNotificationChannel() on a different channel
	// with an equivalent identity in the same or in a different project. This
	// makes it possible to copy a channel between projects without requiring
	// manual reverification of the channel. If the channel is not in the
	// verified state, this method will fail (in other words, this may only be
	// used if the SendNotificationChannelVerificationCode and
	// VerifyNotificationChannel paths have already been used to put the given
	// channel into the verified state).
	//
	// There is no guarantee that the verification codes returned by this method
	// will be of a similar structure or form as the ones that are delivered
	// to the channel via SendNotificationChannelVerificationCode; while
	// VerifyNotificationChannel() will recognize both the codes delivered via
	// SendNotificationChannelVerificationCode() and returned from
	// GetNotificationChannelVerificationCode(), it is typically the case that
	// the verification codes delivered via
	// SendNotificationChannelVerificationCode() will be shorter and also
	// have a shorter expiration (e.g. codes such as "G-123456") whereas
	// GetVerificationCode() will typically return a much longer, websafe base
	// 64 encoded string that has a longer expiration time.
	GetNotificationChannelVerificationCode(context.Context, *GetNotificationChannelVerificationCodeRequest) (*GetNotificationChannelVerificationCodeResponse, error)
	// Verifies a `NotificationChannel` by proving receipt of the code
	// delivered to the channel as a result of calling
	// `SendNotificationChannelVerificationCode`.
	VerifyNotificationChannel(context.Context, *VerifyNotificationChannelRequest) (*NotificationChannel, error)
}

// UnimplementedNotificationChannelServiceServer should be embedded to have forward compatible implementations.
type UnimplementedNotificationChannelServiceServer struct {
}

func (UnimplementedNotificationChannelServiceServer) ListNotificationChannelDescriptors(context.Context, *ListNotificationChannelDescriptorsRequest) (*ListNotificationChannelDescriptorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationChannelDescriptors not implemented")
}
func (UnimplementedNotificationChannelServiceServer) GetNotificationChannelDescriptor(context.Context, *GetNotificationChannelDescriptorRequest) (*NotificationChannelDescriptor, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationChannelDescriptor not implemented")
}
func (UnimplementedNotificationChannelServiceServer) ListNotificationChannels(context.Context, *ListNotificationChannelsRequest) (*ListNotificationChannelsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNotificationChannels not implemented")
}
func (UnimplementedNotificationChannelServiceServer) GetNotificationChannel(context.Context, *GetNotificationChannelRequest) (*NotificationChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationChannel not implemented")
}
func (UnimplementedNotificationChannelServiceServer) CreateNotificationChannel(context.Context, *CreateNotificationChannelRequest) (*NotificationChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateNotificationChannel not implemented")
}
func (UnimplementedNotificationChannelServiceServer) UpdateNotificationChannel(context.Context, *UpdateNotificationChannelRequest) (*NotificationChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNotificationChannel not implemented")
}
func (UnimplementedNotificationChannelServiceServer) DeleteNotificationChannel(context.Context, *DeleteNotificationChannelRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNotificationChannel not implemented")
}
func (UnimplementedNotificationChannelServiceServer) SendNotificationChannelVerificationCode(context.Context, *SendNotificationChannelVerificationCodeRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendNotificationChannelVerificationCode not implemented")
}
func (UnimplementedNotificationChannelServiceServer) GetNotificationChannelVerificationCode(context.Context, *GetNotificationChannelVerificationCodeRequest) (*GetNotificationChannelVerificationCodeResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetNotificationChannelVerificationCode not implemented")
}
func (UnimplementedNotificationChannelServiceServer) VerifyNotificationChannel(context.Context, *VerifyNotificationChannelRequest) (*NotificationChannel, error) {
	return nil, status.Errorf(codes.Unimplemented, "method VerifyNotificationChannel not implemented")
}

// UnsafeNotificationChannelServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NotificationChannelServiceServer will
// result in compilation errors.
type UnsafeNotificationChannelServiceServer interface {
	mustEmbedUnimplementedNotificationChannelServiceServer()
}

func RegisterNotificationChannelServiceServer(s grpc.ServiceRegistrar, srv NotificationChannelServiceServer) {
	s.RegisterService(&NotificationChannelService_ServiceDesc, srv)
}

func _NotificationChannelService_ListNotificationChannelDescriptors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationChannelDescriptorsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).ListNotificationChannelDescriptors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_ListNotificationChannelDescriptors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).ListNotificationChannelDescriptors(ctx, req.(*ListNotificationChannelDescriptorsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_GetNotificationChannelDescriptor_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationChannelDescriptorRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).GetNotificationChannelDescriptor(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_GetNotificationChannelDescriptor_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).GetNotificationChannelDescriptor(ctx, req.(*GetNotificationChannelDescriptorRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_ListNotificationChannels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNotificationChannelsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).ListNotificationChannels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_ListNotificationChannels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).ListNotificationChannels(ctx, req.(*ListNotificationChannelsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_GetNotificationChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).GetNotificationChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_GetNotificationChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).GetNotificationChannel(ctx, req.(*GetNotificationChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_CreateNotificationChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateNotificationChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).CreateNotificationChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_CreateNotificationChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).CreateNotificationChannel(ctx, req.(*CreateNotificationChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_UpdateNotificationChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNotificationChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).UpdateNotificationChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_UpdateNotificationChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).UpdateNotificationChannel(ctx, req.(*UpdateNotificationChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_DeleteNotificationChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNotificationChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).DeleteNotificationChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_DeleteNotificationChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).DeleteNotificationChannel(ctx, req.(*DeleteNotificationChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_SendNotificationChannelVerificationCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendNotificationChannelVerificationCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).SendNotificationChannelVerificationCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_SendNotificationChannelVerificationCode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).SendNotificationChannelVerificationCode(ctx, req.(*SendNotificationChannelVerificationCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_GetNotificationChannelVerificationCode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNotificationChannelVerificationCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).GetNotificationChannelVerificationCode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_GetNotificationChannelVerificationCode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).GetNotificationChannelVerificationCode(ctx, req.(*GetNotificationChannelVerificationCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NotificationChannelService_VerifyNotificationChannel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(VerifyNotificationChannelRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NotificationChannelServiceServer).VerifyNotificationChannel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NotificationChannelService_VerifyNotificationChannel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NotificationChannelServiceServer).VerifyNotificationChannel(ctx, req.(*VerifyNotificationChannelRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NotificationChannelService_ServiceDesc is the grpc.ServiceDesc for NotificationChannelService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NotificationChannelService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.monitoring.v3.NotificationChannelService",
	HandlerType: (*NotificationChannelServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListNotificationChannelDescriptors",
			Handler:    _NotificationChannelService_ListNotificationChannelDescriptors_Handler,
		},
		{
			MethodName: "GetNotificationChannelDescriptor",
			Handler:    _NotificationChannelService_GetNotificationChannelDescriptor_Handler,
		},
		{
			MethodName: "ListNotificationChannels",
			Handler:    _NotificationChannelService_ListNotificationChannels_Handler,
		},
		{
			MethodName: "GetNotificationChannel",
			Handler:    _NotificationChannelService_GetNotificationChannel_Handler,
		},
		{
			MethodName: "CreateNotificationChannel",
			Handler:    _NotificationChannelService_CreateNotificationChannel_Handler,
		},
		{
			MethodName: "UpdateNotificationChannel",
			Handler:    _NotificationChannelService_UpdateNotificationChannel_Handler,
		},
		{
			MethodName: "DeleteNotificationChannel",
			Handler:    _NotificationChannelService_DeleteNotificationChannel_Handler,
		},
		{
			MethodName: "SendNotificationChannelVerificationCode",
			Handler:    _NotificationChannelService_SendNotificationChannelVerificationCode_Handler,
		},
		{
			MethodName: "GetNotificationChannelVerificationCode",
			Handler:    _NotificationChannelService_GetNotificationChannelVerificationCode_Handler,
		},
		{
			MethodName: "VerifyNotificationChannel",
			Handler:    _NotificationChannelService_VerifyNotificationChannel_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/monitoring/v3/notification_service.proto",
}
