
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "cutterbindings_python.h"

// main header
#include "cuttercore_wrapper.h"

// Wrappers providing overrides
#include "mainwindow_wrapper.h"
#include "cutterdockwidget_wrapper.h"

// Argument includes
#include <BasicBlockHighlighter.h>
#include <BasicInstructionHighlighter.h>
#include <Cutter.h>
#include <QHash>
#include <QList>
#include <QString>
#include <QStringList>
#include <qbytearray.h>
#include <qcolor.h>
#include <qdir.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qvariant.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_CutterCore_Type = nullptr;
static PyTypeObject *Sbk_CutterCore_TypeF(void)
{
    return _Sbk_CutterCore_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void CutterCoreWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

CutterCoreWrapper::CutterCoreWrapper(::QObject * parent) : CutterCore(parent)
{
}

void CutterCoreWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    MainWindowWrapper::sbk_o_childEvent("CutterCore", funcName, gil, pyOverride, event);
}

void CutterCoreWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    MainWindowWrapper::sbk_o_connectNotify("CutterCore", funcName, gil, pyOverride, signal);
}

void CutterCoreWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    MainWindowWrapper::sbk_o_customEvent("CutterCore", funcName, gil, pyOverride, event);
}

void CutterCoreWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    MainWindowWrapper::sbk_o_connectNotify("CutterCore", funcName, gil, pyOverride, signal);
}

bool CutterCoreWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return CutterDockWidgetWrapper::sbk_o_event("CutterCore", funcName, gil, pyOverride, event);
}

bool CutterCoreWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return CutterDockWidgetWrapper::sbk_o_eventFilter("CutterCore", funcName, gil, pyOverride, watched, event);
}

void CutterCoreWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_CutterCore_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    MainWindowWrapper::sbk_o_timerEvent("CutterCore", funcName, gil, pyOverride, event);
}

const QMetaObject *CutterCoreWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return CutterCore::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int CutterCoreWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = CutterCore::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *CutterCoreWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< CutterCoreWrapper *>(this));
    }
    return CutterCore::qt_metacast(_clname);
}

CutterCoreWrapper::~CutterCoreWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_CutterCore_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_CutterCore_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::CutterCore >()))
        return -1;

    CutterCoreWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:CutterCore", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: CutterCore::CutterCore(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // CutterCore(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // CutterCore(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // CutterCore(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) CutterCoreWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new CutterCoreWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< CutterCore >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
    };


    return 1;
}

static PyObject *Sbk_CutterCoreFunc_addFlag(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addFlag", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::addFlag(qulonglong,QString,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2])))) {
        overloadId = 0; // addFlag(qulonglong,QString,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addFlag", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned long long cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addFlag(qulonglong,QString,qulonglong)
            cppSelf->addFlag(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_addGlobalVariable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addGlobalVariable", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::addGlobalVariable(qulonglong,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // addGlobalVariable(qulonglong,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addGlobalVariable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addGlobalVariable(qulonglong,QString,QString)
            cppSelf->addGlobalVariable(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_ansiEscapeToHtml(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static CutterCore::ansiEscapeToHtml(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // ansiEscapeToHtml(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "ansiEscapeToHtml", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ansiEscapeToHtml(QString)
            QString cppResult = ::CutterCore::ansiEscapeToHtml(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_applySignature(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::applySignature(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // applySignature(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "applySignature", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // applySignature(QString)
            cppSelf->applySignature(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_applyStructureOffset(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "applyStructureOffset", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OO:applyStructureOffset", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::applyStructureOffset(QString,qulonglong=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // applyStructureOffset(QString,qulonglong)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
            overloadId = 0; // applyStructureOffset(QString,qulonglong)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "applyStructureOffset", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"offset", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "applyStructureOffset", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1 = RVA_INVALID;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // applyStructureOffset(QString,qulonglong)
            cppSelf->applyStructureOffset(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_assemble(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::assemble(QString)->QByteArray
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // assemble(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "assemble", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // assemble(QString)
            QByteArray cppResult = cppSelf->assemble(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_attachDebug(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::attachDebug(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // attachDebug(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "attachDebug", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // attachDebug(int)
            cppSelf->attachDebug(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_attachRemote(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::attachRemote(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // attachRemote(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "attachRemote", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // attachRemote(QString)
            cppSelf->attachRemote(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_breakpointIndexAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::breakpointIndexAt(qulonglong)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // breakpointIndexAt(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "breakpointIndexAt", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // breakpointIndexAt(qulonglong)
            int cppResult = cppSelf->breakpointIndexAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_bytesToHexString(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static CutterCore::bytesToHexString(QByteArray)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // bytesToHexString(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "bytesToHexString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // bytesToHexString(QByteArray)
            QString cppResult = ::CutterCore::bytesToHexString(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_cmd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::cmd(QString)->QString
    // 1: CutterCore::cmd(const char*)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // cmd(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // cmd(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "cmd", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // cmd(const QString &str)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // cmd(QString)
                QString cppResult = cppSelf->cmd(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // cmd(const char *str)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // cmd(const char*)
                QString cppResult = cppSelf->cmd(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_cmdRaw(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::cmdRaw(QString)->QString
    // 1: CutterCore::cmdRaw(const char*)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // cmdRaw(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // cmdRaw(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "cmdRaw", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // cmdRaw(const QString &cmd)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // cmdRaw(QString)
                QString cppResult = cppSelf->cmdRaw(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // cmdRaw(const char *cmd)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // cmdRaw(const char*)
                QString cppResult = cppSelf->cmdRaw(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_cmdRawAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "cmdRawAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::cmdRawAt(QString,qulonglong)->QString
    // 1: CutterCore::cmdRawAt(const char*,qulonglong)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
        overloadId = 1; // cmdRawAt(const char*,qulonglong)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
        overloadId = 0; // cmdRawAt(QString,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "cmdRawAt", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // cmdRawAt(const QString &str, unsigned long long address)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // cmdRawAt(QString,qulonglong)
                QString cppResult = cppSelf->cmdRawAt(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // cmdRawAt(const char *cmd, unsigned long long address)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            unsigned long long cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // cmdRawAt(const char*,qulonglong)
                QString cppResult = cppSelf->cmdRawAt(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_cmdTask(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::cmdTask(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // cmdTask(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "cmdTask", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // cmdTask(QString)
            QString cppResult = cppSelf->cmdTask(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_commitWriteCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // commitWriteCache()
        cppSelf->commitWriteCache();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_continueBackDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // continueBackDebug()
        cppSelf->continueBackDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_continueDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // continueDebug()
        cppSelf->continueDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_continueUntilCall(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // continueUntilCall()
        cppSelf->continueUntilCall();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_continueUntilDebug(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::continueUntilDebug(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // continueUntilDebug(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "continueUntilDebug", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // continueUntilDebug(qulonglong)
            cppSelf->continueUntilDebug(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_continueUntilSyscall(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // continueUntilSyscall()
        cppSelf->continueUntilSyscall();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_createFunctionAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "createFunctionAt", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::createFunctionAt(qulonglong)
    // 1: CutterCore::createFunctionAt(qulonglong,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // createFunctionAt(qulonglong)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 1; // createFunctionAt(qulonglong,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "createFunctionAt", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // createFunctionAt(unsigned long long addr)
        {
            unsigned long long cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // createFunctionAt(qulonglong)
                cppSelf->createFunctionAt(cppArg0);
            }
            break;
        }
        case 1: // createFunctionAt(unsigned long long addr, QString name)
        {
            unsigned long long cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // createFunctionAt(qulonglong,QString)
                cppSelf->createFunctionAt(cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_createNewClass(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::createNewClass(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // createNewClass(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createNewClass", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createNewClass(QString)
            cppSelf->createNewClass(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_createSignature(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::createSignature(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // createSignature(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createSignature", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createSignature(QString)
            cppSelf->createSignature(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_delAllBreakpoints(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // delAllBreakpoints()
        cppSelf->delAllBreakpoints();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_delBreakpoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::delBreakpoint(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // delBreakpoint(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "delBreakpoint", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // delBreakpoint(qulonglong)
            cppSelf->delBreakpoint(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_delComment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::delComment(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // delComment(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "delComment", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // delComment(qulonglong)
            cppSelf->delComment(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_delFlag(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::delFlag(QString)
    // 1: CutterCore::delFlag(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 1; // delFlag(qulonglong)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // delFlag(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "delFlag", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // delFlag(const QString &name)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // delFlag(QString)
                cppSelf->delFlag(cppArg0);
            }
            break;
        }
        case 1: // delFlag(unsigned long long addr)
        {
            unsigned long long cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // delFlag(qulonglong)
                cppSelf->delFlag(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_delFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::delFunction(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // delFunction(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "delFunction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // delFunction(qulonglong)
            cppSelf->delFunction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_delGlobalVariable(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::delGlobalVariable(QString)
    // 1: CutterCore::delGlobalVariable(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 1; // delGlobalVariable(qulonglong)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // delGlobalVariable(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "delGlobalVariable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // delGlobalVariable(QString name)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // delGlobalVariable(QString)
                cppSelf->delGlobalVariable(cppArg0);
            }
            break;
        }
        case 1: // delGlobalVariable(unsigned long long offset)
        {
            unsigned long long cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // delGlobalVariable(qulonglong)
                cppSelf->delGlobalVariable(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_deleteClass(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::deleteClass(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // deleteClass(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "deleteClass", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // deleteClass(QString)
            cppSelf->deleteClass(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_disableBreakpoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::disableBreakpoint(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // disableBreakpoint(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "disableBreakpoint", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // disableBreakpoint(qulonglong)
            cppSelf->disableBreakpoint(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_disassemble(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::disassemble(QByteArray)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // disassemble(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "disassemble", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // disassemble(QByteArray)
            QString cppResult = cppSelf->disassemble(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_disassembleSingleInstruction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::disassembleSingleInstruction(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // disassembleSingleInstruction(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "disassembleSingleInstruction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // disassembleSingleInstruction(qulonglong)
            QString cppResult = cppSelf->disassembleSingleInstruction(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_editBytes(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "editBytes", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::editBytes(qulonglong,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // editBytes(qulonglong,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "editBytes", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // editBytes(qulonglong,QString)
            cppSelf->editBytes(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_editBytesEndian(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "editBytesEndian", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::editBytesEndian(qulonglong,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // editBytesEndian(qulonglong,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "editBytesEndian", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // editBytesEndian(qulonglong,QString)
            cppSelf->editBytesEndian(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_editInstruction(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "editInstruction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:editInstruction", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::editInstruction(qulonglong,QString,bool=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // editInstruction(qulonglong,QString,bool)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2])))) {
            overloadId = 0; // editInstruction(qulonglong,QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "editInstruction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"fillWithNops", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "editInstruction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        bool cppArg2 = false;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // editInstruction(qulonglong,QString,bool)
            cppSelf->editInstruction(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_enableBreakpoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::enableBreakpoint(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // enableBreakpoint(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "enableBreakpoint", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // enableBreakpoint(qulonglong)
            cppSelf->enableBreakpoint(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_existsFileInfo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // existsFileInfo()
        bool cppResult = cppSelf->existsFileInfo();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_flagAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::flagAt(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // flagAt(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "flagAt", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // flagAt(qulonglong)
            QString cppResult = cppSelf->flagAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getActiveDebugPlugin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getActiveDebugPlugin()
        QString cppResult = cppSelf->getActiveDebugPlugin();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getAllAnalysisClasses(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getAllAnalysisClasses(bool)->QList<QString>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // getAllAnalysisClasses(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getAllAnalysisClasses", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getAllAnalysisClasses(bool)
            QList<QString> cppResult = cppSelf->getAllAnalysisClasses(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getAnalysisPluginNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAnalysisPluginNames()
        QStringList cppResult = cppSelf->getAnalysisPluginNames();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getArchBits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getArchBits()
        int cppResult = cppSelf->getArchBits();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getAsmPluginNames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAsmPluginNames()
        QStringList cppResult = cppSelf->getAsmPluginNames();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getBBHighlighter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getBBHighlighter()
        BasicBlockHighlighter * cppResult = cppSelf->getBBHighlighter();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_BasicBlockHighlighter_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getBIHighlighter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getBIHighlighter()
        BasicInstructionHighlighter * cppResult = cppSelf->getBIHighlighter();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_BasicInstructionHighlighter_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getBreakpointsAddresses(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getBreakpointsAddresses()
        QList<unsigned long long> cppResult = cppSelf->getBreakpointsAddresses();
        pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getBreakpointsInFunction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getBreakpointsInFunction(qulonglong)->QList<unsigned long long>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getBreakpointsInFunction(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getBreakpointsInFunction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getBreakpointsInFunction(qulonglong)
            QList<unsigned long long> cppResult = cppSelf->getBreakpointsInFunction(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getColorThemes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getColorThemes()
        QStringList cppResult = cppSelf->getColorThemes();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getCommentAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getCommentAt(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getCommentAt(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getCommentAt", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getCommentAt(qulonglong)
            QString cppResult = cppSelf->getCommentAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfig(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getConfig(QString)->QString
    // 1: CutterCore::getConfig(const char*)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // getConfig(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfig(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfig", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getConfig(const QString &k)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfig(QString)
                QString cppResult = cppSelf->getConfig(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // getConfig(const char *k)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfig(const char*)
                QString cppResult = cppSelf->getConfig(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfigDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getConfigDescription(const char*)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // getConfigDescription(const char*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigDescription", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigDescription(const char*)
            QString cppResult = cppSelf->getConfigDescription(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfigOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getConfigOptions(const char*)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 0; // getConfigOptions(const char*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigOptions", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        const char* cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigOptions(const char*)
            QStringList cppResult = cppSelf->getConfigOptions(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfigVariableSpaces(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getConfigVariableSpaces", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|O:getConfigVariableSpaces", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::getConfigVariableSpaces(const QString&=)->QStringList
    if (numArgs == 0) {
        overloadId = 0; // getConfigVariableSpaces(QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        overloadId = 0; // getConfigVariableSpaces(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getConfigVariableSpaces", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"key", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getConfigVariableSpaces", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        ::QString cppArg0 = "";
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getConfigVariableSpaces(QString)
            QStringList cppResult = cppSelf->getConfigVariableSpaces(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfigb(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getConfigb(QString)->bool
    // 1: CutterCore::getConfigb(const char*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // getConfigb(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigb(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigb", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getConfigb(const QString &k)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfigb(QString)
                bool cppResult = cppSelf->getConfigb(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // getConfigb(const char *k)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfigb(const char*)
                bool cppResult = cppSelf->getConfigb(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfigi(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getConfigi(QString)->int
    // 1: CutterCore::getConfigi(const char*)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // getConfigi(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigi(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigi", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getConfigi(const QString &k)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfigi(QString)
                int cppResult = cppSelf->getConfigi(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // getConfigi(const char *k)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfigi(const char*)
                int cppResult = cppSelf->getConfigi(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getConfigut64(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getConfigut64(QString)->unsigned long long
    // 1: CutterCore::getConfigut64(const char*)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArg)))) {
        overloadId = 1; // getConfigut64(const char*)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getConfigut64(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getConfigut64", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getConfigut64(const QString &k)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfigut64(QString)
                unsigned long long cppResult = cppSelf->getConfigut64(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
            }
            break;
        }
        case 1: // getConfigut64(const char *k)
        {
            const char* cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getConfigut64(const char*)
                unsigned long long cppResult = cppSelf->getConfigut64(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getCutterRCDefaultDirectory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getCutterRCDefaultDirectory()const
        QDir cppResult = const_cast<const ::CutterCore *>(cppSelf)->getCutterRCDefaultDirectory();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QDir_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getDebugPlugins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getDebugPlugins()
        QStringList cppResult = cppSelf->getDebugPlugins();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getDisassemblyPreview(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "getDisassemblyPreview", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::getDisassemblyPreview(qulonglong,int)->QStringList
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // getDisassemblyPreview(qulonglong,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getDisassemblyPreview", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getDisassemblyPreview(qulonglong,int)
            QStringList cppResult = cppSelf->getDisassemblyPreview(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getFunctionEnd(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getFunctionEnd(qulonglong)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getFunctionEnd(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getFunctionEnd", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getFunctionEnd(qulonglong)
            unsigned long long cppResult = cppSelf->getFunctionEnd(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getFunctionStart(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getFunctionStart(qulonglong)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getFunctionStart(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getFunctionStart", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getFunctionStart(qulonglong)
            unsigned long long cppResult = cppSelf->getFunctionStart(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getGlobalVariableType(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getGlobalVariableType(QString)->QString
    // 1: CutterCore::getGlobalVariableType(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 1; // getGlobalVariableType(qulonglong)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getGlobalVariableType(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getGlobalVariableType", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // getGlobalVariableType(QString name)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getGlobalVariableType(QString)
                QString cppResult = cppSelf->getGlobalVariableType(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // getGlobalVariableType(unsigned long long offset)
        {
            unsigned long long cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // getGlobalVariableType(qulonglong)
                QString cppResult = cppSelf->getGlobalVariableType(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getHexdumpPreview(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "getHexdumpPreview", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::getHexdumpPreview(qulonglong,int)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // getHexdumpPreview(qulonglong,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getHexdumpPreview", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getHexdumpPreview(qulonglong,int)
            QString cppResult = cppSelf->getHexdumpPreview(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getInstructionBytes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getInstructionBytes(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getInstructionBytes(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getInstructionBytes", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getInstructionBytes(qulonglong)
            QString cppResult = cppSelf->getInstructionBytes(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getInstructionOpcode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getInstructionOpcode(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getInstructionOpcode(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getInstructionOpcode", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getInstructionOpcode(qulonglong)
            QString cppResult = cppSelf->getInstructionOpcode(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getLastFunctionInstruction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getLastFunctionInstruction(qulonglong)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getLastFunctionInstruction(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getLastFunctionInstruction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getLastFunctionInstruction(qulonglong)
            unsigned long long cppResult = cppSelf->getLastFunctionInstruction(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getMetaString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getMetaString(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getMetaString(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getMetaString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getMetaString(qulonglong)
            QString cppResult = cppSelf->getMetaString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getOffset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getOffset()
        unsigned long long cppResult = cppSelf->getOffset();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getOffsetJump(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getOffsetJump(qulonglong)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getOffsetJump(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getOffsetJump", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getOffsetJump(qulonglong)
            unsigned long long cppResult = cppSelf->getOffsetJump(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getProgramCounterValue(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getProgramCounterValue()
        unsigned long long cppResult = cppSelf->getProgramCounterValue();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getRegisterName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getRegisterName(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getRegisterName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getRegisterName", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getRegisterName(QString)
            QString cppResult = cppSelf->getRegisterName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getRegs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getRegs()
        cppSelf->getRegs();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_getRizinVersionReadable(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "getRizinVersionReadable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|O:getRizinVersionReadable", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::getRizinVersionReadable(const char*=)->QString
    if (numArgs == 0) {
        overloadId = 0; // getRizinVersionReadable(const char*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        overloadId = 0; // getRizinVersionReadable(const char*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "getRizinVersionReadable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"program", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "getRizinVersionReadable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        const char* cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getRizinVersionReadable(const char*)
            QString cppResult = cppSelf->getRizinVersionReadable(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getSectionList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getSectionList()
        QStringList cppResult = cppSelf->getSectionList();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getSeekHistory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getSeekHistory()
        QList<unsigned long long> cppResult = cppSelf->getSeekHistory();
        pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getString(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // getString(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getString(qulonglong)
            QString cppResult = cppSelf->getString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getTheme(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getTheme()
        QHash<QString,QColor> cppResult = cppSelf->getTheme();
        pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QHash_QString_QColor_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getThemeKeys(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getThemeKeys()
        QStringList cppResult = cppSelf->getThemeKeys();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getTypeAsC(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::getTypeAsC(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // getTypeAsC(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getTypeAsC", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // getTypeAsC(QString)
            QString cppResult = cppSelf->getTypeAsC(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_getVersionInformation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getVersionInformation()
        QString cppResult = cppSelf->getVersionInformation();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_handleREvent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "handleREvent", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::handleREvent(int,void*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), (pyArgs[1])))) {
        overloadId = 0; // handleREvent(int,void*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "handleREvent", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        void* cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // handleREvent(int,void*)
            cppSelf->handleREvent(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_hexStringToBytes(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static CutterCore::hexStringToBytes(QString)->QByteArray
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // hexStringToBytes(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hexStringToBytes", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // hexStringToBytes(QString)
            QByteArray cppResult = ::CutterCore::hexStringToBytes(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_initialize(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "initialize", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|O:initialize", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::initialize(bool=)
    if (numArgs == 0) {
        overloadId = 0; // initialize(bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // initialize(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "initialize", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"loadPlugins", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "initialize", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // initialize(bool)
            cppSelf->initialize(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_instance(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // instance()
        CutterCore * cppResult = ::CutterCore::instance();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_ioRead(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "ioRead", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::ioRead(qulonglong,int)->QByteArray
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // ioRead(qulonglong,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "ioRead", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // ioRead(qulonglong,int)
            QByteArray cppResult = cppSelf->ioRead(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isAddressMapped(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::isAddressMapped(qulonglong)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // isAddressMapped(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "isAddressMapped", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isAddressMapped(qulonglong)
            bool cppResult = cppSelf->isAddressMapped(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isBreakpoint(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "isBreakpoint", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::isBreakpoint(QList<qulonglong>,qulonglong)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_unsignedlonglong_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
        overloadId = 0; // isBreakpoint(QList<qulonglong>,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "isBreakpoint", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QList<unsigned long long> cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // isBreakpoint(QList<qulonglong>,qulonglong)
            bool cppResult = cppSelf->isBreakpoint(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isDebugTaskInProgress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isDebugTaskInProgress()
        bool cppResult = cppSelf->isDebugTaskInProgress();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isGraphEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isGraphEmpty()
        bool cppResult = cppSelf->isGraphEmpty();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isIOCacheEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isIOCacheEnabled()const
        bool cppResult = const_cast<const ::CutterCore *>(cppSelf)->isIOCacheEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isRedirectableDebugee(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isRedirectableDebugee()
        bool cppResult = cppSelf->isRedirectableDebugee();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_isWriteModeEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isWriteModeEnabled()
        bool cppResult = cppSelf->isWriteModeEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_itoa(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "itoa", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OO:itoa", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::itoa(qulonglong,int=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // itoa(qulonglong,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // itoa(qulonglong,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "itoa", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"rdx", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "itoa", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 16;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // itoa(qulonglong,int)
            QString cppResult = cppSelf->itoa(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_jmpReverse(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::jmpReverse(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // jmpReverse(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "jmpReverse", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // jmpReverse(qulonglong)
            cppSelf->jmpReverse(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_listFlagsAsStringAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::listFlagsAsStringAt(qulonglong)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // listFlagsAsStringAt(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "listFlagsAsStringAt", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // listFlagsAsStringAt(qulonglong)
            QString cppResult = cppSelf->listFlagsAsStringAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_loadCutterRC(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadCutterRC()
        cppSelf->loadCutterRC();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_loadDefaultCutterRC(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // loadDefaultCutterRC()
        cppSelf->loadDefaultCutterRC();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_loadFile(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[7];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 7));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "loadFile", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOO:loadFile", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::loadFile(QString,qulonglong=,qulonglong=,int=,int=,bool=,const QString&=)->bool
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
                                overloadId = 0; // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "loadFile", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[6] = {{"baddr", 1}, {"mapaddr", 2}, {"perms", 3}, {"va", 4}, {"loadbin", 5}, {"forceBinPlugin", 6}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 6, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1]))))
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2]))))
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))
                || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[5]))))
                || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "loadFile", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1 = 0LL;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned long long cppArg2 = 0LL;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = RZ_PERM_R;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = 0;
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);
        bool cppArg5 = false;
        if (pythonToCpp[5])
            pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QString cppArg6 = QString();
        if (pythonToCpp[6])
            pythonToCpp[6](pyArgs[6], &cppArg6);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadFile(QString,qulonglong,qulonglong,int,int,bool,QString)
            bool cppResult = cppSelf->loadFile(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_loadPDB(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::loadPDB(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // loadPDB(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadPDB", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadPDB(QString)
            cppSelf->loadPDB(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_loadScript(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::loadScript(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // loadScript(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "loadScript", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // loadScript(QString)
            cppSelf->loadScript(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_mapFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "mapFile", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::mapFile(QString,qulonglong)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
        overloadId = 0; // mapFile(QString,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "mapFile", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // mapFile(QString,qulonglong)
            bool cppResult = cppSelf->mapFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_math(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::math(QString)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // math(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "math", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // math(QString)
            unsigned long long cppResult = cppSelf->math(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_message(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "message", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OO:message", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::message(QString,bool=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // message(QString,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // message(QString,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "message", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"debug", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "message", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // message(QString,bool)
            cppSelf->message(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_modifyGlobalVariable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "modifyGlobalVariable", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::modifyGlobalVariable(qulonglong,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // modifyGlobalVariable(qulonglong,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "modifyGlobalVariable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // modifyGlobalVariable(qulonglong,QString,QString)
            cppSelf->modifyGlobalVariable(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_nearestFlag(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "nearestFlag", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::nearestFlag(qulonglong,qulonglong*)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
        overloadId = 0; // nearestFlag(qulonglong,qulonglong*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "nearestFlag", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // nearestFlag(qulonglong,qulonglong*)
            QString cppResult = cppSelf->nearestFlag(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_nextOpAddr(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "nextOpAddr", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::nextOpAddr(qulonglong,int)->unsigned long long
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // nextOpAddr(qulonglong,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "nextOpAddr", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // nextOpAddr(qulonglong,int)
            unsigned long long cppResult = cppSelf->nextOpAddr(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_nopInstruction(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::nopInstruction(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // nopInstruction(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "nopInstruction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // nopInstruction(qulonglong)
            cppSelf->nopInstruction(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_num(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::num(QString)->unsigned long long
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // num(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "num", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // num(QString)
            unsigned long long cppResult = cppSelf->num(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_prevOpAddr(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "prevOpAddr", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::prevOpAddr(qulonglong,int)->unsigned long long
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // prevOpAddr(qulonglong,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "prevOpAddr", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // prevOpAddr(qulonglong,int)
            unsigned long long cppResult = cppSelf->prevOpAddr(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_removeString(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::removeString(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // removeString(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeString(qulonglong)
            cppSelf->removeString(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_renameAnalysisMethod(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "renameAnalysisMethod", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::renameAnalysisMethod(QString,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // renameAnalysisMethod(QString,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "renameAnalysisMethod", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // renameAnalysisMethod(QString,QString,QString)
            cppSelf->renameAnalysisMethod(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_renameClass(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "renameClass", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::renameClass(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // renameClass(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "renameClass", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // renameClass(QString,QString)
            cppSelf->renameClass(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_renameFlag(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "renameFlag", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::renameFlag(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // renameFlag(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "renameFlag", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // renameFlag(QString,QString)
            cppSelf->renameFlag(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_renameFunction(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "renameFunction", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::renameFunction(qulonglong,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // renameFunction(qulonglong,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "renameFunction", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // renameFunction(qulonglong,QString)
            cppSelf->renameFunction(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_renameFunctionVariable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "renameFunctionVariable", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::renameFunctionVariable(QString,QString,qulonglong)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[2])))) {
        overloadId = 0; // renameFunctionVariable(QString,QString,qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "renameFunctionVariable", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        unsigned long long cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // renameFunctionVariable(QString,QString,qulonglong)
            cppSelf->renameFunctionVariable(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_resetWriteCache(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // resetWriteCache()
        cppSelf->resetWriteCache();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_sanitizeStringForCommand(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static CutterCore::sanitizeStringForCommand(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // sanitizeStringForCommand(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "sanitizeStringForCommand", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sanitizeStringForCommand(QString)
            QString cppResult = ::CutterCore::sanitizeStringForCommand(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_sdbGet(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "sdbGet", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::sdbGet(QString,QString)->QString
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // sdbGet(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "sdbGet", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sdbGet(QString,QString)
            QString cppResult = cppSelf->sdbGet(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_sdbList(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::sdbList(QString)->QList<QString>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // sdbList(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "sdbList", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sdbList(QString)
            QList<QString> cppResult = cppSelf->sdbList(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_sdbListKeys(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::sdbListKeys(QString)->QList<QString>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // sdbListKeys(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "sdbListKeys", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sdbListKeys(QString)
            QList<QString> cppResult = cppSelf->sdbListKeys(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_sdbSet(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "sdbSet", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::sdbSet(QString,QString,QString)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // sdbSet(QString,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "sdbSet", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sdbSet(QString,QString,QString)
            bool cppResult = cppSelf->sdbSet(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_seek(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::seek(QString)
    // 1: CutterCore::seek(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 1; // seek(qulonglong)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // seek(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "seek", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // seek(QString thing)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // seek(QString)
                cppSelf->seek(cppArg0);
            }
            break;
        }
        case 1: // seek(unsigned long long offset)
        {
            unsigned long long cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // seek(qulonglong)
                cppSelf->seek(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_seekAndShow(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::seekAndShow(QString)
    // 1: CutterCore::seekAndShow(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 1; // seekAndShow(qulonglong)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // seekAndShow(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "seekAndShow", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // seekAndShow(QString thing)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // seekAndShow(QString)
                cppSelf->seekAndShow(cppArg0);
            }
            break;
        }
        case 1: // seekAndShow(unsigned long long offset)
        {
            unsigned long long cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // seekAndShow(qulonglong)
                cppSelf->seekAndShow(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_seekNext(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // seekNext()
        cppSelf->seekNext();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_seekPrev(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // seekPrev()
        cppSelf->seekPrev();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_seekSilent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::seekSilent(QString)
    // 1: CutterCore::seekSilent(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 1; // seekSilent(qulonglong)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // seekSilent(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "seekSilent", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // seekSilent(QString thing)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // seekSilent(QString)
                cppSelf->seekSilent(cppArg0);
            }
            break;
        }
        case 1: // seekSilent(unsigned long long offset)
        {
            unsigned long long cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // seekSilent(qulonglong)
                cppSelf->seekSilent(cppArg0);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setAsString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setAsString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setAsString", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setAsString(qulonglong,int=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setAsString(qulonglong,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // setAsString(qulonglong,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setAsString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"size", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setAsString", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 0;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setAsString(qulonglong,int)
            cppSelf->setAsString(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setBreakpointTrace(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setBreakpointTrace", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setBreakpointTrace(int,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setBreakpointTrace(int,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setBreakpointTrace", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setBreakpointTrace(int,bool)
            cppSelf->setBreakpointTrace(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setCPU(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setCPU", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setCPU(QString,QString,int)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // setCPU(QString,QString,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setCPU", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCPU(QString,QString,int)
            cppSelf->setCPU(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setColor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setColor", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setColor(QString,QString)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setColor(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setColor", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setColor(QString,QString)
            bool cppResult = cppSelf->setColor(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_setComment(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setComment", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setComment(qulonglong,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setComment(qulonglong,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setComment", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComment(qulonglong,QString)
            cppSelf->setComment(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setConfig(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setConfig", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setConfig(QString,bool)
    // 1: CutterCore::setConfig(QString,QString)
    // 2: CutterCore::setConfig(QString,QVariant)
    // 3: CutterCore::setConfig(QString,const char*)
    // 4: CutterCore::setConfig(QString,int)
    // 5: CutterCore::setConfig(const char*,bool)
    // 6: CutterCore::setConfig(const char*,QString)
    // 7: CutterCore::setConfig(const char*,QVariant)
    // 8: CutterCore::setConfig(const char*,const char*)
    // 9: CutterCore::setConfig(const char*,int)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 8; // setConfig(const char*,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 6; // setConfig(const char*,QString)
        } else if (numArgs == 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 5; // setConfig(const char*,bool)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 9; // setConfig(const char*,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
            overloadId = 7; // setConfig(const char*,QVariant)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
            overloadId = 3; // setConfig(QString,const char*)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            overloadId = 1; // setConfig(QString,QString)
        } else if (numArgs == 2
            && PyBool_Check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setConfig(QString,bool)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 4; // setConfig(QString,int)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))) {
            overloadId = 2; // setConfig(QString,QVariant)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setConfig", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setConfig(const QString &k, bool v)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(QString,bool)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // setConfig(const QString &k, const QString &v)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(QString,QString)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 2: // setConfig(const QString &k, const QVariant &v)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVariant cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(QString,QVariant)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 3: // setConfig(const QString &k, const char *v)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(QString,const char*)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 4: // setConfig(const QString &k, int v)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(QString,int)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 5: // setConfig(const char *k, bool v)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            bool cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(const char*,bool)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 6: // setConfig(const char *k, const QString &v)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(const char*,QString)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 7: // setConfig(const char *k, const QVariant &v)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QVariant cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(const char*,QVariant)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 8: // setConfig(const char *k, const char *v)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(const char*,const char*)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
        case 9: // setConfig(const char *k, int v)
        {
            const char* cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setConfig(const char*,int)
                cppSelf->setConfig(cppArg0, cppArg1);
            }
            break;
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setCurrentBits(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setCurrentBits", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setCurrentBits", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setCurrentBits(int,qulonglong=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setCurrentBits(int,qulonglong)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
            overloadId = 0; // setCurrentBits(int,qulonglong)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setCurrentBits", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"offset", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setCurrentBits", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1 = RVA_INVALID;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentBits(int,qulonglong)
            cppSelf->setCurrentBits(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setCurrentDebugProcess(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setCurrentDebugProcess(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentDebugProcess(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentDebugProcess", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentDebugProcess(int)
            cppSelf->setCurrentDebugProcess(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setCurrentDebugThread(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setCurrentDebugThread(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setCurrentDebugThread(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentDebugThread", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentDebugThread(int)
            cppSelf->setCurrentDebugThread(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setDebugPlugin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setDebugPlugin(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDebugPlugin(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDebugPlugin", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDebugPlugin(QString)
            cppSelf->setDebugPlugin(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setEndianness(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setEndianness(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEndianness(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setEndianness", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setEndianness(bool)
            cppSelf->setEndianness(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setGraphEmpty(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setGraphEmpty(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setGraphEmpty(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setGraphEmpty", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setGraphEmpty(bool)
            cppSelf->setGraphEmpty(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setIOCache(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setIOCache(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setIOCache(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setIOCache", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setIOCache(bool)
            cppSelf->setIOCache(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setImmediateBase(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setImmediateBase", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OO:setImmediateBase", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setImmediateBase(QString,qulonglong=)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setImmediateBase(QString,qulonglong)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1])))) {
            overloadId = 0; // setImmediateBase(QString,qulonglong)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setImmediateBase", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"offset", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setImmediateBase", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        unsigned long long cppArg1 = RVA_INVALID;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setImmediateBase(QString,qulonglong)
            cppSelf->setImmediateBase(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setRegister(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setRegister", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setRegister(QString,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setRegister(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setRegister", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setRegister(QString,QString)
            cppSelf->setRegister(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // setSettings()
        cppSelf->setSettings();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setToCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setToCode(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // setToCode(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setToCode", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToCode(qulonglong)
            cppSelf->setToCode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setToData(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "setToData", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:setToData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::setToData(qulonglong,int,int=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setToData(qulonglong,int,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // setToData(qulonglong,int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setToData", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"repeat", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "setToData", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);
            }
        }
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = 1;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setToData(qulonglong,int,int)
            cppSelf->setToData(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_setWriteMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::setWriteMode(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setWriteMode(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setWriteMode", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setWriteMode(bool)
            cppSelf->setWriteMode(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_showMemoryWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showMemoryWidget()
        cppSelf->showMemoryWidget();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_sizeofDataMeta(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::sizeofDataMeta(qulonglong)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // sizeofDataMeta(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "sizeofDataMeta", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // sizeofDataMeta(qulonglong)
            int cppResult = cppSelf->sizeofDataMeta(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_startDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startDebug()
        cppSelf->startDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_startEmulation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startEmulation()
        cppSelf->startEmulation();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_startTraceSession(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // startTraceSession()
        cppSelf->startTraceSession();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_stepBackDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stepBackDebug()
        cppSelf->stepBackDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_stepDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stepDebug()
        cppSelf->stepDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_stepOutDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stepOutDebug()
        cppSelf->stepOutDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_stepOverDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stepOverDebug()
        cppSelf->stepOverDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_stopDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stopDebug()
        cppSelf->stopDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_stopTraceSession(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stopTraceSession()
        cppSelf->stopTraceSession();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_suspendDebug(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // suspendDebug()
        cppSelf->suspendDebug();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_syncAndSeekProgramCounter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // syncAndSeekProgramCounter()
        cppSelf->syncAndSeekProgramCounter();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_toggleBreakpoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: CutterCore::toggleBreakpoint(qulonglong)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArg)))) {
        overloadId = 0; // toggleBreakpoint(qulonglong)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "toggleBreakpoint", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // toggleBreakpoint(qulonglong)
            cppSelf->toggleBreakpoint(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_triggerAsmOptionsChanged(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // triggerAsmOptionsChanged()
        cppSelf->triggerAsmOptionsChanged();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_triggerFlagsChanged(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // triggerFlagsChanged()
        cppSelf->triggerFlagsChanged();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_triggerFunctionRenamed(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "triggerFunctionRenamed", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::triggerFunctionRenamed(qulonglong,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<unsigned long long>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // triggerFunctionRenamed(qulonglong,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "triggerFunctionRenamed", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        unsigned long long cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // triggerFunctionRenamed(qulonglong,QString)
            cppSelf->triggerFunctionRenamed(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_triggerGraphOptionsChanged(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // triggerGraphOptionsChanged()
        cppSelf->triggerGraphOptionsChanged();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_triggerRefreshAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // triggerRefreshAll()
        cppSelf->triggerRefreshAll();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_triggerVarsChanged(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // triggerVarsChanged()
        cppSelf->triggerVarsChanged();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_CutterCoreFunc_tryFile(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "tryFile", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: CutterCore::tryFile(QString,bool)->bool
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // tryFile(QString,bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "tryFile", errInfo, SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tryFile(QString,bool)
            bool cppResult = cppSelf->tryFile(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_CutterCoreFunc_updateSeek(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // updateSeek()
        cppSelf->updateSeek();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_CutterCore_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_CutterCore_methods[] = {
    {"addFlag", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_addFlag), METH_VARARGS, nullptr},
    {"addGlobalVariable", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_addGlobalVariable), METH_VARARGS, nullptr},
    {"ansiEscapeToHtml", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_ansiEscapeToHtml), METH_O|METH_STATIC, nullptr},
    {"applySignature", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_applySignature), METH_O, nullptr},
    {"applyStructureOffset", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_applyStructureOffset), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"assemble", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_assemble), METH_O, nullptr},
    {"attachDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_attachDebug), METH_O, nullptr},
    {"attachRemote", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_attachRemote), METH_O, nullptr},
    {"breakpointIndexAt", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_breakpointIndexAt), METH_O, nullptr},
    {"bytesToHexString", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_bytesToHexString), METH_O|METH_STATIC, nullptr},
    {"cmd", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_cmd), METH_O, nullptr},
    {"cmdRaw", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_cmdRaw), METH_O, nullptr},
    {"cmdRawAt", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_cmdRawAt), METH_VARARGS, nullptr},
    {"cmdTask", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_cmdTask), METH_O, nullptr},
    {"commitWriteCache", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_commitWriteCache), METH_NOARGS, nullptr},
    {"continueBackDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_continueBackDebug), METH_NOARGS, nullptr},
    {"continueDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_continueDebug), METH_NOARGS, nullptr},
    {"continueUntilCall", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_continueUntilCall), METH_NOARGS, nullptr},
    {"continueUntilDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_continueUntilDebug), METH_O, nullptr},
    {"continueUntilSyscall", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_continueUntilSyscall), METH_NOARGS, nullptr},
    {"createFunctionAt", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_createFunctionAt), METH_VARARGS, nullptr},
    {"createNewClass", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_createNewClass), METH_O, nullptr},
    {"createSignature", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_createSignature), METH_O, nullptr},
    {"delAllBreakpoints", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_delAllBreakpoints), METH_NOARGS, nullptr},
    {"delBreakpoint", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_delBreakpoint), METH_O, nullptr},
    {"delComment", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_delComment), METH_O, nullptr},
    {"delFlag", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_delFlag), METH_O, nullptr},
    {"delFunction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_delFunction), METH_O, nullptr},
    {"delGlobalVariable", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_delGlobalVariable), METH_O, nullptr},
    {"deleteClass", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_deleteClass), METH_O, nullptr},
    {"disableBreakpoint", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_disableBreakpoint), METH_O, nullptr},
    {"disassemble", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_disassemble), METH_O, nullptr},
    {"disassembleSingleInstruction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_disassembleSingleInstruction), METH_O, nullptr},
    {"editBytes", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_editBytes), METH_VARARGS, nullptr},
    {"editBytesEndian", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_editBytesEndian), METH_VARARGS, nullptr},
    {"editInstruction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_editInstruction), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"enableBreakpoint", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_enableBreakpoint), METH_O, nullptr},
    {"existsFileInfo", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_existsFileInfo), METH_NOARGS, nullptr},
    {"flagAt", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_flagAt), METH_O, nullptr},
    {"getActiveDebugPlugin", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getActiveDebugPlugin), METH_NOARGS, nullptr},
    {"getAllAnalysisClasses", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getAllAnalysisClasses), METH_O, nullptr},
    {"getAnalysisPluginNames", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getAnalysisPluginNames), METH_NOARGS, nullptr},
    {"getArchBits", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getArchBits), METH_NOARGS, nullptr},
    {"getAsmPluginNames", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getAsmPluginNames), METH_NOARGS, nullptr},
    {"getBBHighlighter", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getBBHighlighter), METH_NOARGS, nullptr},
    {"getBIHighlighter", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getBIHighlighter), METH_NOARGS, nullptr},
    {"getBreakpointsAddresses", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getBreakpointsAddresses), METH_NOARGS, nullptr},
    {"getBreakpointsInFunction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getBreakpointsInFunction), METH_O, nullptr},
    {"getColorThemes", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getColorThemes), METH_NOARGS, nullptr},
    {"getCommentAt", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getCommentAt), METH_O, nullptr},
    {"getConfig", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfig), METH_O, nullptr},
    {"getConfigDescription", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfigDescription), METH_O, nullptr},
    {"getConfigOptions", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfigOptions), METH_O, nullptr},
    {"getConfigVariableSpaces", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfigVariableSpaces), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"getConfigb", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfigb), METH_O, nullptr},
    {"getConfigi", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfigi), METH_O, nullptr},
    {"getConfigut64", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getConfigut64), METH_O, nullptr},
    {"getCutterRCDefaultDirectory", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getCutterRCDefaultDirectory), METH_NOARGS, nullptr},
    {"getDebugPlugins", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getDebugPlugins), METH_NOARGS, nullptr},
    {"getDisassemblyPreview", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getDisassemblyPreview), METH_VARARGS, nullptr},
    {"getFunctionEnd", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getFunctionEnd), METH_O, nullptr},
    {"getFunctionStart", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getFunctionStart), METH_O, nullptr},
    {"getGlobalVariableType", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getGlobalVariableType), METH_O, nullptr},
    {"getHexdumpPreview", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getHexdumpPreview), METH_VARARGS, nullptr},
    {"getInstructionBytes", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getInstructionBytes), METH_O, nullptr},
    {"getInstructionOpcode", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getInstructionOpcode), METH_O, nullptr},
    {"getLastFunctionInstruction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getLastFunctionInstruction), METH_O, nullptr},
    {"getMetaString", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getMetaString), METH_O, nullptr},
    {"getOffset", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getOffset), METH_NOARGS, nullptr},
    {"getOffsetJump", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getOffsetJump), METH_O, nullptr},
    {"getProgramCounterValue", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getProgramCounterValue), METH_NOARGS, nullptr},
    {"getRegisterName", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getRegisterName), METH_O, nullptr},
    {"getRegs", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getRegs), METH_NOARGS, nullptr},
    {"getRizinVersionReadable", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getRizinVersionReadable), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"getSectionList", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getSectionList), METH_NOARGS, nullptr},
    {"getSeekHistory", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getSeekHistory), METH_NOARGS, nullptr},
    {"getString", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getString), METH_O, nullptr},
    {"getTheme", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getTheme), METH_NOARGS, nullptr},
    {"getThemeKeys", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getThemeKeys), METH_NOARGS, nullptr},
    {"getTypeAsC", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getTypeAsC), METH_O, nullptr},
    {"getVersionInformation", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_getVersionInformation), METH_NOARGS, nullptr},
    {"handleREvent", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_handleREvent), METH_VARARGS, nullptr},
    {"hexStringToBytes", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_hexStringToBytes), METH_O|METH_STATIC, nullptr},
    {"initialize", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_initialize), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"instance", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_instance), METH_NOARGS|METH_STATIC, nullptr},
    {"ioRead", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_ioRead), METH_VARARGS, nullptr},
    {"isAddressMapped", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isAddressMapped), METH_O, nullptr},
    {"isBreakpoint", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isBreakpoint), METH_VARARGS, nullptr},
    {"isDebugTaskInProgress", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isDebugTaskInProgress), METH_NOARGS, nullptr},
    {"isGraphEmpty", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isGraphEmpty), METH_NOARGS, nullptr},
    {"isIOCacheEnabled", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isIOCacheEnabled), METH_NOARGS, nullptr},
    {"isRedirectableDebugee", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isRedirectableDebugee), METH_NOARGS, nullptr},
    {"isWriteModeEnabled", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_isWriteModeEnabled), METH_NOARGS, nullptr},
    {"itoa", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_itoa), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"jmpReverse", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_jmpReverse), METH_O, nullptr},
    {"listFlagsAsStringAt", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_listFlagsAsStringAt), METH_O, nullptr},
    {"loadCutterRC", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_loadCutterRC), METH_NOARGS, nullptr},
    {"loadDefaultCutterRC", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_loadDefaultCutterRC), METH_NOARGS, nullptr},
    {"loadFile", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_loadFile), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"loadPDB", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_loadPDB), METH_O, nullptr},
    {"loadScript", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_loadScript), METH_O, nullptr},
    {"mapFile", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_mapFile), METH_VARARGS, nullptr},
    {"math", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_math), METH_O, nullptr},
    {"message", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_message), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"modifyGlobalVariable", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_modifyGlobalVariable), METH_VARARGS, nullptr},
    {"nearestFlag", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_nearestFlag), METH_VARARGS, nullptr},
    {"nextOpAddr", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_nextOpAddr), METH_VARARGS, nullptr},
    {"nopInstruction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_nopInstruction), METH_O, nullptr},
    {"num", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_num), METH_O, nullptr},
    {"prevOpAddr", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_prevOpAddr), METH_VARARGS, nullptr},
    {"removeString", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_removeString), METH_O, nullptr},
    {"renameAnalysisMethod", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_renameAnalysisMethod), METH_VARARGS, nullptr},
    {"renameClass", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_renameClass), METH_VARARGS, nullptr},
    {"renameFlag", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_renameFlag), METH_VARARGS, nullptr},
    {"renameFunction", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_renameFunction), METH_VARARGS, nullptr},
    {"renameFunctionVariable", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_renameFunctionVariable), METH_VARARGS, nullptr},
    {"resetWriteCache", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_resetWriteCache), METH_NOARGS, nullptr},
    {"sanitizeStringForCommand", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_sanitizeStringForCommand), METH_O|METH_STATIC, nullptr},
    {"sdbGet", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_sdbGet), METH_VARARGS, nullptr},
    {"sdbList", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_sdbList), METH_O, nullptr},
    {"sdbListKeys", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_sdbListKeys), METH_O, nullptr},
    {"sdbSet", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_sdbSet), METH_VARARGS, nullptr},
    {"seek", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_seek), METH_O, nullptr},
    {"seekAndShow", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_seekAndShow), METH_O, nullptr},
    {"seekNext", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_seekNext), METH_NOARGS, nullptr},
    {"seekPrev", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_seekPrev), METH_NOARGS, nullptr},
    {"seekSilent", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_seekSilent), METH_O, nullptr},
    {"setAsString", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setAsString), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setBreakpointTrace", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setBreakpointTrace), METH_VARARGS, nullptr},
    {"setCPU", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setCPU), METH_VARARGS, nullptr},
    {"setColor", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setColor), METH_VARARGS, nullptr},
    {"setComment", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setComment), METH_VARARGS, nullptr},
    {"setConfig", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setConfig), METH_VARARGS, nullptr},
    {"setCurrentBits", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setCurrentBits), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setCurrentDebugProcess", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setCurrentDebugProcess), METH_O, nullptr},
    {"setCurrentDebugThread", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setCurrentDebugThread), METH_O, nullptr},
    {"setDebugPlugin", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setDebugPlugin), METH_O, nullptr},
    {"setEndianness", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setEndianness), METH_O, nullptr},
    {"setGraphEmpty", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setGraphEmpty), METH_O, nullptr},
    {"setIOCache", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setIOCache), METH_O, nullptr},
    {"setImmediateBase", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setImmediateBase), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setRegister", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setRegister), METH_VARARGS, nullptr},
    {"setSettings", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setSettings), METH_NOARGS, nullptr},
    {"setToCode", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setToCode), METH_O, nullptr},
    {"setToData", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setToData), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setWriteMode", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_setWriteMode), METH_O, nullptr},
    {"showMemoryWidget", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_showMemoryWidget), METH_NOARGS, nullptr},
    {"sizeofDataMeta", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_sizeofDataMeta), METH_O, nullptr},
    {"startDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_startDebug), METH_NOARGS, nullptr},
    {"startEmulation", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_startEmulation), METH_NOARGS, nullptr},
    {"startTraceSession", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_startTraceSession), METH_NOARGS, nullptr},
    {"stepBackDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_stepBackDebug), METH_NOARGS, nullptr},
    {"stepDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_stepDebug), METH_NOARGS, nullptr},
    {"stepOutDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_stepOutDebug), METH_NOARGS, nullptr},
    {"stepOverDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_stepOverDebug), METH_NOARGS, nullptr},
    {"stopDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_stopDebug), METH_NOARGS, nullptr},
    {"stopTraceSession", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_stopTraceSession), METH_NOARGS, nullptr},
    {"suspendDebug", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_suspendDebug), METH_NOARGS, nullptr},
    {"syncAndSeekProgramCounter", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_syncAndSeekProgramCounter), METH_NOARGS, nullptr},
    {"toggleBreakpoint", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_toggleBreakpoint), METH_O, nullptr},
    {"triggerAsmOptionsChanged", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_triggerAsmOptionsChanged), METH_NOARGS, nullptr},
    {"triggerFlagsChanged", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_triggerFlagsChanged), METH_NOARGS, nullptr},
    {"triggerFunctionRenamed", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_triggerFunctionRenamed), METH_VARARGS, nullptr},
    {"triggerGraphOptionsChanged", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_triggerGraphOptionsChanged), METH_NOARGS, nullptr},
    {"triggerRefreshAll", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_triggerRefreshAll), METH_NOARGS, nullptr},
    {"triggerVarsChanged", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_triggerVarsChanged), METH_NOARGS, nullptr},
    {"tryFile", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_tryFile), METH_VARARGS, nullptr},
    {"updateSeek", reinterpret_cast<PyCFunction>(Sbk_CutterCoreFunc_updateSeek), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_CutterCore_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<CutterCoreWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_CutterCore_get_currentlyDebugging(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->currentlyDebugging;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_CutterCore_set_currentlyDebugging(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("currentlyDebugging");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("currentlyDebugging", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->currentlyDebugging;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->currentlyDebugging = cppOut_local;

    return 0;
}

static PyObject *Sbk_CutterCore_get_currentlyEmulating(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->currentlyEmulating;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_CutterCore_set_currentlyEmulating(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("currentlyEmulating");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("currentlyEmulating", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->currentlyEmulating;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->currentlyEmulating = cppOut_local;

    return 0;
}

static PyObject *Sbk_CutterCore_get_currentlyTracing(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->currentlyTracing;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_CutterCore_set_currentlyTracing(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("currentlyTracing");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("currentlyTracing", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->currentlyTracing;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->currentlyTracing = cppOut_local;

    return 0;
}

static PyObject *Sbk_CutterCore_get_currentlyRemoteDebugging(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->currentlyRemoteDebugging;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
}
static int Sbk_CutterCore_set_currentlyRemoteDebugging(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("currentlyRemoteDebugging");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("currentlyRemoteDebugging", "bool");
        return -1;
    }

    auto cppOut_local = cppSelf->currentlyRemoteDebugging;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->currentlyRemoteDebugging = cppOut_local;

    return 0;
}

static PyObject *Sbk_CutterCore_get_currentlyAttachedToPID(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->currentlyAttachedToPID;
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
}
static int Sbk_CutterCore_set_currentlyAttachedToPID(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("currentlyAttachedToPID");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("currentlyAttachedToPID", "int");
        return -1;
    }

    auto cppOut_local = cppSelf->currentlyAttachedToPID;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->currentlyAttachedToPID = cppOut_local;

    return 0;
}

static PyObject *Sbk_CutterCore_get_currentlyOpenFile(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppSelf->currentlyOpenFile);
}
static int Sbk_CutterCore_set_currentlyOpenFile(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("currentlyOpenFile");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("currentlyOpenFile", "QString");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->currentlyOpenFile;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_CutterCore_get_regs(PyObject *self, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return Shiboken::Conversions::copyToPython(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX], &cppSelf->regs);
}
static int Sbk_CutterCore_set_regs(PyObject *self, PyObject *pyIn, void * /* closure */)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto *cppSelf = reinterpret_cast< ::CutterCore *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        Shiboken::Errors::setInvalidTypeDeletion("regs");
        return -1;
    }
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    if (!(pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkCutterBindingsTypeConverters[SBK_CutterBindings_QList_QString_IDX], (pyIn)))) {
        Shiboken::Errors::setSetterTypeError("regs", "QList");
        return -1;
    }

    auto &cppOut_ptr = cppSelf->regs;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for CutterCore
static PyGetSetDef Sbk_CutterCore_getsetlist[] = {
    {const_cast<char *>("currentlyDebugging"), Sbk_CutterCore_get_currentlyDebugging, Sbk_CutterCore_set_currentlyDebugging, nullptr, nullptr},
    {const_cast<char *>("currentlyEmulating"), Sbk_CutterCore_get_currentlyEmulating, Sbk_CutterCore_set_currentlyEmulating, nullptr, nullptr},
    {const_cast<char *>("currentlyTracing"), Sbk_CutterCore_get_currentlyTracing, Sbk_CutterCore_set_currentlyTracing, nullptr, nullptr},
    {const_cast<char *>("currentlyRemoteDebugging"), Sbk_CutterCore_get_currentlyRemoteDebugging, Sbk_CutterCore_set_currentlyRemoteDebugging, nullptr, nullptr},
    {const_cast<char *>("currentlyAttachedToPID"), Sbk_CutterCore_get_currentlyAttachedToPID, Sbk_CutterCore_set_currentlyAttachedToPID, nullptr, nullptr},
    {const_cast<char *>("currentlyOpenFile"), Sbk_CutterCore_get_currentlyOpenFile, Sbk_CutterCore_set_currentlyOpenFile, nullptr, nullptr},
    {const_cast<char *>("regs"), Sbk_CutterCore_get_regs, Sbk_CutterCore_set_regs, nullptr, nullptr},
    {nullptr, nullptr, nullptr, nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_CutterCore_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_CutterCore_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_CutterCore_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_CutterCore_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_CutterCore_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_CutterCore_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_CutterCore_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_CutterCore_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_CutterCore_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_CutterCore_spec = {
    "1:CutterBindings.CutterCore",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_CutterCore_slots
};

} //extern "C"

static void *Sbk_CutterCore_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::CutterCore *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void CutterCore_PythonToCpp_CutterCore_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_CutterCore_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_CutterCore_PythonToCpp_CutterCore_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_CutterCore_TypeF()))
        return CutterCore_PythonToCpp_CutterCore_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *CutterCore_PTR_CppToPython_CutterCore(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::CutterCore *>(const_cast<void *>(cppIn)), Sbk_CutterCore_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *CutterCore_SignatureStrings[] = {
    "CutterBindings.CutterCore(self,parent:PySide6.QtCore.QObject=nullptr)",
    "CutterBindings.CutterCore.addFlag(self,offset:unsigned long long,name:QString,size:unsigned long long)",
    "CutterBindings.CutterCore.addGlobalVariable(self,offset:unsigned long long,name:QString,typ:QString)",
    "CutterBindings.CutterCore.ansiEscapeToHtml(text:QString)->QString",
    "CutterBindings.CutterCore.applySignature(self,filepath:QString)",
    "CutterBindings.CutterCore.applyStructureOffset(self,structureOffset:QString,offset:unsigned long long=RVA_INVALID)",
    "CutterBindings.CutterCore.assemble(self,code:QString)->PySide6.QtCore.QByteArray",
    "CutterBindings.CutterCore.attachDebug(self,pid:int)",
    "CutterBindings.CutterCore.attachRemote(self,uri:QString)",
    "CutterBindings.CutterCore.breakpointIndexAt(self,addr:unsigned long long)->int",
    "CutterBindings.CutterCore.bytesToHexString(bytes:typing.Union[PySide6.QtCore.QByteArray, char*])->QString",
    "1:CutterBindings.CutterCore.cmd(self,str:QString)->QString",
    "0:CutterBindings.CutterCore.cmd(self,str:char*)->QString",
    "1:CutterBindings.CutterCore.cmdRaw(self,cmd:QString)->QString",
    "0:CutterBindings.CutterCore.cmdRaw(self,cmd:char*)->QString",
    "1:CutterBindings.CutterCore.cmdRawAt(self,str:QString,address:unsigned long long)->QString",
    "0:CutterBindings.CutterCore.cmdRawAt(self,cmd:char*,address:unsigned long long)->QString",
    "CutterBindings.CutterCore.cmdTask(self,str:QString)->QString",
    "CutterBindings.CutterCore.commitWriteCache(self)",
    "CutterBindings.CutterCore.continueBackDebug(self)",
    "CutterBindings.CutterCore.continueDebug(self)",
    "CutterBindings.CutterCore.continueUntilCall(self)",
    "CutterBindings.CutterCore.continueUntilDebug(self,offset:unsigned long long)",
    "CutterBindings.CutterCore.continueUntilSyscall(self)",
    "1:CutterBindings.CutterCore.createFunctionAt(self,addr:unsigned long long)",
    "0:CutterBindings.CutterCore.createFunctionAt(self,addr:unsigned long long,name:QString)",
    "CutterBindings.CutterCore.createNewClass(self,cls:QString)",
    "CutterBindings.CutterCore.createSignature(self,filepath:QString)",
    "CutterBindings.CutterCore.delAllBreakpoints(self)",
    "CutterBindings.CutterCore.delBreakpoint(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.delComment(self,addr:unsigned long long)",
    "1:CutterBindings.CutterCore.delFlag(self,name:QString)",
    "0:CutterBindings.CutterCore.delFlag(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.delFunction(self,addr:unsigned long long)",
    "1:CutterBindings.CutterCore.delGlobalVariable(self,name:QString)",
    "0:CutterBindings.CutterCore.delGlobalVariable(self,offset:unsigned long long)",
    "CutterBindings.CutterCore.deleteClass(self,cls:QString)",
    "CutterBindings.CutterCore.disableBreakpoint(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.disassemble(self,data:typing.Union[PySide6.QtCore.QByteArray, char*])->QString",
    "CutterBindings.CutterCore.disassembleSingleInstruction(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.editBytes(self,addr:unsigned long long,inst:QString)",
    "CutterBindings.CutterCore.editBytesEndian(self,addr:unsigned long long,bytes:QString)",
    "CutterBindings.CutterCore.editInstruction(self,addr:unsigned long long,inst:QString,fillWithNops:bool=false)",
    "CutterBindings.CutterCore.enableBreakpoint(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.existsFileInfo(self)->bool",
    "CutterBindings.CutterCore.flagAt(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.getActiveDebugPlugin(self)->QString",
    "CutterBindings.CutterCore.getAllAnalysisClasses(self,sorted:bool)->QList[QString]",
    "CutterBindings.CutterCore.getAnalysisPluginNames(self)->QStringList",
    "CutterBindings.CutterCore.getArchBits(self)->int",
    "CutterBindings.CutterCore.getAsmPluginNames(self)->QStringList",
    "CutterBindings.CutterCore.getBBHighlighter(self)->CutterBindings.BasicBlockHighlighter",
    "CutterBindings.CutterCore.getBIHighlighter(self)->CutterBindings.BasicInstructionHighlighter",
    "CutterBindings.CutterCore.getBreakpointsAddresses(self)->QList[unsigned long long]",
    "CutterBindings.CutterCore.getBreakpointsInFunction(self,funcAddr:unsigned long long)->QList[unsigned long long]",
    "CutterBindings.CutterCore.getColorThemes(self)->QStringList",
    "CutterBindings.CutterCore.getCommentAt(self,addr:unsigned long long)->QString",
    "1:CutterBindings.CutterCore.getConfig(self,k:QString)->QString",
    "0:CutterBindings.CutterCore.getConfig(self,k:char*)->QString",
    "CutterBindings.CutterCore.getConfigDescription(self,k:char*)->QString",
    "CutterBindings.CutterCore.getConfigOptions(self,k:char*)->QStringList",
    R"CPP(CutterBindings.CutterCore.getConfigVariableSpaces(self,key:QString="")->QStringList)CPP",
    "1:CutterBindings.CutterCore.getConfigb(self,k:QString)->bool",
    "0:CutterBindings.CutterCore.getConfigb(self,k:char*)->bool",
    "1:CutterBindings.CutterCore.getConfigi(self,k:QString)->int",
    "0:CutterBindings.CutterCore.getConfigi(self,k:char*)->int",
    "1:CutterBindings.CutterCore.getConfigut64(self,k:QString)->unsigned long long",
    "0:CutterBindings.CutterCore.getConfigut64(self,k:char*)->unsigned long long",
    "CutterBindings.CutterCore.getCutterRCDefaultDirectory(self)->PySide6.QtCore.QDir",
    "CutterBindings.CutterCore.getDebugPlugins(self)->QStringList",
    "CutterBindings.CutterCore.getDisassemblyPreview(self,address:unsigned long long,num_of_lines:int)->QStringList",
    "CutterBindings.CutterCore.getFunctionEnd(self,addr:unsigned long long)->unsigned long long",
    "CutterBindings.CutterCore.getFunctionStart(self,addr:unsigned long long)->unsigned long long",
    "1:CutterBindings.CutterCore.getGlobalVariableType(self,name:QString)->QString",
    "0:CutterBindings.CutterCore.getGlobalVariableType(self,offset:unsigned long long)->QString",
    "CutterBindings.CutterCore.getHexdumpPreview(self,offset:unsigned long long,size:int)->QString",
    "CutterBindings.CutterCore.getInstructionBytes(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.getInstructionOpcode(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.getLastFunctionInstruction(self,addr:unsigned long long)->unsigned long long",
    "CutterBindings.CutterCore.getMetaString(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.getOffset(self)->unsigned long long",
    "CutterBindings.CutterCore.getOffsetJump(self,addr:unsigned long long)->unsigned long long",
    "CutterBindings.CutterCore.getProgramCounterValue(self)->unsigned long long",
    "CutterBindings.CutterCore.getRegisterName(self,registerRole:QString)->QString",
    "CutterBindings.CutterCore.getRegs(self)",
    "CutterBindings.CutterCore.getRizinVersionReadable(self,program:char*=nullptr)->QString",
    "CutterBindings.CutterCore.getSectionList(self)->QStringList",
    "CutterBindings.CutterCore.getSeekHistory(self)->QList[unsigned long long]",
    "CutterBindings.CutterCore.getString(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.getTheme(self)->QHash[QString, PySide6.QtGui.QColor]",
    "CutterBindings.CutterCore.getThemeKeys(self)->QStringList",
    "CutterBindings.CutterCore.getTypeAsC(self,name:QString)->QString",
    "CutterBindings.CutterCore.getVersionInformation(self)->QString",
    "CutterBindings.CutterCore.handleREvent(self,type:int,data:void)",
    "CutterBindings.CutterCore.hexStringToBytes(hex:QString)->PySide6.QtCore.QByteArray",
    "CutterBindings.CutterCore.initialize(self,loadPlugins:bool=true)",
    "CutterBindings.CutterCore.instance()->CutterBindings.CutterCore",
    "CutterBindings.CutterCore.ioRead(self,addr:unsigned long long,len:int)->PySide6.QtCore.QByteArray",
    "CutterBindings.CutterCore.isAddressMapped(self,addr:unsigned long long)->bool",
    "CutterBindings.CutterCore.isBreakpoint(self,breakpoints:QList[unsigned long long],addr:unsigned long long)->bool",
    "CutterBindings.CutterCore.isDebugTaskInProgress(self)->bool",
    "CutterBindings.CutterCore.isGraphEmpty(self)->bool",
    "CutterBindings.CutterCore.isIOCacheEnabled(self)->bool",
    "CutterBindings.CutterCore.isRedirectableDebugee(self)->bool",
    "CutterBindings.CutterCore.isWriteModeEnabled(self)->bool",
    "CutterBindings.CutterCore.itoa(self,num:unsigned long long,rdx:int=16)->QString",
    "CutterBindings.CutterCore.jmpReverse(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.listFlagsAsStringAt(self,addr:unsigned long long)->QString",
    "CutterBindings.CutterCore.loadCutterRC(self)",
    "CutterBindings.CutterCore.loadDefaultCutterRC(self)",
    "CutterBindings.CutterCore.loadFile(self,path:QString,baddr:unsigned long long=0LL,mapaddr:unsigned long long=0LL,perms:int=RZ_PERM_R,va:int=0,loadbin:bool=false,forceBinPlugin:QString=QString())->bool",
    "CutterBindings.CutterCore.loadPDB(self,file:QString)",
    "CutterBindings.CutterCore.loadScript(self,scriptname:QString)",
    "CutterBindings.CutterCore.mapFile(self,path:QString,mapaddr:unsigned long long)->bool",
    "CutterBindings.CutterCore.math(self,expr:QString)->unsigned long long",
    "CutterBindings.CutterCore.message(self,msg:QString,debug:bool=false)",
    "CutterBindings.CutterCore.modifyGlobalVariable(self,offset:unsigned long long,name:QString,typ:QString)",
    "CutterBindings.CutterCore.nearestFlag(self,offset:unsigned long long,flagOffsetOut:unsigned long long*)->QString",
    "CutterBindings.CutterCore.nextOpAddr(self,startAddr:unsigned long long,count:int)->unsigned long long",
    "CutterBindings.CutterCore.nopInstruction(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.num(self,expr:QString)->unsigned long long",
    "CutterBindings.CutterCore.prevOpAddr(self,startAddr:unsigned long long,count:int)->unsigned long long",
    "CutterBindings.CutterCore.removeString(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.renameAnalysisMethod(self,className:QString,oldMethodName:QString,newMethodName:QString)",
    "CutterBindings.CutterCore.renameClass(self,oldName:QString,newName:QString)",
    "CutterBindings.CutterCore.renameFlag(self,old_name:QString,new_name:QString)",
    "CutterBindings.CutterCore.renameFunction(self,offset:unsigned long long,newName:QString)",
    "CutterBindings.CutterCore.renameFunctionVariable(self,newName:QString,oldName:QString,functionAddress:unsigned long long)",
    "CutterBindings.CutterCore.resetWriteCache(self)",
    "CutterBindings.CutterCore.sanitizeStringForCommand(s:QString)->QString",
    "CutterBindings.CutterCore.sdbGet(self,path:QString,key:QString)->QString",
    "CutterBindings.CutterCore.sdbList(self,path:QString)->QList[QString]",
    "CutterBindings.CutterCore.sdbListKeys(self,path:QString)->QList[QString]",
    "CutterBindings.CutterCore.sdbSet(self,path:QString,key:QString,val:QString)->bool",
    "1:CutterBindings.CutterCore.seek(self,thing:QString)",
    "0:CutterBindings.CutterCore.seek(self,offset:unsigned long long)",
    "1:CutterBindings.CutterCore.seekAndShow(self,thing:QString)",
    "0:CutterBindings.CutterCore.seekAndShow(self,offset:unsigned long long)",
    "CutterBindings.CutterCore.seekNext(self)",
    "CutterBindings.CutterCore.seekPrev(self)",
    "1:CutterBindings.CutterCore.seekSilent(self,thing:QString)",
    "0:CutterBindings.CutterCore.seekSilent(self,offset:unsigned long long)",
    "CutterBindings.CutterCore.setAsString(self,addr:unsigned long long,size:int=0)",
    "CutterBindings.CutterCore.setBreakpointTrace(self,index:int,enabled:bool)",
    "CutterBindings.CutterCore.setCPU(self,arch:QString,cpu:QString,bits:int)",
    "CutterBindings.CutterCore.setColor(self,key:QString,color:QString)->bool",
    "CutterBindings.CutterCore.setComment(self,addr:unsigned long long,cmt:QString)",
    "9:CutterBindings.CutterCore.setConfig(self,k:QString,v:bool)",
    "8:CutterBindings.CutterCore.setConfig(self,k:QString,v:QString)",
    "7:CutterBindings.CutterCore.setConfig(self,k:QString,v:QVariant)",
    "6:CutterBindings.CutterCore.setConfig(self,k:QString,v:char*)",
    "5:CutterBindings.CutterCore.setConfig(self,k:QString,v:int)",
    "4:CutterBindings.CutterCore.setConfig(self,k:char*,v:bool)",
    "3:CutterBindings.CutterCore.setConfig(self,k:char*,v:QString)",
    "2:CutterBindings.CutterCore.setConfig(self,k:char*,v:QVariant)",
    "1:CutterBindings.CutterCore.setConfig(self,k:char*,v:char*)",
    "0:CutterBindings.CutterCore.setConfig(self,k:char*,v:int)",
    "CutterBindings.CutterCore.setCurrentBits(self,bits:int,offset:unsigned long long=RVA_INVALID)",
    "CutterBindings.CutterCore.setCurrentDebugProcess(self,pid:int)",
    "CutterBindings.CutterCore.setCurrentDebugThread(self,tid:int)",
    "CutterBindings.CutterCore.setDebugPlugin(self,plugin:QString)",
    "CutterBindings.CutterCore.setEndianness(self,big:bool)",
    "CutterBindings.CutterCore.setGraphEmpty(self,empty:bool)",
    "CutterBindings.CutterCore.setIOCache(self,enabled:bool)",
    "CutterBindings.CutterCore.setImmediateBase(self,rzBaseName:QString,offset:unsigned long long=RVA_INVALID)",
    "CutterBindings.CutterCore.setRegister(self,regName:QString,regValue:QString)",
    "CutterBindings.CutterCore.setSettings(self)",
    "CutterBindings.CutterCore.setToCode(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.setToData(self,addr:unsigned long long,size:int,repeat:int=1)",
    "CutterBindings.CutterCore.setWriteMode(self,enabled:bool)",
    "CutterBindings.CutterCore.showMemoryWidget(self)",
    "CutterBindings.CutterCore.sizeofDataMeta(self,addr:unsigned long long)->int",
    "CutterBindings.CutterCore.startDebug(self)",
    "CutterBindings.CutterCore.startEmulation(self)",
    "CutterBindings.CutterCore.startTraceSession(self)",
    "CutterBindings.CutterCore.stepBackDebug(self)",
    "CutterBindings.CutterCore.stepDebug(self)",
    "CutterBindings.CutterCore.stepOutDebug(self)",
    "CutterBindings.CutterCore.stepOverDebug(self)",
    "CutterBindings.CutterCore.stopDebug(self)",
    "CutterBindings.CutterCore.stopTraceSession(self)",
    "CutterBindings.CutterCore.suspendDebug(self)",
    "CutterBindings.CutterCore.syncAndSeekProgramCounter(self)",
    "CutterBindings.CutterCore.toggleBreakpoint(self,addr:unsigned long long)",
    "CutterBindings.CutterCore.triggerAsmOptionsChanged(self)",
    "CutterBindings.CutterCore.triggerFlagsChanged(self)",
    "CutterBindings.CutterCore.triggerFunctionRenamed(self,offset:unsigned long long,newName:QString)",
    "CutterBindings.CutterCore.triggerGraphOptionsChanged(self)",
    "CutterBindings.CutterCore.triggerRefreshAll(self)",
    "CutterBindings.CutterCore.triggerVarsChanged(self)",
    "CutterBindings.CutterCore.tryFile(self,path:QString,rw:bool)->bool",
    "CutterBindings.CutterCore.updateSeek(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t CutterCore_SignatureByteSize = 2280;
static constexpr uint8_t CutterCore_SignatureBytes[2280] = {
    0x78, 0xda, 0xb5, 0x5a, 0xeb, 0x6f, 0xdb, 0x38, 0x12, 0xff, 0xde, 0xbf, 0xa2, 0xd8, 0x4f, 0xc9,
    0xc1, 0x0d, 0xd2, 0xbb, 0xbd, 0xde, 0x6d, 0x80, 0x14, 0xb0, 0x9d, 0xb4, 0xcd, 0x5e, 0x5e, 0xb5,
    0xd3, 0x14, 0xd8, 0x45, 0x11, 0xd0, 0xd2, 0x58, 0xe6, 0x86, 0x22, 0x05, 0x92, 0x4a, 0xe2, 0xfe,
    0xf5, 0x37, 0xa4, 0x1e, 0x96, 0xfc, 0x20, 0x29, 0xc5, 0xfb, 0xa1, 0x8d, 0x4d, 0x73, 0x7e, 0x33,
    0x1c, 0x0e, 0x87, 0xf3, 0xe0, 0x38, 0xd7, 0x1a, 0xe4, 0x88, 0xf2, 0x98, 0xf2, 0x44, 0x1d, 0x8d,
    0xed, 0xd7, 0xb1, 0x90, 0x70, 0xa0, 0x80, 0xcd, 0x07, 0x19, 0x91, 0xc0, 0xf5, 0xc9, 0xed, 0x72,
    0x4a, 0x63, 0xf8, 0x70, 0xf4, 0x55, 0x9b, 0x9f, 0x8e, 0xbe, 0xde, 0xcc, 0xfe, 0x82, 0x48, 0x9f,
    0xf2, 0x9c, 0xb1, 0x4c, 0xcb, 0xc3, 0x37, 0xe3, 0x5d, 0x28, 0x47, 0x24, 0x8e, 0x3f, 0x31, 0x92,
    0x14, 0x68, 0x62, 0x3e, 0x57, 0xa0, 0x4f, 0x72, 0xae, 0x68, 0xc2, 0x21, 0x7e, 0xcb, 0x04, 0x4f,
    0xec, 0x7f, 0x03, 0x4e, 0x52, 0x38, 0xf9, 0x3a, 0xd5, 0x12, 0xe9, 0x07, 0x8a, 0xfe, 0x84, 0x2d,
    0x93, 0x3c, 0x6c, 0x3e, 0x33, 0x31, 0x23, 0xec, 0x9e, 0x48, 0x4a, 0x66, 0x0c, 0x3a, 0x31, 0xd4,
    0xcb, 0xac, 0xfa, 0xec, 0x64, 0x82, 0x30, 0xe7, 0x2a, 0x22, 0x19, 0xdc, 0x89, 0x2f, 0x3a, 0x65,
    0x07, 0x1a, 0x5e, 0x74, 0x4d, 0xf8, 0xee, 0x63, 0xf9, 0xc9, 0x85, 0x90, 0x65, 0x0c, 0x55, 0x99,
    0x70, 0xa2, 0xf3, 0x4a, 0xc5, 0x73, 0xca, 0x20, 0x23, 0x7a, 0x11, 0x24, 0x81, 0xa5, 0xd7, 0x32,
    0x8f, 0x0c, 0xfd, 0x8d, 0x5d, 0x5d, 0x81, 0xa2, 0xda, 0x83, 0xf5, 0xd2, 0x76, 0x6a, 0xe0, 0x74,
    0x72, 0x3f, 0x7c, 0xb8, 0xb8, 0xbe, 0x1f, 0x5e, 0x5e, 0x9c, 0x39, 0x59, 0x2a, 0x05, 0x69, 0xad,
    0xd0, 0x48, 0xc4, 0xd0, 0x58, 0xf1, 0xba, 0x5d, 0x8c, 0x96, 0x1a, 0x86, 0x52, 0x92, 0xa5, 0x0b,
    0x50, 0x6b, 0x12, 0x2d, 0xce, 0x60, 0x96, 0x97, 0x56, 0x91, 0xd1, 0xf8, 0x84, 0x72, 0x7d, 0xe8,
    0xa5, 0x99, 0x40, 0x2a, 0x74, 0x29, 0x48, 0x2e, 0x69, 0x88, 0xc2, 0x66, 0x12, 0xc8, 0x63, 0x26,
    0x10, 0xfe, 0x82, 0xc7, 0xf0, 0x32, 0x2c, 0xb5, 0x85, 0xe6, 0x22, 0xb7, 0x59, 0xd8, 0xbb, 0x8f,
    0x38, 0xd3, 0x05, 0x87, 0xeb, 0x53, 0xb8, 0xf9, 0xf0, 0x52, 0xb0, 0x3e, 0xb0, 0x03, 0x27, 0x68,
    0x3f, 0xf8, 0xe5, 0xe8, 0x1b, 0xa7, 0x82, 0xff, 0xb9, 0x53, 0x27, 0x83, 0xb7, 0xd1, 0x82, 0xc8,
    0x7f, 0xfc, 0x68, 0x58, 0xca, 0xfb, 0x93, 0xdd, 0xbc, 0xa2, 0x34, 0xae, 0xb7, 0x76, 0x8b, 0x91,
    0x1d, 0x87, 0x92, 0x5a, 0xa6, 0xe1, 0x3c, 0x27, 0xe4, 0xb9, 0xdc, 0xea, 0x34, 0xee, 0xce, 0xb6,
    0x45, 0xdd, 0x9d, 0xf3, 0x50, 0x6f, 0x2c, 0xd9, 0xee, 0x15, 0x28, 0xb5, 0x7d, 0xbb, 0xc2, 0xc5,
    0xaa, 0xa0, 0x6b, 0xc1, 0xc2, 0x80, 0x9d, 0xb0, 0x77, 0x44, 0x3d, 0xba, 0xf6, 0xc8, 0x41, 0x2c,
    0xd2, 0x94, 0xea, 0xef, 0x92, 0x6a, 0x18, 0xa3, 0x65, 0x17, 0x46, 0x7d, 0xe8, 0x24, 0xe0, 0x9a,
    0xf2, 0x1c, 0x46, 0x24, 0x7a, 0x5c, 0x9d, 0x9d, 0x10, 0x8a, 0x6e, 0xb3, 0xbf, 0xe1, 0x1f, 0x36,
    0x26, 0x8c, 0x75, 0xa3, 0x68, 0x1c, 0xe7, 0x9d, 0x1e, 0x27, 0x18, 0x6c, 0xba, 0x44, 0x27, 0x5b,
    0x4b, 0xe0, 0xb4, 0x1a, 0x3c, 0xde, 0x1a, 0x3e, 0xe5, 0x3c, 0xd2, 0x78, 0xf4, 0x7c, 0xa7, 0xdb,
    0x6d, 0x25, 0x5d, 0xa0, 0x5a, 0xd7, 0x87, 0x73, 0x5d, 0x16, 0xf5, 0x1a, 0x9e, 0xc7, 0x0c, 0x1d,
    0x69, 0x69, 0x81, 0x4c, 0x85, 0x93, 0xbe, 0xe2, 0xb2, 0x88, 0x81, 0x0d, 0x19, 0x1b, 0xd5, 0x1e,
    0x50, 0x79, 0xb7, 0x14, 0x29, 0x56, 0xd3, 0x3d, 0xba, 0x74, 0xa2, 0x8c, 0xd1, 0xbc, 0xc1, 0x0b,
    0xe1, 0xda, 0x59, 0x04, 0x59, 0xc5, 0x0d, 0x6d, 0x6d, 0x1f, 0x87, 0x92, 0xf5, 0x93, 0xbd, 0x32,
    0x81, 0xd7, 0x09, 0xbf, 0x2d, 0x1a, 0xe9, 0xb4, 0x8c, 0x4e, 0xe1, 0x8c, 0x67, 0x49, 0x80, 0x5e,
    0xa6, 0xb3, 0xfd, 0xc5, 0x54, 0x19, 0xce, 0xfb, 0x30, 0x08, 0x44, 0x6a, 0x45, 0x11, 0x31, 0xd1,
    0xa4, 0xff, 0xa5, 0x19, 0xc4, 0x68, 0x8a, 0xbf, 0x31, 0xb8, 0xe0, 0x45, 0x5c, 0xe4, 0xdd, 0xce,
    0x10, 0x74, 0x88, 0xa9, 0x36, 0x72, 0x29, 0xb7, 0x6b, 0xa0, 0xc8, 0x33, 0x44, 0xbf, 0x35, 0xdc,
    0x39, 0xfe, 0x46, 0xdc, 0xf2, 0x0d, 0x8a, 0x38, 0x23, 0x10, 0x35, 0x74, 0xd5, 0x2d, 0x51, 0x8d,
    0x6b, 0x61, 0xdf, 0xa9, 0x5e, 0x5c, 0x8b, 0x4c, 0x9d, 0xcc, 0x84, 0x60, 0xa7, 0x73, 0xc2, 0x14,
    0x38, 0x99, 0xf1, 0x3d, 0x59, 0x08, 0xbc, 0x50, 0xa5, 0xd5, 0x27, 0x6a, 0x76, 0x6c, 0x2e, 0x0a,
    0x3f, 0xf5, 0xee, 0xa3, 0x11, 0xc2, 0x41, 0x34, 0xc7, 0x83, 0xee, 0x0f, 0xe8, 0xfc, 0xfb, 0x9a,
    0x80, 0x1e, 0xa2, 0xb2, 0x9e, 0x8a, 0x9b, 0xf2, 0x96, 0xe5, 0x09, 0xe5, 0x95, 0x08, 0x61, 0xd4,
    0x8c, 0x0d, 0x39, 0x61, 0x4b, 0x45, 0x95, 0x3d, 0x66, 0x95, 0x85, 0x28, 0x21, 0x35, 0xc4, 0x56,
    0x97, 0x06, 0xea, 0x12, 0xd7, 0xf8, 0x67, 0x09, 0xf8, 0xc3, 0x83, 0x58, 0xc2, 0x15, 0xc2, 0x5c,
    0xa3, 0xdf, 0x50, 0x6b, 0x12, 0x19, 0x30, 0x0f, 0x86, 0x8c, 0x16, 0x23, 0xaa, 0x6b, 0x42, 0x77,
    0x64, 0x6b, 0x08, 0x54, 0xfa, 0x1a, 0x7e, 0xa3, 0xd1, 0x17, 0x9a, 0x2c, 0x18, 0xfe, 0xc3, 0xc1,
    0x8a, 0x7a, 0x8d, 0x62, 0x44, 0x14, 0x8d, 0x46, 0x4c, 0x44, 0x8f, 0x8d, 0xb9, 0x1e, 0xd8, 0x8b,
    0x40, 0xd8, 0x86, 0xd5, 0x87, 0x83, 0xaf, 0x2e, 0xc7, 0x61, 0x11, 0x0d, 0x36, 0x16, 0x6e, 0xf7,
    0x6b, 0xd3, 0xa6, 0x7e, 0x04, 0x43, 0x5e, 0xf0, 0xf6, 0x5d, 0x32, 0xc7, 0x6f, 0xc3, 0xdd, 0x86,
    0xda, 0x8f, 0xdf, 0x58, 0x30, 0x21, 0xef, 0x16, 0xd0, 0x67, 0xcb, 0xca, 0x6b, 0x3a, 0xfc, 0x10,
    0xb9, 0x2e, 0x3d, 0x8b, 0xc7, 0xe7, 0xb4, 0xbc, 0x7c, 0x1f, 0x3b, 0x26, 0x0f, 0x1b, 0xe4, 0xeb,
    0xd9, 0x43, 0x00, 0xe9, 0x19, 0xa8, 0x48, 0xd2, 0x6c, 0xa5, 0xf1, 0x5e, 0x28, 0x37, 0x16, 0x40,
    0xed, 0x40, 0x08, 0xd1, 0xaa, 0x41, 0xa9, 0x6e, 0xee, 0x69, 0x46, 0xa2, 0xca, 0x21, 0x3c, 0xc2,
    0xb2, 0xd2, 0xca, 0xe9, 0x2f, 0xbf, 0xac, 0x61, 0x06, 0xe9, 0x76, 0xb6, 0xa9, 0x5c, 0xeb, 0x25,
    0x8f, 0x3b, 0x11, 0x57, 0x4b, 0xb2, 0xa4, 0x41, 0x7c, 0xe9, 0x26, 0x5f, 0xe3, 0x4f, 0x8e, 0x3b,
    0xd1, 0x56, 0x6c, 0x0d, 0x65, 0x10, 0xd7, 0x5c, 0x7f, 0xf8, 0x75, 0x93, 0xf1, 0xa6, 0x85, 0x86,
    0xc9, 0xd1, 0x44, 0xab, 0x44, 0xd9, 0x82, 0xe5, 0x46, 0xb2, 0xdf, 0x26, 0xe3, 0x33, 0x98, 0x93,
    0x9c, 0xe9, 0x33, 0x2a, 0x21, 0xd2, 0x42, 0x2e, 0xab, 0xa3, 0xb7, 0x1e, 0xc7, 0xe0, 0x04, 0x37,
    0x60, 0xe3, 0xce, 0xe9, 0x7e, 0x7e, 0xcf, 0xea, 0x78, 0x67, 0x79, 0x2b, 0xe1, 0x89, 0xc2, 0xf3,
    0xea, 0x20, 0x6f, 0xcf, 0x6c, 0x07, 0x3c, 0x4f, 0x1f, 0xc4, 0xfc, 0x81, 0x51, 0x8e, 0xf1, 0x84,
    0xa9, 0xba, 0x74, 0x60, 0x57, 0x79, 0x33, 0x0c, 0x58, 0x7c, 0x0e, 0xa3, 0xab, 0x5e, 0x2b, 0xe8,
    0xa9, 0x26, 0x52, 0xf7, 0x00, 0xf7, 0x98, 0x53, 0x3b, 0x98, 0xbe, 0x5b, 0x66, 0xdb, 0x22, 0xf2,
    0x60, 0x3f, 0xb5, 0x0b, 0x6d, 0x77, 0x78, 0x1e, 0xe8, 0x7f, 0xbe, 0xc0, 0x4b, 0x9c, 0xa7, 0x59,
    0x6b, 0x2f, 0x77, 0x97, 0x30, 0x6d, 0x99, 0xb4, 0xb5, 0x85, 0x6e, 0xf4, 0xc6, 0x05, 0xe9, 0x0f,
    0x63, 0x7b, 0x80, 0xde, 0x64, 0xa6, 0x3a, 0xb8, 0x17, 0xd4, 0x4b, 0xa2, 0x6a, 0x93, 0xe8, 0x10,
    0xc3, 0x77, 0xb5, 0xba, 0x2b, 0xd0, 0xa4, 0x2c, 0xe4, 0xed, 0x43, 0xea, 0x46, 0x3d, 0xb6, 0x87,
    0x30, 0x05, 0xf5, 0xef, 0xb8, 0xff, 0xfb, 0x5e, 0xe6, 0xad, 0x14, 0x89, 0x24, 0xe9, 0x58, 0xe4,
    0x1c, 0x47, 0xef, 0x09, 0xcb, 0xa1, 0xaf, 0x90, 0x13, 0x48, 0xd0, 0x4d, 0x80, 0x34, 0x21, 0x62,
    0x21, 0xa6, 0x2c, 0x47, 0x26, 0x82, 0x41, 0xa7, 0x12, 0x58, 0x81, 0xe6, 0x2f, 0x4a, 0x98, 0x79,
    0xf4, 0x27, 0xe5, 0xf7, 0x20, 0x15, 0xda, 0xc0, 0x04, 0x48, 0xbc, 0xca, 0x88, 0xb3, 0x62, 0x69,
    0x85, 0x3f, 0xaf, 0xfb, 0x11, 0x81, 0xec, 0xa7, 0x60, 0xad, 0xca, 0x38, 0xbe, 0xce, 0xae, 0x77,
    0x0a, 0x80, 0x31, 0xac, 0x6a, 0xfa, 0xfe, 0x9e, 0x01, 0xdc, 0x1e, 0x0d, 0xd0, 0x86, 0x81, 0xb5,
    0x38, 0x5f, 0x88, 0x5a, 0x54, 0xf9, 0xc6, 0xe0, 0xed, 0xea, 0x66, 0xfa, 0x9c, 0xd3, 0xa3, 0xaf,
    0x36, 0x6c, 0xfc, 0x11, 0x00, 0xf7, 0x3f, 0x58, 0x76, 0xbf, 0x98, 0x8c, 0x4f, 0x1c, 0xaa, 0xb1,
    0xd3, 0xc9, 0x3a, 0x01, 0xca, 0xcd, 0x36, 0xd9, 0xa0, 0x4c, 0x49, 0x7d, 0xf6, 0x83, 0xc8, 0x17,
    0x84, 0xc7, 0x0c, 0x26, 0xe7, 0x4f, 0x75, 0x05, 0x4a, 0xa3, 0x38, 0xc6, 0x53, 0x16, 0x85, 0x87,
    0x27, 0x41, 0x63, 0x97, 0xc1, 0x2d, 0xaa, 0xea, 0xfe, 0x9d, 0x28, 0xfc, 0x24, 0x0e, 0xbc, 0xb2,
    0xe7, 0x41, 0x39, 0xd5, 0x94, 0x30, 0x74, 0xd8, 0x85, 0x40, 0x4c, 0x90, 0xb8, 0xbc, 0xf4, 0x8b,
    0x54, 0x1b, 0x3d, 0x9c, 0x33, 0xd3, 0x36, 0x99, 0x3a, 0xe1, 0x11, 0x1c, 0x6c, 0x26, 0x3f, 0xab,
    0x59, 0x2e, 0x7a, 0x61, 0xce, 0x8d, 0xbb, 0x1a, 0xc0, 0x80, 0x97, 0xd7, 0x49, 0xaf, 0x25, 0x56,
    0x19, 0xd4, 0x15, 0xc9, 0x32, 0xf0, 0x06, 0x08, 0x9e, 0xdc, 0x9e, 0xaa, 0xf5, 0xaa, 0xc2, 0xaa,
    0x93, 0xa3, 0x4e, 0x76, 0x9e, 0xb4, 0xd7, 0x30, 0xb4, 0x91, 0x98, 0xa9, 0xe8, 0x5f, 0x70, 0xeb,
    0x30, 0x41, 0xa9, 0xc0, 0x42, 0x04, 0x55, 0x9f, 0x25, 0xc9, 0x16, 0xe7, 0x69, 0xa6, 0x97, 0xc1,
    0x24, 0x17, 0x37, 0xb6, 0xf0, 0x7f, 0x6e, 0x4b, 0x28, 0x71, 0x30, 0xd9, 0x04, 0x62, 0x1b, 0x73,
    0x1a, 0x2a, 0x2b, 0x31, 0x40, 0x30, 0xad, 0x6d, 0x37, 0x5c, 0xe1, 0x1d, 0xdd, 0x91, 0xa9, 0x16,
    0xa4, 0x3c, 0xc9, 0x79, 0xba, 0xcd, 0x70, 0x64, 0xfc, 0x62, 0x0c, 0xe7, 0xf4, 0xfd, 0x87, 0xa0,
    0xf3, 0xf9, 0x57, 0x9a, 0x4d, 0xe0, 0x09, 0x0f, 0x38, 0xf4, 0xae, 0x17, 0x31, 0xdc, 0x7f, 0x53,
    0xe7, 0x55, 0x43, 0x55, 0xb0, 0xdb, 0x47, 0x1d, 0xc8, 0x1c, 0xca, 0x2a, 0xbe, 0xf7, 0xde, 0x4a,
    0x66, 0x72, 0x99, 0x04, 0x74, 0xa2, 0x31, 0x35, 0xae, 0xaa, 0xb5, 0xbe, 0x2a, 0xe3, 0x0f, 0x66,
    0x3b, 0x04, 0x3f, 0x3d, 0xbe, 0xbc, 0x1c, 0xa4, 0x24, 0x73, 0xfd, 0x9c, 0x81, 0x4c, 0x6d, 0x2c,
    0x7f, 0x3a, 0xf9, 0xe3, 0xe1, 0xf6, 0x7c, 0x72, 0xf5, 0x30, 0x19, 0x3c, 0x11, 0x3b, 0x70, 0x6c,
    0x3d, 0xcd, 0x8c, 0xf2, 0x46, 0x41, 0x6f, 0x80, 0x2e, 0x35, 0x02, 0x94, 0xaf, 0x70, 0x40, 0x75,
    0x42, 0x5a, 0xfe, 0x3d, 0x38, 0xf4, 0x5b, 0x84, 0x75, 0x5f, 0x67, 0xa3, 0x55, 0x4b, 0x22, 0xa4,
    0x32, 0x69, 0x88, 0xa6, 0x36, 0x3d, 0x2f, 0xab, 0x63, 0xf6, 0x73, 0x68, 0x23, 0x05, 0x75, 0xb0,
    0x43, 0x75, 0xbb, 0xb5, 0xe3, 0x5f, 0x08, 0x5e, 0x2d, 0x8b, 0x02, 0x12, 0x5e, 0x32, 0xe9, 0xce,
    0x31, 0x1d, 0x28, 0xe8, 0x2a, 0x48, 0x52, 0xca, 0x96, 0xaa, 0xa4, 0x16, 0x2d, 0x36, 0x07, 0x34,
    0xb0, 0x96, 0x9a, 0x8a, 0x98, 0xce, 0x97, 0x7f, 0xff, 0x23, 0x06, 0x0e, 0x04, 0x5d, 0x9b, 0x0e,
    0x79, 0x94, 0x61, 0x0a, 0xac, 0x45, 0x54, 0x7a, 0x93, 0x6f, 0x9b, 0x10, 0x56, 0x57, 0xe1, 0xf0,
    0xa2, 0x6f, 0x32, 0x73, 0x39, 0x54, 0xad, 0x52, 0x4c, 0xf1, 0x76, 0x94, 0xc1, 0x06, 0x91, 0x89,
    0x51, 0xcb, 0x5b, 0xa8, 0xd3, 0x1e, 0x70, 0x91, 0x05, 0x27, 0x0a, 0x2e, 0x98, 0x3c, 0x7d, 0xbd,
    0x3d, 0x64, 0x98, 0xbf, 0xfd, 0xfd, 0x2b, 0x96, 0x90, 0x8a, 0x27, 0x08, 0x89, 0x1e, 0x9d, 0x20,
    0xc6, 0x86, 0xaa, 0x72, 0x33, 0xe6, 0x43, 0x0b, 0x11, 0x57, 0x5d, 0x22, 0xa2, 0xd4, 0x75, 0xd3,
    0xc0, 0x04, 0x8b, 0x8b, 0x09, 0xad, 0x51, 0x0e, 0xcf, 0x9b, 0xa3, 0x7e, 0x96, 0x8d, 0x7e, 0x14,
    0xe2, 0xae, 0x23, 0x76, 0xc3, 0x6a, 0xd8, 0x32, 0x8b, 0x1f, 0xf8, 0x1a, 0xd6, 0x03, 0xef, 0x06,
    0xd6, 0x2a, 0xd9, 0x3a, 0xce, 0x5e, 0x67, 0x29, 0x4b, 0xe0, 0xb5, 0x9e, 0x60, 0x1b, 0x66, 0x43,
    0x19, 0xf3, 0xaa, 0x21, 0xbd, 0xfb, 0xb1, 0x82, 0x93, 0x33, 0x4a, 0xdf, 0xe1, 0x95, 0x81, 0x22,
    0x26, 0x50, 0xfd, 0x59, 0x5a, 0xd5, 0x27, 0x21, 0x4d, 0x85, 0x98, 0x98, 0x72, 0x4f, 0xa7, 0x00,
    0x5e, 0xc5, 0xb3, 0xcf, 0xd5, 0xc3, 0xa4, 0x96, 0xaf, 0x6e, 0x14, 0x40, 0x43, 0x81, 0xea, 0xec,
    0xac, 0x85, 0xd4, 0xa5, 0x9f, 0x52, 0x82, 0xd4, 0x89, 0xcc, 0x6b, 0x80, 0xa6, 0xbe, 0x65, 0xe1,
    0xcd, 0xcb, 0xd6, 0x8b, 0xb3, 0xae, 0xe2, 0x94, 0xc2, 0x3c, 0xb2, 0x4c, 0x52, 0x16, 0xf8, 0x5b,
    0x58, 0x7b, 0x78, 0x45, 0xe4, 0xe8, 0x08, 0xfb, 0xb8, 0x0e, 0x79, 0x3c, 0x5d, 0x88, 0xe7, 0x5e,
    0xcc, 0x5b, 0xb4, 0xbd, 0xba, 0xd2, 0x06, 0xe5, 0x1a, 0x6f, 0x06, 0xbf, 0x49, 0xe2, 0x44, 0x53,
    0x10, 0x0b, 0x78, 0x0d, 0x62, 0xa6, 0x4e, 0x31, 0x48, 0xa8, 0xd3, 0xbe, 0x6e, 0x8b, 0x6a, 0x92,
    0xf6, 0x5c, 0x93, 0xae, 0xe2, 0x51, 0x77, 0xa6, 0x55, 0x55, 0xee, 0x4e, 0x8f, 0x3d, 0x70, 0xab,
    0x24, 0xe8, 0x4e, 0x92, 0xa8, 0x74, 0x19, 0xd4, 0xbc, 0x64, 0xb3, 0xe9, 0x6c, 0xd1, 0x7f, 0x2d,
    0x3b, 0x8c, 0x6e, 0xa4, 0xf1, 0xed, 0xb7, 0x52, 0x26, 0x19, 0xad, 0x0c, 0x37, 0xca, 0xf2, 0x55,
    0x08, 0x4a, 0xb5, 0xf2, 0xbd, 0xc3, 0x53, 0x65, 0xbf, 0x69, 0xa3, 0x9d, 0x81, 0xd7, 0x18, 0x0e,
    0xaf, 0x1b, 0xbe, 0x07, 0xc8, 0xff, 0x46, 0x64, 0x10, 0xa5, 0x8d, 0x5e, 0xfa, 0x6f, 0x27, 0x1e,
    0xc0, 0x2d, 0xdd, 0xa7, 0xc1, 0x53, 0xa9, 0x9d, 0xff, 0xf6, 0x23, 0xae, 0x99, 0xff, 0xa7, 0x27,
    0xbd, 0x75, 0xf7, 0x46, 0xab, 0x1f, 0xfa, 0x01, 0x14, 0x9d, 0x8a, 0x37, 0xff, 0xee, 0x47, 0x6d,
    0xf7, 0xf3, 0xd7, 0x2e, 0xb4, 0xc5, 0xdb, 0xb8, 0x4a, 0x6b, 0xff, 0xea, 0x43, 0x5a, 0xeb, 0xec,
    0x9f, 0xbd, 0xa8, 0x6b, 0x8d, 0xbd, 0xef, 0x43, 0x5e, 0xea, 0xeb, 0xb8, 0x0f, 0x6d, 0x80, 0xf5,
    0xe7, 0xd2, 0x3c, 0x88, 0xae, 0xfb, 0xea, 0xf5, 0xa9, 0x79, 0xfd, 0x43, 0xdb, 0x15, 0x7a, 0xd1,
    0x13, 0x92, 0x22, 0xaa, 0x4a, 0x10, 0x21, 0x4f, 0x64, 0xd7, 0xc8, 0xef, 0x16, 0xb2, 0x2e, 0xf8,
    0xe8, 0x20, 0xea, 0xf5, 0xd7, 0x0f, 0x83, 0xac, 0x95, 0x1f, 0x7a, 0xa8, 0x8b, 0x47, 0x2c, 0xbc,
    0x96, 0x78, 0x46, 0x93, 0x10, 0xb7, 0xb4, 0x56, 0x38, 0x19, 0x80, 0xf9, 0x18, 0x42, 0x58, 0x96,
    0x4f, 0x4a, 0xaa, 0x70, 0x3f, 0x78, 0x81, 0x4e, 0x07, 0x25, 0xd5, 0x30, 0x22, 0x55, 0xfd, 0x41,
    0xfe, 0x34, 0x9f, 0xdb, 0x51, 0xd8, 0x1e, 0x36, 0xb3, 0x2a, 0x95, 0xd7, 0x65, 0xf2, 0x16, 0x07,
    0xfc, 0x6e, 0x0b, 0xf1, 0x81, 0xea, 0xc5, 0xb8, 0x43, 0x9b, 0xe1, 0x80, 0xeb, 0x52, 0xdf, 0x89,
    0xb1, 0xb7, 0x0f, 0xe3, 0x43, 0x38, 0x23, 0x9a, 0x84, 0xdd, 0x61, 0xb8, 0x92, 0x0c, 0x88, 0x2e,
    0x0a, 0x40, 0x1e, 0xdc, 0xba, 0x00, 0xd5, 0x71, 0xdb, 0x30, 0xd4, 0xb8, 0xc2, 0x6c, 0x47, 0x2e,
    0xbf, 0xd3, 0x38, 0x81, 0x80, 0x98, 0x01, 0x65, 0x13, 0x73, 0xb3, 0x06, 0xd3, 0xe1, 0x79, 0xdd,
    0x93, 0x6f, 0x9b, 0xbc, 0x85, 0xbd, 0xa1, 0xb5, 0x53, 0xcf, 0xd3, 0x9c, 0x35, 0x0a, 0xd6, 0xbe,
    0xe9, 0xf6, 0x5e, 0x9f, 0xe2, 0xb1, 0x09, 0xa3, 0x80, 0x2c, 0xfc, 0x01, 0xb0, 0x99, 0x1d, 0x3e,
    0x13, 0x53, 0xfc, 0x0e, 0x93, 0x9f, 0x40, 0x86, 0xce, 0x16, 0x59, 0xf8, 0xcc, 0x6e, 0xda, 0xc8,
    0x55, 0x06, 0x3c, 0x0e, 0x44, 0x5f, 0xf2, 0xc8, 0x44, 0xad, 0x36, 0x9a, 0x6c, 0xb6, 0xc3, 0xbc,
    0x94, 0x5a, 0x24, 0xc9, 0x5e, 0x1e, 0xb9, 0xe1, 0x39, 0x4f, 0x12, 0x90, 0x43, 0x95, 0x96, 0x2f,
    0x4c, 0xc6, 0x0b, 0xc2, 0x93, 0xaa, 0x0c, 0xeb, 0x27, 0xb4, 0x05, 0xcf, 0xae, 0x34, 0x65, 0xfa,
    0x38, 0xb1, 0x29, 0x68, 0xbc, 0xc7, 0xa4, 0xb6, 0x64, 0x60, 0x1d, 0x78, 0xbf, 0xf5, 0x4c, 0x60,
    0x8e, 0xf9, 0xe9, 0x62, 0x18, 0xf0, 0xd6, 0xbc, 0xa4, 0xc0, 0xc8, 0xa0, 0x03, 0x93, 0xe5, 0x8e,
    0x82, 0xa1, 0x7c, 0xae, 0x9e, 0xe4, 0x79, 0x82, 0xd4, 0x3c, 0x8b, 0xcd, 0x0b, 0xec, 0x2a, 0xd9,
    0x3a, 0x7c, 0xf3, 0x7f, 0x21, 0x05, 0xd0, 0x78
};
#endif

PyTypeObject *init_CutterCore(PyObject *module)
{
    if (SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX].type != nullptr)
        return SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX].type;

    Shiboken::AutoDecRef Sbk_CutterCore_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_CutterCore_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "CutterCore",
        "CutterCore*",
        &Sbk_CutterCore_spec,
        &Shiboken::callCppDestructor< CutterCore >,
        Sbk_CutterCore_Type_bases.object(),
        0);
    auto *pyType = _Sbk_CutterCore_Type; // references _Sbk_CutterCore_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, CutterCore_SignatureStrings);
#else
    InitSignatureBytes(pyType, CutterCore_SignatureBytes, CutterCore_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_CutterCore_PropertyStrings);
    SbkCutterBindingsTypeStructs[SBK_CutterCore_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        CutterCore_PythonToCpp_CutterCore_PTR,
        is_CutterCore_PythonToCpp_CutterCore_PTR_Convertible,
        CutterCore_PTR_CppToPython_CutterCore);

    Shiboken::Conversions::registerConverterName(converter, "CutterCore");
    Shiboken::Conversions::registerConverterName(converter, "CutterCore*");
    Shiboken::Conversions::registerConverterName(converter, "CutterCore&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::CutterCore).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(CutterCoreWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_CutterCore_TypeF(), &Sbk_CutterCore_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::CutterCore::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::CutterCore::staticMetaObject, sizeof(CutterCoreWrapper));

    return pyType;
}
