// ui/base/cursor/mojom/cursor.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SHARED_H_
#define UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/cursor/mojom/cursor.mojom-shared-internal.h"
#include "skia/public/mojom/bitmap.mojom-shared.h"
#include "ui/base/cursor/mojom/cursor_type.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace ui::mojom {
class CursorDataView;



}  // ui::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ui::mojom::CursorDataView> {
  using Data = ::ui::mojom::internal::Cursor_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace ui::mojom {


class CursorDataView {
 public:
  CursorDataView() = default;

  CursorDataView(
      internal::Cursor_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::ui::mojom::CursorType>(
        data_value, output);
  }
  ::ui::mojom::CursorType type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ui::mojom::CursorType>(data_->type));
  }
  inline void GetHotspotDataView(
      ::gfx::mojom::PointDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHotspot(UserType* output) {
    
    auto* pointer = data_->hotspot.Get();
    return mojo::internal::Deserialize<::gfx::mojom::PointDataView>(
        pointer, output, message_);
  }
  inline void GetBitmapDataView(
      ::skia::mojom::BitmapN32DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBitmap(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapN32DataView, UserType>(),
    "Attempting to read the optional `bitmap` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBitmap` instead "
    "of `ReadBitmap if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->bitmap.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapN32DataView>(
        pointer, output, message_);
  }
  float image_scale_factor() const {
    return data_->image_scale_factor;
  }
 private:
  internal::Cursor_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // ui::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ui::mojom::CursorDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::CursorDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::Cursor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::ui::mojom::CursorType>(
        Traits::type(input), &fragment->type);
    decltype(Traits::hotspot(input)) in_hotspot = Traits::hotspot(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->hotspot)::BaseType> hotspot_fragment(
            fragment.message());
    mojo::internal::Serialize<::gfx::mojom::PointDataView>(
        in_hotspot, hotspot_fragment);
    fragment->hotspot.Set(
        hotspot_fragment.is_null() ? nullptr : hotspot_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->hotspot.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null hotspot in Cursor struct");
    decltype(Traits::bitmap(input)) in_bitmap = Traits::bitmap(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bitmap)::BaseType> bitmap_fragment(
            fragment.message());
    mojo::internal::Serialize<::skia::mojom::BitmapN32DataView>(
        in_bitmap, bitmap_fragment);
    fragment->bitmap.Set(
        bitmap_fragment.is_null() ? nullptr : bitmap_fragment.data());
    fragment->image_scale_factor = Traits::image_scale_factor(input);
  }

  static bool Deserialize(::ui::mojom::internal::Cursor_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ui::mojom::CursorDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ui::mojom {

inline void CursorDataView::GetHotspotDataView(
    ::gfx::mojom::PointDataView* output) {
  auto pointer = data_->hotspot.Get();
  *output = ::gfx::mojom::PointDataView(pointer, message_);
}
inline void CursorDataView::GetBitmapDataView(
    ::skia::mojom::BitmapN32DataView* output) {
  auto pointer = data_->bitmap.Get();
  *output = ::skia::mojom::BitmapN32DataView(pointer, message_);
}



}  // ui::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_BASE_CURSOR_MOJOM_CURSOR_MOJOM_SHARED_H_