// third_party/blink/public/mojom/webauthn/authenticator.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "mojo/public/cpp/bindings/features.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-params-data.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/webauthn/authenticator.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
CommonCredentialInfo::CommonCredentialInfo()
    : id(),
      raw_id(),
      client_data_json(),
      authenticator_data() {}

CommonCredentialInfo::CommonCredentialInfo(
    const WTF::String& id_in,
    WTF::Vector<uint8_t> raw_id_in,
    WTF::Vector<uint8_t> client_data_json_in,
    WTF::Vector<uint8_t> authenticator_data_in)
    : id(std::move(id_in)),
      raw_id(std::move(raw_id_in)),
      client_data_json(std::move(client_data_json_in)),
      authenticator_data(std::move(authenticator_data_in)) {}

CommonCredentialInfo::~CommonCredentialInfo() = default;

void CommonCredentialInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "raw_id"), this->raw_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_data_json"), this->client_data_json,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_data"), this->authenticator_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CommonCredentialInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SupplementalPubKeysResponse::SupplementalPubKeysResponse()
    : signatures() {}

SupplementalPubKeysResponse::SupplementalPubKeysResponse(
    WTF::Vector<WTF::Vector<uint8_t>> signatures_in)
    : signatures(std::move(signatures_in)) {}

SupplementalPubKeysResponse::~SupplementalPubKeysResponse() = default;

void SupplementalPubKeysResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signatures"), this->signatures,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupplementalPubKeysResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticationExtensionsPaymentResponse::AuthenticationExtensionsPaymentResponse()
    : browser_bound_signature() {}

AuthenticationExtensionsPaymentResponse::AuthenticationExtensionsPaymentResponse(
    WTF::Vector<uint8_t> browser_bound_signature_in)
    : browser_bound_signature(std::move(browser_bound_signature_in)) {}

AuthenticationExtensionsPaymentResponse::~AuthenticationExtensionsPaymentResponse() = default;

void AuthenticationExtensionsPaymentResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_bound_signature"), this->browser_bound_signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthenticationExtensionsPaymentResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MakeCredentialAuthenticatorResponse::MakeCredentialAuthenticatorResponse()
    : info(),
      authenticator_attachment(),
      attestation_object(),
      transports(),
      echo_hmac_create_secret(),
      hmac_create_secret(),
      echo_prf(),
      prf(),
      prf_results(),
      echo_cred_blob(),
      cred_blob(),
      public_key_der(),
      public_key_algo(),
      echo_cred_props(),
      has_cred_props_rk(),
      cred_props_rk(),
      echo_large_blob(),
      supports_large_blob(),
      supplemental_pub_keys(),
      payment() {}

MakeCredentialAuthenticatorResponse::MakeCredentialAuthenticatorResponse(
    CommonCredentialInfoPtr info_in,
    AuthenticatorAttachment authenticator_attachment_in,
    WTF::Vector<uint8_t> attestation_object_in,
    WTF::Vector<AuthenticatorTransport> transports_in,
    bool echo_hmac_create_secret_in,
    bool hmac_create_secret_in,
    bool echo_prf_in,
    bool prf_in,
    PRFValuesPtr prf_results_in,
    bool echo_cred_blob_in,
    bool cred_blob_in,
    std::optional<WTF::Vector<uint8_t>> public_key_der_in,
    int32_t public_key_algo_in,
    bool echo_cred_props_in,
    bool has_cred_props_rk_in,
    bool cred_props_rk_in,
    bool echo_large_blob_in,
    bool supports_large_blob_in,
    SupplementalPubKeysResponsePtr supplemental_pub_keys_in,
    AuthenticationExtensionsPaymentResponsePtr payment_in)
    : info(std::move(info_in)),
      authenticator_attachment(std::move(authenticator_attachment_in)),
      attestation_object(std::move(attestation_object_in)),
      transports(std::move(transports_in)),
      echo_hmac_create_secret(std::move(echo_hmac_create_secret_in)),
      hmac_create_secret(std::move(hmac_create_secret_in)),
      echo_prf(std::move(echo_prf_in)),
      prf(std::move(prf_in)),
      prf_results(std::move(prf_results_in)),
      echo_cred_blob(std::move(echo_cred_blob_in)),
      cred_blob(std::move(cred_blob_in)),
      public_key_der(std::move(public_key_der_in)),
      public_key_algo(std::move(public_key_algo_in)),
      echo_cred_props(std::move(echo_cred_props_in)),
      has_cred_props_rk(std::move(has_cred_props_rk_in)),
      cred_props_rk(std::move(cred_props_rk_in)),
      echo_large_blob(std::move(echo_large_blob_in)),
      supports_large_blob(std::move(supports_large_blob_in)),
      supplemental_pub_keys(std::move(supplemental_pub_keys_in)),
      payment(std::move(payment_in)) {}

MakeCredentialAuthenticatorResponse::~MakeCredentialAuthenticatorResponse() = default;

void MakeCredentialAuthenticatorResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CommonCredentialInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_attachment"), this->authenticator_attachment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorAttachment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation_object"), this->attestation_object,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transports"), this->transports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<AuthenticatorTransport>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_hmac_create_secret"), this->echo_hmac_create_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hmac_create_secret"), this->hmac_create_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_prf"), this->echo_prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf"), this->prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_results"), this->prf_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PRFValuesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_cred_blob"), this->echo_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_blob"), this->cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_der"), this->public_key_der,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_algo"), this->public_key_algo,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_cred_props"), this->echo_cred_props,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_cred_props_rk"), this->has_cred_props_rk,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_props_rk"), this->cred_props_rk,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_large_blob"), this->echo_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supports_large_blob"), this->supports_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supplemental_pub_keys"), this->supplemental_pub_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SupplementalPubKeysResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment"), this->payment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticationExtensionsPaymentResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool MakeCredentialAuthenticatorResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
GetAssertionAuthenticatorResponse::GetAssertionAuthenticatorResponse()
    : info(),
      authenticator_attachment(),
      signature(),
      user_handle(),
      extensions() {}

GetAssertionAuthenticatorResponse::GetAssertionAuthenticatorResponse(
    CommonCredentialInfoPtr info_in,
    AuthenticatorAttachment authenticator_attachment_in,
    WTF::Vector<uint8_t> signature_in,
    std::optional<WTF::Vector<uint8_t>> user_handle_in,
    AuthenticationExtensionsClientOutputsPtr extensions_in)
    : info(std::move(info_in)),
      authenticator_attachment(std::move(authenticator_attachment_in)),
      signature(std::move(signature_in)),
      user_handle(std::move(user_handle_in)),
      extensions(std::move(extensions_in)) {}

GetAssertionAuthenticatorResponse::~GetAssertionAuthenticatorResponse() = default;

void GetAssertionAuthenticatorResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "info"), this->info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CommonCredentialInfoPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_attachment"), this->authenticator_attachment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorAttachment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "signature"), this->signature,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_handle"), this->user_handle,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticationExtensionsClientOutputsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool GetAssertionAuthenticatorResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticationExtensionsClientOutputs::AuthenticationExtensionsClientOutputs()
    : echo_appid_extension(),
      appid_extension(),
      echo_prf(),
      prf_results(),
      prf_not_evaluated(),
      echo_large_blob(),
      large_blob(),
      echo_large_blob_written(),
      large_blob_written(),
      get_cred_blob(),
      supplemental_pub_keys(),
      payment() {}

AuthenticationExtensionsClientOutputs::AuthenticationExtensionsClientOutputs(
    bool echo_appid_extension_in,
    bool appid_extension_in,
    bool echo_prf_in,
    PRFValuesPtr prf_results_in,
    bool prf_not_evaluated_in,
    bool echo_large_blob_in,
    std::optional<WTF::Vector<uint8_t>> large_blob_in,
    bool echo_large_blob_written_in,
    bool large_blob_written_in,
    std::optional<WTF::Vector<uint8_t>> get_cred_blob_in,
    SupplementalPubKeysResponsePtr supplemental_pub_keys_in,
    AuthenticationExtensionsPaymentResponsePtr payment_in)
    : echo_appid_extension(std::move(echo_appid_extension_in)),
      appid_extension(std::move(appid_extension_in)),
      echo_prf(std::move(echo_prf_in)),
      prf_results(std::move(prf_results_in)),
      prf_not_evaluated(std::move(prf_not_evaluated_in)),
      echo_large_blob(std::move(echo_large_blob_in)),
      large_blob(std::move(large_blob_in)),
      echo_large_blob_written(std::move(echo_large_blob_written_in)),
      large_blob_written(std::move(large_blob_written_in)),
      get_cred_blob(std::move(get_cred_blob_in)),
      supplemental_pub_keys(std::move(supplemental_pub_keys_in)),
      payment(std::move(payment_in)) {}

AuthenticationExtensionsClientOutputs::~AuthenticationExtensionsClientOutputs() = default;

void AuthenticationExtensionsClientOutputs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_appid_extension"), this->echo_appid_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appid_extension"), this->appid_extension,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_prf"), this->echo_prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_results"), this->prf_results,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PRFValuesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_not_evaluated"), this->prf_not_evaluated,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_large_blob"), this->echo_large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob"), this->large_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "echo_large_blob_written"), this->echo_large_blob_written,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_written"), this->large_blob_written,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_cred_blob"), this->get_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supplemental_pub_keys"), this->supplemental_pub_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SupplementalPubKeysResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment"), this->payment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticationExtensionsPaymentResponsePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthenticationExtensionsClientOutputs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialRpEntity::PublicKeyCredentialRpEntity()
    : id(),
      name() {}

PublicKeyCredentialRpEntity::PublicKeyCredentialRpEntity(
    const WTF::String& id_in,
    const WTF::String& name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)) {}

PublicKeyCredentialRpEntity::~PublicKeyCredentialRpEntity() = default;
size_t PublicKeyCredentialRpEntity::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->id);
  seed = mojo::internal::WTFHash(seed, this->name);
  return seed;
}

void PublicKeyCredentialRpEntity::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialRpEntity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialUserEntity::PublicKeyCredentialUserEntity()
    : id(),
      name(),
      display_name() {}

PublicKeyCredentialUserEntity::PublicKeyCredentialUserEntity(
    WTF::Vector<uint8_t> id_in,
    const WTF::String& name_in,
    const WTF::String& display_name_in)
    : id(std::move(id_in)),
      name(std::move(name_in)),
      display_name(std::move(display_name_in)) {}

PublicKeyCredentialUserEntity::~PublicKeyCredentialUserEntity() = default;

void PublicKeyCredentialUserEntity::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialUserEntity::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialParameters::PublicKeyCredentialParameters()
    : type(),
      algorithm_identifier() {}

PublicKeyCredentialParameters::PublicKeyCredentialParameters(
    PublicKeyCredentialType type_in,
    int32_t algorithm_identifier_in)
    : type(std::move(type_in)),
      algorithm_identifier(std::move(algorithm_identifier_in)) {}

PublicKeyCredentialParameters::~PublicKeyCredentialParameters() = default;
size_t PublicKeyCredentialParameters::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->type);
  seed = mojo::internal::WTFHash(seed, this->algorithm_identifier);
  return seed;
}

void PublicKeyCredentialParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "algorithm_identifier"), this->algorithm_identifier,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CableAuthentication::CableAuthentication()
    : version(),
      client_eid(),
      authenticator_eid(),
      session_pre_key(),
      server_link_data(),
      experiments() {}

CableAuthentication::CableAuthentication(
    uint8_t version_in,
    std::optional<WTF::Vector<uint8_t>> client_eid_in,
    std::optional<WTF::Vector<uint8_t>> authenticator_eid_in,
    std::optional<WTF::Vector<uint8_t>> session_pre_key_in,
    std::optional<WTF::Vector<uint8_t>> server_link_data_in,
    std::optional<WTF::Vector<uint8_t>> experiments_in)
    : version(std::move(version_in)),
      client_eid(std::move(client_eid_in)),
      authenticator_eid(std::move(authenticator_eid_in)),
      session_pre_key(std::move(session_pre_key_in)),
      server_link_data(std::move(server_link_data_in)),
      experiments(std::move(experiments_in)) {}

CableAuthentication::~CableAuthentication() = default;

void CableAuthentication::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "version"), this->version,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "client_eid"), this->client_eid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_eid"), this->authenticator_eid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "session_pre_key"), this->session_pre_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "server_link_data"), this->server_link_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "experiments"), this->experiments,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CableAuthentication::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PRFValues::PRFValues()
    : id(),
      first(),
      second() {}

PRFValues::PRFValues(
    std::optional<WTF::Vector<uint8_t>> id_in,
    WTF::Vector<uint8_t> first_in,
    std::optional<WTF::Vector<uint8_t>> second_in)
    : id(std::move(id_in)),
      first(std::move(first_in)),
      second(std::move(second_in)) {}

PRFValues::~PRFValues() = default;

void PRFValues::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "first"), this->first,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "second"), this->second,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PRFValues::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentOptions::PaymentOptions()
    : total(),
      instrument(),
      payee_name(),
      payee_origin(),
      browser_bound_public_key() {}

PaymentOptions::PaymentOptions(
    ::payments::mojom::blink::PaymentCurrencyAmountPtr total_in,
    PaymentCredentialInstrumentPtr instrument_in,
    const WTF::String& payee_name_in,
    const ::scoped_refptr<const ::blink::SecurityOrigin>& payee_origin_in,
    std::optional<WTF::Vector<uint8_t>> browser_bound_public_key_in)
    : total(std::move(total_in)),
      instrument(std::move(instrument_in)),
      payee_name(std::move(payee_name_in)),
      payee_origin(std::move(payee_origin_in)),
      browser_bound_public_key(std::move(browser_bound_public_key_in)) {}

PaymentOptions::~PaymentOptions() = default;

void PaymentOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "total"), this->total,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::payments::mojom::blink::PaymentCurrencyAmountPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "instrument"), this->instrument,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PaymentCredentialInstrumentPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payee_name"), this->payee_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payee_origin"), this->payee_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_bound_public_key"), this->browser_bound_public_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PaymentCredentialInstrument::PaymentCredentialInstrument()
    : display_name(),
      icon(),
      iconMustBeShown() {}

PaymentCredentialInstrument::PaymentCredentialInstrument(
    const WTF::String& display_name_in,
    const ::blink::KURL& icon_in,
    bool iconMustBeShown_in)
    : display_name(std::move(display_name_in)),
      icon(std::move(icon_in)),
      iconMustBeShown(std::move(iconMustBeShown_in)) {}

PaymentCredentialInstrument::~PaymentCredentialInstrument() = default;

void PaymentCredentialInstrument::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "icon"), this->icon,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "iconMustBeShown"), this->iconMustBeShown,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PaymentCredentialInstrument::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
RemoteDesktopClientOverride::RemoteDesktopClientOverride()
    : origin(),
      same_origin_with_ancestors() {}

RemoteDesktopClientOverride::RemoteDesktopClientOverride(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& origin_in,
    bool same_origin_with_ancestors_in)
    : origin(std::move(origin_in)),
      same_origin_with_ancestors(std::move(same_origin_with_ancestors_in)) {}

RemoteDesktopClientOverride::~RemoteDesktopClientOverride() = default;

void RemoteDesktopClientOverride::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin"), this->origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "same_origin_with_ancestors"), this->same_origin_with_ancestors,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool RemoteDesktopClientOverride::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SupplementalPubKeysRequest::SupplementalPubKeysRequest()
    : device_scope_requested(),
      provider_scope_requested(),
      attestation(),
      attestation_formats() {}

SupplementalPubKeysRequest::SupplementalPubKeysRequest(
    bool device_scope_requested_in,
    bool provider_scope_requested_in,
    AttestationConveyancePreference attestation_in,
    WTF::Vector<WTF::String> attestation_formats_in)
    : device_scope_requested(std::move(device_scope_requested_in)),
      provider_scope_requested(std::move(provider_scope_requested_in)),
      attestation(std::move(attestation_in)),
      attestation_formats(std::move(attestation_formats_in)) {}

SupplementalPubKeysRequest::~SupplementalPubKeysRequest() = default;

void SupplementalPubKeysRequest::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_scope_requested"), this->device_scope_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "provider_scope_requested"), this->provider_scope_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation"), this->attestation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AttestationConveyancePreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation_formats"), this->attestation_formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SupplementalPubKeysRequest::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions()
    : is_conditional(),
      requested_credential_type_flags(),
      challenge(),
      challenge_url(),
      timeout(),
      relying_party_id(),
      allow_credentials(),
      hints(),
      user_verification(),
      extensions() {}

PublicKeyCredentialRequestOptions::PublicKeyCredentialRequestOptions(
    bool is_conditional_in,
    int32_t requested_credential_type_flags_in,
    std::optional<WTF::Vector<uint8_t>> challenge_in,
    const std::optional<::blink::KURL>& challenge_url_in,
    std::optional<::base::TimeDelta> timeout_in,
    const WTF::String& relying_party_id_in,
    WTF::Vector<PublicKeyCredentialDescriptorPtr> allow_credentials_in,
    WTF::Vector<Hint> hints_in,
    UserVerificationRequirement user_verification_in,
    AuthenticationExtensionsClientInputsPtr extensions_in)
    : is_conditional(std::move(is_conditional_in)),
      requested_credential_type_flags(std::move(requested_credential_type_flags_in)),
      challenge(std::move(challenge_in)),
      challenge_url(std::move(challenge_url_in)),
      timeout(std::move(timeout_in)),
      relying_party_id(std::move(relying_party_id_in)),
      allow_credentials(std::move(allow_credentials_in)),
      hints(std::move(hints_in)),
      user_verification(std::move(user_verification_in)),
      extensions(std::move(extensions_in)) {}

PublicKeyCredentialRequestOptions::~PublicKeyCredentialRequestOptions() = default;

void PublicKeyCredentialRequestOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_conditional"), this->is_conditional,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "requested_credential_type_flags"), this->requested_credential_type_flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge_url"), this->challenge_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::KURL>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relying_party_id"), this->relying_party_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_credentials"), this->allow_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PublicKeyCredentialDescriptorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hints"), this->hints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<Hint>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_verification"), this->user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserVerificationRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "extensions"), this->extensions,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticationExtensionsClientInputsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialRequestOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticationExtensionsClientInputs::AuthenticationExtensionsClientInputs()
    : appid(),
      cable_authentication_data(),
      prf(),
      prf_inputs(),
      large_blob_read(),
      large_blob_write(),
      get_cred_blob(),
      remote_desktop_client_override(),
      supplemental_pub_keys(),
      payment_browser_bound_key_parameters() {}

AuthenticationExtensionsClientInputs::AuthenticationExtensionsClientInputs(
    const WTF::String& appid_in,
    WTF::Vector<CableAuthenticationPtr> cable_authentication_data_in,
    bool prf_in,
    WTF::Vector<PRFValuesPtr> prf_inputs_in,
    bool large_blob_read_in,
    std::optional<WTF::Vector<uint8_t>> large_blob_write_in,
    bool get_cred_blob_in,
    RemoteDesktopClientOverridePtr remote_desktop_client_override_in,
    SupplementalPubKeysRequestPtr supplemental_pub_keys_in,
    std::optional<WTF::Vector<PublicKeyCredentialParametersPtr>> payment_browser_bound_key_parameters_in)
    : appid(std::move(appid_in)),
      cable_authentication_data(std::move(cable_authentication_data_in)),
      prf(std::move(prf_in)),
      prf_inputs(std::move(prf_inputs_in)),
      large_blob_read(std::move(large_blob_read_in)),
      large_blob_write(std::move(large_blob_write_in)),
      get_cred_blob(std::move(get_cred_blob_in)),
      remote_desktop_client_override(std::move(remote_desktop_client_override_in)),
      supplemental_pub_keys(std::move(supplemental_pub_keys_in)),
      payment_browser_bound_key_parameters(std::move(payment_browser_bound_key_parameters_in)) {}

AuthenticationExtensionsClientInputs::~AuthenticationExtensionsClientInputs() = default;

void AuthenticationExtensionsClientInputs::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appid"), this->appid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cable_authentication_data"), this->cable_authentication_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<CableAuthenticationPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf"), this->prf,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_inputs"), this->prf_inputs,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PRFValuesPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_read"), this->large_blob_read,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_write"), this->large_blob_write,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "get_cred_blob"), this->get_cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_desktop_client_override"), this->remote_desktop_client_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RemoteDesktopClientOverridePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supplemental_pub_keys"), this->supplemental_pub_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SupplementalPubKeysRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_browser_bound_key_parameters"), this->payment_browser_bound_key_parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<PublicKeyCredentialParametersPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthenticationExtensionsClientInputs::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria()
    : authenticator_attachment(),
      resident_key(),
      user_verification() {}

AuthenticatorSelectionCriteria::AuthenticatorSelectionCriteria(
    AuthenticatorAttachment authenticator_attachment_in,
    ResidentKeyRequirement resident_key_in,
    UserVerificationRequirement user_verification_in)
    : authenticator_attachment(std::move(authenticator_attachment_in)),
      resident_key(std::move(resident_key_in)),
      user_verification(std::move(user_verification_in)) {}

AuthenticatorSelectionCriteria::~AuthenticatorSelectionCriteria() = default;
size_t AuthenticatorSelectionCriteria::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->authenticator_attachment);
  seed = mojo::internal::WTFHash(seed, this->resident_key);
  seed = mojo::internal::WTFHash(seed, this->user_verification);
  return seed;
}

void AuthenticatorSelectionCriteria::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_attachment"), this->authenticator_attachment,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorAttachment>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "resident_key"), this->resident_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ResidentKeyRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_verification"), this->user_verification,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type UserVerificationRequirement>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AuthenticatorSelectionCriteria::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions()
    : relying_party(),
      user(),
      challenge(),
      public_key_parameters(),
      timeout(),
      exclude_credentials(),
      authenticator_selection(),
      hints(),
      attestation(),
      hmac_create_secret(),
      prf_enable(),
      prf_input(),
      protection_policy(),
      enforce_protection_policy(),
      appid_exclude(),
      cred_props(),
      large_blob_enable(),
      is_payment_credential_creation(),
      cred_blob(),
      min_pin_length_requested(false),
      remote_desktop_client_override(),
      supplemental_pub_keys(),
      payment_browser_bound_key_parameters(),
      attestation_formats(),
      is_conditional(false) {}

PublicKeyCredentialCreationOptions::PublicKeyCredentialCreationOptions(
    PublicKeyCredentialRpEntityPtr relying_party_in,
    PublicKeyCredentialUserEntityPtr user_in,
    WTF::Vector<uint8_t> challenge_in,
    WTF::Vector<PublicKeyCredentialParametersPtr> public_key_parameters_in,
    std::optional<::base::TimeDelta> timeout_in,
    WTF::Vector<PublicKeyCredentialDescriptorPtr> exclude_credentials_in,
    AuthenticatorSelectionCriteriaPtr authenticator_selection_in,
    WTF::Vector<Hint> hints_in,
    AttestationConveyancePreference attestation_in,
    bool hmac_create_secret_in,
    bool prf_enable_in,
    PRFValuesPtr prf_input_in,
    ProtectionPolicy protection_policy_in,
    bool enforce_protection_policy_in,
    const WTF::String& appid_exclude_in,
    bool cred_props_in,
    LargeBlobSupport large_blob_enable_in,
    bool is_payment_credential_creation_in,
    std::optional<WTF::Vector<uint8_t>> cred_blob_in,
    bool min_pin_length_requested_in,
    RemoteDesktopClientOverridePtr remote_desktop_client_override_in,
    SupplementalPubKeysRequestPtr supplemental_pub_keys_in,
    std::optional<WTF::Vector<PublicKeyCredentialParametersPtr>> payment_browser_bound_key_parameters_in,
    WTF::Vector<WTF::String> attestation_formats_in,
    bool is_conditional_in)
    : relying_party(std::move(relying_party_in)),
      user(std::move(user_in)),
      challenge(std::move(challenge_in)),
      public_key_parameters(std::move(public_key_parameters_in)),
      timeout(std::move(timeout_in)),
      exclude_credentials(std::move(exclude_credentials_in)),
      authenticator_selection(std::move(authenticator_selection_in)),
      hints(std::move(hints_in)),
      attestation(std::move(attestation_in)),
      hmac_create_secret(std::move(hmac_create_secret_in)),
      prf_enable(std::move(prf_enable_in)),
      prf_input(std::move(prf_input_in)),
      protection_policy(std::move(protection_policy_in)),
      enforce_protection_policy(std::move(enforce_protection_policy_in)),
      appid_exclude(std::move(appid_exclude_in)),
      cred_props(std::move(cred_props_in)),
      large_blob_enable(std::move(large_blob_enable_in)),
      is_payment_credential_creation(std::move(is_payment_credential_creation_in)),
      cred_blob(std::move(cred_blob_in)),
      min_pin_length_requested(std::move(min_pin_length_requested_in)),
      remote_desktop_client_override(std::move(remote_desktop_client_override_in)),
      supplemental_pub_keys(std::move(supplemental_pub_keys_in)),
      payment_browser_bound_key_parameters(std::move(payment_browser_bound_key_parameters_in)),
      attestation_formats(std::move(attestation_formats_in)),
      is_conditional(std::move(is_conditional_in)) {}

PublicKeyCredentialCreationOptions::~PublicKeyCredentialCreationOptions() = default;

void PublicKeyCredentialCreationOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relying_party"), this->relying_party,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialRpEntityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user"), this->user,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialUserEntityPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "challenge"), this->challenge,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "public_key_parameters"), this->public_key_parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PublicKeyCredentialParametersPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "timeout"), this->timeout,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::TimeDelta>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "exclude_credentials"), this->exclude_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type WTF::Vector<PublicKeyCredentialDescriptorPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "authenticator_selection"), this->authenticator_selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AuthenticatorSelectionCriteriaPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hints"), this->hints,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<Hint>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation"), this->attestation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AttestationConveyancePreference>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hmac_create_secret"), this->hmac_create_secret,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_enable"), this->prf_enable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "prf_input"), this->prf_input,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PRFValuesPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protection_policy"), this->protection_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ProtectionPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "enforce_protection_policy"), this->enforce_protection_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "appid_exclude"), this->appid_exclude,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_props"), this->cred_props,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "large_blob_enable"), this->large_blob_enable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type LargeBlobSupport>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_payment_credential_creation"), this->is_payment_credential_creation,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "cred_blob"), this->cred_blob,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "min_pin_length_requested"), this->min_pin_length_requested,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "remote_desktop_client_override"), this->remote_desktop_client_override,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type RemoteDesktopClientOverridePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supplemental_pub_keys"), this->supplemental_pub_keys,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SupplementalPubKeysRequestPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "payment_browser_bound_key_parameters"), this->payment_browser_bound_key_parameters,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<WTF::Vector<PublicKeyCredentialParametersPtr>>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "attestation_formats"), this->attestation_formats,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::String>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_conditional"), this->is_conditional,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialCreationOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor()
    : type(),
      id(),
      transports() {}

PublicKeyCredentialDescriptor::PublicKeyCredentialDescriptor(
    PublicKeyCredentialType type_in,
    WTF::Vector<uint8_t> id_in,
    WTF::Vector<AuthenticatorTransport> transports_in)
    : type(std::move(type_in)),
      id(std::move(id_in)),
      transports(std::move(transports_in)) {}

PublicKeyCredentialDescriptor::~PublicKeyCredentialDescriptor() = default;

void PublicKeyCredentialDescriptor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PublicKeyCredentialType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "id"), this->id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "transports"), this->transports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<AuthenticatorTransport>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialDescriptor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebAuthnDOMExceptionDetails::WebAuthnDOMExceptionDetails()
    : name(),
      message() {}

WebAuthnDOMExceptionDetails::WebAuthnDOMExceptionDetails(
    const WTF::String& name_in,
    const WTF::String& message_in)
    : name(std::move(name_in)),
      message(std::move(message_in)) {}

WebAuthnDOMExceptionDetails::~WebAuthnDOMExceptionDetails() = default;
size_t WebAuthnDOMExceptionDetails::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->message);
  return seed;
}

void WebAuthnDOMExceptionDetails::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "message"), this->message,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebAuthnDOMExceptionDetails::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PublicKeyCredentialReportOptions::PublicKeyCredentialReportOptions()
    : relying_party_id(),
      unknown_credential_id(),
      all_accepted_credentials(),
      current_user_details() {}

PublicKeyCredentialReportOptions::PublicKeyCredentialReportOptions(
    const WTF::String& relying_party_id_in,
    std::optional<WTF::Vector<uint8_t>> unknown_credential_id_in,
    AllAcceptedCredentialsOptionsPtr all_accepted_credentials_in,
    CurrentUserDetailsOptionsPtr current_user_details_in)
    : relying_party_id(std::move(relying_party_id_in)),
      unknown_credential_id(std::move(unknown_credential_id_in)),
      all_accepted_credentials(std::move(all_accepted_credentials_in)),
      current_user_details(std::move(current_user_details_in)) {}

PublicKeyCredentialReportOptions::~PublicKeyCredentialReportOptions() = default;

void PublicKeyCredentialReportOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "relying_party_id"), this->relying_party_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unknown_credential_id"), this->unknown_credential_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_accepted_credentials"), this->all_accepted_credentials,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type AllAcceptedCredentialsOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "current_user_details"), this->current_user_details,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CurrentUserDetailsOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PublicKeyCredentialReportOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
AllAcceptedCredentialsOptions::AllAcceptedCredentialsOptions()
    : user_id(),
      all_accepted_credentials_ids() {}

AllAcceptedCredentialsOptions::AllAcceptedCredentialsOptions(
    WTF::Vector<uint8_t> user_id_in,
    WTF::Vector<WTF::Vector<uint8_t>> all_accepted_credentials_ids_in)
    : user_id(std::move(user_id_in)),
      all_accepted_credentials_ids(std::move(all_accepted_credentials_ids_in)) {}

AllAcceptedCredentialsOptions::~AllAcceptedCredentialsOptions() = default;

void AllAcceptedCredentialsOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_id"), this->user_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "all_accepted_credentials_ids"), this->all_accepted_credentials_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<WTF::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AllAcceptedCredentialsOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CurrentUserDetailsOptions::CurrentUserDetailsOptions()
    : user_id(),
      name(),
      display_name() {}

CurrentUserDetailsOptions::CurrentUserDetailsOptions(
    WTF::Vector<uint8_t> user_id_in,
    const WTF::String& name_in,
    const WTF::String& display_name_in)
    : user_id(std::move(user_id_in)),
      name(std::move(name_in)),
      display_name(std::move(display_name_in)) {}

CurrentUserDetailsOptions::~CurrentUserDetailsOptions() = default;

void CurrentUserDetailsOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_id"), this->user_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "display_name"), this->display_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CurrentUserDetailsOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
WebAuthnClientCapability::WebAuthnClientCapability()
    : name(),
      supported() {}

WebAuthnClientCapability::WebAuthnClientCapability(
    const WTF::String& name_in,
    bool supported_in)
    : name(std::move(name_in)),
      supported(std::move(supported_in)) {}

WebAuthnClientCapability::~WebAuthnClientCapability() = default;
size_t WebAuthnClientCapability::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->name);
  seed = mojo::internal::WTFHash(seed, this->supported);
  return seed;
}

void WebAuthnClientCapability::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const WTF::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "supported"), this->supported,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WebAuthnClientCapability::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char Authenticator::Name_[] = "blink.mojom.Authenticator";

Authenticator::IPCStableHashFunction Authenticator::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::Authenticator>(message.name())) {
    case messages::Authenticator::kMakeCredential: {
      return &Authenticator::MakeCredential_Sym::IPCStableHash;
    }
    case messages::Authenticator::kGetAssertion: {
      return &Authenticator::GetAssertion_Sym::IPCStableHash;
    }
    case messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable: {
      return &Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable_Sym::IPCStableHash;
    }
    case messages::Authenticator::kIsConditionalMediationAvailable: {
      return &Authenticator::IsConditionalMediationAvailable_Sym::IPCStableHash;
    }
    case messages::Authenticator::kReport: {
      return &Authenticator::Report_Sym::IPCStableHash;
    }
    case messages::Authenticator::kGetClientCapabilities: {
      return &Authenticator::GetClientCapabilities_Sym::IPCStableHash;
    }
    case messages::Authenticator::kCancel: {
      return &Authenticator::Cancel_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* Authenticator::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::Authenticator>(message.name())) {
      case messages::Authenticator::kMakeCredential:
            return "Receive blink::mojom::Authenticator::MakeCredential";
      case messages::Authenticator::kGetAssertion:
            return "Receive blink::mojom::Authenticator::GetAssertion";
      case messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable:
            return "Receive blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable";
      case messages::Authenticator::kIsConditionalMediationAvailable:
            return "Receive blink::mojom::Authenticator::IsConditionalMediationAvailable";
      case messages::Authenticator::kReport:
            return "Receive blink::mojom::Authenticator::Report";
      case messages::Authenticator::kGetClientCapabilities:
            return "Receive blink::mojom::Authenticator::GetClientCapabilities";
      case messages::Authenticator::kCancel:
            return "Receive blink::mojom::Authenticator::Cancel";
    }
  } else {
    switch (static_cast<messages::Authenticator>(message.name())) {
      case messages::Authenticator::kMakeCredential:
            return "Receive reply blink::mojom::Authenticator::MakeCredential";
      case messages::Authenticator::kGetAssertion:
            return "Receive reply blink::mojom::Authenticator::GetAssertion";
      case messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable:
            return "Receive reply blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable";
      case messages::Authenticator::kIsConditionalMediationAvailable:
            return "Receive reply blink::mojom::Authenticator::IsConditionalMediationAvailable";
      case messages::Authenticator::kReport:
            return "Receive reply blink::mojom::Authenticator::Report";
      case messages::Authenticator::kGetClientCapabilities:
            return "Receive reply blink::mojom::Authenticator::GetClientCapabilities";
      case messages::Authenticator::kCancel:
            return "Receive reply blink::mojom::Authenticator::Cancel";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t Authenticator::MakeCredential_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::MakeCredential");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Authenticator::GetAssertion_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::GetAssertion");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Authenticator::IsConditionalMediationAvailable_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::IsConditionalMediationAvailable");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Authenticator::Report_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::Report");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Authenticator::GetClientCapabilities_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::GetClientCapabilities");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t Authenticator::Cancel_Sym::IPCStableHash() {
  // This method's address is used for indetifiying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique accross different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  constexpr uint32_t kHash = base::MD5Hash32Constexpr(
          "(Impl)blink::mojom::Authenticator::Cancel");
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class Authenticator_MakeCredential_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_MakeCredential_ForwardToCallback(
      Authenticator::MakeCredentialCallback callback
      ) : callback_(std::move(callback)) {
  }

  Authenticator_MakeCredential_ForwardToCallback(const Authenticator_MakeCredential_ForwardToCallback&) = delete;
  Authenticator_MakeCredential_ForwardToCallback& operator=(const Authenticator_MakeCredential_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::MakeCredentialCallback callback_;
};

class Authenticator_GetAssertion_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_GetAssertion_ForwardToCallback(
      Authenticator::GetAssertionCallback callback
      ) : callback_(std::move(callback)) {
  }

  Authenticator_GetAssertion_ForwardToCallback(const Authenticator_GetAssertion_ForwardToCallback&) = delete;
  Authenticator_GetAssertion_ForwardToCallback& operator=(const Authenticator_GetAssertion_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::GetAssertionCallback callback_;
};

class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(
      Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback&) = delete;
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback& operator=(const Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback_;
};

class Authenticator_IsConditionalMediationAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_IsConditionalMediationAvailable_ForwardToCallback(
      Authenticator::IsConditionalMediationAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  Authenticator_IsConditionalMediationAvailable_ForwardToCallback(const Authenticator_IsConditionalMediationAvailable_ForwardToCallback&) = delete;
  Authenticator_IsConditionalMediationAvailable_ForwardToCallback& operator=(const Authenticator_IsConditionalMediationAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::IsConditionalMediationAvailableCallback callback_;
};

class Authenticator_Report_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_Report_ForwardToCallback(
      Authenticator::ReportCallback callback
      ) : callback_(std::move(callback)) {
  }

  Authenticator_Report_ForwardToCallback(const Authenticator_Report_ForwardToCallback&) = delete;
  Authenticator_Report_ForwardToCallback& operator=(const Authenticator_Report_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::ReportCallback callback_;
};

class Authenticator_GetClientCapabilities_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Authenticator_GetClientCapabilities_ForwardToCallback(
      Authenticator::GetClientCapabilitiesCallback callback
      ) : callback_(std::move(callback)) {
  }

  Authenticator_GetClientCapabilities_ForwardToCallback(const Authenticator_GetClientCapabilities_ForwardToCallback&) = delete;
  Authenticator_GetClientCapabilities_ForwardToCallback& operator=(const Authenticator_GetClientCapabilities_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  Authenticator::GetClientCapabilitiesCallback callback_;
};

AuthenticatorProxy::AuthenticatorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthenticatorProxy::MakeCredential(
    PublicKeyCredentialCreationOptionsPtr in_options, MakeCredentialCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Authenticator::MakeCredential", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PublicKeyCredentialCreationOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kMakeCredential), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_MakeCredential_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialCreationOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.MakeCredential request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("MakeCredential");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_MakeCredential_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AuthenticatorProxy::GetAssertion(
    PublicKeyCredentialRequestOptionsPtr in_options, GetAssertionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Authenticator::GetAssertion", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PublicKeyCredentialRequestOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kGetAssertion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_GetAssertion_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialRequestOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.GetAssertion request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetAssertion");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_GetAssertion_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AuthenticatorProxy::IsUserVerifyingPlatformAuthenticatorAvailable(
    IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsUserVerifyingPlatformAuthenticatorAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AuthenticatorProxy::IsConditionalMediationAvailable(
    IsConditionalMediationAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Authenticator::IsConditionalMediationAvailable");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kIsConditionalMediationAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_IsConditionalMediationAvailable_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsConditionalMediationAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_IsConditionalMediationAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AuthenticatorProxy::Report(
    PublicKeyCredentialReportOptionsPtr in_options, ReportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::Authenticator::Report", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PublicKeyCredentialReportOptionsPtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_Report_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::PublicKeyCredentialReportOptionsDataView>(
      in_options, options_fragment);
  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null options in Authenticator.Report request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("Report");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_Report_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AuthenticatorProxy::GetClientCapabilities(
    GetClientCapabilitiesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Authenticator::GetClientCapabilities");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kGetClientCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_GetClientCapabilities_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetClientCapabilities");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Authenticator_GetClientCapabilities_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void AuthenticatorProxy::Cancel(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::Authenticator::Cancel");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kCancel), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_Cancel_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("Cancel");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class Authenticator_MakeCredential_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Authenticator::MakeCredentialCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Authenticator_MakeCredential_ProxyToResponder> proxy(
        new Authenticator_MakeCredential_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Authenticator_MakeCredential_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_MakeCredential_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Authenticator_MakeCredential_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::MakeCredentialCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, MakeCredentialAuthenticatorResponsePtr in_credential, WebAuthnDOMExceptionDetailsPtr in_dom_exception_details);
};

bool Authenticator_MakeCredential_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Authenticator_MakeCredential_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_MakeCredential_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Authenticator.0
  bool success = true;
  AuthenticatorStatus p_status{};
  MakeCredentialAuthenticatorResponsePtr p_credential{};
  WebAuthnDOMExceptionDetailsPtr p_dom_exception_details{};
  Authenticator_MakeCredential_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (success && !input_data_view.ReadDomExceptionDetails(&p_dom_exception_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential), 
std::move(p_dom_exception_details));
  return true;
}

void Authenticator_MakeCredential_ProxyToResponder::Run(
    AuthenticatorStatus in_status, MakeCredentialAuthenticatorResponsePtr in_credential, WebAuthnDOMExceptionDetailsPtr in_dom_exception_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Authenticator::MakeCredential", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type AuthenticatorStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type MakeCredentialAuthenticatorResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_exception_details"), in_dom_exception_details,
                        "<value of type WebAuthnDOMExceptionDetailsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kMakeCredential), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_MakeCredential_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::MakeCredentialAuthenticatorResponseDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->dom_exception_details)::BaseType> dom_exception_details_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
      in_dom_exception_details, dom_exception_details_fragment);
  params->dom_exception_details.Set(
      dom_exception_details_fragment.is_null() ? nullptr : dom_exception_details_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("MakeCredential");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_GetAssertion_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Authenticator::GetAssertionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Authenticator_GetAssertion_ProxyToResponder> proxy(
        new Authenticator_GetAssertion_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Authenticator_GetAssertion_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_GetAssertion_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Authenticator_GetAssertion_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::GetAssertionCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, GetAssertionAuthenticatorResponsePtr in_credential, WebAuthnDOMExceptionDetailsPtr in_dom_exception_details);
};

bool Authenticator_GetAssertion_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Authenticator_GetAssertion_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_GetAssertion_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Authenticator.1
  bool success = true;
  AuthenticatorStatus p_status{};
  GetAssertionAuthenticatorResponsePtr p_credential{};
  WebAuthnDOMExceptionDetailsPtr p_dom_exception_details{};
  Authenticator_GetAssertion_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadCredential(&p_credential))
    success = false;
  if (success && !input_data_view.ReadDomExceptionDetails(&p_dom_exception_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_credential), 
std::move(p_dom_exception_details));
  return true;
}

void Authenticator_GetAssertion_ProxyToResponder::Run(
    AuthenticatorStatus in_status, GetAssertionAuthenticatorResponsePtr in_credential, WebAuthnDOMExceptionDetailsPtr in_dom_exception_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Authenticator::GetAssertion", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type AuthenticatorStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("credential"), in_credential,
                        "<value of type GetAssertionAuthenticatorResponsePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_exception_details"), in_dom_exception_details,
                        "<value of type WebAuthnDOMExceptionDetailsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kGetAssertion), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_GetAssertion_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->credential)::BaseType> credential_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::GetAssertionAuthenticatorResponseDataView>(
      in_credential, credential_fragment);
  params->credential.Set(
      credential_fragment.is_null() ? nullptr : credential_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->dom_exception_details)::BaseType> dom_exception_details_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
      in_dom_exception_details, dom_exception_details_fragment);
  params->dom_exception_details.Set(
      dom_exception_details_fragment.is_null() ? nullptr : dom_exception_details_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetAssertion");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder> proxy(
        new Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_available);
};

bool Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Authenticator.2
  bool success = true;
  bool p_available{};
  Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_available = input_data_view.available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_available));
  return true;
}

void Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::Run(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Authenticator::IsUserVerifyingPlatformAuthenticatorAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsUserVerifyingPlatformAuthenticatorAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_IsConditionalMediationAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Authenticator::IsConditionalMediationAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Authenticator_IsConditionalMediationAvailable_ProxyToResponder> proxy(
        new Authenticator_IsConditionalMediationAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Authenticator_IsConditionalMediationAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_IsConditionalMediationAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Authenticator_IsConditionalMediationAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::IsConditionalMediationAvailableCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_available);
};

bool Authenticator_IsConditionalMediationAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Authenticator.3
  bool success = true;
  bool p_available{};
  Authenticator_IsConditionalMediationAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_available = input_data_view.available();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_available));
  return true;
}

void Authenticator_IsConditionalMediationAvailable_ProxyToResponder::Run(
    bool in_available) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Authenticator::IsConditionalMediationAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("available"), in_available,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kIsConditionalMediationAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();
  params->available = in_available;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("IsConditionalMediationAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_Report_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Authenticator::ReportCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Authenticator_Report_ProxyToResponder> proxy(
        new Authenticator_Report_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Authenticator_Report_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_Report_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Authenticator_Report_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::ReportCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      AuthenticatorStatus in_status, WebAuthnDOMExceptionDetailsPtr in_dom_exception_details);
};

bool Authenticator_Report_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Authenticator_Report_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_Report_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Authenticator.4
  bool success = true;
  AuthenticatorStatus p_status{};
  WebAuthnDOMExceptionDetailsPtr p_dom_exception_details{};
  Authenticator_Report_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadDomExceptionDetails(&p_dom_exception_details))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_dom_exception_details));
  return true;
}

void Authenticator_Report_ProxyToResponder::Run(
    AuthenticatorStatus in_status, WebAuthnDOMExceptionDetailsPtr in_dom_exception_details) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Authenticator::Report", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type AuthenticatorStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("dom_exception_details"), in_dom_exception_details,
                        "<value of type WebAuthnDOMExceptionDetailsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_Report_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::Serialize<::blink::mojom::AuthenticatorStatus>(
      in_status, &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->dom_exception_details)::BaseType> dom_exception_details_fragment(
          params.message());
  mojo::internal::Serialize<::blink::mojom::WebAuthnDOMExceptionDetailsDataView>(
      in_dom_exception_details, dom_exception_details_fragment);
  params->dom_exception_details.Set(
      dom_exception_details_fragment.is_null() ? nullptr : dom_exception_details_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("Report");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Authenticator_GetClientCapabilities_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static Authenticator::GetClientCapabilitiesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<Authenticator_GetClientCapabilities_ProxyToResponder> proxy(
        new Authenticator_GetClientCapabilities_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&Authenticator_GetClientCapabilities_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Authenticator_GetClientCapabilities_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  Authenticator_GetClientCapabilities_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Authenticator::GetClientCapabilitiesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      WTF::Vector<WebAuthnClientCapabilityPtr> in_capabilities);
};

bool Authenticator_GetClientCapabilities_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::Authenticator_GetClientCapabilities_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Authenticator_GetClientCapabilities_ResponseParams_Data*>(
              message->mutable_payload());
  
  
  // Validation for Authenticator.5
  bool success = true;
  WTF::Vector<WebAuthnClientCapabilityPtr> p_capabilities{};
  Authenticator_GetClientCapabilities_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadCapabilities(&p_capabilities))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Authenticator::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_capabilities));
  return true;
}

void Authenticator_GetClientCapabilities_ProxyToResponder::Run(
    WTF::Vector<WebAuthnClientCapabilityPtr> in_capabilities) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::Authenticator::GetClientCapabilities", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("capabilities"), in_capabilities,
                        "<value of type WTF::Vector<WebAuthnClientCapabilityPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::Authenticator::kGetClientCapabilities), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::Authenticator_GetClientCapabilities_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->capabilities)::BaseType>
      capabilities_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& capabilities_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::WebAuthnClientCapabilityDataView>>(
      in_capabilities, capabilities_fragment, &capabilities_validate_params);
  params->capabilities.Set(
      capabilities_fragment.is_null() ? nullptr : capabilities_fragment.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->capabilities.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null capabilities in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Authenticator::Name_);
  message.set_method_name("GetClientCapabilities");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool AuthenticatorStubDispatch::Accept(
    Authenticator* impl,
    mojo::Message* message) {
  switch (static_cast<messages::Authenticator>(message->header()->name)) {
    case messages::Authenticator::kMakeCredential: {
      break;
    }
    case messages::Authenticator::kGetAssertion: {
      break;
    }
    case messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable: {
      break;
    }
    case messages::Authenticator::kIsConditionalMediationAvailable: {
      break;
    }
    case messages::Authenticator::kReport: {
      break;
    }
    case messages::Authenticator::kGetClientCapabilities: {
      break;
    }
    case messages::Authenticator::kCancel: {
      DCHECK(message->is_serialized());
      internal::Authenticator_Cancel_Params_Data* params =
          reinterpret_cast<internal::Authenticator_Cancel_Params_Data*>(
              message->mutable_payload());
      
      
      // Validation for Authenticator.6
      bool success = true;
      Authenticator_Cancel_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Cancel(        );
      return true;
    }
  }
  return false;
}

// static
bool AuthenticatorStubDispatch::AcceptWithResponder(
    Authenticator* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::Authenticator>(message->header()->name)) {
    case messages::Authenticator::kMakeCredential: {
      internal::Authenticator_MakeCredential_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_MakeCredential_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Authenticator.0
      bool success = true;
      PublicKeyCredentialCreationOptionsPtr p_options{};
      Authenticator_MakeCredential_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 0, false);
        return false;
      }
      Authenticator::MakeCredentialCallback callback =
          Authenticator_MakeCredential_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MakeCredential(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::Authenticator::kGetAssertion: {
      internal::Authenticator_GetAssertion_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_GetAssertion_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Authenticator.1
      bool success = true;
      PublicKeyCredentialRequestOptionsPtr p_options{};
      Authenticator_GetAssertion_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 1, false);
        return false;
      }
      Authenticator::GetAssertionCallback callback =
          Authenticator_GetAssertion_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetAssertion(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::Authenticator::kIsUserVerifyingPlatformAuthenticatorAvailable: {
      internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Authenticator.2
      bool success = true;
      Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 2, false);
        return false;
      }
      Authenticator::IsUserVerifyingPlatformAuthenticatorAvailableCallback callback =
          Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsUserVerifyingPlatformAuthenticatorAvailable(std::move(callback));
      return true;
    }
    case messages::Authenticator::kIsConditionalMediationAvailable: {
      internal::Authenticator_IsConditionalMediationAvailable_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_IsConditionalMediationAvailable_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Authenticator.3
      bool success = true;
      Authenticator_IsConditionalMediationAvailable_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 3, false);
        return false;
      }
      Authenticator::IsConditionalMediationAvailableCallback callback =
          Authenticator_IsConditionalMediationAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsConditionalMediationAvailable(std::move(callback));
      return true;
    }
    case messages::Authenticator::kReport: {
      internal::Authenticator_Report_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_Report_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Authenticator.4
      bool success = true;
      PublicKeyCredentialReportOptionsPtr p_options{};
      Authenticator_Report_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 4, false);
        return false;
      }
      Authenticator::ReportCallback callback =
          Authenticator_Report_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Report(        
        std::move(p_options), std::move(callback));
      return true;
    }
    case messages::Authenticator::kGetClientCapabilities: {
      internal::Authenticator_GetClientCapabilities_Params_Data* params =
          reinterpret_cast<
              internal::Authenticator_GetClientCapabilities_Params_Data*>(
                  message->mutable_payload());
      
      
      // Validation for Authenticator.5
      bool success = true;
      Authenticator_GetClientCapabilities_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Authenticator::Name_, 5, false);
        return false;
      }
      Authenticator::GetClientCapabilitiesCallback callback =
          Authenticator_GetClientCapabilities_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetClientCapabilities(std::move(callback));
      return true;
    }
    case messages::Authenticator::kCancel: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kAuthenticatorValidationInfo[] = {
    { &internal::Authenticator_MakeCredential_Params_Data::Validate,
     &internal::Authenticator_MakeCredential_ResponseParams_Data::Validate},
    { &internal::Authenticator_GetAssertion_Params_Data::Validate,
     &internal::Authenticator_GetAssertion_ResponseParams_Data::Validate},
    { &internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_Params_Data::Validate,
     &internal::Authenticator_IsUserVerifyingPlatformAuthenticatorAvailable_ResponseParams_Data::Validate},
    { &internal::Authenticator_IsConditionalMediationAvailable_Params_Data::Validate,
     &internal::Authenticator_IsConditionalMediationAvailable_ResponseParams_Data::Validate},
    { &internal::Authenticator_Report_Params_Data::Validate,
     &internal::Authenticator_Report_ResponseParams_Data::Validate},
    { &internal::Authenticator_GetClientCapabilities_Params_Data::Validate,
     &internal::Authenticator_GetClientCapabilities_ResponseParams_Data::Validate},
    { &internal::Authenticator_Cancel_Params_Data::Validate,
     nullptr /* no response */},
};

bool AuthenticatorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Authenticator::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kAuthenticatorValidationInfo);
}

bool AuthenticatorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::Authenticator::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kAuthenticatorValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::CommonCredentialInfo::DataView, ::blink::mojom::blink::CommonCredentialInfoPtr>::Read(
    ::blink::mojom::blink::CommonCredentialInfo::DataView input,
    ::blink::mojom::blink::CommonCredentialInfoPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CommonCredentialInfoPtr result(::blink::mojom::blink::CommonCredentialInfo::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadRawId(&result->raw_id))
        success = false;
      if (success && !input.ReadClientDataJson(&result->client_data_json))
        success = false;
      if (success && !input.ReadAuthenticatorData(&result->authenticator_data))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SupplementalPubKeysResponse::DataView, ::blink::mojom::blink::SupplementalPubKeysResponsePtr>::Read(
    ::blink::mojom::blink::SupplementalPubKeysResponse::DataView input,
    ::blink::mojom::blink::SupplementalPubKeysResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::SupplementalPubKeysResponsePtr result(::blink::mojom::blink::SupplementalPubKeysResponse::New());
  
      if (success && !input.ReadSignatures(&result->signatures))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AuthenticationExtensionsPaymentResponse::DataView, ::blink::mojom::blink::AuthenticationExtensionsPaymentResponsePtr>::Read(
    ::blink::mojom::blink::AuthenticationExtensionsPaymentResponse::DataView input,
    ::blink::mojom::blink::AuthenticationExtensionsPaymentResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::AuthenticationExtensionsPaymentResponsePtr result(::blink::mojom::blink::AuthenticationExtensionsPaymentResponse::New());
  
      if (success && !input.ReadBrowserBoundSignature(&result->browser_bound_signature))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MakeCredentialAuthenticatorResponse::DataView, ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr>::Read(
    ::blink::mojom::blink::MakeCredentialAuthenticatorResponse::DataView input,
    ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::MakeCredentialAuthenticatorResponsePtr result(::blink::mojom::blink::MakeCredentialAuthenticatorResponse::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadAuthenticatorAttachment(&result->authenticator_attachment))
        success = false;
      if (success && !input.ReadAttestationObject(&result->attestation_object))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
      if (success)
        result->echo_hmac_create_secret = input.echo_hmac_create_secret();
      if (success)
        result->hmac_create_secret = input.hmac_create_secret();
      if (success)
        result->echo_prf = input.echo_prf();
      if (success)
        result->prf = input.prf();
      if (success && !input.ReadPrfResults(&result->prf_results))
        success = false;
      if (success)
        result->echo_cred_blob = input.echo_cred_blob();
      if (success)
        result->cred_blob = input.cred_blob();
      if (success && !input.ReadPublicKeyDer(&result->public_key_der))
        success = false;
      if (success)
        result->public_key_algo = input.public_key_algo();
      if (success)
        result->echo_cred_props = input.echo_cred_props();
      if (success)
        result->has_cred_props_rk = input.has_cred_props_rk();
      if (success)
        result->cred_props_rk = input.cred_props_rk();
      if (success)
        result->echo_large_blob = input.echo_large_blob();
      if (success)
        result->supports_large_blob = input.supports_large_blob();
      if (success && !input.ReadSupplementalPubKeys(&result->supplemental_pub_keys))
        success = false;
      if (success && !input.ReadPayment(&result->payment))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::GetAssertionAuthenticatorResponse::DataView, ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr>::Read(
    ::blink::mojom::blink::GetAssertionAuthenticatorResponse::DataView input,
    ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::GetAssertionAuthenticatorResponsePtr result(::blink::mojom::blink::GetAssertionAuthenticatorResponse::New());
  
      if (success && !input.ReadInfo(&result->info))
        success = false;
      if (success && !input.ReadAuthenticatorAttachment(&result->authenticator_attachment))
        success = false;
      if (success && !input.ReadSignature(&result->signature))
        success = false;
      if (success && !input.ReadUserHandle(&result->user_handle))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AuthenticationExtensionsClientOutputs::DataView, ::blink::mojom::blink::AuthenticationExtensionsClientOutputsPtr>::Read(
    ::blink::mojom::blink::AuthenticationExtensionsClientOutputs::DataView input,
    ::blink::mojom::blink::AuthenticationExtensionsClientOutputsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AuthenticationExtensionsClientOutputsPtr result(::blink::mojom::blink::AuthenticationExtensionsClientOutputs::New());
  
      if (success)
        result->echo_appid_extension = input.echo_appid_extension();
      if (success)
        result->appid_extension = input.appid_extension();
      if (success)
        result->echo_prf = input.echo_prf();
      if (success && !input.ReadPrfResults(&result->prf_results))
        success = false;
      if (success)
        result->prf_not_evaluated = input.prf_not_evaluated();
      if (success)
        result->echo_large_blob = input.echo_large_blob();
      if (success && !input.ReadLargeBlob(&result->large_blob))
        success = false;
      if (success)
        result->echo_large_blob_written = input.echo_large_blob_written();
      if (success)
        result->large_blob_written = input.large_blob_written();
      if (success && !input.ReadGetCredBlob(&result->get_cred_blob))
        success = false;
      if (success && !input.ReadSupplementalPubKeys(&result->supplemental_pub_keys))
        success = false;
      if (success && !input.ReadPayment(&result->payment))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialRpEntity::DataView, ::blink::mojom::blink::PublicKeyCredentialRpEntityPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialRpEntity::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialRpEntityPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialRpEntityPtr result(::blink::mojom::blink::PublicKeyCredentialRpEntity::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialUserEntity::DataView, ::blink::mojom::blink::PublicKeyCredentialUserEntityPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialUserEntity::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialUserEntityPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialUserEntityPtr result(::blink::mojom::blink::PublicKeyCredentialUserEntity::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialParameters::DataView, ::blink::mojom::blink::PublicKeyCredentialParametersPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialParameters::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialParametersPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialParametersPtr result(::blink::mojom::blink::PublicKeyCredentialParameters::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success)
        result->algorithm_identifier = input.algorithm_identifier();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CableAuthentication::DataView, ::blink::mojom::blink::CableAuthenticationPtr>::Read(
    ::blink::mojom::blink::CableAuthentication::DataView input,
    ::blink::mojom::blink::CableAuthenticationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CableAuthenticationPtr result(::blink::mojom::blink::CableAuthentication::New());
  
      if (success)
        result->version = input.version();
      if (success && !input.ReadClientEid(&result->client_eid))
        success = false;
      if (success && !input.ReadAuthenticatorEid(&result->authenticator_eid))
        success = false;
      if (success && !input.ReadSessionPreKey(&result->session_pre_key))
        success = false;
      if (success && !input.ReadServerLinkData(&result->server_link_data))
        success = false;
      if (success && !input.ReadExperiments(&result->experiments))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PRFValues::DataView, ::blink::mojom::blink::PRFValuesPtr>::Read(
    ::blink::mojom::blink::PRFValues::DataView input,
    ::blink::mojom::blink::PRFValuesPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PRFValuesPtr result(::blink::mojom::blink::PRFValues::New());
  
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadFirst(&result->first))
        success = false;
      if (success && !input.ReadSecond(&result->second))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PaymentOptions::DataView, ::blink::mojom::blink::PaymentOptionsPtr>::Read(
    ::blink::mojom::blink::PaymentOptions::DataView input,
    ::blink::mojom::blink::PaymentOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PaymentOptionsPtr result(::blink::mojom::blink::PaymentOptions::New());
  
      if (success && !input.ReadTotal(&result->total))
        success = false;
      if (success && !input.ReadInstrument(&result->instrument))
        success = false;
      if (success && !input.ReadPayeeName(&result->payee_name))
        success = false;
      if (success && !input.ReadPayeeOrigin(&result->payee_origin))
        success = false;
      if (success && !input.ReadBrowserBoundPublicKey(&result->browser_bound_public_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PaymentCredentialInstrument::DataView, ::blink::mojom::blink::PaymentCredentialInstrumentPtr>::Read(
    ::blink::mojom::blink::PaymentCredentialInstrument::DataView input,
    ::blink::mojom::blink::PaymentCredentialInstrumentPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PaymentCredentialInstrumentPtr result(::blink::mojom::blink::PaymentCredentialInstrument::New());
  
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
      if (success && !input.ReadIcon(&result->icon))
        success = false;
      if (success)
        result->iconMustBeShown = input.iconMustBeShown();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::RemoteDesktopClientOverride::DataView, ::blink::mojom::blink::RemoteDesktopClientOverridePtr>::Read(
    ::blink::mojom::blink::RemoteDesktopClientOverride::DataView input,
    ::blink::mojom::blink::RemoteDesktopClientOverridePtr* output) {
  bool success = true;
  ::blink::mojom::blink::RemoteDesktopClientOverridePtr result(::blink::mojom::blink::RemoteDesktopClientOverride::New());
  
      if (success && !input.ReadOrigin(&result->origin))
        success = false;
      if (success)
        result->same_origin_with_ancestors = input.same_origin_with_ancestors();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SupplementalPubKeysRequest::DataView, ::blink::mojom::blink::SupplementalPubKeysRequestPtr>::Read(
    ::blink::mojom::blink::SupplementalPubKeysRequest::DataView input,
    ::blink::mojom::blink::SupplementalPubKeysRequestPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SupplementalPubKeysRequestPtr result(::blink::mojom::blink::SupplementalPubKeysRequest::New());
  
      if (success)
        result->device_scope_requested = input.device_scope_requested();
      if (success)
        result->provider_scope_requested = input.provider_scope_requested();
      if (success && !input.ReadAttestation(&result->attestation))
        success = false;
      if (success && !input.ReadAttestationFormats(&result->attestation_formats))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialRequestOptions::DataView, ::blink::mojom::blink::PublicKeyCredentialRequestOptionsPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialRequestOptions::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialRequestOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialRequestOptionsPtr result(::blink::mojom::blink::PublicKeyCredentialRequestOptions::New());
  
      if (success)
        result->is_conditional = input.is_conditional();
      if (success)
        result->requested_credential_type_flags = input.requested_credential_type_flags();
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadChallengeUrl(&result->challenge_url))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadRelyingPartyId(&result->relying_party_id))
        success = false;
      if (success && !input.ReadAllowCredentials(&result->allow_credentials))
        success = false;
      if (success && !input.ReadHints(&result->hints))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
      if (success && !input.ReadExtensions(&result->extensions))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AuthenticationExtensionsClientInputs::DataView, ::blink::mojom::blink::AuthenticationExtensionsClientInputsPtr>::Read(
    ::blink::mojom::blink::AuthenticationExtensionsClientInputs::DataView input,
    ::blink::mojom::blink::AuthenticationExtensionsClientInputsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AuthenticationExtensionsClientInputsPtr result(::blink::mojom::blink::AuthenticationExtensionsClientInputs::New());
  
      if (success && !input.ReadAppid(&result->appid))
        success = false;
      if (success && !input.ReadCableAuthenticationData(&result->cable_authentication_data))
        success = false;
      if (success)
        result->prf = input.prf();
      if (success && !input.ReadPrfInputs(&result->prf_inputs))
        success = false;
      if (success)
        result->large_blob_read = input.large_blob_read();
      if (success && !input.ReadLargeBlobWrite(&result->large_blob_write))
        success = false;
      if (success)
        result->get_cred_blob = input.get_cred_blob();
      if (success && !input.ReadRemoteDesktopClientOverride(&result->remote_desktop_client_override))
        success = false;
      if (success && !input.ReadSupplementalPubKeys(&result->supplemental_pub_keys))
        success = false;
      if (success && !input.ReadPaymentBrowserBoundKeyParameters(&result->payment_browser_bound_key_parameters))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AuthenticatorSelectionCriteria::DataView, ::blink::mojom::blink::AuthenticatorSelectionCriteriaPtr>::Read(
    ::blink::mojom::blink::AuthenticatorSelectionCriteria::DataView input,
    ::blink::mojom::blink::AuthenticatorSelectionCriteriaPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AuthenticatorSelectionCriteriaPtr result(::blink::mojom::blink::AuthenticatorSelectionCriteria::New());
  
      if (success && !input.ReadAuthenticatorAttachment(&result->authenticator_attachment))
        success = false;
      if (success && !input.ReadResidentKey(&result->resident_key))
        success = false;
      if (success && !input.ReadUserVerification(&result->user_verification))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialCreationOptions::DataView, ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialCreationOptions::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialCreationOptionsPtr result(::blink::mojom::blink::PublicKeyCredentialCreationOptions::New());
  
      if (success && !input.ReadRelyingParty(&result->relying_party))
        success = false;
      if (success && !input.ReadUser(&result->user))
        success = false;
      if (success && !input.ReadChallenge(&result->challenge))
        success = false;
      if (success && !input.ReadPublicKeyParameters(&result->public_key_parameters))
        success = false;
      if (success && !input.ReadTimeout(&result->timeout))
        success = false;
      if (success && !input.ReadExcludeCredentials(&result->exclude_credentials))
        success = false;
      if (success && !input.ReadAuthenticatorSelection(&result->authenticator_selection))
        success = false;
      if (success && !input.ReadHints(&result->hints))
        success = false;
      if (success && !input.ReadAttestation(&result->attestation))
        success = false;
      if (success)
        result->hmac_create_secret = input.hmac_create_secret();
      if (success)
        result->prf_enable = input.prf_enable();
      if (success && !input.ReadPrfInput(&result->prf_input))
        success = false;
      if (success && !input.ReadProtectionPolicy(&result->protection_policy))
        success = false;
      if (success)
        result->enforce_protection_policy = input.enforce_protection_policy();
      if (success && !input.ReadAppidExclude(&result->appid_exclude))
        success = false;
      if (success)
        result->cred_props = input.cred_props();
      if (success && !input.ReadLargeBlobEnable(&result->large_blob_enable))
        success = false;
      if (success)
        result->is_payment_credential_creation = input.is_payment_credential_creation();
      if (success && !input.ReadCredBlob(&result->cred_blob))
        success = false;
      if (success)
        result->min_pin_length_requested = input.min_pin_length_requested();
      if (success && !input.ReadRemoteDesktopClientOverride(&result->remote_desktop_client_override))
        success = false;
      if (success && !input.ReadSupplementalPubKeys(&result->supplemental_pub_keys))
        success = false;
      if (success && !input.ReadPaymentBrowserBoundKeyParameters(&result->payment_browser_bound_key_parameters))
        success = false;
      if (success && !input.ReadAttestationFormats(&result->attestation_formats))
        success = false;
      if (success)
        result->is_conditional = input.is_conditional();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialDescriptor::DataView, ::blink::mojom::blink::PublicKeyCredentialDescriptorPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialDescriptor::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialDescriptorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialDescriptorPtr result(::blink::mojom::blink::PublicKeyCredentialDescriptor::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadId(&result->id))
        success = false;
      if (success && !input.ReadTransports(&result->transports))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebAuthnDOMExceptionDetails::DataView, ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr>::Read(
    ::blink::mojom::blink::WebAuthnDOMExceptionDetails::DataView input,
    ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebAuthnDOMExceptionDetailsPtr result(::blink::mojom::blink::WebAuthnDOMExceptionDetails::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PublicKeyCredentialReportOptions::DataView, ::blink::mojom::blink::PublicKeyCredentialReportOptionsPtr>::Read(
    ::blink::mojom::blink::PublicKeyCredentialReportOptions::DataView input,
    ::blink::mojom::blink::PublicKeyCredentialReportOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PublicKeyCredentialReportOptionsPtr result(::blink::mojom::blink::PublicKeyCredentialReportOptions::New());
  
      if (success && !input.ReadRelyingPartyId(&result->relying_party_id))
        success = false;
      if (success && !input.ReadUnknownCredentialId(&result->unknown_credential_id))
        success = false;
      if (success && !input.ReadAllAcceptedCredentials(&result->all_accepted_credentials))
        success = false;
      if (success && !input.ReadCurrentUserDetails(&result->current_user_details))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::AllAcceptedCredentialsOptions::DataView, ::blink::mojom::blink::AllAcceptedCredentialsOptionsPtr>::Read(
    ::blink::mojom::blink::AllAcceptedCredentialsOptions::DataView input,
    ::blink::mojom::blink::AllAcceptedCredentialsOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::AllAcceptedCredentialsOptionsPtr result(::blink::mojom::blink::AllAcceptedCredentialsOptions::New());
  
      if (success && !input.ReadUserId(&result->user_id))
        success = false;
      if (success && !input.ReadAllAcceptedCredentialsIds(&result->all_accepted_credentials_ids))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CurrentUserDetailsOptions::DataView, ::blink::mojom::blink::CurrentUserDetailsOptionsPtr>::Read(
    ::blink::mojom::blink::CurrentUserDetailsOptions::DataView input,
    ::blink::mojom::blink::CurrentUserDetailsOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CurrentUserDetailsOptionsPtr result(::blink::mojom::blink::CurrentUserDetailsOptions::New());
  
      if (success && !input.ReadUserId(&result->user_id))
        success = false;
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadDisplayName(&result->display_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::WebAuthnClientCapability::DataView, ::blink::mojom::blink::WebAuthnClientCapabilityPtr>::Read(
    ::blink::mojom::blink::WebAuthnClientCapability::DataView input,
    ::blink::mojom::blink::WebAuthnClientCapabilityPtr* output) {
  bool success = true;
  ::blink::mojom::blink::WebAuthnClientCapabilityPtr result(::blink::mojom::blink::WebAuthnClientCapability::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success)
        result->supported = input.supported();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void AuthenticatorInterceptorForTesting::MakeCredential(PublicKeyCredentialCreationOptionsPtr options, MakeCredentialCallback callback) {
  GetForwardingInterface()->MakeCredential(
    std::move(options)
    , std::move(callback));
}
void AuthenticatorInterceptorForTesting::GetAssertion(PublicKeyCredentialRequestOptionsPtr options, GetAssertionCallback callback) {
  GetForwardingInterface()->GetAssertion(
    std::move(options)
    , std::move(callback));
}
void AuthenticatorInterceptorForTesting::IsUserVerifyingPlatformAuthenticatorAvailable(IsUserVerifyingPlatformAuthenticatorAvailableCallback callback) {
  GetForwardingInterface()->IsUserVerifyingPlatformAuthenticatorAvailable(std::move(callback));
}
void AuthenticatorInterceptorForTesting::IsConditionalMediationAvailable(IsConditionalMediationAvailableCallback callback) {
  GetForwardingInterface()->IsConditionalMediationAvailable(std::move(callback));
}
void AuthenticatorInterceptorForTesting::Report(PublicKeyCredentialReportOptionsPtr options, ReportCallback callback) {
  GetForwardingInterface()->Report(
    std::move(options)
    , std::move(callback));
}
void AuthenticatorInterceptorForTesting::GetClientCapabilities(GetClientCapabilitiesCallback callback) {
  GetForwardingInterface()->GetClientCapabilities(std::move(callback));
}
void AuthenticatorInterceptorForTesting::Cancel() {
  GetForwardingInterface()->Cancel();
}
AuthenticatorAsyncWaiter::AuthenticatorAsyncWaiter(
    Authenticator* proxy) : proxy_(proxy) {}

AuthenticatorAsyncWaiter::~AuthenticatorAsyncWaiter() = default;

void AuthenticatorAsyncWaiter::MakeCredential(
    PublicKeyCredentialCreationOptionsPtr options, AuthenticatorStatus* out_status, MakeCredentialAuthenticatorResponsePtr* out_credential, WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details) {
  base::RunLoop loop;
  proxy_->MakeCredential(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             AuthenticatorStatus* out_status
,
             MakeCredentialAuthenticatorResponsePtr* out_credential
,
             WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details
,
             AuthenticatorStatus status,
             MakeCredentialAuthenticatorResponsePtr credential,
             WebAuthnDOMExceptionDetailsPtr dom_exception_details) {*out_status = std::move(status);*out_credential = std::move(credential);*out_dom_exception_details = std::move(dom_exception_details);
            loop->Quit();
          },
          &loop,
          out_status,
          out_credential,
          out_dom_exception_details));
  loop.Run();
}



void AuthenticatorAsyncWaiter::GetAssertion(
    PublicKeyCredentialRequestOptionsPtr options, AuthenticatorStatus* out_status, GetAssertionAuthenticatorResponsePtr* out_credential, WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details) {
  base::RunLoop loop;
  proxy_->GetAssertion(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             AuthenticatorStatus* out_status
,
             GetAssertionAuthenticatorResponsePtr* out_credential
,
             WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details
,
             AuthenticatorStatus status,
             GetAssertionAuthenticatorResponsePtr credential,
             WebAuthnDOMExceptionDetailsPtr dom_exception_details) {*out_status = std::move(status);*out_credential = std::move(credential);*out_dom_exception_details = std::move(dom_exception_details);
            loop->Quit();
          },
          &loop,
          out_status,
          out_credential,
          out_dom_exception_details));
  loop.Run();
}



void AuthenticatorAsyncWaiter::IsUserVerifyingPlatformAuthenticatorAvailable(
    bool* out_available) {
  base::RunLoop loop;
  proxy_->IsUserVerifyingPlatformAuthenticatorAvailable(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_available
,
             bool available) {*out_available = std::move(available);
            loop->Quit();
          },
          &loop,
          out_available));
  loop.Run();
}

bool AuthenticatorAsyncWaiter::IsUserVerifyingPlatformAuthenticatorAvailable(
    ) {
  bool async_wait_result;
  IsUserVerifyingPlatformAuthenticatorAvailable(&async_wait_result);
  return async_wait_result;
}

void AuthenticatorAsyncWaiter::IsConditionalMediationAvailable(
    bool* out_available) {
  base::RunLoop loop;
  proxy_->IsConditionalMediationAvailable(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_available
,
             bool available) {*out_available = std::move(available);
            loop->Quit();
          },
          &loop,
          out_available));
  loop.Run();
}

bool AuthenticatorAsyncWaiter::IsConditionalMediationAvailable(
    ) {
  bool async_wait_result;
  IsConditionalMediationAvailable(&async_wait_result);
  return async_wait_result;
}

void AuthenticatorAsyncWaiter::Report(
    PublicKeyCredentialReportOptionsPtr options, AuthenticatorStatus* out_status, WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details) {
  base::RunLoop loop;
  proxy_->Report(
      std::move(options),
      base::BindOnce(
          [](base::RunLoop* loop,
             AuthenticatorStatus* out_status
,
             WebAuthnDOMExceptionDetailsPtr* out_dom_exception_details
,
             AuthenticatorStatus status,
             WebAuthnDOMExceptionDetailsPtr dom_exception_details) {*out_status = std::move(status);*out_dom_exception_details = std::move(dom_exception_details);
            loop->Quit();
          },
          &loop,
          out_status,
          out_dom_exception_details));
  loop.Run();
}



void AuthenticatorAsyncWaiter::GetClientCapabilities(
    WTF::Vector<WebAuthnClientCapabilityPtr>* out_capabilities) {
  base::RunLoop loop;
  proxy_->GetClientCapabilities(
      base::BindOnce(
          [](base::RunLoop* loop,
             WTF::Vector<WebAuthnClientCapabilityPtr>* out_capabilities
,
             WTF::Vector<WebAuthnClientCapabilityPtr> capabilities) {*out_capabilities = std::move(capabilities);
            loop->Quit();
          },
          &loop,
          out_capabilities));
  loop.Run();
}

WTF::Vector<WebAuthnClientCapabilityPtr> AuthenticatorAsyncWaiter::GetClientCapabilities(
    ) {
  WTF::Vector<WebAuthnClientCapabilityPtr> async_wait_result;
  GetClientCapabilities(&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif