// third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_HOST_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_HOST_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/private_aggregation/private_aggregation_host.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/aggregation_service/aggregatable_report.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"


#include "base/component_export.h"




namespace blink::mojom {
class DebugKeyDataView;

class DebugModeDetailsDataView;



}  // blink::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::DebugKeyDataView> {
  using Data = ::blink::mojom::internal::DebugKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::DebugModeDetailsDataView> {
  using Data = ::blink::mojom::internal::DebugModeDetails_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {
// Interface base classes. They are used for type safety check.
class PrivateAggregationHostInterfaceBase {};

using PrivateAggregationHostPtrDataView =
    mojo::InterfacePtrDataView<PrivateAggregationHostInterfaceBase>;
using PrivateAggregationHostRequestDataView =
    mojo::InterfaceRequestDataView<PrivateAggregationHostInterfaceBase>;
using PrivateAggregationHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PrivateAggregationHostInterfaceBase>;
using PrivateAggregationHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PrivateAggregationHostInterfaceBase>;


class DebugKeyDataView {
 public:
  DebugKeyDataView() = default;

  DebugKeyDataView(
      internal::DebugKey_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t value() const {
    return data_->value;
  }
 private:
  internal::DebugKey_Data* data_ = nullptr;
};


class DebugModeDetailsDataView {
 public:
  DebugModeDetailsDataView() = default;

  DebugModeDetailsDataView(
      internal::DebugModeDetails_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool is_enabled() const {
    return data_->is_enabled;
  }
  inline void GetDebugKeyDataView(
      DebugKeyDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDebugKey(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::DebugKeyDataView, UserType>(),
    "Attempting to read the optional `debug_key` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDebugKey` instead "
    "of `ReadDebugKey if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->debug_key.Get();
    return mojo::internal::Deserialize<::blink::mojom::DebugKeyDataView>(
        pointer, output, message_);
  }
 private:
  internal::DebugModeDetails_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DebugKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DebugKeyDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DebugKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->value = Traits::value(input);
  }

  static bool Deserialize(::blink::mojom::internal::DebugKey_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DebugKeyDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::DebugModeDetailsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::DebugModeDetailsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::DebugModeDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->is_enabled = Traits::is_enabled(input);
    decltype(Traits::debug_key(input)) in_debug_key = Traits::debug_key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->debug_key)::BaseType> debug_key_fragment(
            fragment.message());
    mojo::internal::Serialize<::blink::mojom::DebugKeyDataView>(
        in_debug_key, debug_key_fragment);
    fragment->debug_key.Set(
        debug_key_fragment.is_null() ? nullptr : debug_key_fragment.data());
  }

  static bool Deserialize(::blink::mojom::internal::DebugModeDetails_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::DebugModeDetailsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {



inline void DebugModeDetailsDataView::GetDebugKeyDataView(
    DebugKeyDataView* output) {
  auto pointer = data_->debug_key.Get();
  *output = DebugKeyDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRIVATE_AGGREGATION_PRIVATE_AGGREGATION_HOST_MOJOM_SHARED_H_