// third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* DevToolsExecutionContextTypeToStringHelper(DevToolsExecutionContextType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case DevToolsExecutionContextType::kDedicatedWorker:
      return "kDedicatedWorker";
    case DevToolsExecutionContextType::kWorklet:
      return "kWorklet";
    default:
      return nullptr;
  }
}

std::string DevToolsExecutionContextTypeToString(DevToolsExecutionContextType value) {
  const char *str = DevToolsExecutionContextTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown DevToolsExecutionContextType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, DevToolsExecutionContextType value) {
  return os << DevToolsExecutionContextTypeToString(value);
}

namespace internal {


// static
bool DevToolsMessage_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsMessage_Data* object =
      static_cast<const DevToolsMessage_Data*>(data);

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->data, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->data, validation_context))
    return false;

  return true;
}

DevToolsMessage_Data::DevToolsMessage_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsSessionState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsSessionState_Data* object =
      static_cast<const DevToolsSessionState_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entries, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& entries_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, true, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
  if (!mojo::internal::ValidateContainer(object->entries, validation_context,
                                         &entries_validate_params)) {
    return false;
  }

  return true;
}

DevToolsSessionState_Data::DevToolsSessionState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgent_AttachDevToolsSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgent_AttachDevToolsSession_Params_Data* object =
      static_cast<const DevToolsAgent_AttachDevToolsSession_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->host, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->session, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->session,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->io_session, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->io_session,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->reattach_session_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session_id, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& session_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->session_id, validation_context,
                                         &session_id_validate_params)) {
    return false;
  }

  return true;
}

DevToolsAgent_AttachDevToolsSession_Params_Data::DevToolsAgent_AttachDevToolsSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgent_InspectElement_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgent_InspectElement_Params_Data* object =
      static_cast<const DevToolsAgent_InspectElement_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->point, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->point, validation_context))
    return false;

  return true;
}

DevToolsAgent_InspectElement_Params_Data::DevToolsAgent_InspectElement_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgent_ReportChildTargets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgent_ReportChildTargets_Params_Data* object =
      static_cast<const DevToolsAgent_ReportChildTargets_Params_Data*>(data);

  return true;
}

DevToolsAgent_ReportChildTargets_Params_Data::DevToolsAgent_ReportChildTargets_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgent_ReportChildTargets_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgent_ReportChildTargets_ResponseParams_Data* object =
      static_cast<const DevToolsAgent_ReportChildTargets_ResponseParams_Data*>(data);

  return true;
}

DevToolsAgent_ReportChildTargets_ResponseParams_Data::DevToolsAgent_ReportChildTargets_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgentHost_ChildTargetCreated_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgentHost_ChildTargetCreated_Params_Data* object =
      static_cast<const DevToolsAgentHost_ChildTargetCreated_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->worker_devtools_agent, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->worker_devtools_agent,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->worker_devtools_agent_host, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->worker_devtools_agent_host,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtools_worker_token, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtools_worker_token, validation_context))
    return false;


  if (!::blink::mojom::internal::DevToolsExecutionContextType_Data
        ::Validate(object->context_type, validation_context))
    return false;

  return true;
}

DevToolsAgentHost_ChildTargetCreated_Params_Data::DevToolsAgentHost_ChildTargetCreated_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data* object =
      static_cast<const DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data*>(data);

  return true;
}

DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data::DevToolsAgentHost_MainThreadDebuggerPaused_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data* object =
      static_cast<const DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data*>(data);

  return true;
}

DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data::DevToolsAgentHost_MainThreadDebuggerResumed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsAgentHost_BringToForeground_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsAgentHost_BringToForeground_Params_Data* object =
      static_cast<const DevToolsAgentHost_BringToForeground_Params_Data*>(data);

  return true;
}

DevToolsAgentHost_BringToForeground_Params_Data::DevToolsAgentHost_BringToForeground_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsSession_DispatchProtocolCommand_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsSession_DispatchProtocolCommand_Params_Data* object =
      static_cast<const DevToolsSession_DispatchProtocolCommand_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  return true;
}

DevToolsSession_DispatchProtocolCommand_Params_Data::DevToolsSession_DispatchProtocolCommand_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsSessionHost_DispatchProtocolResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsSessionHost_DispatchProtocolResponse_Params_Data* object =
      static_cast<const DevToolsSessionHost_DispatchProtocolResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->updates, validation_context))
    return false;

  return true;
}

DevToolsSessionHost_DispatchProtocolResponse_Params_Data::DevToolsSessionHost_DispatchProtocolResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsSessionHost_DispatchProtocolNotification_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsSessionHost_DispatchProtocolNotification_Params_Data* object =
      static_cast<const DevToolsSessionHost_DispatchProtocolNotification_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->message, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->message, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->updates, validation_context))
    return false;

  return true;
}

DevToolsSessionHost_DispatchProtocolNotification_Params_Data::DevToolsSessionHost_DispatchProtocolNotification_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::DevToolsExecutionContextType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::DevToolsExecutionContextType value) {
  return std::move(context).WriteString(::blink::mojom::DevToolsExecutionContextTypeToString(value));
}

} // namespace perfetto