// services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_SHARED_H_
#define SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/cert_verifier/public/mojom/cert_verifier_service_factory.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/file_path.mojom-shared.h"
#include "mojo/public/mojom/base/proto_wrapper.mojom-shared.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service.mojom-shared.h"
#include "services/network/public/mojom/cert_verifier_service_updater.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/ct_log_info.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"






namespace cert_verifier::mojom {
class CertVerifierCreationParamsDataView;

class ChromeRootCertInfoDataView;

class ChromeRootStoreInfoDataView;

class PlatformCertInfoDataView;

class PlatformRootStoreInfoDataView;



}  // cert_verifier::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cert_verifier::mojom::CertVerifierCreationParamsDataView> {
  using Data = ::cert_verifier::mojom::internal::CertVerifierCreationParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::ChromeRootCertInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::ChromeRootCertInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::ChromeRootStoreInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::ChromeRootStoreInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::PlatformCertInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::PlatformCertInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::PlatformRootStoreInfoDataView> {
  using Data = ::cert_verifier::mojom::internal::PlatformRootStoreInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cert_verifier::mojom {


enum class CertificateTrust : int32_t {
  
  kUnspecified = 0,
  
  kDistrusted = 1,
  
  kTrusted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, CertificateTrust value);
inline bool IsKnownEnumValue(CertificateTrust value) {
  return internal::CertificateTrust_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class CertVerifierServiceFactoryInterfaceBase {};

using CertVerifierServiceFactoryPtrDataView =
    mojo::InterfacePtrDataView<CertVerifierServiceFactoryInterfaceBase>;
using CertVerifierServiceFactoryRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierServiceFactoryInterfaceBase>;
using CertVerifierServiceFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierServiceFactoryInterfaceBase>;
using CertVerifierServiceFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierServiceFactoryInterfaceBase>;


class CertVerifierCreationParamsDataView {
 public:
  CertVerifierCreationParamsDataView() = default;

  CertVerifierCreationParamsDataView(
      internal::CertVerifierCreationParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetInitialAdditionalCertificatesDataView(
      ::cert_verifier::mojom::AdditionalCertificatesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadInitialAdditionalCertificates(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::cert_verifier::mojom::AdditionalCertificatesDataView, UserType>(),
    "Attempting to read the optional `initial_additional_certificates` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadInitialAdditionalCertificates` instead "
    "of `ReadInitialAdditionalCertificates if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->initial_additional_certificates.Get();
    return mojo::internal::Deserialize<::cert_verifier::mojom::AdditionalCertificatesDataView>(
        pointer, output, message_);
  }
  bool wait_for_update() const {
    return data_->wait_for_update;
  }
 private:
  internal::CertVerifierCreationParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeRootCertInfoDataView {
 public:
  ChromeRootCertInfoDataView() = default;

  ChromeRootCertInfoDataView(
      internal::ChromeRootCertInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSha256hashHexDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSha256hashHex(UserType* output) {
    
    auto* pointer = data_->sha256hash_hex.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetCertDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCert(UserType* output) {
    
    auto* pointer = data_->cert.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
 private:
  internal::ChromeRootCertInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ChromeRootStoreInfoDataView {
 public:
  ChromeRootStoreInfoDataView() = default;

  ChromeRootStoreInfoDataView(
      internal::ChromeRootStoreInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int64_t version() const {
    return data_->version;
  }
  inline void GetRootCertInfoDataView(
      mojo::ArrayDataView<ChromeRootCertInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRootCertInfo(UserType* output) {
    
    auto* pointer = data_->root_cert_info.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::ChromeRootCertInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::ChromeRootStoreInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlatformCertInfoDataView {
 public:
  PlatformCertInfoDataView() = default;

  PlatformCertInfoDataView(
      internal::PlatformCertInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCertDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCert(UserType* output) {
    
    auto* pointer = data_->cert.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTrustSetting(UserType* output) const {
    auto data_value = data_->trust_setting;
    return mojo::internal::Deserialize<::cert_verifier::mojom::CertificateTrust>(
        data_value, output);
  }
  CertificateTrust trust_setting() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::cert_verifier::mojom::CertificateTrust>(data_->trust_setting));
  }
 private:
  internal::PlatformCertInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class PlatformRootStoreInfoDataView {
 public:
  PlatformRootStoreInfoDataView() = default;

  PlatformRootStoreInfoDataView(
      internal::PlatformRootStoreInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUserAddedCertsDataView(
      mojo::ArrayDataView<PlatformCertInfoDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserAddedCerts(UserType* output) {
    
    auto* pointer = data_->user_added_certs.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::cert_verifier::mojom::PlatformCertInfoDataView>>(
        pointer, output, message_);
  }
 private:
  internal::PlatformRootStoreInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // cert_verifier::mojom

namespace std {

template <>
struct hash<::cert_verifier::mojom::CertificateTrust>
    : public mojo::internal::EnumHashImpl<::cert_verifier::mojom::CertificateTrust> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::CertificateTrust, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::cert_verifier::mojom::CertificateTrust, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::cert_verifier::mojom::CertificateTrust>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::CertVerifierCreationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::CertVerifierCreationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::CertVerifierCreationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::initial_additional_certificates(input)) in_initial_additional_certificates = Traits::initial_additional_certificates(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initial_additional_certificates)::BaseType> initial_additional_certificates_fragment(
            fragment.message());
    mojo::internal::Serialize<::cert_verifier::mojom::AdditionalCertificatesDataView>(
        in_initial_additional_certificates, initial_additional_certificates_fragment);
    fragment->initial_additional_certificates.Set(
        initial_additional_certificates_fragment.is_null() ? nullptr : initial_additional_certificates_fragment.data());
    fragment->wait_for_update = Traits::wait_for_update(input);
  }

  static bool Deserialize(::cert_verifier::mojom::internal::CertVerifierCreationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::CertVerifierCreationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::ChromeRootCertInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::ChromeRootCertInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::ChromeRootCertInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::sha256hash_hex(input)) in_sha256hash_hex = Traits::sha256hash_hex(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->sha256hash_hex)::BaseType> sha256hash_hex_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_sha256hash_hex, sha256hash_hex_fragment);
    fragment->sha256hash_hex.Set(
        sha256hash_hex_fragment.is_null() ? nullptr : sha256hash_hex_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->sha256hash_hex.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sha256hash_hex in ChromeRootCertInfo struct");
    decltype(Traits::cert(input)) in_cert = Traits::cert(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cert)::BaseType>
        cert_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cert_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_cert, cert_fragment, &cert_validate_params);
    fragment->cert.Set(
        cert_fragment.is_null() ? nullptr : cert_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cert.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert in ChromeRootCertInfo struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::ChromeRootCertInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::ChromeRootCertInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::ChromeRootStoreInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::ChromeRootStoreInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::ChromeRootStoreInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->version = Traits::version(input);
    decltype(Traits::root_cert_info(input)) in_root_cert_info = Traits::root_cert_info(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->root_cert_info)::BaseType>
        root_cert_info_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& root_cert_info_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::ChromeRootCertInfoDataView>>(
        in_root_cert_info, root_cert_info_fragment, &root_cert_info_validate_params);
    fragment->root_cert_info.Set(
        root_cert_info_fragment.is_null() ? nullptr : root_cert_info_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->root_cert_info.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null root_cert_info in ChromeRootStoreInfo struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::ChromeRootStoreInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::ChromeRootStoreInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::PlatformCertInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::PlatformCertInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::PlatformCertInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::cert(input)) in_cert = Traits::cert(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->cert)::BaseType>
        cert_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& cert_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
        in_cert, cert_fragment, &cert_validate_params);
    fragment->cert.Set(
        cert_fragment.is_null() ? nullptr : cert_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->cert.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cert in PlatformCertInfo struct");
    mojo::internal::Serialize<::cert_verifier::mojom::CertificateTrust>(
        Traits::trust_setting(input), &fragment->trust_setting);
  }

  static bool Deserialize(::cert_verifier::mojom::internal::PlatformCertInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::PlatformCertInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::cert_verifier::mojom::PlatformRootStoreInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::cert_verifier::mojom::PlatformRootStoreInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::cert_verifier::mojom::internal::PlatformRootStoreInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::user_added_certs(input)) in_user_added_certs = Traits::user_added_certs(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->user_added_certs)::BaseType>
        user_added_certs_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& user_added_certs_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::cert_verifier::mojom::PlatformCertInfoDataView>>(
        in_user_added_certs, user_added_certs_fragment, &user_added_certs_validate_params);
    fragment->user_added_certs.Set(
        user_added_certs_fragment.is_null() ? nullptr : user_added_certs_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->user_added_certs.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null user_added_certs in PlatformRootStoreInfo struct");
  }

  static bool Deserialize(::cert_verifier::mojom::internal::PlatformRootStoreInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::cert_verifier::mojom::PlatformRootStoreInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace cert_verifier::mojom {

inline void CertVerifierCreationParamsDataView::GetInitialAdditionalCertificatesDataView(
    ::cert_verifier::mojom::AdditionalCertificatesDataView* output) {
  auto pointer = data_->initial_additional_certificates.Get();
  *output = ::cert_verifier::mojom::AdditionalCertificatesDataView(pointer, message_);
}


inline void ChromeRootCertInfoDataView::GetSha256hashHexDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->sha256hash_hex.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void ChromeRootCertInfoDataView::GetCertDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->cert.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void ChromeRootStoreInfoDataView::GetRootCertInfoDataView(
    mojo::ArrayDataView<ChromeRootCertInfoDataView>* output) {
  auto pointer = data_->root_cert_info.Get();
  *output = mojo::ArrayDataView<ChromeRootCertInfoDataView>(pointer, message_);
}


inline void PlatformCertInfoDataView::GetCertDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->cert.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, message_);
}


inline void PlatformRootStoreInfoDataView::GetUserAddedCertsDataView(
    mojo::ArrayDataView<PlatformCertInfoDataView>* output) {
  auto pointer = data_->user_added_certs.Get();
  *output = mojo::ArrayDataView<PlatformCertInfoDataView>(pointer, message_);
}



}  // cert_verifier::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::cert_verifier::mojom::CertificateTrust> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::cert_verifier::mojom::CertificateTrust value);
};

} // namespace perfetto

#endif  // SERVICES_CERT_VERIFIER_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_FACTORY_MOJOM_SHARED_H_