// qtwebengine/common/renderer_configuration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef QTWEBENGINE_COMMON_RENDERER_CONFIGURATION_MOJOM_H_
#define QTWEBENGINE_COMMON_RENDERER_CONFIGURATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>

#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "qtwebengine/common/renderer_configuration.mojom-features.h"  // IWYU pragma: export
#include "qtwebengine/common/renderer_configuration.mojom-shared.h"  // IWYU pragma: export
#include "qtwebengine/common/renderer_configuration.mojom-forward.h"  // IWYU pragma: export
#include "components/content_settings/core/common/content_settings.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/lib/message_size_estimator.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace qtwebengine::mojom {

class RendererConfigurationProxy;

template <typename ImplRefTraits>
class RendererConfigurationStub;

class RendererConfigurationRequestValidator;


class RendererConfiguration
    : public RendererConfigurationInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();

  static const char Name_[];
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = RendererConfigurationInterfaceBase;
  using Proxy_ = RendererConfigurationProxy;

  template <typename ImplRefTraits>
  using Stub_ = RendererConfigurationStub<ImplRefTraits>;

  using RequestValidator_ = RendererConfigurationRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetInitialConfigurationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetInitialConfiguration_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~RendererConfiguration() = default;

  
  virtual void SetInitialConfiguration(bool is_incognito_process) = 0;
};



class  RendererConfigurationProxy
    : public RendererConfiguration {
 public:
  using InterfaceType = RendererConfiguration;

  explicit RendererConfigurationProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetInitialConfiguration(bool is_incognito_process) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  RendererConfigurationStubDispatch {
 public:
  static bool Accept(RendererConfiguration* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RendererConfiguration* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RendererConfiguration>>
class RendererConfigurationStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RendererConfigurationStub() = default;
  ~RendererConfigurationStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererConfigurationStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RendererConfigurationStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  RendererConfigurationRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // qtwebengine::mojom

namespace mojo {

}  // namespace mojo

#endif  // QTWEBENGINE_COMMON_RENDERER_CONFIGURATION_MOJOM_H_