// components/performance_manager/public/mojom/web_memory.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_SHARED_H_
#define COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "components/performance_manager/public/mojom/web_memory.mojom-shared-internal.h"



#include "base/component_export.h"




namespace performance_manager::mojom {
class WebMemoryAttributionDataView;

class WebMemoryUsageDataView;

class WebMemoryBreakdownEntryDataView;

class WebMemoryMeasurementDataView;



}  // performance_manager::mojom

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryAttributionDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryAttribution_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryUsageDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryUsage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryBreakdownEntryDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryBreakdownEntry_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::performance_manager::mojom::WebMemoryMeasurementDataView> {
  using Data = ::performance_manager::mojom::internal::WebMemoryMeasurement_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace performance_manager::mojom {


enum class WebMemoryAttribution_Scope : int32_t {
  
  kCrossOriginAggregated = 0,
  
  kWindow = 1,
  
  kDedicatedWorker = 2,
  
  kServiceWorker = 3,
  
  kSharedWorker = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, WebMemoryAttribution_Scope value);
inline bool IsKnownEnumValue(WebMemoryAttribution_Scope value) {
  return internal::WebMemoryAttribution_Scope_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class WebMemoryMeasurement_Mode : int32_t {
  
  kDefault = 0,
  
  kEager = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, WebMemoryMeasurement_Mode value);
inline bool IsKnownEnumValue(WebMemoryMeasurement_Mode value) {
  return internal::WebMemoryMeasurement_Mode_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class WebMemoryAttributionDataView {
 public:
  WebMemoryAttributionDataView() = default;

  WebMemoryAttributionDataView(
      internal::WebMemoryAttribution_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadScope(UserType* output) const {
    auto data_value = data_->scope;
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryAttribution_Scope>(
        data_value, output);
  }
  WebMemoryAttribution_Scope scope() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::performance_manager::mojom::WebMemoryAttribution_Scope>(data_->scope));
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSrcDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrc(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `src` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSrc` instead "
    "of `ReadSrc if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->src.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebMemoryAttribution_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebMemoryUsageDataView {
 public:
  WebMemoryUsageDataView() = default;

  WebMemoryUsageDataView(
      internal::WebMemoryUsage_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t bytes() const {
    return data_->bytes;
  }
 private:
  internal::WebMemoryUsage_Data* data_ = nullptr;
};


class WebMemoryBreakdownEntryDataView {
 public:
  WebMemoryBreakdownEntryDataView() = default;

  WebMemoryBreakdownEntryDataView(
      internal::WebMemoryBreakdownEntry_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMemoryDataView(
      WebMemoryUsageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::performance_manager::mojom::WebMemoryUsageDataView, UserType>(),
    "Attempting to read the optional `memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMemory` instead "
    "of `ReadMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->memory.Get();
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        pointer, output, message_);
  }
  inline void GetCanvasMemoryDataView(
      WebMemoryUsageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCanvasMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::performance_manager::mojom::WebMemoryUsageDataView, UserType>(),
    "Attempting to read the optional `canvas_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadCanvasMemory` instead "
    "of `ReadCanvasMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->canvas_memory.Get();
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        pointer, output, message_);
  }
  inline void GetAttributionDataView(
      mojo::ArrayDataView<WebMemoryAttributionDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAttribution(UserType* output) {
    
    auto* pointer = data_->attribution.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryAttributionDataView>>(
        pointer, output, message_);
  }
 private:
  internal::WebMemoryBreakdownEntry_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class WebMemoryMeasurementDataView {
 public:
  WebMemoryMeasurementDataView() = default;

  WebMemoryMeasurementDataView(
      internal::WebMemoryMeasurement_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBreakdownDataView(
      mojo::ArrayDataView<WebMemoryBreakdownEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBreakdown(UserType* output) {
    
    auto* pointer = data_->breakdown.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryBreakdownEntryDataView>>(
        pointer, output, message_);
  }
  inline void GetDetachedMemoryDataView(
      WebMemoryUsageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDetachedMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::performance_manager::mojom::WebMemoryUsageDataView, UserType>(),
    "Attempting to read the optional `detached_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetachedMemory` instead "
    "of `ReadDetachedMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->detached_memory.Get();
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        pointer, output, message_);
  }
  inline void GetSharedMemoryDataView(
      WebMemoryUsageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSharedMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::performance_manager::mojom::WebMemoryUsageDataView, UserType>(),
    "Attempting to read the optional `shared_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSharedMemory` instead "
    "of `ReadSharedMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->shared_memory.Get();
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        pointer, output, message_);
  }
  inline void GetBlinkMemoryDataView(
      WebMemoryUsageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBlinkMemory(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::performance_manager::mojom::WebMemoryUsageDataView, UserType>(),
    "Attempting to read the optional `blink_memory` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadBlinkMemory` instead "
    "of `ReadBlinkMemory if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->blink_memory.Get();
    return mojo::internal::Deserialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        pointer, output, message_);
  }
 private:
  internal::WebMemoryMeasurement_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // performance_manager::mojom

namespace std {

template <>
struct hash<::performance_manager::mojom::WebMemoryAttribution_Scope>
    : public mojo::internal::EnumHashImpl<::performance_manager::mojom::WebMemoryAttribution_Scope> {};

template <>
struct hash<::performance_manager::mojom::WebMemoryMeasurement_Mode>
    : public mojo::internal::EnumHashImpl<::performance_manager::mojom::WebMemoryMeasurement_Mode> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryAttribution_Scope, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::performance_manager::mojom::WebMemoryAttribution_Scope, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::performance_manager::mojom::WebMemoryAttribution_Scope>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryMeasurement_Mode, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::performance_manager::mojom::WebMemoryMeasurement_Mode, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::performance_manager::mojom::WebMemoryMeasurement_Mode>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryAttributionDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryAttributionDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryAttribution_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryAttribution_Scope>(
        Traits::scope(input), &fragment->scope);
    decltype(Traits::url(input)) in_url = Traits::url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->url)::BaseType> url_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_url, url_fragment);
    fragment->url.Set(
        url_fragment.is_null() ? nullptr : url_fragment.data());
    decltype(Traits::src(input)) in_src = Traits::src(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->src)::BaseType> src_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_src, src_fragment);
    fragment->src.Set(
        src_fragment.is_null() ? nullptr : src_fragment.data());
    decltype(Traits::id(input)) in_id = Traits::id(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->id)::BaseType> id_fragment(
            fragment.message());
    mojo::internal::Serialize<mojo::StringDataView>(
        in_id, id_fragment);
    fragment->id.Set(
        id_fragment.is_null() ? nullptr : id_fragment.data());
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryAttribution_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryAttributionDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryUsageDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryUsageDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryUsage_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    fragment->bytes = Traits::bytes(input);
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryUsage_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryUsageDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryBreakdownEntryDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryBreakdownEntryDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryBreakdownEntry_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::memory(input)) in_memory = Traits::memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->memory)::BaseType> memory_fragment(
            fragment.message());
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        in_memory, memory_fragment);
    fragment->memory.Set(
        memory_fragment.is_null() ? nullptr : memory_fragment.data());
    decltype(Traits::canvas_memory(input)) in_canvas_memory = Traits::canvas_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->canvas_memory)::BaseType> canvas_memory_fragment(
            fragment.message());
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        in_canvas_memory, canvas_memory_fragment);
    fragment->canvas_memory.Set(
        canvas_memory_fragment.is_null() ? nullptr : canvas_memory_fragment.data());
    decltype(Traits::attribution(input)) in_attribution = Traits::attribution(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->attribution)::BaseType>
        attribution_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& attribution_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryAttributionDataView>>(
        in_attribution, attribution_fragment, &attribution_validate_params);
    fragment->attribution.Set(
        attribution_fragment.is_null() ? nullptr : attribution_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->attribution.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null attribution in WebMemoryBreakdownEntry struct");
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryBreakdownEntry_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryBreakdownEntryDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::performance_manager::mojom::WebMemoryMeasurementDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::performance_manager::mojom::WebMemoryMeasurementDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::performance_manager::mojom::internal::WebMemoryMeasurement_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
    decltype(Traits::breakdown(input)) in_breakdown = Traits::breakdown(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->breakdown)::BaseType>
        breakdown_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& breakdown_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    mojo::internal::Serialize<mojo::ArrayDataView<::performance_manager::mojom::WebMemoryBreakdownEntryDataView>>(
        in_breakdown, breakdown_fragment, &breakdown_validate_params);
    fragment->breakdown.Set(
        breakdown_fragment.is_null() ? nullptr : breakdown_fragment.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        fragment->breakdown.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null breakdown in WebMemoryMeasurement struct");
    decltype(Traits::detached_memory(input)) in_detached_memory = Traits::detached_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->detached_memory)::BaseType> detached_memory_fragment(
            fragment.message());
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        in_detached_memory, detached_memory_fragment);
    fragment->detached_memory.Set(
        detached_memory_fragment.is_null() ? nullptr : detached_memory_fragment.data());
    decltype(Traits::shared_memory(input)) in_shared_memory = Traits::shared_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->shared_memory)::BaseType> shared_memory_fragment(
            fragment.message());
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        in_shared_memory, shared_memory_fragment);
    fragment->shared_memory.Set(
        shared_memory_fragment.is_null() ? nullptr : shared_memory_fragment.data());
    decltype(Traits::blink_memory(input)) in_blink_memory = Traits::blink_memory(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->blink_memory)::BaseType> blink_memory_fragment(
            fragment.message());
    mojo::internal::Serialize<::performance_manager::mojom::WebMemoryUsageDataView>(
        in_blink_memory, blink_memory_fragment);
    fragment->blink_memory.Set(
        blink_memory_fragment.is_null() ? nullptr : blink_memory_fragment.data());
  }

  static bool Deserialize(::performance_manager::mojom::internal::WebMemoryMeasurement_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::performance_manager::mojom::WebMemoryMeasurementDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace performance_manager::mojom {

inline void WebMemoryAttributionDataView::GetUrlDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->url.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebMemoryAttributionDataView::GetSrcDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->src.Get();
  *output = mojo::StringDataView(pointer, message_);
}
inline void WebMemoryAttributionDataView::GetIdDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->id.Get();
  *output = mojo::StringDataView(pointer, message_);
}




inline void WebMemoryBreakdownEntryDataView::GetMemoryDataView(
    WebMemoryUsageDataView* output) {
  auto pointer = data_->memory.Get();
  *output = WebMemoryUsageDataView(pointer, message_);
}
inline void WebMemoryBreakdownEntryDataView::GetCanvasMemoryDataView(
    WebMemoryUsageDataView* output) {
  auto pointer = data_->canvas_memory.Get();
  *output = WebMemoryUsageDataView(pointer, message_);
}
inline void WebMemoryBreakdownEntryDataView::GetAttributionDataView(
    mojo::ArrayDataView<WebMemoryAttributionDataView>* output) {
  auto pointer = data_->attribution.Get();
  *output = mojo::ArrayDataView<WebMemoryAttributionDataView>(pointer, message_);
}


inline void WebMemoryMeasurementDataView::GetBreakdownDataView(
    mojo::ArrayDataView<WebMemoryBreakdownEntryDataView>* output) {
  auto pointer = data_->breakdown.Get();
  *output = mojo::ArrayDataView<WebMemoryBreakdownEntryDataView>(pointer, message_);
}
inline void WebMemoryMeasurementDataView::GetDetachedMemoryDataView(
    WebMemoryUsageDataView* output) {
  auto pointer = data_->detached_memory.Get();
  *output = WebMemoryUsageDataView(pointer, message_);
}
inline void WebMemoryMeasurementDataView::GetSharedMemoryDataView(
    WebMemoryUsageDataView* output) {
  auto pointer = data_->shared_memory.Get();
  *output = WebMemoryUsageDataView(pointer, message_);
}
inline void WebMemoryMeasurementDataView::GetBlinkMemoryDataView(
    WebMemoryUsageDataView* output) {
  auto pointer = data_->blink_memory.Get();
  *output = WebMemoryUsageDataView(pointer, message_);
}



}  // performance_manager::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::performance_manager::mojom::WebMemoryAttribution_Scope> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryAttribution_Scope value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct COMPONENT_EXPORT(PERFORMANCE_MANAGER_PUBLIC_MOJOM_SHARED) TraceFormatTraits<::performance_manager::mojom::WebMemoryMeasurement_Mode> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::performance_manager::mojom::WebMemoryMeasurement_Mode value);
};

} // namespace perfetto

#endif  // COMPONENTS_PERFORMANCE_MANAGER_PUBLIC_MOJOM_WEB_MEMORY_MOJOM_SHARED_H_