// third_party/blink/public/mojom/timing/performance_mark_or_measure.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_PERFORMANCE_MARK_OR_MEASURE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_PERFORMANCE_MARK_OR_MEASURE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/timing/performance_mark_or_measure.mojom-shared-internal.h"
#include "mojo/public/mojom/base/big_buffer.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class PerformanceMarkOrMeasureDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PerformanceMarkOrMeasureDataView> {
  using Data = ::blink::mojom::internal::PerformanceMarkOrMeasure_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PerformanceMarkOrMeasure_EntryType : int32_t {
  
  kMark = 0,
  
  kMeasure = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PerformanceMarkOrMeasure_EntryType value);
inline bool IsKnownEnumValue(PerformanceMarkOrMeasure_EntryType value) {
  return internal::PerformanceMarkOrMeasure_EntryType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class PerformanceMarkOrMeasureDataView {
 public:
  PerformanceMarkOrMeasureDataView() {}

  PerformanceMarkOrMeasureDataView(
      internal::PerformanceMarkOrMeasure_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEntryType(UserType* output) const {
    auto data_value = data_->entry_type;
    return mojo::internal::Deserialize<::blink::mojom::PerformanceMarkOrMeasure_EntryType>(
        data_value, output);
  }

  PerformanceMarkOrMeasure_EntryType entry_type() const {
    return static_cast<PerformanceMarkOrMeasure_EntryType>(data_->entry_type);
  }
  double start_time() const {
    return data_->start_time;
  }
  double duration() const {
    return data_->duration;
  }
  inline void GetDetailDataView(
      ::mojo_base::mojom::BigBufferDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDetail(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::mojo_base::mojom::BigBufferDataView, UserType>(),
    "Attempting to read the optional `detail` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDetail` instead "
    "of `ReadDetail if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = !data_->detail.is_null() ? &data_->detail : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::BigBufferDataView>(
        pointer, output, context_);
  }
 private:
  internal::PerformanceMarkOrMeasure_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PerformanceMarkOrMeasure_EntryType>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PerformanceMarkOrMeasure_EntryType> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PerformanceMarkOrMeasure_EntryType, ::blink::mojom::PerformanceMarkOrMeasure_EntryType> {
  static ::blink::mojom::PerformanceMarkOrMeasure_EntryType ToMojom(::blink::mojom::PerformanceMarkOrMeasure_EntryType input) { return input; }
  static bool FromMojom(::blink::mojom::PerformanceMarkOrMeasure_EntryType input, ::blink::mojom::PerformanceMarkOrMeasure_EntryType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerformanceMarkOrMeasure_EntryType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PerformanceMarkOrMeasure_EntryType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PerformanceMarkOrMeasure_EntryType>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PerformanceMarkOrMeasureDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PerformanceMarkOrMeasureDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PerformanceMarkOrMeasure_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::name(input)) in_name = Traits::name(input);
    typename decltype((*output)->name)::BaseType::BufferWriter
        name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_name, buffer, &name_writer, context);
    (*output)->name.Set(
        name_writer.is_null() ? nullptr : name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in PerformanceMarkOrMeasure struct");
    mojo::internal::Serialize<::blink::mojom::PerformanceMarkOrMeasure_EntryType>(
        Traits::entry_type(input), &(*output)->entry_type);
    (*output)->start_time = Traits::start_time(input);
    (*output)->duration = Traits::duration(input);
    decltype(Traits::detail(input)) in_detail = Traits::detail(input);
    typename decltype((*output)->detail)::BufferWriter detail_writer;
    detail_writer.AllocateInline(buffer, &(*output)->detail);
    mojo::internal::Serialize<::mojo_base::mojom::BigBufferDataView>(
        in_detail, buffer, &detail_writer, true, context);
  }

  static bool Deserialize(::blink::mojom::internal::PerformanceMarkOrMeasure_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PerformanceMarkOrMeasureDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void PerformanceMarkOrMeasureDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void PerformanceMarkOrMeasureDataView::GetDetailDataView(
    ::mojo_base::mojom::BigBufferDataView* output) {
  auto pointer = &data_->detail;
  *output = ::mojo_base::mojom::BigBufferDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_PERFORMANCE_MARK_OR_MEASURE_MOJOM_SHARED_H_