// third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_OPTIONS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_OPTIONS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class ServiceWorkerRegistrationOptionsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::ServiceWorkerRegistrationOptionsDataView> {
  using Data = ::blink::mojom::internal::ServiceWorkerRegistrationOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class ServiceWorkerUpdateViaCache : int32_t {
  
  kImports = 0,
  
  kAll = 1,
  
  kNone = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(SERVICE_WORKER_STORAGE_MOJOM_SHARED) std::ostream& operator<<(std::ostream& os, ServiceWorkerUpdateViaCache value);
inline bool IsKnownEnumValue(ServiceWorkerUpdateViaCache value) {
  return internal::ServiceWorkerUpdateViaCache_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class ServiceWorkerRegistrationOptionsDataView {
 public:
  ServiceWorkerRegistrationOptionsDataView() {}

  ServiceWorkerRegistrationOptionsDataView(
      internal::ServiceWorkerRegistrationOptions_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetScopeDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScope(UserType* output) {
    
    auto* pointer = data_->scope.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::blink::mojom::ScriptType>(
        data_value, output);
  }

  ::blink::mojom::ScriptType type() const {
    return static_cast<::blink::mojom::ScriptType>(data_->type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadUpdateViaCache(UserType* output) const {
    auto data_value = data_->update_via_cache;
    return mojo::internal::Deserialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        data_value, output);
  }

  ServiceWorkerUpdateViaCache update_via_cache() const {
    return static_cast<ServiceWorkerUpdateViaCache>(data_->update_via_cache);
  }
 private:
  internal::ServiceWorkerRegistrationOptions_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::ServiceWorkerUpdateViaCache>
    : public mojo::internal::EnumHashImpl<::blink::mojom::ServiceWorkerUpdateViaCache> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::ServiceWorkerUpdateViaCache, ::blink::mojom::ServiceWorkerUpdateViaCache> {
  static ::blink::mojom::ServiceWorkerUpdateViaCache ToMojom(::blink::mojom::ServiceWorkerUpdateViaCache input) { return input; }
  static bool FromMojom(::blink::mojom::ServiceWorkerUpdateViaCache input, ::blink::mojom::ServiceWorkerUpdateViaCache* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerUpdateViaCache, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::ServiceWorkerUpdateViaCache, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::ServiceWorkerUpdateViaCache>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::ServiceWorkerRegistrationOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServiceWorkerRegistrationOptionsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::ServiceWorkerRegistrationOptions_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::scope(input)) in_scope = Traits::scope(input);
    typename decltype((*output)->scope)::BaseType::BufferWriter
        scope_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_scope, buffer, &scope_writer, context);
    (*output)->scope.Set(
        scope_writer.is_null() ? nullptr : scope_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->scope.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null scope in ServiceWorkerRegistrationOptions struct");
    mojo::internal::Serialize<::blink::mojom::ScriptType>(
        Traits::type(input), &(*output)->type);
    mojo::internal::Serialize<::blink::mojom::ServiceWorkerUpdateViaCache>(
        Traits::update_via_cache(input), &(*output)->update_via_cache);
  }

  static bool Deserialize(::blink::mojom::internal::ServiceWorkerRegistrationOptions_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::ServiceWorkerRegistrationOptionsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void ServiceWorkerRegistrationOptionsDataView::GetScopeDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->scope.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_OPTIONS_MOJOM_SHARED_H_