// third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-params-data.h"
#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/screen_enumeration/screen_enumeration.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SCREEN_ENUMERATION_SCREEN_ENUMERATION_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
Displays::Displays()
    : displays(),
      internal_id(),
      primary_id() {}

Displays::Displays(
    std::vector<::display::Display> displays_in,
    int64_t internal_id_in,
    int64_t primary_id_in)
    : displays(std::move(displays_in)),
      internal_id(std::move(internal_id_in)),
      primary_id(std::move(primary_id_in)) {}

Displays::~Displays() = default;

void Displays::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("displays");
  for (const auto& item0 : this->displays) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::display::Display&>"));
  }
  value->EndArray();
  value->SetString("internal_id", base::NumberToString(this->internal_id));
  value->SetString("primary_id", base::NumberToString(this->primary_id));
}

bool Displays::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
const char ScreenEnumeration::Name_[] = "blink.mojom.ScreenEnumeration";

class ScreenEnumeration_GetDisplays_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenEnumeration_GetDisplays_ForwardToCallback(
      ScreenEnumeration::GetDisplaysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ScreenEnumeration::GetDisplaysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ScreenEnumeration_GetDisplays_ForwardToCallback);
};

class ScreenEnumeration_HasMultipleDisplays_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ScreenEnumeration_HasMultipleDisplays_ForwardToCallback(
      ScreenEnumeration::HasMultipleDisplaysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  ScreenEnumeration::HasMultipleDisplaysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(ScreenEnumeration_HasMultipleDisplays_ForwardToCallback);
};

ScreenEnumerationProxy::ScreenEnumerationProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ScreenEnumerationProxy::GetDisplays(
    GetDisplaysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ScreenEnumeration::GetDisplays");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kScreenEnumeration_GetDisplays_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ScreenEnumeration_GetDisplays_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenEnumeration::Name_);
  message.set_method_name("GetDisplays");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenEnumeration_GetDisplays_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void ScreenEnumerationProxy::HasMultipleDisplays(
    HasMultipleDisplaysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::ScreenEnumeration::HasMultipleDisplays");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kScreenEnumeration_HasMultipleDisplays_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ScreenEnumeration_HasMultipleDisplays_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenEnumeration::Name_);
  message.set_method_name("HasMultipleDisplays");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ScreenEnumeration_HasMultipleDisplays_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class ScreenEnumeration_GetDisplays_ProxyToResponder {
 public:
  static ScreenEnumeration::GetDisplaysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ScreenEnumeration_GetDisplays_ProxyToResponder> proxy(
        new ScreenEnumeration_GetDisplays_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ScreenEnumeration_GetDisplays_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenEnumeration_GetDisplays_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ScreenEnumeration_GetDisplays_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ScreenEnumeration::GetDisplaysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      DisplaysPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ScreenEnumeration_GetDisplays_ProxyToResponder);
};

bool ScreenEnumeration_GetDisplays_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ScreenEnumeration::GetDisplaysCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ScreenEnumeration_GetDisplays_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenEnumeration_GetDisplays_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  DisplaysPtr p_result{};
  ScreenEnumeration_GetDisplays_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenEnumeration::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ScreenEnumeration_GetDisplays_ProxyToResponder::Run(
    DisplaysPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ScreenEnumeration::GetDisplaysCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kScreenEnumeration_GetDisplays_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ScreenEnumeration_GetDisplays_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::DisplaysDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ScreenEnumeration::GetDisplaysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenEnumeration::Name_);
  message.set_method_name("GetDisplays");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class ScreenEnumeration_HasMultipleDisplays_ProxyToResponder {
 public:
  static ScreenEnumeration::HasMultipleDisplaysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<ScreenEnumeration_HasMultipleDisplays_ProxyToResponder> proxy(
        new ScreenEnumeration_HasMultipleDisplays_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&ScreenEnumeration_HasMultipleDisplays_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ScreenEnumeration_HasMultipleDisplays_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  ScreenEnumeration_HasMultipleDisplays_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "ScreenEnumeration::HasMultipleDisplaysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MultipleDisplays in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(ScreenEnumeration_HasMultipleDisplays_ProxyToResponder);
};

bool ScreenEnumeration_HasMultipleDisplays_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::ScreenEnumeration::HasMultipleDisplaysCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::ScreenEnumeration_HasMultipleDisplays_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ScreenEnumeration_HasMultipleDisplays_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  MultipleDisplays p_result{};
  ScreenEnumeration_HasMultipleDisplays_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ScreenEnumeration::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void ScreenEnumeration_HasMultipleDisplays_ProxyToResponder::Run(
    MultipleDisplays in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::ScreenEnumeration::HasMultipleDisplaysCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kScreenEnumeration_HasMultipleDisplays_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ScreenEnumeration_HasMultipleDisplays_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::MultipleDisplays>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::ScreenEnumeration::HasMultipleDisplaysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ScreenEnumeration::Name_);
  message.set_method_name("HasMultipleDisplays");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ScreenEnumerationStubDispatch::Accept(
    ScreenEnumeration* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kScreenEnumeration_GetDisplays_Name: {
      break;
    }
    case internal::kScreenEnumeration_HasMultipleDisplays_Name: {
      break;
    }
  }
  return false;
}

// static
bool ScreenEnumerationStubDispatch::AcceptWithResponder(
    ScreenEnumeration* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kScreenEnumeration_GetDisplays_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ScreenEnumeration::GetDisplays",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ScreenEnumeration::GetDisplays");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ScreenEnumeration_GetDisplays_Params_Data* params =
          reinterpret_cast<
              internal::ScreenEnumeration_GetDisplays_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ScreenEnumeration_GetDisplays_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenEnumeration::Name_, 0, false);
        return false;
      }
      ScreenEnumeration::GetDisplaysCallback callback =
          ScreenEnumeration_GetDisplays_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDisplays(std::move(callback));
      return true;
    }
    case internal::kScreenEnumeration_HasMultipleDisplays_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ScreenEnumeration::HasMultipleDisplays",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ScreenEnumeration::HasMultipleDisplays");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::ScreenEnumeration_HasMultipleDisplays_Params_Data* params =
          reinterpret_cast<
              internal::ScreenEnumeration_HasMultipleDisplays_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ScreenEnumeration_HasMultipleDisplays_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ScreenEnumeration::Name_, 1, false);
        return false;
      }
      ScreenEnumeration::HasMultipleDisplaysCallback callback =
          ScreenEnumeration_HasMultipleDisplays_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HasMultipleDisplays(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kScreenEnumerationValidationInfo[] = {
    {&internal::ScreenEnumeration_GetDisplays_Params_Data::Validate,
     &internal::ScreenEnumeration_GetDisplays_ResponseParams_Data::Validate},
    {&internal::ScreenEnumeration_HasMultipleDisplays_Params_Data::Validate,
     &internal::ScreenEnumeration_HasMultipleDisplays_ResponseParams_Data::Validate},
};

bool ScreenEnumerationRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ScreenEnumeration::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kScreenEnumerationValidationInfo);
}

bool ScreenEnumerationResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ScreenEnumeration::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kScreenEnumerationValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::Displays::DataView, ::blink::mojom::DisplaysPtr>::Read(
    ::blink::mojom::Displays::DataView input,
    ::blink::mojom::DisplaysPtr* output) {
  bool success = true;
  ::blink::mojom::DisplaysPtr result(::blink::mojom::Displays::New());
  
      if (success && !input.ReadDisplays(&result->displays))
        success = false;
      if (success)
        result->internal_id = input.internal_id();
      if (success)
        result->primary_id = input.primary_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif