// third_party/blink/public/mojom/page/page.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page_visibility_state.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"


#include "base/component_export.h"




namespace blink {
namespace mojom {
class PageLifecycleStateDataView;

class PageRestoreParamsDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PageLifecycleStateDataView> {
  using Data = ::blink::mojom::internal::PageLifecycleState_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::PageRestoreParamsDataView> {
  using Data = ::blink::mojom::internal::PageRestoreParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class PagehideDispatch : int32_t {
  
  kNotDispatched = 0,
  
  kDispatchedNotPersisted = 1,
  
  kDispatchedPersisted = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, PagehideDispatch value);
inline bool IsKnownEnumValue(PagehideDispatch value) {
  return internal::PagehideDispatch_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PageBroadcastInterfaceBase {};

using PageBroadcastPtrDataView =
    mojo::InterfacePtrDataView<PageBroadcastInterfaceBase>;
using PageBroadcastRequestDataView =
    mojo::InterfaceRequestDataView<PageBroadcastInterfaceBase>;
using PageBroadcastAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PageBroadcastInterfaceBase>;
using PageBroadcastAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PageBroadcastInterfaceBase>;


class PageLifecycleStateDataView {
 public:
  PageLifecycleStateDataView() {}

  PageLifecycleStateDataView(
      internal::PageLifecycleState_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool is_frozen() const {
    return data_->is_frozen;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadVisibility(UserType* output) const {
    auto data_value = data_->visibility;
    return mojo::internal::Deserialize<::blink::mojom::PageVisibilityState>(
        data_value, output);
  }

  ::blink::mojom::PageVisibilityState visibility() const {
    return static_cast<::blink::mojom::PageVisibilityState>(data_->visibility);
  }
  bool is_in_back_forward_cache() const {
    return data_->is_in_back_forward_cache;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPagehideDispatch(UserType* output) const {
    auto data_value = data_->pagehide_dispatch;
    return mojo::internal::Deserialize<::blink::mojom::PagehideDispatch>(
        data_value, output);
  }

  PagehideDispatch pagehide_dispatch() const {
    return static_cast<PagehideDispatch>(data_->pagehide_dispatch);
  }
 private:
  internal::PageLifecycleState_Data* data_ = nullptr;
};



class PageRestoreParamsDataView {
 public:
  PageRestoreParamsDataView() {}

  PageRestoreParamsDataView(
      internal::PageRestoreParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetNavigationStartDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadNavigationStart(UserType* output) {
    
    auto* pointer = data_->navigation_start.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  int32_t pending_history_list_offset() const {
    return data_->pending_history_list_offset;
  }
  int32_t current_history_list_length() const {
    return data_->current_history_list_length;
  }
 private:
  internal::PageRestoreParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::PagehideDispatch>
    : public mojo::internal::EnumHashImpl<::blink::mojom::PagehideDispatch> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::PagehideDispatch, ::blink::mojom::PagehideDispatch> {
  static ::blink::mojom::PagehideDispatch ToMojom(::blink::mojom::PagehideDispatch input) { return input; }
  static bool FromMojom(::blink::mojom::PagehideDispatch input, ::blink::mojom::PagehideDispatch* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PagehideDispatch, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::PagehideDispatch, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::PagehideDispatch>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PageLifecycleStateDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageLifecycleStateDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PageLifecycleState_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->is_frozen = Traits::is_frozen(input);
    mojo::internal::Serialize<::blink::mojom::PageVisibilityState>(
        Traits::visibility(input), &(*output)->visibility);
    (*output)->is_in_back_forward_cache = Traits::is_in_back_forward_cache(input);
    mojo::internal::Serialize<::blink::mojom::PagehideDispatch>(
        Traits::pagehide_dispatch(input), &(*output)->pagehide_dispatch);
  }

  static bool Deserialize(::blink::mojom::internal::PageLifecycleState_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PageLifecycleStateDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::PageRestoreParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageRestoreParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::PageRestoreParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::navigation_start(input)) in_navigation_start = Traits::navigation_start(input);
    typename decltype((*output)->navigation_start)::BaseType::BufferWriter
        navigation_start_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
        in_navigation_start, buffer, &navigation_start_writer, context);
    (*output)->navigation_start.Set(
        navigation_start_writer.is_null() ? nullptr : navigation_start_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->navigation_start.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_start in PageRestoreParams struct");
    (*output)->pending_history_list_offset = Traits::pending_history_list_offset(input);
    (*output)->current_history_list_length = Traits::current_history_list_length(input);
  }

  static bool Deserialize(::blink::mojom::internal::PageRestoreParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::PageRestoreParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {



inline void PageRestoreParamsDataView::GetNavigationStartDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->navigation_start.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SHARED_H_