// services/network/public/mojom/quic_transport.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/quic_transport.mojom-shared.h"
#include "services/network/public/mojom/quic_transport.mojom-forward.h"
#include "mojo/public/mojom/base/read_only_buffer.mojom.h"
#include "url/mojom/url.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/network/public/cpp/quic_transport_error_mojom_traits.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class QuicTransportProxy;

template <typename ImplRefTraits>
class QuicTransportStub;

class QuicTransportRequestValidator;
class QuicTransportResponseValidator;


class  QuicTransport
    : public QuicTransportInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = QuicTransportInterfaceBase;
  using Proxy_ = QuicTransportProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuicTransportStub<ImplRefTraits>;

  using RequestValidator_ = QuicTransportRequestValidator;
  using ResponseValidator_ = QuicTransportResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSendDatagramMinVersion = 0,
    kCreateStreamMinVersion = 0,
    kAcceptBidirectionalStreamMinVersion = 0,
    kAcceptUnidirectionalStreamMinVersion = 0,
    kSendFinMinVersion = 0,
    kAbortStreamMinVersion = 0,
  };
  virtual ~QuicTransport() {}


  using SendDatagramCallback = base::OnceCallback<void(bool)>;
  
  virtual void SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) = 0;


  using CreateStreamCallback = base::OnceCallback<void(bool, uint32_t)>;
  
  virtual void CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) = 0;


  using AcceptBidirectionalStreamCallback = base::OnceCallback<void(uint32_t, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  
  virtual void AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) = 0;


  using AcceptUnidirectionalStreamCallback = base::OnceCallback<void(uint32_t, ::mojo::ScopedDataPipeConsumerHandle)>;
  
  virtual void AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) = 0;

  
  virtual void SendFin(uint32_t stream_id) = 0;

  
  virtual void AbortStream(uint32_t stream_id, uint64_t code) = 0;
};

class QuicTransportClientProxy;

template <typename ImplRefTraits>
class QuicTransportClientStub;

class QuicTransportClientRequestValidator;


class  QuicTransportClient
    : public QuicTransportClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = QuicTransportClientInterfaceBase;
  using Proxy_ = QuicTransportClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuicTransportClientStub<ImplRefTraits>;

  using RequestValidator_ = QuicTransportClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnDatagramReceivedMinVersion = 0,
    kOnIncomingStreamClosedMinVersion = 0,
  };
  virtual ~QuicTransportClient() {}

  
  virtual void OnDatagramReceived(::base::span<const ::uint8_t> data) = 0;

  
  virtual void OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) = 0;
};

class QuicTransportHandshakeClientProxy;

template <typename ImplRefTraits>
class QuicTransportHandshakeClientStub;

class QuicTransportHandshakeClientRequestValidator;


class  QuicTransportHandshakeClient
    : public QuicTransportHandshakeClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = QuicTransportHandshakeClientInterfaceBase;
  using Proxy_ = QuicTransportHandshakeClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuicTransportHandshakeClientStub<ImplRefTraits>;

  using RequestValidator_ = QuicTransportHandshakeClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnConnectionEstablishedMinVersion = 0,
    kOnHandshakeFailedMinVersion = 0,
  };
  virtual ~QuicTransportHandshakeClient() {}

  
  virtual void OnConnectionEstablished(::mojo::PendingRemote<QuicTransport> transport, ::mojo::PendingReceiver<QuicTransportClient> client) = 0;

  
  virtual void OnHandshakeFailed(const base::Optional<::net::QuicTransportError>& error) = 0;
};



class  QuicTransportProxy
    : public QuicTransport {
 public:
  using InterfaceType = QuicTransport;

  explicit QuicTransportProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SendDatagram(::base::span<const ::uint8_t> data, SendDatagramCallback callback) final;
  
  void CreateStream(::mojo::ScopedDataPipeConsumerHandle readable, ::mojo::ScopedDataPipeProducerHandle writable, CreateStreamCallback callback) final;
  
  void AcceptBidirectionalStream(AcceptBidirectionalStreamCallback callback) final;
  
  void AcceptUnidirectionalStream(AcceptUnidirectionalStreamCallback callback) final;
  
  void SendFin(uint32_t stream_id) final;
  
  void AbortStream(uint32_t stream_id, uint64_t code) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  QuicTransportClientProxy
    : public QuicTransportClient {
 public:
  using InterfaceType = QuicTransportClient;

  explicit QuicTransportClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnDatagramReceived(::base::span<const ::uint8_t> data) final;
  
  void OnIncomingStreamClosed(uint32_t stream_id, bool fin_received) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  QuicTransportHandshakeClientProxy
    : public QuicTransportHandshakeClient {
 public:
  using InterfaceType = QuicTransportHandshakeClient;

  explicit QuicTransportHandshakeClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnConnectionEstablished(::mojo::PendingRemote<QuicTransport> transport, ::mojo::PendingReceiver<QuicTransportClient> client) final;
  
  void OnHandshakeFailed(const base::Optional<::net::QuicTransportError>& error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  QuicTransportStubDispatch {
 public:
  static bool Accept(QuicTransport* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      QuicTransport* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<QuicTransport>>
class QuicTransportStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuicTransportStub() {}
  ~QuicTransportStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuicTransportStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuicTransportStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  QuicTransportClientStubDispatch {
 public:
  static bool Accept(QuicTransportClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      QuicTransportClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<QuicTransportClient>>
class QuicTransportClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuicTransportClientStub() {}
  ~QuicTransportClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuicTransportClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuicTransportClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  QuicTransportHandshakeClientStubDispatch {
 public:
  static bool Accept(QuicTransportHandshakeClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      QuicTransportHandshakeClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<QuicTransportHandshakeClient>>
class QuicTransportHandshakeClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuicTransportHandshakeClientStub() {}
  ~QuicTransportHandshakeClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuicTransportHandshakeClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuicTransportHandshakeClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  QuicTransportRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  QuicTransportClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  QuicTransportHandshakeClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  QuicTransportResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class  QuicTransportError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QuicTransportError, T>::value>;
  using DataView = QuicTransportErrorDataView;
  using Data_ = internal::QuicTransportError_Data;

  template <typename... Args>
  static QuicTransportErrorPtr New(Args&&... args) {
    return QuicTransportErrorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QuicTransportErrorPtr From(const U& u) {
    return mojo::TypeConverter<QuicTransportErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QuicTransportError>::Convert(*this);
  }


  QuicTransportError();

  QuicTransportError(
      int32_t net_error,
      int32_t quic_error,
      const std::string& details,
      bool safe_to_report_details);

  ~QuicTransportError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QuicTransportErrorPtr>
  QuicTransportErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QuicTransportError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuicTransportError::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QuicTransportError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QuicTransportError_UnserializedMessageContext<
            UserType, QuicTransportError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<QuicTransportError::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return QuicTransportError::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QuicTransportError_UnserializedMessageContext<
            UserType, QuicTransportError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QuicTransportError::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t net_error;
  
  int32_t quic_error;
  
  std::string details;
  
  bool safe_to_report_details;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QuicTransportError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QuicTransportError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QuicTransportError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QuicTransportError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  QuicTransportCertificateFingerprint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QuicTransportCertificateFingerprint, T>::value>;
  using DataView = QuicTransportCertificateFingerprintDataView;
  using Data_ = internal::QuicTransportCertificateFingerprint_Data;

  template <typename... Args>
  static QuicTransportCertificateFingerprintPtr New(Args&&... args) {
    return QuicTransportCertificateFingerprintPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QuicTransportCertificateFingerprintPtr From(const U& u) {
    return mojo::TypeConverter<QuicTransportCertificateFingerprintPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QuicTransportCertificateFingerprint>::Convert(*this);
  }


  QuicTransportCertificateFingerprint();

  QuicTransportCertificateFingerprint(
      const std::string& algorithm,
      const std::string& fingerprint);

  ~QuicTransportCertificateFingerprint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QuicTransportCertificateFingerprintPtr>
  QuicTransportCertificateFingerprintPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QuicTransportCertificateFingerprint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QuicTransportCertificateFingerprint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QuicTransportCertificateFingerprint_UnserializedMessageContext<
            UserType, QuicTransportCertificateFingerprint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<QuicTransportCertificateFingerprint::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return QuicTransportCertificateFingerprint::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QuicTransportCertificateFingerprint_UnserializedMessageContext<
            UserType, QuicTransportCertificateFingerprint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QuicTransportCertificateFingerprint::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::string algorithm;
  
  std::string fingerprint;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





template <typename StructPtrType>
QuicTransportErrorPtr QuicTransportError::Clone() const {
  return New(
      mojo::Clone(net_error),
      mojo::Clone(quic_error),
      mojo::Clone(details),
      mojo::Clone(safe_to_report_details)
  );
}

template <typename T, QuicTransportError::EnableIfSame<T>*>
bool QuicTransportError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->net_error, other_struct.net_error))
    return false;
  if (!mojo::Equals(this->quic_error, other_struct.quic_error))
    return false;
  if (!mojo::Equals(this->details, other_struct.details))
    return false;
  if (!mojo::Equals(this->safe_to_report_details, other_struct.safe_to_report_details))
    return false;
  return true;
}

template <typename T, QuicTransportError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.net_error, rhs.net_error))
    return true;
  if (std::less<>{}(rhs.net_error, lhs.net_error))
    return false;
  if (std::less<>{}(lhs.quic_error, rhs.quic_error))
    return true;
  if (std::less<>{}(rhs.quic_error, lhs.quic_error))
    return false;
  if (std::less<>{}(lhs.details, rhs.details))
    return true;
  if (std::less<>{}(rhs.details, lhs.details))
    return false;
  if (std::less<>{}(lhs.safe_to_report_details, rhs.safe_to_report_details))
    return true;
  if (std::less<>{}(rhs.safe_to_report_details, lhs.safe_to_report_details))
    return false;
  return false;
}
template <typename StructPtrType>
QuicTransportCertificateFingerprintPtr QuicTransportCertificateFingerprint::Clone() const {
  return New(
      mojo::Clone(algorithm),
      mojo::Clone(fingerprint)
  );
}

template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>*>
bool QuicTransportCertificateFingerprint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->algorithm, other_struct.algorithm))
    return false;
  if (!mojo::Equals(this->fingerprint, other_struct.fingerprint))
    return false;
  return true;
}

template <typename T, QuicTransportCertificateFingerprint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.algorithm, rhs.algorithm))
    return true;
  if (std::less<>{}(rhs.algorithm, lhs.algorithm))
    return false;
  if (std::less<>{}(lhs.fingerprint, rhs.fingerprint))
    return true;
  if (std::less<>{}(rhs.fingerprint, lhs.fingerprint))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::QuicTransportError::DataView,
                                         ::network::mojom::QuicTransportErrorPtr> {
  static bool IsNull(const ::network::mojom::QuicTransportErrorPtr& input) { return !input; }
  static void SetToNull(::network::mojom::QuicTransportErrorPtr* output) { output->reset(); }

  static decltype(::network::mojom::QuicTransportError::net_error) net_error(
      const ::network::mojom::QuicTransportErrorPtr& input) {
    return input->net_error;
  }

  static decltype(::network::mojom::QuicTransportError::quic_error) quic_error(
      const ::network::mojom::QuicTransportErrorPtr& input) {
    return input->quic_error;
  }

  static const decltype(::network::mojom::QuicTransportError::details)& details(
      const ::network::mojom::QuicTransportErrorPtr& input) {
    return input->details;
  }

  static decltype(::network::mojom::QuicTransportError::safe_to_report_details) safe_to_report_details(
      const ::network::mojom::QuicTransportErrorPtr& input) {
    return input->safe_to_report_details;
  }

  static bool Read(::network::mojom::QuicTransportError::DataView input, ::network::mojom::QuicTransportErrorPtr* output);
};


template <>
struct  StructTraits<::network::mojom::QuicTransportCertificateFingerprint::DataView,
                                         ::network::mojom::QuicTransportCertificateFingerprintPtr> {
  static bool IsNull(const ::network::mojom::QuicTransportCertificateFingerprintPtr& input) { return !input; }
  static void SetToNull(::network::mojom::QuicTransportCertificateFingerprintPtr* output) { output->reset(); }

  static const decltype(::network::mojom::QuicTransportCertificateFingerprint::algorithm)& algorithm(
      const ::network::mojom::QuicTransportCertificateFingerprintPtr& input) {
    return input->algorithm;
  }

  static const decltype(::network::mojom::QuicTransportCertificateFingerprint::fingerprint)& fingerprint(
      const ::network::mojom::QuicTransportCertificateFingerprintPtr& input) {
    return input->fingerprint;
  }

  static bool Read(::network::mojom::QuicTransportCertificateFingerprint::DataView input, ::network::mojom::QuicTransportCertificateFingerprintPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_QUIC_TRANSPORT_MOJOM_H_