// services/network/public/mojom/network_service_test.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/network_service_test.mojom-shared.h"
#include "services/network/public/mojom/network_service_test.mojom-forward.h"
#include "mojo/public/mojom/base/memory_pressure_level.mojom.h"
#include "services/network/public/mojom/network_change_manager.mojom-forward.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/network_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class NetworkServiceTestProxy;

template <typename ImplRefTraits>
class NetworkServiceTestStub;

class NetworkServiceTestRequestValidator;
class NetworkServiceTestResponseValidator;


class  NetworkServiceTest
    : public NetworkServiceTestInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = NetworkServiceTestInterfaceBase;
  using Proxy_ = NetworkServiceTestProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkServiceTestStub<ImplRefTraits>;

  using RequestValidator_ = NetworkServiceTestRequestValidator;
  using ResponseValidator_ = NetworkServiceTestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddRulesMinVersion = 0,
    kSimulateNetworkChangeMinVersion = 0,
    kSimulateNetworkQualityChangeMinVersion = 0,
    kSimulateCrashMinVersion = 0,
    kMockCertVerifierSetDefaultResultMinVersion = 0,
    kMockCertVerifierAddResultForCertAndHostMinVersion = 0,
    kSetRequireCTMinVersion = 0,
    kSetTransportSecurityStateSourceMinVersion = 0,
    kSetAllowNetworkAccessToHostResolutionsMinVersion = 0,
    kCrashOnResolveHostMinVersion = 0,
    kCrashOnGetCookieListMinVersion = 0,
    kGetLatestMemoryPressureLevelMinVersion = 0,
    kGetPeerToPeerConnectionsCountChangeMinVersion = 0,
    kGetEnvironmentVariableValueMinVersion = 0,
    kLogMinVersion = 0,
    kActivateFieldTrialMinVersion = 0,
    kSetEVPolicyMinVersion = 0,
  };
  
  using RequireCT = NetworkServiceTest_RequireCT;
  virtual ~NetworkServiceTest() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AddRules(std::vector<RulePtr> rules);

  using AddRulesCallback = base::OnceCallback<void()>;
  
  virtual void AddRules(std::vector<RulePtr> rules, AddRulesCallback callback) = 0;


  using SimulateNetworkChangeCallback = base::OnceCallback<void()>;
  
  virtual void SimulateNetworkChange(::network::mojom::ConnectionType type, SimulateNetworkChangeCallback callback) = 0;


  using SimulateNetworkQualityChangeCallback = base::OnceCallback<void()>;
  
  virtual void SimulateNetworkQualityChange(::net::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) = 0;

  
  virtual void SimulateCrash() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MockCertVerifierSetDefaultResult(int32_t default_result);

  using MockCertVerifierSetDefaultResultCallback = base::OnceCallback<void()>;
  
  virtual void MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv);

  using MockCertVerifierAddResultForCertAndHostCallback = base::OnceCallback<void()>;
  
  virtual void MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetRequireCT(NetworkServiceTest::RequireCT required);

  using SetRequireCTCallback = base::OnceCallback<void()>;
  
  virtual void SetRequireCT(NetworkServiceTest::RequireCT required, SetRequireCTCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetTransportSecurityStateSource(uint16_t reporting_port);

  using SetTransportSecurityStateSourceCallback = base::OnceCallback<void()>;
  
  virtual void SetTransportSecurityStateSource(uint16_t reporting_port, SetTransportSecurityStateSourceCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetAllowNetworkAccessToHostResolutions();

  using SetAllowNetworkAccessToHostResolutionsCallback = base::OnceCallback<void()>;
  
  virtual void SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) = 0;

  
  virtual void CrashOnResolveHost(const std::string& host) = 0;

  
  virtual void CrashOnGetCookieList() = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetLatestMemoryPressureLevel(::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level);

  using GetLatestMemoryPressureLevelCallback = base::OnceCallback<void(::base::MemoryPressureListener::MemoryPressureLevel)>;
  
  virtual void GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPeerToPeerConnectionsCountChange(uint32_t* out_connection_count);

  using GetPeerToPeerConnectionsCountChangeCallback = base::OnceCallback<void(uint32_t)>;
  
  virtual void GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetEnvironmentVariableValue(const std::string& name, std::string* out_value);

  using GetEnvironmentVariableValueCallback = base::OnceCallback<void(const std::string&)>;
  
  virtual void GetEnvironmentVariableValue(const std::string& name, GetEnvironmentVariableValueCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Log(const std::string& message);

  using LogCallback = base::OnceCallback<void()>;
  
  virtual void Log(const std::string& message, LogCallback callback) = 0;

  
  virtual void ActivateFieldTrial(const std::string& field_trial_name) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetEVPolicy(const std::vector<uint8_t>& fingerprint_sha256, const std::string& policy_oid);

  using SetEVPolicyCallback = base::OnceCallback<void()>;
  
  virtual void SetEVPolicy(const std::vector<uint8_t>& fingerprint_sha256, const std::string& policy_oid, SetEVPolicyCallback callback) = 0;
};



class  NetworkServiceTestProxy
    : public NetworkServiceTest {
 public:
  using InterfaceType = NetworkServiceTest;

  explicit NetworkServiceTestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool AddRules(std::vector<RulePtr> rules) final;
  
  void AddRules(std::vector<RulePtr> rules, AddRulesCallback callback) final;
  
  void SimulateNetworkChange(::network::mojom::ConnectionType type, SimulateNetworkChangeCallback callback) final;
  
  void SimulateNetworkQualityChange(::net::EffectiveConnectionType type, SimulateNetworkQualityChangeCallback callback) final;
  
  void SimulateCrash() final;
  
  bool MockCertVerifierSetDefaultResult(int32_t default_result) final;
  
  void MockCertVerifierSetDefaultResult(int32_t default_result, MockCertVerifierSetDefaultResultCallback callback) final;
  
  bool MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv) final;
  
  void MockCertVerifierAddResultForCertAndHost(const ::scoped_refptr<::net::X509Certificate>& cert, const std::string& host_pattern, const ::net::CertVerifyResult& verify_result, int32_t rv, MockCertVerifierAddResultForCertAndHostCallback callback) final;
  
  bool SetRequireCT(NetworkServiceTest::RequireCT required) final;
  
  void SetRequireCT(NetworkServiceTest::RequireCT required, SetRequireCTCallback callback) final;
  
  bool SetTransportSecurityStateSource(uint16_t reporting_port) final;
  
  void SetTransportSecurityStateSource(uint16_t reporting_port, SetTransportSecurityStateSourceCallback callback) final;
  
  bool SetAllowNetworkAccessToHostResolutions() final;
  
  void SetAllowNetworkAccessToHostResolutions(SetAllowNetworkAccessToHostResolutionsCallback callback) final;
  
  void CrashOnResolveHost(const std::string& host) final;
  
  void CrashOnGetCookieList() final;
  
  bool GetLatestMemoryPressureLevel(::base::MemoryPressureListener::MemoryPressureLevel* out_memory_pressure_level) final;
  
  void GetLatestMemoryPressureLevel(GetLatestMemoryPressureLevelCallback callback) final;
  
  bool GetPeerToPeerConnectionsCountChange(uint32_t* out_connection_count) final;
  
  void GetPeerToPeerConnectionsCountChange(GetPeerToPeerConnectionsCountChangeCallback callback) final;
  
  bool GetEnvironmentVariableValue(const std::string& name, std::string* out_value) final;
  
  void GetEnvironmentVariableValue(const std::string& name, GetEnvironmentVariableValueCallback callback) final;
  
  bool Log(const std::string& message) final;
  
  void Log(const std::string& message, LogCallback callback) final;
  
  void ActivateFieldTrial(const std::string& field_trial_name) final;
  
  bool SetEVPolicy(const std::vector<uint8_t>& fingerprint_sha256, const std::string& policy_oid) final;
  
  void SetEVPolicy(const std::vector<uint8_t>& fingerprint_sha256, const std::string& policy_oid, SetEVPolicyCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  NetworkServiceTestStubDispatch {
 public:
  static bool Accept(NetworkServiceTest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkServiceTest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkServiceTest>>
class NetworkServiceTestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkServiceTestStub() {}
  ~NetworkServiceTestStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceTestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkServiceTestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkServiceTestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkServiceTestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  Rule {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Rule, T>::value>;
  using DataView = RuleDataView;
  using Data_ = internal::Rule_Data;

  template <typename... Args>
  static RulePtr New(Args&&... args) {
    return RulePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RulePtr From(const U& u) {
    return mojo::TypeConverter<RulePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Rule>::Convert(*this);
  }


  Rule();

  Rule(
      ResolverType resolver_type,
      const std::string& host_pattern,
      const std::string& replacement,
      int32_t host_resolver_flags,
      const std::string& canonical_name);

  ~Rule();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RulePtr>
  RulePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Rule::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Rule::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Rule::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Rule_UnserializedMessageContext<
            UserType, Rule::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<Rule::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return Rule::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Rule_UnserializedMessageContext<
            UserType, Rule::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Rule::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ResolverType resolver_type;
  
  std::string host_pattern;
  
  std::string replacement;
  
  int32_t host_resolver_flags;
  
  std::string canonical_name;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Rule::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RulePtr Rule::Clone() const {
  return New(
      mojo::Clone(resolver_type),
      mojo::Clone(host_pattern),
      mojo::Clone(replacement),
      mojo::Clone(host_resolver_flags),
      mojo::Clone(canonical_name)
  );
}

template <typename T, Rule::EnableIfSame<T>*>
bool Rule::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->resolver_type, other_struct.resolver_type))
    return false;
  if (!mojo::Equals(this->host_pattern, other_struct.host_pattern))
    return false;
  if (!mojo::Equals(this->replacement, other_struct.replacement))
    return false;
  if (!mojo::Equals(this->host_resolver_flags, other_struct.host_resolver_flags))
    return false;
  if (!mojo::Equals(this->canonical_name, other_struct.canonical_name))
    return false;
  return true;
}

template <typename T, Rule::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.resolver_type, rhs.resolver_type))
    return true;
  if (std::less<>{}(rhs.resolver_type, lhs.resolver_type))
    return false;
  if (std::less<>{}(lhs.host_pattern, rhs.host_pattern))
    return true;
  if (std::less<>{}(rhs.host_pattern, lhs.host_pattern))
    return false;
  if (std::less<>{}(lhs.replacement, rhs.replacement))
    return true;
  if (std::less<>{}(rhs.replacement, lhs.replacement))
    return false;
  if (std::less<>{}(lhs.host_resolver_flags, rhs.host_resolver_flags))
    return true;
  if (std::less<>{}(rhs.host_resolver_flags, lhs.host_resolver_flags))
    return false;
  if (std::less<>{}(lhs.canonical_name, rhs.canonical_name))
    return true;
  if (std::less<>{}(rhs.canonical_name, lhs.canonical_name))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::Rule::DataView,
                                         ::network::mojom::RulePtr> {
  static bool IsNull(const ::network::mojom::RulePtr& input) { return !input; }
  static void SetToNull(::network::mojom::RulePtr* output) { output->reset(); }

  static decltype(::network::mojom::Rule::resolver_type) resolver_type(
      const ::network::mojom::RulePtr& input) {
    return input->resolver_type;
  }

  static const decltype(::network::mojom::Rule::host_pattern)& host_pattern(
      const ::network::mojom::RulePtr& input) {
    return input->host_pattern;
  }

  static const decltype(::network::mojom::Rule::replacement)& replacement(
      const ::network::mojom::RulePtr& input) {
    return input->replacement;
  }

  static decltype(::network::mojom::Rule::host_resolver_flags) host_resolver_flags(
      const ::network::mojom::RulePtr& input) {
    return input->host_resolver_flags;
  }

  static const decltype(::network::mojom::Rule::canonical_name)& canonical_name(
      const ::network::mojom::RulePtr& input) {
    return input->canonical_name;
  }

  static bool Read(::network::mojom::Rule::DataView input, ::network::mojom::RulePtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_TEST_MOJOM_H_