// services/media_session/public/mojom/media_session_service.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_SERVICE_MOJOM_H_
#define SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_SERVICE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/media_session/public/mojom/media_session_service.mojom-shared.h"
#include "services/media_session/public/mojom/media_session_service.mojom-forward.h"
#include "services/media_session/public/mojom/audio_focus.mojom.h"
#include "services/media_session/public/mojom/media_controller.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace media_session {
namespace mojom {

class MediaSessionServiceProxy;

template <typename ImplRefTraits>
class MediaSessionServiceStub;

class MediaSessionServiceRequestValidator;


class  MediaSessionService
    : public MediaSessionServiceInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = MediaSessionServiceInterfaceBase;
  using Proxy_ = MediaSessionServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = MediaSessionServiceStub<ImplRefTraits>;

  using RequestValidator_ = MediaSessionServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kBindAudioFocusManagerMinVersion = 0,
    kBindAudioFocusManagerDebugMinVersion = 0,
    kBindMediaControllerManagerMinVersion = 0,
  };
  virtual ~MediaSessionService() {}

  
  virtual void BindAudioFocusManager(::mojo::PendingReceiver<::media_session::mojom::AudioFocusManager> receiver) = 0;

  
  virtual void BindAudioFocusManagerDebug(::mojo::PendingReceiver<::media_session::mojom::AudioFocusManagerDebug> receiver) = 0;

  
  virtual void BindMediaControllerManager(::mojo::PendingReceiver<::media_session::mojom::MediaControllerManager> receiver) = 0;
};



class  MediaSessionServiceProxy
    : public MediaSessionService {
 public:
  using InterfaceType = MediaSessionService;

  explicit MediaSessionServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindAudioFocusManager(::mojo::PendingReceiver<::media_session::mojom::AudioFocusManager> receiver) final;
  
  void BindAudioFocusManagerDebug(::mojo::PendingReceiver<::media_session::mojom::AudioFocusManagerDebug> receiver) final;
  
  void BindMediaControllerManager(::mojo::PendingReceiver<::media_session::mojom::MediaControllerManager> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MediaSessionServiceStubDispatch {
 public:
  static bool Accept(MediaSessionService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MediaSessionService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MediaSessionService>>
class MediaSessionServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MediaSessionServiceStub() {}
  ~MediaSessionServiceStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MediaSessionServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MediaSessionServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace media_session

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_MEDIA_SESSION_PUBLIC_MOJOM_MEDIA_SESSION_SERVICE_MOJOM_H_