// services/device/public/mojom/nfc.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_BLINK_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/device/public/mojom/nfc.mojom-shared.h"
#include "services/device/public/mojom/nfc.mojom-blink-forward.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/platform/web_common.h"




namespace WTF {
struct device_mojom_internal_NDEFErrorType_DataHashFn {
  static unsigned GetHash(const ::device::mojom::NDEFErrorType& value) {
    using utype = std::underlying_type<::device::mojom::NDEFErrorType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::NDEFErrorType& left, const ::device::mojom::NDEFErrorType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::NDEFErrorType>
    : public GenericHashTraits<::device::mojom::NDEFErrorType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::NDEFErrorType& value) {
    return value == static_cast<::device::mojom::NDEFErrorType>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::NDEFErrorType& slot, bool) {
    slot = static_cast<::device::mojom::NDEFErrorType>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::NDEFErrorType& value) {
    return value == static_cast<::device::mojom::NDEFErrorType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct device_mojom_internal_NDEFRecordTypeCategory_DataHashFn {
  static unsigned GetHash(const ::device::mojom::NDEFRecordTypeCategory& value) {
    using utype = std::underlying_type<::device::mojom::NDEFRecordTypeCategory>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::device::mojom::NDEFRecordTypeCategory& left, const ::device::mojom::NDEFRecordTypeCategory& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::device::mojom::NDEFRecordTypeCategory>
    : public GenericHashTraits<::device::mojom::NDEFRecordTypeCategory> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::device::mojom::NDEFRecordTypeCategory& value) {
    return value == static_cast<::device::mojom::NDEFRecordTypeCategory>(-1000000);
  }
  static void ConstructDeletedValue(::device::mojom::NDEFRecordTypeCategory& slot, bool) {
    slot = static_cast<::device::mojom::NDEFRecordTypeCategory>(-1000001);
  }
  static bool IsDeletedValue(const ::device::mojom::NDEFRecordTypeCategory& value) {
    return value == static_cast<::device::mojom::NDEFRecordTypeCategory>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace device {
namespace mojom {
namespace blink {

class NFCProxy;

template <typename ImplRefTraits>
class NFCStub;

class NFCRequestValidator;
class NFCResponseValidator;


class BLINK_PLATFORM_EXPORT NFC
    : public NFCInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NFCInterfaceBase;
  using Proxy_ = NFCProxy;

  template <typename ImplRefTraits>
  using Stub_ = NFCStub<ImplRefTraits>;

  using RequestValidator_ = NFCRequestValidator;
  using ResponseValidator_ = NFCResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kPushMinVersion = 0,
    kCancelPushMinVersion = 0,
    kWatchMinVersion = 0,
    kCancelWatchMinVersion = 0,
    kCancelAllWatchesMinVersion = 0,
  };
  virtual ~NFC() {}

  
  virtual void SetClient(::mojo::PendingRemote<NFCClient> client) = 0;


  using PushCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  
  virtual void Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) = 0;


  using CancelPushCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  
  virtual void CancelPush(CancelPushCallback callback) = 0;


  using WatchCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  
  virtual void Watch(uint32_t id, WatchCallback callback) = 0;


  using CancelWatchCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  
  virtual void CancelWatch(uint32_t id, CancelWatchCallback callback) = 0;


  using CancelAllWatchesCallback = base::OnceCallback<void(NDEFErrorPtr)>;
  
  virtual void CancelAllWatches(CancelAllWatchesCallback callback) = 0;
};

class NFCClientProxy;

template <typename ImplRefTraits>
class NFCClientStub;

class NFCClientRequestValidator;


class BLINK_PLATFORM_EXPORT NFCClient
    : public NFCClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NFCClientInterfaceBase;
  using Proxy_ = NFCClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NFCClientStub<ImplRefTraits>;

  using RequestValidator_ = NFCClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnWatchMinVersion = 0,
    kOnErrorMinVersion = 0,
  };
  virtual ~NFCClient() {}

  
  virtual void OnWatch(const WTF::Vector<uint32_t>& watch_ids, const WTF::String& serial_number, NDEFMessagePtr message) = 0;

  
  virtual void OnError(NDEFErrorPtr error) = 0;
};



class BLINK_PLATFORM_EXPORT NFCProxy
    : public NFC {
 public:
  using InterfaceType = NFC;

  explicit NFCProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<NFCClient> client) final;
  
  void Push(NDEFMessagePtr message, NDEFWriteOptionsPtr options, PushCallback callback) final;
  
  void CancelPush(CancelPushCallback callback) final;
  
  void Watch(uint32_t id, WatchCallback callback) final;
  
  void CancelWatch(uint32_t id, CancelWatchCallback callback) final;
  
  void CancelAllWatches(CancelAllWatchesCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_PLATFORM_EXPORT NFCClientProxy
    : public NFCClient {
 public:
  using InterfaceType = NFCClient;

  explicit NFCClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnWatch(const WTF::Vector<uint32_t>& watch_ids, const WTF::String& serial_number, NDEFMessagePtr message) final;
  
  void OnError(NDEFErrorPtr error) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT NFCStubDispatch {
 public:
  static bool Accept(NFC* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NFC* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NFC>>
class NFCStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NFCStub() {}
  ~NFCStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT NFCClientStubDispatch {
 public:
  static bool Accept(NFCClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NFCClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NFCClient>>
class NFCClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NFCClientStub() {}
  ~NFCClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NFCClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT NFCRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT NFCClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT NFCResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT NDEFError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFError, T>::value>;
  using DataView = NDEFErrorDataView;
  using Data_ = internal::NDEFError_Data;

  template <typename... Args>
  static NDEFErrorPtr New(Args&&... args) {
    return NDEFErrorPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFErrorPtr From(const U& u) {
    return mojo::TypeConverter<NDEFErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFError>::Convert(*this);
  }


  NDEFError();

  NDEFError(
      NDEFErrorType error_type,
      const WTF::String& error_message);

  ~NDEFError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFErrorPtr>
  NDEFErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFError::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFError_UnserializedMessageContext<
            UserType, NDEFError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NDEFError::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return NDEFError::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFError_UnserializedMessageContext<
            UserType, NDEFError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFError::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  NDEFErrorType error_type;
  
  WTF::String error_message;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class BLINK_PLATFORM_EXPORT NDEFWriteOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFWriteOptions, T>::value>;
  using DataView = NDEFWriteOptionsDataView;
  using Data_ = internal::NDEFWriteOptions_Data;

  template <typename... Args>
  static NDEFWriteOptionsPtr New(Args&&... args) {
    return NDEFWriteOptionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFWriteOptionsPtr From(const U& u) {
    return mojo::TypeConverter<NDEFWriteOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFWriteOptions>::Convert(*this);
  }


  NDEFWriteOptions();

  explicit NDEFWriteOptions(
      bool overwrite);

  ~NDEFWriteOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFWriteOptionsPtr>
  NDEFWriteOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFWriteOptions::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFWriteOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFWriteOptions_UnserializedMessageContext<
            UserType, NDEFWriteOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NDEFWriteOptions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return NDEFWriteOptions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFWriteOptions_UnserializedMessageContext<
            UserType, NDEFWriteOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFWriteOptions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool overwrite;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class BLINK_PLATFORM_EXPORT NDEFRecord {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFRecord, T>::value>;
  using DataView = NDEFRecordDataView;
  using Data_ = internal::NDEFRecord_Data;

  template <typename... Args>
  static NDEFRecordPtr New(Args&&... args) {
    return NDEFRecordPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFRecordPtr From(const U& u) {
    return mojo::TypeConverter<NDEFRecordPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFRecord>::Convert(*this);
  }


  NDEFRecord();

  NDEFRecord(
      NDEFRecordTypeCategory category,
      const WTF::String& record_type,
      const WTF::String& media_type,
      const WTF::String& id,
      const WTF::String& encoding,
      const WTF::String& lang,
      WTF::Vector<uint8_t> data,
      NDEFMessagePtr payload_message);

  ~NDEFRecord();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFRecordPtr>
  NDEFRecordPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFRecord::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFRecord::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFRecord_UnserializedMessageContext<
            UserType, NDEFRecord::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NDEFRecord::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return NDEFRecord::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFRecord_UnserializedMessageContext<
            UserType, NDEFRecord::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFRecord::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  NDEFRecordTypeCategory category;
  
  WTF::String record_type;
  
  WTF::String media_type;
  
  WTF::String id;
  
  WTF::String encoding;
  
  WTF::String lang;
  
  WTF::Vector<uint8_t> data;
  
  NDEFMessagePtr payload_message;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NDEFRecord);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFRecord::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT NDEFMessage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NDEFMessage, T>::value>;
  using DataView = NDEFMessageDataView;
  using Data_ = internal::NDEFMessage_Data;

  template <typename... Args>
  static NDEFMessagePtr New(Args&&... args) {
    return NDEFMessagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NDEFMessagePtr From(const U& u) {
    return mojo::TypeConverter<NDEFMessagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NDEFMessage>::Convert(*this);
  }


  NDEFMessage();

  explicit NDEFMessage(
      WTF::Vector<NDEFRecordPtr> data);

  ~NDEFMessage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NDEFMessagePtr>
  NDEFMessagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NDEFMessage::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NDEFMessage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NDEFMessage_UnserializedMessageContext<
            UserType, NDEFMessage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NDEFMessage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return NDEFMessage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NDEFMessage_UnserializedMessageContext<
            UserType, NDEFMessage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NDEFMessage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::Vector<NDEFRecordPtr> data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NDEFMessage);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NDEFMessage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
NDEFErrorPtr NDEFError::Clone() const {
  return New(
      mojo::Clone(error_type),
      mojo::Clone(error_message)
  );
}

template <typename T, NDEFError::EnableIfSame<T>*>
bool NDEFError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->error_type, other_struct.error_type))
    return false;
  if (!mojo::Equals(this->error_message, other_struct.error_message))
    return false;
  return true;
}

template <typename T, NDEFError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.error_type, rhs.error_type))
    return true;
  if (std::less<>{}(rhs.error_type, lhs.error_type))
    return false;
  if (std::less<>{}(lhs.error_message, rhs.error_message))
    return true;
  if (std::less<>{}(rhs.error_message, lhs.error_message))
    return false;
  return false;
}
template <typename StructPtrType>
NDEFRecordPtr NDEFRecord::Clone() const {
  return New(
      mojo::Clone(category),
      mojo::Clone(record_type),
      mojo::Clone(media_type),
      mojo::Clone(id),
      mojo::Clone(encoding),
      mojo::Clone(lang),
      mojo::Clone(data),
      mojo::Clone(payload_message)
  );
}

template <typename T, NDEFRecord::EnableIfSame<T>*>
bool NDEFRecord::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->category, other_struct.category))
    return false;
  if (!mojo::Equals(this->record_type, other_struct.record_type))
    return false;
  if (!mojo::Equals(this->media_type, other_struct.media_type))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->encoding, other_struct.encoding))
    return false;
  if (!mojo::Equals(this->lang, other_struct.lang))
    return false;
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  if (!mojo::Equals(this->payload_message, other_struct.payload_message))
    return false;
  return true;
}

template <typename T, NDEFRecord::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.category, rhs.category))
    return true;
  if (std::less<>{}(rhs.category, lhs.category))
    return false;
  if (std::less<>{}(lhs.record_type, rhs.record_type))
    return true;
  if (std::less<>{}(rhs.record_type, lhs.record_type))
    return false;
  if (std::less<>{}(lhs.media_type, rhs.media_type))
    return true;
  if (std::less<>{}(rhs.media_type, lhs.media_type))
    return false;
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.encoding, rhs.encoding))
    return true;
  if (std::less<>{}(rhs.encoding, lhs.encoding))
    return false;
  if (std::less<>{}(lhs.lang, rhs.lang))
    return true;
  if (std::less<>{}(rhs.lang, lhs.lang))
    return false;
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  if (std::less<>{}(lhs.payload_message, rhs.payload_message))
    return true;
  if (std::less<>{}(rhs.payload_message, lhs.payload_message))
    return false;
  return false;
}
template <typename StructPtrType>
NDEFMessagePtr NDEFMessage::Clone() const {
  return New(
      mojo::Clone(data)
  );
}

template <typename T, NDEFMessage::EnableIfSame<T>*>
bool NDEFMessage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->data, other_struct.data))
    return false;
  return true;
}

template <typename T, NDEFMessage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.data, rhs.data))
    return true;
  if (std::less<>{}(rhs.data, lhs.data))
    return false;
  return false;
}
template <typename StructPtrType>
NDEFWriteOptionsPtr NDEFWriteOptions::Clone() const {
  return New(
      mojo::Clone(overwrite)
  );
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>*>
bool NDEFWriteOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overwrite, other_struct.overwrite))
    return false;
  return true;
}

template <typename T, NDEFWriteOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.overwrite, rhs.overwrite))
    return true;
  if (std::less<>{}(rhs.overwrite, lhs.overwrite))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace device

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFError::DataView,
                                         ::device::mojom::blink::NDEFErrorPtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFErrorPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFErrorPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::NDEFError::error_type) error_type(
      const ::device::mojom::blink::NDEFErrorPtr& input) {
    return input->error_type;
  }

  static const decltype(::device::mojom::blink::NDEFError::error_message)& error_message(
      const ::device::mojom::blink::NDEFErrorPtr& input) {
    return input->error_message;
  }

  static bool Read(::device::mojom::blink::NDEFError::DataView input, ::device::mojom::blink::NDEFErrorPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFRecord::DataView,
                                         ::device::mojom::blink::NDEFRecordPtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFRecordPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFRecordPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::NDEFRecord::category) category(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->category;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::record_type)& record_type(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->record_type;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::media_type)& media_type(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->media_type;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::id)& id(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->id;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::encoding)& encoding(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->encoding;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::lang)& lang(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->lang;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::data)& data(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->data;
  }

  static const decltype(::device::mojom::blink::NDEFRecord::payload_message)& payload_message(
      const ::device::mojom::blink::NDEFRecordPtr& input) {
    return input->payload_message;
  }

  static bool Read(::device::mojom::blink::NDEFRecord::DataView input, ::device::mojom::blink::NDEFRecordPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFMessage::DataView,
                                         ::device::mojom::blink::NDEFMessagePtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFMessagePtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFMessagePtr* output) { output->reset(); }

  static const decltype(::device::mojom::blink::NDEFMessage::data)& data(
      const ::device::mojom::blink::NDEFMessagePtr& input) {
    return input->data;
  }

  static bool Read(::device::mojom::blink::NDEFMessage::DataView input, ::device::mojom::blink::NDEFMessagePtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::device::mojom::blink::NDEFWriteOptions::DataView,
                                         ::device::mojom::blink::NDEFWriteOptionsPtr> {
  static bool IsNull(const ::device::mojom::blink::NDEFWriteOptionsPtr& input) { return !input; }
  static void SetToNull(::device::mojom::blink::NDEFWriteOptionsPtr* output) { output->reset(); }

  static decltype(::device::mojom::blink::NDEFWriteOptions::overwrite) overwrite(
      const ::device::mojom::blink::NDEFWriteOptionsPtr& input) {
    return input->overwrite;
  }

  static bool Read(::device::mojom::blink::NDEFWriteOptions::DataView input, ::device::mojom::blink::NDEFWriteOptionsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_BLINK_H_