/*
qpwgraph - A PipeWire Graph Qt GUI Interface

   Copyright (C) 2021-2025, rncbc aka Rui Nuno Capela. All rights reserved.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with this program; if not, write to the Free Software Foundation, Inc.,
   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.

 
*/

/********************************************************************************
** Form generated from reading UI file 'qpwgraph_main.ui'
**
** Created by: Qt User Interface Compiler version 6.10.0
**
** WARNING! All changes made in this file will be lost when recompiling UI file!
********************************************************************************/

#ifndef UI_QPWGRAPH_MAIN_H
#define UI_QPWGRAPH_MAIN_H

#include <QtCore/QVariant>
#include <QtGui/QAction>
#include <QtGui/QIcon>
#include <QtWidgets/QApplication>
#include <QtWidgets/QMainWindow>
#include <QtWidgets/QMenu>
#include <QtWidgets/QMenuBar>
#include <QtWidgets/QStatusBar>
#include <QtWidgets/QToolBar>
#include <QtWidgets/QVBoxLayout>
#include <QtWidgets/QWidget>
#include "qpwgraph_canvas.h"

QT_BEGIN_NAMESPACE

class Ui_qpwgraph_main
{
public:
    QAction *graphConnectAction;
    QAction *graphDisconnectAction;
    QAction *graphOptionsAction;
    QAction *graphQuitAction;
    QAction *patchbayNewAction;
    QAction *patchbayOpenAction;
    QAction *patchbaySaveAction;
    QAction *patchbaySaveAsAction;
    QAction *patchbayActivatedAction;
    QAction *patchbayExclusiveAction;
    QAction *patchbayEditAction;
    QAction *patchbayPinAction;
    QAction *patchbayUnpinAction;
    QAction *patchbayAutoPinAction;
    QAction *patchbayAutoDisconnectAction;
    QAction *patchbayManageAction;
    QAction *editSelectAllAction;
    QAction *editSelectNoneAction;
    QAction *editSelectInvertAction;
    QAction *editRenameItemAction;
    QAction *editSearchItemAction;
    QAction *viewMenubarAction;
    QAction *viewGraphToolbarAction;
    QAction *viewPatchbayToolbarAction;
    QAction *viewStatusbarAction;
    QAction *viewThumbviewTopLeftAction;
    QAction *viewThumbviewTopRightAction;
    QAction *viewThumbviewBottomLeftAction;
    QAction *viewThumbviewBottomRightAction;
    QAction *viewThumbviewNoneAction;
    QAction *viewTextBesideIconsAction;
    QAction *viewCenterAction;
    QAction *viewRefreshAction;
    QAction *viewZoomInAction;
    QAction *viewZoomOutAction;
    QAction *viewZoomFitAction;
    QAction *viewZoomResetAction;
    QAction *viewZoomRangeAction;
    QAction *viewColorsPipewireAudioAction;
    QAction *viewColorsPipewireMidiAction;
    QAction *viewColorsPipewireVideoAction;
    QAction *viewColorsPipewireOtherAction;
    QAction *viewColorsAlsaMidiAction;
    QAction *viewColorsResetAction;
    QAction *viewSortPortNameAction;
    QAction *viewSortPortTitleAction;
    QAction *viewSortPortIndexAction;
    QAction *viewSortAscendingAction;
    QAction *viewSortDescendingAction;
    QAction *viewRepelOverlappingNodesAction;
    QAction *viewConnectThroughNodesAction;
    QAction *helpAboutAction;
    QAction *helpAboutQtAction;
    QWidget *MainCentralWidget;
    QVBoxLayout *vboxLayout;
    qpwgraph_canvas *graphCanvas;
    QStatusBar *StatusBar;
    QMenuBar *MenuBar;
    QMenu *graphMenu;
    QMenu *patchbayMenu;
    QMenu *patchbayOpenRecentMenu;
    QMenu *editMenu;
    QMenu *viewMenu;
    QMenu *viewToolbarMenu;
    QMenu *viewThumbviewMenu;
    QMenu *viewZoomMenu;
    QMenu *viewColorsMenu;
    QMenu *viewSortMenu;
    QMenu *helpMenu;
    QToolBar *graphToolbar;
    QToolBar *patchbayToolbar;

    void setupUi(QMainWindow *qpwgraph_main)
    {
        if (qpwgraph_main->objectName().isEmpty())
            qpwgraph_main->setObjectName("qpwgraph_main");
        qpwgraph_main->resize(800, 600);
        const QIcon icon = QIcon(QString::fromUtf8(":/images/qpwgraph.svg"));
        qpwgraph_main->setWindowIcon(icon);
        graphConnectAction = new QAction(qpwgraph_main);
        graphConnectAction->setObjectName("graphConnectAction");
        const QIcon icon1 = QIcon(QString::fromUtf8(":/images/itemConnect.png"));
        graphConnectAction->setIcon(icon1);
        graphDisconnectAction = new QAction(qpwgraph_main);
        graphDisconnectAction->setObjectName("graphDisconnectAction");
        const QIcon icon2 = QIcon(QString::fromUtf8(":/images/itemDisconnect.png"));
        graphDisconnectAction->setIcon(icon2);
        graphOptionsAction = new QAction(qpwgraph_main);
        graphOptionsAction->setObjectName("graphOptionsAction");
        graphQuitAction = new QAction(qpwgraph_main);
        graphQuitAction->setObjectName("graphQuitAction");
        patchbayNewAction = new QAction(qpwgraph_main);
        patchbayNewAction->setObjectName("patchbayNewAction");
        const QIcon icon3 = QIcon(QString::fromUtf8(":/images/fileNew.png"));
        patchbayNewAction->setIcon(icon3);
        patchbayOpenAction = new QAction(qpwgraph_main);
        patchbayOpenAction->setObjectName("patchbayOpenAction");
        const QIcon icon4 = QIcon(QString::fromUtf8(":/images/fileOpen.png"));
        patchbayOpenAction->setIcon(icon4);
        patchbaySaveAction = new QAction(qpwgraph_main);
        patchbaySaveAction->setObjectName("patchbaySaveAction");
        const QIcon icon5 = QIcon(QString::fromUtf8(":/images/fileSave.png"));
        patchbaySaveAction->setIcon(icon5);
        patchbaySaveAsAction = new QAction(qpwgraph_main);
        patchbaySaveAsAction->setObjectName("patchbaySaveAsAction");
        patchbayActivatedAction = new QAction(qpwgraph_main);
        patchbayActivatedAction->setObjectName("patchbayActivatedAction");
        patchbayActivatedAction->setCheckable(true);
        const QIcon icon6 = QIcon(QString::fromUtf8(":/images/itemActivate.png"));
        patchbayActivatedAction->setIcon(icon6);
        patchbayExclusiveAction = new QAction(qpwgraph_main);
        patchbayExclusiveAction->setObjectName("patchbayExclusiveAction");
        patchbayExclusiveAction->setCheckable(true);
        const QIcon icon7 = QIcon(QString::fromUtf8(":/images/itemExclusive.png"));
        patchbayExclusiveAction->setIcon(icon7);
        patchbayEditAction = new QAction(qpwgraph_main);
        patchbayEditAction->setObjectName("patchbayEditAction");
        patchbayEditAction->setCheckable(true);
        const QIcon icon8 = QIcon(QString::fromUtf8(":/images/itemEdit.png"));
        patchbayEditAction->setIcon(icon8);
        patchbayPinAction = new QAction(qpwgraph_main);
        patchbayPinAction->setObjectName("patchbayPinAction");
        const QIcon icon9 = QIcon(QString::fromUtf8(":/images/itemPin.png"));
        patchbayPinAction->setIcon(icon9);
        patchbayUnpinAction = new QAction(qpwgraph_main);
        patchbayUnpinAction->setObjectName("patchbayUnpinAction");
        const QIcon icon10 = QIcon(QString::fromUtf8(":/images/itemUnpin.png"));
        patchbayUnpinAction->setIcon(icon10);
        patchbayAutoPinAction = new QAction(qpwgraph_main);
        patchbayAutoPinAction->setObjectName("patchbayAutoPinAction");
        patchbayAutoPinAction->setCheckable(true);
        patchbayAutoDisconnectAction = new QAction(qpwgraph_main);
        patchbayAutoDisconnectAction->setObjectName("patchbayAutoDisconnectAction");
        patchbayAutoDisconnectAction->setCheckable(true);
        patchbayManageAction = new QAction(qpwgraph_main);
        patchbayManageAction->setObjectName("patchbayManageAction");
        editSelectAllAction = new QAction(qpwgraph_main);
        editSelectAllAction->setObjectName("editSelectAllAction");
        editSelectNoneAction = new QAction(qpwgraph_main);
        editSelectNoneAction->setObjectName("editSelectNoneAction");
        editSelectInvertAction = new QAction(qpwgraph_main);
        editSelectInvertAction->setObjectName("editSelectInvertAction");
        editRenameItemAction = new QAction(qpwgraph_main);
        editRenameItemAction->setObjectName("editRenameItemAction");
        editRenameItemAction->setIcon(icon8);
        editSearchItemAction = new QAction(qpwgraph_main);
        editSearchItemAction->setObjectName("editSearchItemAction");
        const QIcon icon11 = QIcon(QString::fromUtf8(":/images/itemFind.png"));
        editSearchItemAction->setIcon(icon11);
        viewMenubarAction = new QAction(qpwgraph_main);
        viewMenubarAction->setObjectName("viewMenubarAction");
        viewMenubarAction->setCheckable(true);
        viewGraphToolbarAction = new QAction(qpwgraph_main);
        viewGraphToolbarAction->setObjectName("viewGraphToolbarAction");
        viewGraphToolbarAction->setCheckable(true);
        viewPatchbayToolbarAction = new QAction(qpwgraph_main);
        viewPatchbayToolbarAction->setObjectName("viewPatchbayToolbarAction");
        viewPatchbayToolbarAction->setCheckable(true);
        viewStatusbarAction = new QAction(qpwgraph_main);
        viewStatusbarAction->setObjectName("viewStatusbarAction");
        viewStatusbarAction->setCheckable(true);
        viewThumbviewTopLeftAction = new QAction(qpwgraph_main);
        viewThumbviewTopLeftAction->setObjectName("viewThumbviewTopLeftAction");
        viewThumbviewTopLeftAction->setCheckable(true);
        viewThumbviewTopRightAction = new QAction(qpwgraph_main);
        viewThumbviewTopRightAction->setObjectName("viewThumbviewTopRightAction");
        viewThumbviewTopRightAction->setCheckable(true);
        viewThumbviewBottomLeftAction = new QAction(qpwgraph_main);
        viewThumbviewBottomLeftAction->setObjectName("viewThumbviewBottomLeftAction");
        viewThumbviewBottomLeftAction->setCheckable(true);
        viewThumbviewBottomRightAction = new QAction(qpwgraph_main);
        viewThumbviewBottomRightAction->setObjectName("viewThumbviewBottomRightAction");
        viewThumbviewBottomRightAction->setCheckable(true);
        viewThumbviewNoneAction = new QAction(qpwgraph_main);
        viewThumbviewNoneAction->setObjectName("viewThumbviewNoneAction");
        viewThumbviewNoneAction->setCheckable(true);
        viewTextBesideIconsAction = new QAction(qpwgraph_main);
        viewTextBesideIconsAction->setObjectName("viewTextBesideIconsAction");
        viewTextBesideIconsAction->setCheckable(true);
        viewCenterAction = new QAction(qpwgraph_main);
        viewCenterAction->setObjectName("viewCenterAction");
        const QIcon icon12 = QIcon(QString::fromUtf8(":/images/viewCenter.png"));
        viewCenterAction->setIcon(icon12);
        viewRefreshAction = new QAction(qpwgraph_main);
        viewRefreshAction->setObjectName("viewRefreshAction");
        viewZoomInAction = new QAction(qpwgraph_main);
        viewZoomInAction->setObjectName("viewZoomInAction");
        const QIcon icon13 = QIcon(QString::fromUtf8(":/images/viewZoomIn.png"));
        viewZoomInAction->setIcon(icon13);
        viewZoomOutAction = new QAction(qpwgraph_main);
        viewZoomOutAction->setObjectName("viewZoomOutAction");
        const QIcon icon14 = QIcon(QString::fromUtf8(":/images/viewZoomOut.png"));
        viewZoomOutAction->setIcon(icon14);
        viewZoomFitAction = new QAction(qpwgraph_main);
        viewZoomFitAction->setObjectName("viewZoomFitAction");
        const QIcon icon15 = QIcon(QString::fromUtf8(":/images/viewZoomFit.png"));
        viewZoomFitAction->setIcon(icon15);
        viewZoomResetAction = new QAction(qpwgraph_main);
        viewZoomResetAction->setObjectName("viewZoomResetAction");
        const QIcon icon16 = QIcon(QString::fromUtf8(":/images/viewZoomReset.png"));
        viewZoomResetAction->setIcon(icon16);
        viewZoomRangeAction = new QAction(qpwgraph_main);
        viewZoomRangeAction->setObjectName("viewZoomRangeAction");
        viewZoomRangeAction->setCheckable(true);
        const QIcon icon17 = QIcon(QString::fromUtf8(":/images/viewZoomRange.png"));
        viewZoomRangeAction->setIcon(icon17);
        viewColorsPipewireAudioAction = new QAction(qpwgraph_main);
        viewColorsPipewireAudioAction->setObjectName("viewColorsPipewireAudioAction");
        viewColorsPipewireMidiAction = new QAction(qpwgraph_main);
        viewColorsPipewireMidiAction->setObjectName("viewColorsPipewireMidiAction");
        viewColorsPipewireVideoAction = new QAction(qpwgraph_main);
        viewColorsPipewireVideoAction->setObjectName("viewColorsPipewireVideoAction");
        viewColorsPipewireOtherAction = new QAction(qpwgraph_main);
        viewColorsPipewireOtherAction->setObjectName("viewColorsPipewireOtherAction");
        viewColorsAlsaMidiAction = new QAction(qpwgraph_main);
        viewColorsAlsaMidiAction->setObjectName("viewColorsAlsaMidiAction");
        viewColorsResetAction = new QAction(qpwgraph_main);
        viewColorsResetAction->setObjectName("viewColorsResetAction");
        viewSortPortNameAction = new QAction(qpwgraph_main);
        viewSortPortNameAction->setObjectName("viewSortPortNameAction");
        viewSortPortNameAction->setCheckable(true);
        viewSortPortTitleAction = new QAction(qpwgraph_main);
        viewSortPortTitleAction->setObjectName("viewSortPortTitleAction");
        viewSortPortTitleAction->setCheckable(true);
        viewSortPortIndexAction = new QAction(qpwgraph_main);
        viewSortPortIndexAction->setObjectName("viewSortPortIndexAction");
        viewSortPortIndexAction->setCheckable(true);
        viewSortAscendingAction = new QAction(qpwgraph_main);
        viewSortAscendingAction->setObjectName("viewSortAscendingAction");
        viewSortAscendingAction->setCheckable(true);
        viewSortDescendingAction = new QAction(qpwgraph_main);
        viewSortDescendingAction->setObjectName("viewSortDescendingAction");
        viewSortDescendingAction->setCheckable(true);
        viewRepelOverlappingNodesAction = new QAction(qpwgraph_main);
        viewRepelOverlappingNodesAction->setObjectName("viewRepelOverlappingNodesAction");
        viewRepelOverlappingNodesAction->setCheckable(true);
        viewConnectThroughNodesAction = new QAction(qpwgraph_main);
        viewConnectThroughNodesAction->setObjectName("viewConnectThroughNodesAction");
        viewConnectThroughNodesAction->setCheckable(true);
        helpAboutAction = new QAction(qpwgraph_main);
        helpAboutAction->setObjectName("helpAboutAction");
        helpAboutQtAction = new QAction(qpwgraph_main);
        helpAboutQtAction->setObjectName("helpAboutQtAction");
        MainCentralWidget = new QWidget(qpwgraph_main);
        MainCentralWidget->setObjectName("MainCentralWidget");
        vboxLayout = new QVBoxLayout(MainCentralWidget);
        vboxLayout->setSpacing(0);
        vboxLayout->setContentsMargins(0, 0, 0, 0);
        vboxLayout->setObjectName("vboxLayout");
        graphCanvas = new qpwgraph_canvas(MainCentralWidget);
        graphCanvas->setObjectName("graphCanvas");

        vboxLayout->addWidget(graphCanvas);

        qpwgraph_main->setCentralWidget(MainCentralWidget);
        StatusBar = new QStatusBar(qpwgraph_main);
        StatusBar->setObjectName("StatusBar");
        qpwgraph_main->setStatusBar(StatusBar);
        MenuBar = new QMenuBar(qpwgraph_main);
        MenuBar->setObjectName("MenuBar");
        MenuBar->setGeometry(QRect(0, 0, 800, 20));
        graphMenu = new QMenu(MenuBar);
        graphMenu->setObjectName("graphMenu");
        patchbayMenu = new QMenu(MenuBar);
        patchbayMenu->setObjectName("patchbayMenu");
        patchbayOpenRecentMenu = new QMenu(patchbayMenu);
        patchbayOpenRecentMenu->setObjectName("patchbayOpenRecentMenu");
        editMenu = new QMenu(MenuBar);
        editMenu->setObjectName("editMenu");
        viewMenu = new QMenu(MenuBar);
        viewMenu->setObjectName("viewMenu");
        viewToolbarMenu = new QMenu(viewMenu);
        viewToolbarMenu->setObjectName("viewToolbarMenu");
        viewThumbviewMenu = new QMenu(viewMenu);
        viewThumbviewMenu->setObjectName("viewThumbviewMenu");
        const QIcon icon18 = QIcon(QString::fromUtf8(":/images/viewThumbview.png"));
        viewThumbviewMenu->setIcon(icon18);
        viewZoomMenu = new QMenu(viewMenu);
        viewZoomMenu->setObjectName("viewZoomMenu");
        const QIcon icon19 = QIcon(QString::fromUtf8(":/images/viewZoomTool.png"));
        viewZoomMenu->setIcon(icon19);
        viewColorsMenu = new QMenu(viewMenu);
        viewColorsMenu->setObjectName("viewColorsMenu");
        const QIcon icon20 = QIcon(QString::fromUtf8(":/images/viewColors.png"));
        viewColorsMenu->setIcon(icon20);
        viewSortMenu = new QMenu(viewMenu);
        viewSortMenu->setObjectName("viewSortMenu");
        helpMenu = new QMenu(MenuBar);
        helpMenu->setObjectName("helpMenu");
        qpwgraph_main->setMenuBar(MenuBar);
        graphToolbar = new QToolBar(qpwgraph_main);
        graphToolbar->setObjectName("graphToolbar");
        graphToolbar->setAllowedAreas(Qt::AllToolBarAreas);
        graphToolbar->setOrientation(Qt::Horizontal);
        graphToolbar->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
        graphToolbar->setFloatable(true);
        qpwgraph_main->addToolBar(Qt::ToolBarArea::TopToolBarArea, graphToolbar);
        patchbayToolbar = new QToolBar(qpwgraph_main);
        patchbayToolbar->setObjectName("patchbayToolbar");
        patchbayToolbar->setAllowedAreas(Qt::AllToolBarAreas);
        patchbayToolbar->setOrientation(Qt::Horizontal);
        patchbayToolbar->setToolButtonStyle(Qt::ToolButtonTextBesideIcon);
        patchbayToolbar->setFloatable(true);
        qpwgraph_main->addToolBar(Qt::ToolBarArea::TopToolBarArea, patchbayToolbar);
        qpwgraph_main->insertToolBarBreak(patchbayToolbar);

        MenuBar->addAction(graphMenu->menuAction());
        MenuBar->addAction(patchbayMenu->menuAction());
        MenuBar->addAction(editMenu->menuAction());
        MenuBar->addAction(viewMenu->menuAction());
        MenuBar->addSeparator();
        MenuBar->addAction(helpMenu->menuAction());
        graphMenu->addAction(graphConnectAction);
        graphMenu->addAction(graphDisconnectAction);
        graphMenu->addSeparator();
        graphMenu->addAction(graphOptionsAction);
        graphMenu->addSeparator();
        graphMenu->addAction(graphQuitAction);
        patchbayMenu->addAction(patchbayNewAction);
        patchbayMenu->addSeparator();
        patchbayMenu->addAction(patchbayOpenAction);
        patchbayMenu->addAction(patchbayOpenRecentMenu->menuAction());
        patchbayMenu->addSeparator();
        patchbayMenu->addAction(patchbaySaveAction);
        patchbayMenu->addAction(patchbaySaveAsAction);
        patchbayMenu->addSeparator();
        patchbayMenu->addAction(patchbayActivatedAction);
        patchbayMenu->addAction(patchbayExclusiveAction);
        patchbayMenu->addSeparator();
        patchbayMenu->addAction(patchbayEditAction);
        patchbayMenu->addAction(patchbayPinAction);
        patchbayMenu->addAction(patchbayUnpinAction);
        patchbayMenu->addSeparator();
        patchbayMenu->addAction(patchbayAutoPinAction);
        patchbayMenu->addAction(patchbayAutoDisconnectAction);
        patchbayMenu->addSeparator();
        patchbayMenu->addAction(patchbayManageAction);
        editMenu->addAction(editSelectAllAction);
        editMenu->addAction(editSelectNoneAction);
        editMenu->addAction(editSelectInvertAction);
        editMenu->addSeparator();
        editMenu->addAction(editSearchItemAction);
        editMenu->addAction(editRenameItemAction);
        viewMenu->addAction(viewMenubarAction);
        viewMenu->addAction(viewToolbarMenu->menuAction());
        viewMenu->addAction(viewStatusbarAction);
        viewMenu->addSeparator();
        viewMenu->addAction(viewThumbviewMenu->menuAction());
        viewMenu->addSeparator();
        viewMenu->addAction(viewTextBesideIconsAction);
        viewMenu->addAction(viewColorsMenu->menuAction());
        viewMenu->addAction(viewSortMenu->menuAction());
        viewMenu->addSeparator();
        viewMenu->addAction(viewCenterAction);
        viewMenu->addAction(viewZoomMenu->menuAction());
        viewMenu->addAction(viewZoomRangeAction);
        viewMenu->addSeparator();
        viewMenu->addAction(viewRepelOverlappingNodesAction);
        viewMenu->addAction(viewConnectThroughNodesAction);
        viewMenu->addSeparator();
        viewMenu->addAction(viewRefreshAction);
        viewToolbarMenu->addAction(viewGraphToolbarAction);
        viewToolbarMenu->addAction(viewPatchbayToolbarAction);
        viewThumbviewMenu->addAction(viewThumbviewTopLeftAction);
        viewThumbviewMenu->addAction(viewThumbviewTopRightAction);
        viewThumbviewMenu->addAction(viewThumbviewBottomLeftAction);
        viewThumbviewMenu->addAction(viewThumbviewBottomRightAction);
        viewThumbviewMenu->addSeparator();
        viewThumbviewMenu->addAction(viewThumbviewNoneAction);
        viewZoomMenu->addAction(viewZoomInAction);
        viewZoomMenu->addAction(viewZoomOutAction);
        viewZoomMenu->addSeparator();
        viewZoomMenu->addAction(viewZoomFitAction);
        viewZoomMenu->addAction(viewZoomResetAction);
        viewColorsMenu->addAction(viewColorsPipewireAudioAction);
        viewColorsMenu->addAction(viewColorsPipewireMidiAction);
        viewColorsMenu->addAction(viewColorsPipewireVideoAction);
        viewColorsMenu->addAction(viewColorsPipewireOtherAction);
        viewColorsMenu->addSeparator();
        viewColorsMenu->addAction(viewColorsResetAction);
        viewSortMenu->addAction(viewSortPortNameAction);
        viewSortMenu->addAction(viewSortPortTitleAction);
        viewSortMenu->addAction(viewSortPortIndexAction);
        viewSortMenu->addSeparator();
        viewSortMenu->addAction(viewSortAscendingAction);
        viewSortMenu->addAction(viewSortDescendingAction);
        helpMenu->addAction(helpAboutAction);
        helpMenu->addAction(helpAboutQtAction);
        graphToolbar->addAction(graphConnectAction);
        graphToolbar->addAction(graphDisconnectAction);
        graphToolbar->addSeparator();
        graphToolbar->addAction(viewCenterAction);
        graphToolbar->addSeparator();
        graphToolbar->addAction(viewZoomInAction);
        graphToolbar->addAction(viewZoomOutAction);
        graphToolbar->addSeparator();
        graphToolbar->addAction(viewZoomFitAction);
        graphToolbar->addAction(viewZoomResetAction);
        graphToolbar->addSeparator();
        graphToolbar->addAction(viewZoomRangeAction);
        patchbayToolbar->addAction(patchbayNewAction);
        patchbayToolbar->addAction(patchbayOpenAction);
        patchbayToolbar->addAction(patchbaySaveAction);
        patchbayToolbar->addSeparator();
        patchbayToolbar->addAction(patchbayActivatedAction);
        patchbayToolbar->addAction(patchbayExclusiveAction);
        patchbayToolbar->addSeparator();
        patchbayToolbar->addAction(patchbayEditAction);
        patchbayToolbar->addAction(patchbayPinAction);
        patchbayToolbar->addAction(patchbayUnpinAction);

        retranslateUi(qpwgraph_main);

        QMetaObject::connectSlotsByName(qpwgraph_main);
    } // setupUi

    void retranslateUi(QMainWindow *qpwgraph_main)
    {
        qpwgraph_main->setWindowTitle(QCoreApplication::translate("qpwgraph_main", "qpwgraph", nullptr));
        graphConnectAction->setText(QCoreApplication::translate("qpwgraph_main", "&Connect", nullptr));
        graphConnectAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Connect", nullptr));
#if QT_CONFIG(tooltip)
        graphConnectAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Connect", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        graphConnectAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Connect selected ports", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        graphConnectAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+C", nullptr));
#endif // QT_CONFIG(shortcut)
        graphDisconnectAction->setText(QCoreApplication::translate("qpwgraph_main", "&Disconnect", nullptr));
        graphDisconnectAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Disconnect", nullptr));
#if QT_CONFIG(tooltip)
        graphDisconnectAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Disconnect", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        graphDisconnectAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Disconnect selected ports", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        graphDisconnectAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+D", nullptr));
#endif // QT_CONFIG(shortcut)
        graphOptionsAction->setText(QCoreApplication::translate("qpwgraph_main", "&Options...", nullptr));
        graphOptionsAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Options", nullptr));
#if QT_CONFIG(tooltip)
        graphOptionsAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Options", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        graphOptionsAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Change general application program options", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        graphOptionsAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        graphQuitAction->setText(QCoreApplication::translate("qpwgraph_main", "&Quit", nullptr));
        graphQuitAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Quit", nullptr));
#if QT_CONFIG(tooltip)
        graphQuitAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Quit", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        graphQuitAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Quit this application program", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        graphQuitAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+Q", nullptr));
#endif // QT_CONFIG(shortcut)
        patchbayNewAction->setText(QCoreApplication::translate("qpwgraph_main", "&New", nullptr));
        patchbayNewAction->setIconText(QCoreApplication::translate("qpwgraph_main", "New", nullptr));
#if QT_CONFIG(tooltip)
        patchbayNewAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "New patchbay", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayNewAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "New patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayNewAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+N", nullptr));
#endif // QT_CONFIG(shortcut)
        patchbayOpenAction->setText(QCoreApplication::translate("qpwgraph_main", "&Open...", nullptr));
        patchbayOpenAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Open", nullptr));
#if QT_CONFIG(tooltip)
        patchbayOpenAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Open patchbay", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayOpenAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Open patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayOpenAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+O", nullptr));
#endif // QT_CONFIG(shortcut)
        patchbaySaveAction->setText(QCoreApplication::translate("qpwgraph_main", "&Save", nullptr));
        patchbaySaveAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Save", nullptr));
#if QT_CONFIG(tooltip)
        patchbaySaveAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Save patchbay", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbaySaveAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Save current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbaySaveAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+S", nullptr));
#endif // QT_CONFIG(shortcut)
        patchbaySaveAsAction->setText(QCoreApplication::translate("qpwgraph_main", "Save &As...", nullptr));
        patchbaySaveAsAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Save As", nullptr));
#if QT_CONFIG(tooltip)
        patchbaySaveAsAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Save as", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbaySaveAsAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Save current patchbay with another name", nullptr));
#endif // QT_CONFIG(statustip)
        patchbayActivatedAction->setText(QCoreApplication::translate("qpwgraph_main", "Act&ivated", nullptr));
        patchbayActivatedAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Activated", nullptr));
#if QT_CONFIG(tooltip)
        patchbayActivatedAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Activated patchbay", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayActivatedAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Activate current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayActivatedAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayExclusiveAction->setText(QCoreApplication::translate("qpwgraph_main", "E&xclusive", nullptr));
        patchbayExclusiveAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Exclusive", nullptr));
#if QT_CONFIG(tooltip)
        patchbayExclusiveAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Exclusive patchbay", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayExclusiveAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Exclusive current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayExclusiveAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayEditAction->setText(QCoreApplication::translate("qpwgraph_main", "&Edit", nullptr));
        patchbayEditAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Edit", nullptr));
#if QT_CONFIG(tooltip)
        patchbayEditAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Edit patchbay", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayEditAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Edit current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayEditAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayPinAction->setText(QCoreApplication::translate("qpwgraph_main", "&Pin", nullptr));
        patchbayPinAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Pin", nullptr));
#if QT_CONFIG(tooltip)
        patchbayPinAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Pin connection", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayPinAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Pin connection to current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayPinAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayUnpinAction->setText(QCoreApplication::translate("qpwgraph_main", "&Unpin", nullptr));
        patchbayUnpinAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Unpin", nullptr));
#if QT_CONFIG(tooltip)
        patchbayUnpinAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Unpin connection", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayUnpinAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Unpin connection from current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayUnpinAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayAutoPinAction->setText(QCoreApplication::translate("qpwgraph_main", "Au&to Pin", nullptr));
#if QT_CONFIG(tooltip)
        patchbayAutoPinAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Auto pin connections", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayAutoPinAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Auto pin connections to current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayAutoPinAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayAutoDisconnectAction->setText(QCoreApplication::translate("qpwgraph_main", "Auto &Disconnect", nullptr));
#if QT_CONFIG(tooltip)
        patchbayAutoDisconnectAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Auto disconnect on deactivate", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayAutoDisconnectAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Auto disconnect on deactivate current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayAutoDisconnectAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        patchbayManageAction->setText(QCoreApplication::translate("qpwgraph_main", "&Manage...", nullptr));
#if QT_CONFIG(tooltip)
        patchbayManageAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Manage", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        patchbayManageAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Manage current patchbay", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        patchbayManageAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        editSelectAllAction->setText(QCoreApplication::translate("qpwgraph_main", "Select &All", nullptr));
        editSelectAllAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Select All", nullptr));
#if QT_CONFIG(tooltip)
        editSelectAllAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Select All", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        editSelectAllAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Select All", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        editSelectAllAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+A", nullptr));
#endif // QT_CONFIG(shortcut)
        editSelectNoneAction->setText(QCoreApplication::translate("qpwgraph_main", "Select &None", nullptr));
        editSelectNoneAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Select None", nullptr));
#if QT_CONFIG(tooltip)
        editSelectNoneAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Select None", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        editSelectNoneAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Select None", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        editSelectNoneAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+Shift+A", nullptr));
#endif // QT_CONFIG(shortcut)
        editSelectInvertAction->setText(QCoreApplication::translate("qpwgraph_main", "Select &Invert", nullptr));
        editSelectInvertAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Select Invert", nullptr));
#if QT_CONFIG(tooltip)
        editSelectInvertAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Select Invert", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        editSelectInvertAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Select Invert", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        editSelectInvertAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+I", nullptr));
#endif // QT_CONFIG(shortcut)
        editRenameItemAction->setText(QCoreApplication::translate("qpwgraph_main", "&Rename...", nullptr));
        editRenameItemAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Rename Item", nullptr));
#if QT_CONFIG(tooltip)
        editRenameItemAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Rename item", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        editRenameItemAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Rename item", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        editRenameItemAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "F2", nullptr));
#endif // QT_CONFIG(shortcut)
        editSearchItemAction->setText(QCoreApplication::translate("qpwgraph_main", "&Find...", nullptr));
        editSearchItemAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Find", nullptr));
#if QT_CONFIG(tooltip)
        editSearchItemAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Find nodes", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        editSearchItemAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Find nodes", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        editSearchItemAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+F", nullptr));
#endif // QT_CONFIG(shortcut)
        viewMenubarAction->setText(QCoreApplication::translate("qpwgraph_main", "&Menubar", nullptr));
        viewMenubarAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Menubar", nullptr));
#if QT_CONFIG(tooltip)
        viewMenubarAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Menubar", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewMenubarAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show/hide the main program window menubar", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewMenubarAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+M", nullptr));
#endif // QT_CONFIG(shortcut)
        viewGraphToolbarAction->setText(QCoreApplication::translate("qpwgraph_main", "&Graph", nullptr));
        viewGraphToolbarAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Graph Toolbar", nullptr));
#if QT_CONFIG(tooltip)
        viewGraphToolbarAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Graph toolbar", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewGraphToolbarAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show/hide main program graph toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        viewPatchbayToolbarAction->setText(QCoreApplication::translate("qpwgraph_main", "&Patchbay", nullptr));
        viewPatchbayToolbarAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Patchbay Toolbar", nullptr));
#if QT_CONFIG(tooltip)
        viewPatchbayToolbarAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Patchbay toolbar", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewPatchbayToolbarAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show/hide main program patchbay toolbar", nullptr));
#endif // QT_CONFIG(statustip)
        viewStatusbarAction->setText(QCoreApplication::translate("qpwgraph_main", "&Statusbar", nullptr));
        viewStatusbarAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Statusbar", nullptr));
#if QT_CONFIG(tooltip)
        viewStatusbarAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Statusbar", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewStatusbarAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show/hide the main program window statusbar", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewStatusbarAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewThumbviewTopLeftAction->setText(QCoreApplication::translate("qpwgraph_main", "&Top Left", nullptr));
        viewThumbviewTopLeftAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Top left", nullptr));
#if QT_CONFIG(tooltip)
        viewThumbviewTopLeftAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Top left", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewThumbviewTopLeftAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show the thumbnail overview on the top-left", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewThumbviewTopLeftAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewThumbviewTopRightAction->setText(QCoreApplication::translate("qpwgraph_main", "Top &Right", nullptr));
        viewThumbviewTopRightAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Top Right", nullptr));
#if QT_CONFIG(tooltip)
        viewThumbviewTopRightAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Top right", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewThumbviewTopRightAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show the thumbnail overview on the top-right", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewThumbviewTopRightAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewThumbviewBottomLeftAction->setText(QCoreApplication::translate("qpwgraph_main", "Bottom &Left", nullptr));
        viewThumbviewBottomLeftAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Bottom Left", nullptr));
#if QT_CONFIG(tooltip)
        viewThumbviewBottomLeftAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Bottom left", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewThumbviewBottomLeftAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show the thumbnail overview on the bottom-left", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewThumbviewBottomLeftAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewThumbviewBottomRightAction->setText(QCoreApplication::translate("qpwgraph_main", "&Bottom Right", nullptr));
        viewThumbviewBottomRightAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Bottom Right", nullptr));
#if QT_CONFIG(tooltip)
        viewThumbviewBottomRightAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Bottom right", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewThumbviewBottomRightAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show the thumbnail overview on the bottom-right", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewThumbviewBottomRightAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewThumbviewNoneAction->setText(QCoreApplication::translate("qpwgraph_main", "&None", nullptr));
        viewThumbviewNoneAction->setIconText(QCoreApplication::translate("qpwgraph_main", "None", nullptr));
#if QT_CONFIG(tooltip)
        viewThumbviewNoneAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Hide thumbview", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewThumbviewNoneAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Hide the thumbnail overview", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewThumbviewNoneAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewTextBesideIconsAction->setText(QCoreApplication::translate("qpwgraph_main", "Text Beside &Icons", nullptr));
        viewTextBesideIconsAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Text Beside Icons", nullptr));
#if QT_CONFIG(tooltip)
        viewTextBesideIconsAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Text beside icons", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewTextBesideIconsAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show/hide text beside icons", nullptr));
#endif // QT_CONFIG(statustip)
        viewCenterAction->setText(QCoreApplication::translate("qpwgraph_main", "&Center", nullptr));
        viewCenterAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Center", nullptr));
#if QT_CONFIG(tooltip)
        viewCenterAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Center", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewCenterAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Center view", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewCenterAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewRefreshAction->setText(QCoreApplication::translate("qpwgraph_main", "&Refresh", nullptr));
        viewRefreshAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Refresh", nullptr));
#if QT_CONFIG(tooltip)
        viewRefreshAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Refresh", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewRefreshAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Refresh view", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewRefreshAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "F5", nullptr));
#endif // QT_CONFIG(shortcut)
        viewZoomInAction->setText(QCoreApplication::translate("qpwgraph_main", "Zoom &In", nullptr));
        viewZoomInAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Zoom In", nullptr));
#if QT_CONFIG(tooltip)
        viewZoomInAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Zoom In", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewZoomInAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Zoom In", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewZoomInAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl++", nullptr));
#endif // QT_CONFIG(shortcut)
        viewZoomOutAction->setText(QCoreApplication::translate("qpwgraph_main", "Zoom &Out", nullptr));
        viewZoomOutAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Zoom Out", nullptr));
#if QT_CONFIG(tooltip)
        viewZoomOutAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Zoom Out", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewZoomOutAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Zoom Out", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewZoomOutAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+-", nullptr));
#endif // QT_CONFIG(shortcut)
        viewZoomFitAction->setText(QCoreApplication::translate("qpwgraph_main", "Zoom &Fit", nullptr));
        viewZoomFitAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Zoom Fit", nullptr));
#if QT_CONFIG(tooltip)
        viewZoomFitAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Zoom Fit", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewZoomFitAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Zoom Fit", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewZoomFitAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+0", nullptr));
#endif // QT_CONFIG(shortcut)
        viewZoomResetAction->setText(QCoreApplication::translate("qpwgraph_main", "Zoom &Reset", nullptr));
        viewZoomResetAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Zoom Reset", nullptr));
#if QT_CONFIG(tooltip)
        viewZoomResetAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Zoom Reset", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewZoomResetAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Zoom Reset", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewZoomResetAction->setShortcut(QCoreApplication::translate("qpwgraph_main", "Ctrl+1", nullptr));
#endif // QT_CONFIG(shortcut)
        viewZoomRangeAction->setText(QCoreApplication::translate("qpwgraph_main", "Zoom Rang&e", nullptr));
        viewZoomRangeAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Zoom Range", nullptr));
#if QT_CONFIG(tooltip)
        viewZoomRangeAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Zoom Range", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewZoomRangeAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Zoom Range", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewZoomRangeAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewColorsPipewireAudioAction->setText(QCoreApplication::translate("qpwgraph_main", "PipeWire &Audio...", nullptr));
        viewColorsPipewireAudioAction->setIconText(QCoreApplication::translate("qpwgraph_main", "PipeWire Audio Color", nullptr));
#if QT_CONFIG(tooltip)
        viewColorsPipewireAudioAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "PipeWire Audio color", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewColorsPipewireAudioAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "PipeWire Audio color", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewColorsPipewireAudioAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewColorsPipewireMidiAction->setText(QCoreApplication::translate("qpwgraph_main", "PipeWire &MIDI...", nullptr));
        viewColorsPipewireMidiAction->setIconText(QCoreApplication::translate("qpwgraph_main", "PipeWire MIDI Color", nullptr));
#if QT_CONFIG(tooltip)
        viewColorsPipewireMidiAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "PipeWire MIDI color", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewColorsPipewireMidiAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "PipeWire MIDI color", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewColorsPipewireMidiAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewColorsPipewireVideoAction->setText(QCoreApplication::translate("qpwgraph_main", "PipeWire &Video...", nullptr));
        viewColorsPipewireVideoAction->setIconText(QCoreApplication::translate("qpwgraph_main", "PipeWire Video Color", nullptr));
#if QT_CONFIG(tooltip)
        viewColorsPipewireVideoAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "PipeWire Video color", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewColorsPipewireVideoAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "PipeWire Video color", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewColorsPipewireVideoAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewColorsPipewireOtherAction->setText(QCoreApplication::translate("qpwgraph_main", "PipeWire &Other...", nullptr));
        viewColorsPipewireOtherAction->setIconText(QCoreApplication::translate("qpwgraph_main", "PipeWire Other Color", nullptr));
#if QT_CONFIG(tooltip)
        viewColorsPipewireOtherAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "PipeWire Other color", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewColorsPipewireOtherAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "PipeWire Other color", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewColorsPipewireOtherAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewColorsAlsaMidiAction->setText(QCoreApplication::translate("qpwgraph_main", "ALSA M&IDI...", nullptr));
        viewColorsAlsaMidiAction->setIconText(QCoreApplication::translate("qpwgraph_main", "ALSA MIDI Color", nullptr));
#if QT_CONFIG(tooltip)
        viewColorsAlsaMidiAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "ALSA MIDI color", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewColorsAlsaMidiAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "ALSA MIDI color", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewColorsAlsaMidiAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewColorsResetAction->setText(QCoreApplication::translate("qpwgraph_main", "&Reset", nullptr));
        viewColorsResetAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Reset Colors", nullptr));
#if QT_CONFIG(tooltip)
        viewColorsResetAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Reset colors", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewColorsResetAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Reset colors", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewColorsResetAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewSortPortNameAction->setText(QCoreApplication::translate("qpwgraph_main", "Port &Name", nullptr));
#if QT_CONFIG(tooltip)
        viewSortPortNameAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Port name", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewSortPortNameAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Sort by port name", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewSortPortNameAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewSortPortTitleAction->setText(QCoreApplication::translate("qpwgraph_main", "Port &Title", nullptr));
#if QT_CONFIG(tooltip)
        viewSortPortTitleAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Port title", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewSortPortTitleAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Sort by port title", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewSortPortTitleAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewSortPortIndexAction->setText(QCoreApplication::translate("qpwgraph_main", "Port &Index", nullptr));
#if QT_CONFIG(tooltip)
        viewSortPortIndexAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Port index", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewSortPortIndexAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Sort by port index", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewSortPortIndexAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewSortAscendingAction->setText(QCoreApplication::translate("qpwgraph_main", "&Ascending", nullptr));
#if QT_CONFIG(tooltip)
        viewSortAscendingAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Ascending", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewSortAscendingAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Ascending sort order", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewSortAscendingAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewSortDescendingAction->setText(QCoreApplication::translate("qpwgraph_main", "&Descending", nullptr));
#if QT_CONFIG(tooltip)
        viewSortDescendingAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Descending", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewSortDescendingAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Descending sort order", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewSortDescendingAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewRepelOverlappingNodesAction->setText(QCoreApplication::translate("qpwgraph_main", "Repel O&verlapping Nodes", nullptr));
        viewRepelOverlappingNodesAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Repel Nodes", nullptr));
#if QT_CONFIG(tooltip)
        viewRepelOverlappingNodesAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Repel overlapping nodes", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewRepelOverlappingNodesAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Repel overlapping nodes", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewRepelOverlappingNodesAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        viewConnectThroughNodesAction->setText(QCoreApplication::translate("qpwgraph_main", "Connect Thro&ugh Nodes", nullptr));
        viewConnectThroughNodesAction->setIconText(QCoreApplication::translate("qpwgraph_main", "Connect Through Nodes", nullptr));
#if QT_CONFIG(tooltip)
        viewConnectThroughNodesAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "Connect through nodes", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        viewConnectThroughNodesAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Whether to draw connectors through or around nodes", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        viewConnectThroughNodesAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        helpAboutAction->setText(QCoreApplication::translate("qpwgraph_main", "&About...", nullptr));
        helpAboutAction->setIconText(QCoreApplication::translate("qpwgraph_main", "About...", nullptr));
#if QT_CONFIG(tooltip)
        helpAboutAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "About", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        helpAboutAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show information about this application program", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        helpAboutAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        helpAboutQtAction->setText(QCoreApplication::translate("qpwgraph_main", "About &Qt...", nullptr));
        helpAboutQtAction->setIconText(QCoreApplication::translate("qpwgraph_main", "About Qt...", nullptr));
#if QT_CONFIG(tooltip)
        helpAboutQtAction->setToolTip(QCoreApplication::translate("qpwgraph_main", "About Qt", nullptr));
#endif // QT_CONFIG(tooltip)
#if QT_CONFIG(statustip)
        helpAboutQtAction->setStatusTip(QCoreApplication::translate("qpwgraph_main", "Show information about the Qt toolkit", nullptr));
#endif // QT_CONFIG(statustip)
#if QT_CONFIG(shortcut)
        helpAboutQtAction->setShortcut(QString());
#endif // QT_CONFIG(shortcut)
        graphMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&Graph", nullptr));
        patchbayMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&Patchbay", nullptr));
        patchbayOpenRecentMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "Open &Recent", nullptr));
        editMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&Edit", nullptr));
        viewMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&View", nullptr));
        viewToolbarMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&Toolbar", nullptr));
        viewThumbviewMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "T&humbview", nullptr));
        viewZoomMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&Zoom", nullptr));
        viewColorsMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "Co&lors", nullptr));
        viewSortMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "S&ort", nullptr));
        helpMenu->setTitle(QCoreApplication::translate("qpwgraph_main", "&Help", nullptr));
    } // retranslateUi

};

namespace Ui {
    class qpwgraph_main: public Ui_qpwgraph_main {};
} // namespace Ui

QT_END_NAMESPACE

#endif // UI_QPWGRAPH_MAIN_H
