/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Definitions                                                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: ProtonGPUOps.td                                                      *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_OP_LIST
#undef GET_OP_LIST

::mlir::triton::proton::gpu::CircularStoreOp,
::mlir::triton::proton::gpu::FinalizeOp,
::mlir::triton::proton::gpu::GlobalScratchAllocOp,
::mlir::triton::proton::gpu::InitCtxOp,
::mlir::triton::proton::gpu::ReadCounterOp,
::mlir::triton::proton::gpu::RestoreCtxOp,
::mlir::triton::proton::gpu::SaveCtxOp,
::mlir::triton::proton::gpu::SegmentAllocOp
#endif  // GET_OP_LIST

#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES


//===----------------------------------------------------------------------===//
// Local Utility Method Definitions
//===----------------------------------------------------------------------===//

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_ProtonGPUOps1(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::proton::gpu::SegmentType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be A segment in the internal buffer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_ProtonGPUOps2(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((type.isSignlessInteger(32))) || ((type.isSignlessInteger(64))))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be 32-bit signless integer or 64-bit signless integer, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_ProtonGPUOps3(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!(((::mlir::isa<::mlir::triton::PointerType>(type))) && ([](::mlir::Type pointeeType) { return (true); }(::mlir::cast<::mlir::triton::PointerType>(type).getPointeeType())))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be ptr, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_type_constraint_ProtonGPUOps4(
    ::mlir::Operation *op, ::mlir::Type type, ::llvm::StringRef valueKind,
    unsigned valueIndex) {
  if (!((::llvm::isa<::mlir::triton::gpu::MemDescType>(type)))) {
    return op->emitOpError(valueKind) << " #" << valueIndex
        << " must be memory descriptor type (`::mlir::triton::gpu::MemDescType`) in Triton IR type system, but got " << type;
  }
  return ::mlir::success();
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_ProtonGPUOps1(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::UnitAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: unit attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_ProtonGPUOps1(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_ProtonGPUOps1(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_ProtonGPUOps2(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !(((::llvm::isa<::mlir::IntegerAttr>(attr))) && ((::llvm::cast<::mlir::IntegerAttr>(attr).getType().isSignlessInteger(32)))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: 32-bit signless integer attribute";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_ProtonGPUOps2(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_ProtonGPUOps2(attr, attrName, [op]() {
    return op->emitOpError();
  });
}

static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_ProtonGPUOps3(
    ::mlir::Attribute attr, ::llvm::StringRef attrName, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  if (attr && !((::llvm::isa<::mlir::triton::proton::MetricTypeAttr>(attr))))
    return emitError() << "attribute '" << attrName
        << "' failed to satisfy constraint: The type of metric to be profiled";
  return ::mlir::success();
}
static ::llvm::LogicalResult __mlir_ods_local_attr_constraint_ProtonGPUOps3(
    ::mlir::Operation *op, ::mlir::Attribute attr, ::llvm::StringRef attrName) {
  return __mlir_ods_local_attr_constraint_ProtonGPUOps3(attr, attrName, [op]() {
    return op->emitOpError();
  });
}
} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::CircularStoreOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
CircularStoreOpGenericAdaptorBase::CircularStoreOpGenericAdaptorBase(CircularStoreOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::UnitAttr CircularStoreOpGenericAdaptorBase::getIsStartAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().isStart);
  if (!attr)
    attr = ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr);
  return attr;
}

bool CircularStoreOpGenericAdaptorBase::getIsStart() {
  auto attr = getIsStartAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder(odsAttrs.getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

uint32_t CircularStoreOpGenericAdaptorBase::getScopeId() {
  auto attr = getScopeIdAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
CircularStoreOpAdaptor::CircularStoreOpAdaptor(CircularStoreOp op) : CircularStoreOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult CircularStoreOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_isStart = getProperties().isStart; (void)tblgen_isStart;
  auto tblgen_scopeId = getProperties().scopeId; (void)tblgen_scopeId;
  if (!tblgen_scopeId) return emitError(loc, "'proton_gpu.circular_store' op ""requires attribute 'scopeId'");

  if (tblgen_isStart && !((::llvm::isa<::mlir::UnitAttr>(tblgen_isStart))))
    return emitError(loc, "'proton_gpu.circular_store' op ""attribute 'isStart' failed to satisfy constraint: unit attribute");

  if (tblgen_scopeId && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_scopeId))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_scopeId).getType().isSignlessInteger(32)))))
    return emitError(loc, "'proton_gpu.circular_store' op ""attribute 'scopeId' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult CircularStoreOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.isStart;
       auto attr = dict.get("isStart");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `isStart` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.scopeId;
       auto attr = dict.get("scopeId");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `scopeId` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute CircularStoreOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.isStart;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("isStart",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.scopeId;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("scopeId",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code CircularStoreOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.isStart.getAsOpaquePointer()), 
    llvm::hash_value(prop.scopeId.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> CircularStoreOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "isStart")
      return prop.isStart;

    if (name == "scopeId")
      return prop.scopeId;
  return std::nullopt;
}

void CircularStoreOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "isStart") {
       prop.isStart = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.isStart)>>(value);
       return;
    }

    if (name == "scopeId") {
       prop.scopeId = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.scopeId)>>(value);
       return;
    }
}

void CircularStoreOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.isStart) attrs.append("isStart", prop.isStart);

    if (prop.scopeId) attrs.append("scopeId", prop.scopeId);
}

::llvm::LogicalResult CircularStoreOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getIsStartAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps1(attr, "isStart", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getScopeIdAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps2(attr, "scopeId", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult CircularStoreOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.isStart)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.scopeId)))
    return ::mlir::failure();
  return ::mlir::success();
}

void CircularStoreOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.isStart);
  writer.writeAttribute(prop.scopeId);
}

bool CircularStoreOp::getIsStart() {
  auto attr = getIsStartAttr();
    if (!attr)
      return ((false) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr) != nullptr;
  return attr != nullptr;
}

uint32_t CircularStoreOp::getScopeId() {
  auto attr = getScopeIdAttr();
  return attr.getValue().getZExtValue();
}

void CircularStoreOp::setIsStart(bool attrValue) {
    auto &odsProp = getProperties().isStart;
    if (attrValue)
      odsProp = ((attrValue) ? ::mlir::Builder((*this)->getContext()).getUnitAttr() : nullptr);
    else
      odsProp = nullptr;
}

void CircularStoreOp::setScopeId(uint32_t attrValue) {
  getProperties().scopeId = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void CircularStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value segment, ::mlir::Value counter, /*optional*/::mlir::UnitAttr isStart, ::mlir::IntegerAttr scopeId) {
  odsState.addOperands(segment);
  odsState.addOperands(counter);
  if (isStart) {
    odsState.getOrAddProperties<Properties>().isStart = isStart;
  }
  odsState.getOrAddProperties<Properties>().scopeId = scopeId;
}

CircularStoreOp CircularStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value segment, ::mlir::Value counter, /*optional*/::mlir::UnitAttr isStart, ::mlir::IntegerAttr scopeId) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, segment, counter, isStart, scopeId);
  auto __res__ = ::llvm::dyn_cast<CircularStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CircularStoreOp CircularStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value segment, ::mlir::Value counter, /*optional*/::mlir::UnitAttr isStart, ::mlir::IntegerAttr scopeId) {
  return create(builder, builder.getLoc(), segment, counter, isStart, scopeId);
}

void CircularStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value counter, /*optional*/::mlir::UnitAttr isStart, ::mlir::IntegerAttr scopeId) {
  odsState.addOperands(segment);
  odsState.addOperands(counter);
  if (isStart) {
    odsState.getOrAddProperties<Properties>().isStart = isStart;
  }
  odsState.getOrAddProperties<Properties>().scopeId = scopeId;
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

CircularStoreOp CircularStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value counter, /*optional*/::mlir::UnitAttr isStart, ::mlir::IntegerAttr scopeId) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, segment, counter, isStart, scopeId);
  auto __res__ = ::llvm::dyn_cast<CircularStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CircularStoreOp CircularStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value counter, /*optional*/::mlir::UnitAttr isStart, ::mlir::IntegerAttr scopeId) {
  return create(builder, builder.getLoc(), resultTypes, segment, counter, isStart, scopeId);
}

void CircularStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value segment, ::mlir::Value counter, /*optional*/bool isStart, uint32_t scopeId) {
  odsState.addOperands(segment);
  odsState.addOperands(counter);
  if (isStart) {
    odsState.getOrAddProperties<Properties>().isStart = ((isStart) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.getOrAddProperties<Properties>().scopeId = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), scopeId);
}

CircularStoreOp CircularStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value segment, ::mlir::Value counter, /*optional*/bool isStart, uint32_t scopeId) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, segment, counter, isStart, scopeId);
  auto __res__ = ::llvm::dyn_cast<CircularStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CircularStoreOp CircularStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value segment, ::mlir::Value counter, /*optional*/bool isStart, uint32_t scopeId) {
  return create(builder, builder.getLoc(), segment, counter, isStart, scopeId);
}

void CircularStoreOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value counter, /*optional*/bool isStart, uint32_t scopeId) {
  odsState.addOperands(segment);
  odsState.addOperands(counter);
  if (isStart) {
    odsState.getOrAddProperties<Properties>().isStart = ((isStart) ? odsBuilder.getUnitAttr() : nullptr);
  }
  odsState.getOrAddProperties<Properties>().scopeId = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), scopeId);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

CircularStoreOp CircularStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value counter, /*optional*/bool isStart, uint32_t scopeId) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, segment, counter, isStart, scopeId);
  auto __res__ = ::llvm::dyn_cast<CircularStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CircularStoreOp CircularStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value counter, /*optional*/bool isStart, uint32_t scopeId) {
  return create(builder, builder.getLoc(), resultTypes, segment, counter, isStart, scopeId);
}

void CircularStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<CircularStoreOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

CircularStoreOp CircularStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<CircularStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CircularStoreOp CircularStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void CircularStoreOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

CircularStoreOp CircularStoreOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<CircularStoreOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

CircularStoreOp CircularStoreOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult CircularStoreOp::verifyInvariantsImpl() {
  auto tblgen_isStart = getProperties().isStart; (void)tblgen_isStart;
  auto tblgen_scopeId = getProperties().scopeId; (void)tblgen_scopeId;
  if (!tblgen_scopeId) return emitOpError("requires attribute 'scopeId'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps1(*this, tblgen_isStart, "isStart")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps2(*this, tblgen_scopeId, "scopeId")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps2(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult CircularStoreOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult CircularStoreOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand segmentRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> segmentOperands(&segmentRawOperand, 1);  ::llvm::SMLoc segmentOperandsLoc;
  (void)segmentOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand counterRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> counterOperands(&counterRawOperand, 1);  ::llvm::SMLoc counterOperandsLoc;
  (void)counterOperandsLoc;
  ::mlir::Type segmentRawType{};
  ::llvm::ArrayRef<::mlir::Type> segmentTypes(&segmentRawType, 1);
  ::mlir::Type counterRawType{};
  ::llvm::ArrayRef<::mlir::Type> counterTypes(&counterRawType, 1);
  if (::mlir::succeeded(parser.parseOptionalKeyword("start"))) {
    result.getOrAddProperties<CircularStoreOp::Properties>().isStart = parser.getBuilder().getUnitAttr();  } else {
  if (parser.parseKeyword("end"))
    return ::mlir::failure();
  }

  segmentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(segmentRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  counterOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(counterRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(segmentRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    counterRawType = type;
  }
  if (parser.resolveOperands(segmentOperands, segmentTypes, segmentOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(counterOperands, counterTypes, counterOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void CircularStoreOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  if ((getIsStartAttr() && getIsStartAttr() != ((false) ? ::mlir::OpBuilder((*this)->getContext()).getUnitAttr() : nullptr))) {
    _odsPrinter << ' ' << "start";
  } else {
    _odsPrinter << ' ' << "end";
  }
  _odsPrinter << ' ';
  _odsPrinter << getSegment();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getCounter();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  elidedAttrs.push_back("isStart");
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getIsStartAttr();
     if(attr && (attr == ((false) ? odsBuilder.getUnitAttr() : nullptr)))
       elidedAttrs.push_back("isStart");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getSegment().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  {
    auto type = getCounter().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void CircularStoreOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::CircularStoreOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::FinalizeOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
FinalizeOpGenericAdaptorBase::FinalizeOpGenericAdaptorBase(FinalizeOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
FinalizeOpAdaptor::FinalizeOpAdaptor(FinalizeOp op) : FinalizeOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult FinalizeOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult FinalizeOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute FinalizeOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code FinalizeOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> FinalizeOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void FinalizeOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void FinalizeOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult FinalizeOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void FinalizeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  odsState.addOperands(segment);
  odsState.addOperands(scratchPtr);
}

FinalizeOp FinalizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, segment, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<FinalizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FinalizeOp FinalizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), segment, scratchPtr);
}

void FinalizeOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  odsState.addOperands(segment);
  odsState.addOperands(scratchPtr);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

FinalizeOp FinalizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, segment, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<FinalizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FinalizeOp FinalizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), resultTypes, segment, scratchPtr);
}

void FinalizeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

FinalizeOp FinalizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<FinalizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FinalizeOp FinalizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void FinalizeOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

FinalizeOp FinalizeOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<FinalizeOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

FinalizeOp FinalizeOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult FinalizeOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult FinalizeOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult FinalizeOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand segmentRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> segmentOperands(&segmentRawOperand, 1);  ::llvm::SMLoc segmentOperandsLoc;
  (void)segmentOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand scratchPtrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> scratchPtrOperands(&scratchPtrRawOperand, 1);  ::llvm::SMLoc scratchPtrOperandsLoc;
  (void)scratchPtrOperandsLoc;
  ::mlir::Type segmentRawType{};
  ::llvm::ArrayRef<::mlir::Type> segmentTypes(&segmentRawType, 1);
  ::mlir::Type scratchPtrRawType{};
  ::llvm::ArrayRef<::mlir::Type> scratchPtrTypes(&scratchPtrRawType, 1);

  segmentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(segmentRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  scratchPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(scratchPtrRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(segmentRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(scratchPtrRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(segmentOperands, segmentTypes, segmentOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(scratchPtrOperands, scratchPtrTypes, scratchPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void FinalizeOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSegment();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getScratchPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getSegment().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getScratchPtr().getType();
}

void FinalizeOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::triton::gpu::SharedMemory::get());
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::triton::GlobalMemory::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::FinalizeOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::GlobalScratchAllocOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
GlobalScratchAllocOpGenericAdaptorBase::GlobalScratchAllocOpGenericAdaptorBase(GlobalScratchAllocOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

uint32_t GlobalScratchAllocOpGenericAdaptorBase::getNbytes() {
  auto attr = getNbytesAttr();
  return attr.getValue().getZExtValue();
}

uint32_t GlobalScratchAllocOpGenericAdaptorBase::getAlignment() {
  auto attr = getAlignmentAttr();
  return attr.getValue().getZExtValue();
}

} // namespace detail
GlobalScratchAllocOpAdaptor::GlobalScratchAllocOpAdaptor(GlobalScratchAllocOp op) : GlobalScratchAllocOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult GlobalScratchAllocOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_alignment = getProperties().alignment; (void)tblgen_alignment;
  if (!tblgen_alignment) return emitError(loc, "'proton_gpu.global_scratch_alloc' op ""requires attribute 'alignment'");
  auto tblgen_nbytes = getProperties().nbytes; (void)tblgen_nbytes;
  if (!tblgen_nbytes) return emitError(loc, "'proton_gpu.global_scratch_alloc' op ""requires attribute 'nbytes'");

  if (tblgen_nbytes && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_nbytes))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_nbytes).getType().isSignlessInteger(32)))))
    return emitError(loc, "'proton_gpu.global_scratch_alloc' op ""attribute 'nbytes' failed to satisfy constraint: 32-bit signless integer attribute");

  if (tblgen_alignment && !(((::llvm::isa<::mlir::IntegerAttr>(tblgen_alignment))) && ((::llvm::cast<::mlir::IntegerAttr>(tblgen_alignment).getType().isSignlessInteger(32)))))
    return emitError(loc, "'proton_gpu.global_scratch_alloc' op ""attribute 'alignment' failed to satisfy constraint: 32-bit signless integer attribute");
  return ::mlir::success();
}

::llvm::LogicalResult GlobalScratchAllocOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.alignment;
       auto attr = dict.get("alignment");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `alignment` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }

  {
    auto &propStorage = prop.nbytes;
       auto attr = dict.get("nbytes");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `nbytes` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute GlobalScratchAllocOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.alignment;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("alignment",
                                       propStorage));
    }

    {
      const auto &propStorage = prop.nbytes;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("nbytes",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code GlobalScratchAllocOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.alignment.getAsOpaquePointer()), 
    llvm::hash_value(prop.nbytes.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> GlobalScratchAllocOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "alignment")
      return prop.alignment;

    if (name == "nbytes")
      return prop.nbytes;
  return std::nullopt;
}

void GlobalScratchAllocOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "alignment") {
       prop.alignment = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.alignment)>>(value);
       return;
    }

    if (name == "nbytes") {
       prop.nbytes = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.nbytes)>>(value);
       return;
    }
}

void GlobalScratchAllocOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.alignment) attrs.append("alignment", prop.alignment);

    if (prop.nbytes) attrs.append("nbytes", prop.nbytes);
}

::llvm::LogicalResult GlobalScratchAllocOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getAlignmentAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps2(attr, "alignment", emitError)))
        return ::mlir::failure();
    }

    {
      ::mlir::Attribute attr = attrs.get(getNbytesAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps2(attr, "nbytes", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult GlobalScratchAllocOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readAttribute(prop.alignment)))
    return ::mlir::failure();

  if (::mlir::failed(reader.readAttribute(prop.nbytes)))
    return ::mlir::failure();
  return ::mlir::success();
}

void GlobalScratchAllocOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;
  writer.writeAttribute(prop.alignment);
  writer.writeAttribute(prop.nbytes);
}

uint32_t GlobalScratchAllocOp::getNbytes() {
  auto attr = getNbytesAttr();
  return attr.getValue().getZExtValue();
}

uint32_t GlobalScratchAllocOp::getAlignment() {
  auto attr = getAlignmentAttr();
  return attr.getValue().getZExtValue();
}

void GlobalScratchAllocOp::setNbytes(uint32_t attrValue) {
  getProperties().nbytes = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void GlobalScratchAllocOp::setAlignment(uint32_t attrValue) {
  getProperties().alignment = ::mlir::Builder((*this)->getContext()).getIntegerAttr(::mlir::Builder((*this)->getContext()).getIntegerType(32), attrValue);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Type result, int32_t nbytes, int32_t alignment) {
 build(odsBuilder, odsState, result,
                       odsBuilder.getI32IntegerAttr(nbytes), odsBuilder.getI32IntegerAttr(alignment)); 
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, Type result, int32_t nbytes, int32_t alignment) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, nbytes, alignment);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, Type result, int32_t nbytes, int32_t alignment) {
  return create(builder, builder.getLoc(), result, nbytes, alignment);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::IntegerAttr nbytes, ::mlir::IntegerAttr alignment) {
  odsState.getOrAddProperties<Properties>().nbytes = nbytes;
  odsState.getOrAddProperties<Properties>().alignment = alignment;
  odsState.addTypes(result);
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::IntegerAttr nbytes, ::mlir::IntegerAttr alignment) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, nbytes, alignment);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::IntegerAttr nbytes, ::mlir::IntegerAttr alignment) {
  return create(builder, builder.getLoc(), result, nbytes, alignment);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr nbytes, ::mlir::IntegerAttr alignment) {
  odsState.getOrAddProperties<Properties>().nbytes = nbytes;
  odsState.getOrAddProperties<Properties>().alignment = alignment;
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr nbytes, ::mlir::IntegerAttr alignment) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, nbytes, alignment);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::IntegerAttr nbytes, ::mlir::IntegerAttr alignment) {
  return create(builder, builder.getLoc(), resultTypes, nbytes, alignment);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, uint32_t nbytes, uint32_t alignment) {
  odsState.getOrAddProperties<Properties>().nbytes = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), nbytes);
  odsState.getOrAddProperties<Properties>().alignment = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), alignment);
  odsState.addTypes(result);
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, uint32_t nbytes, uint32_t alignment) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, result, nbytes, alignment);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, uint32_t nbytes, uint32_t alignment) {
  return create(builder, builder.getLoc(), result, nbytes, alignment);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, uint32_t nbytes, uint32_t alignment) {
  odsState.getOrAddProperties<Properties>().nbytes = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), nbytes);
  odsState.getOrAddProperties<Properties>().alignment = odsBuilder.getIntegerAttr(odsBuilder.getIntegerType(32), alignment);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, uint32_t nbytes, uint32_t alignment) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, nbytes, alignment);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, uint32_t nbytes, uint32_t alignment) {
  return create(builder, builder.getLoc(), resultTypes, nbytes, alignment);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<GlobalScratchAllocOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void GlobalScratchAllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<GlobalScratchAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

GlobalScratchAllocOp GlobalScratchAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult GlobalScratchAllocOp::verifyInvariantsImpl() {
  auto tblgen_alignment = getProperties().alignment; (void)tblgen_alignment;
  if (!tblgen_alignment) return emitOpError("requires attribute 'alignment'");
  auto tblgen_nbytes = getProperties().nbytes; (void)tblgen_nbytes;
  if (!tblgen_nbytes) return emitOpError("requires attribute 'nbytes'");

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps2(*this, tblgen_nbytes, "nbytes")))
    return ::mlir::failure();

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps2(*this, tblgen_alignment, "alignment")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps3(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult GlobalScratchAllocOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult GlobalScratchAllocOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::Type resultRawType{};
  ::llvm::ArrayRef<::mlir::Type> resultTypes(&resultRawType, 1);
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(resultRawType))
    return ::mlir::failure();
  result.addTypes(resultTypes);
  return ::mlir::success();
}

void GlobalScratchAllocOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getResult().getType();
}

void GlobalScratchAllocOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Allocate::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::GlobalScratchAllocOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::InitCtxOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
InitCtxOpGenericAdaptorBase::InitCtxOpGenericAdaptorBase(InitCtxOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
InitCtxOpAdaptor::InitCtxOpAdaptor(InitCtxOp op) : InitCtxOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult InitCtxOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult InitCtxOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute InitCtxOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code InitCtxOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> InitCtxOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void InitCtxOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void InitCtxOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult InitCtxOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void InitCtxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value scratchPtr) {
  odsState.addOperands(scratchPtr);
}

InitCtxOp InitCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<InitCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitCtxOp InitCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), scratchPtr);
}

void InitCtxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value scratchPtr) {
  odsState.addOperands(scratchPtr);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

InitCtxOp InitCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<InitCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitCtxOp InitCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), resultTypes, scratchPtr);
}

void InitCtxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

InitCtxOp InitCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<InitCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitCtxOp InitCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void InitCtxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

InitCtxOp InitCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<InitCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

InitCtxOp InitCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult InitCtxOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult InitCtxOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult InitCtxOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand scratchPtrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> scratchPtrOperands(&scratchPtrRawOperand, 1);  ::llvm::SMLoc scratchPtrOperandsLoc;
  (void)scratchPtrOperandsLoc;
  ::mlir::Type scratchPtrRawType{};
  ::llvm::ArrayRef<::mlir::Type> scratchPtrTypes(&scratchPtrRawType, 1);

  scratchPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(scratchPtrRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(scratchPtrRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(scratchPtrOperands, scratchPtrTypes, scratchPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void InitCtxOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getScratchPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getScratchPtr().getType();
}

void InitCtxOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::InitCtxOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::ReadCounterOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
ReadCounterOpGenericAdaptorBase::ReadCounterOpGenericAdaptorBase(ReadCounterOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

::mlir::triton::proton::MetricTypeAttr ReadCounterOpGenericAdaptorBase::getMetricAttr() {
  auto attr = ::llvm::dyn_cast_or_null<::mlir::triton::proton::MetricTypeAttr>(getProperties().metric);
  return attr;
}

::mlir::triton::proton::MetricType ReadCounterOpGenericAdaptorBase::getMetric() {
  auto attr = getMetricAttr();
  return attr.getValue();
}

} // namespace detail
ReadCounterOpAdaptor::ReadCounterOpAdaptor(ReadCounterOp op) : ReadCounterOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult ReadCounterOpAdaptor::verify(::mlir::Location loc) {
  auto tblgen_metric = getProperties().metric; (void)tblgen_metric;

  if (tblgen_metric && !((::llvm::isa<::mlir::triton::proton::MetricTypeAttr>(tblgen_metric))))
    return emitError(loc, "'proton_gpu.read_counter' op ""attribute 'metric' failed to satisfy constraint: The type of metric to be profiled");
  return ::mlir::success();
}

::llvm::LogicalResult ReadCounterOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }

  {
    auto &propStorage = prop.metric;
       auto attr = dict.get("metric");
    if (attr) {
      auto convertedAttr = ::llvm::dyn_cast<std::remove_reference_t<decltype(propStorage)>>(attr);
      if (convertedAttr) {
        propStorage = convertedAttr;
      } else {
        emitError() << "Invalid attribute `metric` in property conversion: " << attr;
        return ::mlir::failure();
      }
    }
  }
  return ::mlir::success();
}

::mlir::Attribute ReadCounterOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

    {
      const auto &propStorage = prop.metric;
      if (propStorage)
        attrs.push_back(odsBuilder.getNamedAttr("metric",
                                       propStorage));
    }

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code ReadCounterOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine(
    llvm::hash_value(prop.metric.getAsOpaquePointer()));
}

std::optional<mlir::Attribute> ReadCounterOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
    if (name == "metric")
      return prop.metric;
  return std::nullopt;
}

void ReadCounterOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
    if (name == "metric") {
       prop.metric = ::llvm::dyn_cast_or_null<std::remove_reference_t<decltype(prop.metric)>>(value);
       return;
    }
}

void ReadCounterOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
    if (prop.metric) attrs.append("metric", prop.metric);
}

::llvm::LogicalResult ReadCounterOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    {
      ::mlir::Attribute attr = attrs.get(getMetricAttrName(opName));
      if (attr && ::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps3(attr, "metric", emitError)))
        return ::mlir::failure();
    }
    return ::mlir::success();
}

::llvm::LogicalResult ReadCounterOp::readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state) {
  auto &prop = state.getOrAddProperties<Properties>(); (void)prop;
  if (::mlir::failed(reader.readOptionalAttribute(prop.metric)))
    return ::mlir::failure();
  return ::mlir::success();
}

void ReadCounterOp::writeProperties(::mlir::DialectBytecodeWriter &writer) {
  auto &prop = getProperties(); (void)prop;

  writer.writeOptionalAttribute(prop.metric);
}

::mlir::triton::proton::MetricType ReadCounterOp::getMetric() {
  auto attr = getMetricAttr();
  return attr.getValue();
}

void ReadCounterOp::setMetric(::mlir::triton::proton::MetricType attrValue) {
  getProperties().metric = ::mlir::triton::proton::MetricTypeAttr::get(::mlir::Builder((*this)->getContext()).getContext(), attrValue);
}

void ReadCounterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type counter, ::mlir::triton::proton::MetricTypeAttr metric) {
  if (metric) {
    odsState.getOrAddProperties<Properties>().metric = metric;
  }
  odsState.addTypes(counter);
}

ReadCounterOp ReadCounterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type counter, ::mlir::triton::proton::MetricTypeAttr metric) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, counter, metric);
  auto __res__ = ::llvm::dyn_cast<ReadCounterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReadCounterOp ReadCounterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type counter, ::mlir::triton::proton::MetricTypeAttr metric) {
  return create(builder, builder.getLoc(), counter, metric);
}

void ReadCounterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::triton::proton::MetricTypeAttr metric) {
  if (metric) {
    odsState.getOrAddProperties<Properties>().metric = metric;
  }
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ReadCounterOp ReadCounterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::triton::proton::MetricTypeAttr metric) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, metric);
  auto __res__ = ::llvm::dyn_cast<ReadCounterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReadCounterOp ReadCounterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::triton::proton::MetricTypeAttr metric) {
  return create(builder, builder.getLoc(), resultTypes, metric);
}

void ReadCounterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type counter, ::mlir::triton::proton::MetricType metric) {
  odsState.getOrAddProperties<Properties>().metric = ::mlir::triton::proton::MetricTypeAttr::get(odsBuilder.getContext(), metric);
  odsState.addTypes(counter);
}

ReadCounterOp ReadCounterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type counter, ::mlir::triton::proton::MetricType metric) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, counter, metric);
  auto __res__ = ::llvm::dyn_cast<ReadCounterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReadCounterOp ReadCounterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type counter, ::mlir::triton::proton::MetricType metric) {
  return create(builder, builder.getLoc(), counter, metric);
}

void ReadCounterOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::triton::proton::MetricType metric) {
  odsState.getOrAddProperties<Properties>().metric = ::mlir::triton::proton::MetricTypeAttr::get(odsBuilder.getContext(), metric);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

ReadCounterOp ReadCounterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::triton::proton::MetricType metric) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, metric);
  auto __res__ = ::llvm::dyn_cast<ReadCounterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReadCounterOp ReadCounterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::triton::proton::MetricType metric) {
  return create(builder, builder.getLoc(), resultTypes, metric);
}

void ReadCounterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);

  if (!attributes.empty()) {
    ::mlir::OpaqueProperties properties =
      &odsState.getOrAddProperties<ReadCounterOp::Properties>();
    std::optional<::mlir::RegisteredOperationName> info =
      odsState.name.getRegisteredInfo();
    if (failed(info->setOpPropertiesFromAttribute(odsState.name, properties,
        odsState.attributes.getDictionary(odsState.getContext()), nullptr)))
      ::llvm::report_fatal_error("Property conversion failed.");
  }
}

ReadCounterOp ReadCounterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<ReadCounterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReadCounterOp ReadCounterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void ReadCounterOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 0u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

ReadCounterOp ReadCounterOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<ReadCounterOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

ReadCounterOp ReadCounterOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

void ReadCounterOp::populateDefaultProperties(::mlir::OperationName opName, Properties &properties) {
  ::mlir::Builder odsBuilder(opName.getContext());
  if (!properties.metric)
    properties.metric = ::mlir::triton::proton::MetricTypeAttr::get(odsBuilder.getContext(), MetricType::CYCLE);
}

::llvm::LogicalResult ReadCounterOp::verifyInvariantsImpl() {
  auto tblgen_metric = getProperties().metric; (void)tblgen_metric;

  if (::mlir::failed(__mlir_ods_local_attr_constraint_ProtonGPUOps3(*this, tblgen_metric, "metric")))
    return ::mlir::failure();
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps2(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult ReadCounterOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult ReadCounterOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::Type counterRawType{};
  ::llvm::ArrayRef<::mlir::Type> counterTypes(&counterRawType, 1);
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  {
    ::mlir::Type type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    counterRawType = type;
  }
  result.addTypes(counterTypes);
  return ::mlir::success();
}

void ReadCounterOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  {
     ::mlir::Builder odsBuilder(getContext());
     ::mlir::Attribute attr = getMetricAttr();
     if(attr && (attr == ::mlir::triton::proton::MetricTypeAttr::get(odsBuilder.getContext(), MetricType::CYCLE)))
       elidedAttrs.push_back("metric");
  }
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
  {
    auto type = getCounter().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::Type>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void ReadCounterOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::SideEffects::DefaultResource::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::ReadCounterOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::RestoreCtxOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
RestoreCtxOpGenericAdaptorBase::RestoreCtxOpGenericAdaptorBase(RestoreCtxOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
RestoreCtxOpAdaptor::RestoreCtxOpAdaptor(RestoreCtxOp op) : RestoreCtxOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult RestoreCtxOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult RestoreCtxOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute RestoreCtxOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code RestoreCtxOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> RestoreCtxOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void RestoreCtxOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void RestoreCtxOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult RestoreCtxOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void RestoreCtxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  odsState.addOperands(segment);
  odsState.addOperands(scratchPtr);
}

RestoreCtxOp RestoreCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, segment, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<RestoreCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RestoreCtxOp RestoreCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), segment, scratchPtr);
}

void RestoreCtxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  odsState.addOperands(segment);
  odsState.addOperands(scratchPtr);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

RestoreCtxOp RestoreCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, segment, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<RestoreCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RestoreCtxOp RestoreCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), resultTypes, segment, scratchPtr);
}

void RestoreCtxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

RestoreCtxOp RestoreCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<RestoreCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RestoreCtxOp RestoreCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void RestoreCtxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

RestoreCtxOp RestoreCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<RestoreCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

RestoreCtxOp RestoreCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult RestoreCtxOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult RestoreCtxOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult RestoreCtxOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand segmentRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> segmentOperands(&segmentRawOperand, 1);  ::llvm::SMLoc segmentOperandsLoc;
  (void)segmentOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand scratchPtrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> scratchPtrOperands(&scratchPtrRawOperand, 1);  ::llvm::SMLoc scratchPtrOperandsLoc;
  (void)scratchPtrOperandsLoc;
  ::mlir::Type segmentRawType{};
  ::llvm::ArrayRef<::mlir::Type> segmentTypes(&segmentRawType, 1);
  ::mlir::Type scratchPtrRawType{};
  ::llvm::ArrayRef<::mlir::Type> scratchPtrTypes(&scratchPtrRawType, 1);

  segmentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(segmentRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  scratchPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(scratchPtrRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(segmentRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(scratchPtrRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(segmentOperands, segmentTypes, segmentOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(scratchPtrOperands, scratchPtrTypes, scratchPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void RestoreCtxOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSegment();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getScratchPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getSegment().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getScratchPtr().getType();
}

void RestoreCtxOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Read::get(), 0, false, ::mlir::triton::GlobalMemory::get());
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::RestoreCtxOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::SaveCtxOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SaveCtxOpGenericAdaptorBase::SaveCtxOpGenericAdaptorBase(SaveCtxOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
SaveCtxOpAdaptor::SaveCtxOpAdaptor(SaveCtxOp op) : SaveCtxOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SaveCtxOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult SaveCtxOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute SaveCtxOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SaveCtxOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> SaveCtxOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void SaveCtxOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void SaveCtxOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult SaveCtxOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void SaveCtxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  odsState.addOperands(segment);
  odsState.addOperands(scratchPtr);
}

SaveCtxOp SaveCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, segment, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<SaveCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SaveCtxOp SaveCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), segment, scratchPtr);
}

void SaveCtxOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  odsState.addOperands(segment);
  odsState.addOperands(scratchPtr);
  assert(resultTypes.size() == 0u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SaveCtxOp SaveCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, segment, scratchPtr);
  auto __res__ = ::llvm::dyn_cast<SaveCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SaveCtxOp SaveCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value segment, ::mlir::Value scratchPtr) {
  return create(builder, builder.getLoc(), resultTypes, segment, scratchPtr);
}

void SaveCtxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SaveCtxOp SaveCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SaveCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SaveCtxOp SaveCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SaveCtxOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 2u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 0u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SaveCtxOp SaveCtxOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SaveCtxOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SaveCtxOp SaveCtxOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SaveCtxOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps1(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
    auto valueGroup1 = getODSOperands(1);

    for (auto v : valueGroup1) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps3(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SaveCtxOp::verifyInvariants() {
  return verifyInvariantsImpl();
}

::mlir::ParseResult SaveCtxOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand segmentRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> segmentOperands(&segmentRawOperand, 1);  ::llvm::SMLoc segmentOperandsLoc;
  (void)segmentOperandsLoc;
  ::mlir::OpAsmParser::UnresolvedOperand scratchPtrRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> scratchPtrOperands(&scratchPtrRawOperand, 1);  ::llvm::SMLoc scratchPtrOperandsLoc;
  (void)scratchPtrOperandsLoc;
  ::mlir::Type segmentRawType{};
  ::llvm::ArrayRef<::mlir::Type> segmentTypes(&segmentRawType, 1);
  ::mlir::Type scratchPtrRawType{};
  ::llvm::ArrayRef<::mlir::Type> scratchPtrTypes(&scratchPtrRawType, 1);

  segmentOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(segmentRawOperand))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  scratchPtrOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(scratchPtrRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(segmentRawType))
    return ::mlir::failure();
  if (parser.parseComma())
    return ::mlir::failure();

  if (parser.parseType(scratchPtrRawType))
    return ::mlir::failure();
  if (parser.resolveOperands(segmentOperands, segmentTypes, segmentOperandsLoc, result.operands))
    return ::mlir::failure();
  if (parser.resolveOperands(scratchPtrOperands, scratchPtrTypes, scratchPtrOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SaveCtxOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getSegment();
  _odsPrinter << ",";
  _odsPrinter << ' ';
  _odsPrinter << getScratchPtr();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getSegment().getType();
  _odsPrinter << ",";
  _odsPrinter << ' ';
   _odsPrinter << getScratchPtr().getType();
}

void SaveCtxOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
  effects.emplace_back(::mlir::MemoryEffects::Write::get(), 0, false, ::mlir::triton::GlobalMemory::get());
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::SaveCtxOp)

namespace mlir {
namespace triton {
namespace proton {
namespace gpu {

//===----------------------------------------------------------------------===//
// ::mlir::triton::proton::gpu::SegmentAllocOp definitions
//===----------------------------------------------------------------------===//

namespace detail {
SegmentAllocOpGenericAdaptorBase::SegmentAllocOpGenericAdaptorBase(SegmentAllocOp op) : odsAttrs(op->getRawDictionaryAttrs()), odsOpName(op->getName()), properties(op.getProperties()), odsRegions(op->getRegions()) {}

} // namespace detail
SegmentAllocOpAdaptor::SegmentAllocOpAdaptor(SegmentAllocOp op) : SegmentAllocOpGenericAdaptor(op->getOperands(), op) {}

::llvm::LogicalResult SegmentAllocOpAdaptor::verify(::mlir::Location loc) {
  return ::mlir::success();
}

::llvm::LogicalResult SegmentAllocOp::setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
  ::mlir::DictionaryAttr dict = ::llvm::dyn_cast<::mlir::DictionaryAttr>(attr);
  if (!dict) {
    emitError() << "expected DictionaryAttr to set properties";
    return ::mlir::failure();
  }
      return ::mlir::success();
}

::mlir::Attribute SegmentAllocOp::getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop) {
    ::mlir::SmallVector<::mlir::NamedAttribute> attrs;
    ::mlir::Builder odsBuilder{ctx};

  if (!attrs.empty())
    return odsBuilder.getDictionaryAttr(attrs);
  return {};
}

llvm::hash_code SegmentAllocOp::computePropertiesHash(const Properties &prop) {
  using llvm::hash_value;
  return llvm::hash_combine();
}

std::optional<mlir::Attribute> SegmentAllocOp::getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name) {
  return std::nullopt;
}

void SegmentAllocOp::setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value) {
}

void SegmentAllocOp::populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs) {
}

::llvm::LogicalResult SegmentAllocOp::verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError) {
    return ::mlir::success();
}

void SegmentAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type segment, ::mlir::Value buffer) {
  odsState.addOperands(buffer);
  odsState.addTypes(segment);
}

SegmentAllocOp SegmentAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type segment, ::mlir::Value buffer) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, segment, buffer);
  auto __res__ = ::llvm::dyn_cast<SegmentAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SegmentAllocOp SegmentAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type segment, ::mlir::Value buffer) {
  return create(builder, builder.getLoc(), segment, buffer);
}

void SegmentAllocOp::build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value buffer) {
  odsState.addOperands(buffer);
  assert(resultTypes.size() == 1u && "mismatched number of results");
  odsState.addTypes(resultTypes);
}

SegmentAllocOp SegmentAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value buffer) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, buffer);
  auto __res__ = ::llvm::dyn_cast<SegmentAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SegmentAllocOp SegmentAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value buffer) {
  return create(builder, builder.getLoc(), resultTypes, buffer);
}

void SegmentAllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.addAttributes(attributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SegmentAllocOp SegmentAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, attributes);
  auto __res__ = ::llvm::dyn_cast<SegmentAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SegmentAllocOp SegmentAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, attributes);
}

void SegmentAllocOp::build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  assert(operands.size() == 1u && "mismatched number of parameters");
  odsState.addOperands(operands);
  odsState.useProperties(const_cast<Properties&>(properties));
  odsState.addAttributes(discardableAttributes);
  assert(resultTypes.size() == 1u && "mismatched number of return types");
  odsState.addTypes(resultTypes);
}

SegmentAllocOp SegmentAllocOp::create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  ::mlir::OperationState __state__(location, getOperationName());
  build(builder, __state__, resultTypes, operands, properties, discardableAttributes);
  auto __res__ = ::llvm::dyn_cast<SegmentAllocOp>(builder.create(__state__));
  assert(__res__ && "builder didn't return the right type");
  return __res__;
}

SegmentAllocOp SegmentAllocOp::create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes) {
  return create(builder, builder.getLoc(), resultTypes, operands, properties, discardableAttributes);
}

::llvm::LogicalResult SegmentAllocOp::verifyInvariantsImpl() {
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSOperands(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps4(*this, v.getType(), "operand", index++)))
        return ::mlir::failure();
    }
  }
  {
    unsigned index = 0; (void)index;
    auto valueGroup0 = getODSResults(0);

    for (auto v : valueGroup0) {
      if (::mlir::failed(__mlir_ods_local_type_constraint_ProtonGPUOps1(*this, v.getType(), "result", index++)))
        return ::mlir::failure();
    }
  }
  return ::mlir::success();
}

::llvm::LogicalResult SegmentAllocOp::verifyInvariants() {
  if(::mlir::succeeded(verifyInvariantsImpl()) && ::mlir::succeeded(verify()))
    return ::mlir::success();
  return ::mlir::failure();
}

::mlir::ParseResult SegmentAllocOp::parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result) {
  ::mlir::OpAsmParser::UnresolvedOperand bufferRawOperand{};
  ::llvm::ArrayRef<::mlir::OpAsmParser::UnresolvedOperand> bufferOperands(&bufferRawOperand, 1);  ::llvm::SMLoc bufferOperandsLoc;
  (void)bufferOperandsLoc;
  ::mlir::Type bufferRawType{};
  ::llvm::ArrayRef<::mlir::Type> bufferTypes(&bufferRawType, 1);
  ::mlir::Type segmentRawType{};
  ::llvm::ArrayRef<::mlir::Type> segmentTypes(&segmentRawType, 1);

  bufferOperandsLoc = parser.getCurrentLocation();
  if (parser.parseOperand(bufferRawOperand))
    return ::mlir::failure();
  {
    auto loc = parser.getCurrentLocation();(void)loc;
    if (parser.parseOptionalAttrDict(result.attributes))
      return ::mlir::failure();
    if (failed(verifyInherentAttrs(result.name, result.attributes, [&]() {
        return parser.emitError(loc) << "'" << result.name.getStringRef() << "' op ";
      })))
      return ::mlir::failure();
  }
  if (parser.parseColon())
    return ::mlir::failure();

  if (parser.parseType(bufferRawType))
    return ::mlir::failure();
  if (parser.parseArrow())
    return ::mlir::failure();

  {
    ::mlir::triton::proton::gpu::SegmentType type;
    if (parser.parseCustomTypeWithFallback(type))
      return ::mlir::failure();
    segmentRawType = type;
  }
  result.addTypes(segmentTypes);
  if (parser.resolveOperands(bufferOperands, bufferTypes, bufferOperandsLoc, result.operands))
    return ::mlir::failure();
  return ::mlir::success();
}

void SegmentAllocOp::print(::mlir::OpAsmPrinter &_odsPrinter) {
  _odsPrinter << ' ';
  _odsPrinter << getBuffer();
  ::llvm::SmallVector<::llvm::StringRef, 2> elidedAttrs;
  _odsPrinter.printOptionalAttrDict((*this)->getAttrs(), elidedAttrs);
  _odsPrinter << ' ' << ":";
  _odsPrinter << ' ';
   _odsPrinter << getBuffer().getType();
  _odsPrinter << ' ' << "->";
  _odsPrinter << ' ';
  {
    auto type = getSegment().getType();
    if (auto validType = ::llvm::dyn_cast<::mlir::triton::proton::gpu::SegmentType>(type))
      _odsPrinter.printStrippedAttrOrType(validType);
   else
     _odsPrinter << type;
  }
}

void SegmentAllocOp::getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects) {
}

} // namespace gpu
} // namespace proton
} // namespace triton
} // namespace mlir
MLIR_DEFINE_EXPLICIT_TYPE_ID(::mlir::triton::proton::gpu::SegmentAllocOp)


#endif  // GET_OP_CLASSES

