#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkEnsembleDataReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkNastranBDFReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPhastaReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPPhastaReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkPVPLYWriter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredPOPReader_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVRMLSource_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkPVVTKExtensionsIOGeneralCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkEnsembleDataReader_Init(csi);
  vtkNastranBDFReader_Init(csi);
  vtkPhastaReader_Init(csi);
  vtkPPhastaReader_Init(csi);
  vtkPVPLYWriter_Init(csi);
  vtkUnstructuredPOPReader_Init(csi);
  vtkVRMLSource_Init(csi);
}
