// python wrapper for vtkAMRDualContour
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkAMRDualContour.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkAMRDualContour(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkAMRDualContour_ClassNew(); }


static PyObject *
PyvtkAMRDualContour_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkAMRDualContour::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkAMRDualContour::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkAMRDualContour *tempr = vtkAMRDualContour::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkAMRDualContour *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkAMRDualContour::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkAMRDualContour::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkAMRDualContour::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetIsoValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetIsoValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  double temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetIsoValue(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetIsoValue(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetIsoValue(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetIsoValue");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    double tempr = (ap.IsBound() ?
      op->GetIsoValue() :
      op->vtkAMRDualContour::GetIsoValue());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetEnableCapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableCapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableCapping(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetEnableCapping(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetEnableCapping(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableCapping");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEnableCapping() :
      op->vtkAMRDualContour::GetEnableCapping());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableCappingOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableCappingOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableCappingOn();
    }
    else
    {
      op->vtkAMRDualContour::EnableCappingOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableCappingOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableCappingOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableCappingOff();
    }
    else
    {
      op->vtkAMRDualContour::EnableCappingOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetEnableDegenerateCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableDegenerateCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableDegenerateCells(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetEnableDegenerateCells(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetEnableDegenerateCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableDegenerateCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEnableDegenerateCells() :
      op->vtkAMRDualContour::GetEnableDegenerateCells());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableDegenerateCellsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableDegenerateCellsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableDegenerateCellsOn();
    }
    else
    {
      op->vtkAMRDualContour::EnableDegenerateCellsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableDegenerateCellsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableDegenerateCellsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableDegenerateCellsOff();
    }
    else
    {
      op->vtkAMRDualContour::EnableDegenerateCellsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetEnableMultiProcessCommunication(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableMultiProcessCommunication");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableMultiProcessCommunication(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetEnableMultiProcessCommunication(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetEnableMultiProcessCommunication(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableMultiProcessCommunication");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEnableMultiProcessCommunication() :
      op->vtkAMRDualContour::GetEnableMultiProcessCommunication());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableMultiProcessCommunicationOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableMultiProcessCommunicationOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableMultiProcessCommunicationOn();
    }
    else
    {
      op->vtkAMRDualContour::EnableMultiProcessCommunicationOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableMultiProcessCommunicationOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableMultiProcessCommunicationOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableMultiProcessCommunicationOff();
    }
    else
    {
      op->vtkAMRDualContour::EnableMultiProcessCommunicationOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetEnableMergePoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetEnableMergePoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetEnableMergePoints(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetEnableMergePoints(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetEnableMergePoints(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEnableMergePoints");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEnableMergePoints() :
      op->vtkAMRDualContour::GetEnableMergePoints());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableMergePointsOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableMergePointsOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableMergePointsOn();
    }
    else
    {
      op->vtkAMRDualContour::EnableMergePointsOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_EnableMergePointsOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EnableMergePointsOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->EnableMergePointsOff();
    }
    else
    {
      op->vtkAMRDualContour::EnableMergePointsOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetTriangulateCap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetTriangulateCap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetTriangulateCap(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetTriangulateCap(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetTriangulateCap(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetTriangulateCap");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetTriangulateCap() :
      op->vtkAMRDualContour::GetTriangulateCap());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_TriangulateCapOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TriangulateCapOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TriangulateCapOn();
    }
    else
    {
      op->vtkAMRDualContour::TriangulateCapOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_TriangulateCapOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "TriangulateCapOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->TriangulateCapOff();
    }
    else
    {
      op->vtkAMRDualContour::TriangulateCapOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetSkipGhostCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSkipGhostCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetSkipGhostCopy(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetSkipGhostCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetSkipGhostCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSkipGhostCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetSkipGhostCopy() :
      op->vtkAMRDualContour::GetSkipGhostCopy());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SkipGhostCopyOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SkipGhostCopyOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SkipGhostCopyOn();
    }
    else
    {
      op->vtkAMRDualContour::SkipGhostCopyOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SkipGhostCopyOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SkipGhostCopyOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->SkipGhostCopyOff();
    }
    else
    {
      op->vtkAMRDualContour::SkipGhostCopyOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_GetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkMultiProcessController *tempr = (ap.IsBound() ?
      op->GetController() :
      op->vtkAMRDualContour::GetController());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkAMRDualContour_SetController(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetController");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkAMRDualContour *op = static_cast<vtkAMRDualContour *>(vp);

  vtkMultiProcessController *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkMultiProcessController"))
  {
    if (ap.IsBound())
    {
      op->SetController(temp0);
    }
    else
    {
      op->vtkAMRDualContour::SetController(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkAMRDualContour_Methods[] = {
  {"IsTypeOf", PyvtkAMRDualContour_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkAMRDualContour_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkAMRDualContour_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkAMRDualContour\nC++: static vtkAMRDualContour *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkAMRDualContour_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkAMRDualContour\nC++: vtkAMRDualContour *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkAMRDualContour_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkAMRDualContour_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetIsoValue", PyvtkAMRDualContour_SetIsoValue, METH_VARARGS,
   "SetIsoValue(self, _arg:float) -> None\nC++: virtual void SetIsoValue(double _arg)\n\n"},
  {"GetIsoValue", PyvtkAMRDualContour_GetIsoValue, METH_VARARGS,
   "GetIsoValue(self) -> float\nC++: virtual double GetIsoValue()\n\n"},
  {"SetEnableCapping", PyvtkAMRDualContour_SetEnableCapping, METH_VARARGS,
   "SetEnableCapping(self, _arg:int) -> None\nC++: virtual void SetEnableCapping(int _arg)\n\nThese are to evaluate performances. You can turn off capping,\ndegenerate cells and multiprocess communication to see how they\naffect speed of execution. Degenerate cells is the meshing\nbetween levels in the grid.\n"},
  {"GetEnableCapping", PyvtkAMRDualContour_GetEnableCapping, METH_VARARGS,
   "GetEnableCapping(self) -> int\nC++: virtual int GetEnableCapping()\n\n"},
  {"EnableCappingOn", PyvtkAMRDualContour_EnableCappingOn, METH_VARARGS,
   "EnableCappingOn(self) -> None\nC++: virtual void EnableCappingOn()\n\n"},
  {"EnableCappingOff", PyvtkAMRDualContour_EnableCappingOff, METH_VARARGS,
   "EnableCappingOff(self) -> None\nC++: virtual void EnableCappingOff()\n\n"},
  {"SetEnableDegenerateCells", PyvtkAMRDualContour_SetEnableDegenerateCells, METH_VARARGS,
   "SetEnableDegenerateCells(self, _arg:int) -> None\nC++: virtual void SetEnableDegenerateCells(int _arg)\n\n"},
  {"GetEnableDegenerateCells", PyvtkAMRDualContour_GetEnableDegenerateCells, METH_VARARGS,
   "GetEnableDegenerateCells(self) -> int\nC++: virtual int GetEnableDegenerateCells()\n\n"},
  {"EnableDegenerateCellsOn", PyvtkAMRDualContour_EnableDegenerateCellsOn, METH_VARARGS,
   "EnableDegenerateCellsOn(self) -> None\nC++: virtual void EnableDegenerateCellsOn()\n\n"},
  {"EnableDegenerateCellsOff", PyvtkAMRDualContour_EnableDegenerateCellsOff, METH_VARARGS,
   "EnableDegenerateCellsOff(self) -> None\nC++: virtual void EnableDegenerateCellsOff()\n\n"},
  {"SetEnableMultiProcessCommunication", PyvtkAMRDualContour_SetEnableMultiProcessCommunication, METH_VARARGS,
   "SetEnableMultiProcessCommunication(self, _arg:int) -> None\nC++: virtual void SetEnableMultiProcessCommunication(int _arg)\n\n"},
  {"GetEnableMultiProcessCommunication", PyvtkAMRDualContour_GetEnableMultiProcessCommunication, METH_VARARGS,
   "GetEnableMultiProcessCommunication(self) -> int\nC++: virtual int GetEnableMultiProcessCommunication()\n\n"},
  {"EnableMultiProcessCommunicationOn", PyvtkAMRDualContour_EnableMultiProcessCommunicationOn, METH_VARARGS,
   "EnableMultiProcessCommunicationOn(self) -> None\nC++: virtual void EnableMultiProcessCommunicationOn()\n\n"},
  {"EnableMultiProcessCommunicationOff", PyvtkAMRDualContour_EnableMultiProcessCommunicationOff, METH_VARARGS,
   "EnableMultiProcessCommunicationOff(self) -> None\nC++: virtual void EnableMultiProcessCommunicationOff()\n\n"},
  {"SetEnableMergePoints", PyvtkAMRDualContour_SetEnableMergePoints, METH_VARARGS,
   "SetEnableMergePoints(self, _arg:int) -> None\nC++: virtual void SetEnableMergePoints(int _arg)\n\nThis flag causes blocks to share locators so there are no\nboundary edges between blocks. It does not eliminate boundary\nedges between processes.\n"},
  {"GetEnableMergePoints", PyvtkAMRDualContour_GetEnableMergePoints, METH_VARARGS,
   "GetEnableMergePoints(self) -> int\nC++: virtual int GetEnableMergePoints()\n\n"},
  {"EnableMergePointsOn", PyvtkAMRDualContour_EnableMergePointsOn, METH_VARARGS,
   "EnableMergePointsOn(self) -> None\nC++: virtual void EnableMergePointsOn()\n\n"},
  {"EnableMergePointsOff", PyvtkAMRDualContour_EnableMergePointsOff, METH_VARARGS,
   "EnableMergePointsOff(self) -> None\nC++: virtual void EnableMergePointsOff()\n\n"},
  {"SetTriangulateCap", PyvtkAMRDualContour_SetTriangulateCap, METH_VARARGS,
   "SetTriangulateCap(self, _arg:int) -> None\nC++: virtual void SetTriangulateCap(int _arg)\n\nA flag that causes the polygons on the capping surfaces to be\ntriagulated.\n"},
  {"GetTriangulateCap", PyvtkAMRDualContour_GetTriangulateCap, METH_VARARGS,
   "GetTriangulateCap(self) -> int\nC++: virtual int GetTriangulateCap()\n\n"},
  {"TriangulateCapOn", PyvtkAMRDualContour_TriangulateCapOn, METH_VARARGS,
   "TriangulateCapOn(self) -> None\nC++: virtual void TriangulateCapOn()\n\n"},
  {"TriangulateCapOff", PyvtkAMRDualContour_TriangulateCapOff, METH_VARARGS,
   "TriangulateCapOff(self) -> None\nC++: virtual void TriangulateCapOff()\n\n"},
  {"SetSkipGhostCopy", PyvtkAMRDualContour_SetSkipGhostCopy, METH_VARARGS,
   "SetSkipGhostCopy(self, _arg:int) -> None\nC++: virtual void SetSkipGhostCopy(int _arg)\n\nAn option to turn off copying ghost values across process\nboundaries. If the ghost values are already correct, then the\nextra communication is not necessary.  If this assumption is\nwrong, this option will produce cracks / seams.\n"},
  {"GetSkipGhostCopy", PyvtkAMRDualContour_GetSkipGhostCopy, METH_VARARGS,
   "GetSkipGhostCopy(self) -> int\nC++: virtual int GetSkipGhostCopy()\n\n"},
  {"SkipGhostCopyOn", PyvtkAMRDualContour_SkipGhostCopyOn, METH_VARARGS,
   "SkipGhostCopyOn(self) -> None\nC++: virtual void SkipGhostCopyOn()\n\n"},
  {"SkipGhostCopyOff", PyvtkAMRDualContour_SkipGhostCopyOff, METH_VARARGS,
   "SkipGhostCopyOff(self) -> None\nC++: virtual void SkipGhostCopyOff()\n\n"},
  {"GetController", PyvtkAMRDualContour_GetController, METH_VARARGS,
   "GetController(self) -> vtkMultiProcessController\nC++: virtual vtkMultiProcessController *GetController()\n\n"},
  {"SetController", PyvtkAMRDualContour_SetController, METH_VARARGS,
   "SetController(self, __a:vtkMultiProcessController) -> None\nC++: virtual void SetController(vtkMultiProcessController *)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkAMRDualContour_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("iso_value"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetIsoValue(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetIsoValue(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetIsoValue(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetIsoValue/SetIsoValue\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_capping"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetEnableCapping(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetEnableCapping(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetEnableCapping(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableCapping/SetEnableCapping\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_degenerate_cells"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetEnableDegenerateCells(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetEnableDegenerateCells(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetEnableDegenerateCells(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableDegenerateCells/SetEnableDegenerateCells\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_multi_process_communication"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetEnableMultiProcessCommunication(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetEnableMultiProcessCommunication(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetEnableMultiProcessCommunication(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableMultiProcessCommunication/SetEnableMultiProcessCommunication\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("enable_merge_points"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetEnableMergePoints(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetEnableMergePoints(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetEnableMergePoints(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetEnableMergePoints/SetEnableMergePoints\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("triangulate_cap"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetTriangulateCap(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetTriangulateCap(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetTriangulateCap(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetTriangulateCap/SetTriangulateCap\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("skip_ghost_copy"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetSkipGhostCopy(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetSkipGhostCopy(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetSkipGhostCopy(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetSkipGhostCopy/SetSkipGhostCopy\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("controller"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkAMRDualContour_GetController(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkAMRDualContour_SetController(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkAMRDualContour_SetController(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetController/SetController\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkAMRDualContour_Doc =
  "vtkAMRDualContour - Extract particles and analyse them.\n\n"
  "Superclass: vtkMultiBlockDataSetAlgorithm\n\n"
  "This filter takes a cell data volume fraction and generates a\n"
  "polydata surface.  It also performs connectivity on the particles and\n"
  "generates a particle index as part of the cell data of the output. \n"
  "It computes the volume of each particle from the volume fraction.\n\n"
  "Input should be a vtkNonOverlappingAMR data.\n\n"
  "This will turn on validation and debug i/o of the filter.{.cpp}\n"
  "#define vtkAMRDualContourDEBUG\n"
  "#define vtkAMRDualContourPROFILE\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkAMRDualContour_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsAMR.vtkAMRDualContour", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkAMRDualContour_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkAMRDualContour_StaticNew()
{
  return vtkAMRDualContour::New();
}

PyObject *PyvtkAMRDualContour_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkAMRDualContour_Type, PyvtkAMRDualContour_Methods,
    "vtkAMRDualContour",
 &PyvtkAMRDualContour_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkMultiBlockDataSetAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkAMRDualContour_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkAMRDualContour(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkAMRDualContour_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkAMRDualContour", o) != 0)
  {
    Py_DECREF(o);
  }

}

