// python wrapper for vtkSMViewLayoutProxy
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkVector.h"
#include "vtkSMViewLayoutProxy.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkSMViewLayoutProxy(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkSMViewLayoutProxy_ClassNew(); }

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMViewLayoutProxy_Direction_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMViewLayoutProxy.Direction", // tp_name
  sizeof(PyLongObject), // tp_basicsize
  0, // tp_itemsize
  nullptr, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  nullptr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  nullptr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT
#if PY_VERSION_HEX >= 0x030A0000
    | Py_TPFLAGS_DISALLOW_INSTANTIATION
#endif
  , // tp_flags
  nullptr, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  &PyLong_Type, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  nullptr, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

template<class T>
static PyObject *PyvtkSMViewLayoutProxy_Direction_FromEnum(T val)
{
  return PyVTKEnum_New(&PyvtkSMViewLayoutProxy_Direction_Type, static_cast<int>(val));
}


static PyObject *
PyvtkSMViewLayoutProxy_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMViewLayoutProxy::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkSMViewLayoutProxy::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkSMViewLayoutProxy *tempr = vtkSMViewLayoutProxy::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkSMViewLayoutProxy *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkSMViewLayoutProxy::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkSMViewLayoutProxy::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkSMViewLayoutProxy::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_Split(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Split");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  int temp1;
  double temp2;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetValue(temp2))
  {
    int tempr = (ap.IsBound() ?
      op->Split(temp0, temp1, temp2) :
      op->vtkSMViewLayoutProxy::Split(temp0, temp1, temp2));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SplitVertical(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SplitVertical");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->SplitVertical(temp0, temp1) :
      op->vtkSMViewLayoutProxy::SplitVertical(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SplitHorizontal(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SplitHorizontal");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->SplitHorizontal(temp0, temp1) :
      op->vtkSMViewLayoutProxy::SplitHorizontal(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_AssignView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AssignView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  vtkSMViewProxy *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetVTKObject(temp1, "vtkSMViewProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->AssignView(temp0, temp1) :
      op->vtkSMViewLayoutProxy::AssignView(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_AssignViewToAnyCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AssignViewToAnyCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy") &&
      ap.GetValue(temp1))
  {
    int tempr = (ap.IsBound() ?
      op->AssignViewToAnyCell(temp0, temp1) :
      op->vtkSMViewLayoutProxy::AssignViewToAnyCell(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_RemoveView_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    int tempr = (ap.IsBound() ?
      op->RemoveView(temp0) :
      op->vtkSMViewLayoutProxy::RemoveView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_RemoveView_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RemoveView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->RemoveView(temp0) :
      op->vtkSMViewLayoutProxy::RemoveView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMViewLayoutProxy_RemoveView_Methods[] = {
  {"RemoveView", PyvtkSMViewLayoutProxy_RemoveView_s1, METH_VARARGS,
   "@V *vtkSMViewProxy"},
  {"RemoveView", PyvtkSMViewLayoutProxy_RemoveView_s2, METH_VARARGS,
   "@i"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMViewLayoutProxy_RemoveView(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMViewLayoutProxy_RemoveView_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "RemoveView");
  return nullptr;
}


static PyObject *
PyvtkSMViewLayoutProxy_Collapse(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Collapse");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->Collapse(temp0) :
      op->vtkSMViewLayoutProxy::Collapse(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SwapCells(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SwapCells");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->SwapCells(temp0, temp1) :
      op->vtkSMViewLayoutProxy::SwapCells(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SetSplitFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSplitFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  double temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    bool tempr = (ap.IsBound() ?
      op->SetSplitFraction(temp0, temp1) :
      op->vtkSMViewLayoutProxy::SetSplitFraction(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_EqualizeViews_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EqualizeViews");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->EqualizeViews() :
      op->vtkSMViewLayoutProxy::EqualizeViews());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_EqualizeViews_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "EqualizeViews");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  typedef vtkSMViewLayoutProxy::Direction temp0_type;
  temp0_type temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetEnumValue(temp0, "vtkSMViewLayoutProxy.Direction"))
  {
    bool tempr = (ap.IsBound() ?
      op->EqualizeViews(temp0) :
      op->vtkSMViewLayoutProxy::EqualizeViews(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_EqualizeViews(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 0:
      return PyvtkSMViewLayoutProxy_EqualizeViews_s1(self, args);
    case 1:
      return PyvtkSMViewLayoutProxy_EqualizeViews_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "EqualizeViews");
  return nullptr;
}


static PyObject *
PyvtkSMViewLayoutProxy_MaximizeCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "MaximizeCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->MaximizeCell(temp0) :
      op->vtkSMViewLayoutProxy::MaximizeCell(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_RestoreMaximizedState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "RestoreMaximizedState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->RestoreMaximizedState();
    }
    else
    {
      op->vtkSMViewLayoutProxy::RestoreMaximizedState();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetMaximizedCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetMaximizedCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetMaximizedCell() :
      op->vtkSMViewLayoutProxy::GetMaximizedCell());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_IsSplitCell(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsSplitCell");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    bool tempr = (ap.IsBound() ?
      op->IsSplitCell(temp0) :
      op->vtkSMViewLayoutProxy::IsSplitCell(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetSplitDirection(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSplitDirection");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    typedef vtkSMViewLayoutProxy::Direction tempr_type;
  tempr_type tempr = (ap.IsBound() ?
      op->GetSplitDirection(temp0) :
      op->vtkSMViewLayoutProxy::GetSplitDirection(temp0));

    if (!ap.ErrorOccurred())
    {
      result = PyvtkSMViewLayoutProxy_Direction_FromEnum(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetSplitFraction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSplitFraction");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    double tempr = (ap.IsBound() ?
      op->GetSplitFraction(temp0) :
      op->vtkSMViewLayoutProxy::GetSplitFraction(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetFirstChild(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetFirstChild");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMViewLayoutProxy::GetFirstChild(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetSecondChild(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetSecondChild");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMViewLayoutProxy::GetSecondChild(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetParent(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetParent");

  int temp0;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkSMViewLayoutProxy::GetParent(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetView(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkSMViewProxy *tempr = (ap.IsBound() ?
      op->GetView(temp0) :
      op->vtkSMViewLayoutProxy::GetView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetViewLocation(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetViewLocation");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    int tempr = (ap.IsBound() ?
      op->GetViewLocation(temp0) :
      op->vtkSMViewLayoutProxy::GetViewLocation(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_ContainsView_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ContainsView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkSMViewProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->ContainsView(temp0) :
      op->vtkSMViewLayoutProxy::ContainsView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_ContainsView_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ContainsView");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkSMProxy *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkSMProxy"))
  {
    bool tempr = (ap.IsBound() ?
      op->ContainsView(temp0) :
      op->vtkSMViewLayoutProxy::ContainsView(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkSMViewLayoutProxy_ContainsView_Methods[] = {
  {"ContainsView", PyvtkSMViewLayoutProxy_ContainsView_s1, METH_VARARGS,
   "@V *vtkSMViewProxy"},
  {"ContainsView", PyvtkSMViewLayoutProxy_ContainsView_s2, METH_VARARGS,
   "@V *vtkSMProxy"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkSMViewLayoutProxy_ContainsView(PyObject *self, PyObject *args)
{
  PyMethodDef *methods = PyvtkSMViewLayoutProxy_ContainsView_Methods;
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return vtkPythonOverload::CallMethod(methods, self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "ContainsView");
  return nullptr;
}


static PyObject *
PyvtkSMViewLayoutProxy_UpdateViewPositions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "UpdateViewPositions");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->UpdateViewPositions();
    }
    else
    {
      op->vtkSMViewLayoutProxy::UpdateViewPositions();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_ShowViewsOnTileDisplay(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ShowViewsOnTileDisplay");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ShowViewsOnTileDisplay();
    }
    else
    {
      op->vtkSMViewLayoutProxy::ShowViewsOnTileDisplay();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_CaptureWindow_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CaptureWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    vtkImageData *tempr = (ap.IsBound() ?
      op->CaptureWindow(temp0) :
      op->vtkSMViewLayoutProxy::CaptureWindow(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_CaptureWindow_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "CaptureWindow");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkImageData *tempr = (ap.IsBound() ?
      op->CaptureWindow(temp0, temp1) :
      op->vtkSMViewLayoutProxy::CaptureWindow(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_CaptureWindow(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMViewLayoutProxy_CaptureWindow_s1(self, args);
    case 2:
      return PyvtkSMViewLayoutProxy_CaptureWindow_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "CaptureWindow");
  return nullptr;
}


static PyObject *
PyvtkSMViewLayoutProxy_SaveXMLState_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveXMLState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement"))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->SaveXMLState(temp0) :
      op->vtkSMViewLayoutProxy::SaveXMLState(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_SaveXMLState_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveXMLState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  vtkSMPropertyIterator *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      ap.GetVTKObject(temp1, "vtkSMPropertyIterator"))
  {
    vtkPVXMLElement *tempr = (ap.IsBound() ?
      op->SaveXMLState(temp0, temp1) :
      op->vtkSMViewLayoutProxy::SaveXMLState(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_SaveXMLState(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMViewLayoutProxy_SaveXMLState_s1(self, args);
    case 2:
      return PyvtkSMViewLayoutProxy_SaveXMLState_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SaveXMLState");
  return nullptr;
}


static PyObject *
PyvtkSMViewLayoutProxy_LoadXMLState(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "LoadXMLState");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  vtkPVXMLElement *temp0 = nullptr;
  vtkSMProxyLocator *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPVXMLElement") &&
      ap.GetVTKObject(temp1, "vtkSMProxyLocator"))
  {
    int tempr = (ap.IsBound() ?
      op->LoadXMLState(temp0, temp1) :
      op->vtkSMViewLayoutProxy::LoadXMLState(temp0, temp1));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_Reset(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Reset");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Reset();
    }
    else
    {
      op->vtkSMViewLayoutProxy::Reset();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetLayoutExtent(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLayoutExtent");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  const size_t size0 = 4;
  int temp0[4];
  int save0[4];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    vtkPythonArgs::Save(temp0, save0, size0);

    if (ap.IsBound())
    {
      op->GetLayoutExtent(temp0);
    }
    else
    {
      op->vtkSMViewLayoutProxy::GetLayoutExtent(temp0);
    }

    if (vtkPythonArgs::HasChanged(temp0, save0, size0) &&
        !ap.ErrorOccurred())
    {
      ap.SetArray(0, temp0, size0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SetSize_s1(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  const size_t size0 = 2;
  int temp0[2];
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetArray(temp0, size0))
  {
    if (ap.IsBound())
    {
      op->SetSize(temp0);
    }
    else
    {
      op->vtkSMViewLayoutProxy::SetSize(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_SetSize_s2(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetSize(temp0, temp1);
    }
    else
    {
      op->vtkSMViewLayoutProxy::SetSize(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyObject *
PyvtkSMViewLayoutProxy_SetSize(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(self, args);

  switch(nargs)
  {
    case 1:
      return PyvtkSMViewLayoutProxy_SetSize_s1(self, args);
    case 2:
      return PyvtkSMViewLayoutProxy_SetSize_s2(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "SetSize");
  return nullptr;
}


static PyObject *
PyvtkSMViewLayoutProxy_GetSize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetSize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkVector2i tempr = (ap.IsBound() ?
      op->GetSize() :
      op->vtkSMViewLayoutProxy::GetSize());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildSpecialObject(&tempr, "vtkVector2i");
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_FindLayout(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "FindLayout");

  vtkSMViewProxy *temp0 = nullptr;
  const char *temp1 = "layouts";
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1, 2) &&
      ap.GetVTKObject(temp0, "vtkSMViewProxy") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)))
  {
    vtkSMViewLayoutProxy *tempr = vtkSMViewLayoutProxy::FindLayout(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkSMViewLayoutProxy_SaveAsPNG(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SaveAsPNG");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkSMViewLayoutProxy *op = static_cast<vtkSMViewLayoutProxy *>(vp);

  int temp0;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SaveAsPNG(temp0, temp1);
    }
    else
    {
      op->vtkSMViewLayoutProxy::SaveAsPNG(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}

static PyMethodDef PyvtkSMViewLayoutProxy_Methods[] = {
  {"IsTypeOf", PyvtkSMViewLayoutProxy_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkSMViewLayoutProxy_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkSMViewLayoutProxy_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkSMViewLayoutProxy\nC++: static vtkSMViewLayoutProxy *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkSMViewLayoutProxy_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkSMViewLayoutProxy\nC++: vtkSMViewLayoutProxy *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkSMViewLayoutProxy_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkSMViewLayoutProxy_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Split", PyvtkSMViewLayoutProxy_Split, METH_VARARGS,
   "Split(self, location:int, direction:int, fraction:float) -> int\nC++: int Split(int location, int direction, double fraction)\n\nSplit a frame at the given location. Location must point to an\nexisting cell that's not split. If the location does not exist or\nis already split, then returns -1, to indicate failure. Otherwise\nreturns the index of the left (or top) child node. The index for\nthe sibling can be computed as (ret_val + 1). fraction indicates\na value in the range [0.0, 1.0] at which the cell is split. If a\nView is set at the given location, it will be moved to the left\n(or top) child after the split.\n"},
  {"SplitVertical", PyvtkSMViewLayoutProxy_SplitVertical, METH_VARARGS,
   "SplitVertical(self, location:int, fraction:float) -> int\nC++: int SplitVertical(int location, double fraction)\n\n"},
  {"SplitHorizontal", PyvtkSMViewLayoutProxy_SplitHorizontal, METH_VARARGS,
   "SplitHorizontal(self, location:int, fraction:float) -> int\nC++: int SplitHorizontal(int location, double fraction)\n\n"},
  {"AssignView", PyvtkSMViewLayoutProxy_AssignView, METH_VARARGS,
   "AssignView(self, location:int, view:vtkSMViewProxy) -> bool\nC++: bool AssignView(int location, vtkSMViewProxy *view)\n\nAssign a view at a particular location. Note that the view's\nposition may be changed by Split() calls. Returns true on\nsuccess.\n"},
  {"AssignViewToAnyCell", PyvtkSMViewLayoutProxy_AssignViewToAnyCell, METH_VARARGS,
   "AssignViewToAnyCell(self, view:vtkSMViewProxy, location_hint:int)\n    -> int\nC++: int AssignViewToAnyCell(vtkSMViewProxy *view,\n    int location_hint)\n\nSimilar to AssignView() except that is location specified is not\navailable, then this method treats the location merely as a hint\nand tries to find a suitable place. First, if any empty cell is\navailable, then that is used. Second, if no empty cell is\navailable and location is a valid cell, then we either split the\ncell or traverse down the sub-tree from the cell and split a cell\nto make room for the view. Thus, this method will always assign\nthe view to a frame. Returns the assigned location.\n"},
  {"RemoveView", PyvtkSMViewLayoutProxy_RemoveView, METH_VARARGS,
   "RemoveView(self, view:vtkSMViewProxy) -> int\nC++: int RemoveView(vtkSMViewProxy *view)\nRemoveView(self, index:int) -> bool\nC++: bool RemoveView(int index)\n\nRemoves a view. Returns the location of the cell emptied by the\nview, if any, otherwise -1.\n"},
  {"Collapse", PyvtkSMViewLayoutProxy_Collapse, METH_VARARGS,
   "Collapse(self, location:int) -> bool\nC++: bool Collapse(int location)\n\nCollapses a cell. Only leaf cells without any assigned views can\nbe collapsed. If the cell has a sibling, then that sibling is\nassigned to the parent node and the sibling cell is destroyed as\nwell. Returns true on success, else false.\n"},
  {"SwapCells", PyvtkSMViewLayoutProxy_SwapCells, METH_VARARGS,
   "SwapCells(self, location1:int, location2:int) -> bool\nC++: bool SwapCells(int location1, int location2)\n\nSwaps the cells at the two locations. Both locations must be leaf\nlocations i.e. cannot be split-cells.\n"},
  {"SetSplitFraction", PyvtkSMViewLayoutProxy_SetSplitFraction, METH_VARARGS,
   "SetSplitFraction(self, location:int, fraction:float) -> bool\nC++: bool SetSplitFraction(int location, double fraction)\n\nUpdate the split fraction for a split cell. If\nIsSplitCell(location) returns false, this method does not update\nthe fraction.\n"},
  {"EqualizeViews", PyvtkSMViewLayoutProxy_EqualizeViews, METH_VARARGS,
   "EqualizeViews(self) -> bool\nC++: bool EqualizeViews()\nEqualizeViews(self, direction:Direction) -> bool\nC++: bool EqualizeViews(Direction direction)\n\nEqualize views so they appear evenly sized.\n"},
  {"MaximizeCell", PyvtkSMViewLayoutProxy_MaximizeCell, METH_VARARGS,
   "MaximizeCell(self, location:int) -> bool\nC++: bool MaximizeCell(int location)\n\nOne can maximize a particular (non-split) cell. Note the\nmaximized state is restored as soon as the layout is changed or\nwhen RestoreMaximizedState() is called. Returns false if the cell\nat the location cannot be maximized since it's a split cell or\ninvalid cell, true otherwise.\n"},
  {"RestoreMaximizedState", PyvtkSMViewLayoutProxy_RestoreMaximizedState, METH_VARARGS,
   "RestoreMaximizedState(self) -> None\nC++: void RestoreMaximizedState()\n\nRestores the maximized state.\n"},
  {"GetMaximizedCell", PyvtkSMViewLayoutProxy_GetMaximizedCell, METH_VARARGS,
   "GetMaximizedCell(self) -> int\nC++: virtual int GetMaximizedCell()\n\nReturns the maximized cell, if any. Returns -1 if no cell is\ncurrently maximized.\n"},
  {"IsSplitCell", PyvtkSMViewLayoutProxy_IsSplitCell, METH_VARARGS,
   "IsSplitCell(self, location:int) -> bool\nC++: bool IsSplitCell(int location)\n\nReturns true if the cell identified by the location is a split\ncell.\n"},
  {"GetSplitDirection", PyvtkSMViewLayoutProxy_GetSplitDirection, METH_VARARGS,
   "GetSplitDirection(self, location:int) -> Direction\nC++: Direction GetSplitDirection(int location)\n\nReturns the split direction for a split cell at the given\nlocation.\n"},
  {"GetSplitFraction", PyvtkSMViewLayoutProxy_GetSplitFraction, METH_VARARGS,
   "GetSplitFraction(self, location:int) -> float\nC++: double GetSplitFraction(int location)\n\nReturns the split-fraction for a split cell at the given\nlocation.\n"},
  {"GetFirstChild", PyvtkSMViewLayoutProxy_GetFirstChild, METH_VARARGS,
   "GetFirstChild(location:int) -> int\nC++: static int GetFirstChild(int location)\n\nReturns the index for the first child of the given location. This\ndoes not do any validity checks for the location, nor that of the\nchild.\n"},
  {"GetSecondChild", PyvtkSMViewLayoutProxy_GetSecondChild, METH_VARARGS,
   "GetSecondChild(location:int) -> int\nC++: static int GetSecondChild(int location)\n\nReturns the index for the second child of the given location.\nThis does not do any validity checks for the location, nor that\nof the child.\n"},
  {"GetParent", PyvtkSMViewLayoutProxy_GetParent, METH_VARARGS,
   "GetParent(location:int) -> int\nC++: static int GetParent(int location)\n\nReturns the parent index.\n"},
  {"GetView", PyvtkSMViewLayoutProxy_GetView, METH_VARARGS,
   "GetView(self, location:int) -> vtkSMViewProxy\nC++: vtkSMViewProxy *GetView(int location)\n\nReturns the view, if any, assigned to the given cell location.\n"},
  {"GetViewLocation", PyvtkSMViewLayoutProxy_GetViewLocation, METH_VARARGS,
   "GetViewLocation(self, __a:vtkSMViewProxy) -> int\nC++: int GetViewLocation(vtkSMViewProxy *)\n\nReturns the location for the view, of any. Returns -1 if the view\nis not found.\n"},
  {"ContainsView", PyvtkSMViewLayoutProxy_ContainsView, METH_VARARGS,
   "ContainsView(self, view:vtkSMViewProxy) -> bool\nC++: bool ContainsView(vtkSMViewProxy *view)\nContainsView(self, view:vtkSMProxy) -> bool\nC++: bool ContainsView(vtkSMProxy *view)\n\nReturns if a view is contained in this layout.\n"},
  {"UpdateViewPositions", PyvtkSMViewLayoutProxy_UpdateViewPositions, METH_VARARGS,
   "UpdateViewPositions(self) -> None\nC++: void UpdateViewPositions()\n\nUpdates positions for all views using the layout and current\nsizes. This method is called automatically when the layout\nchanges or the \"ViewSize\" property on the assigned views changes.\n"},
  {"ShowViewsOnTileDisplay", PyvtkSMViewLayoutProxy_ShowViewsOnTileDisplay, METH_VARARGS,
   "ShowViewsOnTileDisplay(self) -> None\nC++: void ShowViewsOnTileDisplay()\n\nWhen in tile-display configuration, only 1 view-layout is shown\non the tile-display (for obvious reasons). To show any particular\nlayout on the tile display, simply call this method.\n"},
  {"CaptureWindow", PyvtkSMViewLayoutProxy_CaptureWindow, METH_VARARGS,
   "CaptureWindow(self, magnification:int) -> vtkImageData\nC++: vtkImageData *CaptureWindow(int magnification)\nCaptureWindow(self, magnificationX:int, magnificationY:int)\n    -> vtkImageData\nC++: vtkImageData *CaptureWindow(int magnificationX,\n    int magnificationY)\n\nCaptures an image from the layout (including all the views in the\nlayout.\n"},
  {"SaveXMLState", PyvtkSMViewLayoutProxy_SaveXMLState, METH_VARARGS,
   "SaveXMLState(self, root:vtkPVXMLElement) -> vtkPVXMLElement\nC++: vtkPVXMLElement *SaveXMLState(vtkPVXMLElement *root)\n    override;\nSaveXMLState(self, root:vtkPVXMLElement,\n    iter:vtkSMPropertyIterator) -> vtkPVXMLElement\nC++: vtkPVXMLElement *SaveXMLState(vtkPVXMLElement *root,\n    vtkSMPropertyIterator *iter) override;\n\nOverridden to save custom XML state.\n"},
  {"LoadXMLState", PyvtkSMViewLayoutProxy_LoadXMLState, METH_VARARGS,
   "LoadXMLState(self, element:vtkPVXMLElement,\n    locator:vtkSMProxyLocator) -> int\nC++: int LoadXMLState(vtkPVXMLElement *element,\n    vtkSMProxyLocator *locator) override;\n\nOverridden to load custom XML state.\n"},
  {"Reset", PyvtkSMViewLayoutProxy_Reset, METH_VARARGS,
   "Reset(self) -> None\nC++: void Reset()\n\nResets the layout.\n"},
  {"GetLayoutExtent", PyvtkSMViewLayoutProxy_GetLayoutExtent, METH_VARARGS,
   "GetLayoutExtent(self, extent:[int, int, int, int]) -> None\nC++: void GetLayoutExtent(int extent[4])\n\nReturns the extents for all views in the layout.\n"},
  {"SetSize", PyvtkSMViewLayoutProxy_SetSize, METH_VARARGS,
   "SetSize(self, size:(int, int)) -> None\nC++: void SetSize(const int size[2])\nSetSize(self, width:int, height:int) -> None\nC++: void SetSize(int width, int height)\n\nUpdate the size for all the views in the layout assuming the new\nsize provided for the whole layout. This resizes and repositions\neach view based the recursive split ratios for all the cells in\nthe layout.\n"},
  {"GetSize", PyvtkSMViewLayoutProxy_GetSize, METH_VARARGS,
   "GetSize(self) -> vtkVector2i\nC++: vtkVector2i GetSize()\n\nReturns the current size.\n"},
  {"FindLayout", PyvtkSMViewLayoutProxy_FindLayout, METH_VARARGS,
   "FindLayout(__a:vtkSMViewProxy, reggroup:str=\"layouts\")\n    -> vtkSMViewLayoutProxy\nC++: static vtkSMViewLayoutProxy *FindLayout(vtkSMViewProxy *,\n    const char *reggroup=\"layouts\")\n\nHelper method to locate a layout, if any that contains the\nspecified view proxy.\n"},
  {"SaveAsPNG", PyvtkSMViewLayoutProxy_SaveAsPNG, METH_VARARGS,
   "SaveAsPNG(self, rank:int, fname:str) -> None\nC++: void SaveAsPNG(int rank, const char *fname)\n\nThis is only meant for testing and debugging purposes. This\nallows the application to save the image rendered on the server\nside in certain configurations (tile display and cave) to a png\nfile for regression testing.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkSMViewLayoutProxy_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("size"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkSMViewLayoutProxy_SetSize(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkSMViewLayoutProxy_SetSize(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetSize\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("maximized_cell"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMViewLayoutProxy_GetMaximizedCell(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetMaximizedCell\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("size"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkSMViewLayoutProxy_GetSize(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetSize\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkSMViewLayoutProxy_Doc =
  "vtkSMViewLayoutProxy - vtkSMViewLayoutProxy is used by ParaView to\nlayout multiple views in a 2D KD-Tree layout.\n\n"
  "Superclass: vtkSMProxy\n\n"
  "vtkSMViewLayoutProxy is used by ParaView to layout multiple views in\n"
  "a 2D KD-Tree layout. This is proxy, hence can be registered with the\n"
  "proxy manager just like other regular proxies; participates in xml\n"
  "state saving/restoring, undo-redo, etc. Users can affects the GUI\n"
  "layout using this proxy instance from Python as well.\n\n"
  "Every time the vtkSMViewLayoutProxy changes so that it would affect\n"
  "the UI, this class fires vtkCommand::ConfigureEvent.\n\n"
  "View proxies that are to laid out in an layout should be \"assigned\"\n"
  "to a particular cell in a vtkSMViewLayoutProxy instance.\n"
  "vtkSMViewLayoutProxy takes over the responsibility of updating the\n"
  "view's Position property correctly.\n\n"
  "Although, currently, there are no safe guards against assigning a\n"
  "view to more than one layout, this is strictly prohibited and can\n"
  "cause unexpected problems at run-time.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkSMViewLayoutProxy_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkRemotingViews.vtkSMViewLayoutProxy", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkSMViewLayoutProxy_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkSMViewLayoutProxy_StaticNew()
{
  return vtkSMViewLayoutProxy::New();
}

PyObject *PyvtkSMViewLayoutProxy_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkSMViewLayoutProxy_Type, PyvtkSMViewLayoutProxy_Methods,
    "vtkSMViewLayoutProxy",
 &PyvtkSMViewLayoutProxy_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkSMProxy");

  PyObject *d = pytype->tp_dict;
  PyObject *o;

  PyType_Ready(&PyvtkSMViewLayoutProxy_Direction_Type);
  PyVTKEnum_Add(&PyvtkSMViewLayoutProxy_Direction_Type, "vtkSMViewLayoutProxy.Direction");

  o = (PyObject *)&PyvtkSMViewLayoutProxy_Direction_Type;
  if (PyDict_SetItemString(d, "Direction", o) != 0)
  {
    Py_DECREF(o);
  }

  for (int c = 0; c < 3; c++)
  {
    typedef vtkSMViewLayoutProxy::Direction cxx_enum_type;

    static const struct { const char *name; cxx_enum_type value; }
      constants[3] = {
        { "NONE", vtkSMViewLayoutProxy::NONE },
        { "VERTICAL", vtkSMViewLayoutProxy::VERTICAL },
        { "HORIZONTAL", vtkSMViewLayoutProxy::HORIZONTAL },
      };

    o = PyvtkSMViewLayoutProxy_Direction_FromEnum(constants[c].value);
    if (o)
    {
      PyDict_SetItemString(d, constants[c].name, o);
      Py_DECREF(o);
    }
  }

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkSMViewLayoutProxy_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkSMViewLayoutProxy(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkSMViewLayoutProxy_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkSMViewLayoutProxy", o) != 0)
  {
    Py_DECREF(o);
  }

}

