/* SquaresEffect.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from SquaresEffect.vala, do not modify */

/*
* Copyright (c) 2011-2013 Yorba Foundation
*               2013 Jens Bav
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "pantheon-photos-transitions.h"
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "io.elementary.photos.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#define SQUARES_EFFECT_DESIRED_FPS 25
#define SQUARES_EFFECT_MIN_FPS 10
#define SQUARES_EFFECT_SQUARE_SIZE 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define TYPE_SQUARES_EFFECT_DESCRIPTOR (squares_effect_descriptor_get_type ())
#define SQUARES_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SQUARES_EFFECT_DESCRIPTOR, SquaresEffectDescriptor))
#define SQUARES_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SQUARES_EFFECT_DESCRIPTOR, SquaresEffectDescriptorClass))
#define IS_SQUARES_EFFECT_DESCRIPTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SQUARES_EFFECT_DESCRIPTOR))
#define IS_SQUARES_EFFECT_DESCRIPTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SQUARES_EFFECT_DESCRIPTOR))
#define SQUARES_EFFECT_DESCRIPTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SQUARES_EFFECT_DESCRIPTOR, SquaresEffectDescriptorClass))

typedef struct _SquaresEffectDescriptor SquaresEffectDescriptor;
typedef struct _SquaresEffectDescriptorClass SquaresEffectDescriptorClass;
typedef struct _SquaresEffectDescriptorPrivate SquaresEffectDescriptorPrivate;
enum  {
	SQUARES_EFFECT_DESCRIPTOR_0_PROPERTY,
	SQUARES_EFFECT_DESCRIPTOR_NUM_PROPERTIES
};
static GParamSpec* squares_effect_descriptor_properties[SQUARES_EFFECT_DESCRIPTOR_NUM_PROPERTIES];

#define TYPE_SQUARES_EFFECT (squares_effect_get_type ())
#define SQUARES_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SQUARES_EFFECT, SquaresEffect))
#define SQUARES_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SQUARES_EFFECT, SquaresEffectClass))
#define IS_SQUARES_EFFECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SQUARES_EFFECT))
#define IS_SQUARES_EFFECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SQUARES_EFFECT))
#define SQUARES_EFFECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SQUARES_EFFECT, SquaresEffectClass))

typedef struct _SquaresEffect SquaresEffect;
typedef struct _SquaresEffectClass SquaresEffectClass;
typedef struct _SquaresEffectPrivate SquaresEffectPrivate;
enum  {
	SQUARES_EFFECT_0_PROPERTY,
	SQUARES_EFFECT_NUM_PROPERTIES
};
static GParamSpec* squares_effect_properties[SQUARES_EFFECT_NUM_PROPERTIES];

struct _SquaresEffectDescriptor {
	ShotwellTransitionDescriptor parent_instance;
	SquaresEffectDescriptorPrivate * priv;
};

struct _SquaresEffectDescriptorClass {
	ShotwellTransitionDescriptorClass parent_class;
};

struct _SquaresEffect {
	GObject parent_instance;
	SquaresEffectPrivate * priv;
};

struct _SquaresEffectClass {
	GObjectClass parent_class;
};

struct _SquaresEffectPrivate {
	gdouble square_count_x;
	gdouble square_count_y;
};

static gpointer squares_effect_descriptor_parent_class = NULL;
static gint SquaresEffect_private_offset;
static gpointer squares_effect_parent_class = NULL;
static SpitTransitionsEffectIface * squares_effect_spit_transitions_effect_parent_iface = NULL;

VALA_EXTERN GType squares_effect_descriptor_get_type (void) G_GNUC_CONST ;
VALA_EXTERN SquaresEffectDescriptor* squares_effect_descriptor_new (GFile* resource_directory);
VALA_EXTERN SquaresEffectDescriptor* squares_effect_descriptor_construct (GType object_type,
                                                              GFile* resource_directory);
static const gchar* squares_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base);
static const gchar* squares_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base);
static SpitTransitionsEffect* squares_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                                              SpitHostInterface* host);
VALA_EXTERN SquaresEffect* squares_effect_new (void);
VALA_EXTERN SquaresEffect* squares_effect_construct (GType object_type);
VALA_EXTERN GType squares_effect_get_type (void) G_GNUC_CONST ;
static GType squares_effect_descriptor_get_type_once (void);
static void squares_effect_real_get_fps (SpitTransitionsEffect* base,
                                  gint* desired_fps,
                                  gint* min_fps);
static void squares_effect_real_start (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion);
static gboolean squares_effect_real_needs_clear_background (SpitTransitionsEffect* base);
static void squares_effect_real_paint (SpitTransitionsEffect* base,
                                SpitTransitionsVisuals* visuals,
                                SpitTransitionsMotion* motion,
                                cairo_t* ctx,
                                gint width,
                                gint height,
                                gint frame_number);
static void squares_effect_real_advance (SpitTransitionsEffect* base,
                                  SpitTransitionsVisuals* visuals,
                                  SpitTransitionsMotion* motion,
                                  gint frame_number);
static void squares_effect_real_cancel (SpitTransitionsEffect* base);
static void squares_effect_finalize (GObject * obj);
static GType squares_effect_get_type_once (void);

SquaresEffectDescriptor*
squares_effect_descriptor_construct (GType object_type,
                                     GFile* resource_directory)
{
	SquaresEffectDescriptor * self = NULL;
	g_return_val_if_fail (resource_directory != NULL, NULL);
	self = (SquaresEffectDescriptor*) shotwell_transition_descriptor_construct (object_type, resource_directory);
	return self;
}

SquaresEffectDescriptor*
squares_effect_descriptor_new (GFile* resource_directory)
{
	return squares_effect_descriptor_construct (TYPE_SQUARES_EFFECT_DESCRIPTOR, resource_directory);
}

static const gchar*
squares_effect_descriptor_real_get_id (ShotwellTransitionDescriptor* base)
{
	SquaresEffectDescriptor * self;
	const gchar* result;
	self = (SquaresEffectDescriptor*) base;
	result = "io.elementary.photos.transitions.squares";
	return result;
}

static const gchar*
squares_effect_descriptor_real_get_pluggable_name (ShotwellTransitionDescriptor* base)
{
	SquaresEffectDescriptor * self;
	const gchar* result;
	self = (SquaresEffectDescriptor*) base;
	result = _ ("Squares");
	return result;
}

static SpitTransitionsEffect*
squares_effect_descriptor_real_create (ShotwellTransitionDescriptor* base,
                                       SpitHostInterface* host)
{
	SquaresEffectDescriptor * self;
	SquaresEffect* _tmp0_;
	SpitTransitionsEffect* result;
	self = (SquaresEffectDescriptor*) base;
	g_return_val_if_fail (host != NULL, NULL);
	_tmp0_ = squares_effect_new ();
	result = (SpitTransitionsEffect*) _tmp0_;
	return result;
}

static void
squares_effect_descriptor_class_init (SquaresEffectDescriptorClass * klass,
                                      gpointer klass_data)
{
	squares_effect_descriptor_parent_class = g_type_class_peek_parent (klass);
	((ShotwellTransitionDescriptorClass *) klass)->get_id = (const gchar* (*) (ShotwellTransitionDescriptor*)) squares_effect_descriptor_real_get_id;
	((ShotwellTransitionDescriptorClass *) klass)->get_pluggable_name = (const gchar* (*) (ShotwellTransitionDescriptor*)) squares_effect_descriptor_real_get_pluggable_name;
	((ShotwellTransitionDescriptorClass *) klass)->create = (SpitTransitionsEffect* (*) (ShotwellTransitionDescriptor*, SpitHostInterface*)) squares_effect_descriptor_real_create;
}

static void
squares_effect_descriptor_instance_init (SquaresEffectDescriptor * self,
                                         gpointer klass)
{
}

static GType
squares_effect_descriptor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SquaresEffectDescriptorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) squares_effect_descriptor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SquaresEffectDescriptor), 0, (GInstanceInitFunc) squares_effect_descriptor_instance_init, NULL };
	GType squares_effect_descriptor_type_id;
	squares_effect_descriptor_type_id = g_type_register_static (TYPE_SHOTWELL_TRANSITION_DESCRIPTOR, "SquaresEffectDescriptor", &g_define_type_info, 0);
	return squares_effect_descriptor_type_id;
}

GType
squares_effect_descriptor_get_type (void)
{
	static volatile gsize squares_effect_descriptor_type_id__once = 0;
	if (g_once_init_enter (&squares_effect_descriptor_type_id__once)) {
		GType squares_effect_descriptor_type_id;
		squares_effect_descriptor_type_id = squares_effect_descriptor_get_type_once ();
		g_once_init_leave (&squares_effect_descriptor_type_id__once, squares_effect_descriptor_type_id);
	}
	return squares_effect_descriptor_type_id__once;
}

static inline gpointer
squares_effect_get_instance_private (SquaresEffect* self)
{
	return G_STRUCT_MEMBER_P (self, SquaresEffect_private_offset);
}

SquaresEffect*
squares_effect_construct (GType object_type)
{
	SquaresEffect * self = NULL;
	self = (SquaresEffect*) g_object_new (object_type, NULL);
	return self;
}

SquaresEffect*
squares_effect_new (void)
{
	return squares_effect_construct (TYPE_SQUARES_EFFECT);
}

static void
squares_effect_real_get_fps (SpitTransitionsEffect* base,
                             gint* desired_fps,
                             gint* min_fps)
{
	SquaresEffect * self;
	gint _vala_desired_fps = 0;
	gint _vala_min_fps = 0;
	self = (SquaresEffect*) base;
	_vala_desired_fps = SQUARES_EFFECT_DESIRED_FPS;
	_vala_min_fps = SQUARES_EFFECT_MIN_FPS;
	if (desired_fps) {
		*desired_fps = _vala_desired_fps;
	}
	if (min_fps) {
		*min_fps = _vala_min_fps;
	}
}

static void
squares_effect_real_start (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion)
{
	SquaresEffect * self;
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _tmp1_;
	GdkRectangle _tmp2_ = {0};
	GdkRectangle _tmp3_;
	self = (SquaresEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	spit_transitions_visuals_get_to_pos (visuals, &_tmp0_);
	_tmp1_ = _tmp0_;
	self->priv->square_count_x = (gdouble) ((_tmp1_.width / SQUARES_EFFECT_SQUARE_SIZE) + 1);
	spit_transitions_visuals_get_to_pos (visuals, &_tmp2_);
	_tmp3_ = _tmp2_;
	self->priv->square_count_y = (gdouble) ((_tmp3_.height / SQUARES_EFFECT_SQUARE_SIZE) + 1);
}

static gboolean
squares_effect_real_needs_clear_background (SpitTransitionsEffect* base)
{
	SquaresEffect * self;
	gboolean result;
	self = (SquaresEffect*) base;
	result = TRUE;
	return result;
}

static void
squares_effect_real_paint (SpitTransitionsEffect* base,
                           SpitTransitionsVisuals* visuals,
                           SpitTransitionsMotion* motion,
                           cairo_t* ctx,
                           gint width,
                           gint height,
                           gint frame_number)
{
	SquaresEffect * self;
	gdouble alpha = 0.0;
	GdkPixbuf* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp8_;
	GdkPixbuf* _tmp9_;
	self = (SquaresEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
	g_return_if_fail (ctx != NULL);
	alpha = spit_transitions_motion_get_alpha (motion, frame_number);
	_tmp0_ = spit_transitions_visuals_get_from_pixbuf (visuals);
	_tmp1_ = _tmp0_;
	if (_tmp1_ != NULL) {
		GdkPixbuf* _tmp2_;
		GdkPixbuf* _tmp3_;
		GdkRectangle _tmp4_ = {0};
		GdkRectangle _tmp5_;
		GdkRectangle _tmp6_ = {0};
		GdkRectangle _tmp7_;
		_tmp2_ = spit_transitions_visuals_get_from_pixbuf (visuals);
		_tmp3_ = _tmp2_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp4_);
		_tmp5_ = _tmp4_;
		spit_transitions_visuals_get_from_pos (visuals, &_tmp6_);
		_tmp7_ = _tmp6_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp3_, (gdouble) _tmp5_.x, (gdouble) _tmp7_.y);
		cairo_paint_with_alpha (ctx, 1 - alpha);
	}
	_tmp8_ = spit_transitions_visuals_get_to_pixbuf (visuals);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		GdkPixbuf* _tmp10_;
		GdkPixbuf* _tmp11_;
		GdkRectangle _tmp12_ = {0};
		GdkRectangle _tmp13_;
		GdkRectangle _tmp14_ = {0};
		GdkRectangle _tmp15_;
		_tmp10_ = spit_transitions_visuals_get_to_pixbuf (visuals);
		_tmp11_ = _tmp10_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp12_);
		_tmp13_ = _tmp12_;
		spit_transitions_visuals_get_to_pos (visuals, &_tmp14_);
		_tmp15_ = _tmp14_;
		gdk_cairo_set_source_pixbuf (ctx, _tmp11_, (gdouble) _tmp13_.x, (gdouble) _tmp15_.y);
		{
			gdouble y = 0.0;
			y = (gdouble) 0;
			{
				gboolean _tmp16_ = FALSE;
				_tmp16_ = TRUE;
				while (TRUE) {
					if (!_tmp16_) {
						gdouble _tmp17_;
						_tmp17_ = y;
						y = _tmp17_ + 1;
					}
					_tmp16_ = FALSE;
					if (!(y <= self->priv->square_count_y)) {
						break;
					}
					{
						gdouble x = 0.0;
						x = (gdouble) 0;
						{
							gboolean _tmp18_ = FALSE;
							_tmp18_ = TRUE;
							while (TRUE) {
								gdouble size = 0.0;
								GdkRectangle _tmp20_ = {0};
								GdkRectangle _tmp21_;
								GdkRectangle _tmp22_ = {0};
								GdkRectangle _tmp23_;
								if (!_tmp18_) {
									gdouble _tmp19_;
									_tmp19_ = x;
									x = _tmp19_ + 1;
								}
								_tmp18_ = FALSE;
								if (!(x <= self->priv->square_count_x)) {
									break;
								}
								size = SQUARES_EFFECT_SQUARE_SIZE * fmin ((gdouble) 1, alpha + ((((self->priv->square_count_x - x) / self->priv->square_count_x) + ((self->priv->square_count_y - y) / self->priv->square_count_y)) / 2.5));
								spit_transitions_visuals_get_to_pos (visuals, &_tmp20_);
								_tmp21_ = _tmp20_;
								spit_transitions_visuals_get_to_pos (visuals, &_tmp22_);
								_tmp23_ = _tmp22_;
								cairo_rectangle (ctx, _tmp21_.x + (x * SQUARES_EFFECT_SQUARE_SIZE), _tmp23_.y + (y * SQUARES_EFFECT_SQUARE_SIZE), size, size);
								cairo_fill (ctx);
							}
						}
					}
				}
			}
		}
		cairo_clip (ctx);
		cairo_paint_with_alpha (ctx, alpha);
	}
}

static void
squares_effect_real_advance (SpitTransitionsEffect* base,
                             SpitTransitionsVisuals* visuals,
                             SpitTransitionsMotion* motion,
                             gint frame_number)
{
	SquaresEffect * self;
	self = (SquaresEffect*) base;
	g_return_if_fail (visuals != NULL);
	g_return_if_fail (motion != NULL);
}

static void
squares_effect_real_cancel (SpitTransitionsEffect* base)
{
	SquaresEffect * self;
	self = (SquaresEffect*) base;
}

static void
squares_effect_class_init (SquaresEffectClass * klass,
                           gpointer klass_data)
{
	squares_effect_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SquaresEffect_private_offset);
	G_OBJECT_CLASS (klass)->finalize = squares_effect_finalize;
}

static void
squares_effect_spit_transitions_effect_interface_init (SpitTransitionsEffectIface * iface,
                                                       gpointer iface_data)
{
	squares_effect_spit_transitions_effect_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_fps = (void (*) (SpitTransitionsEffect*, gint*, gint*)) squares_effect_real_get_fps;
	iface->start = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*)) squares_effect_real_start;
	iface->needs_clear_background = (gboolean (*) (SpitTransitionsEffect*)) squares_effect_real_needs_clear_background;
	iface->paint = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, cairo_t*, gint, gint, gint)) squares_effect_real_paint;
	iface->advance = (void (*) (SpitTransitionsEffect*, SpitTransitionsVisuals*, SpitTransitionsMotion*, gint)) squares_effect_real_advance;
	iface->cancel = (void (*) (SpitTransitionsEffect*)) squares_effect_real_cancel;
}

static void
squares_effect_instance_init (SquaresEffect * self,
                              gpointer klass)
{
	self->priv = squares_effect_get_instance_private (self);
}

static void
squares_effect_finalize (GObject * obj)
{
	SquaresEffect * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SQUARES_EFFECT, SquaresEffect);
	G_OBJECT_CLASS (squares_effect_parent_class)->finalize (obj);
}

static GType
squares_effect_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SquaresEffectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) squares_effect_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SquaresEffect), 0, (GInstanceInitFunc) squares_effect_instance_init, NULL };
	static const GInterfaceInfo spit_transitions_effect_info = { (GInterfaceInitFunc) squares_effect_spit_transitions_effect_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType squares_effect_type_id;
	squares_effect_type_id = g_type_register_static (G_TYPE_OBJECT, "SquaresEffect", &g_define_type_info, 0);
	g_type_add_interface_static (squares_effect_type_id, SPIT_TRANSITIONS_TYPE_EFFECT, &spit_transitions_effect_info);
	SquaresEffect_private_offset = g_type_add_instance_private (squares_effect_type_id, sizeof (SquaresEffectPrivate));
	return squares_effect_type_id;
}

GType
squares_effect_get_type (void)
{
	static volatile gsize squares_effect_type_id__once = 0;
	if (g_once_init_enter (&squares_effect_type_id__once)) {
		GType squares_effect_type_id;
		squares_effect_type_id = squares_effect_get_type_once ();
		g_once_init_leave (&squares_effect_type_id__once, squares_effect_type_id);
	}
	return squares_effect_type_id__once;
}

