/* EditorToolbar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from EditorToolbar.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017-2023 elementary, Inc. (https://elementary.io)
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <webkit2/webkit2.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <granite.h>
#include <glib/gi18n-lib.h>

#define EDITOR_TOOLBAR_ACTION_GROUP_PREFIX "editor-toolbar"
#define EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_GROUP_PREFIX "."
#define EDITOR_TOOLBAR_ACTION_BOLD "bold"
#define EDITOR_TOOLBAR_ACTION_ITALIC "italic"
#define EDITOR_TOOLBAR_ACTION_UNDERLINE "underline"
#define EDITOR_TOOLBAR_ACTION_STRIKETHROUGH "strikethrough"
#define EDITOR_TOOLBAR_ACTION_INSERT_LINK "insert-link"
#define EDITOR_TOOLBAR_ACTION_REMOVE_FORMAT "remove-formatting"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_EDITOR_TOOLBAR (editor_toolbar_get_type ())
#define EDITOR_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDITOR_TOOLBAR, EditorToolbar))
#define EDITOR_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDITOR_TOOLBAR, EditorToolbarClass))
#define IS_EDITOR_TOOLBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDITOR_TOOLBAR))
#define IS_EDITOR_TOOLBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDITOR_TOOLBAR))
#define EDITOR_TOOLBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDITOR_TOOLBAR, EditorToolbarClass))

typedef struct _EditorToolbar EditorToolbar;
typedef struct _EditorToolbarClass EditorToolbarClass;
typedef struct _EditorToolbarPrivate EditorToolbarPrivate;

#define MAIL_TYPE_WEB_VIEW (mail_web_view_get_type ())
#define MAIL_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), MAIL_TYPE_WEB_VIEW, MailWebView))
#define MAIL_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), MAIL_TYPE_WEB_VIEW, MailWebViewClass))
#define MAIL_IS_WEB_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MAIL_TYPE_WEB_VIEW))
#define MAIL_IS_WEB_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MAIL_TYPE_WEB_VIEW))
#define MAIL_WEB_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), MAIL_TYPE_WEB_VIEW, MailWebViewClass))

typedef struct _MailWebView MailWebView;
typedef struct _MailWebViewClass MailWebViewClass;
enum  {
	EDITOR_TOOLBAR_0_PROPERTY,
	EDITOR_TOOLBAR_WEB_VIEW_PROPERTY,
	EDITOR_TOOLBAR_NUM_PROPERTIES
};
static GParamSpec* editor_toolbar_properties[EDITOR_TOOLBAR_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block18Data Block18Data;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_INSERT_LINK_DIALOG (insert_link_dialog_get_type ())
#define INSERT_LINK_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_INSERT_LINK_DIALOG, InsertLinkDialog))
#define INSERT_LINK_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_INSERT_LINK_DIALOG, InsertLinkDialogClass))
#define IS_INSERT_LINK_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_INSERT_LINK_DIALOG))
#define IS_INSERT_LINK_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_INSERT_LINK_DIALOG))
#define INSERT_LINK_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_INSERT_LINK_DIALOG, InsertLinkDialogClass))

typedef struct _InsertLinkDialog InsertLinkDialog;
typedef struct _InsertLinkDialogClass InsertLinkDialogClass;
typedef struct _EditorToolbarAskInsertLinkData EditorToolbarAskInsertLinkData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _EditorToolbar {
	GtkBox parent_instance;
	EditorToolbarPrivate * priv;
};

struct _EditorToolbarClass {
	GtkBoxClass parent_class;
};

struct _EditorToolbarPrivate {
	MailWebView* _web_view;
	GSimpleActionGroup* action_group;
};

struct _Block18Data {
	int _ref_count_;
	EditorToolbar* self;
	gchar* selected_text;
	gpointer _async_data_;
};

struct _EditorToolbarAskInsertLinkData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	EditorToolbar* self;
	Block18Data* _data18_;
	MailWebView* _tmp0_;
	gchar* _tmp1_;
	InsertLinkDialog* insert_link_dialog;
	GtkWidget* _tmp2_;
	GtkWindow* _tmp3_;
	InsertLinkDialog* _tmp4_;
};

static gint EditorToolbar_private_offset;
static gpointer editor_toolbar_parent_class = NULL;

VALA_EXTERN GType editor_toolbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EditorToolbar, g_object_unref)
VALA_EXTERN GType mail_web_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MailWebView, g_object_unref)
static void editor_toolbar_on_edit_action (EditorToolbar* self,
                                    GSimpleAction* action,
                                    GVariant* param);
static void _editor_toolbar_on_edit_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void editor_toolbar_on_insert_link_clicked (EditorToolbar* self);
static void _editor_toolbar_on_insert_link_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                              GVariant* parameter,
                                                                              gpointer self);
static void editor_toolbar_on_remove_format (EditorToolbar* self);
static void _editor_toolbar_on_remove_format_gsimple_action_activate_callback (GSimpleAction* action,
                                                                        GVariant* parameter,
                                                                        gpointer self);
VALA_EXTERN EditorToolbar* editor_toolbar_new (MailWebView* web_view);
VALA_EXTERN EditorToolbar* editor_toolbar_construct (GType object_type,
                                         MailWebView* web_view);
static void editor_toolbar_ask_insert_link (EditorToolbar* self,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
static void editor_toolbar_ask_insert_link_finish (EditorToolbar* self,
                                            GAsyncResult* _res_);
static void editor_toolbar_ask_insert_link_data_free (gpointer _data);
static gboolean editor_toolbar_ask_insert_link_co (EditorToolbarAskInsertLinkData* _data_);
static Block18Data* block18_data_ref (Block18Data* _data18_);
static void block18_data_unref (void * _userdata_);
VALA_EXTERN MailWebView* editor_toolbar_get_web_view (EditorToolbar* self);
VALA_EXTERN void mail_web_view_get_selected_text (MailWebView* self,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gchar* mail_web_view_get_selected_text_finish (MailWebView* self,
                                               GAsyncResult* _res_);
static void editor_toolbar_ask_insert_link_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
VALA_EXTERN GType insert_link_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (InsertLinkDialog, g_object_unref)
VALA_EXTERN InsertLinkDialog* insert_link_dialog_new (const gchar* text);
VALA_EXTERN InsertLinkDialog* insert_link_dialog_construct (GType object_type,
                                                const gchar* text);
static void __lambda110_ (Block18Data* _data18_,
                   const gchar* url,
                   const gchar* title);
static void editor_toolbar_on_link_inserted (EditorToolbar* self,
                                      const gchar* url,
                                      const gchar* title,
                                      const gchar* selected_text);
static void ___lambda110__insert_link_dialog_insert_link (InsertLinkDialog* _sender,
                                                   const gchar* url,
                                                   const gchar* title,
                                                   gpointer self);
VALA_EXTERN void mail_web_view_execute_editor_command (MailWebView* self,
                                           const gchar* command,
                                           const gchar* argument);
static void editor_toolbar_update_actions (EditorToolbar* self);
VALA_EXTERN void mail_web_view_query_command_state (MailWebView* self,
                                        const gchar* command,
                                        GAsyncReadyCallback _callback_,
                                        gpointer _user_data_);
VALA_EXTERN gboolean mail_web_view_query_command_state_finish (MailWebView* self,
                                                   GAsyncResult* _res_);
static void __lambda104_ (EditorToolbar* self,
                   GObject* obj,
                   GAsyncResult* res);
static GVariant* _variant_new4 (const gchar* value);
static void ___lambda104__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __lambda105_ (EditorToolbar* self,
                   GObject* obj,
                   GAsyncResult* res);
static GVariant* _variant_new5 (const gchar* value);
static void ___lambda105__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __lambda106_ (EditorToolbar* self,
                   GObject* obj,
                   GAsyncResult* res);
static GVariant* _variant_new6 (const gchar* value);
static void ___lambda106__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void __lambda107_ (EditorToolbar* self,
                   GObject* obj,
                   GAsyncResult* res);
static GVariant* _variant_new7 (const gchar* value);
static void ___lambda107__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void editor_toolbar_set_web_view (EditorToolbar* self,
                                  MailWebView* value);
static GObject * editor_toolbar_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static GVariant* _variant_new8 (const gchar* value);
static GVariant* _variant_new9 (const gchar* value);
static GVariant* _variant_new10 (const gchar* value);
static GVariant* _variant_new11 (const gchar* value);
static GVariant* _variant_new12 (const gchar* value);
static GVariant* _variant_new13 (const gchar* value);
static GVariant* _variant_new14 (const gchar* value);
static GVariant* _variant_new15 (const gchar* value);
static void _editor_toolbar___lambda111_ (EditorToolbar* self);
static void __editor_toolbar___lambda111__gtk_widget_map (GtkWidget* _sender,
                                                   gpointer self);
static void _editor_toolbar_update_actions_mail_web_view_selection_changed (MailWebView* _sender,
                                                                     gpointer self);
static void editor_toolbar_finalize (GObject * obj);
static GType editor_toolbar_get_type_once (void);
static void _vala_editor_toolbar_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_editor_toolbar_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GActionEntry EDITOR_TOOLBAR_ACTION_ENTRIES[6] = {{EDITOR_TOOLBAR_ACTION_BOLD, _editor_toolbar_on_edit_action_gsimple_action_activate_callback, "s", "''"}, {EDITOR_TOOLBAR_ACTION_ITALIC, _editor_toolbar_on_edit_action_gsimple_action_activate_callback, "s", "''"}, {EDITOR_TOOLBAR_ACTION_UNDERLINE, _editor_toolbar_on_edit_action_gsimple_action_activate_callback, "s", "''"}, {EDITOR_TOOLBAR_ACTION_STRIKETHROUGH, _editor_toolbar_on_edit_action_gsimple_action_activate_callback, "s", "''"}, {EDITOR_TOOLBAR_ACTION_INSERT_LINK, _editor_toolbar_on_insert_link_clicked_gsimple_action_activate_callback}, {EDITOR_TOOLBAR_ACTION_REMOVE_FORMAT, _editor_toolbar_on_remove_format_gsimple_action_activate_callback}};

static inline gpointer
editor_toolbar_get_instance_private (EditorToolbar* self)
{
	return G_STRUCT_MEMBER_P (self, EditorToolbar_private_offset);
}

static void
_editor_toolbar_on_edit_action_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	editor_toolbar_on_edit_action ((EditorToolbar*) self, action, parameter);
}

static void
_editor_toolbar_on_insert_link_clicked_gsimple_action_activate_callback (GSimpleAction* action,
                                                                         GVariant* parameter,
                                                                         gpointer self)
{
	editor_toolbar_on_insert_link_clicked ((EditorToolbar*) self);
}

static void
_editor_toolbar_on_remove_format_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self)
{
	editor_toolbar_on_remove_format ((EditorToolbar*) self);
}

EditorToolbar*
editor_toolbar_construct (GType object_type,
                          MailWebView* web_view)
{
	EditorToolbar * self = NULL;
	g_return_val_if_fail (web_view != NULL, NULL);
	self = (EditorToolbar*) g_object_new (object_type, "web-view", web_view, NULL);
	return self;
}

EditorToolbar*
editor_toolbar_new (MailWebView* web_view)
{
	return editor_toolbar_construct (TYPE_EDITOR_TOOLBAR, web_view);
}

static void
editor_toolbar_on_insert_link_clicked (EditorToolbar* self)
{
	g_return_if_fail (self != NULL);
	editor_toolbar_ask_insert_link (self, NULL, NULL);
}

static void
editor_toolbar_ask_insert_link_data_free (gpointer _data)
{
	EditorToolbarAskInsertLinkData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (EditorToolbarAskInsertLinkData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
editor_toolbar_ask_insert_link (EditorToolbar* self,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	EditorToolbarAskInsertLinkData* _data_;
	EditorToolbar* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (EditorToolbarAskInsertLinkData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, editor_toolbar_ask_insert_link_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	editor_toolbar_ask_insert_link_co (_data_);
}

static void
editor_toolbar_ask_insert_link_finish (EditorToolbar* self,
                                       GAsyncResult* _res_)
{
	EditorToolbarAskInsertLinkData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block18Data*
block18_data_ref (Block18Data* _data18_)
{
	g_atomic_int_inc (&_data18_->_ref_count_);
	return _data18_;
}

static void
block18_data_unref (void * _userdata_)
{
	Block18Data* _data18_;
	_data18_ = (Block18Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data18_->_ref_count_)) {
		EditorToolbar* self;
		self = _data18_->self;
		_g_free0 (_data18_->selected_text);
		_g_object_unref0 (self);
		g_slice_free (Block18Data, _data18_);
	}
}

static void
editor_toolbar_ask_insert_link_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	EditorToolbarAskInsertLinkData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	editor_toolbar_ask_insert_link_co (_data_);
}

static void
__lambda110_ (Block18Data* _data18_,
              const gchar* url,
              const gchar* title)
{
	EditorToolbar* self;
	self = _data18_->self;
	g_return_if_fail (url != NULL);
	g_return_if_fail (title != NULL);
	editor_toolbar_on_link_inserted (self, url, title, _data18_->selected_text);
}

static void
___lambda110__insert_link_dialog_insert_link (InsertLinkDialog* _sender,
                                              const gchar* url,
                                              const gchar* title,
                                              gpointer self)
{
	__lambda110_ (self, url, title);
}

static gboolean
editor_toolbar_ask_insert_link_co (EditorToolbarAskInsertLinkData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data18_ = g_slice_new0 (Block18Data);
	_data_->_data18_->_ref_count_ = 1;
	_data_->_data18_->self = g_object_ref (_data_->self);
	_data_->_data18_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->_web_view;
	_data_->_state_ = 1;
	mail_web_view_get_selected_text (_data_->_tmp0_, editor_toolbar_ask_insert_link_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp1_ = mail_web_view_get_selected_text_finish (_data_->_tmp0_, _data_->_res_);
	_data_->_data18_->selected_text = _data_->_tmp1_;
	_data_->_tmp2_ = gtk_widget_get_toplevel ((GtkWidget*) _data_->self);
	_data_->_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp2_, gtk_window_get_type (), GtkWindow));
	_data_->_tmp4_ = NULL;
	_data_->_tmp4_ = insert_link_dialog_new (_data_->_data18_->selected_text);
	gtk_window_set_transient_for ((GtkWindow*) _data_->_tmp4_, _data_->_tmp3_);
	_g_object_unref0 (_data_->_tmp3_);
	g_object_ref_sink (_data_->_tmp4_);
	_data_->insert_link_dialog = _data_->_tmp4_;
	gtk_window_present ((GtkWindow*) _data_->insert_link_dialog);
	g_signal_connect_data (_data_->insert_link_dialog, "insert-link", (GCallback) ___lambda110__insert_link_dialog_insert_link, block18_data_ref (_data_->_data18_), (GClosureNotify) block18_data_unref, 0);
	_g_object_unref0 (_data_->insert_link_dialog);
	block18_data_unref (_data_->_data18_);
	_data_->_data18_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
editor_toolbar_on_link_inserted (EditorToolbar* self,
                                 const gchar* url,
                                 const gchar* title,
                                 const gchar* selected_text)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (url != NULL);
	g_return_if_fail (title != NULL);
	if (selected_text != NULL) {
		_tmp0_ = g_strcmp0 (title, selected_text) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		MailWebView* _tmp1_;
		_tmp1_ = self->priv->_web_view;
		mail_web_view_execute_editor_command (_tmp1_, "createLink", url);
	} else {
		gboolean _tmp2_ = FALSE;
		if (title != NULL) {
			gint _tmp3_;
			gint _tmp4_;
			_tmp3_ = strlen (title);
			_tmp4_ = _tmp3_;
			_tmp2_ = _tmp4_ > 0;
		} else {
			_tmp2_ = FALSE;
		}
		if (_tmp2_) {
			MailWebView* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp5_ = self->priv->_web_view;
			_tmp6_ = g_strdup_printf ("<a href=\"%s\">%s</a>", url, title);
			_tmp7_ = _tmp6_;
			mail_web_view_execute_editor_command (_tmp5_, "insertHTML", _tmp7_);
			_g_free0 (_tmp7_);
		} else {
			MailWebView* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp8_ = self->priv->_web_view;
			_tmp9_ = g_strdup_printf ("<a href=\"%s\">%s</a>", url, url);
			_tmp10_ = _tmp9_;
			mail_web_view_execute_editor_command (_tmp8_, "insertHTML", _tmp10_);
			_g_free0 (_tmp10_);
		}
	}
}

static void
editor_toolbar_on_edit_action (EditorToolbar* self,
                               GSimpleAction* action,
                               GVariant* param)
{
	gchar* command = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	MailWebView* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	_tmp0_ = g_variant_get_string (param, NULL);
	_tmp1_ = g_strdup (_tmp0_);
	command = _tmp1_;
	_tmp2_ = self->priv->_web_view;
	mail_web_view_execute_editor_command (_tmp2_, command, "");
	editor_toolbar_update_actions (self);
	_g_free0 (command);
}

static void
editor_toolbar_on_remove_format (EditorToolbar* self)
{
	MailWebView* _tmp0_;
	MailWebView* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_web_view;
	mail_web_view_execute_editor_command (_tmp0_, "removeformat", "");
	_tmp1_ = self->priv->_web_view;
	mail_web_view_execute_editor_command (_tmp1_, "unlink", "");
}

static GVariant*
_variant_new4 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
__lambda104_ (EditorToolbar* self,
              GObject* obj,
              GAsyncResult* res)
{
	const gchar* _tmp0_ = NULL;
	MailWebView* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (res != NULL);
	_tmp1_ = self->priv->_web_view;
	if (mail_web_view_query_command_state_finish (_tmp1_, res)) {
		_tmp0_ = EDITOR_TOOLBAR_ACTION_BOLD;
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = self->priv->action_group;
	_tmp3_ = _variant_new4 (_tmp0_);
	g_action_group_change_action_state ((GActionGroup*) _tmp2_, EDITOR_TOOLBAR_ACTION_BOLD, _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static void
___lambda104__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda104_ ((EditorToolbar*) self, source_object, res);
	g_object_unref (self);
}

static GVariant*
_variant_new5 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
__lambda105_ (EditorToolbar* self,
              GObject* obj,
              GAsyncResult* res)
{
	const gchar* _tmp0_ = NULL;
	MailWebView* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (res != NULL);
	_tmp1_ = self->priv->_web_view;
	if (mail_web_view_query_command_state_finish (_tmp1_, res)) {
		_tmp0_ = EDITOR_TOOLBAR_ACTION_ITALIC;
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = self->priv->action_group;
	_tmp3_ = _variant_new5 (_tmp0_);
	g_action_group_change_action_state ((GActionGroup*) _tmp2_, EDITOR_TOOLBAR_ACTION_ITALIC, _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static void
___lambda105__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda105_ ((EditorToolbar*) self, source_object, res);
	g_object_unref (self);
}

static GVariant*
_variant_new6 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
__lambda106_ (EditorToolbar* self,
              GObject* obj,
              GAsyncResult* res)
{
	const gchar* _tmp0_ = NULL;
	MailWebView* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (res != NULL);
	_tmp1_ = self->priv->_web_view;
	if (mail_web_view_query_command_state_finish (_tmp1_, res)) {
		_tmp0_ = EDITOR_TOOLBAR_ACTION_UNDERLINE;
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = self->priv->action_group;
	_tmp3_ = _variant_new6 (_tmp0_);
	g_action_group_change_action_state ((GActionGroup*) _tmp2_, EDITOR_TOOLBAR_ACTION_UNDERLINE, _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static void
___lambda106__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda106_ ((EditorToolbar*) self, source_object, res);
	g_object_unref (self);
}

static GVariant*
_variant_new7 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
__lambda107_ (EditorToolbar* self,
              GObject* obj,
              GAsyncResult* res)
{
	const gchar* _tmp0_ = NULL;
	MailWebView* _tmp1_;
	GSimpleActionGroup* _tmp2_;
	GVariant* _tmp3_;
	g_return_if_fail (res != NULL);
	_tmp1_ = self->priv->_web_view;
	if (mail_web_view_query_command_state_finish (_tmp1_, res)) {
		_tmp0_ = EDITOR_TOOLBAR_ACTION_STRIKETHROUGH;
	} else {
		_tmp0_ = "";
	}
	_tmp2_ = self->priv->action_group;
	_tmp3_ = _variant_new7 (_tmp0_);
	g_action_group_change_action_state ((GActionGroup*) _tmp2_, EDITOR_TOOLBAR_ACTION_STRIKETHROUGH, _tmp3_);
	_g_variant_unref0 (_tmp3_);
}

static void
___lambda107__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda107_ ((EditorToolbar*) self, source_object, res);
	g_object_unref (self);
}

static void
editor_toolbar_update_actions (EditorToolbar* self)
{
	MailWebView* _tmp0_;
	MailWebView* _tmp1_;
	MailWebView* _tmp2_;
	MailWebView* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_web_view;
	mail_web_view_query_command_state (_tmp0_, "bold", ___lambda104__gasync_ready_callback, g_object_ref (self));
	_tmp1_ = self->priv->_web_view;
	mail_web_view_query_command_state (_tmp1_, "italic", ___lambda105__gasync_ready_callback, g_object_ref (self));
	_tmp2_ = self->priv->_web_view;
	mail_web_view_query_command_state (_tmp2_, "underline", ___lambda106__gasync_ready_callback, g_object_ref (self));
	_tmp3_ = self->priv->_web_view;
	mail_web_view_query_command_state (_tmp3_, "strikethrough", ___lambda107__gasync_ready_callback, g_object_ref (self));
}

MailWebView*
editor_toolbar_get_web_view (EditorToolbar* self)
{
	MailWebView* result;
	MailWebView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_web_view;
	result = _tmp0_;
	return result;
}

static void
editor_toolbar_set_web_view (EditorToolbar* self,
                             MailWebView* value)
{
	MailWebView* old_value;
	g_return_if_fail (self != NULL);
	old_value = editor_toolbar_get_web_view (self);
	if (old_value != value) {
		MailWebView* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_web_view);
		self->priv->_web_view = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, editor_toolbar_properties[EDITOR_TOOLBAR_WEB_VIEW_PROPERTY]);
	}
}

static GVariant*
_variant_new8 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new9 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new10 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new11 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new12 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new13 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new14 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GVariant*
_variant_new15 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static void
_editor_toolbar___lambda111_ (EditorToolbar* self)
{
	GtkWidget* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = self->priv->action_group;
	gtk_widget_insert_action_group (_tmp0_, EDITOR_TOOLBAR_ACTION_GROUP_PREFIX, (GActionGroup*) _tmp1_);
}

static void
__editor_toolbar___lambda111__gtk_widget_map (GtkWidget* _sender,
                                              gpointer self)
{
	_editor_toolbar___lambda111_ ((EditorToolbar*) self);
}

static void
_editor_toolbar_update_actions_mail_web_view_selection_changed (MailWebView* _sender,
                                                                gpointer self)
{
	editor_toolbar_update_actions ((EditorToolbar*) self);
}

static GObject *
editor_toolbar_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	EditorToolbar * self;
	GSimpleActionGroup* _tmp0_;
	GSimpleActionGroup* _tmp1_;
	GtkApplication* application = NULL;
	GApplication* _tmp2_;
	GtkApplication* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	GtkApplication* _tmp7_;
	GVariant* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar** _tmp12_;
	gchar** _tmp13_;
	gint _tmp13__length1;
	GtkApplication* _tmp14_;
	GVariant* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GtkToggleButton* bold = NULL;
	gchar* _tmp21_;
	GVariant* _tmp22_;
	GtkImage* _tmp23_;
	gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gint _tmp26__length1;
	gchar* _tmp27_;
	GtkToggleButton* _tmp28_ = NULL;
	GtkToggleButton* _tmp29_;
	GtkToggleButton* italic = NULL;
	gchar* _tmp30_;
	GVariant* _tmp31_;
	GtkImage* _tmp32_;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_;
	gint _tmp35__length1;
	gchar* _tmp36_;
	GtkToggleButton* _tmp37_ = NULL;
	GtkToggleButton* _tmp38_;
	GtkToggleButton* underline = NULL;
	gchar* _tmp39_;
	GVariant* _tmp40_;
	GtkImage* _tmp41_;
	GtkApplication* _tmp42_;
	GVariant* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	GtkToggleButton* _tmp50_ = NULL;
	GtkToggleButton* _tmp51_;
	GtkToggleButton* strikethrough = NULL;
	gchar* _tmp52_;
	GVariant* _tmp53_;
	GtkImage* _tmp54_;
	GtkApplication* _tmp55_;
	GVariant* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	gchar** _tmp59_;
	gchar** _tmp60_;
	gchar** _tmp61_;
	gint _tmp61__length1;
	gchar* _tmp62_;
	GtkToggleButton* _tmp63_ = NULL;
	GtkToggleButton* _tmp64_;
	GtkBox* formatting_buttons = NULL;
	GtkBox* _tmp65_;
	GtkBox* _tmp66_;
	GtkStyleContext* _tmp67_;
	GtkBox* _tmp68_;
	GtkToggleButton* _tmp69_;
	GtkBox* _tmp70_;
	GtkToggleButton* _tmp71_;
	GtkBox* _tmp72_;
	GtkToggleButton* _tmp73_;
	GtkBox* _tmp74_;
	GtkToggleButton* _tmp75_;
	GtkButton* clear_format = NULL;
	gchar* _tmp76_;
	GtkApplication* _tmp77_;
	gchar** _tmp78_;
	gchar** _tmp79_;
	gchar** _tmp80_;
	gint _tmp80__length1;
	gchar* _tmp81_;
	GtkButton* _tmp82_ = NULL;
	GtkButton* _tmp83_;
	GtkButton* link = NULL;
	gchar* _tmp84_;
	GtkApplication* _tmp85_;
	gchar** _tmp86_;
	gchar** _tmp87_;
	gchar** _tmp88_;
	gint _tmp88__length1;
	gchar* _tmp89_;
	GtkButton* _tmp90_ = NULL;
	GtkButton* _tmp91_;
	GtkBox* _tmp92_;
	GtkButton* _tmp93_;
	GtkButton* _tmp94_;
	MailWebView* _tmp95_;
	parent_class = G_OBJECT_CLASS (editor_toolbar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDITOR_TOOLBAR, EditorToolbar);
	_tmp0_ = g_simple_action_group_new ();
	_g_object_unref0 (self->priv->action_group);
	self->priv->action_group = _tmp0_;
	_tmp1_ = self->priv->action_group;
	g_action_map_add_action_entries ((GActionMap*) _tmp1_, EDITOR_TOOLBAR_ACTION_ENTRIES, (gint) G_N_ELEMENTS (EDITOR_TOOLBAR_ACTION_ENTRIES), self);
	_tmp2_ = g_application_get_default ();
	application = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_application_get_type (), GtkApplication);
	_tmp3_ = application;
	_tmp4_ = g_strdup ("<Control>K");
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 1;
	gtk_application_set_accels_for_action (_tmp3_, EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_INSERT_LINK, _tmp6_);
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	_tmp7_ = application;
	_tmp8_ = _variant_new8 (EDITOR_TOOLBAR_ACTION_STRIKETHROUGH);
	_tmp9_ = g_action_print_detailed_name (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_STRIKETHROUGH, _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strdup ("<Control>percent");
	_tmp12_ = g_new0 (gchar*, 1 + 1);
	_tmp12_[0] = _tmp11_;
	_tmp13_ = _tmp12_;
	_tmp13__length1 = 1;
	gtk_application_set_accels_for_action (_tmp7_, _tmp10_, _tmp13_);
	_tmp13_ = (_vala_array_free (_tmp13_, _tmp13__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp10_);
	_g_variant_unref0 (_tmp8_);
	_tmp14_ = application;
	_tmp15_ = _variant_new9 (EDITOR_TOOLBAR_ACTION_UNDERLINE);
	_tmp16_ = g_action_print_detailed_name (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_UNDERLINE, _tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = g_strdup ("<Control>U");
	_tmp19_ = g_new0 (gchar*, 1 + 1);
	_tmp19_[0] = _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 1;
	gtk_application_set_accels_for_action (_tmp14_, _tmp17_, _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp17_);
	_g_variant_unref0 (_tmp15_);
	_tmp21_ = g_strdup (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_BOLD);
	_tmp22_ = _variant_new10 (EDITOR_TOOLBAR_ACTION_BOLD);
	_tmp23_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-bold-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp23_);
	_tmp24_ = g_strdup ("<Ctrl>B");
	_tmp25_ = g_new0 (gchar*, 1 + 1);
	_tmp25_[0] = _tmp24_;
	_tmp26_ = _tmp25_;
	_tmp26__length1 = 1;
	_tmp27_ = granite_markup_accel_tooltip (_tmp26_, (gint) 1, _ ("Bold"));
	_tmp28_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp28_, _tmp21_);
	_g_free0 (_tmp21_);
	g_object_set ((GtkActionable*) _tmp28_, "action-target", _tmp22_, NULL);
	_g_variant_unref0 (_tmp22_);
	gtk_button_set_image ((GtkButton*) _tmp28_, (GtkWidget*) _tmp23_);
	_g_object_unref0 (_tmp23_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp28_, _tmp27_);
	_g_free0 (_tmp27_);
	g_object_ref_sink (_tmp28_);
	_tmp29_ = _tmp28_;
	_tmp26_ = (_vala_array_free (_tmp26_, _tmp26__length1, (GDestroyNotify) g_free), NULL);
	bold = _tmp29_;
	_tmp30_ = g_strdup (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_ITALIC);
	_tmp31_ = _variant_new11 (EDITOR_TOOLBAR_ACTION_ITALIC);
	_tmp32_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-italic-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp32_);
	_tmp33_ = g_strdup ("<Ctrl>I");
	_tmp34_ = g_new0 (gchar*, 1 + 1);
	_tmp34_[0] = _tmp33_;
	_tmp35_ = _tmp34_;
	_tmp35__length1 = 1;
	_tmp36_ = granite_markup_accel_tooltip (_tmp35_, (gint) 1, _ ("Italic"));
	_tmp37_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp37_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_set ((GtkActionable*) _tmp37_, "action-target", _tmp31_, NULL);
	_g_variant_unref0 (_tmp31_);
	gtk_button_set_image ((GtkButton*) _tmp37_, (GtkWidget*) _tmp32_);
	_g_object_unref0 (_tmp32_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp37_, _tmp36_);
	_g_free0 (_tmp36_);
	g_object_ref_sink (_tmp37_);
	_tmp38_ = _tmp37_;
	_tmp35_ = (_vala_array_free (_tmp35_, _tmp35__length1, (GDestroyNotify) g_free), NULL);
	italic = _tmp38_;
	_tmp39_ = g_strdup (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_UNDERLINE);
	_tmp40_ = _variant_new12 (EDITOR_TOOLBAR_ACTION_UNDERLINE);
	_tmp41_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-underline-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp41_);
	_tmp42_ = application;
	_tmp43_ = _variant_new13 (EDITOR_TOOLBAR_ACTION_UNDERLINE);
	_tmp44_ = g_action_print_detailed_name (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_UNDERLINE, _tmp43_);
	_tmp45_ = _tmp44_;
	_tmp47_ = _tmp46_ = gtk_application_get_accels_for_action (_tmp42_, _tmp45_);
	_tmp48_ = _tmp47_;
	_tmp48__length1 = _vala_array_length (_tmp46_);
	_tmp49_ = granite_markup_accel_tooltip (_tmp48_, (gint) _vala_array_length (_tmp46_), _ ("Underline"));
	_tmp50_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp50_, _tmp39_);
	_g_free0 (_tmp39_);
	g_object_set ((GtkActionable*) _tmp50_, "action-target", _tmp40_, NULL);
	_g_variant_unref0 (_tmp40_);
	gtk_button_set_image ((GtkButton*) _tmp50_, (GtkWidget*) _tmp41_);
	_g_object_unref0 (_tmp41_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp50_, _tmp49_);
	_g_free0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	_tmp51_ = _tmp50_;
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp45_);
	_g_variant_unref0 (_tmp43_);
	underline = _tmp51_;
	_tmp52_ = g_strdup (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_STRIKETHROUGH);
	_tmp53_ = _variant_new14 (EDITOR_TOOLBAR_ACTION_STRIKETHROUGH);
	_tmp54_ = (GtkImage*) gtk_image_new_from_icon_name ("format-text-strikethrough-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp54_);
	_tmp55_ = application;
	_tmp56_ = _variant_new15 (EDITOR_TOOLBAR_ACTION_STRIKETHROUGH);
	_tmp57_ = g_action_print_detailed_name (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_STRIKETHROUGH, _tmp56_);
	_tmp58_ = _tmp57_;
	_tmp60_ = _tmp59_ = gtk_application_get_accels_for_action (_tmp55_, _tmp58_);
	_tmp61_ = _tmp60_;
	_tmp61__length1 = _vala_array_length (_tmp59_);
	_tmp62_ = granite_markup_accel_tooltip (_tmp61_, (gint) _vala_array_length (_tmp59_), _ ("Strikethrough"));
	_tmp63_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp63_, _tmp52_);
	_g_free0 (_tmp52_);
	g_object_set ((GtkActionable*) _tmp63_, "action-target", _tmp53_, NULL);
	_g_variant_unref0 (_tmp53_);
	gtk_button_set_image ((GtkButton*) _tmp63_, (GtkWidget*) _tmp54_);
	_g_object_unref0 (_tmp54_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp63_, _tmp62_);
	_g_free0 (_tmp62_);
	g_object_ref_sink (_tmp63_);
	_tmp64_ = _tmp63_;
	_tmp61_ = (_vala_array_free (_tmp61_, _tmp61__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp58_);
	_g_variant_unref0 (_tmp56_);
	strikethrough = _tmp64_;
	_tmp65_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp65_);
	formatting_buttons = _tmp65_;
	_tmp66_ = formatting_buttons;
	_tmp67_ = gtk_widget_get_style_context ((GtkWidget*) _tmp66_);
	gtk_style_context_add_class (_tmp67_, GTK_STYLE_CLASS_LINKED);
	_tmp68_ = formatting_buttons;
	_tmp69_ = bold;
	gtk_container_add ((GtkContainer*) _tmp68_, (GtkWidget*) _tmp69_);
	_tmp70_ = formatting_buttons;
	_tmp71_ = italic;
	gtk_container_add ((GtkContainer*) _tmp70_, (GtkWidget*) _tmp71_);
	_tmp72_ = formatting_buttons;
	_tmp73_ = underline;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = formatting_buttons;
	_tmp75_ = strikethrough;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = g_strdup (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_REMOVE_FORMAT);
	_tmp77_ = application;
	_tmp79_ = _tmp78_ = gtk_application_get_accels_for_action (_tmp77_, EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_REMOVE_FORMAT);
	_tmp80_ = _tmp79_;
	_tmp80__length1 = _vala_array_length (_tmp78_);
	_tmp81_ = granite_markup_accel_tooltip (_tmp80_, (gint) _vala_array_length (_tmp78_), _ ("Remove formatting"));
	_tmp82_ = (GtkButton*) gtk_button_new_from_icon_name ("format-text-clear-formatting-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp82_, _tmp76_);
	_g_free0 (_tmp76_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp82_, _tmp81_);
	_g_free0 (_tmp81_);
	g_object_ref_sink (_tmp82_);
	_tmp83_ = _tmp82_;
	_tmp80_ = (_vala_array_free (_tmp80_, _tmp80__length1, (GDestroyNotify) g_free), NULL);
	clear_format = _tmp83_;
	_tmp84_ = g_strdup (EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_INSERT_LINK);
	_tmp85_ = application;
	_tmp87_ = _tmp86_ = gtk_application_get_accels_for_action (_tmp85_, EDITOR_TOOLBAR_ACTION_PREFIX EDITOR_TOOLBAR_ACTION_INSERT_LINK);
	_tmp88_ = _tmp87_;
	_tmp88__length1 = _vala_array_length (_tmp86_);
	_tmp89_ = granite_markup_accel_tooltip (_tmp88_, (gint) _vala_array_length (_tmp86_), _ ("Insert Link"));
	_tmp90_ = (GtkButton*) gtk_button_new_from_icon_name ("insert-link-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp90_, _tmp84_);
	_g_free0 (_tmp84_);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp90_, _tmp89_);
	_g_free0 (_tmp89_);
	g_object_ref_sink (_tmp90_);
	_tmp91_ = _tmp90_;
	_tmp88_ = (_vala_array_free (_tmp88_, _tmp88__length1, (GDestroyNotify) g_free), NULL);
	link = _tmp91_;
	gtk_widget_set_margin_start ((GtkWidget*) self, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) self, 6);
	gtk_box_set_spacing ((GtkBox*) self, 6);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_HORIZONTAL);
	_tmp92_ = formatting_buttons;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp92_);
	_tmp93_ = clear_format;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp93_);
	_tmp94_ = link;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp94_);
	g_signal_connect_object ((GtkWidget*) self, "map", (GCallback) __editor_toolbar___lambda111__gtk_widget_map, self, 0);
	_tmp95_ = self->priv->_web_view;
	g_signal_connect_object (_tmp95_, "selection-changed", (GCallback) _editor_toolbar_update_actions_mail_web_view_selection_changed, self, 0);
	_g_object_unref0 (link);
	_g_object_unref0 (clear_format);
	_g_object_unref0 (formatting_buttons);
	_g_object_unref0 (strikethrough);
	_g_object_unref0 (underline);
	_g_object_unref0 (italic);
	_g_object_unref0 (bold);
	return obj;
}

static void
editor_toolbar_class_init (EditorToolbarClass * klass,
                           gpointer klass_data)
{
	editor_toolbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &EditorToolbar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_editor_toolbar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_editor_toolbar_set_property;
	G_OBJECT_CLASS (klass)->constructor = editor_toolbar_constructor;
	G_OBJECT_CLASS (klass)->finalize = editor_toolbar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), EDITOR_TOOLBAR_WEB_VIEW_PROPERTY, editor_toolbar_properties[EDITOR_TOOLBAR_WEB_VIEW_PROPERTY] = g_param_spec_object ("web-view", "web-view", "web-view", MAIL_TYPE_WEB_VIEW, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
editor_toolbar_instance_init (EditorToolbar * self,
                              gpointer klass)
{
	self->priv = editor_toolbar_get_instance_private (self);
}

static void
editor_toolbar_finalize (GObject * obj)
{
	EditorToolbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_EDITOR_TOOLBAR, EditorToolbar);
	_g_object_unref0 (self->priv->_web_view);
	_g_object_unref0 (self->priv->action_group);
	G_OBJECT_CLASS (editor_toolbar_parent_class)->finalize (obj);
}

static GType
editor_toolbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (EditorToolbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) editor_toolbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditorToolbar), 0, (GInstanceInitFunc) editor_toolbar_instance_init, NULL };
	GType editor_toolbar_type_id;
	editor_toolbar_type_id = g_type_register_static (gtk_box_get_type (), "EditorToolbar", &g_define_type_info, 0);
	EditorToolbar_private_offset = g_type_add_instance_private (editor_toolbar_type_id, sizeof (EditorToolbarPrivate));
	return editor_toolbar_type_id;
}

GType
editor_toolbar_get_type (void)
{
	static volatile gsize editor_toolbar_type_id__once = 0;
	if (g_once_init_enter (&editor_toolbar_type_id__once)) {
		GType editor_toolbar_type_id;
		editor_toolbar_type_id = editor_toolbar_get_type_once ();
		g_once_init_leave (&editor_toolbar_type_id__once, editor_toolbar_type_id);
	}
	return editor_toolbar_type_id__once;
}

static void
_vala_editor_toolbar_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	EditorToolbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EDITOR_TOOLBAR, EditorToolbar);
	switch (property_id) {
		case EDITOR_TOOLBAR_WEB_VIEW_PROPERTY:
		g_value_set_object (value, editor_toolbar_get_web_view (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_editor_toolbar_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	EditorToolbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_EDITOR_TOOLBAR, EditorToolbar);
	switch (property_id) {
		case EDITOR_TOOLBAR_WEB_VIEW_PROPERTY:
		editor_toolbar_set_web_view (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

