/* Miller.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Miller.vala, do not modify */

/*********************/
/** Signal handling **/

#include "pantheon-files-core.h"
#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_VIEW_TYPE_MILLER (files_view_miller_get_type ())
#define FILES_VIEW_MILLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_MILLER, FilesViewMiller))
#define FILES_VIEW_MILLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_MILLER, FilesViewMillerClass))
#define FILES_VIEW_IS_MILLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_MILLER))
#define FILES_VIEW_IS_MILLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_MILLER))
#define FILES_VIEW_MILLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_MILLER, FilesViewMillerClass))

typedef struct _FilesViewMiller FilesViewMiller;
typedef struct _FilesViewMillerClass FilesViewMillerClass;
typedef struct _FilesViewMillerPrivate FilesViewMillerPrivate;

#define FILES_VIEW_TYPE_SLOT (files_view_slot_get_type ())
#define FILES_VIEW_SLOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlot))
#define FILES_VIEW_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))
#define FILES_VIEW_IS_SLOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_IS_SLOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_SLOT))
#define FILES_VIEW_SLOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_SLOT, FilesViewSlotClass))

typedef struct _FilesViewSlot FilesViewSlot;
typedef struct _FilesViewSlotClass FilesViewSlotClass;

#define FILES_VIEW_TYPE_VIEW_CONTAINER (files_view_view_container_get_type ())
#define FILES_VIEW_VIEW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainer))
#define FILES_VIEW_VIEW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainerClass))
#define FILES_VIEW_IS_VIEW_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER))
#define FILES_VIEW_IS_VIEW_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_VIEW_TYPE_VIEW_CONTAINER))
#define FILES_VIEW_VIEW_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_VIEW_TYPE_VIEW_CONTAINER, FilesViewViewContainerClass))

typedef struct _FilesViewViewContainer FilesViewViewContainer;
typedef struct _FilesViewViewContainerClass FilesViewViewContainerClass;
enum  {
	FILES_VIEW_MILLER_0_PROPERTY,
	FILES_VIEW_MILLER_CTAB_PROPERTY,
	FILES_VIEW_MILLER_ROOT_LOCATION_PROPERTY,
	FILES_VIEW_MILLER_IS_FROZEN_PROPERTY,
	FILES_VIEW_MILLER_NUM_PROPERTIES
};
static GParamSpec* files_view_miller_properties[FILES_VIEW_MILLER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _FilesViewSlotPrivate FilesViewSlotPrivate;

#define FILES_TYPE_ABSTRACT_DIRECTORY_VIEW (files_abstract_directory_view_get_type ())
#define FILES_ABSTRACT_DIRECTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryView))
#define FILES_ABSTRACT_DIRECTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryViewClass))
#define FILES_IS_ABSTRACT_DIRECTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW))
#define FILES_IS_ABSTRACT_DIRECTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW))
#define FILES_ABSTRACT_DIRECTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_ABSTRACT_DIRECTORY_VIEW, FilesAbstractDirectoryViewClass))

typedef struct _FilesAbstractDirectoryView FilesAbstractDirectoryView;
typedef struct _FilesAbstractDirectoryViewClass FilesAbstractDirectoryViewClass;
typedef struct _Block41Data Block41Data;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block42Data Block42Data;
typedef struct _Block43Data Block43Data;
typedef struct _Block44Data Block44Data;
typedef struct _Block45Data Block45Data;
typedef struct _Block46Data Block46Data;
typedef struct _Block47Data Block47Data;

struct _FilesViewMiller {
	FilesAbstractSlot parent_instance;
	FilesViewMillerPrivate * priv;
	GtkAdjustment* hadj;
	FilesViewSlot* current_slot;
	GList* slot_list;
	gint total_width;
};

struct _FilesViewMillerClass {
	FilesAbstractSlotClass parent_class;
};

struct _FilesViewMillerPrivate {
	FilesViewViewContainer* _ctab;
	GFile* _root_location;
	GtkBox* colpane;
	guint scroll_to_slot_timeout_id;
	GtkScrolledWindow* scrolled_window;
	GtkViewport* viewport;
	guint total_width_timeout_id;
	guint animation_timeout_source_id;
};

struct _FilesViewSlot {
	FilesAbstractSlot parent_instance;
	FilesViewSlotPrivate * priv;
	GtkBox* colpane;
	GtkPaned* hpane;
};

struct _FilesViewSlotClass {
	FilesAbstractSlotClass parent_class;
};

struct _Block41Data {
	int _ref_count_;
	FilesViewMiller* self;
	guint n;
};

struct _Block42Data {
	int _ref_count_;
	FilesViewMiller* self;
	FilesViewSlot* slot;
};

struct _Block43Data {
	int _ref_count_;
	FilesViewMiller* self;
	gint i;
	gint hidden;
};

struct _Block44Data {
	int _ref_count_;
	FilesViewMiller* self;
	gboolean frozen;
};

struct _Block45Data {
	int _ref_count_;
	FilesViewMiller* self;
	FilesViewSlot* slot;
	gboolean animate;
};

struct _Block46Data {
	int _ref_count_;
	Block45Data * _data45_;
	gint total_width_before;
};

struct _Block47Data {
	int _ref_count_;
	FilesViewMiller* self;
	gdouble initial;
	gdouble to_do;
	gint factor;
	gint newvalue;
	gdouble old_adj_value;
	GtkAdjustment* adj;
	gint final;
};

static gint FilesViewMiller_private_offset;
static gpointer files_view_miller_parent_class = NULL;

VALA_EXTERN GType files_view_miller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewMiller, g_object_unref)
VALA_EXTERN GType files_view_slot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewSlot, g_object_unref)
VALA_EXTERN GType files_view_view_container_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesViewViewContainer, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
VALA_EXTERN FilesViewMiller* files_view_miller_new (GFile* loc,
                                        FilesViewViewContainer* _ctab);
VALA_EXTERN FilesViewMiller* files_view_miller_construct (GType object_type,
                                              GFile* loc,
                                              FilesViewViewContainer* _ctab);
VALA_EXTERN void files_view_miller_add_location (FilesViewMiller* self,
                                     GFile* loc,
                                     FilesViewSlot* host);
VALA_EXTERN FilesViewViewContainer* files_view_miller_get_ctab (FilesViewMiller* self);
VALA_EXTERN FilesViewSlot* files_view_slot_new (GFile* _location,
                                    FilesViewViewContainer* _ctab,
                                    FilesViewMode _mode);
VALA_EXTERN FilesViewSlot* files_view_slot_construct (GType object_type,
                                          GFile* _location,
                                          FilesViewViewContainer* _ctab,
                                          FilesViewMode _mode);
VALA_EXTERN GType files_abstract_directory_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesAbstractDirectoryView, g_object_unref)
VALA_EXTERN FilesAbstractDirectoryView* files_view_slot_get_directory_view (FilesViewSlot* self);
static void files_view_miller_connect_slot_signals (FilesViewMiller* self,
                                             FilesViewSlot* slot);
static void files_view_miller_truncate_list_after_slot (FilesViewMiller* self,
                                                 FilesViewSlot* slot);
VALA_EXTERN void files_view_slot_select_gof_file (FilesViewSlot* self,
                                      FilesFile* gof);
static void files_view_miller_update_total_width (FilesViewMiller* self);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void __lambda52_ (Block41Data* _data41_,
                  FilesViewSlot* s);
static void files_view_miller_disconnect_slot_signals (FilesViewMiller* self,
                                                FilesViewSlot* slot);
static void ___lambda52__gfunc (gconstpointer data,
                         gpointer self);
static void __lambda64_ (FilesViewMiller* self,
                  GtkWidget* w);
static void ___lambda64__gtk_callback (GtkWidget* widget,
                                gpointer self);
static void files_view_miller_calculate_total_width (FilesViewMiller* self);
static void __lambda54_ (FilesViewMiller* self,
                  FilesViewSlot* slot);
static void ___lambda54__gfunc (gconstpointer data,
                         gpointer self);
static gboolean __lambda53_ (FilesViewMiller* self);
static gboolean ___lambda53__gsource_func (gpointer self);
static void files_view_miller_real_user_path_change_request (FilesAbstractSlot* base,
                                                      GFile* loc,
                                                      gboolean make_root);
static void files_view_miller_change_path (FilesViewMiller* self,
                                    GFile* loc,
                                    gboolean make_root);
static gboolean files_view_miller_add_relative_path (FilesViewMiller* self,
                                              FilesViewSlot* root,
                                              GFile* loc);
VALA_EXTERN void files_view_miller_set_root_location (FilesViewMiller* self,
                                          GFile* value);
static void files_view_miller_on_slot_selection_changed (FilesViewMiller* self,
                                                  GList* files);
static void _files_view_miller_on_slot_selection_changed_files_abstract_slot_selection_changed (FilesAbstractSlot* _sender,
                                                                                         GList* files,
                                                                                         gpointer self);
static void files_view_miller_on_slot_frozen_changed (FilesViewMiller* self,
                                               FilesViewSlot* slot,
                                               gboolean frozen);
static void _files_view_miller_on_slot_frozen_changed_files_view_slot_frozen_changed (FilesViewSlot* _sender,
                                                                               gboolean freeze,
                                                                               gpointer self);
static void files_view_miller_on_slot_active (FilesViewMiller* self,
                                       FilesAbstractSlot* aslot,
                                       gboolean scroll,
                                       gboolean animate);
static void _files_view_miller_on_slot_active_files_abstract_slot_active (FilesAbstractSlot* _sender,
                                                                   gboolean scroll,
                                                                   gboolean animate,
                                                                   gpointer self);
static void files_view_miller_on_miller_slot_request (FilesViewMiller* self,
                                               FilesViewSlot* slot,
                                               GFile* loc,
                                               gboolean make_root);
static void _files_view_miller_on_miller_slot_request_files_view_slot_miller_slot_request (FilesViewSlot* _sender,
                                                                                    GFile* file,
                                                                                    gboolean make_root,
                                                                                    gpointer self);
static void files_view_miller_on_new_container_request (FilesViewMiller* self,
                                                 GFile* loc,
                                                 FilesOpenFlag flag);
static void _files_view_miller_on_new_container_request_files_abstract_slot_new_container_request (FilesAbstractSlot* _sender,
                                                                                            GFile* loc,
                                                                                            FilesOpenFlag flag,
                                                                                            gpointer self);
static void _files_view_miller_update_total_width_files_view_slot_size_change (FilesViewSlot* _sender,
                                                                        gpointer self);
static void files_view_miller_on_slot_folder_deleted (FilesViewMiller* self,
                                               FilesViewSlot* slot,
                                               FilesFile* file,
                                               FilesDirectory* dir);
static void _files_view_miller_on_slot_folder_deleted_files_view_slot_folder_deleted (FilesViewSlot* _sender,
                                                                               FilesFile* file,
                                                                               FilesDirectory* parent,
                                                                               gpointer self);
static void files_view_miller_on_slot_path_changed (FilesViewMiller* self);
static void _files_view_miller_on_slot_path_changed_files_abstract_slot_path_changed (FilesAbstractSlot* _sender,
                                                                               gpointer self);
static void files_view_miller_on_slot_directory_loaded (FilesViewMiller* self,
                                                 FilesDirectory* dir);
static void _files_view_miller_on_slot_directory_loaded_files_abstract_slot_directory_loaded (FilesAbstractSlot* _sender,
                                                                                       FilesDirectory* dir,
                                                                                       gpointer self);
static void _files_view_miller_update_total_width_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
static void files_view_miller_schedule_scroll_to_slot (FilesViewMiller* self,
                                                FilesViewSlot* slot,
                                                gboolean animate);
static void ___lambda51_ (Block42Data* _data42_,
                   FilesViewSlot* s);
static void ____lambda51__gfunc (gconstpointer data,
                          gpointer self);
static void files_view_miller_show_hidden_files_changed (FilesViewMiller* self,
                                                  gboolean show_hidden);
static Block43Data* block43_data_ref (Block43Data* _data43_);
static void block43_data_unref (void * _userdata_);
static void ___lambda68_ (Block43Data* _data43_,
                   FilesViewSlot* s);
static void ____lambda68__gfunc (gconstpointer data,
                          gpointer self);
VALA_EXTERN gboolean files_view_miller_on_miller_key_pressed (FilesViewMiller* self,
                                                  guint keyval,
                                                  guint keycode,
                                                  GdkModifierType state);
VALA_EXTERN gboolean files_abstract_directory_view_get_renaming (FilesAbstractDirectoryView* self);
VALA_EXTERN gboolean files_view_view_container_go_up (FilesViewViewContainer* self);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static void __lambda45_ (Block44Data* _data44_,
                  FilesViewSlot* abstract_slot);
static void ___lambda45__gfunc (gconstpointer data,
                         gpointer self);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static gboolean __lambda48_ (Block45Data* _data45_);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static gboolean files_view_miller_get_animating (FilesViewMiller* self);
static void files_view_miller_cancel_animation (FilesViewMiller* self);
static void __lambda49_ (Block46Data* _data46_,
                  FilesViewSlot* abs);
static void ___lambda49__gfunc (gconstpointer data,
                         gpointer self);
static void files_view_miller_smooth_adjustment_to (FilesViewMiller* self,
                                             GtkAdjustment* adj,
                                             gint final);
static gboolean ___lambda48__gsource_func (gpointer self);
static FilesAbstractSlot* files_view_miller_real_get_current_slot (FilesAbstractSlot* base);
static GList* files_view_miller_real_get_selected_files (FilesAbstractSlot* base);
static void files_view_miller_real_set_active_state (FilesAbstractSlot* base,
                                              gboolean set_active,
                                              gboolean animate);
static gchar* files_view_miller_real_get_tip_uri (FilesAbstractSlot* base);
static gchar* files_view_miller_real_get_root_uri (FilesAbstractSlot* base);
VALA_EXTERN GFile* files_view_miller_get_root_location (FilesViewMiller* self);
static void files_view_miller_real_select_glib_files (FilesAbstractSlot* base,
                                               GList* files,
                                               GFile* focus_location);
static void files_view_miller_real_focus_first_for_empty_selection (FilesAbstractSlot* base,
                                                             gboolean select);
static void files_view_miller_real_zoom_in (FilesAbstractSlot* base);
static void files_view_miller_real_zoom_out (FilesAbstractSlot* base);
static void files_view_miller_real_zoom_normal (FilesAbstractSlot* base);
static void files_view_miller_real_grab_focus (FilesAbstractSlot* base);
static void files_view_miller_real_initialize_directory (FilesAbstractSlot* base);
static void files_view_miller_real_reload (FilesAbstractSlot* base,
                                    gboolean non_local_only);
static void files_view_miller_real_close (FilesAbstractSlot* base);
static gboolean files_view_miller_real_set_all_selected (FilesAbstractSlot* base,
                                                  gboolean all);
static GFileInfo* files_view_miller_real_lookup_file_info (FilesAbstractSlot* base,
                                                    GFile* loc);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static gboolean __lambda50_ (Block47Data* _data47_);
static gboolean ___lambda50__gsource_func (gpointer self);
static void files_view_miller_set_ctab (FilesViewMiller* self,
                                 FilesViewViewContainer* value);
static GObject * files_view_miller_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void _files_view_miller___lambda69_ (FilesViewMiller* self,
                                     GObject* s,
                                     GParamSpec* p);
static void __files_view_miller___lambda69__g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self);
static void files_view_miller_finalize (GObject * obj);
static GType files_view_miller_get_type_once (void);
static void _vala_files_view_miller_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_files_view_miller_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
files_view_miller_get_instance_private (FilesViewMiller* self)
{
	return G_STRUCT_MEMBER_P (self, FilesViewMiller_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

FilesViewMiller*
files_view_miller_construct (GType object_type,
                             GFile* loc,
                             FilesViewViewContainer* _ctab)
{
	FilesViewMiller * self = NULL;
	g_return_val_if_fail (loc != NULL, NULL);
	g_return_val_if_fail (_ctab != NULL, NULL);
	self = (FilesViewMiller*) g_object_new (object_type, "location", loc, "root-location", loc, "ctab", _ctab, NULL);
	return self;
}

FilesViewMiller*
files_view_miller_new (GFile* loc,
                       FilesViewViewContainer* _ctab)
{
	return files_view_miller_construct (FILES_VIEW_TYPE_MILLER, loc, _ctab);
}

/** Creates a new slot in the host slot hpane */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
files_view_miller_add_location (FilesViewMiller* self,
                                GFile* loc,
                                FilesViewSlot* host)
{
	FilesViewSlot* guest = NULL;
	FilesViewViewContainer* _tmp0_;
	FilesViewSlot* _tmp1_;
	gint _tmp2_ = 0;
	FilesViewSlot* _tmp5_;
	FilesViewSlot* _tmp6_;
	GtkBox* _tmp7_;
	FilesViewSlot* _tmp8_;
	GtkBox* _tmp9_;
	FilesViewSlot* _tmp10_;
	FilesViewSlot* _tmp11_;
	GtkPaned* _tmp12_ = NULL;
	FilesViewSlot* _tmp13_;
	GtkPaned* _tmp14_;
	FilesViewSlot* _tmp15_;
	FilesAbstractDirectoryView* _tmp16_;
	FilesViewSlot* _tmp17_;
	GtkPaned* _tmp18_;
	FilesViewSlot* _tmp19_;
	GtkBox* _tmp20_;
	FilesViewSlot* _tmp21_;
	GtkPaned* _tmp22_;
	FilesViewSlot* _tmp23_;
	FilesViewSlot* _tmp34_;
	FilesViewSlot* _tmp35_;
	FilesViewSlot* _tmp36_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (loc != NULL);
	_tmp0_ = self->priv->_ctab;
	_tmp1_ = files_view_slot_new (loc, _tmp0_, FILES_VIEW_MODE_MILLER_COLUMNS);
	guest = _tmp1_;
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "path-changed");
	if (host != NULL) {
		gint _tmp3_;
		gint _tmp4_;
		_tmp3_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) host);
		_tmp4_ = _tmp3_;
		_tmp2_ = _tmp4_ + 1;
	} else {
		_tmp2_ = 0;
	}
	_tmp5_ = guest;
	files_abstract_slot_set_slot_number ((FilesAbstractSlot*) _tmp5_, _tmp2_);
	_tmp6_ = guest;
	_tmp7_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (_tmp6_->colpane);
	_tmp6_->colpane = _tmp7_;
	_tmp8_ = guest;
	_tmp9_ = _tmp8_->colpane;
	_tmp10_ = guest;
	gtk_widget_set_size_request ((GtkWidget*) _tmp9_, ((FilesAbstractSlot*) _tmp10_)->width, -1);
	_tmp11_ = guest;
	_tmp12_ = (GtkPaned*) gtk_paned_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp12_, TRUE);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (_tmp11_->hpane);
	_tmp11_->hpane = _tmp12_;
	_tmp13_ = guest;
	_tmp14_ = _tmp13_->hpane;
	_tmp15_ = guest;
	_tmp16_ = files_view_slot_get_directory_view (_tmp15_);
	gtk_paned_pack1 (_tmp14_, (GtkWidget*) _tmp16_, FALSE, FALSE);
	_tmp17_ = guest;
	_tmp18_ = _tmp17_->hpane;
	_tmp19_ = guest;
	_tmp20_ = _tmp19_->colpane;
	gtk_paned_pack2 (_tmp18_, (GtkWidget*) _tmp20_, TRUE, TRUE);
	_tmp21_ = guest;
	_tmp22_ = _tmp21_->hpane;
	gtk_widget_show_all ((GtkWidget*) _tmp22_);
	_tmp23_ = guest;
	files_view_miller_connect_slot_signals (self, _tmp23_);
	if (host != NULL) {
		FilesViewSlot* _tmp24_;
		FilesFile* _tmp25_;
		FilesFile* _tmp26_;
		GtkBox* _tmp27_;
		FilesViewSlot* _tmp28_;
		GtkPaned* _tmp29_;
		FilesViewSlot* _tmp30_;
		files_view_miller_truncate_list_after_slot (self, host);
		_tmp24_ = guest;
		_tmp25_ = files_abstract_slot_get_file ((FilesAbstractSlot*) _tmp24_);
		_tmp26_ = _tmp25_;
		files_view_slot_select_gof_file (host, _tmp26_);
		_tmp27_ = host->colpane;
		_tmp28_ = guest;
		_tmp29_ = _tmp28_->hpane;
		gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp29_);
		_tmp30_ = guest;
		files_abstract_slot_initialize_directory ((FilesAbstractSlot*) _tmp30_);
	} else {
		GtkBox* _tmp31_;
		FilesViewSlot* _tmp32_;
		GtkPaned* _tmp33_;
		_tmp31_ = self->priv->colpane;
		_tmp32_ = guest;
		_tmp33_ = _tmp32_->hpane;
		gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp33_);
	}
	_tmp34_ = guest;
	_tmp35_ = _g_object_ref0 (_tmp34_);
	self->slot_list = g_list_append (self->slot_list, _tmp35_);
	_tmp36_ = guest;
	g_signal_emit_by_name ((FilesAbstractSlot*) _tmp36_, "active", TRUE, TRUE);
	files_view_miller_update_total_width (self);
	_g_object_unref0 (guest);
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data41_->self;
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
__lambda52_ (Block41Data* _data41_,
             FilesViewSlot* s)
{
	FilesViewMiller* self;
	gint _tmp0_;
	gint _tmp1_;
	self = _data41_->self;
	g_return_if_fail (s != NULL);
	_tmp0_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) s);
	_tmp1_ = _tmp0_;
	if (((guint) _tmp1_) > _data41_->n) {
		files_view_miller_disconnect_slot_signals (self, s);
		files_abstract_slot_close ((FilesAbstractSlot*) s);
	}
}

static void
___lambda52__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda52_ (self, (FilesViewSlot*) data);
}

static void
__lambda64_ (FilesViewMiller* self,
             GtkWidget* w)
{
	g_return_if_fail (w != NULL);
	gtk_widget_destroy (w);
}

static void
___lambda64__gtk_callback (GtkWidget* widget,
                           gpointer self)
{
	__lambda64_ ((FilesViewMiller*) self, widget);
}

static void
files_view_miller_truncate_list_after_slot (FilesViewMiller* self,
                                            FilesViewSlot* slot)
{
	Block41Data* _data41_;
	GList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GList* _tmp3_;
	GtkBox* _tmp4_;
	GList* _tmp5_;
	GList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = self->slot_list;
	if (g_list_length (_tmp0_) <= ((guint) 0)) {
		block41_data_unref (_data41_);
		_data41_ = NULL;
		return;
	}
	_tmp1_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) slot);
	_tmp2_ = _tmp1_;
	_data41_->n = (guint) _tmp2_;
	_tmp3_ = self->slot_list;
	g_list_foreach (_tmp3_, ___lambda52__gfunc, _data41_);
	_tmp4_ = G_TYPE_CHECK_INSTANCE_CAST (slot, FILES_VIEW_TYPE_SLOT, FilesViewSlot)->colpane;
	gtk_container_foreach ((GtkContainer*) _tmp4_, ___lambda64__gtk_callback, self);
	_tmp5_ = self->slot_list;
	_tmp6_ = g_list_nth (_tmp5_, _data41_->n);
	(_tmp6_->next == NULL) ? NULL : (_tmp6_->next = (_g_list_free__g_object_unref0_ (_tmp6_->next), NULL));
	_tmp6_->next = NULL;
	files_view_miller_calculate_total_width (self);
	self->current_slot = slot;
	g_signal_emit_by_name ((FilesAbstractSlot*) slot, "active", TRUE, TRUE);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}

static void
__lambda54_ (FilesViewMiller* self,
             FilesViewSlot* slot)
{
	g_return_if_fail (slot != NULL);
	self->total_width = self->total_width + ((FilesAbstractSlot*) slot)->width;
}

static void
___lambda54__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda54_ ((FilesViewMiller*) self, (FilesViewSlot*) data);
}

static void
files_view_miller_calculate_total_width (FilesViewMiller* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	self->total_width = 100;
	_tmp0_ = self->slot_list;
	g_list_foreach (_tmp0_, ___lambda54__gfunc, self);
}

static gboolean
__lambda53_ (FilesViewMiller* self)
{
	GtkBox* _tmp0_;
	gboolean result;
	self->priv->total_width_timeout_id = (guint) 0;
	files_view_miller_calculate_total_width (self);
	_tmp0_ = self->priv->colpane;
	gtk_widget_set_size_request ((GtkWidget*) _tmp0_, self->total_width, -1);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda53__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda53_ ((FilesViewMiller*) self);
	return result;
}

static void
files_view_miller_update_total_width (FilesViewMiller* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->total_width_timeout_id > ((guint) 0)) {
		return;
	}
	self->priv->total_width_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda53__gsource_func, g_object_ref (self), g_object_unref);
}

/*********************/
static void
files_view_miller_real_user_path_change_request (FilesAbstractSlot* base,
                                                 GFile* loc,
                                                 gboolean make_root)
{
	FilesViewMiller * self;
	self = (FilesViewMiller*) base;
	g_return_if_fail (loc != NULL);
	files_view_miller_change_path (self, loc, make_root);
}

static void
files_view_miller_change_path (FilesViewMiller* self,
                               GFile* loc,
                               gboolean make_root)
{
	FilesViewSlot* first_slot = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	FilesViewSlot* _tmp3_;
	gchar* root_uri = NULL;
	FilesViewSlot* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* target_uri = NULL;
	gchar* _tmp8_;
	gboolean found = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (loc != NULL);
	_tmp0_ = self->slot_list;
	_tmp1_ = g_list_first (_tmp0_);
	_tmp2_ = _tmp1_->data;
	_tmp3_ = _g_object_ref0 ((FilesViewSlot*) _tmp2_);
	first_slot = _tmp3_;
	_tmp4_ = first_slot;
	_tmp5_ = files_abstract_slot_get_uri ((FilesAbstractSlot*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	root_uri = _tmp7_;
	_tmp8_ = g_file_get_uri (loc);
	target_uri = _tmp8_;
	found = FALSE;
	if (!make_root) {
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp11_ = target_uri;
		_tmp12_ = root_uri;
		_tmp10_ = g_str_has_prefix (_tmp11_, _tmp12_);
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		const gchar* _tmp13_;
		const gchar* _tmp14_;
		_tmp13_ = target_uri;
		_tmp14_ = root_uri;
		_tmp9_ = g_strcmp0 (_tmp13_, _tmp14_) != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GList* copy_slot_list = NULL;
		GList* _tmp15_;
		GList* _tmp16_;
		GList* _tmp17_;
		_tmp15_ = self->slot_list;
		_tmp16_ = g_list_copy (_tmp15_);
		copy_slot_list = _tmp16_;
		copy_slot_list = g_list_reverse (copy_slot_list);
		_tmp17_ = copy_slot_list;
		{
			GList* s_collection = NULL;
			GList* s_it = NULL;
			s_collection = _tmp17_;
			for (s_it = s_collection; s_it != NULL; s_it = s_it->next) {
				FilesViewSlot* _tmp18_;
				FilesViewSlot* s = NULL;
				_tmp18_ = _g_object_ref0 ((FilesViewSlot*) s_it->data);
				s = _tmp18_;
				{
					FilesViewSlot* _tmp19_;
					_tmp19_ = s;
					if (files_view_miller_add_relative_path (self, _tmp19_, loc)) {
						found = TRUE;
						_g_object_unref0 (s);
						break;
					}
					_g_object_unref0 (s);
				}
			}
		}
		(copy_slot_list == NULL) ? NULL : (copy_slot_list = (g_list_free (copy_slot_list), NULL));
	}
	if (!found) {
		FilesViewSlot* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		FilesViewSlot* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gboolean _tmp26_;
		_tmp20_ = first_slot;
		files_view_miller_truncate_list_after_slot (self, _tmp20_);
		_tmp21_ = g_file_get_uri (loc);
		_tmp22_ = _tmp21_;
		_tmp23_ = first_slot;
		_tmp24_ = files_abstract_slot_get_uri ((FilesAbstractSlot*) _tmp23_);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strcmp0 (_tmp22_, _tmp25_) != 0;
		_g_free0 (_tmp22_);
		if (_tmp26_) {
			FilesViewSlot* _tmp27_;
			_tmp27_ = first_slot;
			files_abstract_slot_user_path_change_request ((FilesAbstractSlot*) _tmp27_, loc, TRUE);
			files_view_miller_set_root_location (self, loc);
			if (make_root) {
				FilesViewSlot* _tmp28_;
				_tmp28_ = first_slot;
				files_abstract_slot_focus_first_for_empty_selection ((FilesAbstractSlot*) _tmp28_, FALSE);
			}
		}
	}
	_g_free0 (target_uri);
	_g_free0 (root_uri);
	_g_object_unref0 (first_slot);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
files_view_miller_add_relative_path (FilesViewMiller* self,
                                     FilesViewSlot* root,
                                     GFile* loc)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gboolean _tmp6_;
	gchar* relative_path = NULL;
	GFile* _tmp7_;
	GFile* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gboolean _tmp13_ = FALSE;
	const gchar* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (root != NULL, FALSE);
	g_return_val_if_fail (loc != NULL, FALSE);
	_tmp0_ = files_abstract_slot_get_location ((FilesAbstractSlot*) root);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_file_get_uri (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_get_uri (loc);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strcmp0 (_tmp3_, _tmp5_) == 0;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	if (_tmp6_) {
		files_view_miller_truncate_list_after_slot (self, root);
		result = TRUE;
		return result;
	}
	_tmp7_ = files_abstract_slot_get_location ((FilesAbstractSlot*) root);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_file_get_relative_path (_tmp8_, loc);
	_tmp10_ = _tmp9_;
	_tmp11_ = files_file_utils_escape_uri (_tmp10_, FALSE, TRUE);
	_tmp12_ = _tmp11_;
	_g_free0 (_tmp10_);
	relative_path = _tmp12_;
	_tmp14_ = relative_path;
	if (_tmp14_ != NULL) {
		const gchar* _tmp15_;
		gint _tmp16_;
		gint _tmp17_;
		_tmp15_ = relative_path;
		_tmp16_ = strlen (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_ > 0;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gchar** dirs = NULL;
		const gchar* _tmp18_;
		gchar** _tmp19_;
		gchar** _tmp20_;
		gint dirs_length1;
		gint _dirs_size_;
		gchar* last_uri = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		const gchar* _tmp24_;
		gchar** _tmp27_;
		gint _tmp27__length1;
		files_view_miller_truncate_list_after_slot (self, root);
		_tmp18_ = relative_path;
		_tmp20_ = _tmp19_ = g_strsplit (_tmp18_, G_DIR_SEPARATOR_S, 0);
		dirs = _tmp20_;
		dirs_length1 = _vala_array_length (_tmp19_);
		_dirs_size_ = dirs_length1;
		_tmp21_ = files_abstract_slot_get_uri ((FilesAbstractSlot*) root);
		_tmp22_ = _tmp21_;
		_tmp23_ = g_strdup (_tmp22_);
		last_uri = _tmp23_;
		_tmp24_ = last_uri;
		if (g_str_has_suffix (_tmp24_, G_DIR_SEPARATOR_S)) {
			const gchar* _tmp25_;
			gchar* _tmp26_;
			_tmp25_ = last_uri;
			_tmp26_ = string_slice (_tmp25_, (glong) 0, (glong) -1);
			_g_free0 (last_uri);
			last_uri = _tmp26_;
		}
		_tmp27_ = dirs;
		_tmp27__length1 = dirs_length1;
		{
			gchar** d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
			d_collection = _tmp27_;
			d_collection_length1 = _tmp27__length1;
			for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
				const gchar* d = NULL;
				d = d_collection[d_it];
				{
					const gchar* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					_tmp28_ = d;
					_tmp29_ = strlen (_tmp28_);
					_tmp30_ = _tmp29_;
					if (_tmp30_ > 0) {
						const gchar* _tmp31_;
						const gchar* _tmp32_;
						gchar* _tmp33_;
						FilesViewSlot* last_slot = NULL;
						GList* _tmp34_;
						GList* _tmp35_;
						gconstpointer _tmp36_;
						FilesViewSlot* _tmp37_;
						GFile* file = NULL;
						const gchar* _tmp38_;
						GFile* _tmp39_;
						GList* list = NULL;
						GFile* _tmp40_;
						GFile* _tmp41_;
						FilesViewSlot* _tmp42_;
						GList* _tmp43_;
						GFile* _tmp44_;
						GFile* _tmp45_;
						FilesViewSlot* _tmp46_;
						_tmp31_ = last_uri;
						_tmp32_ = d;
						_tmp33_ = g_build_path (G_DIR_SEPARATOR_S, _tmp31_, _tmp32_, NULL);
						_g_free0 (last_uri);
						last_uri = _tmp33_;
						_tmp34_ = self->slot_list;
						_tmp35_ = g_list_last (_tmp34_);
						_tmp36_ = _tmp35_->data;
						_tmp37_ = _g_object_ref0 ((FilesViewSlot*) _tmp36_);
						last_slot = _tmp37_;
						_tmp38_ = last_uri;
						_tmp39_ = g_file_new_for_uri (_tmp38_);
						file = _tmp39_;
						list = NULL;
						_tmp40_ = file;
						_tmp41_ = _g_object_ref0 (_tmp40_);
						list = g_list_prepend (list, _tmp41_);
						_tmp42_ = last_slot;
						_tmp43_ = list;
						_tmp44_ = file;
						files_abstract_slot_select_glib_files ((FilesAbstractSlot*) _tmp42_, _tmp43_, _tmp44_);
						g_usleep ((gulong) 100000);
						_tmp45_ = file;
						_tmp46_ = last_slot;
						files_view_miller_add_location (self, _tmp45_, _tmp46_);
						(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
						_g_object_unref0 (file);
						_g_object_unref0 (last_slot);
					}
				}
			}
		}
		_g_free0 (last_uri);
		dirs = (_vala_array_free (dirs, dirs_length1, (GDestroyNotify) g_free), NULL);
	} else {
		result = FALSE;
		_g_free0 (relative_path);
		return result;
	}
	result = TRUE;
	_g_free0 (relative_path);
	return result;
}

static void
_files_view_miller_on_slot_selection_changed_files_abstract_slot_selection_changed (FilesAbstractSlot* _sender,
                                                                                    GList* files,
                                                                                    gpointer self)
{
	files_view_miller_on_slot_selection_changed ((FilesViewMiller*) self, files);
}

static void
_files_view_miller_on_slot_frozen_changed_files_view_slot_frozen_changed (FilesViewSlot* _sender,
                                                                          gboolean freeze,
                                                                          gpointer self)
{
	files_view_miller_on_slot_frozen_changed ((FilesViewMiller*) self, _sender, freeze);
}

static void
_files_view_miller_on_slot_active_files_abstract_slot_active (FilesAbstractSlot* _sender,
                                                              gboolean scroll,
                                                              gboolean animate,
                                                              gpointer self)
{
	files_view_miller_on_slot_active ((FilesViewMiller*) self, _sender, scroll, animate);
}

static void
_files_view_miller_on_miller_slot_request_files_view_slot_miller_slot_request (FilesViewSlot* _sender,
                                                                               GFile* file,
                                                                               gboolean make_root,
                                                                               gpointer self)
{
	files_view_miller_on_miller_slot_request ((FilesViewMiller*) self, _sender, file, make_root);
}

static void
_files_view_miller_on_new_container_request_files_abstract_slot_new_container_request (FilesAbstractSlot* _sender,
                                                                                       GFile* loc,
                                                                                       FilesOpenFlag flag,
                                                                                       gpointer self)
{
	files_view_miller_on_new_container_request ((FilesViewMiller*) self, loc, flag);
}

static void
_files_view_miller_update_total_width_files_view_slot_size_change (FilesViewSlot* _sender,
                                                                   gpointer self)
{
	files_view_miller_update_total_width ((FilesViewMiller*) self);
}

static void
_files_view_miller_on_slot_folder_deleted_files_view_slot_folder_deleted (FilesViewSlot* _sender,
                                                                          FilesFile* file,
                                                                          FilesDirectory* parent,
                                                                          gpointer self)
{
	files_view_miller_on_slot_folder_deleted ((FilesViewMiller*) self, _sender, file, parent);
}

static void
_files_view_miller_on_slot_path_changed_files_abstract_slot_path_changed (FilesAbstractSlot* _sender,
                                                                          gpointer self)
{
	files_view_miller_on_slot_path_changed ((FilesViewMiller*) self);
}

static void
_files_view_miller_on_slot_directory_loaded_files_abstract_slot_directory_loaded (FilesAbstractSlot* _sender,
                                                                                  FilesDirectory* dir,
                                                                                  gpointer self)
{
	files_view_miller_on_slot_directory_loaded ((FilesViewMiller*) self, dir);
}

static void
_files_view_miller_update_total_width_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	files_view_miller_update_total_width ((FilesViewMiller*) self);
}

static void
files_view_miller_connect_slot_signals (FilesViewMiller* self,
                                        FilesViewSlot* slot)
{
	GtkPaned* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	g_signal_connect_object ((FilesAbstractSlot*) slot, "selection-changed", (GCallback) _files_view_miller_on_slot_selection_changed_files_abstract_slot_selection_changed, self, 0);
	g_signal_connect_object (slot, "frozen-changed", (GCallback) _files_view_miller_on_slot_frozen_changed_files_view_slot_frozen_changed, self, 0);
	g_signal_connect_object ((FilesAbstractSlot*) slot, "active", (GCallback) _files_view_miller_on_slot_active_files_abstract_slot_active, self, 0);
	g_signal_connect_object (slot, "miller-slot-request", (GCallback) _files_view_miller_on_miller_slot_request_files_view_slot_miller_slot_request, self, 0);
	g_signal_connect_object ((FilesAbstractSlot*) slot, "new-container-request", (GCallback) _files_view_miller_on_new_container_request_files_abstract_slot_new_container_request, self, 0);
	g_signal_connect_object (slot, "size-change", (GCallback) _files_view_miller_update_total_width_files_view_slot_size_change, self, 0);
	g_signal_connect_object (slot, "folder-deleted", (GCallback) _files_view_miller_on_slot_folder_deleted_files_view_slot_folder_deleted, self, 0);
	g_signal_connect_object ((FilesAbstractSlot*) slot, "path-changed", (GCallback) _files_view_miller_on_slot_path_changed_files_abstract_slot_path_changed, self, 0);
	g_signal_connect_object ((FilesAbstractSlot*) slot, "directory-loaded", (GCallback) _files_view_miller_on_slot_directory_loaded_files_abstract_slot_directory_loaded, self, 0);
	_tmp0_ = slot->hpane;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::position", (GCallback) _files_view_miller_update_total_width_g_object_notify, self, 0);
}

static void
files_view_miller_disconnect_slot_signals (FilesViewMiller* self,
                                           FilesViewSlot* slot)
{
	guint _tmp0_;
	guint _tmp1_;
	guint _tmp2_;
	guint _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	guint _tmp6_;
	guint _tmp7_;
	guint _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	g_signal_parse_name ("selection-changed", FILES_TYPE_ABSTRACT_SLOT, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FilesAbstractSlot*) slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _files_view_miller_on_slot_selection_changed_files_abstract_slot_selection_changed, self);
	g_signal_parse_name ("frozen-changed", FILES_VIEW_TYPE_SLOT, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_view_miller_on_slot_frozen_changed_files_view_slot_frozen_changed, self);
	g_signal_parse_name ("active", FILES_TYPE_ABSTRACT_SLOT, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FilesAbstractSlot*) slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _files_view_miller_on_slot_active_files_abstract_slot_active, self);
	g_signal_parse_name ("miller-slot-request", FILES_VIEW_TYPE_SLOT, &_tmp3_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_view_miller_on_miller_slot_request_files_view_slot_miller_slot_request, self);
	g_signal_parse_name ("new-container-request", FILES_TYPE_ABSTRACT_SLOT, &_tmp4_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FilesAbstractSlot*) slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _files_view_miller_on_new_container_request_files_abstract_slot_new_container_request, self);
	g_signal_parse_name ("size-change", FILES_VIEW_TYPE_SLOT, &_tmp5_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _files_view_miller_update_total_width_files_view_slot_size_change, self);
	g_signal_parse_name ("folder-deleted", FILES_VIEW_TYPE_SLOT, &_tmp6_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _files_view_miller_on_slot_folder_deleted_files_view_slot_folder_deleted, self);
	g_signal_parse_name ("path-changed", FILES_TYPE_ABSTRACT_SLOT, &_tmp7_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FilesAbstractSlot*) slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _files_view_miller_on_slot_path_changed_files_abstract_slot_path_changed, self);
	g_signal_parse_name ("directory-loaded", FILES_TYPE_ABSTRACT_SLOT, &_tmp8_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((FilesAbstractSlot*) slot, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _files_view_miller_on_slot_directory_loaded_files_abstract_slot_directory_loaded, self);
}

static void
files_view_miller_on_miller_slot_request (FilesViewMiller* self,
                                          FilesViewSlot* slot,
                                          GFile* loc,
                                          gboolean make_root)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	g_return_if_fail (loc != NULL);
	if (make_root) {
		files_view_miller_change_path (self, loc, TRUE);
	} else {
		files_view_miller_add_location (self, loc, slot);
	}
}

static void
files_view_miller_on_new_container_request (FilesViewMiller* self,
                                            GFile* loc,
                                            FilesOpenFlag flag)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (loc != NULL);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "new-container-request", loc, flag);
}

static void
files_view_miller_on_slot_path_changed (FilesViewMiller* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "path-changed");
}

static void
files_view_miller_on_slot_directory_loaded (FilesViewMiller* self,
                                            FilesDirectory* dir)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (dir != NULL);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "directory-loaded", dir);
}

static void
files_view_miller_on_slot_folder_deleted (FilesViewMiller* self,
                                          FilesViewSlot* slot,
                                          FilesFile* file,
                                          FilesDirectory* dir)
{
	FilesViewSlot* next_slot = NULL;
	GList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gconstpointer _tmp3_;
	FilesViewSlot* _tmp4_;
	gboolean _tmp5_ = FALSE;
	FilesViewSlot* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = self->slot_list;
	_tmp1_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) slot);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_nth_data (_tmp0_, (guint) (_tmp2_ + 1));
	_tmp4_ = _g_object_ref0 ((FilesViewSlot*) _tmp3_);
	next_slot = _tmp4_;
	_tmp6_ = next_slot;
	if (_tmp6_ != NULL) {
		FilesViewSlot* _tmp7_;
		FilesDirectory* _tmp8_;
		FilesDirectory* _tmp9_;
		_tmp7_ = next_slot;
		_tmp8_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp5_ = _tmp9_ == dir;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		files_view_miller_truncate_list_after_slot (self, slot);
	}
	_g_object_unref0 (next_slot);
}

/** Called in response to slot active signal.
         *  Should not be called directly
         **/
static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data42_->self;
		_g_object_unref0 (_data42_->slot);
		_g_object_unref0 (self);
		g_slice_free (Block42Data, _data42_);
	}
}

static void
___lambda51_ (Block42Data* _data42_,
              FilesViewSlot* s)
{
	FilesViewMiller* self;
	FilesViewSlot* _tmp0_;
	self = _data42_->self;
	g_return_if_fail (s != NULL);
	_tmp0_ = _data42_->slot;
	if (s != _tmp0_) {
		g_signal_emit_by_name ((FilesAbstractSlot*) s, "inactive");
	}
}

static void
____lambda51__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda51_ (self, (FilesViewSlot*) data);
}

static void
files_view_miller_on_slot_active (FilesViewMiller* self,
                                  FilesAbstractSlot* aslot,
                                  gboolean scroll,
                                  gboolean animate)
{
	Block42Data* _data42_;
	FilesViewSlot* _tmp2_;
	FilesViewSlot* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (aslot != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->self = g_object_ref (self);
	if (!FILES_VIEW_IS_SLOT (aslot)) {
		block42_data_unref (_data42_);
		_data42_ = NULL;
		return;
	} else {
		FilesViewSlot* _tmp0_;
		_tmp0_ = _g_object_ref0 (FILES_VIEW_IS_SLOT (aslot) ? ((FilesViewSlot*) aslot) : NULL);
		_g_object_unref0 (_data42_->slot);
		_data42_->slot = _tmp0_;
	}
	if (scroll) {
		FilesViewSlot* _tmp1_;
		_tmp1_ = _data42_->slot;
		files_view_miller_schedule_scroll_to_slot (self, _tmp1_, animate);
	}
	_tmp2_ = self->current_slot;
	_tmp3_ = _data42_->slot;
	if (_tmp2_ != _tmp3_) {
		GList* _tmp4_;
		FilesViewSlot* _tmp5_;
		_tmp4_ = self->slot_list;
		g_list_foreach (_tmp4_, ____lambda51__gfunc, _data42_);
		_tmp5_ = _data42_->slot;
		self->current_slot = _tmp5_;
	}
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "active", TRUE, TRUE);
	block42_data_unref (_data42_);
	_data42_ = NULL;
}

static Block43Data*
block43_data_ref (Block43Data* _data43_)
{
	g_atomic_int_inc (&_data43_->_ref_count_);
	return _data43_;
}

static void
block43_data_unref (void * _userdata_)
{
	Block43Data* _data43_;
	_data43_ = (Block43Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data43_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data43_->self;
		_g_object_unref0 (self);
		g_slice_free (Block43Data, _data43_);
	}
}

static void
___lambda68_ (Block43Data* _data43_,
              FilesViewSlot* s)
{
	FilesViewMiller* self;
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	FilesDirectory* _tmp2_;
	FilesDirectory* _tmp3_;
	FilesFile* _tmp4_;
	FilesFile* _tmp5_;
	gboolean _tmp6_;
	gboolean _tmp7_;
	self = _data43_->self;
	g_return_if_fail (s != NULL);
	_tmp0_ = _data43_->i;
	_data43_->i = _tmp0_ + 1;
	_tmp2_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) s);
	_tmp3_ = _tmp2_;
	_tmp4_ = files_directory_get_file (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = files_file_get_is_hidden (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		_tmp1_ = _data43_->hidden <= 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_data43_->hidden = _data43_->i;
	}
}

static void
____lambda68__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda68_ (self, (FilesViewSlot*) data);
}

static void
files_view_miller_show_hidden_files_changed (FilesViewMiller* self,
                                             gboolean show_hidden)
{
	g_return_if_fail (self != NULL);
	if (!show_hidden) {
		Block43Data* _data43_;
		GList* _tmp0_;
		FilesViewSlot* slot = NULL;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		FilesViewSlot* _tmp3_;
		FilesViewSlot* _tmp4_;
		FilesViewSlot* _tmp5_;
		_data43_ = g_slice_new0 (Block43Data);
		_data43_->_ref_count_ = 1;
		_data43_->self = g_object_ref (self);
		_data43_->i = -1;
		_data43_->hidden = -1;
		_tmp0_ = self->slot_list;
		g_list_foreach (_tmp0_, ____lambda68__gfunc, _data43_);
		if (_data43_->hidden <= 0) {
			block43_data_unref (_data43_);
			_data43_ = NULL;
			return;
		}
		_tmp1_ = self->slot_list;
		_tmp2_ = g_list_nth_data (_tmp1_, (guint) (_data43_->hidden - 1));
		_tmp3_ = _g_object_ref0 ((FilesViewSlot*) _tmp2_);
		slot = _tmp3_;
		_tmp4_ = slot;
		files_view_miller_truncate_list_after_slot (self, _tmp4_);
		_tmp5_ = slot;
		g_signal_emit_by_name ((FilesAbstractSlot*) _tmp5_, "active", TRUE, TRUE);
		_g_object_unref0 (slot);
		block43_data_unref (_data43_);
		_data43_ = NULL;
	}
}

gboolean
files_view_miller_on_miller_key_pressed (FilesViewMiller* self,
                                         guint keyval,
                                         guint keycode,
                                         GdkModifierType state)
{
	gint current_position = 0;
	GList* _tmp0_;
	FilesViewSlot* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	FilesAbstractDirectoryView* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	FilesViewSlot* to_activate = NULL;
	FilesViewSlot* _tmp40_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((state & gtk_accelerator_get_default_mod_mask ()) > 0) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->slot_list;
	_tmp1_ = self->current_slot;
	current_position = g_list_index (_tmp0_, _tmp1_);
	_tmp2_ = self->slot_list;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) current_position);
	_tmp4_ = files_view_slot_get_directory_view ((FilesViewSlot*) _tmp3_);
	_tmp5_ = files_abstract_directory_view_get_renaming (_tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		result = FALSE;
		return result;
	}
	to_activate = NULL;
	switch (keyval) {
		case GDK_KEY_Left:
		{
			if (current_position > 0) {
				GList* _tmp7_;
				gconstpointer _tmp8_;
				FilesViewSlot* _tmp9_;
				_tmp7_ = self->slot_list;
				_tmp8_ = g_list_nth_data (_tmp7_, (guint) (current_position - 1));
				_tmp9_ = _g_object_ref0 ((FilesViewSlot*) _tmp8_);
				_g_object_unref0 (to_activate);
				to_activate = _tmp9_;
			}
			break;
		}
		case GDK_KEY_Right:
		{
			FilesViewSlot* _tmp10_;
			GList* _tmp11_;
			FilesFile* selected_file = NULL;
			FilesViewSlot* _tmp12_;
			GList* _tmp13_;
			gconstpointer _tmp14_;
			FilesFile* _tmp15_;
			FilesFile* _tmp16_;
			GFile* current_location = NULL;
			FilesFile* _tmp17_;
			GFile* _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			GFile* next_location = NULL;
			GList* _tmp21_;
			gboolean _tmp27_ = FALSE;
			GFile* _tmp28_;
			_tmp10_ = self->current_slot;
			_tmp11_ = files_abstract_slot_get_selected_files ((FilesAbstractSlot*) _tmp10_);
			if (_tmp11_ == NULL) {
				result = TRUE;
				_g_object_unref0 (to_activate);
				return result;
			}
			_tmp12_ = self->current_slot;
			_tmp13_ = files_abstract_slot_get_selected_files ((FilesAbstractSlot*) _tmp12_);
			_tmp14_ = _tmp13_->data;
			_tmp15_ = _g_object_ref0 ((FilesFile*) _tmp14_);
			selected_file = _tmp15_;
			_tmp16_ = selected_file;
			if (_tmp16_ == NULL) {
				result = TRUE;
				_g_object_unref0 (selected_file);
				_g_object_unref0 (to_activate);
				return result;
			}
			_tmp17_ = selected_file;
			_tmp18_ = files_file_get_location (_tmp17_);
			_tmp19_ = _tmp18_;
			_tmp20_ = _g_object_ref0 (_tmp19_);
			current_location = _tmp20_;
			next_location = NULL;
			_tmp21_ = self->slot_list;
			if (((guint) current_position) < (g_list_length (_tmp21_) - 1)) {
				GList* _tmp22_;
				gconstpointer _tmp23_;
				GFile* _tmp24_;
				GFile* _tmp25_;
				GFile* _tmp26_;
				_tmp22_ = self->slot_list;
				_tmp23_ = g_list_nth_data (_tmp22_, (guint) (current_position + 1));
				_tmp24_ = files_abstract_slot_get_location ((FilesAbstractSlot*) ((FilesViewSlot*) _tmp23_));
				_tmp25_ = _tmp24_;
				_tmp26_ = _g_object_ref0 (_tmp25_);
				_g_object_unref0 (next_location);
				next_location = _tmp26_;
			}
			_tmp28_ = next_location;
			if (_tmp28_ != NULL) {
				GFile* _tmp29_;
				GFile* _tmp30_;
				_tmp29_ = next_location;
				_tmp30_ = current_location;
				_tmp27_ = g_file_equal (_tmp29_, _tmp30_);
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				GList* _tmp31_;
				gconstpointer _tmp32_;
				FilesViewSlot* _tmp33_;
				_tmp31_ = self->slot_list;
				_tmp32_ = g_list_nth_data (_tmp31_, (guint) (current_position + 1));
				_tmp33_ = _g_object_ref0 ((FilesViewSlot*) _tmp32_);
				_g_object_unref0 (to_activate);
				to_activate = _tmp33_;
			} else {
				FilesFile* _tmp34_;
				_tmp34_ = selected_file;
				if (files_file_is_folder (_tmp34_)) {
					GFile* _tmp35_;
					FilesViewSlot* _tmp36_;
					_tmp35_ = current_location;
					_tmp36_ = self->current_slot;
					files_view_miller_add_location (self, _tmp35_, _tmp36_);
					result = TRUE;
					_g_object_unref0 (next_location);
					_g_object_unref0 (current_location);
					_g_object_unref0 (selected_file);
					_g_object_unref0 (to_activate);
					return result;
				}
			}
			_g_object_unref0 (next_location);
			_g_object_unref0 (current_location);
			_g_object_unref0 (selected_file);
			break;
		}
		case GDK_KEY_BackSpace:
		{
			if (current_position > 0) {
				GList* _tmp37_;
				gconstpointer _tmp38_;
				_tmp37_ = self->slot_list;
				_tmp38_ = g_list_nth_data (_tmp37_, (guint) (current_position - 1));
				files_view_miller_truncate_list_after_slot (self, (FilesViewSlot*) _tmp38_);
			} else {
				FilesViewViewContainer* _tmp39_;
				_tmp39_ = self->priv->_ctab;
				files_view_view_container_go_up (_tmp39_);
				result = TRUE;
				_g_object_unref0 (to_activate);
				return result;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp40_ = to_activate;
	if (_tmp40_ != NULL) {
		FilesViewSlot* _tmp41_;
		FilesViewSlot* _tmp42_;
		_tmp41_ = to_activate;
		g_signal_emit_by_name ((FilesAbstractSlot*) _tmp41_, "active", TRUE, TRUE);
		_tmp42_ = to_activate;
		files_abstract_slot_focus_first_for_empty_selection ((FilesAbstractSlot*) _tmp42_, TRUE);
	}
	result = FALSE;
	_g_object_unref0 (to_activate);
	return result;
}

static void
files_view_miller_on_slot_selection_changed (FilesViewMiller* self,
                                             GList* files)
{
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name ((FilesAbstractSlot*) self, "selection-changed", files);
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data44_->self;
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static void
__lambda45_ (Block44Data* _data44_,
             FilesViewSlot* abstract_slot)
{
	FilesViewMiller* self;
	FilesViewSlot* s = NULL;
	FilesViewSlot* _tmp0_;
	FilesViewSlot* _tmp1_;
	self = _data44_->self;
	g_return_if_fail (abstract_slot != NULL);
	_tmp0_ = _g_object_ref0 (FILES_VIEW_IS_SLOT (abstract_slot) ? ((FilesViewSlot*) abstract_slot) : NULL);
	s = _tmp0_;
	_tmp1_ = s;
	if (_tmp1_ != NULL) {
		FilesViewSlot* _tmp2_;
		guint _tmp3_;
		FilesViewSlot* _tmp4_;
		FilesViewSlot* _tmp5_;
		_tmp2_ = s;
		g_signal_parse_name ("frozen-changed", FILES_VIEW_TYPE_SLOT, &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_view_miller_on_slot_frozen_changed_files_view_slot_frozen_changed, self);
		_tmp4_ = s;
		files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) _tmp4_, _data44_->frozen);
		_tmp5_ = s;
		g_signal_connect_object (_tmp5_, "frozen-changed", (GCallback) _files_view_miller_on_slot_frozen_changed_files_view_slot_frozen_changed, self, 0);
	}
	_g_object_unref0 (s);
}

static void
___lambda45__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda45_ (self, (FilesViewSlot*) data);
}

static void
files_view_miller_on_slot_frozen_changed (FilesViewMiller* self,
                                          FilesViewSlot* slot,
                                          gboolean frozen)
{
	Block44Data* _data44_;
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_data44_->frozen = frozen;
	_tmp0_ = self->slot_list;
	g_list_foreach (_tmp0_, ___lambda45__gfunc, _data44_);
	block44_data_unref (_data44_);
	_data44_ = NULL;
}

/** Helper functions */
static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data45_->self;
		_g_object_unref0 (_data45_->slot);
		_g_object_unref0 (self);
		g_slice_free (Block45Data, _data45_);
	}
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data46_->_data45_->self;
		block45_data_unref (_data46_->_data45_);
		_data46_->_data45_ = NULL;
		g_slice_free (Block46Data, _data46_);
	}
}

static void
__lambda49_ (Block46Data* _data46_,
             FilesViewSlot* abs)
{
	Block45Data* _data45_;
	FilesViewMiller* self;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_data45_ = _data46_->_data45_;
	self = _data45_->self;
	g_return_if_fail (abs != NULL);
	_tmp0_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) abs);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_abstract_slot_get_slot_number ((FilesAbstractSlot*) _data45_->slot);
	_tmp3_ = _tmp2_;
	if (_tmp1_ < _tmp3_) {
		_data46_->total_width_before += ((FilesAbstractSlot*) abs)->width;
	}
}

static void
___lambda49__gfunc (gconstpointer data,
                    gpointer self)
{
	__lambda49_ (self, (FilesViewSlot*) data);
}

static gboolean
__lambda48_ (Block45Data* _data45_)
{
	FilesViewMiller* self;
	Block46Data* _data46_;
	gboolean _tmp0_ = FALSE;
	GtkScrolledWindow* _tmp1_;
	GList* _tmp6_;
	gint hadj_value = 0;
	GtkAdjustment* _tmp7_;
	gint offset = 0;
	GtkViewport* _tmp8_;
	GdkWindow* _tmp9_;
	gboolean result;
	self = _data45_->self;
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->_data45_ = block45_data_ref (_data45_);
	_tmp1_ = self->priv->scrolled_window;
	if (!gtk_widget_get_realized ((GtkWidget*) _tmp1_)) {
		_tmp0_ = TRUE;
	} else {
		FilesDirectory* _tmp2_;
		FilesDirectory* _tmp3_;
		FilesDirectoryState _tmp4_;
		FilesDirectoryState _tmp5_;
		_tmp2_ = files_abstract_slot_get_directory ((FilesAbstractSlot*) _data45_->slot);
		_tmp3_ = _tmp2_;
		_tmp4_ = files_directory_get_state (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp0_ = _tmp5_ != FILES_DIRECTORY_STATE_LOADED;
	}
	if (_tmp0_) {
		result = G_SOURCE_CONTINUE;
		block46_data_unref (_data46_);
		_data46_ = NULL;
		return result;
	}
	if (files_view_miller_get_animating (self)) {
		files_view_miller_cancel_animation (self);
	}
	_data46_->total_width_before = 0;
	_tmp6_ = self->slot_list;
	g_list_foreach (_tmp6_, ___lambda49__gfunc, _data46_);
	_tmp7_ = self->hadj;
	hadj_value = (gint) gtk_adjustment_get_value (_tmp7_);
	offset = _data46_->total_width_before - hadj_value;
	if (offset < 0) {
		hadj_value += offset;
	}
	_tmp8_ = self->priv->viewport;
	_tmp9_ = gtk_viewport_get_view_window (_tmp8_);
	offset = ((_data46_->total_width_before + ((FilesAbstractSlot*) _data45_->slot)->width) - hadj_value) - gdk_window_get_width (_tmp9_);
	if (offset > 0) {
		hadj_value += offset;
	}
	if (_data45_->animate) {
		GtkAdjustment* _tmp10_;
		_tmp10_ = self->hadj;
		files_view_miller_smooth_adjustment_to (self, _tmp10_, hadj_value);
	} else {
		GtkAdjustment* _tmp11_;
		_tmp11_ = self->hadj;
		gtk_adjustment_set_value (_tmp11_, (gdouble) hadj_value);
	}
	self->priv->scroll_to_slot_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	block46_data_unref (_data46_);
	_data46_ = NULL;
	return result;
}

static gboolean
___lambda48__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda48_ (self);
	return result;
}

static void
files_view_miller_schedule_scroll_to_slot (FilesViewMiller* self,
                                           FilesViewSlot* slot,
                                           gboolean animate)
{
	Block45Data* _data45_;
	FilesViewSlot* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (slot != NULL);
	_data45_ = g_slice_new0 (Block45Data);
	_data45_->_ref_count_ = 1;
	_data45_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (slot);
	_g_object_unref0 (_data45_->slot);
	_data45_->slot = _tmp0_;
	_data45_->animate = animate;
	if (self->priv->scroll_to_slot_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->scroll_to_slot_timeout_id);
	}
	self->priv->scroll_to_slot_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, ___lambda48__gsource_func, block45_data_ref (_data45_), block45_data_unref);
	block45_data_unref (_data45_);
	_data45_ = NULL;
}

static FilesAbstractSlot*
files_view_miller_real_get_current_slot (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	FilesAbstractSlot* result;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	result = (FilesAbstractSlot*) _tmp0_;
	return result;
}

static GList*
files_view_miller_real_get_selected_files (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	GList* _tmp1_;
	GList* result;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	_tmp1_ = files_abstract_slot_get_selected_files ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot));
	result = _tmp1_;
	return result;
}

static void
files_view_miller_real_set_active_state (FilesAbstractSlot* base,
                                         gboolean set_active,
                                         gboolean animate)
{
	FilesViewMiller * self;
	self = (FilesViewMiller*) base;
	if (set_active) {
		FilesViewSlot* _tmp0_;
		_tmp0_ = self->current_slot;
		g_signal_emit_by_name ((FilesAbstractSlot*) _tmp0_, "active", TRUE, animate);
	} else {
		FilesViewSlot* _tmp1_;
		_tmp1_ = self->current_slot;
		g_signal_emit_by_name ((FilesAbstractSlot*) _tmp1_, "inactive");
	}
}

static gchar*
files_view_miller_real_get_tip_uri (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GList* _tmp2_;
	gchar* result;
	self = (FilesViewMiller*) base;
	_tmp2_ = self->slot_list;
	if (_tmp2_ != NULL) {
		GList* _tmp3_;
		GList* _tmp4_;
		_tmp3_ = self->slot_list;
		_tmp4_ = g_list_last (_tmp3_);
		_tmp1_ = _tmp4_ != NULL;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GList* _tmp5_;
		GList* _tmp6_;
		gconstpointer _tmp7_;
		_tmp5_ = self->slot_list;
		_tmp6_ = g_list_last (_tmp5_);
		_tmp7_ = _tmp6_->data;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_TYPE ((FilesViewSlot*) _tmp7_, FILES_TYPE_ABSTRACT_SLOT);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GList* _tmp8_;
		GList* _tmp9_;
		gconstpointer _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp8_ = self->slot_list;
		_tmp9_ = g_list_last (_tmp8_);
		_tmp10_ = _tmp9_->data;
		_tmp11_ = files_abstract_slot_get_uri ((FilesAbstractSlot*) ((FilesViewSlot*) _tmp10_));
		_tmp12_ = _tmp11_;
		_tmp13_ = g_strdup (_tmp12_);
		result = _tmp13_;
		return result;
	} else {
		result = NULL;
		return result;
	}
}

static gchar*
files_view_miller_real_get_root_uri (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->priv->_root_location;
	_tmp1_ = g_file_get_uri (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
files_view_miller_real_select_glib_files (FilesAbstractSlot* base,
                                          GList* files,
                                          GFile* focus_location)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_select_glib_files ((FilesAbstractSlot*) _tmp0_, files, focus_location);
}

static void
files_view_miller_real_focus_first_for_empty_selection (FilesAbstractSlot* base,
                                                        gboolean select)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_focus_first_for_empty_selection ((FilesAbstractSlot*) _tmp0_, select);
}

static void
files_view_miller_real_zoom_in (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_zoom_in ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot));
}

static void
files_view_miller_real_zoom_out (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_zoom_out ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot));
}

static void
files_view_miller_real_zoom_normal (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_zoom_normal ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot));
}

static void
files_view_miller_real_grab_focus (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_grab_focus ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot));
}

static void
files_view_miller_real_initialize_directory (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_initialize_directory ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot));
}

static void
files_view_miller_real_reload (FilesAbstractSlot* base,
                               gboolean non_local_only)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	files_abstract_slot_reload ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot), non_local_only);
}

static void
files_view_miller_real_close (FilesAbstractSlot* base)
{
	FilesViewMiller * self;
	GList* _tmp0_;
	GList* _tmp1_;
	gconstpointer _tmp2_;
	self = (FilesViewMiller*) base;
	self->current_slot = NULL;
	if (self->priv->scroll_to_slot_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->scroll_to_slot_timeout_id);
	}
	if (self->priv->total_width_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->total_width_timeout_id);
	}
	_tmp0_ = self->slot_list;
	_tmp1_ = g_list_first (_tmp0_);
	_tmp2_ = _tmp1_->data;
	files_view_miller_truncate_list_after_slot (self, (FilesViewSlot*) _tmp2_);
}

static gboolean
files_view_miller_real_set_all_selected (FilesAbstractSlot* base,
                                         gboolean all)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	gboolean result;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	result = files_abstract_slot_set_all_selected ((FilesAbstractSlot*) G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, FILES_VIEW_TYPE_SLOT, FilesViewSlot), all);
	return result;
}

static GFileInfo*
files_view_miller_real_lookup_file_info (FilesAbstractSlot* base,
                                         GFile* loc)
{
	FilesViewMiller * self;
	FilesViewSlot* _tmp0_;
	GFileInfo* _tmp1_;
	GFileInfo* result;
	self = (FilesViewMiller*) base;
	g_return_val_if_fail (loc != NULL, NULL);
	_tmp0_ = self->current_slot;
	_tmp1_ = files_abstract_slot_lookup_file_info ((FilesAbstractSlot*) _tmp0_, loc);
	result = _tmp1_;
	return result;
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		FilesViewMiller* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->adj);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}

static gboolean
__lambda50_ (Block47Data* _data47_)
{
	FilesViewMiller* self;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gboolean result;
	self = _data47_->self;
	_tmp0_ = gtk_adjustment_get_value (_data47_->adj);
	_tmp1_ = _tmp0_;
	if (_data47_->old_adj_value != _tmp1_) {
		self->priv->animation_timeout_source_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	if (((gdouble) _data47_->newvalue) >= (_data47_->to_do - 10)) {
		gtk_adjustment_set_value (_data47_->adj, (gdouble) _data47_->final);
		self->priv->animation_timeout_source_id = (guint) 0;
		result = G_SOURCE_REMOVE;
		return result;
	}
	_data47_->newvalue += 10;
	gtk_adjustment_set_value (_data47_->adj, _data47_->initial + ((_data47_->factor * sin (((((gdouble) _data47_->newvalue) / ((gdouble) _data47_->to_do)) * G_PI) / 2)) * _data47_->to_do));
	_tmp2_ = gtk_adjustment_get_value (_data47_->adj);
	_tmp3_ = _tmp2_;
	_data47_->old_adj_value = _tmp3_;
	result = G_SOURCE_CONTINUE;
	return result;
}

static gboolean
___lambda50__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda50_ (self);
	return result;
}

static void
files_view_miller_smooth_adjustment_to (FilesViewMiller* self,
                                        GtkAdjustment* adj,
                                        gint final)
{
	Block47Data* _data47_;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gint _tmp3_ = 0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adj != NULL);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (adj);
	_g_object_unref0 (_data47_->adj);
	_data47_->adj = _tmp0_;
	_data47_->final = final;
	files_view_miller_cancel_animation (self);
	_tmp1_ = gtk_adjustment_get_value (_data47_->adj);
	_tmp2_ = _tmp1_;
	_data47_->initial = _tmp2_;
	_data47_->to_do = _data47_->final - _data47_->initial;
	if (_data47_->to_do > ((gdouble) 0)) {
		_data47_->factor = 1;
		_tmp3_ = _data47_->factor;
	} else {
		_data47_->factor = -1;
		_tmp3_ = _data47_->factor;
	}
	_data47_->to_do = (gdouble) (abs ((gint) _data47_->to_do) + 1);
	_data47_->newvalue = 0;
	_tmp4_ = gtk_adjustment_get_value (_data47_->adj);
	_tmp5_ = _tmp4_;
	_data47_->old_adj_value = _tmp5_;
	self->priv->animation_timeout_source_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) (1000 / 60), ___lambda50__gsource_func, block47_data_ref (_data47_), block47_data_unref);
	block47_data_unref (_data47_);
	_data47_ = NULL;
}

static gboolean
files_view_miller_get_animating (FilesViewMiller* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->animation_timeout_source_id > ((guint) 0);
	return result;
}

static void
files_view_miller_cancel_animation (FilesViewMiller* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->animation_timeout_source_id > ((guint) 0)) {
		g_source_remove (self->priv->animation_timeout_source_id);
		self->priv->animation_timeout_source_id = (guint) 0;
	}
}

FilesViewViewContainer*
files_view_miller_get_ctab (FilesViewMiller* self)
{
	FilesViewViewContainer* result;
	FilesViewViewContainer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_ctab;
	result = _tmp0_;
	return result;
}

static void
files_view_miller_set_ctab (FilesViewMiller* self,
                            FilesViewViewContainer* value)
{
	FilesViewViewContainer* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_miller_get_ctab (self);
	if (old_value != value) {
		self->priv->_ctab = value;
		g_object_notify_by_pspec ((GObject *) self, files_view_miller_properties[FILES_VIEW_MILLER_CTAB_PROPERTY]);
	}
}

GFile*
files_view_miller_get_root_location (FilesViewMiller* self)
{
	GFile* result;
	GFile* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_root_location;
	result = _tmp0_;
	return result;
}

void
files_view_miller_set_root_location (FilesViewMiller* self,
                                     GFile* value)
{
	GFile* old_value;
	g_return_if_fail (self != NULL);
	old_value = files_view_miller_get_root_location (self);
	if (old_value != value) {
		GFile* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_root_location);
		self->priv->_root_location = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, files_view_miller_properties[FILES_VIEW_MILLER_ROOT_LOCATION_PROPERTY]);
	}
}

static gboolean
files_view_miller_real_get_is_frozen (FilesAbstractSlot* base)
{
	gboolean result;
	FilesViewMiller* self;
	gboolean _tmp0_ = FALSE;
	FilesViewSlot* _tmp1_;
	self = (FilesViewMiller*) base;
	_tmp1_ = self->current_slot;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		FilesViewSlot* _tmp2_;
		gboolean _tmp3_;
		gboolean _tmp4_;
		_tmp2_ = self->current_slot;
		_tmp3_ = files_abstract_slot_get_is_frozen ((FilesAbstractSlot*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

static void
files_view_miller_real_set_is_frozen (FilesAbstractSlot* base,
                                      gboolean value)
{
	FilesViewMiller* self;
	FilesViewSlot* _tmp0_;
	self = (FilesViewMiller*) base;
	_tmp0_ = self->current_slot;
	if (_tmp0_ != NULL) {
		FilesViewSlot* _tmp1_;
		_tmp1_ = self->current_slot;
		files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) _tmp1_, value);
	}
	g_object_notify_by_pspec ((GObject *) self, files_view_miller_properties[FILES_VIEW_MILLER_IS_FROZEN_PROPERTY]);
}

static void
_files_view_miller___lambda69_ (FilesViewMiller* self,
                                GObject* s,
                                GParamSpec* p)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = files_preferences_get_show_hidden_files (G_TYPE_CHECK_INSTANCE_CAST (s, FILES_TYPE_PREFERENCES, FilesPreferences));
	_tmp1_ = _tmp0_;
	files_view_miller_show_hidden_files_changed (self, _tmp1_);
}

static void
__files_view_miller___lambda69__g_object_notify (GObject* _sender,
                                                 GParamSpec* pspec,
                                                 gpointer self)
{
	_files_view_miller___lambda69_ ((FilesViewMiller*) self, _sender, pspec);
}

static GObject *
files_view_miller_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesViewMiller * self;
	FilesPreferences* _tmp0_;
	FilesPreferences* _tmp1_;
	GtkBox* _tmp2_;
	GtkViewport* _tmp3_ = NULL;
	GtkViewport* _tmp4_;
	GtkBox* _tmp5_;
	GtkViewport* _tmp6_;
	GtkWidget* _tmp7_;
	GtkScrolledWindow* _tmp8_ = NULL;
	GtkScrolledWindow* _tmp9_;
	GtkAdjustment* _tmp10_;
	GtkAdjustment* _tmp11_;
	GtkScrolledWindow* _tmp12_;
	GtkBox* _tmp13_;
	GFile* _tmp14_;
	parent_class = G_OBJECT_CLASS (files_view_miller_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_MILLER, FilesViewMiller);
	_tmp0_ = files_preferences_get_default ();
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::show-hidden-files", (GCallback) __files_view_miller___lambda69__g_object_notify, self, 0);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->colpane);
	self->priv->colpane = _tmp2_;
	_tmp3_ = (GtkViewport*) gtk_viewport_new (NULL, NULL);
	gtk_viewport_set_shadow_type (_tmp3_, GTK_SHADOW_NONE);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->viewport);
	self->priv->viewport = _tmp3_;
	_tmp4_ = self->priv->viewport;
	_tmp5_ = self->priv->colpane;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->viewport;
	_tmp7_ = _g_object_ref0 ((GtkWidget*) _tmp6_);
	_tmp8_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp8_, "child", _tmp7_, NULL);
	_g_object_unref0 (_tmp7_);
	g_object_set (_tmp8_, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	g_object_set (_tmp8_, "vscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp8_;
	_tmp9_ = self->priv->scrolled_window;
	_tmp10_ = gtk_scrolled_window_get_hadjustment (_tmp9_);
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->hadj);
	self->hadj = _tmp11_;
	_tmp12_ = self->priv->scrolled_window;
	files_abstract_slot_add_overlay ((FilesAbstractSlot*) self, (GtkWidget*) _tmp12_);
	_tmp13_ = ((FilesAbstractSlot*) self)->content_box;
	gtk_widget_show_all ((GtkWidget*) _tmp13_);
	self->current_slot = NULL;
	_tmp14_ = self->priv->_root_location;
	files_view_miller_add_location (self, _tmp14_, NULL);
	files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, TRUE);
	return obj;
}

static void
files_view_miller_class_init (FilesViewMillerClass * klass,
                              gpointer klass_data)
{
	files_view_miller_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesViewMiller_private_offset);
	((FilesAbstractSlotClass *) klass)->user_path_change_request = (void (*) (FilesAbstractSlot*, GFile*, gboolean)) files_view_miller_real_user_path_change_request;
	((FilesAbstractSlotClass *) klass)->get_current_slot = (FilesAbstractSlot* (*) (FilesAbstractSlot*)) files_view_miller_real_get_current_slot;
	((FilesAbstractSlotClass *) klass)->get_selected_files = (GList* (*) (FilesAbstractSlot*)) files_view_miller_real_get_selected_files;
	((FilesAbstractSlotClass *) klass)->set_active_state = (void (*) (FilesAbstractSlot*, gboolean, gboolean)) files_view_miller_real_set_active_state;
	((FilesAbstractSlotClass *) klass)->get_tip_uri = (gchar* (*) (FilesAbstractSlot*)) files_view_miller_real_get_tip_uri;
	((FilesAbstractSlotClass *) klass)->get_root_uri = (gchar* (*) (FilesAbstractSlot*)) files_view_miller_real_get_root_uri;
	((FilesAbstractSlotClass *) klass)->select_glib_files = (void (*) (FilesAbstractSlot*, GList*, GFile*)) files_view_miller_real_select_glib_files;
	((FilesAbstractSlotClass *) klass)->focus_first_for_empty_selection = (void (*) (FilesAbstractSlot*, gboolean)) files_view_miller_real_focus_first_for_empty_selection;
	((FilesAbstractSlotClass *) klass)->zoom_in = (void (*) (FilesAbstractSlot*)) files_view_miller_real_zoom_in;
	((FilesAbstractSlotClass *) klass)->zoom_out = (void (*) (FilesAbstractSlot*)) files_view_miller_real_zoom_out;
	((FilesAbstractSlotClass *) klass)->zoom_normal = (void (*) (FilesAbstractSlot*)) files_view_miller_real_zoom_normal;
	((FilesAbstractSlotClass *) klass)->grab_focus = (void (*) (FilesAbstractSlot*)) files_view_miller_real_grab_focus;
	((FilesAbstractSlotClass *) klass)->initialize_directory = (void (*) (FilesAbstractSlot*)) files_view_miller_real_initialize_directory;
	((FilesAbstractSlotClass *) klass)->reload = (void (*) (FilesAbstractSlot*, gboolean)) files_view_miller_real_reload;
	((FilesAbstractSlotClass *) klass)->close = (void (*) (FilesAbstractSlot*)) files_view_miller_real_close;
	((FilesAbstractSlotClass *) klass)->set_all_selected = (gboolean (*) (FilesAbstractSlot*, gboolean)) files_view_miller_real_set_all_selected;
	((FilesAbstractSlotClass *) klass)->lookup_file_info = (GFileInfo* (*) (FilesAbstractSlot*, GFile*)) files_view_miller_real_lookup_file_info;
	FILES_ABSTRACT_SLOT_CLASS (klass)->get_is_frozen = (gboolean (*) (FilesAbstractSlot*)) files_view_miller_real_get_is_frozen;
	FILES_ABSTRACT_SLOT_CLASS (klass)->set_is_frozen = (void (*) (FilesAbstractSlot*, gboolean)) files_view_miller_real_set_is_frozen;
	G_OBJECT_CLASS (klass)->get_property = _vala_files_view_miller_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_view_miller_set_property;
	G_OBJECT_CLASS (klass)->constructor = files_view_miller_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_view_miller_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_MILLER_CTAB_PROPERTY, files_view_miller_properties[FILES_VIEW_MILLER_CTAB_PROPERTY] = g_param_spec_object ("ctab", "ctab", "ctab", FILES_VIEW_TYPE_VIEW_CONTAINER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_MILLER_ROOT_LOCATION_PROPERTY, files_view_miller_properties[FILES_VIEW_MILLER_ROOT_LOCATION_PROPERTY] = g_param_spec_object ("root-location", "root-location", "root-location", g_file_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_VIEW_MILLER_IS_FROZEN_PROPERTY, files_view_miller_properties[FILES_VIEW_MILLER_IS_FROZEN_PROPERTY] = g_param_spec_boolean ("is-frozen", "is-frozen", "is-frozen", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
files_view_miller_instance_init (FilesViewMiller * self,
                                 gpointer klass)
{
	self->priv = files_view_miller_get_instance_private (self);
	self->priv->scroll_to_slot_timeout_id = (guint) 0;
	self->slot_list = NULL;
	self->total_width = 0;
	self->priv->total_width_timeout_id = (guint) 0;
	self->priv->animation_timeout_source_id = (guint) 0;
}

static void
files_view_miller_finalize (GObject * obj)
{
	FilesViewMiller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_VIEW_TYPE_MILLER, FilesViewMiller);
	g_debug ("Miller.vala:89: Miller destruct");
	_g_object_unref0 (self->priv->_root_location);
	_g_object_unref0 (self->priv->colpane);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->viewport);
	_g_object_unref0 (self->hadj);
	(self->slot_list == NULL) ? NULL : (self->slot_list = (_g_list_free__g_object_unref0_ (self->slot_list), NULL));
	G_OBJECT_CLASS (files_view_miller_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_view_miller_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesViewMillerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_view_miller_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesViewMiller), 0, (GInstanceInitFunc) files_view_miller_instance_init, NULL };
	GType files_view_miller_type_id;
	files_view_miller_type_id = g_type_register_static (FILES_TYPE_ABSTRACT_SLOT, "FilesViewMiller", &g_define_type_info, 0);
	FilesViewMiller_private_offset = g_type_add_instance_private (files_view_miller_type_id, sizeof (FilesViewMillerPrivate));
	return files_view_miller_type_id;
}

GType
files_view_miller_get_type (void)
{
	static volatile gsize files_view_miller_type_id__once = 0;
	if (g_once_init_enter (&files_view_miller_type_id__once)) {
		GType files_view_miller_type_id;
		files_view_miller_type_id = files_view_miller_get_type_once ();
		g_once_init_leave (&files_view_miller_type_id__once, files_view_miller_type_id);
	}
	return files_view_miller_type_id__once;
}

static void
_vala_files_view_miller_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	FilesViewMiller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_MILLER, FilesViewMiller);
	switch (property_id) {
		case FILES_VIEW_MILLER_CTAB_PROPERTY:
		g_value_set_object (value, files_view_miller_get_ctab (self));
		break;
		case FILES_VIEW_MILLER_ROOT_LOCATION_PROPERTY:
		g_value_set_object (value, files_view_miller_get_root_location (self));
		break;
		case FILES_VIEW_MILLER_IS_FROZEN_PROPERTY:
		g_value_set_boolean (value, files_abstract_slot_get_is_frozen ((FilesAbstractSlot*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_view_miller_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	FilesViewMiller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_VIEW_TYPE_MILLER, FilesViewMiller);
	switch (property_id) {
		case FILES_VIEW_MILLER_CTAB_PROPERTY:
		files_view_miller_set_ctab (self, g_value_get_object (value));
		break;
		case FILES_VIEW_MILLER_ROOT_LOCATION_PROPERTY:
		files_view_miller_set_root_location (self, g_value_get_object (value));
		break;
		case FILES_VIEW_MILLER_IS_FROZEN_PROPERTY:
		files_abstract_slot_set_is_frozen ((FilesAbstractSlot*) self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

