/* ClipboardManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ClipboardManager.vala, do not modify */

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include "pantheon-files-core.h"
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "marlin-file-operations.h"
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define FILES_TYPE_CLIPBOARD_MANAGER (files_clipboard_manager_get_type ())
#define FILES_CLIPBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager))
#define FILES_CLIPBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManagerClass))
#define FILES_IS_CLIPBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FILES_TYPE_CLIPBOARD_MANAGER))
#define FILES_IS_CLIPBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FILES_TYPE_CLIPBOARD_MANAGER))
#define FILES_CLIPBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManagerClass))

typedef struct _FilesClipboardManager FilesClipboardManager;
typedef struct _FilesClipboardManagerClass FilesClipboardManagerClass;
typedef struct _FilesClipboardManagerPrivate FilesClipboardManagerPrivate;
enum  {
	FILES_CLIPBOARD_MANAGER_0_PROPERTY,
	FILES_CLIPBOARD_MANAGER_FILES_LINKED_PROPERTY,
	FILES_CLIPBOARD_MANAGER_CAN_PASTE_PROPERTY,
	FILES_CLIPBOARD_MANAGER_NUM_PROPERTIES
};
static GParamSpec* files_clipboard_manager_properties[FILES_CLIPBOARD_MANAGER_NUM_PROPERTIES];
typedef enum  {
	FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_GNOME_COPIED_FILES,
	FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_PNG_IMAGE,
	FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_UTF8_STRING
} FilesClipboardManagerClipboardTarget;

#define FILES_CLIPBOARD_MANAGER_TYPE_CLIPBOARD_TARGET (files_clipboard_manager_clipboard_target_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _FilesClipboardManagerPasteFilesData FilesClipboardManagerPasteFilesData;
#define __vala_GtkSelectionData_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkSelectionData_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _FilesClipboardManagerContentsReceivedData FilesClipboardManagerContentsReceivedData;
enum  {
	FILES_CLIPBOARD_MANAGER_CHANGED_SIGNAL,
	FILES_CLIPBOARD_MANAGER_NUM_SIGNALS
};
static guint files_clipboard_manager_signals[FILES_CLIPBOARD_MANAGER_NUM_SIGNALS] = {0};

struct _FilesClipboardManager {
	GObject parent_instance;
	FilesClipboardManagerPrivate * priv;
};

struct _FilesClipboardManagerClass {
	GObjectClass parent_class;
};

struct _FilesClipboardManagerPrivate {
	GtkClipboard* clipboard;
	GList* files;
	gboolean files_cutted;
	gboolean _files_linked;
	gboolean _can_paste;
};

struct _Block3Data {
	int _ref_count_;
	FilesClipboardManager* self;
	GFile* target_file;
	GtkWidget* widget;
	gpointer _async_data_;
};

struct _FilesClipboardManagerPasteFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesClipboardManager* self;
	GFile* target_file;
	GtkWidget* widget;
	Block3Data* _data3_;
	GtkClipboard* _tmp0_;
};

struct _FilesClipboardManagerContentsReceivedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	FilesClipboardManager* self;
	GtkSelectionData* sd;
	GFile* target_file;
	GtkWidget* widget;
	gchar* text;
	gchar* _tmp0_;
	gboolean _tmp1_;
	const gchar* _tmp2_;
	GdkDragAction action;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	GList* file_list;
	const gchar* _tmp12_;
	GList* _tmp13_;
	GList* _tmp14_;
	GList* _tmp15_;
	GError* e;
	GError* _tmp16_;
	GError* _tmp17_;
	GtkClipboard* _tmp18_;
	GtkClipboard* _tmp19_;
	GdkDisplay* _tmp20_;
	GError* _inner_error0_;
};

static gint FilesClipboardManager_private_offset;
static gpointer files_clipboard_manager_parent_class = NULL;
static GQuark files_clipboard_manager_marlin_clipboard_manager_quark;
static GQuark files_clipboard_manager_marlin_clipboard_manager_quark = 0U;
static GdkAtom files_clipboard_manager_x_special_gnome_copied_files;
static GdkAtom files_clipboard_manager_x_special_gnome_copied_files = 0U;

VALA_EXTERN GType files_clipboard_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FilesClipboardManager, g_object_unref)
static void files_clipboard_manager_release_pending_files (FilesClipboardManager* self);
static void files_clipboard_manager_owner_changed (FilesClipboardManager* self,
                                            GdkEvent* owner_change_event);
static void _files_clipboard_manager_owner_changed_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                        GdkEventOwnerChange* event,
                                                                        gpointer self);
static GType files_clipboard_manager_clipboard_target_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static FilesClipboardManager* files_clipboard_manager_new (GtkClipboard* _clipboard);
static FilesClipboardManager* files_clipboard_manager_construct (GType object_type,
                                                          GtkClipboard* _clipboard);
VALA_EXTERN FilesClipboardManager* files_clipboard_manager_get_for_display (GdkDisplay* display);
VALA_EXTERN gboolean files_clipboard_manager_has_cutted_file (FilesClipboardManager* self,
                                                  FilesFile* file);
VALA_EXTERN gboolean files_clipboard_manager_has_file (FilesClipboardManager* self,
                                           FilesFile* file);
VALA_EXTERN void files_clipboard_manager_copy_files (FilesClipboardManager* self,
                                         GList* files);
static void files_clipboard_manager_transfer_files (FilesClipboardManager* self,
                                             gboolean copy,
                                             gboolean link,
                                             GList* files_for_transfer);
VALA_EXTERN void files_clipboard_manager_copy_link_files (FilesClipboardManager* self,
                                              GList* files);
VALA_EXTERN void files_clipboard_manager_cut_files (FilesClipboardManager* self,
                                        GList* files);
static void files_clipboard_manager_paste_files_data_free (gpointer _data);
VALA_EXTERN void files_clipboard_manager_paste_files (FilesClipboardManager* self,
                                          GFile* target_file,
                                          GtkWidget* widget,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
VALA_EXTERN void files_clipboard_manager_paste_files_finish (FilesClipboardManager* self,
                                                 GAsyncResult* _res_);
static gboolean files_clipboard_manager_paste_files_co (FilesClipboardManagerPasteFilesData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void __lambda13_ (Block3Data* _data3_,
                  GtkClipboard* cb,
                  GtkSelectionData* sd);
static void files_clipboard_manager_contents_received (FilesClipboardManager* self,
                                                GtkSelectionData* sd,
                                                GFile* target_file,
                                                GtkWidget* widget,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void files_clipboard_manager_contents_received_finish (FilesClipboardManager* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void __lambda14_ (Block3Data* _data3_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda14__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ___lambda13__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                               GtkSelectionData* selection_data,
                                               gpointer self);
static void _vala_GtkSelectionData_free (GtkSelectionData* self);
static void files_clipboard_manager_contents_received_data_free (gpointer _data);
static GtkSelectionData* _vala_GtkSelectionData_copy (GtkSelectionData* self);
static gboolean files_clipboard_manager_contents_received_co (FilesClipboardManagerContentsReceivedData* _data_);
static void files_clipboard_manager_contents_received_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void __lambda12_ (FilesClipboardManager* self,
                  GtkClipboard* cb,
                  GtkSelectionData* sd);
static void files_clipboard_manager_set_can_paste (FilesClipboardManager* self,
                                            gboolean value);
static void ___lambda12__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                               GtkSelectionData* selection_data,
                                               gpointer self);
static void files_clipboard_manager_set_files_linked (FilesClipboardManager* self,
                                               gboolean value);
static void files_clipboard_manager_on_file_destroyed (FilesClipboardManager* self,
                                                FilesFile* file);
static void _files_clipboard_manager_on_file_destroyed_files_file_destroy (FilesFile* _sender,
                                                                    gpointer self);
VALA_EXTERN void files_clipboard_manager_get_callback (GtkClipboard* cb,
                                           GtkSelectionData* sd,
                                           guint target_info,
                                           void* parent);
static void _files_clipboard_manager_get_callback_gtk_clipboard_get_func (GtkClipboard* clipboard,
                                                                   GtkSelectionData* selection_data,
                                                                   guint info,
                                                                   void* user_data_or_owner);
VALA_EXTERN void files_clipboard_manager_clear_callback (GtkClipboard* cb,
                                             void* parent);
static void _files_clipboard_manager_clear_callback_gtk_clipboard_clear_func (GtkClipboard* clipboard,
                                                                       void* user_data_or_owner);
VALA_EXTERN gboolean files_clipboard_manager_get_files_linked (FilesClipboardManager* self);
VALA_EXTERN gboolean files_clipboard_manager_get_can_paste (FilesClipboardManager* self);
static void files_clipboard_manager_finalize (GObject * obj);
static GType files_clipboard_manager_get_type_once (void);
static void _vala_files_clipboard_manager_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec);
static void _vala_files_clipboard_manager_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec);

static const GtkTargetEntry FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGETS[3] = {{"x-special/gnome-copied-files", (guint) 0, (guint) FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_GNOME_COPIED_FILES}, {"image/png", (guint) 0, (guint) FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_PNG_IMAGE}, {"UTF8_STRING", (guint) 0, (guint) FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_UTF8_STRING}};

static inline gpointer
files_clipboard_manager_get_instance_private (FilesClipboardManager* self)
{
	return G_STRUCT_MEMBER_P (self, FilesClipboardManager_private_offset);
}

static void
_files_clipboard_manager_owner_changed_gtk_clipboard_owner_change (GtkClipboard* _sender,
                                                                   GdkEventOwnerChange* event,
                                                                   gpointer self)
{
	files_clipboard_manager_owner_changed ((FilesClipboardManager*) self, event);
}

 G_GNUC_NO_INLINE static GType
files_clipboard_manager_clipboard_target_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_GNOME_COPIED_FILES, "FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_GNOME_COPIED_FILES", "gnome-copied-files"}, {FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_PNG_IMAGE, "FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_PNG_IMAGE", "png-image"}, {FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_UTF8_STRING, "FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_UTF8_STRING", "utf8-string"}, {0, NULL, NULL}};
	GType files_clipboard_manager_clipboard_target_type_id;
	files_clipboard_manager_clipboard_target_type_id = g_enum_register_static ("FilesClipboardManagerClipboardTarget", values);
	return files_clipboard_manager_clipboard_target_type_id;
}

static GType
files_clipboard_manager_clipboard_target_get_type (void)
{
	static volatile gsize files_clipboard_manager_clipboard_target_type_id__once = 0;
	if (g_once_init_enter (&files_clipboard_manager_clipboard_target_type_id__once)) {
		GType files_clipboard_manager_clipboard_target_type_id;
		files_clipboard_manager_clipboard_target_type_id = files_clipboard_manager_clipboard_target_get_type_once ();
		g_once_init_leave (&files_clipboard_manager_clipboard_target_type_id__once, files_clipboard_manager_clipboard_target_type_id);
	}
	return files_clipboard_manager_clipboard_target_type_id__once;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static FilesClipboardManager*
files_clipboard_manager_construct (GType object_type,
                                   GtkClipboard* _clipboard)
{
	FilesClipboardManager * self = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	FilesClipboardManager* _tmp2_;
	GtkClipboard* _tmp3_;
	g_return_val_if_fail (_clipboard != NULL, NULL);
	self = (FilesClipboardManager*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (_clipboard);
	_g_object_unref0 (self->priv->clipboard);
	self->priv->clipboard = _tmp0_;
	_tmp1_ = self->priv->clipboard;
	_tmp2_ = _g_object_ref0 (self);
	g_object_set_qdata_full ((GObject*) _tmp1_, files_clipboard_manager_marlin_clipboard_manager_quark, _tmp2_, g_object_unref);
	_tmp3_ = self->priv->clipboard;
	g_signal_connect_object (_tmp3_, "owner-change", (GCallback) _files_clipboard_manager_owner_changed_gtk_clipboard_owner_change, self, 0);
	return self;
}

static FilesClipboardManager*
files_clipboard_manager_new (GtkClipboard* _clipboard)
{
	return files_clipboard_manager_construct (FILES_TYPE_CLIPBOARD_MANAGER, _clipboard);
}

FilesClipboardManager*
files_clipboard_manager_get_for_display (GdkDisplay* display)
{
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp0_;
	GtkClipboard* _tmp1_;
	FilesClipboardManager* manager = NULL;
	GtkClipboard* _tmp2_;
	gconstpointer _tmp3_;
	FilesClipboardManager* _tmp4_;
	FilesClipboardManager* _tmp5_;
	FilesClipboardManager* result;
	if (display == NULL) {
		g_critical ("ClipboardManager.vala:68: ClipboardManager cannot find display");
		g_assert_not_reached ();
	}
	_tmp0_ = gtk_clipboard_get_for_display (display, GDK_SELECTION_CLIPBOARD);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	clipboard = _tmp1_;
	_tmp2_ = clipboard;
	_tmp3_ = g_object_get_qdata ((GObject*) _tmp2_, files_clipboard_manager_marlin_clipboard_manager_quark);
	_tmp4_ = _g_object_ref0 ((FilesClipboardManager*) _tmp3_);
	manager = _tmp4_;
	_tmp5_ = manager;
	if (_tmp5_ != NULL) {
		result = manager;
		_g_object_unref0 (clipboard);
		return result;
	} else {
		GtkClipboard* _tmp6_;
		FilesClipboardManager* _tmp7_;
		_tmp6_ = clipboard;
		_tmp7_ = files_clipboard_manager_new (_tmp6_);
		result = _tmp7_;
		_g_object_unref0 (manager);
		_g_object_unref0 (clipboard);
		return result;
	}
}

/** If @file is null, returns whether there are ANY cut files
         * otherwise whether @file is amongst the cut files
        **/
gboolean
files_clipboard_manager_has_cutted_file (FilesClipboardManager* self,
                                         FilesFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (self->priv->files_cutted) {
		gboolean _tmp1_ = FALSE;
		if (file == NULL) {
			_tmp1_ = TRUE;
		} else {
			_tmp1_ = files_clipboard_manager_has_file (self, file);
		}
		_tmp0_ = _tmp1_;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
files_clipboard_manager_has_file (FilesClipboardManager* self,
                                  FilesFile* file)
{
	gboolean _tmp0_ = FALSE;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_tmp1_ = self->priv->files;
	if (_tmp1_ != NULL) {
		GList* _tmp2_;
		GList* _tmp3_;
		_tmp2_ = self->priv->files;
		_tmp3_ = g_list_find (_tmp2_, file);
		_tmp0_ = _tmp3_ != NULL;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
files_clipboard_manager_copy_files (FilesClipboardManager* self,
                                    GList* files)
{
	g_return_if_fail (self != NULL);
	files_clipboard_manager_transfer_files (self, TRUE, FALSE, files);
}

void
files_clipboard_manager_copy_link_files (FilesClipboardManager* self,
                                         GList* files)
{
	g_return_if_fail (self != NULL);
	files_clipboard_manager_transfer_files (self, TRUE, TRUE, files);
}

void
files_clipboard_manager_cut_files (FilesClipboardManager* self,
                                   GList* files)
{
	g_return_if_fail (self != NULL);
	files_clipboard_manager_transfer_files (self, FALSE, FALSE, files);
}

static void
files_clipboard_manager_paste_files_data_free (gpointer _data)
{
	FilesClipboardManagerPasteFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesClipboardManagerPasteFilesData, _data_);
}

void
files_clipboard_manager_paste_files (FilesClipboardManager* self,
                                     GFile* target_file,
                                     GtkWidget* widget,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	FilesClipboardManagerPasteFilesData* _data_;
	FilesClipboardManager* _tmp0_;
	GFile* _tmp1_;
	GtkWidget* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (target_file != NULL);
	_data_ = g_slice_new0 (FilesClipboardManagerPasteFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_clipboard_manager_paste_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (target_file);
	_g_object_unref0 (_data_->target_file);
	_data_->target_file = _tmp1_;
	_tmp2_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp2_;
	files_clipboard_manager_paste_files_co (_data_);
}

void
files_clipboard_manager_paste_files_finish (FilesClipboardManager* self,
                                            GAsyncResult* _res_)
{
	FilesClipboardManagerPasteFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

/**
         * @target_file        : the #GFile of the folder to which the contents on the clipboard
         *                       should be pasted.
         * @widget             : a #GtkWidget, on which to perform the paste or %NULL if no widget is
         *                       known.
         * @new_files_callback : a #GCallback to connect to the job's "new-files" signal,
         *                       which will be emitted when the job finishes with the
         *                       list of #GFile<!---->s created by the job, or
         *                       %NULL if you're not interested in the signal.
         *
         * Pastes the contents from the clipboard to the directory
         * referenced by @target_file.
        **/
static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		FilesClipboardManager* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->target_file);
		_g_object_unref0 (_data3_->widget);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
__lambda14_ (Block3Data* _data3_,
             GObject* obj,
             GAsyncResult* res)
{
	FilesClipboardManager* self;
	GError* _inner_error0_ = NULL;
	self = _data3_->self;
	g_return_if_fail (res != NULL);
	{
		files_clipboard_manager_contents_received_finish (self, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_debug ("ClipboardManager.vala:135: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	files_clipboard_manager_paste_files_co (_data3_->_async_data_);
}

static void
___lambda14__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda14_ (self, source_object, res);
	block3_data_unref (self);
}

static void
__lambda13_ (Block3Data* _data3_,
             GtkClipboard* cb,
             GtkSelectionData* sd)
{
	FilesClipboardManager* self;
	self = _data3_->self;
	g_return_if_fail (cb != NULL);
	g_return_if_fail (sd != NULL);
	files_clipboard_manager_contents_received (self, sd, _data3_->target_file, _data3_->widget, ___lambda14__gasync_ready_callback, block3_data_ref (_data3_));
}

static void
___lambda13__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                          GtkSelectionData* selection_data,
                                          gpointer self)
{
	__lambda13_ (self, clipboard, selection_data);
	block3_data_unref (self);
}

static gboolean
files_clipboard_manager_paste_files_co (FilesClipboardManagerPasteFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_g_object_unref0 (_data_->_data3_->target_file);
	_data_->_data3_->target_file = _data_->target_file;
	_g_object_unref0 (_data_->_data3_->widget);
	_data_->_data3_->widget = _data_->widget;
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->self->priv->clipboard;
	gtk_clipboard_request_contents (_data_->_tmp0_, files_clipboard_manager_x_special_gnome_copied_files, ___lambda13__gtk_clipboard_received_func, block3_data_ref (_data_->_data3_));
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
_vala_GtkSelectionData_free (GtkSelectionData* self)
{
	g_boxed_free (gtk_selection_data_get_type (), self);
}

static void
files_clipboard_manager_contents_received_data_free (gpointer _data)
{
	FilesClipboardManagerContentsReceivedData* _data_;
	_data_ = _data;
	__vala_GtkSelectionData_free0 (_data_->sd);
	_g_object_unref0 (_data_->target_file);
	_g_object_unref0 (_data_->widget);
	_g_object_unref0 (_data_->self);
	g_slice_free (FilesClipboardManagerContentsReceivedData, _data_);
}

static GtkSelectionData*
_vala_GtkSelectionData_copy (GtkSelectionData* self)
{
	return g_boxed_copy (gtk_selection_data_get_type (), self);
}

static gpointer
__vala_GtkSelectionData_copy0 (gpointer self)
{
	return self ? _vala_GtkSelectionData_copy (self) : NULL;
}

static void
files_clipboard_manager_contents_received (FilesClipboardManager* self,
                                           GtkSelectionData* sd,
                                           GFile* target_file,
                                           GtkWidget* widget,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	FilesClipboardManagerContentsReceivedData* _data_;
	FilesClipboardManager* _tmp0_;
	GtkSelectionData* _tmp1_;
	GFile* _tmp2_;
	GtkWidget* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (sd != NULL);
	g_return_if_fail (target_file != NULL);
	_data_ = g_slice_new0 (FilesClipboardManagerContentsReceivedData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, files_clipboard_manager_contents_received_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = __vala_GtkSelectionData_copy0 (sd);
	__vala_GtkSelectionData_free0 (_data_->sd);
	_data_->sd = _tmp1_;
	_tmp2_ = _g_object_ref0 (target_file);
	_g_object_unref0 (_data_->target_file);
	_data_->target_file = _tmp2_;
	_tmp3_ = _g_object_ref0 (widget);
	_g_object_unref0 (_data_->widget);
	_data_->widget = _tmp3_;
	files_clipboard_manager_contents_received_co (_data_);
}

static void
files_clipboard_manager_contents_received_finish (FilesClipboardManager* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	FilesClipboardManagerContentsReceivedData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
	if (NULL == _data_) {
		return;
	}
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

static void
files_clipboard_manager_contents_received_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	FilesClipboardManagerContentsReceivedData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	files_clipboard_manager_contents_received_co (_data_);
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

static gboolean
files_clipboard_manager_contents_received_co (FilesClipboardManagerContentsReceivedData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp1_ = files_dnd_handler_selection_data_is_uri_list (_data_->sd, (guint) FILES_TARGET_TYPE_TEXT_URI_LIST, &_data_->_tmp0_);
	_g_free0 (_data_->text);
	_data_->text = _data_->_tmp0_;
	if (!_data_->_tmp1_) {
		g_warning ("ClipboardManager.vala:151: Selection data not uri_list in Files.Clipbo" \
"ardManager contents_received");
		_g_free0 (_data_->text);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = _data_->text;
	if (_data_->_tmp2_ == NULL) {
		g_warning ("ClipboardManager.vala:156: Empty selection data in Files.ClipboardMana" \
"ger contents_received");
		_g_free0 (_data_->text);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->action = 0;
	_data_->_tmp3_ = _data_->text;
	if (g_str_has_prefix (_data_->_tmp3_, "copy")) {
		_data_->action = GDK_ACTION_COPY;
		_data_->_tmp4_ = _data_->text;
		_data_->_tmp5_ = string_substring (_data_->_tmp4_, (glong) 4, (glong) -1);
		_g_free0 (_data_->text);
		_data_->text = _data_->_tmp5_;
	} else {
		_data_->_tmp6_ = _data_->text;
		if (g_str_has_prefix (_data_->_tmp6_, "cut")) {
			_data_->action = GDK_ACTION_MOVE;
			_data_->_tmp7_ = _data_->text;
			_data_->_tmp8_ = string_substring (_data_->_tmp7_, (glong) 3, (glong) -1);
			_g_free0 (_data_->text);
			_data_->text = _data_->_tmp8_;
		} else {
			_data_->_tmp9_ = _data_->text;
			if (g_str_has_prefix (_data_->_tmp9_, "link")) {
				_data_->action = GDK_ACTION_LINK;
				_data_->_tmp10_ = _data_->text;
				_data_->_tmp11_ = string_substring (_data_->_tmp10_, (glong) 4, (glong) -1);
				_g_free0 (_data_->text);
				_data_->text = _data_->_tmp11_;
			} else {
				g_warning ("ClipboardManager.vala:171: Invalid selection data in Files.ClipboardMa" \
"nager contents_received");
				_g_free0 (_data_->text);
				g_task_return_pointer (_data_->_async_result, _data_, NULL);
				if (_data_->_state_ != 0) {
					while (!g_task_get_completed (_data_->_async_result)) {
						g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
					}
				}
				g_object_unref (_data_->_async_result);
				return FALSE;
			}
		}
	}
	_data_->_tmp12_ = _data_->text;
	_data_->_tmp13_ = files_file_utils_files_from_escaped_uris (_data_->_tmp12_);
	_data_->file_list = _data_->_tmp13_;
	_data_->_tmp14_ = _data_->file_list;
	if (_data_->_tmp14_ != NULL) {
		{
			_data_->_tmp15_ = _data_->file_list;
			_data_->_state_ = 1;
			marlin_file_operations_copy_move_link (_data_->_tmp15_, _data_->target_file, _data_->action, _data_->widget, NULL, files_clipboard_manager_contents_received_ready, _data_);
			return FALSE;
			_state_1:
			marlin_file_operations_copy_move_link_finish (_data_->_res_, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			_data_->e = _data_->_inner_error0_;
			_data_->_inner_error0_ = NULL;
			_data_->_tmp16_ = _data_->e;
			_data_->_tmp17_ = _g_error_copy0 (_data_->_tmp16_);
			_data_->_inner_error0_ = _data_->_tmp17_;
			_g_error_free0 (_data_->e);
			goto __finally0;
		}
		__finally0:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_task_return_error (_data_->_async_result, _data_->_inner_error0_);
			(_data_->file_list == NULL) ? NULL : (_data_->file_list = (_g_list_free__g_object_unref0_ (_data_->file_list), NULL));
			_g_free0 (_data_->text);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	if (_data_->action != GDK_ACTION_COPY) {
		_data_->_tmp18_ = _data_->self->priv->clipboard;
		gtk_clipboard_clear (_data_->_tmp18_);
	}
	_data_->_tmp19_ = _data_->self->priv->clipboard;
	_data_->_tmp20_ = gtk_clipboard_get_display (_data_->_tmp19_);
	if (!gdk_display_supports_selection_notification (_data_->_tmp20_)) {
		files_clipboard_manager_owner_changed (_data_->self, NULL);
	}
	(_data_->file_list == NULL) ? NULL : (_data_->file_list = (_g_list_free__g_object_unref0_ (_data_->file_list), NULL));
	_g_free0 (_data_->text);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
__lambda12_ (FilesClipboardManager* self,
             GtkClipboard* cb,
             GtkSelectionData* sd)
{
	GdkAtom* targets = NULL;
	gint targets_length1;
	gint _targets_size_;
	GdkAtom* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	GdkAtom* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (cb != NULL);
	g_return_if_fail (sd != NULL);
	files_clipboard_manager_set_can_paste (self, FALSE);
	targets = NULL;
	targets_length1 = 0;
	_targets_size_ = targets_length1;
	gtk_selection_data_get_targets (sd, &_tmp0_, &_tmp1_);
	targets = (g_free (targets), NULL);
	targets = _tmp0_;
	targets_length1 = _tmp1_;
	_targets_size_ = targets_length1;
	_tmp2_ = targets;
	_tmp2__length1 = targets_length1;
	{
		GdkAtom* target_collection = NULL;
		gint target_collection_length1 = 0;
		gint _target_collection_size_ = 0;
		gint target_it = 0;
		target_collection = _tmp2_;
		target_collection_length1 = _tmp2__length1;
		for (target_it = 0; target_it < target_collection_length1; target_it = target_it + 1) {
			GdkAtom target = (GdkAtom) 0U;
			target = target_collection[target_it];
			{
				if (target == files_clipboard_manager_x_special_gnome_copied_files) {
					files_clipboard_manager_set_can_paste (self, TRUE);
					break;
				}
			}
		}
	}
	g_signal_emit (self, files_clipboard_manager_signals[FILES_CLIPBOARD_MANAGER_CHANGED_SIGNAL], 0);
	g_object_notify ((GObject*) self, "can-paste");
	targets = (g_free (targets), NULL);
}

static void
___lambda12__gtk_clipboard_received_func (GtkClipboard* clipboard,
                                          GtkSelectionData* selection_data,
                                          gpointer self)
{
	__lambda12_ ((FilesClipboardManager*) self, clipboard, selection_data);
	g_object_unref (self);
}

static void
files_clipboard_manager_owner_changed (FilesClipboardManager* self,
                                       GdkEvent* owner_change_event)
{
	GtkClipboard* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clipboard;
	gtk_clipboard_request_contents (_tmp0_, gdk_atom_intern_static_string ("TARGETS"), ___lambda12__gtk_clipboard_received_func, g_object_ref (self));
}

/**
         * Sets the clipboard to contain @files_for_transfer and marks them to be copied
         * or moved according to @copy when the user pastes from the clipboard.
        **/
static void
_files_clipboard_manager_on_file_destroyed_files_file_destroy (FilesFile* _sender,
                                                               gpointer self)
{
	files_clipboard_manager_on_file_destroyed ((FilesClipboardManager*) self, _sender);
}

static void
_files_clipboard_manager_get_callback_gtk_clipboard_get_func (GtkClipboard* clipboard,
                                                              GtkSelectionData* selection_data,
                                                              guint info,
                                                              void* user_data_or_owner)
{
	files_clipboard_manager_get_callback (clipboard, selection_data, info, user_data_or_owner);
}

static void
_files_clipboard_manager_clear_callback_gtk_clipboard_clear_func (GtkClipboard* clipboard,
                                                                  void* user_data_or_owner)
{
	files_clipboard_manager_clear_callback (clipboard, user_data_or_owner);
}

static void
files_clipboard_manager_transfer_files (FilesClipboardManager* self,
                                        gboolean copy,
                                        gboolean link,
                                        GList* files_for_transfer)
{
	GtkClipboard* _tmp4_;
	GtkClipboard* _tmp5_;
	GdkDisplay* _tmp6_;
	g_return_if_fail (self != NULL);
	files_clipboard_manager_release_pending_files (self);
	self->priv->files_cutted = !copy;
	files_clipboard_manager_set_files_linked (self, link);
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = files_for_transfer;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			FilesFile* _tmp0_;
			FilesFile* file = NULL;
			_tmp0_ = _g_object_ref0 ((FilesFile*) file_it->data);
			file = _tmp0_;
			{
				FilesFile* _tmp1_;
				FilesFile* _tmp2_;
				FilesFile* _tmp3_;
				_tmp1_ = file;
				_tmp2_ = _g_object_ref0 (_tmp1_);
				self->priv->files = g_list_prepend (self->priv->files, _tmp2_);
				_tmp3_ = file;
				g_signal_connect_object (_tmp3_, "destroy", (GCallback) _files_clipboard_manager_on_file_destroyed_files_file_destroy, self, 0);
				_g_object_unref0 (file);
			}
		}
	}
	_tmp4_ = self->priv->clipboard;
	gtk_clipboard_set_with_owner (_tmp4_, FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGETS, (guint) G_N_ELEMENTS (FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGETS), _files_clipboard_manager_get_callback_gtk_clipboard_get_func, _files_clipboard_manager_clear_callback_gtk_clipboard_clear_func, (GObject*) self);
	_tmp5_ = self->priv->clipboard;
	_tmp6_ = gtk_clipboard_get_display (_tmp5_);
	if (!gdk_display_supports_selection_notification (_tmp6_)) {
		files_clipboard_manager_owner_changed (self, NULL);
	}
}

static GList*
vala_g_list_remove_full (GList* self,
                         gconstpointer data,
                         GFreeFunc func)
{
	GList* l = NULL;
	GList* result;
	l = self;
	while (TRUE) {
		GList* _tmp0_;
		GList* _tmp1_;
		gconstpointer _tmp2_;
		_tmp0_ = l;
		if (!(_tmp0_ != NULL)) {
			break;
		}
		_tmp1_ = l;
		_tmp2_ = ((GList*) _tmp1_)->data;
		if (_tmp2_ != data) {
			GList* _tmp3_;
			GList* _tmp4_;
			_tmp3_ = l;
			_tmp4_ = ((GList*) _tmp3_)->next;
			l = _tmp4_;
		} else {
			GList* _tmp5_;
			gconstpointer _tmp6_;
			GList* _tmp7_;
			_tmp5_ = l;
			_tmp6_ = ((GList*) _tmp5_)->data;
			func (_tmp6_);
			_tmp7_ = l;
			self = g_list_delete_link (self, (GList*) _tmp7_);
			break;
		}
	}
	result = self;
	return result;
}

static void
files_clipboard_manager_on_file_destroyed (FilesClipboardManager* self,
                                           FilesFile* file)
{
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_signal_parse_name ("destroy", FILES_TYPE_FILE, &_tmp0_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (file, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp0_, 0, NULL, (GCallback) _files_clipboard_manager_on_file_destroyed_files_file_destroy, self);
	self->priv->files = vala_g_list_remove_full (self->priv->files, file, _g_object_unref0_);
}

void
files_clipboard_manager_get_callback (GtkClipboard* cb,
                                      GtkSelectionData* sd,
                                      guint target_info,
                                      void* parent)
{
	FilesClipboardManager* manager = NULL;
	FilesClipboardManager* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FilesClipboardManager* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (cb != NULL);
	g_return_if_fail (sd != NULL);
	_tmp0_ = _g_object_ref0 (FILES_IS_CLIPBOARD_MANAGER (parent) ? ((FilesClipboardManager*) parent) : NULL);
	manager = _tmp0_;
	_tmp2_ = manager;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		FilesClipboardManager* _tmp3_;
		GtkClipboard* _tmp4_;
		_tmp3_ = manager;
		_tmp4_ = _tmp3_->priv->clipboard;
		_tmp1_ = _tmp4_ != cb;
	}
	if (_tmp1_) {
		_g_object_unref0 (manager);
		return;
	}
	switch (target_info) {
		case FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_GNOME_COPIED_FILES:
		{
			const gchar* _tmp5_ = NULL;
			FilesClipboardManager* _tmp6_;
			gchar* prefix = NULL;
			gchar* _tmp10_;
			FilesClipboardManager* _tmp11_;
			GList* _tmp12_;
			const gchar* _tmp13_;
			_tmp6_ = manager;
			if (_tmp6_->priv->files_cutted) {
				_tmp5_ = "cut";
			} else {
				const gchar* _tmp7_ = NULL;
				FilesClipboardManager* _tmp8_;
				gboolean _tmp9_;
				_tmp8_ = manager;
				_tmp9_ = _tmp8_->priv->_files_linked;
				if (_tmp9_) {
					_tmp7_ = "link";
				} else {
					_tmp7_ = "copy";
				}
				_tmp5_ = _tmp7_;
			}
			_tmp10_ = g_strdup (_tmp5_);
			prefix = _tmp10_;
			_tmp11_ = manager;
			_tmp12_ = _tmp11_->priv->files;
			_tmp13_ = prefix;
			files_dnd_handler_set_selection_data_as_file_list (sd, _tmp12_, _tmp13_);
			_g_free0 (prefix);
			break;
		}
		case FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_PNG_IMAGE:
		{
			FilesClipboardManager* _tmp14_;
			GList* _tmp15_;
			gchar* filename = NULL;
			FilesClipboardManager* _tmp16_;
			GList* _tmp17_;
			gconstpointer _tmp18_;
			GFile* _tmp19_;
			GFile* _tmp20_;
			gchar* _tmp21_;
			_tmp14_ = manager;
			_tmp15_ = _tmp14_->priv->files;
			if (_tmp15_ == NULL) {
				break;
			}
			_tmp16_ = manager;
			_tmp17_ = _tmp16_->priv->files;
			_tmp18_ = _tmp17_->data;
			_tmp19_ = files_file_get_location ((FilesFile*) _tmp18_);
			_tmp20_ = _tmp19_;
			_tmp21_ = g_file_get_path (_tmp20_);
			filename = _tmp21_;
			{
				GdkPixbuf* pixbuf = NULL;
				const gchar* _tmp22_;
				GdkPixbuf* _tmp23_;
				GdkPixbuf* _tmp24_;
				_tmp22_ = filename;
				_tmp23_ = gdk_pixbuf_new_from_file (_tmp22_, &_inner_error0_);
				pixbuf = _tmp23_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				_tmp24_ = pixbuf;
				gtk_selection_data_set_pixbuf (sd, _tmp24_);
				_g_object_unref0 (pixbuf);
			}
			goto __finally0;
			__catch0_g_error:
			{
				const gchar* _tmp25_;
				g_clear_error (&_inner_error0_);
				_tmp25_ = filename;
				g_warning ("ClipboardManager.vala:275: failed to get pixbuf from file %s ", _tmp25_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_free0 (filename);
				_g_object_unref0 (manager);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_free0 (filename);
			break;
		}
		case FILES_CLIPBOARD_MANAGER_CLIPBOARD_TARGET_UTF8_STRING:
		{
			FilesClipboardManager* _tmp26_;
			GList* _tmp27_;
			_tmp26_ = manager;
			_tmp27_ = _tmp26_->priv->files;
			files_dnd_handler_set_selection_data_as_text (sd, _tmp27_, "");
			break;
		}
		default:
		{
			break;
		}
	}
	_g_object_unref0 (manager);
}

void
files_clipboard_manager_clear_callback (GtkClipboard* cb,
                                        void* parent)
{
	FilesClipboardManager* manager = NULL;
	FilesClipboardManager* _tmp0_;
	gboolean _tmp1_ = FALSE;
	FilesClipboardManager* _tmp2_;
	FilesClipboardManager* _tmp5_;
	g_return_if_fail (cb != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (parent, FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager));
	manager = _tmp0_;
	_tmp2_ = manager;
	if (_tmp2_ == NULL) {
		_tmp1_ = TRUE;
	} else {
		FilesClipboardManager* _tmp3_;
		GtkClipboard* _tmp4_;
		_tmp3_ = manager;
		_tmp4_ = _tmp3_->priv->clipboard;
		_tmp1_ = _tmp4_ != cb;
	}
	if (_tmp1_) {
		_g_object_unref0 (manager);
		return;
	}
	_tmp5_ = manager;
	files_clipboard_manager_release_pending_files (_tmp5_);
	_g_object_unref0 (manager);
}

static void
files_clipboard_manager_release_pending_files (FilesClipboardManager* self)
{
	GList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->files;
	{
		GList* file_collection = NULL;
		GList* file_it = NULL;
		file_collection = _tmp0_;
		for (file_it = file_collection; file_it != NULL; file_it = file_it->next) {
			FilesFile* _tmp1_;
			FilesFile* file = NULL;
			_tmp1_ = _g_object_ref0 ((FilesFile*) file_it->data);
			file = _tmp1_;
			{
				FilesFile* _tmp2_;
				guint _tmp3_;
				_tmp2_ = file;
				g_signal_parse_name ("destroy", FILES_TYPE_FILE, &_tmp3_, NULL, FALSE);
				g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _files_clipboard_manager_on_file_destroyed_files_file_destroy, self);
				_g_object_unref0 (file);
			}
		}
	}
	(self->priv->files == NULL) ? NULL : (self->priv->files = (_g_list_free__g_object_unref0_ (self->priv->files), NULL));
	self->priv->files = NULL;
}

gboolean
files_clipboard_manager_get_files_linked (FilesClipboardManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_files_linked;
	return result;
}

static void
files_clipboard_manager_set_files_linked (FilesClipboardManager* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_clipboard_manager_get_files_linked (self);
	if (old_value != value) {
		self->priv->_files_linked = value;
		g_object_notify_by_pspec ((GObject *) self, files_clipboard_manager_properties[FILES_CLIPBOARD_MANAGER_FILES_LINKED_PROPERTY]);
	}
}

gboolean
files_clipboard_manager_get_can_paste (FilesClipboardManager* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_paste;
	return result;
}

static void
files_clipboard_manager_set_can_paste (FilesClipboardManager* self,
                                       gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = files_clipboard_manager_get_can_paste (self);
	if (old_value != value) {
		self->priv->_can_paste = value;
		g_object_notify_by_pspec ((GObject *) self, files_clipboard_manager_properties[FILES_CLIPBOARD_MANAGER_CAN_PASTE_PROPERTY]);
	}
}

static void
files_clipboard_manager_class_init (FilesClipboardManagerClass * klass,
                                    gpointer klass_data)
{
	files_clipboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesClipboardManager_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_clipboard_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_files_clipboard_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = files_clipboard_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_CLIPBOARD_MANAGER_FILES_LINKED_PROPERTY, files_clipboard_manager_properties[FILES_CLIPBOARD_MANAGER_FILES_LINKED_PROPERTY] = g_param_spec_boolean ("files-linked", "files-linked", "files-linked", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	/** Returns TRUE if the contents of the clipboard can be pasted into a folder.
	        **/
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_CLIPBOARD_MANAGER_CAN_PASTE_PROPERTY, files_clipboard_manager_properties[FILES_CLIPBOARD_MANAGER_CAN_PASTE_PROPERTY] = g_param_spec_boolean ("can-paste", "can-paste", "can-paste", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	files_clipboard_manager_signals[FILES_CLIPBOARD_MANAGER_CHANGED_SIGNAL] = g_signal_new ("changed", FILES_TYPE_CLIPBOARD_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	files_clipboard_manager_marlin_clipboard_manager_quark = g_quark_from_string ("marlin-clipboard-manager");
	files_clipboard_manager_x_special_gnome_copied_files = gdk_atom_intern_static_string ("x-special/gnome-copied-files");
}

static void
files_clipboard_manager_instance_init (FilesClipboardManager * self,
                                       gpointer klass)
{
	self->priv = files_clipboard_manager_get_instance_private (self);
	self->priv->files = NULL;
	self->priv->files_cutted = FALSE;
	self->priv->_files_linked = FALSE;
	self->priv->_can_paste = FALSE;
}

static void
files_clipboard_manager_finalize (GObject * obj)
{
	FilesClipboardManager * self;
	GtkClipboard* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager);
	files_clipboard_manager_release_pending_files (self);
	_tmp0_ = self->priv->clipboard;
	g_signal_parse_name ("owner-change", gtk_clipboard_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _files_clipboard_manager_owner_changed_gtk_clipboard_owner_change, self);
	_g_object_unref0 (self->priv->clipboard);
	(self->priv->files == NULL) ? NULL : (self->priv->files = (_g_list_free__g_object_unref0_ (self->priv->files), NULL));
	G_OBJECT_CLASS (files_clipboard_manager_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_clipboard_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesClipboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_clipboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesClipboardManager), 0, (GInstanceInitFunc) files_clipboard_manager_instance_init, NULL };
	GType files_clipboard_manager_type_id;
	files_clipboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "FilesClipboardManager", &g_define_type_info, 0);
	FilesClipboardManager_private_offset = g_type_add_instance_private (files_clipboard_manager_type_id, sizeof (FilesClipboardManagerPrivate));
	return files_clipboard_manager_type_id;
}

GType
files_clipboard_manager_get_type (void)
{
	static volatile gsize files_clipboard_manager_type_id__once = 0;
	if (g_once_init_enter (&files_clipboard_manager_type_id__once)) {
		GType files_clipboard_manager_type_id;
		files_clipboard_manager_type_id = files_clipboard_manager_get_type_once ();
		g_once_init_leave (&files_clipboard_manager_type_id__once, files_clipboard_manager_type_id);
	}
	return files_clipboard_manager_type_id__once;
}

static void
_vala_files_clipboard_manager_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec)
{
	FilesClipboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager);
	switch (property_id) {
		case FILES_CLIPBOARD_MANAGER_FILES_LINKED_PROPERTY:
		g_value_set_boolean (value, files_clipboard_manager_get_files_linked (self));
		break;
		case FILES_CLIPBOARD_MANAGER_CAN_PASTE_PROPERTY:
		g_value_set_boolean (value, files_clipboard_manager_get_can_paste (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_files_clipboard_manager_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec)
{
	FilesClipboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_CLIPBOARD_MANAGER, FilesClipboardManager);
	switch (property_id) {
		case FILES_CLIPBOARD_MANAGER_FILES_LINKED_PROPERTY:
		files_clipboard_manager_set_files_linked (self, g_value_get_boolean (value));
		break;
		case FILES_CLIPBOARD_MANAGER_CAN_PASTE_PROPERTY:
		files_clipboard_manager_set_can_paste (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

