/* utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from utils.vala, do not modify */

/*      utils.vala*/
/*      */
/*      Copyright 2011 Hong Jen Yee (PCMan) <pcman.tw@pcman.tw@gmail.com>*/
/*      */
/*      This program is free software; you can redistribute it and/or modify*/
/*      it under the terms of the GNU General Public License as published by*/
/*      the Free Software Foundation; either version 2 of the License, or*/
/*      (at your option) any later version.*/
/*      */
/*      This program is distributed in the hope that it will be useful,*/
/*      but WITHOUT ANY WARRANTY; without even the implied warranty of*/
/*      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the*/
/*      GNU General Public License for more details.*/
/*      */
/*      You should have received a copy of the GNU General Public License*/
/*      along with this program; if not, write to the Free Software*/
/*      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,*/
/*      MA 02110-1301, USA.*/
/*      */
/*      */

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "fm-actions.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

VALA_EXTERN gchar* utils_key_file_get_string (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  const gchar* def_val);
VALA_EXTERN gchar** utils_key_file_get_string_list (GKeyFile* kf,
                                        const gchar* group,
                                        const gchar* key,
                                        gchar** def_val,
                                        gint def_val_length1,
                                        gint* result_length1);
static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
VALA_EXTERN gchar* utils_key_file_get_locale_string (GKeyFile* kf,
                                         const gchar* group,
                                         const gchar* key,
                                         const gchar* def_val);
VALA_EXTERN gboolean utils_key_file_get_bool (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  gboolean def_val);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

gchar*
utils_key_file_get_string (GKeyFile* kf,
                           const gchar* group,
                           const gchar* key,
                           const gchar* def_val)
{
	gchar* val = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_string (kf, group, key, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (val);
		val = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_strdup (def_val);
		_g_free0 (val);
		val = _tmp3_;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = val;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

gchar**
utils_key_file_get_string_list (GKeyFile* kf,
                                const gchar* group,
                                const gchar* key,
                                gchar** def_val,
                                gint def_val_length1,
                                gint* result_length1)
{
	gchar** val = NULL;
	gint val_length1 = 0;
	gint _val_size_ = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	GError* _inner_error0_ = NULL;
	gchar** result;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar** _tmp0_ = NULL;
		gsize _tmp1_ = 0;
		gchar** _tmp2_;
		gint _tmp0__length1;
		gint __tmp0__size_;
		gchar** _tmp3_;
		gint _tmp3__length1;
		_tmp2_ = g_key_file_get_string_list (kf, group, key, &_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		_tmp0__length1 = _tmp1_;
		__tmp0__size_ = _tmp0__length1;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp3_ = _tmp0_;
		_tmp3__length1 = _tmp0__length1;
		_tmp0_ = NULL;
		_tmp0__length1 = 0;
		val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
		val = _tmp3_;
		val_length1 = _tmp3__length1;
		_val_size_ = val_length1;
		_tmp0_ = (_vala_array_free (_tmp0_, _tmp0__length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		gchar** _tmp4_;
		gint _tmp4__length1;
		g_clear_error (&_inner_error0_);
		_tmp4_ = (def_val != NULL) ? _vala_array_dup1 (def_val, def_val_length1) : def_val;
		_tmp4__length1 = def_val_length1;
		val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
		val = _tmp4_;
		val_length1 = _tmp4__length1;
		_val_size_ = val_length1;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		val = (_vala_array_free (val, val_length1, (GDestroyNotify) g_free), NULL);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	_tmp5_ = val;
	_tmp5__length1 = val_length1;
	if (result_length1) {
		*result_length1 = _tmp5__length1;
	}
	result = _tmp5_;
	return result;
}

gchar*
utils_key_file_get_locale_string (GKeyFile* kf,
                                  const gchar* group,
                                  const gchar* key,
                                  const gchar* def_val)
{
	gchar* val = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (kf != NULL, NULL);
	g_return_val_if_fail (group != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_key_file_get_locale_string (kf, group, key, NULL, &_inner_error0_);
		_tmp0_ = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			_g_free0 (val);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp2_ = _tmp0_;
		_tmp0_ = NULL;
		_g_free0 (val);
		val = _tmp2_;
		_g_free0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		gchar* _tmp3_;
		g_clear_error (&_inner_error0_);
		_tmp3_ = g_strdup (def_val);
		_g_free0 (val);
		val = _tmp3_;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (val);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = val;
	return result;
}

gboolean
utils_key_file_get_bool (GKeyFile* kf,
                         const gchar* group,
                         const gchar* key,
                         gboolean def_val)
{
	gboolean val = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (kf != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	g_return_val_if_fail (key != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = g_key_file_get_boolean (kf, group, key, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_KEY_FILE_ERROR) {
				goto __catch0_g_key_file_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
		val = _tmp0_;
	}
	goto __finally0;
	__catch0_g_key_file_error:
	{
		g_clear_error (&_inner_error0_);
		val = def_val;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	result = val;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

