/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the PPC target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 41;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(PPCInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(PPCInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static PPCInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static PPCInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s32,
  GILLT_s64,
  GILLT_s128,
  GILLT_v2s64,
  GILLT_v4s32,
  GILLT_v8s16,
  GILLT_v16s8,
  GILLT_v256s1,
  GILLT_v512s1,
  GILLT_v1024s1,
  GILLT_v2048s1,
};
const static size_t NumTypeObjects = 12;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(256), 1),
  LLT::vector(ElementCount::getFixed(512), 1),
  LLT::vector(ElementCount::getFixed(1024), 1),
  LLT::vector(ElementCount::getFixed(2048), 1),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_In32BitModeBit = 1,
  Feature_In64BitModeBit = 9,
  Feature_HasOnlyMSYNCBit = 23,
  Feature_HasSYNCBit = 22,
  Feature_HasSPEBit = 8,
  Feature_HasICBTBit = 21,
  Feature_HasBPERMDBit = 10,
  Feature_HasExtDivBit = 3,
  Feature_IsISA2_06Bit = 11,
  Feature_IsISA2_07Bit = 40,
  Feature_IsISA3_0Bit = 2,
  Feature_HasFPUBit = 0,
  Feature_PCRelativeMemopsBit = 37,
  Feature_IsNotISA3_1Bit = 39,
  Feature_IsAIXBit = 24,
  Feature_NotAIXBit = 25,
  Feature_IsISAFutureBit = 18,
  Feature_IsNotISAFutureBit = 19,
  Feature_HasAltivecBit = 4,
  Feature_HasP8AltivecBit = 5,
  Feature_HasP8CryptoBit = 6,
  Feature_HasP9AltivecBit = 7,
  Feature_HasVSXBit = 12,
  Feature_IsLittleEndianBit = 26,
  Feature_IsBigEndianBit = 27,
  Feature_IsPPC64Bit = 31,
  Feature_HasOnlySwappingMemOpsBit = 29,
  Feature_NoP8VectorBit = 30,
  Feature_HasP8VectorBit = 13,
  Feature_HasDirectMoveBit = 14,
  Feature_NoP9VectorBit = 28,
  Feature_HasP9VectorBit = 15,
  Feature_NoP9AltivecBit = 32,
  Feature_NoP10VectorBit = 33,
  Feature_HasP10VectorBit = 36,
  Feature_HasHTMBit = 34,
  Feature_MMABit = 20,
  Feature_IsPPC32Bit = 38,
  Feature_PrefixInstrsBit = 16,
  Feature_IsISA3_1Bit = 17,
  Feature_PairedVectorMemopsBit = 35,
};

PredicateBitset PPCInstructionSelector::
computeAvailableModuleFeatures(const PPCSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (!Subtarget->isPPC64())
    Features.set(Feature_In32BitModeBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasOnlyMSYNCBit);
  if (!Subtarget->hasOnlyMSYNC())
    Features.set(Feature_HasSYNCBit);
  if (Subtarget->hasSPE())
    Features.set(Feature_HasSPEBit);
  if (Subtarget->hasICBT())
    Features.set(Feature_HasICBTBit);
  if (Subtarget->hasBPERMD())
    Features.set(Feature_HasBPERMDBit);
  if (Subtarget->hasExtDiv())
    Features.set(Feature_HasExtDivBit);
  if (Subtarget->isISA2_06())
    Features.set(Feature_IsISA2_06Bit);
  if (Subtarget->isISA2_07())
    Features.set(Feature_IsISA2_07Bit);
  if (Subtarget->isISA3_0())
    Features.set(Feature_IsISA3_0Bit);
  if (Subtarget->hasFPU())
    Features.set(Feature_HasFPUBit);
  if (Subtarget->hasPCRelativeMemops())
    Features.set(Feature_PCRelativeMemopsBit);
  if (!Subtarget->isISA3_1())
    Features.set(Feature_IsNotISA3_1Bit);
  if (Subtarget->isAIXABI())
    Features.set(Feature_IsAIXBit);
  if (!Subtarget->isAIXABI())
    Features.set(Feature_NotAIXBit);
  if (Subtarget->isISAFuture())
    Features.set(Feature_IsISAFutureBit);
  if (!Subtarget->isISAFuture())
    Features.set(Feature_IsNotISAFutureBit);
  if (Subtarget->hasAltivec())
    Features.set(Feature_HasAltivecBit);
  if (Subtarget->hasP8Altivec())
    Features.set(Feature_HasP8AltivecBit);
  if (Subtarget->hasP8Crypto())
    Features.set(Feature_HasP8CryptoBit);
  if (Subtarget->hasP9Altivec())
    Features.set(Feature_HasP9AltivecBit);
  if (Subtarget->hasVSX())
    Features.set(Feature_HasVSXBit);
  if (Subtarget->isLittleEndian())
    Features.set(Feature_IsLittleEndianBit);
  if (!Subtarget->isLittleEndian())
    Features.set(Feature_IsBigEndianBit);
  if (Subtarget->isPPC64())
    Features.set(Feature_IsPPC64Bit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_HasOnlySwappingMemOpsBit);
  if (!Subtarget->hasP8Vector())
    Features.set(Feature_NoP8VectorBit);
  if (Subtarget->hasP8Vector())
    Features.set(Feature_HasP8VectorBit);
  if (Subtarget->hasDirectMove())
    Features.set(Feature_HasDirectMoveBit);
  if (!Subtarget->hasP9Vector())
    Features.set(Feature_NoP9VectorBit);
  if (Subtarget->hasP9Vector())
    Features.set(Feature_HasP9VectorBit);
  if (!Subtarget->hasP9Altivec())
    Features.set(Feature_NoP9AltivecBit);
  if (!Subtarget->hasP10Vector())
    Features.set(Feature_NoP10VectorBit);
  if (Subtarget->hasP10Vector())
    Features.set(Feature_HasP10VectorBit);
  if (Subtarget->hasHTM())
    Features.set(Feature_HasHTMBit);
  if (Subtarget->hasMMA())
    Features.set(Feature_MMABit);
  if (!Subtarget->isPPC64())
    Features.set(Feature_IsPPC32Bit);
  if (Subtarget->hasPrefixInstrs())
    Features.set(Feature_PrefixInstrsBit);
  if (Subtarget->isISA3_1())
    Features.set(Feature_IsISA3_1Bit);
  if (Subtarget->pairedVectorMemops())
    Features.set(Feature_PairedVectorMemopsBit);
  return Features;
}

void PPCInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const PPCSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset PPCInstructionSelector::
computeAvailableFunctionFeatures(const PPCSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasAltivec,
  GIFBS_HasBPERMD,
  GIFBS_HasExtDiv,
  GIFBS_HasFPU,
  GIFBS_HasHTM,
  GIFBS_HasOnlyMSYNC,
  GIFBS_HasP8Altivec,
  GIFBS_HasP8Crypto,
  GIFBS_HasP9Altivec,
  GIFBS_HasSPE,
  GIFBS_HasSYNC,
  GIFBS_HasVSX,
  GIFBS_In32BitMode,
  GIFBS_In64BitMode,
  GIFBS_IsAIX,
  GIFBS_IsISA3_0,
  GIFBS_IsISA3_1,
  GIFBS_IsISAFuture,
  GIFBS_IsNotISA3_1,
  GIFBS_NotAIX,
  GIFBS_PairedVectorMemops,
  GIFBS_HasDirectMove_HasVSX,
  GIFBS_HasFPU_IsISA3_1,
  GIFBS_HasP10Vector_PrefixInstrs,
  GIFBS_HasP8Altivec_HasVSX,
  GIFBS_HasP8Vector_HasVSX,
  GIFBS_HasP9Vector_HasVSX,
  GIFBS_HasVSX_IsISA3_1,
  GIFBS_In64BitMode_IsISA3_0,
  GIFBS_IsISAFuture_MMA,
  GIFBS_IsNotISAFuture_MMA,
  GIFBS_HasP8Altivec_HasVSX_IsBigEndian,
  GIFBS_HasP8Altivec_HasVSX_IsLittleEndian,
  GIFBS_IsISAFuture_MMA_PrefixInstrs,
  GIFBS_IsNotISAFuture_MMA_PrefixInstrs,
  GIFBS_HasDirectMove_HasVSX_IsISA3_0_IsLittleEndian,
  GIFBS_HasDirectMove_HasVSX_IsLittleEndian_NoP9Vector,
  GIFBS_HasVSX_IsBigEndian_IsISA3_1_IsPPC32,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsISA3_0_IsPPC64,
  GIFBS_HasDirectMove_HasVSX_IsBigEndian_IsPPC64_NoP9Vector,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasAltivecBit, },
  {Feature_HasBPERMDBit, },
  {Feature_HasExtDivBit, },
  {Feature_HasFPUBit, },
  {Feature_HasHTMBit, },
  {Feature_HasOnlyMSYNCBit, },
  {Feature_HasP8AltivecBit, },
  {Feature_HasP8CryptoBit, },
  {Feature_HasP9AltivecBit, },
  {Feature_HasSPEBit, },
  {Feature_HasSYNCBit, },
  {Feature_HasVSXBit, },
  {Feature_In32BitModeBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsAIXBit, },
  {Feature_IsISA3_0Bit, },
  {Feature_IsISA3_1Bit, },
  {Feature_IsISAFutureBit, },
  {Feature_IsNotISA3_1Bit, },
  {Feature_NotAIXBit, },
  {Feature_PairedVectorMemopsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, },
  {Feature_HasFPUBit, Feature_IsISA3_1Bit, },
  {Feature_HasP10VectorBit, Feature_PrefixInstrsBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, },
  {Feature_HasP8VectorBit, Feature_HasVSXBit, },
  {Feature_HasP9VectorBit, Feature_HasVSXBit, },
  {Feature_HasVSXBit, Feature_IsISA3_1Bit, },
  {Feature_In64BitModeBit, Feature_IsISA3_0Bit, },
  {Feature_IsISAFutureBit, Feature_MMABit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsBigEndianBit, },
  {Feature_HasP8AltivecBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, },
  {Feature_IsISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_IsNotISAFutureBit, Feature_MMABit, Feature_PrefixInstrsBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsISA3_0Bit, Feature_IsLittleEndianBit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsLittleEndianBit, Feature_NoP9VectorBit, },
  {Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_1Bit, Feature_IsPPC32Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsISA3_0Bit, Feature_IsPPC64Bit, },
  {Feature_HasDirectMoveBit, Feature_HasVSXBit, Feature_IsBigEndianBit, Feature_IsPPC64Bit, Feature_NoP9VectorBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

PPCInstructionSelector::ComplexMatcherMemFn
PPCInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_or_disjoint = GICXXPred_Invalid + 1,
};
bool PPCInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_Msk2Imm = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_Msk4Imm,
  GICXXPred_I64_Predicate_Msk8Imm,
  GICXXPred_I64_Predicate_i32immNonAllOneNonZero,
  GICXXPred_I64_Predicate_imm32SExt16,
  GICXXPred_I64_Predicate_imm64SExt16,
  GICXXPred_I64_Predicate_imm64ZExt32,
  GICXXPred_I64_Predicate_immNonAllOneAnyExt8,
  GICXXPred_I64_Predicate_immSExt5NonZero,
};
bool PPCInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_Msk2Imm: {
     return isUInt<2>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk4Imm: {
     return isUInt<4>(Imm); 
  }
  case GICXXPred_I64_Predicate_Msk8Imm: {
     return isUInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immNonAllOneNonZero: {
     return Imm && (Imm != -1); 
  }
  case GICXXPred_I64_Predicate_imm32SExt16: {
    
      // imm32SExt16 predicate - True if the i32 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int32_t)Imm == (short)Imm;
    
    llvm_unreachable("imm32SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64SExt16: {
    
      // imm64SExt16 predicate - True if the i64 immediate fits in a 16-bit
      // sign extended field.  Used by instructions like 'addi'.
      return (int64_t)Imm == (short)Imm;
    
    llvm_unreachable("imm64SExt16 should have returned");
  }
  case GICXXPred_I64_Predicate_imm64ZExt32: {
    
      // imm64ZExt32 predicate - True if the i64 immediate fits in a 32-bit
      // zero extended field.
      return isUInt<32>(Imm);
    
    llvm_unreachable("imm64ZExt32 should have returned");
  }
  case GICXXPred_I64_Predicate_immNonAllOneAnyExt8: {
    
      return (isInt<8>(Imm) && (Imm != -1)) || (isUInt<8>(Imm) && (Imm != 0xFF));
    
  }
  case GICXXPred_I64_Predicate_immSExt5NonZero: {
     return Imm && isInt<5>(Imm); 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool PPCInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool PPCInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("PPCInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
PPCInstructionSelector::CustomRendererFn
PPCInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool PPCInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool PPCInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("PPCInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *PPCInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*      0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(293), /*)*//*default:*//*Label 83*/ GIMT_Encode4(211489),
     /*     10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(970),
     /*     14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(1379),
     /*     18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(1820),
     /*     22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(2102),
     /*     26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(2258),
     /*     30 */ /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(2414),
     /*     34 */ /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(2576), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     46 */ /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(2738),
     /*     50 */ /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(5299),
     /*     54 */ /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(48441), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    106 */ /*TargetOpcode::G_BUILD_VECTOR*//*Label 10*/ GIMT_Encode4(57548), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    126 */ /*TargetOpcode::G_BITCAST*//*Label 11*/ GIMT_Encode4(58515), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 12*/ GIMT_Encode4(60792),
     /*    146 */ /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 13*/ GIMT_Encode4(61067),
     /*    150 */ /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 14*/ GIMT_Encode4(61317),
     /*    154 */ /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 15*/ GIMT_Encode4(61448), GIMT_Encode4(0),
     /*    162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 16*/ GIMT_Encode4(61579), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    294 */ /*TargetOpcode::G_FENCE*//*Label 17*/ GIMT_Encode4(61599), GIMT_Encode4(0),
     /*    302 */ /*TargetOpcode::G_BRCOND*//*Label 18*/ GIMT_Encode4(61724), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    314 */ /*TargetOpcode::G_INTRINSIC*//*Label 19*/ GIMT_Encode4(61787),
     /*    318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 20*/ GIMT_Encode4(91215), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    330 */ /*TargetOpcode::G_ANYEXT*//*Label 21*/ GIMT_Encode4(94107),
     /*    334 */ /*TargetOpcode::G_TRUNC*//*Label 22*/ GIMT_Encode4(114863), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    350 */ /*TargetOpcode::G_CONSTANT*//*Label 23*/ GIMT_Encode4(115049), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    366 */ /*TargetOpcode::G_SEXT*//*Label 24*/ GIMT_Encode4(115201),
     /*    370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 25*/ GIMT_Encode4(130233),
     /*    374 */ /*TargetOpcode::G_ZEXT*//*Label 26*/ GIMT_Encode4(130586),
     /*    378 */ /*TargetOpcode::G_SHL*//*Label 27*/ GIMT_Encode4(152056),
     /*    382 */ /*TargetOpcode::G_LSHR*//*Label 28*/ GIMT_Encode4(152412),
     /*    386 */ /*TargetOpcode::G_ASHR*//*Label 29*/ GIMT_Encode4(152834), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    402 */ /*TargetOpcode::G_ROTL*//*Label 30*/ GIMT_Encode4(153204),
     /*    406 */ /*TargetOpcode::G_ICMP*//*Label 31*/ GIMT_Encode4(153512),
     /*    410 */ /*TargetOpcode::G_FCMP*//*Label 32*/ GIMT_Encode4(157514), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    422 */ /*TargetOpcode::G_SELECT*//*Label 33*/ GIMT_Encode4(160965), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    466 */ /*TargetOpcode::G_UMULH*//*Label 34*/ GIMT_Encode4(162089),
     /*    470 */ /*TargetOpcode::G_SMULH*//*Label 35*/ GIMT_Encode4(162219),
     /*    474 */ /*TargetOpcode::G_UADDSAT*//*Label 36*/ GIMT_Encode4(162349),
     /*    478 */ /*TargetOpcode::G_SADDSAT*//*Label 37*/ GIMT_Encode4(162451),
     /*    482 */ /*TargetOpcode::G_USUBSAT*//*Label 38*/ GIMT_Encode4(162553),
     /*    486 */ /*TargetOpcode::G_SSUBSAT*//*Label 39*/ GIMT_Encode4(162655), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    530 */ /*TargetOpcode::G_FADD*//*Label 40*/ GIMT_Encode4(162757),
     /*    534 */ /*TargetOpcode::G_FSUB*//*Label 41*/ GIMT_Encode4(163052),
     /*    538 */ /*TargetOpcode::G_FMUL*//*Label 42*/ GIMT_Encode4(163347),
     /*    542 */ /*TargetOpcode::G_FMA*//*Label 43*/ GIMT_Encode4(163697), GIMT_Encode4(0),
     /*    550 */ /*TargetOpcode::G_FDIV*//*Label 44*/ GIMT_Encode4(164278), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    598 */ /*TargetOpcode::G_FNEG*//*Label 45*/ GIMT_Encode4(164548),
     /*    602 */ /*TargetOpcode::G_FPEXT*//*Label 46*/ GIMT_Encode4(167019),
     /*    606 */ /*TargetOpcode::G_FPTRUNC*//*Label 47*/ GIMT_Encode4(167183),
     /*    610 */ /*TargetOpcode::G_FPTOSI*//*Label 48*/ GIMT_Encode4(167340),
     /*    614 */ /*TargetOpcode::G_FPTOUI*//*Label 49*/ GIMT_Encode4(167603),
     /*    618 */ /*TargetOpcode::G_SITOFP*//*Label 50*/ GIMT_Encode4(167866),
     /*    622 */ /*TargetOpcode::G_UITOFP*//*Label 51*/ GIMT_Encode4(168113), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    634 */ /*TargetOpcode::G_FABS*//*Label 52*/ GIMT_Encode4(168360),
     /*    638 */ /*TargetOpcode::G_FCOPYSIGN*//*Label 53*/ GIMT_Encode4(168652), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    650 */ /*TargetOpcode::G_FMINNUM*//*Label 54*/ GIMT_Encode4(168968),
     /*    654 */ /*TargetOpcode::G_FMAXNUM*//*Label 55*/ GIMT_Encode4(169048),
     /*    658 */ /*TargetOpcode::G_FMINNUM_IEEE*//*Label 56*/ GIMT_Encode4(169128),
     /*    662 */ /*TargetOpcode::G_FMAXNUM_IEEE*//*Label 57*/ GIMT_Encode4(169710), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    718 */ /*TargetOpcode::G_SMIN*//*Label 58*/ GIMT_Encode4(170292),
     /*    722 */ /*TargetOpcode::G_SMAX*//*Label 59*/ GIMT_Encode4(170472),
     /*    726 */ /*TargetOpcode::G_UMIN*//*Label 60*/ GIMT_Encode4(170652),
     /*    730 */ /*TargetOpcode::G_UMAX*//*Label 61*/ GIMT_Encode4(170832), GIMT_Encode4(0),
     /*    738 */ /*TargetOpcode::G_LROUND*//*Label 62*/ GIMT_Encode4(171012),
     /*    742 */ /*TargetOpcode::G_LLROUND*//*Label 63*/ GIMT_Encode4(171314),
     /*    746 */ /*TargetOpcode::G_BR*//*Label 64*/ GIMT_Encode4(171479), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    766 */ /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 65*/ GIMT_Encode4(171495), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    790 */ /*TargetOpcode::G_CTTZ*//*Label 66*/ GIMT_Encode4(171613), GIMT_Encode4(0),
     /*    798 */ /*TargetOpcode::G_CTLZ*//*Label 67*/ GIMT_Encode4(171791), GIMT_Encode4(0),
     /*    806 */ /*TargetOpcode::G_CTPOP*//*Label 68*/ GIMT_Encode4(171963),
     /*    810 */ /*TargetOpcode::G_BSWAP*//*Label 69*/ GIMT_Encode4(172135),
     /*    814 */ /*TargetOpcode::G_BITREVERSE*//*Label 70*/ GIMT_Encode4(172399),
     /*    818 */ /*TargetOpcode::G_FCEIL*//*Label 71*/ GIMT_Encode4(208405), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    866 */ /*TargetOpcode::G_FSQRT*//*Label 72*/ GIMT_Encode4(208680),
     /*    870 */ /*TargetOpcode::G_FFLOOR*//*Label 73*/ GIMT_Encode4(208897),
     /*    874 */ /*TargetOpcode::G_FRINT*//*Label 74*/ GIMT_Encode4(209172),
     /*    878 */ /*TargetOpcode::G_FNEARBYINT*//*Label 75*/ GIMT_Encode4(209384), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 76*/ GIMT_Encode4(209621),
     /*    910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 77*/ GIMT_Encode4(209891),
     /*    914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 78*/ GIMT_Encode4(210161),
     /*    918 */ /*TargetOpcode::G_STRICT_FDIV*//*Label 79*/ GIMT_Encode4(210431), GIMT_Encode4(0),
     /*    926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 80*/ GIMT_Encode4(210701),
     /*    930 */ /*TargetOpcode::G_STRICT_FSQRT*//*Label 81*/ GIMT_Encode4(211259), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    966 */ /*TargetOpcode::G_TRAP*//*Label 82*/ GIMT_Encode4(211476),
     /*    970 */ // Label 0: @970
     /*    970 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 92*/ GIMT_Encode4(1378),
     /*    981 */ /*GILLT_s1*//*Label 84*/ GIMT_Encode4(1013),
     /*    985 */ /*GILLT_s32*//*Label 85*/ GIMT_Encode4(1036),
     /*    989 */ /*GILLT_s64*//*Label 86*/ GIMT_Encode4(1096),
     /*    993 */ /*GILLT_s128*//*Label 87*/ GIMT_Encode4(1156),
     /*    997 */ /*GILLT_v2s64*//*Label 88*/ GIMT_Encode4(1182),
     /*   1001 */ /*GILLT_v4s32*//*Label 89*/ GIMT_Encode4(1208),
     /*   1005 */ /*GILLT_v8s16*//*Label 90*/ GIMT_Encode4(1234),
     /*   1009 */ /*GILLT_v16s8*//*Label 91*/ GIMT_Encode4(1352),
     /*   1013 */ // Label 84: @1013
     /*   1013 */ GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1035), // Rule ID 3669 //
     /*   1018 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*   1021 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*   1024 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
     /*   1028 */   // (add:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
     /*   1028 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
     /*   1033 */   GIR_RootConstrainSelectedInstOperands,
     /*   1034 */   // GIR_Coverage, 3669,
     /*   1034 */   GIR_Done,
     /*   1035 */ // Label 93: @1035
     /*   1035 */ GIM_Reject,
     /*   1036 */ // Label 85: @1036
     /*   1036 */ GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1095),
     /*   1041 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   1044 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   1047 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   1051 */   GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1082), // Rule ID 107 //
     /*   1056 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1060 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1064 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
     /*   1068 */     // MIs[1] Operand 1
     /*   1068 */     // No operand predicates
     /*   1068 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1070 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (ADDI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
     /*   1070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ADDI),
     /*   1073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
     /*   1075 */     GIR_RootToRootCopy, /*OpIdx*/1, // RA
     /*   1077 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
     /*   1080 */     GIR_RootConstrainSelectedInstOperands,
     /*   1081 */     // GIR_Coverage, 107,
     /*   1081 */     GIR_EraseRootFromParent_Done,
     /*   1082 */   // Label 95: @1082
     /*   1082 */   GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1094), // Rule ID 199 //
     /*   1087 */     // (add:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (ADD4:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   1087 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD4),
     /*   1092 */     GIR_RootConstrainSelectedInstOperands,
     /*   1093 */     // GIR_Coverage, 199,
     /*   1093 */     GIR_Done,
     /*   1094 */   // Label 96: @1094
     /*   1094 */   GIM_Reject,
     /*   1095 */ // Label 94: @1095
     /*   1095 */ GIM_Reject,
     /*   1096 */ // Label 86: @1096
     /*   1096 */ GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1155),
     /*   1101 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   1104 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   1107 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   1111 */   GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1142), // Rule ID 663 //
     /*   1116 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1120 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1124 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
     /*   1128 */     // MIs[1] Operand 1
     /*   1128 */     // No operand predicates
     /*   1128 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1130 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (ADDI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
     /*   1130 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ADDI8),
     /*   1133 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
     /*   1135 */     GIR_RootToRootCopy, /*OpIdx*/1, // RA
     /*   1137 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
     /*   1140 */     GIR_RootConstrainSelectedInstOperands,
     /*   1141 */     // GIR_Coverage, 663,
     /*   1141 */     GIR_EraseRootFromParent_Done,
     /*   1142 */   // Label 98: @1142
     /*   1142 */   GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1154), // Rule ID 659 //
     /*   1147 */     // (add:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (ADD8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   1147 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::ADD8),
     /*   1152 */     GIR_RootConstrainSelectedInstOperands,
     /*   1153 */     // GIR_Coverage, 659,
     /*   1153 */     GIR_Done,
     /*   1154 */   // Label 99: @1154
     /*   1154 */   GIM_Reject,
     /*   1155 */ // Label 97: @1155
     /*   1155 */ GIM_Reject,
     /*   1156 */ // Label 87: @1156
     /*   1156 */ GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1181), // Rule ID 470 //
     /*   1161 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
     /*   1164 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
     /*   1167 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
     /*   1170 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1174 */   // (add:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VADDUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
     /*   1174 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUQM),
     /*   1179 */   GIR_RootConstrainSelectedInstOperands,
     /*   1180 */   // GIR_Coverage, 470,
     /*   1180 */   GIR_Done,
     /*   1181 */ // Label 100: @1181
     /*   1181 */ GIM_Reject,
     /*   1182 */ // Label 88: @1182
     /*   1182 */ GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1207), // Rule ID 469 //
     /*   1187 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
     /*   1190 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   1193 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   1196 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1200 */   // (add:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VADDUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   1200 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUDM),
     /*   1205 */   GIR_RootConstrainSelectedInstOperands,
     /*   1206 */   // GIR_Coverage, 469,
     /*   1206 */   GIR_Done,
     /*   1207 */ // Label 101: @1207
     /*   1207 */ GIM_Reject,
     /*   1208 */ // Label 89: @1208
     /*   1208 */ GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1233), // Rule ID 303 //
     /*   1213 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1216 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   1219 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   1222 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1226 */   // (add:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VADDUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   1226 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUWM),
     /*   1231 */   GIR_RootConstrainSelectedInstOperands,
     /*   1232 */   // GIR_Coverage, 303,
     /*   1232 */   GIR_Done,
     /*   1233 */ // Label 102: @1233
     /*   1233 */ GIM_Reject,
     /*   1234 */ // Label 90: @1234
     /*   1234 */ GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1351),
     /*   1239 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   1242 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   1245 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1249 */   GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1292), // Rule ID 1296 //
     /*   1254 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1257 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1261 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   1265 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   1269 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   1273 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1275 */     // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB), v8i16:{ *:[v8i16] }:$vC)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, ?:{ *:[v8i16] }:$vC)
     /*   1275 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
     /*   1278 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   1280 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*   1284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   1288 */     GIR_RootToRootCopy, /*OpIdx*/2, // vC
     /*   1290 */     GIR_RootConstrainSelectedInstOperands,
     /*   1291 */     // GIR_Coverage, 1296,
     /*   1291 */     GIR_EraseRootFromParent_Done,
     /*   1292 */   // Label 104: @1292
     /*   1292 */   GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1335), // Rule ID 4947 //
     /*   1297 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1300 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1304 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   1308 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   1312 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   1316 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1318 */     // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vC, (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB))  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, ?:{ *:[v8i16] }:$vC)
     /*   1318 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
     /*   1321 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   1323 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*   1327 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   1331 */     GIR_RootToRootCopy, /*OpIdx*/1, // vC
     /*   1333 */     GIR_RootConstrainSelectedInstOperands,
     /*   1334 */     // GIR_Coverage, 4947,
     /*   1334 */     GIR_EraseRootFromParent_Done,
     /*   1335 */   // Label 105: @1335
     /*   1335 */   GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1350), // Rule ID 302 //
     /*   1340 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1343 */     // (add:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VADDUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
     /*   1343 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUHM),
     /*   1348 */     GIR_RootConstrainSelectedInstOperands,
     /*   1349 */     // GIR_Coverage, 302,
     /*   1349 */     GIR_Done,
     /*   1350 */   // Label 106: @1350
     /*   1350 */   GIM_Reject,
     /*   1351 */ // Label 103: @1351
     /*   1351 */ GIM_Reject,
     /*   1352 */ // Label 91: @1352
     /*   1352 */ GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1377), // Rule ID 301 //
     /*   1357 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1360 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   1363 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*   1366 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1370 */   // (add:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VADDUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
     /*   1370 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VADDUBM),
     /*   1375 */   GIR_RootConstrainSelectedInstOperands,
     /*   1376 */   // GIR_Coverage, 301,
     /*   1376 */   GIR_Done,
     /*   1377 */ // Label 107: @1377
     /*   1377 */ GIM_Reject,
     /*   1378 */ // Label 92: @1378
     /*   1378 */ GIM_Reject,
     /*   1379 */ // Label 1: @1379
     /*   1379 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(8), /*)*//*default:*//*Label 116*/ GIMT_Encode4(1819),
     /*   1390 */ /*GILLT_s1*//*Label 108*/ GIMT_Encode4(1422),
     /*   1394 */ /*GILLT_s32*//*Label 109*/ GIMT_Encode4(1445),
     /*   1398 */ /*GILLT_s64*//*Label 110*/ GIMT_Encode4(1530),
     /*   1402 */ /*GILLT_s128*//*Label 111*/ GIMT_Encode4(1615),
     /*   1406 */ /*GILLT_v2s64*//*Label 112*/ GIMT_Encode4(1641),
     /*   1410 */ /*GILLT_v4s32*//*Label 113*/ GIMT_Encode4(1704),
     /*   1414 */ /*GILLT_v8s16*//*Label 114*/ GIMT_Encode4(1767),
     /*   1418 */ /*GILLT_v16s8*//*Label 115*/ GIMT_Encode4(1793),
     /*   1422 */ // Label 108: @1422
     /*   1422 */ GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1444), // Rule ID 3670 //
     /*   1427 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*   1430 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*   1433 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
     /*   1437 */   // (sub:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRXOR:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
     /*   1437 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRXOR),
     /*   1442 */   GIR_RootConstrainSelectedInstOperands,
     /*   1443 */   // GIR_Coverage, 3670,
     /*   1443 */   GIR_Done,
     /*   1444 */ // Label 117: @1444
     /*   1444 */ GIM_Reject,
     /*   1445 */ // Label 109: @1445
     /*   1445 */ GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1529),
     /*   1450 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   1453 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   1456 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   1460 */   GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(1478), // Rule ID 211 //
     /*   1465 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   1469 */     // (sub:{ *:[i32] } 0:{ *:[i32] }, i32:{ *:[i32] }:$RA)  =>  (NEG:{ *:[i32] } i32:{ *:[i32] }:$RA)
     /*   1469 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NEG),
     /*   1472 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   1474 */     GIR_RootToRootCopy, /*OpIdx*/2, // RA
     /*   1476 */     GIR_RootConstrainSelectedInstOperands,
     /*   1477 */     // GIR_Coverage, 211,
     /*   1477 */     GIR_EraseRootFromParent_Done,
     /*   1478 */   // Label 119: @1478
     /*   1478 */   GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1512), // Rule ID 1217 //
     /*   1483 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1487 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1491 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
     /*   1495 */     // MIs[1] Operand 1
     /*   1495 */     // No operand predicates
     /*   1495 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1497 */     // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$imm, i32:{ *:[i32] }:$in)  =>  (SUBFIC:{ *:[i32] }:{ *:[i32] } ?:{ *:[i32] }:$in, (imm:{ *:[i32] }):$imm)
     /*   1497 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBFIC),
     /*   1500 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
     /*   1502 */     GIR_RootToRootCopy, /*OpIdx*/2, // in
     /*   1504 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   1507 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
     /*   1510 */     GIR_RootConstrainSelectedInstOperands,
     /*   1511 */     // GIR_Coverage, 1217,
     /*   1511 */     GIR_EraseRootFromParent_Done,
     /*   1512 */   // Label 120: @1512
     /*   1512 */   GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1528), // Rule ID 209 //
     /*   1517 */     // (sub:{ *:[i32] } i32:{ *:[i32] }:$RB, i32:{ *:[i32] }:$RA)  =>  (SUBF:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   1517 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBF),
     /*   1520 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   1522 */     GIR_RootToRootCopy, /*OpIdx*/2, // RA
     /*   1524 */     GIR_RootToRootCopy, /*OpIdx*/1, // RB
     /*   1526 */     GIR_RootConstrainSelectedInstOperands,
     /*   1527 */     // GIR_Coverage, 209,
     /*   1527 */     GIR_EraseRootFromParent_Done,
     /*   1528 */   // Label 121: @1528
     /*   1528 */   GIM_Reject,
     /*   1529 */ // Label 118: @1529
     /*   1529 */ GIM_Reject,
     /*   1530 */ // Label 110: @1530
     /*   1530 */ GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(1614),
     /*   1535 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   1538 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   1541 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   1545 */   GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(1563), // Rule ID 669 //
     /*   1550 */     GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
     /*   1554 */     // (sub:{ *:[i64] } 0:{ *:[i64] }, i64:{ *:[i64] }:$RA)  =>  (NEG8:{ *:[i64] } i64:{ *:[i64] }:$RA)
     /*   1554 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::NEG8),
     /*   1557 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   1559 */     GIR_RootToRootCopy, /*OpIdx*/2, // RA
     /*   1561 */     GIR_RootConstrainSelectedInstOperands,
     /*   1562 */     // GIR_Coverage, 669,
     /*   1562 */     GIR_EraseRootFromParent_Done,
     /*   1563 */   // Label 123: @1563
     /*   1563 */   GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(1597), // Rule ID 1539 //
     /*   1568 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1572 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1576 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
     /*   1580 */     // MIs[1] Operand 1
     /*   1580 */     // No operand predicates
     /*   1580 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1582 */     // (sub:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$imm, i64:{ *:[i64] }:$in)  =>  (SUBFIC8:{ *:[i64] }:{ *:[i32] } ?:{ *:[i64] }:$in, (imm:{ *:[i64] }):$imm)
     /*   1582 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBFIC8),
     /*   1585 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
     /*   1587 */     GIR_RootToRootCopy, /*OpIdx*/2, // in
     /*   1589 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   1592 */     GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for PPC::CARRY*/0,
     /*   1595 */     GIR_RootConstrainSelectedInstOperands,
     /*   1596 */     // GIR_Coverage, 1539,
     /*   1596 */     GIR_EraseRootFromParent_Done,
     /*   1597 */   // Label 124: @1597
     /*   1597 */   GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(1613), // Rule ID 668 //
     /*   1602 */     // (sub:{ *:[i64] } i64:{ *:[i64] }:$RB, i64:{ *:[i64] }:$RA)  =>  (SUBF8:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   1602 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::SUBF8),
     /*   1605 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   1607 */     GIR_RootToRootCopy, /*OpIdx*/2, // RA
     /*   1609 */     GIR_RootToRootCopy, /*OpIdx*/1, // RB
     /*   1611 */     GIR_RootConstrainSelectedInstOperands,
     /*   1612 */     // GIR_Coverage, 668,
     /*   1612 */     GIR_EraseRootFromParent_Done,
     /*   1613 */   // Label 125: @1613
     /*   1613 */   GIM_Reject,
     /*   1614 */ // Label 122: @1614
     /*   1614 */ GIM_Reject,
     /*   1615 */ // Label 111: @1615
     /*   1615 */ GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(1640), // Rule ID 475 //
     /*   1620 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
     /*   1623 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
     /*   1626 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
     /*   1629 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1633 */   // (sub:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VSUBUQM:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
     /*   1633 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUQM),
     /*   1638 */   GIR_RootConstrainSelectedInstOperands,
     /*   1639 */   // GIR_Coverage, 475,
     /*   1639 */   GIR_Done,
     /*   1640 */ // Label 126: @1640
     /*   1640 */ GIM_Reject,
     /*   1641 */ // Label 112: @1641
     /*   1641 */ GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(1703),
     /*   1646 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   1649 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   1652 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1656 */   GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(1687), // Rule ID 542 //
     /*   1661 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
     /*   1664 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1668 */     GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   1674 */     GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
     /*   1676 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1678 */     // (sub:{ *:[v2i64] } immAllZerosV:{ *:[v2i64] }, v2i64:{ *:[v2i64] }:$VB)  =>  (VNEGD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VB)
     /*   1678 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNEGD),
     /*   1681 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
     /*   1683 */     GIR_RootToRootCopy, /*OpIdx*/2, // VB
     /*   1685 */     GIR_RootConstrainSelectedInstOperands,
     /*   1686 */     // GIR_Coverage, 542,
     /*   1686 */     GIR_EraseRootFromParent_Done,
     /*   1687 */   // Label 128: @1687
     /*   1687 */   GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(1702), // Rule ID 474 //
     /*   1692 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
     /*   1695 */     // (sub:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VSUBUDM:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   1695 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUDM),
     /*   1700 */     GIR_RootConstrainSelectedInstOperands,
     /*   1701 */     // GIR_Coverage, 474,
     /*   1701 */     GIR_Done,
     /*   1702 */   // Label 129: @1702
     /*   1702 */   GIM_Reject,
     /*   1703 */ // Label 127: @1703
     /*   1703 */ GIM_Reject,
     /*   1704 */ // Label 113: @1704
     /*   1704 */ GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(1766),
     /*   1709 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   1712 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   1715 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1719 */   GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(1750), // Rule ID 541 //
     /*   1724 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP9Altivec),
     /*   1727 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   1731 */     GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   1737 */     GIM_CheckIsBuildVectorAllZeros, /*MI*/1,
     /*   1739 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1741 */     // (sub:{ *:[v4i32] } immAllZerosV:{ *:[v4i32] }, v4i32:{ *:[v4i32] }:$VB)  =>  (VNEGW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB)
     /*   1741 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VNEGW),
     /*   1744 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
     /*   1746 */     GIR_RootToRootCopy, /*OpIdx*/2, // VB
     /*   1748 */     GIR_RootConstrainSelectedInstOperands,
     /*   1749 */     // GIR_Coverage, 541,
     /*   1749 */     GIR_EraseRootFromParent_Done,
     /*   1750 */   // Label 131: @1750
     /*   1750 */   GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(1765), // Rule ID 373 //
     /*   1755 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1758 */     // (sub:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VSUBUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   1758 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUWM),
     /*   1763 */     GIR_RootConstrainSelectedInstOperands,
     /*   1764 */     // GIR_Coverage, 373,
     /*   1764 */     GIR_Done,
     /*   1765 */   // Label 132: @1765
     /*   1765 */   GIM_Reject,
     /*   1766 */ // Label 130: @1766
     /*   1766 */ GIM_Reject,
     /*   1767 */ // Label 114: @1767
     /*   1767 */ GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(1792), // Rule ID 372 //
     /*   1772 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1775 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   1778 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   1781 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1785 */   // (sub:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)  =>  (VSUBUHM:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$VA, v8i16:{ *:[v8i16] }:$VB)
     /*   1785 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUHM),
     /*   1790 */   GIR_RootConstrainSelectedInstOperands,
     /*   1791 */   // GIR_Coverage, 372,
     /*   1791 */   GIR_Done,
     /*   1792 */ // Label 133: @1792
     /*   1792 */ GIM_Reject,
     /*   1793 */ // Label 115: @1793
     /*   1793 */ GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(1818), // Rule ID 371 //
     /*   1798 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   1801 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
     /*   1804 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
     /*   1807 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   1811 */   // (sub:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)  =>  (VSUBUBM:{ *:[v16i8] } v16i8:{ *:[v16i8] }:$VA, v16i8:{ *:[v16i8] }:$VB)
     /*   1811 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VSUBUBM),
     /*   1816 */   GIR_RootConstrainSelectedInstOperands,
     /*   1817 */   // GIR_Coverage, 371,
     /*   1817 */   GIR_Done,
     /*   1818 */ // Label 134: @1818
     /*   1818 */ GIM_Reject,
     /*   1819 */ // Label 116: @1819
     /*   1819 */ GIM_Reject,
     /*   1820 */ // Label 2: @1820
     /*   1820 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(7), /*)*//*default:*//*Label 141*/ GIMT_Encode4(2101),
     /*   1831 */ /*GILLT_s1*//*Label 135*/ GIMT_Encode4(1859),
     /*   1835 */ /*GILLT_s32*//*Label 136*/ GIMT_Encode4(1882),
     /*   1839 */ /*GILLT_s64*//*Label 137*/ GIMT_Encode4(1942), GIMT_Encode4(0),
     /*   1847 */ /*GILLT_v2s64*//*Label 138*/ GIMT_Encode4(2002),
     /*   1851 */ /*GILLT_v4s32*//*Label 139*/ GIMT_Encode4(2028),
     /*   1855 */ /*GILLT_v8s16*//*Label 140*/ GIMT_Encode4(2054),
     /*   1859 */ // Label 135: @1859
     /*   1859 */ GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(1881), // Rule ID 3671 //
     /*   1864 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*   1867 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*   1870 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
     /*   1874 */   // (mul:{ *:[i1] } i1:{ *:[i1] }:$a, i1:{ *:[i1] }:$b)  =>  (CRAND:{ *:[i1] } ?:{ *:[i1] }:$a, ?:{ *:[i1] }:$b)
     /*   1874 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
     /*   1879 */   GIR_RootConstrainSelectedInstOperands,
     /*   1880 */   // GIR_Coverage, 3671,
     /*   1880 */   GIR_Done,
     /*   1881 */ // Label 142: @1881
     /*   1881 */ GIM_Reject,
     /*   1882 */ // Label 136: @1882
     /*   1882 */ GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(1941),
     /*   1887 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   1890 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   1893 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   1897 */   GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(1928), // Rule ID 111 //
     /*   1902 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1906 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1910 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm32SExt16),
     /*   1914 */     // MIs[1] Operand 1
     /*   1914 */     // No operand predicates
     /*   1914 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1916 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] })<<P:Predicate_imm32SExt16>>:$D)  =>  (MULLI:{ *:[i32] } i32:{ *:[i32] }:$RA, (imm:{ *:[i32] }):$D)
     /*   1916 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULLI),
     /*   1919 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
     /*   1921 */     GIR_RootToRootCopy, /*OpIdx*/1, // RA
     /*   1923 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
     /*   1926 */     GIR_RootConstrainSelectedInstOperands,
     /*   1927 */     // GIR_Coverage, 111,
     /*   1927 */     GIR_EraseRootFromParent_Done,
     /*   1928 */   // Label 144: @1928
     /*   1928 */   GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(1940), // Rule ID 208 //
     /*   1933 */     // (mul:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MULLW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   1933 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLW),
     /*   1938 */     GIR_RootConstrainSelectedInstOperands,
     /*   1939 */     // GIR_Coverage, 208,
     /*   1939 */     GIR_Done,
     /*   1940 */   // Label 145: @1940
     /*   1940 */   GIM_Reject,
     /*   1941 */ // Label 143: @1941
     /*   1941 */ GIM_Reject,
     /*   1942 */ // Label 137: @1942
     /*   1942 */ GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2001),
     /*   1947 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   1950 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   1953 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   1957 */   GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(1988), // Rule ID 706 //
     /*   1962 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   1966 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   1970 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm64SExt16),
     /*   1974 */     // MIs[1] Operand 1
     /*   1974 */     // No operand predicates
     /*   1974 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   1976 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] })<<P:Predicate_imm64SExt16>>:$D)  =>  (MULLI8:{ *:[i64] } i64:{ *:[i64] }:$RA, (imm:{ *:[i64] }):$D)
     /*   1976 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::MULLI8),
     /*   1979 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RST]
     /*   1981 */     GIR_RootToRootCopy, /*OpIdx*/1, // RA
     /*   1983 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // D
     /*   1986 */     GIR_RootConstrainSelectedInstOperands,
     /*   1987 */     // GIR_Coverage, 706,
     /*   1987 */     GIR_EraseRootFromParent_Done,
     /*   1988 */   // Label 147: @1988
     /*   1988 */   GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2000), // Rule ID 705 //
     /*   1993 */     // (mul:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MULLD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   1993 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MULLD),
     /*   1998 */     GIR_RootConstrainSelectedInstOperands,
     /*   1999 */     // GIR_Coverage, 705,
     /*   1999 */     GIR_Done,
     /*   2000 */   // Label 148: @2000
     /*   2000 */   GIM_Reject,
     /*   2001 */ // Label 146: @2001
     /*   2001 */ GIM_Reject,
     /*   2002 */ // Label 138: @2002
     /*   2002 */ GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2027), // Rule ID 1124 //
     /*   2007 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2010 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   2013 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   2016 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2020 */   // (mul:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMULLD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   2020 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULLD),
     /*   2025 */   GIR_RootConstrainSelectedInstOperands,
     /*   2026 */   // GIR_Coverage, 1124,
     /*   2026 */   GIR_Done,
     /*   2027 */ // Label 149: @2027
     /*   2027 */ GIM_Reject,
     /*   2028 */ // Label 139: @2028
     /*   2028 */ GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2053), // Rule ID 461 //
     /*   2033 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP8Altivec),
     /*   2036 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   2039 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   2042 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2046 */   // (mul:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMULUWM:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   2046 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMULUWM),
     /*   2051 */   GIR_RootConstrainSelectedInstOperands,
     /*   2052 */   // GIR_Coverage, 461,
     /*   2052 */   GIR_Done,
     /*   2053 */ // Label 150: @2053
     /*   2053 */ GIM_Reject,
     /*   2054 */ // Label 140: @2054
     /*   2054 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2100), // Rule ID 1295 //
     /*   2059 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   2062 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
     /*   2065 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
     /*   2068 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2072 */   // (mul:{ *:[v8i16] } v8i16:{ *:[v8i16] }:$vA, v8i16:{ *:[v8i16] }:$vB)  =>  (VMLADDUHM:{ *:[v8i16] } ?:{ *:[v8i16] }:$vA, ?:{ *:[v8i16] }:$vB, (V_SET0H:{ *:[v8i16] }))
     /*   2072 */   GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s16,
     /*   2075 */   GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(PPC::V_SET0H),
     /*   2079 */   GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   2084 */   GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   2086 */   GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VMLADDUHM),
     /*   2089 */   GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RT]
     /*   2091 */   GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   2093 */   GIR_RootToRootCopy, /*OpIdx*/2, // vB
     /*   2095 */   GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   2098 */   GIR_RootConstrainSelectedInstOperands,
     /*   2099 */   // GIR_Coverage, 1295,
     /*   2099 */   GIR_EraseRootFromParent_Done,
     /*   2100 */ // Label 151: @2100
     /*   2100 */ GIM_Reject,
     /*   2101 */ // Label 141: @2101
     /*   2101 */ GIM_Reject,
     /*   2102 */ // Label 3: @2102
     /*   2102 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 157*/ GIMT_Encode4(2257),
     /*   2113 */ /*GILLT_s32*//*Label 152*/ GIMT_Encode4(2133),
     /*   2117 */ /*GILLT_s64*//*Label 153*/ GIMT_Encode4(2156),
     /*   2121 */ /*GILLT_s128*//*Label 154*/ GIMT_Encode4(2179),
     /*   2125 */ /*GILLT_v2s64*//*Label 155*/ GIMT_Encode4(2205),
     /*   2129 */ /*GILLT_v4s32*//*Label 156*/ GIMT_Encode4(2231),
     /*   2133 */ // Label 152: @2133
     /*   2133 */ GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(2155), // Rule ID 202 //
     /*   2138 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2141 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2144 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   2148 */   // (sdiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   2148 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVW),
     /*   2153 */   GIR_RootConstrainSelectedInstOperands,
     /*   2154 */   // GIR_Coverage, 202,
     /*   2154 */   GIR_Done,
     /*   2155 */ // Label 158: @2155
     /*   2155 */ GIM_Reject,
     /*   2156 */ // Label 153: @2156
     /*   2156 */ GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(2178), // Rule ID 697 //
     /*   2161 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   2164 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   2167 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   2171 */   // (sdiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   2171 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVD),
     /*   2176 */   GIR_RootConstrainSelectedInstOperands,
     /*   2177 */   // GIR_Coverage, 697,
     /*   2177 */   GIR_Done,
     /*   2178 */ // Label 159: @2178
     /*   2178 */ GIM_Reject,
     /*   2179 */ // Label 154: @2179
     /*   2179 */ GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(2204), // Rule ID 1148 //
     /*   2184 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2187 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
     /*   2190 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
     /*   2193 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2197 */   // (sdiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
     /*   2197 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSQ),
     /*   2202 */   GIR_RootConstrainSelectedInstOperands,
     /*   2203 */   // GIR_Coverage, 1148,
     /*   2203 */   GIR_Done,
     /*   2204 */ // Label 160: @2204
     /*   2204 */ GIM_Reject,
     /*   2205 */ // Label 155: @2205
     /*   2205 */ GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(2230), // Rule ID 1135 //
     /*   2210 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2213 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   2216 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   2219 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2223 */   // (sdiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   2223 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSD),
     /*   2228 */   GIR_RootConstrainSelectedInstOperands,
     /*   2229 */   // GIR_Coverage, 1135,
     /*   2229 */   GIR_Done,
     /*   2230 */ // Label 161: @2230
     /*   2230 */ GIM_Reject,
     /*   2231 */ // Label 156: @2231
     /*   2231 */ GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(2256), // Rule ID 1133 //
     /*   2236 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2239 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   2242 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   2245 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2249 */   // (sdiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   2249 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVSW),
     /*   2254 */   GIR_RootConstrainSelectedInstOperands,
     /*   2255 */   // GIR_Coverage, 1133,
     /*   2255 */   GIR_Done,
     /*   2256 */ // Label 162: @2256
     /*   2256 */ GIM_Reject,
     /*   2257 */ // Label 157: @2257
     /*   2257 */ GIM_Reject,
     /*   2258 */ // Label 4: @2258
     /*   2258 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 168*/ GIMT_Encode4(2413),
     /*   2269 */ /*GILLT_s32*//*Label 163*/ GIMT_Encode4(2289),
     /*   2273 */ /*GILLT_s64*//*Label 164*/ GIMT_Encode4(2312),
     /*   2277 */ /*GILLT_s128*//*Label 165*/ GIMT_Encode4(2335),
     /*   2281 */ /*GILLT_v2s64*//*Label 166*/ GIMT_Encode4(2361),
     /*   2285 */ /*GILLT_v4s32*//*Label 167*/ GIMT_Encode4(2387),
     /*   2289 */ // Label 163: @2289
     /*   2289 */ GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2311), // Rule ID 203 //
     /*   2294 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2297 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2300 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   2304 */   // (udiv:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (DIVWU:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   2304 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVWU),
     /*   2309 */   GIR_RootConstrainSelectedInstOperands,
     /*   2310 */   // GIR_Coverage, 203,
     /*   2310 */   GIR_Done,
     /*   2311 */ // Label 169: @2311
     /*   2311 */ GIM_Reject,
     /*   2312 */ // Label 164: @2312
     /*   2312 */ GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2334), // Rule ID 698 //
     /*   2317 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   2320 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   2323 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   2327 */   // (udiv:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (DIVDU:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   2327 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::DIVDU),
     /*   2332 */   GIR_RootConstrainSelectedInstOperands,
     /*   2333 */   // GIR_Coverage, 698,
     /*   2333 */   GIR_Done,
     /*   2334 */ // Label 170: @2334
     /*   2334 */ GIM_Reject,
     /*   2335 */ // Label 165: @2335
     /*   2335 */ GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2360), // Rule ID 1149 //
     /*   2340 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2343 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
     /*   2346 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
     /*   2349 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2353 */   // (udiv:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VDIVUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
     /*   2353 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUQ),
     /*   2358 */   GIR_RootConstrainSelectedInstOperands,
     /*   2359 */   // GIR_Coverage, 1149,
     /*   2359 */   GIR_Done,
     /*   2360 */ // Label 171: @2360
     /*   2360 */ GIM_Reject,
     /*   2361 */ // Label 166: @2361
     /*   2361 */ GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2386), // Rule ID 1136 //
     /*   2366 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2369 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   2372 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   2375 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2379 */   // (udiv:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VDIVUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   2379 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUD),
     /*   2384 */   GIR_RootConstrainSelectedInstOperands,
     /*   2385 */   // GIR_Coverage, 1136,
     /*   2385 */   GIR_Done,
     /*   2386 */ // Label 172: @2386
     /*   2386 */ GIM_Reject,
     /*   2387 */ // Label 167: @2387
     /*   2387 */ GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2412), // Rule ID 1134 //
     /*   2392 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2395 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   2398 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   2401 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2405 */   // (udiv:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VDIVUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   2405 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VDIVUW),
     /*   2410 */   GIR_RootConstrainSelectedInstOperands,
     /*   2411 */   // GIR_Coverage, 1134,
     /*   2411 */   GIR_Done,
     /*   2412 */ // Label 173: @2412
     /*   2412 */ GIM_Reject,
     /*   2413 */ // Label 168: @2413
     /*   2413 */ GIM_Reject,
     /*   2414 */ // Label 5: @2414
     /*   2414 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 179*/ GIMT_Encode4(2575),
     /*   2425 */ /*GILLT_s32*//*Label 174*/ GIMT_Encode4(2445),
     /*   2429 */ /*GILLT_s64*//*Label 175*/ GIMT_Encode4(2471),
     /*   2433 */ /*GILLT_s128*//*Label 176*/ GIMT_Encode4(2497),
     /*   2437 */ /*GILLT_v2s64*//*Label 177*/ GIMT_Encode4(2523),
     /*   2441 */ /*GILLT_v4s32*//*Label 178*/ GIMT_Encode4(2549),
     /*   2445 */ // Label 174: @2445
     /*   2445 */ GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2470), // Rule ID 197 //
     /*   2450 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
     /*   2453 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2456 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2459 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   2463 */   // (srem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODSW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   2463 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSW),
     /*   2468 */   GIR_RootConstrainSelectedInstOperands,
     /*   2469 */   // GIR_Coverage, 197,
     /*   2469 */   GIR_Done,
     /*   2470 */ // Label 180: @2470
     /*   2470 */ GIM_Reject,
     /*   2471 */ // Label 175: @2471
     /*   2471 */ GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2496), // Rule ID 702 //
     /*   2476 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
     /*   2479 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   2482 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   2485 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   2489 */   // (srem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODSD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   2489 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODSD),
     /*   2494 */   GIR_RootConstrainSelectedInstOperands,
     /*   2495 */   // GIR_Coverage, 702,
     /*   2495 */   GIR_Done,
     /*   2496 */ // Label 181: @2496
     /*   2496 */ GIM_Reject,
     /*   2497 */ // Label 176: @2497
     /*   2497 */ GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(2522), // Rule ID 1158 //
     /*   2502 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2505 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
     /*   2508 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
     /*   2511 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2515 */   // (srem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODSQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
     /*   2515 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSQ),
     /*   2520 */   GIR_RootConstrainSelectedInstOperands,
     /*   2521 */   // GIR_Coverage, 1158,
     /*   2521 */   GIR_Done,
     /*   2522 */ // Label 182: @2522
     /*   2522 */ GIM_Reject,
     /*   2523 */ // Label 177: @2523
     /*   2523 */ GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(2548), // Rule ID 1131 //
     /*   2528 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2531 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   2534 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   2537 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2541 */   // (srem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODSD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   2541 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSD),
     /*   2546 */   GIR_RootConstrainSelectedInstOperands,
     /*   2547 */   // GIR_Coverage, 1131,
     /*   2547 */   GIR_Done,
     /*   2548 */ // Label 183: @2548
     /*   2548 */ GIM_Reject,
     /*   2549 */ // Label 178: @2549
     /*   2549 */ GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(2574), // Rule ID 1129 //
     /*   2554 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2557 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   2560 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   2563 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2567 */   // (srem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODSW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   2567 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODSW),
     /*   2572 */   GIR_RootConstrainSelectedInstOperands,
     /*   2573 */   // GIR_Coverage, 1129,
     /*   2573 */   GIR_Done,
     /*   2574 */ // Label 184: @2574
     /*   2574 */ GIM_Reject,
     /*   2575 */ // Label 179: @2575
     /*   2575 */ GIM_Reject,
     /*   2576 */ // Label 6: @2576
     /*   2576 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(6), /*)*//*default:*//*Label 190*/ GIMT_Encode4(2737),
     /*   2587 */ /*GILLT_s32*//*Label 185*/ GIMT_Encode4(2607),
     /*   2591 */ /*GILLT_s64*//*Label 186*/ GIMT_Encode4(2633),
     /*   2595 */ /*GILLT_s128*//*Label 187*/ GIMT_Encode4(2659),
     /*   2599 */ /*GILLT_v2s64*//*Label 188*/ GIMT_Encode4(2685),
     /*   2603 */ /*GILLT_v4s32*//*Label 189*/ GIMT_Encode4(2711),
     /*   2607 */ // Label 185: @2607
     /*   2607 */ GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(2632), // Rule ID 198 //
     /*   2612 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
     /*   2615 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2618 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2621 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   2625 */   // (urem:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)  =>  (MODUW:{ *:[i32] } i32:{ *:[i32] }:$RA, i32:{ *:[i32] }:$RB)
     /*   2625 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUW),
     /*   2630 */   GIR_RootConstrainSelectedInstOperands,
     /*   2631 */   // GIR_Coverage, 198,
     /*   2631 */   GIR_Done,
     /*   2632 */ // Label 191: @2632
     /*   2632 */ GIM_Reject,
     /*   2633 */ // Label 186: @2633
     /*   2633 */ GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(2658), // Rule ID 703 //
     /*   2638 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_0),
     /*   2641 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   2644 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   2647 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   2651 */   // (urem:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)  =>  (MODUD:{ *:[i64] } i64:{ *:[i64] }:$RA, i64:{ *:[i64] }:$RB)
     /*   2651 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::MODUD),
     /*   2656 */   GIR_RootConstrainSelectedInstOperands,
     /*   2657 */   // GIR_Coverage, 703,
     /*   2657 */   GIR_Done,
     /*   2658 */ // Label 192: @2658
     /*   2658 */ GIM_Reject,
     /*   2659 */ // Label 187: @2659
     /*   2659 */ GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(2684), // Rule ID 1159 //
     /*   2664 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2667 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s128,
     /*   2670 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s128,
     /*   2673 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2677 */   // (urem:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)  =>  (VMODUQ:{ *:[v1i128] } v1i128:{ *:[v1i128] }:$VA, v1i128:{ *:[v1i128] }:$VB)
     /*   2677 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUQ),
     /*   2682 */   GIR_RootConstrainSelectedInstOperands,
     /*   2683 */   // GIR_Coverage, 1159,
     /*   2683 */   GIR_Done,
     /*   2684 */ // Label 193: @2684
     /*   2684 */ GIM_Reject,
     /*   2685 */ // Label 188: @2685
     /*   2685 */ GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(2710), // Rule ID 1132 //
     /*   2690 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2693 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /*   2696 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
     /*   2699 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2703 */   // (urem:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)  =>  (VMODUD:{ *:[v2i64] } v2i64:{ *:[v2i64] }:$VA, v2i64:{ *:[v2i64] }:$VB)
     /*   2703 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUD),
     /*   2708 */   GIR_RootConstrainSelectedInstOperands,
     /*   2709 */   // GIR_Coverage, 1132,
     /*   2709 */   GIR_Done,
     /*   2710 */ // Label 194: @2710
     /*   2710 */ GIM_Reject,
     /*   2711 */ // Label 189: @2711
     /*   2711 */ GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(2736), // Rule ID 1130 //
     /*   2716 */   GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsISA3_1),
     /*   2719 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   2722 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   2725 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   2729 */   // (urem:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VMODUW:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   2729 */   GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VMODUW),
     /*   2734 */   GIR_RootConstrainSelectedInstOperands,
     /*   2735 */   // GIR_Coverage, 1130,
     /*   2735 */   GIR_Done,
     /*   2736 */ // Label 195: @2736
     /*   2736 */ GIM_Reject,
     /*   2737 */ // Label 190: @2737
     /*   2737 */ GIM_Reject,
     /*   2738 */ // Label 7: @2738
     /*   2738 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 200*/ GIMT_Encode4(5298),
     /*   2749 */ /*GILLT_s1*//*Label 196*/ GIMT_Encode4(2773),
     /*   2753 */ /*GILLT_s32*//*Label 197*/ GIMT_Encode4(2882),
     /*   2757 */ /*GILLT_s64*//*Label 198*/ GIMT_Encode4(2991), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   2769 */ /*GILLT_v4s32*//*Label 199*/ GIMT_Encode4(3100),
     /*   2773 */ // Label 196: @2773
     /*   2773 */ GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(2881),
     /*   2778 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*   2781 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*   2784 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
     /*   2788 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(2828), // Rule ID 4924 //
     /*   2793 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2797 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   2801 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*   2805 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*   2809 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   2813 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2815 */     // (and:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
     /*   2815 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
     /*   2818 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
     /*   2820 */     GIR_RootToRootCopy, /*OpIdx*/2, // CRA
     /*   2822 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
     /*   2826 */     GIR_RootConstrainSelectedInstOperands,
     /*   2827 */     // GIR_Coverage, 4924,
     /*   2827 */     GIR_EraseRootFromParent_Done,
     /*   2828 */   // Label 202: @2828
     /*   2828 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(2868), // Rule ID 182 //
     /*   2833 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2837 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   2841 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*   2845 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*   2849 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   2853 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2855 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRANDC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
     /*   2855 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRANDC),
     /*   2858 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
     /*   2860 */     GIR_RootToRootCopy, /*OpIdx*/1, // CRA
     /*   2862 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
     /*   2866 */     GIR_RootConstrainSelectedInstOperands,
     /*   2867 */     // GIR_Coverage, 182,
     /*   2867 */     GIR_EraseRootFromParent_Done,
     /*   2868 */   // Label 203: @2868
     /*   2868 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(2880), // Rule ID 175 //
     /*   2873 */     // (and:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CRAND:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
     /*   2873 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CRAND),
     /*   2878 */     GIR_RootConstrainSelectedInstOperands,
     /*   2879 */     // GIR_Coverage, 175,
     /*   2879 */     GIR_Done,
     /*   2880 */   // Label 204: @2880
     /*   2880 */   GIM_Reject,
     /*   2881 */ // Label 201: @2881
     /*   2881 */ GIM_Reject,
     /*   2882 */ // Label 197: @2882
     /*   2882 */ GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(2990),
     /*   2887 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   2890 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   2893 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   2897 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(2937), // Rule ID 4918 //
     /*   2902 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   2906 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   2910 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2914 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2918 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   2922 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2924 */     // (and:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
     /*   2924 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC),
     /*   2927 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   2929 */     GIR_RootToRootCopy, /*OpIdx*/2, // RST
     /*   2931 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   2935 */     GIR_RootConstrainSelectedInstOperands,
     /*   2936 */     // GIR_Coverage, 4918,
     /*   2936 */     GIR_EraseRootFromParent_Done,
     /*   2937 */   // Label 206: @2937
     /*   2937 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(2977), // Rule ID 123 //
     /*   2942 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   2946 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   2950 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   2954 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   2958 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   2962 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   2964 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ANDC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
     /*   2964 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC),
     /*   2967 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   2969 */     GIR_RootToRootCopy, /*OpIdx*/1, // RST
     /*   2971 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   2975 */     GIR_RootConstrainSelectedInstOperands,
     /*   2976 */     // GIR_Coverage, 123,
     /*   2976 */     GIR_EraseRootFromParent_Done,
     /*   2977 */   // Label 207: @2977
     /*   2977 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(2989), // Rule ID 122 //
     /*   2982 */     // (and:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (AND:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
     /*   2982 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND),
     /*   2987 */     GIR_RootConstrainSelectedInstOperands,
     /*   2988 */     // GIR_Coverage, 122,
     /*   2988 */     GIR_Done,
     /*   2989 */   // Label 208: @2989
     /*   2989 */   GIM_Reject,
     /*   2990 */ // Label 205: @2990
     /*   2990 */ GIM_Reject,
     /*   2991 */ // Label 198: @2991
     /*   2991 */ GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(3099),
     /*   2996 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   2999 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   3002 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   3006 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(3046), // Rule ID 4931 //
     /*   3011 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3015 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3019 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   3023 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   3027 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   3031 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3033 */     // (and:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
     /*   3033 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
     /*   3036 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   3038 */     GIR_RootToRootCopy, /*OpIdx*/2, // RST
     /*   3040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   3044 */     GIR_RootConstrainSelectedInstOperands,
     /*   3045 */     // GIR_Coverage, 4931,
     /*   3045 */     GIR_EraseRootFromParent_Done,
     /*   3046 */   // Label 210: @3046
     /*   3046 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(3086), // Rule ID 647 //
     /*   3051 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   3055 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3059 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   3063 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   3067 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   3071 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   3073 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ANDC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
     /*   3073 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ANDC8),
     /*   3076 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   3078 */     GIR_RootToRootCopy, /*OpIdx*/1, // RST
     /*   3080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   3084 */     GIR_RootConstrainSelectedInstOperands,
     /*   3085 */     // GIR_Coverage, 647,
     /*   3085 */     GIR_EraseRootFromParent_Done,
     /*   3086 */   // Label 211: @3086
     /*   3086 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(3098), // Rule ID 646 //
     /*   3091 */     // (and:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (AND8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
     /*   3091 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::AND8),
     /*   3096 */     GIR_RootConstrainSelectedInstOperands,
     /*   3097 */     // GIR_Coverage, 646,
     /*   3097 */     GIR_Done,
     /*   3098 */   // Label 212: @3098
     /*   3098 */   GIM_Reject,
     /*   3099 */ // Label 209: @3099
     /*   3099 */ GIM_Reject,
     /*   3100 */ // Label 199: @3100
     /*   3100 */ GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(5297),
     /*   3105 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3108 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3111 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(3189), // Rule ID 5279 //
     /*   3116 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3119 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3123 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3127 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   3131 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3135 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3139 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3143 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3147 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3151 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3155 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   3159 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3165 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3167 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3169 */     // (and:{ *:[v4i32] } (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
     /*   3169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   3178 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   3182 */     GIR_RootToRootCopy, /*OpIdx*/2, // vC
     /*   3184 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
     /*   3187 */     GIR_RootConstrainSelectedInstOperands,
     /*   3188 */     // GIR_Coverage, 5279,
     /*   3188 */     GIR_EraseRootFromParent_Done,
     /*   3189 */   // Label 214: @3189
     /*   3189 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(3267), // Rule ID 5280 //
     /*   3194 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3197 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3201 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3205 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   3209 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3213 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3217 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   3221 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3225 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3229 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3233 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   3237 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3243 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3245 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3247 */     // (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })), v4i32:{ *:[v4i32] }:$vC)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
     /*   3247 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3250 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3252 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   3256 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   3260 */     GIR_RootToRootCopy, /*OpIdx*/2, // vC
     /*   3262 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
     /*   3265 */     GIR_RootConstrainSelectedInstOperands,
     /*   3266 */     // GIR_Coverage, 5280,
     /*   3266 */     GIR_EraseRootFromParent_Done,
     /*   3267 */   // Label 215: @3267
     /*   3267 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(3347), // Rule ID 5281 //
     /*   3272 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3275 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3279 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3283 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   3287 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3291 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3295 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   3299 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3303 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3307 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3311 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   3315 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3321 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3323 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3325 */     // (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
     /*   3325 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3328 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3330 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   3334 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   3338 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   3342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
     /*   3345 */     GIR_RootConstrainSelectedInstOperands,
     /*   3346 */     // GIR_Coverage, 5281,
     /*   3346 */     GIR_EraseRootFromParent_Done,
     /*   3347 */   // Label 216: @3347
     /*   3347 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(3427), // Rule ID 5284 //
     /*   3352 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3355 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3359 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3363 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*   3367 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3371 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3375 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   3379 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3383 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3387 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3391 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   3395 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3401 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3403 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3405 */     // (and:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 112:{ *:[i32] })
     /*   3405 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3408 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3410 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   3414 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   3418 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   3422 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/112,
     /*   3425 */     GIR_RootConstrainSelectedInstOperands,
     /*   3426 */     // GIR_Coverage, 5284,
     /*   3426 */     GIR_EraseRootFromParent_Done,
     /*   3427 */   // Label 217: @3427
     /*   3427 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(3505), // Rule ID 4968 //
     /*   3432 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3435 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3439 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3443 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3447 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3451 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3455 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3459 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   3463 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3467 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3471 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3475 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3481 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3483 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3485 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 14:{ *:[i32] })
     /*   3485 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3488 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3490 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   3492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   3496 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   3500 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   3503 */     GIR_RootConstrainSelectedInstOperands,
     /*   3504 */     // GIR_Coverage, 4968,
     /*   3504 */     GIR_EraseRootFromParent_Done,
     /*   3505 */   // Label 218: @3505
     /*   3505 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(3583), // Rule ID 4962 //
     /*   3510 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3513 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3517 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3521 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3525 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3529 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3533 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3537 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*   3541 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3545 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3549 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3553 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3559 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3561 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3563 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 8:{ *:[i32] })
     /*   3563 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3566 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3568 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   3570 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   3574 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   3578 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*   3581 */     GIR_RootConstrainSelectedInstOperands,
     /*   3582 */     // GIR_Coverage, 4962,
     /*   3582 */     GIR_EraseRootFromParent_Done,
     /*   3583 */   // Label 219: @3583
     /*   3583 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(3661), // Rule ID 4966 //
     /*   3588 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3591 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3595 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3599 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3603 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3607 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3611 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3615 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3619 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3623 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3627 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   3631 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3637 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3639 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3641 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
     /*   3641 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3644 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3646 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   3648 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   3652 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   3656 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
     /*   3659 */     GIR_RootConstrainSelectedInstOperands,
     /*   3660 */     // GIR_Coverage, 4966,
     /*   3660 */     GIR_EraseRootFromParent_Done,
     /*   3661 */   // Label 220: @3661
     /*   3661 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(3739), // Rule ID 4965 //
     /*   3666 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3669 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3673 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3677 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3681 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3685 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3689 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   3693 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3697 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3701 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3705 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   3709 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3715 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3717 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3719 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
     /*   3719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3724 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   3726 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   3730 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   3734 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
     /*   3737 */     GIR_RootConstrainSelectedInstOperands,
     /*   3738 */     // GIR_Coverage, 4965,
     /*   3738 */     GIR_EraseRootFromParent_Done,
     /*   3739 */   // Label 221: @3739
     /*   3739 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(3817), // Rule ID 4967 //
     /*   3744 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3747 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3751 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3755 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3759 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3763 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3767 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   3771 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3775 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3779 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3783 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   3787 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3793 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   3795 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3797 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] })), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
     /*   3797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3802 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   3804 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   3808 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*   3812 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
     /*   3815 */     GIR_RootConstrainSelectedInstOperands,
     /*   3816 */     // GIR_Coverage, 4967,
     /*   3816 */     GIR_EraseRootFromParent_Done,
     /*   3817 */   // Label 222: @3817
     /*   3817 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(3897), // Rule ID 3405 //
     /*   3822 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3825 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3829 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3833 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3837 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3841 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3845 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   3849 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3855 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   3857 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   3861 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
     /*   3865 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3869 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3873 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3875 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
     /*   3875 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3878 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3880 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*   3884 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*   3888 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*   3892 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
     /*   3895 */     GIR_RootConstrainSelectedInstOperands,
     /*   3896 */     // GIR_Coverage, 3405,
     /*   3896 */     GIR_EraseRootFromParent_Done,
     /*   3897 */   // Label 223: @3897
     /*   3897 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(3977), // Rule ID 3406 //
     /*   3902 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3905 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3909 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3913 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3917 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3921 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3925 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   3929 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   3935 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   3937 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   3941 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*   3945 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   3949 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   3953 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   3955 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 112:{ *:[i32] })
     /*   3955 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   3958 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   3960 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*   3964 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*   3968 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*   3972 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/112,
     /*   3975 */     GIR_RootConstrainSelectedInstOperands,
     /*   3976 */     // GIR_Coverage, 3406,
     /*   3976 */     GIR_EraseRootFromParent_Done,
     /*   3977 */   // Label 224: @3977
     /*   3977 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(4057), // Rule ID 3404 //
     /*   3982 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   3985 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   3989 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   3993 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   3997 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4001 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4005 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   4009 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4015 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   4017 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   4021 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4025 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4029 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4033 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4035 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 96:{ *:[i32] })
     /*   4035 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4038 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*   4044 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*   4048 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*   4052 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/96,
     /*   4055 */     GIR_RootConstrainSelectedInstOperands,
     /*   4056 */     // GIR_Coverage, 3404,
     /*   4056 */     GIR_EraseRootFromParent_Done,
     /*   4057 */   // Label 225: @4057
     /*   4057 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(4137), // Rule ID 5278 //
     /*   4062 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4065 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4069 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4073 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4077 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4081 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4085 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   4089 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4093 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4097 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4101 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   4105 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4111 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4113 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4115 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 96:{ *:[i32] })
     /*   4115 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4118 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4120 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   4124 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   4128 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   4132 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/96,
     /*   4135 */     GIR_RootConstrainSelectedInstOperands,
     /*   4136 */     // GIR_Coverage, 5278,
     /*   4136 */     GIR_EraseRootFromParent_Done,
     /*   4137 */   // Label 226: @4137
     /*   4137 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4215), // Rule ID 5282 //
     /*   4142 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4145 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4149 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4153 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   4157 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4161 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4165 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4169 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4173 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4177 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4181 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   4185 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4191 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4193 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4195 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
     /*   4195 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4198 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4200 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   4204 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   4208 */     GIR_RootToRootCopy, /*OpIdx*/1, // vC
     /*   4210 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
     /*   4213 */     GIR_RootConstrainSelectedInstOperands,
     /*   4214 */     // GIR_Coverage, 5282,
     /*   4214 */     GIR_EraseRootFromParent_Done,
     /*   4215 */   // Label 227: @4215
     /*   4215 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4293), // Rule ID 5283 //
     /*   4220 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4223 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4227 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4231 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   4235 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4239 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4243 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   4247 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4251 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4255 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4259 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   4263 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4269 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4271 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4273 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, immAllOnesV:{ *:[v4i32] })))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 16:{ *:[i32] })
     /*   4273 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4276 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4278 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   4282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   4286 */     GIR_RootToRootCopy, /*OpIdx*/1, // vC
     /*   4288 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/16,
     /*   4291 */     GIR_RootConstrainSelectedInstOperands,
     /*   4292 */     // GIR_Coverage, 5283,
     /*   4292 */     GIR_EraseRootFromParent_Done,
     /*   4293 */   // Label 228: @4293
     /*   4293 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4371), // Rule ID 3392 //
     /*   4298 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4301 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4305 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4309 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4313 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4317 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4321 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4325 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   4329 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4333 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4337 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   4341 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4347 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4349 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4351 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 14:{ *:[i32] })
     /*   4351 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4354 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4356 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   4358 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   4362 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   4366 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
     /*   4369 */     GIR_RootConstrainSelectedInstOperands,
     /*   4370 */     // GIR_Coverage, 3392,
     /*   4370 */     GIR_EraseRootFromParent_Done,
     /*   4371 */   // Label 229: @4371
     /*   4371 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4449), // Rule ID 3390 //
     /*   4376 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4379 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4383 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4387 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4391 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4395 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4399 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4403 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*   4407 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4411 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4415 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   4419 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4425 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4427 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4429 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 8:{ *:[i32] })
     /*   4429 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4432 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4434 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   4436 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   4440 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   4444 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/8,
     /*   4447 */     GIR_RootConstrainSelectedInstOperands,
     /*   4448 */     // GIR_Coverage, 3390,
     /*   4448 */     GIR_EraseRootFromParent_Done,
     /*   4449 */   // Label 230: @4449
     /*   4449 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4527), // Rule ID 4963 //
     /*   4454 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4457 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4461 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4465 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4469 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4473 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4477 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4481 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4485 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4489 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4493 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   4497 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4503 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4505 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4507 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
     /*   4507 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4510 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4512 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   4514 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   4518 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   4522 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
     /*   4525 */     GIR_RootConstrainSelectedInstOperands,
     /*   4526 */     // GIR_Coverage, 4963,
     /*   4526 */     GIR_EraseRootFromParent_Done,
     /*   4527 */   // Label 231: @4527
     /*   4527 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4605), // Rule ID 3391 //
     /*   4532 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4535 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4539 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4543 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4547 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4551 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4555 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   4559 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4563 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4567 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4571 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   4575 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4581 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4583 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4585 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
     /*   4585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4590 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   4592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   4596 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   4600 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
     /*   4603 */     GIR_RootConstrainSelectedInstOperands,
     /*   4604 */     // GIR_Coverage, 3391,
     /*   4604 */     GIR_EraseRootFromParent_Done,
     /*   4605 */   // Label 232: @4605
     /*   4605 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4683), // Rule ID 4964 //
     /*   4610 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4613 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4617 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4621 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4625 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4629 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4633 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   4637 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4641 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4645 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4649 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*   4653 */     GIM_CheckOpcodeIsEither, /*MI*/3, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4659 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/3,
     /*   4661 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   4663 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, immAllOnesV:{ *:[v4i32] })))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 9:{ *:[i32] })
     /*   4663 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4666 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4668 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   4670 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   4674 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*   4678 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/9,
     /*   4681 */     GIR_RootConstrainSelectedInstOperands,
     /*   4682 */     // GIR_Coverage, 4964,
     /*   4682 */     GIR_EraseRootFromParent_Done,
     /*   4683 */   // Label 233: @4683
     /*   4683 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4738), // Rule ID 4939 //
     /*   4688 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
     /*   4691 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4695 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4699 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4703 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4707 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4711 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   4715 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4721 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   4723 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4725 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$XA)  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
     /*   4725 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
     /*   4728 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4730 */     GIR_RootToRootCopy, /*OpIdx*/2, // XA
     /*   4732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
     /*   4736 */     GIR_RootConstrainSelectedInstOperands,
     /*   4737 */     // GIR_Coverage, 4939,
     /*   4737 */     GIR_EraseRootFromParent_Done,
     /*   4738 */   // Label 234: @4738
     /*   4738 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4793), // Rule ID 933 //
     /*   4743 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
     /*   4746 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4750 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4754 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4758 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4762 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4766 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   4770 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   4776 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   4778 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   4780 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XB, immAllOnesV:{ *:[v4i32] }))  =>  (XXLANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
     /*   4780 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXLANDC),
     /*   4783 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4785 */     GIR_RootToRootCopy, /*OpIdx*/1, // XA
     /*   4787 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // XB
     /*   4791 */     GIR_RootConstrainSelectedInstOperands,
     /*   4792 */     // GIR_Coverage, 933,
     /*   4792 */     GIR_EraseRootFromParent_Done,
     /*   4793 */   // Label 235: @4793
     /*   4793 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(4843), // Rule ID 4959 //
     /*   4798 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4801 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4805 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4809 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   4813 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4817 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4821 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4823 */     // (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 1:{ *:[i32] })
     /*   4823 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4826 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4828 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*   4832 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   4836 */     GIR_RootToRootCopy, /*OpIdx*/2, // vC
     /*   4838 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   4841 */     GIR_RootConstrainSelectedInstOperands,
     /*   4842 */     // GIR_Coverage, 4959,
     /*   4842 */     GIR_EraseRootFromParent_Done,
     /*   4843 */   // Label 236: @4843
     /*   4843 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(4893), // Rule ID 4961 //
     /*   4848 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4851 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4855 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4859 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*   4863 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4867 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4871 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4873 */     // (and:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 7:{ *:[i32] })
     /*   4873 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4876 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4878 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   4880 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   4884 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   4888 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/7,
     /*   4891 */     GIR_RootConstrainSelectedInstOperands,
     /*   4892 */     // GIR_Coverage, 4961,
     /*   4892 */     GIR_EraseRootFromParent_Done,
     /*   4893 */   // Label 237: @4893
     /*   4893 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(4943), // Rule ID 4960 //
     /*   4898 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4901 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4905 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   4909 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   4913 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4917 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4921 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4923 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA)  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 6:{ *:[i32] })
     /*   4923 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4926 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4928 */     GIR_RootToRootCopy, /*OpIdx*/2, // vA
     /*   4930 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   4934 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   4938 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   4941 */     GIR_RootConstrainSelectedInstOperands,
     /*   4942 */     // GIR_Coverage, 4960,
     /*   4942 */     GIR_EraseRootFromParent_Done,
     /*   4943 */   // Label 238: @4943
     /*   4943 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(4993), // Rule ID 3387 //
     /*   4948 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   4951 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   4955 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   4959 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   4963 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   4967 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   4971 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   4973 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 1:{ *:[i32] })
     /*   4973 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   4976 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   4978 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   4980 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   4984 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   4988 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   4991 */     GIR_RootConstrainSelectedInstOperands,
     /*   4992 */     // GIR_Coverage, 3387,
     /*   4992 */     GIR_EraseRootFromParent_Done,
     /*   4993 */   // Label 239: @4993
     /*   4993 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(5043), // Rule ID 3389 //
     /*   4998 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   5001 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   5005 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5009 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /*   5013 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5017 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5021 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5023 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 7:{ *:[i32] })
     /*   5023 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   5026 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   5028 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   5030 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   5034 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   5038 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/7,
     /*   5041 */     GIR_RootConstrainSelectedInstOperands,
     /*   5042 */     // GIR_Coverage, 3389,
     /*   5042 */     GIR_EraseRootFromParent_Done,
     /*   5043 */   // Label 240: @5043
     /*   5043 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(5093), // Rule ID 3388 //
     /*   5048 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   5051 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   5055 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5059 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5063 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5067 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5071 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5073 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 6:{ *:[i32] })
     /*   5073 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   5076 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   5078 */     GIR_RootToRootCopy, /*OpIdx*/1, // vA
     /*   5080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*   5084 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   5088 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   5091 */     GIR_RootConstrainSelectedInstOperands,
     /*   5092 */     // GIR_Coverage, 3388,
     /*   5092 */     GIR_EraseRootFromParent_Done,
     /*   5093 */   // Label 241: @5093
     /*   5093 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(5112), // Rule ID 932 //
     /*   5098 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVSX),
     /*   5101 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   5105 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)  =>  (XXLAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$XA, v4i32:{ *:[v4i32] }:$XB)
     /*   5105 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::XXLAND),
     /*   5110 */     GIR_RootConstrainSelectedInstOperands,
     /*   5111 */     // GIR_Coverage, 932,
     /*   5111 */     GIR_Done,
     /*   5112 */   // Label 242: @5112
     /*   5112 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(5167), // Rule ID 4927 //
     /*   5117 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   5120 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   5124 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5128 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5132 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5136 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5140 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   5144 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   5150 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   5152 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5154 */     // (and:{ *:[v4i32] } (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }), v4i32:{ *:[v4i32] }:$VA)  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   5154 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
     /*   5157 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
     /*   5159 */     GIR_RootToRootCopy, /*OpIdx*/2, // VA
     /*   5161 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
     /*   5165 */     GIR_RootConstrainSelectedInstOperands,
     /*   5166 */     // GIR_Coverage, 4927,
     /*   5166 */     GIR_EraseRootFromParent_Done,
     /*   5167 */   // Label 243: @5167
     /*   5167 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(5222), // Rule ID 312 //
     /*   5172 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   5175 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   5179 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5183 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5187 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5191 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5195 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   5199 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   5205 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   5207 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5209 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VB, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   5209 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
     /*   5212 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
     /*   5214 */     GIR_RootToRootCopy, /*OpIdx*/1, // VA
     /*   5216 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // VB
     /*   5220 */     GIR_RootConstrainSelectedInstOperands,
     /*   5221 */     // GIR_Coverage, 312,
     /*   5221 */     GIR_EraseRootFromParent_Done,
     /*   5222 */   // Label 244: @5222
     /*   5222 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(5277), // Rule ID 1384 //
     /*   5227 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   5230 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   5234 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5238 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5242 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5246 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5250 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   5254 */     GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   5260 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
     /*   5262 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   5264 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$A, (xor:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$B, immAllOnesV:{ *:[v4i32] }))  =>  (VANDC:{ *:[v4i32] } ?:{ *:[v4i32] }:$A, ?:{ *:[v4i32] }:$B)
     /*   5264 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::VANDC),
     /*   5267 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[VD]
     /*   5269 */     GIR_RootToRootCopy, /*OpIdx*/1, // A
     /*   5271 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // B
     /*   5275 */     GIR_RootConstrainSelectedInstOperands,
     /*   5276 */     // GIR_Coverage, 1384,
     /*   5276 */     GIR_EraseRootFromParent_Done,
     /*   5277 */   // Label 245: @5277
     /*   5277 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(5296), // Rule ID 311 //
     /*   5282 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAltivec),
     /*   5285 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VRRCRegClassID),
     /*   5289 */     // (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)  =>  (VAND:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$VA, v4i32:{ *:[v4i32] }:$VB)
     /*   5289 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::VAND),
     /*   5294 */     GIR_RootConstrainSelectedInstOperands,
     /*   5295 */     // GIR_Coverage, 311,
     /*   5295 */     GIR_Done,
     /*   5296 */   // Label 246: @5296
     /*   5296 */   GIM_Reject,
     /*   5297 */ // Label 213: @5297
     /*   5297 */ GIM_Reject,
     /*   5298 */ // Label 200: @5298
     /*   5298 */ GIM_Reject,
     /*   5299 */ // Label 8: @5299
     /*   5299 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(6), /*)*//*default:*//*Label 251*/ GIMT_Encode4(48440),
     /*   5310 */ /*GILLT_s1*//*Label 247*/ GIMT_Encode4(5334),
     /*   5314 */ /*GILLT_s32*//*Label 248*/ GIMT_Encode4(5443),
     /*   5318 */ /*GILLT_s64*//*Label 249*/ GIMT_Encode4(5552), GIMT_Encode4(0), GIMT_Encode4(0),
     /*   5330 */ /*GILLT_v4s32*//*Label 250*/ GIMT_Encode4(5661),
     /*   5334 */ // Label 247: @5334
     /*   5334 */ GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(5442),
     /*   5339 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
     /*   5342 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
     /*   5345 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::CRBITRCRegClassID),
     /*   5349 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(5389), // Rule ID 4925 //
     /*   5354 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5358 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5362 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*   5366 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*   5370 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   5374 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5376 */     // (or:{ *:[i1] } (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }), i1:{ *:[i1] }:$CRA)  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
     /*   5376 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRORC),
     /*   5379 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
     /*   5381 */     GIR_RootToRootCopy, /*OpIdx*/2, // CRA
     /*   5383 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
     /*   5387 */     GIR_RootConstrainSelectedInstOperands,
     /*   5388 */     // GIR_Coverage, 4925,
     /*   5388 */     GIR_EraseRootFromParent_Done,
     /*   5389 */   // Label 253: @5389
     /*   5389 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(5429), // Rule ID 183 //
     /*   5394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5402 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
     /*   5406 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
     /*   5410 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   5414 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5416 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, (xor:{ *:[i1] } i1:{ *:[i1] }:$CRB, -1:{ *:[i1] }))  =>  (CRORC:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
     /*   5416 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::CRORC),
     /*   5419 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[CRD]
     /*   5421 */     GIR_RootToRootCopy, /*OpIdx*/1, // CRA
     /*   5423 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // CRB
     /*   5427 */     GIR_RootConstrainSelectedInstOperands,
     /*   5428 */     // GIR_Coverage, 183,
     /*   5428 */     GIR_EraseRootFromParent_Done,
     /*   5429 */   // Label 254: @5429
     /*   5429 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(5441), // Rule ID 177 //
     /*   5434 */     // (or:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)  =>  (CROR:{ *:[i1] } i1:{ *:[i1] }:$CRA, i1:{ *:[i1] }:$CRB)
     /*   5434 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::CROR),
     /*   5439 */     GIR_RootConstrainSelectedInstOperands,
     /*   5440 */     // GIR_Coverage, 177,
     /*   5440 */     GIR_Done,
     /*   5441 */   // Label 255: @5441
     /*   5441 */   GIM_Reject,
     /*   5442 */ // Label 252: @5442
     /*   5442 */ GIM_Reject,
     /*   5443 */ // Label 248: @5443
     /*   5443 */ GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(5551),
     /*   5448 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*   5451 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*   5454 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::GPRCRegClassID),
     /*   5458 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(5498), // Rule ID 4919 //
     /*   5463 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5467 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5471 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5475 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5479 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   5483 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5485 */     // (or:{ *:[i32] } (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }), i32:{ *:[i32] }:$RST)  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
     /*   5485 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC),
     /*   5488 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   5490 */     GIR_RootToRootCopy, /*OpIdx*/2, // RST
     /*   5492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   5496 */     GIR_RootConstrainSelectedInstOperands,
     /*   5497 */     // GIR_Coverage, 4919,
     /*   5497 */     GIR_EraseRootFromParent_Done,
     /*   5498 */   // Label 257: @5498
     /*   5498 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(5538), // Rule ID 126 //
     /*   5503 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5507 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5511 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*   5515 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*   5519 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   5523 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5525 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, (xor:{ *:[i32] } i32:{ *:[i32] }:$RB, -1:{ *:[i32] }))  =>  (ORC:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
     /*   5525 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC),
     /*   5528 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   5530 */     GIR_RootToRootCopy, /*OpIdx*/1, // RST
     /*   5532 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   5536 */     GIR_RootConstrainSelectedInstOperands,
     /*   5537 */     // GIR_Coverage, 126,
     /*   5537 */     GIR_EraseRootFromParent_Done,
     /*   5538 */   // Label 258: @5538
     /*   5538 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(5550), // Rule ID 124 //
     /*   5543 */     // (or:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)  =>  (OR:{ *:[i32] } i32:{ *:[i32] }:$RST, i32:{ *:[i32] }:$RB)
     /*   5543 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR),
     /*   5548 */     GIR_RootConstrainSelectedInstOperands,
     /*   5549 */     // GIR_Coverage, 124,
     /*   5549 */     GIR_Done,
     /*   5550 */   // Label 259: @5550
     /*   5550 */   GIM_Reject,
     /*   5551 */ // Label 256: @5551
     /*   5551 */ GIM_Reject,
     /*   5552 */ // Label 249: @5552
     /*   5552 */ GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(5660),
     /*   5557 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*   5560 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   5563 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::G8RCRegClassID),
     /*   5567 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(5607), // Rule ID 4932 //
     /*   5572 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5576 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5580 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5584 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   5588 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   5592 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5594 */     // (or:{ *:[i64] } (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }), i64:{ *:[i64] }:$RST)  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
     /*   5594 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC8),
     /*   5597 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   5599 */     GIR_RootToRootCopy, /*OpIdx*/2, // RST
     /*   5601 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   5605 */     GIR_RootConstrainSelectedInstOperands,
     /*   5606 */     // GIR_Coverage, 4932,
     /*   5606 */     GIR_EraseRootFromParent_Done,
     /*   5607 */   // Label 261: @5607
     /*   5607 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(5647), // Rule ID 650 //
     /*   5612 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   5616 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5620 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   5624 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   5628 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
     /*   5632 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   5634 */     // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, (xor:{ *:[i64] } i64:{ *:[i64] }:$RB, -1:{ *:[i64] }))  =>  (ORC8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
     /*   5634 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::ORC8),
     /*   5637 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RA]
     /*   5639 */     GIR_RootToRootCopy, /*OpIdx*/1, // RST
     /*   5641 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // RB
     /*   5645 */     GIR_RootConstrainSelectedInstOperands,
     /*   5646 */     // GIR_Coverage, 650,
     /*   5646 */     GIR_EraseRootFromParent_Done,
     /*   5647 */   // Label 262: @5647
     /*   5647 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5659), // Rule ID 648 //
     /*   5652 */     // (or:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)  =>  (OR8:{ *:[i64] } i64:{ *:[i64] }:$RST, i64:{ *:[i64] }:$RB)
     /*   5652 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(PPC::OR8),
     /*   5657 */     GIR_RootConstrainSelectedInstOperands,
     /*   5658 */     // GIR_Coverage, 648,
     /*   5658 */     GIR_Done,
     /*   5659 */   // Label 263: @5659
     /*   5659 */   GIM_Reject,
     /*   5660 */ // Label 260: @5660
     /*   5660 */ GIM_Reject,
     /*   5661 */ // Label 250: @5661
     /*   5661 */ GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(48439),
     /*   5666 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5669 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5672 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5810), // Rule ID 4979 //
     /*   5677 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   5680 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   5684 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5688 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   5692 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5696 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5700 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5704 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   5708 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5712 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5716 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   5720 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5724 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5728 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5732 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   5736 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   5740 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5744 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   5748 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   5752 */     // MIs[5] vA
     /*   5752 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   5757 */     // MIs[5] vB
     /*   5757 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5762 */     // MIs[4] vC
     /*   5762 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   5767 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   5771 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   5777 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   5779 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   5781 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   5781 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   5784 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   5786 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   5790 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   5794 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   5798 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   5808 */     GIR_RootConstrainSelectedInstOperands,
     /*   5809 */     // GIR_Coverage, 4979,
     /*   5809 */     GIR_EraseRootFromParent_Done,
     /*   5810 */   // Label 265: @5810
     /*   5810 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5948), // Rule ID 4980 //
     /*   5815 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   5818 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   5822 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5826 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   5830 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5834 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5838 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5842 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   5846 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5850 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5854 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   5858 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   5862 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5866 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5870 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   5874 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   5878 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5882 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   5886 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   5890 */     // MIs[5] vB
     /*   5890 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   5895 */     // MIs[5] vA
     /*   5895 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   5900 */     // MIs[4] vC
     /*   5900 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   5905 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   5909 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   5915 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   5917 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   5919 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   5919 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   5922 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   5924 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   5928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   5932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   5936 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   5946 */     GIR_RootConstrainSelectedInstOperands,
     /*   5947 */     // GIR_Coverage, 4980,
     /*   5947 */     GIR_EraseRootFromParent_Done,
     /*   5948 */   // Label 266: @5948
     /*   5948 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(6086), // Rule ID 4981 //
     /*   5953 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   5956 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   5960 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   5964 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   5968 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5972 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5976 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   5980 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   5984 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   5988 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   5992 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   5996 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6000 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6004 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6008 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6012 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6016 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6020 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6024 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6028 */     // MIs[5] vA
     /*   6028 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6033 */     // MIs[5] vC
     /*   6033 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6038 */     // MIs[4] vB
     /*   6038 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6043 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6047 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6053 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6055 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6057 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6057 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6060 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6062 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   6066 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   6070 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6074 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6084 */     GIR_RootConstrainSelectedInstOperands,
     /*   6085 */     // GIR_Coverage, 4981,
     /*   6085 */     GIR_EraseRootFromParent_Done,
     /*   6086 */   // Label 267: @6086
     /*   6086 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(6224), // Rule ID 4982 //
     /*   6091 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6094 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6098 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6102 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6106 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6110 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6114 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6118 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6122 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6126 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6130 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6134 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6138 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6142 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6146 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6150 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6154 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6158 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6162 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6166 */     // MIs[5] vC
     /*   6166 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6171 */     // MIs[5] vA
     /*   6171 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6176 */     // MIs[4] vB
     /*   6176 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6181 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6185 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6191 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6193 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6195 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6195 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6198 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6200 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   6204 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   6208 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6212 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6222 */     GIR_RootConstrainSelectedInstOperands,
     /*   6223 */     // GIR_Coverage, 4982,
     /*   6223 */     GIR_EraseRootFromParent_Done,
     /*   6224 */   // Label 268: @6224
     /*   6224 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(6362), // Rule ID 4983 //
     /*   6229 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6232 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6236 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6240 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6244 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6248 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6252 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6256 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6260 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6264 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6268 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6272 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6276 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6280 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6284 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6288 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6292 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6296 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6300 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6304 */     // MIs[5] vB
     /*   6304 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6309 */     // MIs[5] vC
     /*   6309 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6314 */     // MIs[4] vA
     /*   6314 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6319 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6323 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6329 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6331 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6333 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6333 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6336 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6338 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   6342 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   6346 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6350 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6360 */     GIR_RootConstrainSelectedInstOperands,
     /*   6361 */     // GIR_Coverage, 4983,
     /*   6361 */     GIR_EraseRootFromParent_Done,
     /*   6362 */   // Label 269: @6362
     /*   6362 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(6500), // Rule ID 4984 //
     /*   6367 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6370 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6374 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6378 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6382 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6386 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6390 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6394 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6398 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6402 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6406 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6410 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6414 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6418 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6422 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6426 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6430 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6434 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6438 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6442 */     // MIs[5] vC
     /*   6442 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6447 */     // MIs[5] vB
     /*   6447 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6452 */     // MIs[4] vA
     /*   6452 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6457 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6461 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6467 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6469 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6471 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6471 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6474 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6476 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   6480 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   6484 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6488 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6498 */     GIR_RootConstrainSelectedInstOperands,
     /*   6499 */     // GIR_Coverage, 4984,
     /*   6499 */     GIR_EraseRootFromParent_Done,
     /*   6500 */   // Label 270: @6500
     /*   6500 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(6638), // Rule ID 4991 //
     /*   6505 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6508 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6512 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6516 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6520 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6524 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6528 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6532 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6536 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6540 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6544 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6548 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6552 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6556 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6560 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6564 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6568 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6572 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6576 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6580 */     // MIs[5] vA
     /*   6580 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6585 */     // MIs[5] vB
     /*   6585 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6590 */     // MIs[4] vC
     /*   6590 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6595 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6599 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6605 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6607 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6609 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6614 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   6618 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   6622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6626 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6636 */     GIR_RootConstrainSelectedInstOperands,
     /*   6637 */     // GIR_Coverage, 4991,
     /*   6637 */     GIR_EraseRootFromParent_Done,
     /*   6638 */   // Label 271: @6638
     /*   6638 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(6776), // Rule ID 4992 //
     /*   6643 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6650 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6654 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6658 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6662 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6666 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6670 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6674 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6678 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6682 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6686 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6690 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6694 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6698 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6702 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6706 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6710 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6714 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6718 */     // MIs[5] vB
     /*   6718 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6723 */     // MIs[5] vA
     /*   6723 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6728 */     // MIs[4] vC
     /*   6728 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6733 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6737 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6743 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6745 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6747 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6747 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6750 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6752 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   6756 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   6760 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6764 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6774 */     GIR_RootConstrainSelectedInstOperands,
     /*   6775 */     // GIR_Coverage, 4992,
     /*   6775 */     GIR_EraseRootFromParent_Done,
     /*   6776 */   // Label 272: @6776
     /*   6776 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(6914), // Rule ID 4993 //
     /*   6781 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6784 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6788 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6792 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6796 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6800 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6804 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6808 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6812 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6816 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6820 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6824 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6828 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6832 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6836 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6840 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6844 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6848 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6852 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6856 */     // MIs[5] vA
     /*   6856 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   6861 */     // MIs[5] vC
     /*   6861 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6866 */     // MIs[4] vB
     /*   6866 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   6871 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   6875 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   6881 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   6883 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   6885 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   6885 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   6888 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   6890 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   6894 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   6898 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   6902 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   6912 */     GIR_RootConstrainSelectedInstOperands,
     /*   6913 */     // GIR_Coverage, 4993,
     /*   6913 */     GIR_EraseRootFromParent_Done,
     /*   6914 */   // Label 273: @6914
     /*   6914 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(7052), // Rule ID 4994 //
     /*   6919 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   6922 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   6926 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   6930 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6934 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6938 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6942 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   6946 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   6950 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6954 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6958 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   6962 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   6966 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6970 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   6974 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   6978 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6982 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   6986 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   6990 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   6994 */     // MIs[5] vC
     /*   6994 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   6999 */     // MIs[5] vA
     /*   6999 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7004 */     // MIs[4] vB
     /*   7004 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7009 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7013 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7019 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7021 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7023 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7023 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7026 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7028 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   7032 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   7036 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   7040 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7050 */     GIR_RootConstrainSelectedInstOperands,
     /*   7051 */     // GIR_Coverage, 4994,
     /*   7051 */     GIR_EraseRootFromParent_Done,
     /*   7052 */   // Label 274: @7052
     /*   7052 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(7190), // Rule ID 4995 //
     /*   7057 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7060 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7064 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7068 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7072 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7076 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7080 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7084 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7088 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7092 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7096 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7100 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7104 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7108 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7112 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7116 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7120 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7124 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7128 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7132 */     // MIs[5] vB
     /*   7132 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7137 */     // MIs[5] vC
     /*   7137 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7142 */     // MIs[4] vA
     /*   7142 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7147 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7151 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7157 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7159 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7161 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7161 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7164 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7166 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   7170 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   7174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   7178 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7188 */     GIR_RootConstrainSelectedInstOperands,
     /*   7189 */     // GIR_Coverage, 4995,
     /*   7189 */     GIR_EraseRootFromParent_Done,
     /*   7190 */   // Label 275: @7190
     /*   7190 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(7328), // Rule ID 4996 //
     /*   7195 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7198 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7202 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7206 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7210 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7214 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7218 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7222 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7226 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7230 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7234 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7238 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7242 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7246 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7250 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7254 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7258 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7262 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7266 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7270 */     // MIs[5] vC
     /*   7270 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7275 */     // MIs[5] vB
     /*   7275 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7280 */     // MIs[4] vA
     /*   7280 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7285 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7289 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7295 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7297 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7299 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7299 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7302 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7304 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   7308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   7312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*   7316 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7326 */     GIR_RootConstrainSelectedInstOperands,
     /*   7327 */     // GIR_Coverage, 4996,
     /*   7327 */     GIR_EraseRootFromParent_Done,
     /*   7328 */   // Label 276: @7328
     /*   7328 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(7466), // Rule ID 5003 //
     /*   7333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7340 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7344 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7348 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7352 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7356 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7360 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7364 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7368 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7372 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7376 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7380 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7384 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7388 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7392 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7396 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7400 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7404 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7408 */     // MIs[5] vA
     /*   7408 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7413 */     // MIs[5] vB
     /*   7413 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7418 */     // MIs[4] vC
     /*   7418 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7423 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7427 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7433 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7435 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7437 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7437 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7440 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7442 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   7446 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   7450 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   7454 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7464 */     GIR_RootConstrainSelectedInstOperands,
     /*   7465 */     // GIR_Coverage, 5003,
     /*   7465 */     GIR_EraseRootFromParent_Done,
     /*   7466 */   // Label 277: @7466
     /*   7466 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(7604), // Rule ID 5004 //
     /*   7471 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7474 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7478 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7482 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7486 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7490 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7494 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7498 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7502 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7506 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7510 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7514 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7518 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7522 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7526 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7530 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7534 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7538 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7542 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7546 */     // MIs[5] vB
     /*   7546 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7551 */     // MIs[5] vA
     /*   7551 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7556 */     // MIs[4] vC
     /*   7556 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7561 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7565 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7571 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7573 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7575 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7575 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7578 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7580 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   7584 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   7588 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   7592 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7602 */     GIR_RootConstrainSelectedInstOperands,
     /*   7603 */     // GIR_Coverage, 5004,
     /*   7603 */     GIR_EraseRootFromParent_Done,
     /*   7604 */   // Label 278: @7604
     /*   7604 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(7742), // Rule ID 5005 //
     /*   7609 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7612 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7616 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7620 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7624 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7628 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7632 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7636 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7640 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7644 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7648 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7652 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7656 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7660 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7664 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7668 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7672 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7676 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7680 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7684 */     // MIs[5] vA
     /*   7684 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7689 */     // MIs[5] vC
     /*   7689 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7694 */     // MIs[4] vB
     /*   7694 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7699 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7703 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7709 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7711 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7713 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7713 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7716 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7718 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   7722 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   7726 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   7730 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7740 */     GIR_RootConstrainSelectedInstOperands,
     /*   7741 */     // GIR_Coverage, 5005,
     /*   7741 */     GIR_EraseRootFromParent_Done,
     /*   7742 */   // Label 279: @7742
     /*   7742 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(7880), // Rule ID 5006 //
     /*   7747 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7750 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7754 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7758 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7762 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7766 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7770 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7774 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7778 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7782 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7786 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7790 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7794 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7798 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7802 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7806 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7810 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7814 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7818 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7822 */     // MIs[5] vC
     /*   7822 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7827 */     // MIs[5] vA
     /*   7827 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7832 */     // MIs[4] vB
     /*   7832 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7837 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7841 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7847 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7849 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7851 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7851 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7854 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7856 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   7860 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   7864 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   7868 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   7878 */     GIR_RootConstrainSelectedInstOperands,
     /*   7879 */     // GIR_Coverage, 5006,
     /*   7879 */     GIR_EraseRootFromParent_Done,
     /*   7880 */   // Label 280: @7880
     /*   7880 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(8018), // Rule ID 5007 //
     /*   7885 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   7888 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   7892 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   7896 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7900 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7904 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7908 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   7912 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   7916 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7920 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7924 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   7928 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   7932 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7936 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   7940 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   7944 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7948 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   7952 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   7956 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   7960 */     // MIs[5] vB
     /*   7960 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   7965 */     // MIs[5] vC
     /*   7965 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   7970 */     // MIs[4] vA
     /*   7970 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   7975 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   7979 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   7985 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   7987 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   7989 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   7989 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   7992 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   7994 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   7998 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8002 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   8006 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8016 */     GIR_RootConstrainSelectedInstOperands,
     /*   8017 */     // GIR_Coverage, 5007,
     /*   8017 */     GIR_EraseRootFromParent_Done,
     /*   8018 */   // Label 281: @8018
     /*   8018 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(8156), // Rule ID 5008 //
     /*   8023 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8026 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8030 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8034 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8038 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8042 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8046 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8050 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8054 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8058 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8062 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8066 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8070 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8074 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8078 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8082 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8086 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8090 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8094 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8098 */     // MIs[5] vC
     /*   8098 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8103 */     // MIs[5] vB
     /*   8103 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8108 */     // MIs[4] vA
     /*   8108 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8113 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8117 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8123 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8125 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8127 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8127 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8130 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8132 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*   8136 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8140 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   8144 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8154 */     GIR_RootConstrainSelectedInstOperands,
     /*   8155 */     // GIR_Coverage, 5008,
     /*   8155 */     GIR_EraseRootFromParent_Done,
     /*   8156 */   // Label 282: @8156
     /*   8156 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(8294), // Rule ID 5015 //
     /*   8161 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8164 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8168 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8172 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8176 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8180 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8184 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8188 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8192 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8196 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8200 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8204 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8208 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8212 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8216 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8220 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8224 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8228 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8232 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8236 */     // MIs[5] vA
     /*   8236 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8241 */     // MIs[5] vB
     /*   8241 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8246 */     // MIs[4] vC
     /*   8246 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8251 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8255 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8261 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8263 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8265 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8265 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8268 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8270 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   8274 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8278 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   8282 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8292 */     GIR_RootConstrainSelectedInstOperands,
     /*   8293 */     // GIR_Coverage, 5015,
     /*   8293 */     GIR_EraseRootFromParent_Done,
     /*   8294 */   // Label 283: @8294
     /*   8294 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(8432), // Rule ID 5016 //
     /*   8299 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8302 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8306 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8310 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8314 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8318 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8322 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8326 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8330 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8334 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8338 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8342 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8346 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8350 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8354 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8358 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8362 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8366 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8370 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8374 */     // MIs[5] vB
     /*   8374 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8379 */     // MIs[5] vA
     /*   8379 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8384 */     // MIs[4] vC
     /*   8384 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8389 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8393 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8399 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8401 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8403 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8403 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8406 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8408 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   8412 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8416 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   8420 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8430 */     GIR_RootConstrainSelectedInstOperands,
     /*   8431 */     // GIR_Coverage, 5016,
     /*   8431 */     GIR_EraseRootFromParent_Done,
     /*   8432 */   // Label 284: @8432
     /*   8432 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(8570), // Rule ID 5017 //
     /*   8437 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8440 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8444 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8448 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8452 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8456 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8460 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8464 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8468 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8472 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8476 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8480 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8484 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8488 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8492 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8496 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8500 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8504 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8508 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8512 */     // MIs[5] vA
     /*   8512 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8517 */     // MIs[5] vC
     /*   8517 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8522 */     // MIs[4] vB
     /*   8522 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8527 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8531 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8537 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8539 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8541 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8541 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8544 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8546 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   8550 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8554 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   8558 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8568 */     GIR_RootConstrainSelectedInstOperands,
     /*   8569 */     // GIR_Coverage, 5017,
     /*   8569 */     GIR_EraseRootFromParent_Done,
     /*   8570 */   // Label 285: @8570
     /*   8570 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(8708), // Rule ID 5018 //
     /*   8575 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8578 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8582 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8586 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8590 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8594 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8598 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8602 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8606 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8610 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8614 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8618 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8622 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8626 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8630 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8634 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8638 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8642 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8646 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8650 */     // MIs[5] vC
     /*   8650 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8655 */     // MIs[5] vA
     /*   8655 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8660 */     // MIs[4] vB
     /*   8660 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8665 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8669 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8675 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8677 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8679 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8679 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8682 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8684 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   8688 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8692 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   8696 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8706 */     GIR_RootConstrainSelectedInstOperands,
     /*   8707 */     // GIR_Coverage, 5018,
     /*   8707 */     GIR_EraseRootFromParent_Done,
     /*   8708 */   // Label 286: @8708
     /*   8708 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(8846), // Rule ID 5019 //
     /*   8713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8720 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8724 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8728 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8732 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8736 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8740 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8744 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8748 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8752 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8756 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8760 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8764 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8768 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8772 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8776 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8780 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8784 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8788 */     // MIs[5] vB
     /*   8788 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8793 */     // MIs[5] vC
     /*   8793 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8798 */     // MIs[4] vA
     /*   8798 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8803 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8807 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8813 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8815 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8817 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8817 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8820 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8822 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   8826 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8830 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   8834 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8844 */     GIR_RootConstrainSelectedInstOperands,
     /*   8845 */     // GIR_Coverage, 5019,
     /*   8845 */     GIR_EraseRootFromParent_Done,
     /*   8846 */   // Label 287: @8846
     /*   8846 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(8984), // Rule ID 5020 //
     /*   8851 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8854 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8858 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   8862 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8866 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8870 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8874 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   8878 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   8882 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8886 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8890 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   8894 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   8898 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8902 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   8906 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   8910 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8914 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   8918 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   8922 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   8926 */     // MIs[5] vC
     /*   8926 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   8931 */     // MIs[5] vB
     /*   8931 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   8936 */     // MIs[4] vA
     /*   8936 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   8941 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   8945 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   8951 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   8953 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   8955 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   8955 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   8958 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   8960 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*   8964 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*   8968 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   8972 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   8982 */     GIR_RootConstrainSelectedInstOperands,
     /*   8983 */     // GIR_Coverage, 5020,
     /*   8983 */     GIR_EraseRootFromParent_Done,
     /*   8984 */   // Label 288: @8984
     /*   8984 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(9122), // Rule ID 5027 //
     /*   8989 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   8992 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   8996 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9000 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9004 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9008 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9012 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9016 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9020 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9024 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9028 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9032 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9036 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9040 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9044 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9048 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9052 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9056 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9060 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9064 */     // MIs[5] vA
     /*   9064 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9069 */     // MIs[5] vB
     /*   9069 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9074 */     // MIs[4] vC
     /*   9074 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9079 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9083 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9089 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9091 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9093 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9093 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9096 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9098 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9102 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   9106 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   9110 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9120 */     GIR_RootConstrainSelectedInstOperands,
     /*   9121 */     // GIR_Coverage, 5027,
     /*   9121 */     GIR_EraseRootFromParent_Done,
     /*   9122 */   // Label 289: @9122
     /*   9122 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(9260), // Rule ID 5028 //
     /*   9127 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9130 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9134 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9138 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9142 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9146 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9150 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9154 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9158 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9162 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9166 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9170 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9174 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9178 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9182 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9186 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9190 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9194 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9198 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9202 */     // MIs[5] vB
     /*   9202 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9207 */     // MIs[5] vA
     /*   9207 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9212 */     // MIs[4] vC
     /*   9212 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9217 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9221 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9227 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9229 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9231 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9231 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9234 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9236 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9240 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   9244 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   9248 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9258 */     GIR_RootConstrainSelectedInstOperands,
     /*   9259 */     // GIR_Coverage, 5028,
     /*   9259 */     GIR_EraseRootFromParent_Done,
     /*   9260 */   // Label 290: @9260
     /*   9260 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(9398), // Rule ID 5029 //
     /*   9265 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9268 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9272 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9276 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9280 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9284 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9288 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9292 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9296 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9300 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9304 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9308 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9312 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9316 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9320 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9324 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9328 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9332 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9336 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9340 */     // MIs[5] vA
     /*   9340 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9345 */     // MIs[5] vC
     /*   9345 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9350 */     // MIs[4] vB
     /*   9350 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9355 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9359 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9365 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9367 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9369 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9369 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9372 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9374 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9378 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   9382 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   9386 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9396 */     GIR_RootConstrainSelectedInstOperands,
     /*   9397 */     // GIR_Coverage, 5029,
     /*   9397 */     GIR_EraseRootFromParent_Done,
     /*   9398 */   // Label 291: @9398
     /*   9398 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(9536), // Rule ID 5030 //
     /*   9403 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9406 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9410 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9414 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9418 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9422 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9426 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9430 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9434 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9438 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9442 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9446 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9450 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9454 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9458 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9462 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9466 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9470 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9474 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9478 */     // MIs[5] vC
     /*   9478 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9483 */     // MIs[5] vA
     /*   9483 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9488 */     // MIs[4] vB
     /*   9488 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9493 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9497 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9503 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9505 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9507 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9507 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9510 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9512 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9516 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   9520 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   9524 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9534 */     GIR_RootConstrainSelectedInstOperands,
     /*   9535 */     // GIR_Coverage, 5030,
     /*   9535 */     GIR_EraseRootFromParent_Done,
     /*   9536 */   // Label 292: @9536
     /*   9536 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(9674), // Rule ID 5031 //
     /*   9541 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9544 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9548 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9552 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9556 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9560 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9564 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9568 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9572 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9576 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9580 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9584 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9588 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9592 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9596 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9600 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9604 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9608 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9612 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9616 */     // MIs[5] vB
     /*   9616 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9621 */     // MIs[5] vC
     /*   9621 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9626 */     // MIs[4] vA
     /*   9626 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9631 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9635 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9641 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9643 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9645 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9645 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9648 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9650 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9654 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   9658 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   9662 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9672 */     GIR_RootConstrainSelectedInstOperands,
     /*   9673 */     // GIR_Coverage, 5031,
     /*   9673 */     GIR_EraseRootFromParent_Done,
     /*   9674 */   // Label 293: @9674
     /*   9674 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(9812), // Rule ID 5032 //
     /*   9679 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9682 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9686 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9690 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9694 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9698 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9702 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9706 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9710 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9714 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9718 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9722 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9726 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9730 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9734 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9738 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9742 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9746 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9750 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9754 */     // MIs[5] vC
     /*   9754 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9759 */     // MIs[5] vB
     /*   9759 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9764 */     // MIs[4] vA
     /*   9764 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9769 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9773 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9779 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9781 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9783 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9783 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9786 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9788 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9792 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*   9796 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*   9800 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9810 */     GIR_RootConstrainSelectedInstOperands,
     /*   9811 */     // GIR_Coverage, 5032,
     /*   9811 */     GIR_EraseRootFromParent_Done,
     /*   9812 */   // Label 294: @9812
     /*   9812 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(9950), // Rule ID 5039 //
     /*   9817 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9820 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9824 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9828 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9832 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9836 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9840 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9844 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9848 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9852 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9856 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9860 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*   9864 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9868 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9872 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*   9876 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9880 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9884 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*   9888 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*   9892 */     // MIs[5] vA
     /*   9892 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*   9897 */     // MIs[5] vB
     /*   9897 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*   9902 */     // MIs[4] vC
     /*   9902 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*   9907 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*   9911 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*   9917 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*   9919 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*   9921 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*   9921 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*   9924 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*   9926 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*   9930 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*   9934 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*   9938 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*   9948 */     GIR_RootConstrainSelectedInstOperands,
     /*   9949 */     // GIR_Coverage, 5039,
     /*   9949 */     GIR_EraseRootFromParent_Done,
     /*   9950 */   // Label 295: @9950
     /*   9950 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(10088), // Rule ID 5040 //
     /*   9955 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*   9958 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*   9962 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   9966 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9970 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9974 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9978 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   9982 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*   9986 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*   9990 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*   9994 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*   9998 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10002 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10006 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10010 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10014 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10018 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10022 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  10026 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10030 */     // MIs[5] vB
     /*  10030 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10035 */     // MIs[5] vA
     /*  10035 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10040 */     // MIs[4] vC
     /*  10040 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10045 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10049 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10055 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10057 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10059 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10059 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10062 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10064 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  10068 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10072 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  10076 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10086 */     GIR_RootConstrainSelectedInstOperands,
     /*  10087 */     // GIR_Coverage, 5040,
     /*  10087 */     GIR_EraseRootFromParent_Done,
     /*  10088 */   // Label 296: @10088
     /*  10088 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(10226), // Rule ID 5041 //
     /*  10093 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10096 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10100 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10104 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10108 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10112 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10116 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10120 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10124 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10128 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10132 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10136 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10140 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10144 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10148 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10152 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10156 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10160 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  10164 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10168 */     // MIs[5] vA
     /*  10168 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10173 */     // MIs[5] vC
     /*  10173 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10178 */     // MIs[4] vB
     /*  10178 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10183 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10187 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10193 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10195 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10197 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10197 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10200 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10202 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  10206 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10210 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  10214 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10224 */     GIR_RootConstrainSelectedInstOperands,
     /*  10225 */     // GIR_Coverage, 5041,
     /*  10225 */     GIR_EraseRootFromParent_Done,
     /*  10226 */   // Label 297: @10226
     /*  10226 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(10364), // Rule ID 5042 //
     /*  10231 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10234 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10238 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10242 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10246 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10250 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10254 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10258 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10262 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10266 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10270 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10274 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10278 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10282 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10286 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10290 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10294 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10298 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  10302 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10306 */     // MIs[5] vC
     /*  10306 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10311 */     // MIs[5] vA
     /*  10311 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10316 */     // MIs[4] vB
     /*  10316 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10321 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10325 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10331 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10333 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10335 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10335 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10338 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10340 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  10344 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10348 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  10352 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10362 */     GIR_RootConstrainSelectedInstOperands,
     /*  10363 */     // GIR_Coverage, 5042,
     /*  10363 */     GIR_EraseRootFromParent_Done,
     /*  10364 */   // Label 298: @10364
     /*  10364 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(10502), // Rule ID 5043 //
     /*  10369 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10372 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10376 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10380 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10384 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10388 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10392 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10396 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10400 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10404 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10408 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10412 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10416 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10420 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10424 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10428 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10432 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10436 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  10440 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10444 */     // MIs[5] vB
     /*  10444 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10449 */     // MIs[5] vC
     /*  10449 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10454 */     // MIs[4] vA
     /*  10454 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10459 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10463 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10469 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10471 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10473 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10473 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10476 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10478 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  10482 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  10490 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10500 */     GIR_RootConstrainSelectedInstOperands,
     /*  10501 */     // GIR_Coverage, 5043,
     /*  10501 */     GIR_EraseRootFromParent_Done,
     /*  10502 */   // Label 299: @10502
     /*  10502 */   GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(10640), // Rule ID 5044 //
     /*  10507 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10510 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10514 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10518 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10522 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10526 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10530 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10534 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10538 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10542 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10546 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10550 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10554 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10558 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10562 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10566 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10570 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10574 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  10578 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10582 */     // MIs[5] vC
     /*  10582 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10587 */     // MIs[5] vB
     /*  10587 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10592 */     // MIs[4] vA
     /*  10592 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10597 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10601 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10607 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10609 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10611 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10611 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10614 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10616 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  10620 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10624 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  10628 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10638 */     GIR_RootConstrainSelectedInstOperands,
     /*  10639 */     // GIR_Coverage, 5044,
     /*  10639 */     GIR_EraseRootFromParent_Done,
     /*  10640 */   // Label 300: @10640
     /*  10640 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(10778), // Rule ID 4985 //
     /*  10645 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10648 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10652 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10656 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10660 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10664 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10668 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10672 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10676 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10680 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10684 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10688 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10692 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10696 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10700 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10704 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10708 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10712 */     // MIs[4] vC
     /*  10712 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10717 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  10721 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10725 */     // MIs[5] vA
     /*  10725 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10730 */     // MIs[5] vB
     /*  10730 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10735 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10739 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10745 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10747 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10749 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10749 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10752 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10754 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  10758 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10762 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  10766 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10776 */     GIR_RootConstrainSelectedInstOperands,
     /*  10777 */     // GIR_Coverage, 4985,
     /*  10777 */     GIR_EraseRootFromParent_Done,
     /*  10778 */   // Label 301: @10778
     /*  10778 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(10916), // Rule ID 4986 //
     /*  10783 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10786 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10790 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10794 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10798 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10802 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10806 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10810 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10814 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10818 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10822 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10826 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10830 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10834 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10838 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10842 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10846 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10850 */     // MIs[4] vC
     /*  10850 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  10855 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  10859 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10863 */     // MIs[5] vB
     /*  10863 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10868 */     // MIs[5] vA
     /*  10868 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  10873 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  10877 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  10883 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  10885 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  10887 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  10887 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  10890 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  10892 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  10896 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  10900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  10904 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  10914 */     GIR_RootConstrainSelectedInstOperands,
     /*  10915 */     // GIR_Coverage, 4986,
     /*  10915 */     GIR_EraseRootFromParent_Done,
     /*  10916 */   // Label 302: @10916
     /*  10916 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(11054), // Rule ID 4987 //
     /*  10921 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  10924 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  10928 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  10932 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10936 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10940 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10944 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  10948 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  10952 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10956 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10960 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  10964 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  10968 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  10972 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10976 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  10980 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  10984 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  10988 */     // MIs[4] vB
     /*  10988 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  10993 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  10997 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11001 */     // MIs[5] vA
     /*  11001 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11006 */     // MIs[5] vC
     /*  11006 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11011 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11015 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11021 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11023 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11025 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11025 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11028 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11030 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  11034 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  11038 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11042 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11052 */     GIR_RootConstrainSelectedInstOperands,
     /*  11053 */     // GIR_Coverage, 4987,
     /*  11053 */     GIR_EraseRootFromParent_Done,
     /*  11054 */   // Label 303: @11054
     /*  11054 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(11192), // Rule ID 4988 //
     /*  11059 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11062 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11066 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11070 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11074 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11078 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11082 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11086 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11090 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11094 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11098 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11102 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11106 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11110 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11114 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11118 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11122 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11126 */     // MIs[4] vB
     /*  11126 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11131 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11135 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11139 */     // MIs[5] vC
     /*  11139 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11144 */     // MIs[5] vA
     /*  11144 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11149 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11153 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11159 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11161 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11163 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11163 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11166 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11168 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  11172 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  11176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11180 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11190 */     GIR_RootConstrainSelectedInstOperands,
     /*  11191 */     // GIR_Coverage, 4988,
     /*  11191 */     GIR_EraseRootFromParent_Done,
     /*  11192 */   // Label 304: @11192
     /*  11192 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(11330), // Rule ID 4989 //
     /*  11197 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11200 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11204 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11208 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11212 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11216 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11220 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11224 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11228 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11232 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11236 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11240 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11244 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11248 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11252 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11256 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11260 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11264 */     // MIs[4] vA
     /*  11264 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11269 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11273 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11277 */     // MIs[5] vB
     /*  11277 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11282 */     // MIs[5] vC
     /*  11282 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11287 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11291 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11297 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11299 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11301 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11306 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  11310 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  11314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11318 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11328 */     GIR_RootConstrainSelectedInstOperands,
     /*  11329 */     // GIR_Coverage, 4989,
     /*  11329 */     GIR_EraseRootFromParent_Done,
     /*  11330 */   // Label 305: @11330
     /*  11330 */   GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(11468), // Rule ID 4990 //
     /*  11335 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11338 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11342 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11346 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11350 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11354 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11358 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11362 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11366 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11370 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11374 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11378 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11382 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11386 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11390 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11394 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11398 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11402 */     // MIs[4] vA
     /*  11402 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11407 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11411 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11415 */     // MIs[5] vC
     /*  11415 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11420 */     // MIs[5] vB
     /*  11420 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11425 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11429 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11435 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11437 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11439 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11439 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11442 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11444 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  11448 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  11452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11456 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11466 */     GIR_RootConstrainSelectedInstOperands,
     /*  11467 */     // GIR_Coverage, 4990,
     /*  11467 */     GIR_EraseRootFromParent_Done,
     /*  11468 */   // Label 306: @11468
     /*  11468 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(11606), // Rule ID 4997 //
     /*  11473 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11476 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11480 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11484 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11488 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11492 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11496 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11500 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11504 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11508 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11512 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11516 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11520 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11524 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11528 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11532 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11536 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11540 */     // MIs[4] vC
     /*  11540 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11545 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11549 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11553 */     // MIs[5] vA
     /*  11553 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11558 */     // MIs[5] vB
     /*  11558 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11563 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11567 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11573 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11575 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11577 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11577 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11580 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11582 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  11586 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  11590 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11594 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11604 */     GIR_RootConstrainSelectedInstOperands,
     /*  11605 */     // GIR_Coverage, 4997,
     /*  11605 */     GIR_EraseRootFromParent_Done,
     /*  11606 */   // Label 307: @11606
     /*  11606 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(11744), // Rule ID 4998 //
     /*  11611 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11614 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11618 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11622 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11626 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11630 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11634 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11638 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11642 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11646 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11650 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11654 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11658 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11662 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11666 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11670 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11674 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11678 */     // MIs[4] vC
     /*  11678 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11683 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11687 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11691 */     // MIs[5] vB
     /*  11691 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11696 */     // MIs[5] vA
     /*  11696 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11701 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11705 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11711 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11713 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11715 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11715 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11718 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11720 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  11724 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  11728 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11732 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11742 */     GIR_RootConstrainSelectedInstOperands,
     /*  11743 */     // GIR_Coverage, 4998,
     /*  11743 */     GIR_EraseRootFromParent_Done,
     /*  11744 */   // Label 308: @11744
     /*  11744 */   GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(11882), // Rule ID 4999 //
     /*  11749 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11752 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11756 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11760 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11764 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11768 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11772 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11776 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11780 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11784 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11788 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11792 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11796 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11800 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11804 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11808 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11812 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11816 */     // MIs[4] vB
     /*  11816 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11821 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11825 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11829 */     // MIs[5] vA
     /*  11829 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11834 */     // MIs[5] vC
     /*  11834 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11839 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11843 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11849 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11851 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11853 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11853 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11856 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11858 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  11862 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  11866 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  11870 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  11880 */     GIR_RootConstrainSelectedInstOperands,
     /*  11881 */     // GIR_Coverage, 4999,
     /*  11881 */     GIR_EraseRootFromParent_Done,
     /*  11882 */   // Label 309: @11882
     /*  11882 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(12020), // Rule ID 5000 //
     /*  11887 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  11890 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  11894 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  11898 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11902 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11906 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11910 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  11914 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  11918 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11922 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11926 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  11930 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  11934 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  11938 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11942 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  11946 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11950 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  11954 */     // MIs[4] vB
     /*  11954 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  11959 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  11963 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  11967 */     // MIs[5] vC
     /*  11967 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  11972 */     // MIs[5] vA
     /*  11972 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  11977 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  11981 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  11987 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  11989 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  11991 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  11991 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  11994 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  11996 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  12000 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  12004 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  12008 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12018 */     GIR_RootConstrainSelectedInstOperands,
     /*  12019 */     // GIR_Coverage, 5000,
     /*  12019 */     GIR_EraseRootFromParent_Done,
     /*  12020 */   // Label 310: @12020
     /*  12020 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(12158), // Rule ID 5001 //
     /*  12025 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12028 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12032 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12036 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12040 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12044 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12048 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12052 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12056 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12060 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12064 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12068 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12072 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12076 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12080 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12084 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12088 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12092 */     // MIs[4] vA
     /*  12092 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12097 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12101 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12105 */     // MIs[5] vB
     /*  12105 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12110 */     // MIs[5] vC
     /*  12110 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12115 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12119 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12125 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12127 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12129 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12129 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12132 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12134 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  12138 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  12142 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  12146 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12156 */     GIR_RootConstrainSelectedInstOperands,
     /*  12157 */     // GIR_Coverage, 5001,
     /*  12157 */     GIR_EraseRootFromParent_Done,
     /*  12158 */   // Label 311: @12158
     /*  12158 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(12296), // Rule ID 5002 //
     /*  12163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12166 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12170 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12174 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12178 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12182 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12186 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12190 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12194 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12198 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12202 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12206 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12210 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12214 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12218 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12222 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12226 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12230 */     // MIs[4] vA
     /*  12230 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12235 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12239 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12243 */     // MIs[5] vC
     /*  12243 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12248 */     // MIs[5] vB
     /*  12248 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12253 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12257 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12263 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12265 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12267 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12267 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12270 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12272 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  12276 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  12280 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vC
     /*  12284 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12294 */     GIR_RootConstrainSelectedInstOperands,
     /*  12295 */     // GIR_Coverage, 5002,
     /*  12295 */     GIR_EraseRootFromParent_Done,
     /*  12296 */   // Label 312: @12296
     /*  12296 */   GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(12434), // Rule ID 5009 //
     /*  12301 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12304 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12308 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12312 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12316 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12320 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12324 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12328 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12332 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12336 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12340 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12344 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12348 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12352 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12356 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12360 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12364 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12368 */     // MIs[4] vC
     /*  12368 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12373 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12377 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12381 */     // MIs[5] vA
     /*  12381 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12386 */     // MIs[5] vB
     /*  12386 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12391 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12395 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12401 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12403 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12405 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12405 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12408 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12410 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  12414 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  12418 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  12422 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12432 */     GIR_RootConstrainSelectedInstOperands,
     /*  12433 */     // GIR_Coverage, 5009,
     /*  12433 */     GIR_EraseRootFromParent_Done,
     /*  12434 */   // Label 313: @12434
     /*  12434 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(12572), // Rule ID 5010 //
     /*  12439 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12442 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12446 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12450 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12454 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12458 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12462 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12466 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12470 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12474 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12478 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12482 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12486 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12490 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12494 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12498 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12502 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12506 */     // MIs[4] vC
     /*  12506 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12511 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12515 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12519 */     // MIs[5] vB
     /*  12519 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12524 */     // MIs[5] vA
     /*  12524 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12529 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12533 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12539 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12541 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12543 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12543 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12546 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12548 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  12552 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  12556 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  12560 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12570 */     GIR_RootConstrainSelectedInstOperands,
     /*  12571 */     // GIR_Coverage, 5010,
     /*  12571 */     GIR_EraseRootFromParent_Done,
     /*  12572 */   // Label 314: @12572
     /*  12572 */   GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(12710), // Rule ID 5011 //
     /*  12577 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12580 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12584 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12588 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12592 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12596 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12600 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12604 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12608 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12612 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12616 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12620 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12624 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12628 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12632 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12636 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12640 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12644 */     // MIs[4] vB
     /*  12644 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12649 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12653 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12657 */     // MIs[5] vA
     /*  12657 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12662 */     // MIs[5] vC
     /*  12662 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12667 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12671 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12677 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12679 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12681 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12681 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12684 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12686 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  12690 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  12694 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  12698 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12708 */     GIR_RootConstrainSelectedInstOperands,
     /*  12709 */     // GIR_Coverage, 5011,
     /*  12709 */     GIR_EraseRootFromParent_Done,
     /*  12710 */   // Label 315: @12710
     /*  12710 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(12848), // Rule ID 5012 //
     /*  12715 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12718 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12722 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12726 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12730 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12734 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12738 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12742 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12746 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12750 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12754 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12758 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12762 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12766 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12770 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12774 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12778 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12782 */     // MIs[4] vB
     /*  12782 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12787 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12791 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12795 */     // MIs[5] vC
     /*  12795 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12800 */     // MIs[5] vA
     /*  12800 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12805 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12809 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12815 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12817 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12819 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12819 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12822 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12824 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  12828 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  12832 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  12836 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12846 */     GIR_RootConstrainSelectedInstOperands,
     /*  12847 */     // GIR_Coverage, 5012,
     /*  12847 */     GIR_EraseRootFromParent_Done,
     /*  12848 */   // Label 316: @12848
     /*  12848 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(12986), // Rule ID 5013 //
     /*  12853 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12856 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12860 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  12864 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12868 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12872 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12876 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  12880 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  12884 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12888 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12892 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  12896 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  12900 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  12904 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12908 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  12912 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12916 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  12920 */     // MIs[4] vA
     /*  12920 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  12925 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  12929 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  12933 */     // MIs[5] vB
     /*  12933 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  12938 */     // MIs[5] vC
     /*  12938 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  12943 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  12947 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  12953 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  12955 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  12957 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  12957 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  12960 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  12962 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  12966 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  12970 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  12974 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  12984 */     GIR_RootConstrainSelectedInstOperands,
     /*  12985 */     // GIR_Coverage, 5013,
     /*  12985 */     GIR_EraseRootFromParent_Done,
     /*  12986 */   // Label 317: @12986
     /*  12986 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(13124), // Rule ID 5014 //
     /*  12991 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  12994 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  12998 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13002 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13006 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13010 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13014 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13018 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13022 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13026 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13030 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13034 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13038 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13042 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13046 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13050 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13054 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13058 */     // MIs[4] vA
     /*  13058 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13063 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13067 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13071 */     // MIs[5] vC
     /*  13071 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13076 */     // MIs[5] vB
     /*  13076 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13081 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13085 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13091 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13093 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13095 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13095 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13098 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13100 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  13104 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13108 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  13112 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13122 */     GIR_RootConstrainSelectedInstOperands,
     /*  13123 */     // GIR_Coverage, 5014,
     /*  13123 */     GIR_EraseRootFromParent_Done,
     /*  13124 */   // Label 318: @13124
     /*  13124 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(13262), // Rule ID 5021 //
     /*  13129 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13132 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13136 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13140 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13144 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13148 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13152 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13156 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13160 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13164 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13168 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13172 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13176 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13180 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13184 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13188 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13192 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13196 */     // MIs[4] vC
     /*  13196 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13201 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13205 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13209 */     // MIs[5] vA
     /*  13209 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13214 */     // MIs[5] vB
     /*  13214 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13219 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13223 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13229 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13231 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13233 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13233 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13236 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13238 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  13242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  13250 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13260 */     GIR_RootConstrainSelectedInstOperands,
     /*  13261 */     // GIR_Coverage, 5021,
     /*  13261 */     GIR_EraseRootFromParent_Done,
     /*  13262 */   // Label 319: @13262
     /*  13262 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(13400), // Rule ID 5022 //
     /*  13267 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13270 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13274 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13278 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13282 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13286 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13290 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13294 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13298 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13302 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13306 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13310 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13314 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13318 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13322 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13326 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13330 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13334 */     // MIs[4] vC
     /*  13334 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13339 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13343 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13347 */     // MIs[5] vB
     /*  13347 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13352 */     // MIs[5] vA
     /*  13352 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13357 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13361 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13367 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13369 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13371 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13371 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13374 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13376 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  13380 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13384 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  13388 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13398 */     GIR_RootConstrainSelectedInstOperands,
     /*  13399 */     // GIR_Coverage, 5022,
     /*  13399 */     GIR_EraseRootFromParent_Done,
     /*  13400 */   // Label 320: @13400
     /*  13400 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(13538), // Rule ID 5023 //
     /*  13405 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13408 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13412 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13416 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13420 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13424 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13428 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13432 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13436 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13440 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13444 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13448 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13452 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13456 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13460 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13464 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13468 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13472 */     // MIs[4] vB
     /*  13472 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13477 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13481 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13485 */     // MIs[5] vA
     /*  13485 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13490 */     // MIs[5] vC
     /*  13490 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13495 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13499 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13505 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13507 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13509 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13509 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13512 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13514 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  13518 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  13526 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13536 */     GIR_RootConstrainSelectedInstOperands,
     /*  13537 */     // GIR_Coverage, 5023,
     /*  13537 */     GIR_EraseRootFromParent_Done,
     /*  13538 */   // Label 321: @13538
     /*  13538 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(13676), // Rule ID 5024 //
     /*  13543 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13546 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13550 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13554 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13558 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13562 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13566 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13570 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13574 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13578 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13582 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13586 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13590 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13594 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13598 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13602 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13606 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13610 */     // MIs[4] vB
     /*  13610 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13615 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13619 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13623 */     // MIs[5] vC
     /*  13623 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13628 */     // MIs[5] vA
     /*  13628 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13633 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13637 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13643 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13645 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13647 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13647 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13650 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13652 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  13656 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13660 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  13664 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13674 */     GIR_RootConstrainSelectedInstOperands,
     /*  13675 */     // GIR_Coverage, 5024,
     /*  13675 */     GIR_EraseRootFromParent_Done,
     /*  13676 */   // Label 322: @13676
     /*  13676 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(13814), // Rule ID 5025 //
     /*  13681 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13684 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13688 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13692 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13696 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13700 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13704 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13708 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13712 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13716 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13720 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13724 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13728 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13732 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13736 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13740 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13744 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13748 */     // MIs[4] vA
     /*  13748 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13753 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13757 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13761 */     // MIs[5] vB
     /*  13761 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13766 */     // MIs[5] vC
     /*  13766 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13771 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13775 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13781 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13783 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13785 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13785 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13788 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13790 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  13794 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13798 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  13802 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13812 */     GIR_RootConstrainSelectedInstOperands,
     /*  13813 */     // GIR_Coverage, 5025,
     /*  13813 */     GIR_EraseRootFromParent_Done,
     /*  13814 */   // Label 323: @13814
     /*  13814 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(13952), // Rule ID 5026 //
     /*  13819 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13822 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13826 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13830 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13834 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13838 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13842 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13846 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13850 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13854 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13858 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  13862 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  13866 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13870 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13874 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  13878 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13882 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13886 */     // MIs[4] vA
     /*  13886 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  13891 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  13895 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  13899 */     // MIs[5] vC
     /*  13899 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  13904 */     // MIs[5] vB
     /*  13904 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  13909 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  13913 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  13919 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  13921 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  13923 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  13923 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  13926 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  13928 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  13932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vB
     /*  13936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  13940 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  13950 */     GIR_RootConstrainSelectedInstOperands,
     /*  13951 */     // GIR_Coverage, 5026,
     /*  13951 */     GIR_EraseRootFromParent_Done,
     /*  13952 */   // Label 324: @13952
     /*  13952 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(14090), // Rule ID 5033 //
     /*  13957 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  13960 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  13964 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  13968 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13972 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13976 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13980 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  13984 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  13988 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  13992 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  13996 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14000 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14004 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14008 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14012 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14016 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14020 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14024 */     // MIs[4] vC
     /*  14024 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14029 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14033 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14037 */     // MIs[5] vA
     /*  14037 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14042 */     // MIs[5] vB
     /*  14042 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14047 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14051 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14057 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14059 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14061 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14061 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14064 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14066 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14070 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  14074 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  14078 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14088 */     GIR_RootConstrainSelectedInstOperands,
     /*  14089 */     // GIR_Coverage, 5033,
     /*  14089 */     GIR_EraseRootFromParent_Done,
     /*  14090 */   // Label 325: @14090
     /*  14090 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(14228), // Rule ID 5034 //
     /*  14095 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14098 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14102 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14106 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14110 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14114 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14118 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14122 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14126 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14130 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14134 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14138 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14142 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14146 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14150 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14154 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14158 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14162 */     // MIs[4] vC
     /*  14162 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14167 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14171 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14175 */     // MIs[5] vB
     /*  14175 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14180 */     // MIs[5] vA
     /*  14180 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14185 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14189 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14195 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14197 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14199 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14199 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14202 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14204 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14208 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  14212 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  14216 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14226 */     GIR_RootConstrainSelectedInstOperands,
     /*  14227 */     // GIR_Coverage, 5034,
     /*  14227 */     GIR_EraseRootFromParent_Done,
     /*  14228 */   // Label 326: @14228
     /*  14228 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(14366), // Rule ID 5035 //
     /*  14233 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14236 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14240 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14244 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14248 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14252 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14256 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14260 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14264 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14268 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14272 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14276 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14280 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14284 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14288 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14292 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14296 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14300 */     // MIs[4] vB
     /*  14300 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14305 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14309 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14313 */     // MIs[5] vA
     /*  14313 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14318 */     // MIs[5] vC
     /*  14318 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14323 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14327 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14333 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14335 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14337 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14337 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14340 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14342 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14346 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  14350 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  14354 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14364 */     GIR_RootConstrainSelectedInstOperands,
     /*  14365 */     // GIR_Coverage, 5035,
     /*  14365 */     GIR_EraseRootFromParent_Done,
     /*  14366 */   // Label 327: @14366
     /*  14366 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(14504), // Rule ID 5036 //
     /*  14371 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14374 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14378 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14382 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14386 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14390 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14394 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14398 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14402 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14406 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14410 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14414 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14418 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14422 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14426 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14430 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14434 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14438 */     // MIs[4] vB
     /*  14438 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14443 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14447 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14451 */     // MIs[5] vC
     /*  14451 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14456 */     // MIs[5] vA
     /*  14456 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14461 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14465 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14471 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14473 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14475 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14475 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14478 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14480 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14484 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  14488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  14492 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14502 */     GIR_RootConstrainSelectedInstOperands,
     /*  14503 */     // GIR_Coverage, 5036,
     /*  14503 */     GIR_EraseRootFromParent_Done,
     /*  14504 */   // Label 328: @14504
     /*  14504 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(14642), // Rule ID 5037 //
     /*  14509 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14512 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14516 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14520 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14524 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14528 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14532 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14536 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14540 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14544 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14548 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14552 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14556 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14560 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14564 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14568 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14572 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14576 */     // MIs[4] vA
     /*  14576 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14581 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14585 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14589 */     // MIs[5] vB
     /*  14589 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14594 */     // MIs[5] vC
     /*  14594 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14599 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14603 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14609 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14611 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14613 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14613 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14616 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14618 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  14626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  14630 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14640 */     GIR_RootConstrainSelectedInstOperands,
     /*  14641 */     // GIR_Coverage, 5037,
     /*  14641 */     GIR_EraseRootFromParent_Done,
     /*  14642 */   // Label 329: @14642
     /*  14642 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(14780), // Rule ID 5038 //
     /*  14647 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14650 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14654 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14658 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14662 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14666 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14670 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14674 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14678 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14682 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14686 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14690 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14694 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14698 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14702 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14706 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14710 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14714 */     // MIs[4] vA
     /*  14714 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14719 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14723 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14727 */     // MIs[5] vC
     /*  14727 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14732 */     // MIs[5] vB
     /*  14732 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14737 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14741 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14747 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14749 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14751 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14751 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14754 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14756 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14760 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  14764 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  14768 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14778 */     GIR_RootConstrainSelectedInstOperands,
     /*  14779 */     // GIR_Coverage, 5038,
     /*  14779 */     GIR_EraseRootFromParent_Done,
     /*  14780 */   // Label 330: @14780
     /*  14780 */   GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(14918), // Rule ID 5045 //
     /*  14785 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14788 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14792 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14796 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14800 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14804 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14808 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14812 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14816 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14820 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14824 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14828 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14832 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14836 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14840 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14844 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14848 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14852 */     // MIs[4] vC
     /*  14852 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14857 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14861 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14865 */     // MIs[5] vA
     /*  14865 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  14870 */     // MIs[5] vB
     /*  14870 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  14875 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  14879 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  14885 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  14887 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  14889 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  14889 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  14892 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  14894 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  14898 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  14902 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  14906 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  14916 */     GIR_RootConstrainSelectedInstOperands,
     /*  14917 */     // GIR_Coverage, 5045,
     /*  14917 */     GIR_EraseRootFromParent_Done,
     /*  14918 */   // Label 331: @14918
     /*  14918 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(15056), // Rule ID 5046 //
     /*  14923 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  14926 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  14930 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  14934 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14938 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14942 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14946 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  14950 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  14954 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14958 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14962 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  14966 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  14970 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  14974 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14978 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  14982 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  14986 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  14990 */     // MIs[4] vC
     /*  14990 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  14995 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  14999 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15003 */     // MIs[5] vB
     /*  15003 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15008 */     // MIs[5] vA
     /*  15008 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  15013 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15017 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15023 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15025 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15027 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15027 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15030 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15032 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  15036 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  15044 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15054 */     GIR_RootConstrainSelectedInstOperands,
     /*  15055 */     // GIR_Coverage, 5046,
     /*  15055 */     GIR_EraseRootFromParent_Done,
     /*  15056 */   // Label 332: @15056
     /*  15056 */   GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(15194), // Rule ID 5047 //
     /*  15061 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15064 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15068 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15072 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15076 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15080 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15084 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  15088 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15092 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15096 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15100 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15104 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15108 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15112 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15116 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15120 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15124 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15128 */     // MIs[4] vB
     /*  15128 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15133 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  15137 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15141 */     // MIs[5] vA
     /*  15141 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  15146 */     // MIs[5] vC
     /*  15146 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15151 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15155 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15161 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15163 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15165 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15165 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15168 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15170 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  15174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15178 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  15182 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15192 */     GIR_RootConstrainSelectedInstOperands,
     /*  15193 */     // GIR_Coverage, 5047,
     /*  15193 */     GIR_EraseRootFromParent_Done,
     /*  15194 */   // Label 333: @15194
     /*  15194 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(15332), // Rule ID 5048 //
     /*  15199 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15202 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15214 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15218 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15222 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  15226 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15230 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15234 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15238 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15242 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15246 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15250 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15254 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15258 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15262 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15266 */     // MIs[4] vB
     /*  15266 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15271 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  15275 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15279 */     // MIs[5] vC
     /*  15279 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15284 */     // MIs[5] vA
     /*  15284 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  15289 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15293 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15299 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15301 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15303 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15303 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15306 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  15312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15316 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  15320 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15330 */     GIR_RootConstrainSelectedInstOperands,
     /*  15331 */     // GIR_Coverage, 5048,
     /*  15331 */     GIR_EraseRootFromParent_Done,
     /*  15332 */   // Label 334: @15332
     /*  15332 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(15470), // Rule ID 5049 //
     /*  15337 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15340 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15344 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15348 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15352 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15356 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15360 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  15364 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15368 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15372 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15376 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15380 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15384 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15388 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15392 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15396 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15400 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15404 */     // MIs[4] vA
     /*  15404 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  15409 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  15413 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15417 */     // MIs[5] vB
     /*  15417 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15422 */     // MIs[5] vC
     /*  15422 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15427 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15431 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15437 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15439 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15441 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15441 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15444 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15446 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  15450 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  15458 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15468 */     GIR_RootConstrainSelectedInstOperands,
     /*  15469 */     // GIR_Coverage, 5049,
     /*  15469 */     GIR_EraseRootFromParent_Done,
     /*  15470 */   // Label 335: @15470
     /*  15470 */   GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(15608), // Rule ID 5050 //
     /*  15475 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15478 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15482 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15486 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15490 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15494 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15498 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  15502 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15506 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15510 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15514 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15518 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15522 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15526 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15530 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15534 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15538 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15542 */     // MIs[4] vA
     /*  15542 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/2,
     /*  15547 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  15551 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15555 */     // MIs[5] vC
     /*  15555 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15560 */     // MIs[5] vB
     /*  15560 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15565 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15569 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15575 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15577 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15579 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15579 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15582 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15584 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // vA
     /*  15588 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  15596 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15606 */     GIR_RootConstrainSelectedInstOperands,
     /*  15607 */     // GIR_Coverage, 5050,
     /*  15607 */     GIR_EraseRootFromParent_Done,
     /*  15608 */   // Label 336: @15608
     /*  15608 */   GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(15746), // Rule ID 5051 //
     /*  15613 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15616 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15620 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15624 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15628 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15632 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15636 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15640 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15644 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15648 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15652 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15656 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15660 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15664 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15668 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15672 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15676 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15680 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  15684 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15688 */     // MIs[5] vA
     /*  15688 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15693 */     // MIs[5] vB
     /*  15693 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15698 */     // MIs[4] vC
     /*  15698 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  15703 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15707 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15713 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15715 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15717 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15717 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15720 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15722 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  15726 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15730 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  15734 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15744 */     GIR_RootConstrainSelectedInstOperands,
     /*  15745 */     // GIR_Coverage, 5051,
     /*  15745 */     GIR_EraseRootFromParent_Done,
     /*  15746 */   // Label 337: @15746
     /*  15746 */   GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(15884), // Rule ID 5052 //
     /*  15751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15754 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15758 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15762 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15766 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15770 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15774 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15778 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15782 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15786 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15790 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15794 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15798 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15802 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15806 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15810 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15814 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15818 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  15822 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15826 */     // MIs[5] vB
     /*  15826 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15831 */     // MIs[5] vA
     /*  15831 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15836 */     // MIs[4] vC
     /*  15836 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  15841 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15845 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15851 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15853 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15855 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15855 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15858 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15860 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  15864 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  15868 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  15872 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  15882 */     GIR_RootConstrainSelectedInstOperands,
     /*  15883 */     // GIR_Coverage, 5052,
     /*  15883 */     GIR_EraseRootFromParent_Done,
     /*  15884 */   // Label 338: @15884
     /*  15884 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(16022), // Rule ID 5053 //
     /*  15889 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  15892 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  15896 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  15900 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15904 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15908 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15912 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  15916 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  15920 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15924 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15928 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  15932 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  15936 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15940 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  15944 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  15948 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15952 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  15956 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  15960 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  15964 */     // MIs[5] vA
     /*  15964 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  15969 */     // MIs[5] vC
     /*  15969 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  15974 */     // MIs[4] vB
     /*  15974 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  15979 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  15983 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  15989 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  15991 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  15993 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  15993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  15996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  15998 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  16002 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  16006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16010 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16020 */     GIR_RootConstrainSelectedInstOperands,
     /*  16021 */     // GIR_Coverage, 5053,
     /*  16021 */     GIR_EraseRootFromParent_Done,
     /*  16022 */   // Label 339: @16022
     /*  16022 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(16160), // Rule ID 5054 //
     /*  16027 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16030 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16034 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16038 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16042 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16046 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16050 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16054 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16058 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16062 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16066 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16070 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16074 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16078 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16082 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16086 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16090 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16094 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16098 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16102 */     // MIs[5] vC
     /*  16102 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16107 */     // MIs[5] vA
     /*  16107 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16112 */     // MIs[4] vB
     /*  16112 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16117 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16121 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16127 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16129 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16131 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16131 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16134 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16136 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  16140 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  16144 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16148 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16158 */     GIR_RootConstrainSelectedInstOperands,
     /*  16159 */     // GIR_Coverage, 5054,
     /*  16159 */     GIR_EraseRootFromParent_Done,
     /*  16160 */   // Label 340: @16160
     /*  16160 */   GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(16298), // Rule ID 5055 //
     /*  16165 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16168 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16172 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16176 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16180 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16184 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16188 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16192 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16196 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16200 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16204 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16208 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16212 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16216 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16220 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16224 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16228 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16232 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16236 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16240 */     // MIs[5] vB
     /*  16240 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16245 */     // MIs[5] vC
     /*  16245 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16250 */     // MIs[4] vA
     /*  16250 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16255 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16259 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16265 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16267 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16269 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16269 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16272 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16274 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  16278 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  16282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16286 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16296 */     GIR_RootConstrainSelectedInstOperands,
     /*  16297 */     // GIR_Coverage, 5055,
     /*  16297 */     GIR_EraseRootFromParent_Done,
     /*  16298 */   // Label 341: @16298
     /*  16298 */   GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(16436), // Rule ID 5056 //
     /*  16303 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16306 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16310 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16314 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16318 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16322 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16326 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16330 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16334 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16338 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16342 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16346 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16350 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16354 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16358 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16362 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16366 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16370 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16374 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16378 */     // MIs[5] vC
     /*  16378 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16383 */     // MIs[5] vB
     /*  16383 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16388 */     // MIs[4] vA
     /*  16388 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16393 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16397 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16403 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16405 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16407 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16407 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16410 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16412 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  16416 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  16420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16424 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16434 */     GIR_RootConstrainSelectedInstOperands,
     /*  16435 */     // GIR_Coverage, 5056,
     /*  16435 */     GIR_EraseRootFromParent_Done,
     /*  16436 */   // Label 342: @16436
     /*  16436 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(16574), // Rule ID 5063 //
     /*  16441 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16444 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16448 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16452 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16456 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16460 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16464 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16468 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16472 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16476 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16480 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16484 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16488 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16492 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16496 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16500 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16504 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16508 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16512 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16516 */     // MIs[5] vA
     /*  16516 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16521 */     // MIs[5] vB
     /*  16521 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16526 */     // MIs[4] vC
     /*  16526 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16531 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16535 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16541 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16543 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16545 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16545 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16548 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16550 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  16554 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  16558 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16562 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16572 */     GIR_RootConstrainSelectedInstOperands,
     /*  16573 */     // GIR_Coverage, 5063,
     /*  16573 */     GIR_EraseRootFromParent_Done,
     /*  16574 */   // Label 343: @16574
     /*  16574 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(16712), // Rule ID 5064 //
     /*  16579 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16582 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16586 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16590 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16594 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16598 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16602 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16606 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16610 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16614 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16618 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16622 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16626 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16630 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16634 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16638 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16642 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16646 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16650 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16654 */     // MIs[5] vB
     /*  16654 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16659 */     // MIs[5] vA
     /*  16659 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16664 */     // MIs[4] vC
     /*  16664 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16669 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16673 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16679 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16681 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16683 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16683 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16686 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16688 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  16692 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  16696 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16700 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16710 */     GIR_RootConstrainSelectedInstOperands,
     /*  16711 */     // GIR_Coverage, 5064,
     /*  16711 */     GIR_EraseRootFromParent_Done,
     /*  16712 */   // Label 344: @16712
     /*  16712 */   GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(16850), // Rule ID 5065 //
     /*  16717 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16720 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16724 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16728 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16732 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16736 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16740 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16744 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16748 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16752 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16756 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16760 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16764 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16768 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16772 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16776 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16780 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16784 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16788 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16792 */     // MIs[5] vA
     /*  16792 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16797 */     // MIs[5] vC
     /*  16797 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16802 */     // MIs[4] vB
     /*  16802 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16807 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16811 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16817 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16819 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16821 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16821 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16824 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16826 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  16830 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  16834 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16838 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16848 */     GIR_RootConstrainSelectedInstOperands,
     /*  16849 */     // GIR_Coverage, 5065,
     /*  16849 */     GIR_EraseRootFromParent_Done,
     /*  16850 */   // Label 345: @16850
     /*  16850 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(16988), // Rule ID 5066 //
     /*  16855 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16858 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  16862 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  16866 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16870 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16874 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16878 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  16882 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  16886 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16890 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16894 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  16898 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  16902 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16906 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  16910 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  16914 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16918 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  16922 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  16926 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  16930 */     // MIs[5] vC
     /*  16930 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  16935 */     // MIs[5] vA
     /*  16935 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  16940 */     // MIs[4] vB
     /*  16940 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  16945 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  16949 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  16955 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  16957 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  16959 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  16959 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  16962 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  16964 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  16968 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  16972 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  16976 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  16986 */     GIR_RootConstrainSelectedInstOperands,
     /*  16987 */     // GIR_Coverage, 5066,
     /*  16987 */     GIR_EraseRootFromParent_Done,
     /*  16988 */   // Label 346: @16988
     /*  16988 */   GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(17126), // Rule ID 5067 //
     /*  16993 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  16996 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17000 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17004 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17008 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17012 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17016 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17020 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17024 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17028 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17032 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17036 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17040 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17044 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17048 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17052 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17056 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17060 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17064 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17068 */     // MIs[5] vB
     /*  17068 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17073 */     // MIs[5] vC
     /*  17073 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17078 */     // MIs[4] vA
     /*  17078 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17083 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17087 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17093 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17095 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17097 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17097 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17100 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17102 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  17106 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  17110 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  17114 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17124 */     GIR_RootConstrainSelectedInstOperands,
     /*  17125 */     // GIR_Coverage, 5067,
     /*  17125 */     GIR_EraseRootFromParent_Done,
     /*  17126 */   // Label 347: @17126
     /*  17126 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(17264), // Rule ID 5068 //
     /*  17131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17138 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17142 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17146 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17150 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17154 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17158 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17162 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17166 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17170 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17174 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17178 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17182 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17186 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17190 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17194 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17198 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17202 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17206 */     // MIs[5] vC
     /*  17206 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17211 */     // MIs[5] vB
     /*  17211 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17216 */     // MIs[4] vA
     /*  17216 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17221 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17225 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17231 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17233 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17235 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17235 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17238 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17240 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  17244 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  17248 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  17252 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17262 */     GIR_RootConstrainSelectedInstOperands,
     /*  17263 */     // GIR_Coverage, 5068,
     /*  17263 */     GIR_EraseRootFromParent_Done,
     /*  17264 */   // Label 348: @17264
     /*  17264 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(17402), // Rule ID 5075 //
     /*  17269 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17272 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17276 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17280 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17284 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17288 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17292 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17296 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17300 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17304 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17308 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17312 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17316 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17320 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17324 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17328 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17332 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17336 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17340 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17344 */     // MIs[5] vA
     /*  17344 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17349 */     // MIs[5] vB
     /*  17349 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17354 */     // MIs[4] vC
     /*  17354 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17359 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17363 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17369 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17371 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17373 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17373 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17376 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17378 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  17382 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  17386 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  17390 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17400 */     GIR_RootConstrainSelectedInstOperands,
     /*  17401 */     // GIR_Coverage, 5075,
     /*  17401 */     GIR_EraseRootFromParent_Done,
     /*  17402 */   // Label 349: @17402
     /*  17402 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(17540), // Rule ID 5076 //
     /*  17407 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17410 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17414 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17418 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17422 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17426 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17430 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17434 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17438 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17442 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17446 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17450 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17454 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17458 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17462 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17466 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17470 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17474 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17478 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17482 */     // MIs[5] vB
     /*  17482 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17487 */     // MIs[5] vA
     /*  17487 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17492 */     // MIs[4] vC
     /*  17492 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17497 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17501 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17507 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17509 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17511 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17511 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17514 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17516 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  17520 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  17524 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  17528 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17538 */     GIR_RootConstrainSelectedInstOperands,
     /*  17539 */     // GIR_Coverage, 5076,
     /*  17539 */     GIR_EraseRootFromParent_Done,
     /*  17540 */   // Label 350: @17540
     /*  17540 */   GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(17678), // Rule ID 5077 //
     /*  17545 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17548 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17552 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17556 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17560 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17564 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17568 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17572 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17576 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17580 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17584 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17588 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17592 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17596 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17600 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17604 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17608 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17612 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17616 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17620 */     // MIs[5] vA
     /*  17620 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17625 */     // MIs[5] vC
     /*  17625 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17630 */     // MIs[4] vB
     /*  17630 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17635 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17639 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17645 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17647 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17649 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17649 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17652 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17654 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  17658 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  17662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  17666 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17676 */     GIR_RootConstrainSelectedInstOperands,
     /*  17677 */     // GIR_Coverage, 5077,
     /*  17677 */     GIR_EraseRootFromParent_Done,
     /*  17678 */   // Label 351: @17678
     /*  17678 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(17816), // Rule ID 5078 //
     /*  17683 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17686 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17690 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17694 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17698 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17702 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17706 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17710 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17714 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17718 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17722 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17726 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17730 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17734 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17738 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17742 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17746 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17750 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17754 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17758 */     // MIs[5] vC
     /*  17758 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17763 */     // MIs[5] vA
     /*  17763 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17768 */     // MIs[4] vB
     /*  17768 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17773 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17777 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17783 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17785 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17787 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17787 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17790 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17792 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  17796 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  17800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  17804 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17814 */     GIR_RootConstrainSelectedInstOperands,
     /*  17815 */     // GIR_Coverage, 5078,
     /*  17815 */     GIR_EraseRootFromParent_Done,
     /*  17816 */   // Label 352: @17816
     /*  17816 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(17954), // Rule ID 5079 //
     /*  17821 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17824 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17828 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17832 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17836 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17840 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17844 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17848 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17852 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17856 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17860 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  17864 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  17868 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17872 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17876 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  17880 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17884 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17888 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  17892 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  17896 */     // MIs[5] vB
     /*  17896 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  17901 */     // MIs[5] vC
     /*  17901 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  17906 */     // MIs[4] vA
     /*  17906 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  17911 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  17915 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  17921 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  17923 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  17925 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  17925 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  17928 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  17930 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  17934 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  17938 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  17942 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  17952 */     GIR_RootConstrainSelectedInstOperands,
     /*  17953 */     // GIR_Coverage, 5079,
     /*  17953 */     GIR_EraseRootFromParent_Done,
     /*  17954 */   // Label 353: @17954
     /*  17954 */   GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(18092), // Rule ID 5080 //
     /*  17959 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  17962 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  17966 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  17970 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17974 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17978 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17982 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  17986 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  17990 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  17994 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  17998 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18002 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18006 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18010 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18014 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18018 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18022 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18026 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18030 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18034 */     // MIs[5] vC
     /*  18034 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18039 */     // MIs[5] vB
     /*  18039 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18044 */     // MIs[4] vA
     /*  18044 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18049 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18053 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18059 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18061 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18063 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18063 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18066 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18068 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  18072 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  18080 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18090 */     GIR_RootConstrainSelectedInstOperands,
     /*  18091 */     // GIR_Coverage, 5080,
     /*  18091 */     GIR_EraseRootFromParent_Done,
     /*  18092 */   // Label 354: @18092
     /*  18092 */   GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(18230), // Rule ID 5087 //
     /*  18097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18100 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18104 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18108 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18112 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18116 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18120 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18124 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18128 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18132 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18136 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18140 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18144 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18148 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18152 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18156 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18160 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18164 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18168 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18172 */     // MIs[5] vA
     /*  18172 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18177 */     // MIs[5] vB
     /*  18177 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18182 */     // MIs[4] vC
     /*  18182 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18187 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18191 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18197 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18199 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18201 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18201 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18204 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18206 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  18210 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18214 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  18218 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18228 */     GIR_RootConstrainSelectedInstOperands,
     /*  18229 */     // GIR_Coverage, 5087,
     /*  18229 */     GIR_EraseRootFromParent_Done,
     /*  18230 */   // Label 355: @18230
     /*  18230 */   GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(18368), // Rule ID 5088 //
     /*  18235 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18238 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18242 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18246 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18250 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18254 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18258 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18262 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18266 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18270 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18274 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18278 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18282 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18286 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18290 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18294 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18298 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18302 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18306 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18310 */     // MIs[5] vB
     /*  18310 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18315 */     // MIs[5] vA
     /*  18315 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18320 */     // MIs[4] vC
     /*  18320 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18325 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18329 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18335 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18337 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18339 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18339 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18342 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18344 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  18348 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  18356 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18366 */     GIR_RootConstrainSelectedInstOperands,
     /*  18367 */     // GIR_Coverage, 5088,
     /*  18367 */     GIR_EraseRootFromParent_Done,
     /*  18368 */   // Label 356: @18368
     /*  18368 */   GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(18506), // Rule ID 5089 //
     /*  18373 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18376 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18380 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18384 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18388 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18392 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18396 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18400 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18404 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18408 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18412 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18416 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18420 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18424 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18428 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18432 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18436 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18440 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18444 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18448 */     // MIs[5] vA
     /*  18448 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18453 */     // MIs[5] vC
     /*  18453 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18458 */     // MIs[4] vB
     /*  18458 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18463 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18467 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18473 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18475 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18477 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18477 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18480 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18482 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  18486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18490 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  18494 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18504 */     GIR_RootConstrainSelectedInstOperands,
     /*  18505 */     // GIR_Coverage, 5089,
     /*  18505 */     GIR_EraseRootFromParent_Done,
     /*  18506 */   // Label 357: @18506
     /*  18506 */   GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(18644), // Rule ID 5090 //
     /*  18511 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18514 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18518 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18522 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18526 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18530 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18534 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18538 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18542 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18546 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18550 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18554 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18558 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18562 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18566 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18570 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18574 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18578 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18582 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18586 */     // MIs[5] vC
     /*  18586 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18591 */     // MIs[5] vA
     /*  18591 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18596 */     // MIs[4] vB
     /*  18596 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18601 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18605 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18611 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18613 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18615 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18615 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18618 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18620 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  18624 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18628 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  18632 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18642 */     GIR_RootConstrainSelectedInstOperands,
     /*  18643 */     // GIR_Coverage, 5090,
     /*  18643 */     GIR_EraseRootFromParent_Done,
     /*  18644 */   // Label 358: @18644
     /*  18644 */   GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(18782), // Rule ID 5091 //
     /*  18649 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18652 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18656 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18660 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18664 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18668 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18672 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18676 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18680 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18684 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18688 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18692 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18696 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18700 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18704 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18708 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18712 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18716 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18720 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18724 */     // MIs[5] vB
     /*  18724 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18729 */     // MIs[5] vC
     /*  18729 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18734 */     // MIs[4] vA
     /*  18734 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18739 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18743 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18749 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18751 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18753 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18758 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  18762 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  18770 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18780 */     GIR_RootConstrainSelectedInstOperands,
     /*  18781 */     // GIR_Coverage, 5091,
     /*  18781 */     GIR_EraseRootFromParent_Done,
     /*  18782 */   // Label 359: @18782
     /*  18782 */   GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(18920), // Rule ID 5092 //
     /*  18787 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18790 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18794 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18798 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18802 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18806 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18810 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18814 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18818 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18822 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18826 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18830 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18834 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18838 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18842 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18846 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18850 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18854 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18858 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18862 */     // MIs[5] vC
     /*  18862 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  18867 */     // MIs[5] vB
     /*  18867 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  18872 */     // MIs[4] vA
     /*  18872 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  18877 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  18881 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  18887 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  18889 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  18891 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  18891 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  18894 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  18896 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  18900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  18904 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  18908 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  18918 */     GIR_RootConstrainSelectedInstOperands,
     /*  18919 */     // GIR_Coverage, 5092,
     /*  18919 */     GIR_EraseRootFromParent_Done,
     /*  18920 */   // Label 360: @18920
     /*  18920 */   GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(19058), // Rule ID 5099 //
     /*  18925 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  18928 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  18932 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  18936 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18940 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18944 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18948 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  18952 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  18956 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18960 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18964 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  18968 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  18972 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18976 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  18980 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  18984 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  18988 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  18992 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  18996 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19000 */     // MIs[5] vA
     /*  19000 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19005 */     // MIs[5] vB
     /*  19005 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19010 */     // MIs[4] vC
     /*  19010 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19015 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19019 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19025 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19027 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19029 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19029 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19032 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19034 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19038 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  19042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  19046 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19056 */     GIR_RootConstrainSelectedInstOperands,
     /*  19057 */     // GIR_Coverage, 5099,
     /*  19057 */     GIR_EraseRootFromParent_Done,
     /*  19058 */   // Label 361: @19058
     /*  19058 */   GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(19196), // Rule ID 5100 //
     /*  19063 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19066 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19070 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19074 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19078 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19082 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19086 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19090 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19094 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19098 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19102 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19106 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19110 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19114 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19118 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19122 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19126 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19130 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19134 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19138 */     // MIs[5] vB
     /*  19138 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19143 */     // MIs[5] vA
     /*  19143 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19148 */     // MIs[4] vC
     /*  19148 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19153 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19157 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19163 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19165 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19167 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19167 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19170 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19172 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  19180 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  19184 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19194 */     GIR_RootConstrainSelectedInstOperands,
     /*  19195 */     // GIR_Coverage, 5100,
     /*  19195 */     GIR_EraseRootFromParent_Done,
     /*  19196 */   // Label 362: @19196
     /*  19196 */   GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(19334), // Rule ID 5101 //
     /*  19201 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19204 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19208 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19212 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19216 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19220 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19224 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19228 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19232 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19236 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19240 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19244 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19248 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19252 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19256 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19260 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19264 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19268 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19272 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19276 */     // MIs[5] vA
     /*  19276 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19281 */     // MIs[5] vC
     /*  19281 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19286 */     // MIs[4] vB
     /*  19286 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19291 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19295 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19301 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19303 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19305 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19305 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19308 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19310 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  19318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  19322 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19332 */     GIR_RootConstrainSelectedInstOperands,
     /*  19333 */     // GIR_Coverage, 5101,
     /*  19333 */     GIR_EraseRootFromParent_Done,
     /*  19334 */   // Label 363: @19334
     /*  19334 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(19472), // Rule ID 5102 //
     /*  19339 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19342 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19346 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19350 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19354 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19358 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19362 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19366 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19370 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19374 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19378 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19382 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19386 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19390 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19394 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19398 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19402 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19406 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19410 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19414 */     // MIs[5] vC
     /*  19414 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19419 */     // MIs[5] vA
     /*  19419 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19424 */     // MIs[4] vB
     /*  19424 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19429 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19433 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19439 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19441 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19443 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19443 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19446 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19448 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  19456 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  19460 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19470 */     GIR_RootConstrainSelectedInstOperands,
     /*  19471 */     // GIR_Coverage, 5102,
     /*  19471 */     GIR_EraseRootFromParent_Done,
     /*  19472 */   // Label 364: @19472
     /*  19472 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(19610), // Rule ID 5103 //
     /*  19477 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19480 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19484 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19488 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19492 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19496 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19500 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19504 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19508 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19512 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19516 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19520 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19524 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19528 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19532 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19536 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19540 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19544 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19548 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19552 */     // MIs[5] vB
     /*  19552 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19557 */     // MIs[5] vC
     /*  19557 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19562 */     // MIs[4] vA
     /*  19562 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19567 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19571 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19577 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19579 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19581 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19581 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19584 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19586 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19590 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  19594 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  19598 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19608 */     GIR_RootConstrainSelectedInstOperands,
     /*  19609 */     // GIR_Coverage, 5103,
     /*  19609 */     GIR_EraseRootFromParent_Done,
     /*  19610 */   // Label 365: @19610
     /*  19610 */   GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(19748), // Rule ID 5104 //
     /*  19615 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19618 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19622 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19626 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19630 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19634 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19638 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19642 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19646 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19650 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19654 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19658 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19662 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19666 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19670 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19674 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19678 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19682 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19686 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19690 */     // MIs[5] vC
     /*  19690 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19695 */     // MIs[5] vB
     /*  19695 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19700 */     // MIs[4] vA
     /*  19700 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19705 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19709 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19715 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19717 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19719 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19724 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19728 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  19732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  19736 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19746 */     GIR_RootConstrainSelectedInstOperands,
     /*  19747 */     // GIR_Coverage, 5104,
     /*  19747 */     GIR_EraseRootFromParent_Done,
     /*  19748 */   // Label 366: @19748
     /*  19748 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(19886), // Rule ID 5110 //
     /*  19753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19756 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19760 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19764 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19768 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19772 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19776 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19780 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19784 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19788 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19792 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19796 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19800 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19804 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19808 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19812 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19816 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19820 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19824 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19828 */     // MIs[5] vA
     /*  19828 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19833 */     // MIs[5] vB
     /*  19833 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19838 */     // MIs[4] vC
     /*  19838 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19843 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19847 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19853 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19855 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19857 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19857 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19860 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  19862 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  19866 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  19870 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  19874 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  19884 */     GIR_RootConstrainSelectedInstOperands,
     /*  19885 */     // GIR_Coverage, 5110,
     /*  19885 */     GIR_EraseRootFromParent_Done,
     /*  19886 */   // Label 367: @19886
     /*  19886 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(20024), // Rule ID 5111 //
     /*  19891 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  19894 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  19898 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  19902 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19906 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19910 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19914 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  19918 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  19922 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19926 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19930 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  19934 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  19938 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19942 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  19946 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  19950 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19954 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  19958 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  19962 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  19966 */     // MIs[5] vB
     /*  19966 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  19971 */     // MIs[5] vA
     /*  19971 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  19976 */     // MIs[4] vC
     /*  19976 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  19981 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  19985 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  19991 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  19993 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  19995 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  19995 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  19998 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20000 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  20004 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20008 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  20012 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20022 */     GIR_RootConstrainSelectedInstOperands,
     /*  20023 */     // GIR_Coverage, 5111,
     /*  20023 */     GIR_EraseRootFromParent_Done,
     /*  20024 */   // Label 368: @20024
     /*  20024 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(20162), // Rule ID 5112 //
     /*  20029 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20032 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20036 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20040 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20044 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20048 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20052 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20056 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20060 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20064 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20068 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20072 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20076 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20080 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20084 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20088 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20092 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20096 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20100 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20104 */     // MIs[5] vA
     /*  20104 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20109 */     // MIs[5] vC
     /*  20109 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20114 */     // MIs[4] vB
     /*  20114 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20119 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20123 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20129 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20131 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20133 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20133 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20136 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20138 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  20142 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20146 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  20150 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20160 */     GIR_RootConstrainSelectedInstOperands,
     /*  20161 */     // GIR_Coverage, 5112,
     /*  20161 */     GIR_EraseRootFromParent_Done,
     /*  20162 */   // Label 369: @20162
     /*  20162 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(20300), // Rule ID 5113 //
     /*  20167 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20170 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20174 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20178 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20182 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20186 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20190 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20194 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20198 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20202 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20206 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20210 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20214 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20218 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20222 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20226 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20230 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20234 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20238 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20242 */     // MIs[5] vC
     /*  20242 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20247 */     // MIs[5] vA
     /*  20247 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20252 */     // MIs[4] vB
     /*  20252 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20257 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20261 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20267 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20269 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20271 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20271 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20274 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20276 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  20280 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  20288 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20298 */     GIR_RootConstrainSelectedInstOperands,
     /*  20299 */     // GIR_Coverage, 5113,
     /*  20299 */     GIR_EraseRootFromParent_Done,
     /*  20300 */   // Label 370: @20300
     /*  20300 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(20438), // Rule ID 5114 //
     /*  20305 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20308 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20312 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20316 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20320 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20324 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20328 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20332 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20336 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20340 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20344 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20348 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20352 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20356 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20360 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20364 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20368 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20372 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20376 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20380 */     // MIs[5] vB
     /*  20380 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20385 */     // MIs[5] vC
     /*  20385 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20390 */     // MIs[4] vA
     /*  20390 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20395 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20399 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20405 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20407 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20409 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20409 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20412 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20414 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  20418 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20422 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  20426 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20436 */     GIR_RootConstrainSelectedInstOperands,
     /*  20437 */     // GIR_Coverage, 5114,
     /*  20437 */     GIR_EraseRootFromParent_Done,
     /*  20438 */   // Label 371: @20438
     /*  20438 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(20576), // Rule ID 5115 //
     /*  20443 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20446 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20450 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20454 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20458 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20462 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20466 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20470 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20474 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20478 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20482 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20486 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20490 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20494 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20498 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20502 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20506 */     GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20510 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/1, // MIs[5]
     /*  20514 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20518 */     // MIs[5] vC
     /*  20518 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20523 */     // MIs[5] vB
     /*  20523 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20528 */     // MIs[4] vA
     /*  20528 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20533 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20537 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20543 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20545 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20547 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20547 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20550 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20552 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  20556 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  20564 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20574 */     GIR_RootConstrainSelectedInstOperands,
     /*  20575 */     // GIR_Coverage, 5115,
     /*  20575 */     GIR_EraseRootFromParent_Done,
     /*  20576 */   // Label 372: @20576
     /*  20576 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(20714), // Rule ID 3399 //
     /*  20581 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20584 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20588 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20592 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20596 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20600 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20604 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20608 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20612 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20616 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20620 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20624 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20628 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20632 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20636 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20640 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20644 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20648 */     // MIs[4] vA
     /*  20648 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20653 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  20657 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20661 */     // MIs[5] vB
     /*  20661 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20666 */     // MIs[5] vC
     /*  20666 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20671 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20675 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20681 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20683 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20685 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20685 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20688 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20690 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  20694 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  20698 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  20702 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20712 */     GIR_RootConstrainSelectedInstOperands,
     /*  20713 */     // GIR_Coverage, 3399,
     /*  20713 */     GIR_EraseRootFromParent_Done,
     /*  20714 */   // Label 373: @20714
     /*  20714 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(20852), // Rule ID 5057 //
     /*  20719 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20722 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20726 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20730 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20734 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20738 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20742 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20746 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20750 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20754 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20758 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20762 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20766 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20770 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20774 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20778 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20782 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20786 */     // MIs[4] vC
     /*  20786 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20791 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  20795 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20799 */     // MIs[5] vA
     /*  20799 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20804 */     // MIs[5] vB
     /*  20804 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20809 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20813 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20819 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20821 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20823 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20823 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20826 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20828 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  20832 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20836 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  20840 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20850 */     GIR_RootConstrainSelectedInstOperands,
     /*  20851 */     // GIR_Coverage, 5057,
     /*  20851 */     GIR_EraseRootFromParent_Done,
     /*  20852 */   // Label 374: @20852
     /*  20852 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(20990), // Rule ID 5058 //
     /*  20857 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20860 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  20864 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  20868 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20872 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20876 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20880 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  20884 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  20888 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20892 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20896 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  20900 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  20904 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  20908 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20912 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  20916 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20920 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  20924 */     // MIs[4] vC
     /*  20924 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  20929 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  20933 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  20937 */     // MIs[5] vB
     /*  20937 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  20942 */     // MIs[5] vA
     /*  20942 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  20947 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  20951 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  20957 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  20959 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  20961 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  20961 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  20964 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  20966 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  20970 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  20974 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  20978 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  20988 */     GIR_RootConstrainSelectedInstOperands,
     /*  20989 */     // GIR_Coverage, 5058,
     /*  20989 */     GIR_EraseRootFromParent_Done,
     /*  20990 */   // Label 375: @20990
     /*  20990 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(21128), // Rule ID 5059 //
     /*  20995 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  20998 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21002 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21006 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21010 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21014 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21018 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21022 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21026 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21030 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21034 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21038 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21042 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21046 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21050 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21054 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21058 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21062 */     // MIs[4] vB
     /*  21062 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21067 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21071 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21075 */     // MIs[5] vA
     /*  21075 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21080 */     // MIs[5] vC
     /*  21080 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21085 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21089 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21095 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21097 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21099 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21099 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21102 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21104 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  21108 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  21112 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21116 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21126 */     GIR_RootConstrainSelectedInstOperands,
     /*  21127 */     // GIR_Coverage, 5059,
     /*  21127 */     GIR_EraseRootFromParent_Done,
     /*  21128 */   // Label 376: @21128
     /*  21128 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(21266), // Rule ID 5060 //
     /*  21133 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21136 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21140 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21144 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21148 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21152 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21156 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21160 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21164 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21168 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21172 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21176 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21180 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21184 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21188 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21192 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21196 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21200 */     // MIs[4] vB
     /*  21200 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21205 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21209 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21213 */     // MIs[5] vC
     /*  21213 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21218 */     // MIs[5] vA
     /*  21218 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21223 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21227 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21233 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21235 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21237 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21237 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21240 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  21246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  21250 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21254 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21264 */     GIR_RootConstrainSelectedInstOperands,
     /*  21265 */     // GIR_Coverage, 5060,
     /*  21265 */     GIR_EraseRootFromParent_Done,
     /*  21266 */   // Label 377: @21266
     /*  21266 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(21404), // Rule ID 5061 //
     /*  21271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21274 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21278 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21282 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21286 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21290 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21294 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21298 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21302 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21306 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21310 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21314 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21318 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21322 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21326 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21330 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21334 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21338 */     // MIs[4] vA
     /*  21338 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21343 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21347 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21351 */     // MIs[5] vB
     /*  21351 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21356 */     // MIs[5] vC
     /*  21356 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21361 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21365 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21371 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21373 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21375 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21375 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21378 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21380 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  21384 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  21388 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21392 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21402 */     GIR_RootConstrainSelectedInstOperands,
     /*  21403 */     // GIR_Coverage, 5061,
     /*  21403 */     GIR_EraseRootFromParent_Done,
     /*  21404 */   // Label 378: @21404
     /*  21404 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(21542), // Rule ID 5062 //
     /*  21409 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21412 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21416 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21420 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21424 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21428 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21432 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21436 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21440 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21444 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21448 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21452 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21456 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21460 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21464 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21468 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21472 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21476 */     // MIs[4] vA
     /*  21476 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21481 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21485 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21489 */     // MIs[5] vC
     /*  21489 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21494 */     // MIs[5] vB
     /*  21494 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21499 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21503 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21509 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21511 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21513 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21513 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21516 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21518 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  21522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  21526 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21530 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21540 */     GIR_RootConstrainSelectedInstOperands,
     /*  21541 */     // GIR_Coverage, 5062,
     /*  21541 */     GIR_EraseRootFromParent_Done,
     /*  21542 */   // Label 379: @21542
     /*  21542 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(21680), // Rule ID 5069 //
     /*  21547 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21550 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21554 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21558 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21562 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21566 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21570 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21574 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21578 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21582 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21586 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21590 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21594 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21598 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21602 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21606 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21610 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21614 */     // MIs[4] vC
     /*  21614 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21619 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21623 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21627 */     // MIs[5] vA
     /*  21627 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21632 */     // MIs[5] vB
     /*  21632 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21637 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21641 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21647 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21649 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21651 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21651 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21654 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21656 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  21660 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  21664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21668 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21678 */     GIR_RootConstrainSelectedInstOperands,
     /*  21679 */     // GIR_Coverage, 5069,
     /*  21679 */     GIR_EraseRootFromParent_Done,
     /*  21680 */   // Label 380: @21680
     /*  21680 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(21818), // Rule ID 5070 //
     /*  21685 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21688 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21692 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21696 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21700 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21704 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21708 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21712 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21716 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21720 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21724 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21728 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21732 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21736 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21740 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21744 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21748 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21752 */     // MIs[4] vC
     /*  21752 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21757 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21761 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21765 */     // MIs[5] vB
     /*  21765 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21770 */     // MIs[5] vA
     /*  21770 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21775 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21779 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21785 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21787 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21789 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21789 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21792 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21794 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  21798 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  21802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21806 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21816 */     GIR_RootConstrainSelectedInstOperands,
     /*  21817 */     // GIR_Coverage, 5070,
     /*  21817 */     GIR_EraseRootFromParent_Done,
     /*  21818 */   // Label 381: @21818
     /*  21818 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(21956), // Rule ID 5071 //
     /*  21823 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21826 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21830 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21834 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21838 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21842 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21846 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21850 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21854 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21858 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21862 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  21866 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  21870 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21874 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21878 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  21882 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21886 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21890 */     // MIs[4] vB
     /*  21890 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  21895 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  21899 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  21903 */     // MIs[5] vA
     /*  21903 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  21908 */     // MIs[5] vC
     /*  21908 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  21913 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  21917 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  21923 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  21925 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  21927 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  21927 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  21930 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  21932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  21936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  21940 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  21944 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  21954 */     GIR_RootConstrainSelectedInstOperands,
     /*  21955 */     // GIR_Coverage, 5071,
     /*  21955 */     GIR_EraseRootFromParent_Done,
     /*  21956 */   // Label 382: @21956
     /*  21956 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(22094), // Rule ID 5072 //
     /*  21961 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  21964 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  21968 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  21972 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21976 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21980 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  21984 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  21988 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  21992 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  21996 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22000 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22004 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22008 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22012 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22016 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22020 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22024 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22028 */     // MIs[4] vB
     /*  22028 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22033 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22037 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22041 */     // MIs[5] vC
     /*  22041 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22046 */     // MIs[5] vA
     /*  22046 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22051 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22055 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22061 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22063 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22065 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22065 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22068 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22070 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  22074 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  22078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  22082 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22092 */     GIR_RootConstrainSelectedInstOperands,
     /*  22093 */     // GIR_Coverage, 5072,
     /*  22093 */     GIR_EraseRootFromParent_Done,
     /*  22094 */   // Label 383: @22094
     /*  22094 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(22232), // Rule ID 5073 //
     /*  22099 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22102 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22106 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22110 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22114 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22118 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22122 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22126 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22130 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22134 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22138 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22142 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22146 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22150 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22154 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22158 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22162 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22166 */     // MIs[4] vA
     /*  22166 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22171 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22175 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22179 */     // MIs[5] vB
     /*  22179 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22184 */     // MIs[5] vC
     /*  22184 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22189 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22193 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22199 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22201 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22203 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22203 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22206 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22208 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  22212 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  22216 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  22220 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22230 */     GIR_RootConstrainSelectedInstOperands,
     /*  22231 */     // GIR_Coverage, 5073,
     /*  22231 */     GIR_EraseRootFromParent_Done,
     /*  22232 */   // Label 384: @22232
     /*  22232 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(22370), // Rule ID 5074 //
     /*  22237 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22240 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22244 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22248 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22252 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22256 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22260 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22264 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22268 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22272 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22276 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22280 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22284 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22288 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22292 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22296 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22300 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22304 */     // MIs[4] vA
     /*  22304 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22309 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22313 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22317 */     // MIs[5] vC
     /*  22317 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22322 */     // MIs[5] vB
     /*  22322 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22327 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22331 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22337 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22339 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22341 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22341 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22344 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22346 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  22350 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  22354 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vC
     /*  22358 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22368 */     GIR_RootConstrainSelectedInstOperands,
     /*  22369 */     // GIR_Coverage, 5074,
     /*  22369 */     GIR_EraseRootFromParent_Done,
     /*  22370 */   // Label 385: @22370
     /*  22370 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(22508), // Rule ID 5081 //
     /*  22375 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22378 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22382 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22386 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22390 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22394 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22398 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22402 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22406 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22410 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22414 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22418 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22422 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22426 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22430 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22434 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22438 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22442 */     // MIs[4] vC
     /*  22442 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22447 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22451 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22455 */     // MIs[5] vA
     /*  22455 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22460 */     // MIs[5] vB
     /*  22460 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22465 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22469 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22475 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22477 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22479 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22479 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22482 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22484 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  22488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  22492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  22496 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22506 */     GIR_RootConstrainSelectedInstOperands,
     /*  22507 */     // GIR_Coverage, 5081,
     /*  22507 */     GIR_EraseRootFromParent_Done,
     /*  22508 */   // Label 386: @22508
     /*  22508 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(22646), // Rule ID 5082 //
     /*  22513 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22516 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22520 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22524 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22528 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22532 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22536 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22540 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22544 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22548 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22552 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22556 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22560 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22564 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22568 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22572 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22576 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22580 */     // MIs[4] vC
     /*  22580 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22585 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22589 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22593 */     // MIs[5] vB
     /*  22593 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22598 */     // MIs[5] vA
     /*  22598 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22603 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22607 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22613 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22615 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22617 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22617 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22620 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  22626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  22630 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  22634 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22644 */     GIR_RootConstrainSelectedInstOperands,
     /*  22645 */     // GIR_Coverage, 5082,
     /*  22645 */     GIR_EraseRootFromParent_Done,
     /*  22646 */   // Label 387: @22646
     /*  22646 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(22784), // Rule ID 5083 //
     /*  22651 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22654 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22658 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22662 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22666 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22670 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22674 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22678 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22682 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22686 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22690 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22694 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22698 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22702 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22706 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22710 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22714 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22718 */     // MIs[4] vB
     /*  22718 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22723 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22727 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22731 */     // MIs[5] vA
     /*  22731 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22736 */     // MIs[5] vC
     /*  22736 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22741 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22745 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22751 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22753 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22755 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22755 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22758 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22760 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  22764 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  22768 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  22772 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22782 */     GIR_RootConstrainSelectedInstOperands,
     /*  22783 */     // GIR_Coverage, 5083,
     /*  22783 */     GIR_EraseRootFromParent_Done,
     /*  22784 */   // Label 388: @22784
     /*  22784 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(22922), // Rule ID 5084 //
     /*  22789 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22792 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22796 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22800 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22804 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22808 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22812 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22816 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22820 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22824 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22828 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22832 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22836 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22840 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22844 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22848 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22852 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22856 */     // MIs[4] vB
     /*  22856 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  22861 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  22865 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22869 */     // MIs[5] vC
     /*  22869 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  22874 */     // MIs[5] vA
     /*  22874 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22879 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  22883 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  22889 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  22891 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  22893 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  22893 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  22896 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  22898 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  22902 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  22906 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  22910 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  22920 */     GIR_RootConstrainSelectedInstOperands,
     /*  22921 */     // GIR_Coverage, 5084,
     /*  22921 */     GIR_EraseRootFromParent_Done,
     /*  22922 */   // Label 389: @22922
     /*  22922 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(23060), // Rule ID 5085 //
     /*  22927 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  22930 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  22934 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  22938 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22942 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22946 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22950 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  22954 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  22958 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22962 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22966 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  22970 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  22974 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  22978 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22982 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  22986 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  22990 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  22994 */     // MIs[4] vA
     /*  22994 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  22999 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23003 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23007 */     // MIs[5] vB
     /*  23007 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23012 */     // MIs[5] vC
     /*  23012 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23017 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23021 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23027 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23029 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23031 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23036 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  23040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23044 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  23048 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23058 */     GIR_RootConstrainSelectedInstOperands,
     /*  23059 */     // GIR_Coverage, 5085,
     /*  23059 */     GIR_EraseRootFromParent_Done,
     /*  23060 */   // Label 390: @23060
     /*  23060 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(23198), // Rule ID 5086 //
     /*  23065 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23068 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23072 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23076 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23080 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23084 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23088 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23092 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23096 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23100 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23104 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23108 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23112 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23116 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23120 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23124 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23128 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23132 */     // MIs[4] vA
     /*  23132 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23137 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23141 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23145 */     // MIs[5] vC
     /*  23145 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23150 */     // MIs[5] vB
     /*  23150 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23155 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23159 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23165 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23167 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23169 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23169 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23172 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23174 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vA
     /*  23178 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23182 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  23186 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23196 */     GIR_RootConstrainSelectedInstOperands,
     /*  23197 */     // GIR_Coverage, 5086,
     /*  23197 */     GIR_EraseRootFromParent_Done,
     /*  23198 */   // Label 391: @23198
     /*  23198 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(23336), // Rule ID 5093 //
     /*  23203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23206 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23210 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23214 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23218 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23222 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23226 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23230 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23234 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23238 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23242 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23246 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23250 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23254 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23258 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23262 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23266 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23270 */     // MIs[4] vC
     /*  23270 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23275 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23279 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23283 */     // MIs[5] vA
     /*  23283 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23288 */     // MIs[5] vB
     /*  23288 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23293 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23297 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23303 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23305 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23307 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23307 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23310 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23312 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  23316 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23320 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  23324 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23334 */     GIR_RootConstrainSelectedInstOperands,
     /*  23335 */     // GIR_Coverage, 5093,
     /*  23335 */     GIR_EraseRootFromParent_Done,
     /*  23336 */   // Label 392: @23336
     /*  23336 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(23474), // Rule ID 5094 //
     /*  23341 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23344 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23348 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23352 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23356 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23360 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23364 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23368 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23372 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23376 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23380 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23384 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23388 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23392 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23396 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23400 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23404 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23408 */     // MIs[4] vC
     /*  23408 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23413 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23417 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23421 */     // MIs[5] vB
     /*  23421 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23426 */     // MIs[5] vA
     /*  23426 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23431 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23435 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23441 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23443 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23445 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23445 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23448 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23450 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  23454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23458 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  23462 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23472 */     GIR_RootConstrainSelectedInstOperands,
     /*  23473 */     // GIR_Coverage, 5094,
     /*  23473 */     GIR_EraseRootFromParent_Done,
     /*  23474 */   // Label 393: @23474
     /*  23474 */   GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(23612), // Rule ID 5095 //
     /*  23479 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23482 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23486 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23490 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23494 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23498 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23502 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23506 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23510 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23514 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23518 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23522 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23526 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23530 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23534 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23538 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23542 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23546 */     // MIs[4] vB
     /*  23546 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23551 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23555 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23559 */     // MIs[5] vA
     /*  23559 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23564 */     // MIs[5] vC
     /*  23564 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23569 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23573 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23579 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23581 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23583 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23583 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23586 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23588 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  23592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23596 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  23600 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23610 */     GIR_RootConstrainSelectedInstOperands,
     /*  23611 */     // GIR_Coverage, 5095,
     /*  23611 */     GIR_EraseRootFromParent_Done,
     /*  23612 */   // Label 394: @23612
     /*  23612 */   GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(23750), // Rule ID 5096 //
     /*  23617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23620 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23624 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23628 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23632 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23636 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23640 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23644 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23648 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23652 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23656 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23660 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23664 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23668 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23672 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23676 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23680 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23684 */     // MIs[4] vB
     /*  23684 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23689 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23693 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23697 */     // MIs[5] vC
     /*  23697 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23702 */     // MIs[5] vA
     /*  23702 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23707 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23711 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23717 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23719 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23721 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23721 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23724 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23726 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  23730 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23734 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  23738 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23748 */     GIR_RootConstrainSelectedInstOperands,
     /*  23749 */     // GIR_Coverage, 5096,
     /*  23749 */     GIR_EraseRootFromParent_Done,
     /*  23750 */   // Label 395: @23750
     /*  23750 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(23888), // Rule ID 5097 //
     /*  23755 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23758 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23762 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23766 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23770 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23774 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23778 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23782 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23786 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23790 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23794 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23798 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23802 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23806 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23810 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23814 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23818 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23822 */     // MIs[4] vA
     /*  23822 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23827 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23831 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23835 */     // MIs[5] vB
     /*  23835 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23840 */     // MIs[5] vC
     /*  23840 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23845 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23849 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23855 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23857 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23859 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23859 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  23862 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  23864 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  23868 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  23872 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  23876 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  23886 */     GIR_RootConstrainSelectedInstOperands,
     /*  23887 */     // GIR_Coverage, 5097,
     /*  23887 */     GIR_EraseRootFromParent_Done,
     /*  23888 */   // Label 396: @23888
     /*  23888 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(24026), // Rule ID 5098 //
     /*  23893 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  23896 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  23900 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  23904 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23908 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23912 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23916 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  23920 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  23924 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23928 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23932 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  23936 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  23940 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  23944 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23948 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  23952 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23956 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  23960 */     // MIs[4] vA
     /*  23960 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  23965 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  23969 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  23973 */     // MIs[5] vC
     /*  23973 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  23978 */     // MIs[5] vB
     /*  23978 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  23983 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  23987 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  23993 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  23995 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  23997 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  23997 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24000 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24002 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  24006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vB
     /*  24010 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  24014 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24024 */     GIR_RootConstrainSelectedInstOperands,
     /*  24025 */     // GIR_Coverage, 5098,
     /*  24025 */     GIR_EraseRootFromParent_Done,
     /*  24026 */   // Label 397: @24026
     /*  24026 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(24164), // Rule ID 5105 //
     /*  24031 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24038 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24042 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24046 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24050 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24054 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24058 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24062 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24066 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24070 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24074 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24078 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24082 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24086 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24090 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24094 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24098 */     // MIs[4] vC
     /*  24098 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24103 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24107 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24111 */     // MIs[5] vA
     /*  24111 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24116 */     // MIs[5] vB
     /*  24116 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24121 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24125 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24131 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24133 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24135 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24135 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24138 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24140 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24144 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  24148 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  24152 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24162 */     GIR_RootConstrainSelectedInstOperands,
     /*  24163 */     // GIR_Coverage, 5105,
     /*  24163 */     GIR_EraseRootFromParent_Done,
     /*  24164 */   // Label 398: @24164
     /*  24164 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(24302), // Rule ID 5106 //
     /*  24169 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24172 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24176 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24180 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24184 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24188 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24192 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24196 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24200 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24204 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24208 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24212 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24216 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24220 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24224 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24228 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24232 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24236 */     // MIs[4] vC
     /*  24236 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24241 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24245 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24249 */     // MIs[5] vB
     /*  24249 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24254 */     // MIs[5] vA
     /*  24254 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24259 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24263 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24269 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24271 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24273 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24273 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24276 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24278 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  24286 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  24290 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24300 */     GIR_RootConstrainSelectedInstOperands,
     /*  24301 */     // GIR_Coverage, 5106,
     /*  24301 */     GIR_EraseRootFromParent_Done,
     /*  24302 */   // Label 399: @24302
     /*  24302 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(24440), // Rule ID 5107 //
     /*  24307 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24310 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24314 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24318 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24322 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24326 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24330 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24334 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24338 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24342 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24346 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24350 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24354 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24358 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24362 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24366 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24370 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24374 */     // MIs[4] vB
     /*  24374 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24379 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24383 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24387 */     // MIs[5] vA
     /*  24387 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24392 */     // MIs[5] vC
     /*  24392 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24397 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24401 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24407 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24409 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24411 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24411 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24414 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24416 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  24424 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  24428 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24438 */     GIR_RootConstrainSelectedInstOperands,
     /*  24439 */     // GIR_Coverage, 5107,
     /*  24439 */     GIR_EraseRootFromParent_Done,
     /*  24440 */   // Label 400: @24440
     /*  24440 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(24578), // Rule ID 5108 //
     /*  24445 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24448 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24452 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24456 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24460 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24464 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24468 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24472 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24476 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24480 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24484 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24488 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24492 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24496 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24500 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24504 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24508 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24512 */     // MIs[4] vB
     /*  24512 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24517 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24521 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24525 */     // MIs[5] vC
     /*  24525 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24530 */     // MIs[5] vA
     /*  24530 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24535 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24539 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24545 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24547 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24549 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24549 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24552 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24554 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24558 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  24562 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  24566 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24576 */     GIR_RootConstrainSelectedInstOperands,
     /*  24577 */     // GIR_Coverage, 5108,
     /*  24577 */     GIR_EraseRootFromParent_Done,
     /*  24578 */   // Label 401: @24578
     /*  24578 */   GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(24716), // Rule ID 5109 //
     /*  24583 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24586 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24590 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24594 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24598 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24602 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24606 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24610 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24614 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24618 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24622 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24626 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24630 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24634 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24638 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24642 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24646 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24650 */     // MIs[4] vA
     /*  24650 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24655 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24659 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24663 */     // MIs[5] vC
     /*  24663 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24668 */     // MIs[5] vB
     /*  24668 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24673 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24677 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24683 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24685 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24687 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24687 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24690 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24692 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24696 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  24700 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  24704 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24714 */     GIR_RootConstrainSelectedInstOperands,
     /*  24715 */     // GIR_Coverage, 5109,
     /*  24715 */     GIR_EraseRootFromParent_Done,
     /*  24716 */   // Label 402: @24716
     /*  24716 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(24854), // Rule ID 5116 //
     /*  24721 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24724 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24728 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24732 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24736 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24740 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24744 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24748 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24752 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24756 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24760 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24764 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24768 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24772 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24776 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24780 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24784 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24788 */     // MIs[4] vC
     /*  24788 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24793 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24797 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24801 */     // MIs[5] vA
     /*  24801 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24806 */     // MIs[5] vB
     /*  24806 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24811 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24815 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24821 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24823 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24825 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24825 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24828 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24830 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24834 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  24838 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  24842 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24852 */     GIR_RootConstrainSelectedInstOperands,
     /*  24853 */     // GIR_Coverage, 5116,
     /*  24853 */     GIR_EraseRootFromParent_Done,
     /*  24854 */   // Label 403: @24854
     /*  24854 */   GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(24992), // Rule ID 5117 //
     /*  24859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  24862 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  24866 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  24870 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24874 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24878 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24882 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  24886 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  24890 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24894 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24898 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  24902 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  24906 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  24910 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24914 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  24918 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24922 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  24926 */     // MIs[4] vC
     /*  24926 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  24931 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  24935 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  24939 */     // MIs[5] vB
     /*  24939 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  24944 */     // MIs[5] vA
     /*  24944 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  24949 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  24953 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  24959 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  24961 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  24963 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  24963 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  24966 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  24968 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  24972 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  24976 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  24980 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  24990 */     GIR_RootConstrainSelectedInstOperands,
     /*  24991 */     // GIR_Coverage, 5117,
     /*  24991 */     GIR_EraseRootFromParent_Done,
     /*  24992 */   // Label 404: @24992
     /*  24992 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(25130), // Rule ID 5118 //
     /*  24997 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25000 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25004 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25008 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25012 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25016 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25020 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25024 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25028 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25032 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25036 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  25040 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25044 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25048 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25052 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  25056 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25060 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25064 */     // MIs[4] vB
     /*  25064 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25069 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  25073 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25077 */     // MIs[5] vA
     /*  25077 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  25082 */     // MIs[5] vC
     /*  25082 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25087 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  25091 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25097 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  25099 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25101 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25101 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25104 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25106 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  25110 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  25114 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  25118 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25128 */     GIR_RootConstrainSelectedInstOperands,
     /*  25129 */     // GIR_Coverage, 5118,
     /*  25129 */     GIR_EraseRootFromParent_Done,
     /*  25130 */   // Label 405: @25130
     /*  25130 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(25268), // Rule ID 5119 //
     /*  25135 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25138 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25142 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25146 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25150 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25154 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25158 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25162 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25166 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25170 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25174 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  25178 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25182 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25186 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25190 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  25194 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25198 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25202 */     // MIs[4] vB
     /*  25202 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25207 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  25211 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25215 */     // MIs[5] vC
     /*  25215 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25220 */     // MIs[5] vA
     /*  25220 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  25225 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  25229 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25235 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  25237 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25239 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25239 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25242 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25244 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  25248 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  25252 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  25256 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25266 */     GIR_RootConstrainSelectedInstOperands,
     /*  25267 */     // GIR_Coverage, 5119,
     /*  25267 */     GIR_EraseRootFromParent_Done,
     /*  25268 */   // Label 406: @25268
     /*  25268 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(25406), // Rule ID 5120 //
     /*  25273 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25276 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25280 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25284 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25288 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25292 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25296 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25300 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25304 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25308 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25312 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  25316 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25320 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25324 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25328 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  25332 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25336 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25340 */     // MIs[4] vA
     /*  25340 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  25345 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  25349 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25353 */     // MIs[5] vB
     /*  25353 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25358 */     // MIs[5] vC
     /*  25358 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25363 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  25367 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25373 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  25375 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25377 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25377 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25380 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25382 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  25386 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  25390 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  25394 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25404 */     GIR_RootConstrainSelectedInstOperands,
     /*  25405 */     // GIR_Coverage, 5120,
     /*  25405 */     GIR_EraseRootFromParent_Done,
     /*  25406 */   // Label 407: @25406
     /*  25406 */   GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(25544), // Rule ID 5121 //
     /*  25411 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25414 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25418 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25422 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25426 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25430 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25434 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*  25438 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25442 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25446 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25450 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
     /*  25454 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25458 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25462 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25466 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
     /*  25470 */     GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25474 */     GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25478 */     // MIs[4] vA
     /*  25478 */     GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
     /*  25483 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/4, /*OpIdx*/2, // MIs[5]
     /*  25487 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25491 */     // MIs[5] vC
     /*  25491 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  25496 */     // MIs[5] vB
     /*  25496 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25501 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/3, /*OpIdx*/2, // MIs[6]
     /*  25505 */     GIM_CheckOpcodeIsEither, /*MI*/6, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25511 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/6,
     /*  25513 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25515 */     // (or:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25515 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25518 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25520 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vA
     /*  25524 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  25528 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  25532 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25542 */     GIR_RootConstrainSelectedInstOperands,
     /*  25543 */     // GIR_Coverage, 5121,
     /*  25543 */     GIR_EraseRootFromParent_Done,
     /*  25544 */   // Label 408: @25544
     /*  25544 */   GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(25682), // Rule ID 5122 //
     /*  25549 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25552 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25556 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25560 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25564 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25568 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25572 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25576 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25580 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25584 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25588 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25592 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25596 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25600 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25604 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  25608 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25614 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  25616 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  25620 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25624 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25628 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  25632 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25636 */     // MIs[6] vA
     /*  25636 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25641 */     // MIs[6] vB
     /*  25641 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  25646 */     // MIs[5] vC
     /*  25646 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25651 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25653 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25653 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25656 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25658 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  25662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  25666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  25670 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25680 */     GIR_RootConstrainSelectedInstOperands,
     /*  25681 */     // GIR_Coverage, 5122,
     /*  25681 */     GIR_EraseRootFromParent_Done,
     /*  25682 */   // Label 409: @25682
     /*  25682 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(25820), // Rule ID 5123 //
     /*  25687 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25690 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25694 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25698 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25702 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25706 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25710 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25714 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25718 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25722 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25726 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25730 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25734 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25738 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25742 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  25746 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25752 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  25754 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  25758 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25762 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25766 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  25770 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25774 */     // MIs[6] vB
     /*  25774 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  25779 */     // MIs[6] vA
     /*  25779 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25784 */     // MIs[5] vC
     /*  25784 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25789 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25791 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25791 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25794 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25796 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  25800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  25804 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  25808 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25818 */     GIR_RootConstrainSelectedInstOperands,
     /*  25819 */     // GIR_Coverage, 5123,
     /*  25819 */     GIR_EraseRootFromParent_Done,
     /*  25820 */   // Label 410: @25820
     /*  25820 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(25958), // Rule ID 5124 //
     /*  25825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25828 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25832 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25836 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25840 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25844 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25848 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25852 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25856 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25860 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25864 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  25868 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25872 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25876 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25880 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  25884 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  25890 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  25892 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  25896 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25900 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25904 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  25908 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  25912 */     // MIs[6] vA
     /*  25912 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  25917 */     // MIs[6] vC
     /*  25917 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  25922 */     // MIs[5] vB
     /*  25922 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  25927 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  25929 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  25929 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  25932 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  25934 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  25938 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  25942 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  25946 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  25956 */     GIR_RootConstrainSelectedInstOperands,
     /*  25957 */     // GIR_Coverage, 5124,
     /*  25957 */     GIR_EraseRootFromParent_Done,
     /*  25958 */   // Label 411: @25958
     /*  25958 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(26096), // Rule ID 5125 //
     /*  25963 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  25966 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  25970 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  25974 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  25978 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25982 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  25986 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  25990 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  25994 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  25998 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26002 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26006 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26010 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26014 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26018 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26022 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26028 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26030 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26034 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26038 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26042 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26046 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26050 */     // MIs[6] vC
     /*  26050 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26055 */     // MIs[6] vA
     /*  26055 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26060 */     // MIs[5] vB
     /*  26060 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26065 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26067 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26067 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26070 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26072 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  26076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  26080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26084 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26094 */     GIR_RootConstrainSelectedInstOperands,
     /*  26095 */     // GIR_Coverage, 5125,
     /*  26095 */     GIR_EraseRootFromParent_Done,
     /*  26096 */   // Label 412: @26096
     /*  26096 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(26234), // Rule ID 5126 //
     /*  26101 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26104 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26108 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26112 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26116 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26120 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26124 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26128 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26132 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26136 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26140 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26144 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26148 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26152 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26156 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26160 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26166 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26168 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26172 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26176 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26180 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26184 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26188 */     // MIs[6] vB
     /*  26188 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26193 */     // MIs[6] vC
     /*  26193 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26198 */     // MIs[5] vA
     /*  26198 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26203 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26205 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26205 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26208 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26210 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  26214 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  26218 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26222 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26232 */     GIR_RootConstrainSelectedInstOperands,
     /*  26233 */     // GIR_Coverage, 5126,
     /*  26233 */     GIR_EraseRootFromParent_Done,
     /*  26234 */   // Label 413: @26234
     /*  26234 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(26372), // Rule ID 5127 //
     /*  26239 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26242 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26246 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26250 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26254 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26258 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26262 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26266 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26270 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26274 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26278 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26282 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26286 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26290 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26294 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26298 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26304 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26306 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26310 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26314 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26318 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26322 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26326 */     // MIs[6] vC
     /*  26326 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26331 */     // MIs[6] vB
     /*  26331 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26336 */     // MIs[5] vA
     /*  26336 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26341 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26343 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26343 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26346 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26348 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  26352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  26356 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26360 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26370 */     GIR_RootConstrainSelectedInstOperands,
     /*  26371 */     // GIR_Coverage, 5127,
     /*  26371 */     GIR_EraseRootFromParent_Done,
     /*  26372 */   // Label 414: @26372
     /*  26372 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(26510), // Rule ID 5134 //
     /*  26377 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26380 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26384 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26388 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26392 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26396 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26400 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26404 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26408 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26412 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26416 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26420 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26424 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26428 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26432 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26436 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26442 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26444 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26448 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26452 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26456 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26460 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26464 */     // MIs[6] vA
     /*  26464 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26469 */     // MIs[6] vB
     /*  26469 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26474 */     // MIs[5] vC
     /*  26474 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26479 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26481 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26481 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26484 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  26490 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  26494 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26498 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26508 */     GIR_RootConstrainSelectedInstOperands,
     /*  26509 */     // GIR_Coverage, 5134,
     /*  26509 */     GIR_EraseRootFromParent_Done,
     /*  26510 */   // Label 415: @26510
     /*  26510 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(26648), // Rule ID 5135 //
     /*  26515 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26518 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26522 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26526 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26530 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26534 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26538 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26542 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26546 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26550 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26554 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26558 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26562 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26566 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26570 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26574 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26580 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26582 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26586 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26590 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26594 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26598 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26602 */     // MIs[6] vB
     /*  26602 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26607 */     // MIs[6] vA
     /*  26607 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26612 */     // MIs[5] vC
     /*  26612 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26617 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26619 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26619 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26622 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26624 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  26628 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  26632 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26636 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26646 */     GIR_RootConstrainSelectedInstOperands,
     /*  26647 */     // GIR_Coverage, 5135,
     /*  26647 */     GIR_EraseRootFromParent_Done,
     /*  26648 */   // Label 416: @26648
     /*  26648 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(26786), // Rule ID 5136 //
     /*  26653 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26656 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26668 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26672 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26676 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26680 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26684 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26688 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26692 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26696 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26700 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26704 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26708 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26712 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26718 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26720 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26724 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26728 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26732 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26736 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26740 */     // MIs[6] vA
     /*  26740 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26745 */     // MIs[6] vC
     /*  26745 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26750 */     // MIs[5] vB
     /*  26750 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26755 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26757 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26757 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26760 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26762 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  26766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  26770 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26774 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26784 */     GIR_RootConstrainSelectedInstOperands,
     /*  26785 */     // GIR_Coverage, 5136,
     /*  26785 */     GIR_EraseRootFromParent_Done,
     /*  26786 */   // Label 417: @26786
     /*  26786 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(26924), // Rule ID 5137 //
     /*  26791 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26794 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26798 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26802 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26806 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26810 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26814 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26818 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26822 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26826 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26830 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26834 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26838 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26842 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26846 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26850 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26856 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26858 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  26862 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26866 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26870 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  26874 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  26878 */     // MIs[6] vC
     /*  26878 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  26883 */     // MIs[6] vA
     /*  26883 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  26888 */     // MIs[5] vB
     /*  26888 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  26893 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  26895 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  26895 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  26898 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  26900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  26904 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  26908 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  26912 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  26922 */     GIR_RootConstrainSelectedInstOperands,
     /*  26923 */     // GIR_Coverage, 5137,
     /*  26923 */     GIR_EraseRootFromParent_Done,
     /*  26924 */   // Label 418: @26924
     /*  26924 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(27062), // Rule ID 5138 //
     /*  26929 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  26932 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  26936 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  26940 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  26944 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26948 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26952 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  26956 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26960 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26964 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26968 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  26972 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  26976 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  26980 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  26984 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  26988 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  26994 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  26996 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27000 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27004 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27008 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27012 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27016 */     // MIs[6] vB
     /*  27016 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27021 */     // MIs[6] vC
     /*  27021 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27026 */     // MIs[5] vA
     /*  27026 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27031 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27033 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27033 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27036 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27038 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  27042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  27046 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  27050 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27060 */     GIR_RootConstrainSelectedInstOperands,
     /*  27061 */     // GIR_Coverage, 5138,
     /*  27061 */     GIR_EraseRootFromParent_Done,
     /*  27062 */   // Label 419: @27062
     /*  27062 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(27200), // Rule ID 5139 //
     /*  27067 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27070 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27074 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27078 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27082 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27086 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27090 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27094 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27098 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27102 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27106 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27110 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27114 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27118 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27122 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27126 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27132 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27134 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27138 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27142 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27146 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27150 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27154 */     // MIs[6] vC
     /*  27154 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27159 */     // MIs[6] vB
     /*  27159 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27164 */     // MIs[5] vA
     /*  27164 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27169 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27171 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27171 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27174 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27176 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  27180 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  27184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  27188 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27198 */     GIR_RootConstrainSelectedInstOperands,
     /*  27199 */     // GIR_Coverage, 5139,
     /*  27199 */     GIR_EraseRootFromParent_Done,
     /*  27200 */   // Label 420: @27200
     /*  27200 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(27338), // Rule ID 5146 //
     /*  27205 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27208 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27212 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27216 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27220 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27224 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27228 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27232 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27236 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27240 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27244 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27248 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27252 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27256 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27260 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27264 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27270 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27272 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27276 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27280 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27284 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27288 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27292 */     // MIs[6] vA
     /*  27292 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27297 */     // MIs[6] vB
     /*  27297 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27302 */     // MIs[5] vC
     /*  27302 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27307 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27309 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27309 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27312 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27314 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  27318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  27322 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  27326 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27336 */     GIR_RootConstrainSelectedInstOperands,
     /*  27337 */     // GIR_Coverage, 5146,
     /*  27337 */     GIR_EraseRootFromParent_Done,
     /*  27338 */   // Label 421: @27338
     /*  27338 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(27476), // Rule ID 5147 //
     /*  27343 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27346 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27350 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27354 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27358 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27362 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27366 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27370 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27374 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27378 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27382 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27386 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27390 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27394 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27398 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27402 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27408 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27410 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27414 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27418 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27422 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27426 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27430 */     // MIs[6] vB
     /*  27430 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27435 */     // MIs[6] vA
     /*  27435 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27440 */     // MIs[5] vC
     /*  27440 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27445 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27447 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27447 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27450 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27452 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  27456 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  27460 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  27464 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27474 */     GIR_RootConstrainSelectedInstOperands,
     /*  27475 */     // GIR_Coverage, 5147,
     /*  27475 */     GIR_EraseRootFromParent_Done,
     /*  27476 */   // Label 422: @27476
     /*  27476 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(27614), // Rule ID 5148 //
     /*  27481 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27484 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27488 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27492 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27496 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27500 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27504 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27508 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27512 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27516 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27520 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27524 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27528 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27532 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27536 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27540 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27546 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27548 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27552 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27556 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27560 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27564 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27568 */     // MIs[6] vA
     /*  27568 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27573 */     // MIs[6] vC
     /*  27573 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27578 */     // MIs[5] vB
     /*  27578 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27583 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27585 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27585 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27588 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27590 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  27594 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  27598 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  27602 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27612 */     GIR_RootConstrainSelectedInstOperands,
     /*  27613 */     // GIR_Coverage, 5148,
     /*  27613 */     GIR_EraseRootFromParent_Done,
     /*  27614 */   // Label 423: @27614
     /*  27614 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(27752), // Rule ID 5149 //
     /*  27619 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27622 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27626 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27630 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27634 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27638 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27642 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27646 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27650 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27654 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27658 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27662 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27666 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27670 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27674 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27678 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27684 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27686 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27690 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27694 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27698 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27702 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27706 */     // MIs[6] vC
     /*  27706 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27711 */     // MIs[6] vA
     /*  27711 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27716 */     // MIs[5] vB
     /*  27716 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27721 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27723 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27723 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27726 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27728 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  27732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  27736 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  27740 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27750 */     GIR_RootConstrainSelectedInstOperands,
     /*  27751 */     // GIR_Coverage, 5149,
     /*  27751 */     GIR_EraseRootFromParent_Done,
     /*  27752 */   // Label 424: @27752
     /*  27752 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(27890), // Rule ID 5150 //
     /*  27757 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27760 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27764 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27768 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27772 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27776 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27780 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27784 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27788 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27792 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27796 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27800 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27804 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27808 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27812 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27816 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27822 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27824 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27828 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27832 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27836 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27840 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27844 */     // MIs[6] vB
     /*  27844 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27849 */     // MIs[6] vC
     /*  27849 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27854 */     // MIs[5] vA
     /*  27854 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27859 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27861 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27861 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  27864 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  27866 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  27870 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  27874 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  27878 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  27888 */     GIR_RootConstrainSelectedInstOperands,
     /*  27889 */     // GIR_Coverage, 5150,
     /*  27889 */     GIR_EraseRootFromParent_Done,
     /*  27890 */   // Label 425: @27890
     /*  27890 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(28028), // Rule ID 5151 //
     /*  27895 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  27898 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  27902 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  27906 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  27910 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27914 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27918 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  27922 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27926 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27930 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27934 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  27938 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  27942 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27946 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  27950 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  27954 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  27960 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  27962 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  27966 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27970 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  27974 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  27978 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  27982 */     // MIs[6] vC
     /*  27982 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  27987 */     // MIs[6] vB
     /*  27987 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  27992 */     // MIs[5] vA
     /*  27992 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  27997 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  27999 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  27999 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28002 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28004 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  28008 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28012 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  28016 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28026 */     GIR_RootConstrainSelectedInstOperands,
     /*  28027 */     // GIR_Coverage, 5151,
     /*  28027 */     GIR_EraseRootFromParent_Done,
     /*  28028 */   // Label 426: @28028
     /*  28028 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(28166), // Rule ID 5158 //
     /*  28033 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28036 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28040 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28044 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28048 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28052 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28056 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28060 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28064 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28068 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28072 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28076 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28080 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28084 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28088 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28092 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28098 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28100 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28104 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28108 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28112 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28116 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28120 */     // MIs[6] vA
     /*  28120 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28125 */     // MIs[6] vB
     /*  28125 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28130 */     // MIs[5] vC
     /*  28130 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28135 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28137 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28137 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28140 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28142 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  28146 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28150 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  28154 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28164 */     GIR_RootConstrainSelectedInstOperands,
     /*  28165 */     // GIR_Coverage, 5158,
     /*  28165 */     GIR_EraseRootFromParent_Done,
     /*  28166 */   // Label 427: @28166
     /*  28166 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(28304), // Rule ID 5159 //
     /*  28171 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28174 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28178 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28182 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28186 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28190 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28194 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28198 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28202 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28206 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28210 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28214 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28218 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28222 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28226 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28230 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28236 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28238 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28242 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28246 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28250 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28254 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28258 */     // MIs[6] vB
     /*  28258 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28263 */     // MIs[6] vA
     /*  28263 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28268 */     // MIs[5] vC
     /*  28268 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28273 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28275 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28275 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28278 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28280 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  28284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28288 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  28292 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28302 */     GIR_RootConstrainSelectedInstOperands,
     /*  28303 */     // GIR_Coverage, 5159,
     /*  28303 */     GIR_EraseRootFromParent_Done,
     /*  28304 */   // Label 428: @28304
     /*  28304 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(28442), // Rule ID 5160 //
     /*  28309 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28312 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28316 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28320 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28324 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28328 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28332 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28336 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28340 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28344 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28348 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28352 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28356 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28360 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28364 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28368 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28374 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28376 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28380 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28384 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28388 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28392 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28396 */     // MIs[6] vA
     /*  28396 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28401 */     // MIs[6] vC
     /*  28401 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28406 */     // MIs[5] vB
     /*  28406 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28411 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28413 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28413 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28416 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28418 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  28422 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28426 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  28430 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28440 */     GIR_RootConstrainSelectedInstOperands,
     /*  28441 */     // GIR_Coverage, 5160,
     /*  28441 */     GIR_EraseRootFromParent_Done,
     /*  28442 */   // Label 429: @28442
     /*  28442 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(28580), // Rule ID 5161 //
     /*  28447 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28450 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28454 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28458 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28462 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28466 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28470 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28474 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28478 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28482 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28486 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28490 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28494 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28498 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28502 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28506 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28512 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28514 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28518 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28522 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28526 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28530 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28534 */     // MIs[6] vC
     /*  28534 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28539 */     // MIs[6] vA
     /*  28539 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28544 */     // MIs[5] vB
     /*  28544 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28549 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28551 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28551 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28554 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28556 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  28560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28564 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  28568 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28578 */     GIR_RootConstrainSelectedInstOperands,
     /*  28579 */     // GIR_Coverage, 5161,
     /*  28579 */     GIR_EraseRootFromParent_Done,
     /*  28580 */   // Label 430: @28580
     /*  28580 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(28718), // Rule ID 5162 //
     /*  28585 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28588 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28592 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28596 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28600 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28604 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28608 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28612 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28616 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28620 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28624 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28628 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28632 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28636 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28640 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28644 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28650 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28652 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28656 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28660 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28664 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28668 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28672 */     // MIs[6] vB
     /*  28672 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28677 */     // MIs[6] vC
     /*  28677 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28682 */     // MIs[5] vA
     /*  28682 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28687 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28689 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28689 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28692 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28694 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  28698 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28702 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  28706 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28716 */     GIR_RootConstrainSelectedInstOperands,
     /*  28717 */     // GIR_Coverage, 5162,
     /*  28717 */     GIR_EraseRootFromParent_Done,
     /*  28718 */   // Label 431: @28718
     /*  28718 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(28856), // Rule ID 5163 //
     /*  28723 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28726 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28730 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28734 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28738 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28742 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28746 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28750 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28754 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28758 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28762 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28766 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28770 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28774 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28778 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28782 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28788 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28790 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28794 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28798 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28802 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28806 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28810 */     // MIs[6] vC
     /*  28810 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28815 */     // MIs[6] vB
     /*  28815 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28820 */     // MIs[5] vA
     /*  28820 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28825 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28827 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28827 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28830 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28832 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  28836 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  28840 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  28844 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28854 */     GIR_RootConstrainSelectedInstOperands,
     /*  28855 */     // GIR_Coverage, 5163,
     /*  28855 */     GIR_EraseRootFromParent_Done,
     /*  28856 */   // Label 432: @28856
     /*  28856 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(28994), // Rule ID 5170 //
     /*  28861 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  28864 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  28868 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  28872 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  28876 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28880 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28884 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  28888 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28892 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28896 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28900 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  28904 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  28908 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28912 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  28916 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  28920 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  28926 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  28928 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  28932 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28936 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  28940 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  28944 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  28948 */     // MIs[6] vA
     /*  28948 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  28953 */     // MIs[6] vB
     /*  28953 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  28958 */     // MIs[5] vC
     /*  28958 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  28963 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  28965 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  28965 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  28968 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  28970 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  28974 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  28978 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  28982 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  28992 */     GIR_RootConstrainSelectedInstOperands,
     /*  28993 */     // GIR_Coverage, 5170,
     /*  28993 */     GIR_EraseRootFromParent_Done,
     /*  28994 */   // Label 433: @28994
     /*  28994 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(29132), // Rule ID 5171 //
     /*  28999 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29002 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29006 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29010 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29014 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29018 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29022 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29026 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29030 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29034 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29038 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29042 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29046 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29050 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29054 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29058 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29064 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29066 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29070 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29074 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29078 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29082 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29086 */     // MIs[6] vB
     /*  29086 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29091 */     // MIs[6] vA
     /*  29091 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29096 */     // MIs[5] vC
     /*  29096 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29101 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29103 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29103 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29106 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29108 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29112 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  29116 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  29120 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29130 */     GIR_RootConstrainSelectedInstOperands,
     /*  29131 */     // GIR_Coverage, 5171,
     /*  29131 */     GIR_EraseRootFromParent_Done,
     /*  29132 */   // Label 434: @29132
     /*  29132 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(29270), // Rule ID 5172 //
     /*  29137 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29140 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29144 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29148 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29152 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29156 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29160 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29164 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29168 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29172 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29176 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29180 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29184 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29188 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29192 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29196 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29202 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29204 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29208 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29212 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29216 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29220 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29224 */     // MIs[6] vA
     /*  29224 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29229 */     // MIs[6] vC
     /*  29229 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29234 */     // MIs[5] vB
     /*  29234 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29239 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29241 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29241 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29244 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29246 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29250 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  29254 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  29258 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29268 */     GIR_RootConstrainSelectedInstOperands,
     /*  29269 */     // GIR_Coverage, 5172,
     /*  29269 */     GIR_EraseRootFromParent_Done,
     /*  29270 */   // Label 435: @29270
     /*  29270 */   GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(29408), // Rule ID 5173 //
     /*  29275 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29278 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29282 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29286 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29290 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29294 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29298 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29302 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29306 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29310 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29314 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29318 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29322 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29326 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29330 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29334 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29340 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29342 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29346 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29350 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29354 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29358 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29362 */     // MIs[6] vC
     /*  29362 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29367 */     // MIs[6] vA
     /*  29367 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29372 */     // MIs[5] vB
     /*  29372 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29377 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29379 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29379 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29382 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29384 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29388 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  29392 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  29396 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29406 */     GIR_RootConstrainSelectedInstOperands,
     /*  29407 */     // GIR_Coverage, 5173,
     /*  29407 */     GIR_EraseRootFromParent_Done,
     /*  29408 */   // Label 436: @29408
     /*  29408 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(29546), // Rule ID 5174 //
     /*  29413 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29416 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29420 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29424 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29428 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29432 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29436 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29440 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29444 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29448 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29452 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29456 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29460 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29464 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29468 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29472 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29478 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29480 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29484 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29488 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29492 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29496 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29500 */     // MIs[6] vB
     /*  29500 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29505 */     // MIs[6] vC
     /*  29505 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29510 */     // MIs[5] vA
     /*  29510 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29515 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29517 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29517 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29520 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29526 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  29530 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  29534 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29544 */     GIR_RootConstrainSelectedInstOperands,
     /*  29545 */     // GIR_Coverage, 5174,
     /*  29545 */     GIR_EraseRootFromParent_Done,
     /*  29546 */   // Label 437: @29546
     /*  29546 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(29684), // Rule ID 5175 //
     /*  29551 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29554 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29558 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29562 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29566 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29570 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29574 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29578 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29582 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29586 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29590 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29594 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29598 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29602 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29606 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29610 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29616 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29618 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29622 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29626 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29630 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29634 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29638 */     // MIs[6] vC
     /*  29638 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29643 */     // MIs[6] vB
     /*  29643 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29648 */     // MIs[5] vA
     /*  29648 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29653 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29655 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29655 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29658 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29660 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  29668 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  29672 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29682 */     GIR_RootConstrainSelectedInstOperands,
     /*  29683 */     // GIR_Coverage, 5175,
     /*  29683 */     GIR_EraseRootFromParent_Done,
     /*  29684 */   // Label 438: @29684
     /*  29684 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(29822), // Rule ID 5182 //
     /*  29689 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29692 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29696 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29700 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29704 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29708 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29712 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29716 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29720 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29724 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29728 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29732 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29736 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29740 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29744 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29748 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29754 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29756 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29760 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29764 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29768 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29772 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29776 */     // MIs[6] vA
     /*  29776 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29781 */     // MIs[6] vB
     /*  29781 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29786 */     // MIs[5] vC
     /*  29786 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29791 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29793 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29793 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29796 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29798 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  29806 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  29810 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29820 */     GIR_RootConstrainSelectedInstOperands,
     /*  29821 */     // GIR_Coverage, 5182,
     /*  29821 */     GIR_EraseRootFromParent_Done,
     /*  29822 */   // Label 439: @29822
     /*  29822 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(29960), // Rule ID 5183 //
     /*  29827 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29830 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29834 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29838 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29842 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29846 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29850 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29854 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29858 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29862 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29866 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  29870 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29874 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29878 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29882 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  29886 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  29892 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  29894 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  29898 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29902 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29906 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  29910 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  29914 */     // MIs[6] vB
     /*  29914 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  29919 */     // MIs[6] vA
     /*  29919 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  29924 */     // MIs[5] vC
     /*  29924 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  29929 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  29931 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  29931 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  29934 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  29936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  29940 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  29944 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  29948 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  29958 */     GIR_RootConstrainSelectedInstOperands,
     /*  29959 */     // GIR_Coverage, 5183,
     /*  29959 */     GIR_EraseRootFromParent_Done,
     /*  29960 */   // Label 440: @29960
     /*  29960 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(30098), // Rule ID 5184 //
     /*  29965 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  29968 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  29972 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  29976 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  29980 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  29984 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  29988 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  29992 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  29996 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30000 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30004 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30008 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30012 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30016 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30020 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30024 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30030 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30032 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30036 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30040 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30044 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30048 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30052 */     // MIs[6] vA
     /*  30052 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30057 */     // MIs[6] vC
     /*  30057 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30062 */     // MIs[5] vB
     /*  30062 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30067 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30069 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30069 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30072 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30074 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  30078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30082 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  30086 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30096 */     GIR_RootConstrainSelectedInstOperands,
     /*  30097 */     // GIR_Coverage, 5184,
     /*  30097 */     GIR_EraseRootFromParent_Done,
     /*  30098 */   // Label 441: @30098
     /*  30098 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(30236), // Rule ID 5185 //
     /*  30103 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30106 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30110 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30114 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30118 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30122 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30126 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30130 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30134 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30138 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30142 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30146 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30150 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30154 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30158 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30162 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30168 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30170 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30174 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30178 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30182 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30186 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30190 */     // MIs[6] vC
     /*  30190 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30195 */     // MIs[6] vA
     /*  30195 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30200 */     // MIs[5] vB
     /*  30200 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30205 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30207 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30207 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30210 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30212 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  30216 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30220 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  30224 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30234 */     GIR_RootConstrainSelectedInstOperands,
     /*  30235 */     // GIR_Coverage, 5185,
     /*  30235 */     GIR_EraseRootFromParent_Done,
     /*  30236 */   // Label 442: @30236
     /*  30236 */   GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(30374), // Rule ID 5186 //
     /*  30241 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30244 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30248 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30252 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30256 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30260 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30264 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30268 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30272 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30276 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30280 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30284 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30288 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30292 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30296 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30300 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30306 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30308 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30312 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30316 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30320 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30324 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30328 */     // MIs[6] vB
     /*  30328 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30333 */     // MIs[6] vC
     /*  30333 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30338 */     // MIs[5] vA
     /*  30338 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30343 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30345 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30345 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30348 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30350 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  30354 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30358 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  30362 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30372 */     GIR_RootConstrainSelectedInstOperands,
     /*  30373 */     // GIR_Coverage, 5186,
     /*  30373 */     GIR_EraseRootFromParent_Done,
     /*  30374 */   // Label 443: @30374
     /*  30374 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(30512), // Rule ID 5187 //
     /*  30379 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30382 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30386 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30390 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30394 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30398 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30402 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30406 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30410 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30414 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30418 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30422 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30426 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30430 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30434 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30438 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30444 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30446 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30450 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30454 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30458 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  30462 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30466 */     // MIs[6] vC
     /*  30466 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30471 */     // MIs[6] vB
     /*  30471 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30476 */     // MIs[5] vA
     /*  30476 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30481 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30483 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30483 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30486 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  30492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30496 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  30500 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30510 */     GIR_RootConstrainSelectedInstOperands,
     /*  30511 */     // GIR_Coverage, 5187,
     /*  30511 */     GIR_EraseRootFromParent_Done,
     /*  30512 */   // Label 444: @30512
     /*  30512 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(30650), // Rule ID 5128 //
     /*  30517 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30520 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30524 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30528 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30532 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30536 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30540 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30544 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30548 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30552 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30556 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30560 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30564 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30568 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30572 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30576 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30582 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30584 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30588 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30592 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30596 */     // MIs[5] vC
     /*  30596 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30601 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  30605 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30609 */     // MIs[6] vA
     /*  30609 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30614 */     // MIs[6] vB
     /*  30614 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30619 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30621 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30621 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30624 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  30630 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30634 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  30638 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30648 */     GIR_RootConstrainSelectedInstOperands,
     /*  30649 */     // GIR_Coverage, 5128,
     /*  30649 */     GIR_EraseRootFromParent_Done,
     /*  30650 */   // Label 445: @30650
     /*  30650 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(30788), // Rule ID 5129 //
     /*  30655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30658 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30670 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30674 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30678 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30682 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30686 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30690 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30694 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30698 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30702 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30706 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30710 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30714 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30720 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30722 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30726 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30730 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30734 */     // MIs[5] vC
     /*  30734 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30739 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  30743 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30747 */     // MIs[6] vB
     /*  30747 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30752 */     // MIs[6] vA
     /*  30752 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30757 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30759 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30759 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30762 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30764 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  30768 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  30776 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30786 */     GIR_RootConstrainSelectedInstOperands,
     /*  30787 */     // GIR_Coverage, 5129,
     /*  30787 */     GIR_EraseRootFromParent_Done,
     /*  30788 */   // Label 446: @30788
     /*  30788 */   GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(30926), // Rule ID 5130 //
     /*  30793 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30796 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30800 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30804 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30808 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30812 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30816 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30820 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30824 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30828 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30832 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30836 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30840 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30844 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30848 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30852 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30858 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30860 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  30864 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30868 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30872 */     // MIs[5] vB
     /*  30872 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  30877 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  30881 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  30885 */     // MIs[6] vA
     /*  30885 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  30890 */     // MIs[6] vC
     /*  30890 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  30895 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  30897 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  30897 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  30900 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  30902 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  30906 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  30910 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  30914 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  30924 */     GIR_RootConstrainSelectedInstOperands,
     /*  30925 */     // GIR_Coverage, 5130,
     /*  30925 */     GIR_EraseRootFromParent_Done,
     /*  30926 */   // Label 447: @30926
     /*  30926 */   GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(31064), // Rule ID 5131 //
     /*  30931 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  30934 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  30938 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  30942 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  30946 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30950 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30954 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  30958 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30962 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30966 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30970 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  30974 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  30978 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  30982 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  30986 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  30990 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  30996 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  30998 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31002 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31006 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31010 */     // MIs[5] vB
     /*  31010 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31015 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31019 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31023 */     // MIs[6] vC
     /*  31023 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31028 */     // MIs[6] vA
     /*  31028 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31033 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31035 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31035 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31038 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31040 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  31044 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  31048 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31052 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31062 */     GIR_RootConstrainSelectedInstOperands,
     /*  31063 */     // GIR_Coverage, 5131,
     /*  31063 */     GIR_EraseRootFromParent_Done,
     /*  31064 */   // Label 448: @31064
     /*  31064 */   GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(31202), // Rule ID 5132 //
     /*  31069 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31072 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31076 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31080 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31084 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31088 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31092 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31096 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31100 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31104 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31108 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31112 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31116 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31120 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31124 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31128 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31134 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31136 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31140 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31144 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31148 */     // MIs[5] vA
     /*  31148 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31153 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31157 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31161 */     // MIs[6] vB
     /*  31161 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31166 */     // MIs[6] vC
     /*  31166 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31171 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31173 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31178 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  31182 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  31186 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31190 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31200 */     GIR_RootConstrainSelectedInstOperands,
     /*  31201 */     // GIR_Coverage, 5132,
     /*  31201 */     GIR_EraseRootFromParent_Done,
     /*  31202 */   // Label 449: @31202
     /*  31202 */   GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(31340), // Rule ID 5133 //
     /*  31207 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31210 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31214 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31218 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31222 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31226 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31230 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31234 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31238 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31242 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31246 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31250 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31254 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31258 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31262 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31266 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31272 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31274 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31278 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31282 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31286 */     // MIs[5] vA
     /*  31286 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31291 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31295 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31299 */     // MIs[6] vC
     /*  31299 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31304 */     // MIs[6] vB
     /*  31304 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31309 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31311 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31311 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31314 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31316 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  31320 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  31324 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31328 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31338 */     GIR_RootConstrainSelectedInstOperands,
     /*  31339 */     // GIR_Coverage, 5133,
     /*  31339 */     GIR_EraseRootFromParent_Done,
     /*  31340 */   // Label 450: @31340
     /*  31340 */   GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(31478), // Rule ID 5140 //
     /*  31345 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31348 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31352 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31356 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31360 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31364 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31368 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31372 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31376 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31380 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31384 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31388 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31392 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31396 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31400 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31404 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31410 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31412 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31416 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31420 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31424 */     // MIs[5] vC
     /*  31424 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31429 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31433 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31437 */     // MIs[6] vA
     /*  31437 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31442 */     // MIs[6] vB
     /*  31442 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31447 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31449 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31449 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31452 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31454 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  31458 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  31462 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31466 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31476 */     GIR_RootConstrainSelectedInstOperands,
     /*  31477 */     // GIR_Coverage, 5140,
     /*  31477 */     GIR_EraseRootFromParent_Done,
     /*  31478 */   // Label 451: @31478
     /*  31478 */   GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(31616), // Rule ID 5141 //
     /*  31483 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31486 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31490 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31494 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31498 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31502 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31506 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31510 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31514 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31518 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31522 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31526 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31530 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31534 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31538 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31542 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31548 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31550 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31554 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31558 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31562 */     // MIs[5] vC
     /*  31562 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31567 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31571 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31575 */     // MIs[6] vB
     /*  31575 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31580 */     // MIs[6] vA
     /*  31580 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31585 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31587 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31587 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31590 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31592 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  31596 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  31600 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31604 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31614 */     GIR_RootConstrainSelectedInstOperands,
     /*  31615 */     // GIR_Coverage, 5141,
     /*  31615 */     GIR_EraseRootFromParent_Done,
     /*  31616 */   // Label 452: @31616
     /*  31616 */   GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(31754), // Rule ID 5142 //
     /*  31621 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31624 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31628 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31632 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31636 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31640 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31644 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31648 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31652 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31656 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31660 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31664 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31668 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31672 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31676 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31680 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31686 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31688 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31692 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31696 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31700 */     // MIs[5] vB
     /*  31700 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31705 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31709 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31713 */     // MIs[6] vA
     /*  31713 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31718 */     // MIs[6] vC
     /*  31718 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31723 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31725 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31725 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31728 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31730 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  31734 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  31738 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31742 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31752 */     GIR_RootConstrainSelectedInstOperands,
     /*  31753 */     // GIR_Coverage, 5142,
     /*  31753 */     GIR_EraseRootFromParent_Done,
     /*  31754 */   // Label 453: @31754
     /*  31754 */   GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(31892), // Rule ID 5143 //
     /*  31759 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31762 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31766 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31770 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31774 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31778 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31782 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31786 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31790 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31794 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31798 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31802 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31806 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31810 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31814 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31818 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31824 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31826 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31830 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31834 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31838 */     // MIs[5] vB
     /*  31838 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31843 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31847 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31851 */     // MIs[6] vC
     /*  31851 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31856 */     // MIs[6] vA
     /*  31856 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31861 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  31863 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  31863 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  31866 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  31868 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  31872 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  31876 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  31880 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  31890 */     GIR_RootConstrainSelectedInstOperands,
     /*  31891 */     // GIR_Coverage, 5143,
     /*  31891 */     GIR_EraseRootFromParent_Done,
     /*  31892 */   // Label 454: @31892
     /*  31892 */   GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(32030), // Rule ID 5144 //
     /*  31897 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  31900 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  31904 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  31908 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  31912 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31916 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31920 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  31924 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31928 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31932 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31936 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  31940 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  31944 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  31948 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31952 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  31956 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  31962 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  31964 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  31968 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31972 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  31976 */     // MIs[5] vA
     /*  31976 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  31981 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  31985 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  31989 */     // MIs[6] vB
     /*  31989 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  31994 */     // MIs[6] vC
     /*  31994 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  31999 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32001 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32001 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32004 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32006 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  32010 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  32014 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  32018 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32028 */     GIR_RootConstrainSelectedInstOperands,
     /*  32029 */     // GIR_Coverage, 5144,
     /*  32029 */     GIR_EraseRootFromParent_Done,
     /*  32030 */   // Label 455: @32030
     /*  32030 */   GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(32168), // Rule ID 5145 //
     /*  32035 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32038 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32042 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32046 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32050 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32054 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32058 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32062 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32066 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32070 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32074 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32078 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32082 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32086 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32090 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32094 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32100 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32102 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32106 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32110 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32114 */     // MIs[5] vA
     /*  32114 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32119 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32123 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32127 */     // MIs[6] vC
     /*  32127 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32132 */     // MIs[6] vB
     /*  32132 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32137 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32139 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32139 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32142 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32144 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  32148 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  32152 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vC
     /*  32156 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32166 */     GIR_RootConstrainSelectedInstOperands,
     /*  32167 */     // GIR_Coverage, 5145,
     /*  32167 */     GIR_EraseRootFromParent_Done,
     /*  32168 */   // Label 456: @32168
     /*  32168 */   GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(32306), // Rule ID 5152 //
     /*  32173 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32176 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32180 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32184 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32188 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32192 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32196 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32200 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32204 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32208 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32212 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32216 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32220 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32224 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32228 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32232 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32238 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32240 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32244 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32248 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32252 */     // MIs[5] vC
     /*  32252 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32257 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32261 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32265 */     // MIs[6] vA
     /*  32265 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32270 */     // MIs[6] vB
     /*  32270 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32275 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32277 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32277 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32280 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  32286 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  32290 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  32294 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32304 */     GIR_RootConstrainSelectedInstOperands,
     /*  32305 */     // GIR_Coverage, 5152,
     /*  32305 */     GIR_EraseRootFromParent_Done,
     /*  32306 */   // Label 457: @32306
     /*  32306 */   GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(32444), // Rule ID 5153 //
     /*  32311 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32314 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32318 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32322 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32326 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32330 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32334 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32338 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32342 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32346 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32350 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32354 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32358 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32362 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32366 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32370 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32376 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32378 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32382 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32386 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32390 */     // MIs[5] vC
     /*  32390 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32395 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32399 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32403 */     // MIs[6] vB
     /*  32403 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32408 */     // MIs[6] vA
     /*  32408 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32413 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32415 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32415 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32418 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32420 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  32424 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  32428 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  32432 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32442 */     GIR_RootConstrainSelectedInstOperands,
     /*  32443 */     // GIR_Coverage, 5153,
     /*  32443 */     GIR_EraseRootFromParent_Done,
     /*  32444 */   // Label 458: @32444
     /*  32444 */   GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(32582), // Rule ID 5154 //
     /*  32449 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32452 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32464 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32468 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32472 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32476 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32480 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32484 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32488 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32492 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32496 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32500 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32504 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32508 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32514 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32516 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32520 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32524 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32528 */     // MIs[5] vB
     /*  32528 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32533 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32537 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32541 */     // MIs[6] vA
     /*  32541 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32546 */     // MIs[6] vC
     /*  32546 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32551 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32553 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32553 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32556 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32558 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  32562 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  32566 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  32570 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32580 */     GIR_RootConstrainSelectedInstOperands,
     /*  32581 */     // GIR_Coverage, 5154,
     /*  32581 */     GIR_EraseRootFromParent_Done,
     /*  32582 */   // Label 459: @32582
     /*  32582 */   GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(32720), // Rule ID 5155 //
     /*  32587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32594 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32598 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32602 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32606 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32610 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32614 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32618 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32622 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32626 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32630 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32634 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32638 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32642 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32646 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32652 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32654 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32658 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32662 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32666 */     // MIs[5] vB
     /*  32666 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32671 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32675 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32679 */     // MIs[6] vC
     /*  32679 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32684 */     // MIs[6] vA
     /*  32684 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32689 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32691 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32691 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32694 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32696 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  32700 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  32704 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  32708 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32718 */     GIR_RootConstrainSelectedInstOperands,
     /*  32719 */     // GIR_Coverage, 5155,
     /*  32719 */     GIR_EraseRootFromParent_Done,
     /*  32720 */   // Label 460: @32720
     /*  32720 */   GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(32858), // Rule ID 5156 //
     /*  32725 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32728 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32732 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32736 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32740 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32744 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32748 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32752 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32756 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32760 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32764 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32768 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32772 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32776 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32780 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32784 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32790 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32792 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32796 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32800 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32804 */     // MIs[5] vA
     /*  32804 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32809 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32813 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32817 */     // MIs[6] vB
     /*  32817 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32822 */     // MIs[6] vC
     /*  32822 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32827 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32829 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32829 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32832 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32834 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  32838 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  32842 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  32846 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32856 */     GIR_RootConstrainSelectedInstOperands,
     /*  32857 */     // GIR_Coverage, 5156,
     /*  32857 */     GIR_EraseRootFromParent_Done,
     /*  32858 */   // Label 461: @32858
     /*  32858 */   GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(32996), // Rule ID 5157 //
     /*  32863 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  32866 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  32870 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  32874 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  32878 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32882 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32886 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  32890 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32894 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32898 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32902 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  32906 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  32910 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  32914 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32918 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  32922 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  32928 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  32930 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  32934 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32938 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  32942 */     // MIs[5] vA
     /*  32942 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  32947 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  32951 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  32955 */     // MIs[6] vC
     /*  32955 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  32960 */     // MIs[6] vB
     /*  32960 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  32965 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  32967 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  32967 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  32970 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  32972 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  32976 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  32980 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  32984 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  32994 */     GIR_RootConstrainSelectedInstOperands,
     /*  32995 */     // GIR_Coverage, 5157,
     /*  32995 */     GIR_EraseRootFromParent_Done,
     /*  32996 */   // Label 462: @32996
     /*  32996 */   GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(33134), // Rule ID 5164 //
     /*  33001 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33004 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33008 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33012 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33016 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33020 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33024 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33028 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33032 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33036 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33040 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33044 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33048 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33052 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33056 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33060 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33066 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33068 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33072 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33076 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33080 */     // MIs[5] vC
     /*  33080 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33085 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33089 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33093 */     // MIs[6] vA
     /*  33093 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33098 */     // MIs[6] vB
     /*  33098 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33103 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33105 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33105 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33108 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33110 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  33114 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  33118 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  33122 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33132 */     GIR_RootConstrainSelectedInstOperands,
     /*  33133 */     // GIR_Coverage, 5164,
     /*  33133 */     GIR_EraseRootFromParent_Done,
     /*  33134 */   // Label 463: @33134
     /*  33134 */   GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(33272), // Rule ID 5165 //
     /*  33139 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33142 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33146 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33150 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33154 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33158 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33162 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33166 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33170 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33174 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33178 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33182 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33186 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33190 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33194 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33198 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33204 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33206 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33210 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33214 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33218 */     // MIs[5] vC
     /*  33218 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33223 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33227 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33231 */     // MIs[6] vB
     /*  33231 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33236 */     // MIs[6] vA
     /*  33236 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33241 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33243 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33243 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33246 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33248 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  33252 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  33256 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  33260 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33270 */     GIR_RootConstrainSelectedInstOperands,
     /*  33271 */     // GIR_Coverage, 5165,
     /*  33271 */     GIR_EraseRootFromParent_Done,
     /*  33272 */   // Label 464: @33272
     /*  33272 */   GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(33410), // Rule ID 5166 //
     /*  33277 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33280 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33284 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33288 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33292 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33296 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33300 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33304 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33308 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33312 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33316 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33320 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33324 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33328 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33332 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33336 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33342 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33344 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33348 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33352 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33356 */     // MIs[5] vB
     /*  33356 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33361 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33365 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33369 */     // MIs[6] vA
     /*  33369 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33374 */     // MIs[6] vC
     /*  33374 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33379 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33381 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33381 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33384 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33386 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  33390 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  33394 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  33398 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33408 */     GIR_RootConstrainSelectedInstOperands,
     /*  33409 */     // GIR_Coverage, 5166,
     /*  33409 */     GIR_EraseRootFromParent_Done,
     /*  33410 */   // Label 465: @33410
     /*  33410 */   GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(33548), // Rule ID 5167 //
     /*  33415 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33418 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33422 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33426 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33430 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33434 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33438 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33442 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33446 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33450 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33454 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33458 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33462 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33466 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33470 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33474 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33480 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33482 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33486 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33490 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33494 */     // MIs[5] vB
     /*  33494 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33499 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33503 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33507 */     // MIs[6] vC
     /*  33507 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33512 */     // MIs[6] vA
     /*  33512 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33517 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33519 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33519 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33522 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33524 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  33528 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  33532 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  33536 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33546 */     GIR_RootConstrainSelectedInstOperands,
     /*  33547 */     // GIR_Coverage, 5167,
     /*  33547 */     GIR_EraseRootFromParent_Done,
     /*  33548 */   // Label 466: @33548
     /*  33548 */   GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(33686), // Rule ID 5168 //
     /*  33553 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33556 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33560 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33564 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33568 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33572 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33576 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33580 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33584 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33588 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33592 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33596 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33600 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33604 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33608 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33612 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33618 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33620 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33624 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33628 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33632 */     // MIs[5] vA
     /*  33632 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33637 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33641 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33645 */     // MIs[6] vB
     /*  33645 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33650 */     // MIs[6] vC
     /*  33650 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33655 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33657 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33657 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33660 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  33666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  33670 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  33674 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33684 */     GIR_RootConstrainSelectedInstOperands,
     /*  33685 */     // GIR_Coverage, 5168,
     /*  33685 */     GIR_EraseRootFromParent_Done,
     /*  33686 */   // Label 467: @33686
     /*  33686 */   GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(33824), // Rule ID 5169 //
     /*  33691 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33694 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33698 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33702 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33706 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33710 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33714 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33718 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33722 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33726 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33730 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33734 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33738 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33742 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33746 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33750 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33756 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33758 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33762 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33766 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33770 */     // MIs[5] vA
     /*  33770 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33775 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33779 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33783 */     // MIs[6] vC
     /*  33783 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33788 */     // MIs[6] vB
     /*  33788 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33793 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33795 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33795 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33798 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  33804 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vB
     /*  33808 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  33812 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33822 */     GIR_RootConstrainSelectedInstOperands,
     /*  33823 */     // GIR_Coverage, 5169,
     /*  33823 */     GIR_EraseRootFromParent_Done,
     /*  33824 */   // Label 468: @33824
     /*  33824 */   GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(33962), // Rule ID 5176 //
     /*  33829 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33832 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33836 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33840 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33844 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33848 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33852 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33856 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33860 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33864 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33868 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  33872 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33876 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33880 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33884 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  33888 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  33894 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  33896 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  33900 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33904 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33908 */     // MIs[5] vC
     /*  33908 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  33913 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  33917 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  33921 */     // MIs[6] vA
     /*  33921 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  33926 */     // MIs[6] vB
     /*  33926 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  33931 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  33933 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  33933 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  33936 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  33938 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  33942 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  33946 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  33950 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  33960 */     GIR_RootConstrainSelectedInstOperands,
     /*  33961 */     // GIR_Coverage, 5176,
     /*  33961 */     GIR_EraseRootFromParent_Done,
     /*  33962 */   // Label 469: @33962
     /*  33962 */   GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(34100), // Rule ID 5177 //
     /*  33967 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  33970 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  33974 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  33978 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  33982 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  33986 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  33990 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  33994 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  33998 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34002 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34006 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34010 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34014 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34018 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34022 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34026 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34032 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34034 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34038 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34042 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34046 */     // MIs[5] vC
     /*  34046 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34051 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34055 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34059 */     // MIs[6] vB
     /*  34059 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34064 */     // MIs[6] vA
     /*  34064 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34069 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34071 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34076 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34080 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  34084 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  34088 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34098 */     GIR_RootConstrainSelectedInstOperands,
     /*  34099 */     // GIR_Coverage, 5177,
     /*  34099 */     GIR_EraseRootFromParent_Done,
     /*  34100 */   // Label 470: @34100
     /*  34100 */   GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(34238), // Rule ID 5178 //
     /*  34105 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34108 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34112 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34116 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34120 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34124 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34128 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34132 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34136 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34140 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34144 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34148 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34152 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34156 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34160 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34164 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34170 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34172 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34176 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34180 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34184 */     // MIs[5] vB
     /*  34184 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34189 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34193 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34197 */     // MIs[6] vA
     /*  34197 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34202 */     // MIs[6] vC
     /*  34202 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34207 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34209 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34209 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34212 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34214 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34218 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  34222 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  34226 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34236 */     GIR_RootConstrainSelectedInstOperands,
     /*  34237 */     // GIR_Coverage, 5178,
     /*  34237 */     GIR_EraseRootFromParent_Done,
     /*  34238 */   // Label 471: @34238
     /*  34238 */   GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(34376), // Rule ID 5179 //
     /*  34243 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34246 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34250 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34254 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34258 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34262 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34266 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34270 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34274 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34278 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34282 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34286 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34290 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34294 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34298 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34302 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34308 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34310 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34314 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34318 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34322 */     // MIs[5] vB
     /*  34322 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34327 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34331 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34335 */     // MIs[6] vC
     /*  34335 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34340 */     // MIs[6] vA
     /*  34340 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34345 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34347 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34347 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34350 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34352 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34356 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  34360 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  34364 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34374 */     GIR_RootConstrainSelectedInstOperands,
     /*  34375 */     // GIR_Coverage, 5179,
     /*  34375 */     GIR_EraseRootFromParent_Done,
     /*  34376 */   // Label 472: @34376
     /*  34376 */   GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(34514), // Rule ID 5180 //
     /*  34381 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34384 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34388 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34392 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34396 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34400 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34404 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34408 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34412 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34416 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34420 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34424 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34428 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34432 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34436 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34440 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34446 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34448 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34452 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34456 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34460 */     // MIs[5] vA
     /*  34460 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34465 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34469 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34473 */     // MIs[6] vB
     /*  34473 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34478 */     // MIs[6] vC
     /*  34478 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34483 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34485 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34485 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34488 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34490 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34494 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  34498 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  34502 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34512 */     GIR_RootConstrainSelectedInstOperands,
     /*  34513 */     // GIR_Coverage, 5180,
     /*  34513 */     GIR_EraseRootFromParent_Done,
     /*  34514 */   // Label 473: @34514
     /*  34514 */   GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(34652), // Rule ID 5181 //
     /*  34519 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34522 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34526 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34530 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34534 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34538 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34542 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34546 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34550 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34554 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34558 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34562 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34566 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34570 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34574 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34578 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34584 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34586 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34590 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34594 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34598 */     // MIs[5] vA
     /*  34598 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34603 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34607 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34611 */     // MIs[6] vC
     /*  34611 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34616 */     // MIs[6] vB
     /*  34616 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34621 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34623 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34623 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34626 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34628 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34632 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  34636 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  34640 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34650 */     GIR_RootConstrainSelectedInstOperands,
     /*  34651 */     // GIR_Coverage, 5181,
     /*  34651 */     GIR_EraseRootFromParent_Done,
     /*  34652 */   // Label 474: @34652
     /*  34652 */   GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(34790), // Rule ID 5188 //
     /*  34657 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34660 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34664 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34668 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34672 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34676 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34680 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34684 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34688 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34692 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34696 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34700 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34704 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34708 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34712 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34716 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34722 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34724 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34728 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34732 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34736 */     // MIs[5] vC
     /*  34736 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34741 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34745 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34749 */     // MIs[6] vA
     /*  34749 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34754 */     // MIs[6] vB
     /*  34754 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34759 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34761 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34761 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34764 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34766 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34770 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  34774 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  34778 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34788 */     GIR_RootConstrainSelectedInstOperands,
     /*  34789 */     // GIR_Coverage, 5188,
     /*  34789 */     GIR_EraseRootFromParent_Done,
     /*  34790 */   // Label 475: @34790
     /*  34790 */   GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(34928), // Rule ID 5189 //
     /*  34795 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34798 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34802 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34806 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34810 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34814 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34818 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34822 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34826 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34830 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34834 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34838 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34842 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34846 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34850 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34854 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34860 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  34862 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  34866 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34870 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34874 */     // MIs[5] vC
     /*  34874 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  34879 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  34883 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  34887 */     // MIs[6] vB
     /*  34887 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  34892 */     // MIs[6] vA
     /*  34892 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  34897 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  34899 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  34899 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  34902 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  34904 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  34908 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  34912 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  34916 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  34926 */     GIR_RootConstrainSelectedInstOperands,
     /*  34927 */     // GIR_Coverage, 5189,
     /*  34927 */     GIR_EraseRootFromParent_Done,
     /*  34928 */   // Label 476: @34928
     /*  34928 */   GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(35066), // Rule ID 5190 //
     /*  34933 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  34936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  34940 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  34944 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  34948 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34952 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34956 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  34960 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34964 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34968 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34972 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  34976 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  34980 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  34984 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  34988 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  34992 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  34998 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35000 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35004 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35008 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35012 */     // MIs[5] vB
     /*  35012 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35017 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  35021 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35025 */     // MIs[6] vA
     /*  35025 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35030 */     // MIs[6] vC
     /*  35030 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35035 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35037 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35037 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35040 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  35046 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35050 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  35054 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35064 */     GIR_RootConstrainSelectedInstOperands,
     /*  35065 */     // GIR_Coverage, 5190,
     /*  35065 */     GIR_EraseRootFromParent_Done,
     /*  35066 */   // Label 477: @35066
     /*  35066 */   GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(35204), // Rule ID 5191 //
     /*  35071 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35074 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35078 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35082 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35086 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35090 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35094 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35098 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35102 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35106 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35110 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  35114 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35118 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35122 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35126 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35130 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35136 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35138 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35142 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35146 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35150 */     // MIs[5] vB
     /*  35150 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35155 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  35159 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35163 */     // MIs[6] vC
     /*  35163 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35168 */     // MIs[6] vA
     /*  35168 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35173 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35175 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35175 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35178 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35180 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  35184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35188 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  35192 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35202 */     GIR_RootConstrainSelectedInstOperands,
     /*  35203 */     // GIR_Coverage, 5191,
     /*  35203 */     GIR_EraseRootFromParent_Done,
     /*  35204 */   // Label 478: @35204
     /*  35204 */   GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(35342), // Rule ID 5192 //
     /*  35209 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35212 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35216 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35220 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35224 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35228 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35232 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35236 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35240 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35244 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35248 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  35252 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35256 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35260 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35264 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35268 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35274 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35276 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35280 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35284 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35288 */     // MIs[5] vA
     /*  35288 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35293 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  35297 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35301 */     // MIs[6] vB
     /*  35301 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35306 */     // MIs[6] vC
     /*  35306 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35311 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35313 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35313 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35316 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  35322 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35326 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  35330 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35340 */     GIR_RootConstrainSelectedInstOperands,
     /*  35341 */     // GIR_Coverage, 5192,
     /*  35341 */     GIR_EraseRootFromParent_Done,
     /*  35342 */   // Label 479: @35342
     /*  35342 */   GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(35480), // Rule ID 5193 //
     /*  35347 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35350 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35354 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35358 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35362 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35366 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35370 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35374 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35378 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35382 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35386 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
     /*  35390 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35394 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35398 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35402 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35406 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35412 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35414 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35418 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35422 */     GIM_CheckType, /*MI*/5, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35426 */     // MIs[5] vA
     /*  35426 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/2,
     /*  35431 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/2, // MIs[6]
     /*  35435 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35439 */     // MIs[6] vC
     /*  35439 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35444 */     // MIs[6] vB
     /*  35444 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35449 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35451 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB)))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35451 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35454 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35456 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // vA
     /*  35460 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35464 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  35468 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35478 */     GIR_RootConstrainSelectedInstOperands,
     /*  35479 */     // GIR_Coverage, 5193,
     /*  35479 */     GIR_EraseRootFromParent_Done,
     /*  35480 */   // Label 480: @35480
     /*  35480 */   GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(35618), // Rule ID 5194 //
     /*  35485 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35488 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35492 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35496 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35500 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35504 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35508 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35512 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35516 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35520 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35524 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35528 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35532 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35536 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35540 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35544 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35550 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35552 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35556 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35560 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35564 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  35568 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35572 */     // MIs[6] vA
     /*  35572 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35577 */     // MIs[6] vB
     /*  35577 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35582 */     // MIs[5] vC
     /*  35582 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35587 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35589 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35589 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35592 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35594 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  35598 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35602 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  35606 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35616 */     GIR_RootConstrainSelectedInstOperands,
     /*  35617 */     // GIR_Coverage, 5194,
     /*  35617 */     GIR_EraseRootFromParent_Done,
     /*  35618 */   // Label 481: @35618
     /*  35618 */   GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(35756), // Rule ID 5195 //
     /*  35623 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35626 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35630 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35634 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35638 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35642 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35646 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35650 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35654 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35658 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35662 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35666 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35670 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35674 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35678 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35682 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35688 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35690 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35694 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35698 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35702 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  35706 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35710 */     // MIs[6] vB
     /*  35710 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35715 */     // MIs[6] vA
     /*  35715 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35720 */     // MIs[5] vC
     /*  35720 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35725 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35727 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35727 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35730 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  35736 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35740 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  35744 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35754 */     GIR_RootConstrainSelectedInstOperands,
     /*  35755 */     // GIR_Coverage, 5195,
     /*  35755 */     GIR_EraseRootFromParent_Done,
     /*  35756 */   // Label 482: @35756
     /*  35756 */   GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(35894), // Rule ID 5196 //
     /*  35761 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35764 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35768 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35772 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35776 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35780 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35784 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35788 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35792 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35796 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35800 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35804 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35808 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35812 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35816 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35820 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35826 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35828 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35832 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35836 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35840 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  35844 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35848 */     // MIs[6] vA
     /*  35848 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35853 */     // MIs[6] vC
     /*  35853 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35858 */     // MIs[5] vB
     /*  35858 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  35863 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  35865 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  35865 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  35868 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  35870 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  35874 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  35878 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  35882 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  35892 */     GIR_RootConstrainSelectedInstOperands,
     /*  35893 */     // GIR_Coverage, 5196,
     /*  35893 */     GIR_EraseRootFromParent_Done,
     /*  35894 */   // Label 483: @35894
     /*  35894 */   GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(36032), // Rule ID 5197 //
     /*  35899 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  35902 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  35906 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  35910 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  35914 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35918 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35922 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  35926 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35930 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35934 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35938 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  35942 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  35946 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35950 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  35954 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  35958 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  35964 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  35966 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  35970 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35974 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  35978 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  35982 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  35986 */     // MIs[6] vC
     /*  35986 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  35991 */     // MIs[6] vA
     /*  35991 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  35996 */     // MIs[5] vB
     /*  35996 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36001 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36003 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36003 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36006 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36008 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  36012 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  36016 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36020 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36030 */     GIR_RootConstrainSelectedInstOperands,
     /*  36031 */     // GIR_Coverage, 5197,
     /*  36031 */     GIR_EraseRootFromParent_Done,
     /*  36032 */   // Label 484: @36032
     /*  36032 */   GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(36170), // Rule ID 5198 //
     /*  36037 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36040 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36044 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36048 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36052 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36056 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36060 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36064 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36068 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36072 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36076 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36080 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36084 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36088 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36092 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36096 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36102 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36104 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36108 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36112 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36116 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36120 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36124 */     // MIs[6] vB
     /*  36124 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36129 */     // MIs[6] vC
     /*  36129 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36134 */     // MIs[5] vA
     /*  36134 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36139 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36141 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36141 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36144 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36146 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  36150 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  36154 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36158 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36168 */     GIR_RootConstrainSelectedInstOperands,
     /*  36169 */     // GIR_Coverage, 5198,
     /*  36169 */     GIR_EraseRootFromParent_Done,
     /*  36170 */   // Label 485: @36170
     /*  36170 */   GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(36308), // Rule ID 5199 //
     /*  36175 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36178 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36182 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36186 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36190 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36194 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36198 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36202 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36206 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36210 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36214 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36218 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36222 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36226 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36230 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36234 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36240 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36242 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36246 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36250 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36254 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36258 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36262 */     // MIs[6] vC
     /*  36262 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36267 */     // MIs[6] vB
     /*  36267 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36272 */     // MIs[5] vA
     /*  36272 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36277 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36279 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36279 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36282 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  36288 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vB
     /*  36292 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36296 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36306 */     GIR_RootConstrainSelectedInstOperands,
     /*  36307 */     // GIR_Coverage, 5199,
     /*  36307 */     GIR_EraseRootFromParent_Done,
     /*  36308 */   // Label 486: @36308
     /*  36308 */   GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(36446), // Rule ID 5206 //
     /*  36313 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36316 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36320 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36324 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36328 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36332 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36336 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36340 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36344 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36348 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36352 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36356 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36360 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36364 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36368 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36372 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36378 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36380 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36384 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36388 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36392 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36396 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36400 */     // MIs[6] vA
     /*  36400 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36405 */     // MIs[6] vB
     /*  36405 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36410 */     // MIs[5] vC
     /*  36410 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36415 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36417 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36417 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36420 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36422 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  36426 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  36430 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36434 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36444 */     GIR_RootConstrainSelectedInstOperands,
     /*  36445 */     // GIR_Coverage, 5206,
     /*  36445 */     GIR_EraseRootFromParent_Done,
     /*  36446 */   // Label 487: @36446
     /*  36446 */   GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(36584), // Rule ID 5207 //
     /*  36451 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36458 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36462 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36466 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36470 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36474 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36478 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36482 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36486 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36490 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36494 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36498 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36502 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36506 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36510 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36516 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36518 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36522 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36526 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36530 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36534 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36538 */     // MIs[6] vB
     /*  36538 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36543 */     // MIs[6] vA
     /*  36543 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36548 */     // MIs[5] vC
     /*  36548 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36553 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36555 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36555 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36558 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36560 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  36564 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  36568 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36572 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36582 */     GIR_RootConstrainSelectedInstOperands,
     /*  36583 */     // GIR_Coverage, 5207,
     /*  36583 */     GIR_EraseRootFromParent_Done,
     /*  36584 */   // Label 488: @36584
     /*  36584 */   GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(36722), // Rule ID 5208 //
     /*  36589 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36592 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36596 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36600 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36604 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36608 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36612 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36616 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36620 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36624 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36628 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36632 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36636 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36640 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36644 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36648 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36654 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36656 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36660 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36664 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36668 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36672 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36676 */     // MIs[6] vA
     /*  36676 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36681 */     // MIs[6] vC
     /*  36681 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36686 */     // MIs[5] vB
     /*  36686 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36691 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36693 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36693 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36696 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36698 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  36702 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  36706 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36710 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36720 */     GIR_RootConstrainSelectedInstOperands,
     /*  36721 */     // GIR_Coverage, 5208,
     /*  36721 */     GIR_EraseRootFromParent_Done,
     /*  36722 */   // Label 489: @36722
     /*  36722 */   GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(36860), // Rule ID 5209 //
     /*  36727 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36730 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36734 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36738 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36742 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36746 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36750 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36754 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36758 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36762 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36766 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36770 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36774 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36778 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36782 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36786 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36792 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36794 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36798 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36802 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36806 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36810 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36814 */     // MIs[6] vC
     /*  36814 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36819 */     // MIs[6] vA
     /*  36819 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36824 */     // MIs[5] vB
     /*  36824 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36829 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36831 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36831 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36834 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36836 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  36840 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  36844 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36848 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36858 */     GIR_RootConstrainSelectedInstOperands,
     /*  36859 */     // GIR_Coverage, 5209,
     /*  36859 */     GIR_EraseRootFromParent_Done,
     /*  36860 */   // Label 490: @36860
     /*  36860 */   GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(36998), // Rule ID 5210 //
     /*  36865 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  36868 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  36872 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  36876 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  36880 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36884 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36888 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  36892 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36896 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36900 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36904 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  36908 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  36912 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36916 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  36920 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  36924 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  36930 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  36932 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  36936 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36940 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  36944 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  36948 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  36952 */     // MIs[6] vB
     /*  36952 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  36957 */     // MIs[6] vC
     /*  36957 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  36962 */     // MIs[5] vA
     /*  36962 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  36967 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  36969 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  36969 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  36972 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  36974 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  36978 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  36982 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  36986 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  36996 */     GIR_RootConstrainSelectedInstOperands,
     /*  36997 */     // GIR_Coverage, 5210,
     /*  36997 */     GIR_EraseRootFromParent_Done,
     /*  36998 */   // Label 491: @36998
     /*  36998 */   GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(37136), // Rule ID 5211 //
     /*  37003 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37006 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37010 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37014 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37018 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37022 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37026 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37030 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37034 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37038 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37042 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37046 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37050 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37054 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37058 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37062 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37068 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37070 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37074 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37078 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37082 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37086 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37090 */     // MIs[6] vC
     /*  37090 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37095 */     // MIs[6] vB
     /*  37095 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37100 */     // MIs[5] vA
     /*  37100 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37105 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37107 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37107 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37110 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37112 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  37116 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vB
     /*  37120 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vC
     /*  37124 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37134 */     GIR_RootConstrainSelectedInstOperands,
     /*  37135 */     // GIR_Coverage, 5211,
     /*  37135 */     GIR_EraseRootFromParent_Done,
     /*  37136 */   // Label 492: @37136
     /*  37136 */   GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(37274), // Rule ID 5218 //
     /*  37141 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37144 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37148 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37152 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37156 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37160 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37164 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37168 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37172 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37176 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37180 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37184 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37188 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37192 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37196 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37200 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37206 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37208 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37212 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37216 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37220 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37224 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37228 */     // MIs[6] vA
     /*  37228 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37233 */     // MIs[6] vB
     /*  37233 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37238 */     // MIs[5] vC
     /*  37238 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37243 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37245 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37245 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37248 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37250 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  37254 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  37258 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  37262 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37272 */     GIR_RootConstrainSelectedInstOperands,
     /*  37273 */     // GIR_Coverage, 5218,
     /*  37273 */     GIR_EraseRootFromParent_Done,
     /*  37274 */   // Label 493: @37274
     /*  37274 */   GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(37412), // Rule ID 5219 //
     /*  37279 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37282 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37286 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37290 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37294 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37298 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37302 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37306 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37310 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37314 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37318 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37322 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37326 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37330 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37334 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37338 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37344 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37346 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37350 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37354 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37358 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37362 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37366 */     // MIs[6] vB
     /*  37366 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37371 */     // MIs[6] vA
     /*  37371 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37376 */     // MIs[5] vC
     /*  37376 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37381 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37383 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37388 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  37392 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  37396 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  37400 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37410 */     GIR_RootConstrainSelectedInstOperands,
     /*  37411 */     // GIR_Coverage, 5219,
     /*  37411 */     GIR_EraseRootFromParent_Done,
     /*  37412 */   // Label 494: @37412
     /*  37412 */   GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(37550), // Rule ID 5220 //
     /*  37417 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37420 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37424 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37428 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37432 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37436 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37440 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37444 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37448 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37452 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37456 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37460 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37464 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37468 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37472 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37476 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37482 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37484 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37488 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37492 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37496 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37500 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37504 */     // MIs[6] vA
     /*  37504 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37509 */     // MIs[6] vC
     /*  37509 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37514 */     // MIs[5] vB
     /*  37514 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37519 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37521 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37521 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37524 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37526 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  37530 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  37534 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  37538 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37548 */     GIR_RootConstrainSelectedInstOperands,
     /*  37549 */     // GIR_Coverage, 5220,
     /*  37549 */     GIR_EraseRootFromParent_Done,
     /*  37550 */   // Label 495: @37550
     /*  37550 */   GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(37688), // Rule ID 5221 //
     /*  37555 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37558 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37562 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37566 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37570 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37574 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37578 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37582 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37586 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37590 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37594 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37598 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37602 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37606 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37610 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37614 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37620 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37622 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37626 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37630 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37634 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37638 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37642 */     // MIs[6] vC
     /*  37642 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37647 */     // MIs[6] vA
     /*  37647 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37652 */     // MIs[5] vB
     /*  37652 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37657 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37659 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  37668 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  37672 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  37676 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37686 */     GIR_RootConstrainSelectedInstOperands,
     /*  37687 */     // GIR_Coverage, 5221,
     /*  37687 */     GIR_EraseRootFromParent_Done,
     /*  37688 */   // Label 496: @37688
     /*  37688 */   GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(37826), // Rule ID 5222 //
     /*  37693 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37696 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37700 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37704 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37708 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37712 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37716 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37720 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37724 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37728 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37732 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37736 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37740 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37744 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37748 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37752 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37758 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37760 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37764 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37768 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37772 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37776 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37780 */     // MIs[6] vB
     /*  37780 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37785 */     // MIs[6] vC
     /*  37785 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37790 */     // MIs[5] vA
     /*  37790 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37795 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37797 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37797 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37800 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  37806 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  37810 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  37814 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37824 */     GIR_RootConstrainSelectedInstOperands,
     /*  37825 */     // GIR_Coverage, 5222,
     /*  37825 */     GIR_EraseRootFromParent_Done,
     /*  37826 */   // Label 497: @37826
     /*  37826 */   GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(37964), // Rule ID 5223 //
     /*  37831 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37834 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37838 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37842 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37846 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37850 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37854 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37858 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37862 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37866 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37870 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  37874 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  37878 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37882 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37886 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  37890 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  37896 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  37898 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  37902 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37906 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37910 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  37914 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  37918 */     // MIs[6] vC
     /*  37918 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  37923 */     // MIs[6] vB
     /*  37923 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  37928 */     // MIs[5] vA
     /*  37928 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  37933 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  37935 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vA))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  37935 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  37938 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  37940 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vA
     /*  37944 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  37948 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vC
     /*  37952 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  37962 */     GIR_RootConstrainSelectedInstOperands,
     /*  37963 */     // GIR_Coverage, 5223,
     /*  37963 */     GIR_EraseRootFromParent_Done,
     /*  37964 */   // Label 498: @37964
     /*  37964 */   GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(38102), // Rule ID 5230 //
     /*  37969 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  37972 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  37976 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  37980 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  37984 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  37988 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  37992 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  37996 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38000 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38004 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38008 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  38012 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38016 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38020 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38024 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  38028 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  38034 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  38036 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  38040 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38044 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38048 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  38052 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38056 */     // MIs[6] vA
     /*  38056 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  38061 */     // MIs[6] vB
     /*  38061 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  38066 */     // MIs[5] vC
     /*  38066 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  38071 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  38073 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vB), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  38073 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  38076 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  38078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  38082 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  38086 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  38090 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  38100 */     GIR_RootConstrainSelectedInstOperands,
     /*  38101 */     // GIR_Coverage, 5230,
     /*  38101 */     GIR_EraseRootFromParent_Done,
     /*  38102 */   // Label 499: @38102
     /*  38102 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(38240), // Rule ID 5231 //
     /*  38107 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  38110 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  38114 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38118 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  38122 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38126 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38130 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  38134 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38138 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38142 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38146 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  38150 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38154 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38158 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38162 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  38166 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  38172 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  38174 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  38178 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38182 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38186 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  38190 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38194 */     // MIs[6] vB
     /*  38194 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  38199 */     // MIs[6] vA
     /*  38199 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  38204 */     // MIs[5] vC
     /*  38204 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  38209 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  38211 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vC))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  38211 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  38214 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  38216 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  38220 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  38224 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  38228 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  38238 */     GIR_RootConstrainSelectedInstOperands,
     /*  38239 */     // GIR_Coverage, 5231,
     /*  38239 */     GIR_EraseRootFromParent_Done,
     /*  38240 */   // Label 500: @38240
     /*  38240 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(38378), // Rule ID 5232 //
     /*  38245 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  38248 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  38252 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38256 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  38260 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38264 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38268 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  38272 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38276 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38280 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38284 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  38288 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38292 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38296 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38300 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  38304 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  38310 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  38312 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  38316 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38320 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38324 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  38328 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38332 */     // MIs[6] vA
     /*  38332 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  38337 */     // MIs[6] vC
     /*  38337 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  38342 */     // MIs[5] vB
     /*  38342 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  38347 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  38349 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vA, v4i32:{ *:[v4i32] }:$vC), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  38349 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  38352 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  38354 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  38358 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  38362 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  38366 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  38376 */     GIR_RootConstrainSelectedInstOperands,
     /*  38377 */     // GIR_Coverage, 5232,
     /*  38377 */     GIR_EraseRootFromParent_Done,
     /*  38378 */   // Label 501: @38378
     /*  38378 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(38516), // Rule ID 5233 //
     /*  38383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasP10Vector_PrefixInstrs),
     /*  38386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(PPC::VSRCRegClassID),
     /*  38390 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  38394 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /*  38398 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38402 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38406 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*  38410 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38414 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38418 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38422 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
     /*  38426 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_OR),
     /*  38430 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38434 */     GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_v4s32,
     /*  38438 */     GIM_RecordInsn, /*DefineMI*/4, /*MI*/1, /*OpIdx*/2, // MIs[4]
     /*  38442 */     GIM_CheckOpcodeIsEither, /*MI*/4, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
     /*  38448 */     GIM_CheckIsBuildVectorAllOnes, /*MI*/4,
     /*  38450 */     GIM_RecordInsn, /*DefineMI*/5, /*MI*/0, /*OpIdx*/2, // MIs[5]
     /*  38454 */     GIM_CheckOpcode, /*MI*/5, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38458 */     GIM_CheckType, /*MI*/5, /*Op*/1, /*Type*/GILLT_v4s32,
     /*  38462 */     GIM_RecordInsn, /*DefineMI*/6, /*MI*/5, /*OpIdx*/1, // MIs[6]
     /*  38466 */     GIM_CheckOpcode, /*MI*/6, GIMT_Encode2(TargetOpcode::G_AND),
     /*  38470 */     // MIs[6] vC
     /*  38470 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
     /*  38475 */     // MIs[6] vA
     /*  38475 */     GIM_CheckIsSameOperand, /*MI*/6, /*OpIdx*/2, /*OtherMI*/3, /*OtherOpIdx*/2,
     /*  38480 */     // MIs[5] vB
     /*  38480 */     GIM_CheckIsSameOperand, /*MI*/5, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
     /*  38485 */     GIM_CheckIsSafeToFold, /*NumInsns*/6,
     /*  38487 */     // (or:{ *:[v4i32] } (xor:{ *:[v4i32] } (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vB, (or:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA)), immAllOnesV:{ *:[v4i32] }), (and:{ *:[v4i32] } (and:{ *:[v4i32] } v4i32:{ *:[v4i32] }:$vC, v4i32:{ *:[v4i32] }:$vA), v4i32:{ *:[v4i32] }:$vB))  =>  (XXEVAL:{ *:[v4i32] } ?:{ *:[v4i32] }:$vA, ?:{ *:[v4i32] }:$vB, ?:{ *:[v4i32] }:$vC, 150:{ *:[i32] })
     /*  38487 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(PPC::XXEVAL),
     /*  38490 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[XT]
     /*  38492 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/2, // vA
     /*  38496 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // vB
     /*  38500 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // vC
     /*  38504 */     GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(150),
     /*  38514 */     GIR_RootConstrainSelectedInstOperands,
     /*  38