
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kwidgetsaddons_python.h"

// main header
#include "kfontsizeaction_wrapper.h"

// Wrappers providing overrides
#include "kselectaction_wrapper.h"
#include "kxyselector_wrapper.h"
#include "ktoolbarspaceraction_wrapper.h"

// Extra includes
#include <pysidesignal.h>

// Argument includes
#include <QString>
#include <qaction.h>
#include <qcoreevent.h>
#include <qicon.h>
#include <qmetaobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qwidget.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KFontSizeAction_Type = nullptr;
static PyTypeObject *Sbk_KFontSizeAction_TypeF(void)
{
    return _Sbk_KFontSizeAction_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KFontSizeActionWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KFontSizeActionWrapper::KFontSizeActionWrapper(::QObject * parent) : KFontSizeAction(parent)
{
}

KFontSizeActionWrapper::KFontSizeActionWrapper(const ::QIcon & icon, const ::QString & text, ::QObject * parent) : KFontSizeAction(icon, text, parent)
{
}

KFontSizeActionWrapper::KFontSizeActionWrapper(const ::QString & text, ::QObject * parent) : KFontSizeAction(text, parent)
{
}

void KFontSizeActionWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KXYSelectorWrapper::sbk_o_childEvent("KFontSizeAction", funcName, gil, pyOverride, event);
}

void KFontSizeActionWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KFontSizeAction", funcName, gil, pyOverride, signal);
}

::QWidget * KFontSizeActionWrapper::createWidget(::QWidget * parent)
{
    static const char *funcName = "createWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::createWidget(parent);
    }
    return KToolBarSpacerActionWrapper::sbk_o_createWidget("KFontSizeAction", funcName, gil, pyOverride, parent);
}

void KFontSizeActionWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KXYSelectorWrapper::sbk_o_customEvent("KFontSizeAction", funcName, gil, pyOverride, event);
}

void KFontSizeActionWrapper::deleteWidget(::QWidget * widget)
{
    static const char *funcName = "deleteWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::deleteWidget(widget);
    }
    KToolBarSpacerActionWrapper::sbk_o_deleteWidget("KFontSizeAction", funcName, gil, pyOverride, widget);
}

void KFontSizeActionWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KXYSelectorWrapper::sbk_o_connectNotify("KFontSizeAction", funcName, gil, pyOverride, signal);
}

bool KFontSizeActionWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::event(event);
    }
    return KXYSelectorWrapper::sbk_o_event("KFontSizeAction", funcName, gil, pyOverride, event);
}

bool KFontSizeActionWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::eventFilter(watched, event);
    }
    return KXYSelectorWrapper::sbk_o_eventFilter("KFontSizeAction", funcName, gil, pyOverride, watched, event);
}

void KFontSizeActionWrapper::insertAction(::QAction * before, ::QAction * action)
{
    static const char *funcName = "insertAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::insertAction(before, action);
    }
    KSelectActionWrapper::sbk_o_insertAction("KFontSizeAction", funcName, gil, pyOverride, before, action);
}

::QAction * KFontSizeActionWrapper::removeAction(::QAction * action)
{
    static const char *funcName = "removeAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::KSelectAction::removeAction(action);
    }
    return KSelectActionWrapper::sbk_o_removeAction("KFontSizeAction", funcName, gil, pyOverride, action);
}

void KFontSizeActionWrapper::slotActionTriggered(::QAction * action)
{
    static const char *funcName = "slotActionTriggered";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::KFontSizeAction::slotActionTriggered(action);
    }
    KSelectActionWrapper::sbk_o_slotActionTriggered("KFontSizeAction", funcName, gil, pyOverride, action);
}

void KFontSizeActionWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KFontSizeAction_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KXYSelectorWrapper::sbk_o_timerEvent("KFontSizeAction", funcName, gil, pyOverride, event);
}

const QMetaObject *KFontSizeActionWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KFontSizeAction::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KFontSizeActionWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KFontSizeAction::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KFontSizeActionWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KFontSizeActionWrapper *>(this));
    }
    return KFontSizeAction::qt_metacast(_clname);
}

KFontSizeActionWrapper::~KFontSizeActionWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KFontSizeAction_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KFontSizeAction_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KFontSizeAction >()))
        return -1;

    KFontSizeActionWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KFontSizeAction", 1, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KFontSizeAction::KFontSizeAction(QObject*)
    // 1: KFontSizeAction::KFontSizeAction(QIcon,QString,QObject*)
    // 2: KFontSizeAction::KFontSizeAction(QString,QObject*)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QIcon_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[2])))) {
        overloadId = 1; // KFontSizeAction(QIcon,QString,QObject*)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KFontSizeAction(QObject*)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[1])))) {
        overloadId = 2; // KFontSizeAction(QString,QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KFontSizeAction(QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontSizeAction(QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontSizeActionWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontSizeActionWrapper(cppArg0);
                }

            }
            break;
        }
        case 1: // KFontSizeAction(const QIcon &icon, const QString &text, QObject *parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QIcon cppArg0_local;
            ::QIcon *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QObject *cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontSizeAction(QIcon,QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontSizeActionWrapper(*cppArg0, cppArg1, cppArg2);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontSizeActionWrapper(*cppArg0, cppArg1, cppArg2);
                }

            }
            break;
        }
        case 2: // KFontSizeAction(const QString &text, QObject *parent)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QObject *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KFontSizeAction(QString,QObject*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) KFontSizeActionWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new KFontSizeActionWrapper(cppArg0, cppArg1);
                }

            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KFontSizeAction >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KFontSizeActionFunc_fontSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontSizeAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // fontSize()const
        int cppResult = const_cast<const ::KFontSizeAction *>(cppSelf)->fontSize();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KFontSizeActionFunc_setFontSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontSizeAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KFontSizeAction::setFontSize(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setFontSize(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setFontSize", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setFontSize(int)
            cppSelf->setFontSize(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KFontSizeActionFunc_slotActionTriggered(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KFontSizeAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KSelectAction::slotActionTriggered(QAction*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), (pyArg)))) {
        overloadId = 0; // slotActionTriggered(QAction*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotActionTriggered", errInfo, SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAction *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotActionTriggered(QAction*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KFontSizeAction::slotActionTriggered(cppArg0)
                : cppSelf->slotActionTriggered(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_KFontSizeAction_PropertyStrings[] = {
    "fontSize::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KFontSizeAction_methods[] = {
    {"fontSize", reinterpret_cast<PyCFunction>(Sbk_KFontSizeActionFunc_fontSize), METH_NOARGS, nullptr},
    {"setFontSize", reinterpret_cast<PyCFunction>(Sbk_KFontSizeActionFunc_setFontSize), METH_O, nullptr},
    {"slotActionTriggered", reinterpret_cast<PyCFunction>(Sbk_KFontSizeActionFunc_slotActionTriggered), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KFontSizeAction_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KFontSizeAction *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KFontSizeActionWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KFontSizeAction_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KFontSizeAction_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KFontSizeAction_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KFontSizeAction_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KFontSizeAction_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KFontSizeAction_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KFontSizeAction_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KFontSizeAction_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KFontSizeAction_spec = {
    "1:KWidgetsAddons.KFontSizeAction",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KFontSizeAction_slots
};

} //extern "C"

static void *Sbk_KFontSizeAction_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KFontSizeAction *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KFontSizeAction_PythonToCpp_KFontSizeAction_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KFontSizeAction_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KFontSizeAction_PythonToCpp_KFontSizeAction_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KFontSizeAction_TypeF()))
        return KFontSizeAction_PythonToCpp_KFontSizeAction_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KFontSizeAction_PTR_CppToPython_KFontSizeAction(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KFontSizeAction *>(const_cast<void *>(cppIn)), Sbk_KFontSizeAction_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KFontSizeAction_SignatureStrings[] = {
    "2:KWidgetsAddons.KFontSizeAction(self,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,fontSize:int=None)",
    "1:KWidgetsAddons.KFontSizeAction(self,icon:typing.Union[PySide6.QtGui.QIcon, PySide6.QtGui.QPixmap],text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,fontSize:int=None)",
    "0:KWidgetsAddons.KFontSizeAction(self,text:QString,parent:PySide6.QtCore.QObject,*:KeywordOnly=None,fontSize:int=None)",
    "KWidgetsAddons.KFontSizeAction.fontSize(self)->int",
    "KWidgetsAddons.KFontSizeAction.setFontSize(self,size:int)",
    "KWidgetsAddons.KFontSizeAction.slotActionTriggered(self,action:PySide6.QtGui.QAction)",
    nullptr}; // Sentinel
#else
static constexpr size_t KFontSizeAction_SignatureByteSize = 211;
static constexpr uint8_t KFontSizeAction_SignatureBytes[211] = {
    0x78, 0xda, 0xad, 0x91, 0xb1, 0x0a, 0xc2, 0x40, 0x0c, 0x86, 0x77, 0x9f, 0xc2, 0xd1, 0xca, 0x79,
    0xa8, 0x83, 0xc3, 0x81, 0x82, 0x08, 0x8a, 0x14, 0xd4, 0x52, 0xc5, 0x41, 0x1c, 0x6a, 0x2f, 0x96,
    0x48, 0xcd, 0x95, 0xbb, 0x88, 0xd6, 0xa7, 0xb7, 0xb4, 0x8a, 0xe2, 0xa0, 0x0e, 0x6e, 0xe1, 0x27,
    0xdf, 0xff, 0x05, 0xd2, 0x55, 0xfe, 0x1a, 0x75, 0x02, 0xec, 0x86, 0x5a, 0x1b, 0x72, 0xd2, 0x1f,
    0x1b, 0xe2, 0x10, 0xaf, 0x30, 0x8c, 0x19, 0x0d, 0x35, 0x1c, 0xa4, 0x7b, 0x91, 0x45, 0x16, 0x88,
    0xd5, 0x22, 0x0f, 0x51, 0x43, 0x4f, 0x06, 0x3c, 0x32, 0x16, 0x64, 0x30, 0xdf, 0x1d, 0x20, 0x66,
    0xd1, 0x54, 0x3e, 0xe4, 0x67, 0x63, 0xf5, 0x9c, 0xd2, 0xbc, 0x3f, 0x33, 0x04, 0x62, 0x7f, 0x2f,
    0x51, 0x48, 0x5c, 0x26, 0x5e, 0xad, 0xf3, 0x93, 0x09, 0x63, 0x43, 0x8a, 0xf3, 0x0c, 0x29, 0x91,
    0x2b, 0x2a, 0xe2, 0xcd, 0x53, 0x3a, 0x39, 0xa1, 0x0c, 0xa6, 0xc5, 0x82, 0xa8, 0xbf, 0x85, 0x0b,
    0xbc, 0x1c, 0xa3, 0x6c, 0x2b, 0x18, 0x2e, 0xac, 0x82, 0x90, 0x6d, 0x81, 0xff, 0xe5, 0xe8, 0xf6,
    0x4f, 0x47, 0xff, 0x5d, 0xfb, 0x59, 0x2a, 0x1f, 0x44, 0x69, 0xf7, 0x5a, 0x83, 0x02, 0xfc, 0x86,
    0x38, 0xe0, 0xf1, 0x2b, 0x25, 0xdc, 0xdd, 0xf8, 0x55, 0xe6, 0x52, 0xc3, 0xd5, 0xb8, 0xb4, 0x98,
    0x24, 0x60, 0x41, 0x57, 0x0d, 0x51, 0x19, 0xaa, 0xb7, 0x57, 0x54, 0xab, 0x5e, 0xed, 0x06, 0x4a,
    0x44, 0xdb, 0x75
};
#endif

PyTypeObject *init_KFontSizeAction(PyObject *module)
{
    if (SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX].type != nullptr)
        return SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX].type;

    Shiboken::AutoDecRef Sbk_KFontSizeAction_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKWidgetsAddonsTypeStructs[SBK_KSelectAction_IDX]))));

    _Sbk_KFontSizeAction_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KFontSizeAction",
        "KFontSizeAction*",
        &Sbk_KFontSizeAction_spec,
        &Shiboken::callCppDestructor< KFontSizeAction >,
        Sbk_KFontSizeAction_Type_bases.object(),
        0);
    auto *pyType = Sbk_KFontSizeAction_TypeF(); // references _Sbk_KFontSizeAction_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KFontSizeAction_SignatureStrings);
#else
    InitSignatureBytes(pyType, KFontSizeAction_SignatureBytes, KFontSizeAction_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KFontSizeAction_PropertyStrings);
    SbkKWidgetsAddonsTypeStructs[SBK_KFontSizeAction_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KFontSizeAction_PythonToCpp_KFontSizeAction_PTR,
        is_KFontSizeAction_PythonToCpp_KFontSizeAction_PTR_Convertible,
        KFontSizeAction_PTR_CppToPython_KFontSizeAction);

    Shiboken::Conversions::registerConverterName(converter, "KFontSizeAction");
    Shiboken::Conversions::registerConverterName(converter, "KFontSizeAction*");
    Shiboken::Conversions::registerConverterName(converter, "KFontSizeAction&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KFontSizeAction).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KFontSizeActionWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KFontSizeAction_TypeF(), &Sbk_KFontSizeAction_typeDiscovery);

    PySide::Signal::registerSignals(pyType, &::KFontSizeAction::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KFontSizeAction::staticMetaObject, sizeof(KFontSizeActionWrapper));

    return pyType;
}
