
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kguiaddons_python.h"

// main header
#include "kwordwrap_wrapper.h"

// Argument includes
#include <QString>
#include <kwordwrap.h>
#include <qfontmetrics.h>
#include <qpainter.h>
#include <qrect.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KWordWrap_Type = nullptr;
static PyTypeObject *Sbk_KWordWrap_TypeF(void)
{
    return _Sbk_KWordWrap_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KWordWrap_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KWordWrap >()))
        return -1;

    ::KWordWrap *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "KWordWrap", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KWordWrap::KWordWrap(KWordWrap)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KWordWrap(KWordWrap)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::KWordWrap *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KWordWrap(KWordWrap)
            cptr = new ::KWordWrap(*cppArg0);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KWordWrap >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KWordWrapFunc_boundingRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordWrap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // boundingRect()const
        QRect cppResult = const_cast<const ::KWordWrap *>(cppSelf)->boundingRect();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KWordWrapFunc_drawFadeoutText(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "drawFadeoutText", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KWordWrap::drawFadeoutText(QPainter*,int,int,int,QString)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
        overloadId = 0; // drawFadeoutText(QPainter*,int,int,int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "drawFadeoutText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // drawFadeoutText(QPainter*,int,int,int,QString)
            ::KWordWrap::drawFadeoutText(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWordWrapFunc_drawText(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordWrap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[4];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 3, 4));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "drawText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    if (PyArg_ParseTuple(args, "|OOOO:drawText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KWordWrap::drawText(QPainter*,int,int,int=)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawText(QPainter*,int,int,int)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
            overloadId = 0; // drawText(QPainter*,int,int,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "drawText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"flags", 3}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "drawText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3 = Qt::AlignLeft;
        if (pythonToCpp[3])
            pythonToCpp[3](pyArgs[3], &cppArg3);

        if (Shiboken::Errors::occurred() == nullptr) {
            // drawText(QPainter*,int,int,int)const
            const_cast<const ::KWordWrap *>(cppSelf)->drawText(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWordWrapFunc_drawTruncateText(PyObject *self, PyObject *args)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "drawTruncateText", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KWordWrap::drawTruncateText(QPainter*,int,int,int,QString)
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPainter_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
        overloadId = 0; // drawTruncateText(QPainter*,int,int,int,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "drawTruncateText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // drawTruncateText(QPainter*,int,int,int,QString)
            ::KWordWrap::drawTruncateText(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KWordWrapFunc_formatText(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 4, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "formatText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:formatText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KWordWrap::formatText(QFontMetrics&,QRect,int,QString,int=)->KWordWrap
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QFontMetrics_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRect_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // formatText(QFontMetrics&,QRect,int,QString,int)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4])))) {
            overloadId = 0; // formatText(QFontMetrics&,QRect,int,QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "formatText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"len", 4}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[4]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "formatText", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
        ::QFontMetrics *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1].isValue())
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        int cppArg4 = -1;
        if (pythonToCpp[4])
            pythonToCpp[4](pyArgs[4], &cppArg4);

        if (Shiboken::Errors::occurred() == nullptr) {
            // formatText(QFontMetrics&,QRect,int,QString,int)
            KWordWrap* cppResult = new KWordWrap(::KWordWrap::formatText(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4));
            pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]), cppResult, true, true);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KWordWrapFunc_truncatedString(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordWrap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "truncatedString", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    if (PyArg_ParseTuple(args, "|O:truncatedString", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KWordWrap::truncatedString(bool=)const->QString
    if (numArgs == 0) {
        overloadId = 0; // truncatedString(bool)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0])))) {
        overloadId = 0; // truncatedString(bool)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "truncatedString", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"dots", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "truncatedString", errInfo, SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]);
            }
        }
        bool cppArg0 = true;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // truncatedString(bool)const
            QString cppResult = const_cast<const ::KWordWrap *>(cppSelf)->truncatedString(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KWordWrapFunc_wrappedString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KWordWrap *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // wrappedString()const
        QString cppResult = const_cast<const ::KWordWrap *>(cppSelf)->wrappedString();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KWordWrap_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KWordWrap_methods[] = {
    {"boundingRect", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_boundingRect), METH_NOARGS, nullptr},
    {"drawFadeoutText", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_drawFadeoutText), METH_VARARGS|METH_STATIC, nullptr},
    {"drawText", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_drawText), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"drawTruncateText", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_drawTruncateText), METH_VARARGS|METH_STATIC, nullptr},
    {"formatText", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_formatText), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"truncatedString", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_truncatedString), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"wrappedString", reinterpret_cast<PyCFunction>(Sbk_KWordWrapFunc_wrappedString), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KWordWrap_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KWordWrap_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KWordWrap_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KWordWrap_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KWordWrap_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KWordWrap_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KWordWrap_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KWordWrap_spec = {
    "1:KGuiAddons.KWordWrap",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KWordWrap_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KWordWrap_PythonToCpp_KWordWrap_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KWordWrap_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KWordWrap_PythonToCpp_KWordWrap_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KWordWrap_TypeF()))
        return KWordWrap_PythonToCpp_KWordWrap_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KWordWrap_PTR_CppToPython_KWordWrap(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KWordWrap_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KWordWrap_TypeF(), const_cast<void *>(cppIn), false);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KWordWrap_SignatureStrings[] = {
    "KGuiAddons.KWordWrap(self,other:KGuiAddons.KWordWrap)",
    "KGuiAddons.KWordWrap.boundingRect(self)->PySide6.QtCore.QRect",
    "KGuiAddons.KWordWrap.drawFadeoutText(p:PySide6.QtGui.QPainter,x:int,y:int,maxW:int,t:QString)",
    "KGuiAddons.KWordWrap.drawText(self,painter:PySide6.QtGui.QPainter,x:int,y:int,flags:int=Qt.AlignLeft)",
    "KGuiAddons.KWordWrap.drawTruncateText(p:PySide6.QtGui.QPainter,x:int,y:int,maxW:int,t:QString)",
    "KGuiAddons.KWordWrap.formatText(fm:PySide6.QtGui.QFontMetrics,r:PySide6.QtCore.QRect,flags:int,str:QString,len:int=-1)->KGuiAddons.KWordWrap",
    "KGuiAddons.KWordWrap.truncatedString(self,dots:bool=true)->QString",
    "KGuiAddons.KWordWrap.wrappedString(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KWordWrap_SignatureByteSize = 251;
static constexpr uint8_t KWordWrap_SignatureBytes[251] = {
    0x78, 0xda, 0xb5, 0x91, 0x41, 0x6b, 0x03, 0x21, 0x10, 0x85, 0xef, 0xfd, 0x25, 0x59, 0x30, 0x42,
    0x2f, 0x3d, 0x08, 0x29, 0x84, 0x42, 0x7a, 0xd8, 0x16, 0x62, 0x13, 0xd8, 0xb3, 0x59, 0x67, 0x37,
    0x82, 0xeb, 0x2c, 0x3a, 0x4b, 0x36, 0xff, 0x3e, 0xc6, 0x4d, 0xd9, 0xb4, 0xd8, 0xd2, 0x4b, 0x2f,
    0xa3, 0x38, 0xbe, 0xef, 0xf9, 0xc6, 0xf2, 0x75, 0x30, 0x6b, 0xad, 0xd1, 0x05, 0x5e, 0x56, 0xe8,
    0x75, 0xe5, 0x55, 0xbf, 0x08, 0x60, 0x1b, 0x86, 0x74, 0x04, 0x2f, 0xca, 0x4c, 0xbf, 0x78, 0xc8,
    0x9d, 0xf2, 0x03, 0x0e, 0x4e, 0x1b, 0xd7, 0x7e, 0x40, 0x4d, 0x09, 0x51, 0x2c, 0x9f, 0xb7, 0xe7,
    0x9d, 0xd1, 0xf0, 0xc4, 0x25, 0xbd, 0xa0, 0x07, 0x2e, 0xaf, 0xbd, 0xbc, 0x5a, 0x7b, 0x75, 0xda,
    0x28, 0x0d, 0x38, 0xd0, 0x1e, 0x46, 0x5a, 0xf4, 0x62, 0xd6, 0xc6, 0xfb, 0x5c, 0x6e, 0x95, 0x71,
    0x04, 0x9e, 0x8d, 0x22, 0xae, 0xec, 0x9c, 0x6a, 0xa7, 0xc6, 0x2a, 0x6d, 0x48, 0xc8, 0x1d, 0xf9,
    0x68, 0x5e, 0xfc, 0x4c, 0x4f, 0xd8, 0x14, 0xad, 0x9f, 0x50, 0x7f, 0x71, 0x68, 0xac, 0x6a, 0xc3,
    0x75, 0xb7, 0x92, 0xc4, 0xd7, 0xd6, 0xb4, 0xee, 0x0d, 0x1a, 0xfa, 0xcd, 0xc5, 0x0f, 0xae, 0x56,
    0x04, 0xff, 0x10, 0xa2, 0x41, 0xdf, 0xa9, 0x69, 0x3a, 0x4d, 0xf7, 0x9d, 0xbc, 0x41, 0x47, 0xef,
    0x10, 0xe5, 0x75, 0x60, 0xf7, 0xc9, 0xe6, 0xb9, 0xcf, 0x59, 0x58, 0x20, 0xff, 0xe9, 0xc5, 0x2c,
    0xb8, 0x94, 0x6f, 0xf9, 0x18, 0xff, 0x2b, 0xe7, 0x9b, 0x7f, 0x0c, 0xdd, 0x72, 0xea, 0x09, 0x33,
    0x0d, 0x56, 0x23, 0x05, 0x71, 0x40, 0xb4, 0xab, 0xd8, 0x86, 0xc8, 0xbb, 0x99, 0xe4, 0x11, 0xa7,
    0x58, 0xfa, 0x2f, 0x80, 0x3b, 0xc5, 0x05, 0xa9, 0x5c, 0xf0, 0x7a
};
#endif

PyTypeObject *init_KWordWrap(PyObject *module)
{
    if (SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX].type != nullptr)
        return SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX].type;

    Shiboken::AutoDecRef Sbk_KWordWrap_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KWordWrap_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KWordWrap",
        "KWordWrap*",
        &Sbk_KWordWrap_spec,
        &Shiboken::callCppDestructor< ::KWordWrap >,
        Sbk_KWordWrap_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KWordWrap_Type; // references _Sbk_KWordWrap_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KWordWrap_SignatureStrings);
#else
    InitSignatureBytes(pyType, KWordWrap_SignatureBytes, KWordWrap_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KWordWrap_PropertyStrings);
    SbkKGuiAddonsTypeStructs[SBK_KWordWrap_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KWordWrap_PythonToCpp_KWordWrap_PTR,
        is_KWordWrap_PythonToCpp_KWordWrap_PTR_Convertible,
        KWordWrap_PTR_CppToPython_KWordWrap);

    Shiboken::Conversions::registerConverterName(converter, "KWordWrap");
    Shiboken::Conversions::registerConverterName(converter, "KWordWrap*");
    Shiboken::Conversions::registerConverterName(converter, "KWordWrap&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KWordWrap).name());

    qRegisterMetaType< ::KWordWrap *>();

    return pyType;
}
