
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kaboutperson_wrapper.h"

// Argument includes
#include <QString>
#include <kaboutdata.h>
#include <qjsonobject.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qurl.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAboutPerson_Type = nullptr;
static PyTypeObject *Sbk_KAboutPerson_TypeF(void)
{
    return _Sbk_KAboutPerson_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAboutPerson_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAboutPerson >()))
        return -1;

    ::KAboutPerson *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:KAboutPerson", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAboutPerson::KAboutPerson(KAboutPerson)
    // 1: KAboutPerson::KAboutPerson(const QString&=,const QString&=,const QString&=,const QString&=,const QUrl&=)
    if (numArgs == 0) {
        overloadId = 1; // KAboutPerson(QString,QString,QString,QString,QUrl)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KAboutPerson(QString,QString,QString,QString,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KAboutPerson(QString,QString,QString,QString,QUrl)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // KAboutPerson(QString,QString,QString,QString,QUrl)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // KAboutPerson(QString,QString,QString,QString,QUrl)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[4])))) {
                        overloadId = 1; // KAboutPerson(QString,QString,QString,QString,QUrl)
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KAboutPerson(KAboutPerson)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KAboutPerson(const KAboutPerson &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KAboutPerson cppArg0_local;
            ::KAboutPerson *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutPerson(KAboutPerson)
                cptr = new ::KAboutPerson(*cppArg0);
            }
            break;
        }
        case 1: // KAboutPerson(const QString &name, const QString &task, const QString &emailAddress, const QString &webAddress, const QUrl &avatarUrl)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[5] = {{"name", 0}, {"task", 1}, {"emailAddress", 2}, {"webAddress", 3}, {"avatarUrl", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 5, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);
                }
            }
            ::QString cppArg0 = QString();
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return -1;
            ::QUrl cppArg4_local = QUrl();
            ::QUrl *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
                if (pythonToCpp[4].isValue())
                    pythonToCpp[4](pyArgs[4], &cppArg4_local);
                else
                    pythonToCpp[4](pyArgs[4], &cppArg4);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutPerson(QString,QString,QString,QString,QUrl)
                cptr = new ::KAboutPerson(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KAboutPerson >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KAboutPersonFunc_avatarUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // avatarUrl()const
        QUrl cppResult = const_cast<const ::KAboutPerson *>(cppSelf)->avatarUrl();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutPersonFunc_emailAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // emailAddress()const
        QString cppResult = const_cast<const ::KAboutPerson *>(cppSelf)->emailAddress();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutPersonFunc_fromJSON(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KAboutPerson::fromJSON(QJsonObject)->KAboutPerson
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QJsonObject_IDX], (pyArg)))) {
        overloadId = 0; // fromJSON(QJsonObject)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fromJSON", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]);

    // Call function/method
    {
        ::QJsonObject cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // fromJSON(QJsonObject)
            KAboutPerson cppResult = ::KAboutPerson::fromJSON(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutPersonFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        QString cppResult = const_cast<const ::KAboutPerson *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutPersonFunc_task(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // task()const
        QString cppResult = const_cast<const ::KAboutPerson *>(cppSelf)->task();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutPersonFunc_webAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webAddress()const
        QString cppResult = const_cast<const ::KAboutPerson *>(cppSelf)->webAddress();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutPerson__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KAboutPerson_PropertyStrings[] = {
    "avatarUrl:",
    "emailAddress:",
    "name:",
    "task:",
    "webAddress:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAboutPerson_methods[] = {
    {"avatarUrl", reinterpret_cast<PyCFunction>(Sbk_KAboutPersonFunc_avatarUrl), METH_NOARGS, nullptr},
    {"emailAddress", reinterpret_cast<PyCFunction>(Sbk_KAboutPersonFunc_emailAddress), METH_NOARGS, nullptr},
    {"fromJSON", reinterpret_cast<PyCFunction>(Sbk_KAboutPersonFunc_fromJSON), METH_O|METH_STATIC, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_KAboutPersonFunc_name), METH_NOARGS, nullptr},
    {"task", reinterpret_cast<PyCFunction>(Sbk_KAboutPersonFunc_task), METH_NOARGS, nullptr},
    {"webAddress", reinterpret_cast<PyCFunction>(Sbk_KAboutPersonFunc_webAddress), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KAboutPerson__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KAboutPerson_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAboutPerson_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAboutPerson_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAboutPerson_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAboutPerson_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAboutPerson_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAboutPerson_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAboutPerson_spec = {
    "1:KCoreAddons.KAboutPerson",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAboutPerson_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAboutPerson_PythonToCpp_KAboutPerson_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAboutPerson_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAboutPerson_PythonToCpp_KAboutPerson_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutPerson_TypeF()))
        return KAboutPerson_PythonToCpp_KAboutPerson_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAboutPerson_PTR_CppToPython_KAboutPerson(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KAboutPerson_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KAboutPerson_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KAboutPerson_COPY_CppToPython_KAboutPerson(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KAboutPerson *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KAboutPerson_TypeF(), new ::KAboutPerson(*source), true, true);
}

// Python to C++ copy conversion.
static void KAboutPerson_PythonToCpp_KAboutPerson_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KAboutPerson *>(cppOut) = *reinterpret_cast< ::KAboutPerson *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KAboutPerson_PythonToCpp_KAboutPerson_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutPerson_TypeF()))
        return KAboutPerson_PythonToCpp_KAboutPerson_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAboutPerson_SignatureStrings[] = {
    "1:KCoreAddons.KAboutPerson(self,other:KCoreAddons.KAboutPerson,*:KeywordOnly=None,name:QString=None,task:QString=None,emailAddress:QString=None,webAddress:QString=None,avatarUrl:QUrl=None)",
    "0:KCoreAddons.KAboutPerson(self,name:QString=QString(),task:QString=QString(),emailAddress:QString=QString(),webAddress:QString=QString(),avatarUrl:typing.Union[PySide6.QtCore.QUrl, QString]=QUrl(),*:KeywordOnly=None,name:QString=None,task:QString=None,emailAddress:QString=None,webAddress:QString=None,avatarUrl:QUrl=None)",
    "KCoreAddons.KAboutPerson.avatarUrl(self)->PySide6.QtCore.QUrl",
    "KCoreAddons.KAboutPerson.emailAddress(self)->QString",
    "KCoreAddons.KAboutPerson.fromJSON(obj:QJsonObject)->KCoreAddons.KAboutPerson",
    "KCoreAddons.KAboutPerson.name(self)->QString",
    "KCoreAddons.KAboutPerson.task(self)->QString",
    "KCoreAddons.KAboutPerson.webAddress(self)->QString",
    "KCoreAddons.KAboutPerson.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KAboutPerson_SignatureByteSize = 261;
static constexpr uint8_t KAboutPerson_SignatureBytes[261] = {
    0x78, 0xda, 0xc5, 0x92, 0xc1, 0x6b, 0xc2, 0x30, 0x14, 0xc6, 0xef, 0xfe, 0x15, 0x3b, 0xb6, 0xd2,
    0x05, 0x77, 0xf1, 0x10, 0x70, 0x20, 0xde, 0x2c, 0x58, 0x4b, 0xf1, 0x34, 0x46, 0x48, 0xed, 0x73,
    0xab, 0xb6, 0x79, 0x92, 0x64, 0x93, 0xfc, 0xf7, 0x4b, 0x5c, 0x5d, 0x56, 0x68, 0xb0, 0x37, 0x2f,
    0x09, 0xf9, 0xde, 0xfb, 0x5e, 0x7e, 0xf9, 0xc8, 0x0b, 0x4d, 0x57, 0x28, 0x61, 0x59, 0x55, 0x28,
    0x14, 0x49, 0x97, 0x25, 0x7e, 0xe9, 0x2d, 0x48, 0x85, 0x22, 0x52, 0xd0, 0x1c, 0x12, 0xd4, 0x9f,
    0x20, 0x83, 0x3d, 0xc9, 0x94, 0xa6, 0x60, 0x2e, 0x28, 0xab, 0x4c, 0x34, 0x66, 0xb1, 0x41, 0x01,
    0x89, 0xe0, 0x2d, 0xd0, 0xbc, 0xd0, 0xb2, 0x16, 0x1f, 0xbf, 0x8a, 0xe6, 0xea, 0xd4, 0x57, 0xa0,
    0xe5, 0x75, 0x63, 0xe7, 0x49, 0x50, 0xaa, 0x5f, 0xb9, 0x40, 0x39, 0xa8, 0xf3, 0x6f, 0xae, 0xb9,
    0xdc, 0xc9, 0x86, 0xe6, 0x76, 0xb9, 0x6a, 0xf1, 0x64, 0x76, 0x07, 0xbe, 0x87, 0xd2, 0xed, 0x51,
    0xdc, 0xe7, 0xf1, 0xf2, 0x20, 0x94, 0x2f, 0x0f, 0x90, 0xf9, 0xa2, 0xc7, 0xd3, 0xe6, 0x6c, 0x25,
    0xb2, 0x13, 0x35, 0x8a, 0xb7, 0xad, 0x29, 0xea, 0x0a, 0xe6, 0x24, 0xd7, 0x8e, 0x93, 0x38, 0xf4,
    0xe4, 0xa9, 0x73, 0xbd, 0x2f, 0xdc, 0xd1, 0x7a, 0x1f, 0x9b, 0x61, 0x28, 0x41, 0xf2, 0xd7, 0x7d,
    0xcd, 0x32, 0x7e, 0x7e, 0x1d, 0x78, 0x4c, 0xd8, 0xfd, 0x9f, 0xee, 0x36, 0xa0, 0x83, 0x09, 0x9b,
    0x0e, 0x12, 0xdb, 0x75, 0x91, 0x6d, 0x22, 0x2c, 0x8f, 0x34, 0x5f, 0x5b, 0x29, 0x2b, 0x8f, 0xb0,
    0xd7, 0xd6, 0x1b, 0xf2, 0x84, 0x87, 0xb9, 0x0c, 0x47, 0xdf, 0xec, 0xe2, 0x1d, 0xdd, 0xec, 0xf3,
    0x1d, 0x6d, 0x61, 0x6c, 0x8f, 0x67, 0xc3, 0xd8, 0xcd, 0xd0, 0xfd, 0x12, 0x56, 0xd8, 0xe3, 0xe4,
    0x07, 0x2e, 0xc2, 0x46, 0xcd
};
#endif

PyTypeObject *init_KAboutPerson(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX].type;

    Shiboken::AutoDecRef Sbk_KAboutPerson_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KAboutPerson_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAboutPerson",
        "KAboutPerson",
        &Sbk_KAboutPerson_spec,
        &Shiboken::callCppDestructor< ::KAboutPerson >,
        Sbk_KAboutPerson_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_KAboutPerson_Type; // references _Sbk_KAboutPerson_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAboutPerson_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAboutPerson_SignatureBytes, KAboutPerson_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAboutPerson_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAboutPerson_PythonToCpp_KAboutPerson_PTR,
        is_KAboutPerson_PythonToCpp_KAboutPerson_PTR_Convertible,
        KAboutPerson_PTR_CppToPython_KAboutPerson,
        KAboutPerson_COPY_CppToPython_KAboutPerson);

    Shiboken::Conversions::registerConverterName(converter, "KAboutPerson");
    Shiboken::Conversions::registerConverterName(converter, "KAboutPerson*");
    Shiboken::Conversions::registerConverterName(converter, "KAboutPerson&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAboutPerson).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KAboutPerson_PythonToCpp_KAboutPerson_COPY,
        is_KAboutPerson_PythonToCpp_KAboutPerson_COPY_Convertible);

    qRegisterMetaType< ::KAboutPerson >("KAboutPerson");

    return pyType;
}
