{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Arranges child widgets in rows and columns.
-- 
-- Children have an \"attach point\" defined by the horizontal and vertical
-- index of the cell they occupy; children can span multiple rows or columns.
-- The layout properties for setting the attach points and spans are set
-- using the t'GI.Gtk.Objects.GridLayoutChild.GridLayoutChild' associated to each child widget.
-- 
-- The behaviour of @GtkGridLayout@ when several children occupy the same
-- grid cell is undefined.
-- 
-- @GtkGridLayout@ can be used like a @GtkBoxLayout@ if all children are
-- attached to the same row or column; however, if you only ever need a
-- single row or column, you should consider using @GtkBoxLayout@.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.GridLayout
    ( 

-- * Exported types
    GridLayout(..)                          ,
    IsGridLayout                            ,
    toGridLayout                            ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [allocate]("GI.Gtk.Objects.LayoutManager#g:method:allocate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [layoutChanged]("GI.Gtk.Objects.LayoutManager#g:method:layoutChanged"), [measure]("GI.Gtk.Objects.LayoutManager#g:method:measure"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getBaselineRow]("GI.Gtk.Objects.GridLayout#g:method:getBaselineRow"), [getColumnHomogeneous]("GI.Gtk.Objects.GridLayout#g:method:getColumnHomogeneous"), [getColumnSpacing]("GI.Gtk.Objects.GridLayout#g:method:getColumnSpacing"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getLayoutChild]("GI.Gtk.Objects.LayoutManager#g:method:getLayoutChild"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequestMode]("GI.Gtk.Objects.LayoutManager#g:method:getRequestMode"), [getRowBaselinePosition]("GI.Gtk.Objects.GridLayout#g:method:getRowBaselinePosition"), [getRowHomogeneous]("GI.Gtk.Objects.GridLayout#g:method:getRowHomogeneous"), [getRowSpacing]("GI.Gtk.Objects.GridLayout#g:method:getRowSpacing"), [getWidget]("GI.Gtk.Objects.LayoutManager#g:method:getWidget").
-- 
-- ==== Setters
-- [setBaselineRow]("GI.Gtk.Objects.GridLayout#g:method:setBaselineRow"), [setColumnHomogeneous]("GI.Gtk.Objects.GridLayout#g:method:setColumnHomogeneous"), [setColumnSpacing]("GI.Gtk.Objects.GridLayout#g:method:setColumnSpacing"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setRowBaselinePosition]("GI.Gtk.Objects.GridLayout#g:method:setRowBaselinePosition"), [setRowHomogeneous]("GI.Gtk.Objects.GridLayout#g:method:setRowHomogeneous"), [setRowSpacing]("GI.Gtk.Objects.GridLayout#g:method:setRowSpacing").

#if defined(ENABLE_OVERLOADING)
    ResolveGridLayoutMethod                 ,
#endif

-- ** getBaselineRow #method:getBaselineRow#

#if defined(ENABLE_OVERLOADING)
    GridLayoutGetBaselineRowMethodInfo      ,
#endif
    gridLayoutGetBaselineRow                ,


-- ** getColumnHomogeneous #method:getColumnHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridLayoutGetColumnHomogeneousMethodInfo,
#endif
    gridLayoutGetColumnHomogeneous          ,


-- ** getColumnSpacing #method:getColumnSpacing#

#if defined(ENABLE_OVERLOADING)
    GridLayoutGetColumnSpacingMethodInfo    ,
#endif
    gridLayoutGetColumnSpacing              ,


-- ** getRowBaselinePosition #method:getRowBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    GridLayoutGetRowBaselinePositionMethodInfo,
#endif
    gridLayoutGetRowBaselinePosition        ,


-- ** getRowHomogeneous #method:getRowHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridLayoutGetRowHomogeneousMethodInfo   ,
#endif
    gridLayoutGetRowHomogeneous             ,


-- ** getRowSpacing #method:getRowSpacing#

#if defined(ENABLE_OVERLOADING)
    GridLayoutGetRowSpacingMethodInfo       ,
#endif
    gridLayoutGetRowSpacing                 ,


-- ** new #method:new#

    gridLayoutNew                           ,


-- ** setBaselineRow #method:setBaselineRow#

#if defined(ENABLE_OVERLOADING)
    GridLayoutSetBaselineRowMethodInfo      ,
#endif
    gridLayoutSetBaselineRow                ,


-- ** setColumnHomogeneous #method:setColumnHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridLayoutSetColumnHomogeneousMethodInfo,
#endif
    gridLayoutSetColumnHomogeneous          ,


-- ** setColumnSpacing #method:setColumnSpacing#

#if defined(ENABLE_OVERLOADING)
    GridLayoutSetColumnSpacingMethodInfo    ,
#endif
    gridLayoutSetColumnSpacing              ,


-- ** setRowBaselinePosition #method:setRowBaselinePosition#

#if defined(ENABLE_OVERLOADING)
    GridLayoutSetRowBaselinePositionMethodInfo,
#endif
    gridLayoutSetRowBaselinePosition        ,


-- ** setRowHomogeneous #method:setRowHomogeneous#

#if defined(ENABLE_OVERLOADING)
    GridLayoutSetRowHomogeneousMethodInfo   ,
#endif
    gridLayoutSetRowHomogeneous             ,


-- ** setRowSpacing #method:setRowSpacing#

#if defined(ENABLE_OVERLOADING)
    GridLayoutSetRowSpacingMethodInfo       ,
#endif
    gridLayoutSetRowSpacing                 ,




 -- * Properties


-- ** baselineRow #attr:baselineRow#
-- | The row to align to the baseline, when @GtkWidget:valign@ is set
-- to 'GI.Gtk.Enums.AlignBaseline'.

#if defined(ENABLE_OVERLOADING)
    GridLayoutBaselineRowPropertyInfo       ,
#endif
    constructGridLayoutBaselineRow          ,
    getGridLayoutBaselineRow                ,
#if defined(ENABLE_OVERLOADING)
    gridLayoutBaselineRow                   ,
#endif
    setGridLayoutBaselineRow                ,


-- ** columnHomogeneous #attr:columnHomogeneous#
-- | Whether all the columns in the grid have the same width.

#if defined(ENABLE_OVERLOADING)
    GridLayoutColumnHomogeneousPropertyInfo ,
#endif
    constructGridLayoutColumnHomogeneous    ,
    getGridLayoutColumnHomogeneous          ,
#if defined(ENABLE_OVERLOADING)
    gridLayoutColumnHomogeneous             ,
#endif
    setGridLayoutColumnHomogeneous          ,


-- ** columnSpacing #attr:columnSpacing#
-- | The amount of space between to consecutive columns.

#if defined(ENABLE_OVERLOADING)
    GridLayoutColumnSpacingPropertyInfo     ,
#endif
    constructGridLayoutColumnSpacing        ,
    getGridLayoutColumnSpacing              ,
#if defined(ENABLE_OVERLOADING)
    gridLayoutColumnSpacing                 ,
#endif
    setGridLayoutColumnSpacing              ,


-- ** rowHomogeneous #attr:rowHomogeneous#
-- | Whether all the rows in the grid have the same height.

#if defined(ENABLE_OVERLOADING)
    GridLayoutRowHomogeneousPropertyInfo    ,
#endif
    constructGridLayoutRowHomogeneous       ,
    getGridLayoutRowHomogeneous             ,
#if defined(ENABLE_OVERLOADING)
    gridLayoutRowHomogeneous                ,
#endif
    setGridLayoutRowHomogeneous             ,


-- ** rowSpacing #attr:rowSpacing#
-- | The amount of space between to consecutive rows.

#if defined(ENABLE_OVERLOADING)
    GridLayoutRowSpacingPropertyInfo        ,
#endif
    constructGridLayoutRowSpacing           ,
    getGridLayoutRowSpacing                 ,
#if defined(ENABLE_OVERLOADING)
    gridLayoutRowSpacing                    ,
#endif
    setGridLayoutRowSpacing                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager

#endif

-- | Memory-managed wrapper type.
newtype GridLayout = GridLayout (SP.ManagedPtr GridLayout)
    deriving (Eq)

instance SP.ManagedPtrNewtype GridLayout where
    toManagedPtr (GridLayout p) = p

foreign import ccall "gtk_grid_layout_get_type"
    c_gtk_grid_layout_get_type :: IO B.Types.GType

instance B.Types.TypedObject GridLayout where
    glibType = c_gtk_grid_layout_get_type

instance B.Types.GObject GridLayout

-- | Type class for types which can be safely cast to t'GridLayout', for instance with `toGridLayout`.
class (SP.GObject o, O.IsDescendantOf GridLayout o) => IsGridLayout o
instance (SP.GObject o, O.IsDescendantOf GridLayout o) => IsGridLayout o

instance O.HasParentTypes GridLayout
type instance O.ParentTypes GridLayout = '[Gtk.LayoutManager.LayoutManager, GObject.Object.Object]

-- | Cast to t'GridLayout', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toGridLayout :: (MIO.MonadIO m, IsGridLayout o) => o -> m GridLayout
toGridLayout = MIO.liftIO . B.ManagedPtr.unsafeCastTo GridLayout

-- | Convert t'GridLayout' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe GridLayout) where
    gvalueGType_ = c_gtk_grid_layout_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr GridLayout)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr GridLayout)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject GridLayout ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveGridLayoutMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveGridLayoutMethod "allocate" o = Gtk.LayoutManager.LayoutManagerAllocateMethodInfo
    ResolveGridLayoutMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveGridLayoutMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveGridLayoutMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveGridLayoutMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveGridLayoutMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveGridLayoutMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveGridLayoutMethod "layoutChanged" o = Gtk.LayoutManager.LayoutManagerLayoutChangedMethodInfo
    ResolveGridLayoutMethod "measure" o = Gtk.LayoutManager.LayoutManagerMeasureMethodInfo
    ResolveGridLayoutMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveGridLayoutMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveGridLayoutMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveGridLayoutMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveGridLayoutMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveGridLayoutMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveGridLayoutMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveGridLayoutMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveGridLayoutMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveGridLayoutMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveGridLayoutMethod "getBaselineRow" o = GridLayoutGetBaselineRowMethodInfo
    ResolveGridLayoutMethod "getColumnHomogeneous" o = GridLayoutGetColumnHomogeneousMethodInfo
    ResolveGridLayoutMethod "getColumnSpacing" o = GridLayoutGetColumnSpacingMethodInfo
    ResolveGridLayoutMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveGridLayoutMethod "getLayoutChild" o = Gtk.LayoutManager.LayoutManagerGetLayoutChildMethodInfo
    ResolveGridLayoutMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveGridLayoutMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveGridLayoutMethod "getRequestMode" o = Gtk.LayoutManager.LayoutManagerGetRequestModeMethodInfo
    ResolveGridLayoutMethod "getRowBaselinePosition" o = GridLayoutGetRowBaselinePositionMethodInfo
    ResolveGridLayoutMethod "getRowHomogeneous" o = GridLayoutGetRowHomogeneousMethodInfo
    ResolveGridLayoutMethod "getRowSpacing" o = GridLayoutGetRowSpacingMethodInfo
    ResolveGridLayoutMethod "getWidget" o = Gtk.LayoutManager.LayoutManagerGetWidgetMethodInfo
    ResolveGridLayoutMethod "setBaselineRow" o = GridLayoutSetBaselineRowMethodInfo
    ResolveGridLayoutMethod "setColumnHomogeneous" o = GridLayoutSetColumnHomogeneousMethodInfo
    ResolveGridLayoutMethod "setColumnSpacing" o = GridLayoutSetColumnSpacingMethodInfo
    ResolveGridLayoutMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveGridLayoutMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveGridLayoutMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveGridLayoutMethod "setRowBaselinePosition" o = GridLayoutSetRowBaselinePositionMethodInfo
    ResolveGridLayoutMethod "setRowHomogeneous" o = GridLayoutSetRowHomogeneousMethodInfo
    ResolveGridLayoutMethod "setRowSpacing" o = GridLayoutSetRowSpacingMethodInfo
    ResolveGridLayoutMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveGridLayoutMethod t GridLayout, O.OverloadedMethod info GridLayout p) => OL.IsLabel t (GridLayout -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveGridLayoutMethod t GridLayout, O.OverloadedMethod info GridLayout p, R.HasField t GridLayout p) => R.HasField t GridLayout p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveGridLayoutMethod t GridLayout, O.OverloadedMethodInfo info GridLayout) => OL.IsLabel t (O.MethodProxy info GridLayout) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "baseline-row"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@baseline-row@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridLayout #baselineRow
-- @
getGridLayoutBaselineRow :: (MonadIO m, IsGridLayout o) => o -> m Int32
getGridLayoutBaselineRow obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "baseline-row"

-- | Set the value of the “@baseline-row@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridLayout [ #baselineRow 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridLayoutBaselineRow :: (MonadIO m, IsGridLayout o) => o -> Int32 -> m ()
setGridLayoutBaselineRow obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "baseline-row" val

-- | Construct a t'GValueConstruct' with valid value for the “@baseline-row@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridLayoutBaselineRow :: (IsGridLayout o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGridLayoutBaselineRow val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "baseline-row" val

#if defined(ENABLE_OVERLOADING)
data GridLayoutBaselineRowPropertyInfo
instance AttrInfo GridLayoutBaselineRowPropertyInfo where
    type AttrAllowedOps GridLayoutBaselineRowPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridLayoutBaselineRowPropertyInfo = IsGridLayout
    type AttrSetTypeConstraint GridLayoutBaselineRowPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GridLayoutBaselineRowPropertyInfo = (~) Int32
    type AttrTransferType GridLayoutBaselineRowPropertyInfo = Int32
    type AttrGetType GridLayoutBaselineRowPropertyInfo = Int32
    type AttrLabel GridLayoutBaselineRowPropertyInfo = "baseline-row"
    type AttrOrigin GridLayoutBaselineRowPropertyInfo = GridLayout
    attrGet = getGridLayoutBaselineRow
    attrSet = setGridLayoutBaselineRow
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridLayoutBaselineRow
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.baselineRow"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#g:attr:baselineRow"
        })
#endif

-- VVV Prop "column-homogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@column-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridLayout #columnHomogeneous
-- @
getGridLayoutColumnHomogeneous :: (MonadIO m, IsGridLayout o) => o -> m Bool
getGridLayoutColumnHomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "column-homogeneous"

-- | Set the value of the “@column-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridLayout [ #columnHomogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridLayoutColumnHomogeneous :: (MonadIO m, IsGridLayout o) => o -> Bool -> m ()
setGridLayoutColumnHomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "column-homogeneous" val

-- | Construct a t'GValueConstruct' with valid value for the “@column-homogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridLayoutColumnHomogeneous :: (IsGridLayout o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGridLayoutColumnHomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "column-homogeneous" val

#if defined(ENABLE_OVERLOADING)
data GridLayoutColumnHomogeneousPropertyInfo
instance AttrInfo GridLayoutColumnHomogeneousPropertyInfo where
    type AttrAllowedOps GridLayoutColumnHomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridLayoutColumnHomogeneousPropertyInfo = IsGridLayout
    type AttrSetTypeConstraint GridLayoutColumnHomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GridLayoutColumnHomogeneousPropertyInfo = (~) Bool
    type AttrTransferType GridLayoutColumnHomogeneousPropertyInfo = Bool
    type AttrGetType GridLayoutColumnHomogeneousPropertyInfo = Bool
    type AttrLabel GridLayoutColumnHomogeneousPropertyInfo = "column-homogeneous"
    type AttrOrigin GridLayoutColumnHomogeneousPropertyInfo = GridLayout
    attrGet = getGridLayoutColumnHomogeneous
    attrSet = setGridLayoutColumnHomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridLayoutColumnHomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.columnHomogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#g:attr:columnHomogeneous"
        })
#endif

-- VVV Prop "column-spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@column-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridLayout #columnSpacing
-- @
getGridLayoutColumnSpacing :: (MonadIO m, IsGridLayout o) => o -> m Int32
getGridLayoutColumnSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "column-spacing"

-- | Set the value of the “@column-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridLayout [ #columnSpacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridLayoutColumnSpacing :: (MonadIO m, IsGridLayout o) => o -> Int32 -> m ()
setGridLayoutColumnSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "column-spacing" val

-- | Construct a t'GValueConstruct' with valid value for the “@column-spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridLayoutColumnSpacing :: (IsGridLayout o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGridLayoutColumnSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "column-spacing" val

#if defined(ENABLE_OVERLOADING)
data GridLayoutColumnSpacingPropertyInfo
instance AttrInfo GridLayoutColumnSpacingPropertyInfo where
    type AttrAllowedOps GridLayoutColumnSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridLayoutColumnSpacingPropertyInfo = IsGridLayout
    type AttrSetTypeConstraint GridLayoutColumnSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GridLayoutColumnSpacingPropertyInfo = (~) Int32
    type AttrTransferType GridLayoutColumnSpacingPropertyInfo = Int32
    type AttrGetType GridLayoutColumnSpacingPropertyInfo = Int32
    type AttrLabel GridLayoutColumnSpacingPropertyInfo = "column-spacing"
    type AttrOrigin GridLayoutColumnSpacingPropertyInfo = GridLayout
    attrGet = getGridLayoutColumnSpacing
    attrSet = setGridLayoutColumnSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridLayoutColumnSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.columnSpacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#g:attr:columnSpacing"
        })
#endif

-- VVV Prop "row-homogeneous"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@row-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridLayout #rowHomogeneous
-- @
getGridLayoutRowHomogeneous :: (MonadIO m, IsGridLayout o) => o -> m Bool
getGridLayoutRowHomogeneous obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "row-homogeneous"

-- | Set the value of the “@row-homogeneous@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridLayout [ #rowHomogeneous 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridLayoutRowHomogeneous :: (MonadIO m, IsGridLayout o) => o -> Bool -> m ()
setGridLayoutRowHomogeneous obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "row-homogeneous" val

-- | Construct a t'GValueConstruct' with valid value for the “@row-homogeneous@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridLayoutRowHomogeneous :: (IsGridLayout o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructGridLayoutRowHomogeneous val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "row-homogeneous" val

#if defined(ENABLE_OVERLOADING)
data GridLayoutRowHomogeneousPropertyInfo
instance AttrInfo GridLayoutRowHomogeneousPropertyInfo where
    type AttrAllowedOps GridLayoutRowHomogeneousPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridLayoutRowHomogeneousPropertyInfo = IsGridLayout
    type AttrSetTypeConstraint GridLayoutRowHomogeneousPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint GridLayoutRowHomogeneousPropertyInfo = (~) Bool
    type AttrTransferType GridLayoutRowHomogeneousPropertyInfo = Bool
    type AttrGetType GridLayoutRowHomogeneousPropertyInfo = Bool
    type AttrLabel GridLayoutRowHomogeneousPropertyInfo = "row-homogeneous"
    type AttrOrigin GridLayoutRowHomogeneousPropertyInfo = GridLayout
    attrGet = getGridLayoutRowHomogeneous
    attrSet = setGridLayoutRowHomogeneous
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridLayoutRowHomogeneous
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.rowHomogeneous"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#g:attr:rowHomogeneous"
        })
#endif

-- VVV Prop "row-spacing"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@row-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' gridLayout #rowSpacing
-- @
getGridLayoutRowSpacing :: (MonadIO m, IsGridLayout o) => o -> m Int32
getGridLayoutRowSpacing obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "row-spacing"

-- | Set the value of the “@row-spacing@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' gridLayout [ #rowSpacing 'Data.GI.Base.Attributes.:=' value ]
-- @
setGridLayoutRowSpacing :: (MonadIO m, IsGridLayout o) => o -> Int32 -> m ()
setGridLayoutRowSpacing obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "row-spacing" val

-- | Construct a t'GValueConstruct' with valid value for the “@row-spacing@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructGridLayoutRowSpacing :: (IsGridLayout o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructGridLayoutRowSpacing val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "row-spacing" val

#if defined(ENABLE_OVERLOADING)
data GridLayoutRowSpacingPropertyInfo
instance AttrInfo GridLayoutRowSpacingPropertyInfo where
    type AttrAllowedOps GridLayoutRowSpacingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint GridLayoutRowSpacingPropertyInfo = IsGridLayout
    type AttrSetTypeConstraint GridLayoutRowSpacingPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint GridLayoutRowSpacingPropertyInfo = (~) Int32
    type AttrTransferType GridLayoutRowSpacingPropertyInfo = Int32
    type AttrGetType GridLayoutRowSpacingPropertyInfo = Int32
    type AttrLabel GridLayoutRowSpacingPropertyInfo = "row-spacing"
    type AttrOrigin GridLayoutRowSpacingPropertyInfo = GridLayout
    attrGet = getGridLayoutRowSpacing
    attrSet = setGridLayoutRowSpacing
    attrTransfer _ v = do
        return v
    attrConstruct = constructGridLayoutRowSpacing
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.rowSpacing"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#g:attr:rowSpacing"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList GridLayout
type instance O.AttributeList GridLayout = GridLayoutAttributeList
type GridLayoutAttributeList = ('[ '("baselineRow", GridLayoutBaselineRowPropertyInfo), '("columnHomogeneous", GridLayoutColumnHomogeneousPropertyInfo), '("columnSpacing", GridLayoutColumnSpacingPropertyInfo), '("rowHomogeneous", GridLayoutRowHomogeneousPropertyInfo), '("rowSpacing", GridLayoutRowSpacingPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
gridLayoutBaselineRow :: AttrLabelProxy "baselineRow"
gridLayoutBaselineRow = AttrLabelProxy

gridLayoutColumnHomogeneous :: AttrLabelProxy "columnHomogeneous"
gridLayoutColumnHomogeneous = AttrLabelProxy

gridLayoutColumnSpacing :: AttrLabelProxy "columnSpacing"
gridLayoutColumnSpacing = AttrLabelProxy

gridLayoutRowHomogeneous :: AttrLabelProxy "rowHomogeneous"
gridLayoutRowHomogeneous = AttrLabelProxy

gridLayoutRowSpacing :: AttrLabelProxy "rowSpacing"
gridLayoutRowSpacing = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList GridLayout = GridLayoutSignalList
type GridLayoutSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method GridLayout::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "GridLayout" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_new" gtk_grid_layout_new :: 
    IO (Ptr GridLayout)

-- | Creates a new @GtkGridLayout@.
gridLayoutNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m GridLayout
    -- ^ __Returns:__ the newly created @GtkGridLayout@
gridLayoutNew  = liftIO $ do
    result <- gtk_grid_layout_new
    checkUnexpectedReturnNULL "gridLayoutNew" result
    result' <- (wrapObject GridLayout) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method GridLayout::get_baseline_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_get_baseline_row" gtk_grid_layout_get_baseline_row :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    IO Int32

-- | Retrieves the row set with 'GI.Gtk.Objects.GridLayout.gridLayoutSetBaselineRow'.
gridLayoutGetBaselineRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> m Int32
    -- ^ __Returns:__ the global baseline row
gridLayoutGetBaselineRow grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_layout_get_baseline_row grid'
    touchManagedPtr grid
    return result

#if defined(ENABLE_OVERLOADING)
data GridLayoutGetBaselineRowMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutGetBaselineRowMethodInfo a signature where
    overloadedMethod = gridLayoutGetBaselineRow

instance O.OverloadedMethodInfo GridLayoutGetBaselineRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutGetBaselineRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutGetBaselineRow"
        })


#endif

-- method GridLayout::get_column_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_get_column_homogeneous" gtk_grid_layout_get_column_homogeneous :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    IO CInt

-- | Checks whether all columns of /@grid@/ should have the same width.
gridLayoutGetColumnHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the columns are homogeneous, and 'P.False' otherwise
gridLayoutGetColumnHomogeneous grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_layout_get_column_homogeneous grid'
    let result' = (/= 0) result
    touchManagedPtr grid
    return result'

#if defined(ENABLE_OVERLOADING)
data GridLayoutGetColumnHomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutGetColumnHomogeneousMethodInfo a signature where
    overloadedMethod = gridLayoutGetColumnHomogeneous

instance O.OverloadedMethodInfo GridLayoutGetColumnHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutGetColumnHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutGetColumnHomogeneous"
        })


#endif

-- method GridLayout::get_column_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_get_column_spacing" gtk_grid_layout_get_column_spacing :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    IO Word32

-- | Retrieves the spacing set with 'GI.Gtk.Objects.GridLayout.gridLayoutSetColumnSpacing'.
gridLayoutGetColumnSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> m Word32
    -- ^ __Returns:__ the spacing between consecutive columns
gridLayoutGetColumnSpacing grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_layout_get_column_spacing grid'
    touchManagedPtr grid
    return result

#if defined(ENABLE_OVERLOADING)
data GridLayoutGetColumnSpacingMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutGetColumnSpacingMethodInfo a signature where
    overloadedMethod = gridLayoutGetColumnSpacing

instance O.OverloadedMethodInfo GridLayoutGetColumnSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutGetColumnSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutGetColumnSpacing"
        })


#endif

-- method GridLayout::get_row_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a row index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "BaselinePosition" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_get_row_baseline_position" gtk_grid_layout_get_row_baseline_position :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    Int32 ->                                -- row : TBasicType TInt
    IO CUInt

-- | Returns the baseline position of /@row@/.
-- 
-- If no value has been set with
-- 'GI.Gtk.Objects.GridLayout.gridLayoutSetRowBaselinePosition',
-- the default value of 'GI.Gtk.Enums.BaselinePositionCenter'
-- is returned.
gridLayoutGetRowBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Int32
    -- ^ /@row@/: a row index
    -> m Gtk.Enums.BaselinePosition
    -- ^ __Returns:__ the baseline position of /@row@/
gridLayoutGetRowBaselinePosition grid row = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_layout_get_row_baseline_position grid' row
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr grid
    return result'

#if defined(ENABLE_OVERLOADING)
data GridLayoutGetRowBaselinePositionMethodInfo
instance (signature ~ (Int32 -> m Gtk.Enums.BaselinePosition), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutGetRowBaselinePositionMethodInfo a signature where
    overloadedMethod = gridLayoutGetRowBaselinePosition

instance O.OverloadedMethodInfo GridLayoutGetRowBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutGetRowBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutGetRowBaselinePosition"
        })


#endif

-- method GridLayout::get_row_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_get_row_homogeneous" gtk_grid_layout_get_row_homogeneous :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    IO CInt

-- | Checks whether all rows of /@grid@/ should have the same height.
gridLayoutGetRowHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the rows are homogeneous, and 'P.False' otherwise
gridLayoutGetRowHomogeneous grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_layout_get_row_homogeneous grid'
    let result' = (/= 0) result
    touchManagedPtr grid
    return result'

#if defined(ENABLE_OVERLOADING)
data GridLayoutGetRowHomogeneousMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutGetRowHomogeneousMethodInfo a signature where
    overloadedMethod = gridLayoutGetRowHomogeneous

instance O.OverloadedMethodInfo GridLayoutGetRowHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutGetRowHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutGetRowHomogeneous"
        })


#endif

-- method GridLayout::get_row_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_get_row_spacing" gtk_grid_layout_get_row_spacing :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    IO Word32

-- | Retrieves the spacing set with 'GI.Gtk.Objects.GridLayout.gridLayoutSetRowSpacing'.
gridLayoutGetRowSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> m Word32
    -- ^ __Returns:__ the spacing between consecutive rows
gridLayoutGetRowSpacing grid = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    result <- gtk_grid_layout_get_row_spacing grid'
    touchManagedPtr grid
    return result

#if defined(ENABLE_OVERLOADING)
data GridLayoutGetRowSpacingMethodInfo
instance (signature ~ (m Word32), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutGetRowSpacingMethodInfo a signature where
    overloadedMethod = gridLayoutGetRowSpacing

instance O.OverloadedMethodInfo GridLayoutGetRowSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutGetRowSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutGetRowSpacing"
        })


#endif

-- method GridLayout::set_baseline_row
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the row index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_set_baseline_row" gtk_grid_layout_set_baseline_row :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    Int32 ->                                -- row : TBasicType TInt
    IO ()

-- | Sets which row defines the global baseline for the entire grid.
-- 
-- Each row in the grid can have its own local baseline, but only
-- one of those is global, meaning it will be the baseline in the
-- parent of the /@grid@/.
gridLayoutSetBaselineRow ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Int32
    -- ^ /@row@/: the row index
    -> m ()
gridLayoutSetBaselineRow grid row = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_layout_set_baseline_row grid' row
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridLayoutSetBaselineRowMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutSetBaselineRowMethodInfo a signature where
    overloadedMethod = gridLayoutSetBaselineRow

instance O.OverloadedMethodInfo GridLayoutSetBaselineRowMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutSetBaselineRow",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutSetBaselineRow"
        })


#endif

-- method GridLayout::set_column_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "homogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make columns homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_set_column_homogeneous" gtk_grid_layout_set_column_homogeneous :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    CInt ->                                 -- homogeneous : TBasicType TBoolean
    IO ()

-- | Sets whether all columns of /@grid@/ should have the same width.
gridLayoutSetColumnHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Bool
    -- ^ /@homogeneous@/: 'P.True' to make columns homogeneous
    -> m ()
gridLayoutSetColumnHomogeneous grid homogeneous = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    let homogeneous' = (P.fromIntegral . P.fromEnum) homogeneous
    gtk_grid_layout_set_column_homogeneous grid' homogeneous'
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridLayoutSetColumnHomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutSetColumnHomogeneousMethodInfo a signature where
    overloadedMethod = gridLayoutSetColumnHomogeneous

instance O.OverloadedMethodInfo GridLayoutSetColumnHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutSetColumnHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutSetColumnHomogeneous"
        })


#endif

-- method GridLayout::set_column_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spacing"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the amount of space between columns, in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_set_column_spacing" gtk_grid_layout_set_column_spacing :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    Word32 ->                               -- spacing : TBasicType TUInt
    IO ()

-- | Sets the amount of space to insert between consecutive columns.
gridLayoutSetColumnSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Word32
    -- ^ /@spacing@/: the amount of space between columns, in pixels
    -> m ()
gridLayoutSetColumnSpacing grid spacing = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_layout_set_column_spacing grid' spacing
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridLayoutSetColumnSpacingMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutSetColumnSpacingMethodInfo a signature where
    overloadedMethod = gridLayoutSetColumnSpacing

instance O.OverloadedMethodInfo GridLayoutSetColumnSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutSetColumnSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutSetColumnSpacing"
        })


#endif

-- method GridLayout::set_row_baseline_position
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "row"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a row index" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "pos"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "BaselinePosition" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkBaselinePosition`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_set_row_baseline_position" gtk_grid_layout_set_row_baseline_position :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    Int32 ->                                -- row : TBasicType TInt
    CUInt ->                                -- pos : TInterface (Name {namespace = "Gtk", name = "BaselinePosition"})
    IO ()

-- | Sets how the baseline should be positioned on /@row@/ of the
-- grid, in case that row is assigned more space than is requested.
gridLayoutSetRowBaselinePosition ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Int32
    -- ^ /@row@/: a row index
    -> Gtk.Enums.BaselinePosition
    -- ^ /@pos@/: a @GtkBaselinePosition@
    -> m ()
gridLayoutSetRowBaselinePosition grid row pos = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    let pos' = (fromIntegral . fromEnum) pos
    gtk_grid_layout_set_row_baseline_position grid' row pos'
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridLayoutSetRowBaselinePositionMethodInfo
instance (signature ~ (Int32 -> Gtk.Enums.BaselinePosition -> m ()), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutSetRowBaselinePositionMethodInfo a signature where
    overloadedMethod = gridLayoutSetRowBaselinePosition

instance O.OverloadedMethodInfo GridLayoutSetRowBaselinePositionMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutSetRowBaselinePosition",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutSetRowBaselinePosition"
        })


#endif

-- method GridLayout::set_row_homogeneous
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "homogeneous"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to make rows homogeneous"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_set_row_homogeneous" gtk_grid_layout_set_row_homogeneous :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    CInt ->                                 -- homogeneous : TBasicType TBoolean
    IO ()

-- | Sets whether all rows of /@grid@/ should have the same height.
gridLayoutSetRowHomogeneous ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Bool
    -- ^ /@homogeneous@/: 'P.True' to make rows homogeneous
    -> m ()
gridLayoutSetRowHomogeneous grid homogeneous = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    let homogeneous' = (P.fromIntegral . P.fromEnum) homogeneous
    gtk_grid_layout_set_row_homogeneous grid' homogeneous'
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridLayoutSetRowHomogeneousMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutSetRowHomogeneousMethodInfo a signature where
    overloadedMethod = gridLayoutSetRowHomogeneous

instance O.OverloadedMethodInfo GridLayoutSetRowHomogeneousMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutSetRowHomogeneous",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutSetRowHomogeneous"
        })


#endif

-- method GridLayout::set_row_spacing
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "grid"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "GridLayout" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkGridLayout`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "spacing"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the amount of space between rows, in pixels"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_grid_layout_set_row_spacing" gtk_grid_layout_set_row_spacing :: 
    Ptr GridLayout ->                       -- grid : TInterface (Name {namespace = "Gtk", name = "GridLayout"})
    Word32 ->                               -- spacing : TBasicType TUInt
    IO ()

-- | Sets the amount of space to insert between consecutive rows.
gridLayoutSetRowSpacing ::
    (B.CallStack.HasCallStack, MonadIO m, IsGridLayout a) =>
    a
    -- ^ /@grid@/: a @GtkGridLayout@
    -> Word32
    -- ^ /@spacing@/: the amount of space between rows, in pixels
    -> m ()
gridLayoutSetRowSpacing grid spacing = liftIO $ do
    grid' <- unsafeManagedPtrCastPtr grid
    gtk_grid_layout_set_row_spacing grid' spacing
    touchManagedPtr grid
    return ()

#if defined(ENABLE_OVERLOADING)
data GridLayoutSetRowSpacingMethodInfo
instance (signature ~ (Word32 -> m ()), MonadIO m, IsGridLayout a) => O.OverloadedMethod GridLayoutSetRowSpacingMethodInfo a signature where
    overloadedMethod = gridLayoutSetRowSpacing

instance O.OverloadedMethodInfo GridLayoutSetRowSpacingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.GridLayout.gridLayoutSetRowSpacing",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-GridLayout.html#v:gridLayoutSetRowSpacing"
        })


#endif


