

-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Functions
    ( 

 -- * Methods


-- ** valueDupRenderNode #method:valueDupRenderNode#

    valueDupRenderNode                      ,


-- ** valueGetRenderNode #method:valueGetRenderNode#

    valueGetRenderNode                      ,


-- ** valueSetRenderNode #method:valueSetRenderNode#

    valueSetRenderNode                      ,


-- ** valueTakeRenderNode #method:valueTakeRenderNode#

    valueTakeRenderNode                     ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#else
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode

#endif

-- function value_take_render_node
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [struct@GObject.Value] initialized with type `GSK_TYPE_RENDER_NODE`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a render node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_value_take_render_node" gsk_value_take_render_node :: 
    Ptr GValue ->                           -- value : TGValue
    Ptr Gsk.RenderNode.RenderNode ->        -- node : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    IO ()

-- | Stores the given render node inside a @GValue@.
-- 
-- This function transfers the ownership of the
-- render node to the @GValue@.
-- 
-- /Since: 4.6/
valueTakeRenderNode ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' initialized with type @GSK_TYPE_RENDER_NODE@
    -> Maybe (a)
    -- ^ /@node@/: a render node
    -> m ()
valueTakeRenderNode value node = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    maybeNode <- case node of
        Nothing -> return FP.nullPtr
        Just jNode -> do
            jNode' <- B.ManagedPtr.disownManagedPtr jNode
            return jNode'
    gsk_value_take_render_node value' maybeNode
    touchManagedPtr value
    whenJust node touchManagedPtr
    return ()


-- function value_set_render_node
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [struct@GObject.Value] initialized with type `GSK_TYPE_RENDER_NODE`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "RenderNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a render node" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gsk_value_set_render_node" gsk_value_set_render_node :: 
    Ptr GValue ->                           -- value : TGValue
    Ptr Gsk.RenderNode.RenderNode ->        -- node : TInterface (Name {namespace = "Gsk", name = "RenderNode"})
    IO ()

-- | Stores the given render node inside a @GValue@.
-- 
-- The t'GI.GObject.Structs.Value.Value' will acquire a reference
-- to the render node.
-- 
-- /Since: 4.6/
valueSetRenderNode ::
    (B.CallStack.HasCallStack, MonadIO m, Gsk.RenderNode.IsRenderNode a) =>
    GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' initialized with type @GSK_TYPE_RENDER_NODE@
    -> a
    -- ^ /@node@/: a render node
    -> m ()
valueSetRenderNode value node = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    node' <- unsafeManagedPtrCastPtr node
    gsk_value_set_render_node value' node'
    touchManagedPtr value
    touchManagedPtr node
    return ()


-- function value_get_render_node
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "a `GValue` initialized with type `GSK_TYPE_RENDER_NODE`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_value_get_render_node" gsk_value_get_render_node :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the render node stored inside a @GValue@.
-- 
-- /Since: 4.6/
valueGetRenderNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a @GValue@ initialized with type @GSK_TYPE_RENDER_NODE@
    -> m (Maybe Gsk.RenderNode.RenderNode)
    -- ^ __Returns:__ the render node
valueGetRenderNode value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gsk_value_get_render_node value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newPtr Gsk.RenderNode.RenderNode) result'
        return result''
    touchManagedPtr value
    return maybeResult


-- function value_dup_render_node
-- Args: [ Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a [struct@GObject.Value] initialized with type `GSK_TYPE_RENDER_NODE`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gsk" , name = "RenderNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_value_dup_render_node" gsk_value_dup_render_node :: 
    Ptr GValue ->                           -- value : TGValue
    IO (Ptr Gsk.RenderNode.RenderNode)

-- | Retrieves the render node stored inside a @GValue@,
-- and acquires a reference to it.
-- 
-- /Since: 4.6/
valueDupRenderNode ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    GValue
    -- ^ /@value@/: a t'GI.GObject.Structs.Value.Value' initialized with type @GSK_TYPE_RENDER_NODE@
    -> m (Maybe Gsk.RenderNode.RenderNode)
    -- ^ __Returns:__ the render node
valueDupRenderNode value = liftIO $ do
    value' <- unsafeManagedPtrGetPtr value
    result <- gsk_value_dup_render_node value'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapPtr Gsk.RenderNode.RenderNode) result'
        return result''
    touchManagedPtr value
    return maybeResult



