/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, qtgui, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_qtgui_edit_box_msg = R"doc(Create a QT Edit Box widget where the value is posted as a message.

This block creates a QT Edit Box widget that manages data through message passing interfaces. The 'msg' output port produces messages based on the text in the edit box and the data type set by the  argument (see gr::qtgui::data_type_t). The data types are checked, and WARN log messages are produced when the data is in the wrong format. Not all errors are explicitly checked for, only that conversions happen correctly. Failures are either produces as log messages or the action is simply silently dropped.


The value of the edit boxes can be programmatically updated through the 'val' input message port. It is also checked for the correct data type.


The  argument to the constructor determines if the edit box handles a key:value pair. If set to True, two edit boxes are created with the left for the key and right for the value. The key is always assumed to be a string and the value is restricted by the data type setting as above.


The block can take a default value. Because the block is capable of handling multiple different data types, we enter the default value as a string in the same way we expect the user to enter it into the Value edit box of the widget. We convert this default exactly the same way we convert the user-entered text in the edit box. See the next paragraph for an explanation for how to handle complex numbers.


Complex numbers are currently handled a bit differently than expected. Because we use the std iostream for complex, complex numbers MUST be in the form \"(a,b)\" to represent \"a + jb\". Note that you cannot even have a space after the comma, so \"(1.23,10.56)\" is correct while \"(1.23, 10.56)\" will not parse.


The 'static' mode prevents the user from changing the data type or the key used in the widget. If also in 'pair' mode, the key is not displayed and so must be set in the constructor. It is an error if using static and pair modes with no default key set.


Message Ports:

Constructor Specific Documentation:

Constructs the Edit box block.

Args:
    type : the data type of data in the value box.
    value : the default value of the message. This is entered as a string regardless of the type and converted internally  much like how the block extracts the value from the edit box and converts it.
    label : a label to identify the box on screen.
    is_pair : if we are using a key:value pair.
    is_static : sets the key edit box as a static text box (cannot be edited live).
    key : Set the key used in a key:value pair message.
    parent : a QWidget parent in the QT app.)doc";


static const char* __doc_gr_qtgui_edit_box_msg_edit_box_msg_0 = R"doc()doc";


static const char* __doc_gr_qtgui_edit_box_msg_edit_box_msg_1 = R"doc()doc";


static const char* __doc_gr_qtgui_edit_box_msg_make = R"doc(Create a QT Edit Box widget where the value is posted as a message.

This block creates a QT Edit Box widget that manages data through message passing interfaces. The 'msg' output port produces messages based on the text in the edit box and the data type set by the  argument (see gr::qtgui::data_type_t). The data types are checked, and WARN log messages are produced when the data is in the wrong format. Not all errors are explicitly checked for, only that conversions happen correctly. Failures are either produces as log messages or the action is simply silently dropped.


The value of the edit boxes can be programmatically updated through the 'val' input message port. It is also checked for the correct data type.


The  argument to the constructor determines if the edit box handles a key:value pair. If set to True, two edit boxes are created with the left for the key and right for the value. The key is always assumed to be a string and the value is restricted by the data type setting as above.


The block can take a default value. Because the block is capable of handling multiple different data types, we enter the default value as a string in the same way we expect the user to enter it into the Value edit box of the widget. We convert this default exactly the same way we convert the user-entered text in the edit box. See the next paragraph for an explanation for how to handle complex numbers.


Complex numbers are currently handled a bit differently than expected. Because we use the std iostream for complex, complex numbers MUST be in the form \"(a,b)\" to represent \"a + jb\". Note that you cannot even have a space after the comma, so \"(1.23,10.56)\" is correct while \"(1.23, 10.56)\" will not parse.


The 'static' mode prevents the user from changing the data type or the key used in the widget. If also in 'pair' mode, the key is not displayed and so must be set in the constructor. It is an error if using static and pair modes with no default key set.


Message Ports:

Constructor Specific Documentation:

Constructs the Edit box block.

Args:
    type : the data type of data in the value box.
    value : the default value of the message. This is entered as a string regardless of the type and converted internally  much like how the block extracts the value from the edit box and converts it.
    label : a label to identify the box on screen.
    is_pair : if we are using a key:value pair.
    is_static : sets the key edit box as a static text box (cannot be edited live).
    key : Set the key used in a key:value pair message.
    parent : a QWidget parent in the QT app.)doc";


static const char* __doc_gr_qtgui_edit_box_msg_exec_ = R"doc()doc";


static const char* __doc_gr_qtgui_edit_box_msg_qwidget = R"doc()doc";
