/* contacts-import-dialog.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from contacts-import-dialog.vala, do not modify */

/*
 * Copyright (C) 2023 Niels De Graef <nielsdegraef@gmail.com>
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#include <adwaita.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <gtk/gtk.h>
#include "contacts.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include "contactscore.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define CONTACTS_TYPE_IMPORT_DIALOG (contacts_import_dialog_get_type ())
#define CONTACTS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialog))
#define CONTACTS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialogClass))
#define CONTACTS_IS_IMPORT_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONTACTS_TYPE_IMPORT_DIALOG))
#define CONTACTS_IS_IMPORT_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONTACTS_TYPE_IMPORT_DIALOG))
#define CONTACTS_IMPORT_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialogClass))

typedef struct _ContactsImportDialog ContactsImportDialog;
typedef struct _ContactsImportDialogClass ContactsImportDialogClass;
typedef struct _ContactsImportDialogPrivate ContactsImportDialogPrivate;
enum  {
	CONTACTS_IMPORT_DIALOG_0_PROPERTY,
	CONTACTS_IMPORT_DIALOG_FILES_PROPERTY,
	CONTACTS_IMPORT_DIALOG_CONTACTS_STORE_PROPERTY,
	CONTACTS_IMPORT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* contacts_import_dialog_properties[CONTACTS_IMPORT_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ContactsImportDialogHandleFileData ContactsImportDialogHandleFileData;
typedef struct _ContactsImportDialogImportData ContactsImportDialogImportData;

struct _ContactsImportDialog {
	AdwDialog parent_instance;
	ContactsImportDialogPrivate * priv;
};

struct _ContactsImportDialogClass {
	AdwDialogClass parent_class;
};

struct _ContactsImportDialogPrivate {
	AdwPreferencesPage* page;
	GListModel* _files;
	GListStore* parsed_results;
	GtkFlattenListModel* parsed_list;
	ContactsStore* _contacts_store;
};

struct _ContactsImportDialogHandleFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImportDialog* self;
	GFile* file;
	gboolean show_header;
	AdwPreferencesGroup* group;
	AdwPreferencesGroup* _tmp0_;
	AdwPreferencesPage* _tmp1_;
	AdwPreferencesGroup* _tmp2_;
	GFileInfo* file_info;
	const gchar* file_name;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	GFileInfo* _tmp5_;
	GFileInfo* _tmp6_;
	const gchar* _tmp7_;
	AdwPreferencesGroup* _tmp8_;
	AdwPreferencesGroup* _tmp9_;
	const gchar* _tmp10_;
	AdwSpinner* spinner;
	AdwSpinner* _tmp11_;
	AdwPreferencesGroup* _tmp12_;
	AdwSpinner* _tmp13_;
	GListModel* parsed;
	guint n_parsed;
	ContactsIoParseOperation* parse_op;
	ContactsIoParseOperation* _tmp14_;
	ContactsIoParseOperation* _tmp15_;
	ContactsIoParseOperation* _tmp16_;
	GListModel* _tmp17_;
	GListModel* _tmp18_;
	GListModel* _tmp19_;
	GListModel* _tmp20_;
	GListStore* _tmp21_;
	GListModel* _tmp22_;
	AdwPreferencesGroup* _tmp23_;
	AdwSpinner* _tmp24_;
	GError* err;
	GError* _tmp25_;
	const gchar* _tmp26_;
	AdwPreferencesGroup* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	AdwPreferencesGroup* _tmp31_;
	AdwSpinner* _tmp32_;
	AdwPreferencesGroup* _tmp33_;
	AdwPreferencesGroup* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	guint i;
	gboolean _tmp37_;
	guint _tmp38_;
	ContactsContact* contact;
	GListModel* _tmp39_;
	GObject* _tmp40_;
	AdwActionRow* row;
	AdwActionRow* _tmp41_;
	AdwActionRow* _tmp42_;
	ContactsContact* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	AdwPreferencesGroup* _tmp47_;
	AdwActionRow* _tmp48_;
	GError* _inner_error0_;
};

struct _ContactsImportDialogImportData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ContactsImportDialog* self;
	ContactsImportOperation* import_op;
	ContactsStore* _tmp0_;
	GtkFlattenListModel* _tmp1_;
	ContactsImportOperation* _tmp2_;
	GError* err;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError* _inner_error0_;
};

static gint ContactsImportDialog_private_offset;
static gpointer contacts_import_dialog_parent_class = NULL;

VALA_EXTERN GType contacts_import_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContactsImportDialog, g_object_unref)
VALA_EXTERN ContactsImportDialog* contacts_import_dialog_new (ContactsStore* contacts_store,
                                                  GListModel* files);
VALA_EXTERN ContactsImportDialog* contacts_import_dialog_construct (GType object_type,
                                                        ContactsStore* contacts_store,
                                                        GListModel* files);
static void contacts_import_dialog_handle_file_data_free (gpointer _data);
static void contacts_import_dialog_handle_file (ContactsImportDialog* self,
                                         GFile* file,
                                         gboolean show_header,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_);
static void contacts_import_dialog_handle_file_finish (ContactsImportDialog* self,
                                                GAsyncResult* _res_);
static gboolean contacts_import_dialog_handle_file_co (ContactsImportDialogHandleFileData* _data_);
static void contacts_import_dialog_set_error_label (ContactsImportDialog* self,
                                             AdwPreferencesGroup* group,
                                             const gchar* _error_);
static void contacts_import_dialog_handle_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_);
static void contacts_import_dialog_on_parsed_list_items_changed (ContactsImportDialog* self,
                                                          GListModel* parsed_list,
                                                          guint position,
                                                          guint removed,
                                                          guint added);
static void contacts_import_dialog_action_import (ContactsImportDialog* self,
                                           const gchar* action_name,
                                           GVariant* param);
static void contacts_import_dialog_import (ContactsImportDialog* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static void contacts_import_dialog_import_finish (ContactsImportDialog* self,
                                           GAsyncResult* _res_);
static void __lambda61_ (ContactsImportDialog* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda61__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void contacts_import_dialog_import_data_free (gpointer _data);
static gboolean contacts_import_dialog_import_co (ContactsImportDialogImportData* _data_);
VALA_EXTERN ContactsStore* contacts_import_dialog_get_contacts_store (ContactsImportDialog* self);
static void contacts_import_dialog_import_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
VALA_EXTERN GListModel* contacts_import_dialog_get_files (ContactsImportDialog* self);
VALA_EXTERN void contacts_import_dialog_set_files (ContactsImportDialog* self,
                                       GListModel* value);
VALA_EXTERN void contacts_import_dialog_set_contacts_store (ContactsImportDialog* self,
                                                ContactsStore* value);
static GObject * contacts_import_dialog_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _contacts_import_dialog_on_parsed_list_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                      guint position,
                                                                                      guint removed,
                                                                                      guint added,
                                                                                      gpointer self);
static void contacts_import_dialog_finalize (GObject * obj);
static GType contacts_import_dialog_get_type_once (void);
static void _vala_contacts_import_dialog_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_contacts_import_dialog_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);

static inline gpointer
contacts_import_dialog_get_instance_private (ContactsImportDialog* self)
{
	return G_STRUCT_MEMBER_P (self, ContactsImportDialog_private_offset);
}

ContactsImportDialog*
contacts_import_dialog_construct (GType object_type,
                                  ContactsStore* contacts_store,
                                  GListModel* files)
{
	ContactsImportDialog * self = NULL;
	g_return_val_if_fail (contacts_store != NULL, NULL);
	g_return_val_if_fail (files != NULL, NULL);
	self = (ContactsImportDialog*) g_object_new (object_type, "contacts-store", contacts_store, "files", files, NULL);
	return self;
}

ContactsImportDialog*
contacts_import_dialog_new (ContactsStore* contacts_store,
                            GListModel* files)
{
	return contacts_import_dialog_construct (CONTACTS_TYPE_IMPORT_DIALOG, contacts_store, files);
}

static void
contacts_import_dialog_handle_file_data_free (gpointer _data)
{
	ContactsImportDialogHandleFileData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImportDialogHandleFileData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
contacts_import_dialog_handle_file (ContactsImportDialog* self,
                                    GFile* file,
                                    gboolean show_header,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_)
{
	ContactsImportDialogHandleFileData* _data_;
	ContactsImportDialog* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (ContactsImportDialogHandleFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_import_dialog_handle_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp1_;
	_data_->show_header = show_header;
	contacts_import_dialog_handle_file_co (_data_);
}

static void
contacts_import_dialog_handle_file_finish (ContactsImportDialog* self,
                                           GAsyncResult* _res_)
{
	ContactsImportDialogHandleFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_import_dialog_handle_file_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_)
{
	ContactsImportDialogHandleFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_import_dialog_handle_file_co (_data_);
}

static gboolean
contacts_import_dialog_handle_file_co (ContactsImportDialogHandleFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = (AdwPreferencesGroup*) adw_preferences_group_new ();
	g_object_ref_sink (_data_->_tmp0_);
	_data_->group = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->page;
	_data_->_tmp2_ = _data_->group;
	adw_preferences_page_add (_data_->_tmp1_, _data_->_tmp2_);
	{
		_data_->_tmp4_ = g_file_query_info (_data_->file, G_FILE_ATTRIBUTE_STANDARD_DISPLAY_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_data_->_inner_error0_);
		_data_->_tmp3_ = _data_->_tmp4_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp5_ = _data_->_tmp3_;
		_data_->_tmp3_ = NULL;
		_g_object_unref0 (_data_->file_info);
		_data_->file_info = _data_->_tmp5_;
		_data_->_tmp6_ = _data_->file_info;
		_data_->_tmp7_ = g_file_info_get_display_name (_data_->_tmp6_);
		_data_->file_name = _data_->_tmp7_;
		_g_object_unref0 (_data_->_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->_tmp8_ = _data_->group;
		contacts_import_dialog_set_error_label (_data_->self, _data_->_tmp8_, _ ("An error occurred reading the selected file"));
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->group);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->show_header) {
		_data_->_tmp9_ = _data_->group;
		_data_->_tmp10_ = _data_->file_name;
		adw_preferences_group_set_title (_data_->_tmp9_, _data_->_tmp10_);
	}
	_data_->_tmp11_ = (AdwSpinner*) adw_spinner_new ();
	g_object_ref_sink (_data_->_tmp11_);
	_data_->spinner = _data_->_tmp11_;
	_data_->_tmp12_ = _data_->group;
	_data_->_tmp13_ = _data_->spinner;
	adw_preferences_group_add (_data_->_tmp12_, (GtkWidget*) _data_->_tmp13_);
	_data_->n_parsed = (guint) 0;
	{
		_data_->_tmp14_ = contacts_io_parse_operation_new (_data_->file);
		_data_->parse_op = _data_->_tmp14_;
		_data_->_tmp15_ = _data_->parse_op;
		_data_->_state_ = 1;
		contacts_operation_execute ((ContactsOperation*) _data_->_tmp15_, contacts_import_dialog_handle_file_ready, _data_);
		return FALSE;
		_state_1:
		contacts_operation_execute_finish ((ContactsOperation*) _data_->_tmp15_, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->parse_op);
			goto __catch1_g_error;
		}
		g_debug ("contacts-import-dialog.vala:75: Successfully parsed a contact");
		_data_->_tmp16_ = _data_->parse_op;
		_data_->_tmp17_ = contacts_io_parse_operation_get_parsed (_data_->_tmp16_);
		_data_->_tmp18_ = _data_->_tmp17_;
		_data_->_tmp19_ = _g_object_ref0 (_data_->_tmp18_);
		_g_object_unref0 (_data_->parsed);
		_data_->parsed = _data_->_tmp19_;
		_data_->_tmp20_ = _data_->parsed;
		_data_->n_parsed = g_list_model_get_n_items (_data_->_tmp20_);
		_data_->_tmp21_ = _data_->self->priv->parsed_results;
		_data_->_tmp22_ = _data_->parsed;
		g_list_store_append (_data_->_tmp21_, (GObject*) _data_->_tmp22_);
		_data_->_tmp23_ = _data_->group;
		_data_->_tmp24_ = _data_->spinner;
		adw_preferences_group_remove (_data_->_tmp23_, (GtkWidget*) _data_->_tmp24_);
		_g_object_unref0 (_data_->parse_op);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp25_ = _data_->err;
		_data_->_tmp26_ = _data_->_tmp25_->message;
		g_warning ("contacts-import-dialog.vala:81: Couldn't parse file: %s", _data_->_tmp26_);
		_data_->_tmp27_ = _data_->group;
		_data_->_tmp28_ = _data_->file_name;
		_data_->_tmp29_ = g_strdup_printf ("An error occurred reading the file '%s'", _data_->_tmp28_);
		_data_->_tmp30_ = _data_->_tmp29_;
		contacts_import_dialog_set_error_label (_data_->self, _data_->_tmp27_, _ (_data_->_tmp30_));
		_g_free0 (_data_->_tmp30_);
		_data_->_tmp31_ = _data_->group;
		_data_->_tmp32_ = _data_->spinner;
		adw_preferences_group_remove (_data_->_tmp31_, (GtkWidget*) _data_->_tmp32_);
		_g_error_free0 (_data_->err);
		_g_object_unref0 (_data_->parsed);
		_g_object_unref0 (_data_->spinner);
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->group);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->parsed);
		_g_object_unref0 (_data_->spinner);
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->group);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->n_parsed == ((guint) 0)) {
		_data_->_tmp33_ = _data_->group;
		contacts_import_dialog_set_error_label (_data_->self, _data_->_tmp33_, _ ("The imported file does not seem to contain any contacts"));
		_g_object_unref0 (_data_->parsed);
		_g_object_unref0 (_data_->spinner);
		_g_object_unref0 (_data_->file_info);
		_g_object_unref0 (_data_->group);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->show_header) {
		_data_->_tmp34_ = _data_->group;
		_data_->_tmp35_ = g_strdup_printf (ngettext ("Found %u contact", "Found %u contacts", (gulong) _data_->n_parsed), _data_->n_parsed);
		_data_->_tmp36_ = _data_->_tmp35_;
		adw_preferences_group_set_description (_data_->_tmp34_, _data_->_tmp36_);
		_g_free0 (_data_->_tmp36_);
	}
	{
		_data_->i = (guint) 0;
		{
			_data_->_tmp37_ = TRUE;
			while (TRUE) {
				if (!_data_->_tmp37_) {
					_data_->_tmp38_ = _data_->i;
					_data_->i = _data_->_tmp38_ + 1;
				}
				_data_->_tmp37_ = FALSE;
				if (!(_data_->i < _data_->n_parsed)) {
					break;
				}
				_data_->_tmp39_ = _data_->parsed;
				_data_->_tmp40_ = g_list_model_get_item (_data_->_tmp39_, _data_->i);
				_data_->contact = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp40_, CONTACTS_TYPE_CONTACT, ContactsContact);
				_data_->_tmp41_ = (AdwActionRow*) adw_action_row_new ();
				g_object_ref_sink (_data_->_tmp41_);
				_data_->row = _data_->_tmp41_;
				_data_->_tmp42_ = _data_->row;
				_data_->_tmp43_ = _data_->contact;
				_data_->_tmp44_ = contacts_contact_get_display_name (_data_->_tmp43_);
				_data_->_tmp45_ = _data_->_tmp44_;
				_data_->_tmp46_ = _data_->_tmp45_;
				adw_preferences_row_set_title ((AdwPreferencesRow*) _data_->_tmp42_, _data_->_tmp46_);
				_g_free0 (_data_->_tmp46_);
				_data_->_tmp47_ = _data_->group;
				_data_->_tmp48_ = _data_->row;
				adw_preferences_group_add (_data_->_tmp47_, (GtkWidget*) _data_->_tmp48_);
				_g_object_unref0 (_data_->row);
				_g_object_unref0 (_data_->contact);
			}
		}
	}
	_g_object_unref0 (_data_->parsed);
	_g_object_unref0 (_data_->spinner);
	_g_object_unref0 (_data_->file_info);
	_g_object_unref0 (_data_->group);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
contacts_import_dialog_set_error_label (ContactsImportDialog* self,
                                        AdwPreferencesGroup* group,
                                        const gchar* _error_)
{
	GtkLabel* label = NULL;
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	g_return_if_fail (_error_ != NULL);
	_tmp0_ = (GtkLabel*) gtk_label_new (_error_);
	g_object_ref_sink (_tmp0_);
	label = _tmp0_;
	gtk_widget_add_css_class ((GtkWidget*) label, "error");
	adw_preferences_group_add (group, (GtkWidget*) label);
	_g_object_unref0 (label);
}

static void
contacts_import_dialog_on_parsed_list_items_changed (ContactsImportDialog* self,
                                                     GListModel* parsed_list,
                                                     guint position,
                                                     guint removed,
                                                     guint added)
{
	guint n_contacts = 0U;
	GtkFlattenListModel* _tmp0_;
	AdwPreferencesPage* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (parsed_list != NULL);
	_tmp0_ = self->priv->parsed_list;
	n_contacts = g_list_model_get_n_items ((GListModel*) _tmp0_);
	gtk_widget_action_set_enabled ((GtkWidget*) self, "import", n_contacts > ((guint) 0));
	if (n_contacts == ((guint) 0)) {
		AdwPreferencesPage* _tmp1_;
		_tmp1_ = self->priv->page;
		adw_preferences_page_set_description (_tmp1_, _ ("Can't import: no contacts found"));
		return;
	}
	_tmp2_ = self->priv->page;
	_tmp3_ = g_strdup_printf (ngettext ("By continuing, you will import %u contact", "By continuing, you will import %u contacts", (gulong) n_contacts), n_contacts);
	_tmp4_ = _tmp3_;
	adw_preferences_page_set_description (_tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
}

static void
__lambda61_ (ContactsImportDialog* self,
             GObject* obj,
             GAsyncResult* res)
{
	g_return_if_fail (res != NULL);
	contacts_import_dialog_import_finish (self, res);
	adw_dialog_close ((AdwDialog*) self);
}

static void
___lambda61__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda61_ ((ContactsImportDialog*) self, source_object, res);
	g_object_unref (self);
}

static void
contacts_import_dialog_action_import (ContactsImportDialog* self,
                                      const gchar* action_name,
                                      GVariant* param)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (action_name != NULL);
	contacts_import_dialog_import (self, ___lambda61__gasync_ready_callback, g_object_ref (self));
}

static void
contacts_import_dialog_import_data_free (gpointer _data)
{
	ContactsImportDialogImportData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ContactsImportDialogImportData, _data_);
}

static void
contacts_import_dialog_import (ContactsImportDialog* self,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	ContactsImportDialogImportData* _data_;
	ContactsImportDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ContactsImportDialogImportData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, contacts_import_dialog_import_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	contacts_import_dialog_import_co (_data_);
}

static void
contacts_import_dialog_import_finish (ContactsImportDialog* self,
                                      GAsyncResult* _res_)
{
	ContactsImportDialogImportData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static void
contacts_import_dialog_import_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	ContactsImportDialogImportData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	contacts_import_dialog_import_co (_data_);
}

static gboolean
contacts_import_dialog_import_co (ContactsImportDialogImportData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_contacts_store;
		_data_->_tmp1_ = _data_->self->priv->parsed_list;
		_data_->_tmp2_ = contacts_import_operation_new (_data_->_tmp0_, (GListModel*) _data_->_tmp1_);
		_data_->import_op = _data_->_tmp2_;
		_data_->_state_ = 1;
		contacts_operation_execute ((ContactsOperation*) _data_->import_op, contacts_import_dialog_import_ready, _data_);
		return FALSE;
		_state_1:
		contacts_operation_execute_finish ((ContactsOperation*) _data_->import_op, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			_g_object_unref0 (_data_->import_op);
			goto __catch0_g_error;
		}
		g_debug ("contacts-import-dialog.vala:147: Successfully imported contacts");
		_g_object_unref0 (_data_->import_op);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->err = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = _data_->err;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("contacts-import-dialog.vala:149: Couldn't import contacts: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->err);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

GListModel*
contacts_import_dialog_get_files (ContactsImportDialog* self)
{
	GListModel* result;
	GListModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_files;
	result = _tmp0_;
	return result;
}

void
contacts_import_dialog_set_files (ContactsImportDialog* self,
                                  GListModel* value)
{
	GListModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_import_dialog_get_files (self);
	if (old_value != value) {
		GListModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_files);
		self->priv->_files = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_import_dialog_properties[CONTACTS_IMPORT_DIALOG_FILES_PROPERTY]);
	}
}

ContactsStore*
contacts_import_dialog_get_contacts_store (ContactsImportDialog* self)
{
	ContactsStore* result;
	ContactsStore* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_contacts_store;
	result = _tmp0_;
	return result;
}

void
contacts_import_dialog_set_contacts_store (ContactsImportDialog* self,
                                           ContactsStore* value)
{
	ContactsStore* old_value;
	g_return_if_fail (self != NULL);
	old_value = contacts_import_dialog_get_contacts_store (self);
	if (old_value != value) {
		ContactsStore* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_contacts_store);
		self->priv->_contacts_store = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, contacts_import_dialog_properties[CONTACTS_IMPORT_DIALOG_CONTACTS_STORE_PROPERTY]);
	}
}

static void
_contacts_import_dialog_on_parsed_list_items_changed_g_list_model_items_changed (GListModel* _sender,
                                                                                 guint position,
                                                                                 guint removed,
                                                                                 guint added,
                                                                                 gpointer self)
{
	contacts_import_dialog_on_parsed_list_items_changed ((ContactsImportDialog*) self, _sender, position, removed, added);
}

static GObject *
contacts_import_dialog_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ContactsImportDialog * self;
	GListStore* _tmp0_;
	GListStore* _tmp1_;
	GListModel* _tmp2_;
	GtkFlattenListModel* _tmp3_;
	GtkFlattenListModel* _tmp4_;
	GtkFlattenListModel* _tmp5_;
	guint n_files = 0U;
	GListModel* _tmp6_;
	parent_class = G_OBJECT_CLASS (contacts_import_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialog);
	_tmp0_ = g_list_store_new (g_list_model_get_type ());
	_g_object_unref0 (self->priv->parsed_results);
	self->priv->parsed_results = _tmp0_;
	_tmp1_ = self->priv->parsed_results;
	_tmp2_ = _g_object_ref0 ((GListModel*) _tmp1_);
	_tmp3_ = gtk_flatten_list_model_new (_tmp2_);
	_g_object_unref0 (self->priv->parsed_list);
	self->priv->parsed_list = _tmp3_;
	_tmp4_ = self->priv->parsed_list;
	g_signal_connect_object ((GListModel*) _tmp4_, "items-changed", (GCallback) _contacts_import_dialog_on_parsed_list_items_changed_g_list_model_items_changed, self, 0);
	_tmp5_ = self->priv->parsed_list;
	contacts_import_dialog_on_parsed_list_items_changed (self, (GListModel*) _tmp5_, (guint) 0, (guint) 0, (guint) 0);
	_tmp6_ = self->priv->_files;
	n_files = g_list_model_get_n_items (_tmp6_);
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp7_ = FALSE;
			_tmp7_ = TRUE;
			while (TRUE) {
				GFile* file = NULL;
				GListModel* _tmp9_;
				GObject* _tmp10_;
				GFile* _tmp11_;
				if (!_tmp7_) {
					guint _tmp8_;
					_tmp8_ = i;
					i = _tmp8_ + 1;
				}
				_tmp7_ = FALSE;
				if (!(i < n_files)) {
					break;
				}
				_tmp9_ = self->priv->_files;
				_tmp10_ = g_list_model_get_item (_tmp9_, i);
				file = G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, g_file_get_type (), GFile);
				_tmp11_ = file;
				contacts_import_dialog_handle_file (self, _tmp11_, n_files > ((guint) 1), NULL, NULL);
				_g_object_unref0 (file);
			}
		}
	}
	return obj;
}

static void
contacts_import_dialog_class_init (ContactsImportDialogClass * klass,
                                   gpointer klass_data)
{
	contacts_import_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ContactsImportDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_contacts_import_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_contacts_import_dialog_set_property;
	G_OBJECT_CLASS (klass)->constructor = contacts_import_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = contacts_import_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_DIALOG_FILES_PROPERTY, contacts_import_dialog_properties[CONTACTS_IMPORT_DIALOG_FILES_PROPERTY] = g_param_spec_object ("files", "files", "files", g_list_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CONTACTS_IMPORT_DIALOG_CONTACTS_STORE_PROPERTY, contacts_import_dialog_properties[CONTACTS_IMPORT_DIALOG_CONTACTS_STORE_PROPERTY] = g_param_spec_object ("contacts-store", "contacts-store", "contacts-store", CONTACTS_TYPE_STORE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Contacts/ui/contacts-import-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "page", FALSE, ContactsImportDialog_private_offset + G_STRUCT_OFFSET (ContactsImportDialogPrivate, page));
	gtk_widget_class_install_action (GTK_WIDGET_CLASS (klass), "import", NULL, (GtkWidgetActionActivateFunc) contacts_import_dialog_action_import);
}

static void
contacts_import_dialog_instance_init (ContactsImportDialog * self,
                                      gpointer klass)
{
	self->priv = contacts_import_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
contacts_import_dialog_finalize (GObject * obj)
{
	ContactsImportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialog);
	_g_object_unref0 (self->priv->_files);
	_g_object_unref0 (self->priv->parsed_results);
	_g_object_unref0 (self->priv->parsed_list);
	_g_object_unref0 (self->priv->_contacts_store);
	G_OBJECT_CLASS (contacts_import_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
contacts_import_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContactsImportDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) contacts_import_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContactsImportDialog), 0, (GInstanceInitFunc) contacts_import_dialog_instance_init, NULL };
	GType contacts_import_dialog_type_id;
	contacts_import_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "ContactsImportDialog", &g_define_type_info, 0);
	ContactsImportDialog_private_offset = g_type_add_instance_private (contacts_import_dialog_type_id, sizeof (ContactsImportDialogPrivate));
	return contacts_import_dialog_type_id;
}

GType
contacts_import_dialog_get_type (void)
{
	static volatile gsize contacts_import_dialog_type_id__once = 0;
	if (g_once_init_enter (&contacts_import_dialog_type_id__once)) {
		GType contacts_import_dialog_type_id;
		contacts_import_dialog_type_id = contacts_import_dialog_get_type_once ();
		g_once_init_leave (&contacts_import_dialog_type_id__once, contacts_import_dialog_type_id);
	}
	return contacts_import_dialog_type_id__once;
}

static void
_vala_contacts_import_dialog_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	ContactsImportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialog);
	switch (property_id) {
		case CONTACTS_IMPORT_DIALOG_FILES_PROPERTY:
		g_value_set_object (value, contacts_import_dialog_get_files (self));
		break;
		case CONTACTS_IMPORT_DIALOG_CONTACTS_STORE_PROPERTY:
		g_value_set_object (value, contacts_import_dialog_get_contacts_store (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_contacts_import_dialog_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	ContactsImportDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CONTACTS_TYPE_IMPORT_DIALOG, ContactsImportDialog);
	switch (property_id) {
		case CONTACTS_IMPORT_DIALOG_FILES_PROPERTY:
		contacts_import_dialog_set_files (self, g_value_get_object (value));
		break;
		case CONTACTS_IMPORT_DIALOG_CONTACTS_STORE_PROPERTY:
		contacts_import_dialog_set_contacts_store (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

