// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: blob.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	BlobService_GetBlob_FullMethodName            = "/gitaly.BlobService/GetBlob"
	BlobService_GetBlobs_FullMethodName           = "/gitaly.BlobService/GetBlobs"
	BlobService_ListBlobs_FullMethodName          = "/gitaly.BlobService/ListBlobs"
	BlobService_ListAllBlobs_FullMethodName       = "/gitaly.BlobService/ListAllBlobs"
	BlobService_GetLFSPointers_FullMethodName     = "/gitaly.BlobService/GetLFSPointers"
	BlobService_ListLFSPointers_FullMethodName    = "/gitaly.BlobService/ListLFSPointers"
	BlobService_ListAllLFSPointers_FullMethodName = "/gitaly.BlobService/ListAllLFSPointers"
)

// BlobServiceClient is the client API for BlobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// BlobService is a service which provides RPCs to retrieve Git blobs from a
// specific repository.
type BlobServiceClient interface {
	// GetBlob returns the contents of a blob object referenced by its object
	// ID. We use a stream to return a chunked arbitrarily large binary
	// response
	GetBlob(ctx context.Context, in *GetBlobRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetBlobResponse], error)
	// GetBlobs returns blobs identified via a revision and path.
	//
	// Note that the behaviour of this RPC is quite weird: it does not only return blobs, but will also return submodules
	// as commits and trees. It's use is thus discouraged in favor of ListBlobs, which behaves more sanely.
	GetBlobs(ctx context.Context, in *GetBlobsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetBlobsResponse], error)
	// ListBlobs will list all blobs reachable from a given set of revisions by
	// doing a graph walk. It is not valid to pass revisions which do not resolve
	// to an existing object.
	ListBlobs(ctx context.Context, in *ListBlobsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListBlobsResponse], error)
	// ListAllBlobs retrieves all blobs pointers in the repository, including
	// those not reachable by any reference.
	ListAllBlobs(ctx context.Context, in *ListAllBlobsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListAllBlobsResponse], error)
	// GetLFSPointers retrieves LFS pointers from a given set of object IDs.
	// This RPC filters all requested objects and only returns those which refer
	// to a valid LFS pointer.
	GetLFSPointers(ctx context.Context, in *GetLFSPointersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetLFSPointersResponse], error)
	// ListLFSPointers retrieves LFS pointers reachable from a given set of
	// revisions by doing a graph walk. This includes both normal revisions like
	// an object ID or branch, but also the pseudo-revisions "--all" and "--not"
	// as documented in git-rev-parse(1). Revisions which don't directly or
	// transitively reference any LFS pointers are ignored. It is not valid to
	// pass revisions which do not resolve to an existing object.
	ListLFSPointers(ctx context.Context, in *ListLFSPointersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListLFSPointersResponse], error)
	// ListAllLFSPointers retrieves all LFS pointers in the repository, including
	// those not reachable by any reference.
	ListAllLFSPointers(ctx context.Context, in *ListAllLFSPointersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListAllLFSPointersResponse], error)
}

type blobServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewBlobServiceClient(cc grpc.ClientConnInterface) BlobServiceClient {
	return &blobServiceClient{cc}
}

func (c *blobServiceClient) GetBlob(ctx context.Context, in *GetBlobRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetBlobResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[0], BlobService_GetBlob_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetBlobRequest, GetBlobResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_GetBlobClient = grpc.ServerStreamingClient[GetBlobResponse]

func (c *blobServiceClient) GetBlobs(ctx context.Context, in *GetBlobsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetBlobsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[1], BlobService_GetBlobs_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetBlobsRequest, GetBlobsResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_GetBlobsClient = grpc.ServerStreamingClient[GetBlobsResponse]

func (c *blobServiceClient) ListBlobs(ctx context.Context, in *ListBlobsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListBlobsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[2], BlobService_ListBlobs_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListBlobsRequest, ListBlobsResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListBlobsClient = grpc.ServerStreamingClient[ListBlobsResponse]

func (c *blobServiceClient) ListAllBlobs(ctx context.Context, in *ListAllBlobsRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListAllBlobsResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[3], BlobService_ListAllBlobs_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListAllBlobsRequest, ListAllBlobsResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListAllBlobsClient = grpc.ServerStreamingClient[ListAllBlobsResponse]

func (c *blobServiceClient) GetLFSPointers(ctx context.Context, in *GetLFSPointersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[GetLFSPointersResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[4], BlobService_GetLFSPointers_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[GetLFSPointersRequest, GetLFSPointersResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_GetLFSPointersClient = grpc.ServerStreamingClient[GetLFSPointersResponse]

func (c *blobServiceClient) ListLFSPointers(ctx context.Context, in *ListLFSPointersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListLFSPointersResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[5], BlobService_ListLFSPointers_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListLFSPointersRequest, ListLFSPointersResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListLFSPointersClient = grpc.ServerStreamingClient[ListLFSPointersResponse]

func (c *blobServiceClient) ListAllLFSPointers(ctx context.Context, in *ListAllLFSPointersRequest, opts ...grpc.CallOption) (grpc.ServerStreamingClient[ListAllLFSPointersResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &BlobService_ServiceDesc.Streams[6], BlobService_ListAllLFSPointers_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[ListAllLFSPointersRequest, ListAllLFSPointersResponse]{ClientStream: stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListAllLFSPointersClient = grpc.ServerStreamingClient[ListAllLFSPointersResponse]

// BlobServiceServer is the server API for BlobService service.
// All implementations must embed UnimplementedBlobServiceServer
// for forward compatibility.
//
// BlobService is a service which provides RPCs to retrieve Git blobs from a
// specific repository.
type BlobServiceServer interface {
	// GetBlob returns the contents of a blob object referenced by its object
	// ID. We use a stream to return a chunked arbitrarily large binary
	// response
	GetBlob(*GetBlobRequest, grpc.ServerStreamingServer[GetBlobResponse]) error
	// GetBlobs returns blobs identified via a revision and path.
	//
	// Note that the behaviour of this RPC is quite weird: it does not only return blobs, but will also return submodules
	// as commits and trees. It's use is thus discouraged in favor of ListBlobs, which behaves more sanely.
	GetBlobs(*GetBlobsRequest, grpc.ServerStreamingServer[GetBlobsResponse]) error
	// ListBlobs will list all blobs reachable from a given set of revisions by
	// doing a graph walk. It is not valid to pass revisions which do not resolve
	// to an existing object.
	ListBlobs(*ListBlobsRequest, grpc.ServerStreamingServer[ListBlobsResponse]) error
	// ListAllBlobs retrieves all blobs pointers in the repository, including
	// those not reachable by any reference.
	ListAllBlobs(*ListAllBlobsRequest, grpc.ServerStreamingServer[ListAllBlobsResponse]) error
	// GetLFSPointers retrieves LFS pointers from a given set of object IDs.
	// This RPC filters all requested objects and only returns those which refer
	// to a valid LFS pointer.
	GetLFSPointers(*GetLFSPointersRequest, grpc.ServerStreamingServer[GetLFSPointersResponse]) error
	// ListLFSPointers retrieves LFS pointers reachable from a given set of
	// revisions by doing a graph walk. This includes both normal revisions like
	// an object ID or branch, but also the pseudo-revisions "--all" and "--not"
	// as documented in git-rev-parse(1). Revisions which don't directly or
	// transitively reference any LFS pointers are ignored. It is not valid to
	// pass revisions which do not resolve to an existing object.
	ListLFSPointers(*ListLFSPointersRequest, grpc.ServerStreamingServer[ListLFSPointersResponse]) error
	// ListAllLFSPointers retrieves all LFS pointers in the repository, including
	// those not reachable by any reference.
	ListAllLFSPointers(*ListAllLFSPointersRequest, grpc.ServerStreamingServer[ListAllLFSPointersResponse]) error
	mustEmbedUnimplementedBlobServiceServer()
}

// UnimplementedBlobServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedBlobServiceServer struct{}

func (UnimplementedBlobServiceServer) GetBlob(*GetBlobRequest, grpc.ServerStreamingServer[GetBlobResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetBlob not implemented")
}
func (UnimplementedBlobServiceServer) GetBlobs(*GetBlobsRequest, grpc.ServerStreamingServer[GetBlobsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetBlobs not implemented")
}
func (UnimplementedBlobServiceServer) ListBlobs(*ListBlobsRequest, grpc.ServerStreamingServer[ListBlobsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListBlobs not implemented")
}
func (UnimplementedBlobServiceServer) ListAllBlobs(*ListAllBlobsRequest, grpc.ServerStreamingServer[ListAllBlobsResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListAllBlobs not implemented")
}
func (UnimplementedBlobServiceServer) GetLFSPointers(*GetLFSPointersRequest, grpc.ServerStreamingServer[GetLFSPointersResponse]) error {
	return status.Errorf(codes.Unimplemented, "method GetLFSPointers not implemented")
}
func (UnimplementedBlobServiceServer) ListLFSPointers(*ListLFSPointersRequest, grpc.ServerStreamingServer[ListLFSPointersResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListLFSPointers not implemented")
}
func (UnimplementedBlobServiceServer) ListAllLFSPointers(*ListAllLFSPointersRequest, grpc.ServerStreamingServer[ListAllLFSPointersResponse]) error {
	return status.Errorf(codes.Unimplemented, "method ListAllLFSPointers not implemented")
}
func (UnimplementedBlobServiceServer) mustEmbedUnimplementedBlobServiceServer() {}
func (UnimplementedBlobServiceServer) testEmbeddedByValue()                     {}

// UnsafeBlobServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BlobServiceServer will
// result in compilation errors.
type UnsafeBlobServiceServer interface {
	mustEmbedUnimplementedBlobServiceServer()
}

func RegisterBlobServiceServer(s grpc.ServiceRegistrar, srv BlobServiceServer) {
	// If the following call pancis, it indicates UnimplementedBlobServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&BlobService_ServiceDesc, srv)
}

func _BlobService_GetBlob_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetBlobRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetBlob(m, &grpc.GenericServerStream[GetBlobRequest, GetBlobResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_GetBlobServer = grpc.ServerStreamingServer[GetBlobResponse]

func _BlobService_GetBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetBlobs(m, &grpc.GenericServerStream[GetBlobsRequest, GetBlobsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_GetBlobsServer = grpc.ServerStreamingServer[GetBlobsResponse]

func _BlobService_ListBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListBlobs(m, &grpc.GenericServerStream[ListBlobsRequest, ListBlobsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListBlobsServer = grpc.ServerStreamingServer[ListBlobsResponse]

func _BlobService_ListAllBlobs_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListAllBlobsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListAllBlobs(m, &grpc.GenericServerStream[ListAllBlobsRequest, ListAllBlobsResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListAllBlobsServer = grpc.ServerStreamingServer[ListAllBlobsResponse]

func _BlobService_GetLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(GetLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).GetLFSPointers(m, &grpc.GenericServerStream[GetLFSPointersRequest, GetLFSPointersResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_GetLFSPointersServer = grpc.ServerStreamingServer[GetLFSPointersResponse]

func _BlobService_ListLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListLFSPointers(m, &grpc.GenericServerStream[ListLFSPointersRequest, ListLFSPointersResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListLFSPointersServer = grpc.ServerStreamingServer[ListLFSPointersResponse]

func _BlobService_ListAllLFSPointers_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(ListAllLFSPointersRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(BlobServiceServer).ListAllLFSPointers(m, &grpc.GenericServerStream[ListAllLFSPointersRequest, ListAllLFSPointersResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type BlobService_ListAllLFSPointersServer = grpc.ServerStreamingServer[ListAllLFSPointersResponse]

// BlobService_ServiceDesc is the grpc.ServiceDesc for BlobService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BlobService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.BlobService",
	HandlerType: (*BlobServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "GetBlob",
			Handler:       _BlobService_GetBlob_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetBlobs",
			Handler:       _BlobService_GetBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListBlobs",
			Handler:       _BlobService_ListBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListAllBlobs",
			Handler:       _BlobService_ListAllBlobs_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "GetLFSPointers",
			Handler:       _BlobService_GetLFSPointers_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListLFSPointers",
			Handler:       _BlobService_ListLFSPointers_Handler,
			ServerStreams: true,
		},
		{
			StreamName:    "ListAllLFSPointers",
			Handler:       _BlobService_ListAllLFSPointers_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "blob.proto",
}
