/* THIS FILE IS AUTOGENERATED FROM TouchEvent.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "TouchEventBinding.h"
#include "UIEventBinding.h"
#include "WrapperFactory.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/TouchEvent.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsGlobalWindowInner.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;



TouchEventInit::TouchEventInit()
  : EventModifierInit(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
TouchEventInit::InitIds(JSContext* cx, TouchEventInitAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->touches_id.init(cx, "touches") ||
      !atomsCache->targetTouches_id.init(cx, "targetTouches") ||
      !atomsCache->changedTouches_id.init(cx, "changedTouches")) {
    return false;
  }
  return true;
}

bool
TouchEventInit::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  TouchEventInitAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<TouchEventInitAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!EventModifierInit::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->changedTouches_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'changedTouches' member of TouchEventInit", "sequence");
        return false;
      }
      Sequence<OwningNonNull<mozilla::dom::Touch>> &arr = mChangedTouches;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningNonNull<mozilla::dom::Touch>* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningNonNull<mozilla::dom::Touch>& slot = *slotPtr;
        if (temp.isObject()) {
          static_assert(IsRefcounted<mozilla::dom::Touch>::value, "We can only store refcounted classes.");
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::Touch, mozilla::dom::Touch>(&temp, slot, cx);
            if (NS_FAILED(rv)) {
              cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of 'changedTouches' member of TouchEventInit", "Touch");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of 'changedTouches' member of TouchEventInit");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'changedTouches' member of TouchEventInit", "sequence");
      return false;
    }
  } else {
    /* mChangedTouches array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->targetTouches_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'targetTouches' member of TouchEventInit", "sequence");
        return false;
      }
      Sequence<OwningNonNull<mozilla::dom::Touch>> &arr = mTargetTouches;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningNonNull<mozilla::dom::Touch>* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningNonNull<mozilla::dom::Touch>& slot = *slotPtr;
        if (temp.isObject()) {
          static_assert(IsRefcounted<mozilla::dom::Touch>::value, "We can only store refcounted classes.");
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::Touch, mozilla::dom::Touch>(&temp, slot, cx);
            if (NS_FAILED(rv)) {
              cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of 'targetTouches' member of TouchEventInit", "Touch");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of 'targetTouches' member of TouchEventInit");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'targetTouches' member of TouchEventInit", "sequence");
      return false;
    }
  } else {
    /* mTargetTouches array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->touches_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'touches' member of TouchEventInit", "sequence");
        return false;
      }
      Sequence<OwningNonNull<mozilla::dom::Touch>> &arr = mTouches;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        OwningNonNull<mozilla::dom::Touch>* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        OwningNonNull<mozilla::dom::Touch>& slot = *slotPtr;
        if (temp.isObject()) {
          static_assert(IsRefcounted<mozilla::dom::Touch>::value, "We can only store refcounted classes.");
          {
            // Our JSContext should be in the right global to do unwrapping in.
            nsresult rv = UnwrapObject<prototypes::id::Touch, mozilla::dom::Touch>(&temp, slot, cx);
            if (NS_FAILED(rv)) {
              cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Element of 'touches' member of TouchEventInit", "Touch");
              return false;
            }
          }
        } else {
          cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Element of 'touches' member of TouchEventInit");
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'touches' member of TouchEventInit", "sequence");
      return false;
    }
  } else {
    /* mTouches array is already empty; nothing to do */
  }
  mIsAnyMemberPresent = true;
  return true;
}

bool
TouchEventInit::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

void
TouchEventInit::TraceDictionary(JSTracer* trc)
{
  EventModifierInit::TraceDictionary(trc);
}



TouchEventInit&
TouchEventInit::operator=(const TouchEventInit& aOther)
{
  EventModifierInit::operator=(aOther);
  mChangedTouches = aOther.mChangedTouches;
  mTargetTouches = aOther.mTargetTouches;
  mTouches = aOther.mTouches;
  return *this;
}


namespace TouchEvent_Binding {

static_assert(IsRefcounted<NativeType>::value == IsRefcounted<UIEvent_Binding::NativeType>::value,
              "Can't inherit from an interface with a different ownership model.");

MOZ_CAN_RUN_SCRIPT static bool
get_touches(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "touches", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::TouchList>(MOZ_KnownLive(self)->Touches()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo touches_getterinfo = {
  { get_touches },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_targetTouches(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "targetTouches", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::TouchList>(MOZ_KnownLive(self)->TargetTouches()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo targetTouches_getterinfo = {
  { get_targetTouches },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_changedTouches(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "changedTouches", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  auto result(StrongOrRawPtr<mozilla::dom::TouchList>(MOZ_KnownLive(self)->ChangedTouches()));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  if (!GetOrCreateDOMReflector(cx, result, args.rval())) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const JSJitInfo changedTouches_getterinfo = {
  { get_changedTouches },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_OBJECT,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_altKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "altKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->AltKey());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo altKey_getterinfo = {
  { get_altKey },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_metaKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "metaKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->MetaKey());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo metaKey_getterinfo = {
  { get_metaKey },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_ctrlKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "ctrlKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->CtrlKey());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo ctrlKey_getterinfo = {
  { get_ctrlKey },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_shiftKey(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "shiftKey", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->ShiftKey());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo shiftKey_getterinfo = {
  { get_shiftKey },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
initTouchEvent(JSContext* cx_, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  BindingCallContext cx(cx_, "TouchEvent.initTouchEvent");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "initTouchEvent", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  if (!args.requireAtLeast(cx, "TouchEvent.initTouchEvent", 1)) {
    return false;
  }
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  bool arg1;
  if (args.hasDefined(1)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[1], "Argument 2", &arg1)) {
      return false;
    }
  } else {
    arg1 = false;
  }
  bool arg2;
  if (args.hasDefined(2)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[2], "Argument 3", &arg2)) {
      return false;
    }
  } else {
    arg2 = false;
  }
  nsGlobalWindowInner* arg3;
  if (args.hasDefined(3)) {
    if (args[3].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::Window, nsGlobalWindowInner>(args[3], arg3, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 4", "Window");
          return false;
        }
      }
    } else if (args[3].isNullOrUndefined()) {
      arg3 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 4");
      return false;
    }
  } else {
    arg3 = nullptr;
  }
  int32_t arg4;
  if (args.hasDefined(4)) {
    if (!ValueToPrimitive<int32_t, eDefault>(cx, args[4], "Argument 5", &arg4)) {
      return false;
    }
  } else {
    arg4 = 0;
  }
  bool arg5;
  if (args.hasDefined(5)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[5], "Argument 6", &arg5)) {
      return false;
    }
  } else {
    arg5 = false;
  }
  bool arg6;
  if (args.hasDefined(6)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[6], "Argument 7", &arg6)) {
      return false;
    }
  } else {
    arg6 = false;
  }
  bool arg7;
  if (args.hasDefined(7)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[7], "Argument 8", &arg7)) {
      return false;
    }
  } else {
    arg7 = false;
  }
  bool arg8;
  if (args.hasDefined(8)) {
    if (!ValueToPrimitive<bool, eDefault>(cx, args[8], "Argument 9", &arg8)) {
      return false;
    }
  } else {
    arg8 = false;
  }
  mozilla::dom::TouchList* arg9;
  if (args.hasDefined(9)) {
    if (args[9].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::TouchList, mozilla::dom::TouchList>(args[9], arg9, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 10", "TouchList");
          return false;
        }
      }
    } else if (args[9].isNullOrUndefined()) {
      arg9 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 10");
      return false;
    }
  } else {
    arg9 = nullptr;
  }
  mozilla::dom::TouchList* arg10;
  if (args.hasDefined(10)) {
    if (args[10].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::TouchList, mozilla::dom::TouchList>(args[10], arg10, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 11", "TouchList");
          return false;
        }
      }
    } else if (args[10].isNullOrUndefined()) {
      arg10 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 11");
      return false;
    }
  } else {
    arg10 = nullptr;
  }
  mozilla::dom::TouchList* arg11;
  if (args.hasDefined(11)) {
    if (args[11].isObject()) {
      {
        // Our JSContext should be in the right global to do unwrapping in.
        nsresult rv = UnwrapObject<prototypes::id::TouchList, mozilla::dom::TouchList>(args[11], arg11, cx);
        if (NS_FAILED(rv)) {
          cx.ThrowErrorMessage<MSG_DOES_NOT_IMPLEMENT_INTERFACE>("Argument 12", "TouchList");
          return false;
        }
      }
    } else if (args[11].isNullOrUndefined()) {
      arg11 = nullptr;
    } else {
      cx.ThrowErrorMessage<MSG_NOT_OBJECT>("Argument 12");
      return false;
    }
  } else {
    arg11 = nullptr;
  }
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->InitTouchEvent(NonNullHelper(Constify(arg0)), arg1, arg2, MOZ_KnownLive(Constify(arg3)), arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(Constify(arg9)), MOZ_KnownLive(Constify(arg10)), MOZ_KnownLive(Constify(arg11))))>, "Should be returning void here");
  MOZ_KnownLive(self)->InitTouchEvent(NonNullHelper(Constify(arg0)), arg1, arg2, MOZ_KnownLive(Constify(arg3)), arg4, arg5, arg6, arg7, arg8, MOZ_KnownLive(Constify(arg9)), MOZ_KnownLive(Constify(arg10)), MOZ_KnownLive(Constify(arg11)));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setUndefined();
  return true;
}

static const JSJitInfo initTouchEvent_methodinfo = {
  { (JSJitGetterOp)initTouchEvent },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNDEFINED,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_CAN_RUN_SCRIPT static bool
get_isTrusted(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, JSJitGetterCallArgs args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "isTrusted", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_GETTER) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::dom::TouchEvent*>(void_self);
  bool result(MOZ_KnownLive(self)->IsTrusted());
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  args.rval().setBoolean(result);
  return true;
}

static const JSJitInfo isTrusted_getterinfo = {
  { get_isTrusted },
  { prototypes::id::TouchEvent },
  { PrototypeTraits<prototypes::id::TouchEvent>::Depth },
  JSJitInfo::Getter,
  JSJitInfo::AliasDOMSets, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_BOOLEAN,  /* returnType.  Not relevant for setters. */
  true,  /* isInfallible. False in setters. */
  true,  /* isMovable.  Not relevant for setters. */
  true, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

static void
_finalize(JS::GCContext* gcx, JSObject* obj)
{
  mozilla::dom::TouchEvent* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::dom::TouchEvent>(obj);
  if (self) {
    JS::SetReservedSlot(obj, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, obj);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(obj, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::dom::TouchEvent>(self);
  }
}

MOZ_GLOBINIT static const JSFunctionSpec sMethods_specs[] = {
  JS_FNSPEC("initTouchEvent", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&initTouchEvent_methodinfo), 1, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sMethods[] = {
  { nullptr, &sMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("touches", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &touches_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("targetTouches", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &targetTouches_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("changedTouches", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &changedTouches_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("altKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &altKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("metaKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &metaKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("ctrlKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &ctrlKey_getterinfo, nullptr, nullptr),
  JSPropertySpec::nativeAccessors("shiftKey", JSPROP_ENUMERATE, GenericGetter<NormalThisPolicy, ThrowExceptions>, &shiftKey_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sAttributes[] = {
  { nullptr, &sAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(7 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");

MOZ_GLOBINIT static const JSPropertySpec sUnforgeableAttributes_specs[] = {
  JSPropertySpec::nativeAccessors("isTrusted", JSPROP_ENUMERATE | JSPROP_PERMANENT, GenericGetter<NormalThisPolicy, ThrowExceptions>, &isTrusted_getterinfo, nullptr, nullptr),
  JS_PS_END
};


static const Prefable<const JSPropertySpec> sUnforgeableAttributes[] = {
  { nullptr, &sUnforgeableAttributes_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sNativeProperties_sortedPropertyIndices[9];
static PropertyInfo sNativeProperties_propertyInfos[9];

static const NativePropertiesN<3> sNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sMethods */,
  true,  1 /* sAttributes */,
  false, 0,
  true,  2 /* sUnforgeableAttributes */,
  false, 0,
  -1,
  9,
  sNativeProperties_sortedPropertyIndices,
  {
    { sMethods, &sNativeProperties_propertyInfos[0] },
    { sAttributes, &sNativeProperties_propertyInfos[1] },
    { sUnforgeableAttributes, &sNativeProperties_propertyInfos[8] }
  }
};
static_assert(9 < 1ull << (CHAR_BIT * sizeof(sNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  nullptr,
  { sNativeProperties.Upcast(), nullptr, &sNativePropertiesInited },
  prototypes::id::TouchEvent,
  constructors::id::TouchEvent,
  &DefaultXrayExpandoObjectClass
};

static bool
_constructor(JSContext* cx_, unsigned argc, JS::Value* vp)
{
  BindingCallContext cx(cx_, "TouchEvent constructor");
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "TouchEvent", "constructor", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  JS::CallArgs args = JS::CallArgsFromVp(argc, vp);
  JS::Rooted<JSObject*> obj(cx, &args.callee());
  if (!args.isConstructing()) {
    return ThrowConstructorWithoutNew(cx, "TouchEvent");
  }

  JS::Rooted<JSObject*> desiredProto(cx);
  if (!GetDesiredProto(cx, args,
                       prototypes::id::TouchEvent,
                       CreateInterfaceObjects,
                       &desiredProto)) {
    return false;
  }

  if (!args.requireAtLeast(cx, "TouchEvent constructor", 1)) {
    return false;
  }
  GlobalObject global(cx, obj);
  if (global.Failed()) {
    return false;
  }

  bool objIsXray = xpc::WrapperFactory::IsXrayWrapper(obj);
  binding_detail::FakeString<char16_t> arg0;
  if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
    return false;
  }
  binding_detail::FastTouchEventInit arg1;
  if (!arg1.Init(cx, (args.hasDefined(1)) ? args[1] : JS::NullHandleValue, "Argument 2", false)) {
    return false;
  }
  Maybe<JSAutoRealm> ar;
  if (objIsXray) {
    // Since our object is an Xray, we can just CheckedUnwrapStatic:
    // we know Xrays have no dynamic unwrap behavior.
    obj = js::CheckedUnwrapStatic(obj);
    if (!obj) {
      return false;
    }
    ar.emplace(cx, obj);
    if (!JS_WrapObject(cx, &desiredProto)) {
      return false;
    }
  }
  auto result(StrongOrRawPtr<mozilla::dom::TouchEvent>(mozilla::dom::TouchEvent::Constructor(global, NonNullHelper(Constify(arg0)), Constify(arg1))));
  MOZ_ASSERT(!JS_IsExceptionPending(cx));
  static_assert(!std::is_pointer_v<decltype(result)>,
                "NewObject implies that we need to keep the object alive with a strong reference.");
  if (!GetOrCreateDOMReflector(cx, result, args.rval(), desiredProto)) {
    MOZ_ASSERT(JS_IsExceptionPending(cx));
    return false;
  }
  return true;
}

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { _constructor, &sNativePropertyHooks },
  UIEvent_Binding::GetConstructorObjectHandle,
  PrototypeTraits<prototypes::id::TouchEvent>::Depth,
  prototypes::id::TouchEvent,
  true,
  1,
  "TouchEvent",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "TouchEventPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE + 1 /* slot for the JSObject holding the unforgeable properties */),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::TouchEvent,
  PrototypeTraits<prototypes::id::TouchEvent>::Depth,
  &sNativePropertyHooks,
  UIEvent_Binding::GetProtoObject
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return mozilla::dom::TouchEvent::PrefEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

static const JSClassOps sClassOps = {
  nullptr,               /* addProperty */
  nullptr,               /* delProperty */
  nullptr,               /* enumerate */
  nullptr, /* newEnumerate */
  nullptr, /* resolve */
  nullptr, /* mayResolve */
  _finalize, /* finalize */
  nullptr, /* call */
  nullptr,               /* construct */
  nullptr, /* trace */
};

static const DOMJSClass sClass = {
  { "TouchEvent",
    JSCLASS_IS_DOMJSCLASS | JSCLASS_FOREGROUND_FINALIZE | JSCLASS_HAS_RESERVED_SLOTS(1) | JSCLASS_SKIP_NURSERY_FINALIZE | JSCLASS_PRESERVES_WRAPPER,
    &sClassOps,
    JS_NULL_CLASS_SPEC,
    &NativeTypeHelpers<mozilla::dom::TouchEvent>::sClassExtension,
    JS_NULL_OBJECT_OPS
  },
  { prototypes::id::Event, prototypes::id::UIEvent, prototypes::id::TouchEvent, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::dom::TouchEvent>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::dom::TouchEvent>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::dom::TouchEvent>::Get(),
  nullptr,
  NativeTypeHelpers<mozilla::dom::TouchEvent>::GetWrapperCache
};
static_assert(1 == DOM_INSTANCE_RESERVED_SLOTS,
              "Must have the right minimal number of reserved slots.");
static_assert(1 >= 1,
              "Must have enough reserved slots.");

bool
Wrap(JSContext* aCx, mozilla::dom::TouchEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::dom::TouchEvent>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::dom::TouchEvent*>);
  MOZ_ASSERT(static_cast<mozilla::dom::UIEvent*>(aObject) ==
             reinterpret_cast<mozilla::dom::UIEvent*>(aObject),
             "Multiple inheritance for mozilla::dom::UIEvent is broken.");
  MOZ_ASSERT(static_cast<mozilla::dom::Event*>(aObject) ==
             reinterpret_cast<mozilla::dom::Event*>(aObject),
             "Multiple inheritance for mozilla::dom::Event is broken.");
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    _finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::dom::TouchEvent> creator(aCx);
  creator.CreateObject(aCx, sClass.ToJSClass(), proto, aObject, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);

  // Important: do unforgeable property setup after we have handed
  // over ownership of the C++ object to obj as needed, so that if
  // we fail and it ends up GCed it won't have problems in the
  // finalizer trying to drop its ownership of the C++ object.
  JS::Rooted<JSObject*> unforgeableHolder(aCx,
    &JS::GetReservedSlot(canonicalProto, DOM_INTERFACE_PROTO_SLOTS_BASE).toObject());
  if (!JS_InitializePropertiesFromCompatibleNativeObject(aCx, aReflector, unforgeableHolder)) {
    aCache->ReleaseWrapper(aObject);
    aCache->ClearWrapper();
    return false;
  }
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::TouchEvent);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::TouchEvent);

  JS::Handle<JSObject*> parentProto(UIEvent_Binding::GetProtoObjectHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(UIEvent_Binding::GetConstructorObjectHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 1, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              sNativeProperties.Upcast(),
                              nullptr,
                              "TouchEvent",
                              ShouldExpose<TouchEvent_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);

  JS::AssertObjectIsNotGray(*protoCache);
  JS::Handle<JSObject*> proto = JS::Handle<JSObject*>::fromMarkedLocation(protoCache->unsafeAddress());
  if (!proto) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  JS::Rooted<JSObject*> unforgeableHolder(
      aCx, JS_NewObjectWithoutMetadata(aCx, sClass.ToJSClass(), proto));
  if (!unforgeableHolder) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (!DefineLegacyUnforgeableAttributes(aCx, unforgeableHolder, sUnforgeableAttributes)) {
    *protoCache = nullptr;
    if (interfaceCache) {
      *interfaceCache = nullptr;
    }
    return;
  }

  if (*protoCache) {
    JS::SetReservedSlot(*protoCache, DOM_INTERFACE_PROTO_SLOTS_BASE,
                        JS::ObjectValue(*unforgeableHolder));
  }
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::TouchEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::TouchEvent,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace TouchEvent_Binding



} // namespace mozilla::dom
