//
// DO NOT EDIT.  THIS FILE IS GENERATED FROM $SRCDIR/security/manager/ssl/nsICertStorage.idl
//


/// `interface nsICertStorageCallback : nsISupports`
///

/// ```text
/// /**
///  * Callback type used to notify callers that an operation performed by
///  * nsICertStorage has completed. Indicates the result of the requested
///  * operation, as well as any data returned by the operation.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICertStorageCallback {
    vtable: &'static nsICertStorageCallbackVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICertStorageCallback.
unsafe impl XpCom for nsICertStorageCallback {
    const IID: nsIID = nsID(0x3f8fe26a, 0xa436, 0x4ad4,
        [0x9c, 0x1c, 0xa5, 0x3c, 0x60, 0x97, 0x3c, 0x31]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICertStorageCallback {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICertStorageCallback.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICertStorageCallbackCoerce {
    /// Cheaply cast a value of this type from a `nsICertStorageCallback`.
    fn coerce_from(v: &nsICertStorageCallback) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICertStorageCallbackCoerce for nsICertStorageCallback {
    #[inline]
    fn coerce_from(v: &nsICertStorageCallback) -> &Self {
        v
    }
}

impl nsICertStorageCallback {
    /// Cast this `nsICertStorageCallback` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICertStorageCallbackCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICertStorageCallback {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICertStorageCallbackCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICertStorageCallback) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICertStorageCallback
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICertStorageCallbackVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [must_use] void done (in nsresult rv, in nsIVariant result); */
    pub Done: unsafe extern "system" fn (this: *const nsICertStorageCallback, rv: nserror::nsresult, result: *const nsIVariant) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICertStorageCallback {


    /// `[must_use] void done (in nsresult rv, in nsIVariant result);`
    #[inline]
    pub unsafe fn Done(&self, rv: nserror::nsresult, result: *const nsIVariant) -> ::nserror::nsresult {
        ((*self.vtable).Done)(self, rv, result)
    }


}


/// `interface nsIRevocationState : nsISupports`
///

/// ```text
/// /**
///  * A base interface for representing the revocation state of a certificate.
///  * Implementing this interface by itself is insufficient; your type must
///  * implement an inheriting interface that specifies the certificate by issuer
///  * and serial number or by subject and public key hash.
///  * Set state to nsICertStorage.STATE_UNSET to mark the certificate as not revoked.
///  * Set state to nsICertStorage.STATE_ENFORCE to mark the certificate as revoked.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIRevocationState {
    vtable: &'static nsIRevocationStateVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIRevocationState.
unsafe impl XpCom for nsIRevocationState {
    const IID: nsIID = nsID(0x96db6fd7, 0x6b64, 0x4a5a,
        [0x95, 0x5d, 0x31, 0x0b, 0xd9, 0xca, 0x42, 0x34]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIRevocationState {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIRevocationState.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIRevocationStateCoerce {
    /// Cheaply cast a value of this type from a `nsIRevocationState`.
    fn coerce_from(v: &nsIRevocationState) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIRevocationStateCoerce for nsIRevocationState {
    #[inline]
    fn coerce_from(v: &nsIRevocationState) -> &Self {
        v
    }
}

impl nsIRevocationState {
    /// Cast this `nsIRevocationState` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIRevocationStateCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIRevocationState {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsIRevocationStateCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIRevocationState) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIRevocationState
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIRevocationStateVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute short state; */
    pub GetState: unsafe extern "system" fn (this: *const nsIRevocationState, aState: *mut i16) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIRevocationState {


    /// `readonly attribute short state;`
    #[inline]
    pub unsafe fn GetState(&self, aState: *mut i16) -> ::nserror::nsresult {
        ((*self.vtable).GetState)(self, aState)
    }


}


/// `interface nsIIssuerAndSerialRevocationState : nsIRevocationState`
///

/// ```text
/// /**
///  * An interface representing the revocation state of a certificate by issuer
///  * and serial number. Both issuer name and serial number are base64-encoded.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsIIssuerAndSerialRevocationState {
    vtable: &'static nsIIssuerAndSerialRevocationStateVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsIIssuerAndSerialRevocationState.
unsafe impl XpCom for nsIIssuerAndSerialRevocationState {
    const IID: nsIID = nsID(0x23ce3546, 0xf1b9, 0x46f6,
        [0x8d, 0xe3, 0x77, 0x70, 0x4d, 0xa5, 0x70, 0x2f]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsIIssuerAndSerialRevocationState {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsIIssuerAndSerialRevocationState.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsIIssuerAndSerialRevocationStateCoerce {
    /// Cheaply cast a value of this type from a `nsIIssuerAndSerialRevocationState`.
    fn coerce_from(v: &nsIIssuerAndSerialRevocationState) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsIIssuerAndSerialRevocationStateCoerce for nsIIssuerAndSerialRevocationState {
    #[inline]
    fn coerce_from(v: &nsIIssuerAndSerialRevocationState) -> &Self {
        v
    }
}

impl nsIIssuerAndSerialRevocationState {
    /// Cast this `nsIIssuerAndSerialRevocationState` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsIIssuerAndSerialRevocationStateCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsIIssuerAndSerialRevocationState {
    type Target = nsIRevocationState;
    #[inline]
    fn deref(&self) -> &nsIRevocationState {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsIRevocationStateCoerce> nsIIssuerAndSerialRevocationStateCoerce for T {
    #[inline]
    fn coerce_from(v: &nsIIssuerAndSerialRevocationState) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsIIssuerAndSerialRevocationState
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsIIssuerAndSerialRevocationStateVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsIRevocationStateVTable,

    /* readonly attribute ACString issuer; */
    pub GetIssuer: unsafe extern "system" fn (this: *const nsIIssuerAndSerialRevocationState, aIssuer: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute ACString serial; */
    pub GetSerial: unsafe extern "system" fn (this: *const nsIIssuerAndSerialRevocationState, aSerial: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsIIssuerAndSerialRevocationState {


    /// `readonly attribute ACString issuer;`
    #[inline]
    pub unsafe fn GetIssuer(&self, aIssuer: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetIssuer)(self, aIssuer)
    }



    /// `readonly attribute ACString serial;`
    #[inline]
    pub unsafe fn GetSerial(&self, aSerial: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetSerial)(self, aSerial)
    }


}


/// `interface nsISubjectAndPubKeyRevocationState : nsIRevocationState`
///

/// ```text
/// /**
///  * An interface representing the revocation state of a certificate by subject
///  * and pub key hash (the hash algorithm should be SHA-256). Both subject name
///  * and public key hash are base64-encoded.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsISubjectAndPubKeyRevocationState {
    vtable: &'static nsISubjectAndPubKeyRevocationStateVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsISubjectAndPubKeyRevocationState.
unsafe impl XpCom for nsISubjectAndPubKeyRevocationState {
    const IID: nsIID = nsID(0xe78b51b4, 0x6fa4, 0x41e2,
        [0x92, 0xce, 0xe9, 0x40, 0x4f, 0x54, 0x1e, 0x96]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsISubjectAndPubKeyRevocationState {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsISubjectAndPubKeyRevocationState.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsISubjectAndPubKeyRevocationStateCoerce {
    /// Cheaply cast a value of this type from a `nsISubjectAndPubKeyRevocationState`.
    fn coerce_from(v: &nsISubjectAndPubKeyRevocationState) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsISubjectAndPubKeyRevocationStateCoerce for nsISubjectAndPubKeyRevocationState {
    #[inline]
    fn coerce_from(v: &nsISubjectAndPubKeyRevocationState) -> &Self {
        v
    }
}

impl nsISubjectAndPubKeyRevocationState {
    /// Cast this `nsISubjectAndPubKeyRevocationState` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsISubjectAndPubKeyRevocationStateCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsISubjectAndPubKeyRevocationState {
    type Target = nsIRevocationState;
    #[inline]
    fn deref(&self) -> &nsIRevocationState {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsIRevocationStateCoerce> nsISubjectAndPubKeyRevocationStateCoerce for T {
    #[inline]
    fn coerce_from(v: &nsISubjectAndPubKeyRevocationState) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsISubjectAndPubKeyRevocationState
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsISubjectAndPubKeyRevocationStateVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsIRevocationStateVTable,

    /* readonly attribute ACString subject; */
    pub GetSubject: unsafe extern "system" fn (this: *const nsISubjectAndPubKeyRevocationState, aSubject: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute ACString pubKey; */
    pub GetPubKey: unsafe extern "system" fn (this: *const nsISubjectAndPubKeyRevocationState, aPubKey: *mut ::nsstring::nsACString) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsISubjectAndPubKeyRevocationState {


    /// `readonly attribute ACString subject;`
    #[inline]
    pub unsafe fn GetSubject(&self, aSubject: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetSubject)(self, aSubject)
    }



    /// `readonly attribute ACString pubKey;`
    #[inline]
    pub unsafe fn GetPubKey(&self, aPubKey: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetPubKey)(self, aPubKey)
    }


}


/// `interface nsICRLiteTimestamp : nsISupports`
///

/// ```text
/// /**
///  * An interface representing the id and timestamp fields from an RFC 6962
///  * SignedCertificateTimestamp struct.
///  * logID is the id field.
///  * timestamp is the timestamp field.
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICRLiteTimestamp {
    vtable: &'static nsICRLiteTimestampVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICRLiteTimestamp.
unsafe impl XpCom for nsICRLiteTimestamp {
    const IID: nsIID = nsID(0x9676cfc4, 0x6e84, 0x11ec,
        [0xa3, 0x0d, 0xd3, 0xcd, 0x0a, 0xf8, 0x6e, 0x01]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICRLiteTimestamp {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICRLiteTimestamp.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICRLiteTimestampCoerce {
    /// Cheaply cast a value of this type from a `nsICRLiteTimestamp`.
    fn coerce_from(v: &nsICRLiteTimestamp) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICRLiteTimestampCoerce for nsICRLiteTimestamp {
    #[inline]
    fn coerce_from(v: &nsICRLiteTimestamp) -> &Self {
        v
    }
}

impl nsICRLiteTimestamp {
    /// Cast this `nsICRLiteTimestamp` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICRLiteTimestampCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICRLiteTimestamp {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICRLiteTimestampCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICRLiteTimestamp) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICRLiteTimestamp
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICRLiteTimestampVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute Array<octet> logID; */
    pub GetLogID: unsafe extern "system" fn (this: *const nsICRLiteTimestamp, aLogID: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult,

    /* readonly attribute unsigned long long timestamp; */
    pub GetTimestamp: unsafe extern "system" fn (this: *const nsICRLiteTimestamp, aTimestamp: *mut u64) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICRLiteTimestamp {


    /// `readonly attribute Array<octet> logID;`
    #[inline]
    pub unsafe fn GetLogID(&self, aLogID: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult {
        ((*self.vtable).GetLogID)(self, aLogID)
    }



    /// `readonly attribute unsigned long long timestamp;`
    #[inline]
    pub unsafe fn GetTimestamp(&self, aTimestamp: *mut u64) -> ::nserror::nsresult {
        ((*self.vtable).GetTimestamp)(self, aTimestamp)
    }


}


/// `interface nsICertInfo : nsISupports`
///

/// ```text
/// /**
///  * An interface representing a certificate to add to storage. Consists of the
///  * base64-encoded DER bytes of the certificate (cert), the base64-encoded DER
///  * bytes of the subject distinguished name of the certificate (subject), and the
///  * trust of the certificate (one of the nsICertStorage.TRUST_* constants).
///  * (Note that this implementation does not validate that the given subject DN
    ///  * actually matches the subject DN of the certificate, nor that the given cert
    ///  * is a valid DER X.509 certificate.)
///  */
/// ```
///

// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICertInfo {
    vtable: &'static nsICertInfoVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICertInfo.
unsafe impl XpCom for nsICertInfo {
    const IID: nsIID = nsID(0x27b66f5e, 0x0faf, 0x403b,
        [0x95, 0xb4, 0xbc, 0x11, 0x69, 0x1a, 0xc5, 0x0d]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICertInfo {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICertInfo.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICertInfoCoerce {
    /// Cheaply cast a value of this type from a `nsICertInfo`.
    fn coerce_from(v: &nsICertInfo) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICertInfoCoerce for nsICertInfo {
    #[inline]
    fn coerce_from(v: &nsICertInfo) -> &Self {
        v
    }
}

impl nsICertInfo {
    /// Cast this `nsICertInfo` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICertInfoCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICertInfo {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICertInfoCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICertInfo) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICertInfo
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICertInfoVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* readonly attribute ACString cert; */
    pub GetCert: unsafe extern "system" fn (this: *const nsICertInfo, aCert: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute ACString subject; */
    pub GetSubject: unsafe extern "system" fn (this: *const nsICertInfo, aSubject: *mut ::nsstring::nsACString) -> ::nserror::nsresult,

    /* readonly attribute short trust; */
    pub GetTrust: unsafe extern "system" fn (this: *const nsICertInfo, aTrust: *mut i16) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICertInfo {


    /// `readonly attribute ACString cert;`
    #[inline]
    pub unsafe fn GetCert(&self, aCert: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetCert)(self, aCert)
    }



    /// `readonly attribute ACString subject;`
    #[inline]
    pub unsafe fn GetSubject(&self, aSubject: *mut ::nsstring::nsACString) -> ::nserror::nsresult {
        ((*self.vtable).GetSubject)(self, aSubject)
    }



    /// `readonly attribute short trust;`
    #[inline]
    pub unsafe fn GetTrust(&self, aTrust: *mut i16) -> ::nserror::nsresult {
        ((*self.vtable).GetTrust)(self, aTrust)
    }


}


/// `interface nsICertStorage : nsISupports`
///


// The actual type definition for the interface. This struct has methods
// declared on it which will call through its vtable. You never want to pass
// this type around by value, always pass it behind a reference.

#[repr(C)]
pub struct nsICertStorage {
    vtable: &'static nsICertStorageVTable,

    /// This field is a phantomdata to ensure that the VTable type and any
    /// struct containing it is not safe to send across threads by default, as
    /// XPCOM is generally not threadsafe.
    ///
    /// If this type is marked as [rust_sync], there will be explicit `Send` and
    /// `Sync` implementations on this type, which will override the inherited
    /// negative impls from `Rc`.
    __nosync: ::std::marker::PhantomData<::std::rc::Rc<u8>>,

    // Make the rust compiler aware that there might be interior mutability
    // in what actually implements the interface. This works around UB
    // introduced by https://github.com/llvm/llvm-project/commit/01859da84bad95fd51d6a03b08b60c660e642a4f
    // that a rust lint would make blatantly obvious, but doesn't exist.
    // (See https://github.com/rust-lang/rust/issues/111229).
    // This prevents optimizations, but those optimizations weren't available
    // before rustc switched to LLVM 16, and they now cause problems because
    // of the UB.
    // Until there's a lint available to find all our UB, it's simpler to
    // avoid the UB in the first place, at the cost of preventing optimizations
    // in places that don't cause UB. But again, those optimizations weren't
    // available before.
    __maybe_interior_mutability: ::std::cell::UnsafeCell<[u8; 0]>,
}

// Implementing XpCom for an interface exposes its IID, which allows for easy
// use of the `.query_interface<T>` helper method. This also defines that
// method for nsICertStorage.
unsafe impl XpCom for nsICertStorage {
    const IID: nsIID = nsID(0x327100a7, 0x3401, 0x45ef,
        [0xb1, 0x60, 0xbf, 0x88, 0x0f, 0x10, 0x16, 0xfd]);
}

// We need to implement the RefCounted trait so we can be used with `RefPtr`.
// This trait teaches `RefPtr` how to manage our memory.
unsafe impl RefCounted for nsICertStorage {
    #[inline]
    unsafe fn addref(&self) {
        self.AddRef();
    }
    #[inline]
    unsafe fn release(&self) {
        self.Release();
    }
}

// This trait is implemented on all types which can be coerced to from nsICertStorage.
// It is used in the implementation of `fn coerce<T>`. We hide it from the
// documentation, because it clutters it up a lot.
#[doc(hidden)]
pub trait nsICertStorageCoerce {
    /// Cheaply cast a value of this type from a `nsICertStorage`.
    fn coerce_from(v: &nsICertStorage) -> &Self;
}

// The trivial implementation: We can obviously coerce ourselves to ourselves.
impl nsICertStorageCoerce for nsICertStorage {
    #[inline]
    fn coerce_from(v: &nsICertStorage) -> &Self {
        v
    }
}

impl nsICertStorage {
    /// Cast this `nsICertStorage` to one of its base interfaces.
    #[inline]
    pub fn coerce<T: nsICertStorageCoerce>(&self) -> &T {
        T::coerce_from(self)
    }
}

// Every interface struct type implements `Deref` to its base interface. This
// causes methods on the base interfaces to be directly avaliable on the
// object. For example, you can call `.AddRef` or `.QueryInterface` directly
// on any interface which inherits from `nsISupports`.
impl ::std::ops::Deref for nsICertStorage {
    type Target = nsISupports;
    #[inline]
    fn deref(&self) -> &nsISupports {
        unsafe {
            ::std::mem::transmute(self)
        }
    }
}

// Ensure we can use .coerce() to cast to our base types as well. Any type which
// our base interface can coerce from should be coercable from us as well.
impl<T: nsISupportsCoerce> nsICertStorageCoerce for T {
    #[inline]
    fn coerce_from(v: &nsICertStorage) -> &Self {
        T::coerce_from(v)
    }
}

// This struct represents the interface's VTable. A pointer to a statically
// allocated version of this struct is at the beginning of every nsICertStorage
// object. It contains one pointer field for each method in the interface. In
// the case where we can't generate a binding for a method, we include a void
// pointer.
#[doc(hidden)]
#[repr(C)]
pub struct nsICertStorageVTable {
    /// We need to include the members from the base interface's vtable at the start
    /// of the VTable definition.
    pub __base: nsISupportsVTable,

    /* [must_use] void hasPriorData (in octet type, in nsICertStorageCallback callback); */
    pub HasPriorData: unsafe extern "system" fn (this: *const nsICertStorage, type_: u8, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* [must_use] void setRevocations (in Array<nsIRevocationState> revocations, in nsICertStorageCallback callback); */
    pub SetRevocations: unsafe extern "system" fn (this: *const nsICertStorage, revocations: *const thin_vec::ThinVec<Option<RefPtr<nsIRevocationState>>>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* [must_use] short getRevocationState (in Array<octet> issuer, in Array<octet> serial, in Array<octet> subject, in Array<octet> pubkey); */
    pub GetRevocationState: unsafe extern "system" fn (this: *const nsICertStorage, issuer: *const thin_vec::ThinVec<u8>, serial: *const thin_vec::ThinVec<u8>, subject: *const thin_vec::ThinVec<u8>, pubkey: *const thin_vec::ThinVec<u8>, _retval: *mut i16) -> ::nserror::nsresult,

    /* [must_use] void setFullCRLiteFilter (in Array<octet> filter, in nsICertStorageCallback callback); */
    pub SetFullCRLiteFilter: unsafe extern "system" fn (this: *const nsICertStorage, filter: *const thin_vec::ThinVec<u8>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* [must_use,noscript] short getCRLiteRevocationState (in Array<octet> issuerSPKI, in Array<octet> serialNumber, in Array<nsICRLiteTimestamp> timestamps); */
    pub GetCRLiteRevocationState: unsafe extern "system" fn (this: *const nsICertStorage, issuerSPKI: *const thin_vec::ThinVec<u8>, serialNumber: *const thin_vec::ThinVec<u8>, timestamps: *const thin_vec::ThinVec<Option<RefPtr<nsICRLiteTimestamp>>>, _retval: *mut i16) -> ::nserror::nsresult,

    /* [must_use] void addCRLiteDelta (in Array<octet> delta, in ACString filename, in nsICertStorageCallback callback); */
    pub AddCRLiteDelta: unsafe extern "system" fn (this: *const nsICertStorage, delta: *const thin_vec::ThinVec<u8>, filename: *const ::nsstring::nsACString, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* [must_use] void testNoteCRLiteUpdateTime (in nsICertStorageCallback callback); */
    pub TestNoteCRLiteUpdateTime: unsafe extern "system" fn (this: *const nsICertStorage, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* [must_use] void addCerts (in Array<nsICertInfo> certs, in nsICertStorageCallback callback); */
    pub AddCerts: unsafe extern "system" fn (this: *const nsICertStorage, certs: *const thin_vec::ThinVec<Option<RefPtr<nsICertInfo>>>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* void TestHelperAddCert (in ACString cert, in ACString subject, in short trust); */
    pub TestHelperAddCert: unsafe extern "system" fn (this: *const nsICertStorage, cert: *const ::nsstring::nsACString, subject: *const ::nsstring::nsACString, trust: i16) -> ::nserror::nsresult,

    /* [must_use] void removeCertsByHashes (in Array<ACString> hashes, in nsICertStorageCallback callback); */
    pub RemoveCertsByHashes: unsafe extern "system" fn (this: *const nsICertStorage, hashes: *const thin_vec::ThinVec<::nsstring::nsCString>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult,

    /* [must_use] Array<Array<octet>> findCertsBySubject (in Array<octet> subject); */
    pub FindCertsBySubject: unsafe extern "system" fn (this: *const nsICertStorage, subject: *const thin_vec::ThinVec<u8>, _retval: *mut thin_vec::ThinVec<thin_vec::ThinVec<u8>>) -> ::nserror::nsresult,

    /* [must_use] boolean hasAllCertsByHash (in Array<Array<octet>> hashes); */
    pub HasAllCertsByHash: unsafe extern "system" fn (this: *const nsICertStorage, hashes: *const thin_vec::ThinVec<thin_vec::ThinVec<u8>>, _retval: *mut bool) -> ::nserror::nsresult,

    /* [must_use] Array<octet> findCertByHash (in Array<octet> cert_hash); */
    pub FindCertByHash: unsafe extern "system" fn (this: *const nsICertStorage, cert_hash: *const thin_vec::ThinVec<u8>, _retval: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult,

    /* [must_use] int32_t GetRemainingOperationCount (); */
    pub GetRemainingOperationCount: unsafe extern "system" fn (this: *const nsICertStorage, _retval: *mut i32) -> ::nserror::nsresult,
}


// The implementations of the function wrappers which are exposed to rust code.
// Call these methods rather than manually calling through the VTable struct.
impl nsICertStorage {

    pub const DATA_TYPE_REVOCATION: u8 = 1;


    pub const DATA_TYPE_CERTIFICATE: u8 = 2;


    pub const DATA_TYPE_CRLITE: u8 = 3;


    pub const DATA_TYPE_CRLITE_FILTER_FULL: u8 = 4;


    pub const DATA_TYPE_CRLITE_FILTER_INCREMENTAL: u8 = 5;


    pub const STATE_UNSET: i16 = 0;


    pub const STATE_ENFORCE: i16 = 1;


    pub const STATE_NOT_ENROLLED: i16 = 2;


    pub const STATE_NOT_COVERED: i16 = 3;


    pub const STATE_NO_FILTER: i16 = 4;

    /// ```text
    /// /**
    ///    * Trust flags to use when adding a adding a certificate.
    ///    * TRUST_INHERIT indicates a certificate inherits trust from another
    ///    * certificate.
    ///    * TRUST_ANCHOR indicates the certificate is a root of trust.
    ///    */
    /// ```
    ///

    pub const TRUST_INHERIT: i16 = 0;


    pub const TRUST_ANCHOR: i16 = 1;

    /// ```text
    /// /**
    ///    * Asynchronously check if the backing storage has stored data of the given
    ///    * type in the past. This is useful if the backing storage may have had to
    ///    * have been deleted and recreated (as in bug 1546361 when we discovered that
        ///    * moving from a 32-bit binary to a 64-bit binary caused the DB to become
        ///    * unreadable, thus necessitating its deletion and recreation).
    ///    */
    /// ```
    ///

    /// `[must_use] void hasPriorData (in octet type, in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn HasPriorData(&self, type_: u8, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).HasPriorData)(self, type_, callback)
    }


    /// ```text
    /// /**
    ///    * Asynchronously set the revocation states of a set of certificates.
    ///    * The given callback is called with the result of the operation when it
    ///    * completes.
    ///    * Must only be called from the main thread.
    ///    */
    /// ```
    ///

    /// `[must_use] void setRevocations (in Array<nsIRevocationState> revocations, in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn SetRevocations(&self, revocations: *const thin_vec::ThinVec<Option<RefPtr<nsIRevocationState>>>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).SetRevocations)(self, revocations, callback)
    }


    /// ```text
    /// /**
    ///    * Get the revocation state of a certificate. STATE_UNSET indicates the
    ///    * certificate is not revoked. STATE_ENFORCE indicates the certificate is
    ///    * revoked.
    ///    * issuer - issuer name, DER encoded
    ///    * serial - serial number, DER encoded
    ///    * subject - subject name, DER encoded
    ///    * pubkey - public key, DER encoded
    ///    * In gecko, must not be called from the main thread. See bug 1541212.
    ///    * xpcshell tests may call this from the main thread.
    ///    */
    /// ```
    ///

    /// `[must_use] short getRevocationState (in Array<octet> issuer, in Array<octet> serial, in Array<octet> subject, in Array<octet> pubkey);`
    #[inline]
    pub unsafe fn GetRevocationState(&self, issuer: *const thin_vec::ThinVec<u8>, serial: *const thin_vec::ThinVec<u8>, subject: *const thin_vec::ThinVec<u8>, pubkey: *const thin_vec::ThinVec<u8>, _retval: *mut i16) -> ::nserror::nsresult {
        ((*self.vtable).GetRevocationState)(self, issuer, serial, subject, pubkey, _retval)
    }


    /// ```text
    /// /**
    ///    * Given the contents of a new CRLite filter, replaces any existing filter
    ///    * with the new one. Also clears any previously-set incremental revocation
    ///    * updates ("deltas").
    ///    */
    /// ```
    ///

    /// `[must_use] void setFullCRLiteFilter (in Array<octet> filter, in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn SetFullCRLiteFilter(&self, filter: *const thin_vec::ThinVec<u8>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).SetFullCRLiteFilter)(self, filter, callback)
    }


    /// ```text
    /// /**
    ///    * Given the DER-encoded issuer subject public key info, the bytes of the
    ///    * value of the serial number (so, not including the DER tag and length) of a
    ///    * certificate, and the timestamps from that certificate's embedded SCTs,
    ///    * returns the result of looking up the corresponding entry in the
    ///    * currently-saved CRLite filter (if any).
    ///    * Returns
    ///    *    - STATE_ENFORCE if the lookup indicates the certificate is revoked via CRLite,
    ///    *    - STATE_UNSET if the lookup indicates the certificate is not revoked via CRLite,
    ///    *    - STATE_NOT_ENROLLED if the issuer is not enrolled in CRLite, or
    ///    *    - STATE_NOT_COVERED if the issuer is enrolled but the provided timestamps indicate
    ///    *      that the serial number is not covered by the current CRLite filter.
    ///    *    - STATE_NO_FILTER if there is no (usable) CRLite filter.
    ///    * No lookup is performed in the STATE_NOT_ENROLLED and STATE_NOT_COVERED cases.
    ///    */
    /// ```
    ///

    /// `[must_use,noscript] short getCRLiteRevocationState (in Array<octet> issuerSPKI, in Array<octet> serialNumber, in Array<nsICRLiteTimestamp> timestamps);`
    #[inline]
    pub unsafe fn GetCRLiteRevocationState(&self, issuerSPKI: *const thin_vec::ThinVec<u8>, serialNumber: *const thin_vec::ThinVec<u8>, timestamps: *const thin_vec::ThinVec<Option<RefPtr<nsICRLiteTimestamp>>>, _retval: *mut i16) -> ::nserror::nsresult {
        ((*self.vtable).GetCRLiteRevocationState)(self, issuerSPKI, serialNumber, timestamps, _retval)
    }


    /// ```text
    /// /**
    ///    * Add a new CRLite filter for consideration in revocation checks. This
    ///    * filter is treated as a delta update to the current full filter. Calling
    ///    * this function will not remove the existing full filter, stashes, or delta
    ///    * updates. A copy of the new filter will be written to the user's
    ///    * security_state directory with the given filename.
    ///    */
    /// ```
    ///

    /// `[must_use] void addCRLiteDelta (in Array<octet> delta, in ACString filename, in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn AddCRLiteDelta(&self, delta: *const thin_vec::ThinVec<u8>, filename: *const ::nsstring::nsACString, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).AddCRLiteDelta)(self, delta, filename, callback)
    }


    /// ```text
    /// /**
    ///    * Mark CRLite filters as fresh. For use in tests only.
    ///    */
    /// ```
    ///

    /// `[must_use] void testNoteCRLiteUpdateTime (in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn TestNoteCRLiteUpdateTime(&self, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).TestNoteCRLiteUpdateTime)(self, callback)
    }


    /// ```text
    /// /**
    ///    * Asynchronously add a list of certificates to the backing storage.
    ///    * See the documentation for nsICertInfo.
    ///    * The given callback is called with the result of the operation when it
    ///    * completes.
    ///    * Must only be called from the main thread.
    ///    */
    /// ```
    ///

    /// `[must_use] void addCerts (in Array<nsICertInfo> certs, in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn AddCerts(&self, certs: *const thin_vec::ThinVec<Option<RefPtr<nsICertInfo>>>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).AddCerts)(self, certs, callback)
    }


    /// ```text
    /// /**
    ///    * Synchronously add a certificate to the backing storage.
    ///    * See the documentation for nsICertInfo.
    ///    * This is a helper which should only be called from tests.
    ///    */
    /// ```
    ///

    /// `void TestHelperAddCert (in ACString cert, in ACString subject, in short trust);`
    #[inline]
    pub unsafe fn TestHelperAddCert(&self, cert: *const ::nsstring::nsACString, subject: *const ::nsstring::nsACString, trust: i16) -> ::nserror::nsresult {
        ((*self.vtable).TestHelperAddCert)(self, cert, subject, trust)
    }


    /// ```text
    /// /**
    ///    * Asynchronously remove the certificates with the given sha-256 hashes from
    ///    * the backing storage.
    ///    * hashes is an array of base64-encoded bytes of the sha-256 hashes of each
    ///    * certificate's bytes (DER-encoded).
    ///    * The given callback is called with the result of the operation when it
    ///    * completes.
    ///    * Must only be called from the main thread.
    ///    */
    /// ```
    ///

    /// `[must_use] void removeCertsByHashes (in Array<ACString> hashes, in nsICertStorageCallback callback);`
    #[inline]
    pub unsafe fn RemoveCertsByHashes(&self, hashes: *const thin_vec::ThinVec<::nsstring::nsCString>, callback: *const nsICertStorageCallback) -> ::nserror::nsresult {
        ((*self.vtable).RemoveCertsByHashes)(self, hashes, callback)
    }


    /// ```text
    /// /**
    ///    * Find all certificates in the backing storage with the given subject
    ///    * distinguished name.
    ///    * subject is the DER-encoded bytes of the subject distinguished name.
    ///    * Returns an array of arrays of bytes, where each inner array corresponds to
    ///    * the DER-encoded bytes of a certificate that has the given subject (although
        ///    * as these certificates were presumably added via addCertBySubject, this
        ///    * aspect is never actually valided by nsICertStorage).
    ///    * Must not be called from the main thread. See bug 1541212.
    ///    */
    /// ```
    ///

    /// `[must_use] Array<Array<octet>> findCertsBySubject (in Array<octet> subject);`
    #[inline]
    pub unsafe fn FindCertsBySubject(&self, subject: *const thin_vec::ThinVec<u8>, _retval: *mut thin_vec::ThinVec<thin_vec::ThinVec<u8>>) -> ::nserror::nsresult {
        ((*self.vtable).FindCertsBySubject)(self, subject, _retval)
    }


    /// ```text
    /// /**
    ///    * Check for presence of all certificates in backing storage identified
    ///    * by the list of hashes. Returns true or false accordingly.
    ///    * Must not be called from the main thread. See bug 1541212.
    ///    */
    /// ```
    ///

    /// `[must_use] boolean hasAllCertsByHash (in Array<Array<octet>> hashes);`
    #[inline]
    pub unsafe fn HasAllCertsByHash(&self, hashes: *const thin_vec::ThinVec<thin_vec::ThinVec<u8>>, _retval: *mut bool) -> ::nserror::nsresult {
        ((*self.vtable).HasAllCertsByHash)(self, hashes, _retval)
    }


    /// ```text
    /// /**
    ///    * Finds a certificate in backing storage, identified by SHA256 of the
    ///    * DER-encoded bytes of the certificate. Returns an array of bytes
    ///    * representing the DER-encoded bytes of the certificate.
    ///    * Must not be called from the main thread. See bug 1541212.
    ///    */
    /// ```
    ///

    /// `[must_use] Array<octet> findCertByHash (in Array<octet> cert_hash);`
    #[inline]
    pub unsafe fn FindCertByHash(&self, cert_hash: *const thin_vec::ThinVec<u8>, _retval: *mut thin_vec::ThinVec<u8>) -> ::nserror::nsresult {
        ((*self.vtable).FindCertByHash)(self, cert_hash, _retval)
    }


    /// ```text
    /// /**
    ///    * Get the count of remaining async operations. Called to ensure we don't skip
    ///    * or interrupt any operations during fast shutdown.
    ///    * Must only be called from the main thread.
    ///    */
    /// ```
    ///

    /// `[must_use] int32_t GetRemainingOperationCount ();`
    #[inline]
    pub unsafe fn GetRemainingOperationCount(&self, _retval: *mut i32) -> ::nserror::nsresult {
        ((*self.vtable).GetRemainingOperationCount)(self, _retval)
    }


}


